; Based on CPU DB MC9S12UF32_100, version 2.87.1370 (RegistersPrg V2.28)

; ###################################################################
;     Filename  : mc9s12uf32.inc
;     Processor : MC9S12UF32PU
;     FileFormat: V2.28
;     DataSheet : 9S12UF32SOCGuide/D V01.00
;     Compiler  : CodeWarrior compiler
;     Date/Time : 2.7.2009, 8:42
;     Abstract  :
;         This header implements the mapping of I/O devices.
;
;     Copyright : 1997 - 2009 Freescale Semiconductor, Inc. All Rights Reserved.
;     
;     http      : www.freescale.com
;     mail      : support@freescale.com
;
;     CPU Registers Revisions:
;      - 13.09.2006, V2.87.1361:
;              - Renamed bits IREN_Hi ==> IREN, TNPx_Hi ==> TNPx. REASON: Bug-fix (#3552 in Issue Manager)
;
;     File-Format-Revisions:
;      - 14.11.2005, V2.00 :
;               - Deprecated symbols added for backward compatibility (section at the end of this file)
;      - 15.11.2005, V2.01 :
;               - Fixed invalid instruction in macro __RESET_WATCHDOG for HCS12 family.
;      - 17.12.2005, V2.02 :
;               - Arrays (symbols xx_ARR) are defined as pointer to volatile, see issue #2778
;      - 16.01.2006, V2.03 :
;               - Fixed declaration of non volatile registers. Now it does not require (but allows) their initialization, see issue #2920.
;               - "volatile" modifier removed from declaration of non volatile registers (that contain modifier "const")
;      - 08.03.2006, V2.04 :
;               - Support for bit(s) names duplicated with any register name in .h header files
;      - 24.03.2006, V2.05 :
;               - Fixed macro __RESET_WATCHDOG for HCS12 family - address and correct write order.
;      - 26.04.2006, V2.06 :
;               - Changes have not affected this file (because they are related to another family)
;      - 27.04.2006, V2.07 :
;               - Fixed macro __RESET_WATCHDOG for HCS12, HCS12X ,HCS08 DZ and HCS08 EN derivatives (write 0x55,0xAA).
;      - 07.06.2006, V2.08 :
;               - Changes have not affected this file (because they are related to another family)
;      - 03.07.2006, V2.09 :
;               - Changes have not affected this file (because they are related to another family)
;      - 27.10.2006, V2.10 :
;               - __RESET_WATCHDOG improved formating and re-definition
;      - 23.11.2006, V2.11 :
;               - Changes have not affected this file (because they are related to another family)
;      - 22.01.2007, V2.12 :
;               - Fixed declaration of non volatile registers. Now it does not require (but allows) their initialization, see issue #4086.
;      - 01.03.2007, V2.13 :
;               - Flash commands constants values converted to HEX format
;      - 02.03.2007, V2.14 :
;               - Interrupt vector numbers added into .H, see VectorNumber_*
;      - 26.03.2007, V2.15 :
;               - Changes have not affected this file (because they are related to another family)
;      - 10.05.2007, V2.16 :
;               - Changes have not affected this file (because they are related to another family)
;      - 05.06.2007, V2.17 :
;               - Changes have not affected this file (because they are related to another family)
;      - 19.07.2007, V2.18 :
;               - Improved number of blanked lines inside register structures
;      - 06.08.2007, V2.19 :
;               - CPUDB revisions generated ahead of the file-format revisions.
;      - 11.09.2007, V2.20 :
;               - Added comment about initialization of unbonded pins.
;      - 02.01.2008, V2.21 :
;               - Changes have not affected this file (because they are related to another family)
;      - 13.02.2008, V2.22 :
;               - Changes have not affected this file (because they are related to another family)
;      - 20.02.2008, V2.23 :
;               - Termination of pragma V30toV31Compatible added, #5708
;      - 03.07.2008, V2.24 :
;               - Added support for bits with name starting with number (like "1HZ")
;      - 28.11.2008, V2.25 :
;               - StandBy RAM array declaration for ANSI-C added
;      - 1.12.2008, V2.26 :
;               - Duplication of bit (or bit-group) name with register name is not marked as a problem, is register is internal only and it is not displayed in I/O map.
;      - 17.3.2009, V2.27 :
;               - Merged bit-group is not generated, if the name matches with another bit name in the register
;      - 6.4.2009, V2.28 :
;               - Fixed generation of merged bits for bit-groups with a digit at the end, if group-name is defined in CPUDB
;
;     Not all general-purpose I/O pins are available on all packages or on all mask sets of a specific
;     derivative device. To avoid extra current drain from floating input pins, the users reset
;     initialization routine in the application program must either enable on-chip pull-up devices
;     or change the direction of unconnected pins to outputs so the pins do not float.
; ###################################################################

;*** Memory Map and Interrupt Vectors
;******************************************
RAMStart:           equ   $00001200
RAMEnd:             equ   $00001FFF
ROM_4000Start:      equ   $00004000
ROM_4000End:        equ   $00007FFF
ROM_C000Start:      equ   $0000C000
ROM_C000End:        equ   $0000FEFF
;
VReserved63:        equ   $0000FF80
Vsmhcs:             equ   $0000FF82
Vsmhce:             equ   $0000FF84
Vsdhc:              equ   $0000FF86
Vmshc:              equ   $0000FF88
Vcfireqhc:          equ   $0000FF8A
Vcfsfthc:           equ   $0000FF8C
Vata5hc:            equ   $0000FF8E
VReserved55:        equ   $0000FF90
VReserved54:        equ   $0000FF92
Viquech34dbtc:      equ   $0000FF94
Viquech34dbe:       equ   $0000FF96
Viquech34dbf:       equ   $0000FF98
Viquech12dbtc:      equ   $0000FF9A
Viquech12dbe:       equ   $0000FF9C
Viquech12dbf:       equ   $0000FF9E
Viquech4v:          equ   $0000FFA0
Viquech4e:          equ   $0000FFA2
Viquech4f:          equ   $0000FFA4
Viquech3v:          equ   $0000FFA6
Viquech3e:          equ   $0000FFA8
Viquech3f:          equ   $0000FFAA
Viquech2v:          equ   $0000FFAC
Viquech2e:          equ   $0000FFAE
Viquech2f:          equ   $0000FFB0
Viquech1v:          equ   $0000FFB2
Viquech1e:          equ   $0000FFB4
Viquech1f:          equ   $0000FFB6
Vflash:             equ   $0000FFB8
VReserved34:        equ   $0000FFBA
VReserved33:        equ   $0000FFBC
Vusbsof:            equ   $0000FFBE
Vusbe6:             equ   $0000FFC0
Vusbe5:             equ   $0000FFC2
Vusbe4:             equ   $0000FFC4
Vcrgplllck:         equ   $0000FFC6
Vusbe3:             equ   $0000FFC8
Vusbe2:             equ   $0000FFCA
Vusbe0o:            equ   $0000FFCC
Vusbe0i:            equ   $0000FFCE
Vusbsecrr:          equ   $0000FFD0
Vusbscr:            equ   $0000FFD2
Vusbsc:             equ   $0000FFD4
Vsci:               equ   $0000FFD6
VReserved19:        equ   $0000FFD8
Vtimpaie:           equ   $0000FFDA
Vtimpaovf:          equ   $0000FFDC
Vtimovf:            equ   $0000FFDE
Vtimch7:            equ   $0000FFE0
Vtimch6:            equ   $0000FFE2
Vtimch5:            equ   $0000FFE4
Vtimch4:            equ   $0000FFE6
Vtimch3:            equ   $0000FFE8
Vtimch2:            equ   $0000FFEA
Vtimch1:            equ   $0000FFEC
Vtimch0:            equ   $0000FFEE
Vrti:               equ   $0000FFF0
Virq:               equ   $0000FFF2
Vxirq:              equ   $0000FFF4
Vswi:               equ   $0000FFF6
Vtrap:              equ   $0000FFF8
Vcop:               equ   $0000FFFA
VReserved1:         equ   $0000FFFC
Vreset:             equ   $0000FFFE
;


;*** PORTAB - Port AB Register; 0x00000000 ***
PORTAB:             equ    $00000000                                ;*** PORTAB - Port AB Register; 0x00000000 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PORTAB_BIT0:        equ    0                                         ; Port AB Bit 0
PORTAB_BIT1:        equ    1                                         ; Port AB Bit 1
PORTAB_BIT2:        equ    2                                         ; Port AB Bit 2
PORTAB_BIT3:        equ    3                                         ; Port AB Bit 3
PORTAB_BIT4:        equ    4                                         ; Port AB Bit 4
PORTAB_BIT5:        equ    5                                         ; Port AB Bit 5
PORTAB_BIT6:        equ    6                                         ; Port AB Bit 6
PORTAB_BIT7:        equ    7                                         ; Port AB Bit 7
PORTAB_BIT8:        equ    8                                         ; Port AB Bit 8
PORTAB_BIT9:        equ    9                                         ; Port AB Bit 9
PORTAB_BIT10:       equ    10                                        ; Port AB Bit 10
PORTAB_BIT11:       equ    11                                        ; Port AB Bit 11
PORTAB_BIT12:       equ    12                                        ; Port AB Bit 12
PORTAB_BIT13:       equ    13                                        ; Port AB Bit 13
PORTAB_BIT14:       equ    14                                        ; Port AB Bit 14
PORTAB_BIT15:       equ    15                                        ; Port AB Bit 15
; bit position masks
mPORTAB_BIT0:       equ    %00000001
mPORTAB_BIT1:       equ    %00000010
mPORTAB_BIT2:       equ    %00000100
mPORTAB_BIT3:       equ    %00001000
mPORTAB_BIT4:       equ    %00010000
mPORTAB_BIT5:       equ    %00100000
mPORTAB_BIT6:       equ    %01000000
mPORTAB_BIT7:       equ    %10000000
mPORTAB_BIT8:       equ    %100000000
mPORTAB_BIT9:       equ    %1000000000
mPORTAB_BIT10:      equ    %10000000000
mPORTAB_BIT11:      equ    %100000000000
mPORTAB_BIT12:      equ    %1000000000000
mPORTAB_BIT13:      equ    %10000000000000
mPORTAB_BIT14:      equ    %100000000000000
mPORTAB_BIT15:      equ    %1000000000000000


;*** PORTA - Port A Register; 0x00000000 ***
PORTA:              equ    $00000000                                ;*** PORTA - Port A Register; 0x00000000 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PORTA_BIT0:         equ    0                                         ; Port A Bit 0
PORTA_BIT1:         equ    1                                         ; Port A Bit 1
PORTA_BIT2:         equ    2                                         ; Port A Bit 2
PORTA_BIT3:         equ    3                                         ; Port A Bit 3
PORTA_BIT4:         equ    4                                         ; Port A Bit 4
PORTA_BIT5:         equ    5                                         ; Port A Bit 5
PORTA_BIT6:         equ    6                                         ; Port A Bit 6
PORTA_BIT7:         equ    7                                         ; Port A Bit 7
; bit position masks
mPORTA_BIT0:        equ    %00000001
mPORTA_BIT1:        equ    %00000010
mPORTA_BIT2:        equ    %00000100
mPORTA_BIT3:        equ    %00001000
mPORTA_BIT4:        equ    %00010000
mPORTA_BIT5:        equ    %00100000
mPORTA_BIT6:        equ    %01000000
mPORTA_BIT7:        equ    %10000000


;*** PORTB - Port B Register; 0x00000001 ***
PORTB:              equ    $00000001                                ;*** PORTB - Port B Register; 0x00000001 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PORTB_BIT0:         equ    0                                         ; Port B Bit 0
PORTB_BIT1:         equ    1                                         ; Port B Bit 1
PORTB_BIT2:         equ    2                                         ; Port B Bit 2
PORTB_BIT3:         equ    3                                         ; Port B Bit 3
PORTB_BIT4:         equ    4                                         ; Port B Bit 4
PORTB_BIT5:         equ    5                                         ; Port B Bit 5
PORTB_BIT6:         equ    6                                         ; Port B Bit 6
PORTB_BIT7:         equ    7                                         ; Port B Bit 7
; bit position masks
mPORTB_BIT0:        equ    %00000001
mPORTB_BIT1:        equ    %00000010
mPORTB_BIT2:        equ    %00000100
mPORTB_BIT3:        equ    %00001000
mPORTB_BIT4:        equ    %00010000
mPORTB_BIT5:        equ    %00100000
mPORTB_BIT6:        equ    %01000000
mPORTB_BIT7:        equ    %10000000


;*** DDRAB - Port AB Data Direction Register; 0x00000002 ***
DDRAB:              equ    $00000002                                ;*** DDRAB - Port AB Data Direction Register; 0x00000002 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRAB_BIT0:         equ    0                                         ; Data Direction Port AB Bit 0
DDRAB_BIT1:         equ    1                                         ; Data Direction Port AB Bit 1
DDRAB_BIT2:         equ    2                                         ; Data Direction Port AB Bit 2
DDRAB_BIT3:         equ    3                                         ; Data Direction Port AB Bit 3
DDRAB_BIT4:         equ    4                                         ; Data Direction Port AB Bit 4
DDRAB_BIT5:         equ    5                                         ; Data Direction Port AB Bit 5
DDRAB_BIT6:         equ    6                                         ; Data Direction Port AB Bit 6
DDRAB_BIT7:         equ    7                                         ; Data Direction Port AB Bit 7
DDRAB_BIT8:         equ    8                                         ; Data Direction Port AB Bit 8
DDRAB_BIT9:         equ    9                                         ; Data Direction Port AB Bit 9
DDRAB_BIT10:        equ    10                                        ; Data Direction Port AB Bit 10
DDRAB_BIT11:        equ    11                                        ; Data Direction Port AB Bit 11
DDRAB_BIT12:        equ    12                                        ; Data Direction Port AB Bit 12
DDRAB_BIT13:        equ    13                                        ; Data Direction Port AB Bit 13
DDRAB_BIT14:        equ    14                                        ; Data Direction Port AB Bit 14
DDRAB_BIT15:        equ    15                                        ; Data Direction Port AB Bit 15
; bit position masks
mDDRAB_BIT0:        equ    %00000001
mDDRAB_BIT1:        equ    %00000010
mDDRAB_BIT2:        equ    %00000100
mDDRAB_BIT3:        equ    %00001000
mDDRAB_BIT4:        equ    %00010000
mDDRAB_BIT5:        equ    %00100000
mDDRAB_BIT6:        equ    %01000000
mDDRAB_BIT7:        equ    %10000000
mDDRAB_BIT8:        equ    %100000000
mDDRAB_BIT9:        equ    %1000000000
mDDRAB_BIT10:       equ    %10000000000
mDDRAB_BIT11:       equ    %100000000000
mDDRAB_BIT12:       equ    %1000000000000
mDDRAB_BIT13:       equ    %10000000000000
mDDRAB_BIT14:       equ    %100000000000000
mDDRAB_BIT15:       equ    %1000000000000000


;*** DDRA - Port A Data Direction Register; 0x00000002 ***
DDRA:               equ    $00000002                                ;*** DDRA - Port A Data Direction Register; 0x00000002 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRA_BIT0:          equ    0                                         ; Data Direction Port A Bit 0
DDRA_BIT1:          equ    1                                         ; Data Direction Port A Bit 1
DDRA_BIT2:          equ    2                                         ; Data Direction Port A Bit 2
DDRA_BIT3:          equ    3                                         ; Data Direction Port A Bit 3
DDRA_BIT4:          equ    4                                         ; Data Direction Port A Bit 4
DDRA_BIT5:          equ    5                                         ; Data Direction Port A Bit 5
DDRA_BIT6:          equ    6                                         ; Data Direction Port A Bit 6
DDRA_BIT7:          equ    7                                         ; Data Direction Port A Bit 7
; bit position masks
mDDRA_BIT0:         equ    %00000001
mDDRA_BIT1:         equ    %00000010
mDDRA_BIT2:         equ    %00000100
mDDRA_BIT3:         equ    %00001000
mDDRA_BIT4:         equ    %00010000
mDDRA_BIT5:         equ    %00100000
mDDRA_BIT6:         equ    %01000000
mDDRA_BIT7:         equ    %10000000


;*** DDRB - Port B Data Direction Register; 0x00000003 ***
DDRB:               equ    $00000003                                ;*** DDRB - Port B Data Direction Register; 0x00000003 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRB_BIT0:          equ    0                                         ; Data Direction Port B Bit 0
DDRB_BIT1:          equ    1                                         ; Data Direction Port B Bit 1
DDRB_BIT2:          equ    2                                         ; Data Direction Port B Bit 2
DDRB_BIT3:          equ    3                                         ; Data Direction Port B Bit 3
DDRB_BIT4:          equ    4                                         ; Data Direction Port B Bit 4
DDRB_BIT5:          equ    5                                         ; Data Direction Port B Bit 5
DDRB_BIT6:          equ    6                                         ; Data Direction Port B Bit 6
DDRB_BIT7:          equ    7                                         ; Data Direction Port B Bit 7
; bit position masks
mDDRB_BIT0:         equ    %00000001
mDDRB_BIT1:         equ    %00000010
mDDRB_BIT2:         equ    %00000100
mDDRB_BIT3:         equ    %00001000
mDDRB_BIT4:         equ    %00010000
mDDRB_BIT5:         equ    %00100000
mDDRB_BIT6:         equ    %01000000
mDDRB_BIT7:         equ    %10000000


;*** PORTE - Port E Register; 0x00000008 ***
PORTE:              equ    $00000008                                ;*** PORTE - Port E Register; 0x00000008 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PORTE_BIT0:         equ    0                                         ; Port E Bit 0
PORTE_BIT1:         equ    1                                         ; Port E Bit 1
PORTE_BIT2:         equ    2                                         ; Port E Bit 2
PORTE_BIT3:         equ    3                                         ; Port E Bit 3
PORTE_BIT4:         equ    4                                         ; Port E Bit 4
PORTE_BIT5:         equ    5                                         ; Port E Bit 5
PORTE_BIT6:         equ    6                                         ; Port E Bit 6
PORTE_BIT7:         equ    7                                         ; Port E Bit 7
; bit position masks
mPORTE_BIT0:        equ    %00000001
mPORTE_BIT1:        equ    %00000010
mPORTE_BIT2:        equ    %00000100
mPORTE_BIT3:        equ    %00001000
mPORTE_BIT4:        equ    %00010000
mPORTE_BIT5:        equ    %00100000
mPORTE_BIT6:        equ    %01000000
mPORTE_BIT7:        equ    %10000000


;*** DDRE - Port E Data Direction Register; 0x00000009 ***
DDRE:               equ    $00000009                                ;*** DDRE - Port E Data Direction Register; 0x00000009 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRE_BIT2:          equ    2                                         ; Data Direction Port E Bit 2
DDRE_BIT3:          equ    3                                         ; Data Direction Port E Bit 3
DDRE_BIT4:          equ    4                                         ; Data Direction Port E Bit 4
DDRE_BIT5:          equ    5                                         ; Data Direction Port E Bit 5
DDRE_BIT6:          equ    6                                         ; Data Direction Port E Bit 6
DDRE_BIT7:          equ    7                                         ; Data Direction Port E Bit 7
; bit position masks
mDDRE_BIT2:         equ    %00000100
mDDRE_BIT3:         equ    %00001000
mDDRE_BIT4:         equ    %00010000
mDDRE_BIT5:         equ    %00100000
mDDRE_BIT6:         equ    %01000000
mDDRE_BIT7:         equ    %10000000


;*** PEAR - Port E Assignment Register; 0x0000000A ***
PEAR:               equ    $0000000A                                ;*** PEAR - Port E Assignment Register; 0x0000000A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PEAR_RDWE:          equ    2                                         ; Read / Write Enable
PEAR_LSTRE:         equ    3                                         ; Low Strobe (LSTRB) Enable
PEAR_NECLK:         equ    4                                         ; No External E Clock
PEAR_PIPOE:         equ    5                                         ; Pipe Status Signal Output Enable
PEAR_NOACCE:        equ    7                                         ; CPU No Access Output Enable
; bit position masks
mPEAR_RDWE:         equ    %00000100
mPEAR_LSTRE:        equ    %00001000
mPEAR_NECLK:        equ    %00010000
mPEAR_PIPOE:        equ    %00100000
mPEAR_NOACCE:       equ    %10000000


;*** MODE - Mode Register; 0x0000000B ***
MODE:               equ    $0000000B                                ;*** MODE - Mode Register; 0x0000000B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MODE_EME:           equ    0                                         ; Emulate Port E
MODE_EMK:           equ    1                                         ; Emulate Port K
MODE_IVIS:          equ    3                                         ; Internal Visibility
MODE_MODA:          equ    5                                         ; Mode Select Bit A
MODE_MODB:          equ    6                                         ; Mode Select Bit B
MODE_MODC:          equ    7                                         ; Mode Select Bit C
; bit position masks
mMODE_EME:          equ    %00000001
mMODE_EMK:          equ    %00000010
mMODE_IVIS:         equ    %00001000
mMODE_MODA:         equ    %00100000
mMODE_MODB:         equ    %01000000
mMODE_MODC:         equ    %10000000


;*** PUCR - Pull-Up Control Register; 0x0000000C ***
PUCR:               equ    $0000000C                                ;*** PUCR - Pull-Up Control Register; 0x0000000C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PUCR_PUPAE:         equ    0                                         ; Pull-Up Port A Enable
PUCR_PUPBE:         equ    1                                         ; Pull-Up Port B Enable
PUCR_PUPEE:         equ    4                                         ; Pull-Up Port E Enable
PUCR_PUPKE:         equ    7                                         ; Pull-Up Port K Enable
; bit position masks
mPUCR_PUPAE:        equ    %00000001
mPUCR_PUPBE:        equ    %00000010
mPUCR_PUPEE:        equ    %00010000
mPUCR_PUPKE:        equ    %10000000


;*** RDRIV - Reduced Drive of I/O Lines; 0x0000000D ***
RDRIV:              equ    $0000000D                                ;*** RDRIV - Reduced Drive of I/O Lines; 0x0000000D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RDRIV_RDPA:         equ    0                                         ; Reduced Drive of Port A
RDRIV_RDPB:         equ    1                                         ; Reduced Drive of Port B
RDRIV_RDPE:         equ    4                                         ; Reduced Drive of Port E
RDRIV_RDPK:         equ    7                                         ; Reduced Drive of Port K
; bit position masks
mRDRIV_RDPA:        equ    %00000001
mRDRIV_RDPB:        equ    %00000010
mRDRIV_RDPE:        equ    %00010000
mRDRIV_RDPK:        equ    %10000000


;*** EBICTL - External Bus Interface Control; 0x0000000E ***
EBICTL:             equ    $0000000E                                ;*** EBICTL - External Bus Interface Control; 0x0000000E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
EBICTL_ESTR:        equ    0                                         ; E Stretches
; bit position masks
mEBICTL_ESTR:       equ    %00000001


;*** INITRM - Initialization of Internal RAM Position Register; 0x00000010 ***
INITRM:             equ    $00000010                                ;*** INITRM - Initialization of Internal RAM Position Register; 0x00000010 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
INITRM_RAMHAL:      equ    0                                         ; Internal RAM map alignment
INITRM_RAM11:       equ    3                                         ; Internal RAM Map Position Bit 11
INITRM_RAM12:       equ    4                                         ; Internal RAM Map Position Bit 12
INITRM_RAM13:       equ    5                                         ; Internal RAM Map Position Bit 13
INITRM_RAM14:       equ    6                                         ; Internal RAM Map Position Bit 14
INITRM_RAM15:       equ    7                                         ; Internal RAM Map Position Bit 15
; bit position masks
mINITRM_RAMHAL:     equ    %00000001
mINITRM_RAM11:      equ    %00001000
mINITRM_RAM12:      equ    %00010000
mINITRM_RAM13:      equ    %00100000
mINITRM_RAM14:      equ    %01000000
mINITRM_RAM15:      equ    %10000000


;*** INITRG - Initialization of Internal Registers Position Register; 0x00000011 ***
INITRG:             equ    $00000011                                ;*** INITRG - Initialization of Internal Registers Position Register; 0x00000011 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
INITRG_REG11:       equ    3                                         ; Internal Registers Map Position  Bit 11
INITRG_REG12:       equ    4                                         ; Internal Registers Map Position Bit 12
INITRG_REG13:       equ    5                                         ; Internal Registers Map Position Bit 13
INITRG_REG14:       equ    6                                         ; Internal Registers Map Position Bit 14
; bit position masks
mINITRG_REG11:      equ    %00001000
mINITRG_REG12:      equ    %00010000
mINITRG_REG13:      equ    %00100000
mINITRG_REG14:      equ    %01000000


;*** INITEE - Initialization of Internal EEPROM Position Register; 0x00000012 ***
INITEE:             equ    $00000012                                ;*** INITEE - Initialization of Internal EEPROM Position Register; 0x00000012 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
INITEE_EEON:        equ    0                                         ; Enable EEPROM
INITEE_EE11:        equ    3                                         ; Internal EEPROM map position Bit 0
INITEE_EE12:        equ    4                                         ; Internal EEPROM map position Bit 1
INITEE_EE13:        equ    5                                         ; Internal EEPROM map position Bit 2
INITEE_EE14:        equ    6                                         ; Internal EEPROM map position Bit 3
INITEE_EE15:        equ    7                                         ; Internal EEPROM map position Bit 4
; bit position masks
mINITEE_EEON:       equ    %00000001
mINITEE_EE11:       equ    %00001000
mINITEE_EE12:       equ    %00010000
mINITEE_EE13:       equ    %00100000
mINITEE_EE14:       equ    %01000000
mINITEE_EE15:       equ    %10000000


;*** MISC - Miscellaneous System Control Register; 0x00000013 ***
MISC:               equ    $00000013                                ;*** MISC - Miscellaneous System Control Register; 0x00000013 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MISC_ROMON:         equ    0                                         ; Enable Flash EEPROM or ROM
MISC_ROMHM:         equ    1                                         ; Flash EEPROM or ROM only in second half of memory map
MISC_EXSTR0:        equ    2                                         ; External Access Stretch Bit 0
MISC_EXSTR1:        equ    3                                         ; External Access Stretch Bit 1
; bit position masks
mMISC_ROMON:        equ    %00000001
mMISC_ROMHM:        equ    %00000010
mMISC_EXSTR0:       equ    %00000100
mMISC_EXSTR1:       equ    %00001000


;*** ITCR - Interrupt Test Control Register; 0x00000015 ***
ITCR:               equ    $00000015                                ;*** ITCR - Interrupt Test Control Register; 0x00000015 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ITCR_ADR0:          equ    0                                         ; Test register select bit 0
ITCR_ADR1:          equ    1                                         ; Test register select bit 1
ITCR_ADR2:          equ    2                                         ; Test register select bit 2
ITCR_ADR3:          equ    3                                         ; Test register select bit 3
ITCR_WRTINT:        equ    4                                         ; Write to the Interrupt Test Registers
; bit position masks
mITCR_ADR0:         equ    %00000001
mITCR_ADR1:         equ    %00000010
mITCR_ADR2:         equ    %00000100
mITCR_ADR3:         equ    %00001000
mITCR_WRTINT:       equ    %00010000


;*** ITEST - Interrupt Test Register; 0x00000016 ***
ITEST:              equ    $00000016                                ;*** ITEST - Interrupt Test Register; 0x00000016 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ITEST_INT0:         equ    0                                         ; Interrupt TEST bit 0
ITEST_INT2:         equ    1                                         ; Interrupt TEST bit 2
ITEST_INT4:         equ    2                                         ; Interrupt TEST bit 4
ITEST_INT6:         equ    3                                         ; Interrupt TEST bit 6
ITEST_INT8:         equ    4                                         ; Interrupt TEST bit 8
ITEST_INTA:         equ    5                                         ; Interrupt TEST bit A
ITEST_INTC:         equ    6                                         ; Interrupt TEST bit C
ITEST_INTE:         equ    7                                         ; Interrupt TEST bit E
; bit position masks
mITEST_INT0:        equ    %00000001
mITEST_INT2:        equ    %00000010
mITEST_INT4:        equ    %00000100
mITEST_INT6:        equ    %00001000
mITEST_INT8:        equ    %00010000
mITEST_INTA:        equ    %00100000
mITEST_INTC:        equ    %01000000
mITEST_INTE:        equ    %10000000


;*** VREGCTRL - VREG_U Module Control Register; 0x00000019 ***
VREGCTRL:           equ    $00000019                                ;*** VREGCTRL - VREG_U Module Control Register; 0x00000019 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
VREGCTRL_DATA:      equ    0                                         ; REF3V output data
VREGCTRL_EXTEN:     equ    1                                         ; External NMOS Power Channel Enable
VREGCTRL_BURNEN:    equ    2                                         ; Burn-in Mode Enable
VREGCTRL_LEVEL:     equ    3                                         ; Voltage Level in Burn-in Mode
; bit position masks
mVREGCTRL_DATA:     equ    %00000001
mVREGCTRL_EXTEN:    equ    %00000010
mVREGCTRL_BURNEN:   equ    %00000100
mVREGCTRL_LEVEL:    equ    %00001000


;*** PARTID - Part ID Register; 0x0000001A ***
PARTID:             equ    $0000001A                                ;*** PARTID - Part ID Register; 0x0000001A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PARTID_ID0:         equ    0                                         ; Part ID Register Bit 0
PARTID_ID1:         equ    1                                         ; Part ID Register Bit 1
PARTID_ID2:         equ    2                                         ; Part ID Register Bit 2
PARTID_ID3:         equ    3                                         ; Part ID Register Bit 3
PARTID_ID4:         equ    4                                         ; Part ID Register Bit 4
PARTID_ID5:         equ    5                                         ; Part ID Register Bit 5
PARTID_ID6:         equ    6                                         ; Part ID Register Bit 6
PARTID_ID7:         equ    7                                         ; Part ID Register Bit 7
PARTID_ID8:         equ    8                                         ; Part ID Register Bit 8
PARTID_ID9:         equ    9                                         ; Part ID Register Bit 9
PARTID_ID10:        equ    10                                        ; Part ID Register Bit 10
PARTID_ID11:        equ    11                                        ; Part ID Register Bit 11
PARTID_ID12:        equ    12                                        ; Part ID Register Bit 12
PARTID_ID13:        equ    13                                        ; Part ID Register Bit 13
PARTID_ID14:        equ    14                                        ; Part ID Register Bit 14
PARTID_ID15:        equ    15                                        ; Part ID Register Bit 15
; bit position masks
mPARTID_ID0:        equ    %00000001
mPARTID_ID1:        equ    %00000010
mPARTID_ID2:        equ    %00000100
mPARTID_ID3:        equ    %00001000
mPARTID_ID4:        equ    %00010000
mPARTID_ID5:        equ    %00100000
mPARTID_ID6:        equ    %01000000
mPARTID_ID7:        equ    %10000000
mPARTID_ID8:        equ    %100000000
mPARTID_ID9:        equ    %1000000000
mPARTID_ID10:       equ    %10000000000
mPARTID_ID11:       equ    %100000000000
mPARTID_ID12:       equ    %1000000000000
mPARTID_ID13:       equ    %10000000000000
mPARTID_ID14:       equ    %100000000000000
mPARTID_ID15:       equ    %1000000000000000


;*** PARTIDH - High Register of Part ID; 0x0000001A ***
PARTIDH:            equ    $0000001A                                ;*** PARTIDH - High Register of Part ID; 0x0000001A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PARTIDH_ID8:        equ    0                                         ; Part ID high byte Bit 8
PARTIDH_ID9:        equ    1                                         ; Part ID high byte Bit 9
PARTIDH_ID10:       equ    2                                         ; Part ID high byte Bit 10
PARTIDH_ID11:       equ    3                                         ; Part ID high byte Bit 11
PARTIDH_ID12:       equ    4                                         ; Part ID high byte Bit 12
PARTIDH_ID13:       equ    5                                         ; Part ID high byte Bit 13
PARTIDH_ID14:       equ    6                                         ; Part ID high byte Bit 14
PARTIDH_ID15:       equ    7                                         ; Part ID high byte Bit 15
; bit position masks
mPARTIDH_ID8:       equ    %00000001
mPARTIDH_ID9:       equ    %00000010
mPARTIDH_ID10:      equ    %00000100
mPARTIDH_ID11:      equ    %00001000
mPARTIDH_ID12:      equ    %00010000
mPARTIDH_ID13:      equ    %00100000
mPARTIDH_ID14:      equ    %01000000
mPARTIDH_ID15:      equ    %10000000


;*** PARTIDL - Low Register of Part ID; 0x0000001B ***
PARTIDL:            equ    $0000001B                                ;*** PARTIDL - Low Register of Part ID; 0x0000001B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PARTIDL_ID0:        equ    0                                         ; Part ID low byte Bit0
PARTIDL_ID1:        equ    1                                         ; Part ID low byte Bit 1
PARTIDL_ID2:        equ    2                                         ; Part ID low byte Bit 2
PARTIDL_ID3:        equ    3                                         ; Part ID low byte Bit 3
PARTIDL_ID4:        equ    4                                         ; Part ID low byte Bit 4
PARTIDL_ID5:        equ    5                                         ; Part ID low byte Bit 5
PARTIDL_ID6:        equ    6                                         ; Part ID low byte Bit 6
PARTIDL_ID7:        equ    7                                         ; Part ID low byte Bit 7
; bit position masks
mPARTIDL_ID0:       equ    %00000001
mPARTIDL_ID1:       equ    %00000010
mPARTIDL_ID2:       equ    %00000100
mPARTIDL_ID3:       equ    %00001000
mPARTIDL_ID4:       equ    %00010000
mPARTIDL_ID5:       equ    %00100000
mPARTIDL_ID6:       equ    %01000000
mPARTIDL_ID7:       equ    %10000000


;*** MEMSIZ0 - Memory Size Register Zero; 0x0000001C ***
MEMSIZ0:            equ    $0000001C                                ;*** MEMSIZ0 - Memory Size Register Zero; 0x0000001C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MEMSIZ0_ram_sw0:    equ    0                                         ; Allocated System RAM Memory Space Bit 0
MEMSIZ0_ram_sw1:    equ    1                                         ; Allocated System RAM Memory Space Bit 1
MEMSIZ0_ram_sw2:    equ    2                                         ; Allocated System RAM Memory Space Bit 2
MEMSIZ0_eep_sw0:    equ    4                                         ; Allocated System EEPROM Memory Space Bit 0
MEMSIZ0_eep_sw1:    equ    5                                         ; Allocated System EEPROM Memory Space Bit 1
MEMSIZ0_reg_sw0:    equ    7                                         ; Allocated System Register Space
; bit position masks
mMEMSIZ0_ram_sw0:   equ    %00000001
mMEMSIZ0_ram_sw1:   equ    %00000010
mMEMSIZ0_ram_sw2:   equ    %00000100
mMEMSIZ0_eep_sw0:   equ    %00010000
mMEMSIZ0_eep_sw1:   equ    %00100000
mMEMSIZ0_reg_sw0:   equ    %10000000


;*** MEMSIZ1 - Memory Size Register One; 0x0000001D ***
MEMSIZ1:            equ    $0000001D                                ;*** MEMSIZ1 - Memory Size Register One; 0x0000001D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MEMSIZ1_pag_sw0:    equ    0                                         ; Allocated Off-Chip Memory Options Bit 0
MEMSIZ1_pag_sw1:    equ    1                                         ; Allocated Off-Chip Memory Options Bit 1
MEMSIZ1_rom_sw0:    equ    6                                         ; Allocated System Flash EEPROM or ROM Physical Memory Space Bit 0
MEMSIZ1_rom_sw1:    equ    7                                         ; Allocated System Flash EEPROM or ROM Physical Memory Space Bit 1
; bit position masks
mMEMSIZ1_pag_sw0:   equ    %00000001
mMEMSIZ1_pag_sw1:   equ    %00000010
mMEMSIZ1_rom_sw0:   equ    %01000000
mMEMSIZ1_rom_sw1:   equ    %10000000


;*** INTCR - Interrupt Control Register; 0x0000001E ***
INTCR:              equ    $0000001E                                ;*** INTCR - Interrupt Control Register; 0x0000001E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
INTCR_IRQEN:        equ    6                                         ; External IRQ Enable
INTCR_IRQE:         equ    7                                         ; IRQ Select Edge Sensitive Only
; bit position masks
mINTCR_IRQEN:       equ    %01000000
mINTCR_IRQE:        equ    %10000000


;*** HPRIO - Highest Priority I Interrupt; 0x0000001F ***
HPRIO:              equ    $0000001F                                ;*** HPRIO - Highest Priority I Interrupt; 0x0000001F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
HPRIO_PSEL1:        equ    1                                         ; Highest priority I interrupt select bit 1
HPRIO_PSEL2:        equ    2                                         ; Highest priority I interrupt select bit 2
HPRIO_PSEL3:        equ    3                                         ; Highest priority I interrupt select bit 3
HPRIO_PSEL4:        equ    4                                         ; Highest priority I interrupt select bit 4
HPRIO_PSEL5:        equ    5                                         ; Highest priority I interrupt select bit 5
HPRIO_PSEL6:        equ    6                                         ; Highest priority I interrupt select bit 6
HPRIO_PSEL7:        equ    7                                         ; Highest priority I interrupt select bit 7
; bit position masks
mHPRIO_PSEL1:       equ    %00000010
mHPRIO_PSEL2:       equ    %00000100
mHPRIO_PSEL3:       equ    %00001000
mHPRIO_PSEL4:       equ    %00010000
mHPRIO_PSEL5:       equ    %00100000
mHPRIO_PSEL6:       equ    %01000000
mHPRIO_PSEL7:       equ    %10000000


;*** BKPCT0 - Breakpoint Control Register 0; 0x00000028 ***
BKPCT0:             equ    $00000028                                ;*** BKPCT0 - Breakpoint Control Register 0; 0x00000028 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
BKPCT0_BKTAG:       equ    4                                         ; Breakpoint on Tag
BKPCT0_BKBDM:       equ    5                                         ; Breakpoint Background Debug Mode Enable
BKPCT0_BKFULL:      equ    6                                         ; Full Breakpoint Mode Enable
BKPCT0_BKEN:        equ    7                                         ; Breakpoint Enable
; bit position masks
mBKPCT0_BKTAG:      equ    %00010000
mBKPCT0_BKBDM:      equ    %00100000
mBKPCT0_BKFULL:     equ    %01000000
mBKPCT0_BKEN:       equ    %10000000


;*** BKPCT1 - Breakpoint Control Register 1; 0x00000029 ***
BKPCT1:             equ    $00000029                                ;*** BKPCT1 - Breakpoint Control Register 1; 0x00000029 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
BKPCT1_BK1RW:       equ    0                                         ; R/W Compare Value of second address
BKPCT1_BK1RWE:      equ    1                                         ; R/W Compare Enable of second address
BKPCT1_BK0RW:       equ    2                                         ; R/W Compare Value of First Address
BKPCT1_BK0RWE:      equ    3                                         ; R/W Compare Enable of First Address
BKPCT1_BK1MBL:      equ    4                                         ; Breakpoint Mask Low Byte of Data (Second Address)
BKPCT1_BK1MBH:      equ    5                                         ; Breakpoint Mask High Byte of Data (Second Address)
BKPCT1_BK0MBL:      equ    6                                         ; Breakpoint Mask Low Byte for First Address
BKPCT1_BK0MBH:      equ    7                                         ; Breakpoint Mask High Byte for First Address
; bit position masks
mBKPCT1_BK1RW:      equ    %00000001
mBKPCT1_BK1RWE:     equ    %00000010
mBKPCT1_BK0RW:      equ    %00000100
mBKPCT1_BK0RWE:     equ    %00001000
mBKPCT1_BK1MBL:     equ    %00010000
mBKPCT1_BK1MBH:     equ    %00100000
mBKPCT1_BK0MBL:     equ    %01000000
mBKPCT1_BK0MBH:     equ    %10000000


;*** BKP0X - Breakpoint First Address Expansion Register; 0x0000002A ***
BKP0X:              equ    $0000002A                                ;*** BKP0X - Breakpoint First Address Expansion Register; 0x0000002A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
BKP0X_BK0V0:        equ    0                                         ; Value of first breakpoint address to be matched in memory expansion space Bit 0
BKP0X_BK0V1:        equ    1                                         ; Value of first breakpoint address to be matched in memory expansion space Bit 1
BKP0X_BK0V2:        equ    2                                         ; Value of first breakpoint address to be matched in memory expansion space Bit 2
BKP0X_BK0V3:        equ    3                                         ; Value of first breakpoint address to be matched in memory expansion space Bit 3
BKP0X_BK0V4:        equ    4                                         ; Value of first breakpoint address to be matched in memory expansion space Bit 4
BKP0X_BK0V5:        equ    5                                         ; Value of first breakpoint address to be matched in memory expansion space Bit 5
; bit position masks
mBKP0X_BK0V0:       equ    %00000001
mBKP0X_BK0V1:       equ    %00000010
mBKP0X_BK0V2:       equ    %00000100
mBKP0X_BK0V3:       equ    %00001000
mBKP0X_BK0V4:       equ    %00010000
mBKP0X_BK0V5:       equ    %00100000


;*** BKP0H - Breakpoint First Address High Byte Register; 0x0000002B ***
BKP0H:              equ    $0000002B                                ;*** BKP0H - Breakpoint First Address High Byte Register; 0x0000002B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
BKP0H_BIT0:         equ    0                                         ; Breakpoint address high byte Bit 0
BKP0H_BIT1:         equ    1                                         ; Breakpoint address high byte Bit 1
BKP0H_BIT2:         equ    2                                         ; Breakpoint address high byte Bit 2
BKP0H_BIT3:         equ    3                                         ; Breakpoint address high byte Bit 3
BKP0H_BIT4:         equ    4                                         ; Breakpoint address high byte Bit 4
BKP0H_BIT5:         equ    5                                         ; Breakpoint address high byte Bit 5
BKP0H_BIT6:         equ    6                                         ; Breakpoint address high byte Bit 6
BKP0H_BIT7:         equ    7                                         ; Breakpoint address high byte Bit 7
; bit position masks
mBKP0H_BIT0:        equ    %00000001
mBKP0H_BIT1:        equ    %00000010
mBKP0H_BIT2:        equ    %00000100
mBKP0H_BIT3:        equ    %00001000
mBKP0H_BIT4:        equ    %00010000
mBKP0H_BIT5:        equ    %00100000
mBKP0H_BIT6:        equ    %01000000
mBKP0H_BIT7:        equ    %10000000


;*** BKP0L - Breakpoint First Address Low Byte Register; 0x0000002C ***
BKP0L:              equ    $0000002C                                ;*** BKP0L - Breakpoint First Address Low Byte Register; 0x0000002C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
BKP0L_BIT0:         equ    0                                         ; Breakpoint address low byte Bit 0
BKP0L_BIT1:         equ    1                                         ; Breakpoint address low byte Bit 1
BKP0L_BIT2:         equ    2                                         ; Breakpoint address low byte Bit 2
BKP0L_BIT3:         equ    3                                         ; Breakpoint address low byte Bit 3
BKP0L_BIT4:         equ    4                                         ; Breakpoint address low byte Bit 4
BKP0L_BIT5:         equ    5                                         ; Breakpoint address low byte Bit 5
BKP0L_BIT6:         equ    6                                         ; Breakpoint address low byte Bit 6
BKP0L_BIT7:         equ    7                                         ; Breakpoint address low byte Bit 7
; bit position masks
mBKP0L_BIT0:        equ    %00000001
mBKP0L_BIT1:        equ    %00000010
mBKP0L_BIT2:        equ    %00000100
mBKP0L_BIT3:        equ    %00001000
mBKP0L_BIT4:        equ    %00010000
mBKP0L_BIT5:        equ    %00100000
mBKP0L_BIT6:        equ    %01000000
mBKP0L_BIT7:        equ    %10000000


;*** BKP1X - Breakpoint Second Address Expansion Register; 0x0000002D ***
BKP1X:              equ    $0000002D                                ;*** BKP1X - Breakpoint Second Address Expansion Register; 0x0000002D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
BKP1X_BK1V0:        equ    0                                         ; Value of first breakpoint address to be matched in memory expansion space Bit 0
BKP1X_BK1V1:        equ    1                                         ; Value of first breakpoint address to be matched in memory expansion space Bit 1
BKP1X_BK1V2:        equ    2                                         ; Value of first breakpoint address to be matched in memory expansion space Bit 2
BKP1X_BK1V3:        equ    3                                         ; Value of first breakpoint address to be matched in memory expansion space Bit 3
BKP1X_BK1V4:        equ    4                                         ; Value of first breakpoint address to be matched in memory expansion space Bit 4
BKP1X_BK1V5:        equ    5                                         ; Value of first breakpoint address to be matched in memory expansion space Bit 5
; bit position masks
mBKP1X_BK1V0:       equ    %00000001
mBKP1X_BK1V1:       equ    %00000010
mBKP1X_BK1V2:       equ    %00000100
mBKP1X_BK1V3:       equ    %00001000
mBKP1X_BK1V4:       equ    %00010000
mBKP1X_BK1V5:       equ    %00100000


;*** BKP1H - Breakpoint Data (Second Address) High Byte Register; 0x0000002E ***
BKP1H:              equ    $0000002E                                ;*** BKP1H - Breakpoint Data (Second Address) High Byte Register; 0x0000002E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
BKP1H_BIT8:         equ    0                                         ; Breakpoint data (second address) high byte Bit 8
BKP1H_BIT9:         equ    1                                         ; Breakpoint data (second address) high byte Bit 9
BKP1H_BIT10:        equ    2                                         ; Breakpoint data (second address) high byte Bit 10
BKP1H_BIT11:        equ    3                                         ; Breakpoint data (second address) high byte Bit 11
BKP1H_BIT12:        equ    4                                         ; Breakpoint data (second address) high byte Bit 12
BKP1H_BIT13:        equ    5                                         ; Breakpoint data (second address) high byte Bit 13
BKP1H_BIT14:        equ    6                                         ; Breakpoint data (second address) high byte Bit 14
BKP1H_BIT15:        equ    7                                         ; Breakpoint data (second address) high byte Bit 15
; bit position masks
mBKP1H_BIT8:        equ    %00000001
mBKP1H_BIT9:        equ    %00000010
mBKP1H_BIT10:       equ    %00000100
mBKP1H_BIT11:       equ    %00001000
mBKP1H_BIT12:       equ    %00010000
mBKP1H_BIT13:       equ    %00100000
mBKP1H_BIT14:       equ    %01000000
mBKP1H_BIT15:       equ    %10000000


;*** BKP1L - Breakpoint Data (Second Address) Low Byte Register; 0x0000002F ***
BKP1L:              equ    $0000002F                                ;*** BKP1L - Breakpoint Data (Second Address) Low Byte Register; 0x0000002F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
BKP1L_BIT0:         equ    0                                         ; Breakpoint data (second address) low byte Bit 0
BKP1L_BIT1:         equ    1                                         ; Breakpoint data (second address) low byte Bit 1
BKP1L_BIT2:         equ    2                                         ; Breakpoint data (second address) low byte Bit 2
BKP1L_BIT3:         equ    3                                         ; Breakpoint data (second address) low byte Bit 3
BKP1L_BIT4:         equ    4                                         ; Breakpoint data (second address) low byte Bit 4
BKP1L_BIT5:         equ    5                                         ; Breakpoint data (second address) low byte Bit 5
BKP1L_BIT6:         equ    6                                         ; Breakpoint data (second address) low byte Bit 6
BKP1L_BIT7:         equ    7                                         ; Breakpoint data (second address) low byte Bit 7
; bit position masks
mBKP1L_BIT0:        equ    %00000001
mBKP1L_BIT1:        equ    %00000010
mBKP1L_BIT2:        equ    %00000100
mBKP1L_BIT3:        equ    %00001000
mBKP1L_BIT4:        equ    %00010000
mBKP1L_BIT5:        equ    %00100000
mBKP1L_BIT6:        equ    %01000000
mBKP1L_BIT7:        equ    %10000000


;*** PPAGE - Program Page Index Register; 0x00000030 ***
PPAGE:              equ    $00000030                                ;*** PPAGE - Program Page Index Register; 0x00000030 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PPAGE_PIX0:         equ    0                                         ; Program Page Index Bit 0
PPAGE_PIX1:         equ    1                                         ; Program Page Index Bit 1
PPAGE_PIX2:         equ    2                                         ; Program Page Index Bit 2
PPAGE_PIX3:         equ    3                                         ; Program Page Index Bit 3
PPAGE_PIX4:         equ    4                                         ; Program Page Index Bit 4
PPAGE_PIX5:         equ    5                                         ; Program Page Index Bit 5
; bit position masks
mPPAGE_PIX0:        equ    %00000001
mPPAGE_PIX1:        equ    %00000010
mPPAGE_PIX2:        equ    %00000100
mPPAGE_PIX3:        equ    %00001000
mPPAGE_PIX4:        equ    %00010000
mPPAGE_PIX5:        equ    %00100000


;*** REFDV - CRG Reference Divider Register; 0x00000035 ***
REFDV:              equ    $00000035                                ;*** REFDV - CRG Reference Divider Register; 0x00000035 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
REFDV_REFDV0:       equ    0                                         ; CRG Reference Divider Bit 0
REFDV_REFDV1:       equ    1                                         ; CRG Reference Divider Bit 1
REFDV_REFDV2:       equ    2                                         ; CRG Reference Divider Bit 2
REFDV_REFDV3:       equ    3                                         ; CRG Reference Divider Bit 3
; bit position masks
mREFDV_REFDV0:      equ    %00000001
mREFDV_REFDV1:      equ    %00000010
mREFDV_REFDV2:      equ    %00000100
mREFDV_REFDV3:      equ    %00001000


;*** CRGFLG - CRG Flags Register; 0x00000037 ***
CRGFLG:             equ    $00000037                                ;*** CRGFLG - CRG Flags Register; 0x00000037 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CRGFLG_LOCK:        equ    3                                         ; Lock Status
CRGFLG_LOCKIF:      equ    4                                         ; PLL Lock Interrupt Flag
CRGFLG_PORF:        equ    6                                         ; Power on Reset Flag
CRGFLG_RTIF:        equ    7                                         ; Real Time Interrupt Flag
; bit position masks
mCRGFLG_LOCK:       equ    %00001000
mCRGFLG_LOCKIF:     equ    %00010000
mCRGFLG_PORF:       equ    %01000000
mCRGFLG_RTIF:       equ    %10000000


;*** CRGINT - CRG Interrupt Enable Register; 0x00000038 ***
CRGINT:             equ    $00000038                                ;*** CRGINT - CRG Interrupt Enable Register; 0x00000038 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CRGINT_LOCKIE:      equ    4                                         ; Lock Interrupt Enable
CRGINT_RTIE:        equ    7                                         ; Real Time Interrupt Enable
; bit position masks
mCRGINT_LOCKIE:     equ    %00010000
mCRGINT_RTIE:       equ    %10000000


;*** CLKSEL - CRG Clock Select Register; 0x00000039 ***
CLKSEL:             equ    $00000039                                ;*** CLKSEL - CRG Clock Select Register; 0x00000039 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CLKSEL_COPWAI:      equ    0                                         ; COP stops in WAIT mode
CLKSEL_RTIWAI:      equ    1                                         ; RTI stops in WAIT mode
CLKSEL_CWAI:        equ    2                                         ; CLK24 and CLK23 stop in WAIT mode
CLKSEL_ROAWAI:      equ    4                                         ; Reduced Oscillator Amplitude in WAIT mode
CLKSEL_SYSWAI:      equ    5                                         ; System clocks stop in WAIT mode
CLKSEL_PLLSEL:      equ    7                                         ; PLL selected for system clock
; bit position masks
mCLKSEL_COPWAI:     equ    %00000001
mCLKSEL_RTIWAI:     equ    %00000010
mCLKSEL_CWAI:       equ    %00000100
mCLKSEL_ROAWAI:     equ    %00010000
mCLKSEL_SYSWAI:     equ    %00100000
mCLKSEL_PLLSEL:     equ    %10000000


;*** RTICTL - CRG RTI Control Register; 0x0000003B ***
RTICTL:             equ    $0000003B                                ;*** RTICTL - CRG RTI Control Register; 0x0000003B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RTICTL_RTR0:        equ    0                                         ; Real Time Interrupt Modulus Counter Select Bit 0
RTICTL_RTR1:        equ    1                                         ; Real Time Interrupt Modulus Counter Select Bit 1
RTICTL_RTR2:        equ    2                                         ; Real Time Interrupt Modulus Counter Select Bit 2
RTICTL_RTR3:        equ    3                                         ; Real Time Interrupt Modulus Counter Select Bit 3
RTICTL_RTR4:        equ    4                                         ; Real Time Interrupt Prescale Rate Select Bit 0
RTICTL_RTR5:        equ    5                                         ; Real Time Interrupt Prescale Rate Select Bit 1
RTICTL_RTR6:        equ    6                                         ; Real Time Interrupt Prescale Rate Select Bit 2
; bit position masks
mRTICTL_RTR0:       equ    %00000001
mRTICTL_RTR1:       equ    %00000010
mRTICTL_RTR2:       equ    %00000100
mRTICTL_RTR3:       equ    %00001000
mRTICTL_RTR4:       equ    %00010000
mRTICTL_RTR5:       equ    %00100000
mRTICTL_RTR6:       equ    %01000000


;*** COPCTL - CRG COP Control Register; 0x0000003C ***
COPCTL:             equ    $0000003C                                ;*** COPCTL - CRG COP Control Register; 0x0000003C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
COPCTL_CR0:         equ    0                                         ; COP Watchdog Timer Rate select Bit 0
COPCTL_CR1:         equ    1                                         ; COP Watchdog Timer Rate select Bit 1
COPCTL_CR2:         equ    2                                         ; COP Watchdog Timer Rate select Bit 2
COPCTL_RSBCK:       equ    6                                         ; COP and RTI stop in Active BDM mode Bit
COPCTL_WCOP:        equ    7                                         ; Window COP mode
; bit position masks
mCOPCTL_CR0:        equ    %00000001
mCOPCTL_CR1:        equ    %00000010
mCOPCTL_CR2:        equ    %00000100
mCOPCTL_RSBCK:      equ    %01000000
mCOPCTL_WCOP:       equ    %10000000


;*** ARMCOP - CRG COP Timer Arm/Reset Register; 0x0000003F ***
ARMCOP:             equ    $0000003F                                ;*** ARMCOP - CRG COP Timer Arm/Reset Register; 0x0000003F ***


;*** TIOS - Timer Input Capture/Output Compare Select; 0x00000040 ***
TIOS:               equ    $00000040                                ;*** TIOS - Timer Input Capture/Output Compare Select; 0x00000040 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TIOS_IOS0:          equ    0                                         ; Input Capture or Output Compare Channel Configuration Bit 0
TIOS_IOS1:          equ    1                                         ; Input Capture or Output Compare Channel Configuration Bit 1
TIOS_IOS2:          equ    2                                         ; Input Capture or Output Compare Channel Configuration Bit 2
TIOS_IOS3:          equ    3                                         ; Input Capture or Output Compare Channel Configuration Bit 3
TIOS_IOS4:          equ    4                                         ; Input Capture or Output Compare Channel Configuration Bit 4
TIOS_IOS5:          equ    5                                         ; Input Capture or Output Compare Channel Configuration Bit 5
TIOS_IOS6:          equ    6                                         ; Input Capture or Output Compare Channel Configuration Bit 6
TIOS_IOS7:          equ    7                                         ; Input Capture or Output Compare Channel Configuration Bit 7
; bit position masks
mTIOS_IOS0:         equ    %00000001
mTIOS_IOS1:         equ    %00000010
mTIOS_IOS2:         equ    %00000100
mTIOS_IOS3:         equ    %00001000
mTIOS_IOS4:         equ    %00010000
mTIOS_IOS5:         equ    %00100000
mTIOS_IOS6:         equ    %01000000
mTIOS_IOS7:         equ    %10000000


;*** CFORC - Timer Compare Force Register; 0x00000041 ***
CFORC:              equ    $00000041                                ;*** CFORC - Timer Compare Force Register; 0x00000041 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CFORC_FOC0:         equ    0                                         ; Force Output Compare Action for Channel 0
CFORC_FOC1:         equ    1                                         ; Force Output Compare Action for Channel 1
CFORC_FOC2:         equ    2                                         ; Force Output Compare Action for Channel 2
CFORC_FOC3:         equ    3                                         ; Force Output Compare Action for Channel 3
CFORC_FOC4:         equ    4                                         ; Force Output Compare Action for Channel 4
CFORC_FOC5:         equ    5                                         ; Force Output Compare Action for Channel 5
CFORC_FOC6:         equ    6                                         ; Force Output Compare Action for Channel 6
CFORC_FOC7:         equ    7                                         ; Force Output Compare Action for Channel 7
; bit position masks
mCFORC_FOC0:        equ    %00000001
mCFORC_FOC1:        equ    %00000010
mCFORC_FOC2:        equ    %00000100
mCFORC_FOC3:        equ    %00001000
mCFORC_FOC4:        equ    %00010000
mCFORC_FOC5:        equ    %00100000
mCFORC_FOC6:        equ    %01000000
mCFORC_FOC7:        equ    %10000000


;*** OC7M - Output Compare 7 Mask Register; 0x00000042 ***
OC7M:               equ    $00000042                                ;*** OC7M - Output Compare 7 Mask Register; 0x00000042 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
OC7M_OC7M0:         equ    0                                         ; Output Compare 7 Mask Bit 0
OC7M_OC7M1:         equ    1                                         ; Output Compare 7 Mask Bit 1
OC7M_OC7M2:         equ    2                                         ; Output Compare 7 Mask Bit 2
OC7M_OC7M3:         equ    3                                         ; Output Compare 7 Mask Bit 3
OC7M_OC7M4:         equ    4                                         ; Output Compare 7 Mask Bit 4
OC7M_OC7M5:         equ    5                                         ; Output Compare 7 Mask Bit 5
OC7M_OC7M6:         equ    6                                         ; Output Compare 7 Mask Bit 6
OC7M_OC7M7:         equ    7                                         ; Output Compare 7 Mask Bit 7
; bit position masks
mOC7M_OC7M0:        equ    %00000001
mOC7M_OC7M1:        equ    %00000010
mOC7M_OC7M2:        equ    %00000100
mOC7M_OC7M3:        equ    %00001000
mOC7M_OC7M4:        equ    %00010000
mOC7M_OC7M5:        equ    %00100000
mOC7M_OC7M6:        equ    %01000000
mOC7M_OC7M7:        equ    %10000000


;*** OC7D - Output Compare 7 Data Register; 0x00000043 ***
OC7D:               equ    $00000043                                ;*** OC7D - Output Compare 7 Data Register; 0x00000043 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
OC7D_OC7D0:         equ    0                                         ; Output Compare 7 Bit 0
OC7D_OC7D1:         equ    1                                         ; Output Compare 7 Bit 1
OC7D_OC7D2:         equ    2                                         ; Output Compare 7 Bit 2
OC7D_OC7D3:         equ    3                                         ; Output Compare 7 Bit 3
OC7D_OC7D4:         equ    4                                         ; Output Compare 7 Bit 4
OC7D_OC7D5:         equ    5                                         ; Output Compare 7 Bit 5
OC7D_OC7D6:         equ    6                                         ; Output Compare 7 Bit 6
OC7D_OC7D7:         equ    7                                         ; Output Compare 7 Bit 7
; bit position masks
mOC7D_OC7D0:        equ    %00000001
mOC7D_OC7D1:        equ    %00000010
mOC7D_OC7D2:        equ    %00000100
mOC7D_OC7D3:        equ    %00001000
mOC7D_OC7D4:        equ    %00010000
mOC7D_OC7D5:        equ    %00100000
mOC7D_OC7D6:        equ    %01000000
mOC7D_OC7D7:        equ    %10000000


;*** TCNT - Timer Count Register; 0x00000044 ***
TCNT:               equ    $00000044                                ;*** TCNT - Timer Count Register; 0x00000044 ***


;*** TCNTHi - Timer Count Register High; 0x00000044 ***
TCNTHi:             equ    $00000044                                ;*** TCNTHi - Timer Count Register High; 0x00000044 ***


;*** TCNTLo - Timer Count Register Low; 0x00000045 ***
TCNTLo:             equ    $00000045                                ;*** TCNTLo - Timer Count Register Low; 0x00000045 ***


;*** TSCR1 - Timer System Control Register1; 0x00000046 ***
TSCR1:              equ    $00000046                                ;*** TSCR1 - Timer System Control Register1; 0x00000046 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TSCR1_TFFCA:        equ    4                                         ; Timer Fast Flag Clear All
TSCR1_TSFRZ:        equ    5                                         ; Timer and Modulus Counter Stop While in Freeze Mode
TSCR1_TSWAI:        equ    6                                         ; Timer Module Stops While in Wait
TSCR1_TEN:          equ    7                                         ; Timer Enable
; bit position masks
mTSCR1_TFFCA:       equ    %00010000
mTSCR1_TSFRZ:       equ    %00100000
mTSCR1_TSWAI:       equ    %01000000
mTSCR1_TEN:         equ    %10000000


;*** TTOV - Timer Toggle On Overflow Register; 0x00000047 ***
TTOV:               equ    $00000047                                ;*** TTOV - Timer Toggle On Overflow Register; 0x00000047 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TTOV_TOV0:          equ    0                                         ; Toggle On Overflow Bit 0
TTOV_TOV1:          equ    1                                         ; Toggle On Overflow Bit 1
TTOV_TOV2:          equ    2                                         ; Toggle On Overflow Bit 2
TTOV_TOV3:          equ    3                                         ; Toggle On Overflow Bit 3
TTOV_TOV4:          equ    4                                         ; Toggle On Overflow Bit 4
TTOV_TOV5:          equ    5                                         ; Toggle On Overflow Bit 5
TTOV_TOV6:          equ    6                                         ; Toggle On Overflow Bit 6
TTOV_TOV7:          equ    7                                         ; Toggle On Overflow Bit 7
; bit position masks
mTTOV_TOV0:         equ    %00000001
mTTOV_TOV1:         equ    %00000010
mTTOV_TOV2:         equ    %00000100
mTTOV_TOV3:         equ    %00001000
mTTOV_TOV4:         equ    %00010000
mTTOV_TOV5:         equ    %00100000
mTTOV_TOV6:         equ    %01000000
mTTOV_TOV7:         equ    %10000000


;*** TCTL1 - Timer Control Register 1; 0x00000048 ***
TCTL1:              equ    $00000048                                ;*** TCTL1 - Timer Control Register 1; 0x00000048 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TCTL1_OL4:          equ    0                                         ; Output Level Bit 4
TCTL1_OM4:          equ    1                                         ; Output Mode Bit 4
TCTL1_OL5:          equ    2                                         ; Output Level Bit 5
TCTL1_OM5:          equ    3                                         ; Output Mode Bit 5
TCTL1_OL6:          equ    4                                         ; Output Level Bit 6
TCTL1_OM6:          equ    5                                         ; Output Mode Bit 6
TCTL1_OL7:          equ    6                                         ; Output Level Bit 7
TCTL1_OM7:          equ    7                                         ; Output Mode Bit 7
; bit position masks
mTCTL1_OL4:         equ    %00000001
mTCTL1_OM4:         equ    %00000010
mTCTL1_OL5:         equ    %00000100
mTCTL1_OM5:         equ    %00001000
mTCTL1_OL6:         equ    %00010000
mTCTL1_OM6:         equ    %00100000
mTCTL1_OL7:         equ    %01000000
mTCTL1_OM7:         equ    %10000000


;*** TCTL2 - Timer Control Register 2; 0x00000049 ***
TCTL2:              equ    $00000049                                ;*** TCTL2 - Timer Control Register 2; 0x00000049 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TCTL2_OL0:          equ    0                                         ; Output Level Bit 0
TCTL2_OM0:          equ    1                                         ; Output Mode Bit 0
TCTL2_OL1:          equ    2                                         ; Output Level Bit 1
TCTL2_OM1:          equ    3                                         ; Output Mode Bit 1
TCTL2_OL2:          equ    4                                         ; Output Level Bit 2
TCTL2_OM2:          equ    5                                         ; Output Mode Bit 2
TCTL2_OL3:          equ    6                                         ; Output Level Bit 3
TCTL2_OM3:          equ    7                                         ; Output Mode Bit 3
; bit position masks
mTCTL2_OL0:         equ    %00000001
mTCTL2_OM0:         equ    %00000010
mTCTL2_OL1:         equ    %00000100
mTCTL2_OM1:         equ    %00001000
mTCTL2_OL2:         equ    %00010000
mTCTL2_OM2:         equ    %00100000
mTCTL2_OL3:         equ    %01000000
mTCTL2_OM3:         equ    %10000000


;*** TCTL3 - Timer Control Register 3; 0x0000004A ***
TCTL3:              equ    $0000004A                                ;*** TCTL3 - Timer Control Register 3; 0x0000004A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TCTL3_EDG4A:        equ    0                                         ; Input Capture Edge Control 4A
TCTL3_EDG4B:        equ    1                                         ; Input Capture Edge Control 4B
TCTL3_EDG5A:        equ    2                                         ; Input Capture Edge Control 5A
TCTL3_EDG5B:        equ    3                                         ; Input Capture Edge Control 5B
TCTL3_EDG6A:        equ    4                                         ; Input Capture Edge Control 6A
TCTL3_EDG6B:        equ    5                                         ; Input Capture Edge Control 6B
TCTL3_EDG7A:        equ    6                                         ; Input Capture Edge Control 7A
TCTL3_EDG7B:        equ    7                                         ; Input Capture Edge Control 7B
; bit position masks
mTCTL3_EDG4A:       equ    %00000001
mTCTL3_EDG4B:       equ    %00000010
mTCTL3_EDG5A:       equ    %00000100
mTCTL3_EDG5B:       equ    %00001000
mTCTL3_EDG6A:       equ    %00010000
mTCTL3_EDG6B:       equ    %00100000
mTCTL3_EDG7A:       equ    %01000000
mTCTL3_EDG7B:       equ    %10000000


;*** TCTL4 - Timer Control Register 4; 0x0000004B ***
TCTL4:              equ    $0000004B                                ;*** TCTL4 - Timer Control Register 4; 0x0000004B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TCTL4_EDG0A:        equ    0                                         ; Input Capture Edge Control 0A
TCTL4_EDG0B:        equ    1                                         ; Input Capture Edge Control 0B
TCTL4_EDG1A:        equ    2                                         ; Input Capture Edge Control 1A
TCTL4_EDG1B:        equ    3                                         ; Input Capture Edge Control 1B
TCTL4_EDG2A:        equ    4                                         ; Input Capture Edge Control 2A
TCTL4_EDG2B:        equ    5                                         ; Input Capture Edge Control 2B
TCTL4_EDG3A:        equ    6                                         ; Input Capture Edge Control 3A
TCTL4_EDG3B:        equ    7                                         ; Input Capture Edge Control 3B
; bit position masks
mTCTL4_EDG0A:       equ    %00000001
mTCTL4_EDG0B:       equ    %00000010
mTCTL4_EDG1A:       equ    %00000100
mTCTL4_EDG1B:       equ    %00001000
mTCTL4_EDG2A:       equ    %00010000
mTCTL4_EDG2B:       equ    %00100000
mTCTL4_EDG3A:       equ    %01000000
mTCTL4_EDG3B:       equ    %10000000


;*** TIE - Timer Interrupt Enable Register; 0x0000004C ***
TIE:                equ    $0000004C                                ;*** TIE - Timer Interrupt Enable Register; 0x0000004C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TIE_C0I:            equ    0                                         ; Input Capture/Output Compare Interrupt Enable Bit 0
TIE_C1I:            equ    1                                         ; Input Capture/Output Compare Interrupt Enable Bit 1
TIE_C2I:            equ    2                                         ; Input Capture/Output Compare Interrupt Enable Bit 2
TIE_C3I:            equ    3                                         ; Input Capture/Output Compare Interrupt Enable Bit 3
TIE_C4I:            equ    4                                         ; Input Capture/Output Compare Interrupt Enable Bit 4
TIE_C5I:            equ    5                                         ; Input Capture/Output Compare Interrupt Enable Bit 5
TIE_C6I:            equ    6                                         ; Input Capture/Output Compare Interrupt Enable Bit 6
TIE_C7I:            equ    7                                         ; Input Capture/Output Compare Interrupt Enable Bit 7
; bit position masks
mTIE_C0I:           equ    %00000001
mTIE_C1I:           equ    %00000010
mTIE_C2I:           equ    %00000100
mTIE_C3I:           equ    %00001000
mTIE_C4I:           equ    %00010000
mTIE_C5I:           equ    %00100000
mTIE_C6I:           equ    %01000000
mTIE_C7I:           equ    %10000000


;*** TSCR2 - Timer System Control Register 2; 0x0000004D ***
TSCR2:              equ    $0000004D                                ;*** TSCR2 - Timer System Control Register 2; 0x0000004D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TSCR2_PR0:          equ    0                                         ; Timer Prescaler Select Bit 0
TSCR2_PR1:          equ    1                                         ; Timer Prescaler Select Bit 1
TSCR2_PR2:          equ    2                                         ; Timer Prescaler Select Bit 2
TSCR2_TCRE:         equ    3                                         ; Timer Counter Reset Enable
TSCR2_TOI:          equ    7                                         ; Timer Overflow Interrupt Enable
; bit position masks
mTSCR2_PR0:         equ    %00000001
mTSCR2_PR1:         equ    %00000010
mTSCR2_PR2:         equ    %00000100
mTSCR2_TCRE:        equ    %00001000
mTSCR2_TOI:         equ    %10000000


;*** TFLG1 - Main Timer Interrupt Flag 1; 0x0000004E ***
TFLG1:              equ    $0000004E                                ;*** TFLG1 - Main Timer Interrupt Flag 1; 0x0000004E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TFLG1_C0F:          equ    0                                         ; Input Capture/Output Compare Channel Flag 0
TFLG1_C1F:          equ    1                                         ; Input Capture/Output Compare Channel Flag 1
TFLG1_C2F:          equ    2                                         ; Input Capture/Output Compare Channel Flag 2
TFLG1_C3F:          equ    3                                         ; Input Capture/Output Compare Channel Flag 3
TFLG1_C4F:          equ    4                                         ; Input Capture/Output Compare Channel Flag 4
TFLG1_C5F:          equ    5                                         ; Input Capture/Output Compare Channel Flag 5
TFLG1_C6F:          equ    6                                         ; Input Capture/Output Compare Channel Flag 6
TFLG1_C7F:          equ    7                                         ; Input Capture/Output Compare Channel Flag 7
; bit position masks
mTFLG1_C0F:         equ    %00000001
mTFLG1_C1F:         equ    %00000010
mTFLG1_C2F:         equ    %00000100
mTFLG1_C3F:         equ    %00001000
mTFLG1_C4F:         equ    %00010000
mTFLG1_C5F:         equ    %00100000
mTFLG1_C6F:         equ    %01000000
mTFLG1_C7F:         equ    %10000000


;*** TFLG2 - Main Timer Interrupt Flag 2; 0x0000004F ***
TFLG2:              equ    $0000004F                                ;*** TFLG2 - Main Timer Interrupt Flag 2; 0x0000004F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TFLG2_TOF:          equ    7                                         ; Timer Overflow Flag
; bit position masks
mTFLG2_TOF:         equ    %10000000


;*** TC0 - Timer Input Capture/Output Compare Register 0; 0x00000050 ***
TC0:                equ    $00000050                                ;*** TC0 - Timer Input Capture/Output Compare Register 0; 0x00000050 ***


;*** TC0Hi - Timer Input Capture/Output Compare Register 0 High; 0x00000050 ***
TC0Hi:              equ    $00000050                                ;*** TC0Hi - Timer Input Capture/Output Compare Register 0 High; 0x00000050 ***


;*** TC0Lo - Timer Input Capture/Output Compare Register 0 Low; 0x00000051 ***
TC0Lo:              equ    $00000051                                ;*** TC0Lo - Timer Input Capture/Output Compare Register 0 Low; 0x00000051 ***


;*** TC1 - Timer Input Capture/Output Compare Register 1; 0x00000052 ***
TC1:                equ    $00000052                                ;*** TC1 - Timer Input Capture/Output Compare Register 1; 0x00000052 ***


;*** TC1Hi - Timer Input Capture/Output Compare Register 1 High; 0x00000052 ***
TC1Hi:              equ    $00000052                                ;*** TC1Hi - Timer Input Capture/Output Compare Register 1 High; 0x00000052 ***


;*** TC1Lo - Timer Input Capture/Output Compare Register 1 Low; 0x00000053 ***
TC1Lo:              equ    $00000053                                ;*** TC1Lo - Timer Input Capture/Output Compare Register 1 Low; 0x00000053 ***


;*** TC2 - Timer Input Capture/Output Compare Register 2; 0x00000054 ***
TC2:                equ    $00000054                                ;*** TC2 - Timer Input Capture/Output Compare Register 2; 0x00000054 ***


;*** TC2Hi - Timer Input Capture/Output Compare Register 2 High; 0x00000054 ***
TC2Hi:              equ    $00000054                                ;*** TC2Hi - Timer Input Capture/Output Compare Register 2 High; 0x00000054 ***


;*** TC2Lo - Timer Input Capture/Output Compare Register 2 Low; 0x00000055 ***
TC2Lo:              equ    $00000055                                ;*** TC2Lo - Timer Input Capture/Output Compare Register 2 Low; 0x00000055 ***


;*** TC3 - Timer Input Capture/Output Compare Register 3; 0x00000056 ***
TC3:                equ    $00000056                                ;*** TC3 - Timer Input Capture/Output Compare Register 3; 0x00000056 ***


;*** TC3Hi - Timer Input Capture/Output Compare Register 3 High; 0x00000056 ***
TC3Hi:              equ    $00000056                                ;*** TC3Hi - Timer Input Capture/Output Compare Register 3 High; 0x00000056 ***


;*** TC3Lo - Timer Input Capture/Output Compare Register 3 Low; 0x00000057 ***
TC3Lo:              equ    $00000057                                ;*** TC3Lo - Timer Input Capture/Output Compare Register 3 Low; 0x00000057 ***


;*** TC4 - Timer Input Capture/Output Compare Register 4; 0x00000058 ***
TC4:                equ    $00000058                                ;*** TC4 - Timer Input Capture/Output Compare Register 4; 0x00000058 ***


;*** TC4Hi - Timer Input Capture/Output Compare Register 4 High; 0x00000058 ***
TC4Hi:              equ    $00000058                                ;*** TC4Hi - Timer Input Capture/Output Compare Register 4 High; 0x00000058 ***


;*** TC4Lo - Timer Input Capture/Output Compare Register 4 Low; 0x00000059 ***
TC4Lo:              equ    $00000059                                ;*** TC4Lo - Timer Input Capture/Output Compare Register 4 Low; 0x00000059 ***


;*** TC5 - Timer Input Capture/Output Compare Register 5; 0x0000005A ***
TC5:                equ    $0000005A                                ;*** TC5 - Timer Input Capture/Output Compare Register 5; 0x0000005A ***


;*** TC5Hi - Timer Input Capture/Output Compare Register 5 High; 0x0000005A ***
TC5Hi:              equ    $0000005A                                ;*** TC5Hi - Timer Input Capture/Output Compare Register 5 High; 0x0000005A ***


;*** TC5Lo - Timer Input Capture/Output Compare Register 5 Low; 0x0000005B ***
TC5Lo:              equ    $0000005B                                ;*** TC5Lo - Timer Input Capture/Output Compare Register 5 Low; 0x0000005B ***


;*** TC6 - Timer Input Capture/Output Compare Register 6; 0x0000005C ***
TC6:                equ    $0000005C                                ;*** TC6 - Timer Input Capture/Output Compare Register 6; 0x0000005C ***


;*** TC6Hi - Timer Input Capture/Output Compare Register 6 High; 0x0000005C ***
TC6Hi:              equ    $0000005C                                ;*** TC6Hi - Timer Input Capture/Output Compare Register 6 High; 0x0000005C ***


;*** TC6Lo - Timer Input Capture/Output Compare Register 6 Low; 0x0000005D ***
TC6Lo:              equ    $0000005D                                ;*** TC6Lo - Timer Input Capture/Output Compare Register 6 Low; 0x0000005D ***


;*** TC7 - Timer Input Capture/Output Compare Register 7; 0x0000005E ***
TC7:                equ    $0000005E                                ;*** TC7 - Timer Input Capture/Output Compare Register 7; 0x0000005E ***


;*** TC7Hi - Timer Input Capture/Output Compare Register 7 High; 0x0000005E ***
TC7Hi:              equ    $0000005E                                ;*** TC7Hi - Timer Input Capture/Output Compare Register 7 High; 0x0000005E ***


;*** TC7Lo - Timer Input Capture/Output Compare Register 7 Low; 0x0000005F ***
TC7Lo:              equ    $0000005F                                ;*** TC7Lo - Timer Input Capture/Output Compare Register 7 Low; 0x0000005F ***


;*** PACTL - 16-Bit Pulse Accumulator A Control Register; 0x00000060 ***
PACTL:              equ    $00000060                                ;*** PACTL - 16-Bit Pulse Accumulator A Control Register; 0x00000060 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PACTL_PAI:          equ    0                                         ; Pulse Accumulator Input Interrupt enable
PACTL_PAOVI:        equ    1                                         ; Pulse Accumulator A Overflow Interrupt enable
PACTL_CLK0:         equ    2                                         ; Clock Select Bit 0
PACTL_CLK1:         equ    3                                         ; Clock Select Bit 1
PACTL_PEDGE:        equ    4                                         ; Pulse Accumulator Edge Control
PACTL_PAMOD:        equ    5                                         ; Pulse Accumulator Mode
PACTL_PAEN:         equ    6                                         ; Pulse Accumulator A System Enable
; bit position masks
mPACTL_PAI:         equ    %00000001
mPACTL_PAOVI:       equ    %00000010
mPACTL_CLK0:        equ    %00000100
mPACTL_CLK1:        equ    %00001000
mPACTL_PEDGE:       equ    %00010000
mPACTL_PAMOD:       equ    %00100000
mPACTL_PAEN:        equ    %01000000


;*** PAFLG - Pulse Accumulator A Flag Register; 0x00000061 ***
PAFLG:              equ    $00000061                                ;*** PAFLG - Pulse Accumulator A Flag Register; 0x00000061 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PAFLG_PAIF:         equ    0                                         ; Pulse Accumulator Input edge Flag
PAFLG_PAOVF:        equ    1                                         ; Pulse Accumulator A Overflow Flag
; bit position masks
mPAFLG_PAIF:        equ    %00000001
mPAFLG_PAOVF:       equ    %00000010


;*** PACNT - Pulse Accumulators Count Register; 0x00000062 ***
PACNT:              equ    $00000062                                ;*** PACNT - Pulse Accumulators Count Register; 0x00000062 ***


;*** SCIBD - SCI Baud Rate Register; 0x000000C8 ***
SCIBD:              equ    $000000C8                                ;*** SCIBD - SCI Baud Rate Register; 0x000000C8 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCIBD_SBR0:         equ    0                                         ; SCI baud rate Bit 0
SCIBD_SBR1:         equ    1                                         ; SCI baud rate Bit 1
SCIBD_SBR2:         equ    2                                         ; SCI baud rate Bit 2
SCIBD_SBR3:         equ    3                                         ; SCI baud rate Bit 3
SCIBD_SBR4:         equ    4                                         ; SCI baud rate Bit 4
SCIBD_SBR5:         equ    5                                         ; SCI baud rate Bit 5
SCIBD_SBR6:         equ    6                                         ; SCI baud rate Bit 6
SCIBD_SBR7:         equ    7                                         ; SCI baud rate Bit 7
SCIBD_SBR8:         equ    8                                         ; SCI baud rate Bit 8
SCIBD_SBR9:         equ    9                                         ; SCI baud rate Bit 9
SCIBD_SBR10:        equ    10                                        ; SCI baud rate Bit 10
SCIBD_SBR11:        equ    11                                        ; SCI baud rate Bit 11
SCIBD_SBR12:        equ    12                                        ; SCI baud rate Bit 12
SCIBD_TNP0:         equ    13                                        ; Transmitter Narrow Pulse Bit 0
SCIBD_TNP1:         equ    14                                        ; Transmitter Narrow Pulse Bit 1
SCIBD_IREN:         equ    15                                        ; Infrared Enable Bit
; bit position masks
mSCIBD_SBR0:        equ    %00000001
mSCIBD_SBR1:        equ    %00000010
mSCIBD_SBR2:        equ    %00000100
mSCIBD_SBR3:        equ    %00001000
mSCIBD_SBR4:        equ    %00010000
mSCIBD_SBR5:        equ    %00100000
mSCIBD_SBR6:        equ    %01000000
mSCIBD_SBR7:        equ    %10000000
mSCIBD_SBR8:        equ    %100000000
mSCIBD_SBR9:        equ    %1000000000
mSCIBD_SBR10:       equ    %10000000000
mSCIBD_SBR11:       equ    %100000000000
mSCIBD_SBR12:       equ    %1000000000000
mSCIBD_TNP0:        equ    %10000000000000
mSCIBD_TNP1:        equ    %100000000000000
mSCIBD_IREN:        equ    %1000000000000000


;*** SCIBDH - SCI Baud Rate Register High; 0x000000C8 ***
SCIBDH:             equ    $000000C8                                ;*** SCIBDH - SCI Baud Rate Register High; 0x000000C8 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCIBDH_SBR8:        equ    0                                         ; SCI 0 baud rate Bit 8
SCIBDH_SBR9:        equ    1                                         ; SCI 0 baud rate Bit 9
SCIBDH_SBR10:       equ    2                                         ; SCI 0 baud rate Bit 10
SCIBDH_SBR11:       equ    3                                         ; SCI 0 baud rate Bit 11
SCIBDH_SBR12:       equ    4                                         ; SCI 0 baud rate Bit 12
SCIBDH_TNP0:        equ    5                                         ; Transmitter Narrow Pulse Bit 0
SCIBDH_TNP1:        equ    6                                         ; Transmitter Narrow Pulse Bit 1
SCIBDH_IREN:        equ    7                                         ; Infrared Enable Bit
; bit position masks
mSCIBDH_SBR8:       equ    %00000001
mSCIBDH_SBR9:       equ    %00000010
mSCIBDH_SBR10:      equ    %00000100
mSCIBDH_SBR11:      equ    %00001000
mSCIBDH_SBR12:      equ    %00010000
mSCIBDH_TNP0:       equ    %00100000
mSCIBDH_TNP1:       equ    %01000000
mSCIBDH_IREN:       equ    %10000000


;*** SCIBDL - SCI Baud Rate Register Low; 0x000000C9 ***
SCIBDL:             equ    $000000C9                                ;*** SCIBDL - SCI Baud Rate Register Low; 0x000000C9 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCIBDL_SBR0:        equ    0                                         ; SCI 0 baud rate Bit 0
SCIBDL_SBR1:        equ    1                                         ; SCI 0 baud rate Bit 1
SCIBDL_SBR2:        equ    2                                         ; SCI 0 baud rate Bit 2
SCIBDL_SBR3:        equ    3                                         ; SCI 0 baud rate Bit 3
SCIBDL_SBR4:        equ    4                                         ; SCI 0 baud rate Bit 4
SCIBDL_SBR5:        equ    5                                         ; SCI 0 baud rate Bit 5
SCIBDL_SBR6:        equ    6                                         ; SCI 0 baud rate Bit 6
SCIBDL_SBR7:        equ    7                                         ; SCI 0 baud rate Bit 7
; bit position masks
mSCIBDL_SBR0:       equ    %00000001
mSCIBDL_SBR1:       equ    %00000010
mSCIBDL_SBR2:       equ    %00000100
mSCIBDL_SBR3:       equ    %00001000
mSCIBDL_SBR4:       equ    %00010000
mSCIBDL_SBR5:       equ    %00100000
mSCIBDL_SBR6:       equ    %01000000
mSCIBDL_SBR7:       equ    %10000000


;*** SCICR1 - SCI Control Register 1; 0x000000CA ***
SCICR1:             equ    $000000CA                                ;*** SCICR1 - SCI Control Register 1; 0x000000CA ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCICR1_PT:          equ    0                                         ; Parity Type Bit
SCICR1_PE:          equ    1                                         ; Parity Enable Bit
SCICR1_ILT:         equ    2                                         ; Idle Line Type Bit
SCICR1_WAKE:        equ    3                                         ; Wakeup Condition Bit
SCICR1_M:           equ    4                                         ; Data Format Mode Bit
SCICR1_RSRC:        equ    5                                         ; Receiver Source Bit
SCICR1_SCISWAI:     equ    6                                         ; SCI 0 Stop in Wait Mode Bit
SCICR1_LOOPS:       equ    7                                         ; Loop Select Bit
; bit position masks
mSCICR1_PT:         equ    %00000001
mSCICR1_PE:         equ    %00000010
mSCICR1_ILT:        equ    %00000100
mSCICR1_WAKE:       equ    %00001000
mSCICR1_M:          equ    %00010000
mSCICR1_RSRC:       equ    %00100000
mSCICR1_SCISWAI:    equ    %01000000
mSCICR1_LOOPS:      equ    %10000000


;*** SCICR2 - SCI Control Register 2; 0x000000CB ***
SCICR2:             equ    $000000CB                                ;*** SCICR2 - SCI Control Register 2; 0x000000CB ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCICR2_SBK:         equ    0                                         ; Send Break Bit
SCICR2_RWU:         equ    1                                         ; Receiver Wakeup Bit
SCICR2_RE:          equ    2                                         ; Receiver Enable Bit
SCICR2_TE:          equ    3                                         ; Transmitter Enable Bit
SCICR2_ILIE:        equ    4                                         ; Idle Line Interrupt Enable Bit
SCICR2_RIE:         equ    5                                         ; Receiver Full Interrupt Enable Bit
SCICR2_TCIE:        equ    6                                         ; Transmission Complete Interrupt Enable Bit
SCICR2_SCTIE:       equ    7                                         ; Transmitter Interrupt Enable Bit
; bit position masks
mSCICR2_SBK:        equ    %00000001
mSCICR2_RWU:        equ    %00000010
mSCICR2_RE:         equ    %00000100
mSCICR2_TE:         equ    %00001000
mSCICR2_ILIE:       equ    %00010000
mSCICR2_RIE:        equ    %00100000
mSCICR2_TCIE:       equ    %01000000
mSCICR2_SCTIE:      equ    %10000000


;*** SCISR1 - SCI Status Register 1; 0x000000CC ***
SCISR1:             equ    $000000CC                                ;*** SCISR1 - SCI Status Register 1; 0x000000CC ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCISR1_PF:          equ    0                                         ; Parity Error Flag
SCISR1_FE:          equ    1                                         ; Framing Error Flag
SCISR1_NF:          equ    2                                         ; Noise Flag
SCISR1_OR:          equ    3                                         ; Overrun Flag
SCISR1_IDLE:        equ    4                                         ; Idle Line Flag
SCISR1_RDRF:        equ    5                                         ; Receive Data Register Full Flag
SCISR1_TC:          equ    6                                         ; Transmit Complete Flag
SCISR1_TDRE:        equ    7                                         ; Transmit Data Register Empty Flag
; bit position masks
mSCISR1_PF:         equ    %00000001
mSCISR1_FE:         equ    %00000010
mSCISR1_NF:         equ    %00000100
mSCISR1_OR:         equ    %00001000
mSCISR1_IDLE:       equ    %00010000
mSCISR1_RDRF:       equ    %00100000
mSCISR1_TC:         equ    %01000000
mSCISR1_TDRE:       equ    %10000000


;*** SCISR2 - SCI Status Register 2; 0x000000CD ***
SCISR2:             equ    $000000CD                                ;*** SCISR2 - SCI Status Register 2; 0x000000CD ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCISR2_RAF:         equ    0                                         ; Receiver Active Flag
SCISR2_TXDIR:       equ    1                                         ; Transmitter pin data direction in Single-Wire mode
SCISR2_BRK13:       equ    2                                         ; Break Transmit character length
; bit position masks
mSCISR2_RAF:        equ    %00000001
mSCISR2_TXDIR:      equ    %00000010
mSCISR2_BRK13:      equ    %00000100


;*** SCIDR - SCI Data Register; 0x000000CE ***
SCIDR:              equ    $000000CE                                ;*** SCIDR - SCI Data Register; 0x000000CE ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCIDR_R0_T0:        equ    0                                         ; Received bit 0 or Transmit bit 0
SCIDR_R1_T1:        equ    1                                         ; Received bit 1 or Transmit bit 1
SCIDR_R2_T2:        equ    2                                         ; Received bit 2 or Transmit bit 2
SCIDR_R3_T3:        equ    3                                         ; Received bit 3 or Transmit bit 3
SCIDR_R4_T4:        equ    4                                         ; Received bit 4 or Transmit bit 4
SCIDR_R5_T5:        equ    5                                         ; Received bit 5 or Transmit bit 5
SCIDR_R6_T6:        equ    6                                         ; Received bit 6 or Transmit bit 6
SCIDR_R7_T7:        equ    7                                         ; Received bit 7 or Transmit bit 7
SCIDR_T8:           equ    14                                        ; Transmit Bit 8
SCIDR_R8:           equ    15                                        ; Received Bit 8
; bit position masks
mSCIDR_R0_T0:       equ    %00000001
mSCIDR_R1_T1:       equ    %00000010
mSCIDR_R2_T2:       equ    %00000100
mSCIDR_R3_T3:       equ    %00001000
mSCIDR_R4_T4:       equ    %00010000
mSCIDR_R5_T5:       equ    %00100000
mSCIDR_R6_T6:       equ    %01000000
mSCIDR_R7_T7:       equ    %10000000
mSCIDR_T8:          equ    %100000000000000
mSCIDR_R8:          equ    %1000000000000000


;*** SCIDRH - SCI Data Register High; 0x000000CE ***
SCIDRH:             equ    $000000CE                                ;*** SCIDRH - SCI Data Register High; 0x000000CE ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCIDRH_T8:          equ    6                                         ; Transmit Bit 8
SCIDRH_R8:          equ    7                                         ; Received Bit 8
; bit position masks
mSCIDRH_T8:         equ    %01000000
mSCIDRH_R8:         equ    %10000000


;*** SCIDRL - SCI Data Register Low; 0x000000CF ***
SCIDRL:             equ    $000000CF                                ;*** SCIDRL - SCI Data Register Low; 0x000000CF ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCIDRL_R0_T0:       equ    0                                         ; Received Bit 0 or transmit Bit 0
SCIDRL_R1_T1:       equ    1                                         ; Received Bit 1 or transmit Bit 1
SCIDRL_R2_T2:       equ    2                                         ; Received Bit 2 or transmit Bit 2
SCIDRL_R3_T3:       equ    3                                         ; Received Bit 3 or transmit Bit 3
SCIDRL_R4_T4:       equ    4                                         ; Received Bit 4 or transmit Bit 4
SCIDRL_R5_T5:       equ    5                                         ; Received Bit 5 or transmit Bit 5
SCIDRL_R6_T6:       equ    6                                         ; Received Bit 6 or transmit Bit 6
SCIDRL_R7_T7:       equ    7                                         ; Received Bit 7 or transmit Bit 7
; bit position masks
mSCIDRL_R0_T0:      equ    %00000001
mSCIDRL_R1_T1:      equ    %00000010
mSCIDRL_R2_T2:      equ    %00000100
mSCIDRL_R3_T3:      equ    %00001000
mSCIDRL_R4_T4:      equ    %00010000
mSCIDRL_R5_T5:      equ    %00100000
mSCIDRL_R6_T6:      equ    %01000000
mSCIDRL_R7_T7:      equ    %10000000


;*** FCLKDIV - Flash Clock Divider Register; 0x00000100 ***
FCLKDIV:            equ    $00000100                                ;*** FCLKDIV - Flash Clock Divider Register; 0x00000100 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FCLKDIV_FDIV0:      equ    0                                         ; Flash Clock Divider Bit 0
FCLKDIV_FDIV1:      equ    1                                         ; Flash Clock Divider Bit 1
FCLKDIV_FDIV2:      equ    2                                         ; Flash Clock Divider Bit 2
FCLKDIV_FDIV3:      equ    3                                         ; Flash Clock Divider Bit 3
FCLKDIV_FDIV4:      equ    4                                         ; Flash Clock Divider Bit 4
FCLKDIV_FDIV5:      equ    5                                         ; Flash Clock Divider Bit 5
FCLKDIV_PRDIV8:     equ    6                                         ; Enable Prescaler by 8
FCLKDIV_FDIVLD:     equ    7                                         ; Flash Clock Divider Loaded
; bit position masks
mFCLKDIV_FDIV0:     equ    %00000001
mFCLKDIV_FDIV1:     equ    %00000010
mFCLKDIV_FDIV2:     equ    %00000100
mFCLKDIV_FDIV3:     equ    %00001000
mFCLKDIV_FDIV4:     equ    %00010000
mFCLKDIV_FDIV5:     equ    %00100000
mFCLKDIV_PRDIV8:    equ    %01000000
mFCLKDIV_FDIVLD:    equ    %10000000


;*** FSEC - Flash Security Register; 0x00000101 ***
FSEC:               equ    $00000101                                ;*** FSEC - Flash Security Register; 0x00000101 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FSEC_SEC0:          equ    0                                         ; Memory security bit 0
FSEC_SEC1:          equ    1                                         ; Memory security bit 1
FSEC_NV2:           equ    2                                         ; Non Volatile flag bit 2
FSEC_NV3:           equ    3                                         ; Non Volatile flag bit 3
FSEC_NV4:           equ    4                                         ; Non Volatile flag bit 4
FSEC_NV5:           equ    5                                         ; Non Volatile flag bit 5
FSEC_KEYEN0:        equ    6                                         ; Bit 0 of Backdoor Key Security Enable
FSEC_KEYEN1:        equ    7                                         ; Bit 1 of Backdoor Key Security Enable
; bit position masks
mFSEC_SEC0:         equ    %00000001
mFSEC_SEC1:         equ    %00000010
mFSEC_NV2:          equ    %00000100
mFSEC_NV3:          equ    %00001000
mFSEC_NV4:          equ    %00010000
mFSEC_NV5:          equ    %00100000
mFSEC_KEYEN0:       equ    %01000000
mFSEC_KEYEN1:       equ    %10000000


;*** FCNFG - Flash Configuration Register; 0x00000103 ***
FCNFG:              equ    $00000103                                ;*** FCNFG - Flash Configuration Register; 0x00000103 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FCNFG_KEYACC:       equ    5                                         ; Enable Security Key Writing
FCNFG_CCIE:         equ    6                                         ; Command Complete Interrupt Enable
FCNFG_CBEIE:        equ    7                                         ; Command Buffers Empty Interrupt Enable
; bit position masks
mFCNFG_KEYACC:      equ    %00100000
mFCNFG_CCIE:        equ    %01000000
mFCNFG_CBEIE:       equ    %10000000


;*** FPROT - Flash Protection Register; 0x00000104 ***
FPROT:              equ    $00000104                                ;*** FPROT - Flash Protection Register; 0x00000104 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FPROT_FPLS0:        equ    0                                         ; Flash Protection Lower Address size 0
FPROT_FPLS1:        equ    1                                         ; Flash Protection Lower Address size 1
FPROT_FPLDIS:       equ    2                                         ; Flash Protection Lower address range disable
FPROT_FPHS0:        equ    3                                         ; Flash Protection Higher address size 0
FPROT_FPHS1:        equ    4                                         ; Flash Protection Higher address size 1
FPROT_FPHDIS:       equ    5                                         ; Flash Protection Higher address range disable
FPROT_NV6:          equ    6                                         ; Non Volatile Flag Bit
FPROT_FPOPEN:       equ    7                                         ; Opens the flash block or subsections of it for program or erase
; bit position masks
mFPROT_FPLS0:       equ    %00000001
mFPROT_FPLS1:       equ    %00000010
mFPROT_FPLDIS:      equ    %00000100
mFPROT_FPHS0:       equ    %00001000
mFPROT_FPHS1:       equ    %00010000
mFPROT_FPHDIS:      equ    %00100000
mFPROT_NV6:         equ    %01000000
mFPROT_FPOPEN:      equ    %10000000


;*** FSTAT - Flash Status Register; 0x00000105 ***
FSTAT:              equ    $00000105                                ;*** FSTAT - Flash Status Register; 0x00000105 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FSTAT_BLANK:        equ    2                                         ; Blank Verify Flag
FSTAT_ACCERR:       equ    4                                         ; Access error
FSTAT_PVIOL:        equ    5                                         ; Protection violation
FSTAT_CCIF:         equ    6                                         ; Command Complete Interrupt Flag
FSTAT_CBEIF:        equ    7                                         ; Command Buffers Empty Interrupt Flag
; bit position masks
mFSTAT_BLANK:       equ    %00000100
mFSTAT_ACCERR:      equ    %00010000
mFSTAT_PVIOL:       equ    %00100000
mFSTAT_CCIF:        equ    %01000000
mFSTAT_CBEIF:       equ    %10000000


;*** FCMD - Flash Command Buffer and Register; 0x00000106 ***
FCMD:               equ    $00000106                                ;*** FCMD - Flash Command Buffer and Register; 0x00000106 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FCMD_CMDB0:         equ    0                                         ; NVM User Mode Command Bit 0
FCMD_CMDB2:         equ    2                                         ; NVM User Mode Command Bit 2
FCMD_CMDB5:         equ    5                                         ; NVM User Mode Command Bit 5
FCMD_CMDB6:         equ    6                                         ; NVM User Mode Command Bit 6
; bit position masks
mFCMD_CMDB0:        equ    %00000001
mFCMD_CMDB2:        equ    %00000100
mFCMD_CMDB5:        equ    %00100000
mFCMD_CMDB6:        equ    %01000000


;*** FADDR - Flash Address Register (High; 0x00000108 ***
FADDR:              equ    $00000108                                ;*** FADDR - Flash Address Register (High; 0x00000108 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FADDR_BIT0:         equ    0                                         ; Flash Address Register Bit 0
FADDR_BIT1:         equ    1                                         ; Flash Address Register Bit 1
FADDR_BIT2:         equ    2                                         ; Flash Address Register Bit 2
FADDR_BIT3:         equ    3                                         ; Flash Address Register Bit 3
FADDR_BIT4:         equ    4                                         ; Flash Address Register Bit 4
FADDR_BIT5:         equ    5                                         ; Flash Address Register Bit 5
FADDR_BIT6:         equ    6                                         ; Flash Address Register Bit 6
FADDR_BIT7:         equ    7                                         ; Flash Address Register Bit 7
FADDR_BIT8:         equ    8                                         ; Flash Address Register Bit 8
FADDR_BIT9:         equ    9                                         ; Flash Address Register Bit 9
FADDR_BIT10:        equ    10                                        ; Flash Address Register Bit 10
FADDR_BIT11:        equ    11                                        ; Flash Address Register Bit 11
FADDR_BIT12:        equ    12                                        ; Flash Address Register Bit 12
FADDR_BIT13:        equ    13                                        ; Flash Address Register Bit 13
; bit position masks
mFADDR_BIT0:        equ    %00000001
mFADDR_BIT1:        equ    %00000010
mFADDR_BIT2:        equ    %00000100
mFADDR_BIT3:        equ    %00001000
mFADDR_BIT4:        equ    %00010000
mFADDR_BIT5:        equ    %00100000
mFADDR_BIT6:        equ    %01000000
mFADDR_BIT7:        equ    %10000000
mFADDR_BIT8:        equ    %100000000
mFADDR_BIT9:        equ    %1000000000
mFADDR_BIT10:       equ    %10000000000
mFADDR_BIT11:       equ    %100000000000
mFADDR_BIT12:       equ    %1000000000000
mFADDR_BIT13:       equ    %10000000000000


;*** FADDRHi - Flash Address High Register; 0x00000108 ***
FADDRHi:            equ    $00000108                                ;*** FADDRHi - Flash Address High Register; 0x00000108 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FADDRHi_BIT8:       equ    0                                         ; Flash Address Register Bit 8
FADDRHi_BIT9:       equ    1                                         ; Flash Address Register Bit 9
FADDRHi_BIT10:      equ    2                                         ; Flash Address Register Bit 10
FADDRHi_BIT11:      equ    3                                         ; Flash Address Register Bit 11
FADDRHi_BIT12:      equ    4                                         ; Flash Address Register Bit 12
FADDRHi_BIT13:      equ    5                                         ; Flash Address Register Bit 13
; bit position masks
mFADDRHi_BIT8:      equ    %00000001
mFADDRHi_BIT9:      equ    %00000010
mFADDRHi_BIT10:     equ    %00000100
mFADDRHi_BIT11:     equ    %00001000
mFADDRHi_BIT12:     equ    %00010000
mFADDRHi_BIT13:     equ    %00100000


;*** FADDRLo - Flash Address Low Register; 0x00000109 ***
FADDRLo:            equ    $00000109                                ;*** FADDRLo - Flash Address Low Register; 0x00000109 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FADDRLo_BIT0:       equ    0                                         ; Flash Address Register Bit 0
FADDRLo_BIT1:       equ    1                                         ; Flash Address Register Bit 1
FADDRLo_BIT2:       equ    2                                         ; Flash Address Register Bit 2
FADDRLo_BIT3:       equ    3                                         ; Flash Address Register Bit 3
FADDRLo_BIT4:       equ    4                                         ; Flash Address Register Bit 4
FADDRLo_BIT5:       equ    5                                         ; Flash Address Register Bit 5
FADDRLo_BIT6:       equ    6                                         ; Flash Address Register Bit 6
FADDRLo_BIT7:       equ    7                                         ; Flash Address Register Bit 7
; bit position masks
mFADDRLo_BIT0:      equ    %00000001
mFADDRLo_BIT1:      equ    %00000010
mFADDRLo_BIT2:      equ    %00000100
mFADDRLo_BIT3:      equ    %00001000
mFADDRLo_BIT4:      equ    %00010000
mFADDRLo_BIT5:      equ    %00100000
mFADDRLo_BIT6:      equ    %01000000
mFADDRLo_BIT7:      equ    %10000000


;*** FDATA - Flash Data Register (high; 0x0000010A ***
FDATA:              equ    $0000010A                                ;*** FDATA - Flash Data Register (high; 0x0000010A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FDATA_BIT0:         equ    0                                         ; Flash data Register Bit 0
FDATA_BIT1:         equ    1                                         ; Flash data Register Bit 1
FDATA_BIT2:         equ    2                                         ; Flash data Register Bit 2
FDATA_BIT3:         equ    3                                         ; Flash data Register Bit 3
FDATA_BIT4:         equ    4                                         ; Flash data Register Bit 4
FDATA_BIT5:         equ    5                                         ; Flash data Register Bit 5
FDATA_BIT6:         equ    6                                         ; Flash data Register Bit 6
FDATA_BIT7:         equ    7                                         ; Flash data Register Bit 7
FDATA_BIT8:         equ    8                                         ; Flash data Register Bit 8
FDATA_BIT9:         equ    9                                         ; Flash data Register Bit 9
FDATA_BIT10:        equ    10                                        ; Flash data Register Bit 10
FDATA_BIT11:        equ    11                                        ; Flash data Register Bit 11
FDATA_BIT12:        equ    12                                        ; Flash data Register Bit 12
FDATA_BIT13:        equ    13                                        ; Flash data Register Bit 13
FDATA_BIT14:        equ    14                                        ; Flash data Register Bit 14
FDATA_BIT15:        equ    15                                        ; Flash data Register Bit 15
; bit position masks
mFDATA_BIT0:        equ    %00000001
mFDATA_BIT1:        equ    %00000010
mFDATA_BIT2:        equ    %00000100
mFDATA_BIT3:        equ    %00001000
mFDATA_BIT4:        equ    %00010000
mFDATA_BIT5:        equ    %00100000
mFDATA_BIT6:        equ    %01000000
mFDATA_BIT7:        equ    %10000000
mFDATA_BIT8:        equ    %100000000
mFDATA_BIT9:        equ    %1000000000
mFDATA_BIT10:       equ    %10000000000
mFDATA_BIT11:       equ    %100000000000
mFDATA_BIT12:       equ    %1000000000000
mFDATA_BIT13:       equ    %10000000000000
mFDATA_BIT14:       equ    %100000000000000
mFDATA_BIT15:       equ    %1000000000000000


;*** FDATAHi - Flash Data Register (high byte); 0x0000010A ***
FDATAHi:            equ    $0000010A                                ;*** FDATAHi - Flash Data Register (high byte); 0x0000010A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FDATAHi_BIT8:       equ    0                                         ; Flash data Register Bit 8
FDATAHi_BIT9:       equ    1                                         ; Flash data Register Bit 9
FDATAHi_BIT10:      equ    2                                         ; Flash data Register Bit 10
FDATAHi_BIT11:      equ    3                                         ; Flash data Register Bit 11
FDATAHi_BIT12:      equ    4                                         ; Flash data Register Bit 12
FDATAHi_BIT13:      equ    5                                         ; Flash data Register Bit 13
FDATAHi_BIT14:      equ    6                                         ; Flash data Register Bit 14
FDATAHi_BIT15:      equ    7                                         ; Flash data Register Bit 15
; bit position masks
mFDATAHi_BIT8:      equ    %00000001
mFDATAHi_BIT9:      equ    %00000010
mFDATAHi_BIT10:     equ    %00000100
mFDATAHi_BIT11:     equ    %00001000
mFDATAHi_BIT12:     equ    %00010000
mFDATAHi_BIT13:     equ    %00100000
mFDATAHi_BIT14:     equ    %01000000
mFDATAHi_BIT15:     equ    %10000000


;*** FDATALo - Flash Data Register (low byte); 0x0000010B ***
FDATALo:            equ    $0000010B                                ;*** FDATALo - Flash Data Register (low byte); 0x0000010B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FDATALo_BIT0:       equ    0                                         ; Flash data Register Bit 0
FDATALo_BIT1:       equ    1                                         ; Flash data Register Bit 1
FDATALo_BIT2:       equ    2                                         ; Flash data Register Bit 2
FDATALo_BIT3:       equ    3                                         ; Flash data Register Bit 3
FDATALo_BIT4:       equ    4                                         ; Flash data Register Bit 4
FDATALo_BIT5:       equ    5                                         ; Flash data Register Bit 5
FDATALo_BIT6:       equ    6                                         ; Flash data Register Bit 6
FDATALo_BIT7:       equ    7                                         ; Flash data Register Bit 7
; bit position masks
mFDATALo_BIT0:      equ    %00000001
mFDATALo_BIT1:      equ    %00000010
mFDATALo_BIT2:      equ    %00000100
mFDATALo_BIT3:      equ    %00001000
mFDATALo_BIT4:      equ    %00010000
mFDATALo_BIT5:      equ    %00100000
mFDATALo_BIT6:      equ    %01000000
mFDATALo_BIT7:      equ    %10000000


;*** SMRAMCFG - SMRAM Configuration Register; 0x0000011C ***
SMRAMCFG:           equ    $0000011C                                ;*** SMRAMCFG - SMRAM Configuration Register; 0x0000011C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SMRAMCFG_SMMODE:    equ    0                                         ; SmartMedia mode
; bit position masks
mSMRAMCFG_SMMODE:   equ    %00000001


;*** SMRAMSTAT - SMRAM Status Register; 0x0000011D ***
SMRAMSTAT:          equ    $0000011D                                ;*** SMRAMSTAT - SMRAM Status Register; 0x0000011D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SMRAMSTAT_PSMBA:    equ    0                                         ; Parity of the SmartMedia Block Address
; bit position masks
mSMRAMSTAT_PSMBA:   equ    %00000001


;*** HCFG - Host Configuration Register; 0x000001C0 ***
HCFG:               equ    $000001C0                                ;*** HCFG - Host Configuration Register; 0x000001C0 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
HCFG_IORDY_EN:      equ    8                                         ; Enable ATA_IORDY function
HCFG_IE:            equ    9                                         ; Interrupt Enable
HCFG_XNW:           equ    10                                        ; IPS_XFR_WAIT support
HCFG_CLK_EN:        equ    11                                        ; module core clock Enable function
HCFG_FR:            equ    14                                        ; FIFO Reset
HCFG_SMR:           equ    15                                        ; State Machine Reset
; bit position masks
mHCFG_IORDY_EN:     equ    %100000000
mHCFG_IE:           equ    %1000000000
mHCFG_XNW:          equ    %10000000000
mHCFG_CLK_EN:       equ    %100000000000
mHCFG_FR:           equ    %100000000000000
mHCFG_SMR:          equ    %1000000000000000


;*** HSR - Host Status Register; 0x000001C2 ***
HSR:                equ    $000001C2                                ;*** HSR - Host Status Register; 0x000001C2 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
HSR_WERR:           equ    8                                         ; Write on unimplemented register(Read only, clear by writing one)
HSR_RERR:           equ    9                                         ; Read on unimplemented register(Read only, clear by writing one)
HSR_FE_HSR:         equ    10                                        ; FIFO Empty Flag
HSR_FF:             equ    11                                        ; FIFO Full Flag
HSR_DRAB:           equ    13                                        ; Device Register Access Busy (Read only)
HSR_UREP:           equ    14                                        ; UDMA Read extended pause
HSR_TIP:            equ    15                                        ; transfer in progress
; bit position masks
mHSR_WERR:          equ    %100000000
mHSR_RERR:          equ    %1000000000
mHSR_FE_HSR:        equ    %10000000000
mHSR_FF:            equ    %100000000000
mHSR_DRAB:          equ    %10000000000000
mHSR_UREP:          equ    %100000000000000
mHSR_TIP:           equ    %1000000000000000


;*** HPIO1 - PIO Timing Register 1; 0x000001C4 ***
HPIO1:              equ    $000001C4                                ;*** HPIO1 - PIO Timing Register 1; 0x000001C4 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
HPIO1_PIO_T2_80:    equ    0                                         ; ATA-5 standard PIO timing t2 for 8-bit transfer Bit 0
HPIO1_PIO_T2_81:    equ    1                                         ; ATA-5 standard PIO timing t2 for 8-bit transfer Bit 1
HPIO1_PIO_T2_82:    equ    2                                         ; ATA-5 standard PIO timing t2 for 8-bit transfer Bit 2
HPIO1_PIO_T2_83:    equ    3                                         ; ATA-5 standard PIO timing t2 for 8-bit transfer Bit 3
HPIO1_PIO_T2_84:    equ    4                                         ; ATA-5 standard PIO timing t2 for 8-bit transfer Bit 4
HPIO1_PIO_T2_85:    equ    5                                         ; ATA-5 standard PIO timing t2 for 8-bit transfer Bit 5
HPIO1_PIO_T00:      equ    8                                         ; ATA-5 standard PIO timing t0 Bit 0
HPIO1_PIO_T01:      equ    9                                         ; ATA-5 standard PIO timing t0 Bit 1
HPIO1_PIO_T02:      equ    10                                        ; ATA-5 standard PIO timing t0 Bit 2
HPIO1_PIO_T03:      equ    11                                        ; ATA-5 standard PIO timing t0 Bit 3
HPIO1_PIO_T04:      equ    12                                        ; ATA-5 standard PIO timing t0 Bit 4
HPIO1_PIO_T05:      equ    13                                        ; ATA-5 standard PIO timing t0 Bit 5
HPIO1_PIO_T06:      equ    14                                        ; ATA-5 standard PIO timing t0 Bit 6
; bit position masks
mHPIO1_PIO_T2_80:   equ    %00000001
mHPIO1_PIO_T2_81:   equ    %00000010
mHPIO1_PIO_T2_82:   equ    %00000100
mHPIO1_PIO_T2_83:   equ    %00001000
mHPIO1_PIO_T2_84:   equ    %00010000
mHPIO1_PIO_T2_85:   equ    %00100000
mHPIO1_PIO_T00:     equ    %100000000
mHPIO1_PIO_T01:     equ    %1000000000
mHPIO1_PIO_T02:     equ    %10000000000
mHPIO1_PIO_T03:     equ    %100000000000
mHPIO1_PIO_T04:     equ    %1000000000000
mHPIO1_PIO_T05:     equ    %10000000000000
mHPIO1_PIO_T06:     equ    %100000000000000


;*** HPIO2 - PIO Timing Register 2; 0x000001C6 ***
HPIO2:              equ    $000001C6                                ;*** HPIO2 - PIO Timing Register 2; 0x000001C6 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
HPIO2_PIO_T2I0:     equ    0                                         ; ATA-5 standard PIO timing t2i Bit 0
HPIO2_PIO_T2I1:     equ    1                                         ; ATA-5 standard PIO timing t2i Bit 1
HPIO2_PIO_T2I2:     equ    2                                         ; ATA-5 standard PIO timing t2i Bit 2
HPIO2_PIO_T2I3:     equ    3                                         ; ATA-5 standard PIO timing t2i Bit 3
HPIO2_PIO_T2_160:   equ    8                                         ; ATA-5 standard PIO timing t2 for 16-bit transfer Bit 0
HPIO2_PIO_T2_161:   equ    9                                         ; ATA-5 standard PIO timing t2 for 16-bit transfer Bit 1
HPIO2_PIO_T2_162:   equ    10                                        ; ATA-5 standard PIO timing t2 for 16-bit transfer Bit 2
HPIO2_PIO_T2_163:   equ    11                                        ; ATA-5 standard PIO timing t2 for 16-bit transfer Bit 3
HPIO2_PIO_T2_164:   equ    12                                        ; ATA-5 standard PIO timing t2 for 16-bit transfer Bit 4
HPIO2_PIO_T2_165:   equ    13                                        ; ATA-5 standard PIO timing t2 for 16-bit transfer Bit 5
; bit position masks
mHPIO2_PIO_T2I0:    equ    %00000001
mHPIO2_PIO_T2I1:    equ    %00000010
mHPIO2_PIO_T2I2:    equ    %00000100
mHPIO2_PIO_T2I3:    equ    %00001000
mHPIO2_PIO_T2_160:  equ    %100000000
mHPIO2_PIO_T2_161:  equ    %1000000000
mHPIO2_PIO_T2_162:  equ    %10000000000
mHPIO2_PIO_T2_163:  equ    %100000000000
mHPIO2_PIO_T2_164:  equ    %1000000000000
mHPIO2_PIO_T2_165:  equ    %10000000000000


;*** HPIO3 - PIO Timing Register 3; 0x000001C8 ***
HPIO3:              equ    $000001C8                                ;*** HPIO3 - PIO Timing Register 3; 0x000001C8 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
HPIO3_PIO_T10:      equ    0                                         ; ATA-5 standard PIO timing t1 Bit 0
HPIO3_PIO_T11:      equ    1                                         ; ATA-5 standard PIO timing t1 Bit 1
HPIO3_PIO_T12:      equ    2                                         ; ATA-5 standard PIO timing t1 Bit 2
HPIO3_PIO_T13:      equ    3                                         ; ATA-5 standard PIO timing t1 Bit 3
HPIO3_PIO_T40:      equ    8                                         ; ATA-5 standard PIO timing t4 Bit 0
HPIO3_PIO_T41:      equ    9                                         ; ATA-5 standard PIO timing t4 Bit 1
HPIO3_PIO_T42:      equ    10                                        ; ATA-5 standard PIO timing t4 Bit 2
; bit position masks
mHPIO3_PIO_T10:     equ    %00000001
mHPIO3_PIO_T11:     equ    %00000010
mHPIO3_PIO_T12:     equ    %00000100
mHPIO3_PIO_T13:     equ    %00001000
mHPIO3_PIO_T40:     equ    %100000000
mHPIO3_PIO_T41:     equ    %1000000000
mHPIO3_PIO_T42:     equ    %10000000000


;*** HPIO4 - PIO Timing Register 4; 0x000001CA ***
HPIO4:              equ    $000001CA                                ;*** HPIO4 - PIO Timing Register 4; 0x000001CA ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
HPIO4_PIO_TA0:      equ    8                                         ; ATA-5 standard PIO timing ta Bit 0
HPIO4_PIO_TA1:      equ    9                                         ; ATA-5 standard PIO timing ta Bit 1
HPIO4_PIO_TA2:      equ    10                                        ; ATA-5 standard PIO timing ta Bit 2
; bit position masks
mHPIO4_PIO_TA0:     equ    %100000000
mHPIO4_PIO_TA1:     equ    %1000000000
mHPIO4_PIO_TA2:     equ    %10000000000


;*** HDMA1 - DMA Timing Register 1; 0x000001CC ***
HDMA1:              equ    $000001CC                                ;*** HDMA1 - DMA Timing Register 1; 0x000001CC ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
HDMA1_DMA_TD0:      equ    0                                         ; ATA-5 standard DMA timing tD Bit 0
HDMA1_DMA_TD1:      equ    1                                         ; ATA-5 standard DMA timing tD Bit 1
HDMA1_DMA_TD2:      equ    2                                         ; ATA-5 standard DMA timing tD Bit 2
HDMA1_DMA_TD3:      equ    3                                         ; ATA-5 standard DMA timing tD Bit 3
HDMA1_DMA_TD4:      equ    4                                         ; ATA-5 standard DMA timing tD Bit 4
HDMA1_DMA_TD5:      equ    5                                         ; ATA-5 standard DMA timing tD Bit 5
HDMA1_DMA_T00:      equ    8                                         ; ATA-5 standard DMA timing t0 Bit 0
HDMA1_DMA_T01:      equ    9                                         ; ATA-5 standard DMA timing t0 Bit 1
HDMA1_DMA_T02:      equ    10                                        ; ATA-5 standard DMA timing t0 Bit 2
HDMA1_DMA_T03:      equ    11                                        ; ATA-5 standard DMA timing t0 Bit 3
HDMA1_DMA_T04:      equ    12                                        ; ATA-5 standard DMA timing t0 Bit 4
HDMA1_DMA_T05:      equ    13                                        ; ATA-5 standard DMA timing t0 Bit 5
HDMA1_DMA_T06:      equ    14                                        ; ATA-5 standard DMA timing t0 Bit 6
; bit position masks
mHDMA1_DMA_TD0:     equ    %00000001
mHDMA1_DMA_TD1:     equ    %00000010
mHDMA1_DMA_TD2:     equ    %00000100
mHDMA1_DMA_TD3:     equ    %00001000
mHDMA1_DMA_TD4:     equ    %00010000
mHDMA1_DMA_TD5:     equ    %00100000
mHDMA1_DMA_T00:     equ    %100000000
mHDMA1_DMA_T01:     equ    %1000000000
mHDMA1_DMA_T02:     equ    %10000000000
mHDMA1_DMA_T03:     equ    %100000000000
mHDMA1_DMA_T04:     equ    %1000000000000
mHDMA1_DMA_T05:     equ    %10000000000000
mHDMA1_DMA_T06:     equ    %100000000000000


;*** HDMA2 - DMA Timing Register 2; 0x000001CE ***
HDMA2:              equ    $000001CE                                ;*** HDMA2 - DMA Timing Register 2; 0x000001CE ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
HDMA2_DMA_TM0:      equ    0                                         ; ATA-5 standard DMA timing tm Bit 0
HDMA2_DMA_TM1:      equ    1                                         ; ATA-5 standard DMA timing tm Bit 1
HDMA2_DMA_TM2:      equ    2                                         ; ATA-5 standard DMA timing tm Bit 2
HDMA2_DMA_TM3:      equ    3                                         ; ATA-5 standard DMA timing tm Bit 3
HDMA2_DMA_TK0:      equ    8                                         ; ATA-5 standard DMA timing tK Bit 0
HDMA2_DMA_TK1:      equ    9                                         ; ATA-5 standard DMA timing tK Bit 1
HDMA2_DMA_TK2:      equ    10                                        ; ATA-5 standard DMA timing tK Bit 2
HDMA2_DMA_TK3:      equ    11                                        ; ATA-5 standard DMA timing tK Bit 3
HDMA2_DMA_TK4:      equ    12                                        ; ATA-5 standard DMA timing tK Bit 4
HDMA2_DMA_TK5:      equ    13                                        ; ATA-5 standard DMA timing tK Bit 5
; bit position masks
mHDMA2_DMA_TM0:     equ    %00000001
mHDMA2_DMA_TM1:     equ    %00000010
mHDMA2_DMA_TM2:     equ    %00000100
mHDMA2_DMA_TM3:     equ    %00001000
mHDMA2_DMA_TK0:     equ    %100000000
mHDMA2_DMA_TK1:     equ    %1000000000
mHDMA2_DMA_TK2:     equ    %10000000000
mHDMA2_DMA_TK3:     equ    %100000000000
mHDMA2_DMA_TK4:     equ    %1000000000000
mHDMA2_DMA_TK5:     equ    %10000000000000


;*** HDMA3 - DMA Timing Register 3; 0x000001D0 ***
HDMA3:              equ    $000001D0                                ;*** HDMA3 - DMA Timing Register 3; 0x000001D0 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
HDMA3_DMA_TJ0:      equ    0                                         ; ATA-5 standard DMA timing tJ Bit 0
HDMA3_DMA_TJ1:      equ    1                                         ; ATA-5 standard DMA timing tJ Bit 1
HDMA3_DMA_TJ2:      equ    2                                         ; ATA-5 standard DMA timing tJ Bit 2
HDMA3_DMA_TH0:      equ    8                                         ; ATA-5 standard DMA timing tH Bit 0
HDMA3_DMA_TH1:      equ    9                                         ; ATA-5 standard DMA timing tH Bit 1
HDMA3_DMA_TH2:      equ    10                                        ; ATA-5 standard DMA timing tH Bit 2
; bit position masks
mHDMA3_DMA_TJ0:     equ    %00000001
mHDMA3_DMA_TJ1:     equ    %00000010
mHDMA3_DMA_TJ2:     equ    %00000100
mHDMA3_DMA_TH0:     equ    %100000000
mHDMA3_DMA_TH1:     equ    %1000000000
mHDMA3_DMA_TH2:     equ    %10000000000


;*** HDMA4 - DMA Timing Register 4; 0x000001D2 ***
HDMA4:              equ    $000001D2                                ;*** HDMA4 - DMA Timing Register 4; 0x000001D2 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
HDMA4_DMA_TN0:      equ    8                                         ; ATA-5 standard DMA timing tN Bit 0
HDMA4_DMA_TN1:      equ    9                                         ; ATA-5 standard DMA timing tN Bit 1
HDMA4_DMA_TN2:      equ    10                                        ; ATA-5 standard DMA timing tN Bit 2
; bit position masks
mHDMA4_DMA_TN0:     equ    %100000000
mHDMA4_DMA_TN1:     equ    %1000000000
mHDMA4_DMA_TN2:     equ    %10000000000


;*** HUDMA1 - UDMA Timing Register 1; 0x000001D4 ***
HUDMA1:             equ    $000001D4                                ;*** HUDMA1 - UDMA Timing Register 1; 0x000001D4 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
HUDMA1_UDMA_TCYC0:  equ    0                                         ; ATA-5 standard UDMA timing tCYC Bit 0
HUDMA1_UDMA_TCYC1:  equ    1                                         ; ATA-5 standard UDMA timing tCYC Bit 1
HUDMA1_UDMA_TCYC2:  equ    2                                         ; ATA-5 standard UDMA timing tCYC Bit 2
HUDMA1_UDMA_TCYC3:  equ    3                                         ; ATA-5 standard UDMA timing tCYC Bit 3
HUDMA1_UDMA_TCYC4:  equ    4                                         ; ATA-5 standard UDMA timing tCYC Bit 4
HUDMA1_UDMA_T2CYCTYP0: equ    8                                      ; ATA-5 standard UDMA timing t2CYCTYP Bit 0
HUDMA1_UDMA_T2CYCTYP1: equ    9                                      ; ATA-5 standard UDMA timing t2CYCTYP Bit 1
HUDMA1_UDMA_T2CYCTYP2: equ    10                                     ; ATA-5 standard UDMA timing t2CYCTYP Bit 2
HUDMA1_UDMA_T2CYCTYP3: equ    11                                     ; ATA-5 standard UDMA timing t2CYCTYP Bit 3
HUDMA1_UDMA_T2CYCTYP4: equ    12                                     ; ATA-5 standard UDMA timing t2CYCTYP Bit 4
HUDMA1_UDMA_T2CYCTYP5: equ    13                                     ; ATA-5 standard UDMA timing t2CYCTYP Bit 5
; bit position masks
mHUDMA1_UDMA_TCYC0: equ    %00000001
mHUDMA1_UDMA_TCYC1: equ    %00000010
mHUDMA1_UDMA_TCYC2: equ    %00000100
mHUDMA1_UDMA_TCYC3: equ    %00001000
mHUDMA1_UDMA_TCYC4: equ    %00010000
mHUDMA1_UDMA_T2CYCTYP0: equ    %100000000
mHUDMA1_UDMA_T2CYCTYP1: equ    %1000000000
mHUDMA1_UDMA_T2CYCTYP2: equ    %10000000000
mHUDMA1_UDMA_T2CYCTYP3: equ    %100000000000
mHUDMA1_UDMA_T2CYCTYP4: equ    %1000000000000
mHUDMA1_UDMA_T2CYCTYP5: equ    %10000000000000


;*** HUDMA2 - UDMA Timing Register 2; 0x000001D6 ***
HUDMA2:             equ    $000001D6                                ;*** HUDMA2 - UDMA Timing Register 2; 0x000001D6 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
HUDMA2_UDMA_TDH0:   equ    0                                         ; ATA-5 standard UDMA timing tDH Bit 0
HUDMA2_UDMA_TDH1:   equ    1                                         ; ATA-5 standard UDMA timing tDH Bit 1
HUDMA2_UDMA_TDH2:   equ    2                                         ; ATA-5 standard UDMA timing tDH Bit 2
HUDMA2_UDMA_TDS0:   equ    8                                         ; ATA-5 standard UDMA timing tDS Bit 0
HUDMA2_UDMA_TDS1:   equ    9                                         ; ATA-5 standard UDMA timing tDS Bit 1
HUDMA2_UDMA_TDS2:   equ    10                                        ; ATA-5 standard UDMA timing tDS Bit 2
; bit position masks
mHUDMA2_UDMA_TDH0:  equ    %00000001
mHUDMA2_UDMA_TDH1:  equ    %00000010
mHUDMA2_UDMA_TDH2:  equ    %00000100
mHUDMA2_UDMA_TDS0:  equ    %100000000
mHUDMA2_UDMA_TDS1:  equ    %1000000000
mHUDMA2_UDMA_TDS2:  equ    %10000000000


;*** HUDMA3 - UDMA Timing Register 3; 0x000001D8 ***
HUDMA3:             equ    $000001D8                                ;*** HUDMA3 - UDMA Timing Register 3; 0x000001D8 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
HUDMA3_UDMA_TDVH0:  equ    0                                         ; ATA-5 standard UDMA timing tDVH Bit 0
HUDMA3_UDMA_TDVH1:  equ    1                                         ; ATA-5 standard UDMA timing tDVH Bit 1
HUDMA3_UDMA_TDVH2:  equ    2                                         ; ATA-5 standard UDMA timing tDVH Bit 2
HUDMA3_UDMA_TDVS0:  equ    8                                         ; ATA-5 standard UDMA timing tDVS Bit 0
HUDMA3_UDMA_TDVS1:  equ    9                                         ; ATA-5 standard UDMA timing tDVS Bit 1
HUDMA3_UDMA_TDVS2:  equ    10                                        ; ATA-5 standard UDMA timing tDVS Bit 2
HUDMA3_UDMA_TDVS3:  equ    11                                        ; ATA-5 standard UDMA timing tDVS Bit 3
HUDMA3_UDMA_TDVS4:  equ    12                                        ; ATA-5 standard UDMA timing tDVS Bit 4
; bit position masks
mHUDMA3_UDMA_TDVH0: equ    %00000001
mHUDMA3_UDMA_TDVH1: equ    %00000010
mHUDMA3_UDMA_TDVH2: equ    %00000100
mHUDMA3_UDMA_TDVS0: equ    %100000000
mHUDMA3_UDMA_TDVS1: equ    %1000000000
mHUDMA3_UDMA_TDVS2: equ    %10000000000
mHUDMA3_UDMA_TDVS3: equ    %100000000000
mHUDMA3_UDMA_TDVS4: equ    %1000000000000


;*** HUDMA4 - UDMA Timing Register 4; 0x000001DA ***
HUDMA4:             equ    $000001DA                                ;*** HUDMA4 - UDMA Timing Register 4; 0x000001DA ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
HUDMA4_UDMA_TLI0:   equ    0                                         ; ATA-5 standard UDMA timing tLI Bit 0
HUDMA4_UDMA_TLI1:   equ    1                                         ; ATA-5 standard UDMA timing tLI Bit 1
HUDMA4_UDMA_TLI2:   equ    2                                         ; ATA-5 standard UDMA timing tLI Bit 2
HUDMA4_UDMA_TLI3:   equ    3                                         ; ATA-5 standard UDMA timing tLI Bit 3
HUDMA4_UDMA_TLI4:   equ    4                                         ; ATA-5 standard UDMA timing tLI Bit 4
HUDMA4_UDMA_TLI5:   equ    5                                         ; ATA-5 standard UDMA timing tLI Bit 5
HUDMA4_UDMA_TFS0:   equ    8                                         ; ATA-5 standard UDMA timing tFS Bit 0
HUDMA4_UDMA_TFS1:   equ    9                                         ; ATA-5 standard UDMA timing tFS Bit 1
HUDMA4_UDMA_TFS2:   equ    10                                        ; ATA-5 standard UDMA timing tFS Bit 2
HUDMA4_UDMA_TFS3:   equ    11                                        ; ATA-5 standard UDMA timing tFS Bit 3
HUDMA4_UDMA_TFS4:   equ    12                                        ; ATA-5 standard UDMA timing tFS Bit 4
HUDMA4_UDMA_TFS5:   equ    13                                        ; ATA-5 standard UDMA timing tFS Bit 5
; bit position masks
mHUDMA4_UDMA_TLI0:  equ    %00000001
mHUDMA4_UDMA_TLI1:  equ    %00000010
mHUDMA4_UDMA_TLI2:  equ    %00000100
mHUDMA4_UDMA_TLI3:  equ    %00001000
mHUDMA4_UDMA_TLI4:  equ    %00010000
mHUDMA4_UDMA_TLI5:  equ    %00100000
mHUDMA4_UDMA_TFS0:  equ    %100000000
mHUDMA4_UDMA_TFS1:  equ    %1000000000
mHUDMA4_UDMA_TFS2:  equ    %10000000000
mHUDMA4_UDMA_TFS3:  equ    %100000000000
mHUDMA4_UDMA_TFS4:  equ    %1000000000000
mHUDMA4_UDMA_TFS5:  equ    %10000000000000


;*** HUDMA5 - UDMA Timing Register 5; 0x000001DC ***
HUDMA5:             equ    $000001DC                                ;*** HUDMA5 - UDMA Timing Register 5; 0x000001DC ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
HUDMA5_UDMA_TAZ0:   equ    0                                         ; ATA-5 standard UDMA timing tAZ Bit 0
HUDMA5_UDMA_TAZ1:   equ    1                                         ; ATA-5 standard UDMA timing tAZ Bit 1
HUDMA5_UDMA_TAZ2:   equ    2                                         ; ATA-5 standard UDMA timing tAZ Bit 2
HUDMA5_UDMA_TMLI0:  equ    8                                         ; ATA-5 standard UDMA timing tMLI Bit 0
HUDMA5_UDMA_TMLI1:  equ    9                                         ; ATA-5 standard UDMA timing tMLI Bit 1
HUDMA5_UDMA_TMLI2:  equ    10                                        ; ATA-5 standard UDMA timing tMLI Bit 2
; bit position masks
mHUDMA5_UDMA_TAZ0:  equ    %00000001
mHUDMA5_UDMA_TAZ1:  equ    %00000010
mHUDMA5_UDMA_TAZ2:  equ    %00000100
mHUDMA5_UDMA_TMLI0: equ    %100000000
mHUDMA5_UDMA_TMLI1: equ    %1000000000
mHUDMA5_UDMA_TMLI2: equ    %10000000000


;*** HUDMA6 - UDMA Timing Register 6; 0x000001DE ***
HUDMA6:             equ    $000001DE                                ;*** HUDMA6 - UDMA Timing Register 6; 0x000001DE ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
HUDMA6_UDMA_TSR0:   equ    0                                         ; ATA-5 standard UDMA timing tSR Bit 0
HUDMA6_UDMA_TSR1:   equ    1                                         ; ATA-5 standard UDMA timing tSR Bit 1
HUDMA6_UDMA_TSR2:   equ    2                                         ; ATA-5 standard UDMA timing tSR Bit 2
HUDMA6_UDMA_TSR3:   equ    3                                         ; ATA-5 standard UDMA timing tSR Bit 3
HUDMA6_UDMA_TENV0:  equ    8                                         ; ATA-5 standard UDMA timing tENV Bit 0
HUDMA6_UDMA_TENV1:  equ    9                                         ; ATA-5 standard UDMA timing tENV Bit 1
HUDMA6_UDMA_TENV2:  equ    10                                        ; ATA-5 standard UDMA timing tENV Bit 2
HUDMA6_UDMA_TENV3:  equ    11                                        ; ATA-5 standard UDMA timing tENV Bit 3
HUDMA6_UDMA_TENV4:  equ    12                                        ; ATA-5 standard UDMA timing tENV Bit 4
; bit position masks
mHUDMA6_UDMA_TSR0:  equ    %00000001
mHUDMA6_UDMA_TSR1:  equ    %00000010
mHUDMA6_UDMA_TSR2:  equ    %00000100
mHUDMA6_UDMA_TSR3:  equ    %00001000
mHUDMA6_UDMA_TENV0: equ    %100000000
mHUDMA6_UDMA_TENV1: equ    %1000000000
mHUDMA6_UDMA_TENV2: equ    %10000000000
mHUDMA6_UDMA_TENV3: equ    %100000000000
mHUDMA6_UDMA_TENV4: equ    %1000000000000


;*** HUDMA7 - UDMA Timing Register 7; 0x000001E0 ***
HUDMA7:             equ    $000001E0                                ;*** HUDMA7 - UDMA Timing Register 7; 0x000001E0 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
HUDMA7_UDMA_TRFS0:  equ    0                                         ; ATA-5 standard UDMA timing tRFS Bit 0
HUDMA7_UDMA_TRFS1:  equ    1                                         ; ATA-5 standard UDMA timing tRFS Bit 1
HUDMA7_UDMA_TRFS2:  equ    2                                         ; ATA-5 standard UDMA timing tRFS Bit 2
HUDMA7_UDMA_TRFS3:  equ    3                                         ; ATA-5 standard UDMA timing tRFS Bit 3
HUDMA7_UDMA_TRFS4:  equ    4                                         ; ATA-5 standard UDMA timing tRFS Bit 4
HUDMA7_UDMA_TSS0:   equ    8                                         ; ATA-5 standard UDMA timing tSS Bit 0
HUDMA7_UDMA_TSS1:   equ    9                                         ; ATA-5 standard UDMA timing tSS Bit 1
HUDMA7_UDMA_TSS2:   equ    10                                        ; ATA-5 standard UDMA timing tSS Bit 2
HUDMA7_UDMA_TSS3:   equ    11                                        ; ATA-5 standard UDMA timing tSS Bit 3
; bit position masks
mHUDMA7_UDMA_TRFS0: equ    %00000001
mHUDMA7_UDMA_TRFS1: equ    %00000010
mHUDMA7_UDMA_TRFS2: equ    %00000100
mHUDMA7_UDMA_TRFS3: equ    %00001000
mHUDMA7_UDMA_TRFS4: equ    %00010000
mHUDMA7_UDMA_TSS0:  equ    %100000000
mHUDMA7_UDMA_TSS1:  equ    %1000000000
mHUDMA7_UDMA_TSS2:  equ    %10000000000
mHUDMA7_UDMA_TSS3:  equ    %100000000000


;*** HUDMA8 - UDMA Timing Register 8; 0x000001E2 ***
HUDMA8:             equ    $000001E2                                ;*** HUDMA8 - UDMA Timing Register 8; 0x000001E2 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
HUDMA8_UDMA_TACK0:  equ    0                                         ; ATA-5 standard UDMA timing tACK Bit 0
HUDMA8_UDMA_TACK1:  equ    1                                         ; ATA-5 standard UDMA timing tACK Bit 1
HUDMA8_UDMA_TACK2:  equ    2                                         ; ATA-5 standard UDMA timing tACK Bit 2
HUDMA8_UDMA_TRP0:   equ    8                                         ; ATA-5 standard UDMA timing tRP Bit 0
HUDMA8_UDMA_TRP1:   equ    9                                         ; ATA-5 standard UDMA timing tRP Bit 1
HUDMA8_UDMA_TRP2:   equ    10                                        ; ATA-5 standard UDMA timing tRP Bit 2
HUDMA8_UDMA_TRP3:   equ    11                                        ; ATA-5 standard UDMA timing tRP Bit 3
HUDMA8_UDMA_TRP4:   equ    12                                        ; ATA-5 standard UDMA timing tRP Bit 4
HUDMA8_UDMA_TRP5:   equ    13                                        ; ATA-5 standard UDMA timing tRP Bit 5
; bit position masks
mHUDMA8_UDMA_TACK0: equ    %00000001
mHUDMA8_UDMA_TACK1: equ    %00000010
mHUDMA8_UDMA_TACK2: equ    %00000100
mHUDMA8_UDMA_TRP0:  equ    %100000000
mHUDMA8_UDMA_TRP1:  equ    %1000000000
mHUDMA8_UDMA_TRP2:  equ    %10000000000
mHUDMA8_UDMA_TRP3:  equ    %100000000000
mHUDMA8_UDMA_TRP4:  equ    %1000000000000
mHUDMA8_UDMA_TRP5:  equ    %10000000000000


;*** HUDMA9 - UDMA Timing Register 9; 0x000001E4 ***
HUDMA9:             equ    $000001E4                                ;*** HUDMA9 - UDMA Timing Register 9; 0x000001E4 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
HUDMA9_UDMA_TZAH0:  equ    8                                         ; ATA-5 standard UDMA timing tZAH Bit 0
HUDMA9_UDMA_TZAH1:  equ    9                                         ; ATA-5 standard UDMA timing tZAH Bit 1
HUDMA9_UDMA_TZAH2:  equ    10                                        ; ATA-5 standard UDMA timing tZAH Bit 2
; bit position masks
mHUDMA9_UDMA_TZAH0: equ    %100000000
mHUDMA9_UDMA_TZAH1: equ    %1000000000
mHUDMA9_UDMA_TZAH2: equ    %10000000000


;*** DASR_DCTR - ATA drive device status register; 0x000001EE ***
DASR_DCTR:          equ    $000001EE                                ;*** DASR_DCTR - ATA drive device status register; 0x000001EE ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DASR_DCTR_ERR_ZERO: equ    8                                         ; Drive error indicator, Mandatory clear bit when written
DASR_DCTR_Bit_0_nIEN: equ    9                                       ; Bit 0 of obsolete field, Host controlled interrupt enable
DASR_DCTR_Bit_1_SRST: equ    10                                      ; Bit 1 of obsolete field, Host controlled software reset bit
DASR_DCTR_DRQ:      equ    11                                        ; Drive ready to transfer
DASR_DCTR_DASR_DCTR_12: equ    12                                    ; Bit 0 of ATA command dependent field
DASR_DCTR_DASR_DCTR_13: equ    13                                    ; Bit 1 of ATA command dependent field
DASR_DCTR_DRDY:     equ    14                                        ; Drive ready
DASR_DCTR_BSY:      equ    15                                        ; Drive busy
; bit position masks
mDASR_DCTR_ERR_ZERO: equ    %100000000
mDASR_DCTR_Bit_0_nIEN: equ    %1000000000
mDASR_DCTR_Bit_1_SRST: equ    %10000000000
mDASR_DCTR_DRQ:     equ    %100000000000
mDASR_DCTR_DASR_DCTR_12: equ    %1000000000000
mDASR_DCTR_DASR_DCTR_13: equ    %10000000000000
mDASR_DCTR_DRDY:    equ    %100000000000000
mDASR_DCTR_BSY:     equ    %1000000000000000


;*** DDR - ATA Drive Data Register; 0x000001F0 ***
DDR:                equ    $000001F0                                ;*** DDR - ATA Drive Data Register; 0x000001F0 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDR_DDR0:           equ    0                                         ; Odd address byte of drive data Bit 0
DDR_DDR1:           equ    1                                         ; Odd address byte of drive data Bit 1
DDR_DDR2:           equ    2                                         ; Odd address byte of drive data Bit 2
DDR_DDR3:           equ    3                                         ; Odd address byte of drive data Bit 3
DDR_DDR4:           equ    4                                         ; Odd address byte of drive data Bit 4
DDR_DDR5:           equ    5                                         ; Odd address byte of drive data Bit 5
DDR_DDR6:           equ    6                                         ; Odd address byte of drive data Bit 6
DDR_DDR7:           equ    7                                         ; Odd address byte of drive data Bit 7
DDR_DDR8:           equ    8                                         ; Even address byte of drive data Bit 0
DDR_DDR9:           equ    9                                         ; Even address byte of drive data Bit 1
DDR_DDR10:          equ    10                                        ; Even address byte of drive data Bit 2
DDR_DDR11:          equ    11                                        ; Even address byte of drive data Bit 3
DDR_DDR12:          equ    12                                        ; Even address byte of drive data Bit 4
DDR_DDR13:          equ    13                                        ; Even address byte of drive data Bit 5
DDR_DDR14:          equ    14                                        ; Even address byte of drive data Bit 6
DDR_DDR15:          equ    15                                        ; Even address byte of drive data Bit 7
; bit position masks
mDDR_DDR0:          equ    %00000001
mDDR_DDR1:          equ    %00000010
mDDR_DDR2:          equ    %00000100
mDDR_DDR3:          equ    %00001000
mDDR_DDR4:          equ    %00010000
mDDR_DDR5:          equ    %00100000
mDDR_DDR6:          equ    %01000000
mDDR_DDR7:          equ    %10000000
mDDR_DDR8:          equ    %100000000
mDDR_DDR9:          equ    %1000000000
mDDR_DDR10:         equ    %10000000000
mDDR_DDR11:         equ    %100000000000
mDDR_DDR12:         equ    %1000000000000
mDDR_DDR13:         equ    %10000000000000
mDDR_DDR14:         equ    %100000000000000
mDDR_DDR15:         equ    %1000000000000000


;*** DFR_DER - ATA Drive Feature Register; 0x000001F2 ***
DFR_DER:            equ    $000001F2                                ;*** DFR_DER - ATA Drive Feature Register; 0x000001F2 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DFR_DER_DFR_DER0:   equ    8                                         ; ATA command parameters Bit 0, ATA command dependent field Bit 0
DFR_DER_DFR_DER1:   equ    9                                         ; ATA command parameters Bit 1, ATA command dependent field Bit 1
DFR_DER_DFR_DER2:   equ    10                                        ; ATA command parameters Bit 2, Drive command aborted
DFR_DER_DFR_DER3:   equ    11                                        ; ATA command parameters Bit 3, ATA command dependent field Bit 11
DFR_DER_DFR_DER4:   equ    12                                        ; ATA command parameters Bit 4, ATA command dependent field Bit 12
DFR_DER_DFR_DER5:   equ    13                                        ; ATA command parameters Bit 5, ATA command dependent field Bit 13
DFR_DER_DFR_DER6:   equ    14                                        ; ATA command parameters Bit 6, ATA command dependent field Bit 14
DFR_DER_DFR_DER7:   equ    15                                        ; ATA command parameters Bit 7, ATA command dependent field Bit 15
; bit position masks
mDFR_DER_DFR_DER0:  equ    %100000000
mDFR_DER_DFR_DER1:  equ    %1000000000
mDFR_DER_DFR_DER2:  equ    %10000000000
mDFR_DER_DFR_DER3:  equ    %100000000000
mDFR_DER_DFR_DER4:  equ    %1000000000000
mDFR_DER_DFR_DER5:  equ    %10000000000000
mDFR_DER_DFR_DER6:  equ    %100000000000000
mDFR_DER_DFR_DER7:  equ    %1000000000000000


;*** DSCR - ATA Drive Sector Count Register; 0x000001F4 ***
DSCR:               equ    $000001F4                                ;*** DSCR - ATA Drive Sector Count Register; 0x000001F4 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DSCR_DSCR8:         equ    8                                         ; Command dependent content Bit 8
DSCR_DSCR9:         equ    9                                         ; Command dependent content Bit 9
DSCR_DSCR10:        equ    10                                        ; Command dependent content Bit 10
DSCR_DSCR11:        equ    11                                        ; Command dependent content Bit 11
DSCR_DSCR12:        equ    12                                        ; Command dependent content Bit 12
DSCR_DSCR13:        equ    13                                        ; Command dependent content Bit 13
DSCR_DSCR14:        equ    14                                        ; Command dependent content Bit 14
DSCR_DSCR15:        equ    15                                        ; Command dependent content Bit 15
; bit position masks
mDSCR_DSCR8:        equ    %100000000
mDSCR_DSCR9:        equ    %1000000000
mDSCR_DSCR10:       equ    %10000000000
mDSCR_DSCR11:       equ    %100000000000
mDSCR_DSCR12:       equ    %1000000000000
mDSCR_DSCR13:       equ    %10000000000000
mDSCR_DSCR14:       equ    %100000000000000
mDSCR_DSCR15:       equ    %1000000000000000


;*** DSNR - ATA Drive Sector Number Register; 0x000001F6 ***
DSNR:               equ    $000001F6                                ;*** DSNR - ATA Drive Sector Number Register; 0x000001F6 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DSNR_DSNR8:         equ    8                                         ; Command dependent content Bit 8
DSNR_DSNR9:         equ    9                                         ; Command dependent content Bit 9
DSNR_DSNR10:        equ    10                                        ; Command dependent content Bit 10
DSNR_DSNR11:        equ    11                                        ; Command dependent content Bit 11
DSNR_DSNR12:        equ    12                                        ; Command dependent content Bit 12
DSNR_DSNR13:        equ    13                                        ; Command dependent content Bit 13
DSNR_DSNR14:        equ    14                                        ; Command dependent content Bit 14
DSNR_DSNR15:        equ    15                                        ; Command dependent content Bit 15
; bit position masks
mDSNR_DSNR8:        equ    %100000000
mDSNR_DSNR9:        equ    %1000000000
mDSNR_DSNR10:       equ    %10000000000
mDSNR_DSNR11:       equ    %100000000000
mDSNR_DSNR12:       equ    %1000000000000
mDSNR_DSNR13:       equ    %10000000000000
mDSNR_DSNR14:       equ    %100000000000000
mDSNR_DSNR15:       equ    %1000000000000000


;*** DCLR - ATA Drive Cylinder Low Register; 0x000001F8 ***
DCLR:               equ    $000001F8                                ;*** DCLR - ATA Drive Cylinder Low Register; 0x000001F8 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DCLR_DCLR8:         equ    8                                         ; Command dependent content Bit 8
DCLR_DCLR9:         equ    9                                         ; Command dependent content Bit 9
DCLR_DCLR10:        equ    10                                        ; Command dependent content Bit 10
DCLR_DCLR11:        equ    11                                        ; Command dependent content Bit 11
DCLR_DCLR12:        equ    12                                        ; Command dependent content Bit 12
DCLR_DCLR13:        equ    13                                        ; Command dependent content Bit 13
DCLR_DCLR14:        equ    14                                        ; Command dependent content Bit 14
DCLR_DCLR15:        equ    15                                        ; Command dependent content Bit 15
; bit position masks
mDCLR_DCLR8:        equ    %100000000
mDCLR_DCLR9:        equ    %1000000000
mDCLR_DCLR10:       equ    %10000000000
mDCLR_DCLR11:       equ    %100000000000
mDCLR_DCLR12:       equ    %1000000000000
mDCLR_DCLR13:       equ    %10000000000000
mDCLR_DCLR14:       equ    %100000000000000
mDCLR_DCLR15:       equ    %1000000000000000


;*** DCHR - ATA Drive Cylinder High Register; 0x000001FA ***
DCHR:               equ    $000001FA                                ;*** DCHR - ATA Drive Cylinder High Register; 0x000001FA ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DCHR_DCHR0:         equ    8                                         ; Command dependent content Bit 0
DCHR_DCHR1:         equ    9                                         ; Command dependent content Bit 1
DCHR_DCHR2:         equ    10                                        ; Command dependent content Bit 2
DCHR_DCHR3:         equ    11                                        ; Command dependent content Bit 3
DCHR_DCHR4:         equ    12                                        ; Command dependent content Bit 4
DCHR_DCHR5:         equ    13                                        ; Command dependent content Bit 5
DCHR_DCHR6:         equ    14                                        ; Command dependent content Bit 6
DCHR_DCHR7:         equ    15                                        ; Command dependent content Bit 7
; bit position masks
mDCHR_DCHR0:        equ    %100000000
mDCHR_DCHR1:        equ    %1000000000
mDCHR_DCHR2:        equ    %10000000000
mDCHR_DCHR3:        equ    %100000000000
mDCHR_DCHR4:        equ    %1000000000000
mDCHR_DCHR5:        equ    %10000000000000
mDCHR_DCHR6:        equ    %100000000000000
mDCHR_DCHR7:        equ    %1000000000000000


;*** DDHR - ATA Drive Device/Head Register; 0x000001FC ***
DDHR:               equ    $000001FC                                ;*** DDHR - ATA Drive Device/Head Register; 0x000001FC ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDHR_DDHR0:         equ    8                                         ; Command dependent bit 0
DDHR_DDHR1:         equ    9                                         ; Command dependent bit 1
DDHR_DDHR2:         equ    10                                        ; Command dependent bit 2
DDHR_DDHR3:         equ    11                                        ; Command dependent bit 3
DDHR_DEV:           equ    12                                        ; Bit distinguishes between the drive 0 and drive 1 connected to the ATA
DDHR_Obs1:          equ    13                                        ; Obsolete, not used 1
DDHR_DDHR4:         equ    14                                        ; Command dependent bit 4
DDHR_Obs2:          equ    15                                        ; Obsolete, not used 2
; bit position masks
mDDHR_DDHR0:        equ    %100000000
mDDHR_DDHR1:        equ    %1000000000
mDDHR_DDHR2:        equ    %10000000000
mDDHR_DDHR3:        equ    %100000000000
mDDHR_DEV:          equ    %1000000000000
mDDHR_Obs1:         equ    %10000000000000
mDDHR_DDHR4:        equ    %100000000000000
mDDHR_Obs2:         equ    %1000000000000000


;*** DCR_DSR - ATA Drive Command Register; 0x000001FE ***
DCR_DSR:            equ    $000001FE                                ;*** DCR_DSR - ATA Drive Command Register; 0x000001FE ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DCR_DSR_DCR_DSR0:   equ    0                                         ; Command code being sent to the drive Bit 0
DCR_DSR_DCR_DSR1:   equ    1                                         ; Command code being sent to the drive Bit 1
DCR_DSR_DCR_DSR2:   equ    2                                         ; Command code being sent to the drive Bit 2
DCR_DSR_DCR_DSR3:   equ    3                                         ; Command code being sent to the drive Bit 3
DCR_DSR_DCR_DSR4:   equ    4                                         ; Command code being sent to the drive Bit 4, Command dependent content Bit 0
DCR_DSR_DCR_DSR5:   equ    5                                         ; Command code being sent to the drive Bit 5, Command dependent content Bit 1
DCR_DSR_DCR_DSR6:   equ    6                                         ; Command code being sent to the drive Bit 6,  Indicates that the drive is ready to accept executable commands
DCR_DSR_DCR_DSR7:   equ    7                                         ; Command code being sent to the drive Bit 7,  Indicates that the drive is busy processing a command
; bit position masks
mDCR_DSR_DCR_DSR0:  equ    %00000001
mDCR_DSR_DCR_DSR1:  equ    %00000010
mDCR_DSR_DCR_DSR2:  equ    %00000100
mDCR_DSR_DCR_DSR3:  equ    %00001000
mDCR_DSR_DCR_DSR4:  equ    %00010000
mDCR_DSR_DCR_DSR5:  equ    %00100000
mDCR_DSR_DCR_DSR6:  equ    %01000000
mDCR_DSR_DCR_DSR7:  equ    %10000000


;*** HDMAM - ATA DMA mode register; 0x000001FF ***
HDMAM:              equ    $000001FF                                ;*** HDMAM - ATA DMA mode register; 0x000001FF ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
HDMAM_WR:           equ    0                                         ; Set when WRITE DMA command is issued
HDMAM_RD:           equ    1                                         ; Set when READ DMA command is issued
HDMAM_UDMA:         equ    2                                         ; Bit is set when UDMA protocol is selected, cleared when multiword DMA protocol is selected
HDMAM_IE_HDMAM:     equ    3                                         ; Enable drive interrupt to pass to CPU in DMA/UDMA modes
HDMAM_AF:           equ    5                                         ; Automatic FIFO reset for AFIFO sub-block when UDMA or Multiword DMA transfer starts
HDMAM_HUT:          equ    6                                         ; Host UDMA burst Terminate
HDMAM_PIE:          equ    7                                         ; Pause Interrupt Enable
; bit position masks
mHDMAM_WR:          equ    %00000001
mHDMAM_RD:          equ    %00000010
mHDMAM_UDMA:        equ    %00000100
mHDMAM_IE_HDMAM:    equ    %00001000
mHDMAM_AF:          equ    %00100000
mHDMAM_HUT:         equ    %01000000
mHDMAM_PIE:         equ    %10000000


;*** IQUECR - IQUE Module Control Register; 0x00000200 ***
IQUECR:             equ    $00000200                                ;*** IQUECR - IQUE Module Control Register; 0x00000200 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
IQUECR_IQUEEN:      equ    0                                         ; IQUE Module Enable
IQUECR_IQUERST:     equ    1                                         ; IQUE Module Reset
IQUECR_QC12DBE:     equ    3                                         ; QUE channel 1+2 double buffer mode.
IQUECR_QC34DBE:     equ    4                                         ; QUE channel 3+4 double buffer mode.
; bit position masks
mIQUECR_IQUEEN:     equ    %00000001
mIQUECR_IQUERST:    equ    %00000010
mIQUECR_QC12DBE:    equ    %00001000
mIQUECR_QC34DBE:    equ    %00010000


;*** QC1DR - Queue Channel 1 FIFO Data Port Register; 0x00000202 ***
QC1DR:              equ    $00000202                                ;*** QC1DR - Queue Channel 1 FIFO Data Port Register; 0x00000202 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
QC1DR_QC1DR0:       equ    0                                         ; Q1DATA Bit 0
QC1DR_QC1DR1:       equ    1                                         ; Q1DATA Bit 1
QC1DR_QC1DR2:       equ    2                                         ; Q1DATA Bit 2
QC1DR_QC1DR3:       equ    3                                         ; Q1DATA Bit 3
QC1DR_QC1DR4:       equ    4                                         ; Q1DATA Bit 4
QC1DR_QC1DR5:       equ    5                                         ; Q1DATA Bit 5
QC1DR_QC1DR6:       equ    6                                         ; Q1DATA Bit 6
QC1DR_QC1DR7:       equ    7                                         ; Q1DATA Bit 7
QC1DR_QC1DR8:       equ    8                                         ; Q1DATA Bit 8
QC1DR_QC1DR9:       equ    9                                         ; Q1DATA Bit 9
QC1DR_QC1DR10:      equ    10                                        ; Q1DATA Bit 10
QC1DR_QC1DR11:      equ    11                                        ; Q1DATA Bit 11
QC1DR_QC1DR12:      equ    12                                        ; Q1DATA Bit 12
QC1DR_QC1DR13:      equ    13                                        ; Q1DATA Bit 13
QC1DR_QC1DR14:      equ    14                                        ; Q1DATA Bit 14
QC1DR_QC1DR15:      equ    15                                        ; Q1DATA Bit 15
; bit position masks
mQC1DR_QC1DR0:      equ    %00000001
mQC1DR_QC1DR1:      equ    %00000010
mQC1DR_QC1DR2:      equ    %00000100
mQC1DR_QC1DR3:      equ    %00001000
mQC1DR_QC1DR4:      equ    %00010000
mQC1DR_QC1DR5:      equ    %00100000
mQC1DR_QC1DR6:      equ    %01000000
mQC1DR_QC1DR7:      equ    %10000000
mQC1DR_QC1DR8:      equ    %100000000
mQC1DR_QC1DR9:      equ    %1000000000
mQC1DR_QC1DR10:     equ    %10000000000
mQC1DR_QC1DR11:     equ    %100000000000
mQC1DR_QC1DR12:     equ    %1000000000000
mQC1DR_QC1DR13:     equ    %10000000000000
mQC1DR_QC1DR14:     equ    %100000000000000
mQC1DR_QC1DR15:     equ    %1000000000000000


;*** QC1BP - Queue Channel 1 Begin Pointer; 0x00000204 ***
QC1BP:              equ    $00000204                                ;*** QC1BP - Queue Channel 1 Begin Pointer; 0x00000204 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
QC1BP_BEGPTR10:     equ    0                                         ; Begin Pointer for Queue Channel 1 FIFO Bit 0
QC1BP_BEGPTR11:     equ    1                                         ; Begin Pointer for Queue Channel 1 FIFO Bit 1
QC1BP_BEGPTR12:     equ    2                                         ; Begin Pointer for Queue Channel 1 FIFO Bit 2
QC1BP_BEGPTR13:     equ    3                                         ; Begin Pointer for Queue Channel 1 FIFO Bit 3
QC1BP_BEGPTR14:     equ    4                                         ; Begin Pointer for Queue Channel 1 FIFO Bit 4
QC1BP_BEGPTR15:     equ    5                                         ; Begin Pointer for Queue Channel 1 FIFO Bit 5
QC1BP_BEGPTR16:     equ    6                                         ; Begin Pointer for Queue Channel 1 FIFO Bit 6
QC1BP_BEGPTR17:     equ    7                                         ; Begin Pointer for Queue Channel 1 FIFO Bit 7
QC1BP_BEGPTR18:     equ    8                                         ; Begin Pointer for Queue Channel 1 FIFO Bit 8
QC1BP_BEGPTR19:     equ    9                                         ; Begin Pointer for Queue Channel 1 FIFO Bit 9
QC1BP_BEGPTR110:    equ    10                                        ; Begin Pointer for Queue Channel 1 FIFO Bit 10
QC1BP_BEGPTR111:    equ    11                                        ; Begin Pointer for Queue Channel 1 FIFO Bit 11
; bit position masks
mQC1BP_BEGPTR10:    equ    %00000001
mQC1BP_BEGPTR11:    equ    %00000010
mQC1BP_BEGPTR12:    equ    %00000100
mQC1BP_BEGPTR13:    equ    %00001000
mQC1BP_BEGPTR14:    equ    %00010000
mQC1BP_BEGPTR15:    equ    %00100000
mQC1BP_BEGPTR16:    equ    %01000000
mQC1BP_BEGPTR17:    equ    %10000000
mQC1BP_BEGPTR18:    equ    %100000000
mQC1BP_BEGPTR19:    equ    %1000000000
mQC1BP_BEGPTR110:   equ    %10000000000
mQC1BP_BEGPTR111:   equ    %100000000000


;*** QC1EP - Queue Channel 1 End Pointer; 0x00000206 ***
QC1EP:              equ    $00000206                                ;*** QC1EP - Queue Channel 1 End Pointer; 0x00000206 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
QC1EP_ENDPTR10:     equ    0                                         ; End Pointer for Queue Channel 1 FIFO Bit 0
QC1EP_ENDPTR11:     equ    1                                         ; End Pointer for Queue Channel 1 FIFO Bit 1
QC1EP_ENDPTR12:     equ    2                                         ; End Pointer for Queue Channel 1 FIFO Bit 2
QC1EP_ENDPTR13:     equ    3                                         ; End Pointer for Queue Channel 1 FIFO Bit 3
QC1EP_ENDPTR14:     equ    4                                         ; End Pointer for Queue Channel 1 FIFO Bit 4
QC1EP_ENDPTR15:     equ    5                                         ; End Pointer for Queue Channel 1 FIFO Bit 5
QC1EP_ENDPTR16:     equ    6                                         ; End Pointer for Queue Channel 1 FIFO Bit 6
QC1EP_ENDPTR17:     equ    7                                         ; End Pointer for Queue Channel 1 FIFO Bit 7
QC1EP_ENDPTR18:     equ    8                                         ; End Pointer for Queue Channel 1 FIFO Bit 8
QC1EP_ENDPTR19:     equ    9                                         ; End Pointer for Queue Channel 1 FIFO Bit 9
QC1EP_ENDPTR110:    equ    10                                        ; End Pointer for Queue Channel 1 FIFO Bit 10
QC1EP_ENDPTR111:    equ    11                                        ; End Pointer for Queue Channel 1 FIFO Bit 11
; bit position masks
mQC1EP_ENDPTR10:    equ    %00000001
mQC1EP_ENDPTR11:    equ    %00000010
mQC1EP_ENDPTR12:    equ    %00000100
mQC1EP_ENDPTR13:    equ    %00001000
mQC1EP_ENDPTR14:    equ    %00010000
mQC1EP_ENDPTR15:    equ    %00100000
mQC1EP_ENDPTR16:    equ    %01000000
mQC1EP_ENDPTR17:    equ    %10000000
mQC1EP_ENDPTR18:    equ    %100000000
mQC1EP_ENDPTR19:    equ    %1000000000
mQC1EP_ENDPTR110:   equ    %10000000000
mQC1EP_ENDPTR111:   equ    %100000000000


;*** QC1CR - Queue Channel 1 Control Register; 0x00000208 ***
QC1CR:              equ    $00000208                                ;*** QC1CR - Queue Channel 1 Control Register; 0x00000208 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
QC1CR_Q1PRST:       equ    0                                         ; Queue Channel 1 Pointers Reset
QC1CR_Q1THRU:       equ    1                                         ; Select Passthrough Mode Involving Queue Channel 1+2 (3+4)
QC1CR_Q116EN:       equ    2                                         ; Configure Channel 1 for 16-bit/8-bit Transfers
QC1CR_Q1SML:        equ    3                                         ; Queue Channel 1 Small Buffer Select
QC1CR_Q1EN:         equ    4                                         ; Queue Channel 1 Enable
QC1CR_Q1FIE:        equ    5                                         ; Queue Channel 1 Full Interrupt Enable
QC1CR_Q1EIE:        equ    6                                         ; Queue Channel 1 Empty Interrupt Enable
QC1CR_Q1VIE:        equ    7                                         ; Queue Channel 1 Valid Interrupt Enable
; bit position masks
mQC1CR_Q1PRST:      equ    %00000001
mQC1CR_Q1THRU:      equ    %00000010
mQC1CR_Q116EN:      equ    %00000100
mQC1CR_Q1SML:       equ    %00001000
mQC1CR_Q1EN:        equ    %00010000
mQC1CR_Q1FIE:       equ    %00100000
mQC1CR_Q1EIE:       equ    %01000000
mQC1CR_Q1VIE:       equ    %10000000


;*** QC1SR - Queue Channel 1 Status Register; 0x00000209 ***
QC1SR:              equ    $00000209                                ;*** QC1SR - Queue Channel 1 Status Register; 0x00000209 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
QC1SR_Q1EIF:        equ    2                                         ; Queue Channel 1 Empty Interrupt Flag
QC1SR_Q1FIF:        equ    3                                         ; Queue Channel 1 Full Interrupt Flag
QC1SR_Q1VIF:        equ    4                                         ; Queue Channel 1 Valid Data Interrupt Flag
QC1SR_Q1ESF:        equ    5                                         ; Queue Channel 1 Empty Status Flag
QC1SR_Q1FSF:        equ    6                                         ; Queue Channel 1 Full Status Flag
QC1SR_Q1VSF:        equ    7                                         ; Queue Channel 1 Valid Data Control and Status Flag
; bit position masks
mQC1SR_Q1EIF:       equ    %00000100
mQC1SR_Q1FIF:       equ    %00001000
mQC1SR_Q1VIF:       equ    %00010000
mQC1SR_Q1ESF:       equ    %00100000
mQC1SR_Q1FSF:       equ    %01000000
mQC1SR_Q1VSF:       equ    %10000000


;*** QC1SZB - Buffer Size/Base Address Register for Queue Channel 1; 0x0000020A ***
QC1SZB:             equ    $0000020A                                ;*** QC1SZB - Buffer Size/Base Address Register for Queue Channel 1; 0x0000020A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
QC1SZB_QBASE0_1:    equ    0                                         ; Queue Channel 1 Buffer Base Address Bit 0
QC1SZB_QBASE1_1:    equ    1                                         ; Queue Channel 1 Buffer Base Address Bit 1
QC1SZB_QBASE2_1:    equ    2                                         ; Queue Channel 1 Buffer Base Address Bit 2
QC1SZB_QBASE3_1:    equ    3                                         ; Queue Channel 1 Buffer Base Address Bit 3
QC1SZB_QSIZE0_1:    equ    4                                         ; Queue Channel 1 Buffer Size Bit 0
QC1SZB_QSIZE1_1:    equ    5                                         ; Queue Channel 1 Buffer Size Bit 1
QC1SZB_QSIZE2_1:    equ    6                                         ; Queue Channel 1 Buffer Size Bit 2
QC1SZB_QSIZE3_1:    equ    7                                         ; Queue Channel 1 Buffer Size Bit 3
; bit position masks
mQC1SZB_QBASE0_1:   equ    %00000001
mQC1SZB_QBASE1_1:   equ    %00000010
mQC1SZB_QBASE2_1:   equ    %00000100
mQC1SZB_QBASE3_1:   equ    %00001000
mQC1SZB_QSIZE0_1:   equ    %00010000
mQC1SZB_QSIZE1_1:   equ    %00100000
mQC1SZB_QSIZE2_1:   equ    %01000000
mQC1SZB_QSIZE3_1:   equ    %10000000


;*** QC1REQ - Queue Channel 1 Request Mapping Register; 0x0000020B ***
QC1REQ:             equ    $0000020B                                ;*** QC1REQ - Queue Channel 1 Request Mapping Register; 0x0000020B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
QC1REQ_Q1REQ0:      equ    0                                         ; Select Peripheral Request for Queue Channel 1 Bit 0
QC1REQ_Q1REQ1:      equ    1                                         ; Select Peripheral Request for Queue Channel 1 Bit 1
QC1REQ_Q1REQ2:      equ    2                                         ; Select Peripheral Request for Queue Channel 1 Bit 2
QC1REQ_Q1REQ3:      equ    3                                         ; Select Peripheral Request for Queue Channel 1 Bit 3
; bit position masks
mQC1REQ_Q1REQ0:     equ    %00000001
mQC1REQ_Q1REQ1:     equ    %00000010
mQC1REQ_Q1REQ2:     equ    %00000100
mQC1REQ_Q1REQ3:     equ    %00001000


;*** QC2DR - Queue Channel 2 FIFO Data Port Register; 0x0000020C ***
QC2DR:              equ    $0000020C                                ;*** QC2DR - Queue Channel 2 FIFO Data Port Register; 0x0000020C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
QC2DR_QC2DR0:       equ    0                                         ; Q2DATA Bit 0
QC2DR_QC2DR1:       equ    1                                         ; Q2DATA Bit 1
QC2DR_QC2DR2:       equ    2                                         ; Q2DATA Bit 2
QC2DR_QC2DR3:       equ    3                                         ; Q2DATA Bit 3
QC2DR_QC2DR4:       equ    4                                         ; Q2DATA Bit 4
QC2DR_QC2DR5:       equ    5                                         ; Q2DATA Bit 5
QC2DR_QC2DR6:       equ    6                                         ; Q2DATA Bit 6
QC2DR_QC2DR7:       equ    7                                         ; Q2DATA Bit 7
QC2DR_QC2DR8:       equ    8                                         ; Q2DATA Bit 8
QC2DR_QC2DR9:       equ    9                                         ; Q2DATA Bit 9
QC2DR_QC2DR10:      equ    10                                        ; Q2DATA Bit 10
QC2DR_QC2DR11:      equ    11                                        ; Q2DATA Bit 11
QC2DR_QC2DR12:      equ    12                                        ; Q2DATA Bit 12
QC2DR_QC2DR13:      equ    13                                        ; Q2DATA Bit 13
QC2DR_QC2DR14:      equ    14                                        ; Q2DATA Bit 14
QC2DR_QC2DR15:      equ    15                                        ; Q2DATA Bit 15
; bit position masks
mQC2DR_QC2DR0:      equ    %00000001
mQC2DR_QC2DR1:      equ    %00000010
mQC2DR_QC2DR2:      equ    %00000100
mQC2DR_QC2DR3:      equ    %00001000
mQC2DR_QC2DR4:      equ    %00010000
mQC2DR_QC2DR5:      equ    %00100000
mQC2DR_QC2DR6:      equ    %01000000
mQC2DR_QC2DR7:      equ    %10000000
mQC2DR_QC2DR8:      equ    %100000000
mQC2DR_QC2DR9:      equ    %1000000000
mQC2DR_QC2DR10:     equ    %10000000000
mQC2DR_QC2DR11:     equ    %100000000000
mQC2DR_QC2DR12:     equ    %1000000000000
mQC2DR_QC2DR13:     equ    %10000000000000
mQC2DR_QC2DR14:     equ    %100000000000000
mQC2DR_QC2DR15:     equ    %1000000000000000


;*** QC2BP - Queue Channel 2 Begin Pointer; 0x0000020E ***
QC2BP:              equ    $0000020E                                ;*** QC2BP - Queue Channel 2 Begin Pointer; 0x0000020E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
QC2BP_BEGPTR20:     equ    0                                         ; Begin Pointer for Queue Channel 2 FIFO Bit 0
QC2BP_BEGPTR21:     equ    1                                         ; Begin Pointer for Queue Channel 2 FIFO Bit 1
QC2BP_BEGPTR22:     equ    2                                         ; Begin Pointer for Queue Channel 2 FIFO Bit 2
QC2BP_BEGPTR23:     equ    3                                         ; Begin Pointer for Queue Channel 2 FIFO Bit 3
QC2BP_BEGPTR24:     equ    4                                         ; Begin Pointer for Queue Channel 2 FIFO Bit 4
QC2BP_BEGPTR25:     equ    5                                         ; Begin Pointer for Queue Channel 2 FIFO Bit 5
QC2BP_BEGPTR26:     equ    6                                         ; Begin Pointer for Queue Channel 2 FIFO Bit 6
QC2BP_BEGPTR27:     equ    7                                         ; Begin Pointer for Queue Channel 2 FIFO Bit 7
QC2BP_BEGPTR28:     equ    8                                         ; Begin Pointer for Queue Channel 2 FIFO Bit 8
QC2BP_BEGPTR29:     equ    9                                         ; Begin Pointer for Queue Channel 2 FIFO Bit 9
QC2BP_BEGPTR210:    equ    10                                        ; Begin Pointer for Queue Channel 2 FIFO Bit 10
QC2BP_BEGPTR211:    equ    11                                        ; Begin Pointer for Queue Channel 2 FIFO Bit 11
; bit position masks
mQC2BP_BEGPTR20:    equ    %00000001
mQC2BP_BEGPTR21:    equ    %00000010
mQC2BP_BEGPTR22:    equ    %00000100
mQC2BP_BEGPTR23:    equ    %00001000
mQC2BP_BEGPTR24:    equ    %00010000
mQC2BP_BEGPTR25:    equ    %00100000
mQC2BP_BEGPTR26:    equ    %01000000
mQC2BP_BEGPTR27:    equ    %10000000
mQC2BP_BEGPTR28:    equ    %100000000
mQC2BP_BEGPTR29:    equ    %1000000000
mQC2BP_BEGPTR210:   equ    %10000000000
mQC2BP_BEGPTR211:   equ    %100000000000


;*** QC2EP - Queue Channel 2 End Pointer; 0x00000210 ***
QC2EP:              equ    $00000210                                ;*** QC2EP - Queue Channel 2 End Pointer; 0x00000210 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
QC2EP_ENDPTR20:     equ    0                                         ; End Pointer for Queue Channel 2 FIFO Bit 0
QC2EP_ENDPTR21:     equ    1                                         ; End Pointer for Queue Channel 2 FIFO Bit 1
QC2EP_ENDPTR22:     equ    2                                         ; End Pointer for Queue Channel 2 FIFO Bit 2
QC2EP_ENDPTR23:     equ    3                                         ; End Pointer for Queue Channel 2 FIFO Bit 3
QC2EP_ENDPTR24:     equ    4                                         ; End Pointer for Queue Channel 2 FIFO Bit 4
QC2EP_ENDPTR25:     equ    5                                         ; End Pointer for Queue Channel 2 FIFO Bit 5
QC2EP_ENDPTR26:     equ    6                                         ; End Pointer for Queue Channel 2 FIFO Bit 6
QC2EP_ENDPTR27:     equ    7                                         ; End Pointer for Queue Channel 2 FIFO Bit 7
QC2EP_ENDPTR28:     equ    8                                         ; End Pointer for Queue Channel 2 FIFO Bit 8
QC2EP_ENDPTR29:     equ    9                                         ; End Pointer for Queue Channel 2 FIFO Bit 9
QC2EP_ENDPTR210:    equ    10                                        ; End Pointer for Queue Channel 2 FIFO Bit 10
QC2EP_ENDPTR211:    equ    11                                        ; End Pointer for Queue Channel 2 FIFO Bit 11
; bit position masks
mQC2EP_ENDPTR20:    equ    %00000001
mQC2EP_ENDPTR21:    equ    %00000010
mQC2EP_ENDPTR22:    equ    %00000100
mQC2EP_ENDPTR23:    equ    %00001000
mQC2EP_ENDPTR24:    equ    %00010000
mQC2EP_ENDPTR25:    equ    %00100000
mQC2EP_ENDPTR26:    equ    %01000000
mQC2EP_ENDPTR27:    equ    %10000000
mQC2EP_ENDPTR28:    equ    %100000000
mQC2EP_ENDPTR29:    equ    %1000000000
mQC2EP_ENDPTR210:   equ    %10000000000
mQC2EP_ENDPTR211:   equ    %100000000000


;*** QC2CR - Queue Channel 2 Control Register; 0x00000212 ***
QC2CR:              equ    $00000212                                ;*** QC2CR - Queue Channel 2 Control Register; 0x00000212 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
QC2CR_Q2PRST:       equ    0                                         ; Queue Channel 2 Pointers Reset
QC2CR_Q216EN:       equ    2                                         ; Configure Channel 2 for 16-bit/8-bit Transfers
QC2CR_Q2SML:        equ    3                                         ; Queue Channel 2 Small Buffer Select
QC2CR_Q2EN:         equ    4                                         ; Queue Channel 2 Enable
QC2CR_Q2FIE:        equ    5                                         ; Queue Channel 2 Full Interrupt Enable
QC2CR_Q2EIE:        equ    6                                         ; Queue Channel 2 Empty Interrupt Enable
QC2CR_Q2VIE:        equ    7                                         ; Queue Channel 2 Valid Interrupt Enable
; bit position masks
mQC2CR_Q2PRST:      equ    %00000001
mQC2CR_Q216EN:      equ    %00000100
mQC2CR_Q2SML:       equ    %00001000
mQC2CR_Q2EN:        equ    %00010000
mQC2CR_Q2FIE:       equ    %00100000
mQC2CR_Q2EIE:       equ    %01000000
mQC2CR_Q2VIE:       equ    %10000000


;*** QC2SR - Queue Channel 2 Status Register; 0x00000213 ***
QC2SR:              equ    $00000213                                ;*** QC2SR - Queue Channel 2 Status Register; 0x00000213 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
QC2SR_Q2EIF:        equ    2                                         ; Queue Channel 2 Empty Interrupt Flag
QC2SR_Q2FIF:        equ    3                                         ; Queue Channel 2 Full Interrupt Flag
QC2SR_Q2VIF:        equ    4                                         ; Queue Channel 2 Valid Data Interrupt Flag
QC2SR_Q2ESF:        equ    5                                         ; Queue Channel 2 Empty Status Flag
QC2SR_Q2FSF:        equ    6                                         ; Queue Channel 2 Full Status Flag
QC2SR_Q2VSF:        equ    7                                         ; Queue Channel 2 Valid Data Control and Status Flag
; bit position masks
mQC2SR_Q2EIF:       equ    %00000100
mQC2SR_Q2FIF:       equ    %00001000
mQC2SR_Q2VIF:       equ    %00010000
mQC2SR_Q2ESF:       equ    %00100000
mQC2SR_Q2FSF:       equ    %01000000
mQC2SR_Q2VSF:       equ    %10000000


;*** QC2SZB - Buffer Size/Base Address Register for Queue Channel 2; 0x00000214 ***
QC2SZB:             equ    $00000214                                ;*** QC2SZB - Buffer Size/Base Address Register for Queue Channel 2; 0x00000214 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
QC2SZB_QBASE0_2:    equ    0                                         ; Queue Channel 2 Buffer Base Address Bit 0
QC2SZB_QBASE1_2:    equ    1                                         ; Queue Channel 2 Buffer Base Address Bit 1
QC2SZB_QBASE2_2:    equ    2                                         ; Queue Channel 2 Buffer Base Address Bit 2
QC2SZB_QBASE3_2:    equ    3                                         ; Queue Channel 2 Buffer Base Address Bit 3
QC2SZB_QSIZE0_2:    equ    4                                         ; Queue Channel n Buffer Size Bit 0
QC2SZB_QSIZE1_2:    equ    5                                         ; Queue Channel n Buffer Size Bit 1
QC2SZB_QSIZE2_2:    equ    6                                         ; Queue Channel n Buffer Size Bit 2
QC2SZB_QSIZE3_2:    equ    7                                         ; Queue Channel n Buffer Size Bit 3
; bit position masks
mQC2SZB_QBASE0_2:   equ    %00000001
mQC2SZB_QBASE1_2:   equ    %00000010
mQC2SZB_QBASE2_2:   equ    %00000100
mQC2SZB_QBASE3_2:   equ    %00001000
mQC2SZB_QSIZE0_2:   equ    %00010000
mQC2SZB_QSIZE1_2:   equ    %00100000
mQC2SZB_QSIZE2_2:   equ    %01000000
mQC2SZB_QSIZE3_2:   equ    %10000000


;*** QC2REQ - Queue Channel 2 Request Mapping Register; 0x00000215 ***
QC2REQ:             equ    $00000215                                ;*** QC2REQ - Queue Channel 2 Request Mapping Register; 0x00000215 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
QC2REQ_Q2REQ0:      equ    0                                         ; Select Peripheral Request for Queue Channel 2 Bit 0
QC2REQ_Q2REQ1:      equ    1                                         ; Select Peripheral Request for Queue Channel 2 Bit 1
QC2REQ_Q2REQ2:      equ    2                                         ; Select Peripheral Request for Queue Channel 2 Bit 2
QC2REQ_Q2REQ3:      equ    3                                         ; Select Peripheral Request for Queue Channel 2 Bit 3
; bit position masks
mQC2REQ_Q2REQ0:     equ    %00000001
mQC2REQ_Q2REQ1:     equ    %00000010
mQC2REQ_Q2REQ2:     equ    %00000100
mQC2REQ_Q2REQ3:     equ    %00001000


;*** QC3DR - Queue Channel 3 FIFO Data Port Register; 0x00000216 ***
QC3DR:              equ    $00000216                                ;*** QC3DR - Queue Channel 3 FIFO Data Port Register; 0x00000216 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
QC3DR_QC3DR0:       equ    0                                         ; Q3DATA Bit 0
QC3DR_QC3DR1:       equ    1                                         ; Q3DATA Bit 1
QC3DR_QC3DR2:       equ    2                                         ; Q3DATA Bit 2
QC3DR_QC3DR3:       equ    3                                         ; Q3DATA Bit 3
QC3DR_QC3DR4:       equ    4                                         ; Q3DATA Bit 4
QC3DR_QC3DR5:       equ    5                                         ; Q3DATA Bit 5
QC3DR_QC3DR6:       equ    6                                         ; Q3DATA Bit 6
QC3DR_QC3DR7:       equ    7                                         ; Q3DATA Bit 7
QC3DR_QC3DR8:       equ    8                                         ; Q3DATA Bit 8
QC3DR_QC3DR9:       equ    9                                         ; Q3DATA Bit 9
QC3DR_QC3DR10:      equ    10                                        ; Q3DATA Bit 10
QC3DR_QC3DR11:      equ    11                                        ; Q3DATA Bit 11
QC3DR_QC3DR12:      equ    12                                        ; Q3DATA Bit 12
QC3DR_QC3DR13:      equ    13                                        ; Q3DATA Bit 13
QC3DR_QC3DR14:      equ    14                                        ; Q3DATA Bit 14
QC3DR_QC3DR15:      equ    15                                        ; Q3DATA Bit 15
; bit position masks
mQC3DR_QC3DR0:      equ    %00000001
mQC3DR_QC3DR1:      equ    %00000010
mQC3DR_QC3DR2:      equ    %00000100
mQC3DR_QC3DR3:      equ    %00001000
mQC3DR_QC3DR4:      equ    %00010000
mQC3DR_QC3DR5:      equ    %00100000
mQC3DR_QC3DR6:      equ    %01000000
mQC3DR_QC3DR7:      equ    %10000000
mQC3DR_QC3DR8:      equ    %100000000
mQC3DR_QC3DR9:      equ    %1000000000
mQC3DR_QC3DR10:     equ    %10000000000
mQC3DR_QC3DR11:     equ    %100000000000
mQC3DR_QC3DR12:     equ    %1000000000000
mQC3DR_QC3DR13:     equ    %10000000000000
mQC3DR_QC3DR14:     equ    %100000000000000
mQC3DR_QC3DR15:     equ    %1000000000000000


;*** QC3BP - Queue Channel 3 Begin Pointer; 0x00000218 ***
QC3BP:              equ    $00000218                                ;*** QC3BP - Queue Channel 3 Begin Pointer; 0x00000218 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
QC3BP_BEGPTR30:     equ    0                                         ; Begin Pointer for Queue Channel 3 FIFO Bit 0
QC3BP_BEGPTR31:     equ    1                                         ; Begin Pointer for Queue Channel 3 FIFO Bit 1
QC3BP_BEGPTR32:     equ    2                                         ; Begin Pointer for Queue Channel 3 FIFO Bit 2
QC3BP_BEGPTR33:     equ    3                                         ; Begin Pointer for Queue Channel 3 FIFO Bit 3
QC3BP_BEGPTR34:     equ    4                                         ; Begin Pointer for Queue Channel 3 FIFO Bit 4
QC3BP_BEGPTR35:     equ    5                                         ; Begin Pointer for Queue Channel 3 FIFO Bit 5
QC3BP_BEGPTR36:     equ    6                                         ; Begin Pointer for Queue Channel 3 FIFO Bit 6
QC3BP_BEGPTR37:     equ    7                                         ; Begin Pointer for Queue Channel 3 FIFO Bit 7
QC3BP_BEGPTR38:     equ    8                                         ; Begin Pointer for Queue Channel 3 FIFO Bit 8
QC3BP_BEGPTR39:     equ    9                                         ; Begin Pointer for Queue Channel 3 FIFO Bit 9
QC3BP_BEGPTR310:    equ    10                                        ; Begin Pointer for Queue Channel 3 FIFO Bit 10
QC3BP_BEGPTR311:    equ    11                                        ; Begin Pointer for Queue Channel 3 FIFO Bit 11
; bit position masks
mQC3BP_BEGPTR30:    equ    %00000001
mQC3BP_BEGPTR31:    equ    %00000010
mQC3BP_BEGPTR32:    equ    %00000100
mQC3BP_BEGPTR33:    equ    %00001000
mQC3BP_BEGPTR34:    equ    %00010000
mQC3BP_BEGPTR35:    equ    %00100000
mQC3BP_BEGPTR36:    equ    %01000000
mQC3BP_BEGPTR37:    equ    %10000000
mQC3BP_BEGPTR38:    equ    %100000000
mQC3BP_BEGPTR39:    equ    %1000000000
mQC3BP_BEGPTR310:   equ    %10000000000
mQC3BP_BEGPTR311:   equ    %100000000000


;*** QC3EP - Queue Channel 3 End Pointer; 0x0000021A ***
QC3EP:              equ    $0000021A                                ;*** QC3EP - Queue Channel 3 End Pointer; 0x0000021A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
QC3EP_ENDPTR30:     equ    0                                         ; End Pointer for Queue Channel 3 FIFO Bit 0
QC3EP_ENDPTR31:     equ    1                                         ; End Pointer for Queue Channel 3 FIFO Bit 1
QC3EP_ENDPTR32:     equ    2                                         ; End Pointer for Queue Channel 3 FIFO Bit 2
QC3EP_ENDPTR33:     equ    3                                         ; End Pointer for Queue Channel 3 FIFO Bit 3
QC3EP_ENDPTR34:     equ    4                                         ; End Pointer for Queue Channel 3 FIFO Bit 4
QC3EP_ENDPTR35:     equ    5                                         ; End Pointer for Queue Channel 3 FIFO Bit 5
QC3EP_ENDPTR36:     equ    6                                         ; End Pointer for Queue Channel 3 FIFO Bit 6
QC3EP_ENDPTR37:     equ    7                                         ; End Pointer for Queue Channel 3 FIFO Bit 7
QC3EP_ENDPTR38:     equ    8                                         ; End Pointer for Queue Channel 3 FIFO Bit 8
QC3EP_ENDPTR39:     equ    9                                         ; End Pointer for Queue Channel 3 FIFO Bit 9
QC3EP_ENDPTR310:    equ    10                                        ; End Pointer for Queue Channel 3 FIFO Bit 10
QC3EP_ENDPTR311:    equ    11                                        ; End Pointer for Queue Channel 3 FIFO Bit 11
; bit position masks
mQC3EP_ENDPTR30:    equ    %00000001
mQC3EP_ENDPTR31:    equ    %00000010
mQC3EP_ENDPTR32:    equ    %00000100
mQC3EP_ENDPTR33:    equ    %00001000
mQC3EP_ENDPTR34:    equ    %00010000
mQC3EP_ENDPTR35:    equ    %00100000
mQC3EP_ENDPTR36:    equ    %01000000
mQC3EP_ENDPTR37:    equ    %10000000
mQC3EP_ENDPTR38:    equ    %100000000
mQC3EP_ENDPTR39:    equ    %1000000000
mQC3EP_ENDPTR310:   equ    %10000000000
mQC3EP_ENDPTR311:   equ    %100000000000


;*** QC3CR - Queue Channel 3 Control Register; 0x0000021C ***
QC3CR:              equ    $0000021C                                ;*** QC3CR - Queue Channel 3 Control Register; 0x0000021C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
QC3CR_Q3PRST:       equ    0                                         ; Queue Channel 3 Pointers Reset
QC3CR_Q3THRU:       equ    1                                         ; Select Passthrough Mode Involving Queue Channel 1+2 (3+4)
QC3CR_Q316EN:       equ    2                                         ; Configure Channel n for 16-bit/8-bit Transfers
QC3CR_Q3SML:        equ    3                                         ; Queue Channel 3 Small Buffer Select
QC3CR_Q3EN:         equ    4                                         ; Queue Channel 3 Enable
QC3CR_Q3FIE:        equ    5                                         ; Queue Channel 3 Full Interrupt Enable
QC3CR_Q3EIE:        equ    6                                         ; Queue Channel 3 Empty Interrupt Enable
QC3CR_Q3VIE:        equ    7                                         ; Queue Channel 3 Valid Interrupt Enable
; bit position masks
mQC3CR_Q3PRST:      equ    %00000001
mQC3CR_Q3THRU:      equ    %00000010
mQC3CR_Q316EN:      equ    %00000100
mQC3CR_Q3SML:       equ    %00001000
mQC3CR_Q3EN:        equ    %00010000
mQC3CR_Q3FIE:       equ    %00100000
mQC3CR_Q3EIE:       equ    %01000000
mQC3CR_Q3VIE:       equ    %10000000


;*** QC3SR - Queue Channel 3 Status Register; 0x0000021D ***
QC3SR:              equ    $0000021D                                ;*** QC3SR - Queue Channel 3 Status Register; 0x0000021D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
QC3SR_Q3EIF:        equ    2                                         ; Queue Channel 3 Empty Interrupt Flag
QC3SR_Q3FIF:        equ    3                                         ; Queue Channel 3 Full Interrupt Flag
QC3SR_Q3VIF:        equ    4                                         ; Queue Channel 3 Valid Data Interrupt Flag
QC3SR_Q3ESF:        equ    5                                         ; Queue Channel 3 Empty Status Flag
QC3SR_Q3FSF:        equ    6                                         ; Queue Channel 3 Full Status Flag
QC3SR_Q3VSF:        equ    7                                         ; Queue Channel 3 Valid Data Control and Status Flag
; bit position masks
mQC3SR_Q3EIF:       equ    %00000100
mQC3SR_Q3FIF:       equ    %00001000
mQC3SR_Q3VIF:       equ    %00010000
mQC3SR_Q3ESF:       equ    %00100000
mQC3SR_Q3FSF:       equ    %01000000
mQC3SR_Q3VSF:       equ    %10000000


;*** QC3SZB - Buffer Size/Base Address Register for Queue Channel 3; 0x0000021E ***
QC3SZB:             equ    $0000021E                                ;*** QC3SZB - Buffer Size/Base Address Register for Queue Channel 3; 0x0000021E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
QC3SZB_QBASE0_3:    equ    0                                         ; Queue Channel 3 Buffer Base Address Bit 0
QC3SZB_QBASE1_3:    equ    1                                         ; Queue Channel 3 Buffer Base Address Bit 1
QC3SZB_QBASE2_3:    equ    2                                         ; Queue Channel 3 Buffer Base Address Bit 2
QC3SZB_QBASE3_3:    equ    3                                         ; Queue Channel 3 Buffer Base Address Bit 3
QC3SZB_QSIZE0_3:    equ    4                                         ; Queue Channel 3 Buffer Size Bit 0
QC3SZB_QSIZE1_3:    equ    5                                         ; Queue Channel 3 Buffer Size Bit 1
QC3SZB_QSIZE2_3:    equ    6                                         ; Queue Channel 3 Buffer Size Bit 2
QC3SZB_QSIZE3_3:    equ    7                                         ; Queue Channel 3 Buffer Size Bit 3
; bit position masks
mQC3SZB_QBASE0_3:   equ    %00000001
mQC3SZB_QBASE1_3:   equ    %00000010
mQC3SZB_QBASE2_3:   equ    %00000100
mQC3SZB_QBASE3_3:   equ    %00001000
mQC3SZB_QSIZE0_3:   equ    %00010000
mQC3SZB_QSIZE1_3:   equ    %00100000
mQC3SZB_QSIZE2_3:   equ    %01000000
mQC3SZB_QSIZE3_3:   equ    %10000000


;*** QC3REQ - Queue Channel 3 Request Mapping Register; 0x0000021F ***
QC3REQ:             equ    $0000021F                                ;*** QC3REQ - Queue Channel 3 Request Mapping Register; 0x0000021F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
QC3REQ_Q3REQ0:      equ    0                                         ; Select Peripheral Request for Queue Channel 3 Bit 0
QC3REQ_Q3REQ1:      equ    1                                         ; Select Peripheral Request for Queue Channel 3 Bit 1
QC3REQ_Q3REQ2:      equ    2                                         ; Select Peripheral Request for Queue Channel 3 Bit 2
QC3REQ_Q3REQ3:      equ    3                                         ; Select Peripheral Request for Queue Channel 3 Bit 3
; bit position masks
mQC3REQ_Q3REQ0:     equ    %00000001
mQC3REQ_Q3REQ1:     equ    %00000010
mQC3REQ_Q3REQ2:     equ    %00000100
mQC3REQ_Q3REQ3:     equ    %00001000


;*** QC4DR - Queue Channel 4 FIFO Data Port Register; 0x00000220 ***
QC4DR:              equ    $00000220                                ;*** QC4DR - Queue Channel 4 FIFO Data Port Register; 0x00000220 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
QC4DR_QC4DR0:       equ    0                                         ; Q4DATA Bit 0
QC4DR_QC4DR1:       equ    1                                         ; Q4DATA Bit 1
QC4DR_QC4DR2:       equ    2                                         ; Q4DATA Bit 2
QC4DR_QC4DR3:       equ    3                                         ; Q4DATA Bit 3
QC4DR_QC4DR4:       equ    4                                         ; Q4DATA Bit 4
QC4DR_QC4DR5:       equ    5                                         ; Q4DATA Bit 5
QC4DR_QC4DR6:       equ    6                                         ; Q4DATA Bit 6
QC4DR_QC4DR7:       equ    7                                         ; Q4DATA Bit 7
QC4DR_QC4DR8:       equ    8                                         ; Q4DATA Bit 8
QC4DR_QC4DR9:       equ    9                                         ; Q4DATA Bit 9
QC4DR_QC4DR10:      equ    10                                        ; Q4DATA Bit 10
QC4DR_QC4DR11:      equ    11                                        ; Q4DATA Bit 11
QC4DR_QC4DR12:      equ    12                                        ; Q4DATA Bit 12
QC4DR_QC4DR13:      equ    13                                        ; Q4DATA Bit 13
QC4DR_QC4DR14:      equ    14                                        ; Q4DATA Bit 14
QC4DR_QC4DR15:      equ    15                                        ; Q4DATA Bit 15
; bit position masks
mQC4DR_QC4DR0:      equ    %00000001
mQC4DR_QC4DR1:      equ    %00000010
mQC4DR_QC4DR2:      equ    %00000100
mQC4DR_QC4DR3:      equ    %00001000
mQC4DR_QC4DR4:      equ    %00010000
mQC4DR_QC4DR5:      equ    %00100000
mQC4DR_QC4DR6:      equ    %01000000
mQC4DR_QC4DR7:      equ    %10000000
mQC4DR_QC4DR8:      equ    %100000000
mQC4DR_QC4DR9:      equ    %1000000000
mQC4DR_QC4DR10:     equ    %10000000000
mQC4DR_QC4DR11:     equ    %100000000000
mQC4DR_QC4DR12:     equ    %1000000000000
mQC4DR_QC4DR13:     equ    %10000000000000
mQC4DR_QC4DR14:     equ    %100000000000000
mQC4DR_QC4DR15:     equ    %1000000000000000


;*** QC4BP - Queue Channel 4 Begin Pointer; 0x00000222 ***
QC4BP:              equ    $00000222                                ;*** QC4BP - Queue Channel 4 Begin Pointer; 0x00000222 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
QC4BP_BEGPTR40:     equ    0                                         ; Begin Pointer for Queue Channel 4 FIFO Bit 0
QC4BP_BEGPTR41:     equ    1                                         ; Begin Pointer for Queue Channel 4 FIFO Bit 1
QC4BP_BEGPTR42:     equ    2                                         ; Begin Pointer for Queue Channel 4 FIFO Bit 2
QC4BP_BEGPTR43:     equ    3                                         ; Begin Pointer for Queue Channel 4 FIFO Bit 3
QC4BP_BEGPTR44:     equ    4                                         ; Begin Pointer for Queue Channel 4 FIFO Bit 4
QC4BP_BEGPTR45:     equ    5                                         ; Begin Pointer for Queue Channel 4 FIFO Bit 5
QC4BP_BEGPTR46:     equ    6                                         ; Begin Pointer for Queue Channel 4 FIFO Bit 6
QC4BP_BEGPTR47:     equ    7                                         ; Begin Pointer for Queue Channel 4 FIFO Bit 7
QC4BP_BEGPTR48:     equ    8                                         ; Begin Pointer for Queue Channel 4 FIFO Bit 8
QC4BP_BEGPTR49:     equ    9                                         ; Begin Pointer for Queue Channel 4 FIFO Bit 9
QC4BP_BEGPTR410:    equ    10                                        ; Begin Pointer for Queue Channel 4 FIFO Bit 10
QC4BP_BEGPTR411:    equ    11                                        ; Begin Pointer for Queue Channel 4 FIFO Bit 11
; bit position masks
mQC4BP_BEGPTR40:    equ    %00000001
mQC4BP_BEGPTR41:    equ    %00000010
mQC4BP_BEGPTR42:    equ    %00000100
mQC4BP_BEGPTR43:    equ    %00001000
mQC4BP_BEGPTR44:    equ    %00010000
mQC4BP_BEGPTR45:    equ    %00100000
mQC4BP_BEGPTR46:    equ    %01000000
mQC4BP_BEGPTR47:    equ    %10000000
mQC4BP_BEGPTR48:    equ    %100000000
mQC4BP_BEGPTR49:    equ    %1000000000
mQC4BP_BEGPTR410:   equ    %10000000000
mQC4BP_BEGPTR411:   equ    %100000000000


;*** QC4EP - Queue Channel 4 End Pointer; 0x00000224 ***
QC4EP:              equ    $00000224                                ;*** QC4EP - Queue Channel 4 End Pointer; 0x00000224 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
QC4EP_ENDPTR40:     equ    0                                         ; End Pointer for Queue Channel 4 FIFO Bit 0
QC4EP_ENDPTR41:     equ    1                                         ; End Pointer for Queue Channel 4 FIFO Bit 1
QC4EP_ENDPTR42:     equ    2                                         ; End Pointer for Queue Channel 4 FIFO Bit 2
QC4EP_ENDPTR43:     equ    3                                         ; End Pointer for Queue Channel 4 FIFO Bit 3
QC4EP_ENDPTR44:     equ    4                                         ; End Pointer for Queue Channel 4 FIFO Bit 4
QC4EP_ENDPTR45:     equ    5                                         ; End Pointer for Queue Channel 4 FIFO Bit 5
QC4EP_ENDPTR46:     equ    6                                         ; End Pointer for Queue Channel 4 FIFO Bit 6
QC4EP_ENDPTR47:     equ    7                                         ; End Pointer for Queue Channel 4 FIFO Bit 7
QC4EP_ENDPTR48:     equ    8                                         ; End Pointer for Queue Channel 4 FIFO Bit 8
QC4EP_ENDPTR49:     equ    9                                         ; End Pointer for Queue Channel 4 FIFO Bit 9
QC4EP_ENDPTR410:    equ    10                                        ; End Pointer for Queue Channel 4 FIFO Bit 10
QC4EP_ENDPTR411:    equ    11                                        ; End Pointer for Queue Channel 4 FIFO Bit 11
; bit position masks
mQC4EP_ENDPTR40:    equ    %00000001
mQC4EP_ENDPTR41:    equ    %00000010
mQC4EP_ENDPTR42:    equ    %00000100
mQC4EP_ENDPTR43:    equ    %00001000
mQC4EP_ENDPTR44:    equ    %00010000
mQC4EP_ENDPTR45:    equ    %00100000
mQC4EP_ENDPTR46:    equ    %01000000
mQC4EP_ENDPTR47:    equ    %10000000
mQC4EP_ENDPTR48:    equ    %100000000
mQC4EP_ENDPTR49:    equ    %1000000000
mQC4EP_ENDPTR410:   equ    %10000000000
mQC4EP_ENDPTR411:   equ    %100000000000


;*** QC4CR - Queue Channel 4 Control Register; 0x00000226 ***
QC4CR:              equ    $00000226                                ;*** QC4CR - Queue Channel 4 Control Register; 0x00000226 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
QC4CR_Q4PRST:       equ    0                                         ; Queue Channel 4 Pointers Reset
QC4CR_Q416EN:       equ    2                                         ; Configure Channel 4 for 16-bit/8-bit Transfers
QC4CR_Q4SML:        equ    3                                         ; Queue Channel 4 Small Buffer Select
QC4CR_Q4EN:         equ    4                                         ; Queue Channel 4 Enable
QC4CR_Q4FIE:        equ    5                                         ; Queue Channel 4 Full Interrupt Enable
QC4CR_Q4EIE:        equ    6                                         ; Queue Channel 4 Empty Interrupt Enable
QC4CR_Q4VIE:        equ    7                                         ; Queue Channel 4 Valid Interrupt Enable
; bit position masks
mQC4CR_Q4PRST:      equ    %00000001
mQC4CR_Q416EN:      equ    %00000100
mQC4CR_Q4SML:       equ    %00001000
mQC4CR_Q4EN:        equ    %00010000
mQC4CR_Q4FIE:       equ    %00100000
mQC4CR_Q4EIE:       equ    %01000000
mQC4CR_Q4VIE:       equ    %10000000


;*** QC4SR - Queue Channel 4 Status Register; 0x00000227 ***
QC4SR:              equ    $00000227                                ;*** QC4SR - Queue Channel 4 Status Register; 0x00000227 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
QC4SR_Q4EIF:        equ    2                                         ; Queue Channel 4 Empty Interrupt Flag
QC4SR_Q4FIF:        equ    3                                         ; Queue Channel 4 Full Interrupt Flag
QC4SR_Q4VIF:        equ    4                                         ; Queue Channel 4 Valid Data Interrupt Flag
QC4SR_Q4ESF:        equ    5                                         ; Queue Channel 4 Empty Status Flag
QC4SR_Q4FSF:        equ    6                                         ; Queue Channel 4 Full Status Flag
QC4SR_Q4VSF:        equ    7                                         ; Queue Channel 4 Valid Data Control and Status Flag
; bit position masks
mQC4SR_Q4EIF:       equ    %00000100
mQC4SR_Q4FIF:       equ    %00001000
mQC4SR_Q4VIF:       equ    %00010000
mQC4SR_Q4ESF:       equ    %00100000
mQC4SR_Q4FSF:       equ    %01000000
mQC4SR_Q4VSF:       equ    %10000000


;*** QC4SZB - Buffer Size/Base Address Register for Queue Channel 4; 0x00000228 ***
QC4SZB:             equ    $00000228                                ;*** QC4SZB - Buffer Size/Base Address Register for Queue Channel 4; 0x00000228 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
QC4SZB_QBASE0_4:    equ    0                                         ; Queue Channel 4 Buffer Base Address Bit 0
QC4SZB_QBASE1_4:    equ    1                                         ; Queue Channel 4 Buffer Base Address Bit 1
QC4SZB_QBASE2_4:    equ    2                                         ; Queue Channel 4 Buffer Base Address Bit 2
QC4SZB_QBASE3_4:    equ    3                                         ; Queue Channel 4 Buffer Base Address Bit 3
QC4SZB_QSIZE0_4:    equ    4                                         ; Queue Channel 4 Buffer Size Bit 0
QC4SZB_QSIZE1_4:    equ    5                                         ; Queue Channel 4 Buffer Size Bit 1
QC4SZB_QSIZE2_4:    equ    6                                         ; Queue Channel 4 Buffer Size Bit 2
QC4SZB_QSIZE3_4:    equ    7                                         ; Queue Channel 4 Buffer Size Bit 3
; bit position masks
mQC4SZB_QBASE0_4:   equ    %00000001
mQC4SZB_QBASE1_4:   equ    %00000010
mQC4SZB_QBASE2_4:   equ    %00000100
mQC4SZB_QBASE3_4:   equ    %00001000
mQC4SZB_QSIZE0_4:   equ    %00010000
mQC4SZB_QSIZE1_4:   equ    %00100000
mQC4SZB_QSIZE2_4:   equ    %01000000
mQC4SZB_QSIZE3_4:   equ    %10000000


;*** QC4REQ - Queue Channel 4 Request Mapping Register; 0x00000229 ***
QC4REQ:             equ    $00000229                                ;*** QC4REQ - Queue Channel 4 Request Mapping Register; 0x00000229 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
QC4REQ_Q4REQ0:      equ    0                                         ; Select Peripheral Request for Queue Channel 4 Bit 0
QC4REQ_Q4REQ1:      equ    1                                         ; Select Peripheral Request for Queue Channel 4 Bit 1
QC4REQ_Q4REQ2:      equ    2                                         ; Select Peripheral Request for Queue Channel 4 Bit 2
QC4REQ_Q4REQ3:      equ    3                                         ; Select Peripheral Request for Queue Channel 4 Bit 3
; bit position masks
mQC4REQ_Q4REQ0:     equ    %00000001
mQC4REQ_Q4REQ1:     equ    %00000010
mQC4REQ_Q4REQ2:     equ    %00000100
mQC4REQ_Q4REQ3:     equ    %00001000


;*** QC12DCR - Queue Channel 1+2 Double Buffer Control Register; 0x0000022A ***
QC12DCR:            equ    $0000022A                                ;*** QC12DCR - Queue Channel 1+2 Double Buffer Control Register; 0x0000022A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
QC12DCR_DBRST_12:   equ    0                                         ; Double Buffer Status and Pointer Register Reset
QC12DCR_DBFIE_12:   equ    1                                         ; Queue Channel Double Buffer Full Interrupt Enable
QC12DCR_DBEIE_12:   equ    2                                         ; Queue Channel Double Buffer Empty Interrupt Enable
QC12DCR_DBTIE_12:   equ    3                                         ; Double Buffer Block Transfer Complete Interrupt Enable
QC12DCR_SBTE_12:    equ    4                                         ; Single Bock Transfer mode enable
; bit position masks
mQC12DCR_DBRST_12:  equ    %00000001
mQC12DCR_DBFIE_12:  equ    %00000010
mQC12DCR_DBEIE_12:  equ    %00000100
mQC12DCR_DBTIE_12:  equ    %00001000
mQC12DCR_SBTE_12:   equ    %00010000


;*** QC34DCR - Queue Channel 3+4 Double Buffer Control Register; 0x0000022B ***
QC34DCR:            equ    $0000022B                                ;*** QC34DCR - Queue Channel 3+4 Double Buffer Control Register; 0x0000022B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
QC34DCR_DBRST_34:   equ    0                                         ; Double Buffer Status and Pointer Register Reset
QC34DCR_DBFIE_34:   equ    1                                         ; Queue Channel Double Buffer Full Interrupt Enable
QC34DCR_DBEIE_34:   equ    2                                         ; Queue Channel Double Buffer Empty Interrupt Enable
QC34DCR_DBTIE_34:   equ    3                                         ; Double Buffer Block Transfer Complete Interrupt Enable
QC34DCR_SBTE_34:    equ    4                                         ; Single Bock Transfer mode enable
; bit position masks
mQC34DCR_DBRST_34:  equ    %00000001
mQC34DCR_DBFIE_34:  equ    %00000010
mQC34DCR_DBEIE_34:  equ    %00000100
mQC34DCR_DBTIE_34:  equ    %00001000
mQC34DCR_SBTE_34:   equ    %00010000


;*** QC12DSR - Queue Channel 1+2 Double Buffer Status Register; 0x0000022C ***
QC12DSR:            equ    $0000022C                                ;*** QC12DSR - Queue Channel 1+2 Double Buffer Status Register; 0x0000022C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
QC12DSR_DBSF0_12:   equ    0                                         ; Double Buffer Status Flag Bit 0
QC12DSR_DBSF1_12:   equ    1                                         ; Double Buffer Status Flag Bit 1
QC12DSR_DBFIF_12:   equ    5                                         ; Double Buffer Full Interrupt Flag
QC12DSR_DBEIF_12:   equ    6                                         ; Double Buffer Empty Interrupt Flag
QC12DSR_DBTCIF_12:  equ    7                                         ; Block Transfer Complete Interrupt Flag
; bit position masks
mQC12DSR_DBSF0_12:  equ    %00000001
mQC12DSR_DBSF1_12:  equ    %00000010
mQC12DSR_DBFIF_12:  equ    %00100000
mQC12DSR_DBEIF_12:  equ    %01000000
mQC12DSR_DBTCIF_12: equ    %10000000


;*** QC34DSR - Queue Channel 3+4 Double Buffer Status Register; 0x0000022D ***
QC34DSR:            equ    $0000022D                                ;*** QC34DSR - Queue Channel 3+4 Double Buffer Status Register; 0x0000022D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
QC34DSR_DBSF0_34:   equ    0                                         ; Double Buffer Status Flag Bit 0
QC34DSR_DBSF1_34:   equ    1                                         ; Double Buffer Status Flag Bit 1
QC34DSR_DBFIF_34:   equ    5                                         ; Double Buffer Full Interrupt Flag
QC34DSR_DBEIF_34:   equ    6                                         ; Double Buffer Empty Interrupt Flag
QC34DSR_DBTCIF_34:  equ    7                                         ; Block Transfer Complete Interrupt Flag
; bit position masks
mQC34DSR_DBSF0_34:  equ    %00000001
mQC34DSR_DBSF1_34:  equ    %00000010
mQC34DSR_DBFIF_34:  equ    %00100000
mQC34DSR_DBEIF_34:  equ    %01000000
mQC34DSR_DBTCIF_34: equ    %10000000


;*** QCDCT - Queue Channel Double Buffer Counter Register; 0x0000022E ***
QCDCT:              equ    $0000022E                                ;*** QCDCT - Queue Channel Double Buffer Counter Register; 0x0000022E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
QCDCT_DBTRAN120:    equ    0                                         ; Number of buffers to be transfered for Queue Channel 1+2 Bit 0
QCDCT_DBTRAN121:    equ    1                                         ; Number of buffers to be transfered for Queue Channel 1+2 Bit 1
QCDCT_DBTRAN122:    equ    2                                         ; Number of buffers to be transfered for Queue Channel 1+2 Bit 2
QCDCT_DBTRAN123:    equ    3                                         ; Number of buffers to be transfered for Queue Channel 1+2 Bit 3
QCDCT_DBTRAN124:    equ    4                                         ; Number of buffers to be transfered for Queue Channel 1+2 Bit 4
QCDCT_DBTRAN125:    equ    5                                         ; Number of buffers to be transfered for Queue Channel 1+2 Bit 5
QCDCT_DBTRAN126:    equ    6                                         ; Number of buffers to be transfered for Queue Channel 1+2 Bit 6
QCDCT_DBTRAN127:    equ    7                                         ; Number of buffers to be transfered for Queue Channel 1+2 Bit 7
QCDCT_DBTRAN340:    equ    8                                         ; Number of buffers to be transfered for Queue Channel 3+4 Bit 0
QCDCT_DBTRAN341:    equ    9                                         ; Number of buffers to be transfered for Queue Channel 3+4 Bit 1
QCDCT_DBTRAN342:    equ    10                                        ; Number of buffers to be transfered for Queue Channel 3+4 Bit 2
QCDCT_DBTRAN343:    equ    11                                        ; Number of buffers to be transfered for Queue Channel 3+4 Bit 3
QCDCT_DBTRAN344:    equ    12                                        ; Number of buffers to be transfered for Queue Channel 3+4 Bit 4
QCDCT_DBTRAN345:    equ    13                                        ; Number of buffers to be transfered for Queue Channel 3+4 Bit 5
QCDCT_DBTRAN346:    equ    14                                        ; Number of buffers to be transfered for Queue Channel 3+4 Bit 6
QCDCT_DBTRAN347:    equ    15                                        ; Number of buffers to be transfered for Queue Channel 3+4 Bit 7
; bit position masks
mQCDCT_DBTRAN120:   equ    %00000001
mQCDCT_DBTRAN121:   equ    %00000010
mQCDCT_DBTRAN122:   equ    %00000100
mQCDCT_DBTRAN123:   equ    %00001000
mQCDCT_DBTRAN124:   equ    %00010000
mQCDCT_DBTRAN125:   equ    %00100000
mQCDCT_DBTRAN126:   equ    %01000000
mQCDCT_DBTRAN127:   equ    %10000000
mQCDCT_DBTRAN340:   equ    %100000000
mQCDCT_DBTRAN341:   equ    %1000000000
mQCDCT_DBTRAN342:   equ    %10000000000
mQCDCT_DBTRAN343:   equ    %100000000000
mQCDCT_DBTRAN344:   equ    %1000000000000
mQCDCT_DBTRAN345:   equ    %10000000000000
mQCDCT_DBTRAN346:   equ    %100000000000000
mQCDCT_DBTRAN347:   equ    %1000000000000000


;*** QC12DSHR - Queue Channel 1+2 Double Buffer Software Handshake Register; 0x00000230 ***
QC12DSHR:           equ    $00000230                                ;*** QC12DSHR - Queue Channel 1+2 Double Buffer Software Handshake Register; 0x00000230 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
QC12DSHR_DTHE_12:   equ    0                                         ; Queue Channel Double Buffer Transmit Handshake Enable
QC12DSHR_DRHE_12:   equ    1                                         ; Queue Channel Double Buffer Receive Handshake Enable
QC12DSHR_TXDA_12:   equ    4                                         ; Transmitted Data Acknowledge
QC12DSHR_TXRD_12:   equ    5                                         ; Resend Transmitted Data
QC12DSHR_RXDA_12:   equ    6                                         ; Received Data Acknowledge
QC12DSHR_RXDF_12:   equ    7                                         ; Received Data Flush
; bit position masks
mQC12DSHR_DTHE_12:  equ    %00000001
mQC12DSHR_DRHE_12:  equ    %00000010
mQC12DSHR_TXDA_12:  equ    %00010000
mQC12DSHR_TXRD_12:  equ    %00100000
mQC12DSHR_RXDA_12:  equ    %01000000
mQC12DSHR_RXDF_12:  equ    %10000000


;*** QC34DSHR - Queue Channel 3+4 Double Buffer Software Handshake Register; 0x00000231 ***
QC34DSHR:           equ    $00000231                                ;*** QC34DSHR - Queue Channel 3+4 Double Buffer Software Handshake Register; 0x00000231 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
QC34DSHR_DTHE_34:   equ    0                                         ; Queue Channel Double Buffer Transmit Handshake Enable
QC34DSHR_DRHE_34:   equ    1                                         ; Queue Channel Double Buffer Receive Handshake Enable
QC34DSHR_TXDA_34:   equ    4                                         ; Transmitted Data Acknowledge
QC34DSHR_TXRD_34:   equ    5                                         ; Resend Transmitted Data
QC34DSHR_RXDA_34:   equ    6                                         ; Received Data Acknowledge
QC34DSHR_RXDF_34:   equ    7                                         ; Received Data Flush
; bit position masks
mQC34DSHR_DTHE_34:  equ    %00000001
mQC34DSHR_DRHE_34:  equ    %00000010
mQC34DSHR_TXDA_34:  equ    %00010000
mQC34DSHR_TXRD_34:  equ    %00100000
mQC34DSHR_RXDA_34:  equ    %01000000
mQC34DSHR_RXDF_34:  equ    %10000000


;*** PTT - Port T I/O Register; 0x00000240 ***
PTT:                equ    $00000240                                ;*** PTT - Port T I/O Register; 0x00000240 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTT_PTT0:           equ    0                                         ; Port T Bit 0
PTT_PTT1:           equ    1                                         ; Port T Bit 1
PTT_PTT2:           equ    2                                         ; Port T Bit 2
PTT_PTT3:           equ    3                                         ; Port T Bit 3
; bit position masks
mPTT_PTT0:          equ    %00000001
mPTT_PTT1:          equ    %00000010
mPTT_PTT2:          equ    %00000100
mPTT_PTT3:          equ    %00001000


;*** PTIT - Port T Input Register; 0x00000241 ***
PTIT:               equ    $00000241                                ;*** PTIT - Port T Input Register; 0x00000241 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTIT_PTIT0:         equ    0                                         ; Port T Bit 0
PTIT_PTIT1:         equ    1                                         ; Port T Bit 1
PTIT_PTIT2:         equ    2                                         ; Port T Bit 2
PTIT_PTIT3:         equ    3                                         ; Port T Bit 3
; bit position masks
mPTIT_PTIT0:        equ    %00000001
mPTIT_PTIT1:        equ    %00000010
mPTIT_PTIT2:        equ    %00000100
mPTIT_PTIT3:        equ    %00001000


;*** DDRT - Port T Data Direction Register; 0x00000242 ***
DDRT:               equ    $00000242                                ;*** DDRT - Port T Data Direction Register; 0x00000242 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRT_DDRT0:         equ    0                                         ; Data Direction Port T Bit 0
DDRT_DDRT1:         equ    1                                         ; Data Direction Port T Bit 1
DDRT_DDRT2:         equ    2                                         ; Data Direction Port T Bit 2
DDRT_DDRT3:         equ    3                                         ; Data Direction Port T Bit 3
; bit position masks
mDDRT_DDRT0:        equ    %00000001
mDDRT_DDRT1:        equ    %00000010
mDDRT_DDRT2:        equ    %00000100
mDDRT_DDRT3:        equ    %00001000


;*** RDRT - Port T Reduced Drive Register; 0x00000243 ***
RDRT:               equ    $00000243                                ;*** RDRT - Port T Reduced Drive Register; 0x00000243 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RDRT_RDRT0:         equ    0                                         ; Reduced Drive Port T Bit 0
RDRT_RDRT1:         equ    1                                         ; Reduced Drive Port T Bit 1
RDRT_RDRT2:         equ    2                                         ; Reduced Drive Port T Bit 2
RDRT_RDRT3:         equ    3                                         ; Reduced Drive Port T Bit 3
; bit position masks
mRDRT_RDRT0:        equ    %00000001
mRDRT_RDRT1:        equ    %00000010
mRDRT_RDRT2:        equ    %00000100
mRDRT_RDRT3:        equ    %00001000


;*** PERT - Port T Pull Device Enable Register; 0x00000244 ***
PERT:               equ    $00000244                                ;*** PERT - Port T Pull Device Enable Register; 0x00000244 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PERT_PERT0:         equ    0                                         ; Pull Device Enable Port T Bit 0
PERT_PERT1:         equ    1                                         ; Pull Device Enable Port T Bit 1
PERT_PERT2:         equ    2                                         ; Pull Device Enable Port T Bit 2
PERT_PERT3:         equ    3                                         ; Pull Device Enable Port T Bit 3
; bit position masks
mPERT_PERT0:        equ    %00000001
mPERT_PERT1:        equ    %00000010
mPERT_PERT2:        equ    %00000100
mPERT_PERT3:        equ    %00001000


;*** PPST - Port T Polarity Select Register; 0x00000245 ***
PPST:               equ    $00000245                                ;*** PPST - Port T Polarity Select Register; 0x00000245 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PPST_PPST0:         equ    0                                         ; Pull Select Port T Bit 0
PPST_PPST1:         equ    1                                         ; Pull Select Port T Bit 1
PPST_PPST2:         equ    2                                         ; Pull Select Port T Bit 2
PPST_PPST3:         equ    3                                         ; Pull Select Port T Bit 3
; bit position masks
mPPST_PPST0:        equ    %00000001
mPPST_PPST1:        equ    %00000010
mPPST_PPST2:        equ    %00000100
mPPST_PPST3:        equ    %00001000


;*** PTM - Port M I/O Register; 0x00000248 ***
PTM:                equ    $00000248                                ;*** PTM - Port M I/O Register; 0x00000248 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTM_PTM0:           equ    0                                         ; Port M Bit 0
PTM_PTM1:           equ    1                                         ; Port M Bit 1
PTM_PTM2:           equ    2                                         ; Port M Bit 2
PTM_PTM3:           equ    3                                         ; Port M Bit 3
PTM_PTM4:           equ    4                                         ; Port M Bit 4
PTM_PTM5:           equ    5                                         ; Port M Bit 5
; bit position masks
mPTM_PTM0:          equ    %00000001
mPTM_PTM1:          equ    %00000010
mPTM_PTM2:          equ    %00000100
mPTM_PTM3:          equ    %00001000
mPTM_PTM4:          equ    %00010000
mPTM_PTM5:          equ    %00100000


;*** PTIM - Port M Input Register; 0x00000249 ***
PTIM:               equ    $00000249                                ;*** PTIM - Port M Input Register; 0x00000249 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTIM_PTIM0:         equ    0                                         ; Port M Bit 0
PTIM_PTIM1:         equ    1                                         ; Port M Bit 1
PTIM_PTIM2:         equ    2                                         ; Port M Bit 2
PTIM_PTIM3:         equ    3                                         ; Port M Bit 3
PTIM_PTIM4:         equ    4                                         ; Port M Bit 4
PTIM_PTIM5:         equ    5                                         ; Port M Bit 5
; bit position masks
mPTIM_PTIM0:        equ    %00000001
mPTIM_PTIM1:        equ    %00000010
mPTIM_PTIM2:        equ    %00000100
mPTIM_PTIM3:        equ    %00001000
mPTIM_PTIM4:        equ    %00010000
mPTIM_PTIM5:        equ    %00100000


;*** DDRM - Port M Data Direction Register; 0x0000024A ***
DDRM:               equ    $0000024A                                ;*** DDRM - Port M Data Direction Register; 0x0000024A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRM_DDRM0:         equ    0                                         ; Data Direction Port M Bit 0
DDRM_DDRM1:         equ    1                                         ; Data Direction Port M Bit 1
DDRM_DDRM2:         equ    2                                         ; Data Direction Port M Bit 2
DDRM_DDRM3:         equ    3                                         ; Data Direction Port M Bit 3
DDRM_DDRM4:         equ    4                                         ; Data Direction Port M Bit 4
DDRM_DDRM5:         equ    5                                         ; Data Direction Port M Bit 5
; bit position masks
mDDRM_DDRM0:        equ    %00000001
mDDRM_DDRM1:        equ    %00000010
mDDRM_DDRM2:        equ    %00000100
mDDRM_DDRM3:        equ    %00001000
mDDRM_DDRM4:        equ    %00010000
mDDRM_DDRM5:        equ    %00100000


;*** RDRM - Port M Reduced Drive Register; 0x0000024B ***
RDRM:               equ    $0000024B                                ;*** RDRM - Port M Reduced Drive Register; 0x0000024B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RDRM_RDRM0:         equ    0                                         ; Reduced Drive Port M Bit 0
RDRM_RDRM1:         equ    1                                         ; Reduced Drive Port M Bit 1
RDRM_RDRM2:         equ    2                                         ; Reduced Drive Port M Bit 2
RDRM_RDRM3:         equ    3                                         ; Reduced Drive Port M Bit 3
RDRM_RDRM4:         equ    4                                         ; Reduced Drive Port M Bit 4
RDRM_RDRM5:         equ    5                                         ; Reduced Drive Port M Bit 5
; bit position masks
mRDRM_RDRM0:        equ    %00000001
mRDRM_RDRM1:        equ    %00000010
mRDRM_RDRM2:        equ    %00000100
mRDRM_RDRM3:        equ    %00001000
mRDRM_RDRM4:        equ    %00010000
mRDRM_RDRM5:        equ    %00100000


;*** PERM - Port M Pull Device Enable Register; 0x0000024C ***
PERM:               equ    $0000024C                                ;*** PERM - Port M Pull Device Enable Register; 0x0000024C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PERM_PERM0:         equ    0                                         ; Pull Device Enable Port M Bit 0
PERM_PERM1:         equ    1                                         ; Pull Device Enable Port M Bit 1
PERM_PERM2:         equ    2                                         ; Pull Device Enable Port M Bit 2
PERM_PERM3:         equ    3                                         ; Pull Device Enable Port M Bit 3
PERM_PERM4:         equ    4                                         ; Pull Device Enable Port M Bit 4
PERM_PERM5:         equ    5                                         ; Pull Device Enable Port M Bit 5
; bit position masks
mPERM_PERM0:        equ    %00000001
mPERM_PERM1:        equ    %00000010
mPERM_PERM2:        equ    %00000100
mPERM_PERM3:        equ    %00001000
mPERM_PERM4:        equ    %00010000
mPERM_PERM5:        equ    %00100000


;*** PPSM - Port M Polarity Select Register; 0x0000024D ***
PPSM:               equ    $0000024D                                ;*** PPSM - Port M Polarity Select Register; 0x0000024D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PPSM_PPSM0:         equ    0                                         ; Pull Select Port M Bit 0
PPSM_PPSM1:         equ    1                                         ; Pull Select Port M Bit 1
PPSM_PPSM2:         equ    2                                         ; Pull Select Port M Bit 2
PPSM_PPSM3:         equ    3                                         ; Pull Select Port M Bit 3
PPSM_PPSM4:         equ    4                                         ; Pull Select Port M Bit 4
PPSM_PPSM5:         equ    5                                         ; Pull Select Port M Bit 5
; bit position masks
mPPSM_PPSM0:        equ    %00000001
mPPSM_PPSM1:        equ    %00000010
mPPSM_PPSM2:        equ    %00000100
mPPSM_PPSM3:        equ    %00001000
mPPSM_PPSM4:        equ    %00010000
mPPSM_PPSM5:        equ    %00100000


;*** PTJ - Port J I/O Register; 0x00000250 ***
PTJ:                equ    $00000250                                ;*** PTJ - Port J I/O Register; 0x00000250 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTJ_PTJ0:           equ    0                                         ; Port J Bit 0
PTJ_PTJ1:           equ    1                                         ; Port J Bit 1
PTJ_PTJ2:           equ    2                                         ; Port J Bit 2
; bit position masks
mPTJ_PTJ0:          equ    %00000001
mPTJ_PTJ1:          equ    %00000010
mPTJ_PTJ2:          equ    %00000100


;*** PTIJ - Port J Input Register; 0x00000251 ***
PTIJ:               equ    $00000251                                ;*** PTIJ - Port J Input Register; 0x00000251 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTIJ_PTIJ0:         equ    0                                         ; Port J Bit 0
PTIJ_PTIJ1:         equ    1                                         ; Port J Bit 1
PTIJ_PTIJ2:         equ    2                                         ; Port J Bit 2
; bit position masks
mPTIJ_PTIJ0:        equ    %00000001
mPTIJ_PTIJ1:        equ    %00000010
mPTIJ_PTIJ2:        equ    %00000100


;*** DDRJ - Port J Data Direction Register; 0x00000252 ***
DDRJ:               equ    $00000252                                ;*** DDRJ - Port J Data Direction Register; 0x00000252 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRJ_DDRJ0:         equ    0                                         ; Data Direction Port J Bit 0
DDRJ_DDRJ1:         equ    1                                         ; Data Direction Port J Bit 1
DDRJ_DDRJ2:         equ    2                                         ; Data Direction Port J Bit 2
; bit position masks
mDDRJ_DDRJ0:        equ    %00000001
mDDRJ_DDRJ1:        equ    %00000010
mDDRJ_DDRJ2:        equ    %00000100


;*** RDRJ - Port J Reduced Drive Register; 0x00000253 ***
RDRJ:               equ    $00000253                                ;*** RDRJ - Port J Reduced Drive Register; 0x00000253 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RDRJ_RDRJ0:         equ    0                                         ; Reduced Drive Port J Bit 0
RDRJ_RDRJ1:         equ    1                                         ; Reduced Drive Port J Bit 1
RDRJ_RDRJ2:         equ    2                                         ; Reduced Drive Port J Bit 2
; bit position masks
mRDRJ_RDRJ0:        equ    %00000001
mRDRJ_RDRJ1:        equ    %00000010
mRDRJ_RDRJ2:        equ    %00000100


;*** PERJ - Port J Pull Device Enable Register; 0x00000254 ***
PERJ:               equ    $00000254                                ;*** PERJ - Port J Pull Device Enable Register; 0x00000254 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PERJ_PERJ0:         equ    0                                         ; Pull Device Enable Port J Bit 0
PERJ_PERJ1:         equ    1                                         ; Pull Device Enable Port J Bit 1
PERJ_PERJ2:         equ    2                                         ; Pull Device Enable Port J Bit 2
; bit position masks
mPERJ_PERJ0:        equ    %00000001
mPERJ_PERJ1:        equ    %00000010
mPERJ_PERJ2:        equ    %00000100


;*** PPSJ - PortJP Polarity Select Register; 0x00000255 ***
PPSJ:               equ    $00000255                                ;*** PPSJ - PortJP Polarity Select Register; 0x00000255 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PPSJ_PPSJ0:         equ    0                                         ; Pull Select Port J Bit 0
PPSJ_PPSJ1:         equ    1                                         ; Pull Select Port J Bit 1
PPSJ_PPSJ2:         equ    2                                         ; Pull Select Port J Bit 2
; bit position masks
mPPSJ_PPSJ0:        equ    %00000001
mPPSJ_PPSJ1:        equ    %00000010
mPPSJ_PPSJ2:        equ    %00000100


;*** MODRR - Module Routing Register; 0x00000257 ***
MODRR:              equ    $00000257                                ;*** MODRR - Module Routing Register; 0x00000257 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MODRR_MODRR0:       equ    0                                         ; Module Routing Bit 0
MODRR_MODRR1:       equ    1                                         ; Module Routing Bit 1
MODRR_MODRR2:       equ    2                                         ; Module Routing Bit 2
MODRR_MODRR3:       equ    3                                         ; Module Routing Bit 3
MODRR_MODRR4:       equ    4                                         ; Module Routing Bit 4
; bit position masks
mMODRR_MODRR0:      equ    %00000001
mMODRR_MODRR1:      equ    %00000010
mMODRR_MODRR2:      equ    %00000100
mMODRR_MODRR3:      equ    %00001000
mMODRR_MODRR4:      equ    %00010000


;*** PTP - Port P I/O Register; 0x00000258 ***
PTP:                equ    $00000258                                ;*** PTP - Port P I/O Register; 0x00000258 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTP_PTP0:           equ    0                                         ; Port P Bit 0
PTP_PTP1:           equ    1                                         ; Port P Bit 1
PTP_PTP2:           equ    2                                         ; Port P Bit 2
PTP_PTP3:           equ    3                                         ; Port P Bit 3
PTP_PTP4:           equ    4                                         ; Port P Bit 4
PTP_PTP5:           equ    5                                         ; Port P Bit 5
PTP_PTP6:           equ    6                                         ; Port P Bit 6
PTP_PTP7:           equ    7                                         ; Port P Bit 7
; bit position masks
mPTP_PTP0:          equ    %00000001
mPTP_PTP1:          equ    %00000010
mPTP_PTP2:          equ    %00000100
mPTP_PTP3:          equ    %00001000
mPTP_PTP4:          equ    %00010000
mPTP_PTP5:          equ    %00100000
mPTP_PTP6:          equ    %01000000
mPTP_PTP7:          equ    %10000000


;*** PTIP - Port P Input Register; 0x00000259 ***
PTIP:               equ    $00000259                                ;*** PTIP - Port P Input Register; 0x00000259 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTIP_PTIP0:         equ    0                                         ; Port P Bit 0
PTIP_PTIP1:         equ    1                                         ; Port P Bit 1
PTIP_PTIP2:         equ    2                                         ; Port P Bit 2
PTIP_PTIP3:         equ    3                                         ; Port P Bit 3
PTIP_PTIP4:         equ    4                                         ; Port P Bit 4
PTIP_PTIP5:         equ    5                                         ; Port P Bit 5
PTIP_PTIP6:         equ    6                                         ; Port P Bit 6
PTIP_PTIP7:         equ    7                                         ; Port P Bit 7
; bit position masks
mPTIP_PTIP0:        equ    %00000001
mPTIP_PTIP1:        equ    %00000010
mPTIP_PTIP2:        equ    %00000100
mPTIP_PTIP3:        equ    %00001000
mPTIP_PTIP4:        equ    %00010000
mPTIP_PTIP5:        equ    %00100000
mPTIP_PTIP6:        equ    %01000000
mPTIP_PTIP7:        equ    %10000000


;*** DDRP - Port P Data Direction Register; 0x0000025A ***
DDRP:               equ    $0000025A                                ;*** DDRP - Port P Data Direction Register; 0x0000025A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRP_DDRP0:         equ    0                                         ; Data Direction Port P Bit 0
DDRP_DDRP1:         equ    1                                         ; Data Direction Port P Bit 1
DDRP_DDRP2:         equ    2                                         ; Data Direction Port P Bit 2
DDRP_DDRP3:         equ    3                                         ; Data Direction Port P Bit 3
DDRP_DDRP4:         equ    4                                         ; Data Direction Port P Bit 4
DDRP_DDRP5:         equ    5                                         ; Data Direction Port P Bit 5
DDRP_DDRP6:         equ    6                                         ; Data Direction Port P Bit 6
DDRP_DDRP7:         equ    7                                         ; Data Direction Port P Bit 7
; bit position masks
mDDRP_DDRP0:        equ    %00000001
mDDRP_DDRP1:        equ    %00000010
mDDRP_DDRP2:        equ    %00000100
mDDRP_DDRP3:        equ    %00001000
mDDRP_DDRP4:        equ    %00010000
mDDRP_DDRP5:        equ    %00100000
mDDRP_DDRP6:        equ    %01000000
mDDRP_DDRP7:        equ    %10000000


;*** RDRP - Port P Reduced Drive Register; 0x0000025B ***
RDRP:               equ    $0000025B                                ;*** RDRP - Port P Reduced Drive Register; 0x0000025B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RDRP_RDRP0:         equ    0                                         ; Reduced Drive Port P Bit 0
RDRP_RDRP1:         equ    1                                         ; Reduced Drive Port P Bit 1
RDRP_RDRP2:         equ    2                                         ; Reduced Drive Port P Bit 2
RDRP_RDRP3:         equ    3                                         ; Reduced Drive Port P Bit 3
RDRP_RDRP4:         equ    4                                         ; Reduced Drive Port P Bit 4
RDRP_RDRP5:         equ    5                                         ; Reduced Drive Port P Bit 5
RDRP_RDRP6:         equ    6                                         ; Reduced Drive Port P Bit 6
RDRP_RDRP7:         equ    7                                         ; Reduced Drive Port P Bit 7
; bit position masks
mRDRP_RDRP0:        equ    %00000001
mRDRP_RDRP1:        equ    %00000010
mRDRP_RDRP2:        equ    %00000100
mRDRP_RDRP3:        equ    %00001000
mRDRP_RDRP4:        equ    %00010000
mRDRP_RDRP5:        equ    %00100000
mRDRP_RDRP6:        equ    %01000000
mRDRP_RDRP7:        equ    %10000000


;*** PERP - Port P Pull Device Enable Register; 0x0000025C ***
PERP:               equ    $0000025C                                ;*** PERP - Port P Pull Device Enable Register; 0x0000025C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PERP_PERP0:         equ    0                                         ; Pull Device Enable Port P Bit 0
PERP_PERP1:         equ    1                                         ; Pull Device Enable Port P Bit 1
PERP_PERP2:         equ    2                                         ; Pull Device Enable Port P Bit 2
PERP_PERP3:         equ    3                                         ; Pull Device Enable Port P Bit 3
PERP_PERP4:         equ    4                                         ; Pull Device Enable Port P Bit 4
PERP_PERP5:         equ    5                                         ; Pull Device Enable Port P Bit 5
PERP_PERP6:         equ    6                                         ; Pull Device Enable Port P Bit 6
PERP_PERP7:         equ    7                                         ; Pull Device Enable Port P Bit 7
; bit position masks
mPERP_PERP0:        equ    %00000001
mPERP_PERP1:        equ    %00000010
mPERP_PERP2:        equ    %00000100
mPERP_PERP3:        equ    %00001000
mPERP_PERP4:        equ    %00010000
mPERP_PERP5:        equ    %00100000
mPERP_PERP6:        equ    %01000000
mPERP_PERP7:        equ    %10000000


;*** PPSP - Port P Polarity Select Register; 0x0000025D ***
PPSP:               equ    $0000025D                                ;*** PPSP - Port P Polarity Select Register; 0x0000025D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PPSP_PPSP0:         equ    0                                         ; Pull Select Port P Bit 0
PPSP_PPSP1:         equ    1                                         ; Pull Select Port P Bit 1
PPSP_PPSP2:         equ    2                                         ; Pull Select Port P Bit 2
PPSP_PPSP3:         equ    3                                         ; Pull Select Port P Bit 3
PPSP_PPSP4:         equ    4                                         ; Pull Select Port P Bit 4
PPSP_PPSP5:         equ    5                                         ; Pull Select Port P Bit 5
PPSP_PPSP6:         equ    6                                         ; Pull Select Port P Bit 6
PPSP_PPSP7:         equ    7                                         ; Pull Select Port P Bit 7
; bit position masks
mPPSP_PPSP0:        equ    %00000001
mPPSP_PPSP1:        equ    %00000010
mPPSP_PPSP2:        equ    %00000100
mPPSP_PPSP3:        equ    %00001000
mPPSP_PPSP4:        equ    %00010000
mPPSP_PPSP5:        equ    %00100000
mPPSP_PPSP6:        equ    %01000000
mPPSP_PPSP7:        equ    %10000000


;*** PTQ - Port Q I/O Register; 0x00000260 ***
PTQ:                equ    $00000260                                ;*** PTQ - Port Q I/O Register; 0x00000260 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTQ_PTQ0:           equ    0                                         ; Port Q Bit 0
PTQ_PTQ1:           equ    1                                         ; Port Q Bit 1
PTQ_PTQ2:           equ    2                                         ; Port Q Bit 2
PTQ_PTQ3:           equ    3                                         ; Port Q Bit 3
PTQ_PTQ4:           equ    4                                         ; Port Q Bit 4
PTQ_PTQ5:           equ    5                                         ; Port Q Bit 5
PTQ_PTQ6:           equ    6                                         ; Port Q Bit 6
PTQ_PTQ7:           equ    7                                         ; Port Q Bit 7
; bit position masks
mPTQ_PTQ0:          equ    %00000001
mPTQ_PTQ1:          equ    %00000010
mPTQ_PTQ2:          equ    %00000100
mPTQ_PTQ3:          equ    %00001000
mPTQ_PTQ4:          equ    %00010000
mPTQ_PTQ5:          equ    %00100000
mPTQ_PTQ6:          equ    %01000000
mPTQ_PTQ7:          equ    %10000000


;*** PTIQ - Port Q Input Register; 0x00000261 ***
PTIQ:               equ    $00000261                                ;*** PTIQ - Port Q Input Register; 0x00000261 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTIQ_PTIQ0:         equ    0                                         ; Port Q Bit 0
PTIQ_PTIQ1:         equ    1                                         ; Port Q Bit 1
PTIQ_PTIQ2:         equ    2                                         ; Port Q Bit 2
PTIQ_PTIQ3:         equ    3                                         ; Port Q Bit 3
PTIQ_PTIQ4:         equ    4                                         ; Port Q Bit 4
PTIQ_PTIQ5:         equ    5                                         ; Port Q Bit 5
PTIQ_PTIQ6:         equ    6                                         ; Port Q Bit 6
PTIQ_PTIQ7:         equ    7                                         ; Port Q Bit 7
; bit position masks
mPTIQ_PTIQ0:        equ    %00000001
mPTIQ_PTIQ1:        equ    %00000010
mPTIQ_PTIQ2:        equ    %00000100
mPTIQ_PTIQ3:        equ    %00001000
mPTIQ_PTIQ4:        equ    %00010000
mPTIQ_PTIQ5:        equ    %00100000
mPTIQ_PTIQ6:        equ    %01000000
mPTIQ_PTIQ7:        equ    %10000000


;*** DDRQ - Port Q Data Direction Register; 0x00000262 ***
DDRQ:               equ    $00000262                                ;*** DDRQ - Port Q Data Direction Register; 0x00000262 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRQ_DDRQ0:         equ    0                                         ; Data Direction Port Q Bit 0
DDRQ_DDRQ1:         equ    1                                         ; Data Direction Port Q Bit 1
DDRQ_DDRQ2:         equ    2                                         ; Data Direction Port Q Bit 2
DDRQ_DDRQ3:         equ    3                                         ; Data Direction Port Q Bit 3
DDRQ_DDRQ4:         equ    4                                         ; Data Direction Port Q Bit 4
DDRQ_DDRQ5:         equ    5                                         ; Data Direction Port Q Bit 5
DDRQ_DDRQ6:         equ    6                                         ; Data Direction Port Q Bit 6
DDRQ_DDRQ7:         equ    7                                         ; Data Direction Port Q Bit 7
; bit position masks
mDDRQ_DDRQ0:        equ    %00000001
mDDRQ_DDRQ1:        equ    %00000010
mDDRQ_DDRQ2:        equ    %00000100
mDDRQ_DDRQ3:        equ    %00001000
mDDRQ_DDRQ4:        equ    %00010000
mDDRQ_DDRQ5:        equ    %00100000
mDDRQ_DDRQ6:        equ    %01000000
mDDRQ_DDRQ7:        equ    %10000000


;*** RDRQ - Port Q Reduced Drive Register; 0x00000263 ***
RDRQ:               equ    $00000263                                ;*** RDRQ - Port Q Reduced Drive Register; 0x00000263 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RDRQ_RDRQ0:         equ    0                                         ; Reduced Drive Port Q Bit 0
RDRQ_RDRQ1:         equ    1                                         ; Reduced Drive Port Q Bit 1
RDRQ_RDRQ2:         equ    2                                         ; Reduced Drive Port Q Bit 2
RDRQ_RDRQ3:         equ    3                                         ; Reduced Drive Port Q Bit 3
RDRQ_RDRQ4:         equ    4                                         ; Reduced Drive Port Q Bit 4
RDRQ_RDRQ5:         equ    5                                         ; Reduced Drive Port Q Bit 5
RDRQ_RDRQ6:         equ    6                                         ; Reduced Drive Port Q Bit 6
RDRQ_RDRQ7:         equ    7                                         ; Reduced Drive Port Q Bit 7
; bit position masks
mRDRQ_RDRQ0:        equ    %00000001
mRDRQ_RDRQ1:        equ    %00000010
mRDRQ_RDRQ2:        equ    %00000100
mRDRQ_RDRQ3:        equ    %00001000
mRDRQ_RDRQ4:        equ    %00010000
mRDRQ_RDRQ5:        equ    %00100000
mRDRQ_RDRQ6:        equ    %01000000
mRDRQ_RDRQ7:        equ    %10000000


;*** PERQ - Port Q Pull Device Enable Register; 0x00000264 ***
PERQ:               equ    $00000264                                ;*** PERQ - Port Q Pull Device Enable Register; 0x00000264 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PERQ_PERQ0:         equ    0                                         ; Pull Device Enable Port Q Bit 0
PERQ_PERQ1:         equ    1                                         ; Pull Device Enable Port Q Bit 1
PERQ_PERQ2:         equ    2                                         ; Pull Device Enable Port Q Bit 2
PERQ_PERQ3:         equ    3                                         ; Pull Device Enable Port Q Bit 3
PERQ_PERQ4:         equ    4                                         ; Pull Device Enable Port Q Bit 4
PERQ_PERQ5:         equ    5                                         ; Pull Device Enable Port Q Bit 5
PERQ_PERQ6:         equ    6                                         ; Pull Device Enable Port Q Bit 6
PERQ_PERQ7:         equ    7                                         ; Pull Device Enable Port Q Bit 7
; bit position masks
mPERQ_PERQ0:        equ    %00000001
mPERQ_PERQ1:        equ    %00000010
mPERQ_PERQ2:        equ    %00000100
mPERQ_PERQ3:        equ    %00001000
mPERQ_PERQ4:        equ    %00010000
mPERQ_PERQ5:        equ    %00100000
mPERQ_PERQ6:        equ    %01000000
mPERQ_PERQ7:        equ    %10000000


;*** PPSQ - Port Q Polarity Select Register; 0x00000265 ***
PPSQ:               equ    $00000265                                ;*** PPSQ - Port Q Polarity Select Register; 0x00000265 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PPSQ_PPSQ0:         equ    0                                         ; Pull Select Port Q Bit 0
PPSQ_PPSQ1:         equ    1                                         ; Pull Select Port Q Bit 1
PPSQ_PPSQ2:         equ    2                                         ; Pull Select Port Q Bit 2
PPSQ_PPSQ3:         equ    3                                         ; Pull Select Port Q Bit 3
PPSQ_PPSQ4:         equ    4                                         ; Pull Select Port Q Bit 4
PPSQ_PPSQ5:         equ    5                                         ; Pull Select Port Q Bit 5
PPSQ_PPSQ6:         equ    6                                         ; Pull Select Port Q Bit 6
PPSQ_PPSQ7:         equ    7                                         ; Pull Select Port Q Bit 7
; bit position masks
mPPSQ_PPSQ0:        equ    %00000001
mPPSQ_PPSQ1:        equ    %00000010
mPPSQ_PPSQ2:        equ    %00000100
mPPSQ_PPSQ3:        equ    %00001000
mPPSQ_PPSQ4:        equ    %00010000
mPPSQ_PPSQ5:        equ    %00100000
mPPSQ_PPSQ6:        equ    %01000000
mPPSQ_PPSQ7:        equ    %10000000


;*** PTR - Port R I/O Register; 0x00000268 ***
PTR:                equ    $00000268                                ;*** PTR - Port R I/O Register; 0x00000268 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTR_PTR0:           equ    0                                         ; Port R Bit 0
PTR_PTR1:           equ    1                                         ; Port R Bit 1
PTR_PTR2:           equ    2                                         ; Port R Bit 2
PTR_PTR3:           equ    3                                         ; Port R Bit 3
PTR_PTR4:           equ    4                                         ; Port R Bit 4
PTR_PTR5:           equ    5                                         ; Port R Bit 5
PTR_PTR6:           equ    6                                         ; Port R Bit 6
PTR_PTR7:           equ    7                                         ; Port R Bit 7
; bit position masks
mPTR_PTR0:          equ    %00000001
mPTR_PTR1:          equ    %00000010
mPTR_PTR2:          equ    %00000100
mPTR_PTR3:          equ    %00001000
mPTR_PTR4:          equ    %00010000
mPTR_PTR5:          equ    %00100000
mPTR_PTR6:          equ    %01000000
mPTR_PTR7:          equ    %10000000


;*** PTIR - Port R Input Register; 0x00000269 ***
PTIR:               equ    $00000269                                ;*** PTIR - Port R Input Register; 0x00000269 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTIR_PTIR0:         equ    0                                         ; Port R Bit 0
PTIR_PTIR1:         equ    1                                         ; Port R Bit 1
PTIR_PTIR2:         equ    2                                         ; Port R Bit 2
PTIR_PTIR3:         equ    3                                         ; Port R Bit 3
PTIR_PTIR4:         equ    4                                         ; Port R Bit 4
PTIR_PTIR5:         equ    5                                         ; Port R Bit 5
PTIR_PTIR6:         equ    6                                         ; Port R Bit 6
PTIR_PTIR7:         equ    7                                         ; Port R Bit 7
; bit position masks
mPTIR_PTIR0:        equ    %00000001
mPTIR_PTIR1:        equ    %00000010
mPTIR_PTIR2:        equ    %00000100
mPTIR_PTIR3:        equ    %00001000
mPTIR_PTIR4:        equ    %00010000
mPTIR_PTIR5:        equ    %00100000
mPTIR_PTIR6:        equ    %01000000
mPTIR_PTIR7:        equ    %10000000


;*** DDRR - Port R Data Direction Register; 0x0000026A ***
DDRR:               equ    $0000026A                                ;*** DDRR - Port R Data Direction Register; 0x0000026A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRR_DDRR0:         equ    0                                         ; Data Direction Port R Bit 0
DDRR_DDRR1:         equ    1                                         ; Data Direction Port R Bit 1
DDRR_DDRR2:         equ    2                                         ; Data Direction Port R Bit 2
DDRR_DDRR3:         equ    3                                         ; Data Direction Port R Bit 3
DDRR_DDRR4:         equ    4                                         ; Data Direction Port R Bit 4
DDRR_DDRR5:         equ    5                                         ; Data Direction Port R Bit 5
DDRR_DDRR6:         equ    6                                         ; Data Direction Port R Bit 6
DDRR_DDRR7:         equ    7                                         ; Data Direction Port R Bit 7
; bit position masks
mDDRR_DDRR0:        equ    %00000001
mDDRR_DDRR1:        equ    %00000010
mDDRR_DDRR2:        equ    %00000100
mDDRR_DDRR3:        equ    %00001000
mDDRR_DDRR4:        equ    %00010000
mDDRR_DDRR5:        equ    %00100000
mDDRR_DDRR6:        equ    %01000000
mDDRR_DDRR7:        equ    %10000000


;*** RDRR - Port R Reduced Drive Register; 0x0000026B ***
RDRR:               equ    $0000026B                                ;*** RDRR - Port R Reduced Drive Register; 0x0000026B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RDRR_RDRR0:         equ    0                                         ; Reduced Drive Port R Bit 0
RDRR_RDRR1:         equ    1                                         ; Reduced Drive Port R Bit 1
RDRR_RDRR2:         equ    2                                         ; Reduced Drive Port R Bit 2
RDRR_RDRR3:         equ    3                                         ; Reduced Drive Port R Bit 3
RDRR_RDRR4:         equ    4                                         ; Reduced Drive Port R Bit 4
RDRR_RDRR5:         equ    5                                         ; Reduced Drive Port R Bit 5
RDRR_RDRR6:         equ    6                                         ; Reduced Drive Port R Bit 6
RDRR_RDRR7:         equ    7                                         ; Reduced Drive Port R Bit 7
; bit position masks
mRDRR_RDRR0:        equ    %00000001
mRDRR_RDRR1:        equ    %00000010
mRDRR_RDRR2:        equ    %00000100
mRDRR_RDRR3:        equ    %00001000
mRDRR_RDRR4:        equ    %00010000
mRDRR_RDRR5:        equ    %00100000
mRDRR_RDRR6:        equ    %01000000
mRDRR_RDRR7:        equ    %10000000


;*** PERR - Port R Pull Device Enable Register; 0x0000026C ***
PERR:               equ    $0000026C                                ;*** PERR - Port R Pull Device Enable Register; 0x0000026C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PERR_PERR0:         equ    0                                         ; Pull Device Enable Port R Bit 0
PERR_PERR1:         equ    1                                         ; Pull Device Enable Port R Bit 1
PERR_PERR2:         equ    2                                         ; Pull Device Enable Port R Bit 2
PERR_PERR3:         equ    3                                         ; Pull Device Enable Port R Bit 3
PERR_PERR4:         equ    4                                         ; Pull Device Enable Port R Bit 4
PERR_PERR5:         equ    5                                         ; Pull Device Enable Port R Bit 5
PERR_PERR6:         equ    6                                         ; Pull Device Enable Port R Bit 6
PERR_PERR7:         equ    7                                         ; Pull Device Enable Port R Bit 7
; bit position masks
mPERR_PERR0:        equ    %00000001
mPERR_PERR1:        equ    %00000010
mPERR_PERR2:        equ    %00000100
mPERR_PERR3:        equ    %00001000
mPERR_PERR4:        equ    %00010000
mPERR_PERR5:        equ    %00100000
mPERR_PERR6:        equ    %01000000
mPERR_PERR7:        equ    %10000000


;*** PPSR - Port R Polarity Select Register; 0x0000026D ***
PPSR:               equ    $0000026D                                ;*** PPSR - Port R Polarity Select Register; 0x0000026D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PPSR_PPSR0:         equ    0                                         ; Pull Select Port R Bit 0
PPSR_PPSR1:         equ    1                                         ; Pull Select Port R Bit 1
PPSR_PPSR2:         equ    2                                         ; Pull Select Port R Bit 2
PPSR_PPSR3:         equ    3                                         ; Pull Select Port R Bit 3
PPSR_PPSR4:         equ    4                                         ; Pull Select Port R Bit 4
PPSR_PPSR5:         equ    5                                         ; Pull Select Port R Bit 5
PPSR_PPSR6:         equ    6                                         ; Pull Select Port R Bit 6
PPSR_PPSR7:         equ    7                                         ; Pull Select Port R Bit 7
; bit position masks
mPPSR_PPSR0:        equ    %00000001
mPPSR_PPSR1:        equ    %00000010
mPPSR_PPSR2:        equ    %00000100
mPPSR_PPSR3:        equ    %00001000
mPPSR_PPSR4:        equ    %00010000
mPPSR_PPSR5:        equ    %00100000
mPPSR_PPSR6:        equ    %01000000
mPPSR_PPSR7:        equ    %10000000


;*** PTS - Port S I/O Register; 0x00000270 ***
PTS:                equ    $00000270                                ;*** PTS - Port S I/O Register; 0x00000270 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTS_PTS0:           equ    0                                         ; Port S Bit 0
PTS_PTS1:           equ    1                                         ; Port S Bit 1
PTS_PTS2:           equ    2                                         ; Port S Bit 2
PTS_PTS3:           equ    3                                         ; Port S Bit 3
PTS_PTS4:           equ    4                                         ; Port S Bit 4
PTS_PTS5:           equ    5                                         ; Port S Bit 5
PTS_PTS6:           equ    6                                         ; Port S Bit 6
PTS_PTS7:           equ    7                                         ; Port S Bit 7
; bit position masks
mPTS_PTS0:          equ    %00000001
mPTS_PTS1:          equ    %00000010
mPTS_PTS2:          equ    %00000100
mPTS_PTS3:          equ    %00001000
mPTS_PTS4:          equ    %00010000
mPTS_PTS5:          equ    %00100000
mPTS_PTS6:          equ    %01000000
mPTS_PTS7:          equ    %10000000


;*** PTIS - Port S Input Register; 0x00000271 ***
PTIS:               equ    $00000271                                ;*** PTIS - Port S Input Register; 0x00000271 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTIS_PTIS0:         equ    0                                         ; Port S Bit 0
PTIS_PTIS1:         equ    1                                         ; Port S Bit 1
PTIS_PTIS2:         equ    2                                         ; Port S Bit 2
PTIS_PTIS3:         equ    3                                         ; Port S Bit 3
PTIS_PTIS4:         equ    4                                         ; Port S Bit 4
PTIS_PTIS5:         equ    5                                         ; Port S Bit 5
PTIS_PTIS6:         equ    6                                         ; Port S Bit 6
PTIS_PTIS7:         equ    7                                         ; Port S Bit 7
; bit position masks
mPTIS_PTIS0:        equ    %00000001
mPTIS_PTIS1:        equ    %00000010
mPTIS_PTIS2:        equ    %00000100
mPTIS_PTIS3:        equ    %00001000
mPTIS_PTIS4:        equ    %00010000
mPTIS_PTIS5:        equ    %00100000
mPTIS_PTIS6:        equ    %01000000
mPTIS_PTIS7:        equ    %10000000


;*** DDRS - Port S Data Direction Register; 0x00000272 ***
DDRS:               equ    $00000272                                ;*** DDRS - Port S Data Direction Register; 0x00000272 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRS_DDRS0:         equ    0                                         ; Data Direction Port S Bit 0
DDRS_DDRS1:         equ    1                                         ; Data Direction Port S Bit 1
DDRS_DDRS2:         equ    2                                         ; Data Direction Port S Bit 2
DDRS_DDRS3:         equ    3                                         ; Data Direction Port S Bit 3
DDRS_DDRS4:         equ    4                                         ; Data Direction Port S Bit 4
DDRS_DDRS5:         equ    5                                         ; Data Direction Port S Bit 5
DDRS_DDRS6:         equ    6                                         ; Data Direction Port S Bit 6
DDRS_DDRS7:         equ    7                                         ; Data Direction Port S Bit 7
; bit position masks
mDDRS_DDRS0:        equ    %00000001
mDDRS_DDRS1:        equ    %00000010
mDDRS_DDRS2:        equ    %00000100
mDDRS_DDRS3:        equ    %00001000
mDDRS_DDRS4:        equ    %00010000
mDDRS_DDRS5:        equ    %00100000
mDDRS_DDRS6:        equ    %01000000
mDDRS_DDRS7:        equ    %10000000


;*** RDRS - Port S Reduced Drive Register; 0x00000273 ***
RDRS:               equ    $00000273                                ;*** RDRS - Port S Reduced Drive Register; 0x00000273 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RDRS_RDRS0:         equ    0                                         ; Reduced Drive Port S Bit 0
RDRS_RDRS1:         equ    1                                         ; Reduced Drive Port S Bit 1
RDRS_RDRS2:         equ    2                                         ; Reduced Drive Port S Bit 2
RDRS_RDRS3:         equ    3                                         ; Reduced Drive Port S Bit 3
RDRS_RDRS4:         equ    4                                         ; Reduced Drive Port S Bit 4
RDRS_RDRS5:         equ    5                                         ; Reduced Drive Port S Bit 5
RDRS_RDRS6:         equ    6                                         ; Reduced Drive Port S Bit 6
RDRS_RDRS7:         equ    7                                         ; Reduced Drive Port S Bit 7
; bit position masks
mRDRS_RDRS0:        equ    %00000001
mRDRS_RDRS1:        equ    %00000010
mRDRS_RDRS2:        equ    %00000100
mRDRS_RDRS3:        equ    %00001000
mRDRS_RDRS4:        equ    %00010000
mRDRS_RDRS5:        equ    %00100000
mRDRS_RDRS6:        equ    %01000000
mRDRS_RDRS7:        equ    %10000000


;*** PERS - Port S Pull Device Enable Register; 0x00000274 ***
PERS:               equ    $00000274                                ;*** PERS - Port S Pull Device Enable Register; 0x00000274 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PERS_PERS0:         equ    0                                         ; Pull Device Enable Port S Bit 0
PERS_PERS1:         equ    1                                         ; Pull Device Enable Port S Bit 1
PERS_PERS2:         equ    2                                         ; Pull Device Enable Port S Bit 2
PERS_PERS3:         equ    3                                         ; Pull Device Enable Port S Bit 3
PERS_PERS4:         equ    4                                         ; Pull Device Enable Port S Bit 4
PERS_PERS5:         equ    5                                         ; Pull Device Enable Port S Bit 5
PERS_PERS6:         equ    6                                         ; Pull Device Enable Port S Bit 6
PERS_PERS7:         equ    7                                         ; Pull Device Enable Port S Bit 7
; bit position masks
mPERS_PERS0:        equ    %00000001
mPERS_PERS1:        equ    %00000010
mPERS_PERS2:        equ    %00000100
mPERS_PERS3:        equ    %00001000
mPERS_PERS4:        equ    %00010000
mPERS_PERS5:        equ    %00100000
mPERS_PERS6:        equ    %01000000
mPERS_PERS7:        equ    %10000000


;*** PPSS - Port S Polarity Select Register; 0x00000275 ***
PPSS:               equ    $00000275                                ;*** PPSS - Port S Polarity Select Register; 0x00000275 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PPSS_PPSS0:         equ    0                                         ; Pull Select Port S Bit 0
PPSS_PPSS1:         equ    1                                         ; Pull Select Port S Bit 1
PPSS_PPSS2:         equ    2                                         ; Pull Select Port S Bit 2
PPSS_PPSS3:         equ    3                                         ; Pull Select Port S Bit 3
PPSS_PPSS4:         equ    4                                         ; Pull Select Port S Bit 4
PPSS_PPSS5:         equ    5                                         ; Pull Select Port S Bit 5
PPSS_PPSS6:         equ    6                                         ; Pull Select Port S Bit 6
PPSS_PPSS7:         equ    7                                         ; Pull Select Port S Bit 7
; bit position masks
mPPSS_PPSS0:        equ    %00000001
mPPSS_PPSS1:        equ    %00000010
mPPSS_PPSS2:        equ    %00000100
mPPSS_PPSS3:        equ    %00001000
mPPSS_PPSS4:        equ    %00010000
mPPSS_PPSS5:        equ    %00100000
mPPSS_PPSS6:        equ    %01000000
mPPSS_PPSS7:        equ    %10000000


;*** PTU - Port U I/O Register; 0x00000278 ***
PTU:                equ    $00000278                                ;*** PTU - Port U I/O Register; 0x00000278 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTU_PTU0:           equ    0                                         ; Port U Bit 0
PTU_PTU1:           equ    1                                         ; Port U Bit 1
PTU_PTU2:           equ    2                                         ; Port U Bit 2
PTU_PTU3:           equ    3                                         ; Port U Bit 3
PTU_PTU4:           equ    4                                         ; Port U Bit 4
PTU_PTU5:           equ    5                                         ; Port U Bit 5
; bit position masks
mPTU_PTU0:          equ    %00000001
mPTU_PTU1:          equ    %00000010
mPTU_PTU2:          equ    %00000100
mPTU_PTU3:          equ    %00001000
mPTU_PTU4:          equ    %00010000
mPTU_PTU5:          equ    %00100000


;*** PTIU - Port U Input Register; 0x00000279 ***
PTIU:               equ    $00000279                                ;*** PTIU - Port U Input Register; 0x00000279 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTIU_PTIU0:         equ    0                                         ; Port U Bit 0
PTIU_PTIU1:         equ    1                                         ; Port U Bit 1
PTIU_PTIU2:         equ    2                                         ; Port U Bit 2
PTIU_PTIU3:         equ    3                                         ; Port U Bit 3
PTIU_PTIU4:         equ    4                                         ; Port U Bit 4
PTIU_PTIU5:         equ    5                                         ; Port U Bit 5
; bit position masks
mPTIU_PTIU0:        equ    %00000001
mPTIU_PTIU1:        equ    %00000010
mPTIU_PTIU2:        equ    %00000100
mPTIU_PTIU3:        equ    %00001000
mPTIU_PTIU4:        equ    %00010000
mPTIU_PTIU5:        equ    %00100000


;*** DDRU - Port U Data Direction Register; 0x0000027A ***
DDRU:               equ    $0000027A                                ;*** DDRU - Port U Data Direction Register; 0x0000027A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRU_DDRU0:         equ    0                                         ; Data Direction Port U Bit 0
DDRU_DDRU1:         equ    1                                         ; Data Direction Port U Bit 1
DDRU_DDRU2:         equ    2                                         ; Data Direction Port U Bit 2
DDRU_DDRU3:         equ    3                                         ; Data Direction Port U Bit 3
DDRU_DDRU4:         equ    4                                         ; Data Direction Port U Bit 4
DDRU_DDRU5:         equ    5                                         ; Data Direction Port U Bit 5
; bit position masks
mDDRU_DDRU0:        equ    %00000001
mDDRU_DDRU1:        equ    %00000010
mDDRU_DDRU2:        equ    %00000100
mDDRU_DDRU3:        equ    %00001000
mDDRU_DDRU4:        equ    %00010000
mDDRU_DDRU5:        equ    %00100000


;*** RDRU - Port U Reduced Drive Register; 0x0000027B ***
RDRU:               equ    $0000027B                                ;*** RDRU - Port U Reduced Drive Register; 0x0000027B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RDRU_RDRU0:         equ    0                                         ; Reduced Drive Port U Bit 0
RDRU_RDRU1:         equ    1                                         ; Reduced Drive Port U Bit 1
RDRU_RDRU2:         equ    2                                         ; Reduced Drive Port U Bit 2
RDRU_RDRU3:         equ    3                                         ; Reduced Drive Port U Bit 3
RDRU_RDRU4:         equ    4                                         ; Reduced Drive Port U Bit 4
RDRU_RDRU5:         equ    5                                         ; Reduced Drive Port U Bit 5
; bit position masks
mRDRU_RDRU0:        equ    %00000001
mRDRU_RDRU1:        equ    %00000010
mRDRU_RDRU2:        equ    %00000100
mRDRU_RDRU3:        equ    %00001000
mRDRU_RDRU4:        equ    %00010000
mRDRU_RDRU5:        equ    %00100000


;*** PERU - Port U Pull Device Enable Register; 0x0000027C ***
PERU:               equ    $0000027C                                ;*** PERU - Port U Pull Device Enable Register; 0x0000027C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PERU_PERU0:         equ    0                                         ; Pull Device Enable Port U Bit 0
PERU_PERU1:         equ    1                                         ; Pull Device Enable Port U Bit 1
PERU_PERU2:         equ    2                                         ; Pull Device Enable Port U Bit 2
PERU_PERU3:         equ    3                                         ; Pull Device Enable Port U Bit 3
PERU_PERU4:         equ    4                                         ; Pull Device Enable Port U Bit 4
PERU_PERU5:         equ    5                                         ; Pull Device Enable Port U Bit 5
; bit position masks
mPERU_PERU0:        equ    %00000001
mPERU_PERU1:        equ    %00000010
mPERU_PERU2:        equ    %00000100
mPERU_PERU3:        equ    %00001000
mPERU_PERU4:        equ    %00010000
mPERU_PERU5:        equ    %00100000


;*** PPSU - Port U Polarity Select Register; 0x0000027D ***
PPSU:               equ    $0000027D                                ;*** PPSU - Port U Polarity Select Register; 0x0000027D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PPSU_PPSU0:         equ    0                                         ; Pull Select Port U Bit 0
PPSU_PPSU1:         equ    1                                         ; Pull Select Port U Bit 1
PPSU_PPSU2:         equ    2                                         ; Pull Select Port U Bit 2
PPSU_PPSU3:         equ    3                                         ; Pull Select Port U Bit 3
PPSU_PPSU4:         equ    4                                         ; Pull Select Port U Bit 4
PPSU_PPSU5:         equ    5                                         ; Pull Select Port U Bit 5
; bit position masks
mPPSU_PPSU0:        equ    %00000001
mPPSU_PPSU1:        equ    %00000010
mPPSU_PPSU2:        equ    %00000100
mPPSU_PPSU3:        equ    %00001000
mPPSU_PPSU4:        equ    %00010000
mPPSU_PPSU5:        equ    %00100000


;*** CFISR - CF Interface Status Register; 0x00000280 ***
CFISR:              equ    $00000280                                ;*** CFISR - CF Interface Status Register; 0x00000280 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CFISR_CHG:          equ    0                                         ; State Change
CFISR_SPKRB:        equ    1                                         ; Binary Audio Output
CFISR_CD1:          equ    2                                         ; Card Detect 1
CFISR_CD2:          equ    3                                         ; Card Detect 2
CFISR_IOIS16:       equ    4                                         ; 16 bit I/O Port Select
CFISR_RDY:          equ    5                                         ; Card Ready
CFISR_VS:           equ    6                                         ; Voltage Sense
CFISR_INPACK:       equ    7                                         ; Input Acknowledge
CFISR_CWAIT:        equ    8                                         ; Bus Cycle Wait
CFISR_VCC:          equ    9                                         ; Card Power Supply
; bit position masks
mCFISR_CHG:         equ    %00000001
mCFISR_SPKRB:       equ    %00000010
mCFISR_CD1:         equ    %00000100
mCFISR_CD2:         equ    %00001000
mCFISR_IOIS16:      equ    %00010000
mCFISR_RDY:         equ    %00100000
mCFISR_VS:          equ    %01000000
mCFISR_INPACK:      equ    %10000000
mCFISR_CWAIT:       equ    %100000000
mCFISR_VCC:         equ    %1000000000


;*** CFCCR - CF Card Configuration Register; 0x00000282 ***
CFCCR:              equ    $00000282                                ;*** CFCCR - CF Card Configuration Register; 0x00000282 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CFCCR_COM:          equ    0                                         ; Card Operation Mode
CFCCR_REGB:         equ    1                                         ; Attribute Memory Select
CFCCR_CE1B:         equ    2                                         ; Card Enable 1
CFCCR_CE2B:         equ    3                                         ; Card Enable 2
; bit position masks
mCFCCR_COM:         equ    %00000001
mCFCCR_REGB:        equ    %00000010
mCFCCR_CE1B:        equ    %00000100
mCFCCR_CE2B:        equ    %00001000


;*** CFSCR1 - CF Status and Control Register 1; 0x00000284 ***
CFSCR1:             equ    $00000284                                ;*** CFSCR1 - CF Status and Control Register 1; 0x00000284 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CFSCR1_CDIE:        equ    0                                         ; Card Detect Interrupt Enable
CFSCR1_CHGIE:       equ    1                                         ; Card State Change Interrupt Enable
CFSCR1_RDYIE:       equ    2                                         ; Card RDY/BSY Interrupt Enable
CFSCR1_VSIE:        equ    3                                         ; Voltage Sense Interrupt Enable
CFSCR1_CIE:         equ    4                                         ; Card Interrupt Enable
CFSCR1_OOIE:        equ    5                                         ; OOIE  Operation Over Interrupt Enable
CFSCR1_CFTEIE:      equ    6                                         ; CF Transmit Interrupt Enable
CFSCR1_CFRFIE:      equ    7                                         ; CF Receive Interrupt Enable
CFSCR1_TERRIE:      equ    8                                         ; Time-out Error Interrupt Enable
CFSCR1_WERRIE:      equ    9                                         ; Wait Assertion Error Interrupt Enable
CFSCR1_IEDGE:       equ    10                                        ; Interrupt Edge Select
CFSCR1_CFSWAI:      equ    11                                        ; CF Module Stop in Wait Mode
CFSCR1_DISINC:      equ    12                                        ; Disable increase of CF Block Base Address Register (CFBBAR)
CFSCR1_CRST:        equ    13                                        ; Card Reset
CFSCR1_CFOE:        equ    14                                        ; CF Output Enable
CFSCR1_CFE:         equ    15                                        ; CFHC system Enable
; bit position masks
mCFSCR1_CDIE:       equ    %00000001
mCFSCR1_CHGIE:      equ    %00000010
mCFSCR1_RDYIE:      equ    %00000100
mCFSCR1_VSIE:       equ    %00001000
mCFSCR1_CIE:        equ    %00010000
mCFSCR1_OOIE:       equ    %00100000
mCFSCR1_CFTEIE:     equ    %01000000
mCFSCR1_CFRFIE:     equ    %10000000
mCFSCR1_TERRIE:     equ    %100000000
mCFSCR1_WERRIE:     equ    %1000000000
mCFSCR1_IEDGE:      equ    %10000000000
mCFSCR1_CFSWAI:     equ    %100000000000
mCFSCR1_DISINC:     equ    %1000000000000
mCFSCR1_CRST:       equ    %10000000000000
mCFSCR1_CFOE:       equ    %100000000000000
mCFSCR1_CFE:        equ    %1000000000000000


;*** CFSCR2 - CF Status and Control Register 2; 0x00000286 ***
CFSCR2:             equ    $00000286                                ;*** CFSCR2 - CF Status and Control Register 2; 0x00000286 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CFSCR2_TPS0:        equ    0                                         ; Time-out Period Selection Bit 0
CFSCR2_TPS1:        equ    1                                         ; Time-out Period Selection Bit 1
CFSCR2_TPS2:        equ    2                                         ; Time-out Period Selection Bit 2
CFSCR2_TPS3:        equ    3                                         ; Time-out Period Selection Bit 3
CFSCR2_TPS4:        equ    4                                         ; Time-out Period Selection Bit 4
CFSCR2_TPS5:        equ    5                                         ; Time-out Period Selection Bit 5
CFSCR2_CA4E:        equ    9                                         ; Card Address Bit 4 Port Enable
CFSCR2_CA5E:        equ    10                                        ; Card Address Bit 5 Port Enable
CFSCR2_CA6E:        equ    11                                        ; Card Address Bit 6 Port Enable
CFSCR2_CA7E:        equ    12                                        ; Card Address Bit 7 Port Enable
CFSCR2_CA8E:        equ    13                                        ; Card Address Bit 8 Port Enable
CFSCR2_CA9E:        equ    14                                        ; Card Address Bit 9 Port Enable
CFSCR2_CA10E:       equ    15                                        ; Card Address Bit 10 Port Enable
; bit position masks
mCFSCR2_TPS0:       equ    %00000001
mCFSCR2_TPS1:       equ    %00000010
mCFSCR2_TPS2:       equ    %00000100
mCFSCR2_TPS3:       equ    %00001000
mCFSCR2_TPS4:       equ    %00010000
mCFSCR2_TPS5:       equ    %00100000
mCFSCR2_CA4E:       equ    %1000000000
mCFSCR2_CA5E:       equ    %10000000000
mCFSCR2_CA6E:       equ    %100000000000
mCFSCR2_CA7E:       equ    %1000000000000
mCFSCR2_CA8E:       equ    %10000000000000
mCFSCR2_CA9E:       equ    %100000000000000
mCFSCR2_CA10E:      equ    %1000000000000000


;*** CFCR - CF Command Register; 0x00000288 ***
CFCR:               equ    $00000288                                ;*** CFCR - CF Command Register; 0x00000288 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CFCR_RWB:           equ    0                                         ; Read Operation or Write Operation
CFCR_INVOKE:        equ    1                                         ; Operation Invoked
CFCR_STOP:          equ    2                                         ; STOP Operation
CFCR_RQ:            equ    3                                         ; Reception Request (reserved bit for internal use)
CFCR_TQ:            equ    4                                         ; Transmission Request (reserved bit for internal use)
CFCR_BSY_CFCR:      equ    6                                         ; CF Module Busy
CFCR_HIS:           equ    7                                         ; Host Interface Select
; bit position masks
mCFCR_RWB:          equ    %00000001
mCFCR_INVOKE:       equ    %00000010
mCFCR_STOP:         equ    %00000100
mCFCR_RQ:           equ    %00001000
mCFCR_TQ:           equ    %00010000
mCFCR_BSY_CFCR:     equ    %01000000
mCFCR_HIS:          equ    %10000000


;*** CFBBAR - CF Block Base Address Register; 0x0000028A ***
CFBBAR:             equ    $0000028A                                ;*** CFBBAR - CF Block Base Address Register; 0x0000028A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CFBBAR_BBA0:        equ    0                                         ; Block Base Address Bit 0
CFBBAR_BBA1:        equ    1                                         ; Block Base Address Bit 1
CFBBAR_BBA2:        equ    2                                         ; Block Base Address Bit 2
CFBBAR_BBA3:        equ    3                                         ; Block Base Address Bit 3
CFBBAR_BBA4:        equ    4                                         ; Block Base Address Bit 4
CFBBAR_BBA5:        equ    5                                         ; Block Base Address Bit 5
CFBBAR_BBA6:        equ    6                                         ; Block Base Address Bit 6
CFBBAR_BBA7:        equ    7                                         ; Block Base Address Bit 7
CFBBAR_BBA8:        equ    8                                         ; Block Base Address Bit 8
CFBBAR_BBA9:        equ    9                                         ; Block Base Address Bit 9
CFBBAR_BBA10:       equ    10                                        ; Block Base Address Bit 10
; bit position masks
mCFBBAR_BBA0:       equ    %00000001
mCFBBAR_BBA1:       equ    %00000010
mCFBBAR_BBA2:       equ    %00000100
mCFBBAR_BBA3:       equ    %00001000
mCFBBAR_BBA4:       equ    %00010000
mCFBBAR_BBA5:       equ    %00100000
mCFBBAR_BBA6:       equ    %01000000
mCFBBAR_BBA7:       equ    %10000000
mCFBBAR_BBA8:       equ    %100000000
mCFBBAR_BBA9:       equ    %1000000000
mCFBBAR_BBA10:      equ    %10000000000


;*** CFBSR - CF Block Size Register; 0x0000028C ***
CFBSR:              equ    $0000028C                                ;*** CFBSR - CF Block Size Register; 0x0000028C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CFBSR_BS0:          equ    0                                         ; Block Size in byte Bit 0
CFBSR_BS1:          equ    1                                         ; Block Size in byte Bit 1
CFBSR_BS2:          equ    2                                         ; Block Size in byte Bit 2
CFBSR_BS3:          equ    3                                         ; Block Size in byte Bit 3
CFBSR_BS4:          equ    4                                         ; Block Size in byte Bit 4
CFBSR_BS5:          equ    5                                         ; Block Size in byte Bit 5
CFBSR_BS6:          equ    6                                         ; Block Size in byte Bit 6
CFBSR_BS7:          equ    7                                         ; Block Size in byte Bit 7
CFBSR_BS8:          equ    8                                         ; Block Size in byte Bit 8
; bit position masks
mCFBSR_BS0:         equ    %00000001
mCFBSR_BS1:         equ    %00000010
mCFBSR_BS2:         equ    %00000100
mCFBSR_BS3:         equ    %00001000
mCFBSR_BS4:         equ    %00010000
mCFBSR_BS5:         equ    %00100000
mCFBSR_BS6:         equ    %01000000
mCFBSR_BS7:         equ    %10000000
mCFBSR_BS8:         equ    %100000000


;*** CFPMR - CF Power Management Register; 0x0000028E ***
CFPMR:              equ    $0000028E                                ;*** CFPMR - CF Power Management Register; 0x0000028E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CFPMR_CVS:          equ    0                                         ; Card Voltage Select
CFPMR_CPE:          equ    1                                         ; Card Power Enable
; bit position masks
mCFPMR_CVS:         equ    %00000001
mCFPMR_CPE:         equ    %00000010


;*** CFDR - CF Data Register; 0x00000290 ***
CFDR:               equ    $00000290                                ;*** CFDR - CF Data Register; 0x00000290 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CFDR_CFDR0:         equ    0                                         ; Receive/Transmit Data Bit 0
CFDR_CFDR1:         equ    1                                         ; Receive/Transmit Data Bit 1
CFDR_CFDR2:         equ    2                                         ; Receive/Transmit Data Bit 2
CFDR_CFDR3:         equ    3                                         ; Receive/Transmit Data Bit 3
CFDR_CFDR4:         equ    4                                         ; Receive/Transmit Data Bit 4
CFDR_CFDR5:         equ    5                                         ; Receive/Transmit Data Bit 5
CFDR_CFDR6:         equ    6                                         ; Receive/Transmit Data Bit 6
CFDR_CFDR7:         equ    7                                         ; Receive/Transmit Data Bit 7
CFDR_CFDR8:         equ    8                                         ; Receive/Transmit Data Bit 8
CFDR_CFDR9:         equ    9                                         ; Receive/Transmit Data Bit 9
CFDR_CFDR10:        equ    10                                        ; Receive/Transmit Data Bit 10
CFDR_CFDR11:        equ    11                                        ; Receive/Transmit Data Bit 11
CFDR_CFDR12:        equ    12                                        ; Receive/Transmit Data Bit 12
CFDR_CFDR13:        equ    13                                        ; Receive/Transmit Data Bit 13
CFDR_CFDR14:        equ    14                                        ; Receive/Transmit Data Bit 14
CFDR_CFDR15:        equ    15                                        ; Receive/Transmit Data Bit 15
; bit position masks
mCFDR_CFDR0:        equ    %00000001
mCFDR_CFDR1:        equ    %00000010
mCFDR_CFDR2:        equ    %00000100
mCFDR_CFDR3:        equ    %00001000
mCFDR_CFDR4:        equ    %00010000
mCFDR_CFDR5:        equ    %00100000
mCFDR_CFDR6:        equ    %01000000
mCFDR_CFDR7:        equ    %10000000
mCFDR_CFDR8:        equ    %100000000
mCFDR_CFDR9:        equ    %1000000000
mCFDR_CFDR10:       equ    %10000000000
mCFDR_CFDR11:       equ    %100000000000
mCFDR_CFDR12:       equ    %1000000000000
mCFDR_CFDR13:       equ    %10000000000000
mCFDR_CFDR14:       equ    %100000000000000
mCFDR_CFDR15:       equ    %1000000000000000


;*** CFIFR - CF Interrupt Flag Register; 0x00000292 ***
CFIFR:              equ    $00000292                                ;*** CFIFR - CF Interrupt Flag Register; 0x00000292 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CFIFR_CDIF:         equ    0                                         ; Card Detect Interrupt Flag
CFIFR_CHGIF:        equ    1                                         ; Card State Change Interrupt Flag
CFIFR_RDYIF:        equ    2                                         ; Card Ready Interrupt Flag
CFIFR_VSIF:         equ    3                                         ; Voltage Sense Interrupt Flag
CFIFR_CIF:          equ    4                                         ; Operation Over Interrupt Flag
CFIFR_OOIF:         equ    5                                         ; Card Hard Interrupt Flag
CFIFR_CFTEIF:       equ    6                                         ; CF Transmit Data Register Empty Interrupt Flag
CFIFR_CFRFIF:       equ    7                                         ; CF Receive Data Register Full Interrupt Flag
CFIFR_TERRIF:       equ    8                                         ; Time-out Error Interrupt Flag
CFIFR_WERRIF:       equ    9                                         ; Wait Assertion Error Interrupt Flag
; bit position masks
mCFIFR_CDIF:        equ    %00000001
mCFIFR_CHGIF:       equ    %00000010
mCFIFR_RDYIF:       equ    %00000100
mCFIFR_VSIF:        equ    %00001000
mCFIFR_CIF:         equ    %00010000
mCFIFR_OOIF:        equ    %00100000
mCFIFR_CFTEIF:      equ    %01000000
mCFIFR_CFRFIF:      equ    %10000000
mCFIFR_TERRIF:      equ    %100000000
mCFIFR_WERRIF:      equ    %1000000000


;*** MSCMD - Memory Stick Command Register; 0x000002A0 ***
MSCMD:              equ    $000002A0                                ;*** MSCMD - Memory Stick Command Register; 0x000002A0 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MSCMD_DATASIZE0:    equ    0                                         ; Data size Bit 0
MSCMD_DATASIZE1:    equ    1                                         ; Data size Bit 1
MSCMD_DATASIZE2:    equ    2                                         ; Data size Bit 2
MSCMD_DATASIZE3:    equ    3                                         ; Data size Bit 3
MSCMD_DATASIZE4:    equ    4                                         ; Data size Bit 4
MSCMD_DATASIZE5:    equ    5                                         ; Data size Bit 5
MSCMD_DATASIZE6:    equ    6                                         ; Data size Bit 6
MSCMD_DATASIZE7:    equ    7                                         ; Data size Bit 7
MSCMD_DATASIZE8:    equ    8                                         ; Data size Bit 8
MSCMD_DATASIZE9:    equ    9                                         ; Data size Bit 9
MSCMD_PID0:         equ    12                                        ; Packet ID Bit 0
MSCMD_PID1:         equ    13                                        ; Packet ID Bit 1
MSCMD_PID2:         equ    14                                        ; Packet ID Bit2
MSCMD_PID3:         equ    15                                        ; Packet ID Bit 3
; bit position masks
mMSCMD_DATASIZE0:   equ    %00000001
mMSCMD_DATASIZE1:   equ    %00000010
mMSCMD_DATASIZE2:   equ    %00000100
mMSCMD_DATASIZE3:   equ    %00001000
mMSCMD_DATASIZE4:   equ    %00010000
mMSCMD_DATASIZE5:   equ    %00100000
mMSCMD_DATASIZE6:   equ    %01000000
mMSCMD_DATASIZE7:   equ    %10000000
mMSCMD_DATASIZE8:   equ    %100000000
mMSCMD_DATASIZE9:   equ    %1000000000
mMSCMD_PID0:        equ    %1000000000000
mMSCMD_PID1:        equ    %10000000000000
mMSCMD_PID2:        equ    %100000000000000
mMSCMD_PID3:        equ    %1000000000000000


;*** MSC0 - Memory Stick Control 0 Register; 0x000002A2 ***
MSC0:               equ    $000002A2                                ;*** MSC0 - Memory Stick Control 0 Register; 0x000002A2 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MSC0_BSYCNT0:       equ    0                                         ; Busy Count, RDY timeout time setting (Serial Clock Count),Bit 0
MSC0_BSYCNT1:       equ    1                                         ; Busy Count, RDY timeout time setting (Serial Clock Count), Bit 1
MSC0_BSYCNT2:       equ    2                                         ; Busy Count, RDY timeout time setting (Serial Clock Count), Bit 2
MSC0_NOCRC:         equ    3                                         ; No CRC
MSC0_MSCE:          equ    4                                         ; Memory Stick Host Controller Enable
MSC0_SIEN:          equ    5                                         ; Serial Interface Enable
MSC0_PWS:           equ    6                                         ; Power Save
MSC0_RST:           equ    7                                         ; Reset
; bit position masks
mMSC0_BSYCNT0:      equ    %00000001
mMSC0_BSYCNT1:      equ    %00000010
mMSC0_BSYCNT2:      equ    %00000100
mMSC0_NOCRC:        equ    %00001000
mMSC0_MSCE:         equ    %00010000
mMSC0_SIEN:         equ    %00100000
mMSC0_PWS:          equ    %01000000
mMSC0_RST:          equ    %10000000


;*** MSS0 - Memory Stick Status 0 Register; 0x000002A3 ***
MSS0:               equ    $000002A3                                ;*** MSS0 - Memory Stick Status 0 Register; 0x000002A3 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MSS0_TBF:           equ    0                                         ; Transmit Buffer Full Flag
MSS0_TBE:           equ    1                                         ; Transmit Buffer Empty Flag
MSS0_RBF:           equ    2                                         ; Receive Buffer Full Flag
MSS0_RBE:           equ    3                                         ; Receive Buffer Empty Flag
; bit position masks
mMSS0_TBF:          equ    %00000001
mMSS0_TBE:          equ    %00000010
mMSS0_RBF:          equ    %00000100
mMSS0_RBE:          equ    %00001000


;*** MSTDATA - Memory Stick Transmit FIFO DATA Register; 0x000002A4 ***
MSTDATA:            equ    $000002A4                                ;*** MSTDATA - Memory Stick Transmit FIFO DATA Register; 0x000002A4 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MSTDATA_MSTDATA0:   equ    0                                         ; TX data buffer Bit 0
MSTDATA_MSTDATA1:   equ    1                                         ; TX data buffer Bit 1
MSTDATA_MSTDATA2:   equ    2                                         ; TX data buffer Bit 2
MSTDATA_MSTDATA3:   equ    3                                         ; TX data buffer Bit 3
MSTDATA_MSTDATA4:   equ    4                                         ; TX data buffer Bit 4
MSTDATA_MSTDATA5:   equ    5                                         ; TX data buffer Bit 5
MSTDATA_MSTDATA6:   equ    6                                         ; TX data buffer Bit 6
MSTDATA_MSTDATA7:   equ    7                                         ; TX data buffer Bit 7
MSTDATA_MSTDATA8:   equ    8                                         ; TX data buffer Bit 8
MSTDATA_MSTDATA9:   equ    9                                         ; TX data buffer Bit 9
MSTDATA_MSTDATA10:  equ    10                                        ; TX data buffer Bit 10
MSTDATA_MSTDATA11:  equ    11                                        ; TX data buffer Bit 11
MSTDATA_MSTDATA12:  equ    12                                        ; TX data buffer Bit 12
MSTDATA_MSTDATA13:  equ    13                                        ; TX data buffer Bit 13
MSTDATA_MSTDATA14:  equ    14                                        ; TX data buffer Bit 14
MSTDATA_MSTDATA15:  equ    15                                        ; TX data buffer Bit 15
; bit position masks
mMSTDATA_MSTDATA0:  equ    %00000001
mMSTDATA_MSTDATA1:  equ    %00000010
mMSTDATA_MSTDATA2:  equ    %00000100
mMSTDATA_MSTDATA3:  equ    %00001000
mMSTDATA_MSTDATA4:  equ    %00010000
mMSTDATA_MSTDATA5:  equ    %00100000
mMSTDATA_MSTDATA6:  equ    %01000000
mMSTDATA_MSTDATA7:  equ    %10000000
mMSTDATA_MSTDATA8:  equ    %100000000
mMSTDATA_MSTDATA9:  equ    %1000000000
mMSTDATA_MSTDATA10: equ    %10000000000
mMSTDATA_MSTDATA11: equ    %100000000000
mMSTDATA_MSTDATA12: equ    %1000000000000
mMSTDATA_MSTDATA13: equ    %10000000000000
mMSTDATA_MSTDATA14: equ    %100000000000000
mMSTDATA_MSTDATA15: equ    %1000000000000000


;*** MSRDATA - Memory Stick Receive FIFO DATA Register; 0x000002A6 ***
MSRDATA:            equ    $000002A6                                ;*** MSRDATA - Memory Stick Receive FIFO DATA Register; 0x000002A6 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MSRDATA_MSRDATA0:   equ    0                                         ; RX data buffer Bit 0
MSRDATA_MSRDATA1:   equ    1                                         ; RX data buffer Bit 1
MSRDATA_MSRDATA2:   equ    2                                         ; RX data buffer Bit 2
MSRDATA_MSRDATA3:   equ    3                                         ; RX data buffer Bit 3
MSRDATA_MSRDATA4:   equ    4                                         ; RX data buffer Bit 4
MSRDATA_MSRDATA5:   equ    5                                         ; RX data buffer Bit 5
MSRDATA_MSRDATA6:   equ    6                                         ; RX data buffer Bit 6
MSRDATA_MSRDATA7:   equ    7                                         ; RX data buffer Bit 7
MSRDATA_MSRDATA8:   equ    8                                         ; RX data buffer Bit 8
MSRDATA_MSRDATA9:   equ    9                                         ; RX data buffer Bit 9
MSRDATA_MSRDATA10:  equ    10                                        ; RX data buffer Bit 10
MSRDATA_MSRDATA11:  equ    11                                        ; RX data buffer Bit 11
MSRDATA_MSRDATA12:  equ    12                                        ; RX data buffer Bit 12
MSRDATA_MSRDATA13:  equ    13                                        ; RX data buffer Bit 13
MSRDATA_MSRDATA14:  equ    14                                        ; RX data buffer Bit 14
MSRDATA_MSRDATA15:  equ    15                                        ; RX data buffer Bit 15
; bit position masks
mMSRDATA_MSRDATA0:  equ    %00000001
mMSRDATA_MSRDATA1:  equ    %00000010
mMSRDATA_MSRDATA2:  equ    %00000100
mMSRDATA_MSRDATA3:  equ    %00001000
mMSRDATA_MSRDATA4:  equ    %00010000
mMSRDATA_MSRDATA5:  equ    %00100000
mMSRDATA_MSRDATA6:  equ    %01000000
mMSRDATA_MSRDATA7:  equ    %10000000
mMSRDATA_MSRDATA8:  equ    %100000000
mMSRDATA_MSRDATA9:  equ    %1000000000
mMSRDATA_MSRDATA10: equ    %10000000000
mMSRDATA_MSRDATA11: equ    %100000000000
mMSRDATA_MSRDATA12: equ    %1000000000000
mMSRDATA_MSRDATA13: equ    %10000000000000
mMSRDATA_MSRDATA14: equ    %100000000000000
mMSRDATA_MSRDATA15: equ    %1000000000000000


;*** MSIC - Memory Stick Interrupt Control Register; 0x000002A8 ***
MSIC:               equ    $000002A8                                ;*** MSIC - Memory Stick Interrupt Control Register; 0x000002A8 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MSIC_FAEEN:         equ    4                                         ; FIFO Access Error Detection Enable
MSIC_DTCMPIE:       equ    5                                         ; Data Transfer Complete Interrupt Enable
MSIC_DTRQIE:        equ    6                                         ; Data Transfer Request Interrupt Enable
MSIC_INTE_MSIC:     equ    7                                         ; Interrupt Enable
; bit position masks
mMSIC_FAEEN:        equ    %00010000
mMSIC_DTCMPIE:      equ    %00100000
mMSIC_DTRQIE:       equ    %01000000
mMSIC_INTE_MSIC:    equ    %10000000


;*** MSIS - Memory Stick Interrupt Status Register; 0x000002A9 ***
MSIS:               equ    $000002A9                                ;*** MSIS - Memory Stick Interrupt Status Register; 0x000002A9 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MSIS_TOE:           equ    0                                         ; Time Out Error flag
MSIS_CRCE:          equ    1                                         ; CRC Error flag
MSIS_FAE:           equ    2                                         ; FIFO Access Error flag
MSIS_DTCMP:         equ    4                                         ; Data Transfer Complete flag
MSIS_DTRQ:          equ    5                                         ; Data Transfer Request flag
MSIS_SIF:           equ    6                                         ; Serial I/F Interrupt flag
MSIS_RDY_MSIS:      equ    7                                         ; Ready flag
; bit position masks
mMSIS_TOE:          equ    %00000001
mMSIS_CRCE:         equ    %00000010
mMSIS_FAE:          equ    %00000100
mMSIS_DTCMP:        equ    %00010000
mMSIS_DTRQ:         equ    %00100000
mMSIS_SIF:          equ    %01000000
mMSIS_RDY_MSIS:     equ    %10000000


;*** MSC1 - Memory Stick Control 1 Register; 0x000002AA ***
MSC1:               equ    $000002AA                                ;*** MSC1 - Memory Stick Control 1 Register; 0x000002AA ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MSC1_TFE:           equ    0                                         ; TxFIFO Empty data transfer Request
MSC1_RFF:           equ    1                                         ; RxFIFO Full data transfer Request
MSC1_DTRQE:         equ    3                                         ; Transfer through QUEUE module Enable
MSC1_DIV0:          equ    4                                         ; Divide Ratio Bit 0
MSC1_DIV1:          equ    5                                         ; Divide Ratio Bit 1
MSC1_ACD:           equ    7                                         ; Auto Command
; bit position masks
mMSC1_TFE:          equ    %00000001
mMSC1_RFF:          equ    %00000010
mMSC1_DTRQE:        equ    %00001000
mMSC1_DIV0:         equ    %00010000
mMSC1_DIV1:         equ    %00100000
mMSC1_ACD:          equ    %10000000


;*** MSS1 - Memory Stick Status 1 Register; 0x000002AB ***
MSS1:               equ    $000002AB                                ;*** MSS1 - Memory Stick Status 1 Register; 0x000002AB ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MSS1_TOV:           equ    6                                         ; TxFIFO Overrun Access
MSS1_RUN:           equ    7                                         ; RxFIFO Underrun Access
; bit position masks
mMSS1_TOV:          equ    %01000000
mMSS1_RUN:          equ    %10000000


;*** MSACMD - Memory Stick Auto Command Register; 0x000002AC ***
MSACMD:             equ    $000002AC                                ;*** MSACMD - Memory Stick Auto Command Register; 0x000002AC ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MSACMD_ADATASIZE0:  equ    0                                         ; Auto Command Data Size Bit 0
MSACMD_ADATASIZE1:  equ    1                                         ; Auto Command Data Size Bit 1
MSACMD_ADATASIZE2:  equ    2                                         ; Auto Command Data Size Bit 2
MSACMD_ADATASIZE3:  equ    3                                         ; Auto Command Data Size Bit 3
MSACMD_ADATASIZE4:  equ    4                                         ; Auto Command Data Size Bit 4
MSACMD_ADATASIZE5:  equ    5                                         ; Auto Command Data Size Bit 5
MSACMD_ADATASIZE6:  equ    6                                         ; Auto Command Data Size Bit 6
MSACMD_ADATASIZE7:  equ    7                                         ; Auto Command Data Size Bit 7
MSACMD_ADATASIZE8:  equ    8                                         ; Auto Command Data Size Bit 8
MSACMD_ADATASIZE9:  equ    9                                         ; Auto Command Data Size Bit 9
MSACMD_APID0:       equ    12                                        ; Auto Command PID Bit 0
MSACMD_APID1:       equ    13                                        ; Auto Command PID Bit 1
MSACMD_APID2:       equ    14                                        ; Auto Command PID Bit 2
MSACMD_APID3:       equ    15                                        ; Auto Command PID Bit 3
; bit position masks
mMSACMD_ADATASIZE0: equ    %00000001
mMSACMD_ADATASIZE1: equ    %00000010
mMSACMD_ADATASIZE2: equ    %00000100
mMSACMD_ADATASIZE3: equ    %00001000
mMSACMD_ADATASIZE4: equ    %00010000
mMSACMD_ADATASIZE5: equ    %00100000
mMSACMD_ADATASIZE6: equ    %01000000
mMSACMD_ADATASIZE7: equ    %10000000
mMSACMD_ADATASIZE8: equ    %100000000
mMSACMD_ADATASIZE9: equ    %1000000000
mMSACMD_APID0:      equ    %1000000000000
mMSACMD_APID1:      equ    %10000000000000
mMSACMD_APID2:      equ    %100000000000000
mMSACMD_APID3:      equ    %1000000000000000


;*** SMC - Smartmedia Control Register; 0x000002B0 ***
SMC:                equ    $000002B0                                ;*** SMC - Smartmedia Control Register; 0x000002B0 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SMC_CNT0:           equ    0                                         ; Specify the no. of bytes of data to be transferred to smartmedia for page program operation, Bit 0
SMC_CNT1:           equ    1                                         ; Specify the no. of bytes of data to be transferred to smartmedia for page program operation, Bit 1
SMC_ECCEN:          equ    2                                         ; Enable/disable ECC generation during read/page program operations
SMC_QEN:            equ    3                                         ; Enable/disable QUE during read/page program operations
SMC_SMRST:          equ    4                                         ; State machine reset
SMC_FRST:           equ    5                                         ; FIFO reset
SMC_SMHCEN:         equ    6                                         ; Smartmedia host controller enable
; bit position masks
mSMC_CNT0:          equ    %00000001
mSMC_CNT1:          equ    %00000010
mSMC_ECCEN:         equ    %00000100
mSMC_QEN:           equ    %00001000
mSMC_SMRST:         equ    %00010000
mSMC_FRST:          equ    %00100000
mSMC_SMHCEN:        equ    %01000000


;*** SMHS - Smartmedia Handshake Register; 0x000002B1 ***
SMHS:               equ    $000002B1                                ;*** SMHS - Smartmedia Handshake Register; 0x000002B1 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SMHS_SCE:           equ    0                                         ; Start command execution
; bit position masks
mSMHS_SCE:          equ    %00000001


;*** SMDATA - Smartmedia FIFO DATA Register (transmitter and receiver); 0x000002B2 ***
SMDATA:             equ    $000002B2                                ;*** SMDATA - Smartmedia FIFO DATA Register (transmitter and receiver); 0x000002B2 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SMDATA_B0:          equ    0                                         ; FIFO Data Buffer Bit 0
SMDATA_B1:          equ    1                                         ; FIFO Data Buffer Bit 1
SMDATA_B2:          equ    2                                         ; FIFO Data Buffer Bit 2
SMDATA_B3:          equ    3                                         ; FIFO Data Buffer Bit 3
SMDATA_B4:          equ    4                                         ; FIFO Data Buffer Bit 4
SMDATA_B5:          equ    5                                         ; FIFO Data Buffer Bit 5
SMDATA_B6:          equ    6                                         ; FIFO Data Buffer Bit 6
SMDATA_B7:          equ    7                                         ; FIFO Data Buffer Bit 7
SMDATA_B8:          equ    8                                         ; FIFO Data Buffer Bit 8
SMDATA_B9:          equ    9                                         ; FIFO Data Buffer Bit 9
SMDATA_B10:         equ    10                                        ; FIFO Data Buffer Bit 10
SMDATA_B11:         equ    11                                        ; FIFO Data Buffer Bit 11
SMDATA_B12:         equ    12                                        ; FIFO Data Buffer Bit 12
SMDATA_B13:         equ    13                                        ; FIFO Data Buffer Bit 13
SMDATA_B14:         equ    14                                        ; FIFO Data Buffer Bit 14
SMDATA_B15:         equ    15                                        ; FIFO Data Buffer Bit 15
; bit position masks
mSMDATA_B0:         equ    %00000001
mSMDATA_B1:         equ    %00000010
mSMDATA_B2:         equ    %00000100
mSMDATA_B3:         equ    %00001000
mSMDATA_B4:         equ    %00010000
mSMDATA_B5:         equ    %00100000
mSMDATA_B6:         equ    %01000000
mSMDATA_B7:         equ    %10000000
mSMDATA_B8:         equ    %100000000
mSMDATA_B9:         equ    %1000000000
mSMDATA_B10:        equ    %10000000000
mSMDATA_B11:        equ    %100000000000
mSMDATA_B12:        equ    %1000000000000
mSMDATA_B13:        equ    %10000000000000
mSMDATA_B14:        equ    %100000000000000
mSMDATA_B15:        equ    %1000000000000000


;*** SMISR - Smartmedia Interrupt Status Register(; 0x000002B4 ***
SMISR:              equ    $000002B4                                ;*** SMISR - Smartmedia Interrupt Status Register(; 0x000002B4 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SMISR_RDY_SMISR:    equ    0                                         ; Smartmedia ready interrupt.
SMISR_CDOUT:        equ    1                                         ; Card Out interrupt
SMISR_CDIN:         equ    2                                         ; Card Insert interrupt
SMISR_RDP:          equ    3                                         ; Redundant data pending interrupt
SMISR_RDR:          equ    4                                         ; Redundant data ready interrupt
SMISR_ECCR:         equ    5                                         ; ECC ready interrupt
SMISR_HCE:          equ    6                                         ; Host controller error interrupt
; bit position masks
mSMISR_RDY_SMISR:   equ    %00000001
mSMISR_CDOUT:       equ    %00000010
mSMISR_CDIN:        equ    %00000100
mSMISR_RDP:         equ    %00001000
mSMISR_RDR:         equ    %00010000
mSMISR_ECCR:        equ    %00100000
mSMISR_HCE:         equ    %01000000


;*** SMIMR - Smartmedia Interrupt Mask Register; 0x000002B5 ***
SMIMR:              equ    $000002B5                                ;*** SMIMR - Smartmedia Interrupt Mask Register; 0x000002B5 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SMIMR_RDYIEN:       equ    0                                         ; The ready interrupt enable
SMIMR_CDOUTIEN:     equ    1                                         ; The card out interrupt enable
SMIMR_CDINIEN:      equ    2                                         ; The card in interrupt enable
SMIMR_RDPIEN:       equ    3                                         ; The redundant data pending interrupt enable
SMIMR_RDRIEN:       equ    4                                         ; The redundant data ready interrupt enable
SMIMR_ECCRIEN:      equ    5                                         ; The ECC ready interrupt enable
SMIMR_HCEIEN:       equ    6                                         ; The host controller error interrupt enable
SMIMR_INTEN:        equ    7                                         ; Interrupt Enable
; bit position masks
mSMIMR_RDYIEN:      equ    %00000001
mSMIMR_CDOUTIEN:    equ    %00000010
mSMIMR_CDINIEN:     equ    %00000100
mSMIMR_RDPIEN:      equ    %00001000
mSMIMR_RDRIEN:      equ    %00010000
mSMIMR_ECCRIEN:     equ    %00100000
mSMIMR_HCEIEN:      equ    %01000000
mSMIMR_INTEN:       equ    %10000000


;*** SMS - Smartmedia Status Register(; 0x000002B6 ***
SMS:                equ    $000002B6                                ;*** SMS - Smartmedia Status Register(; 0x000002B6 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SMS_CP:             equ    0                                         ; Card present
SMS_BUSY:           equ    1                                         ; Shows the smartmedia is busy or ready
SMS_DRQ_SMS:        equ    2                                         ; QUE request
SMS_BAF1P:          equ    3                                         ; Block Address Field-1 parity check
SMS_BAF2P:          equ    4                                         ;  Block Address Field-2 parity check
SMS_SME:            equ    5                                         ; State machine error
SMS_CEC:            equ    6                                         ; Command execution complete
; bit position masks
mSMS_CP:            equ    %00000001
mSMS_BUSY:          equ    %00000010
mSMS_DRQ_SMS:       equ    %00000100
mSMS_BAF1P:         equ    %00001000
mSMS_BAF2P:         equ    %00010000
mSMS_SME:           equ    %00100000
mSMS_CEC:           equ    %01000000


;*** SMFCS - Smartmedia FIFO Status Register; 0x000002B7 ***
SMFCS:              equ    $000002B7                                ;*** SMFCS - Smartmedia FIFO Status Register; 0x000002B7 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SMFCS_TBF_SMFCS:    equ    0                                         ; The transmit FIFO full flag
SMFCS_TBE_SMFCS:    equ    1                                         ; The transmit FIFO empty flag
SMFCS_RBF_SMFCS:    equ    2                                         ; The receive FIFO full flag
SMFCS_RBE_SMFCS:    equ    3                                         ; The receive FIFO empty flag
SMFCS_TFL_SMFCS:    equ    4                                         ; Transmit FIFO flush
SMFCS_RFL_SMFCS:    equ    5                                         ; Receive FIFO flush
; bit position masks
mSMFCS_TBF_SMFCS:   equ    %00000001
mSMFCS_TBE_SMFCS:   equ    %00000010
mSMFCS_RBF_SMFCS:   equ    %00000100
mSMFCS_RBE_SMFCS:   equ    %00001000
mSMFCS_TFL_SMFCS:   equ    %00010000
mSMFCS_RFL_SMFCS:   equ    %00100000


;*** SMCLKR - Smartmedia Clock Rate Register(; 0x000002B8 ***
SMCLKR:             equ    $000002B8                                ;*** SMCLKR - Smartmedia Clock Rate Register(; 0x000002B8 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SMCLKR_PS0:         equ    0                                         ; The pre-scalar settings Bit 0
SMCLKR_PS1:         equ    1                                         ; The pre-scalar settings Bit 1
SMCLKR_PS2:         equ    2                                         ; The pre-scalar settings Bit 2
; bit position masks
mSMCLKR_PS0:        equ    %00000001
mSMCLKR_PS1:        equ    %00000010
mSMCLKR_PS2:        equ    %00000100


;*** SDCON - SDHC Control Register; 0x000002C0 ***
SDCON:              equ    $000002C0                                ;*** SDCON - SDHC Control Register; 0x000002C0 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SDCON_SDEN:         equ    0                                         ; module enable
SDCON_QIEN:         equ    1                                         ; fast data transfer enable
SDCON_PDEN:         equ    2                                         ; Pull-down enable
SDCON_PUEN:         equ    3                                         ; Pull-up enable
SDCON_IRST:         equ    4                                         ; Internal reset enable
SDCON_LBUF:         equ    5                                         ; Last data buffer
; bit position masks
mSDCON_SDEN:        equ    %00000001
mSDCON_QIEN:        equ    %00000010
mSDCON_PDEN:        equ    %00000100
mSDCON_PUEN:        equ    %00001000
mSDCON_IRST:        equ    %00010000
mSDCON_LBUF:        equ    %00100000


;*** SDSTAT - SDHC Status Register; 0x000002C2 ***
SDSTAT:             equ    $000002C2                                ;*** SDSTAT - SDHC Status Register; 0x000002C2 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SDSTAT_RDTO:        equ    0                                         ; Read data timeout
SDSTAT_RSPTO:       equ    1                                         ; Response timeout
SDSTAT_WR_ECRC:     equ    2                                         ; CRC write error
SDSTAT_RD_ECRC:     equ    3                                         ; CRC read error
SDSTAT_RSP_ECRC:    equ    4                                         ; Response CRC error
SDSTAT_WR_ECRC_CODE0: equ    5                                       ; Write CRC Error code Bit 0
SDSTAT_WR_ECRC_CODE1: equ    6                                       ; Write CRC Error code Bit 1
SDSTAT_SDCKON:      equ    7                                         ; SD/MMC card clock running
SDSTAT_DTDN:        equ    8                                         ; Data transfer done
SDSTAT_WRDN:        equ    9                                         ; Write SD/MMC card done
SDSTAT_ECR:         equ    10                                        ; End command response
SDSTAT_CD:          equ    11                                        ; Card Detected
SDSTAT_FEMPTY:      equ    12                                        ; Data FIFO empty
SDSTAT_FFULL:       equ    13                                        ; Data FIFO full
; bit position masks
mSDSTAT_RDTO:       equ    %00000001
mSDSTAT_RSPTO:      equ    %00000010
mSDSTAT_WR_ECRC:    equ    %00000100
mSDSTAT_RD_ECRC:    equ    %00001000
mSDSTAT_RSP_ECRC:   equ    %00010000
mSDSTAT_WR_ECRC_CODE0: equ    %00100000
mSDSTAT_WR_ECRC_CODE1: equ    %01000000
mSDSTAT_SDCKON:     equ    %10000000
mSDSTAT_DTDN:       equ    %100000000
mSDSTAT_WRDN:       equ    %1000000000
mSDSTAT_ECR:        equ    %10000000000
mSDSTAT_CD:         equ    %100000000000
mSDSTAT_FEMPTY:     equ    %1000000000000
mSDSTAT_FFULL:      equ    %10000000000000


;*** SDCLKCON - SD Clock Control Register; 0x000002C4 ***
SDCLKCON:           equ    $000002C4                                ;*** SDCLKCON - SD Clock Control Register; 0x000002C4 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SDCLKCON_CLKRATE0:  equ    0                                         ; SD?MMC card clock rate Bit 0
SDCLKCON_CLKRATE1:  equ    1                                         ; SD?MMC card clock rate Bit 1
SDCLKCON_CLKRATE2:  equ    2                                         ; SD?MMC card clock rate Bit 2
SDCLKCON_SCLKEN:    equ    3                                         ; SD/MMC card clock enable
; bit position masks
mSDCLKCON_CLKRATE0: equ    %00000001
mSDCLKCON_CLKRATE1: equ    %00000010
mSDCLKCON_CLKRATE2: equ    %00000100
mSDCLKCON_SCLKEN:   equ    %00001000


;*** SDCMDATCON - Command and Data Control Register; 0x000002C6 ***
SDCMDATCON:         equ    $000002C6                                ;*** SDCMDATCON - Command and Data Control Register; 0x000002C6 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SDCMDATCON_RSPNO0:  equ    0                                         ; Response types Bit 0
SDCMDATCON_RSPNO1:  equ    1                                         ; Response types Bit 1
SDCMDATCON_DATAEN:  equ    2                                         ; Data transfer enable
SDCMDATCON_WRD:     equ    3                                         ; Data read or write operation
SDCMDATCON_SBMOD:   equ    4                                         ; Data transfer mode selection
SDCMDATCON_MBLK:    equ    5                                         ; Multiple block mode
SDCMDATCON_BUSY_SDCMDATCON: equ    6                                 ; Expected busy status
SDCMDATCON_INIT:    equ    7                                         ; Card initialization
SDCMDATCON_WBUS:    equ    9                                         ; Wide bus selection
SDCMDATCON_NOBEN:   equ    10                                        ; NOB enable
; bit position masks
mSDCMDATCON_RSPNO0: equ    %00000001
mSDCMDATCON_RSPNO1: equ    %00000010
mSDCMDATCON_DATAEN: equ    %00000100
mSDCMDATCON_WRD:    equ    %00001000
mSDCMDATCON_SBMOD:  equ    %00010000
mSDCMDATCON_MBLK:   equ    %00100000
mSDCMDATCON_BUSY_SDCMDATCON: equ    %01000000
mSDCMDATCON_INIT:   equ    %10000000
mSDCMDATCON_WBUS:   equ    %1000000000
mSDCMDATCON_NOBEN:  equ    %10000000000


;*** SDRTOUT - Response Timeout Register; 0x000002C8 ***
SDRTOUT:            equ    $000002C8                                ;*** SDRTOUT - Response Timeout Register; 0x000002C8 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SDRTOUT_RSP_TO0:    equ    0                                         ; Response timeout Bit 0
SDRTOUT_RSP_TO1:    equ    1                                         ; Response timeout Bit 1
SDRTOUT_RSP_TO2:    equ    2                                         ; Response timeout Bit 2
SDRTOUT_RSP_TO3:    equ    3                                         ; Response timeout Bit 3
SDRTOUT_RSP_TO4:    equ    4                                         ; Response timeout Bit 4
SDRTOUT_RSP_TO5:    equ    5                                         ; Response timeout Bit 5
SDRTOUT_RSP_TO6:    equ    6                                         ; Response timeout Bit 6
; bit position masks
mSDRTOUT_RSP_TO0:   equ    %00000001
mSDRTOUT_RSP_TO1:   equ    %00000010
mSDRTOUT_RSP_TO2:   equ    %00000100
mSDRTOUT_RSP_TO3:   equ    %00001000
mSDRTOUT_RSP_TO4:   equ    %00010000
mSDRTOUT_RSP_TO5:   equ    %00100000
mSDRTOUT_RSP_TO6:   equ    %01000000


;*** SDRDTOUT - Read Timeout Register; 0x000002CA ***
SDRDTOUT:           equ    $000002CA                                ;*** SDRDTOUT - Read Timeout Register; 0x000002CA ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SDRDTOUT_RD_TO0:    equ    0                                         ; Read timeout Bit 0
SDRDTOUT_RD_TO1:    equ    1                                         ; Read timeout Bit 1
SDRDTOUT_RD_TO2:    equ    2                                         ; Read timeout Bit 2
SDRDTOUT_RD_TO3:    equ    3                                         ; Read timeout Bit 3
SDRDTOUT_RD_TO4:    equ    4                                         ; Read timeout Bit 4
SDRDTOUT_RD_TO5:    equ    5                                         ; Read timeout Bit 5
SDRDTOUT_RD_TO6:    equ    6                                         ; Read timeout Bit 6
SDRDTOUT_RD_TO7:    equ    7                                         ; Read timeout Bit 7
SDRDTOUT_RD_TO8:    equ    8                                         ; Read timeout Bit 8
SDRDTOUT_RD_TO9:    equ    9                                         ; Read timeout Bit 9
SDRDTOUT_RD_TO10:   equ    10                                        ; Read timeout Bit 10
SDRDTOUT_RD_TO11:   equ    11                                        ; Read timeout Bit 11
SDRDTOUT_RD_TO12:   equ    12                                        ; Read timeout Bit 12
SDRDTOUT_RD_TO13:   equ    13                                        ; Read timeout Bit 13
SDRDTOUT_RD_TO14:   equ    14                                        ; Read timeout Bit 14
SDRDTOUT_RD_TO15:   equ    15                                        ; Read timeout Bit 15
; bit position masks
mSDRDTOUT_RD_TO0:   equ    %00000001
mSDRDTOUT_RD_TO1:   equ    %00000010
mSDRDTOUT_RD_TO2:   equ    %00000100
mSDRDTOUT_RD_TO3:   equ    %00001000
mSDRDTOUT_RD_TO4:   equ    %00010000
mSDRDTOUT_RD_TO5:   equ    %00100000
mSDRDTOUT_RD_TO6:   equ    %01000000
mSDRDTOUT_RD_TO7:   equ    %10000000
mSDRDTOUT_RD_TO8:   equ    %100000000
mSDRDTOUT_RD_TO9:   equ    %1000000000
mSDRDTOUT_RD_TO10:  equ    %10000000000
mSDRDTOUT_RD_TO11:  equ    %100000000000
mSDRDTOUT_RD_TO12:  equ    %1000000000000
mSDRDTOUT_RD_TO13:  equ    %10000000000000
mSDRDTOUT_RD_TO14:  equ    %100000000000000
mSDRDTOUT_RD_TO15:  equ    %1000000000000000


;*** SDBLKLN - Block Length Register; 0x000002CC ***
SDBLKLN:            equ    $000002CC                                ;*** SDBLKLN - Block Length Register; 0x000002CC ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SDBLKLN_BLEN0:      equ    0                                         ; Block length Bit 0
SDBLKLN_BLEN1:      equ    1                                         ; Block length Bit 1
SDBLKLN_BLEN2:      equ    2                                         ; Block length Bit 2
SDBLKLN_BLEN3:      equ    3                                         ; Block length Bit 3
SDBLKLN_BLEN4:      equ    4                                         ; Block length Bit 4
SDBLKLN_BLEN5:      equ    5                                         ; Block length Bit 5
SDBLKLN_BLEN6:      equ    6                                         ; Block length Bit 6
SDBLKLN_BLEN7:      equ    7                                         ; Block length Bit 7
SDBLKLN_BLEN8:      equ    8                                         ; Block length Bit 8
SDBLKLN_BLEN9:      equ    9                                         ; Block length Bit 9
; bit position masks
mSDBLKLN_BLEN0:     equ    %00000001
mSDBLKLN_BLEN1:     equ    %00000010
mSDBLKLN_BLEN2:     equ    %00000100
mSDBLKLN_BLEN3:     equ    %00001000
mSDBLKLN_BLEN4:     equ    %00010000
mSDBLKLN_BLEN5:     equ    %00100000
mSDBLKLN_BLEN6:     equ    %01000000
mSDBLKLN_BLEN7:     equ    %10000000
mSDBLKLN_BLEN8:     equ    %100000000
mSDBLKLN_BLEN9:     equ    %1000000000


;*** SDNOBLK - Number of Blocks Register; 0x000002CE ***
SDNOBLK:            equ    $000002CE                                ;*** SDNOBLK - Number of Blocks Register; 0x000002CE ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SDNOBLK_NOB0:       equ    0                                         ; Number of blocks Bit 0
SDNOBLK_NOB1:       equ    1                                         ; Number of blocks Bit 1
SDNOBLK_NOB2:       equ    2                                         ; Number of blocks Bit 2
SDNOBLK_NOB3:       equ    3                                         ; Number of blocks Bit 3
SDNOBLK_NOB4:       equ    4                                         ; Number of blocks Bit 4
SDNOBLK_NOB5:       equ    5                                         ; Number of blocks Bit 5
SDNOBLK_NOB6:       equ    6                                         ; Number of blocks Bit 6
SDNOBLK_NOB7:       equ    7                                         ; Number of blocks Bit 7
SDNOBLK_NOB8:       equ    8                                         ; Number of blocks Bit 8
SDNOBLK_NOB9:       equ    9                                         ; Number of blocks Bit 9
SDNOBLK_NOB10:      equ    10                                        ; Number of blocks Bit 10
SDNOBLK_NOB11:      equ    11                                        ; Number of blocks Bit 11
SDNOBLK_NOB12:      equ    12                                        ; Number of blocks Bit 12
SDNOBLK_NOB13:      equ    13                                        ; Number of blocks Bit 13
SDNOBLK_NOB14:      equ    14                                        ; Number of blocks Bit 14
SDNOBLK_NOB15:      equ    15                                        ; Number of blocks Bit 15
; bit position masks
mSDNOBLK_NOB0:      equ    %00000001
mSDNOBLK_NOB1:      equ    %00000010
mSDNOBLK_NOB2:      equ    %00000100
mSDNOBLK_NOB3:      equ    %00001000
mSDNOBLK_NOB4:      equ    %00010000
mSDNOBLK_NOB5:      equ    %00100000
mSDNOBLK_NOB6:      equ    %01000000
mSDNOBLK_NOB7:      equ    %10000000
mSDNOBLK_NOB8:      equ    %100000000
mSDNOBLK_NOB9:      equ    %1000000000
mSDNOBLK_NOB10:     equ    %10000000000
mSDNOBLK_NOB11:     equ    %100000000000
mSDNOBLK_NOB12:     equ    %1000000000000
mSDNOBLK_NOB13:     equ    %10000000000000
mSDNOBLK_NOB14:     equ    %100000000000000
mSDNOBLK_NOB15:     equ    %1000000000000000


;*** SDINTREN - Interrupt Enable Register; 0x000002D0 ***
SDINTREN:           equ    $000002D0                                ;*** SDINTREN - Interrupt Enable Register; 0x000002D0 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SDINTREN_TOIE:      equ    0                                         ; Timeout interrupt enable
SDINTREN_CRCIE:     equ    1                                         ; CRC error interrupt enable
SDINTREN_DTDNIE:    equ    2                                         ; Data transfer done interrupt enable
SDINTREN_WRDNIE:    equ    3                                         ; Write operation done interrupt enable
SDINTREN_ECRIE:     equ    4                                         ; End command response interrupt enable
SDINTREN_CDIE_SDINTREN: equ    5                                     ; Auto card detect interrupt enable
; bit position masks
mSDINTREN_TOIE:     equ    %00000001
mSDINTREN_CRCIE:    equ    %00000010
mSDINTREN_DTDNIE:   equ    %00000100
mSDINTREN_WRDNIE:   equ    %00001000
mSDINTREN_ECRIE:    equ    %00010000
mSDINTREN_CDIE_SDINTREN: equ    %00100000


;*** SDCMDNO - Command Register; 0x000002D2 ***
SDCMDNO:            equ    $000002D2                                ;*** SDCMDNO - Command Register; 0x000002D2 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SDCMDNO_CMDNO0:     equ    0                                         ; Command number Bit 0
SDCMDNO_CMDNO1:     equ    1                                         ; Command number Bit 1
SDCMDNO_CMDNO2:     equ    2                                         ; Command number Bit 2
SDCMDNO_CMDNO3:     equ    3                                         ; Command number Bit 3
SDCMDNO_CMDNO4:     equ    4                                         ; Command number Bit 4
SDCMDNO_CMDNO5:     equ    5                                         ; Command number Bit 5
; bit position masks
mSDCMDNO_CMDNO0:    equ    %00000001
mSDCMDNO_CMDNO1:    equ    %00000010
mSDCMDNO_CMDNO2:    equ    %00000100
mSDCMDNO_CMDNO3:    equ    %00001000
mSDCMDNO_CMDNO4:    equ    %00010000
mSDCMDNO_CMDNO5:    equ    %00100000


;*** SDARGH - Argument High Register; 0x000002D4 ***
SDARGH:             equ    $000002D4                                ;*** SDARGH - Argument High Register; 0x000002D4 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SDARGH_HARG0:       equ    0                                         ; High-word argument Bit 0
SDARGH_HARG1:       equ    1                                         ; High-word argument Bit 1
SDARGH_HARG2:       equ    2                                         ; High-word argument Bit 2
SDARGH_HARG3:       equ    3                                         ; High-word argument Bit 3
SDARGH_HARG4:       equ    4                                         ; High-word argument Bit 4
SDARGH_HARG5:       equ    5                                         ; High-word argument Bit 5
SDARGH_HARG6:       equ    6                                         ; High-word argument Bit 6
SDARGH_HARG7:       equ    7                                         ; High-word argument Bit 7
SDARGH_HARG8:       equ    8                                         ; High-word argument Bit 8
SDARGH_HARG9:       equ    9                                         ; High-word argument Bit 9
SDARGH_HARG10:      equ    10                                        ; High-word argument Bit 10
SDARGH_HARG11:      equ    11                                        ; High-word argument Bit 11
SDARGH_HARG12:      equ    12                                        ; High-word argument Bit 12
SDARGH_HARG13:      equ    13                                        ; High-word argument Bit 13
SDARGH_HARG14:      equ    14                                        ; High-word argument Bit 14
SDARGH_HARG15:      equ    15                                        ; High-word argument Bit 15
; bit position masks
mSDARGH_HARG0:      equ    %00000001
mSDARGH_HARG1:      equ    %00000010
mSDARGH_HARG2:      equ    %00000100
mSDARGH_HARG3:      equ    %00001000
mSDARGH_HARG4:      equ    %00010000
mSDARGH_HARG5:      equ    %00100000
mSDARGH_HARG6:      equ    %01000000
mSDARGH_HARG7:      equ    %10000000
mSDARGH_HARG8:      equ    %100000000
mSDARGH_HARG9:      equ    %1000000000
mSDARGH_HARG10:     equ    %10000000000
mSDARGH_HARG11:     equ    %100000000000
mSDARGH_HARG12:     equ    %1000000000000
mSDARGH_HARG13:     equ    %10000000000000
mSDARGH_HARG14:     equ    %100000000000000
mSDARGH_HARG15:     equ    %1000000000000000


;*** SDARGL - Argument Low Register; 0x000002D6 ***
SDARGL:             equ    $000002D6                                ;*** SDARGL - Argument Low Register; 0x000002D6 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SDARGL_LARG0:       equ    0                                         ; Low-word argument Bit 0
SDARGL_LARG1:       equ    1                                         ; Low-word argument Bit 1
SDARGL_LARG2:       equ    2                                         ; Low-word argument Bit 2
SDARGL_LARG3:       equ    3                                         ; Low-word argument Bit 3
SDARGL_LARG4:       equ    4                                         ; Low-word argument Bit 4
SDARGL_LARG5:       equ    5                                         ; Low-word argument Bit 5
SDARGL_LARG6:       equ    6                                         ; Low-word argument Bit 6
SDARGL_LARG7:       equ    7                                         ; Low-word argument Bit 7
SDARGL_LARG8:       equ    8                                         ; Low-word argument Bit 8
SDARGL_LARG9:       equ    9                                         ; Low-word argument Bit 9
SDARGL_LARG10:      equ    10                                        ; Low-word argument Bit 10
SDARGL_LARG11:      equ    11                                        ; Low-word argument Bit 11
SDARGL_LARG12:      equ    12                                        ; Low-word argument Bit 12
SDARGL_LARG13:      equ    13                                        ; Low-word argument Bit 13
SDARGL_LARG14:      equ    14                                        ; Low-word argument Bit 14
SDARGL_LARG15:      equ    15                                        ; Low-word argument Bit 15
; bit position masks
mSDARGL_LARG0:      equ    %00000001
mSDARGL_LARG1:      equ    %00000010
mSDARGL_LARG2:      equ    %00000100
mSDARGL_LARG3:      equ    %00001000
mSDARGL_LARG4:      equ    %00010000
mSDARGL_LARG5:      equ    %00100000
mSDARGL_LARG6:      equ    %01000000
mSDARGL_LARG7:      equ    %10000000
mSDARGL_LARG8:      equ    %100000000
mSDARGL_LARG9:      equ    %1000000000
mSDARGL_LARG10:     equ    %10000000000
mSDARGL_LARG11:     equ    %100000000000
mSDARGL_LARG12:     equ    %1000000000000
mSDARGL_LARG13:     equ    %10000000000000
mSDARGL_LARG14:     equ    %100000000000000
mSDARGL_LARG15:     equ    %1000000000000000


;*** SDRSP - Response Register; 0x000002D8 ***
SDRSP:              equ    $000002D8                                ;*** SDRSP - Response Register; 0x000002D8 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SDRSP_CRSP0:        equ    0                                         ; SD/MMC card response Bit 0
SDRSP_CRSP1:        equ    1                                         ; SD/MMC card response Bit 1
SDRSP_CRSP2:        equ    2                                         ; SD/MMC card response Bit 2
SDRSP_CRSP3:        equ    3                                         ; SD/MMC card response Bit 3
SDRSP_CRSP4:        equ    4                                         ; SD/MMC card response Bit 4
SDRSP_CRSP5:        equ    5                                         ; SD/MMC card response Bit 5
SDRSP_CRSP6:        equ    6                                         ; SD/MMC card response Bit 6
SDRSP_CRSP7:        equ    7                                         ; SD/MMC card response Bit 7
SDRSP_CRSP8:        equ    8                                         ; SD/MMC card response Bit 8
SDRSP_CRSP9:        equ    9                                         ; SD/MMC card response Bit 9
SDRSP_CRSP10:       equ    10                                        ; SD/MMC card response Bit 10
SDRSP_CRSP11:       equ    11                                        ; SD/MMC card response Bit 11
SDRSP_CRSP12:       equ    12                                        ; SD/MMC card response Bit 12
SDRSP_CRSP13:       equ    13                                        ; SD/MMC card response Bit 13
SDRSP_CRSP14:       equ    14                                        ; SD/MMC card response Bit 14
SDRSP_CRSP15:       equ    15                                        ; SD/MMC card response Bit 15
; bit position masks
mSDRSP_CRSP0:       equ    %00000001
mSDRSP_CRSP1:       equ    %00000010
mSDRSP_CRSP2:       equ    %00000100
mSDRSP_CRSP3:       equ    %00001000
mSDRSP_CRSP4:       equ    %00010000
mSDRSP_CRSP5:       equ    %00100000
mSDRSP_CRSP6:       equ    %01000000
mSDRSP_CRSP7:       equ    %10000000
mSDRSP_CRSP8:       equ    %100000000
mSDRSP_CRSP9:       equ    %1000000000
mSDRSP_CRSP10:      equ    %10000000000
mSDRSP_CRSP11:      equ    %100000000000
mSDRSP_CRSP12:      equ    %1000000000000
mSDRSP_CRSP13:      equ    %10000000000000
mSDRSP_CRSP14:      equ    %100000000000000
mSDRSP_CRSP15:      equ    %1000000000000000


;*** SDATA - SD/MMC Data Register; 0x000002DA ***
SDATA:              equ    $000002DA                                ;*** SDATA - SD/MMC Data Register; 0x000002DA ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SDATA_SDAT0:        equ    0                                         ; SD/MMC fifo data Bit 0
SDATA_SDAT1:        equ    1                                         ; SD/MMC fifo data Bit 1
SDATA_SDAT2:        equ    2                                         ; SD/MMC fifo data Bit 2
SDATA_SDAT3:        equ    3                                         ; SD/MMC fifo data Bit 3
SDATA_SDAT4:        equ    4                                         ; SD/MMC fifo data Bit 4
SDATA_SDAT5:        equ    5                                         ; SD/MMC fifo data Bit 5
SDATA_SDAT6:        equ    6                                         ; SD/MMC fifo data Bit 6
SDATA_SDAT7:        equ    7                                         ; SD/MMC fifo data Bit 7
SDATA_SDAT8:        equ    8                                         ; SD/MMC fifo data Bit 8
SDATA_SDAT9:        equ    9                                         ; SD/MMC fifo data Bit 9
SDATA_SDAT10:       equ    10                                        ; SD/MMC fifo data Bit 10
SDATA_SDAT11:       equ    11                                        ; SD/MMC fifo data Bit 11
SDATA_SDAT12:       equ    12                                        ; SD/MMC fifo data Bit 12
SDATA_SDAT13:       equ    13                                        ; SD/MMC fifo data Bit 13
SDATA_SDAT14:       equ    14                                        ; SD/MMC fifo data Bit 14
SDATA_SDAT15:       equ    15                                        ; SD/MMC fifo data Bit 15
; bit position masks
mSDATA_SDAT0:       equ    %00000001
mSDATA_SDAT1:       equ    %00000010
mSDATA_SDAT2:       equ    %00000100
mSDATA_SDAT3:       equ    %00001000
mSDATA_SDAT4:       equ    %00010000
mSDATA_SDAT5:       equ    %00100000
mSDATA_SDAT6:       equ    %01000000
mSDATA_SDAT7:       equ    %10000000
mSDATA_SDAT8:       equ    %100000000
mSDATA_SDAT9:       equ    %1000000000
mSDATA_SDAT10:      equ    %10000000000
mSDATA_SDAT11:      equ    %100000000000
mSDATA_SDAT12:      equ    %1000000000000
mSDATA_SDAT13:      equ    %10000000000000
mSDATA_SDAT14:      equ    %100000000000000
mSDATA_SDAT15:      equ    %1000000000000000


;*** UMCR - USB20 Module Control Register; 0x00000300 ***
UMCR:               equ    $00000300                                ;*** UMCR - USB20 Module Control Register; 0x00000300 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
UMCR_SCSUP:         equ    0                                         ; Synch Frame command Support
UMCR_SPWR:          equ    1                                         ; Self Powered
UMCR_PWUC:          equ    2                                         ; Remote Wakeup Capable
UMCR_EXSPD:         equ    3                                         ; Expected Speed
UMCR_SDSUP:         equ    4                                         ; Set Descriptor Command Support
UMCR_DISCON:        equ    5                                         ; Device Disconnect
UMCR_EPRST:         equ    9                                         ; Endpoint Reset
UMCR_PHYRST:        equ    10                                        ; Physical Layer Reset
UMCR_SPHY:          equ    11                                        ; Suspend PHY
UMCR_RESUME:        equ    12                                        ; Remote Wakeup Indication
UMCR_MRST:          equ    13                                        ; Module Reset
UMCR_MCE:           equ    14                                        ; Module Clock Enable
UMCR_MEM:           equ    15                                        ; Module Enable
; bit position masks
mUMCR_SCSUP:        equ    %00000001
mUMCR_SPWR:         equ    %00000010
mUMCR_PWUC:         equ    %00000100
mUMCR_EXSPD:        equ    %00001000
mUMCR_SDSUP:        equ    %00010000
mUMCR_DISCON:       equ    %00100000
mUMCR_EPRST:        equ    %1000000000
mUMCR_PHYRST:       equ    %10000000000
mUMCR_SPHY:         equ    %100000000000
mUMCR_RESUME:       equ    %1000000000000
mUMCR_MRST:         equ    %10000000000000
mUMCR_MCE:          equ    %100000000000000
mUMCR_MEM:          equ    %1000000000000000


;*** UMSR1 - USB20 Module Status Register 1; 0x00000302 ***
UMSR1:              equ    $00000302                                ;*** UMSR1 - USB20 Module Status Register 1; 0x00000302 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
UMSR1_SETUP:        equ    0                                         ; USB Setup Command Detected
UMSR1_SETOVR:       equ    1                                         ; USB Setup Command Overrun
UMSR1_SOF:          equ    2                                         ; Start of Frame
UMSR1_URD:          equ    3                                         ; USB Reset Detected
UMSR1_USD:          equ    4                                         ; USB Suspend Detected
UMSR1_SPD:          equ    6                                         ; Set Endpoint Configuration Request
UMSR1_ENUMD:        equ    10                                        ; Enumeration Done
UMSR1_URSC:         equ    11                                        ; USB20 Reset Status Change
UMSR1_USSC:         equ    12                                        ; USB20 Suspend Status Change
UMSR1_ACTEP0:       equ    13                                        ; bit 0 of Active Endpoint
UMSR1_ACTEP1:       equ    14                                        ; bit 1 of Active Endpoint
UMSR1_ACTEP2:       equ    15                                        ; bit 2 of Active Endpoint
; bit position masks
mUMSR1_SETUP:       equ    %00000001
mUMSR1_SETOVR:      equ    %00000010
mUMSR1_SOF:         equ    %00000100
mUMSR1_URD:         equ    %00001000
mUMSR1_USD:         equ    %00010000
mUMSR1_SPD:         equ    %01000000
mUMSR1_ENUMD:       equ    %10000000000
mUMSR1_URSC:        equ    %100000000000
mUMSR1_USSC:        equ    %1000000000000
mUMSR1_ACTEP0:      equ    %10000000000000
mUMSR1_ACTEP1:      equ    %100000000000000
mUMSR1_ACTEP2:      equ    %1000000000000000


;*** UIMR - USB20 Interrupt Mask Register; 0x00000304 ***
UIMR:               equ    $00000304                                ;*** UIMR - USB20 Interrupt Mask Register; 0x00000304 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
UIMR_SETUPIE:       equ    0                                         ; Setup Command Interrupt Enable
UIMR_SETOVFIE:      equ    1                                         ; Setup Command Overrun Interrupt Enable
UIMR_SOFIE:         equ    2                                         ; Start of Frame Inter rupt Enable
UIMR_URSCIE:        equ    11                                        ; USB20 Reset Status Change Interrupt Enable
UIMR_USSCIE:        equ    12                                        ; USB20 Suspend Status Change Interrupt Enable
UIMR_SETECRIE:      equ    13                                        ; Set Endpoint Configuration Request Interrupt Enable
UIMR_RESUMEIE:      equ    14                                        ; Resume Interrupt Enable
; bit position masks
mUIMR_SETUPIE:      equ    %00000001
mUIMR_SETOVFIE:     equ    %00000010
mUIMR_SOFIE:        equ    %00000100
mUIMR_URSCIE:       equ    %100000000000
mUIMR_USSCIE:       equ    %1000000000000
mUIMR_SETECRIE:     equ    %10000000000000
mUIMR_RESUMEIE:     equ    %100000000000000


;*** UTR - USB20 Test Register; 0x00000308 ***
UTR:                equ    $00000308                                ;*** UTR - USB20 Test Register; 0x00000308 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
UTR_TMS0:           equ    0                                         ; Test mode enable Bit 0
UTR_TMS1:           equ    1                                         ; Test mode enable Bit 1
UTR_USD_UTR:        equ    3                                         ; UDC Scale Down
UTR_TME:            equ    4                                         ; Test mode select
; bit position masks
mUTR_TMS0:          equ    %00000001
mUTR_TMS1:          equ    %00000010
mUTR_USD_UTR:       equ    %00001000
mUTR_TME:           equ    %00010000


;*** UTSR - USB20 Timestamp Register; 0x0000030A ***
UTSR:               equ    $0000030A                                ;*** UTSR - USB20 Timestamp Register; 0x0000030A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
UTSR_TIMEST0:       equ    0                                         ; Start of Frame SOF frame number Bit 0
UTSR_TIMEST1:       equ    1                                         ; Start of Frame SOF frame number Bit 1
UTSR_TIMEST2:       equ    2                                         ; Start of Frame SOF frame number Bit 2
UTSR_TIMEST3:       equ    3                                         ; Start of Frame SOF frame number Bit 3
UTSR_TIMEST4:       equ    4                                         ; Start of Frame SOF frame number Bit 4
UTSR_TIMEST5:       equ    5                                         ; Start of Frame SOF frame number Bit 5
UTSR_TIMEST6:       equ    6                                         ; Start of Frame SOF frame number Bit 6
UTSR_TIMEST7:       equ    7                                         ; Start of Frame SOF frame number Bit 7
UTSR_TIMEST8:       equ    8                                         ; Start of Frame SOF frame number Bit 8
UTSR_TIMEST9:       equ    9                                         ; Start of Frame SOF frame number Bit 9
UTSR_TIMEST10:      equ    10                                        ; Start of Frame SOF frame number Bit 10
; bit position masks
mUTSR_TIMEST0:      equ    %00000001
mUTSR_TIMEST1:      equ    %00000010
mUTSR_TIMEST2:      equ    %00000100
mUTSR_TIMEST3:      equ    %00001000
mUTSR_TIMEST4:      equ    %00010000
mUTSR_TIMEST5:      equ    %00100000
mUTSR_TIMEST6:      equ    %01000000
mUTSR_TIMEST7:      equ    %10000000
mUTSR_TIMEST8:      equ    %100000000
mUTSR_TIMEST9:      equ    %1000000000
mUTSR_TIMEST10:     equ    %10000000000


;*** UCCSR - USB20 Configuration Control Status Register; 0x0000030C ***
UCCSR:              equ    $0000030C                                ;*** UCCSR - USB20 Configuration Control Status Register; 0x0000030C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
UCCSR_ALTINTF0:     equ    0                                         ; Current Alternate Setting Bit 0
UCCSR_ALTINTF1:     equ    1                                         ; Current Alternate Setting Bit 1
UCCSR_ALTINTF2:     equ    2                                         ; Current Alternate Setting Bit 2
UCCSR_ALTINTF3:     equ    3                                         ; Current Alternate Setting Bit 3
UCCSR_INTF0:        equ    4                                         ; Current Interface Bit 0
UCCSR_INTF1:        equ    5                                         ; Current Interface Bit 1
UCCSR_INTF2:        equ    6                                         ; Current Interface Bit 2
UCCSR_INTF3:        equ    7                                         ; Current Interface Bit 3
UCCSR_CFG0:         equ    8                                         ; Current Configuration Bit 0
UCCSR_CFG1:         equ    9                                         ; Current Configuration Bit 1
UCCSR_CFG2:         equ    10                                        ; Current Configuration Bit 2
UCCSR_CFG3:         equ    11                                        ; Current Configuration Bit 3
UCCSR_DONEECRU:     equ    12                                        ; Done Endpoint Configuration Update
UCCSR_SETECR:       equ    13                                        ; Set Endpoint Configuration Request
UCCSR_INTFVALID:    equ    14                                        ; Interface/Alternate Setting Valid
UCCSR_CFGVALID:     equ    15                                        ; configuration valid
; bit position masks
mUCCSR_ALTINTF0:    equ    %00000001
mUCCSR_ALTINTF1:    equ    %00000010
mUCCSR_ALTINTF2:    equ    %00000100
mUCCSR_ALTINTF3:    equ    %00001000
mUCCSR_INTF0:       equ    %00010000
mUCCSR_INTF1:       equ    %00100000
mUCCSR_INTF2:       equ    %01000000
mUCCSR_INTF3:       equ    %10000000
mUCCSR_CFG0:        equ    %100000000
mUCCSR_CFG1:        equ    %1000000000
mUCCSR_CFG2:        equ    %10000000000
mUCCSR_CFG3:        equ    %100000000000
mUCCSR_DONEECRU:    equ    %1000000000000
mUCCSR_SETECR:      equ    %10000000000000
mUCCSR_INTFVALID:   equ    %100000000000000
mUCCSR_CFGVALID:    equ    %1000000000000000


;*** UEPCSELR - USB20 Endpoint and Configuration Select Register; 0x0000030E ***
UEPCSELR:           equ    $0000030E                                ;*** UEPCSELR - USB20 Endpoint and Configuration Select Register; 0x0000030E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
UEPCSELR_EPBSEL00:  equ    0                                         ; Endpoint Buffer Select 0 Bit 0
UEPCSELR_EPBSEL01:  equ    1                                         ; Endpoint Buffer Select 0 Bit 1
UEPCSELR_EPBSEL02:  equ    2                                         ; Endpoint Buffer Select 0 Bit 2
UEPCSELR_EPBSEL10:  equ    4                                         ; Endpoint Buffer Select 1 Bit 0
UEPCSELR_EPBSEL11:  equ    5                                         ; Endpoint Buffer Select 1 Bit 1
UEPCSELR_EPBSEL12:  equ    6                                         ; Endpoint Buffer Select 1 Bit 2
UEPCSELR_UCRSEL0:   equ    8                                         ; USB20 Configuration Register Select Bit 0
UEPCSELR_UCRSEL1:   equ    9                                         ; USB20 Configuration Register Select Bit 1
UEPCSELR_UCRSEL2:   equ    10                                        ; USB20 Configuration Register Select Bit 2
UEPCSELR_UCRSEL3:   equ    11                                        ; USB20 Configuration Register Select Bit 3
; bit position masks
mUEPCSELR_EPBSEL00: equ    %00000001
mUEPCSELR_EPBSEL01: equ    %00000010
mUEPCSELR_EPBSEL02: equ    %00000100
mUEPCSELR_EPBSEL10: equ    %00010000
mUEPCSELR_EPBSEL11: equ    %00100000
mUEPCSELR_EPBSEL12: equ    %01000000
mUEPCSELR_UCRSEL0:  equ    %100000000
mUEPCSELR_UCRSEL1:  equ    %1000000000
mUEPCSELR_UCRSEL2:  equ    %10000000000
mUEPCSELR_UCRSEL3:  equ    %100000000000


;*** UUCFGR - UDC Configuration Register (UPECFGRn, UNCIR, UNASR); 0x00000310 ***
UUCFGR:             equ    $00000310                                ;*** UUCFGR - UDC Configuration Register (UPECFGRn, UNCIR, UNASR); 0x00000310 ***


;*** UEPCSR0 - USB20 Endpoint Control Status Register 0; 0x00000314 ***
UEPCSR0:            equ    $00000314                                ;*** UEPCSR0 - USB20 Endpoint Control Status Register 0; 0x00000314 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
UEPCSR0_TXSIZ0:     equ    0                                         ; Transmit data size Bit 0
UEPCSR0_TXSIZ1:     equ    1                                         ; Transmit data size Bit 1
UEPCSR0_TXSIZ2:     equ    2                                         ; Transmit data size Bit 2
UEPCSR0_TXSIZ3:     equ    3                                         ; Transmit data size Bit 3
UEPCSR0_TXSIZ4:     equ    4                                         ; Transmit data size Bit 4
UEPCSR0_TXSIZ5:     equ    5                                         ; Transmit data size Bit 5
UEPCSR0_TXSIZ6:     equ    6                                         ; Transmit data size Bit 6
UEPCSR0_TCIE0:      equ    12                                        ; Transfer complete interrupt enable
UEPCSR0_TFRC0:      equ    13                                        ; Transfer Completed
UEPCSR0_DVALID0:    equ    14                                        ; Data Valid
UEPCSR0_STALL0:     equ    15                                        ; Stall
; bit position masks
mUEPCSR0_TXSIZ0:    equ    %00000001
mUEPCSR0_TXSIZ1:    equ    %00000010
mUEPCSR0_TXSIZ2:    equ    %00000100
mUEPCSR0_TXSIZ3:    equ    %00001000
mUEPCSR0_TXSIZ4:    equ    %00010000
mUEPCSR0_TXSIZ5:    equ    %00100000
mUEPCSR0_TXSIZ6:    equ    %01000000
mUEPCSR0_TCIE0:     equ    %1000000000000
mUEPCSR0_TFRC0:     equ    %10000000000000
mUEPCSR0_DVALID0:   equ    %100000000000000
mUEPCSR0_STALL0:    equ    %1000000000000000


;*** UEPCSR1 - USB20 Endpoint Control Status Register 1; 0x00000316 ***
UEPCSR1:            equ    $00000316                                ;*** UEPCSR1 - USB20 Endpoint Control Status Register 1; 0x00000316 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
UEPCSR1_RXSIZ10:    equ    0                                         ; Receive data size Bit 0
UEPCSR1_RXSIZ11:    equ    1                                         ; Receive data size Bit 1
UEPCSR1_RXSIZ12:    equ    2                                         ; Receive data size Bit 2
UEPCSR1_RXSIZ13:    equ    3                                         ; Receive data size Bit 3
UEPCSR1_RXSIZ14:    equ    4                                         ; Receive data size Bit 4
UEPCSR1_RXSIZ15:    equ    5                                         ; Receive data size Bit 5
UEPCSR1_RXSIZ16:    equ    6                                         ; Receive data size Bit 6
UEPCSR1_TCIE1:      equ    12                                        ; Transfer complete interrupt enable
UEPCSR1_TFRC1:      equ    13                                        ; Transfer Completed
UEPCSR1_DVALID1:    equ    14                                        ; Data Valid
UEPCSR1_STALL1:     equ    15                                        ; Stall
; bit position masks
mUEPCSR1_RXSIZ10:   equ    %00000001
mUEPCSR1_RXSIZ11:   equ    %00000010
mUEPCSR1_RXSIZ12:   equ    %00000100
mUEPCSR1_RXSIZ13:   equ    %00001000
mUEPCSR1_RXSIZ14:   equ    %00010000
mUEPCSR1_RXSIZ15:   equ    %00100000
mUEPCSR1_RXSIZ16:   equ    %01000000
mUEPCSR1_TCIE1:     equ    %1000000000000
mUEPCSR1_TFRC1:     equ    %10000000000000
mUEPCSR1_DVALID1:   equ    %100000000000000
mUEPCSR1_STALL1:    equ    %1000000000000000


;*** UEPCSR2 - USB20 Endpoint Control Status Register 2; 0x00000318 ***
UEPCSR2:            equ    $00000318                                ;*** UEPCSR2 - USB20 Endpoint Control Status Register 2; 0x00000318 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
UEPCSR2_RXTXSIZ20:  equ    0                                         ; Receive and transmit data size Bit 0
UEPCSR2_RXTXSIZ21:  equ    1                                         ; Receive and transmit data size Bit 1
UEPCSR2_RXTXSIZ22:  equ    2                                         ; Receive and transmit data size Bit 2
UEPCSR2_RXTXSIZ23:  equ    3                                         ; Receive and transmit data size Bit 3
UEPCSR2_RXTXSIZ24:  equ    4                                         ; Receive and transmit data size Bit 4
UEPCSR2_RXTXSIZ25:  equ    5                                         ; Receive and transmit data size Bit 5
UEPCSR2_RXTXSIZ26:  equ    6                                         ; Receive and transmit data size Bit 6
UEPCSR2_TCIE2:      equ    12                                        ; Transfer complete interrupt enable
UEPCSR2_TFRC2:      equ    13                                        ; Transfer Completed
UEPCSR2_DVALID2:    equ    14                                        ; Data Valid
UEPCSR2_STALL2:     equ    15                                        ; Stall
; bit position masks
mUEPCSR2_RXTXSIZ20: equ    %00000001
mUEPCSR2_RXTXSIZ21: equ    %00000010
mUEPCSR2_RXTXSIZ22: equ    %00000100
mUEPCSR2_RXTXSIZ23: equ    %00001000
mUEPCSR2_RXTXSIZ24: equ    %00010000
mUEPCSR2_RXTXSIZ25: equ    %00100000
mUEPCSR2_RXTXSIZ26: equ    %01000000
mUEPCSR2_TCIE2:     equ    %1000000000000
mUEPCSR2_TFRC2:     equ    %10000000000000
mUEPCSR2_DVALID2:   equ    %100000000000000
mUEPCSR2_STALL2:    equ    %1000000000000000


;*** UEPCSR3 - USB20 Endpoint Control Status Register 3; 0x0000031A ***
UEPCSR3:            equ    $0000031A                                ;*** UEPCSR3 - USB20 Endpoint Control Status Register 3; 0x0000031A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
UEPCSR3_RXTXSIZ30:  equ    0                                         ; Receive and transmit data size Bit 0
UEPCSR3_RXTXSIZ31:  equ    1                                         ; Receive and transmit data size Bit 1
UEPCSR3_RXTXSIZ32:  equ    2                                         ; Receive and transmit data size Bit 2
UEPCSR3_RXTXSIZ33:  equ    3                                         ; Receive and transmit data size Bit 3
UEPCSR3_RXTXSIZ34:  equ    4                                         ; Receive and transmit data size Bit 4
UEPCSR3_RXTXSIZ35:  equ    5                                         ; Receive and transmit data size Bit 5
UEPCSR3_RXTXSIZ36:  equ    6                                         ; Receive and transmit data size Bit 6
UEPCSR3_TCIE3:      equ    12                                        ; Transfer complete interrupt enable
UEPCSR3_TFRC3:      equ    13                                        ; Transfer Completed
UEPCSR3_DVALID3:    equ    14                                        ; Data Valid
UEPCSR3_STALL3:     equ    15                                        ; Stall
; bit position masks
mUEPCSR3_RXTXSIZ30: equ    %00000001
mUEPCSR3_RXTXSIZ31: equ    %00000010
mUEPCSR3_RXTXSIZ32: equ    %00000100
mUEPCSR3_RXTXSIZ33: equ    %00001000
mUEPCSR3_RXTXSIZ34: equ    %00010000
mUEPCSR3_RXTXSIZ35: equ    %00100000
mUEPCSR3_RXTXSIZ36: equ    %01000000
mUEPCSR3_TCIE3:     equ    %1000000000000
mUEPCSR3_TFRC3:     equ    %10000000000000
mUEPCSR3_DVALID3:   equ    %100000000000000
mUEPCSR3_STALL3:    equ    %1000000000000000


;*** UEPCSR4A - USB 20 EndPoint Control Status Register 4 A; 0x0000031C ***
UEPCSR4A:           equ    $0000031C                                ;*** UEPCSR4A - USB 20 EndPoint Control Status Register 4 A; 0x0000031C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
UEPCSR4A_RXSIZ4A0:  equ    0                                         ; Receive data size Bit 0
UEPCSR4A_RXSIZ4A1:  equ    1                                         ; Receive data size Bit 1
UEPCSR4A_RXSIZ4A2:  equ    2                                         ; Receive data size Bit 2
UEPCSR4A_RXSIZ4A3:  equ    3                                         ; Receive data size Bit 3
UEPCSR4A_RXSIZ4A4:  equ    4                                         ; Receive data size Bit 4
UEPCSR4A_RXSIZ4A5:  equ    5                                         ; Receive data size Bit 5
UEPCSR4A_RXSIZ4A6:  equ    6                                         ; Receive data size Bit 6
UEPCSR4A_RXSIZ4A7:  equ    7                                         ; Receive data size Bit 7
UEPCSR4A_RXSIZ4A8:  equ    8                                         ; Receive data size Bit 8
UEPCSR4A_RXSIZ4A9:  equ    9                                         ; Receive data size Bit 9
UEPCSR4A_RXSIZ4A10: equ    10                                        ; Receive data size Bit 10
UEPCSR4A_CTERR:     equ    11                                        ; Continue on Transfer Error
UEPCSR4A_TCIE4A:    equ    12                                        ; Transfer complete interrupt enable
UEPCSR4A_TFRC4A:    equ    13                                        ; Transfer Completed
UEPCSR4A_SNAK:      equ    14                                        ; Send NAK
UEPCSR4A_STALL4A:   equ    15                                        ; Stall
; bit position masks
mUEPCSR4A_RXSIZ4A0: equ    %00000001
mUEPCSR4A_RXSIZ4A1: equ    %00000010
mUEPCSR4A_RXSIZ4A2: equ    %00000100
mUEPCSR4A_RXSIZ4A3: equ    %00001000
mUEPCSR4A_RXSIZ4A4: equ    %00010000
mUEPCSR4A_RXSIZ4A5: equ    %00100000
mUEPCSR4A_RXSIZ4A6: equ    %01000000
mUEPCSR4A_RXSIZ4A7: equ    %10000000
mUEPCSR4A_RXSIZ4A8: equ    %100000000
mUEPCSR4A_RXSIZ4A9: equ    %1000000000
mUEPCSR4A_RXSIZ4A10: equ    %10000000000
mUEPCSR4A_CTERR:    equ    %100000000000
mUEPCSR4A_TCIE4A:   equ    %1000000000000
mUEPCSR4A_TFRC4A:   equ    %10000000000000
mUEPCSR4A_SNAK:     equ    %100000000000000
mUEPCSR4A_STALL4A:  equ    %1000000000000000


;*** UEPCSR4B -  USB20 Endpoint Control Status Register 4 B; 0x0000031E ***
UEPCSR4B:           equ    $0000031E                                ;*** UEPCSR4B -  USB20 Endpoint Control Status Register 4 B; 0x0000031E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
UEPCSR4B_MPPB0:     equ    0                                         ; Maxpkt per Block Bit 0
UEPCSR4B_MPPB1:     equ    1                                         ; Maxpkt per Block Bit 1
UEPCSR4B_MPPB2:     equ    2                                         ; Maxpkt per Block Bit 2
UEPCSR4B_MPPB3:     equ    3                                         ; Maxpkt per Block Bit 3
UEPCSR4B_CURMP0:    equ    4                                         ; Current maxpkt index Bit 0
UEPCSR4B_CURMP1:    equ    5                                         ; Current maxpkt index Bit 1
UEPCSR4B_CURMP2:    equ    6                                         ; Current maxpkt index Bit 2
UEPCSR4B_CURMP3:    equ    7                                         ; Current maxpkt index Bit 3
UEPCSR4B_EBAVA0:    equ    10                                        ; Number of empty buffer available Bit 0
UEPCSR4B_EBAVA1:    equ    11                                        ; Number of empty buffer available Bit 1
UEPCSR4B_TERRIE:    equ    12                                        ; Transfer error interrupt enable
UEPCSR4B_TFRERR:    equ    13                                        ; Transfer Error
UEPCSR4B_SPKTIE:    equ    14                                        ; Short Packet Received interrupt enable
UEPCSR4B_SPKT:      equ    15                                        ; Short Packet Received
; bit position masks
mUEPCSR4B_MPPB0:    equ    %00000001
mUEPCSR4B_MPPB1:    equ    %00000010
mUEPCSR4B_MPPB2:    equ    %00000100
mUEPCSR4B_MPPB3:    equ    %00001000
mUEPCSR4B_CURMP0:   equ    %00010000
mUEPCSR4B_CURMP1:   equ    %00100000
mUEPCSR4B_CURMP2:   equ    %01000000
mUEPCSR4B_CURMP3:   equ    %10000000
mUEPCSR4B_EBAVA0:   equ    %10000000000
mUEPCSR4B_EBAVA1:   equ    %100000000000
mUEPCSR4B_TERRIE:   equ    %1000000000000
mUEPCSR4B_TFRERR:   equ    %10000000000000
mUEPCSR4B_SPKTIE:   equ    %100000000000000
mUEPCSR4B_SPKT:     equ    %1000000000000000


;*** UEPCSR5A - USB 20 EndPoint Control Status Register 5A; 0x00000320 ***
UEPCSR5A:           equ    $00000320                                ;*** UEPCSR5A - USB 20 EndPoint Control Status Register 5A; 0x00000320 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
UEPCSR5A_TXSIZ05A0: equ    0                                         ; Transmit data size  Bit 0
UEPCSR5A_TXSIZ05A1: equ    1                                         ; Transmit data size  Bit 1
UEPCSR5A_TXSIZ05A2: equ    2                                         ; Transmit data size  Bit 2
UEPCSR5A_TXSIZ05A3: equ    3                                         ; Transmit data size  Bit 3
UEPCSR5A_TXSIZ05A4: equ    4                                         ; Transmit data size  Bit 4
UEPCSR5A_TXSIZ05A5: equ    5                                         ; Transmit data size  Bit 5
UEPCSR5A_TXSIZ05A6: equ    6                                         ; Transmit data size  Bit 6
UEPCSR5A_TXSIZ05A7: equ    7                                         ; Transmit data size  Bit 7
UEPCSR5A_TXSIZ05A8: equ    8                                         ; Transmit data size  Bit 8
UEPCSR5A_TXSIZ05A9: equ    9                                         ; Transmit data size  Bit 9
UEPCSR5A_TXSIZ05A10: equ    10                                       ; Transmit data size  Bit 10
UEPCSR5A_CTERR5A:   equ    11                                        ; Continue on Transfer Error
UEPCSR5A_TCIE5A:    equ    12                                        ; Transfer complete interrupt enable
UEPCSR5A_TFRC5A:    equ    13                                        ; Transfer Completed
UEPCSR5A_SNAK5A:    equ    14                                        ; Send NAK
UEPCSR5A_STALL5A:   equ    15                                        ; Stall
; bit position masks
mUEPCSR5A_TXSIZ05A0: equ    %00000001
mUEPCSR5A_TXSIZ05A1: equ    %00000010
mUEPCSR5A_TXSIZ05A2: equ    %00000100
mUEPCSR5A_TXSIZ05A3: equ    %00001000
mUEPCSR5A_TXSIZ05A4: equ    %00010000
mUEPCSR5A_TXSIZ05A5: equ    %00100000
mUEPCSR5A_TXSIZ05A6: equ    %01000000
mUEPCSR5A_TXSIZ05A7: equ    %10000000
mUEPCSR5A_TXSIZ05A8: equ    %100000000
mUEPCSR5A_TXSIZ05A9: equ    %1000000000
mUEPCSR5A_TXSIZ05A10: equ    %10000000000
mUEPCSR5A_CTERR5A:  equ    %100000000000
mUEPCSR5A_TCIE5A:   equ    %1000000000000
mUEPCSR5A_TFRC5A:   equ    %10000000000000
mUEPCSR5A_SNAK5A:   equ    %100000000000000
mUEPCSR5A_STALL5A:  equ    %1000000000000000


;*** UEPCSR5B - USB20 Endpoint Control Status Register 5 B; 0x00000322 ***
UEPCSR5B:           equ    $00000322                                ;*** UEPCSR5B - USB20 Endpoint Control Status Register 5 B; 0x00000322 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
UEPCSR5B_MPPB5B0:   equ    0                                         ; Maxpkt per Block Bit 0
UEPCSR5B_MPPB5B1:   equ    1                                         ; Maxpkt per Block Bit 1
UEPCSR5B_MPPB5B2:   equ    2                                         ; Maxpkt per Block Bit 2
UEPCSR5B_MPPB5B3:   equ    3                                         ; Maxpkt per Block Bit 3
UEPCSR5B_CURMP5B0:  equ    4                                         ; Current maxpkt index  Bit 0
UEPCSR5B_CURMP5B1:  equ    5                                         ; Current maxpkt index  Bit 1
UEPCSR5B_CURMP5B2:  equ    6                                         ; Current maxpkt index  Bit 2
UEPCSR5B_CURMP5B3:  equ    7                                         ; Current maxpkt index  Bit 3
UEPCSR5B_BVLD5B0:   equ    8                                         ; Number of valid buffer Bit 0
UEPCSR5B_BVLD5B1:   equ    9                                         ; Number of valid buffer Bit 1
UEPCSR5B_TERRIE5B:  equ    12                                        ; Transfer error interrupt enable
UEPCSR5B_TFRERR5B:  equ    13                                        ; Transfer Error
; bit position masks
mUEPCSR5B_MPPB5B0:  equ    %00000001
mUEPCSR5B_MPPB5B1:  equ    %00000010
mUEPCSR5B_MPPB5B2:  equ    %00000100
mUEPCSR5B_MPPB5B3:  equ    %00001000
mUEPCSR5B_CURMP5B0: equ    %00010000
mUEPCSR5B_CURMP5B1: equ    %00100000
mUEPCSR5B_CURMP5B2: equ    %01000000
mUEPCSR5B_CURMP5B3: equ    %10000000
mUEPCSR5B_BVLD5B0:  equ    %100000000
mUEPCSR5B_BVLD5B1:  equ    %1000000000
mUEPCSR5B_TERRIE5B: equ    %1000000000000
mUEPCSR5B_TFRERR5B: equ    %10000000000000


;*** UEPCSR6 - USB20 Endpoint Control Status Register 6; 0x00000324 ***
UEPCSR6:            equ    $00000324                                ;*** UEPCSR6 - USB20 Endpoint Control Status Register 6; 0x00000324 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
UEPCSR6_RXTXSIZ60:  equ    0                                         ; Receive and transmit data size Bit 0
UEPCSR6_RXTXSIZ61:  equ    1                                         ; Receive and transmit data size Bit 1
UEPCSR6_RXTXSIZ62:  equ    2                                         ; Receive and transmit data size Bit 2
UEPCSR6_RXTXSIZ63:  equ    3                                         ; Receive and transmit data size Bit 3
UEPCSR6_RXTXSIZ64:  equ    4                                         ; Receive and transmit data size Bit 4
UEPCSR6_RXTXSIZ65:  equ    5                                         ; Receive and transmit data size Bit 5
UEPCSR6_RXTXSIZ66:  equ    6                                         ; Receive and transmit data size Bit 6
UEPCSR6_TCIE6:      equ    12                                        ; Transfer complete interrupt enable
UEPCSR6_TFRC6:      equ    13                                        ; Transfer Completed
UEPCSR6_DVALID6:    equ    14                                        ; Data Valid
UEPCSR6_STALL6:     equ    15                                        ; Stall
; bit position masks
mUEPCSR6_RXTXSIZ60: equ    %00000001
mUEPCSR6_RXTXSIZ61: equ    %00000010
mUEPCSR6_RXTXSIZ62: equ    %00000100
mUEPCSR6_RXTXSIZ63: equ    %00001000
mUEPCSR6_RXTXSIZ64: equ    %00010000
mUEPCSR6_RXTXSIZ65: equ    %00100000
mUEPCSR6_RXTXSIZ66: equ    %01000000
mUEPCSR6_TCIE6:     equ    %1000000000000
mUEPCSR6_TFRC6:     equ    %10000000000000
mUEPCSR6_DVALID6:   equ    %100000000000000
mUEPCSR6_STALL6:    equ    %1000000000000000


;*** BAKEY0 - Backdoor Access Key 0; 0x0000FF00 ***
BAKEY0:             equ    $0000FF00                                ;*** BAKEY0 - Backdoor Access Key 0; 0x0000FF00 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
BAKEY0_KEY0:        equ    0                                         ; Backdoor Access Key bits, bit 0
BAKEY0_KEY1:        equ    1                                         ; Backdoor Access Key bits, bit 1
BAKEY0_KEY2:        equ    2                                         ; Backdoor Access Key bits, bit 2
BAKEY0_KEY3:        equ    3                                         ; Backdoor Access Key bits, bit 3
BAKEY0_KEY4:        equ    4                                         ; Backdoor Access Key bits, bit 4
BAKEY0_KEY5:        equ    5                                         ; Backdoor Access Key bits, bit 5
BAKEY0_KEY6:        equ    6                                         ; Backdoor Access Key bits, bit 6
BAKEY0_KEY7:        equ    7                                         ; Backdoor Access Key bits, bit 7
BAKEY0_KEY8:        equ    8                                         ; Backdoor Access Key bits, bit 8
BAKEY0_KEY9:        equ    9                                         ; Backdoor Access Key bits, bit 9
BAKEY0_KEY10:       equ    10                                        ; Backdoor Access Key bits, bit 10
BAKEY0_KEY11:       equ    11                                        ; Backdoor Access Key bits, bit 11
BAKEY0_KEY12:       equ    12                                        ; Backdoor Access Key bits, bit 12
BAKEY0_KEY13:       equ    13                                        ; Backdoor Access Key bits, bit 13
BAKEY0_KEY14:       equ    14                                        ; Backdoor Access Key bits, bit 14
BAKEY0_KEY15:       equ    15                                        ; Backdoor Access Key bits, bit 15
; bit position masks
mBAKEY0_KEY0:       equ    %00000001
mBAKEY0_KEY1:       equ    %00000010
mBAKEY0_KEY2:       equ    %00000100
mBAKEY0_KEY3:       equ    %00001000
mBAKEY0_KEY4:       equ    %00010000
mBAKEY0_KEY5:       equ    %00100000
mBAKEY0_KEY6:       equ    %01000000
mBAKEY0_KEY7:       equ    %10000000
mBAKEY0_KEY8:       equ    %100000000
mBAKEY0_KEY9:       equ    %1000000000
mBAKEY0_KEY10:      equ    %10000000000
mBAKEY0_KEY11:      equ    %100000000000
mBAKEY0_KEY12:      equ    %1000000000000
mBAKEY0_KEY13:      equ    %10000000000000
mBAKEY0_KEY14:      equ    %100000000000000
mBAKEY0_KEY15:      equ    %1000000000000000


;*** BAKEY1 - Backdoor Access Key 1; 0x0000FF02 ***
BAKEY1:             equ    $0000FF02                                ;*** BAKEY1 - Backdoor Access Key 1; 0x0000FF02 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
BAKEY1_KEY0:        equ    0                                         ; Backdoor Access Key bits, bit 0
BAKEY1_KEY1:        equ    1                                         ; Backdoor Access Key bits, bit 1
BAKEY1_KEY2:        equ    2                                         ; Backdoor Access Key bits, bit 2
BAKEY1_KEY3:        equ    3                                         ; Backdoor Access Key bits, bit 3
BAKEY1_KEY4:        equ    4                                         ; Backdoor Access Key bits, bit 4
BAKEY1_KEY5:        equ    5                                         ; Backdoor Access Key bits, bit 5
BAKEY1_KEY6:        equ    6                                         ; Backdoor Access Key bits, bit 6
BAKEY1_KEY7:        equ    7                                         ; Backdoor Access Key bits, bit 7
BAKEY1_KEY8:        equ    8                                         ; Backdoor Access Key bits, bit 8
BAKEY1_KEY9:        equ    9                                         ; Backdoor Access Key bits, bit 9
BAKEY1_KEY10:       equ    10                                        ; Backdoor Access Key bits, bit 10
BAKEY1_KEY11:       equ    11                                        ; Backdoor Access Key bits, bit 11
BAKEY1_KEY12:       equ    12                                        ; Backdoor Access Key bits, bit 12
BAKEY1_KEY13:       equ    13                                        ; Backdoor Access Key bits, bit 13
BAKEY1_KEY14:       equ    14                                        ; Backdoor Access Key bits, bit 14
BAKEY1_KEY15:       equ    15                                        ; Backdoor Access Key bits, bit 15
; bit position masks
mBAKEY1_KEY0:       equ    %00000001
mBAKEY1_KEY1:       equ    %00000010
mBAKEY1_KEY2:       equ    %00000100
mBAKEY1_KEY3:       equ    %00001000
mBAKEY1_KEY4:       equ    %00010000
mBAKEY1_KEY5:       equ    %00100000
mBAKEY1_KEY6:       equ    %01000000
mBAKEY1_KEY7:       equ    %10000000
mBAKEY1_KEY8:       equ    %100000000
mBAKEY1_KEY9:       equ    %1000000000
mBAKEY1_KEY10:      equ    %10000000000
mBAKEY1_KEY11:      equ    %100000000000
mBAKEY1_KEY12:      equ    %1000000000000
mBAKEY1_KEY13:      equ    %10000000000000
mBAKEY1_KEY14:      equ    %100000000000000
mBAKEY1_KEY15:      equ    %1000000000000000


;*** BAKEY2 - Backdoor Access Key 2; 0x0000FF04 ***
BAKEY2:             equ    $0000FF04                                ;*** BAKEY2 - Backdoor Access Key 2; 0x0000FF04 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
BAKEY2_KEY0:        equ    0                                         ; Backdoor Access Key bits, bit 0
BAKEY2_KEY1:        equ    1                                         ; Backdoor Access Key bits, bit 1
BAKEY2_KEY2:        equ    2                                         ; Backdoor Access Key bits, bit 2
BAKEY2_KEY3:        equ    3                                         ; Backdoor Access Key bits, bit 3
BAKEY2_KEY4:        equ    4                                         ; Backdoor Access Key bits, bit 4
BAKEY2_KEY5:        equ    5                                         ; Backdoor Access Key bits, bit 5
BAKEY2_KEY6:        equ    6                                         ; Backdoor Access Key bits, bit 6
BAKEY2_KEY7:        equ    7                                         ; Backdoor Access Key bits, bit 7
BAKEY2_KEY8:        equ    8                                         ; Backdoor Access Key bits, bit 8
BAKEY2_KEY9:        equ    9                                         ; Backdoor Access Key bits, bit 9
BAKEY2_KEY10:       equ    10                                        ; Backdoor Access Key bits, bit 10
BAKEY2_KEY11:       equ    11                                        ; Backdoor Access Key bits, bit 11
BAKEY2_KEY12:       equ    12                                        ; Backdoor Access Key bits, bit 12
BAKEY2_KEY13:       equ    13                                        ; Backdoor Access Key bits, bit 13
BAKEY2_KEY14:       equ    14                                        ; Backdoor Access Key bits, bit 14
BAKEY2_KEY15:       equ    15                                        ; Backdoor Access Key bits, bit 15
; bit position masks
mBAKEY2_KEY0:       equ    %00000001
mBAKEY2_KEY1:       equ    %00000010
mBAKEY2_KEY2:       equ    %00000100
mBAKEY2_KEY3:       equ    %00001000
mBAKEY2_KEY4:       equ    %00010000
mBAKEY2_KEY5:       equ    %00100000
mBAKEY2_KEY6:       equ    %01000000
mBAKEY2_KEY7:       equ    %10000000
mBAKEY2_KEY8:       equ    %100000000
mBAKEY2_KEY9:       equ    %1000000000
mBAKEY2_KEY10:      equ    %10000000000
mBAKEY2_KEY11:      equ    %100000000000
mBAKEY2_KEY12:      equ    %1000000000000
mBAKEY2_KEY13:      equ    %10000000000000
mBAKEY2_KEY14:      equ    %100000000000000
mBAKEY2_KEY15:      equ    %1000000000000000


;*** BAKEY3 - Backdoor Access Key 3; 0x0000FF06 ***
BAKEY3:             equ    $0000FF06                                ;*** BAKEY3 - Backdoor Access Key 3; 0x0000FF06 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
BAKEY3_KEY0:        equ    0                                         ; Backdoor Access Key bits, bit 0
BAKEY3_KEY1:        equ    1                                         ; Backdoor Access Key bits, bit 1
BAKEY3_KEY2:        equ    2                                         ; Backdoor Access Key bits, bit 2
BAKEY3_KEY3:        equ    3                                         ; Backdoor Access Key bits, bit 3
BAKEY3_KEY4:        equ    4                                         ; Backdoor Access Key bits, bit 4
BAKEY3_KEY5:        equ    5                                         ; Backdoor Access Key bits, bit 5
BAKEY3_KEY6:        equ    6                                         ; Backdoor Access Key bits, bit 6
BAKEY3_KEY7:        equ    7                                         ; Backdoor Access Key bits, bit 7
BAKEY3_KEY8:        equ    8                                         ; Backdoor Access Key bits, bit 8
BAKEY3_KEY9:        equ    9                                         ; Backdoor Access Key bits, bit 9
BAKEY3_KEY10:       equ    10                                        ; Backdoor Access Key bits, bit 10
BAKEY3_KEY11:       equ    11                                        ; Backdoor Access Key bits, bit 11
BAKEY3_KEY12:       equ    12                                        ; Backdoor Access Key bits, bit 12
BAKEY3_KEY13:       equ    13                                        ; Backdoor Access Key bits, bit 13
BAKEY3_KEY14:       equ    14                                        ; Backdoor Access Key bits, bit 14
BAKEY3_KEY15:       equ    15                                        ; Backdoor Access Key bits, bit 15
; bit position masks
mBAKEY3_KEY0:       equ    %00000001
mBAKEY3_KEY1:       equ    %00000010
mBAKEY3_KEY2:       equ    %00000100
mBAKEY3_KEY3:       equ    %00001000
mBAKEY3_KEY4:       equ    %00010000
mBAKEY3_KEY5:       equ    %00100000
mBAKEY3_KEY6:       equ    %01000000
mBAKEY3_KEY7:       equ    %10000000
mBAKEY3_KEY8:       equ    %100000000
mBAKEY3_KEY9:       equ    %1000000000
mBAKEY3_KEY10:      equ    %10000000000
mBAKEY3_KEY11:      equ    %100000000000
mBAKEY3_KEY12:      equ    %1000000000000
mBAKEY3_KEY13:      equ    %10000000000000
mBAKEY3_KEY14:      equ    %100000000000000
mBAKEY3_KEY15:      equ    %1000000000000000


;*** NVFPROT0 - Non volatile Block 0 Flash Protection Register; 0x0000FF0D ***
NVFPROT0:           equ    $0000FF0D                                ;*** NVFPROT0 - Non volatile Block 0 Flash Protection Register; 0x0000FF0D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NVFPROT0_FPLS0:     equ    0                                         ; Flash Protection Lower Address size 0
NVFPROT0_FPLS1:     equ    1                                         ; Flash Protection Lower Address size 1
NVFPROT0_FPLDIS:    equ    2                                         ; Flash Protection Lower address range disable
NVFPROT0_FPHS0:     equ    3                                         ; Flash Protection Higher address size 0
NVFPROT0_FPHS1:     equ    4                                         ; Flash Protection Higher address size 1
NVFPROT0_FPHDIS:    equ    5                                         ; Flash Protection Higher address range disable
NVFPROT0_NV6:       equ    6                                         ; Non Volatile Flag Bit
NVFPROT0_FPOPEN:    equ    7                                         ; Opens the flash block or subsections of it for program or erase
; bit position masks
mNVFPROT0_FPLS0:    equ    %00000001
mNVFPROT0_FPLS1:    equ    %00000010
mNVFPROT0_FPLDIS:   equ    %00000100
mNVFPROT0_FPHS0:    equ    %00001000
mNVFPROT0_FPHS1:    equ    %00010000
mNVFPROT0_FPHDIS:   equ    %00100000
mNVFPROT0_NV6:      equ    %01000000
mNVFPROT0_FPOPEN:   equ    %10000000


;*** NVFSEC - Non volatile Flash Security Register; 0x0000FF0F ***
NVFSEC:             equ    $0000FF0F                                ;*** NVFSEC - Non volatile Flash Security Register; 0x0000FF0F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NVFSEC_SEC0:        equ    0                                         ; Memory security bit 0
NVFSEC_SEC1:        equ    1                                         ; Memory security bit 1
NVFSEC_NV2:         equ    2                                         ; Non Volatile flag bit 2
NVFSEC_NV3:         equ    3                                         ; Non Volatile flag bit 3
NVFSEC_NV4:         equ    4                                         ; Non Volatile flag bit 4
NVFSEC_NV5:         equ    5                                         ; Non Volatile flag bit 5
NVFSEC_NV6:         equ    6                                         ; Non Volatile flag bit 6
NVFSEC_KEYEN:       equ    7                                         ; Backdoor Key Security Enable
; bit position masks
mNVFSEC_SEC0:       equ    %00000001
mNVFSEC_SEC1:       equ    %00000010
mNVFSEC_NV2:        equ    %00000100
mNVFSEC_NV3:        equ    %00001000
mNVFSEC_NV4:        equ    %00010000
mNVFSEC_NV5:        equ    %00100000
mNVFSEC_NV6:        equ    %01000000
mNVFSEC_KEYEN:      equ    %10000000



;***********************************************
;**   D E P R E C I A T E D   S Y M B O L S   **
;***********************************************
        IFNDEF  __GENERATE_APPLICATION__                            ; not supported for absolute assembler
                    XREF    This_symb_has_been_depreciated
        ENDIF
; ---------------------------------------------------------------------------
; The following symbols were removed, because they were invalid or irrelevant
; ---------------------------------------------------------------------------
;
; Follows changes from the database 2.87.1351 version
SCIBDH_TNP0_Hi                           EQU        SCIBDH_TNP0
mSCIBDH_TNP0_Hi                          EQU        mSCIBDH_TNP0
SCIBDH_TNP1_Hi                           EQU        SCIBDH_TNP1
mSCIBDH_TNP1_Hi                          EQU        mSCIBDH_TNP1
SCIBDH_IREN_Hi                           EQU        SCIBDH_IREN
mSCIBDH_IREN_Hi                          EQU        mSCIBDH_IREN


; **** 24.10.2007 11:10:33

        IFNDEF __GENERATE_APPLICATION__
SMRAMStart:                              equ        RAMStart
SMRAMEnd:                                equ        RAMEnd
        ENDIF

; EOF
