/* Based on CPU DB MC9S12UF32_100, version 2.87.1371 (RegistersPrg V2.32) */
/*
** ###################################################################
**     Filename  : mc9s12uf32.h
**     Processor : MC9S12UF32PU
**     FileFormat: V2.32
**     DataSheet : 9S12UF32SOCGuide/D V01.00
**     Compiler  : CodeWarrior compiler
**     Date/Time : 8.6.2010, 8:50
**     Abstract  :
**         This header implements the mapping of I/O devices.
**
**     Copyright : 1997 - 2010 Freescale Semiconductor, Inc. All Rights Reserved.
**     
**     http      : www.freescale.com
**     mail      : support@freescale.com
**
**     CPU Registers Revisions:
**      - 13.09.2006, V2.87.1361:
**              - Renamed bits IREN_Hi ==> IREN, TNPx_Hi ==> TNPx. REASON: Bug-fix (#3552 in Issue Manager)
**
**     File-Format-Revisions:
**      - 14.11.2005, V2.00 :
**               - Deprecated symbols added for backward compatibility (section at the end of this file)
**      - 15.11.2005, V2.01 :
**               - Fixed invalid instruction in macro __RESET_WATCHDOG for HCS12 family.
**      - 17.12.2005, V2.02 :
**               - Arrays (symbols xx_ARR) are defined as pointer to volatile, see issue #2778
**      - 16.01.2006, V2.03 :
**               - Fixed declaration of non volatile registers. Now it does not require (but allows) their initialization, see issue #2920.
**               - "volatile" modifier removed from declaration of non volatile registers (that contain modifier "const")
**      - 08.03.2006, V2.04 :
**               - Support for bit(s) names duplicated with any register name in .h header files
**      - 24.03.2006, V2.05 :
**               - Fixed macro __RESET_WATCHDOG for HCS12 family - address and correct write order.
**      - 26.04.2006, V2.06 :
**               - Changes have not affected this file (because they are related to another family)
**      - 27.04.2006, V2.07 :
**               - Fixed macro __RESET_WATCHDOG for HCS12, HCS12X ,HCS08 DZ and HCS08 EN derivatives (write 0x55,0xAA).
**      - 07.06.2006, V2.08 :
**               - Changes have not affected this file (because they are related to another family)
**      - 03.07.2006, V2.09 :
**               - Changes have not affected this file (because they are related to another family)
**      - 27.10.2006, V2.10 :
**               - __RESET_WATCHDOG improved formating and re-definition
**      - 23.11.2006, V2.11 :
**               - Changes have not affected this file (because they are related to another family)
**      - 22.01.2007, V2.12 :
**               - Fixed declaration of non volatile registers. Now it does not require (but allows) their initialization, see issue #4086.
**      - 01.03.2007, V2.13 :
**               - Flash commands constants values converted to HEX format
**      - 02.03.2007, V2.14 :
**               - Interrupt vector numbers added into .H, see VectorNumber_*
**      - 26.03.2007, V2.15 :
**               - Changes have not affected this file (because they are related to another family)
**      - 10.05.2007, V2.16 :
**               - Changes have not affected this file (because they are related to another family)
**      - 05.06.2007, V2.17 :
**               - Changes have not affected this file (because they are related to another family)
**      - 19.07.2007, V2.18 :
**               - Improved number of blanked lines inside register structures
**      - 06.08.2007, V2.19 :
**               - CPUDB revisions generated ahead of the file-format revisions.
**      - 11.09.2007, V2.20 :
**               - Added comment about initialization of unbonded pins.
**      - 02.01.2008, V2.21 :
**               - Changes have not affected this file (because they are related to another family)
**      - 13.02.2008, V2.22 :
**               - Changes have not affected this file (because they are related to another family)
**      - 20.02.2008, V2.23 :
**               - Termination of pragma V30toV31Compatible added, #5708
**      - 03.07.2008, V2.24 :
**               - Added support for bits with name starting with number (like "1HZ")
**      - 28.11.2008, V2.25 :
**               - StandBy RAM array declaration for ANSI-C added
**      - 1.12.2008, V2.26 :
**               - Duplication of bit (or bit-group) name with register name is not marked as a problem, is register is internal only and it is not displayed in I/O map.
**      - 17.3.2009, V2.27 :
**               - Merged bit-group is not generated, if the name matches with another bit name in the register
**      - 6.4.2009, V2.28 :
**               - Fixed generation of merged bits for bit-groups with a digit at the end, if group-name is defined in CPUDB
**      - 3.8.2009, V2.29 :
**               - If there is just one bits group matching register name, single bits are not generated
**      - 10.9.2009, V2.30 :
**               - Fixed generation of registers arrays.
**      - 15.10.2009, V2.31 :
**               - Changes have not affected this file (because they are related to another family)
**      - 18.05.2010, V2.32 :
**               - MISRA compliance: U/UL suffixes added to all numbers (_MASK,_BITNUM and addresses)
**
**     Not all general-purpose I/O pins are available on all packages or on all mask sets of a specific
**     derivative device. To avoid extra current drain from floating input pins, the users reset
**     initialization routine in the application program must either enable on-chip pull-up devices
**     or change the direction of unconnected pins to outputs so the pins do not float.
** ###################################################################
*/

#ifndef _MC9S12UF32_H
#define _MC9S12UF32_H

/*lint -save  -e950 -esym(960,18.4) -e46 -esym(961,19.7) Disable MISRA rule (1.1,18.4,6.4,19.7) checking. */
/* Types definition */
typedef unsigned char byte;
typedef unsigned int word;
typedef unsigned long dword;
typedef unsigned long dlong[2];

#define REG_BASE 0x0000                /* Base address for the I/O register block */


#pragma MESSAGE DISABLE C1106 /* WARNING C1106: Non-standard bitfield type */
#pragma OPTION ADD V30toV31Compatible "-BfaGapLimitBits4294967295" /*this guarantee correct bitfield positions*/

/**************** interrupt vector numbers ****************/
#define VectorNumber_VReserved63        63U
#define VectorNumber_Vsmhcs             62U
#define VectorNumber_Vsmhce             61U
#define VectorNumber_Vsdhc              60U
#define VectorNumber_Vmshc              59U
#define VectorNumber_Vcfireqhc          58U
#define VectorNumber_Vcfsfthc           57U
#define VectorNumber_Vata5hc            56U
#define VectorNumber_VReserved55        55U
#define VectorNumber_VReserved54        54U
#define VectorNumber_Viquech34dbtc      53U
#define VectorNumber_Viquech34dbe       52U
#define VectorNumber_Viquech34dbf       51U
#define VectorNumber_Viquech12dbtc      50U
#define VectorNumber_Viquech12dbe       49U
#define VectorNumber_Viquech12dbf       48U
#define VectorNumber_Viquech4v          47U
#define VectorNumber_Viquech4e          46U
#define VectorNumber_Viquech4f          45U
#define VectorNumber_Viquech3v          44U
#define VectorNumber_Viquech3e          43U
#define VectorNumber_Viquech3f          42U
#define VectorNumber_Viquech2v          41U
#define VectorNumber_Viquech2e          40U
#define VectorNumber_Viquech2f          39U
#define VectorNumber_Viquech1v          38U
#define VectorNumber_Viquech1e          37U
#define VectorNumber_Viquech1f          36U
#define VectorNumber_Vflash             35U
#define VectorNumber_VReserved34        34U
#define VectorNumber_VReserved33        33U
#define VectorNumber_Vusbsof            32U
#define VectorNumber_Vusbe6             31U
#define VectorNumber_Vusbe5             30U
#define VectorNumber_Vusbe4             29U
#define VectorNumber_Vcrgplllck         28U
#define VectorNumber_Vusbe3             27U
#define VectorNumber_Vusbe2             26U
#define VectorNumber_Vusbe0o            25U
#define VectorNumber_Vusbe0i            24U
#define VectorNumber_Vusbsecrr          23U
#define VectorNumber_Vusbscr            22U
#define VectorNumber_Vusbsc             21U
#define VectorNumber_Vsci               20U
#define VectorNumber_VReserved19        19U
#define VectorNumber_Vtimpaie           18U
#define VectorNumber_Vtimpaovf          17U
#define VectorNumber_Vtimovf            16U
#define VectorNumber_Vtimch7            15U
#define VectorNumber_Vtimch6            14U
#define VectorNumber_Vtimch5            13U
#define VectorNumber_Vtimch4            12U
#define VectorNumber_Vtimch3            11U
#define VectorNumber_Vtimch2            10U
#define VectorNumber_Vtimch1            9U
#define VectorNumber_Vtimch0            8U
#define VectorNumber_Vrti               7U
#define VectorNumber_Virq               6U
#define VectorNumber_Vxirq              5U
#define VectorNumber_Vswi               4U
#define VectorNumber_Vtrap              3U
#define VectorNumber_Vcop               2U
#define VectorNumber_VReserved1         1U
#define VectorNumber_Vreset             0U

/**************** interrupt vector table ****************/
#define VReserved63                     0xFF80U
#define Vsmhcs                          0xFF82U
#define Vsmhce                          0xFF84U
#define Vsdhc                           0xFF86U
#define Vmshc                           0xFF88U
#define Vcfireqhc                       0xFF8AU
#define Vcfsfthc                        0xFF8CU
#define Vata5hc                         0xFF8EU
#define VReserved55                     0xFF90U
#define VReserved54                     0xFF92U
#define Viquech34dbtc                   0xFF94U
#define Viquech34dbe                    0xFF96U
#define Viquech34dbf                    0xFF98U
#define Viquech12dbtc                   0xFF9AU
#define Viquech12dbe                    0xFF9CU
#define Viquech12dbf                    0xFF9EU
#define Viquech4v                       0xFFA0U
#define Viquech4e                       0xFFA2U
#define Viquech4f                       0xFFA4U
#define Viquech3v                       0xFFA6U
#define Viquech3e                       0xFFA8U
#define Viquech3f                       0xFFAAU
#define Viquech2v                       0xFFACU
#define Viquech2e                       0xFFAEU
#define Viquech2f                       0xFFB0U
#define Viquech1v                       0xFFB2U
#define Viquech1e                       0xFFB4U
#define Viquech1f                       0xFFB6U
#define Vflash                          0xFFB8U
#define VReserved34                     0xFFBAU
#define VReserved33                     0xFFBCU
#define Vusbsof                         0xFFBEU
#define Vusbe6                          0xFFC0U
#define Vusbe5                          0xFFC2U
#define Vusbe4                          0xFFC4U
#define Vcrgplllck                      0xFFC6U
#define Vusbe3                          0xFFC8U
#define Vusbe2                          0xFFCAU
#define Vusbe0o                         0xFFCCU
#define Vusbe0i                         0xFFCEU
#define Vusbsecrr                       0xFFD0U
#define Vusbscr                         0xFFD2U
#define Vusbsc                          0xFFD4U
#define Vsci                            0xFFD6U
#define VReserved19                     0xFFD8U
#define Vtimpaie                        0xFFDAU
#define Vtimpaovf                       0xFFDCU
#define Vtimovf                         0xFFDEU
#define Vtimch7                         0xFFE0U
#define Vtimch6                         0xFFE2U
#define Vtimch5                         0xFFE4U
#define Vtimch4                         0xFFE6U
#define Vtimch3                         0xFFE8U
#define Vtimch2                         0xFFEAU
#define Vtimch1                         0xFFECU
#define Vtimch0                         0xFFEEU
#define Vrti                            0xFFF0U
#define Virq                            0xFFF2U
#define Vxirq                           0xFFF4U
#define Vswi                            0xFFF6U
#define Vtrap                           0xFFF8U
#define Vcop                            0xFFFAU
#define VReserved1                      0xFFFCU
#define Vreset                          0xFFFEU

/**************** registers I/O map ****************/

/*** PORTAB - Port AB Register; 0x00000000 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** PORTA - Port A Register; 0x00000000 ***/
    union {
      byte Byte;
      struct {
        byte BIT0        :1;                                       /* Port A Bit 0 */
        byte BIT1        :1;                                       /* Port A Bit 1 */
        byte BIT2        :1;                                       /* Port A Bit 2 */
        byte BIT3        :1;                                       /* Port A Bit 3 */
        byte BIT4        :1;                                       /* Port A Bit 4 */
        byte BIT5        :1;                                       /* Port A Bit 5 */
        byte BIT6        :1;                                       /* Port A Bit 6 */
        byte BIT7        :1;                                       /* Port A Bit 7 */
      } Bits;
    } PORTASTR;
    #define PORTA                       _PORTAB.Overlap_STR.PORTASTR.Byte
    #define PORTA_BIT0                  _PORTAB.Overlap_STR.PORTASTR.Bits.BIT0
    #define PORTA_BIT1                  _PORTAB.Overlap_STR.PORTASTR.Bits.BIT1
    #define PORTA_BIT2                  _PORTAB.Overlap_STR.PORTASTR.Bits.BIT2
    #define PORTA_BIT3                  _PORTAB.Overlap_STR.PORTASTR.Bits.BIT3
    #define PORTA_BIT4                  _PORTAB.Overlap_STR.PORTASTR.Bits.BIT4
    #define PORTA_BIT5                  _PORTAB.Overlap_STR.PORTASTR.Bits.BIT5
    #define PORTA_BIT6                  _PORTAB.Overlap_STR.PORTASTR.Bits.BIT6
    #define PORTA_BIT7                  _PORTAB.Overlap_STR.PORTASTR.Bits.BIT7
    
    #define PORTA_BIT0_MASK             1U
    #define PORTA_BIT1_MASK             2U
    #define PORTA_BIT2_MASK             4U
    #define PORTA_BIT3_MASK             8U
    #define PORTA_BIT4_MASK             16U
    #define PORTA_BIT5_MASK             32U
    #define PORTA_BIT6_MASK             64U
    #define PORTA_BIT7_MASK             128U
    

    /*** PORTB - Port B Register; 0x00000001 ***/
    union {
      byte Byte;
      struct {
        byte BIT0        :1;                                       /* Port B Bit 0 */
        byte BIT1        :1;                                       /* Port B Bit 1 */
        byte BIT2        :1;                                       /* Port B Bit 2 */
        byte BIT3        :1;                                       /* Port B Bit 3 */
        byte BIT4        :1;                                       /* Port B Bit 4 */
        byte BIT5        :1;                                       /* Port B Bit 5 */
        byte BIT6        :1;                                       /* Port B Bit 6 */
        byte BIT7        :1;                                       /* Port B Bit 7 */
      } Bits;
    } PORTBSTR;
    #define PORTB                       _PORTAB.Overlap_STR.PORTBSTR.Byte
    #define PORTB_BIT0                  _PORTAB.Overlap_STR.PORTBSTR.Bits.BIT0
    #define PORTB_BIT1                  _PORTAB.Overlap_STR.PORTBSTR.Bits.BIT1
    #define PORTB_BIT2                  _PORTAB.Overlap_STR.PORTBSTR.Bits.BIT2
    #define PORTB_BIT3                  _PORTAB.Overlap_STR.PORTBSTR.Bits.BIT3
    #define PORTB_BIT4                  _PORTAB.Overlap_STR.PORTBSTR.Bits.BIT4
    #define PORTB_BIT5                  _PORTAB.Overlap_STR.PORTBSTR.Bits.BIT5
    #define PORTB_BIT6                  _PORTAB.Overlap_STR.PORTBSTR.Bits.BIT6
    #define PORTB_BIT7                  _PORTAB.Overlap_STR.PORTBSTR.Bits.BIT7
    
    #define PORTB_BIT0_MASK             1U
    #define PORTB_BIT1_MASK             2U
    #define PORTB_BIT2_MASK             4U
    #define PORTB_BIT3_MASK             8U
    #define PORTB_BIT4_MASK             16U
    #define PORTB_BIT5_MASK             32U
    #define PORTB_BIT6_MASK             64U
    #define PORTB_BIT7_MASK             128U
    
  } Overlap_STR;

  struct {
    word BIT0        :1;                                       /* Port AB Bit 0 */
    word BIT1        :1;                                       /* Port AB Bit 1 */
    word BIT2        :1;                                       /* Port AB Bit 2 */
    word BIT3        :1;                                       /* Port AB Bit 3 */
    word BIT4        :1;                                       /* Port AB Bit 4 */
    word BIT5        :1;                                       /* Port AB Bit 5 */
    word BIT6        :1;                                       /* Port AB Bit 6 */
    word BIT7        :1;                                       /* Port AB Bit 7 */
    word BIT8        :1;                                       /* Port AB Bit 8 */
    word BIT9        :1;                                       /* Port AB Bit 9 */
    word BIT10       :1;                                       /* Port AB Bit 10 */
    word BIT11       :1;                                       /* Port AB Bit 11 */
    word BIT12       :1;                                       /* Port AB Bit 12 */
    word BIT13       :1;                                       /* Port AB Bit 13 */
    word BIT14       :1;                                       /* Port AB Bit 14 */
    word BIT15       :1;                                       /* Port AB Bit 15 */
  } Bits;
} PORTABSTR;
extern volatile PORTABSTR _PORTAB @(REG_BASE + 0x00000000UL);
#define PORTAB                          _PORTAB.Word
#define PORTAB_BIT0                     _PORTAB.Bits.BIT0
#define PORTAB_BIT1                     _PORTAB.Bits.BIT1
#define PORTAB_BIT2                     _PORTAB.Bits.BIT2
#define PORTAB_BIT3                     _PORTAB.Bits.BIT3
#define PORTAB_BIT4                     _PORTAB.Bits.BIT4
#define PORTAB_BIT5                     _PORTAB.Bits.BIT5
#define PORTAB_BIT6                     _PORTAB.Bits.BIT6
#define PORTAB_BIT7                     _PORTAB.Bits.BIT7
#define PORTAB_BIT8                     _PORTAB.Bits.BIT8
#define PORTAB_BIT9                     _PORTAB.Bits.BIT9
#define PORTAB_BIT10                    _PORTAB.Bits.BIT10
#define PORTAB_BIT11                    _PORTAB.Bits.BIT11
#define PORTAB_BIT12                    _PORTAB.Bits.BIT12
#define PORTAB_BIT13                    _PORTAB.Bits.BIT13
#define PORTAB_BIT14                    _PORTAB.Bits.BIT14
#define PORTAB_BIT15                    _PORTAB.Bits.BIT15

#define PORTAB_BIT0_MASK                1U
#define PORTAB_BIT1_MASK                2U
#define PORTAB_BIT2_MASK                4U
#define PORTAB_BIT3_MASK                8U
#define PORTAB_BIT4_MASK                16U
#define PORTAB_BIT5_MASK                32U
#define PORTAB_BIT6_MASK                64U
#define PORTAB_BIT7_MASK                128U
#define PORTAB_BIT8_MASK                256U
#define PORTAB_BIT9_MASK                512U
#define PORTAB_BIT10_MASK               1024U
#define PORTAB_BIT11_MASK               2048U
#define PORTAB_BIT12_MASK               4096U
#define PORTAB_BIT13_MASK               8192U
#define PORTAB_BIT14_MASK               16384U
#define PORTAB_BIT15_MASK               32768U


/*** DDRAB - Port AB Data Direction Register; 0x00000002 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** DDRA - Port A Data Direction Register; 0x00000002 ***/
    union {
      byte Byte;
      struct {
        byte BIT0        :1;                                       /* Data Direction Port A Bit 0 */
        byte BIT1        :1;                                       /* Data Direction Port A Bit 1 */
        byte BIT2        :1;                                       /* Data Direction Port A Bit 2 */
        byte BIT3        :1;                                       /* Data Direction Port A Bit 3 */
        byte BIT4        :1;                                       /* Data Direction Port A Bit 4 */
        byte BIT5        :1;                                       /* Data Direction Port A Bit 5 */
        byte BIT6        :1;                                       /* Data Direction Port A Bit 6 */
        byte BIT7        :1;                                       /* Data Direction Port A Bit 7 */
      } Bits;
    } DDRASTR;
    #define DDRA                        _DDRAB.Overlap_STR.DDRASTR.Byte
    #define DDRA_BIT0                   _DDRAB.Overlap_STR.DDRASTR.Bits.BIT0
    #define DDRA_BIT1                   _DDRAB.Overlap_STR.DDRASTR.Bits.BIT1
    #define DDRA_BIT2                   _DDRAB.Overlap_STR.DDRASTR.Bits.BIT2
    #define DDRA_BIT3                   _DDRAB.Overlap_STR.DDRASTR.Bits.BIT3
    #define DDRA_BIT4                   _DDRAB.Overlap_STR.DDRASTR.Bits.BIT4
    #define DDRA_BIT5                   _DDRAB.Overlap_STR.DDRASTR.Bits.BIT5
    #define DDRA_BIT6                   _DDRAB.Overlap_STR.DDRASTR.Bits.BIT6
    #define DDRA_BIT7                   _DDRAB.Overlap_STR.DDRASTR.Bits.BIT7
    
    #define DDRA_BIT0_MASK              1U
    #define DDRA_BIT1_MASK              2U
    #define DDRA_BIT2_MASK              4U
    #define DDRA_BIT3_MASK              8U
    #define DDRA_BIT4_MASK              16U
    #define DDRA_BIT5_MASK              32U
    #define DDRA_BIT6_MASK              64U
    #define DDRA_BIT7_MASK              128U
    

    /*** DDRB - Port B Data Direction Register; 0x00000003 ***/
    union {
      byte Byte;
      struct {
        byte BIT0        :1;                                       /* Data Direction Port B Bit 0 */
        byte BIT1        :1;                                       /* Data Direction Port B Bit 1 */
        byte BIT2        :1;                                       /* Data Direction Port B Bit 2 */
        byte BIT3        :1;                                       /* Data Direction Port B Bit 3 */
        byte BIT4        :1;                                       /* Data Direction Port B Bit 4 */
        byte BIT5        :1;                                       /* Data Direction Port B Bit 5 */
        byte BIT6        :1;                                       /* Data Direction Port B Bit 6 */
        byte BIT7        :1;                                       /* Data Direction Port B Bit 7 */
      } Bits;
    } DDRBSTR;
    #define DDRB                        _DDRAB.Overlap_STR.DDRBSTR.Byte
    #define DDRB_BIT0                   _DDRAB.Overlap_STR.DDRBSTR.Bits.BIT0
    #define DDRB_BIT1                   _DDRAB.Overlap_STR.DDRBSTR.Bits.BIT1
    #define DDRB_BIT2                   _DDRAB.Overlap_STR.DDRBSTR.Bits.BIT2
    #define DDRB_BIT3                   _DDRAB.Overlap_STR.DDRBSTR.Bits.BIT3
    #define DDRB_BIT4                   _DDRAB.Overlap_STR.DDRBSTR.Bits.BIT4
    #define DDRB_BIT5                   _DDRAB.Overlap_STR.DDRBSTR.Bits.BIT5
    #define DDRB_BIT6                   _DDRAB.Overlap_STR.DDRBSTR.Bits.BIT6
    #define DDRB_BIT7                   _DDRAB.Overlap_STR.DDRBSTR.Bits.BIT7
    
    #define DDRB_BIT0_MASK              1U
    #define DDRB_BIT1_MASK              2U
    #define DDRB_BIT2_MASK              4U
    #define DDRB_BIT3_MASK              8U
    #define DDRB_BIT4_MASK              16U
    #define DDRB_BIT5_MASK              32U
    #define DDRB_BIT6_MASK              64U
    #define DDRB_BIT7_MASK              128U
    
  } Overlap_STR;

  struct {
    word BIT0        :1;                                       /* Data Direction Port AB Bit 0 */
    word BIT1        :1;                                       /* Data Direction Port AB Bit 1 */
    word BIT2        :1;                                       /* Data Direction Port AB Bit 2 */
    word BIT3        :1;                                       /* Data Direction Port AB Bit 3 */
    word BIT4        :1;                                       /* Data Direction Port AB Bit 4 */
    word BIT5        :1;                                       /* Data Direction Port AB Bit 5 */
    word BIT6        :1;                                       /* Data Direction Port AB Bit 6 */
    word BIT7        :1;                                       /* Data Direction Port AB Bit 7 */
    word BIT8        :1;                                       /* Data Direction Port AB Bit 8 */
    word BIT9        :1;                                       /* Data Direction Port AB Bit 9 */
    word BIT10       :1;                                       /* Data Direction Port AB Bit 10 */
    word BIT11       :1;                                       /* Data Direction Port AB Bit 11 */
    word BIT12       :1;                                       /* Data Direction Port AB Bit 12 */
    word BIT13       :1;                                       /* Data Direction Port AB Bit 13 */
    word BIT14       :1;                                       /* Data Direction Port AB Bit 14 */
    word BIT15       :1;                                       /* Data Direction Port AB Bit 15 */
  } Bits;
} DDRABSTR;
extern volatile DDRABSTR _DDRAB @(REG_BASE + 0x00000002UL);
#define DDRAB                           _DDRAB.Word
#define DDRAB_BIT0                      _DDRAB.Bits.BIT0
#define DDRAB_BIT1                      _DDRAB.Bits.BIT1
#define DDRAB_BIT2                      _DDRAB.Bits.BIT2
#define DDRAB_BIT3                      _DDRAB.Bits.BIT3
#define DDRAB_BIT4                      _DDRAB.Bits.BIT4
#define DDRAB_BIT5                      _DDRAB.Bits.BIT5
#define DDRAB_BIT6                      _DDRAB.Bits.BIT6
#define DDRAB_BIT7                      _DDRAB.Bits.BIT7
#define DDRAB_BIT8                      _DDRAB.Bits.BIT8
#define DDRAB_BIT9                      _DDRAB.Bits.BIT9
#define DDRAB_BIT10                     _DDRAB.Bits.BIT10
#define DDRAB_BIT11                     _DDRAB.Bits.BIT11
#define DDRAB_BIT12                     _DDRAB.Bits.BIT12
#define DDRAB_BIT13                     _DDRAB.Bits.BIT13
#define DDRAB_BIT14                     _DDRAB.Bits.BIT14
#define DDRAB_BIT15                     _DDRAB.Bits.BIT15

#define DDRAB_BIT0_MASK                 1U
#define DDRAB_BIT1_MASK                 2U
#define DDRAB_BIT2_MASK                 4U
#define DDRAB_BIT3_MASK                 8U
#define DDRAB_BIT4_MASK                 16U
#define DDRAB_BIT5_MASK                 32U
#define DDRAB_BIT6_MASK                 64U
#define DDRAB_BIT7_MASK                 128U
#define DDRAB_BIT8_MASK                 256U
#define DDRAB_BIT9_MASK                 512U
#define DDRAB_BIT10_MASK                1024U
#define DDRAB_BIT11_MASK                2048U
#define DDRAB_BIT12_MASK                4096U
#define DDRAB_BIT13_MASK                8192U
#define DDRAB_BIT14_MASK                16384U
#define DDRAB_BIT15_MASK                32768U


/*** PORTE - Port E Register; 0x00000008 ***/
typedef union {
  byte Byte;
  struct {
    byte BIT0        :1;                                       /* Port E Bit 0 */
    byte BIT1        :1;                                       /* Port E Bit 1 */
    byte BIT2        :1;                                       /* Port E Bit 2 */
    byte BIT3        :1;                                       /* Port E Bit 3 */
    byte BIT4        :1;                                       /* Port E Bit 4 */
    byte BIT5        :1;                                       /* Port E Bit 5 */
    byte BIT6        :1;                                       /* Port E Bit 6 */
    byte BIT7        :1;                                       /* Port E Bit 7 */
  } Bits;
} PORTESTR;
extern volatile PORTESTR _PORTE @(REG_BASE + 0x00000008UL);
#define PORTE                           _PORTE.Byte
#define PORTE_BIT0                      _PORTE.Bits.BIT0
#define PORTE_BIT1                      _PORTE.Bits.BIT1
#define PORTE_BIT2                      _PORTE.Bits.BIT2
#define PORTE_BIT3                      _PORTE.Bits.BIT3
#define PORTE_BIT4                      _PORTE.Bits.BIT4
#define PORTE_BIT5                      _PORTE.Bits.BIT5
#define PORTE_BIT6                      _PORTE.Bits.BIT6
#define PORTE_BIT7                      _PORTE.Bits.BIT7

#define PORTE_BIT0_MASK                 1U
#define PORTE_BIT1_MASK                 2U
#define PORTE_BIT2_MASK                 4U
#define PORTE_BIT3_MASK                 8U
#define PORTE_BIT4_MASK                 16U
#define PORTE_BIT5_MASK                 32U
#define PORTE_BIT6_MASK                 64U
#define PORTE_BIT7_MASK                 128U


/*** DDRE - Port E Data Direction Register; 0x00000009 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte BIT2        :1;                                       /* Data Direction Port E Bit 2 */
    byte BIT3        :1;                                       /* Data Direction Port E Bit 3 */
    byte BIT4        :1;                                       /* Data Direction Port E Bit 4 */
    byte BIT5        :1;                                       /* Data Direction Port E Bit 5 */
    byte BIT6        :1;                                       /* Data Direction Port E Bit 6 */
    byte BIT7        :1;                                       /* Data Direction Port E Bit 7 */
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte grpBIT_2 :6;
  } MergedBits;
} DDRESTR;
extern volatile DDRESTR _DDRE @(REG_BASE + 0x00000009UL);
#define DDRE                            _DDRE.Byte
#define DDRE_BIT2                       _DDRE.Bits.BIT2
#define DDRE_BIT3                       _DDRE.Bits.BIT3
#define DDRE_BIT4                       _DDRE.Bits.BIT4
#define DDRE_BIT5                       _DDRE.Bits.BIT5
#define DDRE_BIT6                       _DDRE.Bits.BIT6
#define DDRE_BIT7                       _DDRE.Bits.BIT7
#define DDRE_BIT_2                      _DDRE.MergedBits.grpBIT_2
#define DDRE_BIT                        DDRE_BIT_2

#define DDRE_BIT2_MASK                  4U
#define DDRE_BIT3_MASK                  8U
#define DDRE_BIT4_MASK                  16U
#define DDRE_BIT5_MASK                  32U
#define DDRE_BIT6_MASK                  64U
#define DDRE_BIT7_MASK                  128U
#define DDRE_BIT_2_MASK                 252U
#define DDRE_BIT_2_BITNUM               2U


/*** PEAR - Port E Assignment Register; 0x0000000A ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte RDWE        :1;                                       /* Read / Write Enable */
    byte LSTRE       :1;                                       /* Low Strobe (LSTRB) Enable */
    byte NECLK       :1;                                       /* No External E Clock */
    byte PIPOE       :1;                                       /* Pipe Status Signal Output Enable */
    byte             :1; 
    byte NOACCE      :1;                                       /* CPU No Access Output Enable */
  } Bits;
} PEARSTR;
extern volatile PEARSTR _PEAR @(REG_BASE + 0x0000000AUL);
#define PEAR                            _PEAR.Byte
#define PEAR_RDWE                       _PEAR.Bits.RDWE
#define PEAR_LSTRE                      _PEAR.Bits.LSTRE
#define PEAR_NECLK                      _PEAR.Bits.NECLK
#define PEAR_PIPOE                      _PEAR.Bits.PIPOE
#define PEAR_NOACCE                     _PEAR.Bits.NOACCE

#define PEAR_RDWE_MASK                  4U
#define PEAR_LSTRE_MASK                 8U
#define PEAR_NECLK_MASK                 16U
#define PEAR_PIPOE_MASK                 32U
#define PEAR_NOACCE_MASK                128U


/*** MODE - Mode Register; 0x0000000B ***/
typedef union {
  byte Byte;
  struct {
    byte EME         :1;                                       /* Emulate Port E */
    byte EMK         :1;                                       /* Emulate Port K */
    byte             :1; 
    byte IVIS        :1;                                       /* Internal Visibility */
    byte             :1; 
    byte MODA        :1;                                       /* Mode Select Bit A */
    byte MODB        :1;                                       /* Mode Select Bit B */
    byte MODC        :1;                                       /* Mode Select Bit C */
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte grpMODx :3;
  } MergedBits;
} MODESTR;
extern volatile MODESTR _MODE @(REG_BASE + 0x0000000BUL);
#define MODE                            _MODE.Byte
#define MODE_EME                        _MODE.Bits.EME
#define MODE_EMK                        _MODE.Bits.EMK
#define MODE_IVIS                       _MODE.Bits.IVIS
#define MODE_MODA                       _MODE.Bits.MODA
#define MODE_MODB                       _MODE.Bits.MODB
#define MODE_MODC                       _MODE.Bits.MODC
#define MODE_MODx                       _MODE.MergedBits.grpMODx

#define MODE_EME_MASK                   1U
#define MODE_EMK_MASK                   2U
#define MODE_IVIS_MASK                  8U
#define MODE_MODA_MASK                  32U
#define MODE_MODB_MASK                  64U
#define MODE_MODC_MASK                  128U
#define MODE_MODx_MASK                  224U
#define MODE_MODx_BITNUM                5U


/*** PUCR - Pull-Up Control Register; 0x0000000C ***/
typedef union {
  byte Byte;
  struct {
    byte PUPAE       :1;                                       /* Pull-Up Port A Enable */
    byte PUPBE       :1;                                       /* Pull-Up Port B Enable */
    byte             :1; 
    byte             :1; 
    byte PUPEE       :1;                                       /* Pull-Up Port E Enable */
    byte             :1; 
    byte             :1; 
    byte PUPKE       :1;                                       /* Pull-Up Port K Enable */
  } Bits;
} PUCRSTR;
extern volatile PUCRSTR _PUCR @(REG_BASE + 0x0000000CUL);
#define PUCR                            _PUCR.Byte
#define PUCR_PUPAE                      _PUCR.Bits.PUPAE
#define PUCR_PUPBE                      _PUCR.Bits.PUPBE
#define PUCR_PUPEE                      _PUCR.Bits.PUPEE
#define PUCR_PUPKE                      _PUCR.Bits.PUPKE

#define PUCR_PUPAE_MASK                 1U
#define PUCR_PUPBE_MASK                 2U
#define PUCR_PUPEE_MASK                 16U
#define PUCR_PUPKE_MASK                 128U


/*** RDRIV - Reduced Drive of I/O Lines; 0x0000000D ***/
typedef union {
  byte Byte;
  struct {
    byte RDPA        :1;                                       /* Reduced Drive of Port A */
    byte RDPB        :1;                                       /* Reduced Drive of Port B */
    byte             :1; 
    byte             :1; 
    byte RDPE        :1;                                       /* Reduced Drive of Port E */
    byte             :1; 
    byte             :1; 
    byte RDPK        :1;                                       /* Reduced Drive of Port K */
  } Bits;
  struct {
    byte grpRDPx :2;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} RDRIVSTR;
extern volatile RDRIVSTR _RDRIV @(REG_BASE + 0x0000000DUL);
#define RDRIV                           _RDRIV.Byte
#define RDRIV_RDPA                      _RDRIV.Bits.RDPA
#define RDRIV_RDPB                      _RDRIV.Bits.RDPB
#define RDRIV_RDPE                      _RDRIV.Bits.RDPE
#define RDRIV_RDPK                      _RDRIV.Bits.RDPK
#define RDRIV_RDPx                      _RDRIV.MergedBits.grpRDPx

#define RDRIV_RDPA_MASK                 1U
#define RDRIV_RDPB_MASK                 2U
#define RDRIV_RDPE_MASK                 16U
#define RDRIV_RDPK_MASK                 128U
#define RDRIV_RDPx_MASK                 3U
#define RDRIV_RDPx_BITNUM               0U


/*** EBICTL - External Bus Interface Control; 0x0000000E ***/
typedef union {
  byte Byte;
  struct {
    byte ESTR        :1;                                       /* E Stretches */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} EBICTLSTR;
extern volatile EBICTLSTR _EBICTL @(REG_BASE + 0x0000000EUL);
#define EBICTL                          _EBICTL.Byte
#define EBICTL_ESTR                     _EBICTL.Bits.ESTR

#define EBICTL_ESTR_MASK                1U


/*** INITRM - Initialization of Internal RAM Position Register; 0x00000010 ***/
typedef union {
  byte Byte;
  struct {
    byte RAMHAL      :1;                                       /* Internal RAM map alignment */
    byte             :1; 
    byte             :1; 
    byte RAM11       :1;                                       /* Internal RAM Map Position Bit 11 */
    byte RAM12       :1;                                       /* Internal RAM Map Position Bit 12 */
    byte RAM13       :1;                                       /* Internal RAM Map Position Bit 13 */
    byte RAM14       :1;                                       /* Internal RAM Map Position Bit 14 */
    byte RAM15       :1;                                       /* Internal RAM Map Position Bit 15 */
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte         :1;
    byte grpRAM_11 :5;
  } MergedBits;
} INITRMSTR;
extern volatile INITRMSTR _INITRM @(REG_BASE + 0x00000010UL);
#define INITRM                          _INITRM.Byte
#define INITRM_RAMHAL                   _INITRM.Bits.RAMHAL
#define INITRM_RAM11                    _INITRM.Bits.RAM11
#define INITRM_RAM12                    _INITRM.Bits.RAM12
#define INITRM_RAM13                    _INITRM.Bits.RAM13
#define INITRM_RAM14                    _INITRM.Bits.RAM14
#define INITRM_RAM15                    _INITRM.Bits.RAM15
#define INITRM_RAM_11                   _INITRM.MergedBits.grpRAM_11
#define INITRM_RAM                      INITRM_RAM_11

#define INITRM_RAMHAL_MASK              1U
#define INITRM_RAM11_MASK               8U
#define INITRM_RAM12_MASK               16U
#define INITRM_RAM13_MASK               32U
#define INITRM_RAM14_MASK               64U
#define INITRM_RAM15_MASK               128U
#define INITRM_RAM_11_MASK              248U
#define INITRM_RAM_11_BITNUM            3U


/*** INITRG - Initialization of Internal Registers Position Register; 0x00000011 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte REG11       :1;                                       /* Internal Registers Map Position  Bit 11 */
    byte REG12       :1;                                       /* Internal Registers Map Position Bit 12 */
    byte REG13       :1;                                       /* Internal Registers Map Position Bit 13 */
    byte REG14       :1;                                       /* Internal Registers Map Position Bit 14 */
    byte             :1; 
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte         :1;
    byte grpREG_11 :4;
    byte         :1;
  } MergedBits;
} INITRGSTR;
extern volatile INITRGSTR _INITRG @(REG_BASE + 0x00000011UL);
#define INITRG                          _INITRG.Byte
#define INITRG_REG11                    _INITRG.Bits.REG11
#define INITRG_REG12                    _INITRG.Bits.REG12
#define INITRG_REG13                    _INITRG.Bits.REG13
#define INITRG_REG14                    _INITRG.Bits.REG14
#define INITRG_REG_11                   _INITRG.MergedBits.grpREG_11
#define INITRG_REG                      INITRG_REG_11

#define INITRG_REG11_MASK               8U
#define INITRG_REG12_MASK               16U
#define INITRG_REG13_MASK               32U
#define INITRG_REG14_MASK               64U
#define INITRG_REG_11_MASK              120U
#define INITRG_REG_11_BITNUM            3U


/*** INITEE - Initialization of Internal EEPROM Position Register; 0x00000012 ***/
typedef union {
  byte Byte;
  struct {
    byte EEON        :1;                                       /* Enable EEPROM */
    byte             :1; 
    byte             :1; 
    byte EE11        :1;                                       /* Internal EEPROM map position Bit 0 */
    byte EE12        :1;                                       /* Internal EEPROM map position Bit 1 */
    byte EE13        :1;                                       /* Internal EEPROM map position Bit 2 */
    byte EE14        :1;                                       /* Internal EEPROM map position Bit 3 */
    byte EE15        :1;                                       /* Internal EEPROM map position Bit 4 */
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte         :1;
    byte grpEE_11 :5;
  } MergedBits;
} INITEESTR;
extern volatile INITEESTR _INITEE @(REG_BASE + 0x00000012UL);
#define INITEE                          _INITEE.Byte
#define INITEE_EEON                     _INITEE.Bits.EEON
#define INITEE_EE11                     _INITEE.Bits.EE11
#define INITEE_EE12                     _INITEE.Bits.EE12
#define INITEE_EE13                     _INITEE.Bits.EE13
#define INITEE_EE14                     _INITEE.Bits.EE14
#define INITEE_EE15                     _INITEE.Bits.EE15
#define INITEE_EE_11                    _INITEE.MergedBits.grpEE_11
#define INITEE_EE                       INITEE_EE_11

#define INITEE_EEON_MASK                1U
#define INITEE_EE11_MASK                8U
#define INITEE_EE12_MASK                16U
#define INITEE_EE13_MASK                32U
#define INITEE_EE14_MASK                64U
#define INITEE_EE15_MASK                128U
#define INITEE_EE_11_MASK               248U
#define INITEE_EE_11_BITNUM             3U


/*** MISC - Miscellaneous System Control Register; 0x00000013 ***/
typedef union {
  byte Byte;
  struct {
    byte ROMON       :1;                                       /* Enable Flash EEPROM or ROM */
    byte ROMHM       :1;                                       /* Flash EEPROM or ROM only in second half of memory map */
    byte EXSTR0      :1;                                       /* External Access Stretch Bit 0 */
    byte EXSTR1      :1;                                       /* External Access Stretch Bit 1 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte grpEXSTR :2;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} MISCSTR;
extern volatile MISCSTR _MISC @(REG_BASE + 0x00000013UL);
#define MISC                            _MISC.Byte
#define MISC_ROMON                      _MISC.Bits.ROMON
#define MISC_ROMHM                      _MISC.Bits.ROMHM
#define MISC_EXSTR0                     _MISC.Bits.EXSTR0
#define MISC_EXSTR1                     _MISC.Bits.EXSTR1
#define MISC_EXSTR                      _MISC.MergedBits.grpEXSTR

#define MISC_ROMON_MASK                 1U
#define MISC_ROMHM_MASK                 2U
#define MISC_EXSTR0_MASK                4U
#define MISC_EXSTR1_MASK                8U
#define MISC_EXSTR_MASK                 12U
#define MISC_EXSTR_BITNUM               2U


/*** ITCR - Interrupt Test Control Register; 0x00000015 ***/
typedef union {
  byte Byte;
  struct {
    byte ADR0        :1;                                       /* Test register select bit 0 */
    byte ADR1        :1;                                       /* Test register select bit 1 */
    byte ADR2        :1;                                       /* Test register select bit 2 */
    byte ADR3        :1;                                       /* Test register select bit 3 */
    byte WRTINT      :1;                                       /* Write to the Interrupt Test Registers */
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpADR  :4;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} ITCRSTR;
extern volatile ITCRSTR _ITCR @(REG_BASE + 0x00000015UL);
#define ITCR                            _ITCR.Byte
#define ITCR_ADR0                       _ITCR.Bits.ADR0
#define ITCR_ADR1                       _ITCR.Bits.ADR1
#define ITCR_ADR2                       _ITCR.Bits.ADR2
#define ITCR_ADR3                       _ITCR.Bits.ADR3
#define ITCR_WRTINT                     _ITCR.Bits.WRTINT
#define ITCR_ADR                        _ITCR.MergedBits.grpADR

#define ITCR_ADR0_MASK                  1U
#define ITCR_ADR1_MASK                  2U
#define ITCR_ADR2_MASK                  4U
#define ITCR_ADR3_MASK                  8U
#define ITCR_WRTINT_MASK                16U
#define ITCR_ADR_MASK                   15U
#define ITCR_ADR_BITNUM                 0U


/*** ITEST - Interrupt Test Register; 0x00000016 ***/
typedef union {
  byte Byte;
  struct {
    byte INT0        :1;                                       /* Interrupt TEST bit 0 */
    byte INT2        :1;                                       /* Interrupt TEST bit 2 */
    byte INT4        :1;                                       /* Interrupt TEST bit 4 */
    byte INT6        :1;                                       /* Interrupt TEST bit 6 */
    byte INT8        :1;                                       /* Interrupt TEST bit 8 */
    byte INTA        :1;                                       /* Interrupt TEST bit A */
    byte INTC        :1;                                       /* Interrupt TEST bit C */
    byte INTE        :1;                                       /* Interrupt TEST bit E */
  } Bits;
} ITESTSTR;
extern volatile ITESTSTR _ITEST @(REG_BASE + 0x00000016UL);
#define ITEST                           _ITEST.Byte
#define ITEST_INT0                      _ITEST.Bits.INT0
#define ITEST_INT2                      _ITEST.Bits.INT2
#define ITEST_INT4                      _ITEST.Bits.INT4
#define ITEST_INT6                      _ITEST.Bits.INT6
#define ITEST_INT8                      _ITEST.Bits.INT8
#define ITEST_INTA                      _ITEST.Bits.INTA
#define ITEST_INTC                      _ITEST.Bits.INTC
#define ITEST_INTE                      _ITEST.Bits.INTE

#define ITEST_INT0_MASK                 1U
#define ITEST_INT2_MASK                 2U
#define ITEST_INT4_MASK                 4U
#define ITEST_INT6_MASK                 8U
#define ITEST_INT8_MASK                 16U
#define ITEST_INTA_MASK                 32U
#define ITEST_INTC_MASK                 64U
#define ITEST_INTE_MASK                 128U


/*** VREGCTRL - VREG_U Module Control Register; 0x00000019 ***/
typedef union {
  byte Byte;
  struct {
    byte DATA        :1;                                       /* REF3V output data */
    byte EXTEN       :1;                                       /* External NMOS Power Channel Enable */
    byte BURNEN      :1;                                       /* Burn-in Mode Enable */
    byte LEVEL       :1;                                       /* Voltage Level in Burn-in Mode */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} VREGCTRLSTR;
extern volatile VREGCTRLSTR _VREGCTRL @(REG_BASE + 0x00000019UL);
#define VREGCTRL                        _VREGCTRL.Byte
#define VREGCTRL_DATA                   _VREGCTRL.Bits.DATA
#define VREGCTRL_EXTEN                  _VREGCTRL.Bits.EXTEN
#define VREGCTRL_BURNEN                 _VREGCTRL.Bits.BURNEN
#define VREGCTRL_LEVEL                  _VREGCTRL.Bits.LEVEL

#define VREGCTRL_DATA_MASK              1U
#define VREGCTRL_EXTEN_MASK             2U
#define VREGCTRL_BURNEN_MASK            4U
#define VREGCTRL_LEVEL_MASK             8U


/*** PARTID - Part ID Register; 0x0000001A ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** PARTIDH - High Register of Part ID; 0x0000001A ***/
    union {
      byte Byte;
      struct {
        byte ID8         :1;                                       /* Part ID high byte Bit 8 */
        byte ID9         :1;                                       /* Part ID high byte Bit 9 */
        byte ID10        :1;                                       /* Part ID high byte Bit 10 */
        byte ID11        :1;                                       /* Part ID high byte Bit 11 */
        byte ID12        :1;                                       /* Part ID high byte Bit 12 */
        byte ID13        :1;                                       /* Part ID high byte Bit 13 */
        byte ID14        :1;                                       /* Part ID high byte Bit 14 */
        byte ID15        :1;                                       /* Part ID high byte Bit 15 */
      } Bits;
    } PARTIDHSTR;
    #define PARTIDH                     _PARTID.Overlap_STR.PARTIDHSTR.Byte
    #define PARTIDH_ID8                 _PARTID.Overlap_STR.PARTIDHSTR.Bits.ID8
    #define PARTIDH_ID9                 _PARTID.Overlap_STR.PARTIDHSTR.Bits.ID9
    #define PARTIDH_ID10                _PARTID.Overlap_STR.PARTIDHSTR.Bits.ID10
    #define PARTIDH_ID11                _PARTID.Overlap_STR.PARTIDHSTR.Bits.ID11
    #define PARTIDH_ID12                _PARTID.Overlap_STR.PARTIDHSTR.Bits.ID12
    #define PARTIDH_ID13                _PARTID.Overlap_STR.PARTIDHSTR.Bits.ID13
    #define PARTIDH_ID14                _PARTID.Overlap_STR.PARTIDHSTR.Bits.ID14
    #define PARTIDH_ID15                _PARTID.Overlap_STR.PARTIDHSTR.Bits.ID15
    
    #define PARTIDH_ID8_MASK            1U
    #define PARTIDH_ID9_MASK            2U
    #define PARTIDH_ID10_MASK           4U
    #define PARTIDH_ID11_MASK           8U
    #define PARTIDH_ID12_MASK           16U
    #define PARTIDH_ID13_MASK           32U
    #define PARTIDH_ID14_MASK           64U
    #define PARTIDH_ID15_MASK           128U
    

    /*** PARTIDL - Low Register of Part ID; 0x0000001B ***/
    union {
      byte Byte;
      struct {
        byte ID0         :1;                                       /* Part ID low byte Bit0 */
        byte ID1         :1;                                       /* Part ID low byte Bit 1 */
        byte ID2         :1;                                       /* Part ID low byte Bit 2 */
        byte ID3         :1;                                       /* Part ID low byte Bit 3 */
        byte ID4         :1;                                       /* Part ID low byte Bit 4 */
        byte ID5         :1;                                       /* Part ID low byte Bit 5 */
        byte ID6         :1;                                       /* Part ID low byte Bit 6 */
        byte ID7         :1;                                       /* Part ID low byte Bit 7 */
      } Bits;
    } PARTIDLSTR;
    #define PARTIDL                     _PARTID.Overlap_STR.PARTIDLSTR.Byte
    #define PARTIDL_ID0                 _PARTID.Overlap_STR.PARTIDLSTR.Bits.ID0
    #define PARTIDL_ID1                 _PARTID.Overlap_STR.PARTIDLSTR.Bits.ID1
    #define PARTIDL_ID2                 _PARTID.Overlap_STR.PARTIDLSTR.Bits.ID2
    #define PARTIDL_ID3                 _PARTID.Overlap_STR.PARTIDLSTR.Bits.ID3
    #define PARTIDL_ID4                 _PARTID.Overlap_STR.PARTIDLSTR.Bits.ID4
    #define PARTIDL_ID5                 _PARTID.Overlap_STR.PARTIDLSTR.Bits.ID5
    #define PARTIDL_ID6                 _PARTID.Overlap_STR.PARTIDLSTR.Bits.ID6
    #define PARTIDL_ID7                 _PARTID.Overlap_STR.PARTIDLSTR.Bits.ID7
    
    #define PARTIDL_ID0_MASK            1U
    #define PARTIDL_ID1_MASK            2U
    #define PARTIDL_ID2_MASK            4U
    #define PARTIDL_ID3_MASK            8U
    #define PARTIDL_ID4_MASK            16U
    #define PARTIDL_ID5_MASK            32U
    #define PARTIDL_ID6_MASK            64U
    #define PARTIDL_ID7_MASK            128U
    
  } Overlap_STR;

  struct {
    word ID0         :1;                                       /* Part ID Register Bit 0 */
    word ID1         :1;                                       /* Part ID Register Bit 1 */
    word ID2         :1;                                       /* Part ID Register Bit 2 */
    word ID3         :1;                                       /* Part ID Register Bit 3 */
    word ID4         :1;                                       /* Part ID Register Bit 4 */
    word ID5         :1;                                       /* Part ID Register Bit 5 */
    word ID6         :1;                                       /* Part ID Register Bit 6 */
    word ID7         :1;                                       /* Part ID Register Bit 7 */
    word ID8         :1;                                       /* Part ID Register Bit 8 */
    word ID9         :1;                                       /* Part ID Register Bit 9 */
    word ID10        :1;                                       /* Part ID Register Bit 10 */
    word ID11        :1;                                       /* Part ID Register Bit 11 */
    word ID12        :1;                                       /* Part ID Register Bit 12 */
    word ID13        :1;                                       /* Part ID Register Bit 13 */
    word ID14        :1;                                       /* Part ID Register Bit 14 */
    word ID15        :1;                                       /* Part ID Register Bit 15 */
  } Bits;
} PARTIDSTR;
extern volatile PARTIDSTR _PARTID @(REG_BASE + 0x0000001AUL);
#define PARTID                          _PARTID.Word
#define PARTID_ID0                      _PARTID.Bits.ID0
#define PARTID_ID1                      _PARTID.Bits.ID1
#define PARTID_ID2                      _PARTID.Bits.ID2
#define PARTID_ID3                      _PARTID.Bits.ID3
#define PARTID_ID4                      _PARTID.Bits.ID4
#define PARTID_ID5                      _PARTID.Bits.ID5
#define PARTID_ID6                      _PARTID.Bits.ID6
#define PARTID_ID7                      _PARTID.Bits.ID7
#define PARTID_ID8                      _PARTID.Bits.ID8
#define PARTID_ID9                      _PARTID.Bits.ID9
#define PARTID_ID10                     _PARTID.Bits.ID10
#define PARTID_ID11                     _PARTID.Bits.ID11
#define PARTID_ID12                     _PARTID.Bits.ID12
#define PARTID_ID13                     _PARTID.Bits.ID13
#define PARTID_ID14                     _PARTID.Bits.ID14
#define PARTID_ID15                     _PARTID.Bits.ID15

#define PARTID_ID0_MASK                 1U
#define PARTID_ID1_MASK                 2U
#define PARTID_ID2_MASK                 4U
#define PARTID_ID3_MASK                 8U
#define PARTID_ID4_MASK                 16U
#define PARTID_ID5_MASK                 32U
#define PARTID_ID6_MASK                 64U
#define PARTID_ID7_MASK                 128U
#define PARTID_ID8_MASK                 256U
#define PARTID_ID9_MASK                 512U
#define PARTID_ID10_MASK                1024U
#define PARTID_ID11_MASK                2048U
#define PARTID_ID12_MASK                4096U
#define PARTID_ID13_MASK                8192U
#define PARTID_ID14_MASK                16384U
#define PARTID_ID15_MASK                32768U


/*** MEMSIZ0 - Memory Size Register Zero; 0x0000001C ***/
typedef union {
  byte Byte;
  struct {
    byte ram_sw0     :1;                                       /* Allocated System RAM Memory Space Bit 0 */
    byte ram_sw1     :1;                                       /* Allocated System RAM Memory Space Bit 1 */
    byte ram_sw2     :1;                                       /* Allocated System RAM Memory Space Bit 2 */
    byte             :1; 
    byte eep_sw0     :1;                                       /* Allocated System EEPROM Memory Space Bit 0 */
    byte eep_sw1     :1;                                       /* Allocated System EEPROM Memory Space Bit 1 */
    byte             :1; 
    byte reg_sw0     :1;                                       /* Allocated System Register Space */
  } Bits;
  struct {
    byte grpram_sw :3;
    byte         :1;
    byte grpeep_sw :2;
    byte         :1;
    byte grpreg_sw :1;
  } MergedBits;
} MEMSIZ0STR;
extern volatile MEMSIZ0STR _MEMSIZ0 @(REG_BASE + 0x0000001CUL);
#define MEMSIZ0                         _MEMSIZ0.Byte
#define MEMSIZ0_ram_sw0                 _MEMSIZ0.Bits.ram_sw0
#define MEMSIZ0_ram_sw1                 _MEMSIZ0.Bits.ram_sw1
#define MEMSIZ0_ram_sw2                 _MEMSIZ0.Bits.ram_sw2
#define MEMSIZ0_eep_sw0                 _MEMSIZ0.Bits.eep_sw0
#define MEMSIZ0_eep_sw1                 _MEMSIZ0.Bits.eep_sw1
#define MEMSIZ0_reg_sw0                 _MEMSIZ0.Bits.reg_sw0
/* MEMSIZ_ARR: Access 2 MEMSIZx registers in an array */
#define MEMSIZ_ARR                      ((volatile byte *) &MEMSIZ0)
#define MEMSIZ0_ram_sw                  _MEMSIZ0.MergedBits.grpram_sw
#define MEMSIZ0_eep_sw                  _MEMSIZ0.MergedBits.grpeep_sw

#define MEMSIZ0_ram_sw0_MASK            1U
#define MEMSIZ0_ram_sw1_MASK            2U
#define MEMSIZ0_ram_sw2_MASK            4U
#define MEMSIZ0_eep_sw0_MASK            16U
#define MEMSIZ0_eep_sw1_MASK            32U
#define MEMSIZ0_reg_sw0_MASK            128U
#define MEMSIZ0_ram_sw_MASK             7U
#define MEMSIZ0_ram_sw_BITNUM           0U
#define MEMSIZ0_eep_sw_MASK             48U
#define MEMSIZ0_eep_sw_BITNUM           4U


/*** MEMSIZ1 - Memory Size Register One; 0x0000001D ***/
typedef union {
  byte Byte;
  struct {
    byte pag_sw0     :1;                                       /* Allocated Off-Chip Memory Options Bit 0 */
    byte pag_sw1     :1;                                       /* Allocated Off-Chip Memory Options Bit 1 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte rom_sw0     :1;                                       /* Allocated System Flash EEPROM or ROM Physical Memory Space Bit 0 */
    byte rom_sw1     :1;                                       /* Allocated System Flash EEPROM or ROM Physical Memory Space Bit 1 */
  } Bits;
  struct {
    byte grppag_sw :2;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte grprom_sw :2;
  } MergedBits;
} MEMSIZ1STR;
extern volatile MEMSIZ1STR _MEMSIZ1 @(REG_BASE + 0x0000001DUL);
#define MEMSIZ1                         _MEMSIZ1.Byte
#define MEMSIZ1_pag_sw0                 _MEMSIZ1.Bits.pag_sw0
#define MEMSIZ1_pag_sw1                 _MEMSIZ1.Bits.pag_sw1
#define MEMSIZ1_rom_sw0                 _MEMSIZ1.Bits.rom_sw0
#define MEMSIZ1_rom_sw1                 _MEMSIZ1.Bits.rom_sw1
#define MEMSIZ1_pag_sw                  _MEMSIZ1.MergedBits.grppag_sw
#define MEMSIZ1_rom_sw                  _MEMSIZ1.MergedBits.grprom_sw

#define MEMSIZ1_pag_sw0_MASK            1U
#define MEMSIZ1_pag_sw1_MASK            2U
#define MEMSIZ1_rom_sw0_MASK            64U
#define MEMSIZ1_rom_sw1_MASK            128U
#define MEMSIZ1_pag_sw_MASK             3U
#define MEMSIZ1_pag_sw_BITNUM           0U
#define MEMSIZ1_rom_sw_MASK             192U
#define MEMSIZ1_rom_sw_BITNUM           6U


/*** INTCR - Interrupt Control Register; 0x0000001E ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte IRQEN       :1;                                       /* External IRQ Enable */
    byte IRQE        :1;                                       /* IRQ Select Edge Sensitive Only */
  } Bits;
} INTCRSTR;
extern volatile INTCRSTR _INTCR @(REG_BASE + 0x0000001EUL);
#define INTCR                           _INTCR.Byte
#define INTCR_IRQEN                     _INTCR.Bits.IRQEN
#define INTCR_IRQE                      _INTCR.Bits.IRQE

#define INTCR_IRQEN_MASK                64U
#define INTCR_IRQE_MASK                 128U


/*** HPRIO - Highest Priority I Interrupt; 0x0000001F ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte PSEL1       :1;                                       /* Highest priority I interrupt select bit 1 */
    byte PSEL2       :1;                                       /* Highest priority I interrupt select bit 2 */
    byte PSEL3       :1;                                       /* Highest priority I interrupt select bit 3 */
    byte PSEL4       :1;                                       /* Highest priority I interrupt select bit 4 */
    byte PSEL5       :1;                                       /* Highest priority I interrupt select bit 5 */
    byte PSEL6       :1;                                       /* Highest priority I interrupt select bit 6 */
    byte PSEL7       :1;                                       /* Highest priority I interrupt select bit 7 */
  } Bits;
  struct {
    byte         :1;
    byte grpPSEL_1 :7;
  } MergedBits;
} HPRIOSTR;
extern volatile HPRIOSTR _HPRIO @(REG_BASE + 0x0000001FUL);
#define HPRIO                           _HPRIO.Byte
#define HPRIO_PSEL1                     _HPRIO.Bits.PSEL1
#define HPRIO_PSEL2                     _HPRIO.Bits.PSEL2
#define HPRIO_PSEL3                     _HPRIO.Bits.PSEL3
#define HPRIO_PSEL4                     _HPRIO.Bits.PSEL4
#define HPRIO_PSEL5                     _HPRIO.Bits.PSEL5
#define HPRIO_PSEL6                     _HPRIO.Bits.PSEL6
#define HPRIO_PSEL7                     _HPRIO.Bits.PSEL7
#define HPRIO_PSEL_1                    _HPRIO.MergedBits.grpPSEL_1
#define HPRIO_PSEL                      HPRIO_PSEL_1

#define HPRIO_PSEL1_MASK                2U
#define HPRIO_PSEL2_MASK                4U
#define HPRIO_PSEL3_MASK                8U
#define HPRIO_PSEL4_MASK                16U
#define HPRIO_PSEL5_MASK                32U
#define HPRIO_PSEL6_MASK                64U
#define HPRIO_PSEL7_MASK                128U
#define HPRIO_PSEL_1_MASK               254U
#define HPRIO_PSEL_1_BITNUM             1U


/*** BKPCT0 - Breakpoint Control Register 0; 0x00000028 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte BKTAG       :1;                                       /* Breakpoint on Tag */
    byte BKBDM       :1;                                       /* Breakpoint Background Debug Mode Enable */
    byte BKFULL      :1;                                       /* Full Breakpoint Mode Enable */
    byte BKEN        :1;                                       /* Breakpoint Enable */
  } Bits;
} BKPCT0STR;
extern volatile BKPCT0STR _BKPCT0 @(REG_BASE + 0x00000028UL);
#define BKPCT0                          _BKPCT0.Byte
#define BKPCT0_BKTAG                    _BKPCT0.Bits.BKTAG
#define BKPCT0_BKBDM                    _BKPCT0.Bits.BKBDM
#define BKPCT0_BKFULL                   _BKPCT0.Bits.BKFULL
#define BKPCT0_BKEN                     _BKPCT0.Bits.BKEN
/* BKPCT_ARR: Access 2 BKPCTx registers in an array */
#define BKPCT_ARR                       ((volatile byte *) &BKPCT0)

#define BKPCT0_BKTAG_MASK               16U
#define BKPCT0_BKBDM_MASK               32U
#define BKPCT0_BKFULL_MASK              64U
#define BKPCT0_BKEN_MASK                128U


/*** BKPCT1 - Breakpoint Control Register 1; 0x00000029 ***/
typedef union {
  byte Byte;
  struct {
    byte BK1RW       :1;                                       /* R/W Compare Value of second address */
    byte BK1RWE      :1;                                       /* R/W Compare Enable of second address */
    byte BK0RW       :1;                                       /* R/W Compare Value of First Address */
    byte BK0RWE      :1;                                       /* R/W Compare Enable of First Address */
    byte BK1MBL      :1;                                       /* Breakpoint Mask Low Byte of Data (Second Address) */
    byte BK1MBH      :1;                                       /* Breakpoint Mask High Byte of Data (Second Address) */
    byte BK0MBL      :1;                                       /* Breakpoint Mask Low Byte for First Address */
    byte BK0MBH      :1;                                       /* Breakpoint Mask High Byte for First Address */
  } Bits;
} BKPCT1STR;
extern volatile BKPCT1STR _BKPCT1 @(REG_BASE + 0x00000029UL);
#define BKPCT1                          _BKPCT1.Byte
#define BKPCT1_BK1RW                    _BKPCT1.Bits.BK1RW
#define BKPCT1_BK1RWE                   _BKPCT1.Bits.BK1RWE
#define BKPCT1_BK0RW                    _BKPCT1.Bits.BK0RW
#define BKPCT1_BK0RWE                   _BKPCT1.Bits.BK0RWE
#define BKPCT1_BK1MBL                   _BKPCT1.Bits.BK1MBL
#define BKPCT1_BK1MBH                   _BKPCT1.Bits.BK1MBH
#define BKPCT1_BK0MBL                   _BKPCT1.Bits.BK0MBL
#define BKPCT1_BK0MBH                   _BKPCT1.Bits.BK0MBH

#define BKPCT1_BK1RW_MASK               1U
#define BKPCT1_BK1RWE_MASK              2U
#define BKPCT1_BK0RW_MASK               4U
#define BKPCT1_BK0RWE_MASK              8U
#define BKPCT1_BK1MBL_MASK              16U
#define BKPCT1_BK1MBH_MASK              32U
#define BKPCT1_BK0MBL_MASK              64U
#define BKPCT1_BK0MBH_MASK              128U


/*** BKP0X - Breakpoint First Address Expansion Register; 0x0000002A ***/
typedef union {
  byte Byte;
  struct {
    byte BK0V0       :1;                                       /* Value of first breakpoint address to be matched in memory expansion space Bit 0 */
    byte BK0V1       :1;                                       /* Value of first breakpoint address to be matched in memory expansion space Bit 1 */
    byte BK0V2       :1;                                       /* Value of first breakpoint address to be matched in memory expansion space Bit 2 */
    byte BK0V3       :1;                                       /* Value of first breakpoint address to be matched in memory expansion space Bit 3 */
    byte BK0V4       :1;                                       /* Value of first breakpoint address to be matched in memory expansion space Bit 4 */
    byte BK0V5       :1;                                       /* Value of first breakpoint address to be matched in memory expansion space Bit 5 */
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpBK0V :6;
    byte         :1;
    byte         :1;
  } MergedBits;
} BKP0XSTR;
extern volatile BKP0XSTR _BKP0X @(REG_BASE + 0x0000002AUL);
#define BKP0X                           _BKP0X.Byte
#define BKP0X_BK0V0                     _BKP0X.Bits.BK0V0
#define BKP0X_BK0V1                     _BKP0X.Bits.BK0V1
#define BKP0X_BK0V2                     _BKP0X.Bits.BK0V2
#define BKP0X_BK0V3                     _BKP0X.Bits.BK0V3
#define BKP0X_BK0V4                     _BKP0X.Bits.BK0V4
#define BKP0X_BK0V5                     _BKP0X.Bits.BK0V5
#define BKP0X_BK0V                      _BKP0X.MergedBits.grpBK0V

#define BKP0X_BK0V0_MASK                1U
#define BKP0X_BK0V1_MASK                2U
#define BKP0X_BK0V2_MASK                4U
#define BKP0X_BK0V3_MASK                8U
#define BKP0X_BK0V4_MASK                16U
#define BKP0X_BK0V5_MASK                32U
#define BKP0X_BK0V_MASK                 63U
#define BKP0X_BK0V_BITNUM               0U


/*** BKP0H - Breakpoint First Address High Byte Register; 0x0000002B ***/
typedef union {
  byte Byte;
  struct {
    byte BIT0        :1;                                       /* Breakpoint address high byte Bit 0 */
    byte BIT1        :1;                                       /* Breakpoint address high byte Bit 1 */
    byte BIT2        :1;                                       /* Breakpoint address high byte Bit 2 */
    byte BIT3        :1;                                       /* Breakpoint address high byte Bit 3 */
    byte BIT4        :1;                                       /* Breakpoint address high byte Bit 4 */
    byte BIT5        :1;                                       /* Breakpoint address high byte Bit 5 */
    byte BIT6        :1;                                       /* Breakpoint address high byte Bit 6 */
    byte BIT7        :1;                                       /* Breakpoint address high byte Bit 7 */
  } Bits;
} BKP0HSTR;
extern volatile BKP0HSTR _BKP0H @(REG_BASE + 0x0000002BUL);
#define BKP0H                           _BKP0H.Byte
#define BKP0H_BIT0                      _BKP0H.Bits.BIT0
#define BKP0H_BIT1                      _BKP0H.Bits.BIT1
#define BKP0H_BIT2                      _BKP0H.Bits.BIT2
#define BKP0H_BIT3                      _BKP0H.Bits.BIT3
#define BKP0H_BIT4                      _BKP0H.Bits.BIT4
#define BKP0H_BIT5                      _BKP0H.Bits.BIT5
#define BKP0H_BIT6                      _BKP0H.Bits.BIT6
#define BKP0H_BIT7                      _BKP0H.Bits.BIT7

#define BKP0H_BIT0_MASK                 1U
#define BKP0H_BIT1_MASK                 2U
#define BKP0H_BIT2_MASK                 4U
#define BKP0H_BIT3_MASK                 8U
#define BKP0H_BIT4_MASK                 16U
#define BKP0H_BIT5_MASK                 32U
#define BKP0H_BIT6_MASK                 64U
#define BKP0H_BIT7_MASK                 128U


/*** BKP0L - Breakpoint First Address Low Byte Register; 0x0000002C ***/
typedef union {
  byte Byte;
  struct {
    byte BIT0        :1;                                       /* Breakpoint address low byte Bit 0 */
    byte BIT1        :1;                                       /* Breakpoint address low byte Bit 1 */
    byte BIT2        :1;                                       /* Breakpoint address low byte Bit 2 */
    byte BIT3        :1;                                       /* Breakpoint address low byte Bit 3 */
    byte BIT4        :1;                                       /* Breakpoint address low byte Bit 4 */
    byte BIT5        :1;                                       /* Breakpoint address low byte Bit 5 */
    byte BIT6        :1;                                       /* Breakpoint address low byte Bit 6 */
    byte BIT7        :1;                                       /* Breakpoint address low byte Bit 7 */
  } Bits;
} BKP0LSTR;
extern volatile BKP0LSTR _BKP0L @(REG_BASE + 0x0000002CUL);
#define BKP0L                           _BKP0L.Byte
#define BKP0L_BIT0                      _BKP0L.Bits.BIT0
#define BKP0L_BIT1                      _BKP0L.Bits.BIT1
#define BKP0L_BIT2                      _BKP0L.Bits.BIT2
#define BKP0L_BIT3                      _BKP0L.Bits.BIT3
#define BKP0L_BIT4                      _BKP0L.Bits.BIT4
#define BKP0L_BIT5                      _BKP0L.Bits.BIT5
#define BKP0L_BIT6                      _BKP0L.Bits.BIT6
#define BKP0L_BIT7                      _BKP0L.Bits.BIT7

#define BKP0L_BIT0_MASK                 1U
#define BKP0L_BIT1_MASK                 2U
#define BKP0L_BIT2_MASK                 4U
#define BKP0L_BIT3_MASK                 8U
#define BKP0L_BIT4_MASK                 16U
#define BKP0L_BIT5_MASK                 32U
#define BKP0L_BIT6_MASK                 64U
#define BKP0L_BIT7_MASK                 128U


/*** BKP1X - Breakpoint Second Address Expansion Register; 0x0000002D ***/
typedef union {
  byte Byte;
  struct {
    byte BK1V0       :1;                                       /* Value of first breakpoint address to be matched in memory expansion space Bit 0 */
    byte BK1V1       :1;                                       /* Value of first breakpoint address to be matched in memory expansion space Bit 1 */
    byte BK1V2       :1;                                       /* Value of first breakpoint address to be matched in memory expansion space Bit 2 */
    byte BK1V3       :1;                                       /* Value of first breakpoint address to be matched in memory expansion space Bit 3 */
    byte BK1V4       :1;                                       /* Value of first breakpoint address to be matched in memory expansion space Bit 4 */
    byte BK1V5       :1;                                       /* Value of first breakpoint address to be matched in memory expansion space Bit 5 */
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpBK1V :6;
    byte         :1;
    byte         :1;
  } MergedBits;
} BKP1XSTR;
extern volatile BKP1XSTR _BKP1X @(REG_BASE + 0x0000002DUL);
#define BKP1X                           _BKP1X.Byte
#define BKP1X_BK1V0                     _BKP1X.Bits.BK1V0
#define BKP1X_BK1V1                     _BKP1X.Bits.BK1V1
#define BKP1X_BK1V2                     _BKP1X.Bits.BK1V2
#define BKP1X_BK1V3                     _BKP1X.Bits.BK1V3
#define BKP1X_BK1V4                     _BKP1X.Bits.BK1V4
#define BKP1X_BK1V5                     _BKP1X.Bits.BK1V5
#define BKP1X_BK1V                      _BKP1X.MergedBits.grpBK1V

#define BKP1X_BK1V0_MASK                1U
#define BKP1X_BK1V1_MASK                2U
#define BKP1X_BK1V2_MASK                4U
#define BKP1X_BK1V3_MASK                8U
#define BKP1X_BK1V4_MASK                16U
#define BKP1X_BK1V5_MASK                32U
#define BKP1X_BK1V_MASK                 63U
#define BKP1X_BK1V_BITNUM               0U


/*** BKP1H - Breakpoint Data (Second Address) High Byte Register; 0x0000002E ***/
typedef union {
  byte Byte;
  struct {
    byte BIT8        :1;                                       /* Breakpoint data (second address) high byte Bit 8 */
    byte BIT9        :1;                                       /* Breakpoint data (second address) high byte Bit 9 */
    byte BIT10       :1;                                       /* Breakpoint data (second address) high byte Bit 10 */
    byte BIT11       :1;                                       /* Breakpoint data (second address) high byte Bit 11 */
    byte BIT12       :1;                                       /* Breakpoint data (second address) high byte Bit 12 */
    byte BIT13       :1;                                       /* Breakpoint data (second address) high byte Bit 13 */
    byte BIT14       :1;                                       /* Breakpoint data (second address) high byte Bit 14 */
    byte BIT15       :1;                                       /* Breakpoint data (second address) high byte Bit 15 */
  } Bits;
} BKP1HSTR;
extern volatile BKP1HSTR _BKP1H @(REG_BASE + 0x0000002EUL);
#define BKP1H                           _BKP1H.Byte
#define BKP1H_BIT8                      _BKP1H.Bits.BIT8
#define BKP1H_BIT9                      _BKP1H.Bits.BIT9
#define BKP1H_BIT10                     _BKP1H.Bits.BIT10
#define BKP1H_BIT11                     _BKP1H.Bits.BIT11
#define BKP1H_BIT12                     _BKP1H.Bits.BIT12
#define BKP1H_BIT13                     _BKP1H.Bits.BIT13
#define BKP1H_BIT14                     _BKP1H.Bits.BIT14
#define BKP1H_BIT15                     _BKP1H.Bits.BIT15

#define BKP1H_BIT8_MASK                 1U
#define BKP1H_BIT9_MASK                 2U
#define BKP1H_BIT10_MASK                4U
#define BKP1H_BIT11_MASK                8U
#define BKP1H_BIT12_MASK                16U
#define BKP1H_BIT13_MASK                32U
#define BKP1H_BIT14_MASK                64U
#define BKP1H_BIT15_MASK                128U


/*** BKP1L - Breakpoint Data (Second Address) Low Byte Register; 0x0000002F ***/
typedef union {
  byte Byte;
  struct {
    byte BIT0        :1;                                       /* Breakpoint data (second address) low byte Bit 0 */
    byte BIT1        :1;                                       /* Breakpoint data (second address) low byte Bit 1 */
    byte BIT2        :1;                                       /* Breakpoint data (second address) low byte Bit 2 */
    byte BIT3        :1;                                       /* Breakpoint data (second address) low byte Bit 3 */
    byte BIT4        :1;                                       /* Breakpoint data (second address) low byte Bit 4 */
    byte BIT5        :1;                                       /* Breakpoint data (second address) low byte Bit 5 */
    byte BIT6        :1;                                       /* Breakpoint data (second address) low byte Bit 6 */
    byte BIT7        :1;                                       /* Breakpoint data (second address) low byte Bit 7 */
  } Bits;
} BKP1LSTR;
extern volatile BKP1LSTR _BKP1L @(REG_BASE + 0x0000002FUL);
#define BKP1L                           _BKP1L.Byte
#define BKP1L_BIT0                      _BKP1L.Bits.BIT0
#define BKP1L_BIT1                      _BKP1L.Bits.BIT1
#define BKP1L_BIT2                      _BKP1L.Bits.BIT2
#define BKP1L_BIT3                      _BKP1L.Bits.BIT3
#define BKP1L_BIT4                      _BKP1L.Bits.BIT4
#define BKP1L_BIT5                      _BKP1L.Bits.BIT5
#define BKP1L_BIT6                      _BKP1L.Bits.BIT6
#define BKP1L_BIT7                      _BKP1L.Bits.BIT7

#define BKP1L_BIT0_MASK                 1U
#define BKP1L_BIT1_MASK                 2U
#define BKP1L_BIT2_MASK                 4U
#define BKP1L_BIT3_MASK                 8U
#define BKP1L_BIT4_MASK                 16U
#define BKP1L_BIT5_MASK                 32U
#define BKP1L_BIT6_MASK                 64U
#define BKP1L_BIT7_MASK                 128U


/*** PPAGE - Program Page Index Register; 0x00000030 ***/
typedef union {
  byte Byte;
  struct {
    byte PIX0        :1;                                       /* Program Page Index Bit 0 */
    byte PIX1        :1;                                       /* Program Page Index Bit 1 */
    byte PIX2        :1;                                       /* Program Page Index Bit 2 */
    byte PIX3        :1;                                       /* Program Page Index Bit 3 */
    byte PIX4        :1;                                       /* Program Page Index Bit 4 */
    byte PIX5        :1;                                       /* Program Page Index Bit 5 */
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpPIX  :6;
    byte         :1;
    byte         :1;
  } MergedBits;
} PPAGESTR;
extern volatile PPAGESTR _PPAGE @(REG_BASE + 0x00000030UL);
#define PPAGE                           _PPAGE.Byte
#define PPAGE_PIX0                      _PPAGE.Bits.PIX0
#define PPAGE_PIX1                      _PPAGE.Bits.PIX1
#define PPAGE_PIX2                      _PPAGE.Bits.PIX2
#define PPAGE_PIX3                      _PPAGE.Bits.PIX3
#define PPAGE_PIX4                      _PPAGE.Bits.PIX4
#define PPAGE_PIX5                      _PPAGE.Bits.PIX5
#define PPAGE_PIX                       _PPAGE.MergedBits.grpPIX

#define PPAGE_PIX0_MASK                 1U
#define PPAGE_PIX1_MASK                 2U
#define PPAGE_PIX2_MASK                 4U
#define PPAGE_PIX3_MASK                 8U
#define PPAGE_PIX4_MASK                 16U
#define PPAGE_PIX5_MASK                 32U
#define PPAGE_PIX_MASK                  63U
#define PPAGE_PIX_BITNUM                0U


/*** REFDV - CRG Reference Divider Register; 0x00000035 ***/
typedef union {
  byte Byte;
  struct {
    byte REFDV0      :1;                                       /* CRG Reference Divider Bit 0 */
    byte REFDV1      :1;                                       /* CRG Reference Divider Bit 1 */
    byte REFDV2      :1;                                       /* CRG Reference Divider Bit 2 */
    byte REFDV3      :1;                                       /* CRG Reference Divider Bit 3 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpREFDV :4;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} REFDVSTR;
extern volatile REFDVSTR _REFDV @(REG_BASE + 0x00000035UL);
#define REFDV                           _REFDV.Byte
#define REFDV_REFDV0                    _REFDV.Bits.REFDV0
#define REFDV_REFDV1                    _REFDV.Bits.REFDV1
#define REFDV_REFDV2                    _REFDV.Bits.REFDV2
#define REFDV_REFDV3                    _REFDV.Bits.REFDV3
#define REFDV_REFDV                     _REFDV.MergedBits.grpREFDV

#define REFDV_REFDV0_MASK               1U
#define REFDV_REFDV1_MASK               2U
#define REFDV_REFDV2_MASK               4U
#define REFDV_REFDV3_MASK               8U
#define REFDV_REFDV_MASK                15U
#define REFDV_REFDV_BITNUM              0U


/*** CRGFLG - CRG Flags Register; 0x00000037 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte LOCK        :1;                                       /* Lock Status */
    byte LOCKIF      :1;                                       /* PLL Lock Interrupt Flag */
    byte             :1; 
    byte PORF        :1;                                       /* Power on Reset Flag */
    byte RTIF        :1;                                       /* Real Time Interrupt Flag */
  } Bits;
} CRGFLGSTR;
extern volatile CRGFLGSTR _CRGFLG @(REG_BASE + 0x00000037UL);
#define CRGFLG                          _CRGFLG.Byte
#define CRGFLG_LOCK                     _CRGFLG.Bits.LOCK
#define CRGFLG_LOCKIF                   _CRGFLG.Bits.LOCKIF
#define CRGFLG_PORF                     _CRGFLG.Bits.PORF
#define CRGFLG_RTIF                     _CRGFLG.Bits.RTIF

#define CRGFLG_LOCK_MASK                8U
#define CRGFLG_LOCKIF_MASK              16U
#define CRGFLG_PORF_MASK                64U
#define CRGFLG_RTIF_MASK                128U


/*** CRGINT - CRG Interrupt Enable Register; 0x00000038 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte LOCKIE      :1;                                       /* Lock Interrupt Enable */
    byte             :1; 
    byte             :1; 
    byte RTIE        :1;                                       /* Real Time Interrupt Enable */
  } Bits;
} CRGINTSTR;
extern volatile CRGINTSTR _CRGINT @(REG_BASE + 0x00000038UL);
#define CRGINT                          _CRGINT.Byte
#define CRGINT_LOCKIE                   _CRGINT.Bits.LOCKIE
#define CRGINT_RTIE                     _CRGINT.Bits.RTIE

#define CRGINT_LOCKIE_MASK              16U
#define CRGINT_RTIE_MASK                128U


/*** CLKSEL - CRG Clock Select Register; 0x00000039 ***/
typedef union {
  byte Byte;
  struct {
    byte COPWAI      :1;                                       /* COP stops in WAIT mode */
    byte RTIWAI      :1;                                       /* RTI stops in WAIT mode */
    byte CWAI        :1;                                       /* CLK24 and CLK23 stop in WAIT mode */
    byte             :1; 
    byte ROAWAI      :1;                                       /* Reduced Oscillator Amplitude in WAIT mode */
    byte SYSWAI      :1;                                       /* System clocks stop in WAIT mode */
    byte             :1; 
    byte PLLSEL      :1;                                       /* PLL selected for system clock */
  } Bits;
} CLKSELSTR;
extern volatile CLKSELSTR _CLKSEL @(REG_BASE + 0x00000039UL);
#define CLKSEL                          _CLKSEL.Byte
#define CLKSEL_COPWAI                   _CLKSEL.Bits.COPWAI
#define CLKSEL_RTIWAI                   _CLKSEL.Bits.RTIWAI
#define CLKSEL_CWAI                     _CLKSEL.Bits.CWAI
#define CLKSEL_ROAWAI                   _CLKSEL.Bits.ROAWAI
#define CLKSEL_SYSWAI                   _CLKSEL.Bits.SYSWAI
#define CLKSEL_PLLSEL                   _CLKSEL.Bits.PLLSEL

#define CLKSEL_COPWAI_MASK              1U
#define CLKSEL_RTIWAI_MASK              2U
#define CLKSEL_CWAI_MASK                4U
#define CLKSEL_ROAWAI_MASK              16U
#define CLKSEL_SYSWAI_MASK              32U
#define CLKSEL_PLLSEL_MASK              128U


/*** RTICTL - CRG RTI Control Register; 0x0000003B ***/
typedef union {
  byte Byte;
  struct {
    byte RTR0        :1;                                       /* Real Time Interrupt Modulus Counter Select Bit 0 */
    byte RTR1        :1;                                       /* Real Time Interrupt Modulus Counter Select Bit 1 */
    byte RTR2        :1;                                       /* Real Time Interrupt Modulus Counter Select Bit 2 */
    byte RTR3        :1;                                       /* Real Time Interrupt Modulus Counter Select Bit 3 */
    byte RTR4        :1;                                       /* Real Time Interrupt Prescale Rate Select Bit 0 */
    byte RTR5        :1;                                       /* Real Time Interrupt Prescale Rate Select Bit 1 */
    byte RTR6        :1;                                       /* Real Time Interrupt Prescale Rate Select Bit 2 */
    byte             :1; 
  } Bits;
  struct {
    byte grpRTR  :7;
    byte         :1;
  } MergedBits;
} RTICTLSTR;
extern volatile RTICTLSTR _RTICTL @(REG_BASE + 0x0000003BUL);
#define RTICTL                          _RTICTL.Byte
#define RTICTL_RTR0                     _RTICTL.Bits.RTR0
#define RTICTL_RTR1                     _RTICTL.Bits.RTR1
#define RTICTL_RTR2                     _RTICTL.Bits.RTR2
#define RTICTL_RTR3                     _RTICTL.Bits.RTR3
#define RTICTL_RTR4                     _RTICTL.Bits.RTR4
#define RTICTL_RTR5                     _RTICTL.Bits.RTR5
#define RTICTL_RTR6                     _RTICTL.Bits.RTR6
#define RTICTL_RTR                      _RTICTL.MergedBits.grpRTR

#define RTICTL_RTR0_MASK                1U
#define RTICTL_RTR1_MASK                2U
#define RTICTL_RTR2_MASK                4U
#define RTICTL_RTR3_MASK                8U
#define RTICTL_RTR4_MASK                16U
#define RTICTL_RTR5_MASK                32U
#define RTICTL_RTR6_MASK                64U
#define RTICTL_RTR_MASK                 127U
#define RTICTL_RTR_BITNUM               0U


/*** COPCTL - CRG COP Control Register; 0x0000003C ***/
typedef union {
  byte Byte;
  struct {
    byte CR0         :1;                                       /* COP Watchdog Timer Rate select Bit 0 */
    byte CR1         :1;                                       /* COP Watchdog Timer Rate select Bit 1 */
    byte CR2         :1;                                       /* COP Watchdog Timer Rate select Bit 2 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte RSBCK       :1;                                       /* COP and RTI stop in Active BDM mode Bit */
    byte WCOP        :1;                                       /* Window COP mode */
  } Bits;
  struct {
    byte grpCR   :3;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} COPCTLSTR;
extern volatile COPCTLSTR _COPCTL @(REG_BASE + 0x0000003CUL);
#define COPCTL                          _COPCTL.Byte
#define COPCTL_CR0                      _COPCTL.Bits.CR0
#define COPCTL_CR1                      _COPCTL.Bits.CR1
#define COPCTL_CR2                      _COPCTL.Bits.CR2
#define COPCTL_RSBCK                    _COPCTL.Bits.RSBCK
#define COPCTL_WCOP                     _COPCTL.Bits.WCOP
#define COPCTL_CR                       _COPCTL.MergedBits.grpCR

#define COPCTL_CR0_MASK                 1U
#define COPCTL_CR1_MASK                 2U
#define COPCTL_CR2_MASK                 4U
#define COPCTL_RSBCK_MASK               64U
#define COPCTL_WCOP_MASK                128U
#define COPCTL_CR_MASK                  7U
#define COPCTL_CR_BITNUM                0U


/*** ARMCOP - CRG COP Timer Arm/Reset Register; 0x0000003F ***/
typedef union {
  byte Byte;
} ARMCOPSTR;
extern volatile ARMCOPSTR _ARMCOP @(REG_BASE + 0x0000003FUL);
#define ARMCOP                          _ARMCOP.Byte


/*** TIOS - Timer Input Capture/Output Compare Select; 0x00000040 ***/
typedef union {
  byte Byte;
  struct {
    byte IOS0        :1;                                       /* Input Capture or Output Compare Channel Configuration Bit 0 */
    byte IOS1        :1;                                       /* Input Capture or Output Compare Channel Configuration Bit 1 */
    byte IOS2        :1;                                       /* Input Capture or Output Compare Channel Configuration Bit 2 */
    byte IOS3        :1;                                       /* Input Capture or Output Compare Channel Configuration Bit 3 */
    byte IOS4        :1;                                       /* Input Capture or Output Compare Channel Configuration Bit 4 */
    byte IOS5        :1;                                       /* Input Capture or Output Compare Channel Configuration Bit 5 */
    byte IOS6        :1;                                       /* Input Capture or Output Compare Channel Configuration Bit 6 */
    byte IOS7        :1;                                       /* Input Capture or Output Compare Channel Configuration Bit 7 */
  } Bits;
} TIOSSTR;
extern volatile TIOSSTR _TIOS @(REG_BASE + 0x00000040UL);
#define TIOS                            _TIOS.Byte
#define TIOS_IOS0                       _TIOS.Bits.IOS0
#define TIOS_IOS1                       _TIOS.Bits.IOS1
#define TIOS_IOS2                       _TIOS.Bits.IOS2
#define TIOS_IOS3                       _TIOS.Bits.IOS3
#define TIOS_IOS4                       _TIOS.Bits.IOS4
#define TIOS_IOS5                       _TIOS.Bits.IOS5
#define TIOS_IOS6                       _TIOS.Bits.IOS6
#define TIOS_IOS7                       _TIOS.Bits.IOS7

#define TIOS_IOS0_MASK                  1U
#define TIOS_IOS1_MASK                  2U
#define TIOS_IOS2_MASK                  4U
#define TIOS_IOS3_MASK                  8U
#define TIOS_IOS4_MASK                  16U
#define TIOS_IOS5_MASK                  32U
#define TIOS_IOS6_MASK                  64U
#define TIOS_IOS7_MASK                  128U


/*** CFORC - Timer Compare Force Register; 0x00000041 ***/
typedef union {
  byte Byte;
  struct {
    byte FOC0        :1;                                       /* Force Output Compare Action for Channel 0 */
    byte FOC1        :1;                                       /* Force Output Compare Action for Channel 1 */
    byte FOC2        :1;                                       /* Force Output Compare Action for Channel 2 */
    byte FOC3        :1;                                       /* Force Output Compare Action for Channel 3 */
    byte FOC4        :1;                                       /* Force Output Compare Action for Channel 4 */
    byte FOC5        :1;                                       /* Force Output Compare Action for Channel 5 */
    byte FOC6        :1;                                       /* Force Output Compare Action for Channel 6 */
    byte FOC7        :1;                                       /* Force Output Compare Action for Channel 7 */
  } Bits;
} CFORCSTR;
extern volatile CFORCSTR _CFORC @(REG_BASE + 0x00000041UL);
#define CFORC                           _CFORC.Byte
#define CFORC_FOC0                      _CFORC.Bits.FOC0
#define CFORC_FOC1                      _CFORC.Bits.FOC1
#define CFORC_FOC2                      _CFORC.Bits.FOC2
#define CFORC_FOC3                      _CFORC.Bits.FOC3
#define CFORC_FOC4                      _CFORC.Bits.FOC4
#define CFORC_FOC5                      _CFORC.Bits.FOC5
#define CFORC_FOC6                      _CFORC.Bits.FOC6
#define CFORC_FOC7                      _CFORC.Bits.FOC7

#define CFORC_FOC0_MASK                 1U
#define CFORC_FOC1_MASK                 2U
#define CFORC_FOC2_MASK                 4U
#define CFORC_FOC3_MASK                 8U
#define CFORC_FOC4_MASK                 16U
#define CFORC_FOC5_MASK                 32U
#define CFORC_FOC6_MASK                 64U
#define CFORC_FOC7_MASK                 128U


/*** OC7M - Output Compare 7 Mask Register; 0x00000042 ***/
typedef union {
  byte Byte;
  struct {
    byte OC7M0       :1;                                       /* Output Compare 7 Mask Bit 0 */
    byte OC7M1       :1;                                       /* Output Compare 7 Mask Bit 1 */
    byte OC7M2       :1;                                       /* Output Compare 7 Mask Bit 2 */
    byte OC7M3       :1;                                       /* Output Compare 7 Mask Bit 3 */
    byte OC7M4       :1;                                       /* Output Compare 7 Mask Bit 4 */
    byte OC7M5       :1;                                       /* Output Compare 7 Mask Bit 5 */
    byte OC7M6       :1;                                       /* Output Compare 7 Mask Bit 6 */
    byte OC7M7       :1;                                       /* Output Compare 7 Mask Bit 7 */
  } Bits;
} OC7MSTR;
extern volatile OC7MSTR _OC7M @(REG_BASE + 0x00000042UL);
#define OC7M                            _OC7M.Byte
#define OC7M_OC7M0                      _OC7M.Bits.OC7M0
#define OC7M_OC7M1                      _OC7M.Bits.OC7M1
#define OC7M_OC7M2                      _OC7M.Bits.OC7M2
#define OC7M_OC7M3                      _OC7M.Bits.OC7M3
#define OC7M_OC7M4                      _OC7M.Bits.OC7M4
#define OC7M_OC7M5                      _OC7M.Bits.OC7M5
#define OC7M_OC7M6                      _OC7M.Bits.OC7M6
#define OC7M_OC7M7                      _OC7M.Bits.OC7M7

#define OC7M_OC7M0_MASK                 1U
#define OC7M_OC7M1_MASK                 2U
#define OC7M_OC7M2_MASK                 4U
#define OC7M_OC7M3_MASK                 8U
#define OC7M_OC7M4_MASK                 16U
#define OC7M_OC7M5_MASK                 32U
#define OC7M_OC7M6_MASK                 64U
#define OC7M_OC7M7_MASK                 128U


/*** OC7D - Output Compare 7 Data Register; 0x00000043 ***/
typedef union {
  byte Byte;
  struct {
    byte OC7D0       :1;                                       /* Output Compare 7 Bit 0 */
    byte OC7D1       :1;                                       /* Output Compare 7 Bit 1 */
    byte OC7D2       :1;                                       /* Output Compare 7 Bit 2 */
    byte OC7D3       :1;                                       /* Output Compare 7 Bit 3 */
    byte OC7D4       :1;                                       /* Output Compare 7 Bit 4 */
    byte OC7D5       :1;                                       /* Output Compare 7 Bit 5 */
    byte OC7D6       :1;                                       /* Output Compare 7 Bit 6 */
    byte OC7D7       :1;                                       /* Output Compare 7 Bit 7 */
  } Bits;
} OC7DSTR;
extern volatile OC7DSTR _OC7D @(REG_BASE + 0x00000043UL);
#define OC7D                            _OC7D.Byte
#define OC7D_OC7D0                      _OC7D.Bits.OC7D0
#define OC7D_OC7D1                      _OC7D.Bits.OC7D1
#define OC7D_OC7D2                      _OC7D.Bits.OC7D2
#define OC7D_OC7D3                      _OC7D.Bits.OC7D3
#define OC7D_OC7D4                      _OC7D.Bits.OC7D4
#define OC7D_OC7D5                      _OC7D.Bits.OC7D5
#define OC7D_OC7D6                      _OC7D.Bits.OC7D6
#define OC7D_OC7D7                      _OC7D.Bits.OC7D7

#define OC7D_OC7D0_MASK                 1U
#define OC7D_OC7D1_MASK                 2U
#define OC7D_OC7D2_MASK                 4U
#define OC7D_OC7D3_MASK                 8U
#define OC7D_OC7D4_MASK                 16U
#define OC7D_OC7D5_MASK                 32U
#define OC7D_OC7D6_MASK                 64U
#define OC7D_OC7D7_MASK                 128U


/*** TCNT - Timer Count Register; 0x00000044 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** TCNTHi - Timer Count Register High; 0x00000044 ***/
    union {
      byte Byte;
    } TCNTHiSTR;
    #define TCNTHi                      _TCNT.Overlap_STR.TCNTHiSTR.Byte
    

    /*** TCNTLo - Timer Count Register Low; 0x00000045 ***/
    union {
      byte Byte;
    } TCNTLoSTR;
    #define TCNTLo                      _TCNT.Overlap_STR.TCNTLoSTR.Byte
    
  } Overlap_STR;

} TCNTSTR;
extern volatile TCNTSTR _TCNT @(REG_BASE + 0x00000044UL);
#define TCNT                            _TCNT.Word


/*** TSCR1 - Timer System Control Register1; 0x00000046 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte TFFCA       :1;                                       /* Timer Fast Flag Clear All */
    byte TSFRZ       :1;                                       /* Timer and Modulus Counter Stop While in Freeze Mode */
    byte TSWAI       :1;                                       /* Timer Module Stops While in Wait */
    byte TEN         :1;                                       /* Timer Enable */
  } Bits;
} TSCR1STR;
extern volatile TSCR1STR _TSCR1 @(REG_BASE + 0x00000046UL);
#define TSCR1                           _TSCR1.Byte
#define TSCR1_TFFCA                     _TSCR1.Bits.TFFCA
#define TSCR1_TSFRZ                     _TSCR1.Bits.TSFRZ
#define TSCR1_TSWAI                     _TSCR1.Bits.TSWAI
#define TSCR1_TEN                       _TSCR1.Bits.TEN

#define TSCR1_TFFCA_MASK                16U
#define TSCR1_TSFRZ_MASK                32U
#define TSCR1_TSWAI_MASK                64U
#define TSCR1_TEN_MASK                  128U


/*** TTOV - Timer Toggle On Overflow Register; 0x00000047 ***/
typedef union {
  byte Byte;
  struct {
    byte TOV0        :1;                                       /* Toggle On Overflow Bit 0 */
    byte TOV1        :1;                                       /* Toggle On Overflow Bit 1 */
    byte TOV2        :1;                                       /* Toggle On Overflow Bit 2 */
    byte TOV3        :1;                                       /* Toggle On Overflow Bit 3 */
    byte TOV4        :1;                                       /* Toggle On Overflow Bit 4 */
    byte TOV5        :1;                                       /* Toggle On Overflow Bit 5 */
    byte TOV6        :1;                                       /* Toggle On Overflow Bit 6 */
    byte TOV7        :1;                                       /* Toggle On Overflow Bit 7 */
  } Bits;
} TTOVSTR;
extern volatile TTOVSTR _TTOV @(REG_BASE + 0x00000047UL);
#define TTOV                            _TTOV.Byte
#define TTOV_TOV0                       _TTOV.Bits.TOV0
#define TTOV_TOV1                       _TTOV.Bits.TOV1
#define TTOV_TOV2                       _TTOV.Bits.TOV2
#define TTOV_TOV3                       _TTOV.Bits.TOV3
#define TTOV_TOV4                       _TTOV.Bits.TOV4
#define TTOV_TOV5                       _TTOV.Bits.TOV5
#define TTOV_TOV6                       _TTOV.Bits.TOV6
#define TTOV_TOV7                       _TTOV.Bits.TOV7

#define TTOV_TOV0_MASK                  1U
#define TTOV_TOV1_MASK                  2U
#define TTOV_TOV2_MASK                  4U
#define TTOV_TOV3_MASK                  8U
#define TTOV_TOV4_MASK                  16U
#define TTOV_TOV5_MASK                  32U
#define TTOV_TOV6_MASK                  64U
#define TTOV_TOV7_MASK                  128U


/*** TCTL1 - Timer Control Register 1; 0x00000048 ***/
typedef union {
  byte Byte;
  struct {
    byte OL4         :1;                                       /* Output Level Bit 4 */
    byte OM4         :1;                                       /* Output Mode Bit 4 */
    byte OL5         :1;                                       /* Output Level Bit 5 */
    byte OM5         :1;                                       /* Output Mode Bit 5 */
    byte OL6         :1;                                       /* Output Level Bit 6 */
    byte OM6         :1;                                       /* Output Mode Bit 6 */
    byte OL7         :1;                                       /* Output Level Bit 7 */
    byte OM7         :1;                                       /* Output Mode Bit 7 */
  } Bits;
} TCTL1STR;
extern volatile TCTL1STR _TCTL1 @(REG_BASE + 0x00000048UL);
#define TCTL1                           _TCTL1.Byte
#define TCTL1_OL4                       _TCTL1.Bits.OL4
#define TCTL1_OM4                       _TCTL1.Bits.OM4
#define TCTL1_OL5                       _TCTL1.Bits.OL5
#define TCTL1_OM5                       _TCTL1.Bits.OM5
#define TCTL1_OL6                       _TCTL1.Bits.OL6
#define TCTL1_OM6                       _TCTL1.Bits.OM6
#define TCTL1_OL7                       _TCTL1.Bits.OL7
#define TCTL1_OM7                       _TCTL1.Bits.OM7

#define TCTL1_OL4_MASK                  1U
#define TCTL1_OM4_MASK                  2U
#define TCTL1_OL5_MASK                  4U
#define TCTL1_OM5_MASK                  8U
#define TCTL1_OL6_MASK                  16U
#define TCTL1_OM6_MASK                  32U
#define TCTL1_OL7_MASK                  64U
#define TCTL1_OM7_MASK                  128U


/*** TCTL2 - Timer Control Register 2; 0x00000049 ***/
typedef union {
  byte Byte;
  struct {
    byte OL0         :1;                                       /* Output Level Bit 0 */
    byte OM0         :1;                                       /* Output Mode Bit 0 */
    byte OL1         :1;                                       /* Output Level Bit 1 */
    byte OM1         :1;                                       /* Output Mode Bit 1 */
    byte OL2         :1;                                       /* Output Level Bit 2 */
    byte OM2         :1;                                       /* Output Mode Bit 2 */
    byte OL3         :1;                                       /* Output Level Bit 3 */
    byte OM3         :1;                                       /* Output Mode Bit 3 */
  } Bits;
} TCTL2STR;
extern volatile TCTL2STR _TCTL2 @(REG_BASE + 0x00000049UL);
#define TCTL2                           _TCTL2.Byte
#define TCTL2_OL0                       _TCTL2.Bits.OL0
#define TCTL2_OM0                       _TCTL2.Bits.OM0
#define TCTL2_OL1                       _TCTL2.Bits.OL1
#define TCTL2_OM1                       _TCTL2.Bits.OM1
#define TCTL2_OL2                       _TCTL2.Bits.OL2
#define TCTL2_OM2                       _TCTL2.Bits.OM2
#define TCTL2_OL3                       _TCTL2.Bits.OL3
#define TCTL2_OM3                       _TCTL2.Bits.OM3

#define TCTL2_OL0_MASK                  1U
#define TCTL2_OM0_MASK                  2U
#define TCTL2_OL1_MASK                  4U
#define TCTL2_OM1_MASK                  8U
#define TCTL2_OL2_MASK                  16U
#define TCTL2_OM2_MASK                  32U
#define TCTL2_OL3_MASK                  64U
#define TCTL2_OM3_MASK                  128U


/*** TCTL3 - Timer Control Register 3; 0x0000004A ***/
typedef union {
  byte Byte;
  struct {
    byte EDG4A       :1;                                       /* Input Capture Edge Control 4A */
    byte EDG4B       :1;                                       /* Input Capture Edge Control 4B */
    byte EDG5A       :1;                                       /* Input Capture Edge Control 5A */
    byte EDG5B       :1;                                       /* Input Capture Edge Control 5B */
    byte EDG6A       :1;                                       /* Input Capture Edge Control 6A */
    byte EDG6B       :1;                                       /* Input Capture Edge Control 6B */
    byte EDG7A       :1;                                       /* Input Capture Edge Control 7A */
    byte EDG7B       :1;                                       /* Input Capture Edge Control 7B */
  } Bits;
  struct {
    byte grpEDG4x :2;
    byte grpEDG5x :2;
    byte grpEDG6x :2;
    byte grpEDG7x :2;
  } MergedBits;
} TCTL3STR;
extern volatile TCTL3STR _TCTL3 @(REG_BASE + 0x0000004AUL);
#define TCTL3                           _TCTL3.Byte
#define TCTL3_EDG4A                     _TCTL3.Bits.EDG4A
#define TCTL3_EDG4B                     _TCTL3.Bits.EDG4B
#define TCTL3_EDG5A                     _TCTL3.Bits.EDG5A
#define TCTL3_EDG5B                     _TCTL3.Bits.EDG5B
#define TCTL3_EDG6A                     _TCTL3.Bits.EDG6A
#define TCTL3_EDG6B                     _TCTL3.Bits.EDG6B
#define TCTL3_EDG7A                     _TCTL3.Bits.EDG7A
#define TCTL3_EDG7B                     _TCTL3.Bits.EDG7B
#define TCTL3_EDG4x                     _TCTL3.MergedBits.grpEDG4x
#define TCTL3_EDG5x                     _TCTL3.MergedBits.grpEDG5x
#define TCTL3_EDG6x                     _TCTL3.MergedBits.grpEDG6x
#define TCTL3_EDG7x                     _TCTL3.MergedBits.grpEDG7x

#define TCTL3_EDG4A_MASK                1U
#define TCTL3_EDG4B_MASK                2U
#define TCTL3_EDG5A_MASK                4U
#define TCTL3_EDG5B_MASK                8U
#define TCTL3_EDG6A_MASK                16U
#define TCTL3_EDG6B_MASK                32U
#define TCTL3_EDG7A_MASK                64U
#define TCTL3_EDG7B_MASK                128U
#define TCTL3_EDG4x_MASK                3U
#define TCTL3_EDG4x_BITNUM              0U
#define TCTL3_EDG5x_MASK                12U
#define TCTL3_EDG5x_BITNUM              2U
#define TCTL3_EDG6x_MASK                48U
#define TCTL3_EDG6x_BITNUM              4U
#define TCTL3_EDG7x_MASK                192U
#define TCTL3_EDG7x_BITNUM              6U


/*** TCTL4 - Timer Control Register 4; 0x0000004B ***/
typedef union {
  byte Byte;
  struct {
    byte EDG0A       :1;                                       /* Input Capture Edge Control 0A */
    byte EDG0B       :1;                                       /* Input Capture Edge Control 0B */
    byte EDG1A       :1;                                       /* Input Capture Edge Control 1A */
    byte EDG1B       :1;                                       /* Input Capture Edge Control 1B */
    byte EDG2A       :1;                                       /* Input Capture Edge Control 2A */
    byte EDG2B       :1;                                       /* Input Capture Edge Control 2B */
    byte EDG3A       :1;                                       /* Input Capture Edge Control 3A */
    byte EDG3B       :1;                                       /* Input Capture Edge Control 3B */
  } Bits;
  struct {
    byte grpEDG0x :2;
    byte grpEDG1x :2;
    byte grpEDG2x :2;
    byte grpEDG3x :2;
  } MergedBits;
} TCTL4STR;
extern volatile TCTL4STR _TCTL4 @(REG_BASE + 0x0000004BUL);
#define TCTL4                           _TCTL4.Byte
#define TCTL4_EDG0A                     _TCTL4.Bits.EDG0A
#define TCTL4_EDG0B                     _TCTL4.Bits.EDG0B
#define TCTL4_EDG1A                     _TCTL4.Bits.EDG1A
#define TCTL4_EDG1B                     _TCTL4.Bits.EDG1B
#define TCTL4_EDG2A                     _TCTL4.Bits.EDG2A
#define TCTL4_EDG2B                     _TCTL4.Bits.EDG2B
#define TCTL4_EDG3A                     _TCTL4.Bits.EDG3A
#define TCTL4_EDG3B                     _TCTL4.Bits.EDG3B
#define TCTL4_EDG0x                     _TCTL4.MergedBits.grpEDG0x
#define TCTL4_EDG1x                     _TCTL4.MergedBits.grpEDG1x
#define TCTL4_EDG2x                     _TCTL4.MergedBits.grpEDG2x
#define TCTL4_EDG3x                     _TCTL4.MergedBits.grpEDG3x

#define TCTL4_EDG0A_MASK                1U
#define TCTL4_EDG0B_MASK                2U
#define TCTL4_EDG1A_MASK                4U
#define TCTL4_EDG1B_MASK                8U
#define TCTL4_EDG2A_MASK                16U
#define TCTL4_EDG2B_MASK                32U
#define TCTL4_EDG3A_MASK                64U
#define TCTL4_EDG3B_MASK                128U
#define TCTL4_EDG0x_MASK                3U
#define TCTL4_EDG0x_BITNUM              0U
#define TCTL4_EDG1x_MASK                12U
#define TCTL4_EDG1x_BITNUM              2U
#define TCTL4_EDG2x_MASK                48U
#define TCTL4_EDG2x_BITNUM              4U
#define TCTL4_EDG3x_MASK                192U
#define TCTL4_EDG3x_BITNUM              6U


/*** TIE - Timer Interrupt Enable Register; 0x0000004C ***/
typedef union {
  byte Byte;
  struct {
    byte C0I         :1;                                       /* Input Capture/Output Compare Interrupt Enable Bit 0 */
    byte C1I         :1;                                       /* Input Capture/Output Compare Interrupt Enable Bit 1 */
    byte C2I         :1;                                       /* Input Capture/Output Compare Interrupt Enable Bit 2 */
    byte C3I         :1;                                       /* Input Capture/Output Compare Interrupt Enable Bit 3 */
    byte C4I         :1;                                       /* Input Capture/Output Compare Interrupt Enable Bit 4 */
    byte C5I         :1;                                       /* Input Capture/Output Compare Interrupt Enable Bit 5 */
    byte C6I         :1;                                       /* Input Capture/Output Compare Interrupt Enable Bit 6 */
    byte C7I         :1;                                       /* Input Capture/Output Compare Interrupt Enable Bit 7 */
  } Bits;
} TIESTR;
extern volatile TIESTR _TIE @(REG_BASE + 0x0000004CUL);
#define TIE                             _TIE.Byte
#define TIE_C0I                         _TIE.Bits.C0I
#define TIE_C1I                         _TIE.Bits.C1I
#define TIE_C2I                         _TIE.Bits.C2I
#define TIE_C3I                         _TIE.Bits.C3I
#define TIE_C4I                         _TIE.Bits.C4I
#define TIE_C5I                         _TIE.Bits.C5I
#define TIE_C6I                         _TIE.Bits.C6I
#define TIE_C7I                         _TIE.Bits.C7I

#define TIE_C0I_MASK                    1U
#define TIE_C1I_MASK                    2U
#define TIE_C2I_MASK                    4U
#define TIE_C3I_MASK                    8U
#define TIE_C4I_MASK                    16U
#define TIE_C5I_MASK                    32U
#define TIE_C6I_MASK                    64U
#define TIE_C7I_MASK                    128U


/*** TSCR2 - Timer System Control Register 2; 0x0000004D ***/
typedef union {
  byte Byte;
  struct {
    byte PR0         :1;                                       /* Timer Prescaler Select Bit 0 */
    byte PR1         :1;                                       /* Timer Prescaler Select Bit 1 */
    byte PR2         :1;                                       /* Timer Prescaler Select Bit 2 */
    byte TCRE        :1;                                       /* Timer Counter Reset Enable */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte TOI         :1;                                       /* Timer Overflow Interrupt Enable */
  } Bits;
  struct {
    byte grpPR   :3;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} TSCR2STR;
extern volatile TSCR2STR _TSCR2 @(REG_BASE + 0x0000004DUL);
#define TSCR2                           _TSCR2.Byte
#define TSCR2_PR0                       _TSCR2.Bits.PR0
#define TSCR2_PR1                       _TSCR2.Bits.PR1
#define TSCR2_PR2                       _TSCR2.Bits.PR2
#define TSCR2_TCRE                      _TSCR2.Bits.TCRE
#define TSCR2_TOI                       _TSCR2.Bits.TOI
#define TSCR2_PR                        _TSCR2.MergedBits.grpPR

#define TSCR2_PR0_MASK                  1U
#define TSCR2_PR1_MASK                  2U
#define TSCR2_PR2_MASK                  4U
#define TSCR2_TCRE_MASK                 8U
#define TSCR2_TOI_MASK                  128U
#define TSCR2_PR_MASK                   7U
#define TSCR2_PR_BITNUM                 0U


/*** TFLG1 - Main Timer Interrupt Flag 1; 0x0000004E ***/
typedef union {
  byte Byte;
  struct {
    byte C0F         :1;                                       /* Input Capture/Output Compare Channel Flag 0 */
    byte C1F         :1;                                       /* Input Capture/Output Compare Channel Flag 1 */
    byte C2F         :1;                                       /* Input Capture/Output Compare Channel Flag 2 */
    byte C3F         :1;                                       /* Input Capture/Output Compare Channel Flag 3 */
    byte C4F         :1;                                       /* Input Capture/Output Compare Channel Flag 4 */
    byte C5F         :1;                                       /* Input Capture/Output Compare Channel Flag 5 */
    byte C6F         :1;                                       /* Input Capture/Output Compare Channel Flag 6 */
    byte C7F         :1;                                       /* Input Capture/Output Compare Channel Flag 7 */
  } Bits;
} TFLG1STR;
extern volatile TFLG1STR _TFLG1 @(REG_BASE + 0x0000004EUL);
#define TFLG1                           _TFLG1.Byte
#define TFLG1_C0F                       _TFLG1.Bits.C0F
#define TFLG1_C1F                       _TFLG1.Bits.C1F
#define TFLG1_C2F                       _TFLG1.Bits.C2F
#define TFLG1_C3F                       _TFLG1.Bits.C3F
#define TFLG1_C4F                       _TFLG1.Bits.C4F
#define TFLG1_C5F                       _TFLG1.Bits.C5F
#define TFLG1_C6F                       _TFLG1.Bits.C6F
#define TFLG1_C7F                       _TFLG1.Bits.C7F

#define TFLG1_C0F_MASK                  1U
#define TFLG1_C1F_MASK                  2U
#define TFLG1_C2F_MASK                  4U
#define TFLG1_C3F_MASK                  8U
#define TFLG1_C4F_MASK                  16U
#define TFLG1_C5F_MASK                  32U
#define TFLG1_C6F_MASK                  64U
#define TFLG1_C7F_MASK                  128U


/*** TFLG2 - Main Timer Interrupt Flag 2; 0x0000004F ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte TOF         :1;                                       /* Timer Overflow Flag */
  } Bits;
} TFLG2STR;
extern volatile TFLG2STR _TFLG2 @(REG_BASE + 0x0000004FUL);
#define TFLG2                           _TFLG2.Byte
#define TFLG2_TOF                       _TFLG2.Bits.TOF

#define TFLG2_TOF_MASK                  128U


/*** TC0 - Timer Input Capture/Output Compare Register 0; 0x00000050 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** TC0Hi - Timer Input Capture/Output Compare Register 0 High; 0x00000050 ***/
    union {
      byte Byte;
    } TC0HiSTR;
    #define TC0Hi                       _TC0.Overlap_STR.TC0HiSTR.Byte
    

    /*** TC0Lo - Timer Input Capture/Output Compare Register 0 Low; 0x00000051 ***/
    union {
      byte Byte;
    } TC0LoSTR;
    #define TC0Lo                       _TC0.Overlap_STR.TC0LoSTR.Byte
    
  } Overlap_STR;

} TC0STR;
extern volatile TC0STR _TC0 @(REG_BASE + 0x00000050UL);
#define TC0                             _TC0.Word
/* TC_ARR: Access 8 TCx registers in an array */
#define TC_ARR                          ((volatile word *) &TC0)


/*** TC1 - Timer Input Capture/Output Compare Register 1; 0x00000052 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** TC1Hi - Timer Input Capture/Output Compare Register 1 High; 0x00000052 ***/
    union {
      byte Byte;
    } TC1HiSTR;
    #define TC1Hi                       _TC1.Overlap_STR.TC1HiSTR.Byte
    

    /*** TC1Lo - Timer Input Capture/Output Compare Register 1 Low; 0x00000053 ***/
    union {
      byte Byte;
    } TC1LoSTR;
    #define TC1Lo                       _TC1.Overlap_STR.TC1LoSTR.Byte
    
  } Overlap_STR;

} TC1STR;
extern volatile TC1STR _TC1 @(REG_BASE + 0x00000052UL);
#define TC1                             _TC1.Word


/*** TC2 - Timer Input Capture/Output Compare Register 2; 0x00000054 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** TC2Hi - Timer Input Capture/Output Compare Register 2 High; 0x00000054 ***/
    union {
      byte Byte;
    } TC2HiSTR;
    #define TC2Hi                       _TC2.Overlap_STR.TC2HiSTR.Byte
    

    /*** TC2Lo - Timer Input Capture/Output Compare Register 2 Low; 0x00000055 ***/
    union {
      byte Byte;
    } TC2LoSTR;
    #define TC2Lo                       _TC2.Overlap_STR.TC2LoSTR.Byte
    
  } Overlap_STR;

} TC2STR;
extern volatile TC2STR _TC2 @(REG_BASE + 0x00000054UL);
#define TC2                             _TC2.Word


/*** TC3 - Timer Input Capture/Output Compare Register 3; 0x00000056 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** TC3Hi - Timer Input Capture/Output Compare Register 3 High; 0x00000056 ***/
    union {
      byte Byte;
    } TC3HiSTR;
    #define TC3Hi                       _TC3.Overlap_STR.TC3HiSTR.Byte
    

    /*** TC3Lo - Timer Input Capture/Output Compare Register 3 Low; 0x00000057 ***/
    union {
      byte Byte;
    } TC3LoSTR;
    #define TC3Lo                       _TC3.Overlap_STR.TC3LoSTR.Byte
    
  } Overlap_STR;

} TC3STR;
extern volatile TC3STR _TC3 @(REG_BASE + 0x00000056UL);
#define TC3                             _TC3.Word


/*** TC4 - Timer Input Capture/Output Compare Register 4; 0x00000058 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** TC4Hi - Timer Input Capture/Output Compare Register 4 High; 0x00000058 ***/
    union {
      byte Byte;
    } TC4HiSTR;
    #define TC4Hi                       _TC4.Overlap_STR.TC4HiSTR.Byte
    

    /*** TC4Lo - Timer Input Capture/Output Compare Register 4 Low; 0x00000059 ***/
    union {
      byte Byte;
    } TC4LoSTR;
    #define TC4Lo                       _TC4.Overlap_STR.TC4LoSTR.Byte
    
  } Overlap_STR;

} TC4STR;
extern volatile TC4STR _TC4 @(REG_BASE + 0x00000058UL);
#define TC4                             _TC4.Word


/*** TC5 - Timer Input Capture/Output Compare Register 5; 0x0000005A ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** TC5Hi - Timer Input Capture/Output Compare Register 5 High; 0x0000005A ***/
    union {
      byte Byte;
    } TC5HiSTR;
    #define TC5Hi                       _TC5.Overlap_STR.TC5HiSTR.Byte
    

    /*** TC5Lo - Timer Input Capture/Output Compare Register 5 Low; 0x0000005B ***/
    union {
      byte Byte;
    } TC5LoSTR;
    #define TC5Lo                       _TC5.Overlap_STR.TC5LoSTR.Byte
    
  } Overlap_STR;

} TC5STR;
extern volatile TC5STR _TC5 @(REG_BASE + 0x0000005AUL);
#define TC5                             _TC5.Word


/*** TC6 - Timer Input Capture/Output Compare Register 6; 0x0000005C ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** TC6Hi - Timer Input Capture/Output Compare Register 6 High; 0x0000005C ***/
    union {
      byte Byte;
    } TC6HiSTR;
    #define TC6Hi                       _TC6.Overlap_STR.TC6HiSTR.Byte
    

    /*** TC6Lo - Timer Input Capture/Output Compare Register 6 Low; 0x0000005D ***/
    union {
      byte Byte;
    } TC6LoSTR;
    #define TC6Lo                       _TC6.Overlap_STR.TC6LoSTR.Byte
    
  } Overlap_STR;

} TC6STR;
extern volatile TC6STR _TC6 @(REG_BASE + 0x0000005CUL);
#define TC6                             _TC6.Word


/*** TC7 - Timer Input Capture/Output Compare Register 7; 0x0000005E ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** TC7Hi - Timer Input Capture/Output Compare Register 7 High; 0x0000005E ***/
    union {
      byte Byte;
    } TC7HiSTR;
    #define TC7Hi                       _TC7.Overlap_STR.TC7HiSTR.Byte
    

    /*** TC7Lo - Timer Input Capture/Output Compare Register 7 Low; 0x0000005F ***/
    union {
      byte Byte;
    } TC7LoSTR;
    #define TC7Lo                       _TC7.Overlap_STR.TC7LoSTR.Byte
    
  } Overlap_STR;

} TC7STR;
extern volatile TC7STR _TC7 @(REG_BASE + 0x0000005EUL);
#define TC7                             _TC7.Word


/*** PACTL - 16-Bit Pulse Accumulator A Control Register; 0x00000060 ***/
typedef union {
  byte Byte;
  struct {
    byte PAI         :1;                                       /* Pulse Accumulator Input Interrupt enable */
    byte PAOVI       :1;                                       /* Pulse Accumulator A Overflow Interrupt enable */
    byte CLK0        :1;                                       /* Clock Select Bit 0 */
    byte CLK1        :1;                                       /* Clock Select Bit 1 */
    byte PEDGE       :1;                                       /* Pulse Accumulator Edge Control */
    byte PAMOD       :1;                                       /* Pulse Accumulator Mode */
    byte PAEN        :1;                                       /* Pulse Accumulator A System Enable */
    byte             :1; 
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte grpCLK  :2;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} PACTLSTR;
extern volatile PACTLSTR _PACTL @(REG_BASE + 0x00000060UL);
#define PACTL                           _PACTL.Byte
#define PACTL_PAI                       _PACTL.Bits.PAI
#define PACTL_PAOVI                     _PACTL.Bits.PAOVI
#define PACTL_CLK0                      _PACTL.Bits.CLK0
#define PACTL_CLK1                      _PACTL.Bits.CLK1
#define PACTL_PEDGE                     _PACTL.Bits.PEDGE
#define PACTL_PAMOD                     _PACTL.Bits.PAMOD
#define PACTL_PAEN                      _PACTL.Bits.PAEN
#define PACTL_CLK                       _PACTL.MergedBits.grpCLK

#define PACTL_PAI_MASK                  1U
#define PACTL_PAOVI_MASK                2U
#define PACTL_CLK0_MASK                 4U
#define PACTL_CLK1_MASK                 8U
#define PACTL_PEDGE_MASK                16U
#define PACTL_PAMOD_MASK                32U
#define PACTL_PAEN_MASK                 64U
#define PACTL_CLK_MASK                  12U
#define PACTL_CLK_BITNUM                2U


/*** PAFLG - Pulse Accumulator A Flag Register; 0x00000061 ***/
typedef union {
  byte Byte;
  struct {
    byte PAIF        :1;                                       /* Pulse Accumulator Input edge Flag */
    byte PAOVF       :1;                                       /* Pulse Accumulator A Overflow Flag */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} PAFLGSTR;
extern volatile PAFLGSTR _PAFLG @(REG_BASE + 0x00000061UL);
#define PAFLG                           _PAFLG.Byte
#define PAFLG_PAIF                      _PAFLG.Bits.PAIF
#define PAFLG_PAOVF                     _PAFLG.Bits.PAOVF

#define PAFLG_PAIF_MASK                 1U
#define PAFLG_PAOVF_MASK                2U


/*** PACNT - Pulse Accumulators Count Register; 0x00000062 ***/
typedef union {
  word Word;
} PACNTSTR;
extern volatile PACNTSTR _PACNT @(REG_BASE + 0x00000062UL);
#define PACNT                           _PACNT.Word


/*** SCIBD - SCI Baud Rate Register; 0x000000C8 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** SCIBDH - SCI Baud Rate Register High; 0x000000C8 ***/
    union {
      byte Byte;
      struct {
        byte SBR8        :1;                                       /* SCI 0 baud rate Bit 8 */
        byte SBR9        :1;                                       /* SCI 0 baud rate Bit 9 */
        byte SBR10       :1;                                       /* SCI 0 baud rate Bit 10 */
        byte SBR11       :1;                                       /* SCI 0 baud rate Bit 11 */
        byte SBR12       :1;                                       /* SCI 0 baud rate Bit 12 */
        byte TNP0        :1;                                       /* Transmitter Narrow Pulse Bit 0 */
        byte TNP1        :1;                                       /* Transmitter Narrow Pulse Bit 1 */
        byte IREN        :1;                                       /* Infrared Enable Bit */
      } Bits;
      struct {
        byte grpSBR_8 :5;
        byte grpTNP :2;
        byte     :1;
      } MergedBits;
    } SCIBDHSTR;
    #define SCIBDH                      _SCIBD.Overlap_STR.SCIBDHSTR.Byte
    #define SCIBDH_SBR8                 _SCIBD.Overlap_STR.SCIBDHSTR.Bits.SBR8
    #define SCIBDH_SBR9                 _SCIBD.Overlap_STR.SCIBDHSTR.Bits.SBR9
    #define SCIBDH_SBR10                _SCIBD.Overlap_STR.SCIBDHSTR.Bits.SBR10
    #define SCIBDH_SBR11                _SCIBD.Overlap_STR.SCIBDHSTR.Bits.SBR11
    #define SCIBDH_SBR12                _SCIBD.Overlap_STR.SCIBDHSTR.Bits.SBR12
    #define SCIBDH_TNP0                 _SCIBD.Overlap_STR.SCIBDHSTR.Bits.TNP0
    #define SCIBDH_TNP1                 _SCIBD.Overlap_STR.SCIBDHSTR.Bits.TNP1
    #define SCIBDH_IREN                 _SCIBD.Overlap_STR.SCIBDHSTR.Bits.IREN
    #define SCIBDH_SBR_8                _SCIBD.Overlap_STR.SCIBDHSTR.MergedBits.grpSBR_8
    #define SCIBDH_TNP                  _SCIBD.Overlap_STR.SCIBDHSTR.MergedBits.grpTNP
    #define SCIBDH_SBR                  SCIBDH_SBR_8
    
    #define SCIBDH_SBR8_MASK            1U
    #define SCIBDH_SBR9_MASK            2U
    #define SCIBDH_SBR10_MASK           4U
    #define SCIBDH_SBR11_MASK           8U
    #define SCIBDH_SBR12_MASK           16U
    #define SCIBDH_TNP0_MASK            32U
    #define SCIBDH_TNP1_MASK            64U
    #define SCIBDH_IREN_MASK            128U
    #define SCIBDH_SBR_8_MASK           31U
    #define SCIBDH_SBR_8_BITNUM         0U
    #define SCIBDH_TNP_MASK             96U
    #define SCIBDH_TNP_BITNUM           5U
    

    /*** SCIBDL - SCI Baud Rate Register Low; 0x000000C9 ***/
    union {
      byte Byte;
      struct {
        byte SBR0        :1;                                       /* SCI 0 baud rate Bit 0 */
        byte SBR1        :1;                                       /* SCI 0 baud rate Bit 1 */
        byte SBR2        :1;                                       /* SCI 0 baud rate Bit 2 */
        byte SBR3        :1;                                       /* SCI 0 baud rate Bit 3 */
        byte SBR4        :1;                                       /* SCI 0 baud rate Bit 4 */
        byte SBR5        :1;                                       /* SCI 0 baud rate Bit 5 */
        byte SBR6        :1;                                       /* SCI 0 baud rate Bit 6 */
        byte SBR7        :1;                                       /* SCI 0 baud rate Bit 7 */
      } Bits;
    } SCIBDLSTR;
    #define SCIBDL                      _SCIBD.Overlap_STR.SCIBDLSTR.Byte
    #define SCIBDL_SBR0                 _SCIBD.Overlap_STR.SCIBDLSTR.Bits.SBR0
    #define SCIBDL_SBR1                 _SCIBD.Overlap_STR.SCIBDLSTR.Bits.SBR1
    #define SCIBDL_SBR2                 _SCIBD.Overlap_STR.SCIBDLSTR.Bits.SBR2
    #define SCIBDL_SBR3                 _SCIBD.Overlap_STR.SCIBDLSTR.Bits.SBR3
    #define SCIBDL_SBR4                 _SCIBD.Overlap_STR.SCIBDLSTR.Bits.SBR4
    #define SCIBDL_SBR5                 _SCIBD.Overlap_STR.SCIBDLSTR.Bits.SBR5
    #define SCIBDL_SBR6                 _SCIBD.Overlap_STR.SCIBDLSTR.Bits.SBR6
    #define SCIBDL_SBR7                 _SCIBD.Overlap_STR.SCIBDLSTR.Bits.SBR7
    
    #define SCIBDL_SBR0_MASK            1U
    #define SCIBDL_SBR1_MASK            2U
    #define SCIBDL_SBR2_MASK            4U
    #define SCIBDL_SBR3_MASK            8U
    #define SCIBDL_SBR4_MASK            16U
    #define SCIBDL_SBR5_MASK            32U
    #define SCIBDL_SBR6_MASK            64U
    #define SCIBDL_SBR7_MASK            128U
    
  } Overlap_STR;

  struct {
    word SBR0        :1;                                       /* SCI baud rate Bit 0 */
    word SBR1        :1;                                       /* SCI baud rate Bit 1 */
    word SBR2        :1;                                       /* SCI baud rate Bit 2 */
    word SBR3        :1;                                       /* SCI baud rate Bit 3 */
    word SBR4        :1;                                       /* SCI baud rate Bit 4 */
    word SBR5        :1;                                       /* SCI baud rate Bit 5 */
    word SBR6        :1;                                       /* SCI baud rate Bit 6 */
    word SBR7        :1;                                       /* SCI baud rate Bit 7 */
    word SBR8        :1;                                       /* SCI baud rate Bit 8 */
    word SBR9        :1;                                       /* SCI baud rate Bit 9 */
    word SBR10       :1;                                       /* SCI baud rate Bit 10 */
    word SBR11       :1;                                       /* SCI baud rate Bit 11 */
    word SBR12       :1;                                       /* SCI baud rate Bit 12 */
    word TNP0        :1;                                       /* Transmitter Narrow Pulse Bit 0 */
    word TNP1        :1;                                       /* Transmitter Narrow Pulse Bit 1 */
    word IREN        :1;                                       /* Infrared Enable Bit */
  } Bits;
  struct {
    word grpSBR  :13;
    word grpTNP  :2;
    word         :1;
  } MergedBits;
} SCIBDSTR;
extern volatile SCIBDSTR _SCIBD @(REG_BASE + 0x000000C8UL);
#define SCIBD                           _SCIBD.Word
#define SCIBD_SBR0                      _SCIBD.Bits.SBR0
#define SCIBD_SBR1                      _SCIBD.Bits.SBR1
#define SCIBD_SBR2                      _SCIBD.Bits.SBR2
#define SCIBD_SBR3                      _SCIBD.Bits.SBR3
#define SCIBD_SBR4                      _SCIBD.Bits.SBR4
#define SCIBD_SBR5                      _SCIBD.Bits.SBR5
#define SCIBD_SBR6                      _SCIBD.Bits.SBR6
#define SCIBD_SBR7                      _SCIBD.Bits.SBR7
#define SCIBD_SBR8                      _SCIBD.Bits.SBR8
#define SCIBD_SBR9                      _SCIBD.Bits.SBR9
#define SCIBD_SBR10                     _SCIBD.Bits.SBR10
#define SCIBD_SBR11                     _SCIBD.Bits.SBR11
#define SCIBD_SBR12                     _SCIBD.Bits.SBR12
#define SCIBD_TNP0                      _SCIBD.Bits.TNP0
#define SCIBD_TNP1                      _SCIBD.Bits.TNP1
#define SCIBD_IREN                      _SCIBD.Bits.IREN
#define SCIBD_SBR                       _SCIBD.MergedBits.grpSBR
#define SCIBD_TNP                       _SCIBD.MergedBits.grpTNP

#define SCIBD_SBR0_MASK                 1U
#define SCIBD_SBR1_MASK                 2U
#define SCIBD_SBR2_MASK                 4U
#define SCIBD_SBR3_MASK                 8U
#define SCIBD_SBR4_MASK                 16U
#define SCIBD_SBR5_MASK                 32U
#define SCIBD_SBR6_MASK                 64U
#define SCIBD_SBR7_MASK                 128U
#define SCIBD_SBR8_MASK                 256U
#define SCIBD_SBR9_MASK                 512U
#define SCIBD_SBR10_MASK                1024U
#define SCIBD_SBR11_MASK                2048U
#define SCIBD_SBR12_MASK                4096U
#define SCIBD_TNP0_MASK                 8192U
#define SCIBD_TNP1_MASK                 16384U
#define SCIBD_IREN_MASK                 32768U
#define SCIBD_SBR_MASK                  8191U
#define SCIBD_SBR_BITNUM                0U
#define SCIBD_TNP_MASK                  24576U
#define SCIBD_TNP_BITNUM                13U


/*** SCICR1 - SCI Control Register 1; 0x000000CA ***/
typedef union {
  byte Byte;
  struct {
    byte PT          :1;                                       /* Parity Type Bit */
    byte PE          :1;                                       /* Parity Enable Bit */
    byte ILT         :1;                                       /* Idle Line Type Bit */
    byte WAKE        :1;                                       /* Wakeup Condition Bit */
    byte M           :1;                                       /* Data Format Mode Bit */
    byte RSRC        :1;                                       /* Receiver Source Bit */
    byte SCISWAI     :1;                                       /* SCI 0 Stop in Wait Mode Bit */
    byte LOOPS       :1;                                       /* Loop Select Bit */
  } Bits;
} SCICR1STR;
extern volatile SCICR1STR _SCICR1 @(REG_BASE + 0x000000CAUL);
#define SCICR1                          _SCICR1.Byte
#define SCICR1_PT                       _SCICR1.Bits.PT
#define SCICR1_PE                       _SCICR1.Bits.PE
#define SCICR1_ILT                      _SCICR1.Bits.ILT
#define SCICR1_WAKE                     _SCICR1.Bits.WAKE
#define SCICR1_M                        _SCICR1.Bits.M
#define SCICR1_RSRC                     _SCICR1.Bits.RSRC
#define SCICR1_SCISWAI                  _SCICR1.Bits.SCISWAI
#define SCICR1_LOOPS                    _SCICR1.Bits.LOOPS

#define SCICR1_PT_MASK                  1U
#define SCICR1_PE_MASK                  2U
#define SCICR1_ILT_MASK                 4U
#define SCICR1_WAKE_MASK                8U
#define SCICR1_M_MASK                   16U
#define SCICR1_RSRC_MASK                32U
#define SCICR1_SCISWAI_MASK             64U
#define SCICR1_LOOPS_MASK               128U


/*** SCICR2 - SCI Control Register 2; 0x000000CB ***/
typedef union {
  byte Byte;
  struct {
    byte SBK         :1;                                       /* Send Break Bit */
    byte RWU         :1;                                       /* Receiver Wakeup Bit */
    byte RE          :1;                                       /* Receiver Enable Bit */
    byte TE          :1;                                       /* Transmitter Enable Bit */
    byte ILIE        :1;                                       /* Idle Line Interrupt Enable Bit */
    byte RIE         :1;                                       /* Receiver Full Interrupt Enable Bit */
    byte TCIE        :1;                                       /* Transmission Complete Interrupt Enable Bit */
    byte SCTIE       :1;                                       /* Transmitter Interrupt Enable Bit */
  } Bits;
} SCICR2STR;
extern volatile SCICR2STR _SCICR2 @(REG_BASE + 0x000000CBUL);
#define SCICR2                          _SCICR2.Byte
#define SCICR2_SBK                      _SCICR2.Bits.SBK
#define SCICR2_RWU                      _SCICR2.Bits.RWU
#define SCICR2_RE                       _SCICR2.Bits.RE
#define SCICR2_TE                       _SCICR2.Bits.TE
#define SCICR2_ILIE                     _SCICR2.Bits.ILIE
#define SCICR2_RIE                      _SCICR2.Bits.RIE
#define SCICR2_TCIE                     _SCICR2.Bits.TCIE
#define SCICR2_SCTIE                    _SCICR2.Bits.SCTIE

#define SCICR2_SBK_MASK                 1U
#define SCICR2_RWU_MASK                 2U
#define SCICR2_RE_MASK                  4U
#define SCICR2_TE_MASK                  8U
#define SCICR2_ILIE_MASK                16U
#define SCICR2_RIE_MASK                 32U
#define SCICR2_TCIE_MASK                64U
#define SCICR2_SCTIE_MASK               128U


/*** SCISR1 - SCI Status Register 1; 0x000000CC ***/
typedef union {
  byte Byte;
  struct {
    byte PF          :1;                                       /* Parity Error Flag */
    byte FE          :1;                                       /* Framing Error Flag */
    byte NF          :1;                                       /* Noise Flag */
    byte OR          :1;                                       /* Overrun Flag */
    byte IDLE        :1;                                       /* Idle Line Flag */
    byte RDRF        :1;                                       /* Receive Data Register Full Flag */
    byte TC          :1;                                       /* Transmit Complete Flag */
    byte TDRE        :1;                                       /* Transmit Data Register Empty Flag */
  } Bits;
} SCISR1STR;
extern volatile SCISR1STR _SCISR1 @(REG_BASE + 0x000000CCUL);
#define SCISR1                          _SCISR1.Byte
#define SCISR1_PF                       _SCISR1.Bits.PF
#define SCISR1_FE                       _SCISR1.Bits.FE
#define SCISR1_NF                       _SCISR1.Bits.NF
#define SCISR1_OR                       _SCISR1.Bits.OR
#define SCISR1_IDLE                     _SCISR1.Bits.IDLE
#define SCISR1_RDRF                     _SCISR1.Bits.RDRF
#define SCISR1_TC                       _SCISR1.Bits.TC
#define SCISR1_TDRE                     _SCISR1.Bits.TDRE

#define SCISR1_PF_MASK                  1U
#define SCISR1_FE_MASK                  2U
#define SCISR1_NF_MASK                  4U
#define SCISR1_OR_MASK                  8U
#define SCISR1_IDLE_MASK                16U
#define SCISR1_RDRF_MASK                32U
#define SCISR1_TC_MASK                  64U
#define SCISR1_TDRE_MASK                128U


/*** SCISR2 - SCI Status Register 2; 0x000000CD ***/
typedef union {
  byte Byte;
  struct {
    byte RAF         :1;                                       /* Receiver Active Flag */
    byte TXDIR       :1;                                       /* Transmitter pin data direction in Single-Wire mode */
    byte BRK13       :1;                                       /* Break Transmit character length */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} SCISR2STR;
extern volatile SCISR2STR _SCISR2 @(REG_BASE + 0x000000CDUL);
#define SCISR2                          _SCISR2.Byte
#define SCISR2_RAF                      _SCISR2.Bits.RAF
#define SCISR2_TXDIR                    _SCISR2.Bits.TXDIR
#define SCISR2_BRK13                    _SCISR2.Bits.BRK13

#define SCISR2_RAF_MASK                 1U
#define SCISR2_TXDIR_MASK               2U
#define SCISR2_BRK13_MASK               4U


/*** SCIDR - SCI Data Register; 0x000000CE ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** SCIDRH - SCI Data Register High; 0x000000CE ***/
    union {
      byte Byte;
      struct {
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte T8          :1;                                       /* Transmit Bit 8 */
        byte R8          :1;                                       /* Received Bit 8 */
      } Bits;
    } SCIDRHSTR;
    #define SCIDRH                      _SCIDR.Overlap_STR.SCIDRHSTR.Byte
    #define SCIDRH_T8                   _SCIDR.Overlap_STR.SCIDRHSTR.Bits.T8
    #define SCIDRH_R8                   _SCIDR.Overlap_STR.SCIDRHSTR.Bits.R8
    
    #define SCIDRH_T8_MASK              64U
    #define SCIDRH_R8_MASK              128U
    

    /*** SCIDRL - SCI Data Register Low; 0x000000CF ***/
    union {
      byte Byte;
      struct {
        byte R0_T0       :1;                                       /* Received Bit 0 or transmit Bit 0 */
        byte R1_T1       :1;                                       /* Received Bit 1 or transmit Bit 1 */
        byte R2_T2       :1;                                       /* Received Bit 2 or transmit Bit 2 */
        byte R3_T3       :1;                                       /* Received Bit 3 or transmit Bit 3 */
        byte R4_T4       :1;                                       /* Received Bit 4 or transmit Bit 4 */
        byte R5_T5       :1;                                       /* Received Bit 5 or transmit Bit 5 */
        byte R6_T6       :1;                                       /* Received Bit 6 or transmit Bit 6 */
        byte R7_T7       :1;                                       /* Received Bit 7 or transmit Bit 7 */
      } Bits;
    } SCIDRLSTR;
    #define SCIDRL                      _SCIDR.Overlap_STR.SCIDRLSTR.Byte
    #define SCIDRL_R0_T0                _SCIDR.Overlap_STR.SCIDRLSTR.Bits.R0_T0
    #define SCIDRL_R1_T1                _SCIDR.Overlap_STR.SCIDRLSTR.Bits.R1_T1
    #define SCIDRL_R2_T2                _SCIDR.Overlap_STR.SCIDRLSTR.Bits.R2_T2
    #define SCIDRL_R3_T3                _SCIDR.Overlap_STR.SCIDRLSTR.Bits.R3_T3
    #define SCIDRL_R4_T4                _SCIDR.Overlap_STR.SCIDRLSTR.Bits.R4_T4
    #define SCIDRL_R5_T5                _SCIDR.Overlap_STR.SCIDRLSTR.Bits.R5_T5
    #define SCIDRL_R6_T6                _SCIDR.Overlap_STR.SCIDRLSTR.Bits.R6_T6
    #define SCIDRL_R7_T7                _SCIDR.Overlap_STR.SCIDRLSTR.Bits.R7_T7
    
    #define SCIDRL_R0_T0_MASK           1U
    #define SCIDRL_R1_T1_MASK           2U
    #define SCIDRL_R2_T2_MASK           4U
    #define SCIDRL_R3_T3_MASK           8U
    #define SCIDRL_R4_T4_MASK           16U
    #define SCIDRL_R5_T5_MASK           32U
    #define SCIDRL_R6_T6_MASK           64U
    #define SCIDRL_R7_T7_MASK           128U
    
  } Overlap_STR;

  struct {
    word R0_T0       :1;                                       /* Received bit 0 or Transmit bit 0 */
    word R1_T1       :1;                                       /* Received bit 1 or Transmit bit 1 */
    word R2_T2       :1;                                       /* Received bit 2 or Transmit bit 2 */
    word R3_T3       :1;                                       /* Received bit 3 or Transmit bit 3 */
    word R4_T4       :1;                                       /* Received bit 4 or Transmit bit 4 */
    word R5_T5       :1;                                       /* Received bit 5 or Transmit bit 5 */
    word R6_T6       :1;                                       /* Received bit 6 or Transmit bit 6 */
    word R7_T7       :1;                                       /* Received bit 7 or Transmit bit 7 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word T8          :1;                                       /* Transmit Bit 8 */
    word R8          :1;                                       /* Received Bit 8 */
  } Bits;
} SCIDRSTR;
extern volatile SCIDRSTR _SCIDR @(REG_BASE + 0x000000CEUL);
#define SCIDR                           _SCIDR.Word
#define SCIDR_R0_T0                     _SCIDR.Bits.R0_T0
#define SCIDR_R1_T1                     _SCIDR.Bits.R1_T1
#define SCIDR_R2_T2                     _SCIDR.Bits.R2_T2
#define SCIDR_R3_T3                     _SCIDR.Bits.R3_T3
#define SCIDR_R4_T4                     _SCIDR.Bits.R4_T4
#define SCIDR_R5_T5                     _SCIDR.Bits.R5_T5
#define SCIDR_R6_T6                     _SCIDR.Bits.R6_T6
#define SCIDR_R7_T7                     _SCIDR.Bits.R7_T7
#define SCIDR_T8                        _SCIDR.Bits.T8
#define SCIDR_R8                        _SCIDR.Bits.R8

#define SCIDR_R0_T0_MASK                1U
#define SCIDR_R1_T1_MASK                2U
#define SCIDR_R2_T2_MASK                4U
#define SCIDR_R3_T3_MASK                8U
#define SCIDR_R4_T4_MASK                16U
#define SCIDR_R5_T5_MASK                32U
#define SCIDR_R6_T6_MASK                64U
#define SCIDR_R7_T7_MASK                128U
#define SCIDR_T8_MASK                   16384U
#define SCIDR_R8_MASK                   32768U


/*** FCLKDIV - Flash Clock Divider Register; 0x00000100 ***/
typedef union {
  byte Byte;
  struct {
    byte FDIV0       :1;                                       /* Flash Clock Divider Bit 0 */
    byte FDIV1       :1;                                       /* Flash Clock Divider Bit 1 */
    byte FDIV2       :1;                                       /* Flash Clock Divider Bit 2 */
    byte FDIV3       :1;                                       /* Flash Clock Divider Bit 3 */
    byte FDIV4       :1;                                       /* Flash Clock Divider Bit 4 */
    byte FDIV5       :1;                                       /* Flash Clock Divider Bit 5 */
    byte PRDIV8      :1;                                       /* Enable Prescaler by 8 */
    byte FDIVLD      :1;                                       /* Flash Clock Divider Loaded */
  } Bits;
  struct {
    byte grpFDIV :6;
    byte grpPRDIV_8 :1;
    byte         :1;
  } MergedBits;
} FCLKDIVSTR;
extern volatile FCLKDIVSTR _FCLKDIV @(REG_BASE + 0x00000100UL);
#define FCLKDIV                         _FCLKDIV.Byte
#define FCLKDIV_FDIV0                   _FCLKDIV.Bits.FDIV0
#define FCLKDIV_FDIV1                   _FCLKDIV.Bits.FDIV1
#define FCLKDIV_FDIV2                   _FCLKDIV.Bits.FDIV2
#define FCLKDIV_FDIV3                   _FCLKDIV.Bits.FDIV3
#define FCLKDIV_FDIV4                   _FCLKDIV.Bits.FDIV4
#define FCLKDIV_FDIV5                   _FCLKDIV.Bits.FDIV5
#define FCLKDIV_PRDIV8                  _FCLKDIV.Bits.PRDIV8
#define FCLKDIV_FDIVLD                  _FCLKDIV.Bits.FDIVLD
#define FCLKDIV_FDIV                    _FCLKDIV.MergedBits.grpFDIV

#define FCLKDIV_FDIV0_MASK              1U
#define FCLKDIV_FDIV1_MASK              2U
#define FCLKDIV_FDIV2_MASK              4U
#define FCLKDIV_FDIV3_MASK              8U
#define FCLKDIV_FDIV4_MASK              16U
#define FCLKDIV_FDIV5_MASK              32U
#define FCLKDIV_PRDIV8_MASK             64U
#define FCLKDIV_FDIVLD_MASK             128U
#define FCLKDIV_FDIV_MASK               63U
#define FCLKDIV_FDIV_BITNUM             0U


/*** FSEC - Flash Security Register; 0x00000101 ***/
typedef union {
  byte Byte;
  struct {
    byte SEC0        :1;                                       /* Memory security bit 0 */
    byte SEC1        :1;                                       /* Memory security bit 1 */
    byte NV2         :1;                                       /* Non Volatile flag bit 2 */
    byte NV3         :1;                                       /* Non Volatile flag bit 3 */
    byte NV4         :1;                                       /* Non Volatile flag bit 4 */
    byte NV5         :1;                                       /* Non Volatile flag bit 5 */
    byte KEYEN0      :1;                                       /* Bit 0 of Backdoor Key Security Enable */
    byte KEYEN1      :1;                                       /* Bit 1 of Backdoor Key Security Enable */
  } Bits;
  struct {
    byte grpSEC  :2;
    byte grpNV_2 :4;
    byte grpKEYEN :2;
  } MergedBits;
} FSECSTR;
extern volatile FSECSTR _FSEC @(REG_BASE + 0x00000101UL);
#define FSEC                            _FSEC.Byte
#define FSEC_SEC0                       _FSEC.Bits.SEC0
#define FSEC_SEC1                       _FSEC.Bits.SEC1
#define FSEC_NV2                        _FSEC.Bits.NV2
#define FSEC_NV3                        _FSEC.Bits.NV3
#define FSEC_NV4                        _FSEC.Bits.NV4
#define FSEC_NV5                        _FSEC.Bits.NV5
#define FSEC_KEYEN0                     _FSEC.Bits.KEYEN0
#define FSEC_KEYEN1                     _FSEC.Bits.KEYEN1
#define FSEC_SEC                        _FSEC.MergedBits.grpSEC
#define FSEC_NV_2                       _FSEC.MergedBits.grpNV_2
#define FSEC_KEYEN                      _FSEC.MergedBits.grpKEYEN
#define FSEC_NV                         FSEC_NV_2

#define FSEC_SEC0_MASK                  1U
#define FSEC_SEC1_MASK                  2U
#define FSEC_NV2_MASK                   4U
#define FSEC_NV3_MASK                   8U
#define FSEC_NV4_MASK                   16U
#define FSEC_NV5_MASK                   32U
#define FSEC_KEYEN0_MASK                64U
#define FSEC_KEYEN1_MASK                128U
#define FSEC_SEC_MASK                   3U
#define FSEC_SEC_BITNUM                 0U
#define FSEC_NV_2_MASK                  60U
#define FSEC_NV_2_BITNUM                2U
#define FSEC_KEYEN_MASK                 192U
#define FSEC_KEYEN_BITNUM               6U


/*** FCNFG - Flash Configuration Register; 0x00000103 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte KEYACC      :1;                                       /* Enable Security Key Writing */
    byte CCIE        :1;                                       /* Command Complete Interrupt Enable */
    byte CBEIE       :1;                                       /* Command Buffers Empty Interrupt Enable */
  } Bits;
} FCNFGSTR;
extern volatile FCNFGSTR _FCNFG @(REG_BASE + 0x00000103UL);
#define FCNFG                           _FCNFG.Byte
#define FCNFG_KEYACC                    _FCNFG.Bits.KEYACC
#define FCNFG_CCIE                      _FCNFG.Bits.CCIE
#define FCNFG_CBEIE                     _FCNFG.Bits.CBEIE

#define FCNFG_KEYACC_MASK               32U
#define FCNFG_CCIE_MASK                 64U
#define FCNFG_CBEIE_MASK                128U


/*** FPROT - Flash Protection Register; 0x00000104 ***/
typedef union {
  byte Byte;
  struct {
    byte FPLS0       :1;                                       /* Flash Protection Lower Address size 0 */
    byte FPLS1       :1;                                       /* Flash Protection Lower Address size 1 */
    byte FPLDIS      :1;                                       /* Flash Protection Lower address range disable */
    byte FPHS0       :1;                                       /* Flash Protection Higher address size 0 */
    byte FPHS1       :1;                                       /* Flash Protection Higher address size 1 */
    byte FPHDIS      :1;                                       /* Flash Protection Higher address range disable */
    byte NV6         :1;                                       /* Non Volatile Flag Bit */
    byte FPOPEN      :1;                                       /* Opens the flash block or subsections of it for program or erase */
  } Bits;
  struct {
    byte grpFPLS :2;
    byte         :1;
    byte grpFPHS :2;
    byte         :1;
    byte grpNV_6 :1;
    byte         :1;
  } MergedBits;
} FPROTSTR;
extern volatile FPROTSTR _FPROT @(REG_BASE + 0x00000104UL);
#define FPROT                           _FPROT.Byte
#define FPROT_FPLS0                     _FPROT.Bits.FPLS0
#define FPROT_FPLS1                     _FPROT.Bits.FPLS1
#define FPROT_FPLDIS                    _FPROT.Bits.FPLDIS
#define FPROT_FPHS0                     _FPROT.Bits.FPHS0
#define FPROT_FPHS1                     _FPROT.Bits.FPHS1
#define FPROT_FPHDIS                    _FPROT.Bits.FPHDIS
#define FPROT_NV6                       _FPROT.Bits.NV6
#define FPROT_FPOPEN                    _FPROT.Bits.FPOPEN
#define FPROT_FPLS                      _FPROT.MergedBits.grpFPLS
#define FPROT_FPHS                      _FPROT.MergedBits.grpFPHS

#define FPROT_FPLS0_MASK                1U
#define FPROT_FPLS1_MASK                2U
#define FPROT_FPLDIS_MASK               4U
#define FPROT_FPHS0_MASK                8U
#define FPROT_FPHS1_MASK                16U
#define FPROT_FPHDIS_MASK               32U
#define FPROT_NV6_MASK                  64U
#define FPROT_FPOPEN_MASK               128U
#define FPROT_FPLS_MASK                 3U
#define FPROT_FPLS_BITNUM               0U
#define FPROT_FPHS_MASK                 24U
#define FPROT_FPHS_BITNUM               3U


/*** FSTAT - Flash Status Register; 0x00000105 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte BLANK       :1;                                       /* Blank Verify Flag */
    byte             :1; 
    byte ACCERR      :1;                                       /* Access error */
    byte PVIOL       :1;                                       /* Protection violation */
    byte CCIF        :1;                                       /* Command Complete Interrupt Flag */
    byte CBEIF       :1;                                       /* Command Buffers Empty Interrupt Flag */
  } Bits;
} FSTATSTR;
extern volatile FSTATSTR _FSTAT @(REG_BASE + 0x00000105UL);
#define FSTAT                           _FSTAT.Byte
#define FSTAT_BLANK                     _FSTAT.Bits.BLANK
#define FSTAT_ACCERR                    _FSTAT.Bits.ACCERR
#define FSTAT_PVIOL                     _FSTAT.Bits.PVIOL
#define FSTAT_CCIF                      _FSTAT.Bits.CCIF
#define FSTAT_CBEIF                     _FSTAT.Bits.CBEIF

#define FSTAT_BLANK_MASK                4U
#define FSTAT_ACCERR_MASK               16U
#define FSTAT_PVIOL_MASK                32U
#define FSTAT_CCIF_MASK                 64U
#define FSTAT_CBEIF_MASK                128U


/*** FCMD - Flash Command Buffer and Register; 0x00000106 ***/
typedef union {
  byte Byte;
  struct {
    byte CMDB0       :1;                                       /* NVM User Mode Command Bit 0 */
    byte             :1; 
    byte CMDB2       :1;                                       /* NVM User Mode Command Bit 2 */
    byte             :1; 
    byte             :1; 
    byte CMDB5       :1;                                       /* NVM User Mode Command Bit 5 */
    byte CMDB6       :1;                                       /* NVM User Mode Command Bit 6 */
    byte             :1; 
  } Bits;
  struct {
    byte grpCMDB :1;
    byte         :1;
    byte grpCMDB_2 :1;
    byte         :1;
    byte         :1;
    byte grpCMDB_5 :2;
    byte         :1;
  } MergedBits;
} FCMDSTR;
extern volatile FCMDSTR _FCMD @(REG_BASE + 0x00000106UL);
#define FCMD                            _FCMD.Byte
#define FCMD_CMDB0                      _FCMD.Bits.CMDB0
#define FCMD_CMDB2                      _FCMD.Bits.CMDB2
#define FCMD_CMDB5                      _FCMD.Bits.CMDB5
#define FCMD_CMDB6                      _FCMD.Bits.CMDB6
#define FCMD_CMDB_5                     _FCMD.MergedBits.grpCMDB_5
#define FCMD_CMDB                       FCMD_CMDB_5

#define FCMD_CMDB0_MASK                 1U
#define FCMD_CMDB2_MASK                 4U
#define FCMD_CMDB5_MASK                 32U
#define FCMD_CMDB6_MASK                 64U
#define FCMD_CMDB_5_MASK                96U
#define FCMD_CMDB_5_BITNUM              5U


/*** FADDR - Flash Address Register (High; 0x00000108 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** FADDRHi - Flash Address High Register; 0x00000108 ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Flash Address Register Bit 8 */
        byte BIT9        :1;                                       /* Flash Address Register Bit 9 */
        byte BIT10       :1;                                       /* Flash Address Register Bit 10 */
        byte BIT11       :1;                                       /* Flash Address Register Bit 11 */
        byte BIT12       :1;                                       /* Flash Address Register Bit 12 */
        byte BIT13       :1;                                       /* Flash Address Register Bit 13 */
        byte             :1; 
        byte             :1; 
      } Bits;
      struct {
        byte grpBIT_8 :6;
        byte     :1;
        byte     :1;
      } MergedBits;
    } FADDRHiSTR;
    #define FADDRHi                     _FADDR.Overlap_STR.FADDRHiSTR.Byte
    #define FADDRHi_BIT8                _FADDR.Overlap_STR.FADDRHiSTR.Bits.BIT8
    #define FADDRHi_BIT9                _FADDR.Overlap_STR.FADDRHiSTR.Bits.BIT9
    #define FADDRHi_BIT10               _FADDR.Overlap_STR.FADDRHiSTR.Bits.BIT10
    #define FADDRHi_BIT11               _FADDR.Overlap_STR.FADDRHiSTR.Bits.BIT11
    #define FADDRHi_BIT12               _FADDR.Overlap_STR.FADDRHiSTR.Bits.BIT12
    #define FADDRHi_BIT13               _FADDR.Overlap_STR.FADDRHiSTR.Bits.BIT13
    #define FADDRHi_BIT_8               _FADDR.Overlap_STR.FADDRHiSTR.MergedBits.grpBIT_8
    #define FADDRHi_BIT                 FADDRHi_BIT_8
    
    #define FADDRHi_BIT8_MASK           1U
    #define FADDRHi_BIT9_MASK           2U
    #define FADDRHi_BIT10_MASK          4U
    #define FADDRHi_BIT11_MASK          8U
    #define FADDRHi_BIT12_MASK          16U
    #define FADDRHi_BIT13_MASK          32U
    #define FADDRHi_BIT_8_MASK          63U
    #define FADDRHi_BIT_8_BITNUM        0U
    

    /*** FADDRLo - Flash Address Low Register; 0x00000109 ***/
    union {
      byte Byte;
      struct {
        byte BIT0        :1;                                       /* Flash Address Register Bit 0 */
        byte BIT1        :1;                                       /* Flash Address Register Bit 1 */
        byte BIT2        :1;                                       /* Flash Address Register Bit 2 */
        byte BIT3        :1;                                       /* Flash Address Register Bit 3 */
        byte BIT4        :1;                                       /* Flash Address Register Bit 4 */
        byte BIT5        :1;                                       /* Flash Address Register Bit 5 */
        byte BIT6        :1;                                       /* Flash Address Register Bit 6 */
        byte BIT7        :1;                                       /* Flash Address Register Bit 7 */
      } Bits;
    } FADDRLoSTR;
    #define FADDRLo                     _FADDR.Overlap_STR.FADDRLoSTR.Byte
    #define FADDRLo_BIT0                _FADDR.Overlap_STR.FADDRLoSTR.Bits.BIT0
    #define FADDRLo_BIT1                _FADDR.Overlap_STR.FADDRLoSTR.Bits.BIT1
    #define FADDRLo_BIT2                _FADDR.Overlap_STR.FADDRLoSTR.Bits.BIT2
    #define FADDRLo_BIT3                _FADDR.Overlap_STR.FADDRLoSTR.Bits.BIT3
    #define FADDRLo_BIT4                _FADDR.Overlap_STR.FADDRLoSTR.Bits.BIT4
    #define FADDRLo_BIT5                _FADDR.Overlap_STR.FADDRLoSTR.Bits.BIT5
    #define FADDRLo_BIT6                _FADDR.Overlap_STR.FADDRLoSTR.Bits.BIT6
    #define FADDRLo_BIT7                _FADDR.Overlap_STR.FADDRLoSTR.Bits.BIT7
    
    #define FADDRLo_BIT0_MASK           1U
    #define FADDRLo_BIT1_MASK           2U
    #define FADDRLo_BIT2_MASK           4U
    #define FADDRLo_BIT3_MASK           8U
    #define FADDRLo_BIT4_MASK           16U
    #define FADDRLo_BIT5_MASK           32U
    #define FADDRLo_BIT6_MASK           64U
    #define FADDRLo_BIT7_MASK           128U
    
  } Overlap_STR;

  struct {
    word BIT0        :1;                                       /* Flash Address Register Bit 0 */
    word BIT1        :1;                                       /* Flash Address Register Bit 1 */
    word BIT2        :1;                                       /* Flash Address Register Bit 2 */
    word BIT3        :1;                                       /* Flash Address Register Bit 3 */
    word BIT4        :1;                                       /* Flash Address Register Bit 4 */
    word BIT5        :1;                                       /* Flash Address Register Bit 5 */
    word BIT6        :1;                                       /* Flash Address Register Bit 6 */
    word BIT7        :1;                                       /* Flash Address Register Bit 7 */
    word BIT8        :1;                                       /* Flash Address Register Bit 8 */
    word BIT9        :1;                                       /* Flash Address Register Bit 9 */
    word BIT10       :1;                                       /* Flash Address Register Bit 10 */
    word BIT11       :1;                                       /* Flash Address Register Bit 11 */
    word BIT12       :1;                                       /* Flash Address Register Bit 12 */
    word BIT13       :1;                                       /* Flash Address Register Bit 13 */
    word             :1; 
    word             :1; 
  } Bits;
  struct {
    word grpBIT  :14;
    word         :1;
    word         :1;
  } MergedBits;
} FADDRSTR;
extern volatile FADDRSTR _FADDR @(REG_BASE + 0x00000108UL);
#define FADDR                           _FADDR.Word
#define FADDR_BIT0                      _FADDR.Bits.BIT0
#define FADDR_BIT1                      _FADDR.Bits.BIT1
#define FADDR_BIT2                      _FADDR.Bits.BIT2
#define FADDR_BIT3                      _FADDR.Bits.BIT3
#define FADDR_BIT4                      _FADDR.Bits.BIT4
#define FADDR_BIT5                      _FADDR.Bits.BIT5
#define FADDR_BIT6                      _FADDR.Bits.BIT6
#define FADDR_BIT7                      _FADDR.Bits.BIT7
#define FADDR_BIT8                      _FADDR.Bits.BIT8
#define FADDR_BIT9                      _FADDR.Bits.BIT9
#define FADDR_BIT10                     _FADDR.Bits.BIT10
#define FADDR_BIT11                     _FADDR.Bits.BIT11
#define FADDR_BIT12                     _FADDR.Bits.BIT12
#define FADDR_BIT13                     _FADDR.Bits.BIT13
#define FADDR_BIT                       _FADDR.MergedBits.grpBIT

#define FADDR_BIT0_MASK                 1U
#define FADDR_BIT1_MASK                 2U
#define FADDR_BIT2_MASK                 4U
#define FADDR_BIT3_MASK                 8U
#define FADDR_BIT4_MASK                 16U
#define FADDR_BIT5_MASK                 32U
#define FADDR_BIT6_MASK                 64U
#define FADDR_BIT7_MASK                 128U
#define FADDR_BIT8_MASK                 256U
#define FADDR_BIT9_MASK                 512U
#define FADDR_BIT10_MASK                1024U
#define FADDR_BIT11_MASK                2048U
#define FADDR_BIT12_MASK                4096U
#define FADDR_BIT13_MASK                8192U
#define FADDR_BIT_MASK                  16383U
#define FADDR_BIT_BITNUM                0U


/*** FDATA - Flash Data Register (high; 0x0000010A ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** FDATAHi - Flash Data Register (high byte); 0x0000010A ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Flash data Register Bit 8 */
        byte BIT9        :1;                                       /* Flash data Register Bit 9 */
        byte BIT10       :1;                                       /* Flash data Register Bit 10 */
        byte BIT11       :1;                                       /* Flash data Register Bit 11 */
        byte BIT12       :1;                                       /* Flash data Register Bit 12 */
        byte BIT13       :1;                                       /* Flash data Register Bit 13 */
        byte BIT14       :1;                                       /* Flash data Register Bit 14 */
        byte BIT15       :1;                                       /* Flash data Register Bit 15 */
      } Bits;
    } FDATAHiSTR;
    #define FDATAHi                     _FDATA.Overlap_STR.FDATAHiSTR.Byte
    #define FDATAHi_BIT8                _FDATA.Overlap_STR.FDATAHiSTR.Bits.BIT8
    #define FDATAHi_BIT9                _FDATA.Overlap_STR.FDATAHiSTR.Bits.BIT9
    #define FDATAHi_BIT10               _FDATA.Overlap_STR.FDATAHiSTR.Bits.BIT10
    #define FDATAHi_BIT11               _FDATA.Overlap_STR.FDATAHiSTR.Bits.BIT11
    #define FDATAHi_BIT12               _FDATA.Overlap_STR.FDATAHiSTR.Bits.BIT12
    #define FDATAHi_BIT13               _FDATA.Overlap_STR.FDATAHiSTR.Bits.BIT13
    #define FDATAHi_BIT14               _FDATA.Overlap_STR.FDATAHiSTR.Bits.BIT14
    #define FDATAHi_BIT15               _FDATA.Overlap_STR.FDATAHiSTR.Bits.BIT15
    
    #define FDATAHi_BIT8_MASK           1U
    #define FDATAHi_BIT9_MASK           2U
    #define FDATAHi_BIT10_MASK          4U
    #define FDATAHi_BIT11_MASK          8U
    #define FDATAHi_BIT12_MASK          16U
    #define FDATAHi_BIT13_MASK          32U
    #define FDATAHi_BIT14_MASK          64U
    #define FDATAHi_BIT15_MASK          128U
    

    /*** FDATALo - Flash Data Register (low byte); 0x0000010B ***/
    union {
      byte Byte;
      struct {
        byte BIT0        :1;                                       /* Flash data Register Bit 0 */
        byte BIT1        :1;                                       /* Flash data Register Bit 1 */
        byte BIT2        :1;                                       /* Flash data Register Bit 2 */
        byte BIT3        :1;                                       /* Flash data Register Bit 3 */
        byte BIT4        :1;                                       /* Flash data Register Bit 4 */
        byte BIT5        :1;                                       /* Flash data Register Bit 5 */
        byte BIT6        :1;                                       /* Flash data Register Bit 6 */
        byte BIT7        :1;                                       /* Flash data Register Bit 7 */
      } Bits;
    } FDATALoSTR;
    #define FDATALo                     _FDATA.Overlap_STR.FDATALoSTR.Byte
    #define FDATALo_BIT0                _FDATA.Overlap_STR.FDATALoSTR.Bits.BIT0
    #define FDATALo_BIT1                _FDATA.Overlap_STR.FDATALoSTR.Bits.BIT1
    #define FDATALo_BIT2                _FDATA.Overlap_STR.FDATALoSTR.Bits.BIT2
    #define FDATALo_BIT3                _FDATA.Overlap_STR.FDATALoSTR.Bits.BIT3
    #define FDATALo_BIT4                _FDATA.Overlap_STR.FDATALoSTR.Bits.BIT4
    #define FDATALo_BIT5                _FDATA.Overlap_STR.FDATALoSTR.Bits.BIT5
    #define FDATALo_BIT6                _FDATA.Overlap_STR.FDATALoSTR.Bits.BIT6
    #define FDATALo_BIT7                _FDATA.Overlap_STR.FDATALoSTR.Bits.BIT7
    
    #define FDATALo_BIT0_MASK           1U
    #define FDATALo_BIT1_MASK           2U
    #define FDATALo_BIT2_MASK           4U
    #define FDATALo_BIT3_MASK           8U
    #define FDATALo_BIT4_MASK           16U
    #define FDATALo_BIT5_MASK           32U
    #define FDATALo_BIT6_MASK           64U
    #define FDATALo_BIT7_MASK           128U
    
  } Overlap_STR;

  struct {
    word BIT0        :1;                                       /* Flash data Register Bit 0 */
    word BIT1        :1;                                       /* Flash data Register Bit 1 */
    word BIT2        :1;                                       /* Flash data Register Bit 2 */
    word BIT3        :1;                                       /* Flash data Register Bit 3 */
    word BIT4        :1;                                       /* Flash data Register Bit 4 */
    word BIT5        :1;                                       /* Flash data Register Bit 5 */
    word BIT6        :1;                                       /* Flash data Register Bit 6 */
    word BIT7        :1;                                       /* Flash data Register Bit 7 */
    word BIT8        :1;                                       /* Flash data Register Bit 8 */
    word BIT9        :1;                                       /* Flash data Register Bit 9 */
    word BIT10       :1;                                       /* Flash data Register Bit 10 */
    word BIT11       :1;                                       /* Flash data Register Bit 11 */
    word BIT12       :1;                                       /* Flash data Register Bit 12 */
    word BIT13       :1;                                       /* Flash data Register Bit 13 */
    word BIT14       :1;                                       /* Flash data Register Bit 14 */
    word BIT15       :1;                                       /* Flash data Register Bit 15 */
  } Bits;
} FDATASTR;
extern volatile FDATASTR _FDATA @(REG_BASE + 0x0000010AUL);
#define FDATA                           _FDATA.Word
#define FDATA_BIT0                      _FDATA.Bits.BIT0
#define FDATA_BIT1                      _FDATA.Bits.BIT1
#define FDATA_BIT2                      _FDATA.Bits.BIT2
#define FDATA_BIT3                      _FDATA.Bits.BIT3
#define FDATA_BIT4                      _FDATA.Bits.BIT4
#define FDATA_BIT5                      _FDATA.Bits.BIT5
#define FDATA_BIT6                      _FDATA.Bits.BIT6
#define FDATA_BIT7                      _FDATA.Bits.BIT7
#define FDATA_BIT8                      _FDATA.Bits.BIT8
#define FDATA_BIT9                      _FDATA.Bits.BIT9
#define FDATA_BIT10                     _FDATA.Bits.BIT10
#define FDATA_BIT11                     _FDATA.Bits.BIT11
#define FDATA_BIT12                     _FDATA.Bits.BIT12
#define FDATA_BIT13                     _FDATA.Bits.BIT13
#define FDATA_BIT14                     _FDATA.Bits.BIT14
#define FDATA_BIT15                     _FDATA.Bits.BIT15

#define FDATA_BIT0_MASK                 1U
#define FDATA_BIT1_MASK                 2U
#define FDATA_BIT2_MASK                 4U
#define FDATA_BIT3_MASK                 8U
#define FDATA_BIT4_MASK                 16U
#define FDATA_BIT5_MASK                 32U
#define FDATA_BIT6_MASK                 64U
#define FDATA_BIT7_MASK                 128U
#define FDATA_BIT8_MASK                 256U
#define FDATA_BIT9_MASK                 512U
#define FDATA_BIT10_MASK                1024U
#define FDATA_BIT11_MASK                2048U
#define FDATA_BIT12_MASK                4096U
#define FDATA_BIT13_MASK                8192U
#define FDATA_BIT14_MASK                16384U
#define FDATA_BIT15_MASK                32768U


/*** SMRAMCFG - SMRAM Configuration Register; 0x0000011C ***/
typedef union {
  byte Byte;
  struct {
    byte SMMODE      :1;                                       /* SmartMedia mode */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} SMRAMCFGSTR;
extern volatile SMRAMCFGSTR _SMRAMCFG @(REG_BASE + 0x0000011CUL);
#define SMRAMCFG                        _SMRAMCFG.Byte
#define SMRAMCFG_SMMODE                 _SMRAMCFG.Bits.SMMODE

#define SMRAMCFG_SMMODE_MASK            1U


/*** SMRAMSTAT - SMRAM Status Register; 0x0000011D ***/
typedef union {
  byte Byte;
  struct {
    byte PSMBA       :1;                                       /* Parity of the SmartMedia Block Address */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} SMRAMSTATSTR;
extern volatile SMRAMSTATSTR _SMRAMSTAT @(REG_BASE + 0x0000011DUL);
#define SMRAMSTAT                       _SMRAMSTAT.Byte
#define SMRAMSTAT_PSMBA                 _SMRAMSTAT.Bits.PSMBA

#define SMRAMSTAT_PSMBA_MASK            1U


/*** HCFG - Host Configuration Register; 0x000001C0 ***/
typedef union {
  word Word;
  struct {
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word IORDY_EN    :1;                                       /* Enable ATA_IORDY function */
    word IE          :1;                                       /* Interrupt Enable */
    word XNW         :1;                                       /* IPS_XFR_WAIT support */
    word CLK_EN      :1;                                       /* module core clock Enable function */
    word             :1; 
    word             :1; 
    word FR          :1;                                       /* FIFO Reset */
    word SMR         :1;                                       /* State Machine Reset */
  } Bits;
} HCFGSTR;
extern volatile HCFGSTR _HCFG @(REG_BASE + 0x000001C0UL);
#define HCFG                            _HCFG.Word
#define HCFG_IORDY_EN                   _HCFG.Bits.IORDY_EN
#define HCFG_IE                         _HCFG.Bits.IE
#define HCFG_XNW                        _HCFG.Bits.XNW
#define HCFG_CLK_EN                     _HCFG.Bits.CLK_EN
#define HCFG_FR                         _HCFG.Bits.FR
#define HCFG_SMR                        _HCFG.Bits.SMR

#define HCFG_IORDY_EN_MASK              256U
#define HCFG_IE_MASK                    512U
#define HCFG_XNW_MASK                   1024U
#define HCFG_CLK_EN_MASK                2048U
#define HCFG_FR_MASK                    16384U
#define HCFG_SMR_MASK                   32768U


/*** HSR - Host Status Register; 0x000001C2 ***/
typedef union {
  word Word;
  struct {
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word WERR        :1;                                       /* Write on unimplemented register(Read only, clear by writing one) */
    word RERR        :1;                                       /* Read on unimplemented register(Read only, clear by writing one) */
    word FE_HSR      :1;                                       /* FIFO Empty Flag */
    word FF          :1;                                       /* FIFO Full Flag */
    word             :1; 
    word DRAB        :1;                                       /* Device Register Access Busy (Read only) */
    word UREP        :1;                                       /* UDMA Read extended pause */
    word TIP         :1;                                       /* transfer in progress */
  } Bits;
} HSRSTR;
extern volatile HSRSTR _HSR @(REG_BASE + 0x000001C2UL);
#define HSR                             _HSR.Word
#define HSR_WERR                        _HSR.Bits.WERR
#define HSR_RERR                        _HSR.Bits.RERR
#define HSR_FE_HSR                      _HSR.Bits.FE_HSR
#define HSR_FF                          _HSR.Bits.FF
#define HSR_DRAB                        _HSR.Bits.DRAB
#define HSR_UREP                        _HSR.Bits.UREP
#define HSR_TIP                         _HSR.Bits.TIP

#define HSR_WERR_MASK                   256U
#define HSR_RERR_MASK                   512U
#define HSR_FE_HSR_MASK                 1024U
#define HSR_FF_MASK                     2048U
#define HSR_DRAB_MASK                   8192U
#define HSR_UREP_MASK                   16384U
#define HSR_TIP_MASK                    32768U


/*** HPIO1 - PIO Timing Register 1; 0x000001C4 ***/
typedef union {
  word Word;
  struct {
    word PIO_T2_80   :1;                                       /* ATA-5 standard PIO timing t2 for 8-bit transfer Bit 0 */
    word PIO_T2_81   :1;                                       /* ATA-5 standard PIO timing t2 for 8-bit transfer Bit 1 */
    word PIO_T2_82   :1;                                       /* ATA-5 standard PIO timing t2 for 8-bit transfer Bit 2 */
    word PIO_T2_83   :1;                                       /* ATA-5 standard PIO timing t2 for 8-bit transfer Bit 3 */
    word PIO_T2_84   :1;                                       /* ATA-5 standard PIO timing t2 for 8-bit transfer Bit 4 */
    word PIO_T2_85   :1;                                       /* ATA-5 standard PIO timing t2 for 8-bit transfer Bit 5 */
    word             :1; 
    word             :1; 
    word PIO_T00     :1;                                       /* ATA-5 standard PIO timing t0 Bit 0 */
    word PIO_T01     :1;                                       /* ATA-5 standard PIO timing t0 Bit 1 */
    word PIO_T02     :1;                                       /* ATA-5 standard PIO timing t0 Bit 2 */
    word PIO_T03     :1;                                       /* ATA-5 standard PIO timing t0 Bit 3 */
    word PIO_T04     :1;                                       /* ATA-5 standard PIO timing t0 Bit 4 */
    word PIO_T05     :1;                                       /* ATA-5 standard PIO timing t0 Bit 5 */
    word PIO_T06     :1;                                       /* ATA-5 standard PIO timing t0 Bit 6 */
    word             :1; 
  } Bits;
  struct {
    word grpPIO_T2__80 :6;
    word         :1;
    word         :1;
    word grpPIO_T0 :7;
    word         :1;
  } MergedBits;
} HPIO1STR;
extern volatile HPIO1STR _HPIO1 @(REG_BASE + 0x000001C4UL);
#define HPIO1                           _HPIO1.Word
#define HPIO1_PIO_T2_80                 _HPIO1.Bits.PIO_T2_80
#define HPIO1_PIO_T2_81                 _HPIO1.Bits.PIO_T2_81
#define HPIO1_PIO_T2_82                 _HPIO1.Bits.PIO_T2_82
#define HPIO1_PIO_T2_83                 _HPIO1.Bits.PIO_T2_83
#define HPIO1_PIO_T2_84                 _HPIO1.Bits.PIO_T2_84
#define HPIO1_PIO_T2_85                 _HPIO1.Bits.PIO_T2_85
#define HPIO1_PIO_T00                   _HPIO1.Bits.PIO_T00
#define HPIO1_PIO_T01                   _HPIO1.Bits.PIO_T01
#define HPIO1_PIO_T02                   _HPIO1.Bits.PIO_T02
#define HPIO1_PIO_T03                   _HPIO1.Bits.PIO_T03
#define HPIO1_PIO_T04                   _HPIO1.Bits.PIO_T04
#define HPIO1_PIO_T05                   _HPIO1.Bits.PIO_T05
#define HPIO1_PIO_T06                   _HPIO1.Bits.PIO_T06
#define HPIO1_PIO_T2__80                _HPIO1.MergedBits.grpPIO_T2__80
#define HPIO1_PIO_T0                    _HPIO1.MergedBits.grpPIO_T0
#define HPIO1_PIO_T2_                   HPIO1_PIO_T2__80

#define HPIO1_PIO_T2_80_MASK            1U
#define HPIO1_PIO_T2_81_MASK            2U
#define HPIO1_PIO_T2_82_MASK            4U
#define HPIO1_PIO_T2_83_MASK            8U
#define HPIO1_PIO_T2_84_MASK            16U
#define HPIO1_PIO_T2_85_MASK            32U
#define HPIO1_PIO_T00_MASK              256U
#define HPIO1_PIO_T01_MASK              512U
#define HPIO1_PIO_T02_MASK              1024U
#define HPIO1_PIO_T03_MASK              2048U
#define HPIO1_PIO_T04_MASK              4096U
#define HPIO1_PIO_T05_MASK              8192U
#define HPIO1_PIO_T06_MASK              16384U
#define HPIO1_PIO_T2__80_MASK           63U
#define HPIO1_PIO_T2__80_BITNUM         0U
#define HPIO1_PIO_T0_MASK               32512U
#define HPIO1_PIO_T0_BITNUM             8U


/*** HPIO2 - PIO Timing Register 2; 0x000001C6 ***/
typedef union {
  word Word;
  struct {
    word PIO_T2I0    :1;                                       /* ATA-5 standard PIO timing t2i Bit 0 */
    word PIO_T2I1    :1;                                       /* ATA-5 standard PIO timing t2i Bit 1 */
    word PIO_T2I2    :1;                                       /* ATA-5 standard PIO timing t2i Bit 2 */
    word PIO_T2I3    :1;                                       /* ATA-5 standard PIO timing t2i Bit 3 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word PIO_T2_160  :1;                                       /* ATA-5 standard PIO timing t2 for 16-bit transfer Bit 0 */
    word PIO_T2_161  :1;                                       /* ATA-5 standard PIO timing t2 for 16-bit transfer Bit 1 */
    word PIO_T2_162  :1;                                       /* ATA-5 standard PIO timing t2 for 16-bit transfer Bit 2 */
    word PIO_T2_163  :1;                                       /* ATA-5 standard PIO timing t2 for 16-bit transfer Bit 3 */
    word PIO_T2_164  :1;                                       /* ATA-5 standard PIO timing t2 for 16-bit transfer Bit 4 */
    word PIO_T2_165  :1;                                       /* ATA-5 standard PIO timing t2 for 16-bit transfer Bit 5 */
    word             :1; 
    word             :1; 
  } Bits;
  struct {
    word grpPIO_T2I :4;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpPIO_T2_1_60 :6;
    word         :1;
    word         :1;
  } MergedBits;
} HPIO2STR;
extern volatile HPIO2STR _HPIO2 @(REG_BASE + 0x000001C6UL);
#define HPIO2                           _HPIO2.Word
#define HPIO2_PIO_T2I0                  _HPIO2.Bits.PIO_T2I0
#define HPIO2_PIO_T2I1                  _HPIO2.Bits.PIO_T2I1
#define HPIO2_PIO_T2I2                  _HPIO2.Bits.PIO_T2I2
#define HPIO2_PIO_T2I3                  _HPIO2.Bits.PIO_T2I3
#define HPIO2_PIO_T2_160                _HPIO2.Bits.PIO_T2_160
#define HPIO2_PIO_T2_161                _HPIO2.Bits.PIO_T2_161
#define HPIO2_PIO_T2_162                _HPIO2.Bits.PIO_T2_162
#define HPIO2_PIO_T2_163                _HPIO2.Bits.PIO_T2_163
#define HPIO2_PIO_T2_164                _HPIO2.Bits.PIO_T2_164
#define HPIO2_PIO_T2_165                _HPIO2.Bits.PIO_T2_165
#define HPIO2_PIO_T2I                   _HPIO2.MergedBits.grpPIO_T2I
#define HPIO2_PIO_T2_1_60               _HPIO2.MergedBits.grpPIO_T2_1_60
#define HPIO2_PIO_T2_1                  HPIO2_PIO_T2_1_60

#define HPIO2_PIO_T2I0_MASK             1U
#define HPIO2_PIO_T2I1_MASK             2U
#define HPIO2_PIO_T2I2_MASK             4U
#define HPIO2_PIO_T2I3_MASK             8U
#define HPIO2_PIO_T2_160_MASK           256U
#define HPIO2_PIO_T2_161_MASK           512U
#define HPIO2_PIO_T2_162_MASK           1024U
#define HPIO2_PIO_T2_163_MASK           2048U
#define HPIO2_PIO_T2_164_MASK           4096U
#define HPIO2_PIO_T2_165_MASK           8192U
#define HPIO2_PIO_T2I_MASK              15U
#define HPIO2_PIO_T2I_BITNUM            0U
#define HPIO2_PIO_T2_1_60_MASK          16128U
#define HPIO2_PIO_T2_1_60_BITNUM        8U


/*** HPIO3 - PIO Timing Register 3; 0x000001C8 ***/
typedef union {
  word Word;
  struct {
    word PIO_T10     :1;                                       /* ATA-5 standard PIO timing t1 Bit 0 */
    word PIO_T11     :1;                                       /* ATA-5 standard PIO timing t1 Bit 1 */
    word PIO_T12     :1;                                       /* ATA-5 standard PIO timing t1 Bit 2 */
    word PIO_T13     :1;                                       /* ATA-5 standard PIO timing t1 Bit 3 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word PIO_T40     :1;                                       /* ATA-5 standard PIO timing t4 Bit 0 */
    word PIO_T41     :1;                                       /* ATA-5 standard PIO timing t4 Bit 1 */
    word PIO_T42     :1;                                       /* ATA-5 standard PIO timing t4 Bit 2 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
  struct {
    word grpPIO_T_10 :4;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpPIO_T_40 :3;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} HPIO3STR;
extern volatile HPIO3STR _HPIO3 @(REG_BASE + 0x000001C8UL);
#define HPIO3                           _HPIO3.Word
#define HPIO3_PIO_T10                   _HPIO3.Bits.PIO_T10
#define HPIO3_PIO_T11                   _HPIO3.Bits.PIO_T11
#define HPIO3_PIO_T12                   _HPIO3.Bits.PIO_T12
#define HPIO3_PIO_T13                   _HPIO3.Bits.PIO_T13
#define HPIO3_PIO_T40                   _HPIO3.Bits.PIO_T40
#define HPIO3_PIO_T41                   _HPIO3.Bits.PIO_T41
#define HPIO3_PIO_T42                   _HPIO3.Bits.PIO_T42
#define HPIO3_PIO_T_10                  _HPIO3.MergedBits.grpPIO_T_10
#define HPIO3_PIO_T_40                  _HPIO3.MergedBits.grpPIO_T_40
#define HPIO3_PIO_T                     HPIO3_PIO_T_10

#define HPIO3_PIO_T10_MASK              1U
#define HPIO3_PIO_T11_MASK              2U
#define HPIO3_PIO_T12_MASK              4U
#define HPIO3_PIO_T13_MASK              8U
#define HPIO3_PIO_T40_MASK              256U
#define HPIO3_PIO_T41_MASK              512U
#define HPIO3_PIO_T42_MASK              1024U
#define HPIO3_PIO_T_10_MASK             15U
#define HPIO3_PIO_T_10_BITNUM           0U
#define HPIO3_PIO_T_40_MASK             1792U
#define HPIO3_PIO_T_40_BITNUM           8U


/*** HPIO4 - PIO Timing Register 4; 0x000001CA ***/
typedef union {
  word Word;
  struct {
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word PIO_TA0     :1;                                       /* ATA-5 standard PIO timing ta Bit 0 */
    word PIO_TA1     :1;                                       /* ATA-5 standard PIO timing ta Bit 1 */
    word PIO_TA2     :1;                                       /* ATA-5 standard PIO timing ta Bit 2 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
  struct {
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpPIO_TA :3;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} HPIO4STR;
extern volatile HPIO4STR _HPIO4 @(REG_BASE + 0x000001CAUL);
#define HPIO4                           _HPIO4.Word
#define HPIO4_PIO_TA0                   _HPIO4.Bits.PIO_TA0
#define HPIO4_PIO_TA1                   _HPIO4.Bits.PIO_TA1
#define HPIO4_PIO_TA2                   _HPIO4.Bits.PIO_TA2
#define HPIO4_PIO_TA                    _HPIO4.MergedBits.grpPIO_TA

#define HPIO4_PIO_TA0_MASK              256U
#define HPIO4_PIO_TA1_MASK              512U
#define HPIO4_PIO_TA2_MASK              1024U
#define HPIO4_PIO_TA_MASK               1792U
#define HPIO4_PIO_TA_BITNUM             8U


/*** HDMA1 - DMA Timing Register 1; 0x000001CC ***/
typedef union {
  word Word;
  struct {
    word DMA_TD0     :1;                                       /* ATA-5 standard DMA timing tD Bit 0 */
    word DMA_TD1     :1;                                       /* ATA-5 standard DMA timing tD Bit 1 */
    word DMA_TD2     :1;                                       /* ATA-5 standard DMA timing tD Bit 2 */
    word DMA_TD3     :1;                                       /* ATA-5 standard DMA timing tD Bit 3 */
    word DMA_TD4     :1;                                       /* ATA-5 standard DMA timing tD Bit 4 */
    word DMA_TD5     :1;                                       /* ATA-5 standard DMA timing tD Bit 5 */
    word             :1; 
    word             :1; 
    word DMA_T00     :1;                                       /* ATA-5 standard DMA timing t0 Bit 0 */
    word DMA_T01     :1;                                       /* ATA-5 standard DMA timing t0 Bit 1 */
    word DMA_T02     :1;                                       /* ATA-5 standard DMA timing t0 Bit 2 */
    word DMA_T03     :1;                                       /* ATA-5 standard DMA timing t0 Bit 3 */
    word DMA_T04     :1;                                       /* ATA-5 standard DMA timing t0 Bit 4 */
    word DMA_T05     :1;                                       /* ATA-5 standard DMA timing t0 Bit 5 */
    word DMA_T06     :1;                                       /* ATA-5 standard DMA timing t0 Bit 6 */
    word             :1; 
  } Bits;
  struct {
    word grpDMA_TD :6;
    word         :1;
    word         :1;
    word grpDMA_T0 :7;
    word         :1;
  } MergedBits;
} HDMA1STR;
extern volatile HDMA1STR _HDMA1 @(REG_BASE + 0x000001CCUL);
#define HDMA1                           _HDMA1.Word
#define HDMA1_DMA_TD0                   _HDMA1.Bits.DMA_TD0
#define HDMA1_DMA_TD1                   _HDMA1.Bits.DMA_TD1
#define HDMA1_DMA_TD2                   _HDMA1.Bits.DMA_TD2
#define HDMA1_DMA_TD3                   _HDMA1.Bits.DMA_TD3
#define HDMA1_DMA_TD4                   _HDMA1.Bits.DMA_TD4
#define HDMA1_DMA_TD5                   _HDMA1.Bits.DMA_TD5
#define HDMA1_DMA_T00                   _HDMA1.Bits.DMA_T00
#define HDMA1_DMA_T01                   _HDMA1.Bits.DMA_T01
#define HDMA1_DMA_T02                   _HDMA1.Bits.DMA_T02
#define HDMA1_DMA_T03                   _HDMA1.Bits.DMA_T03
#define HDMA1_DMA_T04                   _HDMA1.Bits.DMA_T04
#define HDMA1_DMA_T05                   _HDMA1.Bits.DMA_T05
#define HDMA1_DMA_T06                   _HDMA1.Bits.DMA_T06
#define HDMA1_DMA_TD                    _HDMA1.MergedBits.grpDMA_TD
#define HDMA1_DMA_T0                    _HDMA1.MergedBits.grpDMA_T0

#define HDMA1_DMA_TD0_MASK              1U
#define HDMA1_DMA_TD1_MASK              2U
#define HDMA1_DMA_TD2_MASK              4U
#define HDMA1_DMA_TD3_MASK              8U
#define HDMA1_DMA_TD4_MASK              16U
#define HDMA1_DMA_TD5_MASK              32U
#define HDMA1_DMA_T00_MASK              256U
#define HDMA1_DMA_T01_MASK              512U
#define HDMA1_DMA_T02_MASK              1024U
#define HDMA1_DMA_T03_MASK              2048U
#define HDMA1_DMA_T04_MASK              4096U
#define HDMA1_DMA_T05_MASK              8192U
#define HDMA1_DMA_T06_MASK              16384U
#define HDMA1_DMA_TD_MASK               63U
#define HDMA1_DMA_TD_BITNUM             0U
#define HDMA1_DMA_T0_MASK               32512U
#define HDMA1_DMA_T0_BITNUM             8U


/*** HDMA2 - DMA Timing Register 2; 0x000001CE ***/
typedef union {
  word Word;
  struct {
    word DMA_TM0     :1;                                       /* ATA-5 standard DMA timing tm Bit 0 */
    word DMA_TM1     :1;                                       /* ATA-5 standard DMA timing tm Bit 1 */
    word DMA_TM2     :1;                                       /* ATA-5 standard DMA timing tm Bit 2 */
    word DMA_TM3     :1;                                       /* ATA-5 standard DMA timing tm Bit 3 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word DMA_TK0     :1;                                       /* ATA-5 standard DMA timing tK Bit 0 */
    word DMA_TK1     :1;                                       /* ATA-5 standard DMA timing tK Bit 1 */
    word DMA_TK2     :1;                                       /* ATA-5 standard DMA timing tK Bit 2 */
    word DMA_TK3     :1;                                       /* ATA-5 standard DMA timing tK Bit 3 */
    word DMA_TK4     :1;                                       /* ATA-5 standard DMA timing tK Bit 4 */
    word DMA_TK5     :1;                                       /* ATA-5 standard DMA timing tK Bit 5 */
    word             :1; 
    word             :1; 
  } Bits;
  struct {
    word grpDMA_TM :4;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpDMA_TK :6;
    word         :1;
    word         :1;
  } MergedBits;
} HDMA2STR;
extern volatile HDMA2STR _HDMA2 @(REG_BASE + 0x000001CEUL);
#define HDMA2                           _HDMA2.Word
#define HDMA2_DMA_TM0                   _HDMA2.Bits.DMA_TM0
#define HDMA2_DMA_TM1                   _HDMA2.Bits.DMA_TM1
#define HDMA2_DMA_TM2                   _HDMA2.Bits.DMA_TM2
#define HDMA2_DMA_TM3                   _HDMA2.Bits.DMA_TM3
#define HDMA2_DMA_TK0                   _HDMA2.Bits.DMA_TK0
#define HDMA2_DMA_TK1                   _HDMA2.Bits.DMA_TK1
#define HDMA2_DMA_TK2                   _HDMA2.Bits.DMA_TK2
#define HDMA2_DMA_TK3                   _HDMA2.Bits.DMA_TK3
#define HDMA2_DMA_TK4                   _HDMA2.Bits.DMA_TK4
#define HDMA2_DMA_TK5                   _HDMA2.Bits.DMA_TK5
#define HDMA2_DMA_TM                    _HDMA2.MergedBits.grpDMA_TM
#define HDMA2_DMA_TK                    _HDMA2.MergedBits.grpDMA_TK

#define HDMA2_DMA_TM0_MASK              1U
#define HDMA2_DMA_TM1_MASK              2U
#define HDMA2_DMA_TM2_MASK              4U
#define HDMA2_DMA_TM3_MASK              8U
#define HDMA2_DMA_TK0_MASK              256U
#define HDMA2_DMA_TK1_MASK              512U
#define HDMA2_DMA_TK2_MASK              1024U
#define HDMA2_DMA_TK3_MASK              2048U
#define HDMA2_DMA_TK4_MASK              4096U
#define HDMA2_DMA_TK5_MASK              8192U
#define HDMA2_DMA_TM_MASK               15U
#define HDMA2_DMA_TM_BITNUM             0U
#define HDMA2_DMA_TK_MASK               16128U
#define HDMA2_DMA_TK_BITNUM             8U


/*** HDMA3 - DMA Timing Register 3; 0x000001D0 ***/
typedef union {
  word Word;
  struct {
    word DMA_TJ0     :1;                                       /* ATA-5 standard DMA timing tJ Bit 0 */
    word DMA_TJ1     :1;                                       /* ATA-5 standard DMA timing tJ Bit 1 */
    word DMA_TJ2     :1;                                       /* ATA-5 standard DMA timing tJ Bit 2 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word DMA_TH0     :1;                                       /* ATA-5 standard DMA timing tH Bit 0 */
    word DMA_TH1     :1;                                       /* ATA-5 standard DMA timing tH Bit 1 */
    word DMA_TH2     :1;                                       /* ATA-5 standard DMA timing tH Bit 2 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
  struct {
    word grpDMA_TJ :3;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpDMA_TH :3;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} HDMA3STR;
extern volatile HDMA3STR _HDMA3 @(REG_BASE + 0x000001D0UL);
#define HDMA3                           _HDMA3.Word
#define HDMA3_DMA_TJ0                   _HDMA3.Bits.DMA_TJ0
#define HDMA3_DMA_TJ1                   _HDMA3.Bits.DMA_TJ1
#define HDMA3_DMA_TJ2                   _HDMA3.Bits.DMA_TJ2
#define HDMA3_DMA_TH0                   _HDMA3.Bits.DMA_TH0
#define HDMA3_DMA_TH1                   _HDMA3.Bits.DMA_TH1
#define HDMA3_DMA_TH2                   _HDMA3.Bits.DMA_TH2
#define HDMA3_DMA_TJ                    _HDMA3.MergedBits.grpDMA_TJ
#define HDMA3_DMA_TH                    _HDMA3.MergedBits.grpDMA_TH

#define HDMA3_DMA_TJ0_MASK              1U
#define HDMA3_DMA_TJ1_MASK              2U
#define HDMA3_DMA_TJ2_MASK              4U
#define HDMA3_DMA_TH0_MASK              256U
#define HDMA3_DMA_TH1_MASK              512U
#define HDMA3_DMA_TH2_MASK              1024U
#define HDMA3_DMA_TJ_MASK               7U
#define HDMA3_DMA_TJ_BITNUM             0U
#define HDMA3_DMA_TH_MASK               1792U
#define HDMA3_DMA_TH_BITNUM             8U


/*** HDMA4 - DMA Timing Register 4; 0x000001D2 ***/
typedef union {
  word Word;
  struct {
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word DMA_TN0     :1;                                       /* ATA-5 standard DMA timing tN Bit 0 */
    word DMA_TN1     :1;                                       /* ATA-5 standard DMA timing tN Bit 1 */
    word DMA_TN2     :1;                                       /* ATA-5 standard DMA timing tN Bit 2 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
  struct {
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpDMA_TN :3;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} HDMA4STR;
extern volatile HDMA4STR _HDMA4 @(REG_BASE + 0x000001D2UL);
#define HDMA4                           _HDMA4.Word
#define HDMA4_DMA_TN0                   _HDMA4.Bits.DMA_TN0
#define HDMA4_DMA_TN1                   _HDMA4.Bits.DMA_TN1
#define HDMA4_DMA_TN2                   _HDMA4.Bits.DMA_TN2
#define HDMA4_DMA_TN                    _HDMA4.MergedBits.grpDMA_TN

#define HDMA4_DMA_TN0_MASK              256U
#define HDMA4_DMA_TN1_MASK              512U
#define HDMA4_DMA_TN2_MASK              1024U
#define HDMA4_DMA_TN_MASK               1792U
#define HDMA4_DMA_TN_BITNUM             8U


/*** HUDMA1 - UDMA Timing Register 1; 0x000001D4 ***/
typedef union {
  word Word;
  struct {
    word UDMA_TCYC0  :1;                                       /* ATA-5 standard UDMA timing tCYC Bit 0 */
    word UDMA_TCYC1  :1;                                       /* ATA-5 standard UDMA timing tCYC Bit 1 */
    word UDMA_TCYC2  :1;                                       /* ATA-5 standard UDMA timing tCYC Bit 2 */
    word UDMA_TCYC3  :1;                                       /* ATA-5 standard UDMA timing tCYC Bit 3 */
    word UDMA_TCYC4  :1;                                       /* ATA-5 standard UDMA timing tCYC Bit 4 */
    word             :1; 
    word             :1; 
    word             :1; 
    word UDMA_T2CYCTYP0 :1;                                    /* ATA-5 standard UDMA timing t2CYCTYP Bit 0 */
    word UDMA_T2CYCTYP1 :1;                                    /* ATA-5 standard UDMA timing t2CYCTYP Bit 1 */
    word UDMA_T2CYCTYP2 :1;                                    /* ATA-5 standard UDMA timing t2CYCTYP Bit 2 */
    word UDMA_T2CYCTYP3 :1;                                    /* ATA-5 standard UDMA timing t2CYCTYP Bit 3 */
    word UDMA_T2CYCTYP4 :1;                                    /* ATA-5 standard UDMA timing t2CYCTYP Bit 4 */
    word UDMA_T2CYCTYP5 :1;                                    /* ATA-5 standard UDMA timing t2CYCTYP Bit 5 */
    word             :1; 
    word             :1; 
  } Bits;
  struct {
    word grpUDMA_TCYC :5;
    word         :1;
    word         :1;
    word         :1;
    word grpUDMA_T2CYCTYP :6;
    word         :1;
    word         :1;
  } MergedBits;
} HUDMA1STR;
extern volatile HUDMA1STR _HUDMA1 @(REG_BASE + 0x000001D4UL);
#define HUDMA1                          _HUDMA1.Word
#define HUDMA1_UDMA_TCYC0               _HUDMA1.Bits.UDMA_TCYC0
#define HUDMA1_UDMA_TCYC1               _HUDMA1.Bits.UDMA_TCYC1
#define HUDMA1_UDMA_TCYC2               _HUDMA1.Bits.UDMA_TCYC2
#define HUDMA1_UDMA_TCYC3               _HUDMA1.Bits.UDMA_TCYC3
#define HUDMA1_UDMA_TCYC4               _HUDMA1.Bits.UDMA_TCYC4
#define HUDMA1_UDMA_T2CYCTYP0           _HUDMA1.Bits.UDMA_T2CYCTYP0
#define HUDMA1_UDMA_T2CYCTYP1           _HUDMA1.Bits.UDMA_T2CYCTYP1
#define HUDMA1_UDMA_T2CYCTYP2           _HUDMA1.Bits.UDMA_T2CYCTYP2
#define HUDMA1_UDMA_T2CYCTYP3           _HUDMA1.Bits.UDMA_T2CYCTYP3
#define HUDMA1_UDMA_T2CYCTYP4           _HUDMA1.Bits.UDMA_T2CYCTYP4
#define HUDMA1_UDMA_T2CYCTYP5           _HUDMA1.Bits.UDMA_T2CYCTYP5
#define HUDMA1_UDMA_TCYC                _HUDMA1.MergedBits.grpUDMA_TCYC
#define HUDMA1_UDMA_T2CYCTYP            _HUDMA1.MergedBits.grpUDMA_T2CYCTYP

#define HUDMA1_UDMA_TCYC0_MASK          1U
#define HUDMA1_UDMA_TCYC1_MASK          2U
#define HUDMA1_UDMA_TCYC2_MASK          4U
#define HUDMA1_UDMA_TCYC3_MASK          8U
#define HUDMA1_UDMA_TCYC4_MASK          16U
#define HUDMA1_UDMA_T2CYCTYP0_MASK      256U
#define HUDMA1_UDMA_T2CYCTYP1_MASK      512U
#define HUDMA1_UDMA_T2CYCTYP2_MASK      1024U
#define HUDMA1_UDMA_T2CYCTYP3_MASK      2048U
#define HUDMA1_UDMA_T2CYCTYP4_MASK      4096U
#define HUDMA1_UDMA_T2CYCTYP5_MASK      8192U
#define HUDMA1_UDMA_TCYC_MASK           31U
#define HUDMA1_UDMA_TCYC_BITNUM         0U
#define HUDMA1_UDMA_T2CYCTYP_MASK       16128U
#define HUDMA1_UDMA_T2CYCTYP_BITNUM     8U


/*** HUDMA2 - UDMA Timing Register 2; 0x000001D6 ***/
typedef union {
  word Word;
  struct {
    word UDMA_TDH0   :1;                                       /* ATA-5 standard UDMA timing tDH Bit 0 */
    word UDMA_TDH1   :1;                                       /* ATA-5 standard UDMA timing tDH Bit 1 */
    word UDMA_TDH2   :1;                                       /* ATA-5 standard UDMA timing tDH Bit 2 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word UDMA_TDS0   :1;                                       /* ATA-5 standard UDMA timing tDS Bit 0 */
    word UDMA_TDS1   :1;                                       /* ATA-5 standard UDMA timing tDS Bit 1 */
    word UDMA_TDS2   :1;                                       /* ATA-5 standard UDMA timing tDS Bit 2 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
  struct {
    word grpUDMA_TDH :3;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpUDMA_TDS :3;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} HUDMA2STR;
extern volatile HUDMA2STR _HUDMA2 @(REG_BASE + 0x000001D6UL);
#define HUDMA2                          _HUDMA2.Word
#define HUDMA2_UDMA_TDH0                _HUDMA2.Bits.UDMA_TDH0
#define HUDMA2_UDMA_TDH1                _HUDMA2.Bits.UDMA_TDH1
#define HUDMA2_UDMA_TDH2                _HUDMA2.Bits.UDMA_TDH2
#define HUDMA2_UDMA_TDS0                _HUDMA2.Bits.UDMA_TDS0
#define HUDMA2_UDMA_TDS1                _HUDMA2.Bits.UDMA_TDS1
#define HUDMA2_UDMA_TDS2                _HUDMA2.Bits.UDMA_TDS2
#define HUDMA2_UDMA_TDH                 _HUDMA2.MergedBits.grpUDMA_TDH
#define HUDMA2_UDMA_TDS                 _HUDMA2.MergedBits.grpUDMA_TDS

#define HUDMA2_UDMA_TDH0_MASK           1U
#define HUDMA2_UDMA_TDH1_MASK           2U
#define HUDMA2_UDMA_TDH2_MASK           4U
#define HUDMA2_UDMA_TDS0_MASK           256U
#define HUDMA2_UDMA_TDS1_MASK           512U
#define HUDMA2_UDMA_TDS2_MASK           1024U
#define HUDMA2_UDMA_TDH_MASK            7U
#define HUDMA2_UDMA_TDH_BITNUM          0U
#define HUDMA2_UDMA_TDS_MASK            1792U
#define HUDMA2_UDMA_TDS_BITNUM          8U


/*** HUDMA3 - UDMA Timing Register 3; 0x000001D8 ***/
typedef union {
  word Word;
  struct {
    word UDMA_TDVH0  :1;                                       /* ATA-5 standard UDMA timing tDVH Bit 0 */
    word UDMA_TDVH1  :1;                                       /* ATA-5 standard UDMA timing tDVH Bit 1 */
    word UDMA_TDVH2  :1;                                       /* ATA-5 standard UDMA timing tDVH Bit 2 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word UDMA_TDVS0  :1;                                       /* ATA-5 standard UDMA timing tDVS Bit 0 */
    word UDMA_TDVS1  :1;                                       /* ATA-5 standard UDMA timing tDVS Bit 1 */
    word UDMA_TDVS2  :1;                                       /* ATA-5 standard UDMA timing tDVS Bit 2 */
    word UDMA_TDVS3  :1;                                       /* ATA-5 standard UDMA timing tDVS Bit 3 */
    word UDMA_TDVS4  :1;                                       /* ATA-5 standard UDMA timing tDVS Bit 4 */
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
  struct {
    word grpUDMA_TDVH :3;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpUDMA_TDVS :5;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} HUDMA3STR;
extern volatile HUDMA3STR _HUDMA3 @(REG_BASE + 0x000001D8UL);
#define HUDMA3                          _HUDMA3.Word
#define HUDMA3_UDMA_TDVH0               _HUDMA3.Bits.UDMA_TDVH0
#define HUDMA3_UDMA_TDVH1               _HUDMA3.Bits.UDMA_TDVH1
#define HUDMA3_UDMA_TDVH2               _HUDMA3.Bits.UDMA_TDVH2
#define HUDMA3_UDMA_TDVS0               _HUDMA3.Bits.UDMA_TDVS0
#define HUDMA3_UDMA_TDVS1               _HUDMA3.Bits.UDMA_TDVS1
#define HUDMA3_UDMA_TDVS2               _HUDMA3.Bits.UDMA_TDVS2
#define HUDMA3_UDMA_TDVS3               _HUDMA3.Bits.UDMA_TDVS3
#define HUDMA3_UDMA_TDVS4               _HUDMA3.Bits.UDMA_TDVS4
#define HUDMA3_UDMA_TDVH                _HUDMA3.MergedBits.grpUDMA_TDVH
#define HUDMA3_UDMA_TDVS                _HUDMA3.MergedBits.grpUDMA_TDVS

#define HUDMA3_UDMA_TDVH0_MASK          1U
#define HUDMA3_UDMA_TDVH1_MASK          2U
#define HUDMA3_UDMA_TDVH2_MASK          4U
#define HUDMA3_UDMA_TDVS0_MASK          256U
#define HUDMA3_UDMA_TDVS1_MASK          512U
#define HUDMA3_UDMA_TDVS2_MASK          1024U
#define HUDMA3_UDMA_TDVS3_MASK          2048U
#define HUDMA3_UDMA_TDVS4_MASK          4096U
#define HUDMA3_UDMA_TDVH_MASK           7U
#define HUDMA3_UDMA_TDVH_BITNUM         0U
#define HUDMA3_UDMA_TDVS_MASK           7936U
#define HUDMA3_UDMA_TDVS_BITNUM         8U


/*** HUDMA4 - UDMA Timing Register 4; 0x000001DA ***/
typedef union {
  word Word;
  struct {
    word UDMA_TLI0   :1;                                       /* ATA-5 standard UDMA timing tLI Bit 0 */
    word UDMA_TLI1   :1;                                       /* ATA-5 standard UDMA timing tLI Bit 1 */
    word UDMA_TLI2   :1;                                       /* ATA-5 standard UDMA timing tLI Bit 2 */
    word UDMA_TLI3   :1;                                       /* ATA-5 standard UDMA timing tLI Bit 3 */
    word UDMA_TLI4   :1;                                       /* ATA-5 standard UDMA timing tLI Bit 4 */
    word UDMA_TLI5   :1;                                       /* ATA-5 standard UDMA timing tLI Bit 5 */
    word             :1; 
    word             :1; 
    word UDMA_TFS0   :1;                                       /* ATA-5 standard UDMA timing tFS Bit 0 */
    word UDMA_TFS1   :1;                                       /* ATA-5 standard UDMA timing tFS Bit 1 */
    word UDMA_TFS2   :1;                                       /* ATA-5 standard UDMA timing tFS Bit 2 */
    word UDMA_TFS3   :1;                                       /* ATA-5 standard UDMA timing tFS Bit 3 */
    word UDMA_TFS4   :1;                                       /* ATA-5 standard UDMA timing tFS Bit 4 */
    word UDMA_TFS5   :1;                                       /* ATA-5 standard UDMA timing tFS Bit 5 */
    word             :1; 
    word             :1; 
  } Bits;
  struct {
    word grpUDMA_TLI :6;
    word         :1;
    word         :1;
    word grpUDMA_TFS :6;
    word         :1;
    word         :1;
  } MergedBits;
} HUDMA4STR;
extern volatile HUDMA4STR _HUDMA4 @(REG_BASE + 0x000001DAUL);
#define HUDMA4                          _HUDMA4.Word
#define HUDMA4_UDMA_TLI0                _HUDMA4.Bits.UDMA_TLI0
#define HUDMA4_UDMA_TLI1                _HUDMA4.Bits.UDMA_TLI1
#define HUDMA4_UDMA_TLI2                _HUDMA4.Bits.UDMA_TLI2
#define HUDMA4_UDMA_TLI3                _HUDMA4.Bits.UDMA_TLI3
#define HUDMA4_UDMA_TLI4                _HUDMA4.Bits.UDMA_TLI4
#define HUDMA4_UDMA_TLI5                _HUDMA4.Bits.UDMA_TLI5
#define HUDMA4_UDMA_TFS0                _HUDMA4.Bits.UDMA_TFS0
#define HUDMA4_UDMA_TFS1                _HUDMA4.Bits.UDMA_TFS1
#define HUDMA4_UDMA_TFS2                _HUDMA4.Bits.UDMA_TFS2
#define HUDMA4_UDMA_TFS3                _HUDMA4.Bits.UDMA_TFS3
#define HUDMA4_UDMA_TFS4                _HUDMA4.Bits.UDMA_TFS4
#define HUDMA4_UDMA_TFS5                _HUDMA4.Bits.UDMA_TFS5
#define HUDMA4_UDMA_TLI                 _HUDMA4.MergedBits.grpUDMA_TLI
#define HUDMA4_UDMA_TFS                 _HUDMA4.MergedBits.grpUDMA_TFS

#define HUDMA4_UDMA_TLI0_MASK           1U
#define HUDMA4_UDMA_TLI1_MASK           2U
#define HUDMA4_UDMA_TLI2_MASK           4U
#define HUDMA4_UDMA_TLI3_MASK           8U
#define HUDMA4_UDMA_TLI4_MASK           16U
#define HUDMA4_UDMA_TLI5_MASK           32U
#define HUDMA4_UDMA_TFS0_MASK           256U
#define HUDMA4_UDMA_TFS1_MASK           512U
#define HUDMA4_UDMA_TFS2_MASK           1024U
#define HUDMA4_UDMA_TFS3_MASK           2048U
#define HUDMA4_UDMA_TFS4_MASK           4096U
#define HUDMA4_UDMA_TFS5_MASK           8192U
#define HUDMA4_UDMA_TLI_MASK            63U
#define HUDMA4_UDMA_TLI_BITNUM          0U
#define HUDMA4_UDMA_TFS_MASK            16128U
#define HUDMA4_UDMA_TFS_BITNUM          8U


/*** HUDMA5 - UDMA Timing Register 5; 0x000001DC ***/
typedef union {
  word Word;
  struct {
    word UDMA_TAZ0   :1;                                       /* ATA-5 standard UDMA timing tAZ Bit 0 */
    word UDMA_TAZ1   :1;                                       /* ATA-5 standard UDMA timing tAZ Bit 1 */
    word UDMA_TAZ2   :1;                                       /* ATA-5 standard UDMA timing tAZ Bit 2 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word UDMA_TMLI0  :1;                                       /* ATA-5 standard UDMA timing tMLI Bit 0 */
    word UDMA_TMLI1  :1;                                       /* ATA-5 standard UDMA timing tMLI Bit 1 */
    word UDMA_TMLI2  :1;                                       /* ATA-5 standard UDMA timing tMLI Bit 2 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
  struct {
    word grpUDMA_TAZ :3;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpUDMA_TMLI :3;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} HUDMA5STR;
extern volatile HUDMA5STR _HUDMA5 @(REG_BASE + 0x000001DCUL);
#define HUDMA5                          _HUDMA5.Word
#define HUDMA5_UDMA_TAZ0                _HUDMA5.Bits.UDMA_TAZ0
#define HUDMA5_UDMA_TAZ1                _HUDMA5.Bits.UDMA_TAZ1
#define HUDMA5_UDMA_TAZ2                _HUDMA5.Bits.UDMA_TAZ2
#define HUDMA5_UDMA_TMLI0               _HUDMA5.Bits.UDMA_TMLI0
#define HUDMA5_UDMA_TMLI1               _HUDMA5.Bits.UDMA_TMLI1
#define HUDMA5_UDMA_TMLI2               _HUDMA5.Bits.UDMA_TMLI2
#define HUDMA5_UDMA_TAZ                 _HUDMA5.MergedBits.grpUDMA_TAZ
#define HUDMA5_UDMA_TMLI                _HUDMA5.MergedBits.grpUDMA_TMLI

#define HUDMA5_UDMA_TAZ0_MASK           1U
#define HUDMA5_UDMA_TAZ1_MASK           2U
#define HUDMA5_UDMA_TAZ2_MASK           4U
#define HUDMA5_UDMA_TMLI0_MASK          256U
#define HUDMA5_UDMA_TMLI1_MASK          512U
#define HUDMA5_UDMA_TMLI2_MASK          1024U
#define HUDMA5_UDMA_TAZ_MASK            7U
#define HUDMA5_UDMA_TAZ_BITNUM          0U
#define HUDMA5_UDMA_TMLI_MASK           1792U
#define HUDMA5_UDMA_TMLI_BITNUM         8U


/*** HUDMA6 - UDMA Timing Register 6; 0x000001DE ***/
typedef union {
  word Word;
  struct {
    word UDMA_TSR0   :1;                                       /* ATA-5 standard UDMA timing tSR Bit 0 */
    word UDMA_TSR1   :1;                                       /* ATA-5 standard UDMA timing tSR Bit 1 */
    word UDMA_TSR2   :1;                                       /* ATA-5 standard UDMA timing tSR Bit 2 */
    word UDMA_TSR3   :1;                                       /* ATA-5 standard UDMA timing tSR Bit 3 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word UDMA_TENV0  :1;                                       /* ATA-5 standard UDMA timing tENV Bit 0 */
    word UDMA_TENV1  :1;                                       /* ATA-5 standard UDMA timing tENV Bit 1 */
    word UDMA_TENV2  :1;                                       /* ATA-5 standard UDMA timing tENV Bit 2 */
    word UDMA_TENV3  :1;                                       /* ATA-5 standard UDMA timing tENV Bit 3 */
    word UDMA_TENV4  :1;                                       /* ATA-5 standard UDMA timing tENV Bit 4 */
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
  struct {
    word grpUDMA_TSR :4;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpUDMA_TENV :5;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} HUDMA6STR;
extern volatile HUDMA6STR _HUDMA6 @(REG_BASE + 0x000001DEUL);
#define HUDMA6                          _HUDMA6.Word
#define HUDMA6_UDMA_TSR0                _HUDMA6.Bits.UDMA_TSR0
#define HUDMA6_UDMA_TSR1                _HUDMA6.Bits.UDMA_TSR1
#define HUDMA6_UDMA_TSR2                _HUDMA6.Bits.UDMA_TSR2
#define HUDMA6_UDMA_TSR3                _HUDMA6.Bits.UDMA_TSR3
#define HUDMA6_UDMA_TENV0               _HUDMA6.Bits.UDMA_TENV0
#define HUDMA6_UDMA_TENV1               _HUDMA6.Bits.UDMA_TENV1
#define HUDMA6_UDMA_TENV2               _HUDMA6.Bits.UDMA_TENV2
#define HUDMA6_UDMA_TENV3               _HUDMA6.Bits.UDMA_TENV3
#define HUDMA6_UDMA_TENV4               _HUDMA6.Bits.UDMA_TENV4
#define HUDMA6_UDMA_TSR                 _HUDMA6.MergedBits.grpUDMA_TSR
#define HUDMA6_UDMA_TENV                _HUDMA6.MergedBits.grpUDMA_TENV

#define HUDMA6_UDMA_TSR0_MASK           1U
#define HUDMA6_UDMA_TSR1_MASK           2U
#define HUDMA6_UDMA_TSR2_MASK           4U
#define HUDMA6_UDMA_TSR3_MASK           8U
#define HUDMA6_UDMA_TENV0_MASK          256U
#define HUDMA6_UDMA_TENV1_MASK          512U
#define HUDMA6_UDMA_TENV2_MASK          1024U
#define HUDMA6_UDMA_TENV3_MASK          2048U
#define HUDMA6_UDMA_TENV4_MASK          4096U
#define HUDMA6_UDMA_TSR_MASK            15U
#define HUDMA6_UDMA_TSR_BITNUM          0U
#define HUDMA6_UDMA_TENV_MASK           7936U
#define HUDMA6_UDMA_TENV_BITNUM         8U


/*** HUDMA7 - UDMA Timing Register 7; 0x000001E0 ***/
typedef union {
  word Word;
  struct {
    word UDMA_TRFS0  :1;                                       /* ATA-5 standard UDMA timing tRFS Bit 0 */
    word UDMA_TRFS1  :1;                                       /* ATA-5 standard UDMA timing tRFS Bit 1 */
    word UDMA_TRFS2  :1;                                       /* ATA-5 standard UDMA timing tRFS Bit 2 */
    word UDMA_TRFS3  :1;                                       /* ATA-5 standard UDMA timing tRFS Bit 3 */
    word UDMA_TRFS4  :1;                                       /* ATA-5 standard UDMA timing tRFS Bit 4 */
    word             :1; 
    word             :1; 
    word             :1; 
    word UDMA_TSS0   :1;                                       /* ATA-5 standard UDMA timing tSS Bit 0 */
    word UDMA_TSS1   :1;                                       /* ATA-5 standard UDMA timing tSS Bit 1 */
    word UDMA_TSS2   :1;                                       /* ATA-5 standard UDMA timing tSS Bit 2 */
    word UDMA_TSS3   :1;                                       /* ATA-5 standard UDMA timing tSS Bit 3 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
  struct {
    word grpUDMA_TRFS :5;
    word         :1;
    word         :1;
    word         :1;
    word grpUDMA_TSS :4;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} HUDMA7STR;
extern volatile HUDMA7STR _HUDMA7 @(REG_BASE + 0x000001E0UL);
#define HUDMA7                          _HUDMA7.Word
#define HUDMA7_UDMA_TRFS0               _HUDMA7.Bits.UDMA_TRFS0
#define HUDMA7_UDMA_TRFS1               _HUDMA7.Bits.UDMA_TRFS1
#define HUDMA7_UDMA_TRFS2               _HUDMA7.Bits.UDMA_TRFS2
#define HUDMA7_UDMA_TRFS3               _HUDMA7.Bits.UDMA_TRFS3
#define HUDMA7_UDMA_TRFS4               _HUDMA7.Bits.UDMA_TRFS4
#define HUDMA7_UDMA_TSS0                _HUDMA7.Bits.UDMA_TSS0
#define HUDMA7_UDMA_TSS1                _HUDMA7.Bits.UDMA_TSS1
#define HUDMA7_UDMA_TSS2                _HUDMA7.Bits.UDMA_TSS2
#define HUDMA7_UDMA_TSS3                _HUDMA7.Bits.UDMA_TSS3
#define HUDMA7_UDMA_TRFS                _HUDMA7.MergedBits.grpUDMA_TRFS
#define HUDMA7_UDMA_TSS                 _HUDMA7.MergedBits.grpUDMA_TSS

#define HUDMA7_UDMA_TRFS0_MASK          1U
#define HUDMA7_UDMA_TRFS1_MASK          2U
#define HUDMA7_UDMA_TRFS2_MASK          4U
#define HUDMA7_UDMA_TRFS3_MASK          8U
#define HUDMA7_UDMA_TRFS4_MASK          16U
#define HUDMA7_UDMA_TSS0_MASK           256U
#define HUDMA7_UDMA_TSS1_MASK           512U
#define HUDMA7_UDMA_TSS2_MASK           1024U
#define HUDMA7_UDMA_TSS3_MASK           2048U
#define HUDMA7_UDMA_TRFS_MASK           31U
#define HUDMA7_UDMA_TRFS_BITNUM         0U
#define HUDMA7_UDMA_TSS_MASK            3840U
#define HUDMA7_UDMA_TSS_BITNUM          8U


/*** HUDMA8 - UDMA Timing Register 8; 0x000001E2 ***/
typedef union {
  word Word;
  struct {
    word UDMA_TACK0  :1;                                       /* ATA-5 standard UDMA timing tACK Bit 0 */
    word UDMA_TACK1  :1;                                       /* ATA-5 standard UDMA timing tACK Bit 1 */
    word UDMA_TACK2  :1;                                       /* ATA-5 standard UDMA timing tACK Bit 2 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word UDMA_TRP0   :1;                                       /* ATA-5 standard UDMA timing tRP Bit 0 */
    word UDMA_TRP1   :1;                                       /* ATA-5 standard UDMA timing tRP Bit 1 */
    word UDMA_TRP2   :1;                                       /* ATA-5 standard UDMA timing tRP Bit 2 */
    word UDMA_TRP3   :1;                                       /* ATA-5 standard UDMA timing tRP Bit 3 */
    word UDMA_TRP4   :1;                                       /* ATA-5 standard UDMA timing tRP Bit 4 */
    word UDMA_TRP5   :1;                                       /* ATA-5 standard UDMA timing tRP Bit 5 */
    word             :1; 
    word             :1; 
  } Bits;
  struct {
    word grpUDMA_TACK :3;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpUDMA_TRP :6;
    word         :1;
    word         :1;
  } MergedBits;
} HUDMA8STR;
extern volatile HUDMA8STR _HUDMA8 @(REG_BASE + 0x000001E2UL);
#define HUDMA8                          _HUDMA8.Word
#define HUDMA8_UDMA_TACK0               _HUDMA8.Bits.UDMA_TACK0
#define HUDMA8_UDMA_TACK1               _HUDMA8.Bits.UDMA_TACK1
#define HUDMA8_UDMA_TACK2               _HUDMA8.Bits.UDMA_TACK2
#define HUDMA8_UDMA_TRP0                _HUDMA8.Bits.UDMA_TRP0
#define HUDMA8_UDMA_TRP1                _HUDMA8.Bits.UDMA_TRP1
#define HUDMA8_UDMA_TRP2                _HUDMA8.Bits.UDMA_TRP2
#define HUDMA8_UDMA_TRP3                _HUDMA8.Bits.UDMA_TRP3
#define HUDMA8_UDMA_TRP4                _HUDMA8.Bits.UDMA_TRP4
#define HUDMA8_UDMA_TRP5                _HUDMA8.Bits.UDMA_TRP5
#define HUDMA8_UDMA_TACK                _HUDMA8.MergedBits.grpUDMA_TACK
#define HUDMA8_UDMA_TRP                 _HUDMA8.MergedBits.grpUDMA_TRP

#define HUDMA8_UDMA_TACK0_MASK          1U
#define HUDMA8_UDMA_TACK1_MASK          2U
#define HUDMA8_UDMA_TACK2_MASK          4U
#define HUDMA8_UDMA_TRP0_MASK           256U
#define HUDMA8_UDMA_TRP1_MASK           512U
#define HUDMA8_UDMA_TRP2_MASK           1024U
#define HUDMA8_UDMA_TRP3_MASK           2048U
#define HUDMA8_UDMA_TRP4_MASK           4096U
#define HUDMA8_UDMA_TRP5_MASK           8192U
#define HUDMA8_UDMA_TACK_MASK           7U
#define HUDMA8_UDMA_TACK_BITNUM         0U
#define HUDMA8_UDMA_TRP_MASK            16128U
#define HUDMA8_UDMA_TRP_BITNUM          8U


/*** HUDMA9 - UDMA Timing Register 9; 0x000001E4 ***/
typedef union {
  word Word;
  struct {
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word UDMA_TZAH0  :1;                                       /* ATA-5 standard UDMA timing tZAH Bit 0 */
    word UDMA_TZAH1  :1;                                       /* ATA-5 standard UDMA timing tZAH Bit 1 */
    word UDMA_TZAH2  :1;                                       /* ATA-5 standard UDMA timing tZAH Bit 2 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
  struct {
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpUDMA_TZAH :3;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} HUDMA9STR;
extern volatile HUDMA9STR _HUDMA9 @(REG_BASE + 0x000001E4UL);
#define HUDMA9                          _HUDMA9.Word
#define HUDMA9_UDMA_TZAH0               _HUDMA9.Bits.UDMA_TZAH0
#define HUDMA9_UDMA_TZAH1               _HUDMA9.Bits.UDMA_TZAH1
#define HUDMA9_UDMA_TZAH2               _HUDMA9.Bits.UDMA_TZAH2
#define HUDMA9_UDMA_TZAH                _HUDMA9.MergedBits.grpUDMA_TZAH

#define HUDMA9_UDMA_TZAH0_MASK          256U
#define HUDMA9_UDMA_TZAH1_MASK          512U
#define HUDMA9_UDMA_TZAH2_MASK          1024U
#define HUDMA9_UDMA_TZAH_MASK           1792U
#define HUDMA9_UDMA_TZAH_BITNUM         8U


/*** DASR_DCTR - ATA drive device status register; 0x000001EE ***/
typedef union {
  word Word;
  struct {
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word ERR_ZERO    :1;                                       /* Drive error indicator, Mandatory clear bit when written */
    word Bit_0_nIEN  :1;                                       /* Bit 0 of obsolete field, Host controlled interrupt enable */
    word Bit_1_SRST  :1;                                       /* Bit 1 of obsolete field, Host controlled software reset bit */
    word DRQ         :1;                                       /* Drive ready to transfer */
    word DASR_DCTR_12 :1;                                      /* Bit 0 of ATA command dependent field */
    word DASR_DCTR_13 :1;                                      /* Bit 1 of ATA command dependent field */
    word DRDY        :1;                                       /* Drive ready */
    word BSY         :1;                                       /* Drive busy */
  } Bits;
  struct {
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpDASR_DCTR__12 :2;
    word         :1;
    word         :1;
  } MergedBits;
} DASR_DCTRSTR;
extern volatile DASR_DCTRSTR _DASR_DCTR @(REG_BASE + 0x000001EEUL);
#define DASR_DCTR                       _DASR_DCTR.Word
#define DASR_DCTR_ERR_ZERO              _DASR_DCTR.Bits.ERR_ZERO
#define DASR_DCTR_Bit_0_nIEN            _DASR_DCTR.Bits.Bit_0_nIEN
#define DASR_DCTR_Bit_1_SRST            _DASR_DCTR.Bits.Bit_1_SRST
#define DASR_DCTR_DRQ                   _DASR_DCTR.Bits.DRQ
#define DASR_DCTR_DASR_DCTR_12          _DASR_DCTR.Bits.DASR_DCTR_12
#define DASR_DCTR_DASR_DCTR_13          _DASR_DCTR.Bits.DASR_DCTR_13
#define DASR_DCTR_DRDY                  _DASR_DCTR.Bits.DRDY
#define DASR_DCTR_BSY                   _DASR_DCTR.Bits.BSY
#define DASR_DCTR_DASR_DCTR__12         _DASR_DCTR.MergedBits.grpDASR_DCTR__12
#define DASR_DCTR_DASR_DCTR_            DASR_DCTR_DASR_DCTR__12

#define DASR_DCTR_ERR_ZERO_MASK         256U
#define DASR_DCTR_Bit_0_nIEN_MASK       512U
#define DASR_DCTR_Bit_1_SRST_MASK       1024U
#define DASR_DCTR_DRQ_MASK              2048U
#define DASR_DCTR_DASR_DCTR_12_MASK     4096U
#define DASR_DCTR_DASR_DCTR_13_MASK     8192U
#define DASR_DCTR_DRDY_MASK             16384U
#define DASR_DCTR_BSY_MASK              32768U
#define DASR_DCTR_DASR_DCTR__12_MASK    12288U
#define DASR_DCTR_DASR_DCTR__12_BITNUM  12U


/*** DDR - ATA Drive Data Register; 0x000001F0 ***/
typedef union {
  word Word;
  struct {
    word DDR0        :1;                                       /* Odd address byte of drive data Bit 0 */
    word DDR1        :1;                                       /* Odd address byte of drive data Bit 1 */
    word DDR2        :1;                                       /* Odd address byte of drive data Bit 2 */
    word DDR3        :1;                                       /* Odd address byte of drive data Bit 3 */
    word DDR4        :1;                                       /* Odd address byte of drive data Bit 4 */
    word DDR5        :1;                                       /* Odd address byte of drive data Bit 5 */
    word DDR6        :1;                                       /* Odd address byte of drive data Bit 6 */
    word DDR7        :1;                                       /* Odd address byte of drive data Bit 7 */
    word DDR8        :1;                                       /* Even address byte of drive data Bit 0 */
    word DDR9        :1;                                       /* Even address byte of drive data Bit 1 */
    word DDR10       :1;                                       /* Even address byte of drive data Bit 2 */
    word DDR11       :1;                                       /* Even address byte of drive data Bit 3 */
    word DDR12       :1;                                       /* Even address byte of drive data Bit 4 */
    word DDR13       :1;                                       /* Even address byte of drive data Bit 5 */
    word DDR14       :1;                                       /* Even address byte of drive data Bit 6 */
    word DDR15       :1;                                       /* Even address byte of drive data Bit 7 */
  } Bits;
} DDRSTR;
extern volatile DDRSTR _DDR @(REG_BASE + 0x000001F0UL);
#define DDR                             _DDR.Word
#define DDR_DDR0                        _DDR.Bits.DDR0
#define DDR_DDR1                        _DDR.Bits.DDR1
#define DDR_DDR2                        _DDR.Bits.DDR2
#define DDR_DDR3                        _DDR.Bits.DDR3
#define DDR_DDR4                        _DDR.Bits.DDR4
#define DDR_DDR5                        _DDR.Bits.DDR5
#define DDR_DDR6                        _DDR.Bits.DDR6
#define DDR_DDR7                        _DDR.Bits.DDR7
#define DDR_DDR8                        _DDR.Bits.DDR8
#define DDR_DDR9                        _DDR.Bits.DDR9
#define DDR_DDR10                       _DDR.Bits.DDR10
#define DDR_DDR11                       _DDR.Bits.DDR11
#define DDR_DDR12                       _DDR.Bits.DDR12
#define DDR_DDR13                       _DDR.Bits.DDR13
#define DDR_DDR14                       _DDR.Bits.DDR14
#define DDR_DDR15                       _DDR.Bits.DDR15

#define DDR_DDR0_MASK                   1U
#define DDR_DDR1_MASK                   2U
#define DDR_DDR2_MASK                   4U
#define DDR_DDR3_MASK                   8U
#define DDR_DDR4_MASK                   16U
#define DDR_DDR5_MASK                   32U
#define DDR_DDR6_MASK                   64U
#define DDR_DDR7_MASK                   128U
#define DDR_DDR8_MASK                   256U
#define DDR_DDR9_MASK                   512U
#define DDR_DDR10_MASK                  1024U
#define DDR_DDR11_MASK                  2048U
#define DDR_DDR12_MASK                  4096U
#define DDR_DDR13_MASK                  8192U
#define DDR_DDR14_MASK                  16384U
#define DDR_DDR15_MASK                  32768U


/*** DFR_DER - ATA Drive Feature Register; 0x000001F2 ***/
typedef union {
  word Word;
  struct {
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word DFR_DER0    :1;                                       /* ATA command parameters Bit 0, ATA command dependent field Bit 0 */
    word DFR_DER1    :1;                                       /* ATA command parameters Bit 1, ATA command dependent field Bit 1 */
    word DFR_DER2    :1;                                       /* ATA command parameters Bit 2, Drive command aborted */
    word DFR_DER3    :1;                                       /* ATA command parameters Bit 3, ATA command dependent field Bit 11 */
    word DFR_DER4    :1;                                       /* ATA command parameters Bit 4, ATA command dependent field Bit 12 */
    word DFR_DER5    :1;                                       /* ATA command parameters Bit 5, ATA command dependent field Bit 13 */
    word DFR_DER6    :1;                                       /* ATA command parameters Bit 6, ATA command dependent field Bit 14 */
    word DFR_DER7    :1;                                       /* ATA command parameters Bit 7, ATA command dependent field Bit 15 */
  } Bits;
  struct {
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpDFR_DER :8;
  } MergedBits;
} DFR_DERSTR;
extern volatile DFR_DERSTR _DFR_DER @(REG_BASE + 0x000001F2UL);
#define DFR_DER                         _DFR_DER.Word
#define DFR_DER_DFR_DER0                _DFR_DER.Bits.DFR_DER0
#define DFR_DER_DFR_DER1                _DFR_DER.Bits.DFR_DER1
#define DFR_DER_DFR_DER2                _DFR_DER.Bits.DFR_DER2
#define DFR_DER_DFR_DER3                _DFR_DER.Bits.DFR_DER3
#define DFR_DER_DFR_DER4                _DFR_DER.Bits.DFR_DER4
#define DFR_DER_DFR_DER5                _DFR_DER.Bits.DFR_DER5
#define DFR_DER_DFR_DER6                _DFR_DER.Bits.DFR_DER6
#define DFR_DER_DFR_DER7                _DFR_DER.Bits.DFR_DER7
#define DFR_DER_DFR_DER                 _DFR_DER.MergedBits.grpDFR_DER

#define DFR_DER_DFR_DER0_MASK           256U
#define DFR_DER_DFR_DER1_MASK           512U
#define DFR_DER_DFR_DER2_MASK           1024U
#define DFR_DER_DFR_DER3_MASK           2048U
#define DFR_DER_DFR_DER4_MASK           4096U
#define DFR_DER_DFR_DER5_MASK           8192U
#define DFR_DER_DFR_DER6_MASK           16384U
#define DFR_DER_DFR_DER7_MASK           32768U
#define DFR_DER_DFR_DER_MASK            65280U
#define DFR_DER_DFR_DER_BITNUM          8U


/*** DSCR - ATA Drive Sector Count Register; 0x000001F4 ***/
typedef union {
  word Word;
  struct {
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word DSCR8       :1;                                       /* Command dependent content Bit 8 */
    word DSCR9       :1;                                       /* Command dependent content Bit 9 */
    word DSCR10      :1;                                       /* Command dependent content Bit 10 */
    word DSCR11      :1;                                       /* Command dependent content Bit 11 */
    word DSCR12      :1;                                       /* Command dependent content Bit 12 */
    word DSCR13      :1;                                       /* Command dependent content Bit 13 */
    word DSCR14      :1;                                       /* Command dependent content Bit 14 */
    word DSCR15      :1;                                       /* Command dependent content Bit 15 */
  } Bits;
  struct {
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpDSCR_8 :8;
  } MergedBits;
} DSCRSTR;
extern volatile DSCRSTR _DSCR @(REG_BASE + 0x000001F4UL);
#define DSCR                            _DSCR.Word
#define DSCR_DSCR8                      _DSCR.Bits.DSCR8
#define DSCR_DSCR9                      _DSCR.Bits.DSCR9
#define DSCR_DSCR10                     _DSCR.Bits.DSCR10
#define DSCR_DSCR11                     _DSCR.Bits.DSCR11
#define DSCR_DSCR12                     _DSCR.Bits.DSCR12
#define DSCR_DSCR13                     _DSCR.Bits.DSCR13
#define DSCR_DSCR14                     _DSCR.Bits.DSCR14
#define DSCR_DSCR15                     _DSCR.Bits.DSCR15
#define DSCR_DSCR_8                     _DSCR.MergedBits.grpDSCR_8

#define DSCR_DSCR8_MASK                 256U
#define DSCR_DSCR9_MASK                 512U
#define DSCR_DSCR10_MASK                1024U
#define DSCR_DSCR11_MASK                2048U
#define DSCR_DSCR12_MASK                4096U
#define DSCR_DSCR13_MASK                8192U
#define DSCR_DSCR14_MASK                16384U
#define DSCR_DSCR15_MASK                32768U
#define DSCR_DSCR_8_MASK                65280U
#define DSCR_DSCR_8_BITNUM              8U


/*** DSNR - ATA Drive Sector Number Register; 0x000001F6 ***/
typedef union {
  word Word;
  struct {
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word DSNR8       :1;                                       /* Command dependent content Bit 8 */
    word DSNR9       :1;                                       /* Command dependent content Bit 9 */
    word DSNR10      :1;                                       /* Command dependent content Bit 10 */
    word DSNR11      :1;                                       /* Command dependent content Bit 11 */
    word DSNR12      :1;                                       /* Command dependent content Bit 12 */
    word DSNR13      :1;                                       /* Command dependent content Bit 13 */
    word DSNR14      :1;                                       /* Command dependent content Bit 14 */
    word DSNR15      :1;                                       /* Command dependent content Bit 15 */
  } Bits;
  struct {
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpDSNR_8 :8;
  } MergedBits;
} DSNRSTR;
extern volatile DSNRSTR _DSNR @(REG_BASE + 0x000001F6UL);
#define DSNR                            _DSNR.Word
#define DSNR_DSNR8                      _DSNR.Bits.DSNR8
#define DSNR_DSNR9                      _DSNR.Bits.DSNR9
#define DSNR_DSNR10                     _DSNR.Bits.DSNR10
#define DSNR_DSNR11                     _DSNR.Bits.DSNR11
#define DSNR_DSNR12                     _DSNR.Bits.DSNR12
#define DSNR_DSNR13                     _DSNR.Bits.DSNR13
#define DSNR_DSNR14                     _DSNR.Bits.DSNR14
#define DSNR_DSNR15                     _DSNR.Bits.DSNR15
#define DSNR_DSNR_8                     _DSNR.MergedBits.grpDSNR_8

#define DSNR_DSNR8_MASK                 256U
#define DSNR_DSNR9_MASK                 512U
#define DSNR_DSNR10_MASK                1024U
#define DSNR_DSNR11_MASK                2048U
#define DSNR_DSNR12_MASK                4096U
#define DSNR_DSNR13_MASK                8192U
#define DSNR_DSNR14_MASK                16384U
#define DSNR_DSNR15_MASK                32768U
#define DSNR_DSNR_8_MASK                65280U
#define DSNR_DSNR_8_BITNUM              8U


/*** DCLR - ATA Drive Cylinder Low Register; 0x000001F8 ***/
typedef union {
  word Word;
  struct {
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word DCLR8       :1;                                       /* Command dependent content Bit 8 */
    word DCLR9       :1;                                       /* Command dependent content Bit 9 */
    word DCLR10      :1;                                       /* Command dependent content Bit 10 */
    word DCLR11      :1;                                       /* Command dependent content Bit 11 */
    word DCLR12      :1;                                       /* Command dependent content Bit 12 */
    word DCLR13      :1;                                       /* Command dependent content Bit 13 */
    word DCLR14      :1;                                       /* Command dependent content Bit 14 */
    word DCLR15      :1;                                       /* Command dependent content Bit 15 */
  } Bits;
  struct {
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpDCLR_8 :8;
  } MergedBits;
} DCLRSTR;
extern volatile DCLRSTR _DCLR @(REG_BASE + 0x000001F8UL);
#define DCLR                            _DCLR.Word
#define DCLR_DCLR8                      _DCLR.Bits.DCLR8
#define DCLR_DCLR9                      _DCLR.Bits.DCLR9
#define DCLR_DCLR10                     _DCLR.Bits.DCLR10
#define DCLR_DCLR11                     _DCLR.Bits.DCLR11
#define DCLR_DCLR12                     _DCLR.Bits.DCLR12
#define DCLR_DCLR13                     _DCLR.Bits.DCLR13
#define DCLR_DCLR14                     _DCLR.Bits.DCLR14
#define DCLR_DCLR15                     _DCLR.Bits.DCLR15
#define DCLR_DCLR_8                     _DCLR.MergedBits.grpDCLR_8

#define DCLR_DCLR8_MASK                 256U
#define DCLR_DCLR9_MASK                 512U
#define DCLR_DCLR10_MASK                1024U
#define DCLR_DCLR11_MASK                2048U
#define DCLR_DCLR12_MASK                4096U
#define DCLR_DCLR13_MASK                8192U
#define DCLR_DCLR14_MASK                16384U
#define DCLR_DCLR15_MASK                32768U
#define DCLR_DCLR_8_MASK                65280U
#define DCLR_DCLR_8_BITNUM              8U


/*** DCHR - ATA Drive Cylinder High Register; 0x000001FA ***/
typedef union {
  word Word;
  struct {
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word DCHR0       :1;                                       /* Command dependent content Bit 0 */
    word DCHR1       :1;                                       /* Command dependent content Bit 1 */
    word DCHR2       :1;                                       /* Command dependent content Bit 2 */
    word DCHR3       :1;                                       /* Command dependent content Bit 3 */
    word DCHR4       :1;                                       /* Command dependent content Bit 4 */
    word DCHR5       :1;                                       /* Command dependent content Bit 5 */
    word DCHR6       :1;                                       /* Command dependent content Bit 6 */
    word DCHR7       :1;                                       /* Command dependent content Bit 7 */
  } Bits;
  struct {
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpDCHR :8;
  } MergedBits;
} DCHRSTR;
extern volatile DCHRSTR _DCHR @(REG_BASE + 0x000001FAUL);
#define DCHR                            _DCHR.Word
#define DCHR_DCHR0                      _DCHR.Bits.DCHR0
#define DCHR_DCHR1                      _DCHR.Bits.DCHR1
#define DCHR_DCHR2                      _DCHR.Bits.DCHR2
#define DCHR_DCHR3                      _DCHR.Bits.DCHR3
#define DCHR_DCHR4                      _DCHR.Bits.DCHR4
#define DCHR_DCHR5                      _DCHR.Bits.DCHR5
#define DCHR_DCHR6                      _DCHR.Bits.DCHR6
#define DCHR_DCHR7                      _DCHR.Bits.DCHR7
#define DCHR_DCHR                       _DCHR.MergedBits.grpDCHR

#define DCHR_DCHR0_MASK                 256U
#define DCHR_DCHR1_MASK                 512U
#define DCHR_DCHR2_MASK                 1024U
#define DCHR_DCHR3_MASK                 2048U
#define DCHR_DCHR4_MASK                 4096U
#define DCHR_DCHR5_MASK                 8192U
#define DCHR_DCHR6_MASK                 16384U
#define DCHR_DCHR7_MASK                 32768U
#define DCHR_DCHR_MASK                  65280U
#define DCHR_DCHR_BITNUM                8U


/*** DDHR - ATA Drive Device/Head Register; 0x000001FC ***/
typedef union {
  word Word;
  struct {
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word DDHR0       :1;                                       /* Command dependent bit 0 */
    word DDHR1       :1;                                       /* Command dependent bit 1 */
    word DDHR2       :1;                                       /* Command dependent bit 2 */
    word DDHR3       :1;                                       /* Command dependent bit 3 */
    word DEV         :1;                                       /* Bit distinguishes between the drive 0 and drive 1 connected to the ATA */
    word Obs1        :1;                                       /* Obsolete, not used 1 */
    word DDHR4       :1;                                       /* Command dependent bit 4 */
    word Obs2        :1;                                       /* Obsolete, not used 2 */
  } Bits;
  struct {
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpDDHR :4;
    word         :1;
    word grpObs_1 :1;
    word grpDDHR_4 :1;
    word grpObs_2 :1;
  } MergedBits;
} DDHRSTR;
extern volatile DDHRSTR _DDHR @(REG_BASE + 0x000001FCUL);
#define DDHR                            _DDHR.Word
#define DDHR_DDHR0                      _DDHR.Bits.DDHR0
#define DDHR_DDHR1                      _DDHR.Bits.DDHR1
#define DDHR_DDHR2                      _DDHR.Bits.DDHR2
#define DDHR_DDHR3                      _DDHR.Bits.DDHR3
#define DDHR_DEV                        _DDHR.Bits.DEV
#define DDHR_Obs1                       _DDHR.Bits.Obs1
#define DDHR_DDHR4                      _DDHR.Bits.DDHR4
#define DDHR_Obs2                       _DDHR.Bits.Obs2
#define DDHR_DDHR                       _DDHR.MergedBits.grpDDHR

#define DDHR_DDHR0_MASK                 256U
#define DDHR_DDHR1_MASK                 512U
#define DDHR_DDHR2_MASK                 1024U
#define DDHR_DDHR3_MASK                 2048U
#define DDHR_DEV_MASK                   4096U
#define DDHR_Obs1_MASK                  8192U
#define DDHR_DDHR4_MASK                 16384U
#define DDHR_Obs2_MASK                  32768U
#define DDHR_DDHR_MASK                  3840U
#define DDHR_DDHR_BITNUM                8U


/*** DCR_DSR - ATA Drive Command Register; 0x000001FE ***/
typedef union {
  byte Byte;
  struct {
    byte DCR_DSR0    :1;                                       /* Command code being sent to the drive Bit 0 */
    byte DCR_DSR1    :1;                                       /* Command code being sent to the drive Bit 1 */
    byte DCR_DSR2    :1;                                       /* Command code being sent to the drive Bit 2 */
    byte DCR_DSR3    :1;                                       /* Command code being sent to the drive Bit 3 */
    byte DCR_DSR4    :1;                                       /* Command code being sent to the drive Bit 4, Command dependent content Bit 0 */
    byte DCR_DSR5    :1;                                       /* Command code being sent to the drive Bit 5, Command dependent content Bit 1 */
    byte DCR_DSR6    :1;                                       /* Command code being sent to the drive Bit 6,  Indicates that the drive is ready to accept executable commands */
    byte DCR_DSR7    :1;                                       /* Command code being sent to the drive Bit 7,  Indicates that the drive is busy processing a command */
  } Bits;
} DCR_DSRSTR;
extern volatile DCR_DSRSTR _DCR_DSR @(REG_BASE + 0x000001FEUL);
#define DCR_DSR                         _DCR_DSR.Byte
#define DCR_DSR_DCR_DSR0                _DCR_DSR.Bits.DCR_DSR0
#define DCR_DSR_DCR_DSR1                _DCR_DSR.Bits.DCR_DSR1
#define DCR_DSR_DCR_DSR2                _DCR_DSR.Bits.DCR_DSR2
#define DCR_DSR_DCR_DSR3                _DCR_DSR.Bits.DCR_DSR3
#define DCR_DSR_DCR_DSR4                _DCR_DSR.Bits.DCR_DSR4
#define DCR_DSR_DCR_DSR5                _DCR_DSR.Bits.DCR_DSR5
#define DCR_DSR_DCR_DSR6                _DCR_DSR.Bits.DCR_DSR6
#define DCR_DSR_DCR_DSR7                _DCR_DSR.Bits.DCR_DSR7

#define DCR_DSR_DCR_DSR0_MASK           1U
#define DCR_DSR_DCR_DSR1_MASK           2U
#define DCR_DSR_DCR_DSR2_MASK           4U
#define DCR_DSR_DCR_DSR3_MASK           8U
#define DCR_DSR_DCR_DSR4_MASK           16U
#define DCR_DSR_DCR_DSR5_MASK           32U
#define DCR_DSR_DCR_DSR6_MASK           64U
#define DCR_DSR_DCR_DSR7_MASK           128U


/*** HDMAM - ATA DMA mode register; 0x000001FF ***/
typedef union {
  byte Byte;
  struct {
    byte WR          :1;                                       /* Set when WRITE DMA command is issued */
    byte RD          :1;                                       /* Set when READ DMA command is issued */
    byte UDMA        :1;                                       /* Bit is set when UDMA protocol is selected, cleared when multiword DMA protocol is selected */
    byte IE_HDMAM    :1;                                       /* Enable drive interrupt to pass to CPU in DMA/UDMA modes */
    byte             :1; 
    byte AF          :1;                                       /* Automatic FIFO reset for AFIFO sub-block when UDMA or Multiword DMA transfer starts */
    byte HUT         :1;                                       /* Host UDMA burst Terminate */
    byte PIE         :1;                                       /* Pause Interrupt Enable */
  } Bits;
} HDMAMSTR;
extern volatile HDMAMSTR _HDMAM @(REG_BASE + 0x000001FFUL);
#define HDMAM                           _HDMAM.Byte
#define HDMAM_WR                        _HDMAM.Bits.WR
#define HDMAM_RD                        _HDMAM.Bits.RD
#define HDMAM_UDMA                      _HDMAM.Bits.UDMA
#define HDMAM_IE_HDMAM                  _HDMAM.Bits.IE_HDMAM
#define HDMAM_AF                        _HDMAM.Bits.AF
#define HDMAM_HUT                       _HDMAM.Bits.HUT
#define HDMAM_PIE                       _HDMAM.Bits.PIE

#define HDMAM_WR_MASK                   1U
#define HDMAM_RD_MASK                   2U
#define HDMAM_UDMA_MASK                 4U
#define HDMAM_IE_HDMAM_MASK             8U
#define HDMAM_AF_MASK                   32U
#define HDMAM_HUT_MASK                  64U
#define HDMAM_PIE_MASK                  128U


/*** IQUECR - IQUE Module Control Register; 0x00000200 ***/
typedef union {
  byte Byte;
  struct {
    byte IQUEEN      :1;                                       /* IQUE Module Enable */
    byte IQUERST     :1;                                       /* IQUE Module Reset */
    byte             :1; 
    byte QC12DBE     :1;                                       /* QUE channel 1+2 double buffer mode. */
    byte QC34DBE     :1;                                       /* QUE channel 3+4 double buffer mode. */
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} IQUECRSTR;
extern volatile IQUECRSTR _IQUECR @(REG_BASE + 0x00000200UL);
#define IQUECR                          _IQUECR.Byte
#define IQUECR_IQUEEN                   _IQUECR.Bits.IQUEEN
#define IQUECR_IQUERST                  _IQUECR.Bits.IQUERST
#define IQUECR_QC12DBE                  _IQUECR.Bits.QC12DBE
#define IQUECR_QC34DBE                  _IQUECR.Bits.QC34DBE

#define IQUECR_IQUEEN_MASK              1U
#define IQUECR_IQUERST_MASK             2U
#define IQUECR_QC12DBE_MASK             8U
#define IQUECR_QC34DBE_MASK             16U


/*** QC1DR - Queue Channel 1 FIFO Data Port Register; 0x00000202 ***/
typedef union {
  word Word;
  struct {
    word QC1DR0      :1;                                       /* Q1DATA Bit 0 */
    word QC1DR1      :1;                                       /* Q1DATA Bit 1 */
    word QC1DR2      :1;                                       /* Q1DATA Bit 2 */
    word QC1DR3      :1;                                       /* Q1DATA Bit 3 */
    word QC1DR4      :1;                                       /* Q1DATA Bit 4 */
    word QC1DR5      :1;                                       /* Q1DATA Bit 5 */
    word QC1DR6      :1;                                       /* Q1DATA Bit 6 */
    word QC1DR7      :1;                                       /* Q1DATA Bit 7 */
    word QC1DR8      :1;                                       /* Q1DATA Bit 8 */
    word QC1DR9      :1;                                       /* Q1DATA Bit 9 */
    word QC1DR10     :1;                                       /* Q1DATA Bit 10 */
    word QC1DR11     :1;                                       /* Q1DATA Bit 11 */
    word QC1DR12     :1;                                       /* Q1DATA Bit 12 */
    word QC1DR13     :1;                                       /* Q1DATA Bit 13 */
    word QC1DR14     :1;                                       /* Q1DATA Bit 14 */
    word QC1DR15     :1;                                       /* Q1DATA Bit 15 */
  } Bits;
} QC1DRSTR;
extern volatile QC1DRSTR _QC1DR @(REG_BASE + 0x00000202UL);
#define QC1DR                           _QC1DR.Word
#define QC1DR_QC1DR0                    _QC1DR.Bits.QC1DR0
#define QC1DR_QC1DR1                    _QC1DR.Bits.QC1DR1
#define QC1DR_QC1DR2                    _QC1DR.Bits.QC1DR2
#define QC1DR_QC1DR3                    _QC1DR.Bits.QC1DR3
#define QC1DR_QC1DR4                    _QC1DR.Bits.QC1DR4
#define QC1DR_QC1DR5                    _QC1DR.Bits.QC1DR5
#define QC1DR_QC1DR6                    _QC1DR.Bits.QC1DR6
#define QC1DR_QC1DR7                    _QC1DR.Bits.QC1DR7
#define QC1DR_QC1DR8                    _QC1DR.Bits.QC1DR8
#define QC1DR_QC1DR9                    _QC1DR.Bits.QC1DR9
#define QC1DR_QC1DR10                   _QC1DR.Bits.QC1DR10
#define QC1DR_QC1DR11                   _QC1DR.Bits.QC1DR11
#define QC1DR_QC1DR12                   _QC1DR.Bits.QC1DR12
#define QC1DR_QC1DR13                   _QC1DR.Bits.QC1DR13
#define QC1DR_QC1DR14                   _QC1DR.Bits.QC1DR14
#define QC1DR_QC1DR15                   _QC1DR.Bits.QC1DR15

#define QC1DR_QC1DR0_MASK               1U
#define QC1DR_QC1DR1_MASK               2U
#define QC1DR_QC1DR2_MASK               4U
#define QC1DR_QC1DR3_MASK               8U
#define QC1DR_QC1DR4_MASK               16U
#define QC1DR_QC1DR5_MASK               32U
#define QC1DR_QC1DR6_MASK               64U
#define QC1DR_QC1DR7_MASK               128U
#define QC1DR_QC1DR8_MASK               256U
#define QC1DR_QC1DR9_MASK               512U
#define QC1DR_QC1DR10_MASK              1024U
#define QC1DR_QC1DR11_MASK              2048U
#define QC1DR_QC1DR12_MASK              4096U
#define QC1DR_QC1DR13_MASK              8192U
#define QC1DR_QC1DR14_MASK              16384U
#define QC1DR_QC1DR15_MASK              32768U


/*** QC1BP - Queue Channel 1 Begin Pointer; 0x00000204 ***/
typedef union {
  word Word;
  struct {
    word BEGPTR10    :1;                                       /* Begin Pointer for Queue Channel 1 FIFO Bit 0 */
    word BEGPTR11    :1;                                       /* Begin Pointer for Queue Channel 1 FIFO Bit 1 */
    word BEGPTR12    :1;                                       /* Begin Pointer for Queue Channel 1 FIFO Bit 2 */
    word BEGPTR13    :1;                                       /* Begin Pointer for Queue Channel 1 FIFO Bit 3 */
    word BEGPTR14    :1;                                       /* Begin Pointer for Queue Channel 1 FIFO Bit 4 */
    word BEGPTR15    :1;                                       /* Begin Pointer for Queue Channel 1 FIFO Bit 5 */
    word BEGPTR16    :1;                                       /* Begin Pointer for Queue Channel 1 FIFO Bit 6 */
    word BEGPTR17    :1;                                       /* Begin Pointer for Queue Channel 1 FIFO Bit 7 */
    word BEGPTR18    :1;                                       /* Begin Pointer for Queue Channel 1 FIFO Bit 8 */
    word BEGPTR19    :1;                                       /* Begin Pointer for Queue Channel 1 FIFO Bit 9 */
    word BEGPTR110   :1;                                       /* Begin Pointer for Queue Channel 1 FIFO Bit 10 */
    word BEGPTR111   :1;                                       /* Begin Pointer for Queue Channel 1 FIFO Bit 11 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
  struct {
    word grpBEGPTR_10 :10;
    word grpBEGPTR1_10 :2;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} QC1BPSTR;
extern volatile QC1BPSTR _QC1BP @(REG_BASE + 0x00000204UL);
#define QC1BP                           _QC1BP.Word
#define QC1BP_BEGPTR10                  _QC1BP.Bits.BEGPTR10
#define QC1BP_BEGPTR11                  _QC1BP.Bits.BEGPTR11
#define QC1BP_BEGPTR12                  _QC1BP.Bits.BEGPTR12
#define QC1BP_BEGPTR13                  _QC1BP.Bits.BEGPTR13
#define QC1BP_BEGPTR14                  _QC1BP.Bits.BEGPTR14
#define QC1BP_BEGPTR15                  _QC1BP.Bits.BEGPTR15
#define QC1BP_BEGPTR16                  _QC1BP.Bits.BEGPTR16
#define QC1BP_BEGPTR17                  _QC1BP.Bits.BEGPTR17
#define QC1BP_BEGPTR18                  _QC1BP.Bits.BEGPTR18
#define QC1BP_BEGPTR19                  _QC1BP.Bits.BEGPTR19
#define QC1BP_BEGPTR110                 _QC1BP.Bits.BEGPTR110
#define QC1BP_BEGPTR111                 _QC1BP.Bits.BEGPTR111
#define QC1BP_BEGPTR_10                 _QC1BP.MergedBits.grpBEGPTR_10
#define QC1BP_BEGPTR1_10                _QC1BP.MergedBits.grpBEGPTR1_10
#define QC1BP_BEGPTR                    QC1BP_BEGPTR_10
#define QC1BP_BEGPTR1                   QC1BP_BEGPTR1_10

#define QC1BP_BEGPTR10_MASK             1U
#define QC1BP_BEGPTR11_MASK             2U
#define QC1BP_BEGPTR12_MASK             4U
#define QC1BP_BEGPTR13_MASK             8U
#define QC1BP_BEGPTR14_MASK             16U
#define QC1BP_BEGPTR15_MASK             32U
#define QC1BP_BEGPTR16_MASK             64U
#define QC1BP_BEGPTR17_MASK             128U
#define QC1BP_BEGPTR18_MASK             256U
#define QC1BP_BEGPTR19_MASK             512U
#define QC1BP_BEGPTR110_MASK            1024U
#define QC1BP_BEGPTR111_MASK            2048U
#define QC1BP_BEGPTR_10_MASK            1023U
#define QC1BP_BEGPTR_10_BITNUM          0U
#define QC1BP_BEGPTR1_10_MASK           3072U
#define QC1BP_BEGPTR1_10_BITNUM         10U


/*** QC1EP - Queue Channel 1 End Pointer; 0x00000206 ***/
typedef union {
  word Word;
  struct {
    word ENDPTR10    :1;                                       /* End Pointer for Queue Channel 1 FIFO Bit 0 */
    word ENDPTR11    :1;                                       /* End Pointer for Queue Channel 1 FIFO Bit 1 */
    word ENDPTR12    :1;                                       /* End Pointer for Queue Channel 1 FIFO Bit 2 */
    word ENDPTR13    :1;                                       /* End Pointer for Queue Channel 1 FIFO Bit 3 */
    word ENDPTR14    :1;                                       /* End Pointer for Queue Channel 1 FIFO Bit 4 */
    word ENDPTR15    :1;                                       /* End Pointer for Queue Channel 1 FIFO Bit 5 */
    word ENDPTR16    :1;                                       /* End Pointer for Queue Channel 1 FIFO Bit 6 */
    word ENDPTR17    :1;                                       /* End Pointer for Queue Channel 1 FIFO Bit 7 */
    word ENDPTR18    :1;                                       /* End Pointer for Queue Channel 1 FIFO Bit 8 */
    word ENDPTR19    :1;                                       /* End Pointer for Queue Channel 1 FIFO Bit 9 */
    word ENDPTR110   :1;                                       /* End Pointer for Queue Channel 1 FIFO Bit 10 */
    word ENDPTR111   :1;                                       /* End Pointer for Queue Channel 1 FIFO Bit 11 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
  struct {
    word grpENDPTR_10 :10;
    word grpENDPTR1_10 :2;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} QC1EPSTR;
extern volatile QC1EPSTR _QC1EP @(REG_BASE + 0x00000206UL);
#define QC1EP                           _QC1EP.Word
#define QC1EP_ENDPTR10                  _QC1EP.Bits.ENDPTR10
#define QC1EP_ENDPTR11                  _QC1EP.Bits.ENDPTR11
#define QC1EP_ENDPTR12                  _QC1EP.Bits.ENDPTR12
#define QC1EP_ENDPTR13                  _QC1EP.Bits.ENDPTR13
#define QC1EP_ENDPTR14                  _QC1EP.Bits.ENDPTR14
#define QC1EP_ENDPTR15                  _QC1EP.Bits.ENDPTR15
#define QC1EP_ENDPTR16                  _QC1EP.Bits.ENDPTR16
#define QC1EP_ENDPTR17                  _QC1EP.Bits.ENDPTR17
#define QC1EP_ENDPTR18                  _QC1EP.Bits.ENDPTR18
#define QC1EP_ENDPTR19                  _QC1EP.Bits.ENDPTR19
#define QC1EP_ENDPTR110                 _QC1EP.Bits.ENDPTR110
#define QC1EP_ENDPTR111                 _QC1EP.Bits.ENDPTR111
#define QC1EP_ENDPTR_10                 _QC1EP.MergedBits.grpENDPTR_10
#define QC1EP_ENDPTR1_10                _QC1EP.MergedBits.grpENDPTR1_10
#define QC1EP_ENDPTR                    QC1EP_ENDPTR_10
#define QC1EP_ENDPTR1                   QC1EP_ENDPTR1_10

#define QC1EP_ENDPTR10_MASK             1U
#define QC1EP_ENDPTR11_MASK             2U
#define QC1EP_ENDPTR12_MASK             4U
#define QC1EP_ENDPTR13_MASK             8U
#define QC1EP_ENDPTR14_MASK             16U
#define QC1EP_ENDPTR15_MASK             32U
#define QC1EP_ENDPTR16_MASK             64U
#define QC1EP_ENDPTR17_MASK             128U
#define QC1EP_ENDPTR18_MASK             256U
#define QC1EP_ENDPTR19_MASK             512U
#define QC1EP_ENDPTR110_MASK            1024U
#define QC1EP_ENDPTR111_MASK            2048U
#define QC1EP_ENDPTR_10_MASK            1023U
#define QC1EP_ENDPTR_10_BITNUM          0U
#define QC1EP_ENDPTR1_10_MASK           3072U
#define QC1EP_ENDPTR1_10_BITNUM         10U


/*** QC1CR - Queue Channel 1 Control Register; 0x00000208 ***/
typedef union {
  byte Byte;
  struct {
    byte Q1PRST      :1;                                       /* Queue Channel 1 Pointers Reset */
    byte Q1THRU      :1;                                       /* Select Passthrough Mode Involving Queue Channel 1+2 (3+4) */
    byte Q116EN      :1;                                       /* Configure Channel 1 for 16-bit/8-bit Transfers */
    byte Q1SML       :1;                                       /* Queue Channel 1 Small Buffer Select */
    byte Q1EN        :1;                                       /* Queue Channel 1 Enable */
    byte Q1FIE       :1;                                       /* Queue Channel 1 Full Interrupt Enable */
    byte Q1EIE       :1;                                       /* Queue Channel 1 Empty Interrupt Enable */
    byte Q1VIE       :1;                                       /* Queue Channel 1 Valid Interrupt Enable */
  } Bits;
} QC1CRSTR;
extern volatile QC1CRSTR _QC1CR @(REG_BASE + 0x00000208UL);
#define QC1CR                           _QC1CR.Byte
#define QC1CR_Q1PRST                    _QC1CR.Bits.Q1PRST
#define QC1CR_Q1THRU                    _QC1CR.Bits.Q1THRU
#define QC1CR_Q116EN                    _QC1CR.Bits.Q116EN
#define QC1CR_Q1SML                     _QC1CR.Bits.Q1SML
#define QC1CR_Q1EN                      _QC1CR.Bits.Q1EN
#define QC1CR_Q1FIE                     _QC1CR.Bits.Q1FIE
#define QC1CR_Q1EIE                     _QC1CR.Bits.Q1EIE
#define QC1CR_Q1VIE                     _QC1CR.Bits.Q1VIE

#define QC1CR_Q1PRST_MASK               1U
#define QC1CR_Q1THRU_MASK               2U
#define QC1CR_Q116EN_MASK               4U
#define QC1CR_Q1SML_MASK                8U
#define QC1CR_Q1EN_MASK                 16U
#define QC1CR_Q1FIE_MASK                32U
#define QC1CR_Q1EIE_MASK                64U
#define QC1CR_Q1VIE_MASK                128U


/*** QC1SR - Queue Channel 1 Status Register; 0x00000209 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte Q1EIF       :1;                                       /* Queue Channel 1 Empty Interrupt Flag */
    byte Q1FIF       :1;                                       /* Queue Channel 1 Full Interrupt Flag */
    byte Q1VIF       :1;                                       /* Queue Channel 1 Valid Data Interrupt Flag */
    byte Q1ESF       :1;                                       /* Queue Channel 1 Empty Status Flag */
    byte Q1FSF       :1;                                       /* Queue Channel 1 Full Status Flag */
    byte Q1VSF       :1;                                       /* Queue Channel 1 Valid Data Control and Status Flag */
  } Bits;
} QC1SRSTR;
extern volatile QC1SRSTR _QC1SR @(REG_BASE + 0x00000209UL);
#define QC1SR                           _QC1SR.Byte
#define QC1SR_Q1EIF                     _QC1SR.Bits.Q1EIF
#define QC1SR_Q1FIF                     _QC1SR.Bits.Q1FIF
#define QC1SR_Q1VIF                     _QC1SR.Bits.Q1VIF
#define QC1SR_Q1ESF                     _QC1SR.Bits.Q1ESF
#define QC1SR_Q1FSF                     _QC1SR.Bits.Q1FSF
#define QC1SR_Q1VSF                     _QC1SR.Bits.Q1VSF

#define QC1SR_Q1EIF_MASK                4U
#define QC1SR_Q1FIF_MASK                8U
#define QC1SR_Q1VIF_MASK                16U
#define QC1SR_Q1ESF_MASK                32U
#define QC1SR_Q1FSF_MASK                64U
#define QC1SR_Q1VSF_MASK                128U


/*** QC1SZB - Buffer Size/Base Address Register for Queue Channel 1; 0x0000020A ***/
typedef union {
  byte Byte;
  struct {
    byte QBASE0_1    :1;                                       /* Queue Channel 1 Buffer Base Address Bit 0 */
    byte QBASE1_1    :1;                                       /* Queue Channel 1 Buffer Base Address Bit 1 */
    byte QBASE2_1    :1;                                       /* Queue Channel 1 Buffer Base Address Bit 2 */
    byte QBASE3_1    :1;                                       /* Queue Channel 1 Buffer Base Address Bit 3 */
    byte QSIZE0_1    :1;                                       /* Queue Channel 1 Buffer Size Bit 0 */
    byte QSIZE1_1    :1;                                       /* Queue Channel 1 Buffer Size Bit 1 */
    byte QSIZE2_1    :1;                                       /* Queue Channel 1 Buffer Size Bit 2 */
    byte QSIZE3_1    :1;                                       /* Queue Channel 1 Buffer Size Bit 3 */
  } Bits;
} QC1SZBSTR;
extern volatile QC1SZBSTR _QC1SZB @(REG_BASE + 0x0000020AUL);
#define QC1SZB                          _QC1SZB.Byte
#define QC1SZB_QBASE0_1                 _QC1SZB.Bits.QBASE0_1
#define QC1SZB_QBASE1_1                 _QC1SZB.Bits.QBASE1_1
#define QC1SZB_QBASE2_1                 _QC1SZB.Bits.QBASE2_1
#define QC1SZB_QBASE3_1                 _QC1SZB.Bits.QBASE3_1
#define QC1SZB_QSIZE0_1                 _QC1SZB.Bits.QSIZE0_1
#define QC1SZB_QSIZE1_1                 _QC1SZB.Bits.QSIZE1_1
#define QC1SZB_QSIZE2_1                 _QC1SZB.Bits.QSIZE2_1
#define QC1SZB_QSIZE3_1                 _QC1SZB.Bits.QSIZE3_1

#define QC1SZB_QBASE0_1_MASK            1U
#define QC1SZB_QBASE1_1_MASK            2U
#define QC1SZB_QBASE2_1_MASK            4U
#define QC1SZB_QBASE3_1_MASK            8U
#define QC1SZB_QSIZE0_1_MASK            16U
#define QC1SZB_QSIZE1_1_MASK            32U
#define QC1SZB_QSIZE2_1_MASK            64U
#define QC1SZB_QSIZE3_1_MASK            128U


/*** QC1REQ - Queue Channel 1 Request Mapping Register; 0x0000020B ***/
typedef union {
  byte Byte;
  struct {
    byte Q1REQ0      :1;                                       /* Select Peripheral Request for Queue Channel 1 Bit 0 */
    byte Q1REQ1      :1;                                       /* Select Peripheral Request for Queue Channel 1 Bit 1 */
    byte Q1REQ2      :1;                                       /* Select Peripheral Request for Queue Channel 1 Bit 2 */
    byte Q1REQ3      :1;                                       /* Select Peripheral Request for Queue Channel 1 Bit 3 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpQ1REQ :4;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} QC1REQSTR;
extern volatile QC1REQSTR _QC1REQ @(REG_BASE + 0x0000020BUL);
#define QC1REQ                          _QC1REQ.Byte
#define QC1REQ_Q1REQ0                   _QC1REQ.Bits.Q1REQ0
#define QC1REQ_Q1REQ1                   _QC1REQ.Bits.Q1REQ1
#define QC1REQ_Q1REQ2                   _QC1REQ.Bits.Q1REQ2
#define QC1REQ_Q1REQ3                   _QC1REQ.Bits.Q1REQ3
#define QC1REQ_Q1REQ                    _QC1REQ.MergedBits.grpQ1REQ

#define QC1REQ_Q1REQ0_MASK              1U
#define QC1REQ_Q1REQ1_MASK              2U
#define QC1REQ_Q1REQ2_MASK              4U
#define QC1REQ_Q1REQ3_MASK              8U
#define QC1REQ_Q1REQ_MASK               15U
#define QC1REQ_Q1REQ_BITNUM             0U


/*** QC2DR - Queue Channel 2 FIFO Data Port Register; 0x0000020C ***/
typedef union {
  word Word;
  struct {
    word QC2DR0      :1;                                       /* Q2DATA Bit 0 */
    word QC2DR1      :1;                                       /* Q2DATA Bit 1 */
    word QC2DR2      :1;                                       /* Q2DATA Bit 2 */
    word QC2DR3      :1;                                       /* Q2DATA Bit 3 */
    word QC2DR4      :1;                                       /* Q2DATA Bit 4 */
    word QC2DR5      :1;                                       /* Q2DATA Bit 5 */
    word QC2DR6      :1;                                       /* Q2DATA Bit 6 */
    word QC2DR7      :1;                                       /* Q2DATA Bit 7 */
    word QC2DR8      :1;                                       /* Q2DATA Bit 8 */
    word QC2DR9      :1;                                       /* Q2DATA Bit 9 */
    word QC2DR10     :1;                                       /* Q2DATA Bit 10 */
    word QC2DR11     :1;                                       /* Q2DATA Bit 11 */
    word QC2DR12     :1;                                       /* Q2DATA Bit 12 */
    word QC2DR13     :1;                                       /* Q2DATA Bit 13 */
    word QC2DR14     :1;                                       /* Q2DATA Bit 14 */
    word QC2DR15     :1;                                       /* Q2DATA Bit 15 */
  } Bits;
} QC2DRSTR;
extern volatile QC2DRSTR _QC2DR @(REG_BASE + 0x0000020CUL);
#define QC2DR                           _QC2DR.Word
#define QC2DR_QC2DR0                    _QC2DR.Bits.QC2DR0
#define QC2DR_QC2DR1                    _QC2DR.Bits.QC2DR1
#define QC2DR_QC2DR2                    _QC2DR.Bits.QC2DR2
#define QC2DR_QC2DR3                    _QC2DR.Bits.QC2DR3
#define QC2DR_QC2DR4                    _QC2DR.Bits.QC2DR4
#define QC2DR_QC2DR5                    _QC2DR.Bits.QC2DR5
#define QC2DR_QC2DR6                    _QC2DR.Bits.QC2DR6
#define QC2DR_QC2DR7                    _QC2DR.Bits.QC2DR7
#define QC2DR_QC2DR8                    _QC2DR.Bits.QC2DR8
#define QC2DR_QC2DR9                    _QC2DR.Bits.QC2DR9
#define QC2DR_QC2DR10                   _QC2DR.Bits.QC2DR10
#define QC2DR_QC2DR11                   _QC2DR.Bits.QC2DR11
#define QC2DR_QC2DR12                   _QC2DR.Bits.QC2DR12
#define QC2DR_QC2DR13                   _QC2DR.Bits.QC2DR13
#define QC2DR_QC2DR14                   _QC2DR.Bits.QC2DR14
#define QC2DR_QC2DR15                   _QC2DR.Bits.QC2DR15

#define QC2DR_QC2DR0_MASK               1U
#define QC2DR_QC2DR1_MASK               2U
#define QC2DR_QC2DR2_MASK               4U
#define QC2DR_QC2DR3_MASK               8U
#define QC2DR_QC2DR4_MASK               16U
#define QC2DR_QC2DR5_MASK               32U
#define QC2DR_QC2DR6_MASK               64U
#define QC2DR_QC2DR7_MASK               128U
#define QC2DR_QC2DR8_MASK               256U
#define QC2DR_QC2DR9_MASK               512U
#define QC2DR_QC2DR10_MASK              1024U
#define QC2DR_QC2DR11_MASK              2048U
#define QC2DR_QC2DR12_MASK              4096U
#define QC2DR_QC2DR13_MASK              8192U
#define QC2DR_QC2DR14_MASK              16384U
#define QC2DR_QC2DR15_MASK              32768U


/*** QC2BP - Queue Channel 2 Begin Pointer; 0x0000020E ***/
typedef union {
  word Word;
  struct {
    word BEGPTR20    :1;                                       /* Begin Pointer for Queue Channel 2 FIFO Bit 0 */
    word BEGPTR21    :1;                                       /* Begin Pointer for Queue Channel 2 FIFO Bit 1 */
    word BEGPTR22    :1;                                       /* Begin Pointer for Queue Channel 2 FIFO Bit 2 */
    word BEGPTR23    :1;                                       /* Begin Pointer for Queue Channel 2 FIFO Bit 3 */
    word BEGPTR24    :1;                                       /* Begin Pointer for Queue Channel 2 FIFO Bit 4 */
    word BEGPTR25    :1;                                       /* Begin Pointer for Queue Channel 2 FIFO Bit 5 */
    word BEGPTR26    :1;                                       /* Begin Pointer for Queue Channel 2 FIFO Bit 6 */
    word BEGPTR27    :1;                                       /* Begin Pointer for Queue Channel 2 FIFO Bit 7 */
    word BEGPTR28    :1;                                       /* Begin Pointer for Queue Channel 2 FIFO Bit 8 */
    word BEGPTR29    :1;                                       /* Begin Pointer for Queue Channel 2 FIFO Bit 9 */
    word BEGPTR210   :1;                                       /* Begin Pointer for Queue Channel 2 FIFO Bit 10 */
    word BEGPTR211   :1;                                       /* Begin Pointer for Queue Channel 2 FIFO Bit 11 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
  struct {
    word grpBEGPTR_20 :10;
    word grpBEGPTR2_10 :2;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} QC2BPSTR;
extern volatile QC2BPSTR _QC2BP @(REG_BASE + 0x0000020EUL);
#define QC2BP                           _QC2BP.Word
#define QC2BP_BEGPTR20                  _QC2BP.Bits.BEGPTR20
#define QC2BP_BEGPTR21                  _QC2BP.Bits.BEGPTR21
#define QC2BP_BEGPTR22                  _QC2BP.Bits.BEGPTR22
#define QC2BP_BEGPTR23                  _QC2BP.Bits.BEGPTR23
#define QC2BP_BEGPTR24                  _QC2BP.Bits.BEGPTR24
#define QC2BP_BEGPTR25                  _QC2BP.Bits.BEGPTR25
#define QC2BP_BEGPTR26                  _QC2BP.Bits.BEGPTR26
#define QC2BP_BEGPTR27                  _QC2BP.Bits.BEGPTR27
#define QC2BP_BEGPTR28                  _QC2BP.Bits.BEGPTR28
#define QC2BP_BEGPTR29                  _QC2BP.Bits.BEGPTR29
#define QC2BP_BEGPTR210                 _QC2BP.Bits.BEGPTR210
#define QC2BP_BEGPTR211                 _QC2BP.Bits.BEGPTR211
#define QC2BP_BEGPTR_20                 _QC2BP.MergedBits.grpBEGPTR_20
#define QC2BP_BEGPTR2_10                _QC2BP.MergedBits.grpBEGPTR2_10
#define QC2BP_BEGPTR                    QC2BP_BEGPTR_20
#define QC2BP_BEGPTR2                   QC2BP_BEGPTR2_10

#define QC2BP_BEGPTR20_MASK             1U
#define QC2BP_BEGPTR21_MASK             2U
#define QC2BP_BEGPTR22_MASK             4U
#define QC2BP_BEGPTR23_MASK             8U
#define QC2BP_BEGPTR24_MASK             16U
#define QC2BP_BEGPTR25_MASK             32U
#define QC2BP_BEGPTR26_MASK             64U
#define QC2BP_BEGPTR27_MASK             128U
#define QC2BP_BEGPTR28_MASK             256U
#define QC2BP_BEGPTR29_MASK             512U
#define QC2BP_BEGPTR210_MASK            1024U
#define QC2BP_BEGPTR211_MASK            2048U
#define QC2BP_BEGPTR_20_MASK            1023U
#define QC2BP_BEGPTR_20_BITNUM          0U
#define QC2BP_BEGPTR2_10_MASK           3072U
#define QC2BP_BEGPTR2_10_BITNUM         10U


/*** QC2EP - Queue Channel 2 End Pointer; 0x00000210 ***/
typedef union {
  word Word;
  struct {
    word ENDPTR20    :1;                                       /* End Pointer for Queue Channel 2 FIFO Bit 0 */
    word ENDPTR21    :1;                                       /* End Pointer for Queue Channel 2 FIFO Bit 1 */
    word ENDPTR22    :1;                                       /* End Pointer for Queue Channel 2 FIFO Bit 2 */
    word ENDPTR23    :1;                                       /* End Pointer for Queue Channel 2 FIFO Bit 3 */
    word ENDPTR24    :1;                                       /* End Pointer for Queue Channel 2 FIFO Bit 4 */
    word ENDPTR25    :1;                                       /* End Pointer for Queue Channel 2 FIFO Bit 5 */
    word ENDPTR26    :1;                                       /* End Pointer for Queue Channel 2 FIFO Bit 6 */
    word ENDPTR27    :1;                                       /* End Pointer for Queue Channel 2 FIFO Bit 7 */
    word ENDPTR28    :1;                                       /* End Pointer for Queue Channel 2 FIFO Bit 8 */
    word ENDPTR29    :1;                                       /* End Pointer for Queue Channel 2 FIFO Bit 9 */
    word ENDPTR210   :1;                                       /* End Pointer for Queue Channel 2 FIFO Bit 10 */
    word ENDPTR211   :1;                                       /* End Pointer for Queue Channel 2 FIFO Bit 11 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
  struct {
    word grpENDPTR_20 :10;
    word grpENDPTR2_10 :2;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} QC2EPSTR;
extern volatile QC2EPSTR _QC2EP @(REG_BASE + 0x00000210UL);
#define QC2EP                           _QC2EP.Word
#define QC2EP_ENDPTR20                  _QC2EP.Bits.ENDPTR20
#define QC2EP_ENDPTR21                  _QC2EP.Bits.ENDPTR21
#define QC2EP_ENDPTR22                  _QC2EP.Bits.ENDPTR22
#define QC2EP_ENDPTR23                  _QC2EP.Bits.ENDPTR23
#define QC2EP_ENDPTR24                  _QC2EP.Bits.ENDPTR24
#define QC2EP_ENDPTR25                  _QC2EP.Bits.ENDPTR25
#define QC2EP_ENDPTR26                  _QC2EP.Bits.ENDPTR26
#define QC2EP_ENDPTR27                  _QC2EP.Bits.ENDPTR27
#define QC2EP_ENDPTR28                  _QC2EP.Bits.ENDPTR28
#define QC2EP_ENDPTR29                  _QC2EP.Bits.ENDPTR29
#define QC2EP_ENDPTR210                 _QC2EP.Bits.ENDPTR210
#define QC2EP_ENDPTR211                 _QC2EP.Bits.ENDPTR211
#define QC2EP_ENDPTR_20                 _QC2EP.MergedBits.grpENDPTR_20
#define QC2EP_ENDPTR2_10                _QC2EP.MergedBits.grpENDPTR2_10
#define QC2EP_ENDPTR                    QC2EP_ENDPTR_20
#define QC2EP_ENDPTR2                   QC2EP_ENDPTR2_10

#define QC2EP_ENDPTR20_MASK             1U
#define QC2EP_ENDPTR21_MASK             2U
#define QC2EP_ENDPTR22_MASK             4U
#define QC2EP_ENDPTR23_MASK             8U
#define QC2EP_ENDPTR24_MASK             16U
#define QC2EP_ENDPTR25_MASK             32U
#define QC2EP_ENDPTR26_MASK             64U
#define QC2EP_ENDPTR27_MASK             128U
#define QC2EP_ENDPTR28_MASK             256U
#define QC2EP_ENDPTR29_MASK             512U
#define QC2EP_ENDPTR210_MASK            1024U
#define QC2EP_ENDPTR211_MASK            2048U
#define QC2EP_ENDPTR_20_MASK            1023U
#define QC2EP_ENDPTR_20_BITNUM          0U
#define QC2EP_ENDPTR2_10_MASK           3072U
#define QC2EP_ENDPTR2_10_BITNUM         10U


/*** QC2CR - Queue Channel 2 Control Register; 0x00000212 ***/
typedef union {
  byte Byte;
  struct {
    byte Q2PRST      :1;                                       /* Queue Channel 2 Pointers Reset */
    byte             :1; 
    byte Q216EN      :1;                                       /* Configure Channel 2 for 16-bit/8-bit Transfers */
    byte Q2SML       :1;                                       /* Queue Channel 2 Small Buffer Select */
    byte Q2EN        :1;                                       /* Queue Channel 2 Enable */
    byte Q2FIE       :1;                                       /* Queue Channel 2 Full Interrupt Enable */
    byte Q2EIE       :1;                                       /* Queue Channel 2 Empty Interrupt Enable */
    byte Q2VIE       :1;                                       /* Queue Channel 2 Valid Interrupt Enable */
  } Bits;
} QC2CRSTR;
extern volatile QC2CRSTR _QC2CR @(REG_BASE + 0x00000212UL);
#define QC2CR                           _QC2CR.Byte
#define QC2CR_Q2PRST                    _QC2CR.Bits.Q2PRST
#define QC2CR_Q216EN                    _QC2CR.Bits.Q216EN
#define QC2CR_Q2SML                     _QC2CR.Bits.Q2SML
#define QC2CR_Q2EN                      _QC2CR.Bits.Q2EN
#define QC2CR_Q2FIE                     _QC2CR.Bits.Q2FIE
#define QC2CR_Q2EIE                     _QC2CR.Bits.Q2EIE
#define QC2CR_Q2VIE                     _QC2CR.Bits.Q2VIE

#define QC2CR_Q2PRST_MASK               1U
#define QC2CR_Q216EN_MASK               4U
#define QC2CR_Q2SML_MASK                8U
#define QC2CR_Q2EN_MASK                 16U
#define QC2CR_Q2FIE_MASK                32U
#define QC2CR_Q2EIE_MASK                64U
#define QC2CR_Q2VIE_MASK                128U


/*** QC2SR - Queue Channel 2 Status Register; 0x00000213 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte Q2EIF       :1;                                       /* Queue Channel 2 Empty Interrupt Flag */
    byte Q2FIF       :1;                                       /* Queue Channel 2 Full Interrupt Flag */
    byte Q2VIF       :1;                                       /* Queue Channel 2 Valid Data Interrupt Flag */
    byte Q2ESF       :1;                                       /* Queue Channel 2 Empty Status Flag */
    byte Q2FSF       :1;                                       /* Queue Channel 2 Full Status Flag */
    byte Q2VSF       :1;                                       /* Queue Channel 2 Valid Data Control and Status Flag */
  } Bits;
} QC2SRSTR;
extern volatile QC2SRSTR _QC2SR @(REG_BASE + 0x00000213UL);
#define QC2SR                           _QC2SR.Byte
#define QC2SR_Q2EIF                     _QC2SR.Bits.Q2EIF
#define QC2SR_Q2FIF                     _QC2SR.Bits.Q2FIF
#define QC2SR_Q2VIF                     _QC2SR.Bits.Q2VIF
#define QC2SR_Q2ESF                     _QC2SR.Bits.Q2ESF
#define QC2SR_Q2FSF                     _QC2SR.Bits.Q2FSF
#define QC2SR_Q2VSF                     _QC2SR.Bits.Q2VSF

#define QC2SR_Q2EIF_MASK                4U
#define QC2SR_Q2FIF_MASK                8U
#define QC2SR_Q2VIF_MASK                16U
#define QC2SR_Q2ESF_MASK                32U
#define QC2SR_Q2FSF_MASK                64U
#define QC2SR_Q2VSF_MASK                128U


/*** QC2SZB - Buffer Size/Base Address Register for Queue Channel 2; 0x00000214 ***/
typedef union {
  byte Byte;
  struct {
    byte QBASE0_2    :1;                                       /* Queue Channel 2 Buffer Base Address Bit 0 */
    byte QBASE1_2    :1;                                       /* Queue Channel 2 Buffer Base Address Bit 1 */
    byte QBASE2_2    :1;                                       /* Queue Channel 2 Buffer Base Address Bit 2 */
    byte QBASE3_2    :1;                                       /* Queue Channel 2 Buffer Base Address Bit 3 */
    byte QSIZE0_2    :1;                                       /* Queue Channel n Buffer Size Bit 0 */
    byte QSIZE1_2    :1;                                       /* Queue Channel n Buffer Size Bit 1 */
    byte QSIZE2_2    :1;                                       /* Queue Channel n Buffer Size Bit 2 */
    byte QSIZE3_2    :1;                                       /* Queue Channel n Buffer Size Bit 3 */
  } Bits;
} QC2SZBSTR;
extern volatile QC2SZBSTR _QC2SZB @(REG_BASE + 0x00000214UL);
#define QC2SZB                          _QC2SZB.Byte
#define QC2SZB_QBASE0_2                 _QC2SZB.Bits.QBASE0_2
#define QC2SZB_QBASE1_2                 _QC2SZB.Bits.QBASE1_2
#define QC2SZB_QBASE2_2                 _QC2SZB.Bits.QBASE2_2
#define QC2SZB_QBASE3_2                 _QC2SZB.Bits.QBASE3_2
#define QC2SZB_QSIZE0_2                 _QC2SZB.Bits.QSIZE0_2
#define QC2SZB_QSIZE1_2                 _QC2SZB.Bits.QSIZE1_2
#define QC2SZB_QSIZE2_2                 _QC2SZB.Bits.QSIZE2_2
#define QC2SZB_QSIZE3_2                 _QC2SZB.Bits.QSIZE3_2

#define QC2SZB_QBASE0_2_MASK            1U
#define QC2SZB_QBASE1_2_MASK            2U
#define QC2SZB_QBASE2_2_MASK            4U
#define QC2SZB_QBASE3_2_MASK            8U
#define QC2SZB_QSIZE0_2_MASK            16U
#define QC2SZB_QSIZE1_2_MASK            32U
#define QC2SZB_QSIZE2_2_MASK            64U
#define QC2SZB_QSIZE3_2_MASK            128U


/*** QC2REQ - Queue Channel 2 Request Mapping Register; 0x00000215 ***/
typedef union {
  byte Byte;
  struct {
    byte Q2REQ0      :1;                                       /* Select Peripheral Request for Queue Channel 2 Bit 0 */
    byte Q2REQ1      :1;                                       /* Select Peripheral Request for Queue Channel 2 Bit 1 */
    byte Q2REQ2      :1;                                       /* Select Peripheral Request for Queue Channel 2 Bit 2 */
    byte Q2REQ3      :1;                                       /* Select Peripheral Request for Queue Channel 2 Bit 3 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpQ2REQ :4;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} QC2REQSTR;
extern volatile QC2REQSTR _QC2REQ @(REG_BASE + 0x00000215UL);
#define QC2REQ                          _QC2REQ.Byte
#define QC2REQ_Q2REQ0                   _QC2REQ.Bits.Q2REQ0
#define QC2REQ_Q2REQ1                   _QC2REQ.Bits.Q2REQ1
#define QC2REQ_Q2REQ2                   _QC2REQ.Bits.Q2REQ2
#define QC2REQ_Q2REQ3                   _QC2REQ.Bits.Q2REQ3
#define QC2REQ_Q2REQ                    _QC2REQ.MergedBits.grpQ2REQ

#define QC2REQ_Q2REQ0_MASK              1U
#define QC2REQ_Q2REQ1_MASK              2U
#define QC2REQ_Q2REQ2_MASK              4U
#define QC2REQ_Q2REQ3_MASK              8U
#define QC2REQ_Q2REQ_MASK               15U
#define QC2REQ_Q2REQ_BITNUM             0U


/*** QC3DR - Queue Channel 3 FIFO Data Port Register; 0x00000216 ***/
typedef union {
  word Word;
  struct {
    word QC3DR0      :1;                                       /* Q3DATA Bit 0 */
    word QC3DR1      :1;                                       /* Q3DATA Bit 1 */
    word QC3DR2      :1;                                       /* Q3DATA Bit 2 */
    word QC3DR3      :1;                                       /* Q3DATA Bit 3 */
    word QC3DR4      :1;                                       /* Q3DATA Bit 4 */
    word QC3DR5      :1;                                       /* Q3DATA Bit 5 */
    word QC3DR6      :1;                                       /* Q3DATA Bit 6 */
    word QC3DR7      :1;                                       /* Q3DATA Bit 7 */
    word QC3DR8      :1;                                       /* Q3DATA Bit 8 */
    word QC3DR9      :1;                                       /* Q3DATA Bit 9 */
    word QC3DR10     :1;                                       /* Q3DATA Bit 10 */
    word QC3DR11     :1;                                       /* Q3DATA Bit 11 */
    word QC3DR12     :1;                                       /* Q3DATA Bit 12 */
    word QC3DR13     :1;                                       /* Q3DATA Bit 13 */
    word QC3DR14     :1;                                       /* Q3DATA Bit 14 */
    word QC3DR15     :1;                                       /* Q3DATA Bit 15 */
  } Bits;
} QC3DRSTR;
extern volatile QC3DRSTR _QC3DR @(REG_BASE + 0x00000216UL);
#define QC3DR                           _QC3DR.Word
#define QC3DR_QC3DR0                    _QC3DR.Bits.QC3DR0
#define QC3DR_QC3DR1                    _QC3DR.Bits.QC3DR1
#define QC3DR_QC3DR2                    _QC3DR.Bits.QC3DR2
#define QC3DR_QC3DR3                    _QC3DR.Bits.QC3DR3
#define QC3DR_QC3DR4                    _QC3DR.Bits.QC3DR4
#define QC3DR_QC3DR5                    _QC3DR.Bits.QC3DR5
#define QC3DR_QC3DR6                    _QC3DR.Bits.QC3DR6
#define QC3DR_QC3DR7                    _QC3DR.Bits.QC3DR7
#define QC3DR_QC3DR8                    _QC3DR.Bits.QC3DR8
#define QC3DR_QC3DR9                    _QC3DR.Bits.QC3DR9
#define QC3DR_QC3DR10                   _QC3DR.Bits.QC3DR10
#define QC3DR_QC3DR11                   _QC3DR.Bits.QC3DR11
#define QC3DR_QC3DR12                   _QC3DR.Bits.QC3DR12
#define QC3DR_QC3DR13                   _QC3DR.Bits.QC3DR13
#define QC3DR_QC3DR14                   _QC3DR.Bits.QC3DR14
#define QC3DR_QC3DR15                   _QC3DR.Bits.QC3DR15

#define QC3DR_QC3DR0_MASK               1U
#define QC3DR_QC3DR1_MASK               2U
#define QC3DR_QC3DR2_MASK               4U
#define QC3DR_QC3DR3_MASK               8U
#define QC3DR_QC3DR4_MASK               16U
#define QC3DR_QC3DR5_MASK               32U
#define QC3DR_QC3DR6_MASK               64U
#define QC3DR_QC3DR7_MASK               128U
#define QC3DR_QC3DR8_MASK               256U
#define QC3DR_QC3DR9_MASK               512U
#define QC3DR_QC3DR10_MASK              1024U
#define QC3DR_QC3DR11_MASK              2048U
#define QC3DR_QC3DR12_MASK              4096U
#define QC3DR_QC3DR13_MASK              8192U
#define QC3DR_QC3DR14_MASK              16384U
#define QC3DR_QC3DR15_MASK              32768U


/*** QC3BP - Queue Channel 3 Begin Pointer; 0x00000218 ***/
typedef union {
  word Word;
  struct {
    word BEGPTR30    :1;                                       /* Begin Pointer for Queue Channel 3 FIFO Bit 0 */
    word BEGPTR31    :1;                                       /* Begin Pointer for Queue Channel 3 FIFO Bit 1 */
    word BEGPTR32    :1;                                       /* Begin Pointer for Queue Channel 3 FIFO Bit 2 */
    word BEGPTR33    :1;                                       /* Begin Pointer for Queue Channel 3 FIFO Bit 3 */
    word BEGPTR34    :1;                                       /* Begin Pointer for Queue Channel 3 FIFO Bit 4 */
    word BEGPTR35    :1;                                       /* Begin Pointer for Queue Channel 3 FIFO Bit 5 */
    word BEGPTR36    :1;                                       /* Begin Pointer for Queue Channel 3 FIFO Bit 6 */
    word BEGPTR37    :1;                                       /* Begin Pointer for Queue Channel 3 FIFO Bit 7 */
    word BEGPTR38    :1;                                       /* Begin Pointer for Queue Channel 3 FIFO Bit 8 */
    word BEGPTR39    :1;                                       /* Begin Pointer for Queue Channel 3 FIFO Bit 9 */
    word BEGPTR310   :1;                                       /* Begin Pointer for Queue Channel 3 FIFO Bit 10 */
    word BEGPTR311   :1;                                       /* Begin Pointer for Queue Channel 3 FIFO Bit 11 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
  struct {
    word grpBEGPTR_30 :10;
    word grpBEGPTR3_10 :2;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} QC3BPSTR;
extern volatile QC3BPSTR _QC3BP @(REG_BASE + 0x00000218UL);
#define QC3BP                           _QC3BP.Word
#define QC3BP_BEGPTR30                  _QC3BP.Bits.BEGPTR30
#define QC3BP_BEGPTR31                  _QC3BP.Bits.BEGPTR31
#define QC3BP_BEGPTR32                  _QC3BP.Bits.BEGPTR32
#define QC3BP_BEGPTR33                  _QC3BP.Bits.BEGPTR33
#define QC3BP_BEGPTR34                  _QC3BP.Bits.BEGPTR34
#define QC3BP_BEGPTR35                  _QC3BP.Bits.BEGPTR35
#define QC3BP_BEGPTR36                  _QC3BP.Bits.BEGPTR36
#define QC3BP_BEGPTR37                  _QC3BP.Bits.BEGPTR37
#define QC3BP_BEGPTR38                  _QC3BP.Bits.BEGPTR38
#define QC3BP_BEGPTR39                  _QC3BP.Bits.BEGPTR39
#define QC3BP_BEGPTR310                 _QC3BP.Bits.BEGPTR310
#define QC3BP_BEGPTR311                 _QC3BP.Bits.BEGPTR311
#define QC3BP_BEGPTR_30                 _QC3BP.MergedBits.grpBEGPTR_30
#define QC3BP_BEGPTR3_10                _QC3BP.MergedBits.grpBEGPTR3_10
#define QC3BP_BEGPTR                    QC3BP_BEGPTR_30
#define QC3BP_BEGPTR3                   QC3BP_BEGPTR3_10

#define QC3BP_BEGPTR30_MASK             1U
#define QC3BP_BEGPTR31_MASK             2U
#define QC3BP_BEGPTR32_MASK             4U
#define QC3BP_BEGPTR33_MASK             8U
#define QC3BP_BEGPTR34_MASK             16U
#define QC3BP_BEGPTR35_MASK             32U
#define QC3BP_BEGPTR36_MASK             64U
#define QC3BP_BEGPTR37_MASK             128U
#define QC3BP_BEGPTR38_MASK             256U
#define QC3BP_BEGPTR39_MASK             512U
#define QC3BP_BEGPTR310_MASK            1024U
#define QC3BP_BEGPTR311_MASK            2048U
#define QC3BP_BEGPTR_30_MASK            1023U
#define QC3BP_BEGPTR_30_BITNUM          0U
#define QC3BP_BEGPTR3_10_MASK           3072U
#define QC3BP_BEGPTR3_10_BITNUM         10U


/*** QC3EP - Queue Channel 3 End Pointer; 0x0000021A ***/
typedef union {
  word Word;
  struct {
    word ENDPTR30    :1;                                       /* End Pointer for Queue Channel 3 FIFO Bit 0 */
    word ENDPTR31    :1;                                       /* End Pointer for Queue Channel 3 FIFO Bit 1 */
    word ENDPTR32    :1;                                       /* End Pointer for Queue Channel 3 FIFO Bit 2 */
    word ENDPTR33    :1;                                       /* End Pointer for Queue Channel 3 FIFO Bit 3 */
    word ENDPTR34    :1;                                       /* End Pointer for Queue Channel 3 FIFO Bit 4 */
    word ENDPTR35    :1;                                       /* End Pointer for Queue Channel 3 FIFO Bit 5 */
    word ENDPTR36    :1;                                       /* End Pointer for Queue Channel 3 FIFO Bit 6 */
    word ENDPTR37    :1;                                       /* End Pointer for Queue Channel 3 FIFO Bit 7 */
    word ENDPTR38    :1;                                       /* End Pointer for Queue Channel 3 FIFO Bit 8 */
    word ENDPTR39    :1;                                       /* End Pointer for Queue Channel 3 FIFO Bit 9 */
    word ENDPTR310   :1;                                       /* End Pointer for Queue Channel 3 FIFO Bit 10 */
    word ENDPTR311   :1;                                       /* End Pointer for Queue Channel 3 FIFO Bit 11 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
  struct {
    word grpENDPTR_30 :10;
    word grpENDPTR3_10 :2;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} QC3EPSTR;
extern volatile QC3EPSTR _QC3EP @(REG_BASE + 0x0000021AUL);
#define QC3EP                           _QC3EP.Word
#define QC3EP_ENDPTR30                  _QC3EP.Bits.ENDPTR30
#define QC3EP_ENDPTR31                  _QC3EP.Bits.ENDPTR31
#define QC3EP_ENDPTR32                  _QC3EP.Bits.ENDPTR32
#define QC3EP_ENDPTR33                  _QC3EP.Bits.ENDPTR33
#define QC3EP_ENDPTR34                  _QC3EP.Bits.ENDPTR34
#define QC3EP_ENDPTR35                  _QC3EP.Bits.ENDPTR35
#define QC3EP_ENDPTR36                  _QC3EP.Bits.ENDPTR36
#define QC3EP_ENDPTR37                  _QC3EP.Bits.ENDPTR37
#define QC3EP_ENDPTR38                  _QC3EP.Bits.ENDPTR38
#define QC3EP_ENDPTR39                  _QC3EP.Bits.ENDPTR39
#define QC3EP_ENDPTR310                 _QC3EP.Bits.ENDPTR310
#define QC3EP_ENDPTR311                 _QC3EP.Bits.ENDPTR311
#define QC3EP_ENDPTR_30                 _QC3EP.MergedBits.grpENDPTR_30
#define QC3EP_ENDPTR3_10                _QC3EP.MergedBits.grpENDPTR3_10
#define QC3EP_ENDPTR                    QC3EP_ENDPTR_30
#define QC3EP_ENDPTR3                   QC3EP_ENDPTR3_10

#define QC3EP_ENDPTR30_MASK             1U
#define QC3EP_ENDPTR31_MASK             2U
#define QC3EP_ENDPTR32_MASK             4U
#define QC3EP_ENDPTR33_MASK             8U
#define QC3EP_ENDPTR34_MASK             16U
#define QC3EP_ENDPTR35_MASK             32U
#define QC3EP_ENDPTR36_MASK             64U
#define QC3EP_ENDPTR37_MASK             128U
#define QC3EP_ENDPTR38_MASK             256U
#define QC3EP_ENDPTR39_MASK             512U
#define QC3EP_ENDPTR310_MASK            1024U
#define QC3EP_ENDPTR311_MASK            2048U
#define QC3EP_ENDPTR_30_MASK            1023U
#define QC3EP_ENDPTR_30_BITNUM          0U
#define QC3EP_ENDPTR3_10_MASK           3072U
#define QC3EP_ENDPTR3_10_BITNUM         10U


/*** QC3CR - Queue Channel 3 Control Register; 0x0000021C ***/
typedef union {
  byte Byte;
  struct {
    byte Q3PRST      :1;                                       /* Queue Channel 3 Pointers Reset */
    byte Q3THRU      :1;                                       /* Select Passthrough Mode Involving Queue Channel 1+2 (3+4) */
    byte Q316EN      :1;                                       /* Configure Channel n for 16-bit/8-bit Transfers */
    byte Q3SML       :1;                                       /* Queue Channel 3 Small Buffer Select */
    byte Q3EN        :1;                                       /* Queue Channel 3 Enable */
    byte Q3FIE       :1;                                       /* Queue Channel 3 Full Interrupt Enable */
    byte Q3EIE       :1;                                       /* Queue Channel 3 Empty Interrupt Enable */
    byte Q3VIE       :1;                                       /* Queue Channel 3 Valid Interrupt Enable */
  } Bits;
} QC3CRSTR;
extern volatile QC3CRSTR _QC3CR @(REG_BASE + 0x0000021CUL);
#define QC3CR                           _QC3CR.Byte
#define QC3CR_Q3PRST                    _QC3CR.Bits.Q3PRST
#define QC3CR_Q3THRU                    _QC3CR.Bits.Q3THRU
#define QC3CR_Q316EN                    _QC3CR.Bits.Q316EN
#define QC3CR_Q3SML                     _QC3CR.Bits.Q3SML
#define QC3CR_Q3EN                      _QC3CR.Bits.Q3EN
#define QC3CR_Q3FIE                     _QC3CR.Bits.Q3FIE
#define QC3CR_Q3EIE                     _QC3CR.Bits.Q3EIE
#define QC3CR_Q3VIE                     _QC3CR.Bits.Q3VIE

#define QC3CR_Q3PRST_MASK               1U
#define QC3CR_Q3THRU_MASK               2U
#define QC3CR_Q316EN_MASK               4U
#define QC3CR_Q3SML_MASK                8U
#define QC3CR_Q3EN_MASK                 16U
#define QC3CR_Q3FIE_MASK                32U
#define QC3CR_Q3EIE_MASK                64U
#define QC3CR_Q3VIE_MASK                128U


/*** QC3SR - Queue Channel 3 Status Register; 0x0000021D ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte Q3EIF       :1;                                       /* Queue Channel 3 Empty Interrupt Flag */
    byte Q3FIF       :1;                                       /* Queue Channel 3 Full Interrupt Flag */
    byte Q3VIF       :1;                                       /* Queue Channel 3 Valid Data Interrupt Flag */
    byte Q3ESF       :1;                                       /* Queue Channel 3 Empty Status Flag */
    byte Q3FSF       :1;                                       /* Queue Channel 3 Full Status Flag */
    byte Q3VSF       :1;                                       /* Queue Channel 3 Valid Data Control and Status Flag */
  } Bits;
} QC3SRSTR;
extern volatile QC3SRSTR _QC3SR @(REG_BASE + 0x0000021DUL);
#define QC3SR                           _QC3SR.Byte
#define QC3SR_Q3EIF                     _QC3SR.Bits.Q3EIF
#define QC3SR_Q3FIF                     _QC3SR.Bits.Q3FIF
#define QC3SR_Q3VIF                     _QC3SR.Bits.Q3VIF
#define QC3SR_Q3ESF                     _QC3SR.Bits.Q3ESF
#define QC3SR_Q3FSF                     _QC3SR.Bits.Q3FSF
#define QC3SR_Q3VSF                     _QC3SR.Bits.Q3VSF

#define QC3SR_Q3EIF_MASK                4U
#define QC3SR_Q3FIF_MASK                8U
#define QC3SR_Q3VIF_MASK                16U
#define QC3SR_Q3ESF_MASK                32U
#define QC3SR_Q3FSF_MASK                64U
#define QC3SR_Q3VSF_MASK                128U


/*** QC3SZB - Buffer Size/Base Address Register for Queue Channel 3; 0x0000021E ***/
typedef union {
  byte Byte;
  struct {
    byte QBASE0_3    :1;                                       /* Queue Channel 3 Buffer Base Address Bit 0 */
    byte QBASE1_3    :1;                                       /* Queue Channel 3 Buffer Base Address Bit 1 */
    byte QBASE2_3    :1;                                       /* Queue Channel 3 Buffer Base Address Bit 2 */
    byte QBASE3_3    :1;                                       /* Queue Channel 3 Buffer Base Address Bit 3 */
    byte QSIZE0_3    :1;                                       /* Queue Channel 3 Buffer Size Bit 0 */
    byte QSIZE1_3    :1;                                       /* Queue Channel 3 Buffer Size Bit 1 */
    byte QSIZE2_3    :1;                                       /* Queue Channel 3 Buffer Size Bit 2 */
    byte QSIZE3_3    :1;                                       /* Queue Channel 3 Buffer Size Bit 3 */
  } Bits;
} QC3SZBSTR;
extern volatile QC3SZBSTR _QC3SZB @(REG_BASE + 0x0000021EUL);
#define QC3SZB                          _QC3SZB.Byte
#define QC3SZB_QBASE0_3                 _QC3SZB.Bits.QBASE0_3
#define QC3SZB_QBASE1_3                 _QC3SZB.Bits.QBASE1_3
#define QC3SZB_QBASE2_3                 _QC3SZB.Bits.QBASE2_3
#define QC3SZB_QBASE3_3                 _QC3SZB.Bits.QBASE3_3
#define QC3SZB_QSIZE0_3                 _QC3SZB.Bits.QSIZE0_3
#define QC3SZB_QSIZE1_3                 _QC3SZB.Bits.QSIZE1_3
#define QC3SZB_QSIZE2_3                 _QC3SZB.Bits.QSIZE2_3
#define QC3SZB_QSIZE3_3                 _QC3SZB.Bits.QSIZE3_3

#define QC3SZB_QBASE0_3_MASK            1U
#define QC3SZB_QBASE1_3_MASK            2U
#define QC3SZB_QBASE2_3_MASK            4U
#define QC3SZB_QBASE3_3_MASK            8U
#define QC3SZB_QSIZE0_3_MASK            16U
#define QC3SZB_QSIZE1_3_MASK            32U
#define QC3SZB_QSIZE2_3_MASK            64U
#define QC3SZB_QSIZE3_3_MASK            128U


/*** QC3REQ - Queue Channel 3 Request Mapping Register; 0x0000021F ***/
typedef union {
  byte Byte;
  struct {
    byte Q3REQ0      :1;                                       /* Select Peripheral Request for Queue Channel 3 Bit 0 */
    byte Q3REQ1      :1;                                       /* Select Peripheral Request for Queue Channel 3 Bit 1 */
    byte Q3REQ2      :1;                                       /* Select Peripheral Request for Queue Channel 3 Bit 2 */
    byte Q3REQ3      :1;                                       /* Select Peripheral Request for Queue Channel 3 Bit 3 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpQ3REQ :4;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} QC3REQSTR;
extern volatile QC3REQSTR _QC3REQ @(REG_BASE + 0x0000021FUL);
#define QC3REQ                          _QC3REQ.Byte
#define QC3REQ_Q3REQ0                   _QC3REQ.Bits.Q3REQ0
#define QC3REQ_Q3REQ1                   _QC3REQ.Bits.Q3REQ1
#define QC3REQ_Q3REQ2                   _QC3REQ.Bits.Q3REQ2
#define QC3REQ_Q3REQ3                   _QC3REQ.Bits.Q3REQ3
#define QC3REQ_Q3REQ                    _QC3REQ.MergedBits.grpQ3REQ

#define QC3REQ_Q3REQ0_MASK              1U
#define QC3REQ_Q3REQ1_MASK              2U
#define QC3REQ_Q3REQ2_MASK              4U
#define QC3REQ_Q3REQ3_MASK              8U
#define QC3REQ_Q3REQ_MASK               15U
#define QC3REQ_Q3REQ_BITNUM             0U


/*** QC4DR - Queue Channel 4 FIFO Data Port Register; 0x00000220 ***/
typedef union {
  word Word;
  struct {
    word QC4DR0      :1;                                       /* Q4DATA Bit 0 */
    word QC4DR1      :1;                                       /* Q4DATA Bit 1 */
    word QC4DR2      :1;                                       /* Q4DATA Bit 2 */
    word QC4DR3      :1;                                       /* Q4DATA Bit 3 */
    word QC4DR4      :1;                                       /* Q4DATA Bit 4 */
    word QC4DR5      :1;                                       /* Q4DATA Bit 5 */
    word QC4DR6      :1;                                       /* Q4DATA Bit 6 */
    word QC4DR7      :1;                                       /* Q4DATA Bit 7 */
    word QC4DR8      :1;                                       /* Q4DATA Bit 8 */
    word QC4DR9      :1;                                       /* Q4DATA Bit 9 */
    word QC4DR10     :1;                                       /* Q4DATA Bit 10 */
    word QC4DR11     :1;                                       /* Q4DATA Bit 11 */
    word QC4DR12     :1;                                       /* Q4DATA Bit 12 */
    word QC4DR13     :1;                                       /* Q4DATA Bit 13 */
    word QC4DR14     :1;                                       /* Q4DATA Bit 14 */
    word QC4DR15     :1;                                       /* Q4DATA Bit 15 */
  } Bits;
} QC4DRSTR;
extern volatile QC4DRSTR _QC4DR @(REG_BASE + 0x00000220UL);
#define QC4DR                           _QC4DR.Word
#define QC4DR_QC4DR0                    _QC4DR.Bits.QC4DR0
#define QC4DR_QC4DR1                    _QC4DR.Bits.QC4DR1
#define QC4DR_QC4DR2                    _QC4DR.Bits.QC4DR2
#define QC4DR_QC4DR3                    _QC4DR.Bits.QC4DR3
#define QC4DR_QC4DR4                    _QC4DR.Bits.QC4DR4
#define QC4DR_QC4DR5                    _QC4DR.Bits.QC4DR5
#define QC4DR_QC4DR6                    _QC4DR.Bits.QC4DR6
#define QC4DR_QC4DR7                    _QC4DR.Bits.QC4DR7
#define QC4DR_QC4DR8                    _QC4DR.Bits.QC4DR8
#define QC4DR_QC4DR9                    _QC4DR.Bits.QC4DR9
#define QC4DR_QC4DR10                   _QC4DR.Bits.QC4DR10
#define QC4DR_QC4DR11                   _QC4DR.Bits.QC4DR11
#define QC4DR_QC4DR12                   _QC4DR.Bits.QC4DR12
#define QC4DR_QC4DR13                   _QC4DR.Bits.QC4DR13
#define QC4DR_QC4DR14                   _QC4DR.Bits.QC4DR14
#define QC4DR_QC4DR15                   _QC4DR.Bits.QC4DR15

#define QC4DR_QC4DR0_MASK               1U
#define QC4DR_QC4DR1_MASK               2U
#define QC4DR_QC4DR2_MASK               4U
#define QC4DR_QC4DR3_MASK               8U
#define QC4DR_QC4DR4_MASK               16U
#define QC4DR_QC4DR5_MASK               32U
#define QC4DR_QC4DR6_MASK               64U
#define QC4DR_QC4DR7_MASK               128U
#define QC4DR_QC4DR8_MASK               256U
#define QC4DR_QC4DR9_MASK               512U
#define QC4DR_QC4DR10_MASK              1024U
#define QC4DR_QC4DR11_MASK              2048U
#define QC4DR_QC4DR12_MASK              4096U
#define QC4DR_QC4DR13_MASK              8192U
#define QC4DR_QC4DR14_MASK              16384U
#define QC4DR_QC4DR15_MASK              32768U


/*** QC4BP - Queue Channel 4 Begin Pointer; 0x00000222 ***/
typedef union {
  word Word;
  struct {
    word BEGPTR40    :1;                                       /* Begin Pointer for Queue Channel 4 FIFO Bit 0 */
    word BEGPTR41    :1;                                       /* Begin Pointer for Queue Channel 4 FIFO Bit 1 */
    word BEGPTR42    :1;                                       /* Begin Pointer for Queue Channel 4 FIFO Bit 2 */
    word BEGPTR43    :1;                                       /* Begin Pointer for Queue Channel 4 FIFO Bit 3 */
    word BEGPTR44    :1;                                       /* Begin Pointer for Queue Channel 4 FIFO Bit 4 */
    word BEGPTR45    :1;                                       /* Begin Pointer for Queue Channel 4 FIFO Bit 5 */
    word BEGPTR46    :1;                                       /* Begin Pointer for Queue Channel 4 FIFO Bit 6 */
    word BEGPTR47    :1;                                       /* Begin Pointer for Queue Channel 4 FIFO Bit 7 */
    word BEGPTR48    :1;                                       /* Begin Pointer for Queue Channel 4 FIFO Bit 8 */
    word BEGPTR49    :1;                                       /* Begin Pointer for Queue Channel 4 FIFO Bit 9 */
    word BEGPTR410   :1;                                       /* Begin Pointer for Queue Channel 4 FIFO Bit 10 */
    word BEGPTR411   :1;                                       /* Begin Pointer for Queue Channel 4 FIFO Bit 11 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
  struct {
    word grpBEGPTR_40 :10;
    word grpBEGPTR4_10 :2;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} QC4BPSTR;
extern volatile QC4BPSTR _QC4BP @(REG_BASE + 0x00000222UL);
#define QC4BP                           _QC4BP.Word
#define QC4BP_BEGPTR40                  _QC4BP.Bits.BEGPTR40
#define QC4BP_BEGPTR41                  _QC4BP.Bits.BEGPTR41
#define QC4BP_BEGPTR42                  _QC4BP.Bits.BEGPTR42
#define QC4BP_BEGPTR43                  _QC4BP.Bits.BEGPTR43
#define QC4BP_BEGPTR44                  _QC4BP.Bits.BEGPTR44
#define QC4BP_BEGPTR45                  _QC4BP.Bits.BEGPTR45
#define QC4BP_BEGPTR46                  _QC4BP.Bits.BEGPTR46
#define QC4BP_BEGPTR47                  _QC4BP.Bits.BEGPTR47
#define QC4BP_BEGPTR48                  _QC4BP.Bits.BEGPTR48
#define QC4BP_BEGPTR49                  _QC4BP.Bits.BEGPTR49
#define QC4BP_BEGPTR410                 _QC4BP.Bits.BEGPTR410
#define QC4BP_BEGPTR411                 _QC4BP.Bits.BEGPTR411
#define QC4BP_BEGPTR_40                 _QC4BP.MergedBits.grpBEGPTR_40
#define QC4BP_BEGPTR4_10                _QC4BP.MergedBits.grpBEGPTR4_10
#define QC4BP_BEGPTR                    QC4BP_BEGPTR_40
#define QC4BP_BEGPTR4                   QC4BP_BEGPTR4_10

#define QC4BP_BEGPTR40_MASK             1U
#define QC4BP_BEGPTR41_MASK             2U
#define QC4BP_BEGPTR42_MASK             4U
#define QC4BP_BEGPTR43_MASK             8U
#define QC4BP_BEGPTR44_MASK             16U
#define QC4BP_BEGPTR45_MASK             32U
#define QC4BP_BEGPTR46_MASK             64U
#define QC4BP_BEGPTR47_MASK             128U
#define QC4BP_BEGPTR48_MASK             256U
#define QC4BP_BEGPTR49_MASK             512U
#define QC4BP_BEGPTR410_MASK            1024U
#define QC4BP_BEGPTR411_MASK            2048U
#define QC4BP_BEGPTR_40_MASK            1023U
#define QC4BP_BEGPTR_40_BITNUM          0U
#define QC4BP_BEGPTR4_10_MASK           3072U
#define QC4BP_BEGPTR4_10_BITNUM         10U


/*** QC4EP - Queue Channel 4 End Pointer; 0x00000224 ***/
typedef union {
  word Word;
  struct {
    word ENDPTR40    :1;                                       /* End Pointer for Queue Channel 4 FIFO Bit 0 */
    word ENDPTR41    :1;                                       /* End Pointer for Queue Channel 4 FIFO Bit 1 */
    word ENDPTR42    :1;                                       /* End Pointer for Queue Channel 4 FIFO Bit 2 */
    word ENDPTR43    :1;                                       /* End Pointer for Queue Channel 4 FIFO Bit 3 */
    word ENDPTR44    :1;                                       /* End Pointer for Queue Channel 4 FIFO Bit 4 */
    word ENDPTR45    :1;                                       /* End Pointer for Queue Channel 4 FIFO Bit 5 */
    word ENDPTR46    :1;                                       /* End Pointer for Queue Channel 4 FIFO Bit 6 */
    word ENDPTR47    :1;                                       /* End Pointer for Queue Channel 4 FIFO Bit 7 */
    word ENDPTR48    :1;                                       /* End Pointer for Queue Channel 4 FIFO Bit 8 */
    word ENDPTR49    :1;                                       /* End Pointer for Queue Channel 4 FIFO Bit 9 */
    word ENDPTR410   :1;                                       /* End Pointer for Queue Channel 4 FIFO Bit 10 */
    word ENDPTR411   :1;                                       /* End Pointer for Queue Channel 4 FIFO Bit 11 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
  struct {
    word grpENDPTR_40 :10;
    word grpENDPTR4_10 :2;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} QC4EPSTR;
extern volatile QC4EPSTR _QC4EP @(REG_BASE + 0x00000224UL);
#define QC4EP                           _QC4EP.Word
#define QC4EP_ENDPTR40                  _QC4EP.Bits.ENDPTR40
#define QC4EP_ENDPTR41                  _QC4EP.Bits.ENDPTR41
#define QC4EP_ENDPTR42                  _QC4EP.Bits.ENDPTR42
#define QC4EP_ENDPTR43                  _QC4EP.Bits.ENDPTR43
#define QC4EP_ENDPTR44                  _QC4EP.Bits.ENDPTR44
#define QC4EP_ENDPTR45                  _QC4EP.Bits.ENDPTR45
#define QC4EP_ENDPTR46                  _QC4EP.Bits.ENDPTR46
#define QC4EP_ENDPTR47                  _QC4EP.Bits.ENDPTR47
#define QC4EP_ENDPTR48                  _QC4EP.Bits.ENDPTR48
#define QC4EP_ENDPTR49                  _QC4EP.Bits.ENDPTR49
#define QC4EP_ENDPTR410                 _QC4EP.Bits.ENDPTR410
#define QC4EP_ENDPTR411                 _QC4EP.Bits.ENDPTR411
#define QC4EP_ENDPTR_40                 _QC4EP.MergedBits.grpENDPTR_40
#define QC4EP_ENDPTR4_10                _QC4EP.MergedBits.grpENDPTR4_10
#define QC4EP_ENDPTR                    QC4EP_ENDPTR_40
#define QC4EP_ENDPTR4                   QC4EP_ENDPTR4_10

#define QC4EP_ENDPTR40_MASK             1U
#define QC4EP_ENDPTR41_MASK             2U
#define QC4EP_ENDPTR42_MASK             4U
#define QC4EP_ENDPTR43_MASK             8U
#define QC4EP_ENDPTR44_MASK             16U
#define QC4EP_ENDPTR45_MASK             32U
#define QC4EP_ENDPTR46_MASK             64U
#define QC4EP_ENDPTR47_MASK             128U
#define QC4EP_ENDPTR48_MASK             256U
#define QC4EP_ENDPTR49_MASK             512U
#define QC4EP_ENDPTR410_MASK            1024U
#define QC4EP_ENDPTR411_MASK            2048U
#define QC4EP_ENDPTR_40_MASK            1023U
#define QC4EP_ENDPTR_40_BITNUM          0U
#define QC4EP_ENDPTR4_10_MASK           3072U
#define QC4EP_ENDPTR4_10_BITNUM         10U


/*** QC4CR - Queue Channel 4 Control Register; 0x00000226 ***/
typedef union {
  byte Byte;
  struct {
    byte Q4PRST      :1;                                       /* Queue Channel 4 Pointers Reset */
    byte             :1; 
    byte Q416EN      :1;                                       /* Configure Channel 4 for 16-bit/8-bit Transfers */
    byte Q4SML       :1;                                       /* Queue Channel 4 Small Buffer Select */
    byte Q4EN        :1;                                       /* Queue Channel 4 Enable */
    byte Q4FIE       :1;                                       /* Queue Channel 4 Full Interrupt Enable */
    byte Q4EIE       :1;                                       /* Queue Channel 4 Empty Interrupt Enable */
    byte Q4VIE       :1;                                       /* Queue Channel 4 Valid Interrupt Enable */
  } Bits;
} QC4CRSTR;
extern volatile QC4CRSTR _QC4CR @(REG_BASE + 0x00000226UL);
#define QC4CR                           _QC4CR.Byte
#define QC4CR_Q4PRST                    _QC4CR.Bits.Q4PRST
#define QC4CR_Q416EN                    _QC4CR.Bits.Q416EN
#define QC4CR_Q4SML                     _QC4CR.Bits.Q4SML
#define QC4CR_Q4EN                      _QC4CR.Bits.Q4EN
#define QC4CR_Q4FIE                     _QC4CR.Bits.Q4FIE
#define QC4CR_Q4EIE                     _QC4CR.Bits.Q4EIE
#define QC4CR_Q4VIE                     _QC4CR.Bits.Q4VIE

#define QC4CR_Q4PRST_MASK               1U
#define QC4CR_Q416EN_MASK               4U
#define QC4CR_Q4SML_MASK                8U
#define QC4CR_Q4EN_MASK                 16U
#define QC4CR_Q4FIE_MASK                32U
#define QC4CR_Q4EIE_MASK                64U
#define QC4CR_Q4VIE_MASK                128U


/*** QC4SR - Queue Channel 4 Status Register; 0x00000227 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte Q4EIF       :1;                                       /* Queue Channel 4 Empty Interrupt Flag */
    byte Q4FIF       :1;                                       /* Queue Channel 4 Full Interrupt Flag */
    byte Q4VIF       :1;                                       /* Queue Channel 4 Valid Data Interrupt Flag */
    byte Q4ESF       :1;                                       /* Queue Channel 4 Empty Status Flag */
    byte Q4FSF       :1;                                       /* Queue Channel 4 Full Status Flag */
    byte Q4VSF       :1;                                       /* Queue Channel 4 Valid Data Control and Status Flag */
  } Bits;
} QC4SRSTR;
extern volatile QC4SRSTR _QC4SR @(REG_BASE + 0x00000227UL);
#define QC4SR                           _QC4SR.Byte
#define QC4SR_Q4EIF                     _QC4SR.Bits.Q4EIF
#define QC4SR_Q4FIF                     _QC4SR.Bits.Q4FIF
#define QC4SR_Q4VIF                     _QC4SR.Bits.Q4VIF
#define QC4SR_Q4ESF                     _QC4SR.Bits.Q4ESF
#define QC4SR_Q4FSF                     _QC4SR.Bits.Q4FSF
#define QC4SR_Q4VSF                     _QC4SR.Bits.Q4VSF

#define QC4SR_Q4EIF_MASK                4U
#define QC4SR_Q4FIF_MASK                8U
#define QC4SR_Q4VIF_MASK                16U
#define QC4SR_Q4ESF_MASK                32U
#define QC4SR_Q4FSF_MASK                64U
#define QC4SR_Q4VSF_MASK                128U


/*** QC4SZB - Buffer Size/Base Address Register for Queue Channel 4; 0x00000228 ***/
typedef union {
  byte Byte;
  struct {
    byte QBASE0_4    :1;                                       /* Queue Channel 4 Buffer Base Address Bit 0 */
    byte QBASE1_4    :1;                                       /* Queue Channel 4 Buffer Base Address Bit 1 */
    byte QBASE2_4    :1;                                       /* Queue Channel 4 Buffer Base Address Bit 2 */
    byte QBASE3_4    :1;                                       /* Queue Channel 4 Buffer Base Address Bit 3 */
    byte QSIZE0_4    :1;                                       /* Queue Channel 4 Buffer Size Bit 0 */
    byte QSIZE1_4    :1;                                       /* Queue Channel 4 Buffer Size Bit 1 */
    byte QSIZE2_4    :1;                                       /* Queue Channel 4 Buffer Size Bit 2 */
    byte QSIZE3_4    :1;                                       /* Queue Channel 4 Buffer Size Bit 3 */
  } Bits;
} QC4SZBSTR;
extern volatile QC4SZBSTR _QC4SZB @(REG_BASE + 0x00000228UL);
#define QC4SZB                          _QC4SZB.Byte
#define QC4SZB_QBASE0_4                 _QC4SZB.Bits.QBASE0_4
#define QC4SZB_QBASE1_4                 _QC4SZB.Bits.QBASE1_4
#define QC4SZB_QBASE2_4                 _QC4SZB.Bits.QBASE2_4
#define QC4SZB_QBASE3_4                 _QC4SZB.Bits.QBASE3_4
#define QC4SZB_QSIZE0_4                 _QC4SZB.Bits.QSIZE0_4
#define QC4SZB_QSIZE1_4                 _QC4SZB.Bits.QSIZE1_4
#define QC4SZB_QSIZE2_4                 _QC4SZB.Bits.QSIZE2_4
#define QC4SZB_QSIZE3_4                 _QC4SZB.Bits.QSIZE3_4

#define QC4SZB_QBASE0_4_MASK            1U
#define QC4SZB_QBASE1_4_MASK            2U
#define QC4SZB_QBASE2_4_MASK            4U
#define QC4SZB_QBASE3_4_MASK            8U
#define QC4SZB_QSIZE0_4_MASK            16U
#define QC4SZB_QSIZE1_4_MASK            32U
#define QC4SZB_QSIZE2_4_MASK            64U
#define QC4SZB_QSIZE3_4_MASK            128U


/*** QC4REQ - Queue Channel 4 Request Mapping Register; 0x00000229 ***/
typedef union {
  byte Byte;
  struct {
    byte Q4REQ0      :1;                                       /* Select Peripheral Request for Queue Channel 4 Bit 0 */
    byte Q4REQ1      :1;                                       /* Select Peripheral Request for Queue Channel 4 Bit 1 */
    byte Q4REQ2      :1;                                       /* Select Peripheral Request for Queue Channel 4 Bit 2 */
    byte Q4REQ3      :1;                                       /* Select Peripheral Request for Queue Channel 4 Bit 3 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpQ4REQ :4;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} QC4REQSTR;
extern volatile QC4REQSTR _QC4REQ @(REG_BASE + 0x00000229UL);
#define QC4REQ                          _QC4REQ.Byte
#define QC4REQ_Q4REQ0                   _QC4REQ.Bits.Q4REQ0
#define QC4REQ_Q4REQ1                   _QC4REQ.Bits.Q4REQ1
#define QC4REQ_Q4REQ2                   _QC4REQ.Bits.Q4REQ2
#define QC4REQ_Q4REQ3                   _QC4REQ.Bits.Q4REQ3
#define QC4REQ_Q4REQ                    _QC4REQ.MergedBits.grpQ4REQ

#define QC4REQ_Q4REQ0_MASK              1U
#define QC4REQ_Q4REQ1_MASK              2U
#define QC4REQ_Q4REQ2_MASK              4U
#define QC4REQ_Q4REQ3_MASK              8U
#define QC4REQ_Q4REQ_MASK               15U
#define QC4REQ_Q4REQ_BITNUM             0U


/*** QC12DCR - Queue Channel 1+2 Double Buffer Control Register; 0x0000022A ***/
typedef union {
  byte Byte;
  struct {
    byte DBRST_12    :1;                                       /* Double Buffer Status and Pointer Register Reset */
    byte DBFIE_12    :1;                                       /* Queue Channel Double Buffer Full Interrupt Enable */
    byte DBEIE_12    :1;                                       /* Queue Channel Double Buffer Empty Interrupt Enable */
    byte DBTIE_12    :1;                                       /* Double Buffer Block Transfer Complete Interrupt Enable */
    byte SBTE_12     :1;                                       /* Single Bock Transfer mode enable */
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} QC12DCRSTR;
extern volatile QC12DCRSTR _QC12DCR @(REG_BASE + 0x0000022AUL);
#define QC12DCR                         _QC12DCR.Byte
#define QC12DCR_DBRST_12                _QC12DCR.Bits.DBRST_12
#define QC12DCR_DBFIE_12                _QC12DCR.Bits.DBFIE_12
#define QC12DCR_DBEIE_12                _QC12DCR.Bits.DBEIE_12
#define QC12DCR_DBTIE_12                _QC12DCR.Bits.DBTIE_12
#define QC12DCR_SBTE_12                 _QC12DCR.Bits.SBTE_12

#define QC12DCR_DBRST_12_MASK           1U
#define QC12DCR_DBFIE_12_MASK           2U
#define QC12DCR_DBEIE_12_MASK           4U
#define QC12DCR_DBTIE_12_MASK           8U
#define QC12DCR_SBTE_12_MASK            16U


/*** QC34DCR - Queue Channel 3+4 Double Buffer Control Register; 0x0000022B ***/
typedef union {
  byte Byte;
  struct {
    byte DBRST_34    :1;                                       /* Double Buffer Status and Pointer Register Reset */
    byte DBFIE_34    :1;                                       /* Queue Channel Double Buffer Full Interrupt Enable */
    byte DBEIE_34    :1;                                       /* Queue Channel Double Buffer Empty Interrupt Enable */
    byte DBTIE_34    :1;                                       /* Double Buffer Block Transfer Complete Interrupt Enable */
    byte SBTE_34     :1;                                       /* Single Bock Transfer mode enable */
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} QC34DCRSTR;
extern volatile QC34DCRSTR _QC34DCR @(REG_BASE + 0x0000022BUL);
#define QC34DCR                         _QC34DCR.Byte
#define QC34DCR_DBRST_34                _QC34DCR.Bits.DBRST_34
#define QC34DCR_DBFIE_34                _QC34DCR.Bits.DBFIE_34
#define QC34DCR_DBEIE_34                _QC34DCR.Bits.DBEIE_34
#define QC34DCR_DBTIE_34                _QC34DCR.Bits.DBTIE_34
#define QC34DCR_SBTE_34                 _QC34DCR.Bits.SBTE_34

#define QC34DCR_DBRST_34_MASK           1U
#define QC34DCR_DBFIE_34_MASK           2U
#define QC34DCR_DBEIE_34_MASK           4U
#define QC34DCR_DBTIE_34_MASK           8U
#define QC34DCR_SBTE_34_MASK            16U


/*** QC12DSR - Queue Channel 1+2 Double Buffer Status Register; 0x0000022C ***/
typedef union {
  byte Byte;
  struct {
    byte DBSF0_12    :1;                                       /* Double Buffer Status Flag Bit 0 */
    byte DBSF1_12    :1;                                       /* Double Buffer Status Flag Bit 1 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte DBFIF_12    :1;                                       /* Double Buffer Full Interrupt Flag */
    byte DBEIF_12    :1;                                       /* Double Buffer Empty Interrupt Flag */
    byte DBTCIF_12   :1;                                       /* Block Transfer Complete Interrupt Flag */
  } Bits;
} QC12DSRSTR;
extern volatile QC12DSRSTR _QC12DSR @(REG_BASE + 0x0000022CUL);
#define QC12DSR                         _QC12DSR.Byte
#define QC12DSR_DBSF0_12                _QC12DSR.Bits.DBSF0_12
#define QC12DSR_DBSF1_12                _QC12DSR.Bits.DBSF1_12
#define QC12DSR_DBFIF_12                _QC12DSR.Bits.DBFIF_12
#define QC12DSR_DBEIF_12                _QC12DSR.Bits.DBEIF_12
#define QC12DSR_DBTCIF_12               _QC12DSR.Bits.DBTCIF_12

#define QC12DSR_DBSF0_12_MASK           1U
#define QC12DSR_DBSF1_12_MASK           2U
#define QC12DSR_DBFIF_12_MASK           32U
#define QC12DSR_DBEIF_12_MASK           64U
#define QC12DSR_DBTCIF_12_MASK          128U


/*** QC34DSR - Queue Channel 3+4 Double Buffer Status Register; 0x0000022D ***/
typedef union {
  byte Byte;
  struct {
    byte DBSF0_34    :1;                                       /* Double Buffer Status Flag Bit 0 */
    byte DBSF1_34    :1;                                       /* Double Buffer Status Flag Bit 1 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte DBFIF_34    :1;                                       /* Double Buffer Full Interrupt Flag */
    byte DBEIF_34    :1;                                       /* Double Buffer Empty Interrupt Flag */
    byte DBTCIF_34   :1;                                       /* Block Transfer Complete Interrupt Flag */
  } Bits;
} QC34DSRSTR;
extern volatile QC34DSRSTR _QC34DSR @(REG_BASE + 0x0000022DUL);
#define QC34DSR                         _QC34DSR.Byte
#define QC34DSR_DBSF0_34                _QC34DSR.Bits.DBSF0_34
#define QC34DSR_DBSF1_34                _QC34DSR.Bits.DBSF1_34
#define QC34DSR_DBFIF_34                _QC34DSR.Bits.DBFIF_34
#define QC34DSR_DBEIF_34                _QC34DSR.Bits.DBEIF_34
#define QC34DSR_DBTCIF_34               _QC34DSR.Bits.DBTCIF_34

#define QC34DSR_DBSF0_34_MASK           1U
#define QC34DSR_DBSF1_34_MASK           2U
#define QC34DSR_DBFIF_34_MASK           32U
#define QC34DSR_DBEIF_34_MASK           64U
#define QC34DSR_DBTCIF_34_MASK          128U


/*** QCDCT - Queue Channel Double Buffer Counter Register; 0x0000022E ***/
typedef union {
  word Word;
  struct {
    word DBTRAN120   :1;                                       /* Number of buffers to be transfered for Queue Channel 1+2 Bit 0 */
    word DBTRAN121   :1;                                       /* Number of buffers to be transfered for Queue Channel 1+2 Bit 1 */
    word DBTRAN122   :1;                                       /* Number of buffers to be transfered for Queue Channel 1+2 Bit 2 */
    word DBTRAN123   :1;                                       /* Number of buffers to be transfered for Queue Channel 1+2 Bit 3 */
    word DBTRAN124   :1;                                       /* Number of buffers to be transfered for Queue Channel 1+2 Bit 4 */
    word DBTRAN125   :1;                                       /* Number of buffers to be transfered for Queue Channel 1+2 Bit 5 */
    word DBTRAN126   :1;                                       /* Number of buffers to be transfered for Queue Channel 1+2 Bit 6 */
    word DBTRAN127   :1;                                       /* Number of buffers to be transfered for Queue Channel 1+2 Bit 7 */
    word DBTRAN340   :1;                                       /* Number of buffers to be transfered for Queue Channel 3+4 Bit 0 */
    word DBTRAN341   :1;                                       /* Number of buffers to be transfered for Queue Channel 3+4 Bit 1 */
    word DBTRAN342   :1;                                       /* Number of buffers to be transfered for Queue Channel 3+4 Bit 2 */
    word DBTRAN343   :1;                                       /* Number of buffers to be transfered for Queue Channel 3+4 Bit 3 */
    word DBTRAN344   :1;                                       /* Number of buffers to be transfered for Queue Channel 3+4 Bit 4 */
    word DBTRAN345   :1;                                       /* Number of buffers to be transfered for Queue Channel 3+4 Bit 5 */
    word DBTRAN346   :1;                                       /* Number of buffers to be transfered for Queue Channel 3+4 Bit 6 */
    word DBTRAN347   :1;                                       /* Number of buffers to be transfered for Queue Channel 3+4 Bit 7 */
  } Bits;
  struct {
    word grpDBTRAN1_20 :8;
    word grpDBTRAN3_40 :8;
  } MergedBits;
} QCDCTSTR;
extern volatile QCDCTSTR _QCDCT @(REG_BASE + 0x0000022EUL);
#define QCDCT                           _QCDCT.Word
#define QCDCT_DBTRAN120                 _QCDCT.Bits.DBTRAN120
#define QCDCT_DBTRAN121                 _QCDCT.Bits.DBTRAN121
#define QCDCT_DBTRAN122                 _QCDCT.Bits.DBTRAN122
#define QCDCT_DBTRAN123                 _QCDCT.Bits.DBTRAN123
#define QCDCT_DBTRAN124                 _QCDCT.Bits.DBTRAN124
#define QCDCT_DBTRAN125                 _QCDCT.Bits.DBTRAN125
#define QCDCT_DBTRAN126                 _QCDCT.Bits.DBTRAN126
#define QCDCT_DBTRAN127                 _QCDCT.Bits.DBTRAN127
#define QCDCT_DBTRAN340                 _QCDCT.Bits.DBTRAN340
#define QCDCT_DBTRAN341                 _QCDCT.Bits.DBTRAN341
#define QCDCT_DBTRAN342                 _QCDCT.Bits.DBTRAN342
#define QCDCT_DBTRAN343                 _QCDCT.Bits.DBTRAN343
#define QCDCT_DBTRAN344                 _QCDCT.Bits.DBTRAN344
#define QCDCT_DBTRAN345                 _QCDCT.Bits.DBTRAN345
#define QCDCT_DBTRAN346                 _QCDCT.Bits.DBTRAN346
#define QCDCT_DBTRAN347                 _QCDCT.Bits.DBTRAN347
#define QCDCT_DBTRAN1_20                _QCDCT.MergedBits.grpDBTRAN1_20
#define QCDCT_DBTRAN3_40                _QCDCT.MergedBits.grpDBTRAN3_40
#define QCDCT_DBTRAN1                   QCDCT_DBTRAN1_20
#define QCDCT_DBTRAN3                   QCDCT_DBTRAN3_40

#define QCDCT_DBTRAN120_MASK            1U
#define QCDCT_DBTRAN121_MASK            2U
#define QCDCT_DBTRAN122_MASK            4U
#define QCDCT_DBTRAN123_MASK            8U
#define QCDCT_DBTRAN124_MASK            16U
#define QCDCT_DBTRAN125_MASK            32U
#define QCDCT_DBTRAN126_MASK            64U
#define QCDCT_DBTRAN127_MASK            128U
#define QCDCT_DBTRAN340_MASK            256U
#define QCDCT_DBTRAN341_MASK            512U
#define QCDCT_DBTRAN342_MASK            1024U
#define QCDCT_DBTRAN343_MASK            2048U
#define QCDCT_DBTRAN344_MASK            4096U
#define QCDCT_DBTRAN345_MASK            8192U
#define QCDCT_DBTRAN346_MASK            16384U
#define QCDCT_DBTRAN347_MASK            32768U
#define QCDCT_DBTRAN1_20_MASK           255U
#define QCDCT_DBTRAN1_20_BITNUM         0U
#define QCDCT_DBTRAN3_40_MASK           65280U
#define QCDCT_DBTRAN3_40_BITNUM         8U


/*** QC12DSHR - Queue Channel 1+2 Double Buffer Software Handshake Register; 0x00000230 ***/
typedef union {
  byte Byte;
  struct {
    byte DTHE_12     :1;                                       /* Queue Channel Double Buffer Transmit Handshake Enable */
    byte DRHE_12     :1;                                       /* Queue Channel Double Buffer Receive Handshake Enable */
    byte             :1; 
    byte             :1; 
    byte TXDA_12     :1;                                       /* Transmitted Data Acknowledge */
    byte TXRD_12     :1;                                       /* Resend Transmitted Data */
    byte RXDA_12     :1;                                       /* Received Data Acknowledge */
    byte RXDF_12     :1;                                       /* Received Data Flush */
  } Bits;
} QC12DSHRSTR;
extern volatile QC12DSHRSTR _QC12DSHR @(REG_BASE + 0x00000230UL);
#define QC12DSHR                        _QC12DSHR.Byte
#define QC12DSHR_DTHE_12                _QC12DSHR.Bits.DTHE_12
#define QC12DSHR_DRHE_12                _QC12DSHR.Bits.DRHE_12
#define QC12DSHR_TXDA_12                _QC12DSHR.Bits.TXDA_12
#define QC12DSHR_TXRD_12                _QC12DSHR.Bits.TXRD_12
#define QC12DSHR_RXDA_12                _QC12DSHR.Bits.RXDA_12
#define QC12DSHR_RXDF_12                _QC12DSHR.Bits.RXDF_12

#define QC12DSHR_DTHE_12_MASK           1U
#define QC12DSHR_DRHE_12_MASK           2U
#define QC12DSHR_TXDA_12_MASK           16U
#define QC12DSHR_TXRD_12_MASK           32U
#define QC12DSHR_RXDA_12_MASK           64U
#define QC12DSHR_RXDF_12_MASK           128U


/*** QC34DSHR - Queue Channel 3+4 Double Buffer Software Handshake Register; 0x00000231 ***/
typedef union {
  byte Byte;
  struct {
    byte DTHE_34     :1;                                       /* Queue Channel Double Buffer Transmit Handshake Enable */
    byte DRHE_34     :1;                                       /* Queue Channel Double Buffer Receive Handshake Enable */
    byte             :1; 
    byte             :1; 
    byte TXDA_34     :1;                                       /* Transmitted Data Acknowledge */
    byte TXRD_34     :1;                                       /* Resend Transmitted Data */
    byte RXDA_34     :1;                                       /* Received Data Acknowledge */
    byte RXDF_34     :1;                                       /* Received Data Flush */
  } Bits;
} QC34DSHRSTR;
extern volatile QC34DSHRSTR _QC34DSHR @(REG_BASE + 0x00000231UL);
#define QC34DSHR                        _QC34DSHR.Byte
#define QC34DSHR_DTHE_34                _QC34DSHR.Bits.DTHE_34
#define QC34DSHR_DRHE_34                _QC34DSHR.Bits.DRHE_34
#define QC34DSHR_TXDA_34                _QC34DSHR.Bits.TXDA_34
#define QC34DSHR_TXRD_34                _QC34DSHR.Bits.TXRD_34
#define QC34DSHR_RXDA_34                _QC34DSHR.Bits.RXDA_34
#define QC34DSHR_RXDF_34                _QC34DSHR.Bits.RXDF_34

#define QC34DSHR_DTHE_34_MASK           1U
#define QC34DSHR_DRHE_34_MASK           2U
#define QC34DSHR_TXDA_34_MASK           16U
#define QC34DSHR_TXRD_34_MASK           32U
#define QC34DSHR_RXDA_34_MASK           64U
#define QC34DSHR_RXDF_34_MASK           128U


/*** PTT - Port T I/O Register; 0x00000240 ***/
typedef union {
  byte Byte;
  struct {
    byte PTT0        :1;                                       /* Port T Bit 0 */
    byte PTT1        :1;                                       /* Port T Bit 1 */
    byte PTT2        :1;                                       /* Port T Bit 2 */
    byte PTT3        :1;                                       /* Port T Bit 3 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpPTT  :4;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} PTTSTR;
extern volatile PTTSTR _PTT @(REG_BASE + 0x00000240UL);
#define PTT                             _PTT.Byte
#define PTT_PTT0                        _PTT.Bits.PTT0
#define PTT_PTT1                        _PTT.Bits.PTT1
#define PTT_PTT2                        _PTT.Bits.PTT2
#define PTT_PTT3                        _PTT.Bits.PTT3
#define PTT_PTT                         _PTT.MergedBits.grpPTT

#define PTT_PTT0_MASK                   1U
#define PTT_PTT1_MASK                   2U
#define PTT_PTT2_MASK                   4U
#define PTT_PTT3_MASK                   8U
#define PTT_PTT_MASK                    15U
#define PTT_PTT_BITNUM                  0U


/*** PTIT - Port T Input Register; 0x00000241 ***/
typedef union {
  byte Byte;
  struct {
    byte PTIT0       :1;                                       /* Port T Bit 0 */
    byte PTIT1       :1;                                       /* Port T Bit 1 */
    byte PTIT2       :1;                                       /* Port T Bit 2 */
    byte PTIT3       :1;                                       /* Port T Bit 3 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpPTIT :4;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} PTITSTR;
extern volatile PTITSTR _PTIT @(REG_BASE + 0x00000241UL);
#define PTIT                            _PTIT.Byte
#define PTIT_PTIT0                      _PTIT.Bits.PTIT0
#define PTIT_PTIT1                      _PTIT.Bits.PTIT1
#define PTIT_PTIT2                      _PTIT.Bits.PTIT2
#define PTIT_PTIT3                      _PTIT.Bits.PTIT3
#define PTIT_PTIT                       _PTIT.MergedBits.grpPTIT

#define PTIT_PTIT0_MASK                 1U
#define PTIT_PTIT1_MASK                 2U
#define PTIT_PTIT2_MASK                 4U
#define PTIT_PTIT3_MASK                 8U
#define PTIT_PTIT_MASK                  15U
#define PTIT_PTIT_BITNUM                0U


/*** DDRT - Port T Data Direction Register; 0x00000242 ***/
typedef union {
  byte Byte;
  struct {
    byte DDRT0       :1;                                       /* Data Direction Port T Bit 0 */
    byte DDRT1       :1;                                       /* Data Direction Port T Bit 1 */
    byte DDRT2       :1;                                       /* Data Direction Port T Bit 2 */
    byte DDRT3       :1;                                       /* Data Direction Port T Bit 3 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpDDRT :4;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} DDRTSTR;
extern volatile DDRTSTR _DDRT @(REG_BASE + 0x00000242UL);
#define DDRT                            _DDRT.Byte
#define DDRT_DDRT0                      _DDRT.Bits.DDRT0
#define DDRT_DDRT1                      _DDRT.Bits.DDRT1
#define DDRT_DDRT2                      _DDRT.Bits.DDRT2
#define DDRT_DDRT3                      _DDRT.Bits.DDRT3
#define DDRT_DDRT                       _DDRT.MergedBits.grpDDRT

#define DDRT_DDRT0_MASK                 1U
#define DDRT_DDRT1_MASK                 2U
#define DDRT_DDRT2_MASK                 4U
#define DDRT_DDRT3_MASK                 8U
#define DDRT_DDRT_MASK                  15U
#define DDRT_DDRT_BITNUM                0U


/*** RDRT - Port T Reduced Drive Register; 0x00000243 ***/
typedef union {
  byte Byte;
  struct {
    byte RDRT0       :1;                                       /* Reduced Drive Port T Bit 0 */
    byte RDRT1       :1;                                       /* Reduced Drive Port T Bit 1 */
    byte RDRT2       :1;                                       /* Reduced Drive Port T Bit 2 */
    byte RDRT3       :1;                                       /* Reduced Drive Port T Bit 3 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpRDRT :4;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} RDRTSTR;
extern volatile RDRTSTR _RDRT @(REG_BASE + 0x00000243UL);
#define RDRT                            _RDRT.Byte
#define RDRT_RDRT0                      _RDRT.Bits.RDRT0
#define RDRT_RDRT1                      _RDRT.Bits.RDRT1
#define RDRT_RDRT2                      _RDRT.Bits.RDRT2
#define RDRT_RDRT3                      _RDRT.Bits.RDRT3
#define RDRT_RDRT                       _RDRT.MergedBits.grpRDRT

#define RDRT_RDRT0_MASK                 1U
#define RDRT_RDRT1_MASK                 2U
#define RDRT_RDRT2_MASK                 4U
#define RDRT_RDRT3_MASK                 8U
#define RDRT_RDRT_MASK                  15U
#define RDRT_RDRT_BITNUM                0U


/*** PERT - Port T Pull Device Enable Register; 0x00000244 ***/
typedef union {
  byte Byte;
  struct {
    byte PERT0       :1;                                       /* Pull Device Enable Port T Bit 0 */
    byte PERT1       :1;                                       /* Pull Device Enable Port T Bit 1 */
    byte PERT2       :1;                                       /* Pull Device Enable Port T Bit 2 */
    byte PERT3       :1;                                       /* Pull Device Enable Port T Bit 3 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpPERT :4;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} PERTSTR;
extern volatile PERTSTR _PERT @(REG_BASE + 0x00000244UL);
#define PERT                            _PERT.Byte
#define PERT_PERT0                      _PERT.Bits.PERT0
#define PERT_PERT1                      _PERT.Bits.PERT1
#define PERT_PERT2                      _PERT.Bits.PERT2
#define PERT_PERT3                      _PERT.Bits.PERT3
#define PERT_PERT                       _PERT.MergedBits.grpPERT

#define PERT_PERT0_MASK                 1U
#define PERT_PERT1_MASK                 2U
#define PERT_PERT2_MASK                 4U
#define PERT_PERT3_MASK                 8U
#define PERT_PERT_MASK                  15U
#define PERT_PERT_BITNUM                0U


/*** PPST - Port T Polarity Select Register; 0x00000245 ***/
typedef union {
  byte Byte;
  struct {
    byte PPST0       :1;                                       /* Pull Select Port T Bit 0 */
    byte PPST1       :1;                                       /* Pull Select Port T Bit 1 */
    byte PPST2       :1;                                       /* Pull Select Port T Bit 2 */
    byte PPST3       :1;                                       /* Pull Select Port T Bit 3 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpPPST :4;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} PPSTSTR;
extern volatile PPSTSTR _PPST @(REG_BASE + 0x00000245UL);
#define PPST                            _PPST.Byte
#define PPST_PPST0                      _PPST.Bits.PPST0
#define PPST_PPST1                      _PPST.Bits.PPST1
#define PPST_PPST2                      _PPST.Bits.PPST2
#define PPST_PPST3                      _PPST.Bits.PPST3
#define PPST_PPST                       _PPST.MergedBits.grpPPST

#define PPST_PPST0_MASK                 1U
#define PPST_PPST1_MASK                 2U
#define PPST_PPST2_MASK                 4U
#define PPST_PPST3_MASK                 8U
#define PPST_PPST_MASK                  15U
#define PPST_PPST_BITNUM                0U


/*** PTM - Port M I/O Register; 0x00000248 ***/
typedef union {
  byte Byte;
  struct {
    byte PTM0        :1;                                       /* Port M Bit 0 */
    byte PTM1        :1;                                       /* Port M Bit 1 */
    byte PTM2        :1;                                       /* Port M Bit 2 */
    byte PTM3        :1;                                       /* Port M Bit 3 */
    byte PTM4        :1;                                       /* Port M Bit 4 */
    byte PTM5        :1;                                       /* Port M Bit 5 */
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpPTM  :6;
    byte         :1;
    byte         :1;
  } MergedBits;
} PTMSTR;
extern volatile PTMSTR _PTM @(REG_BASE + 0x00000248UL);
#define PTM                             _PTM.Byte
#define PTM_PTM0                        _PTM.Bits.PTM0
#define PTM_PTM1                        _PTM.Bits.PTM1
#define PTM_PTM2                        _PTM.Bits.PTM2
#define PTM_PTM3                        _PTM.Bits.PTM3
#define PTM_PTM4                        _PTM.Bits.PTM4
#define PTM_PTM5                        _PTM.Bits.PTM5
#define PTM_PTM                         _PTM.MergedBits.grpPTM

#define PTM_PTM0_MASK                   1U
#define PTM_PTM1_MASK                   2U
#define PTM_PTM2_MASK                   4U
#define PTM_PTM3_MASK                   8U
#define PTM_PTM4_MASK                   16U
#define PTM_PTM5_MASK                   32U
#define PTM_PTM_MASK                    63U
#define PTM_PTM_BITNUM                  0U


/*** PTIM - Port M Input Register; 0x00000249 ***/
typedef union {
  byte Byte;
  struct {
    byte PTIM0       :1;                                       /* Port M Bit 0 */
    byte PTIM1       :1;                                       /* Port M Bit 1 */
    byte PTIM2       :1;                                       /* Port M Bit 2 */
    byte PTIM3       :1;                                       /* Port M Bit 3 */
    byte PTIM4       :1;                                       /* Port M Bit 4 */
    byte PTIM5       :1;                                       /* Port M Bit 5 */
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpPTIM :6;
    byte         :1;
    byte         :1;
  } MergedBits;
} PTIMSTR;
extern volatile PTIMSTR _PTIM @(REG_BASE + 0x00000249UL);
#define PTIM                            _PTIM.Byte
#define PTIM_PTIM0                      _PTIM.Bits.PTIM0
#define PTIM_PTIM1                      _PTIM.Bits.PTIM1
#define PTIM_PTIM2                      _PTIM.Bits.PTIM2
#define PTIM_PTIM3                      _PTIM.Bits.PTIM3
#define PTIM_PTIM4                      _PTIM.Bits.PTIM4
#define PTIM_PTIM5                      _PTIM.Bits.PTIM5
#define PTIM_PTIM                       _PTIM.MergedBits.grpPTIM

#define PTIM_PTIM0_MASK                 1U
#define PTIM_PTIM1_MASK                 2U
#define PTIM_PTIM2_MASK                 4U
#define PTIM_PTIM3_MASK                 8U
#define PTIM_PTIM4_MASK                 16U
#define PTIM_PTIM5_MASK                 32U
#define PTIM_PTIM_MASK                  63U
#define PTIM_PTIM_BITNUM                0U


/*** DDRM - Port M Data Direction Register; 0x0000024A ***/
typedef union {
  byte Byte;
  struct {
    byte DDRM0       :1;                                       /* Data Direction Port M Bit 0 */
    byte DDRM1       :1;                                       /* Data Direction Port M Bit 1 */
    byte DDRM2       :1;                                       /* Data Direction Port M Bit 2 */
    byte DDRM3       :1;                                       /* Data Direction Port M Bit 3 */
    byte DDRM4       :1;                                       /* Data Direction Port M Bit 4 */
    byte DDRM5       :1;                                       /* Data Direction Port M Bit 5 */
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpDDRM :6;
    byte         :1;
    byte         :1;
  } MergedBits;
} DDRMSTR;
extern volatile DDRMSTR _DDRM @(REG_BASE + 0x0000024AUL);
#define DDRM                            _DDRM.Byte
#define DDRM_DDRM0                      _DDRM.Bits.DDRM0
#define DDRM_DDRM1                      _DDRM.Bits.DDRM1
#define DDRM_DDRM2                      _DDRM.Bits.DDRM2
#define DDRM_DDRM3                      _DDRM.Bits.DDRM3
#define DDRM_DDRM4                      _DDRM.Bits.DDRM4
#define DDRM_DDRM5                      _DDRM.Bits.DDRM5
#define DDRM_DDRM                       _DDRM.MergedBits.grpDDRM

#define DDRM_DDRM0_MASK                 1U
#define DDRM_DDRM1_MASK                 2U
#define DDRM_DDRM2_MASK                 4U
#define DDRM_DDRM3_MASK                 8U
#define DDRM_DDRM4_MASK                 16U
#define DDRM_DDRM5_MASK                 32U
#define DDRM_DDRM_MASK                  63U
#define DDRM_DDRM_BITNUM                0U


/*** RDRM - Port M Reduced Drive Register; 0x0000024B ***/
typedef union {
  byte Byte;
  struct {
    byte RDRM0       :1;                                       /* Reduced Drive Port M Bit 0 */
    byte RDRM1       :1;                                       /* Reduced Drive Port M Bit 1 */
    byte RDRM2       :1;                                       /* Reduced Drive Port M Bit 2 */
    byte RDRM3       :1;                                       /* Reduced Drive Port M Bit 3 */
    byte RDRM4       :1;                                       /* Reduced Drive Port M Bit 4 */
    byte RDRM5       :1;                                       /* Reduced Drive Port M Bit 5 */
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpRDRM :6;
    byte         :1;
    byte         :1;
  } MergedBits;
} RDRMSTR;
extern volatile RDRMSTR _RDRM @(REG_BASE + 0x0000024BUL);
#define RDRM                            _RDRM.Byte
#define RDRM_RDRM0                      _RDRM.Bits.RDRM0
#define RDRM_RDRM1                      _RDRM.Bits.RDRM1
#define RDRM_RDRM2                      _RDRM.Bits.RDRM2
#define RDRM_RDRM3                      _RDRM.Bits.RDRM3
#define RDRM_RDRM4                      _RDRM.Bits.RDRM4
#define RDRM_RDRM5                      _RDRM.Bits.RDRM5
#define RDRM_RDRM                       _RDRM.MergedBits.grpRDRM

#define RDRM_RDRM0_MASK                 1U
#define RDRM_RDRM1_MASK                 2U
#define RDRM_RDRM2_MASK                 4U
#define RDRM_RDRM3_MASK                 8U
#define RDRM_RDRM4_MASK                 16U
#define RDRM_RDRM5_MASK                 32U
#define RDRM_RDRM_MASK                  63U
#define RDRM_RDRM_BITNUM                0U


/*** PERM - Port M Pull Device Enable Register; 0x0000024C ***/
typedef union {
  byte Byte;
  struct {
    byte PERM0       :1;                                       /* Pull Device Enable Port M Bit 0 */
    byte PERM1       :1;                                       /* Pull Device Enable Port M Bit 1 */
    byte PERM2       :1;                                       /* Pull Device Enable Port M Bit 2 */
    byte PERM3       :1;                                       /* Pull Device Enable Port M Bit 3 */
    byte PERM4       :1;                                       /* Pull Device Enable Port M Bit 4 */
    byte PERM5       :1;                                       /* Pull Device Enable Port M Bit 5 */
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpPERM :6;
    byte         :1;
    byte         :1;
  } MergedBits;
} PERMSTR;
extern volatile PERMSTR _PERM @(REG_BASE + 0x0000024CUL);
#define PERM                            _PERM.Byte
#define PERM_PERM0                      _PERM.Bits.PERM0
#define PERM_PERM1                      _PERM.Bits.PERM1
#define PERM_PERM2                      _PERM.Bits.PERM2
#define PERM_PERM3                      _PERM.Bits.PERM3
#define PERM_PERM4                      _PERM.Bits.PERM4
#define PERM_PERM5                      _PERM.Bits.PERM5
#define PERM_PERM                       _PERM.MergedBits.grpPERM

#define PERM_PERM0_MASK                 1U
#define PERM_PERM1_MASK                 2U
#define PERM_PERM2_MASK                 4U
#define PERM_PERM3_MASK                 8U
#define PERM_PERM4_MASK                 16U
#define PERM_PERM5_MASK                 32U
#define PERM_PERM_MASK                  63U
#define PERM_PERM_BITNUM                0U


/*** PPSM - Port M Polarity Select Register; 0x0000024D ***/
typedef union {
  byte Byte;
  struct {
    byte PPSM0       :1;                                       /* Pull Select Port M Bit 0 */
    byte PPSM1       :1;                                       /* Pull Select Port M Bit 1 */
    byte PPSM2       :1;                                       /* Pull Select Port M Bit 2 */
    byte PPSM3       :1;                                       /* Pull Select Port M Bit 3 */
    byte PPSM4       :1;                                       /* Pull Select Port M Bit 4 */
    byte PPSM5       :1;                                       /* Pull Select Port M Bit 5 */
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpPPSM :6;
    byte         :1;
    byte         :1;
  } MergedBits;
} PPSMSTR;
extern volatile PPSMSTR _PPSM @(REG_BASE + 0x0000024DUL);
#define PPSM                            _PPSM.Byte
#define PPSM_PPSM0                      _PPSM.Bits.PPSM0
#define PPSM_PPSM1                      _PPSM.Bits.PPSM1
#define PPSM_PPSM2                      _PPSM.Bits.PPSM2
#define PPSM_PPSM3                      _PPSM.Bits.PPSM3
#define PPSM_PPSM4                      _PPSM.Bits.PPSM4
#define PPSM_PPSM5                      _PPSM.Bits.PPSM5
#define PPSM_PPSM                       _PPSM.MergedBits.grpPPSM

#define PPSM_PPSM0_MASK                 1U
#define PPSM_PPSM1_MASK                 2U
#define PPSM_PPSM2_MASK                 4U
#define PPSM_PPSM3_MASK                 8U
#define PPSM_PPSM4_MASK                 16U
#define PPSM_PPSM5_MASK                 32U
#define PPSM_PPSM_MASK                  63U
#define PPSM_PPSM_BITNUM                0U


/*** PTJ - Port J I/O Register; 0x00000250 ***/
typedef union {
  byte Byte;
  struct {
    byte PTJ0        :1;                                       /* Port J Bit 0 */
    byte PTJ1        :1;                                       /* Port J Bit 1 */
    byte PTJ2        :1;                                       /* Port J Bit 2 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpPTJ  :3;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} PTJSTR;
extern volatile PTJSTR _PTJ @(REG_BASE + 0x00000250UL);
#define PTJ                             _PTJ.Byte
#define PTJ_PTJ0                        _PTJ.Bits.PTJ0
#define PTJ_PTJ1                        _PTJ.Bits.PTJ1
#define PTJ_PTJ2                        _PTJ.Bits.PTJ2
#define PTJ_PTJ                         _PTJ.MergedBits.grpPTJ

#define PTJ_PTJ0_MASK                   1U
#define PTJ_PTJ1_MASK                   2U
#define PTJ_PTJ2_MASK                   4U
#define PTJ_PTJ_MASK                    7U
#define PTJ_PTJ_BITNUM                  0U


/*** PTIJ - Port J Input Register; 0x00000251 ***/
typedef union {
  byte Byte;
  struct {
    byte PTIJ0       :1;                                       /* Port J Bit 0 */
    byte PTIJ1       :1;                                       /* Port J Bit 1 */
    byte PTIJ2       :1;                                       /* Port J Bit 2 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpPTIJ :3;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} PTIJSTR;
extern volatile PTIJSTR _PTIJ @(REG_BASE + 0x00000251UL);
#define PTIJ                            _PTIJ.Byte
#define PTIJ_PTIJ0                      _PTIJ.Bits.PTIJ0
#define PTIJ_PTIJ1                      _PTIJ.Bits.PTIJ1
#define PTIJ_PTIJ2                      _PTIJ.Bits.PTIJ2
#define PTIJ_PTIJ                       _PTIJ.MergedBits.grpPTIJ

#define PTIJ_PTIJ0_MASK                 1U
#define PTIJ_PTIJ1_MASK                 2U
#define PTIJ_PTIJ2_MASK                 4U
#define PTIJ_PTIJ_MASK                  7U
#define PTIJ_PTIJ_BITNUM                0U


/*** DDRJ - Port J Data Direction Register; 0x00000252 ***/
typedef union {
  byte Byte;
  struct {
    byte DDRJ0       :1;                                       /* Data Direction Port J Bit 0 */
    byte DDRJ1       :1;                                       /* Data Direction Port J Bit 1 */
    byte DDRJ2       :1;                                       /* Data Direction Port J Bit 2 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpDDRJ :3;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} DDRJSTR;
extern volatile DDRJSTR _DDRJ @(REG_BASE + 0x00000252UL);
#define DDRJ                            _DDRJ.Byte
#define DDRJ_DDRJ0                      _DDRJ.Bits.DDRJ0
#define DDRJ_DDRJ1                      _DDRJ.Bits.DDRJ1
#define DDRJ_DDRJ2                      _DDRJ.Bits.DDRJ2
#define DDRJ_DDRJ                       _DDRJ.MergedBits.grpDDRJ

#define DDRJ_DDRJ0_MASK                 1U
#define DDRJ_DDRJ1_MASK                 2U
#define DDRJ_DDRJ2_MASK                 4U
#define DDRJ_DDRJ_MASK                  7U
#define DDRJ_DDRJ_BITNUM                0U


/*** RDRJ - Port J Reduced Drive Register; 0x00000253 ***/
typedef union {
  byte Byte;
  struct {
    byte RDRJ0       :1;                                       /* Reduced Drive Port J Bit 0 */
    byte RDRJ1       :1;                                       /* Reduced Drive Port J Bit 1 */
    byte RDRJ2       :1;                                       /* Reduced Drive Port J Bit 2 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpRDRJ :3;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} RDRJSTR;
extern volatile RDRJSTR _RDRJ @(REG_BASE + 0x00000253UL);
#define RDRJ                            _RDRJ.Byte
#define RDRJ_RDRJ0                      _RDRJ.Bits.RDRJ0
#define RDRJ_RDRJ1                      _RDRJ.Bits.RDRJ1
#define RDRJ_RDRJ2                      _RDRJ.Bits.RDRJ2
#define RDRJ_RDRJ                       _RDRJ.MergedBits.grpRDRJ

#define RDRJ_RDRJ0_MASK                 1U
#define RDRJ_RDRJ1_MASK                 2U
#define RDRJ_RDRJ2_MASK                 4U
#define RDRJ_RDRJ_MASK                  7U
#define RDRJ_RDRJ_BITNUM                0U


/*** PERJ - Port J Pull Device Enable Register; 0x00000254 ***/
typedef union {
  byte Byte;
  struct {
    byte PERJ0       :1;                                       /* Pull Device Enable Port J Bit 0 */
    byte PERJ1       :1;                                       /* Pull Device Enable Port J Bit 1 */
    byte PERJ2       :1;                                       /* Pull Device Enable Port J Bit 2 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpPERJ :3;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} PERJSTR;
extern volatile PERJSTR _PERJ @(REG_BASE + 0x00000254UL);
#define PERJ                            _PERJ.Byte
#define PERJ_PERJ0                      _PERJ.Bits.PERJ0
#define PERJ_PERJ1                      _PERJ.Bits.PERJ1
#define PERJ_PERJ2                      _PERJ.Bits.PERJ2
#define PERJ_PERJ                       _PERJ.MergedBits.grpPERJ

#define PERJ_PERJ0_MASK                 1U
#define PERJ_PERJ1_MASK                 2U
#define PERJ_PERJ2_MASK                 4U
#define PERJ_PERJ_MASK                  7U
#define PERJ_PERJ_BITNUM                0U


/*** PPSJ - PortJP Polarity Select Register; 0x00000255 ***/
typedef union {
  byte Byte;
  struct {
    byte PPSJ0       :1;                                       /* Pull Select Port J Bit 0 */
    byte PPSJ1       :1;                                       /* Pull Select Port J Bit 1 */
    byte PPSJ2       :1;                                       /* Pull Select Port J Bit 2 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpPPSJ :3;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} PPSJSTR;
extern volatile PPSJSTR _PPSJ @(REG_BASE + 0x00000255UL);
#define PPSJ                            _PPSJ.Byte
#define PPSJ_PPSJ0                      _PPSJ.Bits.PPSJ0
#define PPSJ_PPSJ1                      _PPSJ.Bits.PPSJ1
#define PPSJ_PPSJ2                      _PPSJ.Bits.PPSJ2
#define PPSJ_PPSJ                       _PPSJ.MergedBits.grpPPSJ

#define PPSJ_PPSJ0_MASK                 1U
#define PPSJ_PPSJ1_MASK                 2U
#define PPSJ_PPSJ2_MASK                 4U
#define PPSJ_PPSJ_MASK                  7U
#define PPSJ_PPSJ_BITNUM                0U


/*** MODRR - Module Routing Register; 0x00000257 ***/
typedef union {
  byte Byte;
  struct {
    byte MODRR0      :1;                                       /* Module Routing Bit 0 */
    byte MODRR1      :1;                                       /* Module Routing Bit 1 */
    byte MODRR2      :1;                                       /* Module Routing Bit 2 */
    byte MODRR3      :1;                                       /* Module Routing Bit 3 */
    byte MODRR4      :1;                                       /* Module Routing Bit 4 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpMODRR :5;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} MODRRSTR;
extern volatile MODRRSTR _MODRR @(REG_BASE + 0x00000257UL);
#define MODRR                           _MODRR.Byte
#define MODRR_MODRR0                    _MODRR.Bits.MODRR0
#define MODRR_MODRR1                    _MODRR.Bits.MODRR1
#define MODRR_MODRR2                    _MODRR.Bits.MODRR2
#define MODRR_MODRR3                    _MODRR.Bits.MODRR3
#define MODRR_MODRR4                    _MODRR.Bits.MODRR4
#define MODRR_MODRR                     _MODRR.MergedBits.grpMODRR

#define MODRR_MODRR0_MASK               1U
#define MODRR_MODRR1_MASK               2U
#define MODRR_MODRR2_MASK               4U
#define MODRR_MODRR3_MASK               8U
#define MODRR_MODRR4_MASK               16U
#define MODRR_MODRR_MASK                31U
#define MODRR_MODRR_BITNUM              0U


/*** PTP - Port P I/O Register; 0x00000258 ***/
typedef union {
  byte Byte;
  struct {
    byte PTP0        :1;                                       /* Port P Bit 0 */
    byte PTP1        :1;                                       /* Port P Bit 1 */
    byte PTP2        :1;                                       /* Port P Bit 2 */
    byte PTP3        :1;                                       /* Port P Bit 3 */
    byte PTP4        :1;                                       /* Port P Bit 4 */
    byte PTP5        :1;                                       /* Port P Bit 5 */
    byte PTP6        :1;                                       /* Port P Bit 6 */
    byte PTP7        :1;                                       /* Port P Bit 7 */
  } Bits;
} PTPSTR;
extern volatile PTPSTR _PTP @(REG_BASE + 0x00000258UL);
#define PTP                             _PTP.Byte
#define PTP_PTP0                        _PTP.Bits.PTP0
#define PTP_PTP1                        _PTP.Bits.PTP1
#define PTP_PTP2                        _PTP.Bits.PTP2
#define PTP_PTP3                        _PTP.Bits.PTP3
#define PTP_PTP4                        _PTP.Bits.PTP4
#define PTP_PTP5                        _PTP.Bits.PTP5
#define PTP_PTP6                        _PTP.Bits.PTP6
#define PTP_PTP7                        _PTP.Bits.PTP7

#define PTP_PTP0_MASK                   1U
#define PTP_PTP1_MASK                   2U
#define PTP_PTP2_MASK                   4U
#define PTP_PTP3_MASK                   8U
#define PTP_PTP4_MASK                   16U
#define PTP_PTP5_MASK                   32U
#define PTP_PTP6_MASK                   64U
#define PTP_PTP7_MASK                   128U


/*** PTIP - Port P Input Register; 0x00000259 ***/
typedef union {
  byte Byte;
  struct {
    byte PTIP0       :1;                                       /* Port P Bit 0 */
    byte PTIP1       :1;                                       /* Port P Bit 1 */
    byte PTIP2       :1;                                       /* Port P Bit 2 */
    byte PTIP3       :1;                                       /* Port P Bit 3 */
    byte PTIP4       :1;                                       /* Port P Bit 4 */
    byte PTIP5       :1;                                       /* Port P Bit 5 */
    byte PTIP6       :1;                                       /* Port P Bit 6 */
    byte PTIP7       :1;                                       /* Port P Bit 7 */
  } Bits;
} PTIPSTR;
extern volatile PTIPSTR _PTIP @(REG_BASE + 0x00000259UL);
#define PTIP                            _PTIP.Byte
#define PTIP_PTIP0                      _PTIP.Bits.PTIP0
#define PTIP_PTIP1                      _PTIP.Bits.PTIP1
#define PTIP_PTIP2                      _PTIP.Bits.PTIP2
#define PTIP_PTIP3                      _PTIP.Bits.PTIP3
#define PTIP_PTIP4                      _PTIP.Bits.PTIP4
#define PTIP_PTIP5                      _PTIP.Bits.PTIP5
#define PTIP_PTIP6                      _PTIP.Bits.PTIP6
#define PTIP_PTIP7                      _PTIP.Bits.PTIP7

#define PTIP_PTIP0_MASK                 1U
#define PTIP_PTIP1_MASK                 2U
#define PTIP_PTIP2_MASK                 4U
#define PTIP_PTIP3_MASK                 8U
#define PTIP_PTIP4_MASK                 16U
#define PTIP_PTIP5_MASK                 32U
#define PTIP_PTIP6_MASK                 64U
#define PTIP_PTIP7_MASK                 128U


/*** DDRP - Port P Data Direction Register; 0x0000025A ***/
typedef union {
  byte Byte;
  struct {
    byte DDRP0       :1;                                       /* Data Direction Port P Bit 0 */
    byte DDRP1       :1;                                       /* Data Direction Port P Bit 1 */
    byte DDRP2       :1;                                       /* Data Direction Port P Bit 2 */
    byte DDRP3       :1;                                       /* Data Direction Port P Bit 3 */
    byte DDRP4       :1;                                       /* Data Direction Port P Bit 4 */
    byte DDRP5       :1;                                       /* Data Direction Port P Bit 5 */
    byte DDRP6       :1;                                       /* Data Direction Port P Bit 6 */
    byte DDRP7       :1;                                       /* Data Direction Port P Bit 7 */
  } Bits;
} DDRPSTR;
extern volatile DDRPSTR _DDRP @(REG_BASE + 0x0000025AUL);
#define DDRP                            _DDRP.Byte
#define DDRP_DDRP0                      _DDRP.Bits.DDRP0
#define DDRP_DDRP1                      _DDRP.Bits.DDRP1
#define DDRP_DDRP2                      _DDRP.Bits.DDRP2
#define DDRP_DDRP3                      _DDRP.Bits.DDRP3
#define DDRP_DDRP4                      _DDRP.Bits.DDRP4
#define DDRP_DDRP5                      _DDRP.Bits.DDRP5
#define DDRP_DDRP6                      _DDRP.Bits.DDRP6
#define DDRP_DDRP7                      _DDRP.Bits.DDRP7

#define DDRP_DDRP0_MASK                 1U
#define DDRP_DDRP1_MASK                 2U
#define DDRP_DDRP2_MASK                 4U
#define DDRP_DDRP3_MASK                 8U
#define DDRP_DDRP4_MASK                 16U
#define DDRP_DDRP5_MASK                 32U
#define DDRP_DDRP6_MASK                 64U
#define DDRP_DDRP7_MASK                 128U


/*** RDRP - Port P Reduced Drive Register; 0x0000025B ***/
typedef union {
  byte Byte;
  struct {
    byte RDRP0       :1;                                       /* Reduced Drive Port P Bit 0 */
    byte RDRP1       :1;                                       /* Reduced Drive Port P Bit 1 */
    byte RDRP2       :1;                                       /* Reduced Drive Port P Bit 2 */
    byte RDRP3       :1;                                       /* Reduced Drive Port P Bit 3 */
    byte RDRP4       :1;                                       /* Reduced Drive Port P Bit 4 */
    byte RDRP5       :1;                                       /* Reduced Drive Port P Bit 5 */
    byte RDRP6       :1;                                       /* Reduced Drive Port P Bit 6 */
    byte RDRP7       :1;                                       /* Reduced Drive Port P Bit 7 */
  } Bits;
} RDRPSTR;
extern volatile RDRPSTR _RDRP @(REG_BASE + 0x0000025BUL);
#define RDRP                            _RDRP.Byte
#define RDRP_RDRP0                      _RDRP.Bits.RDRP0
#define RDRP_RDRP1                      _RDRP.Bits.RDRP1
#define RDRP_RDRP2                      _RDRP.Bits.RDRP2
#define RDRP_RDRP3                      _RDRP.Bits.RDRP3
#define RDRP_RDRP4                      _RDRP.Bits.RDRP4
#define RDRP_RDRP5                      _RDRP.Bits.RDRP5
#define RDRP_RDRP6                      _RDRP.Bits.RDRP6
#define RDRP_RDRP7                      _RDRP.Bits.RDRP7

#define RDRP_RDRP0_MASK                 1U
#define RDRP_RDRP1_MASK                 2U
#define RDRP_RDRP2_MASK                 4U
#define RDRP_RDRP3_MASK                 8U
#define RDRP_RDRP4_MASK                 16U
#define RDRP_RDRP5_MASK                 32U
#define RDRP_RDRP6_MASK                 64U
#define RDRP_RDRP7_MASK                 128U


/*** PERP - Port P Pull Device Enable Register; 0x0000025C ***/
typedef union {
  byte Byte;
  struct {
    byte PERP0       :1;                                       /* Pull Device Enable Port P Bit 0 */
    byte PERP1       :1;                                       /* Pull Device Enable Port P Bit 1 */
    byte PERP2       :1;                                       /* Pull Device Enable Port P Bit 2 */
    byte PERP3       :1;                                       /* Pull Device Enable Port P Bit 3 */
    byte PERP4       :1;                                       /* Pull Device Enable Port P Bit 4 */
    byte PERP5       :1;                                       /* Pull Device Enable Port P Bit 5 */
    byte PERP6       :1;                                       /* Pull Device Enable Port P Bit 6 */
    byte PERP7       :1;                                       /* Pull Device Enable Port P Bit 7 */
  } Bits;
} PERPSTR;
extern volatile PERPSTR _PERP @(REG_BASE + 0x0000025CUL);
#define PERP                            _PERP.Byte
#define PERP_PERP0                      _PERP.Bits.PERP0
#define PERP_PERP1                      _PERP.Bits.PERP1
#define PERP_PERP2                      _PERP.Bits.PERP2
#define PERP_PERP3                      _PERP.Bits.PERP3
#define PERP_PERP4                      _PERP.Bits.PERP4
#define PERP_PERP5                      _PERP.Bits.PERP5
#define PERP_PERP6                      _PERP.Bits.PERP6
#define PERP_PERP7                      _PERP.Bits.PERP7

#define PERP_PERP0_MASK                 1U
#define PERP_PERP1_MASK                 2U
#define PERP_PERP2_MASK                 4U
#define PERP_PERP3_MASK                 8U
#define PERP_PERP4_MASK                 16U
#define PERP_PERP5_MASK                 32U
#define PERP_PERP6_MASK                 64U
#define PERP_PERP7_MASK                 128U


/*** PPSP - Port P Polarity Select Register; 0x0000025D ***/
typedef union {
  byte Byte;
  struct {
    byte PPSP0       :1;                                       /* Pull Select Port P Bit 0 */
    byte PPSP1       :1;                                       /* Pull Select Port P Bit 1 */
    byte PPSP2       :1;                                       /* Pull Select Port P Bit 2 */
    byte PPSP3       :1;                                       /* Pull Select Port P Bit 3 */
    byte PPSP4       :1;                                       /* Pull Select Port P Bit 4 */
    byte PPSP5       :1;                                       /* Pull Select Port P Bit 5 */
    byte PPSP6       :1;                                       /* Pull Select Port P Bit 6 */
    byte PPSP7       :1;                                       /* Pull Select Port P Bit 7 */
  } Bits;
} PPSPSTR;
extern volatile PPSPSTR _PPSP @(REG_BASE + 0x0000025DUL);
#define PPSP                            _PPSP.Byte
#define PPSP_PPSP0                      _PPSP.Bits.PPSP0
#define PPSP_PPSP1                      _PPSP.Bits.PPSP1
#define PPSP_PPSP2                      _PPSP.Bits.PPSP2
#define PPSP_PPSP3                      _PPSP.Bits.PPSP3
#define PPSP_PPSP4                      _PPSP.Bits.PPSP4
#define PPSP_PPSP5                      _PPSP.Bits.PPSP5
#define PPSP_PPSP6                      _PPSP.Bits.PPSP6
#define PPSP_PPSP7                      _PPSP.Bits.PPSP7

#define PPSP_PPSP0_MASK                 1U
#define PPSP_PPSP1_MASK                 2U
#define PPSP_PPSP2_MASK                 4U
#define PPSP_PPSP3_MASK                 8U
#define PPSP_PPSP4_MASK                 16U
#define PPSP_PPSP5_MASK                 32U
#define PPSP_PPSP6_MASK                 64U
#define PPSP_PPSP7_MASK                 128U


/*** PTQ - Port Q I/O Register; 0x00000260 ***/
typedef union {
  byte Byte;
  struct {
    byte PTQ0        :1;                                       /* Port Q Bit 0 */
    byte PTQ1        :1;                                       /* Port Q Bit 1 */
    byte PTQ2        :1;                                       /* Port Q Bit 2 */
    byte PTQ3        :1;                                       /* Port Q Bit 3 */
    byte PTQ4        :1;                                       /* Port Q Bit 4 */
    byte PTQ5        :1;                                       /* Port Q Bit 5 */
    byte PTQ6        :1;                                       /* Port Q Bit 6 */
    byte PTQ7        :1;                                       /* Port Q Bit 7 */
  } Bits;
} PTQSTR;
extern volatile PTQSTR _PTQ @(REG_BASE + 0x00000260UL);
#define PTQ                             _PTQ.Byte
#define PTQ_PTQ0                        _PTQ.Bits.PTQ0
#define PTQ_PTQ1                        _PTQ.Bits.PTQ1
#define PTQ_PTQ2                        _PTQ.Bits.PTQ2
#define PTQ_PTQ3                        _PTQ.Bits.PTQ3
#define PTQ_PTQ4                        _PTQ.Bits.PTQ4
#define PTQ_PTQ5                        _PTQ.Bits.PTQ5
#define PTQ_PTQ6                        _PTQ.Bits.PTQ6
#define PTQ_PTQ7                        _PTQ.Bits.PTQ7

#define PTQ_PTQ0_MASK                   1U
#define PTQ_PTQ1_MASK                   2U
#define PTQ_PTQ2_MASK                   4U
#define PTQ_PTQ3_MASK                   8U
#define PTQ_PTQ4_MASK                   16U
#define PTQ_PTQ5_MASK                   32U
#define PTQ_PTQ6_MASK                   64U
#define PTQ_PTQ7_MASK                   128U


/*** PTIQ - Port Q Input Register; 0x00000261 ***/
typedef union {
  byte Byte;
  struct {
    byte PTIQ0       :1;                                       /* Port Q Bit 0 */
    byte PTIQ1       :1;                                       /* Port Q Bit 1 */
    byte PTIQ2       :1;                                       /* Port Q Bit 2 */
    byte PTIQ3       :1;                                       /* Port Q Bit 3 */
    byte PTIQ4       :1;                                       /* Port Q Bit 4 */
    byte PTIQ5       :1;                                       /* Port Q Bit 5 */
    byte PTIQ6       :1;                                       /* Port Q Bit 6 */
    byte PTIQ7       :1;                                       /* Port Q Bit 7 */
  } Bits;
} PTIQSTR;
extern volatile PTIQSTR _PTIQ @(REG_BASE + 0x00000261UL);
#define PTIQ                            _PTIQ.Byte
#define PTIQ_PTIQ0                      _PTIQ.Bits.PTIQ0
#define PTIQ_PTIQ1                      _PTIQ.Bits.PTIQ1
#define PTIQ_PTIQ2                      _PTIQ.Bits.PTIQ2
#define PTIQ_PTIQ3                      _PTIQ.Bits.PTIQ3
#define PTIQ_PTIQ4                      _PTIQ.Bits.PTIQ4
#define PTIQ_PTIQ5                      _PTIQ.Bits.PTIQ5
#define PTIQ_PTIQ6                      _PTIQ.Bits.PTIQ6
#define PTIQ_PTIQ7                      _PTIQ.Bits.PTIQ7

#define PTIQ_PTIQ0_MASK                 1U
#define PTIQ_PTIQ1_MASK                 2U
#define PTIQ_PTIQ2_MASK                 4U
#define PTIQ_PTIQ3_MASK                 8U
#define PTIQ_PTIQ4_MASK                 16U
#define PTIQ_PTIQ5_MASK                 32U
#define PTIQ_PTIQ6_MASK                 64U
#define PTIQ_PTIQ7_MASK                 128U


/*** DDRQ - Port Q Data Direction Register; 0x00000262 ***/
typedef union {
  byte Byte;
  struct {
    byte DDRQ0       :1;                                       /* Data Direction Port Q Bit 0 */
    byte DDRQ1       :1;                                       /* Data Direction Port Q Bit 1 */
    byte DDRQ2       :1;                                       /* Data Direction Port Q Bit 2 */
    byte DDRQ3       :1;                                       /* Data Direction Port Q Bit 3 */
    byte DDRQ4       :1;                                       /* Data Direction Port Q Bit 4 */
    byte DDRQ5       :1;                                       /* Data Direction Port Q Bit 5 */
    byte DDRQ6       :1;                                       /* Data Direction Port Q Bit 6 */
    byte DDRQ7       :1;                                       /* Data Direction Port Q Bit 7 */
  } Bits;
} DDRQSTR;
extern volatile DDRQSTR _DDRQ @(REG_BASE + 0x00000262UL);
#define DDRQ                            _DDRQ.Byte
#define DDRQ_DDRQ0                      _DDRQ.Bits.DDRQ0
#define DDRQ_DDRQ1                      _DDRQ.Bits.DDRQ1
#define DDRQ_DDRQ2                      _DDRQ.Bits.DDRQ2
#define DDRQ_DDRQ3                      _DDRQ.Bits.DDRQ3
#define DDRQ_DDRQ4                      _DDRQ.Bits.DDRQ4
#define DDRQ_DDRQ5                      _DDRQ.Bits.DDRQ5
#define DDRQ_DDRQ6                      _DDRQ.Bits.DDRQ6
#define DDRQ_DDRQ7                      _DDRQ.Bits.DDRQ7

#define DDRQ_DDRQ0_MASK                 1U
#define DDRQ_DDRQ1_MASK                 2U
#define DDRQ_DDRQ2_MASK                 4U
#define DDRQ_DDRQ3_MASK                 8U
#define DDRQ_DDRQ4_MASK                 16U
#define DDRQ_DDRQ5_MASK                 32U
#define DDRQ_DDRQ6_MASK                 64U
#define DDRQ_DDRQ7_MASK                 128U


/*** RDRQ - Port Q Reduced Drive Register; 0x00000263 ***/
typedef union {
  byte Byte;
  struct {
    byte RDRQ0       :1;                                       /* Reduced Drive Port Q Bit 0 */
    byte RDRQ1       :1;                                       /* Reduced Drive Port Q Bit 1 */
    byte RDRQ2       :1;                                       /* Reduced Drive Port Q Bit 2 */
    byte RDRQ3       :1;                                       /* Reduced Drive Port Q Bit 3 */
    byte RDRQ4       :1;                                       /* Reduced Drive Port Q Bit 4 */
    byte RDRQ5       :1;                                       /* Reduced Drive Port Q Bit 5 */
    byte RDRQ6       :1;                                       /* Reduced Drive Port Q Bit 6 */
    byte RDRQ7       :1;                                       /* Reduced Drive Port Q Bit 7 */
  } Bits;
} RDRQSTR;
extern volatile RDRQSTR _RDRQ @(REG_BASE + 0x00000263UL);
#define RDRQ                            _RDRQ.Byte
#define RDRQ_RDRQ0                      _RDRQ.Bits.RDRQ0
#define RDRQ_RDRQ1                      _RDRQ.Bits.RDRQ1
#define RDRQ_RDRQ2                      _RDRQ.Bits.RDRQ2
#define RDRQ_RDRQ3                      _RDRQ.Bits.RDRQ3
#define RDRQ_RDRQ4                      _RDRQ.Bits.RDRQ4
#define RDRQ_RDRQ5                      _RDRQ.Bits.RDRQ5
#define RDRQ_RDRQ6                      _RDRQ.Bits.RDRQ6
#define RDRQ_RDRQ7                      _RDRQ.Bits.RDRQ7

#define RDRQ_RDRQ0_MASK                 1U
#define RDRQ_RDRQ1_MASK                 2U
#define RDRQ_RDRQ2_MASK                 4U
#define RDRQ_RDRQ3_MASK                 8U
#define RDRQ_RDRQ4_MASK                 16U
#define RDRQ_RDRQ5_MASK                 32U
#define RDRQ_RDRQ6_MASK                 64U
#define RDRQ_RDRQ7_MASK                 128U


/*** PERQ - Port Q Pull Device Enable Register; 0x00000264 ***/
typedef union {
  byte Byte;
  struct {
    byte PERQ0       :1;                                       /* Pull Device Enable Port Q Bit 0 */
    byte PERQ1       :1;                                       /* Pull Device Enable Port Q Bit 1 */
    byte PERQ2       :1;                                       /* Pull Device Enable Port Q Bit 2 */
    byte PERQ3       :1;                                       /* Pull Device Enable Port Q Bit 3 */
    byte PERQ4       :1;                                       /* Pull Device Enable Port Q Bit 4 */
    byte PERQ5       :1;                                       /* Pull Device Enable Port Q Bit 5 */
    byte PERQ6       :1;                                       /* Pull Device Enable Port Q Bit 6 */
    byte PERQ7       :1;                                       /* Pull Device Enable Port Q Bit 7 */
  } Bits;
} PERQSTR;
extern volatile PERQSTR _PERQ @(REG_BASE + 0x00000264UL);
#define PERQ                            _PERQ.Byte
#define PERQ_PERQ0                      _PERQ.Bits.PERQ0
#define PERQ_PERQ1                      _PERQ.Bits.PERQ1
#define PERQ_PERQ2                      _PERQ.Bits.PERQ2
#define PERQ_PERQ3                      _PERQ.Bits.PERQ3
#define PERQ_PERQ4                      _PERQ.Bits.PERQ4
#define PERQ_PERQ5                      _PERQ.Bits.PERQ5
#define PERQ_PERQ6                      _PERQ.Bits.PERQ6
#define PERQ_PERQ7                      _PERQ.Bits.PERQ7

#define PERQ_PERQ0_MASK                 1U
#define PERQ_PERQ1_MASK                 2U
#define PERQ_PERQ2_MASK                 4U
#define PERQ_PERQ3_MASK                 8U
#define PERQ_PERQ4_MASK                 16U
#define PERQ_PERQ5_MASK                 32U
#define PERQ_PERQ6_MASK                 64U
#define PERQ_PERQ7_MASK                 128U


/*** PPSQ - Port Q Polarity Select Register; 0x00000265 ***/
typedef union {
  byte Byte;
  struct {
    byte PPSQ0       :1;                                       /* Pull Select Port Q Bit 0 */
    byte PPSQ1       :1;                                       /* Pull Select Port Q Bit 1 */
    byte PPSQ2       :1;                                       /* Pull Select Port Q Bit 2 */
    byte PPSQ3       :1;                                       /* Pull Select Port Q Bit 3 */
    byte PPSQ4       :1;                                       /* Pull Select Port Q Bit 4 */
    byte PPSQ5       :1;                                       /* Pull Select Port Q Bit 5 */
    byte PPSQ6       :1;                                       /* Pull Select Port Q Bit 6 */
    byte PPSQ7       :1;                                       /* Pull Select Port Q Bit 7 */
  } Bits;
} PPSQSTR;
extern volatile PPSQSTR _PPSQ @(REG_BASE + 0x00000265UL);
#define PPSQ                            _PPSQ.Byte
#define PPSQ_PPSQ0                      _PPSQ.Bits.PPSQ0
#define PPSQ_PPSQ1                      _PPSQ.Bits.PPSQ1
#define PPSQ_PPSQ2                      _PPSQ.Bits.PPSQ2
#define PPSQ_PPSQ3                      _PPSQ.Bits.PPSQ3
#define PPSQ_PPSQ4                      _PPSQ.Bits.PPSQ4
#define PPSQ_PPSQ5                      _PPSQ.Bits.PPSQ5
#define PPSQ_PPSQ6                      _PPSQ.Bits.PPSQ6
#define PPSQ_PPSQ7                      _PPSQ.Bits.PPSQ7

#define PPSQ_PPSQ0_MASK                 1U
#define PPSQ_PPSQ1_MASK                 2U
#define PPSQ_PPSQ2_MASK                 4U
#define PPSQ_PPSQ3_MASK                 8U
#define PPSQ_PPSQ4_MASK                 16U
#define PPSQ_PPSQ5_MASK                 32U
#define PPSQ_PPSQ6_MASK                 64U
#define PPSQ_PPSQ7_MASK                 128U


/*** PTR - Port R I/O Register; 0x00000268 ***/
typedef union {
  byte Byte;
  struct {
    byte PTR0        :1;                                       /* Port R Bit 0 */
    byte PTR1        :1;                                       /* Port R Bit 1 */
    byte PTR2        :1;                                       /* Port R Bit 2 */
    byte PTR3        :1;                                       /* Port R Bit 3 */
    byte PTR4        :1;                                       /* Port R Bit 4 */
    byte PTR5        :1;                                       /* Port R Bit 5 */
    byte PTR6        :1;                                       /* Port R Bit 6 */
    byte PTR7        :1;                                       /* Port R Bit 7 */
  } Bits;
} PTRSTR;
extern volatile PTRSTR _PTR @(REG_BASE + 0x00000268UL);
#define PTR                             _PTR.Byte
#define PTR_PTR0                        _PTR.Bits.PTR0
#define PTR_PTR1                        _PTR.Bits.PTR1
#define PTR_PTR2                        _PTR.Bits.PTR2
#define PTR_PTR3                        _PTR.Bits.PTR3
#define PTR_PTR4                        _PTR.Bits.PTR4
#define PTR_PTR5                        _PTR.Bits.PTR5
#define PTR_PTR6                        _PTR.Bits.PTR6
#define PTR_PTR7                        _PTR.Bits.PTR7

#define PTR_PTR0_MASK                   1U
#define PTR_PTR1_MASK                   2U
#define PTR_PTR2_MASK                   4U
#define PTR_PTR3_MASK                   8U
#define PTR_PTR4_MASK                   16U
#define PTR_PTR5_MASK                   32U
#define PTR_PTR6_MASK                   64U
#define PTR_PTR7_MASK                   128U


/*** PTIR - Port R Input Register; 0x00000269 ***/
typedef union {
  byte Byte;
  struct {
    byte PTIR0       :1;                                       /* Port R Bit 0 */
    byte PTIR1       :1;                                       /* Port R Bit 1 */
    byte PTIR2       :1;                                       /* Port R Bit 2 */
    byte PTIR3       :1;                                       /* Port R Bit 3 */
    byte PTIR4       :1;                                       /* Port R Bit 4 */
    byte PTIR5       :1;                                       /* Port R Bit 5 */
    byte PTIR6       :1;                                       /* Port R Bit 6 */
    byte PTIR7       :1;                                       /* Port R Bit 7 */
  } Bits;
} PTIRSTR;
extern volatile PTIRSTR _PTIR @(REG_BASE + 0x00000269UL);
#define PTIR                            _PTIR.Byte
#define PTIR_PTIR0                      _PTIR.Bits.PTIR0
#define PTIR_PTIR1                      _PTIR.Bits.PTIR1
#define PTIR_PTIR2                      _PTIR.Bits.PTIR2
#define PTIR_PTIR3                      _PTIR.Bits.PTIR3
#define PTIR_PTIR4                      _PTIR.Bits.PTIR4
#define PTIR_PTIR5                      _PTIR.Bits.PTIR5
#define PTIR_PTIR6                      _PTIR.Bits.PTIR6
#define PTIR_PTIR7                      _PTIR.Bits.PTIR7

#define PTIR_PTIR0_MASK                 1U
#define PTIR_PTIR1_MASK                 2U
#define PTIR_PTIR2_MASK                 4U
#define PTIR_PTIR3_MASK                 8U
#define PTIR_PTIR4_MASK                 16U
#define PTIR_PTIR5_MASK                 32U
#define PTIR_PTIR6_MASK                 64U
#define PTIR_PTIR7_MASK                 128U


/*** DDRR - Port R Data Direction Register; 0x0000026A ***/
typedef union {
  byte Byte;
  struct {
    byte DDRR0       :1;                                       /* Data Direction Port R Bit 0 */
    byte DDRR1       :1;                                       /* Data Direction Port R Bit 1 */
    byte DDRR2       :1;                                       /* Data Direction Port R Bit 2 */
    byte DDRR3       :1;                                       /* Data Direction Port R Bit 3 */
    byte DDRR4       :1;                                       /* Data Direction Port R Bit 4 */
    byte DDRR5       :1;                                       /* Data Direction Port R Bit 5 */
    byte DDRR6       :1;                                       /* Data Direction Port R Bit 6 */
    byte DDRR7       :1;                                       /* Data Direction Port R Bit 7 */
  } Bits;
} DDRRSTR;
extern volatile DDRRSTR _DDRR @(REG_BASE + 0x0000026AUL);
#define DDRR                            _DDRR.Byte
#define DDRR_DDRR0                      _DDRR.Bits.DDRR0
#define DDRR_DDRR1                      _DDRR.Bits.DDRR1
#define DDRR_DDRR2                      _DDRR.Bits.DDRR2
#define DDRR_DDRR3                      _DDRR.Bits.DDRR3
#define DDRR_DDRR4                      _DDRR.Bits.DDRR4
#define DDRR_DDRR5                      _DDRR.Bits.DDRR5
#define DDRR_DDRR6                      _DDRR.Bits.DDRR6
#define DDRR_DDRR7                      _DDRR.Bits.DDRR7

#define DDRR_DDRR0_MASK                 1U
#define DDRR_DDRR1_MASK                 2U
#define DDRR_DDRR2_MASK                 4U
#define DDRR_DDRR3_MASK                 8U
#define DDRR_DDRR4_MASK                 16U
#define DDRR_DDRR5_MASK                 32U
#define DDRR_DDRR6_MASK                 64U
#define DDRR_DDRR7_MASK                 128U


/*** RDRR - Port R Reduced Drive Register; 0x0000026B ***/
typedef union {
  byte Byte;
  struct {
    byte RDRR0       :1;                                       /* Reduced Drive Port R Bit 0 */
    byte RDRR1       :1;                                       /* Reduced Drive Port R Bit 1 */
    byte RDRR2       :1;                                       /* Reduced Drive Port R Bit 2 */
    byte RDRR3       :1;                                       /* Reduced Drive Port R Bit 3 */
    byte RDRR4       :1;                                       /* Reduced Drive Port R Bit 4 */
    byte RDRR5       :1;                                       /* Reduced Drive Port R Bit 5 */
    byte RDRR6       :1;                                       /* Reduced Drive Port R Bit 6 */
    byte RDRR7       :1;                                       /* Reduced Drive Port R Bit 7 */
  } Bits;
} RDRRSTR;
extern volatile RDRRSTR _RDRR @(REG_BASE + 0x0000026BUL);
#define RDRR                            _RDRR.Byte
#define RDRR_RDRR0                      _RDRR.Bits.RDRR0
#define RDRR_RDRR1                      _RDRR.Bits.RDRR1
#define RDRR_RDRR2                      _RDRR.Bits.RDRR2
#define RDRR_RDRR3                      _RDRR.Bits.RDRR3
#define RDRR_RDRR4                      _RDRR.Bits.RDRR4
#define RDRR_RDRR5                      _RDRR.Bits.RDRR5
#define RDRR_RDRR6                      _RDRR.Bits.RDRR6
#define RDRR_RDRR7                      _RDRR.Bits.RDRR7

#define RDRR_RDRR0_MASK                 1U
#define RDRR_RDRR1_MASK                 2U
#define RDRR_RDRR2_MASK                 4U
#define RDRR_RDRR3_MASK                 8U
#define RDRR_RDRR4_MASK                 16U
#define RDRR_RDRR5_MASK                 32U
#define RDRR_RDRR6_MASK                 64U
#define RDRR_RDRR7_MASK                 128U


/*** PERR - Port R Pull Device Enable Register; 0x0000026C ***/
typedef union {
  byte Byte;
  struct {
    byte PERR0       :1;                                       /* Pull Device Enable Port R Bit 0 */
    byte PERR1       :1;                                       /* Pull Device Enable Port R Bit 1 */
    byte PERR2       :1;                                       /* Pull Device Enable Port R Bit 2 */
    byte PERR3       :1;                                       /* Pull Device Enable Port R Bit 3 */
    byte PERR4       :1;                                       /* Pull Device Enable Port R Bit 4 */
    byte PERR5       :1;                                       /* Pull Device Enable Port R Bit 5 */
    byte PERR6       :1;                                       /* Pull Device Enable Port R Bit 6 */
    byte PERR7       :1;                                       /* Pull Device Enable Port R Bit 7 */
  } Bits;
} PERRSTR;
extern volatile PERRSTR _PERR @(REG_BASE + 0x0000026CUL);
#define PERR                            _PERR.Byte
#define PERR_PERR0                      _PERR.Bits.PERR0
#define PERR_PERR1                      _PERR.Bits.PERR1
#define PERR_PERR2                      _PERR.Bits.PERR2
#define PERR_PERR3                      _PERR.Bits.PERR3
#define PERR_PERR4                      _PERR.Bits.PERR4
#define PERR_PERR5                      _PERR.Bits.PERR5
#define PERR_PERR6                      _PERR.Bits.PERR6
#define PERR_PERR7                      _PERR.Bits.PERR7

#define PERR_PERR0_MASK                 1U
#define PERR_PERR1_MASK                 2U
#define PERR_PERR2_MASK                 4U
#define PERR_PERR3_MASK                 8U
#define PERR_PERR4_MASK                 16U
#define PERR_PERR5_MASK                 32U
#define PERR_PERR6_MASK                 64U
#define PERR_PERR7_MASK                 128U


/*** PPSR - Port R Polarity Select Register; 0x0000026D ***/
typedef union {
  byte Byte;
  struct {
    byte PPSR0       :1;                                       /* Pull Select Port R Bit 0 */
    byte PPSR1       :1;                                       /* Pull Select Port R Bit 1 */
    byte PPSR2       :1;                                       /* Pull Select Port R Bit 2 */
    byte PPSR3       :1;                                       /* Pull Select Port R Bit 3 */
    byte PPSR4       :1;                                       /* Pull Select Port R Bit 4 */
    byte PPSR5       :1;                                       /* Pull Select Port R Bit 5 */
    byte PPSR6       :1;                                       /* Pull Select Port R Bit 6 */
    byte PPSR7       :1;                                       /* Pull Select Port R Bit 7 */
  } Bits;
} PPSRSTR;
extern volatile PPSRSTR _PPSR @(REG_BASE + 0x0000026DUL);
#define PPSR                            _PPSR.Byte
#define PPSR_PPSR0                      _PPSR.Bits.PPSR0
#define PPSR_PPSR1                      _PPSR.Bits.PPSR1
#define PPSR_PPSR2                      _PPSR.Bits.PPSR2
#define PPSR_PPSR3                      _PPSR.Bits.PPSR3
#define PPSR_PPSR4                      _PPSR.Bits.PPSR4
#define PPSR_PPSR5                      _PPSR.Bits.PPSR5
#define PPSR_PPSR6                      _PPSR.Bits.PPSR6
#define PPSR_PPSR7                      _PPSR.Bits.PPSR7

#define PPSR_PPSR0_MASK                 1U
#define PPSR_PPSR1_MASK                 2U
#define PPSR_PPSR2_MASK                 4U
#define PPSR_PPSR3_MASK                 8U
#define PPSR_PPSR4_MASK                 16U
#define PPSR_PPSR5_MASK                 32U
#define PPSR_PPSR6_MASK                 64U
#define PPSR_PPSR7_MASK                 128U


/*** PTS - Port S I/O Register; 0x00000270 ***/
typedef union {
  byte Byte;
  struct {
    byte PTS0        :1;                                       /* Port S Bit 0 */
    byte PTS1        :1;                                       /* Port S Bit 1 */
    byte PTS2        :1;                                       /* Port S Bit 2 */
    byte PTS3        :1;                                       /* Port S Bit 3 */
    byte PTS4        :1;                                       /* Port S Bit 4 */
    byte PTS5        :1;                                       /* Port S Bit 5 */
    byte PTS6        :1;                                       /* Port S Bit 6 */
    byte PTS7        :1;                                       /* Port S Bit 7 */
  } Bits;
} PTSSTR;
extern volatile PTSSTR _PTS @(REG_BASE + 0x00000270UL);
#define PTS                             _PTS.Byte
#define PTS_PTS0                        _PTS.Bits.PTS0
#define PTS_PTS1                        _PTS.Bits.PTS1
#define PTS_PTS2                        _PTS.Bits.PTS2
#define PTS_PTS3                        _PTS.Bits.PTS3
#define PTS_PTS4                        _PTS.Bits.PTS4
#define PTS_PTS5                        _PTS.Bits.PTS5
#define PTS_PTS6                        _PTS.Bits.PTS6
#define PTS_PTS7                        _PTS.Bits.PTS7

#define PTS_PTS0_MASK                   1U
#define PTS_PTS1_MASK                   2U
#define PTS_PTS2_MASK                   4U
#define PTS_PTS3_MASK                   8U
#define PTS_PTS4_MASK                   16U
#define PTS_PTS5_MASK                   32U
#define PTS_PTS6_MASK                   64U
#define PTS_PTS7_MASK                   128U


/*** PTIS - Port S Input Register; 0x00000271 ***/
typedef union {
  byte Byte;
  struct {
    byte PTIS0       :1;                                       /* Port S Bit 0 */
    byte PTIS1       :1;                                       /* Port S Bit 1 */
    byte PTIS2       :1;                                       /* Port S Bit 2 */
    byte PTIS3       :1;                                       /* Port S Bit 3 */
    byte PTIS4       :1;                                       /* Port S Bit 4 */
    byte PTIS5       :1;                                       /* Port S Bit 5 */
    byte PTIS6       :1;                                       /* Port S Bit 6 */
    byte PTIS7       :1;                                       /* Port S Bit 7 */
  } Bits;
} PTISSTR;
extern volatile PTISSTR _PTIS @(REG_BASE + 0x00000271UL);
#define PTIS                            _PTIS.Byte
#define PTIS_PTIS0                      _PTIS.Bits.PTIS0
#define PTIS_PTIS1                      _PTIS.Bits.PTIS1
#define PTIS_PTIS2                      _PTIS.Bits.PTIS2
#define PTIS_PTIS3                      _PTIS.Bits.PTIS3
#define PTIS_PTIS4                      _PTIS.Bits.PTIS4
#define PTIS_PTIS5                      _PTIS.Bits.PTIS5
#define PTIS_PTIS6                      _PTIS.Bits.PTIS6
#define PTIS_PTIS7                      _PTIS.Bits.PTIS7

#define PTIS_PTIS0_MASK                 1U
#define PTIS_PTIS1_MASK                 2U
#define PTIS_PTIS2_MASK                 4U
#define PTIS_PTIS3_MASK                 8U
#define PTIS_PTIS4_MASK                 16U
#define PTIS_PTIS5_MASK                 32U
#define PTIS_PTIS6_MASK                 64U
#define PTIS_PTIS7_MASK                 128U


/*** DDRS - Port S Data Direction Register; 0x00000272 ***/
typedef union {
  byte Byte;
  struct {
    byte DDRS0       :1;                                       /* Data Direction Port S Bit 0 */
    byte DDRS1       :1;                                       /* Data Direction Port S Bit 1 */
    byte DDRS2       :1;                                       /* Data Direction Port S Bit 2 */
    byte DDRS3       :1;                                       /* Data Direction Port S Bit 3 */
    byte DDRS4       :1;                                       /* Data Direction Port S Bit 4 */
    byte DDRS5       :1;                                       /* Data Direction Port S Bit 5 */
    byte DDRS6       :1;                                       /* Data Direction Port S Bit 6 */
    byte DDRS7       :1;                                       /* Data Direction Port S Bit 7 */
  } Bits;
} DDRSSTR;
extern volatile DDRSSTR _DDRS @(REG_BASE + 0x00000272UL);
#define DDRS                            _DDRS.Byte
#define DDRS_DDRS0                      _DDRS.Bits.DDRS0
#define DDRS_DDRS1                      _DDRS.Bits.DDRS1
#define DDRS_DDRS2                      _DDRS.Bits.DDRS2
#define DDRS_DDRS3                      _DDRS.Bits.DDRS3
#define DDRS_DDRS4                      _DDRS.Bits.DDRS4
#define DDRS_DDRS5                      _DDRS.Bits.DDRS5
#define DDRS_DDRS6                      _DDRS.Bits.DDRS6
#define DDRS_DDRS7                      _DDRS.Bits.DDRS7

#define DDRS_DDRS0_MASK                 1U
#define DDRS_DDRS1_MASK                 2U
#define DDRS_DDRS2_MASK                 4U
#define DDRS_DDRS3_MASK                 8U
#define DDRS_DDRS4_MASK                 16U
#define DDRS_DDRS5_MASK                 32U
#define DDRS_DDRS6_MASK                 64U
#define DDRS_DDRS7_MASK                 128U


/*** RDRS - Port S Reduced Drive Register; 0x00000273 ***/
typedef union {
  byte Byte;
  struct {
    byte RDRS0       :1;                                       /* Reduced Drive Port S Bit 0 */
    byte RDRS1       :1;                                       /* Reduced Drive Port S Bit 1 */
    byte RDRS2       :1;                                       /* Reduced Drive Port S Bit 2 */
    byte RDRS3       :1;                                       /* Reduced Drive Port S Bit 3 */
    byte RDRS4       :1;                                       /* Reduced Drive Port S Bit 4 */
    byte RDRS5       :1;                                       /* Reduced Drive Port S Bit 5 */
    byte RDRS6       :1;                                       /* Reduced Drive Port S Bit 6 */
    byte RDRS7       :1;                                       /* Reduced Drive Port S Bit 7 */
  } Bits;
} RDRSSTR;
extern volatile RDRSSTR _RDRS @(REG_BASE + 0x00000273UL);
#define RDRS                            _RDRS.Byte
#define RDRS_RDRS0                      _RDRS.Bits.RDRS0
#define RDRS_RDRS1                      _RDRS.Bits.RDRS1
#define RDRS_RDRS2                      _RDRS.Bits.RDRS2
#define RDRS_RDRS3                      _RDRS.Bits.RDRS3
#define RDRS_RDRS4                      _RDRS.Bits.RDRS4
#define RDRS_RDRS5                      _RDRS.Bits.RDRS5
#define RDRS_RDRS6                      _RDRS.Bits.RDRS6
#define RDRS_RDRS7                      _RDRS.Bits.RDRS7

#define RDRS_RDRS0_MASK                 1U
#define RDRS_RDRS1_MASK                 2U
#define RDRS_RDRS2_MASK                 4U
#define RDRS_RDRS3_MASK                 8U
#define RDRS_RDRS4_MASK                 16U
#define RDRS_RDRS5_MASK                 32U
#define RDRS_RDRS6_MASK                 64U
#define RDRS_RDRS7_MASK                 128U


/*** PERS - Port S Pull Device Enable Register; 0x00000274 ***/
typedef union {
  byte Byte;
  struct {
    byte PERS0       :1;                                       /* Pull Device Enable Port S Bit 0 */
    byte PERS1       :1;                                       /* Pull Device Enable Port S Bit 1 */
    byte PERS2       :1;                                       /* Pull Device Enable Port S Bit 2 */
    byte PERS3       :1;                                       /* Pull Device Enable Port S Bit 3 */
    byte PERS4       :1;                                       /* Pull Device Enable Port S Bit 4 */
    byte PERS5       :1;                                       /* Pull Device Enable Port S Bit 5 */
    byte PERS6       :1;                                       /* Pull Device Enable Port S Bit 6 */
    byte PERS7       :1;                                       /* Pull Device Enable Port S Bit 7 */
  } Bits;
} PERSSTR;
extern volatile PERSSTR _PERS @(REG_BASE + 0x00000274UL);
#define PERS                            _PERS.Byte
#define PERS_PERS0                      _PERS.Bits.PERS0
#define PERS_PERS1                      _PERS.Bits.PERS1
#define PERS_PERS2                      _PERS.Bits.PERS2
#define PERS_PERS3                      _PERS.Bits.PERS3
#define PERS_PERS4                      _PERS.Bits.PERS4
#define PERS_PERS5                      _PERS.Bits.PERS5
#define PERS_PERS6                      _PERS.Bits.PERS6
#define PERS_PERS7                      _PERS.Bits.PERS7

#define PERS_PERS0_MASK                 1U
#define PERS_PERS1_MASK                 2U
#define PERS_PERS2_MASK                 4U
#define PERS_PERS3_MASK                 8U
#define PERS_PERS4_MASK                 16U
#define PERS_PERS5_MASK                 32U
#define PERS_PERS6_MASK                 64U
#define PERS_PERS7_MASK                 128U


/*** PPSS - Port S Polarity Select Register; 0x00000275 ***/
typedef union {
  byte Byte;
  struct {
    byte PPSS0       :1;                                       /* Pull Select Port S Bit 0 */
    byte PPSS1       :1;                                       /* Pull Select Port S Bit 1 */
    byte PPSS2       :1;                                       /* Pull Select Port S Bit 2 */
    byte PPSS3       :1;                                       /* Pull Select Port S Bit 3 */
    byte PPSS4       :1;                                       /* Pull Select Port S Bit 4 */
    byte PPSS5       :1;                                       /* Pull Select Port S Bit 5 */
    byte PPSS6       :1;                                       /* Pull Select Port S Bit 6 */
    byte PPSS7       :1;                                       /* Pull Select Port S Bit 7 */
  } Bits;
} PPSSSTR;
extern volatile PPSSSTR _PPSS @(REG_BASE + 0x00000275UL);
#define PPSS                            _PPSS.Byte
#define PPSS_PPSS0                      _PPSS.Bits.PPSS0
#define PPSS_PPSS1                      _PPSS.Bits.PPSS1
#define PPSS_PPSS2                      _PPSS.Bits.PPSS2
#define PPSS_PPSS3                      _PPSS.Bits.PPSS3
#define PPSS_PPSS4                      _PPSS.Bits.PPSS4
#define PPSS_PPSS5                      _PPSS.Bits.PPSS5
#define PPSS_PPSS6                      _PPSS.Bits.PPSS6
#define PPSS_PPSS7                      _PPSS.Bits.PPSS7

#define PPSS_PPSS0_MASK                 1U
#define PPSS_PPSS1_MASK                 2U
#define PPSS_PPSS2_MASK                 4U
#define PPSS_PPSS3_MASK                 8U
#define PPSS_PPSS4_MASK                 16U
#define PPSS_PPSS5_MASK                 32U
#define PPSS_PPSS6_MASK                 64U
#define PPSS_PPSS7_MASK                 128U


/*** PTU - Port U I/O Register; 0x00000278 ***/
typedef union {
  byte Byte;
  struct {
    byte PTU0        :1;                                       /* Port U Bit 0 */
    byte PTU1        :1;                                       /* Port U Bit 1 */
    byte PTU2        :1;                                       /* Port U Bit 2 */
    byte PTU3        :1;                                       /* Port U Bit 3 */
    byte PTU4        :1;                                       /* Port U Bit 4 */
    byte PTU5        :1;                                       /* Port U Bit 5 */
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpPTU  :6;
    byte         :1;
    byte         :1;
  } MergedBits;
} PTUSTR;
extern volatile PTUSTR _PTU @(REG_BASE + 0x00000278UL);
#define PTU                             _PTU.Byte
#define PTU_PTU0                        _PTU.Bits.PTU0
#define PTU_PTU1                        _PTU.Bits.PTU1
#define PTU_PTU2                        _PTU.Bits.PTU2
#define PTU_PTU3                        _PTU.Bits.PTU3
#define PTU_PTU4                        _PTU.Bits.PTU4
#define PTU_PTU5                        _PTU.Bits.PTU5
#define PTU_PTU                         _PTU.MergedBits.grpPTU

#define PTU_PTU0_MASK                   1U
#define PTU_PTU1_MASK                   2U
#define PTU_PTU2_MASK                   4U
#define PTU_PTU3_MASK                   8U
#define PTU_PTU4_MASK                   16U
#define PTU_PTU5_MASK                   32U
#define PTU_PTU_MASK                    63U
#define PTU_PTU_BITNUM                  0U


/*** PTIU - Port U Input Register; 0x00000279 ***/
typedef union {
  byte Byte;
  struct {
    byte PTIU0       :1;                                       /* Port U Bit 0 */
    byte PTIU1       :1;                                       /* Port U Bit 1 */
    byte PTIU2       :1;                                       /* Port U Bit 2 */
    byte PTIU3       :1;                                       /* Port U Bit 3 */
    byte PTIU4       :1;                                       /* Port U Bit 4 */
    byte PTIU5       :1;                                       /* Port U Bit 5 */
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpPTIU :6;
    byte         :1;
    byte         :1;
  } MergedBits;
} PTIUSTR;
extern volatile PTIUSTR _PTIU @(REG_BASE + 0x00000279UL);
#define PTIU                            _PTIU.Byte
#define PTIU_PTIU0                      _PTIU.Bits.PTIU0
#define PTIU_PTIU1                      _PTIU.Bits.PTIU1
#define PTIU_PTIU2                      _PTIU.Bits.PTIU2
#define PTIU_PTIU3                      _PTIU.Bits.PTIU3
#define PTIU_PTIU4                      _PTIU.Bits.PTIU4
#define PTIU_PTIU5                      _PTIU.Bits.PTIU5
#define PTIU_PTIU                       _PTIU.MergedBits.grpPTIU

#define PTIU_PTIU0_MASK                 1U
#define PTIU_PTIU1_MASK                 2U
#define PTIU_PTIU2_MASK                 4U
#define PTIU_PTIU3_MASK                 8U
#define PTIU_PTIU4_MASK                 16U
#define PTIU_PTIU5_MASK                 32U
#define PTIU_PTIU_MASK                  63U
#define PTIU_PTIU_BITNUM                0U


/*** DDRU - Port U Data Direction Register; 0x0000027A ***/
typedef union {
  byte Byte;
  struct {
    byte DDRU0       :1;                                       /* Data Direction Port U Bit 0 */
    byte DDRU1       :1;                                       /* Data Direction Port U Bit 1 */
    byte DDRU2       :1;                                       /* Data Direction Port U Bit 2 */
    byte DDRU3       :1;                                       /* Data Direction Port U Bit 3 */
    byte DDRU4       :1;                                       /* Data Direction Port U Bit 4 */
    byte DDRU5       :1;                                       /* Data Direction Port U Bit 5 */
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpDDRU :6;
    byte         :1;
    byte         :1;
  } MergedBits;
} DDRUSTR;
extern volatile DDRUSTR _DDRU @(REG_BASE + 0x0000027AUL);
#define DDRU                            _DDRU.Byte
#define DDRU_DDRU0                      _DDRU.Bits.DDRU0
#define DDRU_DDRU1                      _DDRU.Bits.DDRU1
#define DDRU_DDRU2                      _DDRU.Bits.DDRU2
#define DDRU_DDRU3                      _DDRU.Bits.DDRU3
#define DDRU_DDRU4                      _DDRU.Bits.DDRU4
#define DDRU_DDRU5                      _DDRU.Bits.DDRU5
#define DDRU_DDRU                       _DDRU.MergedBits.grpDDRU

#define DDRU_DDRU0_MASK                 1U
#define DDRU_DDRU1_MASK                 2U
#define DDRU_DDRU2_MASK                 4U
#define DDRU_DDRU3_MASK                 8U
#define DDRU_DDRU4_MASK                 16U
#define DDRU_DDRU5_MASK                 32U
#define DDRU_DDRU_MASK                  63U
#define DDRU_DDRU_BITNUM                0U


/*** RDRU - Port U Reduced Drive Register; 0x0000027B ***/
typedef union {
  byte Byte;
  struct {
    byte RDRU0       :1;                                       /* Reduced Drive Port U Bit 0 */
    byte RDRU1       :1;                                       /* Reduced Drive Port U Bit 1 */
    byte RDRU2       :1;                                       /* Reduced Drive Port U Bit 2 */
    byte RDRU3       :1;                                       /* Reduced Drive Port U Bit 3 */
    byte RDRU4       :1;                                       /* Reduced Drive Port U Bit 4 */
    byte RDRU5       :1;                                       /* Reduced Drive Port U Bit 5 */
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpRDRU :6;
    byte         :1;
    byte         :1;
  } MergedBits;
} RDRUSTR;
extern volatile RDRUSTR _RDRU @(REG_BASE + 0x0000027BUL);
#define RDRU                            _RDRU.Byte
#define RDRU_RDRU0                      _RDRU.Bits.RDRU0
#define RDRU_RDRU1                      _RDRU.Bits.RDRU1
#define RDRU_RDRU2                      _RDRU.Bits.RDRU2
#define RDRU_RDRU3                      _RDRU.Bits.RDRU3
#define RDRU_RDRU4                      _RDRU.Bits.RDRU4
#define RDRU_RDRU5                      _RDRU.Bits.RDRU5
#define RDRU_RDRU                       _RDRU.MergedBits.grpRDRU

#define RDRU_RDRU0_MASK                 1U
#define RDRU_RDRU1_MASK                 2U
#define RDRU_RDRU2_MASK                 4U
#define RDRU_RDRU3_MASK                 8U
#define RDRU_RDRU4_MASK                 16U
#define RDRU_RDRU5_MASK                 32U
#define RDRU_RDRU_MASK                  63U
#define RDRU_RDRU_BITNUM                0U


/*** PERU - Port U Pull Device Enable Register; 0x0000027C ***/
typedef union {
  byte Byte;
  struct {
    byte PERU0       :1;                                       /* Pull Device Enable Port U Bit 0 */
    byte PERU1       :1;                                       /* Pull Device Enable Port U Bit 1 */
    byte PERU2       :1;                                       /* Pull Device Enable Port U Bit 2 */
    byte PERU3       :1;                                       /* Pull Device Enable Port U Bit 3 */
    byte PERU4       :1;                                       /* Pull Device Enable Port U Bit 4 */
    byte PERU5       :1;                                       /* Pull Device Enable Port U Bit 5 */
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpPERU :6;
    byte         :1;
    byte         :1;
  } MergedBits;
} PERUSTR;
extern volatile PERUSTR _PERU @(REG_BASE + 0x0000027CUL);
#define PERU                            _PERU.Byte
#define PERU_PERU0                      _PERU.Bits.PERU0
#define PERU_PERU1                      _PERU.Bits.PERU1
#define PERU_PERU2                      _PERU.Bits.PERU2
#define PERU_PERU3                      _PERU.Bits.PERU3
#define PERU_PERU4                      _PERU.Bits.PERU4
#define PERU_PERU5                      _PERU.Bits.PERU5
#define PERU_PERU                       _PERU.MergedBits.grpPERU

#define PERU_PERU0_MASK                 1U
#define PERU_PERU1_MASK                 2U
#define PERU_PERU2_MASK                 4U
#define PERU_PERU3_MASK                 8U
#define PERU_PERU4_MASK                 16U
#define PERU_PERU5_MASK                 32U
#define PERU_PERU_MASK                  63U
#define PERU_PERU_BITNUM                0U


/*** PPSU - Port U Polarity Select Register; 0x0000027D ***/
typedef union {
  byte Byte;
  struct {
    byte PPSU0       :1;                                       /* Pull Select Port U Bit 0 */
    byte PPSU1       :1;                                       /* Pull Select Port U Bit 1 */
    byte PPSU2       :1;                                       /* Pull Select Port U Bit 2 */
    byte PPSU3       :1;                                       /* Pull Select Port U Bit 3 */
    byte PPSU4       :1;                                       /* Pull Select Port U Bit 4 */
    byte PPSU5       :1;                                       /* Pull Select Port U Bit 5 */
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpPPSU :6;
    byte         :1;
    byte         :1;
  } MergedBits;
} PPSUSTR;
extern volatile PPSUSTR _PPSU @(REG_BASE + 0x0000027DUL);
#define PPSU                            _PPSU.Byte
#define PPSU_PPSU0                      _PPSU.Bits.PPSU0
#define PPSU_PPSU1                      _PPSU.Bits.PPSU1
#define PPSU_PPSU2                      _PPSU.Bits.PPSU2
#define PPSU_PPSU3                      _PPSU.Bits.PPSU3
#define PPSU_PPSU4                      _PPSU.Bits.PPSU4
#define PPSU_PPSU5                      _PPSU.Bits.PPSU5
#define PPSU_PPSU                       _PPSU.MergedBits.grpPPSU

#define PPSU_PPSU0_MASK                 1U
#define PPSU_PPSU1_MASK                 2U
#define PPSU_PPSU2_MASK                 4U
#define PPSU_PPSU3_MASK                 8U
#define PPSU_PPSU4_MASK                 16U
#define PPSU_PPSU5_MASK                 32U
#define PPSU_PPSU_MASK                  63U
#define PPSU_PPSU_BITNUM                0U


/*** CFISR - CF Interface Status Register; 0x00000280 ***/
typedef union {
  word Word;
  struct {
    word CHG         :1;                                       /* State Change */
    word SPKRB       :1;                                       /* Binary Audio Output */
    word CD1         :1;                                       /* Card Detect 1 */
    word CD2         :1;                                       /* Card Detect 2 */
    word IOIS16      :1;                                       /* 16 bit I/O Port Select */
    word RDY         :1;                                       /* Card Ready */
    word VS          :1;                                       /* Voltage Sense */
    word INPACK      :1;                                       /* Input Acknowledge */
    word CWAIT       :1;                                       /* Bus Cycle Wait */
    word VCC         :1;                                       /* Card Power Supply */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
  struct {
    word         :1;
    word         :1;
    word grpCD_1 :2;
    word grpIOIS_16 :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} CFISRSTR;
extern volatile CFISRSTR _CFISR @(REG_BASE + 0x00000280UL);
#define CFISR                           _CFISR.Word
#define CFISR_CHG                       _CFISR.Bits.CHG
#define CFISR_SPKRB                     _CFISR.Bits.SPKRB
#define CFISR_CD1                       _CFISR.Bits.CD1
#define CFISR_CD2                       _CFISR.Bits.CD2
#define CFISR_IOIS16                    _CFISR.Bits.IOIS16
#define CFISR_RDY                       _CFISR.Bits.RDY
#define CFISR_VS                        _CFISR.Bits.VS
#define CFISR_INPACK                    _CFISR.Bits.INPACK
#define CFISR_CWAIT                     _CFISR.Bits.CWAIT
#define CFISR_VCC                       _CFISR.Bits.VCC
#define CFISR_CD_1                      _CFISR.MergedBits.grpCD_1
#define CFISR_CD                        CFISR_CD_1

#define CFISR_CHG_MASK                  1U
#define CFISR_SPKRB_MASK                2U
#define CFISR_CD1_MASK                  4U
#define CFISR_CD2_MASK                  8U
#define CFISR_IOIS16_MASK               16U
#define CFISR_RDY_MASK                  32U
#define CFISR_VS_MASK                   64U
#define CFISR_INPACK_MASK               128U
#define CFISR_CWAIT_MASK                256U
#define CFISR_VCC_MASK                  512U
#define CFISR_CD_1_MASK                 12U
#define CFISR_CD_1_BITNUM               2U


/*** CFCCR - CF Card Configuration Register; 0x00000282 ***/
typedef union {
  word Word;
  struct {
    word COM         :1;                                       /* Card Operation Mode */
    word REGB        :1;                                       /* Attribute Memory Select */
    word CE1B        :1;                                       /* Card Enable 1 */
    word CE2B        :1;                                       /* Card Enable 2 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} CFCCRSTR;
extern volatile CFCCRSTR _CFCCR @(REG_BASE + 0x00000282UL);
#define CFCCR                           _CFCCR.Word
#define CFCCR_COM                       _CFCCR.Bits.COM
#define CFCCR_REGB                      _CFCCR.Bits.REGB
#define CFCCR_CE1B                      _CFCCR.Bits.CE1B
#define CFCCR_CE2B                      _CFCCR.Bits.CE2B

#define CFCCR_COM_MASK                  1U
#define CFCCR_REGB_MASK                 2U
#define CFCCR_CE1B_MASK                 4U
#define CFCCR_CE2B_MASK                 8U


/*** CFSCR1 - CF Status and Control Register 1; 0x00000284 ***/
typedef union {
  word Word;
  struct {
    word CDIE        :1;                                       /* Card Detect Interrupt Enable */
    word CHGIE       :1;                                       /* Card State Change Interrupt Enable */
    word RDYIE       :1;                                       /* Card RDY/BSY Interrupt Enable */
    word VSIE        :1;                                       /* Voltage Sense Interrupt Enable */
    word CIE         :1;                                       /* Card Interrupt Enable */
    word OOIE        :1;                                       /* OOIE  Operation Over Interrupt Enable */
    word CFTEIE      :1;                                       /* CF Transmit Interrupt Enable */
    word CFRFIE      :1;                                       /* CF Receive Interrupt Enable */
    word TERRIE      :1;                                       /* Time-out Error Interrupt Enable */
    word WERRIE      :1;                                       /* Wait Assertion Error Interrupt Enable */
    word IEDGE       :1;                                       /* Interrupt Edge Select */
    word CFSWAI      :1;                                       /* CF Module Stop in Wait Mode */
    word DISINC      :1;                                       /* Disable increase of CF Block Base Address Register (CFBBAR) */
    word CRST        :1;                                       /* Card Reset */
    word CFOE        :1;                                       /* CF Output Enable */
    word CFE         :1;                                       /* CFHC system Enable */
  } Bits;
} CFSCR1STR;
extern volatile CFSCR1STR _CFSCR1 @(REG_BASE + 0x00000284UL);
#define CFSCR1                          _CFSCR1.Word
#define CFSCR1_CDIE                     _CFSCR1.Bits.CDIE
#define CFSCR1_CHGIE                    _CFSCR1.Bits.CHGIE
#define CFSCR1_RDYIE                    _CFSCR1.Bits.RDYIE
#define CFSCR1_VSIE                     _CFSCR1.Bits.VSIE
#define CFSCR1_CIE                      _CFSCR1.Bits.CIE
#define CFSCR1_OOIE                     _CFSCR1.Bits.OOIE
#define CFSCR1_CFTEIE                   _CFSCR1.Bits.CFTEIE
#define CFSCR1_CFRFIE                   _CFSCR1.Bits.CFRFIE
#define CFSCR1_TERRIE                   _CFSCR1.Bits.TERRIE
#define CFSCR1_WERRIE                   _CFSCR1.Bits.WERRIE
#define CFSCR1_IEDGE                    _CFSCR1.Bits.IEDGE
#define CFSCR1_CFSWAI                   _CFSCR1.Bits.CFSWAI
#define CFSCR1_DISINC                   _CFSCR1.Bits.DISINC
#define CFSCR1_CRST                     _CFSCR1.Bits.CRST
#define CFSCR1_CFOE                     _CFSCR1.Bits.CFOE
#define CFSCR1_CFE                      _CFSCR1.Bits.CFE

#define CFSCR1_CDIE_MASK                1U
#define CFSCR1_CHGIE_MASK               2U
#define CFSCR1_RDYIE_MASK               4U
#define CFSCR1_VSIE_MASK                8U
#define CFSCR1_CIE_MASK                 16U
#define CFSCR1_OOIE_MASK                32U
#define CFSCR1_CFTEIE_MASK              64U
#define CFSCR1_CFRFIE_MASK              128U
#define CFSCR1_TERRIE_MASK              256U
#define CFSCR1_WERRIE_MASK              512U
#define CFSCR1_IEDGE_MASK               1024U
#define CFSCR1_CFSWAI_MASK              2048U
#define CFSCR1_DISINC_MASK              4096U
#define CFSCR1_CRST_MASK                8192U
#define CFSCR1_CFOE_MASK                16384U
#define CFSCR1_CFE_MASK                 32768U


/*** CFSCR2 - CF Status and Control Register 2; 0x00000286 ***/
typedef union {
  word Word;
  struct {
    word TPS0        :1;                                       /* Time-out Period Selection Bit 0 */
    word TPS1        :1;                                       /* Time-out Period Selection Bit 1 */
    word TPS2        :1;                                       /* Time-out Period Selection Bit 2 */
    word TPS3        :1;                                       /* Time-out Period Selection Bit 3 */
    word TPS4        :1;                                       /* Time-out Period Selection Bit 4 */
    word TPS5        :1;                                       /* Time-out Period Selection Bit 5 */
    word             :1; 
    word             :1; 
    word             :1; 
    word CA4E        :1;                                       /* Card Address Bit 4 Port Enable */
    word CA5E        :1;                                       /* Card Address Bit 5 Port Enable */
    word CA6E        :1;                                       /* Card Address Bit 6 Port Enable */
    word CA7E        :1;                                       /* Card Address Bit 7 Port Enable */
    word CA8E        :1;                                       /* Card Address Bit 8 Port Enable */
    word CA9E        :1;                                       /* Card Address Bit 9 Port Enable */
    word CA10E       :1;                                       /* Card Address Bit 10 Port Enable */
  } Bits;
  struct {
    word grpTPS  :6;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} CFSCR2STR;
extern volatile CFSCR2STR _CFSCR2 @(REG_BASE + 0x00000286UL);
#define CFSCR2                          _CFSCR2.Word
#define CFSCR2_TPS0                     _CFSCR2.Bits.TPS0
#define CFSCR2_TPS1                     _CFSCR2.Bits.TPS1
#define CFSCR2_TPS2                     _CFSCR2.Bits.TPS2
#define CFSCR2_TPS3                     _CFSCR2.Bits.TPS3
#define CFSCR2_TPS4                     _CFSCR2.Bits.TPS4
#define CFSCR2_TPS5                     _CFSCR2.Bits.TPS5
#define CFSCR2_CA4E                     _CFSCR2.Bits.CA4E
#define CFSCR2_CA5E                     _CFSCR2.Bits.CA5E
#define CFSCR2_CA6E                     _CFSCR2.Bits.CA6E
#define CFSCR2_CA7E                     _CFSCR2.Bits.CA7E
#define CFSCR2_CA8E                     _CFSCR2.Bits.CA8E
#define CFSCR2_CA9E                     _CFSCR2.Bits.CA9E
#define CFSCR2_CA10E                    _CFSCR2.Bits.CA10E
#define CFSCR2_TPS                      _CFSCR2.MergedBits.grpTPS

#define CFSCR2_TPS0_MASK                1U
#define CFSCR2_TPS1_MASK                2U
#define CFSCR2_TPS2_MASK                4U
#define CFSCR2_TPS3_MASK                8U
#define CFSCR2_TPS4_MASK                16U
#define CFSCR2_TPS5_MASK                32U
#define CFSCR2_CA4E_MASK                512U
#define CFSCR2_CA5E_MASK                1024U
#define CFSCR2_CA6E_MASK                2048U
#define CFSCR2_CA7E_MASK                4096U
#define CFSCR2_CA8E_MASK                8192U
#define CFSCR2_CA9E_MASK                16384U
#define CFSCR2_CA10E_MASK               32768U
#define CFSCR2_TPS_MASK                 63U
#define CFSCR2_TPS_BITNUM               0U


/*** CFCR - CF Command Register; 0x00000288 ***/
typedef union {
  word Word;
  struct {
    word RWB         :1;                                       /* Read Operation or Write Operation */
    word INVOKE      :1;                                       /* Operation Invoked */
    word STOP        :1;                                       /* STOP Operation */
    word RQ          :1;                                       /* Reception Request (reserved bit for internal use) */
    word TQ          :1;                                       /* Transmission Request (reserved bit for internal use) */
    word             :1; 
    word BSY_CFCR    :1;                                       /* CF Module Busy */
    word HIS         :1;                                       /* Host Interface Select */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} CFCRSTR;
extern volatile CFCRSTR _CFCR @(REG_BASE + 0x00000288UL);
#define CFCR                            _CFCR.Word
#define CFCR_RWB                        _CFCR.Bits.RWB
#define CFCR_INVOKE                     _CFCR.Bits.INVOKE
#define CFCR_STOP                       _CFCR.Bits.STOP
#define CFCR_RQ                         _CFCR.Bits.RQ
#define CFCR_TQ                         _CFCR.Bits.TQ
#define CFCR_BSY_CFCR                   _CFCR.Bits.BSY_CFCR
#define CFCR_HIS                        _CFCR.Bits.HIS

#define CFCR_RWB_MASK                   1U
#define CFCR_INVOKE_MASK                2U
#define CFCR_STOP_MASK                  4U
#define CFCR_RQ_MASK                    8U
#define CFCR_TQ_MASK                    16U
#define CFCR_BSY_CFCR_MASK              64U
#define CFCR_HIS_MASK                   128U


/*** CFBBAR - CF Block Base Address Register; 0x0000028A ***/
typedef union {
  word Word;
  struct {
    word BBA0        :1;                                       /* Block Base Address Bit 0 */
    word BBA1        :1;                                       /* Block Base Address Bit 1 */
    word BBA2        :1;                                       /* Block Base Address Bit 2 */
    word BBA3        :1;                                       /* Block Base Address Bit 3 */
    word BBA4        :1;                                       /* Block Base Address Bit 4 */
    word BBA5        :1;                                       /* Block Base Address Bit 5 */
    word BBA6        :1;                                       /* Block Base Address Bit 6 */
    word BBA7        :1;                                       /* Block Base Address Bit 7 */
    word BBA8        :1;                                       /* Block Base Address Bit 8 */
    word BBA9        :1;                                       /* Block Base Address Bit 9 */
    word BBA10       :1;                                       /* Block Base Address Bit 10 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
  struct {
    word grpBBA  :11;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} CFBBARSTR;
extern volatile CFBBARSTR _CFBBAR @(REG_BASE + 0x0000028AUL);
#define CFBBAR                          _CFBBAR.Word
#define CFBBAR_BBA0                     _CFBBAR.Bits.BBA0
#define CFBBAR_BBA1                     _CFBBAR.Bits.BBA1
#define CFBBAR_BBA2                     _CFBBAR.Bits.BBA2
#define CFBBAR_BBA3                     _CFBBAR.Bits.BBA3
#define CFBBAR_BBA4                     _CFBBAR.Bits.BBA4
#define CFBBAR_BBA5                     _CFBBAR.Bits.BBA5
#define CFBBAR_BBA6                     _CFBBAR.Bits.BBA6
#define CFBBAR_BBA7                     _CFBBAR.Bits.BBA7
#define CFBBAR_BBA8                     _CFBBAR.Bits.BBA8
#define CFBBAR_BBA9                     _CFBBAR.Bits.BBA9
#define CFBBAR_BBA10                    _CFBBAR.Bits.BBA10
#define CFBBAR_BBA                      _CFBBAR.MergedBits.grpBBA

#define CFBBAR_BBA0_MASK                1U
#define CFBBAR_BBA1_MASK                2U
#define CFBBAR_BBA2_MASK                4U
#define CFBBAR_BBA3_MASK                8U
#define CFBBAR_BBA4_MASK                16U
#define CFBBAR_BBA5_MASK                32U
#define CFBBAR_BBA6_MASK                64U
#define CFBBAR_BBA7_MASK                128U
#define CFBBAR_BBA8_MASK                256U
#define CFBBAR_BBA9_MASK                512U
#define CFBBAR_BBA10_MASK               1024U
#define CFBBAR_BBA_MASK                 2047U
#define CFBBAR_BBA_BITNUM               0U


/*** CFBSR - CF Block Size Register; 0x0000028C ***/
typedef union {
  word Word;
  struct {
    word BS0         :1;                                       /* Block Size in byte Bit 0 */
    word BS1         :1;                                       /* Block Size in byte Bit 1 */
    word BS2         :1;                                       /* Block Size in byte Bit 2 */
    word BS3         :1;                                       /* Block Size in byte Bit 3 */
    word BS4         :1;                                       /* Block Size in byte Bit 4 */
    word BS5         :1;                                       /* Block Size in byte Bit 5 */
    word BS6         :1;                                       /* Block Size in byte Bit 6 */
    word BS7         :1;                                       /* Block Size in byte Bit 7 */
    word BS8         :1;                                       /* Block Size in byte Bit 8 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
  struct {
    word grpBS   :9;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} CFBSRSTR;
extern volatile CFBSRSTR _CFBSR @(REG_BASE + 0x0000028CUL);
#define CFBSR                           _CFBSR.Word
#define CFBSR_BS0                       _CFBSR.Bits.BS0
#define CFBSR_BS1                       _CFBSR.Bits.BS1
#define CFBSR_BS2                       _CFBSR.Bits.BS2
#define CFBSR_BS3                       _CFBSR.Bits.BS3
#define CFBSR_BS4                       _CFBSR.Bits.BS4
#define CFBSR_BS5                       _CFBSR.Bits.BS5
#define CFBSR_BS6                       _CFBSR.Bits.BS6
#define CFBSR_BS7                       _CFBSR.Bits.BS7
#define CFBSR_BS8                       _CFBSR.Bits.BS8
#define CFBSR_BS                        _CFBSR.MergedBits.grpBS

#define CFBSR_BS0_MASK                  1U
#define CFBSR_BS1_MASK                  2U
#define CFBSR_BS2_MASK                  4U
#define CFBSR_BS3_MASK                  8U
#define CFBSR_BS4_MASK                  16U
#define CFBSR_BS5_MASK                  32U
#define CFBSR_BS6_MASK                  64U
#define CFBSR_BS7_MASK                  128U
#define CFBSR_BS8_MASK                  256U
#define CFBSR_BS_MASK                   511U
#define CFBSR_BS_BITNUM                 0U


/*** CFPMR - CF Power Management Register; 0x0000028E ***/
typedef union {
  word Word;
  struct {
    word CVS         :1;                                       /* Card Voltage Select */
    word CPE         :1;                                       /* Card Power Enable */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} CFPMRSTR;
extern volatile CFPMRSTR _CFPMR @(REG_BASE + 0x0000028EUL);
#define CFPMR                           _CFPMR.Word
#define CFPMR_CVS                       _CFPMR.Bits.CVS
#define CFPMR_CPE                       _CFPMR.Bits.CPE

#define CFPMR_CVS_MASK                  1U
#define CFPMR_CPE_MASK                  2U


/*** CFDR - CF Data Register; 0x00000290 ***/
typedef union {
  word Word;
  struct {
    word CFDR0       :1;                                       /* Receive/Transmit Data Bit 0 */
    word CFDR1       :1;                                       /* Receive/Transmit Data Bit 1 */
    word CFDR2       :1;                                       /* Receive/Transmit Data Bit 2 */
    word CFDR3       :1;                                       /* Receive/Transmit Data Bit 3 */
    word CFDR4       :1;                                       /* Receive/Transmit Data Bit 4 */
    word CFDR5       :1;                                       /* Receive/Transmit Data Bit 5 */
    word CFDR6       :1;                                       /* Receive/Transmit Data Bit 6 */
    word CFDR7       :1;                                       /* Receive/Transmit Data Bit 7 */
    word CFDR8       :1;                                       /* Receive/Transmit Data Bit 8 */
    word CFDR9       :1;                                       /* Receive/Transmit Data Bit 9 */
    word CFDR10      :1;                                       /* Receive/Transmit Data Bit 10 */
    word CFDR11      :1;                                       /* Receive/Transmit Data Bit 11 */
    word CFDR12      :1;                                       /* Receive/Transmit Data Bit 12 */
    word CFDR13      :1;                                       /* Receive/Transmit Data Bit 13 */
    word CFDR14      :1;                                       /* Receive/Transmit Data Bit 14 */
    word CFDR15      :1;                                       /* Receive/Transmit Data Bit 15 */
  } Bits;
} CFDRSTR;
extern volatile CFDRSTR _CFDR @(REG_BASE + 0x00000290UL);
#define CFDR                            _CFDR.Word
#define CFDR_CFDR0                      _CFDR.Bits.CFDR0
#define CFDR_CFDR1                      _CFDR.Bits.CFDR1
#define CFDR_CFDR2                      _CFDR.Bits.CFDR2
#define CFDR_CFDR3                      _CFDR.Bits.CFDR3
#define CFDR_CFDR4                      _CFDR.Bits.CFDR4
#define CFDR_CFDR5                      _CFDR.Bits.CFDR5
#define CFDR_CFDR6                      _CFDR.Bits.CFDR6
#define CFDR_CFDR7                      _CFDR.Bits.CFDR7
#define CFDR_CFDR8                      _CFDR.Bits.CFDR8
#define CFDR_CFDR9                      _CFDR.Bits.CFDR9
#define CFDR_CFDR10                     _CFDR.Bits.CFDR10
#define CFDR_CFDR11                     _CFDR.Bits.CFDR11
#define CFDR_CFDR12                     _CFDR.Bits.CFDR12
#define CFDR_CFDR13                     _CFDR.Bits.CFDR13
#define CFDR_CFDR14                     _CFDR.Bits.CFDR14
#define CFDR_CFDR15                     _CFDR.Bits.CFDR15

#define CFDR_CFDR0_MASK                 1U
#define CFDR_CFDR1_MASK                 2U
#define CFDR_CFDR2_MASK                 4U
#define CFDR_CFDR3_MASK                 8U
#define CFDR_CFDR4_MASK                 16U
#define CFDR_CFDR5_MASK                 32U
#define CFDR_CFDR6_MASK                 64U
#define CFDR_CFDR7_MASK                 128U
#define CFDR_CFDR8_MASK                 256U
#define CFDR_CFDR9_MASK                 512U
#define CFDR_CFDR10_MASK                1024U
#define CFDR_CFDR11_MASK                2048U
#define CFDR_CFDR12_MASK                4096U
#define CFDR_CFDR13_MASK                8192U
#define CFDR_CFDR14_MASK                16384U
#define CFDR_CFDR15_MASK                32768U


/*** CFIFR - CF Interrupt Flag Register; 0x00000292 ***/
typedef union {
  word Word;
  struct {
    word CDIF        :1;                                       /* Card Detect Interrupt Flag */
    word CHGIF       :1;                                       /* Card State Change Interrupt Flag */
    word RDYIF       :1;                                       /* Card Ready Interrupt Flag */
    word VSIF        :1;                                       /* Voltage Sense Interrupt Flag */
    word CIF         :1;                                       /* Operation Over Interrupt Flag */
    word OOIF        :1;                                       /* Card Hard Interrupt Flag */
    word CFTEIF      :1;                                       /* CF Transmit Data Register Empty Interrupt Flag */
    word CFRFIF      :1;                                       /* CF Receive Data Register Full Interrupt Flag */
    word TERRIF      :1;                                       /* Time-out Error Interrupt Flag */
    word WERRIF      :1;                                       /* Wait Assertion Error Interrupt Flag */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} CFIFRSTR;
extern volatile CFIFRSTR _CFIFR @(REG_BASE + 0x00000292UL);
#define CFIFR                           _CFIFR.Word
#define CFIFR_CDIF                      _CFIFR.Bits.CDIF
#define CFIFR_CHGIF                     _CFIFR.Bits.CHGIF
#define CFIFR_RDYIF                     _CFIFR.Bits.RDYIF
#define CFIFR_VSIF                      _CFIFR.Bits.VSIF
#define CFIFR_CIF                       _CFIFR.Bits.CIF
#define CFIFR_OOIF                      _CFIFR.Bits.OOIF
#define CFIFR_CFTEIF                    _CFIFR.Bits.CFTEIF
#define CFIFR_CFRFIF                    _CFIFR.Bits.CFRFIF
#define CFIFR_TERRIF                    _CFIFR.Bits.TERRIF
#define CFIFR_WERRIF                    _CFIFR.Bits.WERRIF

#define CFIFR_CDIF_MASK                 1U
#define CFIFR_CHGIF_MASK                2U
#define CFIFR_RDYIF_MASK                4U
#define CFIFR_VSIF_MASK                 8U
#define CFIFR_CIF_MASK                  16U
#define CFIFR_OOIF_MASK                 32U
#define CFIFR_CFTEIF_MASK               64U
#define CFIFR_CFRFIF_MASK               128U
#define CFIFR_TERRIF_MASK               256U
#define CFIFR_WERRIF_MASK               512U


/*** MSCMD - Memory Stick Command Register; 0x000002A0 ***/
typedef union {
  word Word;
  struct {
    word DATASIZE0   :1;                                       /* Data size Bit 0 */
    word DATASIZE1   :1;                                       /* Data size Bit 1 */
    word DATASIZE2   :1;                                       /* Data size Bit 2 */
    word DATASIZE3   :1;                                       /* Data size Bit 3 */
    word DATASIZE4   :1;                                       /* Data size Bit 4 */
    word DATASIZE5   :1;                                       /* Data size Bit 5 */
    word DATASIZE6   :1;                                       /* Data size Bit 6 */
    word DATASIZE7   :1;                                       /* Data size Bit 7 */
    word DATASIZE8   :1;                                       /* Data size Bit 8 */
    word DATASIZE9   :1;                                       /* Data size Bit 9 */
    word             :1; 
    word             :1; 
    word PID0        :1;                                       /* Packet ID Bit 0 */
    word PID1        :1;                                       /* Packet ID Bit 1 */
    word PID2        :1;                                       /* Packet ID Bit2 */
    word PID3        :1;                                       /* Packet ID Bit 3 */
  } Bits;
  struct {
    word grpDATASIZE :10;
    word         :1;
    word         :1;
    word grpPID  :4;
  } MergedBits;
} MSCMDSTR;
extern volatile MSCMDSTR _MSCMD @(REG_BASE + 0x000002A0UL);
#define MSCMD                           _MSCMD.Word
#define MSCMD_DATASIZE0                 _MSCMD.Bits.DATASIZE0
#define MSCMD_DATASIZE1                 _MSCMD.Bits.DATASIZE1
#define MSCMD_DATASIZE2                 _MSCMD.Bits.DATASIZE2
#define MSCMD_DATASIZE3                 _MSCMD.Bits.DATASIZE3
#define MSCMD_DATASIZE4                 _MSCMD.Bits.DATASIZE4
#define MSCMD_DATASIZE5                 _MSCMD.Bits.DATASIZE5
#define MSCMD_DATASIZE6                 _MSCMD.Bits.DATASIZE6
#define MSCMD_DATASIZE7                 _MSCMD.Bits.DATASIZE7
#define MSCMD_DATASIZE8                 _MSCMD.Bits.DATASIZE8
#define MSCMD_DATASIZE9                 _MSCMD.Bits.DATASIZE9
#define MSCMD_PID0                      _MSCMD.Bits.PID0
#define MSCMD_PID1                      _MSCMD.Bits.PID1
#define MSCMD_PID2                      _MSCMD.Bits.PID2
#define MSCMD_PID3                      _MSCMD.Bits.PID3
#define MSCMD_DATASIZE                  _MSCMD.MergedBits.grpDATASIZE
#define MSCMD_PID                       _MSCMD.MergedBits.grpPID

#define MSCMD_DATASIZE0_MASK            1U
#define MSCMD_DATASIZE1_MASK            2U
#define MSCMD_DATASIZE2_MASK            4U
#define MSCMD_DATASIZE3_MASK            8U
#define MSCMD_DATASIZE4_MASK            16U
#define MSCMD_DATASIZE5_MASK            32U
#define MSCMD_DATASIZE6_MASK            64U
#define MSCMD_DATASIZE7_MASK            128U
#define MSCMD_DATASIZE8_MASK            256U
#define MSCMD_DATASIZE9_MASK            512U
#define MSCMD_PID0_MASK                 4096U
#define MSCMD_PID1_MASK                 8192U
#define MSCMD_PID2_MASK                 16384U
#define MSCMD_PID3_MASK                 32768U
#define MSCMD_DATASIZE_MASK             1023U
#define MSCMD_DATASIZE_BITNUM           0U
#define MSCMD_PID_MASK                  61440U
#define MSCMD_PID_BITNUM                12U


/*** MSC0 - Memory Stick Control 0 Register; 0x000002A2 ***/
typedef union {
  byte Byte;
  struct {
    byte BSYCNT0     :1;                                       /* Busy Count, RDY timeout time setting (Serial Clock Count),Bit 0 */
    byte BSYCNT1     :1;                                       /* Busy Count, RDY timeout time setting (Serial Clock Count), Bit 1 */
    byte BSYCNT2     :1;                                       /* Busy Count, RDY timeout time setting (Serial Clock Count), Bit 2 */
    byte NOCRC       :1;                                       /* No CRC */
    byte MSCE        :1;                                       /* Memory Stick Host Controller Enable */
    byte SIEN        :1;                                       /* Serial Interface Enable */
    byte PWS         :1;                                       /* Power Save */
    byte RST         :1;                                       /* Reset */
  } Bits;
  struct {
    byte grpBSYCNT :3;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} MSC0STR;
extern volatile MSC0STR _MSC0 @(REG_BASE + 0x000002A2UL);
#define MSC0                            _MSC0.Byte
#define MSC0_BSYCNT0                    _MSC0.Bits.BSYCNT0
#define MSC0_BSYCNT1                    _MSC0.Bits.BSYCNT1
#define MSC0_BSYCNT2                    _MSC0.Bits.BSYCNT2
#define MSC0_NOCRC                      _MSC0.Bits.NOCRC
#define MSC0_MSCE                       _MSC0.Bits.MSCE
#define MSC0_SIEN                       _MSC0.Bits.SIEN
#define MSC0_PWS                        _MSC0.Bits.PWS
#define MSC0_RST                        _MSC0.Bits.RST
#define MSC0_BSYCNT                     _MSC0.MergedBits.grpBSYCNT

#define MSC0_BSYCNT0_MASK               1U
#define MSC0_BSYCNT1_MASK               2U
#define MSC0_BSYCNT2_MASK               4U
#define MSC0_NOCRC_MASK                 8U
#define MSC0_MSCE_MASK                  16U
#define MSC0_SIEN_MASK                  32U
#define MSC0_PWS_MASK                   64U
#define MSC0_RST_MASK                   128U
#define MSC0_BSYCNT_MASK                7U
#define MSC0_BSYCNT_BITNUM              0U


/*** MSS0 - Memory Stick Status 0 Register; 0x000002A3 ***/
typedef union {
  byte Byte;
  struct {
    byte TBF         :1;                                       /* Transmit Buffer Full Flag */
    byte TBE         :1;                                       /* Transmit Buffer Empty Flag */
    byte RBF         :1;                                       /* Receive Buffer Full Flag */
    byte RBE         :1;                                       /* Receive Buffer Empty Flag */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} MSS0STR;
extern volatile MSS0STR _MSS0 @(REG_BASE + 0x000002A3UL);
#define MSS0                            _MSS0.Byte
#define MSS0_TBF                        _MSS0.Bits.TBF
#define MSS0_TBE                        _MSS0.Bits.TBE
#define MSS0_RBF                        _MSS0.Bits.RBF
#define MSS0_RBE                        _MSS0.Bits.RBE

#define MSS0_TBF_MASK                   1U
#define MSS0_TBE_MASK                   2U
#define MSS0_RBF_MASK                   4U
#define MSS0_RBE_MASK                   8U


/*** MSTDATA - Memory Stick Transmit FIFO DATA Register; 0x000002A4 ***/
typedef union {
  word Word;
  struct {
    word MSTDATA0    :1;                                       /* TX data buffer Bit 0 */
    word MSTDATA1    :1;                                       /* TX data buffer Bit 1 */
    word MSTDATA2    :1;                                       /* TX data buffer Bit 2 */
    word MSTDATA3    :1;                                       /* TX data buffer Bit 3 */
    word MSTDATA4    :1;                                       /* TX data buffer Bit 4 */
    word MSTDATA5    :1;                                       /* TX data buffer Bit 5 */
    word MSTDATA6    :1;                                       /* TX data buffer Bit 6 */
    word MSTDATA7    :1;                                       /* TX data buffer Bit 7 */
    word MSTDATA8    :1;                                       /* TX data buffer Bit 8 */
    word MSTDATA9    :1;                                       /* TX data buffer Bit 9 */
    word MSTDATA10   :1;                                       /* TX data buffer Bit 10 */
    word MSTDATA11   :1;                                       /* TX data buffer Bit 11 */
    word MSTDATA12   :1;                                       /* TX data buffer Bit 12 */
    word MSTDATA13   :1;                                       /* TX data buffer Bit 13 */
    word MSTDATA14   :1;                                       /* TX data buffer Bit 14 */
    word MSTDATA15   :1;                                       /* TX data buffer Bit 15 */
  } Bits;
} MSTDATASTR;
extern volatile MSTDATASTR _MSTDATA @(REG_BASE + 0x000002A4UL);
#define MSTDATA                         _MSTDATA.Word
#define MSTDATA_MSTDATA0                _MSTDATA.Bits.MSTDATA0
#define MSTDATA_MSTDATA1                _MSTDATA.Bits.MSTDATA1
#define MSTDATA_MSTDATA2                _MSTDATA.Bits.MSTDATA2
#define MSTDATA_MSTDATA3                _MSTDATA.Bits.MSTDATA3
#define MSTDATA_MSTDATA4                _MSTDATA.Bits.MSTDATA4
#define MSTDATA_MSTDATA5                _MSTDATA.Bits.MSTDATA5
#define MSTDATA_MSTDATA6                _MSTDATA.Bits.MSTDATA6
#define MSTDATA_MSTDATA7                _MSTDATA.Bits.MSTDATA7
#define MSTDATA_MSTDATA8                _MSTDATA.Bits.MSTDATA8
#define MSTDATA_MSTDATA9                _MSTDATA.Bits.MSTDATA9
#define MSTDATA_MSTDATA10               _MSTDATA.Bits.MSTDATA10
#define MSTDATA_MSTDATA11               _MSTDATA.Bits.MSTDATA11
#define MSTDATA_MSTDATA12               _MSTDATA.Bits.MSTDATA12
#define MSTDATA_MSTDATA13               _MSTDATA.Bits.MSTDATA13
#define MSTDATA_MSTDATA14               _MSTDATA.Bits.MSTDATA14
#define MSTDATA_MSTDATA15               _MSTDATA.Bits.MSTDATA15

#define MSTDATA_MSTDATA0_MASK           1U
#define MSTDATA_MSTDATA1_MASK           2U
#define MSTDATA_MSTDATA2_MASK           4U
#define MSTDATA_MSTDATA3_MASK           8U
#define MSTDATA_MSTDATA4_MASK           16U
#define MSTDATA_MSTDATA5_MASK           32U
#define MSTDATA_MSTDATA6_MASK           64U
#define MSTDATA_MSTDATA7_MASK           128U
#define MSTDATA_MSTDATA8_MASK           256U
#define MSTDATA_MSTDATA9_MASK           512U
#define MSTDATA_MSTDATA10_MASK          1024U
#define MSTDATA_MSTDATA11_MASK          2048U
#define MSTDATA_MSTDATA12_MASK          4096U
#define MSTDATA_MSTDATA13_MASK          8192U
#define MSTDATA_MSTDATA14_MASK          16384U
#define MSTDATA_MSTDATA15_MASK          32768U


/*** MSRDATA - Memory Stick Receive FIFO DATA Register; 0x000002A6 ***/
typedef union {
  word Word;
  struct {
    word MSRDATA0    :1;                                       /* RX data buffer Bit 0 */
    word MSRDATA1    :1;                                       /* RX data buffer Bit 1 */
    word MSRDATA2    :1;                                       /* RX data buffer Bit 2 */
    word MSRDATA3    :1;                                       /* RX data buffer Bit 3 */
    word MSRDATA4    :1;                                       /* RX data buffer Bit 4 */
    word MSRDATA5    :1;                                       /* RX data buffer Bit 5 */
    word MSRDATA6    :1;                                       /* RX data buffer Bit 6 */
    word MSRDATA7    :1;                                       /* RX data buffer Bit 7 */
    word MSRDATA8    :1;                                       /* RX data buffer Bit 8 */
    word MSRDATA9    :1;                                       /* RX data buffer Bit 9 */
    word MSRDATA10   :1;                                       /* RX data buffer Bit 10 */
    word MSRDATA11   :1;                                       /* RX data buffer Bit 11 */
    word MSRDATA12   :1;                                       /* RX data buffer Bit 12 */
    word MSRDATA13   :1;                                       /* RX data buffer Bit 13 */
    word MSRDATA14   :1;                                       /* RX data buffer Bit 14 */
    word MSRDATA15   :1;                                       /* RX data buffer Bit 15 */
  } Bits;
} MSRDATASTR;
extern volatile MSRDATASTR _MSRDATA @(REG_BASE + 0x000002A6UL);
#define MSRDATA                         _MSRDATA.Word
#define MSRDATA_MSRDATA0                _MSRDATA.Bits.MSRDATA0
#define MSRDATA_MSRDATA1                _MSRDATA.Bits.MSRDATA1
#define MSRDATA_MSRDATA2                _MSRDATA.Bits.MSRDATA2
#define MSRDATA_MSRDATA3                _MSRDATA.Bits.MSRDATA3
#define MSRDATA_MSRDATA4                _MSRDATA.Bits.MSRDATA4
#define MSRDATA_MSRDATA5                _MSRDATA.Bits.MSRDATA5
#define MSRDATA_MSRDATA6                _MSRDATA.Bits.MSRDATA6
#define MSRDATA_MSRDATA7                _MSRDATA.Bits.MSRDATA7
#define MSRDATA_MSRDATA8                _MSRDATA.Bits.MSRDATA8
#define MSRDATA_MSRDATA9                _MSRDATA.Bits.MSRDATA9
#define MSRDATA_MSRDATA10               _MSRDATA.Bits.MSRDATA10
#define MSRDATA_MSRDATA11               _MSRDATA.Bits.MSRDATA11
#define MSRDATA_MSRDATA12               _MSRDATA.Bits.MSRDATA12
#define MSRDATA_MSRDATA13               _MSRDATA.Bits.MSRDATA13
#define MSRDATA_MSRDATA14               _MSRDATA.Bits.MSRDATA14
#define MSRDATA_MSRDATA15               _MSRDATA.Bits.MSRDATA15

#define MSRDATA_MSRDATA0_MASK           1U
#define MSRDATA_MSRDATA1_MASK           2U
#define MSRDATA_MSRDATA2_MASK           4U
#define MSRDATA_MSRDATA3_MASK           8U
#define MSRDATA_MSRDATA4_MASK           16U
#define MSRDATA_MSRDATA5_MASK           32U
#define MSRDATA_MSRDATA6_MASK           64U
#define MSRDATA_MSRDATA7_MASK           128U
#define MSRDATA_MSRDATA8_MASK           256U
#define MSRDATA_MSRDATA9_MASK           512U
#define MSRDATA_MSRDATA10_MASK          1024U
#define MSRDATA_MSRDATA11_MASK          2048U
#define MSRDATA_MSRDATA12_MASK          4096U
#define MSRDATA_MSRDATA13_MASK          8192U
#define MSRDATA_MSRDATA14_MASK          16384U
#define MSRDATA_MSRDATA15_MASK          32768U


/*** MSIC - Memory Stick Interrupt Control Register; 0x000002A8 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte FAEEN       :1;                                       /* FIFO Access Error Detection Enable */
    byte DTCMPIE     :1;                                       /* Data Transfer Complete Interrupt Enable */
    byte DTRQIE      :1;                                       /* Data Transfer Request Interrupt Enable */
    byte INTE_MSIC   :1;                                       /* Interrupt Enable */
  } Bits;
} MSICSTR;
extern volatile MSICSTR _MSIC @(REG_BASE + 0x000002A8UL);
#define MSIC                            _MSIC.Byte
#define MSIC_FAEEN                      _MSIC.Bits.FAEEN
#define MSIC_DTCMPIE                    _MSIC.Bits.DTCMPIE
#define MSIC_DTRQIE                     _MSIC.Bits.DTRQIE
#define MSIC_INTE_MSIC                  _MSIC.Bits.INTE_MSIC

#define MSIC_FAEEN_MASK                 16U
#define MSIC_DTCMPIE_MASK               32U
#define MSIC_DTRQIE_MASK                64U
#define MSIC_INTE_MSIC_MASK             128U


/*** MSIS - Memory Stick Interrupt Status Register; 0x000002A9 ***/
typedef union {
  byte Byte;
  struct {
    byte TOE         :1;                                       /* Time Out Error flag */
    byte CRCE        :1;                                       /* CRC Error flag */
    byte FAE         :1;                                       /* FIFO Access Error flag */
    byte             :1; 
    byte DTCMP       :1;                                       /* Data Transfer Complete flag */
    byte DTRQ        :1;                                       /* Data Transfer Request flag */
    byte SIF         :1;                                       /* Serial I/F Interrupt flag */
    byte RDY_MSIS    :1;                                       /* Ready flag */
  } Bits;
} MSISSTR;
extern volatile MSISSTR _MSIS @(REG_BASE + 0x000002A9UL);
#define MSIS                            _MSIS.Byte
#define MSIS_TOE                        _MSIS.Bits.TOE
#define MSIS_CRCE                       _MSIS.Bits.CRCE
#define MSIS_FAE                        _MSIS.Bits.FAE
#define MSIS_DTCMP                      _MSIS.Bits.DTCMP
#define MSIS_DTRQ                       _MSIS.Bits.DTRQ
#define MSIS_SIF                        _MSIS.Bits.SIF
#define MSIS_RDY_MSIS                   _MSIS.Bits.RDY_MSIS

#define MSIS_TOE_MASK                   1U
#define MSIS_CRCE_MASK                  2U
#define MSIS_FAE_MASK                   4U
#define MSIS_DTCMP_MASK                 16U
#define MSIS_DTRQ_MASK                  32U
#define MSIS_SIF_MASK                   64U
#define MSIS_RDY_MSIS_MASK              128U


/*** MSC1 - Memory Stick Control 1 Register; 0x000002AA ***/
typedef union {
  byte Byte;
  struct {
    byte TFE         :1;                                       /* TxFIFO Empty data transfer Request */
    byte RFF         :1;                                       /* RxFIFO Full data transfer Request */
    byte             :1; 
    byte DTRQE       :1;                                       /* Transfer through QUEUE module Enable */
    byte DIV0        :1;                                       /* Divide Ratio Bit 0 */
    byte DIV1        :1;                                       /* Divide Ratio Bit 1 */
    byte             :1; 
    byte ACD         :1;                                       /* Auto Command */
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte grpDIV  :2;
    byte         :1;
    byte         :1;
  } MergedBits;
} MSC1STR;
extern volatile MSC1STR _MSC1 @(REG_BASE + 0x000002AAUL);
#define MSC1                            _MSC1.Byte
#define MSC1_TFE                        _MSC1.Bits.TFE
#define MSC1_RFF                        _MSC1.Bits.RFF
#define MSC1_DTRQE                      _MSC1.Bits.DTRQE
#define MSC1_DIV0                       _MSC1.Bits.DIV0
#define MSC1_DIV1                       _MSC1.Bits.DIV1
#define MSC1_ACD                        _MSC1.Bits.ACD
#define MSC1_DIV                        _MSC1.MergedBits.grpDIV

#define MSC1_TFE_MASK                   1U
#define MSC1_RFF_MASK                   2U
#define MSC1_DTRQE_MASK                 8U
#define MSC1_DIV0_MASK                  16U
#define MSC1_DIV1_MASK                  32U
#define MSC1_ACD_MASK                   128U
#define MSC1_DIV_MASK                   48U
#define MSC1_DIV_BITNUM                 4U


/*** MSS1 - Memory Stick Status 1 Register; 0x000002AB ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte TOV         :1;                                       /* TxFIFO Overrun Access */
    byte RUN         :1;                                       /* RxFIFO Underrun Access */
  } Bits;
} MSS1STR;
extern volatile MSS1STR _MSS1 @(REG_BASE + 0x000002ABUL);
#define MSS1                            _MSS1.Byte
#define MSS1_TOV                        _MSS1.Bits.TOV
#define MSS1_RUN                        _MSS1.Bits.RUN

#define MSS1_TOV_MASK                   64U
#define MSS1_RUN_MASK                   128U


/*** MSACMD - Memory Stick Auto Command Register; 0x000002AC ***/
typedef union {
  word Word;
  struct {
    word ADATASIZE0  :1;                                       /* Auto Command Data Size Bit 0 */
    word ADATASIZE1  :1;                                       /* Auto Command Data Size Bit 1 */
    word ADATASIZE2  :1;                                       /* Auto Command Data Size Bit 2 */
    word ADATASIZE3  :1;                                       /* Auto Command Data Size Bit 3 */
    word ADATASIZE4  :1;                                       /* Auto Command Data Size Bit 4 */
    word ADATASIZE5  :1;                                       /* Auto Command Data Size Bit 5 */
    word ADATASIZE6  :1;                                       /* Auto Command Data Size Bit 6 */
    word ADATASIZE7  :1;                                       /* Auto Command Data Size Bit 7 */
    word ADATASIZE8  :1;                                       /* Auto Command Data Size Bit 8 */
    word ADATASIZE9  :1;                                       /* Auto Command Data Size Bit 9 */
    word             :1; 
    word             :1; 
    word APID0       :1;                                       /* Auto Command PID Bit 0 */
    word APID1       :1;                                       /* Auto Command PID Bit 1 */
    word APID2       :1;                                       /* Auto Command PID Bit 2 */
    word APID3       :1;                                       /* Auto Command PID Bit 3 */
  } Bits;
  struct {
    word grpADATASIZE :10;
    word         :1;
    word         :1;
    word grpAPID :4;
  } MergedBits;
} MSACMDSTR;
extern volatile MSACMDSTR _MSACMD @(REG_BASE + 0x000002ACUL);
#define MSACMD                          _MSACMD.Word
#define MSACMD_ADATASIZE0               _MSACMD.Bits.ADATASIZE0
#define MSACMD_ADATASIZE1               _MSACMD.Bits.ADATASIZE1
#define MSACMD_ADATASIZE2               _MSACMD.Bits.ADATASIZE2
#define MSACMD_ADATASIZE3               _MSACMD.Bits.ADATASIZE3
#define MSACMD_ADATASIZE4               _MSACMD.Bits.ADATASIZE4
#define MSACMD_ADATASIZE5               _MSACMD.Bits.ADATASIZE5
#define MSACMD_ADATASIZE6               _MSACMD.Bits.ADATASIZE6
#define MSACMD_ADATASIZE7               _MSACMD.Bits.ADATASIZE7
#define MSACMD_ADATASIZE8               _MSACMD.Bits.ADATASIZE8
#define MSACMD_ADATASIZE9               _MSACMD.Bits.ADATASIZE9
#define MSACMD_APID0                    _MSACMD.Bits.APID0
#define MSACMD_APID1                    _MSACMD.Bits.APID1
#define MSACMD_APID2                    _MSACMD.Bits.APID2
#define MSACMD_APID3                    _MSACMD.Bits.APID3
#define MSACMD_ADATASIZE                _MSACMD.MergedBits.grpADATASIZE
#define MSACMD_APID                     _MSACMD.MergedBits.grpAPID

#define MSACMD_ADATASIZE0_MASK          1U
#define MSACMD_ADATASIZE1_MASK          2U
#define MSACMD_ADATASIZE2_MASK          4U
#define MSACMD_ADATASIZE3_MASK          8U
#define MSACMD_ADATASIZE4_MASK          16U
#define MSACMD_ADATASIZE5_MASK          32U
#define MSACMD_ADATASIZE6_MASK          64U
#define MSACMD_ADATASIZE7_MASK          128U
#define MSACMD_ADATASIZE8_MASK          256U
#define MSACMD_ADATASIZE9_MASK          512U
#define MSACMD_APID0_MASK               4096U
#define MSACMD_APID1_MASK               8192U
#define MSACMD_APID2_MASK               16384U
#define MSACMD_APID3_MASK               32768U
#define MSACMD_ADATASIZE_MASK           1023U
#define MSACMD_ADATASIZE_BITNUM         0U
#define MSACMD_APID_MASK                61440U
#define MSACMD_APID_BITNUM              12U


/*** SMC - Smartmedia Control Register; 0x000002B0 ***/
typedef union {
  byte Byte;
  struct {
    byte CNT0        :1;                                       /* Specify the no. of bytes of data to be transferred to smartmedia for page program operation, Bit 0 */
    byte CNT1        :1;                                       /* Specify the no. of bytes of data to be transferred to smartmedia for page program operation, Bit 1 */
    byte ECCEN       :1;                                       /* Enable/disable ECC generation during read/page program operations */
    byte QEN         :1;                                       /* Enable/disable QUE during read/page program operations */
    byte SMRST       :1;                                       /* State machine reset */
    byte FRST        :1;                                       /* FIFO reset */
    byte SMHCEN      :1;                                       /* Smartmedia host controller enable */
    byte             :1; 
  } Bits;
  struct {
    byte grpCNT  :2;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} SMCSTR;
extern volatile SMCSTR _SMC @(REG_BASE + 0x000002B0UL);
#define SMC                             _SMC.Byte
#define SMC_CNT0                        _SMC.Bits.CNT0
#define SMC_CNT1                        _SMC.Bits.CNT1
#define SMC_ECCEN                       _SMC.Bits.ECCEN
#define SMC_QEN                         _SMC.Bits.QEN
#define SMC_SMRST                       _SMC.Bits.SMRST
#define SMC_FRST                        _SMC.Bits.FRST
#define SMC_SMHCEN                      _SMC.Bits.SMHCEN
#define SMC_CNT                         _SMC.MergedBits.grpCNT

#define SMC_CNT0_MASK                   1U
#define SMC_CNT1_MASK                   2U
#define SMC_ECCEN_MASK                  4U
#define SMC_QEN_MASK                    8U
#define SMC_SMRST_MASK                  16U
#define SMC_FRST_MASK                   32U
#define SMC_SMHCEN_MASK                 64U
#define SMC_CNT_MASK                    3U
#define SMC_CNT_BITNUM                  0U


/*** SMHS - Smartmedia Handshake Register; 0x000002B1 ***/
typedef union {
  byte Byte;
  struct {
    byte SCE         :1;                                       /* Start command execution */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} SMHSSTR;
extern volatile SMHSSTR _SMHS @(REG_BASE + 0x000002B1UL);
#define SMHS                            _SMHS.Byte
#define SMHS_SCE                        _SMHS.Bits.SCE

#define SMHS_SCE_MASK                   1U


/*** SMDATA - Smartmedia FIFO DATA Register (transmitter and receiver); 0x000002B2 ***/
typedef union {
  word Word;
  struct {
    word B0          :1;                                       /* FIFO Data Buffer Bit 0 */
    word B1          :1;                                       /* FIFO Data Buffer Bit 1 */
    word B2          :1;                                       /* FIFO Data Buffer Bit 2 */
    word B3          :1;                                       /* FIFO Data Buffer Bit 3 */
    word B4          :1;                                       /* FIFO Data Buffer Bit 4 */
    word B5          :1;                                       /* FIFO Data Buffer Bit 5 */
    word B6          :1;                                       /* FIFO Data Buffer Bit 6 */
    word B7          :1;                                       /* FIFO Data Buffer Bit 7 */
    word B8          :1;                                       /* FIFO Data Buffer Bit 8 */
    word B9          :1;                                       /* FIFO Data Buffer Bit 9 */
    word B10         :1;                                       /* FIFO Data Buffer Bit 10 */
    word B11         :1;                                       /* FIFO Data Buffer Bit 11 */
    word B12         :1;                                       /* FIFO Data Buffer Bit 12 */
    word B13         :1;                                       /* FIFO Data Buffer Bit 13 */
    word B14         :1;                                       /* FIFO Data Buffer Bit 14 */
    word B15         :1;                                       /* FIFO Data Buffer Bit 15 */
  } Bits;
} SMDATASTR;
extern volatile SMDATASTR _SMDATA @(REG_BASE + 0x000002B2UL);
#define SMDATA                          _SMDATA.Word
#define SMDATA_B0                       _SMDATA.Bits.B0
#define SMDATA_B1                       _SMDATA.Bits.B1
#define SMDATA_B2                       _SMDATA.Bits.B2
#define SMDATA_B3                       _SMDATA.Bits.B3
#define SMDATA_B4                       _SMDATA.Bits.B4
#define SMDATA_B5                       _SMDATA.Bits.B5
#define SMDATA_B6                       _SMDATA.Bits.B6
#define SMDATA_B7                       _SMDATA.Bits.B7
#define SMDATA_B8                       _SMDATA.Bits.B8
#define SMDATA_B9                       _SMDATA.Bits.B9
#define SMDATA_B10                      _SMDATA.Bits.B10
#define SMDATA_B11                      _SMDATA.Bits.B11
#define SMDATA_B12                      _SMDATA.Bits.B12
#define SMDATA_B13                      _SMDATA.Bits.B13
#define SMDATA_B14                      _SMDATA.Bits.B14
#define SMDATA_B15                      _SMDATA.Bits.B15

#define SMDATA_B0_MASK                  1U
#define SMDATA_B1_MASK                  2U
#define SMDATA_B2_MASK                  4U
#define SMDATA_B3_MASK                  8U
#define SMDATA_B4_MASK                  16U
#define SMDATA_B5_MASK                  32U
#define SMDATA_B6_MASK                  64U
#define SMDATA_B7_MASK                  128U
#define SMDATA_B8_MASK                  256U
#define SMDATA_B9_MASK                  512U
#define SMDATA_B10_MASK                 1024U
#define SMDATA_B11_MASK                 2048U
#define SMDATA_B12_MASK                 4096U
#define SMDATA_B13_MASK                 8192U
#define SMDATA_B14_MASK                 16384U
#define SMDATA_B15_MASK                 32768U


/*** SMISR - Smartmedia Interrupt Status Register(; 0x000002B4 ***/
typedef union {
  byte Byte;
  struct {
    byte RDY_SMISR   :1;                                       /* Smartmedia ready interrupt. */
    byte CDOUT       :1;                                       /* Card Out interrupt */
    byte CDIN        :1;                                       /* Card Insert interrupt */
    byte RDP         :1;                                       /* Redundant data pending interrupt */
    byte RDR         :1;                                       /* Redundant data ready interrupt */
    byte ECCR        :1;                                       /* ECC ready interrupt */
    byte HCE         :1;                                       /* Host controller error interrupt */
    byte             :1; 
  } Bits;
} SMISRSTR;
extern volatile SMISRSTR _SMISR @(REG_BASE + 0x000002B4UL);
#define SMISR                           _SMISR.Byte
#define SMISR_RDY_SMISR                 _SMISR.Bits.RDY_SMISR
#define SMISR_CDOUT                     _SMISR.Bits.CDOUT
#define SMISR_CDIN                      _SMISR.Bits.CDIN
#define SMISR_RDP                       _SMISR.Bits.RDP
#define SMISR_RDR                       _SMISR.Bits.RDR
#define SMISR_ECCR                      _SMISR.Bits.ECCR
#define SMISR_HCE                       _SMISR.Bits.HCE

#define SMISR_RDY_SMISR_MASK            1U
#define SMISR_CDOUT_MASK                2U
#define SMISR_CDIN_MASK                 4U
#define SMISR_RDP_MASK                  8U
#define SMISR_RDR_MASK                  16U
#define SMISR_ECCR_MASK                 32U
#define SMISR_HCE_MASK                  64U


/*** SMIMR - Smartmedia Interrupt Mask Register; 0x000002B5 ***/
typedef union {
  byte Byte;
  struct {
    byte RDYIEN      :1;                                       /* The ready interrupt enable */
    byte CDOUTIEN    :1;                                       /* The card out interrupt enable */
    byte CDINIEN     :1;                                       /* The card in interrupt enable */
    byte RDPIEN      :1;                                       /* The redundant data pending interrupt enable */
    byte RDRIEN      :1;                                       /* The redundant data ready interrupt enable */
    byte ECCRIEN     :1;                                       /* The ECC ready interrupt enable */
    byte HCEIEN      :1;                                       /* The host controller error interrupt enable */
    byte INTEN       :1;                                       /* Interrupt Enable */
  } Bits;
} SMIMRSTR;
extern volatile SMIMRSTR _SMIMR @(REG_BASE + 0x000002B5UL);
#define SMIMR                           _SMIMR.Byte
#define SMIMR_RDYIEN                    _SMIMR.Bits.RDYIEN
#define SMIMR_CDOUTIEN                  _SMIMR.Bits.CDOUTIEN
#define SMIMR_CDINIEN                   _SMIMR.Bits.CDINIEN
#define SMIMR_RDPIEN                    _SMIMR.Bits.RDPIEN
#define SMIMR_RDRIEN                    _SMIMR.Bits.RDRIEN
#define SMIMR_ECCRIEN                   _SMIMR.Bits.ECCRIEN
#define SMIMR_HCEIEN                    _SMIMR.Bits.HCEIEN
#define SMIMR_INTEN                     _SMIMR.Bits.INTEN

#define SMIMR_RDYIEN_MASK               1U
#define SMIMR_CDOUTIEN_MASK             2U
#define SMIMR_CDINIEN_MASK              4U
#define SMIMR_RDPIEN_MASK               8U
#define SMIMR_RDRIEN_MASK               16U
#define SMIMR_ECCRIEN_MASK              32U
#define SMIMR_HCEIEN_MASK               64U
#define SMIMR_INTEN_MASK                128U


/*** SMS - Smartmedia Status Register(; 0x000002B6 ***/
typedef union {
  byte Byte;
  struct {
    byte CP          :1;                                       /* Card present */
    byte BUSY        :1;                                       /* Shows the smartmedia is busy or ready */
    byte DRQ_SMS     :1;                                       /* QUE request */
    byte BAF1P       :1;                                       /* Block Address Field-1 parity check */
    byte BAF2P       :1;                                       /*  Block Address Field-2 parity check */
    byte SME         :1;                                       /* State machine error */
    byte CEC         :1;                                       /* Command execution complete */
    byte             :1; 
  } Bits;
} SMSSTR;
extern volatile SMSSTR _SMS @(REG_BASE + 0x000002B6UL);
#define SMS                             _SMS.Byte
#define SMS_CP                          _SMS.Bits.CP
#define SMS_BUSY                        _SMS.Bits.BUSY
#define SMS_DRQ_SMS                     _SMS.Bits.DRQ_SMS
#define SMS_BAF1P                       _SMS.Bits.BAF1P
#define SMS_BAF2P                       _SMS.Bits.BAF2P
#define SMS_SME                         _SMS.Bits.SME
#define SMS_CEC                         _SMS.Bits.CEC

#define SMS_CP_MASK                     1U
#define SMS_BUSY_MASK                   2U
#define SMS_DRQ_SMS_MASK                4U
#define SMS_BAF1P_MASK                  8U
#define SMS_BAF2P_MASK                  16U
#define SMS_SME_MASK                    32U
#define SMS_CEC_MASK                    64U


/*** SMFCS - Smartmedia FIFO Status Register; 0x000002B7 ***/
typedef union {
  byte Byte;
  struct {
    byte TBF_SMFCS   :1;                                       /* The transmit FIFO full flag */
    byte TBE_SMFCS   :1;                                       /* The transmit FIFO empty flag */
    byte RBF_SMFCS   :1;                                       /* The receive FIFO full flag */
    byte RBE_SMFCS   :1;                                       /* The receive FIFO empty flag */
    byte TFL_SMFCS   :1;                                       /* Transmit FIFO flush */
    byte RFL_SMFCS   :1;                                       /* Receive FIFO flush */
    byte             :1; 
    byte             :1; 
  } Bits;
} SMFCSSTR;
extern volatile SMFCSSTR _SMFCS @(REG_BASE + 0x000002B7UL);
#define SMFCS                           _SMFCS.Byte
#define SMFCS_TBF_SMFCS                 _SMFCS.Bits.TBF_SMFCS
#define SMFCS_TBE_SMFCS                 _SMFCS.Bits.TBE_SMFCS
#define SMFCS_RBF_SMFCS                 _SMFCS.Bits.RBF_SMFCS
#define SMFCS_RBE_SMFCS                 _SMFCS.Bits.RBE_SMFCS
#define SMFCS_TFL_SMFCS                 _SMFCS.Bits.TFL_SMFCS
#define SMFCS_RFL_SMFCS                 _SMFCS.Bits.RFL_SMFCS

#define SMFCS_TBF_SMFCS_MASK            1U
#define SMFCS_TBE_SMFCS_MASK            2U
#define SMFCS_RBF_SMFCS_MASK            4U
#define SMFCS_RBE_SMFCS_MASK            8U
#define SMFCS_TFL_SMFCS_MASK            16U
#define SMFCS_RFL_SMFCS_MASK            32U


/*** SMCLKR - Smartmedia Clock Rate Register(; 0x000002B8 ***/
typedef union {
  byte Byte;
  struct {
    byte PS0         :1;                                       /* The pre-scalar settings Bit 0 */
    byte PS1         :1;                                       /* The pre-scalar settings Bit 1 */
    byte PS2         :1;                                       /* The pre-scalar settings Bit 2 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpPS   :3;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} SMCLKRSTR;
extern volatile SMCLKRSTR _SMCLKR @(REG_BASE + 0x000002B8UL);
#define SMCLKR                          _SMCLKR.Byte
#define SMCLKR_PS0                      _SMCLKR.Bits.PS0
#define SMCLKR_PS1                      _SMCLKR.Bits.PS1
#define SMCLKR_PS2                      _SMCLKR.Bits.PS2
#define SMCLKR_PS                       _SMCLKR.MergedBits.grpPS

#define SMCLKR_PS0_MASK                 1U
#define SMCLKR_PS1_MASK                 2U
#define SMCLKR_PS2_MASK                 4U
#define SMCLKR_PS_MASK                  7U
#define SMCLKR_PS_BITNUM                0U


/*** SDCON - SDHC Control Register; 0x000002C0 ***/
typedef union {
  word Word;
  struct {
    word SDEN        :1;                                       /* module enable */
    word QIEN        :1;                                       /* fast data transfer enable */
    word PDEN        :1;                                       /* Pull-down enable */
    word PUEN        :1;                                       /* Pull-up enable */
    word IRST        :1;                                       /* Internal reset enable */
    word LBUF        :1;                                       /* Last data buffer */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} SDCONSTR;
extern volatile SDCONSTR _SDCON @(REG_BASE + 0x000002C0UL);
#define SDCON                           _SDCON.Word
#define SDCON_SDEN                      _SDCON.Bits.SDEN
#define SDCON_QIEN                      _SDCON.Bits.QIEN
#define SDCON_PDEN                      _SDCON.Bits.PDEN
#define SDCON_PUEN                      _SDCON.Bits.PUEN
#define SDCON_IRST                      _SDCON.Bits.IRST
#define SDCON_LBUF                      _SDCON.Bits.LBUF

#define SDCON_SDEN_MASK                 1U
#define SDCON_QIEN_MASK                 2U
#define SDCON_PDEN_MASK                 4U
#define SDCON_PUEN_MASK                 8U
#define SDCON_IRST_MASK                 16U
#define SDCON_LBUF_MASK                 32U


/*** SDSTAT - SDHC Status Register; 0x000002C2 ***/
typedef union {
  word Word;
  struct {
    word RDTO        :1;                                       /* Read data timeout */
    word RSPTO       :1;                                       /* Response timeout */
    word WR_ECRC     :1;                                       /* CRC write error */
    word RD_ECRC     :1;                                       /* CRC read error */
    word RSP_ECRC    :1;                                       /* Response CRC error */
    word WR_ECRC_CODE0 :1;                                     /* Write CRC Error code Bit 0 */
    word WR_ECRC_CODE1 :1;                                     /* Write CRC Error code Bit 1 */
    word SDCKON      :1;                                       /* SD/MMC card clock running */
    word DTDN        :1;                                       /* Data transfer done */
    word WRDN        :1;                                       /* Write SD/MMC card done */
    word ECR         :1;                                       /* End command response */
    word CD          :1;                                       /* Card Detected */
    word FEMPTY      :1;                                       /* Data FIFO empty */
    word FFULL       :1;                                       /* Data FIFO full */
    word             :1; 
    word             :1; 
  } Bits;
  struct {
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpWR_ECRC_CODE :2;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} SDSTATSTR;
extern volatile SDSTATSTR _SDSTAT @(REG_BASE + 0x000002C2UL);
#define SDSTAT                          _SDSTAT.Word
#define SDSTAT_RDTO                     _SDSTAT.Bits.RDTO
#define SDSTAT_RSPTO                    _SDSTAT.Bits.RSPTO
#define SDSTAT_WR_ECRC                  _SDSTAT.Bits.WR_ECRC
#define SDSTAT_RD_ECRC                  _SDSTAT.Bits.RD_ECRC
#define SDSTAT_RSP_ECRC                 _SDSTAT.Bits.RSP_ECRC
#define SDSTAT_WR_ECRC_CODE0            _SDSTAT.Bits.WR_ECRC_CODE0
#define SDSTAT_WR_ECRC_CODE1            _SDSTAT.Bits.WR_ECRC_CODE1
#define SDSTAT_SDCKON                   _SDSTAT.Bits.SDCKON
#define SDSTAT_DTDN                     _SDSTAT.Bits.DTDN
#define SDSTAT_WRDN                     _SDSTAT.Bits.WRDN
#define SDSTAT_ECR                      _SDSTAT.Bits.ECR
#define SDSTAT_CD                       _SDSTAT.Bits.CD
#define SDSTAT_FEMPTY                   _SDSTAT.Bits.FEMPTY
#define SDSTAT_FFULL                    _SDSTAT.Bits.FFULL
#define SDSTAT_WR_ECRC_CODE             _SDSTAT.MergedBits.grpWR_ECRC_CODE

#define SDSTAT_RDTO_MASK                1U
#define SDSTAT_RSPTO_MASK               2U
#define SDSTAT_WR_ECRC_MASK             4U
#define SDSTAT_RD_ECRC_MASK             8U
#define SDSTAT_RSP_ECRC_MASK            16U
#define SDSTAT_WR_ECRC_CODE0_MASK       32U
#define SDSTAT_WR_ECRC_CODE1_MASK       64U
#define SDSTAT_SDCKON_MASK              128U
#define SDSTAT_DTDN_MASK                256U
#define SDSTAT_WRDN_MASK                512U
#define SDSTAT_ECR_MASK                 1024U
#define SDSTAT_CD_MASK                  2048U
#define SDSTAT_FEMPTY_MASK              4096U
#define SDSTAT_FFULL_MASK               8192U
#define SDSTAT_WR_ECRC_CODE_MASK        96U
#define SDSTAT_WR_ECRC_CODE_BITNUM      5U


/*** SDCLKCON - SD Clock Control Register; 0x000002C4 ***/
typedef union {
  word Word;
  struct {
    word CLKRATE0    :1;                                       /* SD?MMC card clock rate Bit 0 */
    word CLKRATE1    :1;                                       /* SD?MMC card clock rate Bit 1 */
    word CLKRATE2    :1;                                       /* SD?MMC card clock rate Bit 2 */
    word SCLKEN      :1;                                       /* SD/MMC card clock enable */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
  struct {
    word grpCLKRATE :3;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} SDCLKCONSTR;
extern volatile SDCLKCONSTR _SDCLKCON @(REG_BASE + 0x000002C4UL);
#define SDCLKCON                        _SDCLKCON.Word
#define SDCLKCON_CLKRATE0               _SDCLKCON.Bits.CLKRATE0
#define SDCLKCON_CLKRATE1               _SDCLKCON.Bits.CLKRATE1
#define SDCLKCON_CLKRATE2               _SDCLKCON.Bits.CLKRATE2
#define SDCLKCON_SCLKEN                 _SDCLKCON.Bits.SCLKEN
#define SDCLKCON_CLKRATE                _SDCLKCON.MergedBits.grpCLKRATE

#define SDCLKCON_CLKRATE0_MASK          1U
#define SDCLKCON_CLKRATE1_MASK          2U
#define SDCLKCON_CLKRATE2_MASK          4U
#define SDCLKCON_SCLKEN_MASK            8U
#define SDCLKCON_CLKRATE_MASK           7U
#define SDCLKCON_CLKRATE_BITNUM         0U


/*** SDCMDATCON - Command and Data Control Register; 0x000002C6 ***/
typedef union {
  word Word;
  struct {
    word RSPNO0      :1;                                       /* Response types Bit 0 */
    word RSPNO1      :1;                                       /* Response types Bit 1 */
    word DATAEN      :1;                                       /* Data transfer enable */
    word WRD         :1;                                       /* Data read or write operation */
    word SBMOD       :1;                                       /* Data transfer mode selection */
    word MBLK        :1;                                       /* Multiple block mode */
    word BUSY_SDCMDATCON :1;                                   /* Expected busy status */
    word INIT        :1;                                       /* Card initialization */
    word             :1; 
    word WBUS        :1;                                       /* Wide bus selection */
    word NOBEN       :1;                                       /* NOB enable */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
  struct {
    word grpRSPNO :2;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} SDCMDATCONSTR;
extern volatile SDCMDATCONSTR _SDCMDATCON @(REG_BASE + 0x000002C6UL);
#define SDCMDATCON                      _SDCMDATCON.Word
#define SDCMDATCON_RSPNO0               _SDCMDATCON.Bits.RSPNO0
#define SDCMDATCON_RSPNO1               _SDCMDATCON.Bits.RSPNO1
#define SDCMDATCON_DATAEN               _SDCMDATCON.Bits.DATAEN
#define SDCMDATCON_WRD                  _SDCMDATCON.Bits.WRD
#define SDCMDATCON_SBMOD                _SDCMDATCON.Bits.SBMOD
#define SDCMDATCON_MBLK                 _SDCMDATCON.Bits.MBLK
#define SDCMDATCON_BUSY_SDCMDATCON      _SDCMDATCON.Bits.BUSY_SDCMDATCON
#define SDCMDATCON_INIT                 _SDCMDATCON.Bits.INIT
#define SDCMDATCON_WBUS                 _SDCMDATCON.Bits.WBUS
#define SDCMDATCON_NOBEN                _SDCMDATCON.Bits.NOBEN
#define SDCMDATCON_RSPNO                _SDCMDATCON.MergedBits.grpRSPNO

#define SDCMDATCON_RSPNO0_MASK          1U
#define SDCMDATCON_RSPNO1_MASK          2U
#define SDCMDATCON_DATAEN_MASK          4U
#define SDCMDATCON_WRD_MASK             8U
#define SDCMDATCON_SBMOD_MASK           16U
#define SDCMDATCON_MBLK_MASK            32U
#define SDCMDATCON_BUSY_SDCMDATCON_MASK 64U
#define SDCMDATCON_INIT_MASK            128U
#define SDCMDATCON_WBUS_MASK            512U
#define SDCMDATCON_NOBEN_MASK           1024U
#define SDCMDATCON_RSPNO_MASK           3U
#define SDCMDATCON_RSPNO_BITNUM         0U


/*** SDRTOUT - Response Timeout Register; 0x000002C8 ***/
typedef union {
  word Word;
  struct {
    word RSP_TO0     :1;                                       /* Response timeout Bit 0 */
    word RSP_TO1     :1;                                       /* Response timeout Bit 1 */
    word RSP_TO2     :1;                                       /* Response timeout Bit 2 */
    word RSP_TO3     :1;                                       /* Response timeout Bit 3 */
    word RSP_TO4     :1;                                       /* Response timeout Bit 4 */
    word RSP_TO5     :1;                                       /* Response timeout Bit 5 */
    word RSP_TO6     :1;                                       /* Response timeout Bit 6 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
  struct {
    word grpRSP_TO :7;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} SDRTOUTSTR;
extern volatile SDRTOUTSTR _SDRTOUT @(REG_BASE + 0x000002C8UL);
#define SDRTOUT                         _SDRTOUT.Word
#define SDRTOUT_RSP_TO0                 _SDRTOUT.Bits.RSP_TO0
#define SDRTOUT_RSP_TO1                 _SDRTOUT.Bits.RSP_TO1
#define SDRTOUT_RSP_TO2                 _SDRTOUT.Bits.RSP_TO2
#define SDRTOUT_RSP_TO3                 _SDRTOUT.Bits.RSP_TO3
#define SDRTOUT_RSP_TO4                 _SDRTOUT.Bits.RSP_TO4
#define SDRTOUT_RSP_TO5                 _SDRTOUT.Bits.RSP_TO5
#define SDRTOUT_RSP_TO6                 _SDRTOUT.Bits.RSP_TO6
#define SDRTOUT_RSP_TO                  _SDRTOUT.MergedBits.grpRSP_TO

#define SDRTOUT_RSP_TO0_MASK            1U
#define SDRTOUT_RSP_TO1_MASK            2U
#define SDRTOUT_RSP_TO2_MASK            4U
#define SDRTOUT_RSP_TO3_MASK            8U
#define SDRTOUT_RSP_TO4_MASK            16U
#define SDRTOUT_RSP_TO5_MASK            32U
#define SDRTOUT_RSP_TO6_MASK            64U
#define SDRTOUT_RSP_TO_MASK             127U
#define SDRTOUT_RSP_TO_BITNUM           0U


/*** SDRDTOUT - Read Timeout Register; 0x000002CA ***/
typedef union {
  word Word;
  struct {
    word RD_TO0      :1;                                       /* Read timeout Bit 0 */
    word RD_TO1      :1;                                       /* Read timeout Bit 1 */
    word RD_TO2      :1;                                       /* Read timeout Bit 2 */
    word RD_TO3      :1;                                       /* Read timeout Bit 3 */
    word RD_TO4      :1;                                       /* Read timeout Bit 4 */
    word RD_TO5      :1;                                       /* Read timeout Bit 5 */
    word RD_TO6      :1;                                       /* Read timeout Bit 6 */
    word RD_TO7      :1;                                       /* Read timeout Bit 7 */
    word RD_TO8      :1;                                       /* Read timeout Bit 8 */
    word RD_TO9      :1;                                       /* Read timeout Bit 9 */
    word RD_TO10     :1;                                       /* Read timeout Bit 10 */
    word RD_TO11     :1;                                       /* Read timeout Bit 11 */
    word RD_TO12     :1;                                       /* Read timeout Bit 12 */
    word RD_TO13     :1;                                       /* Read timeout Bit 13 */
    word RD_TO14     :1;                                       /* Read timeout Bit 14 */
    word RD_TO15     :1;                                       /* Read timeout Bit 15 */
  } Bits;
} SDRDTOUTSTR;
extern volatile SDRDTOUTSTR _SDRDTOUT @(REG_BASE + 0x000002CAUL);
#define SDRDTOUT                        _SDRDTOUT.Word
#define SDRDTOUT_RD_TO0                 _SDRDTOUT.Bits.RD_TO0
#define SDRDTOUT_RD_TO1                 _SDRDTOUT.Bits.RD_TO1
#define SDRDTOUT_RD_TO2                 _SDRDTOUT.Bits.RD_TO2
#define SDRDTOUT_RD_TO3                 _SDRDTOUT.Bits.RD_TO3
#define SDRDTOUT_RD_TO4                 _SDRDTOUT.Bits.RD_TO4
#define SDRDTOUT_RD_TO5                 _SDRDTOUT.Bits.RD_TO5
#define SDRDTOUT_RD_TO6                 _SDRDTOUT.Bits.RD_TO6
#define SDRDTOUT_RD_TO7                 _SDRDTOUT.Bits.RD_TO7
#define SDRDTOUT_RD_TO8                 _SDRDTOUT.Bits.RD_TO8
#define SDRDTOUT_RD_TO9                 _SDRDTOUT.Bits.RD_TO9
#define SDRDTOUT_RD_TO10                _SDRDTOUT.Bits.RD_TO10
#define SDRDTOUT_RD_TO11                _SDRDTOUT.Bits.RD_TO11
#define SDRDTOUT_RD_TO12                _SDRDTOUT.Bits.RD_TO12
#define SDRDTOUT_RD_TO13                _SDRDTOUT.Bits.RD_TO13
#define SDRDTOUT_RD_TO14                _SDRDTOUT.Bits.RD_TO14
#define SDRDTOUT_RD_TO15                _SDRDTOUT.Bits.RD_TO15

#define SDRDTOUT_RD_TO0_MASK            1U
#define SDRDTOUT_RD_TO1_MASK            2U
#define SDRDTOUT_RD_TO2_MASK            4U
#define SDRDTOUT_RD_TO3_MASK            8U
#define SDRDTOUT_RD_TO4_MASK            16U
#define SDRDTOUT_RD_TO5_MASK            32U
#define SDRDTOUT_RD_TO6_MASK            64U
#define SDRDTOUT_RD_TO7_MASK            128U
#define SDRDTOUT_RD_TO8_MASK            256U
#define SDRDTOUT_RD_TO9_MASK            512U
#define SDRDTOUT_RD_TO10_MASK           1024U
#define SDRDTOUT_RD_TO11_MASK           2048U
#define SDRDTOUT_RD_TO12_MASK           4096U
#define SDRDTOUT_RD_TO13_MASK           8192U
#define SDRDTOUT_RD_TO14_MASK           16384U
#define SDRDTOUT_RD_TO15_MASK           32768U


/*** SDBLKLN - Block Length Register; 0x000002CC ***/
typedef union {
  word Word;
  struct {
    word BLEN0       :1;                                       /* Block length Bit 0 */
    word BLEN1       :1;                                       /* Block length Bit 1 */
    word BLEN2       :1;                                       /* Block length Bit 2 */
    word BLEN3       :1;                                       /* Block length Bit 3 */
    word BLEN4       :1;                                       /* Block length Bit 4 */
    word BLEN5       :1;                                       /* Block length Bit 5 */
    word BLEN6       :1;                                       /* Block length Bit 6 */
    word BLEN7       :1;                                       /* Block length Bit 7 */
    word BLEN8       :1;                                       /* Block length Bit 8 */
    word BLEN9       :1;                                       /* Block length Bit 9 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
  struct {
    word grpBLEN :10;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} SDBLKLNSTR;
extern volatile SDBLKLNSTR _SDBLKLN @(REG_BASE + 0x000002CCUL);
#define SDBLKLN                         _SDBLKLN.Word
#define SDBLKLN_BLEN0                   _SDBLKLN.Bits.BLEN0
#define SDBLKLN_BLEN1                   _SDBLKLN.Bits.BLEN1
#define SDBLKLN_BLEN2                   _SDBLKLN.Bits.BLEN2
#define SDBLKLN_BLEN3                   _SDBLKLN.Bits.BLEN3
#define SDBLKLN_BLEN4                   _SDBLKLN.Bits.BLEN4
#define SDBLKLN_BLEN5                   _SDBLKLN.Bits.BLEN5
#define SDBLKLN_BLEN6                   _SDBLKLN.Bits.BLEN6
#define SDBLKLN_BLEN7                   _SDBLKLN.Bits.BLEN7
#define SDBLKLN_BLEN8                   _SDBLKLN.Bits.BLEN8
#define SDBLKLN_BLEN9                   _SDBLKLN.Bits.BLEN9
#define SDBLKLN_BLEN                    _SDBLKLN.MergedBits.grpBLEN

#define SDBLKLN_BLEN0_MASK              1U
#define SDBLKLN_BLEN1_MASK              2U
#define SDBLKLN_BLEN2_MASK              4U
#define SDBLKLN_BLEN3_MASK              8U
#define SDBLKLN_BLEN4_MASK              16U
#define SDBLKLN_BLEN5_MASK              32U
#define SDBLKLN_BLEN6_MASK              64U
#define SDBLKLN_BLEN7_MASK              128U
#define SDBLKLN_BLEN8_MASK              256U
#define SDBLKLN_BLEN9_MASK              512U
#define SDBLKLN_BLEN_MASK               1023U
#define SDBLKLN_BLEN_BITNUM             0U


/*** SDNOBLK - Number of Blocks Register; 0x000002CE ***/
typedef union {
  word Word;
  struct {
    word NOB0        :1;                                       /* Number of blocks Bit 0 */
    word NOB1        :1;                                       /* Number of blocks Bit 1 */
    word NOB2        :1;                                       /* Number of blocks Bit 2 */
    word NOB3        :1;                                       /* Number of blocks Bit 3 */
    word NOB4        :1;                                       /* Number of blocks Bit 4 */
    word NOB5        :1;                                       /* Number of blocks Bit 5 */
    word NOB6        :1;                                       /* Number of blocks Bit 6 */
    word NOB7        :1;                                       /* Number of blocks Bit 7 */
    word NOB8        :1;                                       /* Number of blocks Bit 8 */
    word NOB9        :1;                                       /* Number of blocks Bit 9 */
    word NOB10       :1;                                       /* Number of blocks Bit 10 */
    word NOB11       :1;                                       /* Number of blocks Bit 11 */
    word NOB12       :1;                                       /* Number of blocks Bit 12 */
    word NOB13       :1;                                       /* Number of blocks Bit 13 */
    word NOB14       :1;                                       /* Number of blocks Bit 14 */
    word NOB15       :1;                                       /* Number of blocks Bit 15 */
  } Bits;
} SDNOBLKSTR;
extern volatile SDNOBLKSTR _SDNOBLK @(REG_BASE + 0x000002CEUL);
#define SDNOBLK                         _SDNOBLK.Word
#define SDNOBLK_NOB0                    _SDNOBLK.Bits.NOB0
#define SDNOBLK_NOB1                    _SDNOBLK.Bits.NOB1
#define SDNOBLK_NOB2                    _SDNOBLK.Bits.NOB2
#define SDNOBLK_NOB3                    _SDNOBLK.Bits.NOB3
#define SDNOBLK_NOB4                    _SDNOBLK.Bits.NOB4
#define SDNOBLK_NOB5                    _SDNOBLK.Bits.NOB5
#define SDNOBLK_NOB6                    _SDNOBLK.Bits.NOB6
#define SDNOBLK_NOB7                    _SDNOBLK.Bits.NOB7
#define SDNOBLK_NOB8                    _SDNOBLK.Bits.NOB8
#define SDNOBLK_NOB9                    _SDNOBLK.Bits.NOB9
#define SDNOBLK_NOB10                   _SDNOBLK.Bits.NOB10
#define SDNOBLK_NOB11                   _SDNOBLK.Bits.NOB11
#define SDNOBLK_NOB12                   _SDNOBLK.Bits.NOB12
#define SDNOBLK_NOB13                   _SDNOBLK.Bits.NOB13
#define SDNOBLK_NOB14                   _SDNOBLK.Bits.NOB14
#define SDNOBLK_NOB15                   _SDNOBLK.Bits.NOB15

#define SDNOBLK_NOB0_MASK               1U
#define SDNOBLK_NOB1_MASK               2U
#define SDNOBLK_NOB2_MASK               4U
#define SDNOBLK_NOB3_MASK               8U
#define SDNOBLK_NOB4_MASK               16U
#define SDNOBLK_NOB5_MASK               32U
#define SDNOBLK_NOB6_MASK               64U
#define SDNOBLK_NOB7_MASK               128U
#define SDNOBLK_NOB8_MASK               256U
#define SDNOBLK_NOB9_MASK               512U
#define SDNOBLK_NOB10_MASK              1024U
#define SDNOBLK_NOB11_MASK              2048U
#define SDNOBLK_NOB12_MASK              4096U
#define SDNOBLK_NOB13_MASK              8192U
#define SDNOBLK_NOB14_MASK              16384U
#define SDNOBLK_NOB15_MASK              32768U


/*** SDINTREN - Interrupt Enable Register; 0x000002D0 ***/
typedef union {
  word Word;
  struct {
    word TOIE        :1;                                       /* Timeout interrupt enable */
    word CRCIE       :1;                                       /* CRC error interrupt enable */
    word DTDNIE      :1;                                       /* Data transfer done interrupt enable */
    word WRDNIE      :1;                                       /* Write operation done interrupt enable */
    word ECRIE       :1;                                       /* End command response interrupt enable */
    word CDIE_SDINTREN :1;                                     /* Auto card detect interrupt enable */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} SDINTRENSTR;
extern volatile SDINTRENSTR _SDINTREN @(REG_BASE + 0x000002D0UL);
#define SDINTREN                        _SDINTREN.Word
#define SDINTREN_TOIE                   _SDINTREN.Bits.TOIE
#define SDINTREN_CRCIE                  _SDINTREN.Bits.CRCIE
#define SDINTREN_DTDNIE                 _SDINTREN.Bits.DTDNIE
#define SDINTREN_WRDNIE                 _SDINTREN.Bits.WRDNIE
#define SDINTREN_ECRIE                  _SDINTREN.Bits.ECRIE
#define SDINTREN_CDIE_SDINTREN          _SDINTREN.Bits.CDIE_SDINTREN

#define SDINTREN_TOIE_MASK              1U
#define SDINTREN_CRCIE_MASK             2U
#define SDINTREN_DTDNIE_MASK            4U
#define SDINTREN_WRDNIE_MASK            8U
#define SDINTREN_ECRIE_MASK             16U
#define SDINTREN_CDIE_SDINTREN_MASK     32U


/*** SDCMDNO - Command Register; 0x000002D2 ***/
typedef union {
  word Word;
  struct {
    word CMDNO0      :1;                                       /* Command number Bit 0 */
    word CMDNO1      :1;                                       /* Command number Bit 1 */
    word CMDNO2      :1;                                       /* Command number Bit 2 */
    word CMDNO3      :1;                                       /* Command number Bit 3 */
    word CMDNO4      :1;                                       /* Command number Bit 4 */
    word CMDNO5      :1;                                       /* Command number Bit 5 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
  struct {
    word grpCMDNO :6;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} SDCMDNOSTR;
extern volatile SDCMDNOSTR _SDCMDNO @(REG_BASE + 0x000002D2UL);
#define SDCMDNO                         _SDCMDNO.Word
#define SDCMDNO_CMDNO0                  _SDCMDNO.Bits.CMDNO0
#define SDCMDNO_CMDNO1                  _SDCMDNO.Bits.CMDNO1
#define SDCMDNO_CMDNO2                  _SDCMDNO.Bits.CMDNO2
#define SDCMDNO_CMDNO3                  _SDCMDNO.Bits.CMDNO3
#define SDCMDNO_CMDNO4                  _SDCMDNO.Bits.CMDNO4
#define SDCMDNO_CMDNO5                  _SDCMDNO.Bits.CMDNO5
#define SDCMDNO_CMDNO                   _SDCMDNO.MergedBits.grpCMDNO

#define SDCMDNO_CMDNO0_MASK             1U
#define SDCMDNO_CMDNO1_MASK             2U
#define SDCMDNO_CMDNO2_MASK             4U
#define SDCMDNO_CMDNO3_MASK             8U
#define SDCMDNO_CMDNO4_MASK             16U
#define SDCMDNO_CMDNO5_MASK             32U
#define SDCMDNO_CMDNO_MASK              63U
#define SDCMDNO_CMDNO_BITNUM            0U


/*** SDARGH - Argument High Register; 0x000002D4 ***/
typedef union {
  word Word;
  struct {
    word HARG0       :1;                                       /* High-word argument Bit 0 */
    word HARG1       :1;                                       /* High-word argument Bit 1 */
    word HARG2       :1;                                       /* High-word argument Bit 2 */
    word HARG3       :1;                                       /* High-word argument Bit 3 */
    word HARG4       :1;                                       /* High-word argument Bit 4 */
    word HARG5       :1;                                       /* High-word argument Bit 5 */
    word HARG6       :1;                                       /* High-word argument Bit 6 */
    word HARG7       :1;                                       /* High-word argument Bit 7 */
    word HARG8       :1;                                       /* High-word argument Bit 8 */
    word HARG9       :1;                                       /* High-word argument Bit 9 */
    word HARG10      :1;                                       /* High-word argument Bit 10 */
    word HARG11      :1;                                       /* High-word argument Bit 11 */
    word HARG12      :1;                                       /* High-word argument Bit 12 */
    word HARG13      :1;                                       /* High-word argument Bit 13 */
    word HARG14      :1;                                       /* High-word argument Bit 14 */
    word HARG15      :1;                                       /* High-word argument Bit 15 */
  } Bits;
} SDARGHSTR;
extern volatile SDARGHSTR _SDARGH @(REG_BASE + 0x000002D4UL);
#define SDARGH                          _SDARGH.Word
#define SDARGH_HARG0                    _SDARGH.Bits.HARG0
#define SDARGH_HARG1                    _SDARGH.Bits.HARG1
#define SDARGH_HARG2                    _SDARGH.Bits.HARG2
#define SDARGH_HARG3                    _SDARGH.Bits.HARG3
#define SDARGH_HARG4                    _SDARGH.Bits.HARG4
#define SDARGH_HARG5                    _SDARGH.Bits.HARG5
#define SDARGH_HARG6                    _SDARGH.Bits.HARG6
#define SDARGH_HARG7                    _SDARGH.Bits.HARG7
#define SDARGH_HARG8                    _SDARGH.Bits.HARG8
#define SDARGH_HARG9                    _SDARGH.Bits.HARG9
#define SDARGH_HARG10                   _SDARGH.Bits.HARG10
#define SDARGH_HARG11                   _SDARGH.Bits.HARG11
#define SDARGH_HARG12                   _SDARGH.Bits.HARG12
#define SDARGH_HARG13                   _SDARGH.Bits.HARG13
#define SDARGH_HARG14                   _SDARGH.Bits.HARG14
#define SDARGH_HARG15                   _SDARGH.Bits.HARG15

#define SDARGH_HARG0_MASK               1U
#define SDARGH_HARG1_MASK               2U
#define SDARGH_HARG2_MASK               4U
#define SDARGH_HARG3_MASK               8U
#define SDARGH_HARG4_MASK               16U
#define SDARGH_HARG5_MASK               32U
#define SDARGH_HARG6_MASK               64U
#define SDARGH_HARG7_MASK               128U
#define SDARGH_HARG8_MASK               256U
#define SDARGH_HARG9_MASK               512U
#define SDARGH_HARG10_MASK              1024U
#define SDARGH_HARG11_MASK              2048U
#define SDARGH_HARG12_MASK              4096U
#define SDARGH_HARG13_MASK              8192U
#define SDARGH_HARG14_MASK              16384U
#define SDARGH_HARG15_MASK              32768U


/*** SDARGL - Argument Low Register; 0x000002D6 ***/
typedef union {
  word Word;
  struct {
    word LARG0       :1;                                       /* Low-word argument Bit 0 */
    word LARG1       :1;                                       /* Low-word argument Bit 1 */
    word LARG2       :1;                                       /* Low-word argument Bit 2 */
    word LARG3       :1;                                       /* Low-word argument Bit 3 */
    word LARG4       :1;                                       /* Low-word argument Bit 4 */
    word LARG5       :1;                                       /* Low-word argument Bit 5 */
    word LARG6       :1;                                       /* Low-word argument Bit 6 */
    word LARG7       :1;                                       /* Low-word argument Bit 7 */
    word LARG8       :1;                                       /* Low-word argument Bit 8 */
    word LARG9       :1;                                       /* Low-word argument Bit 9 */
    word LARG10      :1;                                       /* Low-word argument Bit 10 */
    word LARG11      :1;                                       /* Low-word argument Bit 11 */
    word LARG12      :1;                                       /* Low-word argument Bit 12 */
    word LARG13      :1;                                       /* Low-word argument Bit 13 */
    word LARG14      :1;                                       /* Low-word argument Bit 14 */
    word LARG15      :1;                                       /* Low-word argument Bit 15 */
  } Bits;
} SDARGLSTR;
extern volatile SDARGLSTR _SDARGL @(REG_BASE + 0x000002D6UL);
#define SDARGL                          _SDARGL.Word
#define SDARGL_LARG0                    _SDARGL.Bits.LARG0
#define SDARGL_LARG1                    _SDARGL.Bits.LARG1
#define SDARGL_LARG2                    _SDARGL.Bits.LARG2
#define SDARGL_LARG3                    _SDARGL.Bits.LARG3
#define SDARGL_LARG4                    _SDARGL.Bits.LARG4
#define SDARGL_LARG5                    _SDARGL.Bits.LARG5
#define SDARGL_LARG6                    _SDARGL.Bits.LARG6
#define SDARGL_LARG7                    _SDARGL.Bits.LARG7
#define SDARGL_LARG8                    _SDARGL.Bits.LARG8
#define SDARGL_LARG9                    _SDARGL.Bits.LARG9
#define SDARGL_LARG10                   _SDARGL.Bits.LARG10
#define SDARGL_LARG11                   _SDARGL.Bits.LARG11
#define SDARGL_LARG12                   _SDARGL.Bits.LARG12
#define SDARGL_LARG13                   _SDARGL.Bits.LARG13
#define SDARGL_LARG14                   _SDARGL.Bits.LARG14
#define SDARGL_LARG15                   _SDARGL.Bits.LARG15

#define SDARGL_LARG0_MASK               1U
#define SDARGL_LARG1_MASK               2U
#define SDARGL_LARG2_MASK               4U
#define SDARGL_LARG3_MASK               8U
#define SDARGL_LARG4_MASK               16U
#define SDARGL_LARG5_MASK               32U
#define SDARGL_LARG6_MASK               64U
#define SDARGL_LARG7_MASK               128U
#define SDARGL_LARG8_MASK               256U
#define SDARGL_LARG9_MASK               512U
#define SDARGL_LARG10_MASK              1024U
#define SDARGL_LARG11_MASK              2048U
#define SDARGL_LARG12_MASK              4096U
#define SDARGL_LARG13_MASK              8192U
#define SDARGL_LARG14_MASK              16384U
#define SDARGL_LARG15_MASK              32768U


/*** SDRSP - Response Register; 0x000002D8 ***/
typedef union {
  word Word;
  struct {
    word CRSP0       :1;                                       /* SD/MMC card response Bit 0 */
    word CRSP1       :1;                                       /* SD/MMC card response Bit 1 */
    word CRSP2       :1;                                       /* SD/MMC card response Bit 2 */
    word CRSP3       :1;                                       /* SD/MMC card response Bit 3 */
    word CRSP4       :1;                                       /* SD/MMC card response Bit 4 */
    word CRSP5       :1;                                       /* SD/MMC card response Bit 5 */
    word CRSP6       :1;                                       /* SD/MMC card response Bit 6 */
    word CRSP7       :1;                                       /* SD/MMC card response Bit 7 */
    word CRSP8       :1;                                       /* SD/MMC card response Bit 8 */
    word CRSP9       :1;                                       /* SD/MMC card response Bit 9 */
    word CRSP10      :1;                                       /* SD/MMC card response Bit 10 */
    word CRSP11      :1;                                       /* SD/MMC card response Bit 11 */
    word CRSP12      :1;                                       /* SD/MMC card response Bit 12 */
    word CRSP13      :1;                                       /* SD/MMC card response Bit 13 */
    word CRSP14      :1;                                       /* SD/MMC card response Bit 14 */
    word CRSP15      :1;                                       /* SD/MMC card response Bit 15 */
  } Bits;
} SDRSPSTR;
extern volatile SDRSPSTR _SDRSP @(REG_BASE + 0x000002D8UL);
#define SDRSP                           _SDRSP.Word
#define SDRSP_CRSP0                     _SDRSP.Bits.CRSP0
#define SDRSP_CRSP1                     _SDRSP.Bits.CRSP1
#define SDRSP_CRSP2                     _SDRSP.Bits.CRSP2
#define SDRSP_CRSP3                     _SDRSP.Bits.CRSP3
#define SDRSP_CRSP4                     _SDRSP.Bits.CRSP4
#define SDRSP_CRSP5                     _SDRSP.Bits.CRSP5
#define SDRSP_CRSP6                     _SDRSP.Bits.CRSP6
#define SDRSP_CRSP7                     _SDRSP.Bits.CRSP7
#define SDRSP_CRSP8                     _SDRSP.Bits.CRSP8
#define SDRSP_CRSP9                     _SDRSP.Bits.CRSP9
#define SDRSP_CRSP10                    _SDRSP.Bits.CRSP10
#define SDRSP_CRSP11                    _SDRSP.Bits.CRSP11
#define SDRSP_CRSP12                    _SDRSP.Bits.CRSP12
#define SDRSP_CRSP13                    _SDRSP.Bits.CRSP13
#define SDRSP_CRSP14                    _SDRSP.Bits.CRSP14
#define SDRSP_CRSP15                    _SDRSP.Bits.CRSP15

#define SDRSP_CRSP0_MASK                1U
#define SDRSP_CRSP1_MASK                2U
#define SDRSP_CRSP2_MASK                4U
#define SDRSP_CRSP3_MASK                8U
#define SDRSP_CRSP4_MASK                16U
#define SDRSP_CRSP5_MASK                32U
#define SDRSP_CRSP6_MASK                64U
#define SDRSP_CRSP7_MASK                128U
#define SDRSP_CRSP8_MASK                256U
#define SDRSP_CRSP9_MASK                512U
#define SDRSP_CRSP10_MASK               1024U
#define SDRSP_CRSP11_MASK               2048U
#define SDRSP_CRSP12_MASK               4096U
#define SDRSP_CRSP13_MASK               8192U
#define SDRSP_CRSP14_MASK               16384U
#define SDRSP_CRSP15_MASK               32768U


/*** SDATA - SD/MMC Data Register; 0x000002DA ***/
typedef union {
  word Word;
  struct {
    word SDAT0       :1;                                       /* SD/MMC fifo data Bit 0 */
    word SDAT1       :1;                                       /* SD/MMC fifo data Bit 1 */
    word SDAT2       :1;                                       /* SD/MMC fifo data Bit 2 */
    word SDAT3       :1;                                       /* SD/MMC fifo data Bit 3 */
    word SDAT4       :1;                                       /* SD/MMC fifo data Bit 4 */
    word SDAT5       :1;                                       /* SD/MMC fifo data Bit 5 */
    word SDAT6       :1;                                       /* SD/MMC fifo data Bit 6 */
    word SDAT7       :1;                                       /* SD/MMC fifo data Bit 7 */
    word SDAT8       :1;                                       /* SD/MMC fifo data Bit 8 */
    word SDAT9       :1;                                       /* SD/MMC fifo data Bit 9 */
    word SDAT10      :1;                                       /* SD/MMC fifo data Bit 10 */
    word SDAT11      :1;                                       /* SD/MMC fifo data Bit 11 */
    word SDAT12      :1;                                       /* SD/MMC fifo data Bit 12 */
    word SDAT13      :1;                                       /* SD/MMC fifo data Bit 13 */
    word SDAT14      :1;                                       /* SD/MMC fifo data Bit 14 */
    word SDAT15      :1;                                       /* SD/MMC fifo data Bit 15 */
  } Bits;
} SDATASTR;
extern volatile SDATASTR _SDATA @(REG_BASE + 0x000002DAUL);
#define SDATA                           _SDATA.Word
#define SDATA_SDAT0                     _SDATA.Bits.SDAT0
#define SDATA_SDAT1                     _SDATA.Bits.SDAT1
#define SDATA_SDAT2                     _SDATA.Bits.SDAT2
#define SDATA_SDAT3                     _SDATA.Bits.SDAT3
#define SDATA_SDAT4                     _SDATA.Bits.SDAT4
#define SDATA_SDAT5                     _SDATA.Bits.SDAT5
#define SDATA_SDAT6                     _SDATA.Bits.SDAT6
#define SDATA_SDAT7                     _SDATA.Bits.SDAT7
#define SDATA_SDAT8                     _SDATA.Bits.SDAT8
#define SDATA_SDAT9                     _SDATA.Bits.SDAT9
#define SDATA_SDAT10                    _SDATA.Bits.SDAT10
#define SDATA_SDAT11                    _SDATA.Bits.SDAT11
#define SDATA_SDAT12                    _SDATA.Bits.SDAT12
#define SDATA_SDAT13                    _SDATA.Bits.SDAT13
#define SDATA_SDAT14                    _SDATA.Bits.SDAT14
#define SDATA_SDAT15                    _SDATA.Bits.SDAT15

#define SDATA_SDAT0_MASK                1U
#define SDATA_SDAT1_MASK                2U
#define SDATA_SDAT2_MASK                4U
#define SDATA_SDAT3_MASK                8U
#define SDATA_SDAT4_MASK                16U
#define SDATA_SDAT5_MASK                32U
#define SDATA_SDAT6_MASK                64U
#define SDATA_SDAT7_MASK                128U
#define SDATA_SDAT8_MASK                256U
#define SDATA_SDAT9_MASK                512U
#define SDATA_SDAT10_MASK               1024U
#define SDATA_SDAT11_MASK               2048U
#define SDATA_SDAT12_MASK               4096U
#define SDATA_SDAT13_MASK               8192U
#define SDATA_SDAT14_MASK               16384U
#define SDATA_SDAT15_MASK               32768U


/*** UMCR - USB20 Module Control Register; 0x00000300 ***/
typedef union {
  word Word;
  struct {
    word SCSUP       :1;                                       /* Synch Frame command Support */
    word SPWR        :1;                                       /* Self Powered */
    word PWUC        :1;                                       /* Remote Wakeup Capable */
    word EXSPD       :1;                                       /* Expected Speed */
    word SDSUP       :1;                                       /* Set Descriptor Command Support */
    word DISCON      :1;                                       /* Device Disconnect */
    word             :1; 
    word             :1; 
    word             :1; 
    word EPRST       :1;                                       /* Endpoint Reset */
    word PHYRST      :1;                                       /* Physical Layer Reset */
    word SPHY        :1;                                       /* Suspend PHY */
    word RESUME      :1;                                       /* Remote Wakeup Indication */
    word MRST        :1;                                       /* Module Reset */
    word MCE         :1;                                       /* Module Clock Enable */
    word MEM         :1;                                       /* Module Enable */
  } Bits;
} UMCRSTR;
extern volatile UMCRSTR _UMCR @(REG_BASE + 0x00000300UL);
#define UMCR                            _UMCR.Word
#define UMCR_SCSUP                      _UMCR.Bits.SCSUP
#define UMCR_SPWR                       _UMCR.Bits.SPWR
#define UMCR_PWUC                       _UMCR.Bits.PWUC
#define UMCR_EXSPD                      _UMCR.Bits.EXSPD
#define UMCR_SDSUP                      _UMCR.Bits.SDSUP
#define UMCR_DISCON                     _UMCR.Bits.DISCON
#define UMCR_EPRST                      _UMCR.Bits.EPRST
#define UMCR_PHYRST                     _UMCR.Bits.PHYRST
#define UMCR_SPHY                       _UMCR.Bits.SPHY
#define UMCR_RESUME                     _UMCR.Bits.RESUME
#define UMCR_MRST                       _UMCR.Bits.MRST
#define UMCR_MCE                        _UMCR.Bits.MCE
#define UMCR_MEM                        _UMCR.Bits.MEM

#define UMCR_SCSUP_MASK                 1U
#define UMCR_SPWR_MASK                  2U
#define UMCR_PWUC_MASK                  4U
#define UMCR_EXSPD_MASK                 8U
#define UMCR_SDSUP_MASK                 16U
#define UMCR_DISCON_MASK                32U
#define UMCR_EPRST_MASK                 512U
#define UMCR_PHYRST_MASK                1024U
#define UMCR_SPHY_MASK                  2048U
#define UMCR_RESUME_MASK                4096U
#define UMCR_MRST_MASK                  8192U
#define UMCR_MCE_MASK                   16384U
#define UMCR_MEM_MASK                   32768U


/*** UMSR1 - USB20 Module Status Register 1; 0x00000302 ***/
typedef union {
  word Word;
  struct {
    word SETUP       :1;                                       /* USB Setup Command Detected */
    word SETOVR      :1;                                       /* USB Setup Command Overrun */
    word SOF         :1;                                       /* Start of Frame */
    word URD         :1;                                       /* USB Reset Detected */
    word USD         :1;                                       /* USB Suspend Detected */
    word             :1; 
    word SPD         :1;                                       /* Set Endpoint Configuration Request */
    word             :1; 
    word             :1; 
    word             :1; 
    word ENUMD       :1;                                       /* Enumeration Done */
    word URSC        :1;                                       /* USB20 Reset Status Change */
    word USSC        :1;                                       /* USB20 Suspend Status Change */
    word ACTEP0      :1;                                       /* bit 0 of Active Endpoint */
    word ACTEP1      :1;                                       /* bit 1 of Active Endpoint */
    word ACTEP2      :1;                                       /* bit 2 of Active Endpoint */
  } Bits;
  struct {
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpACTEP :3;
  } MergedBits;
} UMSR1STR;
extern volatile UMSR1STR _UMSR1 @(REG_BASE + 0x00000302UL);
#define UMSR1                           _UMSR1.Word
#define UMSR1_SETUP                     _UMSR1.Bits.SETUP
#define UMSR1_SETOVR                    _UMSR1.Bits.SETOVR
#define UMSR1_SOF                       _UMSR1.Bits.SOF
#define UMSR1_URD                       _UMSR1.Bits.URD
#define UMSR1_USD                       _UMSR1.Bits.USD
#define UMSR1_SPD                       _UMSR1.Bits.SPD
#define UMSR1_ENUMD                     _UMSR1.Bits.ENUMD
#define UMSR1_URSC                      _UMSR1.Bits.URSC
#define UMSR1_USSC                      _UMSR1.Bits.USSC
#define UMSR1_ACTEP0                    _UMSR1.Bits.ACTEP0
#define UMSR1_ACTEP1                    _UMSR1.Bits.ACTEP1
#define UMSR1_ACTEP2                    _UMSR1.Bits.ACTEP2
#define UMSR1_ACTEP                     _UMSR1.MergedBits.grpACTEP

#define UMSR1_SETUP_MASK                1U
#define UMSR1_SETOVR_MASK               2U
#define UMSR1_SOF_MASK                  4U
#define UMSR1_URD_MASK                  8U
#define UMSR1_USD_MASK                  16U
#define UMSR1_SPD_MASK                  64U
#define UMSR1_ENUMD_MASK                1024U
#define UMSR1_URSC_MASK                 2048U
#define UMSR1_USSC_MASK                 4096U
#define UMSR1_ACTEP0_MASK               8192U
#define UMSR1_ACTEP1_MASK               16384U
#define UMSR1_ACTEP2_MASK               32768U
#define UMSR1_ACTEP_MASK                57344U
#define UMSR1_ACTEP_BITNUM              13U


/*** UIMR - USB20 Interrupt Mask Register; 0x00000304 ***/
typedef union {
  word Word;
  struct {
    word SETUPIE     :1;                                       /* Setup Command Interrupt Enable */
    word SETOVFIE    :1;                                       /* Setup Command Overrun Interrupt Enable */
    word SOFIE       :1;                                       /* Start of Frame Inter rupt Enable */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word URSCIE      :1;                                       /* USB20 Reset Status Change Interrupt Enable */
    word USSCIE      :1;                                       /* USB20 Suspend Status Change Interrupt Enable */
    word SETECRIE    :1;                                       /* Set Endpoint Configuration Request Interrupt Enable */
    word RESUMEIE    :1;                                       /* Resume Interrupt Enable */
    word             :1; 
  } Bits;
} UIMRSTR;
extern volatile UIMRSTR _UIMR @(REG_BASE + 0x00000304UL);
#define UIMR                            _UIMR.Word
#define UIMR_SETUPIE                    _UIMR.Bits.SETUPIE
#define UIMR_SETOVFIE                   _UIMR.Bits.SETOVFIE
#define UIMR_SOFIE                      _UIMR.Bits.SOFIE
#define UIMR_URSCIE                     _UIMR.Bits.URSCIE
#define UIMR_USSCIE                     _UIMR.Bits.USSCIE
#define UIMR_SETECRIE                   _UIMR.Bits.SETECRIE
#define UIMR_RESUMEIE                   _UIMR.Bits.RESUMEIE

#define UIMR_SETUPIE_MASK               1U
#define UIMR_SETOVFIE_MASK              2U
#define UIMR_SOFIE_MASK                 4U
#define UIMR_URSCIE_MASK                2048U
#define UIMR_USSCIE_MASK                4096U
#define UIMR_SETECRIE_MASK              8192U
#define UIMR_RESUMEIE_MASK              16384U


/*** UTR - USB20 Test Register; 0x00000308 ***/
typedef union {
  word Word;
  struct {
    word TMS0        :1;                                       /* Test mode enable Bit 0 */
    word TMS1        :1;                                       /* Test mode enable Bit 1 */
    word             :1; 
    word USD_UTR     :1;                                       /* UDC Scale Down */
    word TME         :1;                                       /* Test mode select */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
  struct {
    word grpTMS  :2;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} UTRSTR;
extern volatile UTRSTR _UTR @(REG_BASE + 0x00000308UL);
#define UTR                             _UTR.Word
#define UTR_TMS0                        _UTR.Bits.TMS0
#define UTR_TMS1                        _UTR.Bits.TMS1
#define UTR_USD_UTR                     _UTR.Bits.USD_UTR
#define UTR_TME                         _UTR.Bits.TME
#define UTR_TMS                         _UTR.MergedBits.grpTMS

#define UTR_TMS0_MASK                   1U
#define UTR_TMS1_MASK                   2U
#define UTR_USD_UTR_MASK                8U
#define UTR_TME_MASK                    16U
#define UTR_TMS_MASK                    3U
#define UTR_TMS_BITNUM                  0U


/*** UTSR - USB20 Timestamp Register; 0x0000030A ***/
typedef union {
  word Word;
  struct {
    word TIMEST0     :1;                                       /* Start of Frame SOF frame number Bit 0 */
    word TIMEST1     :1;                                       /* Start of Frame SOF frame number Bit 1 */
    word TIMEST2     :1;                                       /* Start of Frame SOF frame number Bit 2 */
    word TIMEST3     :1;                                       /* Start of Frame SOF frame number Bit 3 */
    word TIMEST4     :1;                                       /* Start of Frame SOF frame number Bit 4 */
    word TIMEST5     :1;                                       /* Start of Frame SOF frame number Bit 5 */
    word TIMEST6     :1;                                       /* Start of Frame SOF frame number Bit 6 */
    word TIMEST7     :1;                                       /* Start of Frame SOF frame number Bit 7 */
    word TIMEST8     :1;                                       /* Start of Frame SOF frame number Bit 8 */
    word TIMEST9     :1;                                       /* Start of Frame SOF frame number Bit 9 */
    word TIMEST10    :1;                                       /* Start of Frame SOF frame number Bit 10 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
  struct {
    word grpTIMEST :11;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} UTSRSTR;
extern volatile UTSRSTR _UTSR @(REG_BASE + 0x0000030AUL);
#define UTSR                            _UTSR.Word
#define UTSR_TIMEST0                    _UTSR.Bits.TIMEST0
#define UTSR_TIMEST1                    _UTSR.Bits.TIMEST1
#define UTSR_TIMEST2                    _UTSR.Bits.TIMEST2
#define UTSR_TIMEST3                    _UTSR.Bits.TIMEST3
#define UTSR_TIMEST4                    _UTSR.Bits.TIMEST4
#define UTSR_TIMEST5                    _UTSR.Bits.TIMEST5
#define UTSR_TIMEST6                    _UTSR.Bits.TIMEST6
#define UTSR_TIMEST7                    _UTSR.Bits.TIMEST7
#define UTSR_TIMEST8                    _UTSR.Bits.TIMEST8
#define UTSR_TIMEST9                    _UTSR.Bits.TIMEST9
#define UTSR_TIMEST10                   _UTSR.Bits.TIMEST10
#define UTSR_TIMEST                     _UTSR.MergedBits.grpTIMEST

#define UTSR_TIMEST0_MASK               1U
#define UTSR_TIMEST1_MASK               2U
#define UTSR_TIMEST2_MASK               4U
#define UTSR_TIMEST3_MASK               8U
#define UTSR_TIMEST4_MASK               16U
#define UTSR_TIMEST5_MASK               32U
#define UTSR_TIMEST6_MASK               64U
#define UTSR_TIMEST7_MASK               128U
#define UTSR_TIMEST8_MASK               256U
#define UTSR_TIMEST9_MASK               512U
#define UTSR_TIMEST10_MASK              1024U
#define UTSR_TIMEST_MASK                2047U
#define UTSR_TIMEST_BITNUM              0U


/*** UCCSR - USB20 Configuration Control Status Register; 0x0000030C ***/
typedef union {
  word Word;
  struct {
    word ALTINTF0    :1;                                       /* Current Alternate Setting Bit 0 */
    word ALTINTF1    :1;                                       /* Current Alternate Setting Bit 1 */
    word ALTINTF2    :1;                                       /* Current Alternate Setting Bit 2 */
    word ALTINTF3    :1;                                       /* Current Alternate Setting Bit 3 */
    word INTF0       :1;                                       /* Current Interface Bit 0 */
    word INTF1       :1;                                       /* Current Interface Bit 1 */
    word INTF2       :1;                                       /* Current Interface Bit 2 */
    word INTF3       :1;                                       /* Current Interface Bit 3 */
    word CFG0        :1;                                       /* Current Configuration Bit 0 */
    word CFG1        :1;                                       /* Current Configuration Bit 1 */
    word CFG2        :1;                                       /* Current Configuration Bit 2 */
    word CFG3        :1;                                       /* Current Configuration Bit 3 */
    word DONEECRU    :1;                                       /* Done Endpoint Configuration Update */
    word SETECR      :1;                                       /* Set Endpoint Configuration Request */
    word INTFVALID   :1;                                       /* Interface/Alternate Setting Valid */
    word CFGVALID    :1;                                       /* configuration valid */
  } Bits;
  struct {
    word grpALTINTF :4;
    word grpINTF :4;
    word grpCFG  :4;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} UCCSRSTR;
extern volatile UCCSRSTR _UCCSR @(REG_BASE + 0x0000030CUL);
#define UCCSR                           _UCCSR.Word
#define UCCSR_ALTINTF0                  _UCCSR.Bits.ALTINTF0
#define UCCSR_ALTINTF1                  _UCCSR.Bits.ALTINTF1
#define UCCSR_ALTINTF2                  _UCCSR.Bits.ALTINTF2
#define UCCSR_ALTINTF3                  _UCCSR.Bits.ALTINTF3
#define UCCSR_INTF0                     _UCCSR.Bits.INTF0
#define UCCSR_INTF1                     _UCCSR.Bits.INTF1
#define UCCSR_INTF2                     _UCCSR.Bits.INTF2
#define UCCSR_INTF3                     _UCCSR.Bits.INTF3
#define UCCSR_CFG0                      _UCCSR.Bits.CFG0
#define UCCSR_CFG1                      _UCCSR.Bits.CFG1
#define UCCSR_CFG2                      _UCCSR.Bits.CFG2
#define UCCSR_CFG3                      _UCCSR.Bits.CFG3
#define UCCSR_DONEECRU                  _UCCSR.Bits.DONEECRU
#define UCCSR_SETECR                    _UCCSR.Bits.SETECR
#define UCCSR_INTFVALID                 _UCCSR.Bits.INTFVALID
#define UCCSR_CFGVALID                  _UCCSR.Bits.CFGVALID
#define UCCSR_ALTINTF                   _UCCSR.MergedBits.grpALTINTF
#define UCCSR_INTF                      _UCCSR.MergedBits.grpINTF
#define UCCSR_CFG                       _UCCSR.MergedBits.grpCFG

#define UCCSR_ALTINTF0_MASK             1U
#define UCCSR_ALTINTF1_MASK             2U
#define UCCSR_ALTINTF2_MASK             4U
#define UCCSR_ALTINTF3_MASK             8U
#define UCCSR_INTF0_MASK                16U
#define UCCSR_INTF1_MASK                32U
#define UCCSR_INTF2_MASK                64U
#define UCCSR_INTF3_MASK                128U
#define UCCSR_CFG0_MASK                 256U
#define UCCSR_CFG1_MASK                 512U
#define UCCSR_CFG2_MASK                 1024U
#define UCCSR_CFG3_MASK                 2048U
#define UCCSR_DONEECRU_MASK             4096U
#define UCCSR_SETECR_MASK               8192U
#define UCCSR_INTFVALID_MASK            16384U
#define UCCSR_CFGVALID_MASK             32768U
#define UCCSR_ALTINTF_MASK              15U
#define UCCSR_ALTINTF_BITNUM            0U
#define UCCSR_INTF_MASK                 240U
#define UCCSR_INTF_BITNUM               4U
#define UCCSR_CFG_MASK                  3840U
#define UCCSR_CFG_BITNUM                8U


/*** UEPCSELR - USB20 Endpoint and Configuration Select Register; 0x0000030E ***/
typedef union {
  word Word;
  struct {
    word EPBSEL00    :1;                                       /* Endpoint Buffer Select 0 Bit 0 */
    word EPBSEL01    :1;                                       /* Endpoint Buffer Select 0 Bit 1 */
    word EPBSEL02    :1;                                       /* Endpoint Buffer Select 0 Bit 2 */
    word             :1; 
    word EPBSEL10    :1;                                       /* Endpoint Buffer Select 1 Bit 0 */
    word EPBSEL11    :1;                                       /* Endpoint Buffer Select 1 Bit 1 */
    word EPBSEL12    :1;                                       /* Endpoint Buffer Select 1 Bit 2 */
    word             :1; 
    word UCRSEL0     :1;                                       /* USB20 Configuration Register Select Bit 0 */
    word UCRSEL1     :1;                                       /* USB20 Configuration Register Select Bit 1 */
    word UCRSEL2     :1;                                       /* USB20 Configuration Register Select Bit 2 */
    word UCRSEL3     :1;                                       /* USB20 Configuration Register Select Bit 3 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
  struct {
    word grpEPBSEL0 :3;
    word         :1;
    word grpEPBSEL_10 :3;
    word         :1;
    word grpUCRSEL :4;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} UEPCSELRSTR;
extern volatile UEPCSELRSTR _UEPCSELR @(REG_BASE + 0x0000030EUL);
#define UEPCSELR                        _UEPCSELR.Word
#define UEPCSELR_EPBSEL00               _UEPCSELR.Bits.EPBSEL00
#define UEPCSELR_EPBSEL01               _UEPCSELR.Bits.EPBSEL01
#define UEPCSELR_EPBSEL02               _UEPCSELR.Bits.EPBSEL02
#define UEPCSELR_EPBSEL10               _UEPCSELR.Bits.EPBSEL10
#define UEPCSELR_EPBSEL11               _UEPCSELR.Bits.EPBSEL11
#define UEPCSELR_EPBSEL12               _UEPCSELR.Bits.EPBSEL12
#define UEPCSELR_UCRSEL0                _UEPCSELR.Bits.UCRSEL0
#define UEPCSELR_UCRSEL1                _UEPCSELR.Bits.UCRSEL1
#define UEPCSELR_UCRSEL2                _UEPCSELR.Bits.UCRSEL2
#define UEPCSELR_UCRSEL3                _UEPCSELR.Bits.UCRSEL3
#define UEPCSELR_EPBSEL0                _UEPCSELR.MergedBits.grpEPBSEL0
#define UEPCSELR_EPBSEL_10              _UEPCSELR.MergedBits.grpEPBSEL_10
#define UEPCSELR_UCRSEL                 _UEPCSELR.MergedBits.grpUCRSEL
#define UEPCSELR_EPBSEL                 UEPCSELR_EPBSEL_10

#define UEPCSELR_EPBSEL00_MASK          1U
#define UEPCSELR_EPBSEL01_MASK          2U
#define UEPCSELR_EPBSEL02_MASK          4U
#define UEPCSELR_EPBSEL10_MASK          16U
#define UEPCSELR_EPBSEL11_MASK          32U
#define UEPCSELR_EPBSEL12_MASK          64U
#define UEPCSELR_UCRSEL0_MASK           256U
#define UEPCSELR_UCRSEL1_MASK           512U
#define UEPCSELR_UCRSEL2_MASK           1024U
#define UEPCSELR_UCRSEL3_MASK           2048U
#define UEPCSELR_EPBSEL0_MASK           7U
#define UEPCSELR_EPBSEL0_BITNUM         0U
#define UEPCSELR_EPBSEL_10_MASK         112U
#define UEPCSELR_EPBSEL_10_BITNUM       4U
#define UEPCSELR_UCRSEL_MASK            3840U
#define UEPCSELR_UCRSEL_BITNUM          8U


/*** UUCFGR - UDC Configuration Register (UPECFGRn, UNCIR, UNASR); 0x00000310 ***/
typedef union {
  dword Dword;
} UUCFGRSTR;
extern volatile UUCFGRSTR _UUCFGR @(REG_BASE + 0x00000310UL);
#define UUCFGR                          _UUCFGR.Dword


/*** UEPCSR0 - USB20 Endpoint Control Status Register 0; 0x00000314 ***/
typedef union {
  word Word;
  struct {
    word TXSIZ0      :1;                                       /* Transmit data size Bit 0 */
    word TXSIZ1      :1;                                       /* Transmit data size Bit 1 */
    word TXSIZ2      :1;                                       /* Transmit data size Bit 2 */
    word TXSIZ3      :1;                                       /* Transmit data size Bit 3 */
    word TXSIZ4      :1;                                       /* Transmit data size Bit 4 */
    word TXSIZ5      :1;                                       /* Transmit data size Bit 5 */
    word TXSIZ6      :1;                                       /* Transmit data size Bit 6 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word TCIE0       :1;                                       /* Transfer complete interrupt enable */
    word TFRC0       :1;                                       /* Transfer Completed */
    word DVALID0     :1;                                       /* Data Valid */
    word STALL0      :1;                                       /* Stall */
  } Bits;
  struct {
    word grpTXSIZ :7;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpTCIE :1;
    word grpTFRC :1;
    word grpDVALID :1;
    word grpSTALL :1;
  } MergedBits;
} UEPCSR0STR;
extern volatile UEPCSR0STR _UEPCSR0 @(REG_BASE + 0x00000314UL);
#define UEPCSR0                         _UEPCSR0.Word
#define UEPCSR0_TXSIZ0                  _UEPCSR0.Bits.TXSIZ0
#define UEPCSR0_TXSIZ1                  _UEPCSR0.Bits.TXSIZ1
#define UEPCSR0_TXSIZ2                  _UEPCSR0.Bits.TXSIZ2
#define UEPCSR0_TXSIZ3                  _UEPCSR0.Bits.TXSIZ3
#define UEPCSR0_TXSIZ4                  _UEPCSR0.Bits.TXSIZ4
#define UEPCSR0_TXSIZ5                  _UEPCSR0.Bits.TXSIZ5
#define UEPCSR0_TXSIZ6                  _UEPCSR0.Bits.TXSIZ6
#define UEPCSR0_TCIE0                   _UEPCSR0.Bits.TCIE0
#define UEPCSR0_TFRC0                   _UEPCSR0.Bits.TFRC0
#define UEPCSR0_DVALID0                 _UEPCSR0.Bits.DVALID0
#define UEPCSR0_STALL0                  _UEPCSR0.Bits.STALL0
/* UEPCSR_ARR: Access 4 UEPCSRx registers in an array */
#define UEPCSR_ARR                      ((volatile word *) &UEPCSR0)
#define UEPCSR0_TXSIZ                   _UEPCSR0.MergedBits.grpTXSIZ

#define UEPCSR0_TXSIZ0_MASK             1U
#define UEPCSR0_TXSIZ1_MASK             2U
#define UEPCSR0_TXSIZ2_MASK             4U
#define UEPCSR0_TXSIZ3_MASK             8U
#define UEPCSR0_TXSIZ4_MASK             16U
#define UEPCSR0_TXSIZ5_MASK             32U
#define UEPCSR0_TXSIZ6_MASK             64U
#define UEPCSR0_TCIE0_MASK              4096U
#define UEPCSR0_TFRC0_MASK              8192U
#define UEPCSR0_DVALID0_MASK            16384U
#define UEPCSR0_STALL0_MASK             32768U
#define UEPCSR0_TXSIZ_MASK              127U
#define UEPCSR0_TXSIZ_BITNUM            0U


/*** UEPCSR1 - USB20 Endpoint Control Status Register 1; 0x00000316 ***/
typedef union {
  word Word;
  struct {
    word RXSIZ10     :1;                                       /* Receive data size Bit 0 */
    word RXSIZ11     :1;                                       /* Receive data size Bit 1 */
    word RXSIZ12     :1;                                       /* Receive data size Bit 2 */
    word RXSIZ13     :1;                                       /* Receive data size Bit 3 */
    word RXSIZ14     :1;                                       /* Receive data size Bit 4 */
    word RXSIZ15     :1;                                       /* Receive data size Bit 5 */
    word RXSIZ16     :1;                                       /* Receive data size Bit 6 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word TCIE1       :1;                                       /* Transfer complete interrupt enable */
    word TFRC1       :1;                                       /* Transfer Completed */
    word DVALID1     :1;                                       /* Data Valid */
    word STALL1      :1;                                       /* Stall */
  } Bits;
  struct {
    word grpRXSIZ_10 :7;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpTCIE_1 :1;
    word grpTFRC_1 :1;
    word grpDVALID_1 :1;
    word grpSTALL_1 :1;
  } MergedBits;
} UEPCSR1STR;
extern volatile UEPCSR1STR _UEPCSR1 @(REG_BASE + 0x00000316UL);
#define UEPCSR1                         _UEPCSR1.Word
#define UEPCSR1_RXSIZ10                 _UEPCSR1.Bits.RXSIZ10
#define UEPCSR1_RXSIZ11                 _UEPCSR1.Bits.RXSIZ11
#define UEPCSR1_RXSIZ12                 _UEPCSR1.Bits.RXSIZ12
#define UEPCSR1_RXSIZ13                 _UEPCSR1.Bits.RXSIZ13
#define UEPCSR1_RXSIZ14                 _UEPCSR1.Bits.RXSIZ14
#define UEPCSR1_RXSIZ15                 _UEPCSR1.Bits.RXSIZ15
#define UEPCSR1_RXSIZ16                 _UEPCSR1.Bits.RXSIZ16
#define UEPCSR1_TCIE1                   _UEPCSR1.Bits.TCIE1
#define UEPCSR1_TFRC1                   _UEPCSR1.Bits.TFRC1
#define UEPCSR1_DVALID1                 _UEPCSR1.Bits.DVALID1
#define UEPCSR1_STALL1                  _UEPCSR1.Bits.STALL1
#define UEPCSR1_RXSIZ_10                _UEPCSR1.MergedBits.grpRXSIZ_10
#define UEPCSR1_RXSIZ                   UEPCSR1_RXSIZ_10

#define UEPCSR1_RXSIZ10_MASK            1U
#define UEPCSR1_RXSIZ11_MASK            2U
#define UEPCSR1_RXSIZ12_MASK            4U
#define UEPCSR1_RXSIZ13_MASK            8U
#define UEPCSR1_RXSIZ14_MASK            16U
#define UEPCSR1_RXSIZ15_MASK            32U
#define UEPCSR1_RXSIZ16_MASK            64U
#define UEPCSR1_TCIE1_MASK              4096U
#define UEPCSR1_TFRC1_MASK              8192U
#define UEPCSR1_DVALID1_MASK            16384U
#define UEPCSR1_STALL1_MASK             32768U
#define UEPCSR1_RXSIZ_10_MASK           127U
#define UEPCSR1_RXSIZ_10_BITNUM         0U


/*** UEPCSR2 - USB20 Endpoint Control Status Register 2; 0x00000318 ***/
typedef union {
  word Word;
  struct {
    word RXTXSIZ20   :1;                                       /* Receive and transmit data size Bit 0 */
    word RXTXSIZ21   :1;                                       /* Receive and transmit data size Bit 1 */
    word RXTXSIZ22   :1;                                       /* Receive and transmit data size Bit 2 */
    word RXTXSIZ23   :1;                                       /* Receive and transmit data size Bit 3 */
    word RXTXSIZ24   :1;                                       /* Receive and transmit data size Bit 4 */
    word RXTXSIZ25   :1;                                       /* Receive and transmit data size Bit 5 */
    word RXTXSIZ26   :1;                                       /* Receive and transmit data size Bit 6 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word TCIE2       :1;                                       /* Transfer complete interrupt enable */
    word TFRC2       :1;                                       /* Transfer Completed */
    word DVALID2     :1;                                       /* Data Valid */
    word STALL2      :1;                                       /* Stall */
  } Bits;
  struct {
    word grpRXTXSIZ_20 :7;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpTCIE_2 :1;
    word grpTFRC_2 :1;
    word grpDVALID_2 :1;
    word grpSTALL_2 :1;
  } MergedBits;
} UEPCSR2STR;
extern volatile UEPCSR2STR _UEPCSR2 @(REG_BASE + 0x00000318UL);
#define UEPCSR2                         _UEPCSR2.Word
#define UEPCSR2_RXTXSIZ20               _UEPCSR2.Bits.RXTXSIZ20
#define UEPCSR2_RXTXSIZ21               _UEPCSR2.Bits.RXTXSIZ21
#define UEPCSR2_RXTXSIZ22               _UEPCSR2.Bits.RXTXSIZ22
#define UEPCSR2_RXTXSIZ23               _UEPCSR2.Bits.RXTXSIZ23
#define UEPCSR2_RXTXSIZ24               _UEPCSR2.Bits.RXTXSIZ24
#define UEPCSR2_RXTXSIZ25               _UEPCSR2.Bits.RXTXSIZ25
#define UEPCSR2_RXTXSIZ26               _UEPCSR2.Bits.RXTXSIZ26
#define UEPCSR2_TCIE2                   _UEPCSR2.Bits.TCIE2
#define UEPCSR2_TFRC2                   _UEPCSR2.Bits.TFRC2
#define UEPCSR2_DVALID2                 _UEPCSR2.Bits.DVALID2
#define UEPCSR2_STALL2                  _UEPCSR2.Bits.STALL2
#define UEPCSR2_RXTXSIZ_20              _UEPCSR2.MergedBits.grpRXTXSIZ_20
#define UEPCSR2_RXTXSIZ                 UEPCSR2_RXTXSIZ_20

#define UEPCSR2_RXTXSIZ20_MASK          1U
#define UEPCSR2_RXTXSIZ21_MASK          2U
#define UEPCSR2_RXTXSIZ22_MASK          4U
#define UEPCSR2_RXTXSIZ23_MASK          8U
#define UEPCSR2_RXTXSIZ24_MASK          16U
#define UEPCSR2_RXTXSIZ25_MASK          32U
#define UEPCSR2_RXTXSIZ26_MASK          64U
#define UEPCSR2_TCIE2_MASK              4096U
#define UEPCSR2_TFRC2_MASK              8192U
#define UEPCSR2_DVALID2_MASK            16384U
#define UEPCSR2_STALL2_MASK             32768U
#define UEPCSR2_RXTXSIZ_20_MASK         127U
#define UEPCSR2_RXTXSIZ_20_BITNUM       0U


/*** UEPCSR3 - USB20 Endpoint Control Status Register 3; 0x0000031A ***/
typedef union {
  word Word;
  struct {
    word RXTXSIZ30   :1;                                       /* Receive and transmit data size Bit 0 */
    word RXTXSIZ31   :1;                                       /* Receive and transmit data size Bit 1 */
    word RXTXSIZ32   :1;                                       /* Receive and transmit data size Bit 2 */
    word RXTXSIZ33   :1;                                       /* Receive and transmit data size Bit 3 */
    word RXTXSIZ34   :1;                                       /* Receive and transmit data size Bit 4 */
    word RXTXSIZ35   :1;                                       /* Receive and transmit data size Bit 5 */
    word RXTXSIZ36   :1;                                       /* Receive and transmit data size Bit 6 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word TCIE3       :1;                                       /* Transfer complete interrupt enable */
    word TFRC3       :1;                                       /* Transfer Completed */
    word DVALID3     :1;                                       /* Data Valid */
    word STALL3      :1;                                       /* Stall */
  } Bits;
  struct {
    word grpRXTXSIZ_30 :7;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpTCIE_3 :1;
    word grpTFRC_3 :1;
    word grpDVALID_3 :1;
    word grpSTALL_3 :1;
  } MergedBits;
} UEPCSR3STR;
extern volatile UEPCSR3STR _UEPCSR3 @(REG_BASE + 0x0000031AUL);
#define UEPCSR3                         _UEPCSR3.Word
#define UEPCSR3_RXTXSIZ30               _UEPCSR3.Bits.RXTXSIZ30
#define UEPCSR3_RXTXSIZ31               _UEPCSR3.Bits.RXTXSIZ31
#define UEPCSR3_RXTXSIZ32               _UEPCSR3.Bits.RXTXSIZ32
#define UEPCSR3_RXTXSIZ33               _UEPCSR3.Bits.RXTXSIZ33
#define UEPCSR3_RXTXSIZ34               _UEPCSR3.Bits.RXTXSIZ34
#define UEPCSR3_RXTXSIZ35               _UEPCSR3.Bits.RXTXSIZ35
#define UEPCSR3_RXTXSIZ36               _UEPCSR3.Bits.RXTXSIZ36
#define UEPCSR3_TCIE3                   _UEPCSR3.Bits.TCIE3
#define UEPCSR3_TFRC3                   _UEPCSR3.Bits.TFRC3
#define UEPCSR3_DVALID3                 _UEPCSR3.Bits.DVALID3
#define UEPCSR3_STALL3                  _UEPCSR3.Bits.STALL3
#define UEPCSR3_RXTXSIZ_30              _UEPCSR3.MergedBits.grpRXTXSIZ_30
#define UEPCSR3_RXTXSIZ                 UEPCSR3_RXTXSIZ_30

#define UEPCSR3_RXTXSIZ30_MASK          1U
#define UEPCSR3_RXTXSIZ31_MASK          2U
#define UEPCSR3_RXTXSIZ32_MASK          4U
#define UEPCSR3_RXTXSIZ33_MASK          8U
#define UEPCSR3_RXTXSIZ34_MASK          16U
#define UEPCSR3_RXTXSIZ35_MASK          32U
#define UEPCSR3_RXTXSIZ36_MASK          64U
#define UEPCSR3_TCIE3_MASK              4096U
#define UEPCSR3_TFRC3_MASK              8192U
#define UEPCSR3_DVALID3_MASK            16384U
#define UEPCSR3_STALL3_MASK             32768U
#define UEPCSR3_RXTXSIZ_30_MASK         127U
#define UEPCSR3_RXTXSIZ_30_BITNUM       0U


/*** UEPCSR4A - USB 20 EndPoint Control Status Register 4 A; 0x0000031C ***/
typedef union {
  word Word;
  struct {
    word RXSIZ4A0    :1;                                       /* Receive data size Bit 0 */
    word RXSIZ4A1    :1;                                       /* Receive data size Bit 1 */
    word RXSIZ4A2    :1;                                       /* Receive data size Bit 2 */
    word RXSIZ4A3    :1;                                       /* Receive data size Bit 3 */
    word RXSIZ4A4    :1;                                       /* Receive data size Bit 4 */
    word RXSIZ4A5    :1;                                       /* Receive data size Bit 5 */
    word RXSIZ4A6    :1;                                       /* Receive data size Bit 6 */
    word RXSIZ4A7    :1;                                       /* Receive data size Bit 7 */
    word RXSIZ4A8    :1;                                       /* Receive data size Bit 8 */
    word RXSIZ4A9    :1;                                       /* Receive data size Bit 9 */
    word RXSIZ4A10   :1;                                       /* Receive data size Bit 10 */
    word CTERR       :1;                                       /* Continue on Transfer Error */
    word TCIE4A      :1;                                       /* Transfer complete interrupt enable */
    word TFRC4A      :1;                                       /* Transfer Completed */
    word SNAK        :1;                                       /* Send NAK */
    word STALL4A     :1;                                       /* Stall */
  } Bits;
  struct {
    word grpRXSIZ4A :11;
    word         :1;
    word grpTCIE4x :1;
    word grpTFRC4x :1;
    word         :1;
    word grpSTALL4x :1;
  } MergedBits;
} UEPCSR4ASTR;
extern volatile UEPCSR4ASTR _UEPCSR4A @(REG_BASE + 0x0000031CUL);
#define UEPCSR4A                        _UEPCSR4A.Word
#define UEPCSR4A_RXSIZ4A0               _UEPCSR4A.Bits.RXSIZ4A0
#define UEPCSR4A_RXSIZ4A1               _UEPCSR4A.Bits.RXSIZ4A1
#define UEPCSR4A_RXSIZ4A2               _UEPCSR4A.Bits.RXSIZ4A2
#define UEPCSR4A_RXSIZ4A3               _UEPCSR4A.Bits.RXSIZ4A3
#define UEPCSR4A_RXSIZ4A4               _UEPCSR4A.Bits.RXSIZ4A4
#define UEPCSR4A_RXSIZ4A5               _UEPCSR4A.Bits.RXSIZ4A5
#define UEPCSR4A_RXSIZ4A6               _UEPCSR4A.Bits.RXSIZ4A6
#define UEPCSR4A_RXSIZ4A7               _UEPCSR4A.Bits.RXSIZ4A7
#define UEPCSR4A_RXSIZ4A8               _UEPCSR4A.Bits.RXSIZ4A8
#define UEPCSR4A_RXSIZ4A9               _UEPCSR4A.Bits.RXSIZ4A9
#define UEPCSR4A_RXSIZ4A10              _UEPCSR4A.Bits.RXSIZ4A10
#define UEPCSR4A_CTERR                  _UEPCSR4A.Bits.CTERR
#define UEPCSR4A_TCIE4A                 _UEPCSR4A.Bits.TCIE4A
#define UEPCSR4A_TFRC4A                 _UEPCSR4A.Bits.TFRC4A
#define UEPCSR4A_SNAK                   _UEPCSR4A.Bits.SNAK
#define UEPCSR4A_STALL4A                _UEPCSR4A.Bits.STALL4A
#define UEPCSR4A_RXSIZ4A                _UEPCSR4A.MergedBits.grpRXSIZ4A

#define UEPCSR4A_RXSIZ4A0_MASK          1U
#define UEPCSR4A_RXSIZ4A1_MASK          2U
#define UEPCSR4A_RXSIZ4A2_MASK          4U
#define UEPCSR4A_RXSIZ4A3_MASK          8U
#define UEPCSR4A_RXSIZ4A4_MASK          16U
#define UEPCSR4A_RXSIZ4A5_MASK          32U
#define UEPCSR4A_RXSIZ4A6_MASK          64U
#define UEPCSR4A_RXSIZ4A7_MASK          128U
#define UEPCSR4A_RXSIZ4A8_MASK          256U
#define UEPCSR4A_RXSIZ4A9_MASK          512U
#define UEPCSR4A_RXSIZ4A10_MASK         1024U
#define UEPCSR4A_CTERR_MASK             2048U
#define UEPCSR4A_TCIE4A_MASK            4096U
#define UEPCSR4A_TFRC4A_MASK            8192U
#define UEPCSR4A_SNAK_MASK              16384U
#define UEPCSR4A_STALL4A_MASK           32768U
#define UEPCSR4A_RXSIZ4A_MASK           2047U
#define UEPCSR4A_RXSIZ4A_BITNUM         0U


/*** UEPCSR4B -  USB20 Endpoint Control Status Register 4 B; 0x0000031E ***/
typedef union {
  word Word;
  struct {
    word MPPB0       :1;                                       /* Maxpkt per Block Bit 0 */
    word MPPB1       :1;                                       /* Maxpkt per Block Bit 1 */
    word MPPB2       :1;                                       /* Maxpkt per Block Bit 2 */
    word MPPB3       :1;                                       /* Maxpkt per Block Bit 3 */
    word CURMP0      :1;                                       /* Current maxpkt index Bit 0 */
    word CURMP1      :1;                                       /* Current maxpkt index Bit 1 */
    word CURMP2      :1;                                       /* Current maxpkt index Bit 2 */
    word CURMP3      :1;                                       /* Current maxpkt index Bit 3 */
    word             :1; 
    word             :1; 
    word EBAVA0      :1;                                       /* Number of empty buffer available Bit 0 */
    word EBAVA1      :1;                                       /* Number of empty buffer available Bit 1 */
    word TERRIE      :1;                                       /* Transfer error interrupt enable */
    word TFRERR      :1;                                       /* Transfer Error */
    word SPKTIE      :1;                                       /* Short Packet Received interrupt enable */
    word SPKT        :1;                                       /* Short Packet Received */
  } Bits;
  struct {
    word grpMPPB :4;
    word grpCURMP :4;
    word         :1;
    word         :1;
    word grpEBAVA :2;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} UEPCSR4BSTR;
extern volatile UEPCSR4BSTR _UEPCSR4B @(REG_BASE + 0x0000031EUL);
#define UEPCSR4B                        _UEPCSR4B.Word
#define UEPCSR4B_MPPB0                  _UEPCSR4B.Bits.MPPB0
#define UEPCSR4B_MPPB1                  _UEPCSR4B.Bits.MPPB1
#define UEPCSR4B_MPPB2                  _UEPCSR4B.Bits.MPPB2
#define UEPCSR4B_MPPB3                  _UEPCSR4B.Bits.MPPB3
#define UEPCSR4B_CURMP0                 _UEPCSR4B.Bits.CURMP0
#define UEPCSR4B_CURMP1                 _UEPCSR4B.Bits.CURMP1
#define UEPCSR4B_CURMP2                 _UEPCSR4B.Bits.CURMP2
#define UEPCSR4B_CURMP3                 _UEPCSR4B.Bits.CURMP3
#define UEPCSR4B_EBAVA0                 _UEPCSR4B.Bits.EBAVA0
#define UEPCSR4B_EBAVA1                 _UEPCSR4B.Bits.EBAVA1
#define UEPCSR4B_TERRIE                 _UEPCSR4B.Bits.TERRIE
#define UEPCSR4B_TFRERR                 _UEPCSR4B.Bits.TFRERR
#define UEPCSR4B_SPKTIE                 _UEPCSR4B.Bits.SPKTIE
#define UEPCSR4B_SPKT                   _UEPCSR4B.Bits.SPKT
#define UEPCSR4B_MPPB                   _UEPCSR4B.MergedBits.grpMPPB
#define UEPCSR4B_CURMP                  _UEPCSR4B.MergedBits.grpCURMP
#define UEPCSR4B_EBAVA                  _UEPCSR4B.MergedBits.grpEBAVA

#define UEPCSR4B_MPPB0_MASK             1U
#define UEPCSR4B_MPPB1_MASK             2U
#define UEPCSR4B_MPPB2_MASK             4U
#define UEPCSR4B_MPPB3_MASK             8U
#define UEPCSR4B_CURMP0_MASK            16U
#define UEPCSR4B_CURMP1_MASK            32U
#define UEPCSR4B_CURMP2_MASK            64U
#define UEPCSR4B_CURMP3_MASK            128U
#define UEPCSR4B_EBAVA0_MASK            1024U
#define UEPCSR4B_EBAVA1_MASK            2048U
#define UEPCSR4B_TERRIE_MASK            4096U
#define UEPCSR4B_TFRERR_MASK            8192U
#define UEPCSR4B_SPKTIE_MASK            16384U
#define UEPCSR4B_SPKT_MASK              32768U
#define UEPCSR4B_MPPB_MASK              15U
#define UEPCSR4B_MPPB_BITNUM            0U
#define UEPCSR4B_CURMP_MASK             240U
#define UEPCSR4B_CURMP_BITNUM           4U
#define UEPCSR4B_EBAVA_MASK             3072U
#define UEPCSR4B_EBAVA_BITNUM           10U


/*** UEPCSR5A - USB 20 EndPoint Control Status Register 5A; 0x00000320 ***/
typedef union {
  word Word;
  struct {
    word TXSIZ05A0   :1;                                       /* Transmit data size  Bit 0 */
    word TXSIZ05A1   :1;                                       /* Transmit data size  Bit 1 */
    word TXSIZ05A2   :1;                                       /* Transmit data size  Bit 2 */
    word TXSIZ05A3   :1;                                       /* Transmit data size  Bit 3 */
    word TXSIZ05A4   :1;                                       /* Transmit data size  Bit 4 */
    word TXSIZ05A5   :1;                                       /* Transmit data size  Bit 5 */
    word TXSIZ05A6   :1;                                       /* Transmit data size  Bit 6 */
    word TXSIZ05A7   :1;                                       /* Transmit data size  Bit 7 */
    word TXSIZ05A8   :1;                                       /* Transmit data size  Bit 8 */
    word TXSIZ05A9   :1;                                       /* Transmit data size  Bit 9 */
    word TXSIZ05A10  :1;                                       /* Transmit data size  Bit 10 */
    word CTERR5A     :1;                                       /* Continue on Transfer Error */
    word TCIE5A      :1;                                       /* Transfer complete interrupt enable */
    word TFRC5A      :1;                                       /* Transfer Completed */
    word SNAK5A      :1;                                       /* Send NAK */
    word STALL5A     :1;                                       /* Stall */
  } Bits;
  struct {
    word grpTXSIZ05A :11;
    word         :1;
    word grpTCIE5x :1;
    word grpTFRC5x :1;
    word grpSNAK5x :1;
    word grpSTALL5x :1;
  } MergedBits;
} UEPCSR5ASTR;
extern volatile UEPCSR5ASTR _UEPCSR5A @(REG_BASE + 0x00000320UL);
#define UEPCSR5A                        _UEPCSR5A.Word
#define UEPCSR5A_TXSIZ05A0              _UEPCSR5A.Bits.TXSIZ05A0
#define UEPCSR5A_TXSIZ05A1              _UEPCSR5A.Bits.TXSIZ05A1
#define UEPCSR5A_TXSIZ05A2              _UEPCSR5A.Bits.TXSIZ05A2
#define UEPCSR5A_TXSIZ05A3              _UEPCSR5A.Bits.TXSIZ05A3
#define UEPCSR5A_TXSIZ05A4              _UEPCSR5A.Bits.TXSIZ05A4
#define UEPCSR5A_TXSIZ05A5              _UEPCSR5A.Bits.TXSIZ05A5
#define UEPCSR5A_TXSIZ05A6              _UEPCSR5A.Bits.TXSIZ05A6
#define UEPCSR5A_TXSIZ05A7              _UEPCSR5A.Bits.TXSIZ05A7
#define UEPCSR5A_TXSIZ05A8              _UEPCSR5A.Bits.TXSIZ05A8
#define UEPCSR5A_TXSIZ05A9              _UEPCSR5A.Bits.TXSIZ05A9
#define UEPCSR5A_TXSIZ05A10             _UEPCSR5A.Bits.TXSIZ05A10
#define UEPCSR5A_CTERR5A                _UEPCSR5A.Bits.CTERR5A
#define UEPCSR5A_TCIE5A                 _UEPCSR5A.Bits.TCIE5A
#define UEPCSR5A_TFRC5A                 _UEPCSR5A.Bits.TFRC5A
#define UEPCSR5A_SNAK5A                 _UEPCSR5A.Bits.SNAK5A
#define UEPCSR5A_STALL5A                _UEPCSR5A.Bits.STALL5A
#define UEPCSR5A_TXSIZ05A               _UEPCSR5A.MergedBits.grpTXSIZ05A

#define UEPCSR5A_TXSIZ05A0_MASK         1U
#define UEPCSR5A_TXSIZ05A1_MASK         2U
#define UEPCSR5A_TXSIZ05A2_MASK         4U
#define UEPCSR5A_TXSIZ05A3_MASK         8U
#define UEPCSR5A_TXSIZ05A4_MASK         16U
#define UEPCSR5A_TXSIZ05A5_MASK         32U
#define UEPCSR5A_TXSIZ05A6_MASK         64U
#define UEPCSR5A_TXSIZ05A7_MASK         128U
#define UEPCSR5A_TXSIZ05A8_MASK         256U
#define UEPCSR5A_TXSIZ05A9_MASK         512U
#define UEPCSR5A_TXSIZ05A10_MASK        1024U
#define UEPCSR5A_CTERR5A_MASK           2048U
#define UEPCSR5A_TCIE5A_MASK            4096U
#define UEPCSR5A_TFRC5A_MASK            8192U
#define UEPCSR5A_SNAK5A_MASK            16384U
#define UEPCSR5A_STALL5A_MASK           32768U
#define UEPCSR5A_TXSIZ05A_MASK          2047U
#define UEPCSR5A_TXSIZ05A_BITNUM        0U


/*** UEPCSR5B - USB20 Endpoint Control Status Register 5 B; 0x00000322 ***/
typedef union {
  word Word;
  struct {
    word MPPB5B0     :1;                                       /* Maxpkt per Block Bit 0 */
    word MPPB5B1     :1;                                       /* Maxpkt per Block Bit 1 */
    word MPPB5B2     :1;                                       /* Maxpkt per Block Bit 2 */
    word MPPB5B3     :1;                                       /* Maxpkt per Block Bit 3 */
    word CURMP5B0    :1;                                       /* Current maxpkt index  Bit 0 */
    word CURMP5B1    :1;                                       /* Current maxpkt index  Bit 1 */
    word CURMP5B2    :1;                                       /* Current maxpkt index  Bit 2 */
    word CURMP5B3    :1;                                       /* Current maxpkt index  Bit 3 */
    word BVLD5B0     :1;                                       /* Number of valid buffer Bit 0 */
    word BVLD5B1     :1;                                       /* Number of valid buffer Bit 1 */
    word             :1; 
    word             :1; 
    word TERRIE5B    :1;                                       /* Transfer error interrupt enable */
    word TFRERR5B    :1;                                       /* Transfer Error */
    word             :1; 
    word             :1; 
  } Bits;
  struct {
    word grpMPPB5B :4;
    word grpCURMP5B :4;
    word grpBVLD5B :2;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} UEPCSR5BSTR;
extern volatile UEPCSR5BSTR _UEPCSR5B @(REG_BASE + 0x00000322UL);
#define UEPCSR5B                        _UEPCSR5B.Word
#define UEPCSR5B_MPPB5B0                _UEPCSR5B.Bits.MPPB5B0
#define UEPCSR5B_MPPB5B1                _UEPCSR5B.Bits.MPPB5B1
#define UEPCSR5B_MPPB5B2                _UEPCSR5B.Bits.MPPB5B2
#define UEPCSR5B_MPPB5B3                _UEPCSR5B.Bits.MPPB5B3
#define UEPCSR5B_CURMP5B0               _UEPCSR5B.Bits.CURMP5B0
#define UEPCSR5B_CURMP5B1               _UEPCSR5B.Bits.CURMP5B1
#define UEPCSR5B_CURMP5B2               _UEPCSR5B.Bits.CURMP5B2
#define UEPCSR5B_CURMP5B3               _UEPCSR5B.Bits.CURMP5B3
#define UEPCSR5B_BVLD5B0                _UEPCSR5B.Bits.BVLD5B0
#define UEPCSR5B_BVLD5B1                _UEPCSR5B.Bits.BVLD5B1
#define UEPCSR5B_TERRIE5B               _UEPCSR5B.Bits.TERRIE5B
#define UEPCSR5B_TFRERR5B               _UEPCSR5B.Bits.TFRERR5B
#define UEPCSR5B_MPPB5B                 _UEPCSR5B.MergedBits.grpMPPB5B
#define UEPCSR5B_CURMP5B                _UEPCSR5B.MergedBits.grpCURMP5B
#define UEPCSR5B_BVLD5B                 _UEPCSR5B.MergedBits.grpBVLD5B

#define UEPCSR5B_MPPB5B0_MASK           1U
#define UEPCSR5B_MPPB5B1_MASK           2U
#define UEPCSR5B_MPPB5B2_MASK           4U
#define UEPCSR5B_MPPB5B3_MASK           8U
#define UEPCSR5B_CURMP5B0_MASK          16U
#define UEPCSR5B_CURMP5B1_MASK          32U
#define UEPCSR5B_CURMP5B2_MASK          64U
#define UEPCSR5B_CURMP5B3_MASK          128U
#define UEPCSR5B_BVLD5B0_MASK           256U
#define UEPCSR5B_BVLD5B1_MASK           512U
#define UEPCSR5B_TERRIE5B_MASK          4096U
#define UEPCSR5B_TFRERR5B_MASK          8192U
#define UEPCSR5B_MPPB5B_MASK            15U
#define UEPCSR5B_MPPB5B_BITNUM          0U
#define UEPCSR5B_CURMP5B_MASK           240U
#define UEPCSR5B_CURMP5B_BITNUM         4U
#define UEPCSR5B_BVLD5B_MASK            768U
#define UEPCSR5B_BVLD5B_BITNUM          8U


/*** UEPCSR6 - USB20 Endpoint Control Status Register 6; 0x00000324 ***/
typedef union {
  word Word;
  struct {
    word RXTXSIZ60   :1;                                       /* Receive and transmit data size Bit 0 */
    word RXTXSIZ61   :1;                                       /* Receive and transmit data size Bit 1 */
    word RXTXSIZ62   :1;                                       /* Receive and transmit data size Bit 2 */
    word RXTXSIZ63   :1;                                       /* Receive and transmit data size Bit 3 */
    word RXTXSIZ64   :1;                                       /* Receive and transmit data size Bit 4 */
    word RXTXSIZ65   :1;                                       /* Receive and transmit data size Bit 5 */
    word RXTXSIZ66   :1;                                       /* Receive and transmit data size Bit 6 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word TCIE6       :1;                                       /* Transfer complete interrupt enable */
    word TFRC6       :1;                                       /* Transfer Completed */
    word DVALID6     :1;                                       /* Data Valid */
    word STALL6      :1;                                       /* Stall */
  } Bits;
  struct {
    word grpRXTXSIZ_60 :7;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpTCIE_6 :1;
    word grpTFRC_6 :1;
    word grpDVALID_6 :1;
    word grpSTALL_6 :1;
  } MergedBits;
} UEPCSR6STR;
extern volatile UEPCSR6STR _UEPCSR6 @(REG_BASE + 0x00000324UL);
#define UEPCSR6                         _UEPCSR6.Word
#define UEPCSR6_RXTXSIZ60               _UEPCSR6.Bits.RXTXSIZ60
#define UEPCSR6_RXTXSIZ61               _UEPCSR6.Bits.RXTXSIZ61
#define UEPCSR6_RXTXSIZ62               _UEPCSR6.Bits.RXTXSIZ62
#define UEPCSR6_RXTXSIZ63               _UEPCSR6.Bits.RXTXSIZ63
#define UEPCSR6_RXTXSIZ64               _UEPCSR6.Bits.RXTXSIZ64
#define UEPCSR6_RXTXSIZ65               _UEPCSR6.Bits.RXTXSIZ65
#define UEPCSR6_RXTXSIZ66               _UEPCSR6.Bits.RXTXSIZ66
#define UEPCSR6_TCIE6                   _UEPCSR6.Bits.TCIE6
#define UEPCSR6_TFRC6                   _UEPCSR6.Bits.TFRC6
#define UEPCSR6_DVALID6                 _UEPCSR6.Bits.DVALID6
#define UEPCSR6_STALL6                  _UEPCSR6.Bits.STALL6
#define UEPCSR6_RXTXSIZ_60              _UEPCSR6.MergedBits.grpRXTXSIZ_60
#define UEPCSR6_RXTXSIZ                 UEPCSR6_RXTXSIZ_60

#define UEPCSR6_RXTXSIZ60_MASK          1U
#define UEPCSR6_RXTXSIZ61_MASK          2U
#define UEPCSR6_RXTXSIZ62_MASK          4U
#define UEPCSR6_RXTXSIZ63_MASK          8U
#define UEPCSR6_RXTXSIZ64_MASK          16U
#define UEPCSR6_RXTXSIZ65_MASK          32U
#define UEPCSR6_RXTXSIZ66_MASK          64U
#define UEPCSR6_TCIE6_MASK              4096U
#define UEPCSR6_TFRC6_MASK              8192U
#define UEPCSR6_DVALID6_MASK            16384U
#define UEPCSR6_STALL6_MASK             32768U
#define UEPCSR6_RXTXSIZ_60_MASK         127U
#define UEPCSR6_RXTXSIZ_60_BITNUM       0U


/*** BAKEY0 - Backdoor Access Key 0; 0x0000FF00 ***/
typedef union {
  word Word;
  struct {
    word KEY0        :1;                                       /* Backdoor Access Key bits, bit 0 */
    word KEY1        :1;                                       /* Backdoor Access Key bits, bit 1 */
    word KEY2        :1;                                       /* Backdoor Access Key bits, bit 2 */
    word KEY3        :1;                                       /* Backdoor Access Key bits, bit 3 */
    word KEY4        :1;                                       /* Backdoor Access Key bits, bit 4 */
    word KEY5        :1;                                       /* Backdoor Access Key bits, bit 5 */
    word KEY6        :1;                                       /* Backdoor Access Key bits, bit 6 */
    word KEY7        :1;                                       /* Backdoor Access Key bits, bit 7 */
    word KEY8        :1;                                       /* Backdoor Access Key bits, bit 8 */
    word KEY9        :1;                                       /* Backdoor Access Key bits, bit 9 */
    word KEY10       :1;                                       /* Backdoor Access Key bits, bit 10 */
    word KEY11       :1;                                       /* Backdoor Access Key bits, bit 11 */
    word KEY12       :1;                                       /* Backdoor Access Key bits, bit 12 */
    word KEY13       :1;                                       /* Backdoor Access Key bits, bit 13 */
    word KEY14       :1;                                       /* Backdoor Access Key bits, bit 14 */
    word KEY15       :1;                                       /* Backdoor Access Key bits, bit 15 */
  } Bits;
} BAKEY0STR;
/* Tip for register initialization in the user code:  const word BAKEY0_INIT @0x0000FF00 = <BAKEY0_INITVAL>; */
#define _BAKEY0 (*(const BAKEY0STR *)0x0000FF00)
#define BAKEY0                          _BAKEY0.Word
#define BAKEY0_KEY0                     _BAKEY0.Bits.KEY0
#define BAKEY0_KEY1                     _BAKEY0.Bits.KEY1
#define BAKEY0_KEY2                     _BAKEY0.Bits.KEY2
#define BAKEY0_KEY3                     _BAKEY0.Bits.KEY3
#define BAKEY0_KEY4                     _BAKEY0.Bits.KEY4
#define BAKEY0_KEY5                     _BAKEY0.Bits.KEY5
#define BAKEY0_KEY6                     _BAKEY0.Bits.KEY6
#define BAKEY0_KEY7                     _BAKEY0.Bits.KEY7
#define BAKEY0_KEY8                     _BAKEY0.Bits.KEY8
#define BAKEY0_KEY9                     _BAKEY0.Bits.KEY9
#define BAKEY0_KEY10                    _BAKEY0.Bits.KEY10
#define BAKEY0_KEY11                    _BAKEY0.Bits.KEY11
#define BAKEY0_KEY12                    _BAKEY0.Bits.KEY12
#define BAKEY0_KEY13                    _BAKEY0.Bits.KEY13
#define BAKEY0_KEY14                    _BAKEY0.Bits.KEY14
#define BAKEY0_KEY15                    _BAKEY0.Bits.KEY15
/* BAKEY_ARR: Access 4 BAKEYx registers in an array */
#define BAKEY_ARR                       ((volatile word *) &BAKEY0)

#define BAKEY0_KEY0_MASK                1U
#define BAKEY0_KEY1_MASK                2U
#define BAKEY0_KEY2_MASK                4U
#define BAKEY0_KEY3_MASK                8U
#define BAKEY0_KEY4_MASK                16U
#define BAKEY0_KEY5_MASK                32U
#define BAKEY0_KEY6_MASK                64U
#define BAKEY0_KEY7_MASK                128U
#define BAKEY0_KEY8_MASK                256U
#define BAKEY0_KEY9_MASK                512U
#define BAKEY0_KEY10_MASK               1024U
#define BAKEY0_KEY11_MASK               2048U
#define BAKEY0_KEY12_MASK               4096U
#define BAKEY0_KEY13_MASK               8192U
#define BAKEY0_KEY14_MASK               16384U
#define BAKEY0_KEY15_MASK               32768U


/*** BAKEY1 - Backdoor Access Key 1; 0x0000FF02 ***/
typedef union {
  word Word;
  struct {
    word KEY0        :1;                                       /* Backdoor Access Key bits, bit 0 */
    word KEY1        :1;                                       /* Backdoor Access Key bits, bit 1 */
    word KEY2        :1;                                       /* Backdoor Access Key bits, bit 2 */
    word KEY3        :1;                                       /* Backdoor Access Key bits, bit 3 */
    word KEY4        :1;                                       /* Backdoor Access Key bits, bit 4 */
    word KEY5        :1;                                       /* Backdoor Access Key bits, bit 5 */
    word KEY6        :1;                                       /* Backdoor Access Key bits, bit 6 */
    word KEY7        :1;                                       /* Backdoor Access Key bits, bit 7 */
    word KEY8        :1;                                       /* Backdoor Access Key bits, bit 8 */
    word KEY9        :1;                                       /* Backdoor Access Key bits, bit 9 */
    word KEY10       :1;                                       /* Backdoor Access Key bits, bit 10 */
    word KEY11       :1;                                       /* Backdoor Access Key bits, bit 11 */
    word KEY12       :1;                                       /* Backdoor Access Key bits, bit 12 */
    word KEY13       :1;                                       /* Backdoor Access Key bits, bit 13 */
    word KEY14       :1;                                       /* Backdoor Access Key bits, bit 14 */
    word KEY15       :1;                                       /* Backdoor Access Key bits, bit 15 */
  } Bits;
} BAKEY1STR;
/* Tip for register initialization in the user code:  const word BAKEY1_INIT @0x0000FF02 = <BAKEY1_INITVAL>; */
#define _BAKEY1 (*(const BAKEY1STR *)0x0000FF02)
#define BAKEY1                          _BAKEY1.Word
#define BAKEY1_KEY0                     _BAKEY1.Bits.KEY0
#define BAKEY1_KEY1                     _BAKEY1.Bits.KEY1
#define BAKEY1_KEY2                     _BAKEY1.Bits.KEY2
#define BAKEY1_KEY3                     _BAKEY1.Bits.KEY3
#define BAKEY1_KEY4                     _BAKEY1.Bits.KEY4
#define BAKEY1_KEY5                     _BAKEY1.Bits.KEY5
#define BAKEY1_KEY6                     _BAKEY1.Bits.KEY6
#define BAKEY1_KEY7                     _BAKEY1.Bits.KEY7
#define BAKEY1_KEY8                     _BAKEY1.Bits.KEY8
#define BAKEY1_KEY9                     _BAKEY1.Bits.KEY9
#define BAKEY1_KEY10                    _BAKEY1.Bits.KEY10
#define BAKEY1_KEY11                    _BAKEY1.Bits.KEY11
#define BAKEY1_KEY12                    _BAKEY1.Bits.KEY12
#define BAKEY1_KEY13                    _BAKEY1.Bits.KEY13
#define BAKEY1_KEY14                    _BAKEY1.Bits.KEY14
#define BAKEY1_KEY15                    _BAKEY1.Bits.KEY15

#define BAKEY1_KEY0_MASK                1U
#define BAKEY1_KEY1_MASK                2U
#define BAKEY1_KEY2_MASK                4U
#define BAKEY1_KEY3_MASK                8U
#define BAKEY1_KEY4_MASK                16U
#define BAKEY1_KEY5_MASK                32U
#define BAKEY1_KEY6_MASK                64U
#define BAKEY1_KEY7_MASK                128U
#define BAKEY1_KEY8_MASK                256U
#define BAKEY1_KEY9_MASK                512U
#define BAKEY1_KEY10_MASK               1024U
#define BAKEY1_KEY11_MASK               2048U
#define BAKEY1_KEY12_MASK               4096U
#define BAKEY1_KEY13_MASK               8192U
#define BAKEY1_KEY14_MASK               16384U
#define BAKEY1_KEY15_MASK               32768U


/*** BAKEY2 - Backdoor Access Key 2; 0x0000FF04 ***/
typedef union {
  word Word;
  struct {
    word KEY0        :1;                                       /* Backdoor Access Key bits, bit 0 */
    word KEY1        :1;                                       /* Backdoor Access Key bits, bit 1 */
    word KEY2        :1;                                       /* Backdoor Access Key bits, bit 2 */
    word KEY3        :1;                                       /* Backdoor Access Key bits, bit 3 */
    word KEY4        :1;                                       /* Backdoor Access Key bits, bit 4 */
    word KEY5        :1;                                       /* Backdoor Access Key bits, bit 5 */
    word KEY6        :1;                                       /* Backdoor Access Key bits, bit 6 */
    word KEY7        :1;                                       /* Backdoor Access Key bits, bit 7 */
    word KEY8        :1;                                       /* Backdoor Access Key bits, bit 8 */
    word KEY9        :1;                                       /* Backdoor Access Key bits, bit 9 */
    word KEY10       :1;                                       /* Backdoor Access Key bits, bit 10 */
    word KEY11       :1;                                       /* Backdoor Access Key bits, bit 11 */
    word KEY12       :1;                                       /* Backdoor Access Key bits, bit 12 */
    word KEY13       :1;                                       /* Backdoor Access Key bits, bit 13 */
    word KEY14       :1;                                       /* Backdoor Access Key bits, bit 14 */
    word KEY15       :1;                                       /* Backdoor Access Key bits, bit 15 */
  } Bits;
} BAKEY2STR;
/* Tip for register initialization in the user code:  const word BAKEY2_INIT @0x0000FF04 = <BAKEY2_INITVAL>; */
#define _BAKEY2 (*(const BAKEY2STR *)0x0000FF04)
#define BAKEY2                          _BAKEY2.Word
#define BAKEY2_KEY0                     _BAKEY2.Bits.KEY0
#define BAKEY2_KEY1                     _BAKEY2.Bits.KEY1
#define BAKEY2_KEY2                     _BAKEY2.Bits.KEY2
#define BAKEY2_KEY3                     _BAKEY2.Bits.KEY3
#define BAKEY2_KEY4                     _BAKEY2.Bits.KEY4
#define BAKEY2_KEY5                     _BAKEY2.Bits.KEY5
#define BAKEY2_KEY6                     _BAKEY2.Bits.KEY6
#define BAKEY2_KEY7                     _BAKEY2.Bits.KEY7
#define BAKEY2_KEY8                     _BAKEY2.Bits.KEY8
#define BAKEY2_KEY9                     _BAKEY2.Bits.KEY9
#define BAKEY2_KEY10                    _BAKEY2.Bits.KEY10
#define BAKEY2_KEY11                    _BAKEY2.Bits.KEY11
#define BAKEY2_KEY12                    _BAKEY2.Bits.KEY12
#define BAKEY2_KEY13                    _BAKEY2.Bits.KEY13
#define BAKEY2_KEY14                    _BAKEY2.Bits.KEY14
#define BAKEY2_KEY15                    _BAKEY2.Bits.KEY15

#define BAKEY2_KEY0_MASK                1U
#define BAKEY2_KEY1_MASK                2U
#define BAKEY2_KEY2_MASK                4U
#define BAKEY2_KEY3_MASK                8U
#define BAKEY2_KEY4_MASK                16U
#define BAKEY2_KEY5_MASK                32U
#define BAKEY2_KEY6_MASK                64U
#define BAKEY2_KEY7_MASK                128U
#define BAKEY2_KEY8_MASK                256U
#define BAKEY2_KEY9_MASK                512U
#define BAKEY2_KEY10_MASK               1024U
#define BAKEY2_KEY11_MASK               2048U
#define BAKEY2_KEY12_MASK               4096U
#define BAKEY2_KEY13_MASK               8192U
#define BAKEY2_KEY14_MASK               16384U
#define BAKEY2_KEY15_MASK               32768U


/*** BAKEY3 - Backdoor Access Key 3; 0x0000FF06 ***/
typedef union {
  word Word;
  struct {
    word KEY0        :1;                                       /* Backdoor Access Key bits, bit 0 */
    word KEY1        :1;                                       /* Backdoor Access Key bits, bit 1 */
    word KEY2        :1;                                       /* Backdoor Access Key bits, bit 2 */
    word KEY3        :1;                                       /* Backdoor Access Key bits, bit 3 */
    word KEY4        :1;                                       /* Backdoor Access Key bits, bit 4 */
    word KEY5        :1;                                       /* Backdoor Access Key bits, bit 5 */
    word KEY6        :1;                                       /* Backdoor Access Key bits, bit 6 */
    word KEY7        :1;                                       /* Backdoor Access Key bits, bit 7 */
    word KEY8        :1;                                       /* Backdoor Access Key bits, bit 8 */
    word KEY9        :1;                                       /* Backdoor Access Key bits, bit 9 */
    word KEY10       :1;                                       /* Backdoor Access Key bits, bit 10 */
    word KEY11       :1;                                       /* Backdoor Access Key bits, bit 11 */
    word KEY12       :1;                                       /* Backdoor Access Key bits, bit 12 */
    word KEY13       :1;                                       /* Backdoor Access Key bits, bit 13 */
    word KEY14       :1;                                       /* Backdoor Access Key bits, bit 14 */
    word KEY15       :1;                                       /* Backdoor Access Key bits, bit 15 */
  } Bits;
} BAKEY3STR;
/* Tip for register initialization in the user code:  const word BAKEY3_INIT @0x0000FF06 = <BAKEY3_INITVAL>; */
#define _BAKEY3 (*(const BAKEY3STR *)0x0000FF06)
#define BAKEY3                          _BAKEY3.Word
#define BAKEY3_KEY0                     _BAKEY3.Bits.KEY0
#define BAKEY3_KEY1                     _BAKEY3.Bits.KEY1
#define BAKEY3_KEY2                     _BAKEY3.Bits.KEY2
#define BAKEY3_KEY3                     _BAKEY3.Bits.KEY3
#define BAKEY3_KEY4                     _BAKEY3.Bits.KEY4
#define BAKEY3_KEY5                     _BAKEY3.Bits.KEY5
#define BAKEY3_KEY6                     _BAKEY3.Bits.KEY6
#define BAKEY3_KEY7                     _BAKEY3.Bits.KEY7
#define BAKEY3_KEY8                     _BAKEY3.Bits.KEY8
#define BAKEY3_KEY9                     _BAKEY3.Bits.KEY9
#define BAKEY3_KEY10                    _BAKEY3.Bits.KEY10
#define BAKEY3_KEY11                    _BAKEY3.Bits.KEY11
#define BAKEY3_KEY12                    _BAKEY3.Bits.KEY12
#define BAKEY3_KEY13                    _BAKEY3.Bits.KEY13
#define BAKEY3_KEY14                    _BAKEY3.Bits.KEY14
#define BAKEY3_KEY15                    _BAKEY3.Bits.KEY15

#define BAKEY3_KEY0_MASK                1U
#define BAKEY3_KEY1_MASK                2U
#define BAKEY3_KEY2_MASK                4U
#define BAKEY3_KEY3_MASK                8U
#define BAKEY3_KEY4_MASK                16U
#define BAKEY3_KEY5_MASK                32U
#define BAKEY3_KEY6_MASK                64U
#define BAKEY3_KEY7_MASK                128U
#define BAKEY3_KEY8_MASK                256U
#define BAKEY3_KEY9_MASK                512U
#define BAKEY3_KEY10_MASK               1024U
#define BAKEY3_KEY11_MASK               2048U
#define BAKEY3_KEY12_MASK               4096U
#define BAKEY3_KEY13_MASK               8192U
#define BAKEY3_KEY14_MASK               16384U
#define BAKEY3_KEY15_MASK               32768U


/*** NVFPROT0 - Non volatile Block 0 Flash Protection Register; 0x0000FF0D ***/
typedef union {
  byte Byte;
  struct {
    byte FPLS0       :1;                                       /* Flash Protection Lower Address size 0 */
    byte FPLS1       :1;                                       /* Flash Protection Lower Address size 1 */
    byte FPLDIS      :1;                                       /* Flash Protection Lower address range disable */
    byte FPHS0       :1;                                       /* Flash Protection Higher address size 0 */
    byte FPHS1       :1;                                       /* Flash Protection Higher address size 1 */
    byte FPHDIS      :1;                                       /* Flash Protection Higher address range disable */
    byte NV6         :1;                                       /* Non Volatile Flag Bit */
    byte FPOPEN      :1;                                       /* Opens the flash block or subsections of it for program or erase */
  } Bits;
  struct {
    byte grpFPLS :2;
    byte         :1;
    byte grpFPHS :2;
    byte         :1;
    byte grpNV_6 :1;
    byte         :1;
  } MergedBits;
} NVFPROT0STR;
/* Tip for register initialization in the user code:  const byte NVFPROT0_INIT @0x0000FF0D = <NVFPROT0_INITVAL>; */
#define _NVFPROT0 (*(const NVFPROT0STR *)0x0000FF0D)
#define NVFPROT0                        _NVFPROT0.Byte
#define NVFPROT0_FPLS0                  _NVFPROT0.Bits.FPLS0
#define NVFPROT0_FPLS1                  _NVFPROT0.Bits.FPLS1
#define NVFPROT0_FPLDIS                 _NVFPROT0.Bits.FPLDIS
#define NVFPROT0_FPHS0                  _NVFPROT0.Bits.FPHS0
#define NVFPROT0_FPHS1                  _NVFPROT0.Bits.FPHS1
#define NVFPROT0_FPHDIS                 _NVFPROT0.Bits.FPHDIS
#define NVFPROT0_NV6                    _NVFPROT0.Bits.NV6
#define NVFPROT0_FPOPEN                 _NVFPROT0.Bits.FPOPEN
#define NVFPROT0_FPLS                   _NVFPROT0.MergedBits.grpFPLS
#define NVFPROT0_FPHS                   _NVFPROT0.MergedBits.grpFPHS

#define NVFPROT0_FPLS0_MASK             1U
#define NVFPROT0_FPLS1_MASK             2U
#define NVFPROT0_FPLDIS_MASK            4U
#define NVFPROT0_FPHS0_MASK             8U
#define NVFPROT0_FPHS1_MASK             16U
#define NVFPROT0_FPHDIS_MASK            32U
#define NVFPROT0_NV6_MASK               64U
#define NVFPROT0_FPOPEN_MASK            128U
#define NVFPROT0_FPLS_MASK              3U
#define NVFPROT0_FPLS_BITNUM            0U
#define NVFPROT0_FPHS_MASK              24U
#define NVFPROT0_FPHS_BITNUM            3U


/*** NVFSEC - Non volatile Flash Security Register; 0x0000FF0F ***/
typedef union {
  byte Byte;
  struct {
    byte SEC0        :1;                                       /* Memory security bit 0 */
    byte SEC1        :1;                                       /* Memory security bit 1 */
    byte NV2         :1;                                       /* Non Volatile flag bit 2 */
    byte NV3         :1;                                       /* Non Volatile flag bit 3 */
    byte NV4         :1;                                       /* Non Volatile flag bit 4 */
    byte NV5         :1;                                       /* Non Volatile flag bit 5 */
    byte NV6         :1;                                       /* Non Volatile flag bit 6 */
    byte KEYEN       :1;                                       /* Backdoor Key Security Enable */
  } Bits;
  struct {
    byte grpSEC  :2;
    byte grpNV_2 :5;
    byte         :1;
  } MergedBits;
} NVFSECSTR;
/* Tip for register initialization in the user code:  const byte NVFSEC_INIT @0x0000FF0F = <NVFSEC_INITVAL>; */
#define _NVFSEC (*(const NVFSECSTR *)0x0000FF0F)
#define NVFSEC                          _NVFSEC.Byte
#define NVFSEC_SEC0                     _NVFSEC.Bits.SEC0
#define NVFSEC_SEC1                     _NVFSEC.Bits.SEC1
#define NVFSEC_NV2                      _NVFSEC.Bits.NV2
#define NVFSEC_NV3                      _NVFSEC.Bits.NV3
#define NVFSEC_NV4                      _NVFSEC.Bits.NV4
#define NVFSEC_NV5                      _NVFSEC.Bits.NV5
#define NVFSEC_NV6                      _NVFSEC.Bits.NV6
#define NVFSEC_KEYEN                    _NVFSEC.Bits.KEYEN
#define NVFSEC_SEC                      _NVFSEC.MergedBits.grpSEC
#define NVFSEC_NV_2                     _NVFSEC.MergedBits.grpNV_2
#define NVFSEC_NV                       NVFSEC_NV_2

#define NVFSEC_SEC0_MASK                1U
#define NVFSEC_SEC1_MASK                2U
#define NVFSEC_NV2_MASK                 4U
#define NVFSEC_NV3_MASK                 8U
#define NVFSEC_NV4_MASK                 16U
#define NVFSEC_NV5_MASK                 32U
#define NVFSEC_NV6_MASK                 64U
#define NVFSEC_KEYEN_MASK               128U
#define NVFSEC_SEC_MASK                 3U
#define NVFSEC_SEC_BITNUM               0U
#define NVFSEC_NV_2_MASK                124U
#define NVFSEC_NV_2_BITNUM              2U


  /* Watchdog reset macro */
#ifndef __RESET_WATCHDOG
#ifdef _lint
  #define __RESET_WATCHDOG()  /* empty */
#else
  #define __RESET_WATCHDOG() (void)(ARMCOP = 0x55U, ARMCOP = 0xAAU)
#endif
#endif /* __RESET_WATCHDOG */


/***********************************************/
/**   D E P R E C I A T E D   S Y M B O L S   **/
/***********************************************/
/* --------------------------------------------------------------------------- */
/* The following symbols were removed, because they were invalid or irrelevant */
/* --------------------------------------------------------------------------- */
/*
 * Follows changes from the database 2.87.1351 version */
#define SCIBDH_TNP0_Hi                   SCIBDH_TNP0
#define SCIBDH_TNP0_Hi_MASK              SCIBDH_TNP0_MASK
#define SCIBDH_TNP1_Hi                   SCIBDH_TNP1
#define SCIBDH_TNP1_Hi_MASK              SCIBDH_TNP1_MASK
#define SCIBDH_IREN_Hi                   SCIBDH_IREN
#define SCIBDH_IREN_Hi_MASK              SCIBDH_IREN_MASK

#ifndef __V30COMPATIBLE__
#pragma OPTION DEL V30toV31Compatible
#endif
/*lint -restore  +esym(961,18.4) +esym(961,19.7) Enable MISRA rule (1.1,18.4,6.4,19.7) checking. */

#endif
