; Based on CPU DB MC9S12Q64_52, version 2.87.413 (RegistersPrg V2.28)

; ###################################################################
;     Filename  : mc9s12q64.inc
;     Processor : MC9S12Q64CPB16
;     FileFormat: V2.28
;     DataSheet : MC9S12Q128 Rev 1.08 05/2007
;     Compiler  : CodeWarrior compiler
;     Date/Time : 2.7.2009, 8:42
;     Abstract  :
;         This header implements the mapping of I/O devices.
;
;     Copyright : 1997 - 2009 Freescale Semiconductor, Inc. All Rights Reserved.
;     
;     http      : www.freescale.com
;     mail      : support@freescale.com
;
;     CPU Registers Revisions:
;      - 08.12.2006, V2.87.400:
;              - Added bit CRGFLG_LVRF. REASON: Bug-fix (#4020 in Issue Manager)
;
;     File-Format-Revisions:
;      - 14.11.2005, V2.00 :
;               - Deprecated symbols added for backward compatibility (section at the end of this file)
;      - 15.11.2005, V2.01 :
;               - Fixed invalid instruction in macro __RESET_WATCHDOG for HCS12 family.
;      - 17.12.2005, V2.02 :
;               - Arrays (symbols xx_ARR) are defined as pointer to volatile, see issue #2778
;      - 16.01.2006, V2.03 :
;               - Fixed declaration of non volatile registers. Now it does not require (but allows) their initialization, see issue #2920.
;               - "volatile" modifier removed from declaration of non volatile registers (that contain modifier "const")
;      - 08.03.2006, V2.04 :
;               - Support for bit(s) names duplicated with any register name in .h header files
;      - 24.03.2006, V2.05 :
;               - Fixed macro __RESET_WATCHDOG for HCS12 family - address and correct write order.
;      - 26.04.2006, V2.06 :
;               - Changes have not affected this file (because they are related to another family)
;      - 27.04.2006, V2.07 :
;               - Fixed macro __RESET_WATCHDOG for HCS12, HCS12X ,HCS08 DZ and HCS08 EN derivatives (write 0x55,0xAA).
;      - 07.06.2006, V2.08 :
;               - Changes have not affected this file (because they are related to another family)
;      - 03.07.2006, V2.09 :
;               - Changes have not affected this file (because they are related to another family)
;      - 27.10.2006, V2.10 :
;               - __RESET_WATCHDOG improved formating and re-definition
;      - 23.11.2006, V2.11 :
;               - Changes have not affected this file (because they are related to another family)
;      - 22.01.2007, V2.12 :
;               - Fixed declaration of non volatile registers. Now it does not require (but allows) their initialization, see issue #4086.
;      - 01.03.2007, V2.13 :
;               - Flash commands constants values converted to HEX format
;      - 02.03.2007, V2.14 :
;               - Interrupt vector numbers added into .H, see VectorNumber_*
;      - 26.03.2007, V2.15 :
;               - Changes have not affected this file (because they are related to another family)
;      - 10.05.2007, V2.16 :
;               - Changes have not affected this file (because they are related to another family)
;      - 05.06.2007, V2.17 :
;               - Changes have not affected this file (because they are related to another family)
;      - 19.07.2007, V2.18 :
;               - Improved number of blanked lines inside register structures
;      - 06.08.2007, V2.19 :
;               - CPUDB revisions generated ahead of the file-format revisions.
;      - 11.09.2007, V2.20 :
;               - Added comment about initialization of unbonded pins.
;      - 02.01.2008, V2.21 :
;               - Changes have not affected this file (because they are related to another family)
;      - 13.02.2008, V2.22 :
;               - Changes have not affected this file (because they are related to another family)
;      - 20.02.2008, V2.23 :
;               - Termination of pragma V30toV31Compatible added, #5708
;      - 03.07.2008, V2.24 :
;               - Added support for bits with name starting with number (like "1HZ")
;      - 28.11.2008, V2.25 :
;               - StandBy RAM array declaration for ANSI-C added
;      - 1.12.2008, V2.26 :
;               - Duplication of bit (or bit-group) name with register name is not marked as a problem, is register is internal only and it is not displayed in I/O map.
;      - 17.3.2009, V2.27 :
;               - Merged bit-group is not generated, if the name matches with another bit name in the register
;      - 6.4.2009, V2.28 :
;               - Fixed generation of merged bits for bit-groups with a digit at the end, if group-name is defined in CPUDB
;
;     Not all general-purpose I/O pins are available on all packages or on all mask sets of a specific
;     derivative device. To avoid extra current drain from floating input pins, the users reset
;     initialization routine in the application program must either enable on-chip pull-up devices
;     or change the direction of unconnected pins to outputs so the pins do not float.
; ###################################################################

;*** Memory Map and Interrupt Vectors
;******************************************
RAMStart:           equ   $00000800
RAMEnd:             equ   $00000FFF
ROM_4000Start:      equ   $00004000
ROM_4000End:        equ   $00007FFF
ROM_C000Start:      equ   $0000C000
ROM_C000End:        equ   $0000FEFF
PAGE_3CStart:       equ   $003C8000
PAGE_3CEnd:         equ   $003CBFFF
PAGE_3DStart:       equ   $003D8000
PAGE_3DEnd:         equ   $003DBFFF
;
VReserved63:        equ   $0000FF80
VReserved62:        equ   $0000FF82
VReserved61:        equ   $0000FF84
VReserved60:        equ   $0000FF86
VReserved59:        equ   $0000FF88
Vvreglvi:           equ   $0000FF8A
VReserved57:        equ   $0000FF8C
Vportp:             equ   $0000FF8E
VReserved55:        equ   $0000FF90
VReserved54:        equ   $0000FF92
VReserved53:        equ   $0000FF94
VReserved52:        equ   $0000FF96
VReserved51:        equ   $0000FF98
VReserved50:        equ   $0000FF9A
VReserved49:        equ   $0000FF9C
VReserved48:        equ   $0000FF9E
VReserved47:        equ   $0000FFA0
VReserved46:        equ   $0000FFA2
VReserved45:        equ   $0000FFA4
VReserved44:        equ   $0000FFA6
VReserved43:        equ   $0000FFA8
VReserved42:        equ   $0000FFAA
VReserved41:        equ   $0000FFAC
VReserved40:        equ   $0000FFAE
Vcantx:             equ   $0000FFB0
Vcanrx:             equ   $0000FFB2
Vcanerr:            equ   $0000FFB4
Vcanwkup:           equ   $0000FFB6
Vflash:             equ   $0000FFB8
VReserved34:        equ   $0000FFBA
VReserved33:        equ   $0000FFBC
VReserved32:        equ   $0000FFBE
VReserved31:        equ   $0000FFC0
VReserved30:        equ   $0000FFC2
Vcrgscm:            equ   $0000FFC4
Vcrgplllck:         equ   $0000FFC6
VReserved27:        equ   $0000FFC8
VReserved26:        equ   $0000FFCA
VReserved25:        equ   $0000FFCC
VReserved24:        equ   $0000FFCE
VReserved23:        equ   $0000FFD0
Vatd0:              equ   $0000FFD2
VReserved21:        equ   $0000FFD4
Vsci:               equ   $0000FFD6
Vspi:               equ   $0000FFD8
Vtimpaie:           equ   $0000FFDA
Vtimpaovf:          equ   $0000FFDC
Vtimovf:            equ   $0000FFDE
Vtimch7:            equ   $0000FFE0
Vtimch6:            equ   $0000FFE2
Vtimch5:            equ   $0000FFE4
Vtimch4:            equ   $0000FFE6
Vtimch3:            equ   $0000FFE8
Vtimch2:            equ   $0000FFEA
VReserved9:         equ   $0000FFEC
VReserved8:         equ   $0000FFEE
Vrti:               equ   $0000FFF0
Virq:               equ   $0000FFF2
Vxirq:              equ   $0000FFF4
Vswi:               equ   $0000FFF6
Vtrap:              equ   $0000FFF8
Vcop:               equ   $0000FFFA
Vclkmon:            equ   $0000FFFC
Vreset:             equ   $0000FFFE
;


;*** PORTAB - Port AB Register; 0x00000000 ***
PORTAB:             equ    $00000000                                ;*** PORTAB - Port AB Register; 0x00000000 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PORTAB_BIT0:        equ    0                                         ; Port AB Bit 0
PORTAB_BIT1:        equ    1                                         ; Port AB Bit 1
PORTAB_BIT2:        equ    2                                         ; Port AB Bit 2
PORTAB_BIT3:        equ    3                                         ; Port AB Bit 3
PORTAB_BIT4:        equ    4                                         ; Port AB Bit 4
PORTAB_BIT5:        equ    5                                         ; Port AB Bit 5
PORTAB_BIT6:        equ    6                                         ; Port AB Bit 6
PORTAB_BIT7:        equ    7                                         ; Port AB Bit 7
PORTAB_BIT8:        equ    8                                         ; Port AB Bit 8
PORTAB_BIT9:        equ    9                                         ; Port AB Bit 9
PORTAB_BIT10:       equ    10                                        ; Port AB Bit 10
PORTAB_BIT11:       equ    11                                        ; Port AB Bit 11
PORTAB_BIT12:       equ    12                                        ; Port AB Bit 12
PORTAB_BIT13:       equ    13                                        ; Port AB Bit 13
PORTAB_BIT14:       equ    14                                        ; Port AB Bit 14
PORTAB_BIT15:       equ    15                                        ; Port AB Bit 15
; bit position masks
mPORTAB_BIT0:       equ    %00000001
mPORTAB_BIT1:       equ    %00000010
mPORTAB_BIT2:       equ    %00000100
mPORTAB_BIT3:       equ    %00001000
mPORTAB_BIT4:       equ    %00010000
mPORTAB_BIT5:       equ    %00100000
mPORTAB_BIT6:       equ    %01000000
mPORTAB_BIT7:       equ    %10000000
mPORTAB_BIT8:       equ    %100000000
mPORTAB_BIT9:       equ    %1000000000
mPORTAB_BIT10:      equ    %10000000000
mPORTAB_BIT11:      equ    %100000000000
mPORTAB_BIT12:      equ    %1000000000000
mPORTAB_BIT13:      equ    %10000000000000
mPORTAB_BIT14:      equ    %100000000000000
mPORTAB_BIT15:      equ    %1000000000000000


;*** PORTA - Port A Register; 0x00000000 ***
PORTA:              equ    $00000000                                ;*** PORTA - Port A Register; 0x00000000 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PORTA_BIT0:         equ    0                                         ; Port A Bit 0
PORTA_BIT1:         equ    1                                         ; Port A Bit 1
PORTA_BIT2:         equ    2                                         ; Port A Bit 2
PORTA_BIT3:         equ    3                                         ; Port A Bit 3
PORTA_BIT4:         equ    4                                         ; Port A Bit 4
PORTA_BIT5:         equ    5                                         ; Port A Bit 5
PORTA_BIT6:         equ    6                                         ; Port A Bit 6
PORTA_BIT7:         equ    7                                         ; Port A Bit 7
; bit position masks
mPORTA_BIT0:        equ    %00000001
mPORTA_BIT1:        equ    %00000010
mPORTA_BIT2:        equ    %00000100
mPORTA_BIT3:        equ    %00001000
mPORTA_BIT4:        equ    %00010000
mPORTA_BIT5:        equ    %00100000
mPORTA_BIT6:        equ    %01000000
mPORTA_BIT7:        equ    %10000000


;*** PORTB - Port B Register; 0x00000001 ***
PORTB:              equ    $00000001                                ;*** PORTB - Port B Register; 0x00000001 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PORTB_BIT0:         equ    0                                         ; Port B Bit 0
PORTB_BIT1:         equ    1                                         ; Port B Bit 1
PORTB_BIT2:         equ    2                                         ; Port B Bit 2
PORTB_BIT3:         equ    3                                         ; Port B Bit 3
PORTB_BIT4:         equ    4                                         ; Port B Bit 4
PORTB_BIT5:         equ    5                                         ; Port B Bit 5
PORTB_BIT6:         equ    6                                         ; Port B Bit 6
PORTB_BIT7:         equ    7                                         ; Port B Bit 7
; bit position masks
mPORTB_BIT0:        equ    %00000001
mPORTB_BIT1:        equ    %00000010
mPORTB_BIT2:        equ    %00000100
mPORTB_BIT3:        equ    %00001000
mPORTB_BIT4:        equ    %00010000
mPORTB_BIT5:        equ    %00100000
mPORTB_BIT6:        equ    %01000000
mPORTB_BIT7:        equ    %10000000


;*** DDRAB - Port AB Data Direction Register; 0x00000002 ***
DDRAB:              equ    $00000002                                ;*** DDRAB - Port AB Data Direction Register; 0x00000002 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRAB_BIT0:         equ    0                                         ; Data Direction Port AB Bit 0
DDRAB_BIT1:         equ    1                                         ; Data Direction Port AB Bit 1
DDRAB_BIT2:         equ    2                                         ; Data Direction Port AB Bit 2
DDRAB_BIT3:         equ    3                                         ; Data Direction Port AB Bit 3
DDRAB_BIT4:         equ    4                                         ; Data Direction Port AB Bit 4
DDRAB_BIT5:         equ    5                                         ; Data Direction Port AB Bit 5
DDRAB_BIT6:         equ    6                                         ; Data Direction Port AB Bit 6
DDRAB_BIT7:         equ    7                                         ; Data Direction Port AB Bit 7
DDRAB_BIT8:         equ    8                                         ; Data Direction Port AB Bit 8
DDRAB_BIT9:         equ    9                                         ; Data Direction Port AB Bit 9
DDRAB_BIT10:        equ    10                                        ; Data Direction Port AB Bit 10
DDRAB_BIT11:        equ    11                                        ; Data Direction Port AB Bit 11
DDRAB_BIT12:        equ    12                                        ; Data Direction Port AB Bit 12
DDRAB_BIT13:        equ    13                                        ; Data Direction Port AB Bit 13
DDRAB_BIT14:        equ    14                                        ; Data Direction Port AB Bit 14
DDRAB_BIT15:        equ    15                                        ; Data Direction Port AB Bit 15
; bit position masks
mDDRAB_BIT0:        equ    %00000001
mDDRAB_BIT1:        equ    %00000010
mDDRAB_BIT2:        equ    %00000100
mDDRAB_BIT3:        equ    %00001000
mDDRAB_BIT4:        equ    %00010000
mDDRAB_BIT5:        equ    %00100000
mDDRAB_BIT6:        equ    %01000000
mDDRAB_BIT7:        equ    %10000000
mDDRAB_BIT8:        equ    %100000000
mDDRAB_BIT9:        equ    %1000000000
mDDRAB_BIT10:       equ    %10000000000
mDDRAB_BIT11:       equ    %100000000000
mDDRAB_BIT12:       equ    %1000000000000
mDDRAB_BIT13:       equ    %10000000000000
mDDRAB_BIT14:       equ    %100000000000000
mDDRAB_BIT15:       equ    %1000000000000000


;*** DDRA - Port A Data Direction Register; 0x00000002 ***
DDRA:               equ    $00000002                                ;*** DDRA - Port A Data Direction Register; 0x00000002 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRA_BIT0:          equ    0                                         ; Data Direction Port A Bit 0
DDRA_BIT1:          equ    1                                         ; Data Direction Port A Bit 1
DDRA_BIT2:          equ    2                                         ; Data Direction Port A Bit 2
DDRA_BIT3:          equ    3                                         ; Data Direction Port A Bit 3
DDRA_BIT4:          equ    4                                         ; Data Direction Port A Bit 4
DDRA_BIT5:          equ    5                                         ; Data Direction Port A Bit 5
DDRA_BIT6:          equ    6                                         ; Data Direction Port A Bit 6
DDRA_BIT7:          equ    7                                         ; Data Direction Port A Bit 7
; bit position masks
mDDRA_BIT0:         equ    %00000001
mDDRA_BIT1:         equ    %00000010
mDDRA_BIT2:         equ    %00000100
mDDRA_BIT3:         equ    %00001000
mDDRA_BIT4:         equ    %00010000
mDDRA_BIT5:         equ    %00100000
mDDRA_BIT6:         equ    %01000000
mDDRA_BIT7:         equ    %10000000


;*** DDRB - Port B Data Direction Register; 0x00000003 ***
DDRB:               equ    $00000003                                ;*** DDRB - Port B Data Direction Register; 0x00000003 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRB_BIT0:          equ    0                                         ; Data Direction Port B Bit 0
DDRB_BIT1:          equ    1                                         ; Data Direction Port B Bit 1
DDRB_BIT2:          equ    2                                         ; Data Direction Port B Bit 2
DDRB_BIT3:          equ    3                                         ; Data Direction Port B Bit 3
DDRB_BIT4:          equ    4                                         ; Data Direction Port B Bit 4
DDRB_BIT5:          equ    5                                         ; Data Direction Port B Bit 5
DDRB_BIT6:          equ    6                                         ; Data Direction Port B Bit 6
DDRB_BIT7:          equ    7                                         ; Data Direction Port B Bit 7
; bit position masks
mDDRB_BIT0:         equ    %00000001
mDDRB_BIT1:         equ    %00000010
mDDRB_BIT2:         equ    %00000100
mDDRB_BIT3:         equ    %00001000
mDDRB_BIT4:         equ    %00010000
mDDRB_BIT5:         equ    %00100000
mDDRB_BIT6:         equ    %01000000
mDDRB_BIT7:         equ    %10000000


;*** PORTE - Port E Register; 0x00000008 ***
PORTE:              equ    $00000008                                ;*** PORTE - Port E Register; 0x00000008 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PORTE_BIT0:         equ    0                                         ; Port E Bit 0
PORTE_BIT1:         equ    1                                         ; Port E Bit 1
PORTE_BIT2:         equ    2                                         ; Port E Bit 2
PORTE_BIT3:         equ    3                                         ; Port E Bit 3
PORTE_BIT4:         equ    4                                         ; Port E Bit 4
PORTE_BIT5:         equ    5                                         ; Port E Bit 5
PORTE_BIT6:         equ    6                                         ; Port E Bit 6
PORTE_BIT7:         equ    7                                         ; Port E Bit 7
; bit position masks
mPORTE_BIT0:        equ    %00000001
mPORTE_BIT1:        equ    %00000010
mPORTE_BIT2:        equ    %00000100
mPORTE_BIT3:        equ    %00001000
mPORTE_BIT4:        equ    %00010000
mPORTE_BIT5:        equ    %00100000
mPORTE_BIT6:        equ    %01000000
mPORTE_BIT7:        equ    %10000000


;*** DDRE - Port E Data Direction Register; 0x00000009 ***
DDRE:               equ    $00000009                                ;*** DDRE - Port E Data Direction Register; 0x00000009 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRE_BIT2:          equ    2                                         ; Data Direction Port E Bit 2
DDRE_BIT3:          equ    3                                         ; Data Direction Port E Bit 3
DDRE_BIT4:          equ    4                                         ; Data Direction Port E Bit 4
DDRE_BIT5:          equ    5                                         ; Data Direction Port E Bit 5
DDRE_BIT6:          equ    6                                         ; Data Direction Port E Bit 6
DDRE_BIT7:          equ    7                                         ; Data Direction Port E Bit 7
; bit position masks
mDDRE_BIT2:         equ    %00000100
mDDRE_BIT3:         equ    %00001000
mDDRE_BIT4:         equ    %00010000
mDDRE_BIT5:         equ    %00100000
mDDRE_BIT6:         equ    %01000000
mDDRE_BIT7:         equ    %10000000


;*** PEAR - Port E Assignment Register; 0x0000000A ***
PEAR:               equ    $0000000A                                ;*** PEAR - Port E Assignment Register; 0x0000000A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PEAR_RDWE:          equ    2                                         ; Read / Write Enable
PEAR_LSTRE:         equ    3                                         ; Low Strobe (LSTRB) Enable
PEAR_NECLK:         equ    4                                         ; No External E Clock
PEAR_PIPOE:         equ    5                                         ; Pipe Status Signal Output Enable
PEAR_NOACCE:        equ    7                                         ; CPU No Access Output Enable
; bit position masks
mPEAR_RDWE:         equ    %00000100
mPEAR_LSTRE:        equ    %00001000
mPEAR_NECLK:        equ    %00010000
mPEAR_PIPOE:        equ    %00100000
mPEAR_NOACCE:       equ    %10000000


;*** MODE - Mode Register; 0x0000000B ***
MODE:               equ    $0000000B                                ;*** MODE - Mode Register; 0x0000000B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MODE_EME:           equ    0                                         ; Emulate Port E
MODE_EMK:           equ    1                                         ; Emulate Port K
MODE_IVIS:          equ    3                                         ; Internal Visibility
MODE_MODA:          equ    5                                         ; Mode Select Bit A
MODE_MODB:          equ    6                                         ; Mode Select Bit B
MODE_MODC:          equ    7                                         ; Mode Select Bit C
; bit position masks
mMODE_EME:          equ    %00000001
mMODE_EMK:          equ    %00000010
mMODE_IVIS:         equ    %00001000
mMODE_MODA:         equ    %00100000
mMODE_MODB:         equ    %01000000
mMODE_MODC:         equ    %10000000


;*** PUCR - Pull-Up Control Register; 0x0000000C ***
PUCR:               equ    $0000000C                                ;*** PUCR - Pull-Up Control Register; 0x0000000C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PUCR_PUPAE:         equ    0                                         ; Pull-Up Port A Enable
PUCR_PUPBE:         equ    1                                         ; Pull-Up Port B Enable
PUCR_PUPEE:         equ    4                                         ; Pull-Up Port E Enable
PUCR_PUPKE:         equ    7                                         ; Pull-Up Port K Enable
; bit position masks
mPUCR_PUPAE:        equ    %00000001
mPUCR_PUPBE:        equ    %00000010
mPUCR_PUPEE:        equ    %00010000
mPUCR_PUPKE:        equ    %10000000


;*** RDRIV - Reduced Drive of I/O Lines; 0x0000000D ***
RDRIV:              equ    $0000000D                                ;*** RDRIV - Reduced Drive of I/O Lines; 0x0000000D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RDRIV_RDPA:         equ    0                                         ; Reduced Drive of Port A
RDRIV_RDPB:         equ    1                                         ; Reduced Drive of Port B
RDRIV_RDPE:         equ    4                                         ; Reduced Drive of Port E
RDRIV_RDPK:         equ    7                                         ; Reduced Drive of Port K
; bit position masks
mRDRIV_RDPA:        equ    %00000001
mRDRIV_RDPB:        equ    %00000010
mRDRIV_RDPE:        equ    %00010000
mRDRIV_RDPK:        equ    %10000000


;*** EBICTL - External Bus Interface Control; 0x0000000E ***
EBICTL:             equ    $0000000E                                ;*** EBICTL - External Bus Interface Control; 0x0000000E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
EBICTL_ESTR:        equ    0                                         ; E Stretches
; bit position masks
mEBICTL_ESTR:       equ    %00000001


;*** INITRM - Initialization of Internal RAM Position Register; 0x00000010 ***
INITRM:             equ    $00000010                                ;*** INITRM - Initialization of Internal RAM Position Register; 0x00000010 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
INITRM_RAMHAL:      equ    0                                         ; Internal RAM map alignment
INITRM_RAM11:       equ    3                                         ; Internal RAM map position Bit 11
INITRM_RAM12:       equ    4                                         ; Internal RAM map position Bit 12
INITRM_RAM13:       equ    5                                         ; Internal RAM map position Bit 13
INITRM_RAM14:       equ    6                                         ; Internal RAM map position Bit 14
INITRM_RAM15:       equ    7                                         ; Internal RAM map position Bit 15
; bit position masks
mINITRM_RAMHAL:     equ    %00000001
mINITRM_RAM11:      equ    %00001000
mINITRM_RAM12:      equ    %00010000
mINITRM_RAM13:      equ    %00100000
mINITRM_RAM14:      equ    %01000000
mINITRM_RAM15:      equ    %10000000


;*** INITRG - Initialization of Internal Registers Position Register; 0x00000011 ***
INITRG:             equ    $00000011                                ;*** INITRG - Initialization of Internal Registers Position Register; 0x00000011 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
INITRG_REG11:       equ    3                                         ; Internal Registers Map Position Bit 11
INITRG_REG12:       equ    4                                         ; Internal Registers Map Position Bit 12
INITRG_REG13:       equ    5                                         ; Internal Registers Map Position Bit 13
INITRG_REG14:       equ    6                                         ; Internal Registers Map Position Bit 14
; bit position masks
mINITRG_REG11:      equ    %00001000
mINITRG_REG12:      equ    %00010000
mINITRG_REG13:      equ    %00100000
mINITRG_REG14:      equ    %01000000


;*** MISC - Miscellaneous System Control Register; 0x00000013 ***
MISC:               equ    $00000013                                ;*** MISC - Miscellaneous System Control Register; 0x00000013 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MISC_ROMON:         equ    0                                         ; Enable Flash EEPROM
MISC_ROMHM:         equ    1                                         ; Flash EEPROM only in second half of memory map
MISC_EXSTR0:        equ    2                                         ; External Access Stretch Bit 0
MISC_EXSTR1:        equ    3                                         ; External Access Stretch Bit 1
; bit position masks
mMISC_ROMON:        equ    %00000001
mMISC_ROMHM:        equ    %00000010
mMISC_EXSTR0:       equ    %00000100
mMISC_EXSTR1:       equ    %00001000


;*** ITCR - Interrupt Test Control Register; 0x00000015 ***
ITCR:               equ    $00000015                                ;*** ITCR - Interrupt Test Control Register; 0x00000015 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ITCR_ADR0:          equ    0                                         ; Test register select Bit 0
ITCR_ADR1:          equ    1                                         ; Test register select Bit 1
ITCR_ADR2:          equ    2                                         ; Test register select Bit 2
ITCR_ADR3:          equ    3                                         ; Test register select Bit 3
ITCR_WRTINT:        equ    4                                         ; Write to the Interrupt Test Registers
; bit position masks
mITCR_ADR0:         equ    %00000001
mITCR_ADR1:         equ    %00000010
mITCR_ADR2:         equ    %00000100
mITCR_ADR3:         equ    %00001000
mITCR_WRTINT:       equ    %00010000


;*** ITEST - Interrupt Test Register; 0x00000016 ***
ITEST:              equ    $00000016                                ;*** ITEST - Interrupt Test Register; 0x00000016 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ITEST_INT0:         equ    0                                         ; Interrupt Test Register Bit 0
ITEST_INT2:         equ    1                                         ; Interrupt Test Register Bit 1
ITEST_INT4:         equ    2                                         ; Interrupt Test Register Bit 2
ITEST_INT6:         equ    3                                         ; Interrupt Test Register Bit 3
ITEST_INT8:         equ    4                                         ; Interrupt Test Register Bit 4
ITEST_INTA:         equ    5                                         ; Interrupt Test Register Bit 5
ITEST_INTC:         equ    6                                         ; Interrupt Test Register Bit 6
ITEST_INTE:         equ    7                                         ; Interrupt Test Register Bit 7
; bit position masks
mITEST_INT0:        equ    %00000001
mITEST_INT2:        equ    %00000010
mITEST_INT4:        equ    %00000100
mITEST_INT6:        equ    %00001000
mITEST_INT8:        equ    %00010000
mITEST_INTA:        equ    %00100000
mITEST_INTC:        equ    %01000000
mITEST_INTE:        equ    %10000000


;*** VREGCTRL - VREG_3V3 - Control Register; 0x00000019 ***
VREGCTRL:           equ    $00000019                                ;*** VREGCTRL - VREG_3V3 - Control Register; 0x00000019 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
VREGCTRL_LVIF:      equ    0                                         ; Low Voltage Interrupt Flag
VREGCTRL_LVIE:      equ    1                                         ; Low Voltage Interrupt Enable Bit
VREGCTRL_LVDS:      equ    2                                         ; Low Voltage Detect Status Bit
; bit position masks
mVREGCTRL_LVIF:     equ    %00000001
mVREGCTRL_LVIE:     equ    %00000010
mVREGCTRL_LVDS:     equ    %00000100


;*** PARTID - Part ID Register; 0x0000001A ***
PARTID:             equ    $0000001A                                ;*** PARTID - Part ID Register; 0x0000001A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PARTID_ID0:         equ    0                                         ; Part ID Register Bit 0
PARTID_ID1:         equ    1                                         ; Part ID Register Bit 1
PARTID_ID2:         equ    2                                         ; Part ID Register Bit 2
PARTID_ID3:         equ    3                                         ; Part ID Register Bit 3
PARTID_ID4:         equ    4                                         ; Part ID Register Bit 4
PARTID_ID5:         equ    5                                         ; Part ID Register Bit 5
PARTID_ID6:         equ    6                                         ; Part ID Register Bit 6
PARTID_ID7:         equ    7                                         ; Part ID Register Bit 7
PARTID_ID8:         equ    8                                         ; Part ID Register Bit 8
PARTID_ID9:         equ    9                                         ; Part ID Register Bit 9
PARTID_ID10:        equ    10                                        ; Part ID Register Bit 10
PARTID_ID11:        equ    11                                        ; Part ID Register Bit 11
PARTID_ID12:        equ    12                                        ; Part ID Register Bit 12
PARTID_ID13:        equ    13                                        ; Part ID Register Bit 13
PARTID_ID14:        equ    14                                        ; Part ID Register Bit 14
PARTID_ID15:        equ    15                                        ; Part ID Register Bit 15
; bit position masks
mPARTID_ID0:        equ    %00000001
mPARTID_ID1:        equ    %00000010
mPARTID_ID2:        equ    %00000100
mPARTID_ID3:        equ    %00001000
mPARTID_ID4:        equ    %00010000
mPARTID_ID5:        equ    %00100000
mPARTID_ID6:        equ    %01000000
mPARTID_ID7:        equ    %10000000
mPARTID_ID8:        equ    %100000000
mPARTID_ID9:        equ    %1000000000
mPARTID_ID10:       equ    %10000000000
mPARTID_ID11:       equ    %100000000000
mPARTID_ID12:       equ    %1000000000000
mPARTID_ID13:       equ    %10000000000000
mPARTID_ID14:       equ    %100000000000000
mPARTID_ID15:       equ    %1000000000000000


;*** PARTIDH - Part ID Register High; 0x0000001A ***
PARTIDH:            equ    $0000001A                                ;*** PARTIDH - Part ID Register High; 0x0000001A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PARTIDH_ID8:        equ    0                                         ; Part ID Register Bit 8
PARTIDH_ID9:        equ    1                                         ; Part ID Register Bit 9
PARTIDH_ID10:       equ    2                                         ; Part ID Register Bit 10
PARTIDH_ID11:       equ    3                                         ; Part ID Register Bit 11
PARTIDH_ID12:       equ    4                                         ; Part ID Register Bit 12
PARTIDH_ID13:       equ    5                                         ; Part ID Register Bit 13
PARTIDH_ID14:       equ    6                                         ; Part ID Register Bit 14
PARTIDH_ID15:       equ    7                                         ; Part ID Register Bit 15
; bit position masks
mPARTIDH_ID8:       equ    %00000001
mPARTIDH_ID9:       equ    %00000010
mPARTIDH_ID10:      equ    %00000100
mPARTIDH_ID11:      equ    %00001000
mPARTIDH_ID12:      equ    %00010000
mPARTIDH_ID13:      equ    %00100000
mPARTIDH_ID14:      equ    %01000000
mPARTIDH_ID15:      equ    %10000000


;*** PARTIDL - Part ID Register Low; 0x0000001B ***
PARTIDL:            equ    $0000001B                                ;*** PARTIDL - Part ID Register Low; 0x0000001B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PARTIDL_ID0:        equ    0                                         ; Part ID Register Bit 0
PARTIDL_ID1:        equ    1                                         ; Part ID Register Bit 1
PARTIDL_ID2:        equ    2                                         ; Part ID Register Bit 2
PARTIDL_ID3:        equ    3                                         ; Part ID Register Bit 3
PARTIDL_ID4:        equ    4                                         ; Part ID Register Bit 4
PARTIDL_ID5:        equ    5                                         ; Part ID Register Bit 5
PARTIDL_ID6:        equ    6                                         ; Part ID Register Bit 6
PARTIDL_ID7:        equ    7                                         ; Part ID Register Bit 7
; bit position masks
mPARTIDL_ID0:       equ    %00000001
mPARTIDL_ID1:       equ    %00000010
mPARTIDL_ID2:       equ    %00000100
mPARTIDL_ID3:       equ    %00001000
mPARTIDL_ID4:       equ    %00010000
mPARTIDL_ID5:       equ    %00100000
mPARTIDL_ID6:       equ    %01000000
mPARTIDL_ID7:       equ    %10000000


;*** MEMSIZ0 - Memory Size Register Zero; 0x0000001C ***
MEMSIZ0:            equ    $0000001C                                ;*** MEMSIZ0 - Memory Size Register Zero; 0x0000001C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MEMSIZ0_ram_sw0:    equ    0                                         ; Allocated System RAM Memory Space Bit 0
MEMSIZ0_ram_sw1:    equ    1                                         ; Allocated System RAM Memory Space Bit 1
MEMSIZ0_ram_sw2:    equ    2                                         ; Allocated System RAM Memory Space Bit 2
MEMSIZ0_eep_sw0:    equ    4                                         ; Allocated EEPROM Memory Space Bit 0
MEMSIZ0_eep_sw1:    equ    5                                         ; Allocated EEPROM Memory Space Bit 1
MEMSIZ0_reg_sw0:    equ    7                                         ; Allocated System Register Space
; bit position masks
mMEMSIZ0_ram_sw0:   equ    %00000001
mMEMSIZ0_ram_sw1:   equ    %00000010
mMEMSIZ0_ram_sw2:   equ    %00000100
mMEMSIZ0_eep_sw0:   equ    %00010000
mMEMSIZ0_eep_sw1:   equ    %00100000
mMEMSIZ0_reg_sw0:   equ    %10000000


;*** MEMSIZ1 - Memory Size Register One; 0x0000001D ***
MEMSIZ1:            equ    $0000001D                                ;*** MEMSIZ1 - Memory Size Register One; 0x0000001D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MEMSIZ1_pag_sw0:    equ    0                                         ; Allocated Off-Chip Memory Options Bit 0
MEMSIZ1_pag_sw1:    equ    1                                         ; Allocated Off-Chip Memory Options Bit 1
MEMSIZ1_rom_sw0:    equ    6                                         ; Allocated Flash EEPROM/ROM Physical Memory Space Bit 0
MEMSIZ1_rom_sw1:    equ    7                                         ; Allocated Flash EEPROM/ROM Physical Memory Space Bit 1
; bit position masks
mMEMSIZ1_pag_sw0:   equ    %00000001
mMEMSIZ1_pag_sw1:   equ    %00000010
mMEMSIZ1_rom_sw0:   equ    %01000000
mMEMSIZ1_rom_sw1:   equ    %10000000


;*** INTCR - Interrupt Control Register; 0x0000001E ***
INTCR:              equ    $0000001E                                ;*** INTCR - Interrupt Control Register; 0x0000001E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
INTCR_IRQEN:        equ    6                                         ; External IRQ Enable
INTCR_IRQE:         equ    7                                         ; IRQ Select Edge Sensitive Only
; bit position masks
mINTCR_IRQEN:       equ    %01000000
mINTCR_IRQE:        equ    %10000000


;*** HPRIO - Highest Priority I Interrupt; 0x0000001F ***
HPRIO:              equ    $0000001F                                ;*** HPRIO - Highest Priority I Interrupt; 0x0000001F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
HPRIO_PSEL1:        equ    1                                         ; Highest Priority I Interrupt Bit 1
HPRIO_PSEL2:        equ    2                                         ; Highest Priority I Interrupt Bit 2
HPRIO_PSEL3:        equ    3                                         ; Highest Priority I Interrupt Bit 3
HPRIO_PSEL4:        equ    4                                         ; Highest Priority I Interrupt Bit 4
HPRIO_PSEL5:        equ    5                                         ; Highest Priority I Interrupt Bit 5
HPRIO_PSEL6:        equ    6                                         ; Highest Priority I Interrupt Bit 6
HPRIO_PSEL7:        equ    7                                         ; Highest Priority I Interrupt Bit 7
; bit position masks
mHPRIO_PSEL1:       equ    %00000010
mHPRIO_PSEL2:       equ    %00000100
mHPRIO_PSEL3:       equ    %00001000
mHPRIO_PSEL4:       equ    %00010000
mHPRIO_PSEL5:       equ    %00100000
mHPRIO_PSEL6:       equ    %01000000
mHPRIO_PSEL7:       equ    %10000000


;*** DBGC1 - Debug Control Register 1; 0x00000020 ***
DBGC1:              equ    $00000020                                ;*** DBGC1 - Debug Control Register 1; 0x00000020 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGC1_CAPMOD0:      equ    0                                         ; Capture Mode Field, bit 0
DBGC1_CAPMOD1:      equ    1                                         ; Capture Mode Field, bit 1
DBGC1_DBGBRK:       equ    3                                         ; DBG Breakpoint Enable Bit
DBGC1_BEGIN:        equ    4                                         ; Begin/End Trigger Bit
DBGC1_TRGSEL:       equ    5                                         ; Trigger Selection Bit
DBGC1_ARM:          equ    6                                         ; Arm Bit
DBGC1_DBGEN:        equ    7                                         ; DBG Mode Enable Bit
; bit position masks
mDBGC1_CAPMOD0:     equ    %00000001
mDBGC1_CAPMOD1:     equ    %00000010
mDBGC1_DBGBRK:      equ    %00001000
mDBGC1_BEGIN:       equ    %00010000
mDBGC1_TRGSEL:      equ    %00100000
mDBGC1_ARM:         equ    %01000000
mDBGC1_DBGEN:       equ    %10000000


;*** DBGSC - Debug Status and Control Register; 0x00000021 ***
DBGSC:              equ    $00000021                                ;*** DBGSC - Debug Status and Control Register; 0x00000021 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGSC_TRG0:         equ    0                                         ; Trigger Mode Bits, bit 0
DBGSC_TRG1:         equ    1                                         ; Trigger Mode Bits, bit 1
DBGSC_TRG2:         equ    2                                         ; Trigger Mode Bits, bit 2
DBGSC_TRG3:         equ    3                                         ; Trigger Mode Bits, bit 3
DBGSC_CF:           equ    5                                         ; Comparator C Match Flag
DBGSC_BF:           equ    6                                         ; Trigger B Match Flag
DBGSC_AF:           equ    7                                         ; Trigger A Match Flag
; bit position masks
mDBGSC_TRG0:        equ    %00000001
mDBGSC_TRG1:        equ    %00000010
mDBGSC_TRG2:        equ    %00000100
mDBGSC_TRG3:        equ    %00001000
mDBGSC_CF:          equ    %00100000
mDBGSC_BF:          equ    %01000000
mDBGSC_AF:          equ    %10000000


;*** DBGTB - Debug Trace Buffer Register; 0x00000022 ***
DBGTB:              equ    $00000022                                ;*** DBGTB - Debug Trace Buffer Register; 0x00000022 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGTB_BIT0:         equ    0                                         ; Trace Buffer Data Bit 0
DBGTB_BIT1:         equ    1                                         ; Trace Buffer Data Bit 1
DBGTB_BIT2:         equ    2                                         ; Trace Buffer Data Bit 2
DBGTB_BIT3:         equ    3                                         ; Trace Buffer Data Bit 3
DBGTB_BIT4:         equ    4                                         ; Trace Buffer Data Bit 4
DBGTB_BIT5:         equ    5                                         ; Trace Buffer Data Bit 5
DBGTB_BIT6:         equ    6                                         ; Trace Buffer Data Bit 6
DBGTB_BIT7:         equ    7                                         ; Trace Buffer Data Bit 7
DBGTB_BIT8:         equ    8                                         ; Trace Buffer Data Bit 8
DBGTB_BIT9:         equ    9                                         ; Trace Buffer Data Bit 9
DBGTB_BIT10:        equ    10                                        ; Trace Buffer Data Bit 10
DBGTB_BIT11:        equ    11                                        ; Trace Buffer Data Bit 11
DBGTB_BIT12:        equ    12                                        ; Trace Buffer Data Bit 12
DBGTB_BIT13:        equ    13                                        ; Trace Buffer Data Bit 13
DBGTB_BIT14:        equ    14                                        ; Trace Buffer Data Bit 14
DBGTB_BIT15:        equ    15                                        ; Trace Buffer Data Bit 15
; bit position masks
mDBGTB_BIT0:        equ    %00000001
mDBGTB_BIT1:        equ    %00000010
mDBGTB_BIT2:        equ    %00000100
mDBGTB_BIT3:        equ    %00001000
mDBGTB_BIT4:        equ    %00010000
mDBGTB_BIT5:        equ    %00100000
mDBGTB_BIT6:        equ    %01000000
mDBGTB_BIT7:        equ    %10000000
mDBGTB_BIT8:        equ    %100000000
mDBGTB_BIT9:        equ    %1000000000
mDBGTB_BIT10:       equ    %10000000000
mDBGTB_BIT11:       equ    %100000000000
mDBGTB_BIT12:       equ    %1000000000000
mDBGTB_BIT13:       equ    %10000000000000
mDBGTB_BIT14:       equ    %100000000000000
mDBGTB_BIT15:       equ    %1000000000000000


;*** DBGTBH - Debug Trace Buffer Register High; 0x00000022 ***
DBGTBH:             equ    $00000022                                ;*** DBGTBH - Debug Trace Buffer Register High; 0x00000022 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGTBH_BIT8:        equ    0                                         ; Trace Buffer Data Bit 8
DBGTBH_BIT9:        equ    1                                         ; Trace Buffer Data Bit 9
DBGTBH_BIT10:       equ    2                                         ; Trace Buffer Data Bit 10
DBGTBH_BIT11:       equ    3                                         ; Trace Buffer Data Bit 11
DBGTBH_BIT12:       equ    4                                         ; Trace Buffer Data Bit 12
DBGTBH_BIT13:       equ    5                                         ; Trace Buffer Data Bit 13
DBGTBH_BIT14:       equ    6                                         ; Trace Buffer Data Bit 14
DBGTBH_BIT15:       equ    7                                         ; Trace Buffer Data Bit 15
; bit position masks
mDBGTBH_BIT8:       equ    %00000001
mDBGTBH_BIT9:       equ    %00000010
mDBGTBH_BIT10:      equ    %00000100
mDBGTBH_BIT11:      equ    %00001000
mDBGTBH_BIT12:      equ    %00010000
mDBGTBH_BIT13:      equ    %00100000
mDBGTBH_BIT14:      equ    %01000000
mDBGTBH_BIT15:      equ    %10000000


;*** DBGTBL - Debug Trace Buffer Register Low; 0x00000023 ***
DBGTBL:             equ    $00000023                                ;*** DBGTBL - Debug Trace Buffer Register Low; 0x00000023 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGTBL_BIT0:        equ    0                                         ; Trace Buffer Data Bit 0
DBGTBL_BIT1:        equ    1                                         ; Trace Buffer Data Bit 1
DBGTBL_BIT2:        equ    2                                         ; Trace Buffer Data Bit 2
DBGTBL_BIT3:        equ    3                                         ; Trace Buffer Data Bit 3
DBGTBL_BIT4:        equ    4                                         ; Trace Buffer Data Bit 4
DBGTBL_BIT5:        equ    5                                         ; Trace Buffer Data Bit 5
DBGTBL_BIT6:        equ    6                                         ; Trace Buffer Data Bit 6
DBGTBL_BIT7:        equ    7                                         ; Trace Buffer Data Bit 7
; bit position masks
mDBGTBL_BIT0:       equ    %00000001
mDBGTBL_BIT1:       equ    %00000010
mDBGTBL_BIT2:       equ    %00000100
mDBGTBL_BIT3:       equ    %00001000
mDBGTBL_BIT4:       equ    %00010000
mDBGTBL_BIT5:       equ    %00100000
mDBGTBL_BIT6:       equ    %01000000
mDBGTBL_BIT7:       equ    %10000000


;*** DBGCNT - Debug Count Register; 0x00000024 ***
DBGCNT:             equ    $00000024                                ;*** DBGCNT - Debug Count Register; 0x00000024 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGCNT_CNT0:        equ    0                                         ; Count Value, bit 0
DBGCNT_CNT1:        equ    1                                         ; Count Value, bit 1
DBGCNT_CNT2:        equ    2                                         ; Count Value, bit 2
DBGCNT_CNT3:        equ    3                                         ; Count Value, bit 3
DBGCNT_CNT4:        equ    4                                         ; Count Value, bit 4
DBGCNT_CNT5:        equ    5                                         ; Count Value, bit 5
DBGCNT_TBF:         equ    7                                         ; Trace Buffer Full
; bit position masks
mDBGCNT_CNT0:       equ    %00000001
mDBGCNT_CNT1:       equ    %00000010
mDBGCNT_CNT2:       equ    %00000100
mDBGCNT_CNT3:       equ    %00001000
mDBGCNT_CNT4:       equ    %00010000
mDBGCNT_CNT5:       equ    %00100000
mDBGCNT_TBF:        equ    %10000000


;*** DBGCCX - Debug Comparator C Extended Register; 0x00000025 ***
DBGCCX:             equ    $00000025                                ;*** DBGCCX - Debug Comparator C Extended Register; 0x00000025 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGCCX_EXTCMP0:     equ    0                                         ; Comparator C Extended Compare Bits, bit 0
DBGCCX_EXTCMP1:     equ    1                                         ; Comparator C Extended Compare Bits, bit 1
DBGCCX_EXTCMP2:     equ    2                                         ; Comparator C Extended Compare Bits, bit 2
DBGCCX_EXTCMP3:     equ    3                                         ; Comparator C Extended Compare Bits, bit 3
DBGCCX_EXTCMP4:     equ    4                                         ; Comparator C Extended Compare Bits, bit 4
DBGCCX_EXTCMP5:     equ    5                                         ; Comparator C Extended Compare Bits, bit 5
DBGCCX_PAGSEL0:     equ    6                                         ; Page Selector Field, bit 0
DBGCCX_PAGSEL1:     equ    7                                         ; Page Selector Field, bit 1
; bit position masks
mDBGCCX_EXTCMP0:    equ    %00000001
mDBGCCX_EXTCMP1:    equ    %00000010
mDBGCCX_EXTCMP2:    equ    %00000100
mDBGCCX_EXTCMP3:    equ    %00001000
mDBGCCX_EXTCMP4:    equ    %00010000
mDBGCCX_EXTCMP5:    equ    %00100000
mDBGCCX_PAGSEL0:    equ    %01000000
mDBGCCX_PAGSEL1:    equ    %10000000


;*** DBGCC - Debug Comparator C Register; 0x00000026 ***
DBGCC:              equ    $00000026                                ;*** DBGCC - Debug Comparator C Register; 0x00000026 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGCC_BIT0:         equ    0                                         ; Comparator C Compare Bit 0
DBGCC_BIT1:         equ    1                                         ; Comparator C Compare Bit 1
DBGCC_BIT2:         equ    2                                         ; Comparator C Compare Bit 2
DBGCC_BIT3:         equ    3                                         ; Comparator C Compare Bit 3
DBGCC_BIT4:         equ    4                                         ; Comparator C Compare Bit 4
DBGCC_BIT5:         equ    5                                         ; Comparator C Compare Bit 5
DBGCC_BIT6:         equ    6                                         ; Comparator C Compare Bit 6
DBGCC_BIT7:         equ    7                                         ; Comparator C Compare Bit 7
DBGCC_BIT8:         equ    8                                         ; Comparator C Compare Bit 8
DBGCC_BIT9:         equ    9                                         ; Comparator C Compare Bit 9
DBGCC_BIT10:        equ    10                                        ; Comparator C Compare Bit 10
DBGCC_BIT11:        equ    11                                        ; Comparator C Compare Bit 11
DBGCC_BIT12:        equ    12                                        ; Comparator C Compare Bit 12
DBGCC_BIT13:        equ    13                                        ; Comparator C Compare Bit 13
DBGCC_BIT14:        equ    14                                        ; Comparator C Compare Bit 14
DBGCC_BIT15:        equ    15                                        ; Comparator C Compare Bit 15
; bit position masks
mDBGCC_BIT0:        equ    %00000001
mDBGCC_BIT1:        equ    %00000010
mDBGCC_BIT2:        equ    %00000100
mDBGCC_BIT3:        equ    %00001000
mDBGCC_BIT4:        equ    %00010000
mDBGCC_BIT5:        equ    %00100000
mDBGCC_BIT6:        equ    %01000000
mDBGCC_BIT7:        equ    %10000000
mDBGCC_BIT8:        equ    %100000000
mDBGCC_BIT9:        equ    %1000000000
mDBGCC_BIT10:       equ    %10000000000
mDBGCC_BIT11:       equ    %100000000000
mDBGCC_BIT12:       equ    %1000000000000
mDBGCC_BIT13:       equ    %10000000000000
mDBGCC_BIT14:       equ    %100000000000000
mDBGCC_BIT15:       equ    %1000000000000000


;*** DBGCCH - Debug Comparator C Register High; 0x00000026 ***
DBGCCH:             equ    $00000026                                ;*** DBGCCH - Debug Comparator C Register High; 0x00000026 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGCCH_BIT8:        equ    0                                         ; Comparator C Compare Bit 8
DBGCCH_BIT9:        equ    1                                         ; Comparator C Compare Bit 9
DBGCCH_BIT10:       equ    2                                         ; Comparator C Compare Bit 10
DBGCCH_BIT11:       equ    3                                         ; Comparator C Compare Bit 11
DBGCCH_BIT12:       equ    4                                         ; Comparator C Compare Bit 12
DBGCCH_BIT13:       equ    5                                         ; Comparator C Compare Bit 13
DBGCCH_BIT14:       equ    6                                         ; Comparator C Compare Bit 14
DBGCCH_BIT15:       equ    7                                         ; Comparator C Compare Bit 15
; bit position masks
mDBGCCH_BIT8:       equ    %00000001
mDBGCCH_BIT9:       equ    %00000010
mDBGCCH_BIT10:      equ    %00000100
mDBGCCH_BIT11:      equ    %00001000
mDBGCCH_BIT12:      equ    %00010000
mDBGCCH_BIT13:      equ    %00100000
mDBGCCH_BIT14:      equ    %01000000
mDBGCCH_BIT15:      equ    %10000000


;*** DBGCCL - Debug Comparator C Register Low; 0x00000027 ***
DBGCCL:             equ    $00000027                                ;*** DBGCCL - Debug Comparator C Register Low; 0x00000027 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGCCL_BIT0:        equ    0                                         ; Comparator C Compare Bit 0
DBGCCL_BIT1:        equ    1                                         ; Comparator C Compare Bit 1
DBGCCL_BIT2:        equ    2                                         ; Comparator C Compare Bit 2
DBGCCL_BIT3:        equ    3                                         ; Comparator C Compare Bit 3
DBGCCL_BIT4:        equ    4                                         ; Comparator C Compare Bit 4
DBGCCL_BIT5:        equ    5                                         ; Comparator C Compare Bit 5
DBGCCL_BIT6:        equ    6                                         ; Comparator C Compare Bit 6
DBGCCL_BIT7:        equ    7                                         ; Comparator C Compare Bit 7
; bit position masks
mDBGCCL_BIT0:       equ    %00000001
mDBGCCL_BIT1:       equ    %00000010
mDBGCCL_BIT2:       equ    %00000100
mDBGCCL_BIT3:       equ    %00001000
mDBGCCL_BIT4:       equ    %00010000
mDBGCCL_BIT5:       equ    %00100000
mDBGCCL_BIT6:       equ    %01000000
mDBGCCL_BIT7:       equ    %10000000


;*** DBGC2 - Debug Control Register 2; 0x00000028 ***
DBGC2:              equ    $00000028                                ;*** DBGC2 - Debug Control Register 2; 0x00000028 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGC2_RWC:          equ    0                                         ; Read/Write Comparator C Value Bit
DBGC2_RWCEN:        equ    1                                         ; Read/Write Comparator C Enable Bit
DBGC2_TAGC:         equ    2                                         ; Comparator C Tag Select
DBGC2_BKCEN:        equ    3                                         ; Breakpoint Comparator C Enable Bit
DBGC2_TAGAB:        equ    4                                         ; Comparator A/B Tag Select
DBGC2_BDM:          equ    5                                         ; Background Debug Mode Enable
DBGC2_FULL:         equ    6                                         ; Full Breakpoint Mode Enable
DBGC2_BKABEN:       equ    7                                         ; Breakpoint Using Comparator A and B Enable
; bit position masks
mDBGC2_RWC:         equ    %00000001
mDBGC2_RWCEN:       equ    %00000010
mDBGC2_TAGC:        equ    %00000100
mDBGC2_BKCEN:       equ    %00001000
mDBGC2_TAGAB:       equ    %00010000
mDBGC2_BDM:         equ    %00100000
mDBGC2_FULL:        equ    %01000000
mDBGC2_BKABEN:      equ    %10000000


;*** DBGC3 - Debug Control Register 3; 0x00000029 ***
DBGC3:              equ    $00000029                                ;*** DBGC3 - Debug Control Register 3; 0x00000029 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGC3_RWB:          equ    0                                         ; Read/Write Comparator B Value Bit
DBGC3_RWBEN:        equ    1                                         ; Read/Write Comparator B Enable Bit
DBGC3_RWA:          equ    2                                         ; Read/Write Comparator A Value Bit
DBGC3_RWAEN:        equ    3                                         ; Read/Write Comparator A Enable Bit
DBGC3_BKBMBL:       equ    4                                         ; Breakpoint Mask Low Byte for Second Address
DBGC3_BKBMBH:       equ    5                                         ; Breakpoint Mask High Byte for Second Address
DBGC3_BKAMBL:       equ    6                                         ; Breakpoint Mask Low Byte for First Address
DBGC3_BKAMBH:       equ    7                                         ; Breakpoint Mask High Byte for First Address
; bit position masks
mDBGC3_RWB:         equ    %00000001
mDBGC3_RWBEN:       equ    %00000010
mDBGC3_RWA:         equ    %00000100
mDBGC3_RWAEN:       equ    %00001000
mDBGC3_BKBMBL:      equ    %00010000
mDBGC3_BKBMBH:      equ    %00100000
mDBGC3_BKAMBL:      equ    %01000000
mDBGC3_BKAMBH:      equ    %10000000


;*** DBGCAX - Debug Comparator A Extended Register; 0x0000002A ***
DBGCAX:             equ    $0000002A                                ;*** DBGCAX - Debug Comparator A Extended Register; 0x0000002A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGCAX_EXTCMP0:     equ    0                                         ; Comparator A Extended Compare Bits, bit 0
DBGCAX_EXTCMP1:     equ    1                                         ; Comparator A Extended Compare Bits, bit 1
DBGCAX_EXTCMP2:     equ    2                                         ; Comparator A Extended Compare Bits, bit 2
DBGCAX_EXTCMP3:     equ    3                                         ; Comparator A Extended Compare Bits, bit 3
DBGCAX_EXTCMP4:     equ    4                                         ; Comparator A Extended Compare Bits, bit 4
DBGCAX_EXTCMP5:     equ    5                                         ; Comparator A Extended Compare Bits, bit 5
DBGCAX_PAGSEL0:     equ    6                                         ; Page Selector Field, bit 0
DBGCAX_PAGSEL1:     equ    7                                         ; Page Selector Field, bit 1
; bit position masks
mDBGCAX_EXTCMP0:    equ    %00000001
mDBGCAX_EXTCMP1:    equ    %00000010
mDBGCAX_EXTCMP2:    equ    %00000100
mDBGCAX_EXTCMP3:    equ    %00001000
mDBGCAX_EXTCMP4:    equ    %00010000
mDBGCAX_EXTCMP5:    equ    %00100000
mDBGCAX_PAGSEL0:    equ    %01000000
mDBGCAX_PAGSEL1:    equ    %10000000


;*** DBGCA - Debug Comparator A Register; 0x0000002B ***
DBGCA:              equ    $0000002B                                ;*** DBGCA - Debug Comparator A Register; 0x0000002B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGCA_BIT0:         equ    0                                         ; Comparator A Compare Bit 0
DBGCA_BIT1:         equ    1                                         ; Comparator A Compare Bit 1
DBGCA_BIT2:         equ    2                                         ; Comparator A Compare Bit 2
DBGCA_BIT3:         equ    3                                         ; Comparator A Compare Bit 3
DBGCA_BIT4:         equ    4                                         ; Comparator A Compare Bit 4
DBGCA_BIT5:         equ    5                                         ; Comparator A Compare Bit 5
DBGCA_BIT6:         equ    6                                         ; Comparator A Compare Bit 6
DBGCA_BIT7:         equ    7                                         ; Comparator A Compare Bit 7
DBGCA_BIT8:         equ    8                                         ; Comparator A Compare Bit 8
DBGCA_BIT9:         equ    9                                         ; Comparator A Compare Bit 9
DBGCA_BIT10:        equ    10                                        ; Comparator A Compare Bit 10
DBGCA_BIT11:        equ    11                                        ; Comparator A Compare Bit 11
DBGCA_BIT12:        equ    12                                        ; Comparator A Compare Bit 12
DBGCA_BIT13:        equ    13                                        ; Comparator A Compare Bit 13
DBGCA_BIT14:        equ    14                                        ; Comparator A Compare Bit 14
DBGCA_BIT15:        equ    15                                        ; Comparator A Compare Bit 15
; bit position masks
mDBGCA_BIT0:        equ    %00000001
mDBGCA_BIT1:        equ    %00000010
mDBGCA_BIT2:        equ    %00000100
mDBGCA_BIT3:        equ    %00001000
mDBGCA_BIT4:        equ    %00010000
mDBGCA_BIT5:        equ    %00100000
mDBGCA_BIT6:        equ    %01000000
mDBGCA_BIT7:        equ    %10000000
mDBGCA_BIT8:        equ    %100000000
mDBGCA_BIT9:        equ    %1000000000
mDBGCA_BIT10:       equ    %10000000000
mDBGCA_BIT11:       equ    %100000000000
mDBGCA_BIT12:       equ    %1000000000000
mDBGCA_BIT13:       equ    %10000000000000
mDBGCA_BIT14:       equ    %100000000000000
mDBGCA_BIT15:       equ    %1000000000000000


;*** DBGCAH - Debug Comparator A Register High; 0x0000002B ***
DBGCAH:             equ    $0000002B                                ;*** DBGCAH - Debug Comparator A Register High; 0x0000002B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGCAH_BIT8:        equ    0                                         ; Comparator A Compare Bit 8
DBGCAH_BIT9:        equ    1                                         ; Comparator A Compare Bit 9
DBGCAH_BIT10:       equ    2                                         ; Comparator A Compare Bit 10
DBGCAH_BIT11:       equ    3                                         ; Comparator A Compare Bit 11
DBGCAH_BIT12:       equ    4                                         ; Comparator A Compare Bit 12
DBGCAH_BIT13:       equ    5                                         ; Comparator A Compare Bit 13
DBGCAH_BIT14:       equ    6                                         ; Comparator A Compare Bit 14
DBGCAH_BIT15:       equ    7                                         ; Comparator A Compare Bit 15
; bit position masks
mDBGCAH_BIT8:       equ    %00000001
mDBGCAH_BIT9:       equ    %00000010
mDBGCAH_BIT10:      equ    %00000100
mDBGCAH_BIT11:      equ    %00001000
mDBGCAH_BIT12:      equ    %00010000
mDBGCAH_BIT13:      equ    %00100000
mDBGCAH_BIT14:      equ    %01000000
mDBGCAH_BIT15:      equ    %10000000


;*** DBGCAL - Debug Comparator A Register Low; 0x0000002C ***
DBGCAL:             equ    $0000002C                                ;*** DBGCAL - Debug Comparator A Register Low; 0x0000002C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGCAL_BIT0:        equ    0                                         ; Comparator A Compare Bit 0
DBGCAL_BIT1:        equ    1                                         ; Comparator A Compare Bit 1
DBGCAL_BIT2:        equ    2                                         ; Comparator A Compare Bit 2
DBGCAL_BIT3:        equ    3                                         ; Comparator A Compare Bit 3
DBGCAL_BIT4:        equ    4                                         ; Comparator A Compare Bit 4
DBGCAL_BIT5:        equ    5                                         ; Comparator A Compare Bit 5
DBGCAL_BIT6:        equ    6                                         ; Comparator A Compare Bit 6
DBGCAL_BIT7:        equ    7                                         ; Comparator A Compare Bit 7
; bit position masks
mDBGCAL_BIT0:       equ    %00000001
mDBGCAL_BIT1:       equ    %00000010
mDBGCAL_BIT2:       equ    %00000100
mDBGCAL_BIT3:       equ    %00001000
mDBGCAL_BIT4:       equ    %00010000
mDBGCAL_BIT5:       equ    %00100000
mDBGCAL_BIT6:       equ    %01000000
mDBGCAL_BIT7:       equ    %10000000


;*** DBGCBX - Debug Comparator B Extended Register; 0x0000002D ***
DBGCBX:             equ    $0000002D                                ;*** DBGCBX - Debug Comparator B Extended Register; 0x0000002D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGCBX_EXTCMP0:     equ    0                                         ; Comparator B Extended Compare Bits, bit 0
DBGCBX_EXTCMP1:     equ    1                                         ; Comparator B Extended Compare Bits, bit 1
DBGCBX_EXTCMP2:     equ    2                                         ; Comparator B Extended Compare Bits, bit 2
DBGCBX_EXTCMP3:     equ    3                                         ; Comparator B Extended Compare Bits, bit 3
DBGCBX_EXTCMP4:     equ    4                                         ; Comparator B Extended Compare Bits, bit 4
DBGCBX_EXTCMP5:     equ    5                                         ; Comparator B Extended Compare Bits, bit 5
DBGCBX_PAGSEL0:     equ    6                                         ; Page Selector Field, bit 0
DBGCBX_PAGSEL1:     equ    7                                         ; Page Selector Field, bit 1
; bit position masks
mDBGCBX_EXTCMP0:    equ    %00000001
mDBGCBX_EXTCMP1:    equ    %00000010
mDBGCBX_EXTCMP2:    equ    %00000100
mDBGCBX_EXTCMP3:    equ    %00001000
mDBGCBX_EXTCMP4:    equ    %00010000
mDBGCBX_EXTCMP5:    equ    %00100000
mDBGCBX_PAGSEL0:    equ    %01000000
mDBGCBX_PAGSEL1:    equ    %10000000


;*** DBGCB - Debug Comparator B Register; 0x0000002E ***
DBGCB:              equ    $0000002E                                ;*** DBGCB - Debug Comparator B Register; 0x0000002E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGCB_BIT0:         equ    0                                         ; Comparator B High Compare Bit 0
DBGCB_BIT1:         equ    1                                         ; Comparator B High Compare Bit 1
DBGCB_BIT2:         equ    2                                         ; Comparator B High Compare Bit 2
DBGCB_BIT3:         equ    3                                         ; Comparator B High Compare Bit 3
DBGCB_BIT4:         equ    4                                         ; Comparator B High Compare Bit 4
DBGCB_BIT5:         equ    5                                         ; Comparator B High Compare Bit 5
DBGCB_BIT6:         equ    6                                         ; Comparator B High Compare Bit 6
DBGCB_BIT7:         equ    7                                         ; Comparator B High Compare Bit 7
DBGCB_BIT8:         equ    8                                         ; Comparator B High Compare Bit 8
DBGCB_BIT9:         equ    9                                         ; Comparator B High Compare Bit 9
DBGCB_BIT10:        equ    10                                        ; Comparator B High Compare Bit 10
DBGCB_BIT11:        equ    11                                        ; Comparator B High Compare Bit 11
DBGCB_BIT12:        equ    12                                        ; Comparator B High Compare Bit 12
DBGCB_BIT13:        equ    13                                        ; Comparator B High Compare Bit 13
DBGCB_BIT14:        equ    14                                        ; Comparator B High Compare Bit 14
DBGCB_BIT15:        equ    15                                        ; Comparator B High Compare Bit 15
; bit position masks
mDBGCB_BIT0:        equ    %00000001
mDBGCB_BIT1:        equ    %00000010
mDBGCB_BIT2:        equ    %00000100
mDBGCB_BIT3:        equ    %00001000
mDBGCB_BIT4:        equ    %00010000
mDBGCB_BIT5:        equ    %00100000
mDBGCB_BIT6:        equ    %01000000
mDBGCB_BIT7:        equ    %10000000
mDBGCB_BIT8:        equ    %100000000
mDBGCB_BIT9:        equ    %1000000000
mDBGCB_BIT10:       equ    %10000000000
mDBGCB_BIT11:       equ    %100000000000
mDBGCB_BIT12:       equ    %1000000000000
mDBGCB_BIT13:       equ    %10000000000000
mDBGCB_BIT14:       equ    %100000000000000
mDBGCB_BIT15:       equ    %1000000000000000


;*** DBGCBH - Debug Comparator B Register High; 0x0000002E ***
DBGCBH:             equ    $0000002E                                ;*** DBGCBH - Debug Comparator B Register High; 0x0000002E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGCBH_BIT8:        equ    0                                         ; Comparator B High Compare Bit 8
DBGCBH_BIT9:        equ    1                                         ; Comparator B High Compare Bit 9
DBGCBH_BIT10:       equ    2                                         ; Comparator B High Compare Bit 10
DBGCBH_BIT11:       equ    3                                         ; Comparator B High Compare Bit 11
DBGCBH_BIT12:       equ    4                                         ; Comparator B High Compare Bit 12
DBGCBH_BIT13:       equ    5                                         ; Comparator B High Compare Bit 13
DBGCBH_BIT14:       equ    6                                         ; Comparator B High Compare Bit 14
DBGCBH_BIT15:       equ    7                                         ; Comparator B High Compare Bit 15
; bit position masks
mDBGCBH_BIT8:       equ    %00000001
mDBGCBH_BIT9:       equ    %00000010
mDBGCBH_BIT10:      equ    %00000100
mDBGCBH_BIT11:      equ    %00001000
mDBGCBH_BIT12:      equ    %00010000
mDBGCBH_BIT13:      equ    %00100000
mDBGCBH_BIT14:      equ    %01000000
mDBGCBH_BIT15:      equ    %10000000


;*** DBGCBL - Debug Comparator B Register Low; 0x0000002F ***
DBGCBL:             equ    $0000002F                                ;*** DBGCBL - Debug Comparator B Register Low; 0x0000002F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGCBL_BIT0:        equ    0                                         ; Comparator B High Compare Bit 0
DBGCBL_BIT1:        equ    1                                         ; Comparator B High Compare Bit 1
DBGCBL_BIT2:        equ    2                                         ; Comparator B High Compare Bit 2
DBGCBL_BIT3:        equ    3                                         ; Comparator B High Compare Bit 3
DBGCBL_BIT4:        equ    4                                         ; Comparator B High Compare Bit 4
DBGCBL_BIT5:        equ    5                                         ; Comparator B High Compare Bit 5
DBGCBL_BIT6:        equ    6                                         ; Comparator B High Compare Bit 6
DBGCBL_BIT7:        equ    7                                         ; Comparator B High Compare Bit 7
; bit position masks
mDBGCBL_BIT0:       equ    %00000001
mDBGCBL_BIT1:       equ    %00000010
mDBGCBL_BIT2:       equ    %00000100
mDBGCBL_BIT3:       equ    %00001000
mDBGCBL_BIT4:       equ    %00010000
mDBGCBL_BIT5:       equ    %00100000
mDBGCBL_BIT6:       equ    %01000000
mDBGCBL_BIT7:       equ    %10000000


;*** PPAGE - Page Index Register; 0x00000030 ***
PPAGE:              equ    $00000030                                ;*** PPAGE - Page Index Register; 0x00000030 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PPAGE_PIX0:         equ    0                                         ; Page Index Register Bit 0
PPAGE_PIX1:         equ    1                                         ; Page Index Register Bit 1
PPAGE_PIX2:         equ    2                                         ; Page Index Register Bit 2
PPAGE_PIX3:         equ    3                                         ; Page Index Register Bit 3
PPAGE_PIX4:         equ    4                                         ; Page Index Register Bit 4
PPAGE_PIX5:         equ    5                                         ; Page Index Register Bit 5
; bit position masks
mPPAGE_PIX0:        equ    %00000001
mPPAGE_PIX1:        equ    %00000010
mPPAGE_PIX2:        equ    %00000100
mPPAGE_PIX3:        equ    %00001000
mPPAGE_PIX4:        equ    %00010000
mPPAGE_PIX5:        equ    %00100000


;*** SYNR - CRG Synthesizer Register; 0x00000034 ***
SYNR:               equ    $00000034                                ;*** SYNR - CRG Synthesizer Register; 0x00000034 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SYNR_SYN0:          equ    0                                         ; CRG Synthesizer Bit 0
SYNR_SYN1:          equ    1                                         ; CRG Synthesizer Bit 1
SYNR_SYN2:          equ    2                                         ; CRG Synthesizer Bit 2
SYNR_SYN3:          equ    3                                         ; CRG Synthesizer Bit 3
SYNR_SYN4:          equ    4                                         ; CRG Synthesizer Bit 4
SYNR_SYN5:          equ    5                                         ; CRG Synthesizer Bit 5
; bit position masks
mSYNR_SYN0:         equ    %00000001
mSYNR_SYN1:         equ    %00000010
mSYNR_SYN2:         equ    %00000100
mSYNR_SYN3:         equ    %00001000
mSYNR_SYN4:         equ    %00010000
mSYNR_SYN5:         equ    %00100000


;*** REFDV - CRG Reference Divider Register; 0x00000035 ***
REFDV:              equ    $00000035                                ;*** REFDV - CRG Reference Divider Register; 0x00000035 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
REFDV_REFDV0:       equ    0                                         ; CRG Reference Divider Bit 0
REFDV_REFDV1:       equ    1                                         ; CRG Reference Divider Bit 1
REFDV_REFDV2:       equ    2                                         ; CRG Reference Divider Bit 2
REFDV_REFDV3:       equ    3                                         ; CRG Reference Divider Bit 3
; bit position masks
mREFDV_REFDV0:      equ    %00000001
mREFDV_REFDV1:      equ    %00000010
mREFDV_REFDV2:      equ    %00000100
mREFDV_REFDV3:      equ    %00001000


;*** CRGFLG - CRG Flags Register; 0x00000037 ***
CRGFLG:             equ    $00000037                                ;*** CRGFLG - CRG Flags Register; 0x00000037 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CRGFLG_SCM:         equ    0                                         ; Self-clock mode Status
CRGFLG_SCMIF:       equ    1                                         ; Self-clock mode Interrupt Flag
CRGFLG_TRACK:       equ    2                                         ; Track Status
CRGFLG_LOCK:        equ    3                                         ; Lock Status
CRGFLG_LOCKIF:      equ    4                                         ; PLL Lock Interrupt Flag
CRGFLG_LVRF:        equ    5                                         ; Self-clock mode Status
CRGFLG_PORF:        equ    6                                         ; Power on Reset Flag
CRGFLG_RTIF:        equ    7                                         ; Real Time Interrupt Flag
; bit position masks
mCRGFLG_SCM:        equ    %00000001
mCRGFLG_SCMIF:      equ    %00000010
mCRGFLG_TRACK:      equ    %00000100
mCRGFLG_LOCK:       equ    %00001000
mCRGFLG_LOCKIF:     equ    %00010000
mCRGFLG_LVRF:       equ    %00100000
mCRGFLG_PORF:       equ    %01000000
mCRGFLG_RTIF:       equ    %10000000


;*** CRGINT - CRG Interrupt Enable Register; 0x00000038 ***
CRGINT:             equ    $00000038                                ;*** CRGINT - CRG Interrupt Enable Register; 0x00000038 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CRGINT_SCMIE:       equ    1                                         ; Self-clock mode Interrupt Enable
CRGINT_LOCKIE:      equ    4                                         ; Lock Interrupt Enable
CRGINT_RTIE:        equ    7                                         ; Real Time Interrupt Enable
; bit position masks
mCRGINT_SCMIE:      equ    %00000010
mCRGINT_LOCKIE:     equ    %00010000
mCRGINT_RTIE:       equ    %10000000


;*** CLKSEL - CRG Clock Select Register; 0x00000039 ***
CLKSEL:             equ    $00000039                                ;*** CLKSEL - CRG Clock Select Register; 0x00000039 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CLKSEL_COPWAI:      equ    0                                         ; COP stops in WAIT mode
CLKSEL_RTIWAI:      equ    1                                         ; RTI stops in WAIT mode
CLKSEL_CWAI:        equ    2                                         ; CLK24 and CLK23 stop in WAIT mode
CLKSEL_PLLWAI:      equ    3                                         ; PLL stops in WAIT mode
CLKSEL_ROAWAI:      equ    4                                         ; Reduced Oscillator Amplitude in WAIT mode
CLKSEL_SYSWAI:      equ    5                                         ; System clocks stop in WAIT mode
CLKSEL_PSTP:        equ    6                                         ; Pseudo Stop
CLKSEL_PLLSEL:      equ    7                                         ; PLL selected for system clock
; bit position masks
mCLKSEL_COPWAI:     equ    %00000001
mCLKSEL_RTIWAI:     equ    %00000010
mCLKSEL_CWAI:       equ    %00000100
mCLKSEL_PLLWAI:     equ    %00001000
mCLKSEL_ROAWAI:     equ    %00010000
mCLKSEL_SYSWAI:     equ    %00100000
mCLKSEL_PSTP:       equ    %01000000
mCLKSEL_PLLSEL:     equ    %10000000


;*** PLLCTL - CRG PLL Control Register; 0x0000003A ***
PLLCTL:             equ    $0000003A                                ;*** PLLCTL - CRG PLL Control Register; 0x0000003A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PLLCTL_SCME:        equ    0                                         ; Self-clock mode enable
PLLCTL_PCE:         equ    1                                         ; COP Enable during Pseudo Stop Bit
PLLCTL_PRE:         equ    2                                         ; RTI Enable during Pseudo Stop Bit
PLLCTL_ACQ:         equ    4                                         ; Acquisition
PLLCTL_AUTO:        equ    5                                         ; Automatic Bandwidth Control
PLLCTL_PLLON:       equ    6                                         ; Phase Lock Loop On
PLLCTL_CME:         equ    7                                         ; Clock Monitor Enable
; bit position masks
mPLLCTL_SCME:       equ    %00000001
mPLLCTL_PCE:        equ    %00000010
mPLLCTL_PRE:        equ    %00000100
mPLLCTL_ACQ:        equ    %00010000
mPLLCTL_AUTO:       equ    %00100000
mPLLCTL_PLLON:      equ    %01000000
mPLLCTL_CME:        equ    %10000000


;*** RTICTL - CRG RTI Control Register; 0x0000003B ***
RTICTL:             equ    $0000003B                                ;*** RTICTL - CRG RTI Control Register; 0x0000003B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RTICTL_RTR0:        equ    0                                         ; Real Time Interrupt Modulus Counter Select Bit 0
RTICTL_RTR1:        equ    1                                         ; Real Time Interrupt Modulus Counter Select Bit 1
RTICTL_RTR2:        equ    2                                         ; Real Time Interrupt Modulus Counter Select Bit 2
RTICTL_RTR3:        equ    3                                         ; Real Time Interrupt Modulus Counter Select Bit 3
RTICTL_RTR4:        equ    4                                         ; Real Time Interrupt Prescale Rate Select Bit 4
RTICTL_RTR5:        equ    5                                         ; Real Time Interrupt Prescale Rate Select Bit 5
RTICTL_RTR6:        equ    6                                         ; Real Time Interrupt Prescale Rate Select Bit 6
; bit position masks
mRTICTL_RTR0:       equ    %00000001
mRTICTL_RTR1:       equ    %00000010
mRTICTL_RTR2:       equ    %00000100
mRTICTL_RTR3:       equ    %00001000
mRTICTL_RTR4:       equ    %00010000
mRTICTL_RTR5:       equ    %00100000
mRTICTL_RTR6:       equ    %01000000


;*** COPCTL - CRG COP Control Register; 0x0000003C ***
COPCTL:             equ    $0000003C                                ;*** COPCTL - CRG COP Control Register; 0x0000003C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
COPCTL_CR0:         equ    0                                         ; COP Watchdog Timer Rate select Bit 0
COPCTL_CR1:         equ    1                                         ; COP Watchdog Timer Rate select Bit 1
COPCTL_CR2:         equ    2                                         ; COP Watchdog Timer Rate select Bit 2
COPCTL_RSBCK:       equ    6                                         ; COP and RTI stop in Active BDM mode Bit
COPCTL_WCOP:        equ    7                                         ; Window COP mode
; bit position masks
mCOPCTL_CR0:        equ    %00000001
mCOPCTL_CR1:        equ    %00000010
mCOPCTL_CR2:        equ    %00000100
mCOPCTL_RSBCK:      equ    %01000000
mCOPCTL_WCOP:       equ    %10000000


;*** ARMCOP - CRG COP Timer Arm/Reset Register; 0x0000003F ***
ARMCOP:             equ    $0000003F                                ;*** ARMCOP - CRG COP Timer Arm/Reset Register; 0x0000003F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ARMCOP_BIT0:        equ    0                                         ; CRG COP Timer Arm/Reset Bit 0
ARMCOP_BIT1:        equ    1                                         ; CRG COP Timer Arm/Reset Bit 1
ARMCOP_BIT2:        equ    2                                         ; CRG COP Timer Arm/Reset Bit 2
ARMCOP_BIT3:        equ    3                                         ; CRG COP Timer Arm/Reset Bit 3
ARMCOP_BIT4:        equ    4                                         ; CRG COP Timer Arm/Reset Bit 4
ARMCOP_BIT5:        equ    5                                         ; CRG COP Timer Arm/Reset Bit 5
ARMCOP_BIT6:        equ    6                                         ; CRG COP Timer Arm/Reset Bit 6
ARMCOP_BIT7:        equ    7                                         ; CRG COP Timer Arm/Reset Bit 7
; bit position masks
mARMCOP_BIT0:       equ    %00000001
mARMCOP_BIT1:       equ    %00000010
mARMCOP_BIT2:       equ    %00000100
mARMCOP_BIT3:       equ    %00001000
mARMCOP_BIT4:       equ    %00010000
mARMCOP_BIT5:       equ    %00100000
mARMCOP_BIT6:       equ    %01000000
mARMCOP_BIT7:       equ    %10000000


;*** TIOS - Timer Input Capture/Output Compare Select; 0x00000040 ***
TIOS:               equ    $00000040                                ;*** TIOS - Timer Input Capture/Output Compare Select; 0x00000040 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TIOS_IOS2:          equ    2                                         ; Input Capture or Output Compare Channel Configuration Bit 2
TIOS_IOS3:          equ    3                                         ; Input Capture or Output Compare Channel Configuration Bit 3
TIOS_IOS4:          equ    4                                         ; Input Capture or Output Compare Channel Configuration Bit 4
TIOS_IOS5:          equ    5                                         ; Input Capture or Output Compare Channel Configuration Bit 5
TIOS_IOS6:          equ    6                                         ; Input Capture or Output Compare Channel Configuration Bit 6
TIOS_IOS7:          equ    7                                         ; Input Capture or Output Compare Channel Configuration Bit 7
; bit position masks
mTIOS_IOS2:         equ    %00000100
mTIOS_IOS3:         equ    %00001000
mTIOS_IOS4:         equ    %00010000
mTIOS_IOS5:         equ    %00100000
mTIOS_IOS6:         equ    %01000000
mTIOS_IOS7:         equ    %10000000


;*** CFORC - Timer Compare Force Register; 0x00000041 ***
CFORC:              equ    $00000041                                ;*** CFORC - Timer Compare Force Register; 0x00000041 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CFORC_FOC2:         equ    2                                         ; Force Output Compare Action for Channel 2
CFORC_FOC3:         equ    3                                         ; Force Output Compare Action for Channel 3
CFORC_FOC4:         equ    4                                         ; Force Output Compare Action for Channel 4
CFORC_FOC5:         equ    5                                         ; Force Output Compare Action for Channel 5
CFORC_FOC6:         equ    6                                         ; Force Output Compare Action for Channel 6
CFORC_FOC7:         equ    7                                         ; Force Output Compare Action for Channel 7
; bit position masks
mCFORC_FOC2:        equ    %00000100
mCFORC_FOC3:        equ    %00001000
mCFORC_FOC4:        equ    %00010000
mCFORC_FOC5:        equ    %00100000
mCFORC_FOC6:        equ    %01000000
mCFORC_FOC7:        equ    %10000000


;*** OC7M - Output Compare 7 Mask Register; 0x00000042 ***
OC7M:               equ    $00000042                                ;*** OC7M - Output Compare 7 Mask Register; 0x00000042 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
OC7M_OC7M2:         equ    2                                         ; Output Compare 7 Mask Bit 2
OC7M_OC7M3:         equ    3                                         ; Output Compare 7 Mask Bit 3
OC7M_OC7M4:         equ    4                                         ; Output Compare 7 Mask Bit 4
OC7M_OC7M5:         equ    5                                         ; Output Compare 7 Mask Bit 5
OC7M_OC7M6:         equ    6                                         ; Output Compare 7 Mask Bit 6
OC7M_OC7M7:         equ    7                                         ; Output Compare 7 Mask Bit 7
; bit position masks
mOC7M_OC7M2:        equ    %00000100
mOC7M_OC7M3:        equ    %00001000
mOC7M_OC7M4:        equ    %00010000
mOC7M_OC7M5:        equ    %00100000
mOC7M_OC7M6:        equ    %01000000
mOC7M_OC7M7:        equ    %10000000


;*** OC7D - Output Compare 7 Data Register; 0x00000043 ***
OC7D:               equ    $00000043                                ;*** OC7D - Output Compare 7 Data Register; 0x00000043 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
OC7D_OC7D2:         equ    2                                         ; Output Compare 7 Bit 2
OC7D_OC7D3:         equ    3                                         ; Output Compare 7 Bit 3
OC7D_OC7D4:         equ    4                                         ; Output Compare 7 Bit 4
OC7D_OC7D5:         equ    5                                         ; Output Compare 7 Bit 5
OC7D_OC7D6:         equ    6                                         ; Output Compare 7 Bit 6
OC7D_OC7D7:         equ    7                                         ; Output Compare 7 Bit 7
; bit position masks
mOC7D_OC7D2:        equ    %00000100
mOC7D_OC7D3:        equ    %00001000
mOC7D_OC7D4:        equ    %00010000
mOC7D_OC7D5:        equ    %00100000
mOC7D_OC7D6:        equ    %01000000
mOC7D_OC7D7:        equ    %10000000


;*** TCNT - Timer Count Register; 0x00000044 ***
TCNT:               equ    $00000044                                ;*** TCNT - Timer Count Register; 0x00000044 ***


;*** TCNTHi - Timer Count Register High; 0x00000044 ***
TCNTHi:             equ    $00000044                                ;*** TCNTHi - Timer Count Register High; 0x00000044 ***


;*** TCNTLo - Timer Count Register Low; 0x00000045 ***
TCNTLo:             equ    $00000045                                ;*** TCNTLo - Timer Count Register Low; 0x00000045 ***


;*** TSCR1 - Timer System Control Register1; 0x00000046 ***
TSCR1:              equ    $00000046                                ;*** TSCR1 - Timer System Control Register1; 0x00000046 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TSCR1_TFFCA:        equ    4                                         ; Timer Fast Flag Clear All
TSCR1_TSFRZ:        equ    5                                         ; Timer and Modulus Counter Stop While in Freeze Mode
TSCR1_TSWAI:        equ    6                                         ; Timer Module Stops While in Wait
TSCR1_TEN:          equ    7                                         ; Timer Enable
; bit position masks
mTSCR1_TFFCA:       equ    %00010000
mTSCR1_TSFRZ:       equ    %00100000
mTSCR1_TSWAI:       equ    %01000000
mTSCR1_TEN:         equ    %10000000


;*** TTOV - Timer Toggle On Overflow Register; 0x00000047 ***
TTOV:               equ    $00000047                                ;*** TTOV - Timer Toggle On Overflow Register; 0x00000047 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TTOV_TOV2:          equ    2                                         ; Toggle On Overflow Bit 2
TTOV_TOV3:          equ    3                                         ; Toggle On Overflow Bit 3
TTOV_TOV4:          equ    4                                         ; Toggle On Overflow Bit 4
TTOV_TOV5:          equ    5                                         ; Toggle On Overflow Bit 5
TTOV_TOV6:          equ    6                                         ; Toggle On Overflow Bit 6
TTOV_TOV7:          equ    7                                         ; Toggle On Overflow Bit 7
; bit position masks
mTTOV_TOV2:         equ    %00000100
mTTOV_TOV3:         equ    %00001000
mTTOV_TOV4:         equ    %00010000
mTTOV_TOV5:         equ    %00100000
mTTOV_TOV6:         equ    %01000000
mTTOV_TOV7:         equ    %10000000


;*** TCTL1 - Timer Control Register 1; 0x00000048 ***
TCTL1:              equ    $00000048                                ;*** TCTL1 - Timer Control Register 1; 0x00000048 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TCTL1_OL4:          equ    0                                         ; Output Level Bit 4
TCTL1_OM4:          equ    1                                         ; Output Mode Bit 4
TCTL1_OL5:          equ    2                                         ; Output Level Bit 5
TCTL1_OM5:          equ    3                                         ; Output Mode Bit 5
TCTL1_OL6:          equ    4                                         ; Output Level Bit 6
TCTL1_OM6:          equ    5                                         ; Output Mode Bit 6
TCTL1_OL7:          equ    6                                         ; Output Level Bit 7
TCTL1_OM7:          equ    7                                         ; Output Mode Bit 7
; bit position masks
mTCTL1_OL4:         equ    %00000001
mTCTL1_OM4:         equ    %00000010
mTCTL1_OL5:         equ    %00000100
mTCTL1_OM5:         equ    %00001000
mTCTL1_OL6:         equ    %00010000
mTCTL1_OM6:         equ    %00100000
mTCTL1_OL7:         equ    %01000000
mTCTL1_OM7:         equ    %10000000


;*** TCTL2 - Timer Control Register 2; 0x00000049 ***
TCTL2:              equ    $00000049                                ;*** TCTL2 - Timer Control Register 2; 0x00000049 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TCTL2_OL2:          equ    4                                         ; Output Level Bit 2
TCTL2_OM2:          equ    5                                         ; Output Mode Bit 2
TCTL2_OL3:          equ    6                                         ; Output Level Bit 3
TCTL2_OM3:          equ    7                                         ; Output Mode Bit 3
; bit position masks
mTCTL2_OL2:         equ    %00010000
mTCTL2_OM2:         equ    %00100000
mTCTL2_OL3:         equ    %01000000
mTCTL2_OM3:         equ    %10000000


;*** TCTL3 - Timer Control Register 3; 0x0000004A ***
TCTL3:              equ    $0000004A                                ;*** TCTL3 - Timer Control Register 3; 0x0000004A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TCTL3_EDG4A:        equ    0                                         ; Input Capture Edge Control 4A
TCTL3_EDG4B:        equ    1                                         ; Input Capture Edge Control 4B
TCTL3_EDG5A:        equ    2                                         ; Input Capture Edge Control 5A
TCTL3_EDG5B:        equ    3                                         ; Input Capture Edge Control 5B
TCTL3_EDG6A:        equ    4                                         ; Input Capture Edge Control 6A
TCTL3_EDG6B:        equ    5                                         ; Input Capture Edge Control 6B
TCTL3_EDG7A:        equ    6                                         ; Input Capture Edge Control 7A
TCTL3_EDG7B:        equ    7                                         ; Input Capture Edge Control 7B
; bit position masks
mTCTL3_EDG4A:       equ    %00000001
mTCTL3_EDG4B:       equ    %00000010
mTCTL3_EDG5A:       equ    %00000100
mTCTL3_EDG5B:       equ    %00001000
mTCTL3_EDG6A:       equ    %00010000
mTCTL3_EDG6B:       equ    %00100000
mTCTL3_EDG7A:       equ    %01000000
mTCTL3_EDG7B:       equ    %10000000


;*** TCTL4 - Timer Control Register 4; 0x0000004B ***
TCTL4:              equ    $0000004B                                ;*** TCTL4 - Timer Control Register 4; 0x0000004B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TCTL4_EDG2A:        equ    4                                         ; Input Capture Edge Control 2A
TCTL4_EDG2B:        equ    5                                         ; Input Capture Edge Control 2B
TCTL4_EDG3A:        equ    6                                         ; Input Capture Edge Control 3A
TCTL4_EDG3B:        equ    7                                         ; Input Capture Edge Control 3B
; bit position masks
mTCTL4_EDG2A:       equ    %00010000
mTCTL4_EDG2B:       equ    %00100000
mTCTL4_EDG3A:       equ    %01000000
mTCTL4_EDG3B:       equ    %10000000


;*** TIE - Timer Interrupt Enable Register; 0x0000004C ***
TIE:                equ    $0000004C                                ;*** TIE - Timer Interrupt Enable Register; 0x0000004C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TIE_C0I:            equ    0                                         ; Input Capture/Output Compare Interrupt Enable Bit 0
TIE_C1I:            equ    1                                         ; Input Capture/Output Compare Interrupt Enable Bit 1
TIE_C2I:            equ    2                                         ; Input Capture/Output Compare Interrupt Enable Bit 2
TIE_C3I:            equ    3                                         ; Input Capture/Output Compare Interrupt Enable Bit 3
TIE_C4I:            equ    4                                         ; Input Capture/Output Compare Interrupt Enable Bit 4
TIE_C5I:            equ    5                                         ; Input Capture/Output Compare Interrupt Enable Bit 5
TIE_C6I:            equ    6                                         ; Input Capture/Output Compare Interrupt Enable Bit 6
TIE_C7I:            equ    7                                         ; Input Capture/Output Compare Interrupt Enable Bit 7
; bit position masks
mTIE_C0I:           equ    %00000001
mTIE_C1I:           equ    %00000010
mTIE_C2I:           equ    %00000100
mTIE_C3I:           equ    %00001000
mTIE_C4I:           equ    %00010000
mTIE_C5I:           equ    %00100000
mTIE_C6I:           equ    %01000000
mTIE_C7I:           equ    %10000000


;*** TSCR2 - Timer System Control Register 2; 0x0000004D ***
TSCR2:              equ    $0000004D                                ;*** TSCR2 - Timer System Control Register 2; 0x0000004D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TSCR2_PR0:          equ    0                                         ; Timer Prescaler Select Bit 0
TSCR2_PR1:          equ    1                                         ; Timer Prescaler Select Bit 1
TSCR2_PR2:          equ    2                                         ; Timer Prescaler Select Bit 2
TSCR2_TCRE:         equ    3                                         ; Timer Counter Reset Enable
TSCR2_TOI:          equ    7                                         ; Timer Overflow Interrupt Enable
; bit position masks
mTSCR2_PR0:         equ    %00000001
mTSCR2_PR1:         equ    %00000010
mTSCR2_PR2:         equ    %00000100
mTSCR2_TCRE:        equ    %00001000
mTSCR2_TOI:         equ    %10000000


;*** TFLG1 - Main Timer Interrupt Flag 1; 0x0000004E ***
TFLG1:              equ    $0000004E                                ;*** TFLG1 - Main Timer Interrupt Flag 1; 0x0000004E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TFLG1_C2F:          equ    2                                         ; Input Capture/Output Compare Channel Flag 2
TFLG1_C3F:          equ    3                                         ; Input Capture/Output Compare Channel Flag 3
TFLG1_C4F:          equ    4                                         ; Input Capture/Output Compare Channel Flag 4
TFLG1_C5F:          equ    5                                         ; Input Capture/Output Compare Channel Flag 5
TFLG1_C6F:          equ    6                                         ; Input Capture/Output Compare Channel Flag 6
TFLG1_C7F:          equ    7                                         ; Input Capture/Output Compare Channel Flag 7
; bit position masks
mTFLG1_C2F:         equ    %00000100
mTFLG1_C3F:         equ    %00001000
mTFLG1_C4F:         equ    %00010000
mTFLG1_C5F:         equ    %00100000
mTFLG1_C6F:         equ    %01000000
mTFLG1_C7F:         equ    %10000000


;*** TFLG2 - Main Timer Interrupt Flag 2; 0x0000004F ***
TFLG2:              equ    $0000004F                                ;*** TFLG2 - Main Timer Interrupt Flag 2; 0x0000004F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TFLG2_TOF:          equ    7                                         ; Timer Overflow Flag
; bit position masks
mTFLG2_TOF:         equ    %10000000


;*** TC2 - Timer Input Capture/Output Compare Register 2; 0x00000054 ***
TC2:                equ    $00000054                                ;*** TC2 - Timer Input Capture/Output Compare Register 2; 0x00000054 ***


;*** TC2Hi - Timer Input Capture/Output Compare Register 2 High; 0x00000054 ***
TC2Hi:              equ    $00000054                                ;*** TC2Hi - Timer Input Capture/Output Compare Register 2 High; 0x00000054 ***


;*** TC2Lo - Timer Input Capture/Output Compare Register 2 Low; 0x00000055 ***
TC2Lo:              equ    $00000055                                ;*** TC2Lo - Timer Input Capture/Output Compare Register 2 Low; 0x00000055 ***


;*** TC3 - Timer Input Capture/Output Compare Register 3; 0x00000056 ***
TC3:                equ    $00000056                                ;*** TC3 - Timer Input Capture/Output Compare Register 3; 0x00000056 ***


;*** TC3Hi - Timer Input Capture/Output Compare Register 3 High; 0x00000056 ***
TC3Hi:              equ    $00000056                                ;*** TC3Hi - Timer Input Capture/Output Compare Register 3 High; 0x00000056 ***


;*** TC3Lo - Timer Input Capture/Output Compare Register 3 Low; 0x00000057 ***
TC3Lo:              equ    $00000057                                ;*** TC3Lo - Timer Input Capture/Output Compare Register 3 Low; 0x00000057 ***


;*** TC4 - Timer Input Capture/Output Compare Register 4; 0x00000058 ***
TC4:                equ    $00000058                                ;*** TC4 - Timer Input Capture/Output Compare Register 4; 0x00000058 ***


;*** TC4Hi - Timer Input Capture/Output Compare Register 4 High; 0x00000058 ***
TC4Hi:              equ    $00000058                                ;*** TC4Hi - Timer Input Capture/Output Compare Register 4 High; 0x00000058 ***


;*** TC4Lo - Timer Input Capture/Output Compare Register 4 Low; 0x00000059 ***
TC4Lo:              equ    $00000059                                ;*** TC4Lo - Timer Input Capture/Output Compare Register 4 Low; 0x00000059 ***


;*** TC5 - Timer Input Capture/Output Compare Register 5; 0x0000005A ***
TC5:                equ    $0000005A                                ;*** TC5 - Timer Input Capture/Output Compare Register 5; 0x0000005A ***


;*** TC5Hi - Timer Input Capture/Output Compare Register 5 High; 0x0000005A ***
TC5Hi:              equ    $0000005A                                ;*** TC5Hi - Timer Input Capture/Output Compare Register 5 High; 0x0000005A ***


;*** TC5Lo - Timer Input Capture/Output Compare Register 5 Low; 0x0000005B ***
TC5Lo:              equ    $0000005B                                ;*** TC5Lo - Timer Input Capture/Output Compare Register 5 Low; 0x0000005B ***


;*** TC6 - Timer Input Capture/Output Compare Register 6; 0x0000005C ***
TC6:                equ    $0000005C                                ;*** TC6 - Timer Input Capture/Output Compare Register 6; 0x0000005C ***


;*** TC6Hi - Timer Input Capture/Output Compare Register 6 High; 0x0000005C ***
TC6Hi:              equ    $0000005C                                ;*** TC6Hi - Timer Input Capture/Output Compare Register 6 High; 0x0000005C ***


;*** TC6Lo - Timer Input Capture/Output Compare Register 6 Low; 0x0000005D ***
TC6Lo:              equ    $0000005D                                ;*** TC6Lo - Timer Input Capture/Output Compare Register 6 Low; 0x0000005D ***


;*** TC7 - Timer Input Capture/Output Compare Register 7; 0x0000005E ***
TC7:                equ    $0000005E                                ;*** TC7 - Timer Input Capture/Output Compare Register 7; 0x0000005E ***


;*** TC7Hi - Timer Input Capture/Output Compare Register 7 High; 0x0000005E ***
TC7Hi:              equ    $0000005E                                ;*** TC7Hi - Timer Input Capture/Output Compare Register 7 High; 0x0000005E ***


;*** TC7Lo - Timer Input Capture/Output Compare Register 7 Low; 0x0000005F ***
TC7Lo:              equ    $0000005F                                ;*** TC7Lo - Timer Input Capture/Output Compare Register 7 Low; 0x0000005F ***


;*** PACTL - 16-Bit Pulse Accumulator A Control Register; 0x00000060 ***
PACTL:              equ    $00000060                                ;*** PACTL - 16-Bit Pulse Accumulator A Control Register; 0x00000060 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PACTL_PAI:          equ    0                                         ; Pulse Accumulator Input Interrupt enable
PACTL_PAOVI:        equ    1                                         ; Pulse Accumulator A Overflow Interrupt enable
PACTL_CLK0:         equ    2                                         ; Clock Select Bit 0
PACTL_CLK1:         equ    3                                         ; Clock Select Bit 1
PACTL_PEDGE:        equ    4                                         ; Pulse Accumulator Edge Control
PACTL_PAMOD:        equ    5                                         ; Pulse Accumulator Mode
PACTL_PAEN:         equ    6                                         ; Pulse Accumulator A System Enable
; bit position masks
mPACTL_PAI:         equ    %00000001
mPACTL_PAOVI:       equ    %00000010
mPACTL_CLK0:        equ    %00000100
mPACTL_CLK1:        equ    %00001000
mPACTL_PEDGE:       equ    %00010000
mPACTL_PAMOD:       equ    %00100000
mPACTL_PAEN:        equ    %01000000


;*** PAFLG - Pulse Accumulator A Flag Register; 0x00000061 ***
PAFLG:              equ    $00000061                                ;*** PAFLG - Pulse Accumulator A Flag Register; 0x00000061 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PAFLG_PAIF:         equ    0                                         ; Pulse Accumulator Input edge Flag
PAFLG_PAOVF:        equ    1                                         ; Pulse Accumulator A Overflow Flag
; bit position masks
mPAFLG_PAIF:        equ    %00000001
mPAFLG_PAOVF:       equ    %00000010


;*** PACNT - Pulse Accumulators Count Register; 0x00000062 ***
PACNT:              equ    $00000062                                ;*** PACNT - Pulse Accumulators Count Register; 0x00000062 ***


;*** ATDCTL23 - ATD Control Register 23; 0x00000082 ***
ATDCTL23:           equ    $00000082                                ;*** ATDCTL23 - ATD Control Register 23; 0x00000082 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDCTL23_FRZ0:      equ    0                                         ; Background Debug Freeze Enable Bit 0
ATDCTL23_FRZ1:      equ    1                                         ; Background Debug Freeze Enable Bit 1
ATDCTL23_FIFO:      equ    2                                         ; Result Register FIFO Mode
ATDCTL23_S1C:       equ    3                                         ; Conversion Sequence Length 1
ATDCTL23_S2C:       equ    4                                         ; Conversion Sequence Length 2
ATDCTL23_S4C:       equ    5                                         ; Conversion Sequence Length 4
ATDCTL23_S8C:       equ    6                                         ; Conversion Sequence Length 8
ATDCTL23_ASCIF:     equ    8                                         ; ATD Sequence Complete Interrupt Flag
ATDCTL23_ASCIE:     equ    9                                         ; ATD Sequence Complete Interrupt Enable
ATDCTL23_ETRIGE:    equ    10                                        ; External Trigger Mode enable
ATDCTL23_ETRIGP:    equ    11                                        ; External Trigger Polarity
ATDCTL23_ETRIGLE:   equ    12                                        ; External Trigger Level/Edge control
ATDCTL23_AWAI:      equ    13                                        ; ATD Power Down in Wait Mode
ATDCTL23_AFFC:      equ    14                                        ; ATD Fast Conversion Complete Flag Clear
ATDCTL23_ADPU:      equ    15                                        ; ATD Disable / Power Down
; bit position masks
mATDCTL23_FRZ0:     equ    %00000001
mATDCTL23_FRZ1:     equ    %00000010
mATDCTL23_FIFO:     equ    %00000100
mATDCTL23_S1C:      equ    %00001000
mATDCTL23_S2C:      equ    %00010000
mATDCTL23_S4C:      equ    %00100000
mATDCTL23_S8C:      equ    %01000000
mATDCTL23_ASCIF:    equ    %100000000
mATDCTL23_ASCIE:    equ    %1000000000
mATDCTL23_ETRIGE:   equ    %10000000000
mATDCTL23_ETRIGP:   equ    %100000000000
mATDCTL23_ETRIGLE:  equ    %1000000000000
mATDCTL23_AWAI:     equ    %10000000000000
mATDCTL23_AFFC:     equ    %100000000000000
mATDCTL23_ADPU:     equ    %1000000000000000


;*** ATDCTL2 - ATD Control Register 2; 0x00000082 ***
ATDCTL2:            equ    $00000082                                ;*** ATDCTL2 - ATD Control Register 2; 0x00000082 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDCTL2_ASCIF:      equ    0                                         ; ATD Sequence Complete Interrupt Flag
ATDCTL2_ASCIE:      equ    1                                         ; ATD Sequence Complete Interrupt Enable
ATDCTL2_ETRIGE:     equ    2                                         ; External Trigger Mode enable
ATDCTL2_ETRIGP:     equ    3                                         ; External Trigger Polarity
ATDCTL2_ETRIGLE:    equ    4                                         ; External Trigger Level/Edge control
ATDCTL2_AWAI:       equ    5                                         ; ATD Power Down in Wait Mode
ATDCTL2_AFFC:       equ    6                                         ; ATD Fast Conversion Complete Flag Clear
ATDCTL2_ADPU:       equ    7                                         ; ATD Disable / Power Down
; bit position masks
mATDCTL2_ASCIF:     equ    %00000001
mATDCTL2_ASCIE:     equ    %00000010
mATDCTL2_ETRIGE:    equ    %00000100
mATDCTL2_ETRIGP:    equ    %00001000
mATDCTL2_ETRIGLE:   equ    %00010000
mATDCTL2_AWAI:      equ    %00100000
mATDCTL2_AFFC:      equ    %01000000
mATDCTL2_ADPU:      equ    %10000000


;*** ATDCTL3 - ATD Control Register 3; 0x00000083 ***
ATDCTL3:            equ    $00000083                                ;*** ATDCTL3 - ATD Control Register 3; 0x00000083 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDCTL3_FRZ0:       equ    0                                         ; Background Debug Freeze Enable Bit 0
ATDCTL3_FRZ1:       equ    1                                         ; Background Debug Freeze Enable Bit 1
ATDCTL3_FIFO:       equ    2                                         ; Result Register FIFO Mode
ATDCTL3_S1C:        equ    3                                         ; Conversion Sequence Length 1
ATDCTL3_S2C:        equ    4                                         ; Conversion Sequence Length 2
ATDCTL3_S4C:        equ    5                                         ; Conversion Sequence Length 4
ATDCTL3_S8C:        equ    6                                         ; Conversion Sequence Length 8
; bit position masks
mATDCTL3_FRZ0:      equ    %00000001
mATDCTL3_FRZ1:      equ    %00000010
mATDCTL3_FIFO:      equ    %00000100
mATDCTL3_S1C:       equ    %00001000
mATDCTL3_S2C:       equ    %00010000
mATDCTL3_S4C:       equ    %00100000
mATDCTL3_S8C:       equ    %01000000


;*** ATDCTL45 - ATD Control Register 45; 0x00000084 ***
ATDCTL45:           equ    $00000084                                ;*** ATDCTL45 - ATD Control Register 45; 0x00000084 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDCTL45_CA:        equ    0                                         ; Analog Input Channel Select Code A
ATDCTL45_CB:        equ    1                                         ; Analog Input Channel Select Code B
ATDCTL45_CC:        equ    2                                         ; Analog Input Channel Select Code C
ATDCTL45_MULT:      equ    4                                         ; Multi-Channel Sample Mode
ATDCTL45_SCAN:      equ    5                                         ; Continuous Conversion Sequence Mode
ATDCTL45_DSGN:      equ    6                                         ; Signed/Unsigned Result Data Mode
ATDCTL45_DJM:       equ    7                                         ; Result Register Data Justification Mode
ATDCTL45_PRS0:      equ    8                                         ; ATD Clock Prescaler 0
ATDCTL45_PRS1:      equ    9                                         ; ATD Clock Prescaler 1
ATDCTL45_PRS2:      equ    10                                        ; ATD Clock Prescaler 2
ATDCTL45_PRS3:      equ    11                                        ; ATD Clock Prescaler 3
ATDCTL45_PRS4:      equ    12                                        ; ATD Clock Prescaler 4
ATDCTL45_SMP0:      equ    13                                        ; Sample Time Select 0
ATDCTL45_SMP1:      equ    14                                        ; Sample Time Select 1
ATDCTL45_SRES8:     equ    15                                        ; ATD Resolution Select
; bit position masks
mATDCTL45_CA:       equ    %00000001
mATDCTL45_CB:       equ    %00000010
mATDCTL45_CC:       equ    %00000100
mATDCTL45_MULT:     equ    %00010000
mATDCTL45_SCAN:     equ    %00100000
mATDCTL45_DSGN:     equ    %01000000
mATDCTL45_DJM:      equ    %10000000
mATDCTL45_PRS0:     equ    %100000000
mATDCTL45_PRS1:     equ    %1000000000
mATDCTL45_PRS2:     equ    %10000000000
mATDCTL45_PRS3:     equ    %100000000000
mATDCTL45_PRS4:     equ    %1000000000000
mATDCTL45_SMP0:     equ    %10000000000000
mATDCTL45_SMP1:     equ    %100000000000000
mATDCTL45_SRES8:    equ    %1000000000000000


;*** ATDCTL4 - ATD Control Register 4; 0x00000084 ***
ATDCTL4:            equ    $00000084                                ;*** ATDCTL4 - ATD Control Register 4; 0x00000084 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDCTL4_PRS0:       equ    0                                         ; ATD Clock Prescaler 0
ATDCTL4_PRS1:       equ    1                                         ; ATD Clock Prescaler 1
ATDCTL4_PRS2:       equ    2                                         ; ATD Clock Prescaler 2
ATDCTL4_PRS3:       equ    3                                         ; ATD Clock Prescaler 3
ATDCTL4_PRS4:       equ    4                                         ; ATD Clock Prescaler 4
ATDCTL4_SMP0:       equ    5                                         ; Sample Time Select 0
ATDCTL4_SMP1:       equ    6                                         ; Sample Time Select 1
ATDCTL4_SRES8:      equ    7                                         ; ATD Resolution Select
; bit position masks
mATDCTL4_PRS0:      equ    %00000001
mATDCTL4_PRS1:      equ    %00000010
mATDCTL4_PRS2:      equ    %00000100
mATDCTL4_PRS3:      equ    %00001000
mATDCTL4_PRS4:      equ    %00010000
mATDCTL4_SMP0:      equ    %00100000
mATDCTL4_SMP1:      equ    %01000000
mATDCTL4_SRES8:     equ    %10000000


;*** ATDCTL5 - ATD Control Register 5; 0x00000085 ***
ATDCTL5:            equ    $00000085                                ;*** ATDCTL5 - ATD Control Register 5; 0x00000085 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDCTL5_CA:         equ    0                                         ; Analog Input Channel Select Code A
ATDCTL5_CB:         equ    1                                         ; Analog Input Channel Select Code B
ATDCTL5_CC:         equ    2                                         ; Analog Input Channel Select Code C
ATDCTL5_MULT:       equ    4                                         ; Multi-Channel Sample Mode
ATDCTL5_SCAN:       equ    5                                         ; Continuous Conversion Sequence Mode
ATDCTL5_DSGN:       equ    6                                         ; Signed/Unsigned Result Data Mode
ATDCTL5_DJM:        equ    7                                         ; Result Register Data Justification Mode
; bit position masks
mATDCTL5_CA:        equ    %00000001
mATDCTL5_CB:        equ    %00000010
mATDCTL5_CC:        equ    %00000100
mATDCTL5_MULT:      equ    %00010000
mATDCTL5_SCAN:      equ    %00100000
mATDCTL5_DSGN:      equ    %01000000
mATDCTL5_DJM:       equ    %10000000


;*** ATDSTAT0 - ATD Status Register 0; 0x00000086 ***
ATDSTAT0:           equ    $00000086                                ;*** ATDSTAT0 - ATD Status Register 0; 0x00000086 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDSTAT0_CC0:       equ    0                                         ; Conversion Counter 0
ATDSTAT0_CC1:       equ    1                                         ; Conversion Counter 1
ATDSTAT0_CC2:       equ    2                                         ; Conversion Counter 2
ATDSTAT0_FIFOR:     equ    4                                         ; FIFO Over Run Flag
ATDSTAT0_ETORF:     equ    5                                         ; External Trigger Overrun Flag
ATDSTAT0_SCF:       equ    7                                         ; Sequence Complete Flag
; bit position masks
mATDSTAT0_CC0:      equ    %00000001
mATDSTAT0_CC1:      equ    %00000010
mATDSTAT0_CC2:      equ    %00000100
mATDSTAT0_FIFOR:    equ    %00010000
mATDSTAT0_ETORF:    equ    %00100000
mATDSTAT0_SCF:      equ    %10000000


;*** ATDTEST1 - ATD Test Register; 0x00000089 ***
ATDTEST1:           equ    $00000089                                ;*** ATDTEST1 - ATD Test Register; 0x00000089 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDTEST1_SC:        equ    0                                         ; Special Channel Conversion Bit
; bit position masks
mATDTEST1_SC:       equ    %00000001


;*** ATDSTAT1 - ATD Status Register 1; 0x0000008B ***
ATDSTAT1:           equ    $0000008B                                ;*** ATDSTAT1 - ATD Status Register 1; 0x0000008B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDSTAT1_CCF0:      equ    0                                         ; Conversion Complete Flag 0
ATDSTAT1_CCF1:      equ    1                                         ; Conversion Complete Flag 1
ATDSTAT1_CCF2:      equ    2                                         ; Conversion Complete Flag 2
ATDSTAT1_CCF3:      equ    3                                         ; Conversion Complete Flag 3
ATDSTAT1_CCF4:      equ    4                                         ; Conversion Complete Flag 4
ATDSTAT1_CCF5:      equ    5                                         ; Conversion Complete Flag 5
ATDSTAT1_CCF6:      equ    6                                         ; Conversion Complete Flag 6
ATDSTAT1_CCF7:      equ    7                                         ; Conversion Complete Flag 7
; bit position masks
mATDSTAT1_CCF0:     equ    %00000001
mATDSTAT1_CCF1:     equ    %00000010
mATDSTAT1_CCF2:     equ    %00000100
mATDSTAT1_CCF3:     equ    %00001000
mATDSTAT1_CCF4:     equ    %00010000
mATDSTAT1_CCF5:     equ    %00100000
mATDSTAT1_CCF6:     equ    %01000000
mATDSTAT1_CCF7:     equ    %10000000


;*** ATDDIEN - ATD Input Enable Register; 0x0000008D ***
ATDDIEN:            equ    $0000008D                                ;*** ATDDIEN - ATD Input Enable Register; 0x0000008D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDIEN_IEN0:       equ    0                                         ; ATD Digital Input Enable on channel 0
ATDDIEN_IEN1:       equ    1                                         ; ATD Digital Input Enable on channel 1
ATDDIEN_IEN2:       equ    2                                         ; ATD Digital Input Enable on channel 2
ATDDIEN_IEN3:       equ    3                                         ; ATD Digital Input Enable on channel 3
ATDDIEN_IEN4:       equ    4                                         ; ATD Digital Input Enable on channel 4
ATDDIEN_IEN5:       equ    5                                         ; ATD Digital Input Enable on channel 5
ATDDIEN_IEN6:       equ    6                                         ; ATD Digital Input Enable on channel 6
ATDDIEN_IEN7:       equ    7                                         ; ATD Digital Input Enable on channel 7
; bit position masks
mATDDIEN_IEN0:      equ    %00000001
mATDDIEN_IEN1:      equ    %00000010
mATDDIEN_IEN2:      equ    %00000100
mATDDIEN_IEN3:      equ    %00001000
mATDDIEN_IEN4:      equ    %00010000
mATDDIEN_IEN5:      equ    %00100000
mATDDIEN_IEN6:      equ    %01000000
mATDDIEN_IEN7:      equ    %10000000


;*** PORTAD0 - Port AD0 Register; 0x0000008F ***
PORTAD0:            equ    $0000008F                                ;*** PORTAD0 - Port AD0 Register; 0x0000008F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PORTAD0_PTAD0:      equ    0                                         ; A/D Channel 0 (AN0) Digital Input
PORTAD0_PTAD1:      equ    1                                         ; A/D Channel 1 (AN1) Digital Input
PORTAD0_PTAD2:      equ    2                                         ; A/D Channel 2 (AN2) Digital Input
PORTAD0_PTAD3:      equ    3                                         ; A/D Channel 3 (AN3) Digital Input
PORTAD0_PTAD4:      equ    4                                         ; A/D Channel 4 (AN4) Digital Input
PORTAD0_PTAD5:      equ    5                                         ; A/D Channel 5 (AN5) Digital Input
PORTAD0_PTAD6:      equ    6                                         ; A/D Channel 6 (AN6) Digital Input
PORTAD0_PTAD7:      equ    7                                         ; A/D Channel 7 (AN7) Digital Input
; bit position masks
mPORTAD0_PTAD0:     equ    %00000001
mPORTAD0_PTAD1:     equ    %00000010
mPORTAD0_PTAD2:     equ    %00000100
mPORTAD0_PTAD3:     equ    %00001000
mPORTAD0_PTAD4:     equ    %00010000
mPORTAD0_PTAD5:     equ    %00100000
mPORTAD0_PTAD6:     equ    %01000000
mPORTAD0_PTAD7:     equ    %10000000


;*** ATDDR0 - ATD Conversion Result Register 0; 0x00000090 ***
ATDDR0:             equ    $00000090                                ;*** ATDDR0 - ATD Conversion Result Register 0; 0x00000090 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR0_BIT6:        equ    6                                         ; Bit 6
ATDDR0_BIT7:        equ    7                                         ; Bit 7
ATDDR0_BIT8:        equ    8                                         ; Bit 8
ATDDR0_BIT9:        equ    9                                         ; Bit 9
ATDDR0_BIT10:       equ    10                                        ; Bit 10
ATDDR0_BIT11:       equ    11                                        ; Bit 11
ATDDR0_BIT12:       equ    12                                        ; Bit 12
ATDDR0_BIT13:       equ    13                                        ; Bit 13
ATDDR0_BIT14:       equ    14                                        ; Bit 14
ATDDR0_BIT15:       equ    15                                        ; Bit 15
; bit position masks
mATDDR0_BIT6:       equ    %01000000
mATDDR0_BIT7:       equ    %10000000
mATDDR0_BIT8:       equ    %100000000
mATDDR0_BIT9:       equ    %1000000000
mATDDR0_BIT10:      equ    %10000000000
mATDDR0_BIT11:      equ    %100000000000
mATDDR0_BIT12:      equ    %1000000000000
mATDDR0_BIT13:      equ    %10000000000000
mATDDR0_BIT14:      equ    %100000000000000
mATDDR0_BIT15:      equ    %1000000000000000


;*** ATDDR0H - ATD Conversion Result Register 0 High; 0x00000090 ***
ATDDR0H:            equ    $00000090                                ;*** ATDDR0H - ATD Conversion Result Register 0 High; 0x00000090 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR0H_BIT8:       equ    0                                         ; Bit 8
ATDDR0H_BIT9:       equ    1                                         ; Bit 9
ATDDR0H_BIT10:      equ    2                                         ; Bit 10
ATDDR0H_BIT11:      equ    3                                         ; Bit 11
ATDDR0H_BIT12:      equ    4                                         ; Bit 12
ATDDR0H_BIT13:      equ    5                                         ; Bit 13
ATDDR0H_BIT14:      equ    6                                         ; Bit 14
ATDDR0H_BIT15:      equ    7                                         ; Bit 15
; bit position masks
mATDDR0H_BIT8:      equ    %00000001
mATDDR0H_BIT9:      equ    %00000010
mATDDR0H_BIT10:     equ    %00000100
mATDDR0H_BIT11:     equ    %00001000
mATDDR0H_BIT12:     equ    %00010000
mATDDR0H_BIT13:     equ    %00100000
mATDDR0H_BIT14:     equ    %01000000
mATDDR0H_BIT15:     equ    %10000000


;*** ATDDR0L - ATD Conversion Result Register 0 Low; 0x00000091 ***
ATDDR0L:            equ    $00000091                                ;*** ATDDR0L - ATD Conversion Result Register 0 Low; 0x00000091 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR0L_BIT6:       equ    6                                         ; Bit 6
ATDDR0L_BIT7:       equ    7                                         ; Bit 7
; bit position masks
mATDDR0L_BIT6:      equ    %01000000
mATDDR0L_BIT7:      equ    %10000000


;*** ATDDR1 - ATD Conversion Result Register 1; 0x00000092 ***
ATDDR1:             equ    $00000092                                ;*** ATDDR1 - ATD Conversion Result Register 1; 0x00000092 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR1_BIT6:        equ    6                                         ; Bit 6
ATDDR1_BIT7:        equ    7                                         ; Bit 7
ATDDR1_BIT8:        equ    8                                         ; Bit 8
ATDDR1_BIT9:        equ    9                                         ; Bit 9
ATDDR1_BIT10:       equ    10                                        ; Bit 10
ATDDR1_BIT11:       equ    11                                        ; Bit 11
ATDDR1_BIT12:       equ    12                                        ; Bit 12
ATDDR1_BIT13:       equ    13                                        ; Bit 13
ATDDR1_BIT14:       equ    14                                        ; Bit 14
ATDDR1_BIT15:       equ    15                                        ; Bit 15
; bit position masks
mATDDR1_BIT6:       equ    %01000000
mATDDR1_BIT7:       equ    %10000000
mATDDR1_BIT8:       equ    %100000000
mATDDR1_BIT9:       equ    %1000000000
mATDDR1_BIT10:      equ    %10000000000
mATDDR1_BIT11:      equ    %100000000000
mATDDR1_BIT12:      equ    %1000000000000
mATDDR1_BIT13:      equ    %10000000000000
mATDDR1_BIT14:      equ    %100000000000000
mATDDR1_BIT15:      equ    %1000000000000000


;*** ATDDR1H - ATD Conversion Result Register 1 High; 0x00000092 ***
ATDDR1H:            equ    $00000092                                ;*** ATDDR1H - ATD Conversion Result Register 1 High; 0x00000092 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR1H_BIT8:       equ    0                                         ; Bit 8
ATDDR1H_BIT9:       equ    1                                         ; Bit 9
ATDDR1H_BIT10:      equ    2                                         ; Bit 10
ATDDR1H_BIT11:      equ    3                                         ; Bit 11
ATDDR1H_BIT12:      equ    4                                         ; Bit 12
ATDDR1H_BIT13:      equ    5                                         ; Bit 13
ATDDR1H_BIT14:      equ    6                                         ; Bit 14
ATDDR1H_BIT15:      equ    7                                         ; Bit 15
; bit position masks
mATDDR1H_BIT8:      equ    %00000001
mATDDR1H_BIT9:      equ    %00000010
mATDDR1H_BIT10:     equ    %00000100
mATDDR1H_BIT11:     equ    %00001000
mATDDR1H_BIT12:     equ    %00010000
mATDDR1H_BIT13:     equ    %00100000
mATDDR1H_BIT14:     equ    %01000000
mATDDR1H_BIT15:     equ    %10000000


;*** ATDDR1L - ATD Conversion Result Register 1 Low; 0x00000093 ***
ATDDR1L:            equ    $00000093                                ;*** ATDDR1L - ATD Conversion Result Register 1 Low; 0x00000093 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR1L_BIT6:       equ    6                                         ; Bit 6
ATDDR1L_BIT7:       equ    7                                         ; Bit 7
; bit position masks
mATDDR1L_BIT6:      equ    %01000000
mATDDR1L_BIT7:      equ    %10000000


;*** ATDDR2 - ATD Conversion Result Register 2; 0x00000094 ***
ATDDR2:             equ    $00000094                                ;*** ATDDR2 - ATD Conversion Result Register 2; 0x00000094 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR2_BIT6:        equ    6                                         ; Bit 6
ATDDR2_BIT7:        equ    7                                         ; Bit 7
ATDDR2_BIT8:        equ    8                                         ; Bit 8
ATDDR2_BIT9:        equ    9                                         ; Bit 9
ATDDR2_BIT10:       equ    10                                        ; Bit 10
ATDDR2_BIT11:       equ    11                                        ; Bit 11
ATDDR2_BIT12:       equ    12                                        ; Bit 12
ATDDR2_BIT13:       equ    13                                        ; Bit 13
ATDDR2_BIT14:       equ    14                                        ; Bit 14
ATDDR2_BIT15:       equ    15                                        ; Bit 15
; bit position masks
mATDDR2_BIT6:       equ    %01000000
mATDDR2_BIT7:       equ    %10000000
mATDDR2_BIT8:       equ    %100000000
mATDDR2_BIT9:       equ    %1000000000
mATDDR2_BIT10:      equ    %10000000000
mATDDR2_BIT11:      equ    %100000000000
mATDDR2_BIT12:      equ    %1000000000000
mATDDR2_BIT13:      equ    %10000000000000
mATDDR2_BIT14:      equ    %100000000000000
mATDDR2_BIT15:      equ    %1000000000000000


;*** ATDDR2H - ATD Conversion Result Register 2 High; 0x00000094 ***
ATDDR2H:            equ    $00000094                                ;*** ATDDR2H - ATD Conversion Result Register 2 High; 0x00000094 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR2H_BIT8:       equ    0                                         ; Bit 8
ATDDR2H_BIT9:       equ    1                                         ; Bit 9
ATDDR2H_BIT10:      equ    2                                         ; Bit 10
ATDDR2H_BIT11:      equ    3                                         ; Bit 11
ATDDR2H_BIT12:      equ    4                                         ; Bit 12
ATDDR2H_BIT13:      equ    5                                         ; Bit 13
ATDDR2H_BIT14:      equ    6                                         ; Bit 14
ATDDR2H_BIT15:      equ    7                                         ; Bit 15
; bit position masks
mATDDR2H_BIT8:      equ    %00000001
mATDDR2H_BIT9:      equ    %00000010
mATDDR2H_BIT10:     equ    %00000100
mATDDR2H_BIT11:     equ    %00001000
mATDDR2H_BIT12:     equ    %00010000
mATDDR2H_BIT13:     equ    %00100000
mATDDR2H_BIT14:     equ    %01000000
mATDDR2H_BIT15:     equ    %10000000


;*** ATDDR2L - ATD Conversion Result Register 2 Low; 0x00000095 ***
ATDDR2L:            equ    $00000095                                ;*** ATDDR2L - ATD Conversion Result Register 2 Low; 0x00000095 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR2L_BIT6:       equ    6                                         ; Bit 6
ATDDR2L_BIT7:       equ    7                                         ; Bit 7
; bit position masks
mATDDR2L_BIT6:      equ    %01000000
mATDDR2L_BIT7:      equ    %10000000


;*** ATDDR3 - ATD Conversion Result Register 3; 0x00000096 ***
ATDDR3:             equ    $00000096                                ;*** ATDDR3 - ATD Conversion Result Register 3; 0x00000096 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR3_BIT6:        equ    6                                         ; Bit 6
ATDDR3_BIT7:        equ    7                                         ; Bit 7
ATDDR3_BIT8:        equ    8                                         ; Bit 8
ATDDR3_BIT9:        equ    9                                         ; Bit 9
ATDDR3_BIT10:       equ    10                                        ; Bit 10
ATDDR3_BIT11:       equ    11                                        ; Bit 11
ATDDR3_BIT12:       equ    12                                        ; Bit 12
ATDDR3_BIT13:       equ    13                                        ; Bit 13
ATDDR3_BIT14:       equ    14                                        ; Bit 14
ATDDR3_BIT15:       equ    15                                        ; Bit 15
; bit position masks
mATDDR3_BIT6:       equ    %01000000
mATDDR3_BIT7:       equ    %10000000
mATDDR3_BIT8:       equ    %100000000
mATDDR3_BIT9:       equ    %1000000000
mATDDR3_BIT10:      equ    %10000000000
mATDDR3_BIT11:      equ    %100000000000
mATDDR3_BIT12:      equ    %1000000000000
mATDDR3_BIT13:      equ    %10000000000000
mATDDR3_BIT14:      equ    %100000000000000
mATDDR3_BIT15:      equ    %1000000000000000


;*** ATDDR3H - ATD Conversion Result Register 3 High; 0x00000096 ***
ATDDR3H:            equ    $00000096                                ;*** ATDDR3H - ATD Conversion Result Register 3 High; 0x00000096 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR3H_BIT8:       equ    0                                         ; Bit 8
ATDDR3H_BIT9:       equ    1                                         ; Bit 9
ATDDR3H_BIT10:      equ    2                                         ; Bit 10
ATDDR3H_BIT11:      equ    3                                         ; Bit 11
ATDDR3H_BIT12:      equ    4                                         ; Bit 12
ATDDR3H_BIT13:      equ    5                                         ; Bit 13
ATDDR3H_BIT14:      equ    6                                         ; Bit 14
ATDDR3H_BIT15:      equ    7                                         ; Bit 15
; bit position masks
mATDDR3H_BIT8:      equ    %00000001
mATDDR3H_BIT9:      equ    %00000010
mATDDR3H_BIT10:     equ    %00000100
mATDDR3H_BIT11:     equ    %00001000
mATDDR3H_BIT12:     equ    %00010000
mATDDR3H_BIT13:     equ    %00100000
mATDDR3H_BIT14:     equ    %01000000
mATDDR3H_BIT15:     equ    %10000000


;*** ATDDR3L - ATD Conversion Result Register 3 Low; 0x00000097 ***
ATDDR3L:            equ    $00000097                                ;*** ATDDR3L - ATD Conversion Result Register 3 Low; 0x00000097 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR3L_BIT6:       equ    6                                         ; Bit 6
ATDDR3L_BIT7:       equ    7                                         ; Bit 7
; bit position masks
mATDDR3L_BIT6:      equ    %01000000
mATDDR3L_BIT7:      equ    %10000000


;*** ATDDR4 - ATD Conversion Result Register 4; 0x00000098 ***
ATDDR4:             equ    $00000098                                ;*** ATDDR4 - ATD Conversion Result Register 4; 0x00000098 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR4_BIT6:        equ    6                                         ; Bit 6
ATDDR4_BIT7:        equ    7                                         ; Bit 7
ATDDR4_BIT8:        equ    8                                         ; Bit 8
ATDDR4_BIT9:        equ    9                                         ; Bit 9
ATDDR4_BIT10:       equ    10                                        ; Bit 10
ATDDR4_BIT11:       equ    11                                        ; Bit 11
ATDDR4_BIT12:       equ    12                                        ; Bit 12
ATDDR4_BIT13:       equ    13                                        ; Bit 13
ATDDR4_BIT14:       equ    14                                        ; Bit 14
ATDDR4_BIT15:       equ    15                                        ; Bit 15
; bit position masks
mATDDR4_BIT6:       equ    %01000000
mATDDR4_BIT7:       equ    %10000000
mATDDR4_BIT8:       equ    %100000000
mATDDR4_BIT9:       equ    %1000000000
mATDDR4_BIT10:      equ    %10000000000
mATDDR4_BIT11:      equ    %100000000000
mATDDR4_BIT12:      equ    %1000000000000
mATDDR4_BIT13:      equ    %10000000000000
mATDDR4_BIT14:      equ    %100000000000000
mATDDR4_BIT15:      equ    %1000000000000000


;*** ATDDR4H - ATD Conversion Result Register 4 High; 0x00000098 ***
ATDDR4H:            equ    $00000098                                ;*** ATDDR4H - ATD Conversion Result Register 4 High; 0x00000098 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR4H_BIT8:       equ    0                                         ; Bit 8
ATDDR4H_BIT9:       equ    1                                         ; Bit 9
ATDDR4H_BIT10:      equ    2                                         ; Bit 10
ATDDR4H_BIT11:      equ    3                                         ; Bit 11
ATDDR4H_BIT12:      equ    4                                         ; Bit 12
ATDDR4H_BIT13:      equ    5                                         ; Bit 13
ATDDR4H_BIT14:      equ    6                                         ; Bit 14
ATDDR4H_BIT15:      equ    7                                         ; Bit 15
; bit position masks
mATDDR4H_BIT8:      equ    %00000001
mATDDR4H_BIT9:      equ    %00000010
mATDDR4H_BIT10:     equ    %00000100
mATDDR4H_BIT11:     equ    %00001000
mATDDR4H_BIT12:     equ    %00010000
mATDDR4H_BIT13:     equ    %00100000
mATDDR4H_BIT14:     equ    %01000000
mATDDR4H_BIT15:     equ    %10000000


;*** ATDDR4L - ATD Conversion Result Register 4 Low; 0x00000099 ***
ATDDR4L:            equ    $00000099                                ;*** ATDDR4L - ATD Conversion Result Register 4 Low; 0x00000099 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR4L_BIT6:       equ    6                                         ; Bit 6
ATDDR4L_BIT7:       equ    7                                         ; Bit 7
; bit position masks
mATDDR4L_BIT6:      equ    %01000000
mATDDR4L_BIT7:      equ    %10000000


;*** ATDDR5 - ATD Conversion Result Register 5; 0x0000009A ***
ATDDR5:             equ    $0000009A                                ;*** ATDDR5 - ATD Conversion Result Register 5; 0x0000009A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR5_BIT6:        equ    6                                         ; Bit 6
ATDDR5_BIT7:        equ    7                                         ; Bit 7
ATDDR5_BIT8:        equ    8                                         ; Bit 8
ATDDR5_BIT9:        equ    9                                         ; Bit 9
ATDDR5_BIT10:       equ    10                                        ; Bit 10
ATDDR5_BIT11:       equ    11                                        ; Bit 11
ATDDR5_BIT12:       equ    12                                        ; Bit 12
ATDDR5_BIT13:       equ    13                                        ; Bit 13
ATDDR5_BIT14:       equ    14                                        ; Bit 14
ATDDR5_BIT15:       equ    15                                        ; Bit 15
; bit position masks
mATDDR5_BIT6:       equ    %01000000
mATDDR5_BIT7:       equ    %10000000
mATDDR5_BIT8:       equ    %100000000
mATDDR5_BIT9:       equ    %1000000000
mATDDR5_BIT10:      equ    %10000000000
mATDDR5_BIT11:      equ    %100000000000
mATDDR5_BIT12:      equ    %1000000000000
mATDDR5_BIT13:      equ    %10000000000000
mATDDR5_BIT14:      equ    %100000000000000
mATDDR5_BIT15:      equ    %1000000000000000


;*** ATDDR5H - ATD Conversion Result Register 5 High; 0x0000009A ***
ATDDR5H:            equ    $0000009A                                ;*** ATDDR5H - ATD Conversion Result Register 5 High; 0x0000009A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR5H_BIT8:       equ    0                                         ; Bit 8
ATDDR5H_BIT9:       equ    1                                         ; Bit 9
ATDDR5H_BIT10:      equ    2                                         ; Bit 10
ATDDR5H_BIT11:      equ    3                                         ; Bit 11
ATDDR5H_BIT12:      equ    4                                         ; Bit 12
ATDDR5H_BIT13:      equ    5                                         ; Bit 13
ATDDR5H_BIT14:      equ    6                                         ; Bit 14
ATDDR5H_BIT15:      equ    7                                         ; Bit 15
; bit position masks
mATDDR5H_BIT8:      equ    %00000001
mATDDR5H_BIT9:      equ    %00000010
mATDDR5H_BIT10:     equ    %00000100
mATDDR5H_BIT11:     equ    %00001000
mATDDR5H_BIT12:     equ    %00010000
mATDDR5H_BIT13:     equ    %00100000
mATDDR5H_BIT14:     equ    %01000000
mATDDR5H_BIT15:     equ    %10000000


;*** ATDDR5L - ATD Conversion Result Register 5 Low; 0x0000009B ***
ATDDR5L:            equ    $0000009B                                ;*** ATDDR5L - ATD Conversion Result Register 5 Low; 0x0000009B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR5L_BIT6:       equ    6                                         ; Bit 6
ATDDR5L_BIT7:       equ    7                                         ; Bit 7
; bit position masks
mATDDR5L_BIT6:      equ    %01000000
mATDDR5L_BIT7:      equ    %10000000


;*** ATDDR6 - ATD Conversion Result Register 6; 0x0000009C ***
ATDDR6:             equ    $0000009C                                ;*** ATDDR6 - ATD Conversion Result Register 6; 0x0000009C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR6_BIT6:        equ    6                                         ; Bit 6
ATDDR6_BIT7:        equ    7                                         ; Bit 7
ATDDR6_BIT8:        equ    8                                         ; Bit 8
ATDDR6_BIT9:        equ    9                                         ; Bit 9
ATDDR6_BIT10:       equ    10                                        ; Bit 10
ATDDR6_BIT11:       equ    11                                        ; Bit 11
ATDDR6_BIT12:       equ    12                                        ; Bit 12
ATDDR6_BIT13:       equ    13                                        ; Bit 13
ATDDR6_BIT14:       equ    14                                        ; Bit 14
ATDDR6_BIT15:       equ    15                                        ; Bit 15
; bit position masks
mATDDR6_BIT6:       equ    %01000000
mATDDR6_BIT7:       equ    %10000000
mATDDR6_BIT8:       equ    %100000000
mATDDR6_BIT9:       equ    %1000000000
mATDDR6_BIT10:      equ    %10000000000
mATDDR6_BIT11:      equ    %100000000000
mATDDR6_BIT12:      equ    %1000000000000
mATDDR6_BIT13:      equ    %10000000000000
mATDDR6_BIT14:      equ    %100000000000000
mATDDR6_BIT15:      equ    %1000000000000000


;*** ATDDR6H - ATD Conversion Result Register 6 High; 0x0000009C ***
ATDDR6H:            equ    $0000009C                                ;*** ATDDR6H - ATD Conversion Result Register 6 High; 0x0000009C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR6H_BIT8:       equ    0                                         ; Bit 8
ATDDR6H_BIT9:       equ    1                                         ; Bit 9
ATDDR6H_BIT10:      equ    2                                         ; Bit 10
ATDDR6H_BIT11:      equ    3                                         ; Bit 11
ATDDR6H_BIT12:      equ    4                                         ; Bit 12
ATDDR6H_BIT13:      equ    5                                         ; Bit 13
ATDDR6H_BIT14:      equ    6                                         ; Bit 14
ATDDR6H_BIT15:      equ    7                                         ; Bit 15
; bit position masks
mATDDR6H_BIT8:      equ    %00000001
mATDDR6H_BIT9:      equ    %00000010
mATDDR6H_BIT10:     equ    %00000100
mATDDR6H_BIT11:     equ    %00001000
mATDDR6H_BIT12:     equ    %00010000
mATDDR6H_BIT13:     equ    %00100000
mATDDR6H_BIT14:     equ    %01000000
mATDDR6H_BIT15:     equ    %10000000


;*** ATDDR6L - ATD Conversion Result Register 6 Low; 0x0000009D ***
ATDDR6L:            equ    $0000009D                                ;*** ATDDR6L - ATD Conversion Result Register 6 Low; 0x0000009D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR6L_BIT6:       equ    6                                         ; Bit 6
ATDDR6L_BIT7:       equ    7                                         ; Bit 7
; bit position masks
mATDDR6L_BIT6:      equ    %01000000
mATDDR6L_BIT7:      equ    %10000000


;*** ATDDR7 - ATD Conversion Result Register 7; 0x0000009E ***
ATDDR7:             equ    $0000009E                                ;*** ATDDR7 - ATD Conversion Result Register 7; 0x0000009E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR7_BIT6:        equ    6                                         ; Bit 6
ATDDR7_BIT7:        equ    7                                         ; Bit 7
ATDDR7_BIT8:        equ    8                                         ; Bit 8
ATDDR7_BIT9:        equ    9                                         ; Bit 9
ATDDR7_BIT10:       equ    10                                        ; Bit 10
ATDDR7_BIT11:       equ    11                                        ; Bit 11
ATDDR7_BIT12:       equ    12                                        ; Bit 12
ATDDR7_BIT13:       equ    13                                        ; Bit 13
ATDDR7_BIT14:       equ    14                                        ; Bit 14
ATDDR7_BIT15:       equ    15                                        ; Bit 15
; bit position masks
mATDDR7_BIT6:       equ    %01000000
mATDDR7_BIT7:       equ    %10000000
mATDDR7_BIT8:       equ    %100000000
mATDDR7_BIT9:       equ    %1000000000
mATDDR7_BIT10:      equ    %10000000000
mATDDR7_BIT11:      equ    %100000000000
mATDDR7_BIT12:      equ    %1000000000000
mATDDR7_BIT13:      equ    %10000000000000
mATDDR7_BIT14:      equ    %100000000000000
mATDDR7_BIT15:      equ    %1000000000000000


;*** ATDDR7H - ATD Conversion Result Register 7 High; 0x0000009E ***
ATDDR7H:            equ    $0000009E                                ;*** ATDDR7H - ATD Conversion Result Register 7 High; 0x0000009E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR7H_BIT8:       equ    0                                         ; Bit 8
ATDDR7H_BIT9:       equ    1                                         ; Bit 9
ATDDR7H_BIT10:      equ    2                                         ; Bit 10
ATDDR7H_BIT11:      equ    3                                         ; Bit 11
ATDDR7H_BIT12:      equ    4                                         ; Bit 12
ATDDR7H_BIT13:      equ    5                                         ; Bit 13
ATDDR7H_BIT14:      equ    6                                         ; Bit 14
ATDDR7H_BIT15:      equ    7                                         ; Bit 15
; bit position masks
mATDDR7H_BIT8:      equ    %00000001
mATDDR7H_BIT9:      equ    %00000010
mATDDR7H_BIT10:     equ    %00000100
mATDDR7H_BIT11:     equ    %00001000
mATDDR7H_BIT12:     equ    %00010000
mATDDR7H_BIT13:     equ    %00100000
mATDDR7H_BIT14:     equ    %01000000
mATDDR7H_BIT15:     equ    %10000000


;*** ATDDR7L - ATD Conversion Result Register 7 Low; 0x0000009F ***
ATDDR7L:            equ    $0000009F                                ;*** ATDDR7L - ATD Conversion Result Register 7 Low; 0x0000009F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR7L_BIT6:       equ    6                                         ; Bit 6
ATDDR7L_BIT7:       equ    7                                         ; Bit 7
; bit position masks
mATDDR7L_BIT6:      equ    %01000000
mATDDR7L_BIT7:      equ    %10000000


;*** SCIBD - SCI Baud Rate Register; 0x000000C8 ***
SCIBD:              equ    $000000C8                                ;*** SCIBD - SCI Baud Rate Register; 0x000000C8 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCIBD_SBR0:         equ    0                                         ; SCI Baud Rate Bit 0
SCIBD_SBR1:         equ    1                                         ; SCI Baud Rate Bit 1
SCIBD_SBR2:         equ    2                                         ; SCI Baud Rate Bit 2
SCIBD_SBR3:         equ    3                                         ; SCI Baud Rate Bit 3
SCIBD_SBR4:         equ    4                                         ; SCI Baud Rate Bit 4
SCIBD_SBR5:         equ    5                                         ; SCI Baud Rate Bit 5
SCIBD_SBR6:         equ    6                                         ; SCI Baud Rate Bit 6
SCIBD_SBR7:         equ    7                                         ; SCI Baud Rate Bit 7
SCIBD_SBR8:         equ    8                                         ; SCI Baud Rate Bit 8
SCIBD_SBR9:         equ    9                                         ; SCI Baud Rate Bit 9
SCIBD_SBR10:        equ    10                                        ; SCI Baud Rate Bit 10
SCIBD_SBR11:        equ    11                                        ; SCI Baud Rate Bit 11
SCIBD_SBR12:        equ    12                                        ; SCI Baud Rate Bit 12
; bit position masks
mSCIBD_SBR0:        equ    %00000001
mSCIBD_SBR1:        equ    %00000010
mSCIBD_SBR2:        equ    %00000100
mSCIBD_SBR3:        equ    %00001000
mSCIBD_SBR4:        equ    %00010000
mSCIBD_SBR5:        equ    %00100000
mSCIBD_SBR6:        equ    %01000000
mSCIBD_SBR7:        equ    %10000000
mSCIBD_SBR8:        equ    %100000000
mSCIBD_SBR9:        equ    %1000000000
mSCIBD_SBR10:       equ    %10000000000
mSCIBD_SBR11:       equ    %100000000000
mSCIBD_SBR12:       equ    %1000000000000


;*** SCIBDH - SCI Baud Rate Register High; 0x000000C8 ***
SCIBDH:             equ    $000000C8                                ;*** SCIBDH - SCI Baud Rate Register High; 0x000000C8 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCIBDH_SBR8:        equ    0                                         ; SCI Baud Rate Bit 8
SCIBDH_SBR9:        equ    1                                         ; SCI Baud Rate Bit 9
SCIBDH_SBR10:       equ    2                                         ; SCI Baud Rate Bit 10
SCIBDH_SBR11:       equ    3                                         ; SCI Baud Rate Bit 11
SCIBDH_SBR12:       equ    4                                         ; SCI Baud Rate Bit 12
; bit position masks
mSCIBDH_SBR8:       equ    %00000001
mSCIBDH_SBR9:       equ    %00000010
mSCIBDH_SBR10:      equ    %00000100
mSCIBDH_SBR11:      equ    %00001000
mSCIBDH_SBR12:      equ    %00010000


;*** SCIBDL - SCI Baud Rate Register Low; 0x000000C9 ***
SCIBDL:             equ    $000000C9                                ;*** SCIBDL - SCI Baud Rate Register Low; 0x000000C9 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCIBDL_SBR0:        equ    0                                         ; SCI Baud Rate Bit 0
SCIBDL_SBR1:        equ    1                                         ; SCI Baud Rate Bit 1
SCIBDL_SBR2:        equ    2                                         ; SCI Baud Rate Bit 2
SCIBDL_SBR3:        equ    3                                         ; SCI Baud Rate Bit 3
SCIBDL_SBR4:        equ    4                                         ; SCI Baud Rate Bit 4
SCIBDL_SBR5:        equ    5                                         ; SCI Baud Rate Bit 5
SCIBDL_SBR6:        equ    6                                         ; SCI Baud Rate Bit 6
SCIBDL_SBR7:        equ    7                                         ; SCI Baud Rate Bit 7
; bit position masks
mSCIBDL_SBR0:       equ    %00000001
mSCIBDL_SBR1:       equ    %00000010
mSCIBDL_SBR2:       equ    %00000100
mSCIBDL_SBR3:       equ    %00001000
mSCIBDL_SBR4:       equ    %00010000
mSCIBDL_SBR5:       equ    %00100000
mSCIBDL_SBR6:       equ    %01000000
mSCIBDL_SBR7:       equ    %10000000


;*** SCICR1 - SCI Control Register 1; 0x000000CA ***
SCICR1:             equ    $000000CA                                ;*** SCICR1 - SCI Control Register 1; 0x000000CA ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCICR1_PT:          equ    0                                         ; Parity Type Bit
SCICR1_PE:          equ    1                                         ; Parity Enable Bit
SCICR1_ILT:         equ    2                                         ; Idle Line Type Bit
SCICR1_WAKE:        equ    3                                         ; Wakeup Condition Bit
SCICR1_M:           equ    4                                         ; Data Format Mode Bit
SCICR1_RSRC:        equ    5                                         ; Receiver Source Bit
SCICR1_SCISWAI:     equ    6                                         ; SCI Stop in Wait Mode Bit
SCICR1_LOOPS:       equ    7                                         ; Loop Select Bit
; bit position masks
mSCICR1_PT:         equ    %00000001
mSCICR1_PE:         equ    %00000010
mSCICR1_ILT:        equ    %00000100
mSCICR1_WAKE:       equ    %00001000
mSCICR1_M:          equ    %00010000
mSCICR1_RSRC:       equ    %00100000
mSCICR1_SCISWAI:    equ    %01000000
mSCICR1_LOOPS:      equ    %10000000


;*** SCICR2 - SCI Control Register 2; 0x000000CB ***
SCICR2:             equ    $000000CB                                ;*** SCICR2 - SCI Control Register 2; 0x000000CB ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCICR2_SBK:         equ    0                                         ; Send Break Bit
SCICR2_RWU:         equ    1                                         ; Receiver Wakeup Bit
SCICR2_RE:          equ    2                                         ; Receiver Enable Bit
SCICR2_TE:          equ    3                                         ; Transmitter Enable Bit
SCICR2_ILIE:        equ    4                                         ; Idle Line Interrupt Enable Bit
SCICR2_RIE:         equ    5                                         ; Receiver Full Interrupt Enable Bit
SCICR2_TCIE:        equ    6                                         ; Transmission Complete Interrupt Enable Bit
SCICR2_SCTIE:       equ    7                                         ; Transmitter Interrupt Enable Bit
; bit position masks
mSCICR2_SBK:        equ    %00000001
mSCICR2_RWU:        equ    %00000010
mSCICR2_RE:         equ    %00000100
mSCICR2_TE:         equ    %00001000
mSCICR2_ILIE:       equ    %00010000
mSCICR2_RIE:        equ    %00100000
mSCICR2_TCIE:       equ    %01000000
mSCICR2_SCTIE:      equ    %10000000


;*** SCISR1 - SCI Status Register 1; 0x000000CC ***
SCISR1:             equ    $000000CC                                ;*** SCISR1 - SCI Status Register 1; 0x000000CC ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCISR1_PF:          equ    0                                         ; Parity Error Flag
SCISR1_FE:          equ    1                                         ; Framing Error Flag
SCISR1_NF:          equ    2                                         ; Noise Flag
SCISR1_OR:          equ    3                                         ; Overrun Flag
SCISR1_IDLE:        equ    4                                         ; Idle Line Flag
SCISR1_RDRF:        equ    5                                         ; Receive Data Register Full Flag
SCISR1_TC:          equ    6                                         ; Transmit Complete Flag
SCISR1_TDRE:        equ    7                                         ; Transmit Data Register Empty Flag
; bit position masks
mSCISR1_PF:         equ    %00000001
mSCISR1_FE:         equ    %00000010
mSCISR1_NF:         equ    %00000100
mSCISR1_OR:         equ    %00001000
mSCISR1_IDLE:       equ    %00010000
mSCISR1_RDRF:       equ    %00100000
mSCISR1_TC:         equ    %01000000
mSCISR1_TDRE:       equ    %10000000


;*** SCISR2 - SCI Status Register 2; 0x000000CD ***
SCISR2:             equ    $000000CD                                ;*** SCISR2 - SCI Status Register 2; 0x000000CD ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCISR2_RAF:         equ    0                                         ; Receiver Active Flag
SCISR2_TXDIR:       equ    1                                         ; Transmitter pin data direction in Single-Wire mode
SCISR2_BRK13:       equ    2                                         ; Break Transmit character length
; bit position masks
mSCISR2_RAF:        equ    %00000001
mSCISR2_TXDIR:      equ    %00000010
mSCISR2_BRK13:      equ    %00000100


;*** SCIDRH - SCI Data Register High; 0x000000CE ***
SCIDRH:             equ    $000000CE                                ;*** SCIDRH - SCI Data Register High; 0x000000CE ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCIDRH_T8:          equ    6                                         ; Transmit Bit 8
SCIDRH_R8:          equ    7                                         ; Received Bit 8
; bit position masks
mSCIDRH_T8:         equ    %01000000
mSCIDRH_R8:         equ    %10000000


;*** SCIDRL - SCI Data Register Low; 0x000000CF ***
SCIDRL:             equ    $000000CF                                ;*** SCIDRL - SCI Data Register Low; 0x000000CF ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCIDRL_R0_T0:       equ    0                                         ; Received bit 0 or Transmit bit 0
SCIDRL_R1_T1:       equ    1                                         ; Received bit 1 or Transmit bit 1
SCIDRL_R2_T2:       equ    2                                         ; Received bit 2 or Transmit bit 2
SCIDRL_R3_T3:       equ    3                                         ; Received bit 3 or Transmit bit 3
SCIDRL_R4_T4:       equ    4                                         ; Received bit 4 or Transmit bit 4
SCIDRL_R5_T5:       equ    5                                         ; Received bit 5 or Transmit bit 5
SCIDRL_R6_T6:       equ    6                                         ; Received bit 6 or Transmit bit 6
SCIDRL_R7_T7:       equ    7                                         ; Received bit 7 or Transmit bit 7
; bit position masks
mSCIDRL_R0_T0:      equ    %00000001
mSCIDRL_R1_T1:      equ    %00000010
mSCIDRL_R2_T2:      equ    %00000100
mSCIDRL_R3_T3:      equ    %00001000
mSCIDRL_R4_T4:      equ    %00010000
mSCIDRL_R5_T5:      equ    %00100000
mSCIDRL_R6_T6:      equ    %01000000
mSCIDRL_R7_T7:      equ    %10000000


;*** SPICR1 - SPI Control Register; 0x000000D8 ***
SPICR1:             equ    $000000D8                                ;*** SPICR1 - SPI Control Register; 0x000000D8 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPICR1_LSBFE:       equ    0                                         ; SPI LSB-First Enable
SPICR1_SSOE:        equ    1                                         ; Slave Select Output Enable
SPICR1_CPHA:        equ    2                                         ; SPI Clock Phase Bit
SPICR1_CPOL:        equ    3                                         ; SPI Clock Polarity Bit
SPICR1_MSTR:        equ    4                                         ; SPI Master/Slave Mode Select Bit
SPICR1_SPTIE:       equ    5                                         ; SPI Transmit Interrupt Enable
SPICR1_SPE:         equ    6                                         ; SPI System Enable Bit
SPICR1_SPIE:        equ    7                                         ; SPI Interrupt Enable Bit
; bit position masks
mSPICR1_LSBFE:      equ    %00000001
mSPICR1_SSOE:       equ    %00000010
mSPICR1_CPHA:       equ    %00000100
mSPICR1_CPOL:       equ    %00001000
mSPICR1_MSTR:       equ    %00010000
mSPICR1_SPTIE:      equ    %00100000
mSPICR1_SPE:        equ    %01000000
mSPICR1_SPIE:       equ    %10000000


;*** SPICR2 - SPI Control Register 2; 0x000000D9 ***
SPICR2:             equ    $000000D9                                ;*** SPICR2 - SPI Control Register 2; 0x000000D9 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPICR2_SPC0:        equ    0                                         ; Serial Pin Control Bit 0
SPICR2_SPISWAI:     equ    1                                         ; SPI Stop in Wait Mode Bit
SPICR2_BIDIROE:     equ    3                                         ; Output enable in the Bidirectional mode of operation
SPICR2_MODFEN:      equ    4                                         ; Mode Fault Enable Bit
; bit position masks
mSPICR2_SPC0:       equ    %00000001
mSPICR2_SPISWAI:    equ    %00000010
mSPICR2_BIDIROE:    equ    %00001000
mSPICR2_MODFEN:     equ    %00010000


;*** SPIBR - SPI Baud Rate Register; 0x000000DA ***
SPIBR:              equ    $000000DA                                ;*** SPIBR - SPI Baud Rate Register; 0x000000DA ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPIBR_SPR0:         equ    0                                         ; SPI Baud Rate Selection Bit 0
SPIBR_SPR1:         equ    1                                         ; SPI Baud Rate Selection Bit 1
SPIBR_SPR2:         equ    2                                         ; SPI Baud Rate Selection Bit 2
SPIBR_SPPR0:        equ    4                                         ; SPI Baud Rate Preselection Bits 0
SPIBR_SPPR1:        equ    5                                         ; SPI Baud Rate Preselection Bits 1
SPIBR_SPPR2:        equ    6                                         ; SPI Baud Rate Preselection Bits 2
; bit position masks
mSPIBR_SPR0:        equ    %00000001
mSPIBR_SPR1:        equ    %00000010
mSPIBR_SPR2:        equ    %00000100
mSPIBR_SPPR0:       equ    %00010000
mSPIBR_SPPR1:       equ    %00100000
mSPIBR_SPPR2:       equ    %01000000


;*** SPISR - SPI Status Register; 0x000000DB ***
SPISR:              equ    $000000DB                                ;*** SPISR - SPI Status Register; 0x000000DB ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPISR_MODF:         equ    4                                         ; Mode Fault Flag
SPISR_SPTEF:        equ    5                                         ; SPI Transmit Empty Interrupt Flag
SPISR_SPIF:         equ    7                                         ; SPIF Receive Interrupt Flag
; bit position masks
mSPISR_MODF:        equ    %00010000
mSPISR_SPTEF:       equ    %00100000
mSPISR_SPIF:        equ    %10000000


;*** SPIDR - SPI Data Register; 0x000000DD ***
SPIDR:              equ    $000000DD                                ;*** SPIDR - SPI Data Register; 0x000000DD ***


;*** FCLKDIV - Flash Clock Divider Register; 0x00000100 ***
FCLKDIV:            equ    $00000100                                ;*** FCLKDIV - Flash Clock Divider Register; 0x00000100 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FCLKDIV_FDIV0:      equ    0                                         ; Flash Clock Divider Bit 0
FCLKDIV_FDIV1:      equ    1                                         ; Flash Clock Divider Bit 1
FCLKDIV_FDIV2:      equ    2                                         ; Flash Clock Divider Bit 2
FCLKDIV_FDIV3:      equ    3                                         ; Flash Clock Divider Bit 3
FCLKDIV_FDIV4:      equ    4                                         ; Flash Clock Divider Bit 4
FCLKDIV_FDIV5:      equ    5                                         ; Flash Clock Divider Bit 5
FCLKDIV_PRDIV8:     equ    6                                         ; Enable Prescaler by 8
FCLKDIV_FDIVLD:     equ    7                                         ; Flash Clock Divider Loaded
; bit position masks
mFCLKDIV_FDIV0:     equ    %00000001
mFCLKDIV_FDIV1:     equ    %00000010
mFCLKDIV_FDIV2:     equ    %00000100
mFCLKDIV_FDIV3:     equ    %00001000
mFCLKDIV_FDIV4:     equ    %00010000
mFCLKDIV_FDIV5:     equ    %00100000
mFCLKDIV_PRDIV8:    equ    %01000000
mFCLKDIV_FDIVLD:    equ    %10000000


;*** FSEC - Flash Security Register; 0x00000101 ***
FSEC:               equ    $00000101                                ;*** FSEC - Flash Security Register; 0x00000101 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FSEC_SEC0:          equ    0                                         ; Memory security bit 0
FSEC_SEC1:          equ    1                                         ; Memory security bit 1
FSEC_NV2:           equ    2                                         ; Non Volatile flag bit 2
FSEC_NV3:           equ    3                                         ; Non Volatile flag bit 3
FSEC_NV4:           equ    4                                         ; Non Volatile flag bit 4
FSEC_NV5:           equ    5                                         ; Non Volatile flag bit 5
FSEC_KEYEN0:        equ    6                                         ; Backdoor Key Security Enable Bit 0
FSEC_KEYEN1:        equ    7                                         ; Backdoor Key Security Enable Bit 1
; bit position masks
mFSEC_SEC0:         equ    %00000001
mFSEC_SEC1:         equ    %00000010
mFSEC_NV2:          equ    %00000100
mFSEC_NV3:          equ    %00001000
mFSEC_NV4:          equ    %00010000
mFSEC_NV5:          equ    %00100000
mFSEC_KEYEN0:       equ    %01000000
mFSEC_KEYEN1:       equ    %10000000


;*** FCNFG - Flash Configuration Register; 0x00000103 ***
FCNFG:              equ    $00000103                                ;*** FCNFG - Flash Configuration Register; 0x00000103 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FCNFG_KEYACC:       equ    5                                         ; Enable Security Key Writing
FCNFG_CCIE:         equ    6                                         ; Command Complete Interrupt Enable
FCNFG_CBEIE:        equ    7                                         ; Command Buffers Empty Interrupt Enable
; bit position masks
mFCNFG_KEYACC:      equ    %00100000
mFCNFG_CCIE:        equ    %01000000
mFCNFG_CBEIE:       equ    %10000000


;*** FPROT - Flash Protection Register; 0x00000104 ***
FPROT:              equ    $00000104                                ;*** FPROT - Flash Protection Register; 0x00000104 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FPROT_FPLS0:        equ    0                                         ; Flash Protection Lower Address size 0
FPROT_FPLS1:        equ    1                                         ; Flash Protection Lower Address size 1
FPROT_FPLDIS:       equ    2                                         ; Flash Protection Lower address range disable
FPROT_FPHS0:        equ    3                                         ; Flash Protection Higher address size 0
FPROT_FPHS1:        equ    4                                         ; Flash Protection Higher address size 1
FPROT_FPHDIS:       equ    5                                         ; Flash Protection Higher address range disable
FPROT_NV6:          equ    6                                         ; Non Volatile Flag Bit
FPROT_FPOPEN:       equ    7                                         ; Opens the flash block or subsections of it for program or erase
; bit position masks
mFPROT_FPLS0:       equ    %00000001
mFPROT_FPLS1:       equ    %00000010
mFPROT_FPLDIS:      equ    %00000100
mFPROT_FPHS0:       equ    %00001000
mFPROT_FPHS1:       equ    %00010000
mFPROT_FPHDIS:      equ    %00100000
mFPROT_NV6:         equ    %01000000
mFPROT_FPOPEN:      equ    %10000000


;*** FSTAT - Flash Status Register; 0x00000105 ***
FSTAT:              equ    $00000105                                ;*** FSTAT - Flash Status Register; 0x00000105 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FSTAT_BLANK:        equ    2                                         ; Blank Verify Flag
FSTAT_ACCERR:       equ    4                                         ; Access error
FSTAT_PVIOL:        equ    5                                         ; Protection violation
FSTAT_CCIF:         equ    6                                         ; Command Complete Interrupt Flag
FSTAT_CBEIF:        equ    7                                         ; Command Buffers Empty Interrupt Flag
; bit position masks
mFSTAT_BLANK:       equ    %00000100
mFSTAT_ACCERR:      equ    %00010000
mFSTAT_PVIOL:       equ    %00100000
mFSTAT_CCIF:        equ    %01000000
mFSTAT_CBEIF:       equ    %10000000


;*** FCMD - Flash Command Buffer and Register; 0x00000106 ***
FCMD:               equ    $00000106                                ;*** FCMD - Flash Command Buffer and Register; 0x00000106 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FCMD_CMDB0:         equ    0                                         ; NVM User Mode Command Bit 0
FCMD_CMDB2:         equ    2                                         ; NVM User Mode Command Bit 2
FCMD_CMDB5:         equ    5                                         ; NVM User Mode Command Bit 5
FCMD_CMDB6:         equ    6                                         ; NVM User Mode Command Bit 6
; bit position masks
mFCMD_CMDB0:        equ    %00000001
mFCMD_CMDB2:        equ    %00000100
mFCMD_CMDB5:        equ    %00100000
mFCMD_CMDB6:        equ    %01000000


;*** CANCTL0 - MSCAN Control 0 Register; 0x00000140 ***
CANCTL0:            equ    $00000140                                ;*** CANCTL0 - MSCAN Control 0 Register; 0x00000140 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANCTL0_INITRQ:     equ    0                                         ; Initialization Mode Request
CANCTL0_SLPRQ:      equ    1                                         ; Sleep Mode Request
CANCTL0_WUPE:       equ    2                                         ; Wake-Up Enable
CANCTL0_TIME:       equ    3                                         ; Timer Enable
CANCTL0_SYNCH:      equ    4                                         ; Synchronized Status
CANCTL0_CSWAI:      equ    5                                         ; CAN Stops in Wait Mode
CANCTL0_RXACT:      equ    6                                         ; Receiver Active Status
CANCTL0_RXFRM:      equ    7                                         ; Received Frame Flag
; bit position masks
mCANCTL0_INITRQ:    equ    %00000001
mCANCTL0_SLPRQ:     equ    %00000010
mCANCTL0_WUPE:      equ    %00000100
mCANCTL0_TIME:      equ    %00001000
mCANCTL0_SYNCH:     equ    %00010000
mCANCTL0_CSWAI:     equ    %00100000
mCANCTL0_RXACT:     equ    %01000000
mCANCTL0_RXFRM:     equ    %10000000


;*** CANCTL1 - MSCAN Control 1 Register; 0x00000141 ***
CANCTL1:            equ    $00000141                                ;*** CANCTL1 - MSCAN Control 1 Register; 0x00000141 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANCTL1_INITAK:     equ    0                                         ; Initialization Mode Acknowledge
CANCTL1_SLPAK:      equ    1                                         ; Sleep Mode Acknowledge
CANCTL1_WUPM:       equ    2                                         ; Wake-Up Mode
CANCTL1_LISTEN:     equ    4                                         ; Listen Only Mode
CANCTL1_LOOPB:      equ    5                                         ; Loop Back Self Test Mode
CANCTL1_CLKSRC:     equ    6                                         ; MSCAN Clock Source
CANCTL1_CANE:       equ    7                                         ; MSCAN Enable
; bit position masks
mCANCTL1_INITAK:    equ    %00000001
mCANCTL1_SLPAK:     equ    %00000010
mCANCTL1_WUPM:      equ    %00000100
mCANCTL1_LISTEN:    equ    %00010000
mCANCTL1_LOOPB:     equ    %00100000
mCANCTL1_CLKSRC:    equ    %01000000
mCANCTL1_CANE:      equ    %10000000


;*** CANBTR0 - MSCAN Bus Timing Register 0; 0x00000142 ***
CANBTR0:            equ    $00000142                                ;*** CANBTR0 - MSCAN Bus Timing Register 0; 0x00000142 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANBTR0_BRP0:       equ    0                                         ; Baud Rate Prescaler 0
CANBTR0_BRP1:       equ    1                                         ; Baud Rate Prescaler 1
CANBTR0_BRP2:       equ    2                                         ; Baud Rate Prescaler 2
CANBTR0_BRP3:       equ    3                                         ; Baud Rate Prescaler 3
CANBTR0_BRP4:       equ    4                                         ; Baud Rate Prescaler 4
CANBTR0_BRP5:       equ    5                                         ; Baud Rate Prescaler 5
CANBTR0_SJW0:       equ    6                                         ; Synchronization Jump Width 0
CANBTR0_SJW1:       equ    7                                         ; Synchronization Jump Width 1
; bit position masks
mCANBTR0_BRP0:      equ    %00000001
mCANBTR0_BRP1:      equ    %00000010
mCANBTR0_BRP2:      equ    %00000100
mCANBTR0_BRP3:      equ    %00001000
mCANBTR0_BRP4:      equ    %00010000
mCANBTR0_BRP5:      equ    %00100000
mCANBTR0_SJW0:      equ    %01000000
mCANBTR0_SJW1:      equ    %10000000


;*** CANBTR1 - MSCAN Bus Timing Register 1; 0x00000143 ***
CANBTR1:            equ    $00000143                                ;*** CANBTR1 - MSCAN Bus Timing Register 1; 0x00000143 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANBTR1_TSEG10:     equ    0                                         ; Time Segment 10
CANBTR1_TSEG11:     equ    1                                         ; Time Segment 11
CANBTR1_TSEG12:     equ    2                                         ; Time Segment 12
CANBTR1_TSEG13:     equ    3                                         ; Time Segment 13
CANBTR1_TSEG20:     equ    4                                         ; Time Segment 20
CANBTR1_TSEG21:     equ    5                                         ; Time Segment 21
CANBTR1_TSEG22:     equ    6                                         ; Time Segment 22
CANBTR1_SAMP:       equ    7                                         ; Sampling
; bit position masks
mCANBTR1_TSEG10:    equ    %00000001
mCANBTR1_TSEG11:    equ    %00000010
mCANBTR1_TSEG12:    equ    %00000100
mCANBTR1_TSEG13:    equ    %00001000
mCANBTR1_TSEG20:    equ    %00010000
mCANBTR1_TSEG21:    equ    %00100000
mCANBTR1_TSEG22:    equ    %01000000
mCANBTR1_SAMP:      equ    %10000000


;*** CANRFLG - MSCAN Receiver Flag Register; 0x00000144 ***
CANRFLG:            equ    $00000144                                ;*** CANRFLG - MSCAN Receiver Flag Register; 0x00000144 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANRFLG_RXF:        equ    0                                         ; Receive Buffer Full
CANRFLG_OVRIF:      equ    1                                         ; Overrun Interrupt Flag
CANRFLG_TSTAT0:     equ    2                                         ; Transmitter Status Bit 0
CANRFLG_TSTAT1:     equ    3                                         ; Transmitter Status Bit 1
CANRFLG_RSTAT0:     equ    4                                         ; Receiver Status Bit 0
CANRFLG_RSTAT1:     equ    5                                         ; Receiver Status Bit 1
CANRFLG_CSCIF:      equ    6                                         ; CAN Status Change Interrupt Flag
CANRFLG_WUPIF:      equ    7                                         ; Wake-up Interrupt Flag
; bit position masks
mCANRFLG_RXF:       equ    %00000001
mCANRFLG_OVRIF:     equ    %00000010
mCANRFLG_TSTAT0:    equ    %00000100
mCANRFLG_TSTAT1:    equ    %00001000
mCANRFLG_RSTAT0:    equ    %00010000
mCANRFLG_RSTAT1:    equ    %00100000
mCANRFLG_CSCIF:     equ    %01000000
mCANRFLG_WUPIF:     equ    %10000000


;*** CANRIER - MSCAN Receiver Interrupt Enable Register; 0x00000145 ***
CANRIER:            equ    $00000145                                ;*** CANRIER - MSCAN Receiver Interrupt Enable Register; 0x00000145 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANRIER_RXFIE:      equ    0                                         ; Receiver Full Interrupt Enable
CANRIER_OVRIE:      equ    1                                         ; Overrun Interrupt Enable
CANRIER_TSTATE0:    equ    2                                         ; Transmitter Status Change Enable 0
CANRIER_TSTATE1:    equ    3                                         ; Transmitter Status Change Enable 1
CANRIER_RSTATE0:    equ    4                                         ; Receiver Status Change Enable 0
CANRIER_RSTATE1:    equ    5                                         ; Receiver Status Change Enable 1
CANRIER_CSCIE:      equ    6                                         ; CAN Status Change Interrupt Enable
CANRIER_WUPIE:      equ    7                                         ; Wake-up Interrupt Enable
; bit position masks
mCANRIER_RXFIE:     equ    %00000001
mCANRIER_OVRIE:     equ    %00000010
mCANRIER_TSTATE0:   equ    %00000100
mCANRIER_TSTATE1:   equ    %00001000
mCANRIER_RSTATE0:   equ    %00010000
mCANRIER_RSTATE1:   equ    %00100000
mCANRIER_CSCIE:     equ    %01000000
mCANRIER_WUPIE:     equ    %10000000


;*** CANTFLG - MSCAN Transmitter Flag Register; 0x00000146 ***
CANTFLG:            equ    $00000146                                ;*** CANTFLG - MSCAN Transmitter Flag Register; 0x00000146 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANTFLG_TXE0:       equ    0                                         ; Transmitter Buffer Empty 0
CANTFLG_TXE1:       equ    1                                         ; Transmitter Buffer Empty 1
CANTFLG_TXE2:       equ    2                                         ; Transmitter Buffer Empty 2
; bit position masks
mCANTFLG_TXE0:      equ    %00000001
mCANTFLG_TXE1:      equ    %00000010
mCANTFLG_TXE2:      equ    %00000100


;*** CANTIER - MSCAN Transmitter Interrupt Enable Register; 0x00000147 ***
CANTIER:            equ    $00000147                                ;*** CANTIER - MSCAN Transmitter Interrupt Enable Register; 0x00000147 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANTIER_TXEIE0:     equ    0                                         ; Transmitter Empty Interrupt Enable 0
CANTIER_TXEIE1:     equ    1                                         ; Transmitter Empty Interrupt Enable 1
CANTIER_TXEIE2:     equ    2                                         ; Transmitter Empty Interrupt Enable 2
; bit position masks
mCANTIER_TXEIE0:    equ    %00000001
mCANTIER_TXEIE1:    equ    %00000010
mCANTIER_TXEIE2:    equ    %00000100


;*** CANTARQ - MSCAN Transmitter Message Abort Request; 0x00000148 ***
CANTARQ:            equ    $00000148                                ;*** CANTARQ - MSCAN Transmitter Message Abort Request; 0x00000148 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANTARQ_ABTRQ0:     equ    0                                         ; Abort Request 0
CANTARQ_ABTRQ1:     equ    1                                         ; Abort Request 1
CANTARQ_ABTRQ2:     equ    2                                         ; Abort Request 2
; bit position masks
mCANTARQ_ABTRQ0:    equ    %00000001
mCANTARQ_ABTRQ1:    equ    %00000010
mCANTARQ_ABTRQ2:    equ    %00000100


;*** CANTAAK - MSCAN Transmitter Message Abort Control; 0x00000149 ***
CANTAAK:            equ    $00000149                                ;*** CANTAAK - MSCAN Transmitter Message Abort Control; 0x00000149 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANTAAK_ABTAK0:     equ    0                                         ; Abort Acknowledge 0
CANTAAK_ABTAK1:     equ    1                                         ; Abort Acknowledge 1
CANTAAK_ABTAK2:     equ    2                                         ; Abort Acknowledge 2
; bit position masks
mCANTAAK_ABTAK0:    equ    %00000001
mCANTAAK_ABTAK1:    equ    %00000010
mCANTAAK_ABTAK2:    equ    %00000100


;*** CANTBSEL - MSCAN Transmit Buffer Selection; 0x0000014A ***
CANTBSEL:           equ    $0000014A                                ;*** CANTBSEL - MSCAN Transmit Buffer Selection; 0x0000014A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANTBSEL_TX0:       equ    0                                         ; Transmit Buffer Select 0
CANTBSEL_TX1:       equ    1                                         ; Transmit Buffer Select 1
CANTBSEL_TX2:       equ    2                                         ; Transmit Buffer Select 2
; bit position masks
mCANTBSEL_TX0:      equ    %00000001
mCANTBSEL_TX1:      equ    %00000010
mCANTBSEL_TX2:      equ    %00000100


;*** CANIDAC - MSCAN Identifier Acceptance Control Register; 0x0000014B ***
CANIDAC:            equ    $0000014B                                ;*** CANIDAC - MSCAN Identifier Acceptance Control Register; 0x0000014B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANIDAC_IDHIT0:     equ    0                                         ; Identifier Acceptance Hit Indicator 0
CANIDAC_IDHIT1:     equ    1                                         ; Identifier Acceptance Hit Indicator 1
CANIDAC_IDHIT2:     equ    2                                         ; Identifier Acceptance Hit Indicator 2
CANIDAC_IDAM0:      equ    4                                         ; Identifier Acceptance Mode 0
CANIDAC_IDAM1:      equ    5                                         ; Identifier Acceptance Mode 1
; bit position masks
mCANIDAC_IDHIT0:    equ    %00000001
mCANIDAC_IDHIT1:    equ    %00000010
mCANIDAC_IDHIT2:    equ    %00000100
mCANIDAC_IDAM0:     equ    %00010000
mCANIDAC_IDAM1:     equ    %00100000


;*** CANRXERR - MSCAN Receive Error Counter Register; 0x0000014E ***
CANRXERR:           equ    $0000014E                                ;*** CANRXERR - MSCAN Receive Error Counter Register; 0x0000014E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANRXERR_RXERR0:    equ    0                                         ; Bit 0
CANRXERR_RXERR1:    equ    1                                         ; Bit 1
CANRXERR_RXERR2:    equ    2                                         ; Bit 2
CANRXERR_RXERR3:    equ    3                                         ; Bit 3
CANRXERR_RXERR4:    equ    4                                         ; Bit 4
CANRXERR_RXERR5:    equ    5                                         ; Bit 5
CANRXERR_RXERR6:    equ    6                                         ; Bit 6
CANRXERR_RXERR7:    equ    7                                         ; Bit 7
; bit position masks
mCANRXERR_RXERR0:   equ    %00000001
mCANRXERR_RXERR1:   equ    %00000010
mCANRXERR_RXERR2:   equ    %00000100
mCANRXERR_RXERR3:   equ    %00001000
mCANRXERR_RXERR4:   equ    %00010000
mCANRXERR_RXERR5:   equ    %00100000
mCANRXERR_RXERR6:   equ    %01000000
mCANRXERR_RXERR7:   equ    %10000000


;*** CANTXERR - MSCAN Transmit Error Counter Register; 0x0000014F ***
CANTXERR:           equ    $0000014F                                ;*** CANTXERR - MSCAN Transmit Error Counter Register; 0x0000014F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANTXERR_TXERR0:    equ    0                                         ; Bit 0
CANTXERR_TXERR1:    equ    1                                         ; Bit 1
CANTXERR_TXERR2:    equ    2                                         ; Bit 2
CANTXERR_TXERR3:    equ    3                                         ; Bit 3
CANTXERR_TXERR4:    equ    4                                         ; Bit 4
CANTXERR_TXERR5:    equ    5                                         ; Bit 5
CANTXERR_TXERR6:    equ    6                                         ; Bit 6
CANTXERR_TXERR7:    equ    7                                         ; Bit 7
; bit position masks
mCANTXERR_TXERR0:   equ    %00000001
mCANTXERR_TXERR1:   equ    %00000010
mCANTXERR_TXERR2:   equ    %00000100
mCANTXERR_TXERR3:   equ    %00001000
mCANTXERR_TXERR4:   equ    %00010000
mCANTXERR_TXERR5:   equ    %00100000
mCANTXERR_TXERR6:   equ    %01000000
mCANTXERR_TXERR7:   equ    %10000000


;*** CANIDAR0 - MSCAN Identifier Acceptance Register 0; 0x00000150 ***
CANIDAR0:           equ    $00000150                                ;*** CANIDAR0 - MSCAN Identifier Acceptance Register 0; 0x00000150 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANIDAR0_AC0:       equ    0                                         ; Acceptance Code Bit 0
CANIDAR0_AC1:       equ    1                                         ; Acceptance Code Bit 1
CANIDAR0_AC2:       equ    2                                         ; Acceptance Code Bit 2
CANIDAR0_AC3:       equ    3                                         ; Acceptance Code Bit 3
CANIDAR0_AC4:       equ    4                                         ; Acceptance Code Bit 4
CANIDAR0_AC5:       equ    5                                         ; Acceptance Code Bit 5
CANIDAR0_AC6:       equ    6                                         ; Acceptance Code Bit 6
CANIDAR0_AC7:       equ    7                                         ; Acceptance Code Bit 7
; bit position masks
mCANIDAR0_AC0:      equ    %00000001
mCANIDAR0_AC1:      equ    %00000010
mCANIDAR0_AC2:      equ    %00000100
mCANIDAR0_AC3:      equ    %00001000
mCANIDAR0_AC4:      equ    %00010000
mCANIDAR0_AC5:      equ    %00100000
mCANIDAR0_AC6:      equ    %01000000
mCANIDAR0_AC7:      equ    %10000000


;*** CANIDAR1 - MSCAN Identifier Acceptance Register 1; 0x00000151 ***
CANIDAR1:           equ    $00000151                                ;*** CANIDAR1 - MSCAN Identifier Acceptance Register 1; 0x00000151 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANIDAR1_AC0:       equ    0                                         ; Acceptance Code Bit 0
CANIDAR1_AC1:       equ    1                                         ; Acceptance Code Bit 1
CANIDAR1_AC2:       equ    2                                         ; Acceptance Code Bit 2
CANIDAR1_AC3:       equ    3                                         ; Acceptance Code Bit 3
CANIDAR1_AC4:       equ    4                                         ; Acceptance Code Bit 4
CANIDAR1_AC5:       equ    5                                         ; Acceptance Code Bit 5
CANIDAR1_AC6:       equ    6                                         ; Acceptance Code Bit 6
CANIDAR1_AC7:       equ    7                                         ; Acceptance Code Bit 7
; bit position masks
mCANIDAR1_AC0:      equ    %00000001
mCANIDAR1_AC1:      equ    %00000010
mCANIDAR1_AC2:      equ    %00000100
mCANIDAR1_AC3:      equ    %00001000
mCANIDAR1_AC4:      equ    %00010000
mCANIDAR1_AC5:      equ    %00100000
mCANIDAR1_AC6:      equ    %01000000
mCANIDAR1_AC7:      equ    %10000000


;*** CANIDAR2 - MSCAN Identifier Acceptance Register 2; 0x00000152 ***
CANIDAR2:           equ    $00000152                                ;*** CANIDAR2 - MSCAN Identifier Acceptance Register 2; 0x00000152 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANIDAR2_AC0:       equ    0                                         ; Acceptance Code Bit 0
CANIDAR2_AC1:       equ    1                                         ; Acceptance Code Bit 1
CANIDAR2_AC2:       equ    2                                         ; Acceptance Code Bit 2
CANIDAR2_AC3:       equ    3                                         ; Acceptance Code Bit 3
CANIDAR2_AC4:       equ    4                                         ; Acceptance Code Bit 4
CANIDAR2_AC5:       equ    5                                         ; Acceptance Code Bit 5
CANIDAR2_AC6:       equ    6                                         ; Acceptance Code Bit 6
CANIDAR2_AC7:       equ    7                                         ; Acceptance Code Bit 7
; bit position masks
mCANIDAR2_AC0:      equ    %00000001
mCANIDAR2_AC1:      equ    %00000010
mCANIDAR2_AC2:      equ    %00000100
mCANIDAR2_AC3:      equ    %00001000
mCANIDAR2_AC4:      equ    %00010000
mCANIDAR2_AC5:      equ    %00100000
mCANIDAR2_AC6:      equ    %01000000
mCANIDAR2_AC7:      equ    %10000000


;*** CANIDAR3 - MSCAN Identifier Acceptance Register 3; 0x00000153 ***
CANIDAR3:           equ    $00000153                                ;*** CANIDAR3 - MSCAN Identifier Acceptance Register 3; 0x00000153 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANIDAR3_AC0:       equ    0                                         ; Acceptance Code Bit 0
CANIDAR3_AC1:       equ    1                                         ; Acceptance Code Bit 1
CANIDAR3_AC2:       equ    2                                         ; Acceptance Code Bit 2
CANIDAR3_AC3:       equ    3                                         ; Acceptance Code Bit 3
CANIDAR3_AC4:       equ    4                                         ; Acceptance Code Bit 4
CANIDAR3_AC5:       equ    5                                         ; Acceptance Code Bit 5
CANIDAR3_AC6:       equ    6                                         ; Acceptance Code Bit 6
CANIDAR3_AC7:       equ    7                                         ; Acceptance Code Bit 7
; bit position masks
mCANIDAR3_AC0:      equ    %00000001
mCANIDAR3_AC1:      equ    %00000010
mCANIDAR3_AC2:      equ    %00000100
mCANIDAR3_AC3:      equ    %00001000
mCANIDAR3_AC4:      equ    %00010000
mCANIDAR3_AC5:      equ    %00100000
mCANIDAR3_AC6:      equ    %01000000
mCANIDAR3_AC7:      equ    %10000000


;*** CANIDMR0 - MSCAN Identifier Mask Register 0; 0x00000154 ***
CANIDMR0:           equ    $00000154                                ;*** CANIDMR0 - MSCAN Identifier Mask Register 0; 0x00000154 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANIDMR0_AM0:       equ    0                                         ; Acceptance Mask Bit 0
CANIDMR0_AM1:       equ    1                                         ; Acceptance Mask Bit 1
CANIDMR0_AM2:       equ    2                                         ; Acceptance Mask Bit 2
CANIDMR0_AM3:       equ    3                                         ; Acceptance Mask Bit 3
CANIDMR0_AM4:       equ    4                                         ; Acceptance Mask Bit 4
CANIDMR0_AM5:       equ    5                                         ; Acceptance Mask Bit 5
CANIDMR0_AM6:       equ    6                                         ; Acceptance Mask Bit 6
CANIDMR0_AM7:       equ    7                                         ; Acceptance Mask Bit 7
; bit position masks
mCANIDMR0_AM0:      equ    %00000001
mCANIDMR0_AM1:      equ    %00000010
mCANIDMR0_AM2:      equ    %00000100
mCANIDMR0_AM3:      equ    %00001000
mCANIDMR0_AM4:      equ    %00010000
mCANIDMR0_AM5:      equ    %00100000
mCANIDMR0_AM6:      equ    %01000000
mCANIDMR0_AM7:      equ    %10000000


;*** CANIDMR1 - MSCAN Identifier Mask Register 1; 0x00000155 ***
CANIDMR1:           equ    $00000155                                ;*** CANIDMR1 - MSCAN Identifier Mask Register 1; 0x00000155 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANIDMR1_AM0:       equ    0                                         ; Acceptance Mask Bit 0
CANIDMR1_AM1:       equ    1                                         ; Acceptance Mask Bit 1
CANIDMR1_AM2:       equ    2                                         ; Acceptance Mask Bit 2
CANIDMR1_AM3:       equ    3                                         ; Acceptance Mask Bit 3
CANIDMR1_AM4:       equ    4                                         ; Acceptance Mask Bit 4
CANIDMR1_AM5:       equ    5                                         ; Acceptance Mask Bit 5
CANIDMR1_AM6:       equ    6                                         ; Acceptance Mask Bit 6
CANIDMR1_AM7:       equ    7                                         ; Acceptance Mask Bit 7
; bit position masks
mCANIDMR1_AM0:      equ    %00000001
mCANIDMR1_AM1:      equ    %00000010
mCANIDMR1_AM2:      equ    %00000100
mCANIDMR1_AM3:      equ    %00001000
mCANIDMR1_AM4:      equ    %00010000
mCANIDMR1_AM5:      equ    %00100000
mCANIDMR1_AM6:      equ    %01000000
mCANIDMR1_AM7:      equ    %10000000


;*** CANIDMR2 - MSCAN Identifier Mask Register 2; 0x00000156 ***
CANIDMR2:           equ    $00000156                                ;*** CANIDMR2 - MSCAN Identifier Mask Register 2; 0x00000156 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANIDMR2_AM0:       equ    0                                         ; Acceptance Mask Bit 0
CANIDMR2_AM1:       equ    1                                         ; Acceptance Mask Bit 1
CANIDMR2_AM2:       equ    2                                         ; Acceptance Mask Bit 2
CANIDMR2_AM3:       equ    3                                         ; Acceptance Mask Bit 3
CANIDMR2_AM4:       equ    4                                         ; Acceptance Mask Bit 4
CANIDMR2_AM5:       equ    5                                         ; Acceptance Mask Bit 5
CANIDMR2_AM6:       equ    6                                         ; Acceptance Mask Bit 6
CANIDMR2_AM7:       equ    7                                         ; Acceptance Mask Bit 7
; bit position masks
mCANIDMR2_AM0:      equ    %00000001
mCANIDMR2_AM1:      equ    %00000010
mCANIDMR2_AM2:      equ    %00000100
mCANIDMR2_AM3:      equ    %00001000
mCANIDMR2_AM4:      equ    %00010000
mCANIDMR2_AM5:      equ    %00100000
mCANIDMR2_AM6:      equ    %01000000
mCANIDMR2_AM7:      equ    %10000000


;*** CANIDMR3 - MSCAN Identifier Mask Register 3; 0x00000157 ***
CANIDMR3:           equ    $00000157                                ;*** CANIDMR3 - MSCAN Identifier Mask Register 3; 0x00000157 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANIDMR3_AM0:       equ    0                                         ; Acceptance Mask Bit 0
CANIDMR3_AM1:       equ    1                                         ; Acceptance Mask Bit 1
CANIDMR3_AM2:       equ    2                                         ; Acceptance Mask Bit 2
CANIDMR3_AM3:       equ    3                                         ; Acceptance Mask Bit 3
CANIDMR3_AM4:       equ    4                                         ; Acceptance Mask Bit 4
CANIDMR3_AM5:       equ    5                                         ; Acceptance Mask Bit 5
CANIDMR3_AM6:       equ    6                                         ; Acceptance Mask Bit 6
CANIDMR3_AM7:       equ    7                                         ; Acceptance Mask Bit 7
; bit position masks
mCANIDMR3_AM0:      equ    %00000001
mCANIDMR3_AM1:      equ    %00000010
mCANIDMR3_AM2:      equ    %00000100
mCANIDMR3_AM3:      equ    %00001000
mCANIDMR3_AM4:      equ    %00010000
mCANIDMR3_AM5:      equ    %00100000
mCANIDMR3_AM6:      equ    %01000000
mCANIDMR3_AM7:      equ    %10000000


;*** CANIDAR4 - MSCAN Identifier Acceptance Register 4; 0x00000158 ***
CANIDAR4:           equ    $00000158                                ;*** CANIDAR4 - MSCAN Identifier Acceptance Register 4; 0x00000158 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANIDAR4_AC0:       equ    0                                         ; Acceptance Code Bit 0
CANIDAR4_AC1:       equ    1                                         ; Acceptance Code Bit 1
CANIDAR4_AC2:       equ    2                                         ; Acceptance Code Bit 2
CANIDAR4_AC3:       equ    3                                         ; Acceptance Code Bit 3
CANIDAR4_AC4:       equ    4                                         ; Acceptance Code Bit 4
CANIDAR4_AC5:       equ    5                                         ; Acceptance Code Bit 5
CANIDAR4_AC6:       equ    6                                         ; Acceptance Code Bit 6
CANIDAR4_AC7:       equ    7                                         ; Acceptance Code Bit 7
; bit position masks
mCANIDAR4_AC0:      equ    %00000001
mCANIDAR4_AC1:      equ    %00000010
mCANIDAR4_AC2:      equ    %00000100
mCANIDAR4_AC3:      equ    %00001000
mCANIDAR4_AC4:      equ    %00010000
mCANIDAR4_AC5:      equ    %00100000
mCANIDAR4_AC6:      equ    %01000000
mCANIDAR4_AC7:      equ    %10000000


;*** CANIDAR5 - MSCAN Identifier Acceptance Register 5; 0x00000159 ***
CANIDAR5:           equ    $00000159                                ;*** CANIDAR5 - MSCAN Identifier Acceptance Register 5; 0x00000159 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANIDAR5_AC0:       equ    0                                         ; Acceptance Code Bit 0
CANIDAR5_AC1:       equ    1                                         ; Acceptance Code Bit 1
CANIDAR5_AC2:       equ    2                                         ; Acceptance Code Bit 2
CANIDAR5_AC3:       equ    3                                         ; Acceptance Code Bit 3
CANIDAR5_AC4:       equ    4                                         ; Acceptance Code Bit 4
CANIDAR5_AC5:       equ    5                                         ; Acceptance Code Bit 5
CANIDAR5_AC6:       equ    6                                         ; Acceptance Code Bit 6
CANIDAR5_AC7:       equ    7                                         ; Acceptance Code Bit 7
; bit position masks
mCANIDAR5_AC0:      equ    %00000001
mCANIDAR5_AC1:      equ    %00000010
mCANIDAR5_AC2:      equ    %00000100
mCANIDAR5_AC3:      equ    %00001000
mCANIDAR5_AC4:      equ    %00010000
mCANIDAR5_AC5:      equ    %00100000
mCANIDAR5_AC6:      equ    %01000000
mCANIDAR5_AC7:      equ    %10000000


;*** CANIDAR6 - MSCAN Identifier Acceptance Register 6; 0x0000015A ***
CANIDAR6:           equ    $0000015A                                ;*** CANIDAR6 - MSCAN Identifier Acceptance Register 6; 0x0000015A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANIDAR6_AC0:       equ    0                                         ; Acceptance Code Bit 0
CANIDAR6_AC1:       equ    1                                         ; Acceptance Code Bit 1
CANIDAR6_AC2:       equ    2                                         ; Acceptance Code Bit 2
CANIDAR6_AC3:       equ    3                                         ; Acceptance Code Bit 3
CANIDAR6_AC4:       equ    4                                         ; Acceptance Code Bit 4
CANIDAR6_AC5:       equ    5                                         ; Acceptance Code Bit 5
CANIDAR6_AC6:       equ    6                                         ; Acceptance Code Bit 6
CANIDAR6_AC7:       equ    7                                         ; Acceptance Code Bit 7
; bit position masks
mCANIDAR6_AC0:      equ    %00000001
mCANIDAR6_AC1:      equ    %00000010
mCANIDAR6_AC2:      equ    %00000100
mCANIDAR6_AC3:      equ    %00001000
mCANIDAR6_AC4:      equ    %00010000
mCANIDAR6_AC5:      equ    %00100000
mCANIDAR6_AC6:      equ    %01000000
mCANIDAR6_AC7:      equ    %10000000


;*** CANIDAR7 - MSCAN Identifier Acceptance Register 7; 0x0000015B ***
CANIDAR7:           equ    $0000015B                                ;*** CANIDAR7 - MSCAN Identifier Acceptance Register 7; 0x0000015B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANIDAR7_AC0:       equ    0                                         ; Acceptance Code Bit 0
CANIDAR7_AC1:       equ    1                                         ; Acceptance Code Bit 1
CANIDAR7_AC2:       equ    2                                         ; Acceptance Code Bit 2
CANIDAR7_AC3:       equ    3                                         ; Acceptance Code Bit 3
CANIDAR7_AC4:       equ    4                                         ; Acceptance Code Bit 4
CANIDAR7_AC5:       equ    5                                         ; Acceptance Code Bit 5
CANIDAR7_AC6:       equ    6                                         ; Acceptance Code Bit 6
CANIDAR7_AC7:       equ    7                                         ; Acceptance Code Bit 7
; bit position masks
mCANIDAR7_AC0:      equ    %00000001
mCANIDAR7_AC1:      equ    %00000010
mCANIDAR7_AC2:      equ    %00000100
mCANIDAR7_AC3:      equ    %00001000
mCANIDAR7_AC4:      equ    %00010000
mCANIDAR7_AC5:      equ    %00100000
mCANIDAR7_AC6:      equ    %01000000
mCANIDAR7_AC7:      equ    %10000000


;*** CANIDMR4 - MSCAN Identifier Mask Register 4; 0x0000015C ***
CANIDMR4:           equ    $0000015C                                ;*** CANIDMR4 - MSCAN Identifier Mask Register 4; 0x0000015C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANIDMR4_AM0:       equ    0                                         ; Acceptance Mask Bit 0
CANIDMR4_AM1:       equ    1                                         ; Acceptance Mask Bit 1
CANIDMR4_AM2:       equ    2                                         ; Acceptance Mask Bit 2
CANIDMR4_AM3:       equ    3                                         ; Acceptance Mask Bit 3
CANIDMR4_AM4:       equ    4                                         ; Acceptance Mask Bit 4
CANIDMR4_AM5:       equ    5                                         ; Acceptance Mask Bit 5
CANIDMR4_AM6:       equ    6                                         ; Acceptance Mask Bit 6
CANIDMR4_AM7:       equ    7                                         ; Acceptance Mask Bit 7
; bit position masks
mCANIDMR4_AM0:      equ    %00000001
mCANIDMR4_AM1:      equ    %00000010
mCANIDMR4_AM2:      equ    %00000100
mCANIDMR4_AM3:      equ    %00001000
mCANIDMR4_AM4:      equ    %00010000
mCANIDMR4_AM5:      equ    %00100000
mCANIDMR4_AM6:      equ    %01000000
mCANIDMR4_AM7:      equ    %10000000


;*** CANIDMR5 - MSCAN Identifier Mask Register 5; 0x0000015D ***
CANIDMR5:           equ    $0000015D                                ;*** CANIDMR5 - MSCAN Identifier Mask Register 5; 0x0000015D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANIDMR5_AM0:       equ    0                                         ; Acceptance Mask Bit 0
CANIDMR5_AM1:       equ    1                                         ; Acceptance Mask Bit 1
CANIDMR5_AM2:       equ    2                                         ; Acceptance Mask Bit 2
CANIDMR5_AM3:       equ    3                                         ; Acceptance Mask Bit 3
CANIDMR5_AM4:       equ    4                                         ; Acceptance Mask Bit 4
CANIDMR5_AM5:       equ    5                                         ; Acceptance Mask Bit 5
CANIDMR5_AM6:       equ    6                                         ; Acceptance Mask Bit 6
CANIDMR5_AM7:       equ    7                                         ; Acceptance Mask Bit 7
; bit position masks
mCANIDMR5_AM0:      equ    %00000001
mCANIDMR5_AM1:      equ    %00000010
mCANIDMR5_AM2:      equ    %00000100
mCANIDMR5_AM3:      equ    %00001000
mCANIDMR5_AM4:      equ    %00010000
mCANIDMR5_AM5:      equ    %00100000
mCANIDMR5_AM6:      equ    %01000000
mCANIDMR5_AM7:      equ    %10000000


;*** CANIDMR6 - MSCAN Identifier Mask Register 6; 0x0000015E ***
CANIDMR6:           equ    $0000015E                                ;*** CANIDMR6 - MSCAN Identifier Mask Register 6; 0x0000015E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANIDMR6_AM0:       equ    0                                         ; Acceptance Mask Bit 0
CANIDMR6_AM1:       equ    1                                         ; Acceptance Mask Bit 1
CANIDMR6_AM2:       equ    2                                         ; Acceptance Mask Bit 2
CANIDMR6_AM3:       equ    3                                         ; Acceptance Mask Bit 3
CANIDMR6_AM4:       equ    4                                         ; Acceptance Mask Bit 4
CANIDMR6_AM5:       equ    5                                         ; Acceptance Mask Bit 5
CANIDMR6_AM6:       equ    6                                         ; Acceptance Mask Bit 6
CANIDMR6_AM7:       equ    7                                         ; Acceptance Mask Bit 7
; bit position masks
mCANIDMR6_AM0:      equ    %00000001
mCANIDMR6_AM1:      equ    %00000010
mCANIDMR6_AM2:      equ    %00000100
mCANIDMR6_AM3:      equ    %00001000
mCANIDMR6_AM4:      equ    %00010000
mCANIDMR6_AM5:      equ    %00100000
mCANIDMR6_AM6:      equ    %01000000
mCANIDMR6_AM7:      equ    %10000000


;*** CANIDMR7 - MSCAN Identifier Mask Register 7; 0x0000015F ***
CANIDMR7:           equ    $0000015F                                ;*** CANIDMR7 - MSCAN Identifier Mask Register 7; 0x0000015F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANIDMR7_AM0:       equ    0                                         ; Acceptance Mask Bit 0
CANIDMR7_AM1:       equ    1                                         ; Acceptance Mask Bit 1
CANIDMR7_AM2:       equ    2                                         ; Acceptance Mask Bit 2
CANIDMR7_AM3:       equ    3                                         ; Acceptance Mask Bit 3
CANIDMR7_AM4:       equ    4                                         ; Acceptance Mask Bit 4
CANIDMR7_AM5:       equ    5                                         ; Acceptance Mask Bit 5
CANIDMR7_AM6:       equ    6                                         ; Acceptance Mask Bit 6
CANIDMR7_AM7:       equ    7                                         ; Acceptance Mask Bit 7
; bit position masks
mCANIDMR7_AM0:      equ    %00000001
mCANIDMR7_AM1:      equ    %00000010
mCANIDMR7_AM2:      equ    %00000100
mCANIDMR7_AM3:      equ    %00001000
mCANIDMR7_AM4:      equ    %00010000
mCANIDMR7_AM5:      equ    %00100000
mCANIDMR7_AM6:      equ    %01000000
mCANIDMR7_AM7:      equ    %10000000


;*** CANRXIDR0 - MSCAN Receive Identifier Register 0; 0x00000160 ***
CANRXIDR0:          equ    $00000160                                ;*** CANRXIDR0 - MSCAN Receive Identifier Register 0; 0x00000160 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANRXIDR0_ID21:     equ    0                                         ; Extended format identifier Bit 21
CANRXIDR0_ID22:     equ    1                                         ; Extended format identifier Bit 22
CANRXIDR0_ID23:     equ    2                                         ; Extended format identifier Bit 23
CANRXIDR0_ID24:     equ    3                                         ; Extended format identifier Bit 24
CANRXIDR0_ID25:     equ    4                                         ; Extended format identifier Bit 25
CANRXIDR0_ID26:     equ    5                                         ; Extended format identifier Bit 26
CANRXIDR0_ID27:     equ    6                                         ; Extended format identifier Bit 27
CANRXIDR0_ID28:     equ    7                                         ; Extended format identifier Bit 28
; bit position masks
mCANRXIDR0_ID21:    equ    %00000001
mCANRXIDR0_ID22:    equ    %00000010
mCANRXIDR0_ID23:    equ    %00000100
mCANRXIDR0_ID24:    equ    %00001000
mCANRXIDR0_ID25:    equ    %00010000
mCANRXIDR0_ID26:    equ    %00100000
mCANRXIDR0_ID27:    equ    %01000000
mCANRXIDR0_ID28:    equ    %10000000


;*** CANRXIDR1 - MSCAN Receive Identifier Register 1; 0x00000161 ***
CANRXIDR1:          equ    $00000161                                ;*** CANRXIDR1 - MSCAN Receive Identifier Register 1; 0x00000161 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANRXIDR1_ID15:     equ    0                                         ; Extended format identifier Bit 15
CANRXIDR1_ID16:     equ    1                                         ; Extended format identifier Bit 16
CANRXIDR1_ID17:     equ    2                                         ; Extended format identifier Bit 17
CANRXIDR1_IDE:      equ    3                                         ; ID Extended
CANRXIDR1_SRR:      equ    4                                         ; Substitute Remote Request
CANRXIDR1_ID18:     equ    5                                         ; Extended format identifier Bit 18
CANRXIDR1_ID19:     equ    6                                         ; Extended format identifier Bit 19
CANRXIDR1_ID20:     equ    7                                         ; Extended format identifier Bit 20
; bit position masks
mCANRXIDR1_ID15:    equ    %00000001
mCANRXIDR1_ID16:    equ    %00000010
mCANRXIDR1_ID17:    equ    %00000100
mCANRXIDR1_IDE:     equ    %00001000
mCANRXIDR1_SRR:     equ    %00010000
mCANRXIDR1_ID18:    equ    %00100000
mCANRXIDR1_ID19:    equ    %01000000
mCANRXIDR1_ID20:    equ    %10000000


;*** CANRXIDR2 - MSCAN Receive Identifier Register 2; 0x00000162 ***
CANRXIDR2:          equ    $00000162                                ;*** CANRXIDR2 - MSCAN Receive Identifier Register 2; 0x00000162 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANRXIDR2_ID7:      equ    0                                         ; Extended format identifier Bit 7
CANRXIDR2_ID8:      equ    1                                         ; Extended format identifier Bit 8
CANRXIDR2_ID9:      equ    2                                         ; Extended format identifier Bit 9
CANRXIDR2_ID10:     equ    3                                         ; Extended format identifier Bit 10
CANRXIDR2_ID11:     equ    4                                         ; Extended format identifier Bit 11
CANRXIDR2_ID12:     equ    5                                         ; Extended format identifier Bit 12
CANRXIDR2_ID13:     equ    6                                         ; Extended format identifier Bit 13
CANRXIDR2_ID14:     equ    7                                         ; Extended format identifier Bit 14
; bit position masks
mCANRXIDR2_ID7:     equ    %00000001
mCANRXIDR2_ID8:     equ    %00000010
mCANRXIDR2_ID9:     equ    %00000100
mCANRXIDR2_ID10:    equ    %00001000
mCANRXIDR2_ID11:    equ    %00010000
mCANRXIDR2_ID12:    equ    %00100000
mCANRXIDR2_ID13:    equ    %01000000
mCANRXIDR2_ID14:    equ    %10000000


;*** CANRXIDR3 - MSCAN Receive Identifier Register 3; 0x00000163 ***
CANRXIDR3:          equ    $00000163                                ;*** CANRXIDR3 - MSCAN Receive Identifier Register 3; 0x00000163 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANRXIDR3_RTR:      equ    0                                         ; Remote Transmission Request
CANRXIDR3_ID0:      equ    1                                         ; Extended format identifier Bit 0
CANRXIDR3_ID1:      equ    2                                         ; Extended format identifier Bit 1
CANRXIDR3_ID2:      equ    3                                         ; Extended format identifier Bit 2
CANRXIDR3_ID3:      equ    4                                         ; Extended format identifier Bit 3
CANRXIDR3_ID4:      equ    5                                         ; Extended format identifier Bit 4
CANRXIDR3_ID5:      equ    6                                         ; Extended format identifier Bit 5
CANRXIDR3_ID6:      equ    7                                         ; Extended format identifier Bit 6
; bit position masks
mCANRXIDR3_RTR:     equ    %00000001
mCANRXIDR3_ID0:     equ    %00000010
mCANRXIDR3_ID1:     equ    %00000100
mCANRXIDR3_ID2:     equ    %00001000
mCANRXIDR3_ID3:     equ    %00010000
mCANRXIDR3_ID4:     equ    %00100000
mCANRXIDR3_ID5:     equ    %01000000
mCANRXIDR3_ID6:     equ    %10000000


;*** CANRXDSR0 - MSCAN Receive Data Segment Register 0; 0x00000164 ***
CANRXDSR0:          equ    $00000164                                ;*** CANRXDSR0 - MSCAN Receive Data Segment Register 0; 0x00000164 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANRXDSR0_DB0:      equ    0                                         ; Data Bit 0
CANRXDSR0_DB1:      equ    1                                         ; Data Bit 1
CANRXDSR0_DB2:      equ    2                                         ; Data Bit 2
CANRXDSR0_DB3:      equ    3                                         ; Data Bit 3
CANRXDSR0_DB4:      equ    4                                         ; Data Bit 4
CANRXDSR0_DB5:      equ    5                                         ; Data Bit 5
CANRXDSR0_DB6:      equ    6                                         ; Data Bit 6
CANRXDSR0_DB7:      equ    7                                         ; Data Bit 7
; bit position masks
mCANRXDSR0_DB0:     equ    %00000001
mCANRXDSR0_DB1:     equ    %00000010
mCANRXDSR0_DB2:     equ    %00000100
mCANRXDSR0_DB3:     equ    %00001000
mCANRXDSR0_DB4:     equ    %00010000
mCANRXDSR0_DB5:     equ    %00100000
mCANRXDSR0_DB6:     equ    %01000000
mCANRXDSR0_DB7:     equ    %10000000


;*** CANRXDSR1 - MSCAN Receive Data Segment Register 1; 0x00000165 ***
CANRXDSR1:          equ    $00000165                                ;*** CANRXDSR1 - MSCAN Receive Data Segment Register 1; 0x00000165 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANRXDSR1_DB0:      equ    0                                         ; Data Bit 0
CANRXDSR1_DB1:      equ    1                                         ; Data Bit 1
CANRXDSR1_DB2:      equ    2                                         ; Data Bit 2
CANRXDSR1_DB3:      equ    3                                         ; Data Bit 3
CANRXDSR1_DB4:      equ    4                                         ; Data Bit 4
CANRXDSR1_DB5:      equ    5                                         ; Data Bit 5
CANRXDSR1_DB6:      equ    6                                         ; Data Bit 6
CANRXDSR1_DB7:      equ    7                                         ; Data Bit 7
; bit position masks
mCANRXDSR1_DB0:     equ    %00000001
mCANRXDSR1_DB1:     equ    %00000010
mCANRXDSR1_DB2:     equ    %00000100
mCANRXDSR1_DB3:     equ    %00001000
mCANRXDSR1_DB4:     equ    %00010000
mCANRXDSR1_DB5:     equ    %00100000
mCANRXDSR1_DB6:     equ    %01000000
mCANRXDSR1_DB7:     equ    %10000000


;*** CANRXDSR2 - MSCAN Receive Data Segment Register 2; 0x00000166 ***
CANRXDSR2:          equ    $00000166                                ;*** CANRXDSR2 - MSCAN Receive Data Segment Register 2; 0x00000166 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANRXDSR2_DB0:      equ    0                                         ; Data Bit 0
CANRXDSR2_DB1:      equ    1                                         ; Data Bit 1
CANRXDSR2_DB2:      equ    2                                         ; Data Bit 2
CANRXDSR2_DB3:      equ    3                                         ; Data Bit 3
CANRXDSR2_DB4:      equ    4                                         ; Data Bit 4
CANRXDSR2_DB5:      equ    5                                         ; Data Bit 5
CANRXDSR2_DB6:      equ    6                                         ; Data Bit 6
CANRXDSR2_DB7:      equ    7                                         ; Data Bit 7
; bit position masks
mCANRXDSR2_DB0:     equ    %00000001
mCANRXDSR2_DB1:     equ    %00000010
mCANRXDSR2_DB2:     equ    %00000100
mCANRXDSR2_DB3:     equ    %00001000
mCANRXDSR2_DB4:     equ    %00010000
mCANRXDSR2_DB5:     equ    %00100000
mCANRXDSR2_DB6:     equ    %01000000
mCANRXDSR2_DB7:     equ    %10000000


;*** CANRXDSR3 - MSCAN Receive Data Segment Register 3; 0x00000167 ***
CANRXDSR3:          equ    $00000167                                ;*** CANRXDSR3 - MSCAN Receive Data Segment Register 3; 0x00000167 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANRXDSR3_DB0:      equ    0                                         ; Data Bit 0
CANRXDSR3_DB1:      equ    1                                         ; Data Bit 1
CANRXDSR3_DB2:      equ    2                                         ; Data Bit 2
CANRXDSR3_DB3:      equ    3                                         ; Data Bit 3
CANRXDSR3_DB4:      equ    4                                         ; Data Bit 4
CANRXDSR3_DB5:      equ    5                                         ; Data Bit 5
CANRXDSR3_DB6:      equ    6                                         ; Data Bit 6
CANRXDSR3_DB7:      equ    7                                         ; Data Bit 7
; bit position masks
mCANRXDSR3_DB0:     equ    %00000001
mCANRXDSR3_DB1:     equ    %00000010
mCANRXDSR3_DB2:     equ    %00000100
mCANRXDSR3_DB3:     equ    %00001000
mCANRXDSR3_DB4:     equ    %00010000
mCANRXDSR3_DB5:     equ    %00100000
mCANRXDSR3_DB6:     equ    %01000000
mCANRXDSR3_DB7:     equ    %10000000


;*** CANRXDSR4 - MSCAN Receive Data Segment Register 4; 0x00000168 ***
CANRXDSR4:          equ    $00000168                                ;*** CANRXDSR4 - MSCAN Receive Data Segment Register 4; 0x00000168 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANRXDSR4_DB0:      equ    0                                         ; Data Bit 0
CANRXDSR4_DB1:      equ    1                                         ; Data Bit 1
CANRXDSR4_DB2:      equ    2                                         ; Data Bit 2
CANRXDSR4_DB3:      equ    3                                         ; Data Bit 3
CANRXDSR4_DB4:      equ    4                                         ; Data Bit 4
CANRXDSR4_DB5:      equ    5                                         ; Data Bit 5
CANRXDSR4_DB6:      equ    6                                         ; Data Bit 6
CANRXDSR4_DB7:      equ    7                                         ; Data Bit 7
; bit position masks
mCANRXDSR4_DB0:     equ    %00000001
mCANRXDSR4_DB1:     equ    %00000010
mCANRXDSR4_DB2:     equ    %00000100
mCANRXDSR4_DB3:     equ    %00001000
mCANRXDSR4_DB4:     equ    %00010000
mCANRXDSR4_DB5:     equ    %00100000
mCANRXDSR4_DB6:     equ    %01000000
mCANRXDSR4_DB7:     equ    %10000000


;*** CANRXDSR5 - MSCAN Receive Data Segment Register 5; 0x00000169 ***
CANRXDSR5:          equ    $00000169                                ;*** CANRXDSR5 - MSCAN Receive Data Segment Register 5; 0x00000169 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANRXDSR5_DB0:      equ    0                                         ; Data Bit 0
CANRXDSR5_DB1:      equ    1                                         ; Data Bit 1
CANRXDSR5_DB2:      equ    2                                         ; Data Bit 2
CANRXDSR5_DB3:      equ    3                                         ; Data Bit 3
CANRXDSR5_DB4:      equ    4                                         ; Data Bit 4
CANRXDSR5_DB5:      equ    5                                         ; Data Bit 5
CANRXDSR5_DB6:      equ    6                                         ; Data Bit 6
CANRXDSR5_DB7:      equ    7                                         ; Data Bit 7
; bit position masks
mCANRXDSR5_DB0:     equ    %00000001
mCANRXDSR5_DB1:     equ    %00000010
mCANRXDSR5_DB2:     equ    %00000100
mCANRXDSR5_DB3:     equ    %00001000
mCANRXDSR5_DB4:     equ    %00010000
mCANRXDSR5_DB5:     equ    %00100000
mCANRXDSR5_DB6:     equ    %01000000
mCANRXDSR5_DB7:     equ    %10000000


;*** CANRXDSR6 - MSCAN Receive Data Segment Register 6; 0x0000016A ***
CANRXDSR6:          equ    $0000016A                                ;*** CANRXDSR6 - MSCAN Receive Data Segment Register 6; 0x0000016A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANRXDSR6_DB0:      equ    0                                         ; Data Bit 0
CANRXDSR6_DB1:      equ    1                                         ; Data Bit 1
CANRXDSR6_DB2:      equ    2                                         ; Data Bit 2
CANRXDSR6_DB3:      equ    3                                         ; Data Bit 3
CANRXDSR6_DB4:      equ    4                                         ; Data Bit 4
CANRXDSR6_DB5:      equ    5                                         ; Data Bit 5
CANRXDSR6_DB6:      equ    6                                         ; Data Bit 6
CANRXDSR6_DB7:      equ    7                                         ; Data Bit 7
; bit position masks
mCANRXDSR6_DB0:     equ    %00000001
mCANRXDSR6_DB1:     equ    %00000010
mCANRXDSR6_DB2:     equ    %00000100
mCANRXDSR6_DB3:     equ    %00001000
mCANRXDSR6_DB4:     equ    %00010000
mCANRXDSR6_DB5:     equ    %00100000
mCANRXDSR6_DB6:     equ    %01000000
mCANRXDSR6_DB7:     equ    %10000000


;*** CANRXDSR7 - MSCAN Receive Data Segment Register 7; 0x0000016B ***
CANRXDSR7:          equ    $0000016B                                ;*** CANRXDSR7 - MSCAN Receive Data Segment Register 7; 0x0000016B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANRXDSR7_DB0:      equ    0                                         ; Data Bit 0
CANRXDSR7_DB1:      equ    1                                         ; Data Bit 1
CANRXDSR7_DB2:      equ    2                                         ; Data Bit 2
CANRXDSR7_DB3:      equ    3                                         ; Data Bit 3
CANRXDSR7_DB4:      equ    4                                         ; Data Bit 4
CANRXDSR7_DB5:      equ    5                                         ; Data Bit 5
CANRXDSR7_DB6:      equ    6                                         ; Data Bit 6
CANRXDSR7_DB7:      equ    7                                         ; Data Bit 7
; bit position masks
mCANRXDSR7_DB0:     equ    %00000001
mCANRXDSR7_DB1:     equ    %00000010
mCANRXDSR7_DB2:     equ    %00000100
mCANRXDSR7_DB3:     equ    %00001000
mCANRXDSR7_DB4:     equ    %00010000
mCANRXDSR7_DB5:     equ    %00100000
mCANRXDSR7_DB6:     equ    %01000000
mCANRXDSR7_DB7:     equ    %10000000


;*** CANRXDLR - MSCAN Receive Data Length Register; 0x0000016C ***
CANRXDLR:           equ    $0000016C                                ;*** CANRXDLR - MSCAN Receive Data Length Register; 0x0000016C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANRXDLR_DLC0:      equ    0                                         ; Data Length Code Bit 0
CANRXDLR_DLC1:      equ    1                                         ; Data Length Code Bit 1
CANRXDLR_DLC2:      equ    2                                         ; Data Length Code Bit 2
CANRXDLR_DLC3:      equ    3                                         ; Data Length Code Bit 3
; bit position masks
mCANRXDLR_DLC0:     equ    %00000001
mCANRXDLR_DLC1:     equ    %00000010
mCANRXDLR_DLC2:     equ    %00000100
mCANRXDLR_DLC3:     equ    %00001000


;*** CANRXTSR - MSCAN Receive Time Stamp Register; 0x0000016E ***
CANRXTSR:           equ    $0000016E                                ;*** CANRXTSR - MSCAN Receive Time Stamp Register; 0x0000016E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANRXTSR_TSR0:      equ    0                                         ; Time Stamp Bit 0
CANRXTSR_TSR1:      equ    1                                         ; Time Stamp Bit 1
CANRXTSR_TSR2:      equ    2                                         ; Time Stamp Bit 2
CANRXTSR_TSR3:      equ    3                                         ; Time Stamp Bit 3
CANRXTSR_TSR4:      equ    4                                         ; Time Stamp Bit 4
CANRXTSR_TSR5:      equ    5                                         ; Time Stamp Bit 5
CANRXTSR_TSR6:      equ    6                                         ; Time Stamp Bit 6
CANRXTSR_TSR7:      equ    7                                         ; Time Stamp Bit 7
CANRXTSR_TSR8:      equ    8                                         ; Time Stamp Bit 8
CANRXTSR_TSR9:      equ    9                                         ; Time Stamp Bit 9
CANRXTSR_TSR10:     equ    10                                        ; Time Stamp Bit 10
CANRXTSR_TSR11:     equ    11                                        ; Time Stamp Bit 11
CANRXTSR_TSR12:     equ    12                                        ; Time Stamp Bit 12
CANRXTSR_TSR13:     equ    13                                        ; Time Stamp Bit 13
CANRXTSR_TSR14:     equ    14                                        ; Time Stamp Bit 14
CANRXTSR_TSR15:     equ    15                                        ; Time Stamp Bit 15
; bit position masks
mCANRXTSR_TSR0:     equ    %00000001
mCANRXTSR_TSR1:     equ    %00000010
mCANRXTSR_TSR2:     equ    %00000100
mCANRXTSR_TSR3:     equ    %00001000
mCANRXTSR_TSR4:     equ    %00010000
mCANRXTSR_TSR5:     equ    %00100000
mCANRXTSR_TSR6:     equ    %01000000
mCANRXTSR_TSR7:     equ    %10000000
mCANRXTSR_TSR8:     equ    %100000000
mCANRXTSR_TSR9:     equ    %1000000000
mCANRXTSR_TSR10:    equ    %10000000000
mCANRXTSR_TSR11:    equ    %100000000000
mCANRXTSR_TSR12:    equ    %1000000000000
mCANRXTSR_TSR13:    equ    %10000000000000
mCANRXTSR_TSR14:    equ    %100000000000000
mCANRXTSR_TSR15:    equ    %1000000000000000


;*** CANRXTSRH - MSCAN Receive Time Stamp Register High; 0x0000016E ***
CANRXTSRH:          equ    $0000016E                                ;*** CANRXTSRH - MSCAN Receive Time Stamp Register High; 0x0000016E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANRXTSRH_TSR8:     equ    0                                         ; Time Stamp Bit 8
CANRXTSRH_TSR9:     equ    1                                         ; Time Stamp Bit 9
CANRXTSRH_TSR10:    equ    2                                         ; Time Stamp Bit 10
CANRXTSRH_TSR11:    equ    3                                         ; Time Stamp Bit 11
CANRXTSRH_TSR12:    equ    4                                         ; Time Stamp Bit 12
CANRXTSRH_TSR13:    equ    5                                         ; Time Stamp Bit 13
CANRXTSRH_TSR14:    equ    6                                         ; Time Stamp Bit 14
CANRXTSRH_TSR15:    equ    7                                         ; Time Stamp Bit 15
; bit position masks
mCANRXTSRH_TSR8:    equ    %00000001
mCANRXTSRH_TSR9:    equ    %00000010
mCANRXTSRH_TSR10:   equ    %00000100
mCANRXTSRH_TSR11:   equ    %00001000
mCANRXTSRH_TSR12:   equ    %00010000
mCANRXTSRH_TSR13:   equ    %00100000
mCANRXTSRH_TSR14:   equ    %01000000
mCANRXTSRH_TSR15:   equ    %10000000


;*** CANRXTSRL - MSCAN Receive Time Stamp Register Low; 0x0000016F ***
CANRXTSRL:          equ    $0000016F                                ;*** CANRXTSRL - MSCAN Receive Time Stamp Register Low; 0x0000016F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANRXTSRL_TSR0:     equ    0                                         ; Time Stamp Bit 0
CANRXTSRL_TSR1:     equ    1                                         ; Time Stamp Bit 1
CANRXTSRL_TSR2:     equ    2                                         ; Time Stamp Bit 2
CANRXTSRL_TSR3:     equ    3                                         ; Time Stamp Bit 3
CANRXTSRL_TSR4:     equ    4                                         ; Time Stamp Bit 4
CANRXTSRL_TSR5:     equ    5                                         ; Time Stamp Bit 5
CANRXTSRL_TSR6:     equ    6                                         ; Time Stamp Bit 6
CANRXTSRL_TSR7:     equ    7                                         ; Time Stamp Bit 7
; bit position masks
mCANRXTSRL_TSR0:    equ    %00000001
mCANRXTSRL_TSR1:    equ    %00000010
mCANRXTSRL_TSR2:    equ    %00000100
mCANRXTSRL_TSR3:    equ    %00001000
mCANRXTSRL_TSR4:    equ    %00010000
mCANRXTSRL_TSR5:    equ    %00100000
mCANRXTSRL_TSR6:    equ    %01000000
mCANRXTSRL_TSR7:    equ    %10000000


;*** CANTXIDR0 - MSCAN Transmit Identifier Register 0; 0x00000170 ***
CANTXIDR0:          equ    $00000170                                ;*** CANTXIDR0 - MSCAN Transmit Identifier Register 0; 0x00000170 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANTXIDR0_ID21:     equ    0                                         ; Extended format identifier Bit 21
CANTXIDR0_ID22:     equ    1                                         ; Extended format identifier Bit 22
CANTXIDR0_ID23:     equ    2                                         ; Extended format identifier Bit 23
CANTXIDR0_ID24:     equ    3                                         ; Extended format identifier Bit 24
CANTXIDR0_ID25:     equ    4                                         ; Extended format identifier Bit 25
CANTXIDR0_ID26:     equ    5                                         ; Extended format identifier Bit 26
CANTXIDR0_ID27:     equ    6                                         ; Extended format identifier Bit 27
CANTXIDR0_ID28:     equ    7                                         ; Extended format identifier Bit 28
; bit position masks
mCANTXIDR0_ID21:    equ    %00000001
mCANTXIDR0_ID22:    equ    %00000010
mCANTXIDR0_ID23:    equ    %00000100
mCANTXIDR0_ID24:    equ    %00001000
mCANTXIDR0_ID25:    equ    %00010000
mCANTXIDR0_ID26:    equ    %00100000
mCANTXIDR0_ID27:    equ    %01000000
mCANTXIDR0_ID28:    equ    %10000000


;*** CANTXIDR1 - MSCAN Transmit Identifier Register 1; 0x00000171 ***
CANTXIDR1:          equ    $00000171                                ;*** CANTXIDR1 - MSCAN Transmit Identifier Register 1; 0x00000171 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANTXIDR1_ID15:     equ    0                                         ; Extended format identifier Bit 15
CANTXIDR1_ID16:     equ    1                                         ; Extended format identifier Bit 16
CANTXIDR1_ID17:     equ    2                                         ; Extended format identifier Bit 17
CANTXIDR1_IDE:      equ    3                                         ; ID Extended
CANTXIDR1_SRR:      equ    4                                         ; Substitute Remote Request
CANTXIDR1_ID18:     equ    5                                         ; Extended format identifier Bit 18
CANTXIDR1_ID19:     equ    6                                         ; Extended format identifier Bit 19
CANTXIDR1_ID20:     equ    7                                         ; Extended format identifier Bit 20
; bit position masks
mCANTXIDR1_ID15:    equ    %00000001
mCANTXIDR1_ID16:    equ    %00000010
mCANTXIDR1_ID17:    equ    %00000100
mCANTXIDR1_IDE:     equ    %00001000
mCANTXIDR1_SRR:     equ    %00010000
mCANTXIDR1_ID18:    equ    %00100000
mCANTXIDR1_ID19:    equ    %01000000
mCANTXIDR1_ID20:    equ    %10000000


;*** CANTXIDR2 - MSCAN Transmit Identifier Register 2; 0x00000172 ***
CANTXIDR2:          equ    $00000172                                ;*** CANTXIDR2 - MSCAN Transmit Identifier Register 2; 0x00000172 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANTXIDR2_ID7:      equ    0                                         ; Extended format identifier Bit 7
CANTXIDR2_ID8:      equ    1                                         ; Extended format identifier Bit 8
CANTXIDR2_ID9:      equ    2                                         ; Extended format identifier Bit 9
CANTXIDR2_ID10:     equ    3                                         ; Extended format identifier Bit 10
CANTXIDR2_ID11:     equ    4                                         ; Extended format identifier Bit 11
CANTXIDR2_ID12:     equ    5                                         ; Extended format identifier Bit 12
CANTXIDR2_ID13:     equ    6                                         ; Extended format identifier Bit 13
CANTXIDR2_ID14:     equ    7                                         ; Extended format identifier Bit 14
; bit position masks
mCANTXIDR2_ID7:     equ    %00000001
mCANTXIDR2_ID8:     equ    %00000010
mCANTXIDR2_ID9:     equ    %00000100
mCANTXIDR2_ID10:    equ    %00001000
mCANTXIDR2_ID11:    equ    %00010000
mCANTXIDR2_ID12:    equ    %00100000
mCANTXIDR2_ID13:    equ    %01000000
mCANTXIDR2_ID14:    equ    %10000000


;*** CANTXIDR3 - MSCAN Transmit Identifier Register 3; 0x00000173 ***
CANTXIDR3:          equ    $00000173                                ;*** CANTXIDR3 - MSCAN Transmit Identifier Register 3; 0x00000173 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANTXIDR3_RTR:      equ    0                                         ; Remote Transmission Request
CANTXIDR3_ID0:      equ    1                                         ; Extended format identifier Bit 0
CANTXIDR3_ID1:      equ    2                                         ; Extended format identifier Bit 1
CANTXIDR3_ID2:      equ    3                                         ; Extended format identifier Bit 2
CANTXIDR3_ID3:      equ    4                                         ; Extended format identifier Bit 3
CANTXIDR3_ID4:      equ    5                                         ; Extended format identifier Bit 4
CANTXIDR3_ID5:      equ    6                                         ; Extended format identifier Bit 5
CANTXIDR3_ID6:      equ    7                                         ; Extended format identifier Bit 6
; bit position masks
mCANTXIDR3_RTR:     equ    %00000001
mCANTXIDR3_ID0:     equ    %00000010
mCANTXIDR3_ID1:     equ    %00000100
mCANTXIDR3_ID2:     equ    %00001000
mCANTXIDR3_ID3:     equ    %00010000
mCANTXIDR3_ID4:     equ    %00100000
mCANTXIDR3_ID5:     equ    %01000000
mCANTXIDR3_ID6:     equ    %10000000


;*** CANTXDSR0 - MSCAN Transmit Data Segment Register 0; 0x00000174 ***
CANTXDSR0:          equ    $00000174                                ;*** CANTXDSR0 - MSCAN Transmit Data Segment Register 0; 0x00000174 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANTXDSR0_DB0:      equ    0                                         ; Data Bit 0
CANTXDSR0_DB1:      equ    1                                         ; Data Bit 1
CANTXDSR0_DB2:      equ    2                                         ; Data Bit 2
CANTXDSR0_DB3:      equ    3                                         ; Data Bit 3
CANTXDSR0_DB4:      equ    4                                         ; Data Bit 4
CANTXDSR0_DB5:      equ    5                                         ; Data Bit 5
CANTXDSR0_DB6:      equ    6                                         ; Data Bit 6
CANTXDSR0_DB7:      equ    7                                         ; Data Bit 7
; bit position masks
mCANTXDSR0_DB0:     equ    %00000001
mCANTXDSR0_DB1:     equ    %00000010
mCANTXDSR0_DB2:     equ    %00000100
mCANTXDSR0_DB3:     equ    %00001000
mCANTXDSR0_DB4:     equ    %00010000
mCANTXDSR0_DB5:     equ    %00100000
mCANTXDSR0_DB6:     equ    %01000000
mCANTXDSR0_DB7:     equ    %10000000


;*** CANTXDSR1 - MSCAN Transmit Data Segment Register 1; 0x00000175 ***
CANTXDSR1:          equ    $00000175                                ;*** CANTXDSR1 - MSCAN Transmit Data Segment Register 1; 0x00000175 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANTXDSR1_DB0:      equ    0                                         ; Data Bit 0
CANTXDSR1_DB1:      equ    1                                         ; Data Bit 1
CANTXDSR1_DB2:      equ    2                                         ; Data Bit 2
CANTXDSR1_DB3:      equ    3                                         ; Data Bit 3
CANTXDSR1_DB4:      equ    4                                         ; Data Bit 4
CANTXDSR1_DB5:      equ    5                                         ; Data Bit 5
CANTXDSR1_DB6:      equ    6                                         ; Data Bit 6
CANTXDSR1_DB7:      equ    7                                         ; Data Bit 7
; bit position masks
mCANTXDSR1_DB0:     equ    %00000001
mCANTXDSR1_DB1:     equ    %00000010
mCANTXDSR1_DB2:     equ    %00000100
mCANTXDSR1_DB3:     equ    %00001000
mCANTXDSR1_DB4:     equ    %00010000
mCANTXDSR1_DB5:     equ    %00100000
mCANTXDSR1_DB6:     equ    %01000000
mCANTXDSR1_DB7:     equ    %10000000


;*** CANTXDSR2 - MSCAN Transmit Data Segment Register 2; 0x00000176 ***
CANTXDSR2:          equ    $00000176                                ;*** CANTXDSR2 - MSCAN Transmit Data Segment Register 2; 0x00000176 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANTXDSR2_DB0:      equ    0                                         ; Data Bit 0
CANTXDSR2_DB1:      equ    1                                         ; Data Bit 1
CANTXDSR2_DB2:      equ    2                                         ; Data Bit 2
CANTXDSR2_DB3:      equ    3                                         ; Data Bit 3
CANTXDSR2_DB4:      equ    4                                         ; Data Bit 4
CANTXDSR2_DB5:      equ    5                                         ; Data Bit 5
CANTXDSR2_DB6:      equ    6                                         ; Data Bit 6
CANTXDSR2_DB7:      equ    7                                         ; Data Bit 7
; bit position masks
mCANTXDSR2_DB0:     equ    %00000001
mCANTXDSR2_DB1:     equ    %00000010
mCANTXDSR2_DB2:     equ    %00000100
mCANTXDSR2_DB3:     equ    %00001000
mCANTXDSR2_DB4:     equ    %00010000
mCANTXDSR2_DB5:     equ    %00100000
mCANTXDSR2_DB6:     equ    %01000000
mCANTXDSR2_DB7:     equ    %10000000


;*** CANTXDSR3 - MSCAN Transmit Data Segment Register 3; 0x00000177 ***
CANTXDSR3:          equ    $00000177                                ;*** CANTXDSR3 - MSCAN Transmit Data Segment Register 3; 0x00000177 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANTXDSR3_DB0:      equ    0                                         ; Data Bit 0
CANTXDSR3_DB1:      equ    1                                         ; Data Bit 1
CANTXDSR3_DB2:      equ    2                                         ; Data Bit 2
CANTXDSR3_DB3:      equ    3                                         ; Data Bit 3
CANTXDSR3_DB4:      equ    4                                         ; Data Bit 4
CANTXDSR3_DB5:      equ    5                                         ; Data Bit 5
CANTXDSR3_DB6:      equ    6                                         ; Data Bit 6
CANTXDSR3_DB7:      equ    7                                         ; Data Bit 7
; bit position masks
mCANTXDSR3_DB0:     equ    %00000001
mCANTXDSR3_DB1:     equ    %00000010
mCANTXDSR3_DB2:     equ    %00000100
mCANTXDSR3_DB3:     equ    %00001000
mCANTXDSR3_DB4:     equ    %00010000
mCANTXDSR3_DB5:     equ    %00100000
mCANTXDSR3_DB6:     equ    %01000000
mCANTXDSR3_DB7:     equ    %10000000


;*** CANTXDSR4 - MSCAN Transmit Data Segment Register 4; 0x00000178 ***
CANTXDSR4:          equ    $00000178                                ;*** CANTXDSR4 - MSCAN Transmit Data Segment Register 4; 0x00000178 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANTXDSR4_DB0:      equ    0                                         ; Data Bit 0
CANTXDSR4_DB1:      equ    1                                         ; Data Bit 1
CANTXDSR4_DB2:      equ    2                                         ; Data Bit 2
CANTXDSR4_DB3:      equ    3                                         ; Data Bit 3
CANTXDSR4_DB4:      equ    4                                         ; Data Bit 4
CANTXDSR4_DB5:      equ    5                                         ; Data Bit 5
CANTXDSR4_DB6:      equ    6                                         ; Data Bit 6
CANTXDSR4_DB7:      equ    7                                         ; Data Bit 7
; bit position masks
mCANTXDSR4_DB0:     equ    %00000001
mCANTXDSR4_DB1:     equ    %00000010
mCANTXDSR4_DB2:     equ    %00000100
mCANTXDSR4_DB3:     equ    %00001000
mCANTXDSR4_DB4:     equ    %00010000
mCANTXDSR4_DB5:     equ    %00100000
mCANTXDSR4_DB6:     equ    %01000000
mCANTXDSR4_DB7:     equ    %10000000


;*** CANTXDSR5 - MSCAN Transmit Data Segment Register 5; 0x00000179 ***
CANTXDSR5:          equ    $00000179                                ;*** CANTXDSR5 - MSCAN Transmit Data Segment Register 5; 0x00000179 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANTXDSR5_DB0:      equ    0                                         ; Data Bit 0
CANTXDSR5_DB1:      equ    1                                         ; Data Bit 1
CANTXDSR5_DB2:      equ    2                                         ; Data Bit 2
CANTXDSR5_DB3:      equ    3                                         ; Data Bit 3
CANTXDSR5_DB4:      equ    4                                         ; Data Bit 4
CANTXDSR5_DB5:      equ    5                                         ; Data Bit 5
CANTXDSR5_DB6:      equ    6                                         ; Data Bit 6
CANTXDSR5_DB7:      equ    7                                         ; Data Bit 7
; bit position masks
mCANTXDSR5_DB0:     equ    %00000001
mCANTXDSR5_DB1:     equ    %00000010
mCANTXDSR5_DB2:     equ    %00000100
mCANTXDSR5_DB3:     equ    %00001000
mCANTXDSR5_DB4:     equ    %00010000
mCANTXDSR5_DB5:     equ    %00100000
mCANTXDSR5_DB6:     equ    %01000000
mCANTXDSR5_DB7:     equ    %10000000


;*** CANTXDSR6 - MSCAN Transmit Data Segment Register 6; 0x0000017A ***
CANTXDSR6:          equ    $0000017A                                ;*** CANTXDSR6 - MSCAN Transmit Data Segment Register 6; 0x0000017A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANTXDSR6_DB0:      equ    0                                         ; Data Bit 0
CANTXDSR6_DB1:      equ    1                                         ; Data Bit 1
CANTXDSR6_DB2:      equ    2                                         ; Data Bit 2
CANTXDSR6_DB3:      equ    3                                         ; Data Bit 3
CANTXDSR6_DB4:      equ    4                                         ; Data Bit 4
CANTXDSR6_DB5:      equ    5                                         ; Data Bit 5
CANTXDSR6_DB6:      equ    6                                         ; Data Bit 6
CANTXDSR6_DB7:      equ    7                                         ; Data Bit 7
; bit position masks
mCANTXDSR6_DB0:     equ    %00000001
mCANTXDSR6_DB1:     equ    %00000010
mCANTXDSR6_DB2:     equ    %00000100
mCANTXDSR6_DB3:     equ    %00001000
mCANTXDSR6_DB4:     equ    %00010000
mCANTXDSR6_DB5:     equ    %00100000
mCANTXDSR6_DB6:     equ    %01000000
mCANTXDSR6_DB7:     equ    %10000000


;*** CANTXDSR7 - MSCAN Transmit Data Segment Register 7; 0x0000017B ***
CANTXDSR7:          equ    $0000017B                                ;*** CANTXDSR7 - MSCAN Transmit Data Segment Register 7; 0x0000017B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANTXDSR7_DB0:      equ    0                                         ; Data Bit 0
CANTXDSR7_DB1:      equ    1                                         ; Data Bit 1
CANTXDSR7_DB2:      equ    2                                         ; Data Bit 2
CANTXDSR7_DB3:      equ    3                                         ; Data Bit 3
CANTXDSR7_DB4:      equ    4                                         ; Data Bit 4
CANTXDSR7_DB5:      equ    5                                         ; Data Bit 5
CANTXDSR7_DB6:      equ    6                                         ; Data Bit 6
CANTXDSR7_DB7:      equ    7                                         ; Data Bit 7
; bit position masks
mCANTXDSR7_DB0:     equ    %00000001
mCANTXDSR7_DB1:     equ    %00000010
mCANTXDSR7_DB2:     equ    %00000100
mCANTXDSR7_DB3:     equ    %00001000
mCANTXDSR7_DB4:     equ    %00010000
mCANTXDSR7_DB5:     equ    %00100000
mCANTXDSR7_DB6:     equ    %01000000
mCANTXDSR7_DB7:     equ    %10000000


;*** CANTXDLR - MSCAN Transmit Data Length Register; 0x0000017C ***
CANTXDLR:           equ    $0000017C                                ;*** CANTXDLR - MSCAN Transmit Data Length Register; 0x0000017C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANTXDLR_DLC0:      equ    0                                         ; Data Length Code Bit 0
CANTXDLR_DLC1:      equ    1                                         ; Data Length Code Bit 1
CANTXDLR_DLC2:      equ    2                                         ; Data Length Code Bit 2
CANTXDLR_DLC3:      equ    3                                         ; Data Length Code Bit 3
; bit position masks
mCANTXDLR_DLC0:     equ    %00000001
mCANTXDLR_DLC1:     equ    %00000010
mCANTXDLR_DLC2:     equ    %00000100
mCANTXDLR_DLC3:     equ    %00001000


;*** CANTXTBPR - MSCAN Transmit Buffer Priority; 0x0000017D ***
CANTXTBPR:          equ    $0000017D                                ;*** CANTXTBPR - MSCAN Transmit Buffer Priority; 0x0000017D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANTXTBPR_PRIO0:    equ    0                                         ; Transmit Buffer Priority Bit 0
CANTXTBPR_PRIO1:    equ    1                                         ; Transmit Buffer Priority Bit 1
CANTXTBPR_PRIO2:    equ    2                                         ; Transmit Buffer Priority Bit 2
CANTXTBPR_PRIO3:    equ    3                                         ; Transmit Buffer Priority Bit 3
CANTXTBPR_PRIO4:    equ    4                                         ; Transmit Buffer Priority Bit 4
CANTXTBPR_PRIO5:    equ    5                                         ; Transmit Buffer Priority Bit 5
CANTXTBPR_PRIO6:    equ    6                                         ; Transmit Buffer Priority Bit 6
CANTXTBPR_PRIO7:    equ    7                                         ; Transmit Buffer Priority Bit 7
; bit position masks
mCANTXTBPR_PRIO0:   equ    %00000001
mCANTXTBPR_PRIO1:   equ    %00000010
mCANTXTBPR_PRIO2:   equ    %00000100
mCANTXTBPR_PRIO3:   equ    %00001000
mCANTXTBPR_PRIO4:   equ    %00010000
mCANTXTBPR_PRIO5:   equ    %00100000
mCANTXTBPR_PRIO6:   equ    %01000000
mCANTXTBPR_PRIO7:   equ    %10000000


;*** CANTXTSR - MSCAN Transmit Time Stamp Register; 0x0000017E ***
CANTXTSR:           equ    $0000017E                                ;*** CANTXTSR - MSCAN Transmit Time Stamp Register; 0x0000017E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANTXTSR_TSR0:      equ    0                                         ; Time Stamp Bit 0
CANTXTSR_TSR1:      equ    1                                         ; Time Stamp Bit 1
CANTXTSR_TSR2:      equ    2                                         ; Time Stamp Bit 2
CANTXTSR_TSR3:      equ    3                                         ; Time Stamp Bit 3
CANTXTSR_TSR4:      equ    4                                         ; Time Stamp Bit 4
CANTXTSR_TSR5:      equ    5                                         ; Time Stamp Bit 5
CANTXTSR_TSR6:      equ    6                                         ; Time Stamp Bit 6
CANTXTSR_TSR7:      equ    7                                         ; Time Stamp Bit 7
CANTXTSR_TSR8:      equ    8                                         ; Time Stamp Bit 8
CANTXTSR_TSR9:      equ    9                                         ; Time Stamp Bit 9
CANTXTSR_TSR10:     equ    10                                        ; Time Stamp Bit 10
CANTXTSR_TSR11:     equ    11                                        ; Time Stamp Bit 11
CANTXTSR_TSR12:     equ    12                                        ; Time Stamp Bit 12
CANTXTSR_TSR13:     equ    13                                        ; Time Stamp Bit 13
CANTXTSR_TSR14:     equ    14                                        ; Time Stamp Bit 14
CANTXTSR_TSR15:     equ    15                                        ; Time Stamp Bit 15
; bit position masks
mCANTXTSR_TSR0:     equ    %00000001
mCANTXTSR_TSR1:     equ    %00000010
mCANTXTSR_TSR2:     equ    %00000100
mCANTXTSR_TSR3:     equ    %00001000
mCANTXTSR_TSR4:     equ    %00010000
mCANTXTSR_TSR5:     equ    %00100000
mCANTXTSR_TSR6:     equ    %01000000
mCANTXTSR_TSR7:     equ    %10000000
mCANTXTSR_TSR8:     equ    %100000000
mCANTXTSR_TSR9:     equ    %1000000000
mCANTXTSR_TSR10:    equ    %10000000000
mCANTXTSR_TSR11:    equ    %100000000000
mCANTXTSR_TSR12:    equ    %1000000000000
mCANTXTSR_TSR13:    equ    %10000000000000
mCANTXTSR_TSR14:    equ    %100000000000000
mCANTXTSR_TSR15:    equ    %1000000000000000


;*** CANTXTSRH - MSCAN Transmit Time Stamp Register High; 0x0000017E ***
CANTXTSRH:          equ    $0000017E                                ;*** CANTXTSRH - MSCAN Transmit Time Stamp Register High; 0x0000017E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANTXTSRH_TSR8:     equ    0                                         ; Time Stamp Bit 8
CANTXTSRH_TSR9:     equ    1                                         ; Time Stamp Bit 9
CANTXTSRH_TSR10:    equ    2                                         ; Time Stamp Bit 10
CANTXTSRH_TSR11:    equ    3                                         ; Time Stamp Bit 11
CANTXTSRH_TSR12:    equ    4                                         ; Time Stamp Bit 12
CANTXTSRH_TSR13:    equ    5                                         ; Time Stamp Bit 13
CANTXTSRH_TSR14:    equ    6                                         ; Time Stamp Bit 14
CANTXTSRH_TSR15:    equ    7                                         ; Time Stamp Bit 15
; bit position masks
mCANTXTSRH_TSR8:    equ    %00000001
mCANTXTSRH_TSR9:    equ    %00000010
mCANTXTSRH_TSR10:   equ    %00000100
mCANTXTSRH_TSR11:   equ    %00001000
mCANTXTSRH_TSR12:   equ    %00010000
mCANTXTSRH_TSR13:   equ    %00100000
mCANTXTSRH_TSR14:   equ    %01000000
mCANTXTSRH_TSR15:   equ    %10000000


;*** CANTXTSRL - MSCAN Transmit Time Stamp Register Low; 0x0000017F ***
CANTXTSRL:          equ    $0000017F                                ;*** CANTXTSRL - MSCAN Transmit Time Stamp Register Low; 0x0000017F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANTXTSRL_TSR0:     equ    0                                         ; Time Stamp Bit 0
CANTXTSRL_TSR1:     equ    1                                         ; Time Stamp Bit 1
CANTXTSRL_TSR2:     equ    2                                         ; Time Stamp Bit 2
CANTXTSRL_TSR3:     equ    3                                         ; Time Stamp Bit 3
CANTXTSRL_TSR4:     equ    4                                         ; Time Stamp Bit 4
CANTXTSRL_TSR5:     equ    5                                         ; Time Stamp Bit 5
CANTXTSRL_TSR6:     equ    6                                         ; Time Stamp Bit 6
CANTXTSRL_TSR7:     equ    7                                         ; Time Stamp Bit 7
; bit position masks
mCANTXTSRL_TSR0:    equ    %00000001
mCANTXTSRL_TSR1:    equ    %00000010
mCANTXTSRL_TSR2:    equ    %00000100
mCANTXTSRL_TSR3:    equ    %00001000
mCANTXTSRL_TSR4:    equ    %00010000
mCANTXTSRL_TSR5:    equ    %00100000
mCANTXTSRL_TSR6:    equ    %01000000
mCANTXTSRL_TSR7:    equ    %10000000


;*** PTT - Port T I/O Register; 0x00000240 ***
PTT:                equ    $00000240                                ;*** PTT - Port T I/O Register; 0x00000240 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTT_PTT0:           equ    0                                         ; Port T Bit 0
PTT_PTT1:           equ    1                                         ; Port T Bit 1
PTT_PTT2:           equ    2                                         ; Port T Bit 2
PTT_PTT3:           equ    3                                         ; Port T Bit 3
PTT_PTT4:           equ    4                                         ; Port T Bit 4
PTT_PTT5:           equ    5                                         ; Port T Bit 5
PTT_PTT6:           equ    6                                         ; Port T Bit 6
PTT_PTT7:           equ    7                                         ; Port T Bit 7
; bit position masks
mPTT_PTT0:          equ    %00000001
mPTT_PTT1:          equ    %00000010
mPTT_PTT2:          equ    %00000100
mPTT_PTT3:          equ    %00001000
mPTT_PTT4:          equ    %00010000
mPTT_PTT5:          equ    %00100000
mPTT_PTT6:          equ    %01000000
mPTT_PTT7:          equ    %10000000


;*** PTIT - Port T Input Register; 0x00000241 ***
PTIT:               equ    $00000241                                ;*** PTIT - Port T Input Register; 0x00000241 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTIT_PTIT0:         equ    0                                         ; Port T Bit 0
PTIT_PTIT1:         equ    1                                         ; Port T Bit 1
PTIT_PTIT2:         equ    2                                         ; Port T Bit 2
PTIT_PTIT3:         equ    3                                         ; Port T Bit 3
PTIT_PTIT4:         equ    4                                         ; Port T Bit 4
PTIT_PTIT5:         equ    5                                         ; Port T Bit 5
PTIT_PTIT6:         equ    6                                         ; Port T Bit 6
PTIT_PTIT7:         equ    7                                         ; Port T Bit 7
; bit position masks
mPTIT_PTIT0:        equ    %00000001
mPTIT_PTIT1:        equ    %00000010
mPTIT_PTIT2:        equ    %00000100
mPTIT_PTIT3:        equ    %00001000
mPTIT_PTIT4:        equ    %00010000
mPTIT_PTIT5:        equ    %00100000
mPTIT_PTIT6:        equ    %01000000
mPTIT_PTIT7:        equ    %10000000


;*** DDRT - Port T Data Direction Register; 0x00000242 ***
DDRT:               equ    $00000242                                ;*** DDRT - Port T Data Direction Register; 0x00000242 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRT_DDRT0:         equ    0                                         ; Data Direction Port T Bit 0
DDRT_DDRT1:         equ    1                                         ; Data Direction Port T Bit 1
DDRT_DDRT2:         equ    2                                         ; Data Direction Port T Bit 2
DDRT_DDRT3:         equ    3                                         ; Data Direction Port T Bit 3
DDRT_DDRT4:         equ    4                                         ; Data Direction Port T Bit 4
DDRT_DDRT5:         equ    5                                         ; Data Direction Port T Bit 5
DDRT_DDRT6:         equ    6                                         ; Data Direction Port T Bit 6
DDRT_DDRT7:         equ    7                                         ; Data Direction Port T Bit 7
; bit position masks
mDDRT_DDRT0:        equ    %00000001
mDDRT_DDRT1:        equ    %00000010
mDDRT_DDRT2:        equ    %00000100
mDDRT_DDRT3:        equ    %00001000
mDDRT_DDRT4:        equ    %00010000
mDDRT_DDRT5:        equ    %00100000
mDDRT_DDRT6:        equ    %01000000
mDDRT_DDRT7:        equ    %10000000


;*** RDRT - Port T Reduced Drive Register; 0x00000243 ***
RDRT:               equ    $00000243                                ;*** RDRT - Port T Reduced Drive Register; 0x00000243 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RDRT_RDRT0:         equ    0                                         ; Reduced Drive Port T Bit 0
RDRT_RDRT1:         equ    1                                         ; Reduced Drive Port T Bit 1
RDRT_RDRT2:         equ    2                                         ; Reduced Drive Port T Bit 2
RDRT_RDRT3:         equ    3                                         ; Reduced Drive Port T Bit 3
RDRT_RDRT4:         equ    4                                         ; Reduced Drive Port T Bit 4
RDRT_RDRT5:         equ    5                                         ; Reduced Drive Port T Bit 5
RDRT_RDRT6:         equ    6                                         ; Reduced Drive Port T Bit 6
RDRT_RDRT7:         equ    7                                         ; Reduced Drive Port T Bit 7
; bit position masks
mRDRT_RDRT0:        equ    %00000001
mRDRT_RDRT1:        equ    %00000010
mRDRT_RDRT2:        equ    %00000100
mRDRT_RDRT3:        equ    %00001000
mRDRT_RDRT4:        equ    %00010000
mRDRT_RDRT5:        equ    %00100000
mRDRT_RDRT6:        equ    %01000000
mRDRT_RDRT7:        equ    %10000000


;*** PERT - Port T Pull Device Enable Register; 0x00000244 ***
PERT:               equ    $00000244                                ;*** PERT - Port T Pull Device Enable Register; 0x00000244 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PERT_PERT0:         equ    0                                         ; Pull Device Enable Port T Bit 0
PERT_PERT1:         equ    1                                         ; Pull Device Enable Port T Bit 1
PERT_PERT2:         equ    2                                         ; Pull Device Enable Port T Bit 2
PERT_PERT3:         equ    3                                         ; Pull Device Enable Port T Bit 3
PERT_PERT4:         equ    4                                         ; Pull Device Enable Port T Bit 4
PERT_PERT5:         equ    5                                         ; Pull Device Enable Port T Bit 5
PERT_PERT6:         equ    6                                         ; Pull Device Enable Port T Bit 6
PERT_PERT7:         equ    7                                         ; Pull Device Enable Port T Bit 7
; bit position masks
mPERT_PERT0:        equ    %00000001
mPERT_PERT1:        equ    %00000010
mPERT_PERT2:        equ    %00000100
mPERT_PERT3:        equ    %00001000
mPERT_PERT4:        equ    %00010000
mPERT_PERT5:        equ    %00100000
mPERT_PERT6:        equ    %01000000
mPERT_PERT7:        equ    %10000000


;*** PPST - Port T Polarity Select Register; 0x00000245 ***
PPST:               equ    $00000245                                ;*** PPST - Port T Polarity Select Register; 0x00000245 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PPST_PPST0:         equ    0                                         ; Pull Select Port T Bit 0
PPST_PPST1:         equ    1                                         ; Pull Select Port T Bit 1
PPST_PPST2:         equ    2                                         ; Pull Select Port T Bit 2
PPST_PPST3:         equ    3                                         ; Pull Select Port T Bit 3
PPST_PPST4:         equ    4                                         ; Pull Select Port T Bit 4
PPST_PPST5:         equ    5                                         ; Pull Select Port T Bit 5
PPST_PPST6:         equ    6                                         ; Pull Select Port T Bit 6
PPST_PPST7:         equ    7                                         ; Pull Select Port T Bit 7
; bit position masks
mPPST_PPST0:        equ    %00000001
mPPST_PPST1:        equ    %00000010
mPPST_PPST2:        equ    %00000100
mPPST_PPST3:        equ    %00001000
mPPST_PPST4:        equ    %00010000
mPPST_PPST5:        equ    %00100000
mPPST_PPST6:        equ    %01000000
mPPST_PPST7:        equ    %10000000


;*** MODRR - Module Routing Register; 0x00000247 ***
MODRR:              equ    $00000247                                ;*** MODRR - Module Routing Register; 0x00000247 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MODRR_MODRR0:       equ    0                                         ; Module Routing Bit 0
MODRR_MODRR1:       equ    1                                         ; Module Routing Bit 1
MODRR_MODRR2:       equ    2                                         ; Module Routing Bit 2
MODRR_MODRR3:       equ    3                                         ; Module Routing Bit 3
MODRR_MODRR4:       equ    4                                         ; Module Routing Bit 4
; bit position masks
mMODRR_MODRR0:      equ    %00000001
mMODRR_MODRR1:      equ    %00000010
mMODRR_MODRR2:      equ    %00000100
mMODRR_MODRR3:      equ    %00001000
mMODRR_MODRR4:      equ    %00010000


;*** PTS - Port S I/O Register; 0x00000248 ***
PTS:                equ    $00000248                                ;*** PTS - Port S I/O Register; 0x00000248 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTS_PTS0:           equ    0                                         ; Port S Bit 0
PTS_PTS1:           equ    1                                         ; Port S Bit 1
PTS_PTS2:           equ    2                                         ; Port S Bit 2
PTS_PTS3:           equ    3                                         ; Port S Bit 3
; bit position masks
mPTS_PTS0:          equ    %00000001
mPTS_PTS1:          equ    %00000010
mPTS_PTS2:          equ    %00000100
mPTS_PTS3:          equ    %00001000


;*** PTIS - Port S Input Register; 0x00000249 ***
PTIS:               equ    $00000249                                ;*** PTIS - Port S Input Register; 0x00000249 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTIS_PTIS0:         equ    0                                         ; Port S Bit 0
PTIS_PTIS1:         equ    1                                         ; Port S Bit 1
PTIS_PTIS2:         equ    2                                         ; Port S Bit 2
PTIS_PTIS3:         equ    3                                         ; Port S Bit 3
; bit position masks
mPTIS_PTIS0:        equ    %00000001
mPTIS_PTIS1:        equ    %00000010
mPTIS_PTIS2:        equ    %00000100
mPTIS_PTIS3:        equ    %00001000


;*** DDRS - Port S Data Direction Register; 0x0000024A ***
DDRS:               equ    $0000024A                                ;*** DDRS - Port S Data Direction Register; 0x0000024A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRS_DDRS0:         equ    0                                         ; Data Direction Port S Bit 0
DDRS_DDRS1:         equ    1                                         ; Data Direction Port S Bit 1
DDRS_DDRS2:         equ    2                                         ; Data Direction Port S Bit 2
DDRS_DDRS3:         equ    3                                         ; Data Direction Port S Bit 3
; bit position masks
mDDRS_DDRS0:        equ    %00000001
mDDRS_DDRS1:        equ    %00000010
mDDRS_DDRS2:        equ    %00000100
mDDRS_DDRS3:        equ    %00001000


;*** RDRS - Port S Reduced Drive Register; 0x0000024B ***
RDRS:               equ    $0000024B                                ;*** RDRS - Port S Reduced Drive Register; 0x0000024B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RDRS_RDRS0:         equ    0                                         ; Reduced Drive Port S Bit 0
RDRS_RDRS1:         equ    1                                         ; Reduced Drive Port S Bit 1
RDRS_RDRS2:         equ    2                                         ; Reduced Drive Port S Bit 2
RDRS_RDRS3:         equ    3                                         ; Reduced Drive Port S Bit 3
; bit position masks
mRDRS_RDRS0:        equ    %00000001
mRDRS_RDRS1:        equ    %00000010
mRDRS_RDRS2:        equ    %00000100
mRDRS_RDRS3:        equ    %00001000


;*** PERS - Port S Pull Device Enable Register; 0x0000024C ***
PERS:               equ    $0000024C                                ;*** PERS - Port S Pull Device Enable Register; 0x0000024C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PERS_PERS0:         equ    0                                         ; Pull Device Enable Port S Bit 0
PERS_PERS1:         equ    1                                         ; Pull Device Enable Port S Bit 1
PERS_PERS2:         equ    2                                         ; Pull Device Enable Port S Bit 2
PERS_PERS3:         equ    3                                         ; Pull Device Enable Port S Bit 3
; bit position masks
mPERS_PERS0:        equ    %00000001
mPERS_PERS1:        equ    %00000010
mPERS_PERS2:        equ    %00000100
mPERS_PERS3:        equ    %00001000


;*** PPSS - Port S Polarity Select Register; 0x0000024D ***
PPSS:               equ    $0000024D                                ;*** PPSS - Port S Polarity Select Register; 0x0000024D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PPSS_PPSS0:         equ    0                                         ; Pull Select Port S Bit 0
PPSS_PPSS1:         equ    1                                         ; Pull Select Port S Bit 1
PPSS_PPSS2:         equ    2                                         ; Pull Select Port S Bit 2
PPSS_PPSS3:         equ    3                                         ; Pull Select Port S Bit 3
; bit position masks
mPPSS_PPSS0:        equ    %00000001
mPPSS_PPSS1:        equ    %00000010
mPPSS_PPSS2:        equ    %00000100
mPPSS_PPSS3:        equ    %00001000


;*** WOMS - Port S Wired-Or Mode Register; 0x0000024E ***
WOMS:               equ    $0000024E                                ;*** WOMS - Port S Wired-Or Mode Register; 0x0000024E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
WOMS_WOMS0:         equ    0                                         ; Wired-Or Mode Port S Bit 0
WOMS_WOMS1:         equ    1                                         ; Wired-Or Mode Port S Bit 1
WOMS_WOMS2:         equ    2                                         ; Wired-Or Mode Port S Bit 2
WOMS_WOMS3:         equ    3                                         ; Wired-Or Mode Port S Bit 3
; bit position masks
mWOMS_WOMS0:        equ    %00000001
mWOMS_WOMS1:        equ    %00000010
mWOMS_WOMS2:        equ    %00000100
mWOMS_WOMS3:        equ    %00001000


;*** PTM - Port M I/O Register; 0x00000250 ***
PTM:                equ    $00000250                                ;*** PTM - Port M I/O Register; 0x00000250 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTM_PTM0:           equ    0                                         ; Port M Bit 0
PTM_PTM1:           equ    1                                         ; Port M Bit 1
PTM_PTM2:           equ    2                                         ; Port M Bit 2
PTM_PTM3:           equ    3                                         ; Port M Bit 3
PTM_PTM4:           equ    4                                         ; Port M Bit 4
PTM_PTM5:           equ    5                                         ; Port M Bit 5
; bit position masks
mPTM_PTM0:          equ    %00000001
mPTM_PTM1:          equ    %00000010
mPTM_PTM2:          equ    %00000100
mPTM_PTM3:          equ    %00001000
mPTM_PTM4:          equ    %00010000
mPTM_PTM5:          equ    %00100000


;*** PTIM - Port M Input Register; 0x00000251 ***
PTIM:               equ    $00000251                                ;*** PTIM - Port M Input Register; 0x00000251 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTIM_PTIM0:         equ    0                                         ; Port M Bit 0
PTIM_PTIM1:         equ    1                                         ; Port M Bit 1
PTIM_PTIM2:         equ    2                                         ; Port M Bit 2
PTIM_PTIM3:         equ    3                                         ; Port M Bit 3
PTIM_PTIM4:         equ    4                                         ; Port M Bit 4
PTIM_PTIM5:         equ    5                                         ; Port M Bit 5
; bit position masks
mPTIM_PTIM0:        equ    %00000001
mPTIM_PTIM1:        equ    %00000010
mPTIM_PTIM2:        equ    %00000100
mPTIM_PTIM3:        equ    %00001000
mPTIM_PTIM4:        equ    %00010000
mPTIM_PTIM5:        equ    %00100000


;*** DDRM - Port M Data Direction Register; 0x00000252 ***
DDRM:               equ    $00000252                                ;*** DDRM - Port M Data Direction Register; 0x00000252 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRM_DDRM0:         equ    0                                         ; Data Direction Port M Bit 0
DDRM_DDRM1:         equ    1                                         ; Data Direction Port M Bit 1
DDRM_DDRM2:         equ    2                                         ; Data Direction Port M Bit 2
DDRM_DDRM3:         equ    3                                         ; Data Direction Port M Bit 3
DDRM_DDRM4:         equ    4                                         ; Data Direction Port M Bit 4
DDRM_DDRM5:         equ    5                                         ; Data Direction Port M Bit 5
; bit position masks
mDDRM_DDRM0:        equ    %00000001
mDDRM_DDRM1:        equ    %00000010
mDDRM_DDRM2:        equ    %00000100
mDDRM_DDRM3:        equ    %00001000
mDDRM_DDRM4:        equ    %00010000
mDDRM_DDRM5:        equ    %00100000


;*** RDRM - Port M Reduced Drive Register; 0x00000253 ***
RDRM:               equ    $00000253                                ;*** RDRM - Port M Reduced Drive Register; 0x00000253 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RDRM_RDRM0:         equ    0                                         ; Reduced Drive Port M Bit 0
RDRM_RDRM1:         equ    1                                         ; Reduced Drive Port M Bit 1
RDRM_RDRM2:         equ    2                                         ; Reduced Drive Port M Bit 2
RDRM_RDRM3:         equ    3                                         ; Reduced Drive Port M Bit 3
RDRM_RDRM4:         equ    4                                         ; Reduced Drive Port M Bit 4
RDRM_RDRM5:         equ    5                                         ; Reduced Drive Port M Bit 5
; bit position masks
mRDRM_RDRM0:        equ    %00000001
mRDRM_RDRM1:        equ    %00000010
mRDRM_RDRM2:        equ    %00000100
mRDRM_RDRM3:        equ    %00001000
mRDRM_RDRM4:        equ    %00010000
mRDRM_RDRM5:        equ    %00100000


;*** PERM - Port M Pull Device Enable Register; 0x00000254 ***
PERM:               equ    $00000254                                ;*** PERM - Port M Pull Device Enable Register; 0x00000254 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PERM_PERM0:         equ    0                                         ; Pull Device Enable Port M Bit 0
PERM_PERM1:         equ    1                                         ; Pull Device Enable Port M Bit 1
PERM_PERM2:         equ    2                                         ; Pull Device Enable Port M Bit 2
PERM_PERM3:         equ    3                                         ; Pull Device Enable Port M Bit 3
PERM_PERM4:         equ    4                                         ; Pull Device Enable Port M Bit 4
PERM_PERM5:         equ    5                                         ; Pull Device Enable Port M Bit 5
; bit position masks
mPERM_PERM0:        equ    %00000001
mPERM_PERM1:        equ    %00000010
mPERM_PERM2:        equ    %00000100
mPERM_PERM3:        equ    %00001000
mPERM_PERM4:        equ    %00010000
mPERM_PERM5:        equ    %00100000


;*** PPSM - Port M Polarity Select Register; 0x00000255 ***
PPSM:               equ    $00000255                                ;*** PPSM - Port M Polarity Select Register; 0x00000255 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PPSM_PPSM0:         equ    0                                         ; Pull Select Port M Bit 0
PPSM_PPSM1:         equ    1                                         ; Pull Select Port M Bit 1
PPSM_PPSM2:         equ    2                                         ; Pull Select Port M Bit 2
PPSM_PPSM3:         equ    3                                         ; Pull Select Port M Bit 3
PPSM_PPSM4:         equ    4                                         ; Pull Select Port M Bit 4
PPSM_PPSM5:         equ    5                                         ; Pull Select Port M Bit 5
; bit position masks
mPPSM_PPSM0:        equ    %00000001
mPPSM_PPSM1:        equ    %00000010
mPPSM_PPSM2:        equ    %00000100
mPPSM_PPSM3:        equ    %00001000
mPPSM_PPSM4:        equ    %00010000
mPPSM_PPSM5:        equ    %00100000


;*** WOMM - Port M Wired-Or Mode Register; 0x00000256 ***
WOMM:               equ    $00000256                                ;*** WOMM - Port M Wired-Or Mode Register; 0x00000256 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
WOMM_WOMM0:         equ    0                                         ; Wired-Or Mode Port M Bit 0
WOMM_WOMM1:         equ    1                                         ; Wired-Or Mode Port M Bit 1
WOMM_WOMM2:         equ    2                                         ; Wired-Or Mode Port M Bit 2
WOMM_WOMM3:         equ    3                                         ; Wired-Or Mode Port M Bit 3
WOMM_WOMM4:         equ    4                                         ; Wired-Or Mode Port M Bit 4
WOMM_WOMM5:         equ    5                                         ; Wired-Or Mode Port M Bit 5
; bit position masks
mWOMM_WOMM0:        equ    %00000001
mWOMM_WOMM1:        equ    %00000010
mWOMM_WOMM2:        equ    %00000100
mWOMM_WOMM3:        equ    %00001000
mWOMM_WOMM4:        equ    %00010000
mWOMM_WOMM5:        equ    %00100000


;*** PTP - Port P I/O Register; 0x00000258 ***
PTP:                equ    $00000258                                ;*** PTP - Port P I/O Register; 0x00000258 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTP_PTP0:           equ    0                                         ; Port P Bit 0
PTP_PTP1:           equ    1                                         ; Port P Bit 1
PTP_PTP2:           equ    2                                         ; Port P Bit 2
PTP_PTP3:           equ    3                                         ; Port P Bit 3
PTP_PTP4:           equ    4                                         ; Port P Bit 4
PTP_PTP5:           equ    5                                         ; Port P Bit 5
PTP_PTP6:           equ    6                                         ; Port P Bit 6
PTP_PTP7:           equ    7                                         ; Port P Bit 7
; bit position masks
mPTP_PTP0:          equ    %00000001
mPTP_PTP1:          equ    %00000010
mPTP_PTP2:          equ    %00000100
mPTP_PTP3:          equ    %00001000
mPTP_PTP4:          equ    %00010000
mPTP_PTP5:          equ    %00100000
mPTP_PTP6:          equ    %01000000
mPTP_PTP7:          equ    %10000000


;*** PTIP - Port P Input Register; 0x00000259 ***
PTIP:               equ    $00000259                                ;*** PTIP - Port P Input Register; 0x00000259 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTIP_PTIP0:         equ    0                                         ; Port P Bit 0
PTIP_PTIP1:         equ    1                                         ; Port P Bit 1
PTIP_PTIP2:         equ    2                                         ; Port P Bit 2
PTIP_PTIP3:         equ    3                                         ; Port P Bit 3
PTIP_PTIP4:         equ    4                                         ; Port P Bit 4
PTIP_PTIP5:         equ    5                                         ; Port P Bit 5
PTIP_PTIP6:         equ    6                                         ; Port P Bit 6
PTIP_PTIP7:         equ    7                                         ; Port P Bit 7
; bit position masks
mPTIP_PTIP0:        equ    %00000001
mPTIP_PTIP1:        equ    %00000010
mPTIP_PTIP2:        equ    %00000100
mPTIP_PTIP3:        equ    %00001000
mPTIP_PTIP4:        equ    %00010000
mPTIP_PTIP5:        equ    %00100000
mPTIP_PTIP6:        equ    %01000000
mPTIP_PTIP7:        equ    %10000000


;*** DDRP - Port P Data Direction Register; 0x0000025A ***
DDRP:               equ    $0000025A                                ;*** DDRP - Port P Data Direction Register; 0x0000025A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRP_DDRP0:         equ    0                                         ; Data Direction Port P Bit 0
DDRP_DDRP1:         equ    1                                         ; Data Direction Port P Bit 1
DDRP_DDRP2:         equ    2                                         ; Data Direction Port P Bit 2
DDRP_DDRP3:         equ    3                                         ; Data Direction Port P Bit 3
DDRP_DDRP4:         equ    4                                         ; Data Direction Port P Bit 4
DDRP_DDRP5:         equ    5                                         ; Data Direction Port P Bit 5
DDRP_DDRP6:         equ    6                                         ; Data Direction Port P Bit 6
DDRP_DDRP7:         equ    7                                         ; Data Direction Port P Bit 7
; bit position masks
mDDRP_DDRP0:        equ    %00000001
mDDRP_DDRP1:        equ    %00000010
mDDRP_DDRP2:        equ    %00000100
mDDRP_DDRP3:        equ    %00001000
mDDRP_DDRP4:        equ    %00010000
mDDRP_DDRP5:        equ    %00100000
mDDRP_DDRP6:        equ    %01000000
mDDRP_DDRP7:        equ    %10000000


;*** RDRP - Port P Reduced Drive Register; 0x0000025B ***
RDRP:               equ    $0000025B                                ;*** RDRP - Port P Reduced Drive Register; 0x0000025B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RDRP_RDRP0:         equ    0                                         ; Reduced Drive Port P Bit 0
RDRP_RDRP1:         equ    1                                         ; Reduced Drive Port P Bit 1
RDRP_RDRP2:         equ    2                                         ; Reduced Drive Port P Bit 2
RDRP_RDRP3:         equ    3                                         ; Reduced Drive Port P Bit 3
RDRP_RDRP4:         equ    4                                         ; Reduced Drive Port P Bit 4
RDRP_RDRP5:         equ    5                                         ; Reduced Drive Port P Bit 5
RDRP_RDRP6:         equ    6                                         ; Reduced Drive Port P Bit 6
RDRP_RDRP7:         equ    7                                         ; Reduced Drive Port P Bit 7
; bit position masks
mRDRP_RDRP0:        equ    %00000001
mRDRP_RDRP1:        equ    %00000010
mRDRP_RDRP2:        equ    %00000100
mRDRP_RDRP3:        equ    %00001000
mRDRP_RDRP4:        equ    %00010000
mRDRP_RDRP5:        equ    %00100000
mRDRP_RDRP6:        equ    %01000000
mRDRP_RDRP7:        equ    %10000000


;*** PERP - Port P Pull Device Enable Register; 0x0000025C ***
PERP:               equ    $0000025C                                ;*** PERP - Port P Pull Device Enable Register; 0x0000025C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PERP_PERP0:         equ    0                                         ; Pull Device Enable Port P Bit 0
PERP_PERP1:         equ    1                                         ; Pull Device Enable Port P Bit 1
PERP_PERP2:         equ    2                                         ; Pull Device Enable Port P Bit 2
PERP_PERP3:         equ    3                                         ; Pull Device Enable Port P Bit 3
PERP_PERP4:         equ    4                                         ; Pull Device Enable Port P Bit 4
PERP_PERP5:         equ    5                                         ; Pull Device Enable Port P Bit 5
PERP_PERP6:         equ    6                                         ; Pull Device Enable Port P Bit 6
PERP_PERP7:         equ    7                                         ; Pull Device Enable Port P Bit 7
; bit position masks
mPERP_PERP0:        equ    %00000001
mPERP_PERP1:        equ    %00000010
mPERP_PERP2:        equ    %00000100
mPERP_PERP3:        equ    %00001000
mPERP_PERP4:        equ    %00010000
mPERP_PERP5:        equ    %00100000
mPERP_PERP6:        equ    %01000000
mPERP_PERP7:        equ    %10000000


;*** PPSP - Port P Polarity Select Register; 0x0000025D ***
PPSP:               equ    $0000025D                                ;*** PPSP - Port P Polarity Select Register; 0x0000025D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PPSP_PPSP0:         equ    0                                         ; Pull Select Port P Bit 0
PPSP_PPSP1:         equ    1                                         ; Pull Select Port P Bit 1
PPSP_PPSP2:         equ    2                                         ; Pull Select Port P Bit 2
PPSP_PPSP3:         equ    3                                         ; Pull Select Port P Bit 3
PPSP_PPSP4:         equ    4                                         ; Pull Select Port P Bit 4
PPSP_PPSP5:         equ    5                                         ; Pull Select Port P Bit 5
PPSP_PPSP6:         equ    6                                         ; Pull Select Port P Bit 6
PPSP_PPSP7:         equ    7                                         ; Pull Select Port P Bit 7
; bit position masks
mPPSP_PPSP0:        equ    %00000001
mPPSP_PPSP1:        equ    %00000010
mPPSP_PPSP2:        equ    %00000100
mPPSP_PPSP3:        equ    %00001000
mPPSP_PPSP4:        equ    %00010000
mPPSP_PPSP5:        equ    %00100000
mPPSP_PPSP6:        equ    %01000000
mPPSP_PPSP7:        equ    %10000000


;*** PIEP - Port P Interrupt Enable Register; 0x0000025E ***
PIEP:               equ    $0000025E                                ;*** PIEP - Port P Interrupt Enable Register; 0x0000025E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PIEP_PIEP0:         equ    0                                         ; Interrupt Enable Port P Bit 0
PIEP_PIEP1:         equ    1                                         ; Interrupt Enable Port P Bit 1
PIEP_PIEP2:         equ    2                                         ; Interrupt Enable Port P Bit 2
PIEP_PIEP3:         equ    3                                         ; Interrupt Enable Port P Bit 3
PIEP_PIEP4:         equ    4                                         ; Interrupt Enable Port P Bit 4
PIEP_PIEP5:         equ    5                                         ; Interrupt Enable Port P Bit 5
PIEP_PIEP6:         equ    6                                         ; Interrupt Enable Port P Bit 6
PIEP_PIEP7:         equ    7                                         ; Interrupt Enable Port P Bit 7
; bit position masks
mPIEP_PIEP0:        equ    %00000001
mPIEP_PIEP1:        equ    %00000010
mPIEP_PIEP2:        equ    %00000100
mPIEP_PIEP3:        equ    %00001000
mPIEP_PIEP4:        equ    %00010000
mPIEP_PIEP5:        equ    %00100000
mPIEP_PIEP6:        equ    %01000000
mPIEP_PIEP7:        equ    %10000000


;*** PIFP - Port P Interrupt Flag Register; 0x0000025F ***
PIFP:               equ    $0000025F                                ;*** PIFP - Port P Interrupt Flag Register; 0x0000025F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PIFP_PIFP0:         equ    0                                         ; Interrupt Flags Port P Bit 0
PIFP_PIFP1:         equ    1                                         ; Interrupt Flags Port P Bit 1
PIFP_PIFP2:         equ    2                                         ; Interrupt Flags Port P Bit 2
PIFP_PIFP3:         equ    3                                         ; Interrupt Flags Port P Bit 3
PIFP_PIFP4:         equ    4                                         ; Interrupt Flags Port P Bit 4
PIFP_PIFP5:         equ    5                                         ; Interrupt Flags Port P Bit 5
PIFP_PIFP6:         equ    6                                         ; Interrupt Flags Port P Bit 6
PIFP_PIFP7:         equ    7                                         ; Interrupt Flags Port P Bit 7
; bit position masks
mPIFP_PIFP0:        equ    %00000001
mPIFP_PIFP1:        equ    %00000010
mPIFP_PIFP2:        equ    %00000100
mPIFP_PIFP3:        equ    %00001000
mPIFP_PIFP4:        equ    %00010000
mPIFP_PIFP5:        equ    %00100000
mPIFP_PIFP6:        equ    %01000000
mPIFP_PIFP7:        equ    %10000000


;*** PTJ - Port J I/O Register; 0x00000268 ***
PTJ:                equ    $00000268                                ;*** PTJ - Port J I/O Register; 0x00000268 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTJ_PTJ6:           equ    6                                         ; Port J Bit 6
PTJ_PTJ7:           equ    7                                         ; Port J Bit 7
; bit position masks
mPTJ_PTJ6:          equ    %01000000
mPTJ_PTJ7:          equ    %10000000


;*** PTIJ - Port J Input Register; 0x00000269 ***
PTIJ:               equ    $00000269                                ;*** PTIJ - Port J Input Register; 0x00000269 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTIJ_PTIJ6:         equ    6                                         ; Port J Bit 6
PTIJ_PTIJ7:         equ    7                                         ; Port J Bit 7
; bit position masks
mPTIJ_PTIJ6:        equ    %01000000
mPTIJ_PTIJ7:        equ    %10000000


;*** DDRJ - Port J Data Direction Register; 0x0000026A ***
DDRJ:               equ    $0000026A                                ;*** DDRJ - Port J Data Direction Register; 0x0000026A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRJ_DDRJ6:         equ    6                                         ; Data Direction Port J Bit 6
DDRJ_DDRJ7:         equ    7                                         ; Data Direction Port J Bit 7
; bit position masks
mDDRJ_DDRJ6:        equ    %01000000
mDDRJ_DDRJ7:        equ    %10000000


;*** RDRJ - Port J Reduced Drive Register; 0x0000026B ***
RDRJ:               equ    $0000026B                                ;*** RDRJ - Port J Reduced Drive Register; 0x0000026B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RDRJ_RDRJ6:         equ    6                                         ; Reduced Drive Port J Bit 6
RDRJ_RDRJ7:         equ    7                                         ; Reduced Drive Port J Bit 7
; bit position masks
mRDRJ_RDRJ6:        equ    %01000000
mRDRJ_RDRJ7:        equ    %10000000


;*** PERJ - Port J Pull Device Enable Register; 0x0000026C ***
PERJ:               equ    $0000026C                                ;*** PERJ - Port J Pull Device Enable Register; 0x0000026C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PERJ_PERJ6:         equ    6                                         ; Pull Device Enable Port J Bit 6
PERJ_PERJ7:         equ    7                                         ; Pull Device Enable Port J Bit 7
; bit position masks
mPERJ_PERJ6:        equ    %01000000
mPERJ_PERJ7:        equ    %10000000


;*** PPSJ - Port J Polarity Select Register; 0x0000026D ***
PPSJ:               equ    $0000026D                                ;*** PPSJ - Port J Polarity Select Register; 0x0000026D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PPSJ_PPSJ6:         equ    6                                         ; Pull Select Port J Bit 6
PPSJ_PPSJ7:         equ    7                                         ; Pull Select Port J Bit 7
; bit position masks
mPPSJ_PPSJ6:        equ    %01000000
mPPSJ_PPSJ7:        equ    %10000000


;*** PIEJ - Port J Interrupt Enable Register; 0x0000026E ***
PIEJ:               equ    $0000026E                                ;*** PIEJ - Port J Interrupt Enable Register; 0x0000026E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PIEJ_PIEJ6:         equ    6                                         ; Interrupt Enable Port J Bit 6
PIEJ_PIEJ7:         equ    7                                         ; Interrupt Enable Port J Bit 7
; bit position masks
mPIEJ_PIEJ6:        equ    %01000000
mPIEJ_PIEJ7:        equ    %10000000


;*** PIFJ - Port J Interrupt Flag Register; 0x0000026F ***
PIFJ:               equ    $0000026F                                ;*** PIFJ - Port J Interrupt Flag Register; 0x0000026F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PIFJ_PIFJ6:         equ    6                                         ; Interrupt Flags Port J Bit 6
PIFJ_PIFJ7:         equ    7                                         ; Interrupt Flags Port J Bit 7
; bit position masks
mPIFJ_PIFJ6:        equ    %01000000
mPIFJ_PIFJ7:        equ    %10000000


;*** PTAD - Port AD I/O Register; 0x00000270 ***
PTAD:               equ    $00000270                                ;*** PTAD - Port AD I/O Register; 0x00000270 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTAD_PTAD0:         equ    0                                         ; Port AD Bit 0
PTAD_PTAD1:         equ    1                                         ; Port AD Bit 1
PTAD_PTAD2:         equ    2                                         ; Port AD Bit 2
PTAD_PTAD3:         equ    3                                         ; Port AD Bit 3
PTAD_PTAD4:         equ    4                                         ; Port AD Bit 4
PTAD_PTAD5:         equ    5                                         ; Port AD Bit 5
PTAD_PTAD6:         equ    6                                         ; Port AD Bit 6
PTAD_PTAD7:         equ    7                                         ; Port AD Bit 7
; bit position masks
mPTAD_PTAD0:        equ    %00000001
mPTAD_PTAD1:        equ    %00000010
mPTAD_PTAD2:        equ    %00000100
mPTAD_PTAD3:        equ    %00001000
mPTAD_PTAD4:        equ    %00010000
mPTAD_PTAD5:        equ    %00100000
mPTAD_PTAD6:        equ    %01000000
mPTAD_PTAD7:        equ    %10000000


;*** PTIAD - Port AD Input Register; 0x00000271 ***
PTIAD:              equ    $00000271                                ;*** PTIAD - Port AD Input Register; 0x00000271 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTIAD_PTIAD0:       equ    0                                         ; Port AD Bit 0
PTIAD_PTIAD1:       equ    1                                         ; Port AD Bit 1
PTIAD_PTIAD2:       equ    2                                         ; Port AD Bit 2
PTIAD_PTIAD3:       equ    3                                         ; Port AD Bit 3
PTIAD_PTIAD4:       equ    4                                         ; Port AD Bit 4
PTIAD_PTIAD5:       equ    5                                         ; Port AD Bit 5
PTIAD_PTIAD6:       equ    6                                         ; Port AD Bit 6
PTIAD_PTIAD7:       equ    7                                         ; Port AD Bit 7
; bit position masks
mPTIAD_PTIAD0:      equ    %00000001
mPTIAD_PTIAD1:      equ    %00000010
mPTIAD_PTIAD2:      equ    %00000100
mPTIAD_PTIAD3:      equ    %00001000
mPTIAD_PTIAD4:      equ    %00010000
mPTIAD_PTIAD5:      equ    %00100000
mPTIAD_PTIAD6:      equ    %01000000
mPTIAD_PTIAD7:      equ    %10000000


;*** DDRAD - Port AD Data Direction Register; 0x00000272 ***
DDRAD:              equ    $00000272                                ;*** DDRAD - Port AD Data Direction Register; 0x00000272 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRAD_DDRAD0:       equ    0                                         ; Port AD Data Direction Bit 0
DDRAD_DDRAD1:       equ    1                                         ; Port AD Data Direction Bit 1
DDRAD_DDRAD2:       equ    2                                         ; Port AD Data Direction Bit 2
DDRAD_DDRAD3:       equ    3                                         ; Port AD Data Direction Bit 3
DDRAD_DDRAD4:       equ    4                                         ; Port AD Data Direction Bit 4
DDRAD_DDRAD5:       equ    5                                         ; Port AD Data Direction Bit 5
DDRAD_DDRAD6:       equ    6                                         ; Port AD Data Direction Bit 6
DDRAD_DDRAD7:       equ    7                                         ; Port AD Data Direction Bit 7
; bit position masks
mDDRAD_DDRAD0:      equ    %00000001
mDDRAD_DDRAD1:      equ    %00000010
mDDRAD_DDRAD2:      equ    %00000100
mDDRAD_DDRAD3:      equ    %00001000
mDDRAD_DDRAD4:      equ    %00010000
mDDRAD_DDRAD5:      equ    %00100000
mDDRAD_DDRAD6:      equ    %01000000
mDDRAD_DDRAD7:      equ    %10000000


;*** RDRAD - Port AD Reduced Drive Register; 0x00000273 ***
RDRAD:              equ    $00000273                                ;*** RDRAD - Port AD Reduced Drive Register; 0x00000273 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RDRAD_RDRAD0:       equ    0                                         ; Port AD Reduced Drive Bit 0
RDRAD_RDRAD1:       equ    1                                         ; Port AD Reduced Drive Bit 1
RDRAD_RDRAD2:       equ    2                                         ; Port AD Reduced Drive Bit 2
RDRAD_RDRAD3:       equ    3                                         ; Port AD Reduced Drive Bit 3
RDRAD_RDRAD4:       equ    4                                         ; Port AD Reduced Drive Bit 4
RDRAD_RDRAD5:       equ    5                                         ; Port AD Reduced Drive Bit 5
RDRAD_RDRAD6:       equ    6                                         ; Port AD Reduced Drive Bit 6
RDRAD_RDRAD7:       equ    7                                         ; Port AD Reduced Drive Bit 7
; bit position masks
mRDRAD_RDRAD0:      equ    %00000001
mRDRAD_RDRAD1:      equ    %00000010
mRDRAD_RDRAD2:      equ    %00000100
mRDRAD_RDRAD3:      equ    %00001000
mRDRAD_RDRAD4:      equ    %00010000
mRDRAD_RDRAD5:      equ    %00100000
mRDRAD_RDRAD6:      equ    %01000000
mRDRAD_RDRAD7:      equ    %10000000


;*** PERAD - Port AD Pull Device Enable Register; 0x00000274 ***
PERAD:              equ    $00000274                                ;*** PERAD - Port AD Pull Device Enable Register; 0x00000274 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PERAD_PERAD0:       equ    0                                         ; Port AD Pull Device Enable Bit 0
PERAD_PERAD1:       equ    1                                         ; Port AD Pull Device Enable Bit 1
PERAD_PERAD2:       equ    2                                         ; Port AD Pull Device Enable Bit 2
PERAD_PERAD3:       equ    3                                         ; Port AD Pull Device Enable Bit 3
PERAD_PERAD4:       equ    4                                         ; Port AD Pull Device Enable Bit 4
PERAD_PERAD5:       equ    5                                         ; Port AD Pull Device Enable Bit 5
PERAD_PERAD6:       equ    6                                         ; Port AD Pull Device Enable Bit 6
PERAD_PERAD7:       equ    7                                         ; Port AD Pull Device Enable Bit 7
; bit position masks
mPERAD_PERAD0:      equ    %00000001
mPERAD_PERAD1:      equ    %00000010
mPERAD_PERAD2:      equ    %00000100
mPERAD_PERAD3:      equ    %00001000
mPERAD_PERAD4:      equ    %00010000
mPERAD_PERAD5:      equ    %00100000
mPERAD_PERAD6:      equ    %01000000
mPERAD_PERAD7:      equ    %10000000


;*** PPSAD - Port AD Polarity Select Register; 0x00000275 ***
PPSAD:              equ    $00000275                                ;*** PPSAD - Port AD Polarity Select Register; 0x00000275 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PPSAD_PPSAD0:       equ    0                                         ; Port AD Polarity Select Bit 0
PPSAD_PPSAD1:       equ    1                                         ; Port AD Polarity Select Bit 1
PPSAD_PPSAD2:       equ    2                                         ; Port AD Polarity Select Bit 2
PPSAD_PPSAD3:       equ    3                                         ; Port AD Polarity Select Bit 3
PPSAD_PPSAD4:       equ    4                                         ; Port AD Polarity Select Bit 4
PPSAD_PPSAD5:       equ    5                                         ; Port AD Polarity Select Bit 5
PPSAD_PPSAD6:       equ    6                                         ; Port AD Polarity Select Bit 6
PPSAD_PPSAD7:       equ    7                                         ; Port AD Polarity Select Bit 7
; bit position masks
mPPSAD_PPSAD0:      equ    %00000001
mPPSAD_PPSAD1:      equ    %00000010
mPPSAD_PPSAD2:      equ    %00000100
mPPSAD_PPSAD3:      equ    %00001000
mPPSAD_PPSAD4:      equ    %00010000
mPPSAD_PPSAD5:      equ    %00100000
mPPSAD_PPSAD6:      equ    %01000000
mPPSAD_PPSAD7:      equ    %10000000


;*** BAKEY0 - Backdoor Access Key 0; 0x0000FF00 ***
BAKEY0:             equ    $0000FF00                                ;*** BAKEY0 - Backdoor Access Key 0; 0x0000FF00 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
BAKEY0_KEY0:        equ    0                                         ; Backdoor Access Key bits, bit 0
BAKEY0_KEY1:        equ    1                                         ; Backdoor Access Key bits, bit 1
BAKEY0_KEY2:        equ    2                                         ; Backdoor Access Key bits, bit 2
BAKEY0_KEY3:        equ    3                                         ; Backdoor Access Key bits, bit 3
BAKEY0_KEY4:        equ    4                                         ; Backdoor Access Key bits, bit 4
BAKEY0_KEY5:        equ    5                                         ; Backdoor Access Key bits, bit 5
BAKEY0_KEY6:        equ    6                                         ; Backdoor Access Key bits, bit 6
BAKEY0_KEY7:        equ    7                                         ; Backdoor Access Key bits, bit 7
BAKEY0_KEY8:        equ    8                                         ; Backdoor Access Key bits, bit 8
BAKEY0_KEY9:        equ    9                                         ; Backdoor Access Key bits, bit 9
BAKEY0_KEY10:       equ    10                                        ; Backdoor Access Key bits, bit 10
BAKEY0_KEY11:       equ    11                                        ; Backdoor Access Key bits, bit 11
BAKEY0_KEY12:       equ    12                                        ; Backdoor Access Key bits, bit 12
BAKEY0_KEY13:       equ    13                                        ; Backdoor Access Key bits, bit 13
BAKEY0_KEY14:       equ    14                                        ; Backdoor Access Key bits, bit 14
BAKEY0_KEY15:       equ    15                                        ; Backdoor Access Key bits, bit 15
; bit position masks
mBAKEY0_KEY0:       equ    %00000001
mBAKEY0_KEY1:       equ    %00000010
mBAKEY0_KEY2:       equ    %00000100
mBAKEY0_KEY3:       equ    %00001000
mBAKEY0_KEY4:       equ    %00010000
mBAKEY0_KEY5:       equ    %00100000
mBAKEY0_KEY6:       equ    %01000000
mBAKEY0_KEY7:       equ    %10000000
mBAKEY0_KEY8:       equ    %100000000
mBAKEY0_KEY9:       equ    %1000000000
mBAKEY0_KEY10:      equ    %10000000000
mBAKEY0_KEY11:      equ    %100000000000
mBAKEY0_KEY12:      equ    %1000000000000
mBAKEY0_KEY13:      equ    %10000000000000
mBAKEY0_KEY14:      equ    %100000000000000
mBAKEY0_KEY15:      equ    %1000000000000000


;*** BAKEY1 - Backdoor Access Key 1; 0x0000FF02 ***
BAKEY1:             equ    $0000FF02                                ;*** BAKEY1 - Backdoor Access Key 1; 0x0000FF02 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
BAKEY1_KEY0:        equ    0                                         ; Backdoor Access Key bits, bit 0
BAKEY1_KEY1:        equ    1                                         ; Backdoor Access Key bits, bit 1
BAKEY1_KEY2:        equ    2                                         ; Backdoor Access Key bits, bit 2
BAKEY1_KEY3:        equ    3                                         ; Backdoor Access Key bits, bit 3
BAKEY1_KEY4:        equ    4                                         ; Backdoor Access Key bits, bit 4
BAKEY1_KEY5:        equ    5                                         ; Backdoor Access Key bits, bit 5
BAKEY1_KEY6:        equ    6                                         ; Backdoor Access Key bits, bit 6
BAKEY1_KEY7:        equ    7                                         ; Backdoor Access Key bits, bit 7
BAKEY1_KEY8:        equ    8                                         ; Backdoor Access Key bits, bit 8
BAKEY1_KEY9:        equ    9                                         ; Backdoor Access Key bits, bit 9
BAKEY1_KEY10:       equ    10                                        ; Backdoor Access Key bits, bit 10
BAKEY1_KEY11:       equ    11                                        ; Backdoor Access Key bits, bit 11
BAKEY1_KEY12:       equ    12                                        ; Backdoor Access Key bits, bit 12
BAKEY1_KEY13:       equ    13                                        ; Backdoor Access Key bits, bit 13
BAKEY1_KEY14:       equ    14                                        ; Backdoor Access Key bits, bit 14
BAKEY1_KEY15:       equ    15                                        ; Backdoor Access Key bits, bit 15
; bit position masks
mBAKEY1_KEY0:       equ    %00000001
mBAKEY1_KEY1:       equ    %00000010
mBAKEY1_KEY2:       equ    %00000100
mBAKEY1_KEY3:       equ    %00001000
mBAKEY1_KEY4:       equ    %00010000
mBAKEY1_KEY5:       equ    %00100000
mBAKEY1_KEY6:       equ    %01000000
mBAKEY1_KEY7:       equ    %10000000
mBAKEY1_KEY8:       equ    %100000000
mBAKEY1_KEY9:       equ    %1000000000
mBAKEY1_KEY10:      equ    %10000000000
mBAKEY1_KEY11:      equ    %100000000000
mBAKEY1_KEY12:      equ    %1000000000000
mBAKEY1_KEY13:      equ    %10000000000000
mBAKEY1_KEY14:      equ    %100000000000000
mBAKEY1_KEY15:      equ    %1000000000000000


;*** BAKEY2 - Backdoor Access Key 2; 0x0000FF04 ***
BAKEY2:             equ    $0000FF04                                ;*** BAKEY2 - Backdoor Access Key 2; 0x0000FF04 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
BAKEY2_KEY0:        equ    0                                         ; Backdoor Access Key bits, bit 0
BAKEY2_KEY1:        equ    1                                         ; Backdoor Access Key bits, bit 1
BAKEY2_KEY2:        equ    2                                         ; Backdoor Access Key bits, bit 2
BAKEY2_KEY3:        equ    3                                         ; Backdoor Access Key bits, bit 3
BAKEY2_KEY4:        equ    4                                         ; Backdoor Access Key bits, bit 4
BAKEY2_KEY5:        equ    5                                         ; Backdoor Access Key bits, bit 5
BAKEY2_KEY6:        equ    6                                         ; Backdoor Access Key bits, bit 6
BAKEY2_KEY7:        equ    7                                         ; Backdoor Access Key bits, bit 7
BAKEY2_KEY8:        equ    8                                         ; Backdoor Access Key bits, bit 8
BAKEY2_KEY9:        equ    9                                         ; Backdoor Access Key bits, bit 9
BAKEY2_KEY10:       equ    10                                        ; Backdoor Access Key bits, bit 10
BAKEY2_KEY11:       equ    11                                        ; Backdoor Access Key bits, bit 11
BAKEY2_KEY12:       equ    12                                        ; Backdoor Access Key bits, bit 12
BAKEY2_KEY13:       equ    13                                        ; Backdoor Access Key bits, bit 13
BAKEY2_KEY14:       equ    14                                        ; Backdoor Access Key bits, bit 14
BAKEY2_KEY15:       equ    15                                        ; Backdoor Access Key bits, bit 15
; bit position masks
mBAKEY2_KEY0:       equ    %00000001
mBAKEY2_KEY1:       equ    %00000010
mBAKEY2_KEY2:       equ    %00000100
mBAKEY2_KEY3:       equ    %00001000
mBAKEY2_KEY4:       equ    %00010000
mBAKEY2_KEY5:       equ    %00100000
mBAKEY2_KEY6:       equ    %01000000
mBAKEY2_KEY7:       equ    %10000000
mBAKEY2_KEY8:       equ    %100000000
mBAKEY2_KEY9:       equ    %1000000000
mBAKEY2_KEY10:      equ    %10000000000
mBAKEY2_KEY11:      equ    %100000000000
mBAKEY2_KEY12:      equ    %1000000000000
mBAKEY2_KEY13:      equ    %10000000000000
mBAKEY2_KEY14:      equ    %100000000000000
mBAKEY2_KEY15:      equ    %1000000000000000


;*** BAKEY3 - Backdoor Access Key 3; 0x0000FF06 ***
BAKEY3:             equ    $0000FF06                                ;*** BAKEY3 - Backdoor Access Key 3; 0x0000FF06 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
BAKEY3_KEY0:        equ    0                                         ; Backdoor Access Key bits, bit 0
BAKEY3_KEY1:        equ    1                                         ; Backdoor Access Key bits, bit 1
BAKEY3_KEY2:        equ    2                                         ; Backdoor Access Key bits, bit 2
BAKEY3_KEY3:        equ    3                                         ; Backdoor Access Key bits, bit 3
BAKEY3_KEY4:        equ    4                                         ; Backdoor Access Key bits, bit 4
BAKEY3_KEY5:        equ    5                                         ; Backdoor Access Key bits, bit 5
BAKEY3_KEY6:        equ    6                                         ; Backdoor Access Key bits, bit 6
BAKEY3_KEY7:        equ    7                                         ; Backdoor Access Key bits, bit 7
BAKEY3_KEY8:        equ    8                                         ; Backdoor Access Key bits, bit 8
BAKEY3_KEY9:        equ    9                                         ; Backdoor Access Key bits, bit 9
BAKEY3_KEY10:       equ    10                                        ; Backdoor Access Key bits, bit 10
BAKEY3_KEY11:       equ    11                                        ; Backdoor Access Key bits, bit 11
BAKEY3_KEY12:       equ    12                                        ; Backdoor Access Key bits, bit 12
BAKEY3_KEY13:       equ    13                                        ; Backdoor Access Key bits, bit 13
BAKEY3_KEY14:       equ    14                                        ; Backdoor Access Key bits, bit 14
BAKEY3_KEY15:       equ    15                                        ; Backdoor Access Key bits, bit 15
; bit position masks
mBAKEY3_KEY0:       equ    %00000001
mBAKEY3_KEY1:       equ    %00000010
mBAKEY3_KEY2:       equ    %00000100
mBAKEY3_KEY3:       equ    %00001000
mBAKEY3_KEY4:       equ    %00010000
mBAKEY3_KEY5:       equ    %00100000
mBAKEY3_KEY6:       equ    %01000000
mBAKEY3_KEY7:       equ    %10000000
mBAKEY3_KEY8:       equ    %100000000
mBAKEY3_KEY9:       equ    %1000000000
mBAKEY3_KEY10:      equ    %10000000000
mBAKEY3_KEY11:      equ    %100000000000
mBAKEY3_KEY12:      equ    %1000000000000
mBAKEY3_KEY13:      equ    %10000000000000
mBAKEY3_KEY14:      equ    %100000000000000
mBAKEY3_KEY15:      equ    %1000000000000000


;*** NVFPROT0 - Non volatile Block 0 Flash Protection Register; 0x0000FF0D ***
NVFPROT0:           equ    $0000FF0D                                ;*** NVFPROT0 - Non volatile Block 0 Flash Protection Register; 0x0000FF0D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NVFPROT0_FPLS0:     equ    0                                         ; Flash Protection Lower Address size 0
NVFPROT0_FPLS1:     equ    1                                         ; Flash Protection Lower Address size 1
NVFPROT0_FPLDIS:    equ    2                                         ; Flash Protection Lower address range disable
NVFPROT0_FPHS0:     equ    3                                         ; Flash Protection Higher address size 0
NVFPROT0_FPHS1:     equ    4                                         ; Flash Protection Higher address size 1
NVFPROT0_FPHDIS:    equ    5                                         ; Flash Protection Higher address range disable
NVFPROT0_NV6:       equ    6                                         ; Non Volatile Flag Bit
NVFPROT0_FPOPEN:    equ    7                                         ; Opens the flash block or subsections of it for program or erase
; bit position masks
mNVFPROT0_FPLS0:    equ    %00000001
mNVFPROT0_FPLS1:    equ    %00000010
mNVFPROT0_FPLDIS:   equ    %00000100
mNVFPROT0_FPHS0:    equ    %00001000
mNVFPROT0_FPHS1:    equ    %00010000
mNVFPROT0_FPHDIS:   equ    %00100000
mNVFPROT0_NV6:      equ    %01000000
mNVFPROT0_FPOPEN:   equ    %10000000


;*** NVFSEC - Non volatile Flash Security Register; 0x0000FF0F ***
NVFSEC:             equ    $0000FF0F                                ;*** NVFSEC - Non volatile Flash Security Register; 0x0000FF0F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NVFSEC_SEC0:        equ    0                                         ; Memory security bit 0
NVFSEC_SEC1:        equ    1                                         ; Memory security bit 1
NVFSEC_NV2:         equ    2                                         ; Non Volatile flag bit 2
NVFSEC_NV3:         equ    3                                         ; Non Volatile flag bit 3
NVFSEC_NV4:         equ    4                                         ; Non Volatile flag bit 4
NVFSEC_NV5:         equ    5                                         ; Non Volatile flag bit 5
NVFSEC_NV6:         equ    6                                         ; Non Volatile flag bit 6
NVFSEC_KEYEN:       equ    7                                         ; Backdoor Key Security Enable
; bit position masks
mNVFSEC_SEC0:       equ    %00000001
mNVFSEC_SEC1:       equ    %00000010
mNVFSEC_NV2:        equ    %00000100
mNVFSEC_NV3:        equ    %00001000
mNVFSEC_NV4:        equ    %00010000
mNVFSEC_NV5:        equ    %00100000
mNVFSEC_NV6:        equ    %01000000
mNVFSEC_KEYEN:      equ    %10000000



;***********************************************
;**   D E P R E C I A T E D   S Y M B O L S   **
;***********************************************
        IFNDEF  __GENERATE_APPLICATION__                            ; not supported for absolute assembler
                    XREF    This_symb_has_been_depreciated
        ENDIF
; ---------------------------------------------------------------------------
; The following symbols were removed, because they were invalid or irrelevant
; ---------------------------------------------------------------------------

; EOF
