; Based on CPU DB MC9S12NE64_112, version 2.87.130 (RegistersPrg V2.28)

; ###################################################################
;     Filename  : mc9s12ne64.inc
;     Processor : MC9S12NE64CPV
;     FileFormat: V2.28
;     DataSheet : MC9S12NE64V1 Rev. 1.1 06/2006
;     Compiler  : CodeWarrior compiler
;     Date/Time : 2.7.2009, 8:41
;     Abstract  :
;         This header implements the mapping of I/O devices.
;
;     Copyright : 1997 - 2009 Freescale Semiconductor, Inc. All Rights Reserved.
;     
;     http      : www.freescale.com
;     mail      : support@freescale.com
;
;     CPU Registers Revisions:
;      - 20.07.2006, V2.87.104:
;              - Renamed registers TCNTL ==> TCNTLo, TCxL ==> TCxLo.  REASON: Bug-fix (#3520 in Issue Manager)
;      - 18.07.2007, V2.87.122:
;              - Removed register ATDSTAT2,  Added registers ATDCTL0/1, ATDTEST1. Changes in data sheet (from rev 1.04 to rev 1.1)
;
;     File-Format-Revisions:
;      - 14.11.2005, V2.00 :
;               - Deprecated symbols added for backward compatibility (section at the end of this file)
;      - 15.11.2005, V2.01 :
;               - Fixed invalid instruction in macro __RESET_WATCHDOG for HCS12 family.
;      - 17.12.2005, V2.02 :
;               - Arrays (symbols xx_ARR) are defined as pointer to volatile, see issue #2778
;      - 16.01.2006, V2.03 :
;               - Fixed declaration of non volatile registers. Now it does not require (but allows) their initialization, see issue #2920.
;               - "volatile" modifier removed from declaration of non volatile registers (that contain modifier "const")
;      - 08.03.2006, V2.04 :
;               - Support for bit(s) names duplicated with any register name in .h header files
;      - 24.03.2006, V2.05 :
;               - Fixed macro __RESET_WATCHDOG for HCS12 family - address and correct write order.
;      - 26.04.2006, V2.06 :
;               - Changes have not affected this file (because they are related to another family)
;      - 27.04.2006, V2.07 :
;               - Fixed macro __RESET_WATCHDOG for HCS12, HCS12X ,HCS08 DZ and HCS08 EN derivatives (write 0x55,0xAA).
;      - 07.06.2006, V2.08 :
;               - Changes have not affected this file (because they are related to another family)
;      - 03.07.2006, V2.09 :
;               - Changes have not affected this file (because they are related to another family)
;      - 27.10.2006, V2.10 :
;               - __RESET_WATCHDOG improved formating and re-definition
;      - 23.11.2006, V2.11 :
;               - Changes have not affected this file (because they are related to another family)
;      - 22.01.2007, V2.12 :
;               - Fixed declaration of non volatile registers. Now it does not require (but allows) their initialization, see issue #4086.
;      - 01.03.2007, V2.13 :
;               - Flash commands constants values converted to HEX format
;      - 02.03.2007, V2.14 :
;               - Interrupt vector numbers added into .H, see VectorNumber_*
;      - 26.03.2007, V2.15 :
;               - Changes have not affected this file (because they are related to another family)
;      - 10.05.2007, V2.16 :
;               - Changes have not affected this file (because they are related to another family)
;      - 05.06.2007, V2.17 :
;               - Changes have not affected this file (because they are related to another family)
;      - 19.07.2007, V2.18 :
;               - Improved number of blanked lines inside register structures
;      - 06.08.2007, V2.19 :
;               - CPUDB revisions generated ahead of the file-format revisions.
;      - 11.09.2007, V2.20 :
;               - Added comment about initialization of unbonded pins.
;      - 02.01.2008, V2.21 :
;               - Changes have not affected this file (because they are related to another family)
;      - 13.02.2008, V2.22 :
;               - Changes have not affected this file (because they are related to another family)
;      - 20.02.2008, V2.23 :
;               - Termination of pragma V30toV31Compatible added, #5708
;      - 03.07.2008, V2.24 :
;               - Added support for bits with name starting with number (like "1HZ")
;      - 28.11.2008, V2.25 :
;               - StandBy RAM array declaration for ANSI-C added
;      - 1.12.2008, V2.26 :
;               - Duplication of bit (or bit-group) name with register name is not marked as a problem, is register is internal only and it is not displayed in I/O map.
;      - 17.3.2009, V2.27 :
;               - Merged bit-group is not generated, if the name matches with another bit name in the register
;      - 6.4.2009, V2.28 :
;               - Fixed generation of merged bits for bit-groups with a digit at the end, if group-name is defined in CPUDB
;
;     Not all general-purpose I/O pins are available on all packages or on all mask sets of a specific
;     derivative device. To avoid extra current drain from floating input pins, the users reset
;     initialization routine in the application program must either enable on-chip pull-up devices
;     or change the direction of unconnected pins to outputs so the pins do not float.
; ###################################################################

;*** Memory Map and Interrupt Vectors
;******************************************
RAMStart:           equ   $00000400
RAMEnd:             equ   $00001FFF
ROM_4000Start:      equ   $00004000
ROM_4000End:        equ   $00007FFF
ROM_C000Start:      equ   $0000C000
ROM_C000End:        equ   $0000FEFF
PAGE_3CStart:       equ   $003C8000
PAGE_3CEnd:         equ   $003CBFFF
PAGE_3DStart:       equ   $003D8000
PAGE_3DEnd:         equ   $003DBFFF
;
VReserved63:        equ   $0000FF80
VReserved62:        equ   $0000FF82
VReserved61:        equ   $0000FF84
VReserved60:        equ   $0000FF86
VReserved59:        equ   $0000FF88
VReserved58:        equ   $0000FF8A
VReserved57:        equ   $0000FF8C
VReserved56:        equ   $0000FF8E
VReserved55:        equ   $0000FF90
VReserved54:        equ   $0000FF92
VReserved53:        equ   $0000FF94
VReserved52:        equ   $0000FF96
VReserved51:        equ   $0000FF98
VReserved50:        equ   $0000FF9A
VReserved49:        equ   $0000FF9C
VReserved48:        equ   $0000FF9E
Vemacec:            equ   $0000FFA0
Vemaclc:            equ   $0000FFA2
Vemacbrxerr:        equ   $0000FFA4
Vemacrxbbo:         equ   $0000FFA6
Vemacrxbao:         equ   $0000FFA8
Vemacrxerr:         equ   $0000FFAA
Vemacmii:           equ   $0000FFAC
Vemacrxfc:          equ   $0000FFAE
Vemactxc:           equ   $0000FFB0
Vemacrxbbc:         equ   $0000FFB2
Vemacrxbac:         equ   $0000FFB4
Vephy:              equ   $0000FFB6
Vflash:             equ   $0000FFB8
VReserved34:        equ   $0000FFBA
VReserved33:        equ   $0000FFBC
VReserved32:        equ   $0000FFBE
Viic:               equ   $0000FFC0
VReserved30:        equ   $0000FFC2
Vcrgscm:            equ   $0000FFC4
Vcrgplllck:         equ   $0000FFC6
VReserved27:        equ   $0000FFC8
Vportg:             equ   $0000FFCA
Vporth:             equ   $0000FFCC
Vportj:             equ   $0000FFCE
VReserved23:        equ   $0000FFD0
Vatd:               equ   $0000FFD2
Vsci1:              equ   $0000FFD4
Vsci0:              equ   $0000FFD6
Vspi:               equ   $0000FFD8
Vtimpaie:           equ   $0000FFDA
Vtimpaovf:          equ   $0000FFDC
Vtimovf:            equ   $0000FFDE
Vtimch7:            equ   $0000FFE0
Vtimch6:            equ   $0000FFE2
Vtimch5:            equ   $0000FFE4
Vtimch4:            equ   $0000FFE6
VReserved11:        equ   $0000FFE8
VReserved10:        equ   $0000FFEA
VReserved9:         equ   $0000FFEC
VReserved8:         equ   $0000FFEE
Vrti:               equ   $0000FFF0
Virq:               equ   $0000FFF2
Vxirq:              equ   $0000FFF4
Vswi:               equ   $0000FFF6
Vtrap:              equ   $0000FFF8
Vcop:               equ   $0000FFFA
Vclkmon:            equ   $0000FFFC
Vreset:             equ   $0000FFFE
;


;*** PORTAB - Port AB Register; 0x00000000 ***
PORTAB:             equ    $00000000                                ;*** PORTAB - Port AB Register; 0x00000000 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PORTAB_BIT0:        equ    0                                         ; Port AB Bit 0
PORTAB_BIT1:        equ    1                                         ; Port AB Bit 1
PORTAB_BIT2:        equ    2                                         ; Port AB Bit 2
PORTAB_BIT3:        equ    3                                         ; Port AB Bit 3
PORTAB_BIT4:        equ    4                                         ; Port AB Bit 4
PORTAB_BIT5:        equ    5                                         ; Port AB Bit 5
PORTAB_BIT6:        equ    6                                         ; Port AB Bit 6
PORTAB_BIT7:        equ    7                                         ; Port AB Bit 7
PORTAB_BIT8:        equ    8                                         ; Port AB Bit 8
PORTAB_BIT9:        equ    9                                         ; Port AB Bit 9
PORTAB_BIT10:       equ    10                                        ; Port AB Bit 10
PORTAB_BIT11:       equ    11                                        ; Port AB Bit 11
PORTAB_BIT12:       equ    12                                        ; Port AB Bit 12
PORTAB_BIT13:       equ    13                                        ; Port AB Bit 13
PORTAB_BIT14:       equ    14                                        ; Port AB Bit 14
PORTAB_BIT15:       equ    15                                        ; Port AB Bit 15
; bit position masks
mPORTAB_BIT0:       equ    %00000001
mPORTAB_BIT1:       equ    %00000010
mPORTAB_BIT2:       equ    %00000100
mPORTAB_BIT3:       equ    %00001000
mPORTAB_BIT4:       equ    %00010000
mPORTAB_BIT5:       equ    %00100000
mPORTAB_BIT6:       equ    %01000000
mPORTAB_BIT7:       equ    %10000000
mPORTAB_BIT8:       equ    %100000000
mPORTAB_BIT9:       equ    %1000000000
mPORTAB_BIT10:      equ    %10000000000
mPORTAB_BIT11:      equ    %100000000000
mPORTAB_BIT12:      equ    %1000000000000
mPORTAB_BIT13:      equ    %10000000000000
mPORTAB_BIT14:      equ    %100000000000000
mPORTAB_BIT15:      equ    %1000000000000000


;*** PORTA - Port A Register; 0x00000000 ***
PORTA:              equ    $00000000                                ;*** PORTA - Port A Register; 0x00000000 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PORTA_BIT0:         equ    0                                         ; Port A Bit 0
PORTA_BIT1:         equ    1                                         ; Port A Bit 1
PORTA_BIT2:         equ    2                                         ; Port A Bit 2
PORTA_BIT3:         equ    3                                         ; Port A Bit 3
PORTA_BIT4:         equ    4                                         ; Port A Bit 4
PORTA_BIT5:         equ    5                                         ; Port A Bit 5
PORTA_BIT6:         equ    6                                         ; Port A Bit 6
PORTA_BIT7:         equ    7                                         ; Port A Bit 7
; bit position masks
mPORTA_BIT0:        equ    %00000001
mPORTA_BIT1:        equ    %00000010
mPORTA_BIT2:        equ    %00000100
mPORTA_BIT3:        equ    %00001000
mPORTA_BIT4:        equ    %00010000
mPORTA_BIT5:        equ    %00100000
mPORTA_BIT6:        equ    %01000000
mPORTA_BIT7:        equ    %10000000


;*** PORTB - Port B Register; 0x00000001 ***
PORTB:              equ    $00000001                                ;*** PORTB - Port B Register; 0x00000001 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PORTB_BIT0:         equ    0                                         ; Port B Bit 0
PORTB_BIT1:         equ    1                                         ; Port B Bit 1
PORTB_BIT2:         equ    2                                         ; Port B Bit 2
PORTB_BIT3:         equ    3                                         ; Port B Bit 3
PORTB_BIT4:         equ    4                                         ; Port B Bit 4
PORTB_BIT5:         equ    5                                         ; Port B Bit 5
PORTB_BIT6:         equ    6                                         ; Port B Bit 6
PORTB_BIT7:         equ    7                                         ; Port B Bit 7
; bit position masks
mPORTB_BIT0:        equ    %00000001
mPORTB_BIT1:        equ    %00000010
mPORTB_BIT2:        equ    %00000100
mPORTB_BIT3:        equ    %00001000
mPORTB_BIT4:        equ    %00010000
mPORTB_BIT5:        equ    %00100000
mPORTB_BIT6:        equ    %01000000
mPORTB_BIT7:        equ    %10000000


;*** DDRAB - Port AB Data Direction Register; 0x00000002 ***
DDRAB:              equ    $00000002                                ;*** DDRAB - Port AB Data Direction Register; 0x00000002 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRAB_BIT0:         equ    0                                         ; Data Direction Port AB Bit 0
DDRAB_BIT1:         equ    1                                         ; Data Direction Port AB Bit 1
DDRAB_BIT2:         equ    2                                         ; Data Direction Port AB Bit 2
DDRAB_BIT3:         equ    3                                         ; Data Direction Port AB Bit 3
DDRAB_BIT4:         equ    4                                         ; Data Direction Port AB Bit 4
DDRAB_BIT5:         equ    5                                         ; Data Direction Port AB Bit 5
DDRAB_BIT6:         equ    6                                         ; Data Direction Port AB Bit 6
DDRAB_BIT7:         equ    7                                         ; Data Direction Port AB Bit 7
DDRAB_BIT8:         equ    8                                         ; Data Direction Port AB Bit 8
DDRAB_BIT9:         equ    9                                         ; Data Direction Port AB Bit 9
DDRAB_BIT10:        equ    10                                        ; Data Direction Port AB Bit 10
DDRAB_BIT11:        equ    11                                        ; Data Direction Port AB Bit 11
DDRAB_BIT12:        equ    12                                        ; Data Direction Port AB Bit 12
DDRAB_BIT13:        equ    13                                        ; Data Direction Port AB Bit 13
DDRAB_BIT14:        equ    14                                        ; Data Direction Port AB Bit 14
DDRAB_BIT15:        equ    15                                        ; Data Direction Port AB Bit 15
; bit position masks
mDDRAB_BIT0:        equ    %00000001
mDDRAB_BIT1:        equ    %00000010
mDDRAB_BIT2:        equ    %00000100
mDDRAB_BIT3:        equ    %00001000
mDDRAB_BIT4:        equ    %00010000
mDDRAB_BIT5:        equ    %00100000
mDDRAB_BIT6:        equ    %01000000
mDDRAB_BIT7:        equ    %10000000
mDDRAB_BIT8:        equ    %100000000
mDDRAB_BIT9:        equ    %1000000000
mDDRAB_BIT10:       equ    %10000000000
mDDRAB_BIT11:       equ    %100000000000
mDDRAB_BIT12:       equ    %1000000000000
mDDRAB_BIT13:       equ    %10000000000000
mDDRAB_BIT14:       equ    %100000000000000
mDDRAB_BIT15:       equ    %1000000000000000


;*** DDRA - Port A Data Direction Register; 0x00000002 ***
DDRA:               equ    $00000002                                ;*** DDRA - Port A Data Direction Register; 0x00000002 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRA_BIT0:          equ    0                                         ; Data Direction Port A Bit 0
DDRA_BIT1:          equ    1                                         ; Data Direction Port A Bit 1
DDRA_BIT2:          equ    2                                         ; Data Direction Port A Bit 2
DDRA_BIT3:          equ    3                                         ; Data Direction Port A Bit 3
DDRA_BIT4:          equ    4                                         ; Data Direction Port A Bit 4
DDRA_BIT5:          equ    5                                         ; Data Direction Port A Bit 5
DDRA_BIT6:          equ    6                                         ; Data Direction Port A Bit 6
DDRA_BIT7:          equ    7                                         ; Data Direction Port A Bit 7
; bit position masks
mDDRA_BIT0:         equ    %00000001
mDDRA_BIT1:         equ    %00000010
mDDRA_BIT2:         equ    %00000100
mDDRA_BIT3:         equ    %00001000
mDDRA_BIT4:         equ    %00010000
mDDRA_BIT5:         equ    %00100000
mDDRA_BIT6:         equ    %01000000
mDDRA_BIT7:         equ    %10000000


;*** DDRB - Port B Data Direction Register; 0x00000003 ***
DDRB:               equ    $00000003                                ;*** DDRB - Port B Data Direction Register; 0x00000003 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRB_BIT0:          equ    0                                         ; Data Direction Port B Bit 0
DDRB_BIT1:          equ    1                                         ; Data Direction Port B Bit 1
DDRB_BIT2:          equ    2                                         ; Data Direction Port B Bit 2
DDRB_BIT3:          equ    3                                         ; Data Direction Port B Bit 3
DDRB_BIT4:          equ    4                                         ; Data Direction Port B Bit 4
DDRB_BIT5:          equ    5                                         ; Data Direction Port B Bit 5
DDRB_BIT6:          equ    6                                         ; Data Direction Port B Bit 6
DDRB_BIT7:          equ    7                                         ; Data Direction Port B Bit 7
; bit position masks
mDDRB_BIT0:         equ    %00000001
mDDRB_BIT1:         equ    %00000010
mDDRB_BIT2:         equ    %00000100
mDDRB_BIT3:         equ    %00001000
mDDRB_BIT4:         equ    %00010000
mDDRB_BIT5:         equ    %00100000
mDDRB_BIT6:         equ    %01000000
mDDRB_BIT7:         equ    %10000000


;*** PORTE - Port E Register; 0x00000008 ***
PORTE:              equ    $00000008                                ;*** PORTE - Port E Register; 0x00000008 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PORTE_BIT0:         equ    0                                         ; Port E Bit 0
PORTE_BIT1:         equ    1                                         ; Port E Bit 1
PORTE_BIT2:         equ    2                                         ; Port E Bit 2
PORTE_BIT3:         equ    3                                         ; Port E Bit 3
PORTE_BIT4:         equ    4                                         ; Port E Bit 4
PORTE_BIT5:         equ    5                                         ; Port E Bit 5
PORTE_BIT6:         equ    6                                         ; Port E Bit 6
PORTE_BIT7:         equ    7                                         ; Port E Bit 7
; bit position masks
mPORTE_BIT0:        equ    %00000001
mPORTE_BIT1:        equ    %00000010
mPORTE_BIT2:        equ    %00000100
mPORTE_BIT3:        equ    %00001000
mPORTE_BIT4:        equ    %00010000
mPORTE_BIT5:        equ    %00100000
mPORTE_BIT6:        equ    %01000000
mPORTE_BIT7:        equ    %10000000


;*** DDRE - Port E Data Direction Register; 0x00000009 ***
DDRE:               equ    $00000009                                ;*** DDRE - Port E Data Direction Register; 0x00000009 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRE_BIT2:          equ    2                                         ; Data Direction Port E Bit 2
DDRE_BIT3:          equ    3                                         ; Data Direction Port E Bit 3
DDRE_BIT4:          equ    4                                         ; Data Direction Port E Bit 4
DDRE_BIT5:          equ    5                                         ; Data Direction Port E Bit 5
DDRE_BIT6:          equ    6                                         ; Data Direction Port E Bit 6
DDRE_BIT7:          equ    7                                         ; Data Direction Port E Bit 7
; bit position masks
mDDRE_BIT2:         equ    %00000100
mDDRE_BIT3:         equ    %00001000
mDDRE_BIT4:         equ    %00010000
mDDRE_BIT5:         equ    %00100000
mDDRE_BIT6:         equ    %01000000
mDDRE_BIT7:         equ    %10000000


;*** PEAR - Port E Assignment Register; 0x0000000A ***
PEAR:               equ    $0000000A                                ;*** PEAR - Port E Assignment Register; 0x0000000A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PEAR_RDWE:          equ    2                                         ; Read / Write Enable
PEAR_LSTRE:         equ    3                                         ; Low Strobe (LSTRB) Enable
PEAR_NECLK:         equ    4                                         ; No External E Clock
PEAR_PIPOE:         equ    5                                         ; Pipe Status Signal Output Enable
PEAR_NOACCE:        equ    7                                         ; CPU No Access Output Enable
; bit position masks
mPEAR_RDWE:         equ    %00000100
mPEAR_LSTRE:        equ    %00001000
mPEAR_NECLK:        equ    %00010000
mPEAR_PIPOE:        equ    %00100000
mPEAR_NOACCE:       equ    %10000000


;*** MODE - Mode Register; 0x0000000B ***
MODE:               equ    $0000000B                                ;*** MODE - Mode Register; 0x0000000B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MODE_EME:           equ    0                                         ; Emulate Port E
MODE_EMK:           equ    1                                         ; Emulate Port K
MODE_IVIS:          equ    3                                         ; Internal Visibility
MODE_MODA:          equ    5                                         ; Mode Select Bit A
MODE_MODB:          equ    6                                         ; Mode Select Bit B
MODE_MODC:          equ    7                                         ; Mode Select Bit C
; bit position masks
mMODE_EME:          equ    %00000001
mMODE_EMK:          equ    %00000010
mMODE_IVIS:         equ    %00001000
mMODE_MODA:         equ    %00100000
mMODE_MODB:         equ    %01000000
mMODE_MODC:         equ    %10000000


;*** PUCR - Pull-Up Control Register; 0x0000000C ***
PUCR:               equ    $0000000C                                ;*** PUCR - Pull-Up Control Register; 0x0000000C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PUCR_PUPAE:         equ    0                                         ; Pull-Up Port A Enable
PUCR_PUPBE:         equ    1                                         ; Pull-Up Port B Enable
PUCR_PUPEE:         equ    4                                         ; Pull-Up Port E Enable
PUCR_PUPKE:         equ    7                                         ; Pull-Up Port K Enable
; bit position masks
mPUCR_PUPAE:        equ    %00000001
mPUCR_PUPBE:        equ    %00000010
mPUCR_PUPEE:        equ    %00010000
mPUCR_PUPKE:        equ    %10000000


;*** RDRIV - Reduced Drive of I/O Lines; 0x0000000D ***
RDRIV:              equ    $0000000D                                ;*** RDRIV - Reduced Drive of I/O Lines; 0x0000000D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RDRIV_RDPA:         equ    0                                         ; Reduced Drive of Port A
RDRIV_RDPB:         equ    1                                         ; Reduced Drive of Port B
RDRIV_RDPE:         equ    4                                         ; Reduced Drive of Port E
RDRIV_RDPK:         equ    7                                         ; Reduced Drive of Port K
; bit position masks
mRDRIV_RDPA:        equ    %00000001
mRDRIV_RDPB:        equ    %00000010
mRDRIV_RDPE:        equ    %00010000
mRDRIV_RDPK:        equ    %10000000


;*** EBICTL - External Bus Interface Control; 0x0000000E ***
EBICTL:             equ    $0000000E                                ;*** EBICTL - External Bus Interface Control; 0x0000000E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
EBICTL_ESTR:        equ    0                                         ; E Stretches
; bit position masks
mEBICTL_ESTR:       equ    %00000001


;*** INITRM - Initialization of Internal RAM Position Register; 0x00000010 ***
INITRM:             equ    $00000010                                ;*** INITRM - Initialization of Internal RAM Position Register; 0x00000010 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
INITRM_RAMHAL:      equ    0                                         ; Internal RAM map alignment
INITRM_RAM11:       equ    3                                         ; Internal RAM map position Bit 11
INITRM_RAM12:       equ    4                                         ; Internal RAM map position Bit 12
INITRM_RAM13:       equ    5                                         ; Internal RAM map position Bit 13
INITRM_RAM14:       equ    6                                         ; Internal RAM map position Bit 14
INITRM_RAM15:       equ    7                                         ; Internal RAM map position Bit 15
; bit position masks
mINITRM_RAMHAL:     equ    %00000001
mINITRM_RAM11:      equ    %00001000
mINITRM_RAM12:      equ    %00010000
mINITRM_RAM13:      equ    %00100000
mINITRM_RAM14:      equ    %01000000
mINITRM_RAM15:      equ    %10000000


;*** INITRG - Initialization of Internal Registers Position Register; 0x00000011 ***
INITRG:             equ    $00000011                                ;*** INITRG - Initialization of Internal Registers Position Register; 0x00000011 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
INITRG_REG11:       equ    3                                         ; Internal Registers Map Position Bit 11
INITRG_REG12:       equ    4                                         ; Internal Registers Map Position Bit 12
INITRG_REG13:       equ    5                                         ; Internal Registers Map Position Bit 13
INITRG_REG14:       equ    6                                         ; Internal Registers Map Position Bit 14
; bit position masks
mINITRG_REG11:      equ    %00001000
mINITRG_REG12:      equ    %00010000
mINITRG_REG13:      equ    %00100000
mINITRG_REG14:      equ    %01000000


;*** MISC - Miscellaneous System Control Register; 0x00000013 ***
MISC:               equ    $00000013                                ;*** MISC - Miscellaneous System Control Register; 0x00000013 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MISC_ROMON:         equ    0                                         ; Enable Flash EEPROM
MISC_ROMHM:         equ    1                                         ; Flash EEPROM only in second half of memory map
MISC_EXSTR0:        equ    2                                         ; External Access Stretch Bit 0
MISC_EXSTR1:        equ    3                                         ; External Access Stretch Bit 1
; bit position masks
mMISC_ROMON:        equ    %00000001
mMISC_ROMHM:        equ    %00000010
mMISC_EXSTR0:       equ    %00000100
mMISC_EXSTR1:       equ    %00001000


;*** ITCR - Interrupt Test Control Register; 0x00000015 ***
ITCR:               equ    $00000015                                ;*** ITCR - Interrupt Test Control Register; 0x00000015 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ITCR_ADR0:          equ    0                                         ; Test register select Bit 0
ITCR_ADR1:          equ    1                                         ; Test register select Bit 1
ITCR_ADR2:          equ    2                                         ; Test register select Bit 2
ITCR_ADR3:          equ    3                                         ; Test register select Bit 3
ITCR_WRTINT:        equ    4                                         ; Write to the Interrupt Test Registers
; bit position masks
mITCR_ADR0:         equ    %00000001
mITCR_ADR1:         equ    %00000010
mITCR_ADR2:         equ    %00000100
mITCR_ADR3:         equ    %00001000
mITCR_WRTINT:       equ    %00010000


;*** ITEST - Interrupt Test Register; 0x00000016 ***
ITEST:              equ    $00000016                                ;*** ITEST - Interrupt Test Register; 0x00000016 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ITEST_INT0:         equ    0                                         ; Interrupt Test Register Bit 0
ITEST_INT2:         equ    1                                         ; Interrupt Test Register Bit 1
ITEST_INT4:         equ    2                                         ; Interrupt Test Register Bit 2
ITEST_INT6:         equ    3                                         ; Interrupt Test Register Bit 3
ITEST_INT8:         equ    4                                         ; Interrupt Test Register Bit 4
ITEST_INTA:         equ    5                                         ; Interrupt Test Register Bit 5
ITEST_INTC:         equ    6                                         ; Interrupt Test Register Bit 6
ITEST_INTE:         equ    7                                         ; Interrupt Test Register Bit 7
; bit position masks
mITEST_INT0:        equ    %00000001
mITEST_INT2:        equ    %00000010
mITEST_INT4:        equ    %00000100
mITEST_INT6:        equ    %00001000
mITEST_INT8:        equ    %00010000
mITEST_INTA:        equ    %00100000
mITEST_INTC:        equ    %01000000
mITEST_INTE:        equ    %10000000


;*** PARTID - Part ID Register; 0x0000001A ***
PARTID:             equ    $0000001A                                ;*** PARTID - Part ID Register; 0x0000001A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PARTID_ID0:         equ    0                                         ; Part ID Register Bit 0
PARTID_ID1:         equ    1                                         ; Part ID Register Bit 1
PARTID_ID2:         equ    2                                         ; Part ID Register Bit 2
PARTID_ID3:         equ    3                                         ; Part ID Register Bit 3
PARTID_ID4:         equ    4                                         ; Part ID Register Bit 4
PARTID_ID5:         equ    5                                         ; Part ID Register Bit 5
PARTID_ID6:         equ    6                                         ; Part ID Register Bit 6
PARTID_ID7:         equ    7                                         ; Part ID Register Bit 7
PARTID_ID8:         equ    8                                         ; Part ID Register Bit 8
PARTID_ID9:         equ    9                                         ; Part ID Register Bit 9
PARTID_ID10:        equ    10                                        ; Part ID Register Bit 10
PARTID_ID11:        equ    11                                        ; Part ID Register Bit 11
PARTID_ID12:        equ    12                                        ; Part ID Register Bit 12
PARTID_ID13:        equ    13                                        ; Part ID Register Bit 13
PARTID_ID14:        equ    14                                        ; Part ID Register Bit 14
PARTID_ID15:        equ    15                                        ; Part ID Register Bit 15
; bit position masks
mPARTID_ID0:        equ    %00000001
mPARTID_ID1:        equ    %00000010
mPARTID_ID2:        equ    %00000100
mPARTID_ID3:        equ    %00001000
mPARTID_ID4:        equ    %00010000
mPARTID_ID5:        equ    %00100000
mPARTID_ID6:        equ    %01000000
mPARTID_ID7:        equ    %10000000
mPARTID_ID8:        equ    %100000000
mPARTID_ID9:        equ    %1000000000
mPARTID_ID10:       equ    %10000000000
mPARTID_ID11:       equ    %100000000000
mPARTID_ID12:       equ    %1000000000000
mPARTID_ID13:       equ    %10000000000000
mPARTID_ID14:       equ    %100000000000000
mPARTID_ID15:       equ    %1000000000000000


;*** PARTIDH - Part ID Register High; 0x0000001A ***
PARTIDH:            equ    $0000001A                                ;*** PARTIDH - Part ID Register High; 0x0000001A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PARTIDH_ID8:        equ    0                                         ; Part ID Register Bit 8
PARTIDH_ID9:        equ    1                                         ; Part ID Register Bit 9
PARTIDH_ID10:       equ    2                                         ; Part ID Register Bit 10
PARTIDH_ID11:       equ    3                                         ; Part ID Register Bit 11
PARTIDH_ID12:       equ    4                                         ; Part ID Register Bit 12
PARTIDH_ID13:       equ    5                                         ; Part ID Register Bit 13
PARTIDH_ID14:       equ    6                                         ; Part ID Register Bit 14
PARTIDH_ID15:       equ    7                                         ; Part ID Register Bit 15
; bit position masks
mPARTIDH_ID8:       equ    %00000001
mPARTIDH_ID9:       equ    %00000010
mPARTIDH_ID10:      equ    %00000100
mPARTIDH_ID11:      equ    %00001000
mPARTIDH_ID12:      equ    %00010000
mPARTIDH_ID13:      equ    %00100000
mPARTIDH_ID14:      equ    %01000000
mPARTIDH_ID15:      equ    %10000000


;*** PARTIDL - Part ID Register Low; 0x0000001B ***
PARTIDL:            equ    $0000001B                                ;*** PARTIDL - Part ID Register Low; 0x0000001B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PARTIDL_ID0:        equ    0                                         ; Part ID Register Bit 0
PARTIDL_ID1:        equ    1                                         ; Part ID Register Bit 1
PARTIDL_ID2:        equ    2                                         ; Part ID Register Bit 2
PARTIDL_ID3:        equ    3                                         ; Part ID Register Bit 3
PARTIDL_ID4:        equ    4                                         ; Part ID Register Bit 4
PARTIDL_ID5:        equ    5                                         ; Part ID Register Bit 5
PARTIDL_ID6:        equ    6                                         ; Part ID Register Bit 6
PARTIDL_ID7:        equ    7                                         ; Part ID Register Bit 7
; bit position masks
mPARTIDL_ID0:       equ    %00000001
mPARTIDL_ID1:       equ    %00000010
mPARTIDL_ID2:       equ    %00000100
mPARTIDL_ID3:       equ    %00001000
mPARTIDL_ID4:       equ    %00010000
mPARTIDL_ID5:       equ    %00100000
mPARTIDL_ID6:       equ    %01000000
mPARTIDL_ID7:       equ    %10000000


;*** MEMSIZ0 - Memory Size Register Zero; 0x0000001C ***
MEMSIZ0:            equ    $0000001C                                ;*** MEMSIZ0 - Memory Size Register Zero; 0x0000001C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MEMSIZ0_ram_sw0:    equ    0                                         ; Allocated System RAM Memory Space Bit 0
MEMSIZ0_ram_sw1:    equ    1                                         ; Allocated System RAM Memory Space Bit 1
MEMSIZ0_ram_sw2:    equ    2                                         ; Allocated System RAM Memory Space Bit 2
MEMSIZ0_eep_sw0:    equ    4                                         ; Allocated EEPROM Memory Space Bit 0
MEMSIZ0_eep_sw1:    equ    5                                         ; Allocated EEPROM Memory Space Bit 1
MEMSIZ0_reg_sw0:    equ    7                                         ; Allocated System Register Space
; bit position masks
mMEMSIZ0_ram_sw0:   equ    %00000001
mMEMSIZ0_ram_sw1:   equ    %00000010
mMEMSIZ0_ram_sw2:   equ    %00000100
mMEMSIZ0_eep_sw0:   equ    %00010000
mMEMSIZ0_eep_sw1:   equ    %00100000
mMEMSIZ0_reg_sw0:   equ    %10000000


;*** MEMSIZ1 - Memory Size Register One; 0x0000001D ***
MEMSIZ1:            equ    $0000001D                                ;*** MEMSIZ1 - Memory Size Register One; 0x0000001D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MEMSIZ1_pag_sw0:    equ    0                                         ; Allocated Off-Chip Memory Options Bit 0
MEMSIZ1_pag_sw1:    equ    1                                         ; Allocated Off-Chip Memory Options Bit 1
MEMSIZ1_rom_sw0:    equ    6                                         ; Allocated Flash EEPROM/ROM Physical Memory Space Bit 0
MEMSIZ1_rom_sw1:    equ    7                                         ; Allocated Flash EEPROM/ROM Physical Memory Space Bit 1
; bit position masks
mMEMSIZ1_pag_sw0:   equ    %00000001
mMEMSIZ1_pag_sw1:   equ    %00000010
mMEMSIZ1_rom_sw0:   equ    %01000000
mMEMSIZ1_rom_sw1:   equ    %10000000


;*** INTCR - Interrupt Control Register; 0x0000001E ***
INTCR:              equ    $0000001E                                ;*** INTCR - Interrupt Control Register; 0x0000001E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
INTCR_IRQEN:        equ    6                                         ; External IRQ Enable
INTCR_IRQE:         equ    7                                         ; IRQ Select Edge Sensitive Only
; bit position masks
mINTCR_IRQEN:       equ    %01000000
mINTCR_IRQE:        equ    %10000000


;*** HPRIO - Highest Priority I Interrupt; 0x0000001F ***
HPRIO:              equ    $0000001F                                ;*** HPRIO - Highest Priority I Interrupt; 0x0000001F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
HPRIO_PSEL1:        equ    1                                         ; Highest Priority I Interrupt Bit 1
HPRIO_PSEL2:        equ    2                                         ; Highest Priority I Interrupt Bit 2
HPRIO_PSEL3:        equ    3                                         ; Highest Priority I Interrupt Bit 3
HPRIO_PSEL4:        equ    4                                         ; Highest Priority I Interrupt Bit 4
HPRIO_PSEL5:        equ    5                                         ; Highest Priority I Interrupt Bit 5
HPRIO_PSEL6:        equ    6                                         ; Highest Priority I Interrupt Bit 6
HPRIO_PSEL7:        equ    7                                         ; Highest Priority I Interrupt Bit 7
; bit position masks
mHPRIO_PSEL1:       equ    %00000010
mHPRIO_PSEL2:       equ    %00000100
mHPRIO_PSEL3:       equ    %00001000
mHPRIO_PSEL4:       equ    %00010000
mHPRIO_PSEL5:       equ    %00100000
mHPRIO_PSEL6:       equ    %01000000
mHPRIO_PSEL7:       equ    %10000000


;*** DBGC1 - Debug Control Register 1; 0x00000020 ***
DBGC1:              equ    $00000020                                ;*** DBGC1 - Debug Control Register 1; 0x00000020 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGC1_CAPMOD0:      equ    0                                         ; Capture Mode Field, bit 0
DBGC1_CAPMOD1:      equ    1                                         ; Capture Mode Field, bit 1
DBGC1_DBGBRK:       equ    3                                         ; DBG Breakpoint Enable Bit
DBGC1_BEGIN:        equ    4                                         ; Begin/End Trigger Bit
DBGC1_TRGSEL:       equ    5                                         ; Trigger Selection Bit
DBGC1_ARM:          equ    6                                         ; Arm Bit
DBGC1_DBGEN:        equ    7                                         ; DBG Mode Enable Bit
; bit position masks
mDBGC1_CAPMOD0:     equ    %00000001
mDBGC1_CAPMOD1:     equ    %00000010
mDBGC1_DBGBRK:      equ    %00001000
mDBGC1_BEGIN:       equ    %00010000
mDBGC1_TRGSEL:      equ    %00100000
mDBGC1_ARM:         equ    %01000000
mDBGC1_DBGEN:       equ    %10000000


;*** DBGSC - Debug Status and Control Register; 0x00000021 ***
DBGSC:              equ    $00000021                                ;*** DBGSC - Debug Status and Control Register; 0x00000021 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGSC_TRG0:         equ    0                                         ; Trigger Mode Bits, bit 0
DBGSC_TRG1:         equ    1                                         ; Trigger Mode Bits, bit 1
DBGSC_TRG2:         equ    2                                         ; Trigger Mode Bits, bit 2
DBGSC_TRG3:         equ    3                                         ; Trigger Mode Bits, bit 3
DBGSC_CF:           equ    5                                         ; Comparator C Match Flag
DBGSC_BF:           equ    6                                         ; Trigger B Match Flag
DBGSC_AF:           equ    7                                         ; Trigger A Match Flag
; bit position masks
mDBGSC_TRG0:        equ    %00000001
mDBGSC_TRG1:        equ    %00000010
mDBGSC_TRG2:        equ    %00000100
mDBGSC_TRG3:        equ    %00001000
mDBGSC_CF:          equ    %00100000
mDBGSC_BF:          equ    %01000000
mDBGSC_AF:          equ    %10000000


;*** DBGTB - Debug Trace Buffer Register; 0x00000022 ***
DBGTB:              equ    $00000022                                ;*** DBGTB - Debug Trace Buffer Register; 0x00000022 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGTB_BIT0:         equ    0                                         ; Trace Buffer Data Bit 0
DBGTB_BIT1:         equ    1                                         ; Trace Buffer Data Bit 1
DBGTB_BIT2:         equ    2                                         ; Trace Buffer Data Bit 2
DBGTB_BIT3:         equ    3                                         ; Trace Buffer Data Bit 3
DBGTB_BIT4:         equ    4                                         ; Trace Buffer Data Bit 4
DBGTB_BIT5:         equ    5                                         ; Trace Buffer Data Bit 5
DBGTB_BIT6:         equ    6                                         ; Trace Buffer Data Bit 6
DBGTB_BIT7:         equ    7                                         ; Trace Buffer Data Bit 7
DBGTB_BIT8:         equ    8                                         ; Trace Buffer Data Bit 8
DBGTB_BIT9:         equ    9                                         ; Trace Buffer Data Bit 9
DBGTB_BIT10:        equ    10                                        ; Trace Buffer Data Bit 10
DBGTB_BIT11:        equ    11                                        ; Trace Buffer Data Bit 11
DBGTB_BIT12:        equ    12                                        ; Trace Buffer Data Bit 12
DBGTB_BIT13:        equ    13                                        ; Trace Buffer Data Bit 13
DBGTB_BIT14:        equ    14                                        ; Trace Buffer Data Bit 14
DBGTB_BIT15:        equ    15                                        ; Trace Buffer Data Bit 15
; bit position masks
mDBGTB_BIT0:        equ    %00000001
mDBGTB_BIT1:        equ    %00000010
mDBGTB_BIT2:        equ    %00000100
mDBGTB_BIT3:        equ    %00001000
mDBGTB_BIT4:        equ    %00010000
mDBGTB_BIT5:        equ    %00100000
mDBGTB_BIT6:        equ    %01000000
mDBGTB_BIT7:        equ    %10000000
mDBGTB_BIT8:        equ    %100000000
mDBGTB_BIT9:        equ    %1000000000
mDBGTB_BIT10:       equ    %10000000000
mDBGTB_BIT11:       equ    %100000000000
mDBGTB_BIT12:       equ    %1000000000000
mDBGTB_BIT13:       equ    %10000000000000
mDBGTB_BIT14:       equ    %100000000000000
mDBGTB_BIT15:       equ    %1000000000000000


;*** DBGTBH - Debug Trace Buffer Register High; 0x00000022 ***
DBGTBH:             equ    $00000022                                ;*** DBGTBH - Debug Trace Buffer Register High; 0x00000022 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGTBH_BIT8:        equ    0                                         ; Trace Buffer Data Bit 8
DBGTBH_BIT9:        equ    1                                         ; Trace Buffer Data Bit 9
DBGTBH_BIT10:       equ    2                                         ; Trace Buffer Data Bit 10
DBGTBH_BIT11:       equ    3                                         ; Trace Buffer Data Bit 11
DBGTBH_BIT12:       equ    4                                         ; Trace Buffer Data Bit 12
DBGTBH_BIT13:       equ    5                                         ; Trace Buffer Data Bit 13
DBGTBH_BIT14:       equ    6                                         ; Trace Buffer Data Bit 14
DBGTBH_BIT15:       equ    7                                         ; Trace Buffer Data Bit 15
; bit position masks
mDBGTBH_BIT8:       equ    %00000001
mDBGTBH_BIT9:       equ    %00000010
mDBGTBH_BIT10:      equ    %00000100
mDBGTBH_BIT11:      equ    %00001000
mDBGTBH_BIT12:      equ    %00010000
mDBGTBH_BIT13:      equ    %00100000
mDBGTBH_BIT14:      equ    %01000000
mDBGTBH_BIT15:      equ    %10000000


;*** DBGTBL - Debug Trace Buffer Register Low; 0x00000023 ***
DBGTBL:             equ    $00000023                                ;*** DBGTBL - Debug Trace Buffer Register Low; 0x00000023 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGTBL_BIT0:        equ    0                                         ; Trace Buffer Data Bit 0
DBGTBL_BIT1:        equ    1                                         ; Trace Buffer Data Bit 1
DBGTBL_BIT2:        equ    2                                         ; Trace Buffer Data Bit 2
DBGTBL_BIT3:        equ    3                                         ; Trace Buffer Data Bit 3
DBGTBL_BIT4:        equ    4                                         ; Trace Buffer Data Bit 4
DBGTBL_BIT5:        equ    5                                         ; Trace Buffer Data Bit 5
DBGTBL_BIT6:        equ    6                                         ; Trace Buffer Data Bit 6
DBGTBL_BIT7:        equ    7                                         ; Trace Buffer Data Bit 7
; bit position masks
mDBGTBL_BIT0:       equ    %00000001
mDBGTBL_BIT1:       equ    %00000010
mDBGTBL_BIT2:       equ    %00000100
mDBGTBL_BIT3:       equ    %00001000
mDBGTBL_BIT4:       equ    %00010000
mDBGTBL_BIT5:       equ    %00100000
mDBGTBL_BIT6:       equ    %01000000
mDBGTBL_BIT7:       equ    %10000000


;*** DBGCNT - Debug Count Register; 0x00000024 ***
DBGCNT:             equ    $00000024                                ;*** DBGCNT - Debug Count Register; 0x00000024 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGCNT_CNT0:        equ    0                                         ; Count Value, bit 0
DBGCNT_CNT1:        equ    1                                         ; Count Value, bit 1
DBGCNT_CNT2:        equ    2                                         ; Count Value, bit 2
DBGCNT_CNT3:        equ    3                                         ; Count Value, bit 3
DBGCNT_CNT4:        equ    4                                         ; Count Value, bit 4
DBGCNT_CNT5:        equ    5                                         ; Count Value, bit 5
DBGCNT_TBF:         equ    7                                         ; Trace Buffer Full
; bit position masks
mDBGCNT_CNT0:       equ    %00000001
mDBGCNT_CNT1:       equ    %00000010
mDBGCNT_CNT2:       equ    %00000100
mDBGCNT_CNT3:       equ    %00001000
mDBGCNT_CNT4:       equ    %00010000
mDBGCNT_CNT5:       equ    %00100000
mDBGCNT_TBF:        equ    %10000000


;*** DBGCCX - Debug Comparator C Extended Register; 0x00000025 ***
DBGCCX:             equ    $00000025                                ;*** DBGCCX - Debug Comparator C Extended Register; 0x00000025 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGCCX_EXTCMP0:     equ    0                                         ; Comparator C Extended Compare Bits, bit 0
DBGCCX_EXTCMP1:     equ    1                                         ; Comparator C Extended Compare Bits, bit 1
DBGCCX_EXTCMP2:     equ    2                                         ; Comparator C Extended Compare Bits, bit 2
DBGCCX_EXTCMP3:     equ    3                                         ; Comparator C Extended Compare Bits, bit 3
DBGCCX_EXTCMP4:     equ    4                                         ; Comparator C Extended Compare Bits, bit 4
DBGCCX_EXTCMP5:     equ    5                                         ; Comparator C Extended Compare Bits, bit 5
DBGCCX_PAGSEL0:     equ    6                                         ; Page Selector Field, bit 0
DBGCCX_PAGSEL1:     equ    7                                         ; Page Selector Field, bit 1
; bit position masks
mDBGCCX_EXTCMP0:    equ    %00000001
mDBGCCX_EXTCMP1:    equ    %00000010
mDBGCCX_EXTCMP2:    equ    %00000100
mDBGCCX_EXTCMP3:    equ    %00001000
mDBGCCX_EXTCMP4:    equ    %00010000
mDBGCCX_EXTCMP5:    equ    %00100000
mDBGCCX_PAGSEL0:    equ    %01000000
mDBGCCX_PAGSEL1:    equ    %10000000


;*** DBGCC - Debug Comparator C Register; 0x00000026 ***
DBGCC:              equ    $00000026                                ;*** DBGCC - Debug Comparator C Register; 0x00000026 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGCC_BIT0:         equ    0                                         ; Comparator C Compare Bit 0
DBGCC_BIT1:         equ    1                                         ; Comparator C Compare Bit 1
DBGCC_BIT2:         equ    2                                         ; Comparator C Compare Bit 2
DBGCC_BIT3:         equ    3                                         ; Comparator C Compare Bit 3
DBGCC_BIT4:         equ    4                                         ; Comparator C Compare Bit 4
DBGCC_BIT5:         equ    5                                         ; Comparator C Compare Bit 5
DBGCC_BIT6:         equ    6                                         ; Comparator C Compare Bit 6
DBGCC_BIT7:         equ    7                                         ; Comparator C Compare Bit 7
DBGCC_BIT8:         equ    8                                         ; Comparator C Compare Bit 8
DBGCC_BIT9:         equ    9                                         ; Comparator C Compare Bit 9
DBGCC_BIT10:        equ    10                                        ; Comparator C Compare Bit 10
DBGCC_BIT11:        equ    11                                        ; Comparator C Compare Bit 11
DBGCC_BIT12:        equ    12                                        ; Comparator C Compare Bit 12
DBGCC_BIT13:        equ    13                                        ; Comparator C Compare Bit 13
DBGCC_BIT14:        equ    14                                        ; Comparator C Compare Bit 14
DBGCC_BIT15:        equ    15                                        ; Comparator C Compare Bit 15
; bit position masks
mDBGCC_BIT0:        equ    %00000001
mDBGCC_BIT1:        equ    %00000010
mDBGCC_BIT2:        equ    %00000100
mDBGCC_BIT3:        equ    %00001000
mDBGCC_BIT4:        equ    %00010000
mDBGCC_BIT5:        equ    %00100000
mDBGCC_BIT6:        equ    %01000000
mDBGCC_BIT7:        equ    %10000000
mDBGCC_BIT8:        equ    %100000000
mDBGCC_BIT9:        equ    %1000000000
mDBGCC_BIT10:       equ    %10000000000
mDBGCC_BIT11:       equ    %100000000000
mDBGCC_BIT12:       equ    %1000000000000
mDBGCC_BIT13:       equ    %10000000000000
mDBGCC_BIT14:       equ    %100000000000000
mDBGCC_BIT15:       equ    %1000000000000000


;*** DBGCCH - Debug Comparator C Register High; 0x00000026 ***
DBGCCH:             equ    $00000026                                ;*** DBGCCH - Debug Comparator C Register High; 0x00000026 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGCCH_BIT8:        equ    0                                         ; Comparator C Compare Bit 8
DBGCCH_BIT9:        equ    1                                         ; Comparator C Compare Bit 9
DBGCCH_BIT10:       equ    2                                         ; Comparator C Compare Bit 10
DBGCCH_BIT11:       equ    3                                         ; Comparator C Compare Bit 11
DBGCCH_BIT12:       equ    4                                         ; Comparator C Compare Bit 12
DBGCCH_BIT13:       equ    5                                         ; Comparator C Compare Bit 13
DBGCCH_BIT14:       equ    6                                         ; Comparator C Compare Bit 14
DBGCCH_BIT15:       equ    7                                         ; Comparator C Compare Bit 15
; bit position masks
mDBGCCH_BIT8:       equ    %00000001
mDBGCCH_BIT9:       equ    %00000010
mDBGCCH_BIT10:      equ    %00000100
mDBGCCH_BIT11:      equ    %00001000
mDBGCCH_BIT12:      equ    %00010000
mDBGCCH_BIT13:      equ    %00100000
mDBGCCH_BIT14:      equ    %01000000
mDBGCCH_BIT15:      equ    %10000000


;*** DBGCCL - Debug Comparator C Register Low; 0x00000027 ***
DBGCCL:             equ    $00000027                                ;*** DBGCCL - Debug Comparator C Register Low; 0x00000027 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGCCL_BIT0:        equ    0                                         ; Comparator C Compare Bit 0
DBGCCL_BIT1:        equ    1                                         ; Comparator C Compare Bit 1
DBGCCL_BIT2:        equ    2                                         ; Comparator C Compare Bit 2
DBGCCL_BIT3:        equ    3                                         ; Comparator C Compare Bit 3
DBGCCL_BIT4:        equ    4                                         ; Comparator C Compare Bit 4
DBGCCL_BIT5:        equ    5                                         ; Comparator C Compare Bit 5
DBGCCL_BIT6:        equ    6                                         ; Comparator C Compare Bit 6
DBGCCL_BIT7:        equ    7                                         ; Comparator C Compare Bit 7
; bit position masks
mDBGCCL_BIT0:       equ    %00000001
mDBGCCL_BIT1:       equ    %00000010
mDBGCCL_BIT2:       equ    %00000100
mDBGCCL_BIT3:       equ    %00001000
mDBGCCL_BIT4:       equ    %00010000
mDBGCCL_BIT5:       equ    %00100000
mDBGCCL_BIT6:       equ    %01000000
mDBGCCL_BIT7:       equ    %10000000


;*** DBGC2 - Debug Control Register 2; 0x00000028 ***
DBGC2:              equ    $00000028                                ;*** DBGC2 - Debug Control Register 2; 0x00000028 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGC2_RWC:          equ    0                                         ; Read/Write Comparator C Value Bit
DBGC2_RWCEN:        equ    1                                         ; Read/Write Comparator C Enable Bit
DBGC2_TAGC:         equ    2                                         ; Comparator C Tag Select
DBGC2_BKCEN:        equ    3                                         ; Breakpoint Comparator C Enable Bit
DBGC2_TAGAB:        equ    4                                         ; Comparator A/B Tag Select
DBGC2_BDM:          equ    5                                         ; Background Debug Mode Enable
DBGC2_FULL:         equ    6                                         ; Full Breakpoint Mode Enable
DBGC2_BKABEN:       equ    7                                         ; Breakpoint Using Comparator A and B Enable
; bit position masks
mDBGC2_RWC:         equ    %00000001
mDBGC2_RWCEN:       equ    %00000010
mDBGC2_TAGC:        equ    %00000100
mDBGC2_BKCEN:       equ    %00001000
mDBGC2_TAGAB:       equ    %00010000
mDBGC2_BDM:         equ    %00100000
mDBGC2_FULL:        equ    %01000000
mDBGC2_BKABEN:      equ    %10000000


;*** DBGC3 - Debug Control Register 3; 0x00000029 ***
DBGC3:              equ    $00000029                                ;*** DBGC3 - Debug Control Register 3; 0x00000029 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGC3_RWB:          equ    0                                         ; Read/Write Comparator B Value Bit
DBGC3_RWBEN:        equ    1                                         ; Read/Write Comparator B Enable Bit
DBGC3_RWA:          equ    2                                         ; Read/Write Comparator A Value Bit
DBGC3_RWAEN:        equ    3                                         ; Read/Write Comparator A Enable Bit
DBGC3_BKBMBL:       equ    4                                         ; Breakpoint Mask Low Byte for Second Address
DBGC3_BKBMBH:       equ    5                                         ; Breakpoint Mask High Byte for Second Address
DBGC3_BKAMBL:       equ    6                                         ; Breakpoint Mask Low Byte for First Address
DBGC3_BKAMBH:       equ    7                                         ; Breakpoint Mask High Byte for First Address
; bit position masks
mDBGC3_RWB:         equ    %00000001
mDBGC3_RWBEN:       equ    %00000010
mDBGC3_RWA:         equ    %00000100
mDBGC3_RWAEN:       equ    %00001000
mDBGC3_BKBMBL:      equ    %00010000
mDBGC3_BKBMBH:      equ    %00100000
mDBGC3_BKAMBL:      equ    %01000000
mDBGC3_BKAMBH:      equ    %10000000


;*** DBGCAX - Debug Comparator A Extended Register; 0x0000002A ***
DBGCAX:             equ    $0000002A                                ;*** DBGCAX - Debug Comparator A Extended Register; 0x0000002A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGCAX_EXTCMP0:     equ    0                                         ; Comparator A Extended Compare Bits, bit 0
DBGCAX_EXTCMP1:     equ    1                                         ; Comparator A Extended Compare Bits, bit 1
DBGCAX_EXTCMP2:     equ    2                                         ; Comparator A Extended Compare Bits, bit 2
DBGCAX_EXTCMP3:     equ    3                                         ; Comparator A Extended Compare Bits, bit 3
DBGCAX_EXTCMP4:     equ    4                                         ; Comparator A Extended Compare Bits, bit 4
DBGCAX_EXTCMP5:     equ    5                                         ; Comparator A Extended Compare Bits, bit 5
DBGCAX_PAGSEL0:     equ    6                                         ; Page Selector Field, bit 0
DBGCAX_PAGSEL1:     equ    7                                         ; Page Selector Field, bit 1
; bit position masks
mDBGCAX_EXTCMP0:    equ    %00000001
mDBGCAX_EXTCMP1:    equ    %00000010
mDBGCAX_EXTCMP2:    equ    %00000100
mDBGCAX_EXTCMP3:    equ    %00001000
mDBGCAX_EXTCMP4:    equ    %00010000
mDBGCAX_EXTCMP5:    equ    %00100000
mDBGCAX_PAGSEL0:    equ    %01000000
mDBGCAX_PAGSEL1:    equ    %10000000


;*** DBGCA - Debug Comparator A Register; 0x0000002B ***
DBGCA:              equ    $0000002B                                ;*** DBGCA - Debug Comparator A Register; 0x0000002B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGCA_BIT0:         equ    0                                         ; Comparator A Compare Bit 0
DBGCA_BIT1:         equ    1                                         ; Comparator A Compare Bit 1
DBGCA_BIT2:         equ    2                                         ; Comparator A Compare Bit 2
DBGCA_BIT3:         equ    3                                         ; Comparator A Compare Bit 3
DBGCA_BIT4:         equ    4                                         ; Comparator A Compare Bit 4
DBGCA_BIT5:         equ    5                                         ; Comparator A Compare Bit 5
DBGCA_BIT6:         equ    6                                         ; Comparator A Compare Bit 6
DBGCA_BIT7:         equ    7                                         ; Comparator A Compare Bit 7
DBGCA_BIT8:         equ    8                                         ; Comparator A Compare Bit 8
DBGCA_BIT9:         equ    9                                         ; Comparator A Compare Bit 9
DBGCA_BIT10:        equ    10                                        ; Comparator A Compare Bit 10
DBGCA_BIT11:        equ    11                                        ; Comparator A Compare Bit 11
DBGCA_BIT12:        equ    12                                        ; Comparator A Compare Bit 12
DBGCA_BIT13:        equ    13                                        ; Comparator A Compare Bit 13
DBGCA_BIT14:        equ    14                                        ; Comparator A Compare Bit 14
DBGCA_BIT15:        equ    15                                        ; Comparator A Compare Bit 15
; bit position masks
mDBGCA_BIT0:        equ    %00000001
mDBGCA_BIT1:        equ    %00000010
mDBGCA_BIT2:        equ    %00000100
mDBGCA_BIT3:        equ    %00001000
mDBGCA_BIT4:        equ    %00010000
mDBGCA_BIT5:        equ    %00100000
mDBGCA_BIT6:        equ    %01000000
mDBGCA_BIT7:        equ    %10000000
mDBGCA_BIT8:        equ    %100000000
mDBGCA_BIT9:        equ    %1000000000
mDBGCA_BIT10:       equ    %10000000000
mDBGCA_BIT11:       equ    %100000000000
mDBGCA_BIT12:       equ    %1000000000000
mDBGCA_BIT13:       equ    %10000000000000
mDBGCA_BIT14:       equ    %100000000000000
mDBGCA_BIT15:       equ    %1000000000000000


;*** DBGCAH - Debug Comparator A Register High; 0x0000002B ***
DBGCAH:             equ    $0000002B                                ;*** DBGCAH - Debug Comparator A Register High; 0x0000002B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGCAH_BIT8:        equ    0                                         ; Comparator A Compare Bit 8
DBGCAH_BIT9:        equ    1                                         ; Comparator A Compare Bit 9
DBGCAH_BIT10:       equ    2                                         ; Comparator A Compare Bit 10
DBGCAH_BIT11:       equ    3                                         ; Comparator A Compare Bit 11
DBGCAH_BIT12:       equ    4                                         ; Comparator A Compare Bit 12
DBGCAH_BIT13:       equ    5                                         ; Comparator A Compare Bit 13
DBGCAH_BIT14:       equ    6                                         ; Comparator A Compare Bit 14
DBGCAH_BIT15:       equ    7                                         ; Comparator A Compare Bit 15
; bit position masks
mDBGCAH_BIT8:       equ    %00000001
mDBGCAH_BIT9:       equ    %00000010
mDBGCAH_BIT10:      equ    %00000100
mDBGCAH_BIT11:      equ    %00001000
mDBGCAH_BIT12:      equ    %00010000
mDBGCAH_BIT13:      equ    %00100000
mDBGCAH_BIT14:      equ    %01000000
mDBGCAH_BIT15:      equ    %10000000


;*** DBGCAL - Debug Comparator A Register Low; 0x0000002C ***
DBGCAL:             equ    $0000002C                                ;*** DBGCAL - Debug Comparator A Register Low; 0x0000002C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGCAL_BIT0:        equ    0                                         ; Comparator A Compare Bit 0
DBGCAL_BIT1:        equ    1                                         ; Comparator A Compare Bit 1
DBGCAL_BIT2:        equ    2                                         ; Comparator A Compare Bit 2
DBGCAL_BIT3:        equ    3                                         ; Comparator A Compare Bit 3
DBGCAL_BIT4:        equ    4                                         ; Comparator A Compare Bit 4
DBGCAL_BIT5:        equ    5                                         ; Comparator A Compare Bit 5
DBGCAL_BIT6:        equ    6                                         ; Comparator A Compare Bit 6
DBGCAL_BIT7:        equ    7                                         ; Comparator A Compare Bit 7
; bit position masks
mDBGCAL_BIT0:       equ    %00000001
mDBGCAL_BIT1:       equ    %00000010
mDBGCAL_BIT2:       equ    %00000100
mDBGCAL_BIT3:       equ    %00001000
mDBGCAL_BIT4:       equ    %00010000
mDBGCAL_BIT5:       equ    %00100000
mDBGCAL_BIT6:       equ    %01000000
mDBGCAL_BIT7:       equ    %10000000


;*** DBGCBX - Debug Comparator B Extended Register; 0x0000002D ***
DBGCBX:             equ    $0000002D                                ;*** DBGCBX - Debug Comparator B Extended Register; 0x0000002D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGCBX_EXTCMP0:     equ    0                                         ; Comparator B Extended Compare Bits, bit 0
DBGCBX_EXTCMP1:     equ    1                                         ; Comparator B Extended Compare Bits, bit 1
DBGCBX_EXTCMP2:     equ    2                                         ; Comparator B Extended Compare Bits, bit 2
DBGCBX_EXTCMP3:     equ    3                                         ; Comparator B Extended Compare Bits, bit 3
DBGCBX_EXTCMP4:     equ    4                                         ; Comparator B Extended Compare Bits, bit 4
DBGCBX_EXTCMP5:     equ    5                                         ; Comparator B Extended Compare Bits, bit 5
DBGCBX_PAGSEL0:     equ    6                                         ; Page Selector Field, bit 0
DBGCBX_PAGSEL1:     equ    7                                         ; Page Selector Field, bit 1
; bit position masks
mDBGCBX_EXTCMP0:    equ    %00000001
mDBGCBX_EXTCMP1:    equ    %00000010
mDBGCBX_EXTCMP2:    equ    %00000100
mDBGCBX_EXTCMP3:    equ    %00001000
mDBGCBX_EXTCMP4:    equ    %00010000
mDBGCBX_EXTCMP5:    equ    %00100000
mDBGCBX_PAGSEL0:    equ    %01000000
mDBGCBX_PAGSEL1:    equ    %10000000


;*** DBGCB - Debug Comparator B Register; 0x0000002E ***
DBGCB:              equ    $0000002E                                ;*** DBGCB - Debug Comparator B Register; 0x0000002E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGCB_BIT0:         equ    0                                         ; Comparator B High Compare Bit 0
DBGCB_BIT1:         equ    1                                         ; Comparator B High Compare Bit 1
DBGCB_BIT2:         equ    2                                         ; Comparator B High Compare Bit 2
DBGCB_BIT3:         equ    3                                         ; Comparator B High Compare Bit 3
DBGCB_BIT4:         equ    4                                         ; Comparator B High Compare Bit 4
DBGCB_BIT5:         equ    5                                         ; Comparator B High Compare Bit 5
DBGCB_BIT6:         equ    6                                         ; Comparator B High Compare Bit 6
DBGCB_BIT7:         equ    7                                         ; Comparator B High Compare Bit 7
DBGCB_BIT8:         equ    8                                         ; Comparator B High Compare Bit 8
DBGCB_BIT9:         equ    9                                         ; Comparator B High Compare Bit 9
DBGCB_BIT10:        equ    10                                        ; Comparator B High Compare Bit 10
DBGCB_BIT11:        equ    11                                        ; Comparator B High Compare Bit 11
DBGCB_BIT12:        equ    12                                        ; Comparator B High Compare Bit 12
DBGCB_BIT13:        equ    13                                        ; Comparator B High Compare Bit 13
DBGCB_BIT14:        equ    14                                        ; Comparator B High Compare Bit 14
DBGCB_BIT15:        equ    15                                        ; Comparator B High Compare Bit 15
; bit position masks
mDBGCB_BIT0:        equ    %00000001
mDBGCB_BIT1:        equ    %00000010
mDBGCB_BIT2:        equ    %00000100
mDBGCB_BIT3:        equ    %00001000
mDBGCB_BIT4:        equ    %00010000
mDBGCB_BIT5:        equ    %00100000
mDBGCB_BIT6:        equ    %01000000
mDBGCB_BIT7:        equ    %10000000
mDBGCB_BIT8:        equ    %100000000
mDBGCB_BIT9:        equ    %1000000000
mDBGCB_BIT10:       equ    %10000000000
mDBGCB_BIT11:       equ    %100000000000
mDBGCB_BIT12:       equ    %1000000000000
mDBGCB_BIT13:       equ    %10000000000000
mDBGCB_BIT14:       equ    %100000000000000
mDBGCB_BIT15:       equ    %1000000000000000


;*** DBGCBH - Debug Comparator B Register High; 0x0000002E ***
DBGCBH:             equ    $0000002E                                ;*** DBGCBH - Debug Comparator B Register High; 0x0000002E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGCBH_BIT8:        equ    0                                         ; Comparator B High Compare Bit 8
DBGCBH_BIT9:        equ    1                                         ; Comparator B High Compare Bit 9
DBGCBH_BIT10:       equ    2                                         ; Comparator B High Compare Bit 10
DBGCBH_BIT11:       equ    3                                         ; Comparator B High Compare Bit 11
DBGCBH_BIT12:       equ    4                                         ; Comparator B High Compare Bit 12
DBGCBH_BIT13:       equ    5                                         ; Comparator B High Compare Bit 13
DBGCBH_BIT14:       equ    6                                         ; Comparator B High Compare Bit 14
DBGCBH_BIT15:       equ    7                                         ; Comparator B High Compare Bit 15
; bit position masks
mDBGCBH_BIT8:       equ    %00000001
mDBGCBH_BIT9:       equ    %00000010
mDBGCBH_BIT10:      equ    %00000100
mDBGCBH_BIT11:      equ    %00001000
mDBGCBH_BIT12:      equ    %00010000
mDBGCBH_BIT13:      equ    %00100000
mDBGCBH_BIT14:      equ    %01000000
mDBGCBH_BIT15:      equ    %10000000


;*** DBGCBL - Debug Comparator B Register Low; 0x0000002F ***
DBGCBL:             equ    $0000002F                                ;*** DBGCBL - Debug Comparator B Register Low; 0x0000002F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGCBL_BIT0:        equ    0                                         ; Comparator B High Compare Bit 0
DBGCBL_BIT1:        equ    1                                         ; Comparator B High Compare Bit 1
DBGCBL_BIT2:        equ    2                                         ; Comparator B High Compare Bit 2
DBGCBL_BIT3:        equ    3                                         ; Comparator B High Compare Bit 3
DBGCBL_BIT4:        equ    4                                         ; Comparator B High Compare Bit 4
DBGCBL_BIT5:        equ    5                                         ; Comparator B High Compare Bit 5
DBGCBL_BIT6:        equ    6                                         ; Comparator B High Compare Bit 6
DBGCBL_BIT7:        equ    7                                         ; Comparator B High Compare Bit 7
; bit position masks
mDBGCBL_BIT0:       equ    %00000001
mDBGCBL_BIT1:       equ    %00000010
mDBGCBL_BIT2:       equ    %00000100
mDBGCBL_BIT3:       equ    %00001000
mDBGCBL_BIT4:       equ    %00010000
mDBGCBL_BIT5:       equ    %00100000
mDBGCBL_BIT6:       equ    %01000000
mDBGCBL_BIT7:       equ    %10000000


;*** PPAGE - Page Index Register; 0x00000030 ***
PPAGE:              equ    $00000030                                ;*** PPAGE - Page Index Register; 0x00000030 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PPAGE_PIX0:         equ    0                                         ; Page Index Register Bit 0
PPAGE_PIX1:         equ    1                                         ; Page Index Register Bit 1
PPAGE_PIX2:         equ    2                                         ; Page Index Register Bit 2
PPAGE_PIX3:         equ    3                                         ; Page Index Register Bit 3
PPAGE_PIX4:         equ    4                                         ; Page Index Register Bit 4
PPAGE_PIX5:         equ    5                                         ; Page Index Register Bit 5
; bit position masks
mPPAGE_PIX0:        equ    %00000001
mPPAGE_PIX1:        equ    %00000010
mPPAGE_PIX2:        equ    %00000100
mPPAGE_PIX3:        equ    %00001000
mPPAGE_PIX4:        equ    %00010000
mPPAGE_PIX5:        equ    %00100000


;*** PORTK - Port K Data Register; 0x00000032 ***
PORTK:              equ    $00000032                                ;*** PORTK - Port K Data Register; 0x00000032 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PORTK_BIT0:         equ    0                                         ; Port K Bit 0
PORTK_BIT1:         equ    1                                         ; Port K Bit 1
PORTK_BIT2:         equ    2                                         ; Port K Bit 2
PORTK_BIT3:         equ    3                                         ; Port K Bit 3
PORTK_BIT4:         equ    4                                         ; Port K Bit 4
PORTK_BIT5:         equ    5                                         ; Port K Bit 5
PORTK_BIT6:         equ    6                                         ; Port K Bit 6
PORTK_BIT7:         equ    7                                         ; Port K Bit 7
; bit position masks
mPORTK_BIT0:        equ    %00000001
mPORTK_BIT1:        equ    %00000010
mPORTK_BIT2:        equ    %00000100
mPORTK_BIT3:        equ    %00001000
mPORTK_BIT4:        equ    %00010000
mPORTK_BIT5:        equ    %00100000
mPORTK_BIT6:        equ    %01000000
mPORTK_BIT7:        equ    %10000000


;*** DDRK - Port K Data Direction Register; 0x00000033 ***
DDRK:               equ    $00000033                                ;*** DDRK - Port K Data Direction Register; 0x00000033 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRK_BIT0:          equ    0                                         ; Port K Data Direction Bit 0
DDRK_BIT1:          equ    1                                         ; Port K Data Direction Bit 1
DDRK_BIT2:          equ    2                                         ; Port K Data Direction Bit 2
DDRK_BIT3:          equ    3                                         ; Port K Data Direction Bit 3
DDRK_BIT4:          equ    4                                         ; Port K Data Direction Bit 4
DDRK_BIT5:          equ    5                                         ; Port K Data Direction Bit 5
DDRK_BIT6:          equ    6                                         ; Port K Data Direction Bit 6
DDRK_BIT7:          equ    7                                         ; Port K Data Direction Bit 7
; bit position masks
mDDRK_BIT0:         equ    %00000001
mDDRK_BIT1:         equ    %00000010
mDDRK_BIT2:         equ    %00000100
mDDRK_BIT3:         equ    %00001000
mDDRK_BIT4:         equ    %00010000
mDDRK_BIT5:         equ    %00100000
mDDRK_BIT6:         equ    %01000000
mDDRK_BIT7:         equ    %10000000


;*** SYNR - CRG Synthesizer Register; 0x00000034 ***
SYNR:               equ    $00000034                                ;*** SYNR - CRG Synthesizer Register; 0x00000034 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SYNR_SYN0:          equ    0                                         ; CRG Synthesizer Bit 0
SYNR_SYN1:          equ    1                                         ; CRG Synthesizer Bit 1
SYNR_SYN2:          equ    2                                         ; CRG Synthesizer Bit 2
SYNR_SYN3:          equ    3                                         ; CRG Synthesizer Bit 3
SYNR_SYN4:          equ    4                                         ; CRG Synthesizer Bit 4
SYNR_SYN5:          equ    5                                         ; CRG Synthesizer Bit 5
; bit position masks
mSYNR_SYN0:         equ    %00000001
mSYNR_SYN1:         equ    %00000010
mSYNR_SYN2:         equ    %00000100
mSYNR_SYN3:         equ    %00001000
mSYNR_SYN4:         equ    %00010000
mSYNR_SYN5:         equ    %00100000


;*** REFDV - CRG Reference Divider Register; 0x00000035 ***
REFDV:              equ    $00000035                                ;*** REFDV - CRG Reference Divider Register; 0x00000035 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
REFDV_REFDV0:       equ    0                                         ; CRG Reference Divider Bit 0
REFDV_REFDV1:       equ    1                                         ; CRG Reference Divider Bit 1
REFDV_REFDV2:       equ    2                                         ; CRG Reference Divider Bit 2
REFDV_REFDV3:       equ    3                                         ; CRG Reference Divider Bit 3
; bit position masks
mREFDV_REFDV0:      equ    %00000001
mREFDV_REFDV1:      equ    %00000010
mREFDV_REFDV2:      equ    %00000100
mREFDV_REFDV3:      equ    %00001000


;*** CRGFLG - CRG Flags Register; 0x00000037 ***
CRGFLG:             equ    $00000037                                ;*** CRGFLG - CRG Flags Register; 0x00000037 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CRGFLG_SCM:         equ    0                                         ; Self-clock mode Status
CRGFLG_SCMIF:       equ    1                                         ; Self-clock mode Interrupt Flag
CRGFLG_TRACK:       equ    2                                         ; Track Status
CRGFLG_LOCK:        equ    3                                         ; Lock Status
CRGFLG_LOCKIF:      equ    4                                         ; PLL Lock Interrupt Flag
CRGFLG_LVRF:        equ    5                                         ; Low Voltage Reset Flag
CRGFLG_PORF:        equ    6                                         ; Power on Reset Flag
CRGFLG_RTIF:        equ    7                                         ; Real Time Interrupt Flag
; bit position masks
mCRGFLG_SCM:        equ    %00000001
mCRGFLG_SCMIF:      equ    %00000010
mCRGFLG_TRACK:      equ    %00000100
mCRGFLG_LOCK:       equ    %00001000
mCRGFLG_LOCKIF:     equ    %00010000
mCRGFLG_LVRF:       equ    %00100000
mCRGFLG_PORF:       equ    %01000000
mCRGFLG_RTIF:       equ    %10000000


;*** CRGINT - CRG Interrupt Enable Register; 0x00000038 ***
CRGINT:             equ    $00000038                                ;*** CRGINT - CRG Interrupt Enable Register; 0x00000038 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CRGINT_SCMIE:       equ    1                                         ; Self-clock mode Interrupt Enable
CRGINT_LOCKIE:      equ    4                                         ; Lock Interrupt Enable
CRGINT_RTIE:        equ    7                                         ; Real Time Interrupt Enable
; bit position masks
mCRGINT_SCMIE:      equ    %00000010
mCRGINT_LOCKIE:     equ    %00010000
mCRGINT_RTIE:       equ    %10000000


;*** CLKSEL - CRG Clock Select Register; 0x00000039 ***
CLKSEL:             equ    $00000039                                ;*** CLKSEL - CRG Clock Select Register; 0x00000039 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CLKSEL_COPWAI:      equ    0                                         ; COP stops in WAIT mode
CLKSEL_RTIWAI:      equ    1                                         ; RTI stops in WAIT mode
CLKSEL_CWAI:        equ    2                                         ; CLK24 and CLK23 stop in WAIT mode
CLKSEL_PLLWAI:      equ    3                                         ; PLL stops in WAIT mode
CLKSEL_ROAWAI:      equ    4                                         ; Reduced Oscillator Amplitude in WAIT mode
CLKSEL_SYSWAI:      equ    5                                         ; System clocks stop in WAIT mode
CLKSEL_PSTP:        equ    6                                         ; Pseudo Stop
CLKSEL_PLLSEL:      equ    7                                         ; PLL selected for system clock
; bit position masks
mCLKSEL_COPWAI:     equ    %00000001
mCLKSEL_RTIWAI:     equ    %00000010
mCLKSEL_CWAI:       equ    %00000100
mCLKSEL_PLLWAI:     equ    %00001000
mCLKSEL_ROAWAI:     equ    %00010000
mCLKSEL_SYSWAI:     equ    %00100000
mCLKSEL_PSTP:       equ    %01000000
mCLKSEL_PLLSEL:     equ    %10000000


;*** PLLCTL - CRG PLL Control Register; 0x0000003A ***
PLLCTL:             equ    $0000003A                                ;*** PLLCTL - CRG PLL Control Register; 0x0000003A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PLLCTL_SCME:        equ    0                                         ; Self-clock mode enable
PLLCTL_PCE:         equ    1                                         ; COP Enable during Pseudo Stop Bit
PLLCTL_PRE:         equ    2                                         ; RTI Enable during Pseudo Stop Bit
PLLCTL_ACQ:         equ    4                                         ; Acquisition
PLLCTL_AUTO:        equ    5                                         ; Automatic Bandwidth Control
PLLCTL_PLLON:       equ    6                                         ; Phase Lock Loop On
PLLCTL_CME:         equ    7                                         ; Clock Monitor Enable
; bit position masks
mPLLCTL_SCME:       equ    %00000001
mPLLCTL_PCE:        equ    %00000010
mPLLCTL_PRE:        equ    %00000100
mPLLCTL_ACQ:        equ    %00010000
mPLLCTL_AUTO:       equ    %00100000
mPLLCTL_PLLON:      equ    %01000000
mPLLCTL_CME:        equ    %10000000


;*** RTICTL - CRG RTI Control Register; 0x0000003B ***
RTICTL:             equ    $0000003B                                ;*** RTICTL - CRG RTI Control Register; 0x0000003B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RTICTL_RTR0:        equ    0                                         ; Real Time Interrupt Modulus Counter Select Bit 0
RTICTL_RTR1:        equ    1                                         ; Real Time Interrupt Modulus Counter Select Bit 1
RTICTL_RTR2:        equ    2                                         ; Real Time Interrupt Modulus Counter Select Bit 2
RTICTL_RTR3:        equ    3                                         ; Real Time Interrupt Modulus Counter Select Bit 3
RTICTL_RTR4:        equ    4                                         ; Real Time Interrupt Prescale Rate Select Bit 4
RTICTL_RTR5:        equ    5                                         ; Real Time Interrupt Prescale Rate Select Bit 5
RTICTL_RTR6:        equ    6                                         ; Real Time Interrupt Prescale Rate Select Bit 6
; bit position masks
mRTICTL_RTR0:       equ    %00000001
mRTICTL_RTR1:       equ    %00000010
mRTICTL_RTR2:       equ    %00000100
mRTICTL_RTR3:       equ    %00001000
mRTICTL_RTR4:       equ    %00010000
mRTICTL_RTR5:       equ    %00100000
mRTICTL_RTR6:       equ    %01000000


;*** COPCTL - CRG COP Control Register; 0x0000003C ***
COPCTL:             equ    $0000003C                                ;*** COPCTL - CRG COP Control Register; 0x0000003C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
COPCTL_CR0:         equ    0                                         ; COP Watchdog Timer Rate select Bit 0
COPCTL_CR1:         equ    1                                         ; COP Watchdog Timer Rate select Bit 1
COPCTL_CR2:         equ    2                                         ; COP Watchdog Timer Rate select Bit 2
COPCTL_RSBCK:       equ    6                                         ; COP and RTI stop in Active BDM mode Bit
COPCTL_WCOP:        equ    7                                         ; Window COP mode
; bit position masks
mCOPCTL_CR0:        equ    %00000001
mCOPCTL_CR1:        equ    %00000010
mCOPCTL_CR2:        equ    %00000100
mCOPCTL_RSBCK:      equ    %01000000
mCOPCTL_WCOP:       equ    %10000000


;*** ARMCOP - CRG COP Timer Arm/Reset Register; 0x0000003F ***
ARMCOP:             equ    $0000003F                                ;*** ARMCOP - CRG COP Timer Arm/Reset Register; 0x0000003F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ARMCOP_BIT0:        equ    0                                         ; CRG COP Timer Arm/Reset Bit 0
ARMCOP_BIT1:        equ    1                                         ; CRG COP Timer Arm/Reset Bit 1
ARMCOP_BIT2:        equ    2                                         ; CRG COP Timer Arm/Reset Bit 2
ARMCOP_BIT3:        equ    3                                         ; CRG COP Timer Arm/Reset Bit 3
ARMCOP_BIT4:        equ    4                                         ; CRG COP Timer Arm/Reset Bit 4
ARMCOP_BIT5:        equ    5                                         ; CRG COP Timer Arm/Reset Bit 5
ARMCOP_BIT6:        equ    6                                         ; CRG COP Timer Arm/Reset Bit 6
ARMCOP_BIT7:        equ    7                                         ; CRG COP Timer Arm/Reset Bit 7
; bit position masks
mARMCOP_BIT0:       equ    %00000001
mARMCOP_BIT1:       equ    %00000010
mARMCOP_BIT2:       equ    %00000100
mARMCOP_BIT3:       equ    %00001000
mARMCOP_BIT4:       equ    %00010000
mARMCOP_BIT5:       equ    %00100000
mARMCOP_BIT6:       equ    %01000000
mARMCOP_BIT7:       equ    %10000000


;*** TIOS - Timer Input Capture/Output Compare Select; 0x00000040 ***
TIOS:               equ    $00000040                                ;*** TIOS - Timer Input Capture/Output Compare Select; 0x00000040 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TIOS_IOS4:          equ    4                                         ; Input Capture or Output Compare Channel Configuration Bit 4
TIOS_IOS5:          equ    5                                         ; Input Capture or Output Compare Channel Configuration Bit 5
TIOS_IOS6:          equ    6                                         ; Input Capture or Output Compare Channel Configuration Bit 6
TIOS_IOS7:          equ    7                                         ; Input Capture or Output Compare Channel Configuration Bit 7
; bit position masks
mTIOS_IOS4:         equ    %00010000
mTIOS_IOS5:         equ    %00100000
mTIOS_IOS6:         equ    %01000000
mTIOS_IOS7:         equ    %10000000


;*** CFORC - Timer Compare Force Register; 0x00000041 ***
CFORC:              equ    $00000041                                ;*** CFORC - Timer Compare Force Register; 0x00000041 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CFORC_FOC4:         equ    4                                         ; Force Output Compare Action for Channel 4
CFORC_FOC5:         equ    5                                         ; Force Output Compare Action for Channel 5
CFORC_FOC6:         equ    6                                         ; Force Output Compare Action for Channel 6
CFORC_FOC7:         equ    7                                         ; Force Output Compare Action for Channel 7
; bit position masks
mCFORC_FOC4:        equ    %00010000
mCFORC_FOC5:        equ    %00100000
mCFORC_FOC6:        equ    %01000000
mCFORC_FOC7:        equ    %10000000


;*** OC7M - Output Compare 7 Mask Register; 0x00000042 ***
OC7M:               equ    $00000042                                ;*** OC7M - Output Compare 7 Mask Register; 0x00000042 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
OC7M_OC7M4:         equ    4                                         ; Output Compare 7 Mask Bit 4
OC7M_OC7M5:         equ    5                                         ; Output Compare 7 Mask Bit 5
OC7M_OC7M6:         equ    6                                         ; Output Compare 7 Mask Bit 6
OC7M_OC7M7:         equ    7                                         ; Output Compare 7 Mask Bit 7
; bit position masks
mOC7M_OC7M4:        equ    %00010000
mOC7M_OC7M5:        equ    %00100000
mOC7M_OC7M6:        equ    %01000000
mOC7M_OC7M7:        equ    %10000000


;*** OC7D - Output Compare 7 Data Register; 0x00000043 ***
OC7D:               equ    $00000043                                ;*** OC7D - Output Compare 7 Data Register; 0x00000043 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
OC7D_OC7D4:         equ    4                                         ; Output Compare 7 Bit 4
OC7D_OC7D5:         equ    5                                         ; Output Compare 7 Bit 5
OC7D_OC7D6:         equ    6                                         ; Output Compare 7 Bit 6
OC7D_OC7D7:         equ    7                                         ; Output Compare 7 Bit 7
; bit position masks
mOC7D_OC7D4:        equ    %00010000
mOC7D_OC7D5:        equ    %00100000
mOC7D_OC7D6:        equ    %01000000
mOC7D_OC7D7:        equ    %10000000


;*** TCNT - Timer Count Register; 0x00000044 ***
TCNT:               equ    $00000044                                ;*** TCNT - Timer Count Register; 0x00000044 ***


;*** TCNTHi - Timer Count Register High; 0x00000044 ***
TCNTHi:             equ    $00000044                                ;*** TCNTHi - Timer Count Register High; 0x00000044 ***


;*** TCNTLo - Timer Count Register Low; 0x00000045 ***
TCNTLo:             equ    $00000045                                ;*** TCNTLo - Timer Count Register Low; 0x00000045 ***


;*** TSCR1 - Timer System Control Register1; 0x00000046 ***
TSCR1:              equ    $00000046                                ;*** TSCR1 - Timer System Control Register1; 0x00000046 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TSCR1_TFFCA:        equ    4                                         ; Timer Fast Flag Clear All
TSCR1_TSFRZ:        equ    5                                         ; Timer and Modulus Counter Stop While in Freeze Mode
TSCR1_TSWAI:        equ    6                                         ; Timer Module Stops While in Wait
TSCR1_TEN:          equ    7                                         ; Timer Enable
; bit position masks
mTSCR1_TFFCA:       equ    %00010000
mTSCR1_TSFRZ:       equ    %00100000
mTSCR1_TSWAI:       equ    %01000000
mTSCR1_TEN:         equ    %10000000


;*** TTOV - Timer Toggle On Overflow Register; 0x00000047 ***
TTOV:               equ    $00000047                                ;*** TTOV - Timer Toggle On Overflow Register; 0x00000047 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TTOV_TOV4:          equ    4                                         ; Toggle On Overflow Bit 4
TTOV_TOV5:          equ    5                                         ; Toggle On Overflow Bit 5
TTOV_TOV6:          equ    6                                         ; Toggle On Overflow Bit 6
TTOV_TOV7:          equ    7                                         ; Toggle On Overflow Bit 7
; bit position masks
mTTOV_TOV4:         equ    %00010000
mTTOV_TOV5:         equ    %00100000
mTTOV_TOV6:         equ    %01000000
mTTOV_TOV7:         equ    %10000000


;*** TCTL1 - Timer Control Register 1; 0x00000048 ***
TCTL1:              equ    $00000048                                ;*** TCTL1 - Timer Control Register 1; 0x00000048 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TCTL1_OL4:          equ    0                                         ; Output Level Bit 4
TCTL1_OM4:          equ    1                                         ; Output Mode Bit 4
TCTL1_OL5:          equ    2                                         ; Output Level Bit 5
TCTL1_OM5:          equ    3                                         ; Output Mode Bit 5
TCTL1_OL6:          equ    4                                         ; Output Level Bit 6
TCTL1_OM6:          equ    5                                         ; Output Mode Bit 6
TCTL1_OL7:          equ    6                                         ; Output Level Bit 7
TCTL1_OM7:          equ    7                                         ; Output Mode Bit 7
; bit position masks
mTCTL1_OL4:         equ    %00000001
mTCTL1_OM4:         equ    %00000010
mTCTL1_OL5:         equ    %00000100
mTCTL1_OM5:         equ    %00001000
mTCTL1_OL6:         equ    %00010000
mTCTL1_OM6:         equ    %00100000
mTCTL1_OL7:         equ    %01000000
mTCTL1_OM7:         equ    %10000000


;*** TCTL3 - Timer Control Register 3; 0x0000004A ***
TCTL3:              equ    $0000004A                                ;*** TCTL3 - Timer Control Register 3; 0x0000004A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TCTL3_EDG4A:        equ    0                                         ; Input Capture Edge Control 4A
TCTL3_EDG4B:        equ    1                                         ; Input Capture Edge Control 4B
TCTL3_EDG5A:        equ    2                                         ; Input Capture Edge Control 5A
TCTL3_EDG5B:        equ    3                                         ; Input Capture Edge Control 5B
TCTL3_EDG6A:        equ    4                                         ; Input Capture Edge Control 6A
TCTL3_EDG6B:        equ    5                                         ; Input Capture Edge Control 6B
TCTL3_EDG7A:        equ    6                                         ; Input Capture Edge Control 7A
TCTL3_EDG7B:        equ    7                                         ; Input Capture Edge Control 7B
; bit position masks
mTCTL3_EDG4A:       equ    %00000001
mTCTL3_EDG4B:       equ    %00000010
mTCTL3_EDG5A:       equ    %00000100
mTCTL3_EDG5B:       equ    %00001000
mTCTL3_EDG6A:       equ    %00010000
mTCTL3_EDG6B:       equ    %00100000
mTCTL3_EDG7A:       equ    %01000000
mTCTL3_EDG7B:       equ    %10000000


;*** TIE - Timer Interrupt Enable Register; 0x0000004C ***
TIE:                equ    $0000004C                                ;*** TIE - Timer Interrupt Enable Register; 0x0000004C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TIE_C4I:            equ    4                                         ; Input Capture/Output Compare Interrupt Enable Bit 4
TIE_C5I:            equ    5                                         ; Input Capture/Output Compare Interrupt Enable Bit 5
TIE_C6I:            equ    6                                         ; Input Capture/Output Compare Interrupt Enable Bit 6
TIE_C7I:            equ    7                                         ; Input Capture/Output Compare Interrupt Enable Bit 7
; bit position masks
mTIE_C4I:           equ    %00010000
mTIE_C5I:           equ    %00100000
mTIE_C6I:           equ    %01000000
mTIE_C7I:           equ    %10000000


;*** TSCR2 - Timer System Control Register 2; 0x0000004D ***
TSCR2:              equ    $0000004D                                ;*** TSCR2 - Timer System Control Register 2; 0x0000004D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TSCR2_PR0:          equ    0                                         ; Timer Prescaler Select Bit 0
TSCR2_PR1:          equ    1                                         ; Timer Prescaler Select Bit 1
TSCR2_PR2:          equ    2                                         ; Timer Prescaler Select Bit 2
TSCR2_TCRE:         equ    3                                         ; Timer Counter Reset Enable
TSCR2_TOI:          equ    7                                         ; Timer Overflow Interrupt Enable
; bit position masks
mTSCR2_PR0:         equ    %00000001
mTSCR2_PR1:         equ    %00000010
mTSCR2_PR2:         equ    %00000100
mTSCR2_TCRE:        equ    %00001000
mTSCR2_TOI:         equ    %10000000


;*** TFLG1 - Main Timer Interrupt Flag 1; 0x0000004E ***
TFLG1:              equ    $0000004E                                ;*** TFLG1 - Main Timer Interrupt Flag 1; 0x0000004E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TFLG1_C4F:          equ    4                                         ; Input Capture/Output Compare Channel Flag 4
TFLG1_C5F:          equ    5                                         ; Input Capture/Output Compare Channel Flag 5
TFLG1_C6F:          equ    6                                         ; Input Capture/Output Compare Channel Flag 6
TFLG1_C7F:          equ    7                                         ; Input Capture/Output Compare Channel Flag 7
; bit position masks
mTFLG1_C4F:         equ    %00010000
mTFLG1_C5F:         equ    %00100000
mTFLG1_C6F:         equ    %01000000
mTFLG1_C7F:         equ    %10000000


;*** TFLG2 - Main Timer Interrupt Flag 2; 0x0000004F ***
TFLG2:              equ    $0000004F                                ;*** TFLG2 - Main Timer Interrupt Flag 2; 0x0000004F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TFLG2_TOF:          equ    7                                         ; Timer Overflow Flag
; bit position masks
mTFLG2_TOF:         equ    %10000000


;*** TC4 - Timer Input Capture/Output Compare Register 4; 0x00000058 ***
TC4:                equ    $00000058                                ;*** TC4 - Timer Input Capture/Output Compare Register 4; 0x00000058 ***


;*** TC4Hi - Timer Input Capture/Output Compare Register 4 High; 0x00000058 ***
TC4Hi:              equ    $00000058                                ;*** TC4Hi - Timer Input Capture/Output Compare Register 4 High; 0x00000058 ***


;*** TC4Lo - Timer Input Capture/Output Compare Register 4 Low; 0x00000059 ***
TC4Lo:              equ    $00000059                                ;*** TC4Lo - Timer Input Capture/Output Compare Register 4 Low; 0x00000059 ***


;*** TC5 - Timer Input Capture/Output Compare Register 5; 0x0000005A ***
TC5:                equ    $0000005A                                ;*** TC5 - Timer Input Capture/Output Compare Register 5; 0x0000005A ***


;*** TC5Hi - Timer Input Capture/Output Compare Register 5 High; 0x0000005A ***
TC5Hi:              equ    $0000005A                                ;*** TC5Hi - Timer Input Capture/Output Compare Register 5 High; 0x0000005A ***


;*** TC5Lo - Timer Input Capture/Output Compare Register 5 Low; 0x0000005B ***
TC5Lo:              equ    $0000005B                                ;*** TC5Lo - Timer Input Capture/Output Compare Register 5 Low; 0x0000005B ***


;*** TC6 - Timer Input Capture/Output Compare Register 6; 0x0000005C ***
TC6:                equ    $0000005C                                ;*** TC6 - Timer Input Capture/Output Compare Register 6; 0x0000005C ***


;*** TC6Hi - Timer Input Capture/Output Compare Register 6 High; 0x0000005C ***
TC6Hi:              equ    $0000005C                                ;*** TC6Hi - Timer Input Capture/Output Compare Register 6 High; 0x0000005C ***


;*** TC6Lo - Timer Input Capture/Output Compare Register 6 Low; 0x0000005D ***
TC6Lo:              equ    $0000005D                                ;*** TC6Lo - Timer Input Capture/Output Compare Register 6 Low; 0x0000005D ***


;*** TC7 - Timer Input Capture/Output Compare Register 7; 0x0000005E ***
TC7:                equ    $0000005E                                ;*** TC7 - Timer Input Capture/Output Compare Register 7; 0x0000005E ***


;*** TC7Hi - Timer Input Capture/Output Compare Register 7 High; 0x0000005E ***
TC7Hi:              equ    $0000005E                                ;*** TC7Hi - Timer Input Capture/Output Compare Register 7 High; 0x0000005E ***


;*** TC7Lo - Timer Input Capture/Output Compare Register 7 Low; 0x0000005F ***
TC7Lo:              equ    $0000005F                                ;*** TC7Lo - Timer Input Capture/Output Compare Register 7 Low; 0x0000005F ***


;*** PACTL - 16-Bit Pulse Accumulator A Control Register; 0x00000060 ***
PACTL:              equ    $00000060                                ;*** PACTL - 16-Bit Pulse Accumulator A Control Register; 0x00000060 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PACTL_PAI:          equ    0                                         ; Pulse Accumulator Input Interrupt enable
PACTL_PAOVI:        equ    1                                         ; Pulse Accumulator A Overflow Interrupt enable
PACTL_CLK0:         equ    2                                         ; Clock Select Bit 0
PACTL_CLK1:         equ    3                                         ; Clock Select Bit 1
PACTL_PEDGE:        equ    4                                         ; Pulse Accumulator Edge Control
PACTL_PAMOD:        equ    5                                         ; Pulse Accumulator Mode
PACTL_PAEN:         equ    6                                         ; Pulse Accumulator A System Enable
; bit position masks
mPACTL_PAI:         equ    %00000001
mPACTL_PAOVI:       equ    %00000010
mPACTL_CLK0:        equ    %00000100
mPACTL_CLK1:        equ    %00001000
mPACTL_PEDGE:       equ    %00010000
mPACTL_PAMOD:       equ    %00100000
mPACTL_PAEN:        equ    %01000000


;*** PAFLG - Pulse Accumulator A Flag Register; 0x00000061 ***
PAFLG:              equ    $00000061                                ;*** PAFLG - Pulse Accumulator A Flag Register; 0x00000061 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PAFLG_PAIF:         equ    0                                         ; Pulse Accumulator Input edge Flag
PAFLG_PAOVF:        equ    1                                         ; Pulse Accumulator A Overflow Flag
; bit position masks
mPAFLG_PAIF:        equ    %00000001
mPAFLG_PAOVF:       equ    %00000010


;*** PACNT - Pulse Accumulators Count Register; 0x00000062 ***
PACNT:              equ    $00000062                                ;*** PACNT - Pulse Accumulators Count Register; 0x00000062 ***


;*** ATDCTL01 - ATD Control Register 01; 0x00000080 ***
ATDCTL01:           equ    $00000080                                ;*** ATDCTL01 - ATD Control Register 01; 0x00000080 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDCTL01_ETRIGCH0:  equ    0                                         ; External Trigger Channel Select Bit 0
ATDCTL01_ETRIGCH1:  equ    1                                         ; External Trigger Channel Select Bit 1
ATDCTL01_ETRIGCH2:  equ    2                                         ; External Trigger Channel Select Bit 2
ATDCTL01_ETRIGCH3:  equ    3                                         ; External Trigger Channel Select Bit 3
ATDCTL01_ETRIGSEL:  equ    7                                         ; External Trigger Source Select
ATDCTL01_WRAP0:     equ    8                                         ; Wrap Around Channel Select Bit 0
ATDCTL01_WRAP1:     equ    9                                         ; Wrap Around Channel Select Bit 1
ATDCTL01_WRAP2:     equ    10                                        ; Wrap Around Channel Select Bit 2
ATDCTL01_WRAP3:     equ    11                                        ; Wrap Around Channel Select Bit 3
; bit position masks
mATDCTL01_ETRIGCH0: equ    %00000001
mATDCTL01_ETRIGCH1: equ    %00000010
mATDCTL01_ETRIGCH2: equ    %00000100
mATDCTL01_ETRIGCH3: equ    %00001000
mATDCTL01_ETRIGSEL: equ    %10000000
mATDCTL01_WRAP0:    equ    %100000000
mATDCTL01_WRAP1:    equ    %1000000000
mATDCTL01_WRAP2:    equ    %10000000000
mATDCTL01_WRAP3:    equ    %100000000000


;*** ATDCTL0 - ATD Control Register 0; 0x00000080 ***
ATDCTL0:            equ    $00000080                                ;*** ATDCTL0 - ATD Control Register 0; 0x00000080 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDCTL0_WRAP0:      equ    0                                         ; Wrap Around Channel Select Bit 0
ATDCTL0_WRAP1:      equ    1                                         ; Wrap Around Channel Select Bit 1
ATDCTL0_WRAP2:      equ    2                                         ; Wrap Around Channel Select Bit 2
ATDCTL0_WRAP3:      equ    3                                         ; Wrap Around Channel Select Bit 3
; bit position masks
mATDCTL0_WRAP0:     equ    %00000001
mATDCTL0_WRAP1:     equ    %00000010
mATDCTL0_WRAP2:     equ    %00000100
mATDCTL0_WRAP3:     equ    %00001000


;*** ATDCTL1 - ATD Control Register 1; 0x00000081 ***
ATDCTL1:            equ    $00000081                                ;*** ATDCTL1 - ATD Control Register 1; 0x00000081 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDCTL1_ETRIGCH0:   equ    0                                         ; External Trigger Channel Select Bit 0
ATDCTL1_ETRIGCH1:   equ    1                                         ; External Trigger Channel Select Bit 1
ATDCTL1_ETRIGCH2:   equ    2                                         ; External Trigger Channel Select Bit 2
ATDCTL1_ETRIGCH3:   equ    3                                         ; External Trigger Channel Select Bit 3
ATDCTL1_ETRIGSEL:   equ    7                                         ; External Trigger Source Select
; bit position masks
mATDCTL1_ETRIGCH0:  equ    %00000001
mATDCTL1_ETRIGCH1:  equ    %00000010
mATDCTL1_ETRIGCH2:  equ    %00000100
mATDCTL1_ETRIGCH3:  equ    %00001000
mATDCTL1_ETRIGSEL:  equ    %10000000


;*** ATDCTL23 - ATD Control Register 23; 0x00000082 ***
ATDCTL23:           equ    $00000082                                ;*** ATDCTL23 - ATD Control Register 23; 0x00000082 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDCTL23_FRZ0:      equ    0                                         ; Background Debug Freeze Enable Bit 0
ATDCTL23_FRZ1:      equ    1                                         ; Background Debug Freeze Enable Bit 1
ATDCTL23_FIFO:      equ    2                                         ; Result Register FIFO Mode
ATDCTL23_S1C:       equ    3                                         ; Conversion Sequence Length 1
ATDCTL23_S2C:       equ    4                                         ; Conversion Sequence Length 2
ATDCTL23_S4C:       equ    5                                         ; Conversion Sequence Length 4
ATDCTL23_S8C:       equ    6                                         ; Conversion Sequence Length 8
ATDCTL23_ASCIF:     equ    8                                         ; ATD Sequence Complete Interrupt Flag
ATDCTL23_ASCIE:     equ    9                                         ; ATD Sequence Complete Interrupt Enable
ATDCTL23_ETRIGE:    equ    10                                        ; External Trigger Mode enable
ATDCTL23_ETRIGP:    equ    11                                        ; External Trigger Polarity
ATDCTL23_ETRIGLE:   equ    12                                        ; External Trigger Level/Edge control
ATDCTL23_AWAI:      equ    13                                        ; ATD Power Down in Wait Mode
ATDCTL23_AFFC:      equ    14                                        ; ATD Fast Conversion Complete Flag Clear
ATDCTL23_ADPU:      equ    15                                        ; ATD Disable / Power Down
; bit position masks
mATDCTL23_FRZ0:     equ    %00000001
mATDCTL23_FRZ1:     equ    %00000010
mATDCTL23_FIFO:     equ    %00000100
mATDCTL23_S1C:      equ    %00001000
mATDCTL23_S2C:      equ    %00010000
mATDCTL23_S4C:      equ    %00100000
mATDCTL23_S8C:      equ    %01000000
mATDCTL23_ASCIF:    equ    %100000000
mATDCTL23_ASCIE:    equ    %1000000000
mATDCTL23_ETRIGE:   equ    %10000000000
mATDCTL23_ETRIGP:   equ    %100000000000
mATDCTL23_ETRIGLE:  equ    %1000000000000
mATDCTL23_AWAI:     equ    %10000000000000
mATDCTL23_AFFC:     equ    %100000000000000
mATDCTL23_ADPU:     equ    %1000000000000000


;*** ATDCTL2 - ATD Control Register 2; 0x00000082 ***
ATDCTL2:            equ    $00000082                                ;*** ATDCTL2 - ATD Control Register 2; 0x00000082 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDCTL2_ASCIF:      equ    0                                         ; ATD Sequence Complete Interrupt Flag
ATDCTL2_ASCIE:      equ    1                                         ; ATD Sequence Complete Interrupt Enable
ATDCTL2_ETRIGE:     equ    2                                         ; External Trigger Mode enable
ATDCTL2_ETRIGP:     equ    3                                         ; External Trigger Polarity
ATDCTL2_ETRIGLE:    equ    4                                         ; External Trigger Level/Edge control
ATDCTL2_AWAI:       equ    5                                         ; ATD Power Down in Wait Mode
ATDCTL2_AFFC:       equ    6                                         ; ATD Fast Conversion Complete Flag Clear
ATDCTL2_ADPU:       equ    7                                         ; ATD Disable / Power Down
; bit position masks
mATDCTL2_ASCIF:     equ    %00000001
mATDCTL2_ASCIE:     equ    %00000010
mATDCTL2_ETRIGE:    equ    %00000100
mATDCTL2_ETRIGP:    equ    %00001000
mATDCTL2_ETRIGLE:   equ    %00010000
mATDCTL2_AWAI:      equ    %00100000
mATDCTL2_AFFC:      equ    %01000000
mATDCTL2_ADPU:      equ    %10000000


;*** ATDCTL3 - ATD Control Register 3; 0x00000083 ***
ATDCTL3:            equ    $00000083                                ;*** ATDCTL3 - ATD Control Register 3; 0x00000083 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDCTL3_FRZ0:       equ    0                                         ; Background Debug Freeze Enable Bit 0
ATDCTL3_FRZ1:       equ    1                                         ; Background Debug Freeze Enable Bit 1
ATDCTL3_FIFO:       equ    2                                         ; Result Register FIFO Mode
ATDCTL3_S1C:        equ    3                                         ; Conversion Sequence Length 1
ATDCTL3_S2C:        equ    4                                         ; Conversion Sequence Length 2
ATDCTL3_S4C:        equ    5                                         ; Conversion Sequence Length 4
ATDCTL3_S8C:        equ    6                                         ; Conversion Sequence Length 8
; bit position masks
mATDCTL3_FRZ0:      equ    %00000001
mATDCTL3_FRZ1:      equ    %00000010
mATDCTL3_FIFO:      equ    %00000100
mATDCTL3_S1C:       equ    %00001000
mATDCTL3_S2C:       equ    %00010000
mATDCTL3_S4C:       equ    %00100000
mATDCTL3_S8C:       equ    %01000000


;*** ATDCTL45 - ATD Control Register 45; 0x00000084 ***
ATDCTL45:           equ    $00000084                                ;*** ATDCTL45 - ATD Control Register 45; 0x00000084 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDCTL45_CA:        equ    0                                         ; Analog Input Channel Select Code A
ATDCTL45_CB:        equ    1                                         ; Analog Input Channel Select Code B
ATDCTL45_CC:        equ    2                                         ; Analog Input Channel Select Code C
ATDCTL45_MULT:      equ    4                                         ; Multi-Channel Sample Mode
ATDCTL45_SCAN:      equ    5                                         ; Continuous Conversion Sequence Mode
ATDCTL45_DSGN:      equ    6                                         ; Signed/Unsigned Result Data Mode
ATDCTL45_DJM:       equ    7                                         ; Result Register Data Justification Mode
ATDCTL45_PRS0:      equ    8                                         ; ATD Clock Prescaler 0
ATDCTL45_PRS1:      equ    9                                         ; ATD Clock Prescaler 1
ATDCTL45_PRS2:      equ    10                                        ; ATD Clock Prescaler 2
ATDCTL45_PRS3:      equ    11                                        ; ATD Clock Prescaler 3
ATDCTL45_PRS4:      equ    12                                        ; ATD Clock Prescaler 4
ATDCTL45_SMP0:      equ    13                                        ; Sample Time Select 0
ATDCTL45_SMP1:      equ    14                                        ; Sample Time Select 1
ATDCTL45_SRES8:     equ    15                                        ; ATD Resolution Select
; bit position masks
mATDCTL45_CA:       equ    %00000001
mATDCTL45_CB:       equ    %00000010
mATDCTL45_CC:       equ    %00000100
mATDCTL45_MULT:     equ    %00010000
mATDCTL45_SCAN:     equ    %00100000
mATDCTL45_DSGN:     equ    %01000000
mATDCTL45_DJM:      equ    %10000000
mATDCTL45_PRS0:     equ    %100000000
mATDCTL45_PRS1:     equ    %1000000000
mATDCTL45_PRS2:     equ    %10000000000
mATDCTL45_PRS3:     equ    %100000000000
mATDCTL45_PRS4:     equ    %1000000000000
mATDCTL45_SMP0:     equ    %10000000000000
mATDCTL45_SMP1:     equ    %100000000000000
mATDCTL45_SRES8:    equ    %1000000000000000


;*** ATDCTL4 - ATD Control Register 4; 0x00000084 ***
ATDCTL4:            equ    $00000084                                ;*** ATDCTL4 - ATD Control Register 4; 0x00000084 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDCTL4_PRS0:       equ    0                                         ; ATD Clock Prescaler 0
ATDCTL4_PRS1:       equ    1                                         ; ATD Clock Prescaler 1
ATDCTL4_PRS2:       equ    2                                         ; ATD Clock Prescaler 2
ATDCTL4_PRS3:       equ    3                                         ; ATD Clock Prescaler 3
ATDCTL4_PRS4:       equ    4                                         ; ATD Clock Prescaler 4
ATDCTL4_SMP0:       equ    5                                         ; Sample Time Select 0
ATDCTL4_SMP1:       equ    6                                         ; Sample Time Select 1
ATDCTL4_SRES8:      equ    7                                         ; ATD Resolution Select
; bit position masks
mATDCTL4_PRS0:      equ    %00000001
mATDCTL4_PRS1:      equ    %00000010
mATDCTL4_PRS2:      equ    %00000100
mATDCTL4_PRS3:      equ    %00001000
mATDCTL4_PRS4:      equ    %00010000
mATDCTL4_SMP0:      equ    %00100000
mATDCTL4_SMP1:      equ    %01000000
mATDCTL4_SRES8:     equ    %10000000


;*** ATDCTL5 - ATD Control Register 5; 0x00000085 ***
ATDCTL5:            equ    $00000085                                ;*** ATDCTL5 - ATD Control Register 5; 0x00000085 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDCTL5_CA:         equ    0                                         ; Analog Input Channel Select Code A
ATDCTL5_CB:         equ    1                                         ; Analog Input Channel Select Code B
ATDCTL5_CC:         equ    2                                         ; Analog Input Channel Select Code C
ATDCTL5_MULT:       equ    4                                         ; Multi-Channel Sample Mode
ATDCTL5_SCAN:       equ    5                                         ; Continuous Conversion Sequence Mode
ATDCTL5_DSGN:       equ    6                                         ; Signed/Unsigned Result Data Mode
ATDCTL5_DJM:        equ    7                                         ; Result Register Data Justification Mode
; bit position masks
mATDCTL5_CA:        equ    %00000001
mATDCTL5_CB:        equ    %00000010
mATDCTL5_CC:        equ    %00000100
mATDCTL5_MULT:      equ    %00010000
mATDCTL5_SCAN:      equ    %00100000
mATDCTL5_DSGN:      equ    %01000000
mATDCTL5_DJM:       equ    %10000000


;*** ATDSTAT0 - ATD Status Register 0; 0x00000086 ***
ATDSTAT0:           equ    $00000086                                ;*** ATDSTAT0 - ATD Status Register 0; 0x00000086 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDSTAT0_CC0:       equ    0                                         ; Conversion Counter 0
ATDSTAT0_CC1:       equ    1                                         ; Conversion Counter 1
ATDSTAT0_CC2:       equ    2                                         ; Conversion Counter 2
ATDSTAT0_FIFOR:     equ    4                                         ; FIFO Over Run Flag
ATDSTAT0_ETORF:     equ    5                                         ; External Trigger Overrun Flag
ATDSTAT0_SCF:       equ    7                                         ; Sequence Complete Flag
; bit position masks
mATDSTAT0_CC0:      equ    %00000001
mATDSTAT0_CC1:      equ    %00000010
mATDSTAT0_CC2:      equ    %00000100
mATDSTAT0_FIFOR:    equ    %00010000
mATDSTAT0_ETORF:    equ    %00100000
mATDSTAT0_SCF:      equ    %10000000


;*** ATDTEST1 - ATD Test Register; 0x00000089 ***
ATDTEST1:           equ    $00000089                                ;*** ATDTEST1 - ATD Test Register; 0x00000089 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDTEST1_SC:        equ    0                                         ; Special Channel Conversion Bit
; bit position masks
mATDTEST1_SC:       equ    %00000001


;*** ATDSTAT1 - ATD Status Register 1; 0x0000008B ***
ATDSTAT1:           equ    $0000008B                                ;*** ATDSTAT1 - ATD Status Register 1; 0x0000008B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDSTAT1_CCF0:      equ    0                                         ; Conversion Complete Flag 0
ATDSTAT1_CCF1:      equ    1                                         ; Conversion Complete Flag 1
ATDSTAT1_CCF2:      equ    2                                         ; Conversion Complete Flag 2
ATDSTAT1_CCF3:      equ    3                                         ; Conversion Complete Flag 3
ATDSTAT1_CCF4:      equ    4                                         ; Conversion Complete Flag 4
ATDSTAT1_CCF5:      equ    5                                         ; Conversion Complete Flag 5
ATDSTAT1_CCF6:      equ    6                                         ; Conversion Complete Flag 6
ATDSTAT1_CCF7:      equ    7                                         ; Conversion Complete Flag 7
; bit position masks
mATDSTAT1_CCF0:     equ    %00000001
mATDSTAT1_CCF1:     equ    %00000010
mATDSTAT1_CCF2:     equ    %00000100
mATDSTAT1_CCF3:     equ    %00001000
mATDSTAT1_CCF4:     equ    %00010000
mATDSTAT1_CCF5:     equ    %00100000
mATDSTAT1_CCF6:     equ    %01000000
mATDSTAT1_CCF7:     equ    %10000000


;*** ATDDIEN - ATD Input Enable Register; 0x0000008D ***
ATDDIEN:            equ    $0000008D                                ;*** ATDDIEN - ATD Input Enable Register; 0x0000008D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDIEN_IEN0:       equ    0                                         ; ATD Digital Input Enable on channel 0
ATDDIEN_IEN1:       equ    1                                         ; ATD Digital Input Enable on channel 1
ATDDIEN_IEN2:       equ    2                                         ; ATD Digital Input Enable on channel 2
ATDDIEN_IEN3:       equ    3                                         ; ATD Digital Input Enable on channel 3
ATDDIEN_IEN4:       equ    4                                         ; ATD Digital Input Enable on channel 4
ATDDIEN_IEN5:       equ    5                                         ; ATD Digital Input Enable on channel 5
ATDDIEN_IEN6:       equ    6                                         ; ATD Digital Input Enable on channel 6
ATDDIEN_IEN7:       equ    7                                         ; ATD Digital Input Enable on channel 7
; bit position masks
mATDDIEN_IEN0:      equ    %00000001
mATDDIEN_IEN1:      equ    %00000010
mATDDIEN_IEN2:      equ    %00000100
mATDDIEN_IEN3:      equ    %00001000
mATDDIEN_IEN4:      equ    %00010000
mATDDIEN_IEN5:      equ    %00100000
mATDDIEN_IEN6:      equ    %01000000
mATDDIEN_IEN7:      equ    %10000000


;*** PORTAD - Port AD Data Register; 0x0000008F ***
PORTAD:             equ    $0000008F                                ;*** PORTAD - Port AD Data Register; 0x0000008F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PORTAD_PTAD0:       equ    0                                         ; A/D Channel 0 (AN0) Digital Input
PORTAD_PTAD1:       equ    1                                         ; A/D Channel 1 (AN1) Digital Input
PORTAD_PTAD2:       equ    2                                         ; A/D Channel 2 (AN2) Digital Input
PORTAD_PTAD3:       equ    3                                         ; A/D Channel 3 (AN3) Digital Input
PORTAD_PTAD4:       equ    4                                         ; A/D Channel 4 (AN4) Digital Input
PORTAD_PTAD5:       equ    5                                         ; A/D Channel 5 (AN5) Digital Input
PORTAD_PTAD6:       equ    6                                         ; A/D Channel 6 (AN6) Digital Input
PORTAD_PTAD7:       equ    7                                         ; A/D Channel 7 (AN7) Digital Input
; bit position masks
mPORTAD_PTAD0:      equ    %00000001
mPORTAD_PTAD1:      equ    %00000010
mPORTAD_PTAD2:      equ    %00000100
mPORTAD_PTAD3:      equ    %00001000
mPORTAD_PTAD4:      equ    %00010000
mPORTAD_PTAD5:      equ    %00100000
mPORTAD_PTAD6:      equ    %01000000
mPORTAD_PTAD7:      equ    %10000000


;*** ATDDR0 - ATD Conversion Result Register 0; 0x00000090 ***
ATDDR0:             equ    $00000090                                ;*** ATDDR0 - ATD Conversion Result Register 0; 0x00000090 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR0_BIT6:        equ    6                                         ; Bit 6
ATDDR0_BIT7:        equ    7                                         ; Bit 7
ATDDR0_BIT8:        equ    8                                         ; Bit 8
ATDDR0_BIT9:        equ    9                                         ; Bit 9
ATDDR0_BIT10:       equ    10                                        ; Bit 10
ATDDR0_BIT11:       equ    11                                        ; Bit 11
ATDDR0_BIT12:       equ    12                                        ; Bit 12
ATDDR0_BIT13:       equ    13                                        ; Bit 13
ATDDR0_BIT14:       equ    14                                        ; Bit 14
ATDDR0_BIT15:       equ    15                                        ; Bit 15
; bit position masks
mATDDR0_BIT6:       equ    %01000000
mATDDR0_BIT7:       equ    %10000000
mATDDR0_BIT8:       equ    %100000000
mATDDR0_BIT9:       equ    %1000000000
mATDDR0_BIT10:      equ    %10000000000
mATDDR0_BIT11:      equ    %100000000000
mATDDR0_BIT12:      equ    %1000000000000
mATDDR0_BIT13:      equ    %10000000000000
mATDDR0_BIT14:      equ    %100000000000000
mATDDR0_BIT15:      equ    %1000000000000000


;*** ATDDR0H - ATD Conversion Result Register 0 High; 0x00000090 ***
ATDDR0H:            equ    $00000090                                ;*** ATDDR0H - ATD Conversion Result Register 0 High; 0x00000090 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR0H_BIT8:       equ    0                                         ; Bit 8
ATDDR0H_BIT9:       equ    1                                         ; Bit 9
ATDDR0H_BIT10:      equ    2                                         ; Bit 10
ATDDR0H_BIT11:      equ    3                                         ; Bit 11
ATDDR0H_BIT12:      equ    4                                         ; Bit 12
ATDDR0H_BIT13:      equ    5                                         ; Bit 13
ATDDR0H_BIT14:      equ    6                                         ; Bit 14
ATDDR0H_BIT15:      equ    7                                         ; Bit 15
; bit position masks
mATDDR0H_BIT8:      equ    %00000001
mATDDR0H_BIT9:      equ    %00000010
mATDDR0H_BIT10:     equ    %00000100
mATDDR0H_BIT11:     equ    %00001000
mATDDR0H_BIT12:     equ    %00010000
mATDDR0H_BIT13:     equ    %00100000
mATDDR0H_BIT14:     equ    %01000000
mATDDR0H_BIT15:     equ    %10000000


;*** ATDDR0L - ATD Conversion Result Register 0 Low; 0x00000091 ***
ATDDR0L:            equ    $00000091                                ;*** ATDDR0L - ATD Conversion Result Register 0 Low; 0x00000091 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR0L_BIT6:       equ    6                                         ; Bit 6
ATDDR0L_BIT7:       equ    7                                         ; Bit 7
; bit position masks
mATDDR0L_BIT6:      equ    %01000000
mATDDR0L_BIT7:      equ    %10000000


;*** ATDDR1 - ATD Conversion Result Register 1; 0x00000092 ***
ATDDR1:             equ    $00000092                                ;*** ATDDR1 - ATD Conversion Result Register 1; 0x00000092 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR1_BIT6:        equ    6                                         ; Bit 6
ATDDR1_BIT7:        equ    7                                         ; Bit 7
ATDDR1_BIT8:        equ    8                                         ; Bit 8
ATDDR1_BIT9:        equ    9                                         ; Bit 9
ATDDR1_BIT10:       equ    10                                        ; Bit 10
ATDDR1_BIT11:       equ    11                                        ; Bit 11
ATDDR1_BIT12:       equ    12                                        ; Bit 12
ATDDR1_BIT13:       equ    13                                        ; Bit 13
ATDDR1_BIT14:       equ    14                                        ; Bit 14
ATDDR1_BIT15:       equ    15                                        ; Bit 15
; bit position masks
mATDDR1_BIT6:       equ    %01000000
mATDDR1_BIT7:       equ    %10000000
mATDDR1_BIT8:       equ    %100000000
mATDDR1_BIT9:       equ    %1000000000
mATDDR1_BIT10:      equ    %10000000000
mATDDR1_BIT11:      equ    %100000000000
mATDDR1_BIT12:      equ    %1000000000000
mATDDR1_BIT13:      equ    %10000000000000
mATDDR1_BIT14:      equ    %100000000000000
mATDDR1_BIT15:      equ    %1000000000000000


;*** ATDDR1H - ATD Conversion Result Register 1 High; 0x00000092 ***
ATDDR1H:            equ    $00000092                                ;*** ATDDR1H - ATD Conversion Result Register 1 High; 0x00000092 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR1H_BIT8:       equ    0                                         ; Bit 8
ATDDR1H_BIT9:       equ    1                                         ; Bit 9
ATDDR1H_BIT10:      equ    2                                         ; Bit 10
ATDDR1H_BIT11:      equ    3                                         ; Bit 11
ATDDR1H_BIT12:      equ    4                                         ; Bit 12
ATDDR1H_BIT13:      equ    5                                         ; Bit 13
ATDDR1H_BIT14:      equ    6                                         ; Bit 14
ATDDR1H_BIT15:      equ    7                                         ; Bit 15
; bit position masks
mATDDR1H_BIT8:      equ    %00000001
mATDDR1H_BIT9:      equ    %00000010
mATDDR1H_BIT10:     equ    %00000100
mATDDR1H_BIT11:     equ    %00001000
mATDDR1H_BIT12:     equ    %00010000
mATDDR1H_BIT13:     equ    %00100000
mATDDR1H_BIT14:     equ    %01000000
mATDDR1H_BIT15:     equ    %10000000


;*** ATDDR1L - ATD Conversion Result Register 1 Low; 0x00000093 ***
ATDDR1L:            equ    $00000093                                ;*** ATDDR1L - ATD Conversion Result Register 1 Low; 0x00000093 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR1L_BIT6:       equ    6                                         ; Bit 6
ATDDR1L_BIT7:       equ    7                                         ; Bit 7
; bit position masks
mATDDR1L_BIT6:      equ    %01000000
mATDDR1L_BIT7:      equ    %10000000


;*** ATDDR2 - ATD Conversion Result Register 2; 0x00000094 ***
ATDDR2:             equ    $00000094                                ;*** ATDDR2 - ATD Conversion Result Register 2; 0x00000094 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR2_BIT6:        equ    6                                         ; Bit 6
ATDDR2_BIT7:        equ    7                                         ; Bit 7
ATDDR2_BIT8:        equ    8                                         ; Bit 8
ATDDR2_BIT9:        equ    9                                         ; Bit 9
ATDDR2_BIT10:       equ    10                                        ; Bit 10
ATDDR2_BIT11:       equ    11                                        ; Bit 11
ATDDR2_BIT12:       equ    12                                        ; Bit 12
ATDDR2_BIT13:       equ    13                                        ; Bit 13
ATDDR2_BIT14:       equ    14                                        ; Bit 14
ATDDR2_BIT15:       equ    15                                        ; Bit 15
; bit position masks
mATDDR2_BIT6:       equ    %01000000
mATDDR2_BIT7:       equ    %10000000
mATDDR2_BIT8:       equ    %100000000
mATDDR2_BIT9:       equ    %1000000000
mATDDR2_BIT10:      equ    %10000000000
mATDDR2_BIT11:      equ    %100000000000
mATDDR2_BIT12:      equ    %1000000000000
mATDDR2_BIT13:      equ    %10000000000000
mATDDR2_BIT14:      equ    %100000000000000
mATDDR2_BIT15:      equ    %1000000000000000


;*** ATDDR2H - ATD Conversion Result Register 2 High; 0x00000094 ***
ATDDR2H:            equ    $00000094                                ;*** ATDDR2H - ATD Conversion Result Register 2 High; 0x00000094 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR2H_BIT8:       equ    0                                         ; Bit 8
ATDDR2H_BIT9:       equ    1                                         ; Bit 9
ATDDR2H_BIT10:      equ    2                                         ; Bit 10
ATDDR2H_BIT11:      equ    3                                         ; Bit 11
ATDDR2H_BIT12:      equ    4                                         ; Bit 12
ATDDR2H_BIT13:      equ    5                                         ; Bit 13
ATDDR2H_BIT14:      equ    6                                         ; Bit 14
ATDDR2H_BIT15:      equ    7                                         ; Bit 15
; bit position masks
mATDDR2H_BIT8:      equ    %00000001
mATDDR2H_BIT9:      equ    %00000010
mATDDR2H_BIT10:     equ    %00000100
mATDDR2H_BIT11:     equ    %00001000
mATDDR2H_BIT12:     equ    %00010000
mATDDR2H_BIT13:     equ    %00100000
mATDDR2H_BIT14:     equ    %01000000
mATDDR2H_BIT15:     equ    %10000000


;*** ATDDR2L - ATD Conversion Result Register 2 Low; 0x00000095 ***
ATDDR2L:            equ    $00000095                                ;*** ATDDR2L - ATD Conversion Result Register 2 Low; 0x00000095 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR2L_BIT6:       equ    6                                         ; Bit 6
ATDDR2L_BIT7:       equ    7                                         ; Bit 7
; bit position masks
mATDDR2L_BIT6:      equ    %01000000
mATDDR2L_BIT7:      equ    %10000000


;*** ATDDR3 - ATD Conversion Result Register 3; 0x00000096 ***
ATDDR3:             equ    $00000096                                ;*** ATDDR3 - ATD Conversion Result Register 3; 0x00000096 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR3_BIT6:        equ    6                                         ; Bit 6
ATDDR3_BIT7:        equ    7                                         ; Bit 7
ATDDR3_BIT8:        equ    8                                         ; Bit 8
ATDDR3_BIT9:        equ    9                                         ; Bit 9
ATDDR3_BIT10:       equ    10                                        ; Bit 10
ATDDR3_BIT11:       equ    11                                        ; Bit 11
ATDDR3_BIT12:       equ    12                                        ; Bit 12
ATDDR3_BIT13:       equ    13                                        ; Bit 13
ATDDR3_BIT14:       equ    14                                        ; Bit 14
ATDDR3_BIT15:       equ    15                                        ; Bit 15
; bit position masks
mATDDR3_BIT6:       equ    %01000000
mATDDR3_BIT7:       equ    %10000000
mATDDR3_BIT8:       equ    %100000000
mATDDR3_BIT9:       equ    %1000000000
mATDDR3_BIT10:      equ    %10000000000
mATDDR3_BIT11:      equ    %100000000000
mATDDR3_BIT12:      equ    %1000000000000
mATDDR3_BIT13:      equ    %10000000000000
mATDDR3_BIT14:      equ    %100000000000000
mATDDR3_BIT15:      equ    %1000000000000000


;*** ATDDR3H - ATD Conversion Result Register 3 High; 0x00000096 ***
ATDDR3H:            equ    $00000096                                ;*** ATDDR3H - ATD Conversion Result Register 3 High; 0x00000096 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR3H_BIT8:       equ    0                                         ; Bit 8
ATDDR3H_BIT9:       equ    1                                         ; Bit 9
ATDDR3H_BIT10:      equ    2                                         ; Bit 10
ATDDR3H_BIT11:      equ    3                                         ; Bit 11
ATDDR3H_BIT12:      equ    4                                         ; Bit 12
ATDDR3H_BIT13:      equ    5                                         ; Bit 13
ATDDR3H_BIT14:      equ    6                                         ; Bit 14
ATDDR3H_BIT15:      equ    7                                         ; Bit 15
; bit position masks
mATDDR3H_BIT8:      equ    %00000001
mATDDR3H_BIT9:      equ    %00000010
mATDDR3H_BIT10:     equ    %00000100
mATDDR3H_BIT11:     equ    %00001000
mATDDR3H_BIT12:     equ    %00010000
mATDDR3H_BIT13:     equ    %00100000
mATDDR3H_BIT14:     equ    %01000000
mATDDR3H_BIT15:     equ    %10000000


;*** ATDDR3L - ATD Conversion Result Register 3 Low; 0x00000097 ***
ATDDR3L:            equ    $00000097                                ;*** ATDDR3L - ATD Conversion Result Register 3 Low; 0x00000097 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR3L_BIT6:       equ    6                                         ; Bit 6
ATDDR3L_BIT7:       equ    7                                         ; Bit 7
; bit position masks
mATDDR3L_BIT6:      equ    %01000000
mATDDR3L_BIT7:      equ    %10000000


;*** ATDDR4 - ATD Conversion Result Register 4; 0x00000098 ***
ATDDR4:             equ    $00000098                                ;*** ATDDR4 - ATD Conversion Result Register 4; 0x00000098 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR4_BIT6:        equ    6                                         ; Bit 6
ATDDR4_BIT7:        equ    7                                         ; Bit 7
ATDDR4_BIT8:        equ    8                                         ; Bit 8
ATDDR4_BIT9:        equ    9                                         ; Bit 9
ATDDR4_BIT10:       equ    10                                        ; Bit 10
ATDDR4_BIT11:       equ    11                                        ; Bit 11
ATDDR4_BIT12:       equ    12                                        ; Bit 12
ATDDR4_BIT13:       equ    13                                        ; Bit 13
ATDDR4_BIT14:       equ    14                                        ; Bit 14
ATDDR4_BIT15:       equ    15                                        ; Bit 15
; bit position masks
mATDDR4_BIT6:       equ    %01000000
mATDDR4_BIT7:       equ    %10000000
mATDDR4_BIT8:       equ    %100000000
mATDDR4_BIT9:       equ    %1000000000
mATDDR4_BIT10:      equ    %10000000000
mATDDR4_BIT11:      equ    %100000000000
mATDDR4_BIT12:      equ    %1000000000000
mATDDR4_BIT13:      equ    %10000000000000
mATDDR4_BIT14:      equ    %100000000000000
mATDDR4_BIT15:      equ    %1000000000000000


;*** ATDDR4H - ATD Conversion Result Register 4 High; 0x00000098 ***
ATDDR4H:            equ    $00000098                                ;*** ATDDR4H - ATD Conversion Result Register 4 High; 0x00000098 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR4H_BIT8:       equ    0                                         ; Bit 8
ATDDR4H_BIT9:       equ    1                                         ; Bit 9
ATDDR4H_BIT10:      equ    2                                         ; Bit 10
ATDDR4H_BIT11:      equ    3                                         ; Bit 11
ATDDR4H_BIT12:      equ    4                                         ; Bit 12
ATDDR4H_BIT13:      equ    5                                         ; Bit 13
ATDDR4H_BIT14:      equ    6                                         ; Bit 14
ATDDR4H_BIT15:      equ    7                                         ; Bit 15
; bit position masks
mATDDR4H_BIT8:      equ    %00000001
mATDDR4H_BIT9:      equ    %00000010
mATDDR4H_BIT10:     equ    %00000100
mATDDR4H_BIT11:     equ    %00001000
mATDDR4H_BIT12:     equ    %00010000
mATDDR4H_BIT13:     equ    %00100000
mATDDR4H_BIT14:     equ    %01000000
mATDDR4H_BIT15:     equ    %10000000


;*** ATDDR4L - ATD Conversion Result Register 4 Low; 0x00000099 ***
ATDDR4L:            equ    $00000099                                ;*** ATDDR4L - ATD Conversion Result Register 4 Low; 0x00000099 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR4L_BIT6:       equ    6                                         ; Bit 6
ATDDR4L_BIT7:       equ    7                                         ; Bit 7
; bit position masks
mATDDR4L_BIT6:      equ    %01000000
mATDDR4L_BIT7:      equ    %10000000


;*** ATDDR5 - ATD Conversion Result Register 5; 0x0000009A ***
ATDDR5:             equ    $0000009A                                ;*** ATDDR5 - ATD Conversion Result Register 5; 0x0000009A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR5_BIT6:        equ    6                                         ; Bit 6
ATDDR5_BIT7:        equ    7                                         ; Bit 7
ATDDR5_BIT8:        equ    8                                         ; Bit 8
ATDDR5_BIT9:        equ    9                                         ; Bit 9
ATDDR5_BIT10:       equ    10                                        ; Bit 10
ATDDR5_BIT11:       equ    11                                        ; Bit 11
ATDDR5_BIT12:       equ    12                                        ; Bit 12
ATDDR5_BIT13:       equ    13                                        ; Bit 13
ATDDR5_BIT14:       equ    14                                        ; Bit 14
ATDDR5_BIT15:       equ    15                                        ; Bit 15
; bit position masks
mATDDR5_BIT6:       equ    %01000000
mATDDR5_BIT7:       equ    %10000000
mATDDR5_BIT8:       equ    %100000000
mATDDR5_BIT9:       equ    %1000000000
mATDDR5_BIT10:      equ    %10000000000
mATDDR5_BIT11:      equ    %100000000000
mATDDR5_BIT12:      equ    %1000000000000
mATDDR5_BIT13:      equ    %10000000000000
mATDDR5_BIT14:      equ    %100000000000000
mATDDR5_BIT15:      equ    %1000000000000000


;*** ATDDR5H - ATD Conversion Result Register 5 High; 0x0000009A ***
ATDDR5H:            equ    $0000009A                                ;*** ATDDR5H - ATD Conversion Result Register 5 High; 0x0000009A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR5H_BIT8:       equ    0                                         ; Bit 8
ATDDR5H_BIT9:       equ    1                                         ; Bit 9
ATDDR5H_BIT10:      equ    2                                         ; Bit 10
ATDDR5H_BIT11:      equ    3                                         ; Bit 11
ATDDR5H_BIT12:      equ    4                                         ; Bit 12
ATDDR5H_BIT13:      equ    5                                         ; Bit 13
ATDDR5H_BIT14:      equ    6                                         ; Bit 14
ATDDR5H_BIT15:      equ    7                                         ; Bit 15
; bit position masks
mATDDR5H_BIT8:      equ    %00000001
mATDDR5H_BIT9:      equ    %00000010
mATDDR5H_BIT10:     equ    %00000100
mATDDR5H_BIT11:     equ    %00001000
mATDDR5H_BIT12:     equ    %00010000
mATDDR5H_BIT13:     equ    %00100000
mATDDR5H_BIT14:     equ    %01000000
mATDDR5H_BIT15:     equ    %10000000


;*** ATDDR5L - ATD Conversion Result Register 5 Low; 0x0000009B ***
ATDDR5L:            equ    $0000009B                                ;*** ATDDR5L - ATD Conversion Result Register 5 Low; 0x0000009B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR5L_BIT6:       equ    6                                         ; Bit 6
ATDDR5L_BIT7:       equ    7                                         ; Bit 7
; bit position masks
mATDDR5L_BIT6:      equ    %01000000
mATDDR5L_BIT7:      equ    %10000000


;*** ATDDR6 - ATD Conversion Result Register 6; 0x0000009C ***
ATDDR6:             equ    $0000009C                                ;*** ATDDR6 - ATD Conversion Result Register 6; 0x0000009C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR6_BIT6:        equ    6                                         ; Bit 6
ATDDR6_BIT7:        equ    7                                         ; Bit 7
ATDDR6_BIT8:        equ    8                                         ; Bit 8
ATDDR6_BIT9:        equ    9                                         ; Bit 9
ATDDR6_BIT10:       equ    10                                        ; Bit 10
ATDDR6_BIT11:       equ    11                                        ; Bit 11
ATDDR6_BIT12:       equ    12                                        ; Bit 12
ATDDR6_BIT13:       equ    13                                        ; Bit 13
ATDDR6_BIT14:       equ    14                                        ; Bit 14
ATDDR6_BIT15:       equ    15                                        ; Bit 15
; bit position masks
mATDDR6_BIT6:       equ    %01000000
mATDDR6_BIT7:       equ    %10000000
mATDDR6_BIT8:       equ    %100000000
mATDDR6_BIT9:       equ    %1000000000
mATDDR6_BIT10:      equ    %10000000000
mATDDR6_BIT11:      equ    %100000000000
mATDDR6_BIT12:      equ    %1000000000000
mATDDR6_BIT13:      equ    %10000000000000
mATDDR6_BIT14:      equ    %100000000000000
mATDDR6_BIT15:      equ    %1000000000000000


;*** ATDDR6H - ATD Conversion Result Register 6 High; 0x0000009C ***
ATDDR6H:            equ    $0000009C                                ;*** ATDDR6H - ATD Conversion Result Register 6 High; 0x0000009C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR6H_BIT8:       equ    0                                         ; Bit 8
ATDDR6H_BIT9:       equ    1                                         ; Bit 9
ATDDR6H_BIT10:      equ    2                                         ; Bit 10
ATDDR6H_BIT11:      equ    3                                         ; Bit 11
ATDDR6H_BIT12:      equ    4                                         ; Bit 12
ATDDR6H_BIT13:      equ    5                                         ; Bit 13
ATDDR6H_BIT14:      equ    6                                         ; Bit 14
ATDDR6H_BIT15:      equ    7                                         ; Bit 15
; bit position masks
mATDDR6H_BIT8:      equ    %00000001
mATDDR6H_BIT9:      equ    %00000010
mATDDR6H_BIT10:     equ    %00000100
mATDDR6H_BIT11:     equ    %00001000
mATDDR6H_BIT12:     equ    %00010000
mATDDR6H_BIT13:     equ    %00100000
mATDDR6H_BIT14:     equ    %01000000
mATDDR6H_BIT15:     equ    %10000000


;*** ATDDR6L - ATD Conversion Result Register 6 Low; 0x0000009D ***
ATDDR6L:            equ    $0000009D                                ;*** ATDDR6L - ATD Conversion Result Register 6 Low; 0x0000009D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR6L_BIT6:       equ    6                                         ; Bit 6
ATDDR6L_BIT7:       equ    7                                         ; Bit 7
; bit position masks
mATDDR6L_BIT6:      equ    %01000000
mATDDR6L_BIT7:      equ    %10000000


;*** ATDDR7 - ATD Conversion Result Register 7; 0x0000009E ***
ATDDR7:             equ    $0000009E                                ;*** ATDDR7 - ATD Conversion Result Register 7; 0x0000009E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR7_BIT6:        equ    6                                         ; Bit 6
ATDDR7_BIT7:        equ    7                                         ; Bit 7
ATDDR7_BIT8:        equ    8                                         ; Bit 8
ATDDR7_BIT9:        equ    9                                         ; Bit 9
ATDDR7_BIT10:       equ    10                                        ; Bit 10
ATDDR7_BIT11:       equ    11                                        ; Bit 11
ATDDR7_BIT12:       equ    12                                        ; Bit 12
ATDDR7_BIT13:       equ    13                                        ; Bit 13
ATDDR7_BIT14:       equ    14                                        ; Bit 14
ATDDR7_BIT15:       equ    15                                        ; Bit 15
; bit position masks
mATDDR7_BIT6:       equ    %01000000
mATDDR7_BIT7:       equ    %10000000
mATDDR7_BIT8:       equ    %100000000
mATDDR7_BIT9:       equ    %1000000000
mATDDR7_BIT10:      equ    %10000000000
mATDDR7_BIT11:      equ    %100000000000
mATDDR7_BIT12:      equ    %1000000000000
mATDDR7_BIT13:      equ    %10000000000000
mATDDR7_BIT14:      equ    %100000000000000
mATDDR7_BIT15:      equ    %1000000000000000


;*** ATDDR7H - ATD Conversion Result Register 7 High; 0x0000009E ***
ATDDR7H:            equ    $0000009E                                ;*** ATDDR7H - ATD Conversion Result Register 7 High; 0x0000009E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR7H_BIT8:       equ    0                                         ; Bit 8
ATDDR7H_BIT9:       equ    1                                         ; Bit 9
ATDDR7H_BIT10:      equ    2                                         ; Bit 10
ATDDR7H_BIT11:      equ    3                                         ; Bit 11
ATDDR7H_BIT12:      equ    4                                         ; Bit 12
ATDDR7H_BIT13:      equ    5                                         ; Bit 13
ATDDR7H_BIT14:      equ    6                                         ; Bit 14
ATDDR7H_BIT15:      equ    7                                         ; Bit 15
; bit position masks
mATDDR7H_BIT8:      equ    %00000001
mATDDR7H_BIT9:      equ    %00000010
mATDDR7H_BIT10:     equ    %00000100
mATDDR7H_BIT11:     equ    %00001000
mATDDR7H_BIT12:     equ    %00010000
mATDDR7H_BIT13:     equ    %00100000
mATDDR7H_BIT14:     equ    %01000000
mATDDR7H_BIT15:     equ    %10000000


;*** ATDDR7L - ATD Conversion Result Register 7 Low; 0x0000009F ***
ATDDR7L:            equ    $0000009F                                ;*** ATDDR7L - ATD Conversion Result Register 7 Low; 0x0000009F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR7L_BIT6:       equ    6                                         ; Bit 6
ATDDR7L_BIT7:       equ    7                                         ; Bit 7
; bit position masks
mATDDR7L_BIT6:      equ    %01000000
mATDDR7L_BIT7:      equ    %10000000


;*** SCI0BD - SCI 0 Baud Rate Register; 0x000000C8 ***
SCI0BD:             equ    $000000C8                                ;*** SCI0BD - SCI 0 Baud Rate Register; 0x000000C8 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI0BD_SBR0:        equ    0                                         ; SCI Baud Rate Bit 0
SCI0BD_SBR1:        equ    1                                         ; SCI Baud Rate Bit 1
SCI0BD_SBR2:        equ    2                                         ; SCI Baud Rate Bit 2
SCI0BD_SBR3:        equ    3                                         ; SCI Baud Rate Bit 3
SCI0BD_SBR4:        equ    4                                         ; SCI Baud Rate Bit 4
SCI0BD_SBR5:        equ    5                                         ; SCI Baud Rate Bit 5
SCI0BD_SBR6:        equ    6                                         ; SCI Baud Rate Bit 6
SCI0BD_SBR7:        equ    7                                         ; SCI Baud Rate Bit 7
SCI0BD_SBR8:        equ    8                                         ; SCI Baud Rate Bit 8
SCI0BD_SBR9:        equ    9                                         ; SCI Baud Rate Bit 9
SCI0BD_SBR10:       equ    10                                        ; SCI Baud Rate Bit 10
SCI0BD_SBR11:       equ    11                                        ; SCI Baud Rate Bit 11
SCI0BD_SBR12:       equ    12                                        ; SCI Baud Rate Bit 12
SCI0BD_TNP0:        equ    13                                        ; Transmitter Narrow Pulse Bit 0
SCI0BD_TNP1:        equ    14                                        ; Transmitter Narrow Pulse Bit 1
SCI0BD_IREN:        equ    15                                        ; Infrared Enable Bit
; bit position masks
mSCI0BD_SBR0:       equ    %00000001
mSCI0BD_SBR1:       equ    %00000010
mSCI0BD_SBR2:       equ    %00000100
mSCI0BD_SBR3:       equ    %00001000
mSCI0BD_SBR4:       equ    %00010000
mSCI0BD_SBR5:       equ    %00100000
mSCI0BD_SBR6:       equ    %01000000
mSCI0BD_SBR7:       equ    %10000000
mSCI0BD_SBR8:       equ    %100000000
mSCI0BD_SBR9:       equ    %1000000000
mSCI0BD_SBR10:      equ    %10000000000
mSCI0BD_SBR11:      equ    %100000000000
mSCI0BD_SBR12:      equ    %1000000000000
mSCI0BD_TNP0:       equ    %10000000000000
mSCI0BD_TNP1:       equ    %100000000000000
mSCI0BD_IREN:       equ    %1000000000000000


;*** SCI0BDH - SCI 0 Baud Rate Register High; 0x000000C8 ***
SCI0BDH:            equ    $000000C8                                ;*** SCI0BDH - SCI 0 Baud Rate Register High; 0x000000C8 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI0BDH_SBR8:       equ    0                                         ; SCI Baud Rate Bit 8
SCI0BDH_SBR9:       equ    1                                         ; SCI Baud Rate Bit 9
SCI0BDH_SBR10:      equ    2                                         ; SCI Baud Rate Bit 10
SCI0BDH_SBR11:      equ    3                                         ; SCI Baud Rate Bit 11
SCI0BDH_SBR12:      equ    4                                         ; SCI Baud Rate Bit 12
SCI0BDH_TNP0:       equ    5                                         ; Transmitter Narrow Pulse Bit 0
SCI0BDH_TNP1:       equ    6                                         ; Transmitter Narrow Pulse Bit 1
SCI0BDH_IREN:       equ    7                                         ; Infrared Enable Bit
; bit position masks
mSCI0BDH_SBR8:      equ    %00000001
mSCI0BDH_SBR9:      equ    %00000010
mSCI0BDH_SBR10:     equ    %00000100
mSCI0BDH_SBR11:     equ    %00001000
mSCI0BDH_SBR12:     equ    %00010000
mSCI0BDH_TNP0:      equ    %00100000
mSCI0BDH_TNP1:      equ    %01000000
mSCI0BDH_IREN:      equ    %10000000


;*** SCI0BDL - SCI 0 Baud Rate Register Low; 0x000000C9 ***
SCI0BDL:            equ    $000000C9                                ;*** SCI0BDL - SCI 0 Baud Rate Register Low; 0x000000C9 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI0BDL_SBR0:       equ    0                                         ; SCI Baud Rate Bit 0
SCI0BDL_SBR1:       equ    1                                         ; SCI Baud Rate Bit 1
SCI0BDL_SBR2:       equ    2                                         ; SCI Baud Rate Bit 2
SCI0BDL_SBR3:       equ    3                                         ; SCI Baud Rate Bit 3
SCI0BDL_SBR4:       equ    4                                         ; SCI Baud Rate Bit 4
SCI0BDL_SBR5:       equ    5                                         ; SCI Baud Rate Bit 5
SCI0BDL_SBR6:       equ    6                                         ; SCI Baud Rate Bit 6
SCI0BDL_SBR7:       equ    7                                         ; SCI Baud Rate Bit 7
; bit position masks
mSCI0BDL_SBR0:      equ    %00000001
mSCI0BDL_SBR1:      equ    %00000010
mSCI0BDL_SBR2:      equ    %00000100
mSCI0BDL_SBR3:      equ    %00001000
mSCI0BDL_SBR4:      equ    %00010000
mSCI0BDL_SBR5:      equ    %00100000
mSCI0BDL_SBR6:      equ    %01000000
mSCI0BDL_SBR7:      equ    %10000000


;*** SCI0CR1 - SCI 0 Control Register 1; 0x000000CA ***
SCI0CR1:            equ    $000000CA                                ;*** SCI0CR1 - SCI 0 Control Register 1; 0x000000CA ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI0CR1_PT:         equ    0                                         ; Parity Type Bit
SCI0CR1_PE:         equ    1                                         ; Parity Enable Bit
SCI0CR1_ILT:        equ    2                                         ; Idle Line Type Bit
SCI0CR1_WAKE:       equ    3                                         ; Wakeup Condition Bit
SCI0CR1_M:          equ    4                                         ; Data Format Mode Bit
SCI0CR1_RSRC:       equ    5                                         ; Receiver Source Bit
SCI0CR1_SCISWAI:    equ    6                                         ; SCI Stop in Wait Mode Bit
SCI0CR1_LOOPS:      equ    7                                         ; Loop Select Bit
; bit position masks
mSCI0CR1_PT:        equ    %00000001
mSCI0CR1_PE:        equ    %00000010
mSCI0CR1_ILT:       equ    %00000100
mSCI0CR1_WAKE:      equ    %00001000
mSCI0CR1_M:         equ    %00010000
mSCI0CR1_RSRC:      equ    %00100000
mSCI0CR1_SCISWAI:   equ    %01000000
mSCI0CR1_LOOPS:     equ    %10000000


;*** SCI0CR2 - SCI 0 Control Register 2; 0x000000CB ***
SCI0CR2:            equ    $000000CB                                ;*** SCI0CR2 - SCI 0 Control Register 2; 0x000000CB ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI0CR2_SBK:        equ    0                                         ; Send Break Bit
SCI0CR2_RWU:        equ    1                                         ; Receiver Wakeup Bit
SCI0CR2_RE:         equ    2                                         ; Receiver Enable Bit
SCI0CR2_TE:         equ    3                                         ; Transmitter Enable Bit
SCI0CR2_ILIE:       equ    4                                         ; Idle Line Interrupt Enable Bit
SCI0CR2_RIE:        equ    5                                         ; Receiver Full Interrupt Enable Bit
SCI0CR2_TCIE:       equ    6                                         ; Transmission Complete Interrupt Enable Bit
SCI0CR2_SCTIE:      equ    7                                         ; Transmitter Interrupt Enable Bit
; bit position masks
mSCI0CR2_SBK:       equ    %00000001
mSCI0CR2_RWU:       equ    %00000010
mSCI0CR2_RE:        equ    %00000100
mSCI0CR2_TE:        equ    %00001000
mSCI0CR2_ILIE:      equ    %00010000
mSCI0CR2_RIE:       equ    %00100000
mSCI0CR2_TCIE:      equ    %01000000
mSCI0CR2_SCTIE:     equ    %10000000


;*** SCI0SR1 - SCI 0 Status Register 1; 0x000000CC ***
SCI0SR1:            equ    $000000CC                                ;*** SCI0SR1 - SCI 0 Status Register 1; 0x000000CC ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI0SR1_PF:         equ    0                                         ; Parity Error Flag
SCI0SR1_FE:         equ    1                                         ; Framing Error Flag
SCI0SR1_NF:         equ    2                                         ; Noise Flag
SCI0SR1_OR:         equ    3                                         ; Overrun Flag
SCI0SR1_IDLE:       equ    4                                         ; Idle Line Flag
SCI0SR1_RDRF:       equ    5                                         ; Receive Data Register Full Flag
SCI0SR1_TC:         equ    6                                         ; Transmit Complete Flag
SCI0SR1_TDRE:       equ    7                                         ; Transmit Data Register Empty Flag
; bit position masks
mSCI0SR1_PF:        equ    %00000001
mSCI0SR1_FE:        equ    %00000010
mSCI0SR1_NF:        equ    %00000100
mSCI0SR1_OR:        equ    %00001000
mSCI0SR1_IDLE:      equ    %00010000
mSCI0SR1_RDRF:      equ    %00100000
mSCI0SR1_TC:        equ    %01000000
mSCI0SR1_TDRE:      equ    %10000000


;*** SCI0SR2 - SCI 0 Status Register 2; 0x000000CD ***
SCI0SR2:            equ    $000000CD                                ;*** SCI0SR2 - SCI 0 Status Register 2; 0x000000CD ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI0SR2_RAF:        equ    0                                         ; Receiver Active Flag
SCI0SR2_TXDIR:      equ    1                                         ; Transmitter pin data direction in Single-Wire mode
SCI0SR2_BRK13:      equ    2                                         ; Break Transmit character length
; bit position masks
mSCI0SR2_RAF:       equ    %00000001
mSCI0SR2_TXDIR:     equ    %00000010
mSCI0SR2_BRK13:     equ    %00000100


;*** SCI0DRH - SCI 0 Data Register High; 0x000000CE ***
SCI0DRH:            equ    $000000CE                                ;*** SCI0DRH - SCI 0 Data Register High; 0x000000CE ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI0DRH_T8:         equ    6                                         ; Transmit Bit 8
SCI0DRH_R8:         equ    7                                         ; Received Bit 8
; bit position masks
mSCI0DRH_T8:        equ    %01000000
mSCI0DRH_R8:        equ    %10000000


;*** SCI0DRL - SCI 0 Data Register Low; 0x000000CF ***
SCI0DRL:            equ    $000000CF                                ;*** SCI0DRL - SCI 0 Data Register Low; 0x000000CF ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI0DRL_R0_T0:      equ    0                                         ; Received bit 0 or Transmit bit 0
SCI0DRL_R1_T1:      equ    1                                         ; Received bit 1 or Transmit bit 1
SCI0DRL_R2_T2:      equ    2                                         ; Received bit 2 or Transmit bit 2
SCI0DRL_R3_T3:      equ    3                                         ; Received bit 3 or Transmit bit 3
SCI0DRL_R4_T4:      equ    4                                         ; Received bit 4 or Transmit bit 4
SCI0DRL_R5_T5:      equ    5                                         ; Received bit 5 or Transmit bit 5
SCI0DRL_R6_T6:      equ    6                                         ; Received bit 6 or Transmit bit 6
SCI0DRL_R7_T7:      equ    7                                         ; Received bit 7 or Transmit bit 7
; bit position masks
mSCI0DRL_R0_T0:     equ    %00000001
mSCI0DRL_R1_T1:     equ    %00000010
mSCI0DRL_R2_T2:     equ    %00000100
mSCI0DRL_R3_T3:     equ    %00001000
mSCI0DRL_R4_T4:     equ    %00010000
mSCI0DRL_R5_T5:     equ    %00100000
mSCI0DRL_R6_T6:     equ    %01000000
mSCI0DRL_R7_T7:     equ    %10000000


;*** SCI1BD - SCI 1 Baud Rate Register; 0x000000D0 ***
SCI1BD:             equ    $000000D0                                ;*** SCI1BD - SCI 1 Baud Rate Register; 0x000000D0 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI1BD_SBR0:        equ    0                                         ; SCI Baud Rate Bit 0
SCI1BD_SBR1:        equ    1                                         ; SCI Baud Rate Bit 1
SCI1BD_SBR2:        equ    2                                         ; SCI Baud Rate Bit 2
SCI1BD_SBR3:        equ    3                                         ; SCI Baud Rate Bit 3
SCI1BD_SBR4:        equ    4                                         ; SCI Baud Rate Bit 4
SCI1BD_SBR5:        equ    5                                         ; SCI Baud Rate Bit 5
SCI1BD_SBR6:        equ    6                                         ; SCI Baud Rate Bit 6
SCI1BD_SBR7:        equ    7                                         ; SCI Baud Rate Bit 7
SCI1BD_SBR8:        equ    8                                         ; SCI Baud Rate Bit 8
SCI1BD_SBR9:        equ    9                                         ; SCI Baud Rate Bit 9
SCI1BD_SBR10:       equ    10                                        ; SCI Baud Rate Bit 10
SCI1BD_SBR11:       equ    11                                        ; SCI Baud Rate Bit 11
SCI1BD_SBR12:       equ    12                                        ; SCI Baud Rate Bit 12
SCI1BD_TNP0:        equ    13                                        ; Transmitter Narrow Pulse Bit 0
SCI1BD_TNP1:        equ    14                                        ; Transmitter Narrow Pulse Bit 1
SCI1BD_IREN:        equ    15                                        ; Infrared Enable Bit
; bit position masks
mSCI1BD_SBR0:       equ    %00000001
mSCI1BD_SBR1:       equ    %00000010
mSCI1BD_SBR2:       equ    %00000100
mSCI1BD_SBR3:       equ    %00001000
mSCI1BD_SBR4:       equ    %00010000
mSCI1BD_SBR5:       equ    %00100000
mSCI1BD_SBR6:       equ    %01000000
mSCI1BD_SBR7:       equ    %10000000
mSCI1BD_SBR8:       equ    %100000000
mSCI1BD_SBR9:       equ    %1000000000
mSCI1BD_SBR10:      equ    %10000000000
mSCI1BD_SBR11:      equ    %100000000000
mSCI1BD_SBR12:      equ    %1000000000000
mSCI1BD_TNP0:       equ    %10000000000000
mSCI1BD_TNP1:       equ    %100000000000000
mSCI1BD_IREN:       equ    %1000000000000000


;*** SCI1BDH - SCI 1 Baud Rate Register High; 0x000000D0 ***
SCI1BDH:            equ    $000000D0                                ;*** SCI1BDH - SCI 1 Baud Rate Register High; 0x000000D0 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI1BDH_SBR8:       equ    0                                         ; SCI Baud Rate Bit 8
SCI1BDH_SBR9:       equ    1                                         ; SCI Baud Rate Bit 9
SCI1BDH_SBR10:      equ    2                                         ; SCI Baud Rate Bit 10
SCI1BDH_SBR11:      equ    3                                         ; SCI Baud Rate Bit 11
SCI1BDH_SBR12:      equ    4                                         ; SCI Baud Rate Bit 12
SCI1BDH_TNP0:       equ    5                                         ; Transmitter Narrow Pulse Bit 0
SCI1BDH_TNP1:       equ    6                                         ; Transmitter Narrow Pulse Bit 1
SCI1BDH_IREN:       equ    7                                         ; Infrared Enable Bit
; bit position masks
mSCI1BDH_SBR8:      equ    %00000001
mSCI1BDH_SBR9:      equ    %00000010
mSCI1BDH_SBR10:     equ    %00000100
mSCI1BDH_SBR11:     equ    %00001000
mSCI1BDH_SBR12:     equ    %00010000
mSCI1BDH_TNP0:      equ    %00100000
mSCI1BDH_TNP1:      equ    %01000000
mSCI1BDH_IREN:      equ    %10000000


;*** SCI1BDL - SCI 1 Baud Rate Register Low; 0x000000D1 ***
SCI1BDL:            equ    $000000D1                                ;*** SCI1BDL - SCI 1 Baud Rate Register Low; 0x000000D1 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI1BDL_SBR0:       equ    0                                         ; SCI Baud Rate Bit 0
SCI1BDL_SBR1:       equ    1                                         ; SCI Baud Rate Bit 1
SCI1BDL_SBR2:       equ    2                                         ; SCI Baud Rate Bit 2
SCI1BDL_SBR3:       equ    3                                         ; SCI Baud Rate Bit 3
SCI1BDL_SBR4:       equ    4                                         ; SCI Baud Rate Bit 4
SCI1BDL_SBR5:       equ    5                                         ; SCI Baud Rate Bit 5
SCI1BDL_SBR6:       equ    6                                         ; SCI Baud Rate Bit 6
SCI1BDL_SBR7:       equ    7                                         ; SCI Baud Rate Bit 7
; bit position masks
mSCI1BDL_SBR0:      equ    %00000001
mSCI1BDL_SBR1:      equ    %00000010
mSCI1BDL_SBR2:      equ    %00000100
mSCI1BDL_SBR3:      equ    %00001000
mSCI1BDL_SBR4:      equ    %00010000
mSCI1BDL_SBR5:      equ    %00100000
mSCI1BDL_SBR6:      equ    %01000000
mSCI1BDL_SBR7:      equ    %10000000


;*** SCI1CR1 - SCI 1 Control Register 1; 0x000000D2 ***
SCI1CR1:            equ    $000000D2                                ;*** SCI1CR1 - SCI 1 Control Register 1; 0x000000D2 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI1CR1_PT:         equ    0                                         ; Parity Type Bit
SCI1CR1_PE:         equ    1                                         ; Parity Enable Bit
SCI1CR1_ILT:        equ    2                                         ; Idle Line Type Bit
SCI1CR1_WAKE:       equ    3                                         ; Wakeup Condition Bit
SCI1CR1_M:          equ    4                                         ; Data Format Mode Bit
SCI1CR1_RSRC:       equ    5                                         ; Receiver Source Bit
SCI1CR1_SCISWAI:    equ    6                                         ; SCI Stop in Wait Mode Bit
SCI1CR1_LOOPS:      equ    7                                         ; Loop Select Bit
; bit position masks
mSCI1CR1_PT:        equ    %00000001
mSCI1CR1_PE:        equ    %00000010
mSCI1CR1_ILT:       equ    %00000100
mSCI1CR1_WAKE:      equ    %00001000
mSCI1CR1_M:         equ    %00010000
mSCI1CR1_RSRC:      equ    %00100000
mSCI1CR1_SCISWAI:   equ    %01000000
mSCI1CR1_LOOPS:     equ    %10000000


;*** SCI1CR2 - SCI 1 Control Register 2; 0x000000D3 ***
SCI1CR2:            equ    $000000D3                                ;*** SCI1CR2 - SCI 1 Control Register 2; 0x000000D3 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI1CR2_SBK:        equ    0                                         ; Send Break Bit
SCI1CR2_RWU:        equ    1                                         ; Receiver Wakeup Bit
SCI1CR2_RE:         equ    2                                         ; Receiver Enable Bit
SCI1CR2_TE:         equ    3                                         ; Transmitter Enable Bit
SCI1CR2_ILIE:       equ    4                                         ; Idle Line Interrupt Enable Bit
SCI1CR2_RIE:        equ    5                                         ; Receiver Full Interrupt Enable Bit
SCI1CR2_TCIE:       equ    6                                         ; Transmission Complete Interrupt Enable Bit
SCI1CR2_SCTIE:      equ    7                                         ; Transmitter Interrupt Enable Bit
; bit position masks
mSCI1CR2_SBK:       equ    %00000001
mSCI1CR2_RWU:       equ    %00000010
mSCI1CR2_RE:        equ    %00000100
mSCI1CR2_TE:        equ    %00001000
mSCI1CR2_ILIE:      equ    %00010000
mSCI1CR2_RIE:       equ    %00100000
mSCI1CR2_TCIE:      equ    %01000000
mSCI1CR2_SCTIE:     equ    %10000000


;*** SCI1SR1 - SCI 1 Status Register 1; 0x000000D4 ***
SCI1SR1:            equ    $000000D4                                ;*** SCI1SR1 - SCI 1 Status Register 1; 0x000000D4 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI1SR1_PF:         equ    0                                         ; Parity Error Flag
SCI1SR1_FE:         equ    1                                         ; Framing Error Flag
SCI1SR1_NF:         equ    2                                         ; Noise Flag
SCI1SR1_OR:         equ    3                                         ; Overrun Flag
SCI1SR1_IDLE:       equ    4                                         ; Idle Line Flag
SCI1SR1_RDRF:       equ    5                                         ; Receive Data Register Full Flag
SCI1SR1_TC:         equ    6                                         ; Transmit Complete Flag
SCI1SR1_TDRE:       equ    7                                         ; Transmit Data Register Empty Flag
; bit position masks
mSCI1SR1_PF:        equ    %00000001
mSCI1SR1_FE:        equ    %00000010
mSCI1SR1_NF:        equ    %00000100
mSCI1SR1_OR:        equ    %00001000
mSCI1SR1_IDLE:      equ    %00010000
mSCI1SR1_RDRF:      equ    %00100000
mSCI1SR1_TC:        equ    %01000000
mSCI1SR1_TDRE:      equ    %10000000


;*** SCI1SR2 - SCI 1 Status Register 2; 0x000000D5 ***
SCI1SR2:            equ    $000000D5                                ;*** SCI1SR2 - SCI 1 Status Register 2; 0x000000D5 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI1SR2_RAF:        equ    0                                         ; Receiver Active Flag
SCI1SR2_TXDIR:      equ    1                                         ; Transmitter pin data direction in Single-Wire mode
SCI1SR2_BRK13:      equ    2                                         ; Break Transmit character length
; bit position masks
mSCI1SR2_RAF:       equ    %00000001
mSCI1SR2_TXDIR:     equ    %00000010
mSCI1SR2_BRK13:     equ    %00000100


;*** SCI1DRH - SCI 1 Data Register High; 0x000000D6 ***
SCI1DRH:            equ    $000000D6                                ;*** SCI1DRH - SCI 1 Data Register High; 0x000000D6 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI1DRH_T8:         equ    6                                         ; Transmit Bit 8
SCI1DRH_R8:         equ    7                                         ; Received Bit 8
; bit position masks
mSCI1DRH_T8:        equ    %01000000
mSCI1DRH_R8:        equ    %10000000


;*** SCI1DRL - SCI 1 Data Register Low; 0x000000D7 ***
SCI1DRL:            equ    $000000D7                                ;*** SCI1DRL - SCI 1 Data Register Low; 0x000000D7 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI1DRL_R0_T0:      equ    0                                         ; Received bit 0 or Transmit bit 0
SCI1DRL_R1_T1:      equ    1                                         ; Received bit 1 or Transmit bit 1
SCI1DRL_R2_T2:      equ    2                                         ; Received bit 2 or Transmit bit 2
SCI1DRL_R3_T3:      equ    3                                         ; Received bit 3 or Transmit bit 3
SCI1DRL_R4_T4:      equ    4                                         ; Received bit 4 or Transmit bit 4
SCI1DRL_R5_T5:      equ    5                                         ; Received bit 5 or Transmit bit 5
SCI1DRL_R6_T6:      equ    6                                         ; Received bit 6 or Transmit bit 6
SCI1DRL_R7_T7:      equ    7                                         ; Received bit 7 or Transmit bit 7
; bit position masks
mSCI1DRL_R0_T0:     equ    %00000001
mSCI1DRL_R1_T1:     equ    %00000010
mSCI1DRL_R2_T2:     equ    %00000100
mSCI1DRL_R3_T3:     equ    %00001000
mSCI1DRL_R4_T4:     equ    %00010000
mSCI1DRL_R5_T5:     equ    %00100000
mSCI1DRL_R6_T6:     equ    %01000000
mSCI1DRL_R7_T7:     equ    %10000000


;*** SPICR1 - SPI Control Register; 0x000000D8 ***
SPICR1:             equ    $000000D8                                ;*** SPICR1 - SPI Control Register; 0x000000D8 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPICR1_LSBFE:       equ    0                                         ; SPI LSB-First Enable
SPICR1_SSOE:        equ    1                                         ; Slave Select Output Enable
SPICR1_CPHA:        equ    2                                         ; SPI Clock Phase Bit
SPICR1_CPOL:        equ    3                                         ; SPI Clock Polarity Bit
SPICR1_MSTR:        equ    4                                         ; SPI Master/Slave Mode Select Bit
SPICR1_SPTIE:       equ    5                                         ; SPI Transmit Interrupt Enable
SPICR1_SPE:         equ    6                                         ; SPI System Enable Bit
SPICR1_SPIE:        equ    7                                         ; SPI Interrupt Enable Bit
; bit position masks
mSPICR1_LSBFE:      equ    %00000001
mSPICR1_SSOE:       equ    %00000010
mSPICR1_CPHA:       equ    %00000100
mSPICR1_CPOL:       equ    %00001000
mSPICR1_MSTR:       equ    %00010000
mSPICR1_SPTIE:      equ    %00100000
mSPICR1_SPE:        equ    %01000000
mSPICR1_SPIE:       equ    %10000000


;*** SPICR2 - SPI Control Register 2; 0x000000D9 ***
SPICR2:             equ    $000000D9                                ;*** SPICR2 - SPI Control Register 2; 0x000000D9 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPICR2_SPC0:        equ    0                                         ; Serial Pin Control Bit 0
SPICR2_SPISWAI:     equ    1                                         ; SPI Stop in Wait Mode Bit
SPICR2_BIDIROE:     equ    3                                         ; Output enable in the Bidirectional mode of operation
SPICR2_MODFEN:      equ    4                                         ; Mode Fault Enable Bit
; bit position masks
mSPICR2_SPC0:       equ    %00000001
mSPICR2_SPISWAI:    equ    %00000010
mSPICR2_BIDIROE:    equ    %00001000
mSPICR2_MODFEN:     equ    %00010000


;*** SPIBR - SPI Baud Rate Register; 0x000000DA ***
SPIBR:              equ    $000000DA                                ;*** SPIBR - SPI Baud Rate Register; 0x000000DA ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPIBR_SPR0:         equ    0                                         ; SPI Baud Rate Selection Bit 0
SPIBR_SPR1:         equ    1                                         ; SPI Baud Rate Selection Bit 1
SPIBR_SPR2:         equ    2                                         ; SPI Baud Rate Selection Bit 2
SPIBR_SPPR0:        equ    4                                         ; SPI Baud Rate Preselection Bits 0
SPIBR_SPPR1:        equ    5                                         ; SPI Baud Rate Preselection Bits 1
SPIBR_SPPR2:        equ    6                                         ; SPI Baud Rate Preselection Bits 2
; bit position masks
mSPIBR_SPR0:        equ    %00000001
mSPIBR_SPR1:        equ    %00000010
mSPIBR_SPR2:        equ    %00000100
mSPIBR_SPPR0:       equ    %00010000
mSPIBR_SPPR1:       equ    %00100000
mSPIBR_SPPR2:       equ    %01000000


;*** SPISR - SPI Status Register; 0x000000DB ***
SPISR:              equ    $000000DB                                ;*** SPISR - SPI Status Register; 0x000000DB ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPISR_MODF:         equ    4                                         ; Mode Fault Flag
SPISR_SPTEF:        equ    5                                         ; SPI Transmit Empty Interrupt Flag
SPISR_SPIF:         equ    7                                         ; SPIF Receive Interrupt Flag
; bit position masks
mSPISR_MODF:        equ    %00010000
mSPISR_SPTEF:       equ    %00100000
mSPISR_SPIF:        equ    %10000000


;*** SPIDR - SPI Data Register; 0x000000DD ***
SPIDR:              equ    $000000DD                                ;*** SPIDR - SPI Data Register; 0x000000DD ***


;*** IBAD - IIC Address Register; 0x000000E0 ***
IBAD:               equ    $000000E0                                ;*** IBAD - IIC Address Register; 0x000000E0 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
IBAD_ADR1:          equ    1                                         ; Slave Address Bit 1
IBAD_ADR2:          equ    2                                         ; Slave Address Bit 2
IBAD_ADR3:          equ    3                                         ; Slave Address Bit 3
IBAD_ADR4:          equ    4                                         ; Slave Address Bit 4
IBAD_ADR5:          equ    5                                         ; Slave Address Bit 5
IBAD_ADR6:          equ    6                                         ; Slave Address Bit 6
IBAD_ADR7:          equ    7                                         ; Slave Address Bit 7
; bit position masks
mIBAD_ADR1:         equ    %00000010
mIBAD_ADR2:         equ    %00000100
mIBAD_ADR3:         equ    %00001000
mIBAD_ADR4:         equ    %00010000
mIBAD_ADR5:         equ    %00100000
mIBAD_ADR6:         equ    %01000000
mIBAD_ADR7:         equ    %10000000


;*** IBFD - IIC Frequency Divider Register; 0x000000E1 ***
IBFD:               equ    $000000E1                                ;*** IBFD - IIC Frequency Divider Register; 0x000000E1 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
IBFD_IBC0:          equ    0                                         ; I-Bus Clock Rate 0
IBFD_IBC1:          equ    1                                         ; I-Bus Clock Rate 1
IBFD_IBC2:          equ    2                                         ; I-Bus Clock Rate 2
IBFD_IBC3:          equ    3                                         ; I-Bus Clock Rate 3
IBFD_IBC4:          equ    4                                         ; I-Bus Clock Rate 4
IBFD_IBC5:          equ    5                                         ; I-Bus Clock Rate 5
IBFD_IBC6:          equ    6                                         ; I-Bus Clock Rate 6
IBFD_IBC7:          equ    7                                         ; I-Bus Clock Rate 7
; bit position masks
mIBFD_IBC0:         equ    %00000001
mIBFD_IBC1:         equ    %00000010
mIBFD_IBC2:         equ    %00000100
mIBFD_IBC3:         equ    %00001000
mIBFD_IBC4:         equ    %00010000
mIBFD_IBC5:         equ    %00100000
mIBFD_IBC6:         equ    %01000000
mIBFD_IBC7:         equ    %10000000


;*** IBCR - IIC Control Register; 0x000000E2 ***
IBCR:               equ    $000000E2                                ;*** IBCR - IIC Control Register; 0x000000E2 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
IBCR_IBSWAI:        equ    0                                         ; I-Bus Interface Stop in WAIT mode
IBCR_RSTA:          equ    2                                         ; Repeat Start
IBCR_TXAK:          equ    3                                         ; Transmit Acknowledge enable
IBCR_TX_RX:         equ    4                                         ; Transmit/Receive mode select bit
IBCR_MS_SL:         equ    5                                         ; Master/Slave mode select bit
IBCR_IBIE:          equ    6                                         ; I-Bus Interrupt Enable
IBCR_IBEN:          equ    7                                         ; I-Bus Enable
; bit position masks
mIBCR_IBSWAI:       equ    %00000001
mIBCR_RSTA:         equ    %00000100
mIBCR_TXAK:         equ    %00001000
mIBCR_TX_RX:        equ    %00010000
mIBCR_MS_SL:        equ    %00100000
mIBCR_IBIE:         equ    %01000000
mIBCR_IBEN:         equ    %10000000


;*** IBSR - IIC Status Register; 0x000000E3 ***
IBSR:               equ    $000000E3                                ;*** IBSR - IIC Status Register; 0x000000E3 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
IBSR_RXAK:          equ    0                                         ; Received Acknowledge
IBSR_IBIF:          equ    1                                         ; I-Bus Interrupt
IBSR_SRW:           equ    2                                         ; Slave Read/Write
IBSR_IBAL:          equ    4                                         ; Arbitration Lost
IBSR_IBB:           equ    5                                         ; Bus busy bit
IBSR_IAAS:          equ    6                                         ; Addressed as a slave bit
IBSR_TCF:           equ    7                                         ; Data transferring bit
; bit position masks
mIBSR_RXAK:         equ    %00000001
mIBSR_IBIF:         equ    %00000010
mIBSR_SRW:          equ    %00000100
mIBSR_IBAL:         equ    %00010000
mIBSR_IBB:          equ    %00100000
mIBSR_IAAS:         equ    %01000000
mIBSR_TCF:          equ    %10000000


;*** IBDR - IIC Data I/O Register; 0x000000E4 ***
IBDR:               equ    $000000E4                                ;*** IBDR - IIC Data I/O Register; 0x000000E4 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
IBDR_D0:            equ    0                                         ; IIC Data Bit 0
IBDR_D1:            equ    1                                         ; IIC Data Bit 1
IBDR_D2:            equ    2                                         ; IIC Data Bit 2
IBDR_D3:            equ    3                                         ; IIC Data Bit 3
IBDR_D4:            equ    4                                         ; IIC Data Bit 4
IBDR_D5:            equ    5                                         ; IIC Data Bit 5
IBDR_D6:            equ    6                                         ; IIC Data Bit 6
IBDR_D7:            equ    7                                         ; IIC Data Bit 7
; bit position masks
mIBDR_D0:           equ    %00000001
mIBDR_D1:           equ    %00000010
mIBDR_D2:           equ    %00000100
mIBDR_D3:           equ    %00001000
mIBDR_D4:           equ    %00010000
mIBDR_D5:           equ    %00100000
mIBDR_D6:           equ    %01000000
mIBDR_D7:           equ    %10000000


;*** FCLKDIV - Flash Clock Divider Register; 0x00000100 ***
FCLKDIV:            equ    $00000100                                ;*** FCLKDIV - Flash Clock Divider Register; 0x00000100 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FCLKDIV_FDIV0:      equ    0                                         ; Flash Clock Divider Bit 0
FCLKDIV_FDIV1:      equ    1                                         ; Flash Clock Divider Bit 1
FCLKDIV_FDIV2:      equ    2                                         ; Flash Clock Divider Bit 2
FCLKDIV_FDIV3:      equ    3                                         ; Flash Clock Divider Bit 3
FCLKDIV_FDIV4:      equ    4                                         ; Flash Clock Divider Bit 4
FCLKDIV_FDIV5:      equ    5                                         ; Flash Clock Divider Bit 5
FCLKDIV_PRDIV8:     equ    6                                         ; Enable Prescaler by 8
FCLKDIV_FDIVLD:     equ    7                                         ; Flash Clock Divider Loaded
; bit position masks
mFCLKDIV_FDIV0:     equ    %00000001
mFCLKDIV_FDIV1:     equ    %00000010
mFCLKDIV_FDIV2:     equ    %00000100
mFCLKDIV_FDIV3:     equ    %00001000
mFCLKDIV_FDIV4:     equ    %00010000
mFCLKDIV_FDIV5:     equ    %00100000
mFCLKDIV_PRDIV8:    equ    %01000000
mFCLKDIV_FDIVLD:    equ    %10000000


;*** FSEC - Flash Security Register; 0x00000101 ***
FSEC:               equ    $00000101                                ;*** FSEC - Flash Security Register; 0x00000101 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FSEC_SEC0:          equ    0                                         ; Memory security bit 0
FSEC_SEC1:          equ    1                                         ; Memory security bit 1
FSEC_NV2:           equ    2                                         ; Non Volatile flag bit 2
FSEC_NV3:           equ    3                                         ; Non Volatile flag bit 3
FSEC_NV4:           equ    4                                         ; Non Volatile flag bit 4
FSEC_NV5:           equ    5                                         ; Non Volatile flag bit 5
FSEC_NV6:           equ    6                                         ; Non Volatile flag bit 6
FSEC_KEYEN:         equ    7                                         ; Backdoor Key Security Enable
; bit position masks
mFSEC_SEC0:         equ    %00000001
mFSEC_SEC1:         equ    %00000010
mFSEC_NV2:          equ    %00000100
mFSEC_NV3:          equ    %00001000
mFSEC_NV4:          equ    %00010000
mFSEC_NV5:          equ    %00100000
mFSEC_NV6:          equ    %01000000
mFSEC_KEYEN:        equ    %10000000


;*** FCNFG - Flash Configuration Register; 0x00000103 ***
FCNFG:              equ    $00000103                                ;*** FCNFG - Flash Configuration Register; 0x00000103 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FCNFG_KEYACC:       equ    5                                         ; Enable Security Key Writing
FCNFG_CCIE:         equ    6                                         ; Command Complete Interrupt Enable
FCNFG_CBEIE:        equ    7                                         ; Command Buffers Empty Interrupt Enable
; bit position masks
mFCNFG_KEYACC:      equ    %00100000
mFCNFG_CCIE:        equ    %01000000
mFCNFG_CBEIE:       equ    %10000000


;*** FPROT - Flash Protection Register; 0x00000104 ***
FPROT:              equ    $00000104                                ;*** FPROT - Flash Protection Register; 0x00000104 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FPROT_FPLS0:        equ    0                                         ; Flash Protection Lower Address size 0
FPROT_FPLS1:        equ    1                                         ; Flash Protection Lower Address size 1
FPROT_FPLDIS:       equ    2                                         ; Flash Protection Lower address range disable
FPROT_FPHS0:        equ    3                                         ; Flash Protection Higher address size 0
FPROT_FPHS1:        equ    4                                         ; Flash Protection Higher address size 1
FPROT_FPHDIS:       equ    5                                         ; Flash Protection Higher address range disable
FPROT_NV6:          equ    6                                         ; Non Volatile Flag Bit
FPROT_FPOPEN:       equ    7                                         ; Opens the flash block or subsections of it for program or erase
; bit position masks
mFPROT_FPLS0:       equ    %00000001
mFPROT_FPLS1:       equ    %00000010
mFPROT_FPLDIS:      equ    %00000100
mFPROT_FPHS0:       equ    %00001000
mFPROT_FPHS1:       equ    %00010000
mFPROT_FPHDIS:      equ    %00100000
mFPROT_NV6:         equ    %01000000
mFPROT_FPOPEN:      equ    %10000000


;*** FSTAT - Flash Status Register; 0x00000105 ***
FSTAT:              equ    $00000105                                ;*** FSTAT - Flash Status Register; 0x00000105 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FSTAT_BLANK:        equ    2                                         ; Blank Verify Flag
FSTAT_ACCERR:       equ    4                                         ; Access error
FSTAT_PVIOL:        equ    5                                         ; Protection violation
FSTAT_CCIF:         equ    6                                         ; Command Complete Interrupt Flag
FSTAT_CBEIF:        equ    7                                         ; Command Buffers Empty Interrupt Flag
; bit position masks
mFSTAT_BLANK:       equ    %00000100
mFSTAT_ACCERR:      equ    %00010000
mFSTAT_PVIOL:       equ    %00100000
mFSTAT_CCIF:        equ    %01000000
mFSTAT_CBEIF:       equ    %10000000


;*** FCMD - Flash Command Buffer and Register; 0x00000106 ***
FCMD:               equ    $00000106                                ;*** FCMD - Flash Command Buffer and Register; 0x00000106 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FCMD_CMDB0:         equ    0                                         ; NVM User Mode Command Bit 0
FCMD_CMDB2:         equ    2                                         ; NVM User Mode Command Bit 2
FCMD_CMDB5:         equ    5                                         ; NVM User Mode Command Bit 5
FCMD_CMDB6:         equ    6                                         ; NVM User Mode Command Bit 6
; bit position masks
mFCMD_CMDB0:        equ    %00000001
mFCMD_CMDB2:        equ    %00000100
mFCMD_CMDB5:        equ    %00100000
mFCMD_CMDB6:        equ    %01000000


;*** EPHYCTL0 - Ethernet Physical Transceiver Control Register 0; 0x00000120 ***
EPHYCTL0:           equ    $00000120                                ;*** EPHYCTL0 - Ethernet Physical Transceiver Control Register 0; 0x00000120 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
EPHYCTL0_EPHYIEN:   equ    0                                         ; EPHY Interrupt Enable
EPHYCTL0_EPHYWAI:   equ    2                                         ; EPHY Module Stops While in Wait
EPHYCTL0_LEDEN:     equ    3                                         ; LED Drive Enable
EPHYCTL0_DIS10:     equ    4                                         ; Disable 10BaseT PLL
EPHYCTL0_DIS100:    equ    5                                         ; Disable 100 Base-TX PLL
EPHYCTL0_ANDIS:     equ    6                                         ; Auto Negotiation Disable
EPHYCTL0_EPHYEN:    equ    7                                         ; EPHY Enable
; bit position masks
mEPHYCTL0_EPHYIEN:  equ    %00000001
mEPHYCTL0_EPHYWAI:  equ    %00000100
mEPHYCTL0_LEDEN:    equ    %00001000
mEPHYCTL0_DIS10:    equ    %00010000
mEPHYCTL0_DIS100:   equ    %00100000
mEPHYCTL0_ANDIS:    equ    %01000000
mEPHYCTL0_EPHYEN:   equ    %10000000


;*** EPHYCTL1 - Ethernet Physical Transceiver Control Register 1; 0x00000121 ***
EPHYCTL1:           equ    $00000121                                ;*** EPHYCTL1 - Ethernet Physical Transceiver Control Register 1; 0x00000121 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
EPHYCTL1_PHYADD0:   equ    0                                         ; EPHY Address for MII Request Bit 0
EPHYCTL1_PHYADD1:   equ    1                                         ; EPHY Address for MII Request Bit 1
EPHYCTL1_PHYADD2:   equ    2                                         ; EPHY Address for MII Request Bit 2
EPHYCTL1_PHYADD3:   equ    3                                         ; EPHY Address for MII Request Bit 3
EPHYCTL1_PHYADD4:   equ    4                                         ; EPHY Address for MII Request Bit 4
; bit position masks
mEPHYCTL1_PHYADD0:  equ    %00000001
mEPHYCTL1_PHYADD1:  equ    %00000010
mEPHYCTL1_PHYADD2:  equ    %00000100
mEPHYCTL1_PHYADD3:  equ    %00001000
mEPHYCTL1_PHYADD4:  equ    %00010000


;*** EPHYSR - Ethernet Physical Transceiver Status Register; 0x00000122 ***
EPHYSR:             equ    $00000122                                ;*** EPHYSR - Ethernet Physical Transceiver Status Register; 0x00000122 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
EPHYSR_EPHYIF:      equ    0                                         ; EPHY Interrupt Flag
EPHYSR__10DIS:      equ    4                                         ; EPHY Port Base 10X mode status
EPHYSR__100DIS:     equ    5                                         ; EPHY Port Base 100X mode status
; bit position masks
mEPHYSR_EPHYIF:     equ    %00000001
mEPHYSR__10DIS:     equ    %00010000
mEPHYSR__100DIS:    equ    %00100000


;*** NETCTL - Network Control; 0x00000140 ***
NETCTL:             equ    $00000140                                ;*** NETCTL - Network Control; 0x00000140 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NETCTL_FDX:         equ    1                                         ; Full Duplex
NETCTL_MLB:         equ    2                                         ; MAC Loopback
NETCTL_EXTPHY:      equ    3                                         ; External PHY
NETCTL_ESWAI:       equ    4                                         ; EMAC Disabled during WAIT Mode
NETCTL_EMACE:       equ    7                                         ; EMAC Enable
; bit position masks
mNETCTL_FDX:        equ    %00000010
mNETCTL_MLB:        equ    %00000100
mNETCTL_EXTPHY:     equ    %00001000
mNETCTL_ESWAI:      equ    %00010000
mNETCTL_EMACE:      equ    %10000000


;*** RXCTS - Receive Control and Status; 0x00000143 ***
RXCTS:              equ    $00000143                                ;*** RXCTS - Receive Control and Status; 0x00000143 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RXCTS_BCREJ:        equ    0                                         ; Broadcast Reject
RXCTS_CONMC:        equ    1                                         ; Conditional Multicast
RXCTS_PROM:         equ    2                                         ; Promiscuous Mode
RXCTS_RFCE:         equ    4                                         ; Reception Flow Control Enable
RXCTS_RXACT:        equ    7                                         ; Receiver Active Status
; bit position masks
mRXCTS_BCREJ:       equ    %00000001
mRXCTS_CONMC:       equ    %00000010
mRXCTS_PROM:        equ    %00000100
mRXCTS_RFCE:        equ    %00010000
mRXCTS_RXACT:       equ    %10000000


;*** TXCTS - Transmit Control and Status; 0x00000144 ***
TXCTS:              equ    $00000144                                ;*** TXCTS - Transmit Control and Status; 0x00000144 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TXCTS_TCMD0:        equ    0                                         ; Transmit Command Bit 0
TXCTS_TCMD1:        equ    1                                         ; Transmit Command Bit 1
TXCTS_SSB:          equ    3                                         ; Single Slot Backoff
TXCTS_PTRC:         equ    4                                         ; PAUSE Timer Register Control
TXCTS_CSLF:         equ    5                                         ; Carrier Sense Lst Flag
TXCTS_TXACT:        equ    7                                         ; Transmitter Active
; bit position masks
mTXCTS_TCMD0:       equ    %00000001
mTXCTS_TCMD1:       equ    %00000010
mTXCTS_SSB:         equ    %00001000
mTXCTS_PTRC:        equ    %00010000
mTXCTS_CSLF:        equ    %00100000
mTXCTS_TXACT:       equ    %10000000


;*** ETCTL - Ethertype Control; 0x00000145 ***
ETCTL:              equ    $00000145                                ;*** ETCTL - Ethertype Control; 0x00000145 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ETCTL_FIEEE:        equ    0                                         ; IEEE802.3 Length Field Ethertype
ETCTL_FIPV4:        equ    1                                         ; Internet Protocol Version 4 (IPv4) Ethertype
ETCTL_FARP:         equ    2                                         ; Address Resolution Protocol (ARP) Ethertype
ETCTL_FIPV6:        equ    3                                         ; Internet Protocol Version 6 (IPv6) Ethertype
ETCTL_FEMW:         equ    4                                         ; Emware Ethertype
ETCTL_FPET:         equ    7                                         ; Programmable Ethertype
; bit position masks
mETCTL_FIEEE:       equ    %00000001
mETCTL_FIPV4:       equ    %00000010
mETCTL_FARP:        equ    %00000100
mETCTL_FIPV6:       equ    %00001000
mETCTL_FEMW:        equ    %00010000
mETCTL_FPET:        equ    %10000000


;*** ETYPE - Programmable Ethertype; 0x00000146 ***
ETYPE:              equ    $00000146                                ;*** ETYPE - Programmable Ethertype; 0x00000146 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ETYPE_ETYPE0:       equ    0                                         ; Programmable Ethertype Bit 0
ETYPE_ETYPE1:       equ    1                                         ; Programmable Ethertype Bit 1
ETYPE_ETYPE2:       equ    2                                         ; Programmable Ethertype Bit 2
ETYPE_ETYPE3:       equ    3                                         ; Programmable Ethertype Bit 3
ETYPE_ETYPE4:       equ    4                                         ; Programmable Ethertype Bit 4
ETYPE_ETYPE5:       equ    5                                         ; Programmable Ethertype Bit 5
ETYPE_ETYPE6:       equ    6                                         ; Programmable Ethertype Bit 6
ETYPE_ETYPE7:       equ    7                                         ; Programmable Ethertype Bit 7
ETYPE_ETYPE8:       equ    8                                         ; Programmable Ethertype Bit 8
ETYPE_ETYPE9:       equ    9                                         ; Programmable Ethertype Bit 9
ETYPE_ETYPE10:      equ    10                                        ; Programmable Ethertype Bit 10
ETYPE_ETYPE11:      equ    11                                        ; Programmable Ethertype Bit 11
ETYPE_ETYPE12:      equ    12                                        ; Programmable Ethertype Bit 12
ETYPE_ETYPE13:      equ    13                                        ; Programmable Ethertype Bit 13
ETYPE_ETYPE14:      equ    14                                        ; Programmable Ethertype Bit 14
ETYPE_ETYPE15:      equ    15                                        ; Programmable Ethertype Bit 15
; bit position masks
mETYPE_ETYPE0:      equ    %00000001
mETYPE_ETYPE1:      equ    %00000010
mETYPE_ETYPE2:      equ    %00000100
mETYPE_ETYPE3:      equ    %00001000
mETYPE_ETYPE4:      equ    %00010000
mETYPE_ETYPE5:      equ    %00100000
mETYPE_ETYPE6:      equ    %01000000
mETYPE_ETYPE7:      equ    %10000000
mETYPE_ETYPE8:      equ    %100000000
mETYPE_ETYPE9:      equ    %1000000000
mETYPE_ETYPE10:     equ    %10000000000
mETYPE_ETYPE11:     equ    %100000000000
mETYPE_ETYPE12:     equ    %1000000000000
mETYPE_ETYPE13:     equ    %10000000000000
mETYPE_ETYPE14:     equ    %100000000000000
mETYPE_ETYPE15:     equ    %1000000000000000


;*** PTIME - PAUSE Timer Value and Counter; 0x00000148 ***
PTIME:              equ    $00000148                                ;*** PTIME - PAUSE Timer Value and Counter; 0x00000148 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTIME_PTIME0:       equ    0                                         ; PAUSE Timer Value and Counter Bit 0
PTIME_PTIME1:       equ    1                                         ; PAUSE Timer Value and Counter Bit 1
PTIME_PTIME2:       equ    2                                         ; PAUSE Timer Value and Counter Bit 2
PTIME_PTIME3:       equ    3                                         ; PAUSE Timer Value and Counter Bit 3
PTIME_PTIME4:       equ    4                                         ; PAUSE Timer Value and Counter Bit 4
PTIME_PTIME5:       equ    5                                         ; PAUSE Timer Value and Counter Bit 5
PTIME_PTIME6:       equ    6                                         ; PAUSE Timer Value and Counter Bit 6
PTIME_PTIME7:       equ    7                                         ; PAUSE Timer Value and Counter Bit 7
PTIME_PTIME8:       equ    8                                         ; PAUSE Timer Value and Counter Bit 8
PTIME_PTIME9:       equ    9                                         ; PAUSE Timer Value and Counter Bit 9
PTIME_PTIME10:      equ    10                                        ; PAUSE Timer Value and Counter Bit 10
PTIME_PTIME11:      equ    11                                        ; PAUSE Timer Value and Counter Bit 11
PTIME_PTIME12:      equ    12                                        ; PAUSE Timer Value and Counter Bit 12
PTIME_PTIME13:      equ    13                                        ; PAUSE Timer Value and Counter Bit 13
PTIME_PTIME14:      equ    14                                        ; PAUSE Timer Value and Counter Bit 14
PTIME_PTIME15:      equ    15                                        ; PAUSE Timer Value and Counter Bit 15
; bit position masks
mPTIME_PTIME0:      equ    %00000001
mPTIME_PTIME1:      equ    %00000010
mPTIME_PTIME2:      equ    %00000100
mPTIME_PTIME3:      equ    %00001000
mPTIME_PTIME4:      equ    %00010000
mPTIME_PTIME5:      equ    %00100000
mPTIME_PTIME6:      equ    %01000000
mPTIME_PTIME7:      equ    %10000000
mPTIME_PTIME8:      equ    %100000000
mPTIME_PTIME9:      equ    %1000000000
mPTIME_PTIME10:     equ    %10000000000
mPTIME_PTIME11:     equ    %100000000000
mPTIME_PTIME12:     equ    %1000000000000
mPTIME_PTIME13:     equ    %10000000000000
mPTIME_PTIME14:     equ    %100000000000000
mPTIME_PTIME15:     equ    %1000000000000000


;*** IEVENT - Interrupt Event; 0x0000014A ***
IEVENT:             equ    $0000014A                                ;*** IEVENT - Interrupt Event; 0x0000014A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
IEVENT_TXCIF:       equ    1                                         ; Frame Transmission Complete Interrupt Flag
IEVENT_ECIF:        equ    4                                         ; Excessive Collision Interrupt Flag
IEVENT_LCIF:        equ    5                                         ; Late Collision Interrupt Flag
IEVENT_MMCIF:       equ    7                                         ; MII Management Transfer Complete Interrupt Flag
IEVENT_RXBCIF:      equ    8                                         ; Valid Frame Reception to Receive Buffer B Complete Interrupt Flag
IEVENT_RXACIF:      equ    9                                         ; Valid Frame Reception to Receive Buffer A Complete Interrupt Flag
IEVENT_RXBOIF:      equ    10                                        ; Receive Buffer B Overrun Interrupt Flag
IEVENT_RXAOIF:      equ    11                                        ; Receive Buffer A Overrun Interrupt Flag
IEVENT_RXEIF:       equ    12                                        ; Receive Error Interrupt Flag
IEVENT_BREIF:       equ    13                                        ; Babbling Receive Error Interrupt Flag
IEVENT_RFCIF:       equ    15                                        ; Receive Flow Control Interrupt Flag
; bit position masks
mIEVENT_TXCIF:      equ    %00000010
mIEVENT_ECIF:       equ    %00010000
mIEVENT_LCIF:       equ    %00100000
mIEVENT_MMCIF:      equ    %10000000
mIEVENT_RXBCIF:     equ    %100000000
mIEVENT_RXACIF:     equ    %1000000000
mIEVENT_RXBOIF:     equ    %10000000000
mIEVENT_RXAOIF:     equ    %100000000000
mIEVENT_RXEIF:      equ    %1000000000000
mIEVENT_BREIF:      equ    %10000000000000
mIEVENT_RFCIF:      equ    %1000000000000000


;*** IMASK - Interrupt Mask; 0x0000014C ***
IMASK:              equ    $0000014C                                ;*** IMASK - Interrupt Mask; 0x0000014C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
IMASK_TXCIE:        equ    1                                         ; Frame Transmission Complete Interrupt Enable
IMASK_ECIE:         equ    4                                         ; Excessive Collision Interrupt Enable
IMASK_LCIE:         equ    5                                         ; Late Collision Interrupt Enable
IMASK_MMCIE:        equ    7                                         ; MII Management Transfer Complete Interrupt Enable
IMASK_RXBCIE:       equ    8                                         ; Valid Frame Reception to Receive Buffer B Complete Interrupt Enable
IMASK_RXACIE:       equ    9                                         ; Valid Frame Reception to Receive Buffer A Complete Interrupt Enable
IMASK_RXBOIE:       equ    10                                        ; Receive Buffer B Overrun Interrupt Enable
IMASK_RXAOIE:       equ    11                                        ; Receive Buffer A Overrun Interrupt Enable
IMASK_RXEIE:        equ    12                                        ; Receive Error Interrupt Enable
IMASK_BREIE:        equ    13                                        ; Babbling Receive Error Interrupt Enable
IMASK_RFCIE:        equ    15                                        ; Receive Flow Control Interrupt Enable
; bit position masks
mIMASK_TXCIE:       equ    %00000010
mIMASK_ECIE:        equ    %00010000
mIMASK_LCIE:        equ    %00100000
mIMASK_MMCIE:       equ    %10000000
mIMASK_RXBCIE:      equ    %100000000
mIMASK_RXACIE:      equ    %1000000000
mIMASK_RXBOIE:      equ    %10000000000
mIMASK_RXAOIE:      equ    %100000000000
mIMASK_RXEIE:       equ    %1000000000000
mIMASK_BREIE:       equ    %10000000000000
mIMASK_RFCIE:       equ    %1000000000000000


;*** SWRST - Software Reset; 0x0000014E ***
SWRST:              equ    $0000014E                                ;*** SWRST - Software Reset; 0x0000014E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SWRST_MACRST:       equ    7                                         ; MAC Software Reset
; bit position masks
mSWRST_MACRST:      equ    %10000000


;*** MPADR - MII PHY Address; 0x00000150 ***
MPADR:              equ    $00000150                                ;*** MPADR - MII PHY Address; 0x00000150 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MPADR_PADDR0:       equ    0                                         ; MII PHY Address Bit 0
MPADR_PADDR1:       equ    1                                         ; MII PHY Address Bit 1
MPADR_PADDR2:       equ    2                                         ; MII PHY Address Bit 2
MPADR_PADDR3:       equ    3                                         ; MII PHY Address Bit 3
MPADR_PADDR4:       equ    4                                         ; MII PHY Address Bit 4
; bit position masks
mMPADR_PADDR0:      equ    %00000001
mMPADR_PADDR1:      equ    %00000010
mMPADR_PADDR2:      equ    %00000100
mMPADR_PADDR3:      equ    %00001000
mMPADR_PADDR4:      equ    %00010000


;*** MRADR - MII Register Address; 0x00000151 ***
MRADR:              equ    $00000151                                ;*** MRADR - MII Register Address; 0x00000151 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MRADR_RADDR0:       equ    0                                         ; MII Register Address Bit 0
MRADR_RADDR1:       equ    1                                         ; MII Register Address Bit 1
MRADR_RADDR2:       equ    2                                         ; MII Register Address Bit 2
MRADR_RADDR3:       equ    3                                         ; MII Register Address Bit 3
MRADR_RADDR4:       equ    4                                         ; MII Register Address Bit 4
; bit position masks
mMRADR_RADDR0:      equ    %00000001
mMRADR_RADDR1:      equ    %00000010
mMRADR_RADDR2:      equ    %00000100
mMRADR_RADDR3:      equ    %00001000
mMRADR_RADDR4:      equ    %00010000


;*** MWDATA - MII Write Data; 0x00000152 ***
MWDATA:             equ    $00000152                                ;*** MWDATA - MII Write Data; 0x00000152 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MWDATA_WDATA0:      equ    0                                         ; MII Write Data Bit 0
MWDATA_WDATA1:      equ    1                                         ; MII Write Data Bit 1
MWDATA_WDATA2:      equ    2                                         ; MII Write Data Bit 2
MWDATA_WDATA3:      equ    3                                         ; MII Write Data Bit 3
MWDATA_WDATA4:      equ    4                                         ; MII Write Data Bit 4
MWDATA_WDATA5:      equ    5                                         ; MII Write Data Bit 5
MWDATA_WDATA6:      equ    6                                         ; MII Write Data Bit 6
MWDATA_WDATA7:      equ    7                                         ; MII Write Data Bit 7
MWDATA_WDATA8:      equ    8                                         ; MII Write Data Bit 8
MWDATA_WDATA9:      equ    9                                         ; MII Write Data Bit 9
MWDATA_WDATA10:     equ    10                                        ; MII Write Data Bit 10
MWDATA_WDATA11:     equ    11                                        ; MII Write Data Bit 11
MWDATA_WDATA12:     equ    12                                        ; MII Write Data Bit 12
MWDATA_WDATA13:     equ    13                                        ; MII Write Data Bit 13
MWDATA_WDATA14:     equ    14                                        ; MII Write Data Bit 14
MWDATA_WDATA15:     equ    15                                        ; MII Write Data Bit 15
; bit position masks
mMWDATA_WDATA0:     equ    %00000001
mMWDATA_WDATA1:     equ    %00000010
mMWDATA_WDATA2:     equ    %00000100
mMWDATA_WDATA3:     equ    %00001000
mMWDATA_WDATA4:     equ    %00010000
mMWDATA_WDATA5:     equ    %00100000
mMWDATA_WDATA6:     equ    %01000000
mMWDATA_WDATA7:     equ    %10000000
mMWDATA_WDATA8:     equ    %100000000
mMWDATA_WDATA9:     equ    %1000000000
mMWDATA_WDATA10:    equ    %10000000000
mMWDATA_WDATA11:    equ    %100000000000
mMWDATA_WDATA12:    equ    %1000000000000
mMWDATA_WDATA13:    equ    %10000000000000
mMWDATA_WDATA14:    equ    %100000000000000
mMWDATA_WDATA15:    equ    %1000000000000000


;*** MRDATA - MII Read Data; 0x00000154 ***
MRDATA:             equ    $00000154                                ;*** MRDATA - MII Read Data; 0x00000154 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MRDATA_RDATA0:      equ    0                                         ; MII Read Data Bit 0
MRDATA_RDATA1:      equ    1                                         ; MII Read Data Bit 1
MRDATA_RDATA2:      equ    2                                         ; MII Read Data Bit 2
MRDATA_RDATA3:      equ    3                                         ; MII Read Data Bit 3
MRDATA_RDATA4:      equ    4                                         ; MII Read Data Bit 4
MRDATA_RDATA5:      equ    5                                         ; MII Read Data Bit 5
MRDATA_RDATA6:      equ    6                                         ; MII Read Data Bit 6
MRDATA_RDATA7:      equ    7                                         ; MII Read Data Bit 7
MRDATA_RDATA8:      equ    8                                         ; MII Read Data Bit 8
MRDATA_RDATA9:      equ    9                                         ; MII Read Data Bit 9
MRDATA_RDATA10:     equ    10                                        ; MII Read Data Bit 10
MRDATA_RDATA11:     equ    11                                        ; MII Read Data Bit 11
MRDATA_RDATA12:     equ    12                                        ; MII Read Data Bit 12
MRDATA_RDATA13:     equ    13                                        ; MII Read Data Bit 13
MRDATA_RDATA14:     equ    14                                        ; MII Read Data Bit 14
MRDATA_RDATA15:     equ    15                                        ; MII Read Data Bit 15
; bit position masks
mMRDATA_RDATA0:     equ    %00000001
mMRDATA_RDATA1:     equ    %00000010
mMRDATA_RDATA2:     equ    %00000100
mMRDATA_RDATA3:     equ    %00001000
mMRDATA_RDATA4:     equ    %00010000
mMRDATA_RDATA5:     equ    %00100000
mMRDATA_RDATA6:     equ    %01000000
mMRDATA_RDATA7:     equ    %10000000
mMRDATA_RDATA8:     equ    %100000000
mMRDATA_RDATA9:     equ    %1000000000
mMRDATA_RDATA10:    equ    %10000000000
mMRDATA_RDATA11:    equ    %100000000000
mMRDATA_RDATA12:    equ    %1000000000000
mMRDATA_RDATA13:    equ    %10000000000000
mMRDATA_RDATA14:    equ    %100000000000000
mMRDATA_RDATA15:    equ    %1000000000000000


;*** MCMST - MII Command and Status; 0x00000156 ***
MCMST:              equ    $00000156                                ;*** MCMST - MII Command and Status; 0x00000156 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MCMST_MDCSEL0:      equ    0                                         ; Management Clock Rate Select Bit 0
MCMST_MDCSEL1:      equ    1                                         ; Management Clock Rate Select Bit 1
MCMST_MDCSEL2:      equ    2                                         ; Management Clock Rate Select Bit 2
MCMST_MDCSEL3:      equ    3                                         ; Management Clock Rate Select Bit 3
MCMST_NOPRE:        equ    4                                         ; No Preamble
MCMST_BUSY:         equ    5                                         ; Operation in Progress
MCMST_OP0:          equ    6                                         ; Operation Code Bit 0
MCMST_OP1:          equ    7                                         ; Operation Code Bit 1
; bit position masks
mMCMST_MDCSEL0:     equ    %00000001
mMCMST_MDCSEL1:     equ    %00000010
mMCMST_MDCSEL2:     equ    %00000100
mMCMST_MDCSEL3:     equ    %00001000
mMCMST_NOPRE:       equ    %00010000
mMCMST_BUSY:        equ    %00100000
mMCMST_OP0:         equ    %01000000
mMCMST_OP1:         equ    %10000000


;*** BUFCFG - FIFO Buffer Configuration; 0x00000158 ***
BUFCFG:             equ    $00000158                                ;*** BUFCFG - FIFO Buffer Configuration; 0x00000158 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
BUFCFG_MAXFL0:      equ    0                                         ; Receive Maximum Frame Length Bit 0
BUFCFG_MAXFL1:      equ    1                                         ; Receive Maximum Frame Length Bit 1
BUFCFG_MAXFL2:      equ    2                                         ; Receive Maximum Frame Length Bit 2
BUFCFG_MAXFL3:      equ    3                                         ; Receive Maximum Frame Length Bit 3
BUFCFG_MAXFL4:      equ    4                                         ; Receive Maximum Frame Length Bit 4
BUFCFG_MAXFL5:      equ    5                                         ; Receive Maximum Frame Length Bit 5
BUFCFG_MAXFL6:      equ    6                                         ; Receive Maximum Frame Length Bit 6
BUFCFG_MAXFL7:      equ    7                                         ; Receive Maximum Frame Length Bit 7
BUFCFG_MAXFL8:      equ    8                                         ; Receive Maximum Frame Length Bit 8
BUFCFG_MAXFL9:      equ    9                                         ; Receive Maximum Frame Length Bit 9
BUFCFG_MAXFL10:     equ    10                                        ; Receive Maximum Frame Length Bit 10
BUFCFG_BUFMAP0:     equ    12                                        ; Buffer Size and Starting Address Mapping Bit 0
BUFCFG_BUFMAP1:     equ    13                                        ; Buffer Size and Starting Address Mapping Bit 1
BUFCFG_BUFMAP2:     equ    14                                        ; Buffer Size and Starting Address Mapping Bit 2
BUFCFG_BUFMAP3:     equ    15                                        ; Buffer Size and Starting Address Mapping Bit 3
; bit position masks
mBUFCFG_MAXFL0:     equ    %00000001
mBUFCFG_MAXFL1:     equ    %00000010
mBUFCFG_MAXFL2:     equ    %00000100
mBUFCFG_MAXFL3:     equ    %00001000
mBUFCFG_MAXFL4:     equ    %00010000
mBUFCFG_MAXFL5:     equ    %00100000
mBUFCFG_MAXFL6:     equ    %01000000
mBUFCFG_MAXFL7:     equ    %10000000
mBUFCFG_MAXFL8:     equ    %100000000
mBUFCFG_MAXFL9:     equ    %1000000000
mBUFCFG_MAXFL10:    equ    %10000000000
mBUFCFG_BUFMAP0:    equ    %1000000000000
mBUFCFG_BUFMAP1:    equ    %10000000000000
mBUFCFG_BUFMAP2:    equ    %100000000000000
mBUFCFG_BUFMAP3:    equ    %1000000000000000


;*** RXAEFP - Receive A End of Frame Pointer; 0x0000015A ***
RXAEFP:             equ    $0000015A                                ;*** RXAEFP - Receive A End of Frame Pointer; 0x0000015A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RXAEFP_RXAEFP0:     equ    0                                         ; Receive A End of Frame Pointer Bit 0
RXAEFP_RXAEFP1:     equ    1                                         ; Receive A End of Frame Pointer Bit 1
RXAEFP_RXAEFP2:     equ    2                                         ; Receive A End of Frame Pointer Bit 2
RXAEFP_RXAEFP3:     equ    3                                         ; Receive A End of Frame Pointer Bit 3
RXAEFP_RXAEFP4:     equ    4                                         ; Receive A End of Frame Pointer Bit 4
RXAEFP_RXAEFP5:     equ    5                                         ; Receive A End of Frame Pointer Bit 5
RXAEFP_RXAEFP6:     equ    6                                         ; Receive A End of Frame Pointer Bit 6
RXAEFP_RXAEFP7:     equ    7                                         ; Receive A End of Frame Pointer Bit 7
RXAEFP_RXAEFP8:     equ    8                                         ; Receive A End of Frame Pointer Bit 8
RXAEFP_RXAEFP9:     equ    9                                         ; Receive A End of Frame Pointer Bit 9
RXAEFP_RXAEFP10:    equ    10                                        ; Receive A End of Frame Pointer Bit 10
; bit position masks
mRXAEFP_RXAEFP0:    equ    %00000001
mRXAEFP_RXAEFP1:    equ    %00000010
mRXAEFP_RXAEFP2:    equ    %00000100
mRXAEFP_RXAEFP3:    equ    %00001000
mRXAEFP_RXAEFP4:    equ    %00010000
mRXAEFP_RXAEFP5:    equ    %00100000
mRXAEFP_RXAEFP6:    equ    %01000000
mRXAEFP_RXAEFP7:    equ    %10000000
mRXAEFP_RXAEFP8:    equ    %100000000
mRXAEFP_RXAEFP9:    equ    %1000000000
mRXAEFP_RXAEFP10:   equ    %10000000000


;*** RXBEFP - Receive B End of Frame Pointer; 0x0000015C ***
RXBEFP:             equ    $0000015C                                ;*** RXBEFP - Receive B End of Frame Pointer; 0x0000015C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RXBEFP_RXBEFP0:     equ    0                                         ; Receive B End of Frame Pointer Bit 0
RXBEFP_RXBEFP1:     equ    1                                         ; Receive B End of Frame Pointer Bit 1
RXBEFP_RXBEFP2:     equ    2                                         ; Receive B End of Frame Pointer Bit 2
RXBEFP_RXBEFP3:     equ    3                                         ; Receive B End of Frame Pointer Bit 3
RXBEFP_RXBEFP4:     equ    4                                         ; Receive B End of Frame Pointer Bit 4
RXBEFP_RXBEFP5:     equ    5                                         ; Receive B End of Frame Pointer Bit 5
RXBEFP_RXBEFP6:     equ    6                                         ; Receive B End of Frame Pointer Bit 6
RXBEFP_RXBEFP7:     equ    7                                         ; Receive B End of Frame Pointer Bit 7
RXBEFP_RXBEFP8:     equ    8                                         ; Receive B End of Frame Pointer Bit 8
RXBEFP_RXBEFP9:     equ    9                                         ; Receive B End of Frame Pointer Bit 9
RXBEFP_RXBEFP10:    equ    10                                        ; Receive B End of Frame Pointer Bit 10
; bit position masks
mRXBEFP_RXBEFP0:    equ    %00000001
mRXBEFP_RXBEFP1:    equ    %00000010
mRXBEFP_RXBEFP2:    equ    %00000100
mRXBEFP_RXBEFP3:    equ    %00001000
mRXBEFP_RXBEFP4:    equ    %00010000
mRXBEFP_RXBEFP5:    equ    %00100000
mRXBEFP_RXBEFP6:    equ    %01000000
mRXBEFP_RXBEFP7:    equ    %10000000
mRXBEFP_RXBEFP8:    equ    %100000000
mRXBEFP_RXBEFP9:    equ    %1000000000
mRXBEFP_RXBEFP10:   equ    %10000000000


;*** TXEFP - Transmit End of Frame Pointer; 0x0000015E ***
TXEFP:              equ    $0000015E                                ;*** TXEFP - Transmit End of Frame Pointer; 0x0000015E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TXEFP_TXEFP0:       equ    0                                         ; Transmit End of Frame Pointer Bit 0
TXEFP_TXEFP1:       equ    1                                         ; Transmit End of Frame Pointer Bit 1
TXEFP_TXEFP2:       equ    2                                         ; Transmit End of Frame Pointer Bit 2
TXEFP_TXEFP3:       equ    3                                         ; Transmit End of Frame Pointer Bit 3
TXEFP_TXEFP4:       equ    4                                         ; Transmit End of Frame Pointer Bit 4
TXEFP_TXEFP5:       equ    5                                         ; Transmit End of Frame Pointer Bit 5
TXEFP_TXEFP6:       equ    6                                         ; Transmit End of Frame Pointer Bit 6
TXEFP_TXEFP7:       equ    7                                         ; Transmit End of Frame Pointer Bit 7
TXEFP_TXEFP8:       equ    8                                         ; Transmit End of Frame Pointer Bit 8
TXEFP_TXEFP9:       equ    9                                         ; Transmit End of Frame Pointer Bit 9
TXEFP_TXEFP10:      equ    10                                        ; Transmit End of Frame Pointer Bit 10
; bit position masks
mTXEFP_TXEFP0:      equ    %00000001
mTXEFP_TXEFP1:      equ    %00000010
mTXEFP_TXEFP2:      equ    %00000100
mTXEFP_TXEFP3:      equ    %00001000
mTXEFP_TXEFP4:      equ    %00010000
mTXEFP_TXEFP5:      equ    %00100000
mTXEFP_TXEFP6:      equ    %01000000
mTXEFP_TXEFP7:      equ    %10000000
mTXEFP_TXEFP8:      equ    %100000000
mTXEFP_TXEFP9:      equ    %1000000000
mTXEFP_TXEFP10:     equ    %10000000000


;*** MCHASH3 - Multicast Hash Table Register 3; 0x00000160 ***
MCHASH3:            equ    $00000160                                ;*** MCHASH3 - Multicast Hash Table Register 3; 0x00000160 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MCHASH3_MCHASH_48:  equ    0                                         ; Multicast Hash Table Index Bit 48
MCHASH3_MCHASH_49:  equ    1                                         ; Multicast Hash Table Index Bit 49
MCHASH3_MCHASH_50:  equ    2                                         ; Multicast Hash Table Index Bit 50
MCHASH3_MCHASH_51:  equ    3                                         ; Multicast Hash Table Index Bit 51
MCHASH3_MCHASH_52:  equ    4                                         ; Multicast Hash Table Index Bit 52
MCHASH3_MCHASH_53:  equ    5                                         ; Multicast Hash Table Index Bit 53
MCHASH3_MCHASH_54:  equ    6                                         ; Multicast Hash Table Index Bit 54
MCHASH3_MCHASH_55:  equ    7                                         ; Multicast Hash Table Index Bit 55
MCHASH3_MCHASH_56:  equ    8                                         ; Multicast Hash Table Index Bit 56
MCHASH3_MCHASH_57:  equ    9                                         ; Multicast Hash Table Index Bit 57
MCHASH3_MCHASH_58:  equ    10                                        ; Multicast Hash Table Index Bit 58
MCHASH3_MCHASH_59:  equ    11                                        ; Multicast Hash Table Index Bit 59
MCHASH3_MCHASH_60:  equ    12                                        ; Multicast Hash Table Index Bit 60
MCHASH3_MCHASH_61:  equ    13                                        ; Multicast Hash Table Index Bit 61
MCHASH3_MCHASH_62:  equ    14                                        ; Multicast Hash Table Index Bit 62
MCHASH3_MCHASH_63:  equ    15                                        ; Multicast Hash Table Index Bit 63
; bit position masks
mMCHASH3_MCHASH_48: equ    %00000001
mMCHASH3_MCHASH_49: equ    %00000010
mMCHASH3_MCHASH_50: equ    %00000100
mMCHASH3_MCHASH_51: equ    %00001000
mMCHASH3_MCHASH_52: equ    %00010000
mMCHASH3_MCHASH_53: equ    %00100000
mMCHASH3_MCHASH_54: equ    %01000000
mMCHASH3_MCHASH_55: equ    %10000000
mMCHASH3_MCHASH_56: equ    %100000000
mMCHASH3_MCHASH_57: equ    %1000000000
mMCHASH3_MCHASH_58: equ    %10000000000
mMCHASH3_MCHASH_59: equ    %100000000000
mMCHASH3_MCHASH_60: equ    %1000000000000
mMCHASH3_MCHASH_61: equ    %10000000000000
mMCHASH3_MCHASH_62: equ    %100000000000000
mMCHASH3_MCHASH_63: equ    %1000000000000000


;*** MCHASH2 - Multicast Hash Table Register 2; 0x00000162 ***
MCHASH2:            equ    $00000162                                ;*** MCHASH2 - Multicast Hash Table Register 2; 0x00000162 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MCHASH2_MCHASH_32:  equ    0                                         ; Multicast Hash Table Index Bit 32
MCHASH2_MCHASH_33:  equ    1                                         ; Multicast Hash Table Index Bit 33
MCHASH2_MCHASH_34:  equ    2                                         ; Multicast Hash Table Index Bit 34
MCHASH2_MCHASH_35:  equ    3                                         ; Multicast Hash Table Index Bit 35
MCHASH2_MCHASH_36:  equ    4                                         ; Multicast Hash Table Index Bit 36
MCHASH2_MCHASH_37:  equ    5                                         ; Multicast Hash Table Index Bit 37
MCHASH2_MCHASH_38:  equ    6                                         ; Multicast Hash Table Index Bit 38
MCHASH2_MCHASH_39:  equ    7                                         ; Multicast Hash Table Index Bit 39
MCHASH2_MCHASH_40:  equ    8                                         ; Multicast Hash Table Index Bit 40
MCHASH2_MCHASH_41:  equ    9                                         ; Multicast Hash Table Index Bit 41
MCHASH2_MCHASH_42:  equ    10                                        ; Multicast Hash Table Index Bit 42
MCHASH2_MCHASH_43:  equ    11                                        ; Multicast Hash Table Index Bit 43
MCHASH2_MCHASH_44:  equ    12                                        ; Multicast Hash Table Index Bit 44
MCHASH2_MCHASH_45:  equ    13                                        ; Multicast Hash Table Index Bit 45
MCHASH2_MCHASH_46:  equ    14                                        ; Multicast Hash Table Index Bit 46
MCHASH2_MCHASH_47:  equ    15                                        ; Multicast Hash Table Index Bit 47
; bit position masks
mMCHASH2_MCHASH_32: equ    %00000001
mMCHASH2_MCHASH_33: equ    %00000010
mMCHASH2_MCHASH_34: equ    %00000100
mMCHASH2_MCHASH_35: equ    %00001000
mMCHASH2_MCHASH_36: equ    %00010000
mMCHASH2_MCHASH_37: equ    %00100000
mMCHASH2_MCHASH_38: equ    %01000000
mMCHASH2_MCHASH_39: equ    %10000000
mMCHASH2_MCHASH_40: equ    %100000000
mMCHASH2_MCHASH_41: equ    %1000000000
mMCHASH2_MCHASH_42: equ    %10000000000
mMCHASH2_MCHASH_43: equ    %100000000000
mMCHASH2_MCHASH_44: equ    %1000000000000
mMCHASH2_MCHASH_45: equ    %10000000000000
mMCHASH2_MCHASH_46: equ    %100000000000000
mMCHASH2_MCHASH_47: equ    %1000000000000000


;*** MCHASH1 - Multicast Hash Table Register 1; 0x00000164 ***
MCHASH1:            equ    $00000164                                ;*** MCHASH1 - Multicast Hash Table Register 1; 0x00000164 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MCHASH1_MCHASH_16:  equ    0                                         ; Multicast Hash Table Index Bit 16
MCHASH1_MCHASH_17:  equ    1                                         ; Multicast Hash Table Index Bit 17
MCHASH1_MCHASH_18:  equ    2                                         ; Multicast Hash Table Index Bit 18
MCHASH1_MCHASH_19:  equ    3                                         ; Multicast Hash Table Index Bit 19
MCHASH1_MCHASH_20:  equ    4                                         ; Multicast Hash Table Index Bit 20
MCHASH1_MCHASH_21:  equ    5                                         ; Multicast Hash Table Index Bit 21
MCHASH1_MCHASH_22:  equ    6                                         ; Multicast Hash Table Index Bit 22
MCHASH1_MCHASH_23:  equ    7                                         ; Multicast Hash Table Index Bit 23
MCHASH1_MCHASH_24:  equ    8                                         ; Multicast Hash Table Index Bit 24
MCHASH1_MCHASH_25:  equ    9                                         ; Multicast Hash Table Index Bit 25
MCHASH1_MCHASH_26:  equ    10                                        ; Multicast Hash Table Index Bit 26
MCHASH1_MCHASH_27:  equ    11                                        ; Multicast Hash Table Index Bit 27
MCHASH1_MCHASH_28:  equ    12                                        ; Multicast Hash Table Index Bit 28
MCHASH1_MCHASH_29:  equ    13                                        ; Multicast Hash Table Index Bit 29
MCHASH1_MCHASH_30:  equ    14                                        ; Multicast Hash Table Index Bit 30
MCHASH1_MCHASH_31:  equ    15                                        ; Multicast Hash Table Index Bit 31
; bit position masks
mMCHASH1_MCHASH_16: equ    %00000001
mMCHASH1_MCHASH_17: equ    %00000010
mMCHASH1_MCHASH_18: equ    %00000100
mMCHASH1_MCHASH_19: equ    %00001000
mMCHASH1_MCHASH_20: equ    %00010000
mMCHASH1_MCHASH_21: equ    %00100000
mMCHASH1_MCHASH_22: equ    %01000000
mMCHASH1_MCHASH_23: equ    %10000000
mMCHASH1_MCHASH_24: equ    %100000000
mMCHASH1_MCHASH_25: equ    %1000000000
mMCHASH1_MCHASH_26: equ    %10000000000
mMCHASH1_MCHASH_27: equ    %100000000000
mMCHASH1_MCHASH_28: equ    %1000000000000
mMCHASH1_MCHASH_29: equ    %10000000000000
mMCHASH1_MCHASH_30: equ    %100000000000000
mMCHASH1_MCHASH_31: equ    %1000000000000000


;*** MCHASH0 - Multicast Hash Table Register 0; 0x00000166 ***
MCHASH0:            equ    $00000166                                ;*** MCHASH0 - Multicast Hash Table Register 0; 0x00000166 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MCHASH0_MCHASH_0:   equ    0                                         ; Multicast Hash Table Index Bit 0
MCHASH0_MCHASH_1:   equ    1                                         ; Multicast Hash Table Index Bit 1
MCHASH0_MCHASH_2:   equ    2                                         ; Multicast Hash Table Index Bit 2
MCHASH0_MCHASH_3:   equ    3                                         ; Multicast Hash Table Index Bit 3
MCHASH0_MCHASH_4:   equ    4                                         ; Multicast Hash Table Index Bit 4
MCHASH0_MCHASH_5:   equ    5                                         ; Multicast Hash Table Index Bit 5
MCHASH0_MCHASH_6:   equ    6                                         ; Multicast Hash Table Index Bit 6
MCHASH0_MCHASH_7:   equ    7                                         ; Multicast Hash Table Index Bit 7
MCHASH0_MCHASH_8:   equ    8                                         ; Multicast Hash Table Index Bit 8
MCHASH0_MCHASH_9:   equ    9                                         ; Multicast Hash Table Index Bit 9
MCHASH0_MCHASH_10:  equ    10                                        ; Multicast Hash Table Index Bit 10
MCHASH0_MCHASH_11:  equ    11                                        ; Multicast Hash Table Index Bit 11
MCHASH0_MCHASH_12:  equ    12                                        ; Multicast Hash Table Index Bit 12
MCHASH0_MCHASH_13:  equ    13                                        ; Multicast Hash Table Index Bit 13
MCHASH0_MCHASH_14:  equ    14                                        ; Multicast Hash Table Index Bit 14
MCHASH0_MCHASH_15:  equ    15                                        ; Multicast Hash Table Index Bit 15
; bit position masks
mMCHASH0_MCHASH_0:  equ    %00000001
mMCHASH0_MCHASH_1:  equ    %00000010
mMCHASH0_MCHASH_2:  equ    %00000100
mMCHASH0_MCHASH_3:  equ    %00001000
mMCHASH0_MCHASH_4:  equ    %00010000
mMCHASH0_MCHASH_5:  equ    %00100000
mMCHASH0_MCHASH_6:  equ    %01000000
mMCHASH0_MCHASH_7:  equ    %10000000
mMCHASH0_MCHASH_8:  equ    %100000000
mMCHASH0_MCHASH_9:  equ    %1000000000
mMCHASH0_MCHASH_10: equ    %10000000000
mMCHASH0_MCHASH_11: equ    %100000000000
mMCHASH0_MCHASH_12: equ    %1000000000000
mMCHASH0_MCHASH_13: equ    %10000000000000
mMCHASH0_MCHASH_14: equ    %100000000000000
mMCHASH0_MCHASH_15: equ    %1000000000000000


;*** MACAD2 - MAC Address Register 2; 0x00000168 ***
MACAD2:             equ    $00000168                                ;*** MACAD2 - MAC Address Register 2; 0x00000168 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MACAD2_MACAD_32:    equ    0                                         ; MAC Address Bit 32
MACAD2_MACAD_33:    equ    1                                         ; MAC Address Bit 33
MACAD2_MACAD_34:    equ    2                                         ; MAC Address Bit 34
MACAD2_MACAD_35:    equ    3                                         ; MAC Address Bit 35
MACAD2_MACAD_36:    equ    4                                         ; MAC Address Bit 36
MACAD2_MACAD_37:    equ    5                                         ; MAC Address Bit 37
MACAD2_MACAD_38:    equ    6                                         ; MAC Address Bit 38
MACAD2_MACAD_39:    equ    7                                         ; MAC Address Bit 39
MACAD2_MACAD_40:    equ    8                                         ; MAC Address Bit 40
MACAD2_MACAD_41:    equ    9                                         ; MAC Address Bit 41
MACAD2_MACAD_42:    equ    10                                        ; MAC Address Bit 42
MACAD2_MACAD_43:    equ    11                                        ; MAC Address Bit 43
MACAD2_MACAD_44:    equ    12                                        ; MAC Address Bit 44
MACAD2_MACAD_45:    equ    13                                        ; MAC Address Bit 45
MACAD2_MACAD_46:    equ    14                                        ; MAC Address Bit 46
MACAD2_MACAD_47:    equ    15                                        ; MAC Address Bit 47
; bit position masks
mMACAD2_MACAD_32:   equ    %00000001
mMACAD2_MACAD_33:   equ    %00000010
mMACAD2_MACAD_34:   equ    %00000100
mMACAD2_MACAD_35:   equ    %00001000
mMACAD2_MACAD_36:   equ    %00010000
mMACAD2_MACAD_37:   equ    %00100000
mMACAD2_MACAD_38:   equ    %01000000
mMACAD2_MACAD_39:   equ    %10000000
mMACAD2_MACAD_40:   equ    %100000000
mMACAD2_MACAD_41:   equ    %1000000000
mMACAD2_MACAD_42:   equ    %10000000000
mMACAD2_MACAD_43:   equ    %100000000000
mMACAD2_MACAD_44:   equ    %1000000000000
mMACAD2_MACAD_45:   equ    %10000000000000
mMACAD2_MACAD_46:   equ    %100000000000000
mMACAD2_MACAD_47:   equ    %1000000000000000


;*** MACAD1 - MAC Address Register 1; 0x0000016A ***
MACAD1:             equ    $0000016A                                ;*** MACAD1 - MAC Address Register 1; 0x0000016A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MACAD1_MACAD_16:    equ    0                                         ; MAC Address Bit 16
MACAD1_MACAD_17:    equ    1                                         ; MAC Address Bit 17
MACAD1_MACAD_18:    equ    2                                         ; MAC Address Bit 18
MACAD1_MACAD_19:    equ    3                                         ; MAC Address Bit 19
MACAD1_MACAD_20:    equ    4                                         ; MAC Address Bit 20
MACAD1_MACAD_21:    equ    5                                         ; MAC Address Bit 21
MACAD1_MACAD_22:    equ    6                                         ; MAC Address Bit 22
MACAD1_MACAD_23:    equ    7                                         ; MAC Address Bit 23
MACAD1_MACAD_24:    equ    8                                         ; MAC Address Bit 24
MACAD1_MACAD_25:    equ    9                                         ; MAC Address Bit 25
MACAD1_MACAD_26:    equ    10                                        ; MAC Address Bit 26
MACAD1_MACAD_27:    equ    11                                        ; MAC Address Bit 27
MACAD1_MACAD_28:    equ    12                                        ; MAC Address Bit 28
MACAD1_MACAD_29:    equ    13                                        ; MAC Address Bit 29
MACAD1_MACAD_30:    equ    14                                        ; MAC Address Bit 30
MACAD1_MACAD_31:    equ    15                                        ; MAC Address Bit 31
; bit position masks
mMACAD1_MACAD_16:   equ    %00000001
mMACAD1_MACAD_17:   equ    %00000010
mMACAD1_MACAD_18:   equ    %00000100
mMACAD1_MACAD_19:   equ    %00001000
mMACAD1_MACAD_20:   equ    %00010000
mMACAD1_MACAD_21:   equ    %00100000
mMACAD1_MACAD_22:   equ    %01000000
mMACAD1_MACAD_23:   equ    %10000000
mMACAD1_MACAD_24:   equ    %100000000
mMACAD1_MACAD_25:   equ    %1000000000
mMACAD1_MACAD_26:   equ    %10000000000
mMACAD1_MACAD_27:   equ    %100000000000
mMACAD1_MACAD_28:   equ    %1000000000000
mMACAD1_MACAD_29:   equ    %10000000000000
mMACAD1_MACAD_30:   equ    %100000000000000
mMACAD1_MACAD_31:   equ    %1000000000000000


;*** MACAD0 - MAC Address Register 0; 0x0000016C ***
MACAD0:             equ    $0000016C                                ;*** MACAD0 - MAC Address Register 0; 0x0000016C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MACAD0_MACAD_0:     equ    0                                         ; MAC Address Bit 0
MACAD0_MACAD_1:     equ    1                                         ; MAC Address Bit 1
MACAD0_MACAD_2:     equ    2                                         ; MAC Address Bit 2
MACAD0_MACAD_3:     equ    3                                         ; MAC Address Bit 3
MACAD0_MACAD_4:     equ    4                                         ; MAC Address Bit 4
MACAD0_MACAD_5:     equ    5                                         ; MAC Address Bit 5
MACAD0_MACAD_6:     equ    6                                         ; MAC Address Bit 6
MACAD0_MACAD_7:     equ    7                                         ; MAC Address Bit 7
MACAD0_MACAD_8:     equ    8                                         ; MAC Address Bit 8
MACAD0_MACAD_9:     equ    9                                         ; MAC Address Bit 9
MACAD0_MACAD_10:    equ    10                                        ; MAC Address Bit 10
MACAD0_MACAD_11:    equ    11                                        ; MAC Address Bit 11
MACAD0_MACAD_12:    equ    12                                        ; MAC Address Bit 12
MACAD0_MACAD_13:    equ    13                                        ; MAC Address Bit 13
MACAD0_MACAD_14:    equ    14                                        ; MAC Address Bit 14
MACAD0_MACAD_15:    equ    15                                        ; MAC Address Bit 15
; bit position masks
mMACAD0_MACAD_0:    equ    %00000001
mMACAD0_MACAD_1:    equ    %00000010
mMACAD0_MACAD_2:    equ    %00000100
mMACAD0_MACAD_3:    equ    %00001000
mMACAD0_MACAD_4:    equ    %00010000
mMACAD0_MACAD_5:    equ    %00100000
mMACAD0_MACAD_6:    equ    %01000000
mMACAD0_MACAD_7:    equ    %10000000
mMACAD0_MACAD_8:    equ    %100000000
mMACAD0_MACAD_9:    equ    %1000000000
mMACAD0_MACAD_10:   equ    %10000000000
mMACAD0_MACAD_11:   equ    %100000000000
mMACAD0_MACAD_12:   equ    %1000000000000
mMACAD0_MACAD_13:   equ    %10000000000000
mMACAD0_MACAD_14:   equ    %100000000000000
mMACAD0_MACAD_15:   equ    %1000000000000000


;*** EMISC - MAC Address Register 3; 0x0000016E ***
EMISC:              equ    $0000016E                                ;*** EMISC - MAC Address Register 3; 0x0000016E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
EMISC_EMISC0:       equ    0                                         ; EMISC Bit 0
EMISC_EMISC1:       equ    1                                         ; EMISC Bit 1
EMISC_EMISC2:       equ    2                                         ; EMISC Bit 2
EMISC_EMISC3:       equ    3                                         ; EMISC Bit 3
EMISC_EMISC4:       equ    4                                         ; EMISC Bit 4
EMISC_EMISC5:       equ    5                                         ; EMISC Bit 5
EMISC_EMISC6:       equ    6                                         ; EMISC Bit 6
EMISC_EMISC7:       equ    7                                         ; EMISC Bit 7
EMISC_EMISC8:       equ    8                                         ; EMISC Bit 8
EMISC_EMISC9:       equ    9                                         ; EMISC Bit 9
EMISC_EMISC10:      equ    10                                        ; EMISC Bit 10
EMISC_INDEX0:       equ    13                                        ; Miscellaneous Index Bit 0
EMISC_INDEX1:       equ    14                                        ; Miscellaneous Index Bit 1
EMISC_INDEX2:       equ    15                                        ; Miscellaneous Index Bit 2
; bit position masks
mEMISC_EMISC0:      equ    %00000001
mEMISC_EMISC1:      equ    %00000010
mEMISC_EMISC2:      equ    %00000100
mEMISC_EMISC3:      equ    %00001000
mEMISC_EMISC4:      equ    %00010000
mEMISC_EMISC5:      equ    %00100000
mEMISC_EMISC6:      equ    %01000000
mEMISC_EMISC7:      equ    %10000000
mEMISC_EMISC8:      equ    %100000000
mEMISC_EMISC9:      equ    %1000000000
mEMISC_EMISC10:     equ    %10000000000
mEMISC_INDEX0:      equ    %10000000000000
mEMISC_INDEX1:      equ    %100000000000000
mEMISC_INDEX2:      equ    %1000000000000000


;*** PTT - Port T I/O Register; 0x00000240 ***
PTT:                equ    $00000240                                ;*** PTT - Port T I/O Register; 0x00000240 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTT_PTT4:           equ    4                                         ; Port T Bit 4
PTT_PTT5:           equ    5                                         ; Port T Bit 5
PTT_PTT6:           equ    6                                         ; Port T Bit 6
PTT_PTT7:           equ    7                                         ; Port T Bit 7
; bit position masks
mPTT_PTT4:          equ    %00010000
mPTT_PTT5:          equ    %00100000
mPTT_PTT6:          equ    %01000000
mPTT_PTT7:          equ    %10000000


;*** PTIT - Port T Input Register; 0x00000241 ***
PTIT:               equ    $00000241                                ;*** PTIT - Port T Input Register; 0x00000241 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTIT_PTIT4:         equ    4                                         ; Port T Bit 4
PTIT_PTIT5:         equ    5                                         ; Port T Bit 5
PTIT_PTIT6:         equ    6                                         ; Port T Bit 6
PTIT_PTIT7:         equ    7                                         ; Port T Bit 7
; bit position masks
mPTIT_PTIT4:        equ    %00010000
mPTIT_PTIT5:        equ    %00100000
mPTIT_PTIT6:        equ    %01000000
mPTIT_PTIT7:        equ    %10000000


;*** DDRT - Port T Data Direction Register; 0x00000242 ***
DDRT:               equ    $00000242                                ;*** DDRT - Port T Data Direction Register; 0x00000242 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRT_DDRT4:         equ    4                                         ; Data Direction Port T Bit 4
DDRT_DDRT5:         equ    5                                         ; Data Direction Port T Bit 5
DDRT_DDRT6:         equ    6                                         ; Data Direction Port T Bit 6
DDRT_DDRT7:         equ    7                                         ; Data Direction Port T Bit 7
; bit position masks
mDDRT_DDRT4:        equ    %00010000
mDDRT_DDRT5:        equ    %00100000
mDDRT_DDRT6:        equ    %01000000
mDDRT_DDRT7:        equ    %10000000


;*** RDRT - Port T Reduced Drive Register; 0x00000243 ***
RDRT:               equ    $00000243                                ;*** RDRT - Port T Reduced Drive Register; 0x00000243 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RDRT_RDRT4:         equ    4                                         ; Reduced Drive Port T Bit 4
RDRT_RDRT5:         equ    5                                         ; Reduced Drive Port T Bit 5
RDRT_RDRT6:         equ    6                                         ; Reduced Drive Port T Bit 6
RDRT_RDRT7:         equ    7                                         ; Reduced Drive Port T Bit 7
; bit position masks
mRDRT_RDRT4:        equ    %00010000
mRDRT_RDRT5:        equ    %00100000
mRDRT_RDRT6:        equ    %01000000
mRDRT_RDRT7:        equ    %10000000


;*** PERT - Port T Pull Device Enable Register; 0x00000244 ***
PERT:               equ    $00000244                                ;*** PERT - Port T Pull Device Enable Register; 0x00000244 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PERT_PERT4:         equ    4                                         ; Pull Device Enable Port T Bit 4
PERT_PERT5:         equ    5                                         ; Pull Device Enable Port T Bit 5
PERT_PERT6:         equ    6                                         ; Pull Device Enable Port T Bit 6
PERT_PERT7:         equ    7                                         ; Pull Device Enable Port T Bit 7
; bit position masks
mPERT_PERT4:        equ    %00010000
mPERT_PERT5:        equ    %00100000
mPERT_PERT6:        equ    %01000000
mPERT_PERT7:        equ    %10000000


;*** PPST - Port T Polarity Select Register; 0x00000245 ***
PPST:               equ    $00000245                                ;*** PPST - Port T Polarity Select Register; 0x00000245 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PPST_PPST4:         equ    4                                         ; Pull Select Port T Bit 4
PPST_PPST5:         equ    5                                         ; Pull Select Port T Bit 5
PPST_PPST6:         equ    6                                         ; Pull Select Port T Bit 6
PPST_PPST7:         equ    7                                         ; Pull Select Port T Bit 7
; bit position masks
mPPST_PPST4:        equ    %00010000
mPPST_PPST5:        equ    %00100000
mPPST_PPST6:        equ    %01000000
mPPST_PPST7:        equ    %10000000


;*** PTS - Port S I/O Register; 0x00000248 ***
PTS:                equ    $00000248                                ;*** PTS - Port S I/O Register; 0x00000248 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTS_PTS0:           equ    0                                         ; Port S Bit 0
PTS_PTS1:           equ    1                                         ; Port S Bit 1
PTS_PTS2:           equ    2                                         ; Port S Bit 2
PTS_PTS3:           equ    3                                         ; Port S Bit 3
PTS_PTS4:           equ    4                                         ; Port S Bit 4
PTS_PTS5:           equ    5                                         ; Port S Bit 5
PTS_PTS6:           equ    6                                         ; Port S Bit 6
PTS_PTS7:           equ    7                                         ; Port S Bit 7
; bit position masks
mPTS_PTS0:          equ    %00000001
mPTS_PTS1:          equ    %00000010
mPTS_PTS2:          equ    %00000100
mPTS_PTS3:          equ    %00001000
mPTS_PTS4:          equ    %00010000
mPTS_PTS5:          equ    %00100000
mPTS_PTS6:          equ    %01000000
mPTS_PTS7:          equ    %10000000


;*** PTIS - Port S Input Register; 0x00000249 ***
PTIS:               equ    $00000249                                ;*** PTIS - Port S Input Register; 0x00000249 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTIS_PTIS0:         equ    0                                         ; Port S Bit 0
PTIS_PTIS1:         equ    1                                         ; Port S Bit 1
PTIS_PTIS2:         equ    2                                         ; Port S Bit 2
PTIS_PTIS3:         equ    3                                         ; Port S Bit 3
PTIS_PTIS4:         equ    4                                         ; Port S Bit 4
PTIS_PTIS5:         equ    5                                         ; Port S Bit 5
PTIS_PTIS6:         equ    6                                         ; Port S Bit 6
PTIS_PTIS7:         equ    7                                         ; Port S Bit 7
; bit position masks
mPTIS_PTIS0:        equ    %00000001
mPTIS_PTIS1:        equ    %00000010
mPTIS_PTIS2:        equ    %00000100
mPTIS_PTIS3:        equ    %00001000
mPTIS_PTIS4:        equ    %00010000
mPTIS_PTIS5:        equ    %00100000
mPTIS_PTIS6:        equ    %01000000
mPTIS_PTIS7:        equ    %10000000


;*** DDRS - Port S Data Direction Register; 0x0000024A ***
DDRS:               equ    $0000024A                                ;*** DDRS - Port S Data Direction Register; 0x0000024A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRS_DDRS0:         equ    0                                         ; Data Direction Port S Bit 0
DDRS_DDRS1:         equ    1                                         ; Data Direction Port S Bit 1
DDRS_DDRS2:         equ    2                                         ; Data Direction Port S Bit 2
DDRS_DDRS3:         equ    3                                         ; Data Direction Port S Bit 3
DDRS_DDRS4:         equ    4                                         ; Data Direction Port S Bit 4
DDRS_DDRS5:         equ    5                                         ; Data Direction Port S Bit 5
DDRS_DDRS6:         equ    6                                         ; Data Direction Port S Bit 6
DDRS_DDRS7:         equ    7                                         ; Data Direction Port S Bit 7
; bit position masks
mDDRS_DDRS0:        equ    %00000001
mDDRS_DDRS1:        equ    %00000010
mDDRS_DDRS2:        equ    %00000100
mDDRS_DDRS3:        equ    %00001000
mDDRS_DDRS4:        equ    %00010000
mDDRS_DDRS5:        equ    %00100000
mDDRS_DDRS6:        equ    %01000000
mDDRS_DDRS7:        equ    %10000000


;*** RDRS - Port S Reduced Drive Register; 0x0000024B ***
RDRS:               equ    $0000024B                                ;*** RDRS - Port S Reduced Drive Register; 0x0000024B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RDRS_RDRS0:         equ    0                                         ; Reduced Drive Port S Bit 0
RDRS_RDRS1:         equ    1                                         ; Reduced Drive Port S Bit 1
RDRS_RDRS2:         equ    2                                         ; Reduced Drive Port S Bit 2
RDRS_RDRS3:         equ    3                                         ; Reduced Drive Port S Bit 3
RDRS_RDRS4:         equ    4                                         ; Reduced Drive Port S Bit 4
RDRS_RDRS5:         equ    5                                         ; Reduced Drive Port S Bit 5
RDRS_RDRS6:         equ    6                                         ; Reduced Drive Port S Bit 6
RDRS_RDRS7:         equ    7                                         ; Reduced Drive Port S Bit 7
; bit position masks
mRDRS_RDRS0:        equ    %00000001
mRDRS_RDRS1:        equ    %00000010
mRDRS_RDRS2:        equ    %00000100
mRDRS_RDRS3:        equ    %00001000
mRDRS_RDRS4:        equ    %00010000
mRDRS_RDRS5:        equ    %00100000
mRDRS_RDRS6:        equ    %01000000
mRDRS_RDRS7:        equ    %10000000


;*** PERS - Port S Pull Device Enable Register; 0x0000024C ***
PERS:               equ    $0000024C                                ;*** PERS - Port S Pull Device Enable Register; 0x0000024C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PERS_PERS0:         equ    0                                         ; Pull Device Enable Port S Bit 0
PERS_PERS1:         equ    1                                         ; Pull Device Enable Port S Bit 1
PERS_PERS2:         equ    2                                         ; Pull Device Enable Port S Bit 2
PERS_PERS3:         equ    3                                         ; Pull Device Enable Port S Bit 3
PERS_PERS4:         equ    4                                         ; Pull Device Enable Port S Bit 4
PERS_PERS5:         equ    5                                         ; Pull Device Enable Port S Bit 5
PERS_PERS6:         equ    6                                         ; Pull Device Enable Port S Bit 6
PERS_PERS7:         equ    7                                         ; Pull Device Enable Port S Bit 7
; bit position masks
mPERS_PERS0:        equ    %00000001
mPERS_PERS1:        equ    %00000010
mPERS_PERS2:        equ    %00000100
mPERS_PERS3:        equ    %00001000
mPERS_PERS4:        equ    %00010000
mPERS_PERS5:        equ    %00100000
mPERS_PERS6:        equ    %01000000
mPERS_PERS7:        equ    %10000000


;*** PPSS - Port S Polarity Select Register; 0x0000024D ***
PPSS:               equ    $0000024D                                ;*** PPSS - Port S Polarity Select Register; 0x0000024D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PPSS_PPSS0:         equ    0                                         ; Pull Select Port S Bit 0
PPSS_PPSS1:         equ    1                                         ; Pull Select Port S Bit 1
PPSS_PPSS2:         equ    2                                         ; Pull Select Port S Bit 2
PPSS_PPSS3:         equ    3                                         ; Pull Select Port S Bit 3
PPSS_PPSS4:         equ    4                                         ; Pull Select Port S Bit 4
PPSS_PPSS5:         equ    5                                         ; Pull Select Port S Bit 5
PPSS_PPSS6:         equ    6                                         ; Pull Select Port S Bit 6
PPSS_PPSS7:         equ    7                                         ; Pull Select Port S Bit 7
; bit position masks
mPPSS_PPSS0:        equ    %00000001
mPPSS_PPSS1:        equ    %00000010
mPPSS_PPSS2:        equ    %00000100
mPPSS_PPSS3:        equ    %00001000
mPPSS_PPSS4:        equ    %00010000
mPPSS_PPSS5:        equ    %00100000
mPPSS_PPSS6:        equ    %01000000
mPPSS_PPSS7:        equ    %10000000


;*** WOMS - Port S Wired-Or Mode Register; 0x0000024E ***
WOMS:               equ    $0000024E                                ;*** WOMS - Port S Wired-Or Mode Register; 0x0000024E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
WOMS_WOMS0:         equ    0                                         ; Wired-Or Mode Port S Bit 0
WOMS_WOMS1:         equ    1                                         ; Wired-Or Mode Port S Bit 1
WOMS_WOMS2:         equ    2                                         ; Wired-Or Mode Port S Bit 2
WOMS_WOMS3:         equ    3                                         ; Wired-Or Mode Port S Bit 3
WOMS_WOMS4:         equ    4                                         ; Wired-Or Mode Port S Bit 4
WOMS_WOMS5:         equ    5                                         ; Wired-Or Mode Port S Bit 5
WOMS_WOMS6:         equ    6                                         ; Wired-Or Mode Port S Bit 6
WOMS_WOMS7:         equ    7                                         ; Wired-Or Mode Port S Bit 7
; bit position masks
mWOMS_WOMS0:        equ    %00000001
mWOMS_WOMS1:        equ    %00000010
mWOMS_WOMS2:        equ    %00000100
mWOMS_WOMS3:        equ    %00001000
mWOMS_WOMS4:        equ    %00010000
mWOMS_WOMS5:        equ    %00100000
mWOMS_WOMS6:        equ    %01000000
mWOMS_WOMS7:        equ    %10000000


;*** PTG - Port G I/O Register; 0x00000250 ***
PTG:                equ    $00000250                                ;*** PTG - Port G I/O Register; 0x00000250 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTG_PTG0:           equ    0                                         ; Port T Bit 0
PTG_PTG1:           equ    1                                         ; Port T Bit 1
PTG_PTG2:           equ    2                                         ; Port T Bit 2
PTG_PTG3:           equ    3                                         ; Port T Bit 3
PTG_PTG4:           equ    4                                         ; Port T Bit 4
PTG_PTG5:           equ    5                                         ; Port T Bit 5
PTG_PTG6:           equ    6                                         ; Port T Bit 6
PTG_PTG7:           equ    7                                         ; Port T Bit 7
; bit position masks
mPTG_PTG0:          equ    %00000001
mPTG_PTG1:          equ    %00000010
mPTG_PTG2:          equ    %00000100
mPTG_PTG3:          equ    %00001000
mPTG_PTG4:          equ    %00010000
mPTG_PTG5:          equ    %00100000
mPTG_PTG6:          equ    %01000000
mPTG_PTG7:          equ    %10000000


;*** PTIG - Port G Input Register; 0x00000251 ***
PTIG:               equ    $00000251                                ;*** PTIG - Port G Input Register; 0x00000251 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTIG_PTIG0:         equ    0                                         ; Port G Bit 0
PTIG_PTIG1:         equ    1                                         ; Port G Bit 1
PTIG_PTIG2:         equ    2                                         ; Port G Bit 2
PTIG_PTIG3:         equ    3                                         ; Port G Bit 3
PTIG_PTIG4:         equ    4                                         ; Port G Bit 4
PTIG_PTIG5:         equ    5                                         ; Port G Bit 5
PTIG_PTIG6:         equ    6                                         ; Port G Bit 6
PTIG_PTIG7:         equ    7                                         ; Port G Bit 7
; bit position masks
mPTIG_PTIG0:        equ    %00000001
mPTIG_PTIG1:        equ    %00000010
mPTIG_PTIG2:        equ    %00000100
mPTIG_PTIG3:        equ    %00001000
mPTIG_PTIG4:        equ    %00010000
mPTIG_PTIG5:        equ    %00100000
mPTIG_PTIG6:        equ    %01000000
mPTIG_PTIG7:        equ    %10000000


;*** DDRG - Port G Data Direction Register; 0x00000252 ***
DDRG:               equ    $00000252                                ;*** DDRG - Port G Data Direction Register; 0x00000252 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRG_DDRG0:         equ    0                                         ; Data Direction Port G Bit 0
DDRG_DDRG1:         equ    1                                         ; Data Direction Port G Bit 1
DDRG_DDRG2:         equ    2                                         ; Data Direction Port G Bit 2
DDRG_DDRG3:         equ    3                                         ; Data Direction Port G Bit 3
DDRG_DDRG4:         equ    4                                         ; Data Direction Port G Bit 4
DDRG_DDRG5:         equ    5                                         ; Data Direction Port G Bit 5
DDRG_DDRG6:         equ    6                                         ; Data Direction Port G Bit 6
DDRG_DDRG7:         equ    7                                         ; Data Direction Port G Bit 7
; bit position masks
mDDRG_DDRG0:        equ    %00000001
mDDRG_DDRG1:        equ    %00000010
mDDRG_DDRG2:        equ    %00000100
mDDRG_DDRG3:        equ    %00001000
mDDRG_DDRG4:        equ    %00010000
mDDRG_DDRG5:        equ    %00100000
mDDRG_DDRG6:        equ    %01000000
mDDRG_DDRG7:        equ    %10000000


;*** RDRG - Port G Reduced Drive Register; 0x00000253 ***
RDRG:               equ    $00000253                                ;*** RDRG - Port G Reduced Drive Register; 0x00000253 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RDRG_RDRG0:         equ    0                                         ; Reduced Drive Port G Bit 0
RDRG_RDRG1:         equ    1                                         ; Reduced Drive Port G Bit 1
RDRG_RDRG2:         equ    2                                         ; Reduced Drive Port G Bit 2
RDRG_RDRG3:         equ    3                                         ; Reduced Drive Port G Bit 3
RDRG_RDRG4:         equ    4                                         ; Reduced Drive Port G Bit 4
RDRG_RDRG5:         equ    5                                         ; Reduced Drive Port G Bit 5
RDRG_RDRG6:         equ    6                                         ; Reduced Drive Port G Bit 6
RDRG_RDRG7:         equ    7                                         ; Reduced Drive Port G Bit 7
; bit position masks
mRDRG_RDRG0:        equ    %00000001
mRDRG_RDRG1:        equ    %00000010
mRDRG_RDRG2:        equ    %00000100
mRDRG_RDRG3:        equ    %00001000
mRDRG_RDRG4:        equ    %00010000
mRDRG_RDRG5:        equ    %00100000
mRDRG_RDRG6:        equ    %01000000
mRDRG_RDRG7:        equ    %10000000


;*** PERG - Port G Pull Device Enable Register; 0x00000254 ***
PERG:               equ    $00000254                                ;*** PERG - Port G Pull Device Enable Register; 0x00000254 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PERG_PERG0:         equ    0                                         ; Pull Device Enable Port G Bit 0
PERG_PERG1:         equ    1                                         ; Pull Device Enable Port G Bit 1
PERG_PERG2:         equ    2                                         ; Pull Device Enable Port G Bit 2
PERG_PERG3:         equ    3                                         ; Pull Device Enable Port G Bit 3
PERG_PERG4:         equ    4                                         ; Pull Device Enable Port G Bit 4
PERG_PERG5:         equ    5                                         ; Pull Device Enable Port G Bit 5
PERG_PERG6:         equ    6                                         ; Pull Device Enable Port G Bit 6
PERG_PERG7:         equ    7                                         ; Pull Device Enable Port G Bit 7
; bit position masks
mPERG_PERG0:        equ    %00000001
mPERG_PERG1:        equ    %00000010
mPERG_PERG2:        equ    %00000100
mPERG_PERG3:        equ    %00001000
mPERG_PERG4:        equ    %00010000
mPERG_PERG5:        equ    %00100000
mPERG_PERG6:        equ    %01000000
mPERG_PERG7:        equ    %10000000


;*** PPSG - Port G Polarity Select Register; 0x00000255 ***
PPSG:               equ    $00000255                                ;*** PPSG - Port G Polarity Select Register; 0x00000255 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PPSG_PPSG0:         equ    0                                         ; Pull Select Port G Bit 0
PPSG_PPSG1:         equ    1                                         ; Pull Select Port G Bit 1
PPSG_PPSG2:         equ    2                                         ; Pull Select Port G Bit 2
PPSG_PPSG3:         equ    3                                         ; Pull Select Port G Bit 3
PPSG_PPSG4:         equ    4                                         ; Pull Select Port G Bit 4
PPSG_PPSG5:         equ    5                                         ; Pull Select Port G Bit 5
PPSG_PPSG6:         equ    6                                         ; Pull Select Port G Bit 6
PPSG_PPSG7:         equ    7                                         ; Pull Select Port G Bit 7
; bit position masks
mPPSG_PPSG0:        equ    %00000001
mPPSG_PPSG1:        equ    %00000010
mPPSG_PPSG2:        equ    %00000100
mPPSG_PPSG3:        equ    %00001000
mPPSG_PPSG4:        equ    %00010000
mPPSG_PPSG5:        equ    %00100000
mPPSG_PPSG6:        equ    %01000000
mPPSG_PPSG7:        equ    %10000000


;*** PIEG - Port G Interrupt Enable Register; 0x00000256 ***
PIEG:               equ    $00000256                                ;*** PIEG - Port G Interrupt Enable Register; 0x00000256 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PIEG_PIEG0:         equ    0                                         ; Interrupt Enable Port G Bit 0
PIEG_PIEG1:         equ    1                                         ; Interrupt Enable Port G Bit 1
PIEG_PIEG2:         equ    2                                         ; Interrupt Enable Port G Bit 2
PIEG_PIEG3:         equ    3                                         ; Interrupt Enable Port G Bit 3
PIEG_PIEG4:         equ    4                                         ; Interrupt Enable Port G Bit 4
PIEG_PIEG5:         equ    5                                         ; Interrupt Enable Port G Bit 5
PIEG_PIEG6:         equ    6                                         ; Interrupt Enable Port G Bit 6
PIEG_PIEG7:         equ    7                                         ; Interrupt Enable Port G Bit 7
; bit position masks
mPIEG_PIEG0:        equ    %00000001
mPIEG_PIEG1:        equ    %00000010
mPIEG_PIEG2:        equ    %00000100
mPIEG_PIEG3:        equ    %00001000
mPIEG_PIEG4:        equ    %00010000
mPIEG_PIEG5:        equ    %00100000
mPIEG_PIEG6:        equ    %01000000
mPIEG_PIEG7:        equ    %10000000


;*** PIFG - Port G Interrupt Flag Register; 0x00000257 ***
PIFG:               equ    $00000257                                ;*** PIFG - Port G Interrupt Flag Register; 0x00000257 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PIFG_PIFG0:         equ    0                                         ; Interrupt Flags Port G Bit 0
PIFG_PIFG1:         equ    1                                         ; Interrupt Flags Port G Bit 1
PIFG_PIFG2:         equ    2                                         ; Interrupt Flags Port G Bit 2
PIFG_PIFG3:         equ    3                                         ; Interrupt Flags Port G Bit 3
PIFG_PIFG4:         equ    4                                         ; Interrupt Flags Port G Bit 4
PIFG_PIFG5:         equ    5                                         ; Interrupt Flags Port G Bit 5
PIFG_PIFG6:         equ    6                                         ; Interrupt Flags Port G Bit 6
PIFG_PIFG7:         equ    7                                         ; Interrupt Flags Port G Bit 7
; bit position masks
mPIFG_PIFG0:        equ    %00000001
mPIFG_PIFG1:        equ    %00000010
mPIFG_PIFG2:        equ    %00000100
mPIFG_PIFG3:        equ    %00001000
mPIFG_PIFG4:        equ    %00010000
mPIFG_PIFG5:        equ    %00100000
mPIFG_PIFG6:        equ    %01000000
mPIFG_PIFG7:        equ    %10000000


;*** PTH - Port H I/O Register; 0x00000258 ***
PTH:                equ    $00000258                                ;*** PTH - Port H I/O Register; 0x00000258 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTH_PTH0:           equ    0                                         ; Port H Bit 0
PTH_PTH1:           equ    1                                         ; Port H Bit 1
PTH_PTH2:           equ    2                                         ; Port H Bit 2
PTH_PTH3:           equ    3                                         ; Port H Bit 3
PTH_PTH4:           equ    4                                         ; Port H Bit 4
PTH_PTH5:           equ    5                                         ; Port H Bit 5
PTH_PTH6:           equ    6                                         ; Port H Bit 6
; bit position masks
mPTH_PTH0:          equ    %00000001
mPTH_PTH1:          equ    %00000010
mPTH_PTH2:          equ    %00000100
mPTH_PTH3:          equ    %00001000
mPTH_PTH4:          equ    %00010000
mPTH_PTH5:          equ    %00100000
mPTH_PTH6:          equ    %01000000


;*** PTIH - Port H Input Register; 0x00000259 ***
PTIH:               equ    $00000259                                ;*** PTIH - Port H Input Register; 0x00000259 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTIH_PTIH0:         equ    0                                         ; Port H Bit 0
PTIH_PTIH1:         equ    1                                         ; Port H Bit 1
PTIH_PTIH2:         equ    2                                         ; Port H Bit 2
PTIH_PTIH3:         equ    3                                         ; Port H Bit 3
PTIH_PTIH4:         equ    4                                         ; Port H Bit 4
PTIH_PTIH5:         equ    5                                         ; Port H Bit 5
PTIH_PTIH6:         equ    6                                         ; Port H Bit 6
; bit position masks
mPTIH_PTIH0:        equ    %00000001
mPTIH_PTIH1:        equ    %00000010
mPTIH_PTIH2:        equ    %00000100
mPTIH_PTIH3:        equ    %00001000
mPTIH_PTIH4:        equ    %00010000
mPTIH_PTIH5:        equ    %00100000
mPTIH_PTIH6:        equ    %01000000


;*** DDRH - Port H Data Direction Register; 0x0000025A ***
DDRH:               equ    $0000025A                                ;*** DDRH - Port H Data Direction Register; 0x0000025A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRH_DDRH0:         equ    0                                         ; Data Direction Port H Bit 0
DDRH_DDRH1:         equ    1                                         ; Data Direction Port H Bit 1
DDRH_DDRH2:         equ    2                                         ; Data Direction Port H Bit 2
DDRH_DDRH3:         equ    3                                         ; Data Direction Port H Bit 3
DDRH_DDRH4:         equ    4                                         ; Data Direction Port H Bit 4
DDRH_DDRH5:         equ    5                                         ; Data Direction Port H Bit 5
DDRH_DDRH6:         equ    6                                         ; Data Direction Port H Bit 6
; bit position masks
mDDRH_DDRH0:        equ    %00000001
mDDRH_DDRH1:        equ    %00000010
mDDRH_DDRH2:        equ    %00000100
mDDRH_DDRH3:        equ    %00001000
mDDRH_DDRH4:        equ    %00010000
mDDRH_DDRH5:        equ    %00100000
mDDRH_DDRH6:        equ    %01000000


;*** RDRH - Port H Reduced Drive Register; 0x0000025B ***
RDRH:               equ    $0000025B                                ;*** RDRH - Port H Reduced Drive Register; 0x0000025B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RDRH_RDRH0:         equ    0                                         ; Reduced Drive Port H Bit 0
RDRH_RDRH1:         equ    1                                         ; Reduced Drive Port H Bit 1
RDRH_RDRH2:         equ    2                                         ; Reduced Drive Port H Bit 2
RDRH_RDRH3:         equ    3                                         ; Reduced Drive Port H Bit 3
RDRH_RDRH4:         equ    4                                         ; Reduced Drive Port H Bit 4
RDRH_RDRH5:         equ    5                                         ; Reduced Drive Port H Bit 5
RDRH_RDRH6:         equ    6                                         ; Reduced Drive Port H Bit 6
; bit position masks
mRDRH_RDRH0:        equ    %00000001
mRDRH_RDRH1:        equ    %00000010
mRDRH_RDRH2:        equ    %00000100
mRDRH_RDRH3:        equ    %00001000
mRDRH_RDRH4:        equ    %00010000
mRDRH_RDRH5:        equ    %00100000
mRDRH_RDRH6:        equ    %01000000


;*** PERH - Port H Pull Device Enable Register; 0x0000025C ***
PERH:               equ    $0000025C                                ;*** PERH - Port H Pull Device Enable Register; 0x0000025C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PERH_PERH0:         equ    0                                         ; Pull Device Enable Port H Bit 0
PERH_PERH1:         equ    1                                         ; Pull Device Enable Port H Bit 1
PERH_PERH2:         equ    2                                         ; Pull Device Enable Port H Bit 2
PERH_PERH3:         equ    3                                         ; Pull Device Enable Port H Bit 3
PERH_PERH4:         equ    4                                         ; Pull Device Enable Port H Bit 4
PERH_PERH5:         equ    5                                         ; Pull Device Enable Port H Bit 5
PERH_PERH6:         equ    6                                         ; Pull Device Enable Port H Bit 6
; bit position masks
mPERH_PERH0:        equ    %00000001
mPERH_PERH1:        equ    %00000010
mPERH_PERH2:        equ    %00000100
mPERH_PERH3:        equ    %00001000
mPERH_PERH4:        equ    %00010000
mPERH_PERH5:        equ    %00100000
mPERH_PERH6:        equ    %01000000


;*** PPSH - Port H Polarity Select Register; 0x0000025D ***
PPSH:               equ    $0000025D                                ;*** PPSH - Port H Polarity Select Register; 0x0000025D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PPSH_PPSH0:         equ    0                                         ; Pull Select Port H Bit 0
PPSH_PPSH1:         equ    1                                         ; Pull Select Port H Bit 1
PPSH_PPSH2:         equ    2                                         ; Pull Select Port H Bit 2
PPSH_PPSH3:         equ    3                                         ; Pull Select Port H Bit 3
PPSH_PPSH4:         equ    4                                         ; Pull Select Port H Bit 4
PPSH_PPSH5:         equ    5                                         ; Pull Select Port H Bit 5
PPSH_PPSH6:         equ    6                                         ; Pull Select Port H Bit 6
; bit position masks
mPPSH_PPSH0:        equ    %00000001
mPPSH_PPSH1:        equ    %00000010
mPPSH_PPSH2:        equ    %00000100
mPPSH_PPSH3:        equ    %00001000
mPPSH_PPSH4:        equ    %00010000
mPPSH_PPSH5:        equ    %00100000
mPPSH_PPSH6:        equ    %01000000


;*** PIEH - Port H Interrupt Enable Register; 0x0000025E ***
PIEH:               equ    $0000025E                                ;*** PIEH - Port H Interrupt Enable Register; 0x0000025E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PIEH_PIEH0:         equ    0                                         ; Interrupt Enable Port H Bit 0
PIEH_PIEH1:         equ    1                                         ; Interrupt Enable Port H Bit 1
PIEH_PIEH2:         equ    2                                         ; Interrupt Enable Port H Bit 2
PIEH_PIEH3:         equ    3                                         ; Interrupt Enable Port H Bit 3
PIEH_PIEH4:         equ    4                                         ; Interrupt Enable Port H Bit 4
PIEH_PIEH5:         equ    5                                         ; Interrupt Enable Port H Bit 5
PIEH_PIEH6:         equ    6                                         ; Interrupt Enable Port H Bit 6
; bit position masks
mPIEH_PIEH0:        equ    %00000001
mPIEH_PIEH1:        equ    %00000010
mPIEH_PIEH2:        equ    %00000100
mPIEH_PIEH3:        equ    %00001000
mPIEH_PIEH4:        equ    %00010000
mPIEH_PIEH5:        equ    %00100000
mPIEH_PIEH6:        equ    %01000000


;*** PIFH - Port H Interrupt Flag Register; 0x0000025F ***
PIFH:               equ    $0000025F                                ;*** PIFH - Port H Interrupt Flag Register; 0x0000025F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PIFH_PIFH0:         equ    0                                         ; Interrupt Flags Port H Bit 0
PIFH_PIFH1:         equ    1                                         ; Interrupt Flags Port H Bit 1
PIFH_PIFH2:         equ    2                                         ; Interrupt Flags Port H Bit 2
PIFH_PIFH3:         equ    3                                         ; Interrupt Flags Port H Bit 3
PIFH_PIFH4:         equ    4                                         ; Interrupt Flags Port H Bit 4
PIFH_PIFH5:         equ    5                                         ; Interrupt Flags Port H Bit 5
PIFH_PIFH6:         equ    6                                         ; Interrupt Flags Port H Bit 6
; bit position masks
mPIFH_PIFH0:        equ    %00000001
mPIFH_PIFH1:        equ    %00000010
mPIFH_PIFH2:        equ    %00000100
mPIFH_PIFH3:        equ    %00001000
mPIFH_PIFH4:        equ    %00010000
mPIFH_PIFH5:        equ    %00100000
mPIFH_PIFH6:        equ    %01000000


;*** PTJ - Port J I/O Register; 0x00000260 ***
PTJ:                equ    $00000260                                ;*** PTJ - Port J I/O Register; 0x00000260 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTJ_PTJ0:           equ    0                                         ; Port J Bit 0
PTJ_PTJ1:           equ    1                                         ; Port J Bit 1
PTJ_PTJ2:           equ    2                                         ; Port J Bit 2
PTJ_PTJ3:           equ    3                                         ; Port J Bit 3
PTJ_PTJ6:           equ    6                                         ; Port J Bit 6
PTJ_PTJ7:           equ    7                                         ; Port J Bit 7
; bit position masks
mPTJ_PTJ0:          equ    %00000001
mPTJ_PTJ1:          equ    %00000010
mPTJ_PTJ2:          equ    %00000100
mPTJ_PTJ3:          equ    %00001000
mPTJ_PTJ6:          equ    %01000000
mPTJ_PTJ7:          equ    %10000000


;*** PTIJ - Port J Input Register; 0x00000261 ***
PTIJ:               equ    $00000261                                ;*** PTIJ - Port J Input Register; 0x00000261 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTIJ_PTIJ0:         equ    0                                         ; Port J Bit 0
PTIJ_PTIJ1:         equ    1                                         ; Port J Bit 1
PTIJ_PTIJ2:         equ    2                                         ; Port J Bit 2
PTIJ_PTIJ3:         equ    3                                         ; Port J Bit 3
PTIJ_PTIJ6:         equ    6                                         ; Port J Bit 6
PTIJ_PTIJ7:         equ    7                                         ; Port J Bit 7
; bit position masks
mPTIJ_PTIJ0:        equ    %00000001
mPTIJ_PTIJ1:        equ    %00000010
mPTIJ_PTIJ2:        equ    %00000100
mPTIJ_PTIJ3:        equ    %00001000
mPTIJ_PTIJ6:        equ    %01000000
mPTIJ_PTIJ7:        equ    %10000000


;*** DDRJ - Port J Data Direction Register; 0x00000262 ***
DDRJ:               equ    $00000262                                ;*** DDRJ - Port J Data Direction Register; 0x00000262 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRJ_DDRJ0:         equ    0                                         ; Data Direction Port J Bit 0
DDRJ_DDRJ1:         equ    1                                         ; Data Direction Port J Bit 1
DDRJ_DDRJ2:         equ    2                                         ; Data Direction Port J Bit 2
DDRJ_DDRJ3:         equ    3                                         ; Data Direction Port J Bit 3
DDRJ_DDRJ6:         equ    6                                         ; Data Direction Port J Bit 6
DDRJ_DDRJ7:         equ    7                                         ; Data Direction Port J Bit 7
; bit position masks
mDDRJ_DDRJ0:        equ    %00000001
mDDRJ_DDRJ1:        equ    %00000010
mDDRJ_DDRJ2:        equ    %00000100
mDDRJ_DDRJ3:        equ    %00001000
mDDRJ_DDRJ6:        equ    %01000000
mDDRJ_DDRJ7:        equ    %10000000


;*** RDRJ - Port J Reduced Drive Register; 0x00000263 ***
RDRJ:               equ    $00000263                                ;*** RDRJ - Port J Reduced Drive Register; 0x00000263 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RDRJ_RDRJ0:         equ    0                                         ; Reduced Drive Port J Bit 0
RDRJ_RDRJ1:         equ    1                                         ; Reduced Drive Port J Bit 1
RDRJ_RDRJ2:         equ    2                                         ; Reduced Drive Port J Bit 2
RDRJ_RDRJ3:         equ    3                                         ; Reduced Drive Port J Bit 3
RDRJ_RDRJ6:         equ    6                                         ; Reduced Drive Port J Bit 6
RDRJ_RDRJ7:         equ    7                                         ; Reduced Drive Port J Bit 7
; bit position masks
mRDRJ_RDRJ0:        equ    %00000001
mRDRJ_RDRJ1:        equ    %00000010
mRDRJ_RDRJ2:        equ    %00000100
mRDRJ_RDRJ3:        equ    %00001000
mRDRJ_RDRJ6:        equ    %01000000
mRDRJ_RDRJ7:        equ    %10000000


;*** PERJ - Port J Pull Device Enable Register; 0x00000264 ***
PERJ:               equ    $00000264                                ;*** PERJ - Port J Pull Device Enable Register; 0x00000264 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PERJ_PERJ0:         equ    0                                         ; Pull Device Enable Port J Bit 0
PERJ_PERJ1:         equ    1                                         ; Pull Device Enable Port J Bit 1
PERJ_PERJ2:         equ    2                                         ; Pull Device Enable Port J Bit 2
PERJ_PERJ3:         equ    3                                         ; Pull Device Enable Port J Bit 3
PERJ_PERJ6:         equ    6                                         ; Pull Device Enable Port J Bit 6
PERJ_PERJ7:         equ    7                                         ; Pull Device Enable Port J Bit 7
; bit position masks
mPERJ_PERJ0:        equ    %00000001
mPERJ_PERJ1:        equ    %00000010
mPERJ_PERJ2:        equ    %00000100
mPERJ_PERJ3:        equ    %00001000
mPERJ_PERJ6:        equ    %01000000
mPERJ_PERJ7:        equ    %10000000


;*** PPSJ - Port J Polarity Select Register; 0x00000265 ***
PPSJ:               equ    $00000265                                ;*** PPSJ - Port J Polarity Select Register; 0x00000265 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PPSJ_PPSJ0:         equ    0                                         ; Pull Select Port J Bit 0
PPSJ_PPSJ1:         equ    1                                         ; Pull Select Port J Bit 1
PPSJ_PPSJ2:         equ    2                                         ; Pull Select Port J Bit 2
PPSJ_PPSJ3:         equ    3                                         ; Pull Select Port J Bit 3
PPSJ_PPSJ6:         equ    6                                         ; Pull Select Port J Bit 6
PPSJ_PPSJ7:         equ    7                                         ; Pull Select Port J Bit 7
; bit position masks
mPPSJ_PPSJ0:        equ    %00000001
mPPSJ_PPSJ1:        equ    %00000010
mPPSJ_PPSJ2:        equ    %00000100
mPPSJ_PPSJ3:        equ    %00001000
mPPSJ_PPSJ6:        equ    %01000000
mPPSJ_PPSJ7:        equ    %10000000


;*** PIEJ - Port J Interrupt Enable Register; 0x00000266 ***
PIEJ:               equ    $00000266                                ;*** PIEJ - Port J Interrupt Enable Register; 0x00000266 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PIEJ_PIEJ0:         equ    0                                         ; Interrupt Enable Port J Bit 0
PIEJ_PIEJ1:         equ    1                                         ; Interrupt Enable Port J Bit 1
PIEJ_PIEJ2:         equ    2                                         ; Interrupt Enable Port J Bit 2
PIEJ_PIEJ3:         equ    3                                         ; Interrupt Enable Port J Bit 3
PIEJ_PIEJ6:         equ    6                                         ; Interrupt Enable Port J Bit 6
PIEJ_PIEJ7:         equ    7                                         ; Interrupt Enable Port J Bit 7
; bit position masks
mPIEJ_PIEJ0:        equ    %00000001
mPIEJ_PIEJ1:        equ    %00000010
mPIEJ_PIEJ2:        equ    %00000100
mPIEJ_PIEJ3:        equ    %00001000
mPIEJ_PIEJ6:        equ    %01000000
mPIEJ_PIEJ7:        equ    %10000000


;*** PIFJ - Port J Interrupt Flag Register; 0x00000267 ***
PIFJ:               equ    $00000267                                ;*** PIFJ - Port J Interrupt Flag Register; 0x00000267 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PIFJ_PIFJ0:         equ    0                                         ; Interrupt Flags Port J Bit 0
PIFJ_PIFJ1:         equ    1                                         ; Interrupt Flags Port J Bit 1
PIFJ_PIFJ2:         equ    2                                         ; Interrupt Flags Port J Bit 2
PIFJ_PIFJ3:         equ    3                                         ; Interrupt Flags Port J Bit 3
PIFJ_PIFJ6:         equ    6                                         ; Interrupt Flags Port J Bit 6
PIFJ_PIFJ7:         equ    7                                         ; Interrupt Flags Port J Bit 7
; bit position masks
mPIFJ_PIFJ0:        equ    %00000001
mPIFJ_PIFJ1:        equ    %00000010
mPIFJ_PIFJ2:        equ    %00000100
mPIFJ_PIFJ3:        equ    %00001000
mPIFJ_PIFJ6:        equ    %01000000
mPIFJ_PIFJ7:        equ    %10000000


;*** PTL - Port L I/O Register; 0x00000268 ***
PTL:                equ    $00000268                                ;*** PTL - Port L I/O Register; 0x00000268 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTL_PTL0:           equ    0                                         ; Port L Bit 0
PTL_PTL1:           equ    1                                         ; Port L Bit 1
PTL_PTL2:           equ    2                                         ; Port L Bit 2
PTL_PTL3:           equ    3                                         ; Port L Bit 3
PTL_PTL4:           equ    4                                         ; Port L Bit 4
PTL_PTL5:           equ    5                                         ; Port L Bit 5
PTL_PTL6:           equ    6                                         ; Port L Bit 6
; bit position masks
mPTL_PTL0:          equ    %00000001
mPTL_PTL1:          equ    %00000010
mPTL_PTL2:          equ    %00000100
mPTL_PTL3:          equ    %00001000
mPTL_PTL4:          equ    %00010000
mPTL_PTL5:          equ    %00100000
mPTL_PTL6:          equ    %01000000


;*** PTIL - Port L Input Register; 0x00000269 ***
PTIL:               equ    $00000269                                ;*** PTIL - Port L Input Register; 0x00000269 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTIL_PTIL0:         equ    0                                         ; Port L Bit 0
PTIL_PTIL1:         equ    1                                         ; Port L Bit 1
PTIL_PTIL2:         equ    2                                         ; Port L Bit 2
PTIL_PTIL3:         equ    3                                         ; Port L Bit 3
PTIL_PTIL4:         equ    4                                         ; Port L Bit 4
PTIL_PTIL5:         equ    5                                         ; Port L Bit 5
PTIL_PTIL6:         equ    6                                         ; Port L Bit 6
; bit position masks
mPTIL_PTIL0:        equ    %00000001
mPTIL_PTIL1:        equ    %00000010
mPTIL_PTIL2:        equ    %00000100
mPTIL_PTIL3:        equ    %00001000
mPTIL_PTIL4:        equ    %00010000
mPTIL_PTIL5:        equ    %00100000
mPTIL_PTIL6:        equ    %01000000


;*** DDRL - Port L Data Direction Register; 0x0000026A ***
DDRL:               equ    $0000026A                                ;*** DDRL - Port L Data Direction Register; 0x0000026A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRL_DDRL0:         equ    0                                         ; Data Direction Port L Bit 0
DDRL_DDRL1:         equ    1                                         ; Data Direction Port L Bit 1
DDRL_DDRL2:         equ    2                                         ; Data Direction Port L Bit 2
DDRL_DDRL3:         equ    3                                         ; Data Direction Port L Bit 3
DDRL_DDRL4:         equ    4                                         ; Data Direction Port L Bit 4
DDRL_DDRL5:         equ    5                                         ; Data Direction Port L Bit 5
DDRL_DDRL6:         equ    6                                         ; Data Direction Port L Bit 6
; bit position masks
mDDRL_DDRL0:        equ    %00000001
mDDRL_DDRL1:        equ    %00000010
mDDRL_DDRL2:        equ    %00000100
mDDRL_DDRL3:        equ    %00001000
mDDRL_DDRL4:        equ    %00010000
mDDRL_DDRL5:        equ    %00100000
mDDRL_DDRL6:        equ    %01000000


;*** RDRL - Port L Reduced Drive Register; 0x0000026B ***
RDRL:               equ    $0000026B                                ;*** RDRL - Port L Reduced Drive Register; 0x0000026B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RDRL_RDRL0:         equ    0                                         ; Reduced Drive Port L Bit 0
RDRL_RDRL1:         equ    1                                         ; Reduced Drive Port L Bit 1
RDRL_RDRL2:         equ    2                                         ; Reduced Drive Port L Bit 2
RDRL_RDRL3:         equ    3                                         ; Reduced Drive Port L Bit 3
RDRL_RDRL4:         equ    4                                         ; Reduced Drive Port L Bit 4
RDRL_RDRL5:         equ    5                                         ; Reduced Drive Port L Bit 5
RDRL_RDRL6:         equ    6                                         ; Reduced Drive Port L Bit 6
; bit position masks
mRDRL_RDRL0:        equ    %00000001
mRDRL_RDRL1:        equ    %00000010
mRDRL_RDRL2:        equ    %00000100
mRDRL_RDRL3:        equ    %00001000
mRDRL_RDRL4:        equ    %00010000
mRDRL_RDRL5:        equ    %00100000
mRDRL_RDRL6:        equ    %01000000


;*** PERL - Port L Pull Device Enable Register; 0x0000026C ***
PERL:               equ    $0000026C                                ;*** PERL - Port L Pull Device Enable Register; 0x0000026C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PERL_PERL0:         equ    0                                         ; Pull Device Enable Port L Bit 0
PERL_PERL1:         equ    1                                         ; Pull Device Enable Port L Bit 1
PERL_PERL2:         equ    2                                         ; Pull Device Enable Port L Bit 2
PERL_PERL3:         equ    3                                         ; Pull Device Enable Port L Bit 3
PERL_PERL4:         equ    4                                         ; Pull Device Enable Port L Bit 4
PERL_PERL5:         equ    5                                         ; Pull Device Enable Port L Bit 5
PERL_PERL6:         equ    6                                         ; Pull Device Enable Port L Bit 6
; bit position masks
mPERL_PERL0:        equ    %00000001
mPERL_PERL1:        equ    %00000010
mPERL_PERL2:        equ    %00000100
mPERL_PERL3:        equ    %00001000
mPERL_PERL4:        equ    %00010000
mPERL_PERL5:        equ    %00100000
mPERL_PERL6:        equ    %01000000


;*** PPSL - Port L Polarity Select Register; 0x0000026D ***
PPSL:               equ    $0000026D                                ;*** PPSL - Port L Polarity Select Register; 0x0000026D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PPSL_PPSL0:         equ    0                                         ; Pull Select Port L Bit 0
PPSL_PPSL1:         equ    1                                         ; Pull Select Port L Bit 1
PPSL_PPSL2:         equ    2                                         ; Pull Select Port L Bit 2
PPSL_PPSL3:         equ    3                                         ; Pull Select Port L Bit 3
PPSL_PPSL4:         equ    4                                         ; Pull Select Port L Bit 4
PPSL_PPSL5:         equ    5                                         ; Pull Select Port L Bit 5
PPSL_PPSL6:         equ    6                                         ; Pull Select Port L Bit 6
; bit position masks
mPPSL_PPSL0:        equ    %00000001
mPPSL_PPSL1:        equ    %00000010
mPPSL_PPSL2:        equ    %00000100
mPPSL_PPSL3:        equ    %00001000
mPPSL_PPSL4:        equ    %00010000
mPPSL_PPSL5:        equ    %00100000
mPPSL_PPSL6:        equ    %01000000


;*** WOML - Port L Wired-Or Mode Register; 0x0000026E ***
WOML:               equ    $0000026E                                ;*** WOML - Port L Wired-Or Mode Register; 0x0000026E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
WOML_WOML0:         equ    0                                         ; Wired-Or Mode Port L Bit 0
WOML_WOML1:         equ    1                                         ; Wired-Or Mode Port L Bit 1
WOML_WOML2:         equ    2                                         ; Wired-Or Mode Port L Bit 2
WOML_WOML3:         equ    3                                         ; Wired-Or Mode Port L Bit 3
WOML_WOML4:         equ    4                                         ; Wired-Or Mode Port L Bit 4
WOML_WOML5:         equ    5                                         ; Wired-Or Mode Port L Bit 5
WOML_WOML6:         equ    6                                         ; Wired-Or Mode Port L Bit 6
; bit position masks
mWOML_WOML0:        equ    %00000001
mWOML_WOML1:        equ    %00000010
mWOML_WOML2:        equ    %00000100
mWOML_WOML3:        equ    %00001000
mWOML_WOML4:        equ    %00010000
mWOML_WOML5:        equ    %00100000
mWOML_WOML6:        equ    %01000000


;*** BAKEY0 - Backdoor Access Key 0; 0x0000FF00 ***
BAKEY0:             equ    $0000FF00                                ;*** BAKEY0 - Backdoor Access Key 0; 0x0000FF00 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
BAKEY0_KEY0:        equ    0                                         ; Backdoor Access Key bits, bit 0
BAKEY0_KEY1:        equ    1                                         ; Backdoor Access Key bits, bit 1
BAKEY0_KEY2:        equ    2                                         ; Backdoor Access Key bits, bit 2
BAKEY0_KEY3:        equ    3                                         ; Backdoor Access Key bits, bit 3
BAKEY0_KEY4:        equ    4                                         ; Backdoor Access Key bits, bit 4
BAKEY0_KEY5:        equ    5                                         ; Backdoor Access Key bits, bit 5
BAKEY0_KEY6:        equ    6                                         ; Backdoor Access Key bits, bit 6
BAKEY0_KEY7:        equ    7                                         ; Backdoor Access Key bits, bit 7
BAKEY0_KEY8:        equ    8                                         ; Backdoor Access Key bits, bit 8
BAKEY0_KEY9:        equ    9                                         ; Backdoor Access Key bits, bit 9
BAKEY0_KEY10:       equ    10                                        ; Backdoor Access Key bits, bit 10
BAKEY0_KEY11:       equ    11                                        ; Backdoor Access Key bits, bit 11
BAKEY0_KEY12:       equ    12                                        ; Backdoor Access Key bits, bit 12
BAKEY0_KEY13:       equ    13                                        ; Backdoor Access Key bits, bit 13
BAKEY0_KEY14:       equ    14                                        ; Backdoor Access Key bits, bit 14
BAKEY0_KEY15:       equ    15                                        ; Backdoor Access Key bits, bit 15
; bit position masks
mBAKEY0_KEY0:       equ    %00000001
mBAKEY0_KEY1:       equ    %00000010
mBAKEY0_KEY2:       equ    %00000100
mBAKEY0_KEY3:       equ    %00001000
mBAKEY0_KEY4:       equ    %00010000
mBAKEY0_KEY5:       equ    %00100000
mBAKEY0_KEY6:       equ    %01000000
mBAKEY0_KEY7:       equ    %10000000
mBAKEY0_KEY8:       equ    %100000000
mBAKEY0_KEY9:       equ    %1000000000
mBAKEY0_KEY10:      equ    %10000000000
mBAKEY0_KEY11:      equ    %100000000000
mBAKEY0_KEY12:      equ    %1000000000000
mBAKEY0_KEY13:      equ    %10000000000000
mBAKEY0_KEY14:      equ    %100000000000000
mBAKEY0_KEY15:      equ    %1000000000000000


;*** BAKEY1 - Backdoor Access Key 1; 0x0000FF02 ***
BAKEY1:             equ    $0000FF02                                ;*** BAKEY1 - Backdoor Access Key 1; 0x0000FF02 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
BAKEY1_KEY0:        equ    0                                         ; Backdoor Access Key bits, bit 0
BAKEY1_KEY1:        equ    1                                         ; Backdoor Access Key bits, bit 1
BAKEY1_KEY2:        equ    2                                         ; Backdoor Access Key bits, bit 2
BAKEY1_KEY3:        equ    3                                         ; Backdoor Access Key bits, bit 3
BAKEY1_KEY4:        equ    4                                         ; Backdoor Access Key bits, bit 4
BAKEY1_KEY5:        equ    5                                         ; Backdoor Access Key bits, bit 5
BAKEY1_KEY6:        equ    6                                         ; Backdoor Access Key bits, bit 6
BAKEY1_KEY7:        equ    7                                         ; Backdoor Access Key bits, bit 7
BAKEY1_KEY8:        equ    8                                         ; Backdoor Access Key bits, bit 8
BAKEY1_KEY9:        equ    9                                         ; Backdoor Access Key bits, bit 9
BAKEY1_KEY10:       equ    10                                        ; Backdoor Access Key bits, bit 10
BAKEY1_KEY11:       equ    11                                        ; Backdoor Access Key bits, bit 11
BAKEY1_KEY12:       equ    12                                        ; Backdoor Access Key bits, bit 12
BAKEY1_KEY13:       equ    13                                        ; Backdoor Access Key bits, bit 13
BAKEY1_KEY14:       equ    14                                        ; Backdoor Access Key bits, bit 14
BAKEY1_KEY15:       equ    15                                        ; Backdoor Access Key bits, bit 15
; bit position masks
mBAKEY1_KEY0:       equ    %00000001
mBAKEY1_KEY1:       equ    %00000010
mBAKEY1_KEY2:       equ    %00000100
mBAKEY1_KEY3:       equ    %00001000
mBAKEY1_KEY4:       equ    %00010000
mBAKEY1_KEY5:       equ    %00100000
mBAKEY1_KEY6:       equ    %01000000
mBAKEY1_KEY7:       equ    %10000000
mBAKEY1_KEY8:       equ    %100000000
mBAKEY1_KEY9:       equ    %1000000000
mBAKEY1_KEY10:      equ    %10000000000
mBAKEY1_KEY11:      equ    %100000000000
mBAKEY1_KEY12:      equ    %1000000000000
mBAKEY1_KEY13:      equ    %10000000000000
mBAKEY1_KEY14:      equ    %100000000000000
mBAKEY1_KEY15:      equ    %1000000000000000


;*** BAKEY2 - Backdoor Access Key 2; 0x0000FF04 ***
BAKEY2:             equ    $0000FF04                                ;*** BAKEY2 - Backdoor Access Key 2; 0x0000FF04 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
BAKEY2_KEY0:        equ    0                                         ; Backdoor Access Key bits, bit 0
BAKEY2_KEY1:        equ    1                                         ; Backdoor Access Key bits, bit 1
BAKEY2_KEY2:        equ    2                                         ; Backdoor Access Key bits, bit 2
BAKEY2_KEY3:        equ    3                                         ; Backdoor Access Key bits, bit 3
BAKEY2_KEY4:        equ    4                                         ; Backdoor Access Key bits, bit 4
BAKEY2_KEY5:        equ    5                                         ; Backdoor Access Key bits, bit 5
BAKEY2_KEY6:        equ    6                                         ; Backdoor Access Key bits, bit 6
BAKEY2_KEY7:        equ    7                                         ; Backdoor Access Key bits, bit 7
BAKEY2_KEY8:        equ    8                                         ; Backdoor Access Key bits, bit 8
BAKEY2_KEY9:        equ    9                                         ; Backdoor Access Key bits, bit 9
BAKEY2_KEY10:       equ    10                                        ; Backdoor Access Key bits, bit 10
BAKEY2_KEY11:       equ    11                                        ; Backdoor Access Key bits, bit 11
BAKEY2_KEY12:       equ    12                                        ; Backdoor Access Key bits, bit 12
BAKEY2_KEY13:       equ    13                                        ; Backdoor Access Key bits, bit 13
BAKEY2_KEY14:       equ    14                                        ; Backdoor Access Key bits, bit 14
BAKEY2_KEY15:       equ    15                                        ; Backdoor Access Key bits, bit 15
; bit position masks
mBAKEY2_KEY0:       equ    %00000001
mBAKEY2_KEY1:       equ    %00000010
mBAKEY2_KEY2:       equ    %00000100
mBAKEY2_KEY3:       equ    %00001000
mBAKEY2_KEY4:       equ    %00010000
mBAKEY2_KEY5:       equ    %00100000
mBAKEY2_KEY6:       equ    %01000000
mBAKEY2_KEY7:       equ    %10000000
mBAKEY2_KEY8:       equ    %100000000
mBAKEY2_KEY9:       equ    %1000000000
mBAKEY2_KEY10:      equ    %10000000000
mBAKEY2_KEY11:      equ    %100000000000
mBAKEY2_KEY12:      equ    %1000000000000
mBAKEY2_KEY13:      equ    %10000000000000
mBAKEY2_KEY14:      equ    %100000000000000
mBAKEY2_KEY15:      equ    %1000000000000000


;*** BAKEY3 - Backdoor Access Key 3; 0x0000FF06 ***
BAKEY3:             equ    $0000FF06                                ;*** BAKEY3 - Backdoor Access Key 3; 0x0000FF06 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
BAKEY3_KEY0:        equ    0                                         ; Backdoor Access Key bits, bit 0
BAKEY3_KEY1:        equ    1                                         ; Backdoor Access Key bits, bit 1
BAKEY3_KEY2:        equ    2                                         ; Backdoor Access Key bits, bit 2
BAKEY3_KEY3:        equ    3                                         ; Backdoor Access Key bits, bit 3
BAKEY3_KEY4:        equ    4                                         ; Backdoor Access Key bits, bit 4
BAKEY3_KEY5:        equ    5                                         ; Backdoor Access Key bits, bit 5
BAKEY3_KEY6:        equ    6                                         ; Backdoor Access Key bits, bit 6
BAKEY3_KEY7:        equ    7                                         ; Backdoor Access Key bits, bit 7
BAKEY3_KEY8:        equ    8                                         ; Backdoor Access Key bits, bit 8
BAKEY3_KEY9:        equ    9                                         ; Backdoor Access Key bits, bit 9
BAKEY3_KEY10:       equ    10                                        ; Backdoor Access Key bits, bit 10
BAKEY3_KEY11:       equ    11                                        ; Backdoor Access Key bits, bit 11
BAKEY3_KEY12:       equ    12                                        ; Backdoor Access Key bits, bit 12
BAKEY3_KEY13:       equ    13                                        ; Backdoor Access Key bits, bit 13
BAKEY3_KEY14:       equ    14                                        ; Backdoor Access Key bits, bit 14
BAKEY3_KEY15:       equ    15                                        ; Backdoor Access Key bits, bit 15
; bit position masks
mBAKEY3_KEY0:       equ    %00000001
mBAKEY3_KEY1:       equ    %00000010
mBAKEY3_KEY2:       equ    %00000100
mBAKEY3_KEY3:       equ    %00001000
mBAKEY3_KEY4:       equ    %00010000
mBAKEY3_KEY5:       equ    %00100000
mBAKEY3_KEY6:       equ    %01000000
mBAKEY3_KEY7:       equ    %10000000
mBAKEY3_KEY8:       equ    %100000000
mBAKEY3_KEY9:       equ    %1000000000
mBAKEY3_KEY10:      equ    %10000000000
mBAKEY3_KEY11:      equ    %100000000000
mBAKEY3_KEY12:      equ    %1000000000000
mBAKEY3_KEY13:      equ    %10000000000000
mBAKEY3_KEY14:      equ    %100000000000000
mBAKEY3_KEY15:      equ    %1000000000000000


;*** NVFPROT0 - Non volatile Block 0 Flash Protection Register; 0x0000FF0D ***
NVFPROT0:           equ    $0000FF0D                                ;*** NVFPROT0 - Non volatile Block 0 Flash Protection Register; 0x0000FF0D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NVFPROT0_FPLS0:     equ    0                                         ; Flash Protection Lower Address size 0
NVFPROT0_FPLS1:     equ    1                                         ; Flash Protection Lower Address size 1
NVFPROT0_FPLDIS:    equ    2                                         ; Flash Protection Lower address range disable
NVFPROT0_FPHS0:     equ    3                                         ; Flash Protection Higher address size 0
NVFPROT0_FPHS1:     equ    4                                         ; Flash Protection Higher address size 1
NVFPROT0_FPHDIS:    equ    5                                         ; Flash Protection Higher address range disable
NVFPROT0_NV6:       equ    6                                         ; Non Volatile Flag Bit
NVFPROT0_FPOPEN:    equ    7                                         ; Opens the flash block or subsections of it for program or erase
; bit position masks
mNVFPROT0_FPLS0:    equ    %00000001
mNVFPROT0_FPLS1:    equ    %00000010
mNVFPROT0_FPLDIS:   equ    %00000100
mNVFPROT0_FPHS0:    equ    %00001000
mNVFPROT0_FPHS1:    equ    %00010000
mNVFPROT0_FPHDIS:   equ    %00100000
mNVFPROT0_NV6:      equ    %01000000
mNVFPROT0_FPOPEN:   equ    %10000000


;*** NVFSEC - Non volatile Flash Security Register; 0x0000FF0F ***
NVFSEC:             equ    $0000FF0F                                ;*** NVFSEC - Non volatile Flash Security Register; 0x0000FF0F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NVFSEC_SEC0:        equ    0                                         ; Memory security bit 0
NVFSEC_SEC1:        equ    1                                         ; Memory security bit 1
NVFSEC_NV2:         equ    2                                         ; Non Volatile flag bit 2
NVFSEC_NV3:         equ    3                                         ; Non Volatile flag bit 3
NVFSEC_NV4:         equ    4                                         ; Non Volatile flag bit 4
NVFSEC_NV5:         equ    5                                         ; Non Volatile flag bit 5
NVFSEC_NV6:         equ    6                                         ; Non Volatile flag bit 6
NVFSEC_KEYEN:       equ    7                                         ; Backdoor Key Security Enable
; bit position masks
mNVFSEC_SEC0:       equ    %00000001
mNVFSEC_SEC1:       equ    %00000010
mNVFSEC_NV2:        equ    %00000100
mNVFSEC_NV3:        equ    %00001000
mNVFSEC_NV4:        equ    %00010000
mNVFSEC_NV5:        equ    %00100000
mNVFSEC_NV6:        equ    %01000000
mNVFSEC_KEYEN:      equ    %10000000



;***********************************************
;**   D E P R E C I A T E D   S Y M B O L S   **
;***********************************************
        IFNDEF  __GENERATE_APPLICATION__                            ; not supported for absolute assembler
                    XREF    This_symb_has_been_depreciated
        ENDIF
; ---------------------------------------------------------------------------
; The following symbols were removed, because they were invalid or irrelevant
; ---------------------------------------------------------------------------
;
; Follows changes from the database 2.87.103 version
TCNTL                                    EQU        TCNTLo

TC4L                                     EQU        TC4Lo

TC6L                                     EQU        TC6Lo

TC7L                                     EQU        TC7Lo

TC5L                                     EQU        TC5Lo

;
; Follows changes from the database 2.87.119 version
        IFNDEF __GENERATE_APPLICATION__
ATDSTAT2                                 EQU        This_symb_has_been_depreciated
mATDSTAT2_CCF8                           EQU        This_symb_has_been_depreciated
mATDSTAT2_CCF9                           EQU        This_symb_has_been_depreciated
mATDSTAT2_CCF10                          EQU        This_symb_has_been_depreciated
mATDSTAT2_CCF11                          EQU        This_symb_has_been_depreciated
mATDSTAT2_CCF12                          EQU        This_symb_has_been_depreciated
mATDSTAT2_CCF13                          EQU        This_symb_has_been_depreciated
mATDSTAT2_CCF14                          EQU        This_symb_has_been_depreciated
mATDSTAT2_CCF15                          EQU        This_symb_has_been_depreciated
        ENDIF


; **** 24.10.2007 11:10:31

        IFNDEF __GENERATE_APPLICATION__
ATDSTAT2_CCF8:                           equ        This_symb_has_been_depreciated
ATDSTAT2_CCF9:                           equ        This_symb_has_been_depreciated
ATDSTAT2_CCF10:                          equ        This_symb_has_been_depreciated
ATDSTAT2_CCF11:                          equ        This_symb_has_been_depreciated
ATDSTAT2_CCF12:                          equ        This_symb_has_been_depreciated
ATDSTAT2_CCF13:                          equ        This_symb_has_been_depreciated
ATDSTAT2_CCF14:                          equ        This_symb_has_been_depreciated
ATDSTAT2_CCF15:                          equ        This_symb_has_been_depreciated
        ENDIF

; EOF
