; Based on CPU DB MC9S12KG256_112, version 2.87.147 (RegistersPrg V2.28)

; ###################################################################
;     Filename  : mc9s12kg256.inc
;     Processor : MC9S12KG256CPV
;     FileFormat: V2.28
;     DataSheet : 9S12KT256DGV1/D V01.09 9 SEP 2004
;     Compiler  : CodeWarrior compiler
;     Date/Time : 2.7.2009, 8:41
;     Abstract  :
;         This header implements the mapping of I/O devices.
;
;     Copyright : 1997 - 2009 Freescale Semiconductor, Inc. All Rights Reserved.
;     
;     http      : www.freescale.com
;     mail      : support@freescale.com
;
;     CPU Registers Revisions:
;      - 11.07.2006, V2.87.117:
;              - Removed device MSCAN1. REASON: Bug-fix (#3486 in Issue Manager)
;      - 12.09.2006, V2.87.136:
;              - Renamed bits FDATA_FDATAx ==> FDATA_FDATALx/FDATA_FDATAHx REASON: Bug-fix (#3521 in Issue Manager)
;
;     File-Format-Revisions:
;      - 14.11.2005, V2.00 :
;               - Deprecated symbols added for backward compatibility (section at the end of this file)
;      - 15.11.2005, V2.01 :
;               - Fixed invalid instruction in macro __RESET_WATCHDOG for HCS12 family.
;      - 17.12.2005, V2.02 :
;               - Arrays (symbols xx_ARR) are defined as pointer to volatile, see issue #2778
;      - 16.01.2006, V2.03 :
;               - Fixed declaration of non volatile registers. Now it does not require (but allows) their initialization, see issue #2920.
;               - "volatile" modifier removed from declaration of non volatile registers (that contain modifier "const")
;      - 08.03.2006, V2.04 :
;               - Support for bit(s) names duplicated with any register name in .h header files
;      - 24.03.2006, V2.05 :
;               - Fixed macro __RESET_WATCHDOG for HCS12 family - address and correct write order.
;      - 26.04.2006, V2.06 :
;               - Changes have not affected this file (because they are related to another family)
;      - 27.04.2006, V2.07 :
;               - Fixed macro __RESET_WATCHDOG for HCS12, HCS12X ,HCS08 DZ and HCS08 EN derivatives (write 0x55,0xAA).
;      - 07.06.2006, V2.08 :
;               - Changes have not affected this file (because they are related to another family)
;      - 03.07.2006, V2.09 :
;               - Changes have not affected this file (because they are related to another family)
;      - 27.10.2006, V2.10 :
;               - __RESET_WATCHDOG improved formating and re-definition
;      - 23.11.2006, V2.11 :
;               - Changes have not affected this file (because they are related to another family)
;      - 22.01.2007, V2.12 :
;               - Fixed declaration of non volatile registers. Now it does not require (but allows) their initialization, see issue #4086.
;      - 01.03.2007, V2.13 :
;               - Flash commands constants values converted to HEX format
;      - 02.03.2007, V2.14 :
;               - Interrupt vector numbers added into .H, see VectorNumber_*
;      - 26.03.2007, V2.15 :
;               - Changes have not affected this file (because they are related to another family)
;      - 10.05.2007, V2.16 :
;               - Changes have not affected this file (because they are related to another family)
;      - 05.06.2007, V2.17 :
;               - Changes have not affected this file (because they are related to another family)
;      - 19.07.2007, V2.18 :
;               - Improved number of blanked lines inside register structures
;      - 06.08.2007, V2.19 :
;               - CPUDB revisions generated ahead of the file-format revisions.
;      - 11.09.2007, V2.20 :
;               - Added comment about initialization of unbonded pins.
;      - 02.01.2008, V2.21 :
;               - Changes have not affected this file (because they are related to another family)
;      - 13.02.2008, V2.22 :
;               - Changes have not affected this file (because they are related to another family)
;      - 20.02.2008, V2.23 :
;               - Termination of pragma V30toV31Compatible added, #5708
;      - 03.07.2008, V2.24 :
;               - Added support for bits with name starting with number (like "1HZ")
;      - 28.11.2008, V2.25 :
;               - StandBy RAM array declaration for ANSI-C added
;      - 1.12.2008, V2.26 :
;               - Duplication of bit (or bit-group) name with register name is not marked as a problem, is register is internal only and it is not displayed in I/O map.
;      - 17.3.2009, V2.27 :
;               - Merged bit-group is not generated, if the name matches with another bit name in the register
;      - 6.4.2009, V2.28 :
;               - Fixed generation of merged bits for bit-groups with a digit at the end, if group-name is defined in CPUDB
;
;     Not all general-purpose I/O pins are available on all packages or on all mask sets of a specific
;     derivative device. To avoid extra current drain from floating input pins, the users reset
;     initialization routine in the application program must either enable on-chip pull-up devices
;     or change the direction of unconnected pins to outputs so the pins do not float.
; ###################################################################

;*** Memory Map and Interrupt Vectors
;******************************************
EEPROMStart:        equ   $00000400
EEPROMEnd:          equ   $00000FEF
RAMStart:           equ   $00001000
RAMEnd:             equ   $00003FFF
ROM_4000Start:      equ   $00004000
ROM_4000End:        equ   $00007FFF
ROM_C000Start:      equ   $0000C000
ROM_C000End:        equ   $0000FEFF
PAGE_30Start:       equ   $00308000
PAGE_30End:         equ   $0030BFFF
PAGE_31Start:       equ   $00318000
PAGE_31End:         equ   $0031BFFF
PAGE_32Start:       equ   $00328000
PAGE_32End:         equ   $0032BFFF
PAGE_33Start:       equ   $00338000
PAGE_33End:         equ   $0033BFFF
PAGE_34Start:       equ   $00348000
PAGE_34End:         equ   $0034BFFF
PAGE_35Start:       equ   $00358000
PAGE_35End:         equ   $0035BFFF
PAGE_36Start:       equ   $00368000
PAGE_36End:         equ   $0036BFFF
PAGE_37Start:       equ   $00378000
PAGE_37End:         equ   $0037BFFF
PAGE_38Start:       equ   $00388000
PAGE_38End:         equ   $0038BFFF
PAGE_39Start:       equ   $00398000
PAGE_39End:         equ   $0039BFFF
PAGE_3AStart:       equ   $003A8000
PAGE_3AEnd:         equ   $003ABFFF
PAGE_3BStart:       equ   $003B8000
PAGE_3BEnd:         equ   $003BBFFF
PAGE_3CStart:       equ   $003C8000
PAGE_3CEnd:         equ   $003CBFFF
PAGE_3DStart:       equ   $003D8000
PAGE_3DEnd:         equ   $003DBFFF
;
VReserved63:        equ   $0000FF80
VReserved62:        equ   $0000FF82
VReserved61:        equ   $0000FF84
VReserved60:        equ   $0000FF86
VReserved59:        equ   $0000FF88
Vvreglvi:           equ   $0000FF8A
Vpwmesdn:           equ   $0000FF8C
Vportp:             equ   $0000FF8E
Vcan4tx:            equ   $0000FF90
Vcan4rx:            equ   $0000FF92
Vcan4err:           equ   $0000FF94
Vcan4wkup:          equ   $0000FF96
VReserved51:        equ   $0000FF98
VReserved50:        equ   $0000FF9A
VReserved49:        equ   $0000FF9C
VReserved48:        equ   $0000FF9E
VReserved47:        equ   $0000FFA0
VReserved46:        equ   $0000FFA2
VReserved45:        equ   $0000FFA4
VReserved44:        equ   $0000FFA6
VReserved43:        equ   $0000FFA8
VReserved42:        equ   $0000FFAA
VReserved41:        equ   $0000FFAC
VReserved40:        equ   $0000FFAE
Vcan0tx:            equ   $0000FFB0
Vcan0rx:            equ   $0000FFB2
Vcan0err:           equ   $0000FFB4
Vcan0wkup:          equ   $0000FFB6
Vflash:             equ   $0000FFB8
Veeprom:            equ   $0000FFBA
Vspi2:              equ   $0000FFBC
Vspi1:              equ   $0000FFBE
Viic:               equ   $0000FFC0
Vflashdfd:          equ   $0000FFC2
Vcrgscm:            equ   $0000FFC4
Vcrgplllck:         equ   $0000FFC6
VReserved27:        equ   $0000FFC8
VReserved26:        equ   $0000FFCA
Vporth:             equ   $0000FFCC
Vportj:             equ   $0000FFCE
Vatd1:              equ   $0000FFD0
Vatd0:              equ   $0000FFD2
Vsci1:              equ   $0000FFD4
Vsci0:              equ   $0000FFD6
Vspi0:              equ   $0000FFD8
Vtimpaie:           equ   $0000FFDA
Vtimpaovf:          equ   $0000FFDC
Vtimovf:            equ   $0000FFDE
Vtimch7:            equ   $0000FFE0
Vtimch6:            equ   $0000FFE2
Vtimch5:            equ   $0000FFE4
Vtimch4:            equ   $0000FFE6
Vtimch3:            equ   $0000FFE8
Vtimch2:            equ   $0000FFEA
Vtimch1:            equ   $0000FFEC
Vtimch0:            equ   $0000FFEE
Vrti:               equ   $0000FFF0
Virq:               equ   $0000FFF2
Vxirq:              equ   $0000FFF4
Vswi:               equ   $0000FFF6
Vtrap:              equ   $0000FFF8
Vcop:               equ   $0000FFFA
Vclkmon:            equ   $0000FFFC
Vreset:             equ   $0000FFFE
;


;*** PORTAB - Port AB Register; 0x00000000 ***
PORTAB:             equ    $00000000                                ;*** PORTAB - Port AB Register; 0x00000000 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PORTAB_BIT0:        equ    0                                         ; Port AB Bit 0
PORTAB_BIT1:        equ    1                                         ; Port AB Bit 1
PORTAB_BIT2:        equ    2                                         ; Port AB Bit 2
PORTAB_BIT3:        equ    3                                         ; Port AB Bit 3
PORTAB_BIT4:        equ    4                                         ; Port AB Bit 4
PORTAB_BIT5:        equ    5                                         ; Port AB Bit 5
PORTAB_BIT6:        equ    6                                         ; Port AB Bit 6
PORTAB_BIT7:        equ    7                                         ; Port AB Bit 7
PORTAB_BIT8:        equ    8                                         ; Port AB Bit 8
PORTAB_BIT9:        equ    9                                         ; Port AB Bit 9
PORTAB_BIT10:       equ    10                                        ; Port AB Bit 10
PORTAB_BIT11:       equ    11                                        ; Port AB Bit 11
PORTAB_BIT12:       equ    12                                        ; Port AB Bit 12
PORTAB_BIT13:       equ    13                                        ; Port AB Bit 13
PORTAB_BIT14:       equ    14                                        ; Port AB Bit 14
PORTAB_BIT15:       equ    15                                        ; Port AB Bit 15
; bit position masks
mPORTAB_BIT0:       equ    %00000001
mPORTAB_BIT1:       equ    %00000010
mPORTAB_BIT2:       equ    %00000100
mPORTAB_BIT3:       equ    %00001000
mPORTAB_BIT4:       equ    %00010000
mPORTAB_BIT5:       equ    %00100000
mPORTAB_BIT6:       equ    %01000000
mPORTAB_BIT7:       equ    %10000000
mPORTAB_BIT8:       equ    %100000000
mPORTAB_BIT9:       equ    %1000000000
mPORTAB_BIT10:      equ    %10000000000
mPORTAB_BIT11:      equ    %100000000000
mPORTAB_BIT12:      equ    %1000000000000
mPORTAB_BIT13:      equ    %10000000000000
mPORTAB_BIT14:      equ    %100000000000000
mPORTAB_BIT15:      equ    %1000000000000000


;*** PORTA - Port A Register; 0x00000000 ***
PORTA:              equ    $00000000                                ;*** PORTA - Port A Register; 0x00000000 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PORTA_BIT0:         equ    0                                         ; Port A Bit 0
PORTA_BIT1:         equ    1                                         ; Port A Bit 1
PORTA_BIT2:         equ    2                                         ; Port A Bit 2
PORTA_BIT3:         equ    3                                         ; Port A Bit 3
PORTA_BIT4:         equ    4                                         ; Port A Bit 4
PORTA_BIT5:         equ    5                                         ; Port A Bit 5
PORTA_BIT6:         equ    6                                         ; Port A Bit 6
PORTA_BIT7:         equ    7                                         ; Port A Bit 7
; bit position masks
mPORTA_BIT0:        equ    %00000001
mPORTA_BIT1:        equ    %00000010
mPORTA_BIT2:        equ    %00000100
mPORTA_BIT3:        equ    %00001000
mPORTA_BIT4:        equ    %00010000
mPORTA_BIT5:        equ    %00100000
mPORTA_BIT6:        equ    %01000000
mPORTA_BIT7:        equ    %10000000


;*** PORTB - Port B Register; 0x00000001 ***
PORTB:              equ    $00000001                                ;*** PORTB - Port B Register; 0x00000001 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PORTB_BIT0:         equ    0                                         ; Port B Bit 0
PORTB_BIT1:         equ    1                                         ; Port B Bit 1
PORTB_BIT2:         equ    2                                         ; Port B Bit 2
PORTB_BIT3:         equ    3                                         ; Port B Bit 3
PORTB_BIT4:         equ    4                                         ; Port B Bit 4
PORTB_BIT5:         equ    5                                         ; Port B Bit 5
PORTB_BIT6:         equ    6                                         ; Port B Bit 6
PORTB_BIT7:         equ    7                                         ; Port B Bit 7
; bit position masks
mPORTB_BIT0:        equ    %00000001
mPORTB_BIT1:        equ    %00000010
mPORTB_BIT2:        equ    %00000100
mPORTB_BIT3:        equ    %00001000
mPORTB_BIT4:        equ    %00010000
mPORTB_BIT5:        equ    %00100000
mPORTB_BIT6:        equ    %01000000
mPORTB_BIT7:        equ    %10000000


;*** DDRAB - Port AB Data Direction Register; 0x00000002 ***
DDRAB:              equ    $00000002                                ;*** DDRAB - Port AB Data Direction Register; 0x00000002 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRAB_BIT0:         equ    0                                         ; Data Direction Port AB Bit 0
DDRAB_BIT1:         equ    1                                         ; Data Direction Port AB Bit 1
DDRAB_BIT2:         equ    2                                         ; Data Direction Port AB Bit 2
DDRAB_BIT3:         equ    3                                         ; Data Direction Port AB Bit 3
DDRAB_BIT4:         equ    4                                         ; Data Direction Port AB Bit 4
DDRAB_BIT5:         equ    5                                         ; Data Direction Port AB Bit 5
DDRAB_BIT6:         equ    6                                         ; Data Direction Port AB Bit 6
DDRAB_BIT7:         equ    7                                         ; Data Direction Port AB Bit 7
DDRAB_BIT8:         equ    8                                         ; Data Direction Port AB Bit 8
DDRAB_BIT9:         equ    9                                         ; Data Direction Port AB Bit 9
DDRAB_BIT10:        equ    10                                        ; Data Direction Port AB Bit 10
DDRAB_BIT11:        equ    11                                        ; Data Direction Port AB Bit 11
DDRAB_BIT12:        equ    12                                        ; Data Direction Port AB Bit 12
DDRAB_BIT13:        equ    13                                        ; Data Direction Port AB Bit 13
DDRAB_BIT14:        equ    14                                        ; Data Direction Port AB Bit 14
DDRAB_BIT15:        equ    15                                        ; Data Direction Port AB Bit 15
; bit position masks
mDDRAB_BIT0:        equ    %00000001
mDDRAB_BIT1:        equ    %00000010
mDDRAB_BIT2:        equ    %00000100
mDDRAB_BIT3:        equ    %00001000
mDDRAB_BIT4:        equ    %00010000
mDDRAB_BIT5:        equ    %00100000
mDDRAB_BIT6:        equ    %01000000
mDDRAB_BIT7:        equ    %10000000
mDDRAB_BIT8:        equ    %100000000
mDDRAB_BIT9:        equ    %1000000000
mDDRAB_BIT10:       equ    %10000000000
mDDRAB_BIT11:       equ    %100000000000
mDDRAB_BIT12:       equ    %1000000000000
mDDRAB_BIT13:       equ    %10000000000000
mDDRAB_BIT14:       equ    %100000000000000
mDDRAB_BIT15:       equ    %1000000000000000


;*** DDRA - Port A Data Direction Register; 0x00000002 ***
DDRA:               equ    $00000002                                ;*** DDRA - Port A Data Direction Register; 0x00000002 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRA_BIT0:          equ    0                                         ; Data Direction Port A Bit 0
DDRA_BIT1:          equ    1                                         ; Data Direction Port A Bit 1
DDRA_BIT2:          equ    2                                         ; Data Direction Port A Bit 2
DDRA_BIT3:          equ    3                                         ; Data Direction Port A Bit 3
DDRA_BIT4:          equ    4                                         ; Data Direction Port A Bit 4
DDRA_BIT5:          equ    5                                         ; Data Direction Port A Bit 5
DDRA_BIT6:          equ    6                                         ; Data Direction Port A Bit 6
DDRA_BIT7:          equ    7                                         ; Data Direction Port A Bit 7
; bit position masks
mDDRA_BIT0:         equ    %00000001
mDDRA_BIT1:         equ    %00000010
mDDRA_BIT2:         equ    %00000100
mDDRA_BIT3:         equ    %00001000
mDDRA_BIT4:         equ    %00010000
mDDRA_BIT5:         equ    %00100000
mDDRA_BIT6:         equ    %01000000
mDDRA_BIT7:         equ    %10000000


;*** DDRB - Port B Data Direction Register; 0x00000003 ***
DDRB:               equ    $00000003                                ;*** DDRB - Port B Data Direction Register; 0x00000003 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRB_BIT0:          equ    0                                         ; Data Direction Port B Bit 0
DDRB_BIT1:          equ    1                                         ; Data Direction Port B Bit 1
DDRB_BIT2:          equ    2                                         ; Data Direction Port B Bit 2
DDRB_BIT3:          equ    3                                         ; Data Direction Port B Bit 3
DDRB_BIT4:          equ    4                                         ; Data Direction Port B Bit 4
DDRB_BIT5:          equ    5                                         ; Data Direction Port B Bit 5
DDRB_BIT6:          equ    6                                         ; Data Direction Port B Bit 6
DDRB_BIT7:          equ    7                                         ; Data Direction Port B Bit 7
; bit position masks
mDDRB_BIT0:         equ    %00000001
mDDRB_BIT1:         equ    %00000010
mDDRB_BIT2:         equ    %00000100
mDDRB_BIT3:         equ    %00001000
mDDRB_BIT4:         equ    %00010000
mDDRB_BIT5:         equ    %00100000
mDDRB_BIT6:         equ    %01000000
mDDRB_BIT7:         equ    %10000000


;*** PORTE - Port E Register; 0x00000008 ***
PORTE:              equ    $00000008                                ;*** PORTE - Port E Register; 0x00000008 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PORTE_BIT0:         equ    0                                         ; Port E Bit 0
PORTE_BIT1:         equ    1                                         ; Port E Bit 1
PORTE_BIT2:         equ    2                                         ; Port E Bit 2
PORTE_BIT3:         equ    3                                         ; Port E Bit 3
PORTE_BIT4:         equ    4                                         ; Port E Bit 4
PORTE_BIT5:         equ    5                                         ; Port E Bit 5
PORTE_BIT6:         equ    6                                         ; Port E Bit 6
PORTE_BIT7:         equ    7                                         ; Port E Bit 7
; bit position masks
mPORTE_BIT0:        equ    %00000001
mPORTE_BIT1:        equ    %00000010
mPORTE_BIT2:        equ    %00000100
mPORTE_BIT3:        equ    %00001000
mPORTE_BIT4:        equ    %00010000
mPORTE_BIT5:        equ    %00100000
mPORTE_BIT6:        equ    %01000000
mPORTE_BIT7:        equ    %10000000


;*** DDRE - Port E Data Direction Register; 0x00000009 ***
DDRE:               equ    $00000009                                ;*** DDRE - Port E Data Direction Register; 0x00000009 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRE_BIT2:          equ    2                                         ; Data Direction Port E Bit 2
DDRE_BIT3:          equ    3                                         ; Data Direction Port E Bit 3
DDRE_BIT4:          equ    4                                         ; Data Direction Port E Bit 4
DDRE_BIT5:          equ    5                                         ; Data Direction Port E Bit 5
DDRE_BIT6:          equ    6                                         ; Data Direction Port E Bit 6
DDRE_BIT7:          equ    7                                         ; Data Direction Port E Bit 7
; bit position masks
mDDRE_BIT2:         equ    %00000100
mDDRE_BIT3:         equ    %00001000
mDDRE_BIT4:         equ    %00010000
mDDRE_BIT5:         equ    %00100000
mDDRE_BIT6:         equ    %01000000
mDDRE_BIT7:         equ    %10000000


;*** PEAR - Port E Assignment Register; 0x0000000A ***
PEAR:               equ    $0000000A                                ;*** PEAR - Port E Assignment Register; 0x0000000A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PEAR_RDWE:          equ    2                                         ; Read / Write Enable
PEAR_LSTRE:         equ    3                                         ; Low Strobe (LSTRB) Enable
PEAR_NECLK:         equ    4                                         ; No External E Clock
PEAR_PIPOE:         equ    5                                         ; Pipe Status Signal Output Enable
PEAR_NOACCE:        equ    7                                         ; CPU No Access Output Enable
; bit position masks
mPEAR_RDWE:         equ    %00000100
mPEAR_LSTRE:        equ    %00001000
mPEAR_NECLK:        equ    %00010000
mPEAR_PIPOE:        equ    %00100000
mPEAR_NOACCE:       equ    %10000000


;*** MODE - Mode Register; 0x0000000B ***
MODE:               equ    $0000000B                                ;*** MODE - Mode Register; 0x0000000B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MODE_EME:           equ    0                                         ; Emulate Port E
MODE_EMK:           equ    1                                         ; Emulate Port K
MODE_IVIS:          equ    3                                         ; Internal Visibility
MODE_MODA:          equ    5                                         ; Mode Select Bit A
MODE_MODB:          equ    6                                         ; Mode Select Bit B
MODE_MODC:          equ    7                                         ; Mode Select Bit C
; bit position masks
mMODE_EME:          equ    %00000001
mMODE_EMK:          equ    %00000010
mMODE_IVIS:         equ    %00001000
mMODE_MODA:         equ    %00100000
mMODE_MODB:         equ    %01000000
mMODE_MODC:         equ    %10000000


;*** PUCR - Pull-Up Control Register; 0x0000000C ***
PUCR:               equ    $0000000C                                ;*** PUCR - Pull-Up Control Register; 0x0000000C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PUCR_PUPAE:         equ    0                                         ; Pull-Up Port A Enable
PUCR_PUPBE:         equ    1                                         ; Pull-Up Port B Enable
PUCR_PUPEE:         equ    4                                         ; Pull-Up Port E Enable
PUCR_PUPKE:         equ    7                                         ; Pull-Up Port K Enable
; bit position masks
mPUCR_PUPAE:        equ    %00000001
mPUCR_PUPBE:        equ    %00000010
mPUCR_PUPEE:        equ    %00010000
mPUCR_PUPKE:        equ    %10000000


;*** RDRIV - Reduced Drive of I/O Lines; 0x0000000D ***
RDRIV:              equ    $0000000D                                ;*** RDRIV - Reduced Drive of I/O Lines; 0x0000000D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RDRIV_RDPA:         equ    0                                         ; Reduced Drive of Port A
RDRIV_RDPB:         equ    1                                         ; Reduced Drive of Port B
RDRIV_RDPE:         equ    4                                         ; Reduced Drive of Port E
RDRIV_RDPK:         equ    7                                         ; Reduced Drive of Port K
; bit position masks
mRDRIV_RDPA:        equ    %00000001
mRDRIV_RDPB:        equ    %00000010
mRDRIV_RDPE:        equ    %00010000
mRDRIV_RDPK:        equ    %10000000


;*** EBICTL - External Bus Interface Control; 0x0000000E ***
EBICTL:             equ    $0000000E                                ;*** EBICTL - External Bus Interface Control; 0x0000000E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
EBICTL_ESTR:        equ    0                                         ; E Stretches
; bit position masks
mEBICTL_ESTR:       equ    %00000001


;*** INITRM - Initialization of Internal RAM Position Register; 0x00000010 ***
INITRM:             equ    $00000010                                ;*** INITRM - Initialization of Internal RAM Position Register; 0x00000010 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
INITRM_RAMHAL:      equ    0                                         ; Internal RAM map alignment
INITRM_RAM11:       equ    3                                         ; Internal RAM map position Bit 11
INITRM_RAM12:       equ    4                                         ; Internal RAM map position Bit 12
INITRM_RAM13:       equ    5                                         ; Internal RAM map position Bit 13
INITRM_RAM14:       equ    6                                         ; Internal RAM map position Bit 14
INITRM_RAM15:       equ    7                                         ; Internal RAM map position Bit 15
; bit position masks
mINITRM_RAMHAL:     equ    %00000001
mINITRM_RAM11:      equ    %00001000
mINITRM_RAM12:      equ    %00010000
mINITRM_RAM13:      equ    %00100000
mINITRM_RAM14:      equ    %01000000
mINITRM_RAM15:      equ    %10000000


;*** INITRG - Initialization of Internal Registers Position Register; 0x00000011 ***
INITRG:             equ    $00000011                                ;*** INITRG - Initialization of Internal Registers Position Register; 0x00000011 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
INITRG_REG11:       equ    3                                         ; Internal Registers Map Position Bit 11
INITRG_REG12:       equ    4                                         ; Internal Registers Map Position Bit 12
INITRG_REG13:       equ    5                                         ; Internal Registers Map Position Bit 13
INITRG_REG14:       equ    6                                         ; Internal Registers Map Position Bit 14
; bit position masks
mINITRG_REG11:      equ    %00001000
mINITRG_REG12:      equ    %00010000
mINITRG_REG13:      equ    %00100000
mINITRG_REG14:      equ    %01000000


;*** INITEE - Initialization of Internal EEPROM Position Register; 0x00000012 ***
INITEE:             equ    $00000012                                ;*** INITEE - Initialization of Internal EEPROM Position Register; 0x00000012 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
INITEE_EEON:        equ    0                                         ; Internal EEPROM On
INITEE_EE11:        equ    3                                         ; Internal EEPROM map position Bit 11
INITEE_EE12:        equ    4                                         ; Internal EEPROM map position Bit 12
INITEE_EE13:        equ    5                                         ; Internal EEPROM map position Bit 13
INITEE_EE14:        equ    6                                         ; Internal EEPROM map position Bit 14
INITEE_EE15:        equ    7                                         ; Internal EEPROM map position Bit 15
; bit position masks
mINITEE_EEON:       equ    %00000001
mINITEE_EE11:       equ    %00001000
mINITEE_EE12:       equ    %00010000
mINITEE_EE13:       equ    %00100000
mINITEE_EE14:       equ    %01000000
mINITEE_EE15:       equ    %10000000


;*** MISC - Miscellaneous System Control Register; 0x00000013 ***
MISC:               equ    $00000013                                ;*** MISC - Miscellaneous System Control Register; 0x00000013 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MISC_ROMON:         equ    0                                         ; Enable Flash EEPROM
MISC_ROMHM:         equ    1                                         ; Flash EEPROM only in second half of memory map
MISC_EXSTR0:        equ    2                                         ; External Access Stretch Bit 0
MISC_EXSTR1:        equ    3                                         ; External Access Stretch Bit 1
; bit position masks
mMISC_ROMON:        equ    %00000001
mMISC_ROMHM:        equ    %00000010
mMISC_EXSTR0:       equ    %00000100
mMISC_EXSTR1:       equ    %00001000


;*** ITCR - Interrupt Test Control Register; 0x00000015 ***
ITCR:               equ    $00000015                                ;*** ITCR - Interrupt Test Control Register; 0x00000015 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ITCR_ADR0:          equ    0                                         ; Test register select Bit 0
ITCR_ADR1:          equ    1                                         ; Test register select Bit 1
ITCR_ADR2:          equ    2                                         ; Test register select Bit 2
ITCR_ADR3:          equ    3                                         ; Test register select Bit 3
ITCR_WRTINT:        equ    4                                         ; Write to the Interrupt Test Registers
; bit position masks
mITCR_ADR0:         equ    %00000001
mITCR_ADR1:         equ    %00000010
mITCR_ADR2:         equ    %00000100
mITCR_ADR3:         equ    %00001000
mITCR_WRTINT:       equ    %00010000


;*** ITEST - Interrupt Test Register; 0x00000016 ***
ITEST:              equ    $00000016                                ;*** ITEST - Interrupt Test Register; 0x00000016 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ITEST_INT0:         equ    0                                         ; Interrupt Test Register Bit 0
ITEST_INT2:         equ    1                                         ; Interrupt Test Register Bit 1
ITEST_INT4:         equ    2                                         ; Interrupt Test Register Bit 2
ITEST_INT6:         equ    3                                         ; Interrupt Test Register Bit 3
ITEST_INT8:         equ    4                                         ; Interrupt Test Register Bit 4
ITEST_INTA:         equ    5                                         ; Interrupt Test Register Bit 5
ITEST_INTC:         equ    6                                         ; Interrupt Test Register Bit 6
ITEST_INTE:         equ    7                                         ; Interrupt Test Register Bit 7
; bit position masks
mITEST_INT0:        equ    %00000001
mITEST_INT2:        equ    %00000010
mITEST_INT4:        equ    %00000100
mITEST_INT6:        equ    %00001000
mITEST_INT8:        equ    %00010000
mITEST_INTA:        equ    %00100000
mITEST_INTC:        equ    %01000000
mITEST_INTE:        equ    %10000000


;*** VREGCTRL - VREG_3V3 - Control Register; 0x00000019 ***
VREGCTRL:           equ    $00000019                                ;*** VREGCTRL - VREG_3V3 - Control Register; 0x00000019 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
VREGCTRL_LVIF:      equ    0                                         ; Low Voltage Interrupt Flag
VREGCTRL_LVIE:      equ    1                                         ; Low Voltage Interrupt Enable Bit
VREGCTRL_LVDS:      equ    2                                         ; Low Voltage Detect Status Bit
; bit position masks
mVREGCTRL_LVIF:     equ    %00000001
mVREGCTRL_LVIE:     equ    %00000010
mVREGCTRL_LVDS:     equ    %00000100


;*** PARTID - Part ID Register; 0x0000001A ***
PARTID:             equ    $0000001A                                ;*** PARTID - Part ID Register; 0x0000001A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PARTID_ID0:         equ    0                                         ; Part ID Register Bit 0
PARTID_ID1:         equ    1                                         ; Part ID Register Bit 1
PARTID_ID2:         equ    2                                         ; Part ID Register Bit 2
PARTID_ID3:         equ    3                                         ; Part ID Register Bit 3
PARTID_ID4:         equ    4                                         ; Part ID Register Bit 4
PARTID_ID5:         equ    5                                         ; Part ID Register Bit 5
PARTID_ID6:         equ    6                                         ; Part ID Register Bit 6
PARTID_ID7:         equ    7                                         ; Part ID Register Bit 7
PARTID_ID8:         equ    8                                         ; Part ID Register Bit 8
PARTID_ID9:         equ    9                                         ; Part ID Register Bit 9
PARTID_ID10:        equ    10                                        ; Part ID Register Bit 10
PARTID_ID11:        equ    11                                        ; Part ID Register Bit 11
PARTID_ID12:        equ    12                                        ; Part ID Register Bit 12
PARTID_ID13:        equ    13                                        ; Part ID Register Bit 13
PARTID_ID14:        equ    14                                        ; Part ID Register Bit 14
PARTID_ID15:        equ    15                                        ; Part ID Register Bit 15
; bit position masks
mPARTID_ID0:        equ    %00000001
mPARTID_ID1:        equ    %00000010
mPARTID_ID2:        equ    %00000100
mPARTID_ID3:        equ    %00001000
mPARTID_ID4:        equ    %00010000
mPARTID_ID5:        equ    %00100000
mPARTID_ID6:        equ    %01000000
mPARTID_ID7:        equ    %10000000
mPARTID_ID8:        equ    %100000000
mPARTID_ID9:        equ    %1000000000
mPARTID_ID10:       equ    %10000000000
mPARTID_ID11:       equ    %100000000000
mPARTID_ID12:       equ    %1000000000000
mPARTID_ID13:       equ    %10000000000000
mPARTID_ID14:       equ    %100000000000000
mPARTID_ID15:       equ    %1000000000000000


;*** PARTIDH - Part ID Register High; 0x0000001A ***
PARTIDH:            equ    $0000001A                                ;*** PARTIDH - Part ID Register High; 0x0000001A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PARTIDH_ID8:        equ    0                                         ; Part ID Register Bit 8
PARTIDH_ID9:        equ    1                                         ; Part ID Register Bit 9
PARTIDH_ID10:       equ    2                                         ; Part ID Register Bit 10
PARTIDH_ID11:       equ    3                                         ; Part ID Register Bit 11
PARTIDH_ID12:       equ    4                                         ; Part ID Register Bit 12
PARTIDH_ID13:       equ    5                                         ; Part ID Register Bit 13
PARTIDH_ID14:       equ    6                                         ; Part ID Register Bit 14
PARTIDH_ID15:       equ    7                                         ; Part ID Register Bit 15
; bit position masks
mPARTIDH_ID8:       equ    %00000001
mPARTIDH_ID9:       equ    %00000010
mPARTIDH_ID10:      equ    %00000100
mPARTIDH_ID11:      equ    %00001000
mPARTIDH_ID12:      equ    %00010000
mPARTIDH_ID13:      equ    %00100000
mPARTIDH_ID14:      equ    %01000000
mPARTIDH_ID15:      equ    %10000000


;*** PARTIDL - Part ID Register Low; 0x0000001B ***
PARTIDL:            equ    $0000001B                                ;*** PARTIDL - Part ID Register Low; 0x0000001B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PARTIDL_ID0:        equ    0                                         ; Part ID Register Bit 0
PARTIDL_ID1:        equ    1                                         ; Part ID Register Bit 1
PARTIDL_ID2:        equ    2                                         ; Part ID Register Bit 2
PARTIDL_ID3:        equ    3                                         ; Part ID Register Bit 3
PARTIDL_ID4:        equ    4                                         ; Part ID Register Bit 4
PARTIDL_ID5:        equ    5                                         ; Part ID Register Bit 5
PARTIDL_ID6:        equ    6                                         ; Part ID Register Bit 6
PARTIDL_ID7:        equ    7                                         ; Part ID Register Bit 7
; bit position masks
mPARTIDL_ID0:       equ    %00000001
mPARTIDL_ID1:       equ    %00000010
mPARTIDL_ID2:       equ    %00000100
mPARTIDL_ID3:       equ    %00001000
mPARTIDL_ID4:       equ    %00010000
mPARTIDL_ID5:       equ    %00100000
mPARTIDL_ID6:       equ    %01000000
mPARTIDL_ID7:       equ    %10000000


;*** MEMSIZ0 - Memory Size Register Zero; 0x0000001C ***
MEMSIZ0:            equ    $0000001C                                ;*** MEMSIZ0 - Memory Size Register Zero; 0x0000001C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MEMSIZ0_ram_sw0:    equ    0                                         ; Allocated System RAM Memory Space Bit 0
MEMSIZ0_ram_sw1:    equ    1                                         ; Allocated System RAM Memory Space Bit 1
MEMSIZ0_ram_sw2:    equ    2                                         ; Allocated System RAM Memory Space Bit 2
MEMSIZ0_eep_sw0:    equ    4                                         ; Allocated EEPROM Memory Space Bit 0
MEMSIZ0_eep_sw1:    equ    5                                         ; Allocated EEPROM Memory Space Bit 1
MEMSIZ0_reg_sw0:    equ    7                                         ; Allocated System Register Space
; bit position masks
mMEMSIZ0_ram_sw0:   equ    %00000001
mMEMSIZ0_ram_sw1:   equ    %00000010
mMEMSIZ0_ram_sw2:   equ    %00000100
mMEMSIZ0_eep_sw0:   equ    %00010000
mMEMSIZ0_eep_sw1:   equ    %00100000
mMEMSIZ0_reg_sw0:   equ    %10000000


;*** MEMSIZ1 - Memory Size Register One; 0x0000001D ***
MEMSIZ1:            equ    $0000001D                                ;*** MEMSIZ1 - Memory Size Register One; 0x0000001D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MEMSIZ1_pag_sw0:    equ    0                                         ; Allocated Off-Chip Memory Options Bit 0
MEMSIZ1_pag_sw1:    equ    1                                         ; Allocated Off-Chip Memory Options Bit 1
MEMSIZ1_rom_sw0:    equ    6                                         ; Allocated Flash EEPROM/ROM Physical Memory Space Bit 0
MEMSIZ1_rom_sw1:    equ    7                                         ; Allocated Flash EEPROM/ROM Physical Memory Space Bit 1
; bit position masks
mMEMSIZ1_pag_sw0:   equ    %00000001
mMEMSIZ1_pag_sw1:   equ    %00000010
mMEMSIZ1_rom_sw0:   equ    %01000000
mMEMSIZ1_rom_sw1:   equ    %10000000


;*** INTCR - Interrupt Control Register; 0x0000001E ***
INTCR:              equ    $0000001E                                ;*** INTCR - Interrupt Control Register; 0x0000001E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
INTCR_IRQEN:        equ    6                                         ; External IRQ Enable
INTCR_IRQE:         equ    7                                         ; IRQ Select Edge Sensitive Only
; bit position masks
mINTCR_IRQEN:       equ    %01000000
mINTCR_IRQE:        equ    %10000000


;*** HPRIO - Highest Priority I Interrupt; 0x0000001F ***
HPRIO:              equ    $0000001F                                ;*** HPRIO - Highest Priority I Interrupt; 0x0000001F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
HPRIO_PSEL1:        equ    1                                         ; Highest Priority I Interrupt Bit 1
HPRIO_PSEL2:        equ    2                                         ; Highest Priority I Interrupt Bit 2
HPRIO_PSEL3:        equ    3                                         ; Highest Priority I Interrupt Bit 3
HPRIO_PSEL4:        equ    4                                         ; Highest Priority I Interrupt Bit 4
HPRIO_PSEL5:        equ    5                                         ; Highest Priority I Interrupt Bit 5
HPRIO_PSEL6:        equ    6                                         ; Highest Priority I Interrupt Bit 6
HPRIO_PSEL7:        equ    7                                         ; Highest Priority I Interrupt Bit 7
; bit position masks
mHPRIO_PSEL1:       equ    %00000010
mHPRIO_PSEL2:       equ    %00000100
mHPRIO_PSEL3:       equ    %00001000
mHPRIO_PSEL4:       equ    %00010000
mHPRIO_PSEL5:       equ    %00100000
mHPRIO_PSEL6:       equ    %01000000
mHPRIO_PSEL7:       equ    %10000000


;*** DBGC1 - Debug Control Register 1; 0x00000020 ***
DBGC1:              equ    $00000020                                ;*** DBGC1 - Debug Control Register 1; 0x00000020 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGC1_CAPMOD0:      equ    0                                         ; Capture Mode Field, bit 0
DBGC1_CAPMOD1:      equ    1                                         ; Capture Mode Field, bit 1
DBGC1_DBGBRK:       equ    3                                         ; DBG Breakpoint Enable Bit
DBGC1_BEGIN:        equ    4                                         ; Begin/End Trigger Bit
DBGC1_TRGSEL:       equ    5                                         ; Trigger Selection Bit
DBGC1_ARM:          equ    6                                         ; Arm Bit
DBGC1_DBGEN:        equ    7                                         ; DBG Mode Enable Bit
; bit position masks
mDBGC1_CAPMOD0:     equ    %00000001
mDBGC1_CAPMOD1:     equ    %00000010
mDBGC1_DBGBRK:      equ    %00001000
mDBGC1_BEGIN:       equ    %00010000
mDBGC1_TRGSEL:      equ    %00100000
mDBGC1_ARM:         equ    %01000000
mDBGC1_DBGEN:       equ    %10000000


;*** DBGSC - Debug Status and Control Register; 0x00000021 ***
DBGSC:              equ    $00000021                                ;*** DBGSC - Debug Status and Control Register; 0x00000021 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGSC_TRG0:         equ    0                                         ; Trigger Mode Bits, bit 0
DBGSC_TRG1:         equ    1                                         ; Trigger Mode Bits, bit 1
DBGSC_TRG2:         equ    2                                         ; Trigger Mode Bits, bit 2
DBGSC_TRG3:         equ    3                                         ; Trigger Mode Bits, bit 3
DBGSC_CF:           equ    5                                         ; Comparator C Match Flag
DBGSC_BF:           equ    6                                         ; Trigger B Match Flag
DBGSC_AF:           equ    7                                         ; Trigger A Match Flag
; bit position masks
mDBGSC_TRG0:        equ    %00000001
mDBGSC_TRG1:        equ    %00000010
mDBGSC_TRG2:        equ    %00000100
mDBGSC_TRG3:        equ    %00001000
mDBGSC_CF:          equ    %00100000
mDBGSC_BF:          equ    %01000000
mDBGSC_AF:          equ    %10000000


;*** DBGTB - Debug Trace Buffer Register; 0x00000022 ***
DBGTB:              equ    $00000022                                ;*** DBGTB - Debug Trace Buffer Register; 0x00000022 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGTB_BIT0:         equ    0                                         ; Trace Buffer Data Bit 0
DBGTB_BIT1:         equ    1                                         ; Trace Buffer Data Bit 1
DBGTB_BIT2:         equ    2                                         ; Trace Buffer Data Bit 2
DBGTB_BIT3:         equ    3                                         ; Trace Buffer Data Bit 3
DBGTB_BIT4:         equ    4                                         ; Trace Buffer Data Bit 4
DBGTB_BIT5:         equ    5                                         ; Trace Buffer Data Bit 5
DBGTB_BIT6:         equ    6                                         ; Trace Buffer Data Bit 6
DBGTB_BIT7:         equ    7                                         ; Trace Buffer Data Bit 7
DBGTB_BIT8:         equ    8                                         ; Trace Buffer Data Bit 8
DBGTB_BIT9:         equ    9                                         ; Trace Buffer Data Bit 9
DBGTB_BIT10:        equ    10                                        ; Trace Buffer Data Bit 10
DBGTB_BIT11:        equ    11                                        ; Trace Buffer Data Bit 11
DBGTB_BIT12:        equ    12                                        ; Trace Buffer Data Bit 12
DBGTB_BIT13:        equ    13                                        ; Trace Buffer Data Bit 13
DBGTB_BIT14:        equ    14                                        ; Trace Buffer Data Bit 14
DBGTB_BIT15:        equ    15                                        ; Trace Buffer Data Bit 15
; bit position masks
mDBGTB_BIT0:        equ    %00000001
mDBGTB_BIT1:        equ    %00000010
mDBGTB_BIT2:        equ    %00000100
mDBGTB_BIT3:        equ    %00001000
mDBGTB_BIT4:        equ    %00010000
mDBGTB_BIT5:        equ    %00100000
mDBGTB_BIT6:        equ    %01000000
mDBGTB_BIT7:        equ    %10000000
mDBGTB_BIT8:        equ    %100000000
mDBGTB_BIT9:        equ    %1000000000
mDBGTB_BIT10:       equ    %10000000000
mDBGTB_BIT11:       equ    %100000000000
mDBGTB_BIT12:       equ    %1000000000000
mDBGTB_BIT13:       equ    %10000000000000
mDBGTB_BIT14:       equ    %100000000000000
mDBGTB_BIT15:       equ    %1000000000000000


;*** DBGTBH - Debug Trace Buffer Register High; 0x00000022 ***
DBGTBH:             equ    $00000022                                ;*** DBGTBH - Debug Trace Buffer Register High; 0x00000022 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGTBH_BIT8:        equ    0                                         ; Trace Buffer Data Bit 8
DBGTBH_BIT9:        equ    1                                         ; Trace Buffer Data Bit 9
DBGTBH_BIT10:       equ    2                                         ; Trace Buffer Data Bit 10
DBGTBH_BIT11:       equ    3                                         ; Trace Buffer Data Bit 11
DBGTBH_BIT12:       equ    4                                         ; Trace Buffer Data Bit 12
DBGTBH_BIT13:       equ    5                                         ; Trace Buffer Data Bit 13
DBGTBH_BIT14:       equ    6                                         ; Trace Buffer Data Bit 14
DBGTBH_BIT15:       equ    7                                         ; Trace Buffer Data Bit 15
; bit position masks
mDBGTBH_BIT8:       equ    %00000001
mDBGTBH_BIT9:       equ    %00000010
mDBGTBH_BIT10:      equ    %00000100
mDBGTBH_BIT11:      equ    %00001000
mDBGTBH_BIT12:      equ    %00010000
mDBGTBH_BIT13:      equ    %00100000
mDBGTBH_BIT14:      equ    %01000000
mDBGTBH_BIT15:      equ    %10000000


;*** DBGTBL - Debug Trace Buffer Register Low; 0x00000023 ***
DBGTBL:             equ    $00000023                                ;*** DBGTBL - Debug Trace Buffer Register Low; 0x00000023 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGTBL_BIT0:        equ    0                                         ; Trace Buffer Data Bit 0
DBGTBL_BIT1:        equ    1                                         ; Trace Buffer Data Bit 1
DBGTBL_BIT2:        equ    2                                         ; Trace Buffer Data Bit 2
DBGTBL_BIT3:        equ    3                                         ; Trace Buffer Data Bit 3
DBGTBL_BIT4:        equ    4                                         ; Trace Buffer Data Bit 4
DBGTBL_BIT5:        equ    5                                         ; Trace Buffer Data Bit 5
DBGTBL_BIT6:        equ    6                                         ; Trace Buffer Data Bit 6
DBGTBL_BIT7:        equ    7                                         ; Trace Buffer Data Bit 7
; bit position masks
mDBGTBL_BIT0:       equ    %00000001
mDBGTBL_BIT1:       equ    %00000010
mDBGTBL_BIT2:       equ    %00000100
mDBGTBL_BIT3:       equ    %00001000
mDBGTBL_BIT4:       equ    %00010000
mDBGTBL_BIT5:       equ    %00100000
mDBGTBL_BIT6:       equ    %01000000
mDBGTBL_BIT7:       equ    %10000000


;*** DBGCNT - Debug Count Register; 0x00000024 ***
DBGCNT:             equ    $00000024                                ;*** DBGCNT - Debug Count Register; 0x00000024 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGCNT_CNT0:        equ    0                                         ; Count Value, bit 0
DBGCNT_CNT1:        equ    1                                         ; Count Value, bit 1
DBGCNT_CNT2:        equ    2                                         ; Count Value, bit 2
DBGCNT_CNT3:        equ    3                                         ; Count Value, bit 3
DBGCNT_CNT4:        equ    4                                         ; Count Value, bit 4
DBGCNT_CNT5:        equ    5                                         ; Count Value, bit 5
DBGCNT_TBF:         equ    7                                         ; Trace Buffer Full
; bit position masks
mDBGCNT_CNT0:       equ    %00000001
mDBGCNT_CNT1:       equ    %00000010
mDBGCNT_CNT2:       equ    %00000100
mDBGCNT_CNT3:       equ    %00001000
mDBGCNT_CNT4:       equ    %00010000
mDBGCNT_CNT5:       equ    %00100000
mDBGCNT_TBF:        equ    %10000000


;*** DBGCCX - Debug Comparator C Extended Register; 0x00000025 ***
DBGCCX:             equ    $00000025                                ;*** DBGCCX - Debug Comparator C Extended Register; 0x00000025 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGCCX_EXTCMP0:     equ    0                                         ; Comparator C Extended Compare Bits, bit 0
DBGCCX_EXTCMP1:     equ    1                                         ; Comparator C Extended Compare Bits, bit 1
DBGCCX_EXTCMP2:     equ    2                                         ; Comparator C Extended Compare Bits, bit 2
DBGCCX_EXTCMP3:     equ    3                                         ; Comparator C Extended Compare Bits, bit 3
DBGCCX_EXTCMP4:     equ    4                                         ; Comparator C Extended Compare Bits, bit 4
DBGCCX_EXTCMP5:     equ    5                                         ; Comparator C Extended Compare Bits, bit 5
DBGCCX_PAGSEL0:     equ    6                                         ; Page Selector Field, bit 0
DBGCCX_PAGSEL1:     equ    7                                         ; Page Selector Field, bit 1
; bit position masks
mDBGCCX_EXTCMP0:    equ    %00000001
mDBGCCX_EXTCMP1:    equ    %00000010
mDBGCCX_EXTCMP2:    equ    %00000100
mDBGCCX_EXTCMP3:    equ    %00001000
mDBGCCX_EXTCMP4:    equ    %00010000
mDBGCCX_EXTCMP5:    equ    %00100000
mDBGCCX_PAGSEL0:    equ    %01000000
mDBGCCX_PAGSEL1:    equ    %10000000


;*** DBGCC - Debug Comparator C Register; 0x00000026 ***
DBGCC:              equ    $00000026                                ;*** DBGCC - Debug Comparator C Register; 0x00000026 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGCC_BIT0:         equ    0                                         ; Comparator C Compare Bit 0
DBGCC_BIT1:         equ    1                                         ; Comparator C Compare Bit 1
DBGCC_BIT2:         equ    2                                         ; Comparator C Compare Bit 2
DBGCC_BIT3:         equ    3                                         ; Comparator C Compare Bit 3
DBGCC_BIT4:         equ    4                                         ; Comparator C Compare Bit 4
DBGCC_BIT5:         equ    5                                         ; Comparator C Compare Bit 5
DBGCC_BIT6:         equ    6                                         ; Comparator C Compare Bit 6
DBGCC_BIT7:         equ    7                                         ; Comparator C Compare Bit 7
DBGCC_BIT8:         equ    8                                         ; Comparator C Compare Bit 8
DBGCC_BIT9:         equ    9                                         ; Comparator C Compare Bit 9
DBGCC_BIT10:        equ    10                                        ; Comparator C Compare Bit 10
DBGCC_BIT11:        equ    11                                        ; Comparator C Compare Bit 11
DBGCC_BIT12:        equ    12                                        ; Comparator C Compare Bit 12
DBGCC_BIT13:        equ    13                                        ; Comparator C Compare Bit 13
DBGCC_BIT14:        equ    14                                        ; Comparator C Compare Bit 14
DBGCC_BIT15:        equ    15                                        ; Comparator C Compare Bit 15
; bit position masks
mDBGCC_BIT0:        equ    %00000001
mDBGCC_BIT1:        equ    %00000010
mDBGCC_BIT2:        equ    %00000100
mDBGCC_BIT3:        equ    %00001000
mDBGCC_BIT4:        equ    %00010000
mDBGCC_BIT5:        equ    %00100000
mDBGCC_BIT6:        equ    %01000000
mDBGCC_BIT7:        equ    %10000000
mDBGCC_BIT8:        equ    %100000000
mDBGCC_BIT9:        equ    %1000000000
mDBGCC_BIT10:       equ    %10000000000
mDBGCC_BIT11:       equ    %100000000000
mDBGCC_BIT12:       equ    %1000000000000
mDBGCC_BIT13:       equ    %10000000000000
mDBGCC_BIT14:       equ    %100000000000000
mDBGCC_BIT15:       equ    %1000000000000000


;*** DBGCCH - Debug Comparator C Register High; 0x00000026 ***
DBGCCH:             equ    $00000026                                ;*** DBGCCH - Debug Comparator C Register High; 0x00000026 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGCCH_BIT8:        equ    0                                         ; Comparator C Compare Bit 8
DBGCCH_BIT9:        equ    1                                         ; Comparator C Compare Bit 9
DBGCCH_BIT10:       equ    2                                         ; Comparator C Compare Bit 10
DBGCCH_BIT11:       equ    3                                         ; Comparator C Compare Bit 11
DBGCCH_BIT12:       equ    4                                         ; Comparator C Compare Bit 12
DBGCCH_BIT13:       equ    5                                         ; Comparator C Compare Bit 13
DBGCCH_BIT14:       equ    6                                         ; Comparator C Compare Bit 14
DBGCCH_BIT15:       equ    7                                         ; Comparator C Compare Bit 15
; bit position masks
mDBGCCH_BIT8:       equ    %00000001
mDBGCCH_BIT9:       equ    %00000010
mDBGCCH_BIT10:      equ    %00000100
mDBGCCH_BIT11:      equ    %00001000
mDBGCCH_BIT12:      equ    %00010000
mDBGCCH_BIT13:      equ    %00100000
mDBGCCH_BIT14:      equ    %01000000
mDBGCCH_BIT15:      equ    %10000000


;*** DBGCCL - Debug Comparator C Register Low; 0x00000027 ***
DBGCCL:             equ    $00000027                                ;*** DBGCCL - Debug Comparator C Register Low; 0x00000027 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGCCL_BIT0:        equ    0                                         ; Comparator C Compare Bit 0
DBGCCL_BIT1:        equ    1                                         ; Comparator C Compare Bit 1
DBGCCL_BIT2:        equ    2                                         ; Comparator C Compare Bit 2
DBGCCL_BIT3:        equ    3                                         ; Comparator C Compare Bit 3
DBGCCL_BIT4:        equ    4                                         ; Comparator C Compare Bit 4
DBGCCL_BIT5:        equ    5                                         ; Comparator C Compare Bit 5
DBGCCL_BIT6:        equ    6                                         ; Comparator C Compare Bit 6
DBGCCL_BIT7:        equ    7                                         ; Comparator C Compare Bit 7
; bit position masks
mDBGCCL_BIT0:       equ    %00000001
mDBGCCL_BIT1:       equ    %00000010
mDBGCCL_BIT2:       equ    %00000100
mDBGCCL_BIT3:       equ    %00001000
mDBGCCL_BIT4:       equ    %00010000
mDBGCCL_BIT5:       equ    %00100000
mDBGCCL_BIT6:       equ    %01000000
mDBGCCL_BIT7:       equ    %10000000


;*** DBGC2 - Debug Control Register 2; 0x00000028 ***
DBGC2:              equ    $00000028                                ;*** DBGC2 - Debug Control Register 2; 0x00000028 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGC2_RWC:          equ    0                                         ; Read/Write Comparator C Value Bit
DBGC2_RWCEN:        equ    1                                         ; Read/Write Comparator C Enable Bit
DBGC2_TAGC:         equ    2                                         ; Comparator C Tag Select
DBGC2_BKCEN:        equ    3                                         ; Breakpoint Comparator C Enable Bit
DBGC2_TAGAB:        equ    4                                         ; Comparator A/B Tag Select
DBGC2_BDM:          equ    5                                         ; Background Debug Mode Enable
DBGC2_FULL:         equ    6                                         ; Full Breakpoint Mode Enable
DBGC2_BKABEN:       equ    7                                         ; Breakpoint Using Comparator A and B Enable
; bit position masks
mDBGC2_RWC:         equ    %00000001
mDBGC2_RWCEN:       equ    %00000010
mDBGC2_TAGC:        equ    %00000100
mDBGC2_BKCEN:       equ    %00001000
mDBGC2_TAGAB:       equ    %00010000
mDBGC2_BDM:         equ    %00100000
mDBGC2_FULL:        equ    %01000000
mDBGC2_BKABEN:      equ    %10000000


;*** DBGC3 - Debug Control Register 3; 0x00000029 ***
DBGC3:              equ    $00000029                                ;*** DBGC3 - Debug Control Register 3; 0x00000029 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGC3_RWB:          equ    0                                         ; Read/Write Comparator B Value Bit
DBGC3_RWBEN:        equ    1                                         ; Read/Write Comparator B Enable Bit
DBGC3_RWA:          equ    2                                         ; Read/Write Comparator A Value Bit
DBGC3_RWAEN:        equ    3                                         ; Read/Write Comparator A Enable Bit
DBGC3_BKBMBL:       equ    4                                         ; Breakpoint Mask Low Byte for Second Address
DBGC3_BKBMBH:       equ    5                                         ; Breakpoint Mask High Byte for Second Address
DBGC3_BKAMBL:       equ    6                                         ; Breakpoint Mask Low Byte for First Address
DBGC3_BKAMBH:       equ    7                                         ; Breakpoint Mask High Byte for First Address
; bit position masks
mDBGC3_RWB:         equ    %00000001
mDBGC3_RWBEN:       equ    %00000010
mDBGC3_RWA:         equ    %00000100
mDBGC3_RWAEN:       equ    %00001000
mDBGC3_BKBMBL:      equ    %00010000
mDBGC3_BKBMBH:      equ    %00100000
mDBGC3_BKAMBL:      equ    %01000000
mDBGC3_BKAMBH:      equ    %10000000


;*** DBGCAX - Debug Comparator A Extended Register; 0x0000002A ***
DBGCAX:             equ    $0000002A                                ;*** DBGCAX - Debug Comparator A Extended Register; 0x0000002A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGCAX_EXTCMP0:     equ    0                                         ; Comparator A Extended Compare Bits, bit 0
DBGCAX_EXTCMP1:     equ    1                                         ; Comparator A Extended Compare Bits, bit 1
DBGCAX_EXTCMP2:     equ    2                                         ; Comparator A Extended Compare Bits, bit 2
DBGCAX_EXTCMP3:     equ    3                                         ; Comparator A Extended Compare Bits, bit 3
DBGCAX_EXTCMP4:     equ    4                                         ; Comparator A Extended Compare Bits, bit 4
DBGCAX_EXTCMP5:     equ    5                                         ; Comparator A Extended Compare Bits, bit 5
DBGCAX_PAGSEL0:     equ    6                                         ; Page Selector Field, bit 0
DBGCAX_PAGSEL1:     equ    7                                         ; Page Selector Field, bit 1
; bit position masks
mDBGCAX_EXTCMP0:    equ    %00000001
mDBGCAX_EXTCMP1:    equ    %00000010
mDBGCAX_EXTCMP2:    equ    %00000100
mDBGCAX_EXTCMP3:    equ    %00001000
mDBGCAX_EXTCMP4:    equ    %00010000
mDBGCAX_EXTCMP5:    equ    %00100000
mDBGCAX_PAGSEL0:    equ    %01000000
mDBGCAX_PAGSEL1:    equ    %10000000


;*** DBGCA - Debug Comparator A Register; 0x0000002B ***
DBGCA:              equ    $0000002B                                ;*** DBGCA - Debug Comparator A Register; 0x0000002B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGCA_BIT0:         equ    0                                         ; Comparator A Compare Bit 0
DBGCA_BIT1:         equ    1                                         ; Comparator A Compare Bit 1
DBGCA_BIT2:         equ    2                                         ; Comparator A Compare Bit 2
DBGCA_BIT3:         equ    3                                         ; Comparator A Compare Bit 3
DBGCA_BIT4:         equ    4                                         ; Comparator A Compare Bit 4
DBGCA_BIT5:         equ    5                                         ; Comparator A Compare Bit 5
DBGCA_BIT6:         equ    6                                         ; Comparator A Compare Bit 6
DBGCA_BIT7:         equ    7                                         ; Comparator A Compare Bit 7
DBGCA_BIT8:         equ    8                                         ; Comparator A Compare Bit 8
DBGCA_BIT9:         equ    9                                         ; Comparator A Compare Bit 9
DBGCA_BIT10:        equ    10                                        ; Comparator A Compare Bit 10
DBGCA_BIT11:        equ    11                                        ; Comparator A Compare Bit 11
DBGCA_BIT12:        equ    12                                        ; Comparator A Compare Bit 12
DBGCA_BIT13:        equ    13                                        ; Comparator A Compare Bit 13
DBGCA_BIT14:        equ    14                                        ; Comparator A Compare Bit 14
DBGCA_BIT15:        equ    15                                        ; Comparator A Compare Bit 15
; bit position masks
mDBGCA_BIT0:        equ    %00000001
mDBGCA_BIT1:        equ    %00000010
mDBGCA_BIT2:        equ    %00000100
mDBGCA_BIT3:        equ    %00001000
mDBGCA_BIT4:        equ    %00010000
mDBGCA_BIT5:        equ    %00100000
mDBGCA_BIT6:        equ    %01000000
mDBGCA_BIT7:        equ    %10000000
mDBGCA_BIT8:        equ    %100000000
mDBGCA_BIT9:        equ    %1000000000
mDBGCA_BIT10:       equ    %10000000000
mDBGCA_BIT11:       equ    %100000000000
mDBGCA_BIT12:       equ    %1000000000000
mDBGCA_BIT13:       equ    %10000000000000
mDBGCA_BIT14:       equ    %100000000000000
mDBGCA_BIT15:       equ    %1000000000000000


;*** DBGCAH - Debug Comparator A Register High; 0x0000002B ***
DBGCAH:             equ    $0000002B                                ;*** DBGCAH - Debug Comparator A Register High; 0x0000002B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGCAH_BIT8:        equ    0                                         ; Comparator A Compare Bit 8
DBGCAH_BIT9:        equ    1                                         ; Comparator A Compare Bit 9
DBGCAH_BIT10:       equ    2                                         ; Comparator A Compare Bit 10
DBGCAH_BIT11:       equ    3                                         ; Comparator A Compare Bit 11
DBGCAH_BIT12:       equ    4                                         ; Comparator A Compare Bit 12
DBGCAH_BIT13:       equ    5                                         ; Comparator A Compare Bit 13
DBGCAH_BIT14:       equ    6                                         ; Comparator A Compare Bit 14
DBGCAH_BIT15:       equ    7                                         ; Comparator A Compare Bit 15
; bit position masks
mDBGCAH_BIT8:       equ    %00000001
mDBGCAH_BIT9:       equ    %00000010
mDBGCAH_BIT10:      equ    %00000100
mDBGCAH_BIT11:      equ    %00001000
mDBGCAH_BIT12:      equ    %00010000
mDBGCAH_BIT13:      equ    %00100000
mDBGCAH_BIT14:      equ    %01000000
mDBGCAH_BIT15:      equ    %10000000


;*** DBGCAL - Debug Comparator A Register Low; 0x0000002C ***
DBGCAL:             equ    $0000002C                                ;*** DBGCAL - Debug Comparator A Register Low; 0x0000002C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGCAL_BIT0:        equ    0                                         ; Comparator A Compare Bit 0
DBGCAL_BIT1:        equ    1                                         ; Comparator A Compare Bit 1
DBGCAL_BIT2:        equ    2                                         ; Comparator A Compare Bit 2
DBGCAL_BIT3:        equ    3                                         ; Comparator A Compare Bit 3
DBGCAL_BIT4:        equ    4                                         ; Comparator A Compare Bit 4
DBGCAL_BIT5:        equ    5                                         ; Comparator A Compare Bit 5
DBGCAL_BIT6:        equ    6                                         ; Comparator A Compare Bit 6
DBGCAL_BIT7:        equ    7                                         ; Comparator A Compare Bit 7
; bit position masks
mDBGCAL_BIT0:       equ    %00000001
mDBGCAL_BIT1:       equ    %00000010
mDBGCAL_BIT2:       equ    %00000100
mDBGCAL_BIT3:       equ    %00001000
mDBGCAL_BIT4:       equ    %00010000
mDBGCAL_BIT5:       equ    %00100000
mDBGCAL_BIT6:       equ    %01000000
mDBGCAL_BIT7:       equ    %10000000


;*** DBGCBX - Debug Comparator B Extended Register; 0x0000002D ***
DBGCBX:             equ    $0000002D                                ;*** DBGCBX - Debug Comparator B Extended Register; 0x0000002D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGCBX_EXTCMP0:     equ    0                                         ; Comparator B Extended Compare Bits, bit 0
DBGCBX_EXTCMP1:     equ    1                                         ; Comparator B Extended Compare Bits, bit 1
DBGCBX_EXTCMP2:     equ    2                                         ; Comparator B Extended Compare Bits, bit 2
DBGCBX_EXTCMP3:     equ    3                                         ; Comparator B Extended Compare Bits, bit 3
DBGCBX_EXTCMP4:     equ    4                                         ; Comparator B Extended Compare Bits, bit 4
DBGCBX_EXTCMP5:     equ    5                                         ; Comparator B Extended Compare Bits, bit 5
DBGCBX_PAGSEL0:     equ    6                                         ; Page Selector Field, bit 0
DBGCBX_PAGSEL1:     equ    7                                         ; Page Selector Field, bit 1
; bit position masks
mDBGCBX_EXTCMP0:    equ    %00000001
mDBGCBX_EXTCMP1:    equ    %00000010
mDBGCBX_EXTCMP2:    equ    %00000100
mDBGCBX_EXTCMP3:    equ    %00001000
mDBGCBX_EXTCMP4:    equ    %00010000
mDBGCBX_EXTCMP5:    equ    %00100000
mDBGCBX_PAGSEL0:    equ    %01000000
mDBGCBX_PAGSEL1:    equ    %10000000


;*** DBGCB - Debug Comparator B Register; 0x0000002E ***
DBGCB:              equ    $0000002E                                ;*** DBGCB - Debug Comparator B Register; 0x0000002E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGCB_BIT0:         equ    0                                         ; Comparator B High Compare Bit 0
DBGCB_BIT1:         equ    1                                         ; Comparator B High Compare Bit 1
DBGCB_BIT2:         equ    2                                         ; Comparator B High Compare Bit 2
DBGCB_BIT3:         equ    3                                         ; Comparator B High Compare Bit 3
DBGCB_BIT4:         equ    4                                         ; Comparator B High Compare Bit 4
DBGCB_BIT5:         equ    5                                         ; Comparator B High Compare Bit 5
DBGCB_BIT6:         equ    6                                         ; Comparator B High Compare Bit 6
DBGCB_BIT7:         equ    7                                         ; Comparator B High Compare Bit 7
DBGCB_BIT8:         equ    8                                         ; Comparator B High Compare Bit 8
DBGCB_BIT9:         equ    9                                         ; Comparator B High Compare Bit 9
DBGCB_BIT10:        equ    10                                        ; Comparator B High Compare Bit 10
DBGCB_BIT11:        equ    11                                        ; Comparator B High Compare Bit 11
DBGCB_BIT12:        equ    12                                        ; Comparator B High Compare Bit 12
DBGCB_BIT13:        equ    13                                        ; Comparator B High Compare Bit 13
DBGCB_BIT14:        equ    14                                        ; Comparator B High Compare Bit 14
DBGCB_BIT15:        equ    15                                        ; Comparator B High Compare Bit 15
; bit position masks
mDBGCB_BIT0:        equ    %00000001
mDBGCB_BIT1:        equ    %00000010
mDBGCB_BIT2:        equ    %00000100
mDBGCB_BIT3:        equ    %00001000
mDBGCB_BIT4:        equ    %00010000
mDBGCB_BIT5:        equ    %00100000
mDBGCB_BIT6:        equ    %01000000
mDBGCB_BIT7:        equ    %10000000
mDBGCB_BIT8:        equ    %100000000
mDBGCB_BIT9:        equ    %1000000000
mDBGCB_BIT10:       equ    %10000000000
mDBGCB_BIT11:       equ    %100000000000
mDBGCB_BIT12:       equ    %1000000000000
mDBGCB_BIT13:       equ    %10000000000000
mDBGCB_BIT14:       equ    %100000000000000
mDBGCB_BIT15:       equ    %1000000000000000


;*** DBGCBH - Debug Comparator B Register High; 0x0000002E ***
DBGCBH:             equ    $0000002E                                ;*** DBGCBH - Debug Comparator B Register High; 0x0000002E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGCBH_BIT8:        equ    0                                         ; Comparator B High Compare Bit 8
DBGCBH_BIT9:        equ    1                                         ; Comparator B High Compare Bit 9
DBGCBH_BIT10:       equ    2                                         ; Comparator B High Compare Bit 10
DBGCBH_BIT11:       equ    3                                         ; Comparator B High Compare Bit 11
DBGCBH_BIT12:       equ    4                                         ; Comparator B High Compare Bit 12
DBGCBH_BIT13:       equ    5                                         ; Comparator B High Compare Bit 13
DBGCBH_BIT14:       equ    6                                         ; Comparator B High Compare Bit 14
DBGCBH_BIT15:       equ    7                                         ; Comparator B High Compare Bit 15
; bit position masks
mDBGCBH_BIT8:       equ    %00000001
mDBGCBH_BIT9:       equ    %00000010
mDBGCBH_BIT10:      equ    %00000100
mDBGCBH_BIT11:      equ    %00001000
mDBGCBH_BIT12:      equ    %00010000
mDBGCBH_BIT13:      equ    %00100000
mDBGCBH_BIT14:      equ    %01000000
mDBGCBH_BIT15:      equ    %10000000


;*** DBGCBL - Debug Comparator B Register Low; 0x0000002F ***
DBGCBL:             equ    $0000002F                                ;*** DBGCBL - Debug Comparator B Register Low; 0x0000002F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGCBL_BIT0:        equ    0                                         ; Comparator B High Compare Bit 0
DBGCBL_BIT1:        equ    1                                         ; Comparator B High Compare Bit 1
DBGCBL_BIT2:        equ    2                                         ; Comparator B High Compare Bit 2
DBGCBL_BIT3:        equ    3                                         ; Comparator B High Compare Bit 3
DBGCBL_BIT4:        equ    4                                         ; Comparator B High Compare Bit 4
DBGCBL_BIT5:        equ    5                                         ; Comparator B High Compare Bit 5
DBGCBL_BIT6:        equ    6                                         ; Comparator B High Compare Bit 6
DBGCBL_BIT7:        equ    7                                         ; Comparator B High Compare Bit 7
; bit position masks
mDBGCBL_BIT0:       equ    %00000001
mDBGCBL_BIT1:       equ    %00000010
mDBGCBL_BIT2:       equ    %00000100
mDBGCBL_BIT3:       equ    %00001000
mDBGCBL_BIT4:       equ    %00010000
mDBGCBL_BIT5:       equ    %00100000
mDBGCBL_BIT6:       equ    %01000000
mDBGCBL_BIT7:       equ    %10000000


;*** PPAGE - Page Index Register; 0x00000030 ***
PPAGE:              equ    $00000030                                ;*** PPAGE - Page Index Register; 0x00000030 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PPAGE_PIX0:         equ    0                                         ; Page Index Register Bit 0
PPAGE_PIX1:         equ    1                                         ; Page Index Register Bit 1
PPAGE_PIX2:         equ    2                                         ; Page Index Register Bit 2
PPAGE_PIX3:         equ    3                                         ; Page Index Register Bit 3
PPAGE_PIX4:         equ    4                                         ; Page Index Register Bit 4
PPAGE_PIX5:         equ    5                                         ; Page Index Register Bit 5
; bit position masks
mPPAGE_PIX0:        equ    %00000001
mPPAGE_PIX1:        equ    %00000010
mPPAGE_PIX2:        equ    %00000100
mPPAGE_PIX3:        equ    %00001000
mPPAGE_PIX4:        equ    %00010000
mPPAGE_PIX5:        equ    %00100000


;*** PORTK - Port K Data Register; 0x00000032 ***
PORTK:              equ    $00000032                                ;*** PORTK - Port K Data Register; 0x00000032 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PORTK_BIT0:         equ    0                                         ; Port K Bit 0
PORTK_BIT1:         equ    1                                         ; Port K Bit 1
PORTK_BIT2:         equ    2                                         ; Port K Bit 2
PORTK_BIT3:         equ    3                                         ; Port K Bit 3
PORTK_BIT4:         equ    4                                         ; Port K Bit 4
PORTK_BIT5:         equ    5                                         ; Port K Bit 5
PORTK_BIT7:         equ    7                                         ; Port K Bit 7
; bit position masks
mPORTK_BIT0:        equ    %00000001
mPORTK_BIT1:        equ    %00000010
mPORTK_BIT2:        equ    %00000100
mPORTK_BIT3:        equ    %00001000
mPORTK_BIT4:        equ    %00010000
mPORTK_BIT5:        equ    %00100000
mPORTK_BIT7:        equ    %10000000


;*** DDRK - Port K Data Direction Register; 0x00000033 ***
DDRK:               equ    $00000033                                ;*** DDRK - Port K Data Direction Register; 0x00000033 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRK_BIT0:          equ    0                                         ; Port K Data Direction Bit 0
DDRK_BIT1:          equ    1                                         ; Port K Data Direction Bit 1
DDRK_BIT2:          equ    2                                         ; Port K Data Direction Bit 2
DDRK_BIT3:          equ    3                                         ; Port K Data Direction Bit 3
DDRK_BIT4:          equ    4                                         ; Port K Data Direction Bit 4
DDRK_BIT5:          equ    5                                         ; Port K Data Direction Bit 5
DDRK_BIT7:          equ    7                                         ; Port K Data Direction Bit 7
; bit position masks
mDDRK_BIT0:         equ    %00000001
mDDRK_BIT1:         equ    %00000010
mDDRK_BIT2:         equ    %00000100
mDDRK_BIT3:         equ    %00001000
mDDRK_BIT4:         equ    %00010000
mDDRK_BIT5:         equ    %00100000
mDDRK_BIT7:         equ    %10000000


;*** SYNR - CRG Synthesizer Register; 0x00000034 ***
SYNR:               equ    $00000034                                ;*** SYNR - CRG Synthesizer Register; 0x00000034 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SYNR_SYN0:          equ    0                                         ; CRG Synthesizer Bit 0
SYNR_SYN1:          equ    1                                         ; CRG Synthesizer Bit 1
SYNR_SYN2:          equ    2                                         ; CRG Synthesizer Bit 2
SYNR_SYN3:          equ    3                                         ; CRG Synthesizer Bit 3
SYNR_SYN4:          equ    4                                         ; CRG Synthesizer Bit 4
SYNR_SYN5:          equ    5                                         ; CRG Synthesizer Bit 5
; bit position masks
mSYNR_SYN0:         equ    %00000001
mSYNR_SYN1:         equ    %00000010
mSYNR_SYN2:         equ    %00000100
mSYNR_SYN3:         equ    %00001000
mSYNR_SYN4:         equ    %00010000
mSYNR_SYN5:         equ    %00100000


;*** REFDV - CRG Reference Divider Register; 0x00000035 ***
REFDV:              equ    $00000035                                ;*** REFDV - CRG Reference Divider Register; 0x00000035 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
REFDV_REFDV0:       equ    0                                         ; CRG Reference Divider Bit 0
REFDV_REFDV1:       equ    1                                         ; CRG Reference Divider Bit 1
REFDV_REFDV2:       equ    2                                         ; CRG Reference Divider Bit 2
REFDV_REFDV3:       equ    3                                         ; CRG Reference Divider Bit 3
; bit position masks
mREFDV_REFDV0:      equ    %00000001
mREFDV_REFDV1:      equ    %00000010
mREFDV_REFDV2:      equ    %00000100
mREFDV_REFDV3:      equ    %00001000


;*** CRGFLG - CRG Flags Register; 0x00000037 ***
CRGFLG:             equ    $00000037                                ;*** CRGFLG - CRG Flags Register; 0x00000037 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CRGFLG_SCM:         equ    0                                         ; Self-clock mode Status
CRGFLG_SCMIF:       equ    1                                         ; Self-clock mode Interrupt Flag
CRGFLG_TRACK:       equ    2                                         ; Track Status
CRGFLG_LOCK:        equ    3                                         ; Lock Status
CRGFLG_LOCKIF:      equ    4                                         ; PLL Lock Interrupt Flag
CRGFLG_LVRF:        equ    5                                         ; Low Voltage Reset Flag
CRGFLG_PORF:        equ    6                                         ; Power on Reset Flag
CRGFLG_RTIF:        equ    7                                         ; Real Time Interrupt Flag
; bit position masks
mCRGFLG_SCM:        equ    %00000001
mCRGFLG_SCMIF:      equ    %00000010
mCRGFLG_TRACK:      equ    %00000100
mCRGFLG_LOCK:       equ    %00001000
mCRGFLG_LOCKIF:     equ    %00010000
mCRGFLG_LVRF:       equ    %00100000
mCRGFLG_PORF:       equ    %01000000
mCRGFLG_RTIF:       equ    %10000000


;*** CRGINT - CRG Interrupt Enable Register; 0x00000038 ***
CRGINT:             equ    $00000038                                ;*** CRGINT - CRG Interrupt Enable Register; 0x00000038 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CRGINT_SCMIE:       equ    1                                         ; Self-clock mode Interrupt Enable
CRGINT_LOCKIE:      equ    4                                         ; Lock Interrupt Enable
CRGINT_RTIE:        equ    7                                         ; Real Time Interrupt Enable
; bit position masks
mCRGINT_SCMIE:      equ    %00000010
mCRGINT_LOCKIE:     equ    %00010000
mCRGINT_RTIE:       equ    %10000000


;*** CLKSEL - CRG Clock Select Register; 0x00000039 ***
CLKSEL:             equ    $00000039                                ;*** CLKSEL - CRG Clock Select Register; 0x00000039 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CLKSEL_COPWAI:      equ    0                                         ; COP stops in WAIT mode
CLKSEL_RTIWAI:      equ    1                                         ; RTI stops in WAIT mode
CLKSEL_CWAI:        equ    2                                         ; CLK24 and CLK23 stop in WAIT mode
CLKSEL_PLLWAI:      equ    3                                         ; PLL stops in WAIT mode
CLKSEL_ROAWAI:      equ    4                                         ; Reduced Oscillator Amplitude in WAIT mode
CLKSEL_SYSWAI:      equ    5                                         ; System clocks stop in WAIT mode
CLKSEL_PSTP:        equ    6                                         ; Pseudo Stop
CLKSEL_PLLSEL:      equ    7                                         ; PLL selected for system clock
; bit position masks
mCLKSEL_COPWAI:     equ    %00000001
mCLKSEL_RTIWAI:     equ    %00000010
mCLKSEL_CWAI:       equ    %00000100
mCLKSEL_PLLWAI:     equ    %00001000
mCLKSEL_ROAWAI:     equ    %00010000
mCLKSEL_SYSWAI:     equ    %00100000
mCLKSEL_PSTP:       equ    %01000000
mCLKSEL_PLLSEL:     equ    %10000000


;*** PLLCTL - CRG PLL Control Register; 0x0000003A ***
PLLCTL:             equ    $0000003A                                ;*** PLLCTL - CRG PLL Control Register; 0x0000003A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PLLCTL_SCME:        equ    0                                         ; Self-clock mode enable
PLLCTL_PCE:         equ    1                                         ; COP Enable during Pseudo Stop Bit
PLLCTL_PRE:         equ    2                                         ; RTI Enable during Pseudo Stop Bit
PLLCTL_ACQ:         equ    4                                         ; Acquisition
PLLCTL_AUTO:        equ    5                                         ; Automatic Bandwidth Control
PLLCTL_PLLON:       equ    6                                         ; Phase Lock Loop On
PLLCTL_CME:         equ    7                                         ; Clock Monitor Enable
; bit position masks
mPLLCTL_SCME:       equ    %00000001
mPLLCTL_PCE:        equ    %00000010
mPLLCTL_PRE:        equ    %00000100
mPLLCTL_ACQ:        equ    %00010000
mPLLCTL_AUTO:       equ    %00100000
mPLLCTL_PLLON:      equ    %01000000
mPLLCTL_CME:        equ    %10000000


;*** RTICTL - CRG RTI Control Register; 0x0000003B ***
RTICTL:             equ    $0000003B                                ;*** RTICTL - CRG RTI Control Register; 0x0000003B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RTICTL_RTR0:        equ    0                                         ; Real Time Interrupt Modulus Counter Select Bit 0
RTICTL_RTR1:        equ    1                                         ; Real Time Interrupt Modulus Counter Select Bit 1
RTICTL_RTR2:        equ    2                                         ; Real Time Interrupt Modulus Counter Select Bit 2
RTICTL_RTR3:        equ    3                                         ; Real Time Interrupt Modulus Counter Select Bit 3
RTICTL_RTR4:        equ    4                                         ; Real Time Interrupt Prescale Rate Select Bit 4
RTICTL_RTR5:        equ    5                                         ; Real Time Interrupt Prescale Rate Select Bit 5
RTICTL_RTR6:        equ    6                                         ; Real Time Interrupt Prescale Rate Select Bit 6
; bit position masks
mRTICTL_RTR0:       equ    %00000001
mRTICTL_RTR1:       equ    %00000010
mRTICTL_RTR2:       equ    %00000100
mRTICTL_RTR3:       equ    %00001000
mRTICTL_RTR4:       equ    %00010000
mRTICTL_RTR5:       equ    %00100000
mRTICTL_RTR6:       equ    %01000000


;*** COPCTL - CRG COP Control Register; 0x0000003C ***
COPCTL:             equ    $0000003C                                ;*** COPCTL - CRG COP Control Register; 0x0000003C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
COPCTL_CR0:         equ    0                                         ; COP Watchdog Timer Rate select Bit 0
COPCTL_CR1:         equ    1                                         ; COP Watchdog Timer Rate select Bit 1
COPCTL_CR2:         equ    2                                         ; COP Watchdog Timer Rate select Bit 2
COPCTL_RSBCK:       equ    6                                         ; COP and RTI stop in Active BDM mode Bit
COPCTL_WCOP:        equ    7                                         ; Window COP mode
; bit position masks
mCOPCTL_CR0:        equ    %00000001
mCOPCTL_CR1:        equ    %00000010
mCOPCTL_CR2:        equ    %00000100
mCOPCTL_RSBCK:      equ    %01000000
mCOPCTL_WCOP:       equ    %10000000


;*** ARMCOP - CRG COP Timer Arm/Reset Register; 0x0000003F ***
ARMCOP:             equ    $0000003F                                ;*** ARMCOP - CRG COP Timer Arm/Reset Register; 0x0000003F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ARMCOP_BIT0:        equ    0                                         ; CRG COP Timer Arm/Reset Bit 0
ARMCOP_BIT1:        equ    1                                         ; CRG COP Timer Arm/Reset Bit 1
ARMCOP_BIT2:        equ    2                                         ; CRG COP Timer Arm/Reset Bit 2
ARMCOP_BIT3:        equ    3                                         ; CRG COP Timer Arm/Reset Bit 3
ARMCOP_BIT4:        equ    4                                         ; CRG COP Timer Arm/Reset Bit 4
ARMCOP_BIT5:        equ    5                                         ; CRG COP Timer Arm/Reset Bit 5
ARMCOP_BIT6:        equ    6                                         ; CRG COP Timer Arm/Reset Bit 6
ARMCOP_BIT7:        equ    7                                         ; CRG COP Timer Arm/Reset Bit 7
; bit position masks
mARMCOP_BIT0:       equ    %00000001
mARMCOP_BIT1:       equ    %00000010
mARMCOP_BIT2:       equ    %00000100
mARMCOP_BIT3:       equ    %00001000
mARMCOP_BIT4:       equ    %00010000
mARMCOP_BIT5:       equ    %00100000
mARMCOP_BIT6:       equ    %01000000
mARMCOP_BIT7:       equ    %10000000


;*** TIOS - Timer Input Capture/Output Compare Select; 0x00000040 ***
TIOS:               equ    $00000040                                ;*** TIOS - Timer Input Capture/Output Compare Select; 0x00000040 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TIOS_IOS0:          equ    0                                         ; Input Capture or Output Compare Channel Configuration Bit 0
TIOS_IOS1:          equ    1                                         ; Input Capture or Output Compare Channel Configuration Bit 1
TIOS_IOS2:          equ    2                                         ; Input Capture or Output Compare Channel Configuration Bit 2
TIOS_IOS3:          equ    3                                         ; Input Capture or Output Compare Channel Configuration Bit 3
TIOS_IOS4:          equ    4                                         ; Input Capture or Output Compare Channel Configuration Bit 4
TIOS_IOS5:          equ    5                                         ; Input Capture or Output Compare Channel Configuration Bit 5
TIOS_IOS6:          equ    6                                         ; Input Capture or Output Compare Channel Configuration Bit 6
TIOS_IOS7:          equ    7                                         ; Input Capture or Output Compare Channel Configuration Bit 7
; bit position masks
mTIOS_IOS0:         equ    %00000001
mTIOS_IOS1:         equ    %00000010
mTIOS_IOS2:         equ    %00000100
mTIOS_IOS3:         equ    %00001000
mTIOS_IOS4:         equ    %00010000
mTIOS_IOS5:         equ    %00100000
mTIOS_IOS6:         equ    %01000000
mTIOS_IOS7:         equ    %10000000


;*** CFORC - Timer Compare Force Register; 0x00000041 ***
CFORC:              equ    $00000041                                ;*** CFORC - Timer Compare Force Register; 0x00000041 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CFORC_FOC0:         equ    0                                         ; Force Output Compare Action for Channel 0
CFORC_FOC1:         equ    1                                         ; Force Output Compare Action for Channel 1
CFORC_FOC2:         equ    2                                         ; Force Output Compare Action for Channel 2
CFORC_FOC3:         equ    3                                         ; Force Output Compare Action for Channel 3
CFORC_FOC4:         equ    4                                         ; Force Output Compare Action for Channel 4
CFORC_FOC5:         equ    5                                         ; Force Output Compare Action for Channel 5
CFORC_FOC6:         equ    6                                         ; Force Output Compare Action for Channel 6
CFORC_FOC7:         equ    7                                         ; Force Output Compare Action for Channel 7
; bit position masks
mCFORC_FOC0:        equ    %00000001
mCFORC_FOC1:        equ    %00000010
mCFORC_FOC2:        equ    %00000100
mCFORC_FOC3:        equ    %00001000
mCFORC_FOC4:        equ    %00010000
mCFORC_FOC5:        equ    %00100000
mCFORC_FOC6:        equ    %01000000
mCFORC_FOC7:        equ    %10000000


;*** OC7M - Output Compare 7 Mask Register; 0x00000042 ***
OC7M:               equ    $00000042                                ;*** OC7M - Output Compare 7 Mask Register; 0x00000042 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
OC7M_OC7M0:         equ    0                                         ; Output Compare 7 Mask Bit 0
OC7M_OC7M1:         equ    1                                         ; Output Compare 7 Mask Bit 1
OC7M_OC7M2:         equ    2                                         ; Output Compare 7 Mask Bit 2
OC7M_OC7M3:         equ    3                                         ; Output Compare 7 Mask Bit 3
OC7M_OC7M4:         equ    4                                         ; Output Compare 7 Mask Bit 4
OC7M_OC7M5:         equ    5                                         ; Output Compare 7 Mask Bit 5
OC7M_OC7M6:         equ    6                                         ; Output Compare 7 Mask Bit 6
OC7M_OC7M7:         equ    7                                         ; Output Compare 7 Mask Bit 7
; bit position masks
mOC7M_OC7M0:        equ    %00000001
mOC7M_OC7M1:        equ    %00000010
mOC7M_OC7M2:        equ    %00000100
mOC7M_OC7M3:        equ    %00001000
mOC7M_OC7M4:        equ    %00010000
mOC7M_OC7M5:        equ    %00100000
mOC7M_OC7M6:        equ    %01000000
mOC7M_OC7M7:        equ    %10000000


;*** OC7D - Output Compare 7 Data Register; 0x00000043 ***
OC7D:               equ    $00000043                                ;*** OC7D - Output Compare 7 Data Register; 0x00000043 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
OC7D_OC7D0:         equ    0                                         ; Output Compare 7 Bit 0
OC7D_OC7D1:         equ    1                                         ; Output Compare 7 Bit 1
OC7D_OC7D2:         equ    2                                         ; Output Compare 7 Bit 2
OC7D_OC7D3:         equ    3                                         ; Output Compare 7 Bit 3
OC7D_OC7D4:         equ    4                                         ; Output Compare 7 Bit 4
OC7D_OC7D5:         equ    5                                         ; Output Compare 7 Bit 5
OC7D_OC7D6:         equ    6                                         ; Output Compare 7 Bit 6
OC7D_OC7D7:         equ    7                                         ; Output Compare 7 Bit 7
; bit position masks
mOC7D_OC7D0:        equ    %00000001
mOC7D_OC7D1:        equ    %00000010
mOC7D_OC7D2:        equ    %00000100
mOC7D_OC7D3:        equ    %00001000
mOC7D_OC7D4:        equ    %00010000
mOC7D_OC7D5:        equ    %00100000
mOC7D_OC7D6:        equ    %01000000
mOC7D_OC7D7:        equ    %10000000


;*** TCNT - Timer Count Register; 0x00000044 ***
TCNT:               equ    $00000044                                ;*** TCNT - Timer Count Register; 0x00000044 ***


;*** TCNTHi - Timer Count Register High; 0x00000044 ***
TCNTHi:             equ    $00000044                                ;*** TCNTHi - Timer Count Register High; 0x00000044 ***


;*** TCNTLo - Timer Count Register Low; 0x00000045 ***
TCNTLo:             equ    $00000045                                ;*** TCNTLo - Timer Count Register Low; 0x00000045 ***


;*** TSCR1 - Timer System Control Register1; 0x00000046 ***
TSCR1:              equ    $00000046                                ;*** TSCR1 - Timer System Control Register1; 0x00000046 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TSCR1_TFFCA:        equ    4                                         ; Timer Fast Flag Clear All
TSCR1_TSFRZ:        equ    5                                         ; Timer and Modulus Counter Stop While in Freeze Mode
TSCR1_TSWAI:        equ    6                                         ; Timer Module Stops While in Wait
TSCR1_TEN:          equ    7                                         ; Timer Enable
; bit position masks
mTSCR1_TFFCA:       equ    %00010000
mTSCR1_TSFRZ:       equ    %00100000
mTSCR1_TSWAI:       equ    %01000000
mTSCR1_TEN:         equ    %10000000


;*** TTOV - Timer Toggle On Overflow Register; 0x00000047 ***
TTOV:               equ    $00000047                                ;*** TTOV - Timer Toggle On Overflow Register; 0x00000047 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TTOV_TOV0:          equ    0                                         ; Toggle On Overflow Bit 0
TTOV_TOV1:          equ    1                                         ; Toggle On Overflow Bit 1
TTOV_TOV2:          equ    2                                         ; Toggle On Overflow Bit 2
TTOV_TOV3:          equ    3                                         ; Toggle On Overflow Bit 3
TTOV_TOV4:          equ    4                                         ; Toggle On Overflow Bit 4
TTOV_TOV5:          equ    5                                         ; Toggle On Overflow Bit 5
TTOV_TOV6:          equ    6                                         ; Toggle On Overflow Bit 6
TTOV_TOV7:          equ    7                                         ; Toggle On Overflow Bit 7
; bit position masks
mTTOV_TOV0:         equ    %00000001
mTTOV_TOV1:         equ    %00000010
mTTOV_TOV2:         equ    %00000100
mTTOV_TOV3:         equ    %00001000
mTTOV_TOV4:         equ    %00010000
mTTOV_TOV5:         equ    %00100000
mTTOV_TOV6:         equ    %01000000
mTTOV_TOV7:         equ    %10000000


;*** TCTL1 - Timer Control Register 1; 0x00000048 ***
TCTL1:              equ    $00000048                                ;*** TCTL1 - Timer Control Register 1; 0x00000048 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TCTL1_OL4:          equ    0                                         ; Output Level Bit 4
TCTL1_OM4:          equ    1                                         ; Output Mode Bit 4
TCTL1_OL5:          equ    2                                         ; Output Level Bit 5
TCTL1_OM5:          equ    3                                         ; Output Mode Bit 5
TCTL1_OL6:          equ    4                                         ; Output Level Bit 6
TCTL1_OM6:          equ    5                                         ; Output Mode Bit 6
TCTL1_OL7:          equ    6                                         ; Output Level Bit 7
TCTL1_OM7:          equ    7                                         ; Output Mode Bit 7
; bit position masks
mTCTL1_OL4:         equ    %00000001
mTCTL1_OM4:         equ    %00000010
mTCTL1_OL5:         equ    %00000100
mTCTL1_OM5:         equ    %00001000
mTCTL1_OL6:         equ    %00010000
mTCTL1_OM6:         equ    %00100000
mTCTL1_OL7:         equ    %01000000
mTCTL1_OM7:         equ    %10000000


;*** TCTL2 - Timer Control Register 2; 0x00000049 ***
TCTL2:              equ    $00000049                                ;*** TCTL2 - Timer Control Register 2; 0x00000049 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TCTL2_OL0:          equ    0                                         ; Output Level Bit 0
TCTL2_OM0:          equ    1                                         ; Output Mode Bit 0
TCTL2_OL1:          equ    2                                         ; Output Level Bit 1
TCTL2_OM1:          equ    3                                         ; Output Mode Bit 1
TCTL2_OL2:          equ    4                                         ; Output Level Bit 2
TCTL2_OM2:          equ    5                                         ; Output Mode Bit 2
TCTL2_OL3:          equ    6                                         ; Output Level Bit 3
TCTL2_OM3:          equ    7                                         ; Output Mode Bit 3
; bit position masks
mTCTL2_OL0:         equ    %00000001
mTCTL2_OM0:         equ    %00000010
mTCTL2_OL1:         equ    %00000100
mTCTL2_OM1:         equ    %00001000
mTCTL2_OL2:         equ    %00010000
mTCTL2_OM2:         equ    %00100000
mTCTL2_OL3:         equ    %01000000
mTCTL2_OM3:         equ    %10000000


;*** TCTL3 - Timer Control Register 3; 0x0000004A ***
TCTL3:              equ    $0000004A                                ;*** TCTL3 - Timer Control Register 3; 0x0000004A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TCTL3_EDG4A:        equ    0                                         ; Input Capture Edge Control 4A
TCTL3_EDG4B:        equ    1                                         ; Input Capture Edge Control 4B
TCTL3_EDG5A:        equ    2                                         ; Input Capture Edge Control 5A
TCTL3_EDG5B:        equ    3                                         ; Input Capture Edge Control 5B
TCTL3_EDG6A:        equ    4                                         ; Input Capture Edge Control 6A
TCTL3_EDG6B:        equ    5                                         ; Input Capture Edge Control 6B
TCTL3_EDG7A:        equ    6                                         ; Input Capture Edge Control 7A
TCTL3_EDG7B:        equ    7                                         ; Input Capture Edge Control 7B
; bit position masks
mTCTL3_EDG4A:       equ    %00000001
mTCTL3_EDG4B:       equ    %00000010
mTCTL3_EDG5A:       equ    %00000100
mTCTL3_EDG5B:       equ    %00001000
mTCTL3_EDG6A:       equ    %00010000
mTCTL3_EDG6B:       equ    %00100000
mTCTL3_EDG7A:       equ    %01000000
mTCTL3_EDG7B:       equ    %10000000


;*** TCTL4 - Timer Control Register 4; 0x0000004B ***
TCTL4:              equ    $0000004B                                ;*** TCTL4 - Timer Control Register 4; 0x0000004B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TCTL4_EDG0A:        equ    0                                         ; Input Capture Edge Control 0A
TCTL4_EDG0B:        equ    1                                         ; Input Capture Edge Control 0B
TCTL4_EDG1A:        equ    2                                         ; Input Capture Edge Control 1A
TCTL4_EDG1B:        equ    3                                         ; Input Capture Edge Control 1B
TCTL4_EDG2A:        equ    4                                         ; Input Capture Edge Control 2A
TCTL4_EDG2B:        equ    5                                         ; Input Capture Edge Control 2B
TCTL4_EDG3A:        equ    6                                         ; Input Capture Edge Control 3A
TCTL4_EDG3B:        equ    7                                         ; Input Capture Edge Control 3B
; bit position masks
mTCTL4_EDG0A:       equ    %00000001
mTCTL4_EDG0B:       equ    %00000010
mTCTL4_EDG1A:       equ    %00000100
mTCTL4_EDG1B:       equ    %00001000
mTCTL4_EDG2A:       equ    %00010000
mTCTL4_EDG2B:       equ    %00100000
mTCTL4_EDG3A:       equ    %01000000
mTCTL4_EDG3B:       equ    %10000000


;*** TIE - Timer Interrupt Enable Register; 0x0000004C ***
TIE:                equ    $0000004C                                ;*** TIE - Timer Interrupt Enable Register; 0x0000004C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TIE_C0I:            equ    0                                         ; Input Capture/Output Compare Interrupt Enable Bit 0
TIE_C1I:            equ    1                                         ; Input Capture/Output Compare Interrupt Enable Bit 1
TIE_C2I:            equ    2                                         ; Input Capture/Output Compare Interrupt Enable Bit 2
TIE_C3I:            equ    3                                         ; Input Capture/Output Compare Interrupt Enable Bit 3
TIE_C4I:            equ    4                                         ; Input Capture/Output Compare Interrupt Enable Bit 4
TIE_C5I:            equ    5                                         ; Input Capture/Output Compare Interrupt Enable Bit 5
TIE_C6I:            equ    6                                         ; Input Capture/Output Compare Interrupt Enable Bit 6
TIE_C7I:            equ    7                                         ; Input Capture/Output Compare Interrupt Enable Bit 7
; bit position masks
mTIE_C0I:           equ    %00000001
mTIE_C1I:           equ    %00000010
mTIE_C2I:           equ    %00000100
mTIE_C3I:           equ    %00001000
mTIE_C4I:           equ    %00010000
mTIE_C5I:           equ    %00100000
mTIE_C6I:           equ    %01000000
mTIE_C7I:           equ    %10000000


;*** TSCR2 - Timer System Control Register 2; 0x0000004D ***
TSCR2:              equ    $0000004D                                ;*** TSCR2 - Timer System Control Register 2; 0x0000004D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TSCR2_PR0:          equ    0                                         ; Timer Prescaler Select Bit 0
TSCR2_PR1:          equ    1                                         ; Timer Prescaler Select Bit 1
TSCR2_PR2:          equ    2                                         ; Timer Prescaler Select Bit 2
TSCR2_TCRE:         equ    3                                         ; Timer Counter Reset Enable
TSCR2_TOI:          equ    7                                         ; Timer Overflow Interrupt Enable
; bit position masks
mTSCR2_PR0:         equ    %00000001
mTSCR2_PR1:         equ    %00000010
mTSCR2_PR2:         equ    %00000100
mTSCR2_TCRE:        equ    %00001000
mTSCR2_TOI:         equ    %10000000


;*** TFLG1 - Main Timer Interrupt Flag 1; 0x0000004E ***
TFLG1:              equ    $0000004E                                ;*** TFLG1 - Main Timer Interrupt Flag 1; 0x0000004E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TFLG1_C0F:          equ    0                                         ; Input Capture/Output Compare Channel Flag 0
TFLG1_C1F:          equ    1                                         ; Input Capture/Output Compare Channel Flag 1
TFLG1_C2F:          equ    2                                         ; Input Capture/Output Compare Channel Flag 2
TFLG1_C3F:          equ    3                                         ; Input Capture/Output Compare Channel Flag 3
TFLG1_C4F:          equ    4                                         ; Input Capture/Output Compare Channel Flag 4
TFLG1_C5F:          equ    5                                         ; Input Capture/Output Compare Channel Flag 5
TFLG1_C6F:          equ    6                                         ; Input Capture/Output Compare Channel Flag 6
TFLG1_C7F:          equ    7                                         ; Input Capture/Output Compare Channel Flag 7
; bit position masks
mTFLG1_C0F:         equ    %00000001
mTFLG1_C1F:         equ    %00000010
mTFLG1_C2F:         equ    %00000100
mTFLG1_C3F:         equ    %00001000
mTFLG1_C4F:         equ    %00010000
mTFLG1_C5F:         equ    %00100000
mTFLG1_C6F:         equ    %01000000
mTFLG1_C7F:         equ    %10000000


;*** TFLG2 - Main Timer Interrupt Flag 2; 0x0000004F ***
TFLG2:              equ    $0000004F                                ;*** TFLG2 - Main Timer Interrupt Flag 2; 0x0000004F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TFLG2_TOF:          equ    7                                         ; Timer Overflow Flag
; bit position masks
mTFLG2_TOF:         equ    %10000000


;*** TC0 - Timer Input Capture/Output Compare Register 0; 0x00000050 ***
TC0:                equ    $00000050                                ;*** TC0 - Timer Input Capture/Output Compare Register 0; 0x00000050 ***


;*** TC0Hi - Timer Input Capture/Output Compare Register 0 High; 0x00000050 ***
TC0Hi:              equ    $00000050                                ;*** TC0Hi - Timer Input Capture/Output Compare Register 0 High; 0x00000050 ***


;*** TC0Lo - Timer Input Capture/Output Compare Register 0 Low; 0x00000051 ***
TC0Lo:              equ    $00000051                                ;*** TC0Lo - Timer Input Capture/Output Compare Register 0 Low; 0x00000051 ***


;*** TC1 - Timer Input Capture/Output Compare Register 1; 0x00000052 ***
TC1:                equ    $00000052                                ;*** TC1 - Timer Input Capture/Output Compare Register 1; 0x00000052 ***


;*** TC1Hi - Timer Input Capture/Output Compare Register 1 High; 0x00000052 ***
TC1Hi:              equ    $00000052                                ;*** TC1Hi - Timer Input Capture/Output Compare Register 1 High; 0x00000052 ***


;*** TC1Lo - Timer Input Capture/Output Compare Register 1 Low; 0x00000053 ***
TC1Lo:              equ    $00000053                                ;*** TC1Lo - Timer Input Capture/Output Compare Register 1 Low; 0x00000053 ***


;*** TC2 - Timer Input Capture/Output Compare Register 2; 0x00000054 ***
TC2:                equ    $00000054                                ;*** TC2 - Timer Input Capture/Output Compare Register 2; 0x00000054 ***


;*** TC2Hi - Timer Input Capture/Output Compare Register 2 High; 0x00000054 ***
TC2Hi:              equ    $00000054                                ;*** TC2Hi - Timer Input Capture/Output Compare Register 2 High; 0x00000054 ***


;*** TC2Lo - Timer Input Capture/Output Compare Register 2 Low; 0x00000055 ***
TC2Lo:              equ    $00000055                                ;*** TC2Lo - Timer Input Capture/Output Compare Register 2 Low; 0x00000055 ***


;*** TC3 - Timer Input Capture/Output Compare Register 3; 0x00000056 ***
TC3:                equ    $00000056                                ;*** TC3 - Timer Input Capture/Output Compare Register 3; 0x00000056 ***


;*** TC3Hi - Timer Input Capture/Output Compare Register 3 High; 0x00000056 ***
TC3Hi:              equ    $00000056                                ;*** TC3Hi - Timer Input Capture/Output Compare Register 3 High; 0x00000056 ***


;*** TC3Lo - Timer Input Capture/Output Compare Register 3 Low; 0x00000057 ***
TC3Lo:              equ    $00000057                                ;*** TC3Lo - Timer Input Capture/Output Compare Register 3 Low; 0x00000057 ***


;*** TC4 - Timer Input Capture/Output Compare Register 4; 0x00000058 ***
TC4:                equ    $00000058                                ;*** TC4 - Timer Input Capture/Output Compare Register 4; 0x00000058 ***


;*** TC4Hi - Timer Input Capture/Output Compare Register 4 High; 0x00000058 ***
TC4Hi:              equ    $00000058                                ;*** TC4Hi - Timer Input Capture/Output Compare Register 4 High; 0x00000058 ***


;*** TC4Lo - Timer Input Capture/Output Compare Register 4 Low; 0x00000059 ***
TC4Lo:              equ    $00000059                                ;*** TC4Lo - Timer Input Capture/Output Compare Register 4 Low; 0x00000059 ***


;*** TC5 - Timer Input Capture/Output Compare Register 5; 0x0000005A ***
TC5:                equ    $0000005A                                ;*** TC5 - Timer Input Capture/Output Compare Register 5; 0x0000005A ***


;*** TC5Hi - Timer Input Capture/Output Compare Register 5 High; 0x0000005A ***
TC5Hi:              equ    $0000005A                                ;*** TC5Hi - Timer Input Capture/Output Compare Register 5 High; 0x0000005A ***


;*** TC5Lo - Timer Input Capture/Output Compare Register 5 Low; 0x0000005B ***
TC5Lo:              equ    $0000005B                                ;*** TC5Lo - Timer Input Capture/Output Compare Register 5 Low; 0x0000005B ***


;*** TC6 - Timer Input Capture/Output Compare Register 6; 0x0000005C ***
TC6:                equ    $0000005C                                ;*** TC6 - Timer Input Capture/Output Compare Register 6; 0x0000005C ***


;*** TC6Hi - Timer Input Capture/Output Compare Register 6 High; 0x0000005C ***
TC6Hi:              equ    $0000005C                                ;*** TC6Hi - Timer Input Capture/Output Compare Register 6 High; 0x0000005C ***


;*** TC6Lo - Timer Input Capture/Output Compare Register 6 Low; 0x0000005D ***
TC6Lo:              equ    $0000005D                                ;*** TC6Lo - Timer Input Capture/Output Compare Register 6 Low; 0x0000005D ***


;*** TC7 - Timer Input Capture/Output Compare Register 7; 0x0000005E ***
TC7:                equ    $0000005E                                ;*** TC7 - Timer Input Capture/Output Compare Register 7; 0x0000005E ***


;*** TC7Hi - Timer Input Capture/Output Compare Register 7 High; 0x0000005E ***
TC7Hi:              equ    $0000005E                                ;*** TC7Hi - Timer Input Capture/Output Compare Register 7 High; 0x0000005E ***


;*** TC7Lo - Timer Input Capture/Output Compare Register 7 Low; 0x0000005F ***
TC7Lo:              equ    $0000005F                                ;*** TC7Lo - Timer Input Capture/Output Compare Register 7 Low; 0x0000005F ***


;*** PACTL - 16-Bit Pulse Accumulator A Control Register; 0x00000060 ***
PACTL:              equ    $00000060                                ;*** PACTL - 16-Bit Pulse Accumulator A Control Register; 0x00000060 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PACTL_PAI:          equ    0                                         ; Pulse Accumulator Input Interrupt enable
PACTL_PAOVI:        equ    1                                         ; Pulse Accumulator A Overflow Interrupt enable
PACTL_CLK0:         equ    2                                         ; Clock Select Bit 0
PACTL_CLK1:         equ    3                                         ; Clock Select Bit 1
PACTL_PEDGE:        equ    4                                         ; Pulse Accumulator Edge Control
PACTL_PAMOD:        equ    5                                         ; Pulse Accumulator Mode
PACTL_PAEN:         equ    6                                         ; Pulse Accumulator A System Enable
; bit position masks
mPACTL_PAI:         equ    %00000001
mPACTL_PAOVI:       equ    %00000010
mPACTL_CLK0:        equ    %00000100
mPACTL_CLK1:        equ    %00001000
mPACTL_PEDGE:       equ    %00010000
mPACTL_PAMOD:       equ    %00100000
mPACTL_PAEN:        equ    %01000000


;*** PAFLG - Pulse Accumulator A Flag Register; 0x00000061 ***
PAFLG:              equ    $00000061                                ;*** PAFLG - Pulse Accumulator A Flag Register; 0x00000061 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PAFLG_PAIF:         equ    0                                         ; Pulse Accumulator Input edge Flag
PAFLG_PAOVF:        equ    1                                         ; Pulse Accumulator A Overflow Flag
; bit position masks
mPAFLG_PAIF:        equ    %00000001
mPAFLG_PAOVF:       equ    %00000010


;*** PACNT - Pulse Accumulators Count Register; 0x00000062 ***
PACNT:              equ    $00000062                                ;*** PACNT - Pulse Accumulators Count Register; 0x00000062 ***


;*** ATD0CTL01 - ATD 0 Control Register 01; 0x00000080 ***
ATD0CTL01:          equ    $00000080                                ;*** ATD0CTL01 - ATD 0 Control Register 01; 0x00000080 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD0CTL01_ETRIGCH0: equ    0                                         ; External Trigger Channel Select Bit 0
ATD0CTL01_ETRIGCH1: equ    1                                         ; External Trigger Channel Select Bit 1
ATD0CTL01_ETRIGCH2: equ    2                                         ; External Trigger Channel Select Bit 2
ATD0CTL01_ETRIGSEL: equ    7                                         ; External Trigger Source Select
ATD0CTL01_WRAP0:    equ    8                                         ; Wrap Around Channel Select Bit 0
ATD0CTL01_WRAP1:    equ    9                                         ; Wrap Around Channel Select Bit 1
ATD0CTL01_WRAP2:    equ    10                                        ; Wrap Around Channel Select Bit 2
; bit position masks
mATD0CTL01_ETRIGCH0: equ    %00000001
mATD0CTL01_ETRIGCH1: equ    %00000010
mATD0CTL01_ETRIGCH2: equ    %00000100
mATD0CTL01_ETRIGSEL: equ    %10000000
mATD0CTL01_WRAP0:   equ    %100000000
mATD0CTL01_WRAP1:   equ    %1000000000
mATD0CTL01_WRAP2:   equ    %10000000000


;*** ATD0CTL0 - ATD 0 Control Register 0; 0x00000080 ***
ATD0CTL0:           equ    $00000080                                ;*** ATD0CTL0 - ATD 0 Control Register 0; 0x00000080 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD0CTL0_WRAP0:     equ    0                                         ; Wrap Around Channel Select Bit 0
ATD0CTL0_WRAP1:     equ    1                                         ; Wrap Around Channel Select Bit 1
ATD0CTL0_WRAP2:     equ    2                                         ; Wrap Around Channel Select Bit 2
; bit position masks
mATD0CTL0_WRAP0:    equ    %00000001
mATD0CTL0_WRAP1:    equ    %00000010
mATD0CTL0_WRAP2:    equ    %00000100


;*** ATD0CTL1 - ATD0 Control Register 1; 0x00000081 ***
ATD0CTL1:           equ    $00000081                                ;*** ATD0CTL1 - ATD0 Control Register 1; 0x00000081 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD0CTL1_ETRIGCH0:  equ    0                                         ; External Trigger Channel Select Bit 0
ATD0CTL1_ETRIGCH1:  equ    1                                         ; External Trigger Channel Select Bit 1
ATD0CTL1_ETRIGCH2:  equ    2                                         ; External Trigger Channel Select Bit 2
ATD0CTL1_ETRIGSEL:  equ    7                                         ; External Trigger Source Select
; bit position masks
mATD0CTL1_ETRIGCH0: equ    %00000001
mATD0CTL1_ETRIGCH1: equ    %00000010
mATD0CTL1_ETRIGCH2: equ    %00000100
mATD0CTL1_ETRIGSEL: equ    %10000000


;*** ATD0CTL23 - ATD 0 Control Register 23; 0x00000082 ***
ATD0CTL23:          equ    $00000082                                ;*** ATD0CTL23 - ATD 0 Control Register 23; 0x00000082 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD0CTL23_FRZ0:     equ    0                                         ; Background Debug Freeze Enable Bit 0
ATD0CTL23_FRZ1:     equ    1                                         ; Background Debug Freeze Enable Bit 1
ATD0CTL23_FIFO:     equ    2                                         ; Result Register FIFO Mode
ATD0CTL23_S1C:      equ    3                                         ; Conversion Sequence Length 1
ATD0CTL23_S2C:      equ    4                                         ; Conversion Sequence Length 2
ATD0CTL23_S4C:      equ    5                                         ; Conversion Sequence Length 4
ATD0CTL23_S8C:      equ    6                                         ; Conversion Sequence Length 8
ATD0CTL23_ASCIF:    equ    8                                         ; ATD 0 Sequence Complete Interrupt Flag
ATD0CTL23_ASCIE:    equ    9                                         ; ATD 0 Sequence Complete Interrupt Enable
ATD0CTL23_ETRIGE:   equ    10                                        ; External Trigger Mode enable
ATD0CTL23_ETRIGP:   equ    11                                        ; External Trigger Polarity
ATD0CTL23_ETRIGLE:  equ    12                                        ; External Trigger Level/Edge control
ATD0CTL23_AWAI:     equ    13                                        ; ATD Power Down in Wait Mode
ATD0CTL23_AFFC:     equ    14                                        ; ATD Fast Conversion Complete Flag Clear
ATD0CTL23_ADPU:     equ    15                                        ; ATD Disable / Power Down
; bit position masks
mATD0CTL23_FRZ0:    equ    %00000001
mATD0CTL23_FRZ1:    equ    %00000010
mATD0CTL23_FIFO:    equ    %00000100
mATD0CTL23_S1C:     equ    %00001000
mATD0CTL23_S2C:     equ    %00010000
mATD0CTL23_S4C:     equ    %00100000
mATD0CTL23_S8C:     equ    %01000000
mATD0CTL23_ASCIF:   equ    %100000000
mATD0CTL23_ASCIE:   equ    %1000000000
mATD0CTL23_ETRIGE:  equ    %10000000000
mATD0CTL23_ETRIGP:  equ    %100000000000
mATD0CTL23_ETRIGLE: equ    %1000000000000
mATD0CTL23_AWAI:    equ    %10000000000000
mATD0CTL23_AFFC:    equ    %100000000000000
mATD0CTL23_ADPU:    equ    %1000000000000000


;*** ATD0CTL2 - ATD 0 Control Register 2; 0x00000082 ***
ATD0CTL2:           equ    $00000082                                ;*** ATD0CTL2 - ATD 0 Control Register 2; 0x00000082 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD0CTL2_ASCIF:     equ    0                                         ; ATD 0 Sequence Complete Interrupt Flag
ATD0CTL2_ASCIE:     equ    1                                         ; ATD 0 Sequence Complete Interrupt Enable
ATD0CTL2_ETRIGE:    equ    2                                         ; External Trigger Mode enable
ATD0CTL2_ETRIGP:    equ    3                                         ; External Trigger Polarity
ATD0CTL2_ETRIGLE:   equ    4                                         ; External Trigger Level/Edge control
ATD0CTL2_AWAI:      equ    5                                         ; ATD Power Down in Wait Mode
ATD0CTL2_AFFC:      equ    6                                         ; ATD Fast Conversion Complete Flag Clear
ATD0CTL2_ADPU:      equ    7                                         ; ATD Disable / Power Down
; bit position masks
mATD0CTL2_ASCIF:    equ    %00000001
mATD0CTL2_ASCIE:    equ    %00000010
mATD0CTL2_ETRIGE:   equ    %00000100
mATD0CTL2_ETRIGP:   equ    %00001000
mATD0CTL2_ETRIGLE:  equ    %00010000
mATD0CTL2_AWAI:     equ    %00100000
mATD0CTL2_AFFC:     equ    %01000000
mATD0CTL2_ADPU:     equ    %10000000


;*** ATD0CTL3 - ATD 0 Control Register 3; 0x00000083 ***
ATD0CTL3:           equ    $00000083                                ;*** ATD0CTL3 - ATD 0 Control Register 3; 0x00000083 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD0CTL3_FRZ0:      equ    0                                         ; Background Debug Freeze Enable Bit 0
ATD0CTL3_FRZ1:      equ    1                                         ; Background Debug Freeze Enable Bit 1
ATD0CTL3_FIFO:      equ    2                                         ; Result Register FIFO Mode
ATD0CTL3_S1C:       equ    3                                         ; Conversion Sequence Length 1
ATD0CTL3_S2C:       equ    4                                         ; Conversion Sequence Length 2
ATD0CTL3_S4C:       equ    5                                         ; Conversion Sequence Length 4
ATD0CTL3_S8C:       equ    6                                         ; Conversion Sequence Length 8
; bit position masks
mATD0CTL3_FRZ0:     equ    %00000001
mATD0CTL3_FRZ1:     equ    %00000010
mATD0CTL3_FIFO:     equ    %00000100
mATD0CTL3_S1C:      equ    %00001000
mATD0CTL3_S2C:      equ    %00010000
mATD0CTL3_S4C:      equ    %00100000
mATD0CTL3_S8C:      equ    %01000000


;*** ATD0CTL45 - ATD 0 Control Register 45; 0x00000084 ***
ATD0CTL45:          equ    $00000084                                ;*** ATD0CTL45 - ATD 0 Control Register 45; 0x00000084 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD0CTL45_CA:       equ    0                                         ; Analog Input Channel Select Code A
ATD0CTL45_CB:       equ    1                                         ; Analog Input Channel Select Code B
ATD0CTL45_CC:       equ    2                                         ; Analog Input Channel Select Code C
ATD0CTL45_MULT:     equ    4                                         ; Multi-Channel Sample Mode
ATD0CTL45_SCAN:     equ    5                                         ; Continuous Conversion Sequence Mode
ATD0CTL45_DSGN:     equ    6                                         ; Signed/Unsigned Result Data Mode
ATD0CTL45_DJM:      equ    7                                         ; Result Register Data Justification Mode
ATD0CTL45_PRS0:     equ    8                                         ; ATD Clock Prescaler 0
ATD0CTL45_PRS1:     equ    9                                         ; ATD Clock Prescaler 1
ATD0CTL45_PRS2:     equ    10                                        ; ATD Clock Prescaler 2
ATD0CTL45_PRS3:     equ    11                                        ; ATD Clock Prescaler 3
ATD0CTL45_PRS4:     equ    12                                        ; ATD Clock Prescaler 4
ATD0CTL45_SMP0:     equ    13                                        ; Sample Time Select 0
ATD0CTL45_SMP1:     equ    14                                        ; Sample Time Select 1
ATD0CTL45_SRES8:    equ    15                                        ; ATD Resolution Select
; bit position masks
mATD0CTL45_CA:      equ    %00000001
mATD0CTL45_CB:      equ    %00000010
mATD0CTL45_CC:      equ    %00000100
mATD0CTL45_MULT:    equ    %00010000
mATD0CTL45_SCAN:    equ    %00100000
mATD0CTL45_DSGN:    equ    %01000000
mATD0CTL45_DJM:     equ    %10000000
mATD0CTL45_PRS0:    equ    %100000000
mATD0CTL45_PRS1:    equ    %1000000000
mATD0CTL45_PRS2:    equ    %10000000000
mATD0CTL45_PRS3:    equ    %100000000000
mATD0CTL45_PRS4:    equ    %1000000000000
mATD0CTL45_SMP0:    equ    %10000000000000
mATD0CTL45_SMP1:    equ    %100000000000000
mATD0CTL45_SRES8:   equ    %1000000000000000


;*** ATD0CTL4 - ATD 0 Control Register 4; 0x00000084 ***
ATD0CTL4:           equ    $00000084                                ;*** ATD0CTL4 - ATD 0 Control Register 4; 0x00000084 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD0CTL4_PRS0:      equ    0                                         ; ATD Clock Prescaler 0
ATD0CTL4_PRS1:      equ    1                                         ; ATD Clock Prescaler 1
ATD0CTL4_PRS2:      equ    2                                         ; ATD Clock Prescaler 2
ATD0CTL4_PRS3:      equ    3                                         ; ATD Clock Prescaler 3
ATD0CTL4_PRS4:      equ    4                                         ; ATD Clock Prescaler 4
ATD0CTL4_SMP0:      equ    5                                         ; Sample Time Select 0
ATD0CTL4_SMP1:      equ    6                                         ; Sample Time Select 1
ATD0CTL4_SRES8:     equ    7                                         ; ATD Resolution Select
; bit position masks
mATD0CTL4_PRS0:     equ    %00000001
mATD0CTL4_PRS1:     equ    %00000010
mATD0CTL4_PRS2:     equ    %00000100
mATD0CTL4_PRS3:     equ    %00001000
mATD0CTL4_PRS4:     equ    %00010000
mATD0CTL4_SMP0:     equ    %00100000
mATD0CTL4_SMP1:     equ    %01000000
mATD0CTL4_SRES8:    equ    %10000000


;*** ATD0CTL5 - ATD 0 Control Register 5; 0x00000085 ***
ATD0CTL5:           equ    $00000085                                ;*** ATD0CTL5 - ATD 0 Control Register 5; 0x00000085 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD0CTL5_CA:        equ    0                                         ; Analog Input Channel Select Code A
ATD0CTL5_CB:        equ    1                                         ; Analog Input Channel Select Code B
ATD0CTL5_CC:        equ    2                                         ; Analog Input Channel Select Code C
ATD0CTL5_MULT:      equ    4                                         ; Multi-Channel Sample Mode
ATD0CTL5_SCAN:      equ    5                                         ; Continuous Conversion Sequence Mode
ATD0CTL5_DSGN:      equ    6                                         ; Signed/Unsigned Result Data Mode
ATD0CTL5_DJM:       equ    7                                         ; Result Register Data Justification Mode
; bit position masks
mATD0CTL5_CA:       equ    %00000001
mATD0CTL5_CB:       equ    %00000010
mATD0CTL5_CC:       equ    %00000100
mATD0CTL5_MULT:     equ    %00010000
mATD0CTL5_SCAN:     equ    %00100000
mATD0CTL5_DSGN:     equ    %01000000
mATD0CTL5_DJM:      equ    %10000000


;*** ATD0STAT0 - ATD 0 Status Register 0; 0x00000086 ***
ATD0STAT0:          equ    $00000086                                ;*** ATD0STAT0 - ATD 0 Status Register 0; 0x00000086 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD0STAT0_CC0:      equ    0                                         ; Conversion Counter 0
ATD0STAT0_CC1:      equ    1                                         ; Conversion Counter 1
ATD0STAT0_CC2:      equ    2                                         ; Conversion Counter 2
ATD0STAT0_FIFOR:    equ    4                                         ; FIFO Over Run Flag
ATD0STAT0_ETORF:    equ    5                                         ; External Trigger Overrun Flag
ATD0STAT0_SCF:      equ    7                                         ; Sequence Complete Flag
; bit position masks
mATD0STAT0_CC0:     equ    %00000001
mATD0STAT0_CC1:     equ    %00000010
mATD0STAT0_CC2:     equ    %00000100
mATD0STAT0_FIFOR:   equ    %00010000
mATD0STAT0_ETORF:   equ    %00100000
mATD0STAT0_SCF:     equ    %10000000


;*** ATD0TEST1 - ATD0 Test Register; 0x00000089 ***
ATD0TEST1:          equ    $00000089                                ;*** ATD0TEST1 - ATD0 Test Register; 0x00000089 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD0TEST1_SC:       equ    0                                         ; Special Channel Conversion Bit
; bit position masks
mATD0TEST1_SC:      equ    %00000001


;*** ATD0STAT1 - ATD 0 Status Register 1; 0x0000008B ***
ATD0STAT1:          equ    $0000008B                                ;*** ATD0STAT1 - ATD 0 Status Register 1; 0x0000008B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD0STAT1_CCF0:     equ    0                                         ; Conversion Complete Flag 0
ATD0STAT1_CCF1:     equ    1                                         ; Conversion Complete Flag 1
ATD0STAT1_CCF2:     equ    2                                         ; Conversion Complete Flag 2
ATD0STAT1_CCF3:     equ    3                                         ; Conversion Complete Flag 3
ATD0STAT1_CCF4:     equ    4                                         ; Conversion Complete Flag 4
ATD0STAT1_CCF5:     equ    5                                         ; Conversion Complete Flag 5
ATD0STAT1_CCF6:     equ    6                                         ; Conversion Complete Flag 6
ATD0STAT1_CCF7:     equ    7                                         ; Conversion Complete Flag 7
; bit position masks
mATD0STAT1_CCF0:    equ    %00000001
mATD0STAT1_CCF1:    equ    %00000010
mATD0STAT1_CCF2:    equ    %00000100
mATD0STAT1_CCF3:    equ    %00001000
mATD0STAT1_CCF4:    equ    %00010000
mATD0STAT1_CCF5:    equ    %00100000
mATD0STAT1_CCF6:    equ    %01000000
mATD0STAT1_CCF7:    equ    %10000000


;*** ATD0DIEN - ATD 0 Input Enable Register; 0x0000008D ***
ATD0DIEN:           equ    $0000008D                                ;*** ATD0DIEN - ATD 0 Input Enable Register; 0x0000008D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD0DIEN_IEN0:      equ    0                                         ; ATD Digital Input Enable on channel 0
ATD0DIEN_IEN1:      equ    1                                         ; ATD Digital Input Enable on channel 1
ATD0DIEN_IEN2:      equ    2                                         ; ATD Digital Input Enable on channel 2
ATD0DIEN_IEN3:      equ    3                                         ; ATD Digital Input Enable on channel 3
ATD0DIEN_IEN4:      equ    4                                         ; ATD Digital Input Enable on channel 4
ATD0DIEN_IEN5:      equ    5                                         ; ATD Digital Input Enable on channel 5
ATD0DIEN_IEN6:      equ    6                                         ; ATD Digital Input Enable on channel 6
ATD0DIEN_IEN7:      equ    7                                         ; ATD Digital Input Enable on channel 7
; bit position masks
mATD0DIEN_IEN0:     equ    %00000001
mATD0DIEN_IEN1:     equ    %00000010
mATD0DIEN_IEN2:     equ    %00000100
mATD0DIEN_IEN3:     equ    %00001000
mATD0DIEN_IEN4:     equ    %00010000
mATD0DIEN_IEN5:     equ    %00100000
mATD0DIEN_IEN6:     equ    %01000000
mATD0DIEN_IEN7:     equ    %10000000


;*** PORTAD0 - Port AD0 Register; 0x0000008F ***
PORTAD0:            equ    $0000008F                                ;*** PORTAD0 - Port AD0 Register; 0x0000008F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PORTAD0_PTAD0:      equ    0                                         ; A/D Channel 0 (AN0) Digital Input
PORTAD0_PTAD1:      equ    1                                         ; A/D Channel 1 (AN1) Digital Input
PORTAD0_PTAD2:      equ    2                                         ; A/D Channel 2 (AN2) Digital Input
PORTAD0_PTAD3:      equ    3                                         ; A/D Channel 3 (AN3) Digital Input
PORTAD0_PTAD4:      equ    4                                         ; A/D Channel 4 (AN4) Digital Input
PORTAD0_PTAD5:      equ    5                                         ; A/D Channel 5 (AN5) Digital Input
PORTAD0_PTAD6:      equ    6                                         ; A/D Channel 6 (AN6) Digital Input
PORTAD0_PTAD7:      equ    7                                         ; A/D Channel 7 (AN7) Digital Input
; bit position masks
mPORTAD0_PTAD0:     equ    %00000001
mPORTAD0_PTAD1:     equ    %00000010
mPORTAD0_PTAD2:     equ    %00000100
mPORTAD0_PTAD3:     equ    %00001000
mPORTAD0_PTAD4:     equ    %00010000
mPORTAD0_PTAD5:     equ    %00100000
mPORTAD0_PTAD6:     equ    %01000000
mPORTAD0_PTAD7:     equ    %10000000


;*** ATD0DR0 - ATD 0 Conversion Result Register 0; 0x00000090 ***
ATD0DR0:            equ    $00000090                                ;*** ATD0DR0 - ATD 0 Conversion Result Register 0; 0x00000090 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD0DR0_BIT6:       equ    6                                         ; Bit 6
ATD0DR0_BIT7:       equ    7                                         ; Bit 7
ATD0DR0_BIT8:       equ    8                                         ; Bit 8
ATD0DR0_BIT9:       equ    9                                         ; Bit 9
ATD0DR0_BIT10:      equ    10                                        ; Bit 10
ATD0DR0_BIT11:      equ    11                                        ; Bit 11
ATD0DR0_BIT12:      equ    12                                        ; Bit 12
ATD0DR0_BIT13:      equ    13                                        ; Bit 13
ATD0DR0_BIT14:      equ    14                                        ; Bit 14
ATD0DR0_BIT15:      equ    15                                        ; Bit 15
; bit position masks
mATD0DR0_BIT6:      equ    %01000000
mATD0DR0_BIT7:      equ    %10000000
mATD0DR0_BIT8:      equ    %100000000
mATD0DR0_BIT9:      equ    %1000000000
mATD0DR0_BIT10:     equ    %10000000000
mATD0DR0_BIT11:     equ    %100000000000
mATD0DR0_BIT12:     equ    %1000000000000
mATD0DR0_BIT13:     equ    %10000000000000
mATD0DR0_BIT14:     equ    %100000000000000
mATD0DR0_BIT15:     equ    %1000000000000000


;*** ATD0DR0H - ATD 0 Conversion Result Register 0 High; 0x00000090 ***
ATD0DR0H:           equ    $00000090                                ;*** ATD0DR0H - ATD 0 Conversion Result Register 0 High; 0x00000090 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD0DR0H_BIT8:      equ    0                                         ; Bit 8
ATD0DR0H_BIT9:      equ    1                                         ; Bit 9
ATD0DR0H_BIT10:     equ    2                                         ; Bit 10
ATD0DR0H_BIT11:     equ    3                                         ; Bit 11
ATD0DR0H_BIT12:     equ    4                                         ; Bit 12
ATD0DR0H_BIT13:     equ    5                                         ; Bit 13
ATD0DR0H_BIT14:     equ    6                                         ; Bit 14
ATD0DR0H_BIT15:     equ    7                                         ; Bit 15
; bit position masks
mATD0DR0H_BIT8:     equ    %00000001
mATD0DR0H_BIT9:     equ    %00000010
mATD0DR0H_BIT10:    equ    %00000100
mATD0DR0H_BIT11:    equ    %00001000
mATD0DR0H_BIT12:    equ    %00010000
mATD0DR0H_BIT13:    equ    %00100000
mATD0DR0H_BIT14:    equ    %01000000
mATD0DR0H_BIT15:    equ    %10000000


;*** ATD0DR0L - ATD 0 Conversion Result Register 0 Low; 0x00000091 ***
ATD0DR0L:           equ    $00000091                                ;*** ATD0DR0L - ATD 0 Conversion Result Register 0 Low; 0x00000091 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD0DR0L_BIT6:      equ    6                                         ; Bit 6
ATD0DR0L_BIT7:      equ    7                                         ; Bit 7
; bit position masks
mATD0DR0L_BIT6:     equ    %01000000
mATD0DR0L_BIT7:     equ    %10000000


;*** ATD0DR1 - ATD 0 Conversion Result Register 1; 0x00000092 ***
ATD0DR1:            equ    $00000092                                ;*** ATD0DR1 - ATD 0 Conversion Result Register 1; 0x00000092 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD0DR1_BIT6:       equ    6                                         ; Bit 6
ATD0DR1_BIT7:       equ    7                                         ; Bit 7
ATD0DR1_BIT8:       equ    8                                         ; Bit 8
ATD0DR1_BIT9:       equ    9                                         ; Bit 9
ATD0DR1_BIT10:      equ    10                                        ; Bit 10
ATD0DR1_BIT11:      equ    11                                        ; Bit 11
ATD0DR1_BIT12:      equ    12                                        ; Bit 12
ATD0DR1_BIT13:      equ    13                                        ; Bit 13
ATD0DR1_BIT14:      equ    14                                        ; Bit 14
ATD0DR1_BIT15:      equ    15                                        ; Bit 15
; bit position masks
mATD0DR1_BIT6:      equ    %01000000
mATD0DR1_BIT7:      equ    %10000000
mATD0DR1_BIT8:      equ    %100000000
mATD0DR1_BIT9:      equ    %1000000000
mATD0DR1_BIT10:     equ    %10000000000
mATD0DR1_BIT11:     equ    %100000000000
mATD0DR1_BIT12:     equ    %1000000000000
mATD0DR1_BIT13:     equ    %10000000000000
mATD0DR1_BIT14:     equ    %100000000000000
mATD0DR1_BIT15:     equ    %1000000000000000


;*** ATD0DR1H - ATD 0 Conversion Result Register 1 High; 0x00000092 ***
ATD0DR1H:           equ    $00000092                                ;*** ATD0DR1H - ATD 0 Conversion Result Register 1 High; 0x00000092 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD0DR1H_BIT8:      equ    0                                         ; Bit 8
ATD0DR1H_BIT9:      equ    1                                         ; Bit 9
ATD0DR1H_BIT10:     equ    2                                         ; Bit 10
ATD0DR1H_BIT11:     equ    3                                         ; Bit 11
ATD0DR1H_BIT12:     equ    4                                         ; Bit 12
ATD0DR1H_BIT13:     equ    5                                         ; Bit 13
ATD0DR1H_BIT14:     equ    6                                         ; Bit 14
ATD0DR1H_BIT15:     equ    7                                         ; Bit 15
; bit position masks
mATD0DR1H_BIT8:     equ    %00000001
mATD0DR1H_BIT9:     equ    %00000010
mATD0DR1H_BIT10:    equ    %00000100
mATD0DR1H_BIT11:    equ    %00001000
mATD0DR1H_BIT12:    equ    %00010000
mATD0DR1H_BIT13:    equ    %00100000
mATD0DR1H_BIT14:    equ    %01000000
mATD0DR1H_BIT15:    equ    %10000000


;*** ATD0DR1L - ATD 0 Conversion Result Register 1 Low; 0x00000093 ***
ATD0DR1L:           equ    $00000093                                ;*** ATD0DR1L - ATD 0 Conversion Result Register 1 Low; 0x00000093 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD0DR1L_BIT6:      equ    6                                         ; Bit 6
ATD0DR1L_BIT7:      equ    7                                         ; Bit 7
; bit position masks
mATD0DR1L_BIT6:     equ    %01000000
mATD0DR1L_BIT7:     equ    %10000000


;*** ATD0DR2 - ATD 0 Conversion Result Register 2; 0x00000094 ***
ATD0DR2:            equ    $00000094                                ;*** ATD0DR2 - ATD 0 Conversion Result Register 2; 0x00000094 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD0DR2_BIT6:       equ    6                                         ; Bit 6
ATD0DR2_BIT7:       equ    7                                         ; Bit 7
ATD0DR2_BIT8:       equ    8                                         ; Bit 8
ATD0DR2_BIT9:       equ    9                                         ; Bit 9
ATD0DR2_BIT10:      equ    10                                        ; Bit 10
ATD0DR2_BIT11:      equ    11                                        ; Bit 11
ATD0DR2_BIT12:      equ    12                                        ; Bit 12
ATD0DR2_BIT13:      equ    13                                        ; Bit 13
ATD0DR2_BIT14:      equ    14                                        ; Bit 14
ATD0DR2_BIT15:      equ    15                                        ; Bit 15
; bit position masks
mATD0DR2_BIT6:      equ    %01000000
mATD0DR2_BIT7:      equ    %10000000
mATD0DR2_BIT8:      equ    %100000000
mATD0DR2_BIT9:      equ    %1000000000
mATD0DR2_BIT10:     equ    %10000000000
mATD0DR2_BIT11:     equ    %100000000000
mATD0DR2_BIT12:     equ    %1000000000000
mATD0DR2_BIT13:     equ    %10000000000000
mATD0DR2_BIT14:     equ    %100000000000000
mATD0DR2_BIT15:     equ    %1000000000000000


;*** ATD0DR2H - ATD 0 Conversion Result Register 2 High; 0x00000094 ***
ATD0DR2H:           equ    $00000094                                ;*** ATD0DR2H - ATD 0 Conversion Result Register 2 High; 0x00000094 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD0DR2H_BIT8:      equ    0                                         ; Bit 8
ATD0DR2H_BIT9:      equ    1                                         ; Bit 9
ATD0DR2H_BIT10:     equ    2                                         ; Bit 10
ATD0DR2H_BIT11:     equ    3                                         ; Bit 11
ATD0DR2H_BIT12:     equ    4                                         ; Bit 12
ATD0DR2H_BIT13:     equ    5                                         ; Bit 13
ATD0DR2H_BIT14:     equ    6                                         ; Bit 14
ATD0DR2H_BIT15:     equ    7                                         ; Bit 15
; bit position masks
mATD0DR2H_BIT8:     equ    %00000001
mATD0DR2H_BIT9:     equ    %00000010
mATD0DR2H_BIT10:    equ    %00000100
mATD0DR2H_BIT11:    equ    %00001000
mATD0DR2H_BIT12:    equ    %00010000
mATD0DR2H_BIT13:    equ    %00100000
mATD0DR2H_BIT14:    equ    %01000000
mATD0DR2H_BIT15:    equ    %10000000


;*** ATD0DR2L - ATD 0 Conversion Result Register 2 Low; 0x00000095 ***
ATD0DR2L:           equ    $00000095                                ;*** ATD0DR2L - ATD 0 Conversion Result Register 2 Low; 0x00000095 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD0DR2L_BIT6:      equ    6                                         ; Bit 6
ATD0DR2L_BIT7:      equ    7                                         ; Bit 7
; bit position masks
mATD0DR2L_BIT6:     equ    %01000000
mATD0DR2L_BIT7:     equ    %10000000


;*** ATD0DR3 - ATD 0 Conversion Result Register 3; 0x00000096 ***
ATD0DR3:            equ    $00000096                                ;*** ATD0DR3 - ATD 0 Conversion Result Register 3; 0x00000096 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD0DR3_BIT6:       equ    6                                         ; Bit 6
ATD0DR3_BIT7:       equ    7                                         ; Bit 7
ATD0DR3_BIT8:       equ    8                                         ; Bit 8
ATD0DR3_BIT9:       equ    9                                         ; Bit 9
ATD0DR3_BIT10:      equ    10                                        ; Bit 10
ATD0DR3_BIT11:      equ    11                                        ; Bit 11
ATD0DR3_BIT12:      equ    12                                        ; Bit 12
ATD0DR3_BIT13:      equ    13                                        ; Bit 13
ATD0DR3_BIT14:      equ    14                                        ; Bit 14
ATD0DR3_BIT15:      equ    15                                        ; Bit 15
; bit position masks
mATD0DR3_BIT6:      equ    %01000000
mATD0DR3_BIT7:      equ    %10000000
mATD0DR3_BIT8:      equ    %100000000
mATD0DR3_BIT9:      equ    %1000000000
mATD0DR3_BIT10:     equ    %10000000000
mATD0DR3_BIT11:     equ    %100000000000
mATD0DR3_BIT12:     equ    %1000000000000
mATD0DR3_BIT13:     equ    %10000000000000
mATD0DR3_BIT14:     equ    %100000000000000
mATD0DR3_BIT15:     equ    %1000000000000000


;*** ATD0DR3H - ATD 0 Conversion Result Register 3 High; 0x00000096 ***
ATD0DR3H:           equ    $00000096                                ;*** ATD0DR3H - ATD 0 Conversion Result Register 3 High; 0x00000096 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD0DR3H_BIT8:      equ    0                                         ; Bit 8
ATD0DR3H_BIT9:      equ    1                                         ; Bit 9
ATD0DR3H_BIT10:     equ    2                                         ; Bit 10
ATD0DR3H_BIT11:     equ    3                                         ; Bit 11
ATD0DR3H_BIT12:     equ    4                                         ; Bit 12
ATD0DR3H_BIT13:     equ    5                                         ; Bit 13
ATD0DR3H_BIT14:     equ    6                                         ; Bit 14
ATD0DR3H_BIT15:     equ    7                                         ; Bit 15
; bit position masks
mATD0DR3H_BIT8:     equ    %00000001
mATD0DR3H_BIT9:     equ    %00000010
mATD0DR3H_BIT10:    equ    %00000100
mATD0DR3H_BIT11:    equ    %00001000
mATD0DR3H_BIT12:    equ    %00010000
mATD0DR3H_BIT13:    equ    %00100000
mATD0DR3H_BIT14:    equ    %01000000
mATD0DR3H_BIT15:    equ    %10000000


;*** ATD0DR3L - ATD 0 Conversion Result Register 3 Low; 0x00000097 ***
ATD0DR3L:           equ    $00000097                                ;*** ATD0DR3L - ATD 0 Conversion Result Register 3 Low; 0x00000097 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD0DR3L_BIT6:      equ    6                                         ; Bit 6
ATD0DR3L_BIT7:      equ    7                                         ; Bit 7
; bit position masks
mATD0DR3L_BIT6:     equ    %01000000
mATD0DR3L_BIT7:     equ    %10000000


;*** ATD0DR4 - ATD 0 Conversion Result Register 4; 0x00000098 ***
ATD0DR4:            equ    $00000098                                ;*** ATD0DR4 - ATD 0 Conversion Result Register 4; 0x00000098 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD0DR4_BIT6:       equ    6                                         ; Bit 6
ATD0DR4_BIT7:       equ    7                                         ; Bit 7
ATD0DR4_BIT8:       equ    8                                         ; Bit 8
ATD0DR4_BIT9:       equ    9                                         ; Bit 9
ATD0DR4_BIT10:      equ    10                                        ; Bit 10
ATD0DR4_BIT11:      equ    11                                        ; Bit 11
ATD0DR4_BIT12:      equ    12                                        ; Bit 12
ATD0DR4_BIT13:      equ    13                                        ; Bit 13
ATD0DR4_BIT14:      equ    14                                        ; Bit 14
ATD0DR4_BIT15:      equ    15                                        ; Bit 15
; bit position masks
mATD0DR4_BIT6:      equ    %01000000
mATD0DR4_BIT7:      equ    %10000000
mATD0DR4_BIT8:      equ    %100000000
mATD0DR4_BIT9:      equ    %1000000000
mATD0DR4_BIT10:     equ    %10000000000
mATD0DR4_BIT11:     equ    %100000000000
mATD0DR4_BIT12:     equ    %1000000000000
mATD0DR4_BIT13:     equ    %10000000000000
mATD0DR4_BIT14:     equ    %100000000000000
mATD0DR4_BIT15:     equ    %1000000000000000


;*** ATD0DR4H - ATD 0 Conversion Result Register 4 High; 0x00000098 ***
ATD0DR4H:           equ    $00000098                                ;*** ATD0DR4H - ATD 0 Conversion Result Register 4 High; 0x00000098 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD0DR4H_BIT8:      equ    0                                         ; Bit 8
ATD0DR4H_BIT9:      equ    1                                         ; Bit 9
ATD0DR4H_BIT10:     equ    2                                         ; Bit 10
ATD0DR4H_BIT11:     equ    3                                         ; Bit 11
ATD0DR4H_BIT12:     equ    4                                         ; Bit 12
ATD0DR4H_BIT13:     equ    5                                         ; Bit 13
ATD0DR4H_BIT14:     equ    6                                         ; Bit 14
ATD0DR4H_BIT15:     equ    7                                         ; Bit 15
; bit position masks
mATD0DR4H_BIT8:     equ    %00000001
mATD0DR4H_BIT9:     equ    %00000010
mATD0DR4H_BIT10:    equ    %00000100
mATD0DR4H_BIT11:    equ    %00001000
mATD0DR4H_BIT12:    equ    %00010000
mATD0DR4H_BIT13:    equ    %00100000
mATD0DR4H_BIT14:    equ    %01000000
mATD0DR4H_BIT15:    equ    %10000000


;*** ATD0DR4L - ATD 0 Conversion Result Register 4 Low; 0x00000099 ***
ATD0DR4L:           equ    $00000099                                ;*** ATD0DR4L - ATD 0 Conversion Result Register 4 Low; 0x00000099 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD0DR4L_BIT6:      equ    6                                         ; Bit 6
ATD0DR4L_BIT7:      equ    7                                         ; Bit 7
; bit position masks
mATD0DR4L_BIT6:     equ    %01000000
mATD0DR4L_BIT7:     equ    %10000000


;*** ATD0DR5 - ATD 0 Conversion Result Register 5; 0x0000009A ***
ATD0DR5:            equ    $0000009A                                ;*** ATD0DR5 - ATD 0 Conversion Result Register 5; 0x0000009A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD0DR5_BIT6:       equ    6                                         ; Bit 6
ATD0DR5_BIT7:       equ    7                                         ; Bit 7
ATD0DR5_BIT8:       equ    8                                         ; Bit 8
ATD0DR5_BIT9:       equ    9                                         ; Bit 9
ATD0DR5_BIT10:      equ    10                                        ; Bit 10
ATD0DR5_BIT11:      equ    11                                        ; Bit 11
ATD0DR5_BIT12:      equ    12                                        ; Bit 12
ATD0DR5_BIT13:      equ    13                                        ; Bit 13
ATD0DR5_BIT14:      equ    14                                        ; Bit 14
ATD0DR5_BIT15:      equ    15                                        ; Bit 15
; bit position masks
mATD0DR5_BIT6:      equ    %01000000
mATD0DR5_BIT7:      equ    %10000000
mATD0DR5_BIT8:      equ    %100000000
mATD0DR5_BIT9:      equ    %1000000000
mATD0DR5_BIT10:     equ    %10000000000
mATD0DR5_BIT11:     equ    %100000000000
mATD0DR5_BIT12:     equ    %1000000000000
mATD0DR5_BIT13:     equ    %10000000000000
mATD0DR5_BIT14:     equ    %100000000000000
mATD0DR5_BIT15:     equ    %1000000000000000


;*** ATD0DR5H - ATD 0 Conversion Result Register 5 High; 0x0000009A ***
ATD0DR5H:           equ    $0000009A                                ;*** ATD0DR5H - ATD 0 Conversion Result Register 5 High; 0x0000009A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD0DR5H_BIT8:      equ    0                                         ; Bit 8
ATD0DR5H_BIT9:      equ    1                                         ; Bit 9
ATD0DR5H_BIT10:     equ    2                                         ; Bit 10
ATD0DR5H_BIT11:     equ    3                                         ; Bit 11
ATD0DR5H_BIT12:     equ    4                                         ; Bit 12
ATD0DR5H_BIT13:     equ    5                                         ; Bit 13
ATD0DR5H_BIT14:     equ    6                                         ; Bit 14
ATD0DR5H_BIT15:     equ    7                                         ; Bit 15
; bit position masks
mATD0DR5H_BIT8:     equ    %00000001
mATD0DR5H_BIT9:     equ    %00000010
mATD0DR5H_BIT10:    equ    %00000100
mATD0DR5H_BIT11:    equ    %00001000
mATD0DR5H_BIT12:    equ    %00010000
mATD0DR5H_BIT13:    equ    %00100000
mATD0DR5H_BIT14:    equ    %01000000
mATD0DR5H_BIT15:    equ    %10000000


;*** ATD0DR5L - ATD 0 Conversion Result Register 5 Low; 0x0000009B ***
ATD0DR5L:           equ    $0000009B                                ;*** ATD0DR5L - ATD 0 Conversion Result Register 5 Low; 0x0000009B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD0DR5L_BIT6:      equ    6                                         ; Bit 6
ATD0DR5L_BIT7:      equ    7                                         ; Bit 7
; bit position masks
mATD0DR5L_BIT6:     equ    %01000000
mATD0DR5L_BIT7:     equ    %10000000


;*** ATD0DR6 - ATD 0 Conversion Result Register 6; 0x0000009C ***
ATD0DR6:            equ    $0000009C                                ;*** ATD0DR6 - ATD 0 Conversion Result Register 6; 0x0000009C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD0DR6_BIT6:       equ    6                                         ; Bit 6
ATD0DR6_BIT7:       equ    7                                         ; Bit 7
ATD0DR6_BIT8:       equ    8                                         ; Bit 8
ATD0DR6_BIT9:       equ    9                                         ; Bit 9
ATD0DR6_BIT10:      equ    10                                        ; Bit 10
ATD0DR6_BIT11:      equ    11                                        ; Bit 11
ATD0DR6_BIT12:      equ    12                                        ; Bit 12
ATD0DR6_BIT13:      equ    13                                        ; Bit 13
ATD0DR6_BIT14:      equ    14                                        ; Bit 14
ATD0DR6_BIT15:      equ    15                                        ; Bit 15
; bit position masks
mATD0DR6_BIT6:      equ    %01000000
mATD0DR6_BIT7:      equ    %10000000
mATD0DR6_BIT8:      equ    %100000000
mATD0DR6_BIT9:      equ    %1000000000
mATD0DR6_BIT10:     equ    %10000000000
mATD0DR6_BIT11:     equ    %100000000000
mATD0DR6_BIT12:     equ    %1000000000000
mATD0DR6_BIT13:     equ    %10000000000000
mATD0DR6_BIT14:     equ    %100000000000000
mATD0DR6_BIT15:     equ    %1000000000000000


;*** ATD0DR6H - ATD 0 Conversion Result Register 6 High; 0x0000009C ***
ATD0DR6H:           equ    $0000009C                                ;*** ATD0DR6H - ATD 0 Conversion Result Register 6 High; 0x0000009C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD0DR6H_BIT8:      equ    0                                         ; Bit 8
ATD0DR6H_BIT9:      equ    1                                         ; Bit 9
ATD0DR6H_BIT10:     equ    2                                         ; Bit 10
ATD0DR6H_BIT11:     equ    3                                         ; Bit 11
ATD0DR6H_BIT12:     equ    4                                         ; Bit 12
ATD0DR6H_BIT13:     equ    5                                         ; Bit 13
ATD0DR6H_BIT14:     equ    6                                         ; Bit 14
ATD0DR6H_BIT15:     equ    7                                         ; Bit 15
; bit position masks
mATD0DR6H_BIT8:     equ    %00000001
mATD0DR6H_BIT9:     equ    %00000010
mATD0DR6H_BIT10:    equ    %00000100
mATD0DR6H_BIT11:    equ    %00001000
mATD0DR6H_BIT12:    equ    %00010000
mATD0DR6H_BIT13:    equ    %00100000
mATD0DR6H_BIT14:    equ    %01000000
mATD0DR6H_BIT15:    equ    %10000000


;*** ATD0DR6L - ATD 0 Conversion Result Register 6 Low; 0x0000009D ***
ATD0DR6L:           equ    $0000009D                                ;*** ATD0DR6L - ATD 0 Conversion Result Register 6 Low; 0x0000009D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD0DR6L_BIT6:      equ    6                                         ; Bit 6
ATD0DR6L_BIT7:      equ    7                                         ; Bit 7
; bit position masks
mATD0DR6L_BIT6:     equ    %01000000
mATD0DR6L_BIT7:     equ    %10000000


;*** ATD0DR7 - ATD 0 Conversion Result Register 7; 0x0000009E ***
ATD0DR7:            equ    $0000009E                                ;*** ATD0DR7 - ATD 0 Conversion Result Register 7; 0x0000009E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD0DR7_BIT6:       equ    6                                         ; Bit 6
ATD0DR7_BIT7:       equ    7                                         ; Bit 7
ATD0DR7_BIT8:       equ    8                                         ; Bit 8
ATD0DR7_BIT9:       equ    9                                         ; Bit 9
ATD0DR7_BIT10:      equ    10                                        ; Bit 10
ATD0DR7_BIT11:      equ    11                                        ; Bit 11
ATD0DR7_BIT12:      equ    12                                        ; Bit 12
ATD0DR7_BIT13:      equ    13                                        ; Bit 13
ATD0DR7_BIT14:      equ    14                                        ; Bit 14
ATD0DR7_BIT15:      equ    15                                        ; Bit 15
; bit position masks
mATD0DR7_BIT6:      equ    %01000000
mATD0DR7_BIT7:      equ    %10000000
mATD0DR7_BIT8:      equ    %100000000
mATD0DR7_BIT9:      equ    %1000000000
mATD0DR7_BIT10:     equ    %10000000000
mATD0DR7_BIT11:     equ    %100000000000
mATD0DR7_BIT12:     equ    %1000000000000
mATD0DR7_BIT13:     equ    %10000000000000
mATD0DR7_BIT14:     equ    %100000000000000
mATD0DR7_BIT15:     equ    %1000000000000000


;*** ATD0DR7H - ATD 0 Conversion Result Register 7 High; 0x0000009E ***
ATD0DR7H:           equ    $0000009E                                ;*** ATD0DR7H - ATD 0 Conversion Result Register 7 High; 0x0000009E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD0DR7H_BIT8:      equ    0                                         ; Bit 8
ATD0DR7H_BIT9:      equ    1                                         ; Bit 9
ATD0DR7H_BIT10:     equ    2                                         ; Bit 10
ATD0DR7H_BIT11:     equ    3                                         ; Bit 11
ATD0DR7H_BIT12:     equ    4                                         ; Bit 12
ATD0DR7H_BIT13:     equ    5                                         ; Bit 13
ATD0DR7H_BIT14:     equ    6                                         ; Bit 14
ATD0DR7H_BIT15:     equ    7                                         ; Bit 15
; bit position masks
mATD0DR7H_BIT8:     equ    %00000001
mATD0DR7H_BIT9:     equ    %00000010
mATD0DR7H_BIT10:    equ    %00000100
mATD0DR7H_BIT11:    equ    %00001000
mATD0DR7H_BIT12:    equ    %00010000
mATD0DR7H_BIT13:    equ    %00100000
mATD0DR7H_BIT14:    equ    %01000000
mATD0DR7H_BIT15:    equ    %10000000


;*** ATD0DR7L - ATD 0 Conversion Result Register 7 Low; 0x0000009F ***
ATD0DR7L:           equ    $0000009F                                ;*** ATD0DR7L - ATD 0 Conversion Result Register 7 Low; 0x0000009F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD0DR7L_BIT6:      equ    6                                         ; Bit 6
ATD0DR7L_BIT7:      equ    7                                         ; Bit 7
; bit position masks
mATD0DR7L_BIT6:     equ    %01000000
mATD0DR7L_BIT7:     equ    %10000000


;*** SCI0BD - SCI 0 Baud Rate Register; 0x000000C8 ***
SCI0BD:             equ    $000000C8                                ;*** SCI0BD - SCI 0 Baud Rate Register; 0x000000C8 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI0BD_SBR0:        equ    0                                         ; SCI Baud Rate Bit 0
SCI0BD_SBR1:        equ    1                                         ; SCI Baud Rate Bit 1
SCI0BD_SBR2:        equ    2                                         ; SCI Baud Rate Bit 2
SCI0BD_SBR3:        equ    3                                         ; SCI Baud Rate Bit 3
SCI0BD_SBR4:        equ    4                                         ; SCI Baud Rate Bit 4
SCI0BD_SBR5:        equ    5                                         ; SCI Baud Rate Bit 5
SCI0BD_SBR6:        equ    6                                         ; SCI Baud Rate Bit 6
SCI0BD_SBR7:        equ    7                                         ; SCI Baud Rate Bit 7
SCI0BD_SBR8:        equ    8                                         ; SCI Baud Rate Bit 8
SCI0BD_SBR9:        equ    9                                         ; SCI Baud Rate Bit 9
SCI0BD_SBR10:       equ    10                                        ; SCI Baud Rate Bit 10
SCI0BD_SBR11:       equ    11                                        ; SCI Baud Rate Bit 11
SCI0BD_SBR12:       equ    12                                        ; SCI Baud Rate Bit 12
; bit position masks
mSCI0BD_SBR0:       equ    %00000001
mSCI0BD_SBR1:       equ    %00000010
mSCI0BD_SBR2:       equ    %00000100
mSCI0BD_SBR3:       equ    %00001000
mSCI0BD_SBR4:       equ    %00010000
mSCI0BD_SBR5:       equ    %00100000
mSCI0BD_SBR6:       equ    %01000000
mSCI0BD_SBR7:       equ    %10000000
mSCI0BD_SBR8:       equ    %100000000
mSCI0BD_SBR9:       equ    %1000000000
mSCI0BD_SBR10:      equ    %10000000000
mSCI0BD_SBR11:      equ    %100000000000
mSCI0BD_SBR12:      equ    %1000000000000


;*** SCI0BDH - SCI 0 Baud Rate Register High; 0x000000C8 ***
SCI0BDH:            equ    $000000C8                                ;*** SCI0BDH - SCI 0 Baud Rate Register High; 0x000000C8 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI0BDH_SBR8:       equ    0                                         ; SCI Baud Rate Bit 8
SCI0BDH_SBR9:       equ    1                                         ; SCI Baud Rate Bit 9
SCI0BDH_SBR10:      equ    2                                         ; SCI Baud Rate Bit 10
SCI0BDH_SBR11:      equ    3                                         ; SCI Baud Rate Bit 11
SCI0BDH_SBR12:      equ    4                                         ; SCI Baud Rate Bit 12
; bit position masks
mSCI0BDH_SBR8:      equ    %00000001
mSCI0BDH_SBR9:      equ    %00000010
mSCI0BDH_SBR10:     equ    %00000100
mSCI0BDH_SBR11:     equ    %00001000
mSCI0BDH_SBR12:     equ    %00010000


;*** SCI0BDL - SCI 0 Baud Rate Register Low; 0x000000C9 ***
SCI0BDL:            equ    $000000C9                                ;*** SCI0BDL - SCI 0 Baud Rate Register Low; 0x000000C9 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI0BDL_SBR0:       equ    0                                         ; SCI Baud Rate Bit 0
SCI0BDL_SBR1:       equ    1                                         ; SCI Baud Rate Bit 1
SCI0BDL_SBR2:       equ    2                                         ; SCI Baud Rate Bit 2
SCI0BDL_SBR3:       equ    3                                         ; SCI Baud Rate Bit 3
SCI0BDL_SBR4:       equ    4                                         ; SCI Baud Rate Bit 4
SCI0BDL_SBR5:       equ    5                                         ; SCI Baud Rate Bit 5
SCI0BDL_SBR6:       equ    6                                         ; SCI Baud Rate Bit 6
SCI0BDL_SBR7:       equ    7                                         ; SCI Baud Rate Bit 7
; bit position masks
mSCI0BDL_SBR0:      equ    %00000001
mSCI0BDL_SBR1:      equ    %00000010
mSCI0BDL_SBR2:      equ    %00000100
mSCI0BDL_SBR3:      equ    %00001000
mSCI0BDL_SBR4:      equ    %00010000
mSCI0BDL_SBR5:      equ    %00100000
mSCI0BDL_SBR6:      equ    %01000000
mSCI0BDL_SBR7:      equ    %10000000


;*** SCI0CR1 - SCI 0 Control Register 1; 0x000000CA ***
SCI0CR1:            equ    $000000CA                                ;*** SCI0CR1 - SCI 0 Control Register 1; 0x000000CA ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI0CR1_PT:         equ    0                                         ; Parity Type Bit
SCI0CR1_PE:         equ    1                                         ; Parity Enable Bit
SCI0CR1_ILT:        equ    2                                         ; Idle Line Type Bit
SCI0CR1_WAKE:       equ    3                                         ; Wakeup Condition Bit
SCI0CR1_M:          equ    4                                         ; Data Format Mode Bit
SCI0CR1_RSRC:       equ    5                                         ; Receiver Source Bit
SCI0CR1_SCISWAI:    equ    6                                         ; SCI Stop in Wait Mode Bit
SCI0CR1_LOOPS:      equ    7                                         ; Loop Select Bit
; bit position masks
mSCI0CR1_PT:        equ    %00000001
mSCI0CR1_PE:        equ    %00000010
mSCI0CR1_ILT:       equ    %00000100
mSCI0CR1_WAKE:      equ    %00001000
mSCI0CR1_M:         equ    %00010000
mSCI0CR1_RSRC:      equ    %00100000
mSCI0CR1_SCISWAI:   equ    %01000000
mSCI0CR1_LOOPS:     equ    %10000000


;*** SCI0CR2 - SCI 0 Control Register 2; 0x000000CB ***
SCI0CR2:            equ    $000000CB                                ;*** SCI0CR2 - SCI 0 Control Register 2; 0x000000CB ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI0CR2_SBK:        equ    0                                         ; Send Break Bit
SCI0CR2_RWU:        equ    1                                         ; Receiver Wakeup Bit
SCI0CR2_RE:         equ    2                                         ; Receiver Enable Bit
SCI0CR2_TE:         equ    3                                         ; Transmitter Enable Bit
SCI0CR2_ILIE:       equ    4                                         ; Idle Line Interrupt Enable Bit
SCI0CR2_RIE:        equ    5                                         ; Receiver Full Interrupt Enable Bit
SCI0CR2_TCIE:       equ    6                                         ; Transmission Complete Interrupt Enable Bit
SCI0CR2_SCTIE:      equ    7                                         ; Transmitter Interrupt Enable Bit
; bit position masks
mSCI0CR2_SBK:       equ    %00000001
mSCI0CR2_RWU:       equ    %00000010
mSCI0CR2_RE:        equ    %00000100
mSCI0CR2_TE:        equ    %00001000
mSCI0CR2_ILIE:      equ    %00010000
mSCI0CR2_RIE:       equ    %00100000
mSCI0CR2_TCIE:      equ    %01000000
mSCI0CR2_SCTIE:     equ    %10000000


;*** SCI0SR1 - SCI 0 Status Register 1; 0x000000CC ***
SCI0SR1:            equ    $000000CC                                ;*** SCI0SR1 - SCI 0 Status Register 1; 0x000000CC ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI0SR1_PF:         equ    0                                         ; Parity Error Flag
SCI0SR1_FE:         equ    1                                         ; Framing Error Flag
SCI0SR1_NF:         equ    2                                         ; Noise Flag
SCI0SR1_OR:         equ    3                                         ; Overrun Flag
SCI0SR1_IDLE:       equ    4                                         ; Idle Line Flag
SCI0SR1_RDRF:       equ    5                                         ; Receive Data Register Full Flag
SCI0SR1_TC:         equ    6                                         ; Transmit Complete Flag
SCI0SR1_TDRE:       equ    7                                         ; Transmit Data Register Empty Flag
; bit position masks
mSCI0SR1_PF:        equ    %00000001
mSCI0SR1_FE:        equ    %00000010
mSCI0SR1_NF:        equ    %00000100
mSCI0SR1_OR:        equ    %00001000
mSCI0SR1_IDLE:      equ    %00010000
mSCI0SR1_RDRF:      equ    %00100000
mSCI0SR1_TC:        equ    %01000000
mSCI0SR1_TDRE:      equ    %10000000


;*** SCI0SR2 - SCI 0 Status Register 2; 0x000000CD ***
SCI0SR2:            equ    $000000CD                                ;*** SCI0SR2 - SCI 0 Status Register 2; 0x000000CD ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI0SR2_RAF:        equ    0                                         ; Receiver Active Flag
SCI0SR2_TXDIR:      equ    1                                         ; Transmitter pin data direction in Single-Wire mode
SCI0SR2_BRK13:      equ    2                                         ; Break Transmit character length
; bit position masks
mSCI0SR2_RAF:       equ    %00000001
mSCI0SR2_TXDIR:     equ    %00000010
mSCI0SR2_BRK13:     equ    %00000100


;*** SCI0DRH - SCI 0 Data Register High; 0x000000CE ***
SCI0DRH:            equ    $000000CE                                ;*** SCI0DRH - SCI 0 Data Register High; 0x000000CE ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI0DRH_T8:         equ    6                                         ; Transmit Bit 8
SCI0DRH_R8:         equ    7                                         ; Received Bit 8
; bit position masks
mSCI0DRH_T8:        equ    %01000000
mSCI0DRH_R8:        equ    %10000000


;*** SCI0DRL - SCI 0 Data Register Low; 0x000000CF ***
SCI0DRL:            equ    $000000CF                                ;*** SCI0DRL - SCI 0 Data Register Low; 0x000000CF ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI0DRL_R0_T0:      equ    0                                         ; Received bit 0 or Transmit bit 0
SCI0DRL_R1_T1:      equ    1                                         ; Received bit 1 or Transmit bit 1
SCI0DRL_R2_T2:      equ    2                                         ; Received bit 2 or Transmit bit 2
SCI0DRL_R3_T3:      equ    3                                         ; Received bit 3 or Transmit bit 3
SCI0DRL_R4_T4:      equ    4                                         ; Received bit 4 or Transmit bit 4
SCI0DRL_R5_T5:      equ    5                                         ; Received bit 5 or Transmit bit 5
SCI0DRL_R6_T6:      equ    6                                         ; Received bit 6 or Transmit bit 6
SCI0DRL_R7_T7:      equ    7                                         ; Received bit 7 or Transmit bit 7
; bit position masks
mSCI0DRL_R0_T0:     equ    %00000001
mSCI0DRL_R1_T1:     equ    %00000010
mSCI0DRL_R2_T2:     equ    %00000100
mSCI0DRL_R3_T3:     equ    %00001000
mSCI0DRL_R4_T4:     equ    %00010000
mSCI0DRL_R5_T5:     equ    %00100000
mSCI0DRL_R6_T6:     equ    %01000000
mSCI0DRL_R7_T7:     equ    %10000000


;*** SCI1BD - SCI 1 Baud Rate Register; 0x000000D0 ***
SCI1BD:             equ    $000000D0                                ;*** SCI1BD - SCI 1 Baud Rate Register; 0x000000D0 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI1BD_SBR0:        equ    0                                         ; SCI Baud Rate Bit 0
SCI1BD_SBR1:        equ    1                                         ; SCI Baud Rate Bit 1
SCI1BD_SBR2:        equ    2                                         ; SCI Baud Rate Bit 2
SCI1BD_SBR3:        equ    3                                         ; SCI Baud Rate Bit 3
SCI1BD_SBR4:        equ    4                                         ; SCI Baud Rate Bit 4
SCI1BD_SBR5:        equ    5                                         ; SCI Baud Rate Bit 5
SCI1BD_SBR6:        equ    6                                         ; SCI Baud Rate Bit 6
SCI1BD_SBR7:        equ    7                                         ; SCI Baud Rate Bit 7
SCI1BD_SBR8:        equ    8                                         ; SCI Baud Rate Bit 8
SCI1BD_SBR9:        equ    9                                         ; SCI Baud Rate Bit 9
SCI1BD_SBR10:       equ    10                                        ; SCI Baud Rate Bit 10
SCI1BD_SBR11:       equ    11                                        ; SCI Baud Rate Bit 11
SCI1BD_SBR12:       equ    12                                        ; SCI Baud Rate Bit 12
; bit position masks
mSCI1BD_SBR0:       equ    %00000001
mSCI1BD_SBR1:       equ    %00000010
mSCI1BD_SBR2:       equ    %00000100
mSCI1BD_SBR3:       equ    %00001000
mSCI1BD_SBR4:       equ    %00010000
mSCI1BD_SBR5:       equ    %00100000
mSCI1BD_SBR6:       equ    %01000000
mSCI1BD_SBR7:       equ    %10000000
mSCI1BD_SBR8:       equ    %100000000
mSCI1BD_SBR9:       equ    %1000000000
mSCI1BD_SBR10:      equ    %10000000000
mSCI1BD_SBR11:      equ    %100000000000
mSCI1BD_SBR12:      equ    %1000000000000


;*** SCI1BDH - SCI 1 Baud Rate Register High; 0x000000D0 ***
SCI1BDH:            equ    $000000D0                                ;*** SCI1BDH - SCI 1 Baud Rate Register High; 0x000000D0 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI1BDH_SBR8:       equ    0                                         ; SCI Baud Rate Bit 8
SCI1BDH_SBR9:       equ    1                                         ; SCI Baud Rate Bit 9
SCI1BDH_SBR10:      equ    2                                         ; SCI Baud Rate Bit 10
SCI1BDH_SBR11:      equ    3                                         ; SCI Baud Rate Bit 11
SCI1BDH_SBR12:      equ    4                                         ; SCI Baud Rate Bit 12
; bit position masks
mSCI1BDH_SBR8:      equ    %00000001
mSCI1BDH_SBR9:      equ    %00000010
mSCI1BDH_SBR10:     equ    %00000100
mSCI1BDH_SBR11:     equ    %00001000
mSCI1BDH_SBR12:     equ    %00010000


;*** SCI1BDL - SCI 1 Baud Rate Register Low; 0x000000D1 ***
SCI1BDL:            equ    $000000D1                                ;*** SCI1BDL - SCI 1 Baud Rate Register Low; 0x000000D1 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI1BDL_SBR0:       equ    0                                         ; SCI Baud Rate Bit 0
SCI1BDL_SBR1:       equ    1                                         ; SCI Baud Rate Bit 1
SCI1BDL_SBR2:       equ    2                                         ; SCI Baud Rate Bit 2
SCI1BDL_SBR3:       equ    3                                         ; SCI Baud Rate Bit 3
SCI1BDL_SBR4:       equ    4                                         ; SCI Baud Rate Bit 4
SCI1BDL_SBR5:       equ    5                                         ; SCI Baud Rate Bit 5
SCI1BDL_SBR6:       equ    6                                         ; SCI Baud Rate Bit 6
SCI1BDL_SBR7:       equ    7                                         ; SCI Baud Rate Bit 7
; bit position masks
mSCI1BDL_SBR0:      equ    %00000001
mSCI1BDL_SBR1:      equ    %00000010
mSCI1BDL_SBR2:      equ    %00000100
mSCI1BDL_SBR3:      equ    %00001000
mSCI1BDL_SBR4:      equ    %00010000
mSCI1BDL_SBR5:      equ    %00100000
mSCI1BDL_SBR6:      equ    %01000000
mSCI1BDL_SBR7:      equ    %10000000


;*** SCI1CR1 - SCI 1 Control Register 1; 0x000000D2 ***
SCI1CR1:            equ    $000000D2                                ;*** SCI1CR1 - SCI 1 Control Register 1; 0x000000D2 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI1CR1_PT:         equ    0                                         ; Parity Type Bit
SCI1CR1_PE:         equ    1                                         ; Parity Enable Bit
SCI1CR1_ILT:        equ    2                                         ; Idle Line Type Bit
SCI1CR1_WAKE:       equ    3                                         ; Wakeup Condition Bit
SCI1CR1_M:          equ    4                                         ; Data Format Mode Bit
SCI1CR1_RSRC:       equ    5                                         ; Receiver Source Bit
SCI1CR1_SCISWAI:    equ    6                                         ; SCI Stop in Wait Mode Bit
SCI1CR1_LOOPS:      equ    7                                         ; Loop Select Bit
; bit position masks
mSCI1CR1_PT:        equ    %00000001
mSCI1CR1_PE:        equ    %00000010
mSCI1CR1_ILT:       equ    %00000100
mSCI1CR1_WAKE:      equ    %00001000
mSCI1CR1_M:         equ    %00010000
mSCI1CR1_RSRC:      equ    %00100000
mSCI1CR1_SCISWAI:   equ    %01000000
mSCI1CR1_LOOPS:     equ    %10000000


;*** SCI1CR2 - SCI 1 Control Register 2; 0x000000D3 ***
SCI1CR2:            equ    $000000D3                                ;*** SCI1CR2 - SCI 1 Control Register 2; 0x000000D3 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI1CR2_SBK:        equ    0                                         ; Send Break Bit
SCI1CR2_RWU:        equ    1                                         ; Receiver Wakeup Bit
SCI1CR2_RE:         equ    2                                         ; Receiver Enable Bit
SCI1CR2_TE:         equ    3                                         ; Transmitter Enable Bit
SCI1CR2_ILIE:       equ    4                                         ; Idle Line Interrupt Enable Bit
SCI1CR2_RIE:        equ    5                                         ; Receiver Full Interrupt Enable Bit
SCI1CR2_TCIE:       equ    6                                         ; Transmission Complete Interrupt Enable Bit
SCI1CR2_SCTIE:      equ    7                                         ; Transmitter Interrupt Enable Bit
; bit position masks
mSCI1CR2_SBK:       equ    %00000001
mSCI1CR2_RWU:       equ    %00000010
mSCI1CR2_RE:        equ    %00000100
mSCI1CR2_TE:        equ    %00001000
mSCI1CR2_ILIE:      equ    %00010000
mSCI1CR2_RIE:       equ    %00100000
mSCI1CR2_TCIE:      equ    %01000000
mSCI1CR2_SCTIE:     equ    %10000000


;*** SCI1SR1 - SCI 1 Status Register 1; 0x000000D4 ***
SCI1SR1:            equ    $000000D4                                ;*** SCI1SR1 - SCI 1 Status Register 1; 0x000000D4 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI1SR1_PF:         equ    0                                         ; Parity Error Flag
SCI1SR1_FE:         equ    1                                         ; Framing Error Flag
SCI1SR1_NF:         equ    2                                         ; Noise Flag
SCI1SR1_OR:         equ    3                                         ; Overrun Flag
SCI1SR1_IDLE:       equ    4                                         ; Idle Line Flag
SCI1SR1_RDRF:       equ    5                                         ; Receive Data Register Full Flag
SCI1SR1_TC:         equ    6                                         ; Transmit Complete Flag
SCI1SR1_TDRE:       equ    7                                         ; Transmit Data Register Empty Flag
; bit position masks
mSCI1SR1_PF:        equ    %00000001
mSCI1SR1_FE:        equ    %00000010
mSCI1SR1_NF:        equ    %00000100
mSCI1SR1_OR:        equ    %00001000
mSCI1SR1_IDLE:      equ    %00010000
mSCI1SR1_RDRF:      equ    %00100000
mSCI1SR1_TC:        equ    %01000000
mSCI1SR1_TDRE:      equ    %10000000


;*** SCI1SR2 - SCI 1 Status Register 2; 0x000000D5 ***
SCI1SR2:            equ    $000000D5                                ;*** SCI1SR2 - SCI 1 Status Register 2; 0x000000D5 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI1SR2_RAF:        equ    0                                         ; Receiver Active Flag
SCI1SR2_TXDIR:      equ    1                                         ; Transmitter pin data direction in Single-Wire mode
SCI1SR2_BRK13:      equ    2                                         ; Break Transmit character length
; bit position masks
mSCI1SR2_RAF:       equ    %00000001
mSCI1SR2_TXDIR:     equ    %00000010
mSCI1SR2_BRK13:     equ    %00000100


;*** SCI1DRH - SCI 1 Data Register High; 0x000000D6 ***
SCI1DRH:            equ    $000000D6                                ;*** SCI1DRH - SCI 1 Data Register High; 0x000000D6 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI1DRH_T8:         equ    6                                         ; Transmit Bit 8
SCI1DRH_R8:         equ    7                                         ; Received Bit 8
; bit position masks
mSCI1DRH_T8:        equ    %01000000
mSCI1DRH_R8:        equ    %10000000


;*** SCI1DRL - SCI 1 Data Register Low; 0x000000D7 ***
SCI1DRL:            equ    $000000D7                                ;*** SCI1DRL - SCI 1 Data Register Low; 0x000000D7 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI1DRL_R0_T0:      equ    0                                         ; Received bit 0 or Transmit bit 0
SCI1DRL_R1_T1:      equ    1                                         ; Received bit 1 or Transmit bit 1
SCI1DRL_R2_T2:      equ    2                                         ; Received bit 2 or Transmit bit 2
SCI1DRL_R3_T3:      equ    3                                         ; Received bit 3 or Transmit bit 3
SCI1DRL_R4_T4:      equ    4                                         ; Received bit 4 or Transmit bit 4
SCI1DRL_R5_T5:      equ    5                                         ; Received bit 5 or Transmit bit 5
SCI1DRL_R6_T6:      equ    6                                         ; Received bit 6 or Transmit bit 6
SCI1DRL_R7_T7:      equ    7                                         ; Received bit 7 or Transmit bit 7
; bit position masks
mSCI1DRL_R0_T0:     equ    %00000001
mSCI1DRL_R1_T1:     equ    %00000010
mSCI1DRL_R2_T2:     equ    %00000100
mSCI1DRL_R3_T3:     equ    %00001000
mSCI1DRL_R4_T4:     equ    %00010000
mSCI1DRL_R5_T5:     equ    %00100000
mSCI1DRL_R6_T6:     equ    %01000000
mSCI1DRL_R7_T7:     equ    %10000000


;*** SPI0CR1 - SPI 0 Control Register; 0x000000D8 ***
SPI0CR1:            equ    $000000D8                                ;*** SPI0CR1 - SPI 0 Control Register; 0x000000D8 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPI0CR1_LSBFE:      equ    0                                         ; SPI LSB-First Enable
SPI0CR1_SSOE:       equ    1                                         ; Slave Select Output Enable
SPI0CR1_CPHA:       equ    2                                         ; SPI Clock Phase Bit
SPI0CR1_CPOL:       equ    3                                         ; SPI Clock Polarity Bit
SPI0CR1_MSTR:       equ    4                                         ; SPI Master/Slave Mode Select Bit
SPI0CR1_SPTIE:      equ    5                                         ; SPI Transmit Interrupt Enable
SPI0CR1_SPE:        equ    6                                         ; SPI System Enable Bit
SPI0CR1_SPIE:       equ    7                                         ; SPI Interrupt Enable Bit
; bit position masks
mSPI0CR1_LSBFE:     equ    %00000001
mSPI0CR1_SSOE:      equ    %00000010
mSPI0CR1_CPHA:      equ    %00000100
mSPI0CR1_CPOL:      equ    %00001000
mSPI0CR1_MSTR:      equ    %00010000
mSPI0CR1_SPTIE:     equ    %00100000
mSPI0CR1_SPE:       equ    %01000000
mSPI0CR1_SPIE:      equ    %10000000


;*** SPI0CR2 - SPI 0 Control Register 2; 0x000000D9 ***
SPI0CR2:            equ    $000000D9                                ;*** SPI0CR2 - SPI 0 Control Register 2; 0x000000D9 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPI0CR2_SPC0:       equ    0                                         ; Serial Pin Control Bit 0
SPI0CR2_SPISWAI:    equ    1                                         ; SPI Stop in Wait Mode Bit
SPI0CR2_BIDIROE:    equ    3                                         ; Output enable in the Bidirectional mode of operation
SPI0CR2_MODFEN:     equ    4                                         ; Mode Fault Enable Bit
; bit position masks
mSPI0CR2_SPC0:      equ    %00000001
mSPI0CR2_SPISWAI:   equ    %00000010
mSPI0CR2_BIDIROE:   equ    %00001000
mSPI0CR2_MODFEN:    equ    %00010000


;*** SPI0BR - SPI 0 Baud Rate Register; 0x000000DA ***
SPI0BR:             equ    $000000DA                                ;*** SPI0BR - SPI 0 Baud Rate Register; 0x000000DA ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPI0BR_SPR0:        equ    0                                         ; SPI Baud Rate Selection Bit 0
SPI0BR_SPR1:        equ    1                                         ; SPI Baud Rate Selection Bit 1
SPI0BR_SPR2:        equ    2                                         ; SPI Baud Rate Selection Bit 2
SPI0BR_SPPR0:       equ    4                                         ; SPI Baud Rate Preselection Bits 0
SPI0BR_SPPR1:       equ    5                                         ; SPI Baud Rate Preselection Bits 1
SPI0BR_SPPR2:       equ    6                                         ; SPI Baud Rate Preselection Bits 2
; bit position masks
mSPI0BR_SPR0:       equ    %00000001
mSPI0BR_SPR1:       equ    %00000010
mSPI0BR_SPR2:       equ    %00000100
mSPI0BR_SPPR0:      equ    %00010000
mSPI0BR_SPPR1:      equ    %00100000
mSPI0BR_SPPR2:      equ    %01000000


;*** SPI0SR - SPI 0 Status Register; 0x000000DB ***
SPI0SR:             equ    $000000DB                                ;*** SPI0SR - SPI 0 Status Register; 0x000000DB ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPI0SR_MODF:        equ    4                                         ; Mode Fault Flag
SPI0SR_SPTEF:       equ    5                                         ; SPI Transmit Empty Interrupt Flag
SPI0SR_SPIF:        equ    7                                         ; SPIF Receive Interrupt Flag
; bit position masks
mSPI0SR_MODF:       equ    %00010000
mSPI0SR_SPTEF:      equ    %00100000
mSPI0SR_SPIF:       equ    %10000000


;*** SPI0DR - SPI 0 Data Register; 0x000000DD ***
SPI0DR:             equ    $000000DD                                ;*** SPI0DR - SPI 0 Data Register; 0x000000DD ***


;*** IBAD - IIC Address Register; 0x000000E0 ***
IBAD:               equ    $000000E0                                ;*** IBAD - IIC Address Register; 0x000000E0 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
IBAD_ADR1:          equ    1                                         ; Slave Address Bit 1
IBAD_ADR2:          equ    2                                         ; Slave Address Bit 2
IBAD_ADR3:          equ    3                                         ; Slave Address Bit 3
IBAD_ADR4:          equ    4                                         ; Slave Address Bit 4
IBAD_ADR5:          equ    5                                         ; Slave Address Bit 5
IBAD_ADR6:          equ    6                                         ; Slave Address Bit 6
IBAD_ADR7:          equ    7                                         ; Slave Address Bit 7
; bit position masks
mIBAD_ADR1:         equ    %00000010
mIBAD_ADR2:         equ    %00000100
mIBAD_ADR3:         equ    %00001000
mIBAD_ADR4:         equ    %00010000
mIBAD_ADR5:         equ    %00100000
mIBAD_ADR6:         equ    %01000000
mIBAD_ADR7:         equ    %10000000


;*** IBFD - IIC Frequency Divider Register; 0x000000E1 ***
IBFD:               equ    $000000E1                                ;*** IBFD - IIC Frequency Divider Register; 0x000000E1 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
IBFD_IBC0:          equ    0                                         ; I-Bus Clock Rate 0
IBFD_IBC1:          equ    1                                         ; I-Bus Clock Rate 1
IBFD_IBC2:          equ    2                                         ; I-Bus Clock Rate 2
IBFD_IBC3:          equ    3                                         ; I-Bus Clock Rate 3
IBFD_IBC4:          equ    4                                         ; I-Bus Clock Rate 4
IBFD_IBC5:          equ    5                                         ; I-Bus Clock Rate 5
IBFD_IBC6:          equ    6                                         ; I-Bus Clock Rate 6
IBFD_IBC7:          equ    7                                         ; I-Bus Clock Rate 7
; bit position masks
mIBFD_IBC0:         equ    %00000001
mIBFD_IBC1:         equ    %00000010
mIBFD_IBC2:         equ    %00000100
mIBFD_IBC3:         equ    %00001000
mIBFD_IBC4:         equ    %00010000
mIBFD_IBC5:         equ    %00100000
mIBFD_IBC6:         equ    %01000000
mIBFD_IBC7:         equ    %10000000


;*** IBCR - IIC Control Register; 0x000000E2 ***
IBCR:               equ    $000000E2                                ;*** IBCR - IIC Control Register; 0x000000E2 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
IBCR_IBSWAI:        equ    0                                         ; I-Bus Interface Stop in WAIT mode
IBCR_RSTA:          equ    2                                         ; Repeat Start
IBCR_TXAK:          equ    3                                         ; Transmit Acknowledge enable
IBCR_TX_RX:         equ    4                                         ; Transmit/Receive mode select bit
IBCR_MS_SL:         equ    5                                         ; Master/Slave mode select bit
IBCR_IBIE:          equ    6                                         ; I-Bus Interrupt Enable
IBCR_IBEN:          equ    7                                         ; I-Bus Enable
; bit position masks
mIBCR_IBSWAI:       equ    %00000001
mIBCR_RSTA:         equ    %00000100
mIBCR_TXAK:         equ    %00001000
mIBCR_TX_RX:        equ    %00010000
mIBCR_MS_SL:        equ    %00100000
mIBCR_IBIE:         equ    %01000000
mIBCR_IBEN:         equ    %10000000


;*** IBSR - IIC Status Register; 0x000000E3 ***
IBSR:               equ    $000000E3                                ;*** IBSR - IIC Status Register; 0x000000E3 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
IBSR_RXAK:          equ    0                                         ; Received Acknowledge
IBSR_IBIF:          equ    1                                         ; I-Bus Interrupt
IBSR_SRW:           equ    2                                         ; Slave Read/Write
IBSR_IBAL:          equ    4                                         ; Arbitration Lost
IBSR_IBB:           equ    5                                         ; Bus busy bit
IBSR_IAAS:          equ    6                                         ; Addressed as a slave bit
IBSR_TCF:           equ    7                                         ; Data transferring bit
; bit position masks
mIBSR_RXAK:         equ    %00000001
mIBSR_IBIF:         equ    %00000010
mIBSR_SRW:          equ    %00000100
mIBSR_IBAL:         equ    %00010000
mIBSR_IBB:          equ    %00100000
mIBSR_IAAS:         equ    %01000000
mIBSR_TCF:          equ    %10000000


;*** IBDR - IIC Data I/O Register; 0x000000E4 ***
IBDR:               equ    $000000E4                                ;*** IBDR - IIC Data I/O Register; 0x000000E4 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
IBDR_D0:            equ    0                                         ; IIC Data Bit 0
IBDR_D1:            equ    1                                         ; IIC Data Bit 1
IBDR_D2:            equ    2                                         ; IIC Data Bit 2
IBDR_D3:            equ    3                                         ; IIC Data Bit 3
IBDR_D4:            equ    4                                         ; IIC Data Bit 4
IBDR_D5:            equ    5                                         ; IIC Data Bit 5
IBDR_D6:            equ    6                                         ; IIC Data Bit 6
IBDR_D7:            equ    7                                         ; IIC Data Bit 7
; bit position masks
mIBDR_D0:           equ    %00000001
mIBDR_D1:           equ    %00000010
mIBDR_D2:           equ    %00000100
mIBDR_D3:           equ    %00001000
mIBDR_D4:           equ    %00010000
mIBDR_D5:           equ    %00100000
mIBDR_D6:           equ    %01000000
mIBDR_D7:           equ    %10000000


;*** SPI1CR1 - SPI 1 Control Register; 0x000000F0 ***
SPI1CR1:            equ    $000000F0                                ;*** SPI1CR1 - SPI 1 Control Register; 0x000000F0 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPI1CR1_LSBFE:      equ    0                                         ; SPI LSB-First Enable
SPI1CR1_SSOE:       equ    1                                         ; Slave Select Output Enable
SPI1CR1_CPHA:       equ    2                                         ; SPI Clock Phase Bit
SPI1CR1_CPOL:       equ    3                                         ; SPI Clock Polarity Bit
SPI1CR1_MSTR:       equ    4                                         ; SPI Master/Slave Mode Select Bit
SPI1CR1_SPTIE:      equ    5                                         ; SPI Transmit Interrupt Enable
SPI1CR1_SPE:        equ    6                                         ; SPI System Enable Bit
SPI1CR1_SPIE:       equ    7                                         ; SPI Interrupt Enable Bit
; bit position masks
mSPI1CR1_LSBFE:     equ    %00000001
mSPI1CR1_SSOE:      equ    %00000010
mSPI1CR1_CPHA:      equ    %00000100
mSPI1CR1_CPOL:      equ    %00001000
mSPI1CR1_MSTR:      equ    %00010000
mSPI1CR1_SPTIE:     equ    %00100000
mSPI1CR1_SPE:       equ    %01000000
mSPI1CR1_SPIE:      equ    %10000000


;*** SPI1CR2 - SPI 1 Control Register 2; 0x000000F1 ***
SPI1CR2:            equ    $000000F1                                ;*** SPI1CR2 - SPI 1 Control Register 2; 0x000000F1 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPI1CR2_SPC0:       equ    0                                         ; Serial Pin Control Bit 0
SPI1CR2_SPISWAI:    equ    1                                         ; SPI Stop in Wait Mode Bit
SPI1CR2_BIDIROE:    equ    3                                         ; Output enable in the Bidirectional mode of operation
SPI1CR2_MODFEN:     equ    4                                         ; Mode Fault Enable Bit
; bit position masks
mSPI1CR2_SPC0:      equ    %00000001
mSPI1CR2_SPISWAI:   equ    %00000010
mSPI1CR2_BIDIROE:   equ    %00001000
mSPI1CR2_MODFEN:    equ    %00010000


;*** SPI1BR - SPI 1 Baud Rate Register; 0x000000F2 ***
SPI1BR:             equ    $000000F2                                ;*** SPI1BR - SPI 1 Baud Rate Register; 0x000000F2 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPI1BR_SPR0:        equ    0                                         ; SPI Baud Rate Selection Bit 0
SPI1BR_SPR1:        equ    1                                         ; SPI Baud Rate Selection Bit 1
SPI1BR_SPR2:        equ    2                                         ; SPI Baud Rate Selection Bit 2
SPI1BR_SPPR0:       equ    4                                         ; SPI Baud Rate Preselection Bits 0
SPI1BR_SPPR1:       equ    5                                         ; SPI Baud Rate Preselection Bits 1
SPI1BR_SPPR2:       equ    6                                         ; SPI Baud Rate Preselection Bits 2
; bit position masks
mSPI1BR_SPR0:       equ    %00000001
mSPI1BR_SPR1:       equ    %00000010
mSPI1BR_SPR2:       equ    %00000100
mSPI1BR_SPPR0:      equ    %00010000
mSPI1BR_SPPR1:      equ    %00100000
mSPI1BR_SPPR2:      equ    %01000000


;*** SPI1SR - SPI 1 Status Register; 0x000000F3 ***
SPI1SR:             equ    $000000F3                                ;*** SPI1SR - SPI 1 Status Register; 0x000000F3 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPI1SR_MODF:        equ    4                                         ; Mode Fault Flag
SPI1SR_SPTEF:       equ    5                                         ; SPI Transmit Empty Interrupt Flag
SPI1SR_SPIF:        equ    7                                         ; SPIF Receive Interrupt Flag
; bit position masks
mSPI1SR_MODF:       equ    %00010000
mSPI1SR_SPTEF:      equ    %00100000
mSPI1SR_SPIF:       equ    %10000000


;*** SPI1DR - SPI 1 Data Register; 0x000000F5 ***
SPI1DR:             equ    $000000F5                                ;*** SPI1DR - SPI 1 Data Register; 0x000000F5 ***


;*** SPI2CR1 - SPI 2 Control Register; 0x000000F8 ***
SPI2CR1:            equ    $000000F8                                ;*** SPI2CR1 - SPI 2 Control Register; 0x000000F8 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPI2CR1_LSBFE:      equ    0                                         ; SPI LSB-First Enable
SPI2CR1_SSOE:       equ    1                                         ; Slave Select Output Enable
SPI2CR1_CPHA:       equ    2                                         ; SPI Clock Phase Bit
SPI2CR1_CPOL:       equ    3                                         ; SPI Clock Polarity Bit
SPI2CR1_MSTR:       equ    4                                         ; SPI Master/Slave Mode Select Bit
SPI2CR1_SPTIE:      equ    5                                         ; SPI Transmit Interrupt Enable
SPI2CR1_SPE:        equ    6                                         ; SPI System Enable Bit
SPI2CR1_SPIE:       equ    7                                         ; SPI Interrupt Enable Bit
; bit position masks
mSPI2CR1_LSBFE:     equ    %00000001
mSPI2CR1_SSOE:      equ    %00000010
mSPI2CR1_CPHA:      equ    %00000100
mSPI2CR1_CPOL:      equ    %00001000
mSPI2CR1_MSTR:      equ    %00010000
mSPI2CR1_SPTIE:     equ    %00100000
mSPI2CR1_SPE:       equ    %01000000
mSPI2CR1_SPIE:      equ    %10000000


;*** SPI2CR2 - SPI 2 Control Register 2; 0x000000F9 ***
SPI2CR2:            equ    $000000F9                                ;*** SPI2CR2 - SPI 2 Control Register 2; 0x000000F9 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPI2CR2_SPC0:       equ    0                                         ; Serial Pin Control Bit 0
SPI2CR2_SPISWAI:    equ    1                                         ; SPI Stop in Wait Mode Bit
SPI2CR2_BIDIROE:    equ    3                                         ; Output enable in the Bidirectional mode of operation
SPI2CR2_MODFEN:     equ    4                                         ; Mode Fault Enable Bit
; bit position masks
mSPI2CR2_SPC0:      equ    %00000001
mSPI2CR2_SPISWAI:   equ    %00000010
mSPI2CR2_BIDIROE:   equ    %00001000
mSPI2CR2_MODFEN:    equ    %00010000


;*** SPI2BR - SPI 2 Baud Rate Register; 0x000000FA ***
SPI2BR:             equ    $000000FA                                ;*** SPI2BR - SPI 2 Baud Rate Register; 0x000000FA ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPI2BR_SPR0:        equ    0                                         ; SPI Baud Rate Selection Bit 0
SPI2BR_SPR1:        equ    1                                         ; SPI Baud Rate Selection Bit 1
SPI2BR_SPR2:        equ    2                                         ; SPI Baud Rate Selection Bit 2
SPI2BR_SPPR0:       equ    4                                         ; SPI Baud Rate Preselection Bits 0
SPI2BR_SPPR1:       equ    5                                         ; SPI Baud Rate Preselection Bits 1
SPI2BR_SPPR2:       equ    6                                         ; SPI Baud Rate Preselection Bits 2
; bit position masks
mSPI2BR_SPR0:       equ    %00000001
mSPI2BR_SPR1:       equ    %00000010
mSPI2BR_SPR2:       equ    %00000100
mSPI2BR_SPPR0:      equ    %00010000
mSPI2BR_SPPR1:      equ    %00100000
mSPI2BR_SPPR2:      equ    %01000000


;*** SPI2SR - SPI 2 Status Register; 0x000000FB ***
SPI2SR:             equ    $000000FB                                ;*** SPI2SR - SPI 2 Status Register; 0x000000FB ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPI2SR_MODF:        equ    4                                         ; Mode Fault Flag
SPI2SR_SPTEF:       equ    5                                         ; SPI Transmit Empty Interrupt Flag
SPI2SR_SPIF:        equ    7                                         ; SPIF Receive Interrupt Flag
; bit position masks
mSPI2SR_MODF:       equ    %00010000
mSPI2SR_SPTEF:      equ    %00100000
mSPI2SR_SPIF:       equ    %10000000


;*** SPI2DR - SPI 2 Data Register; 0x000000FD ***
SPI2DR:             equ    $000000FD                                ;*** SPI2DR - SPI 2 Data Register; 0x000000FD ***


;*** FCLKDIV - Flash Clock Divider Register; 0x00000100 ***
FCLKDIV:            equ    $00000100                                ;*** FCLKDIV - Flash Clock Divider Register; 0x00000100 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FCLKDIV_FDIV0:      equ    0                                         ; Flash Clock Divider Bit 0
FCLKDIV_FDIV1:      equ    1                                         ; Flash Clock Divider Bit 1
FCLKDIV_FDIV2:      equ    2                                         ; Flash Clock Divider Bit 2
FCLKDIV_FDIV3:      equ    3                                         ; Flash Clock Divider Bit 3
FCLKDIV_FDIV4:      equ    4                                         ; Flash Clock Divider Bit 4
FCLKDIV_FDIV5:      equ    5                                         ; Flash Clock Divider Bit 5
FCLKDIV_PRDIV8:     equ    6                                         ; Enable Prescaler by 8
FCLKDIV_FDIVLD:     equ    7                                         ; Flash Clock Divider Loaded
; bit position masks
mFCLKDIV_FDIV0:     equ    %00000001
mFCLKDIV_FDIV1:     equ    %00000010
mFCLKDIV_FDIV2:     equ    %00000100
mFCLKDIV_FDIV3:     equ    %00001000
mFCLKDIV_FDIV4:     equ    %00010000
mFCLKDIV_FDIV5:     equ    %00100000
mFCLKDIV_PRDIV8:    equ    %01000000
mFCLKDIV_FDIVLD:    equ    %10000000


;*** FSEC - Flash Security Register; 0x00000101 ***
FSEC:               equ    $00000101                                ;*** FSEC - Flash Security Register; 0x00000101 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FSEC_SEC0:          equ    0                                         ; Memory security bit 0
FSEC_SEC1:          equ    1                                         ; Memory security bit 1
FSEC_RNV2:          equ    2                                         ; Reserved Non Volatile flag bit 2
FSEC_RNV3:          equ    3                                         ; Reserved Non Volatile flag bit 3
FSEC_RNV4:          equ    4                                         ; Reserved Non Volatile flag bit 4
FSEC_RNV5:          equ    5                                         ; Reserved Non Volatile flag bit 5
FSEC_KEYEN0:        equ    6                                         ; Backdoor Key Security Enable Bit 0
FSEC_KEYEN1:        equ    7                                         ; Backdoor Key Security Enable Bit 1
; bit position masks
mFSEC_SEC0:         equ    %00000001
mFSEC_SEC1:         equ    %00000010
mFSEC_RNV2:         equ    %00000100
mFSEC_RNV3:         equ    %00001000
mFSEC_RNV4:         equ    %00010000
mFSEC_RNV5:         equ    %00100000
mFSEC_KEYEN0:       equ    %01000000
mFSEC_KEYEN1:       equ    %10000000


;*** FTSTMOD - Flash Test Mode Register; 0x00000102 ***
FTSTMOD:            equ    $00000102                                ;*** FTSTMOD - Flash Test Mode Register; 0x00000102 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FTSTMOD_FDFD:       equ    3                                         ; Force Double Fault Detect
FTSTMOD_WRALL:      equ    4                                         ; Write to all register banks
; bit position masks
mFTSTMOD_FDFD:      equ    %00001000
mFTSTMOD_WRALL:     equ    %00010000


;*** FCNFG - Flash Configuration Register; 0x00000103 ***
FCNFG:              equ    $00000103                                ;*** FCNFG - Flash Configuration Register; 0x00000103 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FCNFG_BKSEL:        equ    0                                         ; Register Bank Select
FCNFG_DFDIE:        equ    3                                         ; Double Fault Detect Interrupt Enable
FCNFG_KEYACC:       equ    5                                         ; Enable Security Key Writing
FCNFG_CCIE:         equ    6                                         ; Command Complete Interrupt Enable
FCNFG_CBEIE:        equ    7                                         ; Command Buffers Empty Interrupt Enable
; bit position masks
mFCNFG_BKSEL:       equ    %00000001
mFCNFG_DFDIE:       equ    %00001000
mFCNFG_KEYACC:      equ    %00100000
mFCNFG_CCIE:        equ    %01000000
mFCNFG_CBEIE:       equ    %10000000


;*** FPROT - Flash Protection Register; 0x00000104 ***
FPROT:              equ    $00000104                                ;*** FPROT - Flash Protection Register; 0x00000104 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FPROT_FPLS0:        equ    0                                         ; Flash Protection Lower Address size 0
FPROT_FPLS1:        equ    1                                         ; Flash Protection Lower Address size 1
FPROT_FPLDIS:       equ    2                                         ; Flash Protection Lower address range disable
FPROT_FPHS0:        equ    3                                         ; Flash Protection Higher address size 0
FPROT_FPHS1:        equ    4                                         ; Flash Protection Higher address size 1
FPROT_FPHDIS:       equ    5                                         ; Flash Protection Higher address range disable
FPROT_RNV6:         equ    6                                         ; Reserved Non Volatile Flag Bit
FPROT_FPOPEN:       equ    7                                         ; Opens the flash block or subsections of it for program or erase
; bit position masks
mFPROT_FPLS0:       equ    %00000001
mFPROT_FPLS1:       equ    %00000010
mFPROT_FPLDIS:      equ    %00000100
mFPROT_FPHS0:       equ    %00001000
mFPROT_FPHS1:       equ    %00010000
mFPROT_FPHDIS:      equ    %00100000
mFPROT_RNV6:        equ    %01000000
mFPROT_FPOPEN:      equ    %10000000


;*** FSTAT - Flash Status Register; 0x00000105 ***
FSTAT:              equ    $00000105                                ;*** FSTAT - Flash Status Register; 0x00000105 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FSTAT_BLANK:        equ    2                                         ; Blank Verify Flag
FSTAT_DFDIF:        equ    3                                         ; Double Fault Detect Interrupt Flag
FSTAT_ACCERR:       equ    4                                         ; Access error
FSTAT_PVIOL:        equ    5                                         ; Protection violation
FSTAT_CCIF:         equ    6                                         ; Command Complete Interrupt Flag
FSTAT_CBEIF:        equ    7                                         ; Command Buffers Empty Interrupt Flag
; bit position masks
mFSTAT_BLANK:       equ    %00000100
mFSTAT_DFDIF:       equ    %00001000
mFSTAT_ACCERR:      equ    %00010000
mFSTAT_PVIOL:       equ    %00100000
mFSTAT_CCIF:        equ    %01000000
mFSTAT_CBEIF:       equ    %10000000


;*** FCMD - Flash Command Buffer and Register; 0x00000106 ***
FCMD:               equ    $00000106                                ;*** FCMD - Flash Command Buffer and Register; 0x00000106 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FCMD_CMDB0:         equ    0                                         ; Flash Command Bit 0
FCMD_CMDB1:         equ    1                                         ; Flash Command Bit 1
FCMD_CMDB2:         equ    2                                         ; Flash Command Bit 2
FCMD_CMDB3:         equ    3                                         ; Flash Command Bit 3
FCMD_CMDB4:         equ    4                                         ; Flash Command Bit 4
FCMD_CMDB5:         equ    5                                         ; Flash Command Bit 5
FCMD_CMDB6:         equ    6                                         ; Flash Command Bit 6
; bit position masks
mFCMD_CMDB0:        equ    %00000001
mFCMD_CMDB1:        equ    %00000010
mFCMD_CMDB2:        equ    %00000100
mFCMD_CMDB3:        equ    %00001000
mFCMD_CMDB4:        equ    %00010000
mFCMD_CMDB5:        equ    %00100000
mFCMD_CMDB6:        equ    %01000000


;*** FCTL - Flash Control Register; 0x00000107 ***
FCTL:               equ    $00000107                                ;*** FCTL - Flash Control Register; 0x00000107 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FCTL_NV0:           equ    0                                         ; Non-Volatile Bit 0
FCTL_NV1:           equ    1                                         ; Non-Volatile Bit 1
FCTL_NV2:           equ    2                                         ; Non-Volatile Bit 2
FCTL_NV3:           equ    3                                         ; Non-Volatile Bit 3
FCTL_NV4:           equ    4                                         ; Non-Volatile Bit 4
FCTL_NV5:           equ    5                                         ; Non-Volatile Bit 5
FCTL_NV6:           equ    6                                         ; Non-Volatile Bit 6
FCTL_NV7:           equ    7                                         ; Non-Volatile Bit 7
; bit position masks
mFCTL_NV0:          equ    %00000001
mFCTL_NV1:          equ    %00000010
mFCTL_NV2:          equ    %00000100
mFCTL_NV3:          equ    %00001000
mFCTL_NV4:          equ    %00010000
mFCTL_NV5:          equ    %00100000
mFCTL_NV6:          equ    %01000000
mFCTL_NV7:          equ    %10000000


;*** FADDR - Flash Address Register; 0x00000108 ***
FADDR:              equ    $00000108                                ;*** FADDR - Flash Address Register; 0x00000108 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FADDR_FADDRLO0:     equ    0                                         ; Flash Address Low Bit 0
FADDR_FADDRLO1:     equ    1                                         ; Flash Address Low Bit 1
FADDR_FADDRLO2:     equ    2                                         ; Flash Address Low Bit 2
FADDR_FADDRLO3:     equ    3                                         ; Flash Address Low Bit 3
FADDR_FADDRLO4:     equ    4                                         ; Flash Address Low Bit 4
FADDR_FADDRLO5:     equ    5                                         ; Flash Address Low Bit 5
FADDR_FADDRLO6:     equ    6                                         ; Flash Address Low Bit 6
FADDR_FADDRLO7:     equ    7                                         ; Flash Address Low Bit 7
FADDR_FADDRHI8:     equ    8                                         ; Flash Address High Bit 8
FADDR_FADDRHI9:     equ    9                                         ; Flash Address High Bit 9
FADDR_FADDRHI10:    equ    10                                        ; Flash Address High Bit 10
FADDR_FADDRHI11:    equ    11                                        ; Flash Address High Bit 11
FADDR_FADDRHI12:    equ    12                                        ; Flash Address High Bit 12
FADDR_FADDRHI13:    equ    13                                        ; Flash Address High Bit 13
FADDR_FADDRHI14:    equ    14                                        ; Flash Address High Bit 14
FADDR_FADDRHI15:    equ    15                                        ; Flash Address High Bit 15
; bit position masks
mFADDR_FADDRLO0:    equ    %00000001
mFADDR_FADDRLO1:    equ    %00000010
mFADDR_FADDRLO2:    equ    %00000100
mFADDR_FADDRLO3:    equ    %00001000
mFADDR_FADDRLO4:    equ    %00010000
mFADDR_FADDRLO5:    equ    %00100000
mFADDR_FADDRLO6:    equ    %01000000
mFADDR_FADDRLO7:    equ    %10000000
mFADDR_FADDRHI8:    equ    %100000000
mFADDR_FADDRHI9:    equ    %1000000000
mFADDR_FADDRHI10:   equ    %10000000000
mFADDR_FADDRHI11:   equ    %100000000000
mFADDR_FADDRHI12:   equ    %1000000000000
mFADDR_FADDRHI13:   equ    %10000000000000
mFADDR_FADDRHI14:   equ    %100000000000000
mFADDR_FADDRHI15:   equ    %1000000000000000


;*** FADDRHI - Flash Address High Register; 0x00000108 ***
FADDRHI:            equ    $00000108                                ;*** FADDRHI - Flash Address High Register; 0x00000108 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FADDRHI_FADDRHI8:   equ    0                                         ; Flash Address High Bit 8
FADDRHI_FADDRHI9:   equ    1                                         ; Flash Address High Bit 9
FADDRHI_FADDRHI10:  equ    2                                         ; Flash Address High Bit 10
FADDRHI_FADDRHI11:  equ    3                                         ; Flash Address High Bit 11
FADDRHI_FADDRHI12:  equ    4                                         ; Flash Address High Bit 12
FADDRHI_FADDRHI13:  equ    5                                         ; Flash Address High Bit 13
FADDRHI_FADDRHI14:  equ    6                                         ; Flash Address High Bit 14
FADDRHI_FADDRHI15:  equ    7                                         ; Flash Address High Bit 15
; bit position masks
mFADDRHI_FADDRHI8:  equ    %00000001
mFADDRHI_FADDRHI9:  equ    %00000010
mFADDRHI_FADDRHI10: equ    %00000100
mFADDRHI_FADDRHI11: equ    %00001000
mFADDRHI_FADDRHI12: equ    %00010000
mFADDRHI_FADDRHI13: equ    %00100000
mFADDRHI_FADDRHI14: equ    %01000000
mFADDRHI_FADDRHI15: equ    %10000000


;*** FADDRLO - Flash Address Low Register; 0x00000109 ***
FADDRLO:            equ    $00000109                                ;*** FADDRLO - Flash Address Low Register; 0x00000109 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FADDRLO_FADDRLO0:   equ    0                                         ; Flash Address Low Bit 0
FADDRLO_FADDRLO1:   equ    1                                         ; Flash Address Low Bit 1
FADDRLO_FADDRLO2:   equ    2                                         ; Flash Address Low Bit 2
FADDRLO_FADDRLO3:   equ    3                                         ; Flash Address Low Bit 3
FADDRLO_FADDRLO4:   equ    4                                         ; Flash Address Low Bit 4
FADDRLO_FADDRLO5:   equ    5                                         ; Flash Address Low Bit 5
FADDRLO_FADDRLO6:   equ    6                                         ; Flash Address Low Bit 6
FADDRLO_FADDRLO7:   equ    7                                         ; Flash Address Low Bit 7
; bit position masks
mFADDRLO_FADDRLO0:  equ    %00000001
mFADDRLO_FADDRLO1:  equ    %00000010
mFADDRLO_FADDRLO2:  equ    %00000100
mFADDRLO_FADDRLO3:  equ    %00001000
mFADDRLO_FADDRLO4:  equ    %00010000
mFADDRLO_FADDRLO5:  equ    %00100000
mFADDRLO_FADDRLO6:  equ    %01000000
mFADDRLO_FADDRLO7:  equ    %10000000


;*** FDATA - Flash Data Register; 0x0000010A ***
FDATA:              equ    $0000010A                                ;*** FDATA - Flash Data Register; 0x0000010A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FDATA_FDATALO0:     equ    0                                         ; Flash Data Low Bit 0
FDATA_FDATALO1:     equ    1                                         ; Flash Data Low Bit 1
FDATA_FDATALO2:     equ    2                                         ; Flash Data Low Bit 2
FDATA_FDATALO3:     equ    3                                         ; Flash Data Low Bit 3
FDATA_FDATALO4:     equ    4                                         ; Flash Data Low Bit 4
FDATA_FDATALO5:     equ    5                                         ; Flash Data Low Bit 5
FDATA_FDATALO6:     equ    6                                         ; Flash Data Low Bit 6
FDATA_FDATALO7:     equ    7                                         ; Flash Data Low Bit 7
FDATA_FDATAHI8:     equ    8                                         ; Flash Data High Bit 8
FDATA_FDATAHI9:     equ    9                                         ; Flash Data High Bit 9
FDATA_FDATAHI10:    equ    10                                        ; Flash Data High Bit 10
FDATA_FDATAHI11:    equ    11                                        ; Flash Data High Bit 11
FDATA_FDATAHI12:    equ    12                                        ; Flash Data High Bit 12
FDATA_FDATAHI13:    equ    13                                        ; Flash Data High Bit 13
FDATA_FDATAHI14:    equ    14                                        ; Flash Data High Bit 14
FDATA_FDATAHI15:    equ    15                                        ; Flash Data High Bit 15
; bit position masks
mFDATA_FDATALO0:    equ    %00000001
mFDATA_FDATALO1:    equ    %00000010
mFDATA_FDATALO2:    equ    %00000100
mFDATA_FDATALO3:    equ    %00001000
mFDATA_FDATALO4:    equ    %00010000
mFDATA_FDATALO5:    equ    %00100000
mFDATA_FDATALO6:    equ    %01000000
mFDATA_FDATALO7:    equ    %10000000
mFDATA_FDATAHI8:    equ    %100000000
mFDATA_FDATAHI9:    equ    %1000000000
mFDATA_FDATAHI10:   equ    %10000000000
mFDATA_FDATAHI11:   equ    %100000000000
mFDATA_FDATAHI12:   equ    %1000000000000
mFDATA_FDATAHI13:   equ    %10000000000000
mFDATA_FDATAHI14:   equ    %100000000000000
mFDATA_FDATAHI15:   equ    %1000000000000000


;*** FDATAHI - Flash Data High Register; 0x0000010A ***
FDATAHI:            equ    $0000010A                                ;*** FDATAHI - Flash Data High Register; 0x0000010A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FDATAHI_FDATAHI8:   equ    0                                         ; Flash Data High Bit 8
FDATAHI_FDATAHI9:   equ    1                                         ; Flash Data High Bit 9
FDATAHI_FDATAHI10:  equ    2                                         ; Flash Data High Bit 10
FDATAHI_FDATAHI11:  equ    3                                         ; Flash Data High Bit 11
FDATAHI_FDATAHI12:  equ    4                                         ; Flash Data High Bit 12
FDATAHI_FDATAHI13:  equ    5                                         ; Flash Data High Bit 13
FDATAHI_FDATAHI14:  equ    6                                         ; Flash Data High Bit 14
FDATAHI_FDATAHI15:  equ    7                                         ; Flash Data High Bit 15
; bit position masks
mFDATAHI_FDATAHI8:  equ    %00000001
mFDATAHI_FDATAHI9:  equ    %00000010
mFDATAHI_FDATAHI10: equ    %00000100
mFDATAHI_FDATAHI11: equ    %00001000
mFDATAHI_FDATAHI12: equ    %00010000
mFDATAHI_FDATAHI13: equ    %00100000
mFDATAHI_FDATAHI14: equ    %01000000
mFDATAHI_FDATAHI15: equ    %10000000


;*** FDATALO - Flash Data Low Register; 0x0000010B ***
FDATALO:            equ    $0000010B                                ;*** FDATALO - Flash Data Low Register; 0x0000010B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FDATALO_FDATALO0:   equ    0                                         ; Flash Data Low Bit 0
FDATALO_FDATALO1:   equ    1                                         ; Flash Data Low Bit 1
FDATALO_FDATALO2:   equ    2                                         ; Flash Data Low Bit 2
FDATALO_FDATALO3:   equ    3                                         ; Flash Data Low Bit 3
FDATALO_FDATALO4:   equ    4                                         ; Flash Data Low Bit 4
FDATALO_FDATALO5:   equ    5                                         ; Flash Data Low Bit 5
FDATALO_FDATALO6:   equ    6                                         ; Flash Data Low Bit 6
FDATALO_FDATALO7:   equ    7                                         ; Flash Data Low Bit 7
; bit position masks
mFDATALO_FDATALO0:  equ    %00000001
mFDATALO_FDATALO1:  equ    %00000010
mFDATALO_FDATALO2:  equ    %00000100
mFDATALO_FDATALO3:  equ    %00001000
mFDATALO_FDATALO4:  equ    %00010000
mFDATALO_FDATALO5:  equ    %00100000
mFDATALO_FDATALO6:  equ    %01000000
mFDATALO_FDATALO7:  equ    %10000000


;*** ECLKDIV - EEPROM Clock Divider Register; 0x00000110 ***
ECLKDIV:            equ    $00000110                                ;*** ECLKDIV - EEPROM Clock Divider Register; 0x00000110 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ECLKDIV_EDIV0:      equ    0                                         ; EEPROM Clock Divider 0
ECLKDIV_EDIV1:      equ    1                                         ; EEPROM Clock Divider 1
ECLKDIV_EDIV2:      equ    2                                         ; EEPROM Clock Divider 2
ECLKDIV_EDIV3:      equ    3                                         ; EEPROM Clock Divider 3
ECLKDIV_EDIV4:      equ    4                                         ; EEPROM Clock Divider 4
ECLKDIV_EDIV5:      equ    5                                         ; EEPROM Clock Divider 5
ECLKDIV_PRDIV8:     equ    6                                         ; Enable Prescaler by 8
ECLKDIV_EDIVLD:     equ    7                                         ; EEPROM Clock Divider Loaded
; bit position masks
mECLKDIV_EDIV0:     equ    %00000001
mECLKDIV_EDIV1:     equ    %00000010
mECLKDIV_EDIV2:     equ    %00000100
mECLKDIV_EDIV3:     equ    %00001000
mECLKDIV_EDIV4:     equ    %00010000
mECLKDIV_EDIV5:     equ    %00100000
mECLKDIV_PRDIV8:    equ    %01000000
mECLKDIV_EDIVLD:    equ    %10000000


;*** ECNFG - EEPROM Configuration Register; 0x00000113 ***
ECNFG:              equ    $00000113                                ;*** ECNFG - EEPROM Configuration Register; 0x00000113 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ECNFG_CCIE:         equ    6                                         ; Command Complete Interrupt Enable
ECNFG_CBEIE:        equ    7                                         ; Command Buffers Empty Interrupt Enable
; bit position masks
mECNFG_CCIE:        equ    %01000000
mECNFG_CBEIE:       equ    %10000000


;*** EPROT - EEPROM Protection Register; 0x00000114 ***
EPROT:              equ    $00000114                                ;*** EPROT - EEPROM Protection Register; 0x00000114 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
EPROT_EP0:          equ    0                                         ; EEPROM Protection address size 0
EPROT_EP1:          equ    1                                         ; EEPROM Protection address size 1
EPROT_EP2:          equ    2                                         ; EEPROM Protection address size 2
EPROT_EPDIS:        equ    3                                         ; EEPROM Protection disable
EPROT_NV4:          equ    4                                         ; Non Volatile Flag Bit 4
EPROT_NV5:          equ    5                                         ; Non Volatile Flag Bit 5
EPROT_NV6:          equ    6                                         ; Non Volatile Flag Bit 6
EPROT_EPOPEN:       equ    7                                         ; Opens the EEPROM block or a subsection of it for program or erase
; bit position masks
mEPROT_EP0:         equ    %00000001
mEPROT_EP1:         equ    %00000010
mEPROT_EP2:         equ    %00000100
mEPROT_EPDIS:       equ    %00001000
mEPROT_NV4:         equ    %00010000
mEPROT_NV5:         equ    %00100000
mEPROT_NV6:         equ    %01000000
mEPROT_EPOPEN:      equ    %10000000


;*** ESTAT - EEPROM Status Register; 0x00000115 ***
ESTAT:              equ    $00000115                                ;*** ESTAT - EEPROM Status Register; 0x00000115 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ESTAT_BLANK:        equ    2                                         ; Blank Verify Flag
ESTAT_ACCERR:       equ    4                                         ; Access error
ESTAT_PVIOL:        equ    5                                         ; Protection violation
ESTAT_CCIF:         equ    6                                         ; Command Complete Interrupt Flag
ESTAT_CBEIF:        equ    7                                         ; Command Buffer Empty Interrupt Flag
; bit position masks
mESTAT_BLANK:       equ    %00000100
mESTAT_ACCERR:      equ    %00010000
mESTAT_PVIOL:       equ    %00100000
mESTAT_CCIF:        equ    %01000000
mESTAT_CBEIF:       equ    %10000000


;*** ECMD - EEPROM Command Buffer and Register; 0x00000116 ***
ECMD:               equ    $00000116                                ;*** ECMD - EEPROM Command Buffer and Register; 0x00000116 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ECMD_CMDB0:         equ    0                                         ; EEPROM User Mode Command 0
ECMD_CMDB2:         equ    2                                         ; EEPROM User Mode Command 2
ECMD_CMDB5:         equ    5                                         ; EEPROM User Mode Command 5
ECMD_CMDB6:         equ    6                                         ; EEPROM User Mode Command 6
; bit position masks
mECMD_CMDB0:        equ    %00000001
mECMD_CMDB2:        equ    %00000100
mECMD_CMDB5:        equ    %00100000
mECMD_CMDB6:        equ    %01000000


;*** ATD1CTL01 - ATD 1 Control Register 01; 0x00000120 ***
ATD1CTL01:          equ    $00000120                                ;*** ATD1CTL01 - ATD 1 Control Register 01; 0x00000120 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD1CTL01_ETRIGCH0: equ    0                                         ; External Trigger Channel Select Bit 0
ATD1CTL01_ETRIGCH1: equ    1                                         ; External Trigger Channel Select Bit 1
ATD1CTL01_ETRIGCH2: equ    2                                         ; External Trigger Channel Select Bit 2
ATD1CTL01_ETRIGSEL: equ    7                                         ; External Trigger Source Select
ATD1CTL01_WRAP0:    equ    8                                         ; Wrap Around Channel Select Bit 0
ATD1CTL01_WRAP1:    equ    9                                         ; Wrap Around Channel Select Bit 1
ATD1CTL01_WRAP2:    equ    10                                        ; Wrap Around Channel Select Bit 2
; bit position masks
mATD1CTL01_ETRIGCH0: equ    %00000001
mATD1CTL01_ETRIGCH1: equ    %00000010
mATD1CTL01_ETRIGCH2: equ    %00000100
mATD1CTL01_ETRIGSEL: equ    %10000000
mATD1CTL01_WRAP0:   equ    %100000000
mATD1CTL01_WRAP1:   equ    %1000000000
mATD1CTL01_WRAP2:   equ    %10000000000


;*** ATD1CTL0 - ATD 1 Control Register 0; 0x00000120 ***
ATD1CTL0:           equ    $00000120                                ;*** ATD1CTL0 - ATD 1 Control Register 0; 0x00000120 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD1CTL0_WRAP0:     equ    0                                         ; Wrap Around Channel Select Bit 0
ATD1CTL0_WRAP1:     equ    1                                         ; Wrap Around Channel Select Bit 1
ATD1CTL0_WRAP2:     equ    2                                         ; Wrap Around Channel Select Bit 2
; bit position masks
mATD1CTL0_WRAP0:    equ    %00000001
mATD1CTL0_WRAP1:    equ    %00000010
mATD1CTL0_WRAP2:    equ    %00000100


;*** ATD1CTL1 - ATD1 Control Register 1; 0x00000121 ***
ATD1CTL1:           equ    $00000121                                ;*** ATD1CTL1 - ATD1 Control Register 1; 0x00000121 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD1CTL1_ETRIGCH0:  equ    0                                         ; External Trigger Channel Select Bit 0
ATD1CTL1_ETRIGCH1:  equ    1                                         ; External Trigger Channel Select Bit 1
ATD1CTL1_ETRIGCH2:  equ    2                                         ; External Trigger Channel Select Bit 2
ATD1CTL1_ETRIGSEL:  equ    7                                         ; External Trigger Source Select
; bit position masks
mATD1CTL1_ETRIGCH0: equ    %00000001
mATD1CTL1_ETRIGCH1: equ    %00000010
mATD1CTL1_ETRIGCH2: equ    %00000100
mATD1CTL1_ETRIGSEL: equ    %10000000


;*** ATD1CTL23 - ATD 1 Control Register 23; 0x00000122 ***
ATD1CTL23:          equ    $00000122                                ;*** ATD1CTL23 - ATD 1 Control Register 23; 0x00000122 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD1CTL23_FRZ0:     equ    0                                         ; Background Debug Freeze Enable Bit 0
ATD1CTL23_FRZ1:     equ    1                                         ; Background Debug Freeze Enable Bit 1
ATD1CTL23_FIFO:     equ    2                                         ; Result Register FIFO Mode
ATD1CTL23_S1C:      equ    3                                         ; Conversion Sequence Length 1
ATD1CTL23_S2C:      equ    4                                         ; Conversion Sequence Length 2
ATD1CTL23_S4C:      equ    5                                         ; Conversion Sequence Length 4
ATD1CTL23_S8C:      equ    6                                         ; Conversion Sequence Length 8
ATD1CTL23_ASCIF:    equ    8                                         ; ATD 1 Sequence Complete Interrupt Flag
ATD1CTL23_ASCIE:    equ    9                                         ; ATD 1 Sequence Complete Interrupt Enable
ATD1CTL23_ETRIGE:   equ    10                                        ; External Trigger Mode enable
ATD1CTL23_ETRIGP:   equ    11                                        ; External Trigger Polarity
ATD1CTL23_ETRIGLE:  equ    12                                        ; External Trigger Level/Edge control
ATD1CTL23_AWAI:     equ    13                                        ; ATD Power Down in Wait Mode
ATD1CTL23_AFFC:     equ    14                                        ; ATD Fast Conversion Complete Flag Clear
ATD1CTL23_ADPU:     equ    15                                        ; ATD Disable / Power Down
; bit position masks
mATD1CTL23_FRZ0:    equ    %00000001
mATD1CTL23_FRZ1:    equ    %00000010
mATD1CTL23_FIFO:    equ    %00000100
mATD1CTL23_S1C:     equ    %00001000
mATD1CTL23_S2C:     equ    %00010000
mATD1CTL23_S4C:     equ    %00100000
mATD1CTL23_S8C:     equ    %01000000
mATD1CTL23_ASCIF:   equ    %100000000
mATD1CTL23_ASCIE:   equ    %1000000000
mATD1CTL23_ETRIGE:  equ    %10000000000
mATD1CTL23_ETRIGP:  equ    %100000000000
mATD1CTL23_ETRIGLE: equ    %1000000000000
mATD1CTL23_AWAI:    equ    %10000000000000
mATD1CTL23_AFFC:    equ    %100000000000000
mATD1CTL23_ADPU:    equ    %1000000000000000


;*** ATD1CTL2 - ATD 1 Control Register 2; 0x00000122 ***
ATD1CTL2:           equ    $00000122                                ;*** ATD1CTL2 - ATD 1 Control Register 2; 0x00000122 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD1CTL2_ASCIF:     equ    0                                         ; ATD 1 Sequence Complete Interrupt Flag
ATD1CTL2_ASCIE:     equ    1                                         ; ATD 1 Sequence Complete Interrupt Enable
ATD1CTL2_ETRIGE:    equ    2                                         ; External Trigger Mode enable
ATD1CTL2_ETRIGP:    equ    3                                         ; External Trigger Polarity
ATD1CTL2_ETRIGLE:   equ    4                                         ; External Trigger Level/Edge control
ATD1CTL2_AWAI:      equ    5                                         ; ATD Power Down in Wait Mode
ATD1CTL2_AFFC:      equ    6                                         ; ATD Fast Conversion Complete Flag Clear
ATD1CTL2_ADPU:      equ    7                                         ; ATD Disable / Power Down
; bit position masks
mATD1CTL2_ASCIF:    equ    %00000001
mATD1CTL2_ASCIE:    equ    %00000010
mATD1CTL2_ETRIGE:   equ    %00000100
mATD1CTL2_ETRIGP:   equ    %00001000
mATD1CTL2_ETRIGLE:  equ    %00010000
mATD1CTL2_AWAI:     equ    %00100000
mATD1CTL2_AFFC:     equ    %01000000
mATD1CTL2_ADPU:     equ    %10000000


;*** ATD1CTL3 - ATD 1 Control Register 3; 0x00000123 ***
ATD1CTL3:           equ    $00000123                                ;*** ATD1CTL3 - ATD 1 Control Register 3; 0x00000123 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD1CTL3_FRZ0:      equ    0                                         ; Background Debug Freeze Enable Bit 0
ATD1CTL3_FRZ1:      equ    1                                         ; Background Debug Freeze Enable Bit 1
ATD1CTL3_FIFO:      equ    2                                         ; Result Register FIFO Mode
ATD1CTL3_S1C:       equ    3                                         ; Conversion Sequence Length 1
ATD1CTL3_S2C:       equ    4                                         ; Conversion Sequence Length 2
ATD1CTL3_S4C:       equ    5                                         ; Conversion Sequence Length 4
ATD1CTL3_S8C:       equ    6                                         ; Conversion Sequence Length 8
; bit position masks
mATD1CTL3_FRZ0:     equ    %00000001
mATD1CTL3_FRZ1:     equ    %00000010
mATD1CTL3_FIFO:     equ    %00000100
mATD1CTL3_S1C:      equ    %00001000
mATD1CTL3_S2C:      equ    %00010000
mATD1CTL3_S4C:      equ    %00100000
mATD1CTL3_S8C:      equ    %01000000


;*** ATD1CTL45 - ATD 1 Control Register 45; 0x00000124 ***
ATD1CTL45:          equ    $00000124                                ;*** ATD1CTL45 - ATD 1 Control Register 45; 0x00000124 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD1CTL45_CA:       equ    0                                         ; Analog Input Channel Select Code A
ATD1CTL45_CB:       equ    1                                         ; Analog Input Channel Select Code B
ATD1CTL45_CC:       equ    2                                         ; Analog Input Channel Select Code C
ATD1CTL45_MULT:     equ    4                                         ; Multi-Channel Sample Mode
ATD1CTL45_SCAN:     equ    5                                         ; Continuous Conversion Sequence Mode
ATD1CTL45_DSGN:     equ    6                                         ; Signed/Unsigned Result Data Mode
ATD1CTL45_DJM:      equ    7                                         ; Result Register Data Justification Mode
ATD1CTL45_PRS0:     equ    8                                         ; ATD Clock Prescaler 0
ATD1CTL45_PRS1:     equ    9                                         ; ATD Clock Prescaler 1
ATD1CTL45_PRS2:     equ    10                                        ; ATD Clock Prescaler 2
ATD1CTL45_PRS3:     equ    11                                        ; ATD Clock Prescaler 3
ATD1CTL45_PRS4:     equ    12                                        ; ATD Clock Prescaler 4
ATD1CTL45_SMP0:     equ    13                                        ; Sample Time Select 0
ATD1CTL45_SMP1:     equ    14                                        ; Sample Time Select 1
ATD1CTL45_SRES8:    equ    15                                        ; ATD Resolution Select
; bit position masks
mATD1CTL45_CA:      equ    %00000001
mATD1CTL45_CB:      equ    %00000010
mATD1CTL45_CC:      equ    %00000100
mATD1CTL45_MULT:    equ    %00010000
mATD1CTL45_SCAN:    equ    %00100000
mATD1CTL45_DSGN:    equ    %01000000
mATD1CTL45_DJM:     equ    %10000000
mATD1CTL45_PRS0:    equ    %100000000
mATD1CTL45_PRS1:    equ    %1000000000
mATD1CTL45_PRS2:    equ    %10000000000
mATD1CTL45_PRS3:    equ    %100000000000
mATD1CTL45_PRS4:    equ    %1000000000000
mATD1CTL45_SMP0:    equ    %10000000000000
mATD1CTL45_SMP1:    equ    %100000000000000
mATD1CTL45_SRES8:   equ    %1000000000000000


;*** ATD1CTL4 - ATD 1 Control Register 4; 0x00000124 ***
ATD1CTL4:           equ    $00000124                                ;*** ATD1CTL4 - ATD 1 Control Register 4; 0x00000124 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD1CTL4_PRS0:      equ    0                                         ; ATD Clock Prescaler 0
ATD1CTL4_PRS1:      equ    1                                         ; ATD Clock Prescaler 1
ATD1CTL4_PRS2:      equ    2                                         ; ATD Clock Prescaler 2
ATD1CTL4_PRS3:      equ    3                                         ; ATD Clock Prescaler 3
ATD1CTL4_PRS4:      equ    4                                         ; ATD Clock Prescaler 4
ATD1CTL4_SMP0:      equ    5                                         ; Sample Time Select 0
ATD1CTL4_SMP1:      equ    6                                         ; Sample Time Select 1
ATD1CTL4_SRES8:     equ    7                                         ; ATD Resolution Select
; bit position masks
mATD1CTL4_PRS0:     equ    %00000001
mATD1CTL4_PRS1:     equ    %00000010
mATD1CTL4_PRS2:     equ    %00000100
mATD1CTL4_PRS3:     equ    %00001000
mATD1CTL4_PRS4:     equ    %00010000
mATD1CTL4_SMP0:     equ    %00100000
mATD1CTL4_SMP1:     equ    %01000000
mATD1CTL4_SRES8:    equ    %10000000


;*** ATD1CTL5 - ATD 1 Control Register 5; 0x00000125 ***
ATD1CTL5:           equ    $00000125                                ;*** ATD1CTL5 - ATD 1 Control Register 5; 0x00000125 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD1CTL5_CA:        equ    0                                         ; Analog Input Channel Select Code A
ATD1CTL5_CB:        equ    1                                         ; Analog Input Channel Select Code B
ATD1CTL5_CC:        equ    2                                         ; Analog Input Channel Select Code C
ATD1CTL5_MULT:      equ    4                                         ; Multi-Channel Sample Mode
ATD1CTL5_SCAN:      equ    5                                         ; Continuous Conversion Sequence Mode
ATD1CTL5_DSGN:      equ    6                                         ; Signed/Unsigned Result Data Mode
ATD1CTL5_DJM:       equ    7                                         ; Result Register Data Justification Mode
; bit position masks
mATD1CTL5_CA:       equ    %00000001
mATD1CTL5_CB:       equ    %00000010
mATD1CTL5_CC:       equ    %00000100
mATD1CTL5_MULT:     equ    %00010000
mATD1CTL5_SCAN:     equ    %00100000
mATD1CTL5_DSGN:     equ    %01000000
mATD1CTL5_DJM:      equ    %10000000


;*** ATD1STAT0 - ATD 1 Status Register 0; 0x00000126 ***
ATD1STAT0:          equ    $00000126                                ;*** ATD1STAT0 - ATD 1 Status Register 0; 0x00000126 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD1STAT0_CC0:      equ    0                                         ; Conversion Counter 0
ATD1STAT0_CC1:      equ    1                                         ; Conversion Counter 1
ATD1STAT0_CC2:      equ    2                                         ; Conversion Counter 2
ATD1STAT0_FIFOR:    equ    4                                         ; FIFO Over Run Flag
ATD1STAT0_ETORF:    equ    5                                         ; External Trigger Overrun Flag
ATD1STAT0_SCF:      equ    7                                         ; Sequence Complete Flag
; bit position masks
mATD1STAT0_CC0:     equ    %00000001
mATD1STAT0_CC1:     equ    %00000010
mATD1STAT0_CC2:     equ    %00000100
mATD1STAT0_FIFOR:   equ    %00010000
mATD1STAT0_ETORF:   equ    %00100000
mATD1STAT0_SCF:     equ    %10000000


;*** ATD1TEST1 - ATD1 Test Register; 0x00000129 ***
ATD1TEST1:          equ    $00000129                                ;*** ATD1TEST1 - ATD1 Test Register; 0x00000129 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD1TEST1_SC:       equ    0                                         ; Special Channel Conversion Bit
; bit position masks
mATD1TEST1_SC:      equ    %00000001


;*** ATD1STAT1 - ATD 1 Status Register 1; 0x0000012B ***
ATD1STAT1:          equ    $0000012B                                ;*** ATD1STAT1 - ATD 1 Status Register 1; 0x0000012B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD1STAT1_CCF0:     equ    0                                         ; Conversion Complete Flag 0
ATD1STAT1_CCF1:     equ    1                                         ; Conversion Complete Flag 1
ATD1STAT1_CCF2:     equ    2                                         ; Conversion Complete Flag 2
ATD1STAT1_CCF3:     equ    3                                         ; Conversion Complete Flag 3
ATD1STAT1_CCF4:     equ    4                                         ; Conversion Complete Flag 4
ATD1STAT1_CCF5:     equ    5                                         ; Conversion Complete Flag 5
ATD1STAT1_CCF6:     equ    6                                         ; Conversion Complete Flag 6
ATD1STAT1_CCF7:     equ    7                                         ; Conversion Complete Flag 7
; bit position masks
mATD1STAT1_CCF0:    equ    %00000001
mATD1STAT1_CCF1:    equ    %00000010
mATD1STAT1_CCF2:    equ    %00000100
mATD1STAT1_CCF3:    equ    %00001000
mATD1STAT1_CCF4:    equ    %00010000
mATD1STAT1_CCF5:    equ    %00100000
mATD1STAT1_CCF6:    equ    %01000000
mATD1STAT1_CCF7:    equ    %10000000


;*** ATD1DIEN - ATD 1 Input Enable Register; 0x0000012D ***
ATD1DIEN:           equ    $0000012D                                ;*** ATD1DIEN - ATD 1 Input Enable Register; 0x0000012D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD1DIEN_IEN0:      equ    0                                         ; ATD Digital Input Enable on channel 0
ATD1DIEN_IEN1:      equ    1                                         ; ATD Digital Input Enable on channel 1
ATD1DIEN_IEN2:      equ    2                                         ; ATD Digital Input Enable on channel 2
ATD1DIEN_IEN3:      equ    3                                         ; ATD Digital Input Enable on channel 3
ATD1DIEN_IEN4:      equ    4                                         ; ATD Digital Input Enable on channel 4
ATD1DIEN_IEN5:      equ    5                                         ; ATD Digital Input Enable on channel 5
ATD1DIEN_IEN6:      equ    6                                         ; ATD Digital Input Enable on channel 6
ATD1DIEN_IEN7:      equ    7                                         ; ATD Digital Input Enable on channel 7
; bit position masks
mATD1DIEN_IEN0:     equ    %00000001
mATD1DIEN_IEN1:     equ    %00000010
mATD1DIEN_IEN2:     equ    %00000100
mATD1DIEN_IEN3:     equ    %00001000
mATD1DIEN_IEN4:     equ    %00010000
mATD1DIEN_IEN5:     equ    %00100000
mATD1DIEN_IEN6:     equ    %01000000
mATD1DIEN_IEN7:     equ    %10000000


;*** PORTAD1 - Port AD1 Register; 0x0000012F ***
PORTAD1:            equ    $0000012F                                ;*** PORTAD1 - Port AD1 Register; 0x0000012F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PORTAD1_PTAD0:      equ    0                                         ; A/D Channel 0 (AN0) Digital Input
PORTAD1_PTAD1:      equ    1                                         ; A/D Channel 1 (AN1) Digital Input
PORTAD1_PTAD2:      equ    2                                         ; A/D Channel 2 (AN2) Digital Input
PORTAD1_PTAD3:      equ    3                                         ; A/D Channel 3 (AN3) Digital Input
PORTAD1_PTAD4:      equ    4                                         ; A/D Channel 4 (AN4) Digital Input
PORTAD1_PTAD5:      equ    5                                         ; A/D Channel 5 (AN5) Digital Input
PORTAD1_PTAD6:      equ    6                                         ; A/D Channel 6 (AN6) Digital Input
PORTAD1_PTAD7:      equ    7                                         ; A/D Channel 7 (AN7) Digital Input
; bit position masks
mPORTAD1_PTAD0:     equ    %00000001
mPORTAD1_PTAD1:     equ    %00000010
mPORTAD1_PTAD2:     equ    %00000100
mPORTAD1_PTAD3:     equ    %00001000
mPORTAD1_PTAD4:     equ    %00010000
mPORTAD1_PTAD5:     equ    %00100000
mPORTAD1_PTAD6:     equ    %01000000
mPORTAD1_PTAD7:     equ    %10000000


;*** ATD1DR0 - ATD 1 Conversion Result Register 0; 0x00000130 ***
ATD1DR0:            equ    $00000130                                ;*** ATD1DR0 - ATD 1 Conversion Result Register 0; 0x00000130 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD1DR0_BIT6:       equ    6                                         ; Bit 6
ATD1DR0_BIT7:       equ    7                                         ; Bit 7
ATD1DR0_BIT8:       equ    8                                         ; Bit 8
ATD1DR0_BIT9:       equ    9                                         ; Bit 9
ATD1DR0_BIT10:      equ    10                                        ; Bit 10
ATD1DR0_BIT11:      equ    11                                        ; Bit 11
ATD1DR0_BIT12:      equ    12                                        ; Bit 12
ATD1DR0_BIT13:      equ    13                                        ; Bit 13
ATD1DR0_BIT14:      equ    14                                        ; Bit 14
ATD1DR0_BIT15:      equ    15                                        ; Bit 15
; bit position masks
mATD1DR0_BIT6:      equ    %01000000
mATD1DR0_BIT7:      equ    %10000000
mATD1DR0_BIT8:      equ    %100000000
mATD1DR0_BIT9:      equ    %1000000000
mATD1DR0_BIT10:     equ    %10000000000
mATD1DR0_BIT11:     equ    %100000000000
mATD1DR0_BIT12:     equ    %1000000000000
mATD1DR0_BIT13:     equ    %10000000000000
mATD1DR0_BIT14:     equ    %100000000000000
mATD1DR0_BIT15:     equ    %1000000000000000


;*** ATD1DR0H - ATD 1 Conversion Result Register 0 High; 0x00000130 ***
ATD1DR0H:           equ    $00000130                                ;*** ATD1DR0H - ATD 1 Conversion Result Register 0 High; 0x00000130 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD1DR0H_BIT8:      equ    0                                         ; Bit 8
ATD1DR0H_BIT9:      equ    1                                         ; Bit 9
ATD1DR0H_BIT10:     equ    2                                         ; Bit 10
ATD1DR0H_BIT11:     equ    3                                         ; Bit 11
ATD1DR0H_BIT12:     equ    4                                         ; Bit 12
ATD1DR0H_BIT13:     equ    5                                         ; Bit 13
ATD1DR0H_BIT14:     equ    6                                         ; Bit 14
ATD1DR0H_BIT15:     equ    7                                         ; Bit 15
; bit position masks
mATD1DR0H_BIT8:     equ    %00000001
mATD1DR0H_BIT9:     equ    %00000010
mATD1DR0H_BIT10:    equ    %00000100
mATD1DR0H_BIT11:    equ    %00001000
mATD1DR0H_BIT12:    equ    %00010000
mATD1DR0H_BIT13:    equ    %00100000
mATD1DR0H_BIT14:    equ    %01000000
mATD1DR0H_BIT15:    equ    %10000000


;*** ATD1DR0L - ATD 1 Conversion Result Register 0 Low; 0x00000131 ***
ATD1DR0L:           equ    $00000131                                ;*** ATD1DR0L - ATD 1 Conversion Result Register 0 Low; 0x00000131 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD1DR0L_BIT6:      equ    6                                         ; Bit 6
ATD1DR0L_BIT7:      equ    7                                         ; Bit 7
; bit position masks
mATD1DR0L_BIT6:     equ    %01000000
mATD1DR0L_BIT7:     equ    %10000000


;*** ATD1DR1 - ATD 1 Conversion Result Register 1; 0x00000132 ***
ATD1DR1:            equ    $00000132                                ;*** ATD1DR1 - ATD 1 Conversion Result Register 1; 0x00000132 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD1DR1_BIT6:       equ    6                                         ; Bit 6
ATD1DR1_BIT7:       equ    7                                         ; Bit 7
ATD1DR1_BIT8:       equ    8                                         ; Bit 8
ATD1DR1_BIT9:       equ    9                                         ; Bit 9
ATD1DR1_BIT10:      equ    10                                        ; Bit 10
ATD1DR1_BIT11:      equ    11                                        ; Bit 11
ATD1DR1_BIT12:      equ    12                                        ; Bit 12
ATD1DR1_BIT13:      equ    13                                        ; Bit 13
ATD1DR1_BIT14:      equ    14                                        ; Bit 14
ATD1DR1_BIT15:      equ    15                                        ; Bit 15
; bit position masks
mATD1DR1_BIT6:      equ    %01000000
mATD1DR1_BIT7:      equ    %10000000
mATD1DR1_BIT8:      equ    %100000000
mATD1DR1_BIT9:      equ    %1000000000
mATD1DR1_BIT10:     equ    %10000000000
mATD1DR1_BIT11:     equ    %100000000000
mATD1DR1_BIT12:     equ    %1000000000000
mATD1DR1_BIT13:     equ    %10000000000000
mATD1DR1_BIT14:     equ    %100000000000000
mATD1DR1_BIT15:     equ    %1000000000000000


;*** ATD1DR1H - ATD 1 Conversion Result Register 1 High; 0x00000132 ***
ATD1DR1H:           equ    $00000132                                ;*** ATD1DR1H - ATD 1 Conversion Result Register 1 High; 0x00000132 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD1DR1H_BIT8:      equ    0                                         ; Bit 8
ATD1DR1H_BIT9:      equ    1                                         ; Bit 9
ATD1DR1H_BIT10:     equ    2                                         ; Bit 10
ATD1DR1H_BIT11:     equ    3                                         ; Bit 11
ATD1DR1H_BIT12:     equ    4                                         ; Bit 12
ATD1DR1H_BIT13:     equ    5                                         ; Bit 13
ATD1DR1H_BIT14:     equ    6                                         ; Bit 14
ATD1DR1H_BIT15:     equ    7                                         ; Bit 15
; bit position masks
mATD1DR1H_BIT8:     equ    %00000001
mATD1DR1H_BIT9:     equ    %00000010
mATD1DR1H_BIT10:    equ    %00000100
mATD1DR1H_BIT11:    equ    %00001000
mATD1DR1H_BIT12:    equ    %00010000
mATD1DR1H_BIT13:    equ    %00100000
mATD1DR1H_BIT14:    equ    %01000000
mATD1DR1H_BIT15:    equ    %10000000


;*** ATD1DR1L - ATD 1 Conversion Result Register 1 Low; 0x00000133 ***
ATD1DR1L:           equ    $00000133                                ;*** ATD1DR1L - ATD 1 Conversion Result Register 1 Low; 0x00000133 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD1DR1L_BIT6:      equ    6                                         ; Bit 6
ATD1DR1L_BIT7:      equ    7                                         ; Bit 7
; bit position masks
mATD1DR1L_BIT6:     equ    %01000000
mATD1DR1L_BIT7:     equ    %10000000


;*** ATD1DR2 - ATD 1 Conversion Result Register 2; 0x00000134 ***
ATD1DR2:            equ    $00000134                                ;*** ATD1DR2 - ATD 1 Conversion Result Register 2; 0x00000134 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD1DR2_BIT6:       equ    6                                         ; Bit 6
ATD1DR2_BIT7:       equ    7                                         ; Bit 7
ATD1DR2_BIT8:       equ    8                                         ; Bit 8
ATD1DR2_BIT9:       equ    9                                         ; Bit 9
ATD1DR2_BIT10:      equ    10                                        ; Bit 10
ATD1DR2_BIT11:      equ    11                                        ; Bit 11
ATD1DR2_BIT12:      equ    12                                        ; Bit 12
ATD1DR2_BIT13:      equ    13                                        ; Bit 13
ATD1DR2_BIT14:      equ    14                                        ; Bit 14
ATD1DR2_BIT15:      equ    15                                        ; Bit 15
; bit position masks
mATD1DR2_BIT6:      equ    %01000000
mATD1DR2_BIT7:      equ    %10000000
mATD1DR2_BIT8:      equ    %100000000
mATD1DR2_BIT9:      equ    %1000000000
mATD1DR2_BIT10:     equ    %10000000000
mATD1DR2_BIT11:     equ    %100000000000
mATD1DR2_BIT12:     equ    %1000000000000
mATD1DR2_BIT13:     equ    %10000000000000
mATD1DR2_BIT14:     equ    %100000000000000
mATD1DR2_BIT15:     equ    %1000000000000000


;*** ATD1DR2H - ATD 1 Conversion Result Register 2 High; 0x00000134 ***
ATD1DR2H:           equ    $00000134                                ;*** ATD1DR2H - ATD 1 Conversion Result Register 2 High; 0x00000134 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD1DR2H_BIT8:      equ    0                                         ; Bit 8
ATD1DR2H_BIT9:      equ    1                                         ; Bit 9
ATD1DR2H_BIT10:     equ    2                                         ; Bit 10
ATD1DR2H_BIT11:     equ    3                                         ; Bit 11
ATD1DR2H_BIT12:     equ    4                                         ; Bit 12
ATD1DR2H_BIT13:     equ    5                                         ; Bit 13
ATD1DR2H_BIT14:     equ    6                                         ; Bit 14
ATD1DR2H_BIT15:     equ    7                                         ; Bit 15
; bit position masks
mATD1DR2H_BIT8:     equ    %00000001
mATD1DR2H_BIT9:     equ    %00000010
mATD1DR2H_BIT10:    equ    %00000100
mATD1DR2H_BIT11:    equ    %00001000
mATD1DR2H_BIT12:    equ    %00010000
mATD1DR2H_BIT13:    equ    %00100000
mATD1DR2H_BIT14:    equ    %01000000
mATD1DR2H_BIT15:    equ    %10000000


;*** ATD1DR2L - ATD 1 Conversion Result Register 2 Low; 0x00000135 ***
ATD1DR2L:           equ    $00000135                                ;*** ATD1DR2L - ATD 1 Conversion Result Register 2 Low; 0x00000135 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD1DR2L_BIT6:      equ    6                                         ; Bit 6
ATD1DR2L_BIT7:      equ    7                                         ; Bit 7
; bit position masks
mATD1DR2L_BIT6:     equ    %01000000
mATD1DR2L_BIT7:     equ    %10000000


;*** ATD1DR3 - ATD 1 Conversion Result Register 3; 0x00000136 ***
ATD1DR3:            equ    $00000136                                ;*** ATD1DR3 - ATD 1 Conversion Result Register 3; 0x00000136 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD1DR3_BIT6:       equ    6                                         ; Bit 6
ATD1DR3_BIT7:       equ    7                                         ; Bit 7
ATD1DR3_BIT8:       equ    8                                         ; Bit 8
ATD1DR3_BIT9:       equ    9                                         ; Bit 9
ATD1DR3_BIT10:      equ    10                                        ; Bit 10
ATD1DR3_BIT11:      equ    11                                        ; Bit 11
ATD1DR3_BIT12:      equ    12                                        ; Bit 12
ATD1DR3_BIT13:      equ    13                                        ; Bit 13
ATD1DR3_BIT14:      equ    14                                        ; Bit 14
ATD1DR3_BIT15:      equ    15                                        ; Bit 15
; bit position masks
mATD1DR3_BIT6:      equ    %01000000
mATD1DR3_BIT7:      equ    %10000000
mATD1DR3_BIT8:      equ    %100000000
mATD1DR3_BIT9:      equ    %1000000000
mATD1DR3_BIT10:     equ    %10000000000
mATD1DR3_BIT11:     equ    %100000000000
mATD1DR3_BIT12:     equ    %1000000000000
mATD1DR3_BIT13:     equ    %10000000000000
mATD1DR3_BIT14:     equ    %100000000000000
mATD1DR3_BIT15:     equ    %1000000000000000


;*** ATD1DR3H - ATD 1 Conversion Result Register 3 High; 0x00000136 ***
ATD1DR3H:           equ    $00000136                                ;*** ATD1DR3H - ATD 1 Conversion Result Register 3 High; 0x00000136 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD1DR3H_BIT8:      equ    0                                         ; Bit 8
ATD1DR3H_BIT9:      equ    1                                         ; Bit 9
ATD1DR3H_BIT10:     equ    2                                         ; Bit 10
ATD1DR3H_BIT11:     equ    3                                         ; Bit 11
ATD1DR3H_BIT12:     equ    4                                         ; Bit 12
ATD1DR3H_BIT13:     equ    5                                         ; Bit 13
ATD1DR3H_BIT14:     equ    6                                         ; Bit 14
ATD1DR3H_BIT15:     equ    7                                         ; Bit 15
; bit position masks
mATD1DR3H_BIT8:     equ    %00000001
mATD1DR3H_BIT9:     equ    %00000010
mATD1DR3H_BIT10:    equ    %00000100
mATD1DR3H_BIT11:    equ    %00001000
mATD1DR3H_BIT12:    equ    %00010000
mATD1DR3H_BIT13:    equ    %00100000
mATD1DR3H_BIT14:    equ    %01000000
mATD1DR3H_BIT15:    equ    %10000000


;*** ATD1DR3L - ATD 1 Conversion Result Register 3 Low; 0x00000137 ***
ATD1DR3L:           equ    $00000137                                ;*** ATD1DR3L - ATD 1 Conversion Result Register 3 Low; 0x00000137 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD1DR3L_BIT6:      equ    6                                         ; Bit 6
ATD1DR3L_BIT7:      equ    7                                         ; Bit 7
; bit position masks
mATD1DR3L_BIT6:     equ    %01000000
mATD1DR3L_BIT7:     equ    %10000000


;*** ATD1DR4 - ATD 1 Conversion Result Register 4; 0x00000138 ***
ATD1DR4:            equ    $00000138                                ;*** ATD1DR4 - ATD 1 Conversion Result Register 4; 0x00000138 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD1DR4_BIT6:       equ    6                                         ; Bit 6
ATD1DR4_BIT7:       equ    7                                         ; Bit 7
ATD1DR4_BIT8:       equ    8                                         ; Bit 8
ATD1DR4_BIT9:       equ    9                                         ; Bit 9
ATD1DR4_BIT10:      equ    10                                        ; Bit 10
ATD1DR4_BIT11:      equ    11                                        ; Bit 11
ATD1DR4_BIT12:      equ    12                                        ; Bit 12
ATD1DR4_BIT13:      equ    13                                        ; Bit 13
ATD1DR4_BIT14:      equ    14                                        ; Bit 14
ATD1DR4_BIT15:      equ    15                                        ; Bit 15
; bit position masks
mATD1DR4_BIT6:      equ    %01000000
mATD1DR4_BIT7:      equ    %10000000
mATD1DR4_BIT8:      equ    %100000000
mATD1DR4_BIT9:      equ    %1000000000
mATD1DR4_BIT10:     equ    %10000000000
mATD1DR4_BIT11:     equ    %100000000000
mATD1DR4_BIT12:     equ    %1000000000000
mATD1DR4_BIT13:     equ    %10000000000000
mATD1DR4_BIT14:     equ    %100000000000000
mATD1DR4_BIT15:     equ    %1000000000000000


;*** ATD1DR4H - ATD 1 Conversion Result Register 4 High; 0x00000138 ***
ATD1DR4H:           equ    $00000138                                ;*** ATD1DR4H - ATD 1 Conversion Result Register 4 High; 0x00000138 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD1DR4H_BIT8:      equ    0                                         ; Bit 8
ATD1DR4H_BIT9:      equ    1                                         ; Bit 9
ATD1DR4H_BIT10:     equ    2                                         ; Bit 10
ATD1DR4H_BIT11:     equ    3                                         ; Bit 11
ATD1DR4H_BIT12:     equ    4                                         ; Bit 12
ATD1DR4H_BIT13:     equ    5                                         ; Bit 13
ATD1DR4H_BIT14:     equ    6                                         ; Bit 14
ATD1DR4H_BIT15:     equ    7                                         ; Bit 15
; bit position masks
mATD1DR4H_BIT8:     equ    %00000001
mATD1DR4H_BIT9:     equ    %00000010
mATD1DR4H_BIT10:    equ    %00000100
mATD1DR4H_BIT11:    equ    %00001000
mATD1DR4H_BIT12:    equ    %00010000
mATD1DR4H_BIT13:    equ    %00100000
mATD1DR4H_BIT14:    equ    %01000000
mATD1DR4H_BIT15:    equ    %10000000


;*** ATD1DR4L - ATD 1 Conversion Result Register 4 Low; 0x00000139 ***
ATD1DR4L:           equ    $00000139                                ;*** ATD1DR4L - ATD 1 Conversion Result Register 4 Low; 0x00000139 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD1DR4L_BIT6:      equ    6                                         ; Bit 6
ATD1DR4L_BIT7:      equ    7                                         ; Bit 7
; bit position masks
mATD1DR4L_BIT6:     equ    %01000000
mATD1DR4L_BIT7:     equ    %10000000


;*** ATD1DR5 - ATD 1 Conversion Result Register 5; 0x0000013A ***
ATD1DR5:            equ    $0000013A                                ;*** ATD1DR5 - ATD 1 Conversion Result Register 5; 0x0000013A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD1DR5_BIT6:       equ    6                                         ; Bit 6
ATD1DR5_BIT7:       equ    7                                         ; Bit 7
ATD1DR5_BIT8:       equ    8                                         ; Bit 8
ATD1DR5_BIT9:       equ    9                                         ; Bit 9
ATD1DR5_BIT10:      equ    10                                        ; Bit 10
ATD1DR5_BIT11:      equ    11                                        ; Bit 11
ATD1DR5_BIT12:      equ    12                                        ; Bit 12
ATD1DR5_BIT13:      equ    13                                        ; Bit 13
ATD1DR5_BIT14:      equ    14                                        ; Bit 14
ATD1DR5_BIT15:      equ    15                                        ; Bit 15
; bit position masks
mATD1DR5_BIT6:      equ    %01000000
mATD1DR5_BIT7:      equ    %10000000
mATD1DR5_BIT8:      equ    %100000000
mATD1DR5_BIT9:      equ    %1000000000
mATD1DR5_BIT10:     equ    %10000000000
mATD1DR5_BIT11:     equ    %100000000000
mATD1DR5_BIT12:     equ    %1000000000000
mATD1DR5_BIT13:     equ    %10000000000000
mATD1DR5_BIT14:     equ    %100000000000000
mATD1DR5_BIT15:     equ    %1000000000000000


;*** ATD1DR5H - ATD 1 Conversion Result Register 5 High; 0x0000013A ***
ATD1DR5H:           equ    $0000013A                                ;*** ATD1DR5H - ATD 1 Conversion Result Register 5 High; 0x0000013A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD1DR5H_BIT8:      equ    0                                         ; Bit 8
ATD1DR5H_BIT9:      equ    1                                         ; Bit 9
ATD1DR5H_BIT10:     equ    2                                         ; Bit 10
ATD1DR5H_BIT11:     equ    3                                         ; Bit 11
ATD1DR5H_BIT12:     equ    4                                         ; Bit 12
ATD1DR5H_BIT13:     equ    5                                         ; Bit 13
ATD1DR5H_BIT14:     equ    6                                         ; Bit 14
ATD1DR5H_BIT15:     equ    7                                         ; Bit 15
; bit position masks
mATD1DR5H_BIT8:     equ    %00000001
mATD1DR5H_BIT9:     equ    %00000010
mATD1DR5H_BIT10:    equ    %00000100
mATD1DR5H_BIT11:    equ    %00001000
mATD1DR5H_BIT12:    equ    %00010000
mATD1DR5H_BIT13:    equ    %00100000
mATD1DR5H_BIT14:    equ    %01000000
mATD1DR5H_BIT15:    equ    %10000000


;*** ATD1DR5L - ATD 1 Conversion Result Register 5 Low; 0x0000013B ***
ATD1DR5L:           equ    $0000013B                                ;*** ATD1DR5L - ATD 1 Conversion Result Register 5 Low; 0x0000013B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD1DR5L_BIT6:      equ    6                                         ; Bit 6
ATD1DR5L_BIT7:      equ    7                                         ; Bit 7
; bit position masks
mATD1DR5L_BIT6:     equ    %01000000
mATD1DR5L_BIT7:     equ    %10000000


;*** ATD1DR6 - ATD 1 Conversion Result Register 6; 0x0000013C ***
ATD1DR6:            equ    $0000013C                                ;*** ATD1DR6 - ATD 1 Conversion Result Register 6; 0x0000013C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD1DR6_BIT6:       equ    6                                         ; Bit 6
ATD1DR6_BIT7:       equ    7                                         ; Bit 7
ATD1DR6_BIT8:       equ    8                                         ; Bit 8
ATD1DR6_BIT9:       equ    9                                         ; Bit 9
ATD1DR6_BIT10:      equ    10                                        ; Bit 10
ATD1DR6_BIT11:      equ    11                                        ; Bit 11
ATD1DR6_BIT12:      equ    12                                        ; Bit 12
ATD1DR6_BIT13:      equ    13                                        ; Bit 13
ATD1DR6_BIT14:      equ    14                                        ; Bit 14
ATD1DR6_BIT15:      equ    15                                        ; Bit 15
; bit position masks
mATD1DR6_BIT6:      equ    %01000000
mATD1DR6_BIT7:      equ    %10000000
mATD1DR6_BIT8:      equ    %100000000
mATD1DR6_BIT9:      equ    %1000000000
mATD1DR6_BIT10:     equ    %10000000000
mATD1DR6_BIT11:     equ    %100000000000
mATD1DR6_BIT12:     equ    %1000000000000
mATD1DR6_BIT13:     equ    %10000000000000
mATD1DR6_BIT14:     equ    %100000000000000
mATD1DR6_BIT15:     equ    %1000000000000000


;*** ATD1DR6H - ATD 1 Conversion Result Register 6 High; 0x0000013C ***
ATD1DR6H:           equ    $0000013C                                ;*** ATD1DR6H - ATD 1 Conversion Result Register 6 High; 0x0000013C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD1DR6H_BIT8:      equ    0                                         ; Bit 8
ATD1DR6H_BIT9:      equ    1                                         ; Bit 9
ATD1DR6H_BIT10:     equ    2                                         ; Bit 10
ATD1DR6H_BIT11:     equ    3                                         ; Bit 11
ATD1DR6H_BIT12:     equ    4                                         ; Bit 12
ATD1DR6H_BIT13:     equ    5                                         ; Bit 13
ATD1DR6H_BIT14:     equ    6                                         ; Bit 14
ATD1DR6H_BIT15:     equ    7                                         ; Bit 15
; bit position masks
mATD1DR6H_BIT8:     equ    %00000001
mATD1DR6H_BIT9:     equ    %00000010
mATD1DR6H_BIT10:    equ    %00000100
mATD1DR6H_BIT11:    equ    %00001000
mATD1DR6H_BIT12:    equ    %00010000
mATD1DR6H_BIT13:    equ    %00100000
mATD1DR6H_BIT14:    equ    %01000000
mATD1DR6H_BIT15:    equ    %10000000


;*** ATD1DR6L - ATD 1 Conversion Result Register 6 Low; 0x0000013D ***
ATD1DR6L:           equ    $0000013D                                ;*** ATD1DR6L - ATD 1 Conversion Result Register 6 Low; 0x0000013D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD1DR6L_BIT6:      equ    6                                         ; Bit 6
ATD1DR6L_BIT7:      equ    7                                         ; Bit 7
; bit position masks
mATD1DR6L_BIT6:     equ    %01000000
mATD1DR6L_BIT7:     equ    %10000000


;*** ATD1DR7 - ATD 1 Conversion Result Register 7; 0x0000013E ***
ATD1DR7:            equ    $0000013E                                ;*** ATD1DR7 - ATD 1 Conversion Result Register 7; 0x0000013E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD1DR7_BIT6:       equ    6                                         ; Bit 6
ATD1DR7_BIT7:       equ    7                                         ; Bit 7
ATD1DR7_BIT8:       equ    8                                         ; Bit 8
ATD1DR7_BIT9:       equ    9                                         ; Bit 9
ATD1DR7_BIT10:      equ    10                                        ; Bit 10
ATD1DR7_BIT11:      equ    11                                        ; Bit 11
ATD1DR7_BIT12:      equ    12                                        ; Bit 12
ATD1DR7_BIT13:      equ    13                                        ; Bit 13
ATD1DR7_BIT14:      equ    14                                        ; Bit 14
ATD1DR7_BIT15:      equ    15                                        ; Bit 15
; bit position masks
mATD1DR7_BIT6:      equ    %01000000
mATD1DR7_BIT7:      equ    %10000000
mATD1DR7_BIT8:      equ    %100000000
mATD1DR7_BIT9:      equ    %1000000000
mATD1DR7_BIT10:     equ    %10000000000
mATD1DR7_BIT11:     equ    %100000000000
mATD1DR7_BIT12:     equ    %1000000000000
mATD1DR7_BIT13:     equ    %10000000000000
mATD1DR7_BIT14:     equ    %100000000000000
mATD1DR7_BIT15:     equ    %1000000000000000


;*** ATD1DR7H - ATD 1 Conversion Result Register 7 High; 0x0000013E ***
ATD1DR7H:           equ    $0000013E                                ;*** ATD1DR7H - ATD 1 Conversion Result Register 7 High; 0x0000013E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD1DR7H_BIT8:      equ    0                                         ; Bit 8
ATD1DR7H_BIT9:      equ    1                                         ; Bit 9
ATD1DR7H_BIT10:     equ    2                                         ; Bit 10
ATD1DR7H_BIT11:     equ    3                                         ; Bit 11
ATD1DR7H_BIT12:     equ    4                                         ; Bit 12
ATD1DR7H_BIT13:     equ    5                                         ; Bit 13
ATD1DR7H_BIT14:     equ    6                                         ; Bit 14
ATD1DR7H_BIT15:     equ    7                                         ; Bit 15
; bit position masks
mATD1DR7H_BIT8:     equ    %00000001
mATD1DR7H_BIT9:     equ    %00000010
mATD1DR7H_BIT10:    equ    %00000100
mATD1DR7H_BIT11:    equ    %00001000
mATD1DR7H_BIT12:    equ    %00010000
mATD1DR7H_BIT13:    equ    %00100000
mATD1DR7H_BIT14:    equ    %01000000
mATD1DR7H_BIT15:    equ    %10000000


;*** ATD1DR7L - ATD 1 Conversion Result Register 7 Low; 0x0000013F ***
ATD1DR7L:           equ    $0000013F                                ;*** ATD1DR7L - ATD 1 Conversion Result Register 7 Low; 0x0000013F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD1DR7L_BIT6:      equ    6                                         ; Bit 6
ATD1DR7L_BIT7:      equ    7                                         ; Bit 7
; bit position masks
mATD1DR7L_BIT6:     equ    %01000000
mATD1DR7L_BIT7:     equ    %10000000


;*** CAN0CTL0 - MSCAN 0 Control 0 Register; 0x00000140 ***
CAN0CTL0:           equ    $00000140                                ;*** CAN0CTL0 - MSCAN 0 Control 0 Register; 0x00000140 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0CTL0_INITRQ:    equ    0                                         ; Initialization Mode Request
CAN0CTL0_SLPRQ:     equ    1                                         ; Sleep Mode Request
CAN0CTL0_WUPE:      equ    2                                         ; Wake-Up Enable
CAN0CTL0_TIME:      equ    3                                         ; Timer Enable
CAN0CTL0_SYNCH:     equ    4                                         ; Synchronized Status
CAN0CTL0_CSWAI:     equ    5                                         ; CAN Stops in Wait Mode
CAN0CTL0_RXACT:     equ    6                                         ; Receiver Active Status
CAN0CTL0_RXFRM:     equ    7                                         ; Received Frame Flag
; bit position masks
mCAN0CTL0_INITRQ:   equ    %00000001
mCAN0CTL0_SLPRQ:    equ    %00000010
mCAN0CTL0_WUPE:     equ    %00000100
mCAN0CTL0_TIME:     equ    %00001000
mCAN0CTL0_SYNCH:    equ    %00010000
mCAN0CTL0_CSWAI:    equ    %00100000
mCAN0CTL0_RXACT:    equ    %01000000
mCAN0CTL0_RXFRM:    equ    %10000000


;*** CAN0CTL1 - MSCAN 0 Control 1 Register; 0x00000141 ***
CAN0CTL1:           equ    $00000141                                ;*** CAN0CTL1 - MSCAN 0 Control 1 Register; 0x00000141 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0CTL1_INITAK:    equ    0                                         ; Initialization Mode Acknowledge
CAN0CTL1_SLPAK:     equ    1                                         ; Sleep Mode Acknowledge
CAN0CTL1_WUPM:      equ    2                                         ; Wake-Up Mode
CAN0CTL1_LISTEN:    equ    4                                         ; Listen Only Mode
CAN0CTL1_LOOPB:     equ    5                                         ; Loop Back Self Test Mode
CAN0CTL1_CLKSRC:    equ    6                                         ; MSCAN 0 Clock Source
CAN0CTL1_CANE:      equ    7                                         ; MSCAN 0 Enable
; bit position masks
mCAN0CTL1_INITAK:   equ    %00000001
mCAN0CTL1_SLPAK:    equ    %00000010
mCAN0CTL1_WUPM:     equ    %00000100
mCAN0CTL1_LISTEN:   equ    %00010000
mCAN0CTL1_LOOPB:    equ    %00100000
mCAN0CTL1_CLKSRC:   equ    %01000000
mCAN0CTL1_CANE:     equ    %10000000


;*** CAN0BTR0 - MSCAN 0 Bus Timing Register 0; 0x00000142 ***
CAN0BTR0:           equ    $00000142                                ;*** CAN0BTR0 - MSCAN 0 Bus Timing Register 0; 0x00000142 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0BTR0_BRP0:      equ    0                                         ; Baud Rate Prescaler 0
CAN0BTR0_BRP1:      equ    1                                         ; Baud Rate Prescaler 1
CAN0BTR0_BRP2:      equ    2                                         ; Baud Rate Prescaler 2
CAN0BTR0_BRP3:      equ    3                                         ; Baud Rate Prescaler 3
CAN0BTR0_BRP4:      equ    4                                         ; Baud Rate Prescaler 4
CAN0BTR0_BRP5:      equ    5                                         ; Baud Rate Prescaler 5
CAN0BTR0_SJW0:      equ    6                                         ; Synchronization Jump Width 0
CAN0BTR0_SJW1:      equ    7                                         ; Synchronization Jump Width 1
; bit position masks
mCAN0BTR0_BRP0:     equ    %00000001
mCAN0BTR0_BRP1:     equ    %00000010
mCAN0BTR0_BRP2:     equ    %00000100
mCAN0BTR0_BRP3:     equ    %00001000
mCAN0BTR0_BRP4:     equ    %00010000
mCAN0BTR0_BRP5:     equ    %00100000
mCAN0BTR0_SJW0:     equ    %01000000
mCAN0BTR0_SJW1:     equ    %10000000


;*** CAN0BTR1 - MSCAN 0 Bus Timing Register 1; 0x00000143 ***
CAN0BTR1:           equ    $00000143                                ;*** CAN0BTR1 - MSCAN 0 Bus Timing Register 1; 0x00000143 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0BTR1_TSEG10:    equ    0                                         ; Time Segment 10
CAN0BTR1_TSEG11:    equ    1                                         ; Time Segment 11
CAN0BTR1_TSEG12:    equ    2                                         ; Time Segment 12
CAN0BTR1_TSEG13:    equ    3                                         ; Time Segment 13
CAN0BTR1_TSEG20:    equ    4                                         ; Time Segment 20
CAN0BTR1_TSEG21:    equ    5                                         ; Time Segment 21
CAN0BTR1_TSEG22:    equ    6                                         ; Time Segment 22
CAN0BTR1_SAMP:      equ    7                                         ; Sampling
; bit position masks
mCAN0BTR1_TSEG10:   equ    %00000001
mCAN0BTR1_TSEG11:   equ    %00000010
mCAN0BTR1_TSEG12:   equ    %00000100
mCAN0BTR1_TSEG13:   equ    %00001000
mCAN0BTR1_TSEG20:   equ    %00010000
mCAN0BTR1_TSEG21:   equ    %00100000
mCAN0BTR1_TSEG22:   equ    %01000000
mCAN0BTR1_SAMP:     equ    %10000000


;*** CAN0RFLG - MSCAN 0 Receiver Flag Register; 0x00000144 ***
CAN0RFLG:           equ    $00000144                                ;*** CAN0RFLG - MSCAN 0 Receiver Flag Register; 0x00000144 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0RFLG_RXF:       equ    0                                         ; Receive Buffer Full
CAN0RFLG_OVRIF:     equ    1                                         ; Overrun Interrupt Flag
CAN0RFLG_TSTAT0:    equ    2                                         ; Transmitter Status Bit 0
CAN0RFLG_TSTAT1:    equ    3                                         ; Transmitter Status Bit 1
CAN0RFLG_RSTAT0:    equ    4                                         ; Receiver Status Bit 0
CAN0RFLG_RSTAT1:    equ    5                                         ; Receiver Status Bit 1
CAN0RFLG_CSCIF:     equ    6                                         ; CAN Status Change Interrupt Flag
CAN0RFLG_WUPIF:     equ    7                                         ; Wake-up Interrupt Flag
; bit position masks
mCAN0RFLG_RXF:      equ    %00000001
mCAN0RFLG_OVRIF:    equ    %00000010
mCAN0RFLG_TSTAT0:   equ    %00000100
mCAN0RFLG_TSTAT1:   equ    %00001000
mCAN0RFLG_RSTAT0:   equ    %00010000
mCAN0RFLG_RSTAT1:   equ    %00100000
mCAN0RFLG_CSCIF:    equ    %01000000
mCAN0RFLG_WUPIF:    equ    %10000000


;*** CAN0RIER - MSCAN 0 Receiver Interrupt Enable Register; 0x00000145 ***
CAN0RIER:           equ    $00000145                                ;*** CAN0RIER - MSCAN 0 Receiver Interrupt Enable Register; 0x00000145 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0RIER_RXFIE:     equ    0                                         ; Receiver Full Interrupt Enable
CAN0RIER_OVRIE:     equ    1                                         ; Overrun Interrupt Enable
CAN0RIER_TSTATE0:   equ    2                                         ; Transmitter Status Change Enable 0
CAN0RIER_TSTATE1:   equ    3                                         ; Transmitter Status Change Enable 1
CAN0RIER_RSTATE0:   equ    4                                         ; Receiver Status Change Enable 0
CAN0RIER_RSTATE1:   equ    5                                         ; Receiver Status Change Enable 1
CAN0RIER_CSCIE:     equ    6                                         ; CAN Status Change Interrupt Enable
CAN0RIER_WUPIE:     equ    7                                         ; Wake-up Interrupt Enable
; bit position masks
mCAN0RIER_RXFIE:    equ    %00000001
mCAN0RIER_OVRIE:    equ    %00000010
mCAN0RIER_TSTATE0:  equ    %00000100
mCAN0RIER_TSTATE1:  equ    %00001000
mCAN0RIER_RSTATE0:  equ    %00010000
mCAN0RIER_RSTATE1:  equ    %00100000
mCAN0RIER_CSCIE:    equ    %01000000
mCAN0RIER_WUPIE:    equ    %10000000


;*** CAN0TFLG - MSCAN 0 Transmitter Flag Register; 0x00000146 ***
CAN0TFLG:           equ    $00000146                                ;*** CAN0TFLG - MSCAN 0 Transmitter Flag Register; 0x00000146 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0TFLG_TXE0:      equ    0                                         ; Transmitter Buffer Empty 0
CAN0TFLG_TXE1:      equ    1                                         ; Transmitter Buffer Empty 1
CAN0TFLG_TXE2:      equ    2                                         ; Transmitter Buffer Empty 2
; bit position masks
mCAN0TFLG_TXE0:     equ    %00000001
mCAN0TFLG_TXE1:     equ    %00000010
mCAN0TFLG_TXE2:     equ    %00000100


;*** CAN0TIER - MSCAN 0 Transmitter Interrupt Enable Register; 0x00000147 ***
CAN0TIER:           equ    $00000147                                ;*** CAN0TIER - MSCAN 0 Transmitter Interrupt Enable Register; 0x00000147 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0TIER_TXEIE0:    equ    0                                         ; Transmitter Empty Interrupt Enable 0
CAN0TIER_TXEIE1:    equ    1                                         ; Transmitter Empty Interrupt Enable 1
CAN0TIER_TXEIE2:    equ    2                                         ; Transmitter Empty Interrupt Enable 2
; bit position masks
mCAN0TIER_TXEIE0:   equ    %00000001
mCAN0TIER_TXEIE1:   equ    %00000010
mCAN0TIER_TXEIE2:   equ    %00000100


;*** CAN0TARQ - MSCAN 0 Transmitter Message Abort Request; 0x00000148 ***
CAN0TARQ:           equ    $00000148                                ;*** CAN0TARQ - MSCAN 0 Transmitter Message Abort Request; 0x00000148 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0TARQ_ABTRQ0:    equ    0                                         ; Abort Request 0
CAN0TARQ_ABTRQ1:    equ    1                                         ; Abort Request 1
CAN0TARQ_ABTRQ2:    equ    2                                         ; Abort Request 2
; bit position masks
mCAN0TARQ_ABTRQ0:   equ    %00000001
mCAN0TARQ_ABTRQ1:   equ    %00000010
mCAN0TARQ_ABTRQ2:   equ    %00000100


;*** CAN0TAAK - MSCAN 0 Transmitter Message Abort Control; 0x00000149 ***
CAN0TAAK:           equ    $00000149                                ;*** CAN0TAAK - MSCAN 0 Transmitter Message Abort Control; 0x00000149 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0TAAK_ABTAK0:    equ    0                                         ; Abort Acknowledge 0
CAN0TAAK_ABTAK1:    equ    1                                         ; Abort Acknowledge 1
CAN0TAAK_ABTAK2:    equ    2                                         ; Abort Acknowledge 2
; bit position masks
mCAN0TAAK_ABTAK0:   equ    %00000001
mCAN0TAAK_ABTAK1:   equ    %00000010
mCAN0TAAK_ABTAK2:   equ    %00000100


;*** CAN0TBSEL - MSCAN 0 Transmit Buffer Selection; 0x0000014A ***
CAN0TBSEL:          equ    $0000014A                                ;*** CAN0TBSEL - MSCAN 0 Transmit Buffer Selection; 0x0000014A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0TBSEL_TX0:      equ    0                                         ; Transmit Buffer Select 0
CAN0TBSEL_TX1:      equ    1                                         ; Transmit Buffer Select 1
CAN0TBSEL_TX2:      equ    2                                         ; Transmit Buffer Select 2
; bit position masks
mCAN0TBSEL_TX0:     equ    %00000001
mCAN0TBSEL_TX1:     equ    %00000010
mCAN0TBSEL_TX2:     equ    %00000100


;*** CAN0IDAC - MSCAN 0 Identifier Acceptance Control Register; 0x0000014B ***
CAN0IDAC:           equ    $0000014B                                ;*** CAN0IDAC - MSCAN 0 Identifier Acceptance Control Register; 0x0000014B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0IDAC_IDHIT0:    equ    0                                         ; Identifier Acceptance Hit Indicator 0
CAN0IDAC_IDHIT1:    equ    1                                         ; Identifier Acceptance Hit Indicator 1
CAN0IDAC_IDHIT2:    equ    2                                         ; Identifier Acceptance Hit Indicator 2
CAN0IDAC_IDAM0:     equ    4                                         ; Identifier Acceptance Mode 0
CAN0IDAC_IDAM1:     equ    5                                         ; Identifier Acceptance Mode 1
; bit position masks
mCAN0IDAC_IDHIT0:   equ    %00000001
mCAN0IDAC_IDHIT1:   equ    %00000010
mCAN0IDAC_IDHIT2:   equ    %00000100
mCAN0IDAC_IDAM0:    equ    %00010000
mCAN0IDAC_IDAM1:    equ    %00100000


;*** CAN0RXERR - MSCAN 0 Receive Error Counter Register; 0x0000014E ***
CAN0RXERR:          equ    $0000014E                                ;*** CAN0RXERR - MSCAN 0 Receive Error Counter Register; 0x0000014E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0RXERR_RXERR0:   equ    0                                         ; Bit 0
CAN0RXERR_RXERR1:   equ    1                                         ; Bit 1
CAN0RXERR_RXERR2:   equ    2                                         ; Bit 2
CAN0RXERR_RXERR3:   equ    3                                         ; Bit 3
CAN0RXERR_RXERR4:   equ    4                                         ; Bit 4
CAN0RXERR_RXERR5:   equ    5                                         ; Bit 5
CAN0RXERR_RXERR6:   equ    6                                         ; Bit 6
CAN0RXERR_RXERR7:   equ    7                                         ; Bit 7
; bit position masks
mCAN0RXERR_RXERR0:  equ    %00000001
mCAN0RXERR_RXERR1:  equ    %00000010
mCAN0RXERR_RXERR2:  equ    %00000100
mCAN0RXERR_RXERR3:  equ    %00001000
mCAN0RXERR_RXERR4:  equ    %00010000
mCAN0RXERR_RXERR5:  equ    %00100000
mCAN0RXERR_RXERR6:  equ    %01000000
mCAN0RXERR_RXERR7:  equ    %10000000


;*** CAN0TXERR - MSCAN 0 Transmit Error Counter Register; 0x0000014F ***
CAN0TXERR:          equ    $0000014F                                ;*** CAN0TXERR - MSCAN 0 Transmit Error Counter Register; 0x0000014F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0TXERR_TXERR0:   equ    0                                         ; Bit 0
CAN0TXERR_TXERR1:   equ    1                                         ; Bit 1
CAN0TXERR_TXERR2:   equ    2                                         ; Bit 2
CAN0TXERR_TXERR3:   equ    3                                         ; Bit 3
CAN0TXERR_TXERR4:   equ    4                                         ; Bit 4
CAN0TXERR_TXERR5:   equ    5                                         ; Bit 5
CAN0TXERR_TXERR6:   equ    6                                         ; Bit 6
CAN0TXERR_TXERR7:   equ    7                                         ; Bit 7
; bit position masks
mCAN0TXERR_TXERR0:  equ    %00000001
mCAN0TXERR_TXERR1:  equ    %00000010
mCAN0TXERR_TXERR2:  equ    %00000100
mCAN0TXERR_TXERR3:  equ    %00001000
mCAN0TXERR_TXERR4:  equ    %00010000
mCAN0TXERR_TXERR5:  equ    %00100000
mCAN0TXERR_TXERR6:  equ    %01000000
mCAN0TXERR_TXERR7:  equ    %10000000


;*** CAN0IDAR0 - MSCAN 0 Identifier Acceptance Register 0; 0x00000150 ***
CAN0IDAR0:          equ    $00000150                                ;*** CAN0IDAR0 - MSCAN 0 Identifier Acceptance Register 0; 0x00000150 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0IDAR0_AC0:      equ    0                                         ; Acceptance Code Bit 0
CAN0IDAR0_AC1:      equ    1                                         ; Acceptance Code Bit 1
CAN0IDAR0_AC2:      equ    2                                         ; Acceptance Code Bit 2
CAN0IDAR0_AC3:      equ    3                                         ; Acceptance Code Bit 3
CAN0IDAR0_AC4:      equ    4                                         ; Acceptance Code Bit 4
CAN0IDAR0_AC5:      equ    5                                         ; Acceptance Code Bit 5
CAN0IDAR0_AC6:      equ    6                                         ; Acceptance Code Bit 6
CAN0IDAR0_AC7:      equ    7                                         ; Acceptance Code Bit 7
; bit position masks
mCAN0IDAR0_AC0:     equ    %00000001
mCAN0IDAR0_AC1:     equ    %00000010
mCAN0IDAR0_AC2:     equ    %00000100
mCAN0IDAR0_AC3:     equ    %00001000
mCAN0IDAR0_AC4:     equ    %00010000
mCAN0IDAR0_AC5:     equ    %00100000
mCAN0IDAR0_AC6:     equ    %01000000
mCAN0IDAR0_AC7:     equ    %10000000


;*** CAN0IDAR1 - MSCAN 0 Identifier Acceptance Register 1; 0x00000151 ***
CAN0IDAR1:          equ    $00000151                                ;*** CAN0IDAR1 - MSCAN 0 Identifier Acceptance Register 1; 0x00000151 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0IDAR1_AC0:      equ    0                                         ; Acceptance Code Bit 0
CAN0IDAR1_AC1:      equ    1                                         ; Acceptance Code Bit 1
CAN0IDAR1_AC2:      equ    2                                         ; Acceptance Code Bit 2
CAN0IDAR1_AC3:      equ    3                                         ; Acceptance Code Bit 3
CAN0IDAR1_AC4:      equ    4                                         ; Acceptance Code Bit 4
CAN0IDAR1_AC5:      equ    5                                         ; Acceptance Code Bit 5
CAN0IDAR1_AC6:      equ    6                                         ; Acceptance Code Bit 6
CAN0IDAR1_AC7:      equ    7                                         ; Acceptance Code Bit 7
; bit position masks
mCAN0IDAR1_AC0:     equ    %00000001
mCAN0IDAR1_AC1:     equ    %00000010
mCAN0IDAR1_AC2:     equ    %00000100
mCAN0IDAR1_AC3:     equ    %00001000
mCAN0IDAR1_AC4:     equ    %00010000
mCAN0IDAR1_AC5:     equ    %00100000
mCAN0IDAR1_AC6:     equ    %01000000
mCAN0IDAR1_AC7:     equ    %10000000


;*** CAN0IDAR2 - MSCAN 0 Identifier Acceptance Register 2; 0x00000152 ***
CAN0IDAR2:          equ    $00000152                                ;*** CAN0IDAR2 - MSCAN 0 Identifier Acceptance Register 2; 0x00000152 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0IDAR2_AC0:      equ    0                                         ; Acceptance Code Bit 0
CAN0IDAR2_AC1:      equ    1                                         ; Acceptance Code Bit 1
CAN0IDAR2_AC2:      equ    2                                         ; Acceptance Code Bit 2
CAN0IDAR2_AC3:      equ    3                                         ; Acceptance Code Bit 3
CAN0IDAR2_AC4:      equ    4                                         ; Acceptance Code Bit 4
CAN0IDAR2_AC5:      equ    5                                         ; Acceptance Code Bit 5
CAN0IDAR2_AC6:      equ    6                                         ; Acceptance Code Bit 6
CAN0IDAR2_AC7:      equ    7                                         ; Acceptance Code Bit 7
; bit position masks
mCAN0IDAR2_AC0:     equ    %00000001
mCAN0IDAR2_AC1:     equ    %00000010
mCAN0IDAR2_AC2:     equ    %00000100
mCAN0IDAR2_AC3:     equ    %00001000
mCAN0IDAR2_AC4:     equ    %00010000
mCAN0IDAR2_AC5:     equ    %00100000
mCAN0IDAR2_AC6:     equ    %01000000
mCAN0IDAR2_AC7:     equ    %10000000


;*** CAN0IDAR3 - MSCAN 0 Identifier Acceptance Register 3; 0x00000153 ***
CAN0IDAR3:          equ    $00000153                                ;*** CAN0IDAR3 - MSCAN 0 Identifier Acceptance Register 3; 0x00000153 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0IDAR3_AC0:      equ    0                                         ; Acceptance Code Bit 0
CAN0IDAR3_AC1:      equ    1                                         ; Acceptance Code Bit 1
CAN0IDAR3_AC2:      equ    2                                         ; Acceptance Code Bit 2
CAN0IDAR3_AC3:      equ    3                                         ; Acceptance Code Bit 3
CAN0IDAR3_AC4:      equ    4                                         ; Acceptance Code Bit 4
CAN0IDAR3_AC5:      equ    5                                         ; Acceptance Code Bit 5
CAN0IDAR3_AC6:      equ    6                                         ; Acceptance Code Bit 6
CAN0IDAR3_AC7:      equ    7                                         ; Acceptance Code Bit 7
; bit position masks
mCAN0IDAR3_AC0:     equ    %00000001
mCAN0IDAR3_AC1:     equ    %00000010
mCAN0IDAR3_AC2:     equ    %00000100
mCAN0IDAR3_AC3:     equ    %00001000
mCAN0IDAR3_AC4:     equ    %00010000
mCAN0IDAR3_AC5:     equ    %00100000
mCAN0IDAR3_AC6:     equ    %01000000
mCAN0IDAR3_AC7:     equ    %10000000


;*** CAN0IDMR0 - MSCAN 0 Identifier Mask Register 0; 0x00000154 ***
CAN0IDMR0:          equ    $00000154                                ;*** CAN0IDMR0 - MSCAN 0 Identifier Mask Register 0; 0x00000154 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0IDMR0_AM0:      equ    0                                         ; Acceptance Mask Bit 0
CAN0IDMR0_AM1:      equ    1                                         ; Acceptance Mask Bit 1
CAN0IDMR0_AM2:      equ    2                                         ; Acceptance Mask Bit 2
CAN0IDMR0_AM3:      equ    3                                         ; Acceptance Mask Bit 3
CAN0IDMR0_AM4:      equ    4                                         ; Acceptance Mask Bit 4
CAN0IDMR0_AM5:      equ    5                                         ; Acceptance Mask Bit 5
CAN0IDMR0_AM6:      equ    6                                         ; Acceptance Mask Bit 6
CAN0IDMR0_AM7:      equ    7                                         ; Acceptance Mask Bit 7
; bit position masks
mCAN0IDMR0_AM0:     equ    %00000001
mCAN0IDMR0_AM1:     equ    %00000010
mCAN0IDMR0_AM2:     equ    %00000100
mCAN0IDMR0_AM3:     equ    %00001000
mCAN0IDMR0_AM4:     equ    %00010000
mCAN0IDMR0_AM5:     equ    %00100000
mCAN0IDMR0_AM6:     equ    %01000000
mCAN0IDMR0_AM7:     equ    %10000000


;*** CAN0IDMR1 - MSCAN 0 Identifier Mask Register 1; 0x00000155 ***
CAN0IDMR1:          equ    $00000155                                ;*** CAN0IDMR1 - MSCAN 0 Identifier Mask Register 1; 0x00000155 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0IDMR1_AM0:      equ    0                                         ; Acceptance Mask Bit 0
CAN0IDMR1_AM1:      equ    1                                         ; Acceptance Mask Bit 1
CAN0IDMR1_AM2:      equ    2                                         ; Acceptance Mask Bit 2
CAN0IDMR1_AM3:      equ    3                                         ; Acceptance Mask Bit 3
CAN0IDMR1_AM4:      equ    4                                         ; Acceptance Mask Bit 4
CAN0IDMR1_AM5:      equ    5                                         ; Acceptance Mask Bit 5
CAN0IDMR1_AM6:      equ    6                                         ; Acceptance Mask Bit 6
CAN0IDMR1_AM7:      equ    7                                         ; Acceptance Mask Bit 7
; bit position masks
mCAN0IDMR1_AM0:     equ    %00000001
mCAN0IDMR1_AM1:     equ    %00000010
mCAN0IDMR1_AM2:     equ    %00000100
mCAN0IDMR1_AM3:     equ    %00001000
mCAN0IDMR1_AM4:     equ    %00010000
mCAN0IDMR1_AM5:     equ    %00100000
mCAN0IDMR1_AM6:     equ    %01000000
mCAN0IDMR1_AM7:     equ    %10000000


;*** CAN0IDMR2 - MSCAN 0 Identifier Mask Register 2; 0x00000156 ***
CAN0IDMR2:          equ    $00000156                                ;*** CAN0IDMR2 - MSCAN 0 Identifier Mask Register 2; 0x00000156 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0IDMR2_AM0:      equ    0                                         ; Acceptance Mask Bit 0
CAN0IDMR2_AM1:      equ    1                                         ; Acceptance Mask Bit 1
CAN0IDMR2_AM2:      equ    2                                         ; Acceptance Mask Bit 2
CAN0IDMR2_AM3:      equ    3                                         ; Acceptance Mask Bit 3
CAN0IDMR2_AM4:      equ    4                                         ; Acceptance Mask Bit 4
CAN0IDMR2_AM5:      equ    5                                         ; Acceptance Mask Bit 5
CAN0IDMR2_AM6:      equ    6                                         ; Acceptance Mask Bit 6
CAN0IDMR2_AM7:      equ    7                                         ; Acceptance Mask Bit 7
; bit position masks
mCAN0IDMR2_AM0:     equ    %00000001
mCAN0IDMR2_AM1:     equ    %00000010
mCAN0IDMR2_AM2:     equ    %00000100
mCAN0IDMR2_AM3:     equ    %00001000
mCAN0IDMR2_AM4:     equ    %00010000
mCAN0IDMR2_AM5:     equ    %00100000
mCAN0IDMR2_AM6:     equ    %01000000
mCAN0IDMR2_AM7:     equ    %10000000


;*** CAN0IDMR3 - MSCAN 0 Identifier Mask Register 3; 0x00000157 ***
CAN0IDMR3:          equ    $00000157                                ;*** CAN0IDMR3 - MSCAN 0 Identifier Mask Register 3; 0x00000157 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0IDMR3_AM0:      equ    0                                         ; Acceptance Mask Bit 0
CAN0IDMR3_AM1:      equ    1                                         ; Acceptance Mask Bit 1
CAN0IDMR3_AM2:      equ    2                                         ; Acceptance Mask Bit 2
CAN0IDMR3_AM3:      equ    3                                         ; Acceptance Mask Bit 3
CAN0IDMR3_AM4:      equ    4                                         ; Acceptance Mask Bit 4
CAN0IDMR3_AM5:      equ    5                                         ; Acceptance Mask Bit 5
CAN0IDMR3_AM6:      equ    6                                         ; Acceptance Mask Bit 6
CAN0IDMR3_AM7:      equ    7                                         ; Acceptance Mask Bit 7
; bit position masks
mCAN0IDMR3_AM0:     equ    %00000001
mCAN0IDMR3_AM1:     equ    %00000010
mCAN0IDMR3_AM2:     equ    %00000100
mCAN0IDMR3_AM3:     equ    %00001000
mCAN0IDMR3_AM4:     equ    %00010000
mCAN0IDMR3_AM5:     equ    %00100000
mCAN0IDMR3_AM6:     equ    %01000000
mCAN0IDMR3_AM7:     equ    %10000000


;*** CAN0IDAR4 - MSCAN 0 Identifier Acceptance Register 4; 0x00000158 ***
CAN0IDAR4:          equ    $00000158                                ;*** CAN0IDAR4 - MSCAN 0 Identifier Acceptance Register 4; 0x00000158 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0IDAR4_AC0:      equ    0                                         ; Acceptance Code Bit 0
CAN0IDAR4_AC1:      equ    1                                         ; Acceptance Code Bit 1
CAN0IDAR4_AC2:      equ    2                                         ; Acceptance Code Bit 2
CAN0IDAR4_AC3:      equ    3                                         ; Acceptance Code Bit 3
CAN0IDAR4_AC4:      equ    4                                         ; Acceptance Code Bit 4
CAN0IDAR4_AC5:      equ    5                                         ; Acceptance Code Bit 5
CAN0IDAR4_AC6:      equ    6                                         ; Acceptance Code Bit 6
CAN0IDAR4_AC7:      equ    7                                         ; Acceptance Code Bit 7
; bit position masks
mCAN0IDAR4_AC0:     equ    %00000001
mCAN0IDAR4_AC1:     equ    %00000010
mCAN0IDAR4_AC2:     equ    %00000100
mCAN0IDAR4_AC3:     equ    %00001000
mCAN0IDAR4_AC4:     equ    %00010000
mCAN0IDAR4_AC5:     equ    %00100000
mCAN0IDAR4_AC6:     equ    %01000000
mCAN0IDAR4_AC7:     equ    %10000000


;*** CAN0IDAR5 - MSCAN 0 Identifier Acceptance Register 5; 0x00000159 ***
CAN0IDAR5:          equ    $00000159                                ;*** CAN0IDAR5 - MSCAN 0 Identifier Acceptance Register 5; 0x00000159 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0IDAR5_AC0:      equ    0                                         ; Acceptance Code Bit 0
CAN0IDAR5_AC1:      equ    1                                         ; Acceptance Code Bit 1
CAN0IDAR5_AC2:      equ    2                                         ; Acceptance Code Bit 2
CAN0IDAR5_AC3:      equ    3                                         ; Acceptance Code Bit 3
CAN0IDAR5_AC4:      equ    4                                         ; Acceptance Code Bit 4
CAN0IDAR5_AC5:      equ    5                                         ; Acceptance Code Bit 5
CAN0IDAR5_AC6:      equ    6                                         ; Acceptance Code Bit 6
CAN0IDAR5_AC7:      equ    7                                         ; Acceptance Code Bit 7
; bit position masks
mCAN0IDAR5_AC0:     equ    %00000001
mCAN0IDAR5_AC1:     equ    %00000010
mCAN0IDAR5_AC2:     equ    %00000100
mCAN0IDAR5_AC3:     equ    %00001000
mCAN0IDAR5_AC4:     equ    %00010000
mCAN0IDAR5_AC5:     equ    %00100000
mCAN0IDAR5_AC6:     equ    %01000000
mCAN0IDAR5_AC7:     equ    %10000000


;*** CAN0IDAR6 - MSCAN 0 Identifier Acceptance Register 6; 0x0000015A ***
CAN0IDAR6:          equ    $0000015A                                ;*** CAN0IDAR6 - MSCAN 0 Identifier Acceptance Register 6; 0x0000015A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0IDAR6_AC0:      equ    0                                         ; Acceptance Code Bit 0
CAN0IDAR6_AC1:      equ    1                                         ; Acceptance Code Bit 1
CAN0IDAR6_AC2:      equ    2                                         ; Acceptance Code Bit 2
CAN0IDAR6_AC3:      equ    3                                         ; Acceptance Code Bit 3
CAN0IDAR6_AC4:      equ    4                                         ; Acceptance Code Bit 4
CAN0IDAR6_AC5:      equ    5                                         ; Acceptance Code Bit 5
CAN0IDAR6_AC6:      equ    6                                         ; Acceptance Code Bit 6
CAN0IDAR6_AC7:      equ    7                                         ; Acceptance Code Bit 7
; bit position masks
mCAN0IDAR6_AC0:     equ    %00000001
mCAN0IDAR6_AC1:     equ    %00000010
mCAN0IDAR6_AC2:     equ    %00000100
mCAN0IDAR6_AC3:     equ    %00001000
mCAN0IDAR6_AC4:     equ    %00010000
mCAN0IDAR6_AC5:     equ    %00100000
mCAN0IDAR6_AC6:     equ    %01000000
mCAN0IDAR6_AC7:     equ    %10000000


;*** CAN0IDAR7 - MSCAN 0 Identifier Acceptance Register 7; 0x0000015B ***
CAN0IDAR7:          equ    $0000015B                                ;*** CAN0IDAR7 - MSCAN 0 Identifier Acceptance Register 7; 0x0000015B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0IDAR7_AC0:      equ    0                                         ; Acceptance Code Bit 0
CAN0IDAR7_AC1:      equ    1                                         ; Acceptance Code Bit 1
CAN0IDAR7_AC2:      equ    2                                         ; Acceptance Code Bit 2
CAN0IDAR7_AC3:      equ    3                                         ; Acceptance Code Bit 3
CAN0IDAR7_AC4:      equ    4                                         ; Acceptance Code Bit 4
CAN0IDAR7_AC5:      equ    5                                         ; Acceptance Code Bit 5
CAN0IDAR7_AC6:      equ    6                                         ; Acceptance Code Bit 6
CAN0IDAR7_AC7:      equ    7                                         ; Acceptance Code Bit 7
; bit position masks
mCAN0IDAR7_AC0:     equ    %00000001
mCAN0IDAR7_AC1:     equ    %00000010
mCAN0IDAR7_AC2:     equ    %00000100
mCAN0IDAR7_AC3:     equ    %00001000
mCAN0IDAR7_AC4:     equ    %00010000
mCAN0IDAR7_AC5:     equ    %00100000
mCAN0IDAR7_AC6:     equ    %01000000
mCAN0IDAR7_AC7:     equ    %10000000


;*** CAN0IDMR4 - MSCAN 0 Identifier Mask Register 4; 0x0000015C ***
CAN0IDMR4:          equ    $0000015C                                ;*** CAN0IDMR4 - MSCAN 0 Identifier Mask Register 4; 0x0000015C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0IDMR4_AM0:      equ    0                                         ; Acceptance Mask Bit 0
CAN0IDMR4_AM1:      equ    1                                         ; Acceptance Mask Bit 1
CAN0IDMR4_AM2:      equ    2                                         ; Acceptance Mask Bit 2
CAN0IDMR4_AM3:      equ    3                                         ; Acceptance Mask Bit 3
CAN0IDMR4_AM4:      equ    4                                         ; Acceptance Mask Bit 4
CAN0IDMR4_AM5:      equ    5                                         ; Acceptance Mask Bit 5
CAN0IDMR4_AM6:      equ    6                                         ; Acceptance Mask Bit 6
CAN0IDMR4_AM7:      equ    7                                         ; Acceptance Mask Bit 7
; bit position masks
mCAN0IDMR4_AM0:     equ    %00000001
mCAN0IDMR4_AM1:     equ    %00000010
mCAN0IDMR4_AM2:     equ    %00000100
mCAN0IDMR4_AM3:     equ    %00001000
mCAN0IDMR4_AM4:     equ    %00010000
mCAN0IDMR4_AM5:     equ    %00100000
mCAN0IDMR4_AM6:     equ    %01000000
mCAN0IDMR4_AM7:     equ    %10000000


;*** CAN0IDMR5 - MSCAN 0 Identifier Mask Register 5; 0x0000015D ***
CAN0IDMR5:          equ    $0000015D                                ;*** CAN0IDMR5 - MSCAN 0 Identifier Mask Register 5; 0x0000015D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0IDMR5_AM0:      equ    0                                         ; Acceptance Mask Bit 0
CAN0IDMR5_AM1:      equ    1                                         ; Acceptance Mask Bit 1
CAN0IDMR5_AM2:      equ    2                                         ; Acceptance Mask Bit 2
CAN0IDMR5_AM3:      equ    3                                         ; Acceptance Mask Bit 3
CAN0IDMR5_AM4:      equ    4                                         ; Acceptance Mask Bit 4
CAN0IDMR5_AM5:      equ    5                                         ; Acceptance Mask Bit 5
CAN0IDMR5_AM6:      equ    6                                         ; Acceptance Mask Bit 6
CAN0IDMR5_AM7:      equ    7                                         ; Acceptance Mask Bit 7
; bit position masks
mCAN0IDMR5_AM0:     equ    %00000001
mCAN0IDMR5_AM1:     equ    %00000010
mCAN0IDMR5_AM2:     equ    %00000100
mCAN0IDMR5_AM3:     equ    %00001000
mCAN0IDMR5_AM4:     equ    %00010000
mCAN0IDMR5_AM5:     equ    %00100000
mCAN0IDMR5_AM6:     equ    %01000000
mCAN0IDMR5_AM7:     equ    %10000000


;*** CAN0IDMR6 - MSCAN 0 Identifier Mask Register 6; 0x0000015E ***
CAN0IDMR6:          equ    $0000015E                                ;*** CAN0IDMR6 - MSCAN 0 Identifier Mask Register 6; 0x0000015E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0IDMR6_AM0:      equ    0                                         ; Acceptance Mask Bit 0
CAN0IDMR6_AM1:      equ    1                                         ; Acceptance Mask Bit 1
CAN0IDMR6_AM2:      equ    2                                         ; Acceptance Mask Bit 2
CAN0IDMR6_AM3:      equ    3                                         ; Acceptance Mask Bit 3
CAN0IDMR6_AM4:      equ    4                                         ; Acceptance Mask Bit 4
CAN0IDMR6_AM5:      equ    5                                         ; Acceptance Mask Bit 5
CAN0IDMR6_AM6:      equ    6                                         ; Acceptance Mask Bit 6
CAN0IDMR6_AM7:      equ    7                                         ; Acceptance Mask Bit 7
; bit position masks
mCAN0IDMR6_AM0:     equ    %00000001
mCAN0IDMR6_AM1:     equ    %00000010
mCAN0IDMR6_AM2:     equ    %00000100
mCAN0IDMR6_AM3:     equ    %00001000
mCAN0IDMR6_AM4:     equ    %00010000
mCAN0IDMR6_AM5:     equ    %00100000
mCAN0IDMR6_AM6:     equ    %01000000
mCAN0IDMR6_AM7:     equ    %10000000


;*** CAN0IDMR7 - MSCAN 0 Identifier Mask Register 7; 0x0000015F ***
CAN0IDMR7:          equ    $0000015F                                ;*** CAN0IDMR7 - MSCAN 0 Identifier Mask Register 7; 0x0000015F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0IDMR7_AM0:      equ    0                                         ; Acceptance Mask Bit 0
CAN0IDMR7_AM1:      equ    1                                         ; Acceptance Mask Bit 1
CAN0IDMR7_AM2:      equ    2                                         ; Acceptance Mask Bit 2
CAN0IDMR7_AM3:      equ    3                                         ; Acceptance Mask Bit 3
CAN0IDMR7_AM4:      equ    4                                         ; Acceptance Mask Bit 4
CAN0IDMR7_AM5:      equ    5                                         ; Acceptance Mask Bit 5
CAN0IDMR7_AM6:      equ    6                                         ; Acceptance Mask Bit 6
CAN0IDMR7_AM7:      equ    7                                         ; Acceptance Mask Bit 7
; bit position masks
mCAN0IDMR7_AM0:     equ    %00000001
mCAN0IDMR7_AM1:     equ    %00000010
mCAN0IDMR7_AM2:     equ    %00000100
mCAN0IDMR7_AM3:     equ    %00001000
mCAN0IDMR7_AM4:     equ    %00010000
mCAN0IDMR7_AM5:     equ    %00100000
mCAN0IDMR7_AM6:     equ    %01000000
mCAN0IDMR7_AM7:     equ    %10000000


;*** CAN0RXIDR0 - MSCAN 0 Receive Identifier Register 0; 0x00000160 ***
CAN0RXIDR0:         equ    $00000160                                ;*** CAN0RXIDR0 - MSCAN 0 Receive Identifier Register 0; 0x00000160 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0RXIDR0_ID21:    equ    0                                         ; Extended format identifier Bit 21
CAN0RXIDR0_ID22:    equ    1                                         ; Extended format identifier Bit 22
CAN0RXIDR0_ID23:    equ    2                                         ; Extended format identifier Bit 23
CAN0RXIDR0_ID24:    equ    3                                         ; Extended format identifier Bit 24
CAN0RXIDR0_ID25:    equ    4                                         ; Extended format identifier Bit 25
CAN0RXIDR0_ID26:    equ    5                                         ; Extended format identifier Bit 26
CAN0RXIDR0_ID27:    equ    6                                         ; Extended format identifier Bit 27
CAN0RXIDR0_ID28:    equ    7                                         ; Extended format identifier Bit 28
; bit position masks
mCAN0RXIDR0_ID21:   equ    %00000001
mCAN0RXIDR0_ID22:   equ    %00000010
mCAN0RXIDR0_ID23:   equ    %00000100
mCAN0RXIDR0_ID24:   equ    %00001000
mCAN0RXIDR0_ID25:   equ    %00010000
mCAN0RXIDR0_ID26:   equ    %00100000
mCAN0RXIDR0_ID27:   equ    %01000000
mCAN0RXIDR0_ID28:   equ    %10000000


;*** CAN0RXIDR1 - MSCAN 0 Receive Identifier Register 1; 0x00000161 ***
CAN0RXIDR1:         equ    $00000161                                ;*** CAN0RXIDR1 - MSCAN 0 Receive Identifier Register 1; 0x00000161 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0RXIDR1_ID15:    equ    0                                         ; Extended format identifier Bit 15
CAN0RXIDR1_ID16:    equ    1                                         ; Extended format identifier Bit 16
CAN0RXIDR1_ID17:    equ    2                                         ; Extended format identifier Bit 17
CAN0RXIDR1_IDE:     equ    3                                         ; ID Extended
CAN0RXIDR1_SRR:     equ    4                                         ; Substitute Remote Request
CAN0RXIDR1_ID18:    equ    5                                         ; Extended format identifier Bit 18
CAN0RXIDR1_ID19:    equ    6                                         ; Extended format identifier Bit 19
CAN0RXIDR1_ID20:    equ    7                                         ; Extended format identifier Bit 20
; bit position masks
mCAN0RXIDR1_ID15:   equ    %00000001
mCAN0RXIDR1_ID16:   equ    %00000010
mCAN0RXIDR1_ID17:   equ    %00000100
mCAN0RXIDR1_IDE:    equ    %00001000
mCAN0RXIDR1_SRR:    equ    %00010000
mCAN0RXIDR1_ID18:   equ    %00100000
mCAN0RXIDR1_ID19:   equ    %01000000
mCAN0RXIDR1_ID20:   equ    %10000000


;*** CAN0RXIDR2 - MSCAN 0 Receive Identifier Register 2; 0x00000162 ***
CAN0RXIDR2:         equ    $00000162                                ;*** CAN0RXIDR2 - MSCAN 0 Receive Identifier Register 2; 0x00000162 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0RXIDR2_ID7:     equ    0                                         ; Extended format identifier Bit 7
CAN0RXIDR2_ID8:     equ    1                                         ; Extended format identifier Bit 8
CAN0RXIDR2_ID9:     equ    2                                         ; Extended format identifier Bit 9
CAN0RXIDR2_ID10:    equ    3                                         ; Extended format identifier Bit 10
CAN0RXIDR2_ID11:    equ    4                                         ; Extended format identifier Bit 11
CAN0RXIDR2_ID12:    equ    5                                         ; Extended format identifier Bit 12
CAN0RXIDR2_ID13:    equ    6                                         ; Extended format identifier Bit 13
CAN0RXIDR2_ID14:    equ    7                                         ; Extended format identifier Bit 14
; bit position masks
mCAN0RXIDR2_ID7:    equ    %00000001
mCAN0RXIDR2_ID8:    equ    %00000010
mCAN0RXIDR2_ID9:    equ    %00000100
mCAN0RXIDR2_ID10:   equ    %00001000
mCAN0RXIDR2_ID11:   equ    %00010000
mCAN0RXIDR2_ID12:   equ    %00100000
mCAN0RXIDR2_ID13:   equ    %01000000
mCAN0RXIDR2_ID14:   equ    %10000000


;*** CAN0RXIDR3 - MSCAN 0 Receive Identifier Register 3; 0x00000163 ***
CAN0RXIDR3:         equ    $00000163                                ;*** CAN0RXIDR3 - MSCAN 0 Receive Identifier Register 3; 0x00000163 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0RXIDR3_RTR:     equ    0                                         ; Remote Transmission Request
CAN0RXIDR3_ID0:     equ    1                                         ; Extended format identifier Bit 0
CAN0RXIDR3_ID1:     equ    2                                         ; Extended format identifier Bit 1
CAN0RXIDR3_ID2:     equ    3                                         ; Extended format identifier Bit 2
CAN0RXIDR3_ID3:     equ    4                                         ; Extended format identifier Bit 3
CAN0RXIDR3_ID4:     equ    5                                         ; Extended format identifier Bit 4
CAN0RXIDR3_ID5:     equ    6                                         ; Extended format identifier Bit 5
CAN0RXIDR3_ID6:     equ    7                                         ; Extended format identifier Bit 6
; bit position masks
mCAN0RXIDR3_RTR:    equ    %00000001
mCAN0RXIDR3_ID0:    equ    %00000010
mCAN0RXIDR3_ID1:    equ    %00000100
mCAN0RXIDR3_ID2:    equ    %00001000
mCAN0RXIDR3_ID3:    equ    %00010000
mCAN0RXIDR3_ID4:    equ    %00100000
mCAN0RXIDR3_ID5:    equ    %01000000
mCAN0RXIDR3_ID6:    equ    %10000000


;*** CAN0RXDSR0 - MSCAN 0 Receive Data Segment Register 0; 0x00000164 ***
CAN0RXDSR0:         equ    $00000164                                ;*** CAN0RXDSR0 - MSCAN 0 Receive Data Segment Register 0; 0x00000164 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0RXDSR0_DB0:     equ    0                                         ; Data Bit 0
CAN0RXDSR0_DB1:     equ    1                                         ; Data Bit 1
CAN0RXDSR0_DB2:     equ    2                                         ; Data Bit 2
CAN0RXDSR0_DB3:     equ    3                                         ; Data Bit 3
CAN0RXDSR0_DB4:     equ    4                                         ; Data Bit 4
CAN0RXDSR0_DB5:     equ    5                                         ; Data Bit 5
CAN0RXDSR0_DB6:     equ    6                                         ; Data Bit 6
CAN0RXDSR0_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN0RXDSR0_DB0:    equ    %00000001
mCAN0RXDSR0_DB1:    equ    %00000010
mCAN0RXDSR0_DB2:    equ    %00000100
mCAN0RXDSR0_DB3:    equ    %00001000
mCAN0RXDSR0_DB4:    equ    %00010000
mCAN0RXDSR0_DB5:    equ    %00100000
mCAN0RXDSR0_DB6:    equ    %01000000
mCAN0RXDSR0_DB7:    equ    %10000000


;*** CAN0RXDSR1 - MSCAN 0 Receive Data Segment Register 1; 0x00000165 ***
CAN0RXDSR1:         equ    $00000165                                ;*** CAN0RXDSR1 - MSCAN 0 Receive Data Segment Register 1; 0x00000165 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0RXDSR1_DB0:     equ    0                                         ; Data Bit 0
CAN0RXDSR1_DB1:     equ    1                                         ; Data Bit 1
CAN0RXDSR1_DB2:     equ    2                                         ; Data Bit 2
CAN0RXDSR1_DB3:     equ    3                                         ; Data Bit 3
CAN0RXDSR1_DB4:     equ    4                                         ; Data Bit 4
CAN0RXDSR1_DB5:     equ    5                                         ; Data Bit 5
CAN0RXDSR1_DB6:     equ    6                                         ; Data Bit 6
CAN0RXDSR1_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN0RXDSR1_DB0:    equ    %00000001
mCAN0RXDSR1_DB1:    equ    %00000010
mCAN0RXDSR1_DB2:    equ    %00000100
mCAN0RXDSR1_DB3:    equ    %00001000
mCAN0RXDSR1_DB4:    equ    %00010000
mCAN0RXDSR1_DB5:    equ    %00100000
mCAN0RXDSR1_DB6:    equ    %01000000
mCAN0RXDSR1_DB7:    equ    %10000000


;*** CAN0RXDSR2 - MSCAN 0 Receive Data Segment Register 2; 0x00000166 ***
CAN0RXDSR2:         equ    $00000166                                ;*** CAN0RXDSR2 - MSCAN 0 Receive Data Segment Register 2; 0x00000166 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0RXDSR2_DB0:     equ    0                                         ; Data Bit 0
CAN0RXDSR2_DB1:     equ    1                                         ; Data Bit 1
CAN0RXDSR2_DB2:     equ    2                                         ; Data Bit 2
CAN0RXDSR2_DB3:     equ    3                                         ; Data Bit 3
CAN0RXDSR2_DB4:     equ    4                                         ; Data Bit 4
CAN0RXDSR2_DB5:     equ    5                                         ; Data Bit 5
CAN0RXDSR2_DB6:     equ    6                                         ; Data Bit 6
CAN0RXDSR2_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN0RXDSR2_DB0:    equ    %00000001
mCAN0RXDSR2_DB1:    equ    %00000010
mCAN0RXDSR2_DB2:    equ    %00000100
mCAN0RXDSR2_DB3:    equ    %00001000
mCAN0RXDSR2_DB4:    equ    %00010000
mCAN0RXDSR2_DB5:    equ    %00100000
mCAN0RXDSR2_DB6:    equ    %01000000
mCAN0RXDSR2_DB7:    equ    %10000000


;*** CAN0RXDSR3 - MSCAN 0 Receive Data Segment Register 3; 0x00000167 ***
CAN0RXDSR3:         equ    $00000167                                ;*** CAN0RXDSR3 - MSCAN 0 Receive Data Segment Register 3; 0x00000167 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0RXDSR3_DB0:     equ    0                                         ; Data Bit 0
CAN0RXDSR3_DB1:     equ    1                                         ; Data Bit 1
CAN0RXDSR3_DB2:     equ    2                                         ; Data Bit 2
CAN0RXDSR3_DB3:     equ    3                                         ; Data Bit 3
CAN0RXDSR3_DB4:     equ    4                                         ; Data Bit 4
CAN0RXDSR3_DB5:     equ    5                                         ; Data Bit 5
CAN0RXDSR3_DB6:     equ    6                                         ; Data Bit 6
CAN0RXDSR3_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN0RXDSR3_DB0:    equ    %00000001
mCAN0RXDSR3_DB1:    equ    %00000010
mCAN0RXDSR3_DB2:    equ    %00000100
mCAN0RXDSR3_DB3:    equ    %00001000
mCAN0RXDSR3_DB4:    equ    %00010000
mCAN0RXDSR3_DB5:    equ    %00100000
mCAN0RXDSR3_DB6:    equ    %01000000
mCAN0RXDSR3_DB7:    equ    %10000000


;*** CAN0RXDSR4 - MSCAN 0 Receive Data Segment Register 4; 0x00000168 ***
CAN0RXDSR4:         equ    $00000168                                ;*** CAN0RXDSR4 - MSCAN 0 Receive Data Segment Register 4; 0x00000168 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0RXDSR4_DB0:     equ    0                                         ; Data Bit 0
CAN0RXDSR4_DB1:     equ    1                                         ; Data Bit 1
CAN0RXDSR4_DB2:     equ    2                                         ; Data Bit 2
CAN0RXDSR4_DB3:     equ    3                                         ; Data Bit 3
CAN0RXDSR4_DB4:     equ    4                                         ; Data Bit 4
CAN0RXDSR4_DB5:     equ    5                                         ; Data Bit 5
CAN0RXDSR4_DB6:     equ    6                                         ; Data Bit 6
CAN0RXDSR4_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN0RXDSR4_DB0:    equ    %00000001
mCAN0RXDSR4_DB1:    equ    %00000010
mCAN0RXDSR4_DB2:    equ    %00000100
mCAN0RXDSR4_DB3:    equ    %00001000
mCAN0RXDSR4_DB4:    equ    %00010000
mCAN0RXDSR4_DB5:    equ    %00100000
mCAN0RXDSR4_DB6:    equ    %01000000
mCAN0RXDSR4_DB7:    equ    %10000000


;*** CAN0RXDSR5 - MSCAN 0 Receive Data Segment Register 5; 0x00000169 ***
CAN0RXDSR5:         equ    $00000169                                ;*** CAN0RXDSR5 - MSCAN 0 Receive Data Segment Register 5; 0x00000169 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0RXDSR5_DB0:     equ    0                                         ; Data Bit 0
CAN0RXDSR5_DB1:     equ    1                                         ; Data Bit 1
CAN0RXDSR5_DB2:     equ    2                                         ; Data Bit 2
CAN0RXDSR5_DB3:     equ    3                                         ; Data Bit 3
CAN0RXDSR5_DB4:     equ    4                                         ; Data Bit 4
CAN0RXDSR5_DB5:     equ    5                                         ; Data Bit 5
CAN0RXDSR5_DB6:     equ    6                                         ; Data Bit 6
CAN0RXDSR5_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN0RXDSR5_DB0:    equ    %00000001
mCAN0RXDSR5_DB1:    equ    %00000010
mCAN0RXDSR5_DB2:    equ    %00000100
mCAN0RXDSR5_DB3:    equ    %00001000
mCAN0RXDSR5_DB4:    equ    %00010000
mCAN0RXDSR5_DB5:    equ    %00100000
mCAN0RXDSR5_DB6:    equ    %01000000
mCAN0RXDSR5_DB7:    equ    %10000000


;*** CAN0RXDSR6 - MSCAN 0 Receive Data Segment Register 6; 0x0000016A ***
CAN0RXDSR6:         equ    $0000016A                                ;*** CAN0RXDSR6 - MSCAN 0 Receive Data Segment Register 6; 0x0000016A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0RXDSR6_DB0:     equ    0                                         ; Data Bit 0
CAN0RXDSR6_DB1:     equ    1                                         ; Data Bit 1
CAN0RXDSR6_DB2:     equ    2                                         ; Data Bit 2
CAN0RXDSR6_DB3:     equ    3                                         ; Data Bit 3
CAN0RXDSR6_DB4:     equ    4                                         ; Data Bit 4
CAN0RXDSR6_DB5:     equ    5                                         ; Data Bit 5
CAN0RXDSR6_DB6:     equ    6                                         ; Data Bit 6
CAN0RXDSR6_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN0RXDSR6_DB0:    equ    %00000001
mCAN0RXDSR6_DB1:    equ    %00000010
mCAN0RXDSR6_DB2:    equ    %00000100
mCAN0RXDSR6_DB3:    equ    %00001000
mCAN0RXDSR6_DB4:    equ    %00010000
mCAN0RXDSR6_DB5:    equ    %00100000
mCAN0RXDSR6_DB6:    equ    %01000000
mCAN0RXDSR6_DB7:    equ    %10000000


;*** CAN0RXDSR7 - MSCAN 0 Receive Data Segment Register 7; 0x0000016B ***
CAN0RXDSR7:         equ    $0000016B                                ;*** CAN0RXDSR7 - MSCAN 0 Receive Data Segment Register 7; 0x0000016B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0RXDSR7_DB0:     equ    0                                         ; Data Bit 0
CAN0RXDSR7_DB1:     equ    1                                         ; Data Bit 1
CAN0RXDSR7_DB2:     equ    2                                         ; Data Bit 2
CAN0RXDSR7_DB3:     equ    3                                         ; Data Bit 3
CAN0RXDSR7_DB4:     equ    4                                         ; Data Bit 4
CAN0RXDSR7_DB5:     equ    5                                         ; Data Bit 5
CAN0RXDSR7_DB6:     equ    6                                         ; Data Bit 6
CAN0RXDSR7_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN0RXDSR7_DB0:    equ    %00000001
mCAN0RXDSR7_DB1:    equ    %00000010
mCAN0RXDSR7_DB2:    equ    %00000100
mCAN0RXDSR7_DB3:    equ    %00001000
mCAN0RXDSR7_DB4:    equ    %00010000
mCAN0RXDSR7_DB5:    equ    %00100000
mCAN0RXDSR7_DB6:    equ    %01000000
mCAN0RXDSR7_DB7:    equ    %10000000


;*** CAN0RXDLR - MSCAN 0 Receive Data Length Register; 0x0000016C ***
CAN0RXDLR:          equ    $0000016C                                ;*** CAN0RXDLR - MSCAN 0 Receive Data Length Register; 0x0000016C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0RXDLR_DLC0:     equ    0                                         ; Data Length Code Bit 0
CAN0RXDLR_DLC1:     equ    1                                         ; Data Length Code Bit 1
CAN0RXDLR_DLC2:     equ    2                                         ; Data Length Code Bit 2
CAN0RXDLR_DLC3:     equ    3                                         ; Data Length Code Bit 3
; bit position masks
mCAN0RXDLR_DLC0:    equ    %00000001
mCAN0RXDLR_DLC1:    equ    %00000010
mCAN0RXDLR_DLC2:    equ    %00000100
mCAN0RXDLR_DLC3:    equ    %00001000


;*** CAN0RXTSR - MSCAN 0 Receive Time Stamp Register; 0x0000016E ***
CAN0RXTSR:          equ    $0000016E                                ;*** CAN0RXTSR - MSCAN 0 Receive Time Stamp Register; 0x0000016E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0RXTSR_TSR0:     equ    0                                         ; Time Stamp Bit 0
CAN0RXTSR_TSR1:     equ    1                                         ; Time Stamp Bit 1
CAN0RXTSR_TSR2:     equ    2                                         ; Time Stamp Bit 2
CAN0RXTSR_TSR3:     equ    3                                         ; Time Stamp Bit 3
CAN0RXTSR_TSR4:     equ    4                                         ; Time Stamp Bit 4
CAN0RXTSR_TSR5:     equ    5                                         ; Time Stamp Bit 5
CAN0RXTSR_TSR6:     equ    6                                         ; Time Stamp Bit 6
CAN0RXTSR_TSR7:     equ    7                                         ; Time Stamp Bit 7
CAN0RXTSR_TSR8:     equ    8                                         ; Time Stamp Bit 8
CAN0RXTSR_TSR9:     equ    9                                         ; Time Stamp Bit 9
CAN0RXTSR_TSR10:    equ    10                                        ; Time Stamp Bit 10
CAN0RXTSR_TSR11:    equ    11                                        ; Time Stamp Bit 11
CAN0RXTSR_TSR12:    equ    12                                        ; Time Stamp Bit 12
CAN0RXTSR_TSR13:    equ    13                                        ; Time Stamp Bit 13
CAN0RXTSR_TSR14:    equ    14                                        ; Time Stamp Bit 14
CAN0RXTSR_TSR15:    equ    15                                        ; Time Stamp Bit 15
; bit position masks
mCAN0RXTSR_TSR0:    equ    %00000001
mCAN0RXTSR_TSR1:    equ    %00000010
mCAN0RXTSR_TSR2:    equ    %00000100
mCAN0RXTSR_TSR3:    equ    %00001000
mCAN0RXTSR_TSR4:    equ    %00010000
mCAN0RXTSR_TSR5:    equ    %00100000
mCAN0RXTSR_TSR6:    equ    %01000000
mCAN0RXTSR_TSR7:    equ    %10000000
mCAN0RXTSR_TSR8:    equ    %100000000
mCAN0RXTSR_TSR9:    equ    %1000000000
mCAN0RXTSR_TSR10:   equ    %10000000000
mCAN0RXTSR_TSR11:   equ    %100000000000
mCAN0RXTSR_TSR12:   equ    %1000000000000
mCAN0RXTSR_TSR13:   equ    %10000000000000
mCAN0RXTSR_TSR14:   equ    %100000000000000
mCAN0RXTSR_TSR15:   equ    %1000000000000000


;*** CAN0RXTSRH - MSCAN 0 Receive Time Stamp Register High; 0x0000016E ***
CAN0RXTSRH:         equ    $0000016E                                ;*** CAN0RXTSRH - MSCAN 0 Receive Time Stamp Register High; 0x0000016E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0RXTSRH_TSR8:    equ    0                                         ; Time Stamp Bit 8
CAN0RXTSRH_TSR9:    equ    1                                         ; Time Stamp Bit 9
CAN0RXTSRH_TSR10:   equ    2                                         ; Time Stamp Bit 10
CAN0RXTSRH_TSR11:   equ    3                                         ; Time Stamp Bit 11
CAN0RXTSRH_TSR12:   equ    4                                         ; Time Stamp Bit 12
CAN0RXTSRH_TSR13:   equ    5                                         ; Time Stamp Bit 13
CAN0RXTSRH_TSR14:   equ    6                                         ; Time Stamp Bit 14
CAN0RXTSRH_TSR15:   equ    7                                         ; Time Stamp Bit 15
; bit position masks
mCAN0RXTSRH_TSR8:   equ    %00000001
mCAN0RXTSRH_TSR9:   equ    %00000010
mCAN0RXTSRH_TSR10:  equ    %00000100
mCAN0RXTSRH_TSR11:  equ    %00001000
mCAN0RXTSRH_TSR12:  equ    %00010000
mCAN0RXTSRH_TSR13:  equ    %00100000
mCAN0RXTSRH_TSR14:  equ    %01000000
mCAN0RXTSRH_TSR15:  equ    %10000000


;*** CAN0RXTSRL - MSCAN 0 Receive Time Stamp Register Low; 0x0000016F ***
CAN0RXTSRL:         equ    $0000016F                                ;*** CAN0RXTSRL - MSCAN 0 Receive Time Stamp Register Low; 0x0000016F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0RXTSRL_TSR0:    equ    0                                         ; Time Stamp Bit 0
CAN0RXTSRL_TSR1:    equ    1                                         ; Time Stamp Bit 1
CAN0RXTSRL_TSR2:    equ    2                                         ; Time Stamp Bit 2
CAN0RXTSRL_TSR3:    equ    3                                         ; Time Stamp Bit 3
CAN0RXTSRL_TSR4:    equ    4                                         ; Time Stamp Bit 4
CAN0RXTSRL_TSR5:    equ    5                                         ; Time Stamp Bit 5
CAN0RXTSRL_TSR6:    equ    6                                         ; Time Stamp Bit 6
CAN0RXTSRL_TSR7:    equ    7                                         ; Time Stamp Bit 7
; bit position masks
mCAN0RXTSRL_TSR0:   equ    %00000001
mCAN0RXTSRL_TSR1:   equ    %00000010
mCAN0RXTSRL_TSR2:   equ    %00000100
mCAN0RXTSRL_TSR3:   equ    %00001000
mCAN0RXTSRL_TSR4:   equ    %00010000
mCAN0RXTSRL_TSR5:   equ    %00100000
mCAN0RXTSRL_TSR6:   equ    %01000000
mCAN0RXTSRL_TSR7:   equ    %10000000


;*** CAN0TXIDR0 - MSCAN 0 Transmit Identifier Register 0; 0x00000170 ***
CAN0TXIDR0:         equ    $00000170                                ;*** CAN0TXIDR0 - MSCAN 0 Transmit Identifier Register 0; 0x00000170 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0TXIDR0_ID21:    equ    0                                         ; Extended format identifier Bit 21
CAN0TXIDR0_ID22:    equ    1                                         ; Extended format identifier Bit 22
CAN0TXIDR0_ID23:    equ    2                                         ; Extended format identifier Bit 23
CAN0TXIDR0_ID24:    equ    3                                         ; Extended format identifier Bit 24
CAN0TXIDR0_ID25:    equ    4                                         ; Extended format identifier Bit 25
CAN0TXIDR0_ID26:    equ    5                                         ; Extended format identifier Bit 26
CAN0TXIDR0_ID27:    equ    6                                         ; Extended format identifier Bit 27
CAN0TXIDR0_ID28:    equ    7                                         ; Extended format identifier Bit 28
; bit position masks
mCAN0TXIDR0_ID21:   equ    %00000001
mCAN0TXIDR0_ID22:   equ    %00000010
mCAN0TXIDR0_ID23:   equ    %00000100
mCAN0TXIDR0_ID24:   equ    %00001000
mCAN0TXIDR0_ID25:   equ    %00010000
mCAN0TXIDR0_ID26:   equ    %00100000
mCAN0TXIDR0_ID27:   equ    %01000000
mCAN0TXIDR0_ID28:   equ    %10000000


;*** CAN0TXIDR1 - MSCAN 0 Transmit Identifier Register 1; 0x00000171 ***
CAN0TXIDR1:         equ    $00000171                                ;*** CAN0TXIDR1 - MSCAN 0 Transmit Identifier Register 1; 0x00000171 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0TXIDR1_ID15:    equ    0                                         ; Extended format identifier Bit 15
CAN0TXIDR1_ID16:    equ    1                                         ; Extended format identifier Bit 16
CAN0TXIDR1_ID17:    equ    2                                         ; Extended format identifier Bit 17
CAN0TXIDR1_IDE:     equ    3                                         ; ID Extended
CAN0TXIDR1_SRR:     equ    4                                         ; Substitute Remote Request
CAN0TXIDR1_ID18:    equ    5                                         ; Extended format identifier Bit 18
CAN0TXIDR1_ID19:    equ    6                                         ; Extended format identifier Bit 19
CAN0TXIDR1_ID20:    equ    7                                         ; Extended format identifier Bit 20
; bit position masks
mCAN0TXIDR1_ID15:   equ    %00000001
mCAN0TXIDR1_ID16:   equ    %00000010
mCAN0TXIDR1_ID17:   equ    %00000100
mCAN0TXIDR1_IDE:    equ    %00001000
mCAN0TXIDR1_SRR:    equ    %00010000
mCAN0TXIDR1_ID18:   equ    %00100000
mCAN0TXIDR1_ID19:   equ    %01000000
mCAN0TXIDR1_ID20:   equ    %10000000


;*** CAN0TXIDR2 - MSCAN 0 Transmit Identifier Register 2; 0x00000172 ***
CAN0TXIDR2:         equ    $00000172                                ;*** CAN0TXIDR2 - MSCAN 0 Transmit Identifier Register 2; 0x00000172 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0TXIDR2_ID7:     equ    0                                         ; Extended format identifier Bit 7
CAN0TXIDR2_ID8:     equ    1                                         ; Extended format identifier Bit 8
CAN0TXIDR2_ID9:     equ    2                                         ; Extended format identifier Bit 9
CAN0TXIDR2_ID10:    equ    3                                         ; Extended format identifier Bit 10
CAN0TXIDR2_ID11:    equ    4                                         ; Extended format identifier Bit 11
CAN0TXIDR2_ID12:    equ    5                                         ; Extended format identifier Bit 12
CAN0TXIDR2_ID13:    equ    6                                         ; Extended format identifier Bit 13
CAN0TXIDR2_ID14:    equ    7                                         ; Extended format identifier Bit 14
; bit position masks
mCAN0TXIDR2_ID7:    equ    %00000001
mCAN0TXIDR2_ID8:    equ    %00000010
mCAN0TXIDR2_ID9:    equ    %00000100
mCAN0TXIDR2_ID10:   equ    %00001000
mCAN0TXIDR2_ID11:   equ    %00010000
mCAN0TXIDR2_ID12:   equ    %00100000
mCAN0TXIDR2_ID13:   equ    %01000000
mCAN0TXIDR2_ID14:   equ    %10000000


;*** CAN0TXIDR3 - MSCAN 0 Transmit Identifier Register 3; 0x00000173 ***
CAN0TXIDR3:         equ    $00000173                                ;*** CAN0TXIDR3 - MSCAN 0 Transmit Identifier Register 3; 0x00000173 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0TXIDR3_RTR:     equ    0                                         ; Remote Transmission Request
CAN0TXIDR3_ID0:     equ    1                                         ; Extended format identifier Bit 0
CAN0TXIDR3_ID1:     equ    2                                         ; Extended format identifier Bit 1
CAN0TXIDR3_ID2:     equ    3                                         ; Extended format identifier Bit 2
CAN0TXIDR3_ID3:     equ    4                                         ; Extended format identifier Bit 3
CAN0TXIDR3_ID4:     equ    5                                         ; Extended format identifier Bit 4
CAN0TXIDR3_ID5:     equ    6                                         ; Extended format identifier Bit 5
CAN0TXIDR3_ID6:     equ    7                                         ; Extended format identifier Bit 6
; bit position masks
mCAN0TXIDR3_RTR:    equ    %00000001
mCAN0TXIDR3_ID0:    equ    %00000010
mCAN0TXIDR3_ID1:    equ    %00000100
mCAN0TXIDR3_ID2:    equ    %00001000
mCAN0TXIDR3_ID3:    equ    %00010000
mCAN0TXIDR3_ID4:    equ    %00100000
mCAN0TXIDR3_ID5:    equ    %01000000
mCAN0TXIDR3_ID6:    equ    %10000000


;*** CAN0TXDSR0 - MSCAN 0 Transmit Data Segment Register 0; 0x00000174 ***
CAN0TXDSR0:         equ    $00000174                                ;*** CAN0TXDSR0 - MSCAN 0 Transmit Data Segment Register 0; 0x00000174 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0TXDSR0_DB0:     equ    0                                         ; Data Bit 0
CAN0TXDSR0_DB1:     equ    1                                         ; Data Bit 1
CAN0TXDSR0_DB2:     equ    2                                         ; Data Bit 2
CAN0TXDSR0_DB3:     equ    3                                         ; Data Bit 3
CAN0TXDSR0_DB4:     equ    4                                         ; Data Bit 4
CAN0TXDSR0_DB5:     equ    5                                         ; Data Bit 5
CAN0TXDSR0_DB6:     equ    6                                         ; Data Bit 6
CAN0TXDSR0_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN0TXDSR0_DB0:    equ    %00000001
mCAN0TXDSR0_DB1:    equ    %00000010
mCAN0TXDSR0_DB2:    equ    %00000100
mCAN0TXDSR0_DB3:    equ    %00001000
mCAN0TXDSR0_DB4:    equ    %00010000
mCAN0TXDSR0_DB5:    equ    %00100000
mCAN0TXDSR0_DB6:    equ    %01000000
mCAN0TXDSR0_DB7:    equ    %10000000


;*** CAN0TXDSR1 - MSCAN 0 Transmit Data Segment Register 1; 0x00000175 ***
CAN0TXDSR1:         equ    $00000175                                ;*** CAN0TXDSR1 - MSCAN 0 Transmit Data Segment Register 1; 0x00000175 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0TXDSR1_DB0:     equ    0                                         ; Data Bit 0
CAN0TXDSR1_DB1:     equ    1                                         ; Data Bit 1
CAN0TXDSR1_DB2:     equ    2                                         ; Data Bit 2
CAN0TXDSR1_DB3:     equ    3                                         ; Data Bit 3
CAN0TXDSR1_DB4:     equ    4                                         ; Data Bit 4
CAN0TXDSR1_DB5:     equ    5                                         ; Data Bit 5
CAN0TXDSR1_DB6:     equ    6                                         ; Data Bit 6
CAN0TXDSR1_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN0TXDSR1_DB0:    equ    %00000001
mCAN0TXDSR1_DB1:    equ    %00000010
mCAN0TXDSR1_DB2:    equ    %00000100
mCAN0TXDSR1_DB3:    equ    %00001000
mCAN0TXDSR1_DB4:    equ    %00010000
mCAN0TXDSR1_DB5:    equ    %00100000
mCAN0TXDSR1_DB6:    equ    %01000000
mCAN0TXDSR1_DB7:    equ    %10000000


;*** CAN0TXDSR2 - MSCAN 0 Transmit Data Segment Register 2; 0x00000176 ***
CAN0TXDSR2:         equ    $00000176                                ;*** CAN0TXDSR2 - MSCAN 0 Transmit Data Segment Register 2; 0x00000176 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0TXDSR2_DB0:     equ    0                                         ; Data Bit 0
CAN0TXDSR2_DB1:     equ    1                                         ; Data Bit 1
CAN0TXDSR2_DB2:     equ    2                                         ; Data Bit 2
CAN0TXDSR2_DB3:     equ    3                                         ; Data Bit 3
CAN0TXDSR2_DB4:     equ    4                                         ; Data Bit 4
CAN0TXDSR2_DB5:     equ    5                                         ; Data Bit 5
CAN0TXDSR2_DB6:     equ    6                                         ; Data Bit 6
CAN0TXDSR2_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN0TXDSR2_DB0:    equ    %00000001
mCAN0TXDSR2_DB1:    equ    %00000010
mCAN0TXDSR2_DB2:    equ    %00000100
mCAN0TXDSR2_DB3:    equ    %00001000
mCAN0TXDSR2_DB4:    equ    %00010000
mCAN0TXDSR2_DB5:    equ    %00100000
mCAN0TXDSR2_DB6:    equ    %01000000
mCAN0TXDSR2_DB7:    equ    %10000000


;*** CAN0TXDSR3 - MSCAN 0 Transmit Data Segment Register 3; 0x00000177 ***
CAN0TXDSR3:         equ    $00000177                                ;*** CAN0TXDSR3 - MSCAN 0 Transmit Data Segment Register 3; 0x00000177 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0TXDSR3_DB0:     equ    0                                         ; Data Bit 0
CAN0TXDSR3_DB1:     equ    1                                         ; Data Bit 1
CAN0TXDSR3_DB2:     equ    2                                         ; Data Bit 2
CAN0TXDSR3_DB3:     equ    3                                         ; Data Bit 3
CAN0TXDSR3_DB4:     equ    4                                         ; Data Bit 4
CAN0TXDSR3_DB5:     equ    5                                         ; Data Bit 5
CAN0TXDSR3_DB6:     equ    6                                         ; Data Bit 6
CAN0TXDSR3_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN0TXDSR3_DB0:    equ    %00000001
mCAN0TXDSR3_DB1:    equ    %00000010
mCAN0TXDSR3_DB2:    equ    %00000100
mCAN0TXDSR3_DB3:    equ    %00001000
mCAN0TXDSR3_DB4:    equ    %00010000
mCAN0TXDSR3_DB5:    equ    %00100000
mCAN0TXDSR3_DB6:    equ    %01000000
mCAN0TXDSR3_DB7:    equ    %10000000


;*** CAN0TXDSR4 - MSCAN 0 Transmit Data Segment Register 4; 0x00000178 ***
CAN0TXDSR4:         equ    $00000178                                ;*** CAN0TXDSR4 - MSCAN 0 Transmit Data Segment Register 4; 0x00000178 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0TXDSR4_DB0:     equ    0                                         ; Data Bit 0
CAN0TXDSR4_DB1:     equ    1                                         ; Data Bit 1
CAN0TXDSR4_DB2:     equ    2                                         ; Data Bit 2
CAN0TXDSR4_DB3:     equ    3                                         ; Data Bit 3
CAN0TXDSR4_DB4:     equ    4                                         ; Data Bit 4
CAN0TXDSR4_DB5:     equ    5                                         ; Data Bit 5
CAN0TXDSR4_DB6:     equ    6                                         ; Data Bit 6
CAN0TXDSR4_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN0TXDSR4_DB0:    equ    %00000001
mCAN0TXDSR4_DB1:    equ    %00000010
mCAN0TXDSR4_DB2:    equ    %00000100
mCAN0TXDSR4_DB3:    equ    %00001000
mCAN0TXDSR4_DB4:    equ    %00010000
mCAN0TXDSR4_DB5:    equ    %00100000
mCAN0TXDSR4_DB6:    equ    %01000000
mCAN0TXDSR4_DB7:    equ    %10000000


;*** CAN0TXDSR5 - MSCAN 0 Transmit Data Segment Register 5; 0x00000179 ***
CAN0TXDSR5:         equ    $00000179                                ;*** CAN0TXDSR5 - MSCAN 0 Transmit Data Segment Register 5; 0x00000179 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0TXDSR5_DB0:     equ    0                                         ; Data Bit 0
CAN0TXDSR5_DB1:     equ    1                                         ; Data Bit 1
CAN0TXDSR5_DB2:     equ    2                                         ; Data Bit 2
CAN0TXDSR5_DB3:     equ    3                                         ; Data Bit 3
CAN0TXDSR5_DB4:     equ    4                                         ; Data Bit 4
CAN0TXDSR5_DB5:     equ    5                                         ; Data Bit 5
CAN0TXDSR5_DB6:     equ    6                                         ; Data Bit 6
CAN0TXDSR5_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN0TXDSR5_DB0:    equ    %00000001
mCAN0TXDSR5_DB1:    equ    %00000010
mCAN0TXDSR5_DB2:    equ    %00000100
mCAN0TXDSR5_DB3:    equ    %00001000
mCAN0TXDSR5_DB4:    equ    %00010000
mCAN0TXDSR5_DB5:    equ    %00100000
mCAN0TXDSR5_DB6:    equ    %01000000
mCAN0TXDSR5_DB7:    equ    %10000000


;*** CAN0TXDSR6 - MSCAN 0 Transmit Data Segment Register 6; 0x0000017A ***
CAN0TXDSR6:         equ    $0000017A                                ;*** CAN0TXDSR6 - MSCAN 0 Transmit Data Segment Register 6; 0x0000017A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0TXDSR6_DB0:     equ    0                                         ; Data Bit 0
CAN0TXDSR6_DB1:     equ    1                                         ; Data Bit 1
CAN0TXDSR6_DB2:     equ    2                                         ; Data Bit 2
CAN0TXDSR6_DB3:     equ    3                                         ; Data Bit 3
CAN0TXDSR6_DB4:     equ    4                                         ; Data Bit 4
CAN0TXDSR6_DB5:     equ    5                                         ; Data Bit 5
CAN0TXDSR6_DB6:     equ    6                                         ; Data Bit 6
CAN0TXDSR6_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN0TXDSR6_DB0:    equ    %00000001
mCAN0TXDSR6_DB1:    equ    %00000010
mCAN0TXDSR6_DB2:    equ    %00000100
mCAN0TXDSR6_DB3:    equ    %00001000
mCAN0TXDSR6_DB4:    equ    %00010000
mCAN0TXDSR6_DB5:    equ    %00100000
mCAN0TXDSR6_DB6:    equ    %01000000
mCAN0TXDSR6_DB7:    equ    %10000000


;*** CAN0TXDSR7 - MSCAN 0 Transmit Data Segment Register 7; 0x0000017B ***
CAN0TXDSR7:         equ    $0000017B                                ;*** CAN0TXDSR7 - MSCAN 0 Transmit Data Segment Register 7; 0x0000017B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0TXDSR7_DB0:     equ    0                                         ; Data Bit 0
CAN0TXDSR7_DB1:     equ    1                                         ; Data Bit 1
CAN0TXDSR7_DB2:     equ    2                                         ; Data Bit 2
CAN0TXDSR7_DB3:     equ    3                                         ; Data Bit 3
CAN0TXDSR7_DB4:     equ    4                                         ; Data Bit 4
CAN0TXDSR7_DB5:     equ    5                                         ; Data Bit 5
CAN0TXDSR7_DB6:     equ    6                                         ; Data Bit 6
CAN0TXDSR7_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN0TXDSR7_DB0:    equ    %00000001
mCAN0TXDSR7_DB1:    equ    %00000010
mCAN0TXDSR7_DB2:    equ    %00000100
mCAN0TXDSR7_DB3:    equ    %00001000
mCAN0TXDSR7_DB4:    equ    %00010000
mCAN0TXDSR7_DB5:    equ    %00100000
mCAN0TXDSR7_DB6:    equ    %01000000
mCAN0TXDSR7_DB7:    equ    %10000000


;*** CAN0TXDLR - MSCAN 0 Transmit Data Length Register; 0x0000017C ***
CAN0TXDLR:          equ    $0000017C                                ;*** CAN0TXDLR - MSCAN 0 Transmit Data Length Register; 0x0000017C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0TXDLR_DLC0:     equ    0                                         ; Data Length Code Bit 0
CAN0TXDLR_DLC1:     equ    1                                         ; Data Length Code Bit 1
CAN0TXDLR_DLC2:     equ    2                                         ; Data Length Code Bit 2
CAN0TXDLR_DLC3:     equ    3                                         ; Data Length Code Bit 3
; bit position masks
mCAN0TXDLR_DLC0:    equ    %00000001
mCAN0TXDLR_DLC1:    equ    %00000010
mCAN0TXDLR_DLC2:    equ    %00000100
mCAN0TXDLR_DLC3:    equ    %00001000


;*** CAN0TXTBPR - MSCAN 0 Transmit Buffer Priority; 0x0000017D ***
CAN0TXTBPR:         equ    $0000017D                                ;*** CAN0TXTBPR - MSCAN 0 Transmit Buffer Priority; 0x0000017D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0TXTBPR_PRIO0:   equ    0                                         ; Transmit Buffer Priority Bit 0
CAN0TXTBPR_PRIO1:   equ    1                                         ; Transmit Buffer Priority Bit 1
CAN0TXTBPR_PRIO2:   equ    2                                         ; Transmit Buffer Priority Bit 2
CAN0TXTBPR_PRIO3:   equ    3                                         ; Transmit Buffer Priority Bit 3
CAN0TXTBPR_PRIO4:   equ    4                                         ; Transmit Buffer Priority Bit 4
CAN0TXTBPR_PRIO5:   equ    5                                         ; Transmit Buffer Priority Bit 5
CAN0TXTBPR_PRIO6:   equ    6                                         ; Transmit Buffer Priority Bit 6
CAN0TXTBPR_PRIO7:   equ    7                                         ; Transmit Buffer Priority Bit 7
; bit position masks
mCAN0TXTBPR_PRIO0:  equ    %00000001
mCAN0TXTBPR_PRIO1:  equ    %00000010
mCAN0TXTBPR_PRIO2:  equ    %00000100
mCAN0TXTBPR_PRIO3:  equ    %00001000
mCAN0TXTBPR_PRIO4:  equ    %00010000
mCAN0TXTBPR_PRIO5:  equ    %00100000
mCAN0TXTBPR_PRIO6:  equ    %01000000
mCAN0TXTBPR_PRIO7:  equ    %10000000


;*** CAN0TXTSR - MSCAN 0 Transmit Time Stamp Register; 0x0000017E ***
CAN0TXTSR:          equ    $0000017E                                ;*** CAN0TXTSR - MSCAN 0 Transmit Time Stamp Register; 0x0000017E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0TXTSR_TSR0:     equ    0                                         ; Time Stamp Bit 0
CAN0TXTSR_TSR1:     equ    1                                         ; Time Stamp Bit 1
CAN0TXTSR_TSR2:     equ    2                                         ; Time Stamp Bit 2
CAN0TXTSR_TSR3:     equ    3                                         ; Time Stamp Bit 3
CAN0TXTSR_TSR4:     equ    4                                         ; Time Stamp Bit 4
CAN0TXTSR_TSR5:     equ    5                                         ; Time Stamp Bit 5
CAN0TXTSR_TSR6:     equ    6                                         ; Time Stamp Bit 6
CAN0TXTSR_TSR7:     equ    7                                         ; Time Stamp Bit 7
CAN0TXTSR_TSR8:     equ    8                                         ; Time Stamp Bit 8
CAN0TXTSR_TSR9:     equ    9                                         ; Time Stamp Bit 9
CAN0TXTSR_TSR10:    equ    10                                        ; Time Stamp Bit 10
CAN0TXTSR_TSR11:    equ    11                                        ; Time Stamp Bit 11
CAN0TXTSR_TSR12:    equ    12                                        ; Time Stamp Bit 12
CAN0TXTSR_TSR13:    equ    13                                        ; Time Stamp Bit 13
CAN0TXTSR_TSR14:    equ    14                                        ; Time Stamp Bit 14
CAN0TXTSR_TSR15:    equ    15                                        ; Time Stamp Bit 15
; bit position masks
mCAN0TXTSR_TSR0:    equ    %00000001
mCAN0TXTSR_TSR1:    equ    %00000010
mCAN0TXTSR_TSR2:    equ    %00000100
mCAN0TXTSR_TSR3:    equ    %00001000
mCAN0TXTSR_TSR4:    equ    %00010000
mCAN0TXTSR_TSR5:    equ    %00100000
mCAN0TXTSR_TSR6:    equ    %01000000
mCAN0TXTSR_TSR7:    equ    %10000000
mCAN0TXTSR_TSR8:    equ    %100000000
mCAN0TXTSR_TSR9:    equ    %1000000000
mCAN0TXTSR_TSR10:   equ    %10000000000
mCAN0TXTSR_TSR11:   equ    %100000000000
mCAN0TXTSR_TSR12:   equ    %1000000000000
mCAN0TXTSR_TSR13:   equ    %10000000000000
mCAN0TXTSR_TSR14:   equ    %100000000000000
mCAN0TXTSR_TSR15:   equ    %1000000000000000


;*** CAN0TXTSRH - MSCAN 0 Transmit Time Stamp Register High; 0x0000017E ***
CAN0TXTSRH:         equ    $0000017E                                ;*** CAN0TXTSRH - MSCAN 0 Transmit Time Stamp Register High; 0x0000017E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0TXTSRH_TSR8:    equ    0                                         ; Time Stamp Bit 8
CAN0TXTSRH_TSR9:    equ    1                                         ; Time Stamp Bit 9
CAN0TXTSRH_TSR10:   equ    2                                         ; Time Stamp Bit 10
CAN0TXTSRH_TSR11:   equ    3                                         ; Time Stamp Bit 11
CAN0TXTSRH_TSR12:   equ    4                                         ; Time Stamp Bit 12
CAN0TXTSRH_TSR13:   equ    5                                         ; Time Stamp Bit 13
CAN0TXTSRH_TSR14:   equ    6                                         ; Time Stamp Bit 14
CAN0TXTSRH_TSR15:   equ    7                                         ; Time Stamp Bit 15
; bit position masks
mCAN0TXTSRH_TSR8:   equ    %00000001
mCAN0TXTSRH_TSR9:   equ    %00000010
mCAN0TXTSRH_TSR10:  equ    %00000100
mCAN0TXTSRH_TSR11:  equ    %00001000
mCAN0TXTSRH_TSR12:  equ    %00010000
mCAN0TXTSRH_TSR13:  equ    %00100000
mCAN0TXTSRH_TSR14:  equ    %01000000
mCAN0TXTSRH_TSR15:  equ    %10000000


;*** CAN0TXTSRL - MSCAN 0 Transmit Time Stamp Register Low; 0x0000017F ***
CAN0TXTSRL:         equ    $0000017F                                ;*** CAN0TXTSRL - MSCAN 0 Transmit Time Stamp Register Low; 0x0000017F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0TXTSRL_TSR0:    equ    0                                         ; Time Stamp Bit 0
CAN0TXTSRL_TSR1:    equ    1                                         ; Time Stamp Bit 1
CAN0TXTSRL_TSR2:    equ    2                                         ; Time Stamp Bit 2
CAN0TXTSRL_TSR3:    equ    3                                         ; Time Stamp Bit 3
CAN0TXTSRL_TSR4:    equ    4                                         ; Time Stamp Bit 4
CAN0TXTSRL_TSR5:    equ    5                                         ; Time Stamp Bit 5
CAN0TXTSRL_TSR6:    equ    6                                         ; Time Stamp Bit 6
CAN0TXTSRL_TSR7:    equ    7                                         ; Time Stamp Bit 7
; bit position masks
mCAN0TXTSRL_TSR0:   equ    %00000001
mCAN0TXTSRL_TSR1:   equ    %00000010
mCAN0TXTSRL_TSR2:   equ    %00000100
mCAN0TXTSRL_TSR3:   equ    %00001000
mCAN0TXTSRL_TSR4:   equ    %00010000
mCAN0TXTSRL_TSR5:   equ    %00100000
mCAN0TXTSRL_TSR6:   equ    %01000000
mCAN0TXTSRL_TSR7:   equ    %10000000


;*** PTT - Port T I/O Register; 0x00000240 ***
PTT:                equ    $00000240                                ;*** PTT - Port T I/O Register; 0x00000240 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTT_PTT0:           equ    0                                         ; Port T Bit 0
PTT_PTT1:           equ    1                                         ; Port T Bit 1
PTT_PTT2:           equ    2                                         ; Port T Bit 2
PTT_PTT3:           equ    3                                         ; Port T Bit 3
PTT_PTT4:           equ    4                                         ; Port T Bit 4
PTT_PTT5:           equ    5                                         ; Port T Bit 5
PTT_PTT6:           equ    6                                         ; Port T Bit 6
PTT_PTT7:           equ    7                                         ; Port T Bit 7
; bit position masks
mPTT_PTT0:          equ    %00000001
mPTT_PTT1:          equ    %00000010
mPTT_PTT2:          equ    %00000100
mPTT_PTT3:          equ    %00001000
mPTT_PTT4:          equ    %00010000
mPTT_PTT5:          equ    %00100000
mPTT_PTT6:          equ    %01000000
mPTT_PTT7:          equ    %10000000


;*** PTIT - Port T Input Register; 0x00000241 ***
PTIT:               equ    $00000241                                ;*** PTIT - Port T Input Register; 0x00000241 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTIT_PTIT0:         equ    0                                         ; Port T Bit 0
PTIT_PTIT1:         equ    1                                         ; Port T Bit 1
PTIT_PTIT2:         equ    2                                         ; Port T Bit 2
PTIT_PTIT3:         equ    3                                         ; Port T Bit 3
PTIT_PTIT4:         equ    4                                         ; Port T Bit 4
PTIT_PTIT5:         equ    5                                         ; Port T Bit 5
PTIT_PTIT6:         equ    6                                         ; Port T Bit 6
PTIT_PTIT7:         equ    7                                         ; Port T Bit 7
; bit position masks
mPTIT_PTIT0:        equ    %00000001
mPTIT_PTIT1:        equ    %00000010
mPTIT_PTIT2:        equ    %00000100
mPTIT_PTIT3:        equ    %00001000
mPTIT_PTIT4:        equ    %00010000
mPTIT_PTIT5:        equ    %00100000
mPTIT_PTIT6:        equ    %01000000
mPTIT_PTIT7:        equ    %10000000


;*** DDRT - Port T Data Direction Register; 0x00000242 ***
DDRT:               equ    $00000242                                ;*** DDRT - Port T Data Direction Register; 0x00000242 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRT_DDRT0:         equ    0                                         ; Data Direction Port T Bit 0
DDRT_DDRT1:         equ    1                                         ; Data Direction Port T Bit 1
DDRT_DDRT2:         equ    2                                         ; Data Direction Port T Bit 2
DDRT_DDRT3:         equ    3                                         ; Data Direction Port T Bit 3
DDRT_DDRT4:         equ    4                                         ; Data Direction Port T Bit 4
DDRT_DDRT5:         equ    5                                         ; Data Direction Port T Bit 5
DDRT_DDRT6:         equ    6                                         ; Data Direction Port T Bit 6
DDRT_DDRT7:         equ    7                                         ; Data Direction Port T Bit 7
; bit position masks
mDDRT_DDRT0:        equ    %00000001
mDDRT_DDRT1:        equ    %00000010
mDDRT_DDRT2:        equ    %00000100
mDDRT_DDRT3:        equ    %00001000
mDDRT_DDRT4:        equ    %00010000
mDDRT_DDRT5:        equ    %00100000
mDDRT_DDRT6:        equ    %01000000
mDDRT_DDRT7:        equ    %10000000


;*** RDRT - Port T Reduced Drive Register; 0x00000243 ***
RDRT:               equ    $00000243                                ;*** RDRT - Port T Reduced Drive Register; 0x00000243 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RDRT_RDRT0:         equ    0                                         ; Reduced Drive Port T Bit 0
RDRT_RDRT1:         equ    1                                         ; Reduced Drive Port T Bit 1
RDRT_RDRT2:         equ    2                                         ; Reduced Drive Port T Bit 2
RDRT_RDRT3:         equ    3                                         ; Reduced Drive Port T Bit 3
RDRT_RDRT4:         equ    4                                         ; Reduced Drive Port T Bit 4
RDRT_RDRT5:         equ    5                                         ; Reduced Drive Port T Bit 5
RDRT_RDRT6:         equ    6                                         ; Reduced Drive Port T Bit 6
RDRT_RDRT7:         equ    7                                         ; Reduced Drive Port T Bit 7
; bit position masks
mRDRT_RDRT0:        equ    %00000001
mRDRT_RDRT1:        equ    %00000010
mRDRT_RDRT2:        equ    %00000100
mRDRT_RDRT3:        equ    %00001000
mRDRT_RDRT4:        equ    %00010000
mRDRT_RDRT5:        equ    %00100000
mRDRT_RDRT6:        equ    %01000000
mRDRT_RDRT7:        equ    %10000000


;*** PERT - Port T Pull Device Enable Register; 0x00000244 ***
PERT:               equ    $00000244                                ;*** PERT - Port T Pull Device Enable Register; 0x00000244 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PERT_PERT0:         equ    0                                         ; Pull Device Enable Port T Bit 0
PERT_PERT1:         equ    1                                         ; Pull Device Enable Port T Bit 1
PERT_PERT2:         equ    2                                         ; Pull Device Enable Port T Bit 2
PERT_PERT3:         equ    3                                         ; Pull Device Enable Port T Bit 3
PERT_PERT4:         equ    4                                         ; Pull Device Enable Port T Bit 4
PERT_PERT5:         equ    5                                         ; Pull Device Enable Port T Bit 5
PERT_PERT6:         equ    6                                         ; Pull Device Enable Port T Bit 6
PERT_PERT7:         equ    7                                         ; Pull Device Enable Port T Bit 7
; bit position masks
mPERT_PERT0:        equ    %00000001
mPERT_PERT1:        equ    %00000010
mPERT_PERT2:        equ    %00000100
mPERT_PERT3:        equ    %00001000
mPERT_PERT4:        equ    %00010000
mPERT_PERT5:        equ    %00100000
mPERT_PERT6:        equ    %01000000
mPERT_PERT7:        equ    %10000000


;*** PPST - Port T Polarity Select Register; 0x00000245 ***
PPST:               equ    $00000245                                ;*** PPST - Port T Polarity Select Register; 0x00000245 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PPST_PPST0:         equ    0                                         ; Pull Select Port T Bit 0
PPST_PPST1:         equ    1                                         ; Pull Select Port T Bit 1
PPST_PPST2:         equ    2                                         ; Pull Select Port T Bit 2
PPST_PPST3:         equ    3                                         ; Pull Select Port T Bit 3
PPST_PPST4:         equ    4                                         ; Pull Select Port T Bit 4
PPST_PPST5:         equ    5                                         ; Pull Select Port T Bit 5
PPST_PPST6:         equ    6                                         ; Pull Select Port T Bit 6
PPST_PPST7:         equ    7                                         ; Pull Select Port T Bit 7
; bit position masks
mPPST_PPST0:        equ    %00000001
mPPST_PPST1:        equ    %00000010
mPPST_PPST2:        equ    %00000100
mPPST_PPST3:        equ    %00001000
mPPST_PPST4:        equ    %00010000
mPPST_PPST5:        equ    %00100000
mPPST_PPST6:        equ    %01000000
mPPST_PPST7:        equ    %10000000


;*** PTS - Port S I/O Register; 0x00000248 ***
PTS:                equ    $00000248                                ;*** PTS - Port S I/O Register; 0x00000248 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTS_PTS0:           equ    0                                         ; Port S Bit 0
PTS_PTS1:           equ    1                                         ; Port S Bit 1
PTS_PTS2:           equ    2                                         ; Port S Bit 2
PTS_PTS3:           equ    3                                         ; Port S Bit 3
PTS_PTS4:           equ    4                                         ; Port S Bit 4
PTS_PTS5:           equ    5                                         ; Port S Bit 5
PTS_PTS6:           equ    6                                         ; Port S Bit 6
PTS_PTS7:           equ    7                                         ; Port S Bit 7
; bit position masks
mPTS_PTS0:          equ    %00000001
mPTS_PTS1:          equ    %00000010
mPTS_PTS2:          equ    %00000100
mPTS_PTS3:          equ    %00001000
mPTS_PTS4:          equ    %00010000
mPTS_PTS5:          equ    %00100000
mPTS_PTS6:          equ    %01000000
mPTS_PTS7:          equ    %10000000


;*** PTIS - Port S Input Register; 0x00000249 ***
PTIS:               equ    $00000249                                ;*** PTIS - Port S Input Register; 0x00000249 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTIS_PTIS0:         equ    0                                         ; Port S Bit 0
PTIS_PTIS1:         equ    1                                         ; Port S Bit 1
PTIS_PTIS2:         equ    2                                         ; Port S Bit 2
PTIS_PTIS3:         equ    3                                         ; Port S Bit 3
PTIS_PTIS4:         equ    4                                         ; Port S Bit 4
PTIS_PTIS5:         equ    5                                         ; Port S Bit 5
PTIS_PTIS6:         equ    6                                         ; Port S Bit 6
PTIS_PTIS7:         equ    7                                         ; Port S Bit 7
; bit position masks
mPTIS_PTIS0:        equ    %00000001
mPTIS_PTIS1:        equ    %00000010
mPTIS_PTIS2:        equ    %00000100
mPTIS_PTIS3:        equ    %00001000
mPTIS_PTIS4:        equ    %00010000
mPTIS_PTIS5:        equ    %00100000
mPTIS_PTIS6:        equ    %01000000
mPTIS_PTIS7:        equ    %10000000


;*** DDRS - Port S Data Direction Register; 0x0000024A ***
DDRS:               equ    $0000024A                                ;*** DDRS - Port S Data Direction Register; 0x0000024A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRS_DDRS0:         equ    0                                         ; Data Direction Port S Bit 0
DDRS_DDRS1:         equ    1                                         ; Data Direction Port S Bit 1
DDRS_DDRS2:         equ    2                                         ; Data Direction Port S Bit 2
DDRS_DDRS3:         equ    3                                         ; Data Direction Port S Bit 3
DDRS_DDRS4:         equ    4                                         ; Data Direction Port S Bit 4
DDRS_DDRS5:         equ    5                                         ; Data Direction Port S Bit 5
DDRS_DDRS6:         equ    6                                         ; Data Direction Port S Bit 6
DDRS_DDRS7:         equ    7                                         ; Data Direction Port S Bit 7
; bit position masks
mDDRS_DDRS0:        equ    %00000001
mDDRS_DDRS1:        equ    %00000010
mDDRS_DDRS2:        equ    %00000100
mDDRS_DDRS3:        equ    %00001000
mDDRS_DDRS4:        equ    %00010000
mDDRS_DDRS5:        equ    %00100000
mDDRS_DDRS6:        equ    %01000000
mDDRS_DDRS7:        equ    %10000000


;*** RDRS - Port S Reduced Drive Register; 0x0000024B ***
RDRS:               equ    $0000024B                                ;*** RDRS - Port S Reduced Drive Register; 0x0000024B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RDRS_RDRS0:         equ    0                                         ; Reduced Drive Port S Bit 0
RDRS_RDRS1:         equ    1                                         ; Reduced Drive Port S Bit 1
RDRS_RDRS2:         equ    2                                         ; Reduced Drive Port S Bit 2
RDRS_RDRS3:         equ    3                                         ; Reduced Drive Port S Bit 3
RDRS_RDRS4:         equ    4                                         ; Reduced Drive Port S Bit 4
RDRS_RDRS5:         equ    5                                         ; Reduced Drive Port S Bit 5
RDRS_RDRS6:         equ    6                                         ; Reduced Drive Port S Bit 6
RDRS_RDRS7:         equ    7                                         ; Reduced Drive Port S Bit 7
; bit position masks
mRDRS_RDRS0:        equ    %00000001
mRDRS_RDRS1:        equ    %00000010
mRDRS_RDRS2:        equ    %00000100
mRDRS_RDRS3:        equ    %00001000
mRDRS_RDRS4:        equ    %00010000
mRDRS_RDRS5:        equ    %00100000
mRDRS_RDRS6:        equ    %01000000
mRDRS_RDRS7:        equ    %10000000


;*** PERS - Port S Pull Device Enable Register; 0x0000024C ***
PERS:               equ    $0000024C                                ;*** PERS - Port S Pull Device Enable Register; 0x0000024C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PERS_PERS0:         equ    0                                         ; Pull Device Enable Port S Bit 0
PERS_PERS1:         equ    1                                         ; Pull Device Enable Port S Bit 1
PERS_PERS2:         equ    2                                         ; Pull Device Enable Port S Bit 2
PERS_PERS3:         equ    3                                         ; Pull Device Enable Port S Bit 3
PERS_PERS4:         equ    4                                         ; Pull Device Enable Port S Bit 4
PERS_PERS5:         equ    5                                         ; Pull Device Enable Port S Bit 5
PERS_PERS6:         equ    6                                         ; Pull Device Enable Port S Bit 6
PERS_PERS7:         equ    7                                         ; Pull Device Enable Port S Bit 7
; bit position masks
mPERS_PERS0:        equ    %00000001
mPERS_PERS1:        equ    %00000010
mPERS_PERS2:        equ    %00000100
mPERS_PERS3:        equ    %00001000
mPERS_PERS4:        equ    %00010000
mPERS_PERS5:        equ    %00100000
mPERS_PERS6:        equ    %01000000
mPERS_PERS7:        equ    %10000000


;*** PPSS - Port S Polarity Select Register; 0x0000024D ***
PPSS:               equ    $0000024D                                ;*** PPSS - Port S Polarity Select Register; 0x0000024D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PPSS_PPSS0:         equ    0                                         ; Pull Select Port S Bit 0
PPSS_PPSS1:         equ    1                                         ; Pull Select Port S Bit 1
PPSS_PPSS2:         equ    2                                         ; Pull Select Port S Bit 2
PPSS_PPSS3:         equ    3                                         ; Pull Select Port S Bit 3
PPSS_PPSS4:         equ    4                                         ; Pull Select Port S Bit 4
PPSS_PPSS5:         equ    5                                         ; Pull Select Port S Bit 5
PPSS_PPSS6:         equ    6                                         ; Pull Select Port S Bit 6
PPSS_PPSS7:         equ    7                                         ; Pull Select Port S Bit 7
; bit position masks
mPPSS_PPSS0:        equ    %00000001
mPPSS_PPSS1:        equ    %00000010
mPPSS_PPSS2:        equ    %00000100
mPPSS_PPSS3:        equ    %00001000
mPPSS_PPSS4:        equ    %00010000
mPPSS_PPSS5:        equ    %00100000
mPPSS_PPSS6:        equ    %01000000
mPPSS_PPSS7:        equ    %10000000


;*** WOMS - Port S Wired-Or Mode Register; 0x0000024E ***
WOMS:               equ    $0000024E                                ;*** WOMS - Port S Wired-Or Mode Register; 0x0000024E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
WOMS_WOMS0:         equ    0                                         ; Wired-Or Mode Port S Bit 0
WOMS_WOMS1:         equ    1                                         ; Wired-Or Mode Port S Bit 1
WOMS_WOMS2:         equ    2                                         ; Wired-Or Mode Port S Bit 2
WOMS_WOMS3:         equ    3                                         ; Wired-Or Mode Port S Bit 3
WOMS_WOMS4:         equ    4                                         ; Wired-Or Mode Port S Bit 4
WOMS_WOMS5:         equ    5                                         ; Wired-Or Mode Port S Bit 5
WOMS_WOMS6:         equ    6                                         ; Wired-Or Mode Port S Bit 6
WOMS_WOMS7:         equ    7                                         ; Wired-Or Mode Port S Bit 7
; bit position masks
mWOMS_WOMS0:        equ    %00000001
mWOMS_WOMS1:        equ    %00000010
mWOMS_WOMS2:        equ    %00000100
mWOMS_WOMS3:        equ    %00001000
mWOMS_WOMS4:        equ    %00010000
mWOMS_WOMS5:        equ    %00100000
mWOMS_WOMS6:        equ    %01000000
mWOMS_WOMS7:        equ    %10000000


;*** PTM - Port M I/O Register; 0x00000250 ***
PTM:                equ    $00000250                                ;*** PTM - Port M I/O Register; 0x00000250 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTM_PTM0:           equ    0                                         ; Port M Bit 0
PTM_PTM1:           equ    1                                         ; Port M Bit 1
PTM_PTM2:           equ    2                                         ; Port M Bit 2
PTM_PTM3:           equ    3                                         ; Port M Bit 3
PTM_PTM4:           equ    4                                         ; Port M Bit 4
PTM_PTM5:           equ    5                                         ; Port M Bit 5
PTM_PTM6:           equ    6                                         ; Port M Bit 6
PTM_PTM7:           equ    7                                         ; Port M Bit 7
; bit position masks
mPTM_PTM0:          equ    %00000001
mPTM_PTM1:          equ    %00000010
mPTM_PTM2:          equ    %00000100
mPTM_PTM3:          equ    %00001000
mPTM_PTM4:          equ    %00010000
mPTM_PTM5:          equ    %00100000
mPTM_PTM6:          equ    %01000000
mPTM_PTM7:          equ    %10000000


;*** PTIM - Port M Input Register; 0x00000251 ***
PTIM:               equ    $00000251                                ;*** PTIM - Port M Input Register; 0x00000251 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTIM_PTIM0:         equ    0                                         ; Port M Bit 0
PTIM_PTIM1:         equ    1                                         ; Port M Bit 1
PTIM_PTIM2:         equ    2                                         ; Port M Bit 2
PTIM_PTIM3:         equ    3                                         ; Port M Bit 3
PTIM_PTIM4:         equ    4                                         ; Port M Bit 4
PTIM_PTIM5:         equ    5                                         ; Port M Bit 5
PTIM_PTIM6:         equ    6                                         ; Port M Bit 6
PTIM_PTIM7:         equ    7                                         ; Port M Bit 7
; bit position masks
mPTIM_PTIM0:        equ    %00000001
mPTIM_PTIM1:        equ    %00000010
mPTIM_PTIM2:        equ    %00000100
mPTIM_PTIM3:        equ    %00001000
mPTIM_PTIM4:        equ    %00010000
mPTIM_PTIM5:        equ    %00100000
mPTIM_PTIM6:        equ    %01000000
mPTIM_PTIM7:        equ    %10000000


;*** DDRM - Port M Data Direction Register; 0x00000252 ***
DDRM:               equ    $00000252                                ;*** DDRM - Port M Data Direction Register; 0x00000252 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRM_DDRM0:         equ    0                                         ; Data Direction Port M Bit 0
DDRM_DDRM1:         equ    1                                         ; Data Direction Port M Bit 1
DDRM_DDRM2:         equ    2                                         ; Data Direction Port M Bit 2
DDRM_DDRM3:         equ    3                                         ; Data Direction Port M Bit 3
DDRM_DDRM4:         equ    4                                         ; Data Direction Port M Bit 4
DDRM_DDRM5:         equ    5                                         ; Data Direction Port M Bit 5
DDRM_DDRM6:         equ    6                                         ; Data Direction Port M Bit 6
DDRM_DDRM7:         equ    7                                         ; Data Direction Port M Bit 7
; bit position masks
mDDRM_DDRM0:        equ    %00000001
mDDRM_DDRM1:        equ    %00000010
mDDRM_DDRM2:        equ    %00000100
mDDRM_DDRM3:        equ    %00001000
mDDRM_DDRM4:        equ    %00010000
mDDRM_DDRM5:        equ    %00100000
mDDRM_DDRM6:        equ    %01000000
mDDRM_DDRM7:        equ    %10000000


;*** RDRM - Port M Reduced Drive Register; 0x00000253 ***
RDRM:               equ    $00000253                                ;*** RDRM - Port M Reduced Drive Register; 0x00000253 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RDRM_RDRM0:         equ    0                                         ; Reduced Drive Port M Bit 0
RDRM_RDRM1:         equ    1                                         ; Reduced Drive Port M Bit 1
RDRM_RDRM2:         equ    2                                         ; Reduced Drive Port M Bit 2
RDRM_RDRM3:         equ    3                                         ; Reduced Drive Port M Bit 3
RDRM_RDRM4:         equ    4                                         ; Reduced Drive Port M Bit 4
RDRM_RDRM5:         equ    5                                         ; Reduced Drive Port M Bit 5
RDRM_RDRM6:         equ    6                                         ; Reduced Drive Port M Bit 6
RDRM_RDRM7:         equ    7                                         ; Reduced Drive Port M Bit 7
; bit position masks
mRDRM_RDRM0:        equ    %00000001
mRDRM_RDRM1:        equ    %00000010
mRDRM_RDRM2:        equ    %00000100
mRDRM_RDRM3:        equ    %00001000
mRDRM_RDRM4:        equ    %00010000
mRDRM_RDRM5:        equ    %00100000
mRDRM_RDRM6:        equ    %01000000
mRDRM_RDRM7:        equ    %10000000


;*** PERM - Port M Pull Device Enable Register; 0x00000254 ***
PERM:               equ    $00000254                                ;*** PERM - Port M Pull Device Enable Register; 0x00000254 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PERM_PERM0:         equ    0                                         ; Pull Device Enable Port M Bit 0
PERM_PERM1:         equ    1                                         ; Pull Device Enable Port M Bit 1
PERM_PERM2:         equ    2                                         ; Pull Device Enable Port M Bit 2
PERM_PERM3:         equ    3                                         ; Pull Device Enable Port M Bit 3
PERM_PERM4:         equ    4                                         ; Pull Device Enable Port M Bit 4
PERM_PERM5:         equ    5                                         ; Pull Device Enable Port M Bit 5
PERM_PERM6:         equ    6                                         ; Pull Device Enable Port M Bit 6
PERM_PERM7:         equ    7                                         ; Pull Device Enable Port M Bit 7
; bit position masks
mPERM_PERM0:        equ    %00000001
mPERM_PERM1:        equ    %00000010
mPERM_PERM2:        equ    %00000100
mPERM_PERM3:        equ    %00001000
mPERM_PERM4:        equ    %00010000
mPERM_PERM5:        equ    %00100000
mPERM_PERM6:        equ    %01000000
mPERM_PERM7:        equ    %10000000


;*** PPSM - Port M Polarity Select Register; 0x00000255 ***
PPSM:               equ    $00000255                                ;*** PPSM - Port M Polarity Select Register; 0x00000255 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PPSM_PPSM0:         equ    0                                         ; Pull Select Port M Bit 0
PPSM_PPSM1:         equ    1                                         ; Pull Select Port M Bit 1
PPSM_PPSM2:         equ    2                                         ; Pull Select Port M Bit 2
PPSM_PPSM3:         equ    3                                         ; Pull Select Port M Bit 3
PPSM_PPSM4:         equ    4                                         ; Pull Select Port M Bit 4
PPSM_PPSM5:         equ    5                                         ; Pull Select Port M Bit 5
PPSM_PPSM6:         equ    6                                         ; Pull Select Port M Bit 6
PPSM_PPSM7:         equ    7                                         ; Pull Select Port M Bit 7
; bit position masks
mPPSM_PPSM0:        equ    %00000001
mPPSM_PPSM1:        equ    %00000010
mPPSM_PPSM2:        equ    %00000100
mPPSM_PPSM3:        equ    %00001000
mPPSM_PPSM4:        equ    %00010000
mPPSM_PPSM5:        equ    %00100000
mPPSM_PPSM6:        equ    %01000000
mPPSM_PPSM7:        equ    %10000000


;*** WOMM - Port M Wired-Or Mode Register; 0x00000256 ***
WOMM:               equ    $00000256                                ;*** WOMM - Port M Wired-Or Mode Register; 0x00000256 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
WOMM_WOMM0:         equ    0                                         ; Wired-Or Mode Port M Bit 0
WOMM_WOMM1:         equ    1                                         ; Wired-Or Mode Port M Bit 1
WOMM_WOMM2:         equ    2                                         ; Wired-Or Mode Port M Bit 2
WOMM_WOMM3:         equ    3                                         ; Wired-Or Mode Port M Bit 3
WOMM_WOMM4:         equ    4                                         ; Wired-Or Mode Port M Bit 4
WOMM_WOMM5:         equ    5                                         ; Wired-Or Mode Port M Bit 5
WOMM_WOMM6:         equ    6                                         ; Wired-Or Mode Port M Bit 6
WOMM_WOMM7:         equ    7                                         ; Wired-Or Mode Port M Bit 7
; bit position masks
mWOMM_WOMM0:        equ    %00000001
mWOMM_WOMM1:        equ    %00000010
mWOMM_WOMM2:        equ    %00000100
mWOMM_WOMM3:        equ    %00001000
mWOMM_WOMM4:        equ    %00010000
mWOMM_WOMM5:        equ    %00100000
mWOMM_WOMM6:        equ    %01000000
mWOMM_WOMM7:        equ    %10000000


;*** MODRR - Module Routing Register; 0x00000257 ***
MODRR:              equ    $00000257                                ;*** MODRR - Module Routing Register; 0x00000257 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MODRR_MODRR0:       equ    0                                         ; CAN0 Routing Bit 0
MODRR_MODRR1:       equ    1                                         ; CAN0 Routing Bit 1
MODRR_MODRR2:       equ    2                                         ; CAN4 Routing Bit 0
MODRR_MODRR3:       equ    3                                         ; CAN4 Routing Bit 1
MODRR_MODRR4:       equ    4                                         ; SPI0 Routing
MODRR_MODRR5:       equ    5                                         ; SPI1 Routing
MODRR_MODRR6:       equ    6                                         ; SPI2 Routing
; bit position masks
mMODRR_MODRR0:      equ    %00000001
mMODRR_MODRR1:      equ    %00000010
mMODRR_MODRR2:      equ    %00000100
mMODRR_MODRR3:      equ    %00001000
mMODRR_MODRR4:      equ    %00010000
mMODRR_MODRR5:      equ    %00100000
mMODRR_MODRR6:      equ    %01000000


;*** PTP - Port P I/O Register; 0x00000258 ***
PTP:                equ    $00000258                                ;*** PTP - Port P I/O Register; 0x00000258 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTP_PTP0:           equ    0                                         ; Port P Bit 0
PTP_PTP1:           equ    1                                         ; Port P Bit 1
PTP_PTP2:           equ    2                                         ; Port P Bit 2
PTP_PTP3:           equ    3                                         ; Port P Bit 3
PTP_PTP4:           equ    4                                         ; Port P Bit 4
PTP_PTP5:           equ    5                                         ; Port P Bit 5
PTP_PTP6:           equ    6                                         ; Port P Bit 6
PTP_PTP7:           equ    7                                         ; Port P Bit 7
; bit position masks
mPTP_PTP0:          equ    %00000001
mPTP_PTP1:          equ    %00000010
mPTP_PTP2:          equ    %00000100
mPTP_PTP3:          equ    %00001000
mPTP_PTP4:          equ    %00010000
mPTP_PTP5:          equ    %00100000
mPTP_PTP6:          equ    %01000000
mPTP_PTP7:          equ    %10000000


;*** PTIP - Port P Input Register; 0x00000259 ***
PTIP:               equ    $00000259                                ;*** PTIP - Port P Input Register; 0x00000259 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTIP_PTIP0:         equ    0                                         ; Port P Bit 0
PTIP_PTIP1:         equ    1                                         ; Port P Bit 1
PTIP_PTIP2:         equ    2                                         ; Port P Bit 2
PTIP_PTIP3:         equ    3                                         ; Port P Bit 3
PTIP_PTIP4:         equ    4                                         ; Port P Bit 4
PTIP_PTIP5:         equ    5                                         ; Port P Bit 5
PTIP_PTIP6:         equ    6                                         ; Port P Bit 6
PTIP_PTIP7:         equ    7                                         ; Port P Bit 7
; bit position masks
mPTIP_PTIP0:        equ    %00000001
mPTIP_PTIP1:        equ    %00000010
mPTIP_PTIP2:        equ    %00000100
mPTIP_PTIP3:        equ    %00001000
mPTIP_PTIP4:        equ    %00010000
mPTIP_PTIP5:        equ    %00100000
mPTIP_PTIP6:        equ    %01000000
mPTIP_PTIP7:        equ    %10000000


;*** DDRP - Port P Data Direction Register; 0x0000025A ***
DDRP:               equ    $0000025A                                ;*** DDRP - Port P Data Direction Register; 0x0000025A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRP_DDRP0:         equ    0                                         ; Data Direction Port P Bit 0
DDRP_DDRP1:         equ    1                                         ; Data Direction Port P Bit 1
DDRP_DDRP2:         equ    2                                         ; Data Direction Port P Bit 2
DDRP_DDRP3:         equ    3                                         ; Data Direction Port P Bit 3
DDRP_DDRP4:         equ    4                                         ; Data Direction Port P Bit 4
DDRP_DDRP5:         equ    5                                         ; Data Direction Port P Bit 5
DDRP_DDRP6:         equ    6                                         ; Data Direction Port P Bit 6
DDRP_DDRP7:         equ    7                                         ; Data Direction Port P Bit 7
; bit position masks
mDDRP_DDRP0:        equ    %00000001
mDDRP_DDRP1:        equ    %00000010
mDDRP_DDRP2:        equ    %00000100
mDDRP_DDRP3:        equ    %00001000
mDDRP_DDRP4:        equ    %00010000
mDDRP_DDRP5:        equ    %00100000
mDDRP_DDRP6:        equ    %01000000
mDDRP_DDRP7:        equ    %10000000


;*** RDRP - Port P Reduced Drive Register; 0x0000025B ***
RDRP:               equ    $0000025B                                ;*** RDRP - Port P Reduced Drive Register; 0x0000025B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RDRP_RDRP0:         equ    0                                         ; Reduced Drive Port P Bit 0
RDRP_RDRP1:         equ    1                                         ; Reduced Drive Port P Bit 1
RDRP_RDRP2:         equ    2                                         ; Reduced Drive Port P Bit 2
RDRP_RDRP3:         equ    3                                         ; Reduced Drive Port P Bit 3
RDRP_RDRP4:         equ    4                                         ; Reduced Drive Port P Bit 4
RDRP_RDRP5:         equ    5                                         ; Reduced Drive Port P Bit 5
RDRP_RDRP6:         equ    6                                         ; Reduced Drive Port P Bit 6
RDRP_RDRP7:         equ    7                                         ; Reduced Drive Port P Bit 7
; bit position masks
mRDRP_RDRP0:        equ    %00000001
mRDRP_RDRP1:        equ    %00000010
mRDRP_RDRP2:        equ    %00000100
mRDRP_RDRP3:        equ    %00001000
mRDRP_RDRP4:        equ    %00010000
mRDRP_RDRP5:        equ    %00100000
mRDRP_RDRP6:        equ    %01000000
mRDRP_RDRP7:        equ    %10000000


;*** PERP - Port P Pull Device Enable Register; 0x0000025C ***
PERP:               equ    $0000025C                                ;*** PERP - Port P Pull Device Enable Register; 0x0000025C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PERP_PERP0:         equ    0                                         ; Pull Device Enable Port P Bit 0
PERP_PERP1:         equ    1                                         ; Pull Device Enable Port P Bit 1
PERP_PERP2:         equ    2                                         ; Pull Device Enable Port P Bit 2
PERP_PERP3:         equ    3                                         ; Pull Device Enable Port P Bit 3
PERP_PERP4:         equ    4                                         ; Pull Device Enable Port P Bit 4
PERP_PERP5:         equ    5                                         ; Pull Device Enable Port P Bit 5
PERP_PERP6:         equ    6                                         ; Pull Device Enable Port P Bit 6
PERP_PERP7:         equ    7                                         ; Pull Device Enable Port P Bit 7
; bit position masks
mPERP_PERP0:        equ    %00000001
mPERP_PERP1:        equ    %00000010
mPERP_PERP2:        equ    %00000100
mPERP_PERP3:        equ    %00001000
mPERP_PERP4:        equ    %00010000
mPERP_PERP5:        equ    %00100000
mPERP_PERP6:        equ    %01000000
mPERP_PERP7:        equ    %10000000


;*** PPSP - Port P Polarity Select Register; 0x0000025D ***
PPSP:               equ    $0000025D                                ;*** PPSP - Port P Polarity Select Register; 0x0000025D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PPSP_PPSP0:         equ    0                                         ; Pull Select Port P Bit 0
PPSP_PPSP1:         equ    1                                         ; Pull Select Port P Bit 1
PPSP_PPSP2:         equ    2                                         ; Pull Select Port P Bit 2
PPSP_PPSP3:         equ    3                                         ; Pull Select Port P Bit 3
PPSP_PPSP4:         equ    4                                         ; Pull Select Port P Bit 4
PPSP_PPSP5:         equ    5                                         ; Pull Select Port P Bit 5
PPSP_PPSP6:         equ    6                                         ; Pull Select Port P Bit 6
PPSP_PPSP7:         equ    7                                         ; Pull Select Port P Bit 7
; bit position masks
mPPSP_PPSP0:        equ    %00000001
mPPSP_PPSP1:        equ    %00000010
mPPSP_PPSP2:        equ    %00000100
mPPSP_PPSP3:        equ    %00001000
mPPSP_PPSP4:        equ    %00010000
mPPSP_PPSP5:        equ    %00100000
mPPSP_PPSP6:        equ    %01000000
mPPSP_PPSP7:        equ    %10000000


;*** PIEP - Port P Interrupt Enable Register; 0x0000025E ***
PIEP:               equ    $0000025E                                ;*** PIEP - Port P Interrupt Enable Register; 0x0000025E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PIEP_PIEP0:         equ    0                                         ; Interrupt Enable Port P Bit 0
PIEP_PIEP1:         equ    1                                         ; Interrupt Enable Port P Bit 1
PIEP_PIEP2:         equ    2                                         ; Interrupt Enable Port P Bit 2
PIEP_PIEP3:         equ    3                                         ; Interrupt Enable Port P Bit 3
PIEP_PIEP4:         equ    4                                         ; Interrupt Enable Port P Bit 4
PIEP_PIEP5:         equ    5                                         ; Interrupt Enable Port P Bit 5
PIEP_PIEP6:         equ    6                                         ; Interrupt Enable Port P Bit 6
PIEP_PIEP7:         equ    7                                         ; Interrupt Enable Port P Bit 7
; bit position masks
mPIEP_PIEP0:        equ    %00000001
mPIEP_PIEP1:        equ    %00000010
mPIEP_PIEP2:        equ    %00000100
mPIEP_PIEP3:        equ    %00001000
mPIEP_PIEP4:        equ    %00010000
mPIEP_PIEP5:        equ    %00100000
mPIEP_PIEP6:        equ    %01000000
mPIEP_PIEP7:        equ    %10000000


;*** PIFP - Port P Interrupt Flag Register; 0x0000025F ***
PIFP:               equ    $0000025F                                ;*** PIFP - Port P Interrupt Flag Register; 0x0000025F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PIFP_PIFP0:         equ    0                                         ; Interrupt Flags Port P Bit 0
PIFP_PIFP1:         equ    1                                         ; Interrupt Flags Port P Bit 1
PIFP_PIFP2:         equ    2                                         ; Interrupt Flags Port P Bit 2
PIFP_PIFP3:         equ    3                                         ; Interrupt Flags Port P Bit 3
PIFP_PIFP4:         equ    4                                         ; Interrupt Flags Port P Bit 4
PIFP_PIFP5:         equ    5                                         ; Interrupt Flags Port P Bit 5
PIFP_PIFP6:         equ    6                                         ; Interrupt Flags Port P Bit 6
PIFP_PIFP7:         equ    7                                         ; Interrupt Flags Port P Bit 7
; bit position masks
mPIFP_PIFP0:        equ    %00000001
mPIFP_PIFP1:        equ    %00000010
mPIFP_PIFP2:        equ    %00000100
mPIFP_PIFP3:        equ    %00001000
mPIFP_PIFP4:        equ    %00010000
mPIFP_PIFP5:        equ    %00100000
mPIFP_PIFP6:        equ    %01000000
mPIFP_PIFP7:        equ    %10000000


;*** PTH - Port H I/O Register; 0x00000260 ***
PTH:                equ    $00000260                                ;*** PTH - Port H I/O Register; 0x00000260 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTH_PTH0:           equ    0                                         ; Port H Bit 0
PTH_PTH1:           equ    1                                         ; Port H Bit 1
PTH_PTH2:           equ    2                                         ; Port H Bit 2
PTH_PTH3:           equ    3                                         ; Port H Bit 3
PTH_PTH4:           equ    4                                         ; Port H Bit 4
PTH_PTH5:           equ    5                                         ; Port H Bit 5
PTH_PTH6:           equ    6                                         ; Port H Bit 6
PTH_PTH7:           equ    7                                         ; Port H Bit 7
; bit position masks
mPTH_PTH0:          equ    %00000001
mPTH_PTH1:          equ    %00000010
mPTH_PTH2:          equ    %00000100
mPTH_PTH3:          equ    %00001000
mPTH_PTH4:          equ    %00010000
mPTH_PTH5:          equ    %00100000
mPTH_PTH6:          equ    %01000000
mPTH_PTH7:          equ    %10000000


;*** PTIH - Port H Input Register; 0x00000261 ***
PTIH:               equ    $00000261                                ;*** PTIH - Port H Input Register; 0x00000261 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTIH_PTIH0:         equ    0                                         ; Port H Bit 0
PTIH_PTIH1:         equ    1                                         ; Port H Bit 1
PTIH_PTIH2:         equ    2                                         ; Port H Bit 2
PTIH_PTIH3:         equ    3                                         ; Port H Bit 3
PTIH_PTIH4:         equ    4                                         ; Port H Bit 4
PTIH_PTIH5:         equ    5                                         ; Port H Bit 5
PTIH_PTIH6:         equ    6                                         ; Port H Bit 6
PTIH_PTIH7:         equ    7                                         ; Port H Bit 7
; bit position masks
mPTIH_PTIH0:        equ    %00000001
mPTIH_PTIH1:        equ    %00000010
mPTIH_PTIH2:        equ    %00000100
mPTIH_PTIH3:        equ    %00001000
mPTIH_PTIH4:        equ    %00010000
mPTIH_PTIH5:        equ    %00100000
mPTIH_PTIH6:        equ    %01000000
mPTIH_PTIH7:        equ    %10000000


;*** DDRH - Port H Data Direction Register; 0x00000262 ***
DDRH:               equ    $00000262                                ;*** DDRH - Port H Data Direction Register; 0x00000262 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRH_DDRH0:         equ    0                                         ; Data Direction Port H Bit 0
DDRH_DDRH1:         equ    1                                         ; Data Direction Port H Bit 1
DDRH_DDRH2:         equ    2                                         ; Data Direction Port H Bit 2
DDRH_DDRH3:         equ    3                                         ; Data Direction Port H Bit 3
DDRH_DDRH4:         equ    4                                         ; Data Direction Port H Bit 4
DDRH_DDRH5:         equ    5                                         ; Data Direction Port H Bit 5
DDRH_DDRH6:         equ    6                                         ; Data Direction Port H Bit 6
DDRH_DDRH7:         equ    7                                         ; Data Direction Port H Bit 7
; bit position masks
mDDRH_DDRH0:        equ    %00000001
mDDRH_DDRH1:        equ    %00000010
mDDRH_DDRH2:        equ    %00000100
mDDRH_DDRH3:        equ    %00001000
mDDRH_DDRH4:        equ    %00010000
mDDRH_DDRH5:        equ    %00100000
mDDRH_DDRH6:        equ    %01000000
mDDRH_DDRH7:        equ    %10000000


;*** RDRH - Port H Reduced Drive Register; 0x00000263 ***
RDRH:               equ    $00000263                                ;*** RDRH - Port H Reduced Drive Register; 0x00000263 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RDRH_RDRH0:         equ    0                                         ; Reduced Drive Port H Bit 0
RDRH_RDRH1:         equ    1                                         ; Reduced Drive Port H Bit 1
RDRH_RDRH2:         equ    2                                         ; Reduced Drive Port H Bit 2
RDRH_RDRH3:         equ    3                                         ; Reduced Drive Port H Bit 3
RDRH_RDRH4:         equ    4                                         ; Reduced Drive Port H Bit 4
RDRH_RDRH5:         equ    5                                         ; Reduced Drive Port H Bit 5
RDRH_RDRH6:         equ    6                                         ; Reduced Drive Port H Bit 6
RDRH_RDRH7:         equ    7                                         ; Reduced Drive Port H Bit 7
; bit position masks
mRDRH_RDRH0:        equ    %00000001
mRDRH_RDRH1:        equ    %00000010
mRDRH_RDRH2:        equ    %00000100
mRDRH_RDRH3:        equ    %00001000
mRDRH_RDRH4:        equ    %00010000
mRDRH_RDRH5:        equ    %00100000
mRDRH_RDRH6:        equ    %01000000
mRDRH_RDRH7:        equ    %10000000


;*** PERH - Port H Pull Device Enable Register; 0x00000264 ***
PERH:               equ    $00000264                                ;*** PERH - Port H Pull Device Enable Register; 0x00000264 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PERH_PERH0:         equ    0                                         ; Pull Device Enable Port H Bit 0
PERH_PERH1:         equ    1                                         ; Pull Device Enable Port H Bit 1
PERH_PERH2:         equ    2                                         ; Pull Device Enable Port H Bit 2
PERH_PERH3:         equ    3                                         ; Pull Device Enable Port H Bit 3
PERH_PERH4:         equ    4                                         ; Pull Device Enable Port H Bit 4
PERH_PERH5:         equ    5                                         ; Pull Device Enable Port H Bit 5
PERH_PERH6:         equ    6                                         ; Pull Device Enable Port H Bit 6
PERH_PERH7:         equ    7                                         ; Pull Device Enable Port H Bit 7
; bit position masks
mPERH_PERH0:        equ    %00000001
mPERH_PERH1:        equ    %00000010
mPERH_PERH2:        equ    %00000100
mPERH_PERH3:        equ    %00001000
mPERH_PERH4:        equ    %00010000
mPERH_PERH5:        equ    %00100000
mPERH_PERH6:        equ    %01000000
mPERH_PERH7:        equ    %10000000


;*** PPSH - Port H Polarity Select Register; 0x00000265 ***
PPSH:               equ    $00000265                                ;*** PPSH - Port H Polarity Select Register; 0x00000265 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PPSH_PPSH0:         equ    0                                         ; Pull Select Port H Bit 0
PPSH_PPSH1:         equ    1                                         ; Pull Select Port H Bit 1
PPSH_PPSH2:         equ    2                                         ; Pull Select Port H Bit 2
PPSH_PPSH3:         equ    3                                         ; Pull Select Port H Bit 3
PPSH_PPSH4:         equ    4                                         ; Pull Select Port H Bit 4
PPSH_PPSH5:         equ    5                                         ; Pull Select Port H Bit 5
PPSH_PPSH6:         equ    6                                         ; Pull Select Port H Bit 6
PPSH_PPSH7:         equ    7                                         ; Pull Select Port H Bit 7
; bit position masks
mPPSH_PPSH0:        equ    %00000001
mPPSH_PPSH1:        equ    %00000010
mPPSH_PPSH2:        equ    %00000100
mPPSH_PPSH3:        equ    %00001000
mPPSH_PPSH4:        equ    %00010000
mPPSH_PPSH5:        equ    %00100000
mPPSH_PPSH6:        equ    %01000000
mPPSH_PPSH7:        equ    %10000000


;*** PIEH - Port H Interrupt Enable Register; 0x00000266 ***
PIEH:               equ    $00000266                                ;*** PIEH - Port H Interrupt Enable Register; 0x00000266 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PIEH_PIEH0:         equ    0                                         ; Interrupt Enable Port H Bit 0
PIEH_PIEH1:         equ    1                                         ; Interrupt Enable Port H Bit 1
PIEH_PIEH2:         equ    2                                         ; Interrupt Enable Port H Bit 2
PIEH_PIEH3:         equ    3                                         ; Interrupt Enable Port H Bit 3
PIEH_PIEH4:         equ    4                                         ; Interrupt Enable Port H Bit 4
PIEH_PIEH5:         equ    5                                         ; Interrupt Enable Port H Bit 5
PIEH_PIEH6:         equ    6                                         ; Interrupt Enable Port H Bit 6
PIEH_PIEH7:         equ    7                                         ; Interrupt Enable Port H Bit 7
; bit position masks
mPIEH_PIEH0:        equ    %00000001
mPIEH_PIEH1:        equ    %00000010
mPIEH_PIEH2:        equ    %00000100
mPIEH_PIEH3:        equ    %00001000
mPIEH_PIEH4:        equ    %00010000
mPIEH_PIEH5:        equ    %00100000
mPIEH_PIEH6:        equ    %01000000
mPIEH_PIEH7:        equ    %10000000


;*** PIFH - Port H Interrupt Flag Register; 0x00000267 ***
PIFH:               equ    $00000267                                ;*** PIFH - Port H Interrupt Flag Register; 0x00000267 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PIFH_PIFH0:         equ    0                                         ; Interrupt Flags Port H Bit 0
PIFH_PIFH1:         equ    1                                         ; Interrupt Flags Port H Bit 1
PIFH_PIFH2:         equ    2                                         ; Interrupt Flags Port H Bit 2
PIFH_PIFH3:         equ    3                                         ; Interrupt Flags Port H Bit 3
PIFH_PIFH4:         equ    4                                         ; Interrupt Flags Port H Bit 4
PIFH_PIFH5:         equ    5                                         ; Interrupt Flags Port H Bit 5
PIFH_PIFH6:         equ    6                                         ; Interrupt Flags Port H Bit 6
PIFH_PIFH7:         equ    7                                         ; Interrupt Flags Port H Bit 7
; bit position masks
mPIFH_PIFH0:        equ    %00000001
mPIFH_PIFH1:        equ    %00000010
mPIFH_PIFH2:        equ    %00000100
mPIFH_PIFH3:        equ    %00001000
mPIFH_PIFH4:        equ    %00010000
mPIFH_PIFH5:        equ    %00100000
mPIFH_PIFH6:        equ    %01000000
mPIFH_PIFH7:        equ    %10000000


;*** PTJ - Port J I/O Register; 0x00000268 ***
PTJ:                equ    $00000268                                ;*** PTJ - Port J I/O Register; 0x00000268 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTJ_PTJ0:           equ    0                                         ; Port J Bit 0
PTJ_PTJ1:           equ    1                                         ; Port J Bit 1
PTJ_PTJ6:           equ    6                                         ; Port J Bit 6
PTJ_PTJ7:           equ    7                                         ; Port J Bit 7
; bit position masks
mPTJ_PTJ0:          equ    %00000001
mPTJ_PTJ1:          equ    %00000010
mPTJ_PTJ6:          equ    %01000000
mPTJ_PTJ7:          equ    %10000000


;*** PTIJ - Port J Input Register; 0x00000269 ***
PTIJ:               equ    $00000269                                ;*** PTIJ - Port J Input Register; 0x00000269 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTIJ_PTIJ0:         equ    0                                         ; Port J Bit 0
PTIJ_PTIJ1:         equ    1                                         ; Port J Bit 1
PTIJ_PTIJ6:         equ    6                                         ; Port J Bit 6
PTIJ_PTIJ7:         equ    7                                         ; Port J Bit 7
; bit position masks
mPTIJ_PTIJ0:        equ    %00000001
mPTIJ_PTIJ1:        equ    %00000010
mPTIJ_PTIJ6:        equ    %01000000
mPTIJ_PTIJ7:        equ    %10000000


;*** DDRJ - Port J Data Direction Register; 0x0000026A ***
DDRJ:               equ    $0000026A                                ;*** DDRJ - Port J Data Direction Register; 0x0000026A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRJ_DDRJ0:         equ    0                                         ; Data Direction Port J Bit 0
DDRJ_DDRJ1:         equ    1                                         ; Data Direction Port J Bit 1
DDRJ_DDRJ6:         equ    6                                         ; Data Direction Port J Bit 6
DDRJ_DDRJ7:         equ    7                                         ; Data Direction Port J Bit 7
; bit position masks
mDDRJ_DDRJ0:        equ    %00000001
mDDRJ_DDRJ1:        equ    %00000010
mDDRJ_DDRJ6:        equ    %01000000
mDDRJ_DDRJ7:        equ    %10000000


;*** RDRJ - Port J Reduced Drive Register; 0x0000026B ***
RDRJ:               equ    $0000026B                                ;*** RDRJ - Port J Reduced Drive Register; 0x0000026B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RDRJ_RDRJ0:         equ    0                                         ; Reduced Drive Port J Bit 0
RDRJ_RDRJ1:         equ    1                                         ; Reduced Drive Port J Bit 1
RDRJ_RDRJ6:         equ    6                                         ; Reduced Drive Port J Bit 6
RDRJ_RDRJ7:         equ    7                                         ; Reduced Drive Port J Bit 7
; bit position masks
mRDRJ_RDRJ0:        equ    %00000001
mRDRJ_RDRJ1:        equ    %00000010
mRDRJ_RDRJ6:        equ    %01000000
mRDRJ_RDRJ7:        equ    %10000000


;*** PERJ - Port J Pull Device Enable Register; 0x0000026C ***
PERJ:               equ    $0000026C                                ;*** PERJ - Port J Pull Device Enable Register; 0x0000026C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PERJ_PERJ0:         equ    0                                         ; Pull Device Enable Port J Bit 0
PERJ_PERJ1:         equ    1                                         ; Pull Device Enable Port J Bit 1
PERJ_PERJ6:         equ    6                                         ; Pull Device Enable Port J Bit 6
PERJ_PERJ7:         equ    7                                         ; Pull Device Enable Port J Bit 7
; bit position masks
mPERJ_PERJ0:        equ    %00000001
mPERJ_PERJ1:        equ    %00000010
mPERJ_PERJ6:        equ    %01000000
mPERJ_PERJ7:        equ    %10000000


;*** PPSJ - Port J Polarity Select Register; 0x0000026D ***
PPSJ:               equ    $0000026D                                ;*** PPSJ - Port J Polarity Select Register; 0x0000026D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PPSJ_PPSJ0:         equ    0                                         ; Pull Select Port J Bit 0
PPSJ_PPSJ1:         equ    1                                         ; Pull Select Port J Bit 1
PPSJ_PPSJ6:         equ    6                                         ; Pull Select Port J Bit 6
PPSJ_PPSJ7:         equ    7                                         ; Pull Select Port J Bit 7
; bit position masks
mPPSJ_PPSJ0:        equ    %00000001
mPPSJ_PPSJ1:        equ    %00000010
mPPSJ_PPSJ6:        equ    %01000000
mPPSJ_PPSJ7:        equ    %10000000


;*** PIEJ - Port J Interrupt Enable Register; 0x0000026E ***
PIEJ:               equ    $0000026E                                ;*** PIEJ - Port J Interrupt Enable Register; 0x0000026E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PIEJ_PIEJ0:         equ    0                                         ; Interrupt Enable Port J Bit 0
PIEJ_PIEJ1:         equ    1                                         ; Interrupt Enable Port J Bit 1
PIEJ_PIEJ6:         equ    6                                         ; Interrupt Enable Port J Bit 6
PIEJ_PIEJ7:         equ    7                                         ; Interrupt Enable Port J Bit 7
; bit position masks
mPIEJ_PIEJ0:        equ    %00000001
mPIEJ_PIEJ1:        equ    %00000010
mPIEJ_PIEJ6:        equ    %01000000
mPIEJ_PIEJ7:        equ    %10000000


;*** PIFJ - Port J Interrupt Flag Register; 0x0000026F ***
PIFJ:               equ    $0000026F                                ;*** PIFJ - Port J Interrupt Flag Register; 0x0000026F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PIFJ_PIFJ0:         equ    0                                         ; Interrupt Flags Port J Bit 0
PIFJ_PIFJ1:         equ    1                                         ; Interrupt Flags Port J Bit 1
PIFJ_PIFJ6:         equ    6                                         ; Interrupt Flags Port J Bit 6
PIFJ_PIFJ7:         equ    7                                         ; Interrupt Flags Port J Bit 7
; bit position masks
mPIFJ_PIFJ0:        equ    %00000001
mPIFJ_PIFJ1:        equ    %00000010
mPIFJ_PIFJ6:        equ    %01000000
mPIFJ_PIFJ7:        equ    %10000000


;*** CAN4CTL0 - MSCAN4 Control 0 Register; 0x00000280 ***
CAN4CTL0:           equ    $00000280                                ;*** CAN4CTL0 - MSCAN4 Control 0 Register; 0x00000280 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN4CTL0_INITRQ:    equ    0                                         ; Initialization Mode Request
CAN4CTL0_SLPRQ:     equ    1                                         ; Sleep Mode Request
CAN4CTL0_WUPE:      equ    2                                         ; Wake-Up Enable
CAN4CTL0_TIME:      equ    3                                         ; Timer Enable
CAN4CTL0_SYNCH:     equ    4                                         ; Synchronized Status
CAN4CTL0_CSWAI:     equ    5                                         ; CAN Stops in Wait Mode
CAN4CTL0_RXACT:     equ    6                                         ; Receiver Active Status
CAN4CTL0_RXFRM:     equ    7                                         ; Received Frame Flag
; bit position masks
mCAN4CTL0_INITRQ:   equ    %00000001
mCAN4CTL0_SLPRQ:    equ    %00000010
mCAN4CTL0_WUPE:     equ    %00000100
mCAN4CTL0_TIME:     equ    %00001000
mCAN4CTL0_SYNCH:    equ    %00010000
mCAN4CTL0_CSWAI:    equ    %00100000
mCAN4CTL0_RXACT:    equ    %01000000
mCAN4CTL0_RXFRM:    equ    %10000000


;*** CAN4CTL1 - MSCAN4 Control 1 Register; 0x00000281 ***
CAN4CTL1:           equ    $00000281                                ;*** CAN4CTL1 - MSCAN4 Control 1 Register; 0x00000281 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN4CTL1_INITAK:    equ    0                                         ; Initialization Mode Acknowledge
CAN4CTL1_SLPAK:     equ    1                                         ; Sleep Mode Acknowledge
CAN4CTL1_WUPM:      equ    2                                         ; Wake-Up Mode
CAN4CTL1_LISTEN:    equ    4                                         ; Listen Only Mode
CAN4CTL1_LOOPB:     equ    5                                         ; Loop Back Self Test Mode
CAN4CTL1_CLKSRC:    equ    6                                         ; MSCAN4 Clock Source
CAN4CTL1_CANE:      equ    7                                         ; MSCAN4 Enable
; bit position masks
mCAN4CTL1_INITAK:   equ    %00000001
mCAN4CTL1_SLPAK:    equ    %00000010
mCAN4CTL1_WUPM:     equ    %00000100
mCAN4CTL1_LISTEN:   equ    %00010000
mCAN4CTL1_LOOPB:    equ    %00100000
mCAN4CTL1_CLKSRC:   equ    %01000000
mCAN4CTL1_CANE:     equ    %10000000


;*** CAN4BTR0 - MSCAN4 Bus Timing Register 0; 0x00000282 ***
CAN4BTR0:           equ    $00000282                                ;*** CAN4BTR0 - MSCAN4 Bus Timing Register 0; 0x00000282 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN4BTR0_BRP0:      equ    0                                         ; Baud Rate Prescaler 0
CAN4BTR0_BRP1:      equ    1                                         ; Baud Rate Prescaler 1
CAN4BTR0_BRP2:      equ    2                                         ; Baud Rate Prescaler 2
CAN4BTR0_BRP3:      equ    3                                         ; Baud Rate Prescaler 3
CAN4BTR0_BRP4:      equ    4                                         ; Baud Rate Prescaler 4
CAN4BTR0_BRP5:      equ    5                                         ; Baud Rate Prescaler 5
CAN4BTR0_SJW0:      equ    6                                         ; Synchronization Jump Width 0
CAN4BTR0_SJW1:      equ    7                                         ; Synchronization Jump Width 1
; bit position masks
mCAN4BTR0_BRP0:     equ    %00000001
mCAN4BTR0_BRP1:     equ    %00000010
mCAN4BTR0_BRP2:     equ    %00000100
mCAN4BTR0_BRP3:     equ    %00001000
mCAN4BTR0_BRP4:     equ    %00010000
mCAN4BTR0_BRP5:     equ    %00100000
mCAN4BTR0_SJW0:     equ    %01000000
mCAN4BTR0_SJW1:     equ    %10000000


;*** CAN4BTR1 - MSCAN4 Bus Timing Register 1; 0x00000283 ***
CAN4BTR1:           equ    $00000283                                ;*** CAN4BTR1 - MSCAN4 Bus Timing Register 1; 0x00000283 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN4BTR1_TSEG10:    equ    0                                         ; Time Segment 10
CAN4BTR1_TSEG11:    equ    1                                         ; Time Segment 11
CAN4BTR1_TSEG12:    equ    2                                         ; Time Segment 12
CAN4BTR1_TSEG13:    equ    3                                         ; Time Segment 13
CAN4BTR1_TSEG20:    equ    4                                         ; Time Segment 20
CAN4BTR1_TSEG21:    equ    5                                         ; Time Segment 21
CAN4BTR1_TSEG22:    equ    6                                         ; Time Segment 22
CAN4BTR1_SAMP:      equ    7                                         ; Sampling
; bit position masks
mCAN4BTR1_TSEG10:   equ    %00000001
mCAN4BTR1_TSEG11:   equ    %00000010
mCAN4BTR1_TSEG12:   equ    %00000100
mCAN4BTR1_TSEG13:   equ    %00001000
mCAN4BTR1_TSEG20:   equ    %00010000
mCAN4BTR1_TSEG21:   equ    %00100000
mCAN4BTR1_TSEG22:   equ    %01000000
mCAN4BTR1_SAMP:     equ    %10000000


;*** CAN4RFLG - MSCAN4 Receiver Flag Register; 0x00000284 ***
CAN4RFLG:           equ    $00000284                                ;*** CAN4RFLG - MSCAN4 Receiver Flag Register; 0x00000284 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN4RFLG_RXF:       equ    0                                         ; Receive Buffer Full
CAN4RFLG_OVRIF:     equ    1                                         ; Overrun Interrupt Flag
CAN4RFLG_TSTAT0:    equ    2                                         ; Transmitter Status Bit 0
CAN4RFLG_TSTAT1:    equ    3                                         ; Transmitter Status Bit 1
CAN4RFLG_RSTAT0:    equ    4                                         ; Receiver Status Bit 0
CAN4RFLG_RSTAT1:    equ    5                                         ; Receiver Status Bit 1
CAN4RFLG_CSCIF:     equ    6                                         ; CAN Status Change Interrupt Flag
CAN4RFLG_WUPIF:     equ    7                                         ; Wake-up Interrupt Flag
; bit position masks
mCAN4RFLG_RXF:      equ    %00000001
mCAN4RFLG_OVRIF:    equ    %00000010
mCAN4RFLG_TSTAT0:   equ    %00000100
mCAN4RFLG_TSTAT1:   equ    %00001000
mCAN4RFLG_RSTAT0:   equ    %00010000
mCAN4RFLG_RSTAT1:   equ    %00100000
mCAN4RFLG_CSCIF:    equ    %01000000
mCAN4RFLG_WUPIF:    equ    %10000000


;*** CAN4RIER - MSCAN4 Receiver Interrupt Enable Register; 0x00000285 ***
CAN4RIER:           equ    $00000285                                ;*** CAN4RIER - MSCAN4 Receiver Interrupt Enable Register; 0x00000285 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN4RIER_RXFIE:     equ    0                                         ; Receiver Full Interrupt Enable
CAN4RIER_OVRIE:     equ    1                                         ; Overrun Interrupt Enable
CAN4RIER_TSTATE0:   equ    2                                         ; Transmitter Status Change Enable 0
CAN4RIER_TSTATE1:   equ    3                                         ; Transmitter Status Change Enable 1
CAN4RIER_RSTATE0:   equ    4                                         ; Receiver Status Change Enable 0
CAN4RIER_RSTATE1:   equ    5                                         ; Receiver Status Change Enable 1
CAN4RIER_CSCIE:     equ    6                                         ; CAN Status Change Interrupt Enable
CAN4RIER_WUPIE:     equ    7                                         ; Wake-up Interrupt Enable
; bit position masks
mCAN4RIER_RXFIE:    equ    %00000001
mCAN4RIER_OVRIE:    equ    %00000010
mCAN4RIER_TSTATE0:  equ    %00000100
mCAN4RIER_TSTATE1:  equ    %00001000
mCAN4RIER_RSTATE0:  equ    %00010000
mCAN4RIER_RSTATE1:  equ    %00100000
mCAN4RIER_CSCIE:    equ    %01000000
mCAN4RIER_WUPIE:    equ    %10000000


;*** CAN4TFLG - MSCAN4 Transmitter Flag Register; 0x00000286 ***
CAN4TFLG:           equ    $00000286                                ;*** CAN4TFLG - MSCAN4 Transmitter Flag Register; 0x00000286 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN4TFLG_TXE0:      equ    0                                         ; Transmitter Buffer Empty 0
CAN4TFLG_TXE1:      equ    1                                         ; Transmitter Buffer Empty 1
CAN4TFLG_TXE2:      equ    2                                         ; Transmitter Buffer Empty 2
; bit position masks
mCAN4TFLG_TXE0:     equ    %00000001
mCAN4TFLG_TXE1:     equ    %00000010
mCAN4TFLG_TXE2:     equ    %00000100


;*** CAN4TIER - MSCAN4 Transmitter Interrupt Enable Register; 0x00000287 ***
CAN4TIER:           equ    $00000287                                ;*** CAN4TIER - MSCAN4 Transmitter Interrupt Enable Register; 0x00000287 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN4TIER_TXEIE0:    equ    0                                         ; Transmitter Empty Interrupt Enable 0
CAN4TIER_TXEIE1:    equ    1                                         ; Transmitter Empty Interrupt Enable 1
CAN4TIER_TXEIE2:    equ    2                                         ; Transmitter Empty Interrupt Enable 2
; bit position masks
mCAN4TIER_TXEIE0:   equ    %00000001
mCAN4TIER_TXEIE1:   equ    %00000010
mCAN4TIER_TXEIE2:   equ    %00000100


;*** CAN4TARQ - MSCAN 4 Transmitter Message Abort Request; 0x00000288 ***
CAN4TARQ:           equ    $00000288                                ;*** CAN4TARQ - MSCAN 4 Transmitter Message Abort Request; 0x00000288 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN4TARQ_ABTRQ0:    equ    0                                         ; Abort Request 0
CAN4TARQ_ABTRQ1:    equ    1                                         ; Abort Request 1
CAN4TARQ_ABTRQ2:    equ    2                                         ; Abort Request 2
; bit position masks
mCAN4TARQ_ABTRQ0:   equ    %00000001
mCAN4TARQ_ABTRQ1:   equ    %00000010
mCAN4TARQ_ABTRQ2:   equ    %00000100


;*** CAN4TAAK - MSCAN4 Transmitter Message Abort Control; 0x00000289 ***
CAN4TAAK:           equ    $00000289                                ;*** CAN4TAAK - MSCAN4 Transmitter Message Abort Control; 0x00000289 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN4TAAK_ABTAK0:    equ    0                                         ; Abort Acknowledge 0
CAN4TAAK_ABTAK1:    equ    1                                         ; Abort Acknowledge 1
CAN4TAAK_ABTAK2:    equ    2                                         ; Abort Acknowledge 2
; bit position masks
mCAN4TAAK_ABTAK0:   equ    %00000001
mCAN4TAAK_ABTAK1:   equ    %00000010
mCAN4TAAK_ABTAK2:   equ    %00000100


;*** CAN4TBSEL - MSCAN4 Transmit Buffer Selection; 0x0000028A ***
CAN4TBSEL:          equ    $0000028A                                ;*** CAN4TBSEL - MSCAN4 Transmit Buffer Selection; 0x0000028A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN4TBSEL_TX0:      equ    0                                         ; Transmit Buffer Select 0
CAN4TBSEL_TX1:      equ    1                                         ; Transmit Buffer Select 1
CAN4TBSEL_TX2:      equ    2                                         ; Transmit Buffer Select 2
; bit position masks
mCAN4TBSEL_TX0:     equ    %00000001
mCAN4TBSEL_TX1:     equ    %00000010
mCAN4TBSEL_TX2:     equ    %00000100


;*** CAN4IDAC - MSCAN4 Identifier Acceptance Control Register; 0x0000028B ***
CAN4IDAC:           equ    $0000028B                                ;*** CAN4IDAC - MSCAN4 Identifier Acceptance Control Register; 0x0000028B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN4IDAC_IDHIT0:    equ    0                                         ; Identifier Acceptance Hit Indicator 0
CAN4IDAC_IDHIT1:    equ    1                                         ; Identifier Acceptance Hit Indicator 1
CAN4IDAC_IDHIT2:    equ    2                                         ; Identifier Acceptance Hit Indicator 2
CAN4IDAC_IDAM0:     equ    4                                         ; Identifier Acceptance Mode 0
CAN4IDAC_IDAM1:     equ    5                                         ; Identifier Acceptance Mode 1
; bit position masks
mCAN4IDAC_IDHIT0:   equ    %00000001
mCAN4IDAC_IDHIT1:   equ    %00000010
mCAN4IDAC_IDHIT2:   equ    %00000100
mCAN4IDAC_IDAM0:    equ    %00010000
mCAN4IDAC_IDAM1:    equ    %00100000


;*** CAN4RXERR - MSCAN4 Receive Error Counter Register; 0x0000028E ***
CAN4RXERR:          equ    $0000028E                                ;*** CAN4RXERR - MSCAN4 Receive Error Counter Register; 0x0000028E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN4RXERR_RXERR0:   equ    0                                         ; Bit 0
CAN4RXERR_RXERR1:   equ    1                                         ; Bit 1
CAN4RXERR_RXERR2:   equ    2                                         ; Bit 2
CAN4RXERR_RXERR3:   equ    3                                         ; Bit 3
CAN4RXERR_RXERR4:   equ    4                                         ; Bit 4
CAN4RXERR_RXERR5:   equ    5                                         ; Bit 5
CAN4RXERR_RXERR6:   equ    6                                         ; Bit 6
CAN4RXERR_RXERR7:   equ    7                                         ; Bit 7
; bit position masks
mCAN4RXERR_RXERR0:  equ    %00000001
mCAN4RXERR_RXERR1:  equ    %00000010
mCAN4RXERR_RXERR2:  equ    %00000100
mCAN4RXERR_RXERR3:  equ    %00001000
mCAN4RXERR_RXERR4:  equ    %00010000
mCAN4RXERR_RXERR5:  equ    %00100000
mCAN4RXERR_RXERR6:  equ    %01000000
mCAN4RXERR_RXERR7:  equ    %10000000


;*** CAN4TXERR - MSCAN4 Transmit Error Counter Register; 0x0000028F ***
CAN4TXERR:          equ    $0000028F                                ;*** CAN4TXERR - MSCAN4 Transmit Error Counter Register; 0x0000028F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN4TXERR_TXERR0:   equ    0                                         ; Bit 0
CAN4TXERR_TXERR1:   equ    1                                         ; Bit 1
CAN4TXERR_TXERR2:   equ    2                                         ; Bit 2
CAN4TXERR_TXERR3:   equ    3                                         ; Bit 3
CAN4TXERR_TXERR4:   equ    4                                         ; Bit 4
CAN4TXERR_TXERR5:   equ    5                                         ; Bit 5
CAN4TXERR_TXERR6:   equ    6                                         ; Bit 6
CAN4TXERR_TXERR7:   equ    7                                         ; Bit 7
; bit position masks
mCAN4TXERR_TXERR0:  equ    %00000001
mCAN4TXERR_TXERR1:  equ    %00000010
mCAN4TXERR_TXERR2:  equ    %00000100
mCAN4TXERR_TXERR3:  equ    %00001000
mCAN4TXERR_TXERR4:  equ    %00010000
mCAN4TXERR_TXERR5:  equ    %00100000
mCAN4TXERR_TXERR6:  equ    %01000000
mCAN4TXERR_TXERR7:  equ    %10000000


;*** CAN4IDAR0 - MSCAN4 Identifier Acceptance Register 0; 0x00000290 ***
CAN4IDAR0:          equ    $00000290                                ;*** CAN4IDAR0 - MSCAN4 Identifier Acceptance Register 0; 0x00000290 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN4IDAR0_AC0:      equ    0                                         ; Acceptance Code Bit 0
CAN4IDAR0_AC1:      equ    1                                         ; Acceptance Code Bit 1
CAN4IDAR0_AC2:      equ    2                                         ; Acceptance Code Bit 2
CAN4IDAR0_AC3:      equ    3                                         ; Acceptance Code Bit 3
CAN4IDAR0_AC4:      equ    4                                         ; Acceptance Code Bit 4
CAN4IDAR0_AC5:      equ    5                                         ; Acceptance Code Bit 5
CAN4IDAR0_AC6:      equ    6                                         ; Acceptance Code Bit 6
CAN4IDAR0_AC7:      equ    7                                         ; Acceptance Code Bit 7
; bit position masks
mCAN4IDAR0_AC0:     equ    %00000001
mCAN4IDAR0_AC1:     equ    %00000010
mCAN4IDAR0_AC2:     equ    %00000100
mCAN4IDAR0_AC3:     equ    %00001000
mCAN4IDAR0_AC4:     equ    %00010000
mCAN4IDAR0_AC5:     equ    %00100000
mCAN4IDAR0_AC6:     equ    %01000000
mCAN4IDAR0_AC7:     equ    %10000000


;*** CAN4IDAR1 - MSCAN4 Identifier Acceptance Register 1; 0x00000291 ***
CAN4IDAR1:          equ    $00000291                                ;*** CAN4IDAR1 - MSCAN4 Identifier Acceptance Register 1; 0x00000291 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN4IDAR1_AC0:      equ    0                                         ; Acceptance Code Bit 0
CAN4IDAR1_AC1:      equ    1                                         ; Acceptance Code Bit 1
CAN4IDAR1_AC2:      equ    2                                         ; Acceptance Code Bit 2
CAN4IDAR1_AC3:      equ    3                                         ; Acceptance Code Bit 3
CAN4IDAR1_AC4:      equ    4                                         ; Acceptance Code Bit 4
CAN4IDAR1_AC5:      equ    5                                         ; Acceptance Code Bit 5
CAN4IDAR1_AC6:      equ    6                                         ; Acceptance Code Bit 6
CAN4IDAR1_AC7:      equ    7                                         ; Acceptance Code Bit 7
; bit position masks
mCAN4IDAR1_AC0:     equ    %00000001
mCAN4IDAR1_AC1:     equ    %00000010
mCAN4IDAR1_AC2:     equ    %00000100
mCAN4IDAR1_AC3:     equ    %00001000
mCAN4IDAR1_AC4:     equ    %00010000
mCAN4IDAR1_AC5:     equ    %00100000
mCAN4IDAR1_AC6:     equ    %01000000
mCAN4IDAR1_AC7:     equ    %10000000


;*** CAN4IDAR2 - MSCAN4 Identifier Acceptance Register 2; 0x00000292 ***
CAN4IDAR2:          equ    $00000292                                ;*** CAN4IDAR2 - MSCAN4 Identifier Acceptance Register 2; 0x00000292 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN4IDAR2_AC0:      equ    0                                         ; Acceptance Code Bit 0
CAN4IDAR2_AC1:      equ    1                                         ; Acceptance Code Bit 1
CAN4IDAR2_AC2:      equ    2                                         ; Acceptance Code Bit 2
CAN4IDAR2_AC3:      equ    3                                         ; Acceptance Code Bit 3
CAN4IDAR2_AC4:      equ    4                                         ; Acceptance Code Bit 4
CAN4IDAR2_AC5:      equ    5                                         ; Acceptance Code Bit 5
CAN4IDAR2_AC6:      equ    6                                         ; Acceptance Code Bit 6
CAN4IDAR2_AC7:      equ    7                                         ; Acceptance Code Bit 7
; bit position masks
mCAN4IDAR2_AC0:     equ    %00000001
mCAN4IDAR2_AC1:     equ    %00000010
mCAN4IDAR2_AC2:     equ    %00000100
mCAN4IDAR2_AC3:     equ    %00001000
mCAN4IDAR2_AC4:     equ    %00010000
mCAN4IDAR2_AC5:     equ    %00100000
mCAN4IDAR2_AC6:     equ    %01000000
mCAN4IDAR2_AC7:     equ    %10000000


;*** CAN4IDAR3 - MSCAN4 Identifier Acceptance Register 3; 0x00000293 ***
CAN4IDAR3:          equ    $00000293                                ;*** CAN4IDAR3 - MSCAN4 Identifier Acceptance Register 3; 0x00000293 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN4IDAR3_AC0:      equ    0                                         ; Acceptance Code Bit 0
CAN4IDAR3_AC1:      equ    1                                         ; Acceptance Code Bit 1
CAN4IDAR3_AC2:      equ    2                                         ; Acceptance Code Bit 2
CAN4IDAR3_AC3:      equ    3                                         ; Acceptance Code Bit 3
CAN4IDAR3_AC4:      equ    4                                         ; Acceptance Code Bit 4
CAN4IDAR3_AC5:      equ    5                                         ; Acceptance Code Bit 5
CAN4IDAR3_AC6:      equ    6                                         ; Acceptance Code Bit 6
CAN4IDAR3_AC7:      equ    7                                         ; Acceptance Code Bit 7
; bit position masks
mCAN4IDAR3_AC0:     equ    %00000001
mCAN4IDAR3_AC1:     equ    %00000010
mCAN4IDAR3_AC2:     equ    %00000100
mCAN4IDAR3_AC3:     equ    %00001000
mCAN4IDAR3_AC4:     equ    %00010000
mCAN4IDAR3_AC5:     equ    %00100000
mCAN4IDAR3_AC6:     equ    %01000000
mCAN4IDAR3_AC7:     equ    %10000000


;*** CAN4IDMR0 - MSCAN4 Identifier Mask Register 0; 0x00000294 ***
CAN4IDMR0:          equ    $00000294                                ;*** CAN4IDMR0 - MSCAN4 Identifier Mask Register 0; 0x00000294 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN4IDMR0_AM0:      equ    0                                         ; Acceptance Mask Bit 0
CAN4IDMR0_AM1:      equ    1                                         ; Acceptance Mask Bit 1
CAN4IDMR0_AM2:      equ    2                                         ; Acceptance Mask Bit 2
CAN4IDMR0_AM3:      equ    3                                         ; Acceptance Mask Bit 3
CAN4IDMR0_AM4:      equ    4                                         ; Acceptance Mask Bit 4
CAN4IDMR0_AM5:      equ    5                                         ; Acceptance Mask Bit 5
CAN4IDMR0_AM6:      equ    6                                         ; Acceptance Mask Bit 6
CAN4IDMR0_AM7:      equ    7                                         ; Acceptance Mask Bit 7
; bit position masks
mCAN4IDMR0_AM0:     equ    %00000001
mCAN4IDMR0_AM1:     equ    %00000010
mCAN4IDMR0_AM2:     equ    %00000100
mCAN4IDMR0_AM3:     equ    %00001000
mCAN4IDMR0_AM4:     equ    %00010000
mCAN4IDMR0_AM5:     equ    %00100000
mCAN4IDMR0_AM6:     equ    %01000000
mCAN4IDMR0_AM7:     equ    %10000000


;*** CAN4IDMR1 - MSCAN4 Identifier Mask Register 1; 0x00000295 ***
CAN4IDMR1:          equ    $00000295                                ;*** CAN4IDMR1 - MSCAN4 Identifier Mask Register 1; 0x00000295 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN4IDMR1_AM0:      equ    0                                         ; Acceptance Mask Bit 0
CAN4IDMR1_AM1:      equ    1                                         ; Acceptance Mask Bit 1
CAN4IDMR1_AM2:      equ    2                                         ; Acceptance Mask Bit 2
CAN4IDMR1_AM3:      equ    3                                         ; Acceptance Mask Bit 3
CAN4IDMR1_AM4:      equ    4                                         ; Acceptance Mask Bit 4
CAN4IDMR1_AM5:      equ    5                                         ; Acceptance Mask Bit 5
CAN4IDMR1_AM6:      equ    6                                         ; Acceptance Mask Bit 6
CAN4IDMR1_AM7:      equ    7                                         ; Acceptance Mask Bit 7
; bit position masks
mCAN4IDMR1_AM0:     equ    %00000001
mCAN4IDMR1_AM1:     equ    %00000010
mCAN4IDMR1_AM2:     equ    %00000100
mCAN4IDMR1_AM3:     equ    %00001000
mCAN4IDMR1_AM4:     equ    %00010000
mCAN4IDMR1_AM5:     equ    %00100000
mCAN4IDMR1_AM6:     equ    %01000000
mCAN4IDMR1_AM7:     equ    %10000000


;*** CAN4IDMR2 - MSCAN4 Identifier Mask Register 2; 0x00000296 ***
CAN4IDMR2:          equ    $00000296                                ;*** CAN4IDMR2 - MSCAN4 Identifier Mask Register 2; 0x00000296 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN4IDMR2_AM0:      equ    0                                         ; Acceptance Mask Bit 0
CAN4IDMR2_AM1:      equ    1                                         ; Acceptance Mask Bit 1
CAN4IDMR2_AM2:      equ    2                                         ; Acceptance Mask Bit 2
CAN4IDMR2_AM3:      equ    3                                         ; Acceptance Mask Bit 3
CAN4IDMR2_AM4:      equ    4                                         ; Acceptance Mask Bit 4
CAN4IDMR2_AM5:      equ    5                                         ; Acceptance Mask Bit 5
CAN4IDMR2_AM6:      equ    6                                         ; Acceptance Mask Bit 6
CAN4IDMR2_AM7:      equ    7                                         ; Acceptance Mask Bit 7
; bit position masks
mCAN4IDMR2_AM0:     equ    %00000001
mCAN4IDMR2_AM1:     equ    %00000010
mCAN4IDMR2_AM2:     equ    %00000100
mCAN4IDMR2_AM3:     equ    %00001000
mCAN4IDMR2_AM4:     equ    %00010000
mCAN4IDMR2_AM5:     equ    %00100000
mCAN4IDMR2_AM6:     equ    %01000000
mCAN4IDMR2_AM7:     equ    %10000000


;*** CAN4IDMR3 - MSCAN4 Identifier Mask Register 3; 0x00000297 ***
CAN4IDMR3:          equ    $00000297                                ;*** CAN4IDMR3 - MSCAN4 Identifier Mask Register 3; 0x00000297 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN4IDMR3_AM0:      equ    0                                         ; Acceptance Mask Bit 0
CAN4IDMR3_AM1:      equ    1                                         ; Acceptance Mask Bit 1
CAN4IDMR3_AM2:      equ    2                                         ; Acceptance Mask Bit 2
CAN4IDMR3_AM3:      equ    3                                         ; Acceptance Mask Bit 3
CAN4IDMR3_AM4:      equ    4                                         ; Acceptance Mask Bit 4
CAN4IDMR3_AM5:      equ    5                                         ; Acceptance Mask Bit 5
CAN4IDMR3_AM6:      equ    6                                         ; Acceptance Mask Bit 6
CAN4IDMR3_AM7:      equ    7                                         ; Acceptance Mask Bit 7
; bit position masks
mCAN4IDMR3_AM0:     equ    %00000001
mCAN4IDMR3_AM1:     equ    %00000010
mCAN4IDMR3_AM2:     equ    %00000100
mCAN4IDMR3_AM3:     equ    %00001000
mCAN4IDMR3_AM4:     equ    %00010000
mCAN4IDMR3_AM5:     equ    %00100000
mCAN4IDMR3_AM6:     equ    %01000000
mCAN4IDMR3_AM7:     equ    %10000000


;*** CAN4IDAR4 - MSCAN4 Identifier Acceptance Register 4; 0x00000298 ***
CAN4IDAR4:          equ    $00000298                                ;*** CAN4IDAR4 - MSCAN4 Identifier Acceptance Register 4; 0x00000298 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN4IDAR4_AC0:      equ    0                                         ; Acceptance Code Bit 0
CAN4IDAR4_AC1:      equ    1                                         ; Acceptance Code Bit 1
CAN4IDAR4_AC2:      equ    2                                         ; Acceptance Code Bit 2
CAN4IDAR4_AC3:      equ    3                                         ; Acceptance Code Bit 3
CAN4IDAR4_AC4:      equ    4                                         ; Acceptance Code Bit 4
CAN4IDAR4_AC5:      equ    5                                         ; Acceptance Code Bit 5
CAN4IDAR4_AC6:      equ    6                                         ; Acceptance Code Bit 6
CAN4IDAR4_AC7:      equ    7                                         ; Acceptance Code Bit 7
; bit position masks
mCAN4IDAR4_AC0:     equ    %00000001
mCAN4IDAR4_AC1:     equ    %00000010
mCAN4IDAR4_AC2:     equ    %00000100
mCAN4IDAR4_AC3:     equ    %00001000
mCAN4IDAR4_AC4:     equ    %00010000
mCAN4IDAR4_AC5:     equ    %00100000
mCAN4IDAR4_AC6:     equ    %01000000
mCAN4IDAR4_AC7:     equ    %10000000


;*** CAN4IDAR5 - MSCAN4 Identifier Acceptance Register 5; 0x00000299 ***
CAN4IDAR5:          equ    $00000299                                ;*** CAN4IDAR5 - MSCAN4 Identifier Acceptance Register 5; 0x00000299 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN4IDAR5_AC0:      equ    0                                         ; Acceptance Code Bit 0
CAN4IDAR5_AC1:      equ    1                                         ; Acceptance Code Bit 1
CAN4IDAR5_AC2:      equ    2                                         ; Acceptance Code Bit 2
CAN4IDAR5_AC3:      equ    3                                         ; Acceptance Code Bit 3
CAN4IDAR5_AC4:      equ    4                                         ; Acceptance Code Bit 4
CAN4IDAR5_AC5:      equ    5                                         ; Acceptance Code Bit 5
CAN4IDAR5_AC6:      equ    6                                         ; Acceptance Code Bit 6
CAN4IDAR5_AC7:      equ    7                                         ; Acceptance Code Bit 7
; bit position masks
mCAN4IDAR5_AC0:     equ    %00000001
mCAN4IDAR5_AC1:     equ    %00000010
mCAN4IDAR5_AC2:     equ    %00000100
mCAN4IDAR5_AC3:     equ    %00001000
mCAN4IDAR5_AC4:     equ    %00010000
mCAN4IDAR5_AC5:     equ    %00100000
mCAN4IDAR5_AC6:     equ    %01000000
mCAN4IDAR5_AC7:     equ    %10000000


;*** CAN4IDAR6 - MSCAN4 Identifier Acceptance Register 6; 0x0000029A ***
CAN4IDAR6:          equ    $0000029A                                ;*** CAN4IDAR6 - MSCAN4 Identifier Acceptance Register 6; 0x0000029A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN4IDAR6_AC0:      equ    0                                         ; Acceptance Code Bit 0
CAN4IDAR6_AC1:      equ    1                                         ; Acceptance Code Bit 1
CAN4IDAR6_AC2:      equ    2                                         ; Acceptance Code Bit 2
CAN4IDAR6_AC3:      equ    3                                         ; Acceptance Code Bit 3
CAN4IDAR6_AC4:      equ    4                                         ; Acceptance Code Bit 4
CAN4IDAR6_AC5:      equ    5                                         ; Acceptance Code Bit 5
CAN4IDAR6_AC6:      equ    6                                         ; Acceptance Code Bit 6
CAN4IDAR6_AC7:      equ    7                                         ; Acceptance Code Bit 7
; bit position masks
mCAN4IDAR6_AC0:     equ    %00000001
mCAN4IDAR6_AC1:     equ    %00000010
mCAN4IDAR6_AC2:     equ    %00000100
mCAN4IDAR6_AC3:     equ    %00001000
mCAN4IDAR6_AC4:     equ    %00010000
mCAN4IDAR6_AC5:     equ    %00100000
mCAN4IDAR6_AC6:     equ    %01000000
mCAN4IDAR6_AC7:     equ    %10000000


;*** CAN4IDAR7 - MSCAN4 Identifier Acceptance Register 7; 0x0000029B ***
CAN4IDAR7:          equ    $0000029B                                ;*** CAN4IDAR7 - MSCAN4 Identifier Acceptance Register 7; 0x0000029B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN4IDAR7_AC0:      equ    0                                         ; Acceptance Code Bit 0
CAN4IDAR7_AC1:      equ    1                                         ; Acceptance Code Bit 1
CAN4IDAR7_AC2:      equ    2                                         ; Acceptance Code Bit 2
CAN4IDAR7_AC3:      equ    3                                         ; Acceptance Code Bit 3
CAN4IDAR7_AC4:      equ    4                                         ; Acceptance Code Bit 4
CAN4IDAR7_AC5:      equ    5                                         ; Acceptance Code Bit 5
CAN4IDAR7_AC6:      equ    6                                         ; Acceptance Code Bit 6
CAN4IDAR7_AC7:      equ    7                                         ; Acceptance Code Bit 7
; bit position masks
mCAN4IDAR7_AC0:     equ    %00000001
mCAN4IDAR7_AC1:     equ    %00000010
mCAN4IDAR7_AC2:     equ    %00000100
mCAN4IDAR7_AC3:     equ    %00001000
mCAN4IDAR7_AC4:     equ    %00010000
mCAN4IDAR7_AC5:     equ    %00100000
mCAN4IDAR7_AC6:     equ    %01000000
mCAN4IDAR7_AC7:     equ    %10000000


;*** CAN4IDMR4 - MSCAN4 Identifier Mask Register 4; 0x0000029C ***
CAN4IDMR4:          equ    $0000029C                                ;*** CAN4IDMR4 - MSCAN4 Identifier Mask Register 4; 0x0000029C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN4IDMR4_AM0:      equ    0                                         ; Acceptance Mask Bit 0
CAN4IDMR4_AM1:      equ    1                                         ; Acceptance Mask Bit 1
CAN4IDMR4_AM2:      equ    2                                         ; Acceptance Mask Bit 2
CAN4IDMR4_AM3:      equ    3                                         ; Acceptance Mask Bit 3
CAN4IDMR4_AM4:      equ    4                                         ; Acceptance Mask Bit 4
CAN4IDMR4_AM5:      equ    5                                         ; Acceptance Mask Bit 5
CAN4IDMR4_AM6:      equ    6                                         ; Acceptance Mask Bit 6
CAN4IDMR4_AM7:      equ    7                                         ; Acceptance Mask Bit 7
; bit position masks
mCAN4IDMR4_AM0:     equ    %00000001
mCAN4IDMR4_AM1:     equ    %00000010
mCAN4IDMR4_AM2:     equ    %00000100
mCAN4IDMR4_AM3:     equ    %00001000
mCAN4IDMR4_AM4:     equ    %00010000
mCAN4IDMR4_AM5:     equ    %00100000
mCAN4IDMR4_AM6:     equ    %01000000
mCAN4IDMR4_AM7:     equ    %10000000


;*** CAN4IDMR5 - MSCAN4 Identifier Mask Register 5; 0x0000029D ***
CAN4IDMR5:          equ    $0000029D                                ;*** CAN4IDMR5 - MSCAN4 Identifier Mask Register 5; 0x0000029D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN4IDMR5_AM0:      equ    0                                         ; Acceptance Mask Bit 0
CAN4IDMR5_AM1:      equ    1                                         ; Acceptance Mask Bit 1
CAN4IDMR5_AM2:      equ    2                                         ; Acceptance Mask Bit 2
CAN4IDMR5_AM3:      equ    3                                         ; Acceptance Mask Bit 3
CAN4IDMR5_AM4:      equ    4                                         ; Acceptance Mask Bit 4
CAN4IDMR5_AM5:      equ    5                                         ; Acceptance Mask Bit 5
CAN4IDMR5_AM6:      equ    6                                         ; Acceptance Mask Bit 6
CAN4IDMR5_AM7:      equ    7                                         ; Acceptance Mask Bit 7
; bit position masks
mCAN4IDMR5_AM0:     equ    %00000001
mCAN4IDMR5_AM1:     equ    %00000010
mCAN4IDMR5_AM2:     equ    %00000100
mCAN4IDMR5_AM3:     equ    %00001000
mCAN4IDMR5_AM4:     equ    %00010000
mCAN4IDMR5_AM5:     equ    %00100000
mCAN4IDMR5_AM6:     equ    %01000000
mCAN4IDMR5_AM7:     equ    %10000000


;*** CAN4IDMR6 - MSCAN4 Identifier Mask Register 6; 0x0000029E ***
CAN4IDMR6:          equ    $0000029E                                ;*** CAN4IDMR6 - MSCAN4 Identifier Mask Register 6; 0x0000029E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN4IDMR6_AM0:      equ    0                                         ; Acceptance Mask Bit 0
CAN4IDMR6_AM1:      equ    1                                         ; Acceptance Mask Bit 1
CAN4IDMR6_AM2:      equ    2                                         ; Acceptance Mask Bit 2
CAN4IDMR6_AM3:      equ    3                                         ; Acceptance Mask Bit 3
CAN4IDMR6_AM4:      equ    4                                         ; Acceptance Mask Bit 4
CAN4IDMR6_AM5:      equ    5                                         ; Acceptance Mask Bit 5
CAN4IDMR6_AM6:      equ    6                                         ; Acceptance Mask Bit 6
CAN4IDMR6_AM7:      equ    7                                         ; Acceptance Mask Bit 7
; bit position masks
mCAN4IDMR6_AM0:     equ    %00000001
mCAN4IDMR6_AM1:     equ    %00000010
mCAN4IDMR6_AM2:     equ    %00000100
mCAN4IDMR6_AM3:     equ    %00001000
mCAN4IDMR6_AM4:     equ    %00010000
mCAN4IDMR6_AM5:     equ    %00100000
mCAN4IDMR6_AM6:     equ    %01000000
mCAN4IDMR6_AM7:     equ    %10000000


;*** CAN4IDMR7 - MSCAN4 Identifier Mask Register 7; 0x0000029F ***
CAN4IDMR7:          equ    $0000029F                                ;*** CAN4IDMR7 - MSCAN4 Identifier Mask Register 7; 0x0000029F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN4IDMR7_AM0:      equ    0                                         ; Acceptance Mask Bit 0
CAN4IDMR7_AM1:      equ    1                                         ; Acceptance Mask Bit 1
CAN4IDMR7_AM2:      equ    2                                         ; Acceptance Mask Bit 2
CAN4IDMR7_AM3:      equ    3                                         ; Acceptance Mask Bit 3
CAN4IDMR7_AM4:      equ    4                                         ; Acceptance Mask Bit 4
CAN4IDMR7_AM5:      equ    5                                         ; Acceptance Mask Bit 5
CAN4IDMR7_AM6:      equ    6                                         ; Acceptance Mask Bit 6
CAN4IDMR7_AM7:      equ    7                                         ; Acceptance Mask Bit 7
; bit position masks
mCAN4IDMR7_AM0:     equ    %00000001
mCAN4IDMR7_AM1:     equ    %00000010
mCAN4IDMR7_AM2:     equ    %00000100
mCAN4IDMR7_AM3:     equ    %00001000
mCAN4IDMR7_AM4:     equ    %00010000
mCAN4IDMR7_AM5:     equ    %00100000
mCAN4IDMR7_AM6:     equ    %01000000
mCAN4IDMR7_AM7:     equ    %10000000


;*** CAN4RXIDR0 - MSCAN4 Receive Identifier Register 0; 0x000002A0 ***
CAN4RXIDR0:         equ    $000002A0                                ;*** CAN4RXIDR0 - MSCAN4 Receive Identifier Register 0; 0x000002A0 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN4RXIDR0_ID21:    equ    0                                         ; Extended format identifier Bit 21
CAN4RXIDR0_ID22:    equ    1                                         ; Extended format identifier Bit 22
CAN4RXIDR0_ID23:    equ    2                                         ; Extended format identifier Bit 23
CAN4RXIDR0_ID24:    equ    3                                         ; Extended format identifier Bit 24
CAN4RXIDR0_ID25:    equ    4                                         ; Extended format identifier Bit 25
CAN4RXIDR0_ID26:    equ    5                                         ; Extended format identifier Bit 26
CAN4RXIDR0_ID27:    equ    6                                         ; Extended format identifier Bit 27
CAN4RXIDR0_ID28:    equ    7                                         ; Extended format identifier Bit 28
; bit position masks
mCAN4RXIDR0_ID21:   equ    %00000001
mCAN4RXIDR0_ID22:   equ    %00000010
mCAN4RXIDR0_ID23:   equ    %00000100
mCAN4RXIDR0_ID24:   equ    %00001000
mCAN4RXIDR0_ID25:   equ    %00010000
mCAN4RXIDR0_ID26:   equ    %00100000
mCAN4RXIDR0_ID27:   equ    %01000000
mCAN4RXIDR0_ID28:   equ    %10000000


;*** CAN4RXIDR1 - MSCAN4 Receive Identifier Register 1; 0x000002A1 ***
CAN4RXIDR1:         equ    $000002A1                                ;*** CAN4RXIDR1 - MSCAN4 Receive Identifier Register 1; 0x000002A1 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN4RXIDR1_ID15:    equ    0                                         ; Extended format identifier Bit 15
CAN4RXIDR1_ID16:    equ    1                                         ; Extended format identifier Bit 16
CAN4RXIDR1_ID17:    equ    2                                         ; Extended format identifier Bit 17
CAN4RXIDR1_IDE:     equ    3                                         ; ID Extended
CAN4RXIDR1_SRR:     equ    4                                         ; Substitute Remote Request
CAN4RXIDR1_ID18:    equ    5                                         ; Extended format identifier Bit 18
CAN4RXIDR1_ID19:    equ    6                                         ; Extended format identifier Bit 19
CAN4RXIDR1_ID20:    equ    7                                         ; Extended format identifier Bit 20
; bit position masks
mCAN4RXIDR1_ID15:   equ    %00000001
mCAN4RXIDR1_ID16:   equ    %00000010
mCAN4RXIDR1_ID17:   equ    %00000100
mCAN4RXIDR1_IDE:    equ    %00001000
mCAN4RXIDR1_SRR:    equ    %00010000
mCAN4RXIDR1_ID18:   equ    %00100000
mCAN4RXIDR1_ID19:   equ    %01000000
mCAN4RXIDR1_ID20:   equ    %10000000


;*** CAN4RXIDR2 - MSCAN4 Receive Identifier Register 2; 0x000002A2 ***
CAN4RXIDR2:         equ    $000002A2                                ;*** CAN4RXIDR2 - MSCAN4 Receive Identifier Register 2; 0x000002A2 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN4RXIDR2_ID7:     equ    0                                         ; Extended format identifier Bit 7
CAN4RXIDR2_ID8:     equ    1                                         ; Extended format identifier Bit 8
CAN4RXIDR2_ID9:     equ    2                                         ; Extended format identifier Bit 9
CAN4RXIDR2_ID10:    equ    3                                         ; Extended format identifier Bit 10
CAN4RXIDR2_ID11:    equ    4                                         ; Extended format identifier Bit 11
CAN4RXIDR2_ID12:    equ    5                                         ; Extended format identifier Bit 12
CAN4RXIDR2_ID13:    equ    6                                         ; Extended format identifier Bit 13
CAN4RXIDR2_ID14:    equ    7                                         ; Extended format identifier Bit 14
; bit position masks
mCAN4RXIDR2_ID7:    equ    %00000001
mCAN4RXIDR2_ID8:    equ    %00000010
mCAN4RXIDR2_ID9:    equ    %00000100
mCAN4RXIDR2_ID10:   equ    %00001000
mCAN4RXIDR2_ID11:   equ    %00010000
mCAN4RXIDR2_ID12:   equ    %00100000
mCAN4RXIDR2_ID13:   equ    %01000000
mCAN4RXIDR2_ID14:   equ    %10000000


;*** CAN4RXIDR3 - MSCAN4 Receive Identifier Register 3; 0x000002A3 ***
CAN4RXIDR3:         equ    $000002A3                                ;*** CAN4RXIDR3 - MSCAN4 Receive Identifier Register 3; 0x000002A3 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN4RXIDR3_RTR:     equ    0                                         ; Remote Transmission Request
CAN4RXIDR3_ID0:     equ    1                                         ; Extended format identifier Bit 0
CAN4RXIDR3_ID1:     equ    2                                         ; Extended format identifier Bit 1
CAN4RXIDR3_ID2:     equ    3                                         ; Extended format identifier Bit 2
CAN4RXIDR3_ID3:     equ    4                                         ; Extended format identifier Bit 3
CAN4RXIDR3_ID4:     equ    5                                         ; Extended format identifier Bit 4
CAN4RXIDR3_ID5:     equ    6                                         ; Extended format identifier Bit 5
CAN4RXIDR3_ID6:     equ    7                                         ; Extended format identifier Bit 6
; bit position masks
mCAN4RXIDR3_RTR:    equ    %00000001
mCAN4RXIDR3_ID0:    equ    %00000010
mCAN4RXIDR3_ID1:    equ    %00000100
mCAN4RXIDR3_ID2:    equ    %00001000
mCAN4RXIDR3_ID3:    equ    %00010000
mCAN4RXIDR3_ID4:    equ    %00100000
mCAN4RXIDR3_ID5:    equ    %01000000
mCAN4RXIDR3_ID6:    equ    %10000000


;*** CAN4RXDSR0 - MSCAN4 Receive Data Segment Register 0; 0x000002A4 ***
CAN4RXDSR0:         equ    $000002A4                                ;*** CAN4RXDSR0 - MSCAN4 Receive Data Segment Register 0; 0x000002A4 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN4RXDSR0_DB0:     equ    0                                         ; Data Bit 0
CAN4RXDSR0_DB1:     equ    1                                         ; Data Bit 1
CAN4RXDSR0_DB2:     equ    2                                         ; Data Bit 2
CAN4RXDSR0_DB3:     equ    3                                         ; Data Bit 3
CAN4RXDSR0_DB4:     equ    4                                         ; Data Bit 4
CAN4RXDSR0_DB5:     equ    5                                         ; Data Bit 5
CAN4RXDSR0_DB6:     equ    6                                         ; Data Bit 6
CAN4RXDSR0_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN4RXDSR0_DB0:    equ    %00000001
mCAN4RXDSR0_DB1:    equ    %00000010
mCAN4RXDSR0_DB2:    equ    %00000100
mCAN4RXDSR0_DB3:    equ    %00001000
mCAN4RXDSR0_DB4:    equ    %00010000
mCAN4RXDSR0_DB5:    equ    %00100000
mCAN4RXDSR0_DB6:    equ    %01000000
mCAN4RXDSR0_DB7:    equ    %10000000


;*** CAN4RXDSR1 - MSCAN4 Receive Data Segment Register 1; 0x000002A5 ***
CAN4RXDSR1:         equ    $000002A5                                ;*** CAN4RXDSR1 - MSCAN4 Receive Data Segment Register 1; 0x000002A5 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN4RXDSR1_DB0:     equ    0                                         ; Data Bit 0
CAN4RXDSR1_DB1:     equ    1                                         ; Data Bit 1
CAN4RXDSR1_DB2:     equ    2                                         ; Data Bit 2
CAN4RXDSR1_DB3:     equ    3                                         ; Data Bit 3
CAN4RXDSR1_DB4:     equ    4                                         ; Data Bit 4
CAN4RXDSR1_DB5:     equ    5                                         ; Data Bit 5
CAN4RXDSR1_DB6:     equ    6                                         ; Data Bit 6
CAN4RXDSR1_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN4RXDSR1_DB0:    equ    %00000001
mCAN4RXDSR1_DB1:    equ    %00000010
mCAN4RXDSR1_DB2:    equ    %00000100
mCAN4RXDSR1_DB3:    equ    %00001000
mCAN4RXDSR1_DB4:    equ    %00010000
mCAN4RXDSR1_DB5:    equ    %00100000
mCAN4RXDSR1_DB6:    equ    %01000000
mCAN4RXDSR1_DB7:    equ    %10000000


;*** CAN4RXDSR2 - MSCAN4 Receive Data Segment Register 2; 0x000002A6 ***
CAN4RXDSR2:         equ    $000002A6                                ;*** CAN4RXDSR2 - MSCAN4 Receive Data Segment Register 2; 0x000002A6 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN4RXDSR2_DB0:     equ    0                                         ; Data Bit 0
CAN4RXDSR2_DB1:     equ    1                                         ; Data Bit 1
CAN4RXDSR2_DB2:     equ    2                                         ; Data Bit 2
CAN4RXDSR2_DB3:     equ    3                                         ; Data Bit 3
CAN4RXDSR2_DB4:     equ    4                                         ; Data Bit 4
CAN4RXDSR2_DB5:     equ    5                                         ; Data Bit 5
CAN4RXDSR2_DB6:     equ    6                                         ; Data Bit 6
CAN4RXDSR2_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN4RXDSR2_DB0:    equ    %00000001
mCAN4RXDSR2_DB1:    equ    %00000010
mCAN4RXDSR2_DB2:    equ    %00000100
mCAN4RXDSR2_DB3:    equ    %00001000
mCAN4RXDSR2_DB4:    equ    %00010000
mCAN4RXDSR2_DB5:    equ    %00100000
mCAN4RXDSR2_DB6:    equ    %01000000
mCAN4RXDSR2_DB7:    equ    %10000000


;*** CAN4RXDSR3 - MSCAN4 Receive Data Segment Register 3; 0x000002A7 ***
CAN4RXDSR3:         equ    $000002A7                                ;*** CAN4RXDSR3 - MSCAN4 Receive Data Segment Register 3; 0x000002A7 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN4RXDSR3_DB0:     equ    0                                         ; Data Bit 0
CAN4RXDSR3_DB1:     equ    1                                         ; Data Bit 1
CAN4RXDSR3_DB2:     equ    2                                         ; Data Bit 2
CAN4RXDSR3_DB3:     equ    3                                         ; Data Bit 3
CAN4RXDSR3_DB4:     equ    4                                         ; Data Bit 4
CAN4RXDSR3_DB5:     equ    5                                         ; Data Bit 5
CAN4RXDSR3_DB6:     equ    6                                         ; Data Bit 6
CAN4RXDSR3_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN4RXDSR3_DB0:    equ    %00000001
mCAN4RXDSR3_DB1:    equ    %00000010
mCAN4RXDSR3_DB2:    equ    %00000100
mCAN4RXDSR3_DB3:    equ    %00001000
mCAN4RXDSR3_DB4:    equ    %00010000
mCAN4RXDSR3_DB5:    equ    %00100000
mCAN4RXDSR3_DB6:    equ    %01000000
mCAN4RXDSR3_DB7:    equ    %10000000


;*** CAN4RXDSR4 - MSCAN4 Receive Data Segment Register 4; 0x000002A8 ***
CAN4RXDSR4:         equ    $000002A8                                ;*** CAN4RXDSR4 - MSCAN4 Receive Data Segment Register 4; 0x000002A8 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN4RXDSR4_DB0:     equ    0                                         ; Data Bit 0
CAN4RXDSR4_DB1:     equ    1                                         ; Data Bit 1
CAN4RXDSR4_DB2:     equ    2                                         ; Data Bit 2
CAN4RXDSR4_DB3:     equ    3                                         ; Data Bit 3
CAN4RXDSR4_DB4:     equ    4                                         ; Data Bit 4
CAN4RXDSR4_DB5:     equ    5                                         ; Data Bit 5
CAN4RXDSR4_DB6:     equ    6                                         ; Data Bit 6
CAN4RXDSR4_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN4RXDSR4_DB0:    equ    %00000001
mCAN4RXDSR4_DB1:    equ    %00000010
mCAN4RXDSR4_DB2:    equ    %00000100
mCAN4RXDSR4_DB3:    equ    %00001000
mCAN4RXDSR4_DB4:    equ    %00010000
mCAN4RXDSR4_DB5:    equ    %00100000
mCAN4RXDSR4_DB6:    equ    %01000000
mCAN4RXDSR4_DB7:    equ    %10000000


;*** CAN4RXDSR5 - MSCAN4 Receive Data Segment Register 5; 0x000002A9 ***
CAN4RXDSR5:         equ    $000002A9                                ;*** CAN4RXDSR5 - MSCAN4 Receive Data Segment Register 5; 0x000002A9 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN4RXDSR5_DB0:     equ    0                                         ; Data Bit 0
CAN4RXDSR5_DB1:     equ    1                                         ; Data Bit 1
CAN4RXDSR5_DB2:     equ    2                                         ; Data Bit 2
CAN4RXDSR5_DB3:     equ    3                                         ; Data Bit 3
CAN4RXDSR5_DB4:     equ    4                                         ; Data Bit 4
CAN4RXDSR5_DB5:     equ    5                                         ; Data Bit 5
CAN4RXDSR5_DB6:     equ    6                                         ; Data Bit 6
CAN4RXDSR5_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN4RXDSR5_DB0:    equ    %00000001
mCAN4RXDSR5_DB1:    equ    %00000010
mCAN4RXDSR5_DB2:    equ    %00000100
mCAN4RXDSR5_DB3:    equ    %00001000
mCAN4RXDSR5_DB4:    equ    %00010000
mCAN4RXDSR5_DB5:    equ    %00100000
mCAN4RXDSR5_DB6:    equ    %01000000
mCAN4RXDSR5_DB7:    equ    %10000000


;*** CAN4RXDSR6 - MSCAN4 Receive Data Segment Register 6; 0x000002AA ***
CAN4RXDSR6:         equ    $000002AA                                ;*** CAN4RXDSR6 - MSCAN4 Receive Data Segment Register 6; 0x000002AA ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN4RXDSR6_DB0:     equ    0                                         ; Data Bit 0
CAN4RXDSR6_DB1:     equ    1                                         ; Data Bit 1
CAN4RXDSR6_DB2:     equ    2                                         ; Data Bit 2
CAN4RXDSR6_DB3:     equ    3                                         ; Data Bit 3
CAN4RXDSR6_DB4:     equ    4                                         ; Data Bit 4
CAN4RXDSR6_DB5:     equ    5                                         ; Data Bit 5
CAN4RXDSR6_DB6:     equ    6                                         ; Data Bit 6
CAN4RXDSR6_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN4RXDSR6_DB0:    equ    %00000001
mCAN4RXDSR6_DB1:    equ    %00000010
mCAN4RXDSR6_DB2:    equ    %00000100
mCAN4RXDSR6_DB3:    equ    %00001000
mCAN4RXDSR6_DB4:    equ    %00010000
mCAN4RXDSR6_DB5:    equ    %00100000
mCAN4RXDSR6_DB6:    equ    %01000000
mCAN4RXDSR6_DB7:    equ    %10000000


;*** CAN4RXDSR7 - MSCAN4 Receive Data Segment Register 7; 0x000002AB ***
CAN4RXDSR7:         equ    $000002AB                                ;*** CAN4RXDSR7 - MSCAN4 Receive Data Segment Register 7; 0x000002AB ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN4RXDSR7_DB0:     equ    0                                         ; Data Bit 0
CAN4RXDSR7_DB1:     equ    1                                         ; Data Bit 1
CAN4RXDSR7_DB2:     equ    2                                         ; Data Bit 2
CAN4RXDSR7_DB3:     equ    3                                         ; Data Bit 3
CAN4RXDSR7_DB4:     equ    4                                         ; Data Bit 4
CAN4RXDSR7_DB5:     equ    5                                         ; Data Bit 5
CAN4RXDSR7_DB6:     equ    6                                         ; Data Bit 6
CAN4RXDSR7_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN4RXDSR7_DB0:    equ    %00000001
mCAN4RXDSR7_DB1:    equ    %00000010
mCAN4RXDSR7_DB2:    equ    %00000100
mCAN4RXDSR7_DB3:    equ    %00001000
mCAN4RXDSR7_DB4:    equ    %00010000
mCAN4RXDSR7_DB5:    equ    %00100000
mCAN4RXDSR7_DB6:    equ    %01000000
mCAN4RXDSR7_DB7:    equ    %10000000


;*** CAN4RXDLR - MSCAN4 Receive Data Length Register; 0x000002AC ***
CAN4RXDLR:          equ    $000002AC                                ;*** CAN4RXDLR - MSCAN4 Receive Data Length Register; 0x000002AC ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN4RXDLR_DLC0:     equ    0                                         ; Data Length Code Bit 0
CAN4RXDLR_DLC1:     equ    1                                         ; Data Length Code Bit 1
CAN4RXDLR_DLC2:     equ    2                                         ; Data Length Code Bit 2
CAN4RXDLR_DLC3:     equ    3                                         ; Data Length Code Bit 3
; bit position masks
mCAN4RXDLR_DLC0:    equ    %00000001
mCAN4RXDLR_DLC1:    equ    %00000010
mCAN4RXDLR_DLC2:    equ    %00000100
mCAN4RXDLR_DLC3:    equ    %00001000


;*** CAN4RXTSR - MSCAN 4 Receive Time Stamp Register; 0x000002AE ***
CAN4RXTSR:          equ    $000002AE                                ;*** CAN4RXTSR - MSCAN 4 Receive Time Stamp Register; 0x000002AE ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN4RXTSR_TSR0:     equ    0                                         ; Time Stamp Bit 0
CAN4RXTSR_TSR1:     equ    1                                         ; Time Stamp Bit 1
CAN4RXTSR_TSR2:     equ    2                                         ; Time Stamp Bit 2
CAN4RXTSR_TSR3:     equ    3                                         ; Time Stamp Bit 3
CAN4RXTSR_TSR4:     equ    4                                         ; Time Stamp Bit 4
CAN4RXTSR_TSR5:     equ    5                                         ; Time Stamp Bit 5
CAN4RXTSR_TSR6:     equ    6                                         ; Time Stamp Bit 6
CAN4RXTSR_TSR7:     equ    7                                         ; Time Stamp Bit 7
CAN4RXTSR_TSR8:     equ    8                                         ; Time Stamp Bit 8
CAN4RXTSR_TSR9:     equ    9                                         ; Time Stamp Bit 9
CAN4RXTSR_TSR10:    equ    10                                        ; Time Stamp Bit 10
CAN4RXTSR_TSR11:    equ    11                                        ; Time Stamp Bit 11
CAN4RXTSR_TSR12:    equ    12                                        ; Time Stamp Bit 12
CAN4RXTSR_TSR13:    equ    13                                        ; Time Stamp Bit 13
CAN4RXTSR_TSR14:    equ    14                                        ; Time Stamp Bit 14
CAN4RXTSR_TSR15:    equ    15                                        ; Time Stamp Bit 15
; bit position masks
mCAN4RXTSR_TSR0:    equ    %00000001
mCAN4RXTSR_TSR1:    equ    %00000010
mCAN4RXTSR_TSR2:    equ    %00000100
mCAN4RXTSR_TSR3:    equ    %00001000
mCAN4RXTSR_TSR4:    equ    %00010000
mCAN4RXTSR_TSR5:    equ    %00100000
mCAN4RXTSR_TSR6:    equ    %01000000
mCAN4RXTSR_TSR7:    equ    %10000000
mCAN4RXTSR_TSR8:    equ    %100000000
mCAN4RXTSR_TSR9:    equ    %1000000000
mCAN4RXTSR_TSR10:   equ    %10000000000
mCAN4RXTSR_TSR11:   equ    %100000000000
mCAN4RXTSR_TSR12:   equ    %1000000000000
mCAN4RXTSR_TSR13:   equ    %10000000000000
mCAN4RXTSR_TSR14:   equ    %100000000000000
mCAN4RXTSR_TSR15:   equ    %1000000000000000


;*** CAN4RXTSRH - MSCAN 4 Receive Time Stamp Register High; 0x000002AE ***
CAN4RXTSRH:         equ    $000002AE                                ;*** CAN4RXTSRH - MSCAN 4 Receive Time Stamp Register High; 0x000002AE ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN4RXTSRH_TSR8:    equ    0                                         ; Time Stamp Bit 8
CAN4RXTSRH_TSR9:    equ    1                                         ; Time Stamp Bit 9
CAN4RXTSRH_TSR10:   equ    2                                         ; Time Stamp Bit 10
CAN4RXTSRH_TSR11:   equ    3                                         ; Time Stamp Bit 11
CAN4RXTSRH_TSR12:   equ    4                                         ; Time Stamp Bit 12
CAN4RXTSRH_TSR13:   equ    5                                         ; Time Stamp Bit 13
CAN4RXTSRH_TSR14:   equ    6                                         ; Time Stamp Bit 14
CAN4RXTSRH_TSR15:   equ    7                                         ; Time Stamp Bit 15
; bit position masks
mCAN4RXTSRH_TSR8:   equ    %00000001
mCAN4RXTSRH_TSR9:   equ    %00000010
mCAN4RXTSRH_TSR10:  equ    %00000100
mCAN4RXTSRH_TSR11:  equ    %00001000
mCAN4RXTSRH_TSR12:  equ    %00010000
mCAN4RXTSRH_TSR13:  equ    %00100000
mCAN4RXTSRH_TSR14:  equ    %01000000
mCAN4RXTSRH_TSR15:  equ    %10000000


;*** CAN4RXTSRL - MSCAN 4 Receive Time Stamp Register Low; 0x000002AF ***
CAN4RXTSRL:         equ    $000002AF                                ;*** CAN4RXTSRL - MSCAN 4 Receive Time Stamp Register Low; 0x000002AF ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN4RXTSRL_TSR0:    equ    0                                         ; Time Stamp Bit 0
CAN4RXTSRL_TSR1:    equ    1                                         ; Time Stamp Bit 1
CAN4RXTSRL_TSR2:    equ    2                                         ; Time Stamp Bit 2
CAN4RXTSRL_TSR3:    equ    3                                         ; Time Stamp Bit 3
CAN4RXTSRL_TSR4:    equ    4                                         ; Time Stamp Bit 4
CAN4RXTSRL_TSR5:    equ    5                                         ; Time Stamp Bit 5
CAN4RXTSRL_TSR6:    equ    6                                         ; Time Stamp Bit 6
CAN4RXTSRL_TSR7:    equ    7                                         ; Time Stamp Bit 7
; bit position masks
mCAN4RXTSRL_TSR0:   equ    %00000001
mCAN4RXTSRL_TSR1:   equ    %00000010
mCAN4RXTSRL_TSR2:   equ    %00000100
mCAN4RXTSRL_TSR3:   equ    %00001000
mCAN4RXTSRL_TSR4:   equ    %00010000
mCAN4RXTSRL_TSR5:   equ    %00100000
mCAN4RXTSRL_TSR6:   equ    %01000000
mCAN4RXTSRL_TSR7:   equ    %10000000


;*** CAN4TXIDR0 - MSCAN4 Transmit Identifier Register 0; 0x000002B0 ***
CAN4TXIDR0:         equ    $000002B0                                ;*** CAN4TXIDR0 - MSCAN4 Transmit Identifier Register 0; 0x000002B0 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN4TXIDR0_ID21:    equ    0                                         ; Extended format identifier Bit 21
CAN4TXIDR0_ID22:    equ    1                                         ; Extended format identifier Bit 22
CAN4TXIDR0_ID23:    equ    2                                         ; Extended format identifier Bit 23
CAN4TXIDR0_ID24:    equ    3                                         ; Extended format identifier Bit 24
CAN4TXIDR0_ID25:    equ    4                                         ; Extended format identifier Bit 25
CAN4TXIDR0_ID26:    equ    5                                         ; Extended format identifier Bit 26
CAN4TXIDR0_ID27:    equ    6                                         ; Extended format identifier Bit 27
CAN4TXIDR0_ID28:    equ    7                                         ; Extended format identifier Bit 28
; bit position masks
mCAN4TXIDR0_ID21:   equ    %00000001
mCAN4TXIDR0_ID22:   equ    %00000010
mCAN4TXIDR0_ID23:   equ    %00000100
mCAN4TXIDR0_ID24:   equ    %00001000
mCAN4TXIDR0_ID25:   equ    %00010000
mCAN4TXIDR0_ID26:   equ    %00100000
mCAN4TXIDR0_ID27:   equ    %01000000
mCAN4TXIDR0_ID28:   equ    %10000000


;*** CAN4TXIDR1 - MSCAN4 Transmit Identifier Register 1; 0x000002B1 ***
CAN4TXIDR1:         equ    $000002B1                                ;*** CAN4TXIDR1 - MSCAN4 Transmit Identifier Register 1; 0x000002B1 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN4TXIDR1_ID15:    equ    0                                         ; Extended format identifier Bit 15
CAN4TXIDR1_ID16:    equ    1                                         ; Extended format identifier Bit 16
CAN4TXIDR1_ID17:    equ    2                                         ; Extended format identifier Bit 17
CAN4TXIDR1_IDE:     equ    3                                         ; ID Extended
CAN4TXIDR1_SRR:     equ    4                                         ; Substitute Remote Request
CAN4TXIDR1_ID18:    equ    5                                         ; Extended format identifier Bit 18
CAN4TXIDR1_ID19:    equ    6                                         ; Extended format identifier Bit 19
CAN4TXIDR1_ID20:    equ    7                                         ; Extended format identifier Bit 20
; bit position masks
mCAN4TXIDR1_ID15:   equ    %00000001
mCAN4TXIDR1_ID16:   equ    %00000010
mCAN4TXIDR1_ID17:   equ    %00000100
mCAN4TXIDR1_IDE:    equ    %00001000
mCAN4TXIDR1_SRR:    equ    %00010000
mCAN4TXIDR1_ID18:   equ    %00100000
mCAN4TXIDR1_ID19:   equ    %01000000
mCAN4TXIDR1_ID20:   equ    %10000000


;*** CAN4TXIDR2 - MSCAN4 Transmit Identifier Register 2; 0x000002B2 ***
CAN4TXIDR2:         equ    $000002B2                                ;*** CAN4TXIDR2 - MSCAN4 Transmit Identifier Register 2; 0x000002B2 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN4TXIDR2_ID7:     equ    0                                         ; Extended format identifier Bit 7
CAN4TXIDR2_ID8:     equ    1                                         ; Extended format identifier Bit 8
CAN4TXIDR2_ID9:     equ    2                                         ; Extended format identifier Bit 9
CAN4TXIDR2_ID10:    equ    3                                         ; Extended format identifier Bit 10
CAN4TXIDR2_ID11:    equ    4                                         ; Extended format identifier Bit 11
CAN4TXIDR2_ID12:    equ    5                                         ; Extended format identifier Bit 12
CAN4TXIDR2_ID13:    equ    6                                         ; Extended format identifier Bit 13
CAN4TXIDR2_ID14:    equ    7                                         ; Extended format identifier Bit 14
; bit position masks
mCAN4TXIDR2_ID7:    equ    %00000001
mCAN4TXIDR2_ID8:    equ    %00000010
mCAN4TXIDR2_ID9:    equ    %00000100
mCAN4TXIDR2_ID10:   equ    %00001000
mCAN4TXIDR2_ID11:   equ    %00010000
mCAN4TXIDR2_ID12:   equ    %00100000
mCAN4TXIDR2_ID13:   equ    %01000000
mCAN4TXIDR2_ID14:   equ    %10000000


;*** CAN4TXIDR3 - MSCAN4 Transmit Identifier Register 3; 0x000002B3 ***
CAN4TXIDR3:         equ    $000002B3                                ;*** CAN4TXIDR3 - MSCAN4 Transmit Identifier Register 3; 0x000002B3 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN4TXIDR3_RTR:     equ    0                                         ; Remote Transmission Request
CAN4TXIDR3_ID0:     equ    1                                         ; Extended format identifier Bit 0
CAN4TXIDR3_ID1:     equ    2                                         ; Extended format identifier Bit 1
CAN4TXIDR3_ID2:     equ    3                                         ; Extended format identifier Bit 2
CAN4TXIDR3_ID3:     equ    4                                         ; Extended format identifier Bit 3
CAN4TXIDR3_ID4:     equ    5                                         ; Extended format identifier Bit 4
CAN4TXIDR3_ID5:     equ    6                                         ; Extended format identifier Bit 5
CAN4TXIDR3_ID6:     equ    7                                         ; Extended format identifier Bit 6
; bit position masks
mCAN4TXIDR3_RTR:    equ    %00000001
mCAN4TXIDR3_ID0:    equ    %00000010
mCAN4TXIDR3_ID1:    equ    %00000100
mCAN4TXIDR3_ID2:    equ    %00001000
mCAN4TXIDR3_ID3:    equ    %00010000
mCAN4TXIDR3_ID4:    equ    %00100000
mCAN4TXIDR3_ID5:    equ    %01000000
mCAN4TXIDR3_ID6:    equ    %10000000


;*** CAN4TXDSR0 - MSCAN4 Transmit Data Segment Register 0; 0x000002B4 ***
CAN4TXDSR0:         equ    $000002B4                                ;*** CAN4TXDSR0 - MSCAN4 Transmit Data Segment Register 0; 0x000002B4 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN4TXDSR0_DB0:     equ    0                                         ; Data Bit 0
CAN4TXDSR0_DB1:     equ    1                                         ; Data Bit 1
CAN4TXDSR0_DB2:     equ    2                                         ; Data Bit 2
CAN4TXDSR0_DB3:     equ    3                                         ; Data Bit 3
CAN4TXDSR0_DB4:     equ    4                                         ; Data Bit 4
CAN4TXDSR0_DB5:     equ    5                                         ; Data Bit 5
CAN4TXDSR0_DB6:     equ    6                                         ; Data Bit 6
CAN4TXDSR0_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN4TXDSR0_DB0:    equ    %00000001
mCAN4TXDSR0_DB1:    equ    %00000010
mCAN4TXDSR0_DB2:    equ    %00000100
mCAN4TXDSR0_DB3:    equ    %00001000
mCAN4TXDSR0_DB4:    equ    %00010000
mCAN4TXDSR0_DB5:    equ    %00100000
mCAN4TXDSR0_DB6:    equ    %01000000
mCAN4TXDSR0_DB7:    equ    %10000000


;*** CAN4TXDSR1 - MSCAN4 Transmit Data Segment Register 1; 0x000002B5 ***
CAN4TXDSR1:         equ    $000002B5                                ;*** CAN4TXDSR1 - MSCAN4 Transmit Data Segment Register 1; 0x000002B5 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN4TXDSR1_DB0:     equ    0                                         ; Data Bit 0
CAN4TXDSR1_DB1:     equ    1                                         ; Data Bit 1
CAN4TXDSR1_DB2:     equ    2                                         ; Data Bit 2
CAN4TXDSR1_DB3:     equ    3                                         ; Data Bit 3
CAN4TXDSR1_DB4:     equ    4                                         ; Data Bit 4
CAN4TXDSR1_DB5:     equ    5                                         ; Data Bit 5
CAN4TXDSR1_DB6:     equ    6                                         ; Data Bit 6
CAN4TXDSR1_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN4TXDSR1_DB0:    equ    %00000001
mCAN4TXDSR1_DB1:    equ    %00000010
mCAN4TXDSR1_DB2:    equ    %00000100
mCAN4TXDSR1_DB3:    equ    %00001000
mCAN4TXDSR1_DB4:    equ    %00010000
mCAN4TXDSR1_DB5:    equ    %00100000
mCAN4TXDSR1_DB6:    equ    %01000000
mCAN4TXDSR1_DB7:    equ    %10000000


;*** CAN4TXDSR2 - MSCAN4 Transmit Data Segment Register 2; 0x000002B6 ***
CAN4TXDSR2:         equ    $000002B6                                ;*** CAN4TXDSR2 - MSCAN4 Transmit Data Segment Register 2; 0x000002B6 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN4TXDSR2_DB0:     equ    0                                         ; Data Bit 0
CAN4TXDSR2_DB1:     equ    1                                         ; Data Bit 1
CAN4TXDSR2_DB2:     equ    2                                         ; Data Bit 2
CAN4TXDSR2_DB3:     equ    3                                         ; Data Bit 3
CAN4TXDSR2_DB4:     equ    4                                         ; Data Bit 4
CAN4TXDSR2_DB5:     equ    5                                         ; Data Bit 5
CAN4TXDSR2_DB6:     equ    6                                         ; Data Bit 6
CAN4TXDSR2_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN4TXDSR2_DB0:    equ    %00000001
mCAN4TXDSR2_DB1:    equ    %00000010
mCAN4TXDSR2_DB2:    equ    %00000100
mCAN4TXDSR2_DB3:    equ    %00001000
mCAN4TXDSR2_DB4:    equ    %00010000
mCAN4TXDSR2_DB5:    equ    %00100000
mCAN4TXDSR2_DB6:    equ    %01000000
mCAN4TXDSR2_DB7:    equ    %10000000


;*** CAN4TXDSR3 - MSCAN4 Transmit Data Segment Register 3; 0x000002B7 ***
CAN4TXDSR3:         equ    $000002B7                                ;*** CAN4TXDSR3 - MSCAN4 Transmit Data Segment Register 3; 0x000002B7 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN4TXDSR3_DB0:     equ    0                                         ; Data Bit 0
CAN4TXDSR3_DB1:     equ    1                                         ; Data Bit 1
CAN4TXDSR3_DB2:     equ    2                                         ; Data Bit 2
CAN4TXDSR3_DB3:     equ    3                                         ; Data Bit 3
CAN4TXDSR3_DB4:     equ    4                                         ; Data Bit 4
CAN4TXDSR3_DB5:     equ    5                                         ; Data Bit 5
CAN4TXDSR3_DB6:     equ    6                                         ; Data Bit 6
CAN4TXDSR3_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN4TXDSR3_DB0:    equ    %00000001
mCAN4TXDSR3_DB1:    equ    %00000010
mCAN4TXDSR3_DB2:    equ    %00000100
mCAN4TXDSR3_DB3:    equ    %00001000
mCAN4TXDSR3_DB4:    equ    %00010000
mCAN4TXDSR3_DB5:    equ    %00100000
mCAN4TXDSR3_DB6:    equ    %01000000
mCAN4TXDSR3_DB7:    equ    %10000000


;*** CAN4TXDSR4 - MSCAN4 Transmit Data Segment Register 4; 0x000002B8 ***
CAN4TXDSR4:         equ    $000002B8                                ;*** CAN4TXDSR4 - MSCAN4 Transmit Data Segment Register 4; 0x000002B8 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN4TXDSR4_DB0:     equ    0                                         ; Data Bit 0
CAN4TXDSR4_DB1:     equ    1                                         ; Data Bit 1
CAN4TXDSR4_DB2:     equ    2                                         ; Data Bit 2
CAN4TXDSR4_DB3:     equ    3                                         ; Data Bit 3
CAN4TXDSR4_DB4:     equ    4                                         ; Data Bit 4
CAN4TXDSR4_DB5:     equ    5                                         ; Data Bit 5
CAN4TXDSR4_DB6:     equ    6                                         ; Data Bit 6
CAN4TXDSR4_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN4TXDSR4_DB0:    equ    %00000001
mCAN4TXDSR4_DB1:    equ    %00000010
mCAN4TXDSR4_DB2:    equ    %00000100
mCAN4TXDSR4_DB3:    equ    %00001000
mCAN4TXDSR4_DB4:    equ    %00010000
mCAN4TXDSR4_DB5:    equ    %00100000
mCAN4TXDSR4_DB6:    equ    %01000000
mCAN4TXDSR4_DB7:    equ    %10000000


;*** CAN4TXDSR5 - MSCAN4 Transmit Data Segment Register 5; 0x000002B9 ***
CAN4TXDSR5:         equ    $000002B9                                ;*** CAN4TXDSR5 - MSCAN4 Transmit Data Segment Register 5; 0x000002B9 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN4TXDSR5_DB0:     equ    0                                         ; Data Bit 0
CAN4TXDSR5_DB1:     equ    1                                         ; Data Bit 1
CAN4TXDSR5_DB2:     equ    2                                         ; Data Bit 2
CAN4TXDSR5_DB3:     equ    3                                         ; Data Bit 3
CAN4TXDSR5_DB4:     equ    4                                         ; Data Bit 4
CAN4TXDSR5_DB5:     equ    5                                         ; Data Bit 5
CAN4TXDSR5_DB6:     equ    6                                         ; Data Bit 6
CAN4TXDSR5_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN4TXDSR5_DB0:    equ    %00000001
mCAN4TXDSR5_DB1:    equ    %00000010
mCAN4TXDSR5_DB2:    equ    %00000100
mCAN4TXDSR5_DB3:    equ    %00001000
mCAN4TXDSR5_DB4:    equ    %00010000
mCAN4TXDSR5_DB5:    equ    %00100000
mCAN4TXDSR5_DB6:    equ    %01000000
mCAN4TXDSR5_DB7:    equ    %10000000


;*** CAN4TXDSR6 - MSCAN4 Transmit Data Segment Register 6; 0x000002BA ***
CAN4TXDSR6:         equ    $000002BA                                ;*** CAN4TXDSR6 - MSCAN4 Transmit Data Segment Register 6; 0x000002BA ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN4TXDSR6_DB0:     equ    0                                         ; Data Bit 0
CAN4TXDSR6_DB1:     equ    1                                         ; Data Bit 1
CAN4TXDSR6_DB2:     equ    2                                         ; Data Bit 2
CAN4TXDSR6_DB3:     equ    3                                         ; Data Bit 3
CAN4TXDSR6_DB4:     equ    4                                         ; Data Bit 4
CAN4TXDSR6_DB5:     equ    5                                         ; Data Bit 5
CAN4TXDSR6_DB6:     equ    6                                         ; Data Bit 6
CAN4TXDSR6_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN4TXDSR6_DB0:    equ    %00000001
mCAN4TXDSR6_DB1:    equ    %00000010
mCAN4TXDSR6_DB2:    equ    %00000100
mCAN4TXDSR6_DB3:    equ    %00001000
mCAN4TXDSR6_DB4:    equ    %00010000
mCAN4TXDSR6_DB5:    equ    %00100000
mCAN4TXDSR6_DB6:    equ    %01000000
mCAN4TXDSR6_DB7:    equ    %10000000


;*** CAN4TXDSR7 - MSCAN4 Transmit Data Segment Register 7; 0x000002BB ***
CAN4TXDSR7:         equ    $000002BB                                ;*** CAN4TXDSR7 - MSCAN4 Transmit Data Segment Register 7; 0x000002BB ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN4TXDSR7_DB0:     equ    0                                         ; Data Bit 0
CAN4TXDSR7_DB1:     equ    1                                         ; Data Bit 1
CAN4TXDSR7_DB2:     equ    2                                         ; Data Bit 2
CAN4TXDSR7_DB3:     equ    3                                         ; Data Bit 3
CAN4TXDSR7_DB4:     equ    4                                         ; Data Bit 4
CAN4TXDSR7_DB5:     equ    5                                         ; Data Bit 5
CAN4TXDSR7_DB6:     equ    6                                         ; Data Bit 6
CAN4TXDSR7_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN4TXDSR7_DB0:    equ    %00000001
mCAN4TXDSR7_DB1:    equ    %00000010
mCAN4TXDSR7_DB2:    equ    %00000100
mCAN4TXDSR7_DB3:    equ    %00001000
mCAN4TXDSR7_DB4:    equ    %00010000
mCAN4TXDSR7_DB5:    equ    %00100000
mCAN4TXDSR7_DB6:    equ    %01000000
mCAN4TXDSR7_DB7:    equ    %10000000


;*** CAN4TXDLR - MSCAN4 Transmit Data Length Register; 0x000002BC ***
CAN4TXDLR:          equ    $000002BC                                ;*** CAN4TXDLR - MSCAN4 Transmit Data Length Register; 0x000002BC ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN4TXDLR_DLC0:     equ    0                                         ; Data Length Code Bit 0
CAN4TXDLR_DLC1:     equ    1                                         ; Data Length Code Bit 1
CAN4TXDLR_DLC2:     equ    2                                         ; Data Length Code Bit 2
CAN4TXDLR_DLC3:     equ    3                                         ; Data Length Code Bit 3
; bit position masks
mCAN4TXDLR_DLC0:    equ    %00000001
mCAN4TXDLR_DLC1:    equ    %00000010
mCAN4TXDLR_DLC2:    equ    %00000100
mCAN4TXDLR_DLC3:    equ    %00001000


;*** CAN4TXTBPR - MSCAN4 Transmit Transmit Buffer Priority; 0x000002BD ***
CAN4TXTBPR:         equ    $000002BD                                ;*** CAN4TXTBPR - MSCAN4 Transmit Transmit Buffer Priority; 0x000002BD ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN4TXTBPR_PRIO0:   equ    0                                         ; Transmit Buffer Priority Bit 0
CAN4TXTBPR_PRIO1:   equ    1                                         ; Transmit Buffer Priority Bit 1
CAN4TXTBPR_PRIO2:   equ    2                                         ; Transmit Buffer Priority Bit 2
CAN4TXTBPR_PRIO3:   equ    3                                         ; Transmit Buffer Priority Bit 3
CAN4TXTBPR_PRIO4:   equ    4                                         ; Transmit Buffer Priority Bit 4
CAN4TXTBPR_PRIO5:   equ    5                                         ; Transmit Buffer Priority Bit 5
CAN4TXTBPR_PRIO6:   equ    6                                         ; Transmit Buffer Priority Bit 6
CAN4TXTBPR_PRIO7:   equ    7                                         ; Transmit Buffer Priority Bit 7
; bit position masks
mCAN4TXTBPR_PRIO0:  equ    %00000001
mCAN4TXTBPR_PRIO1:  equ    %00000010
mCAN4TXTBPR_PRIO2:  equ    %00000100
mCAN4TXTBPR_PRIO3:  equ    %00001000
mCAN4TXTBPR_PRIO4:  equ    %00010000
mCAN4TXTBPR_PRIO5:  equ    %00100000
mCAN4TXTBPR_PRIO6:  equ    %01000000
mCAN4TXTBPR_PRIO7:  equ    %10000000


;*** CAN4TXTSR - MSCAN 4 Transmit Time Stamp Register; 0x000002BE ***
CAN4TXTSR:          equ    $000002BE                                ;*** CAN4TXTSR - MSCAN 4 Transmit Time Stamp Register; 0x000002BE ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN4TXTSR_TSR0:     equ    0                                         ; Time Stamp Bit 0
CAN4TXTSR_TSR1:     equ    1                                         ; Time Stamp Bit 1
CAN4TXTSR_TSR2:     equ    2                                         ; Time Stamp Bit 2
CAN4TXTSR_TSR3:     equ    3                                         ; Time Stamp Bit 3
CAN4TXTSR_TSR4:     equ    4                                         ; Time Stamp Bit 4
CAN4TXTSR_TSR5:     equ    5                                         ; Time Stamp Bit 5
CAN4TXTSR_TSR6:     equ    6                                         ; Time Stamp Bit 6
CAN4TXTSR_TSR7:     equ    7                                         ; Time Stamp Bit 7
CAN4TXTSR_TSR8:     equ    8                                         ; Time Stamp Bit 8
CAN4TXTSR_TSR9:     equ    9                                         ; Time Stamp Bit 9
CAN4TXTSR_TSR10:    equ    10                                        ; Time Stamp Bit 10
CAN4TXTSR_TSR11:    equ    11                                        ; Time Stamp Bit 11
CAN4TXTSR_TSR12:    equ    12                                        ; Time Stamp Bit 12
CAN4TXTSR_TSR13:    equ    13                                        ; Time Stamp Bit 13
CAN4TXTSR_TSR14:    equ    14                                        ; Time Stamp Bit 14
CAN4TXTSR_TSR15:    equ    15                                        ; Time Stamp Bit 15
; bit position masks
mCAN4TXTSR_TSR0:    equ    %00000001
mCAN4TXTSR_TSR1:    equ    %00000010
mCAN4TXTSR_TSR2:    equ    %00000100
mCAN4TXTSR_TSR3:    equ    %00001000
mCAN4TXTSR_TSR4:    equ    %00010000
mCAN4TXTSR_TSR5:    equ    %00100000
mCAN4TXTSR_TSR6:    equ    %01000000
mCAN4TXTSR_TSR7:    equ    %10000000
mCAN4TXTSR_TSR8:    equ    %100000000
mCAN4TXTSR_TSR9:    equ    %1000000000
mCAN4TXTSR_TSR10:   equ    %10000000000
mCAN4TXTSR_TSR11:   equ    %100000000000
mCAN4TXTSR_TSR12:   equ    %1000000000000
mCAN4TXTSR_TSR13:   equ    %10000000000000
mCAN4TXTSR_TSR14:   equ    %100000000000000
mCAN4TXTSR_TSR15:   equ    %1000000000000000


;*** CAN4TXTSRH - MSCAN 4 Transmit Time Stamp Register High; 0x000002BE ***
CAN4TXTSRH:         equ    $000002BE                                ;*** CAN4TXTSRH - MSCAN 4 Transmit Time Stamp Register High; 0x000002BE ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN4TXTSRH_TSR8:    equ    0                                         ; Time Stamp Bit 8
CAN4TXTSRH_TSR9:    equ    1                                         ; Time Stamp Bit 9
CAN4TXTSRH_TSR10:   equ    2                                         ; Time Stamp Bit 10
CAN4TXTSRH_TSR11:   equ    3                                         ; Time Stamp Bit 11
CAN4TXTSRH_TSR12:   equ    4                                         ; Time Stamp Bit 12
CAN4TXTSRH_TSR13:   equ    5                                         ; Time Stamp Bit 13
CAN4TXTSRH_TSR14:   equ    6                                         ; Time Stamp Bit 14
CAN4TXTSRH_TSR15:   equ    7                                         ; Time Stamp Bit 15
; bit position masks
mCAN4TXTSRH_TSR8:   equ    %00000001
mCAN4TXTSRH_TSR9:   equ    %00000010
mCAN4TXTSRH_TSR10:  equ    %00000100
mCAN4TXTSRH_TSR11:  equ    %00001000
mCAN4TXTSRH_TSR12:  equ    %00010000
mCAN4TXTSRH_TSR13:  equ    %00100000
mCAN4TXTSRH_TSR14:  equ    %01000000
mCAN4TXTSRH_TSR15:  equ    %10000000


;*** CAN4TXTSRL - MSCAN 4 Transmit Time Stamp Register Low; 0x000002BF ***
CAN4TXTSRL:         equ    $000002BF                                ;*** CAN4TXTSRL - MSCAN 4 Transmit Time Stamp Register Low; 0x000002BF ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN4TXTSRL_TSR0:    equ    0                                         ; Time Stamp Bit 0
CAN4TXTSRL_TSR1:    equ    1                                         ; Time Stamp Bit 1
CAN4TXTSRL_TSR2:    equ    2                                         ; Time Stamp Bit 2
CAN4TXTSRL_TSR3:    equ    3                                         ; Time Stamp Bit 3
CAN4TXTSRL_TSR4:    equ    4                                         ; Time Stamp Bit 4
CAN4TXTSRL_TSR5:    equ    5                                         ; Time Stamp Bit 5
CAN4TXTSRL_TSR6:    equ    6                                         ; Time Stamp Bit 6
CAN4TXTSRL_TSR7:    equ    7                                         ; Time Stamp Bit 7
; bit position masks
mCAN4TXTSRL_TSR0:   equ    %00000001
mCAN4TXTSRL_TSR1:   equ    %00000010
mCAN4TXTSRL_TSR2:   equ    %00000100
mCAN4TXTSRL_TSR3:   equ    %00001000
mCAN4TXTSRL_TSR4:   equ    %00010000
mCAN4TXTSRL_TSR5:   equ    %00100000
mCAN4TXTSRL_TSR6:   equ    %01000000
mCAN4TXTSRL_TSR7:   equ    %10000000


;*** PWME - PWM Enable Register; 0x000002C0 ***
PWME:               equ    $000002C0                                ;*** PWME - PWM Enable Register; 0x000002C0 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PWME_PWME0:         equ    0                                         ; Pulse Width Channel 0 Enable
PWME_PWME1:         equ    1                                         ; Pulse Width Channel 1 Enable
PWME_PWME2:         equ    2                                         ; Pulse Width Channel 2 Enable
PWME_PWME3:         equ    3                                         ; Pulse Width Channel 3 Enable
PWME_PWME4:         equ    4                                         ; Pulse Width Channel 4 Enable
PWME_PWME5:         equ    5                                         ; Pulse Width Channel 5 Enable
PWME_PWME6:         equ    6                                         ; Pulse Width Channel 6 Enable
PWME_PWME7:         equ    7                                         ; Pulse Width Channel 7 Enable
; bit position masks
mPWME_PWME0:        equ    %00000001
mPWME_PWME1:        equ    %00000010
mPWME_PWME2:        equ    %00000100
mPWME_PWME3:        equ    %00001000
mPWME_PWME4:        equ    %00010000
mPWME_PWME5:        equ    %00100000
mPWME_PWME6:        equ    %01000000
mPWME_PWME7:        equ    %10000000


;*** PWMPOL - PWM Polarity Register; 0x000002C1 ***
PWMPOL:             equ    $000002C1                                ;*** PWMPOL - PWM Polarity Register; 0x000002C1 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PWMPOL_PPOL0:       equ    0                                         ; Pulse Width Channel 0 Polarity
PWMPOL_PPOL1:       equ    1                                         ; Pulse Width Channel 1 Polarity
PWMPOL_PPOL2:       equ    2                                         ; Pulse Width Channel 2 Polarity
PWMPOL_PPOL3:       equ    3                                         ; Pulse Width Channel 3 Polarity
PWMPOL_PPOL4:       equ    4                                         ; Pulse Width Channel 4 Polarity
PWMPOL_PPOL5:       equ    5                                         ; Pulse Width Channel 5 Polarity
PWMPOL_PPOL6:       equ    6                                         ; Pulse Width Channel 6 Polarity
PWMPOL_PPOL7:       equ    7                                         ; Pulse Width Channel 7 Polarity
; bit position masks
mPWMPOL_PPOL0:      equ    %00000001
mPWMPOL_PPOL1:      equ    %00000010
mPWMPOL_PPOL2:      equ    %00000100
mPWMPOL_PPOL3:      equ    %00001000
mPWMPOL_PPOL4:      equ    %00010000
mPWMPOL_PPOL5:      equ    %00100000
mPWMPOL_PPOL6:      equ    %01000000
mPWMPOL_PPOL7:      equ    %10000000


;*** PWMCLK - PWM Clock Select Register; 0x000002C2 ***
PWMCLK:             equ    $000002C2                                ;*** PWMCLK - PWM Clock Select Register; 0x000002C2 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PWMCLK_PCLK0:       equ    0                                         ; Pulse Width Channel 0 Clock Select
PWMCLK_PCLK1:       equ    1                                         ; Pulse Width Channel 1 Clock Select
PWMCLK_PCLK2:       equ    2                                         ; Pulse Width Channel 2 Clock Select
PWMCLK_PCLK3:       equ    3                                         ; Pulse Width Channel 3 Clock Select
PWMCLK_PCLK4:       equ    4                                         ; Pulse Width Channel 4 Clock Select
PWMCLK_PCLK5:       equ    5                                         ; Pulse Width Channel 5 Clock Select
PWMCLK_PCLK6:       equ    6                                         ; Pulse Width Channel 6 Clock Select
PWMCLK_PCLK7:       equ    7                                         ; Pulse Width Channel 7 Clock Select
; bit position masks
mPWMCLK_PCLK0:      equ    %00000001
mPWMCLK_PCLK1:      equ    %00000010
mPWMCLK_PCLK2:      equ    %00000100
mPWMCLK_PCLK3:      equ    %00001000
mPWMCLK_PCLK4:      equ    %00010000
mPWMCLK_PCLK5:      equ    %00100000
mPWMCLK_PCLK6:      equ    %01000000
mPWMCLK_PCLK7:      equ    %10000000


;*** PWMPRCLK - PWM Prescale Clock Select Register; 0x000002C3 ***
PWMPRCLK:           equ    $000002C3                                ;*** PWMPRCLK - PWM Prescale Clock Select Register; 0x000002C3 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PWMPRCLK_PCKA0:     equ    0                                         ; Prescaler Select for Clock A 0
PWMPRCLK_PCKA1:     equ    1                                         ; Prescaler Select for Clock A 1
PWMPRCLK_PCKA2:     equ    2                                         ; Prescaler Select for Clock A 2
PWMPRCLK_PCKB0:     equ    4                                         ; Prescaler Select for Clock B 0
PWMPRCLK_PCKB1:     equ    5                                         ; Prescaler Select for Clock B 1
PWMPRCLK_PCKB2:     equ    6                                         ; Prescaler Select for Clock B 2
; bit position masks
mPWMPRCLK_PCKA0:    equ    %00000001
mPWMPRCLK_PCKA1:    equ    %00000010
mPWMPRCLK_PCKA2:    equ    %00000100
mPWMPRCLK_PCKB0:    equ    %00010000
mPWMPRCLK_PCKB1:    equ    %00100000
mPWMPRCLK_PCKB2:    equ    %01000000


;*** PWMCAE - PWM Center Align Enable Register; 0x000002C4 ***
PWMCAE:             equ    $000002C4                                ;*** PWMCAE - PWM Center Align Enable Register; 0x000002C4 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PWMCAE_CAE0:        equ    0                                         ; Center Aligned Output Mode on channel 0
PWMCAE_CAE1:        equ    1                                         ; Center Aligned Output Mode on channel 1
PWMCAE_CAE2:        equ    2                                         ; Center Aligned Output Mode on channel 2
PWMCAE_CAE3:        equ    3                                         ; Center Aligned Output Mode on channel 3
PWMCAE_CAE4:        equ    4                                         ; Center Aligned Output Mode on channel 4
PWMCAE_CAE5:        equ    5                                         ; Center Aligned Output Mode on channel 5
PWMCAE_CAE6:        equ    6                                         ; Center Aligned Output Mode on channel 6
PWMCAE_CAE7:        equ    7                                         ; Center Aligned Output Mode on channel 7
; bit position masks
mPWMCAE_CAE0:       equ    %00000001
mPWMCAE_CAE1:       equ    %00000010
mPWMCAE_CAE2:       equ    %00000100
mPWMCAE_CAE3:       equ    %00001000
mPWMCAE_CAE4:       equ    %00010000
mPWMCAE_CAE5:       equ    %00100000
mPWMCAE_CAE6:       equ    %01000000
mPWMCAE_CAE7:       equ    %10000000


;*** PWMCTL - PWM Control Register; 0x000002C5 ***
PWMCTL:             equ    $000002C5                                ;*** PWMCTL - PWM Control Register; 0x000002C5 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PWMCTL_PFRZ:        equ    2                                         ; PWM Counters Stop in Freeze Mode
PWMCTL_PSWAI:       equ    3                                         ; PWM Stops in Wait Mode
PWMCTL_CON01:       equ    4                                         ; Concatenate channels 0 and 1
PWMCTL_CON23:       equ    5                                         ; Concatenate channels 2 and 3
PWMCTL_CON45:       equ    6                                         ; Concatenate channels 4 and 5
PWMCTL_CON67:       equ    7                                         ; Concatenate channels 6 and 7
; bit position masks
mPWMCTL_PFRZ:       equ    %00000100
mPWMCTL_PSWAI:      equ    %00001000
mPWMCTL_CON01:      equ    %00010000
mPWMCTL_CON23:      equ    %00100000
mPWMCTL_CON45:      equ    %01000000
mPWMCTL_CON67:      equ    %10000000


;*** PWMSCLA - PWM Scale A Register; 0x000002C8 ***
PWMSCLA:            equ    $000002C8                                ;*** PWMSCLA - PWM Scale A Register; 0x000002C8 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PWMSCLA_BIT0:       equ    0                                         ; PWM Scale A Bit 0
PWMSCLA_BIT1:       equ    1                                         ; PWM Scale A Bit 1
PWMSCLA_BIT2:       equ    2                                         ; PWM Scale A Bit 2
PWMSCLA_BIT3:       equ    3                                         ; PWM Scale A Bit 3
PWMSCLA_BIT4:       equ    4                                         ; PWM Scale A Bit 4
PWMSCLA_BIT5:       equ    5                                         ; PWM Scale A Bit 5
PWMSCLA_BIT6:       equ    6                                         ; PWM Scale A Bit 6
PWMSCLA_BIT7:       equ    7                                         ; PWM Scale A Bit 7
; bit position masks
mPWMSCLA_BIT0:      equ    %00000001
mPWMSCLA_BIT1:      equ    %00000010
mPWMSCLA_BIT2:      equ    %00000100
mPWMSCLA_BIT3:      equ    %00001000
mPWMSCLA_BIT4:      equ    %00010000
mPWMSCLA_BIT5:      equ    %00100000
mPWMSCLA_BIT6:      equ    %01000000
mPWMSCLA_BIT7:      equ    %10000000


;*** PWMSCLB - PWM Scale B Register; 0x000002C9 ***
PWMSCLB:            equ    $000002C9                                ;*** PWMSCLB - PWM Scale B Register; 0x000002C9 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PWMSCLB_BIT0:       equ    0                                         ; PWM Scale B Bit 0
PWMSCLB_BIT1:       equ    1                                         ; PWM Scale B Bit 1
PWMSCLB_BIT2:       equ    2                                         ; PWM Scale B Bit 2
PWMSCLB_BIT3:       equ    3                                         ; PWM Scale B Bit 3
PWMSCLB_BIT4:       equ    4                                         ; PWM Scale B Bit 4
PWMSCLB_BIT5:       equ    5                                         ; PWM Scale B Bit 5
PWMSCLB_BIT6:       equ    6                                         ; PWM Scale B Bit 6
PWMSCLB_BIT7:       equ    7                                         ; PWM Scale B Bit 7
; bit position masks
mPWMSCLB_BIT0:      equ    %00000001
mPWMSCLB_BIT1:      equ    %00000010
mPWMSCLB_BIT2:      equ    %00000100
mPWMSCLB_BIT3:      equ    %00001000
mPWMSCLB_BIT4:      equ    %00010000
mPWMSCLB_BIT5:      equ    %00100000
mPWMSCLB_BIT6:      equ    %01000000
mPWMSCLB_BIT7:      equ    %10000000


;*** PWMCNT01 - PWM Channel Counter 01 Register; 0x000002CC ***
PWMCNT01:           equ    $000002CC                                ;*** PWMCNT01 - PWM Channel Counter 01 Register; 0x000002CC ***


;*** PWMCNT0 - PWM Channel Counter 0 Register; 0x000002CC ***
PWMCNT0:            equ    $000002CC                                ;*** PWMCNT0 - PWM Channel Counter 0 Register; 0x000002CC ***


;*** PWMCNT1 - PWM Channel Counter 1 Register; 0x000002CD ***
PWMCNT1:            equ    $000002CD                                ;*** PWMCNT1 - PWM Channel Counter 1 Register; 0x000002CD ***


;*** PWMCNT23 - PWM Channel Counter 23 Register; 0x000002CE ***
PWMCNT23:           equ    $000002CE                                ;*** PWMCNT23 - PWM Channel Counter 23 Register; 0x000002CE ***


;*** PWMCNT2 - PWM Channel Counter 2 Register; 0x000002CE ***
PWMCNT2:            equ    $000002CE                                ;*** PWMCNT2 - PWM Channel Counter 2 Register; 0x000002CE ***


;*** PWMCNT3 - PWM Channel Counter 3 Register; 0x000002CF ***
PWMCNT3:            equ    $000002CF                                ;*** PWMCNT3 - PWM Channel Counter 3 Register; 0x000002CF ***


;*** PWMCNT45 - PWM Channel Counter 45 Register; 0x000002D0 ***
PWMCNT45:           equ    $000002D0                                ;*** PWMCNT45 - PWM Channel Counter 45 Register; 0x000002D0 ***


;*** PWMCNT4 - PWM Channel Counter 4 Register; 0x000002D0 ***
PWMCNT4:            equ    $000002D0                                ;*** PWMCNT4 - PWM Channel Counter 4 Register; 0x000002D0 ***


;*** PWMCNT5 - PWM Channel Counter 5 Register; 0x000002D1 ***
PWMCNT5:            equ    $000002D1                                ;*** PWMCNT5 - PWM Channel Counter 5 Register; 0x000002D1 ***


;*** PWMCNT67 - PWM Channel Counter 67 Register; 0x000002D2 ***
PWMCNT67:           equ    $000002D2                                ;*** PWMCNT67 - PWM Channel Counter 67 Register; 0x000002D2 ***


;*** PWMCNT6 - PWM Channel Counter 6 Register; 0x000002D2 ***
PWMCNT6:            equ    $000002D2                                ;*** PWMCNT6 - PWM Channel Counter 6 Register; 0x000002D2 ***


;*** PWMCNT7 - PWM Channel Counter 7 Register; 0x000002D3 ***
PWMCNT7:            equ    $000002D3                                ;*** PWMCNT7 - PWM Channel Counter 7 Register; 0x000002D3 ***


;*** PWMPER01 - PWM Channel Period 01 Register; 0x000002D4 ***
PWMPER01:           equ    $000002D4                                ;*** PWMPER01 - PWM Channel Period 01 Register; 0x000002D4 ***


;*** PWMPER0 - PWM Channel Period 0 Register; 0x000002D4 ***
PWMPER0:            equ    $000002D4                                ;*** PWMPER0 - PWM Channel Period 0 Register; 0x000002D4 ***


;*** PWMPER1 - PWM Channel Period 1 Register; 0x000002D5 ***
PWMPER1:            equ    $000002D5                                ;*** PWMPER1 - PWM Channel Period 1 Register; 0x000002D5 ***


;*** PWMPER23 - PWM Channel Period 23 Register; 0x000002D6 ***
PWMPER23:           equ    $000002D6                                ;*** PWMPER23 - PWM Channel Period 23 Register; 0x000002D6 ***


;*** PWMPER2 - PWM Channel Period 2 Register; 0x000002D6 ***
PWMPER2:            equ    $000002D6                                ;*** PWMPER2 - PWM Channel Period 2 Register; 0x000002D6 ***


;*** PWMPER3 - PWM Channel Period 3 Register; 0x000002D7 ***
PWMPER3:            equ    $000002D7                                ;*** PWMPER3 - PWM Channel Period 3 Register; 0x000002D7 ***


;*** PWMPER45 - PWM Channel Period 45 Register; 0x000002D8 ***
PWMPER45:           equ    $000002D8                                ;*** PWMPER45 - PWM Channel Period 45 Register; 0x000002D8 ***


;*** PWMPER4 - PWM Channel Period 4 Register; 0x000002D8 ***
PWMPER4:            equ    $000002D8                                ;*** PWMPER4 - PWM Channel Period 4 Register; 0x000002D8 ***


;*** PWMPER5 - PWM Channel Period 5 Register; 0x000002D9 ***
PWMPER5:            equ    $000002D9                                ;*** PWMPER5 - PWM Channel Period 5 Register; 0x000002D9 ***


;*** PWMPER67 - PWM Channel Period 67 Register; 0x000002DA ***
PWMPER67:           equ    $000002DA                                ;*** PWMPER67 - PWM Channel Period 67 Register; 0x000002DA ***


;*** PWMPER6 - PWM Channel Period 6 Register; 0x000002DA ***
PWMPER6:            equ    $000002DA                                ;*** PWMPER6 - PWM Channel Period 6 Register; 0x000002DA ***


;*** PWMPER7 - PWM Channel Period 7 Register; 0x000002DB ***
PWMPER7:            equ    $000002DB                                ;*** PWMPER7 - PWM Channel Period 7 Register; 0x000002DB ***


;*** PWMDTY01 - PWM Channel Duty 01 Register; 0x000002DC ***
PWMDTY01:           equ    $000002DC                                ;*** PWMDTY01 - PWM Channel Duty 01 Register; 0x000002DC ***


;*** PWMDTY0 - PWM Channel Duty 0 Register; 0x000002DC ***
PWMDTY0:            equ    $000002DC                                ;*** PWMDTY0 - PWM Channel Duty 0 Register; 0x000002DC ***


;*** PWMDTY1 - PWM Channel Duty 1 Register; 0x000002DD ***
PWMDTY1:            equ    $000002DD                                ;*** PWMDTY1 - PWM Channel Duty 1 Register; 0x000002DD ***


;*** PWMDTY23 - PWM Channel Duty 23 Register; 0x000002DE ***
PWMDTY23:           equ    $000002DE                                ;*** PWMDTY23 - PWM Channel Duty 23 Register; 0x000002DE ***


;*** PWMDTY2 - PWM Channel Duty 2 Register; 0x000002DE ***
PWMDTY2:            equ    $000002DE                                ;*** PWMDTY2 - PWM Channel Duty 2 Register; 0x000002DE ***


;*** PWMDTY3 - PWM Channel Duty 3 Register; 0x000002DF ***
PWMDTY3:            equ    $000002DF                                ;*** PWMDTY3 - PWM Channel Duty 3 Register; 0x000002DF ***


;*** PWMDTY45 - PWM Channel Duty 45 Register; 0x000002E0 ***
PWMDTY45:           equ    $000002E0                                ;*** PWMDTY45 - PWM Channel Duty 45 Register; 0x000002E0 ***


;*** PWMDTY4 - PWM Channel Duty 4 Register; 0x000002E0 ***
PWMDTY4:            equ    $000002E0                                ;*** PWMDTY4 - PWM Channel Duty 4 Register; 0x000002E0 ***


;*** PWMDTY5 - PWM Channel Duty 5 Register; 0x000002E1 ***
PWMDTY5:            equ    $000002E1                                ;*** PWMDTY5 - PWM Channel Duty 5 Register; 0x000002E1 ***


;*** PWMDTY67 - PWM Channel Duty 67 Register; 0x000002E2 ***
PWMDTY67:           equ    $000002E2                                ;*** PWMDTY67 - PWM Channel Duty 67 Register; 0x000002E2 ***


;*** PWMDTY6 - PWM Channel Duty 6 Register; 0x000002E2 ***
PWMDTY6:            equ    $000002E2                                ;*** PWMDTY6 - PWM Channel Duty 6 Register; 0x000002E2 ***


;*** PWMDTY7 - PWM Channel Duty 7 Register; 0x000002E3 ***
PWMDTY7:            equ    $000002E3                                ;*** PWMDTY7 - PWM Channel Duty 7 Register; 0x000002E3 ***


;*** PWMSDN - PWM Shutdown Register; 0x000002E4 ***
PWMSDN:             equ    $000002E4                                ;*** PWMSDN - PWM Shutdown Register; 0x000002E4 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PWMSDN_PWM7ENA:     equ    0                                         ; PWM emergency shutdown Enable
PWMSDN_PWM7INL:     equ    1                                         ; PWM shutdown active input level for ch. 7
PWMSDN_PWM7IN:      equ    2                                         ; PWM channel 7 input status
PWMSDN_PWMLVL:      equ    4                                         ; PWM shutdown output Level
PWMSDN_PWMRSTRT:    equ    5                                         ; PWM Restart
PWMSDN_PWMIE:       equ    6                                         ; PWM Interrupt Enable
PWMSDN_PWMIF:       equ    7                                         ; PWM Interrupt Flag
; bit position masks
mPWMSDN_PWM7ENA:    equ    %00000001
mPWMSDN_PWM7INL:    equ    %00000010
mPWMSDN_PWM7IN:     equ    %00000100
mPWMSDN_PWMLVL:     equ    %00010000
mPWMSDN_PWMRSTRT:   equ    %00100000
mPWMSDN_PWMIE:      equ    %01000000
mPWMSDN_PWMIF:      equ    %10000000


;*** BAKEY0 - Backdoor Access Key 0; 0x0000FF00 ***
BAKEY0:             equ    $0000FF00                                ;*** BAKEY0 - Backdoor Access Key 0; 0x0000FF00 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
BAKEY0_KEY0:        equ    0                                         ; Backdoor Access Key bits, bit 0
BAKEY0_KEY1:        equ    1                                         ; Backdoor Access Key bits, bit 1
BAKEY0_KEY2:        equ    2                                         ; Backdoor Access Key bits, bit 2
BAKEY0_KEY3:        equ    3                                         ; Backdoor Access Key bits, bit 3
BAKEY0_KEY4:        equ    4                                         ; Backdoor Access Key bits, bit 4
BAKEY0_KEY5:        equ    5                                         ; Backdoor Access Key bits, bit 5
BAKEY0_KEY6:        equ    6                                         ; Backdoor Access Key bits, bit 6
BAKEY0_KEY7:        equ    7                                         ; Backdoor Access Key bits, bit 7
BAKEY0_KEY8:        equ    8                                         ; Backdoor Access Key bits, bit 8
BAKEY0_KEY9:        equ    9                                         ; Backdoor Access Key bits, bit 9
BAKEY0_KEY10:       equ    10                                        ; Backdoor Access Key bits, bit 10
BAKEY0_KEY11:       equ    11                                        ; Backdoor Access Key bits, bit 11
BAKEY0_KEY12:       equ    12                                        ; Backdoor Access Key bits, bit 12
BAKEY0_KEY13:       equ    13                                        ; Backdoor Access Key bits, bit 13
BAKEY0_KEY14:       equ    14                                        ; Backdoor Access Key bits, bit 14
BAKEY0_KEY15:       equ    15                                        ; Backdoor Access Key bits, bit 15
; bit position masks
mBAKEY0_KEY0:       equ    %00000001
mBAKEY0_KEY1:       equ    %00000010
mBAKEY0_KEY2:       equ    %00000100
mBAKEY0_KEY3:       equ    %00001000
mBAKEY0_KEY4:       equ    %00010000
mBAKEY0_KEY5:       equ    %00100000
mBAKEY0_KEY6:       equ    %01000000
mBAKEY0_KEY7:       equ    %10000000
mBAKEY0_KEY8:       equ    %100000000
mBAKEY0_KEY9:       equ    %1000000000
mBAKEY0_KEY10:      equ    %10000000000
mBAKEY0_KEY11:      equ    %100000000000
mBAKEY0_KEY12:      equ    %1000000000000
mBAKEY0_KEY13:      equ    %10000000000000
mBAKEY0_KEY14:      equ    %100000000000000
mBAKEY0_KEY15:      equ    %1000000000000000


;*** BAKEY1 - Backdoor Access Key 1; 0x0000FF02 ***
BAKEY1:             equ    $0000FF02                                ;*** BAKEY1 - Backdoor Access Key 1; 0x0000FF02 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
BAKEY1_KEY0:        equ    0                                         ; Backdoor Access Key bits, bit 0
BAKEY1_KEY1:        equ    1                                         ; Backdoor Access Key bits, bit 1
BAKEY1_KEY2:        equ    2                                         ; Backdoor Access Key bits, bit 2
BAKEY1_KEY3:        equ    3                                         ; Backdoor Access Key bits, bit 3
BAKEY1_KEY4:        equ    4                                         ; Backdoor Access Key bits, bit 4
BAKEY1_KEY5:        equ    5                                         ; Backdoor Access Key bits, bit 5
BAKEY1_KEY6:        equ    6                                         ; Backdoor Access Key bits, bit 6
BAKEY1_KEY7:        equ    7                                         ; Backdoor Access Key bits, bit 7
BAKEY1_KEY8:        equ    8                                         ; Backdoor Access Key bits, bit 8
BAKEY1_KEY9:        equ    9                                         ; Backdoor Access Key bits, bit 9
BAKEY1_KEY10:       equ    10                                        ; Backdoor Access Key bits, bit 10
BAKEY1_KEY11:       equ    11                                        ; Backdoor Access Key bits, bit 11
BAKEY1_KEY12:       equ    12                                        ; Backdoor Access Key bits, bit 12
BAKEY1_KEY13:       equ    13                                        ; Backdoor Access Key bits, bit 13
BAKEY1_KEY14:       equ    14                                        ; Backdoor Access Key bits, bit 14
BAKEY1_KEY15:       equ    15                                        ; Backdoor Access Key bits, bit 15
; bit position masks
mBAKEY1_KEY0:       equ    %00000001
mBAKEY1_KEY1:       equ    %00000010
mBAKEY1_KEY2:       equ    %00000100
mBAKEY1_KEY3:       equ    %00001000
mBAKEY1_KEY4:       equ    %00010000
mBAKEY1_KEY5:       equ    %00100000
mBAKEY1_KEY6:       equ    %01000000
mBAKEY1_KEY7:       equ    %10000000
mBAKEY1_KEY8:       equ    %100000000
mBAKEY1_KEY9:       equ    %1000000000
mBAKEY1_KEY10:      equ    %10000000000
mBAKEY1_KEY11:      equ    %100000000000
mBAKEY1_KEY12:      equ    %1000000000000
mBAKEY1_KEY13:      equ    %10000000000000
mBAKEY1_KEY14:      equ    %100000000000000
mBAKEY1_KEY15:      equ    %1000000000000000


;*** BAKEY2 - Backdoor Access Key 2; 0x0000FF04 ***
BAKEY2:             equ    $0000FF04                                ;*** BAKEY2 - Backdoor Access Key 2; 0x0000FF04 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
BAKEY2_KEY0:        equ    0                                         ; Backdoor Access Key bits, bit 0
BAKEY2_KEY1:        equ    1                                         ; Backdoor Access Key bits, bit 1
BAKEY2_KEY2:        equ    2                                         ; Backdoor Access Key bits, bit 2
BAKEY2_KEY3:        equ    3                                         ; Backdoor Access Key bits, bit 3
BAKEY2_KEY4:        equ    4                                         ; Backdoor Access Key bits, bit 4
BAKEY2_KEY5:        equ    5                                         ; Backdoor Access Key bits, bit 5
BAKEY2_KEY6:        equ    6                                         ; Backdoor Access Key bits, bit 6
BAKEY2_KEY7:        equ    7                                         ; Backdoor Access Key bits, bit 7
BAKEY2_KEY8:        equ    8                                         ; Backdoor Access Key bits, bit 8
BAKEY2_KEY9:        equ    9                                         ; Backdoor Access Key bits, bit 9
BAKEY2_KEY10:       equ    10                                        ; Backdoor Access Key bits, bit 10
BAKEY2_KEY11:       equ    11                                        ; Backdoor Access Key bits, bit 11
BAKEY2_KEY12:       equ    12                                        ; Backdoor Access Key bits, bit 12
BAKEY2_KEY13:       equ    13                                        ; Backdoor Access Key bits, bit 13
BAKEY2_KEY14:       equ    14                                        ; Backdoor Access Key bits, bit 14
BAKEY2_KEY15:       equ    15                                        ; Backdoor Access Key bits, bit 15
; bit position masks
mBAKEY2_KEY0:       equ    %00000001
mBAKEY2_KEY1:       equ    %00000010
mBAKEY2_KEY2:       equ    %00000100
mBAKEY2_KEY3:       equ    %00001000
mBAKEY2_KEY4:       equ    %00010000
mBAKEY2_KEY5:       equ    %00100000
mBAKEY2_KEY6:       equ    %01000000
mBAKEY2_KEY7:       equ    %10000000
mBAKEY2_KEY8:       equ    %100000000
mBAKEY2_KEY9:       equ    %1000000000
mBAKEY2_KEY10:      equ    %10000000000
mBAKEY2_KEY11:      equ    %100000000000
mBAKEY2_KEY12:      equ    %1000000000000
mBAKEY2_KEY13:      equ    %10000000000000
mBAKEY2_KEY14:      equ    %100000000000000
mBAKEY2_KEY15:      equ    %1000000000000000


;*** BAKEY3 - Backdoor Access Key 3; 0x0000FF06 ***
BAKEY3:             equ    $0000FF06                                ;*** BAKEY3 - Backdoor Access Key 3; 0x0000FF06 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
BAKEY3_KEY0:        equ    0                                         ; Backdoor Access Key bits, bit 0
BAKEY3_KEY1:        equ    1                                         ; Backdoor Access Key bits, bit 1
BAKEY3_KEY2:        equ    2                                         ; Backdoor Access Key bits, bit 2
BAKEY3_KEY3:        equ    3                                         ; Backdoor Access Key bits, bit 3
BAKEY3_KEY4:        equ    4                                         ; Backdoor Access Key bits, bit 4
BAKEY3_KEY5:        equ    5                                         ; Backdoor Access Key bits, bit 5
BAKEY3_KEY6:        equ    6                                         ; Backdoor Access Key bits, bit 6
BAKEY3_KEY7:        equ    7                                         ; Backdoor Access Key bits, bit 7
BAKEY3_KEY8:        equ    8                                         ; Backdoor Access Key bits, bit 8
BAKEY3_KEY9:        equ    9                                         ; Backdoor Access Key bits, bit 9
BAKEY3_KEY10:       equ    10                                        ; Backdoor Access Key bits, bit 10
BAKEY3_KEY11:       equ    11                                        ; Backdoor Access Key bits, bit 11
BAKEY3_KEY12:       equ    12                                        ; Backdoor Access Key bits, bit 12
BAKEY3_KEY13:       equ    13                                        ; Backdoor Access Key bits, bit 13
BAKEY3_KEY14:       equ    14                                        ; Backdoor Access Key bits, bit 14
BAKEY3_KEY15:       equ    15                                        ; Backdoor Access Key bits, bit 15
; bit position masks
mBAKEY3_KEY0:       equ    %00000001
mBAKEY3_KEY1:       equ    %00000010
mBAKEY3_KEY2:       equ    %00000100
mBAKEY3_KEY3:       equ    %00001000
mBAKEY3_KEY4:       equ    %00010000
mBAKEY3_KEY5:       equ    %00100000
mBAKEY3_KEY6:       equ    %01000000
mBAKEY3_KEY7:       equ    %10000000
mBAKEY3_KEY8:       equ    %100000000
mBAKEY3_KEY9:       equ    %1000000000
mBAKEY3_KEY10:      equ    %10000000000
mBAKEY3_KEY11:      equ    %100000000000
mBAKEY3_KEY12:      equ    %1000000000000
mBAKEY3_KEY13:      equ    %10000000000000
mBAKEY3_KEY14:      equ    %100000000000000
mBAKEY3_KEY15:      equ    %1000000000000000


;*** NVFPROT1 - Non volatile Block 1 Flash Protection Register; 0x0000FF0C ***
NVFPROT1:           equ    $0000FF0C                                ;*** NVFPROT1 - Non volatile Block 1 Flash Protection Register; 0x0000FF0C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NVFPROT1_FPLS0:     equ    0                                         ; Flash Protection Lower Address size 0
NVFPROT1_FPLS1:     equ    1                                         ; Flash Protection Lower Address size 1
NVFPROT1_FPLDIS:    equ    2                                         ; Flash Protection Lower address range disable
NVFPROT1_FPHS0:     equ    3                                         ; Flash Protection Higher address size 0
NVFPROT1_FPHS1:     equ    4                                         ; Flash Protection Higher address size 1
NVFPROT1_FPHDIS:    equ    5                                         ; Flash Protection Higher address range disable
NVFPROT1_NV6:       equ    6                                         ; Non Volatile Flag Bit
NVFPROT1_FPOPEN:    equ    7                                         ; Opens the flash block or subsections of it for program or erase
; bit position masks
mNVFPROT1_FPLS0:    equ    %00000001
mNVFPROT1_FPLS1:    equ    %00000010
mNVFPROT1_FPLDIS:   equ    %00000100
mNVFPROT1_FPHS0:    equ    %00001000
mNVFPROT1_FPHS1:    equ    %00010000
mNVFPROT1_FPHDIS:   equ    %00100000
mNVFPROT1_NV6:      equ    %01000000
mNVFPROT1_FPOPEN:   equ    %10000000


;*** NVFPROT0 - Non volatile Block 0 Flash Protection Register; 0x0000FF0D ***
NVFPROT0:           equ    $0000FF0D                                ;*** NVFPROT0 - Non volatile Block 0 Flash Protection Register; 0x0000FF0D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NVFPROT0_FPLS0:     equ    0                                         ; Flash Protection Lower Address size 0
NVFPROT0_FPLS1:     equ    1                                         ; Flash Protection Lower Address size 1
NVFPROT0_FPLDIS:    equ    2                                         ; Flash Protection Lower address range disable
NVFPROT0_FPHS0:     equ    3                                         ; Flash Protection Higher address size 0
NVFPROT0_FPHS1:     equ    4                                         ; Flash Protection Higher address size 1
NVFPROT0_FPHDIS:    equ    5                                         ; Flash Protection Higher address range disable
NVFPROT0_NV6:       equ    6                                         ; Non Volatile Flag Bit
NVFPROT0_FPOPEN:    equ    7                                         ; Opens the flash block or subsections of it for program or erase
; bit position masks
mNVFPROT0_FPLS0:    equ    %00000001
mNVFPROT0_FPLS1:    equ    %00000010
mNVFPROT0_FPLDIS:   equ    %00000100
mNVFPROT0_FPHS0:    equ    %00001000
mNVFPROT0_FPHS1:    equ    %00010000
mNVFPROT0_FPHDIS:   equ    %00100000
mNVFPROT0_NV6:      equ    %01000000
mNVFPROT0_FPOPEN:   equ    %10000000


;*** NVFSEC - Non volatile Flash Security Register; 0x0000FF0F ***
NVFSEC:             equ    $0000FF0F                                ;*** NVFSEC - Non volatile Flash Security Register; 0x0000FF0F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NVFSEC_SEC0:        equ    0                                         ; Memory security bit 0
NVFSEC_SEC1:        equ    1                                         ; Memory security bit 1
NVFSEC_NV2:         equ    2                                         ; Non Volatile flag bit 2
NVFSEC_NV3:         equ    3                                         ; Non Volatile flag bit 3
NVFSEC_NV4:         equ    4                                         ; Non Volatile flag bit 4
NVFSEC_NV5:         equ    5                                         ; Non Volatile flag bit 5
NVFSEC_NV6:         equ    6                                         ; Non Volatile flag bit 6
NVFSEC_KEYEN:       equ    7                                         ; Backdoor Key Security Enable
; bit position masks
mNVFSEC_SEC0:       equ    %00000001
mNVFSEC_SEC1:       equ    %00000010
mNVFSEC_NV2:        equ    %00000100
mNVFSEC_NV3:        equ    %00001000
mNVFSEC_NV4:        equ    %00010000
mNVFSEC_NV5:        equ    %00100000
mNVFSEC_NV6:        equ    %01000000
mNVFSEC_KEYEN:      equ    %10000000



;***********************************************
;**   D E P R E C I A T E D   S Y M B O L S   **
;***********************************************
        IFNDEF  __GENERATE_APPLICATION__                            ; not supported for absolute assembler
                    XREF    This_symb_has_been_depreciated
        ENDIF
; ---------------------------------------------------------------------------
; The following symbols were removed, because they were invalid or irrelevant
; ---------------------------------------------------------------------------
;
; Follows changes from the database 2.87.116 version
        IFNDEF __GENERATE_APPLICATION__
Vcan1wkup                                EQU        This_symb_has_been_depreciated
Vcan1err                                 EQU        This_symb_has_been_depreciated
Vcan1rx                                  EQU        This_symb_has_been_depreciated
Vcan1tx                                  EQU        This_symb_has_been_depreciated
CAN1TXTSRL                               EQU        This_symb_has_been_depreciated
mCAN1TXTSRL_TSR0                         EQU        This_symb_has_been_depreciated
mCAN1TXTSRL_TSR1                         EQU        This_symb_has_been_depreciated
mCAN1TXTSRL_TSR2                         EQU        This_symb_has_been_depreciated
mCAN1TXTSRL_TSR3                         EQU        This_symb_has_been_depreciated
mCAN1TXTSRL_TSR4                         EQU        This_symb_has_been_depreciated
mCAN1TXTSRL_TSR5                         EQU        This_symb_has_been_depreciated
mCAN1TXTSRL_TSR6                         EQU        This_symb_has_been_depreciated
mCAN1TXTSRL_TSR7                         EQU        This_symb_has_been_depreciated
CAN1TXTSR                                EQU        This_symb_has_been_depreciated
mCAN1TXTSR_TSR0                          EQU        This_symb_has_been_depreciated
mCAN1TXTSR_TSR1                          EQU        This_symb_has_been_depreciated
mCAN1TXTSR_TSR2                          EQU        This_symb_has_been_depreciated
mCAN1TXTSR_TSR3                          EQU        This_symb_has_been_depreciated
mCAN1TXTSR_TSR4                          EQU        This_symb_has_been_depreciated
mCAN1TXTSR_TSR5                          EQU        This_symb_has_been_depreciated
mCAN1TXTSR_TSR6                          EQU        This_symb_has_been_depreciated
mCAN1TXTSR_TSR7                          EQU        This_symb_has_been_depreciated
mCAN1TXTSR_TSR8                          EQU        This_symb_has_been_depreciated
mCAN1TXTSR_TSR9                          EQU        This_symb_has_been_depreciated
mCAN1TXTSR_TSR10                         EQU        This_symb_has_been_depreciated
mCAN1TXTSR_TSR11                         EQU        This_symb_has_been_depreciated
mCAN1TXTSR_TSR12                         EQU        This_symb_has_been_depreciated
mCAN1TXTSR_TSR13                         EQU        This_symb_has_been_depreciated
mCAN1TXTSR_TSR14                         EQU        This_symb_has_been_depreciated
mCAN1TXTSR_TSR15                         EQU        This_symb_has_been_depreciated
CAN1TXTSRH                               EQU        This_symb_has_been_depreciated
mCAN1TXTSRH_TSR8                         EQU        This_symb_has_been_depreciated
mCAN1TXTSRH_TSR9                         EQU        This_symb_has_been_depreciated
mCAN1TXTSRH_TSR10                        EQU        This_symb_has_been_depreciated
mCAN1TXTSRH_TSR11                        EQU        This_symb_has_been_depreciated
mCAN1TXTSRH_TSR12                        EQU        This_symb_has_been_depreciated
mCAN1TXTSRH_TSR13                        EQU        This_symb_has_been_depreciated
mCAN1TXTSRH_TSR14                        EQU        This_symb_has_been_depreciated
mCAN1TXTSRH_TSR15                        EQU        This_symb_has_been_depreciated
CAN1TXTBPR                               EQU        This_symb_has_been_depreciated
mCAN1TXTBPR_PRIO0                        EQU        This_symb_has_been_depreciated
mCAN1TXTBPR_PRIO1                        EQU        This_symb_has_been_depreciated
mCAN1TXTBPR_PRIO2                        EQU        This_symb_has_been_depreciated
mCAN1TXTBPR_PRIO3                        EQU        This_symb_has_been_depreciated
mCAN1TXTBPR_PRIO4                        EQU        This_symb_has_been_depreciated
mCAN1TXTBPR_PRIO5                        EQU        This_symb_has_been_depreciated
mCAN1TXTBPR_PRIO6                        EQU        This_symb_has_been_depreciated
mCAN1TXTBPR_PRIO7                        EQU        This_symb_has_been_depreciated
CAN1TXDLR                                EQU        This_symb_has_been_depreciated
mCAN1TXDLR_DLC0                          EQU        This_symb_has_been_depreciated
mCAN1TXDLR_DLC1                          EQU        This_symb_has_been_depreciated
mCAN1TXDLR_DLC2                          EQU        This_symb_has_been_depreciated
mCAN1TXDLR_DLC3                          EQU        This_symb_has_been_depreciated
CAN1TXDSR7                               EQU        This_symb_has_been_depreciated
mCAN1TXDSR7_DB0                          EQU        This_symb_has_been_depreciated
mCAN1TXDSR7_DB1                          EQU        This_symb_has_been_depreciated
mCAN1TXDSR7_DB2                          EQU        This_symb_has_been_depreciated
mCAN1TXDSR7_DB3                          EQU        This_symb_has_been_depreciated
mCAN1TXDSR7_DB4                          EQU        This_symb_has_been_depreciated
mCAN1TXDSR7_DB5                          EQU        This_symb_has_been_depreciated
mCAN1TXDSR7_DB6                          EQU        This_symb_has_been_depreciated
mCAN1TXDSR7_DB7                          EQU        This_symb_has_been_depreciated
CAN1TXDSR6                               EQU        This_symb_has_been_depreciated
mCAN1TXDSR6_DB0                          EQU        This_symb_has_been_depreciated
mCAN1TXDSR6_DB1                          EQU        This_symb_has_been_depreciated
mCAN1TXDSR6_DB2                          EQU        This_symb_has_been_depreciated
mCAN1TXDSR6_DB3                          EQU        This_symb_has_been_depreciated
mCAN1TXDSR6_DB4                          EQU        This_symb_has_been_depreciated
mCAN1TXDSR6_DB5                          EQU        This_symb_has_been_depreciated
mCAN1TXDSR6_DB6                          EQU        This_symb_has_been_depreciated
mCAN1TXDSR6_DB7                          EQU        This_symb_has_been_depreciated
CAN1TXDSR5                               EQU        This_symb_has_been_depreciated
mCAN1TXDSR5_DB0                          EQU        This_symb_has_been_depreciated
mCAN1TXDSR5_DB1                          EQU        This_symb_has_been_depreciated
mCAN1TXDSR5_DB2                          EQU        This_symb_has_been_depreciated
mCAN1TXDSR5_DB3                          EQU        This_symb_has_been_depreciated
mCAN1TXDSR5_DB4                          EQU        This_symb_has_been_depreciated
mCAN1TXDSR5_DB5                          EQU        This_symb_has_been_depreciated
mCAN1TXDSR5_DB6                          EQU        This_symb_has_been_depreciated
mCAN1TXDSR5_DB7                          EQU        This_symb_has_been_depreciated
CAN1TXDSR4                               EQU        This_symb_has_been_depreciated
mCAN1TXDSR4_DB0                          EQU        This_symb_has_been_depreciated
mCAN1TXDSR4_DB1                          EQU        This_symb_has_been_depreciated
mCAN1TXDSR4_DB2                          EQU        This_symb_has_been_depreciated
mCAN1TXDSR4_DB3                          EQU        This_symb_has_been_depreciated
mCAN1TXDSR4_DB4                          EQU        This_symb_has_been_depreciated
mCAN1TXDSR4_DB5                          EQU        This_symb_has_been_depreciated
mCAN1TXDSR4_DB6                          EQU        This_symb_has_been_depreciated
mCAN1TXDSR4_DB7                          EQU        This_symb_has_been_depreciated
CAN1TXDSR3                               EQU        This_symb_has_been_depreciated
mCAN1TXDSR3_DB0                          EQU        This_symb_has_been_depreciated
mCAN1TXDSR3_DB1                          EQU        This_symb_has_been_depreciated
mCAN1TXDSR3_DB2                          EQU        This_symb_has_been_depreciated
mCAN1TXDSR3_DB3                          EQU        This_symb_has_been_depreciated
mCAN1TXDSR3_DB4                          EQU        This_symb_has_been_depreciated
mCAN1TXDSR3_DB5                          EQU        This_symb_has_been_depreciated
mCAN1TXDSR3_DB6                          EQU        This_symb_has_been_depreciated
mCAN1TXDSR3_DB7                          EQU        This_symb_has_been_depreciated
CAN1TXDSR2                               EQU        This_symb_has_been_depreciated
mCAN1TXDSR2_DB0                          EQU        This_symb_has_been_depreciated
mCAN1TXDSR2_DB1                          EQU        This_symb_has_been_depreciated
mCAN1TXDSR2_DB2                          EQU        This_symb_has_been_depreciated
mCAN1TXDSR2_DB3                          EQU        This_symb_has_been_depreciated
mCAN1TXDSR2_DB4                          EQU        This_symb_has_been_depreciated
mCAN1TXDSR2_DB5                          EQU        This_symb_has_been_depreciated
mCAN1TXDSR2_DB6                          EQU        This_symb_has_been_depreciated
mCAN1TXDSR2_DB7                          EQU        This_symb_has_been_depreciated
CAN1TXDSR1                               EQU        This_symb_has_been_depreciated
mCAN1TXDSR1_DB0                          EQU        This_symb_has_been_depreciated
mCAN1TXDSR1_DB1                          EQU        This_symb_has_been_depreciated
mCAN1TXDSR1_DB2                          EQU        This_symb_has_been_depreciated
mCAN1TXDSR1_DB3                          EQU        This_symb_has_been_depreciated
mCAN1TXDSR1_DB4                          EQU        This_symb_has_been_depreciated
mCAN1TXDSR1_DB5                          EQU        This_symb_has_been_depreciated
mCAN1TXDSR1_DB6                          EQU        This_symb_has_been_depreciated
mCAN1TXDSR1_DB7                          EQU        This_symb_has_been_depreciated
CAN1TXDSR0                               EQU        This_symb_has_been_depreciated
mCAN1TXDSR0_DB0                          EQU        This_symb_has_been_depreciated
mCAN1TXDSR0_DB1                          EQU        This_symb_has_been_depreciated
mCAN1TXDSR0_DB2                          EQU        This_symb_has_been_depreciated
mCAN1TXDSR0_DB3                          EQU        This_symb_has_been_depreciated
mCAN1TXDSR0_DB4                          EQU        This_symb_has_been_depreciated
mCAN1TXDSR0_DB5                          EQU        This_symb_has_been_depreciated
mCAN1TXDSR0_DB6                          EQU        This_symb_has_been_depreciated
mCAN1TXDSR0_DB7                          EQU        This_symb_has_been_depreciated
CAN1TXIDR3                               EQU        This_symb_has_been_depreciated
mCAN1TXIDR3_RTR                          EQU        This_symb_has_been_depreciated
mCAN1TXIDR3_ID0                          EQU        This_symb_has_been_depreciated
mCAN1TXIDR3_ID1                          EQU        This_symb_has_been_depreciated
mCAN1TXIDR3_ID2                          EQU        This_symb_has_been_depreciated
mCAN1TXIDR3_ID3                          EQU        This_symb_has_been_depreciated
mCAN1TXIDR3_ID4                          EQU        This_symb_has_been_depreciated
mCAN1TXIDR3_ID5                          EQU        This_symb_has_been_depreciated
mCAN1TXIDR3_ID6                          EQU        This_symb_has_been_depreciated
CAN1TXIDR2                               EQU        This_symb_has_been_depreciated
mCAN1TXIDR2_ID7                          EQU        This_symb_has_been_depreciated
mCAN1TXIDR2_ID8                          EQU        This_symb_has_been_depreciated
mCAN1TXIDR2_ID9                          EQU        This_symb_has_been_depreciated
mCAN1TXIDR2_ID10                         EQU        This_symb_has_been_depreciated
mCAN1TXIDR2_ID11                         EQU        This_symb_has_been_depreciated
mCAN1TXIDR2_ID12                         EQU        This_symb_has_been_depreciated
mCAN1TXIDR2_ID13                         EQU        This_symb_has_been_depreciated
mCAN1TXIDR2_ID14                         EQU        This_symb_has_been_depreciated
CAN1TXIDR1                               EQU        This_symb_has_been_depreciated
mCAN1TXIDR1_ID15                         EQU        This_symb_has_been_depreciated
mCAN1TXIDR1_ID16                         EQU        This_symb_has_been_depreciated
mCAN1TXIDR1_ID17                         EQU        This_symb_has_been_depreciated
mCAN1TXIDR1_IDE                          EQU        This_symb_has_been_depreciated
mCAN1TXIDR1_SRR                          EQU        This_symb_has_been_depreciated
mCAN1TXIDR1_ID18                         EQU        This_symb_has_been_depreciated
mCAN1TXIDR1_ID19                         EQU        This_symb_has_been_depreciated
mCAN1TXIDR1_ID20                         EQU        This_symb_has_been_depreciated
CAN1TXIDR0                               EQU        This_symb_has_been_depreciated
mCAN1TXIDR0_ID21                         EQU        This_symb_has_been_depreciated
mCAN1TXIDR0_ID22                         EQU        This_symb_has_been_depreciated
mCAN1TXIDR0_ID23                         EQU        This_symb_has_been_depreciated
mCAN1TXIDR0_ID24                         EQU        This_symb_has_been_depreciated
mCAN1TXIDR0_ID25                         EQU        This_symb_has_been_depreciated
mCAN1TXIDR0_ID26                         EQU        This_symb_has_been_depreciated
mCAN1TXIDR0_ID27                         EQU        This_symb_has_been_depreciated
mCAN1TXIDR0_ID28                         EQU        This_symb_has_been_depreciated
CAN1RXTSRL                               EQU        This_symb_has_been_depreciated
mCAN1RXTSRL_TSR0                         EQU        This_symb_has_been_depreciated
mCAN1RXTSRL_TSR1                         EQU        This_symb_has_been_depreciated
mCAN1RXTSRL_TSR2                         EQU        This_symb_has_been_depreciated
mCAN1RXTSRL_TSR3                         EQU        This_symb_has_been_depreciated
mCAN1RXTSRL_TSR4                         EQU        This_symb_has_been_depreciated
mCAN1RXTSRL_TSR5                         EQU        This_symb_has_been_depreciated
mCAN1RXTSRL_TSR6                         EQU        This_symb_has_been_depreciated
mCAN1RXTSRL_TSR7                         EQU        This_symb_has_been_depreciated
CAN1RXTSR                                EQU        This_symb_has_been_depreciated
mCAN1RXTSR_TSR0                          EQU        This_symb_has_been_depreciated
mCAN1RXTSR_TSR1                          EQU        This_symb_has_been_depreciated
mCAN1RXTSR_TSR2                          EQU        This_symb_has_been_depreciated
mCAN1RXTSR_TSR3                          EQU        This_symb_has_been_depreciated
mCAN1RXTSR_TSR4                          EQU        This_symb_has_been_depreciated
mCAN1RXTSR_TSR5                          EQU        This_symb_has_been_depreciated
mCAN1RXTSR_TSR6                          EQU        This_symb_has_been_depreciated
mCAN1RXTSR_TSR7                          EQU        This_symb_has_been_depreciated
mCAN1RXTSR_TSR8                          EQU        This_symb_has_been_depreciated
mCAN1RXTSR_TSR9                          EQU        This_symb_has_been_depreciated
mCAN1RXTSR_TSR10                         EQU        This_symb_has_been_depreciated
mCAN1RXTSR_TSR11                         EQU        This_symb_has_been_depreciated
mCAN1RXTSR_TSR12                         EQU        This_symb_has_been_depreciated
mCAN1RXTSR_TSR13                         EQU        This_symb_has_been_depreciated
mCAN1RXTSR_TSR14                         EQU        This_symb_has_been_depreciated
mCAN1RXTSR_TSR15                         EQU        This_symb_has_been_depreciated
CAN1RXTSRH                               EQU        This_symb_has_been_depreciated
mCAN1RXTSRH_TSR8                         EQU        This_symb_has_been_depreciated
mCAN1RXTSRH_TSR9                         EQU        This_symb_has_been_depreciated
mCAN1RXTSRH_TSR10                        EQU        This_symb_has_been_depreciated
mCAN1RXTSRH_TSR11                        EQU        This_symb_has_been_depreciated
mCAN1RXTSRH_TSR12                        EQU        This_symb_has_been_depreciated
mCAN1RXTSRH_TSR13                        EQU        This_symb_has_been_depreciated
mCAN1RXTSRH_TSR14                        EQU        This_symb_has_been_depreciated
mCAN1RXTSRH_TSR15                        EQU        This_symb_has_been_depreciated
CAN1RXDLR                                EQU        This_symb_has_been_depreciated
mCAN1RXDLR_DLC0                          EQU        This_symb_has_been_depreciated
mCAN1RXDLR_DLC1                          EQU        This_symb_has_been_depreciated
mCAN1RXDLR_DLC2                          EQU        This_symb_has_been_depreciated
mCAN1RXDLR_DLC3                          EQU        This_symb_has_been_depreciated
CAN1RXDSR7                               EQU        This_symb_has_been_depreciated
mCAN1RXDSR7_DB0                          EQU        This_symb_has_been_depreciated
mCAN1RXDSR7_DB1                          EQU        This_symb_has_been_depreciated
mCAN1RXDSR7_DB2                          EQU        This_symb_has_been_depreciated
mCAN1RXDSR7_DB3                          EQU        This_symb_has_been_depreciated
mCAN1RXDSR7_DB4                          EQU        This_symb_has_been_depreciated
mCAN1RXDSR7_DB5                          EQU        This_symb_has_been_depreciated
mCAN1RXDSR7_DB6                          EQU        This_symb_has_been_depreciated
mCAN1RXDSR7_DB7                          EQU        This_symb_has_been_depreciated
CAN1RXDSR6                               EQU        This_symb_has_been_depreciated
mCAN1RXDSR6_DB0                          EQU        This_symb_has_been_depreciated
mCAN1RXDSR6_DB1                          EQU        This_symb_has_been_depreciated
mCAN1RXDSR6_DB2                          EQU        This_symb_has_been_depreciated
mCAN1RXDSR6_DB3                          EQU        This_symb_has_been_depreciated
mCAN1RXDSR6_DB4                          EQU        This_symb_has_been_depreciated
mCAN1RXDSR6_DB5                          EQU        This_symb_has_been_depreciated
mCAN1RXDSR6_DB6                          EQU        This_symb_has_been_depreciated
mCAN1RXDSR6_DB7                          EQU        This_symb_has_been_depreciated
CAN1RXDSR5                               EQU        This_symb_has_been_depreciated
mCAN1RXDSR5_DB0                          EQU        This_symb_has_been_depreciated
mCAN1RXDSR5_DB1                          EQU        This_symb_has_been_depreciated
mCAN1RXDSR5_DB2                          EQU        This_symb_has_been_depreciated
mCAN1RXDSR5_DB3                          EQU        This_symb_has_been_depreciated
mCAN1RXDSR5_DB4                          EQU        This_symb_has_been_depreciated
mCAN1RXDSR5_DB5                          EQU        This_symb_has_been_depreciated
mCAN1RXDSR5_DB6                          EQU        This_symb_has_been_depreciated
mCAN1RXDSR5_DB7                          EQU        This_symb_has_been_depreciated
CAN1RXDSR4                               EQU        This_symb_has_been_depreciated
mCAN1RXDSR4_DB0                          EQU        This_symb_has_been_depreciated
mCAN1RXDSR4_DB1                          EQU        This_symb_has_been_depreciated
mCAN1RXDSR4_DB2                          EQU        This_symb_has_been_depreciated
mCAN1RXDSR4_DB3                          EQU        This_symb_has_been_depreciated
mCAN1RXDSR4_DB4                          EQU        This_symb_has_been_depreciated
mCAN1RXDSR4_DB5                          EQU        This_symb_has_been_depreciated
mCAN1RXDSR4_DB6                          EQU        This_symb_has_been_depreciated
mCAN1RXDSR4_DB7                          EQU        This_symb_has_been_depreciated
CAN1RXDSR3                               EQU        This_symb_has_been_depreciated
mCAN1RXDSR3_DB0                          EQU        This_symb_has_been_depreciated
mCAN1RXDSR3_DB1                          EQU        This_symb_has_been_depreciated
mCAN1RXDSR3_DB2                          EQU        This_symb_has_been_depreciated
mCAN1RXDSR3_DB3                          EQU        This_symb_has_been_depreciated
mCAN1RXDSR3_DB4                          EQU        This_symb_has_been_depreciated
mCAN1RXDSR3_DB5                          EQU        This_symb_has_been_depreciated
mCAN1RXDSR3_DB6                          EQU        This_symb_has_been_depreciated
mCAN1RXDSR3_DB7                          EQU        This_symb_has_been_depreciated
CAN1RXDSR2                               EQU        This_symb_has_been_depreciated
mCAN1RXDSR2_DB0                          EQU        This_symb_has_been_depreciated
mCAN1RXDSR2_DB1                          EQU        This_symb_has_been_depreciated
mCAN1RXDSR2_DB2                          EQU        This_symb_has_been_depreciated
mCAN1RXDSR2_DB3                          EQU        This_symb_has_been_depreciated
mCAN1RXDSR2_DB4                          EQU        This_symb_has_been_depreciated
mCAN1RXDSR2_DB5                          EQU        This_symb_has_been_depreciated
mCAN1RXDSR2_DB6                          EQU        This_symb_has_been_depreciated
mCAN1RXDSR2_DB7                          EQU        This_symb_has_been_depreciated
CAN1RXDSR1                               EQU        This_symb_has_been_depreciated
mCAN1RXDSR1_DB0                          EQU        This_symb_has_been_depreciated
mCAN1RXDSR1_DB1                          EQU        This_symb_has_been_depreciated
mCAN1RXDSR1_DB2                          EQU        This_symb_has_been_depreciated
mCAN1RXDSR1_DB3                          EQU        This_symb_has_been_depreciated
mCAN1RXDSR1_DB4                          EQU        This_symb_has_been_depreciated
mCAN1RXDSR1_DB5                          EQU        This_symb_has_been_depreciated
mCAN1RXDSR1_DB6                          EQU        This_symb_has_been_depreciated
mCAN1RXDSR1_DB7                          EQU        This_symb_has_been_depreciated
CAN1RXDSR0                               EQU        This_symb_has_been_depreciated
mCAN1RXDSR0_DB0                          EQU        This_symb_has_been_depreciated
mCAN1RXDSR0_DB1                          EQU        This_symb_has_been_depreciated
mCAN1RXDSR0_DB2                          EQU        This_symb_has_been_depreciated
mCAN1RXDSR0_DB3                          EQU        This_symb_has_been_depreciated
mCAN1RXDSR0_DB4                          EQU        This_symb_has_been_depreciated
mCAN1RXDSR0_DB5                          EQU        This_symb_has_been_depreciated
mCAN1RXDSR0_DB6                          EQU        This_symb_has_been_depreciated
mCAN1RXDSR0_DB7                          EQU        This_symb_has_been_depreciated
CAN1RXIDR3                               EQU        This_symb_has_been_depreciated
mCAN1RXIDR3_RTR                          EQU        This_symb_has_been_depreciated
mCAN1RXIDR3_ID0                          EQU        This_symb_has_been_depreciated
mCAN1RXIDR3_ID1                          EQU        This_symb_has_been_depreciated
mCAN1RXIDR3_ID2                          EQU        This_symb_has_been_depreciated
mCAN1RXIDR3_ID3                          EQU        This_symb_has_been_depreciated
mCAN1RXIDR3_ID4                          EQU        This_symb_has_been_depreciated
mCAN1RXIDR3_ID5                          EQU        This_symb_has_been_depreciated
mCAN1RXIDR3_ID6                          EQU        This_symb_has_been_depreciated
CAN1RXIDR2                               EQU        This_symb_has_been_depreciated
mCAN1RXIDR2_ID7                          EQU        This_symb_has_been_depreciated
mCAN1RXIDR2_ID8                          EQU        This_symb_has_been_depreciated
mCAN1RXIDR2_ID9                          EQU        This_symb_has_been_depreciated
mCAN1RXIDR2_ID10                         EQU        This_symb_has_been_depreciated
mCAN1RXIDR2_ID11                         EQU        This_symb_has_been_depreciated
mCAN1RXIDR2_ID12                         EQU        This_symb_has_been_depreciated
mCAN1RXIDR2_ID13                         EQU        This_symb_has_been_depreciated
mCAN1RXIDR2_ID14                         EQU        This_symb_has_been_depreciated
CAN1RXIDR1                               EQU        This_symb_has_been_depreciated
mCAN1RXIDR1_ID15                         EQU        This_symb_has_been_depreciated
mCAN1RXIDR1_ID16                         EQU        This_symb_has_been_depreciated
mCAN1RXIDR1_ID17                         EQU        This_symb_has_been_depreciated
mCAN1RXIDR1_IDE                          EQU        This_symb_has_been_depreciated
mCAN1RXIDR1_SRR                          EQU        This_symb_has_been_depreciated
mCAN1RXIDR1_ID18                         EQU        This_symb_has_been_depreciated
mCAN1RXIDR1_ID19                         EQU        This_symb_has_been_depreciated
mCAN1RXIDR1_ID20                         EQU        This_symb_has_been_depreciated
CAN1RXIDR0                               EQU        This_symb_has_been_depreciated
mCAN1RXIDR0_ID21                         EQU        This_symb_has_been_depreciated
mCAN1RXIDR0_ID22                         EQU        This_symb_has_been_depreciated
mCAN1RXIDR0_ID23                         EQU        This_symb_has_been_depreciated
mCAN1RXIDR0_ID24                         EQU        This_symb_has_been_depreciated
mCAN1RXIDR0_ID25                         EQU        This_symb_has_been_depreciated
mCAN1RXIDR0_ID26                         EQU        This_symb_has_been_depreciated
mCAN1RXIDR0_ID27                         EQU        This_symb_has_been_depreciated
mCAN1RXIDR0_ID28                         EQU        This_symb_has_been_depreciated
CAN1IDMR7                                EQU        This_symb_has_been_depreciated
mCAN1IDMR7_AM0                           EQU        This_symb_has_been_depreciated
mCAN1IDMR7_AM1                           EQU        This_symb_has_been_depreciated
mCAN1IDMR7_AM2                           EQU        This_symb_has_been_depreciated
mCAN1IDMR7_AM3                           EQU        This_symb_has_been_depreciated
mCAN1IDMR7_AM4                           EQU        This_symb_has_been_depreciated
mCAN1IDMR7_AM5                           EQU        This_symb_has_been_depreciated
mCAN1IDMR7_AM6                           EQU        This_symb_has_been_depreciated
mCAN1IDMR7_AM7                           EQU        This_symb_has_been_depreciated
CAN1IDMR6                                EQU        This_symb_has_been_depreciated
mCAN1IDMR6_AM0                           EQU        This_symb_has_been_depreciated
mCAN1IDMR6_AM1                           EQU        This_symb_has_been_depreciated
mCAN1IDMR6_AM2                           EQU        This_symb_has_been_depreciated
mCAN1IDMR6_AM3                           EQU        This_symb_has_been_depreciated
mCAN1IDMR6_AM4                           EQU        This_symb_has_been_depreciated
mCAN1IDMR6_AM5                           EQU        This_symb_has_been_depreciated
mCAN1IDMR6_AM6                           EQU        This_symb_has_been_depreciated
mCAN1IDMR6_AM7                           EQU        This_symb_has_been_depreciated
CAN1IDMR5                                EQU        This_symb_has_been_depreciated
mCAN1IDMR5_AM0                           EQU        This_symb_has_been_depreciated
mCAN1IDMR5_AM1                           EQU        This_symb_has_been_depreciated
mCAN1IDMR5_AM2                           EQU        This_symb_has_been_depreciated
mCAN1IDMR5_AM3                           EQU        This_symb_has_been_depreciated
mCAN1IDMR5_AM4                           EQU        This_symb_has_been_depreciated
mCAN1IDMR5_AM5                           EQU        This_symb_has_been_depreciated
mCAN1IDMR5_AM6                           EQU        This_symb_has_been_depreciated
mCAN1IDMR5_AM7                           EQU        This_symb_has_been_depreciated
CAN1IDMR4                                EQU        This_symb_has_been_depreciated
mCAN1IDMR4_AM0                           EQU        This_symb_has_been_depreciated
mCAN1IDMR4_AM1                           EQU        This_symb_has_been_depreciated
mCAN1IDMR4_AM2                           EQU        This_symb_has_been_depreciated
mCAN1IDMR4_AM3                           EQU        This_symb_has_been_depreciated
mCAN1IDMR4_AM4                           EQU        This_symb_has_been_depreciated
mCAN1IDMR4_AM5                           EQU        This_symb_has_been_depreciated
mCAN1IDMR4_AM6                           EQU        This_symb_has_been_depreciated
mCAN1IDMR4_AM7                           EQU        This_symb_has_been_depreciated
CAN1IDAR7                                EQU        This_symb_has_been_depreciated
mCAN1IDAR7_AC0                           EQU        This_symb_has_been_depreciated
mCAN1IDAR7_AC1                           EQU        This_symb_has_been_depreciated
mCAN1IDAR7_AC2                           EQU        This_symb_has_been_depreciated
mCAN1IDAR7_AC3                           EQU        This_symb_has_been_depreciated
mCAN1IDAR7_AC4                           EQU        This_symb_has_been_depreciated
mCAN1IDAR7_AC5                           EQU        This_symb_has_been_depreciated
mCAN1IDAR7_AC6                           EQU        This_symb_has_been_depreciated
mCAN1IDAR7_AC7                           EQU        This_symb_has_been_depreciated
CAN1IDAR6                                EQU        This_symb_has_been_depreciated
mCAN1IDAR6_AC0                           EQU        This_symb_has_been_depreciated
mCAN1IDAR6_AC1                           EQU        This_symb_has_been_depreciated
mCAN1IDAR6_AC2                           EQU        This_symb_has_been_depreciated
mCAN1IDAR6_AC3                           EQU        This_symb_has_been_depreciated
mCAN1IDAR6_AC4                           EQU        This_symb_has_been_depreciated
mCAN1IDAR6_AC5                           EQU        This_symb_has_been_depreciated
mCAN1IDAR6_AC6                           EQU        This_symb_has_been_depreciated
mCAN1IDAR6_AC7                           EQU        This_symb_has_been_depreciated
CAN1IDAR5                                EQU        This_symb_has_been_depreciated
mCAN1IDAR5_AC0                           EQU        This_symb_has_been_depreciated
mCAN1IDAR5_AC1                           EQU        This_symb_has_been_depreciated
mCAN1IDAR5_AC2                           EQU        This_symb_has_been_depreciated
mCAN1IDAR5_AC3                           EQU        This_symb_has_been_depreciated
mCAN1IDAR5_AC4                           EQU        This_symb_has_been_depreciated
mCAN1IDAR5_AC5                           EQU        This_symb_has_been_depreciated
mCAN1IDAR5_AC6                           EQU        This_symb_has_been_depreciated
mCAN1IDAR5_AC7                           EQU        This_symb_has_been_depreciated
CAN1IDAR4                                EQU        This_symb_has_been_depreciated
mCAN1IDAR4_AC0                           EQU        This_symb_has_been_depreciated
mCAN1IDAR4_AC1                           EQU        This_symb_has_been_depreciated
mCAN1IDAR4_AC2                           EQU        This_symb_has_been_depreciated
mCAN1IDAR4_AC3                           EQU        This_symb_has_been_depreciated
mCAN1IDAR4_AC4                           EQU        This_symb_has_been_depreciated
mCAN1IDAR4_AC5                           EQU        This_symb_has_been_depreciated
mCAN1IDAR4_AC6                           EQU        This_symb_has_been_depreciated
mCAN1IDAR4_AC7                           EQU        This_symb_has_been_depreciated
CAN1IDMR3                                EQU        This_symb_has_been_depreciated
mCAN1IDMR3_AM0                           EQU        This_symb_has_been_depreciated
mCAN1IDMR3_AM1                           EQU        This_symb_has_been_depreciated
mCAN1IDMR3_AM2                           EQU        This_symb_has_been_depreciated
mCAN1IDMR3_AM3                           EQU        This_symb_has_been_depreciated
mCAN1IDMR3_AM4                           EQU        This_symb_has_been_depreciated
mCAN1IDMR3_AM5                           EQU        This_symb_has_been_depreciated
mCAN1IDMR3_AM6                           EQU        This_symb_has_been_depreciated
mCAN1IDMR3_AM7                           EQU        This_symb_has_been_depreciated
CAN1IDMR2                                EQU        This_symb_has_been_depreciated
mCAN1IDMR2_AM0                           EQU        This_symb_has_been_depreciated
mCAN1IDMR2_AM1                           EQU        This_symb_has_been_depreciated
mCAN1IDMR2_AM2                           EQU        This_symb_has_been_depreciated
mCAN1IDMR2_AM3                           EQU        This_symb_has_been_depreciated
mCAN1IDMR2_AM4                           EQU        This_symb_has_been_depreciated
mCAN1IDMR2_AM5                           EQU        This_symb_has_been_depreciated
mCAN1IDMR2_AM6                           EQU        This_symb_has_been_depreciated
mCAN1IDMR2_AM7                           EQU        This_symb_has_been_depreciated
CAN1IDMR1                                EQU        This_symb_has_been_depreciated
mCAN1IDMR1_AM0                           EQU        This_symb_has_been_depreciated
mCAN1IDMR1_AM1                           EQU        This_symb_has_been_depreciated
mCAN1IDMR1_AM2                           EQU        This_symb_has_been_depreciated
mCAN1IDMR1_AM3                           EQU        This_symb_has_been_depreciated
mCAN1IDMR1_AM4                           EQU        This_symb_has_been_depreciated
mCAN1IDMR1_AM5                           EQU        This_symb_has_been_depreciated
mCAN1IDMR1_AM6                           EQU        This_symb_has_been_depreciated
mCAN1IDMR1_AM7                           EQU        This_symb_has_been_depreciated
CAN1IDMR0                                EQU        This_symb_has_been_depreciated
mCAN1IDMR0_AM0                           EQU        This_symb_has_been_depreciated
mCAN1IDMR0_AM1                           EQU        This_symb_has_been_depreciated
mCAN1IDMR0_AM2                           EQU        This_symb_has_been_depreciated
mCAN1IDMR0_AM3                           EQU        This_symb_has_been_depreciated
mCAN1IDMR0_AM4                           EQU        This_symb_has_been_depreciated
mCAN1IDMR0_AM5                           EQU        This_symb_has_been_depreciated
mCAN1IDMR0_AM6                           EQU        This_symb_has_been_depreciated
mCAN1IDMR0_AM7                           EQU        This_symb_has_been_depreciated
CAN1IDAR3                                EQU        This_symb_has_been_depreciated
mCAN1IDAR3_AC0                           EQU        This_symb_has_been_depreciated
mCAN1IDAR3_AC1                           EQU        This_symb_has_been_depreciated
mCAN1IDAR3_AC2                           EQU        This_symb_has_been_depreciated
mCAN1IDAR3_AC3                           EQU        This_symb_has_been_depreciated
mCAN1IDAR3_AC4                           EQU        This_symb_has_been_depreciated
mCAN1IDAR3_AC5                           EQU        This_symb_has_been_depreciated
mCAN1IDAR3_AC6                           EQU        This_symb_has_been_depreciated
mCAN1IDAR3_AC7                           EQU        This_symb_has_been_depreciated
CAN1IDAR2                                EQU        This_symb_has_been_depreciated
mCAN1IDAR2_AC0                           EQU        This_symb_has_been_depreciated
mCAN1IDAR2_AC1                           EQU        This_symb_has_been_depreciated
mCAN1IDAR2_AC2                           EQU        This_symb_has_been_depreciated
mCAN1IDAR2_AC3                           EQU        This_symb_has_been_depreciated
mCAN1IDAR2_AC4                           EQU        This_symb_has_been_depreciated
mCAN1IDAR2_AC5                           EQU        This_symb_has_been_depreciated
mCAN1IDAR2_AC6                           EQU        This_symb_has_been_depreciated
mCAN1IDAR2_AC7                           EQU        This_symb_has_been_depreciated
CAN1IDAR1                                EQU        This_symb_has_been_depreciated
mCAN1IDAR1_AC0                           EQU        This_symb_has_been_depreciated
mCAN1IDAR1_AC1                           EQU        This_symb_has_been_depreciated
mCAN1IDAR1_AC2                           EQU        This_symb_has_been_depreciated
mCAN1IDAR1_AC3                           EQU        This_symb_has_been_depreciated
mCAN1IDAR1_AC4                           EQU        This_symb_has_been_depreciated
mCAN1IDAR1_AC5                           EQU        This_symb_has_been_depreciated
mCAN1IDAR1_AC6                           EQU        This_symb_has_been_depreciated
mCAN1IDAR1_AC7                           EQU        This_symb_has_been_depreciated
CAN1IDAR0                                EQU        This_symb_has_been_depreciated
mCAN1IDAR0_AC0                           EQU        This_symb_has_been_depreciated
mCAN1IDAR0_AC1                           EQU        This_symb_has_been_depreciated
mCAN1IDAR0_AC2                           EQU        This_symb_has_been_depreciated
mCAN1IDAR0_AC3                           EQU        This_symb_has_been_depreciated
mCAN1IDAR0_AC4                           EQU        This_symb_has_been_depreciated
mCAN1IDAR0_AC5                           EQU        This_symb_has_been_depreciated
mCAN1IDAR0_AC6                           EQU        This_symb_has_been_depreciated
mCAN1IDAR0_AC7                           EQU        This_symb_has_been_depreciated
CAN1TXERR                                EQU        This_symb_has_been_depreciated
mCAN1TXERR_TXERR0                        EQU        This_symb_has_been_depreciated
mCAN1TXERR_TXERR1                        EQU        This_symb_has_been_depreciated
mCAN1TXERR_TXERR2                        EQU        This_symb_has_been_depreciated
mCAN1TXERR_TXERR3                        EQU        This_symb_has_been_depreciated
mCAN1TXERR_TXERR4                        EQU        This_symb_has_been_depreciated
mCAN1TXERR_TXERR5                        EQU        This_symb_has_been_depreciated
mCAN1TXERR_TXERR6                        EQU        This_symb_has_been_depreciated
mCAN1TXERR_TXERR7                        EQU        This_symb_has_been_depreciated
CAN1RXERR                                EQU        This_symb_has_been_depreciated
mCAN1RXERR_RXERR0                        EQU        This_symb_has_been_depreciated
mCAN1RXERR_RXERR1                        EQU        This_symb_has_been_depreciated
mCAN1RXERR_RXERR2                        EQU        This_symb_has_been_depreciated
mCAN1RXERR_RXERR3                        EQU        This_symb_has_been_depreciated
mCAN1RXERR_RXERR4                        EQU        This_symb_has_been_depreciated
mCAN1RXERR_RXERR5                        EQU        This_symb_has_been_depreciated
mCAN1RXERR_RXERR6                        EQU        This_symb_has_been_depreciated
mCAN1RXERR_RXERR7                        EQU        This_symb_has_been_depreciated
CAN1IDAC                                 EQU        This_symb_has_been_depreciated
mCAN1IDAC_IDHIT0                         EQU        This_symb_has_been_depreciated
mCAN1IDAC_IDHIT1                         EQU        This_symb_has_been_depreciated
mCAN1IDAC_IDHIT2                         EQU        This_symb_has_been_depreciated
mCAN1IDAC_IDAM0                          EQU        This_symb_has_been_depreciated
mCAN1IDAC_IDAM1                          EQU        This_symb_has_been_depreciated
CAN1TBSEL                                EQU        This_symb_has_been_depreciated
mCAN1TBSEL_TX0                           EQU        This_symb_has_been_depreciated
mCAN1TBSEL_TX1                           EQU        This_symb_has_been_depreciated
mCAN1TBSEL_TX2                           EQU        This_symb_has_been_depreciated
CAN1TAAK                                 EQU        This_symb_has_been_depreciated
mCAN1TAAK_ABTAK0                         EQU        This_symb_has_been_depreciated
mCAN1TAAK_ABTAK1                         EQU        This_symb_has_been_depreciated
mCAN1TAAK_ABTAK2                         EQU        This_symb_has_been_depreciated
CAN1TARQ                                 EQU        This_symb_has_been_depreciated
mCAN1TARQ_ABTRQ0                         EQU        This_symb_has_been_depreciated
mCAN1TARQ_ABTRQ1                         EQU        This_symb_has_been_depreciated
mCAN1TARQ_ABTRQ2                         EQU        This_symb_has_been_depreciated
CAN1TIER                                 EQU        This_symb_has_been_depreciated
mCAN1TIER_TXEIE0                         EQU        This_symb_has_been_depreciated
mCAN1TIER_TXEIE1                         EQU        This_symb_has_been_depreciated
mCAN1TIER_TXEIE2                         EQU        This_symb_has_been_depreciated
CAN1TFLG                                 EQU        This_symb_has_been_depreciated
mCAN1TFLG_TXE0                           EQU        This_symb_has_been_depreciated
mCAN1TFLG_TXE1                           EQU        This_symb_has_been_depreciated
mCAN1TFLG_TXE2                           EQU        This_symb_has_been_depreciated
CAN1RIER                                 EQU        This_symb_has_been_depreciated
mCAN1RIER_RXFIE                          EQU        This_symb_has_been_depreciated
mCAN1RIER_OVRIE                          EQU        This_symb_has_been_depreciated
mCAN1RIER_TSTATE0                        EQU        This_symb_has_been_depreciated
mCAN1RIER_TSTATE1                        EQU        This_symb_has_been_depreciated
mCAN1RIER_RSTATE0                        EQU        This_symb_has_been_depreciated
mCAN1RIER_RSTATE1                        EQU        This_symb_has_been_depreciated
mCAN1RIER_CSCIE                          EQU        This_symb_has_been_depreciated
mCAN1RIER_WUPIE                          EQU        This_symb_has_been_depreciated
CAN1RFLG                                 EQU        This_symb_has_been_depreciated
mCAN1RFLG_RXF                            EQU        This_symb_has_been_depreciated
mCAN1RFLG_OVRIF                          EQU        This_symb_has_been_depreciated
mCAN1RFLG_TSTAT0                         EQU        This_symb_has_been_depreciated
mCAN1RFLG_TSTAT1                         EQU        This_symb_has_been_depreciated
mCAN1RFLG_RSTAT0                         EQU        This_symb_has_been_depreciated
mCAN1RFLG_RSTAT1                         EQU        This_symb_has_been_depreciated
mCAN1RFLG_CSCIF                          EQU        This_symb_has_been_depreciated
mCAN1RFLG_WUPIF                          EQU        This_symb_has_been_depreciated
CAN1BTR1                                 EQU        This_symb_has_been_depreciated
mCAN1BTR1_TSEG10                         EQU        This_symb_has_been_depreciated
mCAN1BTR1_TSEG11                         EQU        This_symb_has_been_depreciated
mCAN1BTR1_TSEG12                         EQU        This_symb_has_been_depreciated
mCAN1BTR1_TSEG13                         EQU        This_symb_has_been_depreciated
mCAN1BTR1_TSEG20                         EQU        This_symb_has_been_depreciated
mCAN1BTR1_TSEG21                         EQU        This_symb_has_been_depreciated
mCAN1BTR1_TSEG22                         EQU        This_symb_has_been_depreciated
mCAN1BTR1_SAMP                           EQU        This_symb_has_been_depreciated
CAN1BTR0                                 EQU        This_symb_has_been_depreciated
mCAN1BTR0_BRP0                           EQU        This_symb_has_been_depreciated
mCAN1BTR0_BRP1                           EQU        This_symb_has_been_depreciated
mCAN1BTR0_BRP2                           EQU        This_symb_has_been_depreciated
mCAN1BTR0_BRP3                           EQU        This_symb_has_been_depreciated
mCAN1BTR0_BRP4                           EQU        This_symb_has_been_depreciated
mCAN1BTR0_BRP5                           EQU        This_symb_has_been_depreciated
mCAN1BTR0_SJW0                           EQU        This_symb_has_been_depreciated
mCAN1BTR0_SJW1                           EQU        This_symb_has_been_depreciated
CAN1CTL1                                 EQU        This_symb_has_been_depreciated
mCAN1CTL1_INITAK                         EQU        This_symb_has_been_depreciated
mCAN1CTL1_SLPAK                          EQU        This_symb_has_been_depreciated
mCAN1CTL1_WUPM                           EQU        This_symb_has_been_depreciated
mCAN1CTL1_LISTEN                         EQU        This_symb_has_been_depreciated
mCAN1CTL1_LOOPB                          EQU        This_symb_has_been_depreciated
mCAN1CTL1_CLKSRC                         EQU        This_symb_has_been_depreciated
mCAN1CTL1_CANE                           EQU        This_symb_has_been_depreciated
CAN1CTL0                                 EQU        This_symb_has_been_depreciated
mCAN1CTL0_INITRQ                         EQU        This_symb_has_been_depreciated
mCAN1CTL0_SLPRQ                          EQU        This_symb_has_been_depreciated
mCAN1CTL0_WUPE                           EQU        This_symb_has_been_depreciated
mCAN1CTL0_TIME                           EQU        This_symb_has_been_depreciated
mCAN1CTL0_SYNCH                          EQU        This_symb_has_been_depreciated
mCAN1CTL0_CSWAI                          EQU        This_symb_has_been_depreciated
mCAN1CTL0_RXACT                          EQU        This_symb_has_been_depreciated
mCAN1CTL0_RXFRM                          EQU        This_symb_has_been_depreciated
        ENDIF
;
; Follows changes from the database 2.87.131 version
FADDR_FADDR0                             EQU        FADDR_FADDRLO0
mFADDR_FADDR0                            EQU        mFADDR_FADDRLO0
FADDR_FADDR1                             EQU        FADDR_FADDRLO1
mFADDR_FADDR1                            EQU        mFADDR_FADDRLO1
FADDR_FADDR2                             EQU        FADDR_FADDRLO2
mFADDR_FADDR2                            EQU        mFADDR_FADDRLO2
FADDR_FADDR3                             EQU        FADDR_FADDRLO3
mFADDR_FADDR3                            EQU        mFADDR_FADDRLO3
FADDR_FADDR4                             EQU        FADDR_FADDRLO4
mFADDR_FADDR4                            EQU        mFADDR_FADDRLO4
FADDR_FADDR5                             EQU        FADDR_FADDRLO5
mFADDR_FADDR5                            EQU        mFADDR_FADDRLO5
FADDR_FADDR6                             EQU        FADDR_FADDRLO6
mFADDR_FADDR6                            EQU        mFADDR_FADDRLO6
FADDR_FADDR7                             EQU        FADDR_FADDRLO7
mFADDR_FADDR7                            EQU        mFADDR_FADDRLO7
FADDR_FADDR8                             EQU        FADDR_FADDRHI8
mFADDR_FADDR8                            EQU        mFADDR_FADDRHI8
FADDR_FADDR9                             EQU        FADDR_FADDRHI9
mFADDR_FADDR9                            EQU        mFADDR_FADDRHI9
FADDR_FADDR10                            EQU        FADDR_FADDRHI10
mFADDR_FADDR10                           EQU        mFADDR_FADDRHI10
FADDR_FADDR11                            EQU        FADDR_FADDRHI11
mFADDR_FADDR11                           EQU        mFADDR_FADDRHI11
FADDR_FADDR12                            EQU        FADDR_FADDRHI12
mFADDR_FADDR12                           EQU        mFADDR_FADDRHI12
FADDR_FADDR13                            EQU        FADDR_FADDRHI13
mFADDR_FADDR13                           EQU        mFADDR_FADDRHI13
FADDR_FADDR14                            EQU        FADDR_FADDRHI14
mFADDR_FADDR14                           EQU        mFADDR_FADDRHI14
FADDR_FADDR15                            EQU        FADDR_FADDRHI15
mFADDR_FADDR15                           EQU        mFADDR_FADDRHI15
FDATA_FDATA0                             EQU        FDATA_FDATALO0
mFDATA_FDATA0                            EQU        mFDATA_FDATALO0
FDATA_FDATA1                             EQU        FDATA_FDATALO1
mFDATA_FDATA1                            EQU        mFDATA_FDATALO1
FDATA_FDATA2                             EQU        FDATA_FDATALO2
mFDATA_FDATA2                            EQU        mFDATA_FDATALO2
FDATA_FDATA3                             EQU        FDATA_FDATALO3
mFDATA_FDATA3                            EQU        mFDATA_FDATALO3
FDATA_FDATA4                             EQU        FDATA_FDATALO4
mFDATA_FDATA4                            EQU        mFDATA_FDATALO4
FDATA_FDATA5                             EQU        FDATA_FDATALO5
mFDATA_FDATA5                            EQU        mFDATA_FDATALO5
FDATA_FDATA6                             EQU        FDATA_FDATALO6
mFDATA_FDATA6                            EQU        mFDATA_FDATALO6
FDATA_FDATA7                             EQU        FDATA_FDATALO7
mFDATA_FDATA7                            EQU        mFDATA_FDATALO7
FDATA_FDATA8                             EQU        FDATA_FDATAHI8
mFDATA_FDATA8                            EQU        mFDATA_FDATAHI8
FDATA_FDATA9                             EQU        FDATA_FDATAHI9
mFDATA_FDATA9                            EQU        mFDATA_FDATAHI9
FDATA_FDATA10                            EQU        FDATA_FDATAHI10
mFDATA_FDATA10                           EQU        mFDATA_FDATAHI10
FDATA_FDATA11                            EQU        FDATA_FDATAHI11
mFDATA_FDATA11                           EQU        mFDATA_FDATAHI11
FDATA_FDATA12                            EQU        FDATA_FDATAHI12
mFDATA_FDATA12                           EQU        mFDATA_FDATAHI12
FDATA_FDATA13                            EQU        FDATA_FDATAHI13
mFDATA_FDATA13                           EQU        mFDATA_FDATAHI13
FDATA_FDATA14                            EQU        FDATA_FDATAHI14
mFDATA_FDATA14                           EQU        mFDATA_FDATAHI14
FDATA_FDATA15                            EQU        FDATA_FDATAHI15
mFDATA_FDATA15                           EQU        mFDATA_FDATAHI15

; EOF
