; Based on CPU DB MC9S12I32_44, version 2.87.056 (RegistersPrg V2.32)

; ###################################################################
;     Filename  : mc9s12i32.inc
;     Processor : MC9S12I32
;     FileFormat: V2.32
;     DataSheet : MC9S12I32 Rev 2.1 5/2007
;     Compiler  : CodeWarrior compiler
;     Date/Time : 31.1.2011, 8:49
;     Abstract  :
;         This header implements the mapping of I/O devices.
;
;     Copyright : 1997 - 2010 Freescale Semiconductor, Inc. All Rights Reserved.
;     
;     http      : www.freescale.com
;     mail      : support@freescale.com
;
;     CPU Registers Revisions:
;      - 12.03.2008, V2.87.052:
;              - Bit RTIE added to RTICTL register
;      - 21.07.2010, V2.87.057:
;              - Definition of memory area ROM_8000(0x00008000:0x0000FEFF) splitted into ROM_C000(0x0000C000:0x0000FEFF) and PAGE_FE(0x00FE8000:0x00FEBFFF).
;
;     File-Format-Revisions:
;      - 03.07.2006, V2.09 :
;               - Changes have not affected this file (because they are related to another family)
;      - 27.10.2006, V2.10 :
;               - __RESET_WATCHDOG improved formating and re-definition
;      - 23.11.2006, V2.11 :
;               - Changes have not affected this file (because they are related to another family)
;      - 22.01.2007, V2.12 :
;               - Fixed declaration of non volatile registers. Now it does not require (but allows) their initialization, see issue #4086.
;      - 01.03.2007, V2.13 :
;               - Flash commands constants values converted to HEX format
;      - 02.03.2007, V2.14 :
;               - Interrupt vector numbers added into .H, see VectorNumber_*
;      - 26.03.2007, V2.15 :
;               - Changes have not affected this file (because they are related to another family)
;      - 10.05.2007, V2.16 :
;               - Changes have not affected this file (because they are related to another family)
;      - 05.06.2007, V2.17 :
;               - Changes have not affected this file (because they are related to another family)
;      - 19.07.2007, V2.18 :
;               - Improved number of blanked lines inside register structures
;      - 06.08.2007, V2.19 :
;               - CPUDB revisions generated ahead of the file-format revisions.
;      - 11.09.2007, V2.20 :
;               - Added comment about initialization of unbonded pins.
;      - 02.01.2008, V2.21 :
;               - Changes have not affected this file (because they are related to another family)
;      - 13.02.2008, V2.22 :
;               - Changes have not affected this file (because they are related to another family)
;      - 20.02.2008, V2.23 :
;               - Termination of pragma V30toV31Compatible added, #5708
;      - 03.07.2008, V2.24 :
;               - Added support for bits with name starting with number (like "1HZ")
;      - 28.11.2008, V2.25 :
;               - StandBy RAM array declaration for ANSI-C added
;      - 1.12.2008, V2.26 :
;               - Duplication of bit (or bit-group) name with register name is not marked as a problem, if register is internal only and it is not displayed in I/O map.
;      - 17.3.2009, V2.27 :
;               - Merged bit-group is not generated, if the name matches with another bit name in the register
;      - 6.4.2009, V2.28 :
;               - Fixed generation of merged bits for bit-groups with a digit at the end, if group-name is defined in CPUDB
;      - 3.8.2009, V2.29 :
;               - If there is just one bits group matching register name, single bits are not generated
;      - 10.9.2009, V2.30 :
;               - Fixed generation of registers arrays.
;      - 15.10.2009, V2.31 :
;               - Changes have not affected this file (because they are related to another family)
;      - 18.05.2010, V2.32 :
;               - MISRA compliance: U/UL suffixes added to all numbers (_MASK,_BITNUM and addresses)
;
;     Not all general-purpose I/O pins are available on all packages or on all mask sets of a specific
;     derivative device. To avoid extra current drain from floating input pins, the users reset
;     initialization routine in the application program must either enable on-chip pull-up devices
;     or change the direction of unconnected pins to outputs so the pins do not float.
; ###################################################################

;*** Memory Map and Interrupt Vectors
;******************************************
RAMStart:           equ   $00000800
RAMEnd:             equ   $00000FFF
ROM_C000Start:      equ   $0000C000
ROM_C000End:        equ   $0000FEFF
PAGE_FEStart:       equ   $00038000
PAGE_FEEnd:         equ   $0003BFFF
;
Vsi:                equ   $0000FF80
VReserved62:        equ   $0000FF82
VReserved61:        equ   $0000FF84
VReserved60:        equ   $0000FF86
VReserved59:        equ   $0000FF88
VReserved58:        equ   $0000FF8A
VReserved57:        equ   $0000FF8C
VReserved56:        equ   $0000FF8E
VReserved55:        equ   $0000FF90
VReserved54:        equ   $0000FF92
VReserved53:        equ   $0000FF94
VReserved52:        equ   $0000FF96
VReserved51:        equ   $0000FF98
VReserved50:        equ   $0000FF9A
VReserved49:        equ   $0000FF9C
VReserved48:        equ   $0000FF9E
VReserved47:        equ   $0000FFA0
VReserved46:        equ   $0000FFA2
VReserved45:        equ   $0000FFA4
VReserved44:        equ   $0000FFA6
VReserved43:        equ   $0000FFA8
VReserved42:        equ   $0000FFAA
VReserved41:        equ   $0000FFAC
VReserved40:        equ   $0000FFAE
VReserved39:        equ   $0000FFB0
VReserved38:        equ   $0000FFB2
VReserved37:        equ   $0000FFB4
VReserved36:        equ   $0000FFB6
Vflash:             equ   $0000FFB8
VReserved34:        equ   $0000FFBA
VReserved33:        equ   $0000FFBC
VReserved32:        equ   $0000FFBE
VReserved31:        equ   $0000FFC0
VReserved30:        equ   $0000FFC2
VReserved29:        equ   $0000FFC4
Vcrgflllck:         equ   $0000FFC6
VReserved27:        equ   $0000FFC8
VReserved26:        equ   $0000FFCA
VReserved25:        equ   $0000FFCC
VReserved24:        equ   $0000FFCE
VReserved23:        equ   $0000FFD0
VReserved22:        equ   $0000FFD2
VReserved21:        equ   $0000FFD4
VReserved20:        equ   $0000FFD6
Vspi:               equ   $0000FFD8
VReserved18:        equ   $0000FFDA
VReserved17:        equ   $0000FFDC
VReserved16:        equ   $0000FFDE
VReserved15:        equ   $0000FFE0
VReserved14:        equ   $0000FFE2
VReserved13:        equ   $0000FFE4
VReserved12:        equ   $0000FFE6
VReserved11:        equ   $0000FFE8
VReserved10:        equ   $0000FFEA
VReserved9:         equ   $0000FFEC
VReserved8:         equ   $0000FFEE
Vrti:               equ   $0000FFF0
Vd2diexterr:        equ   $0000FFF2
Vd2dierr:           equ   $0000FFF4
Vswi:               equ   $0000FFF6
Vtrap:              equ   $0000FFF8
Vcop:               equ   $0000FFFA
Vclkmon:            equ   $0000FFFC
Vreset:             equ   $0000FFFE
;


;*** PTA - Port A Data Register; 0x00000000 ***
PTA:                equ    $00000000                                ;*** PTA - Port A Data Register; 0x00000000 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTA_PTA0:           equ    0                                         ; Port A Data Bit 0
PTA_PTA1:           equ    1                                         ; Port A Data Bit 1
PTA_PTA2:           equ    2                                         ; Port A Data Bit 2
PTA_PTA3:           equ    3                                         ; Port A Data Bit 3
PTA_PTA4:           equ    4                                         ; Port A Data Bit 4
PTA_PTA5:           equ    5                                         ; Port A Data Bit 5
; bit position masks
mPTA_PTA0:          equ    %00000001
mPTA_PTA1:          equ    %00000010
mPTA_PTA2:          equ    %00000100
mPTA_PTA3:          equ    %00001000
mPTA_PTA4:          equ    %00010000
mPTA_PTA5:          equ    %00100000


;*** DDRA - Data Direction Register A; 0x00000002 ***
DDRA:               equ    $00000002                                ;*** DDRA - Data Direction Register A; 0x00000002 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRA_DDRA0:         equ    0                                         ; Data Direction Register A Bit 0
DDRA_DDRA1:         equ    1                                         ; Data Direction Register A Bit 1
DDRA_DDRA2:         equ    2                                         ; Data Direction Register A Bit 2
DDRA_DDRA3:         equ    3                                         ; Data Direction Register A Bit 3
DDRA_DDRA4:         equ    4                                         ; Data Direction Register A Bit 4
DDRA_DDRA5:         equ    5                                         ; Data Direction Register A Bit 5
; bit position masks
mDDRA_DDRA0:        equ    %00000001
mDDRA_DDRA1:        equ    %00000010
mDDRA_DDRA2:        equ    %00000100
mDDRA_DDRA3:        equ    %00001000
mDDRA_DDRA4:        equ    %00010000
mDDRA_DDRA5:        equ    %00100000


;*** PTC - Port C Data Register; 0x00000004 ***
PTC:                equ    $00000004                                ;*** PTC - Port C Data Register; 0x00000004 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTC_PTC0:           equ    0                                         ; Port C Data Bit 0
PTC_PTC1:           equ    1                                         ; Port C Data Bit 1
; bit position masks
mPTC_PTC0:          equ    %00000001
mPTC_PTC1:          equ    %00000010


;*** PTD - Port D Data Register; 0x00000005 ***
PTD:                equ    $00000005                                ;*** PTD - Port D Data Register; 0x00000005 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTD_PTD0:           equ    0                                         ; Port D Data Bit 0
PTD_PTD1:           equ    1                                         ; Port D Data Bit 1
PTD_PTD2:           equ    2                                         ; Port D Data Bit 2
PTD_PTD3:           equ    3                                         ; Port D Data Bit 3
PTD_PTD4:           equ    4                                         ; Port D Data Bit 4
PTD_PTD5:           equ    5                                         ; Port D Data Bit 5
PTD_PTD6:           equ    6                                         ; Port D Data Bit 6
PTD_PTD7:           equ    7                                         ; Port D Data Bit 7
; bit position masks
mPTD_PTD0:          equ    %00000001
mPTD_PTD1:          equ    %00000010
mPTD_PTD2:          equ    %00000100
mPTD_PTD3:          equ    %00001000
mPTD_PTD4:          equ    %00010000
mPTD_PTD5:          equ    %00100000
mPTD_PTD6:          equ    %01000000
mPTD_PTD7:          equ    %10000000


;*** DDRC - Data Direction Register C; 0x00000006 ***
DDRC:               equ    $00000006                                ;*** DDRC - Data Direction Register C; 0x00000006 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRC_DDRC0:         equ    0                                         ; Data Direction Register C Bit 0
DDRC_DDRC1:         equ    1                                         ; Data Direction Register C Bit 1
; bit position masks
mDDRC_DDRC0:        equ    %00000001
mDDRC_DDRC1:        equ    %00000010


;*** DDRD - Data Direction Register D; 0x00000007 ***
DDRD:               equ    $00000007                                ;*** DDRD - Data Direction Register D; 0x00000007 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRD_DDRD0:         equ    0                                         ; Data Direction Register D Bit 0
DDRD_DDRD1:         equ    1                                         ; Data Direction Register D Bit 1
DDRD_DDRD2:         equ    2                                         ; Data Direction Register D Bit 2
DDRD_DDRD3:         equ    3                                         ; Data Direction Register D Bit 3
DDRD_DDRD4:         equ    4                                         ; Data Direction Register D Bit 4
DDRD_DDRD5:         equ    5                                         ; Data Direction Register D Bit 5
DDRD_DDRD6:         equ    6                                         ; Data Direction Register D Bit 6
DDRD_DDRD7:         equ    7                                         ; Data Direction Register D Bit 7
; bit position masks
mDDRD_DDRD0:        equ    %00000001
mDDRD_DDRD1:        equ    %00000010
mDDRD_DDRD2:        equ    %00000100
mDDRD_DDRD3:        equ    %00001000
mDDRD_DDRD4:        equ    %00010000
mDDRD_DDRD5:        equ    %00100000
mDDRD_DDRD6:        equ    %01000000
mDDRD_DDRD7:        equ    %10000000


;*** PARTID - Part ID Register; 0x0000001A ***
PARTID:             equ    $0000001A                                ;*** PARTID - Part ID Register; 0x0000001A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PARTID_ID0:         equ    0                                         ; Part ID Register Bit 0
PARTID_ID1:         equ    1                                         ; Part ID Register Bit 1
PARTID_ID2:         equ    2                                         ; Part ID Register Bit 2
PARTID_ID3:         equ    3                                         ; Part ID Register Bit 3
PARTID_ID4:         equ    4                                         ; Part ID Register Bit 4
PARTID_ID5:         equ    5                                         ; Part ID Register Bit 5
PARTID_ID6:         equ    6                                         ; Part ID Register Bit 6
PARTID_ID7:         equ    7                                         ; Part ID Register Bit 7
PARTID_ID8:         equ    8                                         ; Part ID Register Bit 8
PARTID_ID9:         equ    9                                         ; Part ID Register Bit 9
PARTID_ID10:        equ    10                                        ; Part ID Register Bit 10
PARTID_ID11:        equ    11                                        ; Part ID Register Bit 11
PARTID_ID12:        equ    12                                        ; Part ID Register Bit 12
PARTID_ID13:        equ    13                                        ; Part ID Register Bit 13
PARTID_ID14:        equ    14                                        ; Part ID Register Bit 14
PARTID_ID15:        equ    15                                        ; Part ID Register Bit 15
; bit position masks
mPARTID_ID0:        equ    %00000001
mPARTID_ID1:        equ    %00000010
mPARTID_ID2:        equ    %00000100
mPARTID_ID3:        equ    %00001000
mPARTID_ID4:        equ    %00010000
mPARTID_ID5:        equ    %00100000
mPARTID_ID6:        equ    %01000000
mPARTID_ID7:        equ    %10000000
mPARTID_ID8:        equ    %100000000
mPARTID_ID9:        equ    %1000000000
mPARTID_ID10:       equ    %10000000000
mPARTID_ID11:       equ    %100000000000
mPARTID_ID12:       equ    %1000000000000
mPARTID_ID13:       equ    %10000000000000
mPARTID_ID14:       equ    %100000000000000
mPARTID_ID15:       equ    %1000000000000000


;*** PARTIDH - Part ID Register High; 0x0000001A ***
PARTIDH:            equ    $0000001A                                ;*** PARTIDH - Part ID Register High; 0x0000001A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PARTIDH_ID8:        equ    0                                         ; Part ID Register Bit 8
PARTIDH_ID9:        equ    1                                         ; Part ID Register Bit 9
PARTIDH_ID10:       equ    2                                         ; Part ID Register Bit 10
PARTIDH_ID11:       equ    3                                         ; Part ID Register Bit 11
PARTIDH_ID12:       equ    4                                         ; Part ID Register Bit 12
PARTIDH_ID13:       equ    5                                         ; Part ID Register Bit 13
PARTIDH_ID14:       equ    6                                         ; Part ID Register Bit 14
PARTIDH_ID15:       equ    7                                         ; Part ID Register Bit 15
; bit position masks
mPARTIDH_ID8:       equ    %00000001
mPARTIDH_ID9:       equ    %00000010
mPARTIDH_ID10:      equ    %00000100
mPARTIDH_ID11:      equ    %00001000
mPARTIDH_ID12:      equ    %00010000
mPARTIDH_ID13:      equ    %00100000
mPARTIDH_ID14:      equ    %01000000
mPARTIDH_ID15:      equ    %10000000


;*** PARTIDL - Part ID Register Low; 0x0000001B ***
PARTIDL:            equ    $0000001B                                ;*** PARTIDL - Part ID Register Low; 0x0000001B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PARTIDL_ID0:        equ    0                                         ; Part ID Register Bit 0
PARTIDL_ID1:        equ    1                                         ; Part ID Register Bit 1
PARTIDL_ID2:        equ    2                                         ; Part ID Register Bit 2
PARTIDL_ID3:        equ    3                                         ; Part ID Register Bit 3
PARTIDL_ID4:        equ    4                                         ; Part ID Register Bit 4
PARTIDL_ID5:        equ    5                                         ; Part ID Register Bit 5
PARTIDL_ID6:        equ    6                                         ; Part ID Register Bit 6
PARTIDL_ID7:        equ    7                                         ; Part ID Register Bit 7
; bit position masks
mPARTIDL_ID0:       equ    %00000001
mPARTIDL_ID1:       equ    %00000010
mPARTIDL_ID2:       equ    %00000100
mPARTIDL_ID3:       equ    %00001000
mPARTIDL_ID4:       equ    %00010000
mPARTIDL_ID5:       equ    %00100000
mPARTIDL_ID6:       equ    %01000000
mPARTIDL_ID7:       equ    %10000000


;*** IVBR - Interrupt Vector Base Register; 0x0000001F ***
IVBR:               equ    $0000001F                                ;*** IVBR - Interrupt Vector Base Register; 0x0000001F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
IVBR_IVB_ADDR0:     equ    0                                         ; Interrupt vector base address bits, bit 0
IVBR_IVB_ADDR1:     equ    1                                         ; Interrupt vector base address bits, bit 1
IVBR_IVB_ADDR2:     equ    2                                         ; Interrupt vector base address bits, bit 2
IVBR_IVB_ADDR3:     equ    3                                         ; Interrupt vector base address bits, bit 3
IVBR_IVB_ADDR4:     equ    4                                         ; Interrupt vector base address bits, bit 4
IVBR_IVB_ADDR5:     equ    5                                         ; Interrupt vector base address bits, bit 5
IVBR_IVB_ADDR6:     equ    6                                         ; Interrupt vector base address bits, bit 6
IVBR_IVB_ADDR7:     equ    7                                         ; Interrupt vector base address bits, bit 7
; bit position masks
mIVBR_IVB_ADDR0:    equ    %00000001
mIVBR_IVB_ADDR1:    equ    %00000010
mIVBR_IVB_ADDR2:    equ    %00000100
mIVBR_IVB_ADDR3:    equ    %00001000
mIVBR_IVB_ADDR4:    equ    %00010000
mIVBR_IVB_ADDR5:    equ    %00100000
mIVBR_IVB_ADDR6:    equ    %01000000
mIVBR_IVB_ADDR7:    equ    %10000000


;*** DBGC1 - Debug Control Register 1; 0x00000020 ***
DBGC1:              equ    $00000020                                ;*** DBGC1 - Debug Control Register 1; 0x00000020 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGC1_COMRV0:       equ    0                                         ; Comparator Register Visibility Bits, bit 0
DBGC1_COMRV1:       equ    1                                         ; Comparator Register Visibility Bits, bit 1
DBGC1_DBGBRK:       equ    3                                         ; S12X_DBG Breakpoint Enable Bits
DBGC1_BDM:          equ    4                                         ; Background Debug Mode Enable
DBGC1_TRIG:         equ    6                                         ; Immediate Trigger Request Bit
DBGC1_ARM:          equ    7                                         ; Arm Bit
; bit position masks
mDBGC1_COMRV0:      equ    %00000001
mDBGC1_COMRV1:      equ    %00000010
mDBGC1_DBGBRK:      equ    %00001000
mDBGC1_BDM:         equ    %00010000
mDBGC1_TRIG:        equ    %01000000
mDBGC1_ARM:         equ    %10000000


;*** DBGSR - Debug Status Register; 0x00000021 ***
DBGSR:              equ    $00000021                                ;*** DBGSR - Debug Status Register; 0x00000021 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGSR_SSF0:         equ    0                                         ; State Sequencer Flag Bit 0
DBGSR_SSF1:         equ    1                                         ; State Sequencer Flag Bit 1
DBGSR_SSF2:         equ    2                                         ; State Sequencer Flag Bit 2
DBGSR_TBF:          equ    7                                         ; Trace Buffer Full
; bit position masks
mDBGSR_SSF0:        equ    %00000001
mDBGSR_SSF1:        equ    %00000010
mDBGSR_SSF2:        equ    %00000100
mDBGSR_TBF:         equ    %10000000


;*** DBGTCR - Debug Trace Control Register; 0x00000022 ***
DBGTCR:             equ    $00000022                                ;*** DBGTCR - Debug Trace Control Register; 0x00000022 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGTCR_TALIGN:      equ    0                                         ; Trigger Align Bits
DBGTCR_TRCMOD0:     equ    2                                         ; Trace Mode Bits, bit 0
DBGTCR_TRCMOD1:     equ    3                                         ; Trace Mode Bits, bit 1
DBGTCR_TSOURCE:     equ    6                                         ; Trace Source Control Bit
; bit position masks
mDBGTCR_TALIGN:     equ    %00000001
mDBGTCR_TRCMOD0:    equ    %00000100
mDBGTCR_TRCMOD1:    equ    %00001000
mDBGTCR_TSOURCE:    equ    %01000000


;*** DBGC2 - Debug Control Register 2; 0x00000023 ***
DBGC2:              equ    $00000023                                ;*** DBGC2 - Debug Control Register 2; 0x00000023 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGC2_ABCM0:        equ    0                                         ; A and B Comparator Match Control, bit 0
DBGC2_ABCM1:        equ    1                                         ; A and B Comparator Match Control, bit 1
; bit position masks
mDBGC2_ABCM0:       equ    %00000001
mDBGC2_ABCM1:       equ    %00000010


;*** DBGTB - Debug Trace Buffer Register; 0x00000024 ***
DBGTB:              equ    $00000024                                ;*** DBGTB - Debug Trace Buffer Register; 0x00000024 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGTB_BIT0:         equ    0                                         ; Debug Trace Buffer Bit 0
DBGTB_BIT1:         equ    1                                         ; Debug Trace Buffer Bit 1
DBGTB_BIT2:         equ    2                                         ; Debug Trace Buffer Bit 2
DBGTB_BIT3:         equ    3                                         ; Debug Trace Buffer Bit 3
DBGTB_BIT4:         equ    4                                         ; Debug Trace Buffer Bit 4
DBGTB_BIT5:         equ    5                                         ; Debug Trace Buffer Bit 5
DBGTB_BIT6:         equ    6                                         ; Debug Trace Buffer Bit 6
DBGTB_BIT7:         equ    7                                         ; Debug Trace Buffer Bit 7
DBGTB_BIT8:         equ    8                                         ; Debug Trace Buffer Bit 8
DBGTB_BIT9:         equ    9                                         ; Debug Trace Buffer Bit 9
DBGTB_BIT10:        equ    10                                        ; Debug Trace Buffer Bit 10
DBGTB_BIT11:        equ    11                                        ; Debug Trace Buffer Bit 11
DBGTB_BIT12:        equ    12                                        ; Debug Trace Buffer Bit 12
DBGTB_BIT13:        equ    13                                        ; Debug Trace Buffer Bit 13
DBGTB_BIT14:        equ    14                                        ; Debug Trace Buffer Bit 14
DBGTB_BIT15:        equ    15                                        ; Debug Trace Buffer Bit 15
; bit position masks
mDBGTB_BIT0:        equ    %00000001
mDBGTB_BIT1:        equ    %00000010
mDBGTB_BIT2:        equ    %00000100
mDBGTB_BIT3:        equ    %00001000
mDBGTB_BIT4:        equ    %00010000
mDBGTB_BIT5:        equ    %00100000
mDBGTB_BIT6:        equ    %01000000
mDBGTB_BIT7:        equ    %10000000
mDBGTB_BIT8:        equ    %100000000
mDBGTB_BIT9:        equ    %1000000000
mDBGTB_BIT10:       equ    %10000000000
mDBGTB_BIT11:       equ    %100000000000
mDBGTB_BIT12:       equ    %1000000000000
mDBGTB_BIT13:       equ    %10000000000000
mDBGTB_BIT14:       equ    %100000000000000
mDBGTB_BIT15:       equ    %1000000000000000


;*** DBGTBH - Debug Trace Buffer Register High; 0x00000024 ***
DBGTBH:             equ    $00000024                                ;*** DBGTBH - Debug Trace Buffer Register High; 0x00000024 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGTBH_BIT8:        equ    0                                         ; Debug Trace Buffer Bit 8
DBGTBH_BIT9:        equ    1                                         ; Debug Trace Buffer Bit 9
DBGTBH_BIT10:       equ    2                                         ; Debug Trace Buffer Bit 10
DBGTBH_BIT11:       equ    3                                         ; Debug Trace Buffer Bit 11
DBGTBH_BIT12:       equ    4                                         ; Debug Trace Buffer Bit 12
DBGTBH_BIT13:       equ    5                                         ; Debug Trace Buffer Bit 13
DBGTBH_BIT14:       equ    6                                         ; Debug Trace Buffer Bit 14
DBGTBH_BIT15:       equ    7                                         ; Debug Trace Buffer Bit 15
; bit position masks
mDBGTBH_BIT8:       equ    %00000001
mDBGTBH_BIT9:       equ    %00000010
mDBGTBH_BIT10:      equ    %00000100
mDBGTBH_BIT11:      equ    %00001000
mDBGTBH_BIT12:      equ    %00010000
mDBGTBH_BIT13:      equ    %00100000
mDBGTBH_BIT14:      equ    %01000000
mDBGTBH_BIT15:      equ    %10000000


;*** DBGTBL - Debug Trace Buffer Register Low; 0x00000025 ***
DBGTBL:             equ    $00000025                                ;*** DBGTBL - Debug Trace Buffer Register Low; 0x00000025 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGTBL_BIT0:        equ    0                                         ; Debug Trace Buffer Bit 0
DBGTBL_BIT1:        equ    1                                         ; Debug Trace Buffer Bit 1
DBGTBL_BIT2:        equ    2                                         ; Debug Trace Buffer Bit 2
DBGTBL_BIT3:        equ    3                                         ; Debug Trace Buffer Bit 3
DBGTBL_BIT4:        equ    4                                         ; Debug Trace Buffer Bit 4
DBGTBL_BIT5:        equ    5                                         ; Debug Trace Buffer Bit 5
DBGTBL_BIT6:        equ    6                                         ; Debug Trace Buffer Bit 6
DBGTBL_BIT7:        equ    7                                         ; Debug Trace Buffer Bit 7
; bit position masks
mDBGTBL_BIT0:       equ    %00000001
mDBGTBL_BIT1:       equ    %00000010
mDBGTBL_BIT2:       equ    %00000100
mDBGTBL_BIT3:       equ    %00001000
mDBGTBL_BIT4:       equ    %00010000
mDBGTBL_BIT5:       equ    %00100000
mDBGTBL_BIT6:       equ    %01000000
mDBGTBL_BIT7:       equ    %10000000


;*** DBGCNT - Debug Count Register; 0x00000026 ***
DBGCNT:             equ    $00000026                                ;*** DBGCNT - Debug Count Register; 0x00000026 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGCNT_CNT0:        equ    0                                         ; Count value, bit 0
DBGCNT_CNT1:        equ    1                                         ; Count value, bit 1
DBGCNT_CNT2:        equ    2                                         ; Count value, bit 2
DBGCNT_CNT3:        equ    3                                         ; Count value, bit 3
DBGCNT_CNT4:        equ    4                                         ; Count value, bit 4
DBGCNT_CNT5:        equ    5                                         ; Count value, bit 5
DBGCNT_TBF:         equ    7                                         ; Trace Buffer Full
; bit position masks
mDBGCNT_CNT0:       equ    %00000001
mDBGCNT_CNT1:       equ    %00000010
mDBGCNT_CNT2:       equ    %00000100
mDBGCNT_CNT3:       equ    %00001000
mDBGCNT_CNT4:       equ    %00010000
mDBGCNT_CNT5:       equ    %00100000
mDBGCNT_TBF:        equ    %10000000


;*** DBGSCRX - Debug State Control Register 0; 0x00000027 ***
DBGSCRX:            equ    $00000027                                ;*** DBGSCRX - Debug State Control Register 0; 0x00000027 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGSCRX_SC0:        equ    0                                         ; These bit (0) select the targeted next state whilst in StateX, based upon the match event
DBGSCRX_SC1:        equ    1                                         ; These bit (1) select the targeted next state whilst in StateX, based upon the match event
DBGSCRX_SC2:        equ    2                                         ; These bit (2) select the targeted next state whilst in StateX, based upon the match event
; bit position masks
mDBGSCRX_SC0:       equ    %00000001
mDBGSCRX_SC1:       equ    %00000010
mDBGSCRX_SC2:       equ    %00000100


;*** DBGMFR - Debug State Control Register 1; 0x00000027 ***
DBGMFR:             equ    $00000027                                ;*** DBGMFR - Debug State Control Register 1; 0x00000027 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGMFR_MC0:         equ    0                                         ; These bit (0) select the targeted next state whilst in StateX, based upon the match event
DBGMFR_MC1:         equ    1                                         ; These bit (1) select the targeted next state whilst in StateX, based upon the match event
DBGMFR_MC2:         equ    2                                         ; These bit (2) select the targeted next state whilst in StateX, based upon the match event
; bit position masks
mDBGMFR_MC0:        equ    %00000001
mDBGMFR_MC1:        equ    %00000010
mDBGMFR_MC2:        equ    %00000100


;*** DBGXCTL - Debug Comparator Control Register; 0x00000028 ***
DBGXCTL:            equ    $00000028                                ;*** DBGXCTL - Debug Comparator Control Register; 0x00000028 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGXCTL_COMPE:      equ    0                                         ; Determines if comparator is enabled
DBGXCTL_RWE:        equ    2                                         ; Read/Write Enable Bit
DBGXCTL_RW:         equ    3                                         ; Read/Write Comparator Value Bit
DBGXCTL_TAG:        equ    5                                         ; Tag select
DBGXCTL_NDB_SZ:     equ    6                                         ; Not Data Bus Compare (for comparators A and C), Size Comparator Value Bit (for comparators B and D)
DBGXCTL_SZE:        equ    7                                         ; Size Comparator Enable Bit (for comparators B and D)
; bit position masks
mDBGXCTL_COMPE:     equ    %00000001
mDBGXCTL_RWE:       equ    %00000100
mDBGXCTL_RW:        equ    %00001000
mDBGXCTL_TAG:       equ    %00100000
mDBGXCTL_NDB_SZ:    equ    %01000000
mDBGXCTL_SZE:       equ    %10000000


;*** DBGXAH - Debug Comparator Address High Register; 0x00000029 ***
DBGXAH:             equ    $00000029                                ;*** DBGXAH - Debug Comparator Address High Register; 0x00000029 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGXAH_BIT16:       equ    0                                         ; Comparator Address High Compare Bit 16
DBGXAH_BIT17:       equ    1                                         ; Comparator Address High Compare Bit 17
; bit position masks
mDBGXAH_BIT16:      equ    %00000001
mDBGXAH_BIT17:      equ    %00000010


;*** DBGXAM - Debug Comparator Address Mid Register; 0x0000002A ***
DBGXAM:             equ    $0000002A                                ;*** DBGXAM - Debug Comparator Address Mid Register; 0x0000002A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGXAM_BIT8:        equ    0                                         ; Comparator Address Mid Compare Bit 8
DBGXAM_BIT9:        equ    1                                         ; Comparator Address Mid Compare Bit 9
DBGXAM_BIT10:       equ    2                                         ; Comparator Address Mid Compare Bit 10
DBGXAM_BIT11:       equ    3                                         ; Comparator Address Mid Compare Bit 11
DBGXAM_BIT12:       equ    4                                         ; Comparator Address Mid Compare Bit 12
DBGXAM_BIT13:       equ    5                                         ; Comparator Address Mid Compare Bit 13
DBGXAM_BIT14:       equ    6                                         ; Comparator Address Mid Compare Bit 14
DBGXAM_BIT15:       equ    7                                         ; Comparator Address Mid Compare Bit 15
; bit position masks
mDBGXAM_BIT8:       equ    %00000001
mDBGXAM_BIT9:       equ    %00000010
mDBGXAM_BIT10:      equ    %00000100
mDBGXAM_BIT11:      equ    %00001000
mDBGXAM_BIT12:      equ    %00010000
mDBGXAM_BIT13:      equ    %00100000
mDBGXAM_BIT14:      equ    %01000000
mDBGXAM_BIT15:      equ    %10000000


;*** DBGXAL - Debug Comparator Address Low Register; 0x0000002B ***
DBGXAL:             equ    $0000002B                                ;*** DBGXAL - Debug Comparator Address Low Register; 0x0000002B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGXAL_BIT0:        equ    0                                         ; Comparator Address Low Compare Bit 0
DBGXAL_BIT1:        equ    1                                         ; Comparator Address Low Compare Bit 1
DBGXAL_BIT2:        equ    2                                         ; Comparator Address Low Compare Bit 2
DBGXAL_BIT3:        equ    3                                         ; Comparator Address Low Compare Bit 3
DBGXAL_BIT4:        equ    4                                         ; Comparator Address Low Compare Bit 4
DBGXAL_BIT5:        equ    5                                         ; Comparator Address Low Compare Bit 5
DBGXAL_BIT6:        equ    6                                         ; Comparator Address Low Compare Bit 6
DBGXAL_BIT7:        equ    7                                         ; Comparator Address Low Compare Bit 7
; bit position masks
mDBGXAL_BIT0:       equ    %00000001
mDBGXAL_BIT1:       equ    %00000010
mDBGXAL_BIT2:       equ    %00000100
mDBGXAL_BIT3:       equ    %00001000
mDBGXAL_BIT4:       equ    %00010000
mDBGXAL_BIT5:       equ    %00100000
mDBGXAL_BIT6:       equ    %01000000
mDBGXAL_BIT7:       equ    %10000000


;*** DBGADH - Debug Comparator Data High Register; 0x0000002C ***
DBGADH:             equ    $0000002C                                ;*** DBGADH - Debug Comparator Data High Register; 0x0000002C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGADH_BIT0:        equ    0                                         ; Comparator A Compare Bit 0
DBGADH_BIT1:        equ    1                                         ; Comparator A Compare Bit 1
DBGADH_BIT2:        equ    2                                         ; Comparator A Compare Bit 2
DBGADH_BIT3:        equ    3                                         ; Comparator A Compare Bit 3
DBGADH_BIT4:        equ    4                                         ; Comparator A Compare Bit 4
DBGADH_BIT5:        equ    5                                         ; Comparator A Compare Bit 5
DBGADH_BIT6:        equ    6                                         ; Comparator A Compare Bit 6
DBGADH_BIT7:        equ    7                                         ; Comparator A Compare Bit 7
; bit position masks
mDBGADH_BIT0:       equ    %00000001
mDBGADH_BIT1:       equ    %00000010
mDBGADH_BIT2:       equ    %00000100
mDBGADH_BIT3:       equ    %00001000
mDBGADH_BIT4:       equ    %00010000
mDBGADH_BIT5:       equ    %00100000
mDBGADH_BIT6:       equ    %01000000
mDBGADH_BIT7:       equ    %10000000


;*** DBGADL - Debug Comparator Data Low Register; 0x0000002D ***
DBGADL:             equ    $0000002D                                ;*** DBGADL - Debug Comparator Data Low Register; 0x0000002D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGADL_BIT0:        equ    0                                         ; Comparator Address Low Compare Bit 0
DBGADL_BIT1:        equ    1                                         ; Comparator Address Low Compare Bit 1
DBGADL_BIT2:        equ    2                                         ; Comparator Address Low Compare Bit 2
DBGADL_BIT3:        equ    3                                         ; Comparator Address Low Compare Bit 3
DBGADL_BIT4:        equ    4                                         ; Comparator Address Low Compare Bit 4
DBGADL_BIT5:        equ    5                                         ; Comparator Address Low Compare Bit 5
DBGADL_BIT6:        equ    6                                         ; Comparator Address Low Compare Bit 6
DBGADL_BIT7:        equ    7                                         ; Comparator Address Low Compare Bit 7
; bit position masks
mDBGADL_BIT0:       equ    %00000001
mDBGADL_BIT1:       equ    %00000010
mDBGADL_BIT2:       equ    %00000100
mDBGADL_BIT3:       equ    %00001000
mDBGADL_BIT4:       equ    %00010000
mDBGADL_BIT5:       equ    %00100000
mDBGADL_BIT6:       equ    %01000000
mDBGADL_BIT7:       equ    %10000000


;*** DBGADHM - Debug Comparator Data High Mask Register; 0x0000002E ***
DBGADHM:            equ    $0000002E                                ;*** DBGADHM - Debug Comparator Data High Mask Register; 0x0000002E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGADHM_BIT8:       equ    0                                         ; Comparator Data High Mask Bit 8
DBGADHM_BIT9:       equ    1                                         ; Comparator Data High Mask Bit 9
DBGADHM_BIT10:      equ    2                                         ; Comparator Data High Mask Bit 10
DBGADHM_BIT11:      equ    3                                         ; Comparator Data High Mask Bit 11
DBGADHM_BIT12:      equ    4                                         ; Comparator Data High Mask Bit 12
DBGADHM_BIT13:      equ    5                                         ; Comparator Data High Mask Bit 13
DBGADHM_BIT14:      equ    6                                         ; Comparator Data High Mask Bit 14
DBGADHM_BIT15:      equ    7                                         ; Comparator Data High Mask Bit 15
; bit position masks
mDBGADHM_BIT8:      equ    %00000001
mDBGADHM_BIT9:      equ    %00000010
mDBGADHM_BIT10:     equ    %00000100
mDBGADHM_BIT11:     equ    %00001000
mDBGADHM_BIT12:     equ    %00010000
mDBGADHM_BIT13:     equ    %00100000
mDBGADHM_BIT14:     equ    %01000000
mDBGADHM_BIT15:     equ    %10000000


;*** DBGADLM - Debug Comparator Data Low Mask Register; 0x0000002F ***
DBGADLM:            equ    $0000002F                                ;*** DBGADLM - Debug Comparator Data Low Mask Register; 0x0000002F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGADLM_BIT0:       equ    0                                         ; Comparator Data High Mask Bit 0
DBGADLM_BIT1:       equ    1                                         ; Comparator Data High Mask Bit 1
DBGADLM_BIT2:       equ    2                                         ; Comparator Data High Mask Bit 2
DBGADLM_BIT3:       equ    3                                         ; Comparator Data High Mask Bit 3
DBGADLM_BIT4:       equ    4                                         ; Comparator Data High Mask Bit 4
DBGADLM_BIT5:       equ    5                                         ; Comparator Data High Mask Bit 5
DBGADLM_BIT6:       equ    6                                         ; Comparator Data High Mask Bit 6
DBGADLM_BIT7:       equ    7                                         ; Comparator Data High Mask Bit 7
; bit position masks
mDBGADLM_BIT0:      equ    %00000001
mDBGADLM_BIT1:      equ    %00000010
mDBGADLM_BIT2:      equ    %00000100
mDBGADLM_BIT3:      equ    %00001000
mDBGADLM_BIT4:      equ    %00010000
mDBGADLM_BIT5:      equ    %00100000
mDBGADLM_BIT6:      equ    %01000000
mDBGADLM_BIT7:      equ    %10000000


;*** PPAGE - Page Index Register; 0x00000030 ***
PPAGE:              equ    $00000030                                ;*** PPAGE - Page Index Register; 0x00000030 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PPAGE_PIX0:         equ    0                                         ; Page Index Register Bit 0
PPAGE_PIX1:         equ    1                                         ; Page Index Register Bit 1
PPAGE_PIX2:         equ    2                                         ; Page Index Register Bit 2
PPAGE_PIX3:         equ    3                                         ; Page Index Register Bit 3
; bit position masks
mPPAGE_PIX0:        equ    %00000001
mPPAGE_PIX1:        equ    %00000010
mPPAGE_PIX2:        equ    %00000100
mPPAGE_PIX3:        equ    %00001000


;*** DIRECT - Direct Page Register; 0x00000031 ***
DIRECT:             equ    $00000031                                ;*** DIRECT - Direct Page Register; 0x00000031 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DIRECT_DP8:         equ    0                                         ; Direct Page Bit 8
DIRECT_DP9:         equ    1                                         ; Direct Page Bit 9
DIRECT_DP10:        equ    2                                         ; Direct Page Bit 10
DIRECT_DP11:        equ    3                                         ; Direct Page Bit 11
DIRECT_DP12:        equ    4                                         ; Direct Page Bit 12
DIRECT_DP13:        equ    5                                         ; Direct Page Bit 13
DIRECT_DP14:        equ    6                                         ; Direct Page Bit 14
DIRECT_DP15:        equ    7                                         ; Direct Page Bit 15
; bit position masks
mDIRECT_DP8:        equ    %00000001
mDIRECT_DP9:        equ    %00000010
mDIRECT_DP10:       equ    %00000100
mDIRECT_DP11:       equ    %00001000
mDIRECT_DP12:       equ    %00010000
mDIRECT_DP13:       equ    %00100000
mDIRECT_DP14:       equ    %01000000
mDIRECT_DP15:       equ    %10000000


;*** MODE - Mode Register; 0x00000032 ***
MODE:               equ    $00000032                                ;*** MODE - Mode Register; 0x00000032 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MODE_MODC:          equ    7                                         ; Mode Select Bit C
; bit position masks
mMODE_MODC:         equ    %10000000


;*** MMCCTL1 - MMCCTL1 Register; 0x00000033 ***
MMCCTL1:            equ    $00000033                                ;*** MMCCTL1 - MMCCTL1 Register; 0x00000033 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MMCCTL1_IFRON:      equ    0                                         ; IFRON
; bit position masks
mMMCCTL1_IFRON:     equ    %00000001


;*** CRGCTL0 - S12SCRG Control Register 0; 0x00000034 ***
CRGCTL0:            equ    $00000034                                ;*** CRGCTL0 - S12SCRG Control Register 0; 0x00000034 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CRGCTL0_OSC4MHZ:    equ    1                                         ; 4MHz Oscillator low pass filter select Bit
CRGCTL0_REFS:       equ    2                                         ; Reference Select Bit
CRGCTL0_BCLKS:      equ    3                                         ; Bus Clock Source Select Bit
CRGCTL0_RDIV0:      equ    4                                         ; Reference Divider Bits, bit 0
CRGCTL0_RDIV1:      equ    5                                         ; Reference Divider Bits, bit 1
CRGCTL0_RDIV2:      equ    6                                         ; Reference Divider Bits, bit 2
CRGCTL0_OSCEN:      equ    7                                         ; Oscillator Enable Bit
; bit position masks
mCRGCTL0_OSC4MHZ:   equ    %00000010
mCRGCTL0_REFS:      equ    %00000100
mCRGCTL0_BCLKS:     equ    %00001000
mCRGCTL0_RDIV0:     equ    %00010000
mCRGCTL0_RDIV1:     equ    %00100000
mCRGCTL0_RDIV2:     equ    %01000000
mCRGCTL0_OSCEN:     equ    %10000000


;*** CRGCTL1 - S12SCRG Control Register 1; 0x00000035 ***
CRGCTL1:            equ    $00000035                                ;*** CRGCTL1 - S12SCRG Control Register 1; 0x00000035 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CRGCTL1_LOCKIE:     equ    1                                         ; FLL Lock Interrupt Enable Bit
CRGCTL1_BDIV0:      equ    4                                         ; Bus Divider Bits, bit 0
CRGCTL1_BDIV1:      equ    5                                         ; Bus Divider Bits, bit 1
CRGCTL1_BDIV2:      equ    6                                         ; Bus Divider Bits, bit 2
CRGCTL1_BDIV3:      equ    7                                         ; Bus Divider Bits, bit 3
; bit position masks
mCRGCTL1_LOCKIE:    equ    %00000010
mCRGCTL1_BDIV0:     equ    %00010000
mCRGCTL1_BDIV1:     equ    %00100000
mCRGCTL1_BDIV2:     equ    %01000000
mCRGCTL1_BDIV3:     equ    %10000000


;*** CRGMULT - S12SCRG FLL Multiply Register; 0x00000036 ***
CRGMULT:            equ    $00000036                                ;*** CRGMULT - S12SCRG FLL Multiply Register; 0x00000036 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CRGMULT_MULT0:      equ    0                                         ; FLL Multiplier Bits, bit 0
CRGMULT_MULT1:      equ    1                                         ; FLL Multiplier Bits, bit 1
CRGMULT_MULT2:      equ    2                                         ; FLL Multiplier Bits, bit 2
CRGMULT_MULT3:      equ    3                                         ; FLL Multiplier Bits, bit 3
CRGMULT_MULT4:      equ    4                                         ; FLL Multiplier Bits, bit 4
CRGMULT_MULT5:      equ    5                                         ; FLL Multiplier Bits, bit 5
CRGMULT_MULT6:      equ    6                                         ; FLL Multiplier Bits, bit 6
; bit position masks
mCRGMULT_MULT0:     equ    %00000001
mCRGMULT_MULT1:     equ    %00000010
mCRGMULT_MULT2:     equ    %00000100
mCRGMULT_MULT3:     equ    %00001000
mCRGMULT_MULT4:     equ    %00010000
mCRGMULT_MULT5:     equ    %00100000
mCRGMULT_MULT6:     equ    %01000000


;*** CRGFLG - S12SCRG Flags Register; 0x00000037 ***
CRGFLG:             equ    $00000037                                ;*** CRGFLG - S12SCRG Flags Register; 0x00000037 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CRGFLG_UPOSC:       equ    1                                         ; Oscillator Startup Status Bit
CRGFLG_ILAF:        equ    2                                         ; Illegal Address Reset Flag
CRGFLG_LOCKST:      equ    3                                         ; Lock Status Bit
CRGFLG_LOCKIF:      equ    4                                         ; FLL Lock Interrupt Flag
CRGFLG_PORF:        equ    6                                         ; Power-On Reset Flag
; bit position masks
mCRGFLG_UPOSC:      equ    %00000010
mCRGFLG_ILAF:       equ    %00000100
mCRGFLG_LOCKST:     equ    %00001000
mCRGFLG_LOCKIF:     equ    %00010000
mCRGFLG_PORF:       equ    %01000000


;*** CRGTRIM - S12SCRG TRIM Register High; 0x00000038 ***
CRGTRIM:            equ    $00000038                                ;*** CRGTRIM - S12SCRG TRIM Register High; 0x00000038 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CRGTRIM_TRIM0:      equ    0                                         ; Trim Bit 0 for Internal Reference Clock
CRGTRIM_TRIM1:      equ    1                                         ; Trim Bit 1 for Internal Reference Clock
CRGTRIM_TRIM2:      equ    2                                         ; Trim Bit 2 for Internal Reference Clock
CRGTRIM_TRIM3:      equ    3                                         ; Trim Bit 3 for Internal Reference Clock
CRGTRIM_TRIM4:      equ    4                                         ; Trim Bit 4 for Internal Reference Clock
CRGTRIM_TRIM5:      equ    5                                         ; Trim Bit 5 for Internal Reference Clock
CRGTRIM_TRIM6:      equ    6                                         ; Trim Bit 6 for Internal Reference Clock
CRGTRIM_TRIM7:      equ    7                                         ; Trim Bit 7 for Internal Reference Clock
CRGTRIM_TRIM8:      equ    8                                         ; Trim Bit 8 for Internal Reference Clock
; bit position masks
mCRGTRIM_TRIM0:     equ    %00000001
mCRGTRIM_TRIM1:     equ    %00000010
mCRGTRIM_TRIM2:     equ    %00000100
mCRGTRIM_TRIM3:     equ    %00001000
mCRGTRIM_TRIM4:     equ    %00010000
mCRGTRIM_TRIM5:     equ    %00100000
mCRGTRIM_TRIM6:     equ    %01000000
mCRGTRIM_TRIM7:     equ    %10000000
mCRGTRIM_TRIM8:     equ    %100000000


;*** CRGTRIMH - S12SCRG TRIM Register High Byte; 0x00000038 ***
CRGTRIMH:           equ    $00000038                                ;*** CRGTRIMH - S12SCRG TRIM Register High Byte; 0x00000038 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CRGTRIMH_TRIM8:     equ    0                                         ; Trim Bit 8 for Internal Reference Clock
; bit position masks
mCRGTRIMH_TRIM8:    equ    %00000001


;*** CRGTRIML - S12SCRG Trim Register Low Byte; 0x00000039 ***
CRGTRIML:           equ    $00000039                                ;*** CRGTRIML - S12SCRG Trim Register Low Byte; 0x00000039 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CRGTRIML_TRIM0:     equ    0                                         ; Trim Bit 0 for Internal Reference Clock
CRGTRIML_TRIM1:     equ    1                                         ; Trim Bit 1 for Internal Reference Clock
CRGTRIML_TRIM2:     equ    2                                         ; Trim Bit 2 for Internal Reference Clock
CRGTRIML_TRIM3:     equ    3                                         ; Trim Bit 3 for Internal Reference Clock
CRGTRIML_TRIM4:     equ    4                                         ; Trim Bit 4 for Internal Reference Clock
CRGTRIML_TRIM5:     equ    5                                         ; Trim Bit 5 for Internal Reference Clock
CRGTRIML_TRIM6:     equ    6                                         ; Trim Bit 6 for Internal Reference Clock
CRGTRIML_TRIM7:     equ    7                                         ; Trim Bit 7 for Internal Reference Clock
; bit position masks
mCRGTRIML_TRIM0:    equ    %00000001
mCRGTRIML_TRIM1:    equ    %00000010
mCRGTRIML_TRIM2:    equ    %00000100
mCRGTRIML_TRIM3:    equ    %00001000
mCRGTRIML_TRIM4:    equ    %00010000
mCRGTRIML_TRIM5:    equ    %00100000
mCRGTRIML_TRIM6:    equ    %01000000
mCRGTRIML_TRIM7:    equ    %10000000


;*** RTICTL - CRG RTI Control Register; 0x0000003C ***
RTICTL:             equ    $0000003C                                ;*** RTICTL - CRG RTI Control Register; 0x0000003C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RTICTL_RTR0:        equ    0                                         ; Real Time Interrupt Modulus Counter Select Bit 0
RTICTL_RTR1:        equ    1                                         ; Real Time Interrupt Modulus Counter Select Bit 1
RTICTL_RTIE:        equ    2                                         ; Real Time Interrupt Enable Bit
RTICTL_RTIRSTP:     equ    3                                         ; RTI Runs in Stop Mode Bit
RTICTL_RTISWAI:     equ    4                                         ; RTI Stops in Wait Mode Bit
RTICTL_WRTMASK:     equ    5                                         ; Write Mask for RTIF, RTISWAI, RTIRSTP, RTIE and RTIRT[1:0] Bits
RTICTL_RTIFRZ:      equ    6                                         ; Real Time Interrupt Freeze
RTICTL_RTIF:        equ    7                                         ; Real Time Interrupt Flag
; bit position masks
mRTICTL_RTR0:       equ    %00000001
mRTICTL_RTR1:       equ    %00000010
mRTICTL_RTIE:       equ    %00000100
mRTICTL_RTIRSTP:    equ    %00001000
mRTICTL_RTISWAI:    equ    %00010000
mRTICTL_WRTMASK:    equ    %00100000
mRTICTL_RTIFRZ:     equ    %01000000
mRTICTL_RTIF:       equ    %10000000


;*** RTICNT - RTI Counter select bits; 0x0000003D ***
RTICNT:             equ    $0000003D                                ;*** RTICNT - RTI Counter select bits; 0x0000003D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RTICNT_RTICNT0:     equ    0                                         ; RTI Counter select bit 0
RTICNT_RTICNT1:     equ    1                                         ; RTI Counter select bit 1
RTICNT_RTICNT2:     equ    2                                         ; RTI Counter select bit 2
RTICNT_RTICNT3:     equ    3                                         ; RTI Counter select bit 3
RTICNT_RTICNT4:     equ    4                                         ; RTI Counter select bit 4
RTICNT_RTICNT5:     equ    5                                         ; RTI Counter select bit 5
RTICNT_RTICNT6:     equ    6                                         ; RTI Counter select bit 6
RTICNT_RTICNT7:     equ    7                                         ; RTI Counter select bit 7
; bit position masks
mRTICNT_RTICNT0:    equ    %00000001
mRTICNT_RTICNT1:    equ    %00000010
mRTICNT_RTICNT2:    equ    %00000100
mRTICNT_RTICNT3:    equ    %00001000
mRTICNT_RTICNT4:    equ    %00010000
mRTICNT_RTICNT5:    equ    %00100000
mRTICNT_RTICNT6:    equ    %01000000
mRTICNT_RTICNT7:    equ    %10000000


;*** COPCTL - CRG COP Control Register; 0x0000003E ***
COPCTL:             equ    $0000003E                                ;*** COPCTL - CRG COP Control Register; 0x0000003E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
COPCTL_CR0:         equ    0                                         ; COP Watchdog Timer Rate select Bit 0
COPCTL_CR1:         equ    1                                         ; COP Watchdog Timer Rate select Bit 1
COPCTL_CR2:         equ    2                                         ; COP Watchdog Timer Rate select Bit 2
COPCTL_COPRSTP:     equ    3                                         ; COP Runs in Stop Mode Bit
COPCTL_COPSWAI:     equ    4                                         ; COP Stops in Wait Mode Bit
COPCTL_WRTMASK:     equ    5                                         ; Write Mask for WCOP and CR[2:0] Bit
COPCTL_RSBCK:       equ    6                                         ; COP and RTI stop in Active BDM mode Bit
COPCTL_WCOP:        equ    7                                         ; Window COP mode
; bit position masks
mCOPCTL_CR0:        equ    %00000001
mCOPCTL_CR1:        equ    %00000010
mCOPCTL_CR2:        equ    %00000100
mCOPCTL_COPRSTP:    equ    %00001000
mCOPCTL_COPSWAI:    equ    %00010000
mCOPCTL_WRTMASK:    equ    %00100000
mCOPCTL_RSBCK:      equ    %01000000
mCOPCTL_WCOP:       equ    %10000000


;*** ARMCOP - CRG COP Timer Arm/Reset Register; 0x0000003F ***
ARMCOP:             equ    $0000003F                                ;*** ARMCOP - CRG COP Timer Arm/Reset Register; 0x0000003F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ARMCOP_BIT0:        equ    0                                         ; CRG COP Timer Arm/Reset Bit 0
ARMCOP_BIT1:        equ    1                                         ; CRG COP Timer Arm/Reset Bit 1
ARMCOP_BIT2:        equ    2                                         ; CRG COP Timer Arm/Reset Bit 2
ARMCOP_BIT3:        equ    3                                         ; CRG COP Timer Arm/Reset Bit 3
ARMCOP_BIT4:        equ    4                                         ; CRG COP Timer Arm/Reset Bit 4
ARMCOP_BIT5:        equ    5                                         ; CRG COP Timer Arm/Reset Bit 5
ARMCOP_BIT6:        equ    6                                         ; CRG COP Timer Arm/Reset Bit 6
ARMCOP_BIT7:        equ    7                                         ; CRG COP Timer Arm/Reset Bit 7
; bit position masks
mARMCOP_BIT0:       equ    %00000001
mARMCOP_BIT1:       equ    %00000010
mARMCOP_BIT2:       equ    %00000100
mARMCOP_BIT3:       equ    %00001000
mARMCOP_BIT4:       equ    %00010000
mARMCOP_BIT5:       equ    %00100000
mARMCOP_BIT6:       equ    %01000000
mARMCOP_BIT7:       equ    %10000000


;*** D2DCTL0 - D2DI Control Register 0; 0x000000D8 ***
D2DCTL0:            equ    $000000D8                                ;*** D2DCTL0 - D2DI Control Register 0; 0x000000D8 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
D2DCTL0_D2DCLKDIV0: equ    0                                         ; Interface Clock Divider, bit 0
D2DCTL0_D2DCLKDIV1: equ    1                                         ; Interface Clock Divider, bit 1
D2DCTL0_D2DSWAI:    equ    5                                         ; D2D Stop In Wait
D2DCTL0_D2DCW:      equ    6                                         ; D2D Connection Width
D2DCTL0_D2DEN:      equ    7                                         ; D2DI Enable
; bit position masks
mD2DCTL0_D2DCLKDIV0: equ    %00000001
mD2DCTL0_D2DCLKDIV1: equ    %00000010
mD2DCTL0_D2DSWAI:   equ    %00100000
mD2DCTL0_D2DCW:     equ    %01000000
mD2DCTL0_D2DEN:     equ    %10000000


;*** D2DCTL1 - D2DI Control Register 1; 0x000000D9 ***
D2DCTL1:            equ    $000000D9                                ;*** D2DCTL1 - D2DI Control Register 1; 0x000000D9 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
D2DCTL1_TIMOUT0:    equ    0                                         ; Time-out Setting, bit 0
D2DCTL1_TIMOUT1:    equ    1                                         ; Time-out Setting, bit 1
D2DCTL1_TIMOUT2:    equ    2                                         ; Time-out Setting, bit 2
D2DCTL1_TIMOUT3:    equ    3                                         ; Time-out Setting, bit 3
D2DCTL1_D2DIE:      equ    7                                         ; D2D Interrupt Enable
; bit position masks
mD2DCTL1_TIMOUT0:   equ    %00000001
mD2DCTL1_TIMOUT1:   equ    %00000010
mD2DCTL1_TIMOUT2:   equ    %00000100
mD2DCTL1_TIMOUT3:   equ    %00001000
mD2DCTL1_D2DIE:     equ    %10000000


;*** D2DSTAT0 - D2DI Status Register 0; 0x000000DA ***
D2DSTAT0:           equ    $000000DA                                ;*** D2DSTAT0 - D2DI Status Register 0; 0x000000DA ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
D2DSTAT0_PAR0:      equ    0                                         ; Parity Bit 0
D2DSTAT0_PAR1:      equ    1                                         ; Parity Bit 1
D2DSTAT0_PARF:      equ    2                                         ; Parity Error Flag
D2DSTAT0_TERRF:     equ    3                                         ; Transaction Error Flag
D2DSTAT0_TIMEF:     equ    4                                         ; Time Out Error Flag
D2DSTAT0_CNCLF:     equ    5                                         ; CNCLF
D2DSTAT0_ACKERF:    equ    6                                         ; Acknowledge Error Flag
D2DSTAT0_ERRIF:     equ    7                                         ; D2DI error interrupt flag
; bit position masks
mD2DSTAT0_PAR0:     equ    %00000001
mD2DSTAT0_PAR1:     equ    %00000010
mD2DSTAT0_PARF:     equ    %00000100
mD2DSTAT0_TERRF:    equ    %00001000
mD2DSTAT0_TIMEF:    equ    %00010000
mD2DSTAT0_CNCLF:    equ    %00100000
mD2DSTAT0_ACKERF:   equ    %01000000
mD2DSTAT0_ERRIF:    equ    %10000000


;*** D2DSTAT1 - D2DI Status Register 1; 0x000000DB ***
D2DSTAT1:           equ    $000000DB                                ;*** D2DSTAT1 - D2DI Status Register 1; 0x000000DB ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
D2DSTAT1_D2DBSY:    equ    6                                         ; D2D Initiator Busy
D2DSTAT1_D2DIF:     equ    7                                         ; D2D Interrupt Flag
; bit position masks
mD2DSTAT1_D2DBSY:   equ    %01000000
mD2DSTAT1_D2DIF:    equ    %10000000


;*** D2DADR - D2DI Address Buffer Register; 0x000000DC ***
D2DADR:             equ    $000000DC                                ;*** D2DADR - D2DI Address Buffer Register; 0x000000DC ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
D2DADR_ADR0:        equ    0                                         ; Transaction Address Bit 0
D2DADR_ADR1:        equ    1                                         ; Transaction Address Bit 1
D2DADR_ADR2:        equ    2                                         ; Transaction Address Bit 2
D2DADR_ADR3:        equ    3                                         ; Transaction Address Bit 3
D2DADR_ADR4:        equ    4                                         ; Transaction Address Bit 4
D2DADR_ADR5:        equ    5                                         ; Transaction Address Bit 5
D2DADR_ADR6:        equ    6                                         ; Transaction Address Bit 6
D2DADR_ADR7:        equ    7                                         ; Transaction Address Bit 7
D2DADR_NBLK:        equ    12                                        ; Transaction Mode
D2DADR_SZ8:         equ    14                                        ; Transaction Size
D2DADR_RWB:         equ    15                                        ; Transaction Read-Write Direction
; bit position masks
mD2DADR_ADR0:       equ    %00000001
mD2DADR_ADR1:       equ    %00000010
mD2DADR_ADR2:       equ    %00000100
mD2DADR_ADR3:       equ    %00001000
mD2DADR_ADR4:       equ    %00010000
mD2DADR_ADR5:       equ    %00100000
mD2DADR_ADR6:       equ    %01000000
mD2DADR_ADR7:       equ    %10000000
mD2DADR_NBLK:       equ    %1000000000000
mD2DADR_SZ8:        equ    %100000000000000
mD2DADR_RWB:        equ    %1000000000000000


;*** D2DADRHI - D2DI Address Buffer Register High; 0x000000DC ***
D2DADRHI:           equ    $000000DC                                ;*** D2DADRHI - D2DI Address Buffer Register High; 0x000000DC ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
D2DADRHI_NBLK:      equ    4                                         ; Transaction Mode
D2DADRHI_SZ8:       equ    6                                         ; Transaction Size
D2DADRHI_RWB:       equ    7                                         ; Transaction Read-Write Direction
; bit position masks
mD2DADRHI_NBLK:     equ    %00010000
mD2DADRHI_SZ8:      equ    %01000000
mD2DADRHI_RWB:      equ    %10000000


;*** D2DADRLO - D2DI Address Buffer Register Low; 0x000000DD ***
D2DADRLO:           equ    $000000DD                                ;*** D2DADRLO - D2DI Address Buffer Register Low; 0x000000DD ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
D2DADRLO_ADR0:      equ    0                                         ; Transaction Address Bit 0
D2DADRLO_ADR1:      equ    1                                         ; Transaction Address Bit 1
D2DADRLO_ADR2:      equ    2                                         ; Transaction Address Bit 2
D2DADRLO_ADR3:      equ    3                                         ; Transaction Address Bit 3
D2DADRLO_ADR4:      equ    4                                         ; Transaction Address Bit 4
D2DADRLO_ADR5:      equ    5                                         ; Transaction Address Bit 5
D2DADRLO_ADR6:      equ    6                                         ; Transaction Address Bit 6
D2DADRLO_ADR7:      equ    7                                         ; Transaction Address Bit 7
; bit position masks
mD2DADRLO_ADR0:     equ    %00000001
mD2DADRLO_ADR1:     equ    %00000010
mD2DADRLO_ADR2:     equ    %00000100
mD2DADRLO_ADR3:     equ    %00001000
mD2DADRLO_ADR4:     equ    %00010000
mD2DADRLO_ADR5:     equ    %00100000
mD2DADRLO_ADR6:     equ    %01000000
mD2DADRLO_ADR7:     equ    %10000000


;*** D2DDATA - D2DI Data Buffer Register; 0x000000DE ***
D2DDATA:            equ    $000000DE                                ;*** D2DDATA - D2DI Data Buffer Register; 0x000000DE ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
D2DDATA_DATA0:      equ    0                                         ; Transaction Data, bit 0
D2DDATA_DATA1:      equ    1                                         ; Transaction Data, bit 1
D2DDATA_DATA2:      equ    2                                         ; Transaction Data, bit 2
D2DDATA_DATA3:      equ    3                                         ; Transaction Data, bit 3
D2DDATA_DATA4:      equ    4                                         ; Transaction Data, bit 4
D2DDATA_DATA5:      equ    5                                         ; Transaction Data, bit 5
D2DDATA_DATA6:      equ    6                                         ; Transaction Data, bit 6
D2DDATA_DATA7:      equ    7                                         ; Transaction Data, bit 7
D2DDATA_DATA8:      equ    8                                         ; Transaction Data, bit 8
D2DDATA_DATA9:      equ    9                                         ; Transaction Data, bit 9
D2DDATA_DATA10:     equ    10                                        ; Transaction Data, bit 10
D2DDATA_DATA11:     equ    11                                        ; Transaction Data, bit 11
D2DDATA_DATA12:     equ    12                                        ; Transaction Data, bit 12
D2DDATA_DATA13:     equ    13                                        ; Transaction Data, bit 13
D2DDATA_DATA14:     equ    14                                        ; Transaction Data, bit 14
D2DDATA_DATA15:     equ    15                                        ; Transaction Data, bit 15
; bit position masks
mD2DDATA_DATA0:     equ    %00000001
mD2DDATA_DATA1:     equ    %00000010
mD2DDATA_DATA2:     equ    %00000100
mD2DDATA_DATA3:     equ    %00001000
mD2DDATA_DATA4:     equ    %00010000
mD2DDATA_DATA5:     equ    %00100000
mD2DDATA_DATA6:     equ    %01000000
mD2DDATA_DATA7:     equ    %10000000
mD2DDATA_DATA8:     equ    %100000000
mD2DDATA_DATA9:     equ    %1000000000
mD2DDATA_DATA10:    equ    %10000000000
mD2DDATA_DATA11:    equ    %100000000000
mD2DDATA_DATA12:    equ    %1000000000000
mD2DDATA_DATA13:    equ    %10000000000000
mD2DDATA_DATA14:    equ    %100000000000000
mD2DDATA_DATA15:    equ    %1000000000000000


;*** D2DDATAHI - D2DI Data Buffer Register High; 0x000000DE ***
D2DDATAHI:          equ    $000000DE                                ;*** D2DDATAHI - D2DI Data Buffer Register High; 0x000000DE ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
D2DDATAHI_DATA8:    equ    0                                         ; Transaction Data Bit 8
D2DDATAHI_DATA9:    equ    1                                         ; Transaction Data Bit 9
D2DDATAHI_DATA10:   equ    2                                         ; Transaction Data Bit 10
D2DDATAHI_DATA11:   equ    3                                         ; Transaction Data Bit 11
D2DDATAHI_DATA12:   equ    4                                         ; Transaction Data Bit 12
D2DDATAHI_DATA13:   equ    5                                         ; Transaction Data Bit 13
D2DDATAHI_DATA14:   equ    6                                         ; Transaction Data Bit 14
D2DDATAHI_DATA15:   equ    7                                         ; Transaction Data Bit 15
; bit position masks
mD2DDATAHI_DATA8:   equ    %00000001
mD2DDATAHI_DATA9:   equ    %00000010
mD2DDATAHI_DATA10:  equ    %00000100
mD2DDATAHI_DATA11:  equ    %00001000
mD2DDATAHI_DATA12:  equ    %00010000
mD2DDATAHI_DATA13:  equ    %00100000
mD2DDATAHI_DATA14:  equ    %01000000
mD2DDATAHI_DATA15:  equ    %10000000


;*** D2DDATALO - D2DI Data Buffer Register Low; 0x000000DF ***
D2DDATALO:          equ    $000000DF                                ;*** D2DDATALO - D2DI Data Buffer Register Low; 0x000000DF ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
D2DDATALO_DATA0:    equ    0                                         ; Transaction Data, bit 0
D2DDATALO_DATA1:    equ    1                                         ; Transaction Data, bit 1
D2DDATALO_DATA2:    equ    2                                         ; Transaction Data, bit 2
D2DDATALO_DATA3:    equ    3                                         ; Transaction Data, bit 3
D2DDATALO_DATA4:    equ    4                                         ; Transaction Data, bit 4
D2DDATALO_DATA5:    equ    5                                         ; Transaction Data, bit 5
D2DDATALO_DATA6:    equ    6                                         ; Transaction Data, bit 6
D2DDATALO_DATA7:    equ    7                                         ; Transaction Data, bit 7
; bit position masks
mD2DDATALO_DATA0:   equ    %00000001
mD2DDATALO_DATA1:   equ    %00000010
mD2DDATALO_DATA2:   equ    %00000100
mD2DDATALO_DATA3:   equ    %00001000
mD2DDATALO_DATA4:   equ    %00010000
mD2DDATALO_DATA5:   equ    %00100000
mD2DDATALO_DATA6:   equ    %01000000
mD2DDATALO_DATA7:   equ    %10000000


;*** SPI0CR1 - SPI Control Register; 0x000000E8 ***
SPI0CR1:            equ    $000000E8                                ;*** SPI0CR1 - SPI Control Register; 0x000000E8 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPI0CR1_LSBFE:      equ    0                                         ; SPI LSB-First Enable
SPI0CR1_SSOE:       equ    1                                         ; Slave Select Output Enable
SPI0CR1_CPHA:       equ    2                                         ; SPI Clock Phase Bit
SPI0CR1_CPOL:       equ    3                                         ; SPI Clock Polarity Bit
SPI0CR1_MSTR:       equ    4                                         ; SPI Master/Slave Mode Select Bit
SPI0CR1_SPTIE:      equ    5                                         ; SPI Transmit Interrupt Enable
SPI0CR1_SPE:        equ    6                                         ; SPI System Enable Bit
SPI0CR1_SPIE:       equ    7                                         ; SPI Interrupt Enable Bit
; bit position masks
mSPI0CR1_LSBFE:     equ    %00000001
mSPI0CR1_SSOE:      equ    %00000010
mSPI0CR1_CPHA:      equ    %00000100
mSPI0CR1_CPOL:      equ    %00001000
mSPI0CR1_MSTR:      equ    %00010000
mSPI0CR1_SPTIE:     equ    %00100000
mSPI0CR1_SPE:       equ    %01000000
mSPI0CR1_SPIE:      equ    %10000000


;*** SPI0CR2 - SPI Control Register 2; 0x000000E9 ***
SPI0CR2:            equ    $000000E9                                ;*** SPI0CR2 - SPI Control Register 2; 0x000000E9 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPI0CR2_SPC0:       equ    0                                         ; Serial Pin Control Bit 0
SPI0CR2_SPISWAI:    equ    1                                         ; SPI Stop in Wait Mode Bit
SPI0CR2_BIDIROE:    equ    3                                         ; Output enable in the Bidirectional mode of operation
SPI0CR2_MODFEN:     equ    4                                         ; Mode Fault Enable Bit
; bit position masks
mSPI0CR2_SPC0:      equ    %00000001
mSPI0CR2_SPISWAI:   equ    %00000010
mSPI0CR2_BIDIROE:   equ    %00001000
mSPI0CR2_MODFEN:    equ    %00010000


;*** SPI0BR - SPI Baud Rate Register; 0x000000EA ***
SPI0BR:             equ    $000000EA                                ;*** SPI0BR - SPI Baud Rate Register; 0x000000EA ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPI0BR_SPR0:        equ    0                                         ; SPI Baud Rate Selection Bit 0
SPI0BR_SPR1:        equ    1                                         ; SPI Baud Rate Selection Bit 1
SPI0BR_SPR2:        equ    2                                         ; SPI Baud Rate Selection Bit 2
SPI0BR_SPPR0:       equ    4                                         ; SPI Baud Rate Preselection Bits 0
SPI0BR_SPPR1:       equ    5                                         ; SPI Baud Rate Preselection Bits 1
SPI0BR_SPPR2:       equ    6                                         ; SPI Baud Rate Preselection Bits 2
; bit position masks
mSPI0BR_SPR0:       equ    %00000001
mSPI0BR_SPR1:       equ    %00000010
mSPI0BR_SPR2:       equ    %00000100
mSPI0BR_SPPR0:      equ    %00010000
mSPI0BR_SPPR1:      equ    %00100000
mSPI0BR_SPPR2:      equ    %01000000


;*** SPI0SR - SPI Status Register; 0x000000EB ***
SPI0SR:             equ    $000000EB                                ;*** SPI0SR - SPI Status Register; 0x000000EB ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPI0SR_MODF:        equ    4                                         ; Mode Fault Flag
SPI0SR_SPTEF:       equ    5                                         ; SPI Transmit Empty Interrupt Flag
SPI0SR_SPIF:        equ    7                                         ; SPIF Receive Interrupt Flag
; bit position masks
mSPI0SR_MODF:       equ    %00010000
mSPI0SR_SPTEF:      equ    %00100000
mSPI0SR_SPIF:       equ    %10000000


;*** SPI0DR - SPI Data Register; 0x000000ED ***
SPI0DR:             equ    $000000ED                                ;*** SPI0DR - SPI Data Register; 0x000000ED ***


;*** PTIA - Port A Input Register; 0x00000120 ***
PTIA:               equ    $00000120                                ;*** PTIA - Port A Input Register; 0x00000120 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTIA_PTIA0:         equ    0                                         ; Port A input data bit 0
PTIA_PTIA1:         equ    1                                         ; Port A input data bit 1
PTIA_PTIA2:         equ    2                                         ; Port A input data bit 2
PTIA_PTIA3:         equ    3                                         ; Port A input data bit 3
PTIA_PTIA4:         equ    4                                         ; Port A input data bit 4
PTIA_PTIA5:         equ    5                                         ; Port A input data bit 5
; bit position masks
mPTIA_PTIA0:        equ    %00000001
mPTIA_PTIA1:        equ    %00000010
mPTIA_PTIA2:        equ    %00000100
mPTIA_PTIA3:        equ    %00001000
mPTIA_PTIA4:        equ    %00010000
mPTIA_PTIA5:        equ    %00100000


;*** RDRA - Port A Reduced Drive Register; 0x00000122 ***
RDRA:               equ    $00000122                                ;*** RDRA - Port A Reduced Drive Register; 0x00000122 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RDRA_RDRA0:         equ    0                                         ; Port A reduced drive bit 0
RDRA_RDRA1:         equ    1                                         ; Port A reduced drive bit 1
RDRA_RDRA2:         equ    2                                         ; Port A reduced drive bit 2
RDRA_RDRA3:         equ    3                                         ; Port A reduced drive bit 3
RDRA_RDRA4:         equ    4                                         ; Port A reduced drive bit 4
RDRA_RDRA5:         equ    5                                         ; Port A reduced drive bit 5
; bit position masks
mRDRA_RDRA0:        equ    %00000001
mRDRA_RDRA1:        equ    %00000010
mRDRA_RDRA2:        equ    %00000100
mRDRA_RDRA3:        equ    %00001000
mRDRA_RDRA4:        equ    %00010000
mRDRA_RDRA5:        equ    %00100000



;***********************************************
;**   D E P R E C I A T E D   S Y M B O L S   **
;***********************************************
        IFNDEF  __GENERATE_APPLICATION__                            ; not supported for absolute assembler
                    XREF    This_symb_has_been_depreciated
        ENDIF

; EOF
