/* Based on CPU DB MC9S12I32_44, version 2.87.056 (RegistersPrg V2.32) */
/*
** ###################################################################
**     Filename  : mc9s12i32.h
**     Processor : MC9S12I32
**     FileFormat: V2.32
**     DataSheet : MC9S12I32 Rev 2.1 5/2007
**     Compiler  : CodeWarrior compiler
**     Date/Time : 21.7.2010, 14:38
**     Abstract  :
**         This header implements the mapping of I/O devices.
**
**     Copyright : 1997 - 2010 Freescale Semiconductor, Inc. All Rights Reserved.
**     
**     http      : www.freescale.com
**     mail      : support@freescale.com
**
**     CPU Registers Revisions:
**      - 12.03.2008, V2.87.052:
**              - Bit RTIE added to RTICTL register
**      - 21.07.2010, V2.87.057:
**              - Definition of memory area ROM_8000(0x00008000:0x0000FEFF) splitted into ROM_C000(0x0000C000:0x0000FEFF) and PAGE_FE(0x00FE8000:0x00FEBFFF).
**
**     File-Format-Revisions:
**      - 03.07.2006, V2.09 :
**               - Changes have not affected this file (because they are related to another family)
**      - 27.10.2006, V2.10 :
**               - __RESET_WATCHDOG improved formating and re-definition
**      - 23.11.2006, V2.11 :
**               - Changes have not affected this file (because they are related to another family)
**      - 22.01.2007, V2.12 :
**               - Fixed declaration of non volatile registers. Now it does not require (but allows) their initialization, see issue #4086.
**      - 01.03.2007, V2.13 :
**               - Flash commands constants values converted to HEX format
**      - 02.03.2007, V2.14 :
**               - Interrupt vector numbers added into .H, see VectorNumber_*
**      - 26.03.2007, V2.15 :
**               - Changes have not affected this file (because they are related to another family)
**      - 10.05.2007, V2.16 :
**               - Changes have not affected this file (because they are related to another family)
**      - 05.06.2007, V2.17 :
**               - Changes have not affected this file (because they are related to another family)
**      - 19.07.2007, V2.18 :
**               - Improved number of blanked lines inside register structures
**      - 06.08.2007, V2.19 :
**               - CPUDB revisions generated ahead of the file-format revisions.
**      - 11.09.2007, V2.20 :
**               - Added comment about initialization of unbonded pins.
**      - 02.01.2008, V2.21 :
**               - Changes have not affected this file (because they are related to another family)
**      - 13.02.2008, V2.22 :
**               - Changes have not affected this file (because they are related to another family)
**      - 20.02.2008, V2.23 :
**               - Termination of pragma V30toV31Compatible added, #5708
**      - 03.07.2008, V2.24 :
**               - Added support for bits with name starting with number (like "1HZ")
**      - 28.11.2008, V2.25 :
**               - StandBy RAM array declaration for ANSI-C added
**      - 1.12.2008, V2.26 :
**               - Duplication of bit (or bit-group) name with register name is not marked as a problem, is register is internal only and it is not displayed in I/O map.
**      - 17.3.2009, V2.27 :
**               - Merged bit-group is not generated, if the name matches with another bit name in the register
**      - 6.4.2009, V2.28 :
**               - Fixed generation of merged bits for bit-groups with a digit at the end, if group-name is defined in CPUDB
**      - 3.8.2009, V2.29 :
**               - If there is just one bits group matching register name, single bits are not generated
**      - 10.9.2009, V2.30 :
**               - Fixed generation of registers arrays.
**      - 15.10.2009, V2.31 :
**               - Changes have not affected this file (because they are related to another family)
**      - 18.05.2010, V2.32 :
**               - MISRA compliance: U/UL suffixes added to all numbers (_MASK,_BITNUM and addresses)
**
**     Not all general-purpose I/O pins are available on all packages or on all mask sets of a specific
**     derivative device. To avoid extra current drain from floating input pins, the users reset
**     initialization routine in the application program must either enable on-chip pull-up devices
**     or change the direction of unconnected pins to outputs so the pins do not float.
** ###################################################################
*/

#ifndef _MC9S12I32_H
#define _MC9S12I32_H

/*lint -save  -e950 -esym(960,18.4) -e46 -esym(961,19.7) Disable MISRA rule (1.1,18.4,6.4,19.7) checking. */
/* Types definition */
typedef unsigned char byte;
typedef unsigned int word;
typedef unsigned long dword;
typedef unsigned long dlong[2];

#define REG_BASE 0x0000                /* Base address for the I/O register block */


#pragma MESSAGE DISABLE C1106 /* WARNING C1106: Non-standard bitfield type */
#pragma OPTION ADD V30toV31Compatible "-BfaGapLimitBits4294967295" /*this guarantee correct bitfield positions*/

/**************** interrupt vector numbers ****************/
#define VectorNumber_Vsi                63U
#define VectorNumber_VReserved62        62U
#define VectorNumber_VReserved61        61U
#define VectorNumber_VReserved60        60U
#define VectorNumber_VReserved59        59U
#define VectorNumber_VReserved58        58U
#define VectorNumber_VReserved57        57U
#define VectorNumber_VReserved56        56U
#define VectorNumber_VReserved55        55U
#define VectorNumber_VReserved54        54U
#define VectorNumber_VReserved53        53U
#define VectorNumber_VReserved52        52U
#define VectorNumber_VReserved51        51U
#define VectorNumber_VReserved50        50U
#define VectorNumber_VReserved49        49U
#define VectorNumber_VReserved48        48U
#define VectorNumber_VReserved47        47U
#define VectorNumber_VReserved46        46U
#define VectorNumber_VReserved45        45U
#define VectorNumber_VReserved44        44U
#define VectorNumber_VReserved43        43U
#define VectorNumber_VReserved42        42U
#define VectorNumber_VReserved41        41U
#define VectorNumber_VReserved40        40U
#define VectorNumber_VReserved39        39U
#define VectorNumber_VReserved38        38U
#define VectorNumber_VReserved37        37U
#define VectorNumber_VReserved36        36U
#define VectorNumber_Vflash             35U
#define VectorNumber_VReserved34        34U
#define VectorNumber_VReserved33        33U
#define VectorNumber_VReserved32        32U
#define VectorNumber_VReserved31        31U
#define VectorNumber_VReserved30        30U
#define VectorNumber_VReserved29        29U
#define VectorNumber_Vcrgflllck         28U
#define VectorNumber_VReserved27        27U
#define VectorNumber_VReserved26        26U
#define VectorNumber_VReserved25        25U
#define VectorNumber_VReserved24        24U
#define VectorNumber_VReserved23        23U
#define VectorNumber_VReserved22        22U
#define VectorNumber_VReserved21        21U
#define VectorNumber_VReserved20        20U
#define VectorNumber_Vspi               19U
#define VectorNumber_VReserved18        18U
#define VectorNumber_VReserved17        17U
#define VectorNumber_VReserved16        16U
#define VectorNumber_VReserved15        15U
#define VectorNumber_VReserved14        14U
#define VectorNumber_VReserved13        13U
#define VectorNumber_VReserved12        12U
#define VectorNumber_VReserved11        11U
#define VectorNumber_VReserved10        10U
#define VectorNumber_VReserved9         9U
#define VectorNumber_VReserved8         8U
#define VectorNumber_Vrti               7U
#define VectorNumber_Vd2diexterr        6U
#define VectorNumber_Vd2dierr           5U
#define VectorNumber_Vswi               4U
#define VectorNumber_Vtrap              3U
#define VectorNumber_Vcop               2U
#define VectorNumber_Vclkmon            1U
#define VectorNumber_Vreset             0U

/**************** interrupt vector table ****************/
#define Vsi                             0xFF80U
#define VReserved62                     0xFF82U
#define VReserved61                     0xFF84U
#define VReserved60                     0xFF86U
#define VReserved59                     0xFF88U
#define VReserved58                     0xFF8AU
#define VReserved57                     0xFF8CU
#define VReserved56                     0xFF8EU
#define VReserved55                     0xFF90U
#define VReserved54                     0xFF92U
#define VReserved53                     0xFF94U
#define VReserved52                     0xFF96U
#define VReserved51                     0xFF98U
#define VReserved50                     0xFF9AU
#define VReserved49                     0xFF9CU
#define VReserved48                     0xFF9EU
#define VReserved47                     0xFFA0U
#define VReserved46                     0xFFA2U
#define VReserved45                     0xFFA4U
#define VReserved44                     0xFFA6U
#define VReserved43                     0xFFA8U
#define VReserved42                     0xFFAAU
#define VReserved41                     0xFFACU
#define VReserved40                     0xFFAEU
#define VReserved39                     0xFFB0U
#define VReserved38                     0xFFB2U
#define VReserved37                     0xFFB4U
#define VReserved36                     0xFFB6U
#define Vflash                          0xFFB8U
#define VReserved34                     0xFFBAU
#define VReserved33                     0xFFBCU
#define VReserved32                     0xFFBEU
#define VReserved31                     0xFFC0U
#define VReserved30                     0xFFC2U
#define VReserved29                     0xFFC4U
#define Vcrgflllck                      0xFFC6U
#define VReserved27                     0xFFC8U
#define VReserved26                     0xFFCAU
#define VReserved25                     0xFFCCU
#define VReserved24                     0xFFCEU
#define VReserved23                     0xFFD0U
#define VReserved22                     0xFFD2U
#define VReserved21                     0xFFD4U
#define VReserved20                     0xFFD6U
#define Vspi                            0xFFD8U
#define VReserved18                     0xFFDAU
#define VReserved17                     0xFFDCU
#define VReserved16                     0xFFDEU
#define VReserved15                     0xFFE0U
#define VReserved14                     0xFFE2U
#define VReserved13                     0xFFE4U
#define VReserved12                     0xFFE6U
#define VReserved11                     0xFFE8U
#define VReserved10                     0xFFEAU
#define VReserved9                      0xFFECU
#define VReserved8                      0xFFEEU
#define Vrti                            0xFFF0U
#define Vd2diexterr                     0xFFF2U
#define Vd2dierr                        0xFFF4U
#define Vswi                            0xFFF6U
#define Vtrap                           0xFFF8U
#define Vcop                            0xFFFAU
#define Vclkmon                         0xFFFCU
#define Vreset                          0xFFFEU

/**************** registers I/O map ****************/

/*** PTA - Port A Data Register; 0x00000000 ***/
typedef union {
  byte Byte;
  struct {
    byte PTA0        :1;                                       /* Port A Data Bit 0 */
    byte PTA1        :1;                                       /* Port A Data Bit 1 */
    byte PTA2        :1;                                       /* Port A Data Bit 2 */
    byte PTA3        :1;                                       /* Port A Data Bit 3 */
    byte PTA4        :1;                                       /* Port A Data Bit 4 */
    byte PTA5        :1;                                       /* Port A Data Bit 5 */
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpPTA  :6;
    byte         :1;
    byte         :1;
  } MergedBits;
} PTASTR;
extern volatile PTASTR _PTA @(REG_BASE + 0x00000000UL);
#define PTA                             _PTA.Byte
#define PTA_PTA0                        _PTA.Bits.PTA0
#define PTA_PTA1                        _PTA.Bits.PTA1
#define PTA_PTA2                        _PTA.Bits.PTA2
#define PTA_PTA3                        _PTA.Bits.PTA3
#define PTA_PTA4                        _PTA.Bits.PTA4
#define PTA_PTA5                        _PTA.Bits.PTA5
#define PTA_PTA                         _PTA.MergedBits.grpPTA

#define PTA_PTA0_MASK                   1U
#define PTA_PTA1_MASK                   2U
#define PTA_PTA2_MASK                   4U
#define PTA_PTA3_MASK                   8U
#define PTA_PTA4_MASK                   16U
#define PTA_PTA5_MASK                   32U
#define PTA_PTA_MASK                    63U
#define PTA_PTA_BITNUM                  0U


/*** DDRA - Data Direction Register A; 0x00000002 ***/
typedef union {
  byte Byte;
  struct {
    byte DDRA0       :1;                                       /* Data Direction Register A Bit 0 */
    byte DDRA1       :1;                                       /* Data Direction Register A Bit 1 */
    byte DDRA2       :1;                                       /* Data Direction Register A Bit 2 */
    byte DDRA3       :1;                                       /* Data Direction Register A Bit 3 */
    byte DDRA4       :1;                                       /* Data Direction Register A Bit 4 */
    byte DDRA5       :1;                                       /* Data Direction Register A Bit 5 */
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpDDRA :6;
    byte         :1;
    byte         :1;
  } MergedBits;
} DDRASTR;
extern volatile DDRASTR _DDRA @(REG_BASE + 0x00000002UL);
#define DDRA                            _DDRA.Byte
#define DDRA_DDRA0                      _DDRA.Bits.DDRA0
#define DDRA_DDRA1                      _DDRA.Bits.DDRA1
#define DDRA_DDRA2                      _DDRA.Bits.DDRA2
#define DDRA_DDRA3                      _DDRA.Bits.DDRA3
#define DDRA_DDRA4                      _DDRA.Bits.DDRA4
#define DDRA_DDRA5                      _DDRA.Bits.DDRA5
#define DDRA_DDRA                       _DDRA.MergedBits.grpDDRA

#define DDRA_DDRA0_MASK                 1U
#define DDRA_DDRA1_MASK                 2U
#define DDRA_DDRA2_MASK                 4U
#define DDRA_DDRA3_MASK                 8U
#define DDRA_DDRA4_MASK                 16U
#define DDRA_DDRA5_MASK                 32U
#define DDRA_DDRA_MASK                  63U
#define DDRA_DDRA_BITNUM                0U


/*** PTC - Port C Data Register; 0x00000004 ***/
typedef union {
  byte Byte;
  struct {
    byte PTC0        :1;                                       /* Port C Data Bit 0 */
    byte PTC1        :1;                                       /* Port C Data Bit 1 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpPTC  :2;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} PTCSTR;
extern volatile PTCSTR _PTC @(REG_BASE + 0x00000004UL);
#define PTC                             _PTC.Byte
#define PTC_PTC0                        _PTC.Bits.PTC0
#define PTC_PTC1                        _PTC.Bits.PTC1
#define PTC_PTC                         _PTC.MergedBits.grpPTC

#define PTC_PTC0_MASK                   1U
#define PTC_PTC1_MASK                   2U
#define PTC_PTC_MASK                    3U
#define PTC_PTC_BITNUM                  0U


/*** PTD - Port D Data Register; 0x00000005 ***/
typedef union {
  byte Byte;
  struct {
    byte PTD0        :1;                                       /* Port D Data Bit 0 */
    byte PTD1        :1;                                       /* Port D Data Bit 1 */
    byte PTD2        :1;                                       /* Port D Data Bit 2 */
    byte PTD3        :1;                                       /* Port D Data Bit 3 */
    byte PTD4        :1;                                       /* Port D Data Bit 4 */
    byte PTD5        :1;                                       /* Port D Data Bit 5 */
    byte PTD6        :1;                                       /* Port D Data Bit 6 */
    byte PTD7        :1;                                       /* Port D Data Bit 7 */
  } Bits;
} PTDSTR;
extern volatile PTDSTR _PTD @(REG_BASE + 0x00000005UL);
#define PTD                             _PTD.Byte
#define PTD_PTD0                        _PTD.Bits.PTD0
#define PTD_PTD1                        _PTD.Bits.PTD1
#define PTD_PTD2                        _PTD.Bits.PTD2
#define PTD_PTD3                        _PTD.Bits.PTD3
#define PTD_PTD4                        _PTD.Bits.PTD4
#define PTD_PTD5                        _PTD.Bits.PTD5
#define PTD_PTD6                        _PTD.Bits.PTD6
#define PTD_PTD7                        _PTD.Bits.PTD7

#define PTD_PTD0_MASK                   1U
#define PTD_PTD1_MASK                   2U
#define PTD_PTD2_MASK                   4U
#define PTD_PTD3_MASK                   8U
#define PTD_PTD4_MASK                   16U
#define PTD_PTD5_MASK                   32U
#define PTD_PTD6_MASK                   64U
#define PTD_PTD7_MASK                   128U


/*** DDRC - Data Direction Register C; 0x00000006 ***/
typedef union {
  byte Byte;
  struct {
    byte DDRC0       :1;                                       /* Data Direction Register C Bit 0 */
    byte DDRC1       :1;                                       /* Data Direction Register C Bit 1 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpDDRC :2;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} DDRCSTR;
extern volatile DDRCSTR _DDRC @(REG_BASE + 0x00000006UL);
#define DDRC                            _DDRC.Byte
#define DDRC_DDRC0                      _DDRC.Bits.DDRC0
#define DDRC_DDRC1                      _DDRC.Bits.DDRC1
#define DDRC_DDRC                       _DDRC.MergedBits.grpDDRC

#define DDRC_DDRC0_MASK                 1U
#define DDRC_DDRC1_MASK                 2U
#define DDRC_DDRC_MASK                  3U
#define DDRC_DDRC_BITNUM                0U


/*** DDRD - Data Direction Register D; 0x00000007 ***/
typedef union {
  byte Byte;
  struct {
    byte DDRD0       :1;                                       /* Data Direction Register D Bit 0 */
    byte DDRD1       :1;                                       /* Data Direction Register D Bit 1 */
    byte DDRD2       :1;                                       /* Data Direction Register D Bit 2 */
    byte DDRD3       :1;                                       /* Data Direction Register D Bit 3 */
    byte DDRD4       :1;                                       /* Data Direction Register D Bit 4 */
    byte DDRD5       :1;                                       /* Data Direction Register D Bit 5 */
    byte DDRD6       :1;                                       /* Data Direction Register D Bit 6 */
    byte DDRD7       :1;                                       /* Data Direction Register D Bit 7 */
  } Bits;
} DDRDSTR;
extern volatile DDRDSTR _DDRD @(REG_BASE + 0x00000007UL);
#define DDRD                            _DDRD.Byte
#define DDRD_DDRD0                      _DDRD.Bits.DDRD0
#define DDRD_DDRD1                      _DDRD.Bits.DDRD1
#define DDRD_DDRD2                      _DDRD.Bits.DDRD2
#define DDRD_DDRD3                      _DDRD.Bits.DDRD3
#define DDRD_DDRD4                      _DDRD.Bits.DDRD4
#define DDRD_DDRD5                      _DDRD.Bits.DDRD5
#define DDRD_DDRD6                      _DDRD.Bits.DDRD6
#define DDRD_DDRD7                      _DDRD.Bits.DDRD7

#define DDRD_DDRD0_MASK                 1U
#define DDRD_DDRD1_MASK                 2U
#define DDRD_DDRD2_MASK                 4U
#define DDRD_DDRD3_MASK                 8U
#define DDRD_DDRD4_MASK                 16U
#define DDRD_DDRD5_MASK                 32U
#define DDRD_DDRD6_MASK                 64U
#define DDRD_DDRD7_MASK                 128U


/*** PARTID - Part ID Register; 0x0000001A ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** PARTIDH - Part ID Register High; 0x0000001A ***/
    union {
      byte Byte;
      struct {
        byte ID8         :1;                                       /* Part ID Register Bit 8 */
        byte ID9         :1;                                       /* Part ID Register Bit 9 */
        byte ID10        :1;                                       /* Part ID Register Bit 10 */
        byte ID11        :1;                                       /* Part ID Register Bit 11 */
        byte ID12        :1;                                       /* Part ID Register Bit 12 */
        byte ID13        :1;                                       /* Part ID Register Bit 13 */
        byte ID14        :1;                                       /* Part ID Register Bit 14 */
        byte ID15        :1;                                       /* Part ID Register Bit 15 */
      } Bits;
    } PARTIDHSTR;
    #define PARTIDH                     _PARTID.Overlap_STR.PARTIDHSTR.Byte
    #define PARTIDH_ID8                 _PARTID.Overlap_STR.PARTIDHSTR.Bits.ID8
    #define PARTIDH_ID9                 _PARTID.Overlap_STR.PARTIDHSTR.Bits.ID9
    #define PARTIDH_ID10                _PARTID.Overlap_STR.PARTIDHSTR.Bits.ID10
    #define PARTIDH_ID11                _PARTID.Overlap_STR.PARTIDHSTR.Bits.ID11
    #define PARTIDH_ID12                _PARTID.Overlap_STR.PARTIDHSTR.Bits.ID12
    #define PARTIDH_ID13                _PARTID.Overlap_STR.PARTIDHSTR.Bits.ID13
    #define PARTIDH_ID14                _PARTID.Overlap_STR.PARTIDHSTR.Bits.ID14
    #define PARTIDH_ID15                _PARTID.Overlap_STR.PARTIDHSTR.Bits.ID15
    
    #define PARTIDH_ID8_MASK            1U
    #define PARTIDH_ID9_MASK            2U
    #define PARTIDH_ID10_MASK           4U
    #define PARTIDH_ID11_MASK           8U
    #define PARTIDH_ID12_MASK           16U
    #define PARTIDH_ID13_MASK           32U
    #define PARTIDH_ID14_MASK           64U
    #define PARTIDH_ID15_MASK           128U
    

    /*** PARTIDL - Part ID Register Low; 0x0000001B ***/
    union {
      byte Byte;
      struct {
        byte ID0         :1;                                       /* Part ID Register Bit 0 */
        byte ID1         :1;                                       /* Part ID Register Bit 1 */
        byte ID2         :1;                                       /* Part ID Register Bit 2 */
        byte ID3         :1;                                       /* Part ID Register Bit 3 */
        byte ID4         :1;                                       /* Part ID Register Bit 4 */
        byte ID5         :1;                                       /* Part ID Register Bit 5 */
        byte ID6         :1;                                       /* Part ID Register Bit 6 */
        byte ID7         :1;                                       /* Part ID Register Bit 7 */
      } Bits;
    } PARTIDLSTR;
    #define PARTIDL                     _PARTID.Overlap_STR.PARTIDLSTR.Byte
    #define PARTIDL_ID0                 _PARTID.Overlap_STR.PARTIDLSTR.Bits.ID0
    #define PARTIDL_ID1                 _PARTID.Overlap_STR.PARTIDLSTR.Bits.ID1
    #define PARTIDL_ID2                 _PARTID.Overlap_STR.PARTIDLSTR.Bits.ID2
    #define PARTIDL_ID3                 _PARTID.Overlap_STR.PARTIDLSTR.Bits.ID3
    #define PARTIDL_ID4                 _PARTID.Overlap_STR.PARTIDLSTR.Bits.ID4
    #define PARTIDL_ID5                 _PARTID.Overlap_STR.PARTIDLSTR.Bits.ID5
    #define PARTIDL_ID6                 _PARTID.Overlap_STR.PARTIDLSTR.Bits.ID6
    #define PARTIDL_ID7                 _PARTID.Overlap_STR.PARTIDLSTR.Bits.ID7
    
    #define PARTIDL_ID0_MASK            1U
    #define PARTIDL_ID1_MASK            2U
    #define PARTIDL_ID2_MASK            4U
    #define PARTIDL_ID3_MASK            8U
    #define PARTIDL_ID4_MASK            16U
    #define PARTIDL_ID5_MASK            32U
    #define PARTIDL_ID6_MASK            64U
    #define PARTIDL_ID7_MASK            128U
    
  } Overlap_STR;

  struct {
    word ID0         :1;                                       /* Part ID Register Bit 0 */
    word ID1         :1;                                       /* Part ID Register Bit 1 */
    word ID2         :1;                                       /* Part ID Register Bit 2 */
    word ID3         :1;                                       /* Part ID Register Bit 3 */
    word ID4         :1;                                       /* Part ID Register Bit 4 */
    word ID5         :1;                                       /* Part ID Register Bit 5 */
    word ID6         :1;                                       /* Part ID Register Bit 6 */
    word ID7         :1;                                       /* Part ID Register Bit 7 */
    word ID8         :1;                                       /* Part ID Register Bit 8 */
    word ID9         :1;                                       /* Part ID Register Bit 9 */
    word ID10        :1;                                       /* Part ID Register Bit 10 */
    word ID11        :1;                                       /* Part ID Register Bit 11 */
    word ID12        :1;                                       /* Part ID Register Bit 12 */
    word ID13        :1;                                       /* Part ID Register Bit 13 */
    word ID14        :1;                                       /* Part ID Register Bit 14 */
    word ID15        :1;                                       /* Part ID Register Bit 15 */
  } Bits;
} PARTIDSTR;
extern volatile PARTIDSTR _PARTID @(REG_BASE + 0x0000001AUL);
#define PARTID                          _PARTID.Word
#define PARTID_ID0                      _PARTID.Bits.ID0
#define PARTID_ID1                      _PARTID.Bits.ID1
#define PARTID_ID2                      _PARTID.Bits.ID2
#define PARTID_ID3                      _PARTID.Bits.ID3
#define PARTID_ID4                      _PARTID.Bits.ID4
#define PARTID_ID5                      _PARTID.Bits.ID5
#define PARTID_ID6                      _PARTID.Bits.ID6
#define PARTID_ID7                      _PARTID.Bits.ID7
#define PARTID_ID8                      _PARTID.Bits.ID8
#define PARTID_ID9                      _PARTID.Bits.ID9
#define PARTID_ID10                     _PARTID.Bits.ID10
#define PARTID_ID11                     _PARTID.Bits.ID11
#define PARTID_ID12                     _PARTID.Bits.ID12
#define PARTID_ID13                     _PARTID.Bits.ID13
#define PARTID_ID14                     _PARTID.Bits.ID14
#define PARTID_ID15                     _PARTID.Bits.ID15

#define PARTID_ID0_MASK                 1U
#define PARTID_ID1_MASK                 2U
#define PARTID_ID2_MASK                 4U
#define PARTID_ID3_MASK                 8U
#define PARTID_ID4_MASK                 16U
#define PARTID_ID5_MASK                 32U
#define PARTID_ID6_MASK                 64U
#define PARTID_ID7_MASK                 128U
#define PARTID_ID8_MASK                 256U
#define PARTID_ID9_MASK                 512U
#define PARTID_ID10_MASK                1024U
#define PARTID_ID11_MASK                2048U
#define PARTID_ID12_MASK                4096U
#define PARTID_ID13_MASK                8192U
#define PARTID_ID14_MASK                16384U
#define PARTID_ID15_MASK                32768U


/*** IVBR - Interrupt Vector Base Register; 0x0000001F ***/
typedef union {
  byte Byte;
  struct {
    byte IVB_ADDR0   :1;                                       /* Interrupt vector base address bits, bit 0 */
    byte IVB_ADDR1   :1;                                       /* Interrupt vector base address bits, bit 1 */
    byte IVB_ADDR2   :1;                                       /* Interrupt vector base address bits, bit 2 */
    byte IVB_ADDR3   :1;                                       /* Interrupt vector base address bits, bit 3 */
    byte IVB_ADDR4   :1;                                       /* Interrupt vector base address bits, bit 4 */
    byte IVB_ADDR5   :1;                                       /* Interrupt vector base address bits, bit 5 */
    byte IVB_ADDR6   :1;                                       /* Interrupt vector base address bits, bit 6 */
    byte IVB_ADDR7   :1;                                       /* Interrupt vector base address bits, bit 7 */
  } Bits;
} IVBRSTR;
extern volatile IVBRSTR _IVBR @(REG_BASE + 0x0000001FUL);
#define IVBR                            _IVBR.Byte
#define IVBR_IVB_ADDR0                  _IVBR.Bits.IVB_ADDR0
#define IVBR_IVB_ADDR1                  _IVBR.Bits.IVB_ADDR1
#define IVBR_IVB_ADDR2                  _IVBR.Bits.IVB_ADDR2
#define IVBR_IVB_ADDR3                  _IVBR.Bits.IVB_ADDR3
#define IVBR_IVB_ADDR4                  _IVBR.Bits.IVB_ADDR4
#define IVBR_IVB_ADDR5                  _IVBR.Bits.IVB_ADDR5
#define IVBR_IVB_ADDR6                  _IVBR.Bits.IVB_ADDR6
#define IVBR_IVB_ADDR7                  _IVBR.Bits.IVB_ADDR7

#define IVBR_IVB_ADDR0_MASK             1U
#define IVBR_IVB_ADDR1_MASK             2U
#define IVBR_IVB_ADDR2_MASK             4U
#define IVBR_IVB_ADDR3_MASK             8U
#define IVBR_IVB_ADDR4_MASK             16U
#define IVBR_IVB_ADDR5_MASK             32U
#define IVBR_IVB_ADDR6_MASK             64U
#define IVBR_IVB_ADDR7_MASK             128U


/*** DBGC1 - Debug Control Register 1; 0x00000020 ***/
typedef union {
  byte Byte;
  struct {
    byte COMRV0      :1;                                       /* Comparator Register Visibility Bits, bit 0 */
    byte COMRV1      :1;                                       /* Comparator Register Visibility Bits, bit 1 */
    byte             :1; 
    byte DBGBRK      :1;                                       /* S12X_DBG Breakpoint Enable Bits */
    byte BDM         :1;                                       /* Background Debug Mode Enable */
    byte             :1; 
    byte TRIG        :1;                                       /* Immediate Trigger Request Bit */
    byte ARM         :1;                                       /* Arm Bit */
  } Bits;
  struct {
    byte grpCOMRV :2;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} DBGC1STR;
extern volatile DBGC1STR _DBGC1 @(REG_BASE + 0x00000020UL);
#define DBGC1                           _DBGC1.Byte
#define DBGC1_COMRV0                    _DBGC1.Bits.COMRV0
#define DBGC1_COMRV1                    _DBGC1.Bits.COMRV1
#define DBGC1_DBGBRK                    _DBGC1.Bits.DBGBRK
#define DBGC1_BDM                       _DBGC1.Bits.BDM
#define DBGC1_TRIG                      _DBGC1.Bits.TRIG
#define DBGC1_ARM                       _DBGC1.Bits.ARM
#define DBGC1_COMRV                     _DBGC1.MergedBits.grpCOMRV

#define DBGC1_COMRV0_MASK               1U
#define DBGC1_COMRV1_MASK               2U
#define DBGC1_DBGBRK_MASK               8U
#define DBGC1_BDM_MASK                  16U
#define DBGC1_TRIG_MASK                 64U
#define DBGC1_ARM_MASK                  128U
#define DBGC1_COMRV_MASK                3U
#define DBGC1_COMRV_BITNUM              0U


/*** DBGSR - Debug Status Register; 0x00000021 ***/
typedef union {
  byte Byte;
  struct {
    byte SSF0        :1;                                       /* State Sequencer Flag Bit 0 */
    byte SSF1        :1;                                       /* State Sequencer Flag Bit 1 */
    byte SSF2        :1;                                       /* State Sequencer Flag Bit 2 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte TBF         :1;                                       /* Trace Buffer Full */
  } Bits;
  struct {
    byte grpSSF  :3;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} DBGSRSTR;
extern volatile DBGSRSTR _DBGSR @(REG_BASE + 0x00000021UL);
#define DBGSR                           _DBGSR.Byte
#define DBGSR_SSF0                      _DBGSR.Bits.SSF0
#define DBGSR_SSF1                      _DBGSR.Bits.SSF1
#define DBGSR_SSF2                      _DBGSR.Bits.SSF2
#define DBGSR_TBF                       _DBGSR.Bits.TBF
#define DBGSR_SSF                       _DBGSR.MergedBits.grpSSF

#define DBGSR_SSF0_MASK                 1U
#define DBGSR_SSF1_MASK                 2U
#define DBGSR_SSF2_MASK                 4U
#define DBGSR_TBF_MASK                  128U
#define DBGSR_SSF_MASK                  7U
#define DBGSR_SSF_BITNUM                0U


/*** DBGTCR - Debug Trace Control Register; 0x00000022 ***/
typedef union {
  byte Byte;
  struct {
    byte TALIGN      :1;                                       /* Trigger Align Bits */
    byte             :1; 
    byte TRCMOD0     :1;                                       /* Trace Mode Bits, bit 0 */
    byte TRCMOD1     :1;                                       /* Trace Mode Bits, bit 1 */
    byte             :1; 
    byte             :1; 
    byte TSOURCE     :1;                                       /* Trace Source Control Bit */
    byte             :1; 
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte grpTRCMOD :2;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} DBGTCRSTR;
extern volatile DBGTCRSTR _DBGTCR @(REG_BASE + 0x00000022UL);
#define DBGTCR                          _DBGTCR.Byte
#define DBGTCR_TALIGN                   _DBGTCR.Bits.TALIGN
#define DBGTCR_TRCMOD0                  _DBGTCR.Bits.TRCMOD0
#define DBGTCR_TRCMOD1                  _DBGTCR.Bits.TRCMOD1
#define DBGTCR_TSOURCE                  _DBGTCR.Bits.TSOURCE
#define DBGTCR_TRCMOD                   _DBGTCR.MergedBits.grpTRCMOD

#define DBGTCR_TALIGN_MASK              1U
#define DBGTCR_TRCMOD0_MASK             4U
#define DBGTCR_TRCMOD1_MASK             8U
#define DBGTCR_TSOURCE_MASK             64U
#define DBGTCR_TRCMOD_MASK              12U
#define DBGTCR_TRCMOD_BITNUM            2U


/*** DBGC2 - Debug Control Register 2; 0x00000023 ***/
typedef union {
  byte Byte;
  struct {
    byte ABCM0       :1;                                       /* A and B Comparator Match Control, bit 0 */
    byte ABCM1       :1;                                       /* A and B Comparator Match Control, bit 1 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpABCM :2;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} DBGC2STR;
extern volatile DBGC2STR _DBGC2 @(REG_BASE + 0x00000023UL);
#define DBGC2                           _DBGC2.Byte
#define DBGC2_ABCM0                     _DBGC2.Bits.ABCM0
#define DBGC2_ABCM1                     _DBGC2.Bits.ABCM1
#define DBGC2_ABCM                      _DBGC2.MergedBits.grpABCM

#define DBGC2_ABCM0_MASK                1U
#define DBGC2_ABCM1_MASK                2U
#define DBGC2_ABCM_MASK                 3U
#define DBGC2_ABCM_BITNUM               0U


/*** DBGTB - Debug Trace Buffer Register; 0x00000024 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** DBGTBH - Debug Trace Buffer Register High; 0x00000024 ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Debug Trace Buffer Bit 8 */
        byte BIT9        :1;                                       /* Debug Trace Buffer Bit 9 */
        byte BIT10       :1;                                       /* Debug Trace Buffer Bit 10 */
        byte BIT11       :1;                                       /* Debug Trace Buffer Bit 11 */
        byte BIT12       :1;                                       /* Debug Trace Buffer Bit 12 */
        byte BIT13       :1;                                       /* Debug Trace Buffer Bit 13 */
        byte BIT14       :1;                                       /* Debug Trace Buffer Bit 14 */
        byte BIT15       :1;                                       /* Debug Trace Buffer Bit 15 */
      } Bits;
    } DBGTBHSTR;
    #define DBGTBH                      _DBGTB.Overlap_STR.DBGTBHSTR.Byte
    #define DBGTBH_BIT8                 _DBGTB.Overlap_STR.DBGTBHSTR.Bits.BIT8
    #define DBGTBH_BIT9                 _DBGTB.Overlap_STR.DBGTBHSTR.Bits.BIT9
    #define DBGTBH_BIT10                _DBGTB.Overlap_STR.DBGTBHSTR.Bits.BIT10
    #define DBGTBH_BIT11                _DBGTB.Overlap_STR.DBGTBHSTR.Bits.BIT11
    #define DBGTBH_BIT12                _DBGTB.Overlap_STR.DBGTBHSTR.Bits.BIT12
    #define DBGTBH_BIT13                _DBGTB.Overlap_STR.DBGTBHSTR.Bits.BIT13
    #define DBGTBH_BIT14                _DBGTB.Overlap_STR.DBGTBHSTR.Bits.BIT14
    #define DBGTBH_BIT15                _DBGTB.Overlap_STR.DBGTBHSTR.Bits.BIT15
    
    #define DBGTBH_BIT8_MASK            1U
    #define DBGTBH_BIT9_MASK            2U
    #define DBGTBH_BIT10_MASK           4U
    #define DBGTBH_BIT11_MASK           8U
    #define DBGTBH_BIT12_MASK           16U
    #define DBGTBH_BIT13_MASK           32U
    #define DBGTBH_BIT14_MASK           64U
    #define DBGTBH_BIT15_MASK           128U
    

    /*** DBGTBL - Debug Trace Buffer Register Low; 0x00000025 ***/
    union {
      byte Byte;
      struct {
        byte BIT0        :1;                                       /* Debug Trace Buffer Bit 0 */
        byte BIT1        :1;                                       /* Debug Trace Buffer Bit 1 */
        byte BIT2        :1;                                       /* Debug Trace Buffer Bit 2 */
        byte BIT3        :1;                                       /* Debug Trace Buffer Bit 3 */
        byte BIT4        :1;                                       /* Debug Trace Buffer Bit 4 */
        byte BIT5        :1;                                       /* Debug Trace Buffer Bit 5 */
        byte BIT6        :1;                                       /* Debug Trace Buffer Bit 6 */
        byte BIT7        :1;                                       /* Debug Trace Buffer Bit 7 */
      } Bits;
    } DBGTBLSTR;
    #define DBGTBL                      _DBGTB.Overlap_STR.DBGTBLSTR.Byte
    #define DBGTBL_BIT0                 _DBGTB.Overlap_STR.DBGTBLSTR.Bits.BIT0
    #define DBGTBL_BIT1                 _DBGTB.Overlap_STR.DBGTBLSTR.Bits.BIT1
    #define DBGTBL_BIT2                 _DBGTB.Overlap_STR.DBGTBLSTR.Bits.BIT2
    #define DBGTBL_BIT3                 _DBGTB.Overlap_STR.DBGTBLSTR.Bits.BIT3
    #define DBGTBL_BIT4                 _DBGTB.Overlap_STR.DBGTBLSTR.Bits.BIT4
    #define DBGTBL_BIT5                 _DBGTB.Overlap_STR.DBGTBLSTR.Bits.BIT5
    #define DBGTBL_BIT6                 _DBGTB.Overlap_STR.DBGTBLSTR.Bits.BIT6
    #define DBGTBL_BIT7                 _DBGTB.Overlap_STR.DBGTBLSTR.Bits.BIT7
    
    #define DBGTBL_BIT0_MASK            1U
    #define DBGTBL_BIT1_MASK            2U
    #define DBGTBL_BIT2_MASK            4U
    #define DBGTBL_BIT3_MASK            8U
    #define DBGTBL_BIT4_MASK            16U
    #define DBGTBL_BIT5_MASK            32U
    #define DBGTBL_BIT6_MASK            64U
    #define DBGTBL_BIT7_MASK            128U
    
  } Overlap_STR;

  struct {
    word BIT0        :1;                                       /* Debug Trace Buffer Bit 0 */
    word BIT1        :1;                                       /* Debug Trace Buffer Bit 1 */
    word BIT2        :1;                                       /* Debug Trace Buffer Bit 2 */
    word BIT3        :1;                                       /* Debug Trace Buffer Bit 3 */
    word BIT4        :1;                                       /* Debug Trace Buffer Bit 4 */
    word BIT5        :1;                                       /* Debug Trace Buffer Bit 5 */
    word BIT6        :1;                                       /* Debug Trace Buffer Bit 6 */
    word BIT7        :1;                                       /* Debug Trace Buffer Bit 7 */
    word BIT8        :1;                                       /* Debug Trace Buffer Bit 8 */
    word BIT9        :1;                                       /* Debug Trace Buffer Bit 9 */
    word BIT10       :1;                                       /* Debug Trace Buffer Bit 10 */
    word BIT11       :1;                                       /* Debug Trace Buffer Bit 11 */
    word BIT12       :1;                                       /* Debug Trace Buffer Bit 12 */
    word BIT13       :1;                                       /* Debug Trace Buffer Bit 13 */
    word BIT14       :1;                                       /* Debug Trace Buffer Bit 14 */
    word BIT15       :1;                                       /* Debug Trace Buffer Bit 15 */
  } Bits;
} DBGTBSTR;
extern volatile DBGTBSTR _DBGTB @(REG_BASE + 0x00000024UL);
#define DBGTB                           _DBGTB.Word
#define DBGTB_BIT0                      _DBGTB.Bits.BIT0
#define DBGTB_BIT1                      _DBGTB.Bits.BIT1
#define DBGTB_BIT2                      _DBGTB.Bits.BIT2
#define DBGTB_BIT3                      _DBGTB.Bits.BIT3
#define DBGTB_BIT4                      _DBGTB.Bits.BIT4
#define DBGTB_BIT5                      _DBGTB.Bits.BIT5
#define DBGTB_BIT6                      _DBGTB.Bits.BIT6
#define DBGTB_BIT7                      _DBGTB.Bits.BIT7
#define DBGTB_BIT8                      _DBGTB.Bits.BIT8
#define DBGTB_BIT9                      _DBGTB.Bits.BIT9
#define DBGTB_BIT10                     _DBGTB.Bits.BIT10
#define DBGTB_BIT11                     _DBGTB.Bits.BIT11
#define DBGTB_BIT12                     _DBGTB.Bits.BIT12
#define DBGTB_BIT13                     _DBGTB.Bits.BIT13
#define DBGTB_BIT14                     _DBGTB.Bits.BIT14
#define DBGTB_BIT15                     _DBGTB.Bits.BIT15

#define DBGTB_BIT0_MASK                 1U
#define DBGTB_BIT1_MASK                 2U
#define DBGTB_BIT2_MASK                 4U
#define DBGTB_BIT3_MASK                 8U
#define DBGTB_BIT4_MASK                 16U
#define DBGTB_BIT5_MASK                 32U
#define DBGTB_BIT6_MASK                 64U
#define DBGTB_BIT7_MASK                 128U
#define DBGTB_BIT8_MASK                 256U
#define DBGTB_BIT9_MASK                 512U
#define DBGTB_BIT10_MASK                1024U
#define DBGTB_BIT11_MASK                2048U
#define DBGTB_BIT12_MASK                4096U
#define DBGTB_BIT13_MASK                8192U
#define DBGTB_BIT14_MASK                16384U
#define DBGTB_BIT15_MASK                32768U


/*** DBGCNT - Debug Count Register; 0x00000026 ***/
typedef union {
  byte Byte;
  struct {
    byte CNT0        :1;                                       /* Count value, bit 0 */
    byte CNT1        :1;                                       /* Count value, bit 1 */
    byte CNT2        :1;                                       /* Count value, bit 2 */
    byte CNT3        :1;                                       /* Count value, bit 3 */
    byte CNT4        :1;                                       /* Count value, bit 4 */
    byte CNT5        :1;                                       /* Count value, bit 5 */
    byte             :1; 
    byte TBF         :1;                                       /* Trace Buffer Full */
  } Bits;
  struct {
    byte grpCNT  :6;
    byte         :1;
    byte         :1;
  } MergedBits;
} DBGCNTSTR;
extern volatile DBGCNTSTR _DBGCNT @(REG_BASE + 0x00000026UL);
#define DBGCNT                          _DBGCNT.Byte
#define DBGCNT_CNT0                     _DBGCNT.Bits.CNT0
#define DBGCNT_CNT1                     _DBGCNT.Bits.CNT1
#define DBGCNT_CNT2                     _DBGCNT.Bits.CNT2
#define DBGCNT_CNT3                     _DBGCNT.Bits.CNT3
#define DBGCNT_CNT4                     _DBGCNT.Bits.CNT4
#define DBGCNT_CNT5                     _DBGCNT.Bits.CNT5
#define DBGCNT_TBF                      _DBGCNT.Bits.TBF
#define DBGCNT_CNT                      _DBGCNT.MergedBits.grpCNT

#define DBGCNT_CNT0_MASK                1U
#define DBGCNT_CNT1_MASK                2U
#define DBGCNT_CNT2_MASK                4U
#define DBGCNT_CNT3_MASK                8U
#define DBGCNT_CNT4_MASK                16U
#define DBGCNT_CNT5_MASK                32U
#define DBGCNT_TBF_MASK                 128U
#define DBGCNT_CNT_MASK                 63U
#define DBGCNT_CNT_BITNUM               0U


/*** DBGSCRX - Debug State Control Register 0; 0x00000027 ***/
typedef union {
  byte Byte;
  union { /* Several registers at the same address */
    /*** DBGSCRX - Debug State Control Register 0; Several registers at the same address ***/
    union {
      struct {
        byte SC0         :1;                                       /* These bit (0) select the targeted next state whilst in StateX, based upon the match event */
        byte SC1         :1;                                       /* These bit (1) select the targeted next state whilst in StateX, based upon the match event */
        byte SC2         :1;                                       /* These bit (2) select the targeted next state whilst in StateX, based upon the match event */
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
      } Bits;
      struct {
        byte grpSC :3;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
      } MergedBits;
    } DBGSCRXSTR;
    #define DBGSCRX                     _DBGSCRX.Byte
    #define DBGSCRX_SC0                 _DBGSCRX.SameAddr_STR.DBGSCRXSTR.Bits.SC0
    #define DBGSCRX_SC1                 _DBGSCRX.SameAddr_STR.DBGSCRXSTR.Bits.SC1
    #define DBGSCRX_SC2                 _DBGSCRX.SameAddr_STR.DBGSCRXSTR.Bits.SC2
    #define DBGSCRX_SC                  _DBGSCRX.SameAddr_STR.DBGSCRXSTR.MergedBits.grpSC
    
    #define DBGSCRX_SC0_MASK            1U
    #define DBGSCRX_SC1_MASK            2U
    #define DBGSCRX_SC2_MASK            4U
    #define DBGSCRX_SC_MASK             7U
    #define DBGSCRX_SC_BITNUM           0U
    
    /*** DBGMFR - Debug State Control Register 1; Several registers at the same address ***/
    union {
      struct {
        byte MC0         :1;                                       /* These bit (0) select the targeted next state whilst in StateX, based upon the match event */
        byte MC1         :1;                                       /* These bit (1) select the targeted next state whilst in StateX, based upon the match event */
        byte MC2         :1;                                       /* These bit (2) select the targeted next state whilst in StateX, based upon the match event */
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
      } Bits;
      struct {
        byte grpMC :3;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
      } MergedBits;
    } DBGMFRSTR;
    #define DBGMFR                      _DBGSCRX.Byte
    #define DBGMFR_MC0                  _DBGSCRX.SameAddr_STR.DBGMFRSTR.Bits.MC0
    #define DBGMFR_MC1                  _DBGSCRX.SameAddr_STR.DBGMFRSTR.Bits.MC1
    #define DBGMFR_MC2                  _DBGSCRX.SameAddr_STR.DBGMFRSTR.Bits.MC2
    #define DBGMFR_MC                   _DBGSCRX.SameAddr_STR.DBGMFRSTR.MergedBits.grpMC
    
    #define DBGMFR_MC0_MASK             1U
    #define DBGMFR_MC1_MASK             2U
    #define DBGMFR_MC2_MASK             4U
    #define DBGMFR_MC_MASK              7U
    #define DBGMFR_MC_BITNUM            0U
    
  } SameAddr_STR; /*Several registers at the same address */

} DBGSCRXSTR;
extern volatile DBGSCRXSTR _DBGSCRX @(REG_BASE + 0x00000027UL);


/*** DBGXCTL - Debug Comparator Control Register; 0x00000028 ***/
typedef union {
  byte Byte;
  struct {
    byte COMPE       :1;                                       /* Determines if comparator is enabled */
    byte             :1; 
    byte RWE         :1;                                       /* Read/Write Enable Bit */
    byte RW          :1;                                       /* Read/Write Comparator Value Bit */
    byte             :1; 
    byte TAG         :1;                                       /* Tag select */
    byte NDB_SZ      :1;                                       /* Not Data Bus Compare (for comparators A and C), Size Comparator Value Bit (for comparators B and D) */
    byte SZE         :1;                                       /* Size Comparator Enable Bit (for comparators B and D) */
  } Bits;
} DBGXCTLSTR;
extern volatile DBGXCTLSTR _DBGXCTL @(REG_BASE + 0x00000028UL);
#define DBGXCTL                         _DBGXCTL.Byte
#define DBGXCTL_COMPE                   _DBGXCTL.Bits.COMPE
#define DBGXCTL_RWE                     _DBGXCTL.Bits.RWE
#define DBGXCTL_RW                      _DBGXCTL.Bits.RW
#define DBGXCTL_TAG                     _DBGXCTL.Bits.TAG
#define DBGXCTL_NDB_SZ                  _DBGXCTL.Bits.NDB_SZ
#define DBGXCTL_SZE                     _DBGXCTL.Bits.SZE

#define DBGXCTL_COMPE_MASK              1U
#define DBGXCTL_RWE_MASK                4U
#define DBGXCTL_RW_MASK                 8U
#define DBGXCTL_TAG_MASK                32U
#define DBGXCTL_NDB_SZ_MASK             64U
#define DBGXCTL_SZE_MASK                128U


/*** DBGXAH - Debug Comparator Address High Register; 0x00000029 ***/
typedef union {
  byte Byte;
  struct {
    byte BIT16       :1;                                       /* Comparator Address High Compare Bit 16 */
    byte BIT17       :1;                                       /* Comparator Address High Compare Bit 17 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpBIT_16 :2;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} DBGXAHSTR;
extern volatile DBGXAHSTR _DBGXAH @(REG_BASE + 0x00000029UL);
#define DBGXAH                          _DBGXAH.Byte
#define DBGXAH_BIT16                    _DBGXAH.Bits.BIT16
#define DBGXAH_BIT17                    _DBGXAH.Bits.BIT17
#define DBGXAH_BIT_16                   _DBGXAH.MergedBits.grpBIT_16
#define DBGXAH_BIT                      DBGXAH_BIT_16

#define DBGXAH_BIT16_MASK               1U
#define DBGXAH_BIT17_MASK               2U
#define DBGXAH_BIT_16_MASK              3U
#define DBGXAH_BIT_16_BITNUM            0U


/*** DBGXAM - Debug Comparator Address Mid Register; 0x0000002A ***/
typedef union {
  byte Byte;
  struct {
    byte BIT8        :1;                                       /* Comparator Address Mid Compare Bit 8 */
    byte BIT9        :1;                                       /* Comparator Address Mid Compare Bit 9 */
    byte BIT10       :1;                                       /* Comparator Address Mid Compare Bit 10 */
    byte BIT11       :1;                                       /* Comparator Address Mid Compare Bit 11 */
    byte BIT12       :1;                                       /* Comparator Address Mid Compare Bit 12 */
    byte BIT13       :1;                                       /* Comparator Address Mid Compare Bit 13 */
    byte BIT14       :1;                                       /* Comparator Address Mid Compare Bit 14 */
    byte BIT15       :1;                                       /* Comparator Address Mid Compare Bit 15 */
  } Bits;
} DBGXAMSTR;
extern volatile DBGXAMSTR _DBGXAM @(REG_BASE + 0x0000002AUL);
#define DBGXAM                          _DBGXAM.Byte
#define DBGXAM_BIT8                     _DBGXAM.Bits.BIT8
#define DBGXAM_BIT9                     _DBGXAM.Bits.BIT9
#define DBGXAM_BIT10                    _DBGXAM.Bits.BIT10
#define DBGXAM_BIT11                    _DBGXAM.Bits.BIT11
#define DBGXAM_BIT12                    _DBGXAM.Bits.BIT12
#define DBGXAM_BIT13                    _DBGXAM.Bits.BIT13
#define DBGXAM_BIT14                    _DBGXAM.Bits.BIT14
#define DBGXAM_BIT15                    _DBGXAM.Bits.BIT15

#define DBGXAM_BIT8_MASK                1U
#define DBGXAM_BIT9_MASK                2U
#define DBGXAM_BIT10_MASK               4U
#define DBGXAM_BIT11_MASK               8U
#define DBGXAM_BIT12_MASK               16U
#define DBGXAM_BIT13_MASK               32U
#define DBGXAM_BIT14_MASK               64U
#define DBGXAM_BIT15_MASK               128U


/*** DBGXAL - Debug Comparator Address Low Register; 0x0000002B ***/
typedef union {
  byte Byte;
  struct {
    byte BIT0        :1;                                       /* Comparator Address Low Compare Bit 0 */
    byte BIT1        :1;                                       /* Comparator Address Low Compare Bit 1 */
    byte BIT2        :1;                                       /* Comparator Address Low Compare Bit 2 */
    byte BIT3        :1;                                       /* Comparator Address Low Compare Bit 3 */
    byte BIT4        :1;                                       /* Comparator Address Low Compare Bit 4 */
    byte BIT5        :1;                                       /* Comparator Address Low Compare Bit 5 */
    byte BIT6        :1;                                       /* Comparator Address Low Compare Bit 6 */
    byte BIT7        :1;                                       /* Comparator Address Low Compare Bit 7 */
  } Bits;
} DBGXALSTR;
extern volatile DBGXALSTR _DBGXAL @(REG_BASE + 0x0000002BUL);
#define DBGXAL                          _DBGXAL.Byte
#define DBGXAL_BIT0                     _DBGXAL.Bits.BIT0
#define DBGXAL_BIT1                     _DBGXAL.Bits.BIT1
#define DBGXAL_BIT2                     _DBGXAL.Bits.BIT2
#define DBGXAL_BIT3                     _DBGXAL.Bits.BIT3
#define DBGXAL_BIT4                     _DBGXAL.Bits.BIT4
#define DBGXAL_BIT5                     _DBGXAL.Bits.BIT5
#define DBGXAL_BIT6                     _DBGXAL.Bits.BIT6
#define DBGXAL_BIT7                     _DBGXAL.Bits.BIT7

#define DBGXAL_BIT0_MASK                1U
#define DBGXAL_BIT1_MASK                2U
#define DBGXAL_BIT2_MASK                4U
#define DBGXAL_BIT3_MASK                8U
#define DBGXAL_BIT4_MASK                16U
#define DBGXAL_BIT5_MASK                32U
#define DBGXAL_BIT6_MASK                64U
#define DBGXAL_BIT7_MASK                128U


/*** DBGADH - Debug Comparator Data High Register; 0x0000002C ***/
typedef union {
  byte Byte;
  struct {
    byte BIT0        :1;                                       /* Comparator A Compare Bit 0 */
    byte BIT1        :1;                                       /* Comparator A Compare Bit 1 */
    byte BIT2        :1;                                       /* Comparator A Compare Bit 2 */
    byte BIT3        :1;                                       /* Comparator A Compare Bit 3 */
    byte BIT4        :1;                                       /* Comparator A Compare Bit 4 */
    byte BIT5        :1;                                       /* Comparator A Compare Bit 5 */
    byte BIT6        :1;                                       /* Comparator A Compare Bit 6 */
    byte BIT7        :1;                                       /* Comparator A Compare Bit 7 */
  } Bits;
} DBGADHSTR;
extern volatile DBGADHSTR _DBGADH @(REG_BASE + 0x0000002CUL);
#define DBGADH                          _DBGADH.Byte
#define DBGADH_BIT0                     _DBGADH.Bits.BIT0
#define DBGADH_BIT1                     _DBGADH.Bits.BIT1
#define DBGADH_BIT2                     _DBGADH.Bits.BIT2
#define DBGADH_BIT3                     _DBGADH.Bits.BIT3
#define DBGADH_BIT4                     _DBGADH.Bits.BIT4
#define DBGADH_BIT5                     _DBGADH.Bits.BIT5
#define DBGADH_BIT6                     _DBGADH.Bits.BIT6
#define DBGADH_BIT7                     _DBGADH.Bits.BIT7

#define DBGADH_BIT0_MASK                1U
#define DBGADH_BIT1_MASK                2U
#define DBGADH_BIT2_MASK                4U
#define DBGADH_BIT3_MASK                8U
#define DBGADH_BIT4_MASK                16U
#define DBGADH_BIT5_MASK                32U
#define DBGADH_BIT6_MASK                64U
#define DBGADH_BIT7_MASK                128U


/*** DBGADL - Debug Comparator Data Low Register; 0x0000002D ***/
typedef union {
  byte Byte;
  struct {
    byte BIT0        :1;                                       /* Comparator Address Low Compare Bit 0 */
    byte BIT1        :1;                                       /* Comparator Address Low Compare Bit 1 */
    byte BIT2        :1;                                       /* Comparator Address Low Compare Bit 2 */
    byte BIT3        :1;                                       /* Comparator Address Low Compare Bit 3 */
    byte BIT4        :1;                                       /* Comparator Address Low Compare Bit 4 */
    byte BIT5        :1;                                       /* Comparator Address Low Compare Bit 5 */
    byte BIT6        :1;                                       /* Comparator Address Low Compare Bit 6 */
    byte BIT7        :1;                                       /* Comparator Address Low Compare Bit 7 */
  } Bits;
} DBGADLSTR;
extern volatile DBGADLSTR _DBGADL @(REG_BASE + 0x0000002DUL);
#define DBGADL                          _DBGADL.Byte
#define DBGADL_BIT0                     _DBGADL.Bits.BIT0
#define DBGADL_BIT1                     _DBGADL.Bits.BIT1
#define DBGADL_BIT2                     _DBGADL.Bits.BIT2
#define DBGADL_BIT3                     _DBGADL.Bits.BIT3
#define DBGADL_BIT4                     _DBGADL.Bits.BIT4
#define DBGADL_BIT5                     _DBGADL.Bits.BIT5
#define DBGADL_BIT6                     _DBGADL.Bits.BIT6
#define DBGADL_BIT7                     _DBGADL.Bits.BIT7

#define DBGADL_BIT0_MASK                1U
#define DBGADL_BIT1_MASK                2U
#define DBGADL_BIT2_MASK                4U
#define DBGADL_BIT3_MASK                8U
#define DBGADL_BIT4_MASK                16U
#define DBGADL_BIT5_MASK                32U
#define DBGADL_BIT6_MASK                64U
#define DBGADL_BIT7_MASK                128U


/*** DBGADHM - Debug Comparator Data High Mask Register; 0x0000002E ***/
typedef union {
  byte Byte;
  struct {
    byte BIT8        :1;                                       /* Comparator Data High Mask Bit 8 */
    byte BIT9        :1;                                       /* Comparator Data High Mask Bit 9 */
    byte BIT10       :1;                                       /* Comparator Data High Mask Bit 10 */
    byte BIT11       :1;                                       /* Comparator Data High Mask Bit 11 */
    byte BIT12       :1;                                       /* Comparator Data High Mask Bit 12 */
    byte BIT13       :1;                                       /* Comparator Data High Mask Bit 13 */
    byte BIT14       :1;                                       /* Comparator Data High Mask Bit 14 */
    byte BIT15       :1;                                       /* Comparator Data High Mask Bit 15 */
  } Bits;
} DBGADHMSTR;
extern volatile DBGADHMSTR _DBGADHM @(REG_BASE + 0x0000002EUL);
#define DBGADHM                         _DBGADHM.Byte
#define DBGADHM_BIT8                    _DBGADHM.Bits.BIT8
#define DBGADHM_BIT9                    _DBGADHM.Bits.BIT9
#define DBGADHM_BIT10                   _DBGADHM.Bits.BIT10
#define DBGADHM_BIT11                   _DBGADHM.Bits.BIT11
#define DBGADHM_BIT12                   _DBGADHM.Bits.BIT12
#define DBGADHM_BIT13                   _DBGADHM.Bits.BIT13
#define DBGADHM_BIT14                   _DBGADHM.Bits.BIT14
#define DBGADHM_BIT15                   _DBGADHM.Bits.BIT15

#define DBGADHM_BIT8_MASK               1U
#define DBGADHM_BIT9_MASK               2U
#define DBGADHM_BIT10_MASK              4U
#define DBGADHM_BIT11_MASK              8U
#define DBGADHM_BIT12_MASK              16U
#define DBGADHM_BIT13_MASK              32U
#define DBGADHM_BIT14_MASK              64U
#define DBGADHM_BIT15_MASK              128U


/*** DBGADLM - Debug Comparator Data Low Mask Register; 0x0000002F ***/
typedef union {
  byte Byte;
  struct {
    byte BIT0        :1;                                       /* Comparator Data High Mask Bit 0 */
    byte BIT1        :1;                                       /* Comparator Data High Mask Bit 1 */
    byte BIT2        :1;                                       /* Comparator Data High Mask Bit 2 */
    byte BIT3        :1;                                       /* Comparator Data High Mask Bit 3 */
    byte BIT4        :1;                                       /* Comparator Data High Mask Bit 4 */
    byte BIT5        :1;                                       /* Comparator Data High Mask Bit 5 */
    byte BIT6        :1;                                       /* Comparator Data High Mask Bit 6 */
    byte BIT7        :1;                                       /* Comparator Data High Mask Bit 7 */
  } Bits;
} DBGADLMSTR;
extern volatile DBGADLMSTR _DBGADLM @(REG_BASE + 0x0000002FUL);
#define DBGADLM                         _DBGADLM.Byte
#define DBGADLM_BIT0                    _DBGADLM.Bits.BIT0
#define DBGADLM_BIT1                    _DBGADLM.Bits.BIT1
#define DBGADLM_BIT2                    _DBGADLM.Bits.BIT2
#define DBGADLM_BIT3                    _DBGADLM.Bits.BIT3
#define DBGADLM_BIT4                    _DBGADLM.Bits.BIT4
#define DBGADLM_BIT5                    _DBGADLM.Bits.BIT5
#define DBGADLM_BIT6                    _DBGADLM.Bits.BIT6
#define DBGADLM_BIT7                    _DBGADLM.Bits.BIT7

#define DBGADLM_BIT0_MASK               1U
#define DBGADLM_BIT1_MASK               2U
#define DBGADLM_BIT2_MASK               4U
#define DBGADLM_BIT3_MASK               8U
#define DBGADLM_BIT4_MASK               16U
#define DBGADLM_BIT5_MASK               32U
#define DBGADLM_BIT6_MASK               64U
#define DBGADLM_BIT7_MASK               128U


/*** PPAGE - Page Index Register; 0x00000030 ***/
typedef union {
  byte Byte;
  struct {
    byte PIX0        :1;                                       /* Page Index Register Bit 0 */
    byte PIX1        :1;                                       /* Page Index Register Bit 1 */
    byte PIX2        :1;                                       /* Page Index Register Bit 2 */
    byte PIX3        :1;                                       /* Page Index Register Bit 3 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpPIX  :4;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} PPAGESTR;
extern volatile PPAGESTR _PPAGE @(REG_BASE + 0x00000030UL);
#define PPAGE                           _PPAGE.Byte
#define PPAGE_PIX0                      _PPAGE.Bits.PIX0
#define PPAGE_PIX1                      _PPAGE.Bits.PIX1
#define PPAGE_PIX2                      _PPAGE.Bits.PIX2
#define PPAGE_PIX3                      _PPAGE.Bits.PIX3
#define PPAGE_PIX                       _PPAGE.MergedBits.grpPIX

#define PPAGE_PIX0_MASK                 1U
#define PPAGE_PIX1_MASK                 2U
#define PPAGE_PIX2_MASK                 4U
#define PPAGE_PIX3_MASK                 8U
#define PPAGE_PIX_MASK                  15U
#define PPAGE_PIX_BITNUM                0U


/*** DIRECT - Direct Page Register; 0x00000031 ***/
typedef union {
  byte Byte;
  struct {
    byte DP8         :1;                                       /* Direct Page Bit 8 */
    byte DP9         :1;                                       /* Direct Page Bit 9 */
    byte DP10        :1;                                       /* Direct Page Bit 10 */
    byte DP11        :1;                                       /* Direct Page Bit 11 */
    byte DP12        :1;                                       /* Direct Page Bit 12 */
    byte DP13        :1;                                       /* Direct Page Bit 13 */
    byte DP14        :1;                                       /* Direct Page Bit 14 */
    byte DP15        :1;                                       /* Direct Page Bit 15 */
  } Bits;
} DIRECTSTR;
extern volatile DIRECTSTR _DIRECT @(REG_BASE + 0x00000031UL);
#define DIRECT                          _DIRECT.Byte
#define DIRECT_DP8                      _DIRECT.Bits.DP8
#define DIRECT_DP9                      _DIRECT.Bits.DP9
#define DIRECT_DP10                     _DIRECT.Bits.DP10
#define DIRECT_DP11                     _DIRECT.Bits.DP11
#define DIRECT_DP12                     _DIRECT.Bits.DP12
#define DIRECT_DP13                     _DIRECT.Bits.DP13
#define DIRECT_DP14                     _DIRECT.Bits.DP14
#define DIRECT_DP15                     _DIRECT.Bits.DP15

#define DIRECT_DP8_MASK                 1U
#define DIRECT_DP9_MASK                 2U
#define DIRECT_DP10_MASK                4U
#define DIRECT_DP11_MASK                8U
#define DIRECT_DP12_MASK                16U
#define DIRECT_DP13_MASK                32U
#define DIRECT_DP14_MASK                64U
#define DIRECT_DP15_MASK                128U


/*** MODE - Mode Register; 0x00000032 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte MODC        :1;                                       /* Mode Select Bit C */
  } Bits;
} MODESTR;
extern volatile MODESTR _MODE @(REG_BASE + 0x00000032UL);
#define MODE                            _MODE.Byte
#define MODE_MODC                       _MODE.Bits.MODC

#define MODE_MODC_MASK                  128U


/*** MMCCTL1 - MMCCTL1 Register; 0x00000033 ***/
typedef union {
  byte Byte;
  struct {
    byte IFRON       :1;                                       /* IFRON */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} MMCCTL1STR;
extern volatile MMCCTL1STR _MMCCTL1 @(REG_BASE + 0x00000033UL);
#define MMCCTL1                         _MMCCTL1.Byte
#define MMCCTL1_IFRON                   _MMCCTL1.Bits.IFRON

#define MMCCTL1_IFRON_MASK              1U


/*** CRGCTL0 - S12SCRG Control Register 0; 0x00000034 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte OSC4MHZ     :1;                                       /* 4MHz Oscillator low pass filter select Bit */
    byte REFS        :1;                                       /* Reference Select Bit */
    byte BCLKS       :1;                                       /* Bus Clock Source Select Bit */
    byte RDIV0       :1;                                       /* Reference Divider Bits, bit 0 */
    byte RDIV1       :1;                                       /* Reference Divider Bits, bit 1 */
    byte RDIV2       :1;                                       /* Reference Divider Bits, bit 2 */
    byte OSCEN       :1;                                       /* Oscillator Enable Bit */
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte grpRDIV :3;
    byte         :1;
  } MergedBits;
} CRGCTL0STR;
extern volatile CRGCTL0STR _CRGCTL0 @(REG_BASE + 0x00000034UL);
#define CRGCTL0                         _CRGCTL0.Byte
#define CRGCTL0_OSC4MHZ                 _CRGCTL0.Bits.OSC4MHZ
#define CRGCTL0_REFS                    _CRGCTL0.Bits.REFS
#define CRGCTL0_BCLKS                   _CRGCTL0.Bits.BCLKS
#define CRGCTL0_RDIV0                   _CRGCTL0.Bits.RDIV0
#define CRGCTL0_RDIV1                   _CRGCTL0.Bits.RDIV1
#define CRGCTL0_RDIV2                   _CRGCTL0.Bits.RDIV2
#define CRGCTL0_OSCEN                   _CRGCTL0.Bits.OSCEN
/* CRGCTL_ARR: Access 2 CRGCTLx registers in an array */
#define CRGCTL_ARR                      ((volatile byte *) &CRGCTL0)
#define CRGCTL0_RDIV                    _CRGCTL0.MergedBits.grpRDIV

#define CRGCTL0_OSC4MHZ_MASK            2U
#define CRGCTL0_REFS_MASK               4U
#define CRGCTL0_BCLKS_MASK              8U
#define CRGCTL0_RDIV0_MASK              16U
#define CRGCTL0_RDIV1_MASK              32U
#define CRGCTL0_RDIV2_MASK              64U
#define CRGCTL0_OSCEN_MASK              128U
#define CRGCTL0_RDIV_MASK               112U
#define CRGCTL0_RDIV_BITNUM             4U


/*** CRGCTL1 - S12SCRG Control Register 1; 0x00000035 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte LOCKIE      :1;                                       /* FLL Lock Interrupt Enable Bit */
    byte             :1; 
    byte             :1; 
    byte BDIV0       :1;                                       /* Bus Divider Bits, bit 0 */
    byte BDIV1       :1;                                       /* Bus Divider Bits, bit 1 */
    byte BDIV2       :1;                                       /* Bus Divider Bits, bit 2 */
    byte BDIV3       :1;                                       /* Bus Divider Bits, bit 3 */
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte grpBDIV :4;
  } MergedBits;
} CRGCTL1STR;
extern volatile CRGCTL1STR _CRGCTL1 @(REG_BASE + 0x00000035UL);
#define CRGCTL1                         _CRGCTL1.Byte
#define CRGCTL1_LOCKIE                  _CRGCTL1.Bits.LOCKIE
#define CRGCTL1_BDIV0                   _CRGCTL1.Bits.BDIV0
#define CRGCTL1_BDIV1                   _CRGCTL1.Bits.BDIV1
#define CRGCTL1_BDIV2                   _CRGCTL1.Bits.BDIV2
#define CRGCTL1_BDIV3                   _CRGCTL1.Bits.BDIV3
#define CRGCTL1_BDIV                    _CRGCTL1.MergedBits.grpBDIV

#define CRGCTL1_LOCKIE_MASK             2U
#define CRGCTL1_BDIV0_MASK              16U
#define CRGCTL1_BDIV1_MASK              32U
#define CRGCTL1_BDIV2_MASK              64U
#define CRGCTL1_BDIV3_MASK              128U
#define CRGCTL1_BDIV_MASK               240U
#define CRGCTL1_BDIV_BITNUM             4U


/*** CRGMULT - S12SCRG FLL Multiply Register; 0x00000036 ***/
typedef union {
  byte Byte;
  struct {
    byte MULT0       :1;                                       /* FLL Multiplier Bits, bit 0 */
    byte MULT1       :1;                                       /* FLL Multiplier Bits, bit 1 */
    byte MULT2       :1;                                       /* FLL Multiplier Bits, bit 2 */
    byte MULT3       :1;                                       /* FLL Multiplier Bits, bit 3 */
    byte MULT4       :1;                                       /* FLL Multiplier Bits, bit 4 */
    byte MULT5       :1;                                       /* FLL Multiplier Bits, bit 5 */
    byte MULT6       :1;                                       /* FLL Multiplier Bits, bit 6 */
    byte             :1; 
  } Bits;
  struct {
    byte grpMULT :7;
    byte         :1;
  } MergedBits;
} CRGMULTSTR;
extern volatile CRGMULTSTR _CRGMULT @(REG_BASE + 0x00000036UL);
#define CRGMULT                         _CRGMULT.Byte
#define CRGMULT_MULT0                   _CRGMULT.Bits.MULT0
#define CRGMULT_MULT1                   _CRGMULT.Bits.MULT1
#define CRGMULT_MULT2                   _CRGMULT.Bits.MULT2
#define CRGMULT_MULT3                   _CRGMULT.Bits.MULT3
#define CRGMULT_MULT4                   _CRGMULT.Bits.MULT4
#define CRGMULT_MULT5                   _CRGMULT.Bits.MULT5
#define CRGMULT_MULT6                   _CRGMULT.Bits.MULT6
#define CRGMULT_MULT                    _CRGMULT.MergedBits.grpMULT

#define CRGMULT_MULT0_MASK              1U
#define CRGMULT_MULT1_MASK              2U
#define CRGMULT_MULT2_MASK              4U
#define CRGMULT_MULT3_MASK              8U
#define CRGMULT_MULT4_MASK              16U
#define CRGMULT_MULT5_MASK              32U
#define CRGMULT_MULT6_MASK              64U
#define CRGMULT_MULT_MASK               127U
#define CRGMULT_MULT_BITNUM             0U


/*** CRGFLG - S12SCRG Flags Register; 0x00000037 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte UPOSC       :1;                                       /* Oscillator Startup Status Bit */
    byte ILAF        :1;                                       /* Illegal Address Reset Flag */
    byte LOCKST      :1;                                       /* Lock Status Bit */
    byte LOCKIF      :1;                                       /* FLL Lock Interrupt Flag */
    byte             :1; 
    byte PORF        :1;                                       /* Power-On Reset Flag */
    byte             :1; 
  } Bits;
} CRGFLGSTR;
extern volatile CRGFLGSTR _CRGFLG @(REG_BASE + 0x00000037UL);
#define CRGFLG                          _CRGFLG.Byte
#define CRGFLG_UPOSC                    _CRGFLG.Bits.UPOSC
#define CRGFLG_ILAF                     _CRGFLG.Bits.ILAF
#define CRGFLG_LOCKST                   _CRGFLG.Bits.LOCKST
#define CRGFLG_LOCKIF                   _CRGFLG.Bits.LOCKIF
#define CRGFLG_PORF                     _CRGFLG.Bits.PORF

#define CRGFLG_UPOSC_MASK               2U
#define CRGFLG_ILAF_MASK                4U
#define CRGFLG_LOCKST_MASK              8U
#define CRGFLG_LOCKIF_MASK              16U
#define CRGFLG_PORF_MASK                64U


/*** CRGTRIM - S12SCRG TRIM Register High; 0x00000038 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** CRGTRIMH - S12SCRG TRIM Register High Byte; 0x00000038 ***/
    union {
      byte Byte;
      struct {
        byte TRIM8       :1;                                       /* Trim Bit 8 for Internal Reference Clock */
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
      } Bits;
    } CRGTRIMHSTR;
    #define CRGTRIMH                    _CRGTRIM.Overlap_STR.CRGTRIMHSTR.Byte
    #define CRGTRIMH_TRIM8              _CRGTRIM.Overlap_STR.CRGTRIMHSTR.Bits.TRIM8
    
    #define CRGTRIMH_TRIM8_MASK         1U
    

    /*** CRGTRIML - S12SCRG Trim Register Low Byte; 0x00000039 ***/
    union {
      byte Byte;
      struct {
        byte TRIM0       :1;                                       /* Trim Bit 0 for Internal Reference Clock */
        byte TRIM1       :1;                                       /* Trim Bit 1 for Internal Reference Clock */
        byte TRIM2       :1;                                       /* Trim Bit 2 for Internal Reference Clock */
        byte TRIM3       :1;                                       /* Trim Bit 3 for Internal Reference Clock */
        byte TRIM4       :1;                                       /* Trim Bit 4 for Internal Reference Clock */
        byte TRIM5       :1;                                       /* Trim Bit 5 for Internal Reference Clock */
        byte TRIM6       :1;                                       /* Trim Bit 6 for Internal Reference Clock */
        byte TRIM7       :1;                                       /* Trim Bit 7 for Internal Reference Clock */
      } Bits;
    } CRGTRIMLSTR;
    #define CRGTRIML                    _CRGTRIM.Overlap_STR.CRGTRIMLSTR.Byte
    #define CRGTRIML_TRIM0              _CRGTRIM.Overlap_STR.CRGTRIMLSTR.Bits.TRIM0
    #define CRGTRIML_TRIM1              _CRGTRIM.Overlap_STR.CRGTRIMLSTR.Bits.TRIM1
    #define CRGTRIML_TRIM2              _CRGTRIM.Overlap_STR.CRGTRIMLSTR.Bits.TRIM2
    #define CRGTRIML_TRIM3              _CRGTRIM.Overlap_STR.CRGTRIMLSTR.Bits.TRIM3
    #define CRGTRIML_TRIM4              _CRGTRIM.Overlap_STR.CRGTRIMLSTR.Bits.TRIM4
    #define CRGTRIML_TRIM5              _CRGTRIM.Overlap_STR.CRGTRIMLSTR.Bits.TRIM5
    #define CRGTRIML_TRIM6              _CRGTRIM.Overlap_STR.CRGTRIMLSTR.Bits.TRIM6
    #define CRGTRIML_TRIM7              _CRGTRIM.Overlap_STR.CRGTRIMLSTR.Bits.TRIM7
    
    #define CRGTRIML_TRIM0_MASK         1U
    #define CRGTRIML_TRIM1_MASK         2U
    #define CRGTRIML_TRIM2_MASK         4U
    #define CRGTRIML_TRIM3_MASK         8U
    #define CRGTRIML_TRIM4_MASK         16U
    #define CRGTRIML_TRIM5_MASK         32U
    #define CRGTRIML_TRIM6_MASK         64U
    #define CRGTRIML_TRIM7_MASK         128U
    
  } Overlap_STR;

  struct {
    word TRIM0       :1;                                       /* Trim Bit 0 for Internal Reference Clock */
    word TRIM1       :1;                                       /* Trim Bit 1 for Internal Reference Clock */
    word TRIM2       :1;                                       /* Trim Bit 2 for Internal Reference Clock */
    word TRIM3       :1;                                       /* Trim Bit 3 for Internal Reference Clock */
    word TRIM4       :1;                                       /* Trim Bit 4 for Internal Reference Clock */
    word TRIM5       :1;                                       /* Trim Bit 5 for Internal Reference Clock */
    word TRIM6       :1;                                       /* Trim Bit 6 for Internal Reference Clock */
    word TRIM7       :1;                                       /* Trim Bit 7 for Internal Reference Clock */
    word TRIM8       :1;                                       /* Trim Bit 8 for Internal Reference Clock */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
  struct {
    word grpTRIM :9;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} CRGTRIMSTR;
extern volatile CRGTRIMSTR _CRGTRIM @(REG_BASE + 0x00000038UL);
#define CRGTRIM                         _CRGTRIM.Word
#define CRGTRIM_TRIM0                   _CRGTRIM.Bits.TRIM0
#define CRGTRIM_TRIM1                   _CRGTRIM.Bits.TRIM1
#define CRGTRIM_TRIM2                   _CRGTRIM.Bits.TRIM2
#define CRGTRIM_TRIM3                   _CRGTRIM.Bits.TRIM3
#define CRGTRIM_TRIM4                   _CRGTRIM.Bits.TRIM4
#define CRGTRIM_TRIM5                   _CRGTRIM.Bits.TRIM5
#define CRGTRIM_TRIM6                   _CRGTRIM.Bits.TRIM6
#define CRGTRIM_TRIM7                   _CRGTRIM.Bits.TRIM7
#define CRGTRIM_TRIM8                   _CRGTRIM.Bits.TRIM8
#define CRGTRIM_TRIM                    _CRGTRIM.MergedBits.grpTRIM

#define CRGTRIM_TRIM0_MASK              1U
#define CRGTRIM_TRIM1_MASK              2U
#define CRGTRIM_TRIM2_MASK              4U
#define CRGTRIM_TRIM3_MASK              8U
#define CRGTRIM_TRIM4_MASK              16U
#define CRGTRIM_TRIM5_MASK              32U
#define CRGTRIM_TRIM6_MASK              64U
#define CRGTRIM_TRIM7_MASK              128U
#define CRGTRIM_TRIM8_MASK              256U
#define CRGTRIM_TRIM_MASK               511U
#define CRGTRIM_TRIM_BITNUM             0U


/*** RTICTL - CRG RTI Control Register; 0x0000003C ***/
typedef union {
  byte Byte;
  struct {
    byte RTR0        :1;                                       /* Real Time Interrupt Modulus Counter Select Bit 0 */
    byte RTR1        :1;                                       /* Real Time Interrupt Modulus Counter Select Bit 1 */
    byte RTIE        :1;                                       /* Real Time Interrupt Enable Bit */
    byte RTIRSTP     :1;                                       /* RTI Runs in Stop Mode Bit */
    byte RTISWAI     :1;                                       /* RTI Stops in Wait Mode Bit */
    byte WRTMASK     :1;                                       /* Write Mask for RTIF, RTISWAI, RTIRSTP, RTIE and RTIRT[1:0] Bits */
    byte RTIFRZ      :1;                                       /* Real Time Interrupt Freeze */
    byte RTIF        :1;                                       /* Real Time Interrupt Flag */
  } Bits;
  struct {
    byte grpRTR  :2;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} RTICTLSTR;
extern volatile RTICTLSTR _RTICTL @(REG_BASE + 0x0000003CUL);
#define RTICTL                          _RTICTL.Byte
#define RTICTL_RTR0                     _RTICTL.Bits.RTR0
#define RTICTL_RTR1                     _RTICTL.Bits.RTR1
#define RTICTL_RTIE                     _RTICTL.Bits.RTIE
#define RTICTL_RTIRSTP                  _RTICTL.Bits.RTIRSTP
#define RTICTL_RTISWAI                  _RTICTL.Bits.RTISWAI
#define RTICTL_WRTMASK                  _RTICTL.Bits.WRTMASK
#define RTICTL_RTIFRZ                   _RTICTL.Bits.RTIFRZ
#define RTICTL_RTIF                     _RTICTL.Bits.RTIF
#define RTICTL_RTR                      _RTICTL.MergedBits.grpRTR

#define RTICTL_RTR0_MASK                1U
#define RTICTL_RTR1_MASK                2U
#define RTICTL_RTIE_MASK                4U
#define RTICTL_RTIRSTP_MASK             8U
#define RTICTL_RTISWAI_MASK             16U
#define RTICTL_WRTMASK_MASK             32U
#define RTICTL_RTIFRZ_MASK              64U
#define RTICTL_RTIF_MASK                128U
#define RTICTL_RTR_MASK                 3U
#define RTICTL_RTR_BITNUM               0U


/*** RTICNT - RTI Counter select bits; 0x0000003D ***/
typedef union {
  byte Byte;
  struct {
    byte RTICNT0     :1;                                       /* RTI Counter select bit 0 */
    byte RTICNT1     :1;                                       /* RTI Counter select bit 1 */
    byte RTICNT2     :1;                                       /* RTI Counter select bit 2 */
    byte RTICNT3     :1;                                       /* RTI Counter select bit 3 */
    byte RTICNT4     :1;                                       /* RTI Counter select bit 4 */
    byte RTICNT5     :1;                                       /* RTI Counter select bit 5 */
    byte RTICNT6     :1;                                       /* RTI Counter select bit 6 */
    byte RTICNT7     :1;                                       /* RTI Counter select bit 7 */
  } Bits;
} RTICNTSTR;
extern volatile RTICNTSTR _RTICNT @(REG_BASE + 0x0000003DUL);
#define RTICNT                          _RTICNT.Byte
#define RTICNT_RTICNT0                  _RTICNT.Bits.RTICNT0
#define RTICNT_RTICNT1                  _RTICNT.Bits.RTICNT1
#define RTICNT_RTICNT2                  _RTICNT.Bits.RTICNT2
#define RTICNT_RTICNT3                  _RTICNT.Bits.RTICNT3
#define RTICNT_RTICNT4                  _RTICNT.Bits.RTICNT4
#define RTICNT_RTICNT5                  _RTICNT.Bits.RTICNT5
#define RTICNT_RTICNT6                  _RTICNT.Bits.RTICNT6
#define RTICNT_RTICNT7                  _RTICNT.Bits.RTICNT7

#define RTICNT_RTICNT0_MASK             1U
#define RTICNT_RTICNT1_MASK             2U
#define RTICNT_RTICNT2_MASK             4U
#define RTICNT_RTICNT3_MASK             8U
#define RTICNT_RTICNT4_MASK             16U
#define RTICNT_RTICNT5_MASK             32U
#define RTICNT_RTICNT6_MASK             64U
#define RTICNT_RTICNT7_MASK             128U


/*** COPCTL - CRG COP Control Register; 0x0000003E ***/
typedef union {
  byte Byte;
  struct {
    byte CR0         :1;                                       /* COP Watchdog Timer Rate select Bit 0 */
    byte CR1         :1;                                       /* COP Watchdog Timer Rate select Bit 1 */
    byte CR2         :1;                                       /* COP Watchdog Timer Rate select Bit 2 */
    byte COPRSTP     :1;                                       /* COP Runs in Stop Mode Bit */
    byte COPSWAI     :1;                                       /* COP Stops in Wait Mode Bit */
    byte WRTMASK     :1;                                       /* Write Mask for WCOP and CR[2:0] Bit */
    byte RSBCK       :1;                                       /* COP and RTI stop in Active BDM mode Bit */
    byte WCOP        :1;                                       /* Window COP mode */
  } Bits;
  struct {
    byte grpCR   :3;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} COPCTLSTR;
extern volatile COPCTLSTR _COPCTL @(REG_BASE + 0x0000003EUL);
#define COPCTL                          _COPCTL.Byte
#define COPCTL_CR0                      _COPCTL.Bits.CR0
#define COPCTL_CR1                      _COPCTL.Bits.CR1
#define COPCTL_CR2                      _COPCTL.Bits.CR2
#define COPCTL_COPRSTP                  _COPCTL.Bits.COPRSTP
#define COPCTL_COPSWAI                  _COPCTL.Bits.COPSWAI
#define COPCTL_WRTMASK                  _COPCTL.Bits.WRTMASK
#define COPCTL_RSBCK                    _COPCTL.Bits.RSBCK
#define COPCTL_WCOP                     _COPCTL.Bits.WCOP
#define COPCTL_CR                       _COPCTL.MergedBits.grpCR

#define COPCTL_CR0_MASK                 1U
#define COPCTL_CR1_MASK                 2U
#define COPCTL_CR2_MASK                 4U
#define COPCTL_COPRSTP_MASK             8U
#define COPCTL_COPSWAI_MASK             16U
#define COPCTL_WRTMASK_MASK             32U
#define COPCTL_RSBCK_MASK               64U
#define COPCTL_WCOP_MASK                128U
#define COPCTL_CR_MASK                  7U
#define COPCTL_CR_BITNUM                0U


/*** ARMCOP - CRG COP Timer Arm/Reset Register; 0x0000003F ***/
typedef union {
  byte Byte;
  struct {
    byte BIT0        :1;                                       /* CRG COP Timer Arm/Reset Bit 0 */
    byte BIT1        :1;                                       /* CRG COP Timer Arm/Reset Bit 1 */
    byte BIT2        :1;                                       /* CRG COP Timer Arm/Reset Bit 2 */
    byte BIT3        :1;                                       /* CRG COP Timer Arm/Reset Bit 3 */
    byte BIT4        :1;                                       /* CRG COP Timer Arm/Reset Bit 4 */
    byte BIT5        :1;                                       /* CRG COP Timer Arm/Reset Bit 5 */
    byte BIT6        :1;                                       /* CRG COP Timer Arm/Reset Bit 6 */
    byte BIT7        :1;                                       /* CRG COP Timer Arm/Reset Bit 7 */
  } Bits;
} ARMCOPSTR;
extern volatile ARMCOPSTR _ARMCOP @(REG_BASE + 0x0000003FUL);
#define ARMCOP                          _ARMCOP.Byte
#define ARMCOP_BIT0                     _ARMCOP.Bits.BIT0
#define ARMCOP_BIT1                     _ARMCOP.Bits.BIT1
#define ARMCOP_BIT2                     _ARMCOP.Bits.BIT2
#define ARMCOP_BIT3                     _ARMCOP.Bits.BIT3
#define ARMCOP_BIT4                     _ARMCOP.Bits.BIT4
#define ARMCOP_BIT5                     _ARMCOP.Bits.BIT5
#define ARMCOP_BIT6                     _ARMCOP.Bits.BIT6
#define ARMCOP_BIT7                     _ARMCOP.Bits.BIT7

#define ARMCOP_BIT0_MASK                1U
#define ARMCOP_BIT1_MASK                2U
#define ARMCOP_BIT2_MASK                4U
#define ARMCOP_BIT3_MASK                8U
#define ARMCOP_BIT4_MASK                16U
#define ARMCOP_BIT5_MASK                32U
#define ARMCOP_BIT6_MASK                64U
#define ARMCOP_BIT7_MASK                128U


/*** D2DCTL0 - D2DI Control Register 0; 0x000000D8 ***/
typedef union {
  byte Byte;
  struct {
    byte D2DCLKDIV0  :1;                                       /* Interface Clock Divider, bit 0 */
    byte D2DCLKDIV1  :1;                                       /* Interface Clock Divider, bit 1 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte D2DSWAI     :1;                                       /* D2D Stop In Wait */
    byte D2DCW       :1;                                       /* D2D Connection Width */
    byte D2DEN       :1;                                       /* D2DI Enable */
  } Bits;
  struct {
    byte grpD2DCLKDIV :2;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} D2DCTL0STR;
extern volatile D2DCTL0STR _D2DCTL0 @(REG_BASE + 0x000000D8UL);
#define D2DCTL0                         _D2DCTL0.Byte
#define D2DCTL0_D2DCLKDIV0              _D2DCTL0.Bits.D2DCLKDIV0
#define D2DCTL0_D2DCLKDIV1              _D2DCTL0.Bits.D2DCLKDIV1
#define D2DCTL0_D2DSWAI                 _D2DCTL0.Bits.D2DSWAI
#define D2DCTL0_D2DCW                   _D2DCTL0.Bits.D2DCW
#define D2DCTL0_D2DEN                   _D2DCTL0.Bits.D2DEN
/* D2DCTL_ARR: Access 2 D2DCTLx registers in an array */
#define D2DCTL_ARR                      ((volatile byte *) &D2DCTL0)
#define D2DCTL0_D2DCLKDIV               _D2DCTL0.MergedBits.grpD2DCLKDIV

#define D2DCTL0_D2DCLKDIV0_MASK         1U
#define D2DCTL0_D2DCLKDIV1_MASK         2U
#define D2DCTL0_D2DSWAI_MASK            32U
#define D2DCTL0_D2DCW_MASK              64U
#define D2DCTL0_D2DEN_MASK              128U
#define D2DCTL0_D2DCLKDIV_MASK          3U
#define D2DCTL0_D2DCLKDIV_BITNUM        0U


/*** D2DCTL1 - D2DI Control Register 1; 0x000000D9 ***/
typedef union {
  byte Byte;
  struct {
    byte TIMOUT0     :1;                                       /* Time-out Setting, bit 0 */
    byte TIMOUT1     :1;                                       /* Time-out Setting, bit 1 */
    byte TIMOUT2     :1;                                       /* Time-out Setting, bit 2 */
    byte TIMOUT3     :1;                                       /* Time-out Setting, bit 3 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte D2DIE       :1;                                       /* D2D Interrupt Enable */
  } Bits;
  struct {
    byte grpTIMOUT :4;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} D2DCTL1STR;
extern volatile D2DCTL1STR _D2DCTL1 @(REG_BASE + 0x000000D9UL);
#define D2DCTL1                         _D2DCTL1.Byte
#define D2DCTL1_TIMOUT0                 _D2DCTL1.Bits.TIMOUT0
#define D2DCTL1_TIMOUT1                 _D2DCTL1.Bits.TIMOUT1
#define D2DCTL1_TIMOUT2                 _D2DCTL1.Bits.TIMOUT2
#define D2DCTL1_TIMOUT3                 _D2DCTL1.Bits.TIMOUT3
#define D2DCTL1_D2DIE                   _D2DCTL1.Bits.D2DIE
#define D2DCTL1_TIMOUT                  _D2DCTL1.MergedBits.grpTIMOUT

#define D2DCTL1_TIMOUT0_MASK            1U
#define D2DCTL1_TIMOUT1_MASK            2U
#define D2DCTL1_TIMOUT2_MASK            4U
#define D2DCTL1_TIMOUT3_MASK            8U
#define D2DCTL1_D2DIE_MASK              128U
#define D2DCTL1_TIMOUT_MASK             15U
#define D2DCTL1_TIMOUT_BITNUM           0U


/*** D2DSTAT0 - D2DI Status Register 0; 0x000000DA ***/
typedef union {
  byte Byte;
  struct {
    byte PAR0        :1;                                       /* Parity Bit 0 */
    byte PAR1        :1;                                       /* Parity Bit 1 */
    byte PARF        :1;                                       /* Parity Error Flag */
    byte TERRF       :1;                                       /* Transaction Error Flag */
    byte TIMEF       :1;                                       /* Time Out Error Flag */
    byte CNCLF       :1;                                       /* CNCLF */
    byte ACKERF      :1;                                       /* Acknowledge Error Flag */
    byte ERRIF       :1;                                       /* D2DI error interrupt flag */
  } Bits;
  struct {
    byte grpPAR  :2;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} D2DSTAT0STR;
extern volatile D2DSTAT0STR _D2DSTAT0 @(REG_BASE + 0x000000DAUL);
#define D2DSTAT0                        _D2DSTAT0.Byte
#define D2DSTAT0_PAR0                   _D2DSTAT0.Bits.PAR0
#define D2DSTAT0_PAR1                   _D2DSTAT0.Bits.PAR1
#define D2DSTAT0_PARF                   _D2DSTAT0.Bits.PARF
#define D2DSTAT0_TERRF                  _D2DSTAT0.Bits.TERRF
#define D2DSTAT0_TIMEF                  _D2DSTAT0.Bits.TIMEF
#define D2DSTAT0_CNCLF                  _D2DSTAT0.Bits.CNCLF
#define D2DSTAT0_ACKERF                 _D2DSTAT0.Bits.ACKERF
#define D2DSTAT0_ERRIF                  _D2DSTAT0.Bits.ERRIF
/* D2DSTAT_ARR: Access 2 D2DSTATx registers in an array */
#define D2DSTAT_ARR                     ((volatile byte *) &D2DSTAT0)
#define D2DSTAT0_PAR                    _D2DSTAT0.MergedBits.grpPAR

#define D2DSTAT0_PAR0_MASK              1U
#define D2DSTAT0_PAR1_MASK              2U
#define D2DSTAT0_PARF_MASK              4U
#define D2DSTAT0_TERRF_MASK             8U
#define D2DSTAT0_TIMEF_MASK             16U
#define D2DSTAT0_CNCLF_MASK             32U
#define D2DSTAT0_ACKERF_MASK            64U
#define D2DSTAT0_ERRIF_MASK             128U
#define D2DSTAT0_PAR_MASK               3U
#define D2DSTAT0_PAR_BITNUM             0U


/*** D2DSTAT1 - D2DI Status Register 1; 0x000000DB ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte D2DBSY      :1;                                       /* D2D Initiator Busy */
    byte D2DIF       :1;                                       /* D2D Interrupt Flag */
  } Bits;
} D2DSTAT1STR;
extern volatile D2DSTAT1STR _D2DSTAT1 @(REG_BASE + 0x000000DBUL);
#define D2DSTAT1                        _D2DSTAT1.Byte
#define D2DSTAT1_D2DBSY                 _D2DSTAT1.Bits.D2DBSY
#define D2DSTAT1_D2DIF                  _D2DSTAT1.Bits.D2DIF

#define D2DSTAT1_D2DBSY_MASK            64U
#define D2DSTAT1_D2DIF_MASK             128U


/*** D2DADR - D2DI Address Buffer Register; 0x000000DC ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** D2DADRHI - D2DI Address Buffer Register High; 0x000000DC ***/
    union {
      byte Byte;
      struct {
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte NBLK        :1;                                       /* Transaction Mode */
        byte             :1; 
        byte SZ8         :1;                                       /* Transaction Size */
        byte RWB         :1;                                       /* Transaction Read-Write Direction */
      } Bits;
    } D2DADRHISTR;
    #define D2DADRHI                    _D2DADR.Overlap_STR.D2DADRHISTR.Byte
    #define D2DADRHI_NBLK               _D2DADR.Overlap_STR.D2DADRHISTR.Bits.NBLK
    #define D2DADRHI_SZ8                _D2DADR.Overlap_STR.D2DADRHISTR.Bits.SZ8
    #define D2DADRHI_RWB                _D2DADR.Overlap_STR.D2DADRHISTR.Bits.RWB
    
    #define D2DADRHI_NBLK_MASK          16U
    #define D2DADRHI_SZ8_MASK           64U
    #define D2DADRHI_RWB_MASK           128U
    

    /*** D2DADRLO - D2DI Address Buffer Register Low; 0x000000DD ***/
    union {
      byte Byte;
      struct {
        byte ADR0        :1;                                       /* Transaction Address Bit 0 */
        byte ADR1        :1;                                       /* Transaction Address Bit 1 */
        byte ADR2        :1;                                       /* Transaction Address Bit 2 */
        byte ADR3        :1;                                       /* Transaction Address Bit 3 */
        byte ADR4        :1;                                       /* Transaction Address Bit 4 */
        byte ADR5        :1;                                       /* Transaction Address Bit 5 */
        byte ADR6        :1;                                       /* Transaction Address Bit 6 */
        byte ADR7        :1;                                       /* Transaction Address Bit 7 */
      } Bits;
    } D2DADRLOSTR;
    #define D2DADRLO                    _D2DADR.Overlap_STR.D2DADRLOSTR.Byte
    #define D2DADRLO_ADR0               _D2DADR.Overlap_STR.D2DADRLOSTR.Bits.ADR0
    #define D2DADRLO_ADR1               _D2DADR.Overlap_STR.D2DADRLOSTR.Bits.ADR1
    #define D2DADRLO_ADR2               _D2DADR.Overlap_STR.D2DADRLOSTR.Bits.ADR2
    #define D2DADRLO_ADR3               _D2DADR.Overlap_STR.D2DADRLOSTR.Bits.ADR3
    #define D2DADRLO_ADR4               _D2DADR.Overlap_STR.D2DADRLOSTR.Bits.ADR4
    #define D2DADRLO_ADR5               _D2DADR.Overlap_STR.D2DADRLOSTR.Bits.ADR5
    #define D2DADRLO_ADR6               _D2DADR.Overlap_STR.D2DADRLOSTR.Bits.ADR6
    #define D2DADRLO_ADR7               _D2DADR.Overlap_STR.D2DADRLOSTR.Bits.ADR7
    
    #define D2DADRLO_ADR0_MASK          1U
    #define D2DADRLO_ADR1_MASK          2U
    #define D2DADRLO_ADR2_MASK          4U
    #define D2DADRLO_ADR3_MASK          8U
    #define D2DADRLO_ADR4_MASK          16U
    #define D2DADRLO_ADR5_MASK          32U
    #define D2DADRLO_ADR6_MASK          64U
    #define D2DADRLO_ADR7_MASK          128U
    
  } Overlap_STR;

  struct {
    word ADR0        :1;                                       /* Transaction Address Bit 0 */
    word ADR1        :1;                                       /* Transaction Address Bit 1 */
    word ADR2        :1;                                       /* Transaction Address Bit 2 */
    word ADR3        :1;                                       /* Transaction Address Bit 3 */
    word ADR4        :1;                                       /* Transaction Address Bit 4 */
    word ADR5        :1;                                       /* Transaction Address Bit 5 */
    word ADR6        :1;                                       /* Transaction Address Bit 6 */
    word ADR7        :1;                                       /* Transaction Address Bit 7 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word NBLK        :1;                                       /* Transaction Mode */
    word             :1; 
    word SZ8         :1;                                       /* Transaction Size */
    word RWB         :1;                                       /* Transaction Read-Write Direction */
  } Bits;
  struct {
    word grpADR  :8;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpSZ_8 :1;
    word         :1;
  } MergedBits;
} D2DADRSTR;
extern volatile D2DADRSTR _D2DADR @(REG_BASE + 0x000000DCUL);
#define D2DADR                          _D2DADR.Word
#define D2DADR_ADR0                     _D2DADR.Bits.ADR0
#define D2DADR_ADR1                     _D2DADR.Bits.ADR1
#define D2DADR_ADR2                     _D2DADR.Bits.ADR2
#define D2DADR_ADR3                     _D2DADR.Bits.ADR3
#define D2DADR_ADR4                     _D2DADR.Bits.ADR4
#define D2DADR_ADR5                     _D2DADR.Bits.ADR5
#define D2DADR_ADR6                     _D2DADR.Bits.ADR6
#define D2DADR_ADR7                     _D2DADR.Bits.ADR7
#define D2DADR_NBLK                     _D2DADR.Bits.NBLK
#define D2DADR_SZ8                      _D2DADR.Bits.SZ8
#define D2DADR_RWB                      _D2DADR.Bits.RWB
#define D2DADR_ADR                      _D2DADR.MergedBits.grpADR

#define D2DADR_ADR0_MASK                1U
#define D2DADR_ADR1_MASK                2U
#define D2DADR_ADR2_MASK                4U
#define D2DADR_ADR3_MASK                8U
#define D2DADR_ADR4_MASK                16U
#define D2DADR_ADR5_MASK                32U
#define D2DADR_ADR6_MASK                64U
#define D2DADR_ADR7_MASK                128U
#define D2DADR_NBLK_MASK                4096U
#define D2DADR_SZ8_MASK                 16384U
#define D2DADR_RWB_MASK                 32768U
#define D2DADR_ADR_MASK                 255U
#define D2DADR_ADR_BITNUM               0U


/*** D2DDATA - D2DI Data Buffer Register; 0x000000DE ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** D2DDATAHI - D2DI Data Buffer Register High; 0x000000DE ***/
    union {
      byte Byte;
      struct {
        byte DATA8       :1;                                       /* Transaction Data Bit 8 */
        byte DATA9       :1;                                       /* Transaction Data Bit 9 */
        byte DATA10      :1;                                       /* Transaction Data Bit 10 */
        byte DATA11      :1;                                       /* Transaction Data Bit 11 */
        byte DATA12      :1;                                       /* Transaction Data Bit 12 */
        byte DATA13      :1;                                       /* Transaction Data Bit 13 */
        byte DATA14      :1;                                       /* Transaction Data Bit 14 */
        byte DATA15      :1;                                       /* Transaction Data Bit 15 */
      } Bits;
    } D2DDATAHISTR;
    #define D2DDATAHI                   _D2DDATA.Overlap_STR.D2DDATAHISTR.Byte
    #define D2DDATAHI_DATA8             _D2DDATA.Overlap_STR.D2DDATAHISTR.Bits.DATA8
    #define D2DDATAHI_DATA9             _D2DDATA.Overlap_STR.D2DDATAHISTR.Bits.DATA9
    #define D2DDATAHI_DATA10            _D2DDATA.Overlap_STR.D2DDATAHISTR.Bits.DATA10
    #define D2DDATAHI_DATA11            _D2DDATA.Overlap_STR.D2DDATAHISTR.Bits.DATA11
    #define D2DDATAHI_DATA12            _D2DDATA.Overlap_STR.D2DDATAHISTR.Bits.DATA12
    #define D2DDATAHI_DATA13            _D2DDATA.Overlap_STR.D2DDATAHISTR.Bits.DATA13
    #define D2DDATAHI_DATA14            _D2DDATA.Overlap_STR.D2DDATAHISTR.Bits.DATA14
    #define D2DDATAHI_DATA15            _D2DDATA.Overlap_STR.D2DDATAHISTR.Bits.DATA15
    
    #define D2DDATAHI_DATA8_MASK        1U
    #define D2DDATAHI_DATA9_MASK        2U
    #define D2DDATAHI_DATA10_MASK       4U
    #define D2DDATAHI_DATA11_MASK       8U
    #define D2DDATAHI_DATA12_MASK       16U
    #define D2DDATAHI_DATA13_MASK       32U
    #define D2DDATAHI_DATA14_MASK       64U
    #define D2DDATAHI_DATA15_MASK       128U
    

    /*** D2DDATALO - D2DI Data Buffer Register Low; 0x000000DF ***/
    union {
      byte Byte;
      struct {
        byte DATA0       :1;                                       /* Transaction Data, bit 0 */
        byte DATA1       :1;                                       /* Transaction Data, bit 1 */
        byte DATA2       :1;                                       /* Transaction Data, bit 2 */
        byte DATA3       :1;                                       /* Transaction Data, bit 3 */
        byte DATA4       :1;                                       /* Transaction Data, bit 4 */
        byte DATA5       :1;                                       /* Transaction Data, bit 5 */
        byte DATA6       :1;                                       /* Transaction Data, bit 6 */
        byte DATA7       :1;                                       /* Transaction Data, bit 7 */
      } Bits;
    } D2DDATALOSTR;
    #define D2DDATALO                   _D2DDATA.Overlap_STR.D2DDATALOSTR.Byte
    #define D2DDATALO_DATA0             _D2DDATA.Overlap_STR.D2DDATALOSTR.Bits.DATA0
    #define D2DDATALO_DATA1             _D2DDATA.Overlap_STR.D2DDATALOSTR.Bits.DATA1
    #define D2DDATALO_DATA2             _D2DDATA.Overlap_STR.D2DDATALOSTR.Bits.DATA2
    #define D2DDATALO_DATA3             _D2DDATA.Overlap_STR.D2DDATALOSTR.Bits.DATA3
    #define D2DDATALO_DATA4             _D2DDATA.Overlap_STR.D2DDATALOSTR.Bits.DATA4
    #define D2DDATALO_DATA5             _D2DDATA.Overlap_STR.D2DDATALOSTR.Bits.DATA5
    #define D2DDATALO_DATA6             _D2DDATA.Overlap_STR.D2DDATALOSTR.Bits.DATA6
    #define D2DDATALO_DATA7             _D2DDATA.Overlap_STR.D2DDATALOSTR.Bits.DATA7
    
    #define D2DDATALO_DATA0_MASK        1U
    #define D2DDATALO_DATA1_MASK        2U
    #define D2DDATALO_DATA2_MASK        4U
    #define D2DDATALO_DATA3_MASK        8U
    #define D2DDATALO_DATA4_MASK        16U
    #define D2DDATALO_DATA5_MASK        32U
    #define D2DDATALO_DATA6_MASK        64U
    #define D2DDATALO_DATA7_MASK        128U
    
  } Overlap_STR;

  struct {
    word DATA0       :1;                                       /* Transaction Data, bit 0 */
    word DATA1       :1;                                       /* Transaction Data, bit 1 */
    word DATA2       :1;                                       /* Transaction Data, bit 2 */
    word DATA3       :1;                                       /* Transaction Data, bit 3 */
    word DATA4       :1;                                       /* Transaction Data, bit 4 */
    word DATA5       :1;                                       /* Transaction Data, bit 5 */
    word DATA6       :1;                                       /* Transaction Data, bit 6 */
    word DATA7       :1;                                       /* Transaction Data, bit 7 */
    word DATA8       :1;                                       /* Transaction Data, bit 8 */
    word DATA9       :1;                                       /* Transaction Data, bit 9 */
    word DATA10      :1;                                       /* Transaction Data, bit 10 */
    word DATA11      :1;                                       /* Transaction Data, bit 11 */
    word DATA12      :1;                                       /* Transaction Data, bit 12 */
    word DATA13      :1;                                       /* Transaction Data, bit 13 */
    word DATA14      :1;                                       /* Transaction Data, bit 14 */
    word DATA15      :1;                                       /* Transaction Data, bit 15 */
  } Bits;
} D2DDATASTR;
extern volatile D2DDATASTR _D2DDATA @(REG_BASE + 0x000000DEUL);
#define D2DDATA                         _D2DDATA.Word
#define D2DDATA_DATA0                   _D2DDATA.Bits.DATA0
#define D2DDATA_DATA1                   _D2DDATA.Bits.DATA1
#define D2DDATA_DATA2                   _D2DDATA.Bits.DATA2
#define D2DDATA_DATA3                   _D2DDATA.Bits.DATA3
#define D2DDATA_DATA4                   _D2DDATA.Bits.DATA4
#define D2DDATA_DATA5                   _D2DDATA.Bits.DATA5
#define D2DDATA_DATA6                   _D2DDATA.Bits.DATA6
#define D2DDATA_DATA7                   _D2DDATA.Bits.DATA7
#define D2DDATA_DATA8                   _D2DDATA.Bits.DATA8
#define D2DDATA_DATA9                   _D2DDATA.Bits.DATA9
#define D2DDATA_DATA10                  _D2DDATA.Bits.DATA10
#define D2DDATA_DATA11                  _D2DDATA.Bits.DATA11
#define D2DDATA_DATA12                  _D2DDATA.Bits.DATA12
#define D2DDATA_DATA13                  _D2DDATA.Bits.DATA13
#define D2DDATA_DATA14                  _D2DDATA.Bits.DATA14
#define D2DDATA_DATA15                  _D2DDATA.Bits.DATA15

#define D2DDATA_DATA0_MASK              1U
#define D2DDATA_DATA1_MASK              2U
#define D2DDATA_DATA2_MASK              4U
#define D2DDATA_DATA3_MASK              8U
#define D2DDATA_DATA4_MASK              16U
#define D2DDATA_DATA5_MASK              32U
#define D2DDATA_DATA6_MASK              64U
#define D2DDATA_DATA7_MASK              128U
#define D2DDATA_DATA8_MASK              256U
#define D2DDATA_DATA9_MASK              512U
#define D2DDATA_DATA10_MASK             1024U
#define D2DDATA_DATA11_MASK             2048U
#define D2DDATA_DATA12_MASK             4096U
#define D2DDATA_DATA13_MASK             8192U
#define D2DDATA_DATA14_MASK             16384U
#define D2DDATA_DATA15_MASK             32768U


/*** SPI0CR1 - SPI Control Register; 0x000000E8 ***/
typedef union {
  byte Byte;
  struct {
    byte LSBFE       :1;                                       /* SPI LSB-First Enable */
    byte SSOE        :1;                                       /* Slave Select Output Enable */
    byte CPHA        :1;                                       /* SPI Clock Phase Bit */
    byte CPOL        :1;                                       /* SPI Clock Polarity Bit */
    byte MSTR        :1;                                       /* SPI Master/Slave Mode Select Bit */
    byte SPTIE       :1;                                       /* SPI Transmit Interrupt Enable */
    byte SPE         :1;                                       /* SPI System Enable Bit */
    byte SPIE        :1;                                       /* SPI Interrupt Enable Bit */
  } Bits;
} SPI0CR1STR;
extern volatile SPI0CR1STR _SPI0CR1 @(REG_BASE + 0x000000E8UL);
#define SPI0CR1                         _SPI0CR1.Byte
#define SPI0CR1_LSBFE                   _SPI0CR1.Bits.LSBFE
#define SPI0CR1_SSOE                    _SPI0CR1.Bits.SSOE
#define SPI0CR1_CPHA                    _SPI0CR1.Bits.CPHA
#define SPI0CR1_CPOL                    _SPI0CR1.Bits.CPOL
#define SPI0CR1_MSTR                    _SPI0CR1.Bits.MSTR
#define SPI0CR1_SPTIE                   _SPI0CR1.Bits.SPTIE
#define SPI0CR1_SPE                     _SPI0CR1.Bits.SPE
#define SPI0CR1_SPIE                    _SPI0CR1.Bits.SPIE

#define SPI0CR1_LSBFE_MASK              1U
#define SPI0CR1_SSOE_MASK               2U
#define SPI0CR1_CPHA_MASK               4U
#define SPI0CR1_CPOL_MASK               8U
#define SPI0CR1_MSTR_MASK               16U
#define SPI0CR1_SPTIE_MASK              32U
#define SPI0CR1_SPE_MASK                64U
#define SPI0CR1_SPIE_MASK               128U


/*** SPI0CR2 - SPI Control Register 2; 0x000000E9 ***/
typedef union {
  byte Byte;
  struct {
    byte SPC0        :1;                                       /* Serial Pin Control Bit 0 */
    byte SPISWAI     :1;                                       /* SPI Stop in Wait Mode Bit */
    byte             :1; 
    byte BIDIROE     :1;                                       /* Output enable in the Bidirectional mode of operation */
    byte MODFEN      :1;                                       /* Mode Fault Enable Bit */
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} SPI0CR2STR;
extern volatile SPI0CR2STR _SPI0CR2 @(REG_BASE + 0x000000E9UL);
#define SPI0CR2                         _SPI0CR2.Byte
#define SPI0CR2_SPC0                    _SPI0CR2.Bits.SPC0
#define SPI0CR2_SPISWAI                 _SPI0CR2.Bits.SPISWAI
#define SPI0CR2_BIDIROE                 _SPI0CR2.Bits.BIDIROE
#define SPI0CR2_MODFEN                  _SPI0CR2.Bits.MODFEN

#define SPI0CR2_SPC0_MASK               1U
#define SPI0CR2_SPISWAI_MASK            2U
#define SPI0CR2_BIDIROE_MASK            8U
#define SPI0CR2_MODFEN_MASK             16U


/*** SPI0BR - SPI Baud Rate Register; 0x000000EA ***/
typedef union {
  byte Byte;
  struct {
    byte SPR0        :1;                                       /* SPI Baud Rate Selection Bit 0 */
    byte SPR1        :1;                                       /* SPI Baud Rate Selection Bit 1 */
    byte SPR2        :1;                                       /* SPI Baud Rate Selection Bit 2 */
    byte             :1; 
    byte SPPR0       :1;                                       /* SPI Baud Rate Preselection Bits 0 */
    byte SPPR1       :1;                                       /* SPI Baud Rate Preselection Bits 1 */
    byte SPPR2       :1;                                       /* SPI Baud Rate Preselection Bits 2 */
    byte             :1; 
  } Bits;
  struct {
    byte grpSPR  :3;
    byte         :1;
    byte grpSPPR :3;
    byte         :1;
  } MergedBits;
} SPI0BRSTR;
extern volatile SPI0BRSTR _SPI0BR @(REG_BASE + 0x000000EAUL);
#define SPI0BR                          _SPI0BR.Byte
#define SPI0BR_SPR0                     _SPI0BR.Bits.SPR0
#define SPI0BR_SPR1                     _SPI0BR.Bits.SPR1
#define SPI0BR_SPR2                     _SPI0BR.Bits.SPR2
#define SPI0BR_SPPR0                    _SPI0BR.Bits.SPPR0
#define SPI0BR_SPPR1                    _SPI0BR.Bits.SPPR1
#define SPI0BR_SPPR2                    _SPI0BR.Bits.SPPR2
#define SPI0BR_SPR                      _SPI0BR.MergedBits.grpSPR
#define SPI0BR_SPPR                     _SPI0BR.MergedBits.grpSPPR

#define SPI0BR_SPR0_MASK                1U
#define SPI0BR_SPR1_MASK                2U
#define SPI0BR_SPR2_MASK                4U
#define SPI0BR_SPPR0_MASK               16U
#define SPI0BR_SPPR1_MASK               32U
#define SPI0BR_SPPR2_MASK               64U
#define SPI0BR_SPR_MASK                 7U
#define SPI0BR_SPR_BITNUM               0U
#define SPI0BR_SPPR_MASK                112U
#define SPI0BR_SPPR_BITNUM              4U


/*** SPI0SR - SPI Status Register; 0x000000EB ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte MODF        :1;                                       /* Mode Fault Flag */
    byte SPTEF       :1;                                       /* SPI Transmit Empty Interrupt Flag */
    byte             :1; 
    byte SPIF        :1;                                       /* SPIF Receive Interrupt Flag */
  } Bits;
} SPI0SRSTR;
extern volatile SPI0SRSTR _SPI0SR @(REG_BASE + 0x000000EBUL);
#define SPI0SR                          _SPI0SR.Byte
#define SPI0SR_MODF                     _SPI0SR.Bits.MODF
#define SPI0SR_SPTEF                    _SPI0SR.Bits.SPTEF
#define SPI0SR_SPIF                     _SPI0SR.Bits.SPIF

#define SPI0SR_MODF_MASK                16U
#define SPI0SR_SPTEF_MASK               32U
#define SPI0SR_SPIF_MASK                128U


/*** SPI0DR - SPI Data Register; 0x000000ED ***/
typedef union {
  byte Byte;
} SPI0DRSTR;
extern volatile SPI0DRSTR _SPI0DR @(REG_BASE + 0x000000EDUL);
#define SPI0DR                          _SPI0DR.Byte


/*** PTIA - Port A Input Register; 0x00000120 ***/
typedef union {
  byte Byte;
  struct {
    byte PTIA0       :1;                                       /* Port A input data bit 0 */
    byte PTIA1       :1;                                       /* Port A input data bit 1 */
    byte PTIA2       :1;                                       /* Port A input data bit 2 */
    byte PTIA3       :1;                                       /* Port A input data bit 3 */
    byte PTIA4       :1;                                       /* Port A input data bit 4 */
    byte PTIA5       :1;                                       /* Port A input data bit 5 */
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpPTIA :6;
    byte         :1;
    byte         :1;
  } MergedBits;
} PTIASTR;
extern volatile PTIASTR _PTIA @(REG_BASE + 0x00000120UL);
#define PTIA                            _PTIA.Byte
#define PTIA_PTIA0                      _PTIA.Bits.PTIA0
#define PTIA_PTIA1                      _PTIA.Bits.PTIA1
#define PTIA_PTIA2                      _PTIA.Bits.PTIA2
#define PTIA_PTIA3                      _PTIA.Bits.PTIA3
#define PTIA_PTIA4                      _PTIA.Bits.PTIA4
#define PTIA_PTIA5                      _PTIA.Bits.PTIA5
#define PTIA_PTIA                       _PTIA.MergedBits.grpPTIA

#define PTIA_PTIA0_MASK                 1U
#define PTIA_PTIA1_MASK                 2U
#define PTIA_PTIA2_MASK                 4U
#define PTIA_PTIA3_MASK                 8U
#define PTIA_PTIA4_MASK                 16U
#define PTIA_PTIA5_MASK                 32U
#define PTIA_PTIA_MASK                  63U
#define PTIA_PTIA_BITNUM                0U


/*** RDRA - Port A Reduced Drive Register; 0x00000122 ***/
typedef union {
  byte Byte;
  struct {
    byte RDRA0       :1;                                       /* Port A reduced drive bit 0 */
    byte RDRA1       :1;                                       /* Port A reduced drive bit 1 */
    byte RDRA2       :1;                                       /* Port A reduced drive bit 2 */
    byte RDRA3       :1;                                       /* Port A reduced drive bit 3 */
    byte RDRA4       :1;                                       /* Port A reduced drive bit 4 */
    byte RDRA5       :1;                                       /* Port A reduced drive bit 5 */
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpRDRA :6;
    byte         :1;
    byte         :1;
  } MergedBits;
} RDRASTR;
extern volatile RDRASTR _RDRA @(REG_BASE + 0x00000122UL);
#define RDRA                            _RDRA.Byte
#define RDRA_RDRA0                      _RDRA.Bits.RDRA0
#define RDRA_RDRA1                      _RDRA.Bits.RDRA1
#define RDRA_RDRA2                      _RDRA.Bits.RDRA2
#define RDRA_RDRA3                      _RDRA.Bits.RDRA3
#define RDRA_RDRA4                      _RDRA.Bits.RDRA4
#define RDRA_RDRA5                      _RDRA.Bits.RDRA5
#define RDRA_RDRA                       _RDRA.MergedBits.grpRDRA

#define RDRA_RDRA0_MASK                 1U
#define RDRA_RDRA1_MASK                 2U
#define RDRA_RDRA2_MASK                 4U
#define RDRA_RDRA3_MASK                 8U
#define RDRA_RDRA4_MASK                 16U
#define RDRA_RDRA5_MASK                 32U
#define RDRA_RDRA_MASK                  63U
#define RDRA_RDRA_BITNUM                0U


  /* Watchdog reset macro */
#ifndef __RESET_WATCHDOG
#ifdef _lint
  #define __RESET_WATCHDOG()  /* empty */
#else
  #define __RESET_WATCHDOG() (void)(ARMCOP = 0x55U, ARMCOP = 0xAAU)
#endif
#endif /* __RESET_WATCHDOG */


/***********************************************/
/**   D E P R E C I A T E D   S Y M B O L S   **/
/***********************************************/

#ifndef __V30COMPATIBLE__
#pragma OPTION DEL V30toV31Compatible
#endif
/*lint -restore  +esym(961,18.4) +esym(961,19.7) Enable MISRA rule (1.1,18.4,6.4,19.7) checking. */

#endif
