; Based on CPU DB MC9S12I128_48, version 3.00.000 (RegistersPrg V2.31)

; ###################################################################
;     Filename  : mc9s12i128.inc
;     Processor : MC9S12I128
;     FileFormat: V2.31
;     DataSheet : MC9S12I128RMV1 Rev. 0.9 October 13, 2009
;     Compiler  : CodeWarrior compiler
;     Date/Time : 15.10.2009, 13:35
;     Abstract  :
;         This header implements the mapping of I/O devices.
;
;     Copyright : 1997 - 2009 Freescale Semiconductor, Inc. All Rights Reserved.
;     
;     http      : www.freescale.com
;     mail      : support@freescale.com
;
;     CPU Registers Revisions:
;               - none
;
;     File-Format-Revisions:
;               - none
;
;     Not all general-purpose I/O pins are available on all packages or on all mask sets of a specific
;     derivative device. To avoid extra current drain from floating input pins, the users reset
;     initialization routine in the application program must either enable on-chip pull-up devices
;     or change the direction of unconnected pins to outputs so the pins do not float.
; ###################################################################

;*** Memory Map and Interrupt Vectors
;******************************************
RAMStart:           equ   $00002800
RAMEnd:             equ   $00003FFF
DFLASHStart:        equ   $00000400
DFLASHEnd:          equ   $000013FF
ROM_1400Start:      equ   $00001400
ROM_1400End:        equ   $000027FF
ROM_4000Start:      equ   $00004000
ROM_4000End:        equ   $00007FFF
ROM_C000Start:      equ   $0000C000
ROM_C000End:        equ   $0000FEFF
PAGE_08Start:       equ   $00020000
PAGE_08End:         equ   $00023FFF
PAGE_09Start:       equ   $00024000
PAGE_09End:         equ   $00027FFF
PAGE_0AStart:       equ   $00028000
PAGE_0AEnd:         equ   $0002BFFF
PAGE_0BStart:       equ   $0002C000
PAGE_0BEnd:         equ   $0002FFFF
PAGE_0CStart:       equ   $00030000
PAGE_0CEnd:         equ   $000313FF
PAGE_0C_A800Start:  equ   $00032800
PAGE_0C_A800End:    equ   $00033FFF
PAGE_0EStart:       equ   $00038000
PAGE_0EEnd:         equ   $0003BFFF
;
Vsi:                equ   $0000FF80
VReserved62:        equ   $0000FF82
VReserved61:        equ   $0000FF84
VReserved60:        equ   $0000FF86
VReserved59:        equ   $0000FF88
Vlvi:               equ   $0000FF8A
VReserved57:        equ   $0000FF8C
VReserved56:        equ   $0000FF8E
VReserved55:        equ   $0000FF90
VReserved54:        equ   $0000FF92
VReserved53:        equ   $0000FF94
VReserved52:        equ   $0000FF96
VReserved51:        equ   $0000FF98
VReserved50:        equ   $0000FF9A
VReserved49:        equ   $0000FF9C
VReserved48:        equ   $0000FF9E
VReserved47:        equ   $0000FFA0
VReserved46:        equ   $0000FFA2
VReserved45:        equ   $0000FFA4
VReserved44:        equ   $0000FFA6
VReserved43:        equ   $0000FFA8
VReserved42:        equ   $0000FFAA
VReserved41:        equ   $0000FFAC
VReserved40:        equ   $0000FFAE
VReserved39:        equ   $0000FFB0
VReserved38:        equ   $0000FFB2
VReserved37:        equ   $0000FFB4
VReserved36:        equ   $0000FFB6
Vflash:             equ   $0000FFB8
Vflashfd:           equ   $0000FFBA
VReserved33:        equ   $0000FFBC
VReserved32:        equ   $0000FFBE
VReserved31:        equ   $0000FFC0
VReserved30:        equ   $0000FFC2
VReserved29:        equ   $0000FFC4
Vcpmuplllck:        equ   $0000FFC6
Vcpmuocsns:         equ   $0000FFC8
VReserved26:        equ   $0000FFCA
VReserved25:        equ   $0000FFCC
VReserved24:        equ   $0000FFCE
VReserved23:        equ   $0000FFD0
VReserved22:        equ   $0000FFD2
VReserved21:        equ   $0000FFD4
VReserved20:        equ   $0000FFD6
Vspi:               equ   $0000FFD8
VReserved18:        equ   $0000FFDA
VReserved17:        equ   $0000FFDC
VReserved16:        equ   $0000FFDE
VReserved15:        equ   $0000FFE0
VReserved14:        equ   $0000FFE2
VReserved13:        equ   $0000FFE4
VReserved12:        equ   $0000FFE6
VReserved11:        equ   $0000FFE8
VReserved10:        equ   $0000FFEA
VReserved9:         equ   $0000FFEC
VReserved8:         equ   $0000FFEE
Vrti:               equ   $0000FFF0
Vd2di_ext:          equ   $0000FFF2
Vd2di_err:          equ   $0000FFF4
Vswi:               equ   $0000FFF6
Vtrap:              equ   $0000FFF8
Vcop:               equ   $0000FFFA
Vclkmon:            equ   $0000FFFC
Vreset:             equ   $0000FFFE
;


;*** PORTA - Port A Data Register; 0x00000000 ***
PORTA:              equ    $00000000                                ;*** PORTA - Port A Data Register; 0x00000000 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PORTA_PA0:          equ    0                                         ; Port A Bit 0
PORTA_PA1:          equ    1                                         ; Port A Bit 1
PORTA_PA2:          equ    2                                         ; Port A Bit 2
PORTA_PA3:          equ    3                                         ; Port A Bit 3
PORTA_PA4:          equ    4                                         ; Port A Bit 4
PORTA_PA5:          equ    5                                         ; Port A Bit 5
PORTA_PA6:          equ    6                                         ; Port A Bit 6
PORTA_PA7:          equ    7                                         ; Port A Bit 7
; bit position masks
mPORTA_PA0:         equ    %00000001
mPORTA_PA1:         equ    %00000010
mPORTA_PA2:         equ    %00000100
mPORTA_PA3:         equ    %00001000
mPORTA_PA4:         equ    %00010000
mPORTA_PA5:         equ    %00100000
mPORTA_PA6:         equ    %01000000
mPORTA_PA7:         equ    %10000000


;*** PORTB - Port A Data Register; 0x00000001 ***
PORTB:              equ    $00000001                                ;*** PORTB - Port A Data Register; 0x00000001 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PORTB_PB0:          equ    0                                         ; Port B Bit 0
PORTB_PB1:          equ    1                                         ; Port B Bit 1
; bit position masks
mPORTB_PB0:         equ    %00000001
mPORTB_PB1:         equ    %00000010


;*** DDRA - Port A Data Direction Register; 0x00000002 ***
DDRA:               equ    $00000002                                ;*** DDRA - Port A Data Direction Register; 0x00000002 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRA_DDRA0:         equ    0                                         ; Data Direction Port A Bit 0
DDRA_DDRA1:         equ    1                                         ; Data Direction Port A Bit 1
DDRA_DDRA2:         equ    2                                         ; Data Direction Port A Bit 2
DDRA_DDRA3:         equ    3                                         ; Data Direction Port A Bit 3
DDRA_DDRA4:         equ    4                                         ; Data Direction Port A Bit 4
DDRA_DDRA5:         equ    5                                         ; Data Direction Port A Bit 5
DDRA_DDRA6:         equ    6                                         ; Data Direction Port A Bit 6
DDRA_DDRA7:         equ    7                                         ; Data Direction Port A Bit 7
; bit position masks
mDDRA_DDRA0:        equ    %00000001
mDDRA_DDRA1:        equ    %00000010
mDDRA_DDRA2:        equ    %00000100
mDDRA_DDRA3:        equ    %00001000
mDDRA_DDRA4:        equ    %00010000
mDDRA_DDRA5:        equ    %00100000
mDDRA_DDRA6:        equ    %01000000
mDDRA_DDRA7:        equ    %10000000


;*** DDRB - Port B Data Direction Register; 0x00000003 ***
DDRB:               equ    $00000003                                ;*** DDRB - Port B Data Direction Register; 0x00000003 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRB_DDRB0:         equ    0                                         ; Data Direction Port B Bit 0
DDRB_DDRB1:         equ    1                                         ; Data Direction Port B Bit 1
; bit position masks
mDDRB_DDRB0:        equ    %00000001
mDDRB_DDRB1:        equ    %00000010


;*** MODE - Mode Register; 0x0000000B ***
MODE:               equ    $0000000B                                ;*** MODE - Mode Register; 0x0000000B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MODE_MODC:          equ    7                                         ; Mode Select Bit
; bit position masks
mMODE_MODC:         equ    %10000000


;*** PUCR - Pull-Up Control Register; 0x0000000C ***
PUCR:               equ    $0000000C                                ;*** PUCR - Pull-Up Control Register; 0x0000000C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PUCR_PDPBE:         equ    1                                         ; Pull-down Port B Enable
PUCR_BKPUE:         equ    6                                         ; BKGD and VREGEN Pin Pull-up Enable
; bit position masks
mPUCR_PDPBE:        equ    %00000010
mPUCR_BKPUE:        equ    %01000000


;*** RDRIV - Reduced Drive Register; 0x0000000D ***
RDRIV:              equ    $0000000D                                ;*** RDRIV - Reduced Drive Register; 0x0000000D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RDRIV_RDPC:         equ    2                                         ; Reduced Drive of Port C
RDRIV_RDPD:         equ    3                                         ; Reduced Drive of Port D
; bit position masks
mRDRIV_RDPC:        equ    %00000100
mRDRIV_RDPD:        equ    %00001000


;*** DIRECT - Direct Page Register; 0x00000011 ***
DIRECT:             equ    $00000011                                ;*** DIRECT - Direct Page Register; 0x00000011 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DIRECT_DP8:         equ    0                                         ; Direct Page Index Bit 8
DIRECT_DP9:         equ    1                                         ; Direct Page Index Bit 9
DIRECT_DP10:        equ    2                                         ; Direct Page Index Bit 10
DIRECT_DP11:        equ    3                                         ; Direct Page Index Bit 11
DIRECT_DP12:        equ    4                                         ; Direct Page Index Bit 12
DIRECT_DP13:        equ    5                                         ; Direct Page Index Bit 13
DIRECT_DP14:        equ    6                                         ; Direct Page Index Bit 14
DIRECT_DP15:        equ    7                                         ; Direct Page Index Bit 15
; bit position masks
mDIRECT_DP8:        equ    %00000001
mDIRECT_DP9:        equ    %00000010
mDIRECT_DP10:       equ    %00000100
mDIRECT_DP11:       equ    %00001000
mDIRECT_DP12:       equ    %00010000
mDIRECT_DP13:       equ    %00100000
mDIRECT_DP14:       equ    %01000000
mDIRECT_DP15:       equ    %10000000


;*** MMCCTL1 - MMC Control Register; 0x00000013 ***
MMCCTL1:            equ    $00000013                                ;*** MMCCTL1 - MMC Control Register; 0x00000013 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MMCCTL1_IFRON:      equ    0                                         ; IFR visible in the memory map
; bit position masks
mMMCCTL1_IFRON:     equ    %00000001


;*** PPAGE - Program Page Index Register; 0x00000015 ***
PPAGE:              equ    $00000015                                ;*** PPAGE - Program Page Index Register; 0x00000015 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PPAGE_PIX0:         equ    0                                         ; Program Page Index Bit 0
PPAGE_PIX1:         equ    1                                         ; Program Page Index Bit 1
PPAGE_PIX2:         equ    2                                         ; Program Page Index Bit 2
PPAGE_PIX3:         equ    3                                         ; Program Page Index Bit 3
; bit position masks
mPPAGE_PIX0:        equ    %00000001
mPPAGE_PIX1:        equ    %00000010
mPPAGE_PIX2:        equ    %00000100
mPPAGE_PIX3:        equ    %00001000


;*** PARTID - Part ID Register; 0x0000001A ***
PARTID:             equ    $0000001A                                ;*** PARTID - Part ID Register; 0x0000001A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PARTID_ID0:         equ    0                                         ; Part ID Register Bit 0
PARTID_ID1:         equ    1                                         ; Part ID Register Bit 1
PARTID_ID2:         equ    2                                         ; Part ID Register Bit 2
PARTID_ID3:         equ    3                                         ; Part ID Register Bit 3
PARTID_ID4:         equ    4                                         ; Part ID Register Bit 4
PARTID_ID5:         equ    5                                         ; Part ID Register Bit 5
PARTID_ID6:         equ    6                                         ; Part ID Register Bit 6
PARTID_ID7:         equ    7                                         ; Part ID Register Bit 7
PARTID_ID8:         equ    8                                         ; Part ID Register Bit 8
PARTID_ID9:         equ    9                                         ; Part ID Register Bit 9
PARTID_ID10:        equ    10                                        ; Part ID Register Bit 10
PARTID_ID11:        equ    11                                        ; Part ID Register Bit 11
PARTID_ID12:        equ    12                                        ; Part ID Register Bit 12
PARTID_ID13:        equ    13                                        ; Part ID Register Bit 13
PARTID_ID14:        equ    14                                        ; Part ID Register Bit 14
PARTID_ID15:        equ    15                                        ; Part ID Register Bit 15
; bit position masks
mPARTID_ID0:        equ    %00000001
mPARTID_ID1:        equ    %00000010
mPARTID_ID2:        equ    %00000100
mPARTID_ID3:        equ    %00001000
mPARTID_ID4:        equ    %00010000
mPARTID_ID5:        equ    %00100000
mPARTID_ID6:        equ    %01000000
mPARTID_ID7:        equ    %10000000
mPARTID_ID8:        equ    %100000000
mPARTID_ID9:        equ    %1000000000
mPARTID_ID10:       equ    %10000000000
mPARTID_ID11:       equ    %100000000000
mPARTID_ID12:       equ    %1000000000000
mPARTID_ID13:       equ    %10000000000000
mPARTID_ID14:       equ    %100000000000000
mPARTID_ID15:       equ    %1000000000000000


;*** PARTIDH - Part ID Register High; 0x0000001A ***
PARTIDH:            equ    $0000001A                                ;*** PARTIDH - Part ID Register High; 0x0000001A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PARTIDH_ID8:        equ    0                                         ; Part ID Register Bit 8
PARTIDH_ID9:        equ    1                                         ; Part ID Register Bit 9
PARTIDH_ID10:       equ    2                                         ; Part ID Register Bit 10
PARTIDH_ID11:       equ    3                                         ; Part ID Register Bit 11
PARTIDH_ID12:       equ    4                                         ; Part ID Register Bit 12
PARTIDH_ID13:       equ    5                                         ; Part ID Register Bit 13
PARTIDH_ID14:       equ    6                                         ; Part ID Register Bit 14
PARTIDH_ID15:       equ    7                                         ; Part ID Register Bit 15
; bit position masks
mPARTIDH_ID8:       equ    %00000001
mPARTIDH_ID9:       equ    %00000010
mPARTIDH_ID10:      equ    %00000100
mPARTIDH_ID11:      equ    %00001000
mPARTIDH_ID12:      equ    %00010000
mPARTIDH_ID13:      equ    %00100000
mPARTIDH_ID14:      equ    %01000000
mPARTIDH_ID15:      equ    %10000000


;*** PARTIDL - Part ID Register Low; 0x0000001B ***
PARTIDL:            equ    $0000001B                                ;*** PARTIDL - Part ID Register Low; 0x0000001B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PARTIDL_ID0:        equ    0                                         ; Part ID Register Bit 0
PARTIDL_ID1:        equ    1                                         ; Part ID Register Bit 1
PARTIDL_ID2:        equ    2                                         ; Part ID Register Bit 2
PARTIDL_ID3:        equ    3                                         ; Part ID Register Bit 3
PARTIDL_ID4:        equ    4                                         ; Part ID Register Bit 4
PARTIDL_ID5:        equ    5                                         ; Part ID Register Bit 5
PARTIDL_ID6:        equ    6                                         ; Part ID Register Bit 6
PARTIDL_ID7:        equ    7                                         ; Part ID Register Bit 7
; bit position masks
mPARTIDL_ID0:       equ    %00000001
mPARTIDL_ID1:       equ    %00000010
mPARTIDL_ID2:       equ    %00000100
mPARTIDL_ID3:       equ    %00001000
mPARTIDL_ID4:       equ    %00010000
mPARTIDL_ID5:       equ    %00100000
mPARTIDL_ID6:       equ    %01000000
mPARTIDL_ID7:       equ    %10000000


;*** IVBR - Interrupt Vector Base Register; 0x0000001F ***
IVBR:               equ    $0000001F                                ;*** IVBR - Interrupt Vector Base Register; 0x0000001F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
IVBR_IVB_ADDR0:     equ    0                                         ; Interrupt Vector Base Address Bits, bit 0
IVBR_IVB_ADDR1:     equ    1                                         ; Interrupt Vector Base Address Bits, bit 1
IVBR_IVB_ADDR2:     equ    2                                         ; Interrupt Vector Base Address Bits, bit 2
IVBR_IVB_ADDR3:     equ    3                                         ; Interrupt Vector Base Address Bits, bit 3
IVBR_IVB_ADDR4:     equ    4                                         ; Interrupt Vector Base Address Bits, bit 4
IVBR_IVB_ADDR5:     equ    5                                         ; Interrupt Vector Base Address Bits, bit 5
IVBR_IVB_ADDR6:     equ    6                                         ; Interrupt Vector Base Address Bits, bit 6
IVBR_IVB_ADDR7:     equ    7                                         ; Interrupt Vector Base Address Bits, bit 7
; bit position masks
mIVBR_IVB_ADDR0:    equ    %00000001
mIVBR_IVB_ADDR1:    equ    %00000010
mIVBR_IVB_ADDR2:    equ    %00000100
mIVBR_IVB_ADDR3:    equ    %00001000
mIVBR_IVB_ADDR4:    equ    %00010000
mIVBR_IVB_ADDR5:    equ    %00100000
mIVBR_IVB_ADDR6:    equ    %01000000
mIVBR_IVB_ADDR7:    equ    %10000000


;*** DBGC1 - Debug Control Register 1; 0x00000020 ***
DBGC1:              equ    $00000020                                ;*** DBGC1 - Debug Control Register 1; 0x00000020 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGC1_COMRV0:       equ    0                                         ; Comparator Register Visibility Bits, bit 0
DBGC1_COMRV1:       equ    1                                         ; Comparator Register Visibility Bits, bit 1
DBGC1_DBGBRK:       equ    3                                         ; S12XDBG Breakpoint Enable Bit 1
DBGC1_BDM:          equ    4                                         ; Background Debug Mode Enable
DBGC1_TRIG:         equ    6                                         ; Immediate Trigger Request Bit
DBGC1_ARM:          equ    7                                         ; Arm Bit
; bit position masks
mDBGC1_COMRV0:      equ    %00000001
mDBGC1_COMRV1:      equ    %00000010
mDBGC1_DBGBRK:      equ    %00001000
mDBGC1_BDM:         equ    %00010000
mDBGC1_TRIG:        equ    %01000000
mDBGC1_ARM:         equ    %10000000


;*** DBGSR - Debug Status Register; 0x00000021 ***
DBGSR:              equ    $00000021                                ;*** DBGSR - Debug Status Register; 0x00000021 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGSR_SSF0:         equ    0                                         ; State Sequencer Flag Bits
DBGSR_SSF1:         equ    1                                         ; State Sequencer Flag Bit 1
DBGSR_SSF2:         equ    2                                         ; State Sequencer Flag Bit 2
DBGSR_TBF:          equ    7                                         ; Trace Buffer Full
; bit position masks
mDBGSR_SSF0:        equ    %00000001
mDBGSR_SSF1:        equ    %00000010
mDBGSR_SSF2:        equ    %00000100
mDBGSR_TBF:         equ    %10000000


;*** DBGTCR - Debug Trace Control Register; 0x00000022 ***
DBGTCR:             equ    $00000022                                ;*** DBGTCR - Debug Trace Control Register; 0x00000022 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGTCR_TALIGN:      equ    0                                         ; Trigger Align Bit
DBGTCR_TRCMOD0:     equ    2                                         ; Trace Mode Bits, bit 0
DBGTCR_TRCMOD1:     equ    3                                         ; Trace Mode Bits, bit 1
DBGTCR_TSOURCE:     equ    6                                         ; Trace Source Control Bits
; bit position masks
mDBGTCR_TALIGN:     equ    %00000001
mDBGTCR_TRCMOD0:    equ    %00000100
mDBGTCR_TRCMOD1:    equ    %00001000
mDBGTCR_TSOURCE:    equ    %01000000


;*** DBGC2 - Debug Control Register 2; 0x00000023 ***
DBGC2:              equ    $00000023                                ;*** DBGC2 - Debug Control Register 2; 0x00000023 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGC2_ABCM0:        equ    0                                         ; A and B Comparator Match Control, bit 0
DBGC2_ABCM1:        equ    1                                         ; A and B Comparator Match Control, bit 1
; bit position masks
mDBGC2_ABCM0:       equ    %00000001
mDBGC2_ABCM1:       equ    %00000010


;*** DBGTB - Debug Trace Buffer Register; 0x00000024 ***
DBGTB:              equ    $00000024                                ;*** DBGTB - Debug Trace Buffer Register; 0x00000024 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGTB_BIT0:         equ    0                                         ; Trace Buffer Data Bits
DBGTB_BIT1:         equ    1                                         ; Trace Buffer Data Bit 1
DBGTB_BIT2:         equ    2                                         ; Trace Buffer Data Bit 2
DBGTB_BIT3:         equ    3                                         ; Trace Buffer Data Bit 3
DBGTB_BIT4:         equ    4                                         ; Trace Buffer Data Bit 4
DBGTB_BIT5:         equ    5                                         ; Trace Buffer Data Bit 5
DBGTB_BIT6:         equ    6                                         ; Trace Buffer Data Bit 6
DBGTB_BIT7:         equ    7                                         ; Trace Buffer Data Bit 7
DBGTB_BIT8:         equ    8                                         ; Trace Buffer Data Bit 8
DBGTB_BIT9:         equ    9                                         ; Trace Buffer Data Bit 9
DBGTB_BIT10:        equ    10                                        ; Trace Buffer Data Bit 10
DBGTB_BIT11:        equ    11                                        ; Trace Buffer Data Bit 11
DBGTB_BIT12:        equ    12                                        ; Trace Buffer Data Bit 12
DBGTB_BIT13:        equ    13                                        ; Trace Buffer Data Bit 13
DBGTB_BIT14:        equ    14                                        ; Trace Buffer Data Bit 14
DBGTB_BIT15:        equ    15                                        ; Trace Buffer Data Bit 15
; bit position masks
mDBGTB_BIT0:        equ    %00000001
mDBGTB_BIT1:        equ    %00000010
mDBGTB_BIT2:        equ    %00000100
mDBGTB_BIT3:        equ    %00001000
mDBGTB_BIT4:        equ    %00010000
mDBGTB_BIT5:        equ    %00100000
mDBGTB_BIT6:        equ    %01000000
mDBGTB_BIT7:        equ    %10000000
mDBGTB_BIT8:        equ    %100000000
mDBGTB_BIT9:        equ    %1000000000
mDBGTB_BIT10:       equ    %10000000000
mDBGTB_BIT11:       equ    %100000000000
mDBGTB_BIT12:       equ    %1000000000000
mDBGTB_BIT13:       equ    %10000000000000
mDBGTB_BIT14:       equ    %100000000000000
mDBGTB_BIT15:       equ    %1000000000000000


;*** DBGTBH - Debug Trace Buffer Register High; 0x00000024 ***
DBGTBH:             equ    $00000024                                ;*** DBGTBH - Debug Trace Buffer Register High; 0x00000024 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGTBH_BIT8:        equ    0                                         ; Trace Buffer Data Bits
DBGTBH_BIT9:        equ    1                                         ; Trace Buffer Data Bit 9
DBGTBH_BIT10:       equ    2                                         ; Trace Buffer Data Bit 10
DBGTBH_BIT11:       equ    3                                         ; Trace Buffer Data Bit 11
DBGTBH_BIT12:       equ    4                                         ; Trace Buffer Data Bit 12
DBGTBH_BIT13:       equ    5                                         ; Trace Buffer Data Bit 13
DBGTBH_BIT14:       equ    6                                         ; Trace Buffer Data Bit 14
DBGTBH_BIT15:       equ    7                                         ; Trace Buffer Data Bit 15
; bit position masks
mDBGTBH_BIT8:       equ    %00000001
mDBGTBH_BIT9:       equ    %00000010
mDBGTBH_BIT10:      equ    %00000100
mDBGTBH_BIT11:      equ    %00001000
mDBGTBH_BIT12:      equ    %00010000
mDBGTBH_BIT13:      equ    %00100000
mDBGTBH_BIT14:      equ    %01000000
mDBGTBH_BIT15:      equ    %10000000


;*** DBGTBL - Debug Trace Buffer Register Low; 0x00000025 ***
DBGTBL:             equ    $00000025                                ;*** DBGTBL - Debug Trace Buffer Register Low; 0x00000025 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGTBL_BIT0:        equ    0                                         ; Trace Buffer Data Bits
DBGTBL_BIT1:        equ    1                                         ; Trace Buffer Data Bit 1
DBGTBL_BIT2:        equ    2                                         ; Trace Buffer Data Bit 2
DBGTBL_BIT3:        equ    3                                         ; Trace Buffer Data Bit 3
DBGTBL_BIT4:        equ    4                                         ; Trace Buffer Data Bit 4
DBGTBL_BIT5:        equ    5                                         ; Trace Buffer Data Bit 5
DBGTBL_BIT6:        equ    6                                         ; Trace Buffer Data Bit 6
DBGTBL_BIT7:        equ    7                                         ; Trace Buffer Data Bit 7
; bit position masks
mDBGTBL_BIT0:       equ    %00000001
mDBGTBL_BIT1:       equ    %00000010
mDBGTBL_BIT2:       equ    %00000100
mDBGTBL_BIT3:       equ    %00001000
mDBGTBL_BIT4:       equ    %00010000
mDBGTBL_BIT5:       equ    %00100000
mDBGTBL_BIT6:       equ    %01000000
mDBGTBL_BIT7:       equ    %10000000


;*** DBGCNT - Debug Count Register; 0x00000026 ***
DBGCNT:             equ    $00000026                                ;*** DBGCNT - Debug Count Register; 0x00000026 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGCNT_CNT0:        equ    0                                         ; Count Value, bit 0
DBGCNT_CNT1:        equ    1                                         ; Count Value, bit 1
DBGCNT_CNT2:        equ    2                                         ; Count Value, bit 2
DBGCNT_CNT3:        equ    3                                         ; Count Value, bit 3
DBGCNT_CNT4:        equ    4                                         ; Count Value, bit 4
DBGCNT_CNT5:        equ    5                                         ; Count Value, bit 5
DBGCNT_TBF:         equ    7                                         ; Trace Buffer Full
; bit position masks
mDBGCNT_CNT0:       equ    %00000001
mDBGCNT_CNT1:       equ    %00000010
mDBGCNT_CNT2:       equ    %00000100
mDBGCNT_CNT3:       equ    %00001000
mDBGCNT_CNT4:       equ    %00010000
mDBGCNT_CNT5:       equ    %00100000
mDBGCNT_TBF:        equ    %10000000


;*** DBGSCRX - Debug State Control Register; 0x00000027 ***
DBGSCRX:            equ    $00000027                                ;*** DBGSCRX - Debug State Control Register; 0x00000027 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGSCRX_SC0:        equ    0                                         ; State X Sequencer Next State Selection Bit 0
DBGSCRX_SC1:        equ    1                                         ; State X Sequencer Next State Selection Bit 1
DBGSCRX_SC2:        equ    2                                         ; State X Sequencer Next State Selection Bit 2
DBGSCRX_SC3:        equ    3                                         ; State X Sequencer Next State Selection Bit 3
; bit position masks
mDBGSCRX_SC0:       equ    %00000001
mDBGSCRX_SC1:       equ    %00000010
mDBGSCRX_SC2:       equ    %00000100
mDBGSCRX_SC3:       equ    %00001000


;*** DBGMFR - Debug Match Flag Register; 0x00000027 ***
DBGMFR:             equ    $00000027                                ;*** DBGMFR - Debug Match Flag Register; 0x00000027 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGMFR_MC0:         equ    0                                         ; Debug Match Flag Bit 0
DBGMFR_MC1:         equ    1                                         ; Debug Match Flag Bit 1
DBGMFR_MC2:         equ    2                                         ; Debug Match Flag Bit 2
; bit position masks
mDBGMFR_MC0:        equ    %00000001
mDBGMFR_MC1:        equ    %00000010
mDBGMFR_MC2:        equ    %00000100


;*** DBGXCTL - Debug Comparator Control Register; 0x00000028 ***
DBGXCTL:            equ    $00000028                                ;*** DBGXCTL - Debug Comparator Control Register; 0x00000028 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGXCTL_COMPE:      equ    0                                         ; Determines if comparator is enabled
DBGXCTL_NDB:        equ    1                                         ; Not Data Bus(Comparators A and C), Size Comparator Value Bit(Comparators B and D)
DBGXCTL_RWE:        equ    2                                         ; Read/Write Enable Bit
DBGXCTL_RW:         equ    3                                         ; Read/Write Comparator Value Bit
DBGXCTL_BRK:        equ    4                                         ; Break
DBGXCTL_TAG:        equ    5                                         ; Tag Select
DBGXCTL_SZ:         equ    6                                         ; Size Comparator Value Bit
DBGXCTL_SZE:        equ    7                                         ; Size Comparator Enable Bit
; bit position masks
mDBGXCTL_COMPE:     equ    %00000001
mDBGXCTL_NDB:       equ    %00000010
mDBGXCTL_RWE:       equ    %00000100
mDBGXCTL_RW:        equ    %00001000
mDBGXCTL_BRK:       equ    %00010000
mDBGXCTL_TAG:       equ    %00100000
mDBGXCTL_SZ:        equ    %01000000
mDBGXCTL_SZE:       equ    %10000000


;*** DBGXAH - Debug Comparator Address High Register; 0x00000029 ***
DBGXAH:             equ    $00000029                                ;*** DBGXAH - Debug Comparator Address High Register; 0x00000029 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGXAH_BIT16:       equ    0                                         ; Comparator Address High Compare Bits
DBGXAH_BIT17:       equ    1                                         ; Comparator Address High Compare Bit 17
; bit position masks
mDBGXAH_BIT16:      equ    %00000001
mDBGXAH_BIT17:      equ    %00000010


;*** DBGXAM - Debug Comparator Address Mid Register; 0x0000002A ***
DBGXAM:             equ    $0000002A                                ;*** DBGXAM - Debug Comparator Address Mid Register; 0x0000002A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGXAM_BIT8:        equ    0                                         ; Comparator Address Mid Compare Bits
DBGXAM_BIT9:        equ    1                                         ; Comparator Address Mid Compare Bit 9
DBGXAM_BIT10:       equ    2                                         ; Comparator Address Mid Compare Bit 10
DBGXAM_BIT11:       equ    3                                         ; Comparator Address Mid Compare Bit 11
DBGXAM_BIT12:       equ    4                                         ; Comparator Address Mid Compare Bit 12
DBGXAM_BIT13:       equ    5                                         ; Comparator Address Mid Compare Bit 13
DBGXAM_BIT14:       equ    6                                         ; Comparator Address Mid Compare Bit 14
DBGXAM_BIT15:       equ    7                                         ; Comparator Address Mid Compare Bit 15
; bit position masks
mDBGXAM_BIT8:       equ    %00000001
mDBGXAM_BIT9:       equ    %00000010
mDBGXAM_BIT10:      equ    %00000100
mDBGXAM_BIT11:      equ    %00001000
mDBGXAM_BIT12:      equ    %00010000
mDBGXAM_BIT13:      equ    %00100000
mDBGXAM_BIT14:      equ    %01000000
mDBGXAM_BIT15:      equ    %10000000


;*** DBGXAL - Debug Comparator Address Low Register; 0x0000002B ***
DBGXAL:             equ    $0000002B                                ;*** DBGXAL - Debug Comparator Address Low Register; 0x0000002B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGXAL_BIT0:        equ    0                                         ; Comparator Address Low Compare Bits
DBGXAL_BIT1:        equ    1                                         ; Comparator Address Low Compare Bit 1
DBGXAL_BIT2:        equ    2                                         ; Comparator Address Low Compare Bit 2
DBGXAL_BIT3:        equ    3                                         ; Comparator Address Low Compare Bit 3
DBGXAL_BIT4:        equ    4                                         ; Comparator Address Low Compare Bit 4
DBGXAL_BIT5:        equ    5                                         ; Comparator Address Low Compare Bit 5
DBGXAL_BIT6:        equ    6                                         ; Comparator Address Low Compare Bit 6
DBGXAL_BIT7:        equ    7                                         ; Comparator Address Low Compare Bit 7
; bit position masks
mDBGXAL_BIT0:       equ    %00000001
mDBGXAL_BIT1:       equ    %00000010
mDBGXAL_BIT2:       equ    %00000100
mDBGXAL_BIT3:       equ    %00001000
mDBGXAL_BIT4:       equ    %00010000
mDBGXAL_BIT5:       equ    %00100000
mDBGXAL_BIT6:       equ    %01000000
mDBGXAL_BIT7:       equ    %10000000


;*** DBGADH - Debug Comparator Data High Register; 0x0000002C ***
DBGADH:             equ    $0000002C                                ;*** DBGADH - Debug Comparator Data High Register; 0x0000002C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGADH_BIT8:        equ    0                                         ; Comparator Data High Compare Bit 8
DBGADH_BIT9:        equ    1                                         ; Comparator Data High Compare Bit 9
DBGADH_BIT10:       equ    2                                         ; Comparator Data High Compare Bit 10
DBGADH_BIT11:       equ    3                                         ; Comparator Data High Compare Bit 11
DBGADH_BIT12:       equ    4                                         ; Comparator Data High Compare Bit 12
DBGADH_BIT13:       equ    5                                         ; Comparator Data High Compare Bit 13
DBGADH_BIT14:       equ    6                                         ; Comparator Data High Compare Bit 14
DBGADH_BIT15:       equ    7                                         ; Comparator Data High Compare Bit 15
; bit position masks
mDBGADH_BIT8:       equ    %00000001
mDBGADH_BIT9:       equ    %00000010
mDBGADH_BIT10:      equ    %00000100
mDBGADH_BIT11:      equ    %00001000
mDBGADH_BIT12:      equ    %00010000
mDBGADH_BIT13:      equ    %00100000
mDBGADH_BIT14:      equ    %01000000
mDBGADH_BIT15:      equ    %10000000


;*** DBGADL - Debug Comparator Data Low Register; 0x0000002D ***
DBGADL:             equ    $0000002D                                ;*** DBGADL - Debug Comparator Data Low Register; 0x0000002D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGADL_BIT0:        equ    0                                         ; Comparator Data Low Compare Bit 0
DBGADL_BIT1:        equ    1                                         ; Comparator Data Low Compare Bit 1
DBGADL_BIT2:        equ    2                                         ; Comparator Data Low Compare Bit 2
DBGADL_BIT3:        equ    3                                         ; Comparator Data Low Compare Bit 3
DBGADL_BIT4:        equ    4                                         ; Comparator Data Low Compare Bit 4
DBGADL_BIT5:        equ    5                                         ; Comparator Data Low Compare Bit 5
DBGADL_BIT6:        equ    6                                         ; Comparator Data Low Compare Bit 6
DBGADL_BIT7:        equ    7                                         ; Comparator Data Low Compare Bit 7
; bit position masks
mDBGADL_BIT0:       equ    %00000001
mDBGADL_BIT1:       equ    %00000010
mDBGADL_BIT2:       equ    %00000100
mDBGADL_BIT3:       equ    %00001000
mDBGADL_BIT4:       equ    %00010000
mDBGADL_BIT5:       equ    %00100000
mDBGADL_BIT6:       equ    %01000000
mDBGADL_BIT7:       equ    %10000000


;*** DBGADHM - Debug Comparator Data High Mask Register; 0x0000002E ***
DBGADHM:            equ    $0000002E                                ;*** DBGADHM - Debug Comparator Data High Mask Register; 0x0000002E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGADHM_BIT8:       equ    0                                         ; Comparator Data High Mask Bit 8
DBGADHM_BIT9:       equ    1                                         ; Comparator Data High Mask Bit 9
DBGADHM_BIT10:      equ    2                                         ; Comparator Data High Mask Bit 10
DBGADHM_BIT11:      equ    3                                         ; Comparator Data High Mask Bit 11
DBGADHM_BIT12:      equ    4                                         ; Comparator Data High Mask Bit 12
DBGADHM_BIT13:      equ    5                                         ; Comparator Data High Mask Bit 13
DBGADHM_BIT14:      equ    6                                         ; Comparator Data High Mask Bit 14
DBGADHM_BIT15:      equ    7                                         ; Comparator Data High Mask Bit 15
; bit position masks
mDBGADHM_BIT8:      equ    %00000001
mDBGADHM_BIT9:      equ    %00000010
mDBGADHM_BIT10:     equ    %00000100
mDBGADHM_BIT11:     equ    %00001000
mDBGADHM_BIT12:     equ    %00010000
mDBGADHM_BIT13:     equ    %00100000
mDBGADHM_BIT14:     equ    %01000000
mDBGADHM_BIT15:     equ    %10000000


;*** DBGADLM - Debug Comparator Data Low Mask Register; 0x0000002F ***
DBGADLM:            equ    $0000002F                                ;*** DBGADLM - Debug Comparator Data Low Mask Register; 0x0000002F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGADLM_BIT0:       equ    0                                         ; Comparator Data Low Mask Bit 0
DBGADLM_BIT1:       equ    1                                         ; Comparator Data Low Mask Bit 1
DBGADLM_BIT2:       equ    2                                         ; Comparator Data Low Mask Bit 2
DBGADLM_BIT3:       equ    3                                         ; Comparator Data Low Mask Bit 3
DBGADLM_BIT4:       equ    4                                         ; Comparator Data Low Mask Bit 4
DBGADLM_BIT5:       equ    5                                         ; Comparator Data Low Mask Bit 5
DBGADLM_BIT6:       equ    6                                         ; Comparator Data Low Mask Bit 6
DBGADLM_BIT7:       equ    7                                         ; Comparator Data Low Mask Bit 7
; bit position masks
mDBGADLM_BIT0:      equ    %00000001
mDBGADLM_BIT1:      equ    %00000010
mDBGADLM_BIT2:      equ    %00000100
mDBGADLM_BIT3:      equ    %00001000
mDBGADLM_BIT4:      equ    %00010000
mDBGADLM_BIT5:      equ    %00100000
mDBGADLM_BIT6:      equ    %01000000
mDBGADLM_BIT7:      equ    %10000000


;*** CPMUSYNR - S12CPMU Synthesizer Register; 0x00000034 ***
CPMUSYNR:           equ    $00000034                                ;*** CPMUSYNR - S12CPMU Synthesizer Register; 0x00000034 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CPMUSYNR_SYNDIV0:   equ    0                                         ; Multiplication factor of the IPLL bit 0
CPMUSYNR_SYNDIV1:   equ    1                                         ; Multiplication factor of the IPLL bit 1
CPMUSYNR_SYNDIV2:   equ    2                                         ; Multiplication factor of the IPLL bit 2
CPMUSYNR_SYNDIV3:   equ    3                                         ; Multiplication factor of the IPLL bit 3
CPMUSYNR_SYNDIV4:   equ    4                                         ; Multiplication factor of the IPLL bit 4
CPMUSYNR_SYNDIV5:   equ    5                                         ; Multiplication factor of the IPLL bit 5
CPMUSYNR_VCOFRQ0:   equ    6                                         ; VCO frequency range bit 0
CPMUSYNR_VCOFRQ1:   equ    7                                         ; VCO frequency range bit 1
; bit position masks
mCPMUSYNR_SYNDIV0:  equ    %00000001
mCPMUSYNR_SYNDIV1:  equ    %00000010
mCPMUSYNR_SYNDIV2:  equ    %00000100
mCPMUSYNR_SYNDIV3:  equ    %00001000
mCPMUSYNR_SYNDIV4:  equ    %00010000
mCPMUSYNR_SYNDIV5:  equ    %00100000
mCPMUSYNR_VCOFRQ0:  equ    %01000000
mCPMUSYNR_VCOFRQ1:  equ    %10000000


;*** CPMUREFDIV - S12CPMU Reference Divider Register; 0x00000035 ***
CPMUREFDIV:         equ    $00000035                                ;*** CPMUREFDIV - S12CPMU Reference Divider Register; 0x00000035 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CPMUREFDIV_REFDIV0: equ    0                                         ; Finer granularity for the IPLL multiplier steps bit 0
CPMUREFDIV_REFDIV1: equ    1                                         ; Finer granularity for the IPLL multiplier steps bit 1
CPMUREFDIV_REFDIV2: equ    2                                         ; Finer granularity for the IPLL multiplier steps bit 2
CPMUREFDIV_REFDIV3: equ    3                                         ; Finer granularity for the IPLL multiplier steps bit 3
CPMUREFDIV_REFFRQ0: equ    6                                         ; IPLL optimal stability and lock time configuration bit 0
CPMUREFDIV_REFFRQ1: equ    7                                         ; IPLL optimal stability and lock time configuration bit 1
; bit position masks
mCPMUREFDIV_REFDIV0: equ    %00000001
mCPMUREFDIV_REFDIV1: equ    %00000010
mCPMUREFDIV_REFDIV2: equ    %00000100
mCPMUREFDIV_REFDIV3: equ    %00001000
mCPMUREFDIV_REFFRQ0: equ    %01000000
mCPMUREFDIV_REFFRQ1: equ    %10000000


;*** CPMUPOSTDIV - S12CPMU Post Divider Register; 0x00000036 ***
CPMUPOSTDIV:        equ    $00000036                                ;*** CPMUPOSTDIV - S12CPMU Post Divider Register; 0x00000036 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CPMUPOSTDIV_POSTDIV0: equ    0                                       ; Frequency ratio between the VCOCLK and PLLCLK control bit 0
CPMUPOSTDIV_POSTDIV1: equ    1                                       ; Frequency ratio between the VCOCLK and PLLCLK control bit 1
CPMUPOSTDIV_POSTDIV2: equ    2                                       ; Frequency ratio between the VCOCLK and PLLCLK control bit 2
CPMUPOSTDIV_POSTDIV3: equ    3                                       ; Frequency ratio between the VCOCLK and PLLCLK control bit 3
CPMUPOSTDIV_POSTDIV4: equ    4                                       ; Frequency ratio between the VCOCLK and PLLCLK control bit 4
; bit position masks
mCPMUPOSTDIV_POSTDIV0: equ    %00000001
mCPMUPOSTDIV_POSTDIV1: equ    %00000010
mCPMUPOSTDIV_POSTDIV2: equ    %00000100
mCPMUPOSTDIV_POSTDIV3: equ    %00001000
mCPMUPOSTDIV_POSTDIV4: equ    %00010000


;*** CPMUFLG - S12CPMU Flags Register; 0x00000037 ***
CPMUFLG:            equ    $00000037                                ;*** CPMUFLG - S12CPMU Flags Register; 0x00000037 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CPMUFLG_UPOSC:      equ    0                                         ; Oscillator Status Bit
CPMUFLG_OSCIF:      equ    1                                         ; Oscillator Interrupt Flag
CPMUFLG_ILAF:       equ    2                                         ; Illegal Address Reset Flag
CPMUFLG_LOCK:       equ    3                                         ; Lock Status Bit
CPMUFLG_LOCKIF:     equ    4                                         ; IPLL Lock Interrupt Flag
CPMUFLG_LVRF:       equ    5                                         ; Low Voltage Reset Flag
CPMUFLG_PORF:       equ    6                                         ; Power on Reset Flag
CPMUFLG_RTIF:       equ    7                                         ; Real Time Interrupt Flag
; bit position masks
mCPMUFLG_UPOSC:     equ    %00000001
mCPMUFLG_OSCIF:     equ    %00000010
mCPMUFLG_ILAF:      equ    %00000100
mCPMUFLG_LOCK:      equ    %00001000
mCPMUFLG_LOCKIF:    equ    %00010000
mCPMUFLG_LVRF:      equ    %00100000
mCPMUFLG_PORF:      equ    %01000000
mCPMUFLG_RTIF:      equ    %10000000


;*** CPMUINT - S12CPMU Interrupt Enable Register; 0x00000038 ***
CPMUINT:            equ    $00000038                                ;*** CPMUINT - S12CPMU Interrupt Enable Register; 0x00000038 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CPMUINT_OSCIE:      equ    1                                         ; Oscillator Corrupt Interrupt Enable Bit
CPMUINT_LOCKIE:     equ    4                                         ; Lock Interrupt Enable Bit
CPMUINT_RTIE:       equ    7                                         ; Real Time Interrupt Enable Bit
; bit position masks
mCPMUINT_OSCIE:     equ    %00000010
mCPMUINT_LOCKIE:    equ    %00010000
mCPMUINT_RTIE:      equ    %10000000


;*** CPMUCLKS - S12CPMU Clock Select Register; 0x00000039 ***
CPMUCLKS:           equ    $00000039                                ;*** CPMUCLKS - S12CPMU Clock Select Register; 0x00000039 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CPMUCLKS_COPOSCSEL: equ    0                                         ; COP Clock Select
CPMUCLKS_RTIOSCSEL: equ    1                                         ; RTI Clock Select
CPMUCLKS_PCE:       equ    2                                         ; COP Enable During Pseudo Stop Bit
CPMUCLKS_PRE:       equ    3                                         ; RTI Enable During Pseudo Stop Bit
CPMUCLKS_PSTP:      equ    6                                         ; Pseudo Stop Bit
CPMUCLKS_PLLSEL:    equ    7                                         ; PLL Select Bit
; bit position masks
mCPMUCLKS_COPOSCSEL: equ    %00000001
mCPMUCLKS_RTIOSCSEL: equ    %00000010
mCPMUCLKS_PCE:      equ    %00000100
mCPMUCLKS_PRE:      equ    %00001000
mCPMUCLKS_PSTP:     equ    %01000000
mCPMUCLKS_PLLSEL:   equ    %10000000


;*** CPMUPLL - S12CPMU PLL Control Register; 0x0000003A ***
CPMUPLL:            equ    $0000003A                                ;*** CPMUPLL - S12CPMU PLL Control Register; 0x0000003A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CPMUPLL_FM0:        equ    4                                         ; PLL Frequency Modulation Enable Bit 0
CPMUPLL_FM1:        equ    5                                         ; PLL Frequency Modulation Enable Bit 1
; bit position masks
mCPMUPLL_FM0:       equ    %00010000
mCPMUPLL_FM1:       equ    %00100000


;*** CPMURTI - CPMU RTI Control Register; 0x0000003B ***
CPMURTI:            equ    $0000003B                                ;*** CPMURTI - CPMU RTI Control Register; 0x0000003B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CPMURTI_RTR0:       equ    0                                         ; Real Time Interrupt Modulus Counter Select Bit 0
CPMURTI_RTR1:       equ    1                                         ; Real Time Interrupt Modulus Counter Select Bit 1
CPMURTI_RTR2:       equ    2                                         ; Real Time Interrupt Modulus Counter Select Bit 2
CPMURTI_RTR3:       equ    3                                         ; Real Time Interrupt Modulus Counter Select Bit 3
CPMURTI_RTR4:       equ    4                                         ; Real Time Interrupt Prescale Rate Select Bit 4
CPMURTI_RTR5:       equ    5                                         ; Real Time Interrupt Prescale Rate Select Bit 5
CPMURTI_RTR6:       equ    6                                         ; Real Time Interrupt Prescale Rate Select Bit 6
CPMURTI_RTDEC:      equ    7                                         ; Decimal or Binary Divider Select Bit
; bit position masks
mCPMURTI_RTR0:      equ    %00000001
mCPMURTI_RTR1:      equ    %00000010
mCPMURTI_RTR2:      equ    %00000100
mCPMURTI_RTR3:      equ    %00001000
mCPMURTI_RTR4:      equ    %00010000
mCPMURTI_RTR5:      equ    %00100000
mCPMURTI_RTR6:      equ    %01000000
mCPMURTI_RTDEC:     equ    %10000000


;*** CPMUCOP - CPMU COP Control Register; 0x0000003C ***
CPMUCOP:            equ    $0000003C                                ;*** CPMUCOP - CPMU COP Control Register; 0x0000003C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CPMUCOP_CR0:        equ    0                                         ; COP Watchdog Timer Rate select Bit 0
CPMUCOP_CR1:        equ    1                                         ; COP Watchdog Timer Rate select Bit 1
CPMUCOP_CR2:        equ    2                                         ; COP Watchdog Timer Rate select Bit 2
CPMUCOP_WRTMASK:    equ    5                                         ; Write Mask for WCOP
CPMUCOP_RSBCK:      equ    6                                         ; COP and RTI stop in Active BDM mode Bit
CPMUCOP_WCOP:       equ    7                                         ; Window COP mode
; bit position masks
mCPMUCOP_CR0:       equ    %00000001
mCPMUCOP_CR1:       equ    %00000010
mCPMUCOP_CR2:       equ    %00000100
mCPMUCOP_WRTMASK:   equ    %00100000
mCPMUCOP_RSBCK:     equ    %01000000
mCPMUCOP_WCOP:      equ    %10000000


;*** CPMUARMCOP - CPMU COP Timer Arm/Reset Register; 0x0000003F ***
CPMUARMCOP:         equ    $0000003F                                ;*** CPMUARMCOP - CPMU COP Timer Arm/Reset Register; 0x0000003F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CPMUARMCOP_BIT0:    equ    0                                         ; CPMU COP Timer Arm/Reset Bit 0
CPMUARMCOP_BIT1:    equ    1                                         ; CPMU COP Timer Arm/Reset Bit 1
CPMUARMCOP_BIT2:    equ    2                                         ; CPMU COP Timer Arm/Reset Bit 2
CPMUARMCOP_BIT3:    equ    3                                         ; CPMU COP Timer Arm/Reset Bit 3
CPMUARMCOP_BIT4:    equ    4                                         ; CPMU COP Timer Arm/Reset Bit 4
CPMUARMCOP_BIT5:    equ    5                                         ; CPMU COP Timer Arm/Reset Bit 5
CPMUARMCOP_BIT6:    equ    6                                         ; CPMU COP Timer Arm/Reset Bit 6
CPMUARMCOP_BIT7:    equ    7                                         ; CPMU COP Timer Arm/Reset Bit 7
; bit position masks
mCPMUARMCOP_BIT0:   equ    %00000001
mCPMUARMCOP_BIT1:   equ    %00000010
mCPMUARMCOP_BIT2:   equ    %00000100
mCPMUARMCOP_BIT3:   equ    %00001000
mCPMUARMCOP_BIT4:   equ    %00010000
mCPMUARMCOP_BIT5:   equ    %00100000
mCPMUARMCOP_BIT6:   equ    %01000000
mCPMUARMCOP_BIT7:   equ    %10000000


;*** D2DCTL0 - D2D Control Register 0; 0x000000D8 ***
D2DCTL0:            equ    $000000D8                                ;*** D2DCTL0 - D2D Control Register 0; 0x000000D8 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
D2DCTL0_D2DCLKDIV0: equ    0                                         ; InterfaceClockDivider, bit 0
D2DCTL0_D2DCLKDIV1: equ    1                                         ; InterfaceClockDivider, bit 1
D2DCTL0_D2DSWAI:    equ    5                                         ; D2D Stop In Wait
D2DCTL0_D2DCW:      equ    6                                         ; D2D Connection Width
D2DCTL0_D2DEN:      equ    7                                         ; D2D Enable
; bit position masks
mD2DCTL0_D2DCLKDIV0: equ    %00000001
mD2DCTL0_D2DCLKDIV1: equ    %00000010
mD2DCTL0_D2DSWAI:   equ    %00100000
mD2DCTL0_D2DCW:     equ    %01000000
mD2DCTL0_D2DEN:     equ    %10000000


;*** D2DCTL1 - D2D Control Register 1; 0x000000D9 ***
D2DCTL1:            equ    $000000D9                                ;*** D2DCTL1 - D2D Control Register 1; 0x000000D9 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
D2DCTL1_TIMOUT0:    equ    0                                         ; Time-out Setting, bit 0
D2DCTL1_TIMOUT1:    equ    1                                         ; Time-out Setting, bit 1
D2DCTL1_TIMOUT2:    equ    2                                         ; Time-out Setting, bit 2
D2DCTL1_TIMOUT3:    equ    3                                         ; Time-out Setting, bit 3
D2DCTL1_D2DIE:      equ    7                                         ; D2D Interrupt Enable
; bit position masks
mD2DCTL1_TIMOUT0:   equ    %00000001
mD2DCTL1_TIMOUT1:   equ    %00000010
mD2DCTL1_TIMOUT2:   equ    %00000100
mD2DCTL1_TIMOUT3:   equ    %00001000
mD2DCTL1_D2DIE:     equ    %10000000


;*** D2DSTAT0 - D2D Status Register 0; 0x000000DA ***
D2DSTAT0:           equ    $000000DA                                ;*** D2DSTAT0 - D2D Status Register 0; 0x000000DA ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
D2DSTAT0_PAR0:      equ    0                                         ; Parity Bit
D2DSTAT0_PAR1:      equ    1                                         ; Parity Bit
D2DSTAT0_PARF:      equ    2                                         ; Parity Error Flag
D2DSTAT0_TERRF:     equ    3                                         ; Transaction Error Flag
D2DSTAT0_TIMEF:     equ    4                                         ; TimeOutErrorFlag
D2DSTAT0_CNCLF:     equ    5                                         ; CNCLF
D2DSTAT0_ACKERF:    equ    6                                         ; Acknowledge Error Flag
D2DSTAT0_ERRIF:     equ    7                                         ; D2D error interrupt flag
; bit position masks
mD2DSTAT0_PAR0:     equ    %00000001
mD2DSTAT0_PAR1:     equ    %00000010
mD2DSTAT0_PARF:     equ    %00000100
mD2DSTAT0_TERRF:    equ    %00001000
mD2DSTAT0_TIMEF:    equ    %00010000
mD2DSTAT0_CNCLF:    equ    %00100000
mD2DSTAT0_ACKERF:   equ    %01000000
mD2DSTAT0_ERRIF:    equ    %10000000


;*** D2DSTAT1 - D2D Status Register 1; 0x000000DB ***
D2DSTAT1:           equ    $000000DB                                ;*** D2DSTAT1 - D2D Status Register 1; 0x000000DB ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
D2DSTAT1_D2DBSY:    equ    6                                         ; D2D Initiator Busy
D2DSTAT1_D2DIF:     equ    7                                         ; D2D InterruptFlag
; bit position masks
mD2DSTAT1_D2DBSY:   equ    %01000000
mD2DSTAT1_D2DIF:    equ    %10000000


;*** D2DADR - D2D Address Buffer Register; 0x000000DC ***
D2DADR:             equ    $000000DC                                ;*** D2DADR - D2D Address Buffer Register; 0x000000DC ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
D2DADR_ADR0:        equ    0                                         ; Transaction Address, bit 0
D2DADR_ADR1:        equ    1                                         ; Transaction Address, bit 1
D2DADR_ADR2:        equ    2                                         ; Transaction Address, bit 2
D2DADR_ADR3:        equ    3                                         ; Transaction Address, bit 3
D2DADR_ADR4:        equ    4                                         ; Transaction Address, bit 4
D2DADR_ADR5:        equ    5                                         ; Transaction Address, bit 5
D2DADR_ADR6:        equ    6                                         ; Transaction Address, bit 6
D2DADR_ADR7:        equ    7                                         ; Transaction Address, bit 7
D2DADR_NBLK:        equ    12                                        ; Transaction Mode
D2DADR_SZ8:         equ    14                                        ; Transaction Size
D2DADR_RWB:         equ    15                                        ; Transaction Read-Write Direction
; bit position masks
mD2DADR_ADR0:       equ    %00000001
mD2DADR_ADR1:       equ    %00000010
mD2DADR_ADR2:       equ    %00000100
mD2DADR_ADR3:       equ    %00001000
mD2DADR_ADR4:       equ    %00010000
mD2DADR_ADR5:       equ    %00100000
mD2DADR_ADR6:       equ    %01000000
mD2DADR_ADR7:       equ    %10000000
mD2DADR_NBLK:       equ    %1000000000000
mD2DADR_SZ8:        equ    %100000000000000
mD2DADR_RWB:        equ    %1000000000000000


;*** D2DADRHI - D2D Address Buffer Register High; 0x000000DC ***
D2DADRHI:           equ    $000000DC                                ;*** D2DADRHI - D2D Address Buffer Register High; 0x000000DC ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
D2DADRHI_NBLK:      equ    4                                         ; Transaction Mode
D2DADRHI_SZ8:       equ    6                                         ; Transaction Size
D2DADRHI_RWB:       equ    7                                         ; Transaction Read-Write Direction
; bit position masks
mD2DADRHI_NBLK:     equ    %00010000
mD2DADRHI_SZ8:      equ    %01000000
mD2DADRHI_RWB:      equ    %10000000


;*** D2DADRLO - D2D Address Buffer Register Low; 0x000000DD ***
D2DADRLO:           equ    $000000DD                                ;*** D2DADRLO - D2D Address Buffer Register Low; 0x000000DD ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
D2DADRLO_ADR0:      equ    0                                         ; Transaction Address, bit 0
D2DADRLO_ADR1:      equ    1                                         ; Transaction Address, bit 1
D2DADRLO_ADR2:      equ    2                                         ; Transaction Address, bit 2
D2DADRLO_ADR3:      equ    3                                         ; Transaction Address, bit 3
D2DADRLO_ADR4:      equ    4                                         ; Transaction Address, bit 4
D2DADRLO_ADR5:      equ    5                                         ; Transaction Address, bit 5
D2DADRLO_ADR6:      equ    6                                         ; Transaction Address, bit 6
D2DADRLO_ADR7:      equ    7                                         ; Transaction Address, bit 7
; bit position masks
mD2DADRLO_ADR0:     equ    %00000001
mD2DADRLO_ADR1:     equ    %00000010
mD2DADRLO_ADR2:     equ    %00000100
mD2DADRLO_ADR3:     equ    %00001000
mD2DADRLO_ADR4:     equ    %00010000
mD2DADRLO_ADR5:     equ    %00100000
mD2DADRLO_ADR6:     equ    %01000000
mD2DADRLO_ADR7:     equ    %10000000


;*** D2DDATA - D2D Data Buffer Register; 0x000000DE ***
D2DDATA:            equ    $000000DE                                ;*** D2DDATA - D2D Data Buffer Register; 0x000000DE ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
D2DDATA_DATA0:      equ    0                                         ; Transaction Data, bit 0
D2DDATA_DATA1:      equ    1                                         ; Transaction Data, bit 1
D2DDATA_DATA2:      equ    2                                         ; Transaction Data, bit 2
D2DDATA_DATA3:      equ    3                                         ; Transaction Data, bit 3
D2DDATA_DATA4:      equ    4                                         ; Transaction Data, bit 4
D2DDATA_DATA5:      equ    5                                         ; Transaction Data, bit 5
D2DDATA_DATA6:      equ    6                                         ; Transaction Data, bit 6
D2DDATA_DATA7:      equ    7                                         ; Transaction Data, bit 7
D2DDATA_DATA8:      equ    8                                         ; Transaction Data, bit 8
D2DDATA_DATA9:      equ    9                                         ; Transaction Data, bit 9
D2DDATA_DATA10:     equ    10                                        ; Transaction Data, bit 10
D2DDATA_DATA11:     equ    11                                        ; Transaction Data, bit 11
D2DDATA_DATA12:     equ    12                                        ; Transaction Data, bit 12
D2DDATA_DATA13:     equ    13                                        ; Transaction Data, bit 13
D2DDATA_DATA14:     equ    14                                        ; Transaction Data, bit 14
D2DDATA_DATA15:     equ    15                                        ; Transaction Data, bit 15
; bit position masks
mD2DDATA_DATA0:     equ    %00000001
mD2DDATA_DATA1:     equ    %00000010
mD2DDATA_DATA2:     equ    %00000100
mD2DDATA_DATA3:     equ    %00001000
mD2DDATA_DATA4:     equ    %00010000
mD2DDATA_DATA5:     equ    %00100000
mD2DDATA_DATA6:     equ    %01000000
mD2DDATA_DATA7:     equ    %10000000
mD2DDATA_DATA8:     equ    %100000000
mD2DDATA_DATA9:     equ    %1000000000
mD2DDATA_DATA10:    equ    %10000000000
mD2DDATA_DATA11:    equ    %100000000000
mD2DDATA_DATA12:    equ    %1000000000000
mD2DDATA_DATA13:    equ    %10000000000000
mD2DDATA_DATA14:    equ    %100000000000000
mD2DDATA_DATA15:    equ    %1000000000000000


;*** D2DDATAHI - D2D Data Buffer Register High; 0x000000DE ***
D2DDATAHI:          equ    $000000DE                                ;*** D2DDATAHI - D2D Data Buffer Register High; 0x000000DE ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
D2DDATAHI_DATA8:    equ    0                                         ; Transaction Data, bit 8
D2DDATAHI_DATA9:    equ    1                                         ; Transaction Data, bit 9
D2DDATAHI_DATA10:   equ    2                                         ; Transaction Data, bit 10
D2DDATAHI_DATA11:   equ    3                                         ; Transaction Data, bit 11
D2DDATAHI_DATA12:   equ    4                                         ; Transaction Data, bit 12
D2DDATAHI_DATA13:   equ    5                                         ; Transaction Data, bit 13
D2DDATAHI_DATA14:   equ    6                                         ; Transaction Data, bit 14
D2DDATAHI_DATA15:   equ    7                                         ; Transaction Data, bit 15
; bit position masks
mD2DDATAHI_DATA8:   equ    %00000001
mD2DDATAHI_DATA9:   equ    %00000010
mD2DDATAHI_DATA10:  equ    %00000100
mD2DDATAHI_DATA11:  equ    %00001000
mD2DDATAHI_DATA12:  equ    %00010000
mD2DDATAHI_DATA13:  equ    %00100000
mD2DDATAHI_DATA14:  equ    %01000000
mD2DDATAHI_DATA15:  equ    %10000000


;*** D2DDATALO - D2D Data Buffer Register Low; 0x000000DF ***
D2DDATALO:          equ    $000000DF                                ;*** D2DDATALO - D2D Data Buffer Register Low; 0x000000DF ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
D2DDATALO_DATA0:    equ    0                                         ; Transaction Data, bit 0
D2DDATALO_DATA1:    equ    1                                         ; Transaction Data, bit 1
D2DDATALO_DATA2:    equ    2                                         ; Transaction Data, bit 2
D2DDATALO_DATA3:    equ    3                                         ; Transaction Data, bit 3
D2DDATALO_DATA4:    equ    4                                         ; Transaction Data, bit 4
D2DDATALO_DATA5:    equ    5                                         ; Transaction Data, bit 5
D2DDATALO_DATA6:    equ    6                                         ; Transaction Data, bit 6
D2DDATALO_DATA7:    equ    7                                         ; Transaction Data, bit 7
; bit position masks
mD2DDATALO_DATA0:   equ    %00000001
mD2DDATALO_DATA1:   equ    %00000010
mD2DDATALO_DATA2:   equ    %00000100
mD2DDATALO_DATA3:   equ    %00001000
mD2DDATALO_DATA4:   equ    %00010000
mD2DDATALO_DATA5:   equ    %00100000
mD2DDATALO_DATA6:   equ    %01000000
mD2DDATALO_DATA7:   equ    %10000000


;*** SPICR1 - SPI  Control Register 1; 0x000000E8 ***
SPICR1:             equ    $000000E8                                ;*** SPICR1 - SPI  Control Register 1; 0x000000E8 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPICR1_LSBFE:       equ    0                                         ; SPI LSB-First Enable
SPICR1_SSOE:        equ    1                                         ; Slave Select Output Enable
SPICR1_CPHA:        equ    2                                         ; SPI Clock Phase Bit
SPICR1_CPOL:        equ    3                                         ; SPI Clock Polarity Bit
SPICR1_MSTR:        equ    4                                         ; SPI Master/Slave Mode Select Bit
SPICR1_SPTIE:       equ    5                                         ; SPI Transmit Interrupt Enable
SPICR1_SPE:         equ    6                                         ; SPI System Enable Bit
SPICR1_SPIE:        equ    7                                         ; SPI Interrupt Enable Bit
; bit position masks
mSPICR1_LSBFE:      equ    %00000001
mSPICR1_SSOE:       equ    %00000010
mSPICR1_CPHA:       equ    %00000100
mSPICR1_CPOL:       equ    %00001000
mSPICR1_MSTR:       equ    %00010000
mSPICR1_SPTIE:      equ    %00100000
mSPICR1_SPE:        equ    %01000000
mSPICR1_SPIE:       equ    %10000000


;*** SPICR2 - SPI  Control Register 2; 0x000000E9 ***
SPICR2:             equ    $000000E9                                ;*** SPICR2 - SPI  Control Register 2; 0x000000E9 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPICR2_SPC0:        equ    0                                         ; Serial Pin Control Bit 0
SPICR2_SPISWAI:     equ    1                                         ; SPI Stop in Wait Mode Bit
SPICR2_BIDIROE:     equ    3                                         ; Output enable in the Bidirectional mode of operation
SPICR2_MODFEN:      equ    4                                         ; Mode Fault Enable Bit
SPICR2_XFRW:        equ    6                                         ; Transfer Width
; bit position masks
mSPICR2_SPC0:       equ    %00000001
mSPICR2_SPISWAI:    equ    %00000010
mSPICR2_BIDIROE:    equ    %00001000
mSPICR2_MODFEN:     equ    %00010000
mSPICR2_XFRW:       equ    %01000000


;*** SPIBR - SPI  Baud Rate Register; 0x000000EA ***
SPIBR:              equ    $000000EA                                ;*** SPIBR - SPI  Baud Rate Register; 0x000000EA ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPIBR_SPR0:         equ    0                                         ; SPI Baud Rate Selection Bit 0
SPIBR_SPR1:         equ    1                                         ; SPI Baud Rate Selection Bit 1
SPIBR_SPR2:         equ    2                                         ; SPI Baud Rate Selection Bit 2
SPIBR_SPPR0:        equ    4                                         ; SPI Baud Rate Preselection Bits 0
SPIBR_SPPR1:        equ    5                                         ; SPI Baud Rate Preselection Bits 1
SPIBR_SPPR2:        equ    6                                         ; SPI Baud Rate Preselection Bits 2
; bit position masks
mSPIBR_SPR0:        equ    %00000001
mSPIBR_SPR1:        equ    %00000010
mSPIBR_SPR2:        equ    %00000100
mSPIBR_SPPR0:       equ    %00010000
mSPIBR_SPPR1:       equ    %00100000
mSPIBR_SPPR2:       equ    %01000000


;*** SPISR - SPI  Status Register; 0x000000EB ***
SPISR:              equ    $000000EB                                ;*** SPISR - SPI  Status Register; 0x000000EB ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPISR_MODF:         equ    4                                         ; Mode Fault Flag
SPISR_SPTEF:        equ    5                                         ; SPI Transmit Empty Interrupt Flag
SPISR_SPIF:         equ    7                                         ; SPIF Receive Interrupt Flag
; bit position masks
mSPISR_MODF:        equ    %00010000
mSPISR_SPTEF:       equ    %00100000
mSPISR_SPIF:        equ    %10000000


;*** SPIDR - SPI  Data Register; 0x000000EC ***
SPIDR:              equ    $000000EC                                ;*** SPIDR - SPI  Data Register; 0x000000EC ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPIDR_R0_T0:        equ    0                                         ; SPI  Data Bit 0
SPIDR_R1_T1:        equ    1                                         ; SPI  Data Bit 1
SPIDR_R2_T2:        equ    2                                         ; SPI  Data Bit 2
SPIDR_R3_T3:        equ    3                                         ; SPI  Data Bit 3
SPIDR_R4_T4:        equ    4                                         ; SPI  Data Bit 4
SPIDR_R5_T5:        equ    5                                         ; SPI  Data Bit 5
SPIDR_R6_T6:        equ    6                                         ; SPI  Data Bit 6
SPIDR_R7_T7:        equ    7                                         ; SPI  Data Bit 7
SPIDR_R8_T8:        equ    8                                         ; SPI  Data Bit 8
SPIDR_R9_T9:        equ    9                                         ; SPI  Data Bit 9
SPIDR_R10_T10:      equ    10                                        ; SPI  Data Bit 10
SPIDR_R11_T11:      equ    11                                        ; SPI  Data Bit 11
SPIDR_R12_T12:      equ    12                                        ; SPI  Data Bit 12
SPIDR_R13_T13:      equ    13                                        ; SPI  Data Bit 13
SPIDR_R14_T14:      equ    14                                        ; SPI  Data Bit 14
SPIDR_R15_T15:      equ    15                                        ; SPI  Data Bit 15
; bit position masks
mSPIDR_R0_T0:       equ    %00000001
mSPIDR_R1_T1:       equ    %00000010
mSPIDR_R2_T2:       equ    %00000100
mSPIDR_R3_T3:       equ    %00001000
mSPIDR_R4_T4:       equ    %00010000
mSPIDR_R5_T5:       equ    %00100000
mSPIDR_R6_T6:       equ    %01000000
mSPIDR_R7_T7:       equ    %10000000
mSPIDR_R8_T8:       equ    %100000000
mSPIDR_R9_T9:       equ    %1000000000
mSPIDR_R10_T10:     equ    %10000000000
mSPIDR_R11_T11:     equ    %100000000000
mSPIDR_R12_T12:     equ    %1000000000000
mSPIDR_R13_T13:     equ    %10000000000000
mSPIDR_R14_T14:     equ    %100000000000000
mSPIDR_R15_T15:     equ    %1000000000000000


;*** SPIDRH - SPI  Data Register High; 0x000000EC ***
SPIDRH:             equ    $000000EC                                ;*** SPIDRH - SPI  Data Register High; 0x000000EC ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPIDRH_R8_T8:       equ    0                                         ; SPI  Data Bit 8
SPIDRH_R9_T9:       equ    1                                         ; SPI  Data Bit 9
SPIDRH_R10_T10:     equ    2                                         ; SPI  Data Bit 10
SPIDRH_R11_T11:     equ    3                                         ; SPI  Data Bit 11
SPIDRH_R12_T12:     equ    4                                         ; SPI  Data Bit 12
SPIDRH_R13_T13:     equ    5                                         ; SPI  Data Bit 13
SPIDRH_R14_T14:     equ    6                                         ; SPI  Data Bit 14
SPIDRH_R15_T15:     equ    7                                         ; SPI  Data Bit 15
; bit position masks
mSPIDRH_R8_T8:      equ    %00000001
mSPIDRH_R9_T9:      equ    %00000010
mSPIDRH_R10_T10:    equ    %00000100
mSPIDRH_R11_T11:    equ    %00001000
mSPIDRH_R12_T12:    equ    %00010000
mSPIDRH_R13_T13:    equ    %00100000
mSPIDRH_R14_T14:    equ    %01000000
mSPIDRH_R15_T15:    equ    %10000000


;*** SPIDRL - SPI  Data Register Low; 0x000000ED ***
SPIDRL:             equ    $000000ED                                ;*** SPIDRL - SPI  Data Register Low; 0x000000ED ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPIDRL_R0_T0:       equ    0                                         ; SPI  Data Bit 0
SPIDRL_R1_T1:       equ    1                                         ; SPI  Data Bit 1
SPIDRL_R2_T2:       equ    2                                         ; SPI  Data Bit 2
SPIDRL_R3_T3:       equ    3                                         ; SPI  Data Bit 3
SPIDRL_R4_T4:       equ    4                                         ; SPI  Data Bit 4
SPIDRL_R5_T5:       equ    5                                         ; SPI  Data Bit 5
SPIDRL_R6_T6:       equ    6                                         ; SPI  Data Bit 6
SPIDRL_R7_T7:       equ    7                                         ; SPI  Data Bit 7
; bit position masks
mSPIDRL_R0_T0:      equ    %00000001
mSPIDRL_R1_T1:      equ    %00000010
mSPIDRL_R2_T2:      equ    %00000100
mSPIDRL_R3_T3:      equ    %00001000
mSPIDRL_R4_T4:      equ    %00010000
mSPIDRL_R5_T5:      equ    %00100000
mSPIDRL_R6_T6:      equ    %01000000
mSPIDRL_R7_T7:      equ    %10000000


;*** FCLKDIV - Flash Clock Divider Register; 0x00000100 ***
FCLKDIV:            equ    $00000100                                ;*** FCLKDIV - Flash Clock Divider Register; 0x00000100 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FCLKDIV_FDIV0:      equ    0                                         ; Clock Divider Bit 0
FCLKDIV_FDIV1:      equ    1                                         ; Clock Divider Bit 1
FCLKDIV_FDIV2:      equ    2                                         ; Clock Divider Bit 2
FCLKDIV_FDIV3:      equ    3                                         ; Clock Divider Bit 3
FCLKDIV_FDIV4:      equ    4                                         ; Clock Divider Bit 4
FCLKDIV_FDIV5:      equ    5                                         ; Clock Divider Bit 5
FCLKDIV_FDIVLCK:    equ    6                                         ; Clock divider locked
FCLKDIV_FDIVLD:     equ    7                                         ; Clock Divider Loaded
; bit position masks
mFCLKDIV_FDIV0:     equ    %00000001
mFCLKDIV_FDIV1:     equ    %00000010
mFCLKDIV_FDIV2:     equ    %00000100
mFCLKDIV_FDIV3:     equ    %00001000
mFCLKDIV_FDIV4:     equ    %00010000
mFCLKDIV_FDIV5:     equ    %00100000
mFCLKDIV_FDIVLCK:   equ    %01000000
mFCLKDIV_FDIVLD:    equ    %10000000


;*** FSEC - Flash Security Register; 0x00000101 ***
FSEC:               equ    $00000101                                ;*** FSEC - Flash Security Register; 0x00000101 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FSEC_SEC0:          equ    0                                         ; Flash Security Bit 0
FSEC_SEC1:          equ    1                                         ; Flash Security Bit 1
FSEC_RNV2:          equ    2                                         ; Reserved Nonvolatile Bit 2
FSEC_RNV3:          equ    3                                         ; Reserved Nonvolatile Bit 3
FSEC_RNV4:          equ    4                                         ; Reserved Nonvolatile Bit 4
FSEC_RNV5:          equ    5                                         ; Reserved Nonvolatile Bit 5
FSEC_KEYEN0:        equ    6                                         ; Backdoor Key Security Enable Bit 0
FSEC_KEYEN1:        equ    7                                         ; Backdoor Key Security Enable Bit 1
; bit position masks
mFSEC_SEC0:         equ    %00000001
mFSEC_SEC1:         equ    %00000010
mFSEC_RNV2:         equ    %00000100
mFSEC_RNV3:         equ    %00001000
mFSEC_RNV4:         equ    %00010000
mFSEC_RNV5:         equ    %00100000
mFSEC_KEYEN0:       equ    %01000000
mFSEC_KEYEN1:       equ    %10000000


;*** FCCOBIX - Flash CCOB Index Register; 0x00000102 ***
FCCOBIX:            equ    $00000102                                ;*** FCCOBIX - Flash CCOB Index Register; 0x00000102 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FCCOBIX_CCOBIX0:    equ    0                                         ; Common Command Register Index Bit 0
FCCOBIX_CCOBIX1:    equ    1                                         ; Common Command Register Index Bit 1
FCCOBIX_CCOBIX2:    equ    2                                         ; Common Command Register Index Bit 2
; bit position masks
mFCCOBIX_CCOBIX0:   equ    %00000001
mFCCOBIX_CCOBIX1:   equ    %00000010
mFCCOBIX_CCOBIX2:   equ    %00000100


;*** FCNFG - Flash Configuration Register; 0x00000104 ***
FCNFG:              equ    $00000104                                ;*** FCNFG - Flash Configuration Register; 0x00000104 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FCNFG_FSFD:         equ    0                                         ; Force Single Bit Fault Detect
FCNFG_FDFD:         equ    1                                         ; Force Double Bit Fault Detect
FCNFG_IGNSF:        equ    4                                         ; Ignore Single Bit Fault
FCNFG_CCIE:         equ    7                                         ; Command Complete Interrupt Enable
; bit position masks
mFCNFG_FSFD:        equ    %00000001
mFCNFG_FDFD:        equ    %00000010
mFCNFG_IGNSF:       equ    %00010000
mFCNFG_CCIE:        equ    %10000000


;*** FERCNFG - Flash Error Configuration Register; 0x00000105 ***
FERCNFG:            equ    $00000105                                ;*** FERCNFG - Flash Error Configuration Register; 0x00000105 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FERCNFG_SFDIE:      equ    0                                         ; Single Bit Fault Detect Interrupt Enable
FERCNFG_DFDIE:      equ    1                                         ; Double Bit Fault Detect Interrupt Enable
; bit position masks
mFERCNFG_SFDIE:     equ    %00000001
mFERCNFG_DFDIE:     equ    %00000010


;*** FSTAT - Flash Status Register; 0x00000106 ***
FSTAT:              equ    $00000106                                ;*** FSTAT - Flash Status Register; 0x00000106 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FSTAT_MGSTAT0:      equ    0                                         ; Memory Controller Command Completion Status Flag 0
FSTAT_MGSTAT1:      equ    1                                         ; Memory Controller Command Completion Status Flag 1
FSTAT_MGBUSY:       equ    3                                         ; Memory Controller Busy Flag
FSTAT_FPVIOL:       equ    4                                         ; Flash Protection Violation Flag
FSTAT_ACCERR:       equ    5                                         ; Flash Access Error Flag
FSTAT_CCIF:         equ    7                                         ; Command Complete Interrupt Flag
; bit position masks
mFSTAT_MGSTAT0:     equ    %00000001
mFSTAT_MGSTAT1:     equ    %00000010
mFSTAT_MGBUSY:      equ    %00001000
mFSTAT_FPVIOL:      equ    %00010000
mFSTAT_ACCERR:      equ    %00100000
mFSTAT_CCIF:        equ    %10000000


;*** FERSTAT - Flash Error Status Register; 0x00000107 ***
FERSTAT:            equ    $00000107                                ;*** FERSTAT - Flash Error Status Register; 0x00000107 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FERSTAT_SFDIF:      equ    0                                         ; Single Bit Fault Detect Interrupt Flag
FERSTAT_DFDIF:      equ    1                                         ; Double Bit Fault Detect Interrupt Flag
; bit position masks
mFERSTAT_SFDIF:     equ    %00000001
mFERSTAT_DFDIF:     equ    %00000010


;*** FPROT - P-Flash Protection Register; 0x00000108 ***
FPROT:              equ    $00000108                                ;*** FPROT - P-Flash Protection Register; 0x00000108 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FPROT_FPLS0:        equ    0                                         ; Flash Protection Lower Address Size Bit 0
FPROT_FPLS1:        equ    1                                         ; Flash Protection Lower Address Size Bit 1
FPROT_FPLDIS:       equ    2                                         ; Flash Protection Lower Address Range Disable
FPROT_FPHS0:        equ    3                                         ; Flash Protection Higher Address Size Bit 0
FPROT_FPHS1:        equ    4                                         ; Flash Protection Higher Address Size Bit 1
FPROT_FPHDIS:       equ    5                                         ; Flash Protection Higher Address Range Disable
FPROT_RNV6:         equ    6                                         ; Reserved Nonvolatile Bit
FPROT_FPOPEN:       equ    7                                         ; Flash Protection Operation Enable
; bit position masks
mFPROT_FPLS0:       equ    %00000001
mFPROT_FPLS1:       equ    %00000010
mFPROT_FPLDIS:      equ    %00000100
mFPROT_FPHS0:       equ    %00001000
mFPROT_FPHS1:       equ    %00010000
mFPROT_FPHDIS:      equ    %00100000
mFPROT_RNV6:        equ    %01000000
mFPROT_FPOPEN:      equ    %10000000


;*** DFPROT - D-Flash Protection Register; 0x00000109 ***
DFPROT:             equ    $00000109                                ;*** DFPROT - D-Flash Protection Register; 0x00000109 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DFPROT_DPS0:        equ    0                                         ; D-Flash Protection Size Bit 0
DFPROT_DPS1:        equ    1                                         ; D-Flash Protection Size Bit 1
DFPROT_DPS2:        equ    2                                         ; D-Flash Protection Size Bit 2
DFPROT_DPS3:        equ    3                                         ; D-Flash Protection Size Bit 3
DFPROT_DPOPEN:      equ    7                                         ; D-Flash Protection Control
; bit position masks
mDFPROT_DPS0:       equ    %00000001
mDFPROT_DPS1:       equ    %00000010
mDFPROT_DPS2:       equ    %00000100
mDFPROT_DPS3:       equ    %00001000
mDFPROT_DPOPEN:     equ    %10000000


;*** FCCOB - Flash Common Command Object Register; 0x0000010A ***
FCCOB:              equ    $0000010A                                ;*** FCCOB - Flash Common Command Object Register; 0x0000010A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FCCOB_CCOB0:        equ    0                                         ; Flash Common Command Object Bit 0
FCCOB_CCOB1:        equ    1                                         ; Flash Common Command Object Bit 1
FCCOB_CCOB2:        equ    2                                         ; Flash Common Command Object Bit 2
FCCOB_CCOB3:        equ    3                                         ; Flash Common Command Object Bit 3
FCCOB_CCOB4:        equ    4                                         ; Flash Common Command Object Bit 4
FCCOB_CCOB5:        equ    5                                         ; Flash Common Command Object Bit 5
FCCOB_CCOB6:        equ    6                                         ; Flash Common Command Object Bit 6
FCCOB_CCOB7:        equ    7                                         ; Flash Common Command Object Bit 7
FCCOB_CCOB8:        equ    8                                         ; Flash Common Command Object Bit 8
FCCOB_CCOB9:        equ    9                                         ; Flash Common Command Object Bit 9
FCCOB_CCOB10:       equ    10                                        ; Flash Common Command Object Bit 10
FCCOB_CCOB11:       equ    11                                        ; Flash Common Command Object Bit 11
FCCOB_CCOB12:       equ    12                                        ; Flash Common Command Object Bit 12
FCCOB_CCOB13:       equ    13                                        ; Flash Common Command Object Bit 13
FCCOB_CCOB14:       equ    14                                        ; Flash Common Command Object Bit 14
FCCOB_CCOB15:       equ    15                                        ; Flash Common Command Object Bit 15
; bit position masks
mFCCOB_CCOB0:       equ    %00000001
mFCCOB_CCOB1:       equ    %00000010
mFCCOB_CCOB2:       equ    %00000100
mFCCOB_CCOB3:       equ    %00001000
mFCCOB_CCOB4:       equ    %00010000
mFCCOB_CCOB5:       equ    %00100000
mFCCOB_CCOB6:       equ    %01000000
mFCCOB_CCOB7:       equ    %10000000
mFCCOB_CCOB8:       equ    %100000000
mFCCOB_CCOB9:       equ    %1000000000
mFCCOB_CCOB10:      equ    %10000000000
mFCCOB_CCOB11:      equ    %100000000000
mFCCOB_CCOB12:      equ    %1000000000000
mFCCOB_CCOB13:      equ    %10000000000000
mFCCOB_CCOB14:      equ    %100000000000000
mFCCOB_CCOB15:      equ    %1000000000000000


;*** FCCOBHI - Flash Common Command Object Register High; 0x0000010A ***
FCCOBHI:            equ    $0000010A                                ;*** FCCOBHI - Flash Common Command Object Register High; 0x0000010A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FCCOBHI_CCOB8:      equ    0                                         ; Flash Common Command Object Bit 8
FCCOBHI_CCOB9:      equ    1                                         ; Flash Common Command Object Bit 9
FCCOBHI_CCOB10:     equ    2                                         ; Flash Common Command Object Bit 10
FCCOBHI_CCOB11:     equ    3                                         ; Flash Common Command Object Bit 11
FCCOBHI_CCOB12:     equ    4                                         ; Flash Common Command Object Bit 12
FCCOBHI_CCOB13:     equ    5                                         ; Flash Common Command Object Bit 13
FCCOBHI_CCOB14:     equ    6                                         ; Flash Common Command Object Bit 14
FCCOBHI_CCOB15:     equ    7                                         ; Flash Common Command Object Bit 15
; bit position masks
mFCCOBHI_CCOB8:     equ    %00000001
mFCCOBHI_CCOB9:     equ    %00000010
mFCCOBHI_CCOB10:    equ    %00000100
mFCCOBHI_CCOB11:    equ    %00001000
mFCCOBHI_CCOB12:    equ    %00010000
mFCCOBHI_CCOB13:    equ    %00100000
mFCCOBHI_CCOB14:    equ    %01000000
mFCCOBHI_CCOB15:    equ    %10000000


;*** FCCOBLO - Flash Common Command Object Register Low; 0x0000010B ***
FCCOBLO:            equ    $0000010B                                ;*** FCCOBLO - Flash Common Command Object Register Low; 0x0000010B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FCCOBLO_CCOB0:      equ    0                                         ; Flash Common Command Object Bit 0
FCCOBLO_CCOB1:      equ    1                                         ; Flash Common Command Object Bit 1
FCCOBLO_CCOB2:      equ    2                                         ; Flash Common Command Object Bit 2
FCCOBLO_CCOB3:      equ    3                                         ; Flash Common Command Object Bit 3
FCCOBLO_CCOB4:      equ    4                                         ; Flash Common Command Object Bit 4
FCCOBLO_CCOB5:      equ    5                                         ; Flash Common Command Object Bit 5
FCCOBLO_CCOB6:      equ    6                                         ; Flash Common Command Object Bit 6
FCCOBLO_CCOB7:      equ    7                                         ; Flash Common Command Object Bit 7
; bit position masks
mFCCOBLO_CCOB0:     equ    %00000001
mFCCOBLO_CCOB1:     equ    %00000010
mFCCOBLO_CCOB2:     equ    %00000100
mFCCOBLO_CCOB3:     equ    %00001000
mFCCOBLO_CCOB4:     equ    %00010000
mFCCOBLO_CCOB5:     equ    %00100000
mFCCOBLO_CCOB6:     equ    %01000000
mFCCOBLO_CCOB7:     equ    %10000000


;*** FOPT - Flash Option Register; 0x00000110 ***
FOPT:               equ    $00000110                                ;*** FOPT - Flash Option Register; 0x00000110 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FOPT_NV0:           equ    0                                         ; Nonvolatile Bit 0
FOPT_NV1:           equ    1                                         ; Nonvolatile Bit 1
FOPT_NV2:           equ    2                                         ; Nonvolatile Bit 2
FOPT_NV3:           equ    3                                         ; Nonvolatile Bit 3
FOPT_NV4:           equ    4                                         ; Nonvolatile Bit 4
FOPT_NV5:           equ    5                                         ; Nonvolatile Bit 5
FOPT_NV6:           equ    6                                         ; Nonvolatile Bit 6
FOPT_NV7:           equ    7                                         ; Nonvolatile Bit 7
; bit position masks
mFOPT_NV0:          equ    %00000001
mFOPT_NV1:          equ    %00000010
mFOPT_NV2:          equ    %00000100
mFOPT_NV3:          equ    %00001000
mFOPT_NV4:          equ    %00010000
mFOPT_NV5:          equ    %00100000
mFOPT_NV6:          equ    %01000000
mFOPT_NV7:          equ    %10000000


;*** PTIA - Port A Input Register; 0x00000120 ***
PTIA:               equ    $00000120                                ;*** PTIA - Port A Input Register; 0x00000120 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTIA_PTIA0:         equ    0                                         ; Port A input data bit 0
PTIA_PTIA1:         equ    1                                         ; Port A input data bit 1
PTIA_PTIA2:         equ    2                                         ; Port A input data bit 2
PTIA_PTIA3:         equ    3                                         ; Port A input data bit 3
PTIA_PTIA4:         equ    4                                         ; Port A input data bit 4
PTIA_PTIA5:         equ    5                                         ; Port A input data bit 5
PTIA_PTIA6:         equ    6                                         ; Port A input data bit 6
PTIA_PTIA7:         equ    7                                         ; Port A input data bit 7
; bit position masks
mPTIA_PTIA0:        equ    %00000001
mPTIA_PTIA1:        equ    %00000010
mPTIA_PTIA2:        equ    %00000100
mPTIA_PTIA3:        equ    %00001000
mPTIA_PTIA4:        equ    %00010000
mPTIA_PTIA5:        equ    %00100000
mPTIA_PTIA6:        equ    %01000000
mPTIA_PTIA7:        equ    %10000000


;*** PTIB - Port B Input Register; 0x00000121 ***
PTIB:               equ    $00000121                                ;*** PTIB - Port B Input Register; 0x00000121 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTIB_PTIB0:         equ    0                                         ; Port B input data bit 0
PTIB_PTIB1:         equ    1                                         ; Port B input data bit 1
; bit position masks
mPTIB_PTIB0:        equ    %00000001
mPTIB_PTIB1:        equ    %00000010


;*** CPMULVCTL - Low Voltage Control Register; 0x000001F1 ***
CPMULVCTL:          equ    $000001F1                                ;*** CPMULVCTL - Low Voltage Control Register; 0x000001F1 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CPMULVCTL_LVIF:     equ    0                                         ; Low-Voltage Interrupt Flag
CPMULVCTL_LVIE:     equ    1                                         ; Low-Voltage Interrupt Enable Bit
CPMULVCTL_LVDS:     equ    2                                         ; Low-Voltage Detect Status Bit
; bit position masks
mCPMULVCTL_LVIF:    equ    %00000001
mCPMULVCTL_LVIE:    equ    %00000010
mCPMULVCTL_LVDS:    equ    %00000100


;*** CPMUIRCTRIM - S12CPMU IRC1M Trim Registers; 0x000001F8 ***
CPMUIRCTRIM:        equ    $000001F8                                ;*** CPMUIRCTRIM - S12CPMU IRC1M Trim Registers; 0x000001F8 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CPMUIRCTRIM_IRCTRIM0: equ    0                                       ; IRC1M Frequency Trim Bit 0
CPMUIRCTRIM_IRCTRIM1: equ    1                                       ; IRC1M Frequency Trim Bit 1
CPMUIRCTRIM_IRCTRIM2: equ    2                                       ; IRC1M Frequency Trim Bit 2
CPMUIRCTRIM_IRCTRIM3: equ    3                                       ; IRC1M Frequency Trim Bit 3
CPMUIRCTRIM_IRCTRIM4: equ    4                                       ; IRC1M Frequency Trim Bit 4
CPMUIRCTRIM_IRCTRIM5: equ    5                                       ; IRC1M Frequency Trim Bit 5
CPMUIRCTRIM_IRCTRIM6: equ    6                                       ; IRC1M Frequency Trim Bit 6
CPMUIRCTRIM_IRCTRIM7: equ    7                                       ; IRC1M Frequency Trim Bit 7
CPMUIRCTRIM_IRCTRIM8: equ    8                                       ; IRC1M Frequency Trim Bit 8
CPMUIRCTRIM_IRCTRIM9: equ    9                                       ; IRC1M Frequency Trim Bit 9
CPMUIRCTRIM_TCTRIM0: equ    12                                       ; IRC1M temperature coeficient Trim Bit 0
CPMUIRCTRIM_TCTRIM1: equ    13                                       ; IRC1M temperature coeficient Trim Bit 1
CPMUIRCTRIM_TCTRIM2: equ    14                                       ; IRC1M temperature coeficient Trim Bit 2
CPMUIRCTRIM_TCTRIM3: equ    15                                       ; IRC1M temperature coeficient Trim Bit 3
; bit position masks
mCPMUIRCTRIM_IRCTRIM0: equ    %00000001
mCPMUIRCTRIM_IRCTRIM1: equ    %00000010
mCPMUIRCTRIM_IRCTRIM2: equ    %00000100
mCPMUIRCTRIM_IRCTRIM3: equ    %00001000
mCPMUIRCTRIM_IRCTRIM4: equ    %00010000
mCPMUIRCTRIM_IRCTRIM5: equ    %00100000
mCPMUIRCTRIM_IRCTRIM6: equ    %01000000
mCPMUIRCTRIM_IRCTRIM7: equ    %10000000
mCPMUIRCTRIM_IRCTRIM8: equ    %100000000
mCPMUIRCTRIM_IRCTRIM9: equ    %1000000000
mCPMUIRCTRIM_TCTRIM0: equ    %1000000000000
mCPMUIRCTRIM_TCTRIM1: equ    %10000000000000
mCPMUIRCTRIM_TCTRIM2: equ    %100000000000000
mCPMUIRCTRIM_TCTRIM3: equ    %1000000000000000


;*** CPMUIRCTRIMH - S12CPMU IRC1M Trim Registers High; 0x000001F8 ***
CPMUIRCTRIMH:       equ    $000001F8                                ;*** CPMUIRCTRIMH - S12CPMU IRC1M Trim Registers High; 0x000001F8 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CPMUIRCTRIMH_IRCTRIM8: equ    0                                      ; IRC1M Frequency Trim Bit 8
CPMUIRCTRIMH_IRCTRIM9: equ    1                                      ; IRC1M Frequency Trim Bit 9
CPMUIRCTRIMH_TCTRIM0: equ    4                                       ; IRC1M temperature coeficient Trim Bit 0
CPMUIRCTRIMH_TCTRIM1: equ    5                                       ; IRC1M temperature coeficient Trim Bit 1
CPMUIRCTRIMH_TCTRIM2: equ    6                                       ; IRC1M temperature coeficient Trim Bit 2
CPMUIRCTRIMH_TCTRIM3: equ    7                                       ; IRC1M temperature coeficient Trim Bit 3
; bit position masks
mCPMUIRCTRIMH_IRCTRIM8: equ    %00000001
mCPMUIRCTRIMH_IRCTRIM9: equ    %00000010
mCPMUIRCTRIMH_TCTRIM0: equ    %00010000
mCPMUIRCTRIMH_TCTRIM1: equ    %00100000
mCPMUIRCTRIMH_TCTRIM2: equ    %01000000
mCPMUIRCTRIMH_TCTRIM3: equ    %10000000


;*** CPMUIRCTRIML - S12CPMU IRC1M Trim Registers Low; 0x000001F9 ***
CPMUIRCTRIML:       equ    $000001F9                                ;*** CPMUIRCTRIML - S12CPMU IRC1M Trim Registers Low; 0x000001F9 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CPMUIRCTRIML_IRCTRIM0: equ    0                                      ; IRC1M Frequency Trim Bit 0
CPMUIRCTRIML_IRCTRIM1: equ    1                                      ; IRC1M Frequency Trim Bit 1
CPMUIRCTRIML_IRCTRIM2: equ    2                                      ; IRC1M Frequency Trim Bit 2
CPMUIRCTRIML_IRCTRIM3: equ    3                                      ; IRC1M Frequency Trim Bit 3
CPMUIRCTRIML_IRCTRIM4: equ    4                                      ; IRC1M Frequency Trim Bit 4
CPMUIRCTRIML_IRCTRIM5: equ    5                                      ; IRC1M Frequency Trim Bit 5
CPMUIRCTRIML_IRCTRIM6: equ    6                                      ; IRC1M Frequency Trim Bit 6
CPMUIRCTRIML_IRCTRIM7: equ    7                                      ; IRC1M Frequency Trim Bit 7
; bit position masks
mCPMUIRCTRIML_IRCTRIM0: equ    %00000001
mCPMUIRCTRIML_IRCTRIM1: equ    %00000010
mCPMUIRCTRIML_IRCTRIM2: equ    %00000100
mCPMUIRCTRIML_IRCTRIM3: equ    %00001000
mCPMUIRCTRIML_IRCTRIM4: equ    %00010000
mCPMUIRCTRIML_IRCTRIM5: equ    %00100000
mCPMUIRCTRIML_IRCTRIM6: equ    %01000000
mCPMUIRCTRIML_IRCTRIM7: equ    %10000000


;*** CPMUOSC - S12CPMU Oscillator Register; 0x000001FA ***
CPMUOSC:            equ    $000001FA                                ;*** CPMUOSC - S12CPMU Oscillator Register; 0x000001FA ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CPMUOSC_OSCFILT0:   equ    0                                         ; Oscillator Filter Bits, bit 0
CPMUOSC_OSCFILT1:   equ    1                                         ; Oscillator Filter Bits, bit 1
CPMUOSC_OSCFILT2:   equ    2                                         ; Oscillator Filter Bits, bit 2
CPMUOSC_OSCFILT3:   equ    3                                         ; Oscillator Filter Bits, bit 3
CPMUOSC_OSCFILT4:   equ    4                                         ; Oscillator Filter Bits, bit 4
CPMUOSC_OSCPINS_EN: equ    5                                         ; Oscillator Pins EXTAL and XTAL Enable Bit
CPMUOSC_OSCBW:      equ    6                                         ; Oscillator Filter Bandwidth Bit
CPMUOSC_OSCE:       equ    7                                         ; Oscillator Enable Bit
; bit position masks
mCPMUOSC_OSCFILT0:  equ    %00000001
mCPMUOSC_OSCFILT1:  equ    %00000010
mCPMUOSC_OSCFILT2:  equ    %00000100
mCPMUOSC_OSCFILT3:  equ    %00001000
mCPMUOSC_OSCFILT4:  equ    %00010000
mCPMUOSC_OSCPINS_EN: equ    %00100000
mCPMUOSC_OSCBW:     equ    %01000000
mCPMUOSC_OSCE:      equ    %10000000


;*** CPMUPROT - S12CPMUV1 Protection Register; 0x000001FB ***
CPMUPROT:           equ    $000001FB                                ;*** CPMUPROT - S12CPMUV1 Protection Register; 0x000001FB ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CPMUPROT_PROT:      equ    0                                         ; Clock Configuration Registers Protection Bit
; bit position masks
mCPMUPROT_PROT:     equ    %00000001


;*** BAKEY0 - Backdoor Comparison Key 0; 0x0000FF00 ***
BAKEY0:             equ    $0000FF00                                ;*** BAKEY0 - Backdoor Comparison Key 0; 0x0000FF00 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
BAKEY0_KEY0:        equ    0                                         ; Backdoor Comparison Key Bits, bit 0
BAKEY0_KEY1:        equ    1                                         ; Backdoor Comparison Key Bits, bit 1
BAKEY0_KEY2:        equ    2                                         ; Backdoor Comparison Key Bits, bit 2
BAKEY0_KEY3:        equ    3                                         ; Backdoor Comparison Key Bits, bit 3
BAKEY0_KEY4:        equ    4                                         ; Backdoor Comparison Key Bits, bit 4
BAKEY0_KEY5:        equ    5                                         ; Backdoor Comparison Key Bits, bit 5
BAKEY0_KEY6:        equ    6                                         ; Backdoor Comparison Key Bits, bit 6
BAKEY0_KEY7:        equ    7                                         ; Backdoor Comparison Key Bits, bit 7
BAKEY0_KEY8:        equ    8                                         ; Backdoor Comparison Key Bits, bit 8
BAKEY0_KEY9:        equ    9                                         ; Backdoor Comparison Key Bits, bit 9
BAKEY0_KEY10:       equ    10                                        ; Backdoor Comparison Key Bits, bit 10
BAKEY0_KEY11:       equ    11                                        ; Backdoor Comparison Key Bits, bit 11
BAKEY0_KEY12:       equ    12                                        ; Backdoor Comparison Key Bits, bit 12
BAKEY0_KEY13:       equ    13                                        ; Backdoor Comparison Key Bits, bit 13
BAKEY0_KEY14:       equ    14                                        ; Backdoor Comparison Key Bits, bit 14
BAKEY0_KEY15:       equ    15                                        ; Backdoor Comparison Key Bits, bit 15
; bit position masks
mBAKEY0_KEY0:       equ    %00000001
mBAKEY0_KEY1:       equ    %00000010
mBAKEY0_KEY2:       equ    %00000100
mBAKEY0_KEY3:       equ    %00001000
mBAKEY0_KEY4:       equ    %00010000
mBAKEY0_KEY5:       equ    %00100000
mBAKEY0_KEY6:       equ    %01000000
mBAKEY0_KEY7:       equ    %10000000
mBAKEY0_KEY8:       equ    %100000000
mBAKEY0_KEY9:       equ    %1000000000
mBAKEY0_KEY10:      equ    %10000000000
mBAKEY0_KEY11:      equ    %100000000000
mBAKEY0_KEY12:      equ    %1000000000000
mBAKEY0_KEY13:      equ    %10000000000000
mBAKEY0_KEY14:      equ    %100000000000000
mBAKEY0_KEY15:      equ    %1000000000000000


;*** BAKEY1 - Backdoor Comparison Key 1; 0x0000FF02 ***
BAKEY1:             equ    $0000FF02                                ;*** BAKEY1 - Backdoor Comparison Key 1; 0x0000FF02 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
BAKEY1_KEY0:        equ    0                                         ; Backdoor Comparison Key Bits, bit 0
BAKEY1_KEY1:        equ    1                                         ; Backdoor Comparison Key Bits, bit 1
BAKEY1_KEY2:        equ    2                                         ; Backdoor Comparison Key Bits, bit 2
BAKEY1_KEY3:        equ    3                                         ; Backdoor Comparison Key Bits, bit 3
BAKEY1_KEY4:        equ    4                                         ; Backdoor Comparison Key Bits, bit 4
BAKEY1_KEY5:        equ    5                                         ; Backdoor Comparison Key Bits, bit 5
BAKEY1_KEY6:        equ    6                                         ; Backdoor Comparison Key Bits, bit 6
BAKEY1_KEY7:        equ    7                                         ; Backdoor Comparison Key Bits, bit 7
BAKEY1_KEY8:        equ    8                                         ; Backdoor Comparison Key Bits, bit 8
BAKEY1_KEY9:        equ    9                                         ; Backdoor Comparison Key Bits, bit 9
BAKEY1_KEY10:       equ    10                                        ; Backdoor Comparison Key Bits, bit 10
BAKEY1_KEY11:       equ    11                                        ; Backdoor Comparison Key Bits, bit 11
BAKEY1_KEY12:       equ    12                                        ; Backdoor Comparison Key Bits, bit 12
BAKEY1_KEY13:       equ    13                                        ; Backdoor Comparison Key Bits, bit 13
BAKEY1_KEY14:       equ    14                                        ; Backdoor Comparison Key Bits, bit 14
BAKEY1_KEY15:       equ    15                                        ; Backdoor Comparison Key Bits, bit 15
; bit position masks
mBAKEY1_KEY0:       equ    %00000001
mBAKEY1_KEY1:       equ    %00000010
mBAKEY1_KEY2:       equ    %00000100
mBAKEY1_KEY3:       equ    %00001000
mBAKEY1_KEY4:       equ    %00010000
mBAKEY1_KEY5:       equ    %00100000
mBAKEY1_KEY6:       equ    %01000000
mBAKEY1_KEY7:       equ    %10000000
mBAKEY1_KEY8:       equ    %100000000
mBAKEY1_KEY9:       equ    %1000000000
mBAKEY1_KEY10:      equ    %10000000000
mBAKEY1_KEY11:      equ    %100000000000
mBAKEY1_KEY12:      equ    %1000000000000
mBAKEY1_KEY13:      equ    %10000000000000
mBAKEY1_KEY14:      equ    %100000000000000
mBAKEY1_KEY15:      equ    %1000000000000000


;*** BAKEY2 - Backdoor Comparison Key 2; 0x0000FF04 ***
BAKEY2:             equ    $0000FF04                                ;*** BAKEY2 - Backdoor Comparison Key 2; 0x0000FF04 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
BAKEY2_KEY0:        equ    0                                         ; Backdoor Comparison Key Bits, bit 0
BAKEY2_KEY1:        equ    1                                         ; Backdoor Comparison Key Bits, bit 1
BAKEY2_KEY2:        equ    2                                         ; Backdoor Comparison Key Bits, bit 2
BAKEY2_KEY3:        equ    3                                         ; Backdoor Comparison Key Bits, bit 3
BAKEY2_KEY4:        equ    4                                         ; Backdoor Comparison Key Bits, bit 4
BAKEY2_KEY5:        equ    5                                         ; Backdoor Comparison Key Bits, bit 5
BAKEY2_KEY6:        equ    6                                         ; Backdoor Comparison Key Bits, bit 6
BAKEY2_KEY7:        equ    7                                         ; Backdoor Comparison Key Bits, bit 7
BAKEY2_KEY8:        equ    8                                         ; Backdoor Comparison Key Bits, bit 8
BAKEY2_KEY9:        equ    9                                         ; Backdoor Comparison Key Bits, bit 9
BAKEY2_KEY10:       equ    10                                        ; Backdoor Comparison Key Bits, bit 10
BAKEY2_KEY11:       equ    11                                        ; Backdoor Comparison Key Bits, bit 11
BAKEY2_KEY12:       equ    12                                        ; Backdoor Comparison Key Bits, bit 12
BAKEY2_KEY13:       equ    13                                        ; Backdoor Comparison Key Bits, bit 13
BAKEY2_KEY14:       equ    14                                        ; Backdoor Comparison Key Bits, bit 14
BAKEY2_KEY15:       equ    15                                        ; Backdoor Comparison Key Bits, bit 15
; bit position masks
mBAKEY2_KEY0:       equ    %00000001
mBAKEY2_KEY1:       equ    %00000010
mBAKEY2_KEY2:       equ    %00000100
mBAKEY2_KEY3:       equ    %00001000
mBAKEY2_KEY4:       equ    %00010000
mBAKEY2_KEY5:       equ    %00100000
mBAKEY2_KEY6:       equ    %01000000
mBAKEY2_KEY7:       equ    %10000000
mBAKEY2_KEY8:       equ    %100000000
mBAKEY2_KEY9:       equ    %1000000000
mBAKEY2_KEY10:      equ    %10000000000
mBAKEY2_KEY11:      equ    %100000000000
mBAKEY2_KEY12:      equ    %1000000000000
mBAKEY2_KEY13:      equ    %10000000000000
mBAKEY2_KEY14:      equ    %100000000000000
mBAKEY2_KEY15:      equ    %1000000000000000


;*** BAKEY3 - Backdoor Comparison Key 3; 0x0000FF06 ***
BAKEY3:             equ    $0000FF06                                ;*** BAKEY3 - Backdoor Comparison Key 3; 0x0000FF06 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
BAKEY3_KEY0:        equ    0                                         ; Backdoor Comparison Key Bits, bit 0
BAKEY3_KEY1:        equ    1                                         ; Backdoor Comparison Key Bits, bit 1
BAKEY3_KEY2:        equ    2                                         ; Backdoor Comparison Key Bits, bit 2
BAKEY3_KEY3:        equ    3                                         ; Backdoor Comparison Key Bits, bit 3
BAKEY3_KEY4:        equ    4                                         ; Backdoor Comparison Key Bits, bit 4
BAKEY3_KEY5:        equ    5                                         ; Backdoor Comparison Key Bits, bit 5
BAKEY3_KEY6:        equ    6                                         ; Backdoor Comparison Key Bits, bit 6
BAKEY3_KEY7:        equ    7                                         ; Backdoor Comparison Key Bits, bit 7
BAKEY3_KEY8:        equ    8                                         ; Backdoor Comparison Key Bits, bit 8
BAKEY3_KEY9:        equ    9                                         ; Backdoor Comparison Key Bits, bit 9
BAKEY3_KEY10:       equ    10                                        ; Backdoor Comparison Key Bits, bit 10
BAKEY3_KEY11:       equ    11                                        ; Backdoor Comparison Key Bits, bit 11
BAKEY3_KEY12:       equ    12                                        ; Backdoor Comparison Key Bits, bit 12
BAKEY3_KEY13:       equ    13                                        ; Backdoor Comparison Key Bits, bit 13
BAKEY3_KEY14:       equ    14                                        ; Backdoor Comparison Key Bits, bit 14
BAKEY3_KEY15:       equ    15                                        ; Backdoor Comparison Key Bits, bit 15
; bit position masks
mBAKEY3_KEY0:       equ    %00000001
mBAKEY3_KEY1:       equ    %00000010
mBAKEY3_KEY2:       equ    %00000100
mBAKEY3_KEY3:       equ    %00001000
mBAKEY3_KEY4:       equ    %00010000
mBAKEY3_KEY5:       equ    %00100000
mBAKEY3_KEY6:       equ    %01000000
mBAKEY3_KEY7:       equ    %10000000
mBAKEY3_KEY8:       equ    %100000000
mBAKEY3_KEY9:       equ    %1000000000
mBAKEY3_KEY10:      equ    %10000000000
mBAKEY3_KEY11:      equ    %100000000000
mBAKEY3_KEY12:      equ    %1000000000000
mBAKEY3_KEY13:      equ    %10000000000000
mBAKEY3_KEY14:      equ    %100000000000000
mBAKEY3_KEY15:      equ    %1000000000000000


;*** NVFPROT - Non Volatile P-Flash Protection Register; 0x0000FF0C ***
NVFPROT:            equ    $0000FF0C                                ;*** NVFPROT - Non Volatile P-Flash Protection Register; 0x0000FF0C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NVFPROT_FPLS0:      equ    0                                         ; Flash Protection Lower Address Size Bit 0
NVFPROT_FPLS1:      equ    1                                         ; Flash Protection Lower Address Size Bit 1
NVFPROT_FPLDIS:     equ    2                                         ; Flash Protection Lower Address Range Disable
NVFPROT_FPHS0:      equ    3                                         ; Flash Protection Higher Address Size Bit 0
NVFPROT_FPHS1:      equ    4                                         ; Flash Protection Higher Address Size Bit 1
NVFPROT_FPHDIS:     equ    5                                         ; Flash Protection Higher Address Range Disable
NVFPROT_RNV6:       equ    6                                         ; Reserved Nonvolatile Bit
NVFPROT_FPOPEN:     equ    7                                         ; Flash Protection Operation Enable
; bit position masks
mNVFPROT_FPLS0:     equ    %00000001
mNVFPROT_FPLS1:     equ    %00000010
mNVFPROT_FPLDIS:    equ    %00000100
mNVFPROT_FPHS0:     equ    %00001000
mNVFPROT_FPHS1:     equ    %00010000
mNVFPROT_FPHDIS:    equ    %00100000
mNVFPROT_RNV6:      equ    %01000000
mNVFPROT_FPOPEN:    equ    %10000000


;*** NVDFPROT - Non Volatile D-Flash Protection Register; 0x0000FF0D ***
NVDFPROT:           equ    $0000FF0D                                ;*** NVDFPROT - Non Volatile D-Flash Protection Register; 0x0000FF0D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NVDFPROT_DPS0:      equ    0                                         ; D-Flash Protection Size Bit 0
NVDFPROT_DPS1:      equ    1                                         ; D-Flash Protection Size Bit 1
NVDFPROT_DPS2:      equ    2                                         ; D-Flash Protection Size Bit 2
NVDFPROT_DPS3:      equ    3                                         ; D-Flash Protection Size Bit 3
NVDFPROT_DPOPEN:    equ    7                                         ; D-Flash Protection Control
; bit position masks
mNVDFPROT_DPS0:     equ    %00000001
mNVDFPROT_DPS1:     equ    %00000010
mNVDFPROT_DPS2:     equ    %00000100
mNVDFPROT_DPS3:     equ    %00001000
mNVDFPROT_DPOPEN:   equ    %10000000


;*** NVFOPT - Non Volatile Flash Option Register; 0x0000FF0E ***
NVFOPT:             equ    $0000FF0E                                ;*** NVFOPT - Non Volatile Flash Option Register; 0x0000FF0E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NVFOPT_NV0:         equ    0                                         ; Nonvolatile Bit 0
NVFOPT_NV1:         equ    1                                         ; Nonvolatile Bit 1
NVFOPT_NV2:         equ    2                                         ; Nonvolatile Bit 2
NVFOPT_NV3:         equ    3                                         ; Nonvolatile Bit 3
NVFOPT_NV4:         equ    4                                         ; Nonvolatile Bit 4
NVFOPT_NV5:         equ    5                                         ; Nonvolatile Bit 5
NVFOPT_NV6:         equ    6                                         ; Nonvolatile Bit 6
NVFOPT_NV7:         equ    7                                         ; Nonvolatile Bit 7
; bit position masks
mNVFOPT_NV0:        equ    %00000001
mNVFOPT_NV1:        equ    %00000010
mNVFOPT_NV2:        equ    %00000100
mNVFOPT_NV3:        equ    %00001000
mNVFOPT_NV4:        equ    %00010000
mNVFOPT_NV5:        equ    %00100000
mNVFOPT_NV6:        equ    %01000000
mNVFOPT_NV7:        equ    %10000000


;*** NVFSEC - Non Volatile Flash Security Register; 0x0000FF0F ***
NVFSEC:             equ    $0000FF0F                                ;*** NVFSEC - Non Volatile Flash Security Register; 0x0000FF0F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NVFSEC_SEC0:        equ    0                                         ; Flash Security Bit 0
NVFSEC_SEC1:        equ    1                                         ; Flash Security Bit 1
NVFSEC_RNV2:        equ    2                                         ; Reserved Nonvolatile Bit 2
NVFSEC_RNV3:        equ    3                                         ; Reserved Nonvolatile Bit 3
NVFSEC_RNV4:        equ    4                                         ; Reserved Nonvolatile Bit 4
NVFSEC_RNV5:        equ    5                                         ; Reserved Nonvolatile Bit 5
NVFSEC_KEYEN0:      equ    6                                         ; Backdoor Key Security Enable Bit 0
NVFSEC_KEYEN1:      equ    7                                         ; Backdoor Key Security Enable Bit 1
; bit position masks
mNVFSEC_SEC0:       equ    %00000001
mNVFSEC_SEC1:       equ    %00000010
mNVFSEC_RNV2:       equ    %00000100
mNVFSEC_RNV3:       equ    %00001000
mNVFSEC_RNV4:       equ    %00010000
mNVFSEC_RNV5:       equ    %00100000
mNVFSEC_KEYEN0:     equ    %01000000
mNVFSEC_KEYEN1:     equ    %10000000



;***********************************************
;**   D E P R E C I A T E D   S Y M B O L S   **
;***********************************************
        IFNDEF  __GENERATE_APPLICATION__                            ; not supported for absolute assembler
                    XREF    This_symb_has_been_depreciated
        ENDIF

; EOF
