; Based on CPU DB MC9S12HZ256_112, version 2.87.469 (RegistersPrg V2.28)

; ###################################################################
;     Filename  : mc9s12hz256.inc
;     Processor : MC9S12HZ256CAL
;     FileFormat: V2.28
;     DataSheet : MC9S12HZ256V2 Rev. 2.05 04/2008
;     Compiler  : CodeWarrior compiler
;     Date/Time : 2.7.2009, 8:40
;     Abstract  :
;         This header implements the mapping of I/O devices.
;
;     Copyright : 1997 - 2009 Freescale Semiconductor, Inc. All Rights Reserved.
;     
;     http      : www.freescale.com
;     mail      : support@freescale.com
;
;     CPU Registers Revisions:
;      - 18.07.2006, V2.87.407:
;              - Added register WOMP. REASON: Changes in data sheet (from rev 1.05 to rev 2.01)
;      - 12.09.2006, V2.87.429:
;              - Renamed interrupt vector Vtimpaaovf ==> Vtimpaovf. REASON: Bug-fix (#3741 in Issue Manager)
;      - 29.06.2009, V2.87.468:
;              - Added MCDCx_FAST registers for PWM operating in 7-bit(fast) resolution mode. REASON: Bug-fix (#3426 in Issue Manager).
;
;     File-Format-Revisions:
;      - 14.11.2005, V2.00 :
;               - Deprecated symbols added for backward compatibility (section at the end of this file)
;      - 15.11.2005, V2.01 :
;               - Fixed invalid instruction in macro __RESET_WATCHDOG for HCS12 family.
;      - 17.12.2005, V2.02 :
;               - Arrays (symbols xx_ARR) are defined as pointer to volatile, see issue #2778
;      - 16.01.2006, V2.03 :
;               - Fixed declaration of non volatile registers. Now it does not require (but allows) their initialization, see issue #2920.
;               - "volatile" modifier removed from declaration of non volatile registers (that contain modifier "const")
;      - 08.03.2006, V2.04 :
;               - Support for bit(s) names duplicated with any register name in .h header files
;      - 24.03.2006, V2.05 :
;               - Fixed macro __RESET_WATCHDOG for HCS12 family - address and correct write order.
;      - 26.04.2006, V2.06 :
;               - Changes have not affected this file (because they are related to another family)
;      - 27.04.2006, V2.07 :
;               - Fixed macro __RESET_WATCHDOG for HCS12, HCS12X ,HCS08 DZ and HCS08 EN derivatives (write 0x55,0xAA).
;      - 07.06.2006, V2.08 :
;               - Changes have not affected this file (because they are related to another family)
;      - 03.07.2006, V2.09 :
;               - Changes have not affected this file (because they are related to another family)
;      - 27.10.2006, V2.10 :
;               - __RESET_WATCHDOG improved formating and re-definition
;      - 23.11.2006, V2.11 :
;               - Changes have not affected this file (because they are related to another family)
;      - 22.01.2007, V2.12 :
;               - Fixed declaration of non volatile registers. Now it does not require (but allows) their initialization, see issue #4086.
;      - 01.03.2007, V2.13 :
;               - Flash commands constants values converted to HEX format
;      - 02.03.2007, V2.14 :
;               - Interrupt vector numbers added into .H, see VectorNumber_*
;      - 26.03.2007, V2.15 :
;               - Changes have not affected this file (because they are related to another family)
;      - 10.05.2007, V2.16 :
;               - Changes have not affected this file (because they are related to another family)
;      - 05.06.2007, V2.17 :
;               - Changes have not affected this file (because they are related to another family)
;      - 19.07.2007, V2.18 :
;               - Improved number of blanked lines inside register structures
;      - 06.08.2007, V2.19 :
;               - CPUDB revisions generated ahead of the file-format revisions.
;      - 11.09.2007, V2.20 :
;               - Added comment about initialization of unbonded pins.
;      - 02.01.2008, V2.21 :
;               - Changes have not affected this file (because they are related to another family)
;      - 13.02.2008, V2.22 :
;               - Changes have not affected this file (because they are related to another family)
;      - 20.02.2008, V2.23 :
;               - Termination of pragma V30toV31Compatible added, #5708
;      - 03.07.2008, V2.24 :
;               - Added support for bits with name starting with number (like "1HZ")
;      - 28.11.2008, V2.25 :
;               - StandBy RAM array declaration for ANSI-C added
;      - 1.12.2008, V2.26 :
;               - Duplication of bit (or bit-group) name with register name is not marked as a problem, is register is internal only and it is not displayed in I/O map.
;      - 17.3.2009, V2.27 :
;               - Merged bit-group is not generated, if the name matches with another bit name in the register
;      - 6.4.2009, V2.28 :
;               - Fixed generation of merged bits for bit-groups with a digit at the end, if group-name is defined in CPUDB
;
;     Not all general-purpose I/O pins are available on all packages or on all mask sets of a specific
;     derivative device. To avoid extra current drain from floating input pins, the users reset
;     initialization routine in the application program must either enable on-chip pull-up devices
;     or change the direction of unconnected pins to outputs so the pins do not float.
; ###################################################################

;*** Memory Map and Interrupt Vectors
;******************************************
EEPROMStart:        equ   $00000400
EEPROMEnd:          equ   $000007EF
RAMStart:           equ   $00001000
RAMEnd:             equ   $00003FFF
ROM_4000Start:      equ   $00004000
ROM_4000End:        equ   $00007FFF
ROM_C000Start:      equ   $0000C000
ROM_C000End:        equ   $0000FEFF
PAGE_30Start:       equ   $00308000
PAGE_30End:         equ   $0030BFFF
PAGE_31Start:       equ   $00318000
PAGE_31End:         equ   $0031BFFF
PAGE_32Start:       equ   $00328000
PAGE_32End:         equ   $0032BFFF
PAGE_33Start:       equ   $00338000
PAGE_33End:         equ   $0033BFFF
PAGE_34Start:       equ   $00348000
PAGE_34End:         equ   $0034BFFF
PAGE_35Start:       equ   $00358000
PAGE_35End:         equ   $0035BFFF
PAGE_36Start:       equ   $00368000
PAGE_36End:         equ   $0036BFFF
PAGE_37Start:       equ   $00378000
PAGE_37End:         equ   $0037BFFF
PAGE_38Start:       equ   $00388000
PAGE_38End:         equ   $0038BFFF
PAGE_39Start:       equ   $00398000
PAGE_39End:         equ   $0039BFFF
PAGE_3AStart:       equ   $003A8000
PAGE_3AEnd:         equ   $003ABFFF
PAGE_3BStart:       equ   $003B8000
PAGE_3BEnd:         equ   $003BBFFF
PAGE_3CStart:       equ   $003C8000
PAGE_3CEnd:         equ   $003CBFFF
PAGE_3DStart:       equ   $003D8000
PAGE_3DEnd:         equ   $003DBFFF
;
VReserved63:        equ   $0000FF80
VReserved62:        equ   $0000FF82
VReserved61:        equ   $0000FF84
VReserved60:        equ   $0000FF86
VReserved59:        equ   $0000FF88
Vvreglvi:           equ   $0000FF8A
Vpwmesdn:           equ   $0000FF8C
VReserved56:        equ   $0000FF8E
VReserved55:        equ   $0000FF90
VReserved54:        equ   $0000FF92
VReserved53:        equ   $0000FF94
Vmctimovf:          equ   $0000FF96
VReserved51:        equ   $0000FF98
Vssd3:              equ   $0000FF9A
Vssd2:              equ   $0000FF9C
Vssd1:              equ   $0000FF9E
Vssd0:              equ   $0000FFA0
VReserved46:        equ   $0000FFA2
VReserved45:        equ   $0000FFA4
VReserved44:        equ   $0000FFA6
Vcan1tx:            equ   $0000FFA8
Vcan1rx:            equ   $0000FFAA
Vcan1err:           equ   $0000FFAC
Vcan1wkup:          equ   $0000FFAE
Vcan0tx:            equ   $0000FFB0
Vcan0rx:            equ   $0000FFB2
Vcan0err:           equ   $0000FFB4
Vcan0wkup:          equ   $0000FFB6
Vflash:             equ   $0000FFB8
Veeprom:            equ   $0000FFBA
VReserved33:        equ   $0000FFBC
VReserved32:        equ   $0000FFBE
Viic:               equ   $0000FFC0
VReserved30:        equ   $0000FFC2
Vcrgscm:            equ   $0000FFC4
Vcrgplllck:         equ   $0000FFC6
Vportad:            equ   $0000FFC8
VReserved26:        equ   $0000FFCA
VReserved25:        equ   $0000FFCC
VReserved24:        equ   $0000FFCE
VReserved23:        equ   $0000FFD0
Vatd:               equ   $0000FFD2
Vsci1:              equ   $0000FFD4
Vsci0:              equ   $0000FFD6
Vspi:               equ   $0000FFD8
Vtimpaie:           equ   $0000FFDA
Vtimpaovf:          equ   $0000FFDC
Vtimovf:            equ   $0000FFDE
Vtimch7:            equ   $0000FFE0
Vtimch6:            equ   $0000FFE2
Vtimch5:            equ   $0000FFE4
Vtimch4:            equ   $0000FFE6
Vtimch3:            equ   $0000FFE8
Vtimch2:            equ   $0000FFEA
Vtimch1:            equ   $0000FFEC
Vtimch0:            equ   $0000FFEE
Vrti:               equ   $0000FFF0
Virq:               equ   $0000FFF2
Vxirq:              equ   $0000FFF4
Vswi:               equ   $0000FFF6
Vtrap:              equ   $0000FFF8
Vcop:               equ   $0000FFFA
Vclkmon:            equ   $0000FFFC
Vreset:             equ   $0000FFFE
;


;*** PORTAB - Port AB Register; 0x00000000 ***
PORTAB:             equ    $00000000                                ;*** PORTAB - Port AB Register; 0x00000000 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PORTAB_BIT0:        equ    0                                         ; Port AB Bit 0
PORTAB_BIT1:        equ    1                                         ; Port AB Bit 1
PORTAB_BIT2:        equ    2                                         ; Port AB Bit 2
PORTAB_BIT3:        equ    3                                         ; Port AB Bit 3
PORTAB_BIT4:        equ    4                                         ; Port AB Bit 4
PORTAB_BIT5:        equ    5                                         ; Port AB Bit 5
PORTAB_BIT6:        equ    6                                         ; Port AB Bit 6
PORTAB_BIT7:        equ    7                                         ; Port AB Bit 7
PORTAB_BIT8:        equ    8                                         ; Port AB Bit 8
PORTAB_BIT9:        equ    9                                         ; Port AB Bit 9
PORTAB_BIT10:       equ    10                                        ; Port AB Bit 10
PORTAB_BIT11:       equ    11                                        ; Port AB Bit 11
PORTAB_BIT12:       equ    12                                        ; Port AB Bit 12
PORTAB_BIT13:       equ    13                                        ; Port AB Bit 13
PORTAB_BIT14:       equ    14                                        ; Port AB Bit 14
PORTAB_BIT15:       equ    15                                        ; Port AB Bit 15
; bit position masks
mPORTAB_BIT0:       equ    %00000001
mPORTAB_BIT1:       equ    %00000010
mPORTAB_BIT2:       equ    %00000100
mPORTAB_BIT3:       equ    %00001000
mPORTAB_BIT4:       equ    %00010000
mPORTAB_BIT5:       equ    %00100000
mPORTAB_BIT6:       equ    %01000000
mPORTAB_BIT7:       equ    %10000000
mPORTAB_BIT8:       equ    %100000000
mPORTAB_BIT9:       equ    %1000000000
mPORTAB_BIT10:      equ    %10000000000
mPORTAB_BIT11:      equ    %100000000000
mPORTAB_BIT12:      equ    %1000000000000
mPORTAB_BIT13:      equ    %10000000000000
mPORTAB_BIT14:      equ    %100000000000000
mPORTAB_BIT15:      equ    %1000000000000000


;*** PORTA - Port A Register; 0x00000000 ***
PORTA:              equ    $00000000                                ;*** PORTA - Port A Register; 0x00000000 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PORTA_BIT0:         equ    0                                         ; Port A Bit 0
PORTA_BIT1:         equ    1                                         ; Port A Bit 1
PORTA_BIT2:         equ    2                                         ; Port A Bit 2
PORTA_BIT3:         equ    3                                         ; Port A Bit 3
PORTA_BIT4:         equ    4                                         ; Port A Bit 4
PORTA_BIT5:         equ    5                                         ; Port A Bit 5
PORTA_BIT6:         equ    6                                         ; Port A Bit 6
PORTA_BIT7:         equ    7                                         ; Port A Bit 7
; bit position masks
mPORTA_BIT0:        equ    %00000001
mPORTA_BIT1:        equ    %00000010
mPORTA_BIT2:        equ    %00000100
mPORTA_BIT3:        equ    %00001000
mPORTA_BIT4:        equ    %00010000
mPORTA_BIT5:        equ    %00100000
mPORTA_BIT6:        equ    %01000000
mPORTA_BIT7:        equ    %10000000


;*** PORTB - Port B Register; 0x00000001 ***
PORTB:              equ    $00000001                                ;*** PORTB - Port B Register; 0x00000001 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PORTB_BIT0:         equ    0                                         ; Port B Bit 0
PORTB_BIT1:         equ    1                                         ; Port B Bit 1
PORTB_BIT2:         equ    2                                         ; Port B Bit 2
PORTB_BIT3:         equ    3                                         ; Port B Bit 3
PORTB_BIT4:         equ    4                                         ; Port B Bit 4
PORTB_BIT5:         equ    5                                         ; Port B Bit 5
PORTB_BIT6:         equ    6                                         ; Port B Bit 6
PORTB_BIT7:         equ    7                                         ; Port B Bit 7
; bit position masks
mPORTB_BIT0:        equ    %00000001
mPORTB_BIT1:        equ    %00000010
mPORTB_BIT2:        equ    %00000100
mPORTB_BIT3:        equ    %00001000
mPORTB_BIT4:        equ    %00010000
mPORTB_BIT5:        equ    %00100000
mPORTB_BIT6:        equ    %01000000
mPORTB_BIT7:        equ    %10000000


;*** DDRAB - Port AB Data Direction Register; 0x00000002 ***
DDRAB:              equ    $00000002                                ;*** DDRAB - Port AB Data Direction Register; 0x00000002 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRAB_BIT0:         equ    0                                         ; Data Direction Port AB Bit 0
DDRAB_BIT1:         equ    1                                         ; Data Direction Port AB Bit 1
DDRAB_BIT2:         equ    2                                         ; Data Direction Port AB Bit 2
DDRAB_BIT3:         equ    3                                         ; Data Direction Port AB Bit 3
DDRAB_BIT4:         equ    4                                         ; Data Direction Port AB Bit 4
DDRAB_BIT5:         equ    5                                         ; Data Direction Port AB Bit 5
DDRAB_BIT6:         equ    6                                         ; Data Direction Port AB Bit 6
DDRAB_BIT7:         equ    7                                         ; Data Direction Port AB Bit 7
DDRAB_BIT8:         equ    8                                         ; Data Direction Port AB Bit 8
DDRAB_BIT9:         equ    9                                         ; Data Direction Port AB Bit 9
DDRAB_BIT10:        equ    10                                        ; Data Direction Port AB Bit 10
DDRAB_BIT11:        equ    11                                        ; Data Direction Port AB Bit 11
DDRAB_BIT12:        equ    12                                        ; Data Direction Port AB Bit 12
DDRAB_BIT13:        equ    13                                        ; Data Direction Port AB Bit 13
DDRAB_BIT14:        equ    14                                        ; Data Direction Port AB Bit 14
DDRAB_BIT15:        equ    15                                        ; Data Direction Port AB Bit 15
; bit position masks
mDDRAB_BIT0:        equ    %00000001
mDDRAB_BIT1:        equ    %00000010
mDDRAB_BIT2:        equ    %00000100
mDDRAB_BIT3:        equ    %00001000
mDDRAB_BIT4:        equ    %00010000
mDDRAB_BIT5:        equ    %00100000
mDDRAB_BIT6:        equ    %01000000
mDDRAB_BIT7:        equ    %10000000
mDDRAB_BIT8:        equ    %100000000
mDDRAB_BIT9:        equ    %1000000000
mDDRAB_BIT10:       equ    %10000000000
mDDRAB_BIT11:       equ    %100000000000
mDDRAB_BIT12:       equ    %1000000000000
mDDRAB_BIT13:       equ    %10000000000000
mDDRAB_BIT14:       equ    %100000000000000
mDDRAB_BIT15:       equ    %1000000000000000


;*** DDRA - Port A Data Direction Register; 0x00000002 ***
DDRA:               equ    $00000002                                ;*** DDRA - Port A Data Direction Register; 0x00000002 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRA_BIT0:          equ    0                                         ; Data Direction Port A Bit 0
DDRA_BIT1:          equ    1                                         ; Data Direction Port A Bit 1
DDRA_BIT2:          equ    2                                         ; Data Direction Port A Bit 2
DDRA_BIT3:          equ    3                                         ; Data Direction Port A Bit 3
DDRA_BIT4:          equ    4                                         ; Data Direction Port A Bit 4
DDRA_BIT5:          equ    5                                         ; Data Direction Port A Bit 5
DDRA_BIT6:          equ    6                                         ; Data Direction Port A Bit 6
DDRA_BIT7:          equ    7                                         ; Data Direction Port A Bit 7
; bit position masks
mDDRA_BIT0:         equ    %00000001
mDDRA_BIT1:         equ    %00000010
mDDRA_BIT2:         equ    %00000100
mDDRA_BIT3:         equ    %00001000
mDDRA_BIT4:         equ    %00010000
mDDRA_BIT5:         equ    %00100000
mDDRA_BIT6:         equ    %01000000
mDDRA_BIT7:         equ    %10000000


;*** DDRB - Port B Data Direction Register; 0x00000003 ***
DDRB:               equ    $00000003                                ;*** DDRB - Port B Data Direction Register; 0x00000003 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRB_BIT0:          equ    0                                         ; Data Direction Port B Bit 0
DDRB_BIT1:          equ    1                                         ; Data Direction Port B Bit 1
DDRB_BIT2:          equ    2                                         ; Data Direction Port B Bit 2
DDRB_BIT3:          equ    3                                         ; Data Direction Port B Bit 3
DDRB_BIT4:          equ    4                                         ; Data Direction Port B Bit 4
DDRB_BIT5:          equ    5                                         ; Data Direction Port B Bit 5
DDRB_BIT6:          equ    6                                         ; Data Direction Port B Bit 6
DDRB_BIT7:          equ    7                                         ; Data Direction Port B Bit 7
; bit position masks
mDDRB_BIT0:         equ    %00000001
mDDRB_BIT1:         equ    %00000010
mDDRB_BIT2:         equ    %00000100
mDDRB_BIT3:         equ    %00001000
mDDRB_BIT4:         equ    %00010000
mDDRB_BIT5:         equ    %00100000
mDDRB_BIT6:         equ    %01000000
mDDRB_BIT7:         equ    %10000000


;*** PORTE - Port E Register; 0x00000008 ***
PORTE:              equ    $00000008                                ;*** PORTE - Port E Register; 0x00000008 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PORTE_BIT0:         equ    0                                         ; Port E Bit 0
PORTE_BIT1:         equ    1                                         ; Port E Bit 1
PORTE_BIT2:         equ    2                                         ; Port E Bit 2
PORTE_BIT3:         equ    3                                         ; Port E Bit 3
PORTE_BIT4:         equ    4                                         ; Port E Bit 4
PORTE_BIT5:         equ    5                                         ; Port E Bit 5
PORTE_BIT6:         equ    6                                         ; Port E Bit 6
PORTE_BIT7:         equ    7                                         ; Port E Bit 7
; bit position masks
mPORTE_BIT0:        equ    %00000001
mPORTE_BIT1:        equ    %00000010
mPORTE_BIT2:        equ    %00000100
mPORTE_BIT3:        equ    %00001000
mPORTE_BIT4:        equ    %00010000
mPORTE_BIT5:        equ    %00100000
mPORTE_BIT6:        equ    %01000000
mPORTE_BIT7:        equ    %10000000


;*** DDRE - Port E Data Direction Register; 0x00000009 ***
DDRE:               equ    $00000009                                ;*** DDRE - Port E Data Direction Register; 0x00000009 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRE_BIT2:          equ    2                                         ; Data Direction Port E Bit 2
DDRE_BIT3:          equ    3                                         ; Data Direction Port E Bit 3
DDRE_BIT4:          equ    4                                         ; Data Direction Port E Bit 4
DDRE_BIT5:          equ    5                                         ; Data Direction Port E Bit 5
DDRE_BIT6:          equ    6                                         ; Data Direction Port E Bit 6
DDRE_BIT7:          equ    7                                         ; Data Direction Port E Bit 7
; bit position masks
mDDRE_BIT2:         equ    %00000100
mDDRE_BIT3:         equ    %00001000
mDDRE_BIT4:         equ    %00010000
mDDRE_BIT5:         equ    %00100000
mDDRE_BIT6:         equ    %01000000
mDDRE_BIT7:         equ    %10000000


;*** PEAR - Port E Assignment Register; 0x0000000A ***
PEAR:               equ    $0000000A                                ;*** PEAR - Port E Assignment Register; 0x0000000A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PEAR_RDWE:          equ    2                                         ; Read / Write Enable
PEAR_LSTRE:         equ    3                                         ; Low Strobe (LSTRB) Enable
PEAR_NECLK:         equ    4                                         ; No External E Clock
PEAR_PIPOE:         equ    5                                         ; Pipe Status Signal Output Enable
PEAR_NOACCE:        equ    7                                         ; CPU No Access Output Enable
; bit position masks
mPEAR_RDWE:         equ    %00000100
mPEAR_LSTRE:        equ    %00001000
mPEAR_NECLK:        equ    %00010000
mPEAR_PIPOE:        equ    %00100000
mPEAR_NOACCE:       equ    %10000000


;*** MODE - Mode Register; 0x0000000B ***
MODE:               equ    $0000000B                                ;*** MODE - Mode Register; 0x0000000B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MODE_EME:           equ    0                                         ; Emulate Port E
MODE_EMK:           equ    1                                         ; Emulate Port K
MODE_IVIS:          equ    3                                         ; Internal Visibility
MODE_MODA:          equ    5                                         ; Mode Select Bit A
MODE_MODB:          equ    6                                         ; Mode Select Bit B
MODE_MODC:          equ    7                                         ; Mode Select Bit C
; bit position masks
mMODE_EME:          equ    %00000001
mMODE_EMK:          equ    %00000010
mMODE_IVIS:         equ    %00001000
mMODE_MODA:         equ    %00100000
mMODE_MODB:         equ    %01000000
mMODE_MODC:         equ    %10000000


;*** PUCR - Pull-Up Control Register; 0x0000000C ***
PUCR:               equ    $0000000C                                ;*** PUCR - Pull-Up Control Register; 0x0000000C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PUCR_PUPAE:         equ    0                                         ; Pull-Up Port A Enable
PUCR_PUPBE:         equ    1                                         ; Pull-Up Port B Enable
PUCR_PUPEE:         equ    4                                         ; Pull-Up Port E Enable
PUCR_PUPKE:         equ    7                                         ; Pull-Up Port K Enable
; bit position masks
mPUCR_PUPAE:        equ    %00000001
mPUCR_PUPBE:        equ    %00000010
mPUCR_PUPEE:        equ    %00010000
mPUCR_PUPKE:        equ    %10000000


;*** RDRIV - Reduced Drive of I/O Lines; 0x0000000D ***
RDRIV:              equ    $0000000D                                ;*** RDRIV - Reduced Drive of I/O Lines; 0x0000000D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RDRIV_RDPA:         equ    0                                         ; Reduced Drive of Port A
RDRIV_RDPB:         equ    1                                         ; Reduced Drive of Port B
RDRIV_RDPE:         equ    4                                         ; Reduced Drive of Port E
RDRIV_RDPK:         equ    7                                         ; Reduced Drive of Port K
; bit position masks
mRDRIV_RDPA:        equ    %00000001
mRDRIV_RDPB:        equ    %00000010
mRDRIV_RDPE:        equ    %00010000
mRDRIV_RDPK:        equ    %10000000


;*** EBICTL - External Bus Interface Control; 0x0000000E ***
EBICTL:             equ    $0000000E                                ;*** EBICTL - External Bus Interface Control; 0x0000000E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
EBICTL_ESTR:        equ    0                                         ; E Stretches
; bit position masks
mEBICTL_ESTR:       equ    %00000001


;*** INITRM - Initialization of Internal RAM Position Register; 0x00000010 ***
INITRM:             equ    $00000010                                ;*** INITRM - Initialization of Internal RAM Position Register; 0x00000010 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
INITRM_RAMHAL:      equ    0                                         ; Internal RAM map alignment
INITRM_RAM11:       equ    3                                         ; Internal RAM map position Bit 11
INITRM_RAM12:       equ    4                                         ; Internal RAM map position Bit 12
INITRM_RAM13:       equ    5                                         ; Internal RAM map position Bit 13
INITRM_RAM14:       equ    6                                         ; Internal RAM map position Bit 14
INITRM_RAM15:       equ    7                                         ; Internal RAM map position Bit 15
; bit position masks
mINITRM_RAMHAL:     equ    %00000001
mINITRM_RAM11:      equ    %00001000
mINITRM_RAM12:      equ    %00010000
mINITRM_RAM13:      equ    %00100000
mINITRM_RAM14:      equ    %01000000
mINITRM_RAM15:      equ    %10000000


;*** INITRG - Initialization of Internal Registers Position Register; 0x00000011 ***
INITRG:             equ    $00000011                                ;*** INITRG - Initialization of Internal Registers Position Register; 0x00000011 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
INITRG_REG11:       equ    3                                         ; Internal Registers Map Position Bit 11
INITRG_REG12:       equ    4                                         ; Internal Registers Map Position Bit 12
INITRG_REG13:       equ    5                                         ; Internal Registers Map Position Bit 13
INITRG_REG14:       equ    6                                         ; Internal Registers Map Position Bit 14
; bit position masks
mINITRG_REG11:      equ    %00001000
mINITRG_REG12:      equ    %00010000
mINITRG_REG13:      equ    %00100000
mINITRG_REG14:      equ    %01000000


;*** INITEE - Initialization of Internal EEPROM Position Register; 0x00000012 ***
INITEE:             equ    $00000012                                ;*** INITEE - Initialization of Internal EEPROM Position Register; 0x00000012 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
INITEE_EEON:        equ    0                                         ; Internal EEPROM On
INITEE_EE11:        equ    3                                         ; Internal EEPROM map position Bit 11
INITEE_EE12:        equ    4                                         ; Internal EEPROM map position Bit 12
INITEE_EE13:        equ    5                                         ; Internal EEPROM map position Bit 13
INITEE_EE14:        equ    6                                         ; Internal EEPROM map position Bit 14
INITEE_EE15:        equ    7                                         ; Internal EEPROM map position Bit 15
; bit position masks
mINITEE_EEON:       equ    %00000001
mINITEE_EE11:       equ    %00001000
mINITEE_EE12:       equ    %00010000
mINITEE_EE13:       equ    %00100000
mINITEE_EE14:       equ    %01000000
mINITEE_EE15:       equ    %10000000


;*** MISC - Miscellaneous System Control Register; 0x00000013 ***
MISC:               equ    $00000013                                ;*** MISC - Miscellaneous System Control Register; 0x00000013 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MISC_ROMON:         equ    0                                         ; Enable Flash EEPROM
MISC_ROMHM:         equ    1                                         ; Flash EEPROM only in second half of memory map
MISC_EXSTR0:        equ    2                                         ; External Access Stretch Bit 0
MISC_EXSTR1:        equ    3                                         ; External Access Stretch Bit 1
; bit position masks
mMISC_ROMON:        equ    %00000001
mMISC_ROMHM:        equ    %00000010
mMISC_EXSTR0:       equ    %00000100
mMISC_EXSTR1:       equ    %00001000


;*** ITCR - Interrupt Test Control Register; 0x00000015 ***
ITCR:               equ    $00000015                                ;*** ITCR - Interrupt Test Control Register; 0x00000015 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ITCR_ADR0:          equ    0                                         ; Test register select Bit 0
ITCR_ADR1:          equ    1                                         ; Test register select Bit 1
ITCR_ADR2:          equ    2                                         ; Test register select Bit 2
ITCR_ADR3:          equ    3                                         ; Test register select Bit 3
ITCR_WRTINT:        equ    4                                         ; Write to the Interrupt Test Registers
; bit position masks
mITCR_ADR0:         equ    %00000001
mITCR_ADR1:         equ    %00000010
mITCR_ADR2:         equ    %00000100
mITCR_ADR3:         equ    %00001000
mITCR_WRTINT:       equ    %00010000


;*** ITEST - Interrupt Test Register; 0x00000016 ***
ITEST:              equ    $00000016                                ;*** ITEST - Interrupt Test Register; 0x00000016 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ITEST_INT0:         equ    0                                         ; Interrupt Test Register Bit 0
ITEST_INT2:         equ    1                                         ; Interrupt Test Register Bit 1
ITEST_INT4:         equ    2                                         ; Interrupt Test Register Bit 2
ITEST_INT6:         equ    3                                         ; Interrupt Test Register Bit 3
ITEST_INT8:         equ    4                                         ; Interrupt Test Register Bit 4
ITEST_INTA:         equ    5                                         ; Interrupt Test Register Bit 5
ITEST_INTC:         equ    6                                         ; Interrupt Test Register Bit 6
ITEST_INTE:         equ    7                                         ; Interrupt Test Register Bit 7
; bit position masks
mITEST_INT0:        equ    %00000001
mITEST_INT2:        equ    %00000010
mITEST_INT4:        equ    %00000100
mITEST_INT6:        equ    %00001000
mITEST_INT8:        equ    %00010000
mITEST_INTA:        equ    %00100000
mITEST_INTC:        equ    %01000000
mITEST_INTE:        equ    %10000000


;*** VREGCTRL - VREG_3V3 - Control Register; 0x00000019 ***
VREGCTRL:           equ    $00000019                                ;*** VREGCTRL - VREG_3V3 - Control Register; 0x00000019 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
VREGCTRL_LVIF:      equ    0                                         ; Low Voltage Interrupt Flag
VREGCTRL_LVIE:      equ    1                                         ; Low Voltage Interrupt Enable Bit
VREGCTRL_LVDS:      equ    2                                         ; Low Voltage Detect Status Bit
; bit position masks
mVREGCTRL_LVIF:     equ    %00000001
mVREGCTRL_LVIE:     equ    %00000010
mVREGCTRL_LVDS:     equ    %00000100


;*** PARTID - Part ID Register; 0x0000001A ***
PARTID:             equ    $0000001A                                ;*** PARTID - Part ID Register; 0x0000001A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PARTID_ID0:         equ    0                                         ; Part ID Register Bit 0
PARTID_ID1:         equ    1                                         ; Part ID Register Bit 1
PARTID_ID2:         equ    2                                         ; Part ID Register Bit 2
PARTID_ID3:         equ    3                                         ; Part ID Register Bit 3
PARTID_ID4:         equ    4                                         ; Part ID Register Bit 4
PARTID_ID5:         equ    5                                         ; Part ID Register Bit 5
PARTID_ID6:         equ    6                                         ; Part ID Register Bit 6
PARTID_ID7:         equ    7                                         ; Part ID Register Bit 7
PARTID_ID8:         equ    8                                         ; Part ID Register Bit 8
PARTID_ID9:         equ    9                                         ; Part ID Register Bit 9
PARTID_ID10:        equ    10                                        ; Part ID Register Bit 10
PARTID_ID11:        equ    11                                        ; Part ID Register Bit 11
PARTID_ID12:        equ    12                                        ; Part ID Register Bit 12
PARTID_ID13:        equ    13                                        ; Part ID Register Bit 13
PARTID_ID14:        equ    14                                        ; Part ID Register Bit 14
PARTID_ID15:        equ    15                                        ; Part ID Register Bit 15
; bit position masks
mPARTID_ID0:        equ    %00000001
mPARTID_ID1:        equ    %00000010
mPARTID_ID2:        equ    %00000100
mPARTID_ID3:        equ    %00001000
mPARTID_ID4:        equ    %00010000
mPARTID_ID5:        equ    %00100000
mPARTID_ID6:        equ    %01000000
mPARTID_ID7:        equ    %10000000
mPARTID_ID8:        equ    %100000000
mPARTID_ID9:        equ    %1000000000
mPARTID_ID10:       equ    %10000000000
mPARTID_ID11:       equ    %100000000000
mPARTID_ID12:       equ    %1000000000000
mPARTID_ID13:       equ    %10000000000000
mPARTID_ID14:       equ    %100000000000000
mPARTID_ID15:       equ    %1000000000000000


;*** PARTIDH - Part ID Register High; 0x0000001A ***
PARTIDH:            equ    $0000001A                                ;*** PARTIDH - Part ID Register High; 0x0000001A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PARTIDH_ID8:        equ    0                                         ; Part ID Register Bit 8
PARTIDH_ID9:        equ    1                                         ; Part ID Register Bit 9
PARTIDH_ID10:       equ    2                                         ; Part ID Register Bit 10
PARTIDH_ID11:       equ    3                                         ; Part ID Register Bit 11
PARTIDH_ID12:       equ    4                                         ; Part ID Register Bit 12
PARTIDH_ID13:       equ    5                                         ; Part ID Register Bit 13
PARTIDH_ID14:       equ    6                                         ; Part ID Register Bit 14
PARTIDH_ID15:       equ    7                                         ; Part ID Register Bit 15
; bit position masks
mPARTIDH_ID8:       equ    %00000001
mPARTIDH_ID9:       equ    %00000010
mPARTIDH_ID10:      equ    %00000100
mPARTIDH_ID11:      equ    %00001000
mPARTIDH_ID12:      equ    %00010000
mPARTIDH_ID13:      equ    %00100000
mPARTIDH_ID14:      equ    %01000000
mPARTIDH_ID15:      equ    %10000000


;*** PARTIDL - Part ID Register Low; 0x0000001B ***
PARTIDL:            equ    $0000001B                                ;*** PARTIDL - Part ID Register Low; 0x0000001B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PARTIDL_ID0:        equ    0                                         ; Part ID Register Bit 0
PARTIDL_ID1:        equ    1                                         ; Part ID Register Bit 1
PARTIDL_ID2:        equ    2                                         ; Part ID Register Bit 2
PARTIDL_ID3:        equ    3                                         ; Part ID Register Bit 3
PARTIDL_ID4:        equ    4                                         ; Part ID Register Bit 4
PARTIDL_ID5:        equ    5                                         ; Part ID Register Bit 5
PARTIDL_ID6:        equ    6                                         ; Part ID Register Bit 6
PARTIDL_ID7:        equ    7                                         ; Part ID Register Bit 7
; bit position masks
mPARTIDL_ID0:       equ    %00000001
mPARTIDL_ID1:       equ    %00000010
mPARTIDL_ID2:       equ    %00000100
mPARTIDL_ID3:       equ    %00001000
mPARTIDL_ID4:       equ    %00010000
mPARTIDL_ID5:       equ    %00100000
mPARTIDL_ID6:       equ    %01000000
mPARTIDL_ID7:       equ    %10000000


;*** MEMSIZ0 - Memory Size Register Zero; 0x0000001C ***
MEMSIZ0:            equ    $0000001C                                ;*** MEMSIZ0 - Memory Size Register Zero; 0x0000001C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MEMSIZ0_ram_sw0:    equ    0                                         ; Allocated System RAM Memory Space Bit 0
MEMSIZ0_ram_sw1:    equ    1                                         ; Allocated System RAM Memory Space Bit 1
MEMSIZ0_ram_sw2:    equ    2                                         ; Allocated System RAM Memory Space Bit 2
MEMSIZ0_eep_sw0:    equ    4                                         ; Allocated EEPROM Memory Space Bit 0
MEMSIZ0_eep_sw1:    equ    5                                         ; Allocated EEPROM Memory Space Bit 1
MEMSIZ0_reg_sw0:    equ    7                                         ; Allocated System Register Space
; bit position masks
mMEMSIZ0_ram_sw0:   equ    %00000001
mMEMSIZ0_ram_sw1:   equ    %00000010
mMEMSIZ0_ram_sw2:   equ    %00000100
mMEMSIZ0_eep_sw0:   equ    %00010000
mMEMSIZ0_eep_sw1:   equ    %00100000
mMEMSIZ0_reg_sw0:   equ    %10000000


;*** MEMSIZ1 - Memory Size Register One; 0x0000001D ***
MEMSIZ1:            equ    $0000001D                                ;*** MEMSIZ1 - Memory Size Register One; 0x0000001D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MEMSIZ1_pag_sw0:    equ    0                                         ; Allocated Off-Chip Memory Options Bit 0
MEMSIZ1_pag_sw1:    equ    1                                         ; Allocated Off-Chip Memory Options Bit 1
MEMSIZ1_rom_sw0:    equ    6                                         ; Allocated Flash EEPROM/ROM Physical Memory Space Bit 0
MEMSIZ1_rom_sw1:    equ    7                                         ; Allocated Flash EEPROM/ROM Physical Memory Space Bit 1
; bit position masks
mMEMSIZ1_pag_sw0:   equ    %00000001
mMEMSIZ1_pag_sw1:   equ    %00000010
mMEMSIZ1_rom_sw0:   equ    %01000000
mMEMSIZ1_rom_sw1:   equ    %10000000


;*** INTCR - Interrupt Control Register; 0x0000001E ***
INTCR:              equ    $0000001E                                ;*** INTCR - Interrupt Control Register; 0x0000001E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
INTCR_IRQEN:        equ    6                                         ; External IRQ Enable
INTCR_IRQE:         equ    7                                         ; IRQ Select Edge Sensitive Only
; bit position masks
mINTCR_IRQEN:       equ    %01000000
mINTCR_IRQE:        equ    %10000000


;*** HPRIO - Highest Priority I Interrupt; 0x0000001F ***
HPRIO:              equ    $0000001F                                ;*** HPRIO - Highest Priority I Interrupt; 0x0000001F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
HPRIO_PSEL1:        equ    1                                         ; Highest Priority I Interrupt Bit 1
HPRIO_PSEL2:        equ    2                                         ; Highest Priority I Interrupt Bit 2
HPRIO_PSEL3:        equ    3                                         ; Highest Priority I Interrupt Bit 3
HPRIO_PSEL4:        equ    4                                         ; Highest Priority I Interrupt Bit 4
HPRIO_PSEL5:        equ    5                                         ; Highest Priority I Interrupt Bit 5
HPRIO_PSEL6:        equ    6                                         ; Highest Priority I Interrupt Bit 6
HPRIO_PSEL7:        equ    7                                         ; Highest Priority I Interrupt Bit 7
; bit position masks
mHPRIO_PSEL1:       equ    %00000010
mHPRIO_PSEL2:       equ    %00000100
mHPRIO_PSEL3:       equ    %00001000
mHPRIO_PSEL4:       equ    %00010000
mHPRIO_PSEL5:       equ    %00100000
mHPRIO_PSEL6:       equ    %01000000
mHPRIO_PSEL7:       equ    %10000000


;*** DBGC1 - Debug Control Register 1; 0x00000020 ***
DBGC1:              equ    $00000020                                ;*** DBGC1 - Debug Control Register 1; 0x00000020 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGC1_CAPMOD0:      equ    0                                         ; Capture Mode Field, bit 0
DBGC1_CAPMOD1:      equ    1                                         ; Capture Mode Field, bit 1
DBGC1_DBGBRK:       equ    3                                         ; DBG Breakpoint Enable Bit
DBGC1_BEGIN:        equ    4                                         ; Begin/End Trigger Bit
DBGC1_TRGSEL:       equ    5                                         ; Trigger Selection Bit
DBGC1_ARM:          equ    6                                         ; Arm Bit
DBGC1_DBGEN:        equ    7                                         ; DBG Mode Enable Bit
; bit position masks
mDBGC1_CAPMOD0:     equ    %00000001
mDBGC1_CAPMOD1:     equ    %00000010
mDBGC1_DBGBRK:      equ    %00001000
mDBGC1_BEGIN:       equ    %00010000
mDBGC1_TRGSEL:      equ    %00100000
mDBGC1_ARM:         equ    %01000000
mDBGC1_DBGEN:       equ    %10000000


;*** DBGSC - Debug Status and Control Register; 0x00000021 ***
DBGSC:              equ    $00000021                                ;*** DBGSC - Debug Status and Control Register; 0x00000021 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGSC_TRG0:         equ    0                                         ; Trigger Mode Bits, bit 0
DBGSC_TRG1:         equ    1                                         ; Trigger Mode Bits, bit 1
DBGSC_TRG2:         equ    2                                         ; Trigger Mode Bits, bit 2
DBGSC_TRG3:         equ    3                                         ; Trigger Mode Bits, bit 3
DBGSC_CF:           equ    5                                         ; Comparator C Match Flag
DBGSC_BF:           equ    6                                         ; Trigger B Match Flag
DBGSC_AF:           equ    7                                         ; Trigger A Match Flag
; bit position masks
mDBGSC_TRG0:        equ    %00000001
mDBGSC_TRG1:        equ    %00000010
mDBGSC_TRG2:        equ    %00000100
mDBGSC_TRG3:        equ    %00001000
mDBGSC_CF:          equ    %00100000
mDBGSC_BF:          equ    %01000000
mDBGSC_AF:          equ    %10000000


;*** DBGTB - Debug Trace Buffer Register; 0x00000022 ***
DBGTB:              equ    $00000022                                ;*** DBGTB - Debug Trace Buffer Register; 0x00000022 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGTB_BIT0:         equ    0                                         ; Trace Buffer Data Bit 0
DBGTB_BIT1:         equ    1                                         ; Trace Buffer Data Bit 1
DBGTB_BIT2:         equ    2                                         ; Trace Buffer Data Bit 2
DBGTB_BIT3:         equ    3                                         ; Trace Buffer Data Bit 3
DBGTB_BIT4:         equ    4                                         ; Trace Buffer Data Bit 4
DBGTB_BIT5:         equ    5                                         ; Trace Buffer Data Bit 5
DBGTB_BIT6:         equ    6                                         ; Trace Buffer Data Bit 6
DBGTB_BIT7:         equ    7                                         ; Trace Buffer Data Bit 7
DBGTB_BIT8:         equ    8                                         ; Trace Buffer Data Bit 8
DBGTB_BIT9:         equ    9                                         ; Trace Buffer Data Bit 9
DBGTB_BIT10:        equ    10                                        ; Trace Buffer Data Bit 10
DBGTB_BIT11:        equ    11                                        ; Trace Buffer Data Bit 11
DBGTB_BIT12:        equ    12                                        ; Trace Buffer Data Bit 12
DBGTB_BIT13:        equ    13                                        ; Trace Buffer Data Bit 13
DBGTB_BIT14:        equ    14                                        ; Trace Buffer Data Bit 14
DBGTB_BIT15:        equ    15                                        ; Trace Buffer Data Bit 15
; bit position masks
mDBGTB_BIT0:        equ    %00000001
mDBGTB_BIT1:        equ    %00000010
mDBGTB_BIT2:        equ    %00000100
mDBGTB_BIT3:        equ    %00001000
mDBGTB_BIT4:        equ    %00010000
mDBGTB_BIT5:        equ    %00100000
mDBGTB_BIT6:        equ    %01000000
mDBGTB_BIT7:        equ    %10000000
mDBGTB_BIT8:        equ    %100000000
mDBGTB_BIT9:        equ    %1000000000
mDBGTB_BIT10:       equ    %10000000000
mDBGTB_BIT11:       equ    %100000000000
mDBGTB_BIT12:       equ    %1000000000000
mDBGTB_BIT13:       equ    %10000000000000
mDBGTB_BIT14:       equ    %100000000000000
mDBGTB_BIT15:       equ    %1000000000000000


;*** DBGTBH - Debug Trace Buffer Register High; 0x00000022 ***
DBGTBH:             equ    $00000022                                ;*** DBGTBH - Debug Trace Buffer Register High; 0x00000022 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGTBH_BIT8:        equ    0                                         ; Trace Buffer Data Bit 8
DBGTBH_BIT9:        equ    1                                         ; Trace Buffer Data Bit 9
DBGTBH_BIT10:       equ    2                                         ; Trace Buffer Data Bit 10
DBGTBH_BIT11:       equ    3                                         ; Trace Buffer Data Bit 11
DBGTBH_BIT12:       equ    4                                         ; Trace Buffer Data Bit 12
DBGTBH_BIT13:       equ    5                                         ; Trace Buffer Data Bit 13
DBGTBH_BIT14:       equ    6                                         ; Trace Buffer Data Bit 14
DBGTBH_BIT15:       equ    7                                         ; Trace Buffer Data Bit 15
; bit position masks
mDBGTBH_BIT8:       equ    %00000001
mDBGTBH_BIT9:       equ    %00000010
mDBGTBH_BIT10:      equ    %00000100
mDBGTBH_BIT11:      equ    %00001000
mDBGTBH_BIT12:      equ    %00010000
mDBGTBH_BIT13:      equ    %00100000
mDBGTBH_BIT14:      equ    %01000000
mDBGTBH_BIT15:      equ    %10000000


;*** DBGTBL - Debug Trace Buffer Register Low; 0x00000023 ***
DBGTBL:             equ    $00000023                                ;*** DBGTBL - Debug Trace Buffer Register Low; 0x00000023 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGTBL_BIT0:        equ    0                                         ; Trace Buffer Data Bit 0
DBGTBL_BIT1:        equ    1                                         ; Trace Buffer Data Bit 1
DBGTBL_BIT2:        equ    2                                         ; Trace Buffer Data Bit 2
DBGTBL_BIT3:        equ    3                                         ; Trace Buffer Data Bit 3
DBGTBL_BIT4:        equ    4                                         ; Trace Buffer Data Bit 4
DBGTBL_BIT5:        equ    5                                         ; Trace Buffer Data Bit 5
DBGTBL_BIT6:        equ    6                                         ; Trace Buffer Data Bit 6
DBGTBL_BIT7:        equ    7                                         ; Trace Buffer Data Bit 7
; bit position masks
mDBGTBL_BIT0:       equ    %00000001
mDBGTBL_BIT1:       equ    %00000010
mDBGTBL_BIT2:       equ    %00000100
mDBGTBL_BIT3:       equ    %00001000
mDBGTBL_BIT4:       equ    %00010000
mDBGTBL_BIT5:       equ    %00100000
mDBGTBL_BIT6:       equ    %01000000
mDBGTBL_BIT7:       equ    %10000000


;*** DBGCNT - Debug Count Register; 0x00000024 ***
DBGCNT:             equ    $00000024                                ;*** DBGCNT - Debug Count Register; 0x00000024 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGCNT_CNT0:        equ    0                                         ; Count Value, bit 0
DBGCNT_CNT1:        equ    1                                         ; Count Value, bit 1
DBGCNT_CNT2:        equ    2                                         ; Count Value, bit 2
DBGCNT_CNT3:        equ    3                                         ; Count Value, bit 3
DBGCNT_CNT4:        equ    4                                         ; Count Value, bit 4
DBGCNT_CNT5:        equ    5                                         ; Count Value, bit 5
DBGCNT_TBF:         equ    7                                         ; Trace Buffer Full
; bit position masks
mDBGCNT_CNT0:       equ    %00000001
mDBGCNT_CNT1:       equ    %00000010
mDBGCNT_CNT2:       equ    %00000100
mDBGCNT_CNT3:       equ    %00001000
mDBGCNT_CNT4:       equ    %00010000
mDBGCNT_CNT5:       equ    %00100000
mDBGCNT_TBF:        equ    %10000000


;*** DBGCCX - Debug Comparator C Extended Register; 0x00000025 ***
DBGCCX:             equ    $00000025                                ;*** DBGCCX - Debug Comparator C Extended Register; 0x00000025 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGCCX_EXTCMP0:     equ    0                                         ; Comparator C Extended Compare Bits, bit 0
DBGCCX_EXTCMP1:     equ    1                                         ; Comparator C Extended Compare Bits, bit 1
DBGCCX_EXTCMP2:     equ    2                                         ; Comparator C Extended Compare Bits, bit 2
DBGCCX_EXTCMP3:     equ    3                                         ; Comparator C Extended Compare Bits, bit 3
DBGCCX_EXTCMP4:     equ    4                                         ; Comparator C Extended Compare Bits, bit 4
DBGCCX_EXTCMP5:     equ    5                                         ; Comparator C Extended Compare Bits, bit 5
DBGCCX_PAGSEL0:     equ    6                                         ; Page Selector Field, bit 0
DBGCCX_PAGSEL1:     equ    7                                         ; Page Selector Field, bit 1
; bit position masks
mDBGCCX_EXTCMP0:    equ    %00000001
mDBGCCX_EXTCMP1:    equ    %00000010
mDBGCCX_EXTCMP2:    equ    %00000100
mDBGCCX_EXTCMP3:    equ    %00001000
mDBGCCX_EXTCMP4:    equ    %00010000
mDBGCCX_EXTCMP5:    equ    %00100000
mDBGCCX_PAGSEL0:    equ    %01000000
mDBGCCX_PAGSEL1:    equ    %10000000


;*** DBGCC - Debug Comparator C Register; 0x00000026 ***
DBGCC:              equ    $00000026                                ;*** DBGCC - Debug Comparator C Register; 0x00000026 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGCC_BIT0:         equ    0                                         ; Comparator C Compare Bit 0
DBGCC_BIT1:         equ    1                                         ; Comparator C Compare Bit 1
DBGCC_BIT2:         equ    2                                         ; Comparator C Compare Bit 2
DBGCC_BIT3:         equ    3                                         ; Comparator C Compare Bit 3
DBGCC_BIT4:         equ    4                                         ; Comparator C Compare Bit 4
DBGCC_BIT5:         equ    5                                         ; Comparator C Compare Bit 5
DBGCC_BIT6:         equ    6                                         ; Comparator C Compare Bit 6
DBGCC_BIT7:         equ    7                                         ; Comparator C Compare Bit 7
DBGCC_BIT8:         equ    8                                         ; Comparator C Compare Bit 8
DBGCC_BIT9:         equ    9                                         ; Comparator C Compare Bit 9
DBGCC_BIT10:        equ    10                                        ; Comparator C Compare Bit 10
DBGCC_BIT11:        equ    11                                        ; Comparator C Compare Bit 11
DBGCC_BIT12:        equ    12                                        ; Comparator C Compare Bit 12
DBGCC_BIT13:        equ    13                                        ; Comparator C Compare Bit 13
DBGCC_BIT14:        equ    14                                        ; Comparator C Compare Bit 14
DBGCC_BIT15:        equ    15                                        ; Comparator C Compare Bit 15
; bit position masks
mDBGCC_BIT0:        equ    %00000001
mDBGCC_BIT1:        equ    %00000010
mDBGCC_BIT2:        equ    %00000100
mDBGCC_BIT3:        equ    %00001000
mDBGCC_BIT4:        equ    %00010000
mDBGCC_BIT5:        equ    %00100000
mDBGCC_BIT6:        equ    %01000000
mDBGCC_BIT7:        equ    %10000000
mDBGCC_BIT8:        equ    %100000000
mDBGCC_BIT9:        equ    %1000000000
mDBGCC_BIT10:       equ    %10000000000
mDBGCC_BIT11:       equ    %100000000000
mDBGCC_BIT12:       equ    %1000000000000
mDBGCC_BIT13:       equ    %10000000000000
mDBGCC_BIT14:       equ    %100000000000000
mDBGCC_BIT15:       equ    %1000000000000000


;*** DBGCCH - Debug Comparator C Register High; 0x00000026 ***
DBGCCH:             equ    $00000026                                ;*** DBGCCH - Debug Comparator C Register High; 0x00000026 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGCCH_BIT8:        equ    0                                         ; Comparator C Compare Bit 8
DBGCCH_BIT9:        equ    1                                         ; Comparator C Compare Bit 9
DBGCCH_BIT10:       equ    2                                         ; Comparator C Compare Bit 10
DBGCCH_BIT11:       equ    3                                         ; Comparator C Compare Bit 11
DBGCCH_BIT12:       equ    4                                         ; Comparator C Compare Bit 12
DBGCCH_BIT13:       equ    5                                         ; Comparator C Compare Bit 13
DBGCCH_BIT14:       equ    6                                         ; Comparator C Compare Bit 14
DBGCCH_BIT15:       equ    7                                         ; Comparator C Compare Bit 15
; bit position masks
mDBGCCH_BIT8:       equ    %00000001
mDBGCCH_BIT9:       equ    %00000010
mDBGCCH_BIT10:      equ    %00000100
mDBGCCH_BIT11:      equ    %00001000
mDBGCCH_BIT12:      equ    %00010000
mDBGCCH_BIT13:      equ    %00100000
mDBGCCH_BIT14:      equ    %01000000
mDBGCCH_BIT15:      equ    %10000000


;*** DBGCCL - Debug Comparator C Register Low; 0x00000027 ***
DBGCCL:             equ    $00000027                                ;*** DBGCCL - Debug Comparator C Register Low; 0x00000027 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGCCL_BIT0:        equ    0                                         ; Comparator C Compare Bit 0
DBGCCL_BIT1:        equ    1                                         ; Comparator C Compare Bit 1
DBGCCL_BIT2:        equ    2                                         ; Comparator C Compare Bit 2
DBGCCL_BIT3:        equ    3                                         ; Comparator C Compare Bit 3
DBGCCL_BIT4:        equ    4                                         ; Comparator C Compare Bit 4
DBGCCL_BIT5:        equ    5                                         ; Comparator C Compare Bit 5
DBGCCL_BIT6:        equ    6                                         ; Comparator C Compare Bit 6
DBGCCL_BIT7:        equ    7                                         ; Comparator C Compare Bit 7
; bit position masks
mDBGCCL_BIT0:       equ    %00000001
mDBGCCL_BIT1:       equ    %00000010
mDBGCCL_BIT2:       equ    %00000100
mDBGCCL_BIT3:       equ    %00001000
mDBGCCL_BIT4:       equ    %00010000
mDBGCCL_BIT5:       equ    %00100000
mDBGCCL_BIT6:       equ    %01000000
mDBGCCL_BIT7:       equ    %10000000


;*** DBGC2 - Debug Control Register 2; 0x00000028 ***
DBGC2:              equ    $00000028                                ;*** DBGC2 - Debug Control Register 2; 0x00000028 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGC2_RWC:          equ    0                                         ; Read/Write Comparator C Value Bit
DBGC2_RWCEN:        equ    1                                         ; Read/Write Comparator C Enable Bit
DBGC2_TAGC:         equ    2                                         ; Comparator C Tag Select
DBGC2_BKCEN:        equ    3                                         ; Breakpoint Comparator C Enable Bit
DBGC2_TAGAB:        equ    4                                         ; Comparator A/B Tag Select
DBGC2_BDM:          equ    5                                         ; Background Debug Mode Enable
DBGC2_FULL:         equ    6                                         ; Full Breakpoint Mode Enable
DBGC2_BKABEN:       equ    7                                         ; Breakpoint Using Comparator A and B Enable
; bit position masks
mDBGC2_RWC:         equ    %00000001
mDBGC2_RWCEN:       equ    %00000010
mDBGC2_TAGC:        equ    %00000100
mDBGC2_BKCEN:       equ    %00001000
mDBGC2_TAGAB:       equ    %00010000
mDBGC2_BDM:         equ    %00100000
mDBGC2_FULL:        equ    %01000000
mDBGC2_BKABEN:      equ    %10000000


;*** DBGC3 - Debug Control Register 3; 0x00000029 ***
DBGC3:              equ    $00000029                                ;*** DBGC3 - Debug Control Register 3; 0x00000029 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGC3_RWB:          equ    0                                         ; Read/Write Comparator B Value Bit
DBGC3_RWBEN:        equ    1                                         ; Read/Write Comparator B Enable Bit
DBGC3_RWA:          equ    2                                         ; Read/Write Comparator A Value Bit
DBGC3_RWAEN:        equ    3                                         ; Read/Write Comparator A Enable Bit
DBGC3_BKBMBL:       equ    4                                         ; Breakpoint Mask Low Byte for Second Address
DBGC3_BKBMBH:       equ    5                                         ; Breakpoint Mask High Byte for Second Address
DBGC3_BKAMBL:       equ    6                                         ; Breakpoint Mask Low Byte for First Address
DBGC3_BKAMBH:       equ    7                                         ; Breakpoint Mask High Byte for First Address
; bit position masks
mDBGC3_RWB:         equ    %00000001
mDBGC3_RWBEN:       equ    %00000010
mDBGC3_RWA:         equ    %00000100
mDBGC3_RWAEN:       equ    %00001000
mDBGC3_BKBMBL:      equ    %00010000
mDBGC3_BKBMBH:      equ    %00100000
mDBGC3_BKAMBL:      equ    %01000000
mDBGC3_BKAMBH:      equ    %10000000


;*** DBGCAX - Debug Comparator A Extended Register; 0x0000002A ***
DBGCAX:             equ    $0000002A                                ;*** DBGCAX - Debug Comparator A Extended Register; 0x0000002A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGCAX_EXTCMP0:     equ    0                                         ; Comparator A Extended Compare Bits, bit 0
DBGCAX_EXTCMP1:     equ    1                                         ; Comparator A Extended Compare Bits, bit 1
DBGCAX_EXTCMP2:     equ    2                                         ; Comparator A Extended Compare Bits, bit 2
DBGCAX_EXTCMP3:     equ    3                                         ; Comparator A Extended Compare Bits, bit 3
DBGCAX_EXTCMP4:     equ    4                                         ; Comparator A Extended Compare Bits, bit 4
DBGCAX_EXTCMP5:     equ    5                                         ; Comparator A Extended Compare Bits, bit 5
DBGCAX_PAGSEL0:     equ    6                                         ; Page Selector Field, bit 0
DBGCAX_PAGSEL1:     equ    7                                         ; Page Selector Field, bit 1
; bit position masks
mDBGCAX_EXTCMP0:    equ    %00000001
mDBGCAX_EXTCMP1:    equ    %00000010
mDBGCAX_EXTCMP2:    equ    %00000100
mDBGCAX_EXTCMP3:    equ    %00001000
mDBGCAX_EXTCMP4:    equ    %00010000
mDBGCAX_EXTCMP5:    equ    %00100000
mDBGCAX_PAGSEL0:    equ    %01000000
mDBGCAX_PAGSEL1:    equ    %10000000


;*** DBGCA - Debug Comparator A Register; 0x0000002B ***
DBGCA:              equ    $0000002B                                ;*** DBGCA - Debug Comparator A Register; 0x0000002B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGCA_BIT0:         equ    0                                         ; Comparator A Compare Bit 0
DBGCA_BIT1:         equ    1                                         ; Comparator A Compare Bit 1
DBGCA_BIT2:         equ    2                                         ; Comparator A Compare Bit 2
DBGCA_BIT3:         equ    3                                         ; Comparator A Compare Bit 3
DBGCA_BIT4:         equ    4                                         ; Comparator A Compare Bit 4
DBGCA_BIT5:         equ    5                                         ; Comparator A Compare Bit 5
DBGCA_BIT6:         equ    6                                         ; Comparator A Compare Bit 6
DBGCA_BIT7:         equ    7                                         ; Comparator A Compare Bit 7
DBGCA_BIT8:         equ    8                                         ; Comparator A Compare Bit 8
DBGCA_BIT9:         equ    9                                         ; Comparator A Compare Bit 9
DBGCA_BIT10:        equ    10                                        ; Comparator A Compare Bit 10
DBGCA_BIT11:        equ    11                                        ; Comparator A Compare Bit 11
DBGCA_BIT12:        equ    12                                        ; Comparator A Compare Bit 12
DBGCA_BIT13:        equ    13                                        ; Comparator A Compare Bit 13
DBGCA_BIT14:        equ    14                                        ; Comparator A Compare Bit 14
DBGCA_BIT15:        equ    15                                        ; Comparator A Compare Bit 15
; bit position masks
mDBGCA_BIT0:        equ    %00000001
mDBGCA_BIT1:        equ    %00000010
mDBGCA_BIT2:        equ    %00000100
mDBGCA_BIT3:        equ    %00001000
mDBGCA_BIT4:        equ    %00010000
mDBGCA_BIT5:        equ    %00100000
mDBGCA_BIT6:        equ    %01000000
mDBGCA_BIT7:        equ    %10000000
mDBGCA_BIT8:        equ    %100000000
mDBGCA_BIT9:        equ    %1000000000
mDBGCA_BIT10:       equ    %10000000000
mDBGCA_BIT11:       equ    %100000000000
mDBGCA_BIT12:       equ    %1000000000000
mDBGCA_BIT13:       equ    %10000000000000
mDBGCA_BIT14:       equ    %100000000000000
mDBGCA_BIT15:       equ    %1000000000000000


;*** DBGCAH - Debug Comparator A Register High; 0x0000002B ***
DBGCAH:             equ    $0000002B                                ;*** DBGCAH - Debug Comparator A Register High; 0x0000002B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGCAH_BIT8:        equ    0                                         ; Comparator A Compare Bit 8
DBGCAH_BIT9:        equ    1                                         ; Comparator A Compare Bit 9
DBGCAH_BIT10:       equ    2                                         ; Comparator A Compare Bit 10
DBGCAH_BIT11:       equ    3                                         ; Comparator A Compare Bit 11
DBGCAH_BIT12:       equ    4                                         ; Comparator A Compare Bit 12
DBGCAH_BIT13:       equ    5                                         ; Comparator A Compare Bit 13
DBGCAH_BIT14:       equ    6                                         ; Comparator A Compare Bit 14
DBGCAH_BIT15:       equ    7                                         ; Comparator A Compare Bit 15
; bit position masks
mDBGCAH_BIT8:       equ    %00000001
mDBGCAH_BIT9:       equ    %00000010
mDBGCAH_BIT10:      equ    %00000100
mDBGCAH_BIT11:      equ    %00001000
mDBGCAH_BIT12:      equ    %00010000
mDBGCAH_BIT13:      equ    %00100000
mDBGCAH_BIT14:      equ    %01000000
mDBGCAH_BIT15:      equ    %10000000


;*** DBGCAL - Debug Comparator A Register Low; 0x0000002C ***
DBGCAL:             equ    $0000002C                                ;*** DBGCAL - Debug Comparator A Register Low; 0x0000002C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGCAL_BIT0:        equ    0                                         ; Comparator A Compare Bit 0
DBGCAL_BIT1:        equ    1                                         ; Comparator A Compare Bit 1
DBGCAL_BIT2:        equ    2                                         ; Comparator A Compare Bit 2
DBGCAL_BIT3:        equ    3                                         ; Comparator A Compare Bit 3
DBGCAL_BIT4:        equ    4                                         ; Comparator A Compare Bit 4
DBGCAL_BIT5:        equ    5                                         ; Comparator A Compare Bit 5
DBGCAL_BIT6:        equ    6                                         ; Comparator A Compare Bit 6
DBGCAL_BIT7:        equ    7                                         ; Comparator A Compare Bit 7
; bit position masks
mDBGCAL_BIT0:       equ    %00000001
mDBGCAL_BIT1:       equ    %00000010
mDBGCAL_BIT2:       equ    %00000100
mDBGCAL_BIT3:       equ    %00001000
mDBGCAL_BIT4:       equ    %00010000
mDBGCAL_BIT5:       equ    %00100000
mDBGCAL_BIT6:       equ    %01000000
mDBGCAL_BIT7:       equ    %10000000


;*** DBGCBX - Debug Comparator B Extended Register; 0x0000002D ***
DBGCBX:             equ    $0000002D                                ;*** DBGCBX - Debug Comparator B Extended Register; 0x0000002D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGCBX_EXTCMP0:     equ    0                                         ; Comparator B Extended Compare Bits, bit 0
DBGCBX_EXTCMP1:     equ    1                                         ; Comparator B Extended Compare Bits, bit 1
DBGCBX_EXTCMP2:     equ    2                                         ; Comparator B Extended Compare Bits, bit 2
DBGCBX_EXTCMP3:     equ    3                                         ; Comparator B Extended Compare Bits, bit 3
DBGCBX_EXTCMP4:     equ    4                                         ; Comparator B Extended Compare Bits, bit 4
DBGCBX_EXTCMP5:     equ    5                                         ; Comparator B Extended Compare Bits, bit 5
DBGCBX_PAGSEL0:     equ    6                                         ; Page Selector Field, bit 0
DBGCBX_PAGSEL1:     equ    7                                         ; Page Selector Field, bit 1
; bit position masks
mDBGCBX_EXTCMP0:    equ    %00000001
mDBGCBX_EXTCMP1:    equ    %00000010
mDBGCBX_EXTCMP2:    equ    %00000100
mDBGCBX_EXTCMP3:    equ    %00001000
mDBGCBX_EXTCMP4:    equ    %00010000
mDBGCBX_EXTCMP5:    equ    %00100000
mDBGCBX_PAGSEL0:    equ    %01000000
mDBGCBX_PAGSEL1:    equ    %10000000


;*** DBGCB - Debug Comparator B Register; 0x0000002E ***
DBGCB:              equ    $0000002E                                ;*** DBGCB - Debug Comparator B Register; 0x0000002E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGCB_BIT0:         equ    0                                         ; Comparator B High Compare Bit 0
DBGCB_BIT1:         equ    1                                         ; Comparator B High Compare Bit 1
DBGCB_BIT2:         equ    2                                         ; Comparator B High Compare Bit 2
DBGCB_BIT3:         equ    3                                         ; Comparator B High Compare Bit 3
DBGCB_BIT4:         equ    4                                         ; Comparator B High Compare Bit 4
DBGCB_BIT5:         equ    5                                         ; Comparator B High Compare Bit 5
DBGCB_BIT6:         equ    6                                         ; Comparator B High Compare Bit 6
DBGCB_BIT7:         equ    7                                         ; Comparator B High Compare Bit 7
DBGCB_BIT8:         equ    8                                         ; Comparator B High Compare Bit 8
DBGCB_BIT9:         equ    9                                         ; Comparator B High Compare Bit 9
DBGCB_BIT10:        equ    10                                        ; Comparator B High Compare Bit 10
DBGCB_BIT11:        equ    11                                        ; Comparator B High Compare Bit 11
DBGCB_BIT12:        equ    12                                        ; Comparator B High Compare Bit 12
DBGCB_BIT13:        equ    13                                        ; Comparator B High Compare Bit 13
DBGCB_BIT14:        equ    14                                        ; Comparator B High Compare Bit 14
DBGCB_BIT15:        equ    15                                        ; Comparator B High Compare Bit 15
; bit position masks
mDBGCB_BIT0:        equ    %00000001
mDBGCB_BIT1:        equ    %00000010
mDBGCB_BIT2:        equ    %00000100
mDBGCB_BIT3:        equ    %00001000
mDBGCB_BIT4:        equ    %00010000
mDBGCB_BIT5:        equ    %00100000
mDBGCB_BIT6:        equ    %01000000
mDBGCB_BIT7:        equ    %10000000
mDBGCB_BIT8:        equ    %100000000
mDBGCB_BIT9:        equ    %1000000000
mDBGCB_BIT10:       equ    %10000000000
mDBGCB_BIT11:       equ    %100000000000
mDBGCB_BIT12:       equ    %1000000000000
mDBGCB_BIT13:       equ    %10000000000000
mDBGCB_BIT14:       equ    %100000000000000
mDBGCB_BIT15:       equ    %1000000000000000


;*** DBGCBH - Debug Comparator B Register High; 0x0000002E ***
DBGCBH:             equ    $0000002E                                ;*** DBGCBH - Debug Comparator B Register High; 0x0000002E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGCBH_BIT8:        equ    0                                         ; Comparator B High Compare Bit 8
DBGCBH_BIT9:        equ    1                                         ; Comparator B High Compare Bit 9
DBGCBH_BIT10:       equ    2                                         ; Comparator B High Compare Bit 10
DBGCBH_BIT11:       equ    3                                         ; Comparator B High Compare Bit 11
DBGCBH_BIT12:       equ    4                                         ; Comparator B High Compare Bit 12
DBGCBH_BIT13:       equ    5                                         ; Comparator B High Compare Bit 13
DBGCBH_BIT14:       equ    6                                         ; Comparator B High Compare Bit 14
DBGCBH_BIT15:       equ    7                                         ; Comparator B High Compare Bit 15
; bit position masks
mDBGCBH_BIT8:       equ    %00000001
mDBGCBH_BIT9:       equ    %00000010
mDBGCBH_BIT10:      equ    %00000100
mDBGCBH_BIT11:      equ    %00001000
mDBGCBH_BIT12:      equ    %00010000
mDBGCBH_BIT13:      equ    %00100000
mDBGCBH_BIT14:      equ    %01000000
mDBGCBH_BIT15:      equ    %10000000


;*** DBGCBL - Debug Comparator B Register Low; 0x0000002F ***
DBGCBL:             equ    $0000002F                                ;*** DBGCBL - Debug Comparator B Register Low; 0x0000002F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGCBL_BIT0:        equ    0                                         ; Comparator B High Compare Bit 0
DBGCBL_BIT1:        equ    1                                         ; Comparator B High Compare Bit 1
DBGCBL_BIT2:        equ    2                                         ; Comparator B High Compare Bit 2
DBGCBL_BIT3:        equ    3                                         ; Comparator B High Compare Bit 3
DBGCBL_BIT4:        equ    4                                         ; Comparator B High Compare Bit 4
DBGCBL_BIT5:        equ    5                                         ; Comparator B High Compare Bit 5
DBGCBL_BIT6:        equ    6                                         ; Comparator B High Compare Bit 6
DBGCBL_BIT7:        equ    7                                         ; Comparator B High Compare Bit 7
; bit position masks
mDBGCBL_BIT0:       equ    %00000001
mDBGCBL_BIT1:       equ    %00000010
mDBGCBL_BIT2:       equ    %00000100
mDBGCBL_BIT3:       equ    %00001000
mDBGCBL_BIT4:       equ    %00010000
mDBGCBL_BIT5:       equ    %00100000
mDBGCBL_BIT6:       equ    %01000000
mDBGCBL_BIT7:       equ    %10000000


;*** PPAGE - Page Index Register; 0x00000030 ***
PPAGE:              equ    $00000030                                ;*** PPAGE - Page Index Register; 0x00000030 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PPAGE_PIX0:         equ    0                                         ; Page Index Register Bit 0
PPAGE_PIX1:         equ    1                                         ; Page Index Register Bit 1
PPAGE_PIX2:         equ    2                                         ; Page Index Register Bit 2
PPAGE_PIX3:         equ    3                                         ; Page Index Register Bit 3
PPAGE_PIX4:         equ    4                                         ; Page Index Register Bit 4
PPAGE_PIX5:         equ    5                                         ; Page Index Register Bit 5
; bit position masks
mPPAGE_PIX0:        equ    %00000001
mPPAGE_PIX1:        equ    %00000010
mPPAGE_PIX2:        equ    %00000100
mPPAGE_PIX3:        equ    %00001000
mPPAGE_PIX4:        equ    %00010000
mPPAGE_PIX5:        equ    %00100000


;*** PORTK - Port K Data Register; 0x00000032 ***
PORTK:              equ    $00000032                                ;*** PORTK - Port K Data Register; 0x00000032 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PORTK_BIT0:         equ    0                                         ; Port K Bit 0
PORTK_BIT1:         equ    1                                         ; Port K Bit 1
PORTK_BIT2:         equ    2                                         ; Port K Bit 2
PORTK_BIT3:         equ    3                                         ; Port K Bit 3
PORTK_BIT4:         equ    4                                         ; Port K Bit 4
PORTK_BIT5:         equ    5                                         ; Port K Bit 5
PORTK_BIT6:         equ    6                                         ; Port K Bit 6
PORTK_BIT7:         equ    7                                         ; Port K Bit 7
; bit position masks
mPORTK_BIT0:        equ    %00000001
mPORTK_BIT1:        equ    %00000010
mPORTK_BIT2:        equ    %00000100
mPORTK_BIT3:        equ    %00001000
mPORTK_BIT4:        equ    %00010000
mPORTK_BIT5:        equ    %00100000
mPORTK_BIT6:        equ    %01000000
mPORTK_BIT7:        equ    %10000000


;*** DDRK - Port K Data Direction Register; 0x00000033 ***
DDRK:               equ    $00000033                                ;*** DDRK - Port K Data Direction Register; 0x00000033 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRK_BIT0:          equ    0                                         ; Port K Data Direction Bit 0
DDRK_BIT1:          equ    1                                         ; Port K Data Direction Bit 1
DDRK_BIT2:          equ    2                                         ; Port K Data Direction Bit 2
DDRK_BIT3:          equ    3                                         ; Port K Data Direction Bit 3
DDRK_BIT4:          equ    4                                         ; Port K Data Direction Bit 4
DDRK_BIT5:          equ    5                                         ; Port K Data Direction Bit 5
DDRK_BIT6:          equ    6                                         ; Port K Data Direction Bit 6
DDRK_BIT7:          equ    7                                         ; Port K Data Direction Bit 7
; bit position masks
mDDRK_BIT0:         equ    %00000001
mDDRK_BIT1:         equ    %00000010
mDDRK_BIT2:         equ    %00000100
mDDRK_BIT3:         equ    %00001000
mDDRK_BIT4:         equ    %00010000
mDDRK_BIT5:         equ    %00100000
mDDRK_BIT6:         equ    %01000000
mDDRK_BIT7:         equ    %10000000


;*** SYNR - CRG Synthesizer Register; 0x00000034 ***
SYNR:               equ    $00000034                                ;*** SYNR - CRG Synthesizer Register; 0x00000034 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SYNR_SYN0:          equ    0                                         ; CRG Synthesizer Bit 0
SYNR_SYN1:          equ    1                                         ; CRG Synthesizer Bit 1
SYNR_SYN2:          equ    2                                         ; CRG Synthesizer Bit 2
SYNR_SYN3:          equ    3                                         ; CRG Synthesizer Bit 3
SYNR_SYN4:          equ    4                                         ; CRG Synthesizer Bit 4
SYNR_SYN5:          equ    5                                         ; CRG Synthesizer Bit 5
; bit position masks
mSYNR_SYN0:         equ    %00000001
mSYNR_SYN1:         equ    %00000010
mSYNR_SYN2:         equ    %00000100
mSYNR_SYN3:         equ    %00001000
mSYNR_SYN4:         equ    %00010000
mSYNR_SYN5:         equ    %00100000


;*** REFDV - CRG Reference Divider Register; 0x00000035 ***
REFDV:              equ    $00000035                                ;*** REFDV - CRG Reference Divider Register; 0x00000035 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
REFDV_REFDV0:       equ    0                                         ; CRG Reference Divider Bit 0
REFDV_REFDV1:       equ    1                                         ; CRG Reference Divider Bit 1
REFDV_REFDV2:       equ    2                                         ; CRG Reference Divider Bit 2
REFDV_REFDV3:       equ    3                                         ; CRG Reference Divider Bit 3
; bit position masks
mREFDV_REFDV0:      equ    %00000001
mREFDV_REFDV1:      equ    %00000010
mREFDV_REFDV2:      equ    %00000100
mREFDV_REFDV3:      equ    %00001000


;*** CRGFLG - CRG Flags Register; 0x00000037 ***
CRGFLG:             equ    $00000037                                ;*** CRGFLG - CRG Flags Register; 0x00000037 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CRGFLG_SCM:         equ    0                                         ; Self-clock mode Status
CRGFLG_SCMIF:       equ    1                                         ; Self-clock mode Interrupt Flag
CRGFLG_TRACK:       equ    2                                         ; Track Status
CRGFLG_LOCK:        equ    3                                         ; Lock Status
CRGFLG_LOCKIF:      equ    4                                         ; PLL Lock Interrupt Flag
CRGFLG_LVRF:        equ    5                                         ; Low Voltage Reset Flag
CRGFLG_PORF:        equ    6                                         ; Power on Reset Flag
CRGFLG_RTIF:        equ    7                                         ; Real Time Interrupt Flag
; bit position masks
mCRGFLG_SCM:        equ    %00000001
mCRGFLG_SCMIF:      equ    %00000010
mCRGFLG_TRACK:      equ    %00000100
mCRGFLG_LOCK:       equ    %00001000
mCRGFLG_LOCKIF:     equ    %00010000
mCRGFLG_LVRF:       equ    %00100000
mCRGFLG_PORF:       equ    %01000000
mCRGFLG_RTIF:       equ    %10000000


;*** CRGINT - CRG Interrupt Enable Register; 0x00000038 ***
CRGINT:             equ    $00000038                                ;*** CRGINT - CRG Interrupt Enable Register; 0x00000038 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CRGINT_SCMIE:       equ    1                                         ; Self-clock mode Interrupt Enable
CRGINT_LOCKIE:      equ    4                                         ; Lock Interrupt Enable
CRGINT_RTIE:        equ    7                                         ; Real Time Interrupt Enable
; bit position masks
mCRGINT_SCMIE:      equ    %00000010
mCRGINT_LOCKIE:     equ    %00010000
mCRGINT_RTIE:       equ    %10000000


;*** CLKSEL - CRG Clock Select Register; 0x00000039 ***
CLKSEL:             equ    $00000039                                ;*** CLKSEL - CRG Clock Select Register; 0x00000039 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CLKSEL_COPWAI:      equ    0                                         ; COP stops in WAIT mode
CLKSEL_RTIWAI:      equ    1                                         ; RTI stops in WAIT mode
CLKSEL_CWAI:        equ    2                                         ; CLK24 and CLK23 stop in WAIT mode
CLKSEL_PLLWAI:      equ    3                                         ; PLL stops in WAIT mode
CLKSEL_ROAWAI:      equ    4                                         ; Reduced Oscillator Amplitude in WAIT mode
CLKSEL_SYSWAI:      equ    5                                         ; System clocks stop in WAIT mode
CLKSEL_PSTP:        equ    6                                         ; Pseudo Stop
CLKSEL_PLLSEL:      equ    7                                         ; PLL selected for system clock
; bit position masks
mCLKSEL_COPWAI:     equ    %00000001
mCLKSEL_RTIWAI:     equ    %00000010
mCLKSEL_CWAI:       equ    %00000100
mCLKSEL_PLLWAI:     equ    %00001000
mCLKSEL_ROAWAI:     equ    %00010000
mCLKSEL_SYSWAI:     equ    %00100000
mCLKSEL_PSTP:       equ    %01000000
mCLKSEL_PLLSEL:     equ    %10000000


;*** PLLCTL - CRG PLL Control Register; 0x0000003A ***
PLLCTL:             equ    $0000003A                                ;*** PLLCTL - CRG PLL Control Register; 0x0000003A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PLLCTL_SCME:        equ    0                                         ; Self-clock mode enable
PLLCTL_PCE:         equ    1                                         ; COP Enable during Pseudo Stop Bit
PLLCTL_PRE:         equ    2                                         ; RTI Enable during Pseudo Stop Bit
PLLCTL_ACQ:         equ    4                                         ; Acquisition
PLLCTL_AUTO:        equ    5                                         ; Automatic Bandwidth Control
PLLCTL_PLLON:       equ    6                                         ; Phase Lock Loop On
PLLCTL_CME:         equ    7                                         ; Clock Monitor Enable
; bit position masks
mPLLCTL_SCME:       equ    %00000001
mPLLCTL_PCE:        equ    %00000010
mPLLCTL_PRE:        equ    %00000100
mPLLCTL_ACQ:        equ    %00010000
mPLLCTL_AUTO:       equ    %00100000
mPLLCTL_PLLON:      equ    %01000000
mPLLCTL_CME:        equ    %10000000


;*** RTICTL - CRG RTI Control Register; 0x0000003B ***
RTICTL:             equ    $0000003B                                ;*** RTICTL - CRG RTI Control Register; 0x0000003B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RTICTL_RTR0:        equ    0                                         ; Real Time Interrupt Modulus Counter Select Bit 0
RTICTL_RTR1:        equ    1                                         ; Real Time Interrupt Modulus Counter Select Bit 1
RTICTL_RTR2:        equ    2                                         ; Real Time Interrupt Modulus Counter Select Bit 2
RTICTL_RTR3:        equ    3                                         ; Real Time Interrupt Modulus Counter Select Bit 3
RTICTL_RTR4:        equ    4                                         ; Real Time Interrupt Prescale Rate Select Bit 4
RTICTL_RTR5:        equ    5                                         ; Real Time Interrupt Prescale Rate Select Bit 5
RTICTL_RTR6:        equ    6                                         ; Real Time Interrupt Prescale Rate Select Bit 6
; bit position masks
mRTICTL_RTR0:       equ    %00000001
mRTICTL_RTR1:       equ    %00000010
mRTICTL_RTR2:       equ    %00000100
mRTICTL_RTR3:       equ    %00001000
mRTICTL_RTR4:       equ    %00010000
mRTICTL_RTR5:       equ    %00100000
mRTICTL_RTR6:       equ    %01000000


;*** COPCTL - CRG COP Control Register; 0x0000003C ***
COPCTL:             equ    $0000003C                                ;*** COPCTL - CRG COP Control Register; 0x0000003C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
COPCTL_CR0:         equ    0                                         ; COP Watchdog Timer Rate select Bit 0
COPCTL_CR1:         equ    1                                         ; COP Watchdog Timer Rate select Bit 1
COPCTL_CR2:         equ    2                                         ; COP Watchdog Timer Rate select Bit 2
COPCTL_RSBCK:       equ    6                                         ; COP and RTI stop in Active BDM mode Bit
COPCTL_WCOP:        equ    7                                         ; Window COP mode
; bit position masks
mCOPCTL_CR0:        equ    %00000001
mCOPCTL_CR1:        equ    %00000010
mCOPCTL_CR2:        equ    %00000100
mCOPCTL_RSBCK:      equ    %01000000
mCOPCTL_WCOP:       equ    %10000000


;*** ARMCOP - CRG COP Timer Arm/Reset Register; 0x0000003F ***
ARMCOP:             equ    $0000003F                                ;*** ARMCOP - CRG COP Timer Arm/Reset Register; 0x0000003F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ARMCOP_BIT0:        equ    0                                         ; CRG COP Timer Arm/Reset Bit 0
ARMCOP_BIT1:        equ    1                                         ; CRG COP Timer Arm/Reset Bit 1
ARMCOP_BIT2:        equ    2                                         ; CRG COP Timer Arm/Reset Bit 2
ARMCOP_BIT3:        equ    3                                         ; CRG COP Timer Arm/Reset Bit 3
ARMCOP_BIT4:        equ    4                                         ; CRG COP Timer Arm/Reset Bit 4
ARMCOP_BIT5:        equ    5                                         ; CRG COP Timer Arm/Reset Bit 5
ARMCOP_BIT6:        equ    6                                         ; CRG COP Timer Arm/Reset Bit 6
ARMCOP_BIT7:        equ    7                                         ; CRG COP Timer Arm/Reset Bit 7
; bit position masks
mARMCOP_BIT0:       equ    %00000001
mARMCOP_BIT1:       equ    %00000010
mARMCOP_BIT2:       equ    %00000100
mARMCOP_BIT3:       equ    %00001000
mARMCOP_BIT4:       equ    %00010000
mARMCOP_BIT5:       equ    %00100000
mARMCOP_BIT6:       equ    %01000000
mARMCOP_BIT7:       equ    %10000000


;*** TIOS - Timer Input Capture/Output Compare Select; 0x00000040 ***
TIOS:               equ    $00000040                                ;*** TIOS - Timer Input Capture/Output Compare Select; 0x00000040 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TIOS_IOS0:          equ    0                                         ; Input Capture or Output Compare Channel Configuration Bit 0
TIOS_IOS1:          equ    1                                         ; Input Capture or Output Compare Channel Configuration Bit 1
TIOS_IOS2:          equ    2                                         ; Input Capture or Output Compare Channel Configuration Bit 2
TIOS_IOS3:          equ    3                                         ; Input Capture or Output Compare Channel Configuration Bit 3
TIOS_IOS4:          equ    4                                         ; Input Capture or Output Compare Channel Configuration Bit 4
TIOS_IOS5:          equ    5                                         ; Input Capture or Output Compare Channel Configuration Bit 5
TIOS_IOS6:          equ    6                                         ; Input Capture or Output Compare Channel Configuration Bit 6
TIOS_IOS7:          equ    7                                         ; Input Capture or Output Compare Channel Configuration Bit 7
; bit position masks
mTIOS_IOS0:         equ    %00000001
mTIOS_IOS1:         equ    %00000010
mTIOS_IOS2:         equ    %00000100
mTIOS_IOS3:         equ    %00001000
mTIOS_IOS4:         equ    %00010000
mTIOS_IOS5:         equ    %00100000
mTIOS_IOS6:         equ    %01000000
mTIOS_IOS7:         equ    %10000000


;*** CFORC - Timer Compare Force Register; 0x00000041 ***
CFORC:              equ    $00000041                                ;*** CFORC - Timer Compare Force Register; 0x00000041 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CFORC_FOC0:         equ    0                                         ; Force Output Compare Action for Channel 0
CFORC_FOC1:         equ    1                                         ; Force Output Compare Action for Channel 1
CFORC_FOC2:         equ    2                                         ; Force Output Compare Action for Channel 2
CFORC_FOC3:         equ    3                                         ; Force Output Compare Action for Channel 3
CFORC_FOC4:         equ    4                                         ; Force Output Compare Action for Channel 4
CFORC_FOC5:         equ    5                                         ; Force Output Compare Action for Channel 5
CFORC_FOC6:         equ    6                                         ; Force Output Compare Action for Channel 6
CFORC_FOC7:         equ    7                                         ; Force Output Compare Action for Channel 7
; bit position masks
mCFORC_FOC0:        equ    %00000001
mCFORC_FOC1:        equ    %00000010
mCFORC_FOC2:        equ    %00000100
mCFORC_FOC3:        equ    %00001000
mCFORC_FOC4:        equ    %00010000
mCFORC_FOC5:        equ    %00100000
mCFORC_FOC6:        equ    %01000000
mCFORC_FOC7:        equ    %10000000


;*** OC7M - Output Compare 7 Mask Register; 0x00000042 ***
OC7M:               equ    $00000042                                ;*** OC7M - Output Compare 7 Mask Register; 0x00000042 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
OC7M_OC7M0:         equ    0                                         ; Output Compare 7 Mask Bit 0
OC7M_OC7M1:         equ    1                                         ; Output Compare 7 Mask Bit 1
OC7M_OC7M2:         equ    2                                         ; Output Compare 7 Mask Bit 2
OC7M_OC7M3:         equ    3                                         ; Output Compare 7 Mask Bit 3
OC7M_OC7M4:         equ    4                                         ; Output Compare 7 Mask Bit 4
OC7M_OC7M5:         equ    5                                         ; Output Compare 7 Mask Bit 5
OC7M_OC7M6:         equ    6                                         ; Output Compare 7 Mask Bit 6
OC7M_OC7M7:         equ    7                                         ; Output Compare 7 Mask Bit 7
; bit position masks
mOC7M_OC7M0:        equ    %00000001
mOC7M_OC7M1:        equ    %00000010
mOC7M_OC7M2:        equ    %00000100
mOC7M_OC7M3:        equ    %00001000
mOC7M_OC7M4:        equ    %00010000
mOC7M_OC7M5:        equ    %00100000
mOC7M_OC7M6:        equ    %01000000
mOC7M_OC7M7:        equ    %10000000


;*** OC7D - Output Compare 7 Data Register; 0x00000043 ***
OC7D:               equ    $00000043                                ;*** OC7D - Output Compare 7 Data Register; 0x00000043 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
OC7D_OC7D0:         equ    0                                         ; Output Compare 7 Bit 0
OC7D_OC7D1:         equ    1                                         ; Output Compare 7 Bit 1
OC7D_OC7D2:         equ    2                                         ; Output Compare 7 Bit 2
OC7D_OC7D3:         equ    3                                         ; Output Compare 7 Bit 3
OC7D_OC7D4:         equ    4                                         ; Output Compare 7 Bit 4
OC7D_OC7D5:         equ    5                                         ; Output Compare 7 Bit 5
OC7D_OC7D6:         equ    6                                         ; Output Compare 7 Bit 6
OC7D_OC7D7:         equ    7                                         ; Output Compare 7 Bit 7
; bit position masks
mOC7D_OC7D0:        equ    %00000001
mOC7D_OC7D1:        equ    %00000010
mOC7D_OC7D2:        equ    %00000100
mOC7D_OC7D3:        equ    %00001000
mOC7D_OC7D4:        equ    %00010000
mOC7D_OC7D5:        equ    %00100000
mOC7D_OC7D6:        equ    %01000000
mOC7D_OC7D7:        equ    %10000000


;*** TCNT - Timer Count Register; 0x00000044 ***
TCNT:               equ    $00000044                                ;*** TCNT - Timer Count Register; 0x00000044 ***


;*** TCNTHi - Timer Count Register High; 0x00000044 ***
TCNTHi:             equ    $00000044                                ;*** TCNTHi - Timer Count Register High; 0x00000044 ***


;*** TCNTLo - Timer Count Register Low; 0x00000045 ***
TCNTLo:             equ    $00000045                                ;*** TCNTLo - Timer Count Register Low; 0x00000045 ***


;*** TSCR1 - Timer System Control Register1; 0x00000046 ***
TSCR1:              equ    $00000046                                ;*** TSCR1 - Timer System Control Register1; 0x00000046 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TSCR1_TFFCA:        equ    4                                         ; Timer Fast Flag Clear All
TSCR1_TSFRZ:        equ    5                                         ; Timer and Modulus Counter Stop While in Freeze Mode
TSCR1_TSWAI:        equ    6                                         ; Timer Module Stops While in Wait
TSCR1_TEN:          equ    7                                         ; Timer Enable
; bit position masks
mTSCR1_TFFCA:       equ    %00010000
mTSCR1_TSFRZ:       equ    %00100000
mTSCR1_TSWAI:       equ    %01000000
mTSCR1_TEN:         equ    %10000000


;*** TTOV - Timer Toggle On Overflow Register; 0x00000047 ***
TTOV:               equ    $00000047                                ;*** TTOV - Timer Toggle On Overflow Register; 0x00000047 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TTOV_TOV0:          equ    0                                         ; Toggle On Overflow Bit 0
TTOV_TOV1:          equ    1                                         ; Toggle On Overflow Bit 1
TTOV_TOV2:          equ    2                                         ; Toggle On Overflow Bit 2
TTOV_TOV3:          equ    3                                         ; Toggle On Overflow Bit 3
TTOV_TOV4:          equ    4                                         ; Toggle On Overflow Bit 4
TTOV_TOV5:          equ    5                                         ; Toggle On Overflow Bit 5
TTOV_TOV6:          equ    6                                         ; Toggle On Overflow Bit 6
TTOV_TOV7:          equ    7                                         ; Toggle On Overflow Bit 7
; bit position masks
mTTOV_TOV0:         equ    %00000001
mTTOV_TOV1:         equ    %00000010
mTTOV_TOV2:         equ    %00000100
mTTOV_TOV3:         equ    %00001000
mTTOV_TOV4:         equ    %00010000
mTTOV_TOV5:         equ    %00100000
mTTOV_TOV6:         equ    %01000000
mTTOV_TOV7:         equ    %10000000


;*** TCTL1 - Timer Control Register 1; 0x00000048 ***
TCTL1:              equ    $00000048                                ;*** TCTL1 - Timer Control Register 1; 0x00000048 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TCTL1_OL4:          equ    0                                         ; Output Level Bit 4
TCTL1_OM4:          equ    1                                         ; Output Mode Bit 4
TCTL1_OL5:          equ    2                                         ; Output Level Bit 5
TCTL1_OM5:          equ    3                                         ; Output Mode Bit 5
TCTL1_OL6:          equ    4                                         ; Output Level Bit 6
TCTL1_OM6:          equ    5                                         ; Output Mode Bit 6
TCTL1_OL7:          equ    6                                         ; Output Level Bit 7
TCTL1_OM7:          equ    7                                         ; Output Mode Bit 7
; bit position masks
mTCTL1_OL4:         equ    %00000001
mTCTL1_OM4:         equ    %00000010
mTCTL1_OL5:         equ    %00000100
mTCTL1_OM5:         equ    %00001000
mTCTL1_OL6:         equ    %00010000
mTCTL1_OM6:         equ    %00100000
mTCTL1_OL7:         equ    %01000000
mTCTL1_OM7:         equ    %10000000


;*** TCTL2 - Timer Control Register 2; 0x00000049 ***
TCTL2:              equ    $00000049                                ;*** TCTL2 - Timer Control Register 2; 0x00000049 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TCTL2_OL0:          equ    0                                         ; Output Level Bit 0
TCTL2_OM0:          equ    1                                         ; Output Mode Bit 0
TCTL2_OL1:          equ    2                                         ; Output Level Bit 1
TCTL2_OM1:          equ    3                                         ; Output Mode Bit 1
TCTL2_OL2:          equ    4                                         ; Output Level Bit 2
TCTL2_OM2:          equ    5                                         ; Output Mode Bit 2
TCTL2_OL3:          equ    6                                         ; Output Level Bit 3
TCTL2_OM3:          equ    7                                         ; Output Mode Bit 3
; bit position masks
mTCTL2_OL0:         equ    %00000001
mTCTL2_OM0:         equ    %00000010
mTCTL2_OL1:         equ    %00000100
mTCTL2_OM1:         equ    %00001000
mTCTL2_OL2:         equ    %00010000
mTCTL2_OM2:         equ    %00100000
mTCTL2_OL3:         equ    %01000000
mTCTL2_OM3:         equ    %10000000


;*** TCTL3 - Timer Control Register 3; 0x0000004A ***
TCTL3:              equ    $0000004A                                ;*** TCTL3 - Timer Control Register 3; 0x0000004A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TCTL3_EDG4A:        equ    0                                         ; Input Capture Edge Control 4A
TCTL3_EDG4B:        equ    1                                         ; Input Capture Edge Control 4B
TCTL3_EDG5A:        equ    2                                         ; Input Capture Edge Control 5A
TCTL3_EDG5B:        equ    3                                         ; Input Capture Edge Control 5B
TCTL3_EDG6A:        equ    4                                         ; Input Capture Edge Control 6A
TCTL3_EDG6B:        equ    5                                         ; Input Capture Edge Control 6B
TCTL3_EDG7A:        equ    6                                         ; Input Capture Edge Control 7A
TCTL3_EDG7B:        equ    7                                         ; Input Capture Edge Control 7B
; bit position masks
mTCTL3_EDG4A:       equ    %00000001
mTCTL3_EDG4B:       equ    %00000010
mTCTL3_EDG5A:       equ    %00000100
mTCTL3_EDG5B:       equ    %00001000
mTCTL3_EDG6A:       equ    %00010000
mTCTL3_EDG6B:       equ    %00100000
mTCTL3_EDG7A:       equ    %01000000
mTCTL3_EDG7B:       equ    %10000000


;*** TCTL4 - Timer Control Register 4; 0x0000004B ***
TCTL4:              equ    $0000004B                                ;*** TCTL4 - Timer Control Register 4; 0x0000004B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TCTL4_EDG0A:        equ    0                                         ; Input Capture Edge Control 0A
TCTL4_EDG0B:        equ    1                                         ; Input Capture Edge Control 0B
TCTL4_EDG1A:        equ    2                                         ; Input Capture Edge Control 1A
TCTL4_EDG1B:        equ    3                                         ; Input Capture Edge Control 1B
TCTL4_EDG2A:        equ    4                                         ; Input Capture Edge Control 2A
TCTL4_EDG2B:        equ    5                                         ; Input Capture Edge Control 2B
TCTL4_EDG3A:        equ    6                                         ; Input Capture Edge Control 3A
TCTL4_EDG3B:        equ    7                                         ; Input Capture Edge Control 3B
; bit position masks
mTCTL4_EDG0A:       equ    %00000001
mTCTL4_EDG0B:       equ    %00000010
mTCTL4_EDG1A:       equ    %00000100
mTCTL4_EDG1B:       equ    %00001000
mTCTL4_EDG2A:       equ    %00010000
mTCTL4_EDG2B:       equ    %00100000
mTCTL4_EDG3A:       equ    %01000000
mTCTL4_EDG3B:       equ    %10000000


;*** TIE - Timer Interrupt Enable Register; 0x0000004C ***
TIE:                equ    $0000004C                                ;*** TIE - Timer Interrupt Enable Register; 0x0000004C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TIE_C0I:            equ    0                                         ; Input Capture/Output Compare Interrupt Enable Bit 0
TIE_C1I:            equ    1                                         ; Input Capture/Output Compare Interrupt Enable Bit 1
TIE_C2I:            equ    2                                         ; Input Capture/Output Compare Interrupt Enable Bit 2
TIE_C3I:            equ    3                                         ; Input Capture/Output Compare Interrupt Enable Bit 3
TIE_C4I:            equ    4                                         ; Input Capture/Output Compare Interrupt Enable Bit 4
TIE_C5I:            equ    5                                         ; Input Capture/Output Compare Interrupt Enable Bit 5
TIE_C6I:            equ    6                                         ; Input Capture/Output Compare Interrupt Enable Bit 6
TIE_C7I:            equ    7                                         ; Input Capture/Output Compare Interrupt Enable Bit 7
; bit position masks
mTIE_C0I:           equ    %00000001
mTIE_C1I:           equ    %00000010
mTIE_C2I:           equ    %00000100
mTIE_C3I:           equ    %00001000
mTIE_C4I:           equ    %00010000
mTIE_C5I:           equ    %00100000
mTIE_C6I:           equ    %01000000
mTIE_C7I:           equ    %10000000


;*** TSCR2 - Timer System Control Register 2; 0x0000004D ***
TSCR2:              equ    $0000004D                                ;*** TSCR2 - Timer System Control Register 2; 0x0000004D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TSCR2_PR0:          equ    0                                         ; Timer Prescaler Select Bit 0
TSCR2_PR1:          equ    1                                         ; Timer Prescaler Select Bit 1
TSCR2_PR2:          equ    2                                         ; Timer Prescaler Select Bit 2
TSCR2_TCRE:         equ    3                                         ; Timer Counter Reset Enable
TSCR2_TOI:          equ    7                                         ; Timer Overflow Interrupt Enable
; bit position masks
mTSCR2_PR0:         equ    %00000001
mTSCR2_PR1:         equ    %00000010
mTSCR2_PR2:         equ    %00000100
mTSCR2_TCRE:        equ    %00001000
mTSCR2_TOI:         equ    %10000000


;*** TFLG1 - Main Timer Interrupt Flag 1; 0x0000004E ***
TFLG1:              equ    $0000004E                                ;*** TFLG1 - Main Timer Interrupt Flag 1; 0x0000004E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TFLG1_C0F:          equ    0                                         ; Input Capture/Output Compare Channel Flag 0
TFLG1_C1F:          equ    1                                         ; Input Capture/Output Compare Channel Flag 1
TFLG1_C2F:          equ    2                                         ; Input Capture/Output Compare Channel Flag 2
TFLG1_C3F:          equ    3                                         ; Input Capture/Output Compare Channel Flag 3
TFLG1_C4F:          equ    4                                         ; Input Capture/Output Compare Channel Flag 4
TFLG1_C5F:          equ    5                                         ; Input Capture/Output Compare Channel Flag 5
TFLG1_C6F:          equ    6                                         ; Input Capture/Output Compare Channel Flag 6
TFLG1_C7F:          equ    7                                         ; Input Capture/Output Compare Channel Flag 7
; bit position masks
mTFLG1_C0F:         equ    %00000001
mTFLG1_C1F:         equ    %00000010
mTFLG1_C2F:         equ    %00000100
mTFLG1_C3F:         equ    %00001000
mTFLG1_C4F:         equ    %00010000
mTFLG1_C5F:         equ    %00100000
mTFLG1_C6F:         equ    %01000000
mTFLG1_C7F:         equ    %10000000


;*** TFLG2 - Main Timer Interrupt Flag 2; 0x0000004F ***
TFLG2:              equ    $0000004F                                ;*** TFLG2 - Main Timer Interrupt Flag 2; 0x0000004F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TFLG2_TOF:          equ    7                                         ; Timer Overflow Flag
; bit position masks
mTFLG2_TOF:         equ    %10000000


;*** TC0 - Timer Input Capture/Output Compare Register 0; 0x00000050 ***
TC0:                equ    $00000050                                ;*** TC0 - Timer Input Capture/Output Compare Register 0; 0x00000050 ***


;*** TC0Hi - Timer Input Capture/Output Compare Register 0 High; 0x00000050 ***
TC0Hi:              equ    $00000050                                ;*** TC0Hi - Timer Input Capture/Output Compare Register 0 High; 0x00000050 ***


;*** TC0Lo - Timer Input Capture/Output Compare Register 0 Low; 0x00000051 ***
TC0Lo:              equ    $00000051                                ;*** TC0Lo - Timer Input Capture/Output Compare Register 0 Low; 0x00000051 ***


;*** TC1 - Timer Input Capture/Output Compare Register 1; 0x00000052 ***
TC1:                equ    $00000052                                ;*** TC1 - Timer Input Capture/Output Compare Register 1; 0x00000052 ***


;*** TC1Hi - Timer Input Capture/Output Compare Register 1 High; 0x00000052 ***
TC1Hi:              equ    $00000052                                ;*** TC1Hi - Timer Input Capture/Output Compare Register 1 High; 0x00000052 ***


;*** TC1Lo - Timer Input Capture/Output Compare Register 1 Low; 0x00000053 ***
TC1Lo:              equ    $00000053                                ;*** TC1Lo - Timer Input Capture/Output Compare Register 1 Low; 0x00000053 ***


;*** TC2 - Timer Input Capture/Output Compare Register 2; 0x00000054 ***
TC2:                equ    $00000054                                ;*** TC2 - Timer Input Capture/Output Compare Register 2; 0x00000054 ***


;*** TC2Hi - Timer Input Capture/Output Compare Register 2 High; 0x00000054 ***
TC2Hi:              equ    $00000054                                ;*** TC2Hi - Timer Input Capture/Output Compare Register 2 High; 0x00000054 ***


;*** TC2Lo - Timer Input Capture/Output Compare Register 2 Low; 0x00000055 ***
TC2Lo:              equ    $00000055                                ;*** TC2Lo - Timer Input Capture/Output Compare Register 2 Low; 0x00000055 ***


;*** TC3 - Timer Input Capture/Output Compare Register 3; 0x00000056 ***
TC3:                equ    $00000056                                ;*** TC3 - Timer Input Capture/Output Compare Register 3; 0x00000056 ***


;*** TC3Hi - Timer Input Capture/Output Compare Register 3 High; 0x00000056 ***
TC3Hi:              equ    $00000056                                ;*** TC3Hi - Timer Input Capture/Output Compare Register 3 High; 0x00000056 ***


;*** TC3Lo - Timer Input Capture/Output Compare Register 3 Low; 0x00000057 ***
TC3Lo:              equ    $00000057                                ;*** TC3Lo - Timer Input Capture/Output Compare Register 3 Low; 0x00000057 ***


;*** TC4 - Timer Input Capture/Output Compare Register 4; 0x00000058 ***
TC4:                equ    $00000058                                ;*** TC4 - Timer Input Capture/Output Compare Register 4; 0x00000058 ***


;*** TC4Hi - Timer Input Capture/Output Compare Register 4 High; 0x00000058 ***
TC4Hi:              equ    $00000058                                ;*** TC4Hi - Timer Input Capture/Output Compare Register 4 High; 0x00000058 ***


;*** TC4Lo - Timer Input Capture/Output Compare Register 4 Low; 0x00000059 ***
TC4Lo:              equ    $00000059                                ;*** TC4Lo - Timer Input Capture/Output Compare Register 4 Low; 0x00000059 ***


;*** TC5 - Timer Input Capture/Output Compare Register 5; 0x0000005A ***
TC5:                equ    $0000005A                                ;*** TC5 - Timer Input Capture/Output Compare Register 5; 0x0000005A ***


;*** TC5Hi - Timer Input Capture/Output Compare Register 5 High; 0x0000005A ***
TC5Hi:              equ    $0000005A                                ;*** TC5Hi - Timer Input Capture/Output Compare Register 5 High; 0x0000005A ***


;*** TC5Lo - Timer Input Capture/Output Compare Register 5 Low; 0x0000005B ***
TC5Lo:              equ    $0000005B                                ;*** TC5Lo - Timer Input Capture/Output Compare Register 5 Low; 0x0000005B ***


;*** TC6 - Timer Input Capture/Output Compare Register 6; 0x0000005C ***
TC6:                equ    $0000005C                                ;*** TC6 - Timer Input Capture/Output Compare Register 6; 0x0000005C ***


;*** TC6Hi - Timer Input Capture/Output Compare Register 6 High; 0x0000005C ***
TC6Hi:              equ    $0000005C                                ;*** TC6Hi - Timer Input Capture/Output Compare Register 6 High; 0x0000005C ***


;*** TC6Lo - Timer Input Capture/Output Compare Register 6 Low; 0x0000005D ***
TC6Lo:              equ    $0000005D                                ;*** TC6Lo - Timer Input Capture/Output Compare Register 6 Low; 0x0000005D ***


;*** TC7 - Timer Input Capture/Output Compare Register 7; 0x0000005E ***
TC7:                equ    $0000005E                                ;*** TC7 - Timer Input Capture/Output Compare Register 7; 0x0000005E ***


;*** TC7Hi - Timer Input Capture/Output Compare Register 7 High; 0x0000005E ***
TC7Hi:              equ    $0000005E                                ;*** TC7Hi - Timer Input Capture/Output Compare Register 7 High; 0x0000005E ***


;*** TC7Lo - Timer Input Capture/Output Compare Register 7 Low; 0x0000005F ***
TC7Lo:              equ    $0000005F                                ;*** TC7Lo - Timer Input Capture/Output Compare Register 7 Low; 0x0000005F ***


;*** PACTL - 16-Bit Pulse Accumulator A Control Register; 0x00000060 ***
PACTL:              equ    $00000060                                ;*** PACTL - 16-Bit Pulse Accumulator A Control Register; 0x00000060 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PACTL_PAI:          equ    0                                         ; Pulse Accumulator Input Interrupt enable
PACTL_PAOVI:        equ    1                                         ; Pulse Accumulator A Overflow Interrupt enable
PACTL_CLK0:         equ    2                                         ; Clock Select Bit 0
PACTL_CLK1:         equ    3                                         ; Clock Select Bit 1
PACTL_PEDGE:        equ    4                                         ; Pulse Accumulator Edge Control
PACTL_PAMOD:        equ    5                                         ; Pulse Accumulator Mode
PACTL_PAEN:         equ    6                                         ; Pulse Accumulator A System Enable
; bit position masks
mPACTL_PAI:         equ    %00000001
mPACTL_PAOVI:       equ    %00000010
mPACTL_CLK0:        equ    %00000100
mPACTL_CLK1:        equ    %00001000
mPACTL_PEDGE:       equ    %00010000
mPACTL_PAMOD:       equ    %00100000
mPACTL_PAEN:        equ    %01000000


;*** PAFLG - Pulse Accumulator A Flag Register; 0x00000061 ***
PAFLG:              equ    $00000061                                ;*** PAFLG - Pulse Accumulator A Flag Register; 0x00000061 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PAFLG_PAIF:         equ    0                                         ; Pulse Accumulator Input edge Flag
PAFLG_PAOVF:        equ    1                                         ; Pulse Accumulator A Overflow Flag
; bit position masks
mPAFLG_PAIF:        equ    %00000001
mPAFLG_PAOVF:       equ    %00000010


;*** PACNT - Pulse Accumulators Count Register; 0x00000062 ***
PACNT:              equ    $00000062                                ;*** PACNT - Pulse Accumulators Count Register; 0x00000062 ***


;*** ATDCTL01 - ATD Control Register 01; 0x00000080 ***
ATDCTL01:           equ    $00000080                                ;*** ATDCTL01 - ATD Control Register 01; 0x00000080 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDCTL01_ETRIGCH0:  equ    0                                         ; External Trigger Channel Select Bit 0
ATDCTL01_ETRIGCH1:  equ    1                                         ; External Trigger Channel Select Bit 1
ATDCTL01_ETRIGCH2:  equ    2                                         ; External Trigger Channel Select Bit 2
ATDCTL01_ETRIGCH3:  equ    3                                         ; External Trigger Channel Select Bit 3
ATDCTL01_ETRIGSEL:  equ    7                                         ; External Trigger Source Select
ATDCTL01_WRAP0:     equ    8                                         ; Wrap Around Channel Select Bit 0
ATDCTL01_WRAP1:     equ    9                                         ; Wrap Around Channel Select Bit 1
ATDCTL01_WRAP2:     equ    10                                        ; Wrap Around Channel Select Bit 2
ATDCTL01_WRAP3:     equ    11                                        ; Wrap Around Channel Select Bit 3
; bit position masks
mATDCTL01_ETRIGCH0: equ    %00000001
mATDCTL01_ETRIGCH1: equ    %00000010
mATDCTL01_ETRIGCH2: equ    %00000100
mATDCTL01_ETRIGCH3: equ    %00001000
mATDCTL01_ETRIGSEL: equ    %10000000
mATDCTL01_WRAP0:    equ    %100000000
mATDCTL01_WRAP1:    equ    %1000000000
mATDCTL01_WRAP2:    equ    %10000000000
mATDCTL01_WRAP3:    equ    %100000000000


;*** ATDCTL0 - ATD Control Register 0; 0x00000080 ***
ATDCTL0:            equ    $00000080                                ;*** ATDCTL0 - ATD Control Register 0; 0x00000080 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDCTL0_WRAP0:      equ    0                                         ; Wrap Around Channel Select Bit 0
ATDCTL0_WRAP1:      equ    1                                         ; Wrap Around Channel Select Bit 1
ATDCTL0_WRAP2:      equ    2                                         ; Wrap Around Channel Select Bit 2
ATDCTL0_WRAP3:      equ    3                                         ; Wrap Around Channel Select Bit 3
; bit position masks
mATDCTL0_WRAP0:     equ    %00000001
mATDCTL0_WRAP1:     equ    %00000010
mATDCTL0_WRAP2:     equ    %00000100
mATDCTL0_WRAP3:     equ    %00001000


;*** ATDCTL1 - ATD Control Register 1; 0x00000081 ***
ATDCTL1:            equ    $00000081                                ;*** ATDCTL1 - ATD Control Register 1; 0x00000081 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDCTL1_ETRIGCH0:   equ    0                                         ; External Trigger Channel Select Bit 0
ATDCTL1_ETRIGCH1:   equ    1                                         ; External Trigger Channel Select Bit 1
ATDCTL1_ETRIGCH2:   equ    2                                         ; External Trigger Channel Select Bit 2
ATDCTL1_ETRIGCH3:   equ    3                                         ; External Trigger Channel Select Bit 3
ATDCTL1_ETRIGSEL:   equ    7                                         ; External Trigger Source Select
; bit position masks
mATDCTL1_ETRIGCH0:  equ    %00000001
mATDCTL1_ETRIGCH1:  equ    %00000010
mATDCTL1_ETRIGCH2:  equ    %00000100
mATDCTL1_ETRIGCH3:  equ    %00001000
mATDCTL1_ETRIGSEL:  equ    %10000000


;*** ATDCTL23 - ATD Control Register 23; 0x00000082 ***
ATDCTL23:           equ    $00000082                                ;*** ATDCTL23 - ATD Control Register 23; 0x00000082 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDCTL23_FRZ0:      equ    0                                         ; Background Debug Freeze Enable Bit 0
ATDCTL23_FRZ1:      equ    1                                         ; Background Debug Freeze Enable Bit 1
ATDCTL23_FIFO:      equ    2                                         ; Result Register FIFO Mode
ATDCTL23_S1C:       equ    3                                         ; Conversion Sequence Length 1
ATDCTL23_S2C:       equ    4                                         ; Conversion Sequence Length 2
ATDCTL23_S4C:       equ    5                                         ; Conversion Sequence Length 4
ATDCTL23_S8C:       equ    6                                         ; Conversion Sequence Length 8
ATDCTL23_ASCIF:     equ    8                                         ; ATD Sequence Complete Interrupt Flag
ATDCTL23_ASCIE:     equ    9                                         ; ATD Sequence Complete Interrupt Enable
ATDCTL23_ETRIGE:    equ    10                                        ; External Trigger Mode enable
ATDCTL23_ETRIGP:    equ    11                                        ; External Trigger Polarity
ATDCTL23_ETRIGLE:   equ    12                                        ; External Trigger Level/Edge control
ATDCTL23_AWAI:      equ    13                                        ; ATD Power Down in Wait Mode
ATDCTL23_AFFC:      equ    14                                        ; ATD Fast Conversion Complete Flag Clear
ATDCTL23_ADPU:      equ    15                                        ; ATD Disable / Power Down
; bit position masks
mATDCTL23_FRZ0:     equ    %00000001
mATDCTL23_FRZ1:     equ    %00000010
mATDCTL23_FIFO:     equ    %00000100
mATDCTL23_S1C:      equ    %00001000
mATDCTL23_S2C:      equ    %00010000
mATDCTL23_S4C:      equ    %00100000
mATDCTL23_S8C:      equ    %01000000
mATDCTL23_ASCIF:    equ    %100000000
mATDCTL23_ASCIE:    equ    %1000000000
mATDCTL23_ETRIGE:   equ    %10000000000
mATDCTL23_ETRIGP:   equ    %100000000000
mATDCTL23_ETRIGLE:  equ    %1000000000000
mATDCTL23_AWAI:     equ    %10000000000000
mATDCTL23_AFFC:     equ    %100000000000000
mATDCTL23_ADPU:     equ    %1000000000000000


;*** ATDCTL2 - ATD Control Register 2; 0x00000082 ***
ATDCTL2:            equ    $00000082                                ;*** ATDCTL2 - ATD Control Register 2; 0x00000082 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDCTL2_ASCIF:      equ    0                                         ; ATD Sequence Complete Interrupt Flag
ATDCTL2_ASCIE:      equ    1                                         ; ATD Sequence Complete Interrupt Enable
ATDCTL2_ETRIGE:     equ    2                                         ; External Trigger Mode enable
ATDCTL2_ETRIGP:     equ    3                                         ; External Trigger Polarity
ATDCTL2_ETRIGLE:    equ    4                                         ; External Trigger Level/Edge control
ATDCTL2_AWAI:       equ    5                                         ; ATD Power Down in Wait Mode
ATDCTL2_AFFC:       equ    6                                         ; ATD Fast Conversion Complete Flag Clear
ATDCTL2_ADPU:       equ    7                                         ; ATD Disable / Power Down
; bit position masks
mATDCTL2_ASCIF:     equ    %00000001
mATDCTL2_ASCIE:     equ    %00000010
mATDCTL2_ETRIGE:    equ    %00000100
mATDCTL2_ETRIGP:    equ    %00001000
mATDCTL2_ETRIGLE:   equ    %00010000
mATDCTL2_AWAI:      equ    %00100000
mATDCTL2_AFFC:      equ    %01000000
mATDCTL2_ADPU:      equ    %10000000


;*** ATDCTL3 - ATD Control Register 3; 0x00000083 ***
ATDCTL3:            equ    $00000083                                ;*** ATDCTL3 - ATD Control Register 3; 0x00000083 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDCTL3_FRZ0:       equ    0                                         ; Background Debug Freeze Enable Bit 0
ATDCTL3_FRZ1:       equ    1                                         ; Background Debug Freeze Enable Bit 1
ATDCTL3_FIFO:       equ    2                                         ; Result Register FIFO Mode
ATDCTL3_S1C:        equ    3                                         ; Conversion Sequence Length 1
ATDCTL3_S2C:        equ    4                                         ; Conversion Sequence Length 2
ATDCTL3_S4C:        equ    5                                         ; Conversion Sequence Length 4
ATDCTL3_S8C:        equ    6                                         ; Conversion Sequence Length 8
; bit position masks
mATDCTL3_FRZ0:      equ    %00000001
mATDCTL3_FRZ1:      equ    %00000010
mATDCTL3_FIFO:      equ    %00000100
mATDCTL3_S1C:       equ    %00001000
mATDCTL3_S2C:       equ    %00010000
mATDCTL3_S4C:       equ    %00100000
mATDCTL3_S8C:       equ    %01000000


;*** ATDCTL45 - ATD Control Register; 0x00000084 ***
ATDCTL45:           equ    $00000084                                ;*** ATDCTL45 - ATD Control Register; 0x00000084 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDCTL45_CA:        equ    0                                         ; Analog Input Channel Select Code A
ATDCTL45_CB:        equ    1                                         ; Analog Input Channel Select Code B
ATDCTL45_CC:        equ    2                                         ; Analog Input Channel Select Code C
ATDCTL45_CD:        equ    3                                         ; Analog Input Channel Select Code D
ATDCTL45_MULT:      equ    4                                         ; Multi-Channel Sample Mode
ATDCTL45_SCAN:      equ    5                                         ; Continuous Conversion Sequence Mode
ATDCTL45_DSGN:      equ    6                                         ; Signed/Unsigned Result Data Mode
ATDCTL45_DJM:       equ    7                                         ; Result Register Data Justification Mode
ATDCTL45_PRS0:      equ    8                                         ; ATD Clock Prescaler 0
ATDCTL45_PRS1:      equ    9                                         ; ATD Clock Prescaler 1
ATDCTL45_PRS2:      equ    10                                        ; ATD Clock Prescaler 2
ATDCTL45_PRS3:      equ    11                                        ; ATD Clock Prescaler 3
ATDCTL45_PRS4:      equ    12                                        ; ATD Clock Prescaler 4
ATDCTL45_SMP0:      equ    13                                        ; Sample Time Select 0
ATDCTL45_SMP1:      equ    14                                        ; Sample Time Select 1
ATDCTL45_SRES8:     equ    15                                        ; ATD Resolution Select
; bit position masks
mATDCTL45_CA:       equ    %00000001
mATDCTL45_CB:       equ    %00000010
mATDCTL45_CC:       equ    %00000100
mATDCTL45_CD:       equ    %00001000
mATDCTL45_MULT:     equ    %00010000
mATDCTL45_SCAN:     equ    %00100000
mATDCTL45_DSGN:     equ    %01000000
mATDCTL45_DJM:      equ    %10000000
mATDCTL45_PRS0:     equ    %100000000
mATDCTL45_PRS1:     equ    %1000000000
mATDCTL45_PRS2:     equ    %10000000000
mATDCTL45_PRS3:     equ    %100000000000
mATDCTL45_PRS4:     equ    %1000000000000
mATDCTL45_SMP0:     equ    %10000000000000
mATDCTL45_SMP1:     equ    %100000000000000
mATDCTL45_SRES8:    equ    %1000000000000000


;*** ATDCTL4 - ATD Control Register 4; 0x00000084 ***
ATDCTL4:            equ    $00000084                                ;*** ATDCTL4 - ATD Control Register 4; 0x00000084 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDCTL4_PRS0:       equ    0                                         ; ATD Clock Prescaler 0
ATDCTL4_PRS1:       equ    1                                         ; ATD Clock Prescaler 1
ATDCTL4_PRS2:       equ    2                                         ; ATD Clock Prescaler 2
ATDCTL4_PRS3:       equ    3                                         ; ATD Clock Prescaler 3
ATDCTL4_PRS4:       equ    4                                         ; ATD Clock Prescaler 4
ATDCTL4_SMP0:       equ    5                                         ; Sample Time Select 0
ATDCTL4_SMP1:       equ    6                                         ; Sample Time Select 1
ATDCTL4_SRES8:      equ    7                                         ; ATD Resolution Select
; bit position masks
mATDCTL4_PRS0:      equ    %00000001
mATDCTL4_PRS1:      equ    %00000010
mATDCTL4_PRS2:      equ    %00000100
mATDCTL4_PRS3:      equ    %00001000
mATDCTL4_PRS4:      equ    %00010000
mATDCTL4_SMP0:      equ    %00100000
mATDCTL4_SMP1:      equ    %01000000
mATDCTL4_SRES8:     equ    %10000000


;*** ATDCTL5 - ATD Control Register 5; 0x00000085 ***
ATDCTL5:            equ    $00000085                                ;*** ATDCTL5 - ATD Control Register 5; 0x00000085 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDCTL5_CA:         equ    0                                         ; Analog Input Channel Select Code A
ATDCTL5_CB:         equ    1                                         ; Analog Input Channel Select Code B
ATDCTL5_CC:         equ    2                                         ; Analog Input Channel Select Code C
ATDCTL5_CD:         equ    3                                         ; Analog Input Channel Select Code D
ATDCTL5_MULT:       equ    4                                         ; Multi-Channel Sample Mode
ATDCTL5_SCAN:       equ    5                                         ; Continuous Conversion Sequence Mode
ATDCTL5_DSGN:       equ    6                                         ; Signed/Unsigned Result Data Mode
ATDCTL5_DJM:        equ    7                                         ; Result Register Data Justification Mode
; bit position masks
mATDCTL5_CA:        equ    %00000001
mATDCTL5_CB:        equ    %00000010
mATDCTL5_CC:        equ    %00000100
mATDCTL5_CD:        equ    %00001000
mATDCTL5_MULT:      equ    %00010000
mATDCTL5_SCAN:      equ    %00100000
mATDCTL5_DSGN:      equ    %01000000
mATDCTL5_DJM:       equ    %10000000


;*** ATDSTAT0 - ATD Status Register 0; 0x00000086 ***
ATDSTAT0:           equ    $00000086                                ;*** ATDSTAT0 - ATD Status Register 0; 0x00000086 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDSTAT0_CC0:       equ    0                                         ; Conversion Counter 0
ATDSTAT0_CC1:       equ    1                                         ; Conversion Counter 1
ATDSTAT0_CC2:       equ    2                                         ; Conversion Counter 2
ATDSTAT0_CC3:       equ    3                                         ; Conversion Counter 3
ATDSTAT0_FIFOR:     equ    4                                         ; FIFO Over Run Flag
ATDSTAT0_ETORF:     equ    5                                         ; External Trigger Overrun Flag
ATDSTAT0_SCF:       equ    7                                         ; Sequence Complete Flag
; bit position masks
mATDSTAT0_CC0:      equ    %00000001
mATDSTAT0_CC1:      equ    %00000010
mATDSTAT0_CC2:      equ    %00000100
mATDSTAT0_CC3:      equ    %00001000
mATDSTAT0_FIFOR:    equ    %00010000
mATDSTAT0_ETORF:    equ    %00100000
mATDSTAT0_SCF:      equ    %10000000


;*** ATDTEST1 - ATD Test Register; 0x00000089 ***
ATDTEST1:           equ    $00000089                                ;*** ATDTEST1 - ATD Test Register; 0x00000089 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDTEST1_SC:        equ    0                                         ; Special Channel Conversion Bit
; bit position masks
mATDTEST1_SC:       equ    %00000001


;*** ATDSTAT2 - ATD Status Register 2; 0x0000008A ***
ATDSTAT2:           equ    $0000008A                                ;*** ATDSTAT2 - ATD Status Register 2; 0x0000008A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDSTAT2_CCF8:      equ    0                                         ; Conversion Complete Flag 8
ATDSTAT2_CCF9:      equ    1                                         ; Conversion Complete Flag 9
ATDSTAT2_CCF10:     equ    2                                         ; Conversion Complete Flag 10
ATDSTAT2_CCF11:     equ    3                                         ; Conversion Complete Flag 11
ATDSTAT2_CCF12:     equ    4                                         ; Conversion Complete Flag 12
ATDSTAT2_CCF13:     equ    5                                         ; Conversion Complete Flag 13
ATDSTAT2_CCF14:     equ    6                                         ; Conversion Complete Flag 14
ATDSTAT2_CCF15:     equ    7                                         ; Conversion Complete Flag 15
; bit position masks
mATDSTAT2_CCF8:     equ    %00000001
mATDSTAT2_CCF9:     equ    %00000010
mATDSTAT2_CCF10:    equ    %00000100
mATDSTAT2_CCF11:    equ    %00001000
mATDSTAT2_CCF12:    equ    %00010000
mATDSTAT2_CCF13:    equ    %00100000
mATDSTAT2_CCF14:    equ    %01000000
mATDSTAT2_CCF15:    equ    %10000000


;*** ATDSTAT1 - ATD Status Register 1; 0x0000008B ***
ATDSTAT1:           equ    $0000008B                                ;*** ATDSTAT1 - ATD Status Register 1; 0x0000008B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDSTAT1_CCF0:      equ    0                                         ; Conversion Complete Flag 0
ATDSTAT1_CCF1:      equ    1                                         ; Conversion Complete Flag 1
ATDSTAT1_CCF2:      equ    2                                         ; Conversion Complete Flag 2
ATDSTAT1_CCF3:      equ    3                                         ; Conversion Complete Flag 3
ATDSTAT1_CCF4:      equ    4                                         ; Conversion Complete Flag 4
ATDSTAT1_CCF5:      equ    5                                         ; Conversion Complete Flag 5
ATDSTAT1_CCF6:      equ    6                                         ; Conversion Complete Flag 6
ATDSTAT1_CCF7:      equ    7                                         ; Conversion Complete Flag 7
; bit position masks
mATDSTAT1_CCF0:     equ    %00000001
mATDSTAT1_CCF1:     equ    %00000010
mATDSTAT1_CCF2:     equ    %00000100
mATDSTAT1_CCF3:     equ    %00001000
mATDSTAT1_CCF4:     equ    %00010000
mATDSTAT1_CCF5:     equ    %00100000
mATDSTAT1_CCF6:     equ    %01000000
mATDSTAT1_CCF7:     equ    %10000000


;*** ATDDIEN - ATD Input Enable Register; 0x0000008C ***
ATDDIEN:            equ    $0000008C                                ;*** ATDDIEN - ATD Input Enable Register; 0x0000008C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDIEN_IEN0:       equ    0                                         ; ATD Digital Input Enable on channel 0
ATDDIEN_IEN1:       equ    1                                         ; ATD Digital Input Enable on channel 1
ATDDIEN_IEN2:       equ    2                                         ; ATD Digital Input Enable on channel 2
ATDDIEN_IEN3:       equ    3                                         ; ATD Digital Input Enable on channel 3
ATDDIEN_IEN4:       equ    4                                         ; ATD Digital Input Enable on channel 4
ATDDIEN_IEN5:       equ    5                                         ; ATD Digital Input Enable on channel 5
ATDDIEN_IEN6:       equ    6                                         ; ATD Digital Input Enable on channel 6
ATDDIEN_IEN7:       equ    7                                         ; ATD Digital Input Enable on channel 7
ATDDIEN_IEN8:       equ    8                                         ; ATD Digital Input Enable on channel 8
ATDDIEN_IEN9:       equ    9                                         ; ATD Digital Input Enable on channel 9
ATDDIEN_IEN10:      equ    10                                        ; ATD Digital Input Enable on channel 10
ATDDIEN_IEN11:      equ    11                                        ; ATD Digital Input Enable on channel 11
ATDDIEN_IEN12:      equ    12                                        ; ATD Digital Input Enable on channel 12
ATDDIEN_IEN13:      equ    13                                        ; ATD Digital Input Enable on channel 13
ATDDIEN_IEN14:      equ    14                                        ; ATD Digital Input Enable on channel 14
ATDDIEN_IEN15:      equ    15                                        ; ATD Digital Input Enable on channel 15
; bit position masks
mATDDIEN_IEN0:      equ    %00000001
mATDDIEN_IEN1:      equ    %00000010
mATDDIEN_IEN2:      equ    %00000100
mATDDIEN_IEN3:      equ    %00001000
mATDDIEN_IEN4:      equ    %00010000
mATDDIEN_IEN5:      equ    %00100000
mATDDIEN_IEN6:      equ    %01000000
mATDDIEN_IEN7:      equ    %10000000
mATDDIEN_IEN8:      equ    %100000000
mATDDIEN_IEN9:      equ    %1000000000
mATDDIEN_IEN10:     equ    %10000000000
mATDDIEN_IEN11:     equ    %100000000000
mATDDIEN_IEN12:     equ    %1000000000000
mATDDIEN_IEN13:     equ    %10000000000000
mATDDIEN_IEN14:     equ    %100000000000000
mATDDIEN_IEN15:     equ    %1000000000000000


;*** ATDDIEN0 - ATD Input Enable Register 0; 0x0000008C ***
ATDDIEN0:           equ    $0000008C                                ;*** ATDDIEN0 - ATD Input Enable Register 0; 0x0000008C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDIEN0_IEN8:      equ    0                                         ; ATD Digital Input Enable on channel 8
ATDDIEN0_IEN9:      equ    1                                         ; ATD Digital Input Enable on channel 9
ATDDIEN0_IEN10:     equ    2                                         ; ATD Digital Input Enable on channel 10
ATDDIEN0_IEN11:     equ    3                                         ; ATD Digital Input Enable on channel 11
ATDDIEN0_IEN12:     equ    4                                         ; ATD Digital Input Enable on channel 12
ATDDIEN0_IEN13:     equ    5                                         ; ATD Digital Input Enable on channel 13
ATDDIEN0_IEN14:     equ    6                                         ; ATD Digital Input Enable on channel 14
ATDDIEN0_IEN15:     equ    7                                         ; ATD Digital Input Enable on channel 15
; bit position masks
mATDDIEN0_IEN8:     equ    %00000001
mATDDIEN0_IEN9:     equ    %00000010
mATDDIEN0_IEN10:    equ    %00000100
mATDDIEN0_IEN11:    equ    %00001000
mATDDIEN0_IEN12:    equ    %00010000
mATDDIEN0_IEN13:    equ    %00100000
mATDDIEN0_IEN14:    equ    %01000000
mATDDIEN0_IEN15:    equ    %10000000


;*** ATDDIEN1 - ATD Input Enable Register 1; 0x0000008D ***
ATDDIEN1:           equ    $0000008D                                ;*** ATDDIEN1 - ATD Input Enable Register 1; 0x0000008D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDIEN1_IEN0:      equ    0                                         ; ATD Digital Input Enable on channel 0
ATDDIEN1_IEN1:      equ    1                                         ; ATD Digital Input Enable on channel 1
ATDDIEN1_IEN2:      equ    2                                         ; ATD Digital Input Enable on channel 2
ATDDIEN1_IEN3:      equ    3                                         ; ATD Digital Input Enable on channel 3
ATDDIEN1_IEN4:      equ    4                                         ; ATD Digital Input Enable on channel 4
ATDDIEN1_IEN5:      equ    5                                         ; ATD Digital Input Enable on channel 5
ATDDIEN1_IEN6:      equ    6                                         ; ATD Digital Input Enable on channel 6
ATDDIEN1_IEN7:      equ    7                                         ; ATD Digital Input Enable on channel 7
; bit position masks
mATDDIEN1_IEN0:     equ    %00000001
mATDDIEN1_IEN1:     equ    %00000010
mATDDIEN1_IEN2:     equ    %00000100
mATDDIEN1_IEN3:     equ    %00001000
mATDDIEN1_IEN4:     equ    %00010000
mATDDIEN1_IEN5:     equ    %00100000
mATDDIEN1_IEN6:     equ    %01000000
mATDDIEN1_IEN7:     equ    %10000000


;*** PORTAD - Port AD0 Data; 0x0000008E ***
PORTAD:             equ    $0000008E                                ;*** PORTAD - Port AD0 Data; 0x0000008E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PORTAD_PTAD0:       equ    0                                         ; A/D Channel 0 (AN0) Digital Input
PORTAD_PTAD1:       equ    1                                         ; A/D Channel 1 (AN1) Digital Input
PORTAD_PTAD2:       equ    2                                         ; A/D Channel 2 (AN2) Digital Input
PORTAD_PTAD3:       equ    3                                         ; A/D Channel 3 (AN3) Digital Input
PORTAD_PTAD4:       equ    4                                         ; A/D Channel 4 (AN4) Digital Input
PORTAD_PTAD5:       equ    5                                         ; A/D Channel 5 (AN5) Digital Input
PORTAD_PTAD6:       equ    6                                         ; A/D Channel 6 (AN6) Digital Input
PORTAD_PTAD7:       equ    7                                         ; A/D Channel 7 (AN7) Digital Input
PORTAD_PTAD8:       equ    8                                         ; A/D Channel 8 (AN8) Digital Input
PORTAD_PTAD9:       equ    9                                         ; A/D Channel 9 (AN9) Digital Input
PORTAD_PTAD10:      equ    10                                        ; A/D Channel 10 (AN10) Digital Input
PORTAD_PTAD11:      equ    11                                        ; A/D Channel 11 (AN11) Digital Input
PORTAD_PTAD12:      equ    12                                        ; A/D Channel 12 (AN12) Digital Input
PORTAD_PTAD13:      equ    13                                        ; A/D Channel 13 (AN13) Digital Input
PORTAD_PTAD14:      equ    14                                        ; A/D Channel 14 (AN14) Digital Input
PORTAD_PTAD15:      equ    15                                        ; A/D Channel 15 (AN15) Digital Input
; bit position masks
mPORTAD_PTAD0:      equ    %00000001
mPORTAD_PTAD1:      equ    %00000010
mPORTAD_PTAD2:      equ    %00000100
mPORTAD_PTAD3:      equ    %00001000
mPORTAD_PTAD4:      equ    %00010000
mPORTAD_PTAD5:      equ    %00100000
mPORTAD_PTAD6:      equ    %01000000
mPORTAD_PTAD7:      equ    %10000000
mPORTAD_PTAD8:      equ    %100000000
mPORTAD_PTAD9:      equ    %1000000000
mPORTAD_PTAD10:     equ    %10000000000
mPORTAD_PTAD11:     equ    %100000000000
mPORTAD_PTAD12:     equ    %1000000000000
mPORTAD_PTAD13:     equ    %10000000000000
mPORTAD_PTAD14:     equ    %100000000000000
mPORTAD_PTAD15:     equ    %1000000000000000


;*** PORTAD0 - Port AD0 Data Register; 0x0000008E ***
PORTAD0:            equ    $0000008E                                ;*** PORTAD0 - Port AD0 Data Register; 0x0000008E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PORTAD0_PTAD8:      equ    0                                         ; A/D Channel 8 (AN8) Digital Input
PORTAD0_PTAD9:      equ    1                                         ; A/D Channel 9 (AN9) Digital Input
PORTAD0_PTAD10:     equ    2                                         ; A/D Channel 10 (AN10) Digital Input
PORTAD0_PTAD11:     equ    3                                         ; A/D Channel 11 (AN11) Digital Input
PORTAD0_PTAD12:     equ    4                                         ; A/D Channel 12 (AN12) Digital Input
PORTAD0_PTAD13:     equ    5                                         ; A/D Channel 13 (AN13) Digital Input
PORTAD0_PTAD14:     equ    6                                         ; A/D Channel 14 (AN14) Digital Input
PORTAD0_PTAD15:     equ    7                                         ; A/D Channel 15 (AN15) Digital Input
; bit position masks
mPORTAD0_PTAD8:     equ    %00000001
mPORTAD0_PTAD9:     equ    %00000010
mPORTAD0_PTAD10:    equ    %00000100
mPORTAD0_PTAD11:    equ    %00001000
mPORTAD0_PTAD12:    equ    %00010000
mPORTAD0_PTAD13:    equ    %00100000
mPORTAD0_PTAD14:    equ    %01000000
mPORTAD0_PTAD15:    equ    %10000000


;*** PORTAD1 - Port AD1 Data Register; 0x0000008F ***
PORTAD1:            equ    $0000008F                                ;*** PORTAD1 - Port AD1 Data Register; 0x0000008F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PORTAD1_PTAD0:      equ    0                                         ; A/D Channel 0 (AN0) Digital Input
PORTAD1_PTAD1:      equ    1                                         ; A/D Channel 1 (AN1) Digital Input
PORTAD1_PTAD2:      equ    2                                         ; A/D Channel 2 (AN2) Digital Input
PORTAD1_PTAD3:      equ    3                                         ; A/D Channel 3 (AN3) Digital Input
PORTAD1_PTAD4:      equ    4                                         ; A/D Channel 4 (AN4) Digital Input
PORTAD1_PTAD5:      equ    5                                         ; A/D Channel 5 (AN5) Digital Input
PORTAD1_PTAD6:      equ    6                                         ; A/D Channel 6 (AN6) Digital Input
PORTAD1_PTAD7:      equ    7                                         ; A/D Channel 7 (AN7) Digital Input
; bit position masks
mPORTAD1_PTAD0:     equ    %00000001
mPORTAD1_PTAD1:     equ    %00000010
mPORTAD1_PTAD2:     equ    %00000100
mPORTAD1_PTAD3:     equ    %00001000
mPORTAD1_PTAD4:     equ    %00010000
mPORTAD1_PTAD5:     equ    %00100000
mPORTAD1_PTAD6:     equ    %01000000
mPORTAD1_PTAD7:     equ    %10000000


;*** ATDDR0 - ATD Conversion Result Register 0; 0x00000090 ***
ATDDR0:             equ    $00000090                                ;*** ATDDR0 - ATD Conversion Result Register 0; 0x00000090 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR0_BIT0:        equ    0                                         ; ATD Conversion Result Bit 0
ATDDR0_BIT1:        equ    1                                         ; ATD Conversion Result Bit 1
ATDDR0_BIT2:        equ    2                                         ; ATD Conversion Result Bit 2
ATDDR0_BIT3:        equ    3                                         ; ATD Conversion Result Bit 3
ATDDR0_BIT4:        equ    4                                         ; ATD Conversion Result Bit 4
ATDDR0_BIT5:        equ    5                                         ; ATD Conversion Result Bit 5
ATDDR0_BIT6:        equ    6                                         ; ATD Conversion Result Bit 6
ATDDR0_BIT7:        equ    7                                         ; ATD Conversion Result Bit 7
ATDDR0_BIT8:        equ    8                                         ; ATD Conversion Result Bit 8
ATDDR0_BIT9:        equ    9                                         ; ATD Conversion Result Bit 9
ATDDR0_BIT10:       equ    10                                        ; ATD Conversion Result Bit 10
ATDDR0_BIT11:       equ    11                                        ; ATD Conversion Result Bit 11
ATDDR0_BIT12:       equ    12                                        ; ATD Conversion Result Bit 12
ATDDR0_BIT13:       equ    13                                        ; ATD Conversion Result Bit 13
ATDDR0_BIT14:       equ    14                                        ; ATD Conversion Result Bit 14
ATDDR0_BIT15:       equ    15                                        ; ATD Conversion Result Bit 15
; bit position masks
mATDDR0_BIT0:       equ    %00000001
mATDDR0_BIT1:       equ    %00000010
mATDDR0_BIT2:       equ    %00000100
mATDDR0_BIT3:       equ    %00001000
mATDDR0_BIT4:       equ    %00010000
mATDDR0_BIT5:       equ    %00100000
mATDDR0_BIT6:       equ    %01000000
mATDDR0_BIT7:       equ    %10000000
mATDDR0_BIT8:       equ    %100000000
mATDDR0_BIT9:       equ    %1000000000
mATDDR0_BIT10:      equ    %10000000000
mATDDR0_BIT11:      equ    %100000000000
mATDDR0_BIT12:      equ    %1000000000000
mATDDR0_BIT13:      equ    %10000000000000
mATDDR0_BIT14:      equ    %100000000000000
mATDDR0_BIT15:      equ    %1000000000000000


;*** ATDDR0H - ATD Conversion Result Register 0 High; 0x00000090 ***
ATDDR0H:            equ    $00000090                                ;*** ATDDR0H - ATD Conversion Result Register 0 High; 0x00000090 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR0H_BIT8:       equ    0                                         ; ATD Conversion Result Bit 8
ATDDR0H_BIT9:       equ    1                                         ; ATD Conversion Result Bit 9
ATDDR0H_BIT10:      equ    2                                         ; ATD Conversion Result Bit 10
ATDDR0H_BIT11:      equ    3                                         ; ATD Conversion Result Bit 11
ATDDR0H_BIT12:      equ    4                                         ; ATD Conversion Result Bit 12
ATDDR0H_BIT13:      equ    5                                         ; ATD Conversion Result Bit 13
ATDDR0H_BIT14:      equ    6                                         ; ATD Conversion Result Bit 14
ATDDR0H_BIT15:      equ    7                                         ; ATD Conversion Result Bit 15
; bit position masks
mATDDR0H_BIT8:      equ    %00000001
mATDDR0H_BIT9:      equ    %00000010
mATDDR0H_BIT10:     equ    %00000100
mATDDR0H_BIT11:     equ    %00001000
mATDDR0H_BIT12:     equ    %00010000
mATDDR0H_BIT13:     equ    %00100000
mATDDR0H_BIT14:     equ    %01000000
mATDDR0H_BIT15:     equ    %10000000


;*** ATDDR0L - ATD Conversion Result Register 0 Low; 0x00000091 ***
ATDDR0L:            equ    $00000091                                ;*** ATDDR0L - ATD Conversion Result Register 0 Low; 0x00000091 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR0L_BIT0:       equ    0                                         ; ATD Conversion Result Bit 0
ATDDR0L_BIT1:       equ    1                                         ; ATD Conversion Result Bit 1
ATDDR0L_BIT2:       equ    2                                         ; ATD Conversion Result Bit 2
ATDDR0L_BIT3:       equ    3                                         ; ATD Conversion Result Bit 3
ATDDR0L_BIT4:       equ    4                                         ; ATD Conversion Result Bit 4
ATDDR0L_BIT5:       equ    5                                         ; ATD Conversion Result Bit 5
ATDDR0L_BIT6:       equ    6                                         ; ATD Conversion Result Bit 6
ATDDR0L_BIT7:       equ    7                                         ; ATD Conversion Result Bit 7
; bit position masks
mATDDR0L_BIT0:      equ    %00000001
mATDDR0L_BIT1:      equ    %00000010
mATDDR0L_BIT2:      equ    %00000100
mATDDR0L_BIT3:      equ    %00001000
mATDDR0L_BIT4:      equ    %00010000
mATDDR0L_BIT5:      equ    %00100000
mATDDR0L_BIT6:      equ    %01000000
mATDDR0L_BIT7:      equ    %10000000


;*** ATDDR1 - ATD Conversion Result Register 1; 0x00000092 ***
ATDDR1:             equ    $00000092                                ;*** ATDDR1 - ATD Conversion Result Register 1; 0x00000092 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR1_BIT0:        equ    0                                         ; ATD Conversion Result Bit 0
ATDDR1_BIT1:        equ    1                                         ; ATD Conversion Result Bit 1
ATDDR1_BIT2:        equ    2                                         ; ATD Conversion Result Bit 2
ATDDR1_BIT3:        equ    3                                         ; ATD Conversion Result Bit 3
ATDDR1_BIT4:        equ    4                                         ; ATD Conversion Result Bit 4
ATDDR1_BIT5:        equ    5                                         ; ATD Conversion Result Bit 5
ATDDR1_BIT6:        equ    6                                         ; ATD Conversion Result Bit 6
ATDDR1_BIT7:        equ    7                                         ; ATD Conversion Result Bit 7
ATDDR1_BIT8:        equ    8                                         ; ATD Conversion Result Bit 8
ATDDR1_BIT9:        equ    9                                         ; ATD Conversion Result Bit 9
ATDDR1_BIT10:       equ    10                                        ; ATD Conversion Result Bit 10
ATDDR1_BIT11:       equ    11                                        ; ATD Conversion Result Bit 11
ATDDR1_BIT12:       equ    12                                        ; ATD Conversion Result Bit 12
ATDDR1_BIT13:       equ    13                                        ; ATD Conversion Result Bit 13
ATDDR1_BIT14:       equ    14                                        ; ATD Conversion Result Bit 14
ATDDR1_BIT15:       equ    15                                        ; ATD Conversion Result Bit 15
; bit position masks
mATDDR1_BIT0:       equ    %00000001
mATDDR1_BIT1:       equ    %00000010
mATDDR1_BIT2:       equ    %00000100
mATDDR1_BIT3:       equ    %00001000
mATDDR1_BIT4:       equ    %00010000
mATDDR1_BIT5:       equ    %00100000
mATDDR1_BIT6:       equ    %01000000
mATDDR1_BIT7:       equ    %10000000
mATDDR1_BIT8:       equ    %100000000
mATDDR1_BIT9:       equ    %1000000000
mATDDR1_BIT10:      equ    %10000000000
mATDDR1_BIT11:      equ    %100000000000
mATDDR1_BIT12:      equ    %1000000000000
mATDDR1_BIT13:      equ    %10000000000000
mATDDR1_BIT14:      equ    %100000000000000
mATDDR1_BIT15:      equ    %1000000000000000


;*** ATDDR1H - ATD Conversion Result Register 1 High; 0x00000092 ***
ATDDR1H:            equ    $00000092                                ;*** ATDDR1H - ATD Conversion Result Register 1 High; 0x00000092 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR1H_BIT8:       equ    0                                         ; ATD Conversion Result Bit 8
ATDDR1H_BIT9:       equ    1                                         ; ATD Conversion Result Bit 9
ATDDR1H_BIT10:      equ    2                                         ; ATD Conversion Result Bit 10
ATDDR1H_BIT11:      equ    3                                         ; ATD Conversion Result Bit 11
ATDDR1H_BIT12:      equ    4                                         ; ATD Conversion Result Bit 12
ATDDR1H_BIT13:      equ    5                                         ; ATD Conversion Result Bit 13
ATDDR1H_BIT14:      equ    6                                         ; ATD Conversion Result Bit 14
ATDDR1H_BIT15:      equ    7                                         ; ATD Conversion Result Bit 15
; bit position masks
mATDDR1H_BIT8:      equ    %00000001
mATDDR1H_BIT9:      equ    %00000010
mATDDR1H_BIT10:     equ    %00000100
mATDDR1H_BIT11:     equ    %00001000
mATDDR1H_BIT12:     equ    %00010000
mATDDR1H_BIT13:     equ    %00100000
mATDDR1H_BIT14:     equ    %01000000
mATDDR1H_BIT15:     equ    %10000000


;*** ATDDR1L - ATD Conversion Result Register 1 Low; 0x00000093 ***
ATDDR1L:            equ    $00000093                                ;*** ATDDR1L - ATD Conversion Result Register 1 Low; 0x00000093 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR1L_BIT0:       equ    0                                         ; ATD Conversion Result Bit 0
ATDDR1L_BIT1:       equ    1                                         ; ATD Conversion Result Bit 1
ATDDR1L_BIT2:       equ    2                                         ; ATD Conversion Result Bit 2
ATDDR1L_BIT3:       equ    3                                         ; ATD Conversion Result Bit 3
ATDDR1L_BIT4:       equ    4                                         ; ATD Conversion Result Bit 4
ATDDR1L_BIT5:       equ    5                                         ; ATD Conversion Result Bit 5
ATDDR1L_BIT6:       equ    6                                         ; ATD Conversion Result Bit 6
ATDDR1L_BIT7:       equ    7                                         ; ATD Conversion Result Bit 7
; bit position masks
mATDDR1L_BIT0:      equ    %00000001
mATDDR1L_BIT1:      equ    %00000010
mATDDR1L_BIT2:      equ    %00000100
mATDDR1L_BIT3:      equ    %00001000
mATDDR1L_BIT4:      equ    %00010000
mATDDR1L_BIT5:      equ    %00100000
mATDDR1L_BIT6:      equ    %01000000
mATDDR1L_BIT7:      equ    %10000000


;*** ATDDR2 - ATD Conversion Result Register 2; 0x00000094 ***
ATDDR2:             equ    $00000094                                ;*** ATDDR2 - ATD Conversion Result Register 2; 0x00000094 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR2_BIT0:        equ    0                                         ; ATD Conversion Result Bit 0
ATDDR2_BIT1:        equ    1                                         ; ATD Conversion Result Bit 1
ATDDR2_BIT2:        equ    2                                         ; ATD Conversion Result Bit 2
ATDDR2_BIT3:        equ    3                                         ; ATD Conversion Result Bit 3
ATDDR2_BIT4:        equ    4                                         ; ATD Conversion Result Bit 4
ATDDR2_BIT5:        equ    5                                         ; ATD Conversion Result Bit 5
ATDDR2_BIT6:        equ    6                                         ; ATD Conversion Result Bit 6
ATDDR2_BIT7:        equ    7                                         ; ATD Conversion Result Bit 7
ATDDR2_BIT8:        equ    8                                         ; ATD Conversion Result Bit 8
ATDDR2_BIT9:        equ    9                                         ; ATD Conversion Result Bit 9
ATDDR2_BIT10:       equ    10                                        ; ATD Conversion Result Bit 10
ATDDR2_BIT11:       equ    11                                        ; ATD Conversion Result Bit 11
ATDDR2_BIT12:       equ    12                                        ; ATD Conversion Result Bit 12
ATDDR2_BIT13:       equ    13                                        ; ATD Conversion Result Bit 13
ATDDR2_BIT14:       equ    14                                        ; ATD Conversion Result Bit 14
ATDDR2_BIT15:       equ    15                                        ; ATD Conversion Result Bit 15
; bit position masks
mATDDR2_BIT0:       equ    %00000001
mATDDR2_BIT1:       equ    %00000010
mATDDR2_BIT2:       equ    %00000100
mATDDR2_BIT3:       equ    %00001000
mATDDR2_BIT4:       equ    %00010000
mATDDR2_BIT5:       equ    %00100000
mATDDR2_BIT6:       equ    %01000000
mATDDR2_BIT7:       equ    %10000000
mATDDR2_BIT8:       equ    %100000000
mATDDR2_BIT9:       equ    %1000000000
mATDDR2_BIT10:      equ    %10000000000
mATDDR2_BIT11:      equ    %100000000000
mATDDR2_BIT12:      equ    %1000000000000
mATDDR2_BIT13:      equ    %10000000000000
mATDDR2_BIT14:      equ    %100000000000000
mATDDR2_BIT15:      equ    %1000000000000000


;*** ATDDR2H - ATD Conversion Result Register 2 High; 0x00000094 ***
ATDDR2H:            equ    $00000094                                ;*** ATDDR2H - ATD Conversion Result Register 2 High; 0x00000094 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR2H_BIT8:       equ    0                                         ; ATD Conversion Result Bit 8
ATDDR2H_BIT9:       equ    1                                         ; ATD Conversion Result Bit 9
ATDDR2H_BIT10:      equ    2                                         ; ATD Conversion Result Bit 10
ATDDR2H_BIT11:      equ    3                                         ; ATD Conversion Result Bit 11
ATDDR2H_BIT12:      equ    4                                         ; ATD Conversion Result Bit 12
ATDDR2H_BIT13:      equ    5                                         ; ATD Conversion Result Bit 13
ATDDR2H_BIT14:      equ    6                                         ; ATD Conversion Result Bit 14
ATDDR2H_BIT15:      equ    7                                         ; ATD Conversion Result Bit 15
; bit position masks
mATDDR2H_BIT8:      equ    %00000001
mATDDR2H_BIT9:      equ    %00000010
mATDDR2H_BIT10:     equ    %00000100
mATDDR2H_BIT11:     equ    %00001000
mATDDR2H_BIT12:     equ    %00010000
mATDDR2H_BIT13:     equ    %00100000
mATDDR2H_BIT14:     equ    %01000000
mATDDR2H_BIT15:     equ    %10000000


;*** ATDDR2L - ATD Conversion Result Register 2 Low; 0x00000095 ***
ATDDR2L:            equ    $00000095                                ;*** ATDDR2L - ATD Conversion Result Register 2 Low; 0x00000095 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR2L_BIT0:       equ    0                                         ; ATD Conversion Result Bit 0
ATDDR2L_BIT1:       equ    1                                         ; ATD Conversion Result Bit 1
ATDDR2L_BIT2:       equ    2                                         ; ATD Conversion Result Bit 2
ATDDR2L_BIT3:       equ    3                                         ; ATD Conversion Result Bit 3
ATDDR2L_BIT4:       equ    4                                         ; ATD Conversion Result Bit 4
ATDDR2L_BIT5:       equ    5                                         ; ATD Conversion Result Bit 5
ATDDR2L_BIT6:       equ    6                                         ; ATD Conversion Result Bit 6
ATDDR2L_BIT7:       equ    7                                         ; ATD Conversion Result Bit 7
; bit position masks
mATDDR2L_BIT0:      equ    %00000001
mATDDR2L_BIT1:      equ    %00000010
mATDDR2L_BIT2:      equ    %00000100
mATDDR2L_BIT3:      equ    %00001000
mATDDR2L_BIT4:      equ    %00010000
mATDDR2L_BIT5:      equ    %00100000
mATDDR2L_BIT6:      equ    %01000000
mATDDR2L_BIT7:      equ    %10000000


;*** ATDDR3 - ATD Conversion Result Register 3; 0x00000096 ***
ATDDR3:             equ    $00000096                                ;*** ATDDR3 - ATD Conversion Result Register 3; 0x00000096 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR3_BIT0:        equ    0                                         ; ATD Conversion Result Bit 0
ATDDR3_BIT1:        equ    1                                         ; ATD Conversion Result Bit 1
ATDDR3_BIT2:        equ    2                                         ; ATD Conversion Result Bit 2
ATDDR3_BIT3:        equ    3                                         ; ATD Conversion Result Bit 3
ATDDR3_BIT4:        equ    4                                         ; ATD Conversion Result Bit 4
ATDDR3_BIT5:        equ    5                                         ; ATD Conversion Result Bit 5
ATDDR3_BIT6:        equ    6                                         ; ATD Conversion Result Bit 6
ATDDR3_BIT7:        equ    7                                         ; ATD Conversion Result Bit 7
ATDDR3_BIT8:        equ    8                                         ; ATD Conversion Result Bit 8
ATDDR3_BIT9:        equ    9                                         ; ATD Conversion Result Bit 9
ATDDR3_BIT10:       equ    10                                        ; ATD Conversion Result Bit 10
ATDDR3_BIT11:       equ    11                                        ; ATD Conversion Result Bit 11
ATDDR3_BIT12:       equ    12                                        ; ATD Conversion Result Bit 12
ATDDR3_BIT13:       equ    13                                        ; ATD Conversion Result Bit 13
ATDDR3_BIT14:       equ    14                                        ; ATD Conversion Result Bit 14
ATDDR3_BIT15:       equ    15                                        ; ATD Conversion Result Bit 15
; bit position masks
mATDDR3_BIT0:       equ    %00000001
mATDDR3_BIT1:       equ    %00000010
mATDDR3_BIT2:       equ    %00000100
mATDDR3_BIT3:       equ    %00001000
mATDDR3_BIT4:       equ    %00010000
mATDDR3_BIT5:       equ    %00100000
mATDDR3_BIT6:       equ    %01000000
mATDDR3_BIT7:       equ    %10000000
mATDDR3_BIT8:       equ    %100000000
mATDDR3_BIT9:       equ    %1000000000
mATDDR3_BIT10:      equ    %10000000000
mATDDR3_BIT11:      equ    %100000000000
mATDDR3_BIT12:      equ    %1000000000000
mATDDR3_BIT13:      equ    %10000000000000
mATDDR3_BIT14:      equ    %100000000000000
mATDDR3_BIT15:      equ    %1000000000000000


;*** ATDDR3H - ATD Conversion Result Register 3 High; 0x00000096 ***
ATDDR3H:            equ    $00000096                                ;*** ATDDR3H - ATD Conversion Result Register 3 High; 0x00000096 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR3H_BIT8:       equ    0                                         ; ATD Conversion Result Bit 8
ATDDR3H_BIT9:       equ    1                                         ; ATD Conversion Result Bit 9
ATDDR3H_BIT10:      equ    2                                         ; ATD Conversion Result Bit 10
ATDDR3H_BIT11:      equ    3                                         ; ATD Conversion Result Bit 11
ATDDR3H_BIT12:      equ    4                                         ; ATD Conversion Result Bit 12
ATDDR3H_BIT13:      equ    5                                         ; ATD Conversion Result Bit 13
ATDDR3H_BIT14:      equ    6                                         ; ATD Conversion Result Bit 14
ATDDR3H_BIT15:      equ    7                                         ; ATD Conversion Result Bit 15
; bit position masks
mATDDR3H_BIT8:      equ    %00000001
mATDDR3H_BIT9:      equ    %00000010
mATDDR3H_BIT10:     equ    %00000100
mATDDR3H_BIT11:     equ    %00001000
mATDDR3H_BIT12:     equ    %00010000
mATDDR3H_BIT13:     equ    %00100000
mATDDR3H_BIT14:     equ    %01000000
mATDDR3H_BIT15:     equ    %10000000


;*** ATDDR3L - ATD Conversion Result Register 3 Low; 0x00000097 ***
ATDDR3L:            equ    $00000097                                ;*** ATDDR3L - ATD Conversion Result Register 3 Low; 0x00000097 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR3L_BIT0:       equ    0                                         ; ATD Conversion Result Bit 0
ATDDR3L_BIT1:       equ    1                                         ; ATD Conversion Result Bit 1
ATDDR3L_BIT2:       equ    2                                         ; ATD Conversion Result Bit 2
ATDDR3L_BIT3:       equ    3                                         ; ATD Conversion Result Bit 3
ATDDR3L_BIT4:       equ    4                                         ; ATD Conversion Result Bit 4
ATDDR3L_BIT5:       equ    5                                         ; ATD Conversion Result Bit 5
ATDDR3L_BIT6:       equ    6                                         ; ATD Conversion Result Bit 6
ATDDR3L_BIT7:       equ    7                                         ; ATD Conversion Result Bit 7
; bit position masks
mATDDR3L_BIT0:      equ    %00000001
mATDDR3L_BIT1:      equ    %00000010
mATDDR3L_BIT2:      equ    %00000100
mATDDR3L_BIT3:      equ    %00001000
mATDDR3L_BIT4:      equ    %00010000
mATDDR3L_BIT5:      equ    %00100000
mATDDR3L_BIT6:      equ    %01000000
mATDDR3L_BIT7:      equ    %10000000


;*** ATDDR4 - ATD Conversion Result Register 4; 0x00000098 ***
ATDDR4:             equ    $00000098                                ;*** ATDDR4 - ATD Conversion Result Register 4; 0x00000098 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR4_BIT0:        equ    0                                         ; ATD Conversion Result Bit 0
ATDDR4_BIT1:        equ    1                                         ; ATD Conversion Result Bit 1
ATDDR4_BIT2:        equ    2                                         ; ATD Conversion Result Bit 2
ATDDR4_BIT3:        equ    3                                         ; ATD Conversion Result Bit 3
ATDDR4_BIT4:        equ    4                                         ; ATD Conversion Result Bit 4
ATDDR4_BIT5:        equ    5                                         ; ATD Conversion Result Bit 5
ATDDR4_BIT6:        equ    6                                         ; ATD Conversion Result Bit 6
ATDDR4_BIT7:        equ    7                                         ; ATD Conversion Result Bit 7
ATDDR4_BIT8:        equ    8                                         ; ATD Conversion Result Bit 8
ATDDR4_BIT9:        equ    9                                         ; ATD Conversion Result Bit 9
ATDDR4_BIT10:       equ    10                                        ; ATD Conversion Result Bit 10
ATDDR4_BIT11:       equ    11                                        ; ATD Conversion Result Bit 11
ATDDR4_BIT12:       equ    12                                        ; ATD Conversion Result Bit 12
ATDDR4_BIT13:       equ    13                                        ; ATD Conversion Result Bit 13
ATDDR4_BIT14:       equ    14                                        ; ATD Conversion Result Bit 14
ATDDR4_BIT15:       equ    15                                        ; ATD Conversion Result Bit 15
; bit position masks
mATDDR4_BIT0:       equ    %00000001
mATDDR4_BIT1:       equ    %00000010
mATDDR4_BIT2:       equ    %00000100
mATDDR4_BIT3:       equ    %00001000
mATDDR4_BIT4:       equ    %00010000
mATDDR4_BIT5:       equ    %00100000
mATDDR4_BIT6:       equ    %01000000
mATDDR4_BIT7:       equ    %10000000
mATDDR4_BIT8:       equ    %100000000
mATDDR4_BIT9:       equ    %1000000000
mATDDR4_BIT10:      equ    %10000000000
mATDDR4_BIT11:      equ    %100000000000
mATDDR4_BIT12:      equ    %1000000000000
mATDDR4_BIT13:      equ    %10000000000000
mATDDR4_BIT14:      equ    %100000000000000
mATDDR4_BIT15:      equ    %1000000000000000


;*** ATDDR4H - ATD Conversion Result Register 4 High; 0x00000098 ***
ATDDR4H:            equ    $00000098                                ;*** ATDDR4H - ATD Conversion Result Register 4 High; 0x00000098 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR4H_BIT8:       equ    0                                         ; ATD Conversion Result Bit 8
ATDDR4H_BIT9:       equ    1                                         ; ATD Conversion Result Bit 9
ATDDR4H_BIT10:      equ    2                                         ; ATD Conversion Result Bit 10
ATDDR4H_BIT11:      equ    3                                         ; ATD Conversion Result Bit 11
ATDDR4H_BIT12:      equ    4                                         ; ATD Conversion Result Bit 12
ATDDR4H_BIT13:      equ    5                                         ; ATD Conversion Result Bit 13
ATDDR4H_BIT14:      equ    6                                         ; ATD Conversion Result Bit 14
ATDDR4H_BIT15:      equ    7                                         ; ATD Conversion Result Bit 15
; bit position masks
mATDDR4H_BIT8:      equ    %00000001
mATDDR4H_BIT9:      equ    %00000010
mATDDR4H_BIT10:     equ    %00000100
mATDDR4H_BIT11:     equ    %00001000
mATDDR4H_BIT12:     equ    %00010000
mATDDR4H_BIT13:     equ    %00100000
mATDDR4H_BIT14:     equ    %01000000
mATDDR4H_BIT15:     equ    %10000000


;*** ATDDR4L - ATD Conversion Result Register 4 Low; 0x00000099 ***
ATDDR4L:            equ    $00000099                                ;*** ATDDR4L - ATD Conversion Result Register 4 Low; 0x00000099 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR4L_BIT0:       equ    0                                         ; ATD Conversion Result Bit 0
ATDDR4L_BIT1:       equ    1                                         ; ATD Conversion Result Bit 1
ATDDR4L_BIT2:       equ    2                                         ; ATD Conversion Result Bit 2
ATDDR4L_BIT3:       equ    3                                         ; ATD Conversion Result Bit 3
ATDDR4L_BIT4:       equ    4                                         ; ATD Conversion Result Bit 4
ATDDR4L_BIT5:       equ    5                                         ; ATD Conversion Result Bit 5
ATDDR4L_BIT6:       equ    6                                         ; ATD Conversion Result Bit 6
ATDDR4L_BIT7:       equ    7                                         ; ATD Conversion Result Bit 7
; bit position masks
mATDDR4L_BIT0:      equ    %00000001
mATDDR4L_BIT1:      equ    %00000010
mATDDR4L_BIT2:      equ    %00000100
mATDDR4L_BIT3:      equ    %00001000
mATDDR4L_BIT4:      equ    %00010000
mATDDR4L_BIT5:      equ    %00100000
mATDDR4L_BIT6:      equ    %01000000
mATDDR4L_BIT7:      equ    %10000000


;*** ATDDR5 - ATD Conversion Result Register 5; 0x0000009A ***
ATDDR5:             equ    $0000009A                                ;*** ATDDR5 - ATD Conversion Result Register 5; 0x0000009A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR5_BIT0:        equ    0                                         ; ATD Conversion Result Bit 0
ATDDR5_BIT1:        equ    1                                         ; ATD Conversion Result Bit 1
ATDDR5_BIT2:        equ    2                                         ; ATD Conversion Result Bit 2
ATDDR5_BIT3:        equ    3                                         ; ATD Conversion Result Bit 3
ATDDR5_BIT4:        equ    4                                         ; ATD Conversion Result Bit 4
ATDDR5_BIT5:        equ    5                                         ; ATD Conversion Result Bit 5
ATDDR5_BIT6:        equ    6                                         ; ATD Conversion Result Bit 6
ATDDR5_BIT7:        equ    7                                         ; ATD Conversion Result Bit 7
ATDDR5_BIT8:        equ    8                                         ; ATD Conversion Result Bit 8
ATDDR5_BIT9:        equ    9                                         ; ATD Conversion Result Bit 9
ATDDR5_BIT10:       equ    10                                        ; ATD Conversion Result Bit 10
ATDDR5_BIT11:       equ    11                                        ; ATD Conversion Result Bit 11
ATDDR5_BIT12:       equ    12                                        ; ATD Conversion Result Bit 12
ATDDR5_BIT13:       equ    13                                        ; ATD Conversion Result Bit 13
ATDDR5_BIT14:       equ    14                                        ; ATD Conversion Result Bit 14
ATDDR5_BIT15:       equ    15                                        ; ATD Conversion Result Bit 15
; bit position masks
mATDDR5_BIT0:       equ    %00000001
mATDDR5_BIT1:       equ    %00000010
mATDDR5_BIT2:       equ    %00000100
mATDDR5_BIT3:       equ    %00001000
mATDDR5_BIT4:       equ    %00010000
mATDDR5_BIT5:       equ    %00100000
mATDDR5_BIT6:       equ    %01000000
mATDDR5_BIT7:       equ    %10000000
mATDDR5_BIT8:       equ    %100000000
mATDDR5_BIT9:       equ    %1000000000
mATDDR5_BIT10:      equ    %10000000000
mATDDR5_BIT11:      equ    %100000000000
mATDDR5_BIT12:      equ    %1000000000000
mATDDR5_BIT13:      equ    %10000000000000
mATDDR5_BIT14:      equ    %100000000000000
mATDDR5_BIT15:      equ    %1000000000000000


;*** ATDDR5H - ATD Conversion Result Register 5 High; 0x0000009A ***
ATDDR5H:            equ    $0000009A                                ;*** ATDDR5H - ATD Conversion Result Register 5 High; 0x0000009A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR5H_BIT8:       equ    0                                         ; ATD Conversion Result Bit 8
ATDDR5H_BIT9:       equ    1                                         ; ATD Conversion Result Bit 9
ATDDR5H_BIT10:      equ    2                                         ; ATD Conversion Result Bit 10
ATDDR5H_BIT11:      equ    3                                         ; ATD Conversion Result Bit 11
ATDDR5H_BIT12:      equ    4                                         ; ATD Conversion Result Bit 12
ATDDR5H_BIT13:      equ    5                                         ; ATD Conversion Result Bit 13
ATDDR5H_BIT14:      equ    6                                         ; ATD Conversion Result Bit 14
ATDDR5H_BIT15:      equ    7                                         ; ATD Conversion Result Bit 15
; bit position masks
mATDDR5H_BIT8:      equ    %00000001
mATDDR5H_BIT9:      equ    %00000010
mATDDR5H_BIT10:     equ    %00000100
mATDDR5H_BIT11:     equ    %00001000
mATDDR5H_BIT12:     equ    %00010000
mATDDR5H_BIT13:     equ    %00100000
mATDDR5H_BIT14:     equ    %01000000
mATDDR5H_BIT15:     equ    %10000000


;*** ATDDR5L - ATD Conversion Result Register 5 Low; 0x0000009B ***
ATDDR5L:            equ    $0000009B                                ;*** ATDDR5L - ATD Conversion Result Register 5 Low; 0x0000009B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR5L_BIT0:       equ    0                                         ; ATD Conversion Result Bit 0
ATDDR5L_BIT1:       equ    1                                         ; ATD Conversion Result Bit 1
ATDDR5L_BIT2:       equ    2                                         ; ATD Conversion Result Bit 2
ATDDR5L_BIT3:       equ    3                                         ; ATD Conversion Result Bit 3
ATDDR5L_BIT4:       equ    4                                         ; ATD Conversion Result Bit 4
ATDDR5L_BIT5:       equ    5                                         ; ATD Conversion Result Bit 5
ATDDR5L_BIT6:       equ    6                                         ; ATD Conversion Result Bit 6
ATDDR5L_BIT7:       equ    7                                         ; ATD Conversion Result Bit 7
; bit position masks
mATDDR5L_BIT0:      equ    %00000001
mATDDR5L_BIT1:      equ    %00000010
mATDDR5L_BIT2:      equ    %00000100
mATDDR5L_BIT3:      equ    %00001000
mATDDR5L_BIT4:      equ    %00010000
mATDDR5L_BIT5:      equ    %00100000
mATDDR5L_BIT6:      equ    %01000000
mATDDR5L_BIT7:      equ    %10000000


;*** ATDDR6 - ATD Conversion Result Register 6; 0x0000009C ***
ATDDR6:             equ    $0000009C                                ;*** ATDDR6 - ATD Conversion Result Register 6; 0x0000009C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR6_BIT0:        equ    0                                         ; ATD Conversion Result Bit 0
ATDDR6_BIT1:        equ    1                                         ; ATD Conversion Result Bit 1
ATDDR6_BIT2:        equ    2                                         ; ATD Conversion Result Bit 2
ATDDR6_BIT3:        equ    3                                         ; ATD Conversion Result Bit 3
ATDDR6_BIT4:        equ    4                                         ; ATD Conversion Result Bit 4
ATDDR6_BIT5:        equ    5                                         ; ATD Conversion Result Bit 5
ATDDR6_BIT6:        equ    6                                         ; ATD Conversion Result Bit 6
ATDDR6_BIT7:        equ    7                                         ; ATD Conversion Result Bit 7
ATDDR6_BIT8:        equ    8                                         ; ATD Conversion Result Bit 8
ATDDR6_BIT9:        equ    9                                         ; ATD Conversion Result Bit 9
ATDDR6_BIT10:       equ    10                                        ; ATD Conversion Result Bit 10
ATDDR6_BIT11:       equ    11                                        ; ATD Conversion Result Bit 11
ATDDR6_BIT12:       equ    12                                        ; ATD Conversion Result Bit 12
ATDDR6_BIT13:       equ    13                                        ; ATD Conversion Result Bit 13
ATDDR6_BIT14:       equ    14                                        ; ATD Conversion Result Bit 14
ATDDR6_BIT15:       equ    15                                        ; ATD Conversion Result Bit 15
; bit position masks
mATDDR6_BIT0:       equ    %00000001
mATDDR6_BIT1:       equ    %00000010
mATDDR6_BIT2:       equ    %00000100
mATDDR6_BIT3:       equ    %00001000
mATDDR6_BIT4:       equ    %00010000
mATDDR6_BIT5:       equ    %00100000
mATDDR6_BIT6:       equ    %01000000
mATDDR6_BIT7:       equ    %10000000
mATDDR6_BIT8:       equ    %100000000
mATDDR6_BIT9:       equ    %1000000000
mATDDR6_BIT10:      equ    %10000000000
mATDDR6_BIT11:      equ    %100000000000
mATDDR6_BIT12:      equ    %1000000000000
mATDDR6_BIT13:      equ    %10000000000000
mATDDR6_BIT14:      equ    %100000000000000
mATDDR6_BIT15:      equ    %1000000000000000


;*** ATDDR6H - ATD Conversion Result Register 6 High; 0x0000009C ***
ATDDR6H:            equ    $0000009C                                ;*** ATDDR6H - ATD Conversion Result Register 6 High; 0x0000009C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR6H_BIT8:       equ    0                                         ; ATD Conversion Result Bit 8
ATDDR6H_BIT9:       equ    1                                         ; ATD Conversion Result Bit 9
ATDDR6H_BIT10:      equ    2                                         ; ATD Conversion Result Bit 10
ATDDR6H_BIT11:      equ    3                                         ; ATD Conversion Result Bit 11
ATDDR6H_BIT12:      equ    4                                         ; ATD Conversion Result Bit 12
ATDDR6H_BIT13:      equ    5                                         ; ATD Conversion Result Bit 13
ATDDR6H_BIT14:      equ    6                                         ; ATD Conversion Result Bit 14
ATDDR6H_BIT15:      equ    7                                         ; ATD Conversion Result Bit 15
; bit position masks
mATDDR6H_BIT8:      equ    %00000001
mATDDR6H_BIT9:      equ    %00000010
mATDDR6H_BIT10:     equ    %00000100
mATDDR6H_BIT11:     equ    %00001000
mATDDR6H_BIT12:     equ    %00010000
mATDDR6H_BIT13:     equ    %00100000
mATDDR6H_BIT14:     equ    %01000000
mATDDR6H_BIT15:     equ    %10000000


;*** ATDDR6L - ATD Conversion Result Register 6 Low; 0x0000009D ***
ATDDR6L:            equ    $0000009D                                ;*** ATDDR6L - ATD Conversion Result Register 6 Low; 0x0000009D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR6L_BIT0:       equ    0                                         ; ATD Conversion Result Bit 0
ATDDR6L_BIT1:       equ    1                                         ; ATD Conversion Result Bit 1
ATDDR6L_BIT2:       equ    2                                         ; ATD Conversion Result Bit 2
ATDDR6L_BIT3:       equ    3                                         ; ATD Conversion Result Bit 3
ATDDR6L_BIT4:       equ    4                                         ; ATD Conversion Result Bit 4
ATDDR6L_BIT5:       equ    5                                         ; ATD Conversion Result Bit 5
ATDDR6L_BIT6:       equ    6                                         ; ATD Conversion Result Bit 6
ATDDR6L_BIT7:       equ    7                                         ; ATD Conversion Result Bit 7
; bit position masks
mATDDR6L_BIT0:      equ    %00000001
mATDDR6L_BIT1:      equ    %00000010
mATDDR6L_BIT2:      equ    %00000100
mATDDR6L_BIT3:      equ    %00001000
mATDDR6L_BIT4:      equ    %00010000
mATDDR6L_BIT5:      equ    %00100000
mATDDR6L_BIT6:      equ    %01000000
mATDDR6L_BIT7:      equ    %10000000


;*** ATDDR7 - ATD Conversion Result Register 7; 0x0000009E ***
ATDDR7:             equ    $0000009E                                ;*** ATDDR7 - ATD Conversion Result Register 7; 0x0000009E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR7_BIT0:        equ    0                                         ; ATD Conversion Result Bit 0
ATDDR7_BIT1:        equ    1                                         ; ATD Conversion Result Bit 1
ATDDR7_BIT2:        equ    2                                         ; ATD Conversion Result Bit 2
ATDDR7_BIT3:        equ    3                                         ; ATD Conversion Result Bit 3
ATDDR7_BIT4:        equ    4                                         ; ATD Conversion Result Bit 4
ATDDR7_BIT5:        equ    5                                         ; ATD Conversion Result Bit 5
ATDDR7_BIT6:        equ    6                                         ; ATD Conversion Result Bit 6
ATDDR7_BIT7:        equ    7                                         ; ATD Conversion Result Bit 7
ATDDR7_BIT8:        equ    8                                         ; ATD Conversion Result Bit 8
ATDDR7_BIT9:        equ    9                                         ; ATD Conversion Result Bit 9
ATDDR7_BIT10:       equ    10                                        ; ATD Conversion Result Bit 10
ATDDR7_BIT11:       equ    11                                        ; ATD Conversion Result Bit 11
ATDDR7_BIT12:       equ    12                                        ; ATD Conversion Result Bit 12
ATDDR7_BIT13:       equ    13                                        ; ATD Conversion Result Bit 13
ATDDR7_BIT14:       equ    14                                        ; ATD Conversion Result Bit 14
ATDDR7_BIT15:       equ    15                                        ; ATD Conversion Result Bit 15
; bit position masks
mATDDR7_BIT0:       equ    %00000001
mATDDR7_BIT1:       equ    %00000010
mATDDR7_BIT2:       equ    %00000100
mATDDR7_BIT3:       equ    %00001000
mATDDR7_BIT4:       equ    %00010000
mATDDR7_BIT5:       equ    %00100000
mATDDR7_BIT6:       equ    %01000000
mATDDR7_BIT7:       equ    %10000000
mATDDR7_BIT8:       equ    %100000000
mATDDR7_BIT9:       equ    %1000000000
mATDDR7_BIT10:      equ    %10000000000
mATDDR7_BIT11:      equ    %100000000000
mATDDR7_BIT12:      equ    %1000000000000
mATDDR7_BIT13:      equ    %10000000000000
mATDDR7_BIT14:      equ    %100000000000000
mATDDR7_BIT15:      equ    %1000000000000000


;*** ATDDR7H - ATD Conversion Result Register 7 High; 0x0000009E ***
ATDDR7H:            equ    $0000009E                                ;*** ATDDR7H - ATD Conversion Result Register 7 High; 0x0000009E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR7H_BIT8:       equ    0                                         ; ATD Conversion Result Bit 8
ATDDR7H_BIT9:       equ    1                                         ; ATD Conversion Result Bit 9
ATDDR7H_BIT10:      equ    2                                         ; ATD Conversion Result Bit 10
ATDDR7H_BIT11:      equ    3                                         ; ATD Conversion Result Bit 11
ATDDR7H_BIT12:      equ    4                                         ; ATD Conversion Result Bit 12
ATDDR7H_BIT13:      equ    5                                         ; ATD Conversion Result Bit 13
ATDDR7H_BIT14:      equ    6                                         ; ATD Conversion Result Bit 14
ATDDR7H_BIT15:      equ    7                                         ; ATD Conversion Result Bit 15
; bit position masks
mATDDR7H_BIT8:      equ    %00000001
mATDDR7H_BIT9:      equ    %00000010
mATDDR7H_BIT10:     equ    %00000100
mATDDR7H_BIT11:     equ    %00001000
mATDDR7H_BIT12:     equ    %00010000
mATDDR7H_BIT13:     equ    %00100000
mATDDR7H_BIT14:     equ    %01000000
mATDDR7H_BIT15:     equ    %10000000


;*** ATDDR7L - ATD Conversion Result Register 7 Low; 0x0000009F ***
ATDDR7L:            equ    $0000009F                                ;*** ATDDR7L - ATD Conversion Result Register 7 Low; 0x0000009F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR7L_BIT0:       equ    0                                         ; ATD Conversion Result Bit 0
ATDDR7L_BIT1:       equ    1                                         ; ATD Conversion Result Bit 1
ATDDR7L_BIT2:       equ    2                                         ; ATD Conversion Result Bit 2
ATDDR7L_BIT3:       equ    3                                         ; ATD Conversion Result Bit 3
ATDDR7L_BIT4:       equ    4                                         ; ATD Conversion Result Bit 4
ATDDR7L_BIT5:       equ    5                                         ; ATD Conversion Result Bit 5
ATDDR7L_BIT6:       equ    6                                         ; ATD Conversion Result Bit 6
ATDDR7L_BIT7:       equ    7                                         ; ATD Conversion Result Bit 7
; bit position masks
mATDDR7L_BIT0:      equ    %00000001
mATDDR7L_BIT1:      equ    %00000010
mATDDR7L_BIT2:      equ    %00000100
mATDDR7L_BIT3:      equ    %00001000
mATDDR7L_BIT4:      equ    %00010000
mATDDR7L_BIT5:      equ    %00100000
mATDDR7L_BIT6:      equ    %01000000
mATDDR7L_BIT7:      equ    %10000000


;*** ATDDR8 - ATD Conversion Result Register 8; 0x000000A0 ***
ATDDR8:             equ    $000000A0                                ;*** ATDDR8 - ATD Conversion Result Register 8; 0x000000A0 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR8_BIT0:        equ    0                                         ; ATD Conversion Result Bit 0
ATDDR8_BIT1:        equ    1                                         ; ATD Conversion Result Bit 1
ATDDR8_BIT2:        equ    2                                         ; ATD Conversion Result Bit 2
ATDDR8_BIT3:        equ    3                                         ; ATD Conversion Result Bit 3
ATDDR8_BIT4:        equ    4                                         ; ATD Conversion Result Bit 4
ATDDR8_BIT5:        equ    5                                         ; ATD Conversion Result Bit 5
ATDDR8_BIT6:        equ    6                                         ; ATD Conversion Result Bit 6
ATDDR8_BIT7:        equ    7                                         ; ATD Conversion Result Bit 7
ATDDR8_BIT8:        equ    8                                         ; ATD Conversion Result Bit 8
ATDDR8_BIT9:        equ    9                                         ; ATD Conversion Result Bit 9
ATDDR8_BIT10:       equ    10                                        ; ATD Conversion Result Bit 10
ATDDR8_BIT11:       equ    11                                        ; ATD Conversion Result Bit 11
ATDDR8_BIT12:       equ    12                                        ; ATD Conversion Result Bit 12
ATDDR8_BIT13:       equ    13                                        ; ATD Conversion Result Bit 13
ATDDR8_BIT14:       equ    14                                        ; ATD Conversion Result Bit 14
ATDDR8_BIT15:       equ    15                                        ; ATD Conversion Result Bit 15
; bit position masks
mATDDR8_BIT0:       equ    %00000001
mATDDR8_BIT1:       equ    %00000010
mATDDR8_BIT2:       equ    %00000100
mATDDR8_BIT3:       equ    %00001000
mATDDR8_BIT4:       equ    %00010000
mATDDR8_BIT5:       equ    %00100000
mATDDR8_BIT6:       equ    %01000000
mATDDR8_BIT7:       equ    %10000000
mATDDR8_BIT8:       equ    %100000000
mATDDR8_BIT9:       equ    %1000000000
mATDDR8_BIT10:      equ    %10000000000
mATDDR8_BIT11:      equ    %100000000000
mATDDR8_BIT12:      equ    %1000000000000
mATDDR8_BIT13:      equ    %10000000000000
mATDDR8_BIT14:      equ    %100000000000000
mATDDR8_BIT15:      equ    %1000000000000000


;*** ATDDR8H - ATD Conversion Result Register 8 High; 0x000000A0 ***
ATDDR8H:            equ    $000000A0                                ;*** ATDDR8H - ATD Conversion Result Register 8 High; 0x000000A0 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR8H_BIT8:       equ    0                                         ; ATD Conversion Result Bit 8
ATDDR8H_BIT9:       equ    1                                         ; ATD Conversion Result Bit 9
ATDDR8H_BIT10:      equ    2                                         ; ATD Conversion Result Bit 10
ATDDR8H_BIT11:      equ    3                                         ; ATD Conversion Result Bit 11
ATDDR8H_BIT12:      equ    4                                         ; ATD Conversion Result Bit 12
ATDDR8H_BIT13:      equ    5                                         ; ATD Conversion Result Bit 13
ATDDR8H_BIT14:      equ    6                                         ; ATD Conversion Result Bit 14
ATDDR8H_BIT15:      equ    7                                         ; ATD Conversion Result Bit 15
; bit position masks
mATDDR8H_BIT8:      equ    %00000001
mATDDR8H_BIT9:      equ    %00000010
mATDDR8H_BIT10:     equ    %00000100
mATDDR8H_BIT11:     equ    %00001000
mATDDR8H_BIT12:     equ    %00010000
mATDDR8H_BIT13:     equ    %00100000
mATDDR8H_BIT14:     equ    %01000000
mATDDR8H_BIT15:     equ    %10000000


;*** ATDDR8L - ATD Conversion Result Register 8 Low; 0x000000A1 ***
ATDDR8L:            equ    $000000A1                                ;*** ATDDR8L - ATD Conversion Result Register 8 Low; 0x000000A1 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR8L_BIT0:       equ    0                                         ; ATD Conversion Result Bit 0
ATDDR8L_BIT1:       equ    1                                         ; ATD Conversion Result Bit 1
ATDDR8L_BIT2:       equ    2                                         ; ATD Conversion Result Bit 2
ATDDR8L_BIT3:       equ    3                                         ; ATD Conversion Result Bit 3
ATDDR8L_BIT4:       equ    4                                         ; ATD Conversion Result Bit 4
ATDDR8L_BIT5:       equ    5                                         ; ATD Conversion Result Bit 5
ATDDR8L_BIT6:       equ    6                                         ; ATD Conversion Result Bit 6
ATDDR8L_BIT7:       equ    7                                         ; ATD Conversion Result Bit 7
; bit position masks
mATDDR8L_BIT0:      equ    %00000001
mATDDR8L_BIT1:      equ    %00000010
mATDDR8L_BIT2:      equ    %00000100
mATDDR8L_BIT3:      equ    %00001000
mATDDR8L_BIT4:      equ    %00010000
mATDDR8L_BIT5:      equ    %00100000
mATDDR8L_BIT6:      equ    %01000000
mATDDR8L_BIT7:      equ    %10000000


;*** ATDDR9 - ATD Conversion Result Register 9; 0x000000A2 ***
ATDDR9:             equ    $000000A2                                ;*** ATDDR9 - ATD Conversion Result Register 9; 0x000000A2 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR9_BIT0:        equ    0                                         ; ATD Conversion Result Bit 0
ATDDR9_BIT1:        equ    1                                         ; ATD Conversion Result Bit 1
ATDDR9_BIT2:        equ    2                                         ; ATD Conversion Result Bit 2
ATDDR9_BIT3:        equ    3                                         ; ATD Conversion Result Bit 3
ATDDR9_BIT4:        equ    4                                         ; ATD Conversion Result Bit 4
ATDDR9_BIT5:        equ    5                                         ; ATD Conversion Result Bit 5
ATDDR9_BIT6:        equ    6                                         ; ATD Conversion Result Bit 6
ATDDR9_BIT7:        equ    7                                         ; ATD Conversion Result Bit 7
ATDDR9_BIT8:        equ    8                                         ; ATD Conversion Result Bit 8
ATDDR9_BIT9:        equ    9                                         ; ATD Conversion Result Bit 9
ATDDR9_BIT10:       equ    10                                        ; ATD Conversion Result Bit 10
ATDDR9_BIT11:       equ    11                                        ; ATD Conversion Result Bit 11
ATDDR9_BIT12:       equ    12                                        ; ATD Conversion Result Bit 12
ATDDR9_BIT13:       equ    13                                        ; ATD Conversion Result Bit 13
ATDDR9_BIT14:       equ    14                                        ; ATD Conversion Result Bit 14
ATDDR9_BIT15:       equ    15                                        ; ATD Conversion Result Bit 15
; bit position masks
mATDDR9_BIT0:       equ    %00000001
mATDDR9_BIT1:       equ    %00000010
mATDDR9_BIT2:       equ    %00000100
mATDDR9_BIT3:       equ    %00001000
mATDDR9_BIT4:       equ    %00010000
mATDDR9_BIT5:       equ    %00100000
mATDDR9_BIT6:       equ    %01000000
mATDDR9_BIT7:       equ    %10000000
mATDDR9_BIT8:       equ    %100000000
mATDDR9_BIT9:       equ    %1000000000
mATDDR9_BIT10:      equ    %10000000000
mATDDR9_BIT11:      equ    %100000000000
mATDDR9_BIT12:      equ    %1000000000000
mATDDR9_BIT13:      equ    %10000000000000
mATDDR9_BIT14:      equ    %100000000000000
mATDDR9_BIT15:      equ    %1000000000000000


;*** ATDDR9H - ATD Conversion Result Register 9 High; 0x000000A2 ***
ATDDR9H:            equ    $000000A2                                ;*** ATDDR9H - ATD Conversion Result Register 9 High; 0x000000A2 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR9H_BIT8:       equ    0                                         ; ATD Conversion Result Bit 8
ATDDR9H_BIT9:       equ    1                                         ; ATD Conversion Result Bit 9
ATDDR9H_BIT10:      equ    2                                         ; ATD Conversion Result Bit 10
ATDDR9H_BIT11:      equ    3                                         ; ATD Conversion Result Bit 11
ATDDR9H_BIT12:      equ    4                                         ; ATD Conversion Result Bit 12
ATDDR9H_BIT13:      equ    5                                         ; ATD Conversion Result Bit 13
ATDDR9H_BIT14:      equ    6                                         ; ATD Conversion Result Bit 14
ATDDR9H_BIT15:      equ    7                                         ; ATD Conversion Result Bit 15
; bit position masks
mATDDR9H_BIT8:      equ    %00000001
mATDDR9H_BIT9:      equ    %00000010
mATDDR9H_BIT10:     equ    %00000100
mATDDR9H_BIT11:     equ    %00001000
mATDDR9H_BIT12:     equ    %00010000
mATDDR9H_BIT13:     equ    %00100000
mATDDR9H_BIT14:     equ    %01000000
mATDDR9H_BIT15:     equ    %10000000


;*** ATDDR9L - ATD Conversion Result Register 9 Low; 0x000000A3 ***
ATDDR9L:            equ    $000000A3                                ;*** ATDDR9L - ATD Conversion Result Register 9 Low; 0x000000A3 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR9L_BIT0:       equ    0                                         ; ATD Conversion Result Bit 0
ATDDR9L_BIT1:       equ    1                                         ; ATD Conversion Result Bit 1
ATDDR9L_BIT2:       equ    2                                         ; ATD Conversion Result Bit 2
ATDDR9L_BIT3:       equ    3                                         ; ATD Conversion Result Bit 3
ATDDR9L_BIT4:       equ    4                                         ; ATD Conversion Result Bit 4
ATDDR9L_BIT5:       equ    5                                         ; ATD Conversion Result Bit 5
ATDDR9L_BIT6:       equ    6                                         ; ATD Conversion Result Bit 6
ATDDR9L_BIT7:       equ    7                                         ; ATD Conversion Result Bit 7
; bit position masks
mATDDR9L_BIT0:      equ    %00000001
mATDDR9L_BIT1:      equ    %00000010
mATDDR9L_BIT2:      equ    %00000100
mATDDR9L_BIT3:      equ    %00001000
mATDDR9L_BIT4:      equ    %00010000
mATDDR9L_BIT5:      equ    %00100000
mATDDR9L_BIT6:      equ    %01000000
mATDDR9L_BIT7:      equ    %10000000


;*** ATDDR10 - ATD Conversion Result Register 10; 0x000000A4 ***
ATDDR10:            equ    $000000A4                                ;*** ATDDR10 - ATD Conversion Result Register 10; 0x000000A4 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR10_BIT0:       equ    0                                         ; ATD Conversion Result Bit 0
ATDDR10_BIT1:       equ    1                                         ; ATD Conversion Result Bit 1
ATDDR10_BIT2:       equ    2                                         ; ATD Conversion Result Bit 2
ATDDR10_BIT3:       equ    3                                         ; ATD Conversion Result Bit 3
ATDDR10_BIT4:       equ    4                                         ; ATD Conversion Result Bit 4
ATDDR10_BIT5:       equ    5                                         ; ATD Conversion Result Bit 5
ATDDR10_BIT6:       equ    6                                         ; ATD Conversion Result Bit 6
ATDDR10_BIT7:       equ    7                                         ; ATD Conversion Result Bit 7
ATDDR10_BIT8:       equ    8                                         ; ATD Conversion Result Bit 8
ATDDR10_BIT9:       equ    9                                         ; ATD Conversion Result Bit 9
ATDDR10_BIT10:      equ    10                                        ; ATD Conversion Result Bit 10
ATDDR10_BIT11:      equ    11                                        ; ATD Conversion Result Bit 11
ATDDR10_BIT12:      equ    12                                        ; ATD Conversion Result Bit 12
ATDDR10_BIT13:      equ    13                                        ; ATD Conversion Result Bit 13
ATDDR10_BIT14:      equ    14                                        ; ATD Conversion Result Bit 14
ATDDR10_BIT15:      equ    15                                        ; ATD Conversion Result Bit 15
; bit position masks
mATDDR10_BIT0:      equ    %00000001
mATDDR10_BIT1:      equ    %00000010
mATDDR10_BIT2:      equ    %00000100
mATDDR10_BIT3:      equ    %00001000
mATDDR10_BIT4:      equ    %00010000
mATDDR10_BIT5:      equ    %00100000
mATDDR10_BIT6:      equ    %01000000
mATDDR10_BIT7:      equ    %10000000
mATDDR10_BIT8:      equ    %100000000
mATDDR10_BIT9:      equ    %1000000000
mATDDR10_BIT10:     equ    %10000000000
mATDDR10_BIT11:     equ    %100000000000
mATDDR10_BIT12:     equ    %1000000000000
mATDDR10_BIT13:     equ    %10000000000000
mATDDR10_BIT14:     equ    %100000000000000
mATDDR10_BIT15:     equ    %1000000000000000


;*** ATDDR10H - ATD Conversion Result Register 10 High; 0x000000A4 ***
ATDDR10H:           equ    $000000A4                                ;*** ATDDR10H - ATD Conversion Result Register 10 High; 0x000000A4 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR10H_BIT8:      equ    0                                         ; ATD Conversion Result Bit 8
ATDDR10H_BIT9:      equ    1                                         ; ATD Conversion Result Bit 9
ATDDR10H_BIT10:     equ    2                                         ; ATD Conversion Result Bit 10
ATDDR10H_BIT11:     equ    3                                         ; ATD Conversion Result Bit 11
ATDDR10H_BIT12:     equ    4                                         ; ATD Conversion Result Bit 12
ATDDR10H_BIT13:     equ    5                                         ; ATD Conversion Result Bit 13
ATDDR10H_BIT14:     equ    6                                         ; ATD Conversion Result Bit 14
ATDDR10H_BIT15:     equ    7                                         ; ATD Conversion Result Bit 15
; bit position masks
mATDDR10H_BIT8:     equ    %00000001
mATDDR10H_BIT9:     equ    %00000010
mATDDR10H_BIT10:    equ    %00000100
mATDDR10H_BIT11:    equ    %00001000
mATDDR10H_BIT12:    equ    %00010000
mATDDR10H_BIT13:    equ    %00100000
mATDDR10H_BIT14:    equ    %01000000
mATDDR10H_BIT15:    equ    %10000000


;*** ATDDR10L - ATD Conversion Result Register 10 Low; 0x000000A5 ***
ATDDR10L:           equ    $000000A5                                ;*** ATDDR10L - ATD Conversion Result Register 10 Low; 0x000000A5 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR10L_BIT0:      equ    0                                         ; ATD Conversion Result Bit 0
ATDDR10L_BIT1:      equ    1                                         ; ATD Conversion Result Bit 1
ATDDR10L_BIT2:      equ    2                                         ; ATD Conversion Result Bit 2
ATDDR10L_BIT3:      equ    3                                         ; ATD Conversion Result Bit 3
ATDDR10L_BIT4:      equ    4                                         ; ATD Conversion Result Bit 4
ATDDR10L_BIT5:      equ    5                                         ; ATD Conversion Result Bit 5
ATDDR10L_BIT6:      equ    6                                         ; ATD Conversion Result Bit 6
ATDDR10L_BIT7:      equ    7                                         ; ATD Conversion Result Bit 7
; bit position masks
mATDDR10L_BIT0:     equ    %00000001
mATDDR10L_BIT1:     equ    %00000010
mATDDR10L_BIT2:     equ    %00000100
mATDDR10L_BIT3:     equ    %00001000
mATDDR10L_BIT4:     equ    %00010000
mATDDR10L_BIT5:     equ    %00100000
mATDDR10L_BIT6:     equ    %01000000
mATDDR10L_BIT7:     equ    %10000000


;*** ATDDR11 - ATD Conversion Result Register 11; 0x000000A6 ***
ATDDR11:            equ    $000000A6                                ;*** ATDDR11 - ATD Conversion Result Register 11; 0x000000A6 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR11_BIT0:       equ    0                                         ; ATD Conversion Result Bit 0
ATDDR11_BIT1:       equ    1                                         ; ATD Conversion Result Bit 1
ATDDR11_BIT2:       equ    2                                         ; ATD Conversion Result Bit 2
ATDDR11_BIT3:       equ    3                                         ; ATD Conversion Result Bit 3
ATDDR11_BIT4:       equ    4                                         ; ATD Conversion Result Bit 4
ATDDR11_BIT5:       equ    5                                         ; ATD Conversion Result Bit 5
ATDDR11_BIT6:       equ    6                                         ; ATD Conversion Result Bit 6
ATDDR11_BIT7:       equ    7                                         ; ATD Conversion Result Bit 7
ATDDR11_BIT8:       equ    8                                         ; ATD Conversion Result Bit 8
ATDDR11_BIT9:       equ    9                                         ; ATD Conversion Result Bit 9
ATDDR11_BIT10:      equ    10                                        ; ATD Conversion Result Bit 10
ATDDR11_BIT11:      equ    11                                        ; ATD Conversion Result Bit 11
ATDDR11_BIT12:      equ    12                                        ; ATD Conversion Result Bit 12
ATDDR11_BIT13:      equ    13                                        ; ATD Conversion Result Bit 13
ATDDR11_BIT14:      equ    14                                        ; ATD Conversion Result Bit 14
ATDDR11_BIT15:      equ    15                                        ; ATD Conversion Result Bit 15
; bit position masks
mATDDR11_BIT0:      equ    %00000001
mATDDR11_BIT1:      equ    %00000010
mATDDR11_BIT2:      equ    %00000100
mATDDR11_BIT3:      equ    %00001000
mATDDR11_BIT4:      equ    %00010000
mATDDR11_BIT5:      equ    %00100000
mATDDR11_BIT6:      equ    %01000000
mATDDR11_BIT7:      equ    %10000000
mATDDR11_BIT8:      equ    %100000000
mATDDR11_BIT9:      equ    %1000000000
mATDDR11_BIT10:     equ    %10000000000
mATDDR11_BIT11:     equ    %100000000000
mATDDR11_BIT12:     equ    %1000000000000
mATDDR11_BIT13:     equ    %10000000000000
mATDDR11_BIT14:     equ    %100000000000000
mATDDR11_BIT15:     equ    %1000000000000000


;*** ATDDR11H - ATD Conversion Result Register 11 High; 0x000000A6 ***
ATDDR11H:           equ    $000000A6                                ;*** ATDDR11H - ATD Conversion Result Register 11 High; 0x000000A6 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR11H_BIT8:      equ    0                                         ; ATD Conversion Result Bit 8
ATDDR11H_BIT9:      equ    1                                         ; ATD Conversion Result Bit 9
ATDDR11H_BIT10:     equ    2                                         ; ATD Conversion Result Bit 10
ATDDR11H_BIT11:     equ    3                                         ; ATD Conversion Result Bit 11
ATDDR11H_BIT12:     equ    4                                         ; ATD Conversion Result Bit 12
ATDDR11H_BIT13:     equ    5                                         ; ATD Conversion Result Bit 13
ATDDR11H_BIT14:     equ    6                                         ; ATD Conversion Result Bit 14
ATDDR11H_BIT15:     equ    7                                         ; ATD Conversion Result Bit 15
; bit position masks
mATDDR11H_BIT8:     equ    %00000001
mATDDR11H_BIT9:     equ    %00000010
mATDDR11H_BIT10:    equ    %00000100
mATDDR11H_BIT11:    equ    %00001000
mATDDR11H_BIT12:    equ    %00010000
mATDDR11H_BIT13:    equ    %00100000
mATDDR11H_BIT14:    equ    %01000000
mATDDR11H_BIT15:    equ    %10000000


;*** ATDDR11L - ATD Conversion Result Register 11 Low; 0x000000A7 ***
ATDDR11L:           equ    $000000A7                                ;*** ATDDR11L - ATD Conversion Result Register 11 Low; 0x000000A7 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR11L_BIT0:      equ    0                                         ; ATD Conversion Result Bit 0
ATDDR11L_BIT1:      equ    1                                         ; ATD Conversion Result Bit 1
ATDDR11L_BIT2:      equ    2                                         ; ATD Conversion Result Bit 2
ATDDR11L_BIT3:      equ    3                                         ; ATD Conversion Result Bit 3
ATDDR11L_BIT4:      equ    4                                         ; ATD Conversion Result Bit 4
ATDDR11L_BIT5:      equ    5                                         ; ATD Conversion Result Bit 5
ATDDR11L_BIT6:      equ    6                                         ; ATD Conversion Result Bit 6
ATDDR11L_BIT7:      equ    7                                         ; ATD Conversion Result Bit 7
; bit position masks
mATDDR11L_BIT0:     equ    %00000001
mATDDR11L_BIT1:     equ    %00000010
mATDDR11L_BIT2:     equ    %00000100
mATDDR11L_BIT3:     equ    %00001000
mATDDR11L_BIT4:     equ    %00010000
mATDDR11L_BIT5:     equ    %00100000
mATDDR11L_BIT6:     equ    %01000000
mATDDR11L_BIT7:     equ    %10000000


;*** ATDDR12 - ATD Conversion Result Register 12; 0x000000A8 ***
ATDDR12:            equ    $000000A8                                ;*** ATDDR12 - ATD Conversion Result Register 12; 0x000000A8 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR12_BIT0:       equ    0                                         ; ATD Conversion Result Bit 0
ATDDR12_BIT1:       equ    1                                         ; ATD Conversion Result Bit 1
ATDDR12_BIT2:       equ    2                                         ; ATD Conversion Result Bit 2
ATDDR12_BIT3:       equ    3                                         ; ATD Conversion Result Bit 3
ATDDR12_BIT4:       equ    4                                         ; ATD Conversion Result Bit 4
ATDDR12_BIT5:       equ    5                                         ; ATD Conversion Result Bit 5
ATDDR12_BIT6:       equ    6                                         ; ATD Conversion Result Bit 6
ATDDR12_BIT7:       equ    7                                         ; ATD Conversion Result Bit 7
ATDDR12_BIT8:       equ    8                                         ; ATD Conversion Result Bit 8
ATDDR12_BIT9:       equ    9                                         ; ATD Conversion Result Bit 9
ATDDR12_BIT10:      equ    10                                        ; ATD Conversion Result Bit 10
ATDDR12_BIT11:      equ    11                                        ; ATD Conversion Result Bit 11
ATDDR12_BIT12:      equ    12                                        ; ATD Conversion Result Bit 12
ATDDR12_BIT13:      equ    13                                        ; ATD Conversion Result Bit 13
ATDDR12_BIT14:      equ    14                                        ; ATD Conversion Result Bit 14
ATDDR12_BIT15:      equ    15                                        ; ATD Conversion Result Bit 15
; bit position masks
mATDDR12_BIT0:      equ    %00000001
mATDDR12_BIT1:      equ    %00000010
mATDDR12_BIT2:      equ    %00000100
mATDDR12_BIT3:      equ    %00001000
mATDDR12_BIT4:      equ    %00010000
mATDDR12_BIT5:      equ    %00100000
mATDDR12_BIT6:      equ    %01000000
mATDDR12_BIT7:      equ    %10000000
mATDDR12_BIT8:      equ    %100000000
mATDDR12_BIT9:      equ    %1000000000
mATDDR12_BIT10:     equ    %10000000000
mATDDR12_BIT11:     equ    %100000000000
mATDDR12_BIT12:     equ    %1000000000000
mATDDR12_BIT13:     equ    %10000000000000
mATDDR12_BIT14:     equ    %100000000000000
mATDDR12_BIT15:     equ    %1000000000000000


;*** ATDDR12H - ATD Conversion Result Register 12 High; 0x000000A8 ***
ATDDR12H:           equ    $000000A8                                ;*** ATDDR12H - ATD Conversion Result Register 12 High; 0x000000A8 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR12H_BIT8:      equ    0                                         ; ATD Conversion Result Bit 8
ATDDR12H_BIT9:      equ    1                                         ; ATD Conversion Result Bit 9
ATDDR12H_BIT10:     equ    2                                         ; ATD Conversion Result Bit 10
ATDDR12H_BIT11:     equ    3                                         ; ATD Conversion Result Bit 11
ATDDR12H_BIT12:     equ    4                                         ; ATD Conversion Result Bit 12
ATDDR12H_BIT13:     equ    5                                         ; ATD Conversion Result Bit 13
ATDDR12H_BIT14:     equ    6                                         ; ATD Conversion Result Bit 14
ATDDR12H_BIT15:     equ    7                                         ; ATD Conversion Result Bit 15
; bit position masks
mATDDR12H_BIT8:     equ    %00000001
mATDDR12H_BIT9:     equ    %00000010
mATDDR12H_BIT10:    equ    %00000100
mATDDR12H_BIT11:    equ    %00001000
mATDDR12H_BIT12:    equ    %00010000
mATDDR12H_BIT13:    equ    %00100000
mATDDR12H_BIT14:    equ    %01000000
mATDDR12H_BIT15:    equ    %10000000


;*** ATDDR12L - ATD Conversion Result Register 12 Low; 0x000000A9 ***
ATDDR12L:           equ    $000000A9                                ;*** ATDDR12L - ATD Conversion Result Register 12 Low; 0x000000A9 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR12L_BIT0:      equ    0                                         ; ATD Conversion Result Bit 0
ATDDR12L_BIT1:      equ    1                                         ; ATD Conversion Result Bit 1
ATDDR12L_BIT2:      equ    2                                         ; ATD Conversion Result Bit 2
ATDDR12L_BIT3:      equ    3                                         ; ATD Conversion Result Bit 3
ATDDR12L_BIT4:      equ    4                                         ; ATD Conversion Result Bit 4
ATDDR12L_BIT5:      equ    5                                         ; ATD Conversion Result Bit 5
ATDDR12L_BIT6:      equ    6                                         ; ATD Conversion Result Bit 6
ATDDR12L_BIT7:      equ    7                                         ; ATD Conversion Result Bit 7
; bit position masks
mATDDR12L_BIT0:     equ    %00000001
mATDDR12L_BIT1:     equ    %00000010
mATDDR12L_BIT2:     equ    %00000100
mATDDR12L_BIT3:     equ    %00001000
mATDDR12L_BIT4:     equ    %00010000
mATDDR12L_BIT5:     equ    %00100000
mATDDR12L_BIT6:     equ    %01000000
mATDDR12L_BIT7:     equ    %10000000


;*** ATDDR13 - ATD Conversion Result Register 13; 0x000000AA ***
ATDDR13:            equ    $000000AA                                ;*** ATDDR13 - ATD Conversion Result Register 13; 0x000000AA ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR13_BIT0:       equ    0                                         ; ATD Conversion Result Bit 0
ATDDR13_BIT1:       equ    1                                         ; ATD Conversion Result Bit 1
ATDDR13_BIT2:       equ    2                                         ; ATD Conversion Result Bit 2
ATDDR13_BIT3:       equ    3                                         ; ATD Conversion Result Bit 3
ATDDR13_BIT4:       equ    4                                         ; ATD Conversion Result Bit 4
ATDDR13_BIT5:       equ    5                                         ; ATD Conversion Result Bit 5
ATDDR13_BIT6:       equ    6                                         ; ATD Conversion Result Bit 6
ATDDR13_BIT7:       equ    7                                         ; ATD Conversion Result Bit 7
ATDDR13_BIT8:       equ    8                                         ; ATD Conversion Result Bit 8
ATDDR13_BIT9:       equ    9                                         ; ATD Conversion Result Bit 9
ATDDR13_BIT10:      equ    10                                        ; ATD Conversion Result Bit 10
ATDDR13_BIT11:      equ    11                                        ; ATD Conversion Result Bit 11
ATDDR13_BIT12:      equ    12                                        ; ATD Conversion Result Bit 12
ATDDR13_BIT13:      equ    13                                        ; ATD Conversion Result Bit 13
ATDDR13_BIT14:      equ    14                                        ; ATD Conversion Result Bit 14
ATDDR13_BIT15:      equ    15                                        ; ATD Conversion Result Bit 15
; bit position masks
mATDDR13_BIT0:      equ    %00000001
mATDDR13_BIT1:      equ    %00000010
mATDDR13_BIT2:      equ    %00000100
mATDDR13_BIT3:      equ    %00001000
mATDDR13_BIT4:      equ    %00010000
mATDDR13_BIT5:      equ    %00100000
mATDDR13_BIT6:      equ    %01000000
mATDDR13_BIT7:      equ    %10000000
mATDDR13_BIT8:      equ    %100000000
mATDDR13_BIT9:      equ    %1000000000
mATDDR13_BIT10:     equ    %10000000000
mATDDR13_BIT11:     equ    %100000000000
mATDDR13_BIT12:     equ    %1000000000000
mATDDR13_BIT13:     equ    %10000000000000
mATDDR13_BIT14:     equ    %100000000000000
mATDDR13_BIT15:     equ    %1000000000000000


;*** ATDDR13H - ATD Conversion Result Register 13 High; 0x000000AA ***
ATDDR13H:           equ    $000000AA                                ;*** ATDDR13H - ATD Conversion Result Register 13 High; 0x000000AA ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR13H_BIT8:      equ    0                                         ; ATD Conversion Result Bit 8
ATDDR13H_BIT9:      equ    1                                         ; ATD Conversion Result Bit 9
ATDDR13H_BIT10:     equ    2                                         ; ATD Conversion Result Bit 10
ATDDR13H_BIT11:     equ    3                                         ; ATD Conversion Result Bit 11
ATDDR13H_BIT12:     equ    4                                         ; ATD Conversion Result Bit 12
ATDDR13H_BIT13:     equ    5                                         ; ATD Conversion Result Bit 13
ATDDR13H_BIT14:     equ    6                                         ; ATD Conversion Result Bit 14
ATDDR13H_BIT15:     equ    7                                         ; ATD Conversion Result Bit 15
; bit position masks
mATDDR13H_BIT8:     equ    %00000001
mATDDR13H_BIT9:     equ    %00000010
mATDDR13H_BIT10:    equ    %00000100
mATDDR13H_BIT11:    equ    %00001000
mATDDR13H_BIT12:    equ    %00010000
mATDDR13H_BIT13:    equ    %00100000
mATDDR13H_BIT14:    equ    %01000000
mATDDR13H_BIT15:    equ    %10000000


;*** ATDDR13L - ATD Conversion Result Register 13 Low; 0x000000AB ***
ATDDR13L:           equ    $000000AB                                ;*** ATDDR13L - ATD Conversion Result Register 13 Low; 0x000000AB ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR13L_BIT0:      equ    0                                         ; ATD Conversion Result Bit 0
ATDDR13L_BIT1:      equ    1                                         ; ATD Conversion Result Bit 1
ATDDR13L_BIT2:      equ    2                                         ; ATD Conversion Result Bit 2
ATDDR13L_BIT3:      equ    3                                         ; ATD Conversion Result Bit 3
ATDDR13L_BIT4:      equ    4                                         ; ATD Conversion Result Bit 4
ATDDR13L_BIT5:      equ    5                                         ; ATD Conversion Result Bit 5
ATDDR13L_BIT6:      equ    6                                         ; ATD Conversion Result Bit 6
ATDDR13L_BIT7:      equ    7                                         ; ATD Conversion Result Bit 7
; bit position masks
mATDDR13L_BIT0:     equ    %00000001
mATDDR13L_BIT1:     equ    %00000010
mATDDR13L_BIT2:     equ    %00000100
mATDDR13L_BIT3:     equ    %00001000
mATDDR13L_BIT4:     equ    %00010000
mATDDR13L_BIT5:     equ    %00100000
mATDDR13L_BIT6:     equ    %01000000
mATDDR13L_BIT7:     equ    %10000000


;*** ATDDR14 - ATD Conversion Result Register 14; 0x000000AC ***
ATDDR14:            equ    $000000AC                                ;*** ATDDR14 - ATD Conversion Result Register 14; 0x000000AC ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR14_BIT0:       equ    0                                         ; ATD Conversion Result Bit 0
ATDDR14_BIT1:       equ    1                                         ; ATD Conversion Result Bit 1
ATDDR14_BIT2:       equ    2                                         ; ATD Conversion Result Bit 2
ATDDR14_BIT3:       equ    3                                         ; ATD Conversion Result Bit 3
ATDDR14_BIT4:       equ    4                                         ; ATD Conversion Result Bit 4
ATDDR14_BIT5:       equ    5                                         ; ATD Conversion Result Bit 5
ATDDR14_BIT6:       equ    6                                         ; ATD Conversion Result Bit 6
ATDDR14_BIT7:       equ    7                                         ; ATD Conversion Result Bit 7
ATDDR14_BIT8:       equ    8                                         ; ATD Conversion Result Bit 8
ATDDR14_BIT9:       equ    9                                         ; ATD Conversion Result Bit 9
ATDDR14_BIT10:      equ    10                                        ; ATD Conversion Result Bit 10
ATDDR14_BIT11:      equ    11                                        ; ATD Conversion Result Bit 11
ATDDR14_BIT12:      equ    12                                        ; ATD Conversion Result Bit 12
ATDDR14_BIT13:      equ    13                                        ; ATD Conversion Result Bit 13
ATDDR14_BIT14:      equ    14                                        ; ATD Conversion Result Bit 14
ATDDR14_BIT15:      equ    15                                        ; ATD Conversion Result Bit 15
; bit position masks
mATDDR14_BIT0:      equ    %00000001
mATDDR14_BIT1:      equ    %00000010
mATDDR14_BIT2:      equ    %00000100
mATDDR14_BIT3:      equ    %00001000
mATDDR14_BIT4:      equ    %00010000
mATDDR14_BIT5:      equ    %00100000
mATDDR14_BIT6:      equ    %01000000
mATDDR14_BIT7:      equ    %10000000
mATDDR14_BIT8:      equ    %100000000
mATDDR14_BIT9:      equ    %1000000000
mATDDR14_BIT10:     equ    %10000000000
mATDDR14_BIT11:     equ    %100000000000
mATDDR14_BIT12:     equ    %1000000000000
mATDDR14_BIT13:     equ    %10000000000000
mATDDR14_BIT14:     equ    %100000000000000
mATDDR14_BIT15:     equ    %1000000000000000


;*** ATDDR14H - ATD Conversion Result Register 14 High; 0x000000AC ***
ATDDR14H:           equ    $000000AC                                ;*** ATDDR14H - ATD Conversion Result Register 14 High; 0x000000AC ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR14H_BIT8:      equ    0                                         ; ATD Conversion Result Bit 8
ATDDR14H_BIT9:      equ    1                                         ; ATD Conversion Result Bit 9
ATDDR14H_BIT10:     equ    2                                         ; ATD Conversion Result Bit 10
ATDDR14H_BIT11:     equ    3                                         ; ATD Conversion Result Bit 11
ATDDR14H_BIT12:     equ    4                                         ; ATD Conversion Result Bit 12
ATDDR14H_BIT13:     equ    5                                         ; ATD Conversion Result Bit 13
ATDDR14H_BIT14:     equ    6                                         ; ATD Conversion Result Bit 14
ATDDR14H_BIT15:     equ    7                                         ; ATD Conversion Result Bit 15
; bit position masks
mATDDR14H_BIT8:     equ    %00000001
mATDDR14H_BIT9:     equ    %00000010
mATDDR14H_BIT10:    equ    %00000100
mATDDR14H_BIT11:    equ    %00001000
mATDDR14H_BIT12:    equ    %00010000
mATDDR14H_BIT13:    equ    %00100000
mATDDR14H_BIT14:    equ    %01000000
mATDDR14H_BIT15:    equ    %10000000


;*** ATDDR14L - ATD Conversion Result Register 14 Low; 0x000000AD ***
ATDDR14L:           equ    $000000AD                                ;*** ATDDR14L - ATD Conversion Result Register 14 Low; 0x000000AD ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR14L_BIT0:      equ    0                                         ; ATD Conversion Result Bit 0
ATDDR14L_BIT1:      equ    1                                         ; ATD Conversion Result Bit 1
ATDDR14L_BIT2:      equ    2                                         ; ATD Conversion Result Bit 2
ATDDR14L_BIT3:      equ    3                                         ; ATD Conversion Result Bit 3
ATDDR14L_BIT4:      equ    4                                         ; ATD Conversion Result Bit 4
ATDDR14L_BIT5:      equ    5                                         ; ATD Conversion Result Bit 5
ATDDR14L_BIT6:      equ    6                                         ; ATD Conversion Result Bit 6
ATDDR14L_BIT7:      equ    7                                         ; ATD Conversion Result Bit 7
; bit position masks
mATDDR14L_BIT0:     equ    %00000001
mATDDR14L_BIT1:     equ    %00000010
mATDDR14L_BIT2:     equ    %00000100
mATDDR14L_BIT3:     equ    %00001000
mATDDR14L_BIT4:     equ    %00010000
mATDDR14L_BIT5:     equ    %00100000
mATDDR14L_BIT6:     equ    %01000000
mATDDR14L_BIT7:     equ    %10000000


;*** ATDDR15 - ATD Conversion Result Register 15; 0x000000AE ***
ATDDR15:            equ    $000000AE                                ;*** ATDDR15 - ATD Conversion Result Register 15; 0x000000AE ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR15_BIT0:       equ    0                                         ; ATD Conversion Result Bit 0
ATDDR15_BIT1:       equ    1                                         ; ATD Conversion Result Bit 1
ATDDR15_BIT2:       equ    2                                         ; ATD Conversion Result Bit 2
ATDDR15_BIT3:       equ    3                                         ; ATD Conversion Result Bit 3
ATDDR15_BIT4:       equ    4                                         ; ATD Conversion Result Bit 4
ATDDR15_BIT5:       equ    5                                         ; ATD Conversion Result Bit 5
ATDDR15_BIT6:       equ    6                                         ; ATD Conversion Result Bit 6
ATDDR15_BIT7:       equ    7                                         ; ATD Conversion Result Bit 7
ATDDR15_BIT8:       equ    8                                         ; ATD Conversion Result Bit 8
ATDDR15_BIT9:       equ    9                                         ; ATD Conversion Result Bit 9
ATDDR15_BIT10:      equ    10                                        ; ATD Conversion Result Bit 10
ATDDR15_BIT11:      equ    11                                        ; ATD Conversion Result Bit 11
ATDDR15_BIT12:      equ    12                                        ; ATD Conversion Result Bit 12
ATDDR15_BIT13:      equ    13                                        ; ATD Conversion Result Bit 13
ATDDR15_BIT14:      equ    14                                        ; ATD Conversion Result Bit 14
ATDDR15_BIT15:      equ    15                                        ; ATD Conversion Result Bit 15
; bit position masks
mATDDR15_BIT0:      equ    %00000001
mATDDR15_BIT1:      equ    %00000010
mATDDR15_BIT2:      equ    %00000100
mATDDR15_BIT3:      equ    %00001000
mATDDR15_BIT4:      equ    %00010000
mATDDR15_BIT5:      equ    %00100000
mATDDR15_BIT6:      equ    %01000000
mATDDR15_BIT7:      equ    %10000000
mATDDR15_BIT8:      equ    %100000000
mATDDR15_BIT9:      equ    %1000000000
mATDDR15_BIT10:     equ    %10000000000
mATDDR15_BIT11:     equ    %100000000000
mATDDR15_BIT12:     equ    %1000000000000
mATDDR15_BIT13:     equ    %10000000000000
mATDDR15_BIT14:     equ    %100000000000000
mATDDR15_BIT15:     equ    %1000000000000000


;*** ATDDR15H - ATD Conversion Result Register 15 High; 0x000000AE ***
ATDDR15H:           equ    $000000AE                                ;*** ATDDR15H - ATD Conversion Result Register 15 High; 0x000000AE ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR15H_BIT8:      equ    0                                         ; ATD Conversion Result Bit 8
ATDDR15H_BIT9:      equ    1                                         ; ATD Conversion Result Bit 9
ATDDR15H_BIT10:     equ    2                                         ; ATD Conversion Result Bit 10
ATDDR15H_BIT11:     equ    3                                         ; ATD Conversion Result Bit 11
ATDDR15H_BIT12:     equ    4                                         ; ATD Conversion Result Bit 12
ATDDR15H_BIT13:     equ    5                                         ; ATD Conversion Result Bit 13
ATDDR15H_BIT14:     equ    6                                         ; ATD Conversion Result Bit 14
ATDDR15H_BIT15:     equ    7                                         ; ATD Conversion Result Bit 15
; bit position masks
mATDDR15H_BIT8:     equ    %00000001
mATDDR15H_BIT9:     equ    %00000010
mATDDR15H_BIT10:    equ    %00000100
mATDDR15H_BIT11:    equ    %00001000
mATDDR15H_BIT12:    equ    %00010000
mATDDR15H_BIT13:    equ    %00100000
mATDDR15H_BIT14:    equ    %01000000
mATDDR15H_BIT15:    equ    %10000000


;*** ATDDR15L - ATD Conversion Result Register 15 Low; 0x000000AF ***
ATDDR15L:           equ    $000000AF                                ;*** ATDDR15L - ATD Conversion Result Register 15 Low; 0x000000AF ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR15L_BIT0:      equ    0                                         ; ATD Conversion Result Bit 0
ATDDR15L_BIT1:      equ    1                                         ; ATD Conversion Result Bit 1
ATDDR15L_BIT2:      equ    2                                         ; ATD Conversion Result Bit 2
ATDDR15L_BIT3:      equ    3                                         ; ATD Conversion Result Bit 3
ATDDR15L_BIT4:      equ    4                                         ; ATD Conversion Result Bit 4
ATDDR15L_BIT5:      equ    5                                         ; ATD Conversion Result Bit 5
ATDDR15L_BIT6:      equ    6                                         ; ATD Conversion Result Bit 6
ATDDR15L_BIT7:      equ    7                                         ; ATD Conversion Result Bit 7
; bit position masks
mATDDR15L_BIT0:     equ    %00000001
mATDDR15L_BIT1:     equ    %00000010
mATDDR15L_BIT2:     equ    %00000100
mATDDR15L_BIT3:     equ    %00001000
mATDDR15L_BIT4:     equ    %00010000
mATDDR15L_BIT5:     equ    %00100000
mATDDR15L_BIT6:     equ    %01000000
mATDDR15L_BIT7:     equ    %10000000


;*** IBAD - IIC Address Register; 0x000000C0 ***
IBAD:               equ    $000000C0                                ;*** IBAD - IIC Address Register; 0x000000C0 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
IBAD_ADR1:          equ    1                                         ; Slave Address Bit 1
IBAD_ADR2:          equ    2                                         ; Slave Address Bit 2
IBAD_ADR3:          equ    3                                         ; Slave Address Bit 3
IBAD_ADR4:          equ    4                                         ; Slave Address Bit 4
IBAD_ADR5:          equ    5                                         ; Slave Address Bit 5
IBAD_ADR6:          equ    6                                         ; Slave Address Bit 6
IBAD_ADR7:          equ    7                                         ; Slave Address Bit 7
; bit position masks
mIBAD_ADR1:         equ    %00000010
mIBAD_ADR2:         equ    %00000100
mIBAD_ADR3:         equ    %00001000
mIBAD_ADR4:         equ    %00010000
mIBAD_ADR5:         equ    %00100000
mIBAD_ADR6:         equ    %01000000
mIBAD_ADR7:         equ    %10000000


;*** IBFD - IIC Frequency Divider Register; 0x000000C1 ***
IBFD:               equ    $000000C1                                ;*** IBFD - IIC Frequency Divider Register; 0x000000C1 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
IBFD_IBC0:          equ    0                                         ; I-Bus Clock Rate 0
IBFD_IBC1:          equ    1                                         ; I-Bus Clock Rate 1
IBFD_IBC2:          equ    2                                         ; I-Bus Clock Rate 2
IBFD_IBC3:          equ    3                                         ; I-Bus Clock Rate 3
IBFD_IBC4:          equ    4                                         ; I-Bus Clock Rate 4
IBFD_IBC5:          equ    5                                         ; I-Bus Clock Rate 5
IBFD_IBC6:          equ    6                                         ; I-Bus Clock Rate 6
IBFD_IBC7:          equ    7                                         ; I-Bus Clock Rate 7
; bit position masks
mIBFD_IBC0:         equ    %00000001
mIBFD_IBC1:         equ    %00000010
mIBFD_IBC2:         equ    %00000100
mIBFD_IBC3:         equ    %00001000
mIBFD_IBC4:         equ    %00010000
mIBFD_IBC5:         equ    %00100000
mIBFD_IBC6:         equ    %01000000
mIBFD_IBC7:         equ    %10000000


;*** IBCR - IIC Control Register; 0x000000C2 ***
IBCR:               equ    $000000C2                                ;*** IBCR - IIC Control Register; 0x000000C2 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
IBCR_IBSWAI:        equ    0                                         ; I-Bus Interface Stop in WAIT mode
IBCR_RSTA:          equ    2                                         ; Repeat Start
IBCR_TXAK:          equ    3                                         ; Transmit Acknowledge enable
IBCR_TX_RX:         equ    4                                         ; Transmit/Receive mode select bit
IBCR_MS_SL:         equ    5                                         ; Master/Slave mode select bit
IBCR_IBIE:          equ    6                                         ; I-Bus Interrupt Enable
IBCR_IBEN:          equ    7                                         ; I-Bus Enable
; bit position masks
mIBCR_IBSWAI:       equ    %00000001
mIBCR_RSTA:         equ    %00000100
mIBCR_TXAK:         equ    %00001000
mIBCR_TX_RX:        equ    %00010000
mIBCR_MS_SL:        equ    %00100000
mIBCR_IBIE:         equ    %01000000
mIBCR_IBEN:         equ    %10000000


;*** IBSR - IIC Status Register; 0x000000C3 ***
IBSR:               equ    $000000C3                                ;*** IBSR - IIC Status Register; 0x000000C3 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
IBSR_RXAK:          equ    0                                         ; Received Acknowledge
IBSR_IBIF:          equ    1                                         ; I-Bus Interrupt
IBSR_SRW:           equ    2                                         ; Slave Read/Write
IBSR_IBAL:          equ    4                                         ; Arbitration Lost
IBSR_IBB:           equ    5                                         ; Bus busy bit
IBSR_IAAS:          equ    6                                         ; Addressed as a slave bit
IBSR_TCF:           equ    7                                         ; Data transferring bit
; bit position masks
mIBSR_RXAK:         equ    %00000001
mIBSR_IBIF:         equ    %00000010
mIBSR_SRW:          equ    %00000100
mIBSR_IBAL:         equ    %00010000
mIBSR_IBB:          equ    %00100000
mIBSR_IAAS:         equ    %01000000
mIBSR_TCF:          equ    %10000000


;*** IBDR - IIC Data I/O Register; 0x000000C4 ***
IBDR:               equ    $000000C4                                ;*** IBDR - IIC Data I/O Register; 0x000000C4 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
IBDR_D0:            equ    0                                         ; IIC Data Bit 0
IBDR_D1:            equ    1                                         ; IIC Data Bit 1
IBDR_D2:            equ    2                                         ; IIC Data Bit 2
IBDR_D3:            equ    3                                         ; IIC Data Bit 3
IBDR_D4:            equ    4                                         ; IIC Data Bit 4
IBDR_D5:            equ    5                                         ; IIC Data Bit 5
IBDR_D6:            equ    6                                         ; IIC Data Bit 6
IBDR_D7:            equ    7                                         ; IIC Data Bit 7
; bit position masks
mIBDR_D0:           equ    %00000001
mIBDR_D1:           equ    %00000010
mIBDR_D2:           equ    %00000100
mIBDR_D3:           equ    %00001000
mIBDR_D4:           equ    %00010000
mIBDR_D5:           equ    %00100000
mIBDR_D6:           equ    %01000000
mIBDR_D7:           equ    %10000000


;*** SCI0BD - SCI 0 Baud Rate Register; 0x000000C8 ***
SCI0BD:             equ    $000000C8                                ;*** SCI0BD - SCI 0 Baud Rate Register; 0x000000C8 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI0BD_SBR0:        equ    0                                         ; SCI Baud Rate Bit 0
SCI0BD_SBR1:        equ    1                                         ; SCI Baud Rate Bit 1
SCI0BD_SBR2:        equ    2                                         ; SCI Baud Rate Bit 2
SCI0BD_SBR3:        equ    3                                         ; SCI Baud Rate Bit 3
SCI0BD_SBR4:        equ    4                                         ; SCI Baud Rate Bit 4
SCI0BD_SBR5:        equ    5                                         ; SCI Baud Rate Bit 5
SCI0BD_SBR6:        equ    6                                         ; SCI Baud Rate Bit 6
SCI0BD_SBR7:        equ    7                                         ; SCI Baud Rate Bit 7
SCI0BD_SBR8:        equ    8                                         ; SCI Baud Rate Bit 8
SCI0BD_SBR9:        equ    9                                         ; SCI Baud Rate Bit 9
SCI0BD_SBR10:       equ    10                                        ; SCI Baud Rate Bit 10
SCI0BD_SBR11:       equ    11                                        ; SCI Baud Rate Bit 11
SCI0BD_SBR12:       equ    12                                        ; SCI Baud Rate Bit 12
SCI0BD_TNP0:        equ    13                                        ; Transmitter Narrow Pulse Bit 0
SCI0BD_TNP1:        equ    14                                        ; Transmitter Narrow Pulse Bit 1
SCI0BD_IREN:        equ    15                                        ; Infrared Enable Bit
; bit position masks
mSCI0BD_SBR0:       equ    %00000001
mSCI0BD_SBR1:       equ    %00000010
mSCI0BD_SBR2:       equ    %00000100
mSCI0BD_SBR3:       equ    %00001000
mSCI0BD_SBR4:       equ    %00010000
mSCI0BD_SBR5:       equ    %00100000
mSCI0BD_SBR6:       equ    %01000000
mSCI0BD_SBR7:       equ    %10000000
mSCI0BD_SBR8:       equ    %100000000
mSCI0BD_SBR9:       equ    %1000000000
mSCI0BD_SBR10:      equ    %10000000000
mSCI0BD_SBR11:      equ    %100000000000
mSCI0BD_SBR12:      equ    %1000000000000
mSCI0BD_TNP0:       equ    %10000000000000
mSCI0BD_TNP1:       equ    %100000000000000
mSCI0BD_IREN:       equ    %1000000000000000


;*** SCI0BDH - SCI 0 Baud Rate Register High; 0x000000C8 ***
SCI0BDH:            equ    $000000C8                                ;*** SCI0BDH - SCI 0 Baud Rate Register High; 0x000000C8 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI0BDH_SBR8:       equ    0                                         ; SCI Baud Rate Bit 8
SCI0BDH_SBR9:       equ    1                                         ; SCI Baud Rate Bit 9
SCI0BDH_SBR10:      equ    2                                         ; SCI Baud Rate Bit 10
SCI0BDH_SBR11:      equ    3                                         ; SCI Baud Rate Bit 11
SCI0BDH_SBR12:      equ    4                                         ; SCI Baud Rate Bit 12
SCI0BDH_TNP0:       equ    5                                         ; Transmitter Narrow Pulse Bit 0
SCI0BDH_TNP1:       equ    6                                         ; Transmitter Narrow Pulse Bit 1
SCI0BDH_IREN:       equ    7                                         ; Infrared Enable Bit
; bit position masks
mSCI0BDH_SBR8:      equ    %00000001
mSCI0BDH_SBR9:      equ    %00000010
mSCI0BDH_SBR10:     equ    %00000100
mSCI0BDH_SBR11:     equ    %00001000
mSCI0BDH_SBR12:     equ    %00010000
mSCI0BDH_TNP0:      equ    %00100000
mSCI0BDH_TNP1:      equ    %01000000
mSCI0BDH_IREN:      equ    %10000000


;*** SCI0BDL - SCI 0 Baud Rate Register Low; 0x000000C9 ***
SCI0BDL:            equ    $000000C9                                ;*** SCI0BDL - SCI 0 Baud Rate Register Low; 0x000000C9 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI0BDL_SBR0:       equ    0                                         ; SCI Baud Rate Bit 0
SCI0BDL_SBR1:       equ    1                                         ; SCI Baud Rate Bit 1
SCI0BDL_SBR2:       equ    2                                         ; SCI Baud Rate Bit 2
SCI0BDL_SBR3:       equ    3                                         ; SCI Baud Rate Bit 3
SCI0BDL_SBR4:       equ    4                                         ; SCI Baud Rate Bit 4
SCI0BDL_SBR5:       equ    5                                         ; SCI Baud Rate Bit 5
SCI0BDL_SBR6:       equ    6                                         ; SCI Baud Rate Bit 6
SCI0BDL_SBR7:       equ    7                                         ; SCI Baud Rate Bit 7
; bit position masks
mSCI0BDL_SBR0:      equ    %00000001
mSCI0BDL_SBR1:      equ    %00000010
mSCI0BDL_SBR2:      equ    %00000100
mSCI0BDL_SBR3:      equ    %00001000
mSCI0BDL_SBR4:      equ    %00010000
mSCI0BDL_SBR5:      equ    %00100000
mSCI0BDL_SBR6:      equ    %01000000
mSCI0BDL_SBR7:      equ    %10000000


;*** SCI0CR1 - SCI 0 Control Register 1; 0x000000CA ***
SCI0CR1:            equ    $000000CA                                ;*** SCI0CR1 - SCI 0 Control Register 1; 0x000000CA ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI0CR1_PT:         equ    0                                         ; Parity Type Bit
SCI0CR1_PE:         equ    1                                         ; Parity Enable Bit
SCI0CR1_ILT:        equ    2                                         ; Idle Line Type Bit
SCI0CR1_WAKE:       equ    3                                         ; Wakeup Condition Bit
SCI0CR1_M:          equ    4                                         ; Data Format Mode Bit
SCI0CR1_RSRC:       equ    5                                         ; Receiver Source Bit
SCI0CR1_SCISWAI:    equ    6                                         ; SCI Stop in Wait Mode Bit
SCI0CR1_LOOPS:      equ    7                                         ; Loop Select Bit
; bit position masks
mSCI0CR1_PT:        equ    %00000001
mSCI0CR1_PE:        equ    %00000010
mSCI0CR1_ILT:       equ    %00000100
mSCI0CR1_WAKE:      equ    %00001000
mSCI0CR1_M:         equ    %00010000
mSCI0CR1_RSRC:      equ    %00100000
mSCI0CR1_SCISWAI:   equ    %01000000
mSCI0CR1_LOOPS:     equ    %10000000


;*** SCI0CR2 - SCI 0 Control Register 2; 0x000000CB ***
SCI0CR2:            equ    $000000CB                                ;*** SCI0CR2 - SCI 0 Control Register 2; 0x000000CB ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI0CR2_SBK:        equ    0                                         ; Send Break Bit
SCI0CR2_RWU:        equ    1                                         ; Receiver Wakeup Bit
SCI0CR2_RE:         equ    2                                         ; Receiver Enable Bit
SCI0CR2_TE:         equ    3                                         ; Transmitter Enable Bit
SCI0CR2_ILIE:       equ    4                                         ; Idle Line Interrupt Enable Bit
SCI0CR2_RIE:        equ    5                                         ; Receiver Full Interrupt Enable Bit
SCI0CR2_TCIE:       equ    6                                         ; Transmission Complete Interrupt Enable Bit
SCI0CR2_SCTIE:      equ    7                                         ; Transmitter Interrupt Enable Bit
; bit position masks
mSCI0CR2_SBK:       equ    %00000001
mSCI0CR2_RWU:       equ    %00000010
mSCI0CR2_RE:        equ    %00000100
mSCI0CR2_TE:        equ    %00001000
mSCI0CR2_ILIE:      equ    %00010000
mSCI0CR2_RIE:       equ    %00100000
mSCI0CR2_TCIE:      equ    %01000000
mSCI0CR2_SCTIE:     equ    %10000000


;*** SCI0SR1 - SCI 0 Status Register 1; 0x000000CC ***
SCI0SR1:            equ    $000000CC                                ;*** SCI0SR1 - SCI 0 Status Register 1; 0x000000CC ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI0SR1_PF:         equ    0                                         ; Parity Error Flag
SCI0SR1_FE:         equ    1                                         ; Framing Error Flag
SCI0SR1_NF:         equ    2                                         ; Noise Flag
SCI0SR1_OR:         equ    3                                         ; Overrun Flag
SCI0SR1_IDLE:       equ    4                                         ; Idle Line Flag
SCI0SR1_RDRF:       equ    5                                         ; Receive Data Register Full Flag
SCI0SR1_TC:         equ    6                                         ; Transmit Complete Flag
SCI0SR1_TDRE:       equ    7                                         ; Transmit Data Register Empty Flag
; bit position masks
mSCI0SR1_PF:        equ    %00000001
mSCI0SR1_FE:        equ    %00000010
mSCI0SR1_NF:        equ    %00000100
mSCI0SR1_OR:        equ    %00001000
mSCI0SR1_IDLE:      equ    %00010000
mSCI0SR1_RDRF:      equ    %00100000
mSCI0SR1_TC:        equ    %01000000
mSCI0SR1_TDRE:      equ    %10000000


;*** SCI0SR2 - SCI 0 Status Register 2; 0x000000CD ***
SCI0SR2:            equ    $000000CD                                ;*** SCI0SR2 - SCI 0 Status Register 2; 0x000000CD ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI0SR2_RAF:        equ    0                                         ; Receiver Active Flag
SCI0SR2_TXDIR:      equ    1                                         ; Transmitter pin data direction in Single-Wire mode
SCI0SR2_BRK13:      equ    2                                         ; Break Transmit character length
SCI0SR2_RXPOL:      equ    3                                         ; Receive Polarity
SCI0SR2_TXPOL:      equ    4                                         ; Transmit Polarity
; bit position masks
mSCI0SR2_RAF:       equ    %00000001
mSCI0SR2_TXDIR:     equ    %00000010
mSCI0SR2_BRK13:     equ    %00000100
mSCI0SR2_RXPOL:     equ    %00001000
mSCI0SR2_TXPOL:     equ    %00010000


;*** SCI0DRH - SCI 0 Data Register High; 0x000000CE ***
SCI0DRH:            equ    $000000CE                                ;*** SCI0DRH - SCI 0 Data Register High; 0x000000CE ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI0DRH_T8:         equ    6                                         ; Transmit Bit 8
SCI0DRH_R8:         equ    7                                         ; Received Bit 8
; bit position masks
mSCI0DRH_T8:        equ    %01000000
mSCI0DRH_R8:        equ    %10000000


;*** SCI0DRL - SCI 0 Data Register Low; 0x000000CF ***
SCI0DRL:            equ    $000000CF                                ;*** SCI0DRL - SCI 0 Data Register Low; 0x000000CF ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI0DRL_R0_T0:      equ    0                                         ; Received bit 0 or Transmit bit 0
SCI0DRL_R1_T1:      equ    1                                         ; Received bit 1 or Transmit bit 1
SCI0DRL_R2_T2:      equ    2                                         ; Received bit 2 or Transmit bit 2
SCI0DRL_R3_T3:      equ    3                                         ; Received bit 3 or Transmit bit 3
SCI0DRL_R4_T4:      equ    4                                         ; Received bit 4 or Transmit bit 4
SCI0DRL_R5_T5:      equ    5                                         ; Received bit 5 or Transmit bit 5
SCI0DRL_R6_T6:      equ    6                                         ; Received bit 6 or Transmit bit 6
SCI0DRL_R7_T7:      equ    7                                         ; Received bit 7 or Transmit bit 7
; bit position masks
mSCI0DRL_R0_T0:     equ    %00000001
mSCI0DRL_R1_T1:     equ    %00000010
mSCI0DRL_R2_T2:     equ    %00000100
mSCI0DRL_R3_T3:     equ    %00001000
mSCI0DRL_R4_T4:     equ    %00010000
mSCI0DRL_R5_T5:     equ    %00100000
mSCI0DRL_R6_T6:     equ    %01000000
mSCI0DRL_R7_T7:     equ    %10000000


;*** SCI1BD - SCI 1 Baud Rate Register; 0x000000D0 ***
SCI1BD:             equ    $000000D0                                ;*** SCI1BD - SCI 1 Baud Rate Register; 0x000000D0 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI1BD_SBR0:        equ    0                                         ; SCI Baud Rate Bit 0
SCI1BD_SBR1:        equ    1                                         ; SCI Baud Rate Bit 1
SCI1BD_SBR2:        equ    2                                         ; SCI Baud Rate Bit 2
SCI1BD_SBR3:        equ    3                                         ; SCI Baud Rate Bit 3
SCI1BD_SBR4:        equ    4                                         ; SCI Baud Rate Bit 4
SCI1BD_SBR5:        equ    5                                         ; SCI Baud Rate Bit 5
SCI1BD_SBR6:        equ    6                                         ; SCI Baud Rate Bit 6
SCI1BD_SBR7:        equ    7                                         ; SCI Baud Rate Bit 7
SCI1BD_SBR8:        equ    8                                         ; SCI Baud Rate Bit 8
SCI1BD_SBR9:        equ    9                                         ; SCI Baud Rate Bit 9
SCI1BD_SBR10:       equ    10                                        ; SCI Baud Rate Bit 10
SCI1BD_SBR11:       equ    11                                        ; SCI Baud Rate Bit 11
SCI1BD_SBR12:       equ    12                                        ; SCI Baud Rate Bit 12
SCI1BD_TNP0:        equ    13                                        ; Transmitter Narrow Pulse Bit 0
SCI1BD_TNP1:        equ    14                                        ; Transmitter Narrow Pulse Bit 1
SCI1BD_IREN:        equ    15                                        ; Infrared Enable Bit
; bit position masks
mSCI1BD_SBR0:       equ    %00000001
mSCI1BD_SBR1:       equ    %00000010
mSCI1BD_SBR2:       equ    %00000100
mSCI1BD_SBR3:       equ    %00001000
mSCI1BD_SBR4:       equ    %00010000
mSCI1BD_SBR5:       equ    %00100000
mSCI1BD_SBR6:       equ    %01000000
mSCI1BD_SBR7:       equ    %10000000
mSCI1BD_SBR8:       equ    %100000000
mSCI1BD_SBR9:       equ    %1000000000
mSCI1BD_SBR10:      equ    %10000000000
mSCI1BD_SBR11:      equ    %100000000000
mSCI1BD_SBR12:      equ    %1000000000000
mSCI1BD_TNP0:       equ    %10000000000000
mSCI1BD_TNP1:       equ    %100000000000000
mSCI1BD_IREN:       equ    %1000000000000000


;*** SCI1BDH - SCI 1 Baud Rate Register High; 0x000000D0 ***
SCI1BDH:            equ    $000000D0                                ;*** SCI1BDH - SCI 1 Baud Rate Register High; 0x000000D0 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI1BDH_SBR8:       equ    0                                         ; SCI Baud Rate Bit 8
SCI1BDH_SBR9:       equ    1                                         ; SCI Baud Rate Bit 9
SCI1BDH_SBR10:      equ    2                                         ; SCI Baud Rate Bit 10
SCI1BDH_SBR11:      equ    3                                         ; SCI Baud Rate Bit 11
SCI1BDH_SBR12:      equ    4                                         ; SCI Baud Rate Bit 12
SCI1BDH_TNP0:       equ    5                                         ; Transmitter Narrow Pulse Bit 0
SCI1BDH_TNP1:       equ    6                                         ; Transmitter Narrow Pulse Bit 1
SCI1BDH_IREN:       equ    7                                         ; Infrared Enable Bit
; bit position masks
mSCI1BDH_SBR8:      equ    %00000001
mSCI1BDH_SBR9:      equ    %00000010
mSCI1BDH_SBR10:     equ    %00000100
mSCI1BDH_SBR11:     equ    %00001000
mSCI1BDH_SBR12:     equ    %00010000
mSCI1BDH_TNP0:      equ    %00100000
mSCI1BDH_TNP1:      equ    %01000000
mSCI1BDH_IREN:      equ    %10000000


;*** SCI1BDL - SCI 1 Baud Rate Register Low; 0x000000D1 ***
SCI1BDL:            equ    $000000D1                                ;*** SCI1BDL - SCI 1 Baud Rate Register Low; 0x000000D1 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI1BDL_SBR0:       equ    0                                         ; SCI Baud Rate Bit 0
SCI1BDL_SBR1:       equ    1                                         ; SCI Baud Rate Bit 1
SCI1BDL_SBR2:       equ    2                                         ; SCI Baud Rate Bit 2
SCI1BDL_SBR3:       equ    3                                         ; SCI Baud Rate Bit 3
SCI1BDL_SBR4:       equ    4                                         ; SCI Baud Rate Bit 4
SCI1BDL_SBR5:       equ    5                                         ; SCI Baud Rate Bit 5
SCI1BDL_SBR6:       equ    6                                         ; SCI Baud Rate Bit 6
SCI1BDL_SBR7:       equ    7                                         ; SCI Baud Rate Bit 7
; bit position masks
mSCI1BDL_SBR0:      equ    %00000001
mSCI1BDL_SBR1:      equ    %00000010
mSCI1BDL_SBR2:      equ    %00000100
mSCI1BDL_SBR3:      equ    %00001000
mSCI1BDL_SBR4:      equ    %00010000
mSCI1BDL_SBR5:      equ    %00100000
mSCI1BDL_SBR6:      equ    %01000000
mSCI1BDL_SBR7:      equ    %10000000


;*** SCI1CR1 - SCI 1 Control Register 1; 0x000000D2 ***
SCI1CR1:            equ    $000000D2                                ;*** SCI1CR1 - SCI 1 Control Register 1; 0x000000D2 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI1CR1_PT:         equ    0                                         ; Parity Type Bit
SCI1CR1_PE:         equ    1                                         ; Parity Enable Bit
SCI1CR1_ILT:        equ    2                                         ; Idle Line Type Bit
SCI1CR1_WAKE:       equ    3                                         ; Wakeup Condition Bit
SCI1CR1_M:          equ    4                                         ; Data Format Mode Bit
SCI1CR1_RSRC:       equ    5                                         ; Receiver Source Bit
SCI1CR1_SCISWAI:    equ    6                                         ; SCI Stop in Wait Mode Bit
SCI1CR1_LOOPS:      equ    7                                         ; Loop Select Bit
; bit position masks
mSCI1CR1_PT:        equ    %00000001
mSCI1CR1_PE:        equ    %00000010
mSCI1CR1_ILT:       equ    %00000100
mSCI1CR1_WAKE:      equ    %00001000
mSCI1CR1_M:         equ    %00010000
mSCI1CR1_RSRC:      equ    %00100000
mSCI1CR1_SCISWAI:   equ    %01000000
mSCI1CR1_LOOPS:     equ    %10000000


;*** SCI1CR2 - SCI 1 Control Register 2; 0x000000D3 ***
SCI1CR2:            equ    $000000D3                                ;*** SCI1CR2 - SCI 1 Control Register 2; 0x000000D3 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI1CR2_SBK:        equ    0                                         ; Send Break Bit
SCI1CR2_RWU:        equ    1                                         ; Receiver Wakeup Bit
SCI1CR2_RE:         equ    2                                         ; Receiver Enable Bit
SCI1CR2_TE:         equ    3                                         ; Transmitter Enable Bit
SCI1CR2_ILIE:       equ    4                                         ; Idle Line Interrupt Enable Bit
SCI1CR2_RIE:        equ    5                                         ; Receiver Full Interrupt Enable Bit
SCI1CR2_TCIE:       equ    6                                         ; Transmission Complete Interrupt Enable Bit
SCI1CR2_SCTIE:      equ    7                                         ; Transmitter Interrupt Enable Bit
; bit position masks
mSCI1CR2_SBK:       equ    %00000001
mSCI1CR2_RWU:       equ    %00000010
mSCI1CR2_RE:        equ    %00000100
mSCI1CR2_TE:        equ    %00001000
mSCI1CR2_ILIE:      equ    %00010000
mSCI1CR2_RIE:       equ    %00100000
mSCI1CR2_TCIE:      equ    %01000000
mSCI1CR2_SCTIE:     equ    %10000000


;*** SCI1SR1 - SCI 1 Status Register 1; 0x000000D4 ***
SCI1SR1:            equ    $000000D4                                ;*** SCI1SR1 - SCI 1 Status Register 1; 0x000000D4 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI1SR1_PF:         equ    0                                         ; Parity Error Flag
SCI1SR1_FE:         equ    1                                         ; Framing Error Flag
SCI1SR1_NF:         equ    2                                         ; Noise Flag
SCI1SR1_OR:         equ    3                                         ; Overrun Flag
SCI1SR1_IDLE:       equ    4                                         ; Idle Line Flag
SCI1SR1_RDRF:       equ    5                                         ; Receive Data Register Full Flag
SCI1SR1_TC:         equ    6                                         ; Transmit Complete Flag
SCI1SR1_TDRE:       equ    7                                         ; Transmit Data Register Empty Flag
; bit position masks
mSCI1SR1_PF:        equ    %00000001
mSCI1SR1_FE:        equ    %00000010
mSCI1SR1_NF:        equ    %00000100
mSCI1SR1_OR:        equ    %00001000
mSCI1SR1_IDLE:      equ    %00010000
mSCI1SR1_RDRF:      equ    %00100000
mSCI1SR1_TC:        equ    %01000000
mSCI1SR1_TDRE:      equ    %10000000


;*** SCI1SR2 - SCI 1 Status Register 2; 0x000000D5 ***
SCI1SR2:            equ    $000000D5                                ;*** SCI1SR2 - SCI 1 Status Register 2; 0x000000D5 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI1SR2_RAF:        equ    0                                         ; Receiver Active Flag
SCI1SR2_TXDIR:      equ    1                                         ; Transmitter pin data direction in Single-Wire mode
SCI1SR2_BRK13:      equ    2                                         ; Break Transmit character length
SCI1SR2_RXPOL:      equ    3                                         ; Receive Polarity
SCI1SR2_TXPOL:      equ    4                                         ; Transmit Polarity
; bit position masks
mSCI1SR2_RAF:       equ    %00000001
mSCI1SR2_TXDIR:     equ    %00000010
mSCI1SR2_BRK13:     equ    %00000100
mSCI1SR2_RXPOL:     equ    %00001000
mSCI1SR2_TXPOL:     equ    %00010000


;*** SCI1DRH - SCI 1 Data Register High; 0x000000D6 ***
SCI1DRH:            equ    $000000D6                                ;*** SCI1DRH - SCI 1 Data Register High; 0x000000D6 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI1DRH_T8:         equ    6                                         ; Transmit Bit 8
SCI1DRH_R8:         equ    7                                         ; Received Bit 8
; bit position masks
mSCI1DRH_T8:        equ    %01000000
mSCI1DRH_R8:        equ    %10000000


;*** SCI1DRL - SCI 1 Data Register Low; 0x000000D7 ***
SCI1DRL:            equ    $000000D7                                ;*** SCI1DRL - SCI 1 Data Register Low; 0x000000D7 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI1DRL_R0_T0:      equ    0                                         ; Received bit 0 or Transmit bit 0
SCI1DRL_R1_T1:      equ    1                                         ; Received bit 1 or Transmit bit 1
SCI1DRL_R2_T2:      equ    2                                         ; Received bit 2 or Transmit bit 2
SCI1DRL_R3_T3:      equ    3                                         ; Received bit 3 or Transmit bit 3
SCI1DRL_R4_T4:      equ    4                                         ; Received bit 4 or Transmit bit 4
SCI1DRL_R5_T5:      equ    5                                         ; Received bit 5 or Transmit bit 5
SCI1DRL_R6_T6:      equ    6                                         ; Received bit 6 or Transmit bit 6
SCI1DRL_R7_T7:      equ    7                                         ; Received bit 7 or Transmit bit 7
; bit position masks
mSCI1DRL_R0_T0:     equ    %00000001
mSCI1DRL_R1_T1:     equ    %00000010
mSCI1DRL_R2_T2:     equ    %00000100
mSCI1DRL_R3_T3:     equ    %00001000
mSCI1DRL_R4_T4:     equ    %00010000
mSCI1DRL_R5_T5:     equ    %00100000
mSCI1DRL_R6_T6:     equ    %01000000
mSCI1DRL_R7_T7:     equ    %10000000


;*** SPICR1 - SPI 0 Control Register; 0x000000D8 ***
SPICR1:             equ    $000000D8                                ;*** SPICR1 - SPI 0 Control Register; 0x000000D8 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPICR1_LSBFE:       equ    0                                         ; SPI LSB-First Enable
SPICR1_SSOE:        equ    1                                         ; Slave Select Output Enable
SPICR1_CPHA:        equ    2                                         ; SPI Clock Phase Bit
SPICR1_CPOL:        equ    3                                         ; SPI Clock Polarity Bit
SPICR1_MSTR:        equ    4                                         ; SPI Master/Slave Mode Select Bit
SPICR1_SPTIE:       equ    5                                         ; SPI Transmit Interrupt Enable
SPICR1_SPE:         equ    6                                         ; SPI System Enable Bit
SPICR1_SPIE:        equ    7                                         ; SPI Interrupt Enable Bit
; bit position masks
mSPICR1_LSBFE:      equ    %00000001
mSPICR1_SSOE:       equ    %00000010
mSPICR1_CPHA:       equ    %00000100
mSPICR1_CPOL:       equ    %00001000
mSPICR1_MSTR:       equ    %00010000
mSPICR1_SPTIE:      equ    %00100000
mSPICR1_SPE:        equ    %01000000
mSPICR1_SPIE:       equ    %10000000


;*** SPICR2 - SPI 0 Control Register 2; 0x000000D9 ***
SPICR2:             equ    $000000D9                                ;*** SPICR2 - SPI 0 Control Register 2; 0x000000D9 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPICR2_SPC0:        equ    0                                         ; Serial Pin Control Bit 0
SPICR2_SPISWAI:     equ    1                                         ; SPI Stop in Wait Mode Bit
SPICR2_BIDIROE:     equ    3                                         ; Output enable in the Bidirectional mode of operation
SPICR2_MODFEN:      equ    4                                         ; Mode Fault Enable Bit
; bit position masks
mSPICR2_SPC0:       equ    %00000001
mSPICR2_SPISWAI:    equ    %00000010
mSPICR2_BIDIROE:    equ    %00001000
mSPICR2_MODFEN:     equ    %00010000


;*** SPIBR - SPI 0 Baud Rate Register; 0x000000DA ***
SPIBR:              equ    $000000DA                                ;*** SPIBR - SPI 0 Baud Rate Register; 0x000000DA ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPIBR_SPR0:         equ    0                                         ; SPI Baud Rate Selection Bit 0
SPIBR_SPR1:         equ    1                                         ; SPI Baud Rate Selection Bit 1
SPIBR_SPR2:         equ    2                                         ; SPI Baud Rate Selection Bit 2
SPIBR_SPPR0:        equ    4                                         ; SPI Baud Rate Preselection Bits 0
SPIBR_SPPR1:        equ    5                                         ; SPI Baud Rate Preselection Bits 1
SPIBR_SPPR2:        equ    6                                         ; SPI Baud Rate Preselection Bits 2
; bit position masks
mSPIBR_SPR0:        equ    %00000001
mSPIBR_SPR1:        equ    %00000010
mSPIBR_SPR2:        equ    %00000100
mSPIBR_SPPR0:       equ    %00010000
mSPIBR_SPPR1:       equ    %00100000
mSPIBR_SPPR2:       equ    %01000000


;*** SPISR - SPI 0 Status Register; 0x000000DB ***
SPISR:              equ    $000000DB                                ;*** SPISR - SPI 0 Status Register; 0x000000DB ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPISR_MODF:         equ    4                                         ; Mode Fault Flag
SPISR_SPTEF:        equ    5                                         ; SPI Transmit Empty Interrupt Flag
SPISR_SPIF:         equ    7                                         ; SPIF Receive Interrupt Flag
; bit position masks
mSPISR_MODF:        equ    %00010000
mSPISR_SPTEF:       equ    %00100000
mSPISR_SPIF:        equ    %10000000


;*** SPIDR - SPI 0 Data Register; 0x000000DD ***
SPIDR:              equ    $000000DD                                ;*** SPIDR - SPI 0 Data Register; 0x000000DD ***


;*** PWME - PWM Enable Register; 0x000000E0 ***
PWME:               equ    $000000E0                                ;*** PWME - PWM Enable Register; 0x000000E0 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PWME_PWME0:         equ    0                                         ; Pulse Width Channel 0 Enable
PWME_PWME1:         equ    1                                         ; Pulse Width Channel 1 Enable
PWME_PWME2:         equ    2                                         ; Pulse Width Channel 2 Enable
PWME_PWME3:         equ    3                                         ; Pulse Width Channel 3 Enable
PWME_PWME4:         equ    4                                         ; Pulse Width Channel 4 Enable
PWME_PWME5:         equ    5                                         ; Pulse Width Channel 5 Enable
; bit position masks
mPWME_PWME0:        equ    %00000001
mPWME_PWME1:        equ    %00000010
mPWME_PWME2:        equ    %00000100
mPWME_PWME3:        equ    %00001000
mPWME_PWME4:        equ    %00010000
mPWME_PWME5:        equ    %00100000


;*** PWMPOL - PWM Polarity Register; 0x000000E1 ***
PWMPOL:             equ    $000000E1                                ;*** PWMPOL - PWM Polarity Register; 0x000000E1 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PWMPOL_PPOL0:       equ    0                                         ; Pulse Width Channel 0 Polarity
PWMPOL_PPOL1:       equ    1                                         ; Pulse Width Channel 1 Polarity
PWMPOL_PPOL2:       equ    2                                         ; Pulse Width Channel 2 Polarity
PWMPOL_PPOL3:       equ    3                                         ; Pulse Width Channel 3 Polarity
PWMPOL_PPOL4:       equ    4                                         ; Pulse Width Channel 4 Polarity
PWMPOL_PPOL5:       equ    5                                         ; Pulse Width Channel 5 Polarity
; bit position masks
mPWMPOL_PPOL0:      equ    %00000001
mPWMPOL_PPOL1:      equ    %00000010
mPWMPOL_PPOL2:      equ    %00000100
mPWMPOL_PPOL3:      equ    %00001000
mPWMPOL_PPOL4:      equ    %00010000
mPWMPOL_PPOL5:      equ    %00100000


;*** PWMCLK - PWM Clock Select Register; 0x000000E2 ***
PWMCLK:             equ    $000000E2                                ;*** PWMCLK - PWM Clock Select Register; 0x000000E2 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PWMCLK_PCLK0:       equ    0                                         ; Pulse Width Channel 0 Clock Select
PWMCLK_PCLK1:       equ    1                                         ; Pulse Width Channel 1 Clock Select
PWMCLK_PCLK2:       equ    2                                         ; Pulse Width Channel 2 Clock Select
PWMCLK_PCLK3:       equ    3                                         ; Pulse Width Channel 3 Clock Select
PWMCLK_PCLK4:       equ    4                                         ; Pulse Width Channel 4 Clock Select
PWMCLK_PCLK5:       equ    5                                         ; Pulse Width Channel 5 Clock Select
; bit position masks
mPWMCLK_PCLK0:      equ    %00000001
mPWMCLK_PCLK1:      equ    %00000010
mPWMCLK_PCLK2:      equ    %00000100
mPWMCLK_PCLK3:      equ    %00001000
mPWMCLK_PCLK4:      equ    %00010000
mPWMCLK_PCLK5:      equ    %00100000


;*** PWMPRCLK - PWM Prescale Clock Select Register; 0x000000E3 ***
PWMPRCLK:           equ    $000000E3                                ;*** PWMPRCLK - PWM Prescale Clock Select Register; 0x000000E3 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PWMPRCLK_PCKA0:     equ    0                                         ; Prescaler Select for Clock A 0
PWMPRCLK_PCKA1:     equ    1                                         ; Prescaler Select for Clock A 1
PWMPRCLK_PCKA2:     equ    2                                         ; Prescaler Select for Clock A 2
PWMPRCLK_PCKB0:     equ    4                                         ; Prescaler Select for Clock B 0
PWMPRCLK_PCKB1:     equ    5                                         ; Prescaler Select for Clock B 1
PWMPRCLK_PCKB2:     equ    6                                         ; Prescaler Select for Clock B 2
; bit position masks
mPWMPRCLK_PCKA0:    equ    %00000001
mPWMPRCLK_PCKA1:    equ    %00000010
mPWMPRCLK_PCKA2:    equ    %00000100
mPWMPRCLK_PCKB0:    equ    %00010000
mPWMPRCLK_PCKB1:    equ    %00100000
mPWMPRCLK_PCKB2:    equ    %01000000


;*** PWMCAE - PWM Center Align Enable Register; 0x000000E4 ***
PWMCAE:             equ    $000000E4                                ;*** PWMCAE - PWM Center Align Enable Register; 0x000000E4 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PWMCAE_CAE0:        equ    0                                         ; Center Aligned Output Mode on channel 0
PWMCAE_CAE1:        equ    1                                         ; Center Aligned Output Mode on channel 1
PWMCAE_CAE2:        equ    2                                         ; Center Aligned Output Mode on channel 2
PWMCAE_CAE3:        equ    3                                         ; Center Aligned Output Mode on channel 3
PWMCAE_CAE4:        equ    4                                         ; Center Aligned Output Mode on channel 4
PWMCAE_CAE5:        equ    5                                         ; Center Aligned Output Mode on channel 5
; bit position masks
mPWMCAE_CAE0:       equ    %00000001
mPWMCAE_CAE1:       equ    %00000010
mPWMCAE_CAE2:       equ    %00000100
mPWMCAE_CAE3:       equ    %00001000
mPWMCAE_CAE4:       equ    %00010000
mPWMCAE_CAE5:       equ    %00100000


;*** PWMCTL - PWM Control Register; 0x000000E5 ***
PWMCTL:             equ    $000000E5                                ;*** PWMCTL - PWM Control Register; 0x000000E5 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PWMCTL_PFRZ:        equ    2                                         ; PWM Counters Stop in Freeze Mode
PWMCTL_PSWAI:       equ    3                                         ; PWM Stops in Wait Mode
PWMCTL_CON01:       equ    4                                         ; Concatenate channels 0 and 1
PWMCTL_CON23:       equ    5                                         ; Concatenate channels 2 and 3
PWMCTL_CON45:       equ    6                                         ; Concatenate channels 4 and 5
; bit position masks
mPWMCTL_PFRZ:       equ    %00000100
mPWMCTL_PSWAI:      equ    %00001000
mPWMCTL_CON01:      equ    %00010000
mPWMCTL_CON23:      equ    %00100000
mPWMCTL_CON45:      equ    %01000000


;*** PWMSCLA - PWM Scale A Register; 0x000000E8 ***
PWMSCLA:            equ    $000000E8                                ;*** PWMSCLA - PWM Scale A Register; 0x000000E8 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PWMSCLA_BIT0:       equ    0                                         ; PWM Scale A Bit 0
PWMSCLA_BIT1:       equ    1                                         ; PWM Scale A Bit 1
PWMSCLA_BIT2:       equ    2                                         ; PWM Scale A Bit 2
PWMSCLA_BIT3:       equ    3                                         ; PWM Scale A Bit 3
PWMSCLA_BIT4:       equ    4                                         ; PWM Scale A Bit 4
PWMSCLA_BIT5:       equ    5                                         ; PWM Scale A Bit 5
PWMSCLA_BIT6:       equ    6                                         ; PWM Scale A Bit 6
PWMSCLA_BIT7:       equ    7                                         ; PWM Scale A Bit 7
; bit position masks
mPWMSCLA_BIT0:      equ    %00000001
mPWMSCLA_BIT1:      equ    %00000010
mPWMSCLA_BIT2:      equ    %00000100
mPWMSCLA_BIT3:      equ    %00001000
mPWMSCLA_BIT4:      equ    %00010000
mPWMSCLA_BIT5:      equ    %00100000
mPWMSCLA_BIT6:      equ    %01000000
mPWMSCLA_BIT7:      equ    %10000000


;*** PWMSCLB - PWM Scale B Register; 0x000000E9 ***
PWMSCLB:            equ    $000000E9                                ;*** PWMSCLB - PWM Scale B Register; 0x000000E9 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PWMSCLB_BIT0:       equ    0                                         ; PWM Scale B Bit 0
PWMSCLB_BIT1:       equ    1                                         ; PWM Scale B Bit 1
PWMSCLB_BIT2:       equ    2                                         ; PWM Scale B Bit 2
PWMSCLB_BIT3:       equ    3                                         ; PWM Scale B Bit 3
PWMSCLB_BIT4:       equ    4                                         ; PWM Scale B Bit 4
PWMSCLB_BIT5:       equ    5                                         ; PWM Scale B Bit 5
PWMSCLB_BIT6:       equ    6                                         ; PWM Scale B Bit 6
PWMSCLB_BIT7:       equ    7                                         ; PWM Scale B Bit 7
; bit position masks
mPWMSCLB_BIT0:      equ    %00000001
mPWMSCLB_BIT1:      equ    %00000010
mPWMSCLB_BIT2:      equ    %00000100
mPWMSCLB_BIT3:      equ    %00001000
mPWMSCLB_BIT4:      equ    %00010000
mPWMSCLB_BIT5:      equ    %00100000
mPWMSCLB_BIT6:      equ    %01000000
mPWMSCLB_BIT7:      equ    %10000000


;*** PWMCNT01 - PWM Channel Counter 01 Register; 0x000000EC ***
PWMCNT01:           equ    $000000EC                                ;*** PWMCNT01 - PWM Channel Counter 01 Register; 0x000000EC ***


;*** PWMCNT0 - PWM Channel Counter 0 Register; 0x000000EC ***
PWMCNT0:            equ    $000000EC                                ;*** PWMCNT0 - PWM Channel Counter 0 Register; 0x000000EC ***


;*** PWMCNT1 - PWM Channel Counter 1 Register; 0x000000ED ***
PWMCNT1:            equ    $000000ED                                ;*** PWMCNT1 - PWM Channel Counter 1 Register; 0x000000ED ***


;*** PWMCNT23 - PWM Channel Counter 23 Register; 0x000000EE ***
PWMCNT23:           equ    $000000EE                                ;*** PWMCNT23 - PWM Channel Counter 23 Register; 0x000000EE ***


;*** PWMCNT2 - PWM Channel Counter 2 Register; 0x000000EE ***
PWMCNT2:            equ    $000000EE                                ;*** PWMCNT2 - PWM Channel Counter 2 Register; 0x000000EE ***


;*** PWMCNT3 - PWM Channel Counter 3 Register; 0x000000EF ***
PWMCNT3:            equ    $000000EF                                ;*** PWMCNT3 - PWM Channel Counter 3 Register; 0x000000EF ***


;*** PWMCNT45 - PWM Channel Counter 45 Register; 0x000000F0 ***
PWMCNT45:           equ    $000000F0                                ;*** PWMCNT45 - PWM Channel Counter 45 Register; 0x000000F0 ***


;*** PWMCNT4 - PWM Channel Counter 4 Register; 0x000000F0 ***
PWMCNT4:            equ    $000000F0                                ;*** PWMCNT4 - PWM Channel Counter 4 Register; 0x000000F0 ***


;*** PWMCNT5 - PWM Channel Counter 5 Register; 0x000000F1 ***
PWMCNT5:            equ    $000000F1                                ;*** PWMCNT5 - PWM Channel Counter 5 Register; 0x000000F1 ***


;*** PWMPER01 - PWM Channel Period 01 Register; 0x000000F2 ***
PWMPER01:           equ    $000000F2                                ;*** PWMPER01 - PWM Channel Period 01 Register; 0x000000F2 ***


;*** PWMPER0 - PWM Channel Period 0 Register; 0x000000F2 ***
PWMPER0:            equ    $000000F2                                ;*** PWMPER0 - PWM Channel Period 0 Register; 0x000000F2 ***


;*** PWMPER1 - PWM Channel Period 1 Register; 0x000000F3 ***
PWMPER1:            equ    $000000F3                                ;*** PWMPER1 - PWM Channel Period 1 Register; 0x000000F3 ***


;*** PWMPER23 - PWM Channel Period 23 Register; 0x000000F4 ***
PWMPER23:           equ    $000000F4                                ;*** PWMPER23 - PWM Channel Period 23 Register; 0x000000F4 ***


;*** PWMPER2 - PWM Channel Period 2 Register; 0x000000F4 ***
PWMPER2:            equ    $000000F4                                ;*** PWMPER2 - PWM Channel Period 2 Register; 0x000000F4 ***


;*** PWMPER3 - PWM Channel Period 3 Register; 0x000000F5 ***
PWMPER3:            equ    $000000F5                                ;*** PWMPER3 - PWM Channel Period 3 Register; 0x000000F5 ***


;*** PWMPER45 - PWM Channel Period 45 Register; 0x000000F6 ***
PWMPER45:           equ    $000000F6                                ;*** PWMPER45 - PWM Channel Period 45 Register; 0x000000F6 ***


;*** PWMPER4 - PWM Channel Period 4 Register; 0x000000F6 ***
PWMPER4:            equ    $000000F6                                ;*** PWMPER4 - PWM Channel Period 4 Register; 0x000000F6 ***


;*** PWMPER5 - PWM Channel Period 5 Register; 0x000000F7 ***
PWMPER5:            equ    $000000F7                                ;*** PWMPER5 - PWM Channel Period 5 Register; 0x000000F7 ***


;*** PWMDTY01 - PWM Channel Duty 01 Register; 0x000000F8 ***
PWMDTY01:           equ    $000000F8                                ;*** PWMDTY01 - PWM Channel Duty 01 Register; 0x000000F8 ***


;*** PWMDTY0 - PWM Channel Duty 0 Register; 0x000000F8 ***
PWMDTY0:            equ    $000000F8                                ;*** PWMDTY0 - PWM Channel Duty 0 Register; 0x000000F8 ***


;*** PWMDTY1 - PWM Channel Duty 1 Register; 0x000000F9 ***
PWMDTY1:            equ    $000000F9                                ;*** PWMDTY1 - PWM Channel Duty 1 Register; 0x000000F9 ***


;*** PWMDTY23 - PWM Channel Duty 23 Register; 0x000000FA ***
PWMDTY23:           equ    $000000FA                                ;*** PWMDTY23 - PWM Channel Duty 23 Register; 0x000000FA ***


;*** PWMDTY2 - PWM Channel Duty 2 Register; 0x000000FA ***
PWMDTY2:            equ    $000000FA                                ;*** PWMDTY2 - PWM Channel Duty 2 Register; 0x000000FA ***


;*** PWMDTY3 - PWM Channel Duty 3 Register; 0x000000FB ***
PWMDTY3:            equ    $000000FB                                ;*** PWMDTY3 - PWM Channel Duty 3 Register; 0x000000FB ***


;*** PWMDTY45 - PWM Channel Duty 45 Register; 0x000000FC ***
PWMDTY45:           equ    $000000FC                                ;*** PWMDTY45 - PWM Channel Duty 45 Register; 0x000000FC ***


;*** PWMDTY4 - PWM Channel Duty 4 Register; 0x000000FC ***
PWMDTY4:            equ    $000000FC                                ;*** PWMDTY4 - PWM Channel Duty 4 Register; 0x000000FC ***


;*** PWMDTY5 - PWM Channel Duty 5 Register; 0x000000FD ***
PWMDTY5:            equ    $000000FD                                ;*** PWMDTY5 - PWM Channel Duty 5 Register; 0x000000FD ***


;*** PWMSDN - PWM Shutdown Register; 0x000000FE ***
PWMSDN:             equ    $000000FE                                ;*** PWMSDN - PWM Shutdown Register; 0x000000FE ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PWMSDN_PWM5ENA:     equ    0                                         ; PWM emergency shutdown Enable
PWMSDN_PWM5INL:     equ    1                                         ; PWM shutdown active input level for ch. 5
PWMSDN_PWM5IN:      equ    2                                         ; PWM channel 5 input status
PWMSDN_PWMLVL:      equ    4                                         ; PWM shutdown output Level
PWMSDN_PWMRSTRT:    equ    5                                         ; PWM Restart
PWMSDN_PWMIE:       equ    6                                         ; PWM Interrupt Enable
PWMSDN_PWMIF:       equ    7                                         ; PWM Interrupt Flag
; bit position masks
mPWMSDN_PWM5ENA:    equ    %00000001
mPWMSDN_PWM5INL:    equ    %00000010
mPWMSDN_PWM5IN:     equ    %00000100
mPWMSDN_PWMLVL:     equ    %00010000
mPWMSDN_PWMRSTRT:   equ    %00100000
mPWMSDN_PWMIE:      equ    %01000000
mPWMSDN_PWMIF:      equ    %10000000


;*** FCLKDIV - Flash Clock Divider Register; 0x00000100 ***
FCLKDIV:            equ    $00000100                                ;*** FCLKDIV - Flash Clock Divider Register; 0x00000100 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FCLKDIV_FDIV0:      equ    0                                         ; Flash Clock Divider Bit 0
FCLKDIV_FDIV1:      equ    1                                         ; Flash Clock Divider Bit 1
FCLKDIV_FDIV2:      equ    2                                         ; Flash Clock Divider Bit 2
FCLKDIV_FDIV3:      equ    3                                         ; Flash Clock Divider Bit 3
FCLKDIV_FDIV4:      equ    4                                         ; Flash Clock Divider Bit 4
FCLKDIV_FDIV5:      equ    5                                         ; Flash Clock Divider Bit 5
FCLKDIV_PRDIV8:     equ    6                                         ; Enable Prescaler by 8
FCLKDIV_FDIVLD:     equ    7                                         ; Flash Clock Divider Loaded
; bit position masks
mFCLKDIV_FDIV0:     equ    %00000001
mFCLKDIV_FDIV1:     equ    %00000010
mFCLKDIV_FDIV2:     equ    %00000100
mFCLKDIV_FDIV3:     equ    %00001000
mFCLKDIV_FDIV4:     equ    %00010000
mFCLKDIV_FDIV5:     equ    %00100000
mFCLKDIV_PRDIV8:    equ    %01000000
mFCLKDIV_FDIVLD:    equ    %10000000


;*** FSEC - Flash Security Register; 0x00000101 ***
FSEC:               equ    $00000101                                ;*** FSEC - Flash Security Register; 0x00000101 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FSEC_SEC0:          equ    0                                         ; Memory security bit 0
FSEC_SEC1:          equ    1                                         ; Memory security bit 1
FSEC_RNV2:          equ    2                                         ; Reserved Non Volatile flag bit 2
FSEC_RNV3:          equ    3                                         ; Reserved Non Volatile flag bit 3
FSEC_RNV4:          equ    4                                         ; Reserved Non Volatile flag bit 4
FSEC_RNV5:          equ    5                                         ; Reserved Non Volatile flag bit 5
FSEC_KEYEN0:        equ    6                                         ; Backdoor Key Security Enable Bit 0
FSEC_KEYEN1:        equ    7                                         ; Backdoor Key Security Enable Bit 1
; bit position masks
mFSEC_SEC0:         equ    %00000001
mFSEC_SEC1:         equ    %00000010
mFSEC_RNV2:         equ    %00000100
mFSEC_RNV3:         equ    %00001000
mFSEC_RNV4:         equ    %00010000
mFSEC_RNV5:         equ    %00100000
mFSEC_KEYEN0:       equ    %01000000
mFSEC_KEYEN1:       equ    %10000000


;*** FCNFG - Flash Configuration Register; 0x00000103 ***
FCNFG:              equ    $00000103                                ;*** FCNFG - Flash Configuration Register; 0x00000103 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FCNFG_BKSEL:        equ    0                                         ; Register Bank Select Bit
FCNFG_KEYACC:       equ    5                                         ; Enable Security Key Writing
FCNFG_CCIE:         equ    6                                         ; Command Complete Interrupt Enable
FCNFG_CBEIE:        equ    7                                         ; Command Buffers Empty Interrupt Enable
; bit position masks
mFCNFG_BKSEL:       equ    %00000001
mFCNFG_KEYACC:      equ    %00100000
mFCNFG_CCIE:        equ    %01000000
mFCNFG_CBEIE:       equ    %10000000


;*** FPROT - Flash Protection Register; 0x00000104 ***
FPROT:              equ    $00000104                                ;*** FPROT - Flash Protection Register; 0x00000104 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FPROT_FPLS0:        equ    0                                         ; Flash Protection Lower Address size 0
FPROT_FPLS1:        equ    1                                         ; Flash Protection Lower Address size 1
FPROT_FPLDIS:       equ    2                                         ; Flash Protection Lower address range disable
FPROT_FPHS0:        equ    3                                         ; Flash Protection Higher address size 0
FPROT_FPHS1:        equ    4                                         ; Flash Protection Higher address size 1
FPROT_FPHDIS:       equ    5                                         ; Flash Protection Higher address range disable
FPROT_RNV6:         equ    6                                         ; Reserved  Non Volatile Flag Bit
FPROT_FPOPEN:       equ    7                                         ; Opens the flash block or subsections of it for program or erase
; bit position masks
mFPROT_FPLS0:       equ    %00000001
mFPROT_FPLS1:       equ    %00000010
mFPROT_FPLDIS:      equ    %00000100
mFPROT_FPHS0:       equ    %00001000
mFPROT_FPHS1:       equ    %00010000
mFPROT_FPHDIS:      equ    %00100000
mFPROT_RNV6:        equ    %01000000
mFPROT_FPOPEN:      equ    %10000000


;*** FSTAT - Flash Status Register; 0x00000105 ***
FSTAT:              equ    $00000105                                ;*** FSTAT - Flash Status Register; 0x00000105 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FSTAT_BLANK:        equ    2                                         ; Blank Verify Flag
FSTAT_ACCERR:       equ    4                                         ; Access error
FSTAT_PVIOL:        equ    5                                         ; Protection violation
FSTAT_CCIF:         equ    6                                         ; Command Complete Interrupt Flag
FSTAT_CBEIF:        equ    7                                         ; Command Buffers Empty Interrupt Flag
; bit position masks
mFSTAT_BLANK:       equ    %00000100
mFSTAT_ACCERR:      equ    %00010000
mFSTAT_PVIOL:       equ    %00100000
mFSTAT_CCIF:        equ    %01000000
mFSTAT_CBEIF:       equ    %10000000


;*** FCMD - Flash Command Buffer and Register; 0x00000106 ***
FCMD:               equ    $00000106                                ;*** FCMD - Flash Command Buffer and Register; 0x00000106 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FCMD_CMDB0:         equ    0                                         ; Flash Command Bit 0
FCMD_CMDB1:         equ    1                                         ; Flash Command Bit 1
FCMD_CMDB2:         equ    2                                         ; Flash Command Bit 2
FCMD_CMDB3:         equ    3                                         ; Flash Command Bit 3
FCMD_CMDB4:         equ    4                                         ; Flash Command Bit 4
FCMD_CMDB5:         equ    5                                         ; Flash Command Bit 5
FCMD_CMDB6:         equ    6                                         ; Flash Command Bit 6
; bit position masks
mFCMD_CMDB0:        equ    %00000001
mFCMD_CMDB1:        equ    %00000010
mFCMD_CMDB2:        equ    %00000100
mFCMD_CMDB3:        equ    %00001000
mFCMD_CMDB4:        equ    %00010000
mFCMD_CMDB5:        equ    %00100000
mFCMD_CMDB6:        equ    %01000000


;*** FCTL - Flash Control Register; 0x00000107 ***
FCTL:               equ    $00000107                                ;*** FCTL - Flash Control Register; 0x00000107 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FCTL_NV0:           equ    0                                         ; Non-Volatile Bit 0
FCTL_NV1:           equ    1                                         ; Non-Volatile Bit 1
FCTL_NV2:           equ    2                                         ; Non-Volatile Bit 2
FCTL_NV3:           equ    3                                         ; Non-Volatile Bit 3
FCTL_NV4:           equ    4                                         ; Non-Volatile Bit 4
FCTL_NV5:           equ    5                                         ; Non-Volatile Bit 5
FCTL_NV6:           equ    6                                         ; Non-Volatile Bit 6
FCTL_NV7:           equ    7                                         ; Non-Volatile Bit 7
; bit position masks
mFCTL_NV0:          equ    %00000001
mFCTL_NV1:          equ    %00000010
mFCTL_NV2:          equ    %00000100
mFCTL_NV3:          equ    %00001000
mFCTL_NV4:          equ    %00010000
mFCTL_NV5:          equ    %00100000
mFCTL_NV6:          equ    %01000000
mFCTL_NV7:          equ    %10000000


;*** FADDRHI - Flash Address High Register; 0x00000108 ***
FADDRHI:            equ    $00000108                                ;*** FADDRHI - Flash Address High Register; 0x00000108 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FADDRHI_FADDRHI8:   equ    0                                         ; Flash Address High Bit 8
FADDRHI_FADDRHI9:   equ    1                                         ; Flash Address High Bit 9
FADDRHI_FADDRHI10:  equ    2                                         ; Flash Address High Bit 10
FADDRHI_FADDRHI11:  equ    3                                         ; Flash Address High Bit 11
FADDRHI_FADDRHI12:  equ    4                                         ; Flash Address High Bit 12
FADDRHI_FADDRHI13:  equ    5                                         ; Flash Address High Bit 13
FADDRHI_FADDRHI14:  equ    6                                         ; Flash Address High Bit 14
FADDRHI_FADDRHI15:  equ    7                                         ; Flash Address High Bit 15
; bit position masks
mFADDRHI_FADDRHI8:  equ    %00000001
mFADDRHI_FADDRHI9:  equ    %00000010
mFADDRHI_FADDRHI10: equ    %00000100
mFADDRHI_FADDRHI11: equ    %00001000
mFADDRHI_FADDRHI12: equ    %00010000
mFADDRHI_FADDRHI13: equ    %00100000
mFADDRHI_FADDRHI14: equ    %01000000
mFADDRHI_FADDRHI15: equ    %10000000


;*** FADDRLO - Flash Address Low Register; 0x00000109 ***
FADDRLO:            equ    $00000109                                ;*** FADDRLO - Flash Address Low Register; 0x00000109 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FADDRLO_FADDRLO0:   equ    0                                         ; Flash Address Low Bit 0
FADDRLO_FADDRLO1:   equ    1                                         ; Flash Address Low Bit 1
FADDRLO_FADDRLO2:   equ    2                                         ; Flash Address Low Bit 2
FADDRLO_FADDRLO3:   equ    3                                         ; Flash Address Low Bit 3
FADDRLO_FADDRLO4:   equ    4                                         ; Flash Address Low Bit 4
FADDRLO_FADDRLO5:   equ    5                                         ; Flash Address Low Bit 5
FADDRLO_FADDRLO6:   equ    6                                         ; Flash Address Low Bit 6
FADDRLO_FADDRLO7:   equ    7                                         ; Flash Address Low Bit 7
; bit position masks
mFADDRLO_FADDRLO0:  equ    %00000001
mFADDRLO_FADDRLO1:  equ    %00000010
mFADDRLO_FADDRLO2:  equ    %00000100
mFADDRLO_FADDRLO3:  equ    %00001000
mFADDRLO_FADDRLO4:  equ    %00010000
mFADDRLO_FADDRLO5:  equ    %00100000
mFADDRLO_FADDRLO6:  equ    %01000000
mFADDRLO_FADDRLO7:  equ    %10000000


;*** FDATAHI - Flash Data High Register; 0x0000010A ***
FDATAHI:            equ    $0000010A                                ;*** FDATAHI - Flash Data High Register; 0x0000010A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FDATAHI_FDATAHI8:   equ    0                                         ; Flash Data High Bit 8
FDATAHI_FDATAHI9:   equ    1                                         ; Flash Data High Bit 9
FDATAHI_FDATAHI10:  equ    2                                         ; Flash Data High Bit 10
FDATAHI_FDATAHI11:  equ    3                                         ; Flash Data High Bit 11
FDATAHI_FDATAHI12:  equ    4                                         ; Flash Data High Bit 12
FDATAHI_FDATAHI13:  equ    5                                         ; Flash Data High Bit 13
FDATAHI_FDATAHI14:  equ    6                                         ; Flash Data High Bit 14
FDATAHI_FDATAHI15:  equ    7                                         ; Flash Data High Bit 15
; bit position masks
mFDATAHI_FDATAHI8:  equ    %00000001
mFDATAHI_FDATAHI9:  equ    %00000010
mFDATAHI_FDATAHI10: equ    %00000100
mFDATAHI_FDATAHI11: equ    %00001000
mFDATAHI_FDATAHI12: equ    %00010000
mFDATAHI_FDATAHI13: equ    %00100000
mFDATAHI_FDATAHI14: equ    %01000000
mFDATAHI_FDATAHI15: equ    %10000000


;*** FDATALO - Flash Data Low Register; 0x0000010B ***
FDATALO:            equ    $0000010B                                ;*** FDATALO - Flash Data Low Register; 0x0000010B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FDATALO_FDATALO0:   equ    0                                         ; Flash Data Low Bit 0
FDATALO_FDATALO1:   equ    1                                         ; Flash Data Low Bit 1
FDATALO_FDATALO2:   equ    2                                         ; Flash Data Low Bit 2
FDATALO_FDATALO3:   equ    3                                         ; Flash Data Low Bit 3
FDATALO_FDATALO4:   equ    4                                         ; Flash Data Low Bit 4
FDATALO_FDATALO5:   equ    5                                         ; Flash Data Low Bit 5
FDATALO_FDATALO6:   equ    6                                         ; Flash Data Low Bit 6
FDATALO_FDATALO7:   equ    7                                         ; Flash Data Low Bit 7
; bit position masks
mFDATALO_FDATALO0:  equ    %00000001
mFDATALO_FDATALO1:  equ    %00000010
mFDATALO_FDATALO2:  equ    %00000100
mFDATALO_FDATALO3:  equ    %00001000
mFDATALO_FDATALO4:  equ    %00010000
mFDATALO_FDATALO5:  equ    %00100000
mFDATALO_FDATALO6:  equ    %01000000
mFDATALO_FDATALO7:  equ    %10000000


;*** ECLKDIV - EEPROM Clock Divider Register; 0x00000110 ***
ECLKDIV:            equ    $00000110                                ;*** ECLKDIV - EEPROM Clock Divider Register; 0x00000110 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ECLKDIV_EDIV0:      equ    0                                         ; EEPROM Clock Divider 0
ECLKDIV_EDIV1:      equ    1                                         ; EEPROM Clock Divider 1
ECLKDIV_EDIV2:      equ    2                                         ; EEPROM Clock Divider 2
ECLKDIV_EDIV3:      equ    3                                         ; EEPROM Clock Divider 3
ECLKDIV_EDIV4:      equ    4                                         ; EEPROM Clock Divider 4
ECLKDIV_EDIV5:      equ    5                                         ; EEPROM Clock Divider 5
ECLKDIV_PRDIV8:     equ    6                                         ; Enable Prescaler by 8
ECLKDIV_EDIVLD:     equ    7                                         ; EEPROM Clock Divider Loaded
; bit position masks
mECLKDIV_EDIV0:     equ    %00000001
mECLKDIV_EDIV1:     equ    %00000010
mECLKDIV_EDIV2:     equ    %00000100
mECLKDIV_EDIV3:     equ    %00001000
mECLKDIV_EDIV4:     equ    %00010000
mECLKDIV_EDIV5:     equ    %00100000
mECLKDIV_PRDIV8:    equ    %01000000
mECLKDIV_EDIVLD:    equ    %10000000


;*** ECNFG - EEPROM Configuration Register; 0x00000113 ***
ECNFG:              equ    $00000113                                ;*** ECNFG - EEPROM Configuration Register; 0x00000113 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ECNFG_CCIE:         equ    6                                         ; Command Complete Interrupt Enable
ECNFG_CBEIE:        equ    7                                         ; Command Buffers Empty Interrupt Enable
; bit position masks
mECNFG_CCIE:        equ    %01000000
mECNFG_CBEIE:       equ    %10000000


;*** EPROT - EEPROM Protection Register; 0x00000114 ***
EPROT:              equ    $00000114                                ;*** EPROT - EEPROM Protection Register; 0x00000114 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
EPROT_EP0:          equ    0                                         ; EEPROM Protection address size 0
EPROT_EP1:          equ    1                                         ; EEPROM Protection address size 1
EPROT_EP2:          equ    2                                         ; EEPROM Protection address size 2
EPROT_EPDIS:        equ    3                                         ; EEPROM Protection disable
EPROT_NV4:          equ    4                                         ; Non Volatile Flag Bit 4
EPROT_NV5:          equ    5                                         ; Non Volatile Flag Bit 5
EPROT_NV6:          equ    6                                         ; Non Volatile Flag Bit 6
EPROT_EPOPEN:       equ    7                                         ; Opens the EEPROM block or a subsection of it for program or erase
; bit position masks
mEPROT_EP0:         equ    %00000001
mEPROT_EP1:         equ    %00000010
mEPROT_EP2:         equ    %00000100
mEPROT_EPDIS:       equ    %00001000
mEPROT_NV4:         equ    %00010000
mEPROT_NV5:         equ    %00100000
mEPROT_NV6:         equ    %01000000
mEPROT_EPOPEN:      equ    %10000000


;*** ESTAT - EEPROM Status Register; 0x00000115 ***
ESTAT:              equ    $00000115                                ;*** ESTAT - EEPROM Status Register; 0x00000115 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ESTAT_BLANK:        equ    2                                         ; Blank Verify Flag
ESTAT_ACCERR:       equ    4                                         ; Access error
ESTAT_PVIOL:        equ    5                                         ; Protection violation
ESTAT_CCIF:         equ    6                                         ; Command Complete Interrupt Flag
ESTAT_CBEIF:        equ    7                                         ; Command Buffer Empty Interrupt Flag
; bit position masks
mESTAT_BLANK:       equ    %00000100
mESTAT_ACCERR:      equ    %00010000
mESTAT_PVIOL:       equ    %00100000
mESTAT_CCIF:        equ    %01000000
mESTAT_CBEIF:       equ    %10000000


;*** ECMD - EEPROM Command Buffer and Register; 0x00000116 ***
ECMD:               equ    $00000116                                ;*** ECMD - EEPROM Command Buffer and Register; 0x00000116 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ECMD_CMDB0:         equ    0                                         ; EEPROM User Mode Command 0
ECMD_CMDB2:         equ    2                                         ; EEPROM User Mode Command 2
ECMD_CMDB5:         equ    5                                         ; EEPROM User Mode Command 5
ECMD_CMDB6:         equ    6                                         ; EEPROM User Mode Command 6
; bit position masks
mECMD_CMDB0:        equ    %00000001
mECMD_CMDB2:        equ    %00000100
mECMD_CMDB5:        equ    %00100000
mECMD_CMDB6:        equ    %01000000


;*** LCDCR0 - LCD Control Register 0; 0x00000120 ***
LCDCR0:             equ    $00000120                                ;*** LCDCR0 - LCD Control Register 0; 0x00000120 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
LCDCR0_DUTY0:       equ    0                                         ; LCD Duty Select Bit 0
LCDCR0_DUTY1:       equ    1                                         ; LCD Duty Select Bit 1
LCDCR0_BIAS:        equ    2                                         ; BIAS Voltage Level Select
LCDCR0_LCLK0:       equ    3                                         ; LCD Clock Prescaler Bit 0
LCDCR0_LCLK1:       equ    4                                         ; LCD Clock Prescaler Bit 1
LCDCR0_LCLK2:       equ    5                                         ; LCD Clock Prescaler Bit 2
LCDCR0_LCDEN:       equ    7                                         ; LCD32F4B Driver System Enable
; bit position masks
mLCDCR0_DUTY0:      equ    %00000001
mLCDCR0_DUTY1:      equ    %00000010
mLCDCR0_BIAS:       equ    %00000100
mLCDCR0_LCLK0:      equ    %00001000
mLCDCR0_LCLK1:      equ    %00010000
mLCDCR0_LCLK2:      equ    %00100000
mLCDCR0_LCDEN:      equ    %10000000


;*** LCDCR1 - LCD Control Register 1; 0x00000121 ***
LCDCR1:             equ    $00000121                                ;*** LCDCR1 - LCD Control Register 1; 0x00000121 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
LCDCR1_LCDRPSTP:    equ    0                                         ; LCD Run in Pseudo STOP Mode
LCDCR1_LCDSWAI:     equ    1                                         ; LCD Stop in Wait Mode
; bit position masks
mLCDCR1_LCDRPSTP:   equ    %00000001
mLCDCR1_LCDSWAI:    equ    %00000010


;*** FPENR0 - LCD Frontplane Enable Register 0; 0x00000122 ***
FPENR0:             equ    $00000122                                ;*** FPENR0 - LCD Frontplane Enable Register 0; 0x00000122 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FPENR0_FP0EN:       equ    0                                         ; Frontplane Output Enable Bit 0
FPENR0_FP1EN:       equ    1                                         ; Frontplane Output Enable Bit 1
FPENR0_FP2EN:       equ    2                                         ; Frontplane Output Enable Bit 2
FPENR0_FP3EN:       equ    3                                         ; Frontplane Output Enable Bit 3
FPENR0_FP4EN:       equ    4                                         ; Frontplane Output Enable Bit 4
FPENR0_FP5EN:       equ    5                                         ; Frontplane Output Enable Bit 5
FPENR0_FP6EN:       equ    6                                         ; Frontplane Output Enable Bit 6
FPENR0_FP7EN:       equ    7                                         ; Frontplane Output Enable Bit 7
; bit position masks
mFPENR0_FP0EN:      equ    %00000001
mFPENR0_FP1EN:      equ    %00000010
mFPENR0_FP2EN:      equ    %00000100
mFPENR0_FP3EN:      equ    %00001000
mFPENR0_FP4EN:      equ    %00010000
mFPENR0_FP5EN:      equ    %00100000
mFPENR0_FP6EN:      equ    %01000000
mFPENR0_FP7EN:      equ    %10000000


;*** FPENR1 - LCD Frontplane Enable Register 1; 0x00000123 ***
FPENR1:             equ    $00000123                                ;*** FPENR1 - LCD Frontplane Enable Register 1; 0x00000123 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FPENR1_FP8EN:       equ    0                                         ; Frontplane Output Enable Bit 8
FPENR1_FP9EN:       equ    1                                         ; Frontplane Output Enable Bit 9
FPENR1_FP10EN:      equ    2                                         ; Frontplane Output Enable Bit 10
FPENR1_FP11EN:      equ    3                                         ; Frontplane Output Enable Bit 11
FPENR1_FP12EN:      equ    4                                         ; Frontplane Output Enable Bit 12
FPENR1_FP13EN:      equ    5                                         ; Frontplane Output Enable Bit 13
FPENR1_FP14EN:      equ    6                                         ; Frontplane Output Enable Bit 14
FPENR1_FP15EN:      equ    7                                         ; Frontplane Output Enable Bit 15
; bit position masks
mFPENR1_FP8EN:      equ    %00000001
mFPENR1_FP9EN:      equ    %00000010
mFPENR1_FP10EN:     equ    %00000100
mFPENR1_FP11EN:     equ    %00001000
mFPENR1_FP12EN:     equ    %00010000
mFPENR1_FP13EN:     equ    %00100000
mFPENR1_FP14EN:     equ    %01000000
mFPENR1_FP15EN:     equ    %10000000


;*** FPENR2 - LCD Frontplane Enable Register 2; 0x00000124 ***
FPENR2:             equ    $00000124                                ;*** FPENR2 - LCD Frontplane Enable Register 2; 0x00000124 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FPENR2_FP16EN:      equ    0                                         ; Frontplane Output Enable Bit 16
FPENR2_FP17EN:      equ    1                                         ; Frontplane Output Enable Bit 17
FPENR2_FP18EN:      equ    2                                         ; Frontplane Output Enable Bit 18
FPENR2_FP19EN:      equ    3                                         ; Frontplane Output Enable Bit 19
FPENR2_FP20EN:      equ    4                                         ; Frontplane Output Enable Bit 20
FPENR2_FP21EN:      equ    5                                         ; Frontplane Output Enable Bit 21
FPENR2_FP22EN:      equ    6                                         ; Frontplane Output Enable Bit 22
FPENR2_FP23EN:      equ    7                                         ; Frontplane Output Enable Bit 23
; bit position masks
mFPENR2_FP16EN:     equ    %00000001
mFPENR2_FP17EN:     equ    %00000010
mFPENR2_FP18EN:     equ    %00000100
mFPENR2_FP19EN:     equ    %00001000
mFPENR2_FP20EN:     equ    %00010000
mFPENR2_FP21EN:     equ    %00100000
mFPENR2_FP22EN:     equ    %01000000
mFPENR2_FP23EN:     equ    %10000000


;*** FPENR3 - LCD Frontplane Enable Register 3; 0x00000125 ***
FPENR3:             equ    $00000125                                ;*** FPENR3 - LCD Frontplane Enable Register 3; 0x00000125 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FPENR3_FP24EN:      equ    0                                         ; Frontplane Output Enable Bit 24
FPENR3_FP25EN:      equ    1                                         ; Frontplane Output Enable Bit 25
FPENR3_FP26EN:      equ    2                                         ; Frontplane Output Enable Bit 26
FPENR3_FP27EN:      equ    3                                         ; Frontplane Output Enable Bit 27
FPENR3_FP28EN:      equ    4                                         ; Frontplane Output Enable Bit 28
FPENR3_FP29EN:      equ    5                                         ; Frontplane Output Enable Bit 29
FPENR3_FP30EN:      equ    6                                         ; Frontplane Output Enable Bit 30
FPENR3_FP31EN:      equ    7                                         ; Frontplane Output Enable Bit 31
; bit position masks
mFPENR3_FP24EN:     equ    %00000001
mFPENR3_FP25EN:     equ    %00000010
mFPENR3_FP26EN:     equ    %00000100
mFPENR3_FP27EN:     equ    %00001000
mFPENR3_FP28EN:     equ    %00010000
mFPENR3_FP29EN:     equ    %00100000
mFPENR3_FP30EN:     equ    %01000000
mFPENR3_FP31EN:     equ    %10000000


;*** LCDRAM0 - LCD RAM Register 0; 0x00000128 ***
LCDRAM0:            equ    $00000128                                ;*** LCDRAM0 - LCD RAM Register 0; 0x00000128 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
LCDRAM0_FP0BP0:     equ    0                                         ; LCD Segment FP0, BP0 ON
LCDRAM0_FP0BP1:     equ    1                                         ; LCD Segment FP0, BP1 ON
LCDRAM0_FP0BP2:     equ    2                                         ; LCD Segment FP0, BP2 ON
LCDRAM0_FP0BP3:     equ    3                                         ; LCD Segment FP0, BP3 ON
LCDRAM0_FP1BP0:     equ    4                                         ; LCD Segment FP1, BP0 ON
LCDRAM0_FP1BP1:     equ    5                                         ; LCD Segment FP1, BP1 ON
LCDRAM0_FP1BP2:     equ    6                                         ; LCD Segment FP1, BP2 ON
LCDRAM0_FP1BP3:     equ    7                                         ; LCD Segment FP1, BP3 ON
; bit position masks
mLCDRAM0_FP0BP0:    equ    %00000001
mLCDRAM0_FP0BP1:    equ    %00000010
mLCDRAM0_FP0BP2:    equ    %00000100
mLCDRAM0_FP0BP3:    equ    %00001000
mLCDRAM0_FP1BP0:    equ    %00010000
mLCDRAM0_FP1BP1:    equ    %00100000
mLCDRAM0_FP1BP2:    equ    %01000000
mLCDRAM0_FP1BP3:    equ    %10000000


;*** LCDRAM1 - LCD RAM Register 1; 0x00000129 ***
LCDRAM1:            equ    $00000129                                ;*** LCDRAM1 - LCD RAM Register 1; 0x00000129 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
LCDRAM1_FP2BP0:     equ    0                                         ; LCD Segment FP2, BP0 ON
LCDRAM1_FP2BP1:     equ    1                                         ; LCD Segment FP2, BP1 ON
LCDRAM1_FP2BP2:     equ    2                                         ; LCD Segment FP2, BP2 ON
LCDRAM1_FP2BP3:     equ    3                                         ; LCD Segment FP2, BP3 ON
LCDRAM1_FP3BP0:     equ    4                                         ; LCD Segment FP3, BP0 ON
LCDRAM1_FP3BP1:     equ    5                                         ; LCD Segment FP3, BP1 ON
LCDRAM1_FP3BP2:     equ    6                                         ; LCD Segment FP3, BP2 ON
LCDRAM1_FP3BP3:     equ    7                                         ; LCD Segment FP3, BP3 ON
; bit position masks
mLCDRAM1_FP2BP0:    equ    %00000001
mLCDRAM1_FP2BP1:    equ    %00000010
mLCDRAM1_FP2BP2:    equ    %00000100
mLCDRAM1_FP2BP3:    equ    %00001000
mLCDRAM1_FP3BP0:    equ    %00010000
mLCDRAM1_FP3BP1:    equ    %00100000
mLCDRAM1_FP3BP2:    equ    %01000000
mLCDRAM1_FP3BP3:    equ    %10000000


;*** LCDRAM2 - LCD RAM Register 2; 0x0000012A ***
LCDRAM2:            equ    $0000012A                                ;*** LCDRAM2 - LCD RAM Register 2; 0x0000012A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
LCDRAM2_FP4BP0:     equ    0                                         ; LCD Segment FP4, BP0 ON
LCDRAM2_FP4BP1:     equ    1                                         ; LCD Segment FP4, BP1 ON
LCDRAM2_FP4BP2:     equ    2                                         ; LCD Segment FP4, BP2 ON
LCDRAM2_FP4BP3:     equ    3                                         ; LCD Segment FP4, BP3 ON
LCDRAM2_FP5BP0:     equ    4                                         ; LCD Segment FP5, BP0 ON
LCDRAM2_FP5BP1:     equ    5                                         ; LCD Segment FP5, BP1 ON
LCDRAM2_FP5BP2:     equ    6                                         ; LCD Segment FP5, BP2 ON
LCDRAM2_FP5BP3:     equ    7                                         ; LCD Segment FP5, BP3 ON
; bit position masks
mLCDRAM2_FP4BP0:    equ    %00000001
mLCDRAM2_FP4BP1:    equ    %00000010
mLCDRAM2_FP4BP2:    equ    %00000100
mLCDRAM2_FP4BP3:    equ    %00001000
mLCDRAM2_FP5BP0:    equ    %00010000
mLCDRAM2_FP5BP1:    equ    %00100000
mLCDRAM2_FP5BP2:    equ    %01000000
mLCDRAM2_FP5BP3:    equ    %10000000


;*** LCDRAM3 - LCD RAM Register 3; 0x0000012B ***
LCDRAM3:            equ    $0000012B                                ;*** LCDRAM3 - LCD RAM Register 3; 0x0000012B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
LCDRAM3_FP6BP0:     equ    0                                         ; LCD Segment FP6, BP0 ON
LCDRAM3_FP6BP1:     equ    1                                         ; LCD Segment FP6, BP1 ON
LCDRAM3_FP6BP2:     equ    2                                         ; LCD Segment FP6, BP2 ON
LCDRAM3_FP6BP3:     equ    3                                         ; LCD Segment FP6, BP3 ON
LCDRAM3_FP7BP0:     equ    4                                         ; LCD Segment FP7, BP0 ON
LCDRAM3_FP7BP1:     equ    5                                         ; LCD Segment FP7, BP1 ON
LCDRAM3_FP7BP2:     equ    6                                         ; LCD Segment FP7, BP2 ON
LCDRAM3_FP7BP3:     equ    7                                         ; LCD Segment FP7, BP3 ON
; bit position masks
mLCDRAM3_FP6BP0:    equ    %00000001
mLCDRAM3_FP6BP1:    equ    %00000010
mLCDRAM3_FP6BP2:    equ    %00000100
mLCDRAM3_FP6BP3:    equ    %00001000
mLCDRAM3_FP7BP0:    equ    %00010000
mLCDRAM3_FP7BP1:    equ    %00100000
mLCDRAM3_FP7BP2:    equ    %01000000
mLCDRAM3_FP7BP3:    equ    %10000000


;*** LCDRAM4 - LCD RAM Register 4; 0x0000012C ***
LCDRAM4:            equ    $0000012C                                ;*** LCDRAM4 - LCD RAM Register 4; 0x0000012C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
LCDRAM4_FP8BP0:     equ    0                                         ; LCD Segment FP8, BP0 ON
LCDRAM4_FP8BP1:     equ    1                                         ; LCD Segment FP8, BP1 ON
LCDRAM4_FP8BP2:     equ    2                                         ; LCD Segment FP8, BP2 ON
LCDRAM4_FP8BP3:     equ    3                                         ; LCD Segment FP8, BP3 ON
LCDRAM4_FP9BP0:     equ    4                                         ; LCD Segment FP9, BP0 ON
LCDRAM4_FP9BP1:     equ    5                                         ; LCD Segment FP9, BP1 ON
LCDRAM4_FP9BP2:     equ    6                                         ; LCD Segment FP9, BP2 ON
LCDRAM4_FP9BP3:     equ    7                                         ; LCD Segment FP9, BP3 ON
; bit position masks
mLCDRAM4_FP8BP0:    equ    %00000001
mLCDRAM4_FP8BP1:    equ    %00000010
mLCDRAM4_FP8BP2:    equ    %00000100
mLCDRAM4_FP8BP3:    equ    %00001000
mLCDRAM4_FP9BP0:    equ    %00010000
mLCDRAM4_FP9BP1:    equ    %00100000
mLCDRAM4_FP9BP2:    equ    %01000000
mLCDRAM4_FP9BP3:    equ    %10000000


;*** LCDRAM5 - LCD RAM Register 5; 0x0000012D ***
LCDRAM5:            equ    $0000012D                                ;*** LCDRAM5 - LCD RAM Register 5; 0x0000012D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
LCDRAM5_FP10BP0:    equ    0                                         ; LCD Segment FP10, BP0 ON
LCDRAM5_FP10BP1:    equ    1                                         ; LCD Segment FP10, BP1 ON
LCDRAM5_FP10BP2:    equ    2                                         ; LCD Segment FP10, BP2 ON
LCDRAM5_FP10BP3:    equ    3                                         ; LCD Segment FP10, BP3 ON
LCDRAM5_FP11BP0:    equ    4                                         ; LCD Segment FP11, BP0 ON
LCDRAM5_FP11BP1:    equ    5                                         ; LCD Segment FP11, BP1 ON
LCDRAM5_FP11BP2:    equ    6                                         ; LCD Segment FP11, BP2 ON
LCDRAM5_FP11BP3:    equ    7                                         ; LCD Segment FP11, BP3 ON
; bit position masks
mLCDRAM5_FP10BP0:   equ    %00000001
mLCDRAM5_FP10BP1:   equ    %00000010
mLCDRAM5_FP10BP2:   equ    %00000100
mLCDRAM5_FP10BP3:   equ    %00001000
mLCDRAM5_FP11BP0:   equ    %00010000
mLCDRAM5_FP11BP1:   equ    %00100000
mLCDRAM5_FP11BP2:   equ    %01000000
mLCDRAM5_FP11BP3:   equ    %10000000


;*** LCDRAM6 - LCD RAM Register 6; 0x0000012E ***
LCDRAM6:            equ    $0000012E                                ;*** LCDRAM6 - LCD RAM Register 6; 0x0000012E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
LCDRAM6_FP12BP0:    equ    0                                         ; LCD Segment FP12, BP0 ON
LCDRAM6_FP12BP1:    equ    1                                         ; LCD Segment FP12, BP1 ON
LCDRAM6_FP12BP2:    equ    2                                         ; LCD Segment FP12, BP2 ON
LCDRAM6_FP12BP3:    equ    3                                         ; LCD Segment FP12, BP3 ON
LCDRAM6_FP13BP0:    equ    4                                         ; LCD Segment FP13, BP0 ON
LCDRAM6_FP13BP1:    equ    5                                         ; LCD Segment FP13, BP1 ON
LCDRAM6_FP13BP2:    equ    6                                         ; LCD Segment FP13, BP2 ON
LCDRAM6_FP13BP3:    equ    7                                         ; LCD Segment FP13, BP3 ON
; bit position masks
mLCDRAM6_FP12BP0:   equ    %00000001
mLCDRAM6_FP12BP1:   equ    %00000010
mLCDRAM6_FP12BP2:   equ    %00000100
mLCDRAM6_FP12BP3:   equ    %00001000
mLCDRAM6_FP13BP0:   equ    %00010000
mLCDRAM6_FP13BP1:   equ    %00100000
mLCDRAM6_FP13BP2:   equ    %01000000
mLCDRAM6_FP13BP3:   equ    %10000000


;*** LCDRAM7 - LCD RAM Register 7; 0x0000012F ***
LCDRAM7:            equ    $0000012F                                ;*** LCDRAM7 - LCD RAM Register 7; 0x0000012F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
LCDRAM7_FP14BP0:    equ    0                                         ; LCD Segment FP14, BP0 ON
LCDRAM7_FP14BP1:    equ    1                                         ; LCD Segment FP14, BP1 ON
LCDRAM7_FP14BP2:    equ    2                                         ; LCD Segment FP14, BP2 ON
LCDRAM7_FP14BP3:    equ    3                                         ; LCD Segment FP14, BP3 ON
LCDRAM7_FP15BP0:    equ    4                                         ; LCD Segment FP15, BP0 ON
LCDRAM7_FP15BP1:    equ    5                                         ; LCD Segment FP15, BP1 ON
LCDRAM7_FP15BP2:    equ    6                                         ; LCD Segment FP15, BP2 ON
LCDRAM7_FP15BP3:    equ    7                                         ; LCD Segment FP15, BP3 ON
; bit position masks
mLCDRAM7_FP14BP0:   equ    %00000001
mLCDRAM7_FP14BP1:   equ    %00000010
mLCDRAM7_FP14BP2:   equ    %00000100
mLCDRAM7_FP14BP3:   equ    %00001000
mLCDRAM7_FP15BP0:   equ    %00010000
mLCDRAM7_FP15BP1:   equ    %00100000
mLCDRAM7_FP15BP2:   equ    %01000000
mLCDRAM7_FP15BP3:   equ    %10000000


;*** LCDRAM8 - LCD RAM Register 8; 0x00000130 ***
LCDRAM8:            equ    $00000130                                ;*** LCDRAM8 - LCD RAM Register 8; 0x00000130 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
LCDRAM8_FP16BP0:    equ    0                                         ; LCD Segment FP16, BP0 ON
LCDRAM8_FP16BP1:    equ    1                                         ; LCD Segment FP16, BP1 ON
LCDRAM8_FP16BP2:    equ    2                                         ; LCD Segment FP16, BP2 ON
LCDRAM8_FP16BP3:    equ    3                                         ; LCD Segment FP16, BP3 ON
LCDRAM8_FP17BP0:    equ    4                                         ; LCD Segment FP17, BP0 ON
LCDRAM8_FP17BP1:    equ    5                                         ; LCD Segment FP17, BP1 ON
LCDRAM8_FP17BP2:    equ    6                                         ; LCD Segment FP17, BP2 ON
LCDRAM8_FP17BP3:    equ    7                                         ; LCD Segment FP17, BP3 ON
; bit position masks
mLCDRAM8_FP16BP0:   equ    %00000001
mLCDRAM8_FP16BP1:   equ    %00000010
mLCDRAM8_FP16BP2:   equ    %00000100
mLCDRAM8_FP16BP3:   equ    %00001000
mLCDRAM8_FP17BP0:   equ    %00010000
mLCDRAM8_FP17BP1:   equ    %00100000
mLCDRAM8_FP17BP2:   equ    %01000000
mLCDRAM8_FP17BP3:   equ    %10000000


;*** LCDRAM9 - LCD RAM Register 9; 0x00000131 ***
LCDRAM9:            equ    $00000131                                ;*** LCDRAM9 - LCD RAM Register 9; 0x00000131 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
LCDRAM9_FP18BP0:    equ    0                                         ; LCD Segment FP18, BP0 ON
LCDRAM9_FP18BP1:    equ    1                                         ; LCD Segment FP18, BP1 ON
LCDRAM9_FP18BP2:    equ    2                                         ; LCD Segment FP18, BP2 ON
LCDRAM9_FP18BP3:    equ    3                                         ; LCD Segment FP18, BP3 ON
LCDRAM9_FP19BP0:    equ    4                                         ; LCD Segment FP19, BP0 ON
LCDRAM9_FP19BP1:    equ    5                                         ; LCD Segment FP19, BP1 ON
LCDRAM9_FP19BP2:    equ    6                                         ; LCD Segment FP19, BP2 ON
LCDRAM9_FP19BP3:    equ    7                                         ; LCD Segment FP19, BP3 ON
; bit position masks
mLCDRAM9_FP18BP0:   equ    %00000001
mLCDRAM9_FP18BP1:   equ    %00000010
mLCDRAM9_FP18BP2:   equ    %00000100
mLCDRAM9_FP18BP3:   equ    %00001000
mLCDRAM9_FP19BP0:   equ    %00010000
mLCDRAM9_FP19BP1:   equ    %00100000
mLCDRAM9_FP19BP2:   equ    %01000000
mLCDRAM9_FP19BP3:   equ    %10000000


;*** LCDRAM10 - LCD RAM Register 10; 0x00000132 ***
LCDRAM10:           equ    $00000132                                ;*** LCDRAM10 - LCD RAM Register 10; 0x00000132 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
LCDRAM10_FP20BP0:   equ    0                                         ; LCD Segment FP20, BP0 ON
LCDRAM10_FP20BP1:   equ    1                                         ; LCD Segment FP20, BP1 ON
LCDRAM10_FP20BP2:   equ    2                                         ; LCD Segment FP20, BP2 ON
LCDRAM10_FP20BP3:   equ    3                                         ; LCD Segment FP20, BP3 ON
LCDRAM10_FP21BP0:   equ    4                                         ; LCD Segment FP21, BP0 ON
LCDRAM10_FP21BP1:   equ    5                                         ; LCD Segment FP21, BP1 ON
LCDRAM10_FP21BP2:   equ    6                                         ; LCD Segment FP21, BP2 ON
LCDRAM10_FP21BP3:   equ    7                                         ; LCD Segment FP21, BP3 ON
; bit position masks
mLCDRAM10_FP20BP0:  equ    %00000001
mLCDRAM10_FP20BP1:  equ    %00000010
mLCDRAM10_FP20BP2:  equ    %00000100
mLCDRAM10_FP20BP3:  equ    %00001000
mLCDRAM10_FP21BP0:  equ    %00010000
mLCDRAM10_FP21BP1:  equ    %00100000
mLCDRAM10_FP21BP2:  equ    %01000000
mLCDRAM10_FP21BP3:  equ    %10000000


;*** LCDRAM11 - LCD RAM Register 11; 0x00000133 ***
LCDRAM11:           equ    $00000133                                ;*** LCDRAM11 - LCD RAM Register 11; 0x00000133 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
LCDRAM11_FP22BP0:   equ    0                                         ; LCD Segment FP22, BP0 ON
LCDRAM11_FP22BP1:   equ    1                                         ; LCD Segment FP22, BP1 ON
LCDRAM11_FP22BP2:   equ    2                                         ; LCD Segment FP22, BP2 ON
LCDRAM11_FP22BP3:   equ    3                                         ; LCD Segment FP22, BP3 ON
LCDRAM11_FP23BP0:   equ    4                                         ; LCD Segment FP23, BP0 ON
LCDRAM11_FP23BP1:   equ    5                                         ; LCD Segment FP23, BP1 ON
LCDRAM11_FP23BP2:   equ    6                                         ; LCD Segment FP23, BP2 ON
LCDRAM11_FP23BP3:   equ    7                                         ; LCD Segment FP23, BP3 ON
; bit position masks
mLCDRAM11_FP22BP0:  equ    %00000001
mLCDRAM11_FP22BP1:  equ    %00000010
mLCDRAM11_FP22BP2:  equ    %00000100
mLCDRAM11_FP22BP3:  equ    %00001000
mLCDRAM11_FP23BP0:  equ    %00010000
mLCDRAM11_FP23BP1:  equ    %00100000
mLCDRAM11_FP23BP2:  equ    %01000000
mLCDRAM11_FP23BP3:  equ    %10000000


;*** LCDRAM12 - LCD RAM Register 12; 0x00000134 ***
LCDRAM12:           equ    $00000134                                ;*** LCDRAM12 - LCD RAM Register 12; 0x00000134 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
LCDRAM12_FP24BP0:   equ    0                                         ; LCD Segment FP24, BP0 ON
LCDRAM12_FP24BP1:   equ    1                                         ; LCD Segment FP24, BP1 ON
LCDRAM12_FP24BP2:   equ    2                                         ; LCD Segment FP24, BP2 ON
LCDRAM12_FP24BP3:   equ    3                                         ; LCD Segment FP24, BP3 ON
LCDRAM12_FP25BP0:   equ    4                                         ; LCD Segment FP25, BP0 ON
LCDRAM12_FP25BP1:   equ    5                                         ; LCD Segment FP25, BP1 ON
LCDRAM12_FP25BP2:   equ    6                                         ; LCD Segment FP25, BP2 ON
LCDRAM12_FP25BP3:   equ    7                                         ; LCD Segment FP25, BP3 ON
; bit position masks
mLCDRAM12_FP24BP0:  equ    %00000001
mLCDRAM12_FP24BP1:  equ    %00000010
mLCDRAM12_FP24BP2:  equ    %00000100
mLCDRAM12_FP24BP3:  equ    %00001000
mLCDRAM12_FP25BP0:  equ    %00010000
mLCDRAM12_FP25BP1:  equ    %00100000
mLCDRAM12_FP25BP2:  equ    %01000000
mLCDRAM12_FP25BP3:  equ    %10000000


;*** LCDRAM13 - LCD RAM Register 13; 0x00000135 ***
LCDRAM13:           equ    $00000135                                ;*** LCDRAM13 - LCD RAM Register 13; 0x00000135 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
LCDRAM13_FP26BP0:   equ    0                                         ; LCD Segment FP26, BP0 ON
LCDRAM13_FP26BP1:   equ    1                                         ; LCD Segment FP26, BP1 ON
LCDRAM13_FP26BP2:   equ    2                                         ; LCD Segment FP26, BP2 ON
LCDRAM13_FP26BP3:   equ    3                                         ; LCD Segment FP26, BP3 ON
LCDRAM13_FP27BP0:   equ    4                                         ; LCD Segment FP27, BP0 ON
LCDRAM13_FP27BP1:   equ    5                                         ; LCD Segment FP27, BP1 ON
LCDRAM13_FP27BP2:   equ    6                                         ; LCD Segment FP27, BP2 ON
LCDRAM13_FP27BP3:   equ    7                                         ; LCD Segment FP27, BP3 ON
; bit position masks
mLCDRAM13_FP26BP0:  equ    %00000001
mLCDRAM13_FP26BP1:  equ    %00000010
mLCDRAM13_FP26BP2:  equ    %00000100
mLCDRAM13_FP26BP3:  equ    %00001000
mLCDRAM13_FP27BP0:  equ    %00010000
mLCDRAM13_FP27BP1:  equ    %00100000
mLCDRAM13_FP27BP2:  equ    %01000000
mLCDRAM13_FP27BP3:  equ    %10000000


;*** LCDRAM14 - LCD RAM Register 14; 0x00000136 ***
LCDRAM14:           equ    $00000136                                ;*** LCDRAM14 - LCD RAM Register 14; 0x00000136 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
LCDRAM14_FP28BP0:   equ    0                                         ; LCD Segment FP28, BP0 ON
LCDRAM14_FP28BP1:   equ    1                                         ; LCD Segment FP28, BP1 ON
LCDRAM14_FP28BP2:   equ    2                                         ; LCD Segment FP28, BP2 ON
LCDRAM14_FP28BP3:   equ    3                                         ; LCD Segment FP28, BP3 ON
LCDRAM14_FP29BP0:   equ    4                                         ; LCD Segment FP29, BP0 ON
LCDRAM14_FP29BP1:   equ    5                                         ; LCD Segment FP29, BP1 ON
LCDRAM14_FP29BP2:   equ    6                                         ; LCD Segment FP29, BP2 ON
LCDRAM14_FP29BP3:   equ    7                                         ; LCD Segment FP29, BP3 ON
; bit position masks
mLCDRAM14_FP28BP0:  equ    %00000001
mLCDRAM14_FP28BP1:  equ    %00000010
mLCDRAM14_FP28BP2:  equ    %00000100
mLCDRAM14_FP28BP3:  equ    %00001000
mLCDRAM14_FP29BP0:  equ    %00010000
mLCDRAM14_FP29BP1:  equ    %00100000
mLCDRAM14_FP29BP2:  equ    %01000000
mLCDRAM14_FP29BP3:  equ    %10000000


;*** LCDRAM15 - LCD RAM Register 15; 0x00000137 ***
LCDRAM15:           equ    $00000137                                ;*** LCDRAM15 - LCD RAM Register 15; 0x00000137 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
LCDRAM15_FP30BP0:   equ    0                                         ; LCD Segment FP30, BP0 ON
LCDRAM15_FP30BP1:   equ    1                                         ; LCD Segment FP30, BP1 ON
LCDRAM15_FP30BP2:   equ    2                                         ; LCD Segment FP30, BP2 ON
LCDRAM15_FP30BP3:   equ    3                                         ; LCD Segment FP30, BP3 ON
LCDRAM15_FP31BP0:   equ    4                                         ; LCD Segment FP31, BP0 ON
LCDRAM15_FP31BP1:   equ    5                                         ; LCD Segment FP31, BP1 ON
LCDRAM15_FP31BP2:   equ    6                                         ; LCD Segment FP31, BP2 ON
LCDRAM15_FP31BP3:   equ    7                                         ; LCD Segment FP31, BP3 ON
; bit position masks
mLCDRAM15_FP30BP0:  equ    %00000001
mLCDRAM15_FP30BP1:  equ    %00000010
mLCDRAM15_FP30BP2:  equ    %00000100
mLCDRAM15_FP30BP3:  equ    %00001000
mLCDRAM15_FP31BP0:  equ    %00010000
mLCDRAM15_FP31BP1:  equ    %00100000
mLCDRAM15_FP31BP2:  equ    %01000000
mLCDRAM15_FP31BP3:  equ    %10000000


;*** CAN0CTL0 - MSCAN 0 Control 0 Register; 0x00000140 ***
CAN0CTL0:           equ    $00000140                                ;*** CAN0CTL0 - MSCAN 0 Control 0 Register; 0x00000140 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0CTL0_INITRQ:    equ    0                                         ; Initialization Mode Request
CAN0CTL0_SLPRQ:     equ    1                                         ; Sleep Mode Request
CAN0CTL0_WUPE:      equ    2                                         ; Wake-Up Enable
CAN0CTL0_TIME:      equ    3                                         ; Timer Enable
CAN0CTL0_SYNCH:     equ    4                                         ; Synchronized Status
CAN0CTL0_CSWAI:     equ    5                                         ; CAN Stops in Wait Mode
CAN0CTL0_RXACT:     equ    6                                         ; Receiver Active Status
CAN0CTL0_RXFRM:     equ    7                                         ; Received Frame Flag
; bit position masks
mCAN0CTL0_INITRQ:   equ    %00000001
mCAN0CTL0_SLPRQ:    equ    %00000010
mCAN0CTL0_WUPE:     equ    %00000100
mCAN0CTL0_TIME:     equ    %00001000
mCAN0CTL0_SYNCH:    equ    %00010000
mCAN0CTL0_CSWAI:    equ    %00100000
mCAN0CTL0_RXACT:    equ    %01000000
mCAN0CTL0_RXFRM:    equ    %10000000


;*** CAN0CTL1 - MSCAN 0 Control 1 Register; 0x00000141 ***
CAN0CTL1:           equ    $00000141                                ;*** CAN0CTL1 - MSCAN 0 Control 1 Register; 0x00000141 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0CTL1_INITAK:    equ    0                                         ; Initialization Mode Acknowledge
CAN0CTL1_SLPAK:     equ    1                                         ; Sleep Mode Acknowledge
CAN0CTL1_WUPM:      equ    2                                         ; Wake-Up Mode
CAN0CTL1_LISTEN:    equ    4                                         ; Listen Only Mode
CAN0CTL1_LOOPB:     equ    5                                         ; Loop Back Self Test Mode
CAN0CTL1_CLKSRC:    equ    6                                         ; MSCAN 0 Clock Source
CAN0CTL1_CANE:      equ    7                                         ; MSCAN 0 Enable
; bit position masks
mCAN0CTL1_INITAK:   equ    %00000001
mCAN0CTL1_SLPAK:    equ    %00000010
mCAN0CTL1_WUPM:     equ    %00000100
mCAN0CTL1_LISTEN:   equ    %00010000
mCAN0CTL1_LOOPB:    equ    %00100000
mCAN0CTL1_CLKSRC:   equ    %01000000
mCAN0CTL1_CANE:     equ    %10000000


;*** CAN0BTR0 - MSCAN 0 Bus Timing Register 0; 0x00000142 ***
CAN0BTR0:           equ    $00000142                                ;*** CAN0BTR0 - MSCAN 0 Bus Timing Register 0; 0x00000142 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0BTR0_BRP0:      equ    0                                         ; Baud Rate Prescaler 0
CAN0BTR0_BRP1:      equ    1                                         ; Baud Rate Prescaler 1
CAN0BTR0_BRP2:      equ    2                                         ; Baud Rate Prescaler 2
CAN0BTR0_BRP3:      equ    3                                         ; Baud Rate Prescaler 3
CAN0BTR0_BRP4:      equ    4                                         ; Baud Rate Prescaler 4
CAN0BTR0_BRP5:      equ    5                                         ; Baud Rate Prescaler 5
CAN0BTR0_SJW0:      equ    6                                         ; Synchronization Jump Width 0
CAN0BTR0_SJW1:      equ    7                                         ; Synchronization Jump Width 1
; bit position masks
mCAN0BTR0_BRP0:     equ    %00000001
mCAN0BTR0_BRP1:     equ    %00000010
mCAN0BTR0_BRP2:     equ    %00000100
mCAN0BTR0_BRP3:     equ    %00001000
mCAN0BTR0_BRP4:     equ    %00010000
mCAN0BTR0_BRP5:     equ    %00100000
mCAN0BTR0_SJW0:     equ    %01000000
mCAN0BTR0_SJW1:     equ    %10000000


;*** CAN0BTR1 - MSCAN 0 Bus Timing Register 1; 0x00000143 ***
CAN0BTR1:           equ    $00000143                                ;*** CAN0BTR1 - MSCAN 0 Bus Timing Register 1; 0x00000143 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0BTR1_TSEG10:    equ    0                                         ; Time Segment 10
CAN0BTR1_TSEG11:    equ    1                                         ; Time Segment 11
CAN0BTR1_TSEG12:    equ    2                                         ; Time Segment 12
CAN0BTR1_TSEG13:    equ    3                                         ; Time Segment 13
CAN0BTR1_TSEG20:    equ    4                                         ; Time Segment 20
CAN0BTR1_TSEG21:    equ    5                                         ; Time Segment 21
CAN0BTR1_TSEG22:    equ    6                                         ; Time Segment 22
CAN0BTR1_SAMP:      equ    7                                         ; Sampling
; bit position masks
mCAN0BTR1_TSEG10:   equ    %00000001
mCAN0BTR1_TSEG11:   equ    %00000010
mCAN0BTR1_TSEG12:   equ    %00000100
mCAN0BTR1_TSEG13:   equ    %00001000
mCAN0BTR1_TSEG20:   equ    %00010000
mCAN0BTR1_TSEG21:   equ    %00100000
mCAN0BTR1_TSEG22:   equ    %01000000
mCAN0BTR1_SAMP:     equ    %10000000


;*** CAN0RFLG - MSCAN 0 Receiver Flag Register; 0x00000144 ***
CAN0RFLG:           equ    $00000144                                ;*** CAN0RFLG - MSCAN 0 Receiver Flag Register; 0x00000144 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0RFLG_RXF:       equ    0                                         ; Receive Buffer Full
CAN0RFLG_OVRIF:     equ    1                                         ; Overrun Interrupt Flag
CAN0RFLG_TSTAT0:    equ    2                                         ; Transmitter Status Bit 0
CAN0RFLG_TSTAT1:    equ    3                                         ; Transmitter Status Bit 1
CAN0RFLG_RSTAT0:    equ    4                                         ; Receiver Status Bit 0
CAN0RFLG_RSTAT1:    equ    5                                         ; Receiver Status Bit 1
CAN0RFLG_CSCIF:     equ    6                                         ; CAN Status Change Interrupt Flag
CAN0RFLG_WUPIF:     equ    7                                         ; Wake-up Interrupt Flag
; bit position masks
mCAN0RFLG_RXF:      equ    %00000001
mCAN0RFLG_OVRIF:    equ    %00000010
mCAN0RFLG_TSTAT0:   equ    %00000100
mCAN0RFLG_TSTAT1:   equ    %00001000
mCAN0RFLG_RSTAT0:   equ    %00010000
mCAN0RFLG_RSTAT1:   equ    %00100000
mCAN0RFLG_CSCIF:    equ    %01000000
mCAN0RFLG_WUPIF:    equ    %10000000


;*** CAN0RIER - MSCAN 0 Receiver Interrupt Enable Register; 0x00000145 ***
CAN0RIER:           equ    $00000145                                ;*** CAN0RIER - MSCAN 0 Receiver Interrupt Enable Register; 0x00000145 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0RIER_RXFIE:     equ    0                                         ; Receiver Full Interrupt Enable
CAN0RIER_OVRIE:     equ    1                                         ; Overrun Interrupt Enable
CAN0RIER_TSTATE0:   equ    2                                         ; Transmitter Status Change Enable 0
CAN0RIER_TSTATE1:   equ    3                                         ; Transmitter Status Change Enable 1
CAN0RIER_RSTATE0:   equ    4                                         ; Receiver Status Change Enable 0
CAN0RIER_RSTATE1:   equ    5                                         ; Receiver Status Change Enable 1
CAN0RIER_CSCIE:     equ    6                                         ; CAN Status Change Interrupt Enable
CAN0RIER_WUPIE:     equ    7                                         ; Wake-up Interrupt Enable
; bit position masks
mCAN0RIER_RXFIE:    equ    %00000001
mCAN0RIER_OVRIE:    equ    %00000010
mCAN0RIER_TSTATE0:  equ    %00000100
mCAN0RIER_TSTATE1:  equ    %00001000
mCAN0RIER_RSTATE0:  equ    %00010000
mCAN0RIER_RSTATE1:  equ    %00100000
mCAN0RIER_CSCIE:    equ    %01000000
mCAN0RIER_WUPIE:    equ    %10000000


;*** CAN0TFLG - MSCAN 0 Transmitter Flag Register; 0x00000146 ***
CAN0TFLG:           equ    $00000146                                ;*** CAN0TFLG - MSCAN 0 Transmitter Flag Register; 0x00000146 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0TFLG_TXE0:      equ    0                                         ; Transmitter Buffer Empty 0
CAN0TFLG_TXE1:      equ    1                                         ; Transmitter Buffer Empty 1
CAN0TFLG_TXE2:      equ    2                                         ; Transmitter Buffer Empty 2
; bit position masks
mCAN0TFLG_TXE0:     equ    %00000001
mCAN0TFLG_TXE1:     equ    %00000010
mCAN0TFLG_TXE2:     equ    %00000100


;*** CAN0TIER - MSCAN 0 Transmitter Interrupt Enable Register; 0x00000147 ***
CAN0TIER:           equ    $00000147                                ;*** CAN0TIER - MSCAN 0 Transmitter Interrupt Enable Register; 0x00000147 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0TIER_TXEIE0:    equ    0                                         ; Transmitter Empty Interrupt Enable 0
CAN0TIER_TXEIE1:    equ    1                                         ; Transmitter Empty Interrupt Enable 1
CAN0TIER_TXEIE2:    equ    2                                         ; Transmitter Empty Interrupt Enable 2
; bit position masks
mCAN0TIER_TXEIE0:   equ    %00000001
mCAN0TIER_TXEIE1:   equ    %00000010
mCAN0TIER_TXEIE2:   equ    %00000100


;*** CAN0TARQ - MSCAN 0 Transmitter Message Abort Request; 0x00000148 ***
CAN0TARQ:           equ    $00000148                                ;*** CAN0TARQ - MSCAN 0 Transmitter Message Abort Request; 0x00000148 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0TARQ_ABTRQ0:    equ    0                                         ; Abort Request 0
CAN0TARQ_ABTRQ1:    equ    1                                         ; Abort Request 1
CAN0TARQ_ABTRQ2:    equ    2                                         ; Abort Request 2
; bit position masks
mCAN0TARQ_ABTRQ0:   equ    %00000001
mCAN0TARQ_ABTRQ1:   equ    %00000010
mCAN0TARQ_ABTRQ2:   equ    %00000100


;*** CAN0TAAK - MSCAN 0 Transmitter Message Abort Control; 0x00000149 ***
CAN0TAAK:           equ    $00000149                                ;*** CAN0TAAK - MSCAN 0 Transmitter Message Abort Control; 0x00000149 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0TAAK_ABTAK0:    equ    0                                         ; Abort Acknowledge 0
CAN0TAAK_ABTAK1:    equ    1                                         ; Abort Acknowledge 1
CAN0TAAK_ABTAK2:    equ    2                                         ; Abort Acknowledge 2
; bit position masks
mCAN0TAAK_ABTAK0:   equ    %00000001
mCAN0TAAK_ABTAK1:   equ    %00000010
mCAN0TAAK_ABTAK2:   equ    %00000100


;*** CAN0TBSEL - MSCAN 0 Transmit Buffer Selection; 0x0000014A ***
CAN0TBSEL:          equ    $0000014A                                ;*** CAN0TBSEL - MSCAN 0 Transmit Buffer Selection; 0x0000014A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0TBSEL_TX0:      equ    0                                         ; Transmit Buffer Select 0
CAN0TBSEL_TX1:      equ    1                                         ; Transmit Buffer Select 1
CAN0TBSEL_TX2:      equ    2                                         ; Transmit Buffer Select 2
; bit position masks
mCAN0TBSEL_TX0:     equ    %00000001
mCAN0TBSEL_TX1:     equ    %00000010
mCAN0TBSEL_TX2:     equ    %00000100


;*** CAN0IDAC - MSCAN 0 Identifier Acceptance Control Register; 0x0000014B ***
CAN0IDAC:           equ    $0000014B                                ;*** CAN0IDAC - MSCAN 0 Identifier Acceptance Control Register; 0x0000014B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0IDAC_IDHIT0:    equ    0                                         ; Identifier Acceptance Hit Indicator 0
CAN0IDAC_IDHIT1:    equ    1                                         ; Identifier Acceptance Hit Indicator 1
CAN0IDAC_IDHIT2:    equ    2                                         ; Identifier Acceptance Hit Indicator 2
CAN0IDAC_IDAM0:     equ    4                                         ; Identifier Acceptance Mode 0
CAN0IDAC_IDAM1:     equ    5                                         ; Identifier Acceptance Mode 1
; bit position masks
mCAN0IDAC_IDHIT0:   equ    %00000001
mCAN0IDAC_IDHIT1:   equ    %00000010
mCAN0IDAC_IDHIT2:   equ    %00000100
mCAN0IDAC_IDAM0:    equ    %00010000
mCAN0IDAC_IDAM1:    equ    %00100000


;*** CAN0RXERR - MSCAN 0 Receive Error Counter Register; 0x0000014E ***
CAN0RXERR:          equ    $0000014E                                ;*** CAN0RXERR - MSCAN 0 Receive Error Counter Register; 0x0000014E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0RXERR_RXERR0:   equ    0                                         ; Bit 0
CAN0RXERR_RXERR1:   equ    1                                         ; Bit 1
CAN0RXERR_RXERR2:   equ    2                                         ; Bit 2
CAN0RXERR_RXERR3:   equ    3                                         ; Bit 3
CAN0RXERR_RXERR4:   equ    4                                         ; Bit 4
CAN0RXERR_RXERR5:   equ    5                                         ; Bit 5
CAN0RXERR_RXERR6:   equ    6                                         ; Bit 6
CAN0RXERR_RXERR7:   equ    7                                         ; Bit 7
; bit position masks
mCAN0RXERR_RXERR0:  equ    %00000001
mCAN0RXERR_RXERR1:  equ    %00000010
mCAN0RXERR_RXERR2:  equ    %00000100
mCAN0RXERR_RXERR3:  equ    %00001000
mCAN0RXERR_RXERR4:  equ    %00010000
mCAN0RXERR_RXERR5:  equ    %00100000
mCAN0RXERR_RXERR6:  equ    %01000000
mCAN0RXERR_RXERR7:  equ    %10000000


;*** CAN0TXERR - MSCAN 0 Transmit Error Counter Register; 0x0000014F ***
CAN0TXERR:          equ    $0000014F                                ;*** CAN0TXERR - MSCAN 0 Transmit Error Counter Register; 0x0000014F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0TXERR_TXERR0:   equ    0                                         ; Bit 0
CAN0TXERR_TXERR1:   equ    1                                         ; Bit 1
CAN0TXERR_TXERR2:   equ    2                                         ; Bit 2
CAN0TXERR_TXERR3:   equ    3                                         ; Bit 3
CAN0TXERR_TXERR4:   equ    4                                         ; Bit 4
CAN0TXERR_TXERR5:   equ    5                                         ; Bit 5
CAN0TXERR_TXERR6:   equ    6                                         ; Bit 6
CAN0TXERR_TXERR7:   equ    7                                         ; Bit 7
; bit position masks
mCAN0TXERR_TXERR0:  equ    %00000001
mCAN0TXERR_TXERR1:  equ    %00000010
mCAN0TXERR_TXERR2:  equ    %00000100
mCAN0TXERR_TXERR3:  equ    %00001000
mCAN0TXERR_TXERR4:  equ    %00010000
mCAN0TXERR_TXERR5:  equ    %00100000
mCAN0TXERR_TXERR6:  equ    %01000000
mCAN0TXERR_TXERR7:  equ    %10000000


;*** CAN0IDAR0 - MSCAN 0 Identifier Acceptance Register 0; 0x00000150 ***
CAN0IDAR0:          equ    $00000150                                ;*** CAN0IDAR0 - MSCAN 0 Identifier Acceptance Register 0; 0x00000150 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0IDAR0_AC0:      equ    0                                         ; Acceptance Code Bit 0
CAN0IDAR0_AC1:      equ    1                                         ; Acceptance Code Bit 1
CAN0IDAR0_AC2:      equ    2                                         ; Acceptance Code Bit 2
CAN0IDAR0_AC3:      equ    3                                         ; Acceptance Code Bit 3
CAN0IDAR0_AC4:      equ    4                                         ; Acceptance Code Bit 4
CAN0IDAR0_AC5:      equ    5                                         ; Acceptance Code Bit 5
CAN0IDAR0_AC6:      equ    6                                         ; Acceptance Code Bit 6
CAN0IDAR0_AC7:      equ    7                                         ; Acceptance Code Bit 7
; bit position masks
mCAN0IDAR0_AC0:     equ    %00000001
mCAN0IDAR0_AC1:     equ    %00000010
mCAN0IDAR0_AC2:     equ    %00000100
mCAN0IDAR0_AC3:     equ    %00001000
mCAN0IDAR0_AC4:     equ    %00010000
mCAN0IDAR0_AC5:     equ    %00100000
mCAN0IDAR0_AC6:     equ    %01000000
mCAN0IDAR0_AC7:     equ    %10000000


;*** CAN0IDAR1 - MSCAN 0 Identifier Acceptance Register 1; 0x00000151 ***
CAN0IDAR1:          equ    $00000151                                ;*** CAN0IDAR1 - MSCAN 0 Identifier Acceptance Register 1; 0x00000151 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0IDAR1_AC0:      equ    0                                         ; Acceptance Code Bit 0
CAN0IDAR1_AC1:      equ    1                                         ; Acceptance Code Bit 1
CAN0IDAR1_AC2:      equ    2                                         ; Acceptance Code Bit 2
CAN0IDAR1_AC3:      equ    3                                         ; Acceptance Code Bit 3
CAN0IDAR1_AC4:      equ    4                                         ; Acceptance Code Bit 4
CAN0IDAR1_AC5:      equ    5                                         ; Acceptance Code Bit 5
CAN0IDAR1_AC6:      equ    6                                         ; Acceptance Code Bit 6
CAN0IDAR1_AC7:      equ    7                                         ; Acceptance Code Bit 7
; bit position masks
mCAN0IDAR1_AC0:     equ    %00000001
mCAN0IDAR1_AC1:     equ    %00000010
mCAN0IDAR1_AC2:     equ    %00000100
mCAN0IDAR1_AC3:     equ    %00001000
mCAN0IDAR1_AC4:     equ    %00010000
mCAN0IDAR1_AC5:     equ    %00100000
mCAN0IDAR1_AC6:     equ    %01000000
mCAN0IDAR1_AC7:     equ    %10000000


;*** CAN0IDAR2 - MSCAN 0 Identifier Acceptance Register 2; 0x00000152 ***
CAN0IDAR2:          equ    $00000152                                ;*** CAN0IDAR2 - MSCAN 0 Identifier Acceptance Register 2; 0x00000152 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0IDAR2_AC0:      equ    0                                         ; Acceptance Code Bit 0
CAN0IDAR2_AC1:      equ    1                                         ; Acceptance Code Bit 1
CAN0IDAR2_AC2:      equ    2                                         ; Acceptance Code Bit 2
CAN0IDAR2_AC3:      equ    3                                         ; Acceptance Code Bit 3
CAN0IDAR2_AC4:      equ    4                                         ; Acceptance Code Bit 4
CAN0IDAR2_AC5:      equ    5                                         ; Acceptance Code Bit 5
CAN0IDAR2_AC6:      equ    6                                         ; Acceptance Code Bit 6
CAN0IDAR2_AC7:      equ    7                                         ; Acceptance Code Bit 7
; bit position masks
mCAN0IDAR2_AC0:     equ    %00000001
mCAN0IDAR2_AC1:     equ    %00000010
mCAN0IDAR2_AC2:     equ    %00000100
mCAN0IDAR2_AC3:     equ    %00001000
mCAN0IDAR2_AC4:     equ    %00010000
mCAN0IDAR2_AC5:     equ    %00100000
mCAN0IDAR2_AC6:     equ    %01000000
mCAN0IDAR2_AC7:     equ    %10000000


;*** CAN0IDAR3 - MSCAN 0 Identifier Acceptance Register 3; 0x00000153 ***
CAN0IDAR3:          equ    $00000153                                ;*** CAN0IDAR3 - MSCAN 0 Identifier Acceptance Register 3; 0x00000153 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0IDAR3_AC0:      equ    0                                         ; Acceptance Code Bit 0
CAN0IDAR3_AC1:      equ    1                                         ; Acceptance Code Bit 1
CAN0IDAR3_AC2:      equ    2                                         ; Acceptance Code Bit 2
CAN0IDAR3_AC3:      equ    3                                         ; Acceptance Code Bit 3
CAN0IDAR3_AC4:      equ    4                                         ; Acceptance Code Bit 4
CAN0IDAR3_AC5:      equ    5                                         ; Acceptance Code Bit 5
CAN0IDAR3_AC6:      equ    6                                         ; Acceptance Code Bit 6
CAN0IDAR3_AC7:      equ    7                                         ; Acceptance Code Bit 7
; bit position masks
mCAN0IDAR3_AC0:     equ    %00000001
mCAN0IDAR3_AC1:     equ    %00000010
mCAN0IDAR3_AC2:     equ    %00000100
mCAN0IDAR3_AC3:     equ    %00001000
mCAN0IDAR3_AC4:     equ    %00010000
mCAN0IDAR3_AC5:     equ    %00100000
mCAN0IDAR3_AC6:     equ    %01000000
mCAN0IDAR3_AC7:     equ    %10000000


;*** CAN0IDMR0 - MSCAN 0 Identifier Mask Register 0; 0x00000154 ***
CAN0IDMR0:          equ    $00000154                                ;*** CAN0IDMR0 - MSCAN 0 Identifier Mask Register 0; 0x00000154 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0IDMR0_AM0:      equ    0                                         ; Acceptance Mask Bit 0
CAN0IDMR0_AM1:      equ    1                                         ; Acceptance Mask Bit 1
CAN0IDMR0_AM2:      equ    2                                         ; Acceptance Mask Bit 2
CAN0IDMR0_AM3:      equ    3                                         ; Acceptance Mask Bit 3
CAN0IDMR0_AM4:      equ    4                                         ; Acceptance Mask Bit 4
CAN0IDMR0_AM5:      equ    5                                         ; Acceptance Mask Bit 5
CAN0IDMR0_AM6:      equ    6                                         ; Acceptance Mask Bit 6
CAN0IDMR0_AM7:      equ    7                                         ; Acceptance Mask Bit 7
; bit position masks
mCAN0IDMR0_AM0:     equ    %00000001
mCAN0IDMR0_AM1:     equ    %00000010
mCAN0IDMR0_AM2:     equ    %00000100
mCAN0IDMR0_AM3:     equ    %00001000
mCAN0IDMR0_AM4:     equ    %00010000
mCAN0IDMR0_AM5:     equ    %00100000
mCAN0IDMR0_AM6:     equ    %01000000
mCAN0IDMR0_AM7:     equ    %10000000


;*** CAN0IDMR1 - MSCAN 0 Identifier Mask Register 1; 0x00000155 ***
CAN0IDMR1:          equ    $00000155                                ;*** CAN0IDMR1 - MSCAN 0 Identifier Mask Register 1; 0x00000155 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0IDMR1_AM0:      equ    0                                         ; Acceptance Mask Bit 0
CAN0IDMR1_AM1:      equ    1                                         ; Acceptance Mask Bit 1
CAN0IDMR1_AM2:      equ    2                                         ; Acceptance Mask Bit 2
CAN0IDMR1_AM3:      equ    3                                         ; Acceptance Mask Bit 3
CAN0IDMR1_AM4:      equ    4                                         ; Acceptance Mask Bit 4
CAN0IDMR1_AM5:      equ    5                                         ; Acceptance Mask Bit 5
CAN0IDMR1_AM6:      equ    6                                         ; Acceptance Mask Bit 6
CAN0IDMR1_AM7:      equ    7                                         ; Acceptance Mask Bit 7
; bit position masks
mCAN0IDMR1_AM0:     equ    %00000001
mCAN0IDMR1_AM1:     equ    %00000010
mCAN0IDMR1_AM2:     equ    %00000100
mCAN0IDMR1_AM3:     equ    %00001000
mCAN0IDMR1_AM4:     equ    %00010000
mCAN0IDMR1_AM5:     equ    %00100000
mCAN0IDMR1_AM6:     equ    %01000000
mCAN0IDMR1_AM7:     equ    %10000000


;*** CAN0IDMR2 - MSCAN 0 Identifier Mask Register 2; 0x00000156 ***
CAN0IDMR2:          equ    $00000156                                ;*** CAN0IDMR2 - MSCAN 0 Identifier Mask Register 2; 0x00000156 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0IDMR2_AM0:      equ    0                                         ; Acceptance Mask Bit 0
CAN0IDMR2_AM1:      equ    1                                         ; Acceptance Mask Bit 1
CAN0IDMR2_AM2:      equ    2                                         ; Acceptance Mask Bit 2
CAN0IDMR2_AM3:      equ    3                                         ; Acceptance Mask Bit 3
CAN0IDMR2_AM4:      equ    4                                         ; Acceptance Mask Bit 4
CAN0IDMR2_AM5:      equ    5                                         ; Acceptance Mask Bit 5
CAN0IDMR2_AM6:      equ    6                                         ; Acceptance Mask Bit 6
CAN0IDMR2_AM7:      equ    7                                         ; Acceptance Mask Bit 7
; bit position masks
mCAN0IDMR2_AM0:     equ    %00000001
mCAN0IDMR2_AM1:     equ    %00000010
mCAN0IDMR2_AM2:     equ    %00000100
mCAN0IDMR2_AM3:     equ    %00001000
mCAN0IDMR2_AM4:     equ    %00010000
mCAN0IDMR2_AM5:     equ    %00100000
mCAN0IDMR2_AM6:     equ    %01000000
mCAN0IDMR2_AM7:     equ    %10000000


;*** CAN0IDMR3 - MSCAN 0 Identifier Mask Register 3; 0x00000157 ***
CAN0IDMR3:          equ    $00000157                                ;*** CAN0IDMR3 - MSCAN 0 Identifier Mask Register 3; 0x00000157 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0IDMR3_AM0:      equ    0                                         ; Acceptance Mask Bit 0
CAN0IDMR3_AM1:      equ    1                                         ; Acceptance Mask Bit 1
CAN0IDMR3_AM2:      equ    2                                         ; Acceptance Mask Bit 2
CAN0IDMR3_AM3:      equ    3                                         ; Acceptance Mask Bit 3
CAN0IDMR3_AM4:      equ    4                                         ; Acceptance Mask Bit 4
CAN0IDMR3_AM5:      equ    5                                         ; Acceptance Mask Bit 5
CAN0IDMR3_AM6:      equ    6                                         ; Acceptance Mask Bit 6
CAN0IDMR3_AM7:      equ    7                                         ; Acceptance Mask Bit 7
; bit position masks
mCAN0IDMR3_AM0:     equ    %00000001
mCAN0IDMR3_AM1:     equ    %00000010
mCAN0IDMR3_AM2:     equ    %00000100
mCAN0IDMR3_AM3:     equ    %00001000
mCAN0IDMR3_AM4:     equ    %00010000
mCAN0IDMR3_AM5:     equ    %00100000
mCAN0IDMR3_AM6:     equ    %01000000
mCAN0IDMR3_AM7:     equ    %10000000


;*** CAN0IDAR4 - MSCAN 0 Identifier Acceptance Register 4; 0x00000158 ***
CAN0IDAR4:          equ    $00000158                                ;*** CAN0IDAR4 - MSCAN 0 Identifier Acceptance Register 4; 0x00000158 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0IDAR4_AC0:      equ    0                                         ; Acceptance Code Bit 0
CAN0IDAR4_AC1:      equ    1                                         ; Acceptance Code Bit 1
CAN0IDAR4_AC2:      equ    2                                         ; Acceptance Code Bit 2
CAN0IDAR4_AC3:      equ    3                                         ; Acceptance Code Bit 3
CAN0IDAR4_AC4:      equ    4                                         ; Acceptance Code Bit 4
CAN0IDAR4_AC5:      equ    5                                         ; Acceptance Code Bit 5
CAN0IDAR4_AC6:      equ    6                                         ; Acceptance Code Bit 6
CAN0IDAR4_AC7:      equ    7                                         ; Acceptance Code Bit 7
; bit position masks
mCAN0IDAR4_AC0:     equ    %00000001
mCAN0IDAR4_AC1:     equ    %00000010
mCAN0IDAR4_AC2:     equ    %00000100
mCAN0IDAR4_AC3:     equ    %00001000
mCAN0IDAR4_AC4:     equ    %00010000
mCAN0IDAR4_AC5:     equ    %00100000
mCAN0IDAR4_AC6:     equ    %01000000
mCAN0IDAR4_AC7:     equ    %10000000


;*** CAN0IDAR5 - MSCAN 0 Identifier Acceptance Register 5; 0x00000159 ***
CAN0IDAR5:          equ    $00000159                                ;*** CAN0IDAR5 - MSCAN 0 Identifier Acceptance Register 5; 0x00000159 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0IDAR5_AC0:      equ    0                                         ; Acceptance Code Bit 0
CAN0IDAR5_AC1:      equ    1                                         ; Acceptance Code Bit 1
CAN0IDAR5_AC2:      equ    2                                         ; Acceptance Code Bit 2
CAN0IDAR5_AC3:      equ    3                                         ; Acceptance Code Bit 3
CAN0IDAR5_AC4:      equ    4                                         ; Acceptance Code Bit 4
CAN0IDAR5_AC5:      equ    5                                         ; Acceptance Code Bit 5
CAN0IDAR5_AC6:      equ    6                                         ; Acceptance Code Bit 6
CAN0IDAR5_AC7:      equ    7                                         ; Acceptance Code Bit 7
; bit position masks
mCAN0IDAR5_AC0:     equ    %00000001
mCAN0IDAR5_AC1:     equ    %00000010
mCAN0IDAR5_AC2:     equ    %00000100
mCAN0IDAR5_AC3:     equ    %00001000
mCAN0IDAR5_AC4:     equ    %00010000
mCAN0IDAR5_AC5:     equ    %00100000
mCAN0IDAR5_AC6:     equ    %01000000
mCAN0IDAR5_AC7:     equ    %10000000


;*** CAN0IDAR6 - MSCAN 0 Identifier Acceptance Register 6; 0x0000015A ***
CAN0IDAR6:          equ    $0000015A                                ;*** CAN0IDAR6 - MSCAN 0 Identifier Acceptance Register 6; 0x0000015A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0IDAR6_AC0:      equ    0                                         ; Acceptance Code Bit 0
CAN0IDAR6_AC1:      equ    1                                         ; Acceptance Code Bit 1
CAN0IDAR6_AC2:      equ    2                                         ; Acceptance Code Bit 2
CAN0IDAR6_AC3:      equ    3                                         ; Acceptance Code Bit 3
CAN0IDAR6_AC4:      equ    4                                         ; Acceptance Code Bit 4
CAN0IDAR6_AC5:      equ    5                                         ; Acceptance Code Bit 5
CAN0IDAR6_AC6:      equ    6                                         ; Acceptance Code Bit 6
CAN0IDAR6_AC7:      equ    7                                         ; Acceptance Code Bit 7
; bit position masks
mCAN0IDAR6_AC0:     equ    %00000001
mCAN0IDAR6_AC1:     equ    %00000010
mCAN0IDAR6_AC2:     equ    %00000100
mCAN0IDAR6_AC3:     equ    %00001000
mCAN0IDAR6_AC4:     equ    %00010000
mCAN0IDAR6_AC5:     equ    %00100000
mCAN0IDAR6_AC6:     equ    %01000000
mCAN0IDAR6_AC7:     equ    %10000000


;*** CAN0IDAR7 - MSCAN 0 Identifier Acceptance Register 7; 0x0000015B ***
CAN0IDAR7:          equ    $0000015B                                ;*** CAN0IDAR7 - MSCAN 0 Identifier Acceptance Register 7; 0x0000015B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0IDAR7_AC0:      equ    0                                         ; Acceptance Code Bit 0
CAN0IDAR7_AC1:      equ    1                                         ; Acceptance Code Bit 1
CAN0IDAR7_AC2:      equ    2                                         ; Acceptance Code Bit 2
CAN0IDAR7_AC3:      equ    3                                         ; Acceptance Code Bit 3
CAN0IDAR7_AC4:      equ    4                                         ; Acceptance Code Bit 4
CAN0IDAR7_AC5:      equ    5                                         ; Acceptance Code Bit 5
CAN0IDAR7_AC6:      equ    6                                         ; Acceptance Code Bit 6
CAN0IDAR7_AC7:      equ    7                                         ; Acceptance Code Bit 7
; bit position masks
mCAN0IDAR7_AC0:     equ    %00000001
mCAN0IDAR7_AC1:     equ    %00000010
mCAN0IDAR7_AC2:     equ    %00000100
mCAN0IDAR7_AC3:     equ    %00001000
mCAN0IDAR7_AC4:     equ    %00010000
mCAN0IDAR7_AC5:     equ    %00100000
mCAN0IDAR7_AC6:     equ    %01000000
mCAN0IDAR7_AC7:     equ    %10000000


;*** CAN0IDMR4 - MSCAN 0 Identifier Mask Register 4; 0x0000015C ***
CAN0IDMR4:          equ    $0000015C                                ;*** CAN0IDMR4 - MSCAN 0 Identifier Mask Register 4; 0x0000015C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0IDMR4_AM0:      equ    0                                         ; Acceptance Mask Bit 0
CAN0IDMR4_AM1:      equ    1                                         ; Acceptance Mask Bit 1
CAN0IDMR4_AM2:      equ    2                                         ; Acceptance Mask Bit 2
CAN0IDMR4_AM3:      equ    3                                         ; Acceptance Mask Bit 3
CAN0IDMR4_AM4:      equ    4                                         ; Acceptance Mask Bit 4
CAN0IDMR4_AM5:      equ    5                                         ; Acceptance Mask Bit 5
CAN0IDMR4_AM6:      equ    6                                         ; Acceptance Mask Bit 6
CAN0IDMR4_AM7:      equ    7                                         ; Acceptance Mask Bit 7
; bit position masks
mCAN0IDMR4_AM0:     equ    %00000001
mCAN0IDMR4_AM1:     equ    %00000010
mCAN0IDMR4_AM2:     equ    %00000100
mCAN0IDMR4_AM3:     equ    %00001000
mCAN0IDMR4_AM4:     equ    %00010000
mCAN0IDMR4_AM5:     equ    %00100000
mCAN0IDMR4_AM6:     equ    %01000000
mCAN0IDMR4_AM7:     equ    %10000000


;*** CAN0IDMR5 - MSCAN 0 Identifier Mask Register 5; 0x0000015D ***
CAN0IDMR5:          equ    $0000015D                                ;*** CAN0IDMR5 - MSCAN 0 Identifier Mask Register 5; 0x0000015D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0IDMR5_AM0:      equ    0                                         ; Acceptance Mask Bit 0
CAN0IDMR5_AM1:      equ    1                                         ; Acceptance Mask Bit 1
CAN0IDMR5_AM2:      equ    2                                         ; Acceptance Mask Bit 2
CAN0IDMR5_AM3:      equ    3                                         ; Acceptance Mask Bit 3
CAN0IDMR5_AM4:      equ    4                                         ; Acceptance Mask Bit 4
CAN0IDMR5_AM5:      equ    5                                         ; Acceptance Mask Bit 5
CAN0IDMR5_AM6:      equ    6                                         ; Acceptance Mask Bit 6
CAN0IDMR5_AM7:      equ    7                                         ; Acceptance Mask Bit 7
; bit position masks
mCAN0IDMR5_AM0:     equ    %00000001
mCAN0IDMR5_AM1:     equ    %00000010
mCAN0IDMR5_AM2:     equ    %00000100
mCAN0IDMR5_AM3:     equ    %00001000
mCAN0IDMR5_AM4:     equ    %00010000
mCAN0IDMR5_AM5:     equ    %00100000
mCAN0IDMR5_AM6:     equ    %01000000
mCAN0IDMR5_AM7:     equ    %10000000


;*** CAN0IDMR6 - MSCAN 0 Identifier Mask Register 6; 0x0000015E ***
CAN0IDMR6:          equ    $0000015E                                ;*** CAN0IDMR6 - MSCAN 0 Identifier Mask Register 6; 0x0000015E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0IDMR6_AM0:      equ    0                                         ; Acceptance Mask Bit 0
CAN0IDMR6_AM1:      equ    1                                         ; Acceptance Mask Bit 1
CAN0IDMR6_AM2:      equ    2                                         ; Acceptance Mask Bit 2
CAN0IDMR6_AM3:      equ    3                                         ; Acceptance Mask Bit 3
CAN0IDMR6_AM4:      equ    4                                         ; Acceptance Mask Bit 4
CAN0IDMR6_AM5:      equ    5                                         ; Acceptance Mask Bit 5
CAN0IDMR6_AM6:      equ    6                                         ; Acceptance Mask Bit 6
CAN0IDMR6_AM7:      equ    7                                         ; Acceptance Mask Bit 7
; bit position masks
mCAN0IDMR6_AM0:     equ    %00000001
mCAN0IDMR6_AM1:     equ    %00000010
mCAN0IDMR6_AM2:     equ    %00000100
mCAN0IDMR6_AM3:     equ    %00001000
mCAN0IDMR6_AM4:     equ    %00010000
mCAN0IDMR6_AM5:     equ    %00100000
mCAN0IDMR6_AM6:     equ    %01000000
mCAN0IDMR6_AM7:     equ    %10000000


;*** CAN0IDMR7 - MSCAN 0 Identifier Mask Register 7; 0x0000015F ***
CAN0IDMR7:          equ    $0000015F                                ;*** CAN0IDMR7 - MSCAN 0 Identifier Mask Register 7; 0x0000015F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0IDMR7_AM0:      equ    0                                         ; Acceptance Mask Bit 0
CAN0IDMR7_AM1:      equ    1                                         ; Acceptance Mask Bit 1
CAN0IDMR7_AM2:      equ    2                                         ; Acceptance Mask Bit 2
CAN0IDMR7_AM3:      equ    3                                         ; Acceptance Mask Bit 3
CAN0IDMR7_AM4:      equ    4                                         ; Acceptance Mask Bit 4
CAN0IDMR7_AM5:      equ    5                                         ; Acceptance Mask Bit 5
CAN0IDMR7_AM6:      equ    6                                         ; Acceptance Mask Bit 6
CAN0IDMR7_AM7:      equ    7                                         ; Acceptance Mask Bit 7
; bit position masks
mCAN0IDMR7_AM0:     equ    %00000001
mCAN0IDMR7_AM1:     equ    %00000010
mCAN0IDMR7_AM2:     equ    %00000100
mCAN0IDMR7_AM3:     equ    %00001000
mCAN0IDMR7_AM4:     equ    %00010000
mCAN0IDMR7_AM5:     equ    %00100000
mCAN0IDMR7_AM6:     equ    %01000000
mCAN0IDMR7_AM7:     equ    %10000000


;*** CAN0RXIDR0 - MSCAN 0 Receive Identifier Register 0; 0x00000160 ***
CAN0RXIDR0:         equ    $00000160                                ;*** CAN0RXIDR0 - MSCAN 0 Receive Identifier Register 0; 0x00000160 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0RXIDR0_ID21:    equ    0                                         ; Extended format identifier Bit 21
CAN0RXIDR0_ID22:    equ    1                                         ; Extended format identifier Bit 22
CAN0RXIDR0_ID23:    equ    2                                         ; Extended format identifier Bit 23
CAN0RXIDR0_ID24:    equ    3                                         ; Extended format identifier Bit 24
CAN0RXIDR0_ID25:    equ    4                                         ; Extended format identifier Bit 25
CAN0RXIDR0_ID26:    equ    5                                         ; Extended format identifier Bit 26
CAN0RXIDR0_ID27:    equ    6                                         ; Extended format identifier Bit 27
CAN0RXIDR0_ID28:    equ    7                                         ; Extended format identifier Bit 28
; bit position masks
mCAN0RXIDR0_ID21:   equ    %00000001
mCAN0RXIDR0_ID22:   equ    %00000010
mCAN0RXIDR0_ID23:   equ    %00000100
mCAN0RXIDR0_ID24:   equ    %00001000
mCAN0RXIDR0_ID25:   equ    %00010000
mCAN0RXIDR0_ID26:   equ    %00100000
mCAN0RXIDR0_ID27:   equ    %01000000
mCAN0RXIDR0_ID28:   equ    %10000000


;*** CAN0RXIDR1 - MSCAN 0 Receive Identifier Register 1; 0x00000161 ***
CAN0RXIDR1:         equ    $00000161                                ;*** CAN0RXIDR1 - MSCAN 0 Receive Identifier Register 1; 0x00000161 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0RXIDR1_ID15:    equ    0                                         ; Extended format identifier Bit 15
CAN0RXIDR1_ID16:    equ    1                                         ; Extended format identifier Bit 16
CAN0RXIDR1_ID17:    equ    2                                         ; Extended format identifier Bit 17
CAN0RXIDR1_IDE:     equ    3                                         ; ID Extended
CAN0RXIDR1_SRR:     equ    4                                         ; Substitute Remote Request
CAN0RXIDR1_ID18:    equ    5                                         ; Extended format identifier Bit 18
CAN0RXIDR1_ID19:    equ    6                                         ; Extended format identifier Bit 19
CAN0RXIDR1_ID20:    equ    7                                         ; Extended format identifier Bit 20
; bit position masks
mCAN0RXIDR1_ID15:   equ    %00000001
mCAN0RXIDR1_ID16:   equ    %00000010
mCAN0RXIDR1_ID17:   equ    %00000100
mCAN0RXIDR1_IDE:    equ    %00001000
mCAN0RXIDR1_SRR:    equ    %00010000
mCAN0RXIDR1_ID18:   equ    %00100000
mCAN0RXIDR1_ID19:   equ    %01000000
mCAN0RXIDR1_ID20:   equ    %10000000


;*** CAN0RXIDR2 - MSCAN 0 Receive Identifier Register 2; 0x00000162 ***
CAN0RXIDR2:         equ    $00000162                                ;*** CAN0RXIDR2 - MSCAN 0 Receive Identifier Register 2; 0x00000162 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0RXIDR2_ID7:     equ    0                                         ; Extended format identifier Bit 7
CAN0RXIDR2_ID8:     equ    1                                         ; Extended format identifier Bit 8
CAN0RXIDR2_ID9:     equ    2                                         ; Extended format identifier Bit 9
CAN0RXIDR2_ID10:    equ    3                                         ; Extended format identifier Bit 10
CAN0RXIDR2_ID11:    equ    4                                         ; Extended format identifier Bit 11
CAN0RXIDR2_ID12:    equ    5                                         ; Extended format identifier Bit 12
CAN0RXIDR2_ID13:    equ    6                                         ; Extended format identifier Bit 13
CAN0RXIDR2_ID14:    equ    7                                         ; Extended format identifier Bit 14
; bit position masks
mCAN0RXIDR2_ID7:    equ    %00000001
mCAN0RXIDR2_ID8:    equ    %00000010
mCAN0RXIDR2_ID9:    equ    %00000100
mCAN0RXIDR2_ID10:   equ    %00001000
mCAN0RXIDR2_ID11:   equ    %00010000
mCAN0RXIDR2_ID12:   equ    %00100000
mCAN0RXIDR2_ID13:   equ    %01000000
mCAN0RXIDR2_ID14:   equ    %10000000


;*** CAN0RXIDR3 - MSCAN 0 Receive Identifier Register 3; 0x00000163 ***
CAN0RXIDR3:         equ    $00000163                                ;*** CAN0RXIDR3 - MSCAN 0 Receive Identifier Register 3; 0x00000163 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0RXIDR3_RTR:     equ    0                                         ; Remote Transmission Request
CAN0RXIDR3_ID0:     equ    1                                         ; Extended format identifier Bit 0
CAN0RXIDR3_ID1:     equ    2                                         ; Extended format identifier Bit 1
CAN0RXIDR3_ID2:     equ    3                                         ; Extended format identifier Bit 2
CAN0RXIDR3_ID3:     equ    4                                         ; Extended format identifier Bit 3
CAN0RXIDR3_ID4:     equ    5                                         ; Extended format identifier Bit 4
CAN0RXIDR3_ID5:     equ    6                                         ; Extended format identifier Bit 5
CAN0RXIDR3_ID6:     equ    7                                         ; Extended format identifier Bit 6
; bit position masks
mCAN0RXIDR3_RTR:    equ    %00000001
mCAN0RXIDR3_ID0:    equ    %00000010
mCAN0RXIDR3_ID1:    equ    %00000100
mCAN0RXIDR3_ID2:    equ    %00001000
mCAN0RXIDR3_ID3:    equ    %00010000
mCAN0RXIDR3_ID4:    equ    %00100000
mCAN0RXIDR3_ID5:    equ    %01000000
mCAN0RXIDR3_ID6:    equ    %10000000


;*** CAN0RXDSR0 - MSCAN 0 Receive Data Segment Register 0; 0x00000164 ***
CAN0RXDSR0:         equ    $00000164                                ;*** CAN0RXDSR0 - MSCAN 0 Receive Data Segment Register 0; 0x00000164 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0RXDSR0_DB0:     equ    0                                         ; Data Bit 0
CAN0RXDSR0_DB1:     equ    1                                         ; Data Bit 1
CAN0RXDSR0_DB2:     equ    2                                         ; Data Bit 2
CAN0RXDSR0_DB3:     equ    3                                         ; Data Bit 3
CAN0RXDSR0_DB4:     equ    4                                         ; Data Bit 4
CAN0RXDSR0_DB5:     equ    5                                         ; Data Bit 5
CAN0RXDSR0_DB6:     equ    6                                         ; Data Bit 6
CAN0RXDSR0_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN0RXDSR0_DB0:    equ    %00000001
mCAN0RXDSR0_DB1:    equ    %00000010
mCAN0RXDSR0_DB2:    equ    %00000100
mCAN0RXDSR0_DB3:    equ    %00001000
mCAN0RXDSR0_DB4:    equ    %00010000
mCAN0RXDSR0_DB5:    equ    %00100000
mCAN0RXDSR0_DB6:    equ    %01000000
mCAN0RXDSR0_DB7:    equ    %10000000


;*** CAN0RXDSR1 - MSCAN 0 Receive Data Segment Register 1; 0x00000165 ***
CAN0RXDSR1:         equ    $00000165                                ;*** CAN0RXDSR1 - MSCAN 0 Receive Data Segment Register 1; 0x00000165 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0RXDSR1_DB0:     equ    0                                         ; Data Bit 0
CAN0RXDSR1_DB1:     equ    1                                         ; Data Bit 1
CAN0RXDSR1_DB2:     equ    2                                         ; Data Bit 2
CAN0RXDSR1_DB3:     equ    3                                         ; Data Bit 3
CAN0RXDSR1_DB4:     equ    4                                         ; Data Bit 4
CAN0RXDSR1_DB5:     equ    5                                         ; Data Bit 5
CAN0RXDSR1_DB6:     equ    6                                         ; Data Bit 6
CAN0RXDSR1_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN0RXDSR1_DB0:    equ    %00000001
mCAN0RXDSR1_DB1:    equ    %00000010
mCAN0RXDSR1_DB2:    equ    %00000100
mCAN0RXDSR1_DB3:    equ    %00001000
mCAN0RXDSR1_DB4:    equ    %00010000
mCAN0RXDSR1_DB5:    equ    %00100000
mCAN0RXDSR1_DB6:    equ    %01000000
mCAN0RXDSR1_DB7:    equ    %10000000


;*** CAN0RXDSR2 - MSCAN 0 Receive Data Segment Register 2; 0x00000166 ***
CAN0RXDSR2:         equ    $00000166                                ;*** CAN0RXDSR2 - MSCAN 0 Receive Data Segment Register 2; 0x00000166 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0RXDSR2_DB0:     equ    0                                         ; Data Bit 0
CAN0RXDSR2_DB1:     equ    1                                         ; Data Bit 1
CAN0RXDSR2_DB2:     equ    2                                         ; Data Bit 2
CAN0RXDSR2_DB3:     equ    3                                         ; Data Bit 3
CAN0RXDSR2_DB4:     equ    4                                         ; Data Bit 4
CAN0RXDSR2_DB5:     equ    5                                         ; Data Bit 5
CAN0RXDSR2_DB6:     equ    6                                         ; Data Bit 6
CAN0RXDSR2_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN0RXDSR2_DB0:    equ    %00000001
mCAN0RXDSR2_DB1:    equ    %00000010
mCAN0RXDSR2_DB2:    equ    %00000100
mCAN0RXDSR2_DB3:    equ    %00001000
mCAN0RXDSR2_DB4:    equ    %00010000
mCAN0RXDSR2_DB5:    equ    %00100000
mCAN0RXDSR2_DB6:    equ    %01000000
mCAN0RXDSR2_DB7:    equ    %10000000


;*** CAN0RXDSR3 - MSCAN 0 Receive Data Segment Register 3; 0x00000167 ***
CAN0RXDSR3:         equ    $00000167                                ;*** CAN0RXDSR3 - MSCAN 0 Receive Data Segment Register 3; 0x00000167 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0RXDSR3_DB0:     equ    0                                         ; Data Bit 0
CAN0RXDSR3_DB1:     equ    1                                         ; Data Bit 1
CAN0RXDSR3_DB2:     equ    2                                         ; Data Bit 2
CAN0RXDSR3_DB3:     equ    3                                         ; Data Bit 3
CAN0RXDSR3_DB4:     equ    4                                         ; Data Bit 4
CAN0RXDSR3_DB5:     equ    5                                         ; Data Bit 5
CAN0RXDSR3_DB6:     equ    6                                         ; Data Bit 6
CAN0RXDSR3_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN0RXDSR3_DB0:    equ    %00000001
mCAN0RXDSR3_DB1:    equ    %00000010
mCAN0RXDSR3_DB2:    equ    %00000100
mCAN0RXDSR3_DB3:    equ    %00001000
mCAN0RXDSR3_DB4:    equ    %00010000
mCAN0RXDSR3_DB5:    equ    %00100000
mCAN0RXDSR3_DB6:    equ    %01000000
mCAN0RXDSR3_DB7:    equ    %10000000


;*** CAN0RXDSR4 - MSCAN 0 Receive Data Segment Register 4; 0x00000168 ***
CAN0RXDSR4:         equ    $00000168                                ;*** CAN0RXDSR4 - MSCAN 0 Receive Data Segment Register 4; 0x00000168 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0RXDSR4_DB0:     equ    0                                         ; Data Bit 0
CAN0RXDSR4_DB1:     equ    1                                         ; Data Bit 1
CAN0RXDSR4_DB2:     equ    2                                         ; Data Bit 2
CAN0RXDSR4_DB3:     equ    3                                         ; Data Bit 3
CAN0RXDSR4_DB4:     equ    4                                         ; Data Bit 4
CAN0RXDSR4_DB5:     equ    5                                         ; Data Bit 5
CAN0RXDSR4_DB6:     equ    6                                         ; Data Bit 6
CAN0RXDSR4_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN0RXDSR4_DB0:    equ    %00000001
mCAN0RXDSR4_DB1:    equ    %00000010
mCAN0RXDSR4_DB2:    equ    %00000100
mCAN0RXDSR4_DB3:    equ    %00001000
mCAN0RXDSR4_DB4:    equ    %00010000
mCAN0RXDSR4_DB5:    equ    %00100000
mCAN0RXDSR4_DB6:    equ    %01000000
mCAN0RXDSR4_DB7:    equ    %10000000


;*** CAN0RXDSR5 - MSCAN 0 Receive Data Segment Register 5; 0x00000169 ***
CAN0RXDSR5:         equ    $00000169                                ;*** CAN0RXDSR5 - MSCAN 0 Receive Data Segment Register 5; 0x00000169 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0RXDSR5_DB0:     equ    0                                         ; Data Bit 0
CAN0RXDSR5_DB1:     equ    1                                         ; Data Bit 1
CAN0RXDSR5_DB2:     equ    2                                         ; Data Bit 2
CAN0RXDSR5_DB3:     equ    3                                         ; Data Bit 3
CAN0RXDSR5_DB4:     equ    4                                         ; Data Bit 4
CAN0RXDSR5_DB5:     equ    5                                         ; Data Bit 5
CAN0RXDSR5_DB6:     equ    6                                         ; Data Bit 6
CAN0RXDSR5_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN0RXDSR5_DB0:    equ    %00000001
mCAN0RXDSR5_DB1:    equ    %00000010
mCAN0RXDSR5_DB2:    equ    %00000100
mCAN0RXDSR5_DB3:    equ    %00001000
mCAN0RXDSR5_DB4:    equ    %00010000
mCAN0RXDSR5_DB5:    equ    %00100000
mCAN0RXDSR5_DB6:    equ    %01000000
mCAN0RXDSR5_DB7:    equ    %10000000


;*** CAN0RXDSR6 - MSCAN 0 Receive Data Segment Register 6; 0x0000016A ***
CAN0RXDSR6:         equ    $0000016A                                ;*** CAN0RXDSR6 - MSCAN 0 Receive Data Segment Register 6; 0x0000016A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0RXDSR6_DB0:     equ    0                                         ; Data Bit 0
CAN0RXDSR6_DB1:     equ    1                                         ; Data Bit 1
CAN0RXDSR6_DB2:     equ    2                                         ; Data Bit 2
CAN0RXDSR6_DB3:     equ    3                                         ; Data Bit 3
CAN0RXDSR6_DB4:     equ    4                                         ; Data Bit 4
CAN0RXDSR6_DB5:     equ    5                                         ; Data Bit 5
CAN0RXDSR6_DB6:     equ    6                                         ; Data Bit 6
CAN0RXDSR6_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN0RXDSR6_DB0:    equ    %00000001
mCAN0RXDSR6_DB1:    equ    %00000010
mCAN0RXDSR6_DB2:    equ    %00000100
mCAN0RXDSR6_DB3:    equ    %00001000
mCAN0RXDSR6_DB4:    equ    %00010000
mCAN0RXDSR6_DB5:    equ    %00100000
mCAN0RXDSR6_DB6:    equ    %01000000
mCAN0RXDSR6_DB7:    equ    %10000000


;*** CAN0RXDSR7 - MSCAN 0 Receive Data Segment Register 7; 0x0000016B ***
CAN0RXDSR7:         equ    $0000016B                                ;*** CAN0RXDSR7 - MSCAN 0 Receive Data Segment Register 7; 0x0000016B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0RXDSR7_DB0:     equ    0                                         ; Data Bit 0
CAN0RXDSR7_DB1:     equ    1                                         ; Data Bit 1
CAN0RXDSR7_DB2:     equ    2                                         ; Data Bit 2
CAN0RXDSR7_DB3:     equ    3                                         ; Data Bit 3
CAN0RXDSR7_DB4:     equ    4                                         ; Data Bit 4
CAN0RXDSR7_DB5:     equ    5                                         ; Data Bit 5
CAN0RXDSR7_DB6:     equ    6                                         ; Data Bit 6
CAN0RXDSR7_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN0RXDSR7_DB0:    equ    %00000001
mCAN0RXDSR7_DB1:    equ    %00000010
mCAN0RXDSR7_DB2:    equ    %00000100
mCAN0RXDSR7_DB3:    equ    %00001000
mCAN0RXDSR7_DB4:    equ    %00010000
mCAN0RXDSR7_DB5:    equ    %00100000
mCAN0RXDSR7_DB6:    equ    %01000000
mCAN0RXDSR7_DB7:    equ    %10000000


;*** CAN0RXDLR - MSCAN 0 Receive Data Length Register; 0x0000016C ***
CAN0RXDLR:          equ    $0000016C                                ;*** CAN0RXDLR - MSCAN 0 Receive Data Length Register; 0x0000016C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0RXDLR_DLC0:     equ    0                                         ; Data Length Code Bit 0
CAN0RXDLR_DLC1:     equ    1                                         ; Data Length Code Bit 1
CAN0RXDLR_DLC2:     equ    2                                         ; Data Length Code Bit 2
CAN0RXDLR_DLC3:     equ    3                                         ; Data Length Code Bit 3
; bit position masks
mCAN0RXDLR_DLC0:    equ    %00000001
mCAN0RXDLR_DLC1:    equ    %00000010
mCAN0RXDLR_DLC2:    equ    %00000100
mCAN0RXDLR_DLC3:    equ    %00001000


;*** CAN0RXTSR - MSCAN 0 Receive Time Stamp Register; 0x0000016E ***
CAN0RXTSR:          equ    $0000016E                                ;*** CAN0RXTSR - MSCAN 0 Receive Time Stamp Register; 0x0000016E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0RXTSR_TSR0:     equ    0                                         ; Time Stamp Bit 0
CAN0RXTSR_TSR1:     equ    1                                         ; Time Stamp Bit 1
CAN0RXTSR_TSR2:     equ    2                                         ; Time Stamp Bit 2
CAN0RXTSR_TSR3:     equ    3                                         ; Time Stamp Bit 3
CAN0RXTSR_TSR4:     equ    4                                         ; Time Stamp Bit 4
CAN0RXTSR_TSR5:     equ    5                                         ; Time Stamp Bit 5
CAN0RXTSR_TSR6:     equ    6                                         ; Time Stamp Bit 6
CAN0RXTSR_TSR7:     equ    7                                         ; Time Stamp Bit 7
CAN0RXTSR_TSR8:     equ    8                                         ; Time Stamp Bit 8
CAN0RXTSR_TSR9:     equ    9                                         ; Time Stamp Bit 9
CAN0RXTSR_TSR10:    equ    10                                        ; Time Stamp Bit 10
CAN0RXTSR_TSR11:    equ    11                                        ; Time Stamp Bit 11
CAN0RXTSR_TSR12:    equ    12                                        ; Time Stamp Bit 12
CAN0RXTSR_TSR13:    equ    13                                        ; Time Stamp Bit 13
CAN0RXTSR_TSR14:    equ    14                                        ; Time Stamp Bit 14
CAN0RXTSR_TSR15:    equ    15                                        ; Time Stamp Bit 15
; bit position masks
mCAN0RXTSR_TSR0:    equ    %00000001
mCAN0RXTSR_TSR1:    equ    %00000010
mCAN0RXTSR_TSR2:    equ    %00000100
mCAN0RXTSR_TSR3:    equ    %00001000
mCAN0RXTSR_TSR4:    equ    %00010000
mCAN0RXTSR_TSR5:    equ    %00100000
mCAN0RXTSR_TSR6:    equ    %01000000
mCAN0RXTSR_TSR7:    equ    %10000000
mCAN0RXTSR_TSR8:    equ    %100000000
mCAN0RXTSR_TSR9:    equ    %1000000000
mCAN0RXTSR_TSR10:   equ    %10000000000
mCAN0RXTSR_TSR11:   equ    %100000000000
mCAN0RXTSR_TSR12:   equ    %1000000000000
mCAN0RXTSR_TSR13:   equ    %10000000000000
mCAN0RXTSR_TSR14:   equ    %100000000000000
mCAN0RXTSR_TSR15:   equ    %1000000000000000


;*** CAN0RXTSRH - MSCAN 0 Receive Time Stamp Register High; 0x0000016E ***
CAN0RXTSRH:         equ    $0000016E                                ;*** CAN0RXTSRH - MSCAN 0 Receive Time Stamp Register High; 0x0000016E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0RXTSRH_TSR8:    equ    0                                         ; Time Stamp Bit 8
CAN0RXTSRH_TSR9:    equ    1                                         ; Time Stamp Bit 9
CAN0RXTSRH_TSR10:   equ    2                                         ; Time Stamp Bit 10
CAN0RXTSRH_TSR11:   equ    3                                         ; Time Stamp Bit 11
CAN0RXTSRH_TSR12:   equ    4                                         ; Time Stamp Bit 12
CAN0RXTSRH_TSR13:   equ    5                                         ; Time Stamp Bit 13
CAN0RXTSRH_TSR14:   equ    6                                         ; Time Stamp Bit 14
CAN0RXTSRH_TSR15:   equ    7                                         ; Time Stamp Bit 15
; bit position masks
mCAN0RXTSRH_TSR8:   equ    %00000001
mCAN0RXTSRH_TSR9:   equ    %00000010
mCAN0RXTSRH_TSR10:  equ    %00000100
mCAN0RXTSRH_TSR11:  equ    %00001000
mCAN0RXTSRH_TSR12:  equ    %00010000
mCAN0RXTSRH_TSR13:  equ    %00100000
mCAN0RXTSRH_TSR14:  equ    %01000000
mCAN0RXTSRH_TSR15:  equ    %10000000


;*** CAN0RXTSRL - MSCAN 0 Receive Time Stamp Register Low; 0x0000016F ***
CAN0RXTSRL:         equ    $0000016F                                ;*** CAN0RXTSRL - MSCAN 0 Receive Time Stamp Register Low; 0x0000016F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0RXTSRL_TSR0:    equ    0                                         ; Time Stamp Bit 0
CAN0RXTSRL_TSR1:    equ    1                                         ; Time Stamp Bit 1
CAN0RXTSRL_TSR2:    equ    2                                         ; Time Stamp Bit 2
CAN0RXTSRL_TSR3:    equ    3                                         ; Time Stamp Bit 3
CAN0RXTSRL_TSR4:    equ    4                                         ; Time Stamp Bit 4
CAN0RXTSRL_TSR5:    equ    5                                         ; Time Stamp Bit 5
CAN0RXTSRL_TSR6:    equ    6                                         ; Time Stamp Bit 6
CAN0RXTSRL_TSR7:    equ    7                                         ; Time Stamp Bit 7
; bit position masks
mCAN0RXTSRL_TSR0:   equ    %00000001
mCAN0RXTSRL_TSR1:   equ    %00000010
mCAN0RXTSRL_TSR2:   equ    %00000100
mCAN0RXTSRL_TSR3:   equ    %00001000
mCAN0RXTSRL_TSR4:   equ    %00010000
mCAN0RXTSRL_TSR5:   equ    %00100000
mCAN0RXTSRL_TSR6:   equ    %01000000
mCAN0RXTSRL_TSR7:   equ    %10000000


;*** CAN0TXIDR0 - MSCAN 0 Transmit Identifier Register 0; 0x00000170 ***
CAN0TXIDR0:         equ    $00000170                                ;*** CAN0TXIDR0 - MSCAN 0 Transmit Identifier Register 0; 0x00000170 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0TXIDR0_ID21:    equ    0                                         ; Extended format identifier Bit 21
CAN0TXIDR0_ID22:    equ    1                                         ; Extended format identifier Bit 22
CAN0TXIDR0_ID23:    equ    2                                         ; Extended format identifier Bit 23
CAN0TXIDR0_ID24:    equ    3                                         ; Extended format identifier Bit 24
CAN0TXIDR0_ID25:    equ    4                                         ; Extended format identifier Bit 25
CAN0TXIDR0_ID26:    equ    5                                         ; Extended format identifier Bit 26
CAN0TXIDR0_ID27:    equ    6                                         ; Extended format identifier Bit 27
CAN0TXIDR0_ID28:    equ    7                                         ; Extended format identifier Bit 28
; bit position masks
mCAN0TXIDR0_ID21:   equ    %00000001
mCAN0TXIDR0_ID22:   equ    %00000010
mCAN0TXIDR0_ID23:   equ    %00000100
mCAN0TXIDR0_ID24:   equ    %00001000
mCAN0TXIDR0_ID25:   equ    %00010000
mCAN0TXIDR0_ID26:   equ    %00100000
mCAN0TXIDR0_ID27:   equ    %01000000
mCAN0TXIDR0_ID28:   equ    %10000000


;*** CAN0TXIDR1 - MSCAN 0 Transmit Identifier Register 1; 0x00000171 ***
CAN0TXIDR1:         equ    $00000171                                ;*** CAN0TXIDR1 - MSCAN 0 Transmit Identifier Register 1; 0x00000171 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0TXIDR1_ID15:    equ    0                                         ; Extended format identifier Bit 15
CAN0TXIDR1_ID16:    equ    1                                         ; Extended format identifier Bit 16
CAN0TXIDR1_ID17:    equ    2                                         ; Extended format identifier Bit 17
CAN0TXIDR1_IDE:     equ    3                                         ; ID Extended
CAN0TXIDR1_SRR:     equ    4                                         ; Substitute Remote Request
CAN0TXIDR1_ID18:    equ    5                                         ; Extended format identifier Bit 18
CAN0TXIDR1_ID19:    equ    6                                         ; Extended format identifier Bit 19
CAN0TXIDR1_ID20:    equ    7                                         ; Extended format identifier Bit 20
; bit position masks
mCAN0TXIDR1_ID15:   equ    %00000001
mCAN0TXIDR1_ID16:   equ    %00000010
mCAN0TXIDR1_ID17:   equ    %00000100
mCAN0TXIDR1_IDE:    equ    %00001000
mCAN0TXIDR1_SRR:    equ    %00010000
mCAN0TXIDR1_ID18:   equ    %00100000
mCAN0TXIDR1_ID19:   equ    %01000000
mCAN0TXIDR1_ID20:   equ    %10000000


;*** CAN0TXIDR2 - MSCAN 0 Transmit Identifier Register 2; 0x00000172 ***
CAN0TXIDR2:         equ    $00000172                                ;*** CAN0TXIDR2 - MSCAN 0 Transmit Identifier Register 2; 0x00000172 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0TXIDR2_ID7:     equ    0                                         ; Extended format identifier Bit 7
CAN0TXIDR2_ID8:     equ    1                                         ; Extended format identifier Bit 8
CAN0TXIDR2_ID9:     equ    2                                         ; Extended format identifier Bit 9
CAN0TXIDR2_ID10:    equ    3                                         ; Extended format identifier Bit 10
CAN0TXIDR2_ID11:    equ    4                                         ; Extended format identifier Bit 11
CAN0TXIDR2_ID12:    equ    5                                         ; Extended format identifier Bit 12
CAN0TXIDR2_ID13:    equ    6                                         ; Extended format identifier Bit 13
CAN0TXIDR2_ID14:    equ    7                                         ; Extended format identifier Bit 14
; bit position masks
mCAN0TXIDR2_ID7:    equ    %00000001
mCAN0TXIDR2_ID8:    equ    %00000010
mCAN0TXIDR2_ID9:    equ    %00000100
mCAN0TXIDR2_ID10:   equ    %00001000
mCAN0TXIDR2_ID11:   equ    %00010000
mCAN0TXIDR2_ID12:   equ    %00100000
mCAN0TXIDR2_ID13:   equ    %01000000
mCAN0TXIDR2_ID14:   equ    %10000000


;*** CAN0TXIDR3 - MSCAN 0 Transmit Identifier Register 3; 0x00000173 ***
CAN0TXIDR3:         equ    $00000173                                ;*** CAN0TXIDR3 - MSCAN 0 Transmit Identifier Register 3; 0x00000173 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0TXIDR3_RTR:     equ    0                                         ; Remote Transmission Request
CAN0TXIDR3_ID0:     equ    1                                         ; Extended format identifier Bit 0
CAN0TXIDR3_ID1:     equ    2                                         ; Extended format identifier Bit 1
CAN0TXIDR3_ID2:     equ    3                                         ; Extended format identifier Bit 2
CAN0TXIDR3_ID3:     equ    4                                         ; Extended format identifier Bit 3
CAN0TXIDR3_ID4:     equ    5                                         ; Extended format identifier Bit 4
CAN0TXIDR3_ID5:     equ    6                                         ; Extended format identifier Bit 5
CAN0TXIDR3_ID6:     equ    7                                         ; Extended format identifier Bit 6
; bit position masks
mCAN0TXIDR3_RTR:    equ    %00000001
mCAN0TXIDR3_ID0:    equ    %00000010
mCAN0TXIDR3_ID1:    equ    %00000100
mCAN0TXIDR3_ID2:    equ    %00001000
mCAN0TXIDR3_ID3:    equ    %00010000
mCAN0TXIDR3_ID4:    equ    %00100000
mCAN0TXIDR3_ID5:    equ    %01000000
mCAN0TXIDR3_ID6:    equ    %10000000


;*** CAN0TXDSR0 - MSCAN 0 Transmit Data Segment Register 0; 0x00000174 ***
CAN0TXDSR0:         equ    $00000174                                ;*** CAN0TXDSR0 - MSCAN 0 Transmit Data Segment Register 0; 0x00000174 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0TXDSR0_DB0:     equ    0                                         ; Data Bit 0
CAN0TXDSR0_DB1:     equ    1                                         ; Data Bit 1
CAN0TXDSR0_DB2:     equ    2                                         ; Data Bit 2
CAN0TXDSR0_DB3:     equ    3                                         ; Data Bit 3
CAN0TXDSR0_DB4:     equ    4                                         ; Data Bit 4
CAN0TXDSR0_DB5:     equ    5                                         ; Data Bit 5
CAN0TXDSR0_DB6:     equ    6                                         ; Data Bit 6
CAN0TXDSR0_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN0TXDSR0_DB0:    equ    %00000001
mCAN0TXDSR0_DB1:    equ    %00000010
mCAN0TXDSR0_DB2:    equ    %00000100
mCAN0TXDSR0_DB3:    equ    %00001000
mCAN0TXDSR0_DB4:    equ    %00010000
mCAN0TXDSR0_DB5:    equ    %00100000
mCAN0TXDSR0_DB6:    equ    %01000000
mCAN0TXDSR0_DB7:    equ    %10000000


;*** CAN0TXDSR1 - MSCAN 0 Transmit Data Segment Register 1; 0x00000175 ***
CAN0TXDSR1:         equ    $00000175                                ;*** CAN0TXDSR1 - MSCAN 0 Transmit Data Segment Register 1; 0x00000175 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0TXDSR1_DB0:     equ    0                                         ; Data Bit 0
CAN0TXDSR1_DB1:     equ    1                                         ; Data Bit 1
CAN0TXDSR1_DB2:     equ    2                                         ; Data Bit 2
CAN0TXDSR1_DB3:     equ    3                                         ; Data Bit 3
CAN0TXDSR1_DB4:     equ    4                                         ; Data Bit 4
CAN0TXDSR1_DB5:     equ    5                                         ; Data Bit 5
CAN0TXDSR1_DB6:     equ    6                                         ; Data Bit 6
CAN0TXDSR1_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN0TXDSR1_DB0:    equ    %00000001
mCAN0TXDSR1_DB1:    equ    %00000010
mCAN0TXDSR1_DB2:    equ    %00000100
mCAN0TXDSR1_DB3:    equ    %00001000
mCAN0TXDSR1_DB4:    equ    %00010000
mCAN0TXDSR1_DB5:    equ    %00100000
mCAN0TXDSR1_DB6:    equ    %01000000
mCAN0TXDSR1_DB7:    equ    %10000000


;*** CAN0TXDSR2 - MSCAN 0 Transmit Data Segment Register 2; 0x00000176 ***
CAN0TXDSR2:         equ    $00000176                                ;*** CAN0TXDSR2 - MSCAN 0 Transmit Data Segment Register 2; 0x00000176 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0TXDSR2_DB0:     equ    0                                         ; Data Bit 0
CAN0TXDSR2_DB1:     equ    1                                         ; Data Bit 1
CAN0TXDSR2_DB2:     equ    2                                         ; Data Bit 2
CAN0TXDSR2_DB3:     equ    3                                         ; Data Bit 3
CAN0TXDSR2_DB4:     equ    4                                         ; Data Bit 4
CAN0TXDSR2_DB5:     equ    5                                         ; Data Bit 5
CAN0TXDSR2_DB6:     equ    6                                         ; Data Bit 6
CAN0TXDSR2_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN0TXDSR2_DB0:    equ    %00000001
mCAN0TXDSR2_DB1:    equ    %00000010
mCAN0TXDSR2_DB2:    equ    %00000100
mCAN0TXDSR2_DB3:    equ    %00001000
mCAN0TXDSR2_DB4:    equ    %00010000
mCAN0TXDSR2_DB5:    equ    %00100000
mCAN0TXDSR2_DB6:    equ    %01000000
mCAN0TXDSR2_DB7:    equ    %10000000


;*** CAN0TXDSR3 - MSCAN 0 Transmit Data Segment Register 3; 0x00000177 ***
CAN0TXDSR3:         equ    $00000177                                ;*** CAN0TXDSR3 - MSCAN 0 Transmit Data Segment Register 3; 0x00000177 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0TXDSR3_DB0:     equ    0                                         ; Data Bit 0
CAN0TXDSR3_DB1:     equ    1                                         ; Data Bit 1
CAN0TXDSR3_DB2:     equ    2                                         ; Data Bit 2
CAN0TXDSR3_DB3:     equ    3                                         ; Data Bit 3
CAN0TXDSR3_DB4:     equ    4                                         ; Data Bit 4
CAN0TXDSR3_DB5:     equ    5                                         ; Data Bit 5
CAN0TXDSR3_DB6:     equ    6                                         ; Data Bit 6
CAN0TXDSR3_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN0TXDSR3_DB0:    equ    %00000001
mCAN0TXDSR3_DB1:    equ    %00000010
mCAN0TXDSR3_DB2:    equ    %00000100
mCAN0TXDSR3_DB3:    equ    %00001000
mCAN0TXDSR3_DB4:    equ    %00010000
mCAN0TXDSR3_DB5:    equ    %00100000
mCAN0TXDSR3_DB6:    equ    %01000000
mCAN0TXDSR3_DB7:    equ    %10000000


;*** CAN0TXDSR4 - MSCAN 0 Transmit Data Segment Register 4; 0x00000178 ***
CAN0TXDSR4:         equ    $00000178                                ;*** CAN0TXDSR4 - MSCAN 0 Transmit Data Segment Register 4; 0x00000178 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0TXDSR4_DB0:     equ    0                                         ; Data Bit 0
CAN0TXDSR4_DB1:     equ    1                                         ; Data Bit 1
CAN0TXDSR4_DB2:     equ    2                                         ; Data Bit 2
CAN0TXDSR4_DB3:     equ    3                                         ; Data Bit 3
CAN0TXDSR4_DB4:     equ    4                                         ; Data Bit 4
CAN0TXDSR4_DB5:     equ    5                                         ; Data Bit 5
CAN0TXDSR4_DB6:     equ    6                                         ; Data Bit 6
CAN0TXDSR4_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN0TXDSR4_DB0:    equ    %00000001
mCAN0TXDSR4_DB1:    equ    %00000010
mCAN0TXDSR4_DB2:    equ    %00000100
mCAN0TXDSR4_DB3:    equ    %00001000
mCAN0TXDSR4_DB4:    equ    %00010000
mCAN0TXDSR4_DB5:    equ    %00100000
mCAN0TXDSR4_DB6:    equ    %01000000
mCAN0TXDSR4_DB7:    equ    %10000000


;*** CAN0TXDSR5 - MSCAN 0 Transmit Data Segment Register 5; 0x00000179 ***
CAN0TXDSR5:         equ    $00000179                                ;*** CAN0TXDSR5 - MSCAN 0 Transmit Data Segment Register 5; 0x00000179 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0TXDSR5_DB0:     equ    0                                         ; Data Bit 0
CAN0TXDSR5_DB1:     equ    1                                         ; Data Bit 1
CAN0TXDSR5_DB2:     equ    2                                         ; Data Bit 2
CAN0TXDSR5_DB3:     equ    3                                         ; Data Bit 3
CAN0TXDSR5_DB4:     equ    4                                         ; Data Bit 4
CAN0TXDSR5_DB5:     equ    5                                         ; Data Bit 5
CAN0TXDSR5_DB6:     equ    6                                         ; Data Bit 6
CAN0TXDSR5_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN0TXDSR5_DB0:    equ    %00000001
mCAN0TXDSR5_DB1:    equ    %00000010
mCAN0TXDSR5_DB2:    equ    %00000100
mCAN0TXDSR5_DB3:    equ    %00001000
mCAN0TXDSR5_DB4:    equ    %00010000
mCAN0TXDSR5_DB5:    equ    %00100000
mCAN0TXDSR5_DB6:    equ    %01000000
mCAN0TXDSR5_DB7:    equ    %10000000


;*** CAN0TXDSR6 - MSCAN 0 Transmit Data Segment Register 6; 0x0000017A ***
CAN0TXDSR6:         equ    $0000017A                                ;*** CAN0TXDSR6 - MSCAN 0 Transmit Data Segment Register 6; 0x0000017A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0TXDSR6_DB0:     equ    0                                         ; Data Bit 0
CAN0TXDSR6_DB1:     equ    1                                         ; Data Bit 1
CAN0TXDSR6_DB2:     equ    2                                         ; Data Bit 2
CAN0TXDSR6_DB3:     equ    3                                         ; Data Bit 3
CAN0TXDSR6_DB4:     equ    4                                         ; Data Bit 4
CAN0TXDSR6_DB5:     equ    5                                         ; Data Bit 5
CAN0TXDSR6_DB6:     equ    6                                         ; Data Bit 6
CAN0TXDSR6_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN0TXDSR6_DB0:    equ    %00000001
mCAN0TXDSR6_DB1:    equ    %00000010
mCAN0TXDSR6_DB2:    equ    %00000100
mCAN0TXDSR6_DB3:    equ    %00001000
mCAN0TXDSR6_DB4:    equ    %00010000
mCAN0TXDSR6_DB5:    equ    %00100000
mCAN0TXDSR6_DB6:    equ    %01000000
mCAN0TXDSR6_DB7:    equ    %10000000


;*** CAN0TXDSR7 - MSCAN 0 Transmit Data Segment Register 7; 0x0000017B ***
CAN0TXDSR7:         equ    $0000017B                                ;*** CAN0TXDSR7 - MSCAN 0 Transmit Data Segment Register 7; 0x0000017B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0TXDSR7_DB0:     equ    0                                         ; Data Bit 0
CAN0TXDSR7_DB1:     equ    1                                         ; Data Bit 1
CAN0TXDSR7_DB2:     equ    2                                         ; Data Bit 2
CAN0TXDSR7_DB3:     equ    3                                         ; Data Bit 3
CAN0TXDSR7_DB4:     equ    4                                         ; Data Bit 4
CAN0TXDSR7_DB5:     equ    5                                         ; Data Bit 5
CAN0TXDSR7_DB6:     equ    6                                         ; Data Bit 6
CAN0TXDSR7_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN0TXDSR7_DB0:    equ    %00000001
mCAN0TXDSR7_DB1:    equ    %00000010
mCAN0TXDSR7_DB2:    equ    %00000100
mCAN0TXDSR7_DB3:    equ    %00001000
mCAN0TXDSR7_DB4:    equ    %00010000
mCAN0TXDSR7_DB5:    equ    %00100000
mCAN0TXDSR7_DB6:    equ    %01000000
mCAN0TXDSR7_DB7:    equ    %10000000


;*** CAN0TXDLR - MSCAN 0 Transmit Data Length Register; 0x0000017C ***
CAN0TXDLR:          equ    $0000017C                                ;*** CAN0TXDLR - MSCAN 0 Transmit Data Length Register; 0x0000017C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0TXDLR_DLC0:     equ    0                                         ; Data Length Code Bit 0
CAN0TXDLR_DLC1:     equ    1                                         ; Data Length Code Bit 1
CAN0TXDLR_DLC2:     equ    2                                         ; Data Length Code Bit 2
CAN0TXDLR_DLC3:     equ    3                                         ; Data Length Code Bit 3
; bit position masks
mCAN0TXDLR_DLC0:    equ    %00000001
mCAN0TXDLR_DLC1:    equ    %00000010
mCAN0TXDLR_DLC2:    equ    %00000100
mCAN0TXDLR_DLC3:    equ    %00001000


;*** CAN0TXTBPR - MSCAN 0 Transmit Buffer Priority; 0x0000017D ***
CAN0TXTBPR:         equ    $0000017D                                ;*** CAN0TXTBPR - MSCAN 0 Transmit Buffer Priority; 0x0000017D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0TXTBPR_PRIO0:   equ    0                                         ; Transmit Buffer Priority Bit 0
CAN0TXTBPR_PRIO1:   equ    1                                         ; Transmit Buffer Priority Bit 1
CAN0TXTBPR_PRIO2:   equ    2                                         ; Transmit Buffer Priority Bit 2
CAN0TXTBPR_PRIO3:   equ    3                                         ; Transmit Buffer Priority Bit 3
CAN0TXTBPR_PRIO4:   equ    4                                         ; Transmit Buffer Priority Bit 4
CAN0TXTBPR_PRIO5:   equ    5                                         ; Transmit Buffer Priority Bit 5
CAN0TXTBPR_PRIO6:   equ    6                                         ; Transmit Buffer Priority Bit 6
CAN0TXTBPR_PRIO7:   equ    7                                         ; Transmit Buffer Priority Bit 7
; bit position masks
mCAN0TXTBPR_PRIO0:  equ    %00000001
mCAN0TXTBPR_PRIO1:  equ    %00000010
mCAN0TXTBPR_PRIO2:  equ    %00000100
mCAN0TXTBPR_PRIO3:  equ    %00001000
mCAN0TXTBPR_PRIO4:  equ    %00010000
mCAN0TXTBPR_PRIO5:  equ    %00100000
mCAN0TXTBPR_PRIO6:  equ    %01000000
mCAN0TXTBPR_PRIO7:  equ    %10000000


;*** CAN0TXTSR - MSCAN 0 Transmit Time Stamp Register; 0x0000017E ***
CAN0TXTSR:          equ    $0000017E                                ;*** CAN0TXTSR - MSCAN 0 Transmit Time Stamp Register; 0x0000017E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0TXTSR_TSR0:     equ    0                                         ; Time Stamp Bit 0
CAN0TXTSR_TSR1:     equ    1                                         ; Time Stamp Bit 1
CAN0TXTSR_TSR2:     equ    2                                         ; Time Stamp Bit 2
CAN0TXTSR_TSR3:     equ    3                                         ; Time Stamp Bit 3
CAN0TXTSR_TSR4:     equ    4                                         ; Time Stamp Bit 4
CAN0TXTSR_TSR5:     equ    5                                         ; Time Stamp Bit 5
CAN0TXTSR_TSR6:     equ    6                                         ; Time Stamp Bit 6
CAN0TXTSR_TSR7:     equ    7                                         ; Time Stamp Bit 7
CAN0TXTSR_TSR8:     equ    8                                         ; Time Stamp Bit 8
CAN0TXTSR_TSR9:     equ    9                                         ; Time Stamp Bit 9
CAN0TXTSR_TSR10:    equ    10                                        ; Time Stamp Bit 10
CAN0TXTSR_TSR11:    equ    11                                        ; Time Stamp Bit 11
CAN0TXTSR_TSR12:    equ    12                                        ; Time Stamp Bit 12
CAN0TXTSR_TSR13:    equ    13                                        ; Time Stamp Bit 13
CAN0TXTSR_TSR14:    equ    14                                        ; Time Stamp Bit 14
CAN0TXTSR_TSR15:    equ    15                                        ; Time Stamp Bit 15
; bit position masks
mCAN0TXTSR_TSR0:    equ    %00000001
mCAN0TXTSR_TSR1:    equ    %00000010
mCAN0TXTSR_TSR2:    equ    %00000100
mCAN0TXTSR_TSR3:    equ    %00001000
mCAN0TXTSR_TSR4:    equ    %00010000
mCAN0TXTSR_TSR5:    equ    %00100000
mCAN0TXTSR_TSR6:    equ    %01000000
mCAN0TXTSR_TSR7:    equ    %10000000
mCAN0TXTSR_TSR8:    equ    %100000000
mCAN0TXTSR_TSR9:    equ    %1000000000
mCAN0TXTSR_TSR10:   equ    %10000000000
mCAN0TXTSR_TSR11:   equ    %100000000000
mCAN0TXTSR_TSR12:   equ    %1000000000000
mCAN0TXTSR_TSR13:   equ    %10000000000000
mCAN0TXTSR_TSR14:   equ    %100000000000000
mCAN0TXTSR_TSR15:   equ    %1000000000000000


;*** CAN0TXTSRH - MSCAN 0 Transmit Time Stamp Register High; 0x0000017E ***
CAN0TXTSRH:         equ    $0000017E                                ;*** CAN0TXTSRH - MSCAN 0 Transmit Time Stamp Register High; 0x0000017E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0TXTSRH_TSR8:    equ    0                                         ; Time Stamp Bit 8
CAN0TXTSRH_TSR9:    equ    1                                         ; Time Stamp Bit 9
CAN0TXTSRH_TSR10:   equ    2                                         ; Time Stamp Bit 10
CAN0TXTSRH_TSR11:   equ    3                                         ; Time Stamp Bit 11
CAN0TXTSRH_TSR12:   equ    4                                         ; Time Stamp Bit 12
CAN0TXTSRH_TSR13:   equ    5                                         ; Time Stamp Bit 13
CAN0TXTSRH_TSR14:   equ    6                                         ; Time Stamp Bit 14
CAN0TXTSRH_TSR15:   equ    7                                         ; Time Stamp Bit 15
; bit position masks
mCAN0TXTSRH_TSR8:   equ    %00000001
mCAN0TXTSRH_TSR9:   equ    %00000010
mCAN0TXTSRH_TSR10:  equ    %00000100
mCAN0TXTSRH_TSR11:  equ    %00001000
mCAN0TXTSRH_TSR12:  equ    %00010000
mCAN0TXTSRH_TSR13:  equ    %00100000
mCAN0TXTSRH_TSR14:  equ    %01000000
mCAN0TXTSRH_TSR15:  equ    %10000000


;*** CAN0TXTSRL - MSCAN 0 Transmit Time Stamp Register Low; 0x0000017F ***
CAN0TXTSRL:         equ    $0000017F                                ;*** CAN0TXTSRL - MSCAN 0 Transmit Time Stamp Register Low; 0x0000017F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0TXTSRL_TSR0:    equ    0                                         ; Time Stamp Bit 0
CAN0TXTSRL_TSR1:    equ    1                                         ; Time Stamp Bit 1
CAN0TXTSRL_TSR2:    equ    2                                         ; Time Stamp Bit 2
CAN0TXTSRL_TSR3:    equ    3                                         ; Time Stamp Bit 3
CAN0TXTSRL_TSR4:    equ    4                                         ; Time Stamp Bit 4
CAN0TXTSRL_TSR5:    equ    5                                         ; Time Stamp Bit 5
CAN0TXTSRL_TSR6:    equ    6                                         ; Time Stamp Bit 6
CAN0TXTSRL_TSR7:    equ    7                                         ; Time Stamp Bit 7
; bit position masks
mCAN0TXTSRL_TSR0:   equ    %00000001
mCAN0TXTSRL_TSR1:   equ    %00000010
mCAN0TXTSRL_TSR2:   equ    %00000100
mCAN0TXTSRL_TSR3:   equ    %00001000
mCAN0TXTSRL_TSR4:   equ    %00010000
mCAN0TXTSRL_TSR5:   equ    %00100000
mCAN0TXTSRL_TSR6:   equ    %01000000
mCAN0TXTSRL_TSR7:   equ    %10000000


;*** CAN1CTL0 - MSCAN 1 Control 0 Register; 0x00000180 ***
CAN1CTL0:           equ    $00000180                                ;*** CAN1CTL0 - MSCAN 1 Control 0 Register; 0x00000180 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1CTL0_INITRQ:    equ    0                                         ; Initialization Mode Request
CAN1CTL0_SLPRQ:     equ    1                                         ; Sleep Mode Request
CAN1CTL0_WUPE:      equ    2                                         ; Wake-Up Enable
CAN1CTL0_TIME:      equ    3                                         ; Timer Enable
CAN1CTL0_SYNCH:     equ    4                                         ; Synchronized Status
CAN1CTL0_CSWAI:     equ    5                                         ; CAN Stops in Wait Mode
CAN1CTL0_RXACT:     equ    6                                         ; Receiver Active Status
CAN1CTL0_RXFRM:     equ    7                                         ; Received Frame Flag
; bit position masks
mCAN1CTL0_INITRQ:   equ    %00000001
mCAN1CTL0_SLPRQ:    equ    %00000010
mCAN1CTL0_WUPE:     equ    %00000100
mCAN1CTL0_TIME:     equ    %00001000
mCAN1CTL0_SYNCH:    equ    %00010000
mCAN1CTL0_CSWAI:    equ    %00100000
mCAN1CTL0_RXACT:    equ    %01000000
mCAN1CTL0_RXFRM:    equ    %10000000


;*** CAN1CTL1 - MSCAN 1 Control 1 Register; 0x00000181 ***
CAN1CTL1:           equ    $00000181                                ;*** CAN1CTL1 - MSCAN 1 Control 1 Register; 0x00000181 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1CTL1_INITAK:    equ    0                                         ; Initialization Mode Acknowledge
CAN1CTL1_SLPAK:     equ    1                                         ; Sleep Mode Acknowledge
CAN1CTL1_WUPM:      equ    2                                         ; Wake-Up Mode
CAN1CTL1_LISTEN:    equ    4                                         ; Listen Only Mode
CAN1CTL1_LOOPB:     equ    5                                         ; Loop Back Self Test Mode
CAN1CTL1_CLKSRC:    equ    6                                         ; MSCAN 1 Clock Source
CAN1CTL1_CANE:      equ    7                                         ; MSCAN 1 Enable
; bit position masks
mCAN1CTL1_INITAK:   equ    %00000001
mCAN1CTL1_SLPAK:    equ    %00000010
mCAN1CTL1_WUPM:     equ    %00000100
mCAN1CTL1_LISTEN:   equ    %00010000
mCAN1CTL1_LOOPB:    equ    %00100000
mCAN1CTL1_CLKSRC:   equ    %01000000
mCAN1CTL1_CANE:     equ    %10000000


;*** CAN1BTR0 - MSCAN 1 Bus Timing Register 0; 0x00000182 ***
CAN1BTR0:           equ    $00000182                                ;*** CAN1BTR0 - MSCAN 1 Bus Timing Register 0; 0x00000182 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1BTR0_BRP0:      equ    0                                         ; Baud Rate Prescaler 0
CAN1BTR0_BRP1:      equ    1                                         ; Baud Rate Prescaler 1
CAN1BTR0_BRP2:      equ    2                                         ; Baud Rate Prescaler 2
CAN1BTR0_BRP3:      equ    3                                         ; Baud Rate Prescaler 3
CAN1BTR0_BRP4:      equ    4                                         ; Baud Rate Prescaler 4
CAN1BTR0_BRP5:      equ    5                                         ; Baud Rate Prescaler 5
CAN1BTR0_SJW0:      equ    6                                         ; Synchronization Jump Width 0
CAN1BTR0_SJW1:      equ    7                                         ; Synchronization Jump Width 1
; bit position masks
mCAN1BTR0_BRP0:     equ    %00000001
mCAN1BTR0_BRP1:     equ    %00000010
mCAN1BTR0_BRP2:     equ    %00000100
mCAN1BTR0_BRP3:     equ    %00001000
mCAN1BTR0_BRP4:     equ    %00010000
mCAN1BTR0_BRP5:     equ    %00100000
mCAN1BTR0_SJW0:     equ    %01000000
mCAN1BTR0_SJW1:     equ    %10000000


;*** CAN1BTR1 - MSCAN 1 Bus Timing Register 1; 0x00000183 ***
CAN1BTR1:           equ    $00000183                                ;*** CAN1BTR1 - MSCAN 1 Bus Timing Register 1; 0x00000183 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1BTR1_TSEG10:    equ    0                                         ; Time Segment 10
CAN1BTR1_TSEG11:    equ    1                                         ; Time Segment 11
CAN1BTR1_TSEG12:    equ    2                                         ; Time Segment 12
CAN1BTR1_TSEG13:    equ    3                                         ; Time Segment 13
CAN1BTR1_TSEG20:    equ    4                                         ; Time Segment 20
CAN1BTR1_TSEG21:    equ    5                                         ; Time Segment 21
CAN1BTR1_TSEG22:    equ    6                                         ; Time Segment 22
CAN1BTR1_SAMP:      equ    7                                         ; Sampling
; bit position masks
mCAN1BTR1_TSEG10:   equ    %00000001
mCAN1BTR1_TSEG11:   equ    %00000010
mCAN1BTR1_TSEG12:   equ    %00000100
mCAN1BTR1_TSEG13:   equ    %00001000
mCAN1BTR1_TSEG20:   equ    %00010000
mCAN1BTR1_TSEG21:   equ    %00100000
mCAN1BTR1_TSEG22:   equ    %01000000
mCAN1BTR1_SAMP:     equ    %10000000


;*** CAN1RFLG - MSCAN 1 Receiver Flag Register; 0x00000184 ***
CAN1RFLG:           equ    $00000184                                ;*** CAN1RFLG - MSCAN 1 Receiver Flag Register; 0x00000184 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1RFLG_RXF:       equ    0                                         ; Receive Buffer Full
CAN1RFLG_OVRIF:     equ    1                                         ; Overrun Interrupt Flag
CAN1RFLG_TSTAT0:    equ    2                                         ; Transmitter Status Bit 0
CAN1RFLG_TSTAT1:    equ    3                                         ; Transmitter Status Bit 1
CAN1RFLG_RSTAT0:    equ    4                                         ; Receiver Status Bit 0
CAN1RFLG_RSTAT1:    equ    5                                         ; Receiver Status Bit 1
CAN1RFLG_CSCIF:     equ    6                                         ; CAN Status Change Interrupt Flag
CAN1RFLG_WUPIF:     equ    7                                         ; Wake-up Interrupt Flag
; bit position masks
mCAN1RFLG_RXF:      equ    %00000001
mCAN1RFLG_OVRIF:    equ    %00000010
mCAN1RFLG_TSTAT0:   equ    %00000100
mCAN1RFLG_TSTAT1:   equ    %00001000
mCAN1RFLG_RSTAT0:   equ    %00010000
mCAN1RFLG_RSTAT1:   equ    %00100000
mCAN1RFLG_CSCIF:    equ    %01000000
mCAN1RFLG_WUPIF:    equ    %10000000


;*** CAN1RIER - MSCAN 1 Receiver Interrupt Enable Register; 0x00000185 ***
CAN1RIER:           equ    $00000185                                ;*** CAN1RIER - MSCAN 1 Receiver Interrupt Enable Register; 0x00000185 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1RIER_RXFIE:     equ    0                                         ; Receiver Full Interrupt Enable
CAN1RIER_OVRIE:     equ    1                                         ; Overrun Interrupt Enable
CAN1RIER_TSTATE0:   equ    2                                         ; Transmitter Status Change Enable 0
CAN1RIER_TSTATE1:   equ    3                                         ; Transmitter Status Change Enable 1
CAN1RIER_RSTATE0:   equ    4                                         ; Receiver Status Change Enable 0
CAN1RIER_RSTATE1:   equ    5                                         ; Receiver Status Change Enable 1
CAN1RIER_CSCIE:     equ    6                                         ; CAN Status Change Interrupt Enable
CAN1RIER_WUPIE:     equ    7                                         ; Wake-up Interrupt Enable
; bit position masks
mCAN1RIER_RXFIE:    equ    %00000001
mCAN1RIER_OVRIE:    equ    %00000010
mCAN1RIER_TSTATE0:  equ    %00000100
mCAN1RIER_TSTATE1:  equ    %00001000
mCAN1RIER_RSTATE0:  equ    %00010000
mCAN1RIER_RSTATE1:  equ    %00100000
mCAN1RIER_CSCIE:    equ    %01000000
mCAN1RIER_WUPIE:    equ    %10000000


;*** CAN1TFLG - MSCAN 1 Transmitter Flag Register; 0x00000186 ***
CAN1TFLG:           equ    $00000186                                ;*** CAN1TFLG - MSCAN 1 Transmitter Flag Register; 0x00000186 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1TFLG_TXE0:      equ    0                                         ; Transmitter Buffer Empty 0
CAN1TFLG_TXE1:      equ    1                                         ; Transmitter Buffer Empty 1
CAN1TFLG_TXE2:      equ    2                                         ; Transmitter Buffer Empty 2
; bit position masks
mCAN1TFLG_TXE0:     equ    %00000001
mCAN1TFLG_TXE1:     equ    %00000010
mCAN1TFLG_TXE2:     equ    %00000100


;*** CAN1TIER - MSCAN 1 Transmitter Interrupt Enable Register; 0x00000187 ***
CAN1TIER:           equ    $00000187                                ;*** CAN1TIER - MSCAN 1 Transmitter Interrupt Enable Register; 0x00000187 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1TIER_TXEIE0:    equ    0                                         ; Transmitter Empty Interrupt Enable 0
CAN1TIER_TXEIE1:    equ    1                                         ; Transmitter Empty Interrupt Enable 1
CAN1TIER_TXEIE2:    equ    2                                         ; Transmitter Empty Interrupt Enable 2
; bit position masks
mCAN1TIER_TXEIE0:   equ    %00000001
mCAN1TIER_TXEIE1:   equ    %00000010
mCAN1TIER_TXEIE2:   equ    %00000100


;*** CAN1TARQ - MSCAN 1 Transmitter Message Abort Request; 0x00000188 ***
CAN1TARQ:           equ    $00000188                                ;*** CAN1TARQ - MSCAN 1 Transmitter Message Abort Request; 0x00000188 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1TARQ_ABTRQ0:    equ    0                                         ; Abort Request 0
CAN1TARQ_ABTRQ1:    equ    1                                         ; Abort Request 1
CAN1TARQ_ABTRQ2:    equ    2                                         ; Abort Request 2
; bit position masks
mCAN1TARQ_ABTRQ0:   equ    %00000001
mCAN1TARQ_ABTRQ1:   equ    %00000010
mCAN1TARQ_ABTRQ2:   equ    %00000100


;*** CAN1TAAK - MSCAN 1 Transmitter Message Abort Control; 0x00000189 ***
CAN1TAAK:           equ    $00000189                                ;*** CAN1TAAK - MSCAN 1 Transmitter Message Abort Control; 0x00000189 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1TAAK_ABTAK0:    equ    0                                         ; Abort Acknowledge 0
CAN1TAAK_ABTAK1:    equ    1                                         ; Abort Acknowledge 1
CAN1TAAK_ABTAK2:    equ    2                                         ; Abort Acknowledge 2
; bit position masks
mCAN1TAAK_ABTAK0:   equ    %00000001
mCAN1TAAK_ABTAK1:   equ    %00000010
mCAN1TAAK_ABTAK2:   equ    %00000100


;*** CAN1TBSEL - MSCAN 1 Transmit Buffer Selection; 0x0000018A ***
CAN1TBSEL:          equ    $0000018A                                ;*** CAN1TBSEL - MSCAN 1 Transmit Buffer Selection; 0x0000018A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1TBSEL_TX0:      equ    0                                         ; Transmit Buffer Select 0
CAN1TBSEL_TX1:      equ    1                                         ; Transmit Buffer Select 1
CAN1TBSEL_TX2:      equ    2                                         ; Transmit Buffer Select 2
; bit position masks
mCAN1TBSEL_TX0:     equ    %00000001
mCAN1TBSEL_TX1:     equ    %00000010
mCAN1TBSEL_TX2:     equ    %00000100


;*** CAN1IDAC - MSCAN 1 Identifier Acceptance Control Register; 0x0000018B ***
CAN1IDAC:           equ    $0000018B                                ;*** CAN1IDAC - MSCAN 1 Identifier Acceptance Control Register; 0x0000018B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1IDAC_IDHIT0:    equ    0                                         ; Identifier Acceptance Hit Indicator 0
CAN1IDAC_IDHIT1:    equ    1                                         ; Identifier Acceptance Hit Indicator 1
CAN1IDAC_IDHIT2:    equ    2                                         ; Identifier Acceptance Hit Indicator 2
CAN1IDAC_IDAM0:     equ    4                                         ; Identifier Acceptance Mode 0
CAN1IDAC_IDAM1:     equ    5                                         ; Identifier Acceptance Mode 1
; bit position masks
mCAN1IDAC_IDHIT0:   equ    %00000001
mCAN1IDAC_IDHIT1:   equ    %00000010
mCAN1IDAC_IDHIT2:   equ    %00000100
mCAN1IDAC_IDAM0:    equ    %00010000
mCAN1IDAC_IDAM1:    equ    %00100000


;*** CAN1RXERR - MSCAN 1 Receive Error Counter Register; 0x0000018E ***
CAN1RXERR:          equ    $0000018E                                ;*** CAN1RXERR - MSCAN 1 Receive Error Counter Register; 0x0000018E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1RXERR_RXERR0:   equ    0                                         ; Bit 0
CAN1RXERR_RXERR1:   equ    1                                         ; Bit 1
CAN1RXERR_RXERR2:   equ    2                                         ; Bit 2
CAN1RXERR_RXERR3:   equ    3                                         ; Bit 3
CAN1RXERR_RXERR4:   equ    4                                         ; Bit 4
CAN1RXERR_RXERR5:   equ    5                                         ; Bit 5
CAN1RXERR_RXERR6:   equ    6                                         ; Bit 6
CAN1RXERR_RXERR7:   equ    7                                         ; Bit 7
; bit position masks
mCAN1RXERR_RXERR0:  equ    %00000001
mCAN1RXERR_RXERR1:  equ    %00000010
mCAN1RXERR_RXERR2:  equ    %00000100
mCAN1RXERR_RXERR3:  equ    %00001000
mCAN1RXERR_RXERR4:  equ    %00010000
mCAN1RXERR_RXERR5:  equ    %00100000
mCAN1RXERR_RXERR6:  equ    %01000000
mCAN1RXERR_RXERR7:  equ    %10000000


;*** CAN1TXERR - MSCAN 1 Transmit Error Counter Register; 0x0000018F ***
CAN1TXERR:          equ    $0000018F                                ;*** CAN1TXERR - MSCAN 1 Transmit Error Counter Register; 0x0000018F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1TXERR_TXERR0:   equ    0                                         ; Bit 0
CAN1TXERR_TXERR1:   equ    1                                         ; Bit 1
CAN1TXERR_TXERR2:   equ    2                                         ; Bit 2
CAN1TXERR_TXERR3:   equ    3                                         ; Bit 3
CAN1TXERR_TXERR4:   equ    4                                         ; Bit 4
CAN1TXERR_TXERR5:   equ    5                                         ; Bit 5
CAN1TXERR_TXERR6:   equ    6                                         ; Bit 6
CAN1TXERR_TXERR7:   equ    7                                         ; Bit 7
; bit position masks
mCAN1TXERR_TXERR0:  equ    %00000001
mCAN1TXERR_TXERR1:  equ    %00000010
mCAN1TXERR_TXERR2:  equ    %00000100
mCAN1TXERR_TXERR3:  equ    %00001000
mCAN1TXERR_TXERR4:  equ    %00010000
mCAN1TXERR_TXERR5:  equ    %00100000
mCAN1TXERR_TXERR6:  equ    %01000000
mCAN1TXERR_TXERR7:  equ    %10000000


;*** CAN1IDAR0 - MSCAN 1 Identifier Acceptance Register 0; 0x00000190 ***
CAN1IDAR0:          equ    $00000190                                ;*** CAN1IDAR0 - MSCAN 1 Identifier Acceptance Register 0; 0x00000190 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1IDAR0_AC0:      equ    0                                         ; Acceptance Code Bit 0
CAN1IDAR0_AC1:      equ    1                                         ; Acceptance Code Bit 1
CAN1IDAR0_AC2:      equ    2                                         ; Acceptance Code Bit 2
CAN1IDAR0_AC3:      equ    3                                         ; Acceptance Code Bit 3
CAN1IDAR0_AC4:      equ    4                                         ; Acceptance Code Bit 4
CAN1IDAR0_AC5:      equ    5                                         ; Acceptance Code Bit 5
CAN1IDAR0_AC6:      equ    6                                         ; Acceptance Code Bit 6
CAN1IDAR0_AC7:      equ    7                                         ; Acceptance Code Bit 7
; bit position masks
mCAN1IDAR0_AC0:     equ    %00000001
mCAN1IDAR0_AC1:     equ    %00000010
mCAN1IDAR0_AC2:     equ    %00000100
mCAN1IDAR0_AC3:     equ    %00001000
mCAN1IDAR0_AC4:     equ    %00010000
mCAN1IDAR0_AC5:     equ    %00100000
mCAN1IDAR0_AC6:     equ    %01000000
mCAN1IDAR0_AC7:     equ    %10000000


;*** CAN1IDAR1 - MSCAN 1 Identifier Acceptance Register 1; 0x00000191 ***
CAN1IDAR1:          equ    $00000191                                ;*** CAN1IDAR1 - MSCAN 1 Identifier Acceptance Register 1; 0x00000191 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1IDAR1_AC0:      equ    0                                         ; Acceptance Code Bit 0
CAN1IDAR1_AC1:      equ    1                                         ; Acceptance Code Bit 1
CAN1IDAR1_AC2:      equ    2                                         ; Acceptance Code Bit 2
CAN1IDAR1_AC3:      equ    3                                         ; Acceptance Code Bit 3
CAN1IDAR1_AC4:      equ    4                                         ; Acceptance Code Bit 4
CAN1IDAR1_AC5:      equ    5                                         ; Acceptance Code Bit 5
CAN1IDAR1_AC6:      equ    6                                         ; Acceptance Code Bit 6
CAN1IDAR1_AC7:      equ    7                                         ; Acceptance Code Bit 7
; bit position masks
mCAN1IDAR1_AC0:     equ    %00000001
mCAN1IDAR1_AC1:     equ    %00000010
mCAN1IDAR1_AC2:     equ    %00000100
mCAN1IDAR1_AC3:     equ    %00001000
mCAN1IDAR1_AC4:     equ    %00010000
mCAN1IDAR1_AC5:     equ    %00100000
mCAN1IDAR1_AC6:     equ    %01000000
mCAN1IDAR1_AC7:     equ    %10000000


;*** CAN1IDAR2 - MSCAN 1 Identifier Acceptance Register 2; 0x00000192 ***
CAN1IDAR2:          equ    $00000192                                ;*** CAN1IDAR2 - MSCAN 1 Identifier Acceptance Register 2; 0x00000192 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1IDAR2_AC0:      equ    0                                         ; Acceptance Code Bit 0
CAN1IDAR2_AC1:      equ    1                                         ; Acceptance Code Bit 1
CAN1IDAR2_AC2:      equ    2                                         ; Acceptance Code Bit 2
CAN1IDAR2_AC3:      equ    3                                         ; Acceptance Code Bit 3
CAN1IDAR2_AC4:      equ    4                                         ; Acceptance Code Bit 4
CAN1IDAR2_AC5:      equ    5                                         ; Acceptance Code Bit 5
CAN1IDAR2_AC6:      equ    6                                         ; Acceptance Code Bit 6
CAN1IDAR2_AC7:      equ    7                                         ; Acceptance Code Bit 7
; bit position masks
mCAN1IDAR2_AC0:     equ    %00000001
mCAN1IDAR2_AC1:     equ    %00000010
mCAN1IDAR2_AC2:     equ    %00000100
mCAN1IDAR2_AC3:     equ    %00001000
mCAN1IDAR2_AC4:     equ    %00010000
mCAN1IDAR2_AC5:     equ    %00100000
mCAN1IDAR2_AC6:     equ    %01000000
mCAN1IDAR2_AC7:     equ    %10000000


;*** CAN1IDAR3 - MSCAN 1 Identifier Acceptance Register 3; 0x00000193 ***
CAN1IDAR3:          equ    $00000193                                ;*** CAN1IDAR3 - MSCAN 1 Identifier Acceptance Register 3; 0x00000193 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1IDAR3_AC0:      equ    0                                         ; Acceptance Code Bit 0
CAN1IDAR3_AC1:      equ    1                                         ; Acceptance Code Bit 1
CAN1IDAR3_AC2:      equ    2                                         ; Acceptance Code Bit 2
CAN1IDAR3_AC3:      equ    3                                         ; Acceptance Code Bit 3
CAN1IDAR3_AC4:      equ    4                                         ; Acceptance Code Bit 4
CAN1IDAR3_AC5:      equ    5                                         ; Acceptance Code Bit 5
CAN1IDAR3_AC6:      equ    6                                         ; Acceptance Code Bit 6
CAN1IDAR3_AC7:      equ    7                                         ; Acceptance Code Bit 7
; bit position masks
mCAN1IDAR3_AC0:     equ    %00000001
mCAN1IDAR3_AC1:     equ    %00000010
mCAN1IDAR3_AC2:     equ    %00000100
mCAN1IDAR3_AC3:     equ    %00001000
mCAN1IDAR3_AC4:     equ    %00010000
mCAN1IDAR3_AC5:     equ    %00100000
mCAN1IDAR3_AC6:     equ    %01000000
mCAN1IDAR3_AC7:     equ    %10000000


;*** CAN1IDMR0 - MSCAN 1 Identifier Mask Register 0; 0x00000194 ***
CAN1IDMR0:          equ    $00000194                                ;*** CAN1IDMR0 - MSCAN 1 Identifier Mask Register 0; 0x00000194 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1IDMR0_AM0:      equ    0                                         ; Acceptance Mask Bit 0
CAN1IDMR0_AM1:      equ    1                                         ; Acceptance Mask Bit 1
CAN1IDMR0_AM2:      equ    2                                         ; Acceptance Mask Bit 2
CAN1IDMR0_AM3:      equ    3                                         ; Acceptance Mask Bit 3
CAN1IDMR0_AM4:      equ    4                                         ; Acceptance Mask Bit 4
CAN1IDMR0_AM5:      equ    5                                         ; Acceptance Mask Bit 5
CAN1IDMR0_AM6:      equ    6                                         ; Acceptance Mask Bit 6
CAN1IDMR0_AM7:      equ    7                                         ; Acceptance Mask Bit 7
; bit position masks
mCAN1IDMR0_AM0:     equ    %00000001
mCAN1IDMR0_AM1:     equ    %00000010
mCAN1IDMR0_AM2:     equ    %00000100
mCAN1IDMR0_AM3:     equ    %00001000
mCAN1IDMR0_AM4:     equ    %00010000
mCAN1IDMR0_AM5:     equ    %00100000
mCAN1IDMR0_AM6:     equ    %01000000
mCAN1IDMR0_AM7:     equ    %10000000


;*** CAN1IDMR1 - MSCAN 1 Identifier Mask Register 1; 0x00000195 ***
CAN1IDMR1:          equ    $00000195                                ;*** CAN1IDMR1 - MSCAN 1 Identifier Mask Register 1; 0x00000195 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1IDMR1_AM0:      equ    0                                         ; Acceptance Mask Bit 0
CAN1IDMR1_AM1:      equ    1                                         ; Acceptance Mask Bit 1
CAN1IDMR1_AM2:      equ    2                                         ; Acceptance Mask Bit 2
CAN1IDMR1_AM3:      equ    3                                         ; Acceptance Mask Bit 3
CAN1IDMR1_AM4:      equ    4                                         ; Acceptance Mask Bit 4
CAN1IDMR1_AM5:      equ    5                                         ; Acceptance Mask Bit 5
CAN1IDMR1_AM6:      equ    6                                         ; Acceptance Mask Bit 6
CAN1IDMR1_AM7:      equ    7                                         ; Acceptance Mask Bit 7
; bit position masks
mCAN1IDMR1_AM0:     equ    %00000001
mCAN1IDMR1_AM1:     equ    %00000010
mCAN1IDMR1_AM2:     equ    %00000100
mCAN1IDMR1_AM3:     equ    %00001000
mCAN1IDMR1_AM4:     equ    %00010000
mCAN1IDMR1_AM5:     equ    %00100000
mCAN1IDMR1_AM6:     equ    %01000000
mCAN1IDMR1_AM7:     equ    %10000000


;*** CAN1IDMR2 - MSCAN 1 Identifier Mask Register 2; 0x00000196 ***
CAN1IDMR2:          equ    $00000196                                ;*** CAN1IDMR2 - MSCAN 1 Identifier Mask Register 2; 0x00000196 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1IDMR2_AM0:      equ    0                                         ; Acceptance Mask Bit 0
CAN1IDMR2_AM1:      equ    1                                         ; Acceptance Mask Bit 1
CAN1IDMR2_AM2:      equ    2                                         ; Acceptance Mask Bit 2
CAN1IDMR2_AM3:      equ    3                                         ; Acceptance Mask Bit 3
CAN1IDMR2_AM4:      equ    4                                         ; Acceptance Mask Bit 4
CAN1IDMR2_AM5:      equ    5                                         ; Acceptance Mask Bit 5
CAN1IDMR2_AM6:      equ    6                                         ; Acceptance Mask Bit 6
CAN1IDMR2_AM7:      equ    7                                         ; Acceptance Mask Bit 7
; bit position masks
mCAN1IDMR2_AM0:     equ    %00000001
mCAN1IDMR2_AM1:     equ    %00000010
mCAN1IDMR2_AM2:     equ    %00000100
mCAN1IDMR2_AM3:     equ    %00001000
mCAN1IDMR2_AM4:     equ    %00010000
mCAN1IDMR2_AM5:     equ    %00100000
mCAN1IDMR2_AM6:     equ    %01000000
mCAN1IDMR2_AM7:     equ    %10000000


;*** CAN1IDMR3 - MSCAN 1 Identifier Mask Register 3; 0x00000197 ***
CAN1IDMR3:          equ    $00000197                                ;*** CAN1IDMR3 - MSCAN 1 Identifier Mask Register 3; 0x00000197 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1IDMR3_AM0:      equ    0                                         ; Acceptance Mask Bit 0
CAN1IDMR3_AM1:      equ    1                                         ; Acceptance Mask Bit 1
CAN1IDMR3_AM2:      equ    2                                         ; Acceptance Mask Bit 2
CAN1IDMR3_AM3:      equ    3                                         ; Acceptance Mask Bit 3
CAN1IDMR3_AM4:      equ    4                                         ; Acceptance Mask Bit 4
CAN1IDMR3_AM5:      equ    5                                         ; Acceptance Mask Bit 5
CAN1IDMR3_AM6:      equ    6                                         ; Acceptance Mask Bit 6
CAN1IDMR3_AM7:      equ    7                                         ; Acceptance Mask Bit 7
; bit position masks
mCAN1IDMR3_AM0:     equ    %00000001
mCAN1IDMR3_AM1:     equ    %00000010
mCAN1IDMR3_AM2:     equ    %00000100
mCAN1IDMR3_AM3:     equ    %00001000
mCAN1IDMR3_AM4:     equ    %00010000
mCAN1IDMR3_AM5:     equ    %00100000
mCAN1IDMR3_AM6:     equ    %01000000
mCAN1IDMR3_AM7:     equ    %10000000


;*** CAN1IDAR4 - MSCAN 1 Identifier Acceptance Register 4; 0x00000198 ***
CAN1IDAR4:          equ    $00000198                                ;*** CAN1IDAR4 - MSCAN 1 Identifier Acceptance Register 4; 0x00000198 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1IDAR4_AC0:      equ    0                                         ; Acceptance Code Bit 0
CAN1IDAR4_AC1:      equ    1                                         ; Acceptance Code Bit 1
CAN1IDAR4_AC2:      equ    2                                         ; Acceptance Code Bit 2
CAN1IDAR4_AC3:      equ    3                                         ; Acceptance Code Bit 3
CAN1IDAR4_AC4:      equ    4                                         ; Acceptance Code Bit 4
CAN1IDAR4_AC5:      equ    5                                         ; Acceptance Code Bit 5
CAN1IDAR4_AC6:      equ    6                                         ; Acceptance Code Bit 6
CAN1IDAR4_AC7:      equ    7                                         ; Acceptance Code Bit 7
; bit position masks
mCAN1IDAR4_AC0:     equ    %00000001
mCAN1IDAR4_AC1:     equ    %00000010
mCAN1IDAR4_AC2:     equ    %00000100
mCAN1IDAR4_AC3:     equ    %00001000
mCAN1IDAR4_AC4:     equ    %00010000
mCAN1IDAR4_AC5:     equ    %00100000
mCAN1IDAR4_AC6:     equ    %01000000
mCAN1IDAR4_AC7:     equ    %10000000


;*** CAN1IDAR5 - MSCAN 1 Identifier Acceptance Register 5; 0x00000199 ***
CAN1IDAR5:          equ    $00000199                                ;*** CAN1IDAR5 - MSCAN 1 Identifier Acceptance Register 5; 0x00000199 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1IDAR5_AC0:      equ    0                                         ; Acceptance Code Bit 0
CAN1IDAR5_AC1:      equ    1                                         ; Acceptance Code Bit 1
CAN1IDAR5_AC2:      equ    2                                         ; Acceptance Code Bit 2
CAN1IDAR5_AC3:      equ    3                                         ; Acceptance Code Bit 3
CAN1IDAR5_AC4:      equ    4                                         ; Acceptance Code Bit 4
CAN1IDAR5_AC5:      equ    5                                         ; Acceptance Code Bit 5
CAN1IDAR5_AC6:      equ    6                                         ; Acceptance Code Bit 6
CAN1IDAR5_AC7:      equ    7                                         ; Acceptance Code Bit 7
; bit position masks
mCAN1IDAR5_AC0:     equ    %00000001
mCAN1IDAR5_AC1:     equ    %00000010
mCAN1IDAR5_AC2:     equ    %00000100
mCAN1IDAR5_AC3:     equ    %00001000
mCAN1IDAR5_AC4:     equ    %00010000
mCAN1IDAR5_AC5:     equ    %00100000
mCAN1IDAR5_AC6:     equ    %01000000
mCAN1IDAR5_AC7:     equ    %10000000


;*** CAN1IDAR6 - MSCAN 1 Identifier Acceptance Register 6; 0x0000019A ***
CAN1IDAR6:          equ    $0000019A                                ;*** CAN1IDAR6 - MSCAN 1 Identifier Acceptance Register 6; 0x0000019A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1IDAR6_AC0:      equ    0                                         ; Acceptance Code Bit 0
CAN1IDAR6_AC1:      equ    1                                         ; Acceptance Code Bit 1
CAN1IDAR6_AC2:      equ    2                                         ; Acceptance Code Bit 2
CAN1IDAR6_AC3:      equ    3                                         ; Acceptance Code Bit 3
CAN1IDAR6_AC4:      equ    4                                         ; Acceptance Code Bit 4
CAN1IDAR6_AC5:      equ    5                                         ; Acceptance Code Bit 5
CAN1IDAR6_AC6:      equ    6                                         ; Acceptance Code Bit 6
CAN1IDAR6_AC7:      equ    7                                         ; Acceptance Code Bit 7
; bit position masks
mCAN1IDAR6_AC0:     equ    %00000001
mCAN1IDAR6_AC1:     equ    %00000010
mCAN1IDAR6_AC2:     equ    %00000100
mCAN1IDAR6_AC3:     equ    %00001000
mCAN1IDAR6_AC4:     equ    %00010000
mCAN1IDAR6_AC5:     equ    %00100000
mCAN1IDAR6_AC6:     equ    %01000000
mCAN1IDAR6_AC7:     equ    %10000000


;*** CAN1IDAR7 - MSCAN 1 Identifier Acceptance Register 7; 0x0000019B ***
CAN1IDAR7:          equ    $0000019B                                ;*** CAN1IDAR7 - MSCAN 1 Identifier Acceptance Register 7; 0x0000019B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1IDAR7_AC0:      equ    0                                         ; Acceptance Code Bit 0
CAN1IDAR7_AC1:      equ    1                                         ; Acceptance Code Bit 1
CAN1IDAR7_AC2:      equ    2                                         ; Acceptance Code Bit 2
CAN1IDAR7_AC3:      equ    3                                         ; Acceptance Code Bit 3
CAN1IDAR7_AC4:      equ    4                                         ; Acceptance Code Bit 4
CAN1IDAR7_AC5:      equ    5                                         ; Acceptance Code Bit 5
CAN1IDAR7_AC6:      equ    6                                         ; Acceptance Code Bit 6
CAN1IDAR7_AC7:      equ    7                                         ; Acceptance Code Bit 7
; bit position masks
mCAN1IDAR7_AC0:     equ    %00000001
mCAN1IDAR7_AC1:     equ    %00000010
mCAN1IDAR7_AC2:     equ    %00000100
mCAN1IDAR7_AC3:     equ    %00001000
mCAN1IDAR7_AC4:     equ    %00010000
mCAN1IDAR7_AC5:     equ    %00100000
mCAN1IDAR7_AC6:     equ    %01000000
mCAN1IDAR7_AC7:     equ    %10000000


;*** CAN1IDMR4 - MSCAN 1 Identifier Mask Register 4; 0x0000019C ***
CAN1IDMR4:          equ    $0000019C                                ;*** CAN1IDMR4 - MSCAN 1 Identifier Mask Register 4; 0x0000019C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1IDMR4_AM0:      equ    0                                         ; Acceptance Mask Bit 0
CAN1IDMR4_AM1:      equ    1                                         ; Acceptance Mask Bit 1
CAN1IDMR4_AM2:      equ    2                                         ; Acceptance Mask Bit 2
CAN1IDMR4_AM3:      equ    3                                         ; Acceptance Mask Bit 3
CAN1IDMR4_AM4:      equ    4                                         ; Acceptance Mask Bit 4
CAN1IDMR4_AM5:      equ    5                                         ; Acceptance Mask Bit 5
CAN1IDMR4_AM6:      equ    6                                         ; Acceptance Mask Bit 6
CAN1IDMR4_AM7:      equ    7                                         ; Acceptance Mask Bit 7
; bit position masks
mCAN1IDMR4_AM0:     equ    %00000001
mCAN1IDMR4_AM1:     equ    %00000010
mCAN1IDMR4_AM2:     equ    %00000100
mCAN1IDMR4_AM3:     equ    %00001000
mCAN1IDMR4_AM4:     equ    %00010000
mCAN1IDMR4_AM5:     equ    %00100000
mCAN1IDMR4_AM6:     equ    %01000000
mCAN1IDMR4_AM7:     equ    %10000000


;*** CAN1IDMR5 - MSCAN 1 Identifier Mask Register 5; 0x0000019D ***
CAN1IDMR5:          equ    $0000019D                                ;*** CAN1IDMR5 - MSCAN 1 Identifier Mask Register 5; 0x0000019D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1IDMR5_AM0:      equ    0                                         ; Acceptance Mask Bit 0
CAN1IDMR5_AM1:      equ    1                                         ; Acceptance Mask Bit 1
CAN1IDMR5_AM2:      equ    2                                         ; Acceptance Mask Bit 2
CAN1IDMR5_AM3:      equ    3                                         ; Acceptance Mask Bit 3
CAN1IDMR5_AM4:      equ    4                                         ; Acceptance Mask Bit 4
CAN1IDMR5_AM5:      equ    5                                         ; Acceptance Mask Bit 5
CAN1IDMR5_AM6:      equ    6                                         ; Acceptance Mask Bit 6
CAN1IDMR5_AM7:      equ    7                                         ; Acceptance Mask Bit 7
; bit position masks
mCAN1IDMR5_AM0:     equ    %00000001
mCAN1IDMR5_AM1:     equ    %00000010
mCAN1IDMR5_AM2:     equ    %00000100
mCAN1IDMR5_AM3:     equ    %00001000
mCAN1IDMR5_AM4:     equ    %00010000
mCAN1IDMR5_AM5:     equ    %00100000
mCAN1IDMR5_AM6:     equ    %01000000
mCAN1IDMR5_AM7:     equ    %10000000


;*** CAN1IDMR6 - MSCAN 1 Identifier Mask Register 6; 0x0000019E ***
CAN1IDMR6:          equ    $0000019E                                ;*** CAN1IDMR6 - MSCAN 1 Identifier Mask Register 6; 0x0000019E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1IDMR6_AM0:      equ    0                                         ; Acceptance Mask Bit 0
CAN1IDMR6_AM1:      equ    1                                         ; Acceptance Mask Bit 1
CAN1IDMR6_AM2:      equ    2                                         ; Acceptance Mask Bit 2
CAN1IDMR6_AM3:      equ    3                                         ; Acceptance Mask Bit 3
CAN1IDMR6_AM4:      equ    4                                         ; Acceptance Mask Bit 4
CAN1IDMR6_AM5:      equ    5                                         ; Acceptance Mask Bit 5
CAN1IDMR6_AM6:      equ    6                                         ; Acceptance Mask Bit 6
CAN1IDMR6_AM7:      equ    7                                         ; Acceptance Mask Bit 7
; bit position masks
mCAN1IDMR6_AM0:     equ    %00000001
mCAN1IDMR6_AM1:     equ    %00000010
mCAN1IDMR6_AM2:     equ    %00000100
mCAN1IDMR6_AM3:     equ    %00001000
mCAN1IDMR6_AM4:     equ    %00010000
mCAN1IDMR6_AM5:     equ    %00100000
mCAN1IDMR6_AM6:     equ    %01000000
mCAN1IDMR6_AM7:     equ    %10000000


;*** CAN1IDMR7 - MSCAN 1 Identifier Mask Register 7; 0x0000019F ***
CAN1IDMR7:          equ    $0000019F                                ;*** CAN1IDMR7 - MSCAN 1 Identifier Mask Register 7; 0x0000019F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1IDMR7_AM0:      equ    0                                         ; Acceptance Mask Bit 0
CAN1IDMR7_AM1:      equ    1                                         ; Acceptance Mask Bit 1
CAN1IDMR7_AM2:      equ    2                                         ; Acceptance Mask Bit 2
CAN1IDMR7_AM3:      equ    3                                         ; Acceptance Mask Bit 3
CAN1IDMR7_AM4:      equ    4                                         ; Acceptance Mask Bit 4
CAN1IDMR7_AM5:      equ    5                                         ; Acceptance Mask Bit 5
CAN1IDMR7_AM6:      equ    6                                         ; Acceptance Mask Bit 6
CAN1IDMR7_AM7:      equ    7                                         ; Acceptance Mask Bit 7
; bit position masks
mCAN1IDMR7_AM0:     equ    %00000001
mCAN1IDMR7_AM1:     equ    %00000010
mCAN1IDMR7_AM2:     equ    %00000100
mCAN1IDMR7_AM3:     equ    %00001000
mCAN1IDMR7_AM4:     equ    %00010000
mCAN1IDMR7_AM5:     equ    %00100000
mCAN1IDMR7_AM6:     equ    %01000000
mCAN1IDMR7_AM7:     equ    %10000000


;*** CAN1RXIDR0 - MSCAN 1 Receive Identifier Register 0; 0x000001A0 ***
CAN1RXIDR0:         equ    $000001A0                                ;*** CAN1RXIDR0 - MSCAN 1 Receive Identifier Register 0; 0x000001A0 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1RXIDR0_ID21:    equ    0                                         ; Extended format identifier Bit 21
CAN1RXIDR0_ID22:    equ    1                                         ; Extended format identifier Bit 22
CAN1RXIDR0_ID23:    equ    2                                         ; Extended format identifier Bit 23
CAN1RXIDR0_ID24:    equ    3                                         ; Extended format identifier Bit 24
CAN1RXIDR0_ID25:    equ    4                                         ; Extended format identifier Bit 25
CAN1RXIDR0_ID26:    equ    5                                         ; Extended format identifier Bit 26
CAN1RXIDR0_ID27:    equ    6                                         ; Extended format identifier Bit 27
CAN1RXIDR0_ID28:    equ    7                                         ; Extended format identifier Bit 28
; bit position masks
mCAN1RXIDR0_ID21:   equ    %00000001
mCAN1RXIDR0_ID22:   equ    %00000010
mCAN1RXIDR0_ID23:   equ    %00000100
mCAN1RXIDR0_ID24:   equ    %00001000
mCAN1RXIDR0_ID25:   equ    %00010000
mCAN1RXIDR0_ID26:   equ    %00100000
mCAN1RXIDR0_ID27:   equ    %01000000
mCAN1RXIDR0_ID28:   equ    %10000000


;*** CAN1RXIDR1 - MSCAN 1 Receive Identifier Register 1; 0x000001A1 ***
CAN1RXIDR1:         equ    $000001A1                                ;*** CAN1RXIDR1 - MSCAN 1 Receive Identifier Register 1; 0x000001A1 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1RXIDR1_ID15:    equ    0                                         ; Extended format identifier Bit 15
CAN1RXIDR1_ID16:    equ    1                                         ; Extended format identifier Bit 16
CAN1RXIDR1_ID17:    equ    2                                         ; Extended format identifier Bit 17
CAN1RXIDR1_IDE:     equ    3                                         ; ID Extended
CAN1RXIDR1_SRR:     equ    4                                         ; Substitute Remote Request
CAN1RXIDR1_ID18:    equ    5                                         ; Extended format identifier Bit 18
CAN1RXIDR1_ID19:    equ    6                                         ; Extended format identifier Bit 19
CAN1RXIDR1_ID20:    equ    7                                         ; Extended format identifier Bit 20
; bit position masks
mCAN1RXIDR1_ID15:   equ    %00000001
mCAN1RXIDR1_ID16:   equ    %00000010
mCAN1RXIDR1_ID17:   equ    %00000100
mCAN1RXIDR1_IDE:    equ    %00001000
mCAN1RXIDR1_SRR:    equ    %00010000
mCAN1RXIDR1_ID18:   equ    %00100000
mCAN1RXIDR1_ID19:   equ    %01000000
mCAN1RXIDR1_ID20:   equ    %10000000


;*** CAN1RXIDR2 - MSCAN 1 Receive Identifier Register 2; 0x000001A2 ***
CAN1RXIDR2:         equ    $000001A2                                ;*** CAN1RXIDR2 - MSCAN 1 Receive Identifier Register 2; 0x000001A2 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1RXIDR2_ID7:     equ    0                                         ; Extended format identifier Bit 7
CAN1RXIDR2_ID8:     equ    1                                         ; Extended format identifier Bit 8
CAN1RXIDR2_ID9:     equ    2                                         ; Extended format identifier Bit 9
CAN1RXIDR2_ID10:    equ    3                                         ; Extended format identifier Bit 10
CAN1RXIDR2_ID11:    equ    4                                         ; Extended format identifier Bit 11
CAN1RXIDR2_ID12:    equ    5                                         ; Extended format identifier Bit 12
CAN1RXIDR2_ID13:    equ    6                                         ; Extended format identifier Bit 13
CAN1RXIDR2_ID14:    equ    7                                         ; Extended format identifier Bit 14
; bit position masks
mCAN1RXIDR2_ID7:    equ    %00000001
mCAN1RXIDR2_ID8:    equ    %00000010
mCAN1RXIDR2_ID9:    equ    %00000100
mCAN1RXIDR2_ID10:   equ    %00001000
mCAN1RXIDR2_ID11:   equ    %00010000
mCAN1RXIDR2_ID12:   equ    %00100000
mCAN1RXIDR2_ID13:   equ    %01000000
mCAN1RXIDR2_ID14:   equ    %10000000


;*** CAN1RXIDR3 - MSCAN 1 Receive Identifier Register 3; 0x000001A3 ***
CAN1RXIDR3:         equ    $000001A3                                ;*** CAN1RXIDR3 - MSCAN 1 Receive Identifier Register 3; 0x000001A3 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1RXIDR3_RTR:     equ    0                                         ; Remote Transmission Request
CAN1RXIDR3_ID0:     equ    1                                         ; Extended format identifier Bit 0
CAN1RXIDR3_ID1:     equ    2                                         ; Extended format identifier Bit 1
CAN1RXIDR3_ID2:     equ    3                                         ; Extended format identifier Bit 2
CAN1RXIDR3_ID3:     equ    4                                         ; Extended format identifier Bit 3
CAN1RXIDR3_ID4:     equ    5                                         ; Extended format identifier Bit 4
CAN1RXIDR3_ID5:     equ    6                                         ; Extended format identifier Bit 5
CAN1RXIDR3_ID6:     equ    7                                         ; Extended format identifier Bit 6
; bit position masks
mCAN1RXIDR3_RTR:    equ    %00000001
mCAN1RXIDR3_ID0:    equ    %00000010
mCAN1RXIDR3_ID1:    equ    %00000100
mCAN1RXIDR3_ID2:    equ    %00001000
mCAN1RXIDR3_ID3:    equ    %00010000
mCAN1RXIDR3_ID4:    equ    %00100000
mCAN1RXIDR3_ID5:    equ    %01000000
mCAN1RXIDR3_ID6:    equ    %10000000


;*** CAN1RXDSR0 - MSCAN 1 Receive Data Segment Register 0; 0x000001A4 ***
CAN1RXDSR0:         equ    $000001A4                                ;*** CAN1RXDSR0 - MSCAN 1 Receive Data Segment Register 0; 0x000001A4 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1RXDSR0_DB0:     equ    0                                         ; Data Bit 0
CAN1RXDSR0_DB1:     equ    1                                         ; Data Bit 1
CAN1RXDSR0_DB2:     equ    2                                         ; Data Bit 2
CAN1RXDSR0_DB3:     equ    3                                         ; Data Bit 3
CAN1RXDSR0_DB4:     equ    4                                         ; Data Bit 4
CAN1RXDSR0_DB5:     equ    5                                         ; Data Bit 5
CAN1RXDSR0_DB6:     equ    6                                         ; Data Bit 6
CAN1RXDSR0_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN1RXDSR0_DB0:    equ    %00000001
mCAN1RXDSR0_DB1:    equ    %00000010
mCAN1RXDSR0_DB2:    equ    %00000100
mCAN1RXDSR0_DB3:    equ    %00001000
mCAN1RXDSR0_DB4:    equ    %00010000
mCAN1RXDSR0_DB5:    equ    %00100000
mCAN1RXDSR0_DB6:    equ    %01000000
mCAN1RXDSR0_DB7:    equ    %10000000


;*** CAN1RXDSR1 - MSCAN 1 Receive Data Segment Register 1; 0x000001A5 ***
CAN1RXDSR1:         equ    $000001A5                                ;*** CAN1RXDSR1 - MSCAN 1 Receive Data Segment Register 1; 0x000001A5 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1RXDSR1_DB0:     equ    0                                         ; Data Bit 0
CAN1RXDSR1_DB1:     equ    1                                         ; Data Bit 1
CAN1RXDSR1_DB2:     equ    2                                         ; Data Bit 2
CAN1RXDSR1_DB3:     equ    3                                         ; Data Bit 3
CAN1RXDSR1_DB4:     equ    4                                         ; Data Bit 4
CAN1RXDSR1_DB5:     equ    5                                         ; Data Bit 5
CAN1RXDSR1_DB6:     equ    6                                         ; Data Bit 6
CAN1RXDSR1_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN1RXDSR1_DB0:    equ    %00000001
mCAN1RXDSR1_DB1:    equ    %00000010
mCAN1RXDSR1_DB2:    equ    %00000100
mCAN1RXDSR1_DB3:    equ    %00001000
mCAN1RXDSR1_DB4:    equ    %00010000
mCAN1RXDSR1_DB5:    equ    %00100000
mCAN1RXDSR1_DB6:    equ    %01000000
mCAN1RXDSR1_DB7:    equ    %10000000


;*** CAN1RXDSR2 - MSCAN 1 Receive Data Segment Register 2; 0x000001A6 ***
CAN1RXDSR2:         equ    $000001A6                                ;*** CAN1RXDSR2 - MSCAN 1 Receive Data Segment Register 2; 0x000001A6 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1RXDSR2_DB0:     equ    0                                         ; Data Bit 0
CAN1RXDSR2_DB1:     equ    1                                         ; Data Bit 1
CAN1RXDSR2_DB2:     equ    2                                         ; Data Bit 2
CAN1RXDSR2_DB3:     equ    3                                         ; Data Bit 3
CAN1RXDSR2_DB4:     equ    4                                         ; Data Bit 4
CAN1RXDSR2_DB5:     equ    5                                         ; Data Bit 5
CAN1RXDSR2_DB6:     equ    6                                         ; Data Bit 6
CAN1RXDSR2_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN1RXDSR2_DB0:    equ    %00000001
mCAN1RXDSR2_DB1:    equ    %00000010
mCAN1RXDSR2_DB2:    equ    %00000100
mCAN1RXDSR2_DB3:    equ    %00001000
mCAN1RXDSR2_DB4:    equ    %00010000
mCAN1RXDSR2_DB5:    equ    %00100000
mCAN1RXDSR2_DB6:    equ    %01000000
mCAN1RXDSR2_DB7:    equ    %10000000


;*** CAN1RXDSR3 - MSCAN 1 Receive Data Segment Register 3; 0x000001A7 ***
CAN1RXDSR3:         equ    $000001A7                                ;*** CAN1RXDSR3 - MSCAN 1 Receive Data Segment Register 3; 0x000001A7 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1RXDSR3_DB0:     equ    0                                         ; Data Bit 0
CAN1RXDSR3_DB1:     equ    1                                         ; Data Bit 1
CAN1RXDSR3_DB2:     equ    2                                         ; Data Bit 2
CAN1RXDSR3_DB3:     equ    3                                         ; Data Bit 3
CAN1RXDSR3_DB4:     equ    4                                         ; Data Bit 4
CAN1RXDSR3_DB5:     equ    5                                         ; Data Bit 5
CAN1RXDSR3_DB6:     equ    6                                         ; Data Bit 6
CAN1RXDSR3_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN1RXDSR3_DB0:    equ    %00000001
mCAN1RXDSR3_DB1:    equ    %00000010
mCAN1RXDSR3_DB2:    equ    %00000100
mCAN1RXDSR3_DB3:    equ    %00001000
mCAN1RXDSR3_DB4:    equ    %00010000
mCAN1RXDSR3_DB5:    equ    %00100000
mCAN1RXDSR3_DB6:    equ    %01000000
mCAN1RXDSR3_DB7:    equ    %10000000


;*** CAN1RXDSR4 - MSCAN 1 Receive Data Segment Register 4; 0x000001A8 ***
CAN1RXDSR4:         equ    $000001A8                                ;*** CAN1RXDSR4 - MSCAN 1 Receive Data Segment Register 4; 0x000001A8 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1RXDSR4_DB0:     equ    0                                         ; Data Bit 0
CAN1RXDSR4_DB1:     equ    1                                         ; Data Bit 1
CAN1RXDSR4_DB2:     equ    2                                         ; Data Bit 2
CAN1RXDSR4_DB3:     equ    3                                         ; Data Bit 3
CAN1RXDSR4_DB4:     equ    4                                         ; Data Bit 4
CAN1RXDSR4_DB5:     equ    5                                         ; Data Bit 5
CAN1RXDSR4_DB6:     equ    6                                         ; Data Bit 6
CAN1RXDSR4_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN1RXDSR4_DB0:    equ    %00000001
mCAN1RXDSR4_DB1:    equ    %00000010
mCAN1RXDSR4_DB2:    equ    %00000100
mCAN1RXDSR4_DB3:    equ    %00001000
mCAN1RXDSR4_DB4:    equ    %00010000
mCAN1RXDSR4_DB5:    equ    %00100000
mCAN1RXDSR4_DB6:    equ    %01000000
mCAN1RXDSR4_DB7:    equ    %10000000


;*** CAN1RXDSR5 - MSCAN 1 Receive Data Segment Register 5; 0x000001A9 ***
CAN1RXDSR5:         equ    $000001A9                                ;*** CAN1RXDSR5 - MSCAN 1 Receive Data Segment Register 5; 0x000001A9 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1RXDSR5_DB0:     equ    0                                         ; Data Bit 0
CAN1RXDSR5_DB1:     equ    1                                         ; Data Bit 1
CAN1RXDSR5_DB2:     equ    2                                         ; Data Bit 2
CAN1RXDSR5_DB3:     equ    3                                         ; Data Bit 3
CAN1RXDSR5_DB4:     equ    4                                         ; Data Bit 4
CAN1RXDSR5_DB5:     equ    5                                         ; Data Bit 5
CAN1RXDSR5_DB6:     equ    6                                         ; Data Bit 6
CAN1RXDSR5_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN1RXDSR5_DB0:    equ    %00000001
mCAN1RXDSR5_DB1:    equ    %00000010
mCAN1RXDSR5_DB2:    equ    %00000100
mCAN1RXDSR5_DB3:    equ    %00001000
mCAN1RXDSR5_DB4:    equ    %00010000
mCAN1RXDSR5_DB5:    equ    %00100000
mCAN1RXDSR5_DB6:    equ    %01000000
mCAN1RXDSR5_DB7:    equ    %10000000


;*** CAN1RXDSR6 - MSCAN 1 Receive Data Segment Register 6; 0x000001AA ***
CAN1RXDSR6:         equ    $000001AA                                ;*** CAN1RXDSR6 - MSCAN 1 Receive Data Segment Register 6; 0x000001AA ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1RXDSR6_DB0:     equ    0                                         ; Data Bit 0
CAN1RXDSR6_DB1:     equ    1                                         ; Data Bit 1
CAN1RXDSR6_DB2:     equ    2                                         ; Data Bit 2
CAN1RXDSR6_DB3:     equ    3                                         ; Data Bit 3
CAN1RXDSR6_DB4:     equ    4                                         ; Data Bit 4
CAN1RXDSR6_DB5:     equ    5                                         ; Data Bit 5
CAN1RXDSR6_DB6:     equ    6                                         ; Data Bit 6
CAN1RXDSR6_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN1RXDSR6_DB0:    equ    %00000001
mCAN1RXDSR6_DB1:    equ    %00000010
mCAN1RXDSR6_DB2:    equ    %00000100
mCAN1RXDSR6_DB3:    equ    %00001000
mCAN1RXDSR6_DB4:    equ    %00010000
mCAN1RXDSR6_DB5:    equ    %00100000
mCAN1RXDSR6_DB6:    equ    %01000000
mCAN1RXDSR6_DB7:    equ    %10000000


;*** CAN1RXDSR7 - MSCAN 1 Receive Data Segment Register 7; 0x000001AB ***
CAN1RXDSR7:         equ    $000001AB                                ;*** CAN1RXDSR7 - MSCAN 1 Receive Data Segment Register 7; 0x000001AB ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1RXDSR7_DB0:     equ    0                                         ; Data Bit 0
CAN1RXDSR7_DB1:     equ    1                                         ; Data Bit 1
CAN1RXDSR7_DB2:     equ    2                                         ; Data Bit 2
CAN1RXDSR7_DB3:     equ    3                                         ; Data Bit 3
CAN1RXDSR7_DB4:     equ    4                                         ; Data Bit 4
CAN1RXDSR7_DB5:     equ    5                                         ; Data Bit 5
CAN1RXDSR7_DB6:     equ    6                                         ; Data Bit 6
CAN1RXDSR7_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN1RXDSR7_DB0:    equ    %00000001
mCAN1RXDSR7_DB1:    equ    %00000010
mCAN1RXDSR7_DB2:    equ    %00000100
mCAN1RXDSR7_DB3:    equ    %00001000
mCAN1RXDSR7_DB4:    equ    %00010000
mCAN1RXDSR7_DB5:    equ    %00100000
mCAN1RXDSR7_DB6:    equ    %01000000
mCAN1RXDSR7_DB7:    equ    %10000000


;*** CAN1RXDLR - MSCAN 1 Receive Data Length Register; 0x000001AC ***
CAN1RXDLR:          equ    $000001AC                                ;*** CAN1RXDLR - MSCAN 1 Receive Data Length Register; 0x000001AC ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1RXDLR_DLC0:     equ    0                                         ; Data Length Code Bit 0
CAN1RXDLR_DLC1:     equ    1                                         ; Data Length Code Bit 1
CAN1RXDLR_DLC2:     equ    2                                         ; Data Length Code Bit 2
CAN1RXDLR_DLC3:     equ    3                                         ; Data Length Code Bit 3
; bit position masks
mCAN1RXDLR_DLC0:    equ    %00000001
mCAN1RXDLR_DLC1:    equ    %00000010
mCAN1RXDLR_DLC2:    equ    %00000100
mCAN1RXDLR_DLC3:    equ    %00001000


;*** CAN1RXTSR - MSCAN 1 Receive Time Stamp Register; 0x000001AE ***
CAN1RXTSR:          equ    $000001AE                                ;*** CAN1RXTSR - MSCAN 1 Receive Time Stamp Register; 0x000001AE ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1RXTSR_TSR0:     equ    0                                         ; Time Stamp Bit 0
CAN1RXTSR_TSR1:     equ    1                                         ; Time Stamp Bit 1
CAN1RXTSR_TSR2:     equ    2                                         ; Time Stamp Bit 2
CAN1RXTSR_TSR3:     equ    3                                         ; Time Stamp Bit 3
CAN1RXTSR_TSR4:     equ    4                                         ; Time Stamp Bit 4
CAN1RXTSR_TSR5:     equ    5                                         ; Time Stamp Bit 5
CAN1RXTSR_TSR6:     equ    6                                         ; Time Stamp Bit 6
CAN1RXTSR_TSR7:     equ    7                                         ; Time Stamp Bit 7
CAN1RXTSR_TSR8:     equ    8                                         ; Time Stamp Bit 8
CAN1RXTSR_TSR9:     equ    9                                         ; Time Stamp Bit 9
CAN1RXTSR_TSR10:    equ    10                                        ; Time Stamp Bit 10
CAN1RXTSR_TSR11:    equ    11                                        ; Time Stamp Bit 11
CAN1RXTSR_TSR12:    equ    12                                        ; Time Stamp Bit 12
CAN1RXTSR_TSR13:    equ    13                                        ; Time Stamp Bit 13
CAN1RXTSR_TSR14:    equ    14                                        ; Time Stamp Bit 14
CAN1RXTSR_TSR15:    equ    15                                        ; Time Stamp Bit 15
; bit position masks
mCAN1RXTSR_TSR0:    equ    %00000001
mCAN1RXTSR_TSR1:    equ    %00000010
mCAN1RXTSR_TSR2:    equ    %00000100
mCAN1RXTSR_TSR3:    equ    %00001000
mCAN1RXTSR_TSR4:    equ    %00010000
mCAN1RXTSR_TSR5:    equ    %00100000
mCAN1RXTSR_TSR6:    equ    %01000000
mCAN1RXTSR_TSR7:    equ    %10000000
mCAN1RXTSR_TSR8:    equ    %100000000
mCAN1RXTSR_TSR9:    equ    %1000000000
mCAN1RXTSR_TSR10:   equ    %10000000000
mCAN1RXTSR_TSR11:   equ    %100000000000
mCAN1RXTSR_TSR12:   equ    %1000000000000
mCAN1RXTSR_TSR13:   equ    %10000000000000
mCAN1RXTSR_TSR14:   equ    %100000000000000
mCAN1RXTSR_TSR15:   equ    %1000000000000000


;*** CAN1RXTSRH - MSCAN 1 Receive Time Stamp Register High; 0x000001AE ***
CAN1RXTSRH:         equ    $000001AE                                ;*** CAN1RXTSRH - MSCAN 1 Receive Time Stamp Register High; 0x000001AE ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1RXTSRH_TSR8:    equ    0                                         ; Time Stamp Bit 8
CAN1RXTSRH_TSR9:    equ    1                                         ; Time Stamp Bit 9
CAN1RXTSRH_TSR10:   equ    2                                         ; Time Stamp Bit 10
CAN1RXTSRH_TSR11:   equ    3                                         ; Time Stamp Bit 11
CAN1RXTSRH_TSR12:   equ    4                                         ; Time Stamp Bit 12
CAN1RXTSRH_TSR13:   equ    5                                         ; Time Stamp Bit 13
CAN1RXTSRH_TSR14:   equ    6                                         ; Time Stamp Bit 14
CAN1RXTSRH_TSR15:   equ    7                                         ; Time Stamp Bit 15
; bit position masks
mCAN1RXTSRH_TSR8:   equ    %00000001
mCAN1RXTSRH_TSR9:   equ    %00000010
mCAN1RXTSRH_TSR10:  equ    %00000100
mCAN1RXTSRH_TSR11:  equ    %00001000
mCAN1RXTSRH_TSR12:  equ    %00010000
mCAN1RXTSRH_TSR13:  equ    %00100000
mCAN1RXTSRH_TSR14:  equ    %01000000
mCAN1RXTSRH_TSR15:  equ    %10000000


;*** CAN1RXTSRL - MSCAN 1 Receive Time Stamp Register Low; 0x000001AF ***
CAN1RXTSRL:         equ    $000001AF                                ;*** CAN1RXTSRL - MSCAN 1 Receive Time Stamp Register Low; 0x000001AF ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1RXTSRL_TSR0:    equ    0                                         ; Time Stamp Bit 0
CAN1RXTSRL_TSR1:    equ    1                                         ; Time Stamp Bit 1
CAN1RXTSRL_TSR2:    equ    2                                         ; Time Stamp Bit 2
CAN1RXTSRL_TSR3:    equ    3                                         ; Time Stamp Bit 3
CAN1RXTSRL_TSR4:    equ    4                                         ; Time Stamp Bit 4
CAN1RXTSRL_TSR5:    equ    5                                         ; Time Stamp Bit 5
CAN1RXTSRL_TSR6:    equ    6                                         ; Time Stamp Bit 6
CAN1RXTSRL_TSR7:    equ    7                                         ; Time Stamp Bit 7
; bit position masks
mCAN1RXTSRL_TSR0:   equ    %00000001
mCAN1RXTSRL_TSR1:   equ    %00000010
mCAN1RXTSRL_TSR2:   equ    %00000100
mCAN1RXTSRL_TSR3:   equ    %00001000
mCAN1RXTSRL_TSR4:   equ    %00010000
mCAN1RXTSRL_TSR5:   equ    %00100000
mCAN1RXTSRL_TSR6:   equ    %01000000
mCAN1RXTSRL_TSR7:   equ    %10000000


;*** CAN1TXIDR0 - MSCAN 1 Transmit Identifier Register 0; 0x000001B0 ***
CAN1TXIDR0:         equ    $000001B0                                ;*** CAN1TXIDR0 - MSCAN 1 Transmit Identifier Register 0; 0x000001B0 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1TXIDR0_ID21:    equ    0                                         ; Extended format identifier Bit 21
CAN1TXIDR0_ID22:    equ    1                                         ; Extended format identifier Bit 22
CAN1TXIDR0_ID23:    equ    2                                         ; Extended format identifier Bit 23
CAN1TXIDR0_ID24:    equ    3                                         ; Extended format identifier Bit 24
CAN1TXIDR0_ID25:    equ    4                                         ; Extended format identifier Bit 25
CAN1TXIDR0_ID26:    equ    5                                         ; Extended format identifier Bit 26
CAN1TXIDR0_ID27:    equ    6                                         ; Extended format identifier Bit 27
CAN1TXIDR0_ID28:    equ    7                                         ; Extended format identifier Bit 28
; bit position masks
mCAN1TXIDR0_ID21:   equ    %00000001
mCAN1TXIDR0_ID22:   equ    %00000010
mCAN1TXIDR0_ID23:   equ    %00000100
mCAN1TXIDR0_ID24:   equ    %00001000
mCAN1TXIDR0_ID25:   equ    %00010000
mCAN1TXIDR0_ID26:   equ    %00100000
mCAN1TXIDR0_ID27:   equ    %01000000
mCAN1TXIDR0_ID28:   equ    %10000000


;*** CAN1TXIDR1 - MSCAN 1 Transmit Identifier Register 1; 0x000001B1 ***
CAN1TXIDR1:         equ    $000001B1                                ;*** CAN1TXIDR1 - MSCAN 1 Transmit Identifier Register 1; 0x000001B1 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1TXIDR1_ID15:    equ    0                                         ; Extended format identifier Bit 15
CAN1TXIDR1_ID16:    equ    1                                         ; Extended format identifier Bit 16
CAN1TXIDR1_ID17:    equ    2                                         ; Extended format identifier Bit 17
CAN1TXIDR1_IDE:     equ    3                                         ; ID Extended
CAN1TXIDR1_SRR:     equ    4                                         ; Substitute Remote Request
CAN1TXIDR1_ID18:    equ    5                                         ; Extended format identifier Bit 18
CAN1TXIDR1_ID19:    equ    6                                         ; Extended format identifier Bit 19
CAN1TXIDR1_ID20:    equ    7                                         ; Extended format identifier Bit 20
; bit position masks
mCAN1TXIDR1_ID15:   equ    %00000001
mCAN1TXIDR1_ID16:   equ    %00000010
mCAN1TXIDR1_ID17:   equ    %00000100
mCAN1TXIDR1_IDE:    equ    %00001000
mCAN1TXIDR1_SRR:    equ    %00010000
mCAN1TXIDR1_ID18:   equ    %00100000
mCAN1TXIDR1_ID19:   equ    %01000000
mCAN1TXIDR1_ID20:   equ    %10000000


;*** CAN1TXIDR2 - MSCAN 1 Transmit Identifier Register 2; 0x000001B2 ***
CAN1TXIDR2:         equ    $000001B2                                ;*** CAN1TXIDR2 - MSCAN 1 Transmit Identifier Register 2; 0x000001B2 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1TXIDR2_ID7:     equ    0                                         ; Extended format identifier Bit 7
CAN1TXIDR2_ID8:     equ    1                                         ; Extended format identifier Bit 8
CAN1TXIDR2_ID9:     equ    2                                         ; Extended format identifier Bit 9
CAN1TXIDR2_ID10:    equ    3                                         ; Extended format identifier Bit 10
CAN1TXIDR2_ID11:    equ    4                                         ; Extended format identifier Bit 11
CAN1TXIDR2_ID12:    equ    5                                         ; Extended format identifier Bit 12
CAN1TXIDR2_ID13:    equ    6                                         ; Extended format identifier Bit 13
CAN1TXIDR2_ID14:    equ    7                                         ; Extended format identifier Bit 14
; bit position masks
mCAN1TXIDR2_ID7:    equ    %00000001
mCAN1TXIDR2_ID8:    equ    %00000010
mCAN1TXIDR2_ID9:    equ    %00000100
mCAN1TXIDR2_ID10:   equ    %00001000
mCAN1TXIDR2_ID11:   equ    %00010000
mCAN1TXIDR2_ID12:   equ    %00100000
mCAN1TXIDR2_ID13:   equ    %01000000
mCAN1TXIDR2_ID14:   equ    %10000000


;*** CAN1TXIDR3 - MSCAN 1 Transmit Identifier Register 3; 0x000001B3 ***
CAN1TXIDR3:         equ    $000001B3                                ;*** CAN1TXIDR3 - MSCAN 1 Transmit Identifier Register 3; 0x000001B3 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1TXIDR3_RTR:     equ    0                                         ; Remote Transmission Request
CAN1TXIDR3_ID0:     equ    1                                         ; Extended format identifier Bit 0
CAN1TXIDR3_ID1:     equ    2                                         ; Extended format identifier Bit 1
CAN1TXIDR3_ID2:     equ    3                                         ; Extended format identifier Bit 2
CAN1TXIDR3_ID3:     equ    4                                         ; Extended format identifier Bit 3
CAN1TXIDR3_ID4:     equ    5                                         ; Extended format identifier Bit 4
CAN1TXIDR3_ID5:     equ    6                                         ; Extended format identifier Bit 5
CAN1TXIDR3_ID6:     equ    7                                         ; Extended format identifier Bit 6
; bit position masks
mCAN1TXIDR3_RTR:    equ    %00000001
mCAN1TXIDR3_ID0:    equ    %00000010
mCAN1TXIDR3_ID1:    equ    %00000100
mCAN1TXIDR3_ID2:    equ    %00001000
mCAN1TXIDR3_ID3:    equ    %00010000
mCAN1TXIDR3_ID4:    equ    %00100000
mCAN1TXIDR3_ID5:    equ    %01000000
mCAN1TXIDR3_ID6:    equ    %10000000


;*** CAN1TXDSR0 - MSCAN 1 Transmit Data Segment Register 0; 0x000001B4 ***
CAN1TXDSR0:         equ    $000001B4                                ;*** CAN1TXDSR0 - MSCAN 1 Transmit Data Segment Register 0; 0x000001B4 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1TXDSR0_DB0:     equ    0                                         ; Data Bit 0
CAN1TXDSR0_DB1:     equ    1                                         ; Data Bit 1
CAN1TXDSR0_DB2:     equ    2                                         ; Data Bit 2
CAN1TXDSR0_DB3:     equ    3                                         ; Data Bit 3
CAN1TXDSR0_DB4:     equ    4                                         ; Data Bit 4
CAN1TXDSR0_DB5:     equ    5                                         ; Data Bit 5
CAN1TXDSR0_DB6:     equ    6                                         ; Data Bit 6
CAN1TXDSR0_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN1TXDSR0_DB0:    equ    %00000001
mCAN1TXDSR0_DB1:    equ    %00000010
mCAN1TXDSR0_DB2:    equ    %00000100
mCAN1TXDSR0_DB3:    equ    %00001000
mCAN1TXDSR0_DB4:    equ    %00010000
mCAN1TXDSR0_DB5:    equ    %00100000
mCAN1TXDSR0_DB6:    equ    %01000000
mCAN1TXDSR0_DB7:    equ    %10000000


;*** CAN1TXDSR1 - MSCAN 1 Transmit Data Segment Register 1; 0x000001B5 ***
CAN1TXDSR1:         equ    $000001B5                                ;*** CAN1TXDSR1 - MSCAN 1 Transmit Data Segment Register 1; 0x000001B5 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1TXDSR1_DB0:     equ    0                                         ; Data Bit 0
CAN1TXDSR1_DB1:     equ    1                                         ; Data Bit 1
CAN1TXDSR1_DB2:     equ    2                                         ; Data Bit 2
CAN1TXDSR1_DB3:     equ    3                                         ; Data Bit 3
CAN1TXDSR1_DB4:     equ    4                                         ; Data Bit 4
CAN1TXDSR1_DB5:     equ    5                                         ; Data Bit 5
CAN1TXDSR1_DB6:     equ    6                                         ; Data Bit 6
CAN1TXDSR1_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN1TXDSR1_DB0:    equ    %00000001
mCAN1TXDSR1_DB1:    equ    %00000010
mCAN1TXDSR1_DB2:    equ    %00000100
mCAN1TXDSR1_DB3:    equ    %00001000
mCAN1TXDSR1_DB4:    equ    %00010000
mCAN1TXDSR1_DB5:    equ    %00100000
mCAN1TXDSR1_DB6:    equ    %01000000
mCAN1TXDSR1_DB7:    equ    %10000000


;*** CAN1TXDSR2 - MSCAN 1 Transmit Data Segment Register 2; 0x000001B6 ***
CAN1TXDSR2:         equ    $000001B6                                ;*** CAN1TXDSR2 - MSCAN 1 Transmit Data Segment Register 2; 0x000001B6 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1TXDSR2_DB0:     equ    0                                         ; Data Bit 0
CAN1TXDSR2_DB1:     equ    1                                         ; Data Bit 1
CAN1TXDSR2_DB2:     equ    2                                         ; Data Bit 2
CAN1TXDSR2_DB3:     equ    3                                         ; Data Bit 3
CAN1TXDSR2_DB4:     equ    4                                         ; Data Bit 4
CAN1TXDSR2_DB5:     equ    5                                         ; Data Bit 5
CAN1TXDSR2_DB6:     equ    6                                         ; Data Bit 6
CAN1TXDSR2_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN1TXDSR2_DB0:    equ    %00000001
mCAN1TXDSR2_DB1:    equ    %00000010
mCAN1TXDSR2_DB2:    equ    %00000100
mCAN1TXDSR2_DB3:    equ    %00001000
mCAN1TXDSR2_DB4:    equ    %00010000
mCAN1TXDSR2_DB5:    equ    %00100000
mCAN1TXDSR2_DB6:    equ    %01000000
mCAN1TXDSR2_DB7:    equ    %10000000


;*** CAN1TXDSR3 - MSCAN 1 Transmit Data Segment Register 3; 0x000001B7 ***
CAN1TXDSR3:         equ    $000001B7                                ;*** CAN1TXDSR3 - MSCAN 1 Transmit Data Segment Register 3; 0x000001B7 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1TXDSR3_DB0:     equ    0                                         ; Data Bit 0
CAN1TXDSR3_DB1:     equ    1                                         ; Data Bit 1
CAN1TXDSR3_DB2:     equ    2                                         ; Data Bit 2
CAN1TXDSR3_DB3:     equ    3                                         ; Data Bit 3
CAN1TXDSR3_DB4:     equ    4                                         ; Data Bit 4
CAN1TXDSR3_DB5:     equ    5                                         ; Data Bit 5
CAN1TXDSR3_DB6:     equ    6                                         ; Data Bit 6
CAN1TXDSR3_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN1TXDSR3_DB0:    equ    %00000001
mCAN1TXDSR3_DB1:    equ    %00000010
mCAN1TXDSR3_DB2:    equ    %00000100
mCAN1TXDSR3_DB3:    equ    %00001000
mCAN1TXDSR3_DB4:    equ    %00010000
mCAN1TXDSR3_DB5:    equ    %00100000
mCAN1TXDSR3_DB6:    equ    %01000000
mCAN1TXDSR3_DB7:    equ    %10000000


;*** CAN1TXDSR4 - MSCAN 1 Transmit Data Segment Register 4; 0x000001B8 ***
CAN1TXDSR4:         equ    $000001B8                                ;*** CAN1TXDSR4 - MSCAN 1 Transmit Data Segment Register 4; 0x000001B8 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1TXDSR4_DB0:     equ    0                                         ; Data Bit 0
CAN1TXDSR4_DB1:     equ    1                                         ; Data Bit 1
CAN1TXDSR4_DB2:     equ    2                                         ; Data Bit 2
CAN1TXDSR4_DB3:     equ    3                                         ; Data Bit 3
CAN1TXDSR4_DB4:     equ    4                                         ; Data Bit 4
CAN1TXDSR4_DB5:     equ    5                                         ; Data Bit 5
CAN1TXDSR4_DB6:     equ    6                                         ; Data Bit 6
CAN1TXDSR4_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN1TXDSR4_DB0:    equ    %00000001
mCAN1TXDSR4_DB1:    equ    %00000010
mCAN1TXDSR4_DB2:    equ    %00000100
mCAN1TXDSR4_DB3:    equ    %00001000
mCAN1TXDSR4_DB4:    equ    %00010000
mCAN1TXDSR4_DB5:    equ    %00100000
mCAN1TXDSR4_DB6:    equ    %01000000
mCAN1TXDSR4_DB7:    equ    %10000000


;*** CAN1TXDSR5 - MSCAN 1 Transmit Data Segment Register 5; 0x000001B9 ***
CAN1TXDSR5:         equ    $000001B9                                ;*** CAN1TXDSR5 - MSCAN 1 Transmit Data Segment Register 5; 0x000001B9 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1TXDSR5_DB0:     equ    0                                         ; Data Bit 0
CAN1TXDSR5_DB1:     equ    1                                         ; Data Bit 1
CAN1TXDSR5_DB2:     equ    2                                         ; Data Bit 2
CAN1TXDSR5_DB3:     equ    3                                         ; Data Bit 3
CAN1TXDSR5_DB4:     equ    4                                         ; Data Bit 4
CAN1TXDSR5_DB5:     equ    5                                         ; Data Bit 5
CAN1TXDSR5_DB6:     equ    6                                         ; Data Bit 6
CAN1TXDSR5_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN1TXDSR5_DB0:    equ    %00000001
mCAN1TXDSR5_DB1:    equ    %00000010
mCAN1TXDSR5_DB2:    equ    %00000100
mCAN1TXDSR5_DB3:    equ    %00001000
mCAN1TXDSR5_DB4:    equ    %00010000
mCAN1TXDSR5_DB5:    equ    %00100000
mCAN1TXDSR5_DB6:    equ    %01000000
mCAN1TXDSR5_DB7:    equ    %10000000


;*** CAN1TXDSR6 - MSCAN 1 Transmit Data Segment Register 6; 0x000001BA ***
CAN1TXDSR6:         equ    $000001BA                                ;*** CAN1TXDSR6 - MSCAN 1 Transmit Data Segment Register 6; 0x000001BA ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1TXDSR6_DB0:     equ    0                                         ; Data Bit 0
CAN1TXDSR6_DB1:     equ    1                                         ; Data Bit 1
CAN1TXDSR6_DB2:     equ    2                                         ; Data Bit 2
CAN1TXDSR6_DB3:     equ    3                                         ; Data Bit 3
CAN1TXDSR6_DB4:     equ    4                                         ; Data Bit 4
CAN1TXDSR6_DB5:     equ    5                                         ; Data Bit 5
CAN1TXDSR6_DB6:     equ    6                                         ; Data Bit 6
CAN1TXDSR6_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN1TXDSR6_DB0:    equ    %00000001
mCAN1TXDSR6_DB1:    equ    %00000010
mCAN1TXDSR6_DB2:    equ    %00000100
mCAN1TXDSR6_DB3:    equ    %00001000
mCAN1TXDSR6_DB4:    equ    %00010000
mCAN1TXDSR6_DB5:    equ    %00100000
mCAN1TXDSR6_DB6:    equ    %01000000
mCAN1TXDSR6_DB7:    equ    %10000000


;*** CAN1TXDSR7 - MSCAN 1 Transmit Data Segment Register 7; 0x000001BB ***
CAN1TXDSR7:         equ    $000001BB                                ;*** CAN1TXDSR7 - MSCAN 1 Transmit Data Segment Register 7; 0x000001BB ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1TXDSR7_DB0:     equ    0                                         ; Data Bit 0
CAN1TXDSR7_DB1:     equ    1                                         ; Data Bit 1
CAN1TXDSR7_DB2:     equ    2                                         ; Data Bit 2
CAN1TXDSR7_DB3:     equ    3                                         ; Data Bit 3
CAN1TXDSR7_DB4:     equ    4                                         ; Data Bit 4
CAN1TXDSR7_DB5:     equ    5                                         ; Data Bit 5
CAN1TXDSR7_DB6:     equ    6                                         ; Data Bit 6
CAN1TXDSR7_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN1TXDSR7_DB0:    equ    %00000001
mCAN1TXDSR7_DB1:    equ    %00000010
mCAN1TXDSR7_DB2:    equ    %00000100
mCAN1TXDSR7_DB3:    equ    %00001000
mCAN1TXDSR7_DB4:    equ    %00010000
mCAN1TXDSR7_DB5:    equ    %00100000
mCAN1TXDSR7_DB6:    equ    %01000000
mCAN1TXDSR7_DB7:    equ    %10000000


;*** CAN1TXDLR - MSCAN 1 Transmit Data Length Register; 0x000001BC ***
CAN1TXDLR:          equ    $000001BC                                ;*** CAN1TXDLR - MSCAN 1 Transmit Data Length Register; 0x000001BC ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1TXDLR_DLC0:     equ    0                                         ; Data Length Code Bit 0
CAN1TXDLR_DLC1:     equ    1                                         ; Data Length Code Bit 1
CAN1TXDLR_DLC2:     equ    2                                         ; Data Length Code Bit 2
CAN1TXDLR_DLC3:     equ    3                                         ; Data Length Code Bit 3
; bit position masks
mCAN1TXDLR_DLC0:    equ    %00000001
mCAN1TXDLR_DLC1:    equ    %00000010
mCAN1TXDLR_DLC2:    equ    %00000100
mCAN1TXDLR_DLC3:    equ    %00001000


;*** CAN1TXTBPR - MSCAN 1 Transmit Buffer Priority; 0x000001BD ***
CAN1TXTBPR:         equ    $000001BD                                ;*** CAN1TXTBPR - MSCAN 1 Transmit Buffer Priority; 0x000001BD ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1TXTBPR_PRIO0:   equ    0                                         ; Transmit Buffer Priority Bit 0
CAN1TXTBPR_PRIO1:   equ    1                                         ; Transmit Buffer Priority Bit 1
CAN1TXTBPR_PRIO2:   equ    2                                         ; Transmit Buffer Priority Bit 2
CAN1TXTBPR_PRIO3:   equ    3                                         ; Transmit Buffer Priority Bit 3
CAN1TXTBPR_PRIO4:   equ    4                                         ; Transmit Buffer Priority Bit 4
CAN1TXTBPR_PRIO5:   equ    5                                         ; Transmit Buffer Priority Bit 5
CAN1TXTBPR_PRIO6:   equ    6                                         ; Transmit Buffer Priority Bit 6
CAN1TXTBPR_PRIO7:   equ    7                                         ; Transmit Buffer Priority Bit 7
; bit position masks
mCAN1TXTBPR_PRIO0:  equ    %00000001
mCAN1TXTBPR_PRIO1:  equ    %00000010
mCAN1TXTBPR_PRIO2:  equ    %00000100
mCAN1TXTBPR_PRIO3:  equ    %00001000
mCAN1TXTBPR_PRIO4:  equ    %00010000
mCAN1TXTBPR_PRIO5:  equ    %00100000
mCAN1TXTBPR_PRIO6:  equ    %01000000
mCAN1TXTBPR_PRIO7:  equ    %10000000


;*** CAN1TXTSR - MSCAN 1 Transmit Time Stamp Register; 0x000001BE ***
CAN1TXTSR:          equ    $000001BE                                ;*** CAN1TXTSR - MSCAN 1 Transmit Time Stamp Register; 0x000001BE ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1TXTSR_TSR0:     equ    0                                         ; Time Stamp Bit 0
CAN1TXTSR_TSR1:     equ    1                                         ; Time Stamp Bit 1
CAN1TXTSR_TSR2:     equ    2                                         ; Time Stamp Bit 2
CAN1TXTSR_TSR3:     equ    3                                         ; Time Stamp Bit 3
CAN1TXTSR_TSR4:     equ    4                                         ; Time Stamp Bit 4
CAN1TXTSR_TSR5:     equ    5                                         ; Time Stamp Bit 5
CAN1TXTSR_TSR6:     equ    6                                         ; Time Stamp Bit 6
CAN1TXTSR_TSR7:     equ    7                                         ; Time Stamp Bit 7
CAN1TXTSR_TSR8:     equ    8                                         ; Time Stamp Bit 8
CAN1TXTSR_TSR9:     equ    9                                         ; Time Stamp Bit 9
CAN1TXTSR_TSR10:    equ    10                                        ; Time Stamp Bit 10
CAN1TXTSR_TSR11:    equ    11                                        ; Time Stamp Bit 11
CAN1TXTSR_TSR12:    equ    12                                        ; Time Stamp Bit 12
CAN1TXTSR_TSR13:    equ    13                                        ; Time Stamp Bit 13
CAN1TXTSR_TSR14:    equ    14                                        ; Time Stamp Bit 14
CAN1TXTSR_TSR15:    equ    15                                        ; Time Stamp Bit 15
; bit position masks
mCAN1TXTSR_TSR0:    equ    %00000001
mCAN1TXTSR_TSR1:    equ    %00000010
mCAN1TXTSR_TSR2:    equ    %00000100
mCAN1TXTSR_TSR3:    equ    %00001000
mCAN1TXTSR_TSR4:    equ    %00010000
mCAN1TXTSR_TSR5:    equ    %00100000
mCAN1TXTSR_TSR6:    equ    %01000000
mCAN1TXTSR_TSR7:    equ    %10000000
mCAN1TXTSR_TSR8:    equ    %100000000
mCAN1TXTSR_TSR9:    equ    %1000000000
mCAN1TXTSR_TSR10:   equ    %10000000000
mCAN1TXTSR_TSR11:   equ    %100000000000
mCAN1TXTSR_TSR12:   equ    %1000000000000
mCAN1TXTSR_TSR13:   equ    %10000000000000
mCAN1TXTSR_TSR14:   equ    %100000000000000
mCAN1TXTSR_TSR15:   equ    %1000000000000000


;*** CAN1TXTSRH - MSCAN 1 Transmit Time Stamp Register High; 0x000001BE ***
CAN1TXTSRH:         equ    $000001BE                                ;*** CAN1TXTSRH - MSCAN 1 Transmit Time Stamp Register High; 0x000001BE ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1TXTSRH_TSR8:    equ    0                                         ; Time Stamp Bit 8
CAN1TXTSRH_TSR9:    equ    1                                         ; Time Stamp Bit 9
CAN1TXTSRH_TSR10:   equ    2                                         ; Time Stamp Bit 10
CAN1TXTSRH_TSR11:   equ    3                                         ; Time Stamp Bit 11
CAN1TXTSRH_TSR12:   equ    4                                         ; Time Stamp Bit 12
CAN1TXTSRH_TSR13:   equ    5                                         ; Time Stamp Bit 13
CAN1TXTSRH_TSR14:   equ    6                                         ; Time Stamp Bit 14
CAN1TXTSRH_TSR15:   equ    7                                         ; Time Stamp Bit 15
; bit position masks
mCAN1TXTSRH_TSR8:   equ    %00000001
mCAN1TXTSRH_TSR9:   equ    %00000010
mCAN1TXTSRH_TSR10:  equ    %00000100
mCAN1TXTSRH_TSR11:  equ    %00001000
mCAN1TXTSRH_TSR12:  equ    %00010000
mCAN1TXTSRH_TSR13:  equ    %00100000
mCAN1TXTSRH_TSR14:  equ    %01000000
mCAN1TXTSRH_TSR15:  equ    %10000000


;*** CAN1TXTSRL - MSCAN 1 Transmit Time Stamp Register Low; 0x000001BF ***
CAN1TXTSRL:         equ    $000001BF                                ;*** CAN1TXTSRL - MSCAN 1 Transmit Time Stamp Register Low; 0x000001BF ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1TXTSRL_TSR0:    equ    0                                         ; Time Stamp Bit 0
CAN1TXTSRL_TSR1:    equ    1                                         ; Time Stamp Bit 1
CAN1TXTSRL_TSR2:    equ    2                                         ; Time Stamp Bit 2
CAN1TXTSRL_TSR3:    equ    3                                         ; Time Stamp Bit 3
CAN1TXTSRL_TSR4:    equ    4                                         ; Time Stamp Bit 4
CAN1TXTSRL_TSR5:    equ    5                                         ; Time Stamp Bit 5
CAN1TXTSRL_TSR6:    equ    6                                         ; Time Stamp Bit 6
CAN1TXTSRL_TSR7:    equ    7                                         ; Time Stamp Bit 7
; bit position masks
mCAN1TXTSRL_TSR0:   equ    %00000001
mCAN1TXTSRL_TSR1:   equ    %00000010
mCAN1TXTSRL_TSR2:   equ    %00000100
mCAN1TXTSRL_TSR3:   equ    %00001000
mCAN1TXTSRL_TSR4:   equ    %00010000
mCAN1TXTSRL_TSR5:   equ    %00100000
mCAN1TXTSRL_TSR6:   equ    %01000000
mCAN1TXTSRL_TSR7:   equ    %10000000


;*** MCCTL0 - Motor Controller Control Register 0; 0x000001C0 ***
MCCTL0:             equ    $000001C0                                ;*** MCCTL0 - Motor Controller Control Register 0; 0x000001C0 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MCCTL0_MCTOIF:      equ    0                                         ; Motor Controller Timer Counter Overflow Interrupt Flag
MCCTL0_DITH:        equ    2                                         ; Motor Control/Driver dither feature enable
MCCTL0_FAST:        equ    3                                         ; Motor Controller PWM resolution mode
MCCTL0_MCSWAI:      equ    4                                         ; Motor Controller Module Stop in WAIT Mode
MCCTL0_MCPRE0:      equ    5                                         ; Motor Controller Prescaler Select Bit 0
MCCTL0_MCPRE1:      equ    6                                         ; Motor Controller Prescaler Select Bit 1
; bit position masks
mMCCTL0_MCTOIF:     equ    %00000001
mMCCTL0_DITH:       equ    %00000100
mMCCTL0_FAST:       equ    %00001000
mMCCTL0_MCSWAI:     equ    %00010000
mMCCTL0_MCPRE0:     equ    %00100000
mMCCTL0_MCPRE1:     equ    %01000000


;*** MCCTL1 - Motor Controller Control Register 1; 0x000001C1 ***
MCCTL1:             equ    $000001C1                                ;*** MCCTL1 - Motor Controller Control Register 1; 0x000001C1 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MCCTL1_MCTOIE:      equ    0                                         ; Motor Controller Timer Counter Overflow Interrupt Enable
MCCTL1_RECIRC:      equ    7                                         ; Recirculation in (Dual) Full H-bridge mode
; bit position masks
mMCCTL1_MCTOIE:     equ    %00000001
mMCCTL1_RECIRC:     equ    %10000000


;*** MCPER - Motor Controller Period Register, with DITH = 0; 0x000001C2 ***
MCPER:              equ    $000001C2                                ;*** MCPER - Motor Controller Period Register, with DITH = 0; 0x000001C2 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MCPER_P0:           equ    0                                         ; Motor Controller Period Bit 0
MCPER_P1:           equ    1                                         ; Motor Controller Period Bit 1
MCPER_P2:           equ    2                                         ; Motor Controller Period Bit 2
MCPER_P3:           equ    3                                         ; Motor Controller Period Bit 3
MCPER_P4:           equ    4                                         ; Motor Controller Period Bit 4
MCPER_P5:           equ    5                                         ; Motor Controller Period Bit 5
MCPER_P6:           equ    6                                         ; Motor Controller Period Bit 6
MCPER_P7:           equ    7                                         ; Motor Controller Period Bit 7
MCPER_P8:           equ    8                                         ; Motor Controller Period Bit 8
MCPER_P9:           equ    9                                         ; Motor Controller Period Bit 9
MCPER_P10:          equ    10                                        ; Motor Controller Period Bit 10
; bit position masks
mMCPER_P0:          equ    %00000001
mMCPER_P1:          equ    %00000010
mMCPER_P2:          equ    %00000100
mMCPER_P3:          equ    %00001000
mMCPER_P4:          equ    %00010000
mMCPER_P5:          equ    %00100000
mMCPER_P6:          equ    %01000000
mMCPER_P7:          equ    %10000000
mMCPER_P8:          equ    %100000000
mMCPER_P9:          equ    %1000000000
mMCPER_P10:         equ    %10000000000


;*** MCCC0 - Motor Controller Control Register Channel 0; 0x000001D0 ***
MCCC0:              equ    $000001D0                                ;*** MCCC0 - Motor Controller Control Register Channel 0; 0x000001D0 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MCCC0_CD0:          equ    0                                         ; PWM Channel Delay Bit 0
MCCC0_CD1:          equ    1                                         ; PWM Channel Delay Bit 1
MCCC0_MCAM0:        equ    4                                         ; PWM Channel Alignment Mode Bit 0
MCCC0_MCAM1:        equ    5                                         ; PWM Channel Alignment Mode Bit 1
MCCC0_MCOM0:        equ    6                                         ; Output Mode Bit 0
MCCC0_MCOM1:        equ    7                                         ; Output Mode Bit 1
; bit position masks
mMCCC0_CD0:         equ    %00000001
mMCCC0_CD1:         equ    %00000010
mMCCC0_MCAM0:       equ    %00010000
mMCCC0_MCAM1:       equ    %00100000
mMCCC0_MCOM0:       equ    %01000000
mMCCC0_MCOM1:       equ    %10000000


;*** MCCC1 - Motor Controller Control Register Channel 1; 0x000001D1 ***
MCCC1:              equ    $000001D1                                ;*** MCCC1 - Motor Controller Control Register Channel 1; 0x000001D1 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MCCC1_CD0:          equ    0                                         ; PWM Channel Delay Bit 0
MCCC1_CD1:          equ    1                                         ; PWM Channel Delay Bit 1
MCCC1_MCAM0:        equ    4                                         ; PWM Channel Alignment Mode Bit 0
MCCC1_MCAM1:        equ    5                                         ; PWM Channel Alignment Mode Bit 1
MCCC1_MCOM0:        equ    6                                         ; Output Mode Bit 0
MCCC1_MCOM1:        equ    7                                         ; Output Mode Bit 1
; bit position masks
mMCCC1_CD0:         equ    %00000001
mMCCC1_CD1:         equ    %00000010
mMCCC1_MCAM0:       equ    %00010000
mMCCC1_MCAM1:       equ    %00100000
mMCCC1_MCOM0:       equ    %01000000
mMCCC1_MCOM1:       equ    %10000000


;*** MCCC2 - Motor Controller Control Register Channel 2; 0x000001D2 ***
MCCC2:              equ    $000001D2                                ;*** MCCC2 - Motor Controller Control Register Channel 2; 0x000001D2 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MCCC2_CD0:          equ    0                                         ; PWM Channel Delay Bit 0
MCCC2_CD1:          equ    1                                         ; PWM Channel Delay Bit 1
MCCC2_MCAM0:        equ    4                                         ; PWM Channel Alignment Mode Bit 0
MCCC2_MCAM1:        equ    5                                         ; PWM Channel Alignment Mode Bit 1
MCCC2_MCOM0:        equ    6                                         ; Output Mode Bit 0
MCCC2_MCOM1:        equ    7                                         ; Output Mode Bit 1
; bit position masks
mMCCC2_CD0:         equ    %00000001
mMCCC2_CD1:         equ    %00000010
mMCCC2_MCAM0:       equ    %00010000
mMCCC2_MCAM1:       equ    %00100000
mMCCC2_MCOM0:       equ    %01000000
mMCCC2_MCOM1:       equ    %10000000


;*** MCCC3 - Motor Controller Control Register Channel 3; 0x000001D3 ***
MCCC3:              equ    $000001D3                                ;*** MCCC3 - Motor Controller Control Register Channel 3; 0x000001D3 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MCCC3_CD0:          equ    0                                         ; PWM Channel Delay Bit 0
MCCC3_CD1:          equ    1                                         ; PWM Channel Delay Bit 1
MCCC3_MCAM0:        equ    4                                         ; PWM Channel Alignment Mode Bit 0
MCCC3_MCAM1:        equ    5                                         ; PWM Channel Alignment Mode Bit 1
MCCC3_MCOM0:        equ    6                                         ; Output Mode Bit 0
MCCC3_MCOM1:        equ    7                                         ; Output Mode Bit 1
; bit position masks
mMCCC3_CD0:         equ    %00000001
mMCCC3_CD1:         equ    %00000010
mMCCC3_MCAM0:       equ    %00010000
mMCCC3_MCAM1:       equ    %00100000
mMCCC3_MCOM0:       equ    %01000000
mMCCC3_MCOM1:       equ    %10000000


;*** MCCC4 - Motor Controller Control Register Channel 4; 0x000001D4 ***
MCCC4:              equ    $000001D4                                ;*** MCCC4 - Motor Controller Control Register Channel 4; 0x000001D4 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MCCC4_CD0:          equ    0                                         ; PWM Channel Delay Bit 0
MCCC4_CD1:          equ    1                                         ; PWM Channel Delay Bit 1
MCCC4_MCAM0:        equ    4                                         ; PWM Channel Alignment Mode Bit 0
MCCC4_MCAM1:        equ    5                                         ; PWM Channel Alignment Mode Bit 1
MCCC4_MCOM0:        equ    6                                         ; Output Mode Bit 0
MCCC4_MCOM1:        equ    7                                         ; Output Mode Bit 1
; bit position masks
mMCCC4_CD0:         equ    %00000001
mMCCC4_CD1:         equ    %00000010
mMCCC4_MCAM0:       equ    %00010000
mMCCC4_MCAM1:       equ    %00100000
mMCCC4_MCOM0:       equ    %01000000
mMCCC4_MCOM1:       equ    %10000000


;*** MCCC5 - Motor Controller Control Register Channel 5; 0x000001D5 ***
MCCC5:              equ    $000001D5                                ;*** MCCC5 - Motor Controller Control Register Channel 5; 0x000001D5 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MCCC5_CD0:          equ    0                                         ; PWM Channel Delay Bit 0
MCCC5_CD1:          equ    1                                         ; PWM Channel Delay Bit 1
MCCC5_MCAM0:        equ    4                                         ; PWM Channel Alignment Mode Bit 0
MCCC5_MCAM1:        equ    5                                         ; PWM Channel Alignment Mode Bit 1
MCCC5_MCOM0:        equ    6                                         ; Output Mode Bit 0
MCCC5_MCOM1:        equ    7                                         ; Output Mode Bit 1
; bit position masks
mMCCC5_CD0:         equ    %00000001
mMCCC5_CD1:         equ    %00000010
mMCCC5_MCAM0:       equ    %00010000
mMCCC5_MCAM1:       equ    %00100000
mMCCC5_MCOM0:       equ    %01000000
mMCCC5_MCOM1:       equ    %10000000


;*** MCCC6 - Motor Controller Control Register Channel 6; 0x000001D6 ***
MCCC6:              equ    $000001D6                                ;*** MCCC6 - Motor Controller Control Register Channel 6; 0x000001D6 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MCCC6_CD0:          equ    0                                         ; PWM Channel Delay Bit 0
MCCC6_CD1:          equ    1                                         ; PWM Channel Delay Bit 1
MCCC6_MCAM0:        equ    4                                         ; PWM Channel Alignment Mode Bit 0
MCCC6_MCAM1:        equ    5                                         ; PWM Channel Alignment Mode Bit 1
MCCC6_MCOM0:        equ    6                                         ; Output Mode Bit 0
MCCC6_MCOM1:        equ    7                                         ; Output Mode Bit 1
; bit position masks
mMCCC6_CD0:         equ    %00000001
mMCCC6_CD1:         equ    %00000010
mMCCC6_MCAM0:       equ    %00010000
mMCCC6_MCAM1:       equ    %00100000
mMCCC6_MCOM0:       equ    %01000000
mMCCC6_MCOM1:       equ    %10000000


;*** MCCC7 - Motor Controller Control Register Channel 7; 0x000001D7 ***
MCCC7:              equ    $000001D7                                ;*** MCCC7 - Motor Controller Control Register Channel 7; 0x000001D7 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MCCC7_CD0:          equ    0                                         ; PWM Channel Delay Bit 0
MCCC7_CD1:          equ    1                                         ; PWM Channel Delay Bit 1
MCCC7_MCAM0:        equ    4                                         ; PWM Channel Alignment Mode Bit 0
MCCC7_MCAM1:        equ    5                                         ; PWM Channel Alignment Mode Bit 1
MCCC7_MCOM0:        equ    6                                         ; Output Mode Bit 0
MCCC7_MCOM1:        equ    7                                         ; Output Mode Bit 1
; bit position masks
mMCCC7_CD0:         equ    %00000001
mMCCC7_CD1:         equ    %00000010
mMCCC7_MCAM0:       equ    %00010000
mMCCC7_MCAM1:       equ    %00100000
mMCCC7_MCOM0:       equ    %01000000
mMCCC7_MCOM1:       equ    %10000000


;*** MCDC0 - Motor Controller Duty Cycle Register 0; 0x000001E0 ***
MCDC0:              equ    $000001E0                                ;*** MCDC0 - Motor Controller Duty Cycle Register 0; 0x000001E0 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MCDC0_D0:           equ    0                                         ; Motor Controller Duty Cycle Bit 0
MCDC0_D1:           equ    1                                         ; Motor Controller Duty Cycle Bit 1
MCDC0_D2:           equ    2                                         ; Motor Controller Duty Cycle Bit 2
MCDC0_D3:           equ    3                                         ; Motor Controller Duty Cycle Bit 3
MCDC0_D4:           equ    4                                         ; Motor Controller Duty Cycle Bit 4
MCDC0_D5:           equ    5                                         ; Motor Controller Duty Cycle Bit 5
MCDC0_D6:           equ    6                                         ; Motor Controller Duty Cycle Bit 6
MCDC0_D7:           equ    7                                         ; Motor Controller Duty Cycle Bit 7
MCDC0_D8:           equ    8                                         ; Motor Controller Duty Cycle Bit 8
MCDC0_D9:           equ    9                                         ; Motor Controller Duty Cycle Bit 9
MCDC0_D10:          equ    10                                        ; Motor Controller Duty Cycle Bit 10
MCDC0_S:            equ    15                                        ; Sign
; bit position masks
mMCDC0_D0:          equ    %00000001
mMCDC0_D1:          equ    %00000010
mMCDC0_D2:          equ    %00000100
mMCDC0_D3:          equ    %00001000
mMCDC0_D4:          equ    %00010000
mMCDC0_D5:          equ    %00100000
mMCDC0_D6:          equ    %01000000
mMCDC0_D7:          equ    %10000000
mMCDC0_D8:          equ    %100000000
mMCDC0_D9:          equ    %1000000000
mMCDC0_D10:         equ    %10000000000
mMCDC0_S:           equ    %1000000000000000


;*** MCDC0_FAST - Motor Controller Period Register 0 access with FAST bit = 1; 0x000001E0 ***
MCDC0_FAST:         equ    $000001E0                                ;*** MCDC0_FAST - Motor Controller Period Register 0 access with FAST bit = 1; 0x000001E0 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MCDC0_FAST_D2:      equ    0                                         ; Motor Controller Duty Cycle, bit 2
MCDC0_FAST_D3:      equ    1                                         ; Motor Controller Duty Cycle, bit 3
MCDC0_FAST_D4:      equ    2                                         ; Motor Controller Duty Cycle, bit 4
MCDC0_FAST_D5:      equ    3                                         ; Motor Controller Duty Cycle, bit 5
MCDC0_FAST_D6:      equ    4                                         ; Motor Controller Duty Cycle, bit 6
MCDC0_FAST_D7:      equ    5                                         ; Motor Controller Duty Cycle, bit 7
MCDC0_FAST_D8:      equ    6                                         ; Motor Controller Duty Cycle, bit 8
MCDC0_FAST_S:       equ    7                                         ; Sign
; bit position masks
mMCDC0_FAST_D2:     equ    %00000001
mMCDC0_FAST_D3:     equ    %00000010
mMCDC0_FAST_D4:     equ    %00000100
mMCDC0_FAST_D5:     equ    %00001000
mMCDC0_FAST_D6:     equ    %00010000
mMCDC0_FAST_D7:     equ    %00100000
mMCDC0_FAST_D8:     equ    %01000000
mMCDC0_FAST_S:      equ    %10000000


;*** MCDC1 - Motor Controller Duty Cycle Register 1; 0x000001E2 ***
MCDC1:              equ    $000001E2                                ;*** MCDC1 - Motor Controller Duty Cycle Register 1; 0x000001E2 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MCDC1_D0:           equ    0                                         ; Motor Controller Duty Cycle Bit 0
MCDC1_D1:           equ    1                                         ; Motor Controller Duty Cycle Bit 1
MCDC1_D2:           equ    2                                         ; Motor Controller Duty Cycle Bit 2
MCDC1_D3:           equ    3                                         ; Motor Controller Duty Cycle Bit 3
MCDC1_D4:           equ    4                                         ; Motor Controller Duty Cycle Bit 4
MCDC1_D5:           equ    5                                         ; Motor Controller Duty Cycle Bit 5
MCDC1_D6:           equ    6                                         ; Motor Controller Duty Cycle Bit 6
MCDC1_D7:           equ    7                                         ; Motor Controller Duty Cycle Bit 7
MCDC1_D8:           equ    8                                         ; Motor Controller Duty Cycle Bit 8
MCDC1_D9:           equ    9                                         ; Motor Controller Duty Cycle Bit 9
MCDC1_D10:          equ    10                                        ; Motor Controller Duty Cycle Bit 10
MCDC1_S:            equ    15                                        ; Sign
; bit position masks
mMCDC1_D0:          equ    %00000001
mMCDC1_D1:          equ    %00000010
mMCDC1_D2:          equ    %00000100
mMCDC1_D3:          equ    %00001000
mMCDC1_D4:          equ    %00010000
mMCDC1_D5:          equ    %00100000
mMCDC1_D6:          equ    %01000000
mMCDC1_D7:          equ    %10000000
mMCDC1_D8:          equ    %100000000
mMCDC1_D9:          equ    %1000000000
mMCDC1_D10:         equ    %10000000000
mMCDC1_S:           equ    %1000000000000000


;*** MCDC1_FAST - Motor Controller Period Register 1 access with FAST bit = 1; 0x000001E2 ***
MCDC1_FAST:         equ    $000001E2                                ;*** MCDC1_FAST - Motor Controller Period Register 1 access with FAST bit = 1; 0x000001E2 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MCDC1_FAST_D2:      equ    0                                         ; Motor Controller Duty Cycle, bit 2
MCDC1_FAST_D3:      equ    1                                         ; Motor Controller Duty Cycle, bit 3
MCDC1_FAST_D4:      equ    2                                         ; Motor Controller Duty Cycle, bit 4
MCDC1_FAST_D5:      equ    3                                         ; Motor Controller Duty Cycle, bit 5
MCDC1_FAST_D6:      equ    4                                         ; Motor Controller Duty Cycle, bit 6
MCDC1_FAST_D7:      equ    5                                         ; Motor Controller Duty Cycle, bit 7
MCDC1_FAST_D8:      equ    6                                         ; Motor Controller Duty Cycle, bit 8
MCDC1_FAST_S:       equ    7                                         ; Sign
; bit position masks
mMCDC1_FAST_D2:     equ    %00000001
mMCDC1_FAST_D3:     equ    %00000010
mMCDC1_FAST_D4:     equ    %00000100
mMCDC1_FAST_D5:     equ    %00001000
mMCDC1_FAST_D6:     equ    %00010000
mMCDC1_FAST_D7:     equ    %00100000
mMCDC1_FAST_D8:     equ    %01000000
mMCDC1_FAST_S:      equ    %10000000


;*** MCDC2 - Motor Controller Duty Cycle Register 2; 0x000001E4 ***
MCDC2:              equ    $000001E4                                ;*** MCDC2 - Motor Controller Duty Cycle Register 2; 0x000001E4 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MCDC2_D0:           equ    0                                         ; Motor Controller Duty Cycle Bit 0
MCDC2_D1:           equ    1                                         ; Motor Controller Duty Cycle Bit 1
MCDC2_D2:           equ    2                                         ; Motor Controller Duty Cycle Bit 2
MCDC2_D3:           equ    3                                         ; Motor Controller Duty Cycle Bit 3
MCDC2_D4:           equ    4                                         ; Motor Controller Duty Cycle Bit 4
MCDC2_D5:           equ    5                                         ; Motor Controller Duty Cycle Bit 5
MCDC2_D6:           equ    6                                         ; Motor Controller Duty Cycle Bit 6
MCDC2_D7:           equ    7                                         ; Motor Controller Duty Cycle Bit 7
MCDC2_D8:           equ    8                                         ; Motor Controller Duty Cycle Bit 8
MCDC2_D9:           equ    9                                         ; Motor Controller Duty Cycle Bit 9
MCDC2_D10:          equ    10                                        ; Motor Controller Duty Cycle Bit 10
MCDC2_S:            equ    15                                        ; Sign
; bit position masks
mMCDC2_D0:          equ    %00000001
mMCDC2_D1:          equ    %00000010
mMCDC2_D2:          equ    %00000100
mMCDC2_D3:          equ    %00001000
mMCDC2_D4:          equ    %00010000
mMCDC2_D5:          equ    %00100000
mMCDC2_D6:          equ    %01000000
mMCDC2_D7:          equ    %10000000
mMCDC2_D8:          equ    %100000000
mMCDC2_D9:          equ    %1000000000
mMCDC2_D10:         equ    %10000000000
mMCDC2_S:           equ    %1000000000000000


;*** MCDC2_FAST - Motor Controller Period Register 2 access with FAST bit = 1; 0x000001E4 ***
MCDC2_FAST:         equ    $000001E4                                ;*** MCDC2_FAST - Motor Controller Period Register 2 access with FAST bit = 1; 0x000001E4 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MCDC2_FAST_D2:      equ    0                                         ; Motor Controller Duty Cycle, bit 2
MCDC2_FAST_D3:      equ    1                                         ; Motor Controller Duty Cycle, bit 3
MCDC2_FAST_D4:      equ    2                                         ; Motor Controller Duty Cycle, bit 4
MCDC2_FAST_D5:      equ    3                                         ; Motor Controller Duty Cycle, bit 5
MCDC2_FAST_D6:      equ    4                                         ; Motor Controller Duty Cycle, bit 6
MCDC2_FAST_D7:      equ    5                                         ; Motor Controller Duty Cycle, bit 7
MCDC2_FAST_D8:      equ    6                                         ; Motor Controller Duty Cycle, bit 8
MCDC2_FAST_S:       equ    7                                         ; Sign
; bit position masks
mMCDC2_FAST_D2:     equ    %00000001
mMCDC2_FAST_D3:     equ    %00000010
mMCDC2_FAST_D4:     equ    %00000100
mMCDC2_FAST_D5:     equ    %00001000
mMCDC2_FAST_D6:     equ    %00010000
mMCDC2_FAST_D7:     equ    %00100000
mMCDC2_FAST_D8:     equ    %01000000
mMCDC2_FAST_S:      equ    %10000000


;*** MCDC3 - Motor Controller Duty Cycle Register 3; 0x000001E6 ***
MCDC3:              equ    $000001E6                                ;*** MCDC3 - Motor Controller Duty Cycle Register 3; 0x000001E6 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MCDC3_D0:           equ    0                                         ; Motor Controller Duty Cycle Bit 0
MCDC3_D1:           equ    1                                         ; Motor Controller Duty Cycle Bit 1
MCDC3_D2:           equ    2                                         ; Motor Controller Duty Cycle Bit 2
MCDC3_D3:           equ    3                                         ; Motor Controller Duty Cycle Bit 3
MCDC3_D4:           equ    4                                         ; Motor Controller Duty Cycle Bit 4
MCDC3_D5:           equ    5                                         ; Motor Controller Duty Cycle Bit 5
MCDC3_D6:           equ    6                                         ; Motor Controller Duty Cycle Bit 6
MCDC3_D7:           equ    7                                         ; Motor Controller Duty Cycle Bit 7
MCDC3_D8:           equ    8                                         ; Motor Controller Duty Cycle Bit 8
MCDC3_D9:           equ    9                                         ; Motor Controller Duty Cycle Bit 9
MCDC3_D10:          equ    10                                        ; Motor Controller Duty Cycle Bit 10
MCDC3_S:            equ    15                                        ; Sign
; bit position masks
mMCDC3_D0:          equ    %00000001
mMCDC3_D1:          equ    %00000010
mMCDC3_D2:          equ    %00000100
mMCDC3_D3:          equ    %00001000
mMCDC3_D4:          equ    %00010000
mMCDC3_D5:          equ    %00100000
mMCDC3_D6:          equ    %01000000
mMCDC3_D7:          equ    %10000000
mMCDC3_D8:          equ    %100000000
mMCDC3_D9:          equ    %1000000000
mMCDC3_D10:         equ    %10000000000
mMCDC3_S:           equ    %1000000000000000


;*** MCDC3_FAST - Motor Controller Period Register 3 access with FAST bit = 1; 0x000001E6 ***
MCDC3_FAST:         equ    $000001E6                                ;*** MCDC3_FAST - Motor Controller Period Register 3 access with FAST bit = 1; 0x000001E6 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MCDC3_FAST_D2:      equ    0                                         ; Motor Controller Duty Cycle, bit 2
MCDC3_FAST_D3:      equ    1                                         ; Motor Controller Duty Cycle, bit 3
MCDC3_FAST_D4:      equ    2                                         ; Motor Controller Duty Cycle, bit 4
MCDC3_FAST_D5:      equ    3                                         ; Motor Controller Duty Cycle, bit 5
MCDC3_FAST_D6:      equ    4                                         ; Motor Controller Duty Cycle, bit 6
MCDC3_FAST_D7:      equ    5                                         ; Motor Controller Duty Cycle, bit 7
MCDC3_FAST_D8:      equ    6                                         ; Motor Controller Duty Cycle, bit 8
MCDC3_FAST_S:       equ    7                                         ; Sign
; bit position masks
mMCDC3_FAST_D2:     equ    %00000001
mMCDC3_FAST_D3:     equ    %00000010
mMCDC3_FAST_D4:     equ    %00000100
mMCDC3_FAST_D5:     equ    %00001000
mMCDC3_FAST_D6:     equ    %00010000
mMCDC3_FAST_D7:     equ    %00100000
mMCDC3_FAST_D8:     equ    %01000000
mMCDC3_FAST_S:      equ    %10000000


;*** MCDC4 - Motor Controller Duty Cycle Register 4; 0x000001E8 ***
MCDC4:              equ    $000001E8                                ;*** MCDC4 - Motor Controller Duty Cycle Register 4; 0x000001E8 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MCDC4_D0:           equ    0                                         ; Motor Controller Duty Cycle Bit 0
MCDC4_D1:           equ    1                                         ; Motor Controller Duty Cycle Bit 1
MCDC4_D2:           equ    2                                         ; Motor Controller Duty Cycle Bit 2
MCDC4_D3:           equ    3                                         ; Motor Controller Duty Cycle Bit 3
MCDC4_D4:           equ    4                                         ; Motor Controller Duty Cycle Bit 4
MCDC4_D5:           equ    5                                         ; Motor Controller Duty Cycle Bit 5
MCDC4_D6:           equ    6                                         ; Motor Controller Duty Cycle Bit 6
MCDC4_D7:           equ    7                                         ; Motor Controller Duty Cycle Bit 7
MCDC4_D8:           equ    8                                         ; Motor Controller Duty Cycle Bit 8
MCDC4_D9:           equ    9                                         ; Motor Controller Duty Cycle Bit 9
MCDC4_D10:          equ    10                                        ; Motor Controller Duty Cycle Bit 10
MCDC4_S:            equ    15                                        ; Sign
; bit position masks
mMCDC4_D0:          equ    %00000001
mMCDC4_D1:          equ    %00000010
mMCDC4_D2:          equ    %00000100
mMCDC4_D3:          equ    %00001000
mMCDC4_D4:          equ    %00010000
mMCDC4_D5:          equ    %00100000
mMCDC4_D6:          equ    %01000000
mMCDC4_D7:          equ    %10000000
mMCDC4_D8:          equ    %100000000
mMCDC4_D9:          equ    %1000000000
mMCDC4_D10:         equ    %10000000000
mMCDC4_S:           equ    %1000000000000000


;*** MCDC4_FAST - Motor Controller Period Register 4 access with FAST bit = 1; 0x000001E8 ***
MCDC4_FAST:         equ    $000001E8                                ;*** MCDC4_FAST - Motor Controller Period Register 4 access with FAST bit = 1; 0x000001E8 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MCDC4_FAST_D2:      equ    0                                         ; Motor Controller Duty Cycle, bit 2
MCDC4_FAST_D3:      equ    1                                         ; Motor Controller Duty Cycle, bit 3
MCDC4_FAST_D4:      equ    2                                         ; Motor Controller Duty Cycle, bit 4
MCDC4_FAST_D5:      equ    3                                         ; Motor Controller Duty Cycle, bit 5
MCDC4_FAST_D6:      equ    4                                         ; Motor Controller Duty Cycle, bit 6
MCDC4_FAST_D7:      equ    5                                         ; Motor Controller Duty Cycle, bit 7
MCDC4_FAST_D8:      equ    6                                         ; Motor Controller Duty Cycle, bit 8
MCDC4_FAST_S:       equ    7                                         ; Sign
; bit position masks
mMCDC4_FAST_D2:     equ    %00000001
mMCDC4_FAST_D3:     equ    %00000010
mMCDC4_FAST_D4:     equ    %00000100
mMCDC4_FAST_D5:     equ    %00001000
mMCDC4_FAST_D6:     equ    %00010000
mMCDC4_FAST_D7:     equ    %00100000
mMCDC4_FAST_D8:     equ    %01000000
mMCDC4_FAST_S:      equ    %10000000


;*** MCDC5 - Motor Controller Duty Cycle Register 5; 0x000001EA ***
MCDC5:              equ    $000001EA                                ;*** MCDC5 - Motor Controller Duty Cycle Register 5; 0x000001EA ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MCDC5_D0:           equ    0                                         ; Motor Controller Duty Cycle Bit 0
MCDC5_D1:           equ    1                                         ; Motor Controller Duty Cycle Bit 1
MCDC5_D2:           equ    2                                         ; Motor Controller Duty Cycle Bit 2
MCDC5_D3:           equ    3                                         ; Motor Controller Duty Cycle Bit 3
MCDC5_D4:           equ    4                                         ; Motor Controller Duty Cycle Bit 4
MCDC5_D5:           equ    5                                         ; Motor Controller Duty Cycle Bit 5
MCDC5_D6:           equ    6                                         ; Motor Controller Duty Cycle Bit 6
MCDC5_D7:           equ    7                                         ; Motor Controller Duty Cycle Bit 7
MCDC5_D8:           equ    8                                         ; Motor Controller Duty Cycle Bit 8
MCDC5_D9:           equ    9                                         ; Motor Controller Duty Cycle Bit 9
MCDC5_D10:          equ    10                                        ; Motor Controller Duty Cycle Bit 10
MCDC5_S:            equ    15                                        ; Sign
; bit position masks
mMCDC5_D0:          equ    %00000001
mMCDC5_D1:          equ    %00000010
mMCDC5_D2:          equ    %00000100
mMCDC5_D3:          equ    %00001000
mMCDC5_D4:          equ    %00010000
mMCDC5_D5:          equ    %00100000
mMCDC5_D6:          equ    %01000000
mMCDC5_D7:          equ    %10000000
mMCDC5_D8:          equ    %100000000
mMCDC5_D9:          equ    %1000000000
mMCDC5_D10:         equ    %10000000000
mMCDC5_S:           equ    %1000000000000000


;*** MCDC5_FAST - Motor Controller Period Register 5 access with FAST bit = 1; 0x000001EA ***
MCDC5_FAST:         equ    $000001EA                                ;*** MCDC5_FAST - Motor Controller Period Register 5 access with FAST bit = 1; 0x000001EA ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MCDC5_FAST_D2:      equ    0                                         ; Motor Controller Duty Cycle, bit 2
MCDC5_FAST_D3:      equ    1                                         ; Motor Controller Duty Cycle, bit 3
MCDC5_FAST_D4:      equ    2                                         ; Motor Controller Duty Cycle, bit 4
MCDC5_FAST_D5:      equ    3                                         ; Motor Controller Duty Cycle, bit 5
MCDC5_FAST_D6:      equ    4                                         ; Motor Controller Duty Cycle, bit 6
MCDC5_FAST_D7:      equ    5                                         ; Motor Controller Duty Cycle, bit 7
MCDC5_FAST_D8:      equ    6                                         ; Motor Controller Duty Cycle, bit 8
MCDC5_FAST_S:       equ    7                                         ; Sign
; bit position masks
mMCDC5_FAST_D2:     equ    %00000001
mMCDC5_FAST_D3:     equ    %00000010
mMCDC5_FAST_D4:     equ    %00000100
mMCDC5_FAST_D5:     equ    %00001000
mMCDC5_FAST_D6:     equ    %00010000
mMCDC5_FAST_D7:     equ    %00100000
mMCDC5_FAST_D8:     equ    %01000000
mMCDC5_FAST_S:      equ    %10000000


;*** MCDC6 - Motor Controller Duty Cycle Register 6; 0x000001EC ***
MCDC6:              equ    $000001EC                                ;*** MCDC6 - Motor Controller Duty Cycle Register 6; 0x000001EC ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MCDC6_D0:           equ    0                                         ; Motor Controller Duty Cycle Bit 0
MCDC6_D1:           equ    1                                         ; Motor Controller Duty Cycle Bit 1
MCDC6_D2:           equ    2                                         ; Motor Controller Duty Cycle Bit 2
MCDC6_D3:           equ    3                                         ; Motor Controller Duty Cycle Bit 3
MCDC6_D4:           equ    4                                         ; Motor Controller Duty Cycle Bit 4
MCDC6_D5:           equ    5                                         ; Motor Controller Duty Cycle Bit 5
MCDC6_D6:           equ    6                                         ; Motor Controller Duty Cycle Bit 6
MCDC6_D7:           equ    7                                         ; Motor Controller Duty Cycle Bit 7
MCDC6_D8:           equ    8                                         ; Motor Controller Duty Cycle Bit 8
MCDC6_D9:           equ    9                                         ; Motor Controller Duty Cycle Bit 9
MCDC6_D10:          equ    10                                        ; Motor Controller Duty Cycle Bit 10
MCDC6_S:            equ    15                                        ; Sign
; bit position masks
mMCDC6_D0:          equ    %00000001
mMCDC6_D1:          equ    %00000010
mMCDC6_D2:          equ    %00000100
mMCDC6_D3:          equ    %00001000
mMCDC6_D4:          equ    %00010000
mMCDC6_D5:          equ    %00100000
mMCDC6_D6:          equ    %01000000
mMCDC6_D7:          equ    %10000000
mMCDC6_D8:          equ    %100000000
mMCDC6_D9:          equ    %1000000000
mMCDC6_D10:         equ    %10000000000
mMCDC6_S:           equ    %1000000000000000


;*** MCDC6_FAST - Motor Controller Period Register 6 access with FAST bit = 1; 0x000001EC ***
MCDC6_FAST:         equ    $000001EC                                ;*** MCDC6_FAST - Motor Controller Period Register 6 access with FAST bit = 1; 0x000001EC ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MCDC6_FAST_D2:      equ    0                                         ; Motor Controller Duty Cycle, bit 2
MCDC6_FAST_D3:      equ    1                                         ; Motor Controller Duty Cycle, bit 3
MCDC6_FAST_D4:      equ    2                                         ; Motor Controller Duty Cycle, bit 4
MCDC6_FAST_D5:      equ    3                                         ; Motor Controller Duty Cycle, bit 5
MCDC6_FAST_D6:      equ    4                                         ; Motor Controller Duty Cycle, bit 6
MCDC6_FAST_D7:      equ    5                                         ; Motor Controller Duty Cycle, bit 7
MCDC6_FAST_D8:      equ    6                                         ; Motor Controller Duty Cycle, bit 8
MCDC6_FAST_S:       equ    7                                         ; Sign
; bit position masks
mMCDC6_FAST_D2:     equ    %00000001
mMCDC6_FAST_D3:     equ    %00000010
mMCDC6_FAST_D4:     equ    %00000100
mMCDC6_FAST_D5:     equ    %00001000
mMCDC6_FAST_D6:     equ    %00010000
mMCDC6_FAST_D7:     equ    %00100000
mMCDC6_FAST_D8:     equ    %01000000
mMCDC6_FAST_S:      equ    %10000000


;*** MCDC7 - Motor Controller Duty Cycle Register 7; 0x000001EE ***
MCDC7:              equ    $000001EE                                ;*** MCDC7 - Motor Controller Duty Cycle Register 7; 0x000001EE ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MCDC7_D0:           equ    0                                         ; Motor Controller Duty Cycle Bit 0
MCDC7_D1:           equ    1                                         ; Motor Controller Duty Cycle Bit 1
MCDC7_D2:           equ    2                                         ; Motor Controller Duty Cycle Bit 2
MCDC7_D3:           equ    3                                         ; Motor Controller Duty Cycle Bit 3
MCDC7_D4:           equ    4                                         ; Motor Controller Duty Cycle Bit 4
MCDC7_D5:           equ    5                                         ; Motor Controller Duty Cycle Bit 5
MCDC7_D6:           equ    6                                         ; Motor Controller Duty Cycle Bit 6
MCDC7_D7:           equ    7                                         ; Motor Controller Duty Cycle Bit 7
MCDC7_D8:           equ    8                                         ; Motor Controller Duty Cycle Bit 8
MCDC7_D9:           equ    9                                         ; Motor Controller Duty Cycle Bit 9
MCDC7_D10:          equ    10                                        ; Motor Controller Duty Cycle Bit 10
MCDC7_S:            equ    15                                        ; Sign
; bit position masks
mMCDC7_D0:          equ    %00000001
mMCDC7_D1:          equ    %00000010
mMCDC7_D2:          equ    %00000100
mMCDC7_D3:          equ    %00001000
mMCDC7_D4:          equ    %00010000
mMCDC7_D5:          equ    %00100000
mMCDC7_D6:          equ    %01000000
mMCDC7_D7:          equ    %10000000
mMCDC7_D8:          equ    %100000000
mMCDC7_D9:          equ    %1000000000
mMCDC7_D10:         equ    %10000000000
mMCDC7_S:           equ    %1000000000000000


;*** MCDC7_FAST - Motor Controller Period Register 7 access with FAST bit = 1; 0x000001EE ***
MCDC7_FAST:         equ    $000001EE                                ;*** MCDC7_FAST - Motor Controller Period Register 7 access with FAST bit = 1; 0x000001EE ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MCDC7_FAST_D2:      equ    0                                         ; Motor Controller Duty Cycle, bit 2
MCDC7_FAST_D3:      equ    1                                         ; Motor Controller Duty Cycle, bit 3
MCDC7_FAST_D4:      equ    2                                         ; Motor Controller Duty Cycle, bit 4
MCDC7_FAST_D5:      equ    3                                         ; Motor Controller Duty Cycle, bit 5
MCDC7_FAST_D6:      equ    4                                         ; Motor Controller Duty Cycle, bit 6
MCDC7_FAST_D7:      equ    5                                         ; Motor Controller Duty Cycle, bit 7
MCDC7_FAST_D8:      equ    6                                         ; Motor Controller Duty Cycle, bit 8
MCDC7_FAST_S:       equ    7                                         ; Sign
; bit position masks
mMCDC7_FAST_D2:     equ    %00000001
mMCDC7_FAST_D3:     equ    %00000010
mMCDC7_FAST_D4:     equ    %00000100
mMCDC7_FAST_D5:     equ    %00001000
mMCDC7_FAST_D6:     equ    %00010000
mMCDC7_FAST_D7:     equ    %00100000
mMCDC7_FAST_D8:     equ    %01000000
mMCDC7_FAST_S:      equ    %10000000


;*** PTT - Port T I/O Register; 0x00000200 ***
PTT:                equ    $00000200                                ;*** PTT - Port T I/O Register; 0x00000200 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTT_PTT0:           equ    0                                         ; Port T Bit 0
PTT_PTT1:           equ    1                                         ; Port T Bit 1
PTT_PTT2:           equ    2                                         ; Port T Bit 2
PTT_PTT3:           equ    3                                         ; Port T Bit 3
PTT_PTT4:           equ    4                                         ; Port T Bit 4
PTT_PTT5:           equ    5                                         ; Port T Bit 5
PTT_PTT6:           equ    6                                         ; Port T Bit 6
PTT_PTT7:           equ    7                                         ; Port T Bit 7
; bit position masks
mPTT_PTT0:          equ    %00000001
mPTT_PTT1:          equ    %00000010
mPTT_PTT2:          equ    %00000100
mPTT_PTT3:          equ    %00001000
mPTT_PTT4:          equ    %00010000
mPTT_PTT5:          equ    %00100000
mPTT_PTT6:          equ    %01000000
mPTT_PTT7:          equ    %10000000


;*** PTIT - Port T Input Register; 0x00000201 ***
PTIT:               equ    $00000201                                ;*** PTIT - Port T Input Register; 0x00000201 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTIT_PTIT0:         equ    0                                         ; Port T Bit 0
PTIT_PTIT1:         equ    1                                         ; Port T Bit 1
PTIT_PTIT2:         equ    2                                         ; Port T Bit 2
PTIT_PTIT3:         equ    3                                         ; Port T Bit 3
PTIT_PTIT4:         equ    4                                         ; Port T Bit 4
PTIT_PTIT5:         equ    5                                         ; Port T Bit 5
PTIT_PTIT6:         equ    6                                         ; Port T Bit 6
PTIT_PTIT7:         equ    7                                         ; Port T Bit 7
; bit position masks
mPTIT_PTIT0:        equ    %00000001
mPTIT_PTIT1:        equ    %00000010
mPTIT_PTIT2:        equ    %00000100
mPTIT_PTIT3:        equ    %00001000
mPTIT_PTIT4:        equ    %00010000
mPTIT_PTIT5:        equ    %00100000
mPTIT_PTIT6:        equ    %01000000
mPTIT_PTIT7:        equ    %10000000


;*** DDRT - Port T Data Direction Register; 0x00000202 ***
DDRT:               equ    $00000202                                ;*** DDRT - Port T Data Direction Register; 0x00000202 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRT_DDRT0:         equ    0                                         ; Data Direction Port T Bit 0
DDRT_DDRT1:         equ    1                                         ; Data Direction Port T Bit 1
DDRT_DDRT2:         equ    2                                         ; Data Direction Port T Bit 2
DDRT_DDRT3:         equ    3                                         ; Data Direction Port T Bit 3
DDRT_DDRT4:         equ    4                                         ; Data Direction Port T Bit 4
DDRT_DDRT5:         equ    5                                         ; Data Direction Port T Bit 5
DDRT_DDRT6:         equ    6                                         ; Data Direction Port T Bit 6
DDRT_DDRT7:         equ    7                                         ; Data Direction Port T Bit 7
; bit position masks
mDDRT_DDRT0:        equ    %00000001
mDDRT_DDRT1:        equ    %00000010
mDDRT_DDRT2:        equ    %00000100
mDDRT_DDRT3:        equ    %00001000
mDDRT_DDRT4:        equ    %00010000
mDDRT_DDRT5:        equ    %00100000
mDDRT_DDRT6:        equ    %01000000
mDDRT_DDRT7:        equ    %10000000


;*** RDRT - Port T Reduced Drive Register; 0x00000203 ***
RDRT:               equ    $00000203                                ;*** RDRT - Port T Reduced Drive Register; 0x00000203 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RDRT_RDRT0:         equ    0                                         ; Reduced Drive Port T Bit 0
RDRT_RDRT1:         equ    1                                         ; Reduced Drive Port T Bit 1
RDRT_RDRT2:         equ    2                                         ; Reduced Drive Port T Bit 2
RDRT_RDRT3:         equ    3                                         ; Reduced Drive Port T Bit 3
RDRT_RDRT4:         equ    4                                         ; Reduced Drive Port T Bit 4
RDRT_RDRT5:         equ    5                                         ; Reduced Drive Port T Bit 5
RDRT_RDRT6:         equ    6                                         ; Reduced Drive Port T Bit 6
RDRT_RDRT7:         equ    7                                         ; Reduced Drive Port T Bit 7
; bit position masks
mRDRT_RDRT0:        equ    %00000001
mRDRT_RDRT1:        equ    %00000010
mRDRT_RDRT2:        equ    %00000100
mRDRT_RDRT3:        equ    %00001000
mRDRT_RDRT4:        equ    %00010000
mRDRT_RDRT5:        equ    %00100000
mRDRT_RDRT6:        equ    %01000000
mRDRT_RDRT7:        equ    %10000000


;*** PERT - Port T Pull Device Enable Register; 0x00000204 ***
PERT:               equ    $00000204                                ;*** PERT - Port T Pull Device Enable Register; 0x00000204 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PERT_PERT0:         equ    0                                         ; Pull Device Enable Port T Bit 0
PERT_PERT1:         equ    1                                         ; Pull Device Enable Port T Bit 1
PERT_PERT2:         equ    2                                         ; Pull Device Enable Port T Bit 2
PERT_PERT3:         equ    3                                         ; Pull Device Enable Port T Bit 3
PERT_PERT4:         equ    4                                         ; Pull Device Enable Port T Bit 4
PERT_PERT5:         equ    5                                         ; Pull Device Enable Port T Bit 5
PERT_PERT6:         equ    6                                         ; Pull Device Enable Port T Bit 6
PERT_PERT7:         equ    7                                         ; Pull Device Enable Port T Bit 7
; bit position masks
mPERT_PERT0:        equ    %00000001
mPERT_PERT1:        equ    %00000010
mPERT_PERT2:        equ    %00000100
mPERT_PERT3:        equ    %00001000
mPERT_PERT4:        equ    %00010000
mPERT_PERT5:        equ    %00100000
mPERT_PERT6:        equ    %01000000
mPERT_PERT7:        equ    %10000000


;*** PPST - Port T Polarity Select Register; 0x00000205 ***
PPST:               equ    $00000205                                ;*** PPST - Port T Polarity Select Register; 0x00000205 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PPST_PPST0:         equ    0                                         ; Pull Select Port T Bit 0
PPST_PPST1:         equ    1                                         ; Pull Select Port T Bit 1
PPST_PPST2:         equ    2                                         ; Pull Select Port T Bit 2
PPST_PPST3:         equ    3                                         ; Pull Select Port T Bit 3
PPST_PPST4:         equ    4                                         ; Pull Select Port T Bit 4
PPST_PPST5:         equ    5                                         ; Pull Select Port T Bit 5
PPST_PPST6:         equ    6                                         ; Pull Select Port T Bit 6
PPST_PPST7:         equ    7                                         ; Pull Select Port T Bit 7
; bit position masks
mPPST_PPST0:        equ    %00000001
mPPST_PPST1:        equ    %00000010
mPPST_PPST2:        equ    %00000100
mPPST_PPST3:        equ    %00001000
mPPST_PPST4:        equ    %00010000
mPPST_PPST5:        equ    %00100000
mPPST_PPST6:        equ    %01000000
mPPST_PPST7:        equ    %10000000


;*** PTS - Port S I/O Register; 0x00000208 ***
PTS:                equ    $00000208                                ;*** PTS - Port S I/O Register; 0x00000208 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTS_PTS0:           equ    0                                         ; Port S Bit 0
PTS_PTS1:           equ    1                                         ; Port S Bit 1
PTS_PTS4:           equ    4                                         ; Port S Bit 4
PTS_PTS5:           equ    5                                         ; Port S Bit 5
PTS_PTS6:           equ    6                                         ; Port S Bit 6
PTS_PTS7:           equ    7                                         ; Port S Bit 7
; bit position masks
mPTS_PTS0:          equ    %00000001
mPTS_PTS1:          equ    %00000010
mPTS_PTS4:          equ    %00010000
mPTS_PTS5:          equ    %00100000
mPTS_PTS6:          equ    %01000000
mPTS_PTS7:          equ    %10000000


;*** PTIS - Port S Input Register; 0x00000209 ***
PTIS:               equ    $00000209                                ;*** PTIS - Port S Input Register; 0x00000209 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTIS_PTIS0:         equ    0                                         ; Port S Bit 0
PTIS_PTIS1:         equ    1                                         ; Port S Bit 1
PTIS_PTIS4:         equ    4                                         ; Port S Bit 4
PTIS_PTIS5:         equ    5                                         ; Port S Bit 5
PTIS_PTIS6:         equ    6                                         ; Port S Bit 6
PTIS_PTIS7:         equ    7                                         ; Port S Bit 7
; bit position masks
mPTIS_PTIS0:        equ    %00000001
mPTIS_PTIS1:        equ    %00000010
mPTIS_PTIS4:        equ    %00010000
mPTIS_PTIS5:        equ    %00100000
mPTIS_PTIS6:        equ    %01000000
mPTIS_PTIS7:        equ    %10000000


;*** DDRS - Port S Data Direction Register; 0x0000020A ***
DDRS:               equ    $0000020A                                ;*** DDRS - Port S Data Direction Register; 0x0000020A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRS_DDRS0:         equ    0                                         ; Data Direction Port S Bit 0
DDRS_DDRS1:         equ    1                                         ; Data Direction Port S Bit 1
DDRS_DDRS4:         equ    4                                         ; Data Direction Port S Bit 4
DDRS_DDRS5:         equ    5                                         ; Data Direction Port S Bit 5
DDRS_DDRS6:         equ    6                                         ; Data Direction Port S Bit 6
DDRS_DDRS7:         equ    7                                         ; Data Direction Port S Bit 7
; bit position masks
mDDRS_DDRS0:        equ    %00000001
mDDRS_DDRS1:        equ    %00000010
mDDRS_DDRS4:        equ    %00010000
mDDRS_DDRS5:        equ    %00100000
mDDRS_DDRS6:        equ    %01000000
mDDRS_DDRS7:        equ    %10000000


;*** RDRS - Port S Reduced Drive Register; 0x0000020B ***
RDRS:               equ    $0000020B                                ;*** RDRS - Port S Reduced Drive Register; 0x0000020B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RDRS_RDRS0:         equ    0                                         ; Reduced Drive Port S Bit 0
RDRS_RDRS1:         equ    1                                         ; Reduced Drive Port S Bit 1
RDRS_RDRS4:         equ    4                                         ; Reduced Drive Port S Bit 4
RDRS_RDRS5:         equ    5                                         ; Reduced Drive Port S Bit 5
RDRS_RDRS6:         equ    6                                         ; Reduced Drive Port S Bit 6
RDRS_RDRS7:         equ    7                                         ; Reduced Drive Port S Bit 7
; bit position masks
mRDRS_RDRS0:        equ    %00000001
mRDRS_RDRS1:        equ    %00000010
mRDRS_RDRS4:        equ    %00010000
mRDRS_RDRS5:        equ    %00100000
mRDRS_RDRS6:        equ    %01000000
mRDRS_RDRS7:        equ    %10000000


;*** PERS - Port S Pull Device Enable Register; 0x0000020C ***
PERS:               equ    $0000020C                                ;*** PERS - Port S Pull Device Enable Register; 0x0000020C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PERS_PERS0:         equ    0                                         ; Pull Device Enable Port S Bit 0
PERS_PERS1:         equ    1                                         ; Pull Device Enable Port S Bit 1
PERS_PERS4:         equ    4                                         ; Pull Device Enable Port S Bit 4
PERS_PERS5:         equ    5                                         ; Pull Device Enable Port S Bit 5
PERS_PERS6:         equ    6                                         ; Pull Device Enable Port S Bit 6
PERS_PERS7:         equ    7                                         ; Pull Device Enable Port S Bit 7
; bit position masks
mPERS_PERS0:        equ    %00000001
mPERS_PERS1:        equ    %00000010
mPERS_PERS4:        equ    %00010000
mPERS_PERS5:        equ    %00100000
mPERS_PERS6:        equ    %01000000
mPERS_PERS7:        equ    %10000000


;*** PPSS - Port S Polarity Select Register; 0x0000020D ***
PPSS:               equ    $0000020D                                ;*** PPSS - Port S Polarity Select Register; 0x0000020D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PPSS_PPSS0:         equ    0                                         ; Pull Select Port S Bit 0
PPSS_PPSS1:         equ    1                                         ; Pull Select Port S Bit 1
PPSS_PPSS4:         equ    4                                         ; Pull Select Port S Bit 4
PPSS_PPSS5:         equ    5                                         ; Pull Select Port S Bit 5
PPSS_PPSS6:         equ    6                                         ; Pull Select Port S Bit 6
PPSS_PPSS7:         equ    7                                         ; Pull Select Port S Bit 7
; bit position masks
mPPSS_PPSS0:        equ    %00000001
mPPSS_PPSS1:        equ    %00000010
mPPSS_PPSS4:        equ    %00010000
mPPSS_PPSS5:        equ    %00100000
mPPSS_PPSS6:        equ    %01000000
mPPSS_PPSS7:        equ    %10000000


;*** WOMS - Port S Wired-Or Mode Register; 0x0000020E ***
WOMS:               equ    $0000020E                                ;*** WOMS - Port S Wired-Or Mode Register; 0x0000020E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
WOMS_WOMS0:         equ    0                                         ; Wired-Or Mode Port S Bit 0
WOMS_WOMS1:         equ    1                                         ; Wired-Or Mode Port S Bit 1
WOMS_WOMS4:         equ    4                                         ; Wired-Or Mode Port S Bit 4
WOMS_WOMS5:         equ    5                                         ; Wired-Or Mode Port S Bit 5
WOMS_WOMS6:         equ    6                                         ; Wired-Or Mode Port S Bit 6
WOMS_WOMS7:         equ    7                                         ; Wired-Or Mode Port S Bit 7
; bit position masks
mWOMS_WOMS0:        equ    %00000001
mWOMS_WOMS1:        equ    %00000010
mWOMS_WOMS4:        equ    %00010000
mWOMS_WOMS5:        equ    %00100000
mWOMS_WOMS6:        equ    %01000000
mWOMS_WOMS7:        equ    %10000000


;*** PTM - Port M I/O Register; 0x00000210 ***
PTM:                equ    $00000210                                ;*** PTM - Port M I/O Register; 0x00000210 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTM_PTM2:           equ    2                                         ; Port M Bit 2
PTM_PTM3:           equ    3                                         ; Port M Bit 3
PTM_PTM4:           equ    4                                         ; Port M Bit 4
PTM_PTM5:           equ    5                                         ; Port M Bit 5
; bit position masks
mPTM_PTM2:          equ    %00000100
mPTM_PTM3:          equ    %00001000
mPTM_PTM4:          equ    %00010000
mPTM_PTM5:          equ    %00100000


;*** PTIM - Port M Input Register; 0x00000211 ***
PTIM:               equ    $00000211                                ;*** PTIM - Port M Input Register; 0x00000211 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTIM_PTIM2:         equ    2                                         ; Port M Bit 2
PTIM_PTIM3:         equ    3                                         ; Port M Bit 3
PTIM_PTIM4:         equ    4                                         ; Port M Bit 4
PTIM_PTIM5:         equ    5                                         ; Port M Bit 5
; bit position masks
mPTIM_PTIM2:        equ    %00000100
mPTIM_PTIM3:        equ    %00001000
mPTIM_PTIM4:        equ    %00010000
mPTIM_PTIM5:        equ    %00100000


;*** DDRM - Port M Data Direction Register; 0x00000212 ***
DDRM:               equ    $00000212                                ;*** DDRM - Port M Data Direction Register; 0x00000212 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRM_DDRM2:         equ    2                                         ; Data Direction Port M Bit 2
DDRM_DDRM3:         equ    3                                         ; Data Direction Port M Bit 3
DDRM_DDRM4:         equ    4                                         ; Data Direction Port M Bit 4
DDRM_DDRM5:         equ    5                                         ; Data Direction Port M Bit 5
; bit position masks
mDDRM_DDRM2:        equ    %00000100
mDDRM_DDRM3:        equ    %00001000
mDDRM_DDRM4:        equ    %00010000
mDDRM_DDRM5:        equ    %00100000


;*** RDRM - Port M Reduced Drive Register; 0x00000213 ***
RDRM:               equ    $00000213                                ;*** RDRM - Port M Reduced Drive Register; 0x00000213 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RDRM_RDRM2:         equ    2                                         ; Reduced Drive Port M Bit 2
RDRM_RDRM3:         equ    3                                         ; Reduced Drive Port M Bit 3
RDRM_RDRM4:         equ    4                                         ; Reduced Drive Port M Bit 4
RDRM_RDRM5:         equ    5                                         ; Reduced Drive Port M Bit 5
; bit position masks
mRDRM_RDRM2:        equ    %00000100
mRDRM_RDRM3:        equ    %00001000
mRDRM_RDRM4:        equ    %00010000
mRDRM_RDRM5:        equ    %00100000


;*** PERM - Port M Pull Device Enable Register; 0x00000214 ***
PERM:               equ    $00000214                                ;*** PERM - Port M Pull Device Enable Register; 0x00000214 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PERM_PERM2:         equ    2                                         ; Pull Device Enable Port M Bit 2
PERM_PERM3:         equ    3                                         ; Pull Device Enable Port M Bit 3
PERM_PERM4:         equ    4                                         ; Pull Device Enable Port M Bit 4
PERM_PERM5:         equ    5                                         ; Pull Device Enable Port M Bit 5
; bit position masks
mPERM_PERM2:        equ    %00000100
mPERM_PERM3:        equ    %00001000
mPERM_PERM4:        equ    %00010000
mPERM_PERM5:        equ    %00100000


;*** PPSM - Port M Polarity Select Register; 0x00000215 ***
PPSM:               equ    $00000215                                ;*** PPSM - Port M Polarity Select Register; 0x00000215 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PPSM_PPSM2:         equ    2                                         ; Pull Select Port M Bit 2
PPSM_PPSM3:         equ    3                                         ; Pull Select Port M Bit 3
PPSM_PPSM4:         equ    4                                         ; Pull Select Port M Bit 4
PPSM_PPSM5:         equ    5                                         ; Pull Select Port M Bit 5
; bit position masks
mPPSM_PPSM2:        equ    %00000100
mPPSM_PPSM3:        equ    %00001000
mPPSM_PPSM4:        equ    %00010000
mPPSM_PPSM5:        equ    %00100000


;*** WOMM - Port M Wired-Or Mode Register; 0x00000216 ***
WOMM:               equ    $00000216                                ;*** WOMM - Port M Wired-Or Mode Register; 0x00000216 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
WOMM_WOMM2:         equ    2                                         ; Wired-Or Mode Port M Bit 2
WOMM_WOMM3:         equ    3                                         ; Wired-Or Mode Port M Bit 3
WOMM_WOMM4:         equ    4                                         ; Wired-Or Mode Port M Bit 4
WOMM_WOMM5:         equ    5                                         ; Wired-Or Mode Port M Bit 5
; bit position masks
mWOMM_WOMM2:        equ    %00000100
mWOMM_WOMM3:        equ    %00001000
mWOMM_WOMM4:        equ    %00010000
mWOMM_WOMM5:        equ    %00100000


;*** PTP - Port P I/O Register; 0x00000218 ***
PTP:                equ    $00000218                                ;*** PTP - Port P I/O Register; 0x00000218 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTP_PTP0:           equ    0                                         ; Port P Bit 0
PTP_PTP1:           equ    1                                         ; Port P Bit 1
PTP_PTP2:           equ    2                                         ; Port P Bit 2
PTP_PTP3:           equ    3                                         ; Port P Bit 3
PTP_PTP4:           equ    4                                         ; Port P Bit 4
PTP_PTP5:           equ    5                                         ; Port P Bit 5
; bit position masks
mPTP_PTP0:          equ    %00000001
mPTP_PTP1:          equ    %00000010
mPTP_PTP2:          equ    %00000100
mPTP_PTP3:          equ    %00001000
mPTP_PTP4:          equ    %00010000
mPTP_PTP5:          equ    %00100000


;*** PTIP - Port P Input Register; 0x00000219 ***
PTIP:               equ    $00000219                                ;*** PTIP - Port P Input Register; 0x00000219 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTIP_PTIP0:         equ    0                                         ; Port P Bit 0
PTIP_PTIP1:         equ    1                                         ; Port P Bit 1
PTIP_PTIP2:         equ    2                                         ; Port P Bit 2
PTIP_PTIP3:         equ    3                                         ; Port P Bit 3
PTIP_PTIP4:         equ    4                                         ; Port P Bit 4
PTIP_PTIP5:         equ    5                                         ; Port P Bit 5
; bit position masks
mPTIP_PTIP0:        equ    %00000001
mPTIP_PTIP1:        equ    %00000010
mPTIP_PTIP2:        equ    %00000100
mPTIP_PTIP3:        equ    %00001000
mPTIP_PTIP4:        equ    %00010000
mPTIP_PTIP5:        equ    %00100000


;*** DDRP - Port P Data Direction Register; 0x0000021A ***
DDRP:               equ    $0000021A                                ;*** DDRP - Port P Data Direction Register; 0x0000021A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRP_DDRP0:         equ    0                                         ; Data Direction Port P Bit 0
DDRP_DDRP1:         equ    1                                         ; Data Direction Port P Bit 1
DDRP_DDRP2:         equ    2                                         ; Data Direction Port P Bit 2
DDRP_DDRP3:         equ    3                                         ; Data Direction Port P Bit 3
DDRP_DDRP4:         equ    4                                         ; Data Direction Port P Bit 4
DDRP_DDRP5:         equ    5                                         ; Data Direction Port P Bit 5
; bit position masks
mDDRP_DDRP0:        equ    %00000001
mDDRP_DDRP1:        equ    %00000010
mDDRP_DDRP2:        equ    %00000100
mDDRP_DDRP3:        equ    %00001000
mDDRP_DDRP4:        equ    %00010000
mDDRP_DDRP5:        equ    %00100000


;*** RDRP - Port P Reduced Drive Register; 0x0000021B ***
RDRP:               equ    $0000021B                                ;*** RDRP - Port P Reduced Drive Register; 0x0000021B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RDRP_RDRP0:         equ    0                                         ; Reduced Drive Port P Bit 0
RDRP_RDRP1:         equ    1                                         ; Reduced Drive Port P Bit 1
RDRP_RDRP2:         equ    2                                         ; Reduced Drive Port P Bit 2
RDRP_RDRP3:         equ    3                                         ; Reduced Drive Port P Bit 3
RDRP_RDRP4:         equ    4                                         ; Reduced Drive Port P Bit 4
RDRP_RDRP5:         equ    5                                         ; Reduced Drive Port P Bit 5
; bit position masks
mRDRP_RDRP0:        equ    %00000001
mRDRP_RDRP1:        equ    %00000010
mRDRP_RDRP2:        equ    %00000100
mRDRP_RDRP3:        equ    %00001000
mRDRP_RDRP4:        equ    %00010000
mRDRP_RDRP5:        equ    %00100000


;*** PERP - Port P Pull Device Enable Register; 0x0000021C ***
PERP:               equ    $0000021C                                ;*** PERP - Port P Pull Device Enable Register; 0x0000021C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PERP_PERP0:         equ    0                                         ; Pull Device Enable Port P Bit 0
PERP_PERP1:         equ    1                                         ; Pull Device Enable Port P Bit 1
PERP_PERP2:         equ    2                                         ; Pull Device Enable Port P Bit 2
PERP_PERP3:         equ    3                                         ; Pull Device Enable Port P Bit 3
PERP_PERP4:         equ    4                                         ; Pull Device Enable Port P Bit 4
PERP_PERP5:         equ    5                                         ; Pull Device Enable Port P Bit 5
; bit position masks
mPERP_PERP0:        equ    %00000001
mPERP_PERP1:        equ    %00000010
mPERP_PERP2:        equ    %00000100
mPERP_PERP3:        equ    %00001000
mPERP_PERP4:        equ    %00010000
mPERP_PERP5:        equ    %00100000


;*** PPSP - Port P Polarity Select Register; 0x0000021D ***
PPSP:               equ    $0000021D                                ;*** PPSP - Port P Polarity Select Register; 0x0000021D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PPSP_PPSP0:         equ    0                                         ; Pull Select Port P Bit 0
PPSP_PPSP1:         equ    1                                         ; Pull Select Port P Bit 1
PPSP_PPSP2:         equ    2                                         ; Pull Select Port P Bit 2
PPSP_PPSP3:         equ    3                                         ; Pull Select Port P Bit 3
PPSP_PPSP4:         equ    4                                         ; Pull Select Port P Bit 4
PPSP_PPSP5:         equ    5                                         ; Pull Select Port P Bit 5
; bit position masks
mPPSP_PPSP0:        equ    %00000001
mPPSP_PPSP1:        equ    %00000010
mPPSP_PPSP2:        equ    %00000100
mPPSP_PPSP3:        equ    %00001000
mPPSP_PPSP4:        equ    %00010000
mPPSP_PPSP5:        equ    %00100000


;*** WOMP - Port P Wired-OR Mode Register; 0x0000021E ***
WOMP:               equ    $0000021E                                ;*** WOMP - Port P Wired-OR Mode Register; 0x0000021E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
WOMP_WOMP0:         equ    0                                         ; Wired-OR Mode Port P Bit 0
WOMP_WOMP2:         equ    2                                         ; Wired-OR Mode Port P Bit 2
WOMP_WOMP4:         equ    4                                         ; Wired-OR Mode Port P Bit 4
WOMP_WOMP5:         equ    5                                         ; Wired-OR Mode Port P Bit 5
; bit position masks
mWOMP_WOMP0:        equ    %00000001
mWOMP_WOMP2:        equ    %00000100
mWOMP_WOMP4:        equ    %00010000
mWOMP_WOMP5:        equ    %00100000


;*** PTL - Port L I/O Register; 0x00000230 ***
PTL:                equ    $00000230                                ;*** PTL - Port L I/O Register; 0x00000230 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTL_PTL0:           equ    0                                         ; Port L Bit 0
PTL_PTL1:           equ    1                                         ; Port L Bit 1
PTL_PTL2:           equ    2                                         ; Port L Bit 2
PTL_PTL3:           equ    3                                         ; Port L Bit 3
PTL_PTL4:           equ    4                                         ; Port L Bit 4
PTL_PTL5:           equ    5                                         ; Port L Bit 5
PTL_PTL6:           equ    6                                         ; Port L Bit 6
PTL_PTL7:           equ    7                                         ; Port L Bit 7
; bit position masks
mPTL_PTL0:          equ    %00000001
mPTL_PTL1:          equ    %00000010
mPTL_PTL2:          equ    %00000100
mPTL_PTL3:          equ    %00001000
mPTL_PTL4:          equ    %00010000
mPTL_PTL5:          equ    %00100000
mPTL_PTL6:          equ    %01000000
mPTL_PTL7:          equ    %10000000


;*** PTIL - Port L Input Register; 0x00000231 ***
PTIL:               equ    $00000231                                ;*** PTIL - Port L Input Register; 0x00000231 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTIL_PTIL0:         equ    0                                         ; Port L Bit 0
PTIL_PTIL1:         equ    1                                         ; Port L Bit 1
PTIL_PTIL2:         equ    2                                         ; Port L Bit 2
PTIL_PTIL3:         equ    3                                         ; Port L Bit 3
PTIL_PTIL4:         equ    4                                         ; Port L Bit 4
PTIL_PTIL5:         equ    5                                         ; Port L Bit 5
PTIL_PTIL6:         equ    6                                         ; Port L Bit 6
PTIL_PTIL7:         equ    7                                         ; Port L Bit 7
; bit position masks
mPTIL_PTIL0:        equ    %00000001
mPTIL_PTIL1:        equ    %00000010
mPTIL_PTIL2:        equ    %00000100
mPTIL_PTIL3:        equ    %00001000
mPTIL_PTIL4:        equ    %00010000
mPTIL_PTIL5:        equ    %00100000
mPTIL_PTIL6:        equ    %01000000
mPTIL_PTIL7:        equ    %10000000


;*** DDRL - Port L Data Direction Register; 0x00000232 ***
DDRL:               equ    $00000232                                ;*** DDRL - Port L Data Direction Register; 0x00000232 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRL_DDRL0:         equ    0                                         ; Data Direction Port L Bit 0
DDRL_DDRL1:         equ    1                                         ; Data Direction Port L Bit 1
DDRL_DDRL2:         equ    2                                         ; Data Direction Port L Bit 2
DDRL_DDRL3:         equ    3                                         ; Data Direction Port L Bit 3
DDRL_DDRL4:         equ    4                                         ; Data Direction Port L Bit 4
DDRL_DDRL5:         equ    5                                         ; Data Direction Port L Bit 5
DDRL_DDRL6:         equ    6                                         ; Data Direction Port L Bit 6
DDRL_DDRL7:         equ    7                                         ; Data Direction Port L Bit 7
; bit position masks
mDDRL_DDRL0:        equ    %00000001
mDDRL_DDRL1:        equ    %00000010
mDDRL_DDRL2:        equ    %00000100
mDDRL_DDRL3:        equ    %00001000
mDDRL_DDRL4:        equ    %00010000
mDDRL_DDRL5:        equ    %00100000
mDDRL_DDRL6:        equ    %01000000
mDDRL_DDRL7:        equ    %10000000


;*** RDRL - Port L Reduced Drive Register; 0x00000233 ***
RDRL:               equ    $00000233                                ;*** RDRL - Port L Reduced Drive Register; 0x00000233 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RDRL_RDRL0:         equ    0                                         ; Reduced Drive Port L Bit 0
RDRL_RDRL1:         equ    1                                         ; Reduced Drive Port L Bit 1
RDRL_RDRL2:         equ    2                                         ; Reduced Drive Port L Bit 2
RDRL_RDRL3:         equ    3                                         ; Reduced Drive Port L Bit 3
RDRL_RDRL4:         equ    4                                         ; Reduced Drive Port L Bit 4
RDRL_RDRL5:         equ    5                                         ; Reduced Drive Port L Bit 5
RDRL_RDRL6:         equ    6                                         ; Reduced Drive Port L Bit 6
RDRL_RDRL7:         equ    7                                         ; Reduced Drive Port L Bit 7
; bit position masks
mRDRL_RDRL0:        equ    %00000001
mRDRL_RDRL1:        equ    %00000010
mRDRL_RDRL2:        equ    %00000100
mRDRL_RDRL3:        equ    %00001000
mRDRL_RDRL4:        equ    %00010000
mRDRL_RDRL5:        equ    %00100000
mRDRL_RDRL6:        equ    %01000000
mRDRL_RDRL7:        equ    %10000000


;*** PERL - Port L Pull Device Enable Register; 0x00000234 ***
PERL:               equ    $00000234                                ;*** PERL - Port L Pull Device Enable Register; 0x00000234 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PERL_PERL0:         equ    0                                         ; Pull Device Enable Port L Bit 0
PERL_PERL1:         equ    1                                         ; Pull Device Enable Port L Bit 1
PERL_PERL2:         equ    2                                         ; Pull Device Enable Port L Bit 2
PERL_PERL3:         equ    3                                         ; Pull Device Enable Port L Bit 3
PERL_PERL4:         equ    4                                         ; Pull Device Enable Port L Bit 4
PERL_PERL5:         equ    5                                         ; Pull Device Enable Port L Bit 5
PERL_PERL6:         equ    6                                         ; Pull Device Enable Port L Bit 6
PERL_PERL7:         equ    7                                         ; Pull Device Enable Port L Bit 7
; bit position masks
mPERL_PERL0:        equ    %00000001
mPERL_PERL1:        equ    %00000010
mPERL_PERL2:        equ    %00000100
mPERL_PERL3:        equ    %00001000
mPERL_PERL4:        equ    %00010000
mPERL_PERL5:        equ    %00100000
mPERL_PERL6:        equ    %01000000
mPERL_PERL7:        equ    %10000000


;*** PPSL - Port L Polarity Select Register; 0x00000235 ***
PPSL:               equ    $00000235                                ;*** PPSL - Port L Polarity Select Register; 0x00000235 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PPSL_PPSL0:         equ    0                                         ; Pull Select Port L Bit 0
PPSL_PPSL1:         equ    1                                         ; Pull Select Port L Bit 1
PPSL_PPSL2:         equ    2                                         ; Pull Select Port L Bit 2
PPSL_PPSL3:         equ    3                                         ; Pull Select Port L Bit 3
PPSL_PPSL4:         equ    4                                         ; Pull Select Port L Bit 4
PPSL_PPSL5:         equ    5                                         ; Pull Select Port L Bit 5
PPSL_PPSL6:         equ    6                                         ; Pull Select Port L Bit 6
PPSL_PPSL7:         equ    7                                         ; Pull Select Port L Bit 7
; bit position masks
mPPSL_PPSL0:        equ    %00000001
mPPSL_PPSL1:        equ    %00000010
mPPSL_PPSL2:        equ    %00000100
mPPSL_PPSL3:        equ    %00001000
mPPSL_PPSL4:        equ    %00010000
mPPSL_PPSL5:        equ    %00100000
mPPSL_PPSL6:        equ    %01000000
mPPSL_PPSL7:        equ    %10000000


;*** PTU - Port U I/O Register; 0x00000238 ***
PTU:                equ    $00000238                                ;*** PTU - Port U I/O Register; 0x00000238 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTU_PTU0:           equ    0                                         ; Port U Bit 0
PTU_PTU1:           equ    1                                         ; Port U Bit 1
PTU_PTU2:           equ    2                                         ; Port U Bit 2
PTU_PTU3:           equ    3                                         ; Port U Bit 3
PTU_PTU4:           equ    4                                         ; Port U Bit 4
PTU_PTU5:           equ    5                                         ; Port U Bit 5
PTU_PTU6:           equ    6                                         ; Port U Bit 6
PTU_PTU7:           equ    7                                         ; Port U Bit 7
; bit position masks
mPTU_PTU0:          equ    %00000001
mPTU_PTU1:          equ    %00000010
mPTU_PTU2:          equ    %00000100
mPTU_PTU3:          equ    %00001000
mPTU_PTU4:          equ    %00010000
mPTU_PTU5:          equ    %00100000
mPTU_PTU6:          equ    %01000000
mPTU_PTU7:          equ    %10000000


;*** PTIU - Port U Input Register; 0x00000239 ***
PTIU:               equ    $00000239                                ;*** PTIU - Port U Input Register; 0x00000239 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTIU_PTIU0:         equ    0                                         ; Port U Bit 0
PTIU_PTIU1:         equ    1                                         ; Port U Bit 1
PTIU_PTIU2:         equ    2                                         ; Port U Bit 2
PTIU_PTIU3:         equ    3                                         ; Port U Bit 3
PTIU_PTIU4:         equ    4                                         ; Port U Bit 4
PTIU_PTIU5:         equ    5                                         ; Port U Bit 5
PTIU_PTIU6:         equ    6                                         ; Port U Bit 6
PTIU_PTIU7:         equ    7                                         ; Port U Bit 7
; bit position masks
mPTIU_PTIU0:        equ    %00000001
mPTIU_PTIU1:        equ    %00000010
mPTIU_PTIU2:        equ    %00000100
mPTIU_PTIU3:        equ    %00001000
mPTIU_PTIU4:        equ    %00010000
mPTIU_PTIU5:        equ    %00100000
mPTIU_PTIU6:        equ    %01000000
mPTIU_PTIU7:        equ    %10000000


;*** DDRU - Port U Data Direction Register; 0x0000023A ***
DDRU:               equ    $0000023A                                ;*** DDRU - Port U Data Direction Register; 0x0000023A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRU_DDRU0:         equ    0                                         ; Data Direction Port U Bit 0
DDRU_DDRU1:         equ    1                                         ; Data Direction Port U Bit 1
DDRU_DDRU2:         equ    2                                         ; Data Direction Port U Bit 2
DDRU_DDRU3:         equ    3                                         ; Data Direction Port U Bit 3
DDRU_DDRU4:         equ    4                                         ; Data Direction Port U Bit 4
DDRU_DDRU5:         equ    5                                         ; Data Direction Port U Bit 5
DDRU_DDRU6:         equ    6                                         ; Data Direction Port U Bit 6
DDRU_DDRU7:         equ    7                                         ; Data Direction Port U Bit 7
; bit position masks
mDDRU_DDRU0:        equ    %00000001
mDDRU_DDRU1:        equ    %00000010
mDDRU_DDRU2:        equ    %00000100
mDDRU_DDRU3:        equ    %00001000
mDDRU_DDRU4:        equ    %00010000
mDDRU_DDRU5:        equ    %00100000
mDDRU_DDRU6:        equ    %01000000
mDDRU_DDRU7:        equ    %10000000


;*** SRRU - Port U Slew Rate Register; 0x0000023B ***
SRRU:               equ    $0000023B                                ;*** SRRU - Port U Slew Rate Register; 0x0000023B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SRRU_SRRU0:         equ    0                                         ; Slew Rate Port U Bit 0
SRRU_SRRU1:         equ    1                                         ; Slew Rate Port U Bit 1
SRRU_SRRU2:         equ    2                                         ; Slew Rate Port U Bit 2
SRRU_SRRU3:         equ    3                                         ; Slew Rate Port U Bit 3
SRRU_SRRU4:         equ    4                                         ; Slew Rate Port U Bit 4
SRRU_SRRU5:         equ    5                                         ; Slew Rate Port U Bit 5
SRRU_SRRU6:         equ    6                                         ; Slew Rate Port U Bit 6
SRRU_SRRU7:         equ    7                                         ; Slew Rate Port U Bit 7
; bit position masks
mSRRU_SRRU0:        equ    %00000001
mSRRU_SRRU1:        equ    %00000010
mSRRU_SRRU2:        equ    %00000100
mSRRU_SRRU3:        equ    %00001000
mSRRU_SRRU4:        equ    %00010000
mSRRU_SRRU5:        equ    %00100000
mSRRU_SRRU6:        equ    %01000000
mSRRU_SRRU7:        equ    %10000000


;*** PERU - Port U Pull Device Enable Register; 0x0000023C ***
PERU:               equ    $0000023C                                ;*** PERU - Port U Pull Device Enable Register; 0x0000023C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PERU_PERU0:         equ    0                                         ; Pull Device Enable Port U Bit 0
PERU_PERU1:         equ    1                                         ; Pull Device Enable Port U Bit 1
PERU_PERU2:         equ    2                                         ; Pull Device Enable Port U Bit 2
PERU_PERU3:         equ    3                                         ; Pull Device Enable Port U Bit 3
PERU_PERU4:         equ    4                                         ; Pull Device Enable Port U Bit 4
PERU_PERU5:         equ    5                                         ; Pull Device Enable Port U Bit 5
PERU_PERU6:         equ    6                                         ; Pull Device Enable Port U Bit 6
PERU_PERU7:         equ    7                                         ; Pull Device Enable Port U Bit 7
; bit position masks
mPERU_PERU0:        equ    %00000001
mPERU_PERU1:        equ    %00000010
mPERU_PERU2:        equ    %00000100
mPERU_PERU3:        equ    %00001000
mPERU_PERU4:        equ    %00010000
mPERU_PERU5:        equ    %00100000
mPERU_PERU6:        equ    %01000000
mPERU_PERU7:        equ    %10000000


;*** PPSU - Port U Polarity Select Register; 0x0000023D ***
PPSU:               equ    $0000023D                                ;*** PPSU - Port U Polarity Select Register; 0x0000023D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PPSU_PPSU0:         equ    0                                         ; Pull Select Port U Bit 0
PPSU_PPSU1:         equ    1                                         ; Pull Select Port U Bit 1
PPSU_PPSU2:         equ    2                                         ; Pull Select Port U Bit 2
PPSU_PPSU3:         equ    3                                         ; Pull Select Port U Bit 3
PPSU_PPSU4:         equ    4                                         ; Pull Select Port U Bit 4
PPSU_PPSU5:         equ    5                                         ; Pull Select Port U Bit 5
PPSU_PPSU6:         equ    6                                         ; Pull Select Port U Bit 6
PPSU_PPSU7:         equ    7                                         ; Pull Select Port U Bit 7
; bit position masks
mPPSU_PPSU0:        equ    %00000001
mPPSU_PPSU1:        equ    %00000010
mPPSU_PPSU2:        equ    %00000100
mPPSU_PPSU3:        equ    %00001000
mPPSU_PPSU4:        equ    %00010000
mPPSU_PPSU5:        equ    %00100000
mPPSU_PPSU6:        equ    %01000000
mPPSU_PPSU7:        equ    %10000000


;*** PTV - Port V I/O Register; 0x00000240 ***
PTV:                equ    $00000240                                ;*** PTV - Port V I/O Register; 0x00000240 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTV_PTV0:           equ    0                                         ; Port V Bit 0
PTV_PTV1:           equ    1                                         ; Port V Bit 1
PTV_PTV2:           equ    2                                         ; Port V Bit 2
PTV_PTV3:           equ    3                                         ; Port V Bit 3
PTV_PTV4:           equ    4                                         ; Port V Bit 4
PTV_PTV5:           equ    5                                         ; Port V Bit 5
PTV_PTV6:           equ    6                                         ; Port V Bit 6
PTV_PTV7:           equ    7                                         ; Port V Bit 7
; bit position masks
mPTV_PTV0:          equ    %00000001
mPTV_PTV1:          equ    %00000010
mPTV_PTV2:          equ    %00000100
mPTV_PTV3:          equ    %00001000
mPTV_PTV4:          equ    %00010000
mPTV_PTV5:          equ    %00100000
mPTV_PTV6:          equ    %01000000
mPTV_PTV7:          equ    %10000000


;*** PTIV - Port V Input Register; 0x00000241 ***
PTIV:               equ    $00000241                                ;*** PTIV - Port V Input Register; 0x00000241 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTIV_PTIV0:         equ    0                                         ; Port V Bit 0
PTIV_PTIV1:         equ    1                                         ; Port V Bit 1
PTIV_PTIV2:         equ    2                                         ; Port V Bit 2
PTIV_PTIV3:         equ    3                                         ; Port V Bit 3
PTIV_PTIV4:         equ    4                                         ; Port V Bit 4
PTIV_PTIV5:         equ    5                                         ; Port V Bit 5
PTIV_PTIV6:         equ    6                                         ; Port V Bit 6
PTIV_PTIV7:         equ    7                                         ; Port V Bit 7
; bit position masks
mPTIV_PTIV0:        equ    %00000001
mPTIV_PTIV1:        equ    %00000010
mPTIV_PTIV2:        equ    %00000100
mPTIV_PTIV3:        equ    %00001000
mPTIV_PTIV4:        equ    %00010000
mPTIV_PTIV5:        equ    %00100000
mPTIV_PTIV6:        equ    %01000000
mPTIV_PTIV7:        equ    %10000000


;*** DDRV - Port V Data Direction Register; 0x00000242 ***
DDRV:               equ    $00000242                                ;*** DDRV - Port V Data Direction Register; 0x00000242 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRV_DDRV0:         equ    0                                         ; Data Direction Port V Bit 0
DDRV_DDRV1:         equ    1                                         ; Data Direction Port V Bit 1
DDRV_DDRV2:         equ    2                                         ; Data Direction Port V Bit 2
DDRV_DDRV3:         equ    3                                         ; Data Direction Port V Bit 3
DDRV_DDRV4:         equ    4                                         ; Data Direction Port V Bit 4
DDRV_DDRV5:         equ    5                                         ; Data Direction Port V Bit 5
DDRV_DDRV6:         equ    6                                         ; Data Direction Port V Bit 6
DDRV_DDRV7:         equ    7                                         ; Data Direction Port V Bit 7
; bit position masks
mDDRV_DDRV0:        equ    %00000001
mDDRV_DDRV1:        equ    %00000010
mDDRV_DDRV2:        equ    %00000100
mDDRV_DDRV3:        equ    %00001000
mDDRV_DDRV4:        equ    %00010000
mDDRV_DDRV5:        equ    %00100000
mDDRV_DDRV6:        equ    %01000000
mDDRV_DDRV7:        equ    %10000000


;*** SRRV - Port V Reduced Drive Register; 0x00000243 ***
SRRV:               equ    $00000243                                ;*** SRRV - Port V Reduced Drive Register; 0x00000243 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SRRV_SRRV0:         equ    0                                         ; Slew Rate Port V Bit 0
SRRV_SRRV1:         equ    1                                         ; Slew Rate Port V Bit 1
SRRV_SRRV2:         equ    2                                         ; Slew Rate Port V Bit 2
SRRV_SRRV3:         equ    3                                         ; Slew Rate Port V Bit 3
SRRV_SRRV4:         equ    4                                         ; Slew Rate Port V Bit 4
SRRV_SRRV5:         equ    5                                         ; Slew Rate Port V Bit 5
SRRV_SRRV6:         equ    6                                         ; Slew Rate Port V Bit 6
SRRV_SRRV7:         equ    7                                         ; Slew Rate Port V Bit 7
; bit position masks
mSRRV_SRRV0:        equ    %00000001
mSRRV_SRRV1:        equ    %00000010
mSRRV_SRRV2:        equ    %00000100
mSRRV_SRRV3:        equ    %00001000
mSRRV_SRRV4:        equ    %00010000
mSRRV_SRRV5:        equ    %00100000
mSRRV_SRRV6:        equ    %01000000
mSRRV_SRRV7:        equ    %10000000


;*** PERV - Port V Pull Device Enable Register; 0x00000244 ***
PERV:               equ    $00000244                                ;*** PERV - Port V Pull Device Enable Register; 0x00000244 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PERV_PERV0:         equ    0                                         ; Pull Device Enable Port V Bit 0
PERV_PERV1:         equ    1                                         ; Pull Device Enable Port V Bit 1
PERV_PERV2:         equ    2                                         ; Pull Device Enable Port V Bit 2
PERV_PERV3:         equ    3                                         ; Pull Device Enable Port V Bit 3
PERV_PERV4:         equ    4                                         ; Pull Device Enable Port V Bit 4
PERV_PERV5:         equ    5                                         ; Pull Device Enable Port V Bit 5
PERV_PERV6:         equ    6                                         ; Pull Device Enable Port V Bit 6
PERV_PERV7:         equ    7                                         ; Pull Device Enable Port V Bit 7
; bit position masks
mPERV_PERV0:        equ    %00000001
mPERV_PERV1:        equ    %00000010
mPERV_PERV2:        equ    %00000100
mPERV_PERV3:        equ    %00001000
mPERV_PERV4:        equ    %00010000
mPERV_PERV5:        equ    %00100000
mPERV_PERV6:        equ    %01000000
mPERV_PERV7:        equ    %10000000


;*** PPSV - Port V Polarity Select Register; 0x00000245 ***
PPSV:               equ    $00000245                                ;*** PPSV - Port V Polarity Select Register; 0x00000245 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PPSV_PPSV0:         equ    0                                         ; Pull Select Port V Bit 0
PPSV_PPSV1:         equ    1                                         ; Pull Select Port V Bit 1
PPSV_PPSV2:         equ    2                                         ; Pull Select Port V Bit 2
PPSV_PPSV3:         equ    3                                         ; Pull Select Port V Bit 3
PPSV_PPSV4:         equ    4                                         ; Pull Select Port V Bit 4
PPSV_PPSV5:         equ    5                                         ; Pull Select Port V Bit 5
PPSV_PPSV6:         equ    6                                         ; Pull Select Port V Bit 6
PPSV_PPSV7:         equ    7                                         ; Pull Select Port V Bit 7
; bit position masks
mPPSV_PPSV0:        equ    %00000001
mPPSV_PPSV1:        equ    %00000010
mPPSV_PPSV2:        equ    %00000100
mPPSV_PPSV3:        equ    %00001000
mPPSV_PPSV4:        equ    %00010000
mPPSV_PPSV5:        equ    %00100000
mPPSV_PPSV6:        equ    %01000000
mPPSV_PPSV7:        equ    %10000000


;*** PTAD - Port AD I/O Register; 0x00000251 ***
PTAD:               equ    $00000251                                ;*** PTAD - Port AD I/O Register; 0x00000251 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTAD_PTAD0:         equ    0                                         ; Port AD Bit 0
PTAD_PTAD1:         equ    1                                         ; Port AD Bit 1
PTAD_PTAD2:         equ    2                                         ; Port AD Bit 2
PTAD_PTAD3:         equ    3                                         ; Port AD Bit 3
PTAD_PTAD4:         equ    4                                         ; Port AD Bit 4
PTAD_PTAD5:         equ    5                                         ; Port AD Bit 5
PTAD_PTAD6:         equ    6                                         ; Port AD Bit 6
PTAD_PTAD7:         equ    7                                         ; Port AD Bit 7
; bit position masks
mPTAD_PTAD0:        equ    %00000001
mPTAD_PTAD1:        equ    %00000010
mPTAD_PTAD2:        equ    %00000100
mPTAD_PTAD3:        equ    %00001000
mPTAD_PTAD4:        equ    %00010000
mPTAD_PTAD5:        equ    %00100000
mPTAD_PTAD6:        equ    %01000000
mPTAD_PTAD7:        equ    %10000000


;*** PTIAD - Port AD Input Register; 0x00000253 ***
PTIAD:              equ    $00000253                                ;*** PTIAD - Port AD Input Register; 0x00000253 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTIAD_PTIAD0:       equ    0                                         ; Port AD Bit 0
PTIAD_PTIAD1:       equ    1                                         ; Port AD Bit 1
PTIAD_PTIAD2:       equ    2                                         ; Port AD Bit 2
PTIAD_PTIAD3:       equ    3                                         ; Port AD Bit 3
PTIAD_PTIAD4:       equ    4                                         ; Port AD Bit 4
PTIAD_PTIAD5:       equ    5                                         ; Port AD Bit 5
PTIAD_PTIAD6:       equ    6                                         ; Port AD Bit 6
PTIAD_PTIAD7:       equ    7                                         ; Port AD Bit 7
; bit position masks
mPTIAD_PTIAD0:      equ    %00000001
mPTIAD_PTIAD1:      equ    %00000010
mPTIAD_PTIAD2:      equ    %00000100
mPTIAD_PTIAD3:      equ    %00001000
mPTIAD_PTIAD4:      equ    %00010000
mPTIAD_PTIAD5:      equ    %00100000
mPTIAD_PTIAD6:      equ    %01000000
mPTIAD_PTIAD7:      equ    %10000000


;*** DDRAD - Port AD Data Direction Register; 0x00000255 ***
DDRAD:              equ    $00000255                                ;*** DDRAD - Port AD Data Direction Register; 0x00000255 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRAD_DDRAD0:       equ    0                                         ; Port AD Data Direction Bit 0
DDRAD_DDRAD1:       equ    1                                         ; Port AD Data Direction Bit 1
DDRAD_DDRAD2:       equ    2                                         ; Port AD Data Direction Bit 2
DDRAD_DDRAD3:       equ    3                                         ; Port AD Data Direction Bit 3
DDRAD_DDRAD4:       equ    4                                         ; Port AD Data Direction Bit 4
DDRAD_DDRAD5:       equ    5                                         ; Port AD Data Direction Bit 5
DDRAD_DDRAD6:       equ    6                                         ; Port AD Data Direction Bit 6
DDRAD_DDRAD7:       equ    7                                         ; Port AD Data Direction Bit 7
; bit position masks
mDDRAD_DDRAD0:      equ    %00000001
mDDRAD_DDRAD1:      equ    %00000010
mDDRAD_DDRAD2:      equ    %00000100
mDDRAD_DDRAD3:      equ    %00001000
mDDRAD_DDRAD4:      equ    %00010000
mDDRAD_DDRAD5:      equ    %00100000
mDDRAD_DDRAD6:      equ    %01000000
mDDRAD_DDRAD7:      equ    %10000000


;*** RDRAD - Port AD Reduced Drive Register; 0x00000257 ***
RDRAD:              equ    $00000257                                ;*** RDRAD - Port AD Reduced Drive Register; 0x00000257 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RDRAD_RDRAD0:       equ    0                                         ; Port AD Reduced Drive Bit 0
RDRAD_RDRAD1:       equ    1                                         ; Port AD Reduced Drive Bit 1
RDRAD_RDRAD2:       equ    2                                         ; Port AD Reduced Drive Bit 2
RDRAD_RDRAD3:       equ    3                                         ; Port AD Reduced Drive Bit 3
RDRAD_RDRAD4:       equ    4                                         ; Port AD Reduced Drive Bit 4
RDRAD_RDRAD5:       equ    5                                         ; Port AD Reduced Drive Bit 5
RDRAD_RDRAD6:       equ    6                                         ; Port AD Reduced Drive Bit 6
RDRAD_RDRAD7:       equ    7                                         ; Port AD Reduced Drive Bit 7
; bit position masks
mRDRAD_RDRAD0:      equ    %00000001
mRDRAD_RDRAD1:      equ    %00000010
mRDRAD_RDRAD2:      equ    %00000100
mRDRAD_RDRAD3:      equ    %00001000
mRDRAD_RDRAD4:      equ    %00010000
mRDRAD_RDRAD5:      equ    %00100000
mRDRAD_RDRAD6:      equ    %01000000
mRDRAD_RDRAD7:      equ    %10000000


;*** PERAD - Port AD Pull Device Enable Register; 0x00000259 ***
PERAD:              equ    $00000259                                ;*** PERAD - Port AD Pull Device Enable Register; 0x00000259 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PERAD_PERAD0:       equ    0                                         ; Port AD Pull Device Enable Bit 0
PERAD_PERAD1:       equ    1                                         ; Port AD Pull Device Enable Bit 1
PERAD_PERAD2:       equ    2                                         ; Port AD Pull Device Enable Bit 2
PERAD_PERAD3:       equ    3                                         ; Port AD Pull Device Enable Bit 3
PERAD_PERAD4:       equ    4                                         ; Port AD Pull Device Enable Bit 4
PERAD_PERAD5:       equ    5                                         ; Port AD Pull Device Enable Bit 5
PERAD_PERAD6:       equ    6                                         ; Port AD Pull Device Enable Bit 6
PERAD_PERAD7:       equ    7                                         ; Port AD Pull Device Enable Bit 7
; bit position masks
mPERAD_PERAD0:      equ    %00000001
mPERAD_PERAD1:      equ    %00000010
mPERAD_PERAD2:      equ    %00000100
mPERAD_PERAD3:      equ    %00001000
mPERAD_PERAD4:      equ    %00010000
mPERAD_PERAD5:      equ    %00100000
mPERAD_PERAD6:      equ    %01000000
mPERAD_PERAD7:      equ    %10000000


;*** PPSAD - Port AD Polarity Select Register; 0x0000025B ***
PPSAD:              equ    $0000025B                                ;*** PPSAD - Port AD Polarity Select Register; 0x0000025B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PPSAD_PPSAD0:       equ    0                                         ; Port AD Polarity Select Bit 0
PPSAD_PPSAD1:       equ    1                                         ; Port AD Polarity Select Bit 1
PPSAD_PPSAD2:       equ    2                                         ; Port AD Polarity Select Bit 2
PPSAD_PPSAD3:       equ    3                                         ; Port AD Polarity Select Bit 3
PPSAD_PPSAD4:       equ    4                                         ; Port AD Polarity Select Bit 4
PPSAD_PPSAD5:       equ    5                                         ; Port AD Polarity Select Bit 5
PPSAD_PPSAD6:       equ    6                                         ; Port AD Polarity Select Bit 6
PPSAD_PPSAD7:       equ    7                                         ; Port AD Polarity Select Bit 7
; bit position masks
mPPSAD_PPSAD0:      equ    %00000001
mPPSAD_PPSAD1:      equ    %00000010
mPPSAD_PPSAD2:      equ    %00000100
mPPSAD_PPSAD3:      equ    %00001000
mPPSAD_PPSAD4:      equ    %00010000
mPPSAD_PPSAD5:      equ    %00100000
mPPSAD_PPSAD6:      equ    %01000000
mPPSAD_PPSAD7:      equ    %10000000


;*** PIEAD - Port AD Interrupt Enable Register; 0x0000025D ***
PIEAD:              equ    $0000025D                                ;*** PIEAD - Port AD Interrupt Enable Register; 0x0000025D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PIEAD_PIEAD0:       equ    0                                         ; Port AD Interrupt Enable Bit 0
PIEAD_PIEAD1:       equ    1                                         ; Port AD Interrupt Enable Bit 1
PIEAD_PIEAD2:       equ    2                                         ; Port AD Interrupt Enable Bit 2
PIEAD_PIEAD3:       equ    3                                         ; Port AD Interrupt Enable Bit 3
PIEAD_PIEAD4:       equ    4                                         ; Port AD Interrupt Enable Bit 4
PIEAD_PIEAD5:       equ    5                                         ; Port AD Interrupt Enable Bit 5
PIEAD_PIEAD6:       equ    6                                         ; Port AD Interrupt Enable Bit 6
PIEAD_PIEAD7:       equ    7                                         ; Port AD Interrupt Enable Bit 7
; bit position masks
mPIEAD_PIEAD0:      equ    %00000001
mPIEAD_PIEAD1:      equ    %00000010
mPIEAD_PIEAD2:      equ    %00000100
mPIEAD_PIEAD3:      equ    %00001000
mPIEAD_PIEAD4:      equ    %00010000
mPIEAD_PIEAD5:      equ    %00100000
mPIEAD_PIEAD6:      equ    %01000000
mPIEAD_PIEAD7:      equ    %10000000


;*** PIFAD - Port AD Interrupt Flag Register; 0x0000025F ***
PIFAD:              equ    $0000025F                                ;*** PIFAD - Port AD Interrupt Flag Register; 0x0000025F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PIFAD_PIFAD0:       equ    0                                         ; Port AD Interrupt Flag Bit 0
PIFAD_PIFAD1:       equ    1                                         ; Port AD Interrupt Flag Bit 1
PIFAD_PIFAD2:       equ    2                                         ; Port AD Interrupt Flag Bit 2
PIFAD_PIFAD3:       equ    3                                         ; Port AD Interrupt Flag Bit 3
PIFAD_PIFAD4:       equ    4                                         ; Port AD Interrupt Flag Bit 4
PIFAD_PIFAD5:       equ    5                                         ; Port AD Interrupt Flag Bit 5
PIFAD_PIFAD6:       equ    6                                         ; Port AD Interrupt Flag Bit 6
PIFAD_PIFAD7:       equ    7                                         ; Port AD Interrupt Flag Bit 7
; bit position masks
mPIFAD_PIFAD0:      equ    %00000001
mPIFAD_PIFAD1:      equ    %00000010
mPIFAD_PIFAD2:      equ    %00000100
mPIFAD_PIFAD3:      equ    %00001000
mPIFAD_PIFAD4:      equ    %00010000
mPIFAD_PIFAD5:      equ    %00100000
mPIFAD_PIFAD6:      equ    %01000000
mPIFAD_PIFAD7:      equ    %10000000


;*** RTZ0CTL - SSD 0 Return to Zero Control register; 0x00000288 ***
RTZ0CTL:            equ    $00000288                                ;*** RTZ0CTL - SSD 0 Return to Zero Control register; 0x00000288 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RTZ0CTL_STEP0:      equ    0                                         ; Full Step State, bit 0
RTZ0CTL_STEP1:      equ    1                                         ; Full Step State, bit 1
RTZ0CTL_SMS:        equ    2                                         ; Stepper Motor Select
RTZ0CTL_POL:        equ    4                                         ; Polarity
RTZ0CTL_RCIR:       equ    5                                         ; Recirculation in blanking mode
RTZ0CTL_DCOIL:      equ    6                                         ; Drive Coil
RTZ0CTL_ITG:        equ    7                                         ; Integration
; bit position masks
mRTZ0CTL_STEP0:     equ    %00000001
mRTZ0CTL_STEP1:     equ    %00000010
mRTZ0CTL_SMS:       equ    %00000100
mRTZ0CTL_POL:       equ    %00010000
mRTZ0CTL_RCIR:      equ    %00100000
mRTZ0CTL_DCOIL:     equ    %01000000
mRTZ0CTL_ITG:       equ    %10000000


;*** MDC0CTL - SSD 0 Modulus Down Counter Control register; 0x00000289 ***
MDC0CTL:            equ    $00000289                                ;*** MDC0CTL - SSD 0 Modulus Down Counter Control register; 0x00000289 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MDC0CTL_AOVIE:      equ    0                                         ; Accumulator Overflow Interrupt Enable
MDC0CTL_MCEN:       equ    2                                         ; Modulus Down-Counter Enable
MDC0CTL_FLMC:       equ    3                                         ; Force Load Register into the Modulus Counter Count Register
MDC0CTL_PRE:        equ    4                                         ; Prescalar
MDC0CTL_RDMCL:      equ    5                                         ; Read Modulus Down-Counter Load
MDC0CTL_MODMC:      equ    6                                         ; Modulus Mode Enable
MDC0CTL_MCZIE:      equ    7                                         ; Modulus Counter Underflow Interrupt Enable
; bit position masks
mMDC0CTL_AOVIE:     equ    %00000001
mMDC0CTL_MCEN:      equ    %00000100
mMDC0CTL_FLMC:      equ    %00001000
mMDC0CTL_PRE:       equ    %00010000
mMDC0CTL_RDMCL:     equ    %00100000
mMDC0CTL_MODMC:     equ    %01000000
mMDC0CTL_MCZIE:     equ    %10000000


;*** SSD0CTL - SSD 0 Stepper Stall Detector Control register; 0x0000028A ***
SSD0CTL:            equ    $0000028A                                ;*** SSD0CTL - SSD 0 Stepper Stall Detector Control register; 0x0000028A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SSD0CTL_ACLKS0:     equ    0                                         ; Accumulator Sample Frequency Select, bit 0
SSD0CTL_ACLKS1:     equ    1                                         ; Accumulator Sample Frequency Select, bit 1
SSD0CTL_SSDWAI:     equ    5                                         ; SSD Disabled during Wait Mode
SSD0CTL_SDCPU:      equ    6                                         ; Sigma-Delta Converter Power Up
SSD0CTL_RTZE:       equ    7                                         ; Return to Zero Enable
; bit position masks
mSSD0CTL_ACLKS0:    equ    %00000001
mSSD0CTL_ACLKS1:    equ    %00000010
mSSD0CTL_SSDWAI:    equ    %00100000
mSSD0CTL_SDCPU:     equ    %01000000
mSSD0CTL_RTZE:      equ    %10000000


;*** SSD0FLG - SSD 0 Stepper Stall Detector Flag register; 0x0000028B ***
SSD0FLG:            equ    $0000028B                                ;*** SSD0FLG - SSD 0 Stepper Stall Detector Flag register; 0x0000028B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SSD0FLG_AOVIF:      equ    0                                         ; Accumulator Overflow Interrupt Flag
SSD0FLG_MCZIF:      equ    7                                         ; Modulus Counter Underflow Interrupt Flag
; bit position masks
mSSD0FLG_AOVIF:     equ    %00000001
mSSD0FLG_MCZIF:     equ    %10000000


;*** MDC0CNT - SSD 0 Modulus Down-Counter Count register; 0x0000028C ***
MDC0CNT:            equ    $0000028C                                ;*** MDC0CNT - SSD 0 Modulus Down-Counter Count register; 0x0000028C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MDC0CNT_MDCCNT0:    equ    0                                         ; Modulus Down-Counter Count Bits, bit 0
MDC0CNT_MDCCNT1:    equ    1                                         ; Modulus Down-Counter Count Bits, bit 1
MDC0CNT_MDCCNT2:    equ    2                                         ; Modulus Down-Counter Count Bits, bit 2
MDC0CNT_MDCCNT3:    equ    3                                         ; Modulus Down-Counter Count Bits, bit 3
MDC0CNT_MDCCNT4:    equ    4                                         ; Modulus Down-Counter Count Bits, bit 4
MDC0CNT_MDCCNT5:    equ    5                                         ; Modulus Down-Counter Count Bits, bit 5
MDC0CNT_MDCCNT6:    equ    6                                         ; Modulus Down-Counter Count Bits, bit 6
MDC0CNT_MDCCNT7:    equ    7                                         ; Modulus Down-Counter Count Bits, bit 7
MDC0CNT_MDCCNT8:    equ    8                                         ; Modulus Down-Counter Count Bits, bit 8
MDC0CNT_MDCCNT9:    equ    9                                         ; Modulus Down-Counter Count Bits, bit 9
MDC0CNT_MDCCNT10:   equ    10                                        ; Modulus Down-Counter Count Bits, bit 10
MDC0CNT_MDCCNT11:   equ    11                                        ; Modulus Down-Counter Count Bits, bit 11
MDC0CNT_MDCCNT12:   equ    12                                        ; Modulus Down-Counter Count Bits, bit 12
MDC0CNT_MDCCNT13:   equ    13                                        ; Modulus Down-Counter Count Bits, bit 13
MDC0CNT_MDCCNT14:   equ    14                                        ; Modulus Down-Counter Count Bits, bit 14
MDC0CNT_MDCCNT15:   equ    15                                        ; Modulus Down-Counter Count Bits, bit 15
; bit position masks
mMDC0CNT_MDCCNT0:   equ    %00000001
mMDC0CNT_MDCCNT1:   equ    %00000010
mMDC0CNT_MDCCNT2:   equ    %00000100
mMDC0CNT_MDCCNT3:   equ    %00001000
mMDC0CNT_MDCCNT4:   equ    %00010000
mMDC0CNT_MDCCNT5:   equ    %00100000
mMDC0CNT_MDCCNT6:   equ    %01000000
mMDC0CNT_MDCCNT7:   equ    %10000000
mMDC0CNT_MDCCNT8:   equ    %100000000
mMDC0CNT_MDCCNT9:   equ    %1000000000
mMDC0CNT_MDCCNT10:  equ    %10000000000
mMDC0CNT_MDCCNT11:  equ    %100000000000
mMDC0CNT_MDCCNT12:  equ    %1000000000000
mMDC0CNT_MDCCNT13:  equ    %10000000000000
mMDC0CNT_MDCCNT14:  equ    %100000000000000
mMDC0CNT_MDCCNT15:  equ    %1000000000000000


;*** ITG0ACC - SSD 0 Integration Accumulator register; 0x0000028E ***
ITG0ACC:            equ    $0000028E                                ;*** ITG0ACC - SSD 0 Integration Accumulator register; 0x0000028E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ITG0ACC_ITGACC0:    equ    0                                         ; Integration Accumulator Bits, bit 0
ITG0ACC_ITGACC1:    equ    1                                         ; Integration Accumulator Bits, bit 1
ITG0ACC_ITGACC2:    equ    2                                         ; Integration Accumulator Bits, bit 2
ITG0ACC_ITGACC3:    equ    3                                         ; Integration Accumulator Bits, bit 3
ITG0ACC_ITGACC4:    equ    4                                         ; Integration Accumulator Bits, bit 4
ITG0ACC_ITGACC5:    equ    5                                         ; Integration Accumulator Bits, bit 5
ITG0ACC_ITGACC6:    equ    6                                         ; Integration Accumulator Bits, bit 6
ITG0ACC_ITGACC7:    equ    7                                         ; Integration Accumulator Bits, bit 7
ITG0ACC_ITGACC8:    equ    8                                         ; Integration Accumulator Bits, bit 8
ITG0ACC_ITGACC9:    equ    9                                         ; Integration Accumulator Bits, bit 9
ITG0ACC_ITGACC10:   equ    10                                        ; Integration Accumulator Bits, bit 10
ITG0ACC_ITGACC11:   equ    11                                        ; Integration Accumulator Bits, bit 11
ITG0ACC_ITGACC12:   equ    12                                        ; Integration Accumulator Bits, bit 12
ITG0ACC_ITGACC13:   equ    13                                        ; Integration Accumulator Bits, bit 13
ITG0ACC_ITGACC14:   equ    14                                        ; Integration Accumulator Bits, bit 14
ITG0ACC_ITGACC15:   equ    15                                        ; Integration Accumulator Bits, bit 15
; bit position masks
mITG0ACC_ITGACC0:   equ    %00000001
mITG0ACC_ITGACC1:   equ    %00000010
mITG0ACC_ITGACC2:   equ    %00000100
mITG0ACC_ITGACC3:   equ    %00001000
mITG0ACC_ITGACC4:   equ    %00010000
mITG0ACC_ITGACC5:   equ    %00100000
mITG0ACC_ITGACC6:   equ    %01000000
mITG0ACC_ITGACC7:   equ    %10000000
mITG0ACC_ITGACC8:   equ    %100000000
mITG0ACC_ITGACC9:   equ    %1000000000
mITG0ACC_ITGACC10:  equ    %10000000000
mITG0ACC_ITGACC11:  equ    %100000000000
mITG0ACC_ITGACC12:  equ    %1000000000000
mITG0ACC_ITGACC13:  equ    %10000000000000
mITG0ACC_ITGACC14:  equ    %100000000000000
mITG0ACC_ITGACC15:  equ    %1000000000000000


;*** RTZ1CTL - SSD 1 Return to Zero Control register; 0x00000290 ***
RTZ1CTL:            equ    $00000290                                ;*** RTZ1CTL - SSD 1 Return to Zero Control register; 0x00000290 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RTZ1CTL_STEP0:      equ    0                                         ; Full Step State, bit 0
RTZ1CTL_STEP1:      equ    1                                         ; Full Step State, bit 1
RTZ1CTL_SMS:        equ    2                                         ; Stepper Motor Select
RTZ1CTL_POL:        equ    4                                         ; Polarity
RTZ1CTL_RCIR:       equ    5                                         ; Recirculation in blanking mode
RTZ1CTL_DCOIL:      equ    6                                         ; Drive Coil
RTZ1CTL_ITG:        equ    7                                         ; Integration
; bit position masks
mRTZ1CTL_STEP0:     equ    %00000001
mRTZ1CTL_STEP1:     equ    %00000010
mRTZ1CTL_SMS:       equ    %00000100
mRTZ1CTL_POL:       equ    %00010000
mRTZ1CTL_RCIR:      equ    %00100000
mRTZ1CTL_DCOIL:     equ    %01000000
mRTZ1CTL_ITG:       equ    %10000000


;*** MDC1CTL - SSD 1 Modulus Down Counter Control register; 0x00000291 ***
MDC1CTL:            equ    $00000291                                ;*** MDC1CTL - SSD 1 Modulus Down Counter Control register; 0x00000291 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MDC1CTL_AOVIE:      equ    0                                         ; Accumulator Overflow Interrupt Enable
MDC1CTL_MCEN:       equ    2                                         ; Modulus Down-Counter Enable
MDC1CTL_FLMC:       equ    3                                         ; Force Load Register into the Modulus Counter Count Register
MDC1CTL_PRE:        equ    4                                         ; Prescalar
MDC1CTL_RDMCL:      equ    5                                         ; Read Modulus Down-Counter Load
MDC1CTL_MODMC:      equ    6                                         ; Modulus Mode Enable
MDC1CTL_MCZIE:      equ    7                                         ; Modulus Counter Underflow Interrupt Enable
; bit position masks
mMDC1CTL_AOVIE:     equ    %00000001
mMDC1CTL_MCEN:      equ    %00000100
mMDC1CTL_FLMC:      equ    %00001000
mMDC1CTL_PRE:       equ    %00010000
mMDC1CTL_RDMCL:     equ    %00100000
mMDC1CTL_MODMC:     equ    %01000000
mMDC1CTL_MCZIE:     equ    %10000000


;*** SSD1CTL - SSD 1 Stepper Stall Detector Control register; 0x00000292 ***
SSD1CTL:            equ    $00000292                                ;*** SSD1CTL - SSD 1 Stepper Stall Detector Control register; 0x00000292 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SSD1CTL_ACLKS0:     equ    0                                         ; Accumulator Sample Frequency Select, bit 0
SSD1CTL_ACLKS1:     equ    1                                         ; Accumulator Sample Frequency Select, bit 1
SSD1CTL_SSDWAI:     equ    5                                         ; SSD Disabled during Wait Mode
SSD1CTL_SDCPU:      equ    6                                         ; Sigma-Delta Converter Power Up
SSD1CTL_RTZE:       equ    7                                         ; Return to Zero Enable
; bit position masks
mSSD1CTL_ACLKS0:    equ    %00000001
mSSD1CTL_ACLKS1:    equ    %00000010
mSSD1CTL_SSDWAI:    equ    %00100000
mSSD1CTL_SDCPU:     equ    %01000000
mSSD1CTL_RTZE:      equ    %10000000


;*** SSD1FLG - SSD 1 Stepper Stall Detector Flag register; 0x00000293 ***
SSD1FLG:            equ    $00000293                                ;*** SSD1FLG - SSD 1 Stepper Stall Detector Flag register; 0x00000293 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SSD1FLG_AOVIF:      equ    0                                         ; Accumulator Overflow Interrupt Flag
SSD1FLG_MCZIF:      equ    7                                         ; Modulus Counter Underflow Interrupt Flag
; bit position masks
mSSD1FLG_AOVIF:     equ    %00000001
mSSD1FLG_MCZIF:     equ    %10000000


;*** MDC1CNT - SSD 1 Modulus Down-Counter Count register; 0x00000294 ***
MDC1CNT:            equ    $00000294                                ;*** MDC1CNT - SSD 1 Modulus Down-Counter Count register; 0x00000294 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MDC1CNT_MDCCNT0:    equ    0                                         ; Modulus Down-Counter Count Bits, bit 0
MDC1CNT_MDCCNT1:    equ    1                                         ; Modulus Down-Counter Count Bits, bit 1
MDC1CNT_MDCCNT2:    equ    2                                         ; Modulus Down-Counter Count Bits, bit 2
MDC1CNT_MDCCNT3:    equ    3                                         ; Modulus Down-Counter Count Bits, bit 3
MDC1CNT_MDCCNT4:    equ    4                                         ; Modulus Down-Counter Count Bits, bit 4
MDC1CNT_MDCCNT5:    equ    5                                         ; Modulus Down-Counter Count Bits, bit 5
MDC1CNT_MDCCNT6:    equ    6                                         ; Modulus Down-Counter Count Bits, bit 6
MDC1CNT_MDCCNT7:    equ    7                                         ; Modulus Down-Counter Count Bits, bit 7
MDC1CNT_MDCCNT8:    equ    8                                         ; Modulus Down-Counter Count Bits, bit 8
MDC1CNT_MDCCNT9:    equ    9                                         ; Modulus Down-Counter Count Bits, bit 9
MDC1CNT_MDCCNT10:   equ    10                                        ; Modulus Down-Counter Count Bits, bit 10
MDC1CNT_MDCCNT11:   equ    11                                        ; Modulus Down-Counter Count Bits, bit 11
MDC1CNT_MDCCNT12:   equ    12                                        ; Modulus Down-Counter Count Bits, bit 12
MDC1CNT_MDCCNT13:   equ    13                                        ; Modulus Down-Counter Count Bits, bit 13
MDC1CNT_MDCCNT14:   equ    14                                        ; Modulus Down-Counter Count Bits, bit 14
MDC1CNT_MDCCNT15:   equ    15                                        ; Modulus Down-Counter Count Bits, bit 15
; bit position masks
mMDC1CNT_MDCCNT0:   equ    %00000001
mMDC1CNT_MDCCNT1:   equ    %00000010
mMDC1CNT_MDCCNT2:   equ    %00000100
mMDC1CNT_MDCCNT3:   equ    %00001000
mMDC1CNT_MDCCNT4:   equ    %00010000
mMDC1CNT_MDCCNT5:   equ    %00100000
mMDC1CNT_MDCCNT6:   equ    %01000000
mMDC1CNT_MDCCNT7:   equ    %10000000
mMDC1CNT_MDCCNT8:   equ    %100000000
mMDC1CNT_MDCCNT9:   equ    %1000000000
mMDC1CNT_MDCCNT10:  equ    %10000000000
mMDC1CNT_MDCCNT11:  equ    %100000000000
mMDC1CNT_MDCCNT12:  equ    %1000000000000
mMDC1CNT_MDCCNT13:  equ    %10000000000000
mMDC1CNT_MDCCNT14:  equ    %100000000000000
mMDC1CNT_MDCCNT15:  equ    %1000000000000000


;*** ITG1ACC - SSD 1 Integration Accumulator register; 0x00000296 ***
ITG1ACC:            equ    $00000296                                ;*** ITG1ACC - SSD 1 Integration Accumulator register; 0x00000296 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ITG1ACC_ITGACC0:    equ    0                                         ; Integration Accumulator Bits, bit 0
ITG1ACC_ITGACC1:    equ    1                                         ; Integration Accumulator Bits, bit 1
ITG1ACC_ITGACC2:    equ    2                                         ; Integration Accumulator Bits, bit 2
ITG1ACC_ITGACC3:    equ    3                                         ; Integration Accumulator Bits, bit 3
ITG1ACC_ITGACC4:    equ    4                                         ; Integration Accumulator Bits, bit 4
ITG1ACC_ITGACC5:    equ    5                                         ; Integration Accumulator Bits, bit 5
ITG1ACC_ITGACC6:    equ    6                                         ; Integration Accumulator Bits, bit 6
ITG1ACC_ITGACC7:    equ    7                                         ; Integration Accumulator Bits, bit 7
ITG1ACC_ITGACC8:    equ    8                                         ; Integration Accumulator Bits, bit 8
ITG1ACC_ITGACC9:    equ    9                                         ; Integration Accumulator Bits, bit 9
ITG1ACC_ITGACC10:   equ    10                                        ; Integration Accumulator Bits, bit 10
ITG1ACC_ITGACC11:   equ    11                                        ; Integration Accumulator Bits, bit 11
ITG1ACC_ITGACC12:   equ    12                                        ; Integration Accumulator Bits, bit 12
ITG1ACC_ITGACC13:   equ    13                                        ; Integration Accumulator Bits, bit 13
ITG1ACC_ITGACC14:   equ    14                                        ; Integration Accumulator Bits, bit 14
ITG1ACC_ITGACC15:   equ    15                                        ; Integration Accumulator Bits, bit 15
; bit position masks
mITG1ACC_ITGACC0:   equ    %00000001
mITG1ACC_ITGACC1:   equ    %00000010
mITG1ACC_ITGACC2:   equ    %00000100
mITG1ACC_ITGACC3:   equ    %00001000
mITG1ACC_ITGACC4:   equ    %00010000
mITG1ACC_ITGACC5:   equ    %00100000
mITG1ACC_ITGACC6:   equ    %01000000
mITG1ACC_ITGACC7:   equ    %10000000
mITG1ACC_ITGACC8:   equ    %100000000
mITG1ACC_ITGACC9:   equ    %1000000000
mITG1ACC_ITGACC10:  equ    %10000000000
mITG1ACC_ITGACC11:  equ    %100000000000
mITG1ACC_ITGACC12:  equ    %1000000000000
mITG1ACC_ITGACC13:  equ    %10000000000000
mITG1ACC_ITGACC14:  equ    %100000000000000
mITG1ACC_ITGACC15:  equ    %1000000000000000


;*** RTZ2CTL - SSD 2 Return to Zero Control register; 0x00000298 ***
RTZ2CTL:            equ    $00000298                                ;*** RTZ2CTL - SSD 2 Return to Zero Control register; 0x00000298 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RTZ2CTL_STEP0:      equ    0                                         ; Full Step State, bit 0
RTZ2CTL_STEP1:      equ    1                                         ; Full Step State, bit 1
RTZ2CTL_SMS:        equ    2                                         ; Stepper Motor Select
RTZ2CTL_POL:        equ    4                                         ; Polarity
RTZ2CTL_RCIR:       equ    5                                         ; Recirculation in blanking mode
RTZ2CTL_DCOIL:      equ    6                                         ; Drive Coil
RTZ2CTL_ITG:        equ    7                                         ; Integration
; bit position masks
mRTZ2CTL_STEP0:     equ    %00000001
mRTZ2CTL_STEP1:     equ    %00000010
mRTZ2CTL_SMS:       equ    %00000100
mRTZ2CTL_POL:       equ    %00010000
mRTZ2CTL_RCIR:      equ    %00100000
mRTZ2CTL_DCOIL:     equ    %01000000
mRTZ2CTL_ITG:       equ    %10000000


;*** MDC2CTL - SSD 2 Modulus Down Counter Control register; 0x00000299 ***
MDC2CTL:            equ    $00000299                                ;*** MDC2CTL - SSD 2 Modulus Down Counter Control register; 0x00000299 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MDC2CTL_AOVIE:      equ    0                                         ; Accumulator Overflow Interrupt Enable
MDC2CTL_MCEN:       equ    2                                         ; Modulus Down-Counter Enable
MDC2CTL_FLMC:       equ    3                                         ; Force Load Register into the Modulus Counter Count Register
MDC2CTL_PRE:        equ    4                                         ; Prescalar
MDC2CTL_RDMCL:      equ    5                                         ; Read Modulus Down-Counter Load
MDC2CTL_MODMC:      equ    6                                         ; Modulus Mode Enable
MDC2CTL_MCZIE:      equ    7                                         ; Modulus Counter Underflow Interrupt Enable
; bit position masks
mMDC2CTL_AOVIE:     equ    %00000001
mMDC2CTL_MCEN:      equ    %00000100
mMDC2CTL_FLMC:      equ    %00001000
mMDC2CTL_PRE:       equ    %00010000
mMDC2CTL_RDMCL:     equ    %00100000
mMDC2CTL_MODMC:     equ    %01000000
mMDC2CTL_MCZIE:     equ    %10000000


;*** SSD2CTL - SSD 2 Stepper Stall Detector Control register; 0x0000029A ***
SSD2CTL:            equ    $0000029A                                ;*** SSD2CTL - SSD 2 Stepper Stall Detector Control register; 0x0000029A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SSD2CTL_ACLKS0:     equ    0                                         ; Accumulator Sample Frequency Select, bit 0
SSD2CTL_ACLKS1:     equ    1                                         ; Accumulator Sample Frequency Select, bit 1
SSD2CTL_SSDWAI:     equ    5                                         ; SSD Disabled during Wait Mode
SSD2CTL_SDCPU:      equ    6                                         ; Sigma-Delta Converter Power Up
SSD2CTL_RTZE:       equ    7                                         ; Return to Zero Enable
; bit position masks
mSSD2CTL_ACLKS0:    equ    %00000001
mSSD2CTL_ACLKS1:    equ    %00000010
mSSD2CTL_SSDWAI:    equ    %00100000
mSSD2CTL_SDCPU:     equ    %01000000
mSSD2CTL_RTZE:      equ    %10000000


;*** SSD2FLG - SSD 2 Stepper Stall Detector Flag register; 0x0000029B ***
SSD2FLG:            equ    $0000029B                                ;*** SSD2FLG - SSD 2 Stepper Stall Detector Flag register; 0x0000029B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SSD2FLG_AOVIF:      equ    0                                         ; Accumulator Overflow Interrupt Flag
SSD2FLG_MCZIF:      equ    7                                         ; Modulus Counter Underflow Interrupt Flag
; bit position masks
mSSD2FLG_AOVIF:     equ    %00000001
mSSD2FLG_MCZIF:     equ    %10000000


;*** MDC2CNT - SSD 2 Modulus Down-Counter Count register; 0x0000029C ***
MDC2CNT:            equ    $0000029C                                ;*** MDC2CNT - SSD 2 Modulus Down-Counter Count register; 0x0000029C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MDC2CNT_MDCCNT0:    equ    0                                         ; Modulus Down-Counter Count Bits, bit 0
MDC2CNT_MDCCNT1:    equ    1                                         ; Modulus Down-Counter Count Bits, bit 1
MDC2CNT_MDCCNT2:    equ    2                                         ; Modulus Down-Counter Count Bits, bit 2
MDC2CNT_MDCCNT3:    equ    3                                         ; Modulus Down-Counter Count Bits, bit 3
MDC2CNT_MDCCNT4:    equ    4                                         ; Modulus Down-Counter Count Bits, bit 4
MDC2CNT_MDCCNT5:    equ    5                                         ; Modulus Down-Counter Count Bits, bit 5
MDC2CNT_MDCCNT6:    equ    6                                         ; Modulus Down-Counter Count Bits, bit 6
MDC2CNT_MDCCNT7:    equ    7                                         ; Modulus Down-Counter Count Bits, bit 7
MDC2CNT_MDCCNT8:    equ    8                                         ; Modulus Down-Counter Count Bits, bit 8
MDC2CNT_MDCCNT9:    equ    9                                         ; Modulus Down-Counter Count Bits, bit 9
MDC2CNT_MDCCNT10:   equ    10                                        ; Modulus Down-Counter Count Bits, bit 10
MDC2CNT_MDCCNT11:   equ    11                                        ; Modulus Down-Counter Count Bits, bit 11
MDC2CNT_MDCCNT12:   equ    12                                        ; Modulus Down-Counter Count Bits, bit 12
MDC2CNT_MDCCNT13:   equ    13                                        ; Modulus Down-Counter Count Bits, bit 13
MDC2CNT_MDCCNT14:   equ    14                                        ; Modulus Down-Counter Count Bits, bit 14
MDC2CNT_MDCCNT15:   equ    15                                        ; Modulus Down-Counter Count Bits, bit 15
; bit position masks
mMDC2CNT_MDCCNT0:   equ    %00000001
mMDC2CNT_MDCCNT1:   equ    %00000010
mMDC2CNT_MDCCNT2:   equ    %00000100
mMDC2CNT_MDCCNT3:   equ    %00001000
mMDC2CNT_MDCCNT4:   equ    %00010000
mMDC2CNT_MDCCNT5:   equ    %00100000
mMDC2CNT_MDCCNT6:   equ    %01000000
mMDC2CNT_MDCCNT7:   equ    %10000000
mMDC2CNT_MDCCNT8:   equ    %100000000
mMDC2CNT_MDCCNT9:   equ    %1000000000
mMDC2CNT_MDCCNT10:  equ    %10000000000
mMDC2CNT_MDCCNT11:  equ    %100000000000
mMDC2CNT_MDCCNT12:  equ    %1000000000000
mMDC2CNT_MDCCNT13:  equ    %10000000000000
mMDC2CNT_MDCCNT14:  equ    %100000000000000
mMDC2CNT_MDCCNT15:  equ    %1000000000000000


;*** ITG2ACC - SSD 2 Integration Accumulator register; 0x0000029E ***
ITG2ACC:            equ    $0000029E                                ;*** ITG2ACC - SSD 2 Integration Accumulator register; 0x0000029E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ITG2ACC_ITGACC0:    equ    0                                         ; Integration Accumulator Bits, bit 0
ITG2ACC_ITGACC1:    equ    1                                         ; Integration Accumulator Bits, bit 1
ITG2ACC_ITGACC2:    equ    2                                         ; Integration Accumulator Bits, bit 2
ITG2ACC_ITGACC3:    equ    3                                         ; Integration Accumulator Bits, bit 3
ITG2ACC_ITGACC4:    equ    4                                         ; Integration Accumulator Bits, bit 4
ITG2ACC_ITGACC5:    equ    5                                         ; Integration Accumulator Bits, bit 5
ITG2ACC_ITGACC6:    equ    6                                         ; Integration Accumulator Bits, bit 6
ITG2ACC_ITGACC7:    equ    7                                         ; Integration Accumulator Bits, bit 7
ITG2ACC_ITGACC8:    equ    8                                         ; Integration Accumulator Bits, bit 8
ITG2ACC_ITGACC9:    equ    9                                         ; Integration Accumulator Bits, bit 9
ITG2ACC_ITGACC10:   equ    10                                        ; Integration Accumulator Bits, bit 10
ITG2ACC_ITGACC11:   equ    11                                        ; Integration Accumulator Bits, bit 11
ITG2ACC_ITGACC12:   equ    12                                        ; Integration Accumulator Bits, bit 12
ITG2ACC_ITGACC13:   equ    13                                        ; Integration Accumulator Bits, bit 13
ITG2ACC_ITGACC14:   equ    14                                        ; Integration Accumulator Bits, bit 14
ITG2ACC_ITGACC15:   equ    15                                        ; Integration Accumulator Bits, bit 15
; bit position masks
mITG2ACC_ITGACC0:   equ    %00000001
mITG2ACC_ITGACC1:   equ    %00000010
mITG2ACC_ITGACC2:   equ    %00000100
mITG2ACC_ITGACC3:   equ    %00001000
mITG2ACC_ITGACC4:   equ    %00010000
mITG2ACC_ITGACC5:   equ    %00100000
mITG2ACC_ITGACC6:   equ    %01000000
mITG2ACC_ITGACC7:   equ    %10000000
mITG2ACC_ITGACC8:   equ    %100000000
mITG2ACC_ITGACC9:   equ    %1000000000
mITG2ACC_ITGACC10:  equ    %10000000000
mITG2ACC_ITGACC11:  equ    %100000000000
mITG2ACC_ITGACC12:  equ    %1000000000000
mITG2ACC_ITGACC13:  equ    %10000000000000
mITG2ACC_ITGACC14:  equ    %100000000000000
mITG2ACC_ITGACC15:  equ    %1000000000000000


;*** RTZ3CTL - SSD 3 Return to Zero Control register; 0x000002A0 ***
RTZ3CTL:            equ    $000002A0                                ;*** RTZ3CTL - SSD 3 Return to Zero Control register; 0x000002A0 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RTZ3CTL_STEP0:      equ    0                                         ; Full Step State, bit 0
RTZ3CTL_STEP1:      equ    1                                         ; Full Step State, bit 1
RTZ3CTL_SMS:        equ    2                                         ; Stepper Motor Select
RTZ3CTL_POL:        equ    4                                         ; Polarity
RTZ3CTL_RCIR:       equ    5                                         ; Recirculation in blanking mode
RTZ3CTL_DCOIL:      equ    6                                         ; Drive Coil
RTZ3CTL_ITG:        equ    7                                         ; Integration
; bit position masks
mRTZ3CTL_STEP0:     equ    %00000001
mRTZ3CTL_STEP1:     equ    %00000010
mRTZ3CTL_SMS:       equ    %00000100
mRTZ3CTL_POL:       equ    %00010000
mRTZ3CTL_RCIR:      equ    %00100000
mRTZ3CTL_DCOIL:     equ    %01000000
mRTZ3CTL_ITG:       equ    %10000000


;*** MDC3CTL - SSD 3 Modulus Down Counter Control register; 0x000002A1 ***
MDC3CTL:            equ    $000002A1                                ;*** MDC3CTL - SSD 3 Modulus Down Counter Control register; 0x000002A1 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MDC3CTL_AOVIE:      equ    0                                         ; Accumulator Overflow Interrupt Enable
MDC3CTL_MCEN:       equ    2                                         ; Modulus Down-Counter Enable
MDC3CTL_FLMC:       equ    3                                         ; Force Load Register into the Modulus Counter Count Register
MDC3CTL_PRE:        equ    4                                         ; Prescalar
MDC3CTL_RDMCL:      equ    5                                         ; Read Modulus Down-Counter Load
MDC3CTL_MODMC:      equ    6                                         ; Modulus Mode Enable
MDC3CTL_MCZIE:      equ    7                                         ; Modulus Counter Underflow Interrupt Enable
; bit position masks
mMDC3CTL_AOVIE:     equ    %00000001
mMDC3CTL_MCEN:      equ    %00000100
mMDC3CTL_FLMC:      equ    %00001000
mMDC3CTL_PRE:       equ    %00010000
mMDC3CTL_RDMCL:     equ    %00100000
mMDC3CTL_MODMC:     equ    %01000000
mMDC3CTL_MCZIE:     equ    %10000000


;*** SSD3CTL - SSD 3 Stepper Stall Detector Control register; 0x000002A2 ***
SSD3CTL:            equ    $000002A2                                ;*** SSD3CTL - SSD 3 Stepper Stall Detector Control register; 0x000002A2 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SSD3CTL_ACLKS0:     equ    0                                         ; Accumulator Sample Frequency Select, bit 0
SSD3CTL_ACLKS1:     equ    1                                         ; Accumulator Sample Frequency Select, bit 1
SSD3CTL_SSDWAI:     equ    5                                         ; SSD Disabled during Wait Mode
SSD3CTL_SDCPU:      equ    6                                         ; Sigma-Delta Converter Power Up
SSD3CTL_RTZE:       equ    7                                         ; Return to Zero Enable
; bit position masks
mSSD3CTL_ACLKS0:    equ    %00000001
mSSD3CTL_ACLKS1:    equ    %00000010
mSSD3CTL_SSDWAI:    equ    %00100000
mSSD3CTL_SDCPU:     equ    %01000000
mSSD3CTL_RTZE:      equ    %10000000


;*** SSD3FLG - SSD 3 Stepper Stall Detector Flag register; 0x000002A3 ***
SSD3FLG:            equ    $000002A3                                ;*** SSD3FLG - SSD 3 Stepper Stall Detector Flag register; 0x000002A3 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SSD3FLG_AOVIF:      equ    0                                         ; Accumulator Overflow Interrupt Flag
SSD3FLG_MCZIF:      equ    7                                         ; Modulus Counter Underflow Interrupt Flag
; bit position masks
mSSD3FLG_AOVIF:     equ    %00000001
mSSD3FLG_MCZIF:     equ    %10000000


;*** MDC3CNT - SSD 3 Modulus Down-Counter Count register; 0x000002A4 ***
MDC3CNT:            equ    $000002A4                                ;*** MDC3CNT - SSD 3 Modulus Down-Counter Count register; 0x000002A4 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MDC3CNT_MDCCNT0:    equ    0                                         ; Modulus Down-Counter Count Bits, bit 0
MDC3CNT_MDCCNT1:    equ    1                                         ; Modulus Down-Counter Count Bits, bit 1
MDC3CNT_MDCCNT2:    equ    2                                         ; Modulus Down-Counter Count Bits, bit 2
MDC3CNT_MDCCNT3:    equ    3                                         ; Modulus Down-Counter Count Bits, bit 3
MDC3CNT_MDCCNT4:    equ    4                                         ; Modulus Down-Counter Count Bits, bit 4
MDC3CNT_MDCCNT5:    equ    5                                         ; Modulus Down-Counter Count Bits, bit 5
MDC3CNT_MDCCNT6:    equ    6                                         ; Modulus Down-Counter Count Bits, bit 6
MDC3CNT_MDCCNT7:    equ    7                                         ; Modulus Down-Counter Count Bits, bit 7
MDC3CNT_MDCCNT8:    equ    8                                         ; Modulus Down-Counter Count Bits, bit 8
MDC3CNT_MDCCNT9:    equ    9                                         ; Modulus Down-Counter Count Bits, bit 9
MDC3CNT_MDCCNT10:   equ    10                                        ; Modulus Down-Counter Count Bits, bit 10
MDC3CNT_MDCCNT11:   equ    11                                        ; Modulus Down-Counter Count Bits, bit 11
MDC3CNT_MDCCNT12:   equ    12                                        ; Modulus Down-Counter Count Bits, bit 12
MDC3CNT_MDCCNT13:   equ    13                                        ; Modulus Down-Counter Count Bits, bit 13
MDC3CNT_MDCCNT14:   equ    14                                        ; Modulus Down-Counter Count Bits, bit 14
MDC3CNT_MDCCNT15:   equ    15                                        ; Modulus Down-Counter Count Bits, bit 15
; bit position masks
mMDC3CNT_MDCCNT0:   equ    %00000001
mMDC3CNT_MDCCNT1:   equ    %00000010
mMDC3CNT_MDCCNT2:   equ    %00000100
mMDC3CNT_MDCCNT3:   equ    %00001000
mMDC3CNT_MDCCNT4:   equ    %00010000
mMDC3CNT_MDCCNT5:   equ    %00100000
mMDC3CNT_MDCCNT6:   equ    %01000000
mMDC3CNT_MDCCNT7:   equ    %10000000
mMDC3CNT_MDCCNT8:   equ    %100000000
mMDC3CNT_MDCCNT9:   equ    %1000000000
mMDC3CNT_MDCCNT10:  equ    %10000000000
mMDC3CNT_MDCCNT11:  equ    %100000000000
mMDC3CNT_MDCCNT12:  equ    %1000000000000
mMDC3CNT_MDCCNT13:  equ    %10000000000000
mMDC3CNT_MDCCNT14:  equ    %100000000000000
mMDC3CNT_MDCCNT15:  equ    %1000000000000000


;*** ITG3ACC - SSD 3 Integration Accumulator register; 0x000002A6 ***
ITG3ACC:            equ    $000002A6                                ;*** ITG3ACC - SSD 3 Integration Accumulator register; 0x000002A6 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ITG3ACC_ITGACC0:    equ    0                                         ; Integration Accumulator Bits, bit 0
ITG3ACC_ITGACC1:    equ    1                                         ; Integration Accumulator Bits, bit 1
ITG3ACC_ITGACC2:    equ    2                                         ; Integration Accumulator Bits, bit 2
ITG3ACC_ITGACC3:    equ    3                                         ; Integration Accumulator Bits, bit 3
ITG3ACC_ITGACC4:    equ    4                                         ; Integration Accumulator Bits, bit 4
ITG3ACC_ITGACC5:    equ    5                                         ; Integration Accumulator Bits, bit 5
ITG3ACC_ITGACC6:    equ    6                                         ; Integration Accumulator Bits, bit 6
ITG3ACC_ITGACC7:    equ    7                                         ; Integration Accumulator Bits, bit 7
ITG3ACC_ITGACC8:    equ    8                                         ; Integration Accumulator Bits, bit 8
ITG3ACC_ITGACC9:    equ    9                                         ; Integration Accumulator Bits, bit 9
ITG3ACC_ITGACC10:   equ    10                                        ; Integration Accumulator Bits, bit 10
ITG3ACC_ITGACC11:   equ    11                                        ; Integration Accumulator Bits, bit 11
ITG3ACC_ITGACC12:   equ    12                                        ; Integration Accumulator Bits, bit 12
ITG3ACC_ITGACC13:   equ    13                                        ; Integration Accumulator Bits, bit 13
ITG3ACC_ITGACC14:   equ    14                                        ; Integration Accumulator Bits, bit 14
ITG3ACC_ITGACC15:   equ    15                                        ; Integration Accumulator Bits, bit 15
; bit position masks
mITG3ACC_ITGACC0:   equ    %00000001
mITG3ACC_ITGACC1:   equ    %00000010
mITG3ACC_ITGACC2:   equ    %00000100
mITG3ACC_ITGACC3:   equ    %00001000
mITG3ACC_ITGACC4:   equ    %00010000
mITG3ACC_ITGACC5:   equ    %00100000
mITG3ACC_ITGACC6:   equ    %01000000
mITG3ACC_ITGACC7:   equ    %10000000
mITG3ACC_ITGACC8:   equ    %100000000
mITG3ACC_ITGACC9:   equ    %1000000000
mITG3ACC_ITGACC10:  equ    %10000000000
mITG3ACC_ITGACC11:  equ    %100000000000
mITG3ACC_ITGACC12:  equ    %1000000000000
mITG3ACC_ITGACC13:  equ    %10000000000000
mITG3ACC_ITGACC14:  equ    %100000000000000
mITG3ACC_ITGACC15:  equ    %1000000000000000


;*** BAKEY0 - Backdoor Access Key 0; 0x0000FF00 ***
BAKEY0:             equ    $0000FF00                                ;*** BAKEY0 - Backdoor Access Key 0; 0x0000FF00 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
BAKEY0_KEY0:        equ    0                                         ; Backdoor Access Key bits, bit 0
BAKEY0_KEY1:        equ    1                                         ; Backdoor Access Key bits, bit 1
BAKEY0_KEY2:        equ    2                                         ; Backdoor Access Key bits, bit 2
BAKEY0_KEY3:        equ    3                                         ; Backdoor Access Key bits, bit 3
BAKEY0_KEY4:        equ    4                                         ; Backdoor Access Key bits, bit 4
BAKEY0_KEY5:        equ    5                                         ; Backdoor Access Key bits, bit 5
BAKEY0_KEY6:        equ    6                                         ; Backdoor Access Key bits, bit 6
BAKEY0_KEY7:        equ    7                                         ; Backdoor Access Key bits, bit 7
BAKEY0_KEY8:        equ    8                                         ; Backdoor Access Key bits, bit 8
BAKEY0_KEY9:        equ    9                                         ; Backdoor Access Key bits, bit 9
BAKEY0_KEY10:       equ    10                                        ; Backdoor Access Key bits, bit 10
BAKEY0_KEY11:       equ    11                                        ; Backdoor Access Key bits, bit 11
BAKEY0_KEY12:       equ    12                                        ; Backdoor Access Key bits, bit 12
BAKEY0_KEY13:       equ    13                                        ; Backdoor Access Key bits, bit 13
BAKEY0_KEY14:       equ    14                                        ; Backdoor Access Key bits, bit 14
BAKEY0_KEY15:       equ    15                                        ; Backdoor Access Key bits, bit 15
; bit position masks
mBAKEY0_KEY0:       equ    %00000001
mBAKEY0_KEY1:       equ    %00000010
mBAKEY0_KEY2:       equ    %00000100
mBAKEY0_KEY3:       equ    %00001000
mBAKEY0_KEY4:       equ    %00010000
mBAKEY0_KEY5:       equ    %00100000
mBAKEY0_KEY6:       equ    %01000000
mBAKEY0_KEY7:       equ    %10000000
mBAKEY0_KEY8:       equ    %100000000
mBAKEY0_KEY9:       equ    %1000000000
mBAKEY0_KEY10:      equ    %10000000000
mBAKEY0_KEY11:      equ    %100000000000
mBAKEY0_KEY12:      equ    %1000000000000
mBAKEY0_KEY13:      equ    %10000000000000
mBAKEY0_KEY14:      equ    %100000000000000
mBAKEY0_KEY15:      equ    %1000000000000000


;*** BAKEY1 - Backdoor Access Key 1; 0x0000FF02 ***
BAKEY1:             equ    $0000FF02                                ;*** BAKEY1 - Backdoor Access Key 1; 0x0000FF02 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
BAKEY1_KEY0:        equ    0                                         ; Backdoor Access Key bits, bit 0
BAKEY1_KEY1:        equ    1                                         ; Backdoor Access Key bits, bit 1
BAKEY1_KEY2:        equ    2                                         ; Backdoor Access Key bits, bit 2
BAKEY1_KEY3:        equ    3                                         ; Backdoor Access Key bits, bit 3
BAKEY1_KEY4:        equ    4                                         ; Backdoor Access Key bits, bit 4
BAKEY1_KEY5:        equ    5                                         ; Backdoor Access Key bits, bit 5
BAKEY1_KEY6:        equ    6                                         ; Backdoor Access Key bits, bit 6
BAKEY1_KEY7:        equ    7                                         ; Backdoor Access Key bits, bit 7
BAKEY1_KEY8:        equ    8                                         ; Backdoor Access Key bits, bit 8
BAKEY1_KEY9:        equ    9                                         ; Backdoor Access Key bits, bit 9
BAKEY1_KEY10:       equ    10                                        ; Backdoor Access Key bits, bit 10
BAKEY1_KEY11:       equ    11                                        ; Backdoor Access Key bits, bit 11
BAKEY1_KEY12:       equ    12                                        ; Backdoor Access Key bits, bit 12
BAKEY1_KEY13:       equ    13                                        ; Backdoor Access Key bits, bit 13
BAKEY1_KEY14:       equ    14                                        ; Backdoor Access Key bits, bit 14
BAKEY1_KEY15:       equ    15                                        ; Backdoor Access Key bits, bit 15
; bit position masks
mBAKEY1_KEY0:       equ    %00000001
mBAKEY1_KEY1:       equ    %00000010
mBAKEY1_KEY2:       equ    %00000100
mBAKEY1_KEY3:       equ    %00001000
mBAKEY1_KEY4:       equ    %00010000
mBAKEY1_KEY5:       equ    %00100000
mBAKEY1_KEY6:       equ    %01000000
mBAKEY1_KEY7:       equ    %10000000
mBAKEY1_KEY8:       equ    %100000000
mBAKEY1_KEY9:       equ    %1000000000
mBAKEY1_KEY10:      equ    %10000000000
mBAKEY1_KEY11:      equ    %100000000000
mBAKEY1_KEY12:      equ    %1000000000000
mBAKEY1_KEY13:      equ    %10000000000000
mBAKEY1_KEY14:      equ    %100000000000000
mBAKEY1_KEY15:      equ    %1000000000000000


;*** BAKEY2 - Backdoor Access Key 2; 0x0000FF04 ***
BAKEY2:             equ    $0000FF04                                ;*** BAKEY2 - Backdoor Access Key 2; 0x0000FF04 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
BAKEY2_KEY0:        equ    0                                         ; Backdoor Access Key bits, bit 0
BAKEY2_KEY1:        equ    1                                         ; Backdoor Access Key bits, bit 1
BAKEY2_KEY2:        equ    2                                         ; Backdoor Access Key bits, bit 2
BAKEY2_KEY3:        equ    3                                         ; Backdoor Access Key bits, bit 3
BAKEY2_KEY4:        equ    4                                         ; Backdoor Access Key bits, bit 4
BAKEY2_KEY5:        equ    5                                         ; Backdoor Access Key bits, bit 5
BAKEY2_KEY6:        equ    6                                         ; Backdoor Access Key bits, bit 6
BAKEY2_KEY7:        equ    7                                         ; Backdoor Access Key bits, bit 7
BAKEY2_KEY8:        equ    8                                         ; Backdoor Access Key bits, bit 8
BAKEY2_KEY9:        equ    9                                         ; Backdoor Access Key bits, bit 9
BAKEY2_KEY10:       equ    10                                        ; Backdoor Access Key bits, bit 10
BAKEY2_KEY11:       equ    11                                        ; Backdoor Access Key bits, bit 11
BAKEY2_KEY12:       equ    12                                        ; Backdoor Access Key bits, bit 12
BAKEY2_KEY13:       equ    13                                        ; Backdoor Access Key bits, bit 13
BAKEY2_KEY14:       equ    14                                        ; Backdoor Access Key bits, bit 14
BAKEY2_KEY15:       equ    15                                        ; Backdoor Access Key bits, bit 15
; bit position masks
mBAKEY2_KEY0:       equ    %00000001
mBAKEY2_KEY1:       equ    %00000010
mBAKEY2_KEY2:       equ    %00000100
mBAKEY2_KEY3:       equ    %00001000
mBAKEY2_KEY4:       equ    %00010000
mBAKEY2_KEY5:       equ    %00100000
mBAKEY2_KEY6:       equ    %01000000
mBAKEY2_KEY7:       equ    %10000000
mBAKEY2_KEY8:       equ    %100000000
mBAKEY2_KEY9:       equ    %1000000000
mBAKEY2_KEY10:      equ    %10000000000
mBAKEY2_KEY11:      equ    %100000000000
mBAKEY2_KEY12:      equ    %1000000000000
mBAKEY2_KEY13:      equ    %10000000000000
mBAKEY2_KEY14:      equ    %100000000000000
mBAKEY2_KEY15:      equ    %1000000000000000


;*** BAKEY3 - Backdoor Access Key 3; 0x0000FF06 ***
BAKEY3:             equ    $0000FF06                                ;*** BAKEY3 - Backdoor Access Key 3; 0x0000FF06 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
BAKEY3_KEY0:        equ    0                                         ; Backdoor Access Key bits, bit 0
BAKEY3_KEY1:        equ    1                                         ; Backdoor Access Key bits, bit 1
BAKEY3_KEY2:        equ    2                                         ; Backdoor Access Key bits, bit 2
BAKEY3_KEY3:        equ    3                                         ; Backdoor Access Key bits, bit 3
BAKEY3_KEY4:        equ    4                                         ; Backdoor Access Key bits, bit 4
BAKEY3_KEY5:        equ    5                                         ; Backdoor Access Key bits, bit 5
BAKEY3_KEY6:        equ    6                                         ; Backdoor Access Key bits, bit 6
BAKEY3_KEY7:        equ    7                                         ; Backdoor Access Key bits, bit 7
BAKEY3_KEY8:        equ    8                                         ; Backdoor Access Key bits, bit 8
BAKEY3_KEY9:        equ    9                                         ; Backdoor Access Key bits, bit 9
BAKEY3_KEY10:       equ    10                                        ; Backdoor Access Key bits, bit 10
BAKEY3_KEY11:       equ    11                                        ; Backdoor Access Key bits, bit 11
BAKEY3_KEY12:       equ    12                                        ; Backdoor Access Key bits, bit 12
BAKEY3_KEY13:       equ    13                                        ; Backdoor Access Key bits, bit 13
BAKEY3_KEY14:       equ    14                                        ; Backdoor Access Key bits, bit 14
BAKEY3_KEY15:       equ    15                                        ; Backdoor Access Key bits, bit 15
; bit position masks
mBAKEY3_KEY0:       equ    %00000001
mBAKEY3_KEY1:       equ    %00000010
mBAKEY3_KEY2:       equ    %00000100
mBAKEY3_KEY3:       equ    %00001000
mBAKEY3_KEY4:       equ    %00010000
mBAKEY3_KEY5:       equ    %00100000
mBAKEY3_KEY6:       equ    %01000000
mBAKEY3_KEY7:       equ    %10000000
mBAKEY3_KEY8:       equ    %100000000
mBAKEY3_KEY9:       equ    %1000000000
mBAKEY3_KEY10:      equ    %10000000000
mBAKEY3_KEY11:      equ    %100000000000
mBAKEY3_KEY12:      equ    %1000000000000
mBAKEY3_KEY13:      equ    %10000000000000
mBAKEY3_KEY14:      equ    %100000000000000
mBAKEY3_KEY15:      equ    %1000000000000000


;*** NVFPROT1 - Non volatile Block 1 Flash Protection Register; 0x0000FF0C ***
NVFPROT1:           equ    $0000FF0C                                ;*** NVFPROT1 - Non volatile Block 1 Flash Protection Register; 0x0000FF0C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NVFPROT1_FPLS0:     equ    0                                         ; Flash Protection Lower Address size 0
NVFPROT1_FPLS1:     equ    1                                         ; Flash Protection Lower Address size 1
NVFPROT1_FPLDIS:    equ    2                                         ; Flash Protection Lower address range disable
NVFPROT1_FPHS0:     equ    3                                         ; Flash Protection Higher address size 0
NVFPROT1_FPHS1:     equ    4                                         ; Flash Protection Higher address size 1
NVFPROT1_FPHDIS:    equ    5                                         ; Flash Protection Higher address range disable
NVFPROT1_NV6:       equ    6                                         ; Non Volatile Flag Bit
NVFPROT1_FPOPEN:    equ    7                                         ; Opens the flash block or subsections of it for program or erase
; bit position masks
mNVFPROT1_FPLS0:    equ    %00000001
mNVFPROT1_FPLS1:    equ    %00000010
mNVFPROT1_FPLDIS:   equ    %00000100
mNVFPROT1_FPHS0:    equ    %00001000
mNVFPROT1_FPHS1:    equ    %00010000
mNVFPROT1_FPHDIS:   equ    %00100000
mNVFPROT1_NV6:      equ    %01000000
mNVFPROT1_FPOPEN:   equ    %10000000


;*** NVFPROT0 - Non volatile Block 0 Flash Protection Register; 0x0000FF0D ***
NVFPROT0:           equ    $0000FF0D                                ;*** NVFPROT0 - Non volatile Block 0 Flash Protection Register; 0x0000FF0D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NVFPROT0_FPLS0:     equ    0                                         ; Flash Protection Lower Address size 0
NVFPROT0_FPLS1:     equ    1                                         ; Flash Protection Lower Address size 1
NVFPROT0_FPLDIS:    equ    2                                         ; Flash Protection Lower address range disable
NVFPROT0_FPHS0:     equ    3                                         ; Flash Protection Higher address size 0
NVFPROT0_FPHS1:     equ    4                                         ; Flash Protection Higher address size 1
NVFPROT0_FPHDIS:    equ    5                                         ; Flash Protection Higher address range disable
NVFPROT0_NV6:       equ    6                                         ; Non Volatile Flag Bit
NVFPROT0_FPOPEN:    equ    7                                         ; Opens the flash block or subsections of it for program or erase
; bit position masks
mNVFPROT0_FPLS0:    equ    %00000001
mNVFPROT0_FPLS1:    equ    %00000010
mNVFPROT0_FPLDIS:   equ    %00000100
mNVFPROT0_FPHS0:    equ    %00001000
mNVFPROT0_FPHS1:    equ    %00010000
mNVFPROT0_FPHDIS:   equ    %00100000
mNVFPROT0_NV6:      equ    %01000000
mNVFPROT0_FPOPEN:   equ    %10000000


;*** NVFSEC - Non volatile Flash Security Register; 0x0000FF0F ***
NVFSEC:             equ    $0000FF0F                                ;*** NVFSEC - Non volatile Flash Security Register; 0x0000FF0F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NVFSEC_SEC0:        equ    0                                         ; Memory security bit 0
NVFSEC_SEC1:        equ    1                                         ; Memory security bit 1
NVFSEC_NV2:         equ    2                                         ; Non Volatile flag bit 2
NVFSEC_NV3:         equ    3                                         ; Non Volatile flag bit 3
NVFSEC_NV4:         equ    4                                         ; Non Volatile flag bit 4
NVFSEC_NV5:         equ    5                                         ; Non Volatile flag bit 5
NVFSEC_NV6:         equ    6                                         ; Non Volatile flag bit 6
NVFSEC_KEYEN:       equ    7                                         ; Backdoor Key Security Enable
; bit position masks
mNVFSEC_SEC0:       equ    %00000001
mNVFSEC_SEC1:       equ    %00000010
mNVFSEC_NV2:        equ    %00000100
mNVFSEC_NV3:        equ    %00001000
mNVFSEC_NV4:        equ    %00010000
mNVFSEC_NV5:        equ    %00100000
mNVFSEC_NV6:        equ    %01000000
mNVFSEC_KEYEN:      equ    %10000000



;***********************************************
;**   D E P R E C I A T E D   S Y M B O L S   **
;***********************************************
        IFNDEF  __GENERATE_APPLICATION__                            ; not supported for absolute assembler
                    XREF    This_symb_has_been_depreciated
        ENDIF
; ---------------------------------------------------------------------------
; The following symbols were removed, because they were invalid or irrelevant
; ---------------------------------------------------------------------------

; EOF
