; Based on CPU DB MC9S12HY64_100, version 3.00.006 (RegistersPrg V2.31)

; ###################################################################
;     Filename  : mc9s12hy32.inc
;     Processor : MC9S12HY32CLL
;     FileFormat: V2.31
;     DataSheet : MC9S12HY64RMV1 Rev. 1.00 07/2009
;     Compiler  : CodeWarrior compiler
;     Date/Time : 14.4.2010, 13:39
;     Abstract  :
;         This header implements the mapping of I/O devices.
;
;     Copyright : 1997 - 2010 Freescale Semiconductor, Inc. All Rights Reserved.
;     
;     http      : www.freescale.com
;     mail      : support@freescale.com
;
;     CPU Registers Revisions:
;      - 1.7.2009, V3.00.0:
;              - Added PORTAB. REASON: Bug-fix (#7339 in Issue Manager).
;      - 14.4.2010, V3.00.1:
;              - Removed NVDFPROT[DPS4] bit to match definition with DFPROT register.
;
;     File-Format-Revisions:
;      - 17.3.2009, V2.27 :
;               - Merged bit-group is not generated, if the name matches with another bit name in the register
;      - 6.4.2009, V2.28 :
;               - Fixed generation of merged bits for bit-groups with a digit at the end, if group-name is defined in CPUDB
;      - 3.8.2009, V2.29 :
;               - If there is just one bits group matching register name, single bits are not generated
;      - 10.9.2009, V2.30 :
;               - Fixed generation of registers arrays.
;      - 15.10.2009, V2.31 :
;               - Changes have not affected this file (because they are related to another family)
;
;     Not all general-purpose I/O pins are available on all packages or on all mask sets of a specific
;     derivative device. To avoid extra current drain from floating input pins, the users reset
;     initialization routine in the application program must either enable on-chip pull-up devices
;     or change the direction of unconnected pins to outputs so the pins do not float.
; ###################################################################

;*** Memory Map and Interrupt Vectors
;******************************************
RAMStart:           equ   $00003800
RAMEnd:             equ   $00003FFF
DFLASHStart:        equ   $00000400
DFLASHEnd:          equ   $000013FF
ROM_C000Start:      equ   $0000C000
ROM_C000End:        equ   $0000FEFF
PAGE_0EStart:       equ   $00038000
PAGE_0EEnd:         equ   $0003BFFF
;
Vsi:                equ   $0000FF80
VReserved62:        equ   $0000FF82
Vatdcompare:        equ   $0000FF84
Vhti:               equ   $0000FF86
Vapi:               equ   $0000FF88
Vlvi:               equ   $0000FF8A
Vpwmesdn:           equ   $0000FF8C
Vportt:             equ   $0000FF8E
VReserved55:        equ   $0000FF90
VReserved54:        equ   $0000FF92
VReserved53:        equ   $0000FF94
Vmctimovf:          equ   $0000FF96
VReserved51:        equ   $0000FF98
Vtim1paie:          equ   $0000FF9A
Vtim1paaovf:        equ   $0000FF9C
Vtim1ovf:           equ   $0000FF9E
Vtim1ch7:           equ   $0000FFA0
Vtim1ch6:           equ   $0000FFA2
Vtim1ch5:           equ   $0000FFA4
Vtim1ch4:           equ   $0000FFA6
Vtim1ch3:           equ   $0000FFA8
Vtim1ch2:           equ   $0000FFAA
Vtim1ch1:           equ   $0000FFAC
Vtim1ch0:           equ   $0000FFAE
Vcantx:             equ   $0000FFB0
Vcanrx:             equ   $0000FFB2
Vcanerr:            equ   $0000FFB4
Vcanwkup:           equ   $0000FFB6
Vflash:             equ   $0000FFB8
Vflashfd:           equ   $0000FFBA
VReserved33:        equ   $0000FFBC
VReserved32:        equ   $0000FFBE
Viic:               equ   $0000FFC0
VReserved30:        equ   $0000FFC2
VReserved29:        equ   $0000FFC4
Vcpmuplllck:        equ   $0000FFC6
Vcpmuocsns:         equ   $0000FFC8
Vports:             equ   $0000FFCA
Vportr:             equ   $0000FFCC
Vportad:            equ   $0000FFCE
VReserved23:        equ   $0000FFD0
Vatd:               equ   $0000FFD2
VReserved21:        equ   $0000FFD4
Vsci:               equ   $0000FFD6
Vspi:               equ   $0000FFD8
Vtim0paie:          equ   $0000FFDA
Vtim0paaovf:        equ   $0000FFDC
Vtim0ovf:           equ   $0000FFDE
Vtim0ch7:           equ   $0000FFE0
Vtim0ch6:           equ   $0000FFE2
Vtim0ch5:           equ   $0000FFE4
Vtim0ch4:           equ   $0000FFE6
Vtim0ch3:           equ   $0000FFE8
Vtim0ch2:           equ   $0000FFEA
Vtim0ch1:           equ   $0000FFEC
Vtim0ch0:           equ   $0000FFEE
Vrti:               equ   $0000FFF0
Virq:               equ   $0000FFF2
Vxirq:              equ   $0000FFF4
Vswi:               equ   $0000FFF6
Vtrap:              equ   $0000FFF8
Vcop:               equ   $0000FFFA
Vclkmon:            equ   $0000FFFC
Vreset:             equ   $0000FFFE
;


;*** PORTAB - Port AB Data Register; 0x00000000 ***
PORTAB:             equ    $00000000                                ;*** PORTAB - Port AB Data Register; 0x00000000 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PORTAB_PB0:         equ    0                                         ; Port B Bit 0
PORTAB_PB1:         equ    1                                         ; Port B Bit 1
PORTAB_PB2:         equ    2                                         ; Port B Bit 2
PORTAB_PB3:         equ    3                                         ; Port B Bit 3
PORTAB_PB4:         equ    4                                         ; Port B Bit 4
PORTAB_PB5:         equ    5                                         ; Port B Bit 5
PORTAB_PB6:         equ    6                                         ; Port B Bit 6
PORTAB_PB7:         equ    7                                         ; Port B Bit 7
PORTAB_PA0:         equ    8                                         ; Port A Bit 0
PORTAB_PA1:         equ    9                                         ; Port A Bit 1
PORTAB_PA2:         equ    10                                        ; Port A Bit 2
PORTAB_PA3:         equ    11                                        ; Port A Bit 3
PORTAB_PA4:         equ    12                                        ; Port A Bit 4
PORTAB_PA5:         equ    13                                        ; Port A Bit 5
PORTAB_PA6:         equ    14                                        ; Port A Bit 6
PORTAB_PA7:         equ    15                                        ; Port A Bit 7
; bit position masks
mPORTAB_PB0:        equ    %00000001
mPORTAB_PB1:        equ    %00000010
mPORTAB_PB2:        equ    %00000100
mPORTAB_PB3:        equ    %00001000
mPORTAB_PB4:        equ    %00010000
mPORTAB_PB5:        equ    %00100000
mPORTAB_PB6:        equ    %01000000
mPORTAB_PB7:        equ    %10000000
mPORTAB_PA0:        equ    %100000000
mPORTAB_PA1:        equ    %1000000000
mPORTAB_PA2:        equ    %10000000000
mPORTAB_PA3:        equ    %100000000000
mPORTAB_PA4:        equ    %1000000000000
mPORTAB_PA5:        equ    %10000000000000
mPORTAB_PA6:        equ    %100000000000000
mPORTAB_PA7:        equ    %1000000000000000


;*** PORTA - Port A Data Register; 0x00000000 ***
PORTA:              equ    $00000000                                ;*** PORTA - Port A Data Register; 0x00000000 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PORTA_PA0:          equ    0                                         ; Port A Bit 0
PORTA_PA1:          equ    1                                         ; Port A Bit 1
PORTA_PA2:          equ    2                                         ; Port A Bit 2
PORTA_PA3:          equ    3                                         ; Port A Bit 3
PORTA_PA4:          equ    4                                         ; Port A Bit 4
PORTA_PA5:          equ    5                                         ; Port A Bit 5
PORTA_PA6:          equ    6                                         ; Port A Bit 6
PORTA_PA7:          equ    7                                         ; Port A Bit 7
; bit position masks
mPORTA_PA0:         equ    %00000001
mPORTA_PA1:         equ    %00000010
mPORTA_PA2:         equ    %00000100
mPORTA_PA3:         equ    %00001000
mPORTA_PA4:         equ    %00010000
mPORTA_PA5:         equ    %00100000
mPORTA_PA6:         equ    %01000000
mPORTA_PA7:         equ    %10000000


;*** PORTB - Port B Data Register; 0x00000001 ***
PORTB:              equ    $00000001                                ;*** PORTB - Port B Data Register; 0x00000001 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PORTB_PB0:          equ    0                                         ; Port B Bit 0
PORTB_PB1:          equ    1                                         ; Port B Bit 1
PORTB_PB2:          equ    2                                         ; Port B Bit 2
PORTB_PB3:          equ    3                                         ; Port B Bit 3
PORTB_PB4:          equ    4                                         ; Port B Bit 4
PORTB_PB5:          equ    5                                         ; Port B Bit 5
PORTB_PB6:          equ    6                                         ; Port B Bit 6
PORTB_PB7:          equ    7                                         ; Port B Bit 7
; bit position masks
mPORTB_PB0:         equ    %00000001
mPORTB_PB1:         equ    %00000010
mPORTB_PB2:         equ    %00000100
mPORTB_PB3:         equ    %00001000
mPORTB_PB4:         equ    %00010000
mPORTB_PB5:         equ    %00100000
mPORTB_PB6:         equ    %01000000
mPORTB_PB7:         equ    %10000000


;*** DDRAB - Port AB Data Direction Register; 0x00000002 ***
DDRAB:              equ    $00000002                                ;*** DDRAB - Port AB Data Direction Register; 0x00000002 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRAB_DDRB0:        equ    0                                         ; Data Direction Port B Bit 0
DDRAB_DDRB1:        equ    1                                         ; Data Direction Port B Bit 1
DDRAB_DDRB2:        equ    2                                         ; Data Direction Port B Bit 2
DDRAB_DDRB3:        equ    3                                         ; Data Direction Port B Bit 3
DDRAB_DDRB4:        equ    4                                         ; Data Direction Port B Bit 4
DDRAB_DDRB5:        equ    5                                         ; Data Direction Port B Bit 5
DDRAB_DDRB6:        equ    6                                         ; Data Direction Port B Bit 6
DDRAB_DDRB7:        equ    7                                         ; Data Direction Port B Bit 7
DDRAB_DDRA0:        equ    8                                         ; Data Direction Port A Bit 0
DDRAB_DDRA1:        equ    9                                         ; Data Direction Port A Bit 1
DDRAB_DDRA2:        equ    10                                        ; Data Direction Port A Bit 2
DDRAB_DDRA3:        equ    11                                        ; Data Direction Port A Bit 3
DDRAB_DDRA4:        equ    12                                        ; Data Direction Port A Bit 4
DDRAB_DDRA5:        equ    13                                        ; Data Direction Port A Bit 5
DDRAB_DDRA6:        equ    14                                        ; Data Direction Port A Bit 6
DDRAB_DDRA7:        equ    15                                        ; Data Direction Port A Bit 7
; bit position masks
mDDRAB_DDRB0:       equ    %00000001
mDDRAB_DDRB1:       equ    %00000010
mDDRAB_DDRB2:       equ    %00000100
mDDRAB_DDRB3:       equ    %00001000
mDDRAB_DDRB4:       equ    %00010000
mDDRAB_DDRB5:       equ    %00100000
mDDRAB_DDRB6:       equ    %01000000
mDDRAB_DDRB7:       equ    %10000000
mDDRAB_DDRA0:       equ    %100000000
mDDRAB_DDRA1:       equ    %1000000000
mDDRAB_DDRA2:       equ    %10000000000
mDDRAB_DDRA3:       equ    %100000000000
mDDRAB_DDRA4:       equ    %1000000000000
mDDRAB_DDRA5:       equ    %10000000000000
mDDRAB_DDRA6:       equ    %100000000000000
mDDRAB_DDRA7:       equ    %1000000000000000


;*** DDRA - Port A Data Direction Register; 0x00000002 ***
DDRA:               equ    $00000002                                ;*** DDRA - Port A Data Direction Register; 0x00000002 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRA_DDRA0:         equ    0                                         ; Data Direction Port A Bit 0
DDRA_DDRA1:         equ    1                                         ; Data Direction Port A Bit 1
DDRA_DDRA2:         equ    2                                         ; Data Direction Port A Bit 2
DDRA_DDRA3:         equ    3                                         ; Data Direction Port A Bit 3
DDRA_DDRA4:         equ    4                                         ; Data Direction Port A Bit 4
DDRA_DDRA5:         equ    5                                         ; Data Direction Port A Bit 5
DDRA_DDRA6:         equ    6                                         ; Data Direction Port A Bit 6
DDRA_DDRA7:         equ    7                                         ; Data Direction Port A Bit 7
; bit position masks
mDDRA_DDRA0:        equ    %00000001
mDDRA_DDRA1:        equ    %00000010
mDDRA_DDRA2:        equ    %00000100
mDDRA_DDRA3:        equ    %00001000
mDDRA_DDRA4:        equ    %00010000
mDDRA_DDRA5:        equ    %00100000
mDDRA_DDRA6:        equ    %01000000
mDDRA_DDRA7:        equ    %10000000


;*** DDRB - Port B Data Direction Register; 0x00000003 ***
DDRB:               equ    $00000003                                ;*** DDRB - Port B Data Direction Register; 0x00000003 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRB_DDRB0:         equ    0                                         ; Data Direction Port B Bit 0
DDRB_DDRB1:         equ    1                                         ; Data Direction Port B Bit 1
DDRB_DDRB2:         equ    2                                         ; Data Direction Port B Bit 2
DDRB_DDRB3:         equ    3                                         ; Data Direction Port B Bit 3
DDRB_DDRB4:         equ    4                                         ; Data Direction Port B Bit 4
DDRB_DDRB5:         equ    5                                         ; Data Direction Port B Bit 5
DDRB_DDRB6:         equ    6                                         ; Data Direction Port B Bit 6
DDRB_DDRB7:         equ    7                                         ; Data Direction Port B Bit 7
; bit position masks
mDDRB_DDRB0:        equ    %00000001
mDDRB_DDRB1:        equ    %00000010
mDDRB_DDRB2:        equ    %00000100
mDDRB_DDRB3:        equ    %00001000
mDDRB_DDRB4:        equ    %00010000
mDDRB_DDRB5:        equ    %00100000
mDDRB_DDRB6:        equ    %01000000
mDDRB_DDRB7:        equ    %10000000


;*** MODE - Mode Register; 0x0000000B ***
MODE:               equ    $0000000B                                ;*** MODE - Mode Register; 0x0000000B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MODE_MODC:          equ    7                                         ; Mode Select Bit
; bit position masks
mMODE_MODC:         equ    %10000000


;*** PUCR - Pull-Up Control Register; 0x0000000C ***
PUCR:               equ    $0000000C                                ;*** PUCR - Pull-Up Control Register; 0x0000000C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PUCR_PUPAE:         equ    0                                         ; Pull-up Port A Enable
PUCR_PUPBE:         equ    1                                         ; Pull-up Port B Enable
PUCR_BKPUE:         equ    6                                         ; BKGD and VREGEN Pin Pull-up Enable
; bit position masks
mPUCR_PUPAE:        equ    %00000001
mPUCR_PUPBE:        equ    %00000010
mPUCR_BKPUE:        equ    %01000000


;*** RDRIV - Reduced Drive Register; 0x0000000D ***
RDRIV:              equ    $0000000D                                ;*** RDRIV - Reduced Drive Register; 0x0000000D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RDRIV_RDPA:         equ    0                                         ; Reduced Drive of Port A
RDRIV_RDPB:         equ    1                                         ; Reduced Drive of Port B
; bit position masks
mRDRIV_RDPA:        equ    %00000001
mRDRIV_RDPB:        equ    %00000010


;*** DIRECT - Direct Page Register; 0x00000011 ***
DIRECT:             equ    $00000011                                ;*** DIRECT - Direct Page Register; 0x00000011 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DIRECT_DP8:         equ    0                                         ; Direct Page Index Bit 8
DIRECT_DP9:         equ    1                                         ; Direct Page Index Bit 9
DIRECT_DP10:        equ    2                                         ; Direct Page Index Bit 10
DIRECT_DP11:        equ    3                                         ; Direct Page Index Bit 11
DIRECT_DP12:        equ    4                                         ; Direct Page Index Bit 12
DIRECT_DP13:        equ    5                                         ; Direct Page Index Bit 13
DIRECT_DP14:        equ    6                                         ; Direct Page Index Bit 14
DIRECT_DP15:        equ    7                                         ; Direct Page Index Bit 15
; bit position masks
mDIRECT_DP8:        equ    %00000001
mDIRECT_DP9:        equ    %00000010
mDIRECT_DP10:       equ    %00000100
mDIRECT_DP11:       equ    %00001000
mDIRECT_DP12:       equ    %00010000
mDIRECT_DP13:       equ    %00100000
mDIRECT_DP14:       equ    %01000000
mDIRECT_DP15:       equ    %10000000


;*** PPAGE - Program Page Index Register; 0x00000015 ***
PPAGE:              equ    $00000015                                ;*** PPAGE - Program Page Index Register; 0x00000015 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PPAGE_PIX0:         equ    0                                         ; Program Page Index Bit 0
PPAGE_PIX1:         equ    1                                         ; Program Page Index Bit 1
PPAGE_PIX2:         equ    2                                         ; Program Page Index Bit 2
PPAGE_PIX3:         equ    3                                         ; Program Page Index Bit 3
; bit position masks
mPPAGE_PIX0:        equ    %00000001
mPPAGE_PIX1:        equ    %00000010
mPPAGE_PIX2:        equ    %00000100
mPPAGE_PIX3:        equ    %00001000


;*** PARTID - Part ID Register; 0x0000001A ***
PARTID:             equ    $0000001A                                ;*** PARTID - Part ID Register; 0x0000001A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PARTID_ID0:         equ    0                                         ; Part ID Register Bit 0
PARTID_ID1:         equ    1                                         ; Part ID Register Bit 1
PARTID_ID2:         equ    2                                         ; Part ID Register Bit 2
PARTID_ID3:         equ    3                                         ; Part ID Register Bit 3
PARTID_ID4:         equ    4                                         ; Part ID Register Bit 4
PARTID_ID5:         equ    5                                         ; Part ID Register Bit 5
PARTID_ID6:         equ    6                                         ; Part ID Register Bit 6
PARTID_ID7:         equ    7                                         ; Part ID Register Bit 7
PARTID_ID8:         equ    8                                         ; Part ID Register Bit 8
PARTID_ID9:         equ    9                                         ; Part ID Register Bit 9
PARTID_ID10:        equ    10                                        ; Part ID Register Bit 10
PARTID_ID11:        equ    11                                        ; Part ID Register Bit 11
PARTID_ID12:        equ    12                                        ; Part ID Register Bit 12
PARTID_ID13:        equ    13                                        ; Part ID Register Bit 13
PARTID_ID14:        equ    14                                        ; Part ID Register Bit 14
PARTID_ID15:        equ    15                                        ; Part ID Register Bit 15
; bit position masks
mPARTID_ID0:        equ    %00000001
mPARTID_ID1:        equ    %00000010
mPARTID_ID2:        equ    %00000100
mPARTID_ID3:        equ    %00001000
mPARTID_ID4:        equ    %00010000
mPARTID_ID5:        equ    %00100000
mPARTID_ID6:        equ    %01000000
mPARTID_ID7:        equ    %10000000
mPARTID_ID8:        equ    %100000000
mPARTID_ID9:        equ    %1000000000
mPARTID_ID10:       equ    %10000000000
mPARTID_ID11:       equ    %100000000000
mPARTID_ID12:       equ    %1000000000000
mPARTID_ID13:       equ    %10000000000000
mPARTID_ID14:       equ    %100000000000000
mPARTID_ID15:       equ    %1000000000000000


;*** PARTIDH - Part ID Register High; 0x0000001A ***
PARTIDH:            equ    $0000001A                                ;*** PARTIDH - Part ID Register High; 0x0000001A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PARTIDH_ID8:        equ    0                                         ; Part ID Register Bit 8
PARTIDH_ID9:        equ    1                                         ; Part ID Register Bit 9
PARTIDH_ID10:       equ    2                                         ; Part ID Register Bit 10
PARTIDH_ID11:       equ    3                                         ; Part ID Register Bit 11
PARTIDH_ID12:       equ    4                                         ; Part ID Register Bit 12
PARTIDH_ID13:       equ    5                                         ; Part ID Register Bit 13
PARTIDH_ID14:       equ    6                                         ; Part ID Register Bit 14
PARTIDH_ID15:       equ    7                                         ; Part ID Register Bit 15
; bit position masks
mPARTIDH_ID8:       equ    %00000001
mPARTIDH_ID9:       equ    %00000010
mPARTIDH_ID10:      equ    %00000100
mPARTIDH_ID11:      equ    %00001000
mPARTIDH_ID12:      equ    %00010000
mPARTIDH_ID13:      equ    %00100000
mPARTIDH_ID14:      equ    %01000000
mPARTIDH_ID15:      equ    %10000000


;*** PARTIDL - Part ID Register Low; 0x0000001B ***
PARTIDL:            equ    $0000001B                                ;*** PARTIDL - Part ID Register Low; 0x0000001B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PARTIDL_ID0:        equ    0                                         ; Part ID Register Bit 0
PARTIDL_ID1:        equ    1                                         ; Part ID Register Bit 1
PARTIDL_ID2:        equ    2                                         ; Part ID Register Bit 2
PARTIDL_ID3:        equ    3                                         ; Part ID Register Bit 3
PARTIDL_ID4:        equ    4                                         ; Part ID Register Bit 4
PARTIDL_ID5:        equ    5                                         ; Part ID Register Bit 5
PARTIDL_ID6:        equ    6                                         ; Part ID Register Bit 6
PARTIDL_ID7:        equ    7                                         ; Part ID Register Bit 7
; bit position masks
mPARTIDL_ID0:       equ    %00000001
mPARTIDL_ID1:       equ    %00000010
mPARTIDL_ID2:       equ    %00000100
mPARTIDL_ID3:       equ    %00001000
mPARTIDL_ID4:       equ    %00010000
mPARTIDL_ID5:       equ    %00100000
mPARTIDL_ID6:       equ    %01000000
mPARTIDL_ID7:       equ    %10000000


;*** ECLKCTL - ECLK Control Register; 0x0000001C ***
ECLKCTL:            equ    $0000001C                                ;*** ECLKCTL - ECLK Control Register; 0x0000001C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ECLKCTL_EDIV0:      equ    0                                         ; Free-running ECLK Divider, bit 0
ECLKCTL_EDIV1:      equ    1                                         ; Free-running ECLK Divider, bit 1
ECLKCTL_EDIV2:      equ    2                                         ; Free-running ECLK Divider, bit 2
ECLKCTL_EDIV3:      equ    3                                         ; Free-running ECLK Divider, bit 3
ECLKCTL_EDIV4:      equ    4                                         ; Free-running ECLK Divider, bit 4
ECLKCTL_DIV16:      equ    5                                         ; Free-running ECLK predivider
ECLKCTL_NECLK:      equ    7                                         ; No ECLK
; bit position masks
mECLKCTL_EDIV0:     equ    %00000001
mECLKCTL_EDIV1:     equ    %00000010
mECLKCTL_EDIV2:     equ    %00000100
mECLKCTL_EDIV3:     equ    %00001000
mECLKCTL_EDIV4:     equ    %00010000
mECLKCTL_DIV16:     equ    %00100000
mECLKCTL_NECLK:     equ    %10000000


;*** IRQCR - Interrupt Control Register; 0x0000001E ***
IRQCR:              equ    $0000001E                                ;*** IRQCR - Interrupt Control Register; 0x0000001E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
IRQCR_XIRQEN:       equ    5                                         ; XIRQ Enable
IRQCR_IRQEN:        equ    6                                         ; External IRQ Enable
IRQCR_IRQE:         equ    7                                         ; IRQ Select Edge Sensitive Only
; bit position masks
mIRQCR_XIRQEN:      equ    %00100000
mIRQCR_IRQEN:       equ    %01000000
mIRQCR_IRQE:        equ    %10000000


;*** DBGC1 - Debug Control Register 1; 0x00000020 ***
DBGC1:              equ    $00000020                                ;*** DBGC1 - Debug Control Register 1; 0x00000020 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGC1_COMRV0:       equ    0                                         ; Comparator Register Visibility Bits, bit 0
DBGC1_COMRV1:       equ    1                                         ; Comparator Register Visibility Bits, bit 1
DBGC1_DBGBRK:       equ    3                                         ; S12XDBG Breakpoint Enable Bit 1
DBGC1_BDM:          equ    4                                         ; Background Debug Mode Enable
DBGC1_TRIG:         equ    6                                         ; Immediate Trigger Request Bit
DBGC1_ARM:          equ    7                                         ; Arm Bit
; bit position masks
mDBGC1_COMRV0:      equ    %00000001
mDBGC1_COMRV1:      equ    %00000010
mDBGC1_DBGBRK:      equ    %00001000
mDBGC1_BDM:         equ    %00010000
mDBGC1_TRIG:        equ    %01000000
mDBGC1_ARM:         equ    %10000000


;*** DBGSR - Debug Status Register; 0x00000021 ***
DBGSR:              equ    $00000021                                ;*** DBGSR - Debug Status Register; 0x00000021 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGSR_SSF0:         equ    0                                         ; State Sequencer Flag Bits
DBGSR_SSF1:         equ    1                                         ; State Sequencer Flag Bit 1
DBGSR_SSF2:         equ    2                                         ; State Sequencer Flag Bit 2
DBGSR_TBF:          equ    7                                         ; Trace Buffer Full
; bit position masks
mDBGSR_SSF0:        equ    %00000001
mDBGSR_SSF1:        equ    %00000010
mDBGSR_SSF2:        equ    %00000100
mDBGSR_TBF:         equ    %10000000


;*** DBGTCR - Debug Trace Control Register; 0x00000022 ***
DBGTCR:             equ    $00000022                                ;*** DBGTCR - Debug Trace Control Register; 0x00000022 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGTCR_TALIGN:      equ    0                                         ; Trigger Align Bit
DBGTCR_TRCMOD0:     equ    2                                         ; Trace Mode Bits, bit 0
DBGTCR_TRCMOD1:     equ    3                                         ; Trace Mode Bits, bit 1
DBGTCR_TSOURCE:     equ    6                                         ; Trace Source Control Bits
; bit position masks
mDBGTCR_TALIGN:     equ    %00000001
mDBGTCR_TRCMOD0:    equ    %00000100
mDBGTCR_TRCMOD1:    equ    %00001000
mDBGTCR_TSOURCE:    equ    %01000000


;*** DBGC2 - Debug Control Register 2; 0x00000023 ***
DBGC2:              equ    $00000023                                ;*** DBGC2 - Debug Control Register 2; 0x00000023 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGC2_ABCM0:        equ    0                                         ; A and B Comparator Match Control, bit 0
DBGC2_ABCM1:        equ    1                                         ; A and B Comparator Match Control, bit 1
; bit position masks
mDBGC2_ABCM0:       equ    %00000001
mDBGC2_ABCM1:       equ    %00000010


;*** DBGTB - Debug Trace Buffer Register; 0x00000024 ***
DBGTB:              equ    $00000024                                ;*** DBGTB - Debug Trace Buffer Register; 0x00000024 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGTB_BIT0:         equ    0                                         ; Trace Buffer Data Bits
DBGTB_BIT1:         equ    1                                         ; Trace Buffer Data Bit 1
DBGTB_BIT2:         equ    2                                         ; Trace Buffer Data Bit 2
DBGTB_BIT3:         equ    3                                         ; Trace Buffer Data Bit 3
DBGTB_BIT4:         equ    4                                         ; Trace Buffer Data Bit 4
DBGTB_BIT5:         equ    5                                         ; Trace Buffer Data Bit 5
DBGTB_BIT6:         equ    6                                         ; Trace Buffer Data Bit 6
DBGTB_BIT7:         equ    7                                         ; Trace Buffer Data Bit 7
DBGTB_BIT8:         equ    8                                         ; Trace Buffer Data Bit 8
DBGTB_BIT9:         equ    9                                         ; Trace Buffer Data Bit 9
DBGTB_BIT10:        equ    10                                        ; Trace Buffer Data Bit 10
DBGTB_BIT11:        equ    11                                        ; Trace Buffer Data Bit 11
DBGTB_BIT12:        equ    12                                        ; Trace Buffer Data Bit 12
DBGTB_BIT13:        equ    13                                        ; Trace Buffer Data Bit 13
DBGTB_BIT14:        equ    14                                        ; Trace Buffer Data Bit 14
DBGTB_BIT15:        equ    15                                        ; Trace Buffer Data Bit 15
; bit position masks
mDBGTB_BIT0:        equ    %00000001
mDBGTB_BIT1:        equ    %00000010
mDBGTB_BIT2:        equ    %00000100
mDBGTB_BIT3:        equ    %00001000
mDBGTB_BIT4:        equ    %00010000
mDBGTB_BIT5:        equ    %00100000
mDBGTB_BIT6:        equ    %01000000
mDBGTB_BIT7:        equ    %10000000
mDBGTB_BIT8:        equ    %100000000
mDBGTB_BIT9:        equ    %1000000000
mDBGTB_BIT10:       equ    %10000000000
mDBGTB_BIT11:       equ    %100000000000
mDBGTB_BIT12:       equ    %1000000000000
mDBGTB_BIT13:       equ    %10000000000000
mDBGTB_BIT14:       equ    %100000000000000
mDBGTB_BIT15:       equ    %1000000000000000


;*** DBGTBH - Debug Trace Buffer Register High; 0x00000024 ***
DBGTBH:             equ    $00000024                                ;*** DBGTBH - Debug Trace Buffer Register High; 0x00000024 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGTBH_BIT8:        equ    0                                         ; Trace Buffer Data Bits
DBGTBH_BIT9:        equ    1                                         ; Trace Buffer Data Bit 9
DBGTBH_BIT10:       equ    2                                         ; Trace Buffer Data Bit 10
DBGTBH_BIT11:       equ    3                                         ; Trace Buffer Data Bit 11
DBGTBH_BIT12:       equ    4                                         ; Trace Buffer Data Bit 12
DBGTBH_BIT13:       equ    5                                         ; Trace Buffer Data Bit 13
DBGTBH_BIT14:       equ    6                                         ; Trace Buffer Data Bit 14
DBGTBH_BIT15:       equ    7                                         ; Trace Buffer Data Bit 15
; bit position masks
mDBGTBH_BIT8:       equ    %00000001
mDBGTBH_BIT9:       equ    %00000010
mDBGTBH_BIT10:      equ    %00000100
mDBGTBH_BIT11:      equ    %00001000
mDBGTBH_BIT12:      equ    %00010000
mDBGTBH_BIT13:      equ    %00100000
mDBGTBH_BIT14:      equ    %01000000
mDBGTBH_BIT15:      equ    %10000000


;*** DBGTBL - Debug Trace Buffer Register Low; 0x00000025 ***
DBGTBL:             equ    $00000025                                ;*** DBGTBL - Debug Trace Buffer Register Low; 0x00000025 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGTBL_BIT0:        equ    0                                         ; Trace Buffer Data Bits
DBGTBL_BIT1:        equ    1                                         ; Trace Buffer Data Bit 1
DBGTBL_BIT2:        equ    2                                         ; Trace Buffer Data Bit 2
DBGTBL_BIT3:        equ    3                                         ; Trace Buffer Data Bit 3
DBGTBL_BIT4:        equ    4                                         ; Trace Buffer Data Bit 4
DBGTBL_BIT5:        equ    5                                         ; Trace Buffer Data Bit 5
DBGTBL_BIT6:        equ    6                                         ; Trace Buffer Data Bit 6
DBGTBL_BIT7:        equ    7                                         ; Trace Buffer Data Bit 7
; bit position masks
mDBGTBL_BIT0:       equ    %00000001
mDBGTBL_BIT1:       equ    %00000010
mDBGTBL_BIT2:       equ    %00000100
mDBGTBL_BIT3:       equ    %00001000
mDBGTBL_BIT4:       equ    %00010000
mDBGTBL_BIT5:       equ    %00100000
mDBGTBL_BIT6:       equ    %01000000
mDBGTBL_BIT7:       equ    %10000000


;*** DBGCNT - Debug Count Register; 0x00000026 ***
DBGCNT:             equ    $00000026                                ;*** DBGCNT - Debug Count Register; 0x00000026 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGCNT_CNT0:        equ    0                                         ; Count Value, bit 0
DBGCNT_CNT1:        equ    1                                         ; Count Value, bit 1
DBGCNT_CNT2:        equ    2                                         ; Count Value, bit 2
DBGCNT_CNT3:        equ    3                                         ; Count Value, bit 3
DBGCNT_CNT4:        equ    4                                         ; Count Value, bit 4
DBGCNT_CNT5:        equ    5                                         ; Count Value, bit 5
DBGCNT_TBF:         equ    7                                         ; Trace Buffer Full
; bit position masks
mDBGCNT_CNT0:       equ    %00000001
mDBGCNT_CNT1:       equ    %00000010
mDBGCNT_CNT2:       equ    %00000100
mDBGCNT_CNT3:       equ    %00001000
mDBGCNT_CNT4:       equ    %00010000
mDBGCNT_CNT5:       equ    %00100000
mDBGCNT_TBF:        equ    %10000000


;*** DBGSCRX - Debug State Control Register; 0x00000027 ***
DBGSCRX:            equ    $00000027                                ;*** DBGSCRX - Debug State Control Register; 0x00000027 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGSCRX_SC0:        equ    0                                         ; State X Sequencer Next State Selection Bit 0
DBGSCRX_SC1:        equ    1                                         ; State X Sequencer Next State Selection Bit 1
DBGSCRX_SC2:        equ    2                                         ; State X Sequencer Next State Selection Bit 2
DBGSCRX_SC3:        equ    3                                         ; State X Sequencer Next State Selection Bit 3
; bit position masks
mDBGSCRX_SC0:       equ    %00000001
mDBGSCRX_SC1:       equ    %00000010
mDBGSCRX_SC2:       equ    %00000100
mDBGSCRX_SC3:       equ    %00001000


;*** DBGMFR - Debug Match Flag Register; 0x00000027 ***
DBGMFR:             equ    $00000027                                ;*** DBGMFR - Debug Match Flag Register; 0x00000027 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGMFR_MC0:         equ    0                                         ; Debug Match Flag Bit 0
DBGMFR_MC1:         equ    1                                         ; Debug Match Flag Bit 1
DBGMFR_MC2:         equ    2                                         ; Debug Match Flag Bit 2
; bit position masks
mDBGMFR_MC0:        equ    %00000001
mDBGMFR_MC1:        equ    %00000010
mDBGMFR_MC2:        equ    %00000100


;*** DBGXCTL - Debug Comparator Control Register; 0x00000028 ***
DBGXCTL:            equ    $00000028                                ;*** DBGXCTL - Debug Comparator Control Register; 0x00000028 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGXCTL_COMPE:      equ    0                                         ; Determines if comparator is enabled
DBGXCTL_NDB:        equ    1                                         ; Not Data Bus(Comparators A and C), Size Comparator Value Bit(Comparators B and D)
DBGXCTL_RWE:        equ    2                                         ; Read/Write Enable Bit
DBGXCTL_RW:         equ    3                                         ; Read/Write Comparator Value Bit
DBGXCTL_BRK:        equ    4                                         ; Break
DBGXCTL_TAG:        equ    5                                         ; Tag Select
DBGXCTL_SZ:         equ    6                                         ; Size Comparator Value Bit
DBGXCTL_SZE:        equ    7                                         ; Size Comparator Enable Bit
; bit position masks
mDBGXCTL_COMPE:     equ    %00000001
mDBGXCTL_NDB:       equ    %00000010
mDBGXCTL_RWE:       equ    %00000100
mDBGXCTL_RW:        equ    %00001000
mDBGXCTL_BRK:       equ    %00010000
mDBGXCTL_TAG:       equ    %00100000
mDBGXCTL_SZ:        equ    %01000000
mDBGXCTL_SZE:       equ    %10000000


;*** DBGXAH - Debug Comparator Address High Register; 0x00000029 ***
DBGXAH:             equ    $00000029                                ;*** DBGXAH - Debug Comparator Address High Register; 0x00000029 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGXAH_BIT16:       equ    0                                         ; Comparator Address High Compare Bits
DBGXAH_BIT17:       equ    1                                         ; Comparator Address High Compare Bit 17
; bit position masks
mDBGXAH_BIT16:      equ    %00000001
mDBGXAH_BIT17:      equ    %00000010


;*** DBGXAM - Debug Comparator Address Mid Register; 0x0000002A ***
DBGXAM:             equ    $0000002A                                ;*** DBGXAM - Debug Comparator Address Mid Register; 0x0000002A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGXAM_BIT8:        equ    0                                         ; Comparator Address Mid Compare Bits
DBGXAM_BIT9:        equ    1                                         ; Comparator Address Mid Compare Bit 9
DBGXAM_BIT10:       equ    2                                         ; Comparator Address Mid Compare Bit 10
DBGXAM_BIT11:       equ    3                                         ; Comparator Address Mid Compare Bit 11
DBGXAM_BIT12:       equ    4                                         ; Comparator Address Mid Compare Bit 12
DBGXAM_BIT13:       equ    5                                         ; Comparator Address Mid Compare Bit 13
DBGXAM_BIT14:       equ    6                                         ; Comparator Address Mid Compare Bit 14
DBGXAM_BIT15:       equ    7                                         ; Comparator Address Mid Compare Bit 15
; bit position masks
mDBGXAM_BIT8:       equ    %00000001
mDBGXAM_BIT9:       equ    %00000010
mDBGXAM_BIT10:      equ    %00000100
mDBGXAM_BIT11:      equ    %00001000
mDBGXAM_BIT12:      equ    %00010000
mDBGXAM_BIT13:      equ    %00100000
mDBGXAM_BIT14:      equ    %01000000
mDBGXAM_BIT15:      equ    %10000000


;*** DBGXAL - Debug Comparator Address Low Register; 0x0000002B ***
DBGXAL:             equ    $0000002B                                ;*** DBGXAL - Debug Comparator Address Low Register; 0x0000002B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGXAL_BIT0:        equ    0                                         ; Comparator Address Low Compare Bits
DBGXAL_BIT1:        equ    1                                         ; Comparator Address Low Compare Bit 1
DBGXAL_BIT2:        equ    2                                         ; Comparator Address Low Compare Bit 2
DBGXAL_BIT3:        equ    3                                         ; Comparator Address Low Compare Bit 3
DBGXAL_BIT4:        equ    4                                         ; Comparator Address Low Compare Bit 4
DBGXAL_BIT5:        equ    5                                         ; Comparator Address Low Compare Bit 5
DBGXAL_BIT6:        equ    6                                         ; Comparator Address Low Compare Bit 6
DBGXAL_BIT7:        equ    7                                         ; Comparator Address Low Compare Bit 7
; bit position masks
mDBGXAL_BIT0:       equ    %00000001
mDBGXAL_BIT1:       equ    %00000010
mDBGXAL_BIT2:       equ    %00000100
mDBGXAL_BIT3:       equ    %00001000
mDBGXAL_BIT4:       equ    %00010000
mDBGXAL_BIT5:       equ    %00100000
mDBGXAL_BIT6:       equ    %01000000
mDBGXAL_BIT7:       equ    %10000000


;*** DBGADH - Debug Comparator Data High Register; 0x0000002C ***
DBGADH:             equ    $0000002C                                ;*** DBGADH - Debug Comparator Data High Register; 0x0000002C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGADH_BIT8:        equ    0                                         ; Comparator Data High Compare Bit 8
DBGADH_BIT9:        equ    1                                         ; Comparator Data High Compare Bit 9
DBGADH_BIT10:       equ    2                                         ; Comparator Data High Compare Bit 10
DBGADH_BIT11:       equ    3                                         ; Comparator Data High Compare Bit 11
DBGADH_BIT12:       equ    4                                         ; Comparator Data High Compare Bit 12
DBGADH_BIT13:       equ    5                                         ; Comparator Data High Compare Bit 13
DBGADH_BIT14:       equ    6                                         ; Comparator Data High Compare Bit 14
DBGADH_BIT15:       equ    7                                         ; Comparator Data High Compare Bit 15
; bit position masks
mDBGADH_BIT8:       equ    %00000001
mDBGADH_BIT9:       equ    %00000010
mDBGADH_BIT10:      equ    %00000100
mDBGADH_BIT11:      equ    %00001000
mDBGADH_BIT12:      equ    %00010000
mDBGADH_BIT13:      equ    %00100000
mDBGADH_BIT14:      equ    %01000000
mDBGADH_BIT15:      equ    %10000000


;*** DBGADL - Debug Comparator Data Low Register; 0x0000002D ***
DBGADL:             equ    $0000002D                                ;*** DBGADL - Debug Comparator Data Low Register; 0x0000002D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGADL_BIT0:        equ    0                                         ; Comparator Data Low Compare Bit 0
DBGADL_BIT1:        equ    1                                         ; Comparator Data Low Compare Bit 1
DBGADL_BIT2:        equ    2                                         ; Comparator Data Low Compare Bit 2
DBGADL_BIT3:        equ    3                                         ; Comparator Data Low Compare Bit 3
DBGADL_BIT4:        equ    4                                         ; Comparator Data Low Compare Bit 4
DBGADL_BIT5:        equ    5                                         ; Comparator Data Low Compare Bit 5
DBGADL_BIT6:        equ    6                                         ; Comparator Data Low Compare Bit 6
DBGADL_BIT7:        equ    7                                         ; Comparator Data Low Compare Bit 7
; bit position masks
mDBGADL_BIT0:       equ    %00000001
mDBGADL_BIT1:       equ    %00000010
mDBGADL_BIT2:       equ    %00000100
mDBGADL_BIT3:       equ    %00001000
mDBGADL_BIT4:       equ    %00010000
mDBGADL_BIT5:       equ    %00100000
mDBGADL_BIT6:       equ    %01000000
mDBGADL_BIT7:       equ    %10000000


;*** DBGADHM - Debug Comparator Data High Mask Register; 0x0000002E ***
DBGADHM:            equ    $0000002E                                ;*** DBGADHM - Debug Comparator Data High Mask Register; 0x0000002E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGADHM_BIT8:       equ    0                                         ; Comparator Data High Mask Bit 8
DBGADHM_BIT9:       equ    1                                         ; Comparator Data High Mask Bit 9
DBGADHM_BIT10:      equ    2                                         ; Comparator Data High Mask Bit 10
DBGADHM_BIT11:      equ    3                                         ; Comparator Data High Mask Bit 11
DBGADHM_BIT12:      equ    4                                         ; Comparator Data High Mask Bit 12
DBGADHM_BIT13:      equ    5                                         ; Comparator Data High Mask Bit 13
DBGADHM_BIT14:      equ    6                                         ; Comparator Data High Mask Bit 14
DBGADHM_BIT15:      equ    7                                         ; Comparator Data High Mask Bit 15
; bit position masks
mDBGADHM_BIT8:      equ    %00000001
mDBGADHM_BIT9:      equ    %00000010
mDBGADHM_BIT10:     equ    %00000100
mDBGADHM_BIT11:     equ    %00001000
mDBGADHM_BIT12:     equ    %00010000
mDBGADHM_BIT13:     equ    %00100000
mDBGADHM_BIT14:     equ    %01000000
mDBGADHM_BIT15:     equ    %10000000


;*** DBGADLM - Debug Comparator Data Low Mask Register; 0x0000002F ***
DBGADLM:            equ    $0000002F                                ;*** DBGADLM - Debug Comparator Data Low Mask Register; 0x0000002F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGADLM_BIT0:       equ    0                                         ; Comparator Data Low Mask Bit 0
DBGADLM_BIT1:       equ    1                                         ; Comparator Data Low Mask Bit 1
DBGADLM_BIT2:       equ    2                                         ; Comparator Data Low Mask Bit 2
DBGADLM_BIT3:       equ    3                                         ; Comparator Data Low Mask Bit 3
DBGADLM_BIT4:       equ    4                                         ; Comparator Data Low Mask Bit 4
DBGADLM_BIT5:       equ    5                                         ; Comparator Data Low Mask Bit 5
DBGADLM_BIT6:       equ    6                                         ; Comparator Data Low Mask Bit 6
DBGADLM_BIT7:       equ    7                                         ; Comparator Data Low Mask Bit 7
; bit position masks
mDBGADLM_BIT0:      equ    %00000001
mDBGADLM_BIT1:      equ    %00000010
mDBGADLM_BIT2:      equ    %00000100
mDBGADLM_BIT3:      equ    %00001000
mDBGADLM_BIT4:      equ    %00010000
mDBGADLM_BIT5:      equ    %00100000
mDBGADLM_BIT6:      equ    %01000000
mDBGADLM_BIT7:      equ    %10000000


;*** CPMUSYNR - S12CPMU Synthesizer Register; 0x00000034 ***
CPMUSYNR:           equ    $00000034                                ;*** CPMUSYNR - S12CPMU Synthesizer Register; 0x00000034 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CPMUSYNR_SYNDIV0:   equ    0                                         ; Multiplication factor of the IPLL bit 0
CPMUSYNR_SYNDIV1:   equ    1                                         ; Multiplication factor of the IPLL bit 1
CPMUSYNR_SYNDIV2:   equ    2                                         ; Multiplication factor of the IPLL bit 2
CPMUSYNR_SYNDIV3:   equ    3                                         ; Multiplication factor of the IPLL bit 3
CPMUSYNR_SYNDIV4:   equ    4                                         ; Multiplication factor of the IPLL bit 4
CPMUSYNR_SYNDIV5:   equ    5                                         ; Multiplication factor of the IPLL bit 5
CPMUSYNR_VCOFRQ0:   equ    6                                         ; VCO frequency range bit 0
CPMUSYNR_VCOFRQ1:   equ    7                                         ; VCO frequency range bit 1
; bit position masks
mCPMUSYNR_SYNDIV0:  equ    %00000001
mCPMUSYNR_SYNDIV1:  equ    %00000010
mCPMUSYNR_SYNDIV2:  equ    %00000100
mCPMUSYNR_SYNDIV3:  equ    %00001000
mCPMUSYNR_SYNDIV4:  equ    %00010000
mCPMUSYNR_SYNDIV5:  equ    %00100000
mCPMUSYNR_VCOFRQ0:  equ    %01000000
mCPMUSYNR_VCOFRQ1:  equ    %10000000


;*** CPMUREFDIV - S12CPMU Reference Divider Register; 0x00000035 ***
CPMUREFDIV:         equ    $00000035                                ;*** CPMUREFDIV - S12CPMU Reference Divider Register; 0x00000035 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CPMUREFDIV_REFDIV0: equ    0                                         ; Finer granularity for the IPLL multiplier steps bit 0
CPMUREFDIV_REFDIV1: equ    1                                         ; Finer granularity for the IPLL multiplier steps bit 1
CPMUREFDIV_REFDIV2: equ    2                                         ; Finer granularity for the IPLL multiplier steps bit 2
CPMUREFDIV_REFDIV3: equ    3                                         ; Finer granularity for the IPLL multiplier steps bit 3
CPMUREFDIV_REFFRQ0: equ    6                                         ; IPLL optimal stability and lock time configuration bit 0
CPMUREFDIV_REFFRQ1: equ    7                                         ; IPLL optimal stability and lock time configuration bit 1
; bit position masks
mCPMUREFDIV_REFDIV0: equ    %00000001
mCPMUREFDIV_REFDIV1: equ    %00000010
mCPMUREFDIV_REFDIV2: equ    %00000100
mCPMUREFDIV_REFDIV3: equ    %00001000
mCPMUREFDIV_REFFRQ0: equ    %01000000
mCPMUREFDIV_REFFRQ1: equ    %10000000


;*** CPMUPOSTDIV - S12CPMU Post Divider Register; 0x00000036 ***
CPMUPOSTDIV:        equ    $00000036                                ;*** CPMUPOSTDIV - S12CPMU Post Divider Register; 0x00000036 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CPMUPOSTDIV_POSTDIV0: equ    0                                       ; Frequency ratio between the VCOCLK and PLLCLK control bit 0
CPMUPOSTDIV_POSTDIV1: equ    1                                       ; Frequency ratio between the VCOCLK and PLLCLK control bit 1
CPMUPOSTDIV_POSTDIV2: equ    2                                       ; Frequency ratio between the VCOCLK and PLLCLK control bit 2
CPMUPOSTDIV_POSTDIV3: equ    3                                       ; Frequency ratio between the VCOCLK and PLLCLK control bit 3
CPMUPOSTDIV_POSTDIV4: equ    4                                       ; Frequency ratio between the VCOCLK and PLLCLK control bit 4
; bit position masks
mCPMUPOSTDIV_POSTDIV0: equ    %00000001
mCPMUPOSTDIV_POSTDIV1: equ    %00000010
mCPMUPOSTDIV_POSTDIV2: equ    %00000100
mCPMUPOSTDIV_POSTDIV3: equ    %00001000
mCPMUPOSTDIV_POSTDIV4: equ    %00010000


;*** CPMUFLG - S12CPMU Flags Register; 0x00000037 ***
CPMUFLG:            equ    $00000037                                ;*** CPMUFLG - S12CPMU Flags Register; 0x00000037 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CPMUFLG_UPOSC:      equ    0                                         ; Oscillator Status Bit
CPMUFLG_OSCIF:      equ    1                                         ; Oscillator Interrupt Flag
CPMUFLG_ILAF:       equ    2                                         ; Illegal Address Reset Flag
CPMUFLG_LOCK:       equ    3                                         ; Lock Status Bit
CPMUFLG_LOCKIF:     equ    4                                         ; IPLL Lock Interrupt Flag
CPMUFLG_LVRF:       equ    5                                         ; Low Voltage Reset Flag
CPMUFLG_PORF:       equ    6                                         ; Power on Reset Flag
CPMUFLG_RTIF:       equ    7                                         ; Real Time Interrupt Flag
; bit position masks
mCPMUFLG_UPOSC:     equ    %00000001
mCPMUFLG_OSCIF:     equ    %00000010
mCPMUFLG_ILAF:      equ    %00000100
mCPMUFLG_LOCK:      equ    %00001000
mCPMUFLG_LOCKIF:    equ    %00010000
mCPMUFLG_LVRF:      equ    %00100000
mCPMUFLG_PORF:      equ    %01000000
mCPMUFLG_RTIF:      equ    %10000000


;*** CPMUINT - S12CPMU Interrupt Enable Register; 0x00000038 ***
CPMUINT:            equ    $00000038                                ;*** CPMUINT - S12CPMU Interrupt Enable Register; 0x00000038 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CPMUINT_OSCIE:      equ    1                                         ; Oscillator Corrupt Interrupt Enable Bit
CPMUINT_LOCKIE:     equ    4                                         ; Lock Interrupt Enable Bit
CPMUINT_RTIE:       equ    7                                         ; Real Time Interrupt Enable Bit
; bit position masks
mCPMUINT_OSCIE:     equ    %00000010
mCPMUINT_LOCKIE:    equ    %00010000
mCPMUINT_RTIE:      equ    %10000000


;*** CPMUCLKS - S12CPMU Clock Select Register; 0x00000039 ***
CPMUCLKS:           equ    $00000039                                ;*** CPMUCLKS - S12CPMU Clock Select Register; 0x00000039 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CPMUCLKS_COPOSCSEL: equ    0                                         ; COP Clock Select
CPMUCLKS_RTIOSCSEL: equ    1                                         ; RTI Clock Select
CPMUCLKS_PCE:       equ    2                                         ; COP Enable During Pseudo Stop Bit
CPMUCLKS_PRE:       equ    3                                         ; RTI Enable During Pseudo Stop Bit
CPMUCLKS_PSTP:      equ    6                                         ; Pseudo Stop Bit
CPMUCLKS_PLLSEL:    equ    7                                         ; PLL Select Bit
; bit position masks
mCPMUCLKS_COPOSCSEL: equ    %00000001
mCPMUCLKS_RTIOSCSEL: equ    %00000010
mCPMUCLKS_PCE:      equ    %00000100
mCPMUCLKS_PRE:      equ    %00001000
mCPMUCLKS_PSTP:     equ    %01000000
mCPMUCLKS_PLLSEL:   equ    %10000000


;*** CPMUPLL - S12CPMU PLL Control Register; 0x0000003A ***
CPMUPLL:            equ    $0000003A                                ;*** CPMUPLL - S12CPMU PLL Control Register; 0x0000003A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CPMUPLL_FM0:        equ    4                                         ; PLL Frequency Modulation Enable Bit 0
CPMUPLL_FM1:        equ    5                                         ; PLL Frequency Modulation Enable Bit 1
; bit position masks
mCPMUPLL_FM0:       equ    %00010000
mCPMUPLL_FM1:       equ    %00100000


;*** CPMURTI - CPMU RTI Control Register; 0x0000003B ***
CPMURTI:            equ    $0000003B                                ;*** CPMURTI - CPMU RTI Control Register; 0x0000003B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CPMURTI_RTR0:       equ    0                                         ; Real Time Interrupt Modulus Counter Select Bit 0
CPMURTI_RTR1:       equ    1                                         ; Real Time Interrupt Modulus Counter Select Bit 1
CPMURTI_RTR2:       equ    2                                         ; Real Time Interrupt Modulus Counter Select Bit 2
CPMURTI_RTR3:       equ    3                                         ; Real Time Interrupt Modulus Counter Select Bit 3
CPMURTI_RTR4:       equ    4                                         ; Real Time Interrupt Prescale Rate Select Bit 4
CPMURTI_RTR5:       equ    5                                         ; Real Time Interrupt Prescale Rate Select Bit 5
CPMURTI_RTR6:       equ    6                                         ; Real Time Interrupt Prescale Rate Select Bit 6
CPMURTI_RTDEC:      equ    7                                         ; Decimal or Binary Divider Select Bit
; bit position masks
mCPMURTI_RTR0:      equ    %00000001
mCPMURTI_RTR1:      equ    %00000010
mCPMURTI_RTR2:      equ    %00000100
mCPMURTI_RTR3:      equ    %00001000
mCPMURTI_RTR4:      equ    %00010000
mCPMURTI_RTR5:      equ    %00100000
mCPMURTI_RTR6:      equ    %01000000
mCPMURTI_RTDEC:     equ    %10000000


;*** CPMUCOP - CPMU COP Control Register; 0x0000003C ***
CPMUCOP:            equ    $0000003C                                ;*** CPMUCOP - CPMU COP Control Register; 0x0000003C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CPMUCOP_CR0:        equ    0                                         ; COP Watchdog Timer Rate select Bit 0
CPMUCOP_CR1:        equ    1                                         ; COP Watchdog Timer Rate select Bit 1
CPMUCOP_CR2:        equ    2                                         ; COP Watchdog Timer Rate select Bit 2
CPMUCOP_WRTMASK:    equ    5                                         ; Write Mask for WCOP
CPMUCOP_RSBCK:      equ    6                                         ; COP and RTI stop in Active BDM mode Bit
CPMUCOP_WCOP:       equ    7                                         ; Window COP mode
; bit position masks
mCPMUCOP_CR0:       equ    %00000001
mCPMUCOP_CR1:       equ    %00000010
mCPMUCOP_CR2:       equ    %00000100
mCPMUCOP_WRTMASK:   equ    %00100000
mCPMUCOP_RSBCK:     equ    %01000000
mCPMUCOP_WCOP:      equ    %10000000


;*** CPMUARMCOP - CPMU COP Timer Arm/Reset Register; 0x0000003F ***
CPMUARMCOP:         equ    $0000003F                                ;*** CPMUARMCOP - CPMU COP Timer Arm/Reset Register; 0x0000003F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CPMUARMCOP_BIT0:    equ    0                                         ; CPMU COP Timer Arm/Reset Bit 0
CPMUARMCOP_BIT1:    equ    1                                         ; CPMU COP Timer Arm/Reset Bit 1
CPMUARMCOP_BIT2:    equ    2                                         ; CPMU COP Timer Arm/Reset Bit 2
CPMUARMCOP_BIT3:    equ    3                                         ; CPMU COP Timer Arm/Reset Bit 3
CPMUARMCOP_BIT4:    equ    4                                         ; CPMU COP Timer Arm/Reset Bit 4
CPMUARMCOP_BIT5:    equ    5                                         ; CPMU COP Timer Arm/Reset Bit 5
CPMUARMCOP_BIT6:    equ    6                                         ; CPMU COP Timer Arm/Reset Bit 6
CPMUARMCOP_BIT7:    equ    7                                         ; CPMU COP Timer Arm/Reset Bit 7
; bit position masks
mCPMUARMCOP_BIT0:   equ    %00000001
mCPMUARMCOP_BIT1:   equ    %00000010
mCPMUARMCOP_BIT2:   equ    %00000100
mCPMUARMCOP_BIT3:   equ    %00001000
mCPMUARMCOP_BIT4:   equ    %00010000
mCPMUARMCOP_BIT5:   equ    %00100000
mCPMUARMCOP_BIT6:   equ    %01000000
mCPMUARMCOP_BIT7:   equ    %10000000


;*** TIM0_TIOS - Timer Input Capture/Output Compare Select; 0x00000040 ***
TIM0_TIOS:          equ    $00000040                                ;*** TIM0_TIOS - Timer Input Capture/Output Compare Select; 0x00000040 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TIM0_TIOS_IOS0:     equ    0                                         ; Input Capture or Output Compare Channel Configuration Bit 0
TIM0_TIOS_IOS1:     equ    1                                         ; Input Capture or Output Compare Channel Configuration Bit 1
TIM0_TIOS_IOS2:     equ    2                                         ; Input Capture or Output Compare Channel Configuration Bit 2
TIM0_TIOS_IOS3:     equ    3                                         ; Input Capture or Output Compare Channel Configuration Bit 3
TIM0_TIOS_IOS4:     equ    4                                         ; Input Capture or Output Compare Channel Configuration Bit 4
TIM0_TIOS_IOS5:     equ    5                                         ; Input Capture or Output Compare Channel Configuration Bit 5
TIM0_TIOS_IOS6:     equ    6                                         ; Input Capture or Output Compare Channel Configuration Bit 6
TIM0_TIOS_IOS7:     equ    7                                         ; Input Capture or Output Compare Channel Configuration Bit 7
; bit position masks
mTIM0_TIOS_IOS0:    equ    %00000001
mTIM0_TIOS_IOS1:    equ    %00000010
mTIM0_TIOS_IOS2:    equ    %00000100
mTIM0_TIOS_IOS3:    equ    %00001000
mTIM0_TIOS_IOS4:    equ    %00010000
mTIM0_TIOS_IOS5:    equ    %00100000
mTIM0_TIOS_IOS6:    equ    %01000000
mTIM0_TIOS_IOS7:    equ    %10000000


;*** TIM0_CFORC - Timer Compare Force Register; 0x00000041 ***
TIM0_CFORC:         equ    $00000041                                ;*** TIM0_CFORC - Timer Compare Force Register; 0x00000041 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TIM0_CFORC_FOC0:    equ    0                                         ; Force Output Compare Action for Channel 0
TIM0_CFORC_FOC1:    equ    1                                         ; Force Output Compare Action for Channel 1
TIM0_CFORC_FOC2:    equ    2                                         ; Force Output Compare Action for Channel 2
TIM0_CFORC_FOC3:    equ    3                                         ; Force Output Compare Action for Channel 3
TIM0_CFORC_FOC4:    equ    4                                         ; Force Output Compare Action for Channel 4
TIM0_CFORC_FOC5:    equ    5                                         ; Force Output Compare Action for Channel 5
TIM0_CFORC_FOC6:    equ    6                                         ; Force Output Compare Action for Channel 6
TIM0_CFORC_FOC7:    equ    7                                         ; Force Output Compare Action for Channel 7
; bit position masks
mTIM0_CFORC_FOC0:   equ    %00000001
mTIM0_CFORC_FOC1:   equ    %00000010
mTIM0_CFORC_FOC2:   equ    %00000100
mTIM0_CFORC_FOC3:   equ    %00001000
mTIM0_CFORC_FOC4:   equ    %00010000
mTIM0_CFORC_FOC5:   equ    %00100000
mTIM0_CFORC_FOC6:   equ    %01000000
mTIM0_CFORC_FOC7:   equ    %10000000


;*** TIM0_OC7M - Output Compare 7 Mask Register; 0x00000042 ***
TIM0_OC7M:          equ    $00000042                                ;*** TIM0_OC7M - Output Compare 7 Mask Register; 0x00000042 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TIM0_OC7M_OC7M0:    equ    0                                         ; Output Compare 7 Mask Bit 0
TIM0_OC7M_OC7M1:    equ    1                                         ; Output Compare 7 Mask Bit 1
TIM0_OC7M_OC7M2:    equ    2                                         ; Output Compare 7 Mask Bit 2
TIM0_OC7M_OC7M3:    equ    3                                         ; Output Compare 7 Mask Bit 3
TIM0_OC7M_OC7M4:    equ    4                                         ; Output Compare 7 Mask Bit 4
TIM0_OC7M_OC7M5:    equ    5                                         ; Output Compare 7 Mask Bit 5
TIM0_OC7M_OC7M6:    equ    6                                         ; Output Compare 7 Mask Bit 6
TIM0_OC7M_OC7M7:    equ    7                                         ; Output Compare 7 Mask Bit 7
; bit position masks
mTIM0_OC7M_OC7M0:   equ    %00000001
mTIM0_OC7M_OC7M1:   equ    %00000010
mTIM0_OC7M_OC7M2:   equ    %00000100
mTIM0_OC7M_OC7M3:   equ    %00001000
mTIM0_OC7M_OC7M4:   equ    %00010000
mTIM0_OC7M_OC7M5:   equ    %00100000
mTIM0_OC7M_OC7M6:   equ    %01000000
mTIM0_OC7M_OC7M7:   equ    %10000000


;*** TIM0_OC7D - Output Compare 7 Data Register; 0x00000043 ***
TIM0_OC7D:          equ    $00000043                                ;*** TIM0_OC7D - Output Compare 7 Data Register; 0x00000043 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TIM0_OC7D_OC7D0:    equ    0                                         ; Output Compare 7 Bit 0
TIM0_OC7D_OC7D1:    equ    1                                         ; Output Compare 7 Bit 1
TIM0_OC7D_OC7D2:    equ    2                                         ; Output Compare 7 Bit 2
TIM0_OC7D_OC7D3:    equ    3                                         ; Output Compare 7 Bit 3
TIM0_OC7D_OC7D4:    equ    4                                         ; Output Compare 7 Bit 4
TIM0_OC7D_OC7D5:    equ    5                                         ; Output Compare 7 Bit 5
TIM0_OC7D_OC7D6:    equ    6                                         ; Output Compare 7 Bit 6
TIM0_OC7D_OC7D7:    equ    7                                         ; Output Compare 7 Bit 7
; bit position masks
mTIM0_OC7D_OC7D0:   equ    %00000001
mTIM0_OC7D_OC7D1:   equ    %00000010
mTIM0_OC7D_OC7D2:   equ    %00000100
mTIM0_OC7D_OC7D3:   equ    %00001000
mTIM0_OC7D_OC7D4:   equ    %00010000
mTIM0_OC7D_OC7D5:   equ    %00100000
mTIM0_OC7D_OC7D6:   equ    %01000000
mTIM0_OC7D_OC7D7:   equ    %10000000


;*** TIM0_TCNT - Timer Count Register; 0x00000044 ***
TIM0_TCNT:          equ    $00000044                                ;*** TIM0_TCNT - Timer Count Register; 0x00000044 ***


;*** TIM0_TCNTHi - Timer Count Register High; 0x00000044 ***
TIM0_TCNTHi:        equ    $00000044                                ;*** TIM0_TCNTHi - Timer Count Register High; 0x00000044 ***


;*** TIM0_TCNTLo - Timer Count Register Low; 0x00000045 ***
TIM0_TCNTLo:        equ    $00000045                                ;*** TIM0_TCNTLo - Timer Count Register Low; 0x00000045 ***


;*** TIM0_TSCR1 - Timer System Control Register1; 0x00000046 ***
TIM0_TSCR1:         equ    $00000046                                ;*** TIM0_TSCR1 - Timer System Control Register1; 0x00000046 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TIM0_TSCR1_PRNT:    equ    3                                         ; Precision Timer
TIM0_TSCR1_TFFCA:   equ    4                                         ; Timer Fast Flag Clear All
TIM0_TSCR1_TSFRZ:   equ    5                                         ; Timer and Modulus Counter Stop While in Freeze Mode
TIM0_TSCR1_TSWAI:   equ    6                                         ; Timer Module Stops While in Wait
TIM0_TSCR1_TEN:     equ    7                                         ; Timer Enable
; bit position masks
mTIM0_TSCR1_PRNT:   equ    %00001000
mTIM0_TSCR1_TFFCA:  equ    %00010000
mTIM0_TSCR1_TSFRZ:  equ    %00100000
mTIM0_TSCR1_TSWAI:  equ    %01000000
mTIM0_TSCR1_TEN:    equ    %10000000


;*** TIM0_TTOV - Timer Toggle On Overflow Register; 0x00000047 ***
TIM0_TTOV:          equ    $00000047                                ;*** TIM0_TTOV - Timer Toggle On Overflow Register; 0x00000047 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TIM0_TTOV_TOV0:     equ    0                                         ; Toggle On Overflow Bit 0
TIM0_TTOV_TOV1:     equ    1                                         ; Toggle On Overflow Bit 1
TIM0_TTOV_TOV2:     equ    2                                         ; Toggle On Overflow Bit 2
TIM0_TTOV_TOV3:     equ    3                                         ; Toggle On Overflow Bit 3
TIM0_TTOV_TOV4:     equ    4                                         ; Toggle On Overflow Bit 4
TIM0_TTOV_TOV5:     equ    5                                         ; Toggle On Overflow Bit 5
TIM0_TTOV_TOV6:     equ    6                                         ; Toggle On Overflow Bit 6
TIM0_TTOV_TOV7:     equ    7                                         ; Toggle On Overflow Bit 7
; bit position masks
mTIM0_TTOV_TOV0:    equ    %00000001
mTIM0_TTOV_TOV1:    equ    %00000010
mTIM0_TTOV_TOV2:    equ    %00000100
mTIM0_TTOV_TOV3:    equ    %00001000
mTIM0_TTOV_TOV4:    equ    %00010000
mTIM0_TTOV_TOV5:    equ    %00100000
mTIM0_TTOV_TOV6:    equ    %01000000
mTIM0_TTOV_TOV7:    equ    %10000000


;*** TIM0_TCTL1 - Timer Control Register 1; 0x00000048 ***
TIM0_TCTL1:         equ    $00000048                                ;*** TIM0_TCTL1 - Timer Control Register 1; 0x00000048 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TIM0_TCTL1_OL4:     equ    0                                         ; Output Level Bit 4
TIM0_TCTL1_OM4:     equ    1                                         ; Output Mode Bit 4
TIM0_TCTL1_OL5:     equ    2                                         ; Output Level Bit 5
TIM0_TCTL1_OM5:     equ    3                                         ; Output Mode Bit 5
TIM0_TCTL1_OL6:     equ    4                                         ; Output Level Bit 6
TIM0_TCTL1_OM6:     equ    5                                         ; Output Mode Bit 6
TIM0_TCTL1_OL7:     equ    6                                         ; Output Level Bit 7
TIM0_TCTL1_OM7:     equ    7                                         ; Output Mode Bit 7
; bit position masks
mTIM0_TCTL1_OL4:    equ    %00000001
mTIM0_TCTL1_OM4:    equ    %00000010
mTIM0_TCTL1_OL5:    equ    %00000100
mTIM0_TCTL1_OM5:    equ    %00001000
mTIM0_TCTL1_OL6:    equ    %00010000
mTIM0_TCTL1_OM6:    equ    %00100000
mTIM0_TCTL1_OL7:    equ    %01000000
mTIM0_TCTL1_OM7:    equ    %10000000


;*** TIM0_TCTL2 - Timer Control Register 2; 0x00000049 ***
TIM0_TCTL2:         equ    $00000049                                ;*** TIM0_TCTL2 - Timer Control Register 2; 0x00000049 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TIM0_TCTL2_OL0:     equ    0                                         ; Output Level Bit 0
TIM0_TCTL2_OM0:     equ    1                                         ; Output Mode Bit 0
TIM0_TCTL2_OL1:     equ    2                                         ; Output Lecel Bit 1
TIM0_TCTL2_OM1:     equ    3                                         ; Output Mode Bit 1
TIM0_TCTL2_OL2:     equ    4                                         ; Output Level Bit 2
TIM0_TCTL2_OM2:     equ    5                                         ; Output Mode Bit 2
TIM0_TCTL2_OL3:     equ    6                                         ; Output Level Bit 3
TIM0_TCTL2_OM3:     equ    7                                         ; Output Mode Bit 3
; bit position masks
mTIM0_TCTL2_OL0:    equ    %00000001
mTIM0_TCTL2_OM0:    equ    %00000010
mTIM0_TCTL2_OL1:    equ    %00000100
mTIM0_TCTL2_OM1:    equ    %00001000
mTIM0_TCTL2_OL2:    equ    %00010000
mTIM0_TCTL2_OM2:    equ    %00100000
mTIM0_TCTL2_OL3:    equ    %01000000
mTIM0_TCTL2_OM3:    equ    %10000000


;*** TIM0_TCTL3 - Timer Control Register 3; 0x0000004A ***
TIM0_TCTL3:         equ    $0000004A                                ;*** TIM0_TCTL3 - Timer Control Register 3; 0x0000004A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TIM0_TCTL3_EDG4A:   equ    0                                         ; Input Capture Edge Control 4A
TIM0_TCTL3_EDG4B:   equ    1                                         ; Input Capture Edge Control 4B
TIM0_TCTL3_EDG5A:   equ    2                                         ; Input Capture Edge Control 5A
TIM0_TCTL3_EDG5B:   equ    3                                         ; Input Capture Edge Control 5B
TIM0_TCTL3_EDG6A:   equ    4                                         ; Input Capture Edge Control 6A
TIM0_TCTL3_EDG6B:   equ    5                                         ; Input Capture Edge Control 6B
TIM0_TCTL3_EDG7A:   equ    6                                         ; Input Capture Edge Control 7A
TIM0_TCTL3_EDG7B:   equ    7                                         ; Input Capture Edge Control 7B
; bit position masks
mTIM0_TCTL3_EDG4A:  equ    %00000001
mTIM0_TCTL3_EDG4B:  equ    %00000010
mTIM0_TCTL3_EDG5A:  equ    %00000100
mTIM0_TCTL3_EDG5B:  equ    %00001000
mTIM0_TCTL3_EDG6A:  equ    %00010000
mTIM0_TCTL3_EDG6B:  equ    %00100000
mTIM0_TCTL3_EDG7A:  equ    %01000000
mTIM0_TCTL3_EDG7B:  equ    %10000000


;*** TIM0_TCTL4 - Timer Control Register 4; 0x0000004B ***
TIM0_TCTL4:         equ    $0000004B                                ;*** TIM0_TCTL4 - Timer Control Register 4; 0x0000004B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TIM0_TCTL4_EDG0A:   equ    0                                         ; Input Capture Edge Control 0A
TIM0_TCTL4_EDG0B:   equ    1                                         ; Input Capture Edge Control 0B
TIM0_TCTL4_EDG1A:   equ    2                                         ; Input Capture Edge Control 1A
TIM0_TCTL4_EDG1B:   equ    3                                         ; Input Capture Edge Control 1B
TIM0_TCTL4_EDG2A:   equ    4                                         ; Input Capture Edge Control 2A
TIM0_TCTL4_EDG2B:   equ    5                                         ; Input Capture Edge Control 2B
TIM0_TCTL4_EDG3A:   equ    6                                         ; Input Capture Edge Control 3A
TIM0_TCTL4_EDG3B:   equ    7                                         ; Input Capture Edge Control 3B
; bit position masks
mTIM0_TCTL4_EDG0A:  equ    %00000001
mTIM0_TCTL4_EDG0B:  equ    %00000010
mTIM0_TCTL4_EDG1A:  equ    %00000100
mTIM0_TCTL4_EDG1B:  equ    %00001000
mTIM0_TCTL4_EDG2A:  equ    %00010000
mTIM0_TCTL4_EDG2B:  equ    %00100000
mTIM0_TCTL4_EDG3A:  equ    %01000000
mTIM0_TCTL4_EDG3B:  equ    %10000000


;*** TIM0_TIE - Timer Interrupt Enable Register; 0x0000004C ***
TIM0_TIE:           equ    $0000004C                                ;*** TIM0_TIE - Timer Interrupt Enable Register; 0x0000004C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TIM0_TIE_C0I:       equ    0                                         ; Input Capture/Output Compare Interrupt Enable Bit 0
TIM0_TIE_C1I:       equ    1                                         ; Input Capture/Output Compare Interrupt Enable Bit 1
TIM0_TIE_C2I:       equ    2                                         ; Input Capture/Output Compare Interrupt Enable Bit 2
TIM0_TIE_C3I:       equ    3                                         ; Input Capture/Output Compare Interrupt Enable Bit 3
TIM0_TIE_C4I:       equ    4                                         ; Input Capture/Output Compare Interrupt Enable Bit 4
TIM0_TIE_C5I:       equ    5                                         ; Input Capture/Output Compare Interrupt Enable Bit 5
TIM0_TIE_C6I:       equ    6                                         ; Input Capture/Output Compare Interrupt Enable Bit 6
TIM0_TIE_C7I:       equ    7                                         ; Input Capture/Output Compare Interrupt Enable Bit 7
; bit position masks
mTIM0_TIE_C0I:      equ    %00000001
mTIM0_TIE_C1I:      equ    %00000010
mTIM0_TIE_C2I:      equ    %00000100
mTIM0_TIE_C3I:      equ    %00001000
mTIM0_TIE_C4I:      equ    %00010000
mTIM0_TIE_C5I:      equ    %00100000
mTIM0_TIE_C6I:      equ    %01000000
mTIM0_TIE_C7I:      equ    %10000000


;*** TIM0_TSCR2 - Timer System Control Register 2; 0x0000004D ***
TIM0_TSCR2:         equ    $0000004D                                ;*** TIM0_TSCR2 - Timer System Control Register 2; 0x0000004D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TIM0_TSCR2_PR0:     equ    0                                         ; Timer Prescaler Select Bit 0
TIM0_TSCR2_PR1:     equ    1                                         ; Timer Prescaler Select Bit 1
TIM0_TSCR2_PR2:     equ    2                                         ; Timer Prescaler Select Bit 2
TIM0_TSCR2_TCRE:    equ    3                                         ; Timer Counter Reset Enable
TIM0_TSCR2_TOI:     equ    7                                         ; Timer Overflow Interrupt Enable
; bit position masks
mTIM0_TSCR2_PR0:    equ    %00000001
mTIM0_TSCR2_PR1:    equ    %00000010
mTIM0_TSCR2_PR2:    equ    %00000100
mTIM0_TSCR2_TCRE:   equ    %00001000
mTIM0_TSCR2_TOI:    equ    %10000000


;*** TIM0_TFLG1 - Main Timer Interrupt Flag 1; 0x0000004E ***
TIM0_TFLG1:         equ    $0000004E                                ;*** TIM0_TFLG1 - Main Timer Interrupt Flag 1; 0x0000004E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TIM0_TFLG1_C0F:     equ    0                                         ; Input Capture/Output Compare Channel Flag 0
TIM0_TFLG1_C1F:     equ    1                                         ; Input Capture/Output Compare Channel Flag 1
TIM0_TFLG1_C2F:     equ    2                                         ; Input Capture/Output Compare Channel Flag 2
TIM0_TFLG1_C3F:     equ    3                                         ; Input Capture/Output Compare Channel Flag 3
TIM0_TFLG1_C4F:     equ    4                                         ; Input Capture/Output Compare Channel Flag 4
TIM0_TFLG1_C5F:     equ    5                                         ; Input Capture/Output Compare Channel Flag 5
TIM0_TFLG1_C6F:     equ    6                                         ; Input Capture/Output Compare Channel Flag 6
TIM0_TFLG1_C7F:     equ    7                                         ; Input Capture/Output Compare Channel Flag 7
; bit position masks
mTIM0_TFLG1_C0F:    equ    %00000001
mTIM0_TFLG1_C1F:    equ    %00000010
mTIM0_TFLG1_C2F:    equ    %00000100
mTIM0_TFLG1_C3F:    equ    %00001000
mTIM0_TFLG1_C4F:    equ    %00010000
mTIM0_TFLG1_C5F:    equ    %00100000
mTIM0_TFLG1_C6F:    equ    %01000000
mTIM0_TFLG1_C7F:    equ    %10000000


;*** TIM0_TFLG2 - Main Timer Interrupt Flag 2; 0x0000004F ***
TIM0_TFLG2:         equ    $0000004F                                ;*** TIM0_TFLG2 - Main Timer Interrupt Flag 2; 0x0000004F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TIM0_TFLG2_TOF:     equ    7                                         ; Timer Overflow Flag
; bit position masks
mTIM0_TFLG2_TOF:    equ    %10000000


;*** TIM0_TC0 - Timer Input Capture/Output Compare Register 0; 0x00000050 ***
TIM0_TC0:           equ    $00000050                                ;*** TIM0_TC0 - Timer Input Capture/Output Compare Register 0; 0x00000050 ***


;*** TIM0_TC0Hi - Timer Input Capture/Output Compare Register 0 High; 0x00000050 ***
TIM0_TC0Hi:         equ    $00000050                                ;*** TIM0_TC0Hi - Timer Input Capture/Output Compare Register 0 High; 0x00000050 ***


;*** TIM0_TC0Lo - Timer Input Capture/Output Compare Register 0 Low; 0x00000051 ***
TIM0_TC0Lo:         equ    $00000051                                ;*** TIM0_TC0Lo - Timer Input Capture/Output Compare Register 0 Low; 0x00000051 ***


;*** TIM0_TC1 - Timer Input Capture/Output Compare Register 1; 0x00000052 ***
TIM0_TC1:           equ    $00000052                                ;*** TIM0_TC1 - Timer Input Capture/Output Compare Register 1; 0x00000052 ***


;*** TIM0_TC1Hi - Timer Input Capture/Output Compare Register 1 High; 0x00000052 ***
TIM0_TC1Hi:         equ    $00000052                                ;*** TIM0_TC1Hi - Timer Input Capture/Output Compare Register 1 High; 0x00000052 ***


;*** TIM0_TC1Lo - Timer Input Capture/Output Compare Register 1 Low; 0x00000053 ***
TIM0_TC1Lo:         equ    $00000053                                ;*** TIM0_TC1Lo - Timer Input Capture/Output Compare Register 1 Low; 0x00000053 ***


;*** TIM0_TC2 - Timer Input Capture/Output Compare Register 2; 0x00000054 ***
TIM0_TC2:           equ    $00000054                                ;*** TIM0_TC2 - Timer Input Capture/Output Compare Register 2; 0x00000054 ***


;*** TIM0_TC2Hi - Timer Input Capture/Output Compare Register 2 High; 0x00000054 ***
TIM0_TC2Hi:         equ    $00000054                                ;*** TIM0_TC2Hi - Timer Input Capture/Output Compare Register 2 High; 0x00000054 ***


;*** TIM0_TC2Lo - Timer Input Capture/Output Compare Register 2 Low; 0x00000055 ***
TIM0_TC2Lo:         equ    $00000055                                ;*** TIM0_TC2Lo - Timer Input Capture/Output Compare Register 2 Low; 0x00000055 ***


;*** TIM0_TC3 - Timer Input Capture/Output Compare Register 3; 0x00000056 ***
TIM0_TC3:           equ    $00000056                                ;*** TIM0_TC3 - Timer Input Capture/Output Compare Register 3; 0x00000056 ***


;*** TIM0_TC3Hi - Timer Input Capture/Output Compare Register 3 High; 0x00000056 ***
TIM0_TC3Hi:         equ    $00000056                                ;*** TIM0_TC3Hi - Timer Input Capture/Output Compare Register 3 High; 0x00000056 ***


;*** TIM0_TC3Lo - Timer Input Capture/Output Compare Register 3 Low; 0x00000057 ***
TIM0_TC3Lo:         equ    $00000057                                ;*** TIM0_TC3Lo - Timer Input Capture/Output Compare Register 3 Low; 0x00000057 ***


;*** TIM0_TC4 - Timer Input Capture/Output Compare Register 4; 0x00000058 ***
TIM0_TC4:           equ    $00000058                                ;*** TIM0_TC4 - Timer Input Capture/Output Compare Register 4; 0x00000058 ***


;*** TIM0_TC4Hi - Timer Input Capture/Output Compare Register 4 High; 0x00000058 ***
TIM0_TC4Hi:         equ    $00000058                                ;*** TIM0_TC4Hi - Timer Input Capture/Output Compare Register 4 High; 0x00000058 ***


;*** TIM0_TC4Lo - Timer Input Capture/Output Compare Register 4 Low; 0x00000059 ***
TIM0_TC4Lo:         equ    $00000059                                ;*** TIM0_TC4Lo - Timer Input Capture/Output Compare Register 4 Low; 0x00000059 ***


;*** TIM0_TC5 - Timer Input Capture/Output Compare Register 5; 0x0000005A ***
TIM0_TC5:           equ    $0000005A                                ;*** TIM0_TC5 - Timer Input Capture/Output Compare Register 5; 0x0000005A ***


;*** TIM0_TC5Hi - Timer Input Capture/Output Compare Register 5 High; 0x0000005A ***
TIM0_TC5Hi:         equ    $0000005A                                ;*** TIM0_TC5Hi - Timer Input Capture/Output Compare Register 5 High; 0x0000005A ***


;*** TIM0_TC5Lo - Timer Input Capture/Output Compare Register 5 Low; 0x0000005B ***
TIM0_TC5Lo:         equ    $0000005B                                ;*** TIM0_TC5Lo - Timer Input Capture/Output Compare Register 5 Low; 0x0000005B ***


;*** TIM0_TC6 - Timer Input Capture/Output Compare Register 6; 0x0000005C ***
TIM0_TC6:           equ    $0000005C                                ;*** TIM0_TC6 - Timer Input Capture/Output Compare Register 6; 0x0000005C ***


;*** TIM0_TC6Hi - Timer Input Capture/Output Compare Register 6 High; 0x0000005C ***
TIM0_TC6Hi:         equ    $0000005C                                ;*** TIM0_TC6Hi - Timer Input Capture/Output Compare Register 6 High; 0x0000005C ***


;*** TIM0_TC6Lo - Timer Input Capture/Output Compare Register 6 Low; 0x0000005D ***
TIM0_TC6Lo:         equ    $0000005D                                ;*** TIM0_TC6Lo - Timer Input Capture/Output Compare Register 6 Low; 0x0000005D ***


;*** TIM0_TC7 - Timer Input Capture/Output Compare Register 7; 0x0000005E ***
TIM0_TC7:           equ    $0000005E                                ;*** TIM0_TC7 - Timer Input Capture/Output Compare Register 7; 0x0000005E ***


;*** TIM0_TC7Hi - Timer Input Capture/Output Compare Register 7 High; 0x0000005E ***
TIM0_TC7Hi:         equ    $0000005E                                ;*** TIM0_TC7Hi - Timer Input Capture/Output Compare Register 7 High; 0x0000005E ***


;*** TIM0_TC7Lo - Timer Input Capture/Output Compare Register 7 Low; 0x0000005F ***
TIM0_TC7Lo:         equ    $0000005F                                ;*** TIM0_TC7Lo - Timer Input Capture/Output Compare Register 7 Low; 0x0000005F ***


;*** TIM0_PACTL - 16-Bit Pulse Accumulator A Control Register; 0x00000060 ***
TIM0_PACTL:         equ    $00000060                                ;*** TIM0_PACTL - 16-Bit Pulse Accumulator A Control Register; 0x00000060 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TIM0_PACTL_PAI:     equ    0                                         ; Pulse Accumulator Input Interrupt enable
TIM0_PACTL_PAOVI:   equ    1                                         ; Pulse Accumulator A Overflow Interrupt enable
TIM0_PACTL_CLK0:    equ    2                                         ; Clock Select Bit 0
TIM0_PACTL_CLK1:    equ    3                                         ; Clock Select Bit 1
TIM0_PACTL_PEDGE:   equ    4                                         ; Pulse Accumulator Edge Control
TIM0_PACTL_PAMOD:   equ    5                                         ; Pulse Accumulator Mode
TIM0_PACTL_PAEN:    equ    6                                         ; Pulse Accumulator A System Enable
; bit position masks
mTIM0_PACTL_PAI:    equ    %00000001
mTIM0_PACTL_PAOVI:  equ    %00000010
mTIM0_PACTL_CLK0:   equ    %00000100
mTIM0_PACTL_CLK1:   equ    %00001000
mTIM0_PACTL_PEDGE:  equ    %00010000
mTIM0_PACTL_PAMOD:  equ    %00100000
mTIM0_PACTL_PAEN:   equ    %01000000


;*** TIM0_PAFLG - Pulse Accumulator A Flag Register; 0x00000061 ***
TIM0_PAFLG:         equ    $00000061                                ;*** TIM0_PAFLG - Pulse Accumulator A Flag Register; 0x00000061 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TIM0_PAFLG_PAIF:    equ    0                                         ; Pulse Accumulator Input edge Flag
TIM0_PAFLG_PAOVF:   equ    1                                         ; Pulse Accumulator A Overflow Flag
; bit position masks
mTIM0_PAFLG_PAIF:   equ    %00000001
mTIM0_PAFLG_PAOVF:  equ    %00000010


;*** TIM0_PACNT - Pulse Accumulators Count Register; 0x00000062 ***
TIM0_PACNT:         equ    $00000062                                ;*** TIM0_PACNT - Pulse Accumulators Count Register; 0x00000062 ***


;*** TIM0_PACNTH - Pulse Accumulators Count Register High; 0x00000062 ***
TIM0_PACNTH:        equ    $00000062                                ;*** TIM0_PACNTH - Pulse Accumulators Count Register High; 0x00000062 ***


;*** TIM0_PACNTL - Pulse Accumulators Count Register Low; 0x00000063 ***
TIM0_PACNTL:        equ    $00000063                                ;*** TIM0_PACNTL - Pulse Accumulators Count Register Low; 0x00000063 ***


;*** TIM0_OCPD - Output Compare Pin Disconnect Register; 0x0000006C ***
TIM0_OCPD:          equ    $0000006C                                ;*** TIM0_OCPD - Output Compare Pin Disconnect Register; 0x0000006C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TIM0_OCPD_OCPD0:    equ    0                                         ; Output Compare Pin Disconnect Bit 0
TIM0_OCPD_OCPD1:    equ    1                                         ; Output Compare Pin Disconnect Bit 1
TIM0_OCPD_OCPD2:    equ    2                                         ; Output Compare Pin Disconnect Bit 2
TIM0_OCPD_OCPD3:    equ    3                                         ; Output Compare Pin Disconnect Bit 3
TIM0_OCPD_OCPD4:    equ    4                                         ; Output Compare Pin Disconnect Bit 4
TIM0_OCPD_OCPD5:    equ    5                                         ; Output Compare Pin Disconnect Bit 5
TIM0_OCPD_OCPD6:    equ    6                                         ; Output Compare Pin Disconnect Bit 6
TIM0_OCPD_OCPD7:    equ    7                                         ; Output Compare Pin Disconnect Bit 7
; bit position masks
mTIM0_OCPD_OCPD0:   equ    %00000001
mTIM0_OCPD_OCPD1:   equ    %00000010
mTIM0_OCPD_OCPD2:   equ    %00000100
mTIM0_OCPD_OCPD3:   equ    %00001000
mTIM0_OCPD_OCPD4:   equ    %00010000
mTIM0_OCPD_OCPD5:   equ    %00100000
mTIM0_OCPD_OCPD6:   equ    %01000000
mTIM0_OCPD_OCPD7:   equ    %10000000


;*** TIM0_PTPSR - Precision Timer Prescaler Select Register; 0x0000006E ***
TIM0_PTPSR:         equ    $0000006E                                ;*** TIM0_PTPSR - Precision Timer Prescaler Select Register; 0x0000006E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TIM0_PTPSR_PTPS0:   equ    0                                         ; Precision Timer Prescaler Select Bit 0
TIM0_PTPSR_PTPS1:   equ    1                                         ; Precision Timer Prescaler Select Bit 1
TIM0_PTPSR_PTPS2:   equ    2                                         ; Precision Timer Prescaler Select Bit 2
TIM0_PTPSR_PTPS3:   equ    3                                         ; Precision Timer Prescaler Select Bit 3
TIM0_PTPSR_PTPS4:   equ    4                                         ; Precision Timer Prescaler Select Bit 4
TIM0_PTPSR_PTPS5:   equ    5                                         ; Precision Timer Prescaler Select Bit 5
TIM0_PTPSR_PTPS6:   equ    6                                         ; Precision Timer Prescaler Select Bit 6
TIM0_PTPSR_PTPS7:   equ    7                                         ; Precision Timer Prescaler Select Bit 7
; bit position masks
mTIM0_PTPSR_PTPS0:  equ    %00000001
mTIM0_PTPSR_PTPS1:  equ    %00000010
mTIM0_PTPSR_PTPS2:  equ    %00000100
mTIM0_PTPSR_PTPS3:  equ    %00001000
mTIM0_PTPSR_PTPS4:  equ    %00010000
mTIM0_PTPSR_PTPS5:  equ    %00100000
mTIM0_PTPSR_PTPS6:  equ    %01000000
mTIM0_PTPSR_PTPS7:  equ    %10000000


;*** ATDCTL01 - ATD  Control Register 01; 0x00000070 ***
ATDCTL01:           equ    $00000070                                ;*** ATDCTL01 - ATD  Control Register 01; 0x00000070 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDCTL01_ETRIGCH0:  equ    0                                         ; External Trigger Channel Select Bit 0
ATDCTL01_ETRIGCH1:  equ    1                                         ; External Trigger Channel Select Bit 1
ATDCTL01_ETRIGCH2:  equ    2                                         ; External Trigger Channel Select Bit 2
ATDCTL01_ETRIGCH3:  equ    3                                         ; External Trigger Channel Select Bit 3
ATDCTL01_SMP_DIS:   equ    4                                         ; Discharge Before Sampling Bit
ATDCTL01_SRES0:     equ    5                                         ; A/D Resolution Select Bit 0
ATDCTL01_SRES1:     equ    6                                         ; A/D Resolution Select Bit 1
ATDCTL01_ETRIGSEL:  equ    7                                         ; External Trigger Source Select
ATDCTL01_WRAP0:     equ    8                                         ; Wrap Around Channel Select Bit 0
ATDCTL01_WRAP1:     equ    9                                         ; Wrap Around Channel Select Bit 1
ATDCTL01_WRAP2:     equ    10                                        ; Wrap Around Channel Select Bit 2
ATDCTL01_WRAP3:     equ    11                                        ; Wrap Around Channel Select Bit 3
; bit position masks
mATDCTL01_ETRIGCH0: equ    %00000001
mATDCTL01_ETRIGCH1: equ    %00000010
mATDCTL01_ETRIGCH2: equ    %00000100
mATDCTL01_ETRIGCH3: equ    %00001000
mATDCTL01_SMP_DIS:  equ    %00010000
mATDCTL01_SRES0:    equ    %00100000
mATDCTL01_SRES1:    equ    %01000000
mATDCTL01_ETRIGSEL: equ    %10000000
mATDCTL01_WRAP0:    equ    %100000000
mATDCTL01_WRAP1:    equ    %1000000000
mATDCTL01_WRAP2:    equ    %10000000000
mATDCTL01_WRAP3:    equ    %100000000000


;*** ATDCTL0 - ATD  Control Register 0; 0x00000070 ***
ATDCTL0:            equ    $00000070                                ;*** ATDCTL0 - ATD  Control Register 0; 0x00000070 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDCTL0_WRAP0:      equ    0                                         ; Wrap Around Channel Select Bit 0
ATDCTL0_WRAP1:      equ    1                                         ; Wrap Around Channel Select Bit 1
ATDCTL0_WRAP2:      equ    2                                         ; Wrap Around Channel Select Bit 2
ATDCTL0_WRAP3:      equ    3                                         ; Wrap Around Channel Select Bit 3
; bit position masks
mATDCTL0_WRAP0:     equ    %00000001
mATDCTL0_WRAP1:     equ    %00000010
mATDCTL0_WRAP2:     equ    %00000100
mATDCTL0_WRAP3:     equ    %00001000


;*** ATDCTL1 - ATD  Control Register 1; 0x00000071 ***
ATDCTL1:            equ    $00000071                                ;*** ATDCTL1 - ATD  Control Register 1; 0x00000071 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDCTL1_ETRIGCH0:   equ    0                                         ; External Trigger Channel Select Bit 0
ATDCTL1_ETRIGCH1:   equ    1                                         ; External Trigger Channel Select Bit 1
ATDCTL1_ETRIGCH2:   equ    2                                         ; External Trigger Channel Select Bit 2
ATDCTL1_ETRIGCH3:   equ    3                                         ; External Trigger Channel Select Bit 3
ATDCTL1_SMP_DIS:    equ    4                                         ; Discharge Before Sampling Bit
ATDCTL1_SRES0:      equ    5                                         ; A/D Resolution Select Bit 0
ATDCTL1_SRES1:      equ    6                                         ; A/D Resolution Select Bit 1
ATDCTL1_ETRIGSEL:   equ    7                                         ; External Trigger Source Select
; bit position masks
mATDCTL1_ETRIGCH0:  equ    %00000001
mATDCTL1_ETRIGCH1:  equ    %00000010
mATDCTL1_ETRIGCH2:  equ    %00000100
mATDCTL1_ETRIGCH3:  equ    %00001000
mATDCTL1_SMP_DIS:   equ    %00010000
mATDCTL1_SRES0:     equ    %00100000
mATDCTL1_SRES1:     equ    %01000000
mATDCTL1_ETRIGSEL:  equ    %10000000


;*** ATDCTL23 - ATD  Control Register 23; 0x00000072 ***
ATDCTL23:           equ    $00000072                                ;*** ATDCTL23 - ATD  Control Register 23; 0x00000072 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDCTL23_FRZ0:      equ    0                                         ; Background Debug Freeze Enable Bit 0
ATDCTL23_FRZ1:      equ    1                                         ; Background Debug Freeze Enable Bit 1
ATDCTL23_FIFO:      equ    2                                         ; Result Register FIFO Mode
ATDCTL23_S1C:       equ    3                                         ; Conversion Sequence Length 1
ATDCTL23_S2C:       equ    4                                         ; Conversion Sequence Length 2
ATDCTL23_S4C:       equ    5                                         ; Conversion Sequence Length 4
ATDCTL23_S8C:       equ    6                                         ; Conversion Sequence Length 8
ATDCTL23_DJM:       equ    7                                         ; Result Register Data Justification
ATDCTL23_ACMPIE:    equ    8                                         ; ATD Compare Interrupt Enable
ATDCTL23_ASCIE:     equ    9                                         ; ATD Sequence Complete Interrupt Enable
ATDCTL23_ETRIGE:    equ    10                                        ; External Trigger Mode enable
ATDCTL23_ETRIGP:    equ    11                                        ; External Trigger Polarity
ATDCTL23_ETRIGLE:   equ    12                                        ; External Trigger Level/Edge control
ATDCTL23_ICLKSTP:   equ    13                                        ; Internal Clock in Stop Mode Bit
ATDCTL23_AFFC:      equ    14                                        ; ATD Fast Conversion Complete Flag Clear
; bit position masks
mATDCTL23_FRZ0:     equ    %00000001
mATDCTL23_FRZ1:     equ    %00000010
mATDCTL23_FIFO:     equ    %00000100
mATDCTL23_S1C:      equ    %00001000
mATDCTL23_S2C:      equ    %00010000
mATDCTL23_S4C:      equ    %00100000
mATDCTL23_S8C:      equ    %01000000
mATDCTL23_DJM:      equ    %10000000
mATDCTL23_ACMPIE:   equ    %100000000
mATDCTL23_ASCIE:    equ    %1000000000
mATDCTL23_ETRIGE:   equ    %10000000000
mATDCTL23_ETRIGP:   equ    %100000000000
mATDCTL23_ETRIGLE:  equ    %1000000000000
mATDCTL23_ICLKSTP:  equ    %10000000000000
mATDCTL23_AFFC:     equ    %100000000000000


;*** ATDCTL2 - ATD  Control Register 2; 0x00000072 ***
ATDCTL2:            equ    $00000072                                ;*** ATDCTL2 - ATD  Control Register 2; 0x00000072 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDCTL2_ACMPIE:     equ    0                                         ; ATD Compare Interrupt Enable
ATDCTL2_ASCIE:      equ    1                                         ; ATD Sequence Complete Interrupt Enable
ATDCTL2_ETRIGE:     equ    2                                         ; External Trigger Mode enable
ATDCTL2_ETRIGP:     equ    3                                         ; External Trigger Polarity
ATDCTL2_ETRIGLE:    equ    4                                         ; External Trigger Level/Edge control
ATDCTL2_ICLKSTP:    equ    5                                         ; Internal Clock in Stop Mode Bit
ATDCTL2_AFFC:       equ    6                                         ; ATD Fast Conversion Complete Flag Clear
; bit position masks
mATDCTL2_ACMPIE:    equ    %00000001
mATDCTL2_ASCIE:     equ    %00000010
mATDCTL2_ETRIGE:    equ    %00000100
mATDCTL2_ETRIGP:    equ    %00001000
mATDCTL2_ETRIGLE:   equ    %00010000
mATDCTL2_ICLKSTP:   equ    %00100000
mATDCTL2_AFFC:      equ    %01000000


;*** ATDCTL3 - ATD  Control Register 3; 0x00000073 ***
ATDCTL3:            equ    $00000073                                ;*** ATDCTL3 - ATD  Control Register 3; 0x00000073 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDCTL3_FRZ0:       equ    0                                         ; Background Debug Freeze Enable Bit 0
ATDCTL3_FRZ1:       equ    1                                         ; Background Debug Freeze Enable Bit 1
ATDCTL3_FIFO:       equ    2                                         ; Result Register FIFO Mode
ATDCTL3_S1C:        equ    3                                         ; Conversion Sequence Length 1
ATDCTL3_S2C:        equ    4                                         ; Conversion Sequence Length 2
ATDCTL3_S4C:        equ    5                                         ; Conversion Sequence Length 4
ATDCTL3_S8C:        equ    6                                         ; Conversion Sequence Length 8
ATDCTL3_DJM:        equ    7                                         ; Result Register Data Justification
; bit position masks
mATDCTL3_FRZ0:      equ    %00000001
mATDCTL3_FRZ1:      equ    %00000010
mATDCTL3_FIFO:      equ    %00000100
mATDCTL3_S1C:       equ    %00001000
mATDCTL3_S2C:       equ    %00010000
mATDCTL3_S4C:       equ    %00100000
mATDCTL3_S8C:       equ    %01000000
mATDCTL3_DJM:       equ    %10000000


;*** ATDCTL45 - ATD  Control Register 45; 0x00000074 ***
ATDCTL45:           equ    $00000074                                ;*** ATDCTL45 - ATD  Control Register 45; 0x00000074 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDCTL45_CA:        equ    0                                         ; Analog Input Channel Select Code A
ATDCTL45_CB:        equ    1                                         ; Analog Input Channel Select Code B
ATDCTL45_CC:        equ    2                                         ; Analog Input Channel Select Code C
ATDCTL45_CD:        equ    3                                         ; Analog Input Channel Select Code D
ATDCTL45_MULT:      equ    4                                         ; Multi-Channel Sample Mode
ATDCTL45_SCAN:      equ    5                                         ; Continuous Conversion Sequence Mode
ATDCTL45_SC:        equ    6                                         ; Special Channel Conversion Bit
ATDCTL45_PRS0:      equ    8                                         ; ATD Clock Prescaler 0
ATDCTL45_PRS1:      equ    9                                         ; ATD Clock Prescaler 1
ATDCTL45_PRS2:      equ    10                                        ; ATD Clock Prescaler 2
ATDCTL45_PRS3:      equ    11                                        ; ATD Clock Prescaler 3
ATDCTL45_PRS4:      equ    12                                        ; ATD Clock Prescaler 4
ATDCTL45_SMP0:      equ    13                                        ; Sample Time Select 0
ATDCTL45_SMP1:      equ    14                                        ; Sample Time Select 1
ATDCTL45_SMP2:      equ    15                                        ; Sample Time Select 2
; bit position masks
mATDCTL45_CA:       equ    %00000001
mATDCTL45_CB:       equ    %00000010
mATDCTL45_CC:       equ    %00000100
mATDCTL45_CD:       equ    %00001000
mATDCTL45_MULT:     equ    %00010000
mATDCTL45_SCAN:     equ    %00100000
mATDCTL45_SC:       equ    %01000000
mATDCTL45_PRS0:     equ    %100000000
mATDCTL45_PRS1:     equ    %1000000000
mATDCTL45_PRS2:     equ    %10000000000
mATDCTL45_PRS3:     equ    %100000000000
mATDCTL45_PRS4:     equ    %1000000000000
mATDCTL45_SMP0:     equ    %10000000000000
mATDCTL45_SMP1:     equ    %100000000000000
mATDCTL45_SMP2:     equ    %1000000000000000


;*** ATDCTL4 - ATD  Control Register 4; 0x00000074 ***
ATDCTL4:            equ    $00000074                                ;*** ATDCTL4 - ATD  Control Register 4; 0x00000074 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDCTL4_PRS0:       equ    0                                         ; ATD Clock Prescaler 0
ATDCTL4_PRS1:       equ    1                                         ; ATD Clock Prescaler 1
ATDCTL4_PRS2:       equ    2                                         ; ATD Clock Prescaler 2
ATDCTL4_PRS3:       equ    3                                         ; ATD Clock Prescaler 3
ATDCTL4_PRS4:       equ    4                                         ; ATD Clock Prescaler 4
ATDCTL4_SMP0:       equ    5                                         ; Sample Time Select 0
ATDCTL4_SMP1:       equ    6                                         ; Sample Time Select 1
ATDCTL4_SMP2:       equ    7                                         ; Sample Time Select 2
; bit position masks
mATDCTL4_PRS0:      equ    %00000001
mATDCTL4_PRS1:      equ    %00000010
mATDCTL4_PRS2:      equ    %00000100
mATDCTL4_PRS3:      equ    %00001000
mATDCTL4_PRS4:      equ    %00010000
mATDCTL4_SMP0:      equ    %00100000
mATDCTL4_SMP1:      equ    %01000000
mATDCTL4_SMP2:      equ    %10000000


;*** ATDCTL5 - ATD  Control Register 5; 0x00000075 ***
ATDCTL5:            equ    $00000075                                ;*** ATDCTL5 - ATD  Control Register 5; 0x00000075 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDCTL5_CA:         equ    0                                         ; Analog Input Channel Select Code A
ATDCTL5_CB:         equ    1                                         ; Analog Input Channel Select Code B
ATDCTL5_CC:         equ    2                                         ; Analog Input Channel Select Code C
ATDCTL5_CD:         equ    3                                         ; Analog Input Channel Select Code D
ATDCTL5_MULT:       equ    4                                         ; Multi-Channel Sample Mode
ATDCTL5_SCAN:       equ    5                                         ; Continuous Conversion Sequence Mode
ATDCTL5_SC:         equ    6                                         ; Special Channel Conversion Bit
; bit position masks
mATDCTL5_CA:        equ    %00000001
mATDCTL5_CB:        equ    %00000010
mATDCTL5_CC:        equ    %00000100
mATDCTL5_CD:        equ    %00001000
mATDCTL5_MULT:      equ    %00010000
mATDCTL5_SCAN:      equ    %00100000
mATDCTL5_SC:        equ    %01000000


;*** ATDSTAT0 - ATD  Status Register 0; 0x00000076 ***
ATDSTAT0:           equ    $00000076                                ;*** ATDSTAT0 - ATD  Status Register 0; 0x00000076 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDSTAT0_CC0:       equ    0                                         ; Conversion Counter 0
ATDSTAT0_CC1:       equ    1                                         ; Conversion Counter 1
ATDSTAT0_CC2:       equ    2                                         ; Conversion Counter 2
ATDSTAT0_CC3:       equ    3                                         ; Conversion Counter 3
ATDSTAT0_FIFOR:     equ    4                                         ; FIFO Over Run Flag
ATDSTAT0_ETORF:     equ    5                                         ; External Trigger Overrun Flag
ATDSTAT0_SCF:       equ    7                                         ; Sequence Complete Flag
; bit position masks
mATDSTAT0_CC0:      equ    %00000001
mATDSTAT0_CC1:      equ    %00000010
mATDSTAT0_CC2:      equ    %00000100
mATDSTAT0_CC3:      equ    %00001000
mATDSTAT0_FIFOR:    equ    %00010000
mATDSTAT0_ETORF:    equ    %00100000
mATDSTAT0_SCF:      equ    %10000000


;*** ATDCMPE - ATD  Compare Enable Register; 0x00000078 ***
ATDCMPE:            equ    $00000078                                ;*** ATDCMPE - ATD  Compare Enable Register; 0x00000078 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDCMPE_CMPE0:      equ    0                                         ; Compare Enable for Conversion Number 0 of a Sequence
ATDCMPE_CMPE1:      equ    1                                         ; Compare Enable for Conversion Number 1 of a Sequence
ATDCMPE_CMPE2:      equ    2                                         ; Compare Enable for Conversion Number 2 of a Sequence
ATDCMPE_CMPE3:      equ    3                                         ; Compare Enable for Conversion Number 3 of a Sequence
ATDCMPE_CMPE4:      equ    4                                         ; Compare Enable for Conversion Number 4 of a Sequence
ATDCMPE_CMPE5:      equ    5                                         ; Compare Enable for Conversion Number 5 of a Sequence
ATDCMPE_CMPE6:      equ    6                                         ; Compare Enable for Conversion Number 6 of a Sequence
ATDCMPE_CMPE7:      equ    7                                         ; Compare Enable for Conversion Number 7 of a Sequence
; bit position masks
mATDCMPE_CMPE0:     equ    %00000001
mATDCMPE_CMPE1:     equ    %00000010
mATDCMPE_CMPE2:     equ    %00000100
mATDCMPE_CMPE3:     equ    %00001000
mATDCMPE_CMPE4:     equ    %00010000
mATDCMPE_CMPE5:     equ    %00100000
mATDCMPE_CMPE6:     equ    %01000000
mATDCMPE_CMPE7:     equ    %10000000


;*** ATDCMPEH - ATD  Compare Enable Register High; 0x00000078 ***
ATDCMPEH:           equ    $00000078                                ;*** ATDCMPEH - ATD  Compare Enable Register High; 0x00000078 ***


;*** ATDCMPEL - ATD  Compare Enable Register Low; 0x00000079 ***
ATDCMPEL:           equ    $00000079                                ;*** ATDCMPEL - ATD  Compare Enable Register Low; 0x00000079 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDCMPEL_CMPE0:     equ    0                                         ; Compare Enable for Conversion Number 0 of a Sequence
ATDCMPEL_CMPE1:     equ    1                                         ; Compare Enable for Conversion Number 1 of a Sequence
ATDCMPEL_CMPE2:     equ    2                                         ; Compare Enable for Conversion Number 2 of a Sequence
ATDCMPEL_CMPE3:     equ    3                                         ; Compare Enable for Conversion Number 3 of a Sequence
ATDCMPEL_CMPE4:     equ    4                                         ; Compare Enable for Conversion Number 4 of a Sequence
ATDCMPEL_CMPE5:     equ    5                                         ; Compare Enable for Conversion Number 5 of a Sequence
ATDCMPEL_CMPE6:     equ    6                                         ; Compare Enable for Conversion Number 6 of a Sequence
ATDCMPEL_CMPE7:     equ    7                                         ; Compare Enable for Conversion Number 7 of a Sequence
; bit position masks
mATDCMPEL_CMPE0:    equ    %00000001
mATDCMPEL_CMPE1:    equ    %00000010
mATDCMPEL_CMPE2:    equ    %00000100
mATDCMPEL_CMPE3:    equ    %00001000
mATDCMPEL_CMPE4:    equ    %00010000
mATDCMPEL_CMPE5:    equ    %00100000
mATDCMPEL_CMPE6:    equ    %01000000
mATDCMPEL_CMPE7:    equ    %10000000


;*** ATDSTAT2 - ATD  Status Register 2; 0x0000007A ***
ATDSTAT2:           equ    $0000007A                                ;*** ATDSTAT2 - ATD  Status Register 2; 0x0000007A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDSTAT2_CCF0:      equ    0                                         ; Conversion Complete Flag 0
ATDSTAT2_CCF1:      equ    1                                         ; Conversion Complete Flag 1
ATDSTAT2_CCF2:      equ    2                                         ; Conversion Complete Flag 2
ATDSTAT2_CCF3:      equ    3                                         ; Conversion Complete Flag 3
ATDSTAT2_CCF4:      equ    4                                         ; Conversion Complete Flag 4
ATDSTAT2_CCF5:      equ    5                                         ; Conversion Complete Flag 5
ATDSTAT2_CCF6:      equ    6                                         ; Conversion Complete Flag 6
ATDSTAT2_CCF7:      equ    7                                         ; Conversion Complete Flag 7
; bit position masks
mATDSTAT2_CCF0:     equ    %00000001
mATDSTAT2_CCF1:     equ    %00000010
mATDSTAT2_CCF2:     equ    %00000100
mATDSTAT2_CCF3:     equ    %00001000
mATDSTAT2_CCF4:     equ    %00010000
mATDSTAT2_CCF5:     equ    %00100000
mATDSTAT2_CCF6:     equ    %01000000
mATDSTAT2_CCF7:     equ    %10000000


;*** ATDSTAT2H - ATD  Status Register 2 High; 0x0000007A ***
ATDSTAT2H:          equ    $0000007A                                ;*** ATDSTAT2H - ATD  Status Register 2 High; 0x0000007A ***


;*** ATDSTAT2L - ATD  Status Register 2 Low; 0x0000007B ***
ATDSTAT2L:          equ    $0000007B                                ;*** ATDSTAT2L - ATD  Status Register 2 Low; 0x0000007B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDSTAT2L_CCF0:     equ    0                                         ; Conversion Complete Flag 0
ATDSTAT2L_CCF1:     equ    1                                         ; Conversion Complete Flag 1
ATDSTAT2L_CCF2:     equ    2                                         ; Conversion Complete Flag 2
ATDSTAT2L_CCF3:     equ    3                                         ; Conversion Complete Flag 3
ATDSTAT2L_CCF4:     equ    4                                         ; Conversion Complete Flag 4
ATDSTAT2L_CCF5:     equ    5                                         ; Conversion Complete Flag 5
ATDSTAT2L_CCF6:     equ    6                                         ; Conversion Complete Flag 6
ATDSTAT2L_CCF7:     equ    7                                         ; Conversion Complete Flag 7
; bit position masks
mATDSTAT2L_CCF0:    equ    %00000001
mATDSTAT2L_CCF1:    equ    %00000010
mATDSTAT2L_CCF2:    equ    %00000100
mATDSTAT2L_CCF3:    equ    %00001000
mATDSTAT2L_CCF4:    equ    %00010000
mATDSTAT2L_CCF5:    equ    %00100000
mATDSTAT2L_CCF6:    equ    %01000000
mATDSTAT2L_CCF7:    equ    %10000000


;*** ATDDIEN - ATD  Input Enable Register; 0x0000007C ***
ATDDIEN:            equ    $0000007C                                ;*** ATDDIEN - ATD  Input Enable Register; 0x0000007C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDIEN_IEN0:       equ    0                                         ; ATD Digital Input Enable on channel 0
ATDDIEN_IEN1:       equ    1                                         ; ATD Digital Input Enable on channel 1
ATDDIEN_IEN2:       equ    2                                         ; ATD Digital Input Enable on channel 2
ATDDIEN_IEN3:       equ    3                                         ; ATD Digital Input Enable on channel 3
ATDDIEN_IEN4:       equ    4                                         ; ATD Digital Input Enable on channel 4
ATDDIEN_IEN5:       equ    5                                         ; ATD Digital Input Enable on channel 5
ATDDIEN_IEN6:       equ    6                                         ; ATD Digital Input Enable on channel 6
ATDDIEN_IEN7:       equ    7                                         ; ATD Digital Input Enable on channel 7
; bit position masks
mATDDIEN_IEN0:      equ    %00000001
mATDDIEN_IEN1:      equ    %00000010
mATDDIEN_IEN2:      equ    %00000100
mATDDIEN_IEN3:      equ    %00001000
mATDDIEN_IEN4:      equ    %00010000
mATDDIEN_IEN5:      equ    %00100000
mATDDIEN_IEN6:      equ    %01000000
mATDDIEN_IEN7:      equ    %10000000


;*** ATDDIENH - ATD  Input Enable Register High; 0x0000007C ***
ATDDIENH:           equ    $0000007C                                ;*** ATDDIENH - ATD  Input Enable Register High; 0x0000007C ***


;*** ATDDIENL - ATD  Input Enable Register Low; 0x0000007D ***
ATDDIENL:           equ    $0000007D                                ;*** ATDDIENL - ATD  Input Enable Register Low; 0x0000007D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDIENL_IEN0:      equ    0                                         ; ATD Digital Input Enable on channel 0
ATDDIENL_IEN1:      equ    1                                         ; ATD Digital Input Enable on channel 1
ATDDIENL_IEN2:      equ    2                                         ; ATD Digital Input Enable on channel 2
ATDDIENL_IEN3:      equ    3                                         ; ATD Digital Input Enable on channel 3
ATDDIENL_IEN4:      equ    4                                         ; ATD Digital Input Enable on channel 4
ATDDIENL_IEN5:      equ    5                                         ; ATD Digital Input Enable on channel 5
ATDDIENL_IEN6:      equ    6                                         ; ATD Digital Input Enable on channel 6
ATDDIENL_IEN7:      equ    7                                         ; ATD Digital Input Enable on channel 7
; bit position masks
mATDDIENL_IEN0:     equ    %00000001
mATDDIENL_IEN1:     equ    %00000010
mATDDIENL_IEN2:     equ    %00000100
mATDDIENL_IEN3:     equ    %00001000
mATDDIENL_IEN4:     equ    %00010000
mATDDIENL_IEN5:     equ    %00100000
mATDDIENL_IEN6:     equ    %01000000
mATDDIENL_IEN7:     equ    %10000000


;*** ATDCMPHT - ATD  Compare Higher Than Register; 0x0000007E ***
ATDCMPHT:           equ    $0000007E                                ;*** ATDCMPHT - ATD  Compare Higher Than Register; 0x0000007E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDCMPHT_CMPHT0:    equ    0                                         ; Compare Operation Higher Than Enable for Conversion Number 0 of a Sequence
ATDCMPHT_CMPHT1:    equ    1                                         ; Compare Operation Higher Than Enable for Conversion Number 1 of a Sequence
ATDCMPHT_CMPHT2:    equ    2                                         ; Compare Operation Higher Than Enable for Conversion Number 2 of a Sequence
ATDCMPHT_CMPHT3:    equ    3                                         ; Compare Operation Higher Than Enable for Conversion Number 3 of a Sequence
ATDCMPHT_CMPHT4:    equ    4                                         ; Compare Operation Higher Than Enable for Conversion Number 4 of a Sequence
ATDCMPHT_CMPHT5:    equ    5                                         ; Compare Operation Higher Than Enable for Conversion Number 5 of a Sequence
ATDCMPHT_CMPHT6:    equ    6                                         ; Compare Operation Higher Than Enable for Conversion Number 6 of a Sequence
ATDCMPHT_CMPHT7:    equ    7                                         ; Compare Operation Higher Than Enable for Conversion Number 7 of a Sequence
; bit position masks
mATDCMPHT_CMPHT0:   equ    %00000001
mATDCMPHT_CMPHT1:   equ    %00000010
mATDCMPHT_CMPHT2:   equ    %00000100
mATDCMPHT_CMPHT3:   equ    %00001000
mATDCMPHT_CMPHT4:   equ    %00010000
mATDCMPHT_CMPHT5:   equ    %00100000
mATDCMPHT_CMPHT6:   equ    %01000000
mATDCMPHT_CMPHT7:   equ    %10000000


;*** ATDCMPHTH - ATD  Compare Higher Than Register High; 0x0000007E ***
ATDCMPHTH:          equ    $0000007E                                ;*** ATDCMPHTH - ATD  Compare Higher Than Register High; 0x0000007E ***


;*** ATDCMPHTL - ATD  Compare Higher Than Register Low; 0x0000007F ***
ATDCMPHTL:          equ    $0000007F                                ;*** ATDCMPHTL - ATD  Compare Higher Than Register Low; 0x0000007F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDCMPHTL_CMPHT0:   equ    0                                         ; Compare Operation Higher Than Enable for Conversion Number 0 of a Sequence
ATDCMPHTL_CMPHT1:   equ    1                                         ; Compare Operation Higher Than Enable for Conversion Number 1 of a Sequence
ATDCMPHTL_CMPHT2:   equ    2                                         ; Compare Operation Higher Than Enable for Conversion Number 2 of a Sequence
ATDCMPHTL_CMPHT3:   equ    3                                         ; Compare Operation Higher Than Enable for Conversion Number 3 of a Sequence
ATDCMPHTL_CMPHT4:   equ    4                                         ; Compare Operation Higher Than Enable for Conversion Number 4 of a Sequence
ATDCMPHTL_CMPHT5:   equ    5                                         ; Compare Operation Higher Than Enable for Conversion Number 5 of a Sequence
ATDCMPHTL_CMPHT6:   equ    6                                         ; Compare Operation Higher Than Enable for Conversion Number 6 of a Sequence
ATDCMPHTL_CMPHT7:   equ    7                                         ; Compare Operation Higher Than Enable for Conversion Number 7 of a Sequence
; bit position masks
mATDCMPHTL_CMPHT0:  equ    %00000001
mATDCMPHTL_CMPHT1:  equ    %00000010
mATDCMPHTL_CMPHT2:  equ    %00000100
mATDCMPHTL_CMPHT3:  equ    %00001000
mATDCMPHTL_CMPHT4:  equ    %00010000
mATDCMPHTL_CMPHT5:  equ    %00100000
mATDCMPHTL_CMPHT6:  equ    %01000000
mATDCMPHTL_CMPHT7:  equ    %10000000


;*** ATDDR0 - ATD  Conversion Result Register 0; 0x00000080 ***
ATDDR0:             equ    $00000080                                ;*** ATDDR0 - ATD  Conversion Result Register 0; 0x00000080 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR0_BIT0:        equ    0                                         ; Bit 0
ATDDR0_BIT1:        equ    1                                         ; Bit 1
ATDDR0_BIT2:        equ    2                                         ; Bit 2
ATDDR0_BIT3:        equ    3                                         ; Bit 3
ATDDR0_BIT4:        equ    4                                         ; Bit 4
ATDDR0_BIT5:        equ    5                                         ; Bit 5
ATDDR0_BIT6:        equ    6                                         ; Bit 6
ATDDR0_BIT7:        equ    7                                         ; Bit 7
ATDDR0_BIT8:        equ    8                                         ; Bit 8
ATDDR0_BIT9:        equ    9                                         ; Bit 9
ATDDR0_BIT10:       equ    10                                        ; Bit 10
ATDDR0_BIT11:       equ    11                                        ; Bit 11
ATDDR0_BIT12:       equ    12                                        ; Bit 12
ATDDR0_BIT13:       equ    13                                        ; Bit 13
ATDDR0_BIT14:       equ    14                                        ; Bit 14
ATDDR0_BIT15:       equ    15                                        ; Bit 15
; bit position masks
mATDDR0_BIT0:       equ    %00000001
mATDDR0_BIT1:       equ    %00000010
mATDDR0_BIT2:       equ    %00000100
mATDDR0_BIT3:       equ    %00001000
mATDDR0_BIT4:       equ    %00010000
mATDDR0_BIT5:       equ    %00100000
mATDDR0_BIT6:       equ    %01000000
mATDDR0_BIT7:       equ    %10000000
mATDDR0_BIT8:       equ    %100000000
mATDDR0_BIT9:       equ    %1000000000
mATDDR0_BIT10:      equ    %10000000000
mATDDR0_BIT11:      equ    %100000000000
mATDDR0_BIT12:      equ    %1000000000000
mATDDR0_BIT13:      equ    %10000000000000
mATDDR0_BIT14:      equ    %100000000000000
mATDDR0_BIT15:      equ    %1000000000000000


;*** ATDDR0H - ATD  Conversion Result Register 0 High; 0x00000080 ***
ATDDR0H:            equ    $00000080                                ;*** ATDDR0H - ATD  Conversion Result Register 0 High; 0x00000080 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR0H_BIT8:       equ    0                                         ; Bit 8
ATDDR0H_BIT9:       equ    1                                         ; Bit 9
ATDDR0H_BIT10:      equ    2                                         ; Bit 10
ATDDR0H_BIT11:      equ    3                                         ; Bit 11
ATDDR0H_BIT12:      equ    4                                         ; Bit 12
ATDDR0H_BIT13:      equ    5                                         ; Bit 13
ATDDR0H_BIT14:      equ    6                                         ; Bit 14
ATDDR0H_BIT15:      equ    7                                         ; Bit 15
; bit position masks
mATDDR0H_BIT8:      equ    %00000001
mATDDR0H_BIT9:      equ    %00000010
mATDDR0H_BIT10:     equ    %00000100
mATDDR0H_BIT11:     equ    %00001000
mATDDR0H_BIT12:     equ    %00010000
mATDDR0H_BIT13:     equ    %00100000
mATDDR0H_BIT14:     equ    %01000000
mATDDR0H_BIT15:     equ    %10000000


;*** ATDDR0L - ATD  Conversion Result Register 0 Low; 0x00000081 ***
ATDDR0L:            equ    $00000081                                ;*** ATDDR0L - ATD  Conversion Result Register 0 Low; 0x00000081 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR0L_BIT0:       equ    0                                         ; Bit 0
ATDDR0L_BIT1:       equ    1                                         ; Bit 1
ATDDR0L_BIT2:       equ    2                                         ; Bit 2
ATDDR0L_BIT3:       equ    3                                         ; Bit 3
ATDDR0L_BIT4:       equ    4                                         ; Bit 4
ATDDR0L_BIT5:       equ    5                                         ; Bit 5
ATDDR0L_BIT6:       equ    6                                         ; Bit 6
ATDDR0L_BIT7:       equ    7                                         ; Bit 7
; bit position masks
mATDDR0L_BIT0:      equ    %00000001
mATDDR0L_BIT1:      equ    %00000010
mATDDR0L_BIT2:      equ    %00000100
mATDDR0L_BIT3:      equ    %00001000
mATDDR0L_BIT4:      equ    %00010000
mATDDR0L_BIT5:      equ    %00100000
mATDDR0L_BIT6:      equ    %01000000
mATDDR0L_BIT7:      equ    %10000000


;*** ATDDR1 - ATD  Conversion Result Register 1; 0x00000082 ***
ATDDR1:             equ    $00000082                                ;*** ATDDR1 - ATD  Conversion Result Register 1; 0x00000082 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR1_BIT0:        equ    0                                         ; Bit 0
ATDDR1_BIT1:        equ    1                                         ; Bit 1
ATDDR1_BIT2:        equ    2                                         ; Bit 2
ATDDR1_BIT3:        equ    3                                         ; Bit 3
ATDDR1_BIT4:        equ    4                                         ; Bit 4
ATDDR1_BIT5:        equ    5                                         ; Bit 5
ATDDR1_BIT6:        equ    6                                         ; Bit 6
ATDDR1_BIT7:        equ    7                                         ; Bit 7
ATDDR1_BIT8:        equ    8                                         ; Bit 8
ATDDR1_BIT9:        equ    9                                         ; Bit 9
ATDDR1_BIT10:       equ    10                                        ; Bit 10
ATDDR1_BIT11:       equ    11                                        ; Bit 11
ATDDR1_BIT12:       equ    12                                        ; Bit 12
ATDDR1_BIT13:       equ    13                                        ; Bit 13
ATDDR1_BIT14:       equ    14                                        ; Bit 14
ATDDR1_BIT15:       equ    15                                        ; Bit 15
; bit position masks
mATDDR1_BIT0:       equ    %00000001
mATDDR1_BIT1:       equ    %00000010
mATDDR1_BIT2:       equ    %00000100
mATDDR1_BIT3:       equ    %00001000
mATDDR1_BIT4:       equ    %00010000
mATDDR1_BIT5:       equ    %00100000
mATDDR1_BIT6:       equ    %01000000
mATDDR1_BIT7:       equ    %10000000
mATDDR1_BIT8:       equ    %100000000
mATDDR1_BIT9:       equ    %1000000000
mATDDR1_BIT10:      equ    %10000000000
mATDDR1_BIT11:      equ    %100000000000
mATDDR1_BIT12:      equ    %1000000000000
mATDDR1_BIT13:      equ    %10000000000000
mATDDR1_BIT14:      equ    %100000000000000
mATDDR1_BIT15:      equ    %1000000000000000


;*** ATDDR1H - ATD  Conversion Result Register 1 High; 0x00000082 ***
ATDDR1H:            equ    $00000082                                ;*** ATDDR1H - ATD  Conversion Result Register 1 High; 0x00000082 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR1H_BIT8:       equ    0                                         ; Bit 8
ATDDR1H_BIT9:       equ    1                                         ; Bit 9
ATDDR1H_BIT10:      equ    2                                         ; Bit 10
ATDDR1H_BIT11:      equ    3                                         ; Bit 11
ATDDR1H_BIT12:      equ    4                                         ; Bit 12
ATDDR1H_BIT13:      equ    5                                         ; Bit 13
ATDDR1H_BIT14:      equ    6                                         ; Bit 14
ATDDR1H_BIT15:      equ    7                                         ; Bit 15
; bit position masks
mATDDR1H_BIT8:      equ    %00000001
mATDDR1H_BIT9:      equ    %00000010
mATDDR1H_BIT10:     equ    %00000100
mATDDR1H_BIT11:     equ    %00001000
mATDDR1H_BIT12:     equ    %00010000
mATDDR1H_BIT13:     equ    %00100000
mATDDR1H_BIT14:     equ    %01000000
mATDDR1H_BIT15:     equ    %10000000


;*** ATDDR1L - ATD  Conversion Result Register 1 Low; 0x00000083 ***
ATDDR1L:            equ    $00000083                                ;*** ATDDR1L - ATD  Conversion Result Register 1 Low; 0x00000083 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR1L_BIT0:       equ    0                                         ; Bit 0
ATDDR1L_BIT1:       equ    1                                         ; Bit 1
ATDDR1L_BIT2:       equ    2                                         ; Bit 2
ATDDR1L_BIT3:       equ    3                                         ; Bit 3
ATDDR1L_BIT4:       equ    4                                         ; Bit 4
ATDDR1L_BIT5:       equ    5                                         ; Bit 5
ATDDR1L_BIT6:       equ    6                                         ; Bit 6
ATDDR1L_BIT7:       equ    7                                         ; Bit 7
; bit position masks
mATDDR1L_BIT0:      equ    %00000001
mATDDR1L_BIT1:      equ    %00000010
mATDDR1L_BIT2:      equ    %00000100
mATDDR1L_BIT3:      equ    %00001000
mATDDR1L_BIT4:      equ    %00010000
mATDDR1L_BIT5:      equ    %00100000
mATDDR1L_BIT6:      equ    %01000000
mATDDR1L_BIT7:      equ    %10000000


;*** ATDDR2 - ATD  Conversion Result Register 2; 0x00000084 ***
ATDDR2:             equ    $00000084                                ;*** ATDDR2 - ATD  Conversion Result Register 2; 0x00000084 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR2_BIT0:        equ    0                                         ; Bit 0
ATDDR2_BIT1:        equ    1                                         ; Bit 1
ATDDR2_BIT2:        equ    2                                         ; Bit 2
ATDDR2_BIT3:        equ    3                                         ; Bit 3
ATDDR2_BIT4:        equ    4                                         ; Bit 4
ATDDR2_BIT5:        equ    5                                         ; Bit 5
ATDDR2_BIT6:        equ    6                                         ; Bit 6
ATDDR2_BIT7:        equ    7                                         ; Bit 7
ATDDR2_BIT8:        equ    8                                         ; Bit 8
ATDDR2_BIT9:        equ    9                                         ; Bit 9
ATDDR2_BIT10:       equ    10                                        ; Bit 10
ATDDR2_BIT11:       equ    11                                        ; Bit 11
ATDDR2_BIT12:       equ    12                                        ; Bit 12
ATDDR2_BIT13:       equ    13                                        ; Bit 13
ATDDR2_BIT14:       equ    14                                        ; Bit 14
ATDDR2_BIT15:       equ    15                                        ; Bit 15
; bit position masks
mATDDR2_BIT0:       equ    %00000001
mATDDR2_BIT1:       equ    %00000010
mATDDR2_BIT2:       equ    %00000100
mATDDR2_BIT3:       equ    %00001000
mATDDR2_BIT4:       equ    %00010000
mATDDR2_BIT5:       equ    %00100000
mATDDR2_BIT6:       equ    %01000000
mATDDR2_BIT7:       equ    %10000000
mATDDR2_BIT8:       equ    %100000000
mATDDR2_BIT9:       equ    %1000000000
mATDDR2_BIT10:      equ    %10000000000
mATDDR2_BIT11:      equ    %100000000000
mATDDR2_BIT12:      equ    %1000000000000
mATDDR2_BIT13:      equ    %10000000000000
mATDDR2_BIT14:      equ    %100000000000000
mATDDR2_BIT15:      equ    %1000000000000000


;*** ATDDR2H - ATD  Conversion Result Register 2 High; 0x00000084 ***
ATDDR2H:            equ    $00000084                                ;*** ATDDR2H - ATD  Conversion Result Register 2 High; 0x00000084 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR2H_BIT8:       equ    0                                         ; Bit 8
ATDDR2H_BIT9:       equ    1                                         ; Bit 9
ATDDR2H_BIT10:      equ    2                                         ; Bit 10
ATDDR2H_BIT11:      equ    3                                         ; Bit 11
ATDDR2H_BIT12:      equ    4                                         ; Bit 12
ATDDR2H_BIT13:      equ    5                                         ; Bit 13
ATDDR2H_BIT14:      equ    6                                         ; Bit 14
ATDDR2H_BIT15:      equ    7                                         ; Bit 15
; bit position masks
mATDDR2H_BIT8:      equ    %00000001
mATDDR2H_BIT9:      equ    %00000010
mATDDR2H_BIT10:     equ    %00000100
mATDDR2H_BIT11:     equ    %00001000
mATDDR2H_BIT12:     equ    %00010000
mATDDR2H_BIT13:     equ    %00100000
mATDDR2H_BIT14:     equ    %01000000
mATDDR2H_BIT15:     equ    %10000000


;*** ATDDR2L - ATD  Conversion Result Register 2 Low; 0x00000085 ***
ATDDR2L:            equ    $00000085                                ;*** ATDDR2L - ATD  Conversion Result Register 2 Low; 0x00000085 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR2L_BIT0:       equ    0                                         ; Bit 0
ATDDR2L_BIT1:       equ    1                                         ; Bit 1
ATDDR2L_BIT2:       equ    2                                         ; Bit 2
ATDDR2L_BIT3:       equ    3                                         ; Bit 3
ATDDR2L_BIT4:       equ    4                                         ; Bit 4
ATDDR2L_BIT5:       equ    5                                         ; Bit 5
ATDDR2L_BIT6:       equ    6                                         ; Bit 6
ATDDR2L_BIT7:       equ    7                                         ; Bit 7
; bit position masks
mATDDR2L_BIT0:      equ    %00000001
mATDDR2L_BIT1:      equ    %00000010
mATDDR2L_BIT2:      equ    %00000100
mATDDR2L_BIT3:      equ    %00001000
mATDDR2L_BIT4:      equ    %00010000
mATDDR2L_BIT5:      equ    %00100000
mATDDR2L_BIT6:      equ    %01000000
mATDDR2L_BIT7:      equ    %10000000


;*** ATDDR3 - ATD  Conversion Result Register 3; 0x00000086 ***
ATDDR3:             equ    $00000086                                ;*** ATDDR3 - ATD  Conversion Result Register 3; 0x00000086 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR3_BIT0:        equ    0                                         ; Bit 0
ATDDR3_BIT1:        equ    1                                         ; Bit 1
ATDDR3_BIT2:        equ    2                                         ; Bit 2
ATDDR3_BIT3:        equ    3                                         ; Bit 3
ATDDR3_BIT4:        equ    4                                         ; Bit 4
ATDDR3_BIT5:        equ    5                                         ; Bit 5
ATDDR3_BIT6:        equ    6                                         ; Bit 6
ATDDR3_BIT7:        equ    7                                         ; Bit 7
ATDDR3_BIT8:        equ    8                                         ; Bit 8
ATDDR3_BIT9:        equ    9                                         ; Bit 9
ATDDR3_BIT10:       equ    10                                        ; Bit 10
ATDDR3_BIT11:       equ    11                                        ; Bit 11
ATDDR3_BIT12:       equ    12                                        ; Bit 12
ATDDR3_BIT13:       equ    13                                        ; Bit 13
ATDDR3_BIT14:       equ    14                                        ; Bit 14
ATDDR3_BIT15:       equ    15                                        ; Bit 15
; bit position masks
mATDDR3_BIT0:       equ    %00000001
mATDDR3_BIT1:       equ    %00000010
mATDDR3_BIT2:       equ    %00000100
mATDDR3_BIT3:       equ    %00001000
mATDDR3_BIT4:       equ    %00010000
mATDDR3_BIT5:       equ    %00100000
mATDDR3_BIT6:       equ    %01000000
mATDDR3_BIT7:       equ    %10000000
mATDDR3_BIT8:       equ    %100000000
mATDDR3_BIT9:       equ    %1000000000
mATDDR3_BIT10:      equ    %10000000000
mATDDR3_BIT11:      equ    %100000000000
mATDDR3_BIT12:      equ    %1000000000000
mATDDR3_BIT13:      equ    %10000000000000
mATDDR3_BIT14:      equ    %100000000000000
mATDDR3_BIT15:      equ    %1000000000000000


;*** ATDDR3H - ATD  Conversion Result Register 3 High; 0x00000086 ***
ATDDR3H:            equ    $00000086                                ;*** ATDDR3H - ATD  Conversion Result Register 3 High; 0x00000086 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR3H_BIT8:       equ    0                                         ; Bit 8
ATDDR3H_BIT9:       equ    1                                         ; Bit 9
ATDDR3H_BIT10:      equ    2                                         ; Bit 10
ATDDR3H_BIT11:      equ    3                                         ; Bit 11
ATDDR3H_BIT12:      equ    4                                         ; Bit 12
ATDDR3H_BIT13:      equ    5                                         ; Bit 13
ATDDR3H_BIT14:      equ    6                                         ; Bit 14
ATDDR3H_BIT15:      equ    7                                         ; Bit 15
; bit position masks
mATDDR3H_BIT8:      equ    %00000001
mATDDR3H_BIT9:      equ    %00000010
mATDDR3H_BIT10:     equ    %00000100
mATDDR3H_BIT11:     equ    %00001000
mATDDR3H_BIT12:     equ    %00010000
mATDDR3H_BIT13:     equ    %00100000
mATDDR3H_BIT14:     equ    %01000000
mATDDR3H_BIT15:     equ    %10000000


;*** ATDDR3L - ATD  Conversion Result Register 3 Low; 0x00000087 ***
ATDDR3L:            equ    $00000087                                ;*** ATDDR3L - ATD  Conversion Result Register 3 Low; 0x00000087 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR3L_BIT0:       equ    0                                         ; Bit 0
ATDDR3L_BIT1:       equ    1                                         ; Bit 1
ATDDR3L_BIT2:       equ    2                                         ; Bit 2
ATDDR3L_BIT3:       equ    3                                         ; Bit 3
ATDDR3L_BIT4:       equ    4                                         ; Bit 4
ATDDR3L_BIT5:       equ    5                                         ; Bit 5
ATDDR3L_BIT6:       equ    6                                         ; Bit 6
ATDDR3L_BIT7:       equ    7                                         ; Bit 7
; bit position masks
mATDDR3L_BIT0:      equ    %00000001
mATDDR3L_BIT1:      equ    %00000010
mATDDR3L_BIT2:      equ    %00000100
mATDDR3L_BIT3:      equ    %00001000
mATDDR3L_BIT4:      equ    %00010000
mATDDR3L_BIT5:      equ    %00100000
mATDDR3L_BIT6:      equ    %01000000
mATDDR3L_BIT7:      equ    %10000000


;*** ATDDR4 - ATD  Conversion Result Register 4; 0x00000088 ***
ATDDR4:             equ    $00000088                                ;*** ATDDR4 - ATD  Conversion Result Register 4; 0x00000088 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR4_BIT0:        equ    0                                         ; Bit 0
ATDDR4_BIT1:        equ    1                                         ; Bit 1
ATDDR4_BIT2:        equ    2                                         ; Bit 2
ATDDR4_BIT3:        equ    3                                         ; Bit 3
ATDDR4_BIT4:        equ    4                                         ; Bit 4
ATDDR4_BIT5:        equ    5                                         ; Bit 5
ATDDR4_BIT6:        equ    6                                         ; Bit 6
ATDDR4_BIT7:        equ    7                                         ; Bit 7
ATDDR4_BIT8:        equ    8                                         ; Bit 8
ATDDR4_BIT9:        equ    9                                         ; Bit 9
ATDDR4_BIT10:       equ    10                                        ; Bit 10
ATDDR4_BIT11:       equ    11                                        ; Bit 11
ATDDR4_BIT12:       equ    12                                        ; Bit 12
ATDDR4_BIT13:       equ    13                                        ; Bit 13
ATDDR4_BIT14:       equ    14                                        ; Bit 14
ATDDR4_BIT15:       equ    15                                        ; Bit 15
; bit position masks
mATDDR4_BIT0:       equ    %00000001
mATDDR4_BIT1:       equ    %00000010
mATDDR4_BIT2:       equ    %00000100
mATDDR4_BIT3:       equ    %00001000
mATDDR4_BIT4:       equ    %00010000
mATDDR4_BIT5:       equ    %00100000
mATDDR4_BIT6:       equ    %01000000
mATDDR4_BIT7:       equ    %10000000
mATDDR4_BIT8:       equ    %100000000
mATDDR4_BIT9:       equ    %1000000000
mATDDR4_BIT10:      equ    %10000000000
mATDDR4_BIT11:      equ    %100000000000
mATDDR4_BIT12:      equ    %1000000000000
mATDDR4_BIT13:      equ    %10000000000000
mATDDR4_BIT14:      equ    %100000000000000
mATDDR4_BIT15:      equ    %1000000000000000


;*** ATDDR4H - ATD  Conversion Result Register 4 High; 0x00000088 ***
ATDDR4H:            equ    $00000088                                ;*** ATDDR4H - ATD  Conversion Result Register 4 High; 0x00000088 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR4H_BIT8:       equ    0                                         ; Bit 8
ATDDR4H_BIT9:       equ    1                                         ; Bit 9
ATDDR4H_BIT10:      equ    2                                         ; Bit 10
ATDDR4H_BIT11:      equ    3                                         ; Bit 11
ATDDR4H_BIT12:      equ    4                                         ; Bit 12
ATDDR4H_BIT13:      equ    5                                         ; Bit 13
ATDDR4H_BIT14:      equ    6                                         ; Bit 14
ATDDR4H_BIT15:      equ    7                                         ; Bit 15
; bit position masks
mATDDR4H_BIT8:      equ    %00000001
mATDDR4H_BIT9:      equ    %00000010
mATDDR4H_BIT10:     equ    %00000100
mATDDR4H_BIT11:     equ    %00001000
mATDDR4H_BIT12:     equ    %00010000
mATDDR4H_BIT13:     equ    %00100000
mATDDR4H_BIT14:     equ    %01000000
mATDDR4H_BIT15:     equ    %10000000


;*** ATDDR4L - ATD  Conversion Result Register 4 Low; 0x00000089 ***
ATDDR4L:            equ    $00000089                                ;*** ATDDR4L - ATD  Conversion Result Register 4 Low; 0x00000089 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR4L_BIT0:       equ    0                                         ; Bit 0
ATDDR4L_BIT1:       equ    1                                         ; Bit 1
ATDDR4L_BIT2:       equ    2                                         ; Bit 2
ATDDR4L_BIT3:       equ    3                                         ; Bit 3
ATDDR4L_BIT4:       equ    4                                         ; Bit 4
ATDDR4L_BIT5:       equ    5                                         ; Bit 5
ATDDR4L_BIT6:       equ    6                                         ; Bit 6
ATDDR4L_BIT7:       equ    7                                         ; Bit 7
; bit position masks
mATDDR4L_BIT0:      equ    %00000001
mATDDR4L_BIT1:      equ    %00000010
mATDDR4L_BIT2:      equ    %00000100
mATDDR4L_BIT3:      equ    %00001000
mATDDR4L_BIT4:      equ    %00010000
mATDDR4L_BIT5:      equ    %00100000
mATDDR4L_BIT6:      equ    %01000000
mATDDR4L_BIT7:      equ    %10000000


;*** ATDDR5 - ATD  Conversion Result Register 5; 0x0000008A ***
ATDDR5:             equ    $0000008A                                ;*** ATDDR5 - ATD  Conversion Result Register 5; 0x0000008A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR5_BIT0:        equ    0                                         ; Bit 0
ATDDR5_BIT1:        equ    1                                         ; Bit 1
ATDDR5_BIT2:        equ    2                                         ; Bit 2
ATDDR5_BIT3:        equ    3                                         ; Bit 3
ATDDR5_BIT4:        equ    4                                         ; Bit 4
ATDDR5_BIT5:        equ    5                                         ; Bit 5
ATDDR5_BIT6:        equ    6                                         ; Bit 6
ATDDR5_BIT7:        equ    7                                         ; Bit 7
ATDDR5_BIT8:        equ    8                                         ; Bit 8
ATDDR5_BIT9:        equ    9                                         ; Bit 9
ATDDR5_BIT10:       equ    10                                        ; Bit 10
ATDDR5_BIT11:       equ    11                                        ; Bit 11
ATDDR5_BIT12:       equ    12                                        ; Bit 12
ATDDR5_BIT13:       equ    13                                        ; Bit 13
ATDDR5_BIT14:       equ    14                                        ; Bit 14
ATDDR5_BIT15:       equ    15                                        ; Bit 15
; bit position masks
mATDDR5_BIT0:       equ    %00000001
mATDDR5_BIT1:       equ    %00000010
mATDDR5_BIT2:       equ    %00000100
mATDDR5_BIT3:       equ    %00001000
mATDDR5_BIT4:       equ    %00010000
mATDDR5_BIT5:       equ    %00100000
mATDDR5_BIT6:       equ    %01000000
mATDDR5_BIT7:       equ    %10000000
mATDDR5_BIT8:       equ    %100000000
mATDDR5_BIT9:       equ    %1000000000
mATDDR5_BIT10:      equ    %10000000000
mATDDR5_BIT11:      equ    %100000000000
mATDDR5_BIT12:      equ    %1000000000000
mATDDR5_BIT13:      equ    %10000000000000
mATDDR5_BIT14:      equ    %100000000000000
mATDDR5_BIT15:      equ    %1000000000000000


;*** ATDDR5H - ATD  Conversion Result Register 5 High; 0x0000008A ***
ATDDR5H:            equ    $0000008A                                ;*** ATDDR5H - ATD  Conversion Result Register 5 High; 0x0000008A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR5H_BIT8:       equ    0                                         ; Bit 8
ATDDR5H_BIT9:       equ    1                                         ; Bit 9
ATDDR5H_BIT10:      equ    2                                         ; Bit 10
ATDDR5H_BIT11:      equ    3                                         ; Bit 11
ATDDR5H_BIT12:      equ    4                                         ; Bit 12
ATDDR5H_BIT13:      equ    5                                         ; Bit 13
ATDDR5H_BIT14:      equ    6                                         ; Bit 14
ATDDR5H_BIT15:      equ    7                                         ; Bit 15
; bit position masks
mATDDR5H_BIT8:      equ    %00000001
mATDDR5H_BIT9:      equ    %00000010
mATDDR5H_BIT10:     equ    %00000100
mATDDR5H_BIT11:     equ    %00001000
mATDDR5H_BIT12:     equ    %00010000
mATDDR5H_BIT13:     equ    %00100000
mATDDR5H_BIT14:     equ    %01000000
mATDDR5H_BIT15:     equ    %10000000


;*** ATDDR5L - ATD  Conversion Result Register 5 Low; 0x0000008B ***
ATDDR5L:            equ    $0000008B                                ;*** ATDDR5L - ATD  Conversion Result Register 5 Low; 0x0000008B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR5L_BIT0:       equ    0                                         ; Bit 0
ATDDR5L_BIT1:       equ    1                                         ; Bit 1
ATDDR5L_BIT2:       equ    2                                         ; Bit 2
ATDDR5L_BIT3:       equ    3                                         ; Bit 3
ATDDR5L_BIT4:       equ    4                                         ; Bit 4
ATDDR5L_BIT5:       equ    5                                         ; Bit 5
ATDDR5L_BIT6:       equ    6                                         ; Bit 6
ATDDR5L_BIT7:       equ    7                                         ; Bit 7
; bit position masks
mATDDR5L_BIT0:      equ    %00000001
mATDDR5L_BIT1:      equ    %00000010
mATDDR5L_BIT2:      equ    %00000100
mATDDR5L_BIT3:      equ    %00001000
mATDDR5L_BIT4:      equ    %00010000
mATDDR5L_BIT5:      equ    %00100000
mATDDR5L_BIT6:      equ    %01000000
mATDDR5L_BIT7:      equ    %10000000


;*** ATDDR6 - ATD  Conversion Result Register 6; 0x0000008C ***
ATDDR6:             equ    $0000008C                                ;*** ATDDR6 - ATD  Conversion Result Register 6; 0x0000008C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR6_BIT0:        equ    0                                         ; Bit 0
ATDDR6_BIT1:        equ    1                                         ; Bit 1
ATDDR6_BIT2:        equ    2                                         ; Bit 2
ATDDR6_BIT3:        equ    3                                         ; Bit 3
ATDDR6_BIT4:        equ    4                                         ; Bit 4
ATDDR6_BIT5:        equ    5                                         ; Bit 5
ATDDR6_BIT6:        equ    6                                         ; Bit 6
ATDDR6_BIT7:        equ    7                                         ; Bit 7
ATDDR6_BIT8:        equ    8                                         ; Bit 8
ATDDR6_BIT9:        equ    9                                         ; Bit 9
ATDDR6_BIT10:       equ    10                                        ; Bit 10
ATDDR6_BIT11:       equ    11                                        ; Bit 11
ATDDR6_BIT12:       equ    12                                        ; Bit 12
ATDDR6_BIT13:       equ    13                                        ; Bit 13
ATDDR6_BIT14:       equ    14                                        ; Bit 14
ATDDR6_BIT15:       equ    15                                        ; Bit 15
; bit position masks
mATDDR6_BIT0:       equ    %00000001
mATDDR6_BIT1:       equ    %00000010
mATDDR6_BIT2:       equ    %00000100
mATDDR6_BIT3:       equ    %00001000
mATDDR6_BIT4:       equ    %00010000
mATDDR6_BIT5:       equ    %00100000
mATDDR6_BIT6:       equ    %01000000
mATDDR6_BIT7:       equ    %10000000
mATDDR6_BIT8:       equ    %100000000
mATDDR6_BIT9:       equ    %1000000000
mATDDR6_BIT10:      equ    %10000000000
mATDDR6_BIT11:      equ    %100000000000
mATDDR6_BIT12:      equ    %1000000000000
mATDDR6_BIT13:      equ    %10000000000000
mATDDR6_BIT14:      equ    %100000000000000
mATDDR6_BIT15:      equ    %1000000000000000


;*** ATDDR6H - ATD  Conversion Result Register 6 High; 0x0000008C ***
ATDDR6H:            equ    $0000008C                                ;*** ATDDR6H - ATD  Conversion Result Register 6 High; 0x0000008C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR6H_BIT8:       equ    0                                         ; Bit 8
ATDDR6H_BIT9:       equ    1                                         ; Bit 9
ATDDR6H_BIT10:      equ    2                                         ; Bit 10
ATDDR6H_BIT11:      equ    3                                         ; Bit 11
ATDDR6H_BIT12:      equ    4                                         ; Bit 12
ATDDR6H_BIT13:      equ    5                                         ; Bit 13
ATDDR6H_BIT14:      equ    6                                         ; Bit 14
ATDDR6H_BIT15:      equ    7                                         ; Bit 15
; bit position masks
mATDDR6H_BIT8:      equ    %00000001
mATDDR6H_BIT9:      equ    %00000010
mATDDR6H_BIT10:     equ    %00000100
mATDDR6H_BIT11:     equ    %00001000
mATDDR6H_BIT12:     equ    %00010000
mATDDR6H_BIT13:     equ    %00100000
mATDDR6H_BIT14:     equ    %01000000
mATDDR6H_BIT15:     equ    %10000000


;*** ATDDR6L - ATD  Conversion Result Register 6 Low; 0x0000008D ***
ATDDR6L:            equ    $0000008D                                ;*** ATDDR6L - ATD  Conversion Result Register 6 Low; 0x0000008D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR6L_BIT0:       equ    0                                         ; Bit 0
ATDDR6L_BIT1:       equ    1                                         ; Bit 1
ATDDR6L_BIT2:       equ    2                                         ; Bit 2
ATDDR6L_BIT3:       equ    3                                         ; Bit 3
ATDDR6L_BIT4:       equ    4                                         ; Bit 4
ATDDR6L_BIT5:       equ    5                                         ; Bit 5
ATDDR6L_BIT6:       equ    6                                         ; Bit 6
ATDDR6L_BIT7:       equ    7                                         ; Bit 7
; bit position masks
mATDDR6L_BIT0:      equ    %00000001
mATDDR6L_BIT1:      equ    %00000010
mATDDR6L_BIT2:      equ    %00000100
mATDDR6L_BIT3:      equ    %00001000
mATDDR6L_BIT4:      equ    %00010000
mATDDR6L_BIT5:      equ    %00100000
mATDDR6L_BIT6:      equ    %01000000
mATDDR6L_BIT7:      equ    %10000000


;*** ATDDR7 - ATD  Conversion Result Register 7; 0x0000008E ***
ATDDR7:             equ    $0000008E                                ;*** ATDDR7 - ATD  Conversion Result Register 7; 0x0000008E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR7_BIT0:        equ    0                                         ; Bit 0
ATDDR7_BIT1:        equ    1                                         ; Bit 1
ATDDR7_BIT2:        equ    2                                         ; Bit 2
ATDDR7_BIT3:        equ    3                                         ; Bit 3
ATDDR7_BIT4:        equ    4                                         ; Bit 4
ATDDR7_BIT5:        equ    5                                         ; Bit 5
ATDDR7_BIT6:        equ    6                                         ; Bit 6
ATDDR7_BIT7:        equ    7                                         ; Bit 7
ATDDR7_BIT8:        equ    8                                         ; Bit 8
ATDDR7_BIT9:        equ    9                                         ; Bit 9
ATDDR7_BIT10:       equ    10                                        ; Bit 10
ATDDR7_BIT11:       equ    11                                        ; Bit 11
ATDDR7_BIT12:       equ    12                                        ; Bit 12
ATDDR7_BIT13:       equ    13                                        ; Bit 13
ATDDR7_BIT14:       equ    14                                        ; Bit 14
ATDDR7_BIT15:       equ    15                                        ; Bit 15
; bit position masks
mATDDR7_BIT0:       equ    %00000001
mATDDR7_BIT1:       equ    %00000010
mATDDR7_BIT2:       equ    %00000100
mATDDR7_BIT3:       equ    %00001000
mATDDR7_BIT4:       equ    %00010000
mATDDR7_BIT5:       equ    %00100000
mATDDR7_BIT6:       equ    %01000000
mATDDR7_BIT7:       equ    %10000000
mATDDR7_BIT8:       equ    %100000000
mATDDR7_BIT9:       equ    %1000000000
mATDDR7_BIT10:      equ    %10000000000
mATDDR7_BIT11:      equ    %100000000000
mATDDR7_BIT12:      equ    %1000000000000
mATDDR7_BIT13:      equ    %10000000000000
mATDDR7_BIT14:      equ    %100000000000000
mATDDR7_BIT15:      equ    %1000000000000000


;*** ATDDR7H - ATD  Conversion Result Register 7 High; 0x0000008E ***
ATDDR7H:            equ    $0000008E                                ;*** ATDDR7H - ATD  Conversion Result Register 7 High; 0x0000008E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR7H_BIT8:       equ    0                                         ; Bit 8
ATDDR7H_BIT9:       equ    1                                         ; Bit 9
ATDDR7H_BIT10:      equ    2                                         ; Bit 10
ATDDR7H_BIT11:      equ    3                                         ; Bit 11
ATDDR7H_BIT12:      equ    4                                         ; Bit 12
ATDDR7H_BIT13:      equ    5                                         ; Bit 13
ATDDR7H_BIT14:      equ    6                                         ; Bit 14
ATDDR7H_BIT15:      equ    7                                         ; Bit 15
; bit position masks
mATDDR7H_BIT8:      equ    %00000001
mATDDR7H_BIT9:      equ    %00000010
mATDDR7H_BIT10:     equ    %00000100
mATDDR7H_BIT11:     equ    %00001000
mATDDR7H_BIT12:     equ    %00010000
mATDDR7H_BIT13:     equ    %00100000
mATDDR7H_BIT14:     equ    %01000000
mATDDR7H_BIT15:     equ    %10000000


;*** ATDDR7L - ATD  Conversion Result Register 7 Low; 0x0000008F ***
ATDDR7L:            equ    $0000008F                                ;*** ATDDR7L - ATD  Conversion Result Register 7 Low; 0x0000008F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR7L_BIT0:       equ    0                                         ; Bit 0
ATDDR7L_BIT1:       equ    1                                         ; Bit 1
ATDDR7L_BIT2:       equ    2                                         ; Bit 2
ATDDR7L_BIT3:       equ    3                                         ; Bit 3
ATDDR7L_BIT4:       equ    4                                         ; Bit 4
ATDDR7L_BIT5:       equ    5                                         ; Bit 5
ATDDR7L_BIT6:       equ    6                                         ; Bit 6
ATDDR7L_BIT7:       equ    7                                         ; Bit 7
; bit position masks
mATDDR7L_BIT0:      equ    %00000001
mATDDR7L_BIT1:      equ    %00000010
mATDDR7L_BIT2:      equ    %00000100
mATDDR7L_BIT3:      equ    %00001000
mATDDR7L_BIT4:      equ    %00010000
mATDDR7L_BIT5:      equ    %00100000
mATDDR7L_BIT6:      equ    %01000000
mATDDR7L_BIT7:      equ    %10000000


;*** PWME - PWM Enable Register; 0x000000A0 ***
PWME:               equ    $000000A0                                ;*** PWME - PWM Enable Register; 0x000000A0 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PWME_PWME0:         equ    0                                         ; Pulse Width Channel 0 Enable
PWME_PWME1:         equ    1                                         ; Pulse Width Channel 1 Enable
PWME_PWME2:         equ    2                                         ; Pulse Width Channel 2 Enable
PWME_PWME3:         equ    3                                         ; Pulse Width Channel 3 Enable
PWME_PWME4:         equ    4                                         ; Pulse Width Channel 4 Enable
PWME_PWME5:         equ    5                                         ; Pulse Width Channel 5 Enable
PWME_PWME6:         equ    6                                         ; Pulse Width Channel 6 Enable
PWME_PWME7:         equ    7                                         ; Pulse Width Channel 7 Enable
; bit position masks
mPWME_PWME0:        equ    %00000001
mPWME_PWME1:        equ    %00000010
mPWME_PWME2:        equ    %00000100
mPWME_PWME3:        equ    %00001000
mPWME_PWME4:        equ    %00010000
mPWME_PWME5:        equ    %00100000
mPWME_PWME6:        equ    %01000000
mPWME_PWME7:        equ    %10000000


;*** PWMPOL - PWM Polarity Register; 0x000000A1 ***
PWMPOL:             equ    $000000A1                                ;*** PWMPOL - PWM Polarity Register; 0x000000A1 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PWMPOL_PPOL0:       equ    0                                         ; Pulse Width Channel 0 Polarity
PWMPOL_PPOL1:       equ    1                                         ; Pulse Width Channel 1 Polarity
PWMPOL_PPOL2:       equ    2                                         ; Pulse Width Channel 2 Polarity
PWMPOL_PPOL3:       equ    3                                         ; Pulse Width Channel 3 Polarity
PWMPOL_PPOL4:       equ    4                                         ; Pulse Width Channel 4 Polarity
PWMPOL_PPOL5:       equ    5                                         ; Pulse Width Channel 5 Polarity
PWMPOL_PPOL6:       equ    6                                         ; Pulse Width Channel 6 Polarity
PWMPOL_PPOL7:       equ    7                                         ; Pulse Width Channel 7 Polarity
; bit position masks
mPWMPOL_PPOL0:      equ    %00000001
mPWMPOL_PPOL1:      equ    %00000010
mPWMPOL_PPOL2:      equ    %00000100
mPWMPOL_PPOL3:      equ    %00001000
mPWMPOL_PPOL4:      equ    %00010000
mPWMPOL_PPOL5:      equ    %00100000
mPWMPOL_PPOL6:      equ    %01000000
mPWMPOL_PPOL7:      equ    %10000000


;*** PWMCLK - PWM Clock Select Register; 0x000000A2 ***
PWMCLK:             equ    $000000A2                                ;*** PWMCLK - PWM Clock Select Register; 0x000000A2 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PWMCLK_PCLK0:       equ    0                                         ; Pulse Width Channel 0 Clock Select
PWMCLK_PCLK1:       equ    1                                         ; Pulse Width Channel 1 Clock Select
PWMCLK_PCLK2:       equ    2                                         ; Pulse Width Channel 2 Clock Select
PWMCLK_PCLK3:       equ    3                                         ; Pulse Width Channel 3 Clock Select
PWMCLK_PCLK4:       equ    4                                         ; Pulse Width Channel 4 Clock Select
PWMCLK_PCLK5:       equ    5                                         ; Pulse Width Channel 5 Clock Select
PWMCLK_PCLK6:       equ    6                                         ; Pulse Width Channel 6 Clock Select
PWMCLK_PCLK7:       equ    7                                         ; Pulse Width Channel 7 Clock Select
; bit position masks
mPWMCLK_PCLK0:      equ    %00000001
mPWMCLK_PCLK1:      equ    %00000010
mPWMCLK_PCLK2:      equ    %00000100
mPWMCLK_PCLK3:      equ    %00001000
mPWMCLK_PCLK4:      equ    %00010000
mPWMCLK_PCLK5:      equ    %00100000
mPWMCLK_PCLK6:      equ    %01000000
mPWMCLK_PCLK7:      equ    %10000000


;*** PWMPRCLK - PWM Prescale Clock Select Register; 0x000000A3 ***
PWMPRCLK:           equ    $000000A3                                ;*** PWMPRCLK - PWM Prescale Clock Select Register; 0x000000A3 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PWMPRCLK_PCKA0:     equ    0                                         ; Prescaler Select for Clock A 0
PWMPRCLK_PCKA1:     equ    1                                         ; Prescaler Select for Clock A 1
PWMPRCLK_PCKA2:     equ    2                                         ; Prescaler Select for Clock A 2
PWMPRCLK_PCKB0:     equ    4                                         ; Prescaler Select for Clock B 0
PWMPRCLK_PCKB1:     equ    5                                         ; Prescaler Select for Clock B 1
PWMPRCLK_PCKB2:     equ    6                                         ; Prescaler Select for Clock B 2
; bit position masks
mPWMPRCLK_PCKA0:    equ    %00000001
mPWMPRCLK_PCKA1:    equ    %00000010
mPWMPRCLK_PCKA2:    equ    %00000100
mPWMPRCLK_PCKB0:    equ    %00010000
mPWMPRCLK_PCKB1:    equ    %00100000
mPWMPRCLK_PCKB2:    equ    %01000000


;*** PWMCAE - PWM Center Align Enable Register; 0x000000A4 ***
PWMCAE:             equ    $000000A4                                ;*** PWMCAE - PWM Center Align Enable Register; 0x000000A4 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PWMCAE_CAE0:        equ    0                                         ; Center Aligned Output Mode on channel 0
PWMCAE_CAE1:        equ    1                                         ; Center Aligned Output Mode on channel 1
PWMCAE_CAE2:        equ    2                                         ; Center Aligned Output Mode on channel 2
PWMCAE_CAE3:        equ    3                                         ; Center Aligned Output Mode on channel 3
PWMCAE_CAE4:        equ    4                                         ; Center Aligned Output Mode on channel 4
PWMCAE_CAE5:        equ    5                                         ; Center Aligned Output Mode on channel 5
PWMCAE_CAE6:        equ    6                                         ; Center Aligned Output Mode on channel 6
PWMCAE_CAE7:        equ    7                                         ; Center Aligned Output Mode on channel 7
; bit position masks
mPWMCAE_CAE0:       equ    %00000001
mPWMCAE_CAE1:       equ    %00000010
mPWMCAE_CAE2:       equ    %00000100
mPWMCAE_CAE3:       equ    %00001000
mPWMCAE_CAE4:       equ    %00010000
mPWMCAE_CAE5:       equ    %00100000
mPWMCAE_CAE6:       equ    %01000000
mPWMCAE_CAE7:       equ    %10000000


;*** PWMCTL - PWM Control Register; 0x000000A5 ***
PWMCTL:             equ    $000000A5                                ;*** PWMCTL - PWM Control Register; 0x000000A5 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PWMCTL_PFRZ:        equ    2                                         ; PWM Counters Stop in Freeze Mode
PWMCTL_PSWAI:       equ    3                                         ; PWM Stops in Wait Mode
PWMCTL_CON01:       equ    4                                         ; Concatenate channels 0 and 1
PWMCTL_CON23:       equ    5                                         ; Concatenate channels 2 and 3
PWMCTL_CON45:       equ    6                                         ; Concatenate channels 4 and 5
PWMCTL_CON67:       equ    7                                         ; Concatenate channels 6 and 7
; bit position masks
mPWMCTL_PFRZ:       equ    %00000100
mPWMCTL_PSWAI:      equ    %00001000
mPWMCTL_CON01:      equ    %00010000
mPWMCTL_CON23:      equ    %00100000
mPWMCTL_CON45:      equ    %01000000
mPWMCTL_CON67:      equ    %10000000


;*** PWMSCLA - PWM Scale A Register; 0x000000A8 ***
PWMSCLA:            equ    $000000A8                                ;*** PWMSCLA - PWM Scale A Register; 0x000000A8 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PWMSCLA_BIT0:       equ    0                                         ; PWM Scale A Bit 0
PWMSCLA_BIT1:       equ    1                                         ; PWM Scale A Bit 1
PWMSCLA_BIT2:       equ    2                                         ; PWM Scale A Bit 2
PWMSCLA_BIT3:       equ    3                                         ; PWM Scale A Bit 3
PWMSCLA_BIT4:       equ    4                                         ; PWM Scale A Bit 4
PWMSCLA_BIT5:       equ    5                                         ; PWM Scale A Bit 5
PWMSCLA_BIT6:       equ    6                                         ; PWM Scale A Bit 6
PWMSCLA_BIT7:       equ    7                                         ; PWM Scale A Bit 7
; bit position masks
mPWMSCLA_BIT0:      equ    %00000001
mPWMSCLA_BIT1:      equ    %00000010
mPWMSCLA_BIT2:      equ    %00000100
mPWMSCLA_BIT3:      equ    %00001000
mPWMSCLA_BIT4:      equ    %00010000
mPWMSCLA_BIT5:      equ    %00100000
mPWMSCLA_BIT6:      equ    %01000000
mPWMSCLA_BIT7:      equ    %10000000


;*** PWMSCLB - PWM Scale B Register; 0x000000A9 ***
PWMSCLB:            equ    $000000A9                                ;*** PWMSCLB - PWM Scale B Register; 0x000000A9 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PWMSCLB_BIT0:       equ    0                                         ; PWM Scale B Bit 0
PWMSCLB_BIT1:       equ    1                                         ; PWM Scale B Bit 1
PWMSCLB_BIT2:       equ    2                                         ; PWM Scale B Bit 2
PWMSCLB_BIT3:       equ    3                                         ; PWM Scale B Bit 3
PWMSCLB_BIT4:       equ    4                                         ; PWM Scale B Bit 4
PWMSCLB_BIT5:       equ    5                                         ; PWM Scale B Bit 5
PWMSCLB_BIT6:       equ    6                                         ; PWM Scale B Bit 6
PWMSCLB_BIT7:       equ    7                                         ; PWM Scale B Bit 7
; bit position masks
mPWMSCLB_BIT0:      equ    %00000001
mPWMSCLB_BIT1:      equ    %00000010
mPWMSCLB_BIT2:      equ    %00000100
mPWMSCLB_BIT3:      equ    %00001000
mPWMSCLB_BIT4:      equ    %00010000
mPWMSCLB_BIT5:      equ    %00100000
mPWMSCLB_BIT6:      equ    %01000000
mPWMSCLB_BIT7:      equ    %10000000


;*** PWMCNT01 - PWM Channel Counter 01 Register; 0x000000AC ***
PWMCNT01:           equ    $000000AC                                ;*** PWMCNT01 - PWM Channel Counter 01 Register; 0x000000AC ***


;*** PWMCNT0 - PWM Channel Counter 0 Register; 0x000000AC ***
PWMCNT0:            equ    $000000AC                                ;*** PWMCNT0 - PWM Channel Counter 0 Register; 0x000000AC ***


;*** PWMCNT1 - PWM Channel Counter 1 Register; 0x000000AD ***
PWMCNT1:            equ    $000000AD                                ;*** PWMCNT1 - PWM Channel Counter 1 Register; 0x000000AD ***


;*** PWMCNT23 - PWM Channel Counter 23 Register; 0x000000AE ***
PWMCNT23:           equ    $000000AE                                ;*** PWMCNT23 - PWM Channel Counter 23 Register; 0x000000AE ***


;*** PWMCNT2 - PWM Channel Counter 2 Register; 0x000000AE ***
PWMCNT2:            equ    $000000AE                                ;*** PWMCNT2 - PWM Channel Counter 2 Register; 0x000000AE ***


;*** PWMCNT3 - PWM Channel Counter 3 Register; 0x000000AF ***
PWMCNT3:            equ    $000000AF                                ;*** PWMCNT3 - PWM Channel Counter 3 Register; 0x000000AF ***


;*** PWMCNT45 - PWM Channel Counter 45 Register; 0x000000B0 ***
PWMCNT45:           equ    $000000B0                                ;*** PWMCNT45 - PWM Channel Counter 45 Register; 0x000000B0 ***


;*** PWMCNT4 - PWM Channel Counter 4 Register; 0x000000B0 ***
PWMCNT4:            equ    $000000B0                                ;*** PWMCNT4 - PWM Channel Counter 4 Register; 0x000000B0 ***


;*** PWMCNT5 - PWM Channel Counter 5 Register; 0x000000B1 ***
PWMCNT5:            equ    $000000B1                                ;*** PWMCNT5 - PWM Channel Counter 5 Register; 0x000000B1 ***


;*** PWMCNT67 - PWM Channel Counter 67 Register; 0x000000B2 ***
PWMCNT67:           equ    $000000B2                                ;*** PWMCNT67 - PWM Channel Counter 67 Register; 0x000000B2 ***


;*** PWMCNT6 - PWM Channel Counter 6 Register; 0x000000B2 ***
PWMCNT6:            equ    $000000B2                                ;*** PWMCNT6 - PWM Channel Counter 6 Register; 0x000000B2 ***


;*** PWMCNT7 - PWM Channel Counter 7 Register; 0x000000B3 ***
PWMCNT7:            equ    $000000B3                                ;*** PWMCNT7 - PWM Channel Counter 7 Register; 0x000000B3 ***


;*** PWMPER01 - PWM Channel Period 01 Register; 0x000000B4 ***
PWMPER01:           equ    $000000B4                                ;*** PWMPER01 - PWM Channel Period 01 Register; 0x000000B4 ***


;*** PWMPER0 - PWM Channel Period 0 Register; 0x000000B4 ***
PWMPER0:            equ    $000000B4                                ;*** PWMPER0 - PWM Channel Period 0 Register; 0x000000B4 ***


;*** PWMPER1 - PWM Channel Period 1 Register; 0x000000B5 ***
PWMPER1:            equ    $000000B5                                ;*** PWMPER1 - PWM Channel Period 1 Register; 0x000000B5 ***


;*** PWMPER23 - PWM Channel Period 23 Register; 0x000000B6 ***
PWMPER23:           equ    $000000B6                                ;*** PWMPER23 - PWM Channel Period 23 Register; 0x000000B6 ***


;*** PWMPER2 - PWM Channel Period 2 Register; 0x000000B6 ***
PWMPER2:            equ    $000000B6                                ;*** PWMPER2 - PWM Channel Period 2 Register; 0x000000B6 ***


;*** PWMPER3 - PWM Channel Period 3 Register; 0x000000B7 ***
PWMPER3:            equ    $000000B7                                ;*** PWMPER3 - PWM Channel Period 3 Register; 0x000000B7 ***


;*** PWMPER45 - PWM Channel Period 45 Register; 0x000000B8 ***
PWMPER45:           equ    $000000B8                                ;*** PWMPER45 - PWM Channel Period 45 Register; 0x000000B8 ***


;*** PWMPER4 - PWM Channel Period 4 Register; 0x000000B8 ***
PWMPER4:            equ    $000000B8                                ;*** PWMPER4 - PWM Channel Period 4 Register; 0x000000B8 ***


;*** PWMPER5 - PWM Channel Period 5 Register; 0x000000B9 ***
PWMPER5:            equ    $000000B9                                ;*** PWMPER5 - PWM Channel Period 5 Register; 0x000000B9 ***


;*** PWMPER67 - PWM Channel Period 67 Register; 0x000000BA ***
PWMPER67:           equ    $000000BA                                ;*** PWMPER67 - PWM Channel Period 67 Register; 0x000000BA ***


;*** PWMPER6 - PWM Channel Period 6 Register; 0x000000BA ***
PWMPER6:            equ    $000000BA                                ;*** PWMPER6 - PWM Channel Period 6 Register; 0x000000BA ***


;*** PWMPER7 - PWM Channel Period 7 Register; 0x000000BB ***
PWMPER7:            equ    $000000BB                                ;*** PWMPER7 - PWM Channel Period 7 Register; 0x000000BB ***


;*** PWMDTY01 - PWM Channel Duty 01 Register; 0x000000BC ***
PWMDTY01:           equ    $000000BC                                ;*** PWMDTY01 - PWM Channel Duty 01 Register; 0x000000BC ***


;*** PWMDTY0 - PWM Channel Duty 0 Register; 0x000000BC ***
PWMDTY0:            equ    $000000BC                                ;*** PWMDTY0 - PWM Channel Duty 0 Register; 0x000000BC ***


;*** PWMDTY1 - PWM Channel Duty 1 Register; 0x000000BD ***
PWMDTY1:            equ    $000000BD                                ;*** PWMDTY1 - PWM Channel Duty 1 Register; 0x000000BD ***


;*** PWMDTY23 - PWM Channel Duty 23 Register; 0x000000BE ***
PWMDTY23:           equ    $000000BE                                ;*** PWMDTY23 - PWM Channel Duty 23 Register; 0x000000BE ***


;*** PWMDTY2 - PWM Channel Duty 2 Register; 0x000000BE ***
PWMDTY2:            equ    $000000BE                                ;*** PWMDTY2 - PWM Channel Duty 2 Register; 0x000000BE ***


;*** PWMDTY3 - PWM Channel Duty 3 Register; 0x000000BF ***
PWMDTY3:            equ    $000000BF                                ;*** PWMDTY3 - PWM Channel Duty 3 Register; 0x000000BF ***


;*** PWMDTY45 - PWM Channel Duty 45 Register; 0x000000C0 ***
PWMDTY45:           equ    $000000C0                                ;*** PWMDTY45 - PWM Channel Duty 45 Register; 0x000000C0 ***


;*** PWMDTY4 - PWM Channel Duty 4 Register; 0x000000C0 ***
PWMDTY4:            equ    $000000C0                                ;*** PWMDTY4 - PWM Channel Duty 4 Register; 0x000000C0 ***


;*** PWMDTY5 - PWM Channel Duty 5 Register; 0x000000C1 ***
PWMDTY5:            equ    $000000C1                                ;*** PWMDTY5 - PWM Channel Duty 5 Register; 0x000000C1 ***


;*** PWMDTY67 - PWM Channel Duty 67 Register; 0x000000C2 ***
PWMDTY67:           equ    $000000C2                                ;*** PWMDTY67 - PWM Channel Duty 67 Register; 0x000000C2 ***


;*** PWMDTY6 - PWM Channel Duty 6 Register; 0x000000C2 ***
PWMDTY6:            equ    $000000C2                                ;*** PWMDTY6 - PWM Channel Duty 6 Register; 0x000000C2 ***


;*** PWMDTY7 - PWM Channel Duty 7 Register; 0x000000C3 ***
PWMDTY7:            equ    $000000C3                                ;*** PWMDTY7 - PWM Channel Duty 7 Register; 0x000000C3 ***


;*** PWMSDN - PWM Shutdown Register; 0x000000C4 ***
PWMSDN:             equ    $000000C4                                ;*** PWMSDN - PWM Shutdown Register; 0x000000C4 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PWMSDN_PWM7ENA:     equ    0                                         ; PWM emergency shutdown Enable
PWMSDN_PWM7INL:     equ    1                                         ; PWM shutdown active input level for ch. 7
PWMSDN_PWM7IN:      equ    2                                         ; PWM channel 7 input status
PWMSDN_PWMLVL:      equ    4                                         ; PWM shutdown output Level
PWMSDN_PWMRSTRT:    equ    5                                         ; PWM Restart
PWMSDN_PWMIE:       equ    6                                         ; PWM Interrupt Enable
PWMSDN_PWMIF:       equ    7                                         ; PWM Interrupt Flag
; bit position masks
mPWMSDN_PWM7ENA:    equ    %00000001
mPWMSDN_PWM7INL:    equ    %00000010
mPWMSDN_PWM7IN:     equ    %00000100
mPWMSDN_PWMLVL:     equ    %00010000
mPWMSDN_PWMRSTRT:   equ    %00100000
mPWMSDN_PWMIE:      equ    %01000000
mPWMSDN_PWMIF:      equ    %10000000


;*** SCIBD - SCI  Baud Rate Register; 0x000000C8 ***
SCIBD:              equ    $000000C8                                ;*** SCIBD - SCI  Baud Rate Register; 0x000000C8 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCIBD_SBR0:         equ    0                                         ; SCI Baud Rate Bit 0
SCIBD_SBR1:         equ    1                                         ; SCI Baud Rate Bit 1
SCIBD_SBR2:         equ    2                                         ; SCI Baud Rate Bit 2
SCIBD_SBR3:         equ    3                                         ; SCI Baud Rate Bit 3
SCIBD_SBR4:         equ    4                                         ; SCI Baud Rate Bit 4
SCIBD_SBR5:         equ    5                                         ; SCI Baud Rate Bit 5
SCIBD_SBR6:         equ    6                                         ; SCI Baud Rate Bit 6
SCIBD_SBR7:         equ    7                                         ; SCI Baud Rate Bit 7
SCIBD_SBR8:         equ    8                                         ; SCI Baud Rate Bit 8
SCIBD_SBR9:         equ    9                                         ; SCI Baud Rate Bit 9
SCIBD_SBR10:        equ    10                                        ; SCI Baud Rate Bit 10
SCIBD_SBR11:        equ    11                                        ; SCI Baud Rate Bit 11
SCIBD_SBR12:        equ    12                                        ; SCI Baud Rate Bit 12
SCIBD_TNP0:         equ    13                                        ; Transmitter Narrow Pulse Bit 0
SCIBD_TNP1:         equ    14                                        ; Transmitter Narrow Pulse Bit 1
SCIBD_IREN:         equ    15                                        ; Infrared Enable Bit
; bit position masks
mSCIBD_SBR0:        equ    %00000001
mSCIBD_SBR1:        equ    %00000010
mSCIBD_SBR2:        equ    %00000100
mSCIBD_SBR3:        equ    %00001000
mSCIBD_SBR4:        equ    %00010000
mSCIBD_SBR5:        equ    %00100000
mSCIBD_SBR6:        equ    %01000000
mSCIBD_SBR7:        equ    %10000000
mSCIBD_SBR8:        equ    %100000000
mSCIBD_SBR9:        equ    %1000000000
mSCIBD_SBR10:       equ    %10000000000
mSCIBD_SBR11:       equ    %100000000000
mSCIBD_SBR12:       equ    %1000000000000
mSCIBD_TNP0:        equ    %10000000000000
mSCIBD_TNP1:        equ    %100000000000000
mSCIBD_IREN:        equ    %1000000000000000


;*** SCIASR1 - SCI  Alternative Status Register 1; 0x000000C8 ***
SCIASR1:            equ    $000000C8                                ;*** SCIASR1 - SCI  Alternative Status Register 1; 0x000000C8 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCIASR1_BKDIF:      equ    0                                         ; Break Detect Interrupt Flag
SCIASR1_BERRIF:     equ    1                                         ; Bit Error Interrupt Flag
SCIASR1_BERRV:      equ    2                                         ; Bit Error Value
SCIASR1_RXEDGIF:    equ    7                                         ; Receive Input Active Edge Interrupt Flag
; bit position masks
mSCIASR1_BKDIF:     equ    %00000001
mSCIASR1_BERRIF:    equ    %00000010
mSCIASR1_BERRV:     equ    %00000100
mSCIASR1_RXEDGIF:   equ    %10000000


;*** SCIBDH - SCI  Baud Rate Register High; 0x000000C8 ***
SCIBDH:             equ    $000000C8                                ;*** SCIBDH - SCI  Baud Rate Register High; 0x000000C8 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCIBDH_SBR8:        equ    0                                         ; SCI Baud Rate Bit 8
SCIBDH_SBR9:        equ    1                                         ; SCI Baud Rate Bit 9
SCIBDH_SBR10:       equ    2                                         ; SCI Baud Rate Bit 10
SCIBDH_SBR11:       equ    3                                         ; SCI Baud Rate Bit 11
SCIBDH_SBR12:       equ    4                                         ; SCI Baud Rate Bit 12
SCIBDH_TNP0:        equ    5                                         ; Transmitter Narrow Pulse Bit 0
SCIBDH_TNP1:        equ    6                                         ; Transmitter Narrow Pulse Bit 1
SCIBDH_IREN:        equ    7                                         ; Infrared Enable Bit
; bit position masks
mSCIBDH_SBR8:       equ    %00000001
mSCIBDH_SBR9:       equ    %00000010
mSCIBDH_SBR10:      equ    %00000100
mSCIBDH_SBR11:      equ    %00001000
mSCIBDH_SBR12:      equ    %00010000
mSCIBDH_TNP0:       equ    %00100000
mSCIBDH_TNP1:       equ    %01000000
mSCIBDH_IREN:       equ    %10000000


;*** SCIACR1 - SCI  Alternative Control Register 1; 0x000000C9 ***
SCIACR1:            equ    $000000C9                                ;*** SCIACR1 - SCI  Alternative Control Register 1; 0x000000C9 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCIACR1_BKDIE:      equ    0                                         ; Break Detect Interrupt Enable
SCIACR1_BERRIE:     equ    1                                         ; Bit Error Interrupt Enable
SCIACR1_RXEDGIE:    equ    7                                         ; Receive Input Active Edge Interrupt Enable
; bit position masks
mSCIACR1_BKDIE:     equ    %00000001
mSCIACR1_BERRIE:    equ    %00000010
mSCIACR1_RXEDGIE:   equ    %10000000


;*** SCIBDL - SCI  Baud Rate Register Low; 0x000000C9 ***
SCIBDL:             equ    $000000C9                                ;*** SCIBDL - SCI  Baud Rate Register Low; 0x000000C9 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCIBDL_SBR0:        equ    0                                         ; SCI Baud Rate Bit 0
SCIBDL_SBR1:        equ    1                                         ; SCI Baud Rate Bit 1
SCIBDL_SBR2:        equ    2                                         ; SCI Baud Rate Bit 2
SCIBDL_SBR3:        equ    3                                         ; SCI Baud Rate Bit 3
SCIBDL_SBR4:        equ    4                                         ; SCI Baud Rate Bit 4
SCIBDL_SBR5:        equ    5                                         ; SCI Baud Rate Bit 5
SCIBDL_SBR6:        equ    6                                         ; SCI Baud Rate Bit 6
SCIBDL_SBR7:        equ    7                                         ; SCI Baud Rate Bit 7
; bit position masks
mSCIBDL_SBR0:       equ    %00000001
mSCIBDL_SBR1:       equ    %00000010
mSCIBDL_SBR2:       equ    %00000100
mSCIBDL_SBR3:       equ    %00001000
mSCIBDL_SBR4:       equ    %00010000
mSCIBDL_SBR5:       equ    %00100000
mSCIBDL_SBR6:       equ    %01000000
mSCIBDL_SBR7:       equ    %10000000


;*** SCIACR2 - SCI  Alternative Control Register 2; 0x000000CA ***
SCIACR2:            equ    $000000CA                                ;*** SCIACR2 - SCI  Alternative Control Register 2; 0x000000CA ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCIACR2_BKDFE:      equ    0                                         ; Break Detect Feature Enable
SCIACR2_BERRM0:     equ    1                                         ; Bit Error Mode 0
SCIACR2_BERRM1:     equ    2                                         ; Bit Error Mode 1
; bit position masks
mSCIACR2_BKDFE:     equ    %00000001
mSCIACR2_BERRM0:    equ    %00000010
mSCIACR2_BERRM1:    equ    %00000100


;*** SCICR1 - SCI  Control Register 1; 0x000000CA ***
SCICR1:             equ    $000000CA                                ;*** SCICR1 - SCI  Control Register 1; 0x000000CA ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCICR1_PT:          equ    0                                         ; Parity Type Bit
SCICR1_PE:          equ    1                                         ; Parity Enable Bit
SCICR1_ILT:         equ    2                                         ; Idle Line Type Bit
SCICR1_WAKE:        equ    3                                         ; Wakeup Condition Bit
SCICR1_M:           equ    4                                         ; Data Format Mode Bit
SCICR1_RSRC:        equ    5                                         ; Receiver Source Bit
SCICR1_SCISWAI:     equ    6                                         ; SCI Stop in Wait Mode Bit
SCICR1_LOOPS:       equ    7                                         ; Loop Select Bit
; bit position masks
mSCICR1_PT:         equ    %00000001
mSCICR1_PE:         equ    %00000010
mSCICR1_ILT:        equ    %00000100
mSCICR1_WAKE:       equ    %00001000
mSCICR1_M:          equ    %00010000
mSCICR1_RSRC:       equ    %00100000
mSCICR1_SCISWAI:    equ    %01000000
mSCICR1_LOOPS:      equ    %10000000


;*** SCICR2 - SCI  Control Register 2; 0x000000CB ***
SCICR2:             equ    $000000CB                                ;*** SCICR2 - SCI  Control Register 2; 0x000000CB ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCICR2_SBK:         equ    0                                         ; Send Break Bit
SCICR2_RWU:         equ    1                                         ; Receiver Wakeup Bit
SCICR2_RE:          equ    2                                         ; Receiver Enable Bit
SCICR2_TE:          equ    3                                         ; Transmitter Enable Bit
SCICR2_ILIE:        equ    4                                         ; Idle Line Interrupt Enable Bit
SCICR2_RIE:         equ    5                                         ; Receiver Full Interrupt Enable Bit
SCICR2_TCIE:        equ    6                                         ; Transmission Complete Interrupt Enable Bit
SCICR2_TIE:         equ    7                                         ; Transmitter Interrupt Enable Bit
; bit position masks
mSCICR2_SBK:        equ    %00000001
mSCICR2_RWU:        equ    %00000010
mSCICR2_RE:         equ    %00000100
mSCICR2_TE:         equ    %00001000
mSCICR2_ILIE:       equ    %00010000
mSCICR2_RIE:        equ    %00100000
mSCICR2_TCIE:       equ    %01000000
mSCICR2_TIE:        equ    %10000000


;*** SCISR1 - SCI  Status Register 1; 0x000000CC ***
SCISR1:             equ    $000000CC                                ;*** SCISR1 - SCI  Status Register 1; 0x000000CC ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCISR1_PF:          equ    0                                         ; Parity Error Flag
SCISR1_FE:          equ    1                                         ; Framing Error Flag
SCISR1_NF:          equ    2                                         ; Noise Flag
SCISR1_OR:          equ    3                                         ; Overrun Flag
SCISR1_IDLE:        equ    4                                         ; Idle Line Flag
SCISR1_RDRF:        equ    5                                         ; Receive Data Register Full Flag
SCISR1_TC:          equ    6                                         ; Transmit Complete Flag
SCISR1_TDRE:        equ    7                                         ; Transmit Data Register Empty Flag
; bit position masks
mSCISR1_PF:         equ    %00000001
mSCISR1_FE:         equ    %00000010
mSCISR1_NF:         equ    %00000100
mSCISR1_OR:         equ    %00001000
mSCISR1_IDLE:       equ    %00010000
mSCISR1_RDRF:       equ    %00100000
mSCISR1_TC:         equ    %01000000
mSCISR1_TDRE:       equ    %10000000


;*** SCISR2 - SCI  Status Register 2; 0x000000CD ***
SCISR2:             equ    $000000CD                                ;*** SCISR2 - SCI  Status Register 2; 0x000000CD ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCISR2_RAF:         equ    0                                         ; Receiver Active Flag
SCISR2_TXDIR:       equ    1                                         ; Transmitter pin data direction in Single-Wire mode
SCISR2_BRK13:       equ    2                                         ; Break Transmit character length
SCISR2_RXPOL:       equ    3                                         ; Receive Polarity
SCISR2_TXPOL:       equ    4                                         ; Transmit Polarity
SCISR2_AMAP:        equ    7                                         ; Alternative Map
; bit position masks
mSCISR2_RAF:        equ    %00000001
mSCISR2_TXDIR:      equ    %00000010
mSCISR2_BRK13:      equ    %00000100
mSCISR2_RXPOL:      equ    %00001000
mSCISR2_TXPOL:      equ    %00010000
mSCISR2_AMAP:       equ    %10000000


;*** SCIDRH - SCI  Data Register High; 0x000000CE ***
SCIDRH:             equ    $000000CE                                ;*** SCIDRH - SCI  Data Register High; 0x000000CE ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCIDRH_T8:          equ    6                                         ; Transmit Bit 8
SCIDRH_R8:          equ    7                                         ; Received Bit 8
; bit position masks
mSCIDRH_T8:         equ    %01000000
mSCIDRH_R8:         equ    %10000000


;*** SCIDRL - SCI  Data Register Low; 0x000000CF ***
SCIDRL:             equ    $000000CF                                ;*** SCIDRL - SCI  Data Register Low; 0x000000CF ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCIDRL_R0_T0:       equ    0                                         ; Received bit 0 or Transmit bit 0
SCIDRL_R1_T1:       equ    1                                         ; Received bit 1 or Transmit bit 1
SCIDRL_R2_T2:       equ    2                                         ; Received bit 2 or Transmit bit 2
SCIDRL_R3_T3:       equ    3                                         ; Received bit 3 or Transmit bit 3
SCIDRL_R4_T4:       equ    4                                         ; Received bit 4 or Transmit bit 4
SCIDRL_R5_T5:       equ    5                                         ; Received bit 5 or Transmit bit 5
SCIDRL_R6_T6:       equ    6                                         ; Received bit 6 or Transmit bit 6
SCIDRL_R7_T7:       equ    7                                         ; Received bit 7 or Transmit bit 7
; bit position masks
mSCIDRL_R0_T0:      equ    %00000001
mSCIDRL_R1_T1:      equ    %00000010
mSCIDRL_R2_T2:      equ    %00000100
mSCIDRL_R3_T3:      equ    %00001000
mSCIDRL_R4_T4:      equ    %00010000
mSCIDRL_R5_T5:      equ    %00100000
mSCIDRL_R6_T6:      equ    %01000000
mSCIDRL_R7_T7:      equ    %10000000


;*** SPICR1 - SPI  Control Register 1; 0x000000D8 ***
SPICR1:             equ    $000000D8                                ;*** SPICR1 - SPI  Control Register 1; 0x000000D8 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPICR1_LSBFE:       equ    0                                         ; SPI LSB-First Enable
SPICR1_SSOE:        equ    1                                         ; Slave Select Output Enable
SPICR1_CPHA:        equ    2                                         ; SPI Clock Phase Bit
SPICR1_CPOL:        equ    3                                         ; SPI Clock Polarity Bit
SPICR1_MSTR:        equ    4                                         ; SPI Master/Slave Mode Select Bit
SPICR1_SPTIE:       equ    5                                         ; SPI Transmit Interrupt Enable
SPICR1_SPE:         equ    6                                         ; SPI System Enable Bit
SPICR1_SPIE:        equ    7                                         ; SPI Interrupt Enable Bit
; bit position masks
mSPICR1_LSBFE:      equ    %00000001
mSPICR1_SSOE:       equ    %00000010
mSPICR1_CPHA:       equ    %00000100
mSPICR1_CPOL:       equ    %00001000
mSPICR1_MSTR:       equ    %00010000
mSPICR1_SPTIE:      equ    %00100000
mSPICR1_SPE:        equ    %01000000
mSPICR1_SPIE:       equ    %10000000


;*** SPICR2 - SPI  Control Register 2; 0x000000D9 ***
SPICR2:             equ    $000000D9                                ;*** SPICR2 - SPI  Control Register 2; 0x000000D9 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPICR2_SPC0:        equ    0                                         ; Serial Pin Control Bit 0
SPICR2_SPISWAI:     equ    1                                         ; SPI Stop in Wait Mode Bit
SPICR2_BIDIROE:     equ    3                                         ; Output enable in the Bidirectional mode of operation
SPICR2_MODFEN:      equ    4                                         ; Mode Fault Enable Bit
SPICR2_XFRW:        equ    6                                         ; Transfer Width
; bit position masks
mSPICR2_SPC0:       equ    %00000001
mSPICR2_SPISWAI:    equ    %00000010
mSPICR2_BIDIROE:    equ    %00001000
mSPICR2_MODFEN:     equ    %00010000
mSPICR2_XFRW:       equ    %01000000


;*** SPIBR - SPI  Baud Rate Register; 0x000000DA ***
SPIBR:              equ    $000000DA                                ;*** SPIBR - SPI  Baud Rate Register; 0x000000DA ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPIBR_SPR0:         equ    0                                         ; SPI Baud Rate Selection Bit 0
SPIBR_SPR1:         equ    1                                         ; SPI Baud Rate Selection Bit 1
SPIBR_SPR2:         equ    2                                         ; SPI Baud Rate Selection Bit 2
SPIBR_SPPR0:        equ    4                                         ; SPI Baud Rate Preselection Bits 0
SPIBR_SPPR1:        equ    5                                         ; SPI Baud Rate Preselection Bits 1
SPIBR_SPPR2:        equ    6                                         ; SPI Baud Rate Preselection Bits 2
; bit position masks
mSPIBR_SPR0:        equ    %00000001
mSPIBR_SPR1:        equ    %00000010
mSPIBR_SPR2:        equ    %00000100
mSPIBR_SPPR0:       equ    %00010000
mSPIBR_SPPR1:       equ    %00100000
mSPIBR_SPPR2:       equ    %01000000


;*** SPISR - SPI  Status Register; 0x000000DB ***
SPISR:              equ    $000000DB                                ;*** SPISR - SPI  Status Register; 0x000000DB ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPISR_MODF:         equ    4                                         ; Mode Fault Flag
SPISR_SPTEF:        equ    5                                         ; SPI Transmit Empty Interrupt Flag
SPISR_SPIF:         equ    7                                         ; SPIF Receive Interrupt Flag
; bit position masks
mSPISR_MODF:        equ    %00010000
mSPISR_SPTEF:       equ    %00100000
mSPISR_SPIF:        equ    %10000000


;*** SPIDR - SPI  Data Register; 0x000000DC ***
SPIDR:              equ    $000000DC                                ;*** SPIDR - SPI  Data Register; 0x000000DC ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPIDR_R0_T0:        equ    0                                         ; SPI  Data Bit 0
SPIDR_R1_T1:        equ    1                                         ; SPI  Data Bit 1
SPIDR_R2_T2:        equ    2                                         ; SPI  Data Bit 2
SPIDR_R3_T3:        equ    3                                         ; SPI  Data Bit 3
SPIDR_R4_T4:        equ    4                                         ; SPI  Data Bit 4
SPIDR_R5_T5:        equ    5                                         ; SPI  Data Bit 5
SPIDR_R6_T6:        equ    6                                         ; SPI  Data Bit 6
SPIDR_R7_T7:        equ    7                                         ; SPI  Data Bit 7
SPIDR_R8_T8:        equ    8                                         ; SPI  Data Bit 8
SPIDR_R9_T9:        equ    9                                         ; SPI  Data Bit 9
SPIDR_R10_T10:      equ    10                                        ; SPI  Data Bit 10
SPIDR_R11_T11:      equ    11                                        ; SPI  Data Bit 11
SPIDR_R12_T12:      equ    12                                        ; SPI  Data Bit 12
SPIDR_R13_T13:      equ    13                                        ; SPI  Data Bit 13
SPIDR_R14_T14:      equ    14                                        ; SPI  Data Bit 14
SPIDR_R15_T15:      equ    15                                        ; SPI  Data Bit 15
; bit position masks
mSPIDR_R0_T0:       equ    %00000001
mSPIDR_R1_T1:       equ    %00000010
mSPIDR_R2_T2:       equ    %00000100
mSPIDR_R3_T3:       equ    %00001000
mSPIDR_R4_T4:       equ    %00010000
mSPIDR_R5_T5:       equ    %00100000
mSPIDR_R6_T6:       equ    %01000000
mSPIDR_R7_T7:       equ    %10000000
mSPIDR_R8_T8:       equ    %100000000
mSPIDR_R9_T9:       equ    %1000000000
mSPIDR_R10_T10:     equ    %10000000000
mSPIDR_R11_T11:     equ    %100000000000
mSPIDR_R12_T12:     equ    %1000000000000
mSPIDR_R13_T13:     equ    %10000000000000
mSPIDR_R14_T14:     equ    %100000000000000
mSPIDR_R15_T15:     equ    %1000000000000000


;*** SPIDRH - SPI  Data Register High; 0x000000DC ***
SPIDRH:             equ    $000000DC                                ;*** SPIDRH - SPI  Data Register High; 0x000000DC ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPIDRH_R8_T8:       equ    0                                         ; SPI  Data Bit 8
SPIDRH_R9_T9:       equ    1                                         ; SPI  Data Bit 9
SPIDRH_R10_T10:     equ    2                                         ; SPI  Data Bit 10
SPIDRH_R11_T11:     equ    3                                         ; SPI  Data Bit 11
SPIDRH_R12_T12:     equ    4                                         ; SPI  Data Bit 12
SPIDRH_R13_T13:     equ    5                                         ; SPI  Data Bit 13
SPIDRH_R14_T14:     equ    6                                         ; SPI  Data Bit 14
SPIDRH_R15_T15:     equ    7                                         ; SPI  Data Bit 15
; bit position masks
mSPIDRH_R8_T8:      equ    %00000001
mSPIDRH_R9_T9:      equ    %00000010
mSPIDRH_R10_T10:    equ    %00000100
mSPIDRH_R11_T11:    equ    %00001000
mSPIDRH_R12_T12:    equ    %00010000
mSPIDRH_R13_T13:    equ    %00100000
mSPIDRH_R14_T14:    equ    %01000000
mSPIDRH_R15_T15:    equ    %10000000


;*** SPIDRL - SPI  Data Register Low; 0x000000DD ***
SPIDRL:             equ    $000000DD                                ;*** SPIDRL - SPI  Data Register Low; 0x000000DD ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPIDRL_R0_T0:       equ    0                                         ; SPI  Data Bit 0
SPIDRL_R1_T1:       equ    1                                         ; SPI  Data Bit 1
SPIDRL_R2_T2:       equ    2                                         ; SPI  Data Bit 2
SPIDRL_R3_T3:       equ    3                                         ; SPI  Data Bit 3
SPIDRL_R4_T4:       equ    4                                         ; SPI  Data Bit 4
SPIDRL_R5_T5:       equ    5                                         ; SPI  Data Bit 5
SPIDRL_R6_T6:       equ    6                                         ; SPI  Data Bit 6
SPIDRL_R7_T7:       equ    7                                         ; SPI  Data Bit 7
; bit position masks
mSPIDRL_R0_T0:      equ    %00000001
mSPIDRL_R1_T1:      equ    %00000010
mSPIDRL_R2_T2:      equ    %00000100
mSPIDRL_R3_T3:      equ    %00001000
mSPIDRL_R4_T4:      equ    %00010000
mSPIDRL_R5_T5:      equ    %00100000
mSPIDRL_R6_T6:      equ    %01000000
mSPIDRL_R7_T7:      equ    %10000000


;*** IIC_IBAD - IIC Address Register; 0x000000E0 ***
IIC_IBAD:           equ    $000000E0                                ;*** IIC_IBAD - IIC Address Register; 0x000000E0 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
IIC_IBAD_ADR1:      equ    1                                         ; Slave Address Bit 1
IIC_IBAD_ADR2:      equ    2                                         ; Slave Address Bit 2
IIC_IBAD_ADR3:      equ    3                                         ; Slave Address Bit 3
IIC_IBAD_ADR4:      equ    4                                         ; Slave Address Bit 4
IIC_IBAD_ADR5:      equ    5                                         ; Slave Address Bit 5
IIC_IBAD_ADR6:      equ    6                                         ; Slave Address Bit 6
IIC_IBAD_ADR7:      equ    7                                         ; Slave Address Bit 7
; bit position masks
mIIC_IBAD_ADR1:     equ    %00000010
mIIC_IBAD_ADR2:     equ    %00000100
mIIC_IBAD_ADR3:     equ    %00001000
mIIC_IBAD_ADR4:     equ    %00010000
mIIC_IBAD_ADR5:     equ    %00100000
mIIC_IBAD_ADR6:     equ    %01000000
mIIC_IBAD_ADR7:     equ    %10000000


;*** IIC_IBFD - IIC Frequency Divider Register; 0x000000E1 ***
IIC_IBFD:           equ    $000000E1                                ;*** IIC_IBFD - IIC Frequency Divider Register; 0x000000E1 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
IIC_IBFD_IBC0:      equ    0                                         ; I-Bus Clock Rate 0
IIC_IBFD_IBC1:      equ    1                                         ; I-Bus Clock Rate 1
IIC_IBFD_IBC2:      equ    2                                         ; I-Bus Clock Rate 2
IIC_IBFD_IBC3:      equ    3                                         ; I-Bus Clock Rate 3
IIC_IBFD_IBC4:      equ    4                                         ; I-Bus Clock Rate 4
IIC_IBFD_IBC5:      equ    5                                         ; I-Bus Clock Rate 5
IIC_IBFD_IBC6:      equ    6                                         ; I-Bus Clock Rate 6
IIC_IBFD_IBC7:      equ    7                                         ; I-Bus Clock Rate 7
; bit position masks
mIIC_IBFD_IBC0:     equ    %00000001
mIIC_IBFD_IBC1:     equ    %00000010
mIIC_IBFD_IBC2:     equ    %00000100
mIIC_IBFD_IBC3:     equ    %00001000
mIIC_IBFD_IBC4:     equ    %00010000
mIIC_IBFD_IBC5:     equ    %00100000
mIIC_IBFD_IBC6:     equ    %01000000
mIIC_IBFD_IBC7:     equ    %10000000


;*** IIC_IBCR - IIC Control Register; 0x000000E2 ***
IIC_IBCR:           equ    $000000E2                                ;*** IIC_IBCR - IIC Control Register; 0x000000E2 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
IIC_IBCR_IBSWAI:    equ    0                                         ; I-Bus Interface Stop in WAIT mode
IIC_IBCR_RSTA:      equ    2                                         ; Repeat Start
IIC_IBCR_TXAK:      equ    3                                         ; Transmit Acknowledge enable
IIC_IBCR_TX_RX:     equ    4                                         ; Transmit/Receive mode select bit
IIC_IBCR_MS_SL:     equ    5                                         ; Master/Slave mode select bit
IIC_IBCR_IBIE:      equ    6                                         ; I-Bus Interrupt Enable
IIC_IBCR_IBEN:      equ    7                                         ; I-Bus Enable
; bit position masks
mIIC_IBCR_IBSWAI:   equ    %00000001
mIIC_IBCR_RSTA:     equ    %00000100
mIIC_IBCR_TXAK:     equ    %00001000
mIIC_IBCR_TX_RX:    equ    %00010000
mIIC_IBCR_MS_SL:    equ    %00100000
mIIC_IBCR_IBIE:     equ    %01000000
mIIC_IBCR_IBEN:     equ    %10000000


;*** IIC_IBSR - IIC Status Register; 0x000000E3 ***
IIC_IBSR:           equ    $000000E3                                ;*** IIC_IBSR - IIC Status Register; 0x000000E3 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
IIC_IBSR_RXAK:      equ    0                                         ; Received Acknowledge
IIC_IBSR_IBIF:      equ    1                                         ; I-Bus Interrupt
IIC_IBSR_SRW:       equ    2                                         ; Slave Read/Write
IIC_IBSR_IBAL:      equ    4                                         ; Arbitration Lost
IIC_IBSR_IBB:       equ    5                                         ; Bus busy bit
IIC_IBSR_IAAS:      equ    6                                         ; Addressed as a slave bit
IIC_IBSR_TCF:       equ    7                                         ; Data transferring bit
; bit position masks
mIIC_IBSR_RXAK:     equ    %00000001
mIIC_IBSR_IBIF:     equ    %00000010
mIIC_IBSR_SRW:      equ    %00000100
mIIC_IBSR_IBAL:     equ    %00010000
mIIC_IBSR_IBB:      equ    %00100000
mIIC_IBSR_IAAS:     equ    %01000000
mIIC_IBSR_TCF:      equ    %10000000


;*** IIC_IBDR - IIC Data I/O Register; 0x000000E4 ***
IIC_IBDR:           equ    $000000E4                                ;*** IIC_IBDR - IIC Data I/O Register; 0x000000E4 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
IIC_IBDR_D0:        equ    0                                         ; IIC Data Bit 0
IIC_IBDR_D1:        equ    1                                         ; IIC Data Bit 1
IIC_IBDR_D2:        equ    2                                         ; IIC Data Bit 2
IIC_IBDR_D3:        equ    3                                         ; IIC Data Bit 3
IIC_IBDR_D4:        equ    4                                         ; IIC Data Bit 4
IIC_IBDR_D5:        equ    5                                         ; IIC Data Bit 5
IIC_IBDR_D6:        equ    6                                         ; IIC Data Bit 6
IIC_IBDR_D7:        equ    7                                         ; IIC Data Bit 7
; bit position masks
mIIC_IBDR_D0:       equ    %00000001
mIIC_IBDR_D1:       equ    %00000010
mIIC_IBDR_D2:       equ    %00000100
mIIC_IBDR_D3:       equ    %00001000
mIIC_IBDR_D4:       equ    %00010000
mIIC_IBDR_D5:       equ    %00100000
mIIC_IBDR_D6:       equ    %01000000
mIIC_IBDR_D7:       equ    %10000000


;*** IIC_IBCR2 - IIC Control Register 2; 0x000000E5 ***
IIC_IBCR2:          equ    $000000E5                                ;*** IIC_IBCR2 - IIC Control Register 2; 0x000000E5 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
IIC_IBCR2_ADR8:     equ    0                                         ; Slave Address Bit 8
IIC_IBCR2_ADR9:     equ    1                                         ; Slave Address Bit 9
IIC_IBCR2_ADR10:    equ    2                                         ; Slave Address Bit 10
IIC_IBCR2_ADTYPE:   equ    6                                         ; Address Type
IIC_IBCR2_GCEN:     equ    7                                         ; General Call Enable
; bit position masks
mIIC_IBCR2_ADR8:    equ    %00000001
mIIC_IBCR2_ADR9:    equ    %00000010
mIIC_IBCR2_ADR10:   equ    %00000100
mIIC_IBCR2_ADTYPE:  equ    %01000000
mIIC_IBCR2_GCEN:    equ    %10000000


;*** FCLKDIV - Flash Clock Divider Register; 0x00000100 ***
FCLKDIV:            equ    $00000100                                ;*** FCLKDIV - Flash Clock Divider Register; 0x00000100 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FCLKDIV_FDIV0:      equ    0                                         ; Clock Divider Bit 0
FCLKDIV_FDIV1:      equ    1                                         ; Clock Divider Bit 1
FCLKDIV_FDIV2:      equ    2                                         ; Clock Divider Bit 2
FCLKDIV_FDIV3:      equ    3                                         ; Clock Divider Bit 3
FCLKDIV_FDIV4:      equ    4                                         ; Clock Divider Bit 4
FCLKDIV_FDIV5:      equ    5                                         ; Clock Divider Bit 5
FCLKDIV_FDIVLCK:    equ    6                                         ; Clock divider locked
FCLKDIV_FDIVLD:     equ    7                                         ; Clock Divider Loaded
; bit position masks
mFCLKDIV_FDIV0:     equ    %00000001
mFCLKDIV_FDIV1:     equ    %00000010
mFCLKDIV_FDIV2:     equ    %00000100
mFCLKDIV_FDIV3:     equ    %00001000
mFCLKDIV_FDIV4:     equ    %00010000
mFCLKDIV_FDIV5:     equ    %00100000
mFCLKDIV_FDIVLCK:   equ    %01000000
mFCLKDIV_FDIVLD:    equ    %10000000


;*** FSEC - Flash Security Register; 0x00000101 ***
FSEC:               equ    $00000101                                ;*** FSEC - Flash Security Register; 0x00000101 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FSEC_SEC0:          equ    0                                         ; Flash Security Bit 0
FSEC_SEC1:          equ    1                                         ; Flash Security Bit 1
FSEC_RNV2:          equ    2                                         ; Reserved Nonvolatile Bit 2
FSEC_RNV3:          equ    3                                         ; Reserved Nonvolatile Bit 3
FSEC_RNV4:          equ    4                                         ; Reserved Nonvolatile Bit 4
FSEC_RNV5:          equ    5                                         ; Reserved Nonvolatile Bit 5
FSEC_KEYEN0:        equ    6                                         ; Backdoor Key Security Enable Bit 0
FSEC_KEYEN1:        equ    7                                         ; Backdoor Key Security Enable Bit 1
; bit position masks
mFSEC_SEC0:         equ    %00000001
mFSEC_SEC1:         equ    %00000010
mFSEC_RNV2:         equ    %00000100
mFSEC_RNV3:         equ    %00001000
mFSEC_RNV4:         equ    %00010000
mFSEC_RNV5:         equ    %00100000
mFSEC_KEYEN0:       equ    %01000000
mFSEC_KEYEN1:       equ    %10000000


;*** FCCOBIX - Flash CCOB Index Register; 0x00000102 ***
FCCOBIX:            equ    $00000102                                ;*** FCCOBIX - Flash CCOB Index Register; 0x00000102 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FCCOBIX_CCOBIX0:    equ    0                                         ; Common Command Register Index Bit 0
FCCOBIX_CCOBIX1:    equ    1                                         ; Common Command Register Index Bit 1
FCCOBIX_CCOBIX2:    equ    2                                         ; Common Command Register Index Bit 2
; bit position masks
mFCCOBIX_CCOBIX0:   equ    %00000001
mFCCOBIX_CCOBIX1:   equ    %00000010
mFCCOBIX_CCOBIX2:   equ    %00000100


;*** FCNFG - Flash Configuration Register; 0x00000104 ***
FCNFG:              equ    $00000104                                ;*** FCNFG - Flash Configuration Register; 0x00000104 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FCNFG_FSFD:         equ    0                                         ; Force Single Bit Fault Detect
FCNFG_FDFD:         equ    1                                         ; Force Double Bit Fault Detect
FCNFG_IGNSF:        equ    4                                         ; Ignore Single Bit Fault
FCNFG_CCIE:         equ    7                                         ; Command Complete Interrupt Enable
; bit position masks
mFCNFG_FSFD:        equ    %00000001
mFCNFG_FDFD:        equ    %00000010
mFCNFG_IGNSF:       equ    %00010000
mFCNFG_CCIE:        equ    %10000000


;*** FERCNFG - Flash Error Configuration Register; 0x00000105 ***
FERCNFG:            equ    $00000105                                ;*** FERCNFG - Flash Error Configuration Register; 0x00000105 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FERCNFG_SFDIE:      equ    0                                         ; Single Bit Fault Detect Interrupt Enable
FERCNFG_DFDIE:      equ    1                                         ; Double Bit Fault Detect Interrupt Enable
; bit position masks
mFERCNFG_SFDIE:     equ    %00000001
mFERCNFG_DFDIE:     equ    %00000010


;*** FSTAT - Flash Status Register; 0x00000106 ***
FSTAT:              equ    $00000106                                ;*** FSTAT - Flash Status Register; 0x00000106 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FSTAT_MGSTAT0:      equ    0                                         ; Memory Controller Command Completion Status Flag 0
FSTAT_MGSTAT1:      equ    1                                         ; Memory Controller Command Completion Status Flag 1
FSTAT_MGBUSY:       equ    3                                         ; Memory Controller Busy Flag
FSTAT_FPVIOL:       equ    4                                         ; Flash Protection Violation Flag
FSTAT_ACCERR:       equ    5                                         ; Flash Access Error Flag
FSTAT_CCIF:         equ    7                                         ; Command Complete Interrupt Flag
; bit position masks
mFSTAT_MGSTAT0:     equ    %00000001
mFSTAT_MGSTAT1:     equ    %00000010
mFSTAT_MGBUSY:      equ    %00001000
mFSTAT_FPVIOL:      equ    %00010000
mFSTAT_ACCERR:      equ    %00100000
mFSTAT_CCIF:        equ    %10000000


;*** FERSTAT - Flash Error Status Register; 0x00000107 ***
FERSTAT:            equ    $00000107                                ;*** FERSTAT - Flash Error Status Register; 0x00000107 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FERSTAT_SFDIF:      equ    0                                         ; Single Bit Fault Detect Interrupt Flag
FERSTAT_DFDIF:      equ    1                                         ; Double Bit Fault Detect Interrupt Flag
; bit position masks
mFERSTAT_SFDIF:     equ    %00000001
mFERSTAT_DFDIF:     equ    %00000010


;*** FPROT - P-Flash Protection Register; 0x00000108 ***
FPROT:              equ    $00000108                                ;*** FPROT - P-Flash Protection Register; 0x00000108 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FPROT_FPLS0:        equ    0                                         ; Flash Protection Lower Address Size Bit 0
FPROT_FPLS1:        equ    1                                         ; Flash Protection Lower Address Size Bit 1
FPROT_FPLDIS:       equ    2                                         ; Flash Protection Lower Address Range Disable
FPROT_FPHS0:        equ    3                                         ; Flash Protection Higher Address Size Bit 0
FPROT_FPHS1:        equ    4                                         ; Flash Protection Higher Address Size Bit 1
FPROT_FPHDIS:       equ    5                                         ; Flash Protection Higher Address Range Disable
FPROT_RNV6:         equ    6                                         ; Reserved Nonvolatile Bit
FPROT_FPOPEN:       equ    7                                         ; Flash Protection Operation Enable
; bit position masks
mFPROT_FPLS0:       equ    %00000001
mFPROT_FPLS1:       equ    %00000010
mFPROT_FPLDIS:      equ    %00000100
mFPROT_FPHS0:       equ    %00001000
mFPROT_FPHS1:       equ    %00010000
mFPROT_FPHDIS:      equ    %00100000
mFPROT_RNV6:        equ    %01000000
mFPROT_FPOPEN:      equ    %10000000


;*** DFPROT - D-Flash Protection Register; 0x00000109 ***
DFPROT:             equ    $00000109                                ;*** DFPROT - D-Flash Protection Register; 0x00000109 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DFPROT_DPS0:        equ    0                                         ; D-Flash Protection Size Bit 0
DFPROT_DPS1:        equ    1                                         ; D-Flash Protection Size Bit 1
DFPROT_DPS2:        equ    2                                         ; D-Flash Protection Size Bit 2
DFPROT_DPS3:        equ    3                                         ; D-Flash Protection Size Bit 3
DFPROT_DPOPEN:      equ    7                                         ; D-Flash Protection Control
; bit position masks
mDFPROT_DPS0:       equ    %00000001
mDFPROT_DPS1:       equ    %00000010
mDFPROT_DPS2:       equ    %00000100
mDFPROT_DPS3:       equ    %00001000
mDFPROT_DPOPEN:     equ    %10000000


;*** FCCOB - Flash Common Command Object Register; 0x0000010A ***
FCCOB:              equ    $0000010A                                ;*** FCCOB - Flash Common Command Object Register; 0x0000010A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FCCOB_CCOB0:        equ    0                                         ; Flash Common Command Object Bit 0
FCCOB_CCOB1:        equ    1                                         ; Flash Common Command Object Bit 1
FCCOB_CCOB2:        equ    2                                         ; Flash Common Command Object Bit 2
FCCOB_CCOB3:        equ    3                                         ; Flash Common Command Object Bit 3
FCCOB_CCOB4:        equ    4                                         ; Flash Common Command Object Bit 4
FCCOB_CCOB5:        equ    5                                         ; Flash Common Command Object Bit 5
FCCOB_CCOB6:        equ    6                                         ; Flash Common Command Object Bit 6
FCCOB_CCOB7:        equ    7                                         ; Flash Common Command Object Bit 7
FCCOB_CCOB8:        equ    8                                         ; Flash Common Command Object Bit 8
FCCOB_CCOB9:        equ    9                                         ; Flash Common Command Object Bit 9
FCCOB_CCOB10:       equ    10                                        ; Flash Common Command Object Bit 10
FCCOB_CCOB11:       equ    11                                        ; Flash Common Command Object Bit 11
FCCOB_CCOB12:       equ    12                                        ; Flash Common Command Object Bit 12
FCCOB_CCOB13:       equ    13                                        ; Flash Common Command Object Bit 13
FCCOB_CCOB14:       equ    14                                        ; Flash Common Command Object Bit 14
FCCOB_CCOB15:       equ    15                                        ; Flash Common Command Object Bit 15
; bit position masks
mFCCOB_CCOB0:       equ    %00000001
mFCCOB_CCOB1:       equ    %00000010
mFCCOB_CCOB2:       equ    %00000100
mFCCOB_CCOB3:       equ    %00001000
mFCCOB_CCOB4:       equ    %00010000
mFCCOB_CCOB5:       equ    %00100000
mFCCOB_CCOB6:       equ    %01000000
mFCCOB_CCOB7:       equ    %10000000
mFCCOB_CCOB8:       equ    %100000000
mFCCOB_CCOB9:       equ    %1000000000
mFCCOB_CCOB10:      equ    %10000000000
mFCCOB_CCOB11:      equ    %100000000000
mFCCOB_CCOB12:      equ    %1000000000000
mFCCOB_CCOB13:      equ    %10000000000000
mFCCOB_CCOB14:      equ    %100000000000000
mFCCOB_CCOB15:      equ    %1000000000000000


;*** FCCOBHI - Flash Common Command Object Register High; 0x0000010A ***
FCCOBHI:            equ    $0000010A                                ;*** FCCOBHI - Flash Common Command Object Register High; 0x0000010A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FCCOBHI_CCOB8:      equ    0                                         ; Flash Common Command Object Bit 8
FCCOBHI_CCOB9:      equ    1                                         ; Flash Common Command Object Bit 9
FCCOBHI_CCOB10:     equ    2                                         ; Flash Common Command Object Bit 10
FCCOBHI_CCOB11:     equ    3                                         ; Flash Common Command Object Bit 11
FCCOBHI_CCOB12:     equ    4                                         ; Flash Common Command Object Bit 12
FCCOBHI_CCOB13:     equ    5                                         ; Flash Common Command Object Bit 13
FCCOBHI_CCOB14:     equ    6                                         ; Flash Common Command Object Bit 14
FCCOBHI_CCOB15:     equ    7                                         ; Flash Common Command Object Bit 15
; bit position masks
mFCCOBHI_CCOB8:     equ    %00000001
mFCCOBHI_CCOB9:     equ    %00000010
mFCCOBHI_CCOB10:    equ    %00000100
mFCCOBHI_CCOB11:    equ    %00001000
mFCCOBHI_CCOB12:    equ    %00010000
mFCCOBHI_CCOB13:    equ    %00100000
mFCCOBHI_CCOB14:    equ    %01000000
mFCCOBHI_CCOB15:    equ    %10000000


;*** FCCOBLO - Flash Common Command Object Register Low; 0x0000010B ***
FCCOBLO:            equ    $0000010B                                ;*** FCCOBLO - Flash Common Command Object Register Low; 0x0000010B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FCCOBLO_CCOB0:      equ    0                                         ; Flash Common Command Object Bit 0
FCCOBLO_CCOB1:      equ    1                                         ; Flash Common Command Object Bit 1
FCCOBLO_CCOB2:      equ    2                                         ; Flash Common Command Object Bit 2
FCCOBLO_CCOB3:      equ    3                                         ; Flash Common Command Object Bit 3
FCCOBLO_CCOB4:      equ    4                                         ; Flash Common Command Object Bit 4
FCCOBLO_CCOB5:      equ    5                                         ; Flash Common Command Object Bit 5
FCCOBLO_CCOB6:      equ    6                                         ; Flash Common Command Object Bit 6
FCCOBLO_CCOB7:      equ    7                                         ; Flash Common Command Object Bit 7
; bit position masks
mFCCOBLO_CCOB0:     equ    %00000001
mFCCOBLO_CCOB1:     equ    %00000010
mFCCOBLO_CCOB2:     equ    %00000100
mFCCOBLO_CCOB3:     equ    %00001000
mFCCOBLO_CCOB4:     equ    %00010000
mFCCOBLO_CCOB5:     equ    %00100000
mFCCOBLO_CCOB6:     equ    %01000000
mFCCOBLO_CCOB7:     equ    %10000000


;*** FOPT - Flash Option Register; 0x00000110 ***
FOPT:               equ    $00000110                                ;*** FOPT - Flash Option Register; 0x00000110 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FOPT_NV0:           equ    0                                         ; Nonvolatile Bit 0
FOPT_NV1:           equ    1                                         ; Nonvolatile Bit 1
FOPT_NV2:           equ    2                                         ; Nonvolatile Bit 2
FOPT_NV3:           equ    3                                         ; Nonvolatile Bit 3
FOPT_NV4:           equ    4                                         ; Nonvolatile Bit 4
FOPT_NV5:           equ    5                                         ; Nonvolatile Bit 5
FOPT_NV6:           equ    6                                         ; Nonvolatile Bit 6
FOPT_NV7:           equ    7                                         ; Nonvolatile Bit 7
; bit position masks
mFOPT_NV0:          equ    %00000001
mFOPT_NV1:          equ    %00000010
mFOPT_NV2:          equ    %00000100
mFOPT_NV3:          equ    %00001000
mFOPT_NV4:          equ    %00010000
mFOPT_NV5:          equ    %00100000
mFOPT_NV6:          equ    %01000000
mFOPT_NV7:          equ    %10000000


;*** IVBR - Interrupt Vector Base Register; 0x00000120 ***
IVBR:               equ    $00000120                                ;*** IVBR - Interrupt Vector Base Register; 0x00000120 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
IVBR_IVB_ADDR0:     equ    0                                         ; Interrupt Vector Base Address Bits, bit 0
IVBR_IVB_ADDR1:     equ    1                                         ; Interrupt Vector Base Address Bits, bit 1
IVBR_IVB_ADDR2:     equ    2                                         ; Interrupt Vector Base Address Bits, bit 2
IVBR_IVB_ADDR3:     equ    3                                         ; Interrupt Vector Base Address Bits, bit 3
IVBR_IVB_ADDR4:     equ    4                                         ; Interrupt Vector Base Address Bits, bit 4
IVBR_IVB_ADDR5:     equ    5                                         ; Interrupt Vector Base Address Bits, bit 5
IVBR_IVB_ADDR6:     equ    6                                         ; Interrupt Vector Base Address Bits, bit 6
IVBR_IVB_ADDR7:     equ    7                                         ; Interrupt Vector Base Address Bits, bit 7
; bit position masks
mIVBR_IVB_ADDR0:    equ    %00000001
mIVBR_IVB_ADDR1:    equ    %00000010
mIVBR_IVB_ADDR2:    equ    %00000100
mIVBR_IVB_ADDR3:    equ    %00001000
mIVBR_IVB_ADDR4:    equ    %00010000
mIVBR_IVB_ADDR5:    equ    %00100000
mIVBR_IVB_ADDR6:    equ    %01000000
mIVBR_IVB_ADDR7:    equ    %10000000


;*** CANCTL0 - MSCAN Control 0 Register; 0x00000140 ***
CANCTL0:            equ    $00000140                                ;*** CANCTL0 - MSCAN Control 0 Register; 0x00000140 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANCTL0_INITRQ:     equ    0                                         ; Initialization Mode Request
CANCTL0_SLPRQ:      equ    1                                         ; Sleep Mode Request
CANCTL0_WUPE:       equ    2                                         ; Wake-Up Enable
CANCTL0_TIME:       equ    3                                         ; Timer Enable
CANCTL0_SYNCH:      equ    4                                         ; Synchronized Status
CANCTL0_CSWAI:      equ    5                                         ; CAN Stops in Wait Mode
CANCTL0_RXACT:      equ    6                                         ; Receiver Active Status
CANCTL0_RXFRM:      equ    7                                         ; Received Frame Flag
; bit position masks
mCANCTL0_INITRQ:    equ    %00000001
mCANCTL0_SLPRQ:     equ    %00000010
mCANCTL0_WUPE:      equ    %00000100
mCANCTL0_TIME:      equ    %00001000
mCANCTL0_SYNCH:     equ    %00010000
mCANCTL0_CSWAI:     equ    %00100000
mCANCTL0_RXACT:     equ    %01000000
mCANCTL0_RXFRM:     equ    %10000000


;*** CANCTL1 - MSCAN Control 1 Register; 0x00000141 ***
CANCTL1:            equ    $00000141                                ;*** CANCTL1 - MSCAN Control 1 Register; 0x00000141 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANCTL1_INITAK:     equ    0                                         ; Initialization Mode Acknowledge
CANCTL1_SLPAK:      equ    1                                         ; Sleep Mode Acknowledge
CANCTL1_WUPM:       equ    2                                         ; Wake-Up Mode
CANCTL1_BORM:       equ    3                                         ; Bus-Off Recovery Mode
CANCTL1_LISTEN:     equ    4                                         ; Listen Only Mode
CANCTL1_LOOPB:      equ    5                                         ; Loop Back Self Test Mode
CANCTL1_CLKSRC:     equ    6                                         ; MSCAN Clock Source
CANCTL1_CANE:       equ    7                                         ; MSCAN Enable
; bit position masks
mCANCTL1_INITAK:    equ    %00000001
mCANCTL1_SLPAK:     equ    %00000010
mCANCTL1_WUPM:      equ    %00000100
mCANCTL1_BORM:      equ    %00001000
mCANCTL1_LISTEN:    equ    %00010000
mCANCTL1_LOOPB:     equ    %00100000
mCANCTL1_CLKSRC:    equ    %01000000
mCANCTL1_CANE:      equ    %10000000


;*** CANBTR0 - MSCAN Bus Timing Register 0; 0x00000142 ***
CANBTR0:            equ    $00000142                                ;*** CANBTR0 - MSCAN Bus Timing Register 0; 0x00000142 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANBTR0_BRP0:       equ    0                                         ; Baud Rate Prescaler 0
CANBTR0_BRP1:       equ    1                                         ; Baud Rate Prescaler 1
CANBTR0_BRP2:       equ    2                                         ; Baud Rate Prescaler 2
CANBTR0_BRP3:       equ    3                                         ; Baud Rate Prescaler 3
CANBTR0_BRP4:       equ    4                                         ; Baud Rate Prescaler 4
CANBTR0_BRP5:       equ    5                                         ; Baud Rate Prescaler 5
CANBTR0_SJW0:       equ    6                                         ; Synchronization Jump Width 0
CANBTR0_SJW1:       equ    7                                         ; Synchronization Jump Width 1
; bit position masks
mCANBTR0_BRP0:      equ    %00000001
mCANBTR0_BRP1:      equ    %00000010
mCANBTR0_BRP2:      equ    %00000100
mCANBTR0_BRP3:      equ    %00001000
mCANBTR0_BRP4:      equ    %00010000
mCANBTR0_BRP5:      equ    %00100000
mCANBTR0_SJW0:      equ    %01000000
mCANBTR0_SJW1:      equ    %10000000


;*** CANBTR1 - MSCAN Bus Timing Register 1; 0x00000143 ***
CANBTR1:            equ    $00000143                                ;*** CANBTR1 - MSCAN Bus Timing Register 1; 0x00000143 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANBTR1_TSEG10:     equ    0                                         ; Time Segment 10
CANBTR1_TSEG11:     equ    1                                         ; Time Segment 11
CANBTR1_TSEG12:     equ    2                                         ; Time Segment 12
CANBTR1_TSEG13:     equ    3                                         ; Time Segment 13
CANBTR1_TSEG20:     equ    4                                         ; Time Segment 20
CANBTR1_TSEG21:     equ    5                                         ; Time Segment 21
CANBTR1_TSEG22:     equ    6                                         ; Time Segment 22
CANBTR1_SAMP:       equ    7                                         ; Sampling
; bit position masks
mCANBTR1_TSEG10:    equ    %00000001
mCANBTR1_TSEG11:    equ    %00000010
mCANBTR1_TSEG12:    equ    %00000100
mCANBTR1_TSEG13:    equ    %00001000
mCANBTR1_TSEG20:    equ    %00010000
mCANBTR1_TSEG21:    equ    %00100000
mCANBTR1_TSEG22:    equ    %01000000
mCANBTR1_SAMP:      equ    %10000000


;*** CANRFLG - MSCAN Receiver Flag Register; 0x00000144 ***
CANRFLG:            equ    $00000144                                ;*** CANRFLG - MSCAN Receiver Flag Register; 0x00000144 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANRFLG_RXF:        equ    0                                         ; Receive Buffer Full
CANRFLG_OVRIF:      equ    1                                         ; Overrun Interrupt Flag
CANRFLG_TSTAT0:     equ    2                                         ; Transmitter Status Bit 0
CANRFLG_TSTAT1:     equ    3                                         ; Transmitter Status Bit 1
CANRFLG_RSTAT0:     equ    4                                         ; Receiver Status Bit 0
CANRFLG_RSTAT1:     equ    5                                         ; Receiver Status Bit 1
CANRFLG_CSCIF:      equ    6                                         ; CAN Status Change Interrupt Flag
CANRFLG_WUPIF:      equ    7                                         ; Wake-up Interrupt Flag
; bit position masks
mCANRFLG_RXF:       equ    %00000001
mCANRFLG_OVRIF:     equ    %00000010
mCANRFLG_TSTAT0:    equ    %00000100
mCANRFLG_TSTAT1:    equ    %00001000
mCANRFLG_RSTAT0:    equ    %00010000
mCANRFLG_RSTAT1:    equ    %00100000
mCANRFLG_CSCIF:     equ    %01000000
mCANRFLG_WUPIF:     equ    %10000000


;*** CANRIER - MSCAN Receiver Interrupt Enable Register; 0x00000145 ***
CANRIER:            equ    $00000145                                ;*** CANRIER - MSCAN Receiver Interrupt Enable Register; 0x00000145 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANRIER_RXFIE:      equ    0                                         ; Receiver Full Interrupt Enable
CANRIER_OVRIE:      equ    1                                         ; Overrun Interrupt Enable
CANRIER_TSTATE0:    equ    2                                         ; Transmitter Status Change Enable 0
CANRIER_TSTATE1:    equ    3                                         ; Transmitter Status Change Enable 1
CANRIER_RSTATE0:    equ    4                                         ; Receiver Status Change Enable 0
CANRIER_RSTATE1:    equ    5                                         ; Receiver Status Change Enable 1
CANRIER_CSCIE:      equ    6                                         ; CAN Status Change Interrupt Enable
CANRIER_WUPIE:      equ    7                                         ; Wake-up Interrupt Enable
; bit position masks
mCANRIER_RXFIE:     equ    %00000001
mCANRIER_OVRIE:     equ    %00000010
mCANRIER_TSTATE0:   equ    %00000100
mCANRIER_TSTATE1:   equ    %00001000
mCANRIER_RSTATE0:   equ    %00010000
mCANRIER_RSTATE1:   equ    %00100000
mCANRIER_CSCIE:     equ    %01000000
mCANRIER_WUPIE:     equ    %10000000


;*** CANTFLG - MSCAN Transmitter Flag Register; 0x00000146 ***
CANTFLG:            equ    $00000146                                ;*** CANTFLG - MSCAN Transmitter Flag Register; 0x00000146 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANTFLG_TXE0:       equ    0                                         ; Transmitter Buffer Empty 0
CANTFLG_TXE1:       equ    1                                         ; Transmitter Buffer Empty 1
CANTFLG_TXE2:       equ    2                                         ; Transmitter Buffer Empty 2
; bit position masks
mCANTFLG_TXE0:      equ    %00000001
mCANTFLG_TXE1:      equ    %00000010
mCANTFLG_TXE2:      equ    %00000100


;*** CANTIER - MSCAN Transmitter Interrupt Enable Register; 0x00000147 ***
CANTIER:            equ    $00000147                                ;*** CANTIER - MSCAN Transmitter Interrupt Enable Register; 0x00000147 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANTIER_TXEIE0:     equ    0                                         ; Transmitter Empty Interrupt Enable 0
CANTIER_TXEIE1:     equ    1                                         ; Transmitter Empty Interrupt Enable 1
CANTIER_TXEIE2:     equ    2                                         ; Transmitter Empty Interrupt Enable 2
; bit position masks
mCANTIER_TXEIE0:    equ    %00000001
mCANTIER_TXEIE1:    equ    %00000010
mCANTIER_TXEIE2:    equ    %00000100


;*** CANTARQ - MSCAN Transmitter Message Abort Request; 0x00000148 ***
CANTARQ:            equ    $00000148                                ;*** CANTARQ - MSCAN Transmitter Message Abort Request; 0x00000148 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANTARQ_ABTRQ0:     equ    0                                         ; Abort Request 0
CANTARQ_ABTRQ1:     equ    1                                         ; Abort Request 1
CANTARQ_ABTRQ2:     equ    2                                         ; Abort Request 2
; bit position masks
mCANTARQ_ABTRQ0:    equ    %00000001
mCANTARQ_ABTRQ1:    equ    %00000010
mCANTARQ_ABTRQ2:    equ    %00000100


;*** CANTAAK - MSCAN Transmitter Message Abort Acknowledge; 0x00000149 ***
CANTAAK:            equ    $00000149                                ;*** CANTAAK - MSCAN Transmitter Message Abort Acknowledge; 0x00000149 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANTAAK_ABTAK0:     equ    0                                         ; Abort Acknowledge 0
CANTAAK_ABTAK1:     equ    1                                         ; Abort Acknowledge 1
CANTAAK_ABTAK2:     equ    2                                         ; Abort Acknowledge 2
; bit position masks
mCANTAAK_ABTAK0:    equ    %00000001
mCANTAAK_ABTAK1:    equ    %00000010
mCANTAAK_ABTAK2:    equ    %00000100


;*** CANTBSEL - MSCAN Transmit Buffer Selection; 0x0000014A ***
CANTBSEL:           equ    $0000014A                                ;*** CANTBSEL - MSCAN Transmit Buffer Selection; 0x0000014A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANTBSEL_TX0:       equ    0                                         ; Transmit Buffer Select 0
CANTBSEL_TX1:       equ    1                                         ; Transmit Buffer Select 1
CANTBSEL_TX2:       equ    2                                         ; Transmit Buffer Select 2
; bit position masks
mCANTBSEL_TX0:      equ    %00000001
mCANTBSEL_TX1:      equ    %00000010
mCANTBSEL_TX2:      equ    %00000100


;*** CANIDAC - MSCAN Identifier Acceptance Control Register; 0x0000014B ***
CANIDAC:            equ    $0000014B                                ;*** CANIDAC - MSCAN Identifier Acceptance Control Register; 0x0000014B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANIDAC_IDHIT0:     equ    0                                         ; Identifier Acceptance Hit Indicator 0
CANIDAC_IDHIT1:     equ    1                                         ; Identifier Acceptance Hit Indicator 1
CANIDAC_IDHIT2:     equ    2                                         ; Identifier Acceptance Hit Indicator 2
CANIDAC_IDAM0:      equ    4                                         ; Identifier Acceptance Mode 0
CANIDAC_IDAM1:      equ    5                                         ; Identifier Acceptance Mode 1
; bit position masks
mCANIDAC_IDHIT0:    equ    %00000001
mCANIDAC_IDHIT1:    equ    %00000010
mCANIDAC_IDHIT2:    equ    %00000100
mCANIDAC_IDAM0:     equ    %00010000
mCANIDAC_IDAM1:     equ    %00100000


;*** CANMISC - MSCAN Miscellaneous Register; 0x0000014D ***
CANMISC:            equ    $0000014D                                ;*** CANMISC - MSCAN Miscellaneous Register; 0x0000014D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANMISC_BOHOLD:     equ    0                                         ; Bus-off State Hold Until User Request
; bit position masks
mCANMISC_BOHOLD:    equ    %00000001


;*** CANRXERR - MSCAN Receive Error Counter Register; 0x0000014E ***
CANRXERR:           equ    $0000014E                                ;*** CANRXERR - MSCAN Receive Error Counter Register; 0x0000014E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANRXERR_RXERR0:    equ    0                                         ; Bit 0
CANRXERR_RXERR1:    equ    1                                         ; Bit 1
CANRXERR_RXERR2:    equ    2                                         ; Bit 2
CANRXERR_RXERR3:    equ    3                                         ; Bit 3
CANRXERR_RXERR4:    equ    4                                         ; Bit 4
CANRXERR_RXERR5:    equ    5                                         ; Bit 5
CANRXERR_RXERR6:    equ    6                                         ; Bit 6
CANRXERR_RXERR7:    equ    7                                         ; Bit 7
; bit position masks
mCANRXERR_RXERR0:   equ    %00000001
mCANRXERR_RXERR1:   equ    %00000010
mCANRXERR_RXERR2:   equ    %00000100
mCANRXERR_RXERR3:   equ    %00001000
mCANRXERR_RXERR4:   equ    %00010000
mCANRXERR_RXERR5:   equ    %00100000
mCANRXERR_RXERR6:   equ    %01000000
mCANRXERR_RXERR7:   equ    %10000000


;*** CANTXERR - MSCAN Transmit Error Counter Register; 0x0000014F ***
CANTXERR:           equ    $0000014F                                ;*** CANTXERR - MSCAN Transmit Error Counter Register; 0x0000014F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANTXERR_TXERR0:    equ    0                                         ; Bit 0
CANTXERR_TXERR1:    equ    1                                         ; Bit 1
CANTXERR_TXERR2:    equ    2                                         ; Bit 2
CANTXERR_TXERR3:    equ    3                                         ; Bit 3
CANTXERR_TXERR4:    equ    4                                         ; Bit 4
CANTXERR_TXERR5:    equ    5                                         ; Bit 5
CANTXERR_TXERR6:    equ    6                                         ; Bit 6
CANTXERR_TXERR7:    equ    7                                         ; Bit 7
; bit position masks
mCANTXERR_TXERR0:   equ    %00000001
mCANTXERR_TXERR1:   equ    %00000010
mCANTXERR_TXERR2:   equ    %00000100
mCANTXERR_TXERR3:   equ    %00001000
mCANTXERR_TXERR4:   equ    %00010000
mCANTXERR_TXERR5:   equ    %00100000
mCANTXERR_TXERR6:   equ    %01000000
mCANTXERR_TXERR7:   equ    %10000000


;*** CANIDAR0 - MSCAN Identifier Acceptance Register 0; 0x00000150 ***
CANIDAR0:           equ    $00000150                                ;*** CANIDAR0 - MSCAN Identifier Acceptance Register 0; 0x00000150 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANIDAR0_AC0:       equ    0                                         ; Acceptance Code Bit 0
CANIDAR0_AC1:       equ    1                                         ; Acceptance Code Bit 1
CANIDAR0_AC2:       equ    2                                         ; Acceptance Code Bit 2
CANIDAR0_AC3:       equ    3                                         ; Acceptance Code Bit 3
CANIDAR0_AC4:       equ    4                                         ; Acceptance Code Bit 4
CANIDAR0_AC5:       equ    5                                         ; Acceptance Code Bit 5
CANIDAR0_AC6:       equ    6                                         ; Acceptance Code Bit 6
CANIDAR0_AC7:       equ    7                                         ; Acceptance Code Bit 7
; bit position masks
mCANIDAR0_AC0:      equ    %00000001
mCANIDAR0_AC1:      equ    %00000010
mCANIDAR0_AC2:      equ    %00000100
mCANIDAR0_AC3:      equ    %00001000
mCANIDAR0_AC4:      equ    %00010000
mCANIDAR0_AC5:      equ    %00100000
mCANIDAR0_AC6:      equ    %01000000
mCANIDAR0_AC7:      equ    %10000000


;*** CANIDAR1 - MSCAN Identifier Acceptance Register 1; 0x00000151 ***
CANIDAR1:           equ    $00000151                                ;*** CANIDAR1 - MSCAN Identifier Acceptance Register 1; 0x00000151 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANIDAR1_AC0:       equ    0                                         ; Acceptance Code Bit 0
CANIDAR1_AC1:       equ    1                                         ; Acceptance Code Bit 1
CANIDAR1_AC2:       equ    2                                         ; Acceptance Code Bit 2
CANIDAR1_AC3:       equ    3                                         ; Acceptance Code Bit 3
CANIDAR1_AC4:       equ    4                                         ; Acceptance Code Bit 4
CANIDAR1_AC5:       equ    5                                         ; Acceptance Code Bit 5
CANIDAR1_AC6:       equ    6                                         ; Acceptance Code Bit 6
CANIDAR1_AC7:       equ    7                                         ; Acceptance Code Bit 7
; bit position masks
mCANIDAR1_AC0:      equ    %00000001
mCANIDAR1_AC1:      equ    %00000010
mCANIDAR1_AC2:      equ    %00000100
mCANIDAR1_AC3:      equ    %00001000
mCANIDAR1_AC4:      equ    %00010000
mCANIDAR1_AC5:      equ    %00100000
mCANIDAR1_AC6:      equ    %01000000
mCANIDAR1_AC7:      equ    %10000000


;*** CANIDAR2 - MSCAN Identifier Acceptance Register 2; 0x00000152 ***
CANIDAR2:           equ    $00000152                                ;*** CANIDAR2 - MSCAN Identifier Acceptance Register 2; 0x00000152 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANIDAR2_AC0:       equ    0                                         ; Acceptance Code Bit 0
CANIDAR2_AC1:       equ    1                                         ; Acceptance Code Bit 1
CANIDAR2_AC2:       equ    2                                         ; Acceptance Code Bit 2
CANIDAR2_AC3:       equ    3                                         ; Acceptance Code Bit 3
CANIDAR2_AC4:       equ    4                                         ; Acceptance Code Bit 4
CANIDAR2_AC5:       equ    5                                         ; Acceptance Code Bit 5
CANIDAR2_AC6:       equ    6                                         ; Acceptance Code Bit 6
CANIDAR2_AC7:       equ    7                                         ; Acceptance Code Bit 7
; bit position masks
mCANIDAR2_AC0:      equ    %00000001
mCANIDAR2_AC1:      equ    %00000010
mCANIDAR2_AC2:      equ    %00000100
mCANIDAR2_AC3:      equ    %00001000
mCANIDAR2_AC4:      equ    %00010000
mCANIDAR2_AC5:      equ    %00100000
mCANIDAR2_AC6:      equ    %01000000
mCANIDAR2_AC7:      equ    %10000000


;*** CANIDAR3 - MSCAN Identifier Acceptance Register 3; 0x00000153 ***
CANIDAR3:           equ    $00000153                                ;*** CANIDAR3 - MSCAN Identifier Acceptance Register 3; 0x00000153 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANIDAR3_AC0:       equ    0                                         ; Acceptance Code Bit 0
CANIDAR3_AC1:       equ    1                                         ; Acceptance Code Bit 1
CANIDAR3_AC2:       equ    2                                         ; Acceptance Code Bit 2
CANIDAR3_AC3:       equ    3                                         ; Acceptance Code Bit 3
CANIDAR3_AC4:       equ    4                                         ; Acceptance Code Bit 4
CANIDAR3_AC5:       equ    5                                         ; Acceptance Code Bit 5
CANIDAR3_AC6:       equ    6                                         ; Acceptance Code Bit 6
CANIDAR3_AC7:       equ    7                                         ; Acceptance Code Bit 7
; bit position masks
mCANIDAR3_AC0:      equ    %00000001
mCANIDAR3_AC1:      equ    %00000010
mCANIDAR3_AC2:      equ    %00000100
mCANIDAR3_AC3:      equ    %00001000
mCANIDAR3_AC4:      equ    %00010000
mCANIDAR3_AC5:      equ    %00100000
mCANIDAR3_AC6:      equ    %01000000
mCANIDAR3_AC7:      equ    %10000000


;*** CANIDMR0 - MSCAN Identifier Mask Register 0; 0x00000154 ***
CANIDMR0:           equ    $00000154                                ;*** CANIDMR0 - MSCAN Identifier Mask Register 0; 0x00000154 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANIDMR0_AM0:       equ    0                                         ; Acceptance Mask Bit 0
CANIDMR0_AM1:       equ    1                                         ; Acceptance Mask Bit 1
CANIDMR0_AM2:       equ    2                                         ; Acceptance Mask Bit 2
CANIDMR0_AM3:       equ    3                                         ; Acceptance Mask Bit 3
CANIDMR0_AM4:       equ    4                                         ; Acceptance Mask Bit 4
CANIDMR0_AM5:       equ    5                                         ; Acceptance Mask Bit 5
CANIDMR0_AM6:       equ    6                                         ; Acceptance Mask Bit 6
CANIDMR0_AM7:       equ    7                                         ; Acceptance Mask Bit 7
; bit position masks
mCANIDMR0_AM0:      equ    %00000001
mCANIDMR0_AM1:      equ    %00000010
mCANIDMR0_AM2:      equ    %00000100
mCANIDMR0_AM3:      equ    %00001000
mCANIDMR0_AM4:      equ    %00010000
mCANIDMR0_AM5:      equ    %00100000
mCANIDMR0_AM6:      equ    %01000000
mCANIDMR0_AM7:      equ    %10000000


;*** CANIDMR1 - MSCAN Identifier Mask Register 1; 0x00000155 ***
CANIDMR1:           equ    $00000155                                ;*** CANIDMR1 - MSCAN Identifier Mask Register 1; 0x00000155 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANIDMR1_AM0:       equ    0                                         ; Acceptance Mask Bit 0
CANIDMR1_AM1:       equ    1                                         ; Acceptance Mask Bit 1
CANIDMR1_AM2:       equ    2                                         ; Acceptance Mask Bit 2
CANIDMR1_AM3:       equ    3                                         ; Acceptance Mask Bit 3
CANIDMR1_AM4:       equ    4                                         ; Acceptance Mask Bit 4
CANIDMR1_AM5:       equ    5                                         ; Acceptance Mask Bit 5
CANIDMR1_AM6:       equ    6                                         ; Acceptance Mask Bit 6
CANIDMR1_AM7:       equ    7                                         ; Acceptance Mask Bit 7
; bit position masks
mCANIDMR1_AM0:      equ    %00000001
mCANIDMR1_AM1:      equ    %00000010
mCANIDMR1_AM2:      equ    %00000100
mCANIDMR1_AM3:      equ    %00001000
mCANIDMR1_AM4:      equ    %00010000
mCANIDMR1_AM5:      equ    %00100000
mCANIDMR1_AM6:      equ    %01000000
mCANIDMR1_AM7:      equ    %10000000


;*** CANIDMR2 - MSCAN Identifier Mask Register 2; 0x00000156 ***
CANIDMR2:           equ    $00000156                                ;*** CANIDMR2 - MSCAN Identifier Mask Register 2; 0x00000156 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANIDMR2_AM0:       equ    0                                         ; Acceptance Mask Bit 0
CANIDMR2_AM1:       equ    1                                         ; Acceptance Mask Bit 1
CANIDMR2_AM2:       equ    2                                         ; Acceptance Mask Bit 2
CANIDMR2_AM3:       equ    3                                         ; Acceptance Mask Bit 3
CANIDMR2_AM4:       equ    4                                         ; Acceptance Mask Bit 4
CANIDMR2_AM5:       equ    5                                         ; Acceptance Mask Bit 5
CANIDMR2_AM6:       equ    6                                         ; Acceptance Mask Bit 6
CANIDMR2_AM7:       equ    7                                         ; Acceptance Mask Bit 7
; bit position masks
mCANIDMR2_AM0:      equ    %00000001
mCANIDMR2_AM1:      equ    %00000010
mCANIDMR2_AM2:      equ    %00000100
mCANIDMR2_AM3:      equ    %00001000
mCANIDMR2_AM4:      equ    %00010000
mCANIDMR2_AM5:      equ    %00100000
mCANIDMR2_AM6:      equ    %01000000
mCANIDMR2_AM7:      equ    %10000000


;*** CANIDMR3 - MSCAN Identifier Mask Register 3; 0x00000157 ***
CANIDMR3:           equ    $00000157                                ;*** CANIDMR3 - MSCAN Identifier Mask Register 3; 0x00000157 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANIDMR3_AM0:       equ    0                                         ; Acceptance Mask Bit 0
CANIDMR3_AM1:       equ    1                                         ; Acceptance Mask Bit 1
CANIDMR3_AM2:       equ    2                                         ; Acceptance Mask Bit 2
CANIDMR3_AM3:       equ    3                                         ; Acceptance Mask Bit 3
CANIDMR3_AM4:       equ    4                                         ; Acceptance Mask Bit 4
CANIDMR3_AM5:       equ    5                                         ; Acceptance Mask Bit 5
CANIDMR3_AM6:       equ    6                                         ; Acceptance Mask Bit 6
CANIDMR3_AM7:       equ    7                                         ; Acceptance Mask Bit 7
; bit position masks
mCANIDMR3_AM0:      equ    %00000001
mCANIDMR3_AM1:      equ    %00000010
mCANIDMR3_AM2:      equ    %00000100
mCANIDMR3_AM3:      equ    %00001000
mCANIDMR3_AM4:      equ    %00010000
mCANIDMR3_AM5:      equ    %00100000
mCANIDMR3_AM6:      equ    %01000000
mCANIDMR3_AM7:      equ    %10000000


;*** CANIDAR4 - MSCAN Identifier Acceptance Register 4; 0x00000158 ***
CANIDAR4:           equ    $00000158                                ;*** CANIDAR4 - MSCAN Identifier Acceptance Register 4; 0x00000158 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANIDAR4_AC0:       equ    0                                         ; Acceptance Code Bit 0
CANIDAR4_AC1:       equ    1                                         ; Acceptance Code Bit 1
CANIDAR4_AC2:       equ    2                                         ; Acceptance Code Bit 2
CANIDAR4_AC3:       equ    3                                         ; Acceptance Code Bit 3
CANIDAR4_AC4:       equ    4                                         ; Acceptance Code Bit 4
CANIDAR4_AC5:       equ    5                                         ; Acceptance Code Bit 5
CANIDAR4_AC6:       equ    6                                         ; Acceptance Code Bit 6
CANIDAR4_AC7:       equ    7                                         ; Acceptance Code Bit 7
; bit position masks
mCANIDAR4_AC0:      equ    %00000001
mCANIDAR4_AC1:      equ    %00000010
mCANIDAR4_AC2:      equ    %00000100
mCANIDAR4_AC3:      equ    %00001000
mCANIDAR4_AC4:      equ    %00010000
mCANIDAR4_AC5:      equ    %00100000
mCANIDAR4_AC6:      equ    %01000000
mCANIDAR4_AC7:      equ    %10000000


;*** CANIDAR5 - MSCAN Identifier Acceptance Register 5; 0x00000159 ***
CANIDAR5:           equ    $00000159                                ;*** CANIDAR5 - MSCAN Identifier Acceptance Register 5; 0x00000159 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANIDAR5_AC0:       equ    0                                         ; Acceptance Code Bit 0
CANIDAR5_AC1:       equ    1                                         ; Acceptance Code Bit 1
CANIDAR5_AC2:       equ    2                                         ; Acceptance Code Bit 2
CANIDAR5_AC3:       equ    3                                         ; Acceptance Code Bit 3
CANIDAR5_AC4:       equ    4                                         ; Acceptance Code Bit 4
CANIDAR5_AC5:       equ    5                                         ; Acceptance Code Bit 5
CANIDAR5_AC6:       equ    6                                         ; Acceptance Code Bit 6
CANIDAR5_AC7:       equ    7                                         ; Acceptance Code Bit 7
; bit position masks
mCANIDAR5_AC0:      equ    %00000001
mCANIDAR5_AC1:      equ    %00000010
mCANIDAR5_AC2:      equ    %00000100
mCANIDAR5_AC3:      equ    %00001000
mCANIDAR5_AC4:      equ    %00010000
mCANIDAR5_AC5:      equ    %00100000
mCANIDAR5_AC6:      equ    %01000000
mCANIDAR5_AC7:      equ    %10000000


;*** CANIDAR6 - MSCAN Identifier Acceptance Register 6; 0x0000015A ***
CANIDAR6:           equ    $0000015A                                ;*** CANIDAR6 - MSCAN Identifier Acceptance Register 6; 0x0000015A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANIDAR6_AC0:       equ    0                                         ; Acceptance Code Bit 0
CANIDAR6_AC1:       equ    1                                         ; Acceptance Code Bit 1
CANIDAR6_AC2:       equ    2                                         ; Acceptance Code Bit 2
CANIDAR6_AC3:       equ    3                                         ; Acceptance Code Bit 3
CANIDAR6_AC4:       equ    4                                         ; Acceptance Code Bit 4
CANIDAR6_AC5:       equ    5                                         ; Acceptance Code Bit 5
CANIDAR6_AC6:       equ    6                                         ; Acceptance Code Bit 6
CANIDAR6_AC7:       equ    7                                         ; Acceptance Code Bit 7
; bit position masks
mCANIDAR6_AC0:      equ    %00000001
mCANIDAR6_AC1:      equ    %00000010
mCANIDAR6_AC2:      equ    %00000100
mCANIDAR6_AC3:      equ    %00001000
mCANIDAR6_AC4:      equ    %00010000
mCANIDAR6_AC5:      equ    %00100000
mCANIDAR6_AC6:      equ    %01000000
mCANIDAR6_AC7:      equ    %10000000


;*** CANIDAR7 - MSCAN Identifier Acceptance Register 7; 0x0000015B ***
CANIDAR7:           equ    $0000015B                                ;*** CANIDAR7 - MSCAN Identifier Acceptance Register 7; 0x0000015B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANIDAR7_AC0:       equ    0                                         ; Acceptance Code Bit 0
CANIDAR7_AC1:       equ    1                                         ; Acceptance Code Bit 1
CANIDAR7_AC2:       equ    2                                         ; Acceptance Code Bit 2
CANIDAR7_AC3:       equ    3                                         ; Acceptance Code Bit 3
CANIDAR7_AC4:       equ    4                                         ; Acceptance Code Bit 4
CANIDAR7_AC5:       equ    5                                         ; Acceptance Code Bit 5
CANIDAR7_AC6:       equ    6                                         ; Acceptance Code Bit 6
CANIDAR7_AC7:       equ    7                                         ; Acceptance Code Bit 7
; bit position masks
mCANIDAR7_AC0:      equ    %00000001
mCANIDAR7_AC1:      equ    %00000010
mCANIDAR7_AC2:      equ    %00000100
mCANIDAR7_AC3:      equ    %00001000
mCANIDAR7_AC4:      equ    %00010000
mCANIDAR7_AC5:      equ    %00100000
mCANIDAR7_AC6:      equ    %01000000
mCANIDAR7_AC7:      equ    %10000000


;*** CANIDMR4 - MSCAN Identifier Mask Register 4; 0x0000015C ***
CANIDMR4:           equ    $0000015C                                ;*** CANIDMR4 - MSCAN Identifier Mask Register 4; 0x0000015C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANIDMR4_AM0:       equ    0                                         ; Acceptance Mask Bit 0
CANIDMR4_AM1:       equ    1                                         ; Acceptance Mask Bit 1
CANIDMR4_AM2:       equ    2                                         ; Acceptance Mask Bit 2
CANIDMR4_AM3:       equ    3                                         ; Acceptance Mask Bit 3
CANIDMR4_AM4:       equ    4                                         ; Acceptance Mask Bit 4
CANIDMR4_AM5:       equ    5                                         ; Acceptance Mask Bit 5
CANIDMR4_AM6:       equ    6                                         ; Acceptance Mask Bit 6
CANIDMR4_AM7:       equ    7                                         ; Acceptance Mask Bit 7
; bit position masks
mCANIDMR4_AM0:      equ    %00000001
mCANIDMR4_AM1:      equ    %00000010
mCANIDMR4_AM2:      equ    %00000100
mCANIDMR4_AM3:      equ    %00001000
mCANIDMR4_AM4:      equ    %00010000
mCANIDMR4_AM5:      equ    %00100000
mCANIDMR4_AM6:      equ    %01000000
mCANIDMR4_AM7:      equ    %10000000


;*** CANIDMR5 - MSCAN Identifier Mask Register 5; 0x0000015D ***
CANIDMR5:           equ    $0000015D                                ;*** CANIDMR5 - MSCAN Identifier Mask Register 5; 0x0000015D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANIDMR5_AM0:       equ    0                                         ; Acceptance Mask Bit 0
CANIDMR5_AM1:       equ    1                                         ; Acceptance Mask Bit 1
CANIDMR5_AM2:       equ    2                                         ; Acceptance Mask Bit 2
CANIDMR5_AM3:       equ    3                                         ; Acceptance Mask Bit 3
CANIDMR5_AM4:       equ    4                                         ; Acceptance Mask Bit 4
CANIDMR5_AM5:       equ    5                                         ; Acceptance Mask Bit 5
CANIDMR5_AM6:       equ    6                                         ; Acceptance Mask Bit 6
CANIDMR5_AM7:       equ    7                                         ; Acceptance Mask Bit 7
; bit position masks
mCANIDMR5_AM0:      equ    %00000001
mCANIDMR5_AM1:      equ    %00000010
mCANIDMR5_AM2:      equ    %00000100
mCANIDMR5_AM3:      equ    %00001000
mCANIDMR5_AM4:      equ    %00010000
mCANIDMR5_AM5:      equ    %00100000
mCANIDMR5_AM6:      equ    %01000000
mCANIDMR5_AM7:      equ    %10000000


;*** CANIDMR6 - MSCAN Identifier Mask Register 6; 0x0000015E ***
CANIDMR6:           equ    $0000015E                                ;*** CANIDMR6 - MSCAN Identifier Mask Register 6; 0x0000015E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANIDMR6_AM0:       equ    0                                         ; Acceptance Mask Bit 0
CANIDMR6_AM1:       equ    1                                         ; Acceptance Mask Bit 1
CANIDMR6_AM2:       equ    2                                         ; Acceptance Mask Bit 2
CANIDMR6_AM3:       equ    3                                         ; Acceptance Mask Bit 3
CANIDMR6_AM4:       equ    4                                         ; Acceptance Mask Bit 4
CANIDMR6_AM5:       equ    5                                         ; Acceptance Mask Bit 5
CANIDMR6_AM6:       equ    6                                         ; Acceptance Mask Bit 6
CANIDMR6_AM7:       equ    7                                         ; Acceptance Mask Bit 7
; bit position masks
mCANIDMR6_AM0:      equ    %00000001
mCANIDMR6_AM1:      equ    %00000010
mCANIDMR6_AM2:      equ    %00000100
mCANIDMR6_AM3:      equ    %00001000
mCANIDMR6_AM4:      equ    %00010000
mCANIDMR6_AM5:      equ    %00100000
mCANIDMR6_AM6:      equ    %01000000
mCANIDMR6_AM7:      equ    %10000000


;*** CANIDMR7 - MSCAN Identifier Mask Register 7; 0x0000015F ***
CANIDMR7:           equ    $0000015F                                ;*** CANIDMR7 - MSCAN Identifier Mask Register 7; 0x0000015F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANIDMR7_AM0:       equ    0                                         ; Acceptance Mask Bit 0
CANIDMR7_AM1:       equ    1                                         ; Acceptance Mask Bit 1
CANIDMR7_AM2:       equ    2                                         ; Acceptance Mask Bit 2
CANIDMR7_AM3:       equ    3                                         ; Acceptance Mask Bit 3
CANIDMR7_AM4:       equ    4                                         ; Acceptance Mask Bit 4
CANIDMR7_AM5:       equ    5                                         ; Acceptance Mask Bit 5
CANIDMR7_AM6:       equ    6                                         ; Acceptance Mask Bit 6
CANIDMR7_AM7:       equ    7                                         ; Acceptance Mask Bit 7
; bit position masks
mCANIDMR7_AM0:      equ    %00000001
mCANIDMR7_AM1:      equ    %00000010
mCANIDMR7_AM2:      equ    %00000100
mCANIDMR7_AM3:      equ    %00001000
mCANIDMR7_AM4:      equ    %00010000
mCANIDMR7_AM5:      equ    %00100000
mCANIDMR7_AM6:      equ    %01000000
mCANIDMR7_AM7:      equ    %10000000


;*** CANRXIDR0 - MSCAN Receive Identifier Register 0; 0x00000160 ***
CANRXIDR0:          equ    $00000160                                ;*** CANRXIDR0 - MSCAN Receive Identifier Register 0; 0x00000160 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANRXIDR0_ID21:     equ    0                                         ; Extended format identifier Bit 21
CANRXIDR0_ID22:     equ    1                                         ; Extended format identifier Bit 22
CANRXIDR0_ID23:     equ    2                                         ; Extended format identifier Bit 23
CANRXIDR0_ID24:     equ    3                                         ; Extended format identifier Bit 24
CANRXIDR0_ID25:     equ    4                                         ; Extended format identifier Bit 25
CANRXIDR0_ID26:     equ    5                                         ; Extended format identifier Bit 26
CANRXIDR0_ID27:     equ    6                                         ; Extended format identifier Bit 27
CANRXIDR0_ID28:     equ    7                                         ; Extended format identifier Bit 28
; bit position masks
mCANRXIDR0_ID21:    equ    %00000001
mCANRXIDR0_ID22:    equ    %00000010
mCANRXIDR0_ID23:    equ    %00000100
mCANRXIDR0_ID24:    equ    %00001000
mCANRXIDR0_ID25:    equ    %00010000
mCANRXIDR0_ID26:    equ    %00100000
mCANRXIDR0_ID27:    equ    %01000000
mCANRXIDR0_ID28:    equ    %10000000


;*** CANRXIDR1 - MSCAN Receive Identifier Register 1; 0x00000161 ***
CANRXIDR1:          equ    $00000161                                ;*** CANRXIDR1 - MSCAN Receive Identifier Register 1; 0x00000161 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANRXIDR1_ID15:     equ    0                                         ; Extended format identifier Bit 15
CANRXIDR1_ID16:     equ    1                                         ; Extended format identifier Bit 16
CANRXIDR1_ID17:     equ    2                                         ; Extended format identifier Bit 17
CANRXIDR1_IDE:      equ    3                                         ; ID Extended
CANRXIDR1_SRR:      equ    4                                         ; Substitute Remote Request
CANRXIDR1_ID18:     equ    5                                         ; Extended format identifier Bit 18
CANRXIDR1_ID19:     equ    6                                         ; Extended format identifier Bit 19
CANRXIDR1_ID20:     equ    7                                         ; Extended format identifier Bit 20
; bit position masks
mCANRXIDR1_ID15:    equ    %00000001
mCANRXIDR1_ID16:    equ    %00000010
mCANRXIDR1_ID17:    equ    %00000100
mCANRXIDR1_IDE:     equ    %00001000
mCANRXIDR1_SRR:     equ    %00010000
mCANRXIDR1_ID18:    equ    %00100000
mCANRXIDR1_ID19:    equ    %01000000
mCANRXIDR1_ID20:    equ    %10000000


;*** CANRXIDR2 - MSCAN Receive Identifier Register 2; 0x00000162 ***
CANRXIDR2:          equ    $00000162                                ;*** CANRXIDR2 - MSCAN Receive Identifier Register 2; 0x00000162 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANRXIDR2_ID7:      equ    0                                         ; Extended format identifier Bit 7
CANRXIDR2_ID8:      equ    1                                         ; Extended format identifier Bit 8
CANRXIDR2_ID9:      equ    2                                         ; Extended format identifier Bit 9
CANRXIDR2_ID10:     equ    3                                         ; Extended format identifier Bit 10
CANRXIDR2_ID11:     equ    4                                         ; Extended format identifier Bit 11
CANRXIDR2_ID12:     equ    5                                         ; Extended format identifier Bit 12
CANRXIDR2_ID13:     equ    6                                         ; Extended format identifier Bit 13
CANRXIDR2_ID14:     equ    7                                         ; Extended format identifier Bit 14
; bit position masks
mCANRXIDR2_ID7:     equ    %00000001
mCANRXIDR2_ID8:     equ    %00000010
mCANRXIDR2_ID9:     equ    %00000100
mCANRXIDR2_ID10:    equ    %00001000
mCANRXIDR2_ID11:    equ    %00010000
mCANRXIDR2_ID12:    equ    %00100000
mCANRXIDR2_ID13:    equ    %01000000
mCANRXIDR2_ID14:    equ    %10000000


;*** CANRXIDR3 - MSCAN Receive Identifier Register 3; 0x00000163 ***
CANRXIDR3:          equ    $00000163                                ;*** CANRXIDR3 - MSCAN Receive Identifier Register 3; 0x00000163 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANRXIDR3_RTR:      equ    0                                         ; Remote Transmission Request
CANRXIDR3_ID0:      equ    1                                         ; Extended format identifier Bit 0
CANRXIDR3_ID1:      equ    2                                         ; Extended format identifier Bit 1
CANRXIDR3_ID2:      equ    3                                         ; Extended format identifier Bit 2
CANRXIDR3_ID3:      equ    4                                         ; Extended format identifier Bit 3
CANRXIDR3_ID4:      equ    5                                         ; Extended format identifier Bit 4
CANRXIDR3_ID5:      equ    6                                         ; Extended format identifier Bit 5
CANRXIDR3_ID6:      equ    7                                         ; Extended format identifier Bit 6
; bit position masks
mCANRXIDR3_RTR:     equ    %00000001
mCANRXIDR3_ID0:     equ    %00000010
mCANRXIDR3_ID1:     equ    %00000100
mCANRXIDR3_ID2:     equ    %00001000
mCANRXIDR3_ID3:     equ    %00010000
mCANRXIDR3_ID4:     equ    %00100000
mCANRXIDR3_ID5:     equ    %01000000
mCANRXIDR3_ID6:     equ    %10000000


;*** CANRXDSR0 - MSCAN Receive Data Segment Register 0; 0x00000164 ***
CANRXDSR0:          equ    $00000164                                ;*** CANRXDSR0 - MSCAN Receive Data Segment Register 0; 0x00000164 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANRXDSR0_DB0:      equ    0                                         ; Data Bit 0
CANRXDSR0_DB1:      equ    1                                         ; Data Bit 1
CANRXDSR0_DB2:      equ    2                                         ; Data Bit 2
CANRXDSR0_DB3:      equ    3                                         ; Data Bit 3
CANRXDSR0_DB4:      equ    4                                         ; Data Bit 4
CANRXDSR0_DB5:      equ    5                                         ; Data Bit 5
CANRXDSR0_DB6:      equ    6                                         ; Data Bit 6
CANRXDSR0_DB7:      equ    7                                         ; Data Bit 7
; bit position masks
mCANRXDSR0_DB0:     equ    %00000001
mCANRXDSR0_DB1:     equ    %00000010
mCANRXDSR0_DB2:     equ    %00000100
mCANRXDSR0_DB3:     equ    %00001000
mCANRXDSR0_DB4:     equ    %00010000
mCANRXDSR0_DB5:     equ    %00100000
mCANRXDSR0_DB6:     equ    %01000000
mCANRXDSR0_DB7:     equ    %10000000


;*** CANRXDSR1 - MSCAN Receive Data Segment Register 1; 0x00000165 ***
CANRXDSR1:          equ    $00000165                                ;*** CANRXDSR1 - MSCAN Receive Data Segment Register 1; 0x00000165 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANRXDSR1_DB0:      equ    0                                         ; Data Bit 0
CANRXDSR1_DB1:      equ    1                                         ; Data Bit 1
CANRXDSR1_DB2:      equ    2                                         ; Data Bit 2
CANRXDSR1_DB3:      equ    3                                         ; Data Bit 3
CANRXDSR1_DB4:      equ    4                                         ; Data Bit 4
CANRXDSR1_DB5:      equ    5                                         ; Data Bit 5
CANRXDSR1_DB6:      equ    6                                         ; Data Bit 6
CANRXDSR1_DB7:      equ    7                                         ; Data Bit 7
; bit position masks
mCANRXDSR1_DB0:     equ    %00000001
mCANRXDSR1_DB1:     equ    %00000010
mCANRXDSR1_DB2:     equ    %00000100
mCANRXDSR1_DB3:     equ    %00001000
mCANRXDSR1_DB4:     equ    %00010000
mCANRXDSR1_DB5:     equ    %00100000
mCANRXDSR1_DB6:     equ    %01000000
mCANRXDSR1_DB7:     equ    %10000000


;*** CANRXDSR2 - MSCAN Receive Data Segment Register 2; 0x00000166 ***
CANRXDSR2:          equ    $00000166                                ;*** CANRXDSR2 - MSCAN Receive Data Segment Register 2; 0x00000166 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANRXDSR2_DB0:      equ    0                                         ; Data Bit 0
CANRXDSR2_DB1:      equ    1                                         ; Data Bit 1
CANRXDSR2_DB2:      equ    2                                         ; Data Bit 2
CANRXDSR2_DB3:      equ    3                                         ; Data Bit 3
CANRXDSR2_DB4:      equ    4                                         ; Data Bit 4
CANRXDSR2_DB5:      equ    5                                         ; Data Bit 5
CANRXDSR2_DB6:      equ    6                                         ; Data Bit 6
CANRXDSR2_DB7:      equ    7                                         ; Data Bit 7
; bit position masks
mCANRXDSR2_DB0:     equ    %00000001
mCANRXDSR2_DB1:     equ    %00000010
mCANRXDSR2_DB2:     equ    %00000100
mCANRXDSR2_DB3:     equ    %00001000
mCANRXDSR2_DB4:     equ    %00010000
mCANRXDSR2_DB5:     equ    %00100000
mCANRXDSR2_DB6:     equ    %01000000
mCANRXDSR2_DB7:     equ    %10000000


;*** CANRXDSR3 - MSCAN Receive Data Segment Register 3; 0x00000167 ***
CANRXDSR3:          equ    $00000167                                ;*** CANRXDSR3 - MSCAN Receive Data Segment Register 3; 0x00000167 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANRXDSR3_DB0:      equ    0                                         ; Data Bit 0
CANRXDSR3_DB1:      equ    1                                         ; Data Bit 1
CANRXDSR3_DB2:      equ    2                                         ; Data Bit 2
CANRXDSR3_DB3:      equ    3                                         ; Data Bit 3
CANRXDSR3_DB4:      equ    4                                         ; Data Bit 4
CANRXDSR3_DB5:      equ    5                                         ; Data Bit 5
CANRXDSR3_DB6:      equ    6                                         ; Data Bit 6
CANRXDSR3_DB7:      equ    7                                         ; Data Bit 7
; bit position masks
mCANRXDSR3_DB0:     equ    %00000001
mCANRXDSR3_DB1:     equ    %00000010
mCANRXDSR3_DB2:     equ    %00000100
mCANRXDSR3_DB3:     equ    %00001000
mCANRXDSR3_DB4:     equ    %00010000
mCANRXDSR3_DB5:     equ    %00100000
mCANRXDSR3_DB6:     equ    %01000000
mCANRXDSR3_DB7:     equ    %10000000


;*** CANRXDSR4 - MSCAN Receive Data Segment Register 4; 0x00000168 ***
CANRXDSR4:          equ    $00000168                                ;*** CANRXDSR4 - MSCAN Receive Data Segment Register 4; 0x00000168 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANRXDSR4_DB0:      equ    0                                         ; Data Bit 0
CANRXDSR4_DB1:      equ    1                                         ; Data Bit 1
CANRXDSR4_DB2:      equ    2                                         ; Data Bit 2
CANRXDSR4_DB3:      equ    3                                         ; Data Bit 3
CANRXDSR4_DB4:      equ    4                                         ; Data Bit 4
CANRXDSR4_DB5:      equ    5                                         ; Data Bit 5
CANRXDSR4_DB6:      equ    6                                         ; Data Bit 6
CANRXDSR4_DB7:      equ    7                                         ; Data Bit 7
; bit position masks
mCANRXDSR4_DB0:     equ    %00000001
mCANRXDSR4_DB1:     equ    %00000010
mCANRXDSR4_DB2:     equ    %00000100
mCANRXDSR4_DB3:     equ    %00001000
mCANRXDSR4_DB4:     equ    %00010000
mCANRXDSR4_DB5:     equ    %00100000
mCANRXDSR4_DB6:     equ    %01000000
mCANRXDSR4_DB7:     equ    %10000000


;*** CANRXDSR5 - MSCAN Receive Data Segment Register 5; 0x00000169 ***
CANRXDSR5:          equ    $00000169                                ;*** CANRXDSR5 - MSCAN Receive Data Segment Register 5; 0x00000169 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANRXDSR5_DB0:      equ    0                                         ; Data Bit 0
CANRXDSR5_DB1:      equ    1                                         ; Data Bit 1
CANRXDSR5_DB2:      equ    2                                         ; Data Bit 2
CANRXDSR5_DB3:      equ    3                                         ; Data Bit 3
CANRXDSR5_DB4:      equ    4                                         ; Data Bit 4
CANRXDSR5_DB5:      equ    5                                         ; Data Bit 5
CANRXDSR5_DB6:      equ    6                                         ; Data Bit 6
CANRXDSR5_DB7:      equ    7                                         ; Data Bit 7
; bit position masks
mCANRXDSR5_DB0:     equ    %00000001
mCANRXDSR5_DB1:     equ    %00000010
mCANRXDSR5_DB2:     equ    %00000100
mCANRXDSR5_DB3:     equ    %00001000
mCANRXDSR5_DB4:     equ    %00010000
mCANRXDSR5_DB5:     equ    %00100000
mCANRXDSR5_DB6:     equ    %01000000
mCANRXDSR5_DB7:     equ    %10000000


;*** CANRXDSR6 - MSCAN Receive Data Segment Register 6; 0x0000016A ***
CANRXDSR6:          equ    $0000016A                                ;*** CANRXDSR6 - MSCAN Receive Data Segment Register 6; 0x0000016A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANRXDSR6_DB0:      equ    0                                         ; Data Bit 0
CANRXDSR6_DB1:      equ    1                                         ; Data Bit 1
CANRXDSR6_DB2:      equ    2                                         ; Data Bit 2
CANRXDSR6_DB3:      equ    3                                         ; Data Bit 3
CANRXDSR6_DB4:      equ    4                                         ; Data Bit 4
CANRXDSR6_DB5:      equ    5                                         ; Data Bit 5
CANRXDSR6_DB6:      equ    6                                         ; Data Bit 6
CANRXDSR6_DB7:      equ    7                                         ; Data Bit 7
; bit position masks
mCANRXDSR6_DB0:     equ    %00000001
mCANRXDSR6_DB1:     equ    %00000010
mCANRXDSR6_DB2:     equ    %00000100
mCANRXDSR6_DB3:     equ    %00001000
mCANRXDSR6_DB4:     equ    %00010000
mCANRXDSR6_DB5:     equ    %00100000
mCANRXDSR6_DB6:     equ    %01000000
mCANRXDSR6_DB7:     equ    %10000000


;*** CANRXDSR7 - MSCAN Receive Data Segment Register 7; 0x0000016B ***
CANRXDSR7:          equ    $0000016B                                ;*** CANRXDSR7 - MSCAN Receive Data Segment Register 7; 0x0000016B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANRXDSR7_DB0:      equ    0                                         ; Data Bit 0
CANRXDSR7_DB1:      equ    1                                         ; Data Bit 1
CANRXDSR7_DB2:      equ    2                                         ; Data Bit 2
CANRXDSR7_DB3:      equ    3                                         ; Data Bit 3
CANRXDSR7_DB4:      equ    4                                         ; Data Bit 4
CANRXDSR7_DB5:      equ    5                                         ; Data Bit 5
CANRXDSR7_DB6:      equ    6                                         ; Data Bit 6
CANRXDSR7_DB7:      equ    7                                         ; Data Bit 7
; bit position masks
mCANRXDSR7_DB0:     equ    %00000001
mCANRXDSR7_DB1:     equ    %00000010
mCANRXDSR7_DB2:     equ    %00000100
mCANRXDSR7_DB3:     equ    %00001000
mCANRXDSR7_DB4:     equ    %00010000
mCANRXDSR7_DB5:     equ    %00100000
mCANRXDSR7_DB6:     equ    %01000000
mCANRXDSR7_DB7:     equ    %10000000


;*** CANRXDLR - MSCAN Receive Data Length Register; 0x0000016C ***
CANRXDLR:           equ    $0000016C                                ;*** CANRXDLR - MSCAN Receive Data Length Register; 0x0000016C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANRXDLR_DLC0:      equ    0                                         ; Data Length Code Bit 0
CANRXDLR_DLC1:      equ    1                                         ; Data Length Code Bit 1
CANRXDLR_DLC2:      equ    2                                         ; Data Length Code Bit 2
CANRXDLR_DLC3:      equ    3                                         ; Data Length Code Bit 3
; bit position masks
mCANRXDLR_DLC0:     equ    %00000001
mCANRXDLR_DLC1:     equ    %00000010
mCANRXDLR_DLC2:     equ    %00000100
mCANRXDLR_DLC3:     equ    %00001000


;*** CANRXTSR - MSCAN Receive Time Stamp Register; 0x0000016E ***
CANRXTSR:           equ    $0000016E                                ;*** CANRXTSR - MSCAN Receive Time Stamp Register; 0x0000016E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANRXTSR_TSR0:      equ    0                                         ; Time Stamp Bit 0
CANRXTSR_TSR1:      equ    1                                         ; Time Stamp Bit 1
CANRXTSR_TSR2:      equ    2                                         ; Time Stamp Bit 2
CANRXTSR_TSR3:      equ    3                                         ; Time Stamp Bit 3
CANRXTSR_TSR4:      equ    4                                         ; Time Stamp Bit 4
CANRXTSR_TSR5:      equ    5                                         ; Time Stamp Bit 5
CANRXTSR_TSR6:      equ    6                                         ; Time Stamp Bit 6
CANRXTSR_TSR7:      equ    7                                         ; Time Stamp Bit 7
CANRXTSR_TSR8:      equ    8                                         ; Time Stamp Bit 8
CANRXTSR_TSR9:      equ    9                                         ; Time Stamp Bit 9
CANRXTSR_TSR10:     equ    10                                        ; Time Stamp Bit 10
CANRXTSR_TSR11:     equ    11                                        ; Time Stamp Bit 11
CANRXTSR_TSR12:     equ    12                                        ; Time Stamp Bit 12
CANRXTSR_TSR13:     equ    13                                        ; Time Stamp Bit 13
CANRXTSR_TSR14:     equ    14                                        ; Time Stamp Bit 14
CANRXTSR_TSR15:     equ    15                                        ; Time Stamp Bit 15
; bit position masks
mCANRXTSR_TSR0:     equ    %00000001
mCANRXTSR_TSR1:     equ    %00000010
mCANRXTSR_TSR2:     equ    %00000100
mCANRXTSR_TSR3:     equ    %00001000
mCANRXTSR_TSR4:     equ    %00010000
mCANRXTSR_TSR5:     equ    %00100000
mCANRXTSR_TSR6:     equ    %01000000
mCANRXTSR_TSR7:     equ    %10000000
mCANRXTSR_TSR8:     equ    %100000000
mCANRXTSR_TSR9:     equ    %1000000000
mCANRXTSR_TSR10:    equ    %10000000000
mCANRXTSR_TSR11:    equ    %100000000000
mCANRXTSR_TSR12:    equ    %1000000000000
mCANRXTSR_TSR13:    equ    %10000000000000
mCANRXTSR_TSR14:    equ    %100000000000000
mCANRXTSR_TSR15:    equ    %1000000000000000


;*** CANRXTSRH - MSCAN Receive Time Stamp Register High; 0x0000016E ***
CANRXTSRH:          equ    $0000016E                                ;*** CANRXTSRH - MSCAN Receive Time Stamp Register High; 0x0000016E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANRXTSRH_TSR8:     equ    0                                         ; Time Stamp Bit 8
CANRXTSRH_TSR9:     equ    1                                         ; Time Stamp Bit 9
CANRXTSRH_TSR10:    equ    2                                         ; Time Stamp Bit 10
CANRXTSRH_TSR11:    equ    3                                         ; Time Stamp Bit 11
CANRXTSRH_TSR12:    equ    4                                         ; Time Stamp Bit 12
CANRXTSRH_TSR13:    equ    5                                         ; Time Stamp Bit 13
CANRXTSRH_TSR14:    equ    6                                         ; Time Stamp Bit 14
CANRXTSRH_TSR15:    equ    7                                         ; Time Stamp Bit 15
; bit position masks
mCANRXTSRH_TSR8:    equ    %00000001
mCANRXTSRH_TSR9:    equ    %00000010
mCANRXTSRH_TSR10:   equ    %00000100
mCANRXTSRH_TSR11:   equ    %00001000
mCANRXTSRH_TSR12:   equ    %00010000
mCANRXTSRH_TSR13:   equ    %00100000
mCANRXTSRH_TSR14:   equ    %01000000
mCANRXTSRH_TSR15:   equ    %10000000


;*** CANRXTSRL - MSCAN Receive Time Stamp Register Low; 0x0000016F ***
CANRXTSRL:          equ    $0000016F                                ;*** CANRXTSRL - MSCAN Receive Time Stamp Register Low; 0x0000016F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANRXTSRL_TSR0:     equ    0                                         ; Time Stamp Bit 0
CANRXTSRL_TSR1:     equ    1                                         ; Time Stamp Bit 1
CANRXTSRL_TSR2:     equ    2                                         ; Time Stamp Bit 2
CANRXTSRL_TSR3:     equ    3                                         ; Time Stamp Bit 3
CANRXTSRL_TSR4:     equ    4                                         ; Time Stamp Bit 4
CANRXTSRL_TSR5:     equ    5                                         ; Time Stamp Bit 5
CANRXTSRL_TSR6:     equ    6                                         ; Time Stamp Bit 6
CANRXTSRL_TSR7:     equ    7                                         ; Time Stamp Bit 7
; bit position masks
mCANRXTSRL_TSR0:    equ    %00000001
mCANRXTSRL_TSR1:    equ    %00000010
mCANRXTSRL_TSR2:    equ    %00000100
mCANRXTSRL_TSR3:    equ    %00001000
mCANRXTSRL_TSR4:    equ    %00010000
mCANRXTSRL_TSR5:    equ    %00100000
mCANRXTSRL_TSR6:    equ    %01000000
mCANRXTSRL_TSR7:    equ    %10000000


;*** CANTXIDR0 - MSCAN Transmit Identifier Register 0; 0x00000170 ***
CANTXIDR0:          equ    $00000170                                ;*** CANTXIDR0 - MSCAN Transmit Identifier Register 0; 0x00000170 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANTXIDR0_ID21:     equ    0                                         ; Extended format identifier Bit 21
CANTXIDR0_ID22:     equ    1                                         ; Extended format identifier Bit 22
CANTXIDR0_ID23:     equ    2                                         ; Extended format identifier Bit 23
CANTXIDR0_ID24:     equ    3                                         ; Extended format identifier Bit 24
CANTXIDR0_ID25:     equ    4                                         ; Extended format identifier Bit 25
CANTXIDR0_ID26:     equ    5                                         ; Extended format identifier Bit 26
CANTXIDR0_ID27:     equ    6                                         ; Extended format identifier Bit 27
CANTXIDR0_ID28:     equ    7                                         ; Extended format identifier Bit 28
; bit position masks
mCANTXIDR0_ID21:    equ    %00000001
mCANTXIDR0_ID22:    equ    %00000010
mCANTXIDR0_ID23:    equ    %00000100
mCANTXIDR0_ID24:    equ    %00001000
mCANTXIDR0_ID25:    equ    %00010000
mCANTXIDR0_ID26:    equ    %00100000
mCANTXIDR0_ID27:    equ    %01000000
mCANTXIDR0_ID28:    equ    %10000000


;*** CANTXIDR1 - MSCAN Transmit Identifier Register 1; 0x00000171 ***
CANTXIDR1:          equ    $00000171                                ;*** CANTXIDR1 - MSCAN Transmit Identifier Register 1; 0x00000171 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANTXIDR1_ID15:     equ    0                                         ; Extended format identifier Bit 15
CANTXIDR1_ID16:     equ    1                                         ; Extended format identifier Bit 16
CANTXIDR1_ID17:     equ    2                                         ; Extended format identifier Bit 17
CANTXIDR1_IDE:      equ    3                                         ; ID Extended
CANTXIDR1_SRR:      equ    4                                         ; Substitute Remote Request
CANTXIDR1_ID18:     equ    5                                         ; Extended format identifier Bit 18
CANTXIDR1_ID19:     equ    6                                         ; Extended format identifier Bit 19
CANTXIDR1_ID20:     equ    7                                         ; Extended format identifier Bit 20
; bit position masks
mCANTXIDR1_ID15:    equ    %00000001
mCANTXIDR1_ID16:    equ    %00000010
mCANTXIDR1_ID17:    equ    %00000100
mCANTXIDR1_IDE:     equ    %00001000
mCANTXIDR1_SRR:     equ    %00010000
mCANTXIDR1_ID18:    equ    %00100000
mCANTXIDR1_ID19:    equ    %01000000
mCANTXIDR1_ID20:    equ    %10000000


;*** CANTXIDR2 - MSCAN Transmit Identifier Register 2; 0x00000172 ***
CANTXIDR2:          equ    $00000172                                ;*** CANTXIDR2 - MSCAN Transmit Identifier Register 2; 0x00000172 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANTXIDR2_ID7:      equ    0                                         ; Extended format identifier Bit 7
CANTXIDR2_ID8:      equ    1                                         ; Extended format identifier Bit 8
CANTXIDR2_ID9:      equ    2                                         ; Extended format identifier Bit 9
CANTXIDR2_ID10:     equ    3                                         ; Extended format identifier Bit 10
CANTXIDR2_ID11:     equ    4                                         ; Extended format identifier Bit 11
CANTXIDR2_ID12:     equ    5                                         ; Extended format identifier Bit 12
CANTXIDR2_ID13:     equ    6                                         ; Extended format identifier Bit 13
CANTXIDR2_ID14:     equ    7                                         ; Extended format identifier Bit 14
; bit position masks
mCANTXIDR2_ID7:     equ    %00000001
mCANTXIDR2_ID8:     equ    %00000010
mCANTXIDR2_ID9:     equ    %00000100
mCANTXIDR2_ID10:    equ    %00001000
mCANTXIDR2_ID11:    equ    %00010000
mCANTXIDR2_ID12:    equ    %00100000
mCANTXIDR2_ID13:    equ    %01000000
mCANTXIDR2_ID14:    equ    %10000000


;*** CANTXIDR3 - MSCAN Transmit Identifier Register 3; 0x00000173 ***
CANTXIDR3:          equ    $00000173                                ;*** CANTXIDR3 - MSCAN Transmit Identifier Register 3; 0x00000173 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANTXIDR3_RTR:      equ    0                                         ; Remote Transmission Request
CANTXIDR3_ID0:      equ    1                                         ; Extended format identifier Bit 0
CANTXIDR3_ID1:      equ    2                                         ; Extended format identifier Bit 1
CANTXIDR3_ID2:      equ    3                                         ; Extended format identifier Bit 2
CANTXIDR3_ID3:      equ    4                                         ; Extended format identifier Bit 3
CANTXIDR3_ID4:      equ    5                                         ; Extended format identifier Bit 4
CANTXIDR3_ID5:      equ    6                                         ; Extended format identifier Bit 5
CANTXIDR3_ID6:      equ    7                                         ; Extended format identifier Bit 6
; bit position masks
mCANTXIDR3_RTR:     equ    %00000001
mCANTXIDR3_ID0:     equ    %00000010
mCANTXIDR3_ID1:     equ    %00000100
mCANTXIDR3_ID2:     equ    %00001000
mCANTXIDR3_ID3:     equ    %00010000
mCANTXIDR3_ID4:     equ    %00100000
mCANTXIDR3_ID5:     equ    %01000000
mCANTXIDR3_ID6:     equ    %10000000


;*** CANTXDSR0 - MSCAN Transmit Data Segment Register 0; 0x00000174 ***
CANTXDSR0:          equ    $00000174                                ;*** CANTXDSR0 - MSCAN Transmit Data Segment Register 0; 0x00000174 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANTXDSR0_DB0:      equ    0                                         ; Data Bit 0
CANTXDSR0_DB1:      equ    1                                         ; Data Bit 1
CANTXDSR0_DB2:      equ    2                                         ; Data Bit 2
CANTXDSR0_DB3:      equ    3                                         ; Data Bit 3
CANTXDSR0_DB4:      equ    4                                         ; Data Bit 4
CANTXDSR0_DB5:      equ    5                                         ; Data Bit 5
CANTXDSR0_DB6:      equ    6                                         ; Data Bit 6
CANTXDSR0_DB7:      equ    7                                         ; Data Bit 7
; bit position masks
mCANTXDSR0_DB0:     equ    %00000001
mCANTXDSR0_DB1:     equ    %00000010
mCANTXDSR0_DB2:     equ    %00000100
mCANTXDSR0_DB3:     equ    %00001000
mCANTXDSR0_DB4:     equ    %00010000
mCANTXDSR0_DB5:     equ    %00100000
mCANTXDSR0_DB6:     equ    %01000000
mCANTXDSR0_DB7:     equ    %10000000


;*** CANTXDSR1 - MSCAN Transmit Data Segment Register 1; 0x00000175 ***
CANTXDSR1:          equ    $00000175                                ;*** CANTXDSR1 - MSCAN Transmit Data Segment Register 1; 0x00000175 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANTXDSR1_DB0:      equ    0                                         ; Data Bit 0
CANTXDSR1_DB1:      equ    1                                         ; Data Bit 1
CANTXDSR1_DB2:      equ    2                                         ; Data Bit 2
CANTXDSR1_DB3:      equ    3                                         ; Data Bit 3
CANTXDSR1_DB4:      equ    4                                         ; Data Bit 4
CANTXDSR1_DB5:      equ    5                                         ; Data Bit 5
CANTXDSR1_DB6:      equ    6                                         ; Data Bit 6
CANTXDSR1_DB7:      equ    7                                         ; Data Bit 7
; bit position masks
mCANTXDSR1_DB0:     equ    %00000001
mCANTXDSR1_DB1:     equ    %00000010
mCANTXDSR1_DB2:     equ    %00000100
mCANTXDSR1_DB3:     equ    %00001000
mCANTXDSR1_DB4:     equ    %00010000
mCANTXDSR1_DB5:     equ    %00100000
mCANTXDSR1_DB6:     equ    %01000000
mCANTXDSR1_DB7:     equ    %10000000


;*** CANTXDSR2 - MSCAN Transmit Data Segment Register 2; 0x00000176 ***
CANTXDSR2:          equ    $00000176                                ;*** CANTXDSR2 - MSCAN Transmit Data Segment Register 2; 0x00000176 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANTXDSR2_DB0:      equ    0                                         ; Data Bit 0
CANTXDSR2_DB1:      equ    1                                         ; Data Bit 1
CANTXDSR2_DB2:      equ    2                                         ; Data Bit 2
CANTXDSR2_DB3:      equ    3                                         ; Data Bit 3
CANTXDSR2_DB4:      equ    4                                         ; Data Bit 4
CANTXDSR2_DB5:      equ    5                                         ; Data Bit 5
CANTXDSR2_DB6:      equ    6                                         ; Data Bit 6
CANTXDSR2_DB7:      equ    7                                         ; Data Bit 7
; bit position masks
mCANTXDSR2_DB0:     equ    %00000001
mCANTXDSR2_DB1:     equ    %00000010
mCANTXDSR2_DB2:     equ    %00000100
mCANTXDSR2_DB3:     equ    %00001000
mCANTXDSR2_DB4:     equ    %00010000
mCANTXDSR2_DB5:     equ    %00100000
mCANTXDSR2_DB6:     equ    %01000000
mCANTXDSR2_DB7:     equ    %10000000


;*** CANTXDSR3 - MSCAN Transmit Data Segment Register 3; 0x00000177 ***
CANTXDSR3:          equ    $00000177                                ;*** CANTXDSR3 - MSCAN Transmit Data Segment Register 3; 0x00000177 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANTXDSR3_DB0:      equ    0                                         ; Data Bit 0
CANTXDSR3_DB1:      equ    1                                         ; Data Bit 1
CANTXDSR3_DB2:      equ    2                                         ; Data Bit 2
CANTXDSR3_DB3:      equ    3                                         ; Data Bit 3
CANTXDSR3_DB4:      equ    4                                         ; Data Bit 4
CANTXDSR3_DB5:      equ    5                                         ; Data Bit 5
CANTXDSR3_DB6:      equ    6                                         ; Data Bit 6
CANTXDSR3_DB7:      equ    7                                         ; Data Bit 7
; bit position masks
mCANTXDSR3_DB0:     equ    %00000001
mCANTXDSR3_DB1:     equ    %00000010
mCANTXDSR3_DB2:     equ    %00000100
mCANTXDSR3_DB3:     equ    %00001000
mCANTXDSR3_DB4:     equ    %00010000
mCANTXDSR3_DB5:     equ    %00100000
mCANTXDSR3_DB6:     equ    %01000000
mCANTXDSR3_DB7:     equ    %10000000


;*** CANTXDSR4 - MSCAN Transmit Data Segment Register 4; 0x00000178 ***
CANTXDSR4:          equ    $00000178                                ;*** CANTXDSR4 - MSCAN Transmit Data Segment Register 4; 0x00000178 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANTXDSR4_DB0:      equ    0                                         ; Data Bit 0
CANTXDSR4_DB1:      equ    1                                         ; Data Bit 1
CANTXDSR4_DB2:      equ    2                                         ; Data Bit 2
CANTXDSR4_DB3:      equ    3                                         ; Data Bit 3
CANTXDSR4_DB4:      equ    4                                         ; Data Bit 4
CANTXDSR4_DB5:      equ    5                                         ; Data Bit 5
CANTXDSR4_DB6:      equ    6                                         ; Data Bit 6
CANTXDSR4_DB7:      equ    7                                         ; Data Bit 7
; bit position masks
mCANTXDSR4_DB0:     equ    %00000001
mCANTXDSR4_DB1:     equ    %00000010
mCANTXDSR4_DB2:     equ    %00000100
mCANTXDSR4_DB3:     equ    %00001000
mCANTXDSR4_DB4:     equ    %00010000
mCANTXDSR4_DB5:     equ    %00100000
mCANTXDSR4_DB6:     equ    %01000000
mCANTXDSR4_DB7:     equ    %10000000


;*** CANTXDSR5 - MSCAN Transmit Data Segment Register 5; 0x00000179 ***
CANTXDSR5:          equ    $00000179                                ;*** CANTXDSR5 - MSCAN Transmit Data Segment Register 5; 0x00000179 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANTXDSR5_DB0:      equ    0                                         ; Data Bit 0
CANTXDSR5_DB1:      equ    1                                         ; Data Bit 1
CANTXDSR5_DB2:      equ    2                                         ; Data Bit 2
CANTXDSR5_DB3:      equ    3                                         ; Data Bit 3
CANTXDSR5_DB4:      equ    4                                         ; Data Bit 4
CANTXDSR5_DB5:      equ    5                                         ; Data Bit 5
CANTXDSR5_DB6:      equ    6                                         ; Data Bit 6
CANTXDSR5_DB7:      equ    7                                         ; Data Bit 7
; bit position masks
mCANTXDSR5_DB0:     equ    %00000001
mCANTXDSR5_DB1:     equ    %00000010
mCANTXDSR5_DB2:     equ    %00000100
mCANTXDSR5_DB3:     equ    %00001000
mCANTXDSR5_DB4:     equ    %00010000
mCANTXDSR5_DB5:     equ    %00100000
mCANTXDSR5_DB6:     equ    %01000000
mCANTXDSR5_DB7:     equ    %10000000


;*** CANTXDSR6 - MSCAN Transmit Data Segment Register 6; 0x0000017A ***
CANTXDSR6:          equ    $0000017A                                ;*** CANTXDSR6 - MSCAN Transmit Data Segment Register 6; 0x0000017A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANTXDSR6_DB0:      equ    0                                         ; Data Bit 0
CANTXDSR6_DB1:      equ    1                                         ; Data Bit 1
CANTXDSR6_DB2:      equ    2                                         ; Data Bit 2
CANTXDSR6_DB3:      equ    3                                         ; Data Bit 3
CANTXDSR6_DB4:      equ    4                                         ; Data Bit 4
CANTXDSR6_DB5:      equ    5                                         ; Data Bit 5
CANTXDSR6_DB6:      equ    6                                         ; Data Bit 6
CANTXDSR6_DB7:      equ    7                                         ; Data Bit 7
; bit position masks
mCANTXDSR6_DB0:     equ    %00000001
mCANTXDSR6_DB1:     equ    %00000010
mCANTXDSR6_DB2:     equ    %00000100
mCANTXDSR6_DB3:     equ    %00001000
mCANTXDSR6_DB4:     equ    %00010000
mCANTXDSR6_DB5:     equ    %00100000
mCANTXDSR6_DB6:     equ    %01000000
mCANTXDSR6_DB7:     equ    %10000000


;*** CANTXDSR7 - MSCAN Transmit Data Segment Register 7; 0x0000017B ***
CANTXDSR7:          equ    $0000017B                                ;*** CANTXDSR7 - MSCAN Transmit Data Segment Register 7; 0x0000017B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANTXDSR7_DB0:      equ    0                                         ; Data Bit 0
CANTXDSR7_DB1:      equ    1                                         ; Data Bit 1
CANTXDSR7_DB2:      equ    2                                         ; Data Bit 2
CANTXDSR7_DB3:      equ    3                                         ; Data Bit 3
CANTXDSR7_DB4:      equ    4                                         ; Data Bit 4
CANTXDSR7_DB5:      equ    5                                         ; Data Bit 5
CANTXDSR7_DB6:      equ    6                                         ; Data Bit 6
CANTXDSR7_DB7:      equ    7                                         ; Data Bit 7
; bit position masks
mCANTXDSR7_DB0:     equ    %00000001
mCANTXDSR7_DB1:     equ    %00000010
mCANTXDSR7_DB2:     equ    %00000100
mCANTXDSR7_DB3:     equ    %00001000
mCANTXDSR7_DB4:     equ    %00010000
mCANTXDSR7_DB5:     equ    %00100000
mCANTXDSR7_DB6:     equ    %01000000
mCANTXDSR7_DB7:     equ    %10000000


;*** CANTXDLR - MSCAN Transmit Data Length Register; 0x0000017C ***
CANTXDLR:           equ    $0000017C                                ;*** CANTXDLR - MSCAN Transmit Data Length Register; 0x0000017C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANTXDLR_DLC0:      equ    0                                         ; Data Length Code Bit 0
CANTXDLR_DLC1:      equ    1                                         ; Data Length Code Bit 1
CANTXDLR_DLC2:      equ    2                                         ; Data Length Code Bit 2
CANTXDLR_DLC3:      equ    3                                         ; Data Length Code Bit 3
; bit position masks
mCANTXDLR_DLC0:     equ    %00000001
mCANTXDLR_DLC1:     equ    %00000010
mCANTXDLR_DLC2:     equ    %00000100
mCANTXDLR_DLC3:     equ    %00001000


;*** CANTXTBPR - MSCAN Transmit Buffer Priority; 0x0000017D ***
CANTXTBPR:          equ    $0000017D                                ;*** CANTXTBPR - MSCAN Transmit Buffer Priority; 0x0000017D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANTXTBPR_PRIO0:    equ    0                                         ; Transmit Buffer Priority Bit 0
CANTXTBPR_PRIO1:    equ    1                                         ; Transmit Buffer Priority Bit 1
CANTXTBPR_PRIO2:    equ    2                                         ; Transmit Buffer Priority Bit 2
CANTXTBPR_PRIO3:    equ    3                                         ; Transmit Buffer Priority Bit 3
CANTXTBPR_PRIO4:    equ    4                                         ; Transmit Buffer Priority Bit 4
CANTXTBPR_PRIO5:    equ    5                                         ; Transmit Buffer Priority Bit 5
CANTXTBPR_PRIO6:    equ    6                                         ; Transmit Buffer Priority Bit 6
CANTXTBPR_PRIO7:    equ    7                                         ; Transmit Buffer Priority Bit 7
; bit position masks
mCANTXTBPR_PRIO0:   equ    %00000001
mCANTXTBPR_PRIO1:   equ    %00000010
mCANTXTBPR_PRIO2:   equ    %00000100
mCANTXTBPR_PRIO3:   equ    %00001000
mCANTXTBPR_PRIO4:   equ    %00010000
mCANTXTBPR_PRIO5:   equ    %00100000
mCANTXTBPR_PRIO6:   equ    %01000000
mCANTXTBPR_PRIO7:   equ    %10000000


;*** CANTXTSR - MSCAN Transmit Time Stamp Register; 0x0000017E ***
CANTXTSR:           equ    $0000017E                                ;*** CANTXTSR - MSCAN Transmit Time Stamp Register; 0x0000017E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANTXTSR_TSR0:      equ    0                                         ; Time Stamp Bit 0
CANTXTSR_TSR1:      equ    1                                         ; Time Stamp Bit 1
CANTXTSR_TSR2:      equ    2                                         ; Time Stamp Bit 2
CANTXTSR_TSR3:      equ    3                                         ; Time Stamp Bit 3
CANTXTSR_TSR4:      equ    4                                         ; Time Stamp Bit 4
CANTXTSR_TSR5:      equ    5                                         ; Time Stamp Bit 5
CANTXTSR_TSR6:      equ    6                                         ; Time Stamp Bit 6
CANTXTSR_TSR7:      equ    7                                         ; Time Stamp Bit 7
CANTXTSR_TSR8:      equ    8                                         ; Time Stamp Bit 8
CANTXTSR_TSR9:      equ    9                                         ; Time Stamp Bit 9
CANTXTSR_TSR10:     equ    10                                        ; Time Stamp Bit 10
CANTXTSR_TSR11:     equ    11                                        ; Time Stamp Bit 11
CANTXTSR_TSR12:     equ    12                                        ; Time Stamp Bit 12
CANTXTSR_TSR13:     equ    13                                        ; Time Stamp Bit 13
CANTXTSR_TSR14:     equ    14                                        ; Time Stamp Bit 14
CANTXTSR_TSR15:     equ    15                                        ; Time Stamp Bit 15
; bit position masks
mCANTXTSR_TSR0:     equ    %00000001
mCANTXTSR_TSR1:     equ    %00000010
mCANTXTSR_TSR2:     equ    %00000100
mCANTXTSR_TSR3:     equ    %00001000
mCANTXTSR_TSR4:     equ    %00010000
mCANTXTSR_TSR5:     equ    %00100000
mCANTXTSR_TSR6:     equ    %01000000
mCANTXTSR_TSR7:     equ    %10000000
mCANTXTSR_TSR8:     equ    %100000000
mCANTXTSR_TSR9:     equ    %1000000000
mCANTXTSR_TSR10:    equ    %10000000000
mCANTXTSR_TSR11:    equ    %100000000000
mCANTXTSR_TSR12:    equ    %1000000000000
mCANTXTSR_TSR13:    equ    %10000000000000
mCANTXTSR_TSR14:    equ    %100000000000000
mCANTXTSR_TSR15:    equ    %1000000000000000


;*** CANTXTSRH - MSCAN Transmit Time Stamp Register High; 0x0000017E ***
CANTXTSRH:          equ    $0000017E                                ;*** CANTXTSRH - MSCAN Transmit Time Stamp Register High; 0x0000017E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANTXTSRH_TSR8:     equ    0                                         ; Time Stamp Bit 8
CANTXTSRH_TSR9:     equ    1                                         ; Time Stamp Bit 9
CANTXTSRH_TSR10:    equ    2                                         ; Time Stamp Bit 10
CANTXTSRH_TSR11:    equ    3                                         ; Time Stamp Bit 11
CANTXTSRH_TSR12:    equ    4                                         ; Time Stamp Bit 12
CANTXTSRH_TSR13:    equ    5                                         ; Time Stamp Bit 13
CANTXTSRH_TSR14:    equ    6                                         ; Time Stamp Bit 14
CANTXTSRH_TSR15:    equ    7                                         ; Time Stamp Bit 15
; bit position masks
mCANTXTSRH_TSR8:    equ    %00000001
mCANTXTSRH_TSR9:    equ    %00000010
mCANTXTSRH_TSR10:   equ    %00000100
mCANTXTSRH_TSR11:   equ    %00001000
mCANTXTSRH_TSR12:   equ    %00010000
mCANTXTSRH_TSR13:   equ    %00100000
mCANTXTSRH_TSR14:   equ    %01000000
mCANTXTSRH_TSR15:   equ    %10000000


;*** CANTXTSRL - MSCAN Transmit Time Stamp Register Low; 0x0000017F ***
CANTXTSRL:          equ    $0000017F                                ;*** CANTXTSRL - MSCAN Transmit Time Stamp Register Low; 0x0000017F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANTXTSRL_TSR0:     equ    0                                         ; Time Stamp Bit 0
CANTXTSRL_TSR1:     equ    1                                         ; Time Stamp Bit 1
CANTXTSRL_TSR2:     equ    2                                         ; Time Stamp Bit 2
CANTXTSRL_TSR3:     equ    3                                         ; Time Stamp Bit 3
CANTXTSRL_TSR4:     equ    4                                         ; Time Stamp Bit 4
CANTXTSRL_TSR5:     equ    5                                         ; Time Stamp Bit 5
CANTXTSRL_TSR6:     equ    6                                         ; Time Stamp Bit 6
CANTXTSRL_TSR7:     equ    7                                         ; Time Stamp Bit 7
; bit position masks
mCANTXTSRL_TSR0:    equ    %00000001
mCANTXTSRL_TSR1:    equ    %00000010
mCANTXTSRL_TSR2:    equ    %00000100
mCANTXTSRL_TSR3:    equ    %00001000
mCANTXTSRL_TSR4:    equ    %00010000
mCANTXTSRL_TSR5:    equ    %00100000
mCANTXTSRL_TSR6:    equ    %01000000
mCANTXTSRL_TSR7:    equ    %10000000


;*** MCCTL0 - Motor Controller Control Register 0; 0x000001C0 ***
MCCTL0:             equ    $000001C0                                ;*** MCCTL0 - Motor Controller Control Register 0; 0x000001C0 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MCCTL0_MCTOIF:      equ    0                                         ; Motor Controller Timer Counter Overflow Interrupt Flag
MCCTL0_DITH:        equ    2                                         ; Motor Control/Driver Dither Feature Enable
MCCTL0_FAST:        equ    3                                         ; Motor Controller PWM Resolution Mode
MCCTL0_MCSWAI:      equ    4                                         ; Motor Controller Module Stop in Wait Mode
MCCTL0_MCPRE0:      equ    5                                         ; Motor Controller Prescaler Select, bit 0
MCCTL0_MCPRE1:      equ    6                                         ; Motor Controller Prescaler Select, bit 1
; bit position masks
mMCCTL0_MCTOIF:     equ    %00000001
mMCCTL0_DITH:       equ    %00000100
mMCCTL0_FAST:       equ    %00001000
mMCCTL0_MCSWAI:     equ    %00010000
mMCCTL0_MCPRE0:     equ    %00100000
mMCCTL0_MCPRE1:     equ    %01000000


;*** MCCTL1 - Motor Controller Control Register 1; 0x000001C1 ***
MCCTL1:             equ    $000001C1                                ;*** MCCTL1 - Motor Controller Control Register 1; 0x000001C1 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MCCTL1_MCTOIE:      equ    0                                         ; Motor Controller Timer Counter Overflow Interrupt Enable
MCCTL1_RECIRC:      equ    7                                         ; Recirculation in (Dual) Full H-Bridge Mode
; bit position masks
mMCCTL1_MCTOIE:     equ    %00000001
mMCCTL1_RECIRC:     equ    %10000000


;*** MCPER - Motor Controller Period Register; 0x000001C2 ***
MCPER:              equ    $000001C2                                ;*** MCPER - Motor Controller Period Register; 0x000001C2 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MCPER_P0:           equ    0                                         ; Motor Controller Period Bit 1
MCPER_P1:           equ    1                                         ; Motor Controller Period, bit 1
MCPER_P2:           equ    2                                         ; Motor Controller Period, bit 2
MCPER_P3:           equ    3                                         ; Motor Controller Period, bit 3
MCPER_P4:           equ    4                                         ; Motor Controller Period, bit 4
MCPER_P5:           equ    5                                         ; Motor Controller Period, bit 5
MCPER_P6:           equ    6                                         ; Motor Controller Period, bit 6
MCPER_P7:           equ    7                                         ; Motor Controller Period, bit 7
MCPER_P8:           equ    8                                         ; Motor Controller Period, bit 8
MCPER_P9:           equ    9                                         ; Motor Controller Period, bit 9
MCPER_P10:          equ    10                                        ; Motor Controller Period, bit 10
; bit position masks
mMCPER_P0:          equ    %00000001
mMCPER_P1:          equ    %00000010
mMCPER_P2:          equ    %00000100
mMCPER_P3:          equ    %00001000
mMCPER_P4:          equ    %00010000
mMCPER_P5:          equ    %00100000
mMCPER_P6:          equ    %01000000
mMCPER_P7:          equ    %10000000
mMCPER_P8:          equ    %100000000
mMCPER_P9:          equ    %1000000000
mMCPER_P10:         equ    %10000000000


;*** MCCC0 - Motor Controller Control Register 0; 0x000001D0 ***
MCCC0:              equ    $000001D0                                ;*** MCCC0 - Motor Controller Control Register 0; 0x000001D0 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MCCC0_CD0:          equ    0                                         ; PWM Channel Delay
MCCC0_CD1:          equ    1                                         ; PWM Channel Delay
MCCC0_MCAM0:        equ    4                                         ; PWM Channel Alignment Mode
MCCC0_MCAM1:        equ    5                                         ; PWM Channel Alignment Mode
MCCC0_MCOM0:        equ    6                                         ; Output Mode
MCCC0_MCOM1:        equ    7                                         ; Output Mode
; bit position masks
mMCCC0_CD0:         equ    %00000001
mMCCC0_CD1:         equ    %00000010
mMCCC0_MCAM0:       equ    %00010000
mMCCC0_MCAM1:       equ    %00100000
mMCCC0_MCOM0:       equ    %01000000
mMCCC0_MCOM1:       equ    %10000000


;*** MCCC1 - Motor Controller Control Register 1; 0x000001D1 ***
MCCC1:              equ    $000001D1                                ;*** MCCC1 - Motor Controller Control Register 1; 0x000001D1 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MCCC1_CD0:          equ    0                                         ; PWM Channel Delay
MCCC1_CD1:          equ    1                                         ; PWM Channel Delay
MCCC1_MCAM0:        equ    4                                         ; PWM Channel Alignment Mode
MCCC1_MCAM1:        equ    5                                         ; PWM Channel Alignment Mode
MCCC1_MCOM0:        equ    6                                         ; Output Mode
MCCC1_MCOM1:        equ    7                                         ; Output Mode
; bit position masks
mMCCC1_CD0:         equ    %00000001
mMCCC1_CD1:         equ    %00000010
mMCCC1_MCAM0:       equ    %00010000
mMCCC1_MCAM1:       equ    %00100000
mMCCC1_MCOM0:       equ    %01000000
mMCCC1_MCOM1:       equ    %10000000


;*** MCCC2 - Motor Controller Control Register 2; 0x000001D2 ***
MCCC2:              equ    $000001D2                                ;*** MCCC2 - Motor Controller Control Register 2; 0x000001D2 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MCCC2_CD0:          equ    0                                         ; PWM Channel Delay
MCCC2_CD1:          equ    1                                         ; PWM Channel Delay
MCCC2_MCAM0:        equ    4                                         ; PWM Channel Alignment Mode
MCCC2_MCAM1:        equ    5                                         ; PWM Channel Alignment Mode
MCCC2_MCOM0:        equ    6                                         ; Output Mode
MCCC2_MCOM1:        equ    7                                         ; Output Mode
; bit position masks
mMCCC2_CD0:         equ    %00000001
mMCCC2_CD1:         equ    %00000010
mMCCC2_MCAM0:       equ    %00010000
mMCCC2_MCAM1:       equ    %00100000
mMCCC2_MCOM0:       equ    %01000000
mMCCC2_MCOM1:       equ    %10000000


;*** MCCC3 - Motor Controller Control Register 3; 0x000001D3 ***
MCCC3:              equ    $000001D3                                ;*** MCCC3 - Motor Controller Control Register 3; 0x000001D3 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MCCC3_CD0:          equ    0                                         ; PWM Channel Delay
MCCC3_CD1:          equ    1                                         ; PWM Channel Delay
MCCC3_MCAM0:        equ    4                                         ; PWM Channel Alignment Mode
MCCC3_MCAM1:        equ    5                                         ; PWM Channel Alignment Mode
MCCC3_MCOM0:        equ    6                                         ; Output Mode
MCCC3_MCOM1:        equ    7                                         ; Output Mode
; bit position masks
mMCCC3_CD0:         equ    %00000001
mMCCC3_CD1:         equ    %00000010
mMCCC3_MCAM0:       equ    %00010000
mMCCC3_MCAM1:       equ    %00100000
mMCCC3_MCOM0:       equ    %01000000
mMCCC3_MCOM1:       equ    %10000000


;*** MCCC4 - Motor Controller Control Register 4; 0x000001D4 ***
MCCC4:              equ    $000001D4                                ;*** MCCC4 - Motor Controller Control Register 4; 0x000001D4 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MCCC4_CD0:          equ    0                                         ; PWM Channel Delay
MCCC4_CD1:          equ    1                                         ; PWM Channel Delay
MCCC4_MCAM0:        equ    4                                         ; PWM Channel Alignment Mode
MCCC4_MCAM1:        equ    5                                         ; PWM Channel Alignment Mode
MCCC4_MCOM0:        equ    6                                         ; Output Mode
MCCC4_MCOM1:        equ    7                                         ; Output Mode
; bit position masks
mMCCC4_CD0:         equ    %00000001
mMCCC4_CD1:         equ    %00000010
mMCCC4_MCAM0:       equ    %00010000
mMCCC4_MCAM1:       equ    %00100000
mMCCC4_MCOM0:       equ    %01000000
mMCCC4_MCOM1:       equ    %10000000


;*** MCCC5 - Motor Controller Control Register 5; 0x000001D5 ***
MCCC5:              equ    $000001D5                                ;*** MCCC5 - Motor Controller Control Register 5; 0x000001D5 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MCCC5_CD0:          equ    0                                         ; PWM Channel Delay
MCCC5_CD1:          equ    1                                         ; PWM Channel Delay
MCCC5_MCAM0:        equ    4                                         ; PWM Channel Alignment Mode
MCCC5_MCAM1:        equ    5                                         ; PWM Channel Alignment Mode
MCCC5_MCOM0:        equ    6                                         ; Output Mode
MCCC5_MCOM1:        equ    7                                         ; Output Mode
; bit position masks
mMCCC5_CD0:         equ    %00000001
mMCCC5_CD1:         equ    %00000010
mMCCC5_MCAM0:       equ    %00010000
mMCCC5_MCAM1:       equ    %00100000
mMCCC5_MCOM0:       equ    %01000000
mMCCC5_MCOM1:       equ    %10000000


;*** MCCC6 - Motor Controller Control Register 6; 0x000001D6 ***
MCCC6:              equ    $000001D6                                ;*** MCCC6 - Motor Controller Control Register 6; 0x000001D6 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MCCC6_CD0:          equ    0                                         ; PWM Channel Delay
MCCC6_CD1:          equ    1                                         ; PWM Channel Delay
MCCC6_MCAM0:        equ    4                                         ; PWM Channel Alignment Mode
MCCC6_MCAM1:        equ    5                                         ; PWM Channel Alignment Mode
MCCC6_MCOM0:        equ    6                                         ; Output Mode
MCCC6_MCOM1:        equ    7                                         ; Output Mode
; bit position masks
mMCCC6_CD0:         equ    %00000001
mMCCC6_CD1:         equ    %00000010
mMCCC6_MCAM0:       equ    %00010000
mMCCC6_MCAM1:       equ    %00100000
mMCCC6_MCOM0:       equ    %01000000
mMCCC6_MCOM1:       equ    %10000000


;*** MCCC7 - Motor Controller Control Register 7; 0x000001D7 ***
MCCC7:              equ    $000001D7                                ;*** MCCC7 - Motor Controller Control Register 7; 0x000001D7 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MCCC7_CD0:          equ    0                                         ; PWM Channel Delay
MCCC7_CD1:          equ    1                                         ; PWM Channel Delay
MCCC7_MCAM0:        equ    4                                         ; PWM Channel Alignment Mode
MCCC7_MCAM1:        equ    5                                         ; PWM Channel Alignment Mode
MCCC7_MCOM0:        equ    6                                         ; Output Mode
MCCC7_MCOM1:        equ    7                                         ; Output Mode
; bit position masks
mMCCC7_CD0:         equ    %00000001
mMCCC7_CD1:         equ    %00000010
mMCCC7_MCAM0:       equ    %00010000
mMCCC7_MCAM1:       equ    %00100000
mMCCC7_MCOM0:       equ    %01000000
mMCCC7_MCOM1:       equ    %10000000


;*** MCDC0 - Motor Controller Period Register 0; 0x000001E0 ***
MCDC0:              equ    $000001E0                                ;*** MCDC0 - Motor Controller Period Register 0; 0x000001E0 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MCDC0_D0:           equ    0                                         ; Motor Controller Duty Cycle, bit 0
MCDC0_D1:           equ    1                                         ; Motor Controller Duty Cycle, bit 1
MCDC0_D2:           equ    2                                         ; Motor Controller Duty Cycle, bit 2
MCDC0_D3:           equ    3                                         ; Motor Controller Duty Cycle, bit 3
MCDC0_D4:           equ    4                                         ; Motor Controller Duty Cycle, bit 4
MCDC0_D5:           equ    5                                         ; Motor Controller Duty Cycle, bit 5
MCDC0_D6:           equ    6                                         ; Motor Controller Duty Cycle, bit 6
MCDC0_D7:           equ    7                                         ; Motor Controller Duty Cycle, bit 7
MCDC0_D8:           equ    8                                         ; Motor Controller Duty Cycle, bit 8
MCDC0_D9:           equ    9                                         ; Motor Controller Duty Cycle, bit 9
MCDC0_D10:          equ    10                                        ; Motor Controller Duty Cycle, bit 10
MCDC0_S:            equ    15                                        ; Sign
; bit position masks
mMCDC0_D0:          equ    %00000001
mMCDC0_D1:          equ    %00000010
mMCDC0_D2:          equ    %00000100
mMCDC0_D3:          equ    %00001000
mMCDC0_D4:          equ    %00010000
mMCDC0_D5:          equ    %00100000
mMCDC0_D6:          equ    %01000000
mMCDC0_D7:          equ    %10000000
mMCDC0_D8:          equ    %100000000
mMCDC0_D9:          equ    %1000000000
mMCDC0_D10:         equ    %10000000000
mMCDC0_S:           equ    %1000000000000000


;*** MCDC0_FAST - Motor Controller Period Register 0 access with FAST bit = 1; 0x000001E0 ***
MCDC0_FAST:         equ    $000001E0                                ;*** MCDC0_FAST - Motor Controller Period Register 0 access with FAST bit = 1; 0x000001E0 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MCDC0_FAST_D2:      equ    0                                         ; Motor Controller Duty Cycle, bit 2
MCDC0_FAST_D3:      equ    1                                         ; Motor Controller Duty Cycle, bit 3
MCDC0_FAST_D4:      equ    2                                         ; Motor Controller Duty Cycle, bit 4
MCDC0_FAST_D5:      equ    3                                         ; Motor Controller Duty Cycle, bit 5
MCDC0_FAST_D6:      equ    4                                         ; Motor Controller Duty Cycle, bit 6
MCDC0_FAST_D7:      equ    5                                         ; Motor Controller Duty Cycle, bit 7
MCDC0_FAST_D8:      equ    6                                         ; Motor Controller Duty Cycle, bit 8
MCDC0_FAST_S:       equ    7                                         ; Sign
; bit position masks
mMCDC0_FAST_D2:     equ    %00000001
mMCDC0_FAST_D3:     equ    %00000010
mMCDC0_FAST_D4:     equ    %00000100
mMCDC0_FAST_D5:     equ    %00001000
mMCDC0_FAST_D6:     equ    %00010000
mMCDC0_FAST_D7:     equ    %00100000
mMCDC0_FAST_D8:     equ    %01000000
mMCDC0_FAST_S:      equ    %10000000


;*** MCDC1 - Motor Controller Period Register 1; 0x000001E2 ***
MCDC1:              equ    $000001E2                                ;*** MCDC1 - Motor Controller Period Register 1; 0x000001E2 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MCDC1_D0:           equ    0                                         ; Motor Controller Duty Cycle, bit 0
MCDC1_D1:           equ    1                                         ; Motor Controller Duty Cycle, bit 1
MCDC1_D2:           equ    2                                         ; Motor Controller Duty Cycle, bit 2
MCDC1_D3:           equ    3                                         ; Motor Controller Duty Cycle, bit 3
MCDC1_D4:           equ    4                                         ; Motor Controller Duty Cycle, bit 4
MCDC1_D5:           equ    5                                         ; Motor Controller Duty Cycle, bit 5
MCDC1_D6:           equ    6                                         ; Motor Controller Duty Cycle, bit 6
MCDC1_D7:           equ    7                                         ; Motor Controller Duty Cycle, bit 7
MCDC1_D8:           equ    8                                         ; Motor Controller Duty Cycle, bit 8
MCDC1_D9:           equ    9                                         ; Motor Controller Duty Cycle, bit 9
MCDC1_D10:          equ    10                                        ; Motor Controller Duty Cycle, bit 10
MCDC1_S:            equ    15                                        ; Sign
; bit position masks
mMCDC1_D0:          equ    %00000001
mMCDC1_D1:          equ    %00000010
mMCDC1_D2:          equ    %00000100
mMCDC1_D3:          equ    %00001000
mMCDC1_D4:          equ    %00010000
mMCDC1_D5:          equ    %00100000
mMCDC1_D6:          equ    %01000000
mMCDC1_D7:          equ    %10000000
mMCDC1_D8:          equ    %100000000
mMCDC1_D9:          equ    %1000000000
mMCDC1_D10:         equ    %10000000000
mMCDC1_S:           equ    %1000000000000000


;*** MCDC1_FAST - Motor Controller Period Register 1 access with FAST bit = 1; 0x000001E2 ***
MCDC1_FAST:         equ    $000001E2                                ;*** MCDC1_FAST - Motor Controller Period Register 1 access with FAST bit = 1; 0x000001E2 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MCDC1_FAST_D2:      equ    0                                         ; Motor Controller Duty Cycle, bit 2
MCDC1_FAST_D3:      equ    1                                         ; Motor Controller Duty Cycle, bit 3
MCDC1_FAST_D4:      equ    2                                         ; Motor Controller Duty Cycle, bit 4
MCDC1_FAST_D5:      equ    3                                         ; Motor Controller Duty Cycle, bit 5
MCDC1_FAST_D6:      equ    4                                         ; Motor Controller Duty Cycle, bit 6
MCDC1_FAST_D7:      equ    5                                         ; Motor Controller Duty Cycle, bit 7
MCDC1_FAST_D8:      equ    6                                         ; Motor Controller Duty Cycle, bit 8
MCDC1_FAST_S:       equ    7                                         ; Sign
; bit position masks
mMCDC1_FAST_D2:     equ    %00000001
mMCDC1_FAST_D3:     equ    %00000010
mMCDC1_FAST_D4:     equ    %00000100
mMCDC1_FAST_D5:     equ    %00001000
mMCDC1_FAST_D6:     equ    %00010000
mMCDC1_FAST_D7:     equ    %00100000
mMCDC1_FAST_D8:     equ    %01000000
mMCDC1_FAST_S:      equ    %10000000


;*** MCDC2 - Motor Controller Period Register 2; 0x000001E4 ***
MCDC2:              equ    $000001E4                                ;*** MCDC2 - Motor Controller Period Register 2; 0x000001E4 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MCDC2_D0:           equ    0                                         ; Motor Controller Duty Cycle, bit 0
MCDC2_D1:           equ    1                                         ; Motor Controller Duty Cycle, bit 1
MCDC2_D2:           equ    2                                         ; Motor Controller Duty Cycle, bit 2
MCDC2_D3:           equ    3                                         ; Motor Controller Duty Cycle, bit 3
MCDC2_D4:           equ    4                                         ; Motor Controller Duty Cycle, bit 4
MCDC2_D5:           equ    5                                         ; Motor Controller Duty Cycle, bit 5
MCDC2_D6:           equ    6                                         ; Motor Controller Duty Cycle, bit 6
MCDC2_D7:           equ    7                                         ; Motor Controller Duty Cycle, bit 7
MCDC2_D8:           equ    8                                         ; Motor Controller Duty Cycle, bit 8
MCDC2_D9:           equ    9                                         ; Motor Controller Duty Cycle, bit 9
MCDC2_D10:          equ    10                                        ; Motor Controller Duty Cycle, bit 10
MCDC2_S:            equ    15                                        ; Sign
; bit position masks
mMCDC2_D0:          equ    %00000001
mMCDC2_D1:          equ    %00000010
mMCDC2_D2:          equ    %00000100
mMCDC2_D3:          equ    %00001000
mMCDC2_D4:          equ    %00010000
mMCDC2_D5:          equ    %00100000
mMCDC2_D6:          equ    %01000000
mMCDC2_D7:          equ    %10000000
mMCDC2_D8:          equ    %100000000
mMCDC2_D9:          equ    %1000000000
mMCDC2_D10:         equ    %10000000000
mMCDC2_S:           equ    %1000000000000000


;*** MCDC2_FAST - Motor Controller Period Register 2 access with FAST bit = 1; 0x000001E4 ***
MCDC2_FAST:         equ    $000001E4                                ;*** MCDC2_FAST - Motor Controller Period Register 2 access with FAST bit = 1; 0x000001E4 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MCDC2_FAST_D2:      equ    0                                         ; Motor Controller Duty Cycle, bit 2
MCDC2_FAST_D3:      equ    1                                         ; Motor Controller Duty Cycle, bit 3
MCDC2_FAST_D4:      equ    2                                         ; Motor Controller Duty Cycle, bit 4
MCDC2_FAST_D5:      equ    3                                         ; Motor Controller Duty Cycle, bit 5
MCDC2_FAST_D6:      equ    4                                         ; Motor Controller Duty Cycle, bit 6
MCDC2_FAST_D7:      equ    5                                         ; Motor Controller Duty Cycle, bit 7
MCDC2_FAST_D8:      equ    6                                         ; Motor Controller Duty Cycle, bit 8
MCDC2_FAST_S:       equ    7                                         ; Sign
; bit position masks
mMCDC2_FAST_D2:     equ    %00000001
mMCDC2_FAST_D3:     equ    %00000010
mMCDC2_FAST_D4:     equ    %00000100
mMCDC2_FAST_D5:     equ    %00001000
mMCDC2_FAST_D6:     equ    %00010000
mMCDC2_FAST_D7:     equ    %00100000
mMCDC2_FAST_D8:     equ    %01000000
mMCDC2_FAST_S:      equ    %10000000


;*** MCDC3 - Motor Controller Period Register 3; 0x000001E6 ***
MCDC3:              equ    $000001E6                                ;*** MCDC3 - Motor Controller Period Register 3; 0x000001E6 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MCDC3_D0:           equ    0                                         ; Motor Controller Duty Cycle, bit 0
MCDC3_D1:           equ    1                                         ; Motor Controller Duty Cycle, bit 1
MCDC3_D2:           equ    2                                         ; Motor Controller Duty Cycle, bit 2
MCDC3_D3:           equ    3                                         ; Motor Controller Duty Cycle, bit 3
MCDC3_D4:           equ    4                                         ; Motor Controller Duty Cycle, bit 4
MCDC3_D5:           equ    5                                         ; Motor Controller Duty Cycle, bit 5
MCDC3_D6:           equ    6                                         ; Motor Controller Duty Cycle, bit 6
MCDC3_D7:           equ    7                                         ; Motor Controller Duty Cycle, bit 7
MCDC3_D8:           equ    8                                         ; Motor Controller Duty Cycle, bit 8
MCDC3_D9:           equ    9                                         ; Motor Controller Duty Cycle, bit 9
MCDC3_D10:          equ    10                                        ; Motor Controller Duty Cycle, bit 10
MCDC3_S:            equ    15                                        ; Sign
; bit position masks
mMCDC3_D0:          equ    %00000001
mMCDC3_D1:          equ    %00000010
mMCDC3_D2:          equ    %00000100
mMCDC3_D3:          equ    %00001000
mMCDC3_D4:          equ    %00010000
mMCDC3_D5:          equ    %00100000
mMCDC3_D6:          equ    %01000000
mMCDC3_D7:          equ    %10000000
mMCDC3_D8:          equ    %100000000
mMCDC3_D9:          equ    %1000000000
mMCDC3_D10:         equ    %10000000000
mMCDC3_S:           equ    %1000000000000000


;*** MCDC3_FAST - Motor Controller Period Register 3 access with FAST bit = 1; 0x000001E6 ***
MCDC3_FAST:         equ    $000001E6                                ;*** MCDC3_FAST - Motor Controller Period Register 3 access with FAST bit = 1; 0x000001E6 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MCDC3_FAST_D2:      equ    0                                         ; Motor Controller Duty Cycle, bit 2
MCDC3_FAST_D3:      equ    1                                         ; Motor Controller Duty Cycle, bit 3
MCDC3_FAST_D4:      equ    2                                         ; Motor Controller Duty Cycle, bit 4
MCDC3_FAST_D5:      equ    3                                         ; Motor Controller Duty Cycle, bit 5
MCDC3_FAST_D6:      equ    4                                         ; Motor Controller Duty Cycle, bit 6
MCDC3_FAST_D7:      equ    5                                         ; Motor Controller Duty Cycle, bit 7
MCDC3_FAST_D8:      equ    6                                         ; Motor Controller Duty Cycle, bit 8
MCDC3_FAST_S:       equ    7                                         ; Sign
; bit position masks
mMCDC3_FAST_D2:     equ    %00000001
mMCDC3_FAST_D3:     equ    %00000010
mMCDC3_FAST_D4:     equ    %00000100
mMCDC3_FAST_D5:     equ    %00001000
mMCDC3_FAST_D6:     equ    %00010000
mMCDC3_FAST_D7:     equ    %00100000
mMCDC3_FAST_D8:     equ    %01000000
mMCDC3_FAST_S:      equ    %10000000


;*** MCDC4 - Motor Controller Period Register 4; 0x000001E8 ***
MCDC4:              equ    $000001E8                                ;*** MCDC4 - Motor Controller Period Register 4; 0x000001E8 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MCDC4_D0:           equ    0                                         ; Motor Controller Duty Cycle, bit 0
MCDC4_D1:           equ    1                                         ; Motor Controller Duty Cycle, bit 1
MCDC4_D2:           equ    2                                         ; Motor Controller Duty Cycle, bit 2
MCDC4_D3:           equ    3                                         ; Motor Controller Duty Cycle, bit 3
MCDC4_D4:           equ    4                                         ; Motor Controller Duty Cycle, bit 4
MCDC4_D5:           equ    5                                         ; Motor Controller Duty Cycle, bit 5
MCDC4_D6:           equ    6                                         ; Motor Controller Duty Cycle, bit 6
MCDC4_D7:           equ    7                                         ; Motor Controller Duty Cycle, bit 7
MCDC4_D8:           equ    8                                         ; Motor Controller Duty Cycle, bit 8
MCDC4_D9:           equ    9                                         ; Motor Controller Duty Cycle, bit 9
MCDC4_D10:          equ    10                                        ; Motor Controller Duty Cycle, bit 10
MCDC4_S:            equ    15                                        ; Sign
; bit position masks
mMCDC4_D0:          equ    %00000001
mMCDC4_D1:          equ    %00000010
mMCDC4_D2:          equ    %00000100
mMCDC4_D3:          equ    %00001000
mMCDC4_D4:          equ    %00010000
mMCDC4_D5:          equ    %00100000
mMCDC4_D6:          equ    %01000000
mMCDC4_D7:          equ    %10000000
mMCDC4_D8:          equ    %100000000
mMCDC4_D9:          equ    %1000000000
mMCDC4_D10:         equ    %10000000000
mMCDC4_S:           equ    %1000000000000000


;*** MCDC4_FAST - Motor Controller Period Register 4 access with FAST bit = 1; 0x000001E8 ***
MCDC4_FAST:         equ    $000001E8                                ;*** MCDC4_FAST - Motor Controller Period Register 4 access with FAST bit = 1; 0x000001E8 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MCDC4_FAST_D2:      equ    0                                         ; Motor Controller Duty Cycle, bit 2
MCDC4_FAST_D3:      equ    1                                         ; Motor Controller Duty Cycle, bit 3
MCDC4_FAST_D4:      equ    2                                         ; Motor Controller Duty Cycle, bit 4
MCDC4_FAST_D5:      equ    3                                         ; Motor Controller Duty Cycle, bit 5
MCDC4_FAST_D6:      equ    4                                         ; Motor Controller Duty Cycle, bit 6
MCDC4_FAST_D7:      equ    5                                         ; Motor Controller Duty Cycle, bit 7
MCDC4_FAST_D8:      equ    6                                         ; Motor Controller Duty Cycle, bit 8
MCDC4_FAST_S:       equ    7                                         ; Sign
; bit position masks
mMCDC4_FAST_D2:     equ    %00000001
mMCDC4_FAST_D3:     equ    %00000010
mMCDC4_FAST_D4:     equ    %00000100
mMCDC4_FAST_D5:     equ    %00001000
mMCDC4_FAST_D6:     equ    %00010000
mMCDC4_FAST_D7:     equ    %00100000
mMCDC4_FAST_D8:     equ    %01000000
mMCDC4_FAST_S:      equ    %10000000


;*** MCDC5 - Motor Controller Period Register 5; 0x000001EA ***
MCDC5:              equ    $000001EA                                ;*** MCDC5 - Motor Controller Period Register 5; 0x000001EA ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MCDC5_D0:           equ    0                                         ; Motor Controller Duty Cycle, bit 0
MCDC5_D1:           equ    1                                         ; Motor Controller Duty Cycle, bit 1
MCDC5_D2:           equ    2                                         ; Motor Controller Duty Cycle, bit 2
MCDC5_D3:           equ    3                                         ; Motor Controller Duty Cycle, bit 3
MCDC5_D4:           equ    4                                         ; Motor Controller Duty Cycle, bit 4
MCDC5_D5:           equ    5                                         ; Motor Controller Duty Cycle, bit 5
MCDC5_D6:           equ    6                                         ; Motor Controller Duty Cycle, bit 6
MCDC5_D7:           equ    7                                         ; Motor Controller Duty Cycle, bit 7
MCDC5_D8:           equ    8                                         ; Motor Controller Duty Cycle, bit 8
MCDC5_D9:           equ    9                                         ; Motor Controller Duty Cycle, bit 9
MCDC5_D10:          equ    10                                        ; Motor Controller Duty Cycle, bit 10
MCDC5_S:            equ    15                                        ; Sign
; bit position masks
mMCDC5_D0:          equ    %00000001
mMCDC5_D1:          equ    %00000010
mMCDC5_D2:          equ    %00000100
mMCDC5_D3:          equ    %00001000
mMCDC5_D4:          equ    %00010000
mMCDC5_D5:          equ    %00100000
mMCDC5_D6:          equ    %01000000
mMCDC5_D7:          equ    %10000000
mMCDC5_D8:          equ    %100000000
mMCDC5_D9:          equ    %1000000000
mMCDC5_D10:         equ    %10000000000
mMCDC5_S:           equ    %1000000000000000


;*** MCDC5_FAST - Motor Controller Period Register 5 access with FAST bit = 1; 0x000001EA ***
MCDC5_FAST:         equ    $000001EA                                ;*** MCDC5_FAST - Motor Controller Period Register 5 access with FAST bit = 1; 0x000001EA ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MCDC5_FAST_D2:      equ    0                                         ; Motor Controller Duty Cycle, bit 2
MCDC5_FAST_D3:      equ    1                                         ; Motor Controller Duty Cycle, bit 3
MCDC5_FAST_D4:      equ    2                                         ; Motor Controller Duty Cycle, bit 4
MCDC5_FAST_D5:      equ    3                                         ; Motor Controller Duty Cycle, bit 5
MCDC5_FAST_D6:      equ    4                                         ; Motor Controller Duty Cycle, bit 6
MCDC5_FAST_D7:      equ    5                                         ; Motor Controller Duty Cycle, bit 7
MCDC5_FAST_D8:      equ    6                                         ; Motor Controller Duty Cycle, bit 8
MCDC5_FAST_S:       equ    7                                         ; Sign
; bit position masks
mMCDC5_FAST_D2:     equ    %00000001
mMCDC5_FAST_D3:     equ    %00000010
mMCDC5_FAST_D4:     equ    %00000100
mMCDC5_FAST_D5:     equ    %00001000
mMCDC5_FAST_D6:     equ    %00010000
mMCDC5_FAST_D7:     equ    %00100000
mMCDC5_FAST_D8:     equ    %01000000
mMCDC5_FAST_S:      equ    %10000000


;*** MCDC6 - Motor Controller Period Register 6; 0x000001EC ***
MCDC6:              equ    $000001EC                                ;*** MCDC6 - Motor Controller Period Register 6; 0x000001EC ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MCDC6_D0:           equ    0                                         ; Motor Controller Duty Cycle, bit 0
MCDC6_D1:           equ    1                                         ; Motor Controller Duty Cycle, bit 1
MCDC6_D2:           equ    2                                         ; Motor Controller Duty Cycle, bit 2
MCDC6_D3:           equ    3                                         ; Motor Controller Duty Cycle, bit 3
MCDC6_D4:           equ    4                                         ; Motor Controller Duty Cycle, bit 4
MCDC6_D5:           equ    5                                         ; Motor Controller Duty Cycle, bit 5
MCDC6_D6:           equ    6                                         ; Motor Controller Duty Cycle, bit 6
MCDC6_D7:           equ    7                                         ; Motor Controller Duty Cycle, bit 7
MCDC6_D8:           equ    8                                         ; Motor Controller Duty Cycle, bit 8
MCDC6_D9:           equ    9                                         ; Motor Controller Duty Cycle, bit 9
MCDC6_D10:          equ    10                                        ; Motor Controller Duty Cycle, bit 10
MCDC6_S:            equ    15                                        ; Sign
; bit position masks
mMCDC6_D0:          equ    %00000001
mMCDC6_D1:          equ    %00000010
mMCDC6_D2:          equ    %00000100
mMCDC6_D3:          equ    %00001000
mMCDC6_D4:          equ    %00010000
mMCDC6_D5:          equ    %00100000
mMCDC6_D6:          equ    %01000000
mMCDC6_D7:          equ    %10000000
mMCDC6_D8:          equ    %100000000
mMCDC6_D9:          equ    %1000000000
mMCDC6_D10:         equ    %10000000000
mMCDC6_S:           equ    %1000000000000000


;*** MCDC6_FAST - Motor Controller Period Register 6 access with FAST bit = 1; 0x000001EC ***
MCDC6_FAST:         equ    $000001EC                                ;*** MCDC6_FAST - Motor Controller Period Register 6 access with FAST bit = 1; 0x000001EC ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MCDC6_FAST_D2:      equ    0                                         ; Motor Controller Duty Cycle, bit 2
MCDC6_FAST_D3:      equ    1                                         ; Motor Controller Duty Cycle, bit 3
MCDC6_FAST_D4:      equ    2                                         ; Motor Controller Duty Cycle, bit 4
MCDC6_FAST_D5:      equ    3                                         ; Motor Controller Duty Cycle, bit 5
MCDC6_FAST_D6:      equ    4                                         ; Motor Controller Duty Cycle, bit 6
MCDC6_FAST_D7:      equ    5                                         ; Motor Controller Duty Cycle, bit 7
MCDC6_FAST_D8:      equ    6                                         ; Motor Controller Duty Cycle, bit 8
MCDC6_FAST_S:       equ    7                                         ; Sign
; bit position masks
mMCDC6_FAST_D2:     equ    %00000001
mMCDC6_FAST_D3:     equ    %00000010
mMCDC6_FAST_D4:     equ    %00000100
mMCDC6_FAST_D5:     equ    %00001000
mMCDC6_FAST_D6:     equ    %00010000
mMCDC6_FAST_D7:     equ    %00100000
mMCDC6_FAST_D8:     equ    %01000000
mMCDC6_FAST_S:      equ    %10000000


;*** MCDC7 - Motor Controller Period Register 7; 0x000001EE ***
MCDC7:              equ    $000001EE                                ;*** MCDC7 - Motor Controller Period Register 7; 0x000001EE ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MCDC7_D0:           equ    0                                         ; Motor Controller Duty Cycle, bit 0
MCDC7_D1:           equ    1                                         ; Motor Controller Duty Cycle, bit 1
MCDC7_D2:           equ    2                                         ; Motor Controller Duty Cycle, bit 2
MCDC7_D3:           equ    3                                         ; Motor Controller Duty Cycle, bit 3
MCDC7_D4:           equ    4                                         ; Motor Controller Duty Cycle, bit 4
MCDC7_D5:           equ    5                                         ; Motor Controller Duty Cycle, bit 5
MCDC7_D6:           equ    6                                         ; Motor Controller Duty Cycle, bit 6
MCDC7_D7:           equ    7                                         ; Motor Controller Duty Cycle, bit 7
MCDC7_D8:           equ    8                                         ; Motor Controller Duty Cycle, bit 8
MCDC7_D9:           equ    9                                         ; Motor Controller Duty Cycle, bit 9
MCDC7_D10:          equ    10                                        ; Motor Controller Duty Cycle, bit 10
MCDC7_S:            equ    15                                        ; Sign
; bit position masks
mMCDC7_D0:          equ    %00000001
mMCDC7_D1:          equ    %00000010
mMCDC7_D2:          equ    %00000100
mMCDC7_D3:          equ    %00001000
mMCDC7_D4:          equ    %00010000
mMCDC7_D5:          equ    %00100000
mMCDC7_D6:          equ    %01000000
mMCDC7_D7:          equ    %10000000
mMCDC7_D8:          equ    %100000000
mMCDC7_D9:          equ    %1000000000
mMCDC7_D10:         equ    %10000000000
mMCDC7_S:           equ    %1000000000000000


;*** MCDC7_FAST - Motor Controller Period Register 7 access with FAST bit = 1; 0x000001EE ***
MCDC7_FAST:         equ    $000001EE                                ;*** MCDC7_FAST - Motor Controller Period Register 7 access with FAST bit = 1; 0x000001EE ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MCDC7_FAST_D2:      equ    0                                         ; Motor Controller Duty Cycle, bit 2
MCDC7_FAST_D3:      equ    1                                         ; Motor Controller Duty Cycle, bit 3
MCDC7_FAST_D4:      equ    2                                         ; Motor Controller Duty Cycle, bit 4
MCDC7_FAST_D5:      equ    3                                         ; Motor Controller Duty Cycle, bit 5
MCDC7_FAST_D6:      equ    4                                         ; Motor Controller Duty Cycle, bit 6
MCDC7_FAST_D7:      equ    5                                         ; Motor Controller Duty Cycle, bit 7
MCDC7_FAST_D8:      equ    6                                         ; Motor Controller Duty Cycle, bit 8
MCDC7_FAST_S:       equ    7                                         ; Sign
; bit position masks
mMCDC7_FAST_D2:     equ    %00000001
mMCDC7_FAST_D3:     equ    %00000010
mMCDC7_FAST_D4:     equ    %00000100
mMCDC7_FAST_D5:     equ    %00001000
mMCDC7_FAST_D6:     equ    %00010000
mMCDC7_FAST_D7:     equ    %00100000
mMCDC7_FAST_D8:     equ    %01000000
mMCDC7_FAST_S:      equ    %10000000


;*** LCDCR0 - LCD Control Register 0; 0x00000200 ***
LCDCR0:             equ    $00000200                                ;*** LCDCR0 - LCD Control Register 0; 0x00000200 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
LCDCR0_DUTY0:       equ    0                                         ; LCD Duty Select Bit 0
LCDCR0_DUTY1:       equ    1                                         ; LCD Duty Select Bit 1
LCDCR0_BIAS:        equ    2                                         ; BIAS Voltage Level Select
LCDCR0_LCLK0:       equ    3                                         ; LCD Clock Prescaler Bit 0
LCDCR0_LCLK1:       equ    4                                         ; LCD Clock Prescaler Bit 1
LCDCR0_LCLK2:       equ    5                                         ; LCD Clock Prescaler Bit 2
LCDCR0_LCDEN:       equ    7                                         ; LCD32F4BV1 Driver System Enable
; bit position masks
mLCDCR0_DUTY0:      equ    %00000001
mLCDCR0_DUTY1:      equ    %00000010
mLCDCR0_BIAS:       equ    %00000100
mLCDCR0_LCLK0:      equ    %00001000
mLCDCR0_LCLK1:      equ    %00010000
mLCDCR0_LCLK2:      equ    %00100000
mLCDCR0_LCDEN:      equ    %10000000


;*** LCDCR1 - LCD Control Register 1; 0x00000201 ***
LCDCR1:             equ    $00000201                                ;*** LCDCR1 - LCD Control Register 1; 0x00000201 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
LCDCR1_LCDSWAI:     equ    1                                         ; LCD Stop in Wait Mode
; bit position masks
mLCDCR1_LCDSWAI:    equ    %00000010


;*** FPENR0 - LCD Frontplane Enable Register 0; 0x00000202 ***
FPENR0:             equ    $00000202                                ;*** FPENR0 - LCD Frontplane Enable Register 0; 0x00000202 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FPENR0_FP0EN:       equ    0                                         ; Frontplane Output Enable Bit 0
FPENR0_FP1EN:       equ    1                                         ; Frontplane Output Enable Bit 1
FPENR0_FP2EN:       equ    2                                         ; Frontplane Output Enable Bit 2
FPENR0_FP3EN:       equ    3                                         ; Frontplane Output Enable Bit 3
FPENR0_FP4EN:       equ    4                                         ; Frontplane Output Enable Bit 4
FPENR0_FP5EN:       equ    5                                         ; Frontplane Output Enable Bit 5
FPENR0_FP6EN:       equ    6                                         ; Frontplane Output Enable Bit 6
FPENR0_FP7EN:       equ    7                                         ; Frontplane Output Enable Bit 7
; bit position masks
mFPENR0_FP0EN:      equ    %00000001
mFPENR0_FP1EN:      equ    %00000010
mFPENR0_FP2EN:      equ    %00000100
mFPENR0_FP3EN:      equ    %00001000
mFPENR0_FP4EN:      equ    %00010000
mFPENR0_FP5EN:      equ    %00100000
mFPENR0_FP6EN:      equ    %01000000
mFPENR0_FP7EN:      equ    %10000000


;*** FPENR1 - LCD Frontplane Enable Register 1; 0x00000203 ***
FPENR1:             equ    $00000203                                ;*** FPENR1 - LCD Frontplane Enable Register 1; 0x00000203 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FPENR1_FP8EN:       equ    0                                         ; Frontplane Output Enable Bit 8
FPENR1_FP9EN:       equ    1                                         ; Frontplane Output Enable Bit 9
FPENR1_FP10EN:      equ    2                                         ; Frontplane Output Enable Bit 10
FPENR1_FP11EN:      equ    3                                         ; Frontplane Output Enable Bit 11
FPENR1_FP12EN:      equ    4                                         ; Frontplane Output Enable Bit 12
FPENR1_FP13EN:      equ    5                                         ; Frontplane Output Enable Bit 13
FPENR1_FP14EN:      equ    6                                         ; Frontplane Output Enable Bit 14
FPENR1_FP15EN:      equ    7                                         ; Frontplane Output Enable Bit 15
; bit position masks
mFPENR1_FP8EN:      equ    %00000001
mFPENR1_FP9EN:      equ    %00000010
mFPENR1_FP10EN:     equ    %00000100
mFPENR1_FP11EN:     equ    %00001000
mFPENR1_FP12EN:     equ    %00010000
mFPENR1_FP13EN:     equ    %00100000
mFPENR1_FP14EN:     equ    %01000000
mFPENR1_FP15EN:     equ    %10000000


;*** FPENR2 - LCD Frontplane Enable Register 2; 0x00000204 ***
FPENR2:             equ    $00000204                                ;*** FPENR2 - LCD Frontplane Enable Register 2; 0x00000204 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FPENR2_FP16EN:      equ    0                                         ; Frontplane Output Enable Bit 16
FPENR2_FP17EN:      equ    1                                         ; Frontplane Output Enable Bit 17
FPENR2_FP18EN:      equ    2                                         ; Frontplane Output Enable Bit 18
FPENR2_FP19EN:      equ    3                                         ; Frontplane Output Enable Bit 19
FPENR2_FP20EN:      equ    4                                         ; Frontplane Output Enable Bit 20
FPENR2_FP21EN:      equ    5                                         ; Frontplane Output Enable Bit 21
FPENR2_FP22EN:      equ    6                                         ; Frontplane Output Enable Bit 22
FPENR2_FP23EN:      equ    7                                         ; Frontplane Output Enable Bit 23
; bit position masks
mFPENR2_FP16EN:     equ    %00000001
mFPENR2_FP17EN:     equ    %00000010
mFPENR2_FP18EN:     equ    %00000100
mFPENR2_FP19EN:     equ    %00001000
mFPENR2_FP20EN:     equ    %00010000
mFPENR2_FP21EN:     equ    %00100000
mFPENR2_FP22EN:     equ    %01000000
mFPENR2_FP23EN:     equ    %10000000


;*** FPENR3 - LCD Frontplane Enable Register 3; 0x00000205 ***
FPENR3:             equ    $00000205                                ;*** FPENR3 - LCD Frontplane Enable Register 3; 0x00000205 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FPENR3_FP24EN:      equ    0                                         ; Frontplane Output Enable Bit 24
FPENR3_FP25EN:      equ    1                                         ; Frontplane Output Enable Bit 25
FPENR3_FP26EN:      equ    2                                         ; Frontplane Output Enable Bit 26
FPENR3_FP27EN:      equ    3                                         ; Frontplane Output Enable Bit 27
FPENR3_FP28EN:      equ    4                                         ; Frontplane Output Enable Bit 28
FPENR3_FP29EN:      equ    5                                         ; Frontplane Output Enable Bit 29
FPENR3_FP30EN:      equ    6                                         ; Frontplane Output Enable Bit 30
FPENR3_FP31EN:      equ    7                                         ; Frontplane Output Enable Bit 31
; bit position masks
mFPENR3_FP24EN:     equ    %00000001
mFPENR3_FP25EN:     equ    %00000010
mFPENR3_FP26EN:     equ    %00000100
mFPENR3_FP27EN:     equ    %00001000
mFPENR3_FP28EN:     equ    %00010000
mFPENR3_FP29EN:     equ    %00100000
mFPENR3_FP30EN:     equ    %01000000
mFPENR3_FP31EN:     equ    %10000000


;*** FPENR4 - LCD Frontplane Enable Register 4; 0x00000206 ***
FPENR4:             equ    $00000206                                ;*** FPENR4 - LCD Frontplane Enable Register 4; 0x00000206 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FPENR4_FP32EN:      equ    0                                         ; Frontplane Output Enable Bit 32
FPENR4_FP33EN:      equ    1                                         ; Frontplane Output Enable Bit 33
FPENR4_FP34EN:      equ    2                                         ; Frontplane Output Enable Bit 34
FPENR4_FP35EN:      equ    3                                         ; Frontplane Output Enable Bit 35
FPENR4_FP36EN:      equ    4                                         ; Frontplane Output Enable Bit 36
FPENR4_FP37EN:      equ    5                                         ; Frontplane Output Enable Bit 37
FPENR4_FP38EN:      equ    6                                         ; Frontplane Output Enable Bit 38
FPENR4_FP39EN:      equ    7                                         ; Frontplane Output Enable Bit 39
; bit position masks
mFPENR4_FP32EN:     equ    %00000001
mFPENR4_FP33EN:     equ    %00000010
mFPENR4_FP34EN:     equ    %00000100
mFPENR4_FP35EN:     equ    %00001000
mFPENR4_FP36EN:     equ    %00010000
mFPENR4_FP37EN:     equ    %00100000
mFPENR4_FP38EN:     equ    %01000000
mFPENR4_FP39EN:     equ    %10000000


;*** LCDRAM0 - LCD RAM 0; 0x00000208 ***
LCDRAM0:            equ    $00000208                                ;*** LCDRAM0 - LCD RAM 0; 0x00000208 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
LCDRAM0_FP0BP0:     equ    0                                         ; LCD Segment FP0, BP0 ON
LCDRAM0_FP0BP1:     equ    1                                         ; LCD Segment FP0, BP1 ON
LCDRAM0_FP0BP2:     equ    2                                         ; LCD Segment FP0, BP2 ON
LCDRAM0_FP0BP3:     equ    3                                         ; LCD Segment FP0, BP3 ON
LCDRAM0_FP1BP0:     equ    4                                         ; LCD Segment FP1, BP0 ON
LCDRAM0_FP1BP1:     equ    5                                         ; LCD Segment FP1, BP1 ON
LCDRAM0_FP1BP2:     equ    6                                         ; LCD Segment FP1, BP2 ON
LCDRAM0_FP1BP3:     equ    7                                         ; LCD Segment FP1, BP3 ON
; bit position masks
mLCDRAM0_FP0BP0:    equ    %00000001
mLCDRAM0_FP0BP1:    equ    %00000010
mLCDRAM0_FP0BP2:    equ    %00000100
mLCDRAM0_FP0BP3:    equ    %00001000
mLCDRAM0_FP1BP0:    equ    %00010000
mLCDRAM0_FP1BP1:    equ    %00100000
mLCDRAM0_FP1BP2:    equ    %01000000
mLCDRAM0_FP1BP3:    equ    %10000000


;*** LCDRAM1 - LCD RAM 1; 0x00000209 ***
LCDRAM1:            equ    $00000209                                ;*** LCDRAM1 - LCD RAM 1; 0x00000209 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
LCDRAM1_FP2BP0:     equ    0                                         ; LCD Segment FP2, BP0 ON
LCDRAM1_FP2BP1:     equ    1                                         ; LCD Segment FP2, BP1 ON
LCDRAM1_FP2BP2:     equ    2                                         ; LCD Segment FP2, BP2 ON
LCDRAM1_FP2BP3:     equ    3                                         ; LCD Segment FP2, BP3 ON
LCDRAM1_FP3BP0:     equ    4                                         ; LCD Segment FP3, BP0 ON
LCDRAM1_FP3BP1:     equ    5                                         ; LCD Segment FP3, BP1 ON
LCDRAM1_FP3BP2:     equ    6                                         ; LCD Segment FP3, BP2 ON
LCDRAM1_FP3BP3:     equ    7                                         ; LCD Segment FP3, BP3 ON
; bit position masks
mLCDRAM1_FP2BP0:    equ    %00000001
mLCDRAM1_FP2BP1:    equ    %00000010
mLCDRAM1_FP2BP2:    equ    %00000100
mLCDRAM1_FP2BP3:    equ    %00001000
mLCDRAM1_FP3BP0:    equ    %00010000
mLCDRAM1_FP3BP1:    equ    %00100000
mLCDRAM1_FP3BP2:    equ    %01000000
mLCDRAM1_FP3BP3:    equ    %10000000


;*** LCDRAM2 - LCD RAM 2; 0x0000020A ***
LCDRAM2:            equ    $0000020A                                ;*** LCDRAM2 - LCD RAM 2; 0x0000020A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
LCDRAM2_FP4BP0:     equ    0                                         ; LCD Segment FP4, BP0 ON
LCDRAM2_FP4BP1:     equ    1                                         ; LCD Segment FP4, BP1 ON
LCDRAM2_FP4BP2:     equ    2                                         ; LCD Segment FP4, BP2 ON
LCDRAM2_FP4BP3:     equ    3                                         ; LCD Segment FP4, BP3 ON
LCDRAM2_FP5BP0:     equ    4                                         ; LCD Segment FP5, BP0 ON
LCDRAM2_FP5BP1:     equ    5                                         ; LCD Segment FP5, BP1 ON
LCDRAM2_FP5BP2:     equ    6                                         ; LCD Segment FP5, BP2 ON
LCDRAM2_FP5BP3:     equ    7                                         ; LCD Segment FP5, BP3 ON
; bit position masks
mLCDRAM2_FP4BP0:    equ    %00000001
mLCDRAM2_FP4BP1:    equ    %00000010
mLCDRAM2_FP4BP2:    equ    %00000100
mLCDRAM2_FP4BP3:    equ    %00001000
mLCDRAM2_FP5BP0:    equ    %00010000
mLCDRAM2_FP5BP1:    equ    %00100000
mLCDRAM2_FP5BP2:    equ    %01000000
mLCDRAM2_FP5BP3:    equ    %10000000


;*** LCDRAM3 - LCD RAM 3; 0x0000020B ***
LCDRAM3:            equ    $0000020B                                ;*** LCDRAM3 - LCD RAM 3; 0x0000020B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
LCDRAM3_FP6BP0:     equ    0                                         ; LCD Segment FP6, BP0 ON
LCDRAM3_FP6BP1:     equ    1                                         ; LCD Segment FP6, BP1 ON
LCDRAM3_FP6BP2:     equ    2                                         ; LCD Segment FP6, BP2 ON
LCDRAM3_FP6BP3:     equ    3                                         ; LCD Segment FP6, BP3 ON
LCDRAM3_FP7BP0:     equ    4                                         ; LCD Segment FP7, BP0 ON
LCDRAM3_FP7BP1:     equ    5                                         ; LCD Segment FP7, BP1 ON
LCDRAM3_FP7BP2:     equ    6                                         ; LCD Segment FP7, BP2 ON
LCDRAM3_FP7BP3:     equ    7                                         ; LCD Segment FP7, BP3 ON
; bit position masks
mLCDRAM3_FP6BP0:    equ    %00000001
mLCDRAM3_FP6BP1:    equ    %00000010
mLCDRAM3_FP6BP2:    equ    %00000100
mLCDRAM3_FP6BP3:    equ    %00001000
mLCDRAM3_FP7BP0:    equ    %00010000
mLCDRAM3_FP7BP1:    equ    %00100000
mLCDRAM3_FP7BP2:    equ    %01000000
mLCDRAM3_FP7BP3:    equ    %10000000


;*** LCDRAM4 - LCD RAM 4; 0x0000020C ***
LCDRAM4:            equ    $0000020C                                ;*** LCDRAM4 - LCD RAM 4; 0x0000020C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
LCDRAM4_FP8BP0:     equ    0                                         ; LCD Segment FP8, BP0 ON
LCDRAM4_FP8BP1:     equ    1                                         ; LCD Segment FP8, BP1 ON
LCDRAM4_FP8BP2:     equ    2                                         ; LCD Segment FP8, BP2 ON
LCDRAM4_FP8BP3:     equ    3                                         ; LCD Segment FP8, BP3 ON
LCDRAM4_FP9BP0:     equ    4                                         ; LCD Segment FP9, BP0 ON
LCDRAM4_FP9BP1:     equ    5                                         ; LCD Segment FP9, BP1 ON
LCDRAM4_FP9BP2:     equ    6                                         ; LCD Segment FP9, BP2 ON
LCDRAM4_FP9BP3:     equ    7                                         ; LCD Segment FP9, BP3 ON
; bit position masks
mLCDRAM4_FP8BP0:    equ    %00000001
mLCDRAM4_FP8BP1:    equ    %00000010
mLCDRAM4_FP8BP2:    equ    %00000100
mLCDRAM4_FP8BP3:    equ    %00001000
mLCDRAM4_FP9BP0:    equ    %00010000
mLCDRAM4_FP9BP1:    equ    %00100000
mLCDRAM4_FP9BP2:    equ    %01000000
mLCDRAM4_FP9BP3:    equ    %10000000


;*** LCDRAM5 - LCD RAM 5; 0x0000020D ***
LCDRAM5:            equ    $0000020D                                ;*** LCDRAM5 - LCD RAM 5; 0x0000020D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
LCDRAM5_FP10BP0:    equ    0                                         ; LCD Segment FP10, BP0 ON
LCDRAM5_FP10BP1:    equ    1                                         ; LCD Segment FP10, BP1 ON
LCDRAM5_FP10BP2:    equ    2                                         ; LCD Segment FP10, BP2 ON
LCDRAM5_FP10BP3:    equ    3                                         ; LCD Segment FP10, BP3 ON
LCDRAM5_FP11BP0:    equ    4                                         ; LCD Segment FP11, BP0 ON
LCDRAM5_FP11BP1:    equ    5                                         ; LCD Segment FP11, BP1 ON
LCDRAM5_FP11BP2:    equ    6                                         ; LCD Segment FP11, BP2 ON
LCDRAM5_FP11BP3:    equ    7                                         ; LCD Segment FP11, BP3 ON
; bit position masks
mLCDRAM5_FP10BP0:   equ    %00000001
mLCDRAM5_FP10BP1:   equ    %00000010
mLCDRAM5_FP10BP2:   equ    %00000100
mLCDRAM5_FP10BP3:   equ    %00001000
mLCDRAM5_FP11BP0:   equ    %00010000
mLCDRAM5_FP11BP1:   equ    %00100000
mLCDRAM5_FP11BP2:   equ    %01000000
mLCDRAM5_FP11BP3:   equ    %10000000


;*** LCDRAM6 - LCD RAM 6; 0x0000020E ***
LCDRAM6:            equ    $0000020E                                ;*** LCDRAM6 - LCD RAM 6; 0x0000020E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
LCDRAM6_FP12BP0:    equ    0                                         ; LCD Segment FP12, BP0 ON
LCDRAM6_FP12BP1:    equ    1                                         ; LCD Segment FP12, BP1 ON
LCDRAM6_FP12BP2:    equ    2                                         ; LCD Segment FP12, BP2 ON
LCDRAM6_FP12BP3:    equ    3                                         ; LCD Segment FP12, BP3 ON
LCDRAM6_FP13BP0:    equ    4                                         ; LCD Segment FP13, BP0 ON
LCDRAM6_FP13BP1:    equ    5                                         ; LCD Segment FP13, BP1 ON
LCDRAM6_FP13BP2:    equ    6                                         ; LCD Segment FP13, BP2 ON
LCDRAM6_FP13BP3:    equ    7                                         ; LCD Segment FP13, BP3 ON
; bit position masks
mLCDRAM6_FP12BP0:   equ    %00000001
mLCDRAM6_FP12BP1:   equ    %00000010
mLCDRAM6_FP12BP2:   equ    %00000100
mLCDRAM6_FP12BP3:   equ    %00001000
mLCDRAM6_FP13BP0:   equ    %00010000
mLCDRAM6_FP13BP1:   equ    %00100000
mLCDRAM6_FP13BP2:   equ    %01000000
mLCDRAM6_FP13BP3:   equ    %10000000


;*** LCDRAM7 - LCD RAM 7; 0x0000020F ***
LCDRAM7:            equ    $0000020F                                ;*** LCDRAM7 - LCD RAM 7; 0x0000020F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
LCDRAM7_FP14BP0:    equ    0                                         ; LCD Segment FP14, BP0 ON
LCDRAM7_FP14BP1:    equ    1                                         ; LCD Segment FP14, BP1 ON
LCDRAM7_FP14BP2:    equ    2                                         ; LCD Segment FP14, BP2 ON
LCDRAM7_FP14BP3:    equ    3                                         ; LCD Segment FP14, BP3 ON
LCDRAM7_FP15BP0:    equ    4                                         ; LCD Segment FP15, BP0 ON
LCDRAM7_FP15BP1:    equ    5                                         ; LCD Segment FP15, BP1 ON
LCDRAM7_FP15BP2:    equ    6                                         ; LCD Segment FP15, BP2 ON
LCDRAM7_FP15BP3:    equ    7                                         ; LCD Segment FP15, BP3 ON
; bit position masks
mLCDRAM7_FP14BP0:   equ    %00000001
mLCDRAM7_FP14BP1:   equ    %00000010
mLCDRAM7_FP14BP2:   equ    %00000100
mLCDRAM7_FP14BP3:   equ    %00001000
mLCDRAM7_FP15BP0:   equ    %00010000
mLCDRAM7_FP15BP1:   equ    %00100000
mLCDRAM7_FP15BP2:   equ    %01000000
mLCDRAM7_FP15BP3:   equ    %10000000


;*** LCDRAM8 - LCD RAM 8; 0x00000210 ***
LCDRAM8:            equ    $00000210                                ;*** LCDRAM8 - LCD RAM 8; 0x00000210 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
LCDRAM8_FP16BP0:    equ    0                                         ; LCD Segment FP16, BP0 ON
LCDRAM8_FP16BP1:    equ    1                                         ; LCD Segment FP16, BP1 ON
LCDRAM8_FP16BP2:    equ    2                                         ; LCD Segment FP16, BP2 ON
LCDRAM8_FP16BP3:    equ    3                                         ; LCD Segment FP16, BP3 ON
LCDRAM8_FP17BP0:    equ    4                                         ; LCD Segment FP17, BP0 ON
LCDRAM8_FP17BP1:    equ    5                                         ; LCD Segment FP17, BP1 ON
LCDRAM8_FP17BP2:    equ    6                                         ; LCD Segment FP17, BP2 ON
LCDRAM8_FP17BP3:    equ    7                                         ; LCD Segment FP17, BP3 ON
; bit position masks
mLCDRAM8_FP16BP0:   equ    %00000001
mLCDRAM8_FP16BP1:   equ    %00000010
mLCDRAM8_FP16BP2:   equ    %00000100
mLCDRAM8_FP16BP3:   equ    %00001000
mLCDRAM8_FP17BP0:   equ    %00010000
mLCDRAM8_FP17BP1:   equ    %00100000
mLCDRAM8_FP17BP2:   equ    %01000000
mLCDRAM8_FP17BP3:   equ    %10000000


;*** LCDRAM9 - LCD RAM 9; 0x00000211 ***
LCDRAM9:            equ    $00000211                                ;*** LCDRAM9 - LCD RAM 9; 0x00000211 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
LCDRAM9_FP18BP0:    equ    0                                         ; LCD Segment FP18, BP0 ON
LCDRAM9_FP18BP1:    equ    1                                         ; LCD Segment FP18, BP1 ON
LCDRAM9_FP18BP2:    equ    2                                         ; LCD Segment FP18, BP2 ON
LCDRAM9_FP18BP3:    equ    3                                         ; LCD Segment FP18, BP3 ON
LCDRAM9_FP19BP0:    equ    4                                         ; LCD Segment FP19, BP0 ON
LCDRAM9_FP19BP1:    equ    5                                         ; LCD Segment FP19, BP1 ON
LCDRAM9_FP19BP2:    equ    6                                         ; LCD Segment FP19, BP2 ON
LCDRAM9_FP19BP3:    equ    7                                         ; LCD Segment FP19, BP3 ON
; bit position masks
mLCDRAM9_FP18BP0:   equ    %00000001
mLCDRAM9_FP18BP1:   equ    %00000010
mLCDRAM9_FP18BP2:   equ    %00000100
mLCDRAM9_FP18BP3:   equ    %00001000
mLCDRAM9_FP19BP0:   equ    %00010000
mLCDRAM9_FP19BP1:   equ    %00100000
mLCDRAM9_FP19BP2:   equ    %01000000
mLCDRAM9_FP19BP3:   equ    %10000000


;*** LCDRAM10 - LCD RAM 10; 0x00000212 ***
LCDRAM10:           equ    $00000212                                ;*** LCDRAM10 - LCD RAM 10; 0x00000212 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
LCDRAM10_FP20BP0:   equ    0                                         ; LCD Segment FP20, BP0 ON
LCDRAM10_FP20BP1:   equ    1                                         ; LCD Segment FP20, BP1 ON
LCDRAM10_FP20BP2:   equ    2                                         ; LCD Segment FP20, BP2 ON
LCDRAM10_FP20BP3:   equ    3                                         ; LCD Segment FP20, BP3 ON
LCDRAM10_FP21BP0:   equ    4                                         ; LCD Segment FP21, BP0 ON
LCDRAM10_FP21BP1:   equ    5                                         ; LCD Segment FP21, BP1 ON
LCDRAM10_FP21BP2:   equ    6                                         ; LCD Segment FP21, BP2 ON
LCDRAM10_FP21BP3:   equ    7                                         ; LCD Segment FP21, BP3 ON
; bit position masks
mLCDRAM10_FP20BP0:  equ    %00000001
mLCDRAM10_FP20BP1:  equ    %00000010
mLCDRAM10_FP20BP2:  equ    %00000100
mLCDRAM10_FP20BP3:  equ    %00001000
mLCDRAM10_FP21BP0:  equ    %00010000
mLCDRAM10_FP21BP1:  equ    %00100000
mLCDRAM10_FP21BP2:  equ    %01000000
mLCDRAM10_FP21BP3:  equ    %10000000


;*** LCDRAM11 - LCD RAM 11; 0x00000213 ***
LCDRAM11:           equ    $00000213                                ;*** LCDRAM11 - LCD RAM 11; 0x00000213 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
LCDRAM11_FP22BP0:   equ    0                                         ; LCD Segment FP22, BP0 ON
LCDRAM11_FP22BP1:   equ    1                                         ; LCD Segment FP22, BP1 ON
LCDRAM11_FP22BP2:   equ    2                                         ; LCD Segment FP22, BP2 ON
LCDRAM11_FP22BP3:   equ    3                                         ; LCD Segment FP22, BP3 ON
LCDRAM11_FP23BP0:   equ    4                                         ; LCD Segment FP23, BP0 ON
LCDRAM11_FP23BP1:   equ    5                                         ; LCD Segment FP23, BP1 ON
LCDRAM11_FP23BP2:   equ    6                                         ; LCD Segment FP23, BP2 ON
LCDRAM11_FP23BP3:   equ    7                                         ; LCD Segment FP23, BP3 ON
; bit position masks
mLCDRAM11_FP22BP0:  equ    %00000001
mLCDRAM11_FP22BP1:  equ    %00000010
mLCDRAM11_FP22BP2:  equ    %00000100
mLCDRAM11_FP22BP3:  equ    %00001000
mLCDRAM11_FP23BP0:  equ    %00010000
mLCDRAM11_FP23BP1:  equ    %00100000
mLCDRAM11_FP23BP2:  equ    %01000000
mLCDRAM11_FP23BP3:  equ    %10000000


;*** LCDRAM12 - LCD RAM 12; 0x00000214 ***
LCDRAM12:           equ    $00000214                                ;*** LCDRAM12 - LCD RAM 12; 0x00000214 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
LCDRAM12_FP24BP0:   equ    0                                         ; LCD Segment FP24, BP0 ON
LCDRAM12_FP24BP1:   equ    1                                         ; LCD Segment FP24, BP1 ON
LCDRAM12_FP24BP2:   equ    2                                         ; LCD Segment FP24, BP2 ON
LCDRAM12_FP24BP3:   equ    3                                         ; LCD Segment FP24, BP3 ON
LCDRAM12_FP25BP0:   equ    4                                         ; LCD Segment FP25, BP0 ON
LCDRAM12_FP25BP1:   equ    5                                         ; LCD Segment FP25, BP1 ON
LCDRAM12_FP25BP2:   equ    6                                         ; LCD Segment FP25, BP2 ON
LCDRAM12_FP25BP3:   equ    7                                         ; LCD Segment FP25, BP3 ON
; bit position masks
mLCDRAM12_FP24BP0:  equ    %00000001
mLCDRAM12_FP24BP1:  equ    %00000010
mLCDRAM12_FP24BP2:  equ    %00000100
mLCDRAM12_FP24BP3:  equ    %00001000
mLCDRAM12_FP25BP0:  equ    %00010000
mLCDRAM12_FP25BP1:  equ    %00100000
mLCDRAM12_FP25BP2:  equ    %01000000
mLCDRAM12_FP25BP3:  equ    %10000000


;*** LCDRAM13 - LCD RAM 13; 0x00000215 ***
LCDRAM13:           equ    $00000215                                ;*** LCDRAM13 - LCD RAM 13; 0x00000215 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
LCDRAM13_FP26BP0:   equ    0                                         ; LCD Segment FP26, BP0 ON
LCDRAM13_FP26BP1:   equ    1                                         ; LCD Segment FP26, BP1 ON
LCDRAM13_FP26BP2:   equ    2                                         ; LCD Segment FP26, BP2 ON
LCDRAM13_FP26BP3:   equ    3                                         ; LCD Segment FP26, BP3 ON
LCDRAM13_FP27BP0:   equ    4                                         ; LCD Segment FP27, BP0 ON
LCDRAM13_FP27BP1:   equ    5                                         ; LCD Segment FP27, BP1 ON
LCDRAM13_FP27BP2:   equ    6                                         ; LCD Segment FP27, BP2 ON
LCDRAM13_FP27BP3:   equ    7                                         ; LCD Segment FP27, BP3 ON
; bit position masks
mLCDRAM13_FP26BP0:  equ    %00000001
mLCDRAM13_FP26BP1:  equ    %00000010
mLCDRAM13_FP26BP2:  equ    %00000100
mLCDRAM13_FP26BP3:  equ    %00001000
mLCDRAM13_FP27BP0:  equ    %00010000
mLCDRAM13_FP27BP1:  equ    %00100000
mLCDRAM13_FP27BP2:  equ    %01000000
mLCDRAM13_FP27BP3:  equ    %10000000


;*** LCDRAM14 - LCD RAM 14; 0x00000216 ***
LCDRAM14:           equ    $00000216                                ;*** LCDRAM14 - LCD RAM 14; 0x00000216 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
LCDRAM14_FP28BP0:   equ    0                                         ; LCD Segment FP28, BP0 ON
LCDRAM14_FP28BP1:   equ    1                                         ; LCD Segment FP28, BP1 ON
LCDRAM14_FP28BP2:   equ    2                                         ; LCD Segment FP28, BP2 ON
LCDRAM14_FP28BP3:   equ    3                                         ; LCD Segment FP28, BP3 ON
LCDRAM14_FP29BP0:   equ    4                                         ; LCD Segment FP29, BP0 ON
LCDRAM14_FP29BP1:   equ    5                                         ; LCD Segment FP29, BP1 ON
LCDRAM14_FP29BP2:   equ    6                                         ; LCD Segment FP29, BP2 ON
LCDRAM14_FP29BP3:   equ    7                                         ; LCD Segment FP29, BP3 ON
; bit position masks
mLCDRAM14_FP28BP0:  equ    %00000001
mLCDRAM14_FP28BP1:  equ    %00000010
mLCDRAM14_FP28BP2:  equ    %00000100
mLCDRAM14_FP28BP3:  equ    %00001000
mLCDRAM14_FP29BP0:  equ    %00010000
mLCDRAM14_FP29BP1:  equ    %00100000
mLCDRAM14_FP29BP2:  equ    %01000000
mLCDRAM14_FP29BP3:  equ    %10000000


;*** LCDRAM15 - LCD RAM 15; 0x00000217 ***
LCDRAM15:           equ    $00000217                                ;*** LCDRAM15 - LCD RAM 15; 0x00000217 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
LCDRAM15_FP30BP0:   equ    0                                         ; LCD Segment FP30, BP0 ON
LCDRAM15_FP30BP1:   equ    1                                         ; LCD Segment FP30, BP1 ON
LCDRAM15_FP30BP2:   equ    2                                         ; LCD Segment FP30, BP2 ON
LCDRAM15_FP30BP3:   equ    3                                         ; LCD Segment FP30, BP3 ON
LCDRAM15_FP31BP0:   equ    4                                         ; LCD Segment FP31, BP0 ON
LCDRAM15_FP31BP1:   equ    5                                         ; LCD Segment FP31, BP1 ON
LCDRAM15_FP31BP2:   equ    6                                         ; LCD Segment FP31, BP2 ON
LCDRAM15_FP31BP3:   equ    7                                         ; LCD Segment FP31, BP3 ON
; bit position masks
mLCDRAM15_FP30BP0:  equ    %00000001
mLCDRAM15_FP30BP1:  equ    %00000010
mLCDRAM15_FP30BP2:  equ    %00000100
mLCDRAM15_FP30BP3:  equ    %00001000
mLCDRAM15_FP31BP0:  equ    %00010000
mLCDRAM15_FP31BP1:  equ    %00100000
mLCDRAM15_FP31BP2:  equ    %01000000
mLCDRAM15_FP31BP3:  equ    %10000000


;*** LCDRAM16 - LCD RAM 16; 0x00000218 ***
LCDRAM16:           equ    $00000218                                ;*** LCDRAM16 - LCD RAM 16; 0x00000218 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
LCDRAM16_FP32BP0:   equ    0                                         ; LCD Segment FP32, BP0 ON
LCDRAM16_FP32BP1:   equ    1                                         ; LCD Segment FP32, BP1 ON
LCDRAM16_FP32BP2:   equ    2                                         ; LCD Segment FP32, BP2 ON
LCDRAM16_FP32BP3:   equ    3                                         ; LCD Segment FP32, BP3 ON
LCDRAM16_FP33BP0:   equ    4                                         ; LCD Segment FP33, BP0 ON
LCDRAM16_FP33BP1:   equ    5                                         ; LCD Segment FP33, BP1 ON
LCDRAM16_FP33BP2:   equ    6                                         ; LCD Segment FP33, BP2 ON
LCDRAM16_FP33BP3:   equ    7                                         ; LCD Segment FP33, BP3 ON
; bit position masks
mLCDRAM16_FP32BP0:  equ    %00000001
mLCDRAM16_FP32BP1:  equ    %00000010
mLCDRAM16_FP32BP2:  equ    %00000100
mLCDRAM16_FP32BP3:  equ    %00001000
mLCDRAM16_FP33BP0:  equ    %00010000
mLCDRAM16_FP33BP1:  equ    %00100000
mLCDRAM16_FP33BP2:  equ    %01000000
mLCDRAM16_FP33BP3:  equ    %10000000


;*** LCDRAM17 - LCD RAM 17; 0x00000219 ***
LCDRAM17:           equ    $00000219                                ;*** LCDRAM17 - LCD RAM 17; 0x00000219 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
LCDRAM17_FP34BP0:   equ    0                                         ; LCD Segment FP34, BP0 ON
LCDRAM17_FP34BP1:   equ    1                                         ; LCD Segment FP34, BP1 ON
LCDRAM17_FP34BP2:   equ    2                                         ; LCD Segment FP34, BP2 ON
LCDRAM17_FP34BP3:   equ    3                                         ; LCD Segment FP34, BP3 ON
LCDRAM17_FP35BP0:   equ    4                                         ; LCD Segment FP35, BP0 ON
LCDRAM17_FP35BP1:   equ    5                                         ; LCD Segment FP35, BP1 ON
LCDRAM17_FP35BP2:   equ    6                                         ; LCD Segment FP35, BP2 ON
LCDRAM17_FP35BP3:   equ    7                                         ; LCD Segment FP35, BP3 ON
; bit position masks
mLCDRAM17_FP34BP0:  equ    %00000001
mLCDRAM17_FP34BP1:  equ    %00000010
mLCDRAM17_FP34BP2:  equ    %00000100
mLCDRAM17_FP34BP3:  equ    %00001000
mLCDRAM17_FP35BP0:  equ    %00010000
mLCDRAM17_FP35BP1:  equ    %00100000
mLCDRAM17_FP35BP2:  equ    %01000000
mLCDRAM17_FP35BP3:  equ    %10000000


;*** LCDRAM18 - LCD RAM 18; 0x0000021A ***
LCDRAM18:           equ    $0000021A                                ;*** LCDRAM18 - LCD RAM 18; 0x0000021A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
LCDRAM18_FP36BP0:   equ    0                                         ; LCD Segment FP36, BP0 ON
LCDRAM18_FP36BP1:   equ    1                                         ; LCD Segment FP36, BP1 ON
LCDRAM18_FP36BP2:   equ    2                                         ; LCD Segment FP36, BP2 ON
LCDRAM18_FP36BP3:   equ    3                                         ; LCD Segment FP36, BP3 ON
LCDRAM18_FP37BP0:   equ    4                                         ; LCD Segment FP37, BP0 ON
LCDRAM18_FP37BP1:   equ    5                                         ; LCD Segment FP37, BP1 ON
LCDRAM18_FP37BP2:   equ    6                                         ; LCD Segment FP37, BP2 ON
LCDRAM18_FP37BP3:   equ    7                                         ; LCD Segment FP37, BP3 ON
; bit position masks
mLCDRAM18_FP36BP0:  equ    %00000001
mLCDRAM18_FP36BP1:  equ    %00000010
mLCDRAM18_FP36BP2:  equ    %00000100
mLCDRAM18_FP36BP3:  equ    %00001000
mLCDRAM18_FP37BP0:  equ    %00010000
mLCDRAM18_FP37BP1:  equ    %00100000
mLCDRAM18_FP37BP2:  equ    %01000000
mLCDRAM18_FP37BP3:  equ    %10000000


;*** LCDRAM19 - LCD RAM 19; 0x0000021B ***
LCDRAM19:           equ    $0000021B                                ;*** LCDRAM19 - LCD RAM 19; 0x0000021B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
LCDRAM19_FP38BP0:   equ    0                                         ; LCD Segment FP38, BP0 ON
LCDRAM19_FP38BP1:   equ    1                                         ; LCD Segment FP38, BP1 ON
LCDRAM19_FP38BP2:   equ    2                                         ; LCD Segment FP38, BP2 ON
LCDRAM19_FP38BP3:   equ    3                                         ; LCD Segment FP38, BP3 ON
LCDRAM19_FP39BP0:   equ    4                                         ; LCD Segment FP39, BP0 ON
LCDRAM19_FP39BP1:   equ    5                                         ; LCD Segment FP39, BP1 ON
LCDRAM19_FP39BP2:   equ    6                                         ; LCD Segment FP39, BP2 ON
LCDRAM19_FP39BP3:   equ    7                                         ; LCD Segment FP39, BP3 ON
; bit position masks
mLCDRAM19_FP38BP0:  equ    %00000001
mLCDRAM19_FP38BP1:  equ    %00000010
mLCDRAM19_FP38BP2:  equ    %00000100
mLCDRAM19_FP38BP3:  equ    %00001000
mLCDRAM19_FP39BP0:  equ    %00010000
mLCDRAM19_FP39BP1:  equ    %00100000
mLCDRAM19_FP39BP2:  equ    %01000000
mLCDRAM19_FP39BP3:  equ    %10000000


;*** PTT - Port T Data Register; 0x00000240 ***
PTT:                equ    $00000240                                ;*** PTT - Port T Data Register; 0x00000240 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTT_PTT0:           equ    0                                         ; Port T general purpose input/output data bit 0
PTT_PTT1:           equ    1                                         ; Port T general purpose input/output data bit 1
PTT_PTT2:           equ    2                                         ; Port T general purpose input/output data bit 2
PTT_PTT3:           equ    3                                         ; Port T general purpose input/output data bit 3
PTT_PTT4:           equ    4                                         ; Port T general purpose input/output data bit 4
PTT_PTT5:           equ    5                                         ; Port T general purpose input/output data bit 5
PTT_PTT6:           equ    6                                         ; Port T general purpose input/output data bit 6
PTT_PTT7:           equ    7                                         ; Port T general purpose input/output data bit 7
; bit position masks
mPTT_PTT0:          equ    %00000001
mPTT_PTT1:          equ    %00000010
mPTT_PTT2:          equ    %00000100
mPTT_PTT3:          equ    %00001000
mPTT_PTT4:          equ    %00010000
mPTT_PTT5:          equ    %00100000
mPTT_PTT6:          equ    %01000000
mPTT_PTT7:          equ    %10000000


;*** PTIT - Port T Input Register; 0x00000241 ***
PTIT:               equ    $00000241                                ;*** PTIT - Port T Input Register; 0x00000241 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTIT_PTIT0:         equ    0                                         ; Port T input data bit 0
PTIT_PTIT1:         equ    1                                         ; Port T input data bit 1
PTIT_PTIT2:         equ    2                                         ; Port T input data bit 2
PTIT_PTIT3:         equ    3                                         ; Port T input data bit 3
PTIT_PTIT4:         equ    4                                         ; Port T input data bit 4
PTIT_PTIT5:         equ    5                                         ; Port T input data bit 5
PTIT_PTIT6:         equ    6                                         ; Port T input data bit 6
PTIT_PTIT7:         equ    7                                         ; Port T input data bit 7
; bit position masks
mPTIT_PTIT0:        equ    %00000001
mPTIT_PTIT1:        equ    %00000010
mPTIT_PTIT2:        equ    %00000100
mPTIT_PTIT3:        equ    %00001000
mPTIT_PTIT4:        equ    %00010000
mPTIT_PTIT5:        equ    %00100000
mPTIT_PTIT6:        equ    %01000000
mPTIT_PTIT7:        equ    %10000000


;*** DDRT - Port T Data Direction Register; 0x00000242 ***
DDRT:               equ    $00000242                                ;*** DDRT - Port T Data Direction Register; 0x00000242 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRT_DDRT0:         equ    0                                         ; Port T data direction bit 0
DDRT_DDRT1:         equ    1                                         ; Port T data direction bit 1
DDRT_DDRT2:         equ    2                                         ; Port T data direction bit 2
DDRT_DDRT3:         equ    3                                         ; Port T data direction bit 3
DDRT_DDRT4:         equ    4                                         ; Port T data direction bit 4
DDRT_DDRT5:         equ    5                                         ; Port T data direction bit 5
DDRT_DDRT6:         equ    6                                         ; Port T data direction bit 6
DDRT_DDRT7:         equ    7                                         ; Port T data direction bit 7
; bit position masks
mDDRT_DDRT0:        equ    %00000001
mDDRT_DDRT1:        equ    %00000010
mDDRT_DDRT2:        equ    %00000100
mDDRT_DDRT3:        equ    %00001000
mDDRT_DDRT4:        equ    %00010000
mDDRT_DDRT5:        equ    %00100000
mDDRT_DDRT6:        equ    %01000000
mDDRT_DDRT7:        equ    %10000000


;*** RDRT - Port T Reduced Drive Register; 0x00000243 ***
RDRT:               equ    $00000243                                ;*** RDRT - Port T Reduced Drive Register; 0x00000243 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RDRT_RDRT0:         equ    0                                         ; Port T reduced drive bit 0
RDRT_RDRT1:         equ    1                                         ; Port T reduced drive bit 1
RDRT_RDRT2:         equ    2                                         ; Port T reduced drive bit 2
RDRT_RDRT3:         equ    3                                         ; Port T reduced drive bit 3
RDRT_RDRT4:         equ    4                                         ; Port T reduced drive bit 4
RDRT_RDRT5:         equ    5                                         ; Port T reduced drive bit 5
RDRT_RDRT6:         equ    6                                         ; Port T reduced drive bit 6
RDRT_RDRT7:         equ    7                                         ; Port T reduced drive bit 7
; bit position masks
mRDRT_RDRT0:        equ    %00000001
mRDRT_RDRT1:        equ    %00000010
mRDRT_RDRT2:        equ    %00000100
mRDRT_RDRT3:        equ    %00001000
mRDRT_RDRT4:        equ    %00010000
mRDRT_RDRT5:        equ    %00100000
mRDRT_RDRT6:        equ    %01000000
mRDRT_RDRT7:        equ    %10000000


;*** PERT - Port T Pull Device Enable Register; 0x00000244 ***
PERT:               equ    $00000244                                ;*** PERT - Port T Pull Device Enable Register; 0x00000244 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PERT_PERT0:         equ    0                                         ; Port T pull device enable bit 0
PERT_PERT1:         equ    1                                         ; Port T pull device enable bit 1
PERT_PERT2:         equ    2                                         ; Port T pull device enable bit 2
PERT_PERT3:         equ    3                                         ; Port T pull device enable bit 3
PERT_PERT4:         equ    4                                         ; Port T pull device enable bit 4
PERT_PERT5:         equ    5                                         ; Port T pull device enable bit 5
PERT_PERT6:         equ    6                                         ; Port T pull device enable bit 6
PERT_PERT7:         equ    7                                         ; Port T pull device enable bit 7
; bit position masks
mPERT_PERT0:        equ    %00000001
mPERT_PERT1:        equ    %00000010
mPERT_PERT2:        equ    %00000100
mPERT_PERT3:        equ    %00001000
mPERT_PERT4:        equ    %00010000
mPERT_PERT5:        equ    %00100000
mPERT_PERT6:        equ    %01000000
mPERT_PERT7:        equ    %10000000


;*** PPST - Port T Polarity Select Register; 0x00000245 ***
PPST:               equ    $00000245                                ;*** PPST - Port T Polarity Select Register; 0x00000245 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PPST_PPST0:         equ    0                                         ; Port T pull device select bit 0
PPST_PPST1:         equ    1                                         ; Port T pull device select bit 1
PPST_PPST2:         equ    2                                         ; Port T pull device select bit 2
PPST_PPST3:         equ    3                                         ; Port T pull device select bit 3
PPST_PPST4:         equ    4                                         ; Port T pull device select bit 4
PPST_PPST5:         equ    5                                         ; Port T pull device select bit 5
PPST_PPST6:         equ    6                                         ; Port T pull device select bit 6
PPST_PPST7:         equ    7                                         ; Port T pull device select bit 7
; bit position masks
mPPST_PPST0:        equ    %00000001
mPPST_PPST1:        equ    %00000010
mPPST_PPST2:        equ    %00000100
mPPST_PPST3:        equ    %00001000
mPPST_PPST4:        equ    %00010000
mPPST_PPST5:        equ    %00100000
mPPST_PPST6:        equ    %01000000
mPPST_PPST7:        equ    %10000000


;*** PTTRR - Port T Routing Register; 0x00000247 ***
PTTRR:              equ    $00000247                                ;*** PTTRR - Port T Routing Register; 0x00000247 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTTRR_PTTRR0:       equ    0                                         ; Port T  routing
PTTRR_PTTRR1:       equ    1                                         ; Port T  routing
PTTRR_PTTRR4:       equ    4                                         ; Port T  routing
PTTRR_PTTRR5:       equ    5                                         ; Port T  routing
; bit position masks
mPTTRR_PTTRR0:      equ    %00000001
mPTTRR_PTTRR1:      equ    %00000010
mPTTRR_PTTRR4:      equ    %00010000
mPTTRR_PTTRR5:      equ    %00100000


;*** PTS - Port S Data Register; 0x00000248 ***
PTS:                equ    $00000248                                ;*** PTS - Port S Data Register; 0x00000248 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTS_PTS0:           equ    0                                         ; Port S general purpose input/output data bit 0
PTS_PTS1:           equ    1                                         ; Port S general purpose input/output data bit 1
PTS_PTS2:           equ    2                                         ; Port S general purpose input/output data bit 2
PTS_PTS3:           equ    3                                         ; Port S general purpose input/output data bit 3
PTS_PTS4:           equ    4                                         ; Port S general purpose input/output data bit 4
PTS_PTS5:           equ    5                                         ; Port S general purpose input/output data bit 5
PTS_PTS6:           equ    6                                         ; Port S general purpose input/output data bit 6
PTS_PTS7:           equ    7                                         ; Port S general purpose input/output data bit 7
; bit position masks
mPTS_PTS0:          equ    %00000001
mPTS_PTS1:          equ    %00000010
mPTS_PTS2:          equ    %00000100
mPTS_PTS3:          equ    %00001000
mPTS_PTS4:          equ    %00010000
mPTS_PTS5:          equ    %00100000
mPTS_PTS6:          equ    %01000000
mPTS_PTS7:          equ    %10000000


;*** PTIS - Port S Input Register; 0x00000249 ***
PTIS:               equ    $00000249                                ;*** PTIS - Port S Input Register; 0x00000249 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTIS_PTIS0:         equ    0                                         ; Port S input data bit 0
PTIS_PTIS1:         equ    1                                         ; Port S input data bit 1
PTIS_PTIS2:         equ    2                                         ; Port S input data bit 2
PTIS_PTIS3:         equ    3                                         ; Port S input data bit 3
PTIS_PTIS4:         equ    4                                         ; Port S input data bit 4
PTIS_PTIS5:         equ    5                                         ; Port S input data bit 5
PTIS_PTIS6:         equ    6                                         ; Port S input data bit 6
PTIS_PTIS7:         equ    7                                         ; Port S input data bit 7
; bit position masks
mPTIS_PTIS0:        equ    %00000001
mPTIS_PTIS1:        equ    %00000010
mPTIS_PTIS2:        equ    %00000100
mPTIS_PTIS3:        equ    %00001000
mPTIS_PTIS4:        equ    %00010000
mPTIS_PTIS5:        equ    %00100000
mPTIS_PTIS6:        equ    %01000000
mPTIS_PTIS7:        equ    %10000000


;*** DDRS - Port S Data Direction Register; 0x0000024A ***
DDRS:               equ    $0000024A                                ;*** DDRS - Port S Data Direction Register; 0x0000024A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRS_DDRS0:         equ    0                                         ; Port S data direction bit 0
DDRS_DDRS1:         equ    1                                         ; Port S data direction bit 1
DDRS_DDRS2:         equ    2                                         ; Port S data direction bit 2
DDRS_DDRS3:         equ    3                                         ; Port S data direction bit 3
DDRS_DDRS4:         equ    4                                         ; Port S data direction bit 4
DDRS_DDRS5:         equ    5                                         ; Port S data direction bit 5
DDRS_DDRS6:         equ    6                                         ; Port S data direction bit 6
DDRS_DDRS7:         equ    7                                         ; Port S data direction bit 7
; bit position masks
mDDRS_DDRS0:        equ    %00000001
mDDRS_DDRS1:        equ    %00000010
mDDRS_DDRS2:        equ    %00000100
mDDRS_DDRS3:        equ    %00001000
mDDRS_DDRS4:        equ    %00010000
mDDRS_DDRS5:        equ    %00100000
mDDRS_DDRS6:        equ    %01000000
mDDRS_DDRS7:        equ    %10000000


;*** RDRS - Port S Reduced Drive Register; 0x0000024B ***
RDRS:               equ    $0000024B                                ;*** RDRS - Port S Reduced Drive Register; 0x0000024B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RDRS_RDRS0:         equ    0                                         ; Port S reduced drive bit 0
RDRS_RDRS1:         equ    1                                         ; Port S reduced drive bit 1
RDRS_RDRS2:         equ    2                                         ; Port S reduced drive bit 2
RDRS_RDRS3:         equ    3                                         ; Port S reduced drive bit 3
RDRS_RDRS4:         equ    4                                         ; Port S reduced drive bit 4
RDRS_RDRS5:         equ    5                                         ; Port S reduced drive bit 5
RDRS_RDRS6:         equ    6                                         ; Port S reduced drive bit 6
RDRS_RDRS7:         equ    7                                         ; Port S reduced drive bit 7
; bit position masks
mRDRS_RDRS0:        equ    %00000001
mRDRS_RDRS1:        equ    %00000010
mRDRS_RDRS2:        equ    %00000100
mRDRS_RDRS3:        equ    %00001000
mRDRS_RDRS4:        equ    %00010000
mRDRS_RDRS5:        equ    %00100000
mRDRS_RDRS6:        equ    %01000000
mRDRS_RDRS7:        equ    %10000000


;*** PERS - Port S Pull Device Enable Register; 0x0000024C ***
PERS:               equ    $0000024C                                ;*** PERS - Port S Pull Device Enable Register; 0x0000024C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PERS_PERS0:         equ    0                                         ; Port S pull device enable bit 0
PERS_PERS1:         equ    1                                         ; Port S pull device enable bit 1
PERS_PERS2:         equ    2                                         ; Port S pull device enable bit 2
PERS_PERS3:         equ    3                                         ; Port S pull device enable bit 3
PERS_PERS4:         equ    4                                         ; Port S pull device enable bit 4
PERS_PERS5:         equ    5                                         ; Port S pull device enable bit 5
PERS_PERS6:         equ    6                                         ; Port S pull device enable bit 6
PERS_PERS7:         equ    7                                         ; Port S pull device enable bit 7
; bit position masks
mPERS_PERS0:        equ    %00000001
mPERS_PERS1:        equ    %00000010
mPERS_PERS2:        equ    %00000100
mPERS_PERS3:        equ    %00001000
mPERS_PERS4:        equ    %00010000
mPERS_PERS5:        equ    %00100000
mPERS_PERS6:        equ    %01000000
mPERS_PERS7:        equ    %10000000


;*** PPSS - Port S Polarity Select Register; 0x0000024D ***
PPSS:               equ    $0000024D                                ;*** PPSS - Port S Polarity Select Register; 0x0000024D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PPSS_PPSS0:         equ    0                                         ; Port S pull device select bit 0
PPSS_PPSS1:         equ    1                                         ; Port S pull device select bit 1
PPSS_PPSS2:         equ    2                                         ; Port S pull device select bit 2
PPSS_PPSS3:         equ    3                                         ; Port S pull device select bit 3
PPSS_PPSS4:         equ    4                                         ; Port S pull device select bit 4
PPSS_PPSS5:         equ    5                                         ; Port S pull device select bit 5
PPSS_PPSS6:         equ    6                                         ; Port S pull device select bit 6
PPSS_PPSS7:         equ    7                                         ; Port S pull device select bit 7
; bit position masks
mPPSS_PPSS0:        equ    %00000001
mPPSS_PPSS1:        equ    %00000010
mPPSS_PPSS2:        equ    %00000100
mPPSS_PPSS3:        equ    %00001000
mPPSS_PPSS4:        equ    %00010000
mPPSS_PPSS5:        equ    %00100000
mPPSS_PPSS6:        equ    %01000000
mPPSS_PPSS7:        equ    %10000000


;*** WOMS - Port S Wired-Or Mode Register; 0x0000024E ***
WOMS:               equ    $0000024E                                ;*** WOMS - Port S Wired-Or Mode Register; 0x0000024E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
WOMS_WOMS0:         equ    0                                         ; Port S wired-or mode bit 0
WOMS_WOMS1:         equ    1                                         ; Port S wired-or mode bit 1
WOMS_WOMS2:         equ    2                                         ; Port S wired-or mode bit 2
WOMS_WOMS3:         equ    3                                         ; Port S wired-or mode bit 3
WOMS_WOMS4:         equ    4                                         ; Port S wired-or mode bit 4
WOMS_WOMS5:         equ    5                                         ; Port S wired-or mode bit 5
WOMS_WOMS6:         equ    6                                         ; Port S wired-or mode bit 6
WOMS_WOMS7:         equ    7                                         ; Port S wired-or mode bit 7
; bit position masks
mWOMS_WOMS0:        equ    %00000001
mWOMS_WOMS1:        equ    %00000010
mWOMS_WOMS2:        equ    %00000100
mWOMS_WOMS3:        equ    %00001000
mWOMS_WOMS4:        equ    %00010000
mWOMS_WOMS5:        equ    %00100000
mWOMS_WOMS6:        equ    %01000000
mWOMS_WOMS7:        equ    %10000000


;*** PTSRR - Port S Routing Register; 0x0000024F ***
PTSRR:              equ    $0000024F                                ;*** PTSRR - Port S Routing Register; 0x0000024F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTSRR_PTSRR0:       equ    0                                         ; Port S  routing
PTSRR_PTSRR1:       equ    1                                         ; Port S  routing
PTSRR_PTSRR4:       equ    4                                         ; Port S  routing
PTSRR_PTSRR5:       equ    5                                         ; Port S  routing
; bit position masks
mPTSRR_PTSRR0:      equ    %00000001
mPTSRR_PTSRR1:      equ    %00000010
mPTSRR_PTSRR4:      equ    %00010000
mPTSRR_PTSRR5:      equ    %00100000


;*** PTP - Port P Data Register; 0x00000258 ***
PTP:                equ    $00000258                                ;*** PTP - Port P Data Register; 0x00000258 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTP_PTP0:           equ    0                                         ; Port P general purpose input/output data bit 0
PTP_PTP1:           equ    1                                         ; Port P general purpose input/output data bit 1
PTP_PTP2:           equ    2                                         ; Port P general purpose input/output data bit 2
PTP_PTP3:           equ    3                                         ; Port P general purpose input/output data bit 3
PTP_PTP4:           equ    4                                         ; Port P general purpose input/output data bit 4
PTP_PTP5:           equ    5                                         ; Port P general purpose input/output data bit 5
PTP_PTP6:           equ    6                                         ; Port P general purpose input/output data bit 6
PTP_PTP7:           equ    7                                         ; Port P general purpose input/output data bit 7
; bit position masks
mPTP_PTP0:          equ    %00000001
mPTP_PTP1:          equ    %00000010
mPTP_PTP2:          equ    %00000100
mPTP_PTP3:          equ    %00001000
mPTP_PTP4:          equ    %00010000
mPTP_PTP5:          equ    %00100000
mPTP_PTP6:          equ    %01000000
mPTP_PTP7:          equ    %10000000


;*** PTIP - Port P Input Register; 0x00000259 ***
PTIP:               equ    $00000259                                ;*** PTIP - Port P Input Register; 0x00000259 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTIP_PTIP0:         equ    0                                         ; Port P input data bit 0
PTIP_PTIP1:         equ    1                                         ; Port P input data bit 1
PTIP_PTIP2:         equ    2                                         ; Port P input data bit 2
PTIP_PTIP3:         equ    3                                         ; Port P input data bit 3
PTIP_PTIP4:         equ    4                                         ; Port P input data bit 4
PTIP_PTIP5:         equ    5                                         ; Port P input data bit 5
PTIP_PTIP6:         equ    6                                         ; Port P input data bit 6
PTIP_PTIP7:         equ    7                                         ; Port P input data bit 7
; bit position masks
mPTIP_PTIP0:        equ    %00000001
mPTIP_PTIP1:        equ    %00000010
mPTIP_PTIP2:        equ    %00000100
mPTIP_PTIP3:        equ    %00001000
mPTIP_PTIP4:        equ    %00010000
mPTIP_PTIP5:        equ    %00100000
mPTIP_PTIP6:        equ    %01000000
mPTIP_PTIP7:        equ    %10000000


;*** DDRP - Port P Data Direction Register; 0x0000025A ***
DDRP:               equ    $0000025A                                ;*** DDRP - Port P Data Direction Register; 0x0000025A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRP_DDRP0:         equ    0                                         ; Port P data direction bit 0
DDRP_DDRP1:         equ    1                                         ; Port P data direction bit 1
DDRP_DDRP2:         equ    2                                         ; Port P data direction bit 2
DDRP_DDRP3:         equ    3                                         ; Port P data direction bit 3
DDRP_DDRP4:         equ    4                                         ; Port P data direction bit 4
DDRP_DDRP5:         equ    5                                         ; Port P data direction bit 5
DDRP_DDRP6:         equ    6                                         ; Port P data direction bit 6
DDRP_DDRP7:         equ    7                                         ; Port P data direction bit 7
; bit position masks
mDDRP_DDRP0:        equ    %00000001
mDDRP_DDRP1:        equ    %00000010
mDDRP_DDRP2:        equ    %00000100
mDDRP_DDRP3:        equ    %00001000
mDDRP_DDRP4:        equ    %00010000
mDDRP_DDRP5:        equ    %00100000
mDDRP_DDRP6:        equ    %01000000
mDDRP_DDRP7:        equ    %10000000


;*** RDRP - Port P Reduced Drive Register; 0x0000025B ***
RDRP:               equ    $0000025B                                ;*** RDRP - Port P Reduced Drive Register; 0x0000025B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RDRP_RDRP0:         equ    0                                         ; Port P reduced drive bit 0
RDRP_RDRP1:         equ    1                                         ; Port P reduced drive bit 1
RDRP_RDRP2:         equ    2                                         ; Port P reduced drive bit 2
RDRP_RDRP3:         equ    3                                         ; Port P reduced drive bit 3
RDRP_RDRP4:         equ    4                                         ; Port P reduced drive bit 4
RDRP_RDRP5:         equ    5                                         ; Port P reduced drive bit 5
RDRP_RDRP6:         equ    6                                         ; Port P reduced drive bit 6
RDRP_RDRP7:         equ    7                                         ; Port P reduced drive bit 7
; bit position masks
mRDRP_RDRP0:        equ    %00000001
mRDRP_RDRP1:        equ    %00000010
mRDRP_RDRP2:        equ    %00000100
mRDRP_RDRP3:        equ    %00001000
mRDRP_RDRP4:        equ    %00010000
mRDRP_RDRP5:        equ    %00100000
mRDRP_RDRP6:        equ    %01000000
mRDRP_RDRP7:        equ    %10000000


;*** PERP - Port P Pull Device Enable Register; 0x0000025C ***
PERP:               equ    $0000025C                                ;*** PERP - Port P Pull Device Enable Register; 0x0000025C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PERP_PERP0:         equ    0                                         ; Port P pull device enable bit 0
PERP_PERP1:         equ    1                                         ; Port P pull device enable bit 1
PERP_PERP2:         equ    2                                         ; Port P pull device enable bit 2
PERP_PERP3:         equ    3                                         ; Port P pull device enable bit 3
PERP_PERP4:         equ    4                                         ; Port P pull device enable bit 4
PERP_PERP5:         equ    5                                         ; Port P pull device enable bit 5
PERP_PERP6:         equ    6                                         ; Port P pull device enable bit 6
PERP_PERP7:         equ    7                                         ; Port P pull device enable bit 7
; bit position masks
mPERP_PERP0:        equ    %00000001
mPERP_PERP1:        equ    %00000010
mPERP_PERP2:        equ    %00000100
mPERP_PERP3:        equ    %00001000
mPERP_PERP4:        equ    %00010000
mPERP_PERP5:        equ    %00100000
mPERP_PERP6:        equ    %01000000
mPERP_PERP7:        equ    %10000000


;*** PPSP - Port P Polarity Select Register; 0x0000025D ***
PPSP:               equ    $0000025D                                ;*** PPSP - Port P Polarity Select Register; 0x0000025D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PPSP_PPSP0:         equ    0                                         ; Port P pull device select bit 0
PPSP_PPSP1:         equ    1                                         ; Port P pull device select bit 1
PPSP_PPSP2:         equ    2                                         ; Port P pull device select bit 2
PPSP_PPSP3:         equ    3                                         ; Port P pull device select bit 3
PPSP_PPSP4:         equ    4                                         ; Port P pull device select bit 4
PPSP_PPSP5:         equ    5                                         ; Port P pull device select bit 5
PPSP_PPSP6:         equ    6                                         ; Port P pull device select bit 6
PPSP_PPSP7:         equ    7                                         ; Port P pull device select bit 7
; bit position masks
mPPSP_PPSP0:        equ    %00000001
mPPSP_PPSP1:        equ    %00000010
mPPSP_PPSP2:        equ    %00000100
mPPSP_PPSP3:        equ    %00001000
mPPSP_PPSP4:        equ    %00010000
mPPSP_PPSP5:        equ    %00100000
mPPSP_PPSP6:        equ    %01000000
mPPSP_PPSP7:        equ    %10000000


;*** PTPRR - Port P Routing Register; 0x0000025E ***
PTPRR:              equ    $0000025E                                ;*** PTPRR - Port P Routing Register; 0x0000025E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTPRR_PTPRRL0:      equ    0                                         ; Port P  routing
PTPRR_PTPRRL1:      equ    1                                         ; Port P  routing
PTPRR_PTPRRL2:      equ    2                                         ; Port P  routing
PTPRR_PTPRRL3:      equ    3                                         ; Port P  routing
PTPRR_PTPRRL4:      equ    4                                         ; Port P  routing
PTPRR_PTPRRL5:      equ    5                                         ; Port P  routing
PTPRR_PTPRRL6:      equ    6                                         ; Port P  routing
PTPRR_PTPRRL7:      equ    7                                         ; Port P  routing
PTPRR_PTPRRH0:      equ    8                                         ; Port P  routing
PTPRR_PTPRRH1:      equ    9                                         ; Port P  routing
; bit position masks
mPTPRR_PTPRRL0:     equ    %00000001
mPTPRR_PTPRRL1:     equ    %00000010
mPTPRR_PTPRRL2:     equ    %00000100
mPTPRR_PTPRRL3:     equ    %00001000
mPTPRR_PTPRRL4:     equ    %00010000
mPTPRR_PTPRRL5:     equ    %00100000
mPTPRR_PTPRRL6:     equ    %01000000
mPTPRR_PTPRRL7:     equ    %10000000
mPTPRR_PTPRRH0:     equ    %100000000
mPTPRR_PTPRRH1:     equ    %1000000000


;*** PTPRRH - Port P Routing Register High; 0x0000025E ***
PTPRRH:             equ    $0000025E                                ;*** PTPRRH - Port P Routing Register High; 0x0000025E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTPRRH_PTPRRH0:     equ    0                                         ; Port P  routing
PTPRRH_PTPRRH1:     equ    1                                         ; Port P  routing
; bit position masks
mPTPRRH_PTPRRH0:    equ    %00000001
mPTPRRH_PTPRRH1:    equ    %00000010


;*** PTPRRL - Port P Routing Register Low; 0x0000025F ***
PTPRRL:             equ    $0000025F                                ;*** PTPRRL - Port P Routing Register Low; 0x0000025F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTPRRL_PTPRRL0:     equ    0                                         ; Port P  routing
PTPRRL_PTPRRL1:     equ    1                                         ; Port P  routing
PTPRRL_PTPRRL2:     equ    2                                         ; Port P  routing
PTPRRL_PTPRRL3:     equ    3                                         ; Port P  routing
PTPRRL_PTPRRL4:     equ    4                                         ; Port P  routing
PTPRRL_PTPRRL5:     equ    5                                         ; Port P  routing
PTPRRL_PTPRRL6:     equ    6                                         ; Port P  routing
PTPRRL_PTPRRL7:     equ    7                                         ; Port P  routing
; bit position masks
mPTPRRL_PTPRRL0:    equ    %00000001
mPTPRRL_PTPRRL1:    equ    %00000010
mPTPRRL_PTPRRL2:    equ    %00000100
mPTPRRL_PTPRRL3:    equ    %00001000
mPTPRRL_PTPRRL4:    equ    %00010000
mPTPRRL_PTPRRL5:    equ    %00100000
mPTPRRL_PTPRRL6:    equ    %01000000
mPTPRRL_PTPRRL7:    equ    %10000000


;*** PTH - Port H Data Register; 0x00000260 ***
PTH:                equ    $00000260                                ;*** PTH - Port H Data Register; 0x00000260 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTH_PTH0:           equ    0                                         ; Port H general purpose input/output data bit 0
PTH_PTH1:           equ    1                                         ; Port H general purpose input/output data bit 1
PTH_PTH2:           equ    2                                         ; Port H general purpose input/output data bit 2
PTH_PTH3:           equ    3                                         ; Port H general purpose input/output data bit 3
PTH_PTH4:           equ    4                                         ; Port H general purpose input/output data bit 4
PTH_PTH5:           equ    5                                         ; Port H general purpose input/output data bit 5
PTH_PTH6:           equ    6                                         ; Port H general purpose input/output data bit 6
PTH_PTH7:           equ    7                                         ; Port H general purpose input/output data bit 7
; bit position masks
mPTH_PTH0:          equ    %00000001
mPTH_PTH1:          equ    %00000010
mPTH_PTH2:          equ    %00000100
mPTH_PTH3:          equ    %00001000
mPTH_PTH4:          equ    %00010000
mPTH_PTH5:          equ    %00100000
mPTH_PTH6:          equ    %01000000
mPTH_PTH7:          equ    %10000000


;*** PTIH - Port H Input Register; 0x00000261 ***
PTIH:               equ    $00000261                                ;*** PTIH - Port H Input Register; 0x00000261 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTIH_PTIH0:         equ    0                                         ; Port H input data bit 0
PTIH_PTIH1:         equ    1                                         ; Port H input data bit 1
PTIH_PTIH2:         equ    2                                         ; Port H input data bit 2
PTIH_PTIH3:         equ    3                                         ; Port H input data bit 3
PTIH_PTIH4:         equ    4                                         ; Port H input data bit 4
PTIH_PTIH5:         equ    5                                         ; Port H input data bit 5
PTIH_PTIH6:         equ    6                                         ; Port H input data bit 6
PTIH_PTIH7:         equ    7                                         ; Port H input data bit 7
; bit position masks
mPTIH_PTIH0:        equ    %00000001
mPTIH_PTIH1:        equ    %00000010
mPTIH_PTIH2:        equ    %00000100
mPTIH_PTIH3:        equ    %00001000
mPTIH_PTIH4:        equ    %00010000
mPTIH_PTIH5:        equ    %00100000
mPTIH_PTIH6:        equ    %01000000
mPTIH_PTIH7:        equ    %10000000


;*** DDRH - Port H Data Direction Register; 0x00000262 ***
DDRH:               equ    $00000262                                ;*** DDRH - Port H Data Direction Register; 0x00000262 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRH_DDRH0:         equ    0                                         ; Port H data direction bit 0
DDRH_DDRH1:         equ    1                                         ; Port H data direction bit 1
DDRH_DDRH2:         equ    2                                         ; Port H data direction bit 2
DDRH_DDRH3:         equ    3                                         ; Port H data direction bit 3
DDRH_DDRH4:         equ    4                                         ; Port H data direction bit 4
DDRH_DDRH5:         equ    5                                         ; Port H data direction bit 5
DDRH_DDRH6:         equ    6                                         ; Port H data direction bit 6
DDRH_DDRH7:         equ    7                                         ; Port H data direction bit 7
; bit position masks
mDDRH_DDRH0:        equ    %00000001
mDDRH_DDRH1:        equ    %00000010
mDDRH_DDRH2:        equ    %00000100
mDDRH_DDRH3:        equ    %00001000
mDDRH_DDRH4:        equ    %00010000
mDDRH_DDRH5:        equ    %00100000
mDDRH_DDRH6:        equ    %01000000
mDDRH_DDRH7:        equ    %10000000


;*** RDRH - Port H Reduced Drive Register; 0x00000263 ***
RDRH:               equ    $00000263                                ;*** RDRH - Port H Reduced Drive Register; 0x00000263 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RDRH_RDRH0:         equ    0                                         ; Port H reduced drive bit 0
RDRH_RDRH1:         equ    1                                         ; Port H reduced drive bit 1
RDRH_RDRH2:         equ    2                                         ; Port H reduced drive bit 2
RDRH_RDRH3:         equ    3                                         ; Port H reduced drive bit 3
RDRH_RDRH4:         equ    4                                         ; Port H reduced drive bit 4
RDRH_RDRH5:         equ    5                                         ; Port H reduced drive bit 5
RDRH_RDRH6:         equ    6                                         ; Port H reduced drive bit 6
RDRH_RDRH7:         equ    7                                         ; Port H reduced drive bit 7
; bit position masks
mRDRH_RDRH0:        equ    %00000001
mRDRH_RDRH1:        equ    %00000010
mRDRH_RDRH2:        equ    %00000100
mRDRH_RDRH3:        equ    %00001000
mRDRH_RDRH4:        equ    %00010000
mRDRH_RDRH5:        equ    %00100000
mRDRH_RDRH6:        equ    %01000000
mRDRH_RDRH7:        equ    %10000000


;*** PERH - Port H Pull Device Enable Register; 0x00000264 ***
PERH:               equ    $00000264                                ;*** PERH - Port H Pull Device Enable Register; 0x00000264 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PERH_PERH0:         equ    0                                         ; Port H pull device enable bit 0
PERH_PERH1:         equ    1                                         ; Port H pull device enable bit 1
PERH_PERH2:         equ    2                                         ; Port H pull device enable bit 2
PERH_PERH3:         equ    3                                         ; Port H pull device enable bit 3
PERH_PERH4:         equ    4                                         ; Port H pull device enable bit 4
PERH_PERH5:         equ    5                                         ; Port H pull device enable bit 5
PERH_PERH6:         equ    6                                         ; Port H pull device enable bit 6
PERH_PERH7:         equ    7                                         ; Port H pull device enable bit 7
; bit position masks
mPERH_PERH0:        equ    %00000001
mPERH_PERH1:        equ    %00000010
mPERH_PERH2:        equ    %00000100
mPERH_PERH3:        equ    %00001000
mPERH_PERH4:        equ    %00010000
mPERH_PERH5:        equ    %00100000
mPERH_PERH6:        equ    %01000000
mPERH_PERH7:        equ    %10000000


;*** PPSH - Port H Polarity Select Register; 0x00000265 ***
PPSH:               equ    $00000265                                ;*** PPSH - Port H Polarity Select Register; 0x00000265 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PPSH_PPSH0:         equ    0                                         ; Port H pull device select bit 0
PPSH_PPSH1:         equ    1                                         ; Port H pull device select bit 1
PPSH_PPSH2:         equ    2                                         ; Port H pull device select bit 2
PPSH_PPSH3:         equ    3                                         ; Port H pull device select bit 3
PPSH_PPSH4:         equ    4                                         ; Port H pull device select bit 4
PPSH_PPSH5:         equ    5                                         ; Port H pull device select bit 5
PPSH_PPSH6:         equ    6                                         ; Port H pull device select bit 6
PPSH_PPSH7:         equ    7                                         ; Port H pull device select bit 7
; bit position masks
mPPSH_PPSH0:        equ    %00000001
mPPSH_PPSH1:        equ    %00000010
mPPSH_PPSH2:        equ    %00000100
mPPSH_PPSH3:        equ    %00001000
mPPSH_PPSH4:        equ    %00010000
mPPSH_PPSH5:        equ    %00100000
mPPSH_PPSH6:        equ    %01000000
mPPSH_PPSH7:        equ    %10000000


;*** WOMH - Port H Wired-Or Mode Register; 0x00000266 ***
WOMH:               equ    $00000266                                ;*** WOMH - Port H Wired-Or Mode Register; 0x00000266 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
WOMH_WOMH0:         equ    0                                         ; Port H wired-or mode bit 0
WOMH_WOMH1:         equ    1                                         ; Port H wired-or mode bit 1
WOMH_WOMH2:         equ    2                                         ; Port H wired-or mode bit 2
WOMH_WOMH3:         equ    3                                         ; Port H wired-or mode bit 3
WOMH_WOMH4:         equ    4                                         ; Port H wired-or mode bit 4
WOMH_WOMH5:         equ    5                                         ; Port H wired-or mode bit 5
WOMH_WOMH6:         equ    6                                         ; Port H wired-or mode bit 6
WOMH_WOMH7:         equ    7                                         ; Port H wired-or mode bit 7
; bit position masks
mWOMH_WOMH0:        equ    %00000001
mWOMH_WOMH1:        equ    %00000010
mWOMH_WOMH2:        equ    %00000100
mWOMH_WOMH3:        equ    %00001000
mWOMH_WOMH4:        equ    %00010000
mWOMH_WOMH5:        equ    %00100000
mWOMH_WOMH6:        equ    %01000000
mWOMH_WOMH7:        equ    %10000000


;*** PT1AD - Port AD Data Register; 0x00000271 ***
PT1AD:              equ    $00000271                                ;*** PT1AD - Port AD Data Register; 0x00000271 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PT1AD_PT1AD0:       equ    0                                         ; Port AD data bit 0
PT1AD_PT1AD1:       equ    1                                         ; Port AD data bit 1
PT1AD_PT1AD2:       equ    2                                         ; Port AD data bit 2
PT1AD_PT1AD3:       equ    3                                         ; Port AD data bit 3
PT1AD_PT1AD4:       equ    4                                         ; Port AD data bit 4
PT1AD_PT1AD5:       equ    5                                         ; Port AD data bit 5
PT1AD_PT1AD6:       equ    6                                         ; Port AD data bit 6
PT1AD_PT1AD7:       equ    7                                         ; Port AD data bit 7
; bit position masks
mPT1AD_PT1AD0:      equ    %00000001
mPT1AD_PT1AD1:      equ    %00000010
mPT1AD_PT1AD2:      equ    %00000100
mPT1AD_PT1AD3:      equ    %00001000
mPT1AD_PT1AD4:      equ    %00010000
mPT1AD_PT1AD5:      equ    %00100000
mPT1AD_PT1AD6:      equ    %01000000
mPT1AD_PT1AD7:      equ    %10000000


;*** DDR1AD - Port AD Data Direction Register; 0x00000273 ***
DDR1AD:             equ    $00000273                                ;*** DDR1AD - Port AD Data Direction Register; 0x00000273 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDR1AD_DDR1AD0:     equ    0                                         ; Port AD data direction bit 0
DDR1AD_DDR1AD1:     equ    1                                         ; Port AD data direction bit 1
DDR1AD_DDR1AD2:     equ    2                                         ; Port AD data direction bit 2
DDR1AD_DDR1AD3:     equ    3                                         ; Port AD data direction bit 3
DDR1AD_DDR1AD4:     equ    4                                         ; Port AD data direction bit 4
DDR1AD_DDR1AD5:     equ    5                                         ; Port AD data direction bit 5
DDR1AD_DDR1AD6:     equ    6                                         ; Port AD data direction bit 6
DDR1AD_DDR1AD7:     equ    7                                         ; Port AD data direction bit 7
; bit position masks
mDDR1AD_DDR1AD0:    equ    %00000001
mDDR1AD_DDR1AD1:    equ    %00000010
mDDR1AD_DDR1AD2:    equ    %00000100
mDDR1AD_DDR1AD3:    equ    %00001000
mDDR1AD_DDR1AD4:    equ    %00010000
mDDR1AD_DDR1AD5:    equ    %00100000
mDDR1AD_DDR1AD6:    equ    %01000000
mDDR1AD_DDR1AD7:    equ    %10000000


;*** RDR1AD - Port AD Reduced Drive Register; 0x00000275 ***
RDR1AD:             equ    $00000275                                ;*** RDR1AD - Port AD Reduced Drive Register; 0x00000275 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RDR1AD_RDR1AD0:     equ    0                                         ; Port AD reduced drive bit 0
RDR1AD_RDR1AD1:     equ    1                                         ; Port AD reduced drive bit 1
RDR1AD_RDR1AD2:     equ    2                                         ; Port AD reduced drive bit 2
RDR1AD_RDR1AD3:     equ    3                                         ; Port AD reduced drive bit 3
RDR1AD_RDR1AD4:     equ    4                                         ; Port AD reduced drive bit 4
RDR1AD_RDR1AD5:     equ    5                                         ; Port AD reduced drive bit 5
RDR1AD_RDR1AD6:     equ    6                                         ; Port AD reduced drive bit 6
RDR1AD_RDR1AD7:     equ    7                                         ; Port AD reduced drive bit 7
; bit position masks
mRDR1AD_RDR1AD0:    equ    %00000001
mRDR1AD_RDR1AD1:    equ    %00000010
mRDR1AD_RDR1AD2:    equ    %00000100
mRDR1AD_RDR1AD3:    equ    %00001000
mRDR1AD_RDR1AD4:    equ    %00010000
mRDR1AD_RDR1AD5:    equ    %00100000
mRDR1AD_RDR1AD6:    equ    %01000000
mRDR1AD_RDR1AD7:    equ    %10000000


;*** PER1AD - Port AD Pull Up Enable Register; 0x00000277 ***
PER1AD:             equ    $00000277                                ;*** PER1AD - Port AD Pull Up Enable Register; 0x00000277 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PER1AD_PER1AD0:     equ    0                                         ; Port AD pull up enable bit 0
PER1AD_PER1AD1:     equ    1                                         ; Port AD pull up enable bit 1
PER1AD_PER1AD2:     equ    2                                         ; Port AD pull up enable bit 2
PER1AD_PER1AD3:     equ    3                                         ; Port AD pull up enable bit 3
PER1AD_PER1AD4:     equ    4                                         ; Port AD pull up enable bit 4
PER1AD_PER1AD5:     equ    5                                         ; Port AD pull up enable bit 5
PER1AD_PER1AD6:     equ    6                                         ; Port AD pull up enable bit 6
PER1AD_PER1AD7:     equ    7                                         ; Port AD pull up enable bit 7
; bit position masks
mPER1AD_PER1AD0:    equ    %00000001
mPER1AD_PER1AD1:    equ    %00000010
mPER1AD_PER1AD2:    equ    %00000100
mPER1AD_PER1AD3:    equ    %00001000
mPER1AD_PER1AD4:    equ    %00010000
mPER1AD_PER1AD5:    equ    %00100000
mPER1AD_PER1AD6:    equ    %01000000
mPER1AD_PER1AD7:    equ    %10000000


;*** PTR - Port R Data Register; 0x00000280 ***
PTR:                equ    $00000280                                ;*** PTR - Port R Data Register; 0x00000280 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTR_PTR0:           equ    0                                         ; Port R general purpose input/output data bit 0
PTR_PTR1:           equ    1                                         ; Port R general purpose input/output data bit 1
PTR_PTR2:           equ    2                                         ; Port R general purpose input/output data bit 2
PTR_PTR3:           equ    3                                         ; Port R general purpose input/output data bit 3
PTR_PTR4:           equ    4                                         ; Port R general purpose input/output data bit 4
PTR_PTR5:           equ    5                                         ; Port R general purpose input/output data bit 5
PTR_PTR6:           equ    6                                         ; Port R general purpose input/output data bit 6
PTR_PTR7:           equ    7                                         ; Port R general purpose input/output data bit 7
; bit position masks
mPTR_PTR0:          equ    %00000001
mPTR_PTR1:          equ    %00000010
mPTR_PTR2:          equ    %00000100
mPTR_PTR3:          equ    %00001000
mPTR_PTR4:          equ    %00010000
mPTR_PTR5:          equ    %00100000
mPTR_PTR6:          equ    %01000000
mPTR_PTR7:          equ    %10000000


;*** PTIR - Port R Input Register; 0x00000281 ***
PTIR:               equ    $00000281                                ;*** PTIR - Port R Input Register; 0x00000281 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTIR_PTIR0:         equ    0                                         ; Port R input data bit 0
PTIR_PTIR1:         equ    1                                         ; Port R input data bit 1
PTIR_PTIR2:         equ    2                                         ; Port R input data bit 2
PTIR_PTIR3:         equ    3                                         ; Port R input data bit 3
PTIR_PTIR4:         equ    4                                         ; Port R input data bit 4
PTIR_PTIR5:         equ    5                                         ; Port R input data bit 5
PTIR_PTIR6:         equ    6                                         ; Port R input data bit 6
PTIR_PTIR7:         equ    7                                         ; Port R input data bit 7
; bit position masks
mPTIR_PTIR0:        equ    %00000001
mPTIR_PTIR1:        equ    %00000010
mPTIR_PTIR2:        equ    %00000100
mPTIR_PTIR3:        equ    %00001000
mPTIR_PTIR4:        equ    %00010000
mPTIR_PTIR5:        equ    %00100000
mPTIR_PTIR6:        equ    %01000000
mPTIR_PTIR7:        equ    %10000000


;*** DDRR - Port R Data Direction Register; 0x00000282 ***
DDRR:               equ    $00000282                                ;*** DDRR - Port R Data Direction Register; 0x00000282 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRR_DDRR0:         equ    0                                         ; Port R data direction bit 0
DDRR_DDRR1:         equ    1                                         ; Port R data direction bit 1
DDRR_DDRR2:         equ    2                                         ; Port R data direction bit 2
DDRR_DDRR3:         equ    3                                         ; Port R data direction bit 3
DDRR_DDRR4:         equ    4                                         ; Port R data direction bit 4
DDRR_DDRR5:         equ    5                                         ; Port R data direction bit 5
DDRR_DDRR6:         equ    6                                         ; Port R data direction bit 6
DDRR_DDRR7:         equ    7                                         ; Port R data direction bit 7
; bit position masks
mDDRR_DDRR0:        equ    %00000001
mDDRR_DDRR1:        equ    %00000010
mDDRR_DDRR2:        equ    %00000100
mDDRR_DDRR3:        equ    %00001000
mDDRR_DDRR4:        equ    %00010000
mDDRR_DDRR5:        equ    %00100000
mDDRR_DDRR6:        equ    %01000000
mDDRR_DDRR7:        equ    %10000000


;*** RDRR - Port R Reduced Drive Register; 0x00000283 ***
RDRR:               equ    $00000283                                ;*** RDRR - Port R Reduced Drive Register; 0x00000283 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RDRR_RDRR0:         equ    0                                         ; Port R reduced drive bit 0
RDRR_RDRR1:         equ    1                                         ; Port R reduced drive bit 1
RDRR_RDRR2:         equ    2                                         ; Port R reduced drive bit 2
RDRR_RDRR3:         equ    3                                         ; Port R reduced drive bit 3
RDRR_RDRR4:         equ    4                                         ; Port R reduced drive bit 4
RDRR_RDRR5:         equ    5                                         ; Port R reduced drive bit 5
RDRR_RDRR6:         equ    6                                         ; Port R reduced drive bit 6
RDRR_RDRR7:         equ    7                                         ; Port R reduced drive bit 7
; bit position masks
mRDRR_RDRR0:        equ    %00000001
mRDRR_RDRR1:        equ    %00000010
mRDRR_RDRR2:        equ    %00000100
mRDRR_RDRR3:        equ    %00001000
mRDRR_RDRR4:        equ    %00010000
mRDRR_RDRR5:        equ    %00100000
mRDRR_RDRR6:        equ    %01000000
mRDRR_RDRR7:        equ    %10000000


;*** PERR - Port R Pull Device Enable Register; 0x00000284 ***
PERR:               equ    $00000284                                ;*** PERR - Port R Pull Device Enable Register; 0x00000284 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PERR_PERR0:         equ    0                                         ; Port R pull device enable bit 0
PERR_PERR1:         equ    1                                         ; Port R pull device enable bit 1
PERR_PERR2:         equ    2                                         ; Port R pull device enable bit 2
PERR_PERR3:         equ    3                                         ; Port R pull device enable bit 3
PERR_PERR4:         equ    4                                         ; Port R pull device enable bit 4
PERR_PERR5:         equ    5                                         ; Port R pull device enable bit 5
PERR_PERR6:         equ    6                                         ; Port R pull device enable bit 6
PERR_PERR7:         equ    7                                         ; Port R pull device enable bit 7
; bit position masks
mPERR_PERR0:        equ    %00000001
mPERR_PERR1:        equ    %00000010
mPERR_PERR2:        equ    %00000100
mPERR_PERR3:        equ    %00001000
mPERR_PERR4:        equ    %00010000
mPERR_PERR5:        equ    %00100000
mPERR_PERR6:        equ    %01000000
mPERR_PERR7:        equ    %10000000


;*** PPSR - Port R Polarity Select Register; 0x00000285 ***
PPSR:               equ    $00000285                                ;*** PPSR - Port R Polarity Select Register; 0x00000285 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PPSR_PPSR0:         equ    0                                         ; Port R pull device select bit 0
PPSR_PPSR1:         equ    1                                         ; Port R pull device select bit 1
PPSR_PPSR2:         equ    2                                         ; Port R pull device select bit 2
PPSR_PPSR3:         equ    3                                         ; Port R pull device select bit 3
PPSR_PPSR4:         equ    4                                         ; Port R pull device select bit 4
PPSR_PPSR5:         equ    5                                         ; Port R pull device select bit 5
PPSR_PPSR6:         equ    6                                         ; Port R pull device select bit 6
PPSR_PPSR7:         equ    7                                         ; Port R pull device select bit 7
; bit position masks
mPPSR_PPSR0:        equ    %00000001
mPPSR_PPSR1:        equ    %00000010
mPPSR_PPSR2:        equ    %00000100
mPPSR_PPSR3:        equ    %00001000
mPPSR_PPSR4:        equ    %00010000
mPPSR_PPSR5:        equ    %00100000
mPPSR_PPSR6:        equ    %01000000
mPPSR_PPSR7:        equ    %10000000


;*** WOMR - Port R Wired-Or Mode Register; 0x00000286 ***
WOMR:               equ    $00000286                                ;*** WOMR - Port R Wired-Or Mode Register; 0x00000286 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
WOMR_WOMR0:         equ    0                                         ; Port R wired-or mode bit 0
WOMR_WOMR1:         equ    1                                         ; Port R wired-or mode bit 1
WOMR_WOMR2:         equ    2                                         ; Port R wired-or mode bit 2
WOMR_WOMR3:         equ    3                                         ; Port R wired-or mode bit 3
WOMR_WOMR4:         equ    4                                         ; Port R wired-or mode bit 4
WOMR_WOMR5:         equ    5                                         ; Port R wired-or mode bit 5
WOMR_WOMR6:         equ    6                                         ; Port R wired-or mode bit 6
WOMR_WOMR7:         equ    7                                         ; Port R wired-or mode bit 7
; bit position masks
mWOMR_WOMR0:        equ    %00000001
mWOMR_WOMR1:        equ    %00000010
mWOMR_WOMR2:        equ    %00000100
mWOMR_WOMR3:        equ    %00001000
mWOMR_WOMR4:        equ    %00010000
mWOMR_WOMR5:        equ    %00100000
mWOMR_WOMR6:        equ    %01000000
mWOMR_WOMR7:        equ    %10000000


;*** PIET - Port T Interrupt Enable Register; 0x00000288 ***
PIET:               equ    $00000288                                ;*** PIET - Port T Interrupt Enable Register; 0x00000288 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PIET_PIET0:         equ    0                                         ; Port T interrupt enable bit 0
PIET_PIET1:         equ    1                                         ; Port T interrupt enable bit 1
PIET_PIET2:         equ    2                                         ; Port T interrupt enable bit 2
PIET_PIET3:         equ    3                                         ; Port T interrupt enable bit 3
PIET_PIET4:         equ    4                                         ; Port T interrupt enable bit 4
PIET_PIET5:         equ    5                                         ; Port T interrupt enable bit 5
PIET_PIET6:         equ    6                                         ; Port T interrupt enable bit 6
PIET_PIET7:         equ    7                                         ; Port T interrupt enable bit 7
; bit position masks
mPIET_PIET0:        equ    %00000001
mPIET_PIET1:        equ    %00000010
mPIET_PIET2:        equ    %00000100
mPIET_PIET3:        equ    %00001000
mPIET_PIET4:        equ    %00010000
mPIET_PIET5:        equ    %00100000
mPIET_PIET6:        equ    %01000000
mPIET_PIET7:        equ    %10000000


;*** PIFT - Port T Interrupt Flag Register; 0x00000289 ***
PIFT:               equ    $00000289                                ;*** PIFT - Port T Interrupt Flag Register; 0x00000289 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PIFT_PIFT0:         equ    0                                         ; Port T interrupt flag bit 0
PIFT_PIFT1:         equ    1                                         ; Port T interrupt flag bit 1
PIFT_PIFT2:         equ    2                                         ; Port T interrupt flag bit 2
PIFT_PIFT3:         equ    3                                         ; Port T interrupt flag bit 3
PIFT_PIFT4:         equ    4                                         ; Port T interrupt flag bit 4
PIFT_PIFT5:         equ    5                                         ; Port T interrupt flag bit 5
PIFT_PIFT6:         equ    6                                         ; Port T interrupt flag bit 6
PIFT_PIFT7:         equ    7                                         ; Port T interrupt flag bit 7
; bit position masks
mPIFT_PIFT0:        equ    %00000001
mPIFT_PIFT1:        equ    %00000010
mPIFT_PIFT2:        equ    %00000100
mPIFT_PIFT3:        equ    %00001000
mPIFT_PIFT4:        equ    %00010000
mPIFT_PIFT5:        equ    %00100000
mPIFT_PIFT6:        equ    %01000000
mPIFT_PIFT7:        equ    %10000000


;*** PIES - Port S Interrupt Enable Register; 0x0000028A ***
PIES:               equ    $0000028A                                ;*** PIES - Port S Interrupt Enable Register; 0x0000028A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PIES_PIES5:         equ    5                                         ; Port S interrupt enable bit 5
PIES_PIES6:         equ    6                                         ; Port S interrupt enable bit 6
; bit position masks
mPIES_PIES5:        equ    %00100000
mPIES_PIES6:        equ    %01000000


;*** PIFS - Port S Interrupt Flag Register; 0x0000028B ***
PIFS:               equ    $0000028B                                ;*** PIFS - Port S Interrupt Flag Register; 0x0000028B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PIFS_PIFS5:         equ    5                                         ; Port S interrupt flag bit 5
PIFS_PIFS6:         equ    6                                         ; Port S interrupt flag bit 6
; bit position masks
mPIFS_PIFS5:        equ    %00100000
mPIFS_PIFS6:        equ    %01000000


;*** PIE1AD - Port AD Interrupt Enable Register; 0x0000028C ***
PIE1AD:             equ    $0000028C                                ;*** PIE1AD - Port AD Interrupt Enable Register; 0x0000028C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PIE1AD_PIE1AD0:     equ    0                                         ; Port AD Interrupt Enable Bit 0
PIE1AD_PIE1AD1:     equ    1                                         ; Port AD Interrupt Enable Bit 1
PIE1AD_PIE1AD2:     equ    2                                         ; Port AD Interrupt Enable Bit 2
PIE1AD_PIE1AD3:     equ    3                                         ; Port AD Interrupt Enable Bit 3
PIE1AD_PIE1AD4:     equ    4                                         ; Port AD Interrupt Enable Bit 4
PIE1AD_PIE1AD5:     equ    5                                         ; Port AD Interrupt Enable Bit 5
PIE1AD_PIE1AD6:     equ    6                                         ; Port AD Interrupt Enable Bit 6
PIE1AD_PIE1AD7:     equ    7                                         ; Port AD Interrupt Enable Bit 7
; bit position masks
mPIE1AD_PIE1AD0:    equ    %00000001
mPIE1AD_PIE1AD1:    equ    %00000010
mPIE1AD_PIE1AD2:    equ    %00000100
mPIE1AD_PIE1AD3:    equ    %00001000
mPIE1AD_PIE1AD4:    equ    %00010000
mPIE1AD_PIE1AD5:    equ    %00100000
mPIE1AD_PIE1AD6:    equ    %01000000
mPIE1AD_PIE1AD7:    equ    %10000000


;*** PIF1AD - Port AD Interrupt Flag Register; 0x0000028D ***
PIF1AD:             equ    $0000028D                                ;*** PIF1AD - Port AD Interrupt Flag Register; 0x0000028D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PIF1AD_PIF1AD0:     equ    0                                         ; Port AD Bit 0
PIF1AD_PIF1AD1:     equ    1                                         ; Port AD Bit 1
PIF1AD_PIF1AD2:     equ    2                                         ; Port AD Bit 2
PIF1AD_PIF1AD3:     equ    3                                         ; Port AD Bit 3
PIF1AD_PIF1AD4:     equ    4                                         ; Port AD Bit 4
PIF1AD_PIF1AD5:     equ    5                                         ; Port AD Bit 5
PIF1AD_PIF1AD6:     equ    6                                         ; Port AD Bit 6
PIF1AD_PIF1AD7:     equ    7                                         ; Port AD Bit 7
; bit position masks
mPIF1AD_PIF1AD0:    equ    %00000001
mPIF1AD_PIF1AD1:    equ    %00000010
mPIF1AD_PIF1AD2:    equ    %00000100
mPIF1AD_PIF1AD3:    equ    %00001000
mPIF1AD_PIF1AD4:    equ    %00010000
mPIF1AD_PIF1AD5:    equ    %00100000
mPIF1AD_PIF1AD6:    equ    %01000000
mPIF1AD_PIF1AD7:    equ    %10000000


;*** PIER - Port R Interrupt Enable Register; 0x0000028E ***
PIER:               equ    $0000028E                                ;*** PIER - Port R Interrupt Enable Register; 0x0000028E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PIER_PIER0:         equ    0                                         ; Port R interrupt enable bit 0
PIER_PIER1:         equ    1                                         ; Port R interrupt enable bit 1
PIER_PIER2:         equ    2                                         ; Port R interrupt enable bit 2
PIER_PIER3:         equ    3                                         ; Port R interrupt enable bit 3
; bit position masks
mPIER_PIER0:        equ    %00000001
mPIER_PIER1:        equ    %00000010
mPIER_PIER2:        equ    %00000100
mPIER_PIER3:        equ    %00001000


;*** PIFR - Port R Interrupt Flag Register; 0x0000028F ***
PIFR:               equ    $0000028F                                ;*** PIFR - Port R Interrupt Flag Register; 0x0000028F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PIFR_PIFR0:         equ    0                                         ; Port R interrupt flag bit 0
PIFR_PIFR1:         equ    1                                         ; Port R interrupt flag bit 1
PIFR_PIFR2:         equ    2                                         ; Port R interrupt flag bit 2
PIFR_PIFR3:         equ    3                                         ; Port R interrupt flag bit 3
; bit position masks
mPIFR_PIFR0:        equ    %00000001
mPIFR_PIFR1:        equ    %00000010
mPIFR_PIFR2:        equ    %00000100
mPIFR_PIFR3:        equ    %00001000


;*** PTU - Port U Data Register; 0x00000290 ***
PTU:                equ    $00000290                                ;*** PTU - Port U Data Register; 0x00000290 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTU_PTU0:           equ    0                                         ; Port U general purpose input/output data bit 0
PTU_PTU1:           equ    1                                         ; Port U general purpose input/output data bit 1
PTU_PTU2:           equ    2                                         ; Port U general purpose input/output data bit 2
PTU_PTU3:           equ    3                                         ; Port U general purpose input/output data bit 3
PTU_PTU4:           equ    4                                         ; Port U general purpose input/output data bit 4
PTU_PTU5:           equ    5                                         ; Port U general purpose input/output data bit 5
PTU_PTU6:           equ    6                                         ; Port U general purpose input/output data bit 6
PTU_PTU7:           equ    7                                         ; Port U general purpose input/output data bit 7
; bit position masks
mPTU_PTU0:          equ    %00000001
mPTU_PTU1:          equ    %00000010
mPTU_PTU2:          equ    %00000100
mPTU_PTU3:          equ    %00001000
mPTU_PTU4:          equ    %00010000
mPTU_PTU5:          equ    %00100000
mPTU_PTU6:          equ    %01000000
mPTU_PTU7:          equ    %10000000


;*** PTIU - Port U Input Register; 0x00000291 ***
PTIU:               equ    $00000291                                ;*** PTIU - Port U Input Register; 0x00000291 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTIU_PTIU0:         equ    0                                         ; Port U input data bit 0
PTIU_PTIU1:         equ    1                                         ; Port U input data bit 1
PTIU_PTIU2:         equ    2                                         ; Port U input data bit 2
PTIU_PTIU3:         equ    3                                         ; Port U input data bit 3
PTIU_PTIU4:         equ    4                                         ; Port U input data bit 4
PTIU_PTIU5:         equ    5                                         ; Port U input data bit 5
PTIU_PTIU6:         equ    6                                         ; Port U input data bit 6
PTIU_PTIU7:         equ    7                                         ; Port U input data bit 7
; bit position masks
mPTIU_PTIU0:        equ    %00000001
mPTIU_PTIU1:        equ    %00000010
mPTIU_PTIU2:        equ    %00000100
mPTIU_PTIU3:        equ    %00001000
mPTIU_PTIU4:        equ    %00010000
mPTIU_PTIU5:        equ    %00100000
mPTIU_PTIU6:        equ    %01000000
mPTIU_PTIU7:        equ    %10000000


;*** DDRU - Port U Data Direction Register; 0x00000292 ***
DDRU:               equ    $00000292                                ;*** DDRU - Port U Data Direction Register; 0x00000292 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRU_DDRU0:         equ    0                                         ; Port U data direction bit 0
DDRU_DDRU1:         equ    1                                         ; Port U data direction bit 1
DDRU_DDRU2:         equ    2                                         ; Port U data direction bit 2
DDRU_DDRU3:         equ    3                                         ; Port U data direction bit 3
DDRU_DDRU4:         equ    4                                         ; Port U data direction bit 4
DDRU_DDRU5:         equ    5                                         ; Port U data direction bit 5
DDRU_DDRU6:         equ    6                                         ; Port U data direction bit 6
DDRU_DDRU7:         equ    7                                         ; Port U data direction bit 7
; bit position masks
mDDRU_DDRU0:        equ    %00000001
mDDRU_DDRU1:        equ    %00000010
mDDRU_DDRU2:        equ    %00000100
mDDRU_DDRU3:        equ    %00001000
mDDRU_DDRU4:        equ    %00010000
mDDRU_DDRU5:        equ    %00100000
mDDRU_DDRU6:        equ    %01000000
mDDRU_DDRU7:        equ    %10000000


;*** PERU - Port U Pull Device Enable Register; 0x00000294 ***
PERU:               equ    $00000294                                ;*** PERU - Port U Pull Device Enable Register; 0x00000294 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PERU_PERU0:         equ    0                                         ; Port U pull device enable bit 0
PERU_PERU1:         equ    1                                         ; Port U pull device enable bit 1
PERU_PERU2:         equ    2                                         ; Port U pull device enable bit 2
PERU_PERU3:         equ    3                                         ; Port U pull device enable bit 3
PERU_PERU4:         equ    4                                         ; Port U pull device enable bit 4
PERU_PERU5:         equ    5                                         ; Port U pull device enable bit 5
PERU_PERU6:         equ    6                                         ; Port U pull device enable bit 6
PERU_PERU7:         equ    7                                         ; Port U pull device enable bit 7
; bit position masks
mPERU_PERU0:        equ    %00000001
mPERU_PERU1:        equ    %00000010
mPERU_PERU2:        equ    %00000100
mPERU_PERU3:        equ    %00001000
mPERU_PERU4:        equ    %00010000
mPERU_PERU5:        equ    %00100000
mPERU_PERU6:        equ    %01000000
mPERU_PERU7:        equ    %10000000


;*** PPSU - Port U Polarity Select Register; 0x00000295 ***
PPSU:               equ    $00000295                                ;*** PPSU - Port U Polarity Select Register; 0x00000295 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PPSU_PPSU0:         equ    0                                         ; Port U pull device select bit 0
PPSU_PPSU1:         equ    1                                         ; Port U pull device select bit 1
PPSU_PPSU2:         equ    2                                         ; Port U pull device select bit 2
PPSU_PPSU3:         equ    3                                         ; Port U pull device select bit 3
PPSU_PPSU4:         equ    4                                         ; Port U pull device select bit 4
PPSU_PPSU5:         equ    5                                         ; Port U pull device select bit 5
PPSU_PPSU6:         equ    6                                         ; Port U pull device select bit 6
PPSU_PPSU7:         equ    7                                         ; Port U pull device select bit 7
; bit position masks
mPPSU_PPSU0:        equ    %00000001
mPPSU_PPSU1:        equ    %00000010
mPPSU_PPSU2:        equ    %00000100
mPPSU_PPSU3:        equ    %00001000
mPPSU_PPSU4:        equ    %00010000
mPPSU_PPSU5:        equ    %00100000
mPPSU_PPSU6:        equ    %01000000
mPPSU_PPSU7:        equ    %10000000


;*** SRRU - Port U Slew Rate Register; 0x00000296 ***
SRRU:               equ    $00000296                                ;*** SRRU - Port U Slew Rate Register; 0x00000296 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SRRU_SRRU0:         equ    0                                         ; Slew rate port U bit 0
SRRU_SRRU1:         equ    1                                         ; Slew rate port U bit 1
SRRU_SRRU2:         equ    2                                         ; Slew rate port U bit 2
SRRU_SRRU3:         equ    3                                         ; Slew rate port U bit 3
SRRU_SRRU4:         equ    4                                         ; Slew rate port U bit 4
SRRU_SRRU5:         equ    5                                         ; Slew rate port U bit 5
SRRU_SRRU6:         equ    6                                         ; Slew rate port U bit 6
SRRU_SRRU7:         equ    7                                         ; Slew rate port U bit 7
; bit position masks
mSRRU_SRRU0:        equ    %00000001
mSRRU_SRRU1:        equ    %00000010
mSRRU_SRRU2:        equ    %00000100
mSRRU_SRRU3:        equ    %00001000
mSRRU_SRRU4:        equ    %00010000
mSRRU_SRRU5:        equ    %00100000
mSRRU_SRRU6:        equ    %01000000
mSRRU_SRRU7:        equ    %10000000


;*** PTV - Port V Data Register; 0x00000298 ***
PTV:                equ    $00000298                                ;*** PTV - Port V Data Register; 0x00000298 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTV_PTV0:           equ    0                                         ; Port V general purpose input/output data bit 0
PTV_PTV1:           equ    1                                         ; Port V general purpose input/output data bit 1
PTV_PTV2:           equ    2                                         ; Port V general purpose input/output data bit 2
PTV_PTV3:           equ    3                                         ; Port V general purpose input/output data bit 3
PTV_PTV4:           equ    4                                         ; Port V general purpose input/output data bit 4
PTV_PTV5:           equ    5                                         ; Port V general purpose input/output data bit 5
PTV_PTV6:           equ    6                                         ; Port V general purpose input/output data bit 6
PTV_PTV7:           equ    7                                         ; Port V general purpose input/output data bit 7
; bit position masks
mPTV_PTV0:          equ    %00000001
mPTV_PTV1:          equ    %00000010
mPTV_PTV2:          equ    %00000100
mPTV_PTV3:          equ    %00001000
mPTV_PTV4:          equ    %00010000
mPTV_PTV5:          equ    %00100000
mPTV_PTV6:          equ    %01000000
mPTV_PTV7:          equ    %10000000


;*** PTIV - Port V Input Register; 0x00000299 ***
PTIV:               equ    $00000299                                ;*** PTIV - Port V Input Register; 0x00000299 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTIV_PTIV0:         equ    0                                         ; Port V input data bit 0
PTIV_PTIV1:         equ    1                                         ; Port V input data bit 1
PTIV_PTIV2:         equ    2                                         ; Port V input data bit 2
PTIV_PTIV3:         equ    3                                         ; Port V input data bit 3
PTIV_PTIV4:         equ    4                                         ; Port V input data bit 4
PTIV_PTIV5:         equ    5                                         ; Port V input data bit 5
PTIV_PTIV6:         equ    6                                         ; Port V input data bit 6
PTIV_PTIV7:         equ    7                                         ; Port V input data bit 7
; bit position masks
mPTIV_PTIV0:        equ    %00000001
mPTIV_PTIV1:        equ    %00000010
mPTIV_PTIV2:        equ    %00000100
mPTIV_PTIV3:        equ    %00001000
mPTIV_PTIV4:        equ    %00010000
mPTIV_PTIV5:        equ    %00100000
mPTIV_PTIV6:        equ    %01000000
mPTIV_PTIV7:        equ    %10000000


;*** DDRV - Port V Data Direction Register; 0x0000029A ***
DDRV:               equ    $0000029A                                ;*** DDRV - Port V Data Direction Register; 0x0000029A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRV_DDRV0:         equ    0                                         ; Port V data direction bit 0
DDRV_DDRV1:         equ    1                                         ; Port V data direction bit 1
DDRV_DDRV2:         equ    2                                         ; Port V data direction bit 2
DDRV_DDRV3:         equ    3                                         ; Port V data direction bit 3
DDRV_DDRV4:         equ    4                                         ; Port V data direction bit 4
DDRV_DDRV5:         equ    5                                         ; Port V data direction bit 5
DDRV_DDRV6:         equ    6                                         ; Port V data direction bit 6
DDRV_DDRV7:         equ    7                                         ; Port V data direction bit 7
; bit position masks
mDDRV_DDRV0:        equ    %00000001
mDDRV_DDRV1:        equ    %00000010
mDDRV_DDRV2:        equ    %00000100
mDDRV_DDRV3:        equ    %00001000
mDDRV_DDRV4:        equ    %00010000
mDDRV_DDRV5:        equ    %00100000
mDDRV_DDRV6:        equ    %01000000
mDDRV_DDRV7:        equ    %10000000


;*** PERV - Port V Pull Device Enable Register; 0x0000029C ***
PERV:               equ    $0000029C                                ;*** PERV - Port V Pull Device Enable Register; 0x0000029C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PERV_PERV0:         equ    0                                         ; Port V pull device enable bit 0
PERV_PERV1:         equ    1                                         ; Port V pull device enable bit 1
PERV_PERV2:         equ    2                                         ; Port V pull device enable bit 2
PERV_PERV3:         equ    3                                         ; Port V pull device enable bit 3
PERV_PERV4:         equ    4                                         ; Port V pull device enable bit 4
PERV_PERV5:         equ    5                                         ; Port V pull device enable bit 5
PERV_PERV6:         equ    6                                         ; Port V pull device enable bit 6
PERV_PERV7:         equ    7                                         ; Port V pull device enable bit 7
; bit position masks
mPERV_PERV0:        equ    %00000001
mPERV_PERV1:        equ    %00000010
mPERV_PERV2:        equ    %00000100
mPERV_PERV3:        equ    %00001000
mPERV_PERV4:        equ    %00010000
mPERV_PERV5:        equ    %00100000
mPERV_PERV6:        equ    %01000000
mPERV_PERV7:        equ    %10000000


;*** PPSV - Port V Polarity Select Register; 0x0000029D ***
PPSV:               equ    $0000029D                                ;*** PPSV - Port V Polarity Select Register; 0x0000029D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PPSV_PPSV0:         equ    0                                         ; Port V pull device select bit 0
PPSV_PPSV1:         equ    1                                         ; Port V pull device select bit 1
PPSV_PPSV2:         equ    2                                         ; Port V pull device select bit 2
PPSV_PPSV3:         equ    3                                         ; Port V pull device select bit 3
PPSV_PPSV4:         equ    4                                         ; Port V pull device select bit 4
PPSV_PPSV5:         equ    5                                         ; Port V pull device select bit 5
PPSV_PPSV6:         equ    6                                         ; Port V pull device select bit 6
PPSV_PPSV7:         equ    7                                         ; Port V pull device select bit 7
; bit position masks
mPPSV_PPSV0:        equ    %00000001
mPPSV_PPSV1:        equ    %00000010
mPPSV_PPSV2:        equ    %00000100
mPPSV_PPSV3:        equ    %00001000
mPPSV_PPSV4:        equ    %00010000
mPPSV_PPSV5:        equ    %00100000
mPPSV_PPSV6:        equ    %01000000
mPPSV_PPSV7:        equ    %10000000


;*** SRRV - Port V Slew Rate Register; 0x0000029E ***
SRRV:               equ    $0000029E                                ;*** SRRV - Port V Slew Rate Register; 0x0000029E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SRRV_SRRV0:         equ    0                                         ; Slew rate port V bit 0
SRRV_SRRV1:         equ    1                                         ; Slew rate port V bit 1
SRRV_SRRV2:         equ    2                                         ; Slew rate port V bit 2
SRRV_SRRV3:         equ    3                                         ; Slew rate port V bit 3
SRRV_SRRV4:         equ    4                                         ; Slew rate port V bit 4
SRRV_SRRV5:         equ    5                                         ; Slew rate port V bit 5
SRRV_SRRV6:         equ    6                                         ; Slew rate port V bit 6
SRRV_SRRV7:         equ    7                                         ; Slew rate port V bit 7
; bit position masks
mSRRV_SRRV0:        equ    %00000001
mSRRV_SRRV1:        equ    %00000010
mSRRV_SRRV2:        equ    %00000100
mSRRV_SRRV3:        equ    %00001000
mSRRV_SRRV4:        equ    %00010000
mSRRV_SRRV5:        equ    %00100000
mSRRV_SRRV6:        equ    %01000000
mSRRV_SRRV7:        equ    %10000000


;*** TIM1_TIOS - Timer Input Capture/Output Compare Select; 0x000002A0 ***
TIM1_TIOS:          equ    $000002A0                                ;*** TIM1_TIOS - Timer Input Capture/Output Compare Select; 0x000002A0 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TIM1_TIOS_IOS0:     equ    0                                         ; Input Capture or Output Compare Channel Configuration Bit 0
TIM1_TIOS_IOS1:     equ    1                                         ; Input Capture or Output Compare Channel Configuration Bit 1
TIM1_TIOS_IOS2:     equ    2                                         ; Input Capture or Output Compare Channel Configuration Bit 2
TIM1_TIOS_IOS3:     equ    3                                         ; Input Capture or Output Compare Channel Configuration Bit 3
TIM1_TIOS_IOS4:     equ    4                                         ; Input Capture or Output Compare Channel Configuration Bit 4
TIM1_TIOS_IOS5:     equ    5                                         ; Input Capture or Output Compare Channel Configuration Bit 5
TIM1_TIOS_IOS6:     equ    6                                         ; Input Capture or Output Compare Channel Configuration Bit 6
TIM1_TIOS_IOS7:     equ    7                                         ; Input Capture or Output Compare Channel Configuration Bit 7
; bit position masks
mTIM1_TIOS_IOS0:    equ    %00000001
mTIM1_TIOS_IOS1:    equ    %00000010
mTIM1_TIOS_IOS2:    equ    %00000100
mTIM1_TIOS_IOS3:    equ    %00001000
mTIM1_TIOS_IOS4:    equ    %00010000
mTIM1_TIOS_IOS5:    equ    %00100000
mTIM1_TIOS_IOS6:    equ    %01000000
mTIM1_TIOS_IOS7:    equ    %10000000


;*** TIM1_CFORC - Timer Compare Force Register; 0x000002A1 ***
TIM1_CFORC:         equ    $000002A1                                ;*** TIM1_CFORC - Timer Compare Force Register; 0x000002A1 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TIM1_CFORC_FOC0:    equ    0                                         ; Force Output Compare Action for Channel 0
TIM1_CFORC_FOC1:    equ    1                                         ; Force Output Compare Action for Channel 1
TIM1_CFORC_FOC2:    equ    2                                         ; Force Output Compare Action for Channel 2
TIM1_CFORC_FOC3:    equ    3                                         ; Force Output Compare Action for Channel 3
TIM1_CFORC_FOC4:    equ    4                                         ; Force Output Compare Action for Channel 4
TIM1_CFORC_FOC5:    equ    5                                         ; Force Output Compare Action for Channel 5
TIM1_CFORC_FOC6:    equ    6                                         ; Force Output Compare Action for Channel 6
TIM1_CFORC_FOC7:    equ    7                                         ; Force Output Compare Action for Channel 7
; bit position masks
mTIM1_CFORC_FOC0:   equ    %00000001
mTIM1_CFORC_FOC1:   equ    %00000010
mTIM1_CFORC_FOC2:   equ    %00000100
mTIM1_CFORC_FOC3:   equ    %00001000
mTIM1_CFORC_FOC4:   equ    %00010000
mTIM1_CFORC_FOC5:   equ    %00100000
mTIM1_CFORC_FOC6:   equ    %01000000
mTIM1_CFORC_FOC7:   equ    %10000000


;*** TIM1_OC7M - Output Compare 7 Mask Register; 0x000002A2 ***
TIM1_OC7M:          equ    $000002A2                                ;*** TIM1_OC7M - Output Compare 7 Mask Register; 0x000002A2 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TIM1_OC7M_OC7M0:    equ    0                                         ; Output Compare 7 Mask Bit 0
TIM1_OC7M_OC7M1:    equ    1                                         ; Output Compare 7 Mask Bit 1
TIM1_OC7M_OC7M2:    equ    2                                         ; Output Compare 7 Mask Bit 2
TIM1_OC7M_OC7M3:    equ    3                                         ; Output Compare 7 Mask Bit 3
TIM1_OC7M_OC7M4:    equ    4                                         ; Output Compare 7 Mask Bit 4
TIM1_OC7M_OC7M5:    equ    5                                         ; Output Compare 7 Mask Bit 5
TIM1_OC7M_OC7M6:    equ    6                                         ; Output Compare 7 Mask Bit 6
TIM1_OC7M_OC7M7:    equ    7                                         ; Output Compare 7 Mask Bit 7
; bit position masks
mTIM1_OC7M_OC7M0:   equ    %00000001
mTIM1_OC7M_OC7M1:   equ    %00000010
mTIM1_OC7M_OC7M2:   equ    %00000100
mTIM1_OC7M_OC7M3:   equ    %00001000
mTIM1_OC7M_OC7M4:   equ    %00010000
mTIM1_OC7M_OC7M5:   equ    %00100000
mTIM1_OC7M_OC7M6:   equ    %01000000
mTIM1_OC7M_OC7M7:   equ    %10000000


;*** TIM1_OC7D - Output Compare 7 Data Register; 0x000002A3 ***
TIM1_OC7D:          equ    $000002A3                                ;*** TIM1_OC7D - Output Compare 7 Data Register; 0x000002A3 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TIM1_OC7D_OC7D0:    equ    0                                         ; Output Compare 7 Bit 0
TIM1_OC7D_OC7D1:    equ    1                                         ; Output Compare 7 Bit 1
TIM1_OC7D_OC7D2:    equ    2                                         ; Output Compare 7 Bit 2
TIM1_OC7D_OC7D3:    equ    3                                         ; Output Compare 7 Bit 3
TIM1_OC7D_OC7D4:    equ    4                                         ; Output Compare 7 Bit 4
TIM1_OC7D_OC7D5:    equ    5                                         ; Output Compare 7 Bit 5
TIM1_OC7D_OC7D6:    equ    6                                         ; Output Compare 7 Bit 6
TIM1_OC7D_OC7D7:    equ    7                                         ; Output Compare 7 Bit 7
; bit position masks
mTIM1_OC7D_OC7D0:   equ    %00000001
mTIM1_OC7D_OC7D1:   equ    %00000010
mTIM1_OC7D_OC7D2:   equ    %00000100
mTIM1_OC7D_OC7D3:   equ    %00001000
mTIM1_OC7D_OC7D4:   equ    %00010000
mTIM1_OC7D_OC7D5:   equ    %00100000
mTIM1_OC7D_OC7D6:   equ    %01000000
mTIM1_OC7D_OC7D7:   equ    %10000000


;*** TIM1_TCNT - Timer Count Register; 0x000002A4 ***
TIM1_TCNT:          equ    $000002A4                                ;*** TIM1_TCNT - Timer Count Register; 0x000002A4 ***


;*** TIM1_TCNTHi - Timer Count Register High; 0x000002A4 ***
TIM1_TCNTHi:        equ    $000002A4                                ;*** TIM1_TCNTHi - Timer Count Register High; 0x000002A4 ***


;*** TIM1_TCNTLo - Timer Count Register Low; 0x000002A5 ***
TIM1_TCNTLo:        equ    $000002A5                                ;*** TIM1_TCNTLo - Timer Count Register Low; 0x000002A5 ***


;*** TIM1_TSCR1 - Timer System Control Register1; 0x000002A6 ***
TIM1_TSCR1:         equ    $000002A6                                ;*** TIM1_TSCR1 - Timer System Control Register1; 0x000002A6 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TIM1_TSCR1_PRNT:    equ    3                                         ; Precision Timer
TIM1_TSCR1_TFFCA:   equ    4                                         ; Timer Fast Flag Clear All
TIM1_TSCR1_TSFRZ:   equ    5                                         ; Timer and Modulus Counter Stop While in Freeze Mode
TIM1_TSCR1_TSWAI:   equ    6                                         ; Timer Module Stops While in Wait
TIM1_TSCR1_TEN:     equ    7                                         ; Timer Enable
; bit position masks
mTIM1_TSCR1_PRNT:   equ    %00001000
mTIM1_TSCR1_TFFCA:  equ    %00010000
mTIM1_TSCR1_TSFRZ:  equ    %00100000
mTIM1_TSCR1_TSWAI:  equ    %01000000
mTIM1_TSCR1_TEN:    equ    %10000000


;*** TIM1_TTOV - Timer Toggle On Overflow Register; 0x000002A7 ***
TIM1_TTOV:          equ    $000002A7                                ;*** TIM1_TTOV - Timer Toggle On Overflow Register; 0x000002A7 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TIM1_TTOV_TOV0:     equ    0                                         ; Toggle On Overflow Bit 0
TIM1_TTOV_TOV1:     equ    1                                         ; Toggle On Overflow Bit 1
TIM1_TTOV_TOV2:     equ    2                                         ; Toggle On Overflow Bit 2
TIM1_TTOV_TOV3:     equ    3                                         ; Toggle On Overflow Bit 3
TIM1_TTOV_TOV4:     equ    4                                         ; Toggle On Overflow Bit 4
TIM1_TTOV_TOV5:     equ    5                                         ; Toggle On Overflow Bit 5
TIM1_TTOV_TOV6:     equ    6                                         ; Toggle On Overflow Bit 6
TIM1_TTOV_TOV7:     equ    7                                         ; Toggle On Overflow Bit 7
; bit position masks
mTIM1_TTOV_TOV0:    equ    %00000001
mTIM1_TTOV_TOV1:    equ    %00000010
mTIM1_TTOV_TOV2:    equ    %00000100
mTIM1_TTOV_TOV3:    equ    %00001000
mTIM1_TTOV_TOV4:    equ    %00010000
mTIM1_TTOV_TOV5:    equ    %00100000
mTIM1_TTOV_TOV6:    equ    %01000000
mTIM1_TTOV_TOV7:    equ    %10000000


;*** TIM1_TCTL1 - Timer Control Register 1; 0x000002A8 ***
TIM1_TCTL1:         equ    $000002A8                                ;*** TIM1_TCTL1 - Timer Control Register 1; 0x000002A8 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TIM1_TCTL1_OL4:     equ    0                                         ; Output Level Bit 4
TIM1_TCTL1_OM4:     equ    1                                         ; Output Mode Bit 4
TIM1_TCTL1_OL5:     equ    2                                         ; Output Level Bit 5
TIM1_TCTL1_OM5:     equ    3                                         ; Output Mode Bit 5
TIM1_TCTL1_OL6:     equ    4                                         ; Output Level Bit 6
TIM1_TCTL1_OM6:     equ    5                                         ; Output Mode Bit 6
TIM1_TCTL1_OL7:     equ    6                                         ; Output Level Bit 7
TIM1_TCTL1_OM7:     equ    7                                         ; Output Mode Bit 7
; bit position masks
mTIM1_TCTL1_OL4:    equ    %00000001
mTIM1_TCTL1_OM4:    equ    %00000010
mTIM1_TCTL1_OL5:    equ    %00000100
mTIM1_TCTL1_OM5:    equ    %00001000
mTIM1_TCTL1_OL6:    equ    %00010000
mTIM1_TCTL1_OM6:    equ    %00100000
mTIM1_TCTL1_OL7:    equ    %01000000
mTIM1_TCTL1_OM7:    equ    %10000000


;*** TIM1_TCTL2 - Timer Control Register 2; 0x000002A9 ***
TIM1_TCTL2:         equ    $000002A9                                ;*** TIM1_TCTL2 - Timer Control Register 2; 0x000002A9 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TIM1_TCTL2_OL0:     equ    0                                         ; Output Level Bit 0
TIM1_TCTL2_OM0:     equ    1                                         ; Output Mode Bit 0
TIM1_TCTL2_OL1:     equ    2                                         ; Output Lecel Bit 1
TIM1_TCTL2_OM1:     equ    3                                         ; Output Mode Bit 1
TIM1_TCTL2_OL2:     equ    4                                         ; Output Level Bit 2
TIM1_TCTL2_OM2:     equ    5                                         ; Output Mode Bit 2
TIM1_TCTL2_OL3:     equ    6                                         ; Output Level Bit 3
TIM1_TCTL2_OM3:     equ    7                                         ; Output Mode Bit 3
; bit position masks
mTIM1_TCTL2_OL0:    equ    %00000001
mTIM1_TCTL2_OM0:    equ    %00000010
mTIM1_TCTL2_OL1:    equ    %00000100
mTIM1_TCTL2_OM1:    equ    %00001000
mTIM1_TCTL2_OL2:    equ    %00010000
mTIM1_TCTL2_OM2:    equ    %00100000
mTIM1_TCTL2_OL3:    equ    %01000000
mTIM1_TCTL2_OM3:    equ    %10000000


;*** TIM1_TCTL3 - Timer Control Register 3; 0x000002AA ***
TIM1_TCTL3:         equ    $000002AA                                ;*** TIM1_TCTL3 - Timer Control Register 3; 0x000002AA ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TIM1_TCTL3_EDG4A:   equ    0                                         ; Input Capture Edge Control 4A
TIM1_TCTL3_EDG4B:   equ    1                                         ; Input Capture Edge Control 4B
TIM1_TCTL3_EDG5A:   equ    2                                         ; Input Capture Edge Control 5A
TIM1_TCTL3_EDG5B:   equ    3                                         ; Input Capture Edge Control 5B
TIM1_TCTL3_EDG6A:   equ    4                                         ; Input Capture Edge Control 6A
TIM1_TCTL3_EDG6B:   equ    5                                         ; Input Capture Edge Control 6B
TIM1_TCTL3_EDG7A:   equ    6                                         ; Input Capture Edge Control 7A
TIM1_TCTL3_EDG7B:   equ    7                                         ; Input Capture Edge Control 7B
; bit position masks
mTIM1_TCTL3_EDG4A:  equ    %00000001
mTIM1_TCTL3_EDG4B:  equ    %00000010
mTIM1_TCTL3_EDG5A:  equ    %00000100
mTIM1_TCTL3_EDG5B:  equ    %00001000
mTIM1_TCTL3_EDG6A:  equ    %00010000
mTIM1_TCTL3_EDG6B:  equ    %00100000
mTIM1_TCTL3_EDG7A:  equ    %01000000
mTIM1_TCTL3_EDG7B:  equ    %10000000


;*** TIM1_TCTL4 - Timer Control Register 4; 0x000002AB ***
TIM1_TCTL4:         equ    $000002AB                                ;*** TIM1_TCTL4 - Timer Control Register 4; 0x000002AB ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TIM1_TCTL4_EDG0A:   equ    0                                         ; Input Capture Edge Control 0A
TIM1_TCTL4_EDG0B:   equ    1                                         ; Input Capture Edge Control 0B
TIM1_TCTL4_EDG1A:   equ    2                                         ; Input Capture Edge Control 1A
TIM1_TCTL4_EDG1B:   equ    3                                         ; Input Capture Edge Control 1B
TIM1_TCTL4_EDG2A:   equ    4                                         ; Input Capture Edge Control 2A
TIM1_TCTL4_EDG2B:   equ    5                                         ; Input Capture Edge Control 2B
TIM1_TCTL4_EDG3A:   equ    6                                         ; Input Capture Edge Control 3A
TIM1_TCTL4_EDG3B:   equ    7                                         ; Input Capture Edge Control 3B
; bit position masks
mTIM1_TCTL4_EDG0A:  equ    %00000001
mTIM1_TCTL4_EDG0B:  equ    %00000010
mTIM1_TCTL4_EDG1A:  equ    %00000100
mTIM1_TCTL4_EDG1B:  equ    %00001000
mTIM1_TCTL4_EDG2A:  equ    %00010000
mTIM1_TCTL4_EDG2B:  equ    %00100000
mTIM1_TCTL4_EDG3A:  equ    %01000000
mTIM1_TCTL4_EDG3B:  equ    %10000000


;*** TIM1_TIE - Timer Interrupt Enable Register; 0x000002AC ***
TIM1_TIE:           equ    $000002AC                                ;*** TIM1_TIE - Timer Interrupt Enable Register; 0x000002AC ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TIM1_TIE_C0I:       equ    0                                         ; Input Capture/Output Compare Interrupt Enable Bit 0
TIM1_TIE_C1I:       equ    1                                         ; Input Capture/Output Compare Interrupt Enable Bit 1
TIM1_TIE_C2I:       equ    2                                         ; Input Capture/Output Compare Interrupt Enable Bit 2
TIM1_TIE_C3I:       equ    3                                         ; Input Capture/Output Compare Interrupt Enable Bit 3
TIM1_TIE_C4I:       equ    4                                         ; Input Capture/Output Compare Interrupt Enable Bit 4
TIM1_TIE_C5I:       equ    5                                         ; Input Capture/Output Compare Interrupt Enable Bit 5
TIM1_TIE_C6I:       equ    6                                         ; Input Capture/Output Compare Interrupt Enable Bit 6
TIM1_TIE_C7I:       equ    7                                         ; Input Capture/Output Compare Interrupt Enable Bit 7
; bit position masks
mTIM1_TIE_C0I:      equ    %00000001
mTIM1_TIE_C1I:      equ    %00000010
mTIM1_TIE_C2I:      equ    %00000100
mTIM1_TIE_C3I:      equ    %00001000
mTIM1_TIE_C4I:      equ    %00010000
mTIM1_TIE_C5I:      equ    %00100000
mTIM1_TIE_C6I:      equ    %01000000
mTIM1_TIE_C7I:      equ    %10000000


;*** TIM1_TSCR2 - Timer System Control Register 2; 0x000002AD ***
TIM1_TSCR2:         equ    $000002AD                                ;*** TIM1_TSCR2 - Timer System Control Register 2; 0x000002AD ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TIM1_TSCR2_PR0:     equ    0                                         ; Timer Prescaler Select Bit 0
TIM1_TSCR2_PR1:     equ    1                                         ; Timer Prescaler Select Bit 1
TIM1_TSCR2_PR2:     equ    2                                         ; Timer Prescaler Select Bit 2
TIM1_TSCR2_TCRE:    equ    3                                         ; Timer Counter Reset Enable
TIM1_TSCR2_TOI:     equ    7                                         ; Timer Overflow Interrupt Enable
; bit position masks
mTIM1_TSCR2_PR0:    equ    %00000001
mTIM1_TSCR2_PR1:    equ    %00000010
mTIM1_TSCR2_PR2:    equ    %00000100
mTIM1_TSCR2_TCRE:   equ    %00001000
mTIM1_TSCR2_TOI:    equ    %10000000


;*** TIM1_TFLG1 - Main Timer Interrupt Flag 1; 0x000002AE ***
TIM1_TFLG1:         equ    $000002AE                                ;*** TIM1_TFLG1 - Main Timer Interrupt Flag 1; 0x000002AE ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TIM1_TFLG1_C0F:     equ    0                                         ; Input Capture/Output Compare Channel Flag 0
TIM1_TFLG1_C1F:     equ    1                                         ; Input Capture/Output Compare Channel Flag 1
TIM1_TFLG1_C2F:     equ    2                                         ; Input Capture/Output Compare Channel Flag 2
TIM1_TFLG1_C3F:     equ    3                                         ; Input Capture/Output Compare Channel Flag 3
TIM1_TFLG1_C4F:     equ    4                                         ; Input Capture/Output Compare Channel Flag 4
TIM1_TFLG1_C5F:     equ    5                                         ; Input Capture/Output Compare Channel Flag 5
TIM1_TFLG1_C6F:     equ    6                                         ; Input Capture/Output Compare Channel Flag 6
TIM1_TFLG1_C7F:     equ    7                                         ; Input Capture/Output Compare Channel Flag 7
; bit position masks
mTIM1_TFLG1_C0F:    equ    %00000001
mTIM1_TFLG1_C1F:    equ    %00000010
mTIM1_TFLG1_C2F:    equ    %00000100
mTIM1_TFLG1_C3F:    equ    %00001000
mTIM1_TFLG1_C4F:    equ    %00010000
mTIM1_TFLG1_C5F:    equ    %00100000
mTIM1_TFLG1_C6F:    equ    %01000000
mTIM1_TFLG1_C7F:    equ    %10000000


;*** TIM1_TFLG2 - Main Timer Interrupt Flag 2; 0x000002AF ***
TIM1_TFLG2:         equ    $000002AF                                ;*** TIM1_TFLG2 - Main Timer Interrupt Flag 2; 0x000002AF ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TIM1_TFLG2_TOF:     equ    7                                         ; Timer Overflow Flag
; bit position masks
mTIM1_TFLG2_TOF:    equ    %10000000


;*** TIM1_TC0 - Timer Input Capture/Output Compare Register 0; 0x000002B0 ***
TIM1_TC0:           equ    $000002B0                                ;*** TIM1_TC0 - Timer Input Capture/Output Compare Register 0; 0x000002B0 ***


;*** TIM1_TC0Hi - Timer Input Capture/Output Compare Register 0 High; 0x000002B0 ***
TIM1_TC0Hi:         equ    $000002B0                                ;*** TIM1_TC0Hi - Timer Input Capture/Output Compare Register 0 High; 0x000002B0 ***


;*** TIM1_TC0Lo - Timer Input Capture/Output Compare Register 0 Low; 0x000002B1 ***
TIM1_TC0Lo:         equ    $000002B1                                ;*** TIM1_TC0Lo - Timer Input Capture/Output Compare Register 0 Low; 0x000002B1 ***


;*** TIM1_TC1 - Timer Input Capture/Output Compare Register 1; 0x000002B2 ***
TIM1_TC1:           equ    $000002B2                                ;*** TIM1_TC1 - Timer Input Capture/Output Compare Register 1; 0x000002B2 ***


;*** TIM1_TC1Hi - Timer Input Capture/Output Compare Register 1 High; 0x000002B2 ***
TIM1_TC1Hi:         equ    $000002B2                                ;*** TIM1_TC1Hi - Timer Input Capture/Output Compare Register 1 High; 0x000002B2 ***


;*** TIM1_TC1Lo - Timer Input Capture/Output Compare Register 1 Low; 0x000002B3 ***
TIM1_TC1Lo:         equ    $000002B3                                ;*** TIM1_TC1Lo - Timer Input Capture/Output Compare Register 1 Low; 0x000002B3 ***


;*** TIM1_TC2 - Timer Input Capture/Output Compare Register 2; 0x000002B4 ***
TIM1_TC2:           equ    $000002B4                                ;*** TIM1_TC2 - Timer Input Capture/Output Compare Register 2; 0x000002B4 ***


;*** TIM1_TC2Hi - Timer Input Capture/Output Compare Register 2 High; 0x000002B4 ***
TIM1_TC2Hi:         equ    $000002B4                                ;*** TIM1_TC2Hi - Timer Input Capture/Output Compare Register 2 High; 0x000002B4 ***


;*** TIM1_TC2Lo - Timer Input Capture/Output Compare Register 2 Low; 0x000002B5 ***
TIM1_TC2Lo:         equ    $000002B5                                ;*** TIM1_TC2Lo - Timer Input Capture/Output Compare Register 2 Low; 0x000002B5 ***


;*** TIM1_TC3 - Timer Input Capture/Output Compare Register 3; 0x000002B6 ***
TIM1_TC3:           equ    $000002B6                                ;*** TIM1_TC3 - Timer Input Capture/Output Compare Register 3; 0x000002B6 ***


;*** TIM1_TC3Hi - Timer Input Capture/Output Compare Register 3 High; 0x000002B6 ***
TIM1_TC3Hi:         equ    $000002B6                                ;*** TIM1_TC3Hi - Timer Input Capture/Output Compare Register 3 High; 0x000002B6 ***


;*** TIM1_TC3Lo - Timer Input Capture/Output Compare Register 3 Low; 0x000002B7 ***
TIM1_TC3Lo:         equ    $000002B7                                ;*** TIM1_TC3Lo - Timer Input Capture/Output Compare Register 3 Low; 0x000002B7 ***


;*** TIM1_TC4 - Timer Input Capture/Output Compare Register 4; 0x000002B8 ***
TIM1_TC4:           equ    $000002B8                                ;*** TIM1_TC4 - Timer Input Capture/Output Compare Register 4; 0x000002B8 ***


;*** TIM1_TC4Hi - Timer Input Capture/Output Compare Register 4 High; 0x000002B8 ***
TIM1_TC4Hi:         equ    $000002B8                                ;*** TIM1_TC4Hi - Timer Input Capture/Output Compare Register 4 High; 0x000002B8 ***


;*** TIM1_TC4Lo - Timer Input Capture/Output Compare Register 4 Low; 0x000002B9 ***
TIM1_TC4Lo:         equ    $000002B9                                ;*** TIM1_TC4Lo - Timer Input Capture/Output Compare Register 4 Low; 0x000002B9 ***


;*** TIM1_TC5 - Timer Input Capture/Output Compare Register 5; 0x000002BA ***
TIM1_TC5:           equ    $000002BA                                ;*** TIM1_TC5 - Timer Input Capture/Output Compare Register 5; 0x000002BA ***


;*** TIM1_TC5Hi - Timer Input Capture/Output Compare Register 5 High; 0x000002BA ***
TIM1_TC5Hi:         equ    $000002BA                                ;*** TIM1_TC5Hi - Timer Input Capture/Output Compare Register 5 High; 0x000002BA ***


;*** TIM1_TC5Lo - Timer Input Capture/Output Compare Register 5 Low; 0x000002BB ***
TIM1_TC5Lo:         equ    $000002BB                                ;*** TIM1_TC5Lo - Timer Input Capture/Output Compare Register 5 Low; 0x000002BB ***


;*** TIM1_TC6 - Timer Input Capture/Output Compare Register 6; 0x000002BC ***
TIM1_TC6:           equ    $000002BC                                ;*** TIM1_TC6 - Timer Input Capture/Output Compare Register 6; 0x000002BC ***


;*** TIM1_TC6Hi - Timer Input Capture/Output Compare Register 6 High; 0x000002BC ***
TIM1_TC6Hi:         equ    $000002BC                                ;*** TIM1_TC6Hi - Timer Input Capture/Output Compare Register 6 High; 0x000002BC ***


;*** TIM1_TC6Lo - Timer Input Capture/Output Compare Register 6 Low; 0x000002BD ***
TIM1_TC6Lo:         equ    $000002BD                                ;*** TIM1_TC6Lo - Timer Input Capture/Output Compare Register 6 Low; 0x000002BD ***


;*** TIM1_TC7 - Timer Input Capture/Output Compare Register 7; 0x000002BE ***
TIM1_TC7:           equ    $000002BE                                ;*** TIM1_TC7 - Timer Input Capture/Output Compare Register 7; 0x000002BE ***


;*** TIM1_TC7Hi - Timer Input Capture/Output Compare Register 7 High; 0x000002BE ***
TIM1_TC7Hi:         equ    $000002BE                                ;*** TIM1_TC7Hi - Timer Input Capture/Output Compare Register 7 High; 0x000002BE ***


;*** TIM1_TC7Lo - Timer Input Capture/Output Compare Register 7 Low; 0x000002BF ***
TIM1_TC7Lo:         equ    $000002BF                                ;*** TIM1_TC7Lo - Timer Input Capture/Output Compare Register 7 Low; 0x000002BF ***


;*** TIM1_PACTL - 16-Bit Pulse Accumulator A Control Register; 0x000002C0 ***
TIM1_PACTL:         equ    $000002C0                                ;*** TIM1_PACTL - 16-Bit Pulse Accumulator A Control Register; 0x000002C0 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TIM1_PACTL_PAI:     equ    0                                         ; Pulse Accumulator Input Interrupt enable
TIM1_PACTL_PAOVI:   equ    1                                         ; Pulse Accumulator A Overflow Interrupt enable
TIM1_PACTL_CLK0:    equ    2                                         ; Clock Select Bit 0
TIM1_PACTL_CLK1:    equ    3                                         ; Clock Select Bit 1
TIM1_PACTL_PEDGE:   equ    4                                         ; Pulse Accumulator Edge Control
TIM1_PACTL_PAMOD:   equ    5                                         ; Pulse Accumulator Mode
TIM1_PACTL_PAEN:    equ    6                                         ; Pulse Accumulator A System Enable
; bit position masks
mTIM1_PACTL_PAI:    equ    %00000001
mTIM1_PACTL_PAOVI:  equ    %00000010
mTIM1_PACTL_CLK0:   equ    %00000100
mTIM1_PACTL_CLK1:   equ    %00001000
mTIM1_PACTL_PEDGE:  equ    %00010000
mTIM1_PACTL_PAMOD:  equ    %00100000
mTIM1_PACTL_PAEN:   equ    %01000000


;*** TIM1_PAFLG - Pulse Accumulator A Flag Register; 0x000002C1 ***
TIM1_PAFLG:         equ    $000002C1                                ;*** TIM1_PAFLG - Pulse Accumulator A Flag Register; 0x000002C1 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TIM1_PAFLG_PAIF:    equ    0                                         ; Pulse Accumulator Input edge Flag
TIM1_PAFLG_PAOVF:   equ    1                                         ; Pulse Accumulator A Overflow Flag
; bit position masks
mTIM1_PAFLG_PAIF:   equ    %00000001
mTIM1_PAFLG_PAOVF:  equ    %00000010


;*** TIM1_PACNT - Pulse Accumulators Count Register; 0x000002C2 ***
TIM1_PACNT:         equ    $000002C2                                ;*** TIM1_PACNT - Pulse Accumulators Count Register; 0x000002C2 ***


;*** TIM1_PACNTH - Pulse Accumulators Count Register High; 0x000002C2 ***
TIM1_PACNTH:        equ    $000002C2                                ;*** TIM1_PACNTH - Pulse Accumulators Count Register High; 0x000002C2 ***


;*** TIM1_PACNTL - Pulse Accumulators Count Register Low; 0x000002C3 ***
TIM1_PACNTL:        equ    $000002C3                                ;*** TIM1_PACNTL - Pulse Accumulators Count Register Low; 0x000002C3 ***


;*** TIM1_OCPD - Output Compare Pin Disconnect Register; 0x000002CC ***
TIM1_OCPD:          equ    $000002CC                                ;*** TIM1_OCPD - Output Compare Pin Disconnect Register; 0x000002CC ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TIM1_OCPD_OCPD0:    equ    0                                         ; Output Compare Pin Disconnect Bit 0
TIM1_OCPD_OCPD1:    equ    1                                         ; Output Compare Pin Disconnect Bit 1
TIM1_OCPD_OCPD2:    equ    2                                         ; Output Compare Pin Disconnect Bit 2
TIM1_OCPD_OCPD3:    equ    3                                         ; Output Compare Pin Disconnect Bit 3
TIM1_OCPD_OCPD4:    equ    4                                         ; Output Compare Pin Disconnect Bit 4
TIM1_OCPD_OCPD5:    equ    5                                         ; Output Compare Pin Disconnect Bit 5
TIM1_OCPD_OCPD6:    equ    6                                         ; Output Compare Pin Disconnect Bit 6
TIM1_OCPD_OCPD7:    equ    7                                         ; Output Compare Pin Disconnect Bit 7
; bit position masks
mTIM1_OCPD_OCPD0:   equ    %00000001
mTIM1_OCPD_OCPD1:   equ    %00000010
mTIM1_OCPD_OCPD2:   equ    %00000100
mTIM1_OCPD_OCPD3:   equ    %00001000
mTIM1_OCPD_OCPD4:   equ    %00010000
mTIM1_OCPD_OCPD5:   equ    %00100000
mTIM1_OCPD_OCPD6:   equ    %01000000
mTIM1_OCPD_OCPD7:   equ    %10000000


;*** TIM1_PTPSR - Precision Timer Prescaler Select Register; 0x000002CE ***
TIM1_PTPSR:         equ    $000002CE                                ;*** TIM1_PTPSR - Precision Timer Prescaler Select Register; 0x000002CE ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TIM1_PTPSR_PTPS0:   equ    0                                         ; Precision Timer Prescaler Select Bit 0
TIM1_PTPSR_PTPS1:   equ    1                                         ; Precision Timer Prescaler Select Bit 1
TIM1_PTPSR_PTPS2:   equ    2                                         ; Precision Timer Prescaler Select Bit 2
TIM1_PTPSR_PTPS3:   equ    3                                         ; Precision Timer Prescaler Select Bit 3
TIM1_PTPSR_PTPS4:   equ    4                                         ; Precision Timer Prescaler Select Bit 4
TIM1_PTPSR_PTPS5:   equ    5                                         ; Precision Timer Prescaler Select Bit 5
TIM1_PTPSR_PTPS6:   equ    6                                         ; Precision Timer Prescaler Select Bit 6
TIM1_PTPSR_PTPS7:   equ    7                                         ; Precision Timer Prescaler Select Bit 7
; bit position masks
mTIM1_PTPSR_PTPS0:  equ    %00000001
mTIM1_PTPSR_PTPS1:  equ    %00000010
mTIM1_PTPSR_PTPS2:  equ    %00000100
mTIM1_PTPSR_PTPS3:  equ    %00001000
mTIM1_PTPSR_PTPS4:  equ    %00010000
mTIM1_PTPSR_PTPS5:  equ    %00100000
mTIM1_PTPSR_PTPS6:  equ    %01000000
mTIM1_PTPSR_PTPS7:  equ    %10000000


;*** CPMUHTCTL - High Temperature Control Register; 0x000002F0 ***
CPMUHTCTL:          equ    $000002F0                                ;*** CPMUHTCTL - High Temperature Control Register; 0x000002F0 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CPMUHTCTL_HTIF:     equ    0                                         ; High Temperature Interrupt Flag
CPMUHTCTL_HTIE:     equ    1                                         ; High Temperature Interrupt Enable Bit
CPMUHTCTL_HTDS:     equ    2                                         ; High Temperature Detect Status Bi
CPMUHTCTL_HTE:      equ    3                                         ; High Temperature Enable Bit
CPMUHTCTL_VSEL:     equ    5                                         ; Voltage Access Select Bit
; bit position masks
mCPMUHTCTL_HTIF:    equ    %00000001
mCPMUHTCTL_HTIE:    equ    %00000010
mCPMUHTCTL_HTDS:    equ    %00000100
mCPMUHTCTL_HTE:     equ    %00001000
mCPMUHTCTL_VSEL:    equ    %00100000


;*** CPMULVCTL - Low Voltage Control Register; 0x000002F1 ***
CPMULVCTL:          equ    $000002F1                                ;*** CPMULVCTL - Low Voltage Control Register; 0x000002F1 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CPMULVCTL_LVIF:     equ    0                                         ; Low-Voltage Interrupt Flag
CPMULVCTL_LVIE:     equ    1                                         ; Low-Voltage Interrupt Enable Bit
CPMULVCTL_LVDS:     equ    2                                         ; Low-Voltage Detect Status Bit
; bit position masks
mCPMULVCTL_LVIF:    equ    %00000001
mCPMULVCTL_LVIE:    equ    %00000010
mCPMULVCTL_LVDS:    equ    %00000100


;*** CPMUAPICTL - Autonomous Periodical Interrupt Control Register; 0x000002F2 ***
CPMUAPICTL:         equ    $000002F2                                ;*** CPMUAPICTL - Autonomous Periodical Interrupt Control Register; 0x000002F2 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CPMUAPICTL_APIF:    equ    0                                         ; Autonomous Periodical Interrupt Flag
CPMUAPICTL_APIE:    equ    1                                         ; Autonomous Periodical Interrupt Enable Bit
CPMUAPICTL_APIFE:   equ    2                                         ; Autonomous Periodical Interrupt Feature Enable Bit
CPMUAPICTL_APIEA:   equ    3                                         ; Autonomous Periodical Interrupt External Access Enable Bit
CPMUAPICTL_APIES:   equ    4                                         ; Autonomous Periodical Interrupt External Select Bit
CPMUAPICTL_APICLK:  equ    7                                         ; Autonomous Periodical Interrupt Clock Select Bit
; bit position masks
mCPMUAPICTL_APIF:   equ    %00000001
mCPMUAPICTL_APIE:   equ    %00000010
mCPMUAPICTL_APIFE:  equ    %00000100
mCPMUAPICTL_APIEA:  equ    %00001000
mCPMUAPICTL_APIES:  equ    %00010000
mCPMUAPICTL_APICLK: equ    %10000000


;*** CPMUAPITR - Autonomous Periodical Interrupt Trimming Register; 0x000002F3 ***
CPMUAPITR:          equ    $000002F3                                ;*** CPMUAPITR - Autonomous Periodical Interrupt Trimming Register; 0x000002F3 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CPMUAPITR_APITR0:   equ    2                                         ; Autonomous Periodical Interrupt Period Trimming Bit 0
CPMUAPITR_APITR1:   equ    3                                         ; Autonomous Periodical Interrupt Period Trimming Bit 1
CPMUAPITR_APITR2:   equ    4                                         ; Autonomous Periodical Interrupt Period Trimming Bit 2
CPMUAPITR_APITR3:   equ    5                                         ; Autonomous Periodical Interrupt Period Trimming Bit 3
CPMUAPITR_APITR4:   equ    6                                         ; Autonomous Periodical Interrupt Period Trimming Bit 4
CPMUAPITR_APITR5:   equ    7                                         ; Autonomous Periodical Interrupt Period Trimming Bit 5
; bit position masks
mCPMUAPITR_APITR0:  equ    %00000100
mCPMUAPITR_APITR1:  equ    %00001000
mCPMUAPITR_APITR2:  equ    %00010000
mCPMUAPITR_APITR3:  equ    %00100000
mCPMUAPITR_APITR4:  equ    %01000000
mCPMUAPITR_APITR5:  equ    %10000000


;*** CPMUAPIR - Autonomous Periodical Interrupt Rate Register; 0x000002F4 ***
CPMUAPIR:           equ    $000002F4                                ;*** CPMUAPIR - Autonomous Periodical Interrupt Rate Register; 0x000002F4 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CPMUAPIR_APIR0:     equ    0                                         ; Autonomous Periodical Interrupt Rate Bit 0
CPMUAPIR_APIR1:     equ    1                                         ; Autonomous Periodical Interrupt Rate Bit 1
CPMUAPIR_APIR2:     equ    2                                         ; Autonomous Periodical Interrupt Rate Bit 2
CPMUAPIR_APIR3:     equ    3                                         ; Autonomous Periodical Interrupt Rate Bit 3
CPMUAPIR_APIR4:     equ    4                                         ; Autonomous Periodical Interrupt Rate Bit 4
CPMUAPIR_APIR5:     equ    5                                         ; Autonomous Periodical Interrupt Rate Bit 5
CPMUAPIR_APIR6:     equ    6                                         ; Autonomous Periodical Interrupt Rate Bit 6
CPMUAPIR_APIR7:     equ    7                                         ; Autonomous Periodical Interrupt Rate Bit 7
CPMUAPIR_APIR8:     equ    8                                         ; Autonomous Periodical Interrupt Rate Bit 8
CPMUAPIR_APIR9:     equ    9                                         ; Autonomous Periodical Interrupt Rate Bit 9
CPMUAPIR_APIR10:    equ    10                                        ; Autonomous Periodical Interrupt Rate Bit 10
CPMUAPIR_APIR11:    equ    11                                        ; Autonomous Periodical Interrupt Rate Bit 11
CPMUAPIR_APIR12:    equ    12                                        ; Autonomous Periodical Interrupt Rate Bit 12
CPMUAPIR_APIR13:    equ    13                                        ; Autonomous Periodical Interrupt Rate Bit 13
CPMUAPIR_APIR14:    equ    14                                        ; Autonomous Periodical Interrupt Rate Bit 14
CPMUAPIR_APIR15:    equ    15                                        ; Autonomous Periodical Interrupt Rate Bit 15
; bit position masks
mCPMUAPIR_APIR0:    equ    %00000001
mCPMUAPIR_APIR1:    equ    %00000010
mCPMUAPIR_APIR2:    equ    %00000100
mCPMUAPIR_APIR3:    equ    %00001000
mCPMUAPIR_APIR4:    equ    %00010000
mCPMUAPIR_APIR5:    equ    %00100000
mCPMUAPIR_APIR6:    equ    %01000000
mCPMUAPIR_APIR7:    equ    %10000000
mCPMUAPIR_APIR8:    equ    %100000000
mCPMUAPIR_APIR9:    equ    %1000000000
mCPMUAPIR_APIR10:   equ    %10000000000
mCPMUAPIR_APIR11:   equ    %100000000000
mCPMUAPIR_APIR12:   equ    %1000000000000
mCPMUAPIR_APIR13:   equ    %10000000000000
mCPMUAPIR_APIR14:   equ    %100000000000000
mCPMUAPIR_APIR15:   equ    %1000000000000000


;*** CPMUAPIRH - Autonomous Periodical Interrupt Rate Register High; 0x000002F4 ***
CPMUAPIRH:          equ    $000002F4                                ;*** CPMUAPIRH - Autonomous Periodical Interrupt Rate Register High; 0x000002F4 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CPMUAPIRH_APIR8:    equ    0                                         ; Autonomous Periodical Interrupt Rate Bit 8
CPMUAPIRH_APIR9:    equ    1                                         ; Autonomous Periodical Interrupt Rate Bit 9
CPMUAPIRH_APIR10:   equ    2                                         ; Autonomous Periodical Interrupt Rate Bit 10
CPMUAPIRH_APIR11:   equ    3                                         ; Autonomous Periodical Interrupt Rate Bit 11
CPMUAPIRH_APIR12:   equ    4                                         ; Autonomous Periodical Interrupt Rate Bit 12
CPMUAPIRH_APIR13:   equ    5                                         ; Autonomous Periodical Interrupt Rate Bit 13
CPMUAPIRH_APIR14:   equ    6                                         ; Autonomous Periodical Interrupt Rate Bit 14
CPMUAPIRH_APIR15:   equ    7                                         ; Autonomous Periodical Interrupt Rate Bit 15
; bit position masks
mCPMUAPIRH_APIR8:   equ    %00000001
mCPMUAPIRH_APIR9:   equ    %00000010
mCPMUAPIRH_APIR10:  equ    %00000100
mCPMUAPIRH_APIR11:  equ    %00001000
mCPMUAPIRH_APIR12:  equ    %00010000
mCPMUAPIRH_APIR13:  equ    %00100000
mCPMUAPIRH_APIR14:  equ    %01000000
mCPMUAPIRH_APIR15:  equ    %10000000


;*** CPMUAPIRL - Autonomous Periodical Interrupt Rate Register Low; 0x000002F5 ***
CPMUAPIRL:          equ    $000002F5                                ;*** CPMUAPIRL - Autonomous Periodical Interrupt Rate Register Low; 0x000002F5 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CPMUAPIRL_APIR0:    equ    0                                         ; Autonomous Periodical Interrupt Rate Bit 0
CPMUAPIRL_APIR1:    equ    1                                         ; Autonomous Periodical Interrupt Rate Bit 1
CPMUAPIRL_APIR2:    equ    2                                         ; Autonomous Periodical Interrupt Rate Bit 2
CPMUAPIRL_APIR3:    equ    3                                         ; Autonomous Periodical Interrupt Rate Bit 3
CPMUAPIRL_APIR4:    equ    4                                         ; Autonomous Periodical Interrupt Rate Bit 4
CPMUAPIRL_APIR5:    equ    5                                         ; Autonomous Periodical Interrupt Rate Bit 5
CPMUAPIRL_APIR6:    equ    6                                         ; Autonomous Periodical Interrupt Rate Bit 6
CPMUAPIRL_APIR7:    equ    7                                         ; Autonomous Periodical Interrupt Rate Bit 7
; bit position masks
mCPMUAPIRL_APIR0:   equ    %00000001
mCPMUAPIRL_APIR1:   equ    %00000010
mCPMUAPIRL_APIR2:   equ    %00000100
mCPMUAPIRL_APIR3:   equ    %00001000
mCPMUAPIRL_APIR4:   equ    %00010000
mCPMUAPIRL_APIR5:   equ    %00100000
mCPMUAPIRL_APIR6:   equ    %01000000
mCPMUAPIRL_APIR7:   equ    %10000000


;*** CPMUHTTR - High Temperature Trimming Register; 0x000002F7 ***
CPMUHTTR:           equ    $000002F7                                ;*** CPMUHTTR - High Temperature Trimming Register; 0x000002F7 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CPMUHTTR_HTTR0:     equ    0                                         ; High Temperature Trimming Bits, bit 0
CPMUHTTR_HTTR1:     equ    1                                         ; High Temperature Trimming Bits, bit 1
CPMUHTTR_HTTR2:     equ    2                                         ; High Temperature Trimming Bits, bit 2
CPMUHTTR_HTTR3:     equ    3                                         ; High Temperature Trimming Bits, bit 3
CPMUHTTR_HTOE:      equ    7                                         ; High Temperature Offeset Enable Bit
; bit position masks
mCPMUHTTR_HTTR0:    equ    %00000001
mCPMUHTTR_HTTR1:    equ    %00000010
mCPMUHTTR_HTTR2:    equ    %00000100
mCPMUHTTR_HTTR3:    equ    %00001000
mCPMUHTTR_HTOE:     equ    %10000000


;*** CPMUIRCTRIM - S12CPMU IRC1M Trim Registers; 0x000002F8 ***
CPMUIRCTRIM:        equ    $000002F8                                ;*** CPMUIRCTRIM - S12CPMU IRC1M Trim Registers; 0x000002F8 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CPMUIRCTRIM_IRCTRIM0: equ    0                                       ; IRC1M Frequency Trim Bit 0
CPMUIRCTRIM_IRCTRIM1: equ    1                                       ; IRC1M Frequency Trim Bit 1
CPMUIRCTRIM_IRCTRIM2: equ    2                                       ; IRC1M Frequency Trim Bit 2
CPMUIRCTRIM_IRCTRIM3: equ    3                                       ; IRC1M Frequency Trim Bit 3
CPMUIRCTRIM_IRCTRIM4: equ    4                                       ; IRC1M Frequency Trim Bit 4
CPMUIRCTRIM_IRCTRIM5: equ    5                                       ; IRC1M Frequency Trim Bit 5
CPMUIRCTRIM_IRCTRIM6: equ    6                                       ; IRC1M Frequency Trim Bit 6
CPMUIRCTRIM_IRCTRIM7: equ    7                                       ; IRC1M Frequency Trim Bit 7
CPMUIRCTRIM_IRCTRIM8: equ    8                                       ; IRC1M Frequency Trim Bit 8
CPMUIRCTRIM_IRCTRIM9: equ    9                                       ; IRC1M Frequency Trim Bit 9
CPMUIRCTRIM_TCTRIM0: equ    12                                       ; IRC1M temperature coeficient Trim Bit 0
CPMUIRCTRIM_TCTRIM1: equ    13                                       ; IRC1M temperature coeficient Trim Bit 1
CPMUIRCTRIM_TCTRIM2: equ    14                                       ; IRC1M temperature coeficient Trim Bit 2
CPMUIRCTRIM_TCTRIM3: equ    15                                       ; IRC1M temperature coeficient Trim Bit 3
; bit position masks
mCPMUIRCTRIM_IRCTRIM0: equ    %00000001
mCPMUIRCTRIM_IRCTRIM1: equ    %00000010
mCPMUIRCTRIM_IRCTRIM2: equ    %00000100
mCPMUIRCTRIM_IRCTRIM3: equ    %00001000
mCPMUIRCTRIM_IRCTRIM4: equ    %00010000
mCPMUIRCTRIM_IRCTRIM5: equ    %00100000
mCPMUIRCTRIM_IRCTRIM6: equ    %01000000
mCPMUIRCTRIM_IRCTRIM7: equ    %10000000
mCPMUIRCTRIM_IRCTRIM8: equ    %100000000
mCPMUIRCTRIM_IRCTRIM9: equ    %1000000000
mCPMUIRCTRIM_TCTRIM0: equ    %1000000000000
mCPMUIRCTRIM_TCTRIM1: equ    %10000000000000
mCPMUIRCTRIM_TCTRIM2: equ    %100000000000000
mCPMUIRCTRIM_TCTRIM3: equ    %1000000000000000


;*** CPMUIRCTRIMH - S12CPMU IRC1M Trim Registers High; 0x000002F8 ***
CPMUIRCTRIMH:       equ    $000002F8                                ;*** CPMUIRCTRIMH - S12CPMU IRC1M Trim Registers High; 0x000002F8 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CPMUIRCTRIMH_IRCTRIM8: equ    0                                      ; IRC1M Frequency Trim Bit 8
CPMUIRCTRIMH_IRCTRIM9: equ    1                                      ; IRC1M Frequency Trim Bit 9
CPMUIRCTRIMH_TCTRIM0: equ    4                                       ; IRC1M temperature coeficient Trim Bit 0
CPMUIRCTRIMH_TCTRIM1: equ    5                                       ; IRC1M temperature coeficient Trim Bit 1
CPMUIRCTRIMH_TCTRIM2: equ    6                                       ; IRC1M temperature coeficient Trim Bit 2
CPMUIRCTRIMH_TCTRIM3: equ    7                                       ; IRC1M temperature coeficient Trim Bit 3
; bit position masks
mCPMUIRCTRIMH_IRCTRIM8: equ    %00000001
mCPMUIRCTRIMH_IRCTRIM9: equ    %00000010
mCPMUIRCTRIMH_TCTRIM0: equ    %00010000
mCPMUIRCTRIMH_TCTRIM1: equ    %00100000
mCPMUIRCTRIMH_TCTRIM2: equ    %01000000
mCPMUIRCTRIMH_TCTRIM3: equ    %10000000


;*** CPMUIRCTRIML - S12CPMU IRC1M Trim Registers Low; 0x000002F9 ***
CPMUIRCTRIML:       equ    $000002F9                                ;*** CPMUIRCTRIML - S12CPMU IRC1M Trim Registers Low; 0x000002F9 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CPMUIRCTRIML_IRCTRIM0: equ    0                                      ; IRC1M Frequency Trim Bit 0
CPMUIRCTRIML_IRCTRIM1: equ    1                                      ; IRC1M Frequency Trim Bit 1
CPMUIRCTRIML_IRCTRIM2: equ    2                                      ; IRC1M Frequency Trim Bit 2
CPMUIRCTRIML_IRCTRIM3: equ    3                                      ; IRC1M Frequency Trim Bit 3
CPMUIRCTRIML_IRCTRIM4: equ    4                                      ; IRC1M Frequency Trim Bit 4
CPMUIRCTRIML_IRCTRIM5: equ    5                                      ; IRC1M Frequency Trim Bit 5
CPMUIRCTRIML_IRCTRIM6: equ    6                                      ; IRC1M Frequency Trim Bit 6
CPMUIRCTRIML_IRCTRIM7: equ    7                                      ; IRC1M Frequency Trim Bit 7
; bit position masks
mCPMUIRCTRIML_IRCTRIM0: equ    %00000001
mCPMUIRCTRIML_IRCTRIM1: equ    %00000010
mCPMUIRCTRIML_IRCTRIM2: equ    %00000100
mCPMUIRCTRIML_IRCTRIM3: equ    %00001000
mCPMUIRCTRIML_IRCTRIM4: equ    %00010000
mCPMUIRCTRIML_IRCTRIM5: equ    %00100000
mCPMUIRCTRIML_IRCTRIM6: equ    %01000000
mCPMUIRCTRIML_IRCTRIM7: equ    %10000000


;*** CPMUOSC - S12CPMU Oscillator Register; 0x000002FA ***
CPMUOSC:            equ    $000002FA                                ;*** CPMUOSC - S12CPMU Oscillator Register; 0x000002FA ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CPMUOSC_OSCFILT0:   equ    0                                         ; Oscillator Filter Bits, bit 0
CPMUOSC_OSCFILT1:   equ    1                                         ; Oscillator Filter Bits, bit 1
CPMUOSC_OSCFILT2:   equ    2                                         ; Oscillator Filter Bits, bit 2
CPMUOSC_OSCFILT3:   equ    3                                         ; Oscillator Filter Bits, bit 3
CPMUOSC_OSCFILT4:   equ    4                                         ; Oscillator Filter Bits, bit 4
CPMUOSC_OSCBW:      equ    6                                         ; Oscillator Filter Bandwidth Bit
CPMUOSC_OSCE:       equ    7                                         ; Oscillator Enable Bit
; bit position masks
mCPMUOSC_OSCFILT0:  equ    %00000001
mCPMUOSC_OSCFILT1:  equ    %00000010
mCPMUOSC_OSCFILT2:  equ    %00000100
mCPMUOSC_OSCFILT3:  equ    %00001000
mCPMUOSC_OSCFILT4:  equ    %00010000
mCPMUOSC_OSCBW:     equ    %01000000
mCPMUOSC_OSCE:      equ    %10000000


;*** CPMUPROT - S12CPMUV1 Protection Register; 0x000002FB ***
CPMUPROT:           equ    $000002FB                                ;*** CPMUPROT - S12CPMUV1 Protection Register; 0x000002FB ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CPMUPROT_PROT:      equ    0                                         ; Clock Configuration Registers Protection Bit
; bit position masks
mCPMUPROT_PROT:     equ    %00000001


;*** BAKEY0 - Backdoor Comparison Key 0; 0x0000FF00 ***
BAKEY0:             equ    $0000FF00                                ;*** BAKEY0 - Backdoor Comparison Key 0; 0x0000FF00 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
BAKEY0_KEY0:        equ    0                                         ; Backdoor Comparison Key Bits, bit 0
BAKEY0_KEY1:        equ    1                                         ; Backdoor Comparison Key Bits, bit 1
BAKEY0_KEY2:        equ    2                                         ; Backdoor Comparison Key Bits, bit 2
BAKEY0_KEY3:        equ    3                                         ; Backdoor Comparison Key Bits, bit 3
BAKEY0_KEY4:        equ    4                                         ; Backdoor Comparison Key Bits, bit 4
BAKEY0_KEY5:        equ    5                                         ; Backdoor Comparison Key Bits, bit 5
BAKEY0_KEY6:        equ    6                                         ; Backdoor Comparison Key Bits, bit 6
BAKEY0_KEY7:        equ    7                                         ; Backdoor Comparison Key Bits, bit 7
BAKEY0_KEY8:        equ    8                                         ; Backdoor Comparison Key Bits, bit 8
BAKEY0_KEY9:        equ    9                                         ; Backdoor Comparison Key Bits, bit 9
BAKEY0_KEY10:       equ    10                                        ; Backdoor Comparison Key Bits, bit 10
BAKEY0_KEY11:       equ    11                                        ; Backdoor Comparison Key Bits, bit 11
BAKEY0_KEY12:       equ    12                                        ; Backdoor Comparison Key Bits, bit 12
BAKEY0_KEY13:       equ    13                                        ; Backdoor Comparison Key Bits, bit 13
BAKEY0_KEY14:       equ    14                                        ; Backdoor Comparison Key Bits, bit 14
BAKEY0_KEY15:       equ    15                                        ; Backdoor Comparison Key Bits, bit 15
; bit position masks
mBAKEY0_KEY0:       equ    %00000001
mBAKEY0_KEY1:       equ    %00000010
mBAKEY0_KEY2:       equ    %00000100
mBAKEY0_KEY3:       equ    %00001000
mBAKEY0_KEY4:       equ    %00010000
mBAKEY0_KEY5:       equ    %00100000
mBAKEY0_KEY6:       equ    %01000000
mBAKEY0_KEY7:       equ    %10000000
mBAKEY0_KEY8:       equ    %100000000
mBAKEY0_KEY9:       equ    %1000000000
mBAKEY0_KEY10:      equ    %10000000000
mBAKEY0_KEY11:      equ    %100000000000
mBAKEY0_KEY12:      equ    %1000000000000
mBAKEY0_KEY13:      equ    %10000000000000
mBAKEY0_KEY14:      equ    %100000000000000
mBAKEY0_KEY15:      equ    %1000000000000000


;*** BAKEY1 - Backdoor Comparison Key 1; 0x0000FF02 ***
BAKEY1:             equ    $0000FF02                                ;*** BAKEY1 - Backdoor Comparison Key 1; 0x0000FF02 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
BAKEY1_KEY0:        equ    0                                         ; Backdoor Comparison Key Bits, bit 0
BAKEY1_KEY1:        equ    1                                         ; Backdoor Comparison Key Bits, bit 1
BAKEY1_KEY2:        equ    2                                         ; Backdoor Comparison Key Bits, bit 2
BAKEY1_KEY3:        equ    3                                         ; Backdoor Comparison Key Bits, bit 3
BAKEY1_KEY4:        equ    4                                         ; Backdoor Comparison Key Bits, bit 4
BAKEY1_KEY5:        equ    5                                         ; Backdoor Comparison Key Bits, bit 5
BAKEY1_KEY6:        equ    6                                         ; Backdoor Comparison Key Bits, bit 6
BAKEY1_KEY7:        equ    7                                         ; Backdoor Comparison Key Bits, bit 7
BAKEY1_KEY8:        equ    8                                         ; Backdoor Comparison Key Bits, bit 8
BAKEY1_KEY9:        equ    9                                         ; Backdoor Comparison Key Bits, bit 9
BAKEY1_KEY10:       equ    10                                        ; Backdoor Comparison Key Bits, bit 10
BAKEY1_KEY11:       equ    11                                        ; Backdoor Comparison Key Bits, bit 11
BAKEY1_KEY12:       equ    12                                        ; Backdoor Comparison Key Bits, bit 12
BAKEY1_KEY13:       equ    13                                        ; Backdoor Comparison Key Bits, bit 13
BAKEY1_KEY14:       equ    14                                        ; Backdoor Comparison Key Bits, bit 14
BAKEY1_KEY15:       equ    15                                        ; Backdoor Comparison Key Bits, bit 15
; bit position masks
mBAKEY1_KEY0:       equ    %00000001
mBAKEY1_KEY1:       equ    %00000010
mBAKEY1_KEY2:       equ    %00000100
mBAKEY1_KEY3:       equ    %00001000
mBAKEY1_KEY4:       equ    %00010000
mBAKEY1_KEY5:       equ    %00100000
mBAKEY1_KEY6:       equ    %01000000
mBAKEY1_KEY7:       equ    %10000000
mBAKEY1_KEY8:       equ    %100000000
mBAKEY1_KEY9:       equ    %1000000000
mBAKEY1_KEY10:      equ    %10000000000
mBAKEY1_KEY11:      equ    %100000000000
mBAKEY1_KEY12:      equ    %1000000000000
mBAKEY1_KEY13:      equ    %10000000000000
mBAKEY1_KEY14:      equ    %100000000000000
mBAKEY1_KEY15:      equ    %1000000000000000


;*** BAKEY2 - Backdoor Comparison Key 2; 0x0000FF04 ***
BAKEY2:             equ    $0000FF04                                ;*** BAKEY2 - Backdoor Comparison Key 2; 0x0000FF04 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
BAKEY2_KEY0:        equ    0                                         ; Backdoor Comparison Key Bits, bit 0
BAKEY2_KEY1:        equ    1                                         ; Backdoor Comparison Key Bits, bit 1
BAKEY2_KEY2:        equ    2                                         ; Backdoor Comparison Key Bits, bit 2
BAKEY2_KEY3:        equ    3                                         ; Backdoor Comparison Key Bits, bit 3
BAKEY2_KEY4:        equ    4                                         ; Backdoor Comparison Key Bits, bit 4
BAKEY2_KEY5:        equ    5                                         ; Backdoor Comparison Key Bits, bit 5
BAKEY2_KEY6:        equ    6                                         ; Backdoor Comparison Key Bits, bit 6
BAKEY2_KEY7:        equ    7                                         ; Backdoor Comparison Key Bits, bit 7
BAKEY2_KEY8:        equ    8                                         ; Backdoor Comparison Key Bits, bit 8
BAKEY2_KEY9:        equ    9                                         ; Backdoor Comparison Key Bits, bit 9
BAKEY2_KEY10:       equ    10                                        ; Backdoor Comparison Key Bits, bit 10
BAKEY2_KEY11:       equ    11                                        ; Backdoor Comparison Key Bits, bit 11
BAKEY2_KEY12:       equ    12                                        ; Backdoor Comparison Key Bits, bit 12
BAKEY2_KEY13:       equ    13                                        ; Backdoor Comparison Key Bits, bit 13
BAKEY2_KEY14:       equ    14                                        ; Backdoor Comparison Key Bits, bit 14
BAKEY2_KEY15:       equ    15                                        ; Backdoor Comparison Key Bits, bit 15
; bit position masks
mBAKEY2_KEY0:       equ    %00000001
mBAKEY2_KEY1:       equ    %00000010
mBAKEY2_KEY2:       equ    %00000100
mBAKEY2_KEY3:       equ    %00001000
mBAKEY2_KEY4:       equ    %00010000
mBAKEY2_KEY5:       equ    %00100000
mBAKEY2_KEY6:       equ    %01000000
mBAKEY2_KEY7:       equ    %10000000
mBAKEY2_KEY8:       equ    %100000000
mBAKEY2_KEY9:       equ    %1000000000
mBAKEY2_KEY10:      equ    %10000000000
mBAKEY2_KEY11:      equ    %100000000000
mBAKEY2_KEY12:      equ    %1000000000000
mBAKEY2_KEY13:      equ    %10000000000000
mBAKEY2_KEY14:      equ    %100000000000000
mBAKEY2_KEY15:      equ    %1000000000000000


;*** BAKEY3 - Backdoor Comparison Key 3; 0x0000FF06 ***
BAKEY3:             equ    $0000FF06                                ;*** BAKEY3 - Backdoor Comparison Key 3; 0x0000FF06 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
BAKEY3_KEY0:        equ    0                                         ; Backdoor Comparison Key Bits, bit 0
BAKEY3_KEY1:        equ    1                                         ; Backdoor Comparison Key Bits, bit 1
BAKEY3_KEY2:        equ    2                                         ; Backdoor Comparison Key Bits, bit 2
BAKEY3_KEY3:        equ    3                                         ; Backdoor Comparison Key Bits, bit 3
BAKEY3_KEY4:        equ    4                                         ; Backdoor Comparison Key Bits, bit 4
BAKEY3_KEY5:        equ    5                                         ; Backdoor Comparison Key Bits, bit 5
BAKEY3_KEY6:        equ    6                                         ; Backdoor Comparison Key Bits, bit 6
BAKEY3_KEY7:        equ    7                                         ; Backdoor Comparison Key Bits, bit 7
BAKEY3_KEY8:        equ    8                                         ; Backdoor Comparison Key Bits, bit 8
BAKEY3_KEY9:        equ    9                                         ; Backdoor Comparison Key Bits, bit 9
BAKEY3_KEY10:       equ    10                                        ; Backdoor Comparison Key Bits, bit 10
BAKEY3_KEY11:       equ    11                                        ; Backdoor Comparison Key Bits, bit 11
BAKEY3_KEY12:       equ    12                                        ; Backdoor Comparison Key Bits, bit 12
BAKEY3_KEY13:       equ    13                                        ; Backdoor Comparison Key Bits, bit 13
BAKEY3_KEY14:       equ    14                                        ; Backdoor Comparison Key Bits, bit 14
BAKEY3_KEY15:       equ    15                                        ; Backdoor Comparison Key Bits, bit 15
; bit position masks
mBAKEY3_KEY0:       equ    %00000001
mBAKEY3_KEY1:       equ    %00000010
mBAKEY3_KEY2:       equ    %00000100
mBAKEY3_KEY3:       equ    %00001000
mBAKEY3_KEY4:       equ    %00010000
mBAKEY3_KEY5:       equ    %00100000
mBAKEY3_KEY6:       equ    %01000000
mBAKEY3_KEY7:       equ    %10000000
mBAKEY3_KEY8:       equ    %100000000
mBAKEY3_KEY9:       equ    %1000000000
mBAKEY3_KEY10:      equ    %10000000000
mBAKEY3_KEY11:      equ    %100000000000
mBAKEY3_KEY12:      equ    %1000000000000
mBAKEY3_KEY13:      equ    %10000000000000
mBAKEY3_KEY14:      equ    %100000000000000
mBAKEY3_KEY15:      equ    %1000000000000000


;*** NVFPROT - Non Volatile P-Flash Protection Register; 0x0000FF0C ***
NVFPROT:            equ    $0000FF0C                                ;*** NVFPROT - Non Volatile P-Flash Protection Register; 0x0000FF0C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NVFPROT_FPLS0:      equ    0                                         ; Flash Protection Lower Address Size Bit 0
NVFPROT_FPLS1:      equ    1                                         ; Flash Protection Lower Address Size Bit 1
NVFPROT_FPLDIS:     equ    2                                         ; Flash Protection Lower Address Range Disable
NVFPROT_FPHS0:      equ    3                                         ; Flash Protection Higher Address Size Bit 0
NVFPROT_FPHS1:      equ    4                                         ; Flash Protection Higher Address Size Bit 1
NVFPROT_FPHDIS:     equ    5                                         ; Flash Protection Higher Address Range Disable
NVFPROT_RNV6:       equ    6                                         ; Reserved Nonvolatile Bit
NVFPROT_FPOPEN:     equ    7                                         ; Flash Protection Operation Enable
; bit position masks
mNVFPROT_FPLS0:     equ    %00000001
mNVFPROT_FPLS1:     equ    %00000010
mNVFPROT_FPLDIS:    equ    %00000100
mNVFPROT_FPHS0:     equ    %00001000
mNVFPROT_FPHS1:     equ    %00010000
mNVFPROT_FPHDIS:    equ    %00100000
mNVFPROT_RNV6:      equ    %01000000
mNVFPROT_FPOPEN:    equ    %10000000


;*** NVDFPROT - Non Volatile D-Flash Protection Register; 0x0000FF0D ***
NVDFPROT:           equ    $0000FF0D                                ;*** NVDFPROT - Non Volatile D-Flash Protection Register; 0x0000FF0D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NVDFPROT_DPS0:      equ    0                                         ; D-Flash Protection Size Bit 0
NVDFPROT_DPS1:      equ    1                                         ; D-Flash Protection Size Bit 1
NVDFPROT_DPS2:      equ    2                                         ; D-Flash Protection Size Bit 2
NVDFPROT_DPS3:      equ    3                                         ; D-Flash Protection Size Bit 3
NVDFPROT_DPOPEN:    equ    7                                         ; D-Flash Protection Control
; bit position masks
mNVDFPROT_DPS0:     equ    %00000001
mNVDFPROT_DPS1:     equ    %00000010
mNVDFPROT_DPS2:     equ    %00000100
mNVDFPROT_DPS3:     equ    %00001000
mNVDFPROT_DPOPEN:   equ    %10000000


;*** NVFOPT - Non Volatile Flash Option Register; 0x0000FF0E ***
NVFOPT:             equ    $0000FF0E                                ;*** NVFOPT - Non Volatile Flash Option Register; 0x0000FF0E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NVFOPT_NV0:         equ    0                                         ; Nonvolatile Bit 0
NVFOPT_NV1:         equ    1                                         ; Nonvolatile Bit 1
NVFOPT_NV2:         equ    2                                         ; Nonvolatile Bit 2
NVFOPT_NV3:         equ    3                                         ; Nonvolatile Bit 3
NVFOPT_NV4:         equ    4                                         ; Nonvolatile Bit 4
NVFOPT_NV5:         equ    5                                         ; Nonvolatile Bit 5
NVFOPT_NV6:         equ    6                                         ; Nonvolatile Bit 6
NVFOPT_NV7:         equ    7                                         ; Nonvolatile Bit 7
; bit position masks
mNVFOPT_NV0:        equ    %00000001
mNVFOPT_NV1:        equ    %00000010
mNVFOPT_NV2:        equ    %00000100
mNVFOPT_NV3:        equ    %00001000
mNVFOPT_NV4:        equ    %00010000
mNVFOPT_NV5:        equ    %00100000
mNVFOPT_NV6:        equ    %01000000
mNVFOPT_NV7:        equ    %10000000


;*** NVFSEC - Non Volatile Flash Security Register; 0x0000FF0F ***
NVFSEC:             equ    $0000FF0F                                ;*** NVFSEC - Non Volatile Flash Security Register; 0x0000FF0F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NVFSEC_SEC0:        equ    0                                         ; Flash Security Bit 0
NVFSEC_SEC1:        equ    1                                         ; Flash Security Bit 1
NVFSEC_RNV2:        equ    2                                         ; Reserved Nonvolatile Bit 2
NVFSEC_RNV3:        equ    3                                         ; Reserved Nonvolatile Bit 3
NVFSEC_RNV4:        equ    4                                         ; Reserved Nonvolatile Bit 4
NVFSEC_RNV5:        equ    5                                         ; Reserved Nonvolatile Bit 5
NVFSEC_KEYEN0:      equ    6                                         ; Backdoor Key Security Enable Bit 0
NVFSEC_KEYEN1:      equ    7                                         ; Backdoor Key Security Enable Bit 1
; bit position masks
mNVFSEC_SEC0:       equ    %00000001
mNVFSEC_SEC1:       equ    %00000010
mNVFSEC_RNV2:       equ    %00000100
mNVFSEC_RNV3:       equ    %00001000
mNVFSEC_RNV4:       equ    %00010000
mNVFSEC_RNV5:       equ    %00100000
mNVFSEC_KEYEN0:     equ    %01000000
mNVFSEC_KEYEN1:     equ    %10000000



;***********************************************
;**   D E P R E C I A T E D   S Y M B O L S   **
;***********************************************
        IFNDEF  __GENERATE_APPLICATION__                            ; not supported for absolute assembler
                    XREF    This_symb_has_been_depreciated
        ENDIF
; ---------------------------------------------------------------------------
; The following symbols were removed, because they were invalid or irrelevant
; ---------------------------------------------------------------------------



; **** 14.4.2010 13:19:27

        IFNDEF __GENERATE_APPLICATION__
NVDFPROT_DPS4:                           equ        This_symb_has_been_depreciated
mNVDFPROT_DPS4:                          equ        This_symb_has_been_depreciated
        ENDIF

; EOF
