/* Based on CPU DB MC9S12HN64_112, version 2.87.454 (RegistersPrg V2.32) */
/*
** ###################################################################
**     Filename  : mc9s12hn64.h
**     Processor : MC9S12HN64CAL
**     FileFormat: V2.32
**     DataSheet : MC9S12HZ256V2 Rev. 2.05 04/2008
**     Compiler  : CodeWarrior compiler
**     Date/Time : 8.6.2010, 8:45
**     Abstract  :
**         This header implements the mapping of I/O devices.
**
**     Copyright : 1997 - 2010 Freescale Semiconductor, Inc. All Rights Reserved.
**     
**     http      : www.freescale.com
**     mail      : support@freescale.com
**
**     CPU Registers Revisions:
**      - 18.07.2006, V2.87.403:
**              - Added register WOMP. REASON: Changes in data sheet (from rev 1.05 to rev 2.01)
**      - 12.09.2006, V2.87.425:
**              - Renamed interrupt vector Vtimpaaovf ==> Vtimpaovf. REASON: Bug-fix (#3741 in Issue Manager)
**      - 13.09.2006, V2.87.427:
**              - Removed bit FCNFG_BKSEL. REASON: Bug-fix (#3757 in Issue Manager)
**      - 20.06.2008, V2.87.441:
**              - Added ADC result registers: ATDDR<8-15>. REASON: Bug-fix (#6291 in Issue Manager).
**      - 29.08.2008, V2.87.446:
**              - Added SSD2, SSD3 module registers.
**              -   REASON: Bug-fix (#6116 in Issue Manager).
**      - 29.06.2009, V2.87.450:
**              - Added MCDCx_FAST registers for PWM operating in 7-bit(fast) resolution mode. REASON: Bug-fix (#3426 in Issue Manager).
**
**     File-Format-Revisions:
**      - 14.11.2005, V2.00 :
**               - Deprecated symbols added for backward compatibility (section at the end of this file)
**      - 15.11.2005, V2.01 :
**               - Fixed invalid instruction in macro __RESET_WATCHDOG for HCS12 family.
**      - 17.12.2005, V2.02 :
**               - Arrays (symbols xx_ARR) are defined as pointer to volatile, see issue #2778
**      - 16.01.2006, V2.03 :
**               - Fixed declaration of non volatile registers. Now it does not require (but allows) their initialization, see issue #2920.
**               - "volatile" modifier removed from declaration of non volatile registers (that contain modifier "const")
**      - 08.03.2006, V2.04 :
**               - Support for bit(s) names duplicated with any register name in .h header files
**      - 24.03.2006, V2.05 :
**               - Fixed macro __RESET_WATCHDOG for HCS12 family - address and correct write order.
**      - 26.04.2006, V2.06 :
**               - Changes have not affected this file (because they are related to another family)
**      - 27.04.2006, V2.07 :
**               - Fixed macro __RESET_WATCHDOG for HCS12, HCS12X ,HCS08 DZ and HCS08 EN derivatives (write 0x55,0xAA).
**      - 07.06.2006, V2.08 :
**               - Changes have not affected this file (because they are related to another family)
**      - 03.07.2006, V2.09 :
**               - Changes have not affected this file (because they are related to another family)
**      - 27.10.2006, V2.10 :
**               - __RESET_WATCHDOG improved formating and re-definition
**      - 23.11.2006, V2.11 :
**               - Changes have not affected this file (because they are related to another family)
**      - 22.01.2007, V2.12 :
**               - Fixed declaration of non volatile registers. Now it does not require (but allows) their initialization, see issue #4086.
**      - 01.03.2007, V2.13 :
**               - Flash commands constants values converted to HEX format
**      - 02.03.2007, V2.14 :
**               - Interrupt vector numbers added into .H, see VectorNumber_*
**      - 26.03.2007, V2.15 :
**               - Changes have not affected this file (because they are related to another family)
**      - 10.05.2007, V2.16 :
**               - Changes have not affected this file (because they are related to another family)
**      - 05.06.2007, V2.17 :
**               - Changes have not affected this file (because they are related to another family)
**      - 19.07.2007, V2.18 :
**               - Improved number of blanked lines inside register structures
**      - 06.08.2007, V2.19 :
**               - CPUDB revisions generated ahead of the file-format revisions.
**      - 11.09.2007, V2.20 :
**               - Added comment about initialization of unbonded pins.
**      - 02.01.2008, V2.21 :
**               - Changes have not affected this file (because they are related to another family)
**      - 13.02.2008, V2.22 :
**               - Changes have not affected this file (because they are related to another family)
**      - 20.02.2008, V2.23 :
**               - Termination of pragma V30toV31Compatible added, #5708
**      - 03.07.2008, V2.24 :
**               - Added support for bits with name starting with number (like "1HZ")
**      - 28.11.2008, V2.25 :
**               - StandBy RAM array declaration for ANSI-C added
**      - 1.12.2008, V2.26 :
**               - Duplication of bit (or bit-group) name with register name is not marked as a problem, is register is internal only and it is not displayed in I/O map.
**      - 17.3.2009, V2.27 :
**               - Merged bit-group is not generated, if the name matches with another bit name in the register
**      - 6.4.2009, V2.28 :
**               - Fixed generation of merged bits for bit-groups with a digit at the end, if group-name is defined in CPUDB
**      - 3.8.2009, V2.29 :
**               - If there is just one bits group matching register name, single bits are not generated
**      - 10.9.2009, V2.30 :
**               - Fixed generation of registers arrays.
**      - 15.10.2009, V2.31 :
**               - Changes have not affected this file (because they are related to another family)
**      - 18.05.2010, V2.32 :
**               - MISRA compliance: U/UL suffixes added to all numbers (_MASK,_BITNUM and addresses)
**
**     Not all general-purpose I/O pins are available on all packages or on all mask sets of a specific
**     derivative device. To avoid extra current drain from floating input pins, the users reset
**     initialization routine in the application program must either enable on-chip pull-up devices
**     or change the direction of unconnected pins to outputs so the pins do not float.
** ###################################################################
*/

#ifndef _MC9S12HN64_H
#define _MC9S12HN64_H

/*lint -save  -e950 -esym(960,18.4) -e46 -esym(961,19.7) Disable MISRA rule (1.1,18.4,6.4,19.7) checking. */
/* Types definition */
typedef unsigned char byte;
typedef unsigned int word;
typedef unsigned long dword;
typedef unsigned long dlong[2];

#define REG_BASE 0x0000                /* Base address for the I/O register block */


#pragma MESSAGE DISABLE C1106 /* WARNING C1106: Non-standard bitfield type */
#pragma OPTION ADD V30toV31Compatible "-BfaGapLimitBits4294967295" /*this guarantee correct bitfield positions*/

/**************** interrupt vector numbers ****************/
#define VectorNumber_VReserved63        63U
#define VectorNumber_VReserved62        62U
#define VectorNumber_VReserved61        61U
#define VectorNumber_VReserved60        60U
#define VectorNumber_VReserved59        59U
#define VectorNumber_Vvreglvi           58U
#define VectorNumber_Vpwmesdn           57U
#define VectorNumber_VReserved56        56U
#define VectorNumber_VReserved55        55U
#define VectorNumber_VReserved54        54U
#define VectorNumber_VReserved53        53U
#define VectorNumber_Vmctimovf          52U
#define VectorNumber_VReserved51        51U
#define VectorNumber_Vssd3              50U
#define VectorNumber_Vssd2              49U
#define VectorNumber_Vssd1              48U
#define VectorNumber_Vssd0              47U
#define VectorNumber_VReserved46        46U
#define VectorNumber_VReserved45        45U
#define VectorNumber_VReserved44        44U
#define VectorNumber_VReserved43        43U
#define VectorNumber_VReserved42        42U
#define VectorNumber_VReserved41        41U
#define VectorNumber_VReserved40        40U
#define VectorNumber_VReserved39        39U
#define VectorNumber_VReserved38        38U
#define VectorNumber_VReserved37        37U
#define VectorNumber_VReserved36        36U
#define VectorNumber_Vflash             35U
#define VectorNumber_Veeprom            34U
#define VectorNumber_VReserved33        33U
#define VectorNumber_VReserved32        32U
#define VectorNumber_VReserved31        31U
#define VectorNumber_VReserved30        30U
#define VectorNumber_Vcrgscm            29U
#define VectorNumber_Vcrgplllck         28U
#define VectorNumber_Vportad            27U
#define VectorNumber_VReserved26        26U
#define VectorNumber_VReserved25        25U
#define VectorNumber_VReserved24        24U
#define VectorNumber_VReserved23        23U
#define VectorNumber_Vatd               22U
#define VectorNumber_VReserved21        21U
#define VectorNumber_Vsci0              20U
#define VectorNumber_Vspi               19U
#define VectorNumber_Vtimpaie           18U
#define VectorNumber_Vtimpaovf          17U
#define VectorNumber_Vtimovf            16U
#define VectorNumber_Vtimch7            15U
#define VectorNumber_Vtimch6            14U
#define VectorNumber_Vtimch5            13U
#define VectorNumber_Vtimch4            12U
#define VectorNumber_Vtimch3            11U
#define VectorNumber_Vtimch2            10U
#define VectorNumber_Vtimch1            9U
#define VectorNumber_Vtimch0            8U
#define VectorNumber_Vrti               7U
#define VectorNumber_VReserved6         6U
#define VectorNumber_Vxirq              5U
#define VectorNumber_Vswi               4U
#define VectorNumber_Vtrap              3U
#define VectorNumber_Vcop               2U
#define VectorNumber_Vclkmon            1U
#define VectorNumber_Vreset             0U

/**************** interrupt vector table ****************/
#define VReserved63                     0xFF80U
#define VReserved62                     0xFF82U
#define VReserved61                     0xFF84U
#define VReserved60                     0xFF86U
#define VReserved59                     0xFF88U
#define Vvreglvi                        0xFF8AU
#define Vpwmesdn                        0xFF8CU
#define VReserved56                     0xFF8EU
#define VReserved55                     0xFF90U
#define VReserved54                     0xFF92U
#define VReserved53                     0xFF94U
#define Vmctimovf                       0xFF96U
#define VReserved51                     0xFF98U
#define Vssd3                           0xFF9AU
#define Vssd2                           0xFF9CU
#define Vssd1                           0xFF9EU
#define Vssd0                           0xFFA0U
#define VReserved46                     0xFFA2U
#define VReserved45                     0xFFA4U
#define VReserved44                     0xFFA6U
#define VReserved43                     0xFFA8U
#define VReserved42                     0xFFAAU
#define VReserved41                     0xFFACU
#define VReserved40                     0xFFAEU
#define VReserved39                     0xFFB0U
#define VReserved38                     0xFFB2U
#define VReserved37                     0xFFB4U
#define VReserved36                     0xFFB6U
#define Vflash                          0xFFB8U
#define Veeprom                         0xFFBAU
#define VReserved33                     0xFFBCU
#define VReserved32                     0xFFBEU
#define VReserved31                     0xFFC0U
#define VReserved30                     0xFFC2U
#define Vcrgscm                         0xFFC4U
#define Vcrgplllck                      0xFFC6U
#define Vportad                         0xFFC8U
#define VReserved26                     0xFFCAU
#define VReserved25                     0xFFCCU
#define VReserved24                     0xFFCEU
#define VReserved23                     0xFFD0U
#define Vatd                            0xFFD2U
#define VReserved21                     0xFFD4U
#define Vsci0                           0xFFD6U
#define Vspi                            0xFFD8U
#define Vtimpaie                        0xFFDAU
#define Vtimpaovf                       0xFFDCU
#define Vtimovf                         0xFFDEU
#define Vtimch7                         0xFFE0U
#define Vtimch6                         0xFFE2U
#define Vtimch5                         0xFFE4U
#define Vtimch4                         0xFFE6U
#define Vtimch3                         0xFFE8U
#define Vtimch2                         0xFFEAU
#define Vtimch1                         0xFFECU
#define Vtimch0                         0xFFEEU
#define Vrti                            0xFFF0U
#define VReserved6                      0xFFF2U
#define Vxirq                           0xFFF4U
#define Vswi                            0xFFF6U
#define Vtrap                           0xFFF8U
#define Vcop                            0xFFFAU
#define Vclkmon                         0xFFFCU
#define Vreset                          0xFFFEU

/**************** registers I/O map ****************/

/*** PORTA - Port A Register; 0x00000000 ***/
typedef union {
  byte Byte;
  struct {
    byte BIT0        :1;                                       /* Port A Bit 0 */
    byte BIT1        :1;                                       /* Port A Bit 1 */
    byte BIT2        :1;                                       /* Port A Bit 2 */
    byte BIT3        :1;                                       /* Port A Bit 3 */
    byte BIT4        :1;                                       /* Port A Bit 4 */
    byte BIT5        :1;                                       /* Port A Bit 5 */
    byte BIT6        :1;                                       /* Port A Bit 6 */
    byte BIT7        :1;                                       /* Port A Bit 7 */
  } Bits;
} PORTASTR;
extern volatile PORTASTR _PORTA @(REG_BASE + 0x00000000UL);
#define PORTA                           _PORTA.Byte
#define PORTA_BIT0                      _PORTA.Bits.BIT0
#define PORTA_BIT1                      _PORTA.Bits.BIT1
#define PORTA_BIT2                      _PORTA.Bits.BIT2
#define PORTA_BIT3                      _PORTA.Bits.BIT3
#define PORTA_BIT4                      _PORTA.Bits.BIT4
#define PORTA_BIT5                      _PORTA.Bits.BIT5
#define PORTA_BIT6                      _PORTA.Bits.BIT6
#define PORTA_BIT7                      _PORTA.Bits.BIT7

#define PORTA_BIT0_MASK                 1U
#define PORTA_BIT1_MASK                 2U
#define PORTA_BIT2_MASK                 4U
#define PORTA_BIT3_MASK                 8U
#define PORTA_BIT4_MASK                 16U
#define PORTA_BIT5_MASK                 32U
#define PORTA_BIT6_MASK                 64U
#define PORTA_BIT7_MASK                 128U


/*** PORTB - Port B Register; 0x00000001 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte BIT4        :1;                                       /* Port B Bit 4 */
    byte BIT5        :1;                                       /* Port B Bit 5 */
    byte BIT6        :1;                                       /* Port B Bit 6 */
    byte BIT7        :1;                                       /* Port B Bit 7 */
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte grpBIT_4 :4;
  } MergedBits;
} PORTBSTR;
extern volatile PORTBSTR _PORTB @(REG_BASE + 0x00000001UL);
#define PORTB                           _PORTB.Byte
#define PORTB_BIT4                      _PORTB.Bits.BIT4
#define PORTB_BIT5                      _PORTB.Bits.BIT5
#define PORTB_BIT6                      _PORTB.Bits.BIT6
#define PORTB_BIT7                      _PORTB.Bits.BIT7
#define PORTB_BIT_4                     _PORTB.MergedBits.grpBIT_4
#define PORTB_BIT                       PORTB_BIT_4

#define PORTB_BIT4_MASK                 16U
#define PORTB_BIT5_MASK                 32U
#define PORTB_BIT6_MASK                 64U
#define PORTB_BIT7_MASK                 128U
#define PORTB_BIT_4_MASK                240U
#define PORTB_BIT_4_BITNUM              4U


/*** DDRA - Port A Data Direction Register; 0x00000002 ***/
typedef union {
  byte Byte;
  struct {
    byte BIT0        :1;                                       /* Data Direction Port A Bit 0 */
    byte BIT1        :1;                                       /* Data Direction Port A Bit 1 */
    byte BIT2        :1;                                       /* Data Direction Port A Bit 2 */
    byte BIT3        :1;                                       /* Data Direction Port A Bit 3 */
    byte BIT4        :1;                                       /* Data Direction Port A Bit 4 */
    byte BIT5        :1;                                       /* Data Direction Port A Bit 5 */
    byte BIT6        :1;                                       /* Data Direction Port A Bit 6 */
    byte BIT7        :1;                                       /* Data Direction Port A Bit 7 */
  } Bits;
} DDRASTR;
extern volatile DDRASTR _DDRA @(REG_BASE + 0x00000002UL);
#define DDRA                            _DDRA.Byte
#define DDRA_BIT0                       _DDRA.Bits.BIT0
#define DDRA_BIT1                       _DDRA.Bits.BIT1
#define DDRA_BIT2                       _DDRA.Bits.BIT2
#define DDRA_BIT3                       _DDRA.Bits.BIT3
#define DDRA_BIT4                       _DDRA.Bits.BIT4
#define DDRA_BIT5                       _DDRA.Bits.BIT5
#define DDRA_BIT6                       _DDRA.Bits.BIT6
#define DDRA_BIT7                       _DDRA.Bits.BIT7

#define DDRA_BIT0_MASK                  1U
#define DDRA_BIT1_MASK                  2U
#define DDRA_BIT2_MASK                  4U
#define DDRA_BIT3_MASK                  8U
#define DDRA_BIT4_MASK                  16U
#define DDRA_BIT5_MASK                  32U
#define DDRA_BIT6_MASK                  64U
#define DDRA_BIT7_MASK                  128U


/*** DDRB - Port B Data Direction Register; 0x00000003 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte BIT4        :1;                                       /* Data Direction Port B Bit 4 */
    byte BIT5        :1;                                       /* Data Direction Port B Bit 5 */
    byte BIT6        :1;                                       /* Data Direction Port B Bit 6 */
    byte BIT7        :1;                                       /* Data Direction Port B Bit 7 */
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte grpBIT_4 :4;
  } MergedBits;
} DDRBSTR;
extern volatile DDRBSTR _DDRB @(REG_BASE + 0x00000003UL);
#define DDRB                            _DDRB.Byte
#define DDRB_BIT4                       _DDRB.Bits.BIT4
#define DDRB_BIT5                       _DDRB.Bits.BIT5
#define DDRB_BIT6                       _DDRB.Bits.BIT6
#define DDRB_BIT7                       _DDRB.Bits.BIT7
#define DDRB_BIT_4                      _DDRB.MergedBits.grpBIT_4
#define DDRB_BIT                        DDRB_BIT_4

#define DDRB_BIT4_MASK                  16U
#define DDRB_BIT5_MASK                  32U
#define DDRB_BIT6_MASK                  64U
#define DDRB_BIT7_MASK                  128U
#define DDRB_BIT_4_MASK                 240U
#define DDRB_BIT_4_BITNUM               4U


/*** PORTE - Port E Register; 0x00000008 ***/
typedef union {
  byte Byte;
  struct {
    byte BIT0        :1;                                       /* Port E Bit 0 */
    byte             :1; 
    byte BIT2        :1;                                       /* Port E Bit 2 */
    byte BIT3        :1;                                       /* Port E Bit 3 */
    byte BIT4        :1;                                       /* Port E Bit 4 */
    byte             :1; 
    byte             :1; 
    byte BIT7        :1;                                       /* Port E Bit 7 */
  } Bits;
  struct {
    byte grpBIT  :1;
    byte         :1;
    byte grpBIT_2 :3;
    byte         :1;
    byte         :1;
    byte grpBIT_7 :1;
  } MergedBits;
} PORTESTR;
extern volatile PORTESTR _PORTE @(REG_BASE + 0x00000008UL);
#define PORTE                           _PORTE.Byte
#define PORTE_BIT0                      _PORTE.Bits.BIT0
#define PORTE_BIT2                      _PORTE.Bits.BIT2
#define PORTE_BIT3                      _PORTE.Bits.BIT3
#define PORTE_BIT4                      _PORTE.Bits.BIT4
#define PORTE_BIT7                      _PORTE.Bits.BIT7
#define PORTE_BIT_2                     _PORTE.MergedBits.grpBIT_2
#define PORTE_BIT                       PORTE_BIT_2

#define PORTE_BIT0_MASK                 1U
#define PORTE_BIT2_MASK                 4U
#define PORTE_BIT3_MASK                 8U
#define PORTE_BIT4_MASK                 16U
#define PORTE_BIT7_MASK                 128U
#define PORTE_BIT_2_MASK                28U
#define PORTE_BIT_2_BITNUM              2U


/*** DDRE - Port E Data Direction Register; 0x00000009 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte BIT2        :1;                                       /* Data Direction Port E Bit 2 */
    byte BIT3        :1;                                       /* Data Direction Port E Bit 3 */
    byte BIT4        :1;                                       /* Data Direction Port E Bit 4 */
    byte             :1; 
    byte             :1; 
    byte BIT7        :1;                                       /* Data Direction Port E Bit 7 */
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte grpBIT_2 :3;
    byte         :1;
    byte         :1;
    byte grpBIT_7 :1;
  } MergedBits;
} DDRESTR;
extern volatile DDRESTR _DDRE @(REG_BASE + 0x00000009UL);
#define DDRE                            _DDRE.Byte
#define DDRE_BIT2                       _DDRE.Bits.BIT2
#define DDRE_BIT3                       _DDRE.Bits.BIT3
#define DDRE_BIT4                       _DDRE.Bits.BIT4
#define DDRE_BIT7                       _DDRE.Bits.BIT7
#define DDRE_BIT_2                      _DDRE.MergedBits.grpBIT_2
#define DDRE_BIT                        DDRE_BIT_2

#define DDRE_BIT2_MASK                  4U
#define DDRE_BIT3_MASK                  8U
#define DDRE_BIT4_MASK                  16U
#define DDRE_BIT7_MASK                  128U
#define DDRE_BIT_2_MASK                 28U
#define DDRE_BIT_2_BITNUM               2U


/*** PEAR - Port E Assignment Register; 0x0000000A ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte RDWE        :1;                                       /* Read / Write Enable */
    byte LSTRE       :1;                                       /* Low Strobe (LSTRB) Enable */
    byte NECLK       :1;                                       /* No External E Clock */
    byte PIPOE       :1;                                       /* Pipe Status Signal Output Enable */
    byte             :1; 
    byte NOACCE      :1;                                       /* CPU No Access Output Enable */
  } Bits;
} PEARSTR;
extern volatile PEARSTR _PEAR @(REG_BASE + 0x0000000AUL);
#define PEAR                            _PEAR.Byte
#define PEAR_RDWE                       _PEAR.Bits.RDWE
#define PEAR_LSTRE                      _PEAR.Bits.LSTRE
#define PEAR_NECLK                      _PEAR.Bits.NECLK
#define PEAR_PIPOE                      _PEAR.Bits.PIPOE
#define PEAR_NOACCE                     _PEAR.Bits.NOACCE

#define PEAR_RDWE_MASK                  4U
#define PEAR_LSTRE_MASK                 8U
#define PEAR_NECLK_MASK                 16U
#define PEAR_PIPOE_MASK                 32U
#define PEAR_NOACCE_MASK                128U


/*** MODE - Mode Register; 0x0000000B ***/
typedef union {
  byte Byte;
  struct {
    byte EME         :1;                                       /* Emulate Port E */
    byte EMK         :1;                                       /* Emulate Port K */
    byte             :1; 
    byte IVIS        :1;                                       /* Internal Visibility */
    byte             :1; 
    byte MODA        :1;                                       /* Mode Select Bit A */
    byte MODB        :1;                                       /* Mode Select Bit B */
    byte MODC        :1;                                       /* Mode Select Bit C */
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte grpMODx :3;
  } MergedBits;
} MODESTR;
extern volatile MODESTR _MODE @(REG_BASE + 0x0000000BUL);
#define MODE                            _MODE.Byte
#define MODE_EME                        _MODE.Bits.EME
#define MODE_EMK                        _MODE.Bits.EMK
#define MODE_IVIS                       _MODE.Bits.IVIS
#define MODE_MODA                       _MODE.Bits.MODA
#define MODE_MODB                       _MODE.Bits.MODB
#define MODE_MODC                       _MODE.Bits.MODC
#define MODE_MODx                       _MODE.MergedBits.grpMODx

#define MODE_EME_MASK                   1U
#define MODE_EMK_MASK                   2U
#define MODE_IVIS_MASK                  8U
#define MODE_MODA_MASK                  32U
#define MODE_MODB_MASK                  64U
#define MODE_MODC_MASK                  128U
#define MODE_MODx_MASK                  224U
#define MODE_MODx_BITNUM                5U


/*** PUCR - Pull-Up Control Register; 0x0000000C ***/
typedef union {
  byte Byte;
  struct {
    byte PUPAE       :1;                                       /* Pull-Up Port A Enable */
    byte PUPBE       :1;                                       /* Pull-Up Port B Enable */
    byte             :1; 
    byte             :1; 
    byte PUPEE       :1;                                       /* Pull-Up Port E Enable */
    byte             :1; 
    byte             :1; 
    byte PUPKE       :1;                                       /* Pull-Up Port K Enable */
  } Bits;
} PUCRSTR;
extern volatile PUCRSTR _PUCR @(REG_BASE + 0x0000000CUL);
#define PUCR                            _PUCR.Byte
#define PUCR_PUPAE                      _PUCR.Bits.PUPAE
#define PUCR_PUPBE                      _PUCR.Bits.PUPBE
#define PUCR_PUPEE                      _PUCR.Bits.PUPEE
#define PUCR_PUPKE                      _PUCR.Bits.PUPKE

#define PUCR_PUPAE_MASK                 1U
#define PUCR_PUPBE_MASK                 2U
#define PUCR_PUPEE_MASK                 16U
#define PUCR_PUPKE_MASK                 128U


/*** RDRIV - Reduced Drive of I/O Lines; 0x0000000D ***/
typedef union {
  byte Byte;
  struct {
    byte RDPA        :1;                                       /* Reduced Drive of Port A */
    byte RDPB        :1;                                       /* Reduced Drive of Port B */
    byte             :1; 
    byte             :1; 
    byte RDPE        :1;                                       /* Reduced Drive of Port E */
    byte             :1; 
    byte             :1; 
    byte RDPK        :1;                                       /* Reduced Drive of Port K */
  } Bits;
  struct {
    byte grpRDPx :2;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} RDRIVSTR;
extern volatile RDRIVSTR _RDRIV @(REG_BASE + 0x0000000DUL);
#define RDRIV                           _RDRIV.Byte
#define RDRIV_RDPA                      _RDRIV.Bits.RDPA
#define RDRIV_RDPB                      _RDRIV.Bits.RDPB
#define RDRIV_RDPE                      _RDRIV.Bits.RDPE
#define RDRIV_RDPK                      _RDRIV.Bits.RDPK
#define RDRIV_RDPx                      _RDRIV.MergedBits.grpRDPx

#define RDRIV_RDPA_MASK                 1U
#define RDRIV_RDPB_MASK                 2U
#define RDRIV_RDPE_MASK                 16U
#define RDRIV_RDPK_MASK                 128U
#define RDRIV_RDPx_MASK                 3U
#define RDRIV_RDPx_BITNUM               0U


/*** EBICTL - External Bus Interface Control; 0x0000000E ***/
typedef union {
  byte Byte;
  struct {
    byte ESTR        :1;                                       /* E Stretches */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} EBICTLSTR;
extern volatile EBICTLSTR _EBICTL @(REG_BASE + 0x0000000EUL);
#define EBICTL                          _EBICTL.Byte
#define EBICTL_ESTR                     _EBICTL.Bits.ESTR

#define EBICTL_ESTR_MASK                1U


/*** INITRM - Initialization of Internal RAM Position Register; 0x00000010 ***/
typedef union {
  byte Byte;
  struct {
    byte RAMHAL      :1;                                       /* Internal RAM map alignment */
    byte             :1; 
    byte             :1; 
    byte RAM11       :1;                                       /* Internal RAM map position Bit 11 */
    byte RAM12       :1;                                       /* Internal RAM map position Bit 12 */
    byte RAM13       :1;                                       /* Internal RAM map position Bit 13 */
    byte RAM14       :1;                                       /* Internal RAM map position Bit 14 */
    byte RAM15       :1;                                       /* Internal RAM map position Bit 15 */
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte         :1;
    byte grpRAM_11 :5;
  } MergedBits;
} INITRMSTR;
extern volatile INITRMSTR _INITRM @(REG_BASE + 0x00000010UL);
#define INITRM                          _INITRM.Byte
#define INITRM_RAMHAL                   _INITRM.Bits.RAMHAL
#define INITRM_RAM11                    _INITRM.Bits.RAM11
#define INITRM_RAM12                    _INITRM.Bits.RAM12
#define INITRM_RAM13                    _INITRM.Bits.RAM13
#define INITRM_RAM14                    _INITRM.Bits.RAM14
#define INITRM_RAM15                    _INITRM.Bits.RAM15
#define INITRM_RAM_11                   _INITRM.MergedBits.grpRAM_11
#define INITRM_RAM                      INITRM_RAM_11

#define INITRM_RAMHAL_MASK              1U
#define INITRM_RAM11_MASK               8U
#define INITRM_RAM12_MASK               16U
#define INITRM_RAM13_MASK               32U
#define INITRM_RAM14_MASK               64U
#define INITRM_RAM15_MASK               128U
#define INITRM_RAM_11_MASK              248U
#define INITRM_RAM_11_BITNUM            3U


/*** INITRG - Initialization of Internal Registers Position Register; 0x00000011 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte REG11       :1;                                       /* Internal Registers Map Position Bit 11 */
    byte REG12       :1;                                       /* Internal Registers Map Position Bit 12 */
    byte REG13       :1;                                       /* Internal Registers Map Position Bit 13 */
    byte REG14       :1;                                       /* Internal Registers Map Position Bit 14 */
    byte             :1; 
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte         :1;
    byte grpREG_11 :4;
    byte         :1;
  } MergedBits;
} INITRGSTR;
extern volatile INITRGSTR _INITRG @(REG_BASE + 0x00000011UL);
#define INITRG                          _INITRG.Byte
#define INITRG_REG11                    _INITRG.Bits.REG11
#define INITRG_REG12                    _INITRG.Bits.REG12
#define INITRG_REG13                    _INITRG.Bits.REG13
#define INITRG_REG14                    _INITRG.Bits.REG14
#define INITRG_REG_11                   _INITRG.MergedBits.grpREG_11
#define INITRG_REG                      INITRG_REG_11

#define INITRG_REG11_MASK               8U
#define INITRG_REG12_MASK               16U
#define INITRG_REG13_MASK               32U
#define INITRG_REG14_MASK               64U
#define INITRG_REG_11_MASK              120U
#define INITRG_REG_11_BITNUM            3U


/*** INITEE - Initialization of Internal EEPROM Position Register; 0x00000012 ***/
typedef union {
  byte Byte;
  struct {
    byte EEON        :1;                                       /* Internal EEPROM On */
    byte             :1; 
    byte             :1; 
    byte EE11        :1;                                       /* Internal EEPROM map position Bit 11 */
    byte EE12        :1;                                       /* Internal EEPROM map position Bit 12 */
    byte EE13        :1;                                       /* Internal EEPROM map position Bit 13 */
    byte EE14        :1;                                       /* Internal EEPROM map position Bit 14 */
    byte EE15        :1;                                       /* Internal EEPROM map position Bit 15 */
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte         :1;
    byte grpEE_11 :5;
  } MergedBits;
} INITEESTR;
extern volatile INITEESTR _INITEE @(REG_BASE + 0x00000012UL);
#define INITEE                          _INITEE.Byte
#define INITEE_EEON                     _INITEE.Bits.EEON
#define INITEE_EE11                     _INITEE.Bits.EE11
#define INITEE_EE12                     _INITEE.Bits.EE12
#define INITEE_EE13                     _INITEE.Bits.EE13
#define INITEE_EE14                     _INITEE.Bits.EE14
#define INITEE_EE15                     _INITEE.Bits.EE15
#define INITEE_EE_11                    _INITEE.MergedBits.grpEE_11
#define INITEE_EE                       INITEE_EE_11

#define INITEE_EEON_MASK                1U
#define INITEE_EE11_MASK                8U
#define INITEE_EE12_MASK                16U
#define INITEE_EE13_MASK                32U
#define INITEE_EE14_MASK                64U
#define INITEE_EE15_MASK                128U
#define INITEE_EE_11_MASK               248U
#define INITEE_EE_11_BITNUM             3U


/*** MISC - Miscellaneous System Control Register; 0x00000013 ***/
typedef union {
  byte Byte;
  struct {
    byte ROMON       :1;                                       /* Enable Flash EEPROM */
    byte ROMHM       :1;                                       /* Flash EEPROM only in second half of memory map */
    byte EXSTR0      :1;                                       /* External Access Stretch Bit 0 */
    byte EXSTR1      :1;                                       /* External Access Stretch Bit 1 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte grpEXSTR :2;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} MISCSTR;
extern volatile MISCSTR _MISC @(REG_BASE + 0x00000013UL);
#define MISC                            _MISC.Byte
#define MISC_ROMON                      _MISC.Bits.ROMON
#define MISC_ROMHM                      _MISC.Bits.ROMHM
#define MISC_EXSTR0                     _MISC.Bits.EXSTR0
#define MISC_EXSTR1                     _MISC.Bits.EXSTR1
#define MISC_EXSTR                      _MISC.MergedBits.grpEXSTR

#define MISC_ROMON_MASK                 1U
#define MISC_ROMHM_MASK                 2U
#define MISC_EXSTR0_MASK                4U
#define MISC_EXSTR1_MASK                8U
#define MISC_EXSTR_MASK                 12U
#define MISC_EXSTR_BITNUM               2U


/*** ITCR - Interrupt Test Control Register; 0x00000015 ***/
typedef union {
  byte Byte;
  struct {
    byte ADR0        :1;                                       /* Test register select Bit 0 */
    byte ADR1        :1;                                       /* Test register select Bit 1 */
    byte ADR2        :1;                                       /* Test register select Bit 2 */
    byte ADR3        :1;                                       /* Test register select Bit 3 */
    byte WRTINT      :1;                                       /* Write to the Interrupt Test Registers */
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpADR  :4;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} ITCRSTR;
extern volatile ITCRSTR _ITCR @(REG_BASE + 0x00000015UL);
#define ITCR                            _ITCR.Byte
#define ITCR_ADR0                       _ITCR.Bits.ADR0
#define ITCR_ADR1                       _ITCR.Bits.ADR1
#define ITCR_ADR2                       _ITCR.Bits.ADR2
#define ITCR_ADR3                       _ITCR.Bits.ADR3
#define ITCR_WRTINT                     _ITCR.Bits.WRTINT
#define ITCR_ADR                        _ITCR.MergedBits.grpADR

#define ITCR_ADR0_MASK                  1U
#define ITCR_ADR1_MASK                  2U
#define ITCR_ADR2_MASK                  4U
#define ITCR_ADR3_MASK                  8U
#define ITCR_WRTINT_MASK                16U
#define ITCR_ADR_MASK                   15U
#define ITCR_ADR_BITNUM                 0U


/*** ITEST - Interrupt Test Register; 0x00000016 ***/
typedef union {
  byte Byte;
  struct {
    byte INT0        :1;                                       /* Interrupt Test Register Bit 0 */
    byte INT2        :1;                                       /* Interrupt Test Register Bit 1 */
    byte INT4        :1;                                       /* Interrupt Test Register Bit 2 */
    byte INT6        :1;                                       /* Interrupt Test Register Bit 3 */
    byte INT8        :1;                                       /* Interrupt Test Register Bit 4 */
    byte INTA        :1;                                       /* Interrupt Test Register Bit 5 */
    byte INTC        :1;                                       /* Interrupt Test Register Bit 6 */
    byte INTE        :1;                                       /* Interrupt Test Register Bit 7 */
  } Bits;
} ITESTSTR;
extern volatile ITESTSTR _ITEST @(REG_BASE + 0x00000016UL);
#define ITEST                           _ITEST.Byte
#define ITEST_INT0                      _ITEST.Bits.INT0
#define ITEST_INT2                      _ITEST.Bits.INT2
#define ITEST_INT4                      _ITEST.Bits.INT4
#define ITEST_INT6                      _ITEST.Bits.INT6
#define ITEST_INT8                      _ITEST.Bits.INT8
#define ITEST_INTA                      _ITEST.Bits.INTA
#define ITEST_INTC                      _ITEST.Bits.INTC
#define ITEST_INTE                      _ITEST.Bits.INTE

#define ITEST_INT0_MASK                 1U
#define ITEST_INT2_MASK                 2U
#define ITEST_INT4_MASK                 4U
#define ITEST_INT6_MASK                 8U
#define ITEST_INT8_MASK                 16U
#define ITEST_INTA_MASK                 32U
#define ITEST_INTC_MASK                 64U
#define ITEST_INTE_MASK                 128U


/*** VREGCTRL - VREG_3V3 - Control Register; 0x00000019 ***/
typedef union {
  byte Byte;
  struct {
    byte LVIF        :1;                                       /* Low Voltage Interrupt Flag */
    byte LVIE        :1;                                       /* Low Voltage Interrupt Enable Bit */
    byte LVDS        :1;                                       /* Low Voltage Detect Status Bit */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} VREGCTRLSTR;
extern volatile VREGCTRLSTR _VREGCTRL @(REG_BASE + 0x00000019UL);
#define VREGCTRL                        _VREGCTRL.Byte
#define VREGCTRL_LVIF                   _VREGCTRL.Bits.LVIF
#define VREGCTRL_LVIE                   _VREGCTRL.Bits.LVIE
#define VREGCTRL_LVDS                   _VREGCTRL.Bits.LVDS

#define VREGCTRL_LVIF_MASK              1U
#define VREGCTRL_LVIE_MASK              2U
#define VREGCTRL_LVDS_MASK              4U


/*** PARTID - Part ID Register; 0x0000001A ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** PARTIDH - Part ID Register High; 0x0000001A ***/
    union {
      byte Byte;
      struct {
        byte ID8         :1;                                       /* Part ID Register Bit 8 */
        byte ID9         :1;                                       /* Part ID Register Bit 9 */
        byte ID10        :1;                                       /* Part ID Register Bit 10 */
        byte ID11        :1;                                       /* Part ID Register Bit 11 */
        byte ID12        :1;                                       /* Part ID Register Bit 12 */
        byte ID13        :1;                                       /* Part ID Register Bit 13 */
        byte ID14        :1;                                       /* Part ID Register Bit 14 */
        byte ID15        :1;                                       /* Part ID Register Bit 15 */
      } Bits;
    } PARTIDHSTR;
    #define PARTIDH                     _PARTID.Overlap_STR.PARTIDHSTR.Byte
    #define PARTIDH_ID8                 _PARTID.Overlap_STR.PARTIDHSTR.Bits.ID8
    #define PARTIDH_ID9                 _PARTID.Overlap_STR.PARTIDHSTR.Bits.ID9
    #define PARTIDH_ID10                _PARTID.Overlap_STR.PARTIDHSTR.Bits.ID10
    #define PARTIDH_ID11                _PARTID.Overlap_STR.PARTIDHSTR.Bits.ID11
    #define PARTIDH_ID12                _PARTID.Overlap_STR.PARTIDHSTR.Bits.ID12
    #define PARTIDH_ID13                _PARTID.Overlap_STR.PARTIDHSTR.Bits.ID13
    #define PARTIDH_ID14                _PARTID.Overlap_STR.PARTIDHSTR.Bits.ID14
    #define PARTIDH_ID15                _PARTID.Overlap_STR.PARTIDHSTR.Bits.ID15
    
    #define PARTIDH_ID8_MASK            1U
    #define PARTIDH_ID9_MASK            2U
    #define PARTIDH_ID10_MASK           4U
    #define PARTIDH_ID11_MASK           8U
    #define PARTIDH_ID12_MASK           16U
    #define PARTIDH_ID13_MASK           32U
    #define PARTIDH_ID14_MASK           64U
    #define PARTIDH_ID15_MASK           128U
    

    /*** PARTIDL - Part ID Register Low; 0x0000001B ***/
    union {
      byte Byte;
      struct {
        byte ID0         :1;                                       /* Part ID Register Bit 0 */
        byte ID1         :1;                                       /* Part ID Register Bit 1 */
        byte ID2         :1;                                       /* Part ID Register Bit 2 */
        byte ID3         :1;                                       /* Part ID Register Bit 3 */
        byte ID4         :1;                                       /* Part ID Register Bit 4 */
        byte ID5         :1;                                       /* Part ID Register Bit 5 */
        byte ID6         :1;                                       /* Part ID Register Bit 6 */
        byte ID7         :1;                                       /* Part ID Register Bit 7 */
      } Bits;
    } PARTIDLSTR;
    #define PARTIDL                     _PARTID.Overlap_STR.PARTIDLSTR.Byte
    #define PARTIDL_ID0                 _PARTID.Overlap_STR.PARTIDLSTR.Bits.ID0
    #define PARTIDL_ID1                 _PARTID.Overlap_STR.PARTIDLSTR.Bits.ID1
    #define PARTIDL_ID2                 _PARTID.Overlap_STR.PARTIDLSTR.Bits.ID2
    #define PARTIDL_ID3                 _PARTID.Overlap_STR.PARTIDLSTR.Bits.ID3
    #define PARTIDL_ID4                 _PARTID.Overlap_STR.PARTIDLSTR.Bits.ID4
    #define PARTIDL_ID5                 _PARTID.Overlap_STR.PARTIDLSTR.Bits.ID5
    #define PARTIDL_ID6                 _PARTID.Overlap_STR.PARTIDLSTR.Bits.ID6
    #define PARTIDL_ID7                 _PARTID.Overlap_STR.PARTIDLSTR.Bits.ID7
    
    #define PARTIDL_ID0_MASK            1U
    #define PARTIDL_ID1_MASK            2U
    #define PARTIDL_ID2_MASK            4U
    #define PARTIDL_ID3_MASK            8U
    #define PARTIDL_ID4_MASK            16U
    #define PARTIDL_ID5_MASK            32U
    #define PARTIDL_ID6_MASK            64U
    #define PARTIDL_ID7_MASK            128U
    
  } Overlap_STR;

  struct {
    word ID0         :1;                                       /* Part ID Register Bit 0 */
    word ID1         :1;                                       /* Part ID Register Bit 1 */
    word ID2         :1;                                       /* Part ID Register Bit 2 */
    word ID3         :1;                                       /* Part ID Register Bit 3 */
    word ID4         :1;                                       /* Part ID Register Bit 4 */
    word ID5         :1;                                       /* Part ID Register Bit 5 */
    word ID6         :1;                                       /* Part ID Register Bit 6 */
    word ID7         :1;                                       /* Part ID Register Bit 7 */
    word ID8         :1;                                       /* Part ID Register Bit 8 */
    word ID9         :1;                                       /* Part ID Register Bit 9 */
    word ID10        :1;                                       /* Part ID Register Bit 10 */
    word ID11        :1;                                       /* Part ID Register Bit 11 */
    word ID12        :1;                                       /* Part ID Register Bit 12 */
    word ID13        :1;                                       /* Part ID Register Bit 13 */
    word ID14        :1;                                       /* Part ID Register Bit 14 */
    word ID15        :1;                                       /* Part ID Register Bit 15 */
  } Bits;
} PARTIDSTR;
extern volatile PARTIDSTR _PARTID @(REG_BASE + 0x0000001AUL);
#define PARTID                          _PARTID.Word
#define PARTID_ID0                      _PARTID.Bits.ID0
#define PARTID_ID1                      _PARTID.Bits.ID1
#define PARTID_ID2                      _PARTID.Bits.ID2
#define PARTID_ID3                      _PARTID.Bits.ID3
#define PARTID_ID4                      _PARTID.Bits.ID4
#define PARTID_ID5                      _PARTID.Bits.ID5
#define PARTID_ID6                      _PARTID.Bits.ID6
#define PARTID_ID7                      _PARTID.Bits.ID7
#define PARTID_ID8                      _PARTID.Bits.ID8
#define PARTID_ID9                      _PARTID.Bits.ID9
#define PARTID_ID10                     _PARTID.Bits.ID10
#define PARTID_ID11                     _PARTID.Bits.ID11
#define PARTID_ID12                     _PARTID.Bits.ID12
#define PARTID_ID13                     _PARTID.Bits.ID13
#define PARTID_ID14                     _PARTID.Bits.ID14
#define PARTID_ID15                     _PARTID.Bits.ID15

#define PARTID_ID0_MASK                 1U
#define PARTID_ID1_MASK                 2U
#define PARTID_ID2_MASK                 4U
#define PARTID_ID3_MASK                 8U
#define PARTID_ID4_MASK                 16U
#define PARTID_ID5_MASK                 32U
#define PARTID_ID6_MASK                 64U
#define PARTID_ID7_MASK                 128U
#define PARTID_ID8_MASK                 256U
#define PARTID_ID9_MASK                 512U
#define PARTID_ID10_MASK                1024U
#define PARTID_ID11_MASK                2048U
#define PARTID_ID12_MASK                4096U
#define PARTID_ID13_MASK                8192U
#define PARTID_ID14_MASK                16384U
#define PARTID_ID15_MASK                32768U


/*** MEMSIZ0 - Memory Size Register Zero; 0x0000001C ***/
typedef union {
  byte Byte;
  struct {
    byte ram_sw0     :1;                                       /* Allocated System RAM Memory Space Bit 0 */
    byte ram_sw1     :1;                                       /* Allocated System RAM Memory Space Bit 1 */
    byte ram_sw2     :1;                                       /* Allocated System RAM Memory Space Bit 2 */
    byte             :1; 
    byte eep_sw0     :1;                                       /* Allocated EEPROM Memory Space Bit 0 */
    byte eep_sw1     :1;                                       /* Allocated EEPROM Memory Space Bit 1 */
    byte             :1; 
    byte reg_sw0     :1;                                       /* Allocated System Register Space */
  } Bits;
  struct {
    byte grpram_sw :3;
    byte         :1;
    byte grpeep_sw :2;
    byte         :1;
    byte grpreg_sw :1;
  } MergedBits;
} MEMSIZ0STR;
extern volatile MEMSIZ0STR _MEMSIZ0 @(REG_BASE + 0x0000001CUL);
#define MEMSIZ0                         _MEMSIZ0.Byte
#define MEMSIZ0_ram_sw0                 _MEMSIZ0.Bits.ram_sw0
#define MEMSIZ0_ram_sw1                 _MEMSIZ0.Bits.ram_sw1
#define MEMSIZ0_ram_sw2                 _MEMSIZ0.Bits.ram_sw2
#define MEMSIZ0_eep_sw0                 _MEMSIZ0.Bits.eep_sw0
#define MEMSIZ0_eep_sw1                 _MEMSIZ0.Bits.eep_sw1
#define MEMSIZ0_reg_sw0                 _MEMSIZ0.Bits.reg_sw0
/* MEMSIZ_ARR: Access 2 MEMSIZx registers in an array */
#define MEMSIZ_ARR                      ((volatile byte *) &MEMSIZ0)
#define MEMSIZ0_ram_sw                  _MEMSIZ0.MergedBits.grpram_sw
#define MEMSIZ0_eep_sw                  _MEMSIZ0.MergedBits.grpeep_sw

#define MEMSIZ0_ram_sw0_MASK            1U
#define MEMSIZ0_ram_sw1_MASK            2U
#define MEMSIZ0_ram_sw2_MASK            4U
#define MEMSIZ0_eep_sw0_MASK            16U
#define MEMSIZ0_eep_sw1_MASK            32U
#define MEMSIZ0_reg_sw0_MASK            128U
#define MEMSIZ0_ram_sw_MASK             7U
#define MEMSIZ0_ram_sw_BITNUM           0U
#define MEMSIZ0_eep_sw_MASK             48U
#define MEMSIZ0_eep_sw_BITNUM           4U


/*** MEMSIZ1 - Memory Size Register One; 0x0000001D ***/
typedef union {
  byte Byte;
  struct {
    byte pag_sw0     :1;                                       /* Allocated Off-Chip Memory Options Bit 0 */
    byte pag_sw1     :1;                                       /* Allocated Off-Chip Memory Options Bit 1 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte rom_sw0     :1;                                       /* Allocated Flash EEPROM/ROM Physical Memory Space Bit 0 */
    byte rom_sw1     :1;                                       /* Allocated Flash EEPROM/ROM Physical Memory Space Bit 1 */
  } Bits;
  struct {
    byte grppag_sw :2;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte grprom_sw :2;
  } MergedBits;
} MEMSIZ1STR;
extern volatile MEMSIZ1STR _MEMSIZ1 @(REG_BASE + 0x0000001DUL);
#define MEMSIZ1                         _MEMSIZ1.Byte
#define MEMSIZ1_pag_sw0                 _MEMSIZ1.Bits.pag_sw0
#define MEMSIZ1_pag_sw1                 _MEMSIZ1.Bits.pag_sw1
#define MEMSIZ1_rom_sw0                 _MEMSIZ1.Bits.rom_sw0
#define MEMSIZ1_rom_sw1                 _MEMSIZ1.Bits.rom_sw1
#define MEMSIZ1_pag_sw                  _MEMSIZ1.MergedBits.grppag_sw
#define MEMSIZ1_rom_sw                  _MEMSIZ1.MergedBits.grprom_sw

#define MEMSIZ1_pag_sw0_MASK            1U
#define MEMSIZ1_pag_sw1_MASK            2U
#define MEMSIZ1_rom_sw0_MASK            64U
#define MEMSIZ1_rom_sw1_MASK            128U
#define MEMSIZ1_pag_sw_MASK             3U
#define MEMSIZ1_pag_sw_BITNUM           0U
#define MEMSIZ1_rom_sw_MASK             192U
#define MEMSIZ1_rom_sw_BITNUM           6U


/*** INTCR - Interrupt Control Register; 0x0000001E ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte IRQEN       :1;                                       /* External IRQ Enable */
    byte IRQE        :1;                                       /* IRQ Select Edge Sensitive Only */
  } Bits;
} INTCRSTR;
extern volatile INTCRSTR _INTCR @(REG_BASE + 0x0000001EUL);
#define INTCR                           _INTCR.Byte
#define INTCR_IRQEN                     _INTCR.Bits.IRQEN
#define INTCR_IRQE                      _INTCR.Bits.IRQE

#define INTCR_IRQEN_MASK                64U
#define INTCR_IRQE_MASK                 128U


/*** HPRIO - Highest Priority I Interrupt; 0x0000001F ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte PSEL1       :1;                                       /* Highest Priority I Interrupt Bit 1 */
    byte PSEL2       :1;                                       /* Highest Priority I Interrupt Bit 2 */
    byte PSEL3       :1;                                       /* Highest Priority I Interrupt Bit 3 */
    byte PSEL4       :1;                                       /* Highest Priority I Interrupt Bit 4 */
    byte PSEL5       :1;                                       /* Highest Priority I Interrupt Bit 5 */
    byte PSEL6       :1;                                       /* Highest Priority I Interrupt Bit 6 */
    byte PSEL7       :1;                                       /* Highest Priority I Interrupt Bit 7 */
  } Bits;
  struct {
    byte         :1;
    byte grpPSEL_1 :7;
  } MergedBits;
} HPRIOSTR;
extern volatile HPRIOSTR _HPRIO @(REG_BASE + 0x0000001FUL);
#define HPRIO                           _HPRIO.Byte
#define HPRIO_PSEL1                     _HPRIO.Bits.PSEL1
#define HPRIO_PSEL2                     _HPRIO.Bits.PSEL2
#define HPRIO_PSEL3                     _HPRIO.Bits.PSEL3
#define HPRIO_PSEL4                     _HPRIO.Bits.PSEL4
#define HPRIO_PSEL5                     _HPRIO.Bits.PSEL5
#define HPRIO_PSEL6                     _HPRIO.Bits.PSEL6
#define HPRIO_PSEL7                     _HPRIO.Bits.PSEL7
#define HPRIO_PSEL_1                    _HPRIO.MergedBits.grpPSEL_1
#define HPRIO_PSEL                      HPRIO_PSEL_1

#define HPRIO_PSEL1_MASK                2U
#define HPRIO_PSEL2_MASK                4U
#define HPRIO_PSEL3_MASK                8U
#define HPRIO_PSEL4_MASK                16U
#define HPRIO_PSEL5_MASK                32U
#define HPRIO_PSEL6_MASK                64U
#define HPRIO_PSEL7_MASK                128U
#define HPRIO_PSEL_1_MASK               254U
#define HPRIO_PSEL_1_BITNUM             1U


/*** DBGC1 - Debug Control Register 1; 0x00000020 ***/
typedef union {
  byte Byte;
  struct {
    byte CAPMOD0     :1;                                       /* Capture Mode Field, bit 0 */
    byte CAPMOD1     :1;                                       /* Capture Mode Field, bit 1 */
    byte             :1; 
    byte DBGBRK      :1;                                       /* DBG Breakpoint Enable Bit */
    byte BEGIN       :1;                                       /* Begin/End Trigger Bit */
    byte TRGSEL      :1;                                       /* Trigger Selection Bit */
    byte ARM         :1;                                       /* Arm Bit */
    byte DBGEN       :1;                                       /* DBG Mode Enable Bit */
  } Bits;
  struct {
    byte grpCAPMOD :2;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} DBGC1STR;
extern volatile DBGC1STR _DBGC1 @(REG_BASE + 0x00000020UL);
#define DBGC1                           _DBGC1.Byte
#define DBGC1_CAPMOD0                   _DBGC1.Bits.CAPMOD0
#define DBGC1_CAPMOD1                   _DBGC1.Bits.CAPMOD1
#define DBGC1_DBGBRK                    _DBGC1.Bits.DBGBRK
#define DBGC1_BEGIN                     _DBGC1.Bits.BEGIN
#define DBGC1_TRGSEL                    _DBGC1.Bits.TRGSEL
#define DBGC1_ARM                       _DBGC1.Bits.ARM
#define DBGC1_DBGEN                     _DBGC1.Bits.DBGEN
#define DBGC1_CAPMOD                    _DBGC1.MergedBits.grpCAPMOD

#define DBGC1_CAPMOD0_MASK              1U
#define DBGC1_CAPMOD1_MASK              2U
#define DBGC1_DBGBRK_MASK               8U
#define DBGC1_BEGIN_MASK                16U
#define DBGC1_TRGSEL_MASK               32U
#define DBGC1_ARM_MASK                  64U
#define DBGC1_DBGEN_MASK                128U
#define DBGC1_CAPMOD_MASK               3U
#define DBGC1_CAPMOD_BITNUM             0U


/*** DBGSC - Debug Status and Control Register; 0x00000021 ***/
typedef union {
  byte Byte;
  struct {
    byte TRG0        :1;                                       /* Trigger Mode Bits, bit 0 */
    byte TRG1        :1;                                       /* Trigger Mode Bits, bit 1 */
    byte TRG2        :1;                                       /* Trigger Mode Bits, bit 2 */
    byte TRG3        :1;                                       /* Trigger Mode Bits, bit 3 */
    byte             :1; 
    byte CF          :1;                                       /* Comparator C Match Flag */
    byte BF          :1;                                       /* Trigger B Match Flag */
    byte AF          :1;                                       /* Trigger A Match Flag */
  } Bits;
  struct {
    byte grpTRG  :4;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} DBGSCSTR;
extern volatile DBGSCSTR _DBGSC @(REG_BASE + 0x00000021UL);
#define DBGSC                           _DBGSC.Byte
#define DBGSC_TRG0                      _DBGSC.Bits.TRG0
#define DBGSC_TRG1                      _DBGSC.Bits.TRG1
#define DBGSC_TRG2                      _DBGSC.Bits.TRG2
#define DBGSC_TRG3                      _DBGSC.Bits.TRG3
#define DBGSC_CF                        _DBGSC.Bits.CF
#define DBGSC_BF                        _DBGSC.Bits.BF
#define DBGSC_AF                        _DBGSC.Bits.AF
#define DBGSC_TRG                       _DBGSC.MergedBits.grpTRG

#define DBGSC_TRG0_MASK                 1U
#define DBGSC_TRG1_MASK                 2U
#define DBGSC_TRG2_MASK                 4U
#define DBGSC_TRG3_MASK                 8U
#define DBGSC_CF_MASK                   32U
#define DBGSC_BF_MASK                   64U
#define DBGSC_AF_MASK                   128U
#define DBGSC_TRG_MASK                  15U
#define DBGSC_TRG_BITNUM                0U


/*** DBGTB - Debug Trace Buffer Register; 0x00000022 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** DBGTBH - Debug Trace Buffer Register High; 0x00000022 ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Trace Buffer Data Bit 8 */
        byte BIT9        :1;                                       /* Trace Buffer Data Bit 9 */
        byte BIT10       :1;                                       /* Trace Buffer Data Bit 10 */
        byte BIT11       :1;                                       /* Trace Buffer Data Bit 11 */
        byte BIT12       :1;                                       /* Trace Buffer Data Bit 12 */
        byte BIT13       :1;                                       /* Trace Buffer Data Bit 13 */
        byte BIT14       :1;                                       /* Trace Buffer Data Bit 14 */
        byte BIT15       :1;                                       /* Trace Buffer Data Bit 15 */
      } Bits;
    } DBGTBHSTR;
    #define DBGTBH                      _DBGTB.Overlap_STR.DBGTBHSTR.Byte
    #define DBGTBH_BIT8                 _DBGTB.Overlap_STR.DBGTBHSTR.Bits.BIT8
    #define DBGTBH_BIT9                 _DBGTB.Overlap_STR.DBGTBHSTR.Bits.BIT9
    #define DBGTBH_BIT10                _DBGTB.Overlap_STR.DBGTBHSTR.Bits.BIT10
    #define DBGTBH_BIT11                _DBGTB.Overlap_STR.DBGTBHSTR.Bits.BIT11
    #define DBGTBH_BIT12                _DBGTB.Overlap_STR.DBGTBHSTR.Bits.BIT12
    #define DBGTBH_BIT13                _DBGTB.Overlap_STR.DBGTBHSTR.Bits.BIT13
    #define DBGTBH_BIT14                _DBGTB.Overlap_STR.DBGTBHSTR.Bits.BIT14
    #define DBGTBH_BIT15                _DBGTB.Overlap_STR.DBGTBHSTR.Bits.BIT15
    
    #define DBGTBH_BIT8_MASK            1U
    #define DBGTBH_BIT9_MASK            2U
    #define DBGTBH_BIT10_MASK           4U
    #define DBGTBH_BIT11_MASK           8U
    #define DBGTBH_BIT12_MASK           16U
    #define DBGTBH_BIT13_MASK           32U
    #define DBGTBH_BIT14_MASK           64U
    #define DBGTBH_BIT15_MASK           128U
    

    /*** DBGTBL - Debug Trace Buffer Register Low; 0x00000023 ***/
    union {
      byte Byte;
      struct {
        byte BIT0        :1;                                       /* Trace Buffer Data Bit 0 */
        byte BIT1        :1;                                       /* Trace Buffer Data Bit 1 */
        byte BIT2        :1;                                       /* Trace Buffer Data Bit 2 */
        byte BIT3        :1;                                       /* Trace Buffer Data Bit 3 */
        byte BIT4        :1;                                       /* Trace Buffer Data Bit 4 */
        byte BIT5        :1;                                       /* Trace Buffer Data Bit 5 */
        byte BIT6        :1;                                       /* Trace Buffer Data Bit 6 */
        byte BIT7        :1;                                       /* Trace Buffer Data Bit 7 */
      } Bits;
    } DBGTBLSTR;
    #define DBGTBL                      _DBGTB.Overlap_STR.DBGTBLSTR.Byte
    #define DBGTBL_BIT0                 _DBGTB.Overlap_STR.DBGTBLSTR.Bits.BIT0
    #define DBGTBL_BIT1                 _DBGTB.Overlap_STR.DBGTBLSTR.Bits.BIT1
    #define DBGTBL_BIT2                 _DBGTB.Overlap_STR.DBGTBLSTR.Bits.BIT2
    #define DBGTBL_BIT3                 _DBGTB.Overlap_STR.DBGTBLSTR.Bits.BIT3
    #define DBGTBL_BIT4                 _DBGTB.Overlap_STR.DBGTBLSTR.Bits.BIT4
    #define DBGTBL_BIT5                 _DBGTB.Overlap_STR.DBGTBLSTR.Bits.BIT5
    #define DBGTBL_BIT6                 _DBGTB.Overlap_STR.DBGTBLSTR.Bits.BIT6
    #define DBGTBL_BIT7                 _DBGTB.Overlap_STR.DBGTBLSTR.Bits.BIT7
    
    #define DBGTBL_BIT0_MASK            1U
    #define DBGTBL_BIT1_MASK            2U
    #define DBGTBL_BIT2_MASK            4U
    #define DBGTBL_BIT3_MASK            8U
    #define DBGTBL_BIT4_MASK            16U
    #define DBGTBL_BIT5_MASK            32U
    #define DBGTBL_BIT6_MASK            64U
    #define DBGTBL_BIT7_MASK            128U
    
  } Overlap_STR;

  struct {
    word BIT0        :1;                                       /* Trace Buffer Data Bit 0 */
    word BIT1        :1;                                       /* Trace Buffer Data Bit 1 */
    word BIT2        :1;                                       /* Trace Buffer Data Bit 2 */
    word BIT3        :1;                                       /* Trace Buffer Data Bit 3 */
    word BIT4        :1;                                       /* Trace Buffer Data Bit 4 */
    word BIT5        :1;                                       /* Trace Buffer Data Bit 5 */
    word BIT6        :1;                                       /* Trace Buffer Data Bit 6 */
    word BIT7        :1;                                       /* Trace Buffer Data Bit 7 */
    word BIT8        :1;                                       /* Trace Buffer Data Bit 8 */
    word BIT9        :1;                                       /* Trace Buffer Data Bit 9 */
    word BIT10       :1;                                       /* Trace Buffer Data Bit 10 */
    word BIT11       :1;                                       /* Trace Buffer Data Bit 11 */
    word BIT12       :1;                                       /* Trace Buffer Data Bit 12 */
    word BIT13       :1;                                       /* Trace Buffer Data Bit 13 */
    word BIT14       :1;                                       /* Trace Buffer Data Bit 14 */
    word BIT15       :1;                                       /* Trace Buffer Data Bit 15 */
  } Bits;
} DBGTBSTR;
extern volatile DBGTBSTR _DBGTB @(REG_BASE + 0x00000022UL);
#define DBGTB                           _DBGTB.Word
#define DBGTB_BIT0                      _DBGTB.Bits.BIT0
#define DBGTB_BIT1                      _DBGTB.Bits.BIT1
#define DBGTB_BIT2                      _DBGTB.Bits.BIT2
#define DBGTB_BIT3                      _DBGTB.Bits.BIT3
#define DBGTB_BIT4                      _DBGTB.Bits.BIT4
#define DBGTB_BIT5                      _DBGTB.Bits.BIT5
#define DBGTB_BIT6                      _DBGTB.Bits.BIT6
#define DBGTB_BIT7                      _DBGTB.Bits.BIT7
#define DBGTB_BIT8                      _DBGTB.Bits.BIT8
#define DBGTB_BIT9                      _DBGTB.Bits.BIT9
#define DBGTB_BIT10                     _DBGTB.Bits.BIT10
#define DBGTB_BIT11                     _DBGTB.Bits.BIT11
#define DBGTB_BIT12                     _DBGTB.Bits.BIT12
#define DBGTB_BIT13                     _DBGTB.Bits.BIT13
#define DBGTB_BIT14                     _DBGTB.Bits.BIT14
#define DBGTB_BIT15                     _DBGTB.Bits.BIT15

#define DBGTB_BIT0_MASK                 1U
#define DBGTB_BIT1_MASK                 2U
#define DBGTB_BIT2_MASK                 4U
#define DBGTB_BIT3_MASK                 8U
#define DBGTB_BIT4_MASK                 16U
#define DBGTB_BIT5_MASK                 32U
#define DBGTB_BIT6_MASK                 64U
#define DBGTB_BIT7_MASK                 128U
#define DBGTB_BIT8_MASK                 256U
#define DBGTB_BIT9_MASK                 512U
#define DBGTB_BIT10_MASK                1024U
#define DBGTB_BIT11_MASK                2048U
#define DBGTB_BIT12_MASK                4096U
#define DBGTB_BIT13_MASK                8192U
#define DBGTB_BIT14_MASK                16384U
#define DBGTB_BIT15_MASK                32768U


/*** DBGCNT - Debug Count Register; 0x00000024 ***/
typedef union {
  byte Byte;
  struct {
    byte CNT0        :1;                                       /* Count Value, bit 0 */
    byte CNT1        :1;                                       /* Count Value, bit 1 */
    byte CNT2        :1;                                       /* Count Value, bit 2 */
    byte CNT3        :1;                                       /* Count Value, bit 3 */
    byte CNT4        :1;                                       /* Count Value, bit 4 */
    byte CNT5        :1;                                       /* Count Value, bit 5 */
    byte             :1; 
    byte TBF         :1;                                       /* Trace Buffer Full */
  } Bits;
  struct {
    byte grpCNT  :6;
    byte         :1;
    byte         :1;
  } MergedBits;
} DBGCNTSTR;
extern volatile DBGCNTSTR _DBGCNT @(REG_BASE + 0x00000024UL);
#define DBGCNT                          _DBGCNT.Byte
#define DBGCNT_CNT0                     _DBGCNT.Bits.CNT0
#define DBGCNT_CNT1                     _DBGCNT.Bits.CNT1
#define DBGCNT_CNT2                     _DBGCNT.Bits.CNT2
#define DBGCNT_CNT3                     _DBGCNT.Bits.CNT3
#define DBGCNT_CNT4                     _DBGCNT.Bits.CNT4
#define DBGCNT_CNT5                     _DBGCNT.Bits.CNT5
#define DBGCNT_TBF                      _DBGCNT.Bits.TBF
#define DBGCNT_CNT                      _DBGCNT.MergedBits.grpCNT

#define DBGCNT_CNT0_MASK                1U
#define DBGCNT_CNT1_MASK                2U
#define DBGCNT_CNT2_MASK                4U
#define DBGCNT_CNT3_MASK                8U
#define DBGCNT_CNT4_MASK                16U
#define DBGCNT_CNT5_MASK                32U
#define DBGCNT_TBF_MASK                 128U
#define DBGCNT_CNT_MASK                 63U
#define DBGCNT_CNT_BITNUM               0U


/*** DBGCCX - Debug Comparator C Extended Register; 0x00000025 ***/
typedef union {
  byte Byte;
  struct {
    byte EXTCMP0     :1;                                       /* Comparator C Extended Compare Bits, bit 0 */
    byte EXTCMP1     :1;                                       /* Comparator C Extended Compare Bits, bit 1 */
    byte EXTCMP2     :1;                                       /* Comparator C Extended Compare Bits, bit 2 */
    byte EXTCMP3     :1;                                       /* Comparator C Extended Compare Bits, bit 3 */
    byte EXTCMP4     :1;                                       /* Comparator C Extended Compare Bits, bit 4 */
    byte EXTCMP5     :1;                                       /* Comparator C Extended Compare Bits, bit 5 */
    byte PAGSEL0     :1;                                       /* Page Selector Field, bit 0 */
    byte PAGSEL1     :1;                                       /* Page Selector Field, bit 1 */
  } Bits;
  struct {
    byte grpEXTCMP :6;
    byte grpPAGSEL :2;
  } MergedBits;
} DBGCCXSTR;
extern volatile DBGCCXSTR _DBGCCX @(REG_BASE + 0x00000025UL);
#define DBGCCX                          _DBGCCX.Byte
#define DBGCCX_EXTCMP0                  _DBGCCX.Bits.EXTCMP0
#define DBGCCX_EXTCMP1                  _DBGCCX.Bits.EXTCMP1
#define DBGCCX_EXTCMP2                  _DBGCCX.Bits.EXTCMP2
#define DBGCCX_EXTCMP3                  _DBGCCX.Bits.EXTCMP3
#define DBGCCX_EXTCMP4                  _DBGCCX.Bits.EXTCMP4
#define DBGCCX_EXTCMP5                  _DBGCCX.Bits.EXTCMP5
#define DBGCCX_PAGSEL0                  _DBGCCX.Bits.PAGSEL0
#define DBGCCX_PAGSEL1                  _DBGCCX.Bits.PAGSEL1
#define DBGCCX_EXTCMP                   _DBGCCX.MergedBits.grpEXTCMP
#define DBGCCX_PAGSEL                   _DBGCCX.MergedBits.grpPAGSEL

#define DBGCCX_EXTCMP0_MASK             1U
#define DBGCCX_EXTCMP1_MASK             2U
#define DBGCCX_EXTCMP2_MASK             4U
#define DBGCCX_EXTCMP3_MASK             8U
#define DBGCCX_EXTCMP4_MASK             16U
#define DBGCCX_EXTCMP5_MASK             32U
#define DBGCCX_PAGSEL0_MASK             64U
#define DBGCCX_PAGSEL1_MASK             128U
#define DBGCCX_EXTCMP_MASK              63U
#define DBGCCX_EXTCMP_BITNUM            0U
#define DBGCCX_PAGSEL_MASK              192U
#define DBGCCX_PAGSEL_BITNUM            6U


/*** DBGCC - Debug Comparator C Register; 0x00000026 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** DBGCCH - Debug Comparator C Register High; 0x00000026 ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Comparator C Compare Bit 8 */
        byte BIT9        :1;                                       /* Comparator C Compare Bit 9 */
        byte BIT10       :1;                                       /* Comparator C Compare Bit 10 */
        byte BIT11       :1;                                       /* Comparator C Compare Bit 11 */
        byte BIT12       :1;                                       /* Comparator C Compare Bit 12 */
        byte BIT13       :1;                                       /* Comparator C Compare Bit 13 */
        byte BIT14       :1;                                       /* Comparator C Compare Bit 14 */
        byte BIT15       :1;                                       /* Comparator C Compare Bit 15 */
      } Bits;
    } DBGCCHSTR;
    #define DBGCCH                      _DBGCC.Overlap_STR.DBGCCHSTR.Byte
    #define DBGCCH_BIT8                 _DBGCC.Overlap_STR.DBGCCHSTR.Bits.BIT8
    #define DBGCCH_BIT9                 _DBGCC.Overlap_STR.DBGCCHSTR.Bits.BIT9
    #define DBGCCH_BIT10                _DBGCC.Overlap_STR.DBGCCHSTR.Bits.BIT10
    #define DBGCCH_BIT11                _DBGCC.Overlap_STR.DBGCCHSTR.Bits.BIT11
    #define DBGCCH_BIT12                _DBGCC.Overlap_STR.DBGCCHSTR.Bits.BIT12
    #define DBGCCH_BIT13                _DBGCC.Overlap_STR.DBGCCHSTR.Bits.BIT13
    #define DBGCCH_BIT14                _DBGCC.Overlap_STR.DBGCCHSTR.Bits.BIT14
    #define DBGCCH_BIT15                _DBGCC.Overlap_STR.DBGCCHSTR.Bits.BIT15
    
    #define DBGCCH_BIT8_MASK            1U
    #define DBGCCH_BIT9_MASK            2U
    #define DBGCCH_BIT10_MASK           4U
    #define DBGCCH_BIT11_MASK           8U
    #define DBGCCH_BIT12_MASK           16U
    #define DBGCCH_BIT13_MASK           32U
    #define DBGCCH_BIT14_MASK           64U
    #define DBGCCH_BIT15_MASK           128U
    

    /*** DBGCCL - Debug Comparator C Register Low; 0x00000027 ***/
    union {
      byte Byte;
      struct {
        byte BIT0        :1;                                       /* Comparator C Compare Bit 0 */
        byte BIT1        :1;                                       /* Comparator C Compare Bit 1 */
        byte BIT2        :1;                                       /* Comparator C Compare Bit 2 */
        byte BIT3        :1;                                       /* Comparator C Compare Bit 3 */
        byte BIT4        :1;                                       /* Comparator C Compare Bit 4 */
        byte BIT5        :1;                                       /* Comparator C Compare Bit 5 */
        byte BIT6        :1;                                       /* Comparator C Compare Bit 6 */
        byte BIT7        :1;                                       /* Comparator C Compare Bit 7 */
      } Bits;
    } DBGCCLSTR;
    #define DBGCCL                      _DBGCC.Overlap_STR.DBGCCLSTR.Byte
    #define DBGCCL_BIT0                 _DBGCC.Overlap_STR.DBGCCLSTR.Bits.BIT0
    #define DBGCCL_BIT1                 _DBGCC.Overlap_STR.DBGCCLSTR.Bits.BIT1
    #define DBGCCL_BIT2                 _DBGCC.Overlap_STR.DBGCCLSTR.Bits.BIT2
    #define DBGCCL_BIT3                 _DBGCC.Overlap_STR.DBGCCLSTR.Bits.BIT3
    #define DBGCCL_BIT4                 _DBGCC.Overlap_STR.DBGCCLSTR.Bits.BIT4
    #define DBGCCL_BIT5                 _DBGCC.Overlap_STR.DBGCCLSTR.Bits.BIT5
    #define DBGCCL_BIT6                 _DBGCC.Overlap_STR.DBGCCLSTR.Bits.BIT6
    #define DBGCCL_BIT7                 _DBGCC.Overlap_STR.DBGCCLSTR.Bits.BIT7
    
    #define DBGCCL_BIT0_MASK            1U
    #define DBGCCL_BIT1_MASK            2U
    #define DBGCCL_BIT2_MASK            4U
    #define DBGCCL_BIT3_MASK            8U
    #define DBGCCL_BIT4_MASK            16U
    #define DBGCCL_BIT5_MASK            32U
    #define DBGCCL_BIT6_MASK            64U
    #define DBGCCL_BIT7_MASK            128U
    
  } Overlap_STR;

  struct {
    word BIT0        :1;                                       /* Comparator C Compare Bit 0 */
    word BIT1        :1;                                       /* Comparator C Compare Bit 1 */
    word BIT2        :1;                                       /* Comparator C Compare Bit 2 */
    word BIT3        :1;                                       /* Comparator C Compare Bit 3 */
    word BIT4        :1;                                       /* Comparator C Compare Bit 4 */
    word BIT5        :1;                                       /* Comparator C Compare Bit 5 */
    word BIT6        :1;                                       /* Comparator C Compare Bit 6 */
    word BIT7        :1;                                       /* Comparator C Compare Bit 7 */
    word BIT8        :1;                                       /* Comparator C Compare Bit 8 */
    word BIT9        :1;                                       /* Comparator C Compare Bit 9 */
    word BIT10       :1;                                       /* Comparator C Compare Bit 10 */
    word BIT11       :1;                                       /* Comparator C Compare Bit 11 */
    word BIT12       :1;                                       /* Comparator C Compare Bit 12 */
    word BIT13       :1;                                       /* Comparator C Compare Bit 13 */
    word BIT14       :1;                                       /* Comparator C Compare Bit 14 */
    word BIT15       :1;                                       /* Comparator C Compare Bit 15 */
  } Bits;
} DBGCCSTR;
extern volatile DBGCCSTR _DBGCC @(REG_BASE + 0x00000026UL);
#define DBGCC                           _DBGCC.Word
#define DBGCC_BIT0                      _DBGCC.Bits.BIT0
#define DBGCC_BIT1                      _DBGCC.Bits.BIT1
#define DBGCC_BIT2                      _DBGCC.Bits.BIT2
#define DBGCC_BIT3                      _DBGCC.Bits.BIT3
#define DBGCC_BIT4                      _DBGCC.Bits.BIT4
#define DBGCC_BIT5                      _DBGCC.Bits.BIT5
#define DBGCC_BIT6                      _DBGCC.Bits.BIT6
#define DBGCC_BIT7                      _DBGCC.Bits.BIT7
#define DBGCC_BIT8                      _DBGCC.Bits.BIT8
#define DBGCC_BIT9                      _DBGCC.Bits.BIT9
#define DBGCC_BIT10                     _DBGCC.Bits.BIT10
#define DBGCC_BIT11                     _DBGCC.Bits.BIT11
#define DBGCC_BIT12                     _DBGCC.Bits.BIT12
#define DBGCC_BIT13                     _DBGCC.Bits.BIT13
#define DBGCC_BIT14                     _DBGCC.Bits.BIT14
#define DBGCC_BIT15                     _DBGCC.Bits.BIT15

#define DBGCC_BIT0_MASK                 1U
#define DBGCC_BIT1_MASK                 2U
#define DBGCC_BIT2_MASK                 4U
#define DBGCC_BIT3_MASK                 8U
#define DBGCC_BIT4_MASK                 16U
#define DBGCC_BIT5_MASK                 32U
#define DBGCC_BIT6_MASK                 64U
#define DBGCC_BIT7_MASK                 128U
#define DBGCC_BIT8_MASK                 256U
#define DBGCC_BIT9_MASK                 512U
#define DBGCC_BIT10_MASK                1024U
#define DBGCC_BIT11_MASK                2048U
#define DBGCC_BIT12_MASK                4096U
#define DBGCC_BIT13_MASK                8192U
#define DBGCC_BIT14_MASK                16384U
#define DBGCC_BIT15_MASK                32768U


/*** DBGC2 - Debug Control Register 2; 0x00000028 ***/
typedef union {
  byte Byte;
  struct {
    byte RWC         :1;                                       /* Read/Write Comparator C Value Bit */
    byte RWCEN       :1;                                       /* Read/Write Comparator C Enable Bit */
    byte TAGC        :1;                                       /* Comparator C Tag Select */
    byte BKCEN       :1;                                       /* Breakpoint Comparator C Enable Bit */
    byte TAGAB       :1;                                       /* Comparator A/B Tag Select */
    byte BDM         :1;                                       /* Background Debug Mode Enable */
    byte FULL        :1;                                       /* Full Breakpoint Mode Enable */
    byte BKABEN      :1;                                       /* Breakpoint Using Comparator A and B Enable */
  } Bits;
} DBGC2STR;
extern volatile DBGC2STR _DBGC2 @(REG_BASE + 0x00000028UL);
#define DBGC2                           _DBGC2.Byte
#define DBGC2_RWC                       _DBGC2.Bits.RWC
#define DBGC2_RWCEN                     _DBGC2.Bits.RWCEN
#define DBGC2_TAGC                      _DBGC2.Bits.TAGC
#define DBGC2_BKCEN                     _DBGC2.Bits.BKCEN
#define DBGC2_TAGAB                     _DBGC2.Bits.TAGAB
#define DBGC2_BDM                       _DBGC2.Bits.BDM
#define DBGC2_FULL                      _DBGC2.Bits.FULL
#define DBGC2_BKABEN                    _DBGC2.Bits.BKABEN

#define DBGC2_RWC_MASK                  1U
#define DBGC2_RWCEN_MASK                2U
#define DBGC2_TAGC_MASK                 4U
#define DBGC2_BKCEN_MASK                8U
#define DBGC2_TAGAB_MASK                16U
#define DBGC2_BDM_MASK                  32U
#define DBGC2_FULL_MASK                 64U
#define DBGC2_BKABEN_MASK               128U


/*** DBGC3 - Debug Control Register 3; 0x00000029 ***/
typedef union {
  byte Byte;
  struct {
    byte RWB         :1;                                       /* Read/Write Comparator B Value Bit */
    byte RWBEN       :1;                                       /* Read/Write Comparator B Enable Bit */
    byte RWA         :1;                                       /* Read/Write Comparator A Value Bit */
    byte RWAEN       :1;                                       /* Read/Write Comparator A Enable Bit */
    byte BKBMBL      :1;                                       /* Breakpoint Mask Low Byte for Second Address */
    byte BKBMBH      :1;                                       /* Breakpoint Mask High Byte for Second Address */
    byte BKAMBL      :1;                                       /* Breakpoint Mask Low Byte for First Address */
    byte BKAMBH      :1;                                       /* Breakpoint Mask High Byte for First Address */
  } Bits;
} DBGC3STR;
extern volatile DBGC3STR _DBGC3 @(REG_BASE + 0x00000029UL);
#define DBGC3                           _DBGC3.Byte
#define DBGC3_RWB                       _DBGC3.Bits.RWB
#define DBGC3_RWBEN                     _DBGC3.Bits.RWBEN
#define DBGC3_RWA                       _DBGC3.Bits.RWA
#define DBGC3_RWAEN                     _DBGC3.Bits.RWAEN
#define DBGC3_BKBMBL                    _DBGC3.Bits.BKBMBL
#define DBGC3_BKBMBH                    _DBGC3.Bits.BKBMBH
#define DBGC3_BKAMBL                    _DBGC3.Bits.BKAMBL
#define DBGC3_BKAMBH                    _DBGC3.Bits.BKAMBH

#define DBGC3_RWB_MASK                  1U
#define DBGC3_RWBEN_MASK                2U
#define DBGC3_RWA_MASK                  4U
#define DBGC3_RWAEN_MASK                8U
#define DBGC3_BKBMBL_MASK               16U
#define DBGC3_BKBMBH_MASK               32U
#define DBGC3_BKAMBL_MASK               64U
#define DBGC3_BKAMBH_MASK               128U


/*** DBGCAX - Debug Comparator A Extended Register; 0x0000002A ***/
typedef union {
  byte Byte;
  struct {
    byte EXTCMP0     :1;                                       /* Comparator A Extended Compare Bits, bit 0 */
    byte EXTCMP1     :1;                                       /* Comparator A Extended Compare Bits, bit 1 */
    byte EXTCMP2     :1;                                       /* Comparator A Extended Compare Bits, bit 2 */
    byte EXTCMP3     :1;                                       /* Comparator A Extended Compare Bits, bit 3 */
    byte EXTCMP4     :1;                                       /* Comparator A Extended Compare Bits, bit 4 */
    byte EXTCMP5     :1;                                       /* Comparator A Extended Compare Bits, bit 5 */
    byte PAGSEL0     :1;                                       /* Page Selector Field, bit 0 */
    byte PAGSEL1     :1;                                       /* Page Selector Field, bit 1 */
  } Bits;
  struct {
    byte grpEXTCMP :6;
    byte grpPAGSEL :2;
  } MergedBits;
} DBGCAXSTR;
extern volatile DBGCAXSTR _DBGCAX @(REG_BASE + 0x0000002AUL);
#define DBGCAX                          _DBGCAX.Byte
#define DBGCAX_EXTCMP0                  _DBGCAX.Bits.EXTCMP0
#define DBGCAX_EXTCMP1                  _DBGCAX.Bits.EXTCMP1
#define DBGCAX_EXTCMP2                  _DBGCAX.Bits.EXTCMP2
#define DBGCAX_EXTCMP3                  _DBGCAX.Bits.EXTCMP3
#define DBGCAX_EXTCMP4                  _DBGCAX.Bits.EXTCMP4
#define DBGCAX_EXTCMP5                  _DBGCAX.Bits.EXTCMP5
#define DBGCAX_PAGSEL0                  _DBGCAX.Bits.PAGSEL0
#define DBGCAX_PAGSEL1                  _DBGCAX.Bits.PAGSEL1
#define DBGCAX_EXTCMP                   _DBGCAX.MergedBits.grpEXTCMP
#define DBGCAX_PAGSEL                   _DBGCAX.MergedBits.grpPAGSEL

#define DBGCAX_EXTCMP0_MASK             1U
#define DBGCAX_EXTCMP1_MASK             2U
#define DBGCAX_EXTCMP2_MASK             4U
#define DBGCAX_EXTCMP3_MASK             8U
#define DBGCAX_EXTCMP4_MASK             16U
#define DBGCAX_EXTCMP5_MASK             32U
#define DBGCAX_PAGSEL0_MASK             64U
#define DBGCAX_PAGSEL1_MASK             128U
#define DBGCAX_EXTCMP_MASK              63U
#define DBGCAX_EXTCMP_BITNUM            0U
#define DBGCAX_PAGSEL_MASK              192U
#define DBGCAX_PAGSEL_BITNUM            6U


/*** DBGCA - Debug Comparator A Register; 0x0000002B ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** DBGCAH - Debug Comparator A Register High; 0x0000002B ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Comparator A Compare Bit 8 */
        byte BIT9        :1;                                       /* Comparator A Compare Bit 9 */
        byte BIT10       :1;                                       /* Comparator A Compare Bit 10 */
        byte BIT11       :1;                                       /* Comparator A Compare Bit 11 */
        byte BIT12       :1;                                       /* Comparator A Compare Bit 12 */
        byte BIT13       :1;                                       /* Comparator A Compare Bit 13 */
        byte BIT14       :1;                                       /* Comparator A Compare Bit 14 */
        byte BIT15       :1;                                       /* Comparator A Compare Bit 15 */
      } Bits;
    } DBGCAHSTR;
    #define DBGCAH                      _DBGCA.Overlap_STR.DBGCAHSTR.Byte
    #define DBGCAH_BIT8                 _DBGCA.Overlap_STR.DBGCAHSTR.Bits.BIT8
    #define DBGCAH_BIT9                 _DBGCA.Overlap_STR.DBGCAHSTR.Bits.BIT9
    #define DBGCAH_BIT10                _DBGCA.Overlap_STR.DBGCAHSTR.Bits.BIT10
    #define DBGCAH_BIT11                _DBGCA.Overlap_STR.DBGCAHSTR.Bits.BIT11
    #define DBGCAH_BIT12                _DBGCA.Overlap_STR.DBGCAHSTR.Bits.BIT12
    #define DBGCAH_BIT13                _DBGCA.Overlap_STR.DBGCAHSTR.Bits.BIT13
    #define DBGCAH_BIT14                _DBGCA.Overlap_STR.DBGCAHSTR.Bits.BIT14
    #define DBGCAH_BIT15                _DBGCA.Overlap_STR.DBGCAHSTR.Bits.BIT15
    
    #define DBGCAH_BIT8_MASK            1U
    #define DBGCAH_BIT9_MASK            2U
    #define DBGCAH_BIT10_MASK           4U
    #define DBGCAH_BIT11_MASK           8U
    #define DBGCAH_BIT12_MASK           16U
    #define DBGCAH_BIT13_MASK           32U
    #define DBGCAH_BIT14_MASK           64U
    #define DBGCAH_BIT15_MASK           128U
    

    /*** DBGCAL - Debug Comparator A Register Low; 0x0000002C ***/
    union {
      byte Byte;
      struct {
        byte BIT0        :1;                                       /* Comparator A Compare Bit 0 */
        byte BIT1        :1;                                       /* Comparator A Compare Bit 1 */
        byte BIT2        :1;                                       /* Comparator A Compare Bit 2 */
        byte BIT3        :1;                                       /* Comparator A Compare Bit 3 */
        byte BIT4        :1;                                       /* Comparator A Compare Bit 4 */
        byte BIT5        :1;                                       /* Comparator A Compare Bit 5 */
        byte BIT6        :1;                                       /* Comparator A Compare Bit 6 */
        byte BIT7        :1;                                       /* Comparator A Compare Bit 7 */
      } Bits;
    } DBGCALSTR;
    #define DBGCAL                      _DBGCA.Overlap_STR.DBGCALSTR.Byte
    #define DBGCAL_BIT0                 _DBGCA.Overlap_STR.DBGCALSTR.Bits.BIT0
    #define DBGCAL_BIT1                 _DBGCA.Overlap_STR.DBGCALSTR.Bits.BIT1
    #define DBGCAL_BIT2                 _DBGCA.Overlap_STR.DBGCALSTR.Bits.BIT2
    #define DBGCAL_BIT3                 _DBGCA.Overlap_STR.DBGCALSTR.Bits.BIT3
    #define DBGCAL_BIT4                 _DBGCA.Overlap_STR.DBGCALSTR.Bits.BIT4
    #define DBGCAL_BIT5                 _DBGCA.Overlap_STR.DBGCALSTR.Bits.BIT5
    #define DBGCAL_BIT6                 _DBGCA.Overlap_STR.DBGCALSTR.Bits.BIT6
    #define DBGCAL_BIT7                 _DBGCA.Overlap_STR.DBGCALSTR.Bits.BIT7
    
    #define DBGCAL_BIT0_MASK            1U
    #define DBGCAL_BIT1_MASK            2U
    #define DBGCAL_BIT2_MASK            4U
    #define DBGCAL_BIT3_MASK            8U
    #define DBGCAL_BIT4_MASK            16U
    #define DBGCAL_BIT5_MASK            32U
    #define DBGCAL_BIT6_MASK            64U
    #define DBGCAL_BIT7_MASK            128U
    
  } Overlap_STR;

  struct {
    word BIT0        :1;                                       /* Comparator A Compare Bit 0 */
    word BIT1        :1;                                       /* Comparator A Compare Bit 1 */
    word BIT2        :1;                                       /* Comparator A Compare Bit 2 */
    word BIT3        :1;                                       /* Comparator A Compare Bit 3 */
    word BIT4        :1;                                       /* Comparator A Compare Bit 4 */
    word BIT5        :1;                                       /* Comparator A Compare Bit 5 */
    word BIT6        :1;                                       /* Comparator A Compare Bit 6 */
    word BIT7        :1;                                       /* Comparator A Compare Bit 7 */
    word BIT8        :1;                                       /* Comparator A Compare Bit 8 */
    word BIT9        :1;                                       /* Comparator A Compare Bit 9 */
    word BIT10       :1;                                       /* Comparator A Compare Bit 10 */
    word BIT11       :1;                                       /* Comparator A Compare Bit 11 */
    word BIT12       :1;                                       /* Comparator A Compare Bit 12 */
    word BIT13       :1;                                       /* Comparator A Compare Bit 13 */
    word BIT14       :1;                                       /* Comparator A Compare Bit 14 */
    word BIT15       :1;                                       /* Comparator A Compare Bit 15 */
  } Bits;
} DBGCASTR;
extern volatile DBGCASTR _DBGCA @(REG_BASE + 0x0000002BUL);
#define DBGCA                           _DBGCA.Word
#define DBGCA_BIT0                      _DBGCA.Bits.BIT0
#define DBGCA_BIT1                      _DBGCA.Bits.BIT1
#define DBGCA_BIT2                      _DBGCA.Bits.BIT2
#define DBGCA_BIT3                      _DBGCA.Bits.BIT3
#define DBGCA_BIT4                      _DBGCA.Bits.BIT4
#define DBGCA_BIT5                      _DBGCA.Bits.BIT5
#define DBGCA_BIT6                      _DBGCA.Bits.BIT6
#define DBGCA_BIT7                      _DBGCA.Bits.BIT7
#define DBGCA_BIT8                      _DBGCA.Bits.BIT8
#define DBGCA_BIT9                      _DBGCA.Bits.BIT9
#define DBGCA_BIT10                     _DBGCA.Bits.BIT10
#define DBGCA_BIT11                     _DBGCA.Bits.BIT11
#define DBGCA_BIT12                     _DBGCA.Bits.BIT12
#define DBGCA_BIT13                     _DBGCA.Bits.BIT13
#define DBGCA_BIT14                     _DBGCA.Bits.BIT14
#define DBGCA_BIT15                     _DBGCA.Bits.BIT15

#define DBGCA_BIT0_MASK                 1U
#define DBGCA_BIT1_MASK                 2U
#define DBGCA_BIT2_MASK                 4U
#define DBGCA_BIT3_MASK                 8U
#define DBGCA_BIT4_MASK                 16U
#define DBGCA_BIT5_MASK                 32U
#define DBGCA_BIT6_MASK                 64U
#define DBGCA_BIT7_MASK                 128U
#define DBGCA_BIT8_MASK                 256U
#define DBGCA_BIT9_MASK                 512U
#define DBGCA_BIT10_MASK                1024U
#define DBGCA_BIT11_MASK                2048U
#define DBGCA_BIT12_MASK                4096U
#define DBGCA_BIT13_MASK                8192U
#define DBGCA_BIT14_MASK                16384U
#define DBGCA_BIT15_MASK                32768U


/*** DBGCBX - Debug Comparator B Extended Register; 0x0000002D ***/
typedef union {
  byte Byte;
  struct {
    byte EXTCMP0     :1;                                       /* Comparator B Extended Compare Bits, bit 0 */
    byte EXTCMP1     :1;                                       /* Comparator B Extended Compare Bits, bit 1 */
    byte EXTCMP2     :1;                                       /* Comparator B Extended Compare Bits, bit 2 */
    byte EXTCMP3     :1;                                       /* Comparator B Extended Compare Bits, bit 3 */
    byte EXTCMP4     :1;                                       /* Comparator B Extended Compare Bits, bit 4 */
    byte EXTCMP5     :1;                                       /* Comparator B Extended Compare Bits, bit 5 */
    byte PAGSEL0     :1;                                       /* Page Selector Field, bit 0 */
    byte PAGSEL1     :1;                                       /* Page Selector Field, bit 1 */
  } Bits;
  struct {
    byte grpEXTCMP :6;
    byte grpPAGSEL :2;
  } MergedBits;
} DBGCBXSTR;
extern volatile DBGCBXSTR _DBGCBX @(REG_BASE + 0x0000002DUL);
#define DBGCBX                          _DBGCBX.Byte
#define DBGCBX_EXTCMP0                  _DBGCBX.Bits.EXTCMP0
#define DBGCBX_EXTCMP1                  _DBGCBX.Bits.EXTCMP1
#define DBGCBX_EXTCMP2                  _DBGCBX.Bits.EXTCMP2
#define DBGCBX_EXTCMP3                  _DBGCBX.Bits.EXTCMP3
#define DBGCBX_EXTCMP4                  _DBGCBX.Bits.EXTCMP4
#define DBGCBX_EXTCMP5                  _DBGCBX.Bits.EXTCMP5
#define DBGCBX_PAGSEL0                  _DBGCBX.Bits.PAGSEL0
#define DBGCBX_PAGSEL1                  _DBGCBX.Bits.PAGSEL1
#define DBGCBX_EXTCMP                   _DBGCBX.MergedBits.grpEXTCMP
#define DBGCBX_PAGSEL                   _DBGCBX.MergedBits.grpPAGSEL

#define DBGCBX_EXTCMP0_MASK             1U
#define DBGCBX_EXTCMP1_MASK             2U
#define DBGCBX_EXTCMP2_MASK             4U
#define DBGCBX_EXTCMP3_MASK             8U
#define DBGCBX_EXTCMP4_MASK             16U
#define DBGCBX_EXTCMP5_MASK             32U
#define DBGCBX_PAGSEL0_MASK             64U
#define DBGCBX_PAGSEL1_MASK             128U
#define DBGCBX_EXTCMP_MASK              63U
#define DBGCBX_EXTCMP_BITNUM            0U
#define DBGCBX_PAGSEL_MASK              192U
#define DBGCBX_PAGSEL_BITNUM            6U


/*** DBGCB - Debug Comparator B Register; 0x0000002E ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** DBGCBH - Debug Comparator B Register High; 0x0000002E ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Comparator B High Compare Bit 8 */
        byte BIT9        :1;                                       /* Comparator B High Compare Bit 9 */
        byte BIT10       :1;                                       /* Comparator B High Compare Bit 10 */
        byte BIT11       :1;                                       /* Comparator B High Compare Bit 11 */
        byte BIT12       :1;                                       /* Comparator B High Compare Bit 12 */
        byte BIT13       :1;                                       /* Comparator B High Compare Bit 13 */
        byte BIT14       :1;                                       /* Comparator B High Compare Bit 14 */
        byte BIT15       :1;                                       /* Comparator B High Compare Bit 15 */
      } Bits;
    } DBGCBHSTR;
    #define DBGCBH                      _DBGCB.Overlap_STR.DBGCBHSTR.Byte
    #define DBGCBH_BIT8                 _DBGCB.Overlap_STR.DBGCBHSTR.Bits.BIT8
    #define DBGCBH_BIT9                 _DBGCB.Overlap_STR.DBGCBHSTR.Bits.BIT9
    #define DBGCBH_BIT10                _DBGCB.Overlap_STR.DBGCBHSTR.Bits.BIT10
    #define DBGCBH_BIT11                _DBGCB.Overlap_STR.DBGCBHSTR.Bits.BIT11
    #define DBGCBH_BIT12                _DBGCB.Overlap_STR.DBGCBHSTR.Bits.BIT12
    #define DBGCBH_BIT13                _DBGCB.Overlap_STR.DBGCBHSTR.Bits.BIT13
    #define DBGCBH_BIT14                _DBGCB.Overlap_STR.DBGCBHSTR.Bits.BIT14
    #define DBGCBH_BIT15                _DBGCB.Overlap_STR.DBGCBHSTR.Bits.BIT15
    
    #define DBGCBH_BIT8_MASK            1U
    #define DBGCBH_BIT9_MASK            2U
    #define DBGCBH_BIT10_MASK           4U
    #define DBGCBH_BIT11_MASK           8U
    #define DBGCBH_BIT12_MASK           16U
    #define DBGCBH_BIT13_MASK           32U
    #define DBGCBH_BIT14_MASK           64U
    #define DBGCBH_BIT15_MASK           128U
    

    /*** DBGCBL - Debug Comparator B Register Low; 0x0000002F ***/
    union {
      byte Byte;
      struct {
        byte BIT0        :1;                                       /* Comparator B High Compare Bit 0 */
        byte BIT1        :1;                                       /* Comparator B High Compare Bit 1 */
        byte BIT2        :1;                                       /* Comparator B High Compare Bit 2 */
        byte BIT3        :1;                                       /* Comparator B High Compare Bit 3 */
        byte BIT4        :1;                                       /* Comparator B High Compare Bit 4 */
        byte BIT5        :1;                                       /* Comparator B High Compare Bit 5 */
        byte BIT6        :1;                                       /* Comparator B High Compare Bit 6 */
        byte BIT7        :1;                                       /* Comparator B High Compare Bit 7 */
      } Bits;
    } DBGCBLSTR;
    #define DBGCBL                      _DBGCB.Overlap_STR.DBGCBLSTR.Byte
    #define DBGCBL_BIT0                 _DBGCB.Overlap_STR.DBGCBLSTR.Bits.BIT0
    #define DBGCBL_BIT1                 _DBGCB.Overlap_STR.DBGCBLSTR.Bits.BIT1
    #define DBGCBL_BIT2                 _DBGCB.Overlap_STR.DBGCBLSTR.Bits.BIT2
    #define DBGCBL_BIT3                 _DBGCB.Overlap_STR.DBGCBLSTR.Bits.BIT3
    #define DBGCBL_BIT4                 _DBGCB.Overlap_STR.DBGCBLSTR.Bits.BIT4
    #define DBGCBL_BIT5                 _DBGCB.Overlap_STR.DBGCBLSTR.Bits.BIT5
    #define DBGCBL_BIT6                 _DBGCB.Overlap_STR.DBGCBLSTR.Bits.BIT6
    #define DBGCBL_BIT7                 _DBGCB.Overlap_STR.DBGCBLSTR.Bits.BIT7
    
    #define DBGCBL_BIT0_MASK            1U
    #define DBGCBL_BIT1_MASK            2U
    #define DBGCBL_BIT2_MASK            4U
    #define DBGCBL_BIT3_MASK            8U
    #define DBGCBL_BIT4_MASK            16U
    #define DBGCBL_BIT5_MASK            32U
    #define DBGCBL_BIT6_MASK            64U
    #define DBGCBL_BIT7_MASK            128U
    
  } Overlap_STR;

  struct {
    word BIT0        :1;                                       /* Comparator B High Compare Bit 0 */
    word BIT1        :1;                                       /* Comparator B High Compare Bit 1 */
    word BIT2        :1;                                       /* Comparator B High Compare Bit 2 */
    word BIT3        :1;                                       /* Comparator B High Compare Bit 3 */
    word BIT4        :1;                                       /* Comparator B High Compare Bit 4 */
    word BIT5        :1;                                       /* Comparator B High Compare Bit 5 */
    word BIT6        :1;                                       /* Comparator B High Compare Bit 6 */
    word BIT7        :1;                                       /* Comparator B High Compare Bit 7 */
    word BIT8        :1;                                       /* Comparator B High Compare Bit 8 */
    word BIT9        :1;                                       /* Comparator B High Compare Bit 9 */
    word BIT10       :1;                                       /* Comparator B High Compare Bit 10 */
    word BIT11       :1;                                       /* Comparator B High Compare Bit 11 */
    word BIT12       :1;                                       /* Comparator B High Compare Bit 12 */
    word BIT13       :1;                                       /* Comparator B High Compare Bit 13 */
    word BIT14       :1;                                       /* Comparator B High Compare Bit 14 */
    word BIT15       :1;                                       /* Comparator B High Compare Bit 15 */
  } Bits;
} DBGCBSTR;
extern volatile DBGCBSTR _DBGCB @(REG_BASE + 0x0000002EUL);
#define DBGCB                           _DBGCB.Word
#define DBGCB_BIT0                      _DBGCB.Bits.BIT0
#define DBGCB_BIT1                      _DBGCB.Bits.BIT1
#define DBGCB_BIT2                      _DBGCB.Bits.BIT2
#define DBGCB_BIT3                      _DBGCB.Bits.BIT3
#define DBGCB_BIT4                      _DBGCB.Bits.BIT4
#define DBGCB_BIT5                      _DBGCB.Bits.BIT5
#define DBGCB_BIT6                      _DBGCB.Bits.BIT6
#define DBGCB_BIT7                      _DBGCB.Bits.BIT7
#define DBGCB_BIT8                      _DBGCB.Bits.BIT8
#define DBGCB_BIT9                      _DBGCB.Bits.BIT9
#define DBGCB_BIT10                     _DBGCB.Bits.BIT10
#define DBGCB_BIT11                     _DBGCB.Bits.BIT11
#define DBGCB_BIT12                     _DBGCB.Bits.BIT12
#define DBGCB_BIT13                     _DBGCB.Bits.BIT13
#define DBGCB_BIT14                     _DBGCB.Bits.BIT14
#define DBGCB_BIT15                     _DBGCB.Bits.BIT15

#define DBGCB_BIT0_MASK                 1U
#define DBGCB_BIT1_MASK                 2U
#define DBGCB_BIT2_MASK                 4U
#define DBGCB_BIT3_MASK                 8U
#define DBGCB_BIT4_MASK                 16U
#define DBGCB_BIT5_MASK                 32U
#define DBGCB_BIT6_MASK                 64U
#define DBGCB_BIT7_MASK                 128U
#define DBGCB_BIT8_MASK                 256U
#define DBGCB_BIT9_MASK                 512U
#define DBGCB_BIT10_MASK                1024U
#define DBGCB_BIT11_MASK                2048U
#define DBGCB_BIT12_MASK                4096U
#define DBGCB_BIT13_MASK                8192U
#define DBGCB_BIT14_MASK                16384U
#define DBGCB_BIT15_MASK                32768U


/*** PPAGE - Page Index Register; 0x00000030 ***/
typedef union {
  byte Byte;
  struct {
    byte PIX0        :1;                                       /* Page Index Register Bit 0 */
    byte PIX1        :1;                                       /* Page Index Register Bit 1 */
    byte PIX2        :1;                                       /* Page Index Register Bit 2 */
    byte PIX3        :1;                                       /* Page Index Register Bit 3 */
    byte PIX4        :1;                                       /* Page Index Register Bit 4 */
    byte PIX5        :1;                                       /* Page Index Register Bit 5 */
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpPIX  :6;
    byte         :1;
    byte         :1;
  } MergedBits;
} PPAGESTR;
extern volatile PPAGESTR _PPAGE @(REG_BASE + 0x00000030UL);
#define PPAGE                           _PPAGE.Byte
#define PPAGE_PIX0                      _PPAGE.Bits.PIX0
#define PPAGE_PIX1                      _PPAGE.Bits.PIX1
#define PPAGE_PIX2                      _PPAGE.Bits.PIX2
#define PPAGE_PIX3                      _PPAGE.Bits.PIX3
#define PPAGE_PIX4                      _PPAGE.Bits.PIX4
#define PPAGE_PIX5                      _PPAGE.Bits.PIX5
#define PPAGE_PIX                       _PPAGE.MergedBits.grpPIX

#define PPAGE_PIX0_MASK                 1U
#define PPAGE_PIX1_MASK                 2U
#define PPAGE_PIX2_MASK                 4U
#define PPAGE_PIX3_MASK                 8U
#define PPAGE_PIX4_MASK                 16U
#define PPAGE_PIX5_MASK                 32U
#define PPAGE_PIX_MASK                  63U
#define PPAGE_PIX_BITNUM                0U


/*** PORTK - Port K Data Register; 0x00000032 ***/
typedef union {
  byte Byte;
  struct {
    byte BIT0        :1;                                       /* Port K Bit 0 */
    byte BIT1        :1;                                       /* Port K Bit 1 */
    byte BIT2        :1;                                       /* Port K Bit 2 */
    byte BIT3        :1;                                       /* Port K Bit 3 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte BIT7        :1;                                       /* Port K Bit 7 */
  } Bits;
  struct {
    byte grpBIT  :4;
    byte         :1;
    byte         :1;
    byte         :1;
    byte grpBIT_7 :1;
  } MergedBits;
} PORTKSTR;
extern volatile PORTKSTR _PORTK @(REG_BASE + 0x00000032UL);
#define PORTK                           _PORTK.Byte
#define PORTK_BIT0                      _PORTK.Bits.BIT0
#define PORTK_BIT1                      _PORTK.Bits.BIT1
#define PORTK_BIT2                      _PORTK.Bits.BIT2
#define PORTK_BIT3                      _PORTK.Bits.BIT3
#define PORTK_BIT7                      _PORTK.Bits.BIT7
#define PORTK_BIT                       _PORTK.MergedBits.grpBIT

#define PORTK_BIT0_MASK                 1U
#define PORTK_BIT1_MASK                 2U
#define PORTK_BIT2_MASK                 4U
#define PORTK_BIT3_MASK                 8U
#define PORTK_BIT7_MASK                 128U
#define PORTK_BIT_MASK                  15U
#define PORTK_BIT_BITNUM                0U


/*** DDRK - Port K Data Direction Register; 0x00000033 ***/
typedef union {
  byte Byte;
  struct {
    byte BIT0        :1;                                       /* Port K Data Direction Bit 0 */
    byte BIT1        :1;                                       /* Port K Data Direction Bit 1 */
    byte BIT2        :1;                                       /* Port K Data Direction Bit 2 */
    byte BIT3        :1;                                       /* Port K Data Direction Bit 3 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte BIT7        :1;                                       /* Port K Data Direction Bit 7 */
  } Bits;
  struct {
    byte grpBIT  :4;
    byte         :1;
    byte         :1;
    byte         :1;
    byte grpBIT_7 :1;
  } MergedBits;
} DDRKSTR;
extern volatile DDRKSTR _DDRK @(REG_BASE + 0x00000033UL);
#define DDRK                            _DDRK.Byte
#define DDRK_BIT0                       _DDRK.Bits.BIT0
#define DDRK_BIT1                       _DDRK.Bits.BIT1
#define DDRK_BIT2                       _DDRK.Bits.BIT2
#define DDRK_BIT3                       _DDRK.Bits.BIT3
#define DDRK_BIT7                       _DDRK.Bits.BIT7
#define DDRK_BIT                        _DDRK.MergedBits.grpBIT

#define DDRK_BIT0_MASK                  1U
#define DDRK_BIT1_MASK                  2U
#define DDRK_BIT2_MASK                  4U
#define DDRK_BIT3_MASK                  8U
#define DDRK_BIT7_MASK                  128U
#define DDRK_BIT_MASK                   15U
#define DDRK_BIT_BITNUM                 0U


/*** SYNR - CRG Synthesizer Register; 0x00000034 ***/
typedef union {
  byte Byte;
  struct {
    byte SYN0        :1;                                       /* CRG Synthesizer Bit 0 */
    byte SYN1        :1;                                       /* CRG Synthesizer Bit 1 */
    byte SYN2        :1;                                       /* CRG Synthesizer Bit 2 */
    byte SYN3        :1;                                       /* CRG Synthesizer Bit 3 */
    byte SYN4        :1;                                       /* CRG Synthesizer Bit 4 */
    byte SYN5        :1;                                       /* CRG Synthesizer Bit 5 */
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpSYN  :6;
    byte         :1;
    byte         :1;
  } MergedBits;
} SYNRSTR;
extern volatile SYNRSTR _SYNR @(REG_BASE + 0x00000034UL);
#define SYNR                            _SYNR.Byte
#define SYNR_SYN0                       _SYNR.Bits.SYN0
#define SYNR_SYN1                       _SYNR.Bits.SYN1
#define SYNR_SYN2                       _SYNR.Bits.SYN2
#define SYNR_SYN3                       _SYNR.Bits.SYN3
#define SYNR_SYN4                       _SYNR.Bits.SYN4
#define SYNR_SYN5                       _SYNR.Bits.SYN5
#define SYNR_SYN                        _SYNR.MergedBits.grpSYN

#define SYNR_SYN0_MASK                  1U
#define SYNR_SYN1_MASK                  2U
#define SYNR_SYN2_MASK                  4U
#define SYNR_SYN3_MASK                  8U
#define SYNR_SYN4_MASK                  16U
#define SYNR_SYN5_MASK                  32U
#define SYNR_SYN_MASK                   63U
#define SYNR_SYN_BITNUM                 0U


/*** REFDV - CRG Reference Divider Register; 0x00000035 ***/
typedef union {
  byte Byte;
  struct {
    byte REFDV0      :1;                                       /* CRG Reference Divider Bit 0 */
    byte REFDV1      :1;                                       /* CRG Reference Divider Bit 1 */
    byte REFDV2      :1;                                       /* CRG Reference Divider Bit 2 */
    byte REFDV3      :1;                                       /* CRG Reference Divider Bit 3 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpREFDV :4;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} REFDVSTR;
extern volatile REFDVSTR _REFDV @(REG_BASE + 0x00000035UL);
#define REFDV                           _REFDV.Byte
#define REFDV_REFDV0                    _REFDV.Bits.REFDV0
#define REFDV_REFDV1                    _REFDV.Bits.REFDV1
#define REFDV_REFDV2                    _REFDV.Bits.REFDV2
#define REFDV_REFDV3                    _REFDV.Bits.REFDV3
#define REFDV_REFDV                     _REFDV.MergedBits.grpREFDV

#define REFDV_REFDV0_MASK               1U
#define REFDV_REFDV1_MASK               2U
#define REFDV_REFDV2_MASK               4U
#define REFDV_REFDV3_MASK               8U
#define REFDV_REFDV_MASK                15U
#define REFDV_REFDV_BITNUM              0U


/*** CRGFLG - CRG Flags Register; 0x00000037 ***/
typedef union {
  byte Byte;
  struct {
    byte SCM         :1;                                       /* Self-clock mode Status */
    byte SCMIF       :1;                                       /* Self-clock mode Interrupt Flag */
    byte TRACK       :1;                                       /* Track Status */
    byte LOCK        :1;                                       /* Lock Status */
    byte LOCKIF      :1;                                       /* PLL Lock Interrupt Flag */
    byte LVRF        :1;                                       /* Low Voltage Reset Flag */
    byte PORF        :1;                                       /* Power on Reset Flag */
    byte RTIF        :1;                                       /* Real Time Interrupt Flag */
  } Bits;
} CRGFLGSTR;
extern volatile CRGFLGSTR _CRGFLG @(REG_BASE + 0x00000037UL);
#define CRGFLG                          _CRGFLG.Byte
#define CRGFLG_SCM                      _CRGFLG.Bits.SCM
#define CRGFLG_SCMIF                    _CRGFLG.Bits.SCMIF
#define CRGFLG_TRACK                    _CRGFLG.Bits.TRACK
#define CRGFLG_LOCK                     _CRGFLG.Bits.LOCK
#define CRGFLG_LOCKIF                   _CRGFLG.Bits.LOCKIF
#define CRGFLG_LVRF                     _CRGFLG.Bits.LVRF
#define CRGFLG_PORF                     _CRGFLG.Bits.PORF
#define CRGFLG_RTIF                     _CRGFLG.Bits.RTIF

#define CRGFLG_SCM_MASK                 1U
#define CRGFLG_SCMIF_MASK               2U
#define CRGFLG_TRACK_MASK               4U
#define CRGFLG_LOCK_MASK                8U
#define CRGFLG_LOCKIF_MASK              16U
#define CRGFLG_LVRF_MASK                32U
#define CRGFLG_PORF_MASK                64U
#define CRGFLG_RTIF_MASK                128U


/*** CRGINT - CRG Interrupt Enable Register; 0x00000038 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte SCMIE       :1;                                       /* Self-clock mode Interrupt Enable */
    byte             :1; 
    byte             :1; 
    byte LOCKIE      :1;                                       /* Lock Interrupt Enable */
    byte             :1; 
    byte             :1; 
    byte RTIE        :1;                                       /* Real Time Interrupt Enable */
  } Bits;
} CRGINTSTR;
extern volatile CRGINTSTR _CRGINT @(REG_BASE + 0x00000038UL);
#define CRGINT                          _CRGINT.Byte
#define CRGINT_SCMIE                    _CRGINT.Bits.SCMIE
#define CRGINT_LOCKIE                   _CRGINT.Bits.LOCKIE
#define CRGINT_RTIE                     _CRGINT.Bits.RTIE

#define CRGINT_SCMIE_MASK               2U
#define CRGINT_LOCKIE_MASK              16U
#define CRGINT_RTIE_MASK                128U


/*** CLKSEL - CRG Clock Select Register; 0x00000039 ***/
typedef union {
  byte Byte;
  struct {
    byte COPWAI      :1;                                       /* COP stops in WAIT mode */
    byte RTIWAI      :1;                                       /* RTI stops in WAIT mode */
    byte CWAI        :1;                                       /* CLK24 and CLK23 stop in WAIT mode */
    byte PLLWAI      :1;                                       /* PLL stops in WAIT mode */
    byte ROAWAI      :1;                                       /* Reduced Oscillator Amplitude in WAIT mode */
    byte SYSWAI      :1;                                       /* System clocks stop in WAIT mode */
    byte PSTP        :1;                                       /* Pseudo Stop */
    byte PLLSEL      :1;                                       /* PLL selected for system clock */
  } Bits;
} CLKSELSTR;
extern volatile CLKSELSTR _CLKSEL @(REG_BASE + 0x00000039UL);
#define CLKSEL                          _CLKSEL.Byte
#define CLKSEL_COPWAI                   _CLKSEL.Bits.COPWAI
#define CLKSEL_RTIWAI                   _CLKSEL.Bits.RTIWAI
#define CLKSEL_CWAI                     _CLKSEL.Bits.CWAI
#define CLKSEL_PLLWAI                   _CLKSEL.Bits.PLLWAI
#define CLKSEL_ROAWAI                   _CLKSEL.Bits.ROAWAI
#define CLKSEL_SYSWAI                   _CLKSEL.Bits.SYSWAI
#define CLKSEL_PSTP                     _CLKSEL.Bits.PSTP
#define CLKSEL_PLLSEL                   _CLKSEL.Bits.PLLSEL

#define CLKSEL_COPWAI_MASK              1U
#define CLKSEL_RTIWAI_MASK              2U
#define CLKSEL_CWAI_MASK                4U
#define CLKSEL_PLLWAI_MASK              8U
#define CLKSEL_ROAWAI_MASK              16U
#define CLKSEL_SYSWAI_MASK              32U
#define CLKSEL_PSTP_MASK                64U
#define CLKSEL_PLLSEL_MASK              128U


/*** PLLCTL - CRG PLL Control Register; 0x0000003A ***/
typedef union {
  byte Byte;
  struct {
    byte SCME        :1;                                       /* Self-clock mode enable */
    byte PCE         :1;                                       /* COP Enable during Pseudo Stop Bit */
    byte PRE         :1;                                       /* RTI Enable during Pseudo Stop Bit */
    byte             :1; 
    byte ACQ         :1;                                       /* Acquisition */
    byte AUTO        :1;                                       /* Automatic Bandwidth Control */
    byte PLLON       :1;                                       /* Phase Lock Loop On */
    byte CME         :1;                                       /* Clock Monitor Enable */
  } Bits;
} PLLCTLSTR;
extern volatile PLLCTLSTR _PLLCTL @(REG_BASE + 0x0000003AUL);
#define PLLCTL                          _PLLCTL.Byte
#define PLLCTL_SCME                     _PLLCTL.Bits.SCME
#define PLLCTL_PCE                      _PLLCTL.Bits.PCE
#define PLLCTL_PRE                      _PLLCTL.Bits.PRE
#define PLLCTL_ACQ                      _PLLCTL.Bits.ACQ
#define PLLCTL_AUTO                     _PLLCTL.Bits.AUTO
#define PLLCTL_PLLON                    _PLLCTL.Bits.PLLON
#define PLLCTL_CME                      _PLLCTL.Bits.CME

#define PLLCTL_SCME_MASK                1U
#define PLLCTL_PCE_MASK                 2U
#define PLLCTL_PRE_MASK                 4U
#define PLLCTL_ACQ_MASK                 16U
#define PLLCTL_AUTO_MASK                32U
#define PLLCTL_PLLON_MASK               64U
#define PLLCTL_CME_MASK                 128U


/*** RTICTL - CRG RTI Control Register; 0x0000003B ***/
typedef union {
  byte Byte;
  struct {
    byte RTR0        :1;                                       /* Real Time Interrupt Modulus Counter Select Bit 0 */
    byte RTR1        :1;                                       /* Real Time Interrupt Modulus Counter Select Bit 1 */
    byte RTR2        :1;                                       /* Real Time Interrupt Modulus Counter Select Bit 2 */
    byte RTR3        :1;                                       /* Real Time Interrupt Modulus Counter Select Bit 3 */
    byte RTR4        :1;                                       /* Real Time Interrupt Prescale Rate Select Bit 4 */
    byte RTR5        :1;                                       /* Real Time Interrupt Prescale Rate Select Bit 5 */
    byte RTR6        :1;                                       /* Real Time Interrupt Prescale Rate Select Bit 6 */
    byte             :1; 
  } Bits;
  struct {
    byte grpRTR  :7;
    byte         :1;
  } MergedBits;
} RTICTLSTR;
extern volatile RTICTLSTR _RTICTL @(REG_BASE + 0x0000003BUL);
#define RTICTL                          _RTICTL.Byte
#define RTICTL_RTR0                     _RTICTL.Bits.RTR0
#define RTICTL_RTR1                     _RTICTL.Bits.RTR1
#define RTICTL_RTR2                     _RTICTL.Bits.RTR2
#define RTICTL_RTR3                     _RTICTL.Bits.RTR3
#define RTICTL_RTR4                     _RTICTL.Bits.RTR4
#define RTICTL_RTR5                     _RTICTL.Bits.RTR5
#define RTICTL_RTR6                     _RTICTL.Bits.RTR6
#define RTICTL_RTR                      _RTICTL.MergedBits.grpRTR

#define RTICTL_RTR0_MASK                1U
#define RTICTL_RTR1_MASK                2U
#define RTICTL_RTR2_MASK                4U
#define RTICTL_RTR3_MASK                8U
#define RTICTL_RTR4_MASK                16U
#define RTICTL_RTR5_MASK                32U
#define RTICTL_RTR6_MASK                64U
#define RTICTL_RTR_MASK                 127U
#define RTICTL_RTR_BITNUM               0U


/*** COPCTL - CRG COP Control Register; 0x0000003C ***/
typedef union {
  byte Byte;
  struct {
    byte CR0         :1;                                       /* COP Watchdog Timer Rate select Bit 0 */
    byte CR1         :1;                                       /* COP Watchdog Timer Rate select Bit 1 */
    byte CR2         :1;                                       /* COP Watchdog Timer Rate select Bit 2 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte RSBCK       :1;                                       /* COP and RTI stop in Active BDM mode Bit */
    byte WCOP        :1;                                       /* Window COP mode */
  } Bits;
  struct {
    byte grpCR   :3;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} COPCTLSTR;
extern volatile COPCTLSTR _COPCTL @(REG_BASE + 0x0000003CUL);
#define COPCTL                          _COPCTL.Byte
#define COPCTL_CR0                      _COPCTL.Bits.CR0
#define COPCTL_CR1                      _COPCTL.Bits.CR1
#define COPCTL_CR2                      _COPCTL.Bits.CR2
#define COPCTL_RSBCK                    _COPCTL.Bits.RSBCK
#define COPCTL_WCOP                     _COPCTL.Bits.WCOP
#define COPCTL_CR                       _COPCTL.MergedBits.grpCR

#define COPCTL_CR0_MASK                 1U
#define COPCTL_CR1_MASK                 2U
#define COPCTL_CR2_MASK                 4U
#define COPCTL_RSBCK_MASK               64U
#define COPCTL_WCOP_MASK                128U
#define COPCTL_CR_MASK                  7U
#define COPCTL_CR_BITNUM                0U


/*** ARMCOP - CRG COP Timer Arm/Reset Register; 0x0000003F ***/
typedef union {
  byte Byte;
  struct {
    byte BIT0        :1;                                       /* CRG COP Timer Arm/Reset Bit 0 */
    byte BIT1        :1;                                       /* CRG COP Timer Arm/Reset Bit 1 */
    byte BIT2        :1;                                       /* CRG COP Timer Arm/Reset Bit 2 */
    byte BIT3        :1;                                       /* CRG COP Timer Arm/Reset Bit 3 */
    byte BIT4        :1;                                       /* CRG COP Timer Arm/Reset Bit 4 */
    byte BIT5        :1;                                       /* CRG COP Timer Arm/Reset Bit 5 */
    byte BIT6        :1;                                       /* CRG COP Timer Arm/Reset Bit 6 */
    byte BIT7        :1;                                       /* CRG COP Timer Arm/Reset Bit 7 */
  } Bits;
} ARMCOPSTR;
extern volatile ARMCOPSTR _ARMCOP @(REG_BASE + 0x0000003FUL);
#define ARMCOP                          _ARMCOP.Byte
#define ARMCOP_BIT0                     _ARMCOP.Bits.BIT0
#define ARMCOP_BIT1                     _ARMCOP.Bits.BIT1
#define ARMCOP_BIT2                     _ARMCOP.Bits.BIT2
#define ARMCOP_BIT3                     _ARMCOP.Bits.BIT3
#define ARMCOP_BIT4                     _ARMCOP.Bits.BIT4
#define ARMCOP_BIT5                     _ARMCOP.Bits.BIT5
#define ARMCOP_BIT6                     _ARMCOP.Bits.BIT6
#define ARMCOP_BIT7                     _ARMCOP.Bits.BIT7

#define ARMCOP_BIT0_MASK                1U
#define ARMCOP_BIT1_MASK                2U
#define ARMCOP_BIT2_MASK                4U
#define ARMCOP_BIT3_MASK                8U
#define ARMCOP_BIT4_MASK                16U
#define ARMCOP_BIT5_MASK                32U
#define ARMCOP_BIT6_MASK                64U
#define ARMCOP_BIT7_MASK                128U


/*** TIOS - Timer Input Capture/Output Compare Select; 0x00000040 ***/
typedef union {
  byte Byte;
  struct {
    byte IOS0        :1;                                       /* Input Capture or Output Compare Channel Configuration Bit 0 */
    byte IOS1        :1;                                       /* Input Capture or Output Compare Channel Configuration Bit 1 */
    byte IOS2        :1;                                       /* Input Capture or Output Compare Channel Configuration Bit 2 */
    byte IOS3        :1;                                       /* Input Capture or Output Compare Channel Configuration Bit 3 */
    byte IOS4        :1;                                       /* Input Capture or Output Compare Channel Configuration Bit 4 */
    byte IOS5        :1;                                       /* Input Capture or Output Compare Channel Configuration Bit 5 */
    byte IOS6        :1;                                       /* Input Capture or Output Compare Channel Configuration Bit 6 */
    byte IOS7        :1;                                       /* Input Capture or Output Compare Channel Configuration Bit 7 */
  } Bits;
} TIOSSTR;
extern volatile TIOSSTR _TIOS @(REG_BASE + 0x00000040UL);
#define TIOS                            _TIOS.Byte
#define TIOS_IOS0                       _TIOS.Bits.IOS0
#define TIOS_IOS1                       _TIOS.Bits.IOS1
#define TIOS_IOS2                       _TIOS.Bits.IOS2
#define TIOS_IOS3                       _TIOS.Bits.IOS3
#define TIOS_IOS4                       _TIOS.Bits.IOS4
#define TIOS_IOS5                       _TIOS.Bits.IOS5
#define TIOS_IOS6                       _TIOS.Bits.IOS6
#define TIOS_IOS7                       _TIOS.Bits.IOS7

#define TIOS_IOS0_MASK                  1U
#define TIOS_IOS1_MASK                  2U
#define TIOS_IOS2_MASK                  4U
#define TIOS_IOS3_MASK                  8U
#define TIOS_IOS4_MASK                  16U
#define TIOS_IOS5_MASK                  32U
#define TIOS_IOS6_MASK                  64U
#define TIOS_IOS7_MASK                  128U


/*** CFORC - Timer Compare Force Register; 0x00000041 ***/
typedef union {
  byte Byte;
  struct {
    byte FOC0        :1;                                       /* Force Output Compare Action for Channel 0 */
    byte FOC1        :1;                                       /* Force Output Compare Action for Channel 1 */
    byte FOC2        :1;                                       /* Force Output Compare Action for Channel 2 */
    byte FOC3        :1;                                       /* Force Output Compare Action for Channel 3 */
    byte FOC4        :1;                                       /* Force Output Compare Action for Channel 4 */
    byte FOC5        :1;                                       /* Force Output Compare Action for Channel 5 */
    byte FOC6        :1;                                       /* Force Output Compare Action for Channel 6 */
    byte FOC7        :1;                                       /* Force Output Compare Action for Channel 7 */
  } Bits;
} CFORCSTR;
extern volatile CFORCSTR _CFORC @(REG_BASE + 0x00000041UL);
#define CFORC                           _CFORC.Byte
#define CFORC_FOC0                      _CFORC.Bits.FOC0
#define CFORC_FOC1                      _CFORC.Bits.FOC1
#define CFORC_FOC2                      _CFORC.Bits.FOC2
#define CFORC_FOC3                      _CFORC.Bits.FOC3
#define CFORC_FOC4                      _CFORC.Bits.FOC4
#define CFORC_FOC5                      _CFORC.Bits.FOC5
#define CFORC_FOC6                      _CFORC.Bits.FOC6
#define CFORC_FOC7                      _CFORC.Bits.FOC7

#define CFORC_FOC0_MASK                 1U
#define CFORC_FOC1_MASK                 2U
#define CFORC_FOC2_MASK                 4U
#define CFORC_FOC3_MASK                 8U
#define CFORC_FOC4_MASK                 16U
#define CFORC_FOC5_MASK                 32U
#define CFORC_FOC6_MASK                 64U
#define CFORC_FOC7_MASK                 128U


/*** OC7M - Output Compare 7 Mask Register; 0x00000042 ***/
typedef union {
  byte Byte;
  struct {
    byte OC7M0       :1;                                       /* Output Compare 7 Mask Bit 0 */
    byte OC7M1       :1;                                       /* Output Compare 7 Mask Bit 1 */
    byte OC7M2       :1;                                       /* Output Compare 7 Mask Bit 2 */
    byte OC7M3       :1;                                       /* Output Compare 7 Mask Bit 3 */
    byte OC7M4       :1;                                       /* Output Compare 7 Mask Bit 4 */
    byte OC7M5       :1;                                       /* Output Compare 7 Mask Bit 5 */
    byte OC7M6       :1;                                       /* Output Compare 7 Mask Bit 6 */
    byte OC7M7       :1;                                       /* Output Compare 7 Mask Bit 7 */
  } Bits;
} OC7MSTR;
extern volatile OC7MSTR _OC7M @(REG_BASE + 0x00000042UL);
#define OC7M                            _OC7M.Byte
#define OC7M_OC7M0                      _OC7M.Bits.OC7M0
#define OC7M_OC7M1                      _OC7M.Bits.OC7M1
#define OC7M_OC7M2                      _OC7M.Bits.OC7M2
#define OC7M_OC7M3                      _OC7M.Bits.OC7M3
#define OC7M_OC7M4                      _OC7M.Bits.OC7M4
#define OC7M_OC7M5                      _OC7M.Bits.OC7M5
#define OC7M_OC7M6                      _OC7M.Bits.OC7M6
#define OC7M_OC7M7                      _OC7M.Bits.OC7M7

#define OC7M_OC7M0_MASK                 1U
#define OC7M_OC7M1_MASK                 2U
#define OC7M_OC7M2_MASK                 4U
#define OC7M_OC7M3_MASK                 8U
#define OC7M_OC7M4_MASK                 16U
#define OC7M_OC7M5_MASK                 32U
#define OC7M_OC7M6_MASK                 64U
#define OC7M_OC7M7_MASK                 128U


/*** OC7D - Output Compare 7 Data Register; 0x00000043 ***/
typedef union {
  byte Byte;
  struct {
    byte OC7D0       :1;                                       /* Output Compare 7 Bit 0 */
    byte OC7D1       :1;                                       /* Output Compare 7 Bit 1 */
    byte OC7D2       :1;                                       /* Output Compare 7 Bit 2 */
    byte OC7D3       :1;                                       /* Output Compare 7 Bit 3 */
    byte OC7D4       :1;                                       /* Output Compare 7 Bit 4 */
    byte OC7D5       :1;                                       /* Output Compare 7 Bit 5 */
    byte OC7D6       :1;                                       /* Output Compare 7 Bit 6 */
    byte OC7D7       :1;                                       /* Output Compare 7 Bit 7 */
  } Bits;
} OC7DSTR;
extern volatile OC7DSTR _OC7D @(REG_BASE + 0x00000043UL);
#define OC7D                            _OC7D.Byte
#define OC7D_OC7D0                      _OC7D.Bits.OC7D0
#define OC7D_OC7D1                      _OC7D.Bits.OC7D1
#define OC7D_OC7D2                      _OC7D.Bits.OC7D2
#define OC7D_OC7D3                      _OC7D.Bits.OC7D3
#define OC7D_OC7D4                      _OC7D.Bits.OC7D4
#define OC7D_OC7D5                      _OC7D.Bits.OC7D5
#define OC7D_OC7D6                      _OC7D.Bits.OC7D6
#define OC7D_OC7D7                      _OC7D.Bits.OC7D7

#define OC7D_OC7D0_MASK                 1U
#define OC7D_OC7D1_MASK                 2U
#define OC7D_OC7D2_MASK                 4U
#define OC7D_OC7D3_MASK                 8U
#define OC7D_OC7D4_MASK                 16U
#define OC7D_OC7D5_MASK                 32U
#define OC7D_OC7D6_MASK                 64U
#define OC7D_OC7D7_MASK                 128U


/*** TCNT - Timer Count Register; 0x00000044 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** TCNTHi - Timer Count Register High; 0x00000044 ***/
    union {
      byte Byte;
    } TCNTHiSTR;
    #define TCNTHi                      _TCNT.Overlap_STR.TCNTHiSTR.Byte
    

    /*** TCNTLo - Timer Count Register Low; 0x00000045 ***/
    union {
      byte Byte;
    } TCNTLoSTR;
    #define TCNTLo                      _TCNT.Overlap_STR.TCNTLoSTR.Byte
    
  } Overlap_STR;

} TCNTSTR;
extern volatile TCNTSTR _TCNT @(REG_BASE + 0x00000044UL);
#define TCNT                            _TCNT.Word


/*** TSCR1 - Timer System Control Register1; 0x00000046 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte TFFCA       :1;                                       /* Timer Fast Flag Clear All */
    byte TSFRZ       :1;                                       /* Timer and Modulus Counter Stop While in Freeze Mode */
    byte TSWAI       :1;                                       /* Timer Module Stops While in Wait */
    byte TEN         :1;                                       /* Timer Enable */
  } Bits;
} TSCR1STR;
extern volatile TSCR1STR _TSCR1 @(REG_BASE + 0x00000046UL);
#define TSCR1                           _TSCR1.Byte
#define TSCR1_TFFCA                     _TSCR1.Bits.TFFCA
#define TSCR1_TSFRZ                     _TSCR1.Bits.TSFRZ
#define TSCR1_TSWAI                     _TSCR1.Bits.TSWAI
#define TSCR1_TEN                       _TSCR1.Bits.TEN

#define TSCR1_TFFCA_MASK                16U
#define TSCR1_TSFRZ_MASK                32U
#define TSCR1_TSWAI_MASK                64U
#define TSCR1_TEN_MASK                  128U


/*** TTOV - Timer Toggle On Overflow Register; 0x00000047 ***/
typedef union {
  byte Byte;
  struct {
    byte TOV0        :1;                                       /* Toggle On Overflow Bit 0 */
    byte TOV1        :1;                                       /* Toggle On Overflow Bit 1 */
    byte TOV2        :1;                                       /* Toggle On Overflow Bit 2 */
    byte TOV3        :1;                                       /* Toggle On Overflow Bit 3 */
    byte TOV4        :1;                                       /* Toggle On Overflow Bit 4 */
    byte TOV5        :1;                                       /* Toggle On Overflow Bit 5 */
    byte TOV6        :1;                                       /* Toggle On Overflow Bit 6 */
    byte TOV7        :1;                                       /* Toggle On Overflow Bit 7 */
  } Bits;
} TTOVSTR;
extern volatile TTOVSTR _TTOV @(REG_BASE + 0x00000047UL);
#define TTOV                            _TTOV.Byte
#define TTOV_TOV0                       _TTOV.Bits.TOV0
#define TTOV_TOV1                       _TTOV.Bits.TOV1
#define TTOV_TOV2                       _TTOV.Bits.TOV2
#define TTOV_TOV3                       _TTOV.Bits.TOV3
#define TTOV_TOV4                       _TTOV.Bits.TOV4
#define TTOV_TOV5                       _TTOV.Bits.TOV5
#define TTOV_TOV6                       _TTOV.Bits.TOV6
#define TTOV_TOV7                       _TTOV.Bits.TOV7

#define TTOV_TOV0_MASK                  1U
#define TTOV_TOV1_MASK                  2U
#define TTOV_TOV2_MASK                  4U
#define TTOV_TOV3_MASK                  8U
#define TTOV_TOV4_MASK                  16U
#define TTOV_TOV5_MASK                  32U
#define TTOV_TOV6_MASK                  64U
#define TTOV_TOV7_MASK                  128U


/*** TCTL1 - Timer Control Register 1; 0x00000048 ***/
typedef union {
  byte Byte;
  struct {
    byte OL4         :1;                                       /* Output Level Bit 4 */
    byte OM4         :1;                                       /* Output Mode Bit 4 */
    byte OL5         :1;                                       /* Output Level Bit 5 */
    byte OM5         :1;                                       /* Output Mode Bit 5 */
    byte OL6         :1;                                       /* Output Level Bit 6 */
    byte OM6         :1;                                       /* Output Mode Bit 6 */
    byte OL7         :1;                                       /* Output Level Bit 7 */
    byte OM7         :1;                                       /* Output Mode Bit 7 */
  } Bits;
} TCTL1STR;
extern volatile TCTL1STR _TCTL1 @(REG_BASE + 0x00000048UL);
#define TCTL1                           _TCTL1.Byte
#define TCTL1_OL4                       _TCTL1.Bits.OL4
#define TCTL1_OM4                       _TCTL1.Bits.OM4
#define TCTL1_OL5                       _TCTL1.Bits.OL5
#define TCTL1_OM5                       _TCTL1.Bits.OM5
#define TCTL1_OL6                       _TCTL1.Bits.OL6
#define TCTL1_OM6                       _TCTL1.Bits.OM6
#define TCTL1_OL7                       _TCTL1.Bits.OL7
#define TCTL1_OM7                       _TCTL1.Bits.OM7

#define TCTL1_OL4_MASK                  1U
#define TCTL1_OM4_MASK                  2U
#define TCTL1_OL5_MASK                  4U
#define TCTL1_OM5_MASK                  8U
#define TCTL1_OL6_MASK                  16U
#define TCTL1_OM6_MASK                  32U
#define TCTL1_OL7_MASK                  64U
#define TCTL1_OM7_MASK                  128U


/*** TCTL2 - Timer Control Register 2; 0x00000049 ***/
typedef union {
  byte Byte;
  struct {
    byte OL0         :1;                                       /* Output Level Bit 0 */
    byte OM0         :1;                                       /* Output Mode Bit 0 */
    byte OL1         :1;                                       /* Output Level Bit 1 */
    byte OM1         :1;                                       /* Output Mode Bit 1 */
    byte OL2         :1;                                       /* Output Level Bit 2 */
    byte OM2         :1;                                       /* Output Mode Bit 2 */
    byte OL3         :1;                                       /* Output Level Bit 3 */
    byte OM3         :1;                                       /* Output Mode Bit 3 */
  } Bits;
} TCTL2STR;
extern volatile TCTL2STR _TCTL2 @(REG_BASE + 0x00000049UL);
#define TCTL2                           _TCTL2.Byte
#define TCTL2_OL0                       _TCTL2.Bits.OL0
#define TCTL2_OM0                       _TCTL2.Bits.OM0
#define TCTL2_OL1                       _TCTL2.Bits.OL1
#define TCTL2_OM1                       _TCTL2.Bits.OM1
#define TCTL2_OL2                       _TCTL2.Bits.OL2
#define TCTL2_OM2                       _TCTL2.Bits.OM2
#define TCTL2_OL3                       _TCTL2.Bits.OL3
#define TCTL2_OM3                       _TCTL2.Bits.OM3

#define TCTL2_OL0_MASK                  1U
#define TCTL2_OM0_MASK                  2U
#define TCTL2_OL1_MASK                  4U
#define TCTL2_OM1_MASK                  8U
#define TCTL2_OL2_MASK                  16U
#define TCTL2_OM2_MASK                  32U
#define TCTL2_OL3_MASK                  64U
#define TCTL2_OM3_MASK                  128U


/*** TCTL3 - Timer Control Register 3; 0x0000004A ***/
typedef union {
  byte Byte;
  struct {
    byte EDG4A       :1;                                       /* Input Capture Edge Control 4A */
    byte EDG4B       :1;                                       /* Input Capture Edge Control 4B */
    byte EDG5A       :1;                                       /* Input Capture Edge Control 5A */
    byte EDG5B       :1;                                       /* Input Capture Edge Control 5B */
    byte EDG6A       :1;                                       /* Input Capture Edge Control 6A */
    byte EDG6B       :1;                                       /* Input Capture Edge Control 6B */
    byte EDG7A       :1;                                       /* Input Capture Edge Control 7A */
    byte EDG7B       :1;                                       /* Input Capture Edge Control 7B */
  } Bits;
  struct {
    byte grpEDG4x :2;
    byte grpEDG5x :2;
    byte grpEDG6x :2;
    byte grpEDG7x :2;
  } MergedBits;
} TCTL3STR;
extern volatile TCTL3STR _TCTL3 @(REG_BASE + 0x0000004AUL);
#define TCTL3                           _TCTL3.Byte
#define TCTL3_EDG4A                     _TCTL3.Bits.EDG4A
#define TCTL3_EDG4B                     _TCTL3.Bits.EDG4B
#define TCTL3_EDG5A                     _TCTL3.Bits.EDG5A
#define TCTL3_EDG5B                     _TCTL3.Bits.EDG5B
#define TCTL3_EDG6A                     _TCTL3.Bits.EDG6A
#define TCTL3_EDG6B                     _TCTL3.Bits.EDG6B
#define TCTL3_EDG7A                     _TCTL3.Bits.EDG7A
#define TCTL3_EDG7B                     _TCTL3.Bits.EDG7B
#define TCTL3_EDG4x                     _TCTL3.MergedBits.grpEDG4x
#define TCTL3_EDG5x                     _TCTL3.MergedBits.grpEDG5x
#define TCTL3_EDG6x                     _TCTL3.MergedBits.grpEDG6x
#define TCTL3_EDG7x                     _TCTL3.MergedBits.grpEDG7x

#define TCTL3_EDG4A_MASK                1U
#define TCTL3_EDG4B_MASK                2U
#define TCTL3_EDG5A_MASK                4U
#define TCTL3_EDG5B_MASK                8U
#define TCTL3_EDG6A_MASK                16U
#define TCTL3_EDG6B_MASK                32U
#define TCTL3_EDG7A_MASK                64U
#define TCTL3_EDG7B_MASK                128U
#define TCTL3_EDG4x_MASK                3U
#define TCTL3_EDG4x_BITNUM              0U
#define TCTL3_EDG5x_MASK                12U
#define TCTL3_EDG5x_BITNUM              2U
#define TCTL3_EDG6x_MASK                48U
#define TCTL3_EDG6x_BITNUM              4U
#define TCTL3_EDG7x_MASK                192U
#define TCTL3_EDG7x_BITNUM              6U


/*** TCTL4 - Timer Control Register 4; 0x0000004B ***/
typedef union {
  byte Byte;
  struct {
    byte EDG0A       :1;                                       /* Input Capture Edge Control 0A */
    byte EDG0B       :1;                                       /* Input Capture Edge Control 0B */
    byte EDG1A       :1;                                       /* Input Capture Edge Control 1A */
    byte EDG1B       :1;                                       /* Input Capture Edge Control 1B */
    byte EDG2A       :1;                                       /* Input Capture Edge Control 2A */
    byte EDG2B       :1;                                       /* Input Capture Edge Control 2B */
    byte EDG3A       :1;                                       /* Input Capture Edge Control 3A */
    byte EDG3B       :1;                                       /* Input Capture Edge Control 3B */
  } Bits;
  struct {
    byte grpEDG0x :2;
    byte grpEDG1x :2;
    byte grpEDG2x :2;
    byte grpEDG3x :2;
  } MergedBits;
} TCTL4STR;
extern volatile TCTL4STR _TCTL4 @(REG_BASE + 0x0000004BUL);
#define TCTL4                           _TCTL4.Byte
#define TCTL4_EDG0A                     _TCTL4.Bits.EDG0A
#define TCTL4_EDG0B                     _TCTL4.Bits.EDG0B
#define TCTL4_EDG1A                     _TCTL4.Bits.EDG1A
#define TCTL4_EDG1B                     _TCTL4.Bits.EDG1B
#define TCTL4_EDG2A                     _TCTL4.Bits.EDG2A
#define TCTL4_EDG2B                     _TCTL4.Bits.EDG2B
#define TCTL4_EDG3A                     _TCTL4.Bits.EDG3A
#define TCTL4_EDG3B                     _TCTL4.Bits.EDG3B
#define TCTL4_EDG0x                     _TCTL4.MergedBits.grpEDG0x
#define TCTL4_EDG1x                     _TCTL4.MergedBits.grpEDG1x
#define TCTL4_EDG2x                     _TCTL4.MergedBits.grpEDG2x
#define TCTL4_EDG3x                     _TCTL4.MergedBits.grpEDG3x

#define TCTL4_EDG0A_MASK                1U
#define TCTL4_EDG0B_MASK                2U
#define TCTL4_EDG1A_MASK                4U
#define TCTL4_EDG1B_MASK                8U
#define TCTL4_EDG2A_MASK                16U
#define TCTL4_EDG2B_MASK                32U
#define TCTL4_EDG3A_MASK                64U
#define TCTL4_EDG3B_MASK                128U
#define TCTL4_EDG0x_MASK                3U
#define TCTL4_EDG0x_BITNUM              0U
#define TCTL4_EDG1x_MASK                12U
#define TCTL4_EDG1x_BITNUM              2U
#define TCTL4_EDG2x_MASK                48U
#define TCTL4_EDG2x_BITNUM              4U
#define TCTL4_EDG3x_MASK                192U
#define TCTL4_EDG3x_BITNUM              6U


/*** TIE - Timer Interrupt Enable Register; 0x0000004C ***/
typedef union {
  byte Byte;
  struct {
    byte C0I         :1;                                       /* Input Capture/Output Compare Interrupt Enable Bit 0 */
    byte C1I         :1;                                       /* Input Capture/Output Compare Interrupt Enable Bit 1 */
    byte C2I         :1;                                       /* Input Capture/Output Compare Interrupt Enable Bit 2 */
    byte C3I         :1;                                       /* Input Capture/Output Compare Interrupt Enable Bit 3 */
    byte C4I         :1;                                       /* Input Capture/Output Compare Interrupt Enable Bit 4 */
    byte C5I         :1;                                       /* Input Capture/Output Compare Interrupt Enable Bit 5 */
    byte C6I         :1;                                       /* Input Capture/Output Compare Interrupt Enable Bit 6 */
    byte C7I         :1;                                       /* Input Capture/Output Compare Interrupt Enable Bit 7 */
  } Bits;
} TIESTR;
extern volatile TIESTR _TIE @(REG_BASE + 0x0000004CUL);
#define TIE                             _TIE.Byte
#define TIE_C0I                         _TIE.Bits.C0I
#define TIE_C1I                         _TIE.Bits.C1I
#define TIE_C2I                         _TIE.Bits.C2I
#define TIE_C3I                         _TIE.Bits.C3I
#define TIE_C4I                         _TIE.Bits.C4I
#define TIE_C5I                         _TIE.Bits.C5I
#define TIE_C6I                         _TIE.Bits.C6I
#define TIE_C7I                         _TIE.Bits.C7I

#define TIE_C0I_MASK                    1U
#define TIE_C1I_MASK                    2U
#define TIE_C2I_MASK                    4U
#define TIE_C3I_MASK                    8U
#define TIE_C4I_MASK                    16U
#define TIE_C5I_MASK                    32U
#define TIE_C6I_MASK                    64U
#define TIE_C7I_MASK                    128U


/*** TSCR2 - Timer System Control Register 2; 0x0000004D ***/
typedef union {
  byte Byte;
  struct {
    byte PR0         :1;                                       /* Timer Prescaler Select Bit 0 */
    byte PR1         :1;                                       /* Timer Prescaler Select Bit 1 */
    byte PR2         :1;                                       /* Timer Prescaler Select Bit 2 */
    byte TCRE        :1;                                       /* Timer Counter Reset Enable */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte TOI         :1;                                       /* Timer Overflow Interrupt Enable */
  } Bits;
  struct {
    byte grpPR   :3;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} TSCR2STR;
extern volatile TSCR2STR _TSCR2 @(REG_BASE + 0x0000004DUL);
#define TSCR2                           _TSCR2.Byte
#define TSCR2_PR0                       _TSCR2.Bits.PR0
#define TSCR2_PR1                       _TSCR2.Bits.PR1
#define TSCR2_PR2                       _TSCR2.Bits.PR2
#define TSCR2_TCRE                      _TSCR2.Bits.TCRE
#define TSCR2_TOI                       _TSCR2.Bits.TOI
#define TSCR2_PR                        _TSCR2.MergedBits.grpPR

#define TSCR2_PR0_MASK                  1U
#define TSCR2_PR1_MASK                  2U
#define TSCR2_PR2_MASK                  4U
#define TSCR2_TCRE_MASK                 8U
#define TSCR2_TOI_MASK                  128U
#define TSCR2_PR_MASK                   7U
#define TSCR2_PR_BITNUM                 0U


/*** TFLG1 - Main Timer Interrupt Flag 1; 0x0000004E ***/
typedef union {
  byte Byte;
  struct {
    byte C0F         :1;                                       /* Input Capture/Output Compare Channel Flag 0 */
    byte C1F         :1;                                       /* Input Capture/Output Compare Channel Flag 1 */
    byte C2F         :1;                                       /* Input Capture/Output Compare Channel Flag 2 */
    byte C3F         :1;                                       /* Input Capture/Output Compare Channel Flag 3 */
    byte C4F         :1;                                       /* Input Capture/Output Compare Channel Flag 4 */
    byte C5F         :1;                                       /* Input Capture/Output Compare Channel Flag 5 */
    byte C6F         :1;                                       /* Input Capture/Output Compare Channel Flag 6 */
    byte C7F         :1;                                       /* Input Capture/Output Compare Channel Flag 7 */
  } Bits;
} TFLG1STR;
extern volatile TFLG1STR _TFLG1 @(REG_BASE + 0x0000004EUL);
#define TFLG1                           _TFLG1.Byte
#define TFLG1_C0F                       _TFLG1.Bits.C0F
#define TFLG1_C1F                       _TFLG1.Bits.C1F
#define TFLG1_C2F                       _TFLG1.Bits.C2F
#define TFLG1_C3F                       _TFLG1.Bits.C3F
#define TFLG1_C4F                       _TFLG1.Bits.C4F
#define TFLG1_C5F                       _TFLG1.Bits.C5F
#define TFLG1_C6F                       _TFLG1.Bits.C6F
#define TFLG1_C7F                       _TFLG1.Bits.C7F

#define TFLG1_C0F_MASK                  1U
#define TFLG1_C1F_MASK                  2U
#define TFLG1_C2F_MASK                  4U
#define TFLG1_C3F_MASK                  8U
#define TFLG1_C4F_MASK                  16U
#define TFLG1_C5F_MASK                  32U
#define TFLG1_C6F_MASK                  64U
#define TFLG1_C7F_MASK                  128U


/*** TFLG2 - Main Timer Interrupt Flag 2; 0x0000004F ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte TOF         :1;                                       /* Timer Overflow Flag */
  } Bits;
} TFLG2STR;
extern volatile TFLG2STR _TFLG2 @(REG_BASE + 0x0000004FUL);
#define TFLG2                           _TFLG2.Byte
#define TFLG2_TOF                       _TFLG2.Bits.TOF

#define TFLG2_TOF_MASK                  128U


/*** TC0 - Timer Input Capture/Output Compare Register 0; 0x00000050 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** TC0Hi - Timer Input Capture/Output Compare Register 0 High; 0x00000050 ***/
    union {
      byte Byte;
    } TC0HiSTR;
    #define TC0Hi                       _TC0.Overlap_STR.TC0HiSTR.Byte
    

    /*** TC0Lo - Timer Input Capture/Output Compare Register 0 Low; 0x00000051 ***/
    union {
      byte Byte;
    } TC0LoSTR;
    #define TC0Lo                       _TC0.Overlap_STR.TC0LoSTR.Byte
    
  } Overlap_STR;

} TC0STR;
extern volatile TC0STR _TC0 @(REG_BASE + 0x00000050UL);
#define TC0                             _TC0.Word
/* TC_ARR: Access 8 TCx registers in an array */
#define TC_ARR                          ((volatile word *) &TC0)


/*** TC1 - Timer Input Capture/Output Compare Register 1; 0x00000052 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** TC1Hi - Timer Input Capture/Output Compare Register 1 High; 0x00000052 ***/
    union {
      byte Byte;
    } TC1HiSTR;
    #define TC1Hi                       _TC1.Overlap_STR.TC1HiSTR.Byte
    

    /*** TC1Lo - Timer Input Capture/Output Compare Register 1 Low; 0x00000053 ***/
    union {
      byte Byte;
    } TC1LoSTR;
    #define TC1Lo                       _TC1.Overlap_STR.TC1LoSTR.Byte
    
  } Overlap_STR;

} TC1STR;
extern volatile TC1STR _TC1 @(REG_BASE + 0x00000052UL);
#define TC1                             _TC1.Word


/*** TC2 - Timer Input Capture/Output Compare Register 2; 0x00000054 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** TC2Hi - Timer Input Capture/Output Compare Register 2 High; 0x00000054 ***/
    union {
      byte Byte;
    } TC2HiSTR;
    #define TC2Hi                       _TC2.Overlap_STR.TC2HiSTR.Byte
    

    /*** TC2Lo - Timer Input Capture/Output Compare Register 2 Low; 0x00000055 ***/
    union {
      byte Byte;
    } TC2LoSTR;
    #define TC2Lo                       _TC2.Overlap_STR.TC2LoSTR.Byte
    
  } Overlap_STR;

} TC2STR;
extern volatile TC2STR _TC2 @(REG_BASE + 0x00000054UL);
#define TC2                             _TC2.Word


/*** TC3 - Timer Input Capture/Output Compare Register 3; 0x00000056 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** TC3Hi - Timer Input Capture/Output Compare Register 3 High; 0x00000056 ***/
    union {
      byte Byte;
    } TC3HiSTR;
    #define TC3Hi                       _TC3.Overlap_STR.TC3HiSTR.Byte
    

    /*** TC3Lo - Timer Input Capture/Output Compare Register 3 Low; 0x00000057 ***/
    union {
      byte Byte;
    } TC3LoSTR;
    #define TC3Lo                       _TC3.Overlap_STR.TC3LoSTR.Byte
    
  } Overlap_STR;

} TC3STR;
extern volatile TC3STR _TC3 @(REG_BASE + 0x00000056UL);
#define TC3                             _TC3.Word


/*** TC4 - Timer Input Capture/Output Compare Register 4; 0x00000058 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** TC4Hi - Timer Input Capture/Output Compare Register 4 High; 0x00000058 ***/
    union {
      byte Byte;
    } TC4HiSTR;
    #define TC4Hi                       _TC4.Overlap_STR.TC4HiSTR.Byte
    

    /*** TC4Lo - Timer Input Capture/Output Compare Register 4 Low; 0x00000059 ***/
    union {
      byte Byte;
    } TC4LoSTR;
    #define TC4Lo                       _TC4.Overlap_STR.TC4LoSTR.Byte
    
  } Overlap_STR;

} TC4STR;
extern volatile TC4STR _TC4 @(REG_BASE + 0x00000058UL);
#define TC4                             _TC4.Word


/*** TC5 - Timer Input Capture/Output Compare Register 5; 0x0000005A ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** TC5Hi - Timer Input Capture/Output Compare Register 5 High; 0x0000005A ***/
    union {
      byte Byte;
    } TC5HiSTR;
    #define TC5Hi                       _TC5.Overlap_STR.TC5HiSTR.Byte
    

    /*** TC5Lo - Timer Input Capture/Output Compare Register 5 Low; 0x0000005B ***/
    union {
      byte Byte;
    } TC5LoSTR;
    #define TC5Lo                       _TC5.Overlap_STR.TC5LoSTR.Byte
    
  } Overlap_STR;

} TC5STR;
extern volatile TC5STR _TC5 @(REG_BASE + 0x0000005AUL);
#define TC5                             _TC5.Word


/*** TC6 - Timer Input Capture/Output Compare Register 6; 0x0000005C ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** TC6Hi - Timer Input Capture/Output Compare Register 6 High; 0x0000005C ***/
    union {
      byte Byte;
    } TC6HiSTR;
    #define TC6Hi                       _TC6.Overlap_STR.TC6HiSTR.Byte
    

    /*** TC6Lo - Timer Input Capture/Output Compare Register 6 Low; 0x0000005D ***/
    union {
      byte Byte;
    } TC6LoSTR;
    #define TC6Lo                       _TC6.Overlap_STR.TC6LoSTR.Byte
    
  } Overlap_STR;

} TC6STR;
extern volatile TC6STR _TC6 @(REG_BASE + 0x0000005CUL);
#define TC6                             _TC6.Word


/*** TC7 - Timer Input Capture/Output Compare Register 7; 0x0000005E ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** TC7Hi - Timer Input Capture/Output Compare Register 7 High; 0x0000005E ***/
    union {
      byte Byte;
    } TC7HiSTR;
    #define TC7Hi                       _TC7.Overlap_STR.TC7HiSTR.Byte
    

    /*** TC7Lo - Timer Input Capture/Output Compare Register 7 Low; 0x0000005F ***/
    union {
      byte Byte;
    } TC7LoSTR;
    #define TC7Lo                       _TC7.Overlap_STR.TC7LoSTR.Byte
    
  } Overlap_STR;

} TC7STR;
extern volatile TC7STR _TC7 @(REG_BASE + 0x0000005EUL);
#define TC7                             _TC7.Word


/*** PACTL - 16-Bit Pulse Accumulator A Control Register; 0x00000060 ***/
typedef union {
  byte Byte;
  struct {
    byte PAI         :1;                                       /* Pulse Accumulator Input Interrupt enable */
    byte PAOVI       :1;                                       /* Pulse Accumulator A Overflow Interrupt enable */
    byte CLK0        :1;                                       /* Clock Select Bit 0 */
    byte CLK1        :1;                                       /* Clock Select Bit 1 */
    byte PEDGE       :1;                                       /* Pulse Accumulator Edge Control */
    byte PAMOD       :1;                                       /* Pulse Accumulator Mode */
    byte PAEN        :1;                                       /* Pulse Accumulator A System Enable */
    byte             :1; 
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte grpCLK  :2;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} PACTLSTR;
extern volatile PACTLSTR _PACTL @(REG_BASE + 0x00000060UL);
#define PACTL                           _PACTL.Byte
#define PACTL_PAI                       _PACTL.Bits.PAI
#define PACTL_PAOVI                     _PACTL.Bits.PAOVI
#define PACTL_CLK0                      _PACTL.Bits.CLK0
#define PACTL_CLK1                      _PACTL.Bits.CLK1
#define PACTL_PEDGE                     _PACTL.Bits.PEDGE
#define PACTL_PAMOD                     _PACTL.Bits.PAMOD
#define PACTL_PAEN                      _PACTL.Bits.PAEN
#define PACTL_CLK                       _PACTL.MergedBits.grpCLK

#define PACTL_PAI_MASK                  1U
#define PACTL_PAOVI_MASK                2U
#define PACTL_CLK0_MASK                 4U
#define PACTL_CLK1_MASK                 8U
#define PACTL_PEDGE_MASK                16U
#define PACTL_PAMOD_MASK                32U
#define PACTL_PAEN_MASK                 64U
#define PACTL_CLK_MASK                  12U
#define PACTL_CLK_BITNUM                2U


/*** PAFLG - Pulse Accumulator A Flag Register; 0x00000061 ***/
typedef union {
  byte Byte;
  struct {
    byte PAIF        :1;                                       /* Pulse Accumulator Input edge Flag */
    byte PAOVF       :1;                                       /* Pulse Accumulator A Overflow Flag */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} PAFLGSTR;
extern volatile PAFLGSTR _PAFLG @(REG_BASE + 0x00000061UL);
#define PAFLG                           _PAFLG.Byte
#define PAFLG_PAIF                      _PAFLG.Bits.PAIF
#define PAFLG_PAOVF                     _PAFLG.Bits.PAOVF

#define PAFLG_PAIF_MASK                 1U
#define PAFLG_PAOVF_MASK                2U


/*** PACNT - Pulse Accumulators Count Register; 0x00000062 ***/
typedef union {
  word Word;
} PACNTSTR;
extern volatile PACNTSTR _PACNT @(REG_BASE + 0x00000062UL);
#define PACNT                           _PACNT.Word


/*** ATDCTL01 - ATD Control Register 01; 0x00000080 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATDCTL0 - ATD Control Register 0; 0x00000080 ***/
    union {
      byte Byte;
      struct {
        byte WRAP0       :1;                                       /* Wrap Around Channel Select Bit 0 */
        byte WRAP1       :1;                                       /* Wrap Around Channel Select Bit 1 */
        byte WRAP2       :1;                                       /* Wrap Around Channel Select Bit 2 */
        byte WRAP3       :1;                                       /* Wrap Around Channel Select Bit 3 */
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
      } Bits;
      struct {
        byte grpWRAP :4;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
      } MergedBits;
    } ATDCTL0STR;
    #define ATDCTL0                     _ATDCTL01.Overlap_STR.ATDCTL0STR.Byte
    #define ATDCTL0_WRAP0               _ATDCTL01.Overlap_STR.ATDCTL0STR.Bits.WRAP0
    #define ATDCTL0_WRAP1               _ATDCTL01.Overlap_STR.ATDCTL0STR.Bits.WRAP1
    #define ATDCTL0_WRAP2               _ATDCTL01.Overlap_STR.ATDCTL0STR.Bits.WRAP2
    #define ATDCTL0_WRAP3               _ATDCTL01.Overlap_STR.ATDCTL0STR.Bits.WRAP3
    /* ATDCTL_ARR: Access 6 ATDCTLx registers in an array */
    #define ATDCTL_ARR                  ((volatile byte *) &ATDCTL0)
    #define ATDCTL0_WRAP                _ATDCTL01.Overlap_STR.ATDCTL0STR.MergedBits.grpWRAP
    
    #define ATDCTL0_WRAP0_MASK          1U
    #define ATDCTL0_WRAP1_MASK          2U
    #define ATDCTL0_WRAP2_MASK          4U
    #define ATDCTL0_WRAP3_MASK          8U
    #define ATDCTL0_WRAP_MASK           15U
    #define ATDCTL0_WRAP_BITNUM         0U
    

    /*** ATDCTL1 - ATD Control Register 1; 0x00000081 ***/
    union {
      byte Byte;
      struct {
        byte ETRIGCH0    :1;                                       /* External Trigger Channel Select Bit 0 */
        byte ETRIGCH1    :1;                                       /* External Trigger Channel Select Bit 1 */
        byte ETRIGCH2    :1;                                       /* External Trigger Channel Select Bit 2 */
        byte ETRIGCH3    :1;                                       /* External Trigger Channel Select Bit 3 */
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte ETRIGSEL    :1;                                       /* External Trigger Source Select */
      } Bits;
      struct {
        byte grpETRIGCH :4;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
      } MergedBits;
    } ATDCTL1STR;
    #define ATDCTL1                     _ATDCTL01.Overlap_STR.ATDCTL1STR.Byte
    #define ATDCTL1_ETRIGCH0            _ATDCTL01.Overlap_STR.ATDCTL1STR.Bits.ETRIGCH0
    #define ATDCTL1_ETRIGCH1            _ATDCTL01.Overlap_STR.ATDCTL1STR.Bits.ETRIGCH1
    #define ATDCTL1_ETRIGCH2            _ATDCTL01.Overlap_STR.ATDCTL1STR.Bits.ETRIGCH2
    #define ATDCTL1_ETRIGCH3            _ATDCTL01.Overlap_STR.ATDCTL1STR.Bits.ETRIGCH3
    #define ATDCTL1_ETRIGSEL            _ATDCTL01.Overlap_STR.ATDCTL1STR.Bits.ETRIGSEL
    #define ATDCTL1_ETRIGCH             _ATDCTL01.Overlap_STR.ATDCTL1STR.MergedBits.grpETRIGCH
    
    #define ATDCTL1_ETRIGCH0_MASK       1U
    #define ATDCTL1_ETRIGCH1_MASK       2U
    #define ATDCTL1_ETRIGCH2_MASK       4U
    #define ATDCTL1_ETRIGCH3_MASK       8U
    #define ATDCTL1_ETRIGSEL_MASK       128U
    #define ATDCTL1_ETRIGCH_MASK        15U
    #define ATDCTL1_ETRIGCH_BITNUM      0U
    
  } Overlap_STR;

  struct {
    word ETRIGCH0    :1;                                       /* External Trigger Channel Select Bit 0 */
    word ETRIGCH1    :1;                                       /* External Trigger Channel Select Bit 1 */
    word ETRIGCH2    :1;                                       /* External Trigger Channel Select Bit 2 */
    word ETRIGCH3    :1;                                       /* External Trigger Channel Select Bit 3 */
    word             :1; 
    word             :1; 
    word             :1; 
    word ETRIGSEL    :1;                                       /* External Trigger Source Select */
    word WRAP0       :1;                                       /* Wrap Around Channel Select Bit 0 */
    word WRAP1       :1;                                       /* Wrap Around Channel Select Bit 1 */
    word WRAP2       :1;                                       /* Wrap Around Channel Select Bit 2 */
    word WRAP3       :1;                                       /* Wrap Around Channel Select Bit 3 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
  struct {
    word grpETRIGCH :4;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpWRAP :4;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} ATDCTL01STR;
extern volatile ATDCTL01STR _ATDCTL01 @(REG_BASE + 0x00000080UL);
#define ATDCTL01                        _ATDCTL01.Word
#define ATDCTL01_ETRIGCH0               _ATDCTL01.Bits.ETRIGCH0
#define ATDCTL01_ETRIGCH1               _ATDCTL01.Bits.ETRIGCH1
#define ATDCTL01_ETRIGCH2               _ATDCTL01.Bits.ETRIGCH2
#define ATDCTL01_ETRIGCH3               _ATDCTL01.Bits.ETRIGCH3
#define ATDCTL01_ETRIGSEL               _ATDCTL01.Bits.ETRIGSEL
#define ATDCTL01_WRAP0                  _ATDCTL01.Bits.WRAP0
#define ATDCTL01_WRAP1                  _ATDCTL01.Bits.WRAP1
#define ATDCTL01_WRAP2                  _ATDCTL01.Bits.WRAP2
#define ATDCTL01_WRAP3                  _ATDCTL01.Bits.WRAP3
#define ATDCTL01_ETRIGCH                _ATDCTL01.MergedBits.grpETRIGCH
#define ATDCTL01_WRAP                   _ATDCTL01.MergedBits.grpWRAP

#define ATDCTL01_ETRIGCH0_MASK          1U
#define ATDCTL01_ETRIGCH1_MASK          2U
#define ATDCTL01_ETRIGCH2_MASK          4U
#define ATDCTL01_ETRIGCH3_MASK          8U
#define ATDCTL01_ETRIGSEL_MASK          128U
#define ATDCTL01_WRAP0_MASK             256U
#define ATDCTL01_WRAP1_MASK             512U
#define ATDCTL01_WRAP2_MASK             1024U
#define ATDCTL01_WRAP3_MASK             2048U
#define ATDCTL01_ETRIGCH_MASK           15U
#define ATDCTL01_ETRIGCH_BITNUM         0U
#define ATDCTL01_WRAP_MASK              3840U
#define ATDCTL01_WRAP_BITNUM            8U


/*** ATDCTL23 - ATD Control Register 23; 0x00000082 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATDCTL2 - ATD Control Register 2; 0x00000082 ***/
    union {
      byte Byte;
      struct {
        byte ASCIF       :1;                                       /* ATD Sequence Complete Interrupt Flag */
        byte ASCIE       :1;                                       /* ATD Sequence Complete Interrupt Enable */
        byte ETRIGE      :1;                                       /* External Trigger Mode enable */
        byte ETRIGP      :1;                                       /* External Trigger Polarity */
        byte ETRIGLE     :1;                                       /* External Trigger Level/Edge control */
        byte AWAI        :1;                                       /* ATD Power Down in Wait Mode */
        byte AFFC        :1;                                       /* ATD Fast Conversion Complete Flag Clear */
        byte ADPU        :1;                                       /* ATD Disable / Power Down */
      } Bits;
    } ATDCTL2STR;
    #define ATDCTL2                     _ATDCTL23.Overlap_STR.ATDCTL2STR.Byte
    #define ATDCTL2_ASCIF               _ATDCTL23.Overlap_STR.ATDCTL2STR.Bits.ASCIF
    #define ATDCTL2_ASCIE               _ATDCTL23.Overlap_STR.ATDCTL2STR.Bits.ASCIE
    #define ATDCTL2_ETRIGE              _ATDCTL23.Overlap_STR.ATDCTL2STR.Bits.ETRIGE
    #define ATDCTL2_ETRIGP              _ATDCTL23.Overlap_STR.ATDCTL2STR.Bits.ETRIGP
    #define ATDCTL2_ETRIGLE             _ATDCTL23.Overlap_STR.ATDCTL2STR.Bits.ETRIGLE
    #define ATDCTL2_AWAI                _ATDCTL23.Overlap_STR.ATDCTL2STR.Bits.AWAI
    #define ATDCTL2_AFFC                _ATDCTL23.Overlap_STR.ATDCTL2STR.Bits.AFFC
    #define ATDCTL2_ADPU                _ATDCTL23.Overlap_STR.ATDCTL2STR.Bits.ADPU
    
    #define ATDCTL2_ASCIF_MASK          1U
    #define ATDCTL2_ASCIE_MASK          2U
    #define ATDCTL2_ETRIGE_MASK         4U
    #define ATDCTL2_ETRIGP_MASK         8U
    #define ATDCTL2_ETRIGLE_MASK        16U
    #define ATDCTL2_AWAI_MASK           32U
    #define ATDCTL2_AFFC_MASK           64U
    #define ATDCTL2_ADPU_MASK           128U
    

    /*** ATDCTL3 - ATD Control Register 3; 0x00000083 ***/
    union {
      byte Byte;
      struct {
        byte FRZ0        :1;                                       /* Background Debug Freeze Enable Bit 0 */
        byte FRZ1        :1;                                       /* Background Debug Freeze Enable Bit 1 */
        byte FIFO        :1;                                       /* Result Register FIFO Mode */
        byte S1C         :1;                                       /* Conversion Sequence Length 1 */
        byte S2C         :1;                                       /* Conversion Sequence Length 2 */
        byte S4C         :1;                                       /* Conversion Sequence Length 4 */
        byte S8C         :1;                                       /* Conversion Sequence Length 8 */
        byte             :1; 
      } Bits;
      struct {
        byte grpFRZ :2;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
      } MergedBits;
    } ATDCTL3STR;
    #define ATDCTL3                     _ATDCTL23.Overlap_STR.ATDCTL3STR.Byte
    #define ATDCTL3_FRZ0                _ATDCTL23.Overlap_STR.ATDCTL3STR.Bits.FRZ0
    #define ATDCTL3_FRZ1                _ATDCTL23.Overlap_STR.ATDCTL3STR.Bits.FRZ1
    #define ATDCTL3_FIFO                _ATDCTL23.Overlap_STR.ATDCTL3STR.Bits.FIFO
    #define ATDCTL3_S1C                 _ATDCTL23.Overlap_STR.ATDCTL3STR.Bits.S1C
    #define ATDCTL3_S2C                 _ATDCTL23.Overlap_STR.ATDCTL3STR.Bits.S2C
    #define ATDCTL3_S4C                 _ATDCTL23.Overlap_STR.ATDCTL3STR.Bits.S4C
    #define ATDCTL3_S8C                 _ATDCTL23.Overlap_STR.ATDCTL3STR.Bits.S8C
    #define ATDCTL3_FRZ                 _ATDCTL23.Overlap_STR.ATDCTL3STR.MergedBits.grpFRZ
    
    #define ATDCTL3_FRZ0_MASK           1U
    #define ATDCTL3_FRZ1_MASK           2U
    #define ATDCTL3_FIFO_MASK           4U
    #define ATDCTL3_S1C_MASK            8U
    #define ATDCTL3_S2C_MASK            16U
    #define ATDCTL3_S4C_MASK            32U
    #define ATDCTL3_S8C_MASK            64U
    #define ATDCTL3_FRZ_MASK            3U
    #define ATDCTL3_FRZ_BITNUM          0U
    
  } Overlap_STR;

  struct {
    word FRZ0        :1;                                       /* Background Debug Freeze Enable Bit 0 */
    word FRZ1        :1;                                       /* Background Debug Freeze Enable Bit 1 */
    word FIFO        :1;                                       /* Result Register FIFO Mode */
    word S1C         :1;                                       /* Conversion Sequence Length 1 */
    word S2C         :1;                                       /* Conversion Sequence Length 2 */
    word S4C         :1;                                       /* Conversion Sequence Length 4 */
    word S8C         :1;                                       /* Conversion Sequence Length 8 */
    word             :1; 
    word ASCIF       :1;                                       /* ATD Sequence Complete Interrupt Flag */
    word ASCIE       :1;                                       /* ATD Sequence Complete Interrupt Enable */
    word ETRIGE      :1;                                       /* External Trigger Mode enable */
    word ETRIGP      :1;                                       /* External Trigger Polarity */
    word ETRIGLE     :1;                                       /* External Trigger Level/Edge control */
    word AWAI        :1;                                       /* ATD Power Down in Wait Mode */
    word AFFC        :1;                                       /* ATD Fast Conversion Complete Flag Clear */
    word ADPU        :1;                                       /* ATD Disable / Power Down */
  } Bits;
  struct {
    word grpFRZ  :2;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} ATDCTL23STR;
extern volatile ATDCTL23STR _ATDCTL23 @(REG_BASE + 0x00000082UL);
#define ATDCTL23                        _ATDCTL23.Word
#define ATDCTL23_FRZ0                   _ATDCTL23.Bits.FRZ0
#define ATDCTL23_FRZ1                   _ATDCTL23.Bits.FRZ1
#define ATDCTL23_FIFO                   _ATDCTL23.Bits.FIFO
#define ATDCTL23_S1C                    _ATDCTL23.Bits.S1C
#define ATDCTL23_S2C                    _ATDCTL23.Bits.S2C
#define ATDCTL23_S4C                    _ATDCTL23.Bits.S4C
#define ATDCTL23_S8C                    _ATDCTL23.Bits.S8C
#define ATDCTL23_ASCIF                  _ATDCTL23.Bits.ASCIF
#define ATDCTL23_ASCIE                  _ATDCTL23.Bits.ASCIE
#define ATDCTL23_ETRIGE                 _ATDCTL23.Bits.ETRIGE
#define ATDCTL23_ETRIGP                 _ATDCTL23.Bits.ETRIGP
#define ATDCTL23_ETRIGLE                _ATDCTL23.Bits.ETRIGLE
#define ATDCTL23_AWAI                   _ATDCTL23.Bits.AWAI
#define ATDCTL23_AFFC                   _ATDCTL23.Bits.AFFC
#define ATDCTL23_ADPU                   _ATDCTL23.Bits.ADPU
#define ATDCTL23_FRZ                    _ATDCTL23.MergedBits.grpFRZ

#define ATDCTL23_FRZ0_MASK              1U
#define ATDCTL23_FRZ1_MASK              2U
#define ATDCTL23_FIFO_MASK              4U
#define ATDCTL23_S1C_MASK               8U
#define ATDCTL23_S2C_MASK               16U
#define ATDCTL23_S4C_MASK               32U
#define ATDCTL23_S8C_MASK               64U
#define ATDCTL23_ASCIF_MASK             256U
#define ATDCTL23_ASCIE_MASK             512U
#define ATDCTL23_ETRIGE_MASK            1024U
#define ATDCTL23_ETRIGP_MASK            2048U
#define ATDCTL23_ETRIGLE_MASK           4096U
#define ATDCTL23_AWAI_MASK              8192U
#define ATDCTL23_AFFC_MASK              16384U
#define ATDCTL23_ADPU_MASK              32768U
#define ATDCTL23_FRZ_MASK               3U
#define ATDCTL23_FRZ_BITNUM             0U


/*** ATDCTL45 - ATD Control Register; 0x00000084 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATDCTL4 - ATD Control Register 4; 0x00000084 ***/
    union {
      byte Byte;
      struct {
        byte PRS0        :1;                                       /* ATD Clock Prescaler 0 */
        byte PRS1        :1;                                       /* ATD Clock Prescaler 1 */
        byte PRS2        :1;                                       /* ATD Clock Prescaler 2 */
        byte PRS3        :1;                                       /* ATD Clock Prescaler 3 */
        byte PRS4        :1;                                       /* ATD Clock Prescaler 4 */
        byte SMP0        :1;                                       /* Sample Time Select 0 */
        byte SMP1        :1;                                       /* Sample Time Select 1 */
        byte SRES8       :1;                                       /* ATD Resolution Select */
      } Bits;
      struct {
        byte grpPRS :5;
        byte grpSMP :2;
        byte grpSRES_8 :1;
      } MergedBits;
    } ATDCTL4STR;
    #define ATDCTL4                     _ATDCTL45.Overlap_STR.ATDCTL4STR.Byte
    #define ATDCTL4_PRS0                _ATDCTL45.Overlap_STR.ATDCTL4STR.Bits.PRS0
    #define ATDCTL4_PRS1                _ATDCTL45.Overlap_STR.ATDCTL4STR.Bits.PRS1
    #define ATDCTL4_PRS2                _ATDCTL45.Overlap_STR.ATDCTL4STR.Bits.PRS2
    #define ATDCTL4_PRS3                _ATDCTL45.Overlap_STR.ATDCTL4STR.Bits.PRS3
    #define ATDCTL4_PRS4                _ATDCTL45.Overlap_STR.ATDCTL4STR.Bits.PRS4
    #define ATDCTL4_SMP0                _ATDCTL45.Overlap_STR.ATDCTL4STR.Bits.SMP0
    #define ATDCTL4_SMP1                _ATDCTL45.Overlap_STR.ATDCTL4STR.Bits.SMP1
    #define ATDCTL4_SRES8               _ATDCTL45.Overlap_STR.ATDCTL4STR.Bits.SRES8
    #define ATDCTL4_PRS                 _ATDCTL45.Overlap_STR.ATDCTL4STR.MergedBits.grpPRS
    #define ATDCTL4_SMP                 _ATDCTL45.Overlap_STR.ATDCTL4STR.MergedBits.grpSMP
    
    #define ATDCTL4_PRS0_MASK           1U
    #define ATDCTL4_PRS1_MASK           2U
    #define ATDCTL4_PRS2_MASK           4U
    #define ATDCTL4_PRS3_MASK           8U
    #define ATDCTL4_PRS4_MASK           16U
    #define ATDCTL4_SMP0_MASK           32U
    #define ATDCTL4_SMP1_MASK           64U
    #define ATDCTL4_SRES8_MASK          128U
    #define ATDCTL4_PRS_MASK            31U
    #define ATDCTL4_PRS_BITNUM          0U
    #define ATDCTL4_SMP_MASK            96U
    #define ATDCTL4_SMP_BITNUM          5U
    

    /*** ATDCTL5 - ATD Control Register 5; 0x00000085 ***/
    union {
      byte Byte;
      struct {
        byte CA          :1;                                       /* Analog Input Channel Select Code A */
        byte CB          :1;                                       /* Analog Input Channel Select Code B */
        byte CC          :1;                                       /* Analog Input Channel Select Code C */
        byte CD          :1;                                       /* Analog Input Channel Select Code D */
        byte MULT        :1;                                       /* Multi-Channel Sample Mode */
        byte SCAN        :1;                                       /* Continuous Conversion Sequence Mode */
        byte DSGN        :1;                                       /* Signed/Unsigned Result Data Mode */
        byte DJM         :1;                                       /* Result Register Data Justification Mode */
      } Bits;
      struct {
        byte grpCx :4;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
      } MergedBits;
    } ATDCTL5STR;
    #define ATDCTL5                     _ATDCTL45.Overlap_STR.ATDCTL5STR.Byte
    #define ATDCTL5_CA                  _ATDCTL45.Overlap_STR.ATDCTL5STR.Bits.CA
    #define ATDCTL5_CB                  _ATDCTL45.Overlap_STR.ATDCTL5STR.Bits.CB
    #define ATDCTL5_CC                  _ATDCTL45.Overlap_STR.ATDCTL5STR.Bits.CC
    #define ATDCTL5_CD                  _ATDCTL45.Overlap_STR.ATDCTL5STR.Bits.CD
    #define ATDCTL5_MULT                _ATDCTL45.Overlap_STR.ATDCTL5STR.Bits.MULT
    #define ATDCTL5_SCAN                _ATDCTL45.Overlap_STR.ATDCTL5STR.Bits.SCAN
    #define ATDCTL5_DSGN                _ATDCTL45.Overlap_STR.ATDCTL5STR.Bits.DSGN
    #define ATDCTL5_DJM                 _ATDCTL45.Overlap_STR.ATDCTL5STR.Bits.DJM
    #define ATDCTL5_Cx                  _ATDCTL45.Overlap_STR.ATDCTL5STR.MergedBits.grpCx
    
    #define ATDCTL5_CA_MASK             1U
    #define ATDCTL5_CB_MASK             2U
    #define ATDCTL5_CC_MASK             4U
    #define ATDCTL5_CD_MASK             8U
    #define ATDCTL5_MULT_MASK           16U
    #define ATDCTL5_SCAN_MASK           32U
    #define ATDCTL5_DSGN_MASK           64U
    #define ATDCTL5_DJM_MASK            128U
    #define ATDCTL5_Cx_MASK             15U
    #define ATDCTL5_Cx_BITNUM           0U
    
  } Overlap_STR;

  struct {
    word CA          :1;                                       /* Analog Input Channel Select Code A */
    word CB          :1;                                       /* Analog Input Channel Select Code B */
    word CC          :1;                                       /* Analog Input Channel Select Code C */
    word CD          :1;                                       /* Analog Input Channel Select Code D */
    word MULT        :1;                                       /* Multi-Channel Sample Mode */
    word SCAN        :1;                                       /* Continuous Conversion Sequence Mode */
    word DSGN        :1;                                       /* Signed/Unsigned Result Data Mode */
    word DJM         :1;                                       /* Result Register Data Justification Mode */
    word PRS0        :1;                                       /* ATD Clock Prescaler 0 */
    word PRS1        :1;                                       /* ATD Clock Prescaler 1 */
    word PRS2        :1;                                       /* ATD Clock Prescaler 2 */
    word PRS3        :1;                                       /* ATD Clock Prescaler 3 */
    word PRS4        :1;                                       /* ATD Clock Prescaler 4 */
    word SMP0        :1;                                       /* Sample Time Select 0 */
    word SMP1        :1;                                       /* Sample Time Select 1 */
    word SRES8       :1;                                       /* ATD Resolution Select */
  } Bits;
  struct {
    word grpCx   :4;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpPRS  :5;
    word grpSMP  :2;
    word grpSRES_8 :1;
  } MergedBits;
} ATDCTL45STR;
extern volatile ATDCTL45STR _ATDCTL45 @(REG_BASE + 0x00000084UL);
#define ATDCTL45                        _ATDCTL45.Word
#define ATDCTL45_CA                     _ATDCTL45.Bits.CA
#define ATDCTL45_CB                     _ATDCTL45.Bits.CB
#define ATDCTL45_CC                     _ATDCTL45.Bits.CC
#define ATDCTL45_CD                     _ATDCTL45.Bits.CD
#define ATDCTL45_MULT                   _ATDCTL45.Bits.MULT
#define ATDCTL45_SCAN                   _ATDCTL45.Bits.SCAN
#define ATDCTL45_DSGN                   _ATDCTL45.Bits.DSGN
#define ATDCTL45_DJM                    _ATDCTL45.Bits.DJM
#define ATDCTL45_PRS0                   _ATDCTL45.Bits.PRS0
#define ATDCTL45_PRS1                   _ATDCTL45.Bits.PRS1
#define ATDCTL45_PRS2                   _ATDCTL45.Bits.PRS2
#define ATDCTL45_PRS3                   _ATDCTL45.Bits.PRS3
#define ATDCTL45_PRS4                   _ATDCTL45.Bits.PRS4
#define ATDCTL45_SMP0                   _ATDCTL45.Bits.SMP0
#define ATDCTL45_SMP1                   _ATDCTL45.Bits.SMP1
#define ATDCTL45_SRES8                  _ATDCTL45.Bits.SRES8
#define ATDCTL45_Cx                     _ATDCTL45.MergedBits.grpCx
#define ATDCTL45_PRS                    _ATDCTL45.MergedBits.grpPRS
#define ATDCTL45_SMP                    _ATDCTL45.MergedBits.grpSMP

#define ATDCTL45_CA_MASK                1U
#define ATDCTL45_CB_MASK                2U
#define ATDCTL45_CC_MASK                4U
#define ATDCTL45_CD_MASK                8U
#define ATDCTL45_MULT_MASK              16U
#define ATDCTL45_SCAN_MASK              32U
#define ATDCTL45_DSGN_MASK              64U
#define ATDCTL45_DJM_MASK               128U
#define ATDCTL45_PRS0_MASK              256U
#define ATDCTL45_PRS1_MASK              512U
#define ATDCTL45_PRS2_MASK              1024U
#define ATDCTL45_PRS3_MASK              2048U
#define ATDCTL45_PRS4_MASK              4096U
#define ATDCTL45_SMP0_MASK              8192U
#define ATDCTL45_SMP1_MASK              16384U
#define ATDCTL45_SRES8_MASK             32768U
#define ATDCTL45_Cx_MASK                15U
#define ATDCTL45_Cx_BITNUM              0U
#define ATDCTL45_PRS_MASK               7936U
#define ATDCTL45_PRS_BITNUM             8U
#define ATDCTL45_SMP_MASK               24576U
#define ATDCTL45_SMP_BITNUM             13U


/*** ATDSTAT0 - ATD Status Register 0; 0x00000086 ***/
typedef union {
  byte Byte;
  struct {
    byte CC0         :1;                                       /* Conversion Counter 0 */
    byte CC1         :1;                                       /* Conversion Counter 1 */
    byte CC2         :1;                                       /* Conversion Counter 2 */
    byte CC3         :1;                                       /* Conversion Counter 3 */
    byte FIFOR       :1;                                       /* FIFO Over Run Flag */
    byte ETORF       :1;                                       /* External Trigger Overrun Flag */
    byte             :1; 
    byte SCF         :1;                                       /* Sequence Complete Flag */
  } Bits;
  struct {
    byte grpCC   :4;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} ATDSTAT0STR;
extern volatile ATDSTAT0STR _ATDSTAT0 @(REG_BASE + 0x00000086UL);
#define ATDSTAT0                        _ATDSTAT0.Byte
#define ATDSTAT0_CC0                    _ATDSTAT0.Bits.CC0
#define ATDSTAT0_CC1                    _ATDSTAT0.Bits.CC1
#define ATDSTAT0_CC2                    _ATDSTAT0.Bits.CC2
#define ATDSTAT0_CC3                    _ATDSTAT0.Bits.CC3
#define ATDSTAT0_FIFOR                  _ATDSTAT0.Bits.FIFOR
#define ATDSTAT0_ETORF                  _ATDSTAT0.Bits.ETORF
#define ATDSTAT0_SCF                    _ATDSTAT0.Bits.SCF
#define ATDSTAT0_CC                     _ATDSTAT0.MergedBits.grpCC

#define ATDSTAT0_CC0_MASK               1U
#define ATDSTAT0_CC1_MASK               2U
#define ATDSTAT0_CC2_MASK               4U
#define ATDSTAT0_CC3_MASK               8U
#define ATDSTAT0_FIFOR_MASK             16U
#define ATDSTAT0_ETORF_MASK             32U
#define ATDSTAT0_SCF_MASK               128U
#define ATDSTAT0_CC_MASK                15U
#define ATDSTAT0_CC_BITNUM              0U


/*** ATDTEST1 - ATD Test Register; 0x00000089 ***/
typedef union {
  byte Byte;
  struct {
    byte SC          :1;                                       /* Special Channel Conversion Bit */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} ATDTEST1STR;
extern volatile ATDTEST1STR _ATDTEST1 @(REG_BASE + 0x00000089UL);
#define ATDTEST1                        _ATDTEST1.Byte
#define ATDTEST1_SC                     _ATDTEST1.Bits.SC

#define ATDTEST1_SC_MASK                1U


/*** ATDSTAT2 - ATD Status Register 2; 0x0000008A ***/
typedef union {
  byte Byte;
  struct {
    byte CCF8        :1;                                       /* Conversion Complete Flag 8 */
    byte CCF9        :1;                                       /* Conversion Complete Flag 9 */
    byte CCF10       :1;                                       /* Conversion Complete Flag 10 */
    byte CCF11       :1;                                       /* Conversion Complete Flag 11 */
    byte CCF12       :1;                                       /* Conversion Complete Flag 12 */
    byte CCF13       :1;                                       /* Conversion Complete Flag 13 */
    byte CCF14       :1;                                       /* Conversion Complete Flag 14 */
    byte CCF15       :1;                                       /* Conversion Complete Flag 15 */
  } Bits;
} ATDSTAT2STR;
extern volatile ATDSTAT2STR _ATDSTAT2 @(REG_BASE + 0x0000008AUL);
#define ATDSTAT2                        _ATDSTAT2.Byte
#define ATDSTAT2_CCF8                   _ATDSTAT2.Bits.CCF8
#define ATDSTAT2_CCF9                   _ATDSTAT2.Bits.CCF9
#define ATDSTAT2_CCF10                  _ATDSTAT2.Bits.CCF10
#define ATDSTAT2_CCF11                  _ATDSTAT2.Bits.CCF11
#define ATDSTAT2_CCF12                  _ATDSTAT2.Bits.CCF12
#define ATDSTAT2_CCF13                  _ATDSTAT2.Bits.CCF13
#define ATDSTAT2_CCF14                  _ATDSTAT2.Bits.CCF14
#define ATDSTAT2_CCF15                  _ATDSTAT2.Bits.CCF15

#define ATDSTAT2_CCF8_MASK              1U
#define ATDSTAT2_CCF9_MASK              2U
#define ATDSTAT2_CCF10_MASK             4U
#define ATDSTAT2_CCF11_MASK             8U
#define ATDSTAT2_CCF12_MASK             16U
#define ATDSTAT2_CCF13_MASK             32U
#define ATDSTAT2_CCF14_MASK             64U
#define ATDSTAT2_CCF15_MASK             128U


/*** ATDSTAT1 - ATD Status Register 1; 0x0000008B ***/
typedef union {
  byte Byte;
  struct {
    byte CCF0        :1;                                       /* Conversion Complete Flag 0 */
    byte CCF1        :1;                                       /* Conversion Complete Flag 1 */
    byte CCF2        :1;                                       /* Conversion Complete Flag 2 */
    byte CCF3        :1;                                       /* Conversion Complete Flag 3 */
    byte CCF4        :1;                                       /* Conversion Complete Flag 4 */
    byte CCF5        :1;                                       /* Conversion Complete Flag 5 */
    byte CCF6        :1;                                       /* Conversion Complete Flag 6 */
    byte CCF7        :1;                                       /* Conversion Complete Flag 7 */
  } Bits;
} ATDSTAT1STR;
extern volatile ATDSTAT1STR _ATDSTAT1 @(REG_BASE + 0x0000008BUL);
#define ATDSTAT1                        _ATDSTAT1.Byte
#define ATDSTAT1_CCF0                   _ATDSTAT1.Bits.CCF0
#define ATDSTAT1_CCF1                   _ATDSTAT1.Bits.CCF1
#define ATDSTAT1_CCF2                   _ATDSTAT1.Bits.CCF2
#define ATDSTAT1_CCF3                   _ATDSTAT1.Bits.CCF3
#define ATDSTAT1_CCF4                   _ATDSTAT1.Bits.CCF4
#define ATDSTAT1_CCF5                   _ATDSTAT1.Bits.CCF5
#define ATDSTAT1_CCF6                   _ATDSTAT1.Bits.CCF6
#define ATDSTAT1_CCF7                   _ATDSTAT1.Bits.CCF7

#define ATDSTAT1_CCF0_MASK              1U
#define ATDSTAT1_CCF1_MASK              2U
#define ATDSTAT1_CCF2_MASK              4U
#define ATDSTAT1_CCF3_MASK              8U
#define ATDSTAT1_CCF4_MASK              16U
#define ATDSTAT1_CCF5_MASK              32U
#define ATDSTAT1_CCF6_MASK              64U
#define ATDSTAT1_CCF7_MASK              128U


/*** ATDDIEN - ATD Input Enable Register; 0x0000008C ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATDDIEN0 - ATD Input Enable Register 0; 0x0000008C ***/
    union {
      byte Byte;
      struct {
        byte IEN8        :1;                                       /* ATD Digital Input Enable on channel 8 */
        byte IEN9        :1;                                       /* ATD Digital Input Enable on channel 9 */
        byte IEN10       :1;                                       /* ATD Digital Input Enable on channel 10 */
        byte IEN11       :1;                                       /* ATD Digital Input Enable on channel 11 */
        byte IEN12       :1;                                       /* ATD Digital Input Enable on channel 12 */
        byte IEN13       :1;                                       /* ATD Digital Input Enable on channel 13 */
        byte IEN14       :1;                                       /* ATD Digital Input Enable on channel 14 */
        byte IEN15       :1;                                       /* ATD Digital Input Enable on channel 15 */
      } Bits;
    } ATDDIEN0STR;
    #define ATDDIEN0                    _ATDDIEN.Overlap_STR.ATDDIEN0STR.Byte
    #define ATDDIEN0_IEN8               _ATDDIEN.Overlap_STR.ATDDIEN0STR.Bits.IEN8
    #define ATDDIEN0_IEN9               _ATDDIEN.Overlap_STR.ATDDIEN0STR.Bits.IEN9
    #define ATDDIEN0_IEN10              _ATDDIEN.Overlap_STR.ATDDIEN0STR.Bits.IEN10
    #define ATDDIEN0_IEN11              _ATDDIEN.Overlap_STR.ATDDIEN0STR.Bits.IEN11
    #define ATDDIEN0_IEN12              _ATDDIEN.Overlap_STR.ATDDIEN0STR.Bits.IEN12
    #define ATDDIEN0_IEN13              _ATDDIEN.Overlap_STR.ATDDIEN0STR.Bits.IEN13
    #define ATDDIEN0_IEN14              _ATDDIEN.Overlap_STR.ATDDIEN0STR.Bits.IEN14
    #define ATDDIEN0_IEN15              _ATDDIEN.Overlap_STR.ATDDIEN0STR.Bits.IEN15
    /* ATDDIEN_ARR: Access 2 ATDDIENx registers in an array */
    #define ATDDIEN_ARR                 ((volatile byte *) &ATDDIEN0)
    
    #define ATDDIEN0_IEN8_MASK          1U
    #define ATDDIEN0_IEN9_MASK          2U
    #define ATDDIEN0_IEN10_MASK         4U
    #define ATDDIEN0_IEN11_MASK         8U
    #define ATDDIEN0_IEN12_MASK         16U
    #define ATDDIEN0_IEN13_MASK         32U
    #define ATDDIEN0_IEN14_MASK         64U
    #define ATDDIEN0_IEN15_MASK         128U
    

    /*** ATDDIEN1 - ATD Input Enable Register 1; 0x0000008D ***/
    union {
      byte Byte;
      struct {
        byte IEN0        :1;                                       /* ATD Digital Input Enable on channel 0 */
        byte IEN1        :1;                                       /* ATD Digital Input Enable on channel 1 */
        byte IEN2        :1;                                       /* ATD Digital Input Enable on channel 2 */
        byte IEN3        :1;                                       /* ATD Digital Input Enable on channel 3 */
        byte IEN4        :1;                                       /* ATD Digital Input Enable on channel 4 */
        byte IEN5        :1;                                       /* ATD Digital Input Enable on channel 5 */
        byte IEN6        :1;                                       /* ATD Digital Input Enable on channel 6 */
        byte IEN7        :1;                                       /* ATD Digital Input Enable on channel 7 */
      } Bits;
    } ATDDIEN1STR;
    #define ATDDIEN1                    _ATDDIEN.Overlap_STR.ATDDIEN1STR.Byte
    #define ATDDIEN1_IEN0               _ATDDIEN.Overlap_STR.ATDDIEN1STR.Bits.IEN0
    #define ATDDIEN1_IEN1               _ATDDIEN.Overlap_STR.ATDDIEN1STR.Bits.IEN1
    #define ATDDIEN1_IEN2               _ATDDIEN.Overlap_STR.ATDDIEN1STR.Bits.IEN2
    #define ATDDIEN1_IEN3               _ATDDIEN.Overlap_STR.ATDDIEN1STR.Bits.IEN3
    #define ATDDIEN1_IEN4               _ATDDIEN.Overlap_STR.ATDDIEN1STR.Bits.IEN4
    #define ATDDIEN1_IEN5               _ATDDIEN.Overlap_STR.ATDDIEN1STR.Bits.IEN5
    #define ATDDIEN1_IEN6               _ATDDIEN.Overlap_STR.ATDDIEN1STR.Bits.IEN6
    #define ATDDIEN1_IEN7               _ATDDIEN.Overlap_STR.ATDDIEN1STR.Bits.IEN7
    
    #define ATDDIEN1_IEN0_MASK          1U
    #define ATDDIEN1_IEN1_MASK          2U
    #define ATDDIEN1_IEN2_MASK          4U
    #define ATDDIEN1_IEN3_MASK          8U
    #define ATDDIEN1_IEN4_MASK          16U
    #define ATDDIEN1_IEN5_MASK          32U
    #define ATDDIEN1_IEN6_MASK          64U
    #define ATDDIEN1_IEN7_MASK          128U
    
  } Overlap_STR;

  struct {
    word IEN0        :1;                                       /* ATD Digital Input Enable on channel 0 */
    word IEN1        :1;                                       /* ATD Digital Input Enable on channel 1 */
    word IEN2        :1;                                       /* ATD Digital Input Enable on channel 2 */
    word IEN3        :1;                                       /* ATD Digital Input Enable on channel 3 */
    word IEN4        :1;                                       /* ATD Digital Input Enable on channel 4 */
    word IEN5        :1;                                       /* ATD Digital Input Enable on channel 5 */
    word IEN6        :1;                                       /* ATD Digital Input Enable on channel 6 */
    word IEN7        :1;                                       /* ATD Digital Input Enable on channel 7 */
    word IEN8        :1;                                       /* ATD Digital Input Enable on channel 8 */
    word IEN9        :1;                                       /* ATD Digital Input Enable on channel 9 */
    word IEN10       :1;                                       /* ATD Digital Input Enable on channel 10 */
    word IEN11       :1;                                       /* ATD Digital Input Enable on channel 11 */
    word IEN12       :1;                                       /* ATD Digital Input Enable on channel 12 */
    word IEN13       :1;                                       /* ATD Digital Input Enable on channel 13 */
    word IEN14       :1;                                       /* ATD Digital Input Enable on channel 14 */
    word IEN15       :1;                                       /* ATD Digital Input Enable on channel 15 */
  } Bits;
} ATDDIENSTR;
extern volatile ATDDIENSTR _ATDDIEN @(REG_BASE + 0x0000008CUL);
#define ATDDIEN                         _ATDDIEN.Word
#define ATDDIEN_IEN0                    _ATDDIEN.Bits.IEN0
#define ATDDIEN_IEN1                    _ATDDIEN.Bits.IEN1
#define ATDDIEN_IEN2                    _ATDDIEN.Bits.IEN2
#define ATDDIEN_IEN3                    _ATDDIEN.Bits.IEN3
#define ATDDIEN_IEN4                    _ATDDIEN.Bits.IEN4
#define ATDDIEN_IEN5                    _ATDDIEN.Bits.IEN5
#define ATDDIEN_IEN6                    _ATDDIEN.Bits.IEN6
#define ATDDIEN_IEN7                    _ATDDIEN.Bits.IEN7
#define ATDDIEN_IEN8                    _ATDDIEN.Bits.IEN8
#define ATDDIEN_IEN9                    _ATDDIEN.Bits.IEN9
#define ATDDIEN_IEN10                   _ATDDIEN.Bits.IEN10
#define ATDDIEN_IEN11                   _ATDDIEN.Bits.IEN11
#define ATDDIEN_IEN12                   _ATDDIEN.Bits.IEN12
#define ATDDIEN_IEN13                   _ATDDIEN.Bits.IEN13
#define ATDDIEN_IEN14                   _ATDDIEN.Bits.IEN14
#define ATDDIEN_IEN15                   _ATDDIEN.Bits.IEN15

#define ATDDIEN_IEN0_MASK               1U
#define ATDDIEN_IEN1_MASK               2U
#define ATDDIEN_IEN2_MASK               4U
#define ATDDIEN_IEN3_MASK               8U
#define ATDDIEN_IEN4_MASK               16U
#define ATDDIEN_IEN5_MASK               32U
#define ATDDIEN_IEN6_MASK               64U
#define ATDDIEN_IEN7_MASK               128U
#define ATDDIEN_IEN8_MASK               256U
#define ATDDIEN_IEN9_MASK               512U
#define ATDDIEN_IEN10_MASK              1024U
#define ATDDIEN_IEN11_MASK              2048U
#define ATDDIEN_IEN12_MASK              4096U
#define ATDDIEN_IEN13_MASK              8192U
#define ATDDIEN_IEN14_MASK              16384U
#define ATDDIEN_IEN15_MASK              32768U


/*** PORTAD - Port AD0 Data; 0x0000008E ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** PORTAD0 - Port AD0 Data Register; 0x0000008E ***/
    union {
      byte Byte;
      struct {
        byte PTAD8       :1;                                       /* A/D Channel 8 (AN8) Digital Input */
        byte PTAD9       :1;                                       /* A/D Channel 9 (AN9) Digital Input */
        byte PTAD10      :1;                                       /* A/D Channel 10 (AN10) Digital Input */
        byte PTAD11      :1;                                       /* A/D Channel 11 (AN11) Digital Input */
        byte PTAD12      :1;                                       /* A/D Channel 12 (AN12) Digital Input */
        byte PTAD13      :1;                                       /* A/D Channel 13 (AN13) Digital Input */
        byte PTAD14      :1;                                       /* A/D Channel 14 (AN14) Digital Input */
        byte PTAD15      :1;                                       /* A/D Channel 15 (AN15) Digital Input */
      } Bits;
    } PORTAD0STR;
    #define PORTAD0                     _PORTAD.Overlap_STR.PORTAD0STR.Byte
    #define PORTAD0_PTAD8               _PORTAD.Overlap_STR.PORTAD0STR.Bits.PTAD8
    #define PORTAD0_PTAD9               _PORTAD.Overlap_STR.PORTAD0STR.Bits.PTAD9
    #define PORTAD0_PTAD10              _PORTAD.Overlap_STR.PORTAD0STR.Bits.PTAD10
    #define PORTAD0_PTAD11              _PORTAD.Overlap_STR.PORTAD0STR.Bits.PTAD11
    #define PORTAD0_PTAD12              _PORTAD.Overlap_STR.PORTAD0STR.Bits.PTAD12
    #define PORTAD0_PTAD13              _PORTAD.Overlap_STR.PORTAD0STR.Bits.PTAD13
    #define PORTAD0_PTAD14              _PORTAD.Overlap_STR.PORTAD0STR.Bits.PTAD14
    #define PORTAD0_PTAD15              _PORTAD.Overlap_STR.PORTAD0STR.Bits.PTAD15
    /* PORTAD_ARR: Access 2 PORTADx registers in an array */
    #define PORTAD_ARR                  ((volatile byte *) &PORTAD0)
    
    #define PORTAD0_PTAD8_MASK          1U
    #define PORTAD0_PTAD9_MASK          2U
    #define PORTAD0_PTAD10_MASK         4U
    #define PORTAD0_PTAD11_MASK         8U
    #define PORTAD0_PTAD12_MASK         16U
    #define PORTAD0_PTAD13_MASK         32U
    #define PORTAD0_PTAD14_MASK         64U
    #define PORTAD0_PTAD15_MASK         128U
    

    /*** PORTAD1 - Port AD1 Data Register; 0x0000008F ***/
    union {
      byte Byte;
      struct {
        byte PTAD0       :1;                                       /* A/D Channel 0 (AN0) Digital Input */
        byte PTAD1       :1;                                       /* A/D Channel 1 (AN1) Digital Input */
        byte PTAD2       :1;                                       /* A/D Channel 2 (AN2) Digital Input */
        byte PTAD3       :1;                                       /* A/D Channel 3 (AN3) Digital Input */
        byte PTAD4       :1;                                       /* A/D Channel 4 (AN4) Digital Input */
        byte PTAD5       :1;                                       /* A/D Channel 5 (AN5) Digital Input */
        byte PTAD6       :1;                                       /* A/D Channel 6 (AN6) Digital Input */
        byte PTAD7       :1;                                       /* A/D Channel 7 (AN7) Digital Input */
      } Bits;
    } PORTAD1STR;
    #define PORTAD1                     _PORTAD.Overlap_STR.PORTAD1STR.Byte
    #define PORTAD1_PTAD0               _PORTAD.Overlap_STR.PORTAD1STR.Bits.PTAD0
    #define PORTAD1_PTAD1               _PORTAD.Overlap_STR.PORTAD1STR.Bits.PTAD1
    #define PORTAD1_PTAD2               _PORTAD.Overlap_STR.PORTAD1STR.Bits.PTAD2
    #define PORTAD1_PTAD3               _PORTAD.Overlap_STR.PORTAD1STR.Bits.PTAD3
    #define PORTAD1_PTAD4               _PORTAD.Overlap_STR.PORTAD1STR.Bits.PTAD4
    #define PORTAD1_PTAD5               _PORTAD.Overlap_STR.PORTAD1STR.Bits.PTAD5
    #define PORTAD1_PTAD6               _PORTAD.Overlap_STR.PORTAD1STR.Bits.PTAD6
    #define PORTAD1_PTAD7               _PORTAD.Overlap_STR.PORTAD1STR.Bits.PTAD7
    
    #define PORTAD1_PTAD0_MASK          1U
    #define PORTAD1_PTAD1_MASK          2U
    #define PORTAD1_PTAD2_MASK          4U
    #define PORTAD1_PTAD3_MASK          8U
    #define PORTAD1_PTAD4_MASK          16U
    #define PORTAD1_PTAD5_MASK          32U
    #define PORTAD1_PTAD6_MASK          64U
    #define PORTAD1_PTAD7_MASK          128U
    
  } Overlap_STR;

  struct {
    word PTAD0       :1;                                       /* A/D Channel 0 (AN0) Digital Input */
    word PTAD1       :1;                                       /* A/D Channel 1 (AN1) Digital Input */
    word PTAD2       :1;                                       /* A/D Channel 2 (AN2) Digital Input */
    word PTAD3       :1;                                       /* A/D Channel 3 (AN3) Digital Input */
    word PTAD4       :1;                                       /* A/D Channel 4 (AN4) Digital Input */
    word PTAD5       :1;                                       /* A/D Channel 5 (AN5) Digital Input */
    word PTAD6       :1;                                       /* A/D Channel 6 (AN6) Digital Input */
    word PTAD7       :1;                                       /* A/D Channel 7 (AN7) Digital Input */
    word PTAD8       :1;                                       /* A/D Channel 8 (AN8) Digital Input */
    word PTAD9       :1;                                       /* A/D Channel 9 (AN9) Digital Input */
    word PTAD10      :1;                                       /* A/D Channel 10 (AN10) Digital Input */
    word PTAD11      :1;                                       /* A/D Channel 11 (AN11) Digital Input */
    word PTAD12      :1;                                       /* A/D Channel 12 (AN12) Digital Input */
    word PTAD13      :1;                                       /* A/D Channel 13 (AN13) Digital Input */
    word PTAD14      :1;                                       /* A/D Channel 14 (AN14) Digital Input */
    word PTAD15      :1;                                       /* A/D Channel 15 (AN15) Digital Input */
  } Bits;
} PORTADSTR;
extern volatile PORTADSTR _PORTAD @(REG_BASE + 0x0000008EUL);
#define PORTAD                          _PORTAD.Word
#define PORTAD_PTAD0                    _PORTAD.Bits.PTAD0
#define PORTAD_PTAD1                    _PORTAD.Bits.PTAD1
#define PORTAD_PTAD2                    _PORTAD.Bits.PTAD2
#define PORTAD_PTAD3                    _PORTAD.Bits.PTAD3
#define PORTAD_PTAD4                    _PORTAD.Bits.PTAD4
#define PORTAD_PTAD5                    _PORTAD.Bits.PTAD5
#define PORTAD_PTAD6                    _PORTAD.Bits.PTAD6
#define PORTAD_PTAD7                    _PORTAD.Bits.PTAD7
#define PORTAD_PTAD8                    _PORTAD.Bits.PTAD8
#define PORTAD_PTAD9                    _PORTAD.Bits.PTAD9
#define PORTAD_PTAD10                   _PORTAD.Bits.PTAD10
#define PORTAD_PTAD11                   _PORTAD.Bits.PTAD11
#define PORTAD_PTAD12                   _PORTAD.Bits.PTAD12
#define PORTAD_PTAD13                   _PORTAD.Bits.PTAD13
#define PORTAD_PTAD14                   _PORTAD.Bits.PTAD14
#define PORTAD_PTAD15                   _PORTAD.Bits.PTAD15

#define PORTAD_PTAD0_MASK               1U
#define PORTAD_PTAD1_MASK               2U
#define PORTAD_PTAD2_MASK               4U
#define PORTAD_PTAD3_MASK               8U
#define PORTAD_PTAD4_MASK               16U
#define PORTAD_PTAD5_MASK               32U
#define PORTAD_PTAD6_MASK               64U
#define PORTAD_PTAD7_MASK               128U
#define PORTAD_PTAD8_MASK               256U
#define PORTAD_PTAD9_MASK               512U
#define PORTAD_PTAD10_MASK              1024U
#define PORTAD_PTAD11_MASK              2048U
#define PORTAD_PTAD12_MASK              4096U
#define PORTAD_PTAD13_MASK              8192U
#define PORTAD_PTAD14_MASK              16384U
#define PORTAD_PTAD15_MASK              32768U


/*** ATDDR0 - ATD Conversion Result Register 0; 0x00000090 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATDDR0H - ATD Conversion Result Register 0 High; 0x00000090 ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* ATD Conversion Result Bit 8 */
        byte BIT9        :1;                                       /* ATD Conversion Result Bit 9 */
        byte BIT10       :1;                                       /* ATD Conversion Result Bit 10 */
        byte BIT11       :1;                                       /* ATD Conversion Result Bit 11 */
        byte BIT12       :1;                                       /* ATD Conversion Result Bit 12 */
        byte BIT13       :1;                                       /* ATD Conversion Result Bit 13 */
        byte BIT14       :1;                                       /* ATD Conversion Result Bit 14 */
        byte BIT15       :1;                                       /* ATD Conversion Result Bit 15 */
      } Bits;
    } ATDDR0HSTR;
    #define ATDDR0H                     _ATDDR0.Overlap_STR.ATDDR0HSTR.Byte
    #define ATDDR0H_BIT8                _ATDDR0.Overlap_STR.ATDDR0HSTR.Bits.BIT8
    #define ATDDR0H_BIT9                _ATDDR0.Overlap_STR.ATDDR0HSTR.Bits.BIT9
    #define ATDDR0H_BIT10               _ATDDR0.Overlap_STR.ATDDR0HSTR.Bits.BIT10
    #define ATDDR0H_BIT11               _ATDDR0.Overlap_STR.ATDDR0HSTR.Bits.BIT11
    #define ATDDR0H_BIT12               _ATDDR0.Overlap_STR.ATDDR0HSTR.Bits.BIT12
    #define ATDDR0H_BIT13               _ATDDR0.Overlap_STR.ATDDR0HSTR.Bits.BIT13
    #define ATDDR0H_BIT14               _ATDDR0.Overlap_STR.ATDDR0HSTR.Bits.BIT14
    #define ATDDR0H_BIT15               _ATDDR0.Overlap_STR.ATDDR0HSTR.Bits.BIT15
    
    #define ATDDR0H_BIT8_MASK           1U
    #define ATDDR0H_BIT9_MASK           2U
    #define ATDDR0H_BIT10_MASK          4U
    #define ATDDR0H_BIT11_MASK          8U
    #define ATDDR0H_BIT12_MASK          16U
    #define ATDDR0H_BIT13_MASK          32U
    #define ATDDR0H_BIT14_MASK          64U
    #define ATDDR0H_BIT15_MASK          128U
    

    /*** ATDDR0L - ATD Conversion Result Register 0 Low; 0x00000091 ***/
    union {
      byte Byte;
      struct {
        byte BIT0        :1;                                       /* ATD Conversion Result Bit 0 */
        byte BIT1        :1;                                       /* ATD Conversion Result Bit 1 */
        byte BIT2        :1;                                       /* ATD Conversion Result Bit 2 */
        byte BIT3        :1;                                       /* ATD Conversion Result Bit 3 */
        byte BIT4        :1;                                       /* ATD Conversion Result Bit 4 */
        byte BIT5        :1;                                       /* ATD Conversion Result Bit 5 */
        byte BIT6        :1;                                       /* ATD Conversion Result Bit 6 */
        byte BIT7        :1;                                       /* ATD Conversion Result Bit 7 */
      } Bits;
    } ATDDR0LSTR;
    #define ATDDR0L                     _ATDDR0.Overlap_STR.ATDDR0LSTR.Byte
    #define ATDDR0L_BIT0                _ATDDR0.Overlap_STR.ATDDR0LSTR.Bits.BIT0
    #define ATDDR0L_BIT1                _ATDDR0.Overlap_STR.ATDDR0LSTR.Bits.BIT1
    #define ATDDR0L_BIT2                _ATDDR0.Overlap_STR.ATDDR0LSTR.Bits.BIT2
    #define ATDDR0L_BIT3                _ATDDR0.Overlap_STR.ATDDR0LSTR.Bits.BIT3
    #define ATDDR0L_BIT4                _ATDDR0.Overlap_STR.ATDDR0LSTR.Bits.BIT4
    #define ATDDR0L_BIT5                _ATDDR0.Overlap_STR.ATDDR0LSTR.Bits.BIT5
    #define ATDDR0L_BIT6                _ATDDR0.Overlap_STR.ATDDR0LSTR.Bits.BIT6
    #define ATDDR0L_BIT7                _ATDDR0.Overlap_STR.ATDDR0LSTR.Bits.BIT7
    
    #define ATDDR0L_BIT0_MASK           1U
    #define ATDDR0L_BIT1_MASK           2U
    #define ATDDR0L_BIT2_MASK           4U
    #define ATDDR0L_BIT3_MASK           8U
    #define ATDDR0L_BIT4_MASK           16U
    #define ATDDR0L_BIT5_MASK           32U
    #define ATDDR0L_BIT6_MASK           64U
    #define ATDDR0L_BIT7_MASK           128U
    
  } Overlap_STR;

  struct {
    word BIT0        :1;                                       /* ATD Conversion Result Bit 0 */
    word BIT1        :1;                                       /* ATD Conversion Result Bit 1 */
    word BIT2        :1;                                       /* ATD Conversion Result Bit 2 */
    word BIT3        :1;                                       /* ATD Conversion Result Bit 3 */
    word BIT4        :1;                                       /* ATD Conversion Result Bit 4 */
    word BIT5        :1;                                       /* ATD Conversion Result Bit 5 */
    word BIT6        :1;                                       /* ATD Conversion Result Bit 6 */
    word BIT7        :1;                                       /* ATD Conversion Result Bit 7 */
    word BIT8        :1;                                       /* ATD Conversion Result Bit 8 */
    word BIT9        :1;                                       /* ATD Conversion Result Bit 9 */
    word BIT10       :1;                                       /* ATD Conversion Result Bit 10 */
    word BIT11       :1;                                       /* ATD Conversion Result Bit 11 */
    word BIT12       :1;                                       /* ATD Conversion Result Bit 12 */
    word BIT13       :1;                                       /* ATD Conversion Result Bit 13 */
    word BIT14       :1;                                       /* ATD Conversion Result Bit 14 */
    word BIT15       :1;                                       /* ATD Conversion Result Bit 15 */
  } Bits;
} ATDDR0STR;
extern volatile ATDDR0STR _ATDDR0 @(REG_BASE + 0x00000090UL);
#define ATDDR0                          _ATDDR0.Word
#define ATDDR0_BIT0                     _ATDDR0.Bits.BIT0
#define ATDDR0_BIT1                     _ATDDR0.Bits.BIT1
#define ATDDR0_BIT2                     _ATDDR0.Bits.BIT2
#define ATDDR0_BIT3                     _ATDDR0.Bits.BIT3
#define ATDDR0_BIT4                     _ATDDR0.Bits.BIT4
#define ATDDR0_BIT5                     _ATDDR0.Bits.BIT5
#define ATDDR0_BIT6                     _ATDDR0.Bits.BIT6
#define ATDDR0_BIT7                     _ATDDR0.Bits.BIT7
#define ATDDR0_BIT8                     _ATDDR0.Bits.BIT8
#define ATDDR0_BIT9                     _ATDDR0.Bits.BIT9
#define ATDDR0_BIT10                    _ATDDR0.Bits.BIT10
#define ATDDR0_BIT11                    _ATDDR0.Bits.BIT11
#define ATDDR0_BIT12                    _ATDDR0.Bits.BIT12
#define ATDDR0_BIT13                    _ATDDR0.Bits.BIT13
#define ATDDR0_BIT14                    _ATDDR0.Bits.BIT14
#define ATDDR0_BIT15                    _ATDDR0.Bits.BIT15
/* ATDDR_ARR: Access 16 ATDDRx registers in an array */
#define ATDDR_ARR                       ((volatile word *) &ATDDR0)

#define ATDDR0_BIT0_MASK                1U
#define ATDDR0_BIT1_MASK                2U
#define ATDDR0_BIT2_MASK                4U
#define ATDDR0_BIT3_MASK                8U
#define ATDDR0_BIT4_MASK                16U
#define ATDDR0_BIT5_MASK                32U
#define ATDDR0_BIT6_MASK                64U
#define ATDDR0_BIT7_MASK                128U
#define ATDDR0_BIT8_MASK                256U
#define ATDDR0_BIT9_MASK                512U
#define ATDDR0_BIT10_MASK               1024U
#define ATDDR0_BIT11_MASK               2048U
#define ATDDR0_BIT12_MASK               4096U
#define ATDDR0_BIT13_MASK               8192U
#define ATDDR0_BIT14_MASK               16384U
#define ATDDR0_BIT15_MASK               32768U


/*** ATDDR1 - ATD Conversion Result Register 1; 0x00000092 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATDDR1H - ATD Conversion Result Register 1 High; 0x00000092 ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* ATD Conversion Result Bit 8 */
        byte BIT9        :1;                                       /* ATD Conversion Result Bit 9 */
        byte BIT10       :1;                                       /* ATD Conversion Result Bit 10 */
        byte BIT11       :1;                                       /* ATD Conversion Result Bit 11 */
        byte BIT12       :1;                                       /* ATD Conversion Result Bit 12 */
        byte BIT13       :1;                                       /* ATD Conversion Result Bit 13 */
        byte BIT14       :1;                                       /* ATD Conversion Result Bit 14 */
        byte BIT15       :1;                                       /* ATD Conversion Result Bit 15 */
      } Bits;
    } ATDDR1HSTR;
    #define ATDDR1H                     _ATDDR1.Overlap_STR.ATDDR1HSTR.Byte
    #define ATDDR1H_BIT8                _ATDDR1.Overlap_STR.ATDDR1HSTR.Bits.BIT8
    #define ATDDR1H_BIT9                _ATDDR1.Overlap_STR.ATDDR1HSTR.Bits.BIT9
    #define ATDDR1H_BIT10               _ATDDR1.Overlap_STR.ATDDR1HSTR.Bits.BIT10
    #define ATDDR1H_BIT11               _ATDDR1.Overlap_STR.ATDDR1HSTR.Bits.BIT11
    #define ATDDR1H_BIT12               _ATDDR1.Overlap_STR.ATDDR1HSTR.Bits.BIT12
    #define ATDDR1H_BIT13               _ATDDR1.Overlap_STR.ATDDR1HSTR.Bits.BIT13
    #define ATDDR1H_BIT14               _ATDDR1.Overlap_STR.ATDDR1HSTR.Bits.BIT14
    #define ATDDR1H_BIT15               _ATDDR1.Overlap_STR.ATDDR1HSTR.Bits.BIT15
    
    #define ATDDR1H_BIT8_MASK           1U
    #define ATDDR1H_BIT9_MASK           2U
    #define ATDDR1H_BIT10_MASK          4U
    #define ATDDR1H_BIT11_MASK          8U
    #define ATDDR1H_BIT12_MASK          16U
    #define ATDDR1H_BIT13_MASK          32U
    #define ATDDR1H_BIT14_MASK          64U
    #define ATDDR1H_BIT15_MASK          128U
    

    /*** ATDDR1L - ATD Conversion Result Register 1 Low; 0x00000093 ***/
    union {
      byte Byte;
      struct {
        byte BIT0        :1;                                       /* ATD Conversion Result Bit 0 */
        byte BIT1        :1;                                       /* ATD Conversion Result Bit 1 */
        byte BIT2        :1;                                       /* ATD Conversion Result Bit 2 */
        byte BIT3        :1;                                       /* ATD Conversion Result Bit 3 */
        byte BIT4        :1;                                       /* ATD Conversion Result Bit 4 */
        byte BIT5        :1;                                       /* ATD Conversion Result Bit 5 */
        byte BIT6        :1;                                       /* ATD Conversion Result Bit 6 */
        byte BIT7        :1;                                       /* ATD Conversion Result Bit 7 */
      } Bits;
    } ATDDR1LSTR;
    #define ATDDR1L                     _ATDDR1.Overlap_STR.ATDDR1LSTR.Byte
    #define ATDDR1L_BIT0                _ATDDR1.Overlap_STR.ATDDR1LSTR.Bits.BIT0
    #define ATDDR1L_BIT1                _ATDDR1.Overlap_STR.ATDDR1LSTR.Bits.BIT1
    #define ATDDR1L_BIT2                _ATDDR1.Overlap_STR.ATDDR1LSTR.Bits.BIT2
    #define ATDDR1L_BIT3                _ATDDR1.Overlap_STR.ATDDR1LSTR.Bits.BIT3
    #define ATDDR1L_BIT4                _ATDDR1.Overlap_STR.ATDDR1LSTR.Bits.BIT4
    #define ATDDR1L_BIT5                _ATDDR1.Overlap_STR.ATDDR1LSTR.Bits.BIT5
    #define ATDDR1L_BIT6                _ATDDR1.Overlap_STR.ATDDR1LSTR.Bits.BIT6
    #define ATDDR1L_BIT7                _ATDDR1.Overlap_STR.ATDDR1LSTR.Bits.BIT7
    
    #define ATDDR1L_BIT0_MASK           1U
    #define ATDDR1L_BIT1_MASK           2U
    #define ATDDR1L_BIT2_MASK           4U
    #define ATDDR1L_BIT3_MASK           8U
    #define ATDDR1L_BIT4_MASK           16U
    #define ATDDR1L_BIT5_MASK           32U
    #define ATDDR1L_BIT6_MASK           64U
    #define ATDDR1L_BIT7_MASK           128U
    
  } Overlap_STR;

  struct {
    word BIT0        :1;                                       /* ATD Conversion Result Bit 0 */
    word BIT1        :1;                                       /* ATD Conversion Result Bit 1 */
    word BIT2        :1;                                       /* ATD Conversion Result Bit 2 */
    word BIT3        :1;                                       /* ATD Conversion Result Bit 3 */
    word BIT4        :1;                                       /* ATD Conversion Result Bit 4 */
    word BIT5        :1;                                       /* ATD Conversion Result Bit 5 */
    word BIT6        :1;                                       /* ATD Conversion Result Bit 6 */
    word BIT7        :1;                                       /* ATD Conversion Result Bit 7 */
    word BIT8        :1;                                       /* ATD Conversion Result Bit 8 */
    word BIT9        :1;                                       /* ATD Conversion Result Bit 9 */
    word BIT10       :1;                                       /* ATD Conversion Result Bit 10 */
    word BIT11       :1;                                       /* ATD Conversion Result Bit 11 */
    word BIT12       :1;                                       /* ATD Conversion Result Bit 12 */
    word BIT13       :1;                                       /* ATD Conversion Result Bit 13 */
    word BIT14       :1;                                       /* ATD Conversion Result Bit 14 */
    word BIT15       :1;                                       /* ATD Conversion Result Bit 15 */
  } Bits;
} ATDDR1STR;
extern volatile ATDDR1STR _ATDDR1 @(REG_BASE + 0x00000092UL);
#define ATDDR1                          _ATDDR1.Word
#define ATDDR1_BIT0                     _ATDDR1.Bits.BIT0
#define ATDDR1_BIT1                     _ATDDR1.Bits.BIT1
#define ATDDR1_BIT2                     _ATDDR1.Bits.BIT2
#define ATDDR1_BIT3                     _ATDDR1.Bits.BIT3
#define ATDDR1_BIT4                     _ATDDR1.Bits.BIT4
#define ATDDR1_BIT5                     _ATDDR1.Bits.BIT5
#define ATDDR1_BIT6                     _ATDDR1.Bits.BIT6
#define ATDDR1_BIT7                     _ATDDR1.Bits.BIT7
#define ATDDR1_BIT8                     _ATDDR1.Bits.BIT8
#define ATDDR1_BIT9                     _ATDDR1.Bits.BIT9
#define ATDDR1_BIT10                    _ATDDR1.Bits.BIT10
#define ATDDR1_BIT11                    _ATDDR1.Bits.BIT11
#define ATDDR1_BIT12                    _ATDDR1.Bits.BIT12
#define ATDDR1_BIT13                    _ATDDR1.Bits.BIT13
#define ATDDR1_BIT14                    _ATDDR1.Bits.BIT14
#define ATDDR1_BIT15                    _ATDDR1.Bits.BIT15

#define ATDDR1_BIT0_MASK                1U
#define ATDDR1_BIT1_MASK                2U
#define ATDDR1_BIT2_MASK                4U
#define ATDDR1_BIT3_MASK                8U
#define ATDDR1_BIT4_MASK                16U
#define ATDDR1_BIT5_MASK                32U
#define ATDDR1_BIT6_MASK                64U
#define ATDDR1_BIT7_MASK                128U
#define ATDDR1_BIT8_MASK                256U
#define ATDDR1_BIT9_MASK                512U
#define ATDDR1_BIT10_MASK               1024U
#define ATDDR1_BIT11_MASK               2048U
#define ATDDR1_BIT12_MASK               4096U
#define ATDDR1_BIT13_MASK               8192U
#define ATDDR1_BIT14_MASK               16384U
#define ATDDR1_BIT15_MASK               32768U


/*** ATDDR2 - ATD Conversion Result Register 2; 0x00000094 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATDDR2H - ATD Conversion Result Register 2 High; 0x00000094 ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* ATD Conversion Result Bit 8 */
        byte BIT9        :1;                                       /* ATD Conversion Result Bit 9 */
        byte BIT10       :1;                                       /* ATD Conversion Result Bit 10 */
        byte BIT11       :1;                                       /* ATD Conversion Result Bit 11 */
        byte BIT12       :1;                                       /* ATD Conversion Result Bit 12 */
        byte BIT13       :1;                                       /* ATD Conversion Result Bit 13 */
        byte BIT14       :1;                                       /* ATD Conversion Result Bit 14 */
        byte BIT15       :1;                                       /* ATD Conversion Result Bit 15 */
      } Bits;
    } ATDDR2HSTR;
    #define ATDDR2H                     _ATDDR2.Overlap_STR.ATDDR2HSTR.Byte
    #define ATDDR2H_BIT8                _ATDDR2.Overlap_STR.ATDDR2HSTR.Bits.BIT8
    #define ATDDR2H_BIT9                _ATDDR2.Overlap_STR.ATDDR2HSTR.Bits.BIT9
    #define ATDDR2H_BIT10               _ATDDR2.Overlap_STR.ATDDR2HSTR.Bits.BIT10
    #define ATDDR2H_BIT11               _ATDDR2.Overlap_STR.ATDDR2HSTR.Bits.BIT11
    #define ATDDR2H_BIT12               _ATDDR2.Overlap_STR.ATDDR2HSTR.Bits.BIT12
    #define ATDDR2H_BIT13               _ATDDR2.Overlap_STR.ATDDR2HSTR.Bits.BIT13
    #define ATDDR2H_BIT14               _ATDDR2.Overlap_STR.ATDDR2HSTR.Bits.BIT14
    #define ATDDR2H_BIT15               _ATDDR2.Overlap_STR.ATDDR2HSTR.Bits.BIT15
    
    #define ATDDR2H_BIT8_MASK           1U
    #define ATDDR2H_BIT9_MASK           2U
    #define ATDDR2H_BIT10_MASK          4U
    #define ATDDR2H_BIT11_MASK          8U
    #define ATDDR2H_BIT12_MASK          16U
    #define ATDDR2H_BIT13_MASK          32U
    #define ATDDR2H_BIT14_MASK          64U
    #define ATDDR2H_BIT15_MASK          128U
    

    /*** ATDDR2L - ATD Conversion Result Register 2 Low; 0x00000095 ***/
    union {
      byte Byte;
      struct {
        byte BIT0        :1;                                       /* ATD Conversion Result Bit 0 */
        byte BIT1        :1;                                       /* ATD Conversion Result Bit 1 */
        byte BIT2        :1;                                       /* ATD Conversion Result Bit 2 */
        byte BIT3        :1;                                       /* ATD Conversion Result Bit 3 */
        byte BIT4        :1;                                       /* ATD Conversion Result Bit 4 */
        byte BIT5        :1;                                       /* ATD Conversion Result Bit 5 */
        byte BIT6        :1;                                       /* ATD Conversion Result Bit 6 */
        byte BIT7        :1;                                       /* ATD Conversion Result Bit 7 */
      } Bits;
    } ATDDR2LSTR;
    #define ATDDR2L                     _ATDDR2.Overlap_STR.ATDDR2LSTR.Byte
    #define ATDDR2L_BIT0                _ATDDR2.Overlap_STR.ATDDR2LSTR.Bits.BIT0
    #define ATDDR2L_BIT1                _ATDDR2.Overlap_STR.ATDDR2LSTR.Bits.BIT1
    #define ATDDR2L_BIT2                _ATDDR2.Overlap_STR.ATDDR2LSTR.Bits.BIT2
    #define ATDDR2L_BIT3                _ATDDR2.Overlap_STR.ATDDR2LSTR.Bits.BIT3
    #define ATDDR2L_BIT4                _ATDDR2.Overlap_STR.ATDDR2LSTR.Bits.BIT4
    #define ATDDR2L_BIT5                _ATDDR2.Overlap_STR.ATDDR2LSTR.Bits.BIT5
    #define ATDDR2L_BIT6                _ATDDR2.Overlap_STR.ATDDR2LSTR.Bits.BIT6
    #define ATDDR2L_BIT7                _ATDDR2.Overlap_STR.ATDDR2LSTR.Bits.BIT7
    
    #define ATDDR2L_BIT0_MASK           1U
    #define ATDDR2L_BIT1_MASK           2U
    #define ATDDR2L_BIT2_MASK           4U
    #define ATDDR2L_BIT3_MASK           8U
    #define ATDDR2L_BIT4_MASK           16U
    #define ATDDR2L_BIT5_MASK           32U
    #define ATDDR2L_BIT6_MASK           64U
    #define ATDDR2L_BIT7_MASK           128U
    
  } Overlap_STR;

  struct {
    word BIT0        :1;                                       /* ATD Conversion Result Bit 0 */
    word BIT1        :1;                                       /* ATD Conversion Result Bit 1 */
    word BIT2        :1;                                       /* ATD Conversion Result Bit 2 */
    word BIT3        :1;                                       /* ATD Conversion Result Bit 3 */
    word BIT4        :1;                                       /* ATD Conversion Result Bit 4 */
    word BIT5        :1;                                       /* ATD Conversion Result Bit 5 */
    word BIT6        :1;                                       /* ATD Conversion Result Bit 6 */
    word BIT7        :1;                                       /* ATD Conversion Result Bit 7 */
    word BIT8        :1;                                       /* ATD Conversion Result Bit 8 */
    word BIT9        :1;                                       /* ATD Conversion Result Bit 9 */
    word BIT10       :1;                                       /* ATD Conversion Result Bit 10 */
    word BIT11       :1;                                       /* ATD Conversion Result Bit 11 */
    word BIT12       :1;                                       /* ATD Conversion Result Bit 12 */
    word BIT13       :1;                                       /* ATD Conversion Result Bit 13 */
    word BIT14       :1;                                       /* ATD Conversion Result Bit 14 */
    word BIT15       :1;                                       /* ATD Conversion Result Bit 15 */
  } Bits;
} ATDDR2STR;
extern volatile ATDDR2STR _ATDDR2 @(REG_BASE + 0x00000094UL);
#define ATDDR2                          _ATDDR2.Word
#define ATDDR2_BIT0                     _ATDDR2.Bits.BIT0
#define ATDDR2_BIT1                     _ATDDR2.Bits.BIT1
#define ATDDR2_BIT2                     _ATDDR2.Bits.BIT2
#define ATDDR2_BIT3                     _ATDDR2.Bits.BIT3
#define ATDDR2_BIT4                     _ATDDR2.Bits.BIT4
#define ATDDR2_BIT5                     _ATDDR2.Bits.BIT5
#define ATDDR2_BIT6                     _ATDDR2.Bits.BIT6
#define ATDDR2_BIT7                     _ATDDR2.Bits.BIT7
#define ATDDR2_BIT8                     _ATDDR2.Bits.BIT8
#define ATDDR2_BIT9                     _ATDDR2.Bits.BIT9
#define ATDDR2_BIT10                    _ATDDR2.Bits.BIT10
#define ATDDR2_BIT11                    _ATDDR2.Bits.BIT11
#define ATDDR2_BIT12                    _ATDDR2.Bits.BIT12
#define ATDDR2_BIT13                    _ATDDR2.Bits.BIT13
#define ATDDR2_BIT14                    _ATDDR2.Bits.BIT14
#define ATDDR2_BIT15                    _ATDDR2.Bits.BIT15

#define ATDDR2_BIT0_MASK                1U
#define ATDDR2_BIT1_MASK                2U
#define ATDDR2_BIT2_MASK                4U
#define ATDDR2_BIT3_MASK                8U
#define ATDDR2_BIT4_MASK                16U
#define ATDDR2_BIT5_MASK                32U
#define ATDDR2_BIT6_MASK                64U
#define ATDDR2_BIT7_MASK                128U
#define ATDDR2_BIT8_MASK                256U
#define ATDDR2_BIT9_MASK                512U
#define ATDDR2_BIT10_MASK               1024U
#define ATDDR2_BIT11_MASK               2048U
#define ATDDR2_BIT12_MASK               4096U
#define ATDDR2_BIT13_MASK               8192U
#define ATDDR2_BIT14_MASK               16384U
#define ATDDR2_BIT15_MASK               32768U


/*** ATDDR3 - ATD Conversion Result Register 3; 0x00000096 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATDDR3H - ATD Conversion Result Register 3 High; 0x00000096 ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* ATD Conversion Result Bit 8 */
        byte BIT9        :1;                                       /* ATD Conversion Result Bit 9 */
        byte BIT10       :1;                                       /* ATD Conversion Result Bit 10 */
        byte BIT11       :1;                                       /* ATD Conversion Result Bit 11 */
        byte BIT12       :1;                                       /* ATD Conversion Result Bit 12 */
        byte BIT13       :1;                                       /* ATD Conversion Result Bit 13 */
        byte BIT14       :1;                                       /* ATD Conversion Result Bit 14 */
        byte BIT15       :1;                                       /* ATD Conversion Result Bit 15 */
      } Bits;
    } ATDDR3HSTR;
    #define ATDDR3H                     _ATDDR3.Overlap_STR.ATDDR3HSTR.Byte
    #define ATDDR3H_BIT8                _ATDDR3.Overlap_STR.ATDDR3HSTR.Bits.BIT8
    #define ATDDR3H_BIT9                _ATDDR3.Overlap_STR.ATDDR3HSTR.Bits.BIT9
    #define ATDDR3H_BIT10               _ATDDR3.Overlap_STR.ATDDR3HSTR.Bits.BIT10
    #define ATDDR3H_BIT11               _ATDDR3.Overlap_STR.ATDDR3HSTR.Bits.BIT11
    #define ATDDR3H_BIT12               _ATDDR3.Overlap_STR.ATDDR3HSTR.Bits.BIT12
    #define ATDDR3H_BIT13               _ATDDR3.Overlap_STR.ATDDR3HSTR.Bits.BIT13
    #define ATDDR3H_BIT14               _ATDDR3.Overlap_STR.ATDDR3HSTR.Bits.BIT14
    #define ATDDR3H_BIT15               _ATDDR3.Overlap_STR.ATDDR3HSTR.Bits.BIT15
    
    #define ATDDR3H_BIT8_MASK           1U
    #define ATDDR3H_BIT9_MASK           2U
    #define ATDDR3H_BIT10_MASK          4U
    #define ATDDR3H_BIT11_MASK          8U
    #define ATDDR3H_BIT12_MASK          16U
    #define ATDDR3H_BIT13_MASK          32U
    #define ATDDR3H_BIT14_MASK          64U
    #define ATDDR3H_BIT15_MASK          128U
    

    /*** ATDDR3L - ATD Conversion Result Register 3 Low; 0x00000097 ***/
    union {
      byte Byte;
      struct {
        byte BIT0        :1;                                       /* ATD Conversion Result Bit 0 */
        byte BIT1        :1;                                       /* ATD Conversion Result Bit 1 */
        byte BIT2        :1;                                       /* ATD Conversion Result Bit 2 */
        byte BIT3        :1;                                       /* ATD Conversion Result Bit 3 */
        byte BIT4        :1;                                       /* ATD Conversion Result Bit 4 */
        byte BIT5        :1;                                       /* ATD Conversion Result Bit 5 */
        byte BIT6        :1;                                       /* ATD Conversion Result Bit 6 */
        byte BIT7        :1;                                       /* ATD Conversion Result Bit 7 */
      } Bits;
    } ATDDR3LSTR;
    #define ATDDR3L                     _ATDDR3.Overlap_STR.ATDDR3LSTR.Byte
    #define ATDDR3L_BIT0                _ATDDR3.Overlap_STR.ATDDR3LSTR.Bits.BIT0
    #define ATDDR3L_BIT1                _ATDDR3.Overlap_STR.ATDDR3LSTR.Bits.BIT1
    #define ATDDR3L_BIT2                _ATDDR3.Overlap_STR.ATDDR3LSTR.Bits.BIT2
    #define ATDDR3L_BIT3                _ATDDR3.Overlap_STR.ATDDR3LSTR.Bits.BIT3
    #define ATDDR3L_BIT4                _ATDDR3.Overlap_STR.ATDDR3LSTR.Bits.BIT4
    #define ATDDR3L_BIT5                _ATDDR3.Overlap_STR.ATDDR3LSTR.Bits.BIT5
    #define ATDDR3L_BIT6                _ATDDR3.Overlap_STR.ATDDR3LSTR.Bits.BIT6
    #define ATDDR3L_BIT7                _ATDDR3.Overlap_STR.ATDDR3LSTR.Bits.BIT7
    
    #define ATDDR3L_BIT0_MASK           1U
    #define ATDDR3L_BIT1_MASK           2U
    #define ATDDR3L_BIT2_MASK           4U
    #define ATDDR3L_BIT3_MASK           8U
    #define ATDDR3L_BIT4_MASK           16U
    #define ATDDR3L_BIT5_MASK           32U
    #define ATDDR3L_BIT6_MASK           64U
    #define ATDDR3L_BIT7_MASK           128U
    
  } Overlap_STR;

  struct {
    word BIT0        :1;                                       /* ATD Conversion Result Bit 0 */
    word BIT1        :1;                                       /* ATD Conversion Result Bit 1 */
    word BIT2        :1;                                       /* ATD Conversion Result Bit 2 */
    word BIT3        :1;                                       /* ATD Conversion Result Bit 3 */
    word BIT4        :1;                                       /* ATD Conversion Result Bit 4 */
    word BIT5        :1;                                       /* ATD Conversion Result Bit 5 */
    word BIT6        :1;                                       /* ATD Conversion Result Bit 6 */
    word BIT7        :1;                                       /* ATD Conversion Result Bit 7 */
    word BIT8        :1;                                       /* ATD Conversion Result Bit 8 */
    word BIT9        :1;                                       /* ATD Conversion Result Bit 9 */
    word BIT10       :1;                                       /* ATD Conversion Result Bit 10 */
    word BIT11       :1;                                       /* ATD Conversion Result Bit 11 */
    word BIT12       :1;                                       /* ATD Conversion Result Bit 12 */
    word BIT13       :1;                                       /* ATD Conversion Result Bit 13 */
    word BIT14       :1;                                       /* ATD Conversion Result Bit 14 */
    word BIT15       :1;                                       /* ATD Conversion Result Bit 15 */
  } Bits;
} ATDDR3STR;
extern volatile ATDDR3STR _ATDDR3 @(REG_BASE + 0x00000096UL);
#define ATDDR3                          _ATDDR3.Word
#define ATDDR3_BIT0                     _ATDDR3.Bits.BIT0
#define ATDDR3_BIT1                     _ATDDR3.Bits.BIT1
#define ATDDR3_BIT2                     _ATDDR3.Bits.BIT2
#define ATDDR3_BIT3                     _ATDDR3.Bits.BIT3
#define ATDDR3_BIT4                     _ATDDR3.Bits.BIT4
#define ATDDR3_BIT5                     _ATDDR3.Bits.BIT5
#define ATDDR3_BIT6                     _ATDDR3.Bits.BIT6
#define ATDDR3_BIT7                     _ATDDR3.Bits.BIT7
#define ATDDR3_BIT8                     _ATDDR3.Bits.BIT8
#define ATDDR3_BIT9                     _ATDDR3.Bits.BIT9
#define ATDDR3_BIT10                    _ATDDR3.Bits.BIT10
#define ATDDR3_BIT11                    _ATDDR3.Bits.BIT11
#define ATDDR3_BIT12                    _ATDDR3.Bits.BIT12
#define ATDDR3_BIT13                    _ATDDR3.Bits.BIT13
#define ATDDR3_BIT14                    _ATDDR3.Bits.BIT14
#define ATDDR3_BIT15                    _ATDDR3.Bits.BIT15

#define ATDDR3_BIT0_MASK                1U
#define ATDDR3_BIT1_MASK                2U
#define ATDDR3_BIT2_MASK                4U
#define ATDDR3_BIT3_MASK                8U
#define ATDDR3_BIT4_MASK                16U
#define ATDDR3_BIT5_MASK                32U
#define ATDDR3_BIT6_MASK                64U
#define ATDDR3_BIT7_MASK                128U
#define ATDDR3_BIT8_MASK                256U
#define ATDDR3_BIT9_MASK                512U
#define ATDDR3_BIT10_MASK               1024U
#define ATDDR3_BIT11_MASK               2048U
#define ATDDR3_BIT12_MASK               4096U
#define ATDDR3_BIT13_MASK               8192U
#define ATDDR3_BIT14_MASK               16384U
#define ATDDR3_BIT15_MASK               32768U


/*** ATDDR4 - ATD Conversion Result Register 4; 0x00000098 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATDDR4H - ATD Conversion Result Register 4 High; 0x00000098 ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* ATD Conversion Result Bit 8 */
        byte BIT9        :1;                                       /* ATD Conversion Result Bit 9 */
        byte BIT10       :1;                                       /* ATD Conversion Result Bit 10 */
        byte BIT11       :1;                                       /* ATD Conversion Result Bit 11 */
        byte BIT12       :1;                                       /* ATD Conversion Result Bit 12 */
        byte BIT13       :1;                                       /* ATD Conversion Result Bit 13 */
        byte BIT14       :1;                                       /* ATD Conversion Result Bit 14 */
        byte BIT15       :1;                                       /* ATD Conversion Result Bit 15 */
      } Bits;
    } ATDDR4HSTR;
    #define ATDDR4H                     _ATDDR4.Overlap_STR.ATDDR4HSTR.Byte
    #define ATDDR4H_BIT8                _ATDDR4.Overlap_STR.ATDDR4HSTR.Bits.BIT8
    #define ATDDR4H_BIT9                _ATDDR4.Overlap_STR.ATDDR4HSTR.Bits.BIT9
    #define ATDDR4H_BIT10               _ATDDR4.Overlap_STR.ATDDR4HSTR.Bits.BIT10
    #define ATDDR4H_BIT11               _ATDDR4.Overlap_STR.ATDDR4HSTR.Bits.BIT11
    #define ATDDR4H_BIT12               _ATDDR4.Overlap_STR.ATDDR4HSTR.Bits.BIT12
    #define ATDDR4H_BIT13               _ATDDR4.Overlap_STR.ATDDR4HSTR.Bits.BIT13
    #define ATDDR4H_BIT14               _ATDDR4.Overlap_STR.ATDDR4HSTR.Bits.BIT14
    #define ATDDR4H_BIT15               _ATDDR4.Overlap_STR.ATDDR4HSTR.Bits.BIT15
    
    #define ATDDR4H_BIT8_MASK           1U
    #define ATDDR4H_BIT9_MASK           2U
    #define ATDDR4H_BIT10_MASK          4U
    #define ATDDR4H_BIT11_MASK          8U
    #define ATDDR4H_BIT12_MASK          16U
    #define ATDDR4H_BIT13_MASK          32U
    #define ATDDR4H_BIT14_MASK          64U
    #define ATDDR4H_BIT15_MASK          128U
    

    /*** ATDDR4L - ATD Conversion Result Register 4 Low; 0x00000099 ***/
    union {
      byte Byte;
      struct {
        byte BIT0        :1;                                       /* ATD Conversion Result Bit 0 */
        byte BIT1        :1;                                       /* ATD Conversion Result Bit 1 */
        byte BIT2        :1;                                       /* ATD Conversion Result Bit 2 */
        byte BIT3        :1;                                       /* ATD Conversion Result Bit 3 */
        byte BIT4        :1;                                       /* ATD Conversion Result Bit 4 */
        byte BIT5        :1;                                       /* ATD Conversion Result Bit 5 */
        byte BIT6        :1;                                       /* ATD Conversion Result Bit 6 */
        byte BIT7        :1;                                       /* ATD Conversion Result Bit 7 */
      } Bits;
    } ATDDR4LSTR;
    #define ATDDR4L                     _ATDDR4.Overlap_STR.ATDDR4LSTR.Byte
    #define ATDDR4L_BIT0                _ATDDR4.Overlap_STR.ATDDR4LSTR.Bits.BIT0
    #define ATDDR4L_BIT1                _ATDDR4.Overlap_STR.ATDDR4LSTR.Bits.BIT1
    #define ATDDR4L_BIT2                _ATDDR4.Overlap_STR.ATDDR4LSTR.Bits.BIT2
    #define ATDDR4L_BIT3                _ATDDR4.Overlap_STR.ATDDR4LSTR.Bits.BIT3
    #define ATDDR4L_BIT4                _ATDDR4.Overlap_STR.ATDDR4LSTR.Bits.BIT4
    #define ATDDR4L_BIT5                _ATDDR4.Overlap_STR.ATDDR4LSTR.Bits.BIT5
    #define ATDDR4L_BIT6                _ATDDR4.Overlap_STR.ATDDR4LSTR.Bits.BIT6
    #define ATDDR4L_BIT7                _ATDDR4.Overlap_STR.ATDDR4LSTR.Bits.BIT7
    
    #define ATDDR4L_BIT0_MASK           1U
    #define ATDDR4L_BIT1_MASK           2U
    #define ATDDR4L_BIT2_MASK           4U
    #define ATDDR4L_BIT3_MASK           8U
    #define ATDDR4L_BIT4_MASK           16U
    #define ATDDR4L_BIT5_MASK           32U
    #define ATDDR4L_BIT6_MASK           64U
    #define ATDDR4L_BIT7_MASK           128U
    
  } Overlap_STR;

  struct {
    word BIT0        :1;                                       /* ATD Conversion Result Bit 0 */
    word BIT1        :1;                                       /* ATD Conversion Result Bit 1 */
    word BIT2        :1;                                       /* ATD Conversion Result Bit 2 */
    word BIT3        :1;                                       /* ATD Conversion Result Bit 3 */
    word BIT4        :1;                                       /* ATD Conversion Result Bit 4 */
    word BIT5        :1;                                       /* ATD Conversion Result Bit 5 */
    word BIT6        :1;                                       /* ATD Conversion Result Bit 6 */
    word BIT7        :1;                                       /* ATD Conversion Result Bit 7 */
    word BIT8        :1;                                       /* ATD Conversion Result Bit 8 */
    word BIT9        :1;                                       /* ATD Conversion Result Bit 9 */
    word BIT10       :1;                                       /* ATD Conversion Result Bit 10 */
    word BIT11       :1;                                       /* ATD Conversion Result Bit 11 */
    word BIT12       :1;                                       /* ATD Conversion Result Bit 12 */
    word BIT13       :1;                                       /* ATD Conversion Result Bit 13 */
    word BIT14       :1;                                       /* ATD Conversion Result Bit 14 */
    word BIT15       :1;                                       /* ATD Conversion Result Bit 15 */
  } Bits;
} ATDDR4STR;
extern volatile ATDDR4STR _ATDDR4 @(REG_BASE + 0x00000098UL);
#define ATDDR4                          _ATDDR4.Word
#define ATDDR4_BIT0                     _ATDDR4.Bits.BIT0
#define ATDDR4_BIT1                     _ATDDR4.Bits.BIT1
#define ATDDR4_BIT2                     _ATDDR4.Bits.BIT2
#define ATDDR4_BIT3                     _ATDDR4.Bits.BIT3
#define ATDDR4_BIT4                     _ATDDR4.Bits.BIT4
#define ATDDR4_BIT5                     _ATDDR4.Bits.BIT5
#define ATDDR4_BIT6                     _ATDDR4.Bits.BIT6
#define ATDDR4_BIT7                     _ATDDR4.Bits.BIT7
#define ATDDR4_BIT8                     _ATDDR4.Bits.BIT8
#define ATDDR4_BIT9                     _ATDDR4.Bits.BIT9
#define ATDDR4_BIT10                    _ATDDR4.Bits.BIT10
#define ATDDR4_BIT11                    _ATDDR4.Bits.BIT11
#define ATDDR4_BIT12                    _ATDDR4.Bits.BIT12
#define ATDDR4_BIT13                    _ATDDR4.Bits.BIT13
#define ATDDR4_BIT14                    _ATDDR4.Bits.BIT14
#define ATDDR4_BIT15                    _ATDDR4.Bits.BIT15

#define ATDDR4_BIT0_MASK                1U
#define ATDDR4_BIT1_MASK                2U
#define ATDDR4_BIT2_MASK                4U
#define ATDDR4_BIT3_MASK                8U
#define ATDDR4_BIT4_MASK                16U
#define ATDDR4_BIT5_MASK                32U
#define ATDDR4_BIT6_MASK                64U
#define ATDDR4_BIT7_MASK                128U
#define ATDDR4_BIT8_MASK                256U
#define ATDDR4_BIT9_MASK                512U
#define ATDDR4_BIT10_MASK               1024U
#define ATDDR4_BIT11_MASK               2048U
#define ATDDR4_BIT12_MASK               4096U
#define ATDDR4_BIT13_MASK               8192U
#define ATDDR4_BIT14_MASK               16384U
#define ATDDR4_BIT15_MASK               32768U


/*** ATDDR5 - ATD Conversion Result Register 5; 0x0000009A ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATDDR5H - ATD Conversion Result Register 5 High; 0x0000009A ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* ATD Conversion Result Bit 8 */
        byte BIT9        :1;                                       /* ATD Conversion Result Bit 9 */
        byte BIT10       :1;                                       /* ATD Conversion Result Bit 10 */
        byte BIT11       :1;                                       /* ATD Conversion Result Bit 11 */
        byte BIT12       :1;                                       /* ATD Conversion Result Bit 12 */
        byte BIT13       :1;                                       /* ATD Conversion Result Bit 13 */
        byte BIT14       :1;                                       /* ATD Conversion Result Bit 14 */
        byte BIT15       :1;                                       /* ATD Conversion Result Bit 15 */
      } Bits;
    } ATDDR5HSTR;
    #define ATDDR5H                     _ATDDR5.Overlap_STR.ATDDR5HSTR.Byte
    #define ATDDR5H_BIT8                _ATDDR5.Overlap_STR.ATDDR5HSTR.Bits.BIT8
    #define ATDDR5H_BIT9                _ATDDR5.Overlap_STR.ATDDR5HSTR.Bits.BIT9
    #define ATDDR5H_BIT10               _ATDDR5.Overlap_STR.ATDDR5HSTR.Bits.BIT10
    #define ATDDR5H_BIT11               _ATDDR5.Overlap_STR.ATDDR5HSTR.Bits.BIT11
    #define ATDDR5H_BIT12               _ATDDR5.Overlap_STR.ATDDR5HSTR.Bits.BIT12
    #define ATDDR5H_BIT13               _ATDDR5.Overlap_STR.ATDDR5HSTR.Bits.BIT13
    #define ATDDR5H_BIT14               _ATDDR5.Overlap_STR.ATDDR5HSTR.Bits.BIT14
    #define ATDDR5H_BIT15               _ATDDR5.Overlap_STR.ATDDR5HSTR.Bits.BIT15
    
    #define ATDDR5H_BIT8_MASK           1U
    #define ATDDR5H_BIT9_MASK           2U
    #define ATDDR5H_BIT10_MASK          4U
    #define ATDDR5H_BIT11_MASK          8U
    #define ATDDR5H_BIT12_MASK          16U
    #define ATDDR5H_BIT13_MASK          32U
    #define ATDDR5H_BIT14_MASK          64U
    #define ATDDR5H_BIT15_MASK          128U
    

    /*** ATDDR5L - ATD Conversion Result Register 5 Low; 0x0000009B ***/
    union {
      byte Byte;
      struct {
        byte BIT0        :1;                                       /* ATD Conversion Result Bit 0 */
        byte BIT1        :1;                                       /* ATD Conversion Result Bit 1 */
        byte BIT2        :1;                                       /* ATD Conversion Result Bit 2 */
        byte BIT3        :1;                                       /* ATD Conversion Result Bit 3 */
        byte BIT4        :1;                                       /* ATD Conversion Result Bit 4 */
        byte BIT5        :1;                                       /* ATD Conversion Result Bit 5 */
        byte BIT6        :1;                                       /* ATD Conversion Result Bit 6 */
        byte BIT7        :1;                                       /* ATD Conversion Result Bit 7 */
      } Bits;
    } ATDDR5LSTR;
    #define ATDDR5L                     _ATDDR5.Overlap_STR.ATDDR5LSTR.Byte
    #define ATDDR5L_BIT0                _ATDDR5.Overlap_STR.ATDDR5LSTR.Bits.BIT0
    #define ATDDR5L_BIT1                _ATDDR5.Overlap_STR.ATDDR5LSTR.Bits.BIT1
    #define ATDDR5L_BIT2                _ATDDR5.Overlap_STR.ATDDR5LSTR.Bits.BIT2
    #define ATDDR5L_BIT3                _ATDDR5.Overlap_STR.ATDDR5LSTR.Bits.BIT3
    #define ATDDR5L_BIT4                _ATDDR5.Overlap_STR.ATDDR5LSTR.Bits.BIT4
    #define ATDDR5L_BIT5                _ATDDR5.Overlap_STR.ATDDR5LSTR.Bits.BIT5
    #define ATDDR5L_BIT6                _ATDDR5.Overlap_STR.ATDDR5LSTR.Bits.BIT6
    #define ATDDR5L_BIT7                _ATDDR5.Overlap_STR.ATDDR5LSTR.Bits.BIT7
    
    #define ATDDR5L_BIT0_MASK           1U
    #define ATDDR5L_BIT1_MASK           2U
    #define ATDDR5L_BIT2_MASK           4U
    #define ATDDR5L_BIT3_MASK           8U
    #define ATDDR5L_BIT4_MASK           16U
    #define ATDDR5L_BIT5_MASK           32U
    #define ATDDR5L_BIT6_MASK           64U
    #define ATDDR5L_BIT7_MASK           128U
    
  } Overlap_STR;

  struct {
    word BIT0        :1;                                       /* ATD Conversion Result Bit 0 */
    word BIT1        :1;                                       /* ATD Conversion Result Bit 1 */
    word BIT2        :1;                                       /* ATD Conversion Result Bit 2 */
    word BIT3        :1;                                       /* ATD Conversion Result Bit 3 */
    word BIT4        :1;                                       /* ATD Conversion Result Bit 4 */
    word BIT5        :1;                                       /* ATD Conversion Result Bit 5 */
    word BIT6        :1;                                       /* ATD Conversion Result Bit 6 */
    word BIT7        :1;                                       /* ATD Conversion Result Bit 7 */
    word BIT8        :1;                                       /* ATD Conversion Result Bit 8 */
    word BIT9        :1;                                       /* ATD Conversion Result Bit 9 */
    word BIT10       :1;                                       /* ATD Conversion Result Bit 10 */
    word BIT11       :1;                                       /* ATD Conversion Result Bit 11 */
    word BIT12       :1;                                       /* ATD Conversion Result Bit 12 */
    word BIT13       :1;                                       /* ATD Conversion Result Bit 13 */
    word BIT14       :1;                                       /* ATD Conversion Result Bit 14 */
    word BIT15       :1;                                       /* ATD Conversion Result Bit 15 */
  } Bits;
} ATDDR5STR;
extern volatile ATDDR5STR _ATDDR5 @(REG_BASE + 0x0000009AUL);
#define ATDDR5                          _ATDDR5.Word
#define ATDDR5_BIT0                     _ATDDR5.Bits.BIT0
#define ATDDR5_BIT1                     _ATDDR5.Bits.BIT1
#define ATDDR5_BIT2                     _ATDDR5.Bits.BIT2
#define ATDDR5_BIT3                     _ATDDR5.Bits.BIT3
#define ATDDR5_BIT4                     _ATDDR5.Bits.BIT4
#define ATDDR5_BIT5                     _ATDDR5.Bits.BIT5
#define ATDDR5_BIT6                     _ATDDR5.Bits.BIT6
#define ATDDR5_BIT7                     _ATDDR5.Bits.BIT7
#define ATDDR5_BIT8                     _ATDDR5.Bits.BIT8
#define ATDDR5_BIT9                     _ATDDR5.Bits.BIT9
#define ATDDR5_BIT10                    _ATDDR5.Bits.BIT10
#define ATDDR5_BIT11                    _ATDDR5.Bits.BIT11
#define ATDDR5_BIT12                    _ATDDR5.Bits.BIT12
#define ATDDR5_BIT13                    _ATDDR5.Bits.BIT13
#define ATDDR5_BIT14                    _ATDDR5.Bits.BIT14
#define ATDDR5_BIT15                    _ATDDR5.Bits.BIT15

#define ATDDR5_BIT0_MASK                1U
#define ATDDR5_BIT1_MASK                2U
#define ATDDR5_BIT2_MASK                4U
#define ATDDR5_BIT3_MASK                8U
#define ATDDR5_BIT4_MASK                16U
#define ATDDR5_BIT5_MASK                32U
#define ATDDR5_BIT6_MASK                64U
#define ATDDR5_BIT7_MASK                128U
#define ATDDR5_BIT8_MASK                256U
#define ATDDR5_BIT9_MASK                512U
#define ATDDR5_BIT10_MASK               1024U
#define ATDDR5_BIT11_MASK               2048U
#define ATDDR5_BIT12_MASK               4096U
#define ATDDR5_BIT13_MASK               8192U
#define ATDDR5_BIT14_MASK               16384U
#define ATDDR5_BIT15_MASK               32768U


/*** ATDDR6 - ATD Conversion Result Register 6; 0x0000009C ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATDDR6H - ATD Conversion Result Register 6 High; 0x0000009C ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* ATD Conversion Result Bit 8 */
        byte BIT9        :1;                                       /* ATD Conversion Result Bit 9 */
        byte BIT10       :1;                                       /* ATD Conversion Result Bit 10 */
        byte BIT11       :1;                                       /* ATD Conversion Result Bit 11 */
        byte BIT12       :1;                                       /* ATD Conversion Result Bit 12 */
        byte BIT13       :1;                                       /* ATD Conversion Result Bit 13 */
        byte BIT14       :1;                                       /* ATD Conversion Result Bit 14 */
        byte BIT15       :1;                                       /* ATD Conversion Result Bit 15 */
      } Bits;
    } ATDDR6HSTR;
    #define ATDDR6H                     _ATDDR6.Overlap_STR.ATDDR6HSTR.Byte
    #define ATDDR6H_BIT8                _ATDDR6.Overlap_STR.ATDDR6HSTR.Bits.BIT8
    #define ATDDR6H_BIT9                _ATDDR6.Overlap_STR.ATDDR6HSTR.Bits.BIT9
    #define ATDDR6H_BIT10               _ATDDR6.Overlap_STR.ATDDR6HSTR.Bits.BIT10
    #define ATDDR6H_BIT11               _ATDDR6.Overlap_STR.ATDDR6HSTR.Bits.BIT11
    #define ATDDR6H_BIT12               _ATDDR6.Overlap_STR.ATDDR6HSTR.Bits.BIT12
    #define ATDDR6H_BIT13               _ATDDR6.Overlap_STR.ATDDR6HSTR.Bits.BIT13
    #define ATDDR6H_BIT14               _ATDDR6.Overlap_STR.ATDDR6HSTR.Bits.BIT14
    #define ATDDR6H_BIT15               _ATDDR6.Overlap_STR.ATDDR6HSTR.Bits.BIT15
    
    #define ATDDR6H_BIT8_MASK           1U
    #define ATDDR6H_BIT9_MASK           2U
    #define ATDDR6H_BIT10_MASK          4U
    #define ATDDR6H_BIT11_MASK          8U
    #define ATDDR6H_BIT12_MASK          16U
    #define ATDDR6H_BIT13_MASK          32U
    #define ATDDR6H_BIT14_MASK          64U
    #define ATDDR6H_BIT15_MASK          128U
    

    /*** ATDDR6L - ATD Conversion Result Register 6 Low; 0x0000009D ***/
    union {
      byte Byte;
      struct {
        byte BIT0        :1;                                       /* ATD Conversion Result Bit 0 */
        byte BIT1        :1;                                       /* ATD Conversion Result Bit 1 */
        byte BIT2        :1;                                       /* ATD Conversion Result Bit 2 */
        byte BIT3        :1;                                       /* ATD Conversion Result Bit 3 */
        byte BIT4        :1;                                       /* ATD Conversion Result Bit 4 */
        byte BIT5        :1;                                       /* ATD Conversion Result Bit 5 */
        byte BIT6        :1;                                       /* ATD Conversion Result Bit 6 */
        byte BIT7        :1;                                       /* ATD Conversion Result Bit 7 */
      } Bits;
    } ATDDR6LSTR;
    #define ATDDR6L                     _ATDDR6.Overlap_STR.ATDDR6LSTR.Byte
    #define ATDDR6L_BIT0                _ATDDR6.Overlap_STR.ATDDR6LSTR.Bits.BIT0
    #define ATDDR6L_BIT1                _ATDDR6.Overlap_STR.ATDDR6LSTR.Bits.BIT1
    #define ATDDR6L_BIT2                _ATDDR6.Overlap_STR.ATDDR6LSTR.Bits.BIT2
    #define ATDDR6L_BIT3                _ATDDR6.Overlap_STR.ATDDR6LSTR.Bits.BIT3
    #define ATDDR6L_BIT4                _ATDDR6.Overlap_STR.ATDDR6LSTR.Bits.BIT4
    #define ATDDR6L_BIT5                _ATDDR6.Overlap_STR.ATDDR6LSTR.Bits.BIT5
    #define ATDDR6L_BIT6                _ATDDR6.Overlap_STR.ATDDR6LSTR.Bits.BIT6
    #define ATDDR6L_BIT7                _ATDDR6.Overlap_STR.ATDDR6LSTR.Bits.BIT7
    
    #define ATDDR6L_BIT0_MASK           1U
    #define ATDDR6L_BIT1_MASK           2U
    #define ATDDR6L_BIT2_MASK           4U
    #define ATDDR6L_BIT3_MASK           8U
    #define ATDDR6L_BIT4_MASK           16U
    #define ATDDR6L_BIT5_MASK           32U
    #define ATDDR6L_BIT6_MASK           64U
    #define ATDDR6L_BIT7_MASK           128U
    
  } Overlap_STR;

  struct {
    word BIT0        :1;                                       /* ATD Conversion Result Bit 0 */
    word BIT1        :1;                                       /* ATD Conversion Result Bit 1 */
    word BIT2        :1;                                       /* ATD Conversion Result Bit 2 */
    word BIT3        :1;                                       /* ATD Conversion Result Bit 3 */
    word BIT4        :1;                                       /* ATD Conversion Result Bit 4 */
    word BIT5        :1;                                       /* ATD Conversion Result Bit 5 */
    word BIT6        :1;                                       /* ATD Conversion Result Bit 6 */
    word BIT7        :1;                                       /* ATD Conversion Result Bit 7 */
    word BIT8        :1;                                       /* ATD Conversion Result Bit 8 */
    word BIT9        :1;                                       /* ATD Conversion Result Bit 9 */
    word BIT10       :1;                                       /* ATD Conversion Result Bit 10 */
    word BIT11       :1;                                       /* ATD Conversion Result Bit 11 */
    word BIT12       :1;                                       /* ATD Conversion Result Bit 12 */
    word BIT13       :1;                                       /* ATD Conversion Result Bit 13 */
    word BIT14       :1;                                       /* ATD Conversion Result Bit 14 */
    word BIT15       :1;                                       /* ATD Conversion Result Bit 15 */
  } Bits;
} ATDDR6STR;
extern volatile ATDDR6STR _ATDDR6 @(REG_BASE + 0x0000009CUL);
#define ATDDR6                          _ATDDR6.Word
#define ATDDR6_BIT0                     _ATDDR6.Bits.BIT0
#define ATDDR6_BIT1                     _ATDDR6.Bits.BIT1
#define ATDDR6_BIT2                     _ATDDR6.Bits.BIT2
#define ATDDR6_BIT3                     _ATDDR6.Bits.BIT3
#define ATDDR6_BIT4                     _ATDDR6.Bits.BIT4
#define ATDDR6_BIT5                     _ATDDR6.Bits.BIT5
#define ATDDR6_BIT6                     _ATDDR6.Bits.BIT6
#define ATDDR6_BIT7                     _ATDDR6.Bits.BIT7
#define ATDDR6_BIT8                     _ATDDR6.Bits.BIT8
#define ATDDR6_BIT9                     _ATDDR6.Bits.BIT9
#define ATDDR6_BIT10                    _ATDDR6.Bits.BIT10
#define ATDDR6_BIT11                    _ATDDR6.Bits.BIT11
#define ATDDR6_BIT12                    _ATDDR6.Bits.BIT12
#define ATDDR6_BIT13                    _ATDDR6.Bits.BIT13
#define ATDDR6_BIT14                    _ATDDR6.Bits.BIT14
#define ATDDR6_BIT15                    _ATDDR6.Bits.BIT15

#define ATDDR6_BIT0_MASK                1U
#define ATDDR6_BIT1_MASK                2U
#define ATDDR6_BIT2_MASK                4U
#define ATDDR6_BIT3_MASK                8U
#define ATDDR6_BIT4_MASK                16U
#define ATDDR6_BIT5_MASK                32U
#define ATDDR6_BIT6_MASK                64U
#define ATDDR6_BIT7_MASK                128U
#define ATDDR6_BIT8_MASK                256U
#define ATDDR6_BIT9_MASK                512U
#define ATDDR6_BIT10_MASK               1024U
#define ATDDR6_BIT11_MASK               2048U
#define ATDDR6_BIT12_MASK               4096U
#define ATDDR6_BIT13_MASK               8192U
#define ATDDR6_BIT14_MASK               16384U
#define ATDDR6_BIT15_MASK               32768U


/*** ATDDR7 - ATD Conversion Result Register 7; 0x0000009E ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATDDR7H - ATD Conversion Result Register 7 High; 0x0000009E ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* ATD Conversion Result Bit 8 */
        byte BIT9        :1;                                       /* ATD Conversion Result Bit 9 */
        byte BIT10       :1;                                       /* ATD Conversion Result Bit 10 */
        byte BIT11       :1;                                       /* ATD Conversion Result Bit 11 */
        byte BIT12       :1;                                       /* ATD Conversion Result Bit 12 */
        byte BIT13       :1;                                       /* ATD Conversion Result Bit 13 */
        byte BIT14       :1;                                       /* ATD Conversion Result Bit 14 */
        byte BIT15       :1;                                       /* ATD Conversion Result Bit 15 */
      } Bits;
    } ATDDR7HSTR;
    #define ATDDR7H                     _ATDDR7.Overlap_STR.ATDDR7HSTR.Byte
    #define ATDDR7H_BIT8                _ATDDR7.Overlap_STR.ATDDR7HSTR.Bits.BIT8
    #define ATDDR7H_BIT9                _ATDDR7.Overlap_STR.ATDDR7HSTR.Bits.BIT9
    #define ATDDR7H_BIT10               _ATDDR7.Overlap_STR.ATDDR7HSTR.Bits.BIT10
    #define ATDDR7H_BIT11               _ATDDR7.Overlap_STR.ATDDR7HSTR.Bits.BIT11
    #define ATDDR7H_BIT12               _ATDDR7.Overlap_STR.ATDDR7HSTR.Bits.BIT12
    #define ATDDR7H_BIT13               _ATDDR7.Overlap_STR.ATDDR7HSTR.Bits.BIT13
    #define ATDDR7H_BIT14               _ATDDR7.Overlap_STR.ATDDR7HSTR.Bits.BIT14
    #define ATDDR7H_BIT15               _ATDDR7.Overlap_STR.ATDDR7HSTR.Bits.BIT15
    
    #define ATDDR7H_BIT8_MASK           1U
    #define ATDDR7H_BIT9_MASK           2U
    #define ATDDR7H_BIT10_MASK          4U
    #define ATDDR7H_BIT11_MASK          8U
    #define ATDDR7H_BIT12_MASK          16U
    #define ATDDR7H_BIT13_MASK          32U
    #define ATDDR7H_BIT14_MASK          64U
    #define ATDDR7H_BIT15_MASK          128U
    

    /*** ATDDR7L - ATD Conversion Result Register 7 Low; 0x0000009F ***/
    union {
      byte Byte;
      struct {
        byte BIT0        :1;                                       /* ATD Conversion Result Bit 0 */
        byte BIT1        :1;                                       /* ATD Conversion Result Bit 1 */
        byte BIT2        :1;                                       /* ATD Conversion Result Bit 2 */
        byte BIT3        :1;                                       /* ATD Conversion Result Bit 3 */
        byte BIT4        :1;                                       /* ATD Conversion Result Bit 4 */
        byte BIT5        :1;                                       /* ATD Conversion Result Bit 5 */
        byte BIT6        :1;                                       /* ATD Conversion Result Bit 6 */
        byte BIT7        :1;                                       /* ATD Conversion Result Bit 7 */
      } Bits;
    } ATDDR7LSTR;
    #define ATDDR7L                     _ATDDR7.Overlap_STR.ATDDR7LSTR.Byte
    #define ATDDR7L_BIT0                _ATDDR7.Overlap_STR.ATDDR7LSTR.Bits.BIT0
    #define ATDDR7L_BIT1                _ATDDR7.Overlap_STR.ATDDR7LSTR.Bits.BIT1
    #define ATDDR7L_BIT2                _ATDDR7.Overlap_STR.ATDDR7LSTR.Bits.BIT2
    #define ATDDR7L_BIT3                _ATDDR7.Overlap_STR.ATDDR7LSTR.Bits.BIT3
    #define ATDDR7L_BIT4                _ATDDR7.Overlap_STR.ATDDR7LSTR.Bits.BIT4
    #define ATDDR7L_BIT5                _ATDDR7.Overlap_STR.ATDDR7LSTR.Bits.BIT5
    #define ATDDR7L_BIT6                _ATDDR7.Overlap_STR.ATDDR7LSTR.Bits.BIT6
    #define ATDDR7L_BIT7                _ATDDR7.Overlap_STR.ATDDR7LSTR.Bits.BIT7
    
    #define ATDDR7L_BIT0_MASK           1U
    #define ATDDR7L_BIT1_MASK           2U
    #define ATDDR7L_BIT2_MASK           4U
    #define ATDDR7L_BIT3_MASK           8U
    #define ATDDR7L_BIT4_MASK           16U
    #define ATDDR7L_BIT5_MASK           32U
    #define ATDDR7L_BIT6_MASK           64U
    #define ATDDR7L_BIT7_MASK           128U
    
  } Overlap_STR;

  struct {
    word BIT0        :1;                                       /* ATD Conversion Result Bit 0 */
    word BIT1        :1;                                       /* ATD Conversion Result Bit 1 */
    word BIT2        :1;                                       /* ATD Conversion Result Bit 2 */
    word BIT3        :1;                                       /* ATD Conversion Result Bit 3 */
    word BIT4        :1;                                       /* ATD Conversion Result Bit 4 */
    word BIT5        :1;                                       /* ATD Conversion Result Bit 5 */
    word BIT6        :1;                                       /* ATD Conversion Result Bit 6 */
    word BIT7        :1;                                       /* ATD Conversion Result Bit 7 */
    word BIT8        :1;                                       /* ATD Conversion Result Bit 8 */
    word BIT9        :1;                                       /* ATD Conversion Result Bit 9 */
    word BIT10       :1;                                       /* ATD Conversion Result Bit 10 */
    word BIT11       :1;                                       /* ATD Conversion Result Bit 11 */
    word BIT12       :1;                                       /* ATD Conversion Result Bit 12 */
    word BIT13       :1;                                       /* ATD Conversion Result Bit 13 */
    word BIT14       :1;                                       /* ATD Conversion Result Bit 14 */
    word BIT15       :1;                                       /* ATD Conversion Result Bit 15 */
  } Bits;
} ATDDR7STR;
extern volatile ATDDR7STR _ATDDR7 @(REG_BASE + 0x0000009EUL);
#define ATDDR7                          _ATDDR7.Word
#define ATDDR7_BIT0                     _ATDDR7.Bits.BIT0
#define ATDDR7_BIT1                     _ATDDR7.Bits.BIT1
#define ATDDR7_BIT2                     _ATDDR7.Bits.BIT2
#define ATDDR7_BIT3                     _ATDDR7.Bits.BIT3
#define ATDDR7_BIT4                     _ATDDR7.Bits.BIT4
#define ATDDR7_BIT5                     _ATDDR7.Bits.BIT5
#define ATDDR7_BIT6                     _ATDDR7.Bits.BIT6
#define ATDDR7_BIT7                     _ATDDR7.Bits.BIT7
#define ATDDR7_BIT8                     _ATDDR7.Bits.BIT8
#define ATDDR7_BIT9                     _ATDDR7.Bits.BIT9
#define ATDDR7_BIT10                    _ATDDR7.Bits.BIT10
#define ATDDR7_BIT11                    _ATDDR7.Bits.BIT11
#define ATDDR7_BIT12                    _ATDDR7.Bits.BIT12
#define ATDDR7_BIT13                    _ATDDR7.Bits.BIT13
#define ATDDR7_BIT14                    _ATDDR7.Bits.BIT14
#define ATDDR7_BIT15                    _ATDDR7.Bits.BIT15

#define ATDDR7_BIT0_MASK                1U
#define ATDDR7_BIT1_MASK                2U
#define ATDDR7_BIT2_MASK                4U
#define ATDDR7_BIT3_MASK                8U
#define ATDDR7_BIT4_MASK                16U
#define ATDDR7_BIT5_MASK                32U
#define ATDDR7_BIT6_MASK                64U
#define ATDDR7_BIT7_MASK                128U
#define ATDDR7_BIT8_MASK                256U
#define ATDDR7_BIT9_MASK                512U
#define ATDDR7_BIT10_MASK               1024U
#define ATDDR7_BIT11_MASK               2048U
#define ATDDR7_BIT12_MASK               4096U
#define ATDDR7_BIT13_MASK               8192U
#define ATDDR7_BIT14_MASK               16384U
#define ATDDR7_BIT15_MASK               32768U


/*** ATDDR8 - ATD Conversion Result Register 8; 0x000000A0 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATDDR8H - ATD Conversion Result Register 8 High; 0x000000A0 ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* ATD Conversion Result Bit 8 */
        byte BIT9        :1;                                       /* ATD Conversion Result Bit 9 */
        byte BIT10       :1;                                       /* ATD Conversion Result Bit 10 */
        byte BIT11       :1;                                       /* ATD Conversion Result Bit 11 */
        byte BIT12       :1;                                       /* ATD Conversion Result Bit 12 */
        byte BIT13       :1;                                       /* ATD Conversion Result Bit 13 */
        byte BIT14       :1;                                       /* ATD Conversion Result Bit 14 */
        byte BIT15       :1;                                       /* ATD Conversion Result Bit 15 */
      } Bits;
    } ATDDR8HSTR;
    #define ATDDR8H                     _ATDDR8.Overlap_STR.ATDDR8HSTR.Byte
    #define ATDDR8H_BIT8                _ATDDR8.Overlap_STR.ATDDR8HSTR.Bits.BIT8
    #define ATDDR8H_BIT9                _ATDDR8.Overlap_STR.ATDDR8HSTR.Bits.BIT9
    #define ATDDR8H_BIT10               _ATDDR8.Overlap_STR.ATDDR8HSTR.Bits.BIT10
    #define ATDDR8H_BIT11               _ATDDR8.Overlap_STR.ATDDR8HSTR.Bits.BIT11
    #define ATDDR8H_BIT12               _ATDDR8.Overlap_STR.ATDDR8HSTR.Bits.BIT12
    #define ATDDR8H_BIT13               _ATDDR8.Overlap_STR.ATDDR8HSTR.Bits.BIT13
    #define ATDDR8H_BIT14               _ATDDR8.Overlap_STR.ATDDR8HSTR.Bits.BIT14
    #define ATDDR8H_BIT15               _ATDDR8.Overlap_STR.ATDDR8HSTR.Bits.BIT15
    
    #define ATDDR8H_BIT8_MASK           1U
    #define ATDDR8H_BIT9_MASK           2U
    #define ATDDR8H_BIT10_MASK          4U
    #define ATDDR8H_BIT11_MASK          8U
    #define ATDDR8H_BIT12_MASK          16U
    #define ATDDR8H_BIT13_MASK          32U
    #define ATDDR8H_BIT14_MASK          64U
    #define ATDDR8H_BIT15_MASK          128U
    

    /*** ATDDR8L - ATD Conversion Result Register 8 Low; 0x000000A1 ***/
    union {
      byte Byte;
      struct {
        byte BIT0        :1;                                       /* ATD Conversion Result Bit 0 */
        byte BIT1        :1;                                       /* ATD Conversion Result Bit 1 */
        byte BIT2        :1;                                       /* ATD Conversion Result Bit 2 */
        byte BIT3        :1;                                       /* ATD Conversion Result Bit 3 */
        byte BIT4        :1;                                       /* ATD Conversion Result Bit 4 */
        byte BIT5        :1;                                       /* ATD Conversion Result Bit 5 */
        byte BIT6        :1;                                       /* ATD Conversion Result Bit 6 */
        byte BIT7        :1;                                       /* ATD Conversion Result Bit 7 */
      } Bits;
    } ATDDR8LSTR;
    #define ATDDR8L                     _ATDDR8.Overlap_STR.ATDDR8LSTR.Byte
    #define ATDDR8L_BIT0                _ATDDR8.Overlap_STR.ATDDR8LSTR.Bits.BIT0
    #define ATDDR8L_BIT1                _ATDDR8.Overlap_STR.ATDDR8LSTR.Bits.BIT1
    #define ATDDR8L_BIT2                _ATDDR8.Overlap_STR.ATDDR8LSTR.Bits.BIT2
    #define ATDDR8L_BIT3                _ATDDR8.Overlap_STR.ATDDR8LSTR.Bits.BIT3
    #define ATDDR8L_BIT4                _ATDDR8.Overlap_STR.ATDDR8LSTR.Bits.BIT4
    #define ATDDR8L_BIT5                _ATDDR8.Overlap_STR.ATDDR8LSTR.Bits.BIT5
    #define ATDDR8L_BIT6                _ATDDR8.Overlap_STR.ATDDR8LSTR.Bits.BIT6
    #define ATDDR8L_BIT7                _ATDDR8.Overlap_STR.ATDDR8LSTR.Bits.BIT7
    
    #define ATDDR8L_BIT0_MASK           1U
    #define ATDDR8L_BIT1_MASK           2U
    #define ATDDR8L_BIT2_MASK           4U
    #define ATDDR8L_BIT3_MASK           8U
    #define ATDDR8L_BIT4_MASK           16U
    #define ATDDR8L_BIT5_MASK           32U
    #define ATDDR8L_BIT6_MASK           64U
    #define ATDDR8L_BIT7_MASK           128U
    
  } Overlap_STR;

  struct {
    word BIT0        :1;                                       /* ATD Conversion Result Bit 0 */
    word BIT1        :1;                                       /* ATD Conversion Result Bit 1 */
    word BIT2        :1;                                       /* ATD Conversion Result Bit 2 */
    word BIT3        :1;                                       /* ATD Conversion Result Bit 3 */
    word BIT4        :1;                                       /* ATD Conversion Result Bit 4 */
    word BIT5        :1;                                       /* ATD Conversion Result Bit 5 */
    word BIT6        :1;                                       /* ATD Conversion Result Bit 6 */
    word BIT7        :1;                                       /* ATD Conversion Result Bit 7 */
    word BIT8        :1;                                       /* ATD Conversion Result Bit 8 */
    word BIT9        :1;                                       /* ATD Conversion Result Bit 9 */
    word BIT10       :1;                                       /* ATD Conversion Result Bit 10 */
    word BIT11       :1;                                       /* ATD Conversion Result Bit 11 */
    word BIT12       :1;                                       /* ATD Conversion Result Bit 12 */
    word BIT13       :1;                                       /* ATD Conversion Result Bit 13 */
    word BIT14       :1;                                       /* ATD Conversion Result Bit 14 */
    word BIT15       :1;                                       /* ATD Conversion Result Bit 15 */
  } Bits;
} ATDDR8STR;
extern volatile ATDDR8STR _ATDDR8 @(REG_BASE + 0x000000A0UL);
#define ATDDR8                          _ATDDR8.Word
#define ATDDR8_BIT0                     _ATDDR8.Bits.BIT0
#define ATDDR8_BIT1                     _ATDDR8.Bits.BIT1
#define ATDDR8_BIT2                     _ATDDR8.Bits.BIT2
#define ATDDR8_BIT3                     _ATDDR8.Bits.BIT3
#define ATDDR8_BIT4                     _ATDDR8.Bits.BIT4
#define ATDDR8_BIT5                     _ATDDR8.Bits.BIT5
#define ATDDR8_BIT6                     _ATDDR8.Bits.BIT6
#define ATDDR8_BIT7                     _ATDDR8.Bits.BIT7
#define ATDDR8_BIT8                     _ATDDR8.Bits.BIT8
#define ATDDR8_BIT9                     _ATDDR8.Bits.BIT9
#define ATDDR8_BIT10                    _ATDDR8.Bits.BIT10
#define ATDDR8_BIT11                    _ATDDR8.Bits.BIT11
#define ATDDR8_BIT12                    _ATDDR8.Bits.BIT12
#define ATDDR8_BIT13                    _ATDDR8.Bits.BIT13
#define ATDDR8_BIT14                    _ATDDR8.Bits.BIT14
#define ATDDR8_BIT15                    _ATDDR8.Bits.BIT15

#define ATDDR8_BIT0_MASK                1U
#define ATDDR8_BIT1_MASK                2U
#define ATDDR8_BIT2_MASK                4U
#define ATDDR8_BIT3_MASK                8U
#define ATDDR8_BIT4_MASK                16U
#define ATDDR8_BIT5_MASK                32U
#define ATDDR8_BIT6_MASK                64U
#define ATDDR8_BIT7_MASK                128U
#define ATDDR8_BIT8_MASK                256U
#define ATDDR8_BIT9_MASK                512U
#define ATDDR8_BIT10_MASK               1024U
#define ATDDR8_BIT11_MASK               2048U
#define ATDDR8_BIT12_MASK               4096U
#define ATDDR8_BIT13_MASK               8192U
#define ATDDR8_BIT14_MASK               16384U
#define ATDDR8_BIT15_MASK               32768U


/*** ATDDR9 - ATD Conversion Result Register 9; 0x000000A2 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATDDR9H - ATD Conversion Result Register 9 High; 0x000000A2 ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* ATD Conversion Result Bit 8 */
        byte BIT9        :1;                                       /* ATD Conversion Result Bit 9 */
        byte BIT10       :1;                                       /* ATD Conversion Result Bit 10 */
        byte BIT11       :1;                                       /* ATD Conversion Result Bit 11 */
        byte BIT12       :1;                                       /* ATD Conversion Result Bit 12 */
        byte BIT13       :1;                                       /* ATD Conversion Result Bit 13 */
        byte BIT14       :1;                                       /* ATD Conversion Result Bit 14 */
        byte BIT15       :1;                                       /* ATD Conversion Result Bit 15 */
      } Bits;
    } ATDDR9HSTR;
    #define ATDDR9H                     _ATDDR9.Overlap_STR.ATDDR9HSTR.Byte
    #define ATDDR9H_BIT8                _ATDDR9.Overlap_STR.ATDDR9HSTR.Bits.BIT8
    #define ATDDR9H_BIT9                _ATDDR9.Overlap_STR.ATDDR9HSTR.Bits.BIT9
    #define ATDDR9H_BIT10               _ATDDR9.Overlap_STR.ATDDR9HSTR.Bits.BIT10
    #define ATDDR9H_BIT11               _ATDDR9.Overlap_STR.ATDDR9HSTR.Bits.BIT11
    #define ATDDR9H_BIT12               _ATDDR9.Overlap_STR.ATDDR9HSTR.Bits.BIT12
    #define ATDDR9H_BIT13               _ATDDR9.Overlap_STR.ATDDR9HSTR.Bits.BIT13
    #define ATDDR9H_BIT14               _ATDDR9.Overlap_STR.ATDDR9HSTR.Bits.BIT14
    #define ATDDR9H_BIT15               _ATDDR9.Overlap_STR.ATDDR9HSTR.Bits.BIT15
    
    #define ATDDR9H_BIT8_MASK           1U
    #define ATDDR9H_BIT9_MASK           2U
    #define ATDDR9H_BIT10_MASK          4U
    #define ATDDR9H_BIT11_MASK          8U
    #define ATDDR9H_BIT12_MASK          16U
    #define ATDDR9H_BIT13_MASK          32U
    #define ATDDR9H_BIT14_MASK          64U
    #define ATDDR9H_BIT15_MASK          128U
    

    /*** ATDDR9L - ATD Conversion Result Register 9 Low; 0x000000A3 ***/
    union {
      byte Byte;
      struct {
        byte BIT0        :1;                                       /* ATD Conversion Result Bit 0 */
        byte BIT1        :1;                                       /* ATD Conversion Result Bit 1 */
        byte BIT2        :1;                                       /* ATD Conversion Result Bit 2 */
        byte BIT3        :1;                                       /* ATD Conversion Result Bit 3 */
        byte BIT4        :1;                                       /* ATD Conversion Result Bit 4 */
        byte BIT5        :1;                                       /* ATD Conversion Result Bit 5 */
        byte BIT6        :1;                                       /* ATD Conversion Result Bit 6 */
        byte BIT7        :1;                                       /* ATD Conversion Result Bit 7 */
      } Bits;
    } ATDDR9LSTR;
    #define ATDDR9L                     _ATDDR9.Overlap_STR.ATDDR9LSTR.Byte
    #define ATDDR9L_BIT0                _ATDDR9.Overlap_STR.ATDDR9LSTR.Bits.BIT0
    #define ATDDR9L_BIT1                _ATDDR9.Overlap_STR.ATDDR9LSTR.Bits.BIT1
    #define ATDDR9L_BIT2                _ATDDR9.Overlap_STR.ATDDR9LSTR.Bits.BIT2
    #define ATDDR9L_BIT3                _ATDDR9.Overlap_STR.ATDDR9LSTR.Bits.BIT3
    #define ATDDR9L_BIT4                _ATDDR9.Overlap_STR.ATDDR9LSTR.Bits.BIT4
    #define ATDDR9L_BIT5                _ATDDR9.Overlap_STR.ATDDR9LSTR.Bits.BIT5
    #define ATDDR9L_BIT6                _ATDDR9.Overlap_STR.ATDDR9LSTR.Bits.BIT6
    #define ATDDR9L_BIT7                _ATDDR9.Overlap_STR.ATDDR9LSTR.Bits.BIT7
    
    #define ATDDR9L_BIT0_MASK           1U
    #define ATDDR9L_BIT1_MASK           2U
    #define ATDDR9L_BIT2_MASK           4U
    #define ATDDR9L_BIT3_MASK           8U
    #define ATDDR9L_BIT4_MASK           16U
    #define ATDDR9L_BIT5_MASK           32U
    #define ATDDR9L_BIT6_MASK           64U
    #define ATDDR9L_BIT7_MASK           128U
    
  } Overlap_STR;

  struct {
    word BIT0        :1;                                       /* ATD Conversion Result Bit 0 */
    word BIT1        :1;                                       /* ATD Conversion Result Bit 1 */
    word BIT2        :1;                                       /* ATD Conversion Result Bit 2 */
    word BIT3        :1;                                       /* ATD Conversion Result Bit 3 */
    word BIT4        :1;                                       /* ATD Conversion Result Bit 4 */
    word BIT5        :1;                                       /* ATD Conversion Result Bit 5 */
    word BIT6        :1;                                       /* ATD Conversion Result Bit 6 */
    word BIT7        :1;                                       /* ATD Conversion Result Bit 7 */
    word BIT8        :1;                                       /* ATD Conversion Result Bit 8 */
    word BIT9        :1;                                       /* ATD Conversion Result Bit 9 */
    word BIT10       :1;                                       /* ATD Conversion Result Bit 10 */
    word BIT11       :1;                                       /* ATD Conversion Result Bit 11 */
    word BIT12       :1;                                       /* ATD Conversion Result Bit 12 */
    word BIT13       :1;                                       /* ATD Conversion Result Bit 13 */
    word BIT14       :1;                                       /* ATD Conversion Result Bit 14 */
    word BIT15       :1;                                       /* ATD Conversion Result Bit 15 */
  } Bits;
} ATDDR9STR;
extern volatile ATDDR9STR _ATDDR9 @(REG_BASE + 0x000000A2UL);
#define ATDDR9                          _ATDDR9.Word
#define ATDDR9_BIT0                     _ATDDR9.Bits.BIT0
#define ATDDR9_BIT1                     _ATDDR9.Bits.BIT1
#define ATDDR9_BIT2                     _ATDDR9.Bits.BIT2
#define ATDDR9_BIT3                     _ATDDR9.Bits.BIT3
#define ATDDR9_BIT4                     _ATDDR9.Bits.BIT4
#define ATDDR9_BIT5                     _ATDDR9.Bits.BIT5
#define ATDDR9_BIT6                     _ATDDR9.Bits.BIT6
#define ATDDR9_BIT7                     _ATDDR9.Bits.BIT7
#define ATDDR9_BIT8                     _ATDDR9.Bits.BIT8
#define ATDDR9_BIT9                     _ATDDR9.Bits.BIT9
#define ATDDR9_BIT10                    _ATDDR9.Bits.BIT10
#define ATDDR9_BIT11                    _ATDDR9.Bits.BIT11
#define ATDDR9_BIT12                    _ATDDR9.Bits.BIT12
#define ATDDR9_BIT13                    _ATDDR9.Bits.BIT13
#define ATDDR9_BIT14                    _ATDDR9.Bits.BIT14
#define ATDDR9_BIT15                    _ATDDR9.Bits.BIT15

#define ATDDR9_BIT0_MASK                1U
#define ATDDR9_BIT1_MASK                2U
#define ATDDR9_BIT2_MASK                4U
#define ATDDR9_BIT3_MASK                8U
#define ATDDR9_BIT4_MASK                16U
#define ATDDR9_BIT5_MASK                32U
#define ATDDR9_BIT6_MASK                64U
#define ATDDR9_BIT7_MASK                128U
#define ATDDR9_BIT8_MASK                256U
#define ATDDR9_BIT9_MASK                512U
#define ATDDR9_BIT10_MASK               1024U
#define ATDDR9_BIT11_MASK               2048U
#define ATDDR9_BIT12_MASK               4096U
#define ATDDR9_BIT13_MASK               8192U
#define ATDDR9_BIT14_MASK               16384U
#define ATDDR9_BIT15_MASK               32768U


/*** ATDDR10 - ATD Conversion Result Register 10; 0x000000A4 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATDDR10H - ATD Conversion Result Register 10 High; 0x000000A4 ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* ATD Conversion Result Bit 8 */
        byte BIT9        :1;                                       /* ATD Conversion Result Bit 9 */
        byte BIT10       :1;                                       /* ATD Conversion Result Bit 10 */
        byte BIT11       :1;                                       /* ATD Conversion Result Bit 11 */
        byte BIT12       :1;                                       /* ATD Conversion Result Bit 12 */
        byte BIT13       :1;                                       /* ATD Conversion Result Bit 13 */
        byte BIT14       :1;                                       /* ATD Conversion Result Bit 14 */
        byte BIT15       :1;                                       /* ATD Conversion Result Bit 15 */
      } Bits;
    } ATDDR10HSTR;
    #define ATDDR10H                    _ATDDR10.Overlap_STR.ATDDR10HSTR.Byte
    #define ATDDR10H_BIT8               _ATDDR10.Overlap_STR.ATDDR10HSTR.Bits.BIT8
    #define ATDDR10H_BIT9               _ATDDR10.Overlap_STR.ATDDR10HSTR.Bits.BIT9
    #define ATDDR10H_BIT10              _ATDDR10.Overlap_STR.ATDDR10HSTR.Bits.BIT10
    #define ATDDR10H_BIT11              _ATDDR10.Overlap_STR.ATDDR10HSTR.Bits.BIT11
    #define ATDDR10H_BIT12              _ATDDR10.Overlap_STR.ATDDR10HSTR.Bits.BIT12
    #define ATDDR10H_BIT13              _ATDDR10.Overlap_STR.ATDDR10HSTR.Bits.BIT13
    #define ATDDR10H_BIT14              _ATDDR10.Overlap_STR.ATDDR10HSTR.Bits.BIT14
    #define ATDDR10H_BIT15              _ATDDR10.Overlap_STR.ATDDR10HSTR.Bits.BIT15
    
    #define ATDDR10H_BIT8_MASK          1U
    #define ATDDR10H_BIT9_MASK          2U
    #define ATDDR10H_BIT10_MASK         4U
    #define ATDDR10H_BIT11_MASK         8U
    #define ATDDR10H_BIT12_MASK         16U
    #define ATDDR10H_BIT13_MASK         32U
    #define ATDDR10H_BIT14_MASK         64U
    #define ATDDR10H_BIT15_MASK         128U
    

    /*** ATDDR10L - ATD Conversion Result Register 10 Low; 0x000000A5 ***/
    union {
      byte Byte;
      struct {
        byte BIT0        :1;                                       /* ATD Conversion Result Bit 0 */
        byte BIT1        :1;                                       /* ATD Conversion Result Bit 1 */
        byte BIT2        :1;                                       /* ATD Conversion Result Bit 2 */
        byte BIT3        :1;                                       /* ATD Conversion Result Bit 3 */
        byte BIT4        :1;                                       /* ATD Conversion Result Bit 4 */
        byte BIT5        :1;                                       /* ATD Conversion Result Bit 5 */
        byte BIT6        :1;                                       /* ATD Conversion Result Bit 6 */
        byte BIT7        :1;                                       /* ATD Conversion Result Bit 7 */
      } Bits;
    } ATDDR10LSTR;
    #define ATDDR10L                    _ATDDR10.Overlap_STR.ATDDR10LSTR.Byte
    #define ATDDR10L_BIT0               _ATDDR10.Overlap_STR.ATDDR10LSTR.Bits.BIT0
    #define ATDDR10L_BIT1               _ATDDR10.Overlap_STR.ATDDR10LSTR.Bits.BIT1
    #define ATDDR10L_BIT2               _ATDDR10.Overlap_STR.ATDDR10LSTR.Bits.BIT2
    #define ATDDR10L_BIT3               _ATDDR10.Overlap_STR.ATDDR10LSTR.Bits.BIT3
    #define ATDDR10L_BIT4               _ATDDR10.Overlap_STR.ATDDR10LSTR.Bits.BIT4
    #define ATDDR10L_BIT5               _ATDDR10.Overlap_STR.ATDDR10LSTR.Bits.BIT5
    #define ATDDR10L_BIT6               _ATDDR10.Overlap_STR.ATDDR10LSTR.Bits.BIT6
    #define ATDDR10L_BIT7               _ATDDR10.Overlap_STR.ATDDR10LSTR.Bits.BIT7
    
    #define ATDDR10L_BIT0_MASK          1U
    #define ATDDR10L_BIT1_MASK          2U
    #define ATDDR10L_BIT2_MASK          4U
    #define ATDDR10L_BIT3_MASK          8U
    #define ATDDR10L_BIT4_MASK          16U
    #define ATDDR10L_BIT5_MASK          32U
    #define ATDDR10L_BIT6_MASK          64U
    #define ATDDR10L_BIT7_MASK          128U
    
  } Overlap_STR;

  struct {
    word BIT0        :1;                                       /* ATD Conversion Result Bit 0 */
    word BIT1        :1;                                       /* ATD Conversion Result Bit 1 */
    word BIT2        :1;                                       /* ATD Conversion Result Bit 2 */
    word BIT3        :1;                                       /* ATD Conversion Result Bit 3 */
    word BIT4        :1;                                       /* ATD Conversion Result Bit 4 */
    word BIT5        :1;                                       /* ATD Conversion Result Bit 5 */
    word BIT6        :1;                                       /* ATD Conversion Result Bit 6 */
    word BIT7        :1;                                       /* ATD Conversion Result Bit 7 */
    word BIT8        :1;                                       /* ATD Conversion Result Bit 8 */
    word BIT9        :1;                                       /* ATD Conversion Result Bit 9 */
    word BIT10       :1;                                       /* ATD Conversion Result Bit 10 */
    word BIT11       :1;                                       /* ATD Conversion Result Bit 11 */
    word BIT12       :1;                                       /* ATD Conversion Result Bit 12 */
    word BIT13       :1;                                       /* ATD Conversion Result Bit 13 */
    word BIT14       :1;                                       /* ATD Conversion Result Bit 14 */
    word BIT15       :1;                                       /* ATD Conversion Result Bit 15 */
  } Bits;
} ATDDR10STR;
extern volatile ATDDR10STR _ATDDR10 @(REG_BASE + 0x000000A4UL);
#define ATDDR10                         _ATDDR10.Word
#define ATDDR10_BIT0                    _ATDDR10.Bits.BIT0
#define ATDDR10_BIT1                    _ATDDR10.Bits.BIT1
#define ATDDR10_BIT2                    _ATDDR10.Bits.BIT2
#define ATDDR10_BIT3                    _ATDDR10.Bits.BIT3
#define ATDDR10_BIT4                    _ATDDR10.Bits.BIT4
#define ATDDR10_BIT5                    _ATDDR10.Bits.BIT5
#define ATDDR10_BIT6                    _ATDDR10.Bits.BIT6
#define ATDDR10_BIT7                    _ATDDR10.Bits.BIT7
#define ATDDR10_BIT8                    _ATDDR10.Bits.BIT8
#define ATDDR10_BIT9                    _ATDDR10.Bits.BIT9
#define ATDDR10_BIT10                   _ATDDR10.Bits.BIT10
#define ATDDR10_BIT11                   _ATDDR10.Bits.BIT11
#define ATDDR10_BIT12                   _ATDDR10.Bits.BIT12
#define ATDDR10_BIT13                   _ATDDR10.Bits.BIT13
#define ATDDR10_BIT14                   _ATDDR10.Bits.BIT14
#define ATDDR10_BIT15                   _ATDDR10.Bits.BIT15

#define ATDDR10_BIT0_MASK               1U
#define ATDDR10_BIT1_MASK               2U
#define ATDDR10_BIT2_MASK               4U
#define ATDDR10_BIT3_MASK               8U
#define ATDDR10_BIT4_MASK               16U
#define ATDDR10_BIT5_MASK               32U
#define ATDDR10_BIT6_MASK               64U
#define ATDDR10_BIT7_MASK               128U
#define ATDDR10_BIT8_MASK               256U
#define ATDDR10_BIT9_MASK               512U
#define ATDDR10_BIT10_MASK              1024U
#define ATDDR10_BIT11_MASK              2048U
#define ATDDR10_BIT12_MASK              4096U
#define ATDDR10_BIT13_MASK              8192U
#define ATDDR10_BIT14_MASK              16384U
#define ATDDR10_BIT15_MASK              32768U


/*** ATDDR11 - ATD Conversion Result Register 11; 0x000000A6 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATDDR11H - ATD Conversion Result Register 11 High; 0x000000A6 ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* ATD Conversion Result Bit 8 */
        byte BIT9        :1;                                       /* ATD Conversion Result Bit 9 */
        byte BIT10       :1;                                       /* ATD Conversion Result Bit 10 */
        byte BIT11       :1;                                       /* ATD Conversion Result Bit 11 */
        byte BIT12       :1;                                       /* ATD Conversion Result Bit 12 */
        byte BIT13       :1;                                       /* ATD Conversion Result Bit 13 */
        byte BIT14       :1;                                       /* ATD Conversion Result Bit 14 */
        byte BIT15       :1;                                       /* ATD Conversion Result Bit 15 */
      } Bits;
    } ATDDR11HSTR;
    #define ATDDR11H                    _ATDDR11.Overlap_STR.ATDDR11HSTR.Byte
    #define ATDDR11H_BIT8               _ATDDR11.Overlap_STR.ATDDR11HSTR.Bits.BIT8
    #define ATDDR11H_BIT9               _ATDDR11.Overlap_STR.ATDDR11HSTR.Bits.BIT9
    #define ATDDR11H_BIT10              _ATDDR11.Overlap_STR.ATDDR11HSTR.Bits.BIT10
    #define ATDDR11H_BIT11              _ATDDR11.Overlap_STR.ATDDR11HSTR.Bits.BIT11
    #define ATDDR11H_BIT12              _ATDDR11.Overlap_STR.ATDDR11HSTR.Bits.BIT12
    #define ATDDR11H_BIT13              _ATDDR11.Overlap_STR.ATDDR11HSTR.Bits.BIT13
    #define ATDDR11H_BIT14              _ATDDR11.Overlap_STR.ATDDR11HSTR.Bits.BIT14
    #define ATDDR11H_BIT15              _ATDDR11.Overlap_STR.ATDDR11HSTR.Bits.BIT15
    
    #define ATDDR11H_BIT8_MASK          1U
    #define ATDDR11H_BIT9_MASK          2U
    #define ATDDR11H_BIT10_MASK         4U
    #define ATDDR11H_BIT11_MASK         8U
    #define ATDDR11H_BIT12_MASK         16U
    #define ATDDR11H_BIT13_MASK         32U
    #define ATDDR11H_BIT14_MASK         64U
    #define ATDDR11H_BIT15_MASK         128U
    

    /*** ATDDR11L - ATD Conversion Result Register 11 Low; 0x000000A7 ***/
    union {
      byte Byte;
      struct {
        byte BIT0        :1;                                       /* ATD Conversion Result Bit 0 */
        byte BIT1        :1;                                       /* ATD Conversion Result Bit 1 */
        byte BIT2        :1;                                       /* ATD Conversion Result Bit 2 */
        byte BIT3        :1;                                       /* ATD Conversion Result Bit 3 */
        byte BIT4        :1;                                       /* ATD Conversion Result Bit 4 */
        byte BIT5        :1;                                       /* ATD Conversion Result Bit 5 */
        byte BIT6        :1;                                       /* ATD Conversion Result Bit 6 */
        byte BIT7        :1;                                       /* ATD Conversion Result Bit 7 */
      } Bits;
    } ATDDR11LSTR;
    #define ATDDR11L                    _ATDDR11.Overlap_STR.ATDDR11LSTR.Byte
    #define ATDDR11L_BIT0               _ATDDR11.Overlap_STR.ATDDR11LSTR.Bits.BIT0
    #define ATDDR11L_BIT1               _ATDDR11.Overlap_STR.ATDDR11LSTR.Bits.BIT1
    #define ATDDR11L_BIT2               _ATDDR11.Overlap_STR.ATDDR11LSTR.Bits.BIT2
    #define ATDDR11L_BIT3               _ATDDR11.Overlap_STR.ATDDR11LSTR.Bits.BIT3
    #define ATDDR11L_BIT4               _ATDDR11.Overlap_STR.ATDDR11LSTR.Bits.BIT4
    #define ATDDR11L_BIT5               _ATDDR11.Overlap_STR.ATDDR11LSTR.Bits.BIT5
    #define ATDDR11L_BIT6               _ATDDR11.Overlap_STR.ATDDR11LSTR.Bits.BIT6
    #define ATDDR11L_BIT7               _ATDDR11.Overlap_STR.ATDDR11LSTR.Bits.BIT7
    
    #define ATDDR11L_BIT0_MASK          1U
    #define ATDDR11L_BIT1_MASK          2U
    #define ATDDR11L_BIT2_MASK          4U
    #define ATDDR11L_BIT3_MASK          8U
    #define ATDDR11L_BIT4_MASK          16U
    #define ATDDR11L_BIT5_MASK          32U
    #define ATDDR11L_BIT6_MASK          64U
    #define ATDDR11L_BIT7_MASK          128U
    
  } Overlap_STR;

  struct {
    word BIT0        :1;                                       /* ATD Conversion Result Bit 0 */
    word BIT1        :1;                                       /* ATD Conversion Result Bit 1 */
    word BIT2        :1;                                       /* ATD Conversion Result Bit 2 */
    word BIT3        :1;                                       /* ATD Conversion Result Bit 3 */
    word BIT4        :1;                                       /* ATD Conversion Result Bit 4 */
    word BIT5        :1;                                       /* ATD Conversion Result Bit 5 */
    word BIT6        :1;                                       /* ATD Conversion Result Bit 6 */
    word BIT7        :1;                                       /* ATD Conversion Result Bit 7 */
    word BIT8        :1;                                       /* ATD Conversion Result Bit 8 */
    word BIT9        :1;                                       /* ATD Conversion Result Bit 9 */
    word BIT10       :1;                                       /* ATD Conversion Result Bit 10 */
    word BIT11       :1;                                       /* ATD Conversion Result Bit 11 */
    word BIT12       :1;                                       /* ATD Conversion Result Bit 12 */
    word BIT13       :1;                                       /* ATD Conversion Result Bit 13 */
    word BIT14       :1;                                       /* ATD Conversion Result Bit 14 */
    word BIT15       :1;                                       /* ATD Conversion Result Bit 15 */
  } Bits;
} ATDDR11STR;
extern volatile ATDDR11STR _ATDDR11 @(REG_BASE + 0x000000A6UL);
#define ATDDR11                         _ATDDR11.Word
#define ATDDR11_BIT0                    _ATDDR11.Bits.BIT0
#define ATDDR11_BIT1                    _ATDDR11.Bits.BIT1
#define ATDDR11_BIT2                    _ATDDR11.Bits.BIT2
#define ATDDR11_BIT3                    _ATDDR11.Bits.BIT3
#define ATDDR11_BIT4                    _ATDDR11.Bits.BIT4
#define ATDDR11_BIT5                    _ATDDR11.Bits.BIT5
#define ATDDR11_BIT6                    _ATDDR11.Bits.BIT6
#define ATDDR11_BIT7                    _ATDDR11.Bits.BIT7
#define ATDDR11_BIT8                    _ATDDR11.Bits.BIT8
#define ATDDR11_BIT9                    _ATDDR11.Bits.BIT9
#define ATDDR11_BIT10                   _ATDDR11.Bits.BIT10
#define ATDDR11_BIT11                   _ATDDR11.Bits.BIT11
#define ATDDR11_BIT12                   _ATDDR11.Bits.BIT12
#define ATDDR11_BIT13                   _ATDDR11.Bits.BIT13
#define ATDDR11_BIT14                   _ATDDR11.Bits.BIT14
#define ATDDR11_BIT15                   _ATDDR11.Bits.BIT15

#define ATDDR11_BIT0_MASK               1U
#define ATDDR11_BIT1_MASK               2U
#define ATDDR11_BIT2_MASK               4U
#define ATDDR11_BIT3_MASK               8U
#define ATDDR11_BIT4_MASK               16U
#define ATDDR11_BIT5_MASK               32U
#define ATDDR11_BIT6_MASK               64U
#define ATDDR11_BIT7_MASK               128U
#define ATDDR11_BIT8_MASK               256U
#define ATDDR11_BIT9_MASK               512U
#define ATDDR11_BIT10_MASK              1024U
#define ATDDR11_BIT11_MASK              2048U
#define ATDDR11_BIT12_MASK              4096U
#define ATDDR11_BIT13_MASK              8192U
#define ATDDR11_BIT14_MASK              16384U
#define ATDDR11_BIT15_MASK              32768U


/*** ATDDR12 - ATD Conversion Result Register 12; 0x000000A8 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATDDR12H - ATD Conversion Result Register 12 High; 0x000000A8 ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* ATD Conversion Result Bit 8 */
        byte BIT9        :1;                                       /* ATD Conversion Result Bit 9 */
        byte BIT10       :1;                                       /* ATD Conversion Result Bit 10 */
        byte BIT11       :1;                                       /* ATD Conversion Result Bit 11 */
        byte BIT12       :1;                                       /* ATD Conversion Result Bit 12 */
        byte BIT13       :1;                                       /* ATD Conversion Result Bit 13 */
        byte BIT14       :1;                                       /* ATD Conversion Result Bit 14 */
        byte BIT15       :1;                                       /* ATD Conversion Result Bit 15 */
      } Bits;
    } ATDDR12HSTR;
    #define ATDDR12H                    _ATDDR12.Overlap_STR.ATDDR12HSTR.Byte
    #define ATDDR12H_BIT8               _ATDDR12.Overlap_STR.ATDDR12HSTR.Bits.BIT8
    #define ATDDR12H_BIT9               _ATDDR12.Overlap_STR.ATDDR12HSTR.Bits.BIT9
    #define ATDDR12H_BIT10              _ATDDR12.Overlap_STR.ATDDR12HSTR.Bits.BIT10
    #define ATDDR12H_BIT11              _ATDDR12.Overlap_STR.ATDDR12HSTR.Bits.BIT11
    #define ATDDR12H_BIT12              _ATDDR12.Overlap_STR.ATDDR12HSTR.Bits.BIT12
    #define ATDDR12H_BIT13              _ATDDR12.Overlap_STR.ATDDR12HSTR.Bits.BIT13
    #define ATDDR12H_BIT14              _ATDDR12.Overlap_STR.ATDDR12HSTR.Bits.BIT14
    #define ATDDR12H_BIT15              _ATDDR12.Overlap_STR.ATDDR12HSTR.Bits.BIT15
    
    #define ATDDR12H_BIT8_MASK          1U
    #define ATDDR12H_BIT9_MASK          2U
    #define ATDDR12H_BIT10_MASK         4U
    #define ATDDR12H_BIT11_MASK         8U
    #define ATDDR12H_BIT12_MASK         16U
    #define ATDDR12H_BIT13_MASK         32U
    #define ATDDR12H_BIT14_MASK         64U
    #define ATDDR12H_BIT15_MASK         128U
    

    /*** ATDDR12L - ATD Conversion Result Register 12 Low; 0x000000A9 ***/
    union {
      byte Byte;
      struct {
        byte BIT0        :1;                                       /* ATD Conversion Result Bit 0 */
        byte BIT1        :1;                                       /* ATD Conversion Result Bit 1 */
        byte BIT2        :1;                                       /* ATD Conversion Result Bit 2 */
        byte BIT3        :1;                                       /* ATD Conversion Result Bit 3 */
        byte BIT4        :1;                                       /* ATD Conversion Result Bit 4 */
        byte BIT5        :1;                                       /* ATD Conversion Result Bit 5 */
        byte BIT6        :1;                                       /* ATD Conversion Result Bit 6 */
        byte BIT7        :1;                                       /* ATD Conversion Result Bit 7 */
      } Bits;
    } ATDDR12LSTR;
    #define ATDDR12L                    _ATDDR12.Overlap_STR.ATDDR12LSTR.Byte
    #define ATDDR12L_BIT0               _ATDDR12.Overlap_STR.ATDDR12LSTR.Bits.BIT0
    #define ATDDR12L_BIT1               _ATDDR12.Overlap_STR.ATDDR12LSTR.Bits.BIT1
    #define ATDDR12L_BIT2               _ATDDR12.Overlap_STR.ATDDR12LSTR.Bits.BIT2
    #define ATDDR12L_BIT3               _ATDDR12.Overlap_STR.ATDDR12LSTR.Bits.BIT3
    #define ATDDR12L_BIT4               _ATDDR12.Overlap_STR.ATDDR12LSTR.Bits.BIT4
    #define ATDDR12L_BIT5               _ATDDR12.Overlap_STR.ATDDR12LSTR.Bits.BIT5
    #define ATDDR12L_BIT6               _ATDDR12.Overlap_STR.ATDDR12LSTR.Bits.BIT6
    #define ATDDR12L_BIT7               _ATDDR12.Overlap_STR.ATDDR12LSTR.Bits.BIT7
    
    #define ATDDR12L_BIT0_MASK          1U
    #define ATDDR12L_BIT1_MASK          2U
    #define ATDDR12L_BIT2_MASK          4U
    #define ATDDR12L_BIT3_MASK          8U
    #define ATDDR12L_BIT4_MASK          16U
    #define ATDDR12L_BIT5_MASK          32U
    #define ATDDR12L_BIT6_MASK          64U
    #define ATDDR12L_BIT7_MASK          128U
    
  } Overlap_STR;

  struct {
    word BIT0        :1;                                       /* ATD Conversion Result Bit 0 */
    word BIT1        :1;                                       /* ATD Conversion Result Bit 1 */
    word BIT2        :1;                                       /* ATD Conversion Result Bit 2 */
    word BIT3        :1;                                       /* ATD Conversion Result Bit 3 */
    word BIT4        :1;                                       /* ATD Conversion Result Bit 4 */
    word BIT5        :1;                                       /* ATD Conversion Result Bit 5 */
    word BIT6        :1;                                       /* ATD Conversion Result Bit 6 */
    word BIT7        :1;                                       /* ATD Conversion Result Bit 7 */
    word BIT8        :1;                                       /* ATD Conversion Result Bit 8 */
    word BIT9        :1;                                       /* ATD Conversion Result Bit 9 */
    word BIT10       :1;                                       /* ATD Conversion Result Bit 10 */
    word BIT11       :1;                                       /* ATD Conversion Result Bit 11 */
    word BIT12       :1;                                       /* ATD Conversion Result Bit 12 */
    word BIT13       :1;                                       /* ATD Conversion Result Bit 13 */
    word BIT14       :1;                                       /* ATD Conversion Result Bit 14 */
    word BIT15       :1;                                       /* ATD Conversion Result Bit 15 */
  } Bits;
} ATDDR12STR;
extern volatile ATDDR12STR _ATDDR12 @(REG_BASE + 0x000000A8UL);
#define ATDDR12                         _ATDDR12.Word
#define ATDDR12_BIT0                    _ATDDR12.Bits.BIT0
#define ATDDR12_BIT1                    _ATDDR12.Bits.BIT1
#define ATDDR12_BIT2                    _ATDDR12.Bits.BIT2
#define ATDDR12_BIT3                    _ATDDR12.Bits.BIT3
#define ATDDR12_BIT4                    _ATDDR12.Bits.BIT4
#define ATDDR12_BIT5                    _ATDDR12.Bits.BIT5
#define ATDDR12_BIT6                    _ATDDR12.Bits.BIT6
#define ATDDR12_BIT7                    _ATDDR12.Bits.BIT7
#define ATDDR12_BIT8                    _ATDDR12.Bits.BIT8
#define ATDDR12_BIT9                    _ATDDR12.Bits.BIT9
#define ATDDR12_BIT10                   _ATDDR12.Bits.BIT10
#define ATDDR12_BIT11                   _ATDDR12.Bits.BIT11
#define ATDDR12_BIT12                   _ATDDR12.Bits.BIT12
#define ATDDR12_BIT13                   _ATDDR12.Bits.BIT13
#define ATDDR12_BIT14                   _ATDDR12.Bits.BIT14
#define ATDDR12_BIT15                   _ATDDR12.Bits.BIT15

#define ATDDR12_BIT0_MASK               1U
#define ATDDR12_BIT1_MASK               2U
#define ATDDR12_BIT2_MASK               4U
#define ATDDR12_BIT3_MASK               8U
#define ATDDR12_BIT4_MASK               16U
#define ATDDR12_BIT5_MASK               32U
#define ATDDR12_BIT6_MASK               64U
#define ATDDR12_BIT7_MASK               128U
#define ATDDR12_BIT8_MASK               256U
#define ATDDR12_BIT9_MASK               512U
#define ATDDR12_BIT10_MASK              1024U
#define ATDDR12_BIT11_MASK              2048U
#define ATDDR12_BIT12_MASK              4096U
#define ATDDR12_BIT13_MASK              8192U
#define ATDDR12_BIT14_MASK              16384U
#define ATDDR12_BIT15_MASK              32768U


/*** ATDDR13 - ATD Conversion Result Register 13; 0x000000AA ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATDDR13H - ATD Conversion Result Register 13 High; 0x000000AA ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* ATD Conversion Result Bit 8 */
        byte BIT9        :1;                                       /* ATD Conversion Result Bit 9 */
        byte BIT10       :1;                                       /* ATD Conversion Result Bit 10 */
        byte BIT11       :1;                                       /* ATD Conversion Result Bit 11 */
        byte BIT12       :1;                                       /* ATD Conversion Result Bit 12 */
        byte BIT13       :1;                                       /* ATD Conversion Result Bit 13 */
        byte BIT14       :1;                                       /* ATD Conversion Result Bit 14 */
        byte BIT15       :1;                                       /* ATD Conversion Result Bit 15 */
      } Bits;
    } ATDDR13HSTR;
    #define ATDDR13H                    _ATDDR13.Overlap_STR.ATDDR13HSTR.Byte
    #define ATDDR13H_BIT8               _ATDDR13.Overlap_STR.ATDDR13HSTR.Bits.BIT8
    #define ATDDR13H_BIT9               _ATDDR13.Overlap_STR.ATDDR13HSTR.Bits.BIT9
    #define ATDDR13H_BIT10              _ATDDR13.Overlap_STR.ATDDR13HSTR.Bits.BIT10
    #define ATDDR13H_BIT11              _ATDDR13.Overlap_STR.ATDDR13HSTR.Bits.BIT11
    #define ATDDR13H_BIT12              _ATDDR13.Overlap_STR.ATDDR13HSTR.Bits.BIT12
    #define ATDDR13H_BIT13              _ATDDR13.Overlap_STR.ATDDR13HSTR.Bits.BIT13
    #define ATDDR13H_BIT14              _ATDDR13.Overlap_STR.ATDDR13HSTR.Bits.BIT14
    #define ATDDR13H_BIT15              _ATDDR13.Overlap_STR.ATDDR13HSTR.Bits.BIT15
    
    #define ATDDR13H_BIT8_MASK          1U
    #define ATDDR13H_BIT9_MASK          2U
    #define ATDDR13H_BIT10_MASK         4U
    #define ATDDR13H_BIT11_MASK         8U
    #define ATDDR13H_BIT12_MASK         16U
    #define ATDDR13H_BIT13_MASK         32U
    #define ATDDR13H_BIT14_MASK         64U
    #define ATDDR13H_BIT15_MASK         128U
    

    /*** ATDDR13L - ATD Conversion Result Register 13 Low; 0x000000AB ***/
    union {
      byte Byte;
      struct {
        byte BIT0        :1;                                       /* ATD Conversion Result Bit 0 */
        byte BIT1        :1;                                       /* ATD Conversion Result Bit 1 */
        byte BIT2        :1;                                       /* ATD Conversion Result Bit 2 */
        byte BIT3        :1;                                       /* ATD Conversion Result Bit 3 */
        byte BIT4        :1;                                       /* ATD Conversion Result Bit 4 */
        byte BIT5        :1;                                       /* ATD Conversion Result Bit 5 */
        byte BIT6        :1;                                       /* ATD Conversion Result Bit 6 */
        byte BIT7        :1;                                       /* ATD Conversion Result Bit 7 */
      } Bits;
    } ATDDR13LSTR;
    #define ATDDR13L                    _ATDDR13.Overlap_STR.ATDDR13LSTR.Byte
    #define ATDDR13L_BIT0               _ATDDR13.Overlap_STR.ATDDR13LSTR.Bits.BIT0
    #define ATDDR13L_BIT1               _ATDDR13.Overlap_STR.ATDDR13LSTR.Bits.BIT1
    #define ATDDR13L_BIT2               _ATDDR13.Overlap_STR.ATDDR13LSTR.Bits.BIT2
    #define ATDDR13L_BIT3               _ATDDR13.Overlap_STR.ATDDR13LSTR.Bits.BIT3
    #define ATDDR13L_BIT4               _ATDDR13.Overlap_STR.ATDDR13LSTR.Bits.BIT4
    #define ATDDR13L_BIT5               _ATDDR13.Overlap_STR.ATDDR13LSTR.Bits.BIT5
    #define ATDDR13L_BIT6               _ATDDR13.Overlap_STR.ATDDR13LSTR.Bits.BIT6
    #define ATDDR13L_BIT7               _ATDDR13.Overlap_STR.ATDDR13LSTR.Bits.BIT7
    
    #define ATDDR13L_BIT0_MASK          1U
    #define ATDDR13L_BIT1_MASK          2U
    #define ATDDR13L_BIT2_MASK          4U
    #define ATDDR13L_BIT3_MASK          8U
    #define ATDDR13L_BIT4_MASK          16U
    #define ATDDR13L_BIT5_MASK          32U
    #define ATDDR13L_BIT6_MASK          64U
    #define ATDDR13L_BIT7_MASK          128U
    
  } Overlap_STR;

  struct {
    word BIT0        :1;                                       /* ATD Conversion Result Bit 0 */
    word BIT1        :1;                                       /* ATD Conversion Result Bit 1 */
    word BIT2        :1;                                       /* ATD Conversion Result Bit 2 */
    word BIT3        :1;                                       /* ATD Conversion Result Bit 3 */
    word BIT4        :1;                                       /* ATD Conversion Result Bit 4 */
    word BIT5        :1;                                       /* ATD Conversion Result Bit 5 */
    word BIT6        :1;                                       /* ATD Conversion Result Bit 6 */
    word BIT7        :1;                                       /* ATD Conversion Result Bit 7 */
    word BIT8        :1;                                       /* ATD Conversion Result Bit 8 */
    word BIT9        :1;                                       /* ATD Conversion Result Bit 9 */
    word BIT10       :1;                                       /* ATD Conversion Result Bit 10 */
    word BIT11       :1;                                       /* ATD Conversion Result Bit 11 */
    word BIT12       :1;                                       /* ATD Conversion Result Bit 12 */
    word BIT13       :1;                                       /* ATD Conversion Result Bit 13 */
    word BIT14       :1;                                       /* ATD Conversion Result Bit 14 */
    word BIT15       :1;                                       /* ATD Conversion Result Bit 15 */
  } Bits;
} ATDDR13STR;
extern volatile ATDDR13STR _ATDDR13 @(REG_BASE + 0x000000AAUL);
#define ATDDR13                         _ATDDR13.Word
#define ATDDR13_BIT0                    _ATDDR13.Bits.BIT0
#define ATDDR13_BIT1                    _ATDDR13.Bits.BIT1
#define ATDDR13_BIT2                    _ATDDR13.Bits.BIT2
#define ATDDR13_BIT3                    _ATDDR13.Bits.BIT3
#define ATDDR13_BIT4                    _ATDDR13.Bits.BIT4
#define ATDDR13_BIT5                    _ATDDR13.Bits.BIT5
#define ATDDR13_BIT6                    _ATDDR13.Bits.BIT6
#define ATDDR13_BIT7                    _ATDDR13.Bits.BIT7
#define ATDDR13_BIT8                    _ATDDR13.Bits.BIT8
#define ATDDR13_BIT9                    _ATDDR13.Bits.BIT9
#define ATDDR13_BIT10                   _ATDDR13.Bits.BIT10
#define ATDDR13_BIT11                   _ATDDR13.Bits.BIT11
#define ATDDR13_BIT12                   _ATDDR13.Bits.BIT12
#define ATDDR13_BIT13                   _ATDDR13.Bits.BIT13
#define ATDDR13_BIT14                   _ATDDR13.Bits.BIT14
#define ATDDR13_BIT15                   _ATDDR13.Bits.BIT15

#define ATDDR13_BIT0_MASK               1U
#define ATDDR13_BIT1_MASK               2U
#define ATDDR13_BIT2_MASK               4U
#define ATDDR13_BIT3_MASK               8U
#define ATDDR13_BIT4_MASK               16U
#define ATDDR13_BIT5_MASK               32U
#define ATDDR13_BIT6_MASK               64U
#define ATDDR13_BIT7_MASK               128U
#define ATDDR13_BIT8_MASK               256U
#define ATDDR13_BIT9_MASK               512U
#define ATDDR13_BIT10_MASK              1024U
#define ATDDR13_BIT11_MASK              2048U
#define ATDDR13_BIT12_MASK              4096U
#define ATDDR13_BIT13_MASK              8192U
#define ATDDR13_BIT14_MASK              16384U
#define ATDDR13_BIT15_MASK              32768U


/*** ATDDR14 - ATD Conversion Result Register 14; 0x000000AC ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATDDR14H - ATD Conversion Result Register 14 High; 0x000000AC ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* ATD Conversion Result Bit 8 */
        byte BIT9        :1;                                       /* ATD Conversion Result Bit 9 */
        byte BIT10       :1;                                       /* ATD Conversion Result Bit 10 */
        byte BIT11       :1;                                       /* ATD Conversion Result Bit 11 */
        byte BIT12       :1;                                       /* ATD Conversion Result Bit 12 */
        byte BIT13       :1;                                       /* ATD Conversion Result Bit 13 */
        byte BIT14       :1;                                       /* ATD Conversion Result Bit 14 */
        byte BIT15       :1;                                       /* ATD Conversion Result Bit 15 */
      } Bits;
    } ATDDR14HSTR;
    #define ATDDR14H                    _ATDDR14.Overlap_STR.ATDDR14HSTR.Byte
    #define ATDDR14H_BIT8               _ATDDR14.Overlap_STR.ATDDR14HSTR.Bits.BIT8
    #define ATDDR14H_BIT9               _ATDDR14.Overlap_STR.ATDDR14HSTR.Bits.BIT9
    #define ATDDR14H_BIT10              _ATDDR14.Overlap_STR.ATDDR14HSTR.Bits.BIT10
    #define ATDDR14H_BIT11              _ATDDR14.Overlap_STR.ATDDR14HSTR.Bits.BIT11
    #define ATDDR14H_BIT12              _ATDDR14.Overlap_STR.ATDDR14HSTR.Bits.BIT12
    #define ATDDR14H_BIT13              _ATDDR14.Overlap_STR.ATDDR14HSTR.Bits.BIT13
    #define ATDDR14H_BIT14              _ATDDR14.Overlap_STR.ATDDR14HSTR.Bits.BIT14
    #define ATDDR14H_BIT15              _ATDDR14.Overlap_STR.ATDDR14HSTR.Bits.BIT15
    
    #define ATDDR14H_BIT8_MASK          1U
    #define ATDDR14H_BIT9_MASK          2U
    #define ATDDR14H_BIT10_MASK         4U
    #define ATDDR14H_BIT11_MASK         8U
    #define ATDDR14H_BIT12_MASK         16U
    #define ATDDR14H_BIT13_MASK         32U
    #define ATDDR14H_BIT14_MASK         64U
    #define ATDDR14H_BIT15_MASK         128U
    

    /*** ATDDR14L - ATD Conversion Result Register 14 Low; 0x000000AD ***/
    union {
      byte Byte;
      struct {
        byte BIT0        :1;                                       /* ATD Conversion Result Bit 0 */
        byte BIT1        :1;                                       /* ATD Conversion Result Bit 1 */
        byte BIT2        :1;                                       /* ATD Conversion Result Bit 2 */
        byte BIT3        :1;                                       /* ATD Conversion Result Bit 3 */
        byte BIT4        :1;                                       /* ATD Conversion Result Bit 4 */
        byte BIT5        :1;                                       /* ATD Conversion Result Bit 5 */
        byte BIT6        :1;                                       /* ATD Conversion Result Bit 6 */
        byte BIT7        :1;                                       /* ATD Conversion Result Bit 7 */
      } Bits;
    } ATDDR14LSTR;
    #define ATDDR14L                    _ATDDR14.Overlap_STR.ATDDR14LSTR.Byte
    #define ATDDR14L_BIT0               _ATDDR14.Overlap_STR.ATDDR14LSTR.Bits.BIT0
    #define ATDDR14L_BIT1               _ATDDR14.Overlap_STR.ATDDR14LSTR.Bits.BIT1
    #define ATDDR14L_BIT2               _ATDDR14.Overlap_STR.ATDDR14LSTR.Bits.BIT2
    #define ATDDR14L_BIT3               _ATDDR14.Overlap_STR.ATDDR14LSTR.Bits.BIT3
    #define ATDDR14L_BIT4               _ATDDR14.Overlap_STR.ATDDR14LSTR.Bits.BIT4
    #define ATDDR14L_BIT5               _ATDDR14.Overlap_STR.ATDDR14LSTR.Bits.BIT5
    #define ATDDR14L_BIT6               _ATDDR14.Overlap_STR.ATDDR14LSTR.Bits.BIT6
    #define ATDDR14L_BIT7               _ATDDR14.Overlap_STR.ATDDR14LSTR.Bits.BIT7
    
    #define ATDDR14L_BIT0_MASK          1U
    #define ATDDR14L_BIT1_MASK          2U
    #define ATDDR14L_BIT2_MASK          4U
    #define ATDDR14L_BIT3_MASK          8U
    #define ATDDR14L_BIT4_MASK          16U
    #define ATDDR14L_BIT5_MASK          32U
    #define ATDDR14L_BIT6_MASK          64U
    #define ATDDR14L_BIT7_MASK          128U
    
  } Overlap_STR;

  struct {
    word BIT0        :1;                                       /* ATD Conversion Result Bit 0 */
    word BIT1        :1;                                       /* ATD Conversion Result Bit 1 */
    word BIT2        :1;                                       /* ATD Conversion Result Bit 2 */
    word BIT3        :1;                                       /* ATD Conversion Result Bit 3 */
    word BIT4        :1;                                       /* ATD Conversion Result Bit 4 */
    word BIT5        :1;                                       /* ATD Conversion Result Bit 5 */
    word BIT6        :1;                                       /* ATD Conversion Result Bit 6 */
    word BIT7        :1;                                       /* ATD Conversion Result Bit 7 */
    word BIT8        :1;                                       /* ATD Conversion Result Bit 8 */
    word BIT9        :1;                                       /* ATD Conversion Result Bit 9 */
    word BIT10       :1;                                       /* ATD Conversion Result Bit 10 */
    word BIT11       :1;                                       /* ATD Conversion Result Bit 11 */
    word BIT12       :1;                                       /* ATD Conversion Result Bit 12 */
    word BIT13       :1;                                       /* ATD Conversion Result Bit 13 */
    word BIT14       :1;                                       /* ATD Conversion Result Bit 14 */
    word BIT15       :1;                                       /* ATD Conversion Result Bit 15 */
  } Bits;
} ATDDR14STR;
extern volatile ATDDR14STR _ATDDR14 @(REG_BASE + 0x000000ACUL);
#define ATDDR14                         _ATDDR14.Word
#define ATDDR14_BIT0                    _ATDDR14.Bits.BIT0
#define ATDDR14_BIT1                    _ATDDR14.Bits.BIT1
#define ATDDR14_BIT2                    _ATDDR14.Bits.BIT2
#define ATDDR14_BIT3                    _ATDDR14.Bits.BIT3
#define ATDDR14_BIT4                    _ATDDR14.Bits.BIT4
#define ATDDR14_BIT5                    _ATDDR14.Bits.BIT5
#define ATDDR14_BIT6                    _ATDDR14.Bits.BIT6
#define ATDDR14_BIT7                    _ATDDR14.Bits.BIT7
#define ATDDR14_BIT8                    _ATDDR14.Bits.BIT8
#define ATDDR14_BIT9                    _ATDDR14.Bits.BIT9
#define ATDDR14_BIT10                   _ATDDR14.Bits.BIT10
#define ATDDR14_BIT11                   _ATDDR14.Bits.BIT11
#define ATDDR14_BIT12                   _ATDDR14.Bits.BIT12
#define ATDDR14_BIT13                   _ATDDR14.Bits.BIT13
#define ATDDR14_BIT14                   _ATDDR14.Bits.BIT14
#define ATDDR14_BIT15                   _ATDDR14.Bits.BIT15

#define ATDDR14_BIT0_MASK               1U
#define ATDDR14_BIT1_MASK               2U
#define ATDDR14_BIT2_MASK               4U
#define ATDDR14_BIT3_MASK               8U
#define ATDDR14_BIT4_MASK               16U
#define ATDDR14_BIT5_MASK               32U
#define ATDDR14_BIT6_MASK               64U
#define ATDDR14_BIT7_MASK               128U
#define ATDDR14_BIT8_MASK               256U
#define ATDDR14_BIT9_MASK               512U
#define ATDDR14_BIT10_MASK              1024U
#define ATDDR14_BIT11_MASK              2048U
#define ATDDR14_BIT12_MASK              4096U
#define ATDDR14_BIT13_MASK              8192U
#define ATDDR14_BIT14_MASK              16384U
#define ATDDR14_BIT15_MASK              32768U


/*** ATDDR15 - ATD Conversion Result Register 15; 0x000000AE ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATDDR15H - ATD Conversion Result Register 15 High; 0x000000AE ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* ATD Conversion Result Bit 8 */
        byte BIT9        :1;                                       /* ATD Conversion Result Bit 9 */
        byte BIT10       :1;                                       /* ATD Conversion Result Bit 10 */
        byte BIT11       :1;                                       /* ATD Conversion Result Bit 11 */
        byte BIT12       :1;                                       /* ATD Conversion Result Bit 12 */
        byte BIT13       :1;                                       /* ATD Conversion Result Bit 13 */
        byte BIT14       :1;                                       /* ATD Conversion Result Bit 14 */
        byte BIT15       :1;                                       /* ATD Conversion Result Bit 15 */
      } Bits;
    } ATDDR15HSTR;
    #define ATDDR15H                    _ATDDR15.Overlap_STR.ATDDR15HSTR.Byte
    #define ATDDR15H_BIT8               _ATDDR15.Overlap_STR.ATDDR15HSTR.Bits.BIT8
    #define ATDDR15H_BIT9               _ATDDR15.Overlap_STR.ATDDR15HSTR.Bits.BIT9
    #define ATDDR15H_BIT10              _ATDDR15.Overlap_STR.ATDDR15HSTR.Bits.BIT10
    #define ATDDR15H_BIT11              _ATDDR15.Overlap_STR.ATDDR15HSTR.Bits.BIT11
    #define ATDDR15H_BIT12              _ATDDR15.Overlap_STR.ATDDR15HSTR.Bits.BIT12
    #define ATDDR15H_BIT13              _ATDDR15.Overlap_STR.ATDDR15HSTR.Bits.BIT13
    #define ATDDR15H_BIT14              _ATDDR15.Overlap_STR.ATDDR15HSTR.Bits.BIT14
    #define ATDDR15H_BIT15              _ATDDR15.Overlap_STR.ATDDR15HSTR.Bits.BIT15
    
    #define ATDDR15H_BIT8_MASK          1U
    #define ATDDR15H_BIT9_MASK          2U
    #define ATDDR15H_BIT10_MASK         4U
    #define ATDDR15H_BIT11_MASK         8U
    #define ATDDR15H_BIT12_MASK         16U
    #define ATDDR15H_BIT13_MASK         32U
    #define ATDDR15H_BIT14_MASK         64U
    #define ATDDR15H_BIT15_MASK         128U
    

    /*** ATDDR15L - ATD Conversion Result Register 15 Low; 0x000000AF ***/
    union {
      byte Byte;
      struct {
        byte BIT0        :1;                                       /* ATD Conversion Result Bit 0 */
        byte BIT1        :1;                                       /* ATD Conversion Result Bit 1 */
        byte BIT2        :1;                                       /* ATD Conversion Result Bit 2 */
        byte BIT3        :1;                                       /* ATD Conversion Result Bit 3 */
        byte BIT4        :1;                                       /* ATD Conversion Result Bit 4 */
        byte BIT5        :1;                                       /* ATD Conversion Result Bit 5 */
        byte BIT6        :1;                                       /* ATD Conversion Result Bit 6 */
        byte BIT7        :1;                                       /* ATD Conversion Result Bit 7 */
      } Bits;
    } ATDDR15LSTR;
    #define ATDDR15L                    _ATDDR15.Overlap_STR.ATDDR15LSTR.Byte
    #define ATDDR15L_BIT0               _ATDDR15.Overlap_STR.ATDDR15LSTR.Bits.BIT0
    #define ATDDR15L_BIT1               _ATDDR15.Overlap_STR.ATDDR15LSTR.Bits.BIT1
    #define ATDDR15L_BIT2               _ATDDR15.Overlap_STR.ATDDR15LSTR.Bits.BIT2
    #define ATDDR15L_BIT3               _ATDDR15.Overlap_STR.ATDDR15LSTR.Bits.BIT3
    #define ATDDR15L_BIT4               _ATDDR15.Overlap_STR.ATDDR15LSTR.Bits.BIT4
    #define ATDDR15L_BIT5               _ATDDR15.Overlap_STR.ATDDR15LSTR.Bits.BIT5
    #define ATDDR15L_BIT6               _ATDDR15.Overlap_STR.ATDDR15LSTR.Bits.BIT6
    #define ATDDR15L_BIT7               _ATDDR15.Overlap_STR.ATDDR15LSTR.Bits.BIT7
    
    #define ATDDR15L_BIT0_MASK          1U
    #define ATDDR15L_BIT1_MASK          2U
    #define ATDDR15L_BIT2_MASK          4U
    #define ATDDR15L_BIT3_MASK          8U
    #define ATDDR15L_BIT4_MASK          16U
    #define ATDDR15L_BIT5_MASK          32U
    #define ATDDR15L_BIT6_MASK          64U
    #define ATDDR15L_BIT7_MASK          128U
    
  } Overlap_STR;

  struct {
    word BIT0        :1;                                       /* ATD Conversion Result Bit 0 */
    word BIT1        :1;                                       /* ATD Conversion Result Bit 1 */
    word BIT2        :1;                                       /* ATD Conversion Result Bit 2 */
    word BIT3        :1;                                       /* ATD Conversion Result Bit 3 */
    word BIT4        :1;                                       /* ATD Conversion Result Bit 4 */
    word BIT5        :1;                                       /* ATD Conversion Result Bit 5 */
    word BIT6        :1;                                       /* ATD Conversion Result Bit 6 */
    word BIT7        :1;                                       /* ATD Conversion Result Bit 7 */
    word BIT8        :1;                                       /* ATD Conversion Result Bit 8 */
    word BIT9        :1;                                       /* ATD Conversion Result Bit 9 */
    word BIT10       :1;                                       /* ATD Conversion Result Bit 10 */
    word BIT11       :1;                                       /* ATD Conversion Result Bit 11 */
    word BIT12       :1;                                       /* ATD Conversion Result Bit 12 */
    word BIT13       :1;                                       /* ATD Conversion Result Bit 13 */
    word BIT14       :1;                                       /* ATD Conversion Result Bit 14 */
    word BIT15       :1;                                       /* ATD Conversion Result Bit 15 */
  } Bits;
} ATDDR15STR;
extern volatile ATDDR15STR _ATDDR15 @(REG_BASE + 0x000000AEUL);
#define ATDDR15                         _ATDDR15.Word
#define ATDDR15_BIT0                    _ATDDR15.Bits.BIT0
#define ATDDR15_BIT1                    _ATDDR15.Bits.BIT1
#define ATDDR15_BIT2                    _ATDDR15.Bits.BIT2
#define ATDDR15_BIT3                    _ATDDR15.Bits.BIT3
#define ATDDR15_BIT4                    _ATDDR15.Bits.BIT4
#define ATDDR15_BIT5                    _ATDDR15.Bits.BIT5
#define ATDDR15_BIT6                    _ATDDR15.Bits.BIT6
#define ATDDR15_BIT7                    _ATDDR15.Bits.BIT7
#define ATDDR15_BIT8                    _ATDDR15.Bits.BIT8
#define ATDDR15_BIT9                    _ATDDR15.Bits.BIT9
#define ATDDR15_BIT10                   _ATDDR15.Bits.BIT10
#define ATDDR15_BIT11                   _ATDDR15.Bits.BIT11
#define ATDDR15_BIT12                   _ATDDR15.Bits.BIT12
#define ATDDR15_BIT13                   _ATDDR15.Bits.BIT13
#define ATDDR15_BIT14                   _ATDDR15.Bits.BIT14
#define ATDDR15_BIT15                   _ATDDR15.Bits.BIT15

#define ATDDR15_BIT0_MASK               1U
#define ATDDR15_BIT1_MASK               2U
#define ATDDR15_BIT2_MASK               4U
#define ATDDR15_BIT3_MASK               8U
#define ATDDR15_BIT4_MASK               16U
#define ATDDR15_BIT5_MASK               32U
#define ATDDR15_BIT6_MASK               64U
#define ATDDR15_BIT7_MASK               128U
#define ATDDR15_BIT8_MASK               256U
#define ATDDR15_BIT9_MASK               512U
#define ATDDR15_BIT10_MASK              1024U
#define ATDDR15_BIT11_MASK              2048U
#define ATDDR15_BIT12_MASK              4096U
#define ATDDR15_BIT13_MASK              8192U
#define ATDDR15_BIT14_MASK              16384U
#define ATDDR15_BIT15_MASK              32768U


/*** SCI0BD - SCI 0 Baud Rate Register; 0x000000C8 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** SCI0BDH - SCI 0 Baud Rate Register High; 0x000000C8 ***/
    union {
      byte Byte;
      struct {
        byte SBR8        :1;                                       /* SCI Baud Rate Bit 8 */
        byte SBR9        :1;                                       /* SCI Baud Rate Bit 9 */
        byte SBR10       :1;                                       /* SCI Baud Rate Bit 10 */
        byte SBR11       :1;                                       /* SCI Baud Rate Bit 11 */
        byte SBR12       :1;                                       /* SCI Baud Rate Bit 12 */
        byte TNP0        :1;                                       /* Transmitter Narrow Pulse Bit 0 */
        byte TNP1        :1;                                       /* Transmitter Narrow Pulse Bit 1 */
        byte IREN        :1;                                       /* Infrared Enable Bit */
      } Bits;
      struct {
        byte grpSBR_8 :5;
        byte grpTNP :2;
        byte     :1;
      } MergedBits;
    } SCI0BDHSTR;
    #define SCI0BDH                     _SCI0BD.Overlap_STR.SCI0BDHSTR.Byte
    #define SCI0BDH_SBR8                _SCI0BD.Overlap_STR.SCI0BDHSTR.Bits.SBR8
    #define SCI0BDH_SBR9                _SCI0BD.Overlap_STR.SCI0BDHSTR.Bits.SBR9
    #define SCI0BDH_SBR10               _SCI0BD.Overlap_STR.SCI0BDHSTR.Bits.SBR10
    #define SCI0BDH_SBR11               _SCI0BD.Overlap_STR.SCI0BDHSTR.Bits.SBR11
    #define SCI0BDH_SBR12               _SCI0BD.Overlap_STR.SCI0BDHSTR.Bits.SBR12
    #define SCI0BDH_TNP0                _SCI0BD.Overlap_STR.SCI0BDHSTR.Bits.TNP0
    #define SCI0BDH_TNP1                _SCI0BD.Overlap_STR.SCI0BDHSTR.Bits.TNP1
    #define SCI0BDH_IREN                _SCI0BD.Overlap_STR.SCI0BDHSTR.Bits.IREN
    #define SCI0BDH_SBR_8               _SCI0BD.Overlap_STR.SCI0BDHSTR.MergedBits.grpSBR_8
    #define SCI0BDH_TNP                 _SCI0BD.Overlap_STR.SCI0BDHSTR.MergedBits.grpTNP
    #define SCI0BDH_SBR                 SCI0BDH_SBR_8
    
    #define SCI0BDH_SBR8_MASK           1U
    #define SCI0BDH_SBR9_MASK           2U
    #define SCI0BDH_SBR10_MASK          4U
    #define SCI0BDH_SBR11_MASK          8U
    #define SCI0BDH_SBR12_MASK          16U
    #define SCI0BDH_TNP0_MASK           32U
    #define SCI0BDH_TNP1_MASK           64U
    #define SCI0BDH_IREN_MASK           128U
    #define SCI0BDH_SBR_8_MASK          31U
    #define SCI0BDH_SBR_8_BITNUM        0U
    #define SCI0BDH_TNP_MASK            96U
    #define SCI0BDH_TNP_BITNUM          5U
    

    /*** SCI0BDL - SCI 0 Baud Rate Register Low; 0x000000C9 ***/
    union {
      byte Byte;
      struct {
        byte SBR0        :1;                                       /* SCI Baud Rate Bit 0 */
        byte SBR1        :1;                                       /* SCI Baud Rate Bit 1 */
        byte SBR2        :1;                                       /* SCI Baud Rate Bit 2 */
        byte SBR3        :1;                                       /* SCI Baud Rate Bit 3 */
        byte SBR4        :1;                                       /* SCI Baud Rate Bit 4 */
        byte SBR5        :1;                                       /* SCI Baud Rate Bit 5 */
        byte SBR6        :1;                                       /* SCI Baud Rate Bit 6 */
        byte SBR7        :1;                                       /* SCI Baud Rate Bit 7 */
      } Bits;
    } SCI0BDLSTR;
    #define SCI0BDL                     _SCI0BD.Overlap_STR.SCI0BDLSTR.Byte
    #define SCI0BDL_SBR0                _SCI0BD.Overlap_STR.SCI0BDLSTR.Bits.SBR0
    #define SCI0BDL_SBR1                _SCI0BD.Overlap_STR.SCI0BDLSTR.Bits.SBR1
    #define SCI0BDL_SBR2                _SCI0BD.Overlap_STR.SCI0BDLSTR.Bits.SBR2
    #define SCI0BDL_SBR3                _SCI0BD.Overlap_STR.SCI0BDLSTR.Bits.SBR3
    #define SCI0BDL_SBR4                _SCI0BD.Overlap_STR.SCI0BDLSTR.Bits.SBR4
    #define SCI0BDL_SBR5                _SCI0BD.Overlap_STR.SCI0BDLSTR.Bits.SBR5
    #define SCI0BDL_SBR6                _SCI0BD.Overlap_STR.SCI0BDLSTR.Bits.SBR6
    #define SCI0BDL_SBR7                _SCI0BD.Overlap_STR.SCI0BDLSTR.Bits.SBR7
    
    #define SCI0BDL_SBR0_MASK           1U
    #define SCI0BDL_SBR1_MASK           2U
    #define SCI0BDL_SBR2_MASK           4U
    #define SCI0BDL_SBR3_MASK           8U
    #define SCI0BDL_SBR4_MASK           16U
    #define SCI0BDL_SBR5_MASK           32U
    #define SCI0BDL_SBR6_MASK           64U
    #define SCI0BDL_SBR7_MASK           128U
    
  } Overlap_STR;

  struct {
    word SBR0        :1;                                       /* SCI Baud Rate Bit 0 */
    word SBR1        :1;                                       /* SCI Baud Rate Bit 1 */
    word SBR2        :1;                                       /* SCI Baud Rate Bit 2 */
    word SBR3        :1;                                       /* SCI Baud Rate Bit 3 */
    word SBR4        :1;                                       /* SCI Baud Rate Bit 4 */
    word SBR5        :1;                                       /* SCI Baud Rate Bit 5 */
    word SBR6        :1;                                       /* SCI Baud Rate Bit 6 */
    word SBR7        :1;                                       /* SCI Baud Rate Bit 7 */
    word SBR8        :1;                                       /* SCI Baud Rate Bit 8 */
    word SBR9        :1;                                       /* SCI Baud Rate Bit 9 */
    word SBR10       :1;                                       /* SCI Baud Rate Bit 10 */
    word SBR11       :1;                                       /* SCI Baud Rate Bit 11 */
    word SBR12       :1;                                       /* SCI Baud Rate Bit 12 */
    word TNP0        :1;                                       /* Transmitter Narrow Pulse Bit 0 */
    word TNP1        :1;                                       /* Transmitter Narrow Pulse Bit 1 */
    word IREN        :1;                                       /* Infrared Enable Bit */
  } Bits;
  struct {
    word grpSBR  :13;
    word grpTNP  :2;
    word         :1;
  } MergedBits;
} SCI0BDSTR;
extern volatile SCI0BDSTR _SCI0BD @(REG_BASE + 0x000000C8UL);
#define SCI0BD                          _SCI0BD.Word
#define SCI0BD_SBR0                     _SCI0BD.Bits.SBR0
#define SCI0BD_SBR1                     _SCI0BD.Bits.SBR1
#define SCI0BD_SBR2                     _SCI0BD.Bits.SBR2
#define SCI0BD_SBR3                     _SCI0BD.Bits.SBR3
#define SCI0BD_SBR4                     _SCI0BD.Bits.SBR4
#define SCI0BD_SBR5                     _SCI0BD.Bits.SBR5
#define SCI0BD_SBR6                     _SCI0BD.Bits.SBR6
#define SCI0BD_SBR7                     _SCI0BD.Bits.SBR7
#define SCI0BD_SBR8                     _SCI0BD.Bits.SBR8
#define SCI0BD_SBR9                     _SCI0BD.Bits.SBR9
#define SCI0BD_SBR10                    _SCI0BD.Bits.SBR10
#define SCI0BD_SBR11                    _SCI0BD.Bits.SBR11
#define SCI0BD_SBR12                    _SCI0BD.Bits.SBR12
#define SCI0BD_TNP0                     _SCI0BD.Bits.TNP0
#define SCI0BD_TNP1                     _SCI0BD.Bits.TNP1
#define SCI0BD_IREN                     _SCI0BD.Bits.IREN
#define SCI0BD_SBR                      _SCI0BD.MergedBits.grpSBR
#define SCI0BD_TNP                      _SCI0BD.MergedBits.grpTNP

#define SCI0BD_SBR0_MASK                1U
#define SCI0BD_SBR1_MASK                2U
#define SCI0BD_SBR2_MASK                4U
#define SCI0BD_SBR3_MASK                8U
#define SCI0BD_SBR4_MASK                16U
#define SCI0BD_SBR5_MASK                32U
#define SCI0BD_SBR6_MASK                64U
#define SCI0BD_SBR7_MASK                128U
#define SCI0BD_SBR8_MASK                256U
#define SCI0BD_SBR9_MASK                512U
#define SCI0BD_SBR10_MASK               1024U
#define SCI0BD_SBR11_MASK               2048U
#define SCI0BD_SBR12_MASK               4096U
#define SCI0BD_TNP0_MASK                8192U
#define SCI0BD_TNP1_MASK                16384U
#define SCI0BD_IREN_MASK                32768U
#define SCI0BD_SBR_MASK                 8191U
#define SCI0BD_SBR_BITNUM               0U
#define SCI0BD_TNP_MASK                 24576U
#define SCI0BD_TNP_BITNUM               13U


/*** SCI0CR1 - SCI 0 Control Register 1; 0x000000CA ***/
typedef union {
  byte Byte;
  struct {
    byte PT          :1;                                       /* Parity Type Bit */
    byte PE          :1;                                       /* Parity Enable Bit */
    byte ILT         :1;                                       /* Idle Line Type Bit */
    byte WAKE        :1;                                       /* Wakeup Condition Bit */
    byte M           :1;                                       /* Data Format Mode Bit */
    byte RSRC        :1;                                       /* Receiver Source Bit */
    byte SCISWAI     :1;                                       /* SCI Stop in Wait Mode Bit */
    byte LOOPS       :1;                                       /* Loop Select Bit */
  } Bits;
} SCI0CR1STR;
extern volatile SCI0CR1STR _SCI0CR1 @(REG_BASE + 0x000000CAUL);
#define SCI0CR1                         _SCI0CR1.Byte
#define SCI0CR1_PT                      _SCI0CR1.Bits.PT
#define SCI0CR1_PE                      _SCI0CR1.Bits.PE
#define SCI0CR1_ILT                     _SCI0CR1.Bits.ILT
#define SCI0CR1_WAKE                    _SCI0CR1.Bits.WAKE
#define SCI0CR1_M                       _SCI0CR1.Bits.M
#define SCI0CR1_RSRC                    _SCI0CR1.Bits.RSRC
#define SCI0CR1_SCISWAI                 _SCI0CR1.Bits.SCISWAI
#define SCI0CR1_LOOPS                   _SCI0CR1.Bits.LOOPS

#define SCI0CR1_PT_MASK                 1U
#define SCI0CR1_PE_MASK                 2U
#define SCI0CR1_ILT_MASK                4U
#define SCI0CR1_WAKE_MASK               8U
#define SCI0CR1_M_MASK                  16U
#define SCI0CR1_RSRC_MASK               32U
#define SCI0CR1_SCISWAI_MASK            64U
#define SCI0CR1_LOOPS_MASK              128U


/*** SCI0CR2 - SCI 0 Control Register 2; 0x000000CB ***/
typedef union {
  byte Byte;
  struct {
    byte SBK         :1;                                       /* Send Break Bit */
    byte RWU         :1;                                       /* Receiver Wakeup Bit */
    byte RE          :1;                                       /* Receiver Enable Bit */
    byte TE          :1;                                       /* Transmitter Enable Bit */
    byte ILIE        :1;                                       /* Idle Line Interrupt Enable Bit */
    byte RIE         :1;                                       /* Receiver Full Interrupt Enable Bit */
    byte TCIE        :1;                                       /* Transmission Complete Interrupt Enable Bit */
    byte SCTIE       :1;                                       /* Transmitter Interrupt Enable Bit */
  } Bits;
} SCI0CR2STR;
extern volatile SCI0CR2STR _SCI0CR2 @(REG_BASE + 0x000000CBUL);
#define SCI0CR2                         _SCI0CR2.Byte
#define SCI0CR2_SBK                     _SCI0CR2.Bits.SBK
#define SCI0CR2_RWU                     _SCI0CR2.Bits.RWU
#define SCI0CR2_RE                      _SCI0CR2.Bits.RE
#define SCI0CR2_TE                      _SCI0CR2.Bits.TE
#define SCI0CR2_ILIE                    _SCI0CR2.Bits.ILIE
#define SCI0CR2_RIE                     _SCI0CR2.Bits.RIE
#define SCI0CR2_TCIE                    _SCI0CR2.Bits.TCIE
#define SCI0CR2_SCTIE                   _SCI0CR2.Bits.SCTIE

#define SCI0CR2_SBK_MASK                1U
#define SCI0CR2_RWU_MASK                2U
#define SCI0CR2_RE_MASK                 4U
#define SCI0CR2_TE_MASK                 8U
#define SCI0CR2_ILIE_MASK               16U
#define SCI0CR2_RIE_MASK                32U
#define SCI0CR2_TCIE_MASK               64U
#define SCI0CR2_SCTIE_MASK              128U


/*** SCI0SR1 - SCI 0 Status Register 1; 0x000000CC ***/
typedef union {
  byte Byte;
  struct {
    byte PF          :1;                                       /* Parity Error Flag */
    byte FE          :1;                                       /* Framing Error Flag */
    byte NF          :1;                                       /* Noise Flag */
    byte OR          :1;                                       /* Overrun Flag */
    byte IDLE        :1;                                       /* Idle Line Flag */
    byte RDRF        :1;                                       /* Receive Data Register Full Flag */
    byte TC          :1;                                       /* Transmit Complete Flag */
    byte TDRE        :1;                                       /* Transmit Data Register Empty Flag */
  } Bits;
} SCI0SR1STR;
extern volatile SCI0SR1STR _SCI0SR1 @(REG_BASE + 0x000000CCUL);
#define SCI0SR1                         _SCI0SR1.Byte
#define SCI0SR1_PF                      _SCI0SR1.Bits.PF
#define SCI0SR1_FE                      _SCI0SR1.Bits.FE
#define SCI0SR1_NF                      _SCI0SR1.Bits.NF
#define SCI0SR1_OR                      _SCI0SR1.Bits.OR
#define SCI0SR1_IDLE                    _SCI0SR1.Bits.IDLE
#define SCI0SR1_RDRF                    _SCI0SR1.Bits.RDRF
#define SCI0SR1_TC                      _SCI0SR1.Bits.TC
#define SCI0SR1_TDRE                    _SCI0SR1.Bits.TDRE

#define SCI0SR1_PF_MASK                 1U
#define SCI0SR1_FE_MASK                 2U
#define SCI0SR1_NF_MASK                 4U
#define SCI0SR1_OR_MASK                 8U
#define SCI0SR1_IDLE_MASK               16U
#define SCI0SR1_RDRF_MASK               32U
#define SCI0SR1_TC_MASK                 64U
#define SCI0SR1_TDRE_MASK               128U


/*** SCI0SR2 - SCI 0 Status Register 2; 0x000000CD ***/
typedef union {
  byte Byte;
  struct {
    byte RAF         :1;                                       /* Receiver Active Flag */
    byte TXDIR       :1;                                       /* Transmitter pin data direction in Single-Wire mode */
    byte BRK13       :1;                                       /* Break Transmit character length */
    byte RXPOL       :1;                                       /* Receive Polarity */
    byte TXPOL       :1;                                       /* Transmit Polarity */
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} SCI0SR2STR;
extern volatile SCI0SR2STR _SCI0SR2 @(REG_BASE + 0x000000CDUL);
#define SCI0SR2                         _SCI0SR2.Byte
#define SCI0SR2_RAF                     _SCI0SR2.Bits.RAF
#define SCI0SR2_TXDIR                   _SCI0SR2.Bits.TXDIR
#define SCI0SR2_BRK13                   _SCI0SR2.Bits.BRK13
#define SCI0SR2_RXPOL                   _SCI0SR2.Bits.RXPOL
#define SCI0SR2_TXPOL                   _SCI0SR2.Bits.TXPOL

#define SCI0SR2_RAF_MASK                1U
#define SCI0SR2_TXDIR_MASK              2U
#define SCI0SR2_BRK13_MASK              4U
#define SCI0SR2_RXPOL_MASK              8U
#define SCI0SR2_TXPOL_MASK              16U


/*** SCI0DRH - SCI 0 Data Register High; 0x000000CE ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte T8          :1;                                       /* Transmit Bit 8 */
    byte R8          :1;                                       /* Received Bit 8 */
  } Bits;
} SCI0DRHSTR;
extern volatile SCI0DRHSTR _SCI0DRH @(REG_BASE + 0x000000CEUL);
#define SCI0DRH                         _SCI0DRH.Byte
#define SCI0DRH_T8                      _SCI0DRH.Bits.T8
#define SCI0DRH_R8                      _SCI0DRH.Bits.R8

#define SCI0DRH_T8_MASK                 64U
#define SCI0DRH_R8_MASK                 128U


/*** SCI0DRL - SCI 0 Data Register Low; 0x000000CF ***/
typedef union {
  byte Byte;
  struct {
    byte R0_T0       :1;                                       /* Received bit 0 or Transmit bit 0 */
    byte R1_T1       :1;                                       /* Received bit 1 or Transmit bit 1 */
    byte R2_T2       :1;                                       /* Received bit 2 or Transmit bit 2 */
    byte R3_T3       :1;                                       /* Received bit 3 or Transmit bit 3 */
    byte R4_T4       :1;                                       /* Received bit 4 or Transmit bit 4 */
    byte R5_T5       :1;                                       /* Received bit 5 or Transmit bit 5 */
    byte R6_T6       :1;                                       /* Received bit 6 or Transmit bit 6 */
    byte R7_T7       :1;                                       /* Received bit 7 or Transmit bit 7 */
  } Bits;
} SCI0DRLSTR;
extern volatile SCI0DRLSTR _SCI0DRL @(REG_BASE + 0x000000CFUL);
#define SCI0DRL                         _SCI0DRL.Byte
#define SCI0DRL_R0_T0                   _SCI0DRL.Bits.R0_T0
#define SCI0DRL_R1_T1                   _SCI0DRL.Bits.R1_T1
#define SCI0DRL_R2_T2                   _SCI0DRL.Bits.R2_T2
#define SCI0DRL_R3_T3                   _SCI0DRL.Bits.R3_T3
#define SCI0DRL_R4_T4                   _SCI0DRL.Bits.R4_T4
#define SCI0DRL_R5_T5                   _SCI0DRL.Bits.R5_T5
#define SCI0DRL_R6_T6                   _SCI0DRL.Bits.R6_T6
#define SCI0DRL_R7_T7                   _SCI0DRL.Bits.R7_T7

#define SCI0DRL_R0_T0_MASK              1U
#define SCI0DRL_R1_T1_MASK              2U
#define SCI0DRL_R2_T2_MASK              4U
#define SCI0DRL_R3_T3_MASK              8U
#define SCI0DRL_R4_T4_MASK              16U
#define SCI0DRL_R5_T5_MASK              32U
#define SCI0DRL_R6_T6_MASK              64U
#define SCI0DRL_R7_T7_MASK              128U


/*** SPICR1 - SPI 0 Control Register; 0x000000D8 ***/
typedef union {
  byte Byte;
  struct {
    byte LSBFE       :1;                                       /* SPI LSB-First Enable */
    byte SSOE        :1;                                       /* Slave Select Output Enable */
    byte CPHA        :1;                                       /* SPI Clock Phase Bit */
    byte CPOL        :1;                                       /* SPI Clock Polarity Bit */
    byte MSTR        :1;                                       /* SPI Master/Slave Mode Select Bit */
    byte SPTIE       :1;                                       /* SPI Transmit Interrupt Enable */
    byte SPE         :1;                                       /* SPI System Enable Bit */
    byte SPIE        :1;                                       /* SPI Interrupt Enable Bit */
  } Bits;
} SPICR1STR;
extern volatile SPICR1STR _SPICR1 @(REG_BASE + 0x000000D8UL);
#define SPICR1                          _SPICR1.Byte
#define SPICR1_LSBFE                    _SPICR1.Bits.LSBFE
#define SPICR1_SSOE                     _SPICR1.Bits.SSOE
#define SPICR1_CPHA                     _SPICR1.Bits.CPHA
#define SPICR1_CPOL                     _SPICR1.Bits.CPOL
#define SPICR1_MSTR                     _SPICR1.Bits.MSTR
#define SPICR1_SPTIE                    _SPICR1.Bits.SPTIE
#define SPICR1_SPE                      _SPICR1.Bits.SPE
#define SPICR1_SPIE                     _SPICR1.Bits.SPIE

#define SPICR1_LSBFE_MASK               1U
#define SPICR1_SSOE_MASK                2U
#define SPICR1_CPHA_MASK                4U
#define SPICR1_CPOL_MASK                8U
#define SPICR1_MSTR_MASK                16U
#define SPICR1_SPTIE_MASK               32U
#define SPICR1_SPE_MASK                 64U
#define SPICR1_SPIE_MASK                128U


/*** SPICR2 - SPI 0 Control Register 2; 0x000000D9 ***/
typedef union {
  byte Byte;
  struct {
    byte SPC0        :1;                                       /* Serial Pin Control Bit 0 */
    byte SPISWAI     :1;                                       /* SPI Stop in Wait Mode Bit */
    byte             :1; 
    byte BIDIROE     :1;                                       /* Output enable in the Bidirectional mode of operation */
    byte MODFEN      :1;                                       /* Mode Fault Enable Bit */
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} SPICR2STR;
extern volatile SPICR2STR _SPICR2 @(REG_BASE + 0x000000D9UL);
#define SPICR2                          _SPICR2.Byte
#define SPICR2_SPC0                     _SPICR2.Bits.SPC0
#define SPICR2_SPISWAI                  _SPICR2.Bits.SPISWAI
#define SPICR2_BIDIROE                  _SPICR2.Bits.BIDIROE
#define SPICR2_MODFEN                   _SPICR2.Bits.MODFEN

#define SPICR2_SPC0_MASK                1U
#define SPICR2_SPISWAI_MASK             2U
#define SPICR2_BIDIROE_MASK             8U
#define SPICR2_MODFEN_MASK              16U


/*** SPIBR - SPI 0 Baud Rate Register; 0x000000DA ***/
typedef union {
  byte Byte;
  struct {
    byte SPR0        :1;                                       /* SPI Baud Rate Selection Bit 0 */
    byte SPR1        :1;                                       /* SPI Baud Rate Selection Bit 1 */
    byte SPR2        :1;                                       /* SPI Baud Rate Selection Bit 2 */
    byte             :1; 
    byte SPPR0       :1;                                       /* SPI Baud Rate Preselection Bits 0 */
    byte SPPR1       :1;                                       /* SPI Baud Rate Preselection Bits 1 */
    byte SPPR2       :1;                                       /* SPI Baud Rate Preselection Bits 2 */
    byte             :1; 
  } Bits;
  struct {
    byte grpSPR  :3;
    byte         :1;
    byte grpSPPR :3;
    byte         :1;
  } MergedBits;
} SPIBRSTR;
extern volatile SPIBRSTR _SPIBR @(REG_BASE + 0x000000DAUL);
#define SPIBR                           _SPIBR.Byte
#define SPIBR_SPR0                      _SPIBR.Bits.SPR0
#define SPIBR_SPR1                      _SPIBR.Bits.SPR1
#define SPIBR_SPR2                      _SPIBR.Bits.SPR2
#define SPIBR_SPPR0                     _SPIBR.Bits.SPPR0
#define SPIBR_SPPR1                     _SPIBR.Bits.SPPR1
#define SPIBR_SPPR2                     _SPIBR.Bits.SPPR2
#define SPIBR_SPR                       _SPIBR.MergedBits.grpSPR
#define SPIBR_SPPR                      _SPIBR.MergedBits.grpSPPR

#define SPIBR_SPR0_MASK                 1U
#define SPIBR_SPR1_MASK                 2U
#define SPIBR_SPR2_MASK                 4U
#define SPIBR_SPPR0_MASK                16U
#define SPIBR_SPPR1_MASK                32U
#define SPIBR_SPPR2_MASK                64U
#define SPIBR_SPR_MASK                  7U
#define SPIBR_SPR_BITNUM                0U
#define SPIBR_SPPR_MASK                 112U
#define SPIBR_SPPR_BITNUM               4U


/*** SPISR - SPI 0 Status Register; 0x000000DB ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte MODF        :1;                                       /* Mode Fault Flag */
    byte SPTEF       :1;                                       /* SPI Transmit Empty Interrupt Flag */
    byte             :1; 
    byte SPIF        :1;                                       /* SPIF Receive Interrupt Flag */
  } Bits;
} SPISRSTR;
extern volatile SPISRSTR _SPISR @(REG_BASE + 0x000000DBUL);
#define SPISR                           _SPISR.Byte
#define SPISR_MODF                      _SPISR.Bits.MODF
#define SPISR_SPTEF                     _SPISR.Bits.SPTEF
#define SPISR_SPIF                      _SPISR.Bits.SPIF

#define SPISR_MODF_MASK                 16U
#define SPISR_SPTEF_MASK                32U
#define SPISR_SPIF_MASK                 128U


/*** SPIDR - SPI 0 Data Register; 0x000000DD ***/
typedef union {
  byte Byte;
} SPIDRSTR;
extern volatile SPIDRSTR _SPIDR @(REG_BASE + 0x000000DDUL);
#define SPIDR                           _SPIDR.Byte


/*** PWME - PWM Enable Register; 0x000000E0 ***/
typedef union {
  byte Byte;
  struct {
    byte PWME0       :1;                                       /* Pulse Width Channel 0 Enable */
    byte PWME1       :1;                                       /* Pulse Width Channel 1 Enable */
    byte PWME2       :1;                                       /* Pulse Width Channel 2 Enable */
    byte PWME3       :1;                                       /* Pulse Width Channel 3 Enable */
    byte PWME4       :1;                                       /* Pulse Width Channel 4 Enable */
    byte PWME5       :1;                                       /* Pulse Width Channel 5 Enable */
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpPWME :6;
    byte         :1;
    byte         :1;
  } MergedBits;
} PWMESTR;
extern volatile PWMESTR _PWME @(REG_BASE + 0x000000E0UL);
#define PWME                            _PWME.Byte
#define PWME_PWME0                      _PWME.Bits.PWME0
#define PWME_PWME1                      _PWME.Bits.PWME1
#define PWME_PWME2                      _PWME.Bits.PWME2
#define PWME_PWME3                      _PWME.Bits.PWME3
#define PWME_PWME4                      _PWME.Bits.PWME4
#define PWME_PWME5                      _PWME.Bits.PWME5
#define PWME_PWME                       _PWME.MergedBits.grpPWME

#define PWME_PWME0_MASK                 1U
#define PWME_PWME1_MASK                 2U
#define PWME_PWME2_MASK                 4U
#define PWME_PWME3_MASK                 8U
#define PWME_PWME4_MASK                 16U
#define PWME_PWME5_MASK                 32U
#define PWME_PWME_MASK                  63U
#define PWME_PWME_BITNUM                0U


/*** PWMPOL - PWM Polarity Register; 0x000000E1 ***/
typedef union {
  byte Byte;
  struct {
    byte PPOL0       :1;                                       /* Pulse Width Channel 0 Polarity */
    byte PPOL1       :1;                                       /* Pulse Width Channel 1 Polarity */
    byte PPOL2       :1;                                       /* Pulse Width Channel 2 Polarity */
    byte PPOL3       :1;                                       /* Pulse Width Channel 3 Polarity */
    byte PPOL4       :1;                                       /* Pulse Width Channel 4 Polarity */
    byte PPOL5       :1;                                       /* Pulse Width Channel 5 Polarity */
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpPPOL :6;
    byte         :1;
    byte         :1;
  } MergedBits;
} PWMPOLSTR;
extern volatile PWMPOLSTR _PWMPOL @(REG_BASE + 0x000000E1UL);
#define PWMPOL                          _PWMPOL.Byte
#define PWMPOL_PPOL0                    _PWMPOL.Bits.PPOL0
#define PWMPOL_PPOL1                    _PWMPOL.Bits.PPOL1
#define PWMPOL_PPOL2                    _PWMPOL.Bits.PPOL2
#define PWMPOL_PPOL3                    _PWMPOL.Bits.PPOL3
#define PWMPOL_PPOL4                    _PWMPOL.Bits.PPOL4
#define PWMPOL_PPOL5                    _PWMPOL.Bits.PPOL5
#define PWMPOL_PPOL                     _PWMPOL.MergedBits.grpPPOL

#define PWMPOL_PPOL0_MASK               1U
#define PWMPOL_PPOL1_MASK               2U
#define PWMPOL_PPOL2_MASK               4U
#define PWMPOL_PPOL3_MASK               8U
#define PWMPOL_PPOL4_MASK               16U
#define PWMPOL_PPOL5_MASK               32U
#define PWMPOL_PPOL_MASK                63U
#define PWMPOL_PPOL_BITNUM              0U


/*** PWMCLK - PWM Clock Select Register; 0x000000E2 ***/
typedef union {
  byte Byte;
  struct {
    byte PCLK0       :1;                                       /* Pulse Width Channel 0 Clock Select */
    byte PCLK1       :1;                                       /* Pulse Width Channel 1 Clock Select */
    byte PCLK2       :1;                                       /* Pulse Width Channel 2 Clock Select */
    byte PCLK3       :1;                                       /* Pulse Width Channel 3 Clock Select */
    byte PCLK4       :1;                                       /* Pulse Width Channel 4 Clock Select */
    byte PCLK5       :1;                                       /* Pulse Width Channel 5 Clock Select */
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpPCLK :6;
    byte         :1;
    byte         :1;
  } MergedBits;
} PWMCLKSTR;
extern volatile PWMCLKSTR _PWMCLK @(REG_BASE + 0x000000E2UL);
#define PWMCLK                          _PWMCLK.Byte
#define PWMCLK_PCLK0                    _PWMCLK.Bits.PCLK0
#define PWMCLK_PCLK1                    _PWMCLK.Bits.PCLK1
#define PWMCLK_PCLK2                    _PWMCLK.Bits.PCLK2
#define PWMCLK_PCLK3                    _PWMCLK.Bits.PCLK3
#define PWMCLK_PCLK4                    _PWMCLK.Bits.PCLK4
#define PWMCLK_PCLK5                    _PWMCLK.Bits.PCLK5
#define PWMCLK_PCLK                     _PWMCLK.MergedBits.grpPCLK

#define PWMCLK_PCLK0_MASK               1U
#define PWMCLK_PCLK1_MASK               2U
#define PWMCLK_PCLK2_MASK               4U
#define PWMCLK_PCLK3_MASK               8U
#define PWMCLK_PCLK4_MASK               16U
#define PWMCLK_PCLK5_MASK               32U
#define PWMCLK_PCLK_MASK                63U
#define PWMCLK_PCLK_BITNUM              0U


/*** PWMPRCLK - PWM Prescale Clock Select Register; 0x000000E3 ***/
typedef union {
  byte Byte;
  struct {
    byte PCKA0       :1;                                       /* Prescaler Select for Clock A 0 */
    byte PCKA1       :1;                                       /* Prescaler Select for Clock A 1 */
    byte PCKA2       :1;                                       /* Prescaler Select for Clock A 2 */
    byte             :1; 
    byte PCKB0       :1;                                       /* Prescaler Select for Clock B 0 */
    byte PCKB1       :1;                                       /* Prescaler Select for Clock B 1 */
    byte PCKB2       :1;                                       /* Prescaler Select for Clock B 2 */
    byte             :1; 
  } Bits;
  struct {
    byte grpPCKA :3;
    byte         :1;
    byte grpPCKB :3;
    byte         :1;
  } MergedBits;
} PWMPRCLKSTR;
extern volatile PWMPRCLKSTR _PWMPRCLK @(REG_BASE + 0x000000E3UL);
#define PWMPRCLK                        _PWMPRCLK.Byte
#define PWMPRCLK_PCKA0                  _PWMPRCLK.Bits.PCKA0
#define PWMPRCLK_PCKA1                  _PWMPRCLK.Bits.PCKA1
#define PWMPRCLK_PCKA2                  _PWMPRCLK.Bits.PCKA2
#define PWMPRCLK_PCKB0                  _PWMPRCLK.Bits.PCKB0
#define PWMPRCLK_PCKB1                  _PWMPRCLK.Bits.PCKB1
#define PWMPRCLK_PCKB2                  _PWMPRCLK.Bits.PCKB2
#define PWMPRCLK_PCKA                   _PWMPRCLK.MergedBits.grpPCKA
#define PWMPRCLK_PCKB                   _PWMPRCLK.MergedBits.grpPCKB

#define PWMPRCLK_PCKA0_MASK             1U
#define PWMPRCLK_PCKA1_MASK             2U
#define PWMPRCLK_PCKA2_MASK             4U
#define PWMPRCLK_PCKB0_MASK             16U
#define PWMPRCLK_PCKB1_MASK             32U
#define PWMPRCLK_PCKB2_MASK             64U
#define PWMPRCLK_PCKA_MASK              7U
#define PWMPRCLK_PCKA_BITNUM            0U
#define PWMPRCLK_PCKB_MASK              112U
#define PWMPRCLK_PCKB_BITNUM            4U


/*** PWMCAE - PWM Center Align Enable Register; 0x000000E4 ***/
typedef union {
  byte Byte;
  struct {
    byte CAE0        :1;                                       /* Center Aligned Output Mode on channel 0 */
    byte CAE1        :1;                                       /* Center Aligned Output Mode on channel 1 */
    byte CAE2        :1;                                       /* Center Aligned Output Mode on channel 2 */
    byte CAE3        :1;                                       /* Center Aligned Output Mode on channel 3 */
    byte CAE4        :1;                                       /* Center Aligned Output Mode on channel 4 */
    byte CAE5        :1;                                       /* Center Aligned Output Mode on channel 5 */
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpCAE  :6;
    byte         :1;
    byte         :1;
  } MergedBits;
} PWMCAESTR;
extern volatile PWMCAESTR _PWMCAE @(REG_BASE + 0x000000E4UL);
#define PWMCAE                          _PWMCAE.Byte
#define PWMCAE_CAE0                     _PWMCAE.Bits.CAE0
#define PWMCAE_CAE1                     _PWMCAE.Bits.CAE1
#define PWMCAE_CAE2                     _PWMCAE.Bits.CAE2
#define PWMCAE_CAE3                     _PWMCAE.Bits.CAE3
#define PWMCAE_CAE4                     _PWMCAE.Bits.CAE4
#define PWMCAE_CAE5                     _PWMCAE.Bits.CAE5
#define PWMCAE_CAE                      _PWMCAE.MergedBits.grpCAE

#define PWMCAE_CAE0_MASK                1U
#define PWMCAE_CAE1_MASK                2U
#define PWMCAE_CAE2_MASK                4U
#define PWMCAE_CAE3_MASK                8U
#define PWMCAE_CAE4_MASK                16U
#define PWMCAE_CAE5_MASK                32U
#define PWMCAE_CAE_MASK                 63U
#define PWMCAE_CAE_BITNUM               0U


/*** PWMCTL - PWM Control Register; 0x000000E5 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte PFRZ        :1;                                       /* PWM Counters Stop in Freeze Mode */
    byte PSWAI       :1;                                       /* PWM Stops in Wait Mode */
    byte CON01       :1;                                       /* Concatenate channels 0 and 1 */
    byte CON23       :1;                                       /* Concatenate channels 2 and 3 */
    byte CON45       :1;                                       /* Concatenate channels 4 and 5 */
    byte             :1; 
  } Bits;
} PWMCTLSTR;
extern volatile PWMCTLSTR _PWMCTL @(REG_BASE + 0x000000E5UL);
#define PWMCTL                          _PWMCTL.Byte
#define PWMCTL_PFRZ                     _PWMCTL.Bits.PFRZ
#define PWMCTL_PSWAI                    _PWMCTL.Bits.PSWAI
#define PWMCTL_CON01                    _PWMCTL.Bits.CON01
#define PWMCTL_CON23                    _PWMCTL.Bits.CON23
#define PWMCTL_CON45                    _PWMCTL.Bits.CON45

#define PWMCTL_PFRZ_MASK                4U
#define PWMCTL_PSWAI_MASK               8U
#define PWMCTL_CON01_MASK               16U
#define PWMCTL_CON23_MASK               32U
#define PWMCTL_CON45_MASK               64U


/*** PWMSCLA - PWM Scale A Register; 0x000000E8 ***/
typedef union {
  byte Byte;
  struct {
    byte BIT0        :1;                                       /* PWM Scale A Bit 0 */
    byte BIT1        :1;                                       /* PWM Scale A Bit 1 */
    byte BIT2        :1;                                       /* PWM Scale A Bit 2 */
    byte BIT3        :1;                                       /* PWM Scale A Bit 3 */
    byte BIT4        :1;                                       /* PWM Scale A Bit 4 */
    byte BIT5        :1;                                       /* PWM Scale A Bit 5 */
    byte BIT6        :1;                                       /* PWM Scale A Bit 6 */
    byte BIT7        :1;                                       /* PWM Scale A Bit 7 */
  } Bits;
} PWMSCLASTR;
extern volatile PWMSCLASTR _PWMSCLA @(REG_BASE + 0x000000E8UL);
#define PWMSCLA                         _PWMSCLA.Byte
#define PWMSCLA_BIT0                    _PWMSCLA.Bits.BIT0
#define PWMSCLA_BIT1                    _PWMSCLA.Bits.BIT1
#define PWMSCLA_BIT2                    _PWMSCLA.Bits.BIT2
#define PWMSCLA_BIT3                    _PWMSCLA.Bits.BIT3
#define PWMSCLA_BIT4                    _PWMSCLA.Bits.BIT4
#define PWMSCLA_BIT5                    _PWMSCLA.Bits.BIT5
#define PWMSCLA_BIT6                    _PWMSCLA.Bits.BIT6
#define PWMSCLA_BIT7                    _PWMSCLA.Bits.BIT7

#define PWMSCLA_BIT0_MASK               1U
#define PWMSCLA_BIT1_MASK               2U
#define PWMSCLA_BIT2_MASK               4U
#define PWMSCLA_BIT3_MASK               8U
#define PWMSCLA_BIT4_MASK               16U
#define PWMSCLA_BIT5_MASK               32U
#define PWMSCLA_BIT6_MASK               64U
#define PWMSCLA_BIT7_MASK               128U


/*** PWMSCLB - PWM Scale B Register; 0x000000E9 ***/
typedef union {
  byte Byte;
  struct {
    byte BIT0        :1;                                       /* PWM Scale B Bit 0 */
    byte BIT1        :1;                                       /* PWM Scale B Bit 1 */
    byte BIT2        :1;                                       /* PWM Scale B Bit 2 */
    byte BIT3        :1;                                       /* PWM Scale B Bit 3 */
    byte BIT4        :1;                                       /* PWM Scale B Bit 4 */
    byte BIT5        :1;                                       /* PWM Scale B Bit 5 */
    byte BIT6        :1;                                       /* PWM Scale B Bit 6 */
    byte BIT7        :1;                                       /* PWM Scale B Bit 7 */
  } Bits;
} PWMSCLBSTR;
extern volatile PWMSCLBSTR _PWMSCLB @(REG_BASE + 0x000000E9UL);
#define PWMSCLB                         _PWMSCLB.Byte
#define PWMSCLB_BIT0                    _PWMSCLB.Bits.BIT0
#define PWMSCLB_BIT1                    _PWMSCLB.Bits.BIT1
#define PWMSCLB_BIT2                    _PWMSCLB.Bits.BIT2
#define PWMSCLB_BIT3                    _PWMSCLB.Bits.BIT3
#define PWMSCLB_BIT4                    _PWMSCLB.Bits.BIT4
#define PWMSCLB_BIT5                    _PWMSCLB.Bits.BIT5
#define PWMSCLB_BIT6                    _PWMSCLB.Bits.BIT6
#define PWMSCLB_BIT7                    _PWMSCLB.Bits.BIT7

#define PWMSCLB_BIT0_MASK               1U
#define PWMSCLB_BIT1_MASK               2U
#define PWMSCLB_BIT2_MASK               4U
#define PWMSCLB_BIT3_MASK               8U
#define PWMSCLB_BIT4_MASK               16U
#define PWMSCLB_BIT5_MASK               32U
#define PWMSCLB_BIT6_MASK               64U
#define PWMSCLB_BIT7_MASK               128U


/*** PWMCNT01 - PWM Channel Counter 01 Register; 0x000000EC ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** PWMCNT0 - PWM Channel Counter 0 Register; 0x000000EC ***/
    union {
      byte Byte;
    } PWMCNT0STR;
    #define PWMCNT0                     _PWMCNT01.Overlap_STR.PWMCNT0STR.Byte
    /* PWMCNT_ARR: Access 6 PWMCNTx registers in an array */
    #define PWMCNT_ARR                  ((volatile byte *) &PWMCNT0)
    

    /*** PWMCNT1 - PWM Channel Counter 1 Register; 0x000000ED ***/
    union {
      byte Byte;
    } PWMCNT1STR;
    #define PWMCNT1                     _PWMCNT01.Overlap_STR.PWMCNT1STR.Byte
    
  } Overlap_STR;

} PWMCNT01STR;
extern volatile PWMCNT01STR _PWMCNT01 @(REG_BASE + 0x000000ECUL);
#define PWMCNT01                        _PWMCNT01.Word


/*** PWMCNT23 - PWM Channel Counter 23 Register; 0x000000EE ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** PWMCNT2 - PWM Channel Counter 2 Register; 0x000000EE ***/
    union {
      byte Byte;
    } PWMCNT2STR;
    #define PWMCNT2                     _PWMCNT23.Overlap_STR.PWMCNT2STR.Byte
    

    /*** PWMCNT3 - PWM Channel Counter 3 Register; 0x000000EF ***/
    union {
      byte Byte;
    } PWMCNT3STR;
    #define PWMCNT3                     _PWMCNT23.Overlap_STR.PWMCNT3STR.Byte
    
  } Overlap_STR;

} PWMCNT23STR;
extern volatile PWMCNT23STR _PWMCNT23 @(REG_BASE + 0x000000EEUL);
#define PWMCNT23                        _PWMCNT23.Word


/*** PWMCNT45 - PWM Channel Counter 45 Register; 0x000000F0 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** PWMCNT4 - PWM Channel Counter 4 Register; 0x000000F0 ***/
    union {
      byte Byte;
    } PWMCNT4STR;
    #define PWMCNT4                     _PWMCNT45.Overlap_STR.PWMCNT4STR.Byte
    

    /*** PWMCNT5 - PWM Channel Counter 5 Register; 0x000000F1 ***/
    union {
      byte Byte;
    } PWMCNT5STR;
    #define PWMCNT5                     _PWMCNT45.Overlap_STR.PWMCNT5STR.Byte
    
  } Overlap_STR;

} PWMCNT45STR;
extern volatile PWMCNT45STR _PWMCNT45 @(REG_BASE + 0x000000F0UL);
#define PWMCNT45                        _PWMCNT45.Word


/*** PWMPER01 - PWM Channel Period 01 Register; 0x000000F2 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** PWMPER0 - PWM Channel Period 0 Register; 0x000000F2 ***/
    union {
      byte Byte;
    } PWMPER0STR;
    #define PWMPER0                     _PWMPER01.Overlap_STR.PWMPER0STR.Byte
    /* PWMPER_ARR: Access 6 PWMPERx registers in an array */
    #define PWMPER_ARR                  ((volatile byte *) &PWMPER0)
    

    /*** PWMPER1 - PWM Channel Period 1 Register; 0x000000F3 ***/
    union {
      byte Byte;
    } PWMPER1STR;
    #define PWMPER1                     _PWMPER01.Overlap_STR.PWMPER1STR.Byte
    
  } Overlap_STR;

} PWMPER01STR;
extern volatile PWMPER01STR _PWMPER01 @(REG_BASE + 0x000000F2UL);
#define PWMPER01                        _PWMPER01.Word


/*** PWMPER23 - PWM Channel Period 23 Register; 0x000000F4 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** PWMPER2 - PWM Channel Period 2 Register; 0x000000F4 ***/
    union {
      byte Byte;
    } PWMPER2STR;
    #define PWMPER2                     _PWMPER23.Overlap_STR.PWMPER2STR.Byte
    

    /*** PWMPER3 - PWM Channel Period 3 Register; 0x000000F5 ***/
    union {
      byte Byte;
    } PWMPER3STR;
    #define PWMPER3                     _PWMPER23.Overlap_STR.PWMPER3STR.Byte
    
  } Overlap_STR;

} PWMPER23STR;
extern volatile PWMPER23STR _PWMPER23 @(REG_BASE + 0x000000F4UL);
#define PWMPER23                        _PWMPER23.Word


/*** PWMPER45 - PWM Channel Period 45 Register; 0x000000F6 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** PWMPER4 - PWM Channel Period 4 Register; 0x000000F6 ***/
    union {
      byte Byte;
    } PWMPER4STR;
    #define PWMPER4                     _PWMPER45.Overlap_STR.PWMPER4STR.Byte
    

    /*** PWMPER5 - PWM Channel Period 5 Register; 0x000000F7 ***/
    union {
      byte Byte;
    } PWMPER5STR;
    #define PWMPER5                     _PWMPER45.Overlap_STR.PWMPER5STR.Byte
    
  } Overlap_STR;

} PWMPER45STR;
extern volatile PWMPER45STR _PWMPER45 @(REG_BASE + 0x000000F6UL);
#define PWMPER45                        _PWMPER45.Word


/*** PWMDTY01 - PWM Channel Duty 01 Register; 0x000000F8 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** PWMDTY0 - PWM Channel Duty 0 Register; 0x000000F8 ***/
    union {
      byte Byte;
    } PWMDTY0STR;
    #define PWMDTY0                     _PWMDTY01.Overlap_STR.PWMDTY0STR.Byte
    /* PWMDTY_ARR: Access 6 PWMDTYx registers in an array */
    #define PWMDTY_ARR                  ((volatile byte *) &PWMDTY0)
    

    /*** PWMDTY1 - PWM Channel Duty 1 Register; 0x000000F9 ***/
    union {
      byte Byte;
    } PWMDTY1STR;
    #define PWMDTY1                     _PWMDTY01.Overlap_STR.PWMDTY1STR.Byte
    
  } Overlap_STR;

} PWMDTY01STR;
extern volatile PWMDTY01STR _PWMDTY01 @(REG_BASE + 0x000000F8UL);
#define PWMDTY01                        _PWMDTY01.Word


/*** PWMDTY23 - PWM Channel Duty 23 Register; 0x000000FA ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** PWMDTY2 - PWM Channel Duty 2 Register; 0x000000FA ***/
    union {
      byte Byte;
    } PWMDTY2STR;
    #define PWMDTY2                     _PWMDTY23.Overlap_STR.PWMDTY2STR.Byte
    

    /*** PWMDTY3 - PWM Channel Duty 3 Register; 0x000000FB ***/
    union {
      byte Byte;
    } PWMDTY3STR;
    #define PWMDTY3                     _PWMDTY23.Overlap_STR.PWMDTY3STR.Byte
    
  } Overlap_STR;

} PWMDTY23STR;
extern volatile PWMDTY23STR _PWMDTY23 @(REG_BASE + 0x000000FAUL);
#define PWMDTY23                        _PWMDTY23.Word


/*** PWMDTY45 - PWM Channel Duty 45 Register; 0x000000FC ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** PWMDTY4 - PWM Channel Duty 4 Register; 0x000000FC ***/
    union {
      byte Byte;
    } PWMDTY4STR;
    #define PWMDTY4                     _PWMDTY45.Overlap_STR.PWMDTY4STR.Byte
    

    /*** PWMDTY5 - PWM Channel Duty 5 Register; 0x000000FD ***/
    union {
      byte Byte;
    } PWMDTY5STR;
    #define PWMDTY5                     _PWMDTY45.Overlap_STR.PWMDTY5STR.Byte
    
  } Overlap_STR;

} PWMDTY45STR;
extern volatile PWMDTY45STR _PWMDTY45 @(REG_BASE + 0x000000FCUL);
#define PWMDTY45                        _PWMDTY45.Word


/*** PWMSDN - PWM Shutdown Register; 0x000000FE ***/
typedef union {
  byte Byte;
  struct {
    byte PWM5ENA     :1;                                       /* PWM emergency shutdown Enable */
    byte PWM5INL     :1;                                       /* PWM shutdown active input level for ch. 5 */
    byte PWM5IN      :1;                                       /* PWM channel 5 input status */
    byte             :1; 
    byte PWMLVL      :1;                                       /* PWM shutdown output Level */
    byte PWMRSTRT    :1;                                       /* PWM Restart */
    byte PWMIE       :1;                                       /* PWM Interrupt Enable */
    byte PWMIF       :1;                                       /* PWM Interrupt Flag */
  } Bits;
} PWMSDNSTR;
extern volatile PWMSDNSTR _PWMSDN @(REG_BASE + 0x000000FEUL);
#define PWMSDN                          _PWMSDN.Byte
#define PWMSDN_PWM5ENA                  _PWMSDN.Bits.PWM5ENA
#define PWMSDN_PWM5INL                  _PWMSDN.Bits.PWM5INL
#define PWMSDN_PWM5IN                   _PWMSDN.Bits.PWM5IN
#define PWMSDN_PWMLVL                   _PWMSDN.Bits.PWMLVL
#define PWMSDN_PWMRSTRT                 _PWMSDN.Bits.PWMRSTRT
#define PWMSDN_PWMIE                    _PWMSDN.Bits.PWMIE
#define PWMSDN_PWMIF                    _PWMSDN.Bits.PWMIF

#define PWMSDN_PWM5ENA_MASK             1U
#define PWMSDN_PWM5INL_MASK             2U
#define PWMSDN_PWM5IN_MASK              4U
#define PWMSDN_PWMLVL_MASK              16U
#define PWMSDN_PWMRSTRT_MASK            32U
#define PWMSDN_PWMIE_MASK               64U
#define PWMSDN_PWMIF_MASK               128U


/*** FCLKDIV - Flash Clock Divider Register; 0x00000100 ***/
typedef union {
  byte Byte;
  struct {
    byte FDIV0       :1;                                       /* Flash Clock Divider Bit 0 */
    byte FDIV1       :1;                                       /* Flash Clock Divider Bit 1 */
    byte FDIV2       :1;                                       /* Flash Clock Divider Bit 2 */
    byte FDIV3       :1;                                       /* Flash Clock Divider Bit 3 */
    byte FDIV4       :1;                                       /* Flash Clock Divider Bit 4 */
    byte FDIV5       :1;                                       /* Flash Clock Divider Bit 5 */
    byte PRDIV8      :1;                                       /* Enable Prescaler by 8 */
    byte FDIVLD      :1;                                       /* Flash Clock Divider Loaded */
  } Bits;
  struct {
    byte grpFDIV :6;
    byte grpPRDIV_8 :1;
    byte         :1;
  } MergedBits;
} FCLKDIVSTR;
extern volatile FCLKDIVSTR _FCLKDIV @(REG_BASE + 0x00000100UL);
#define FCLKDIV                         _FCLKDIV.Byte
#define FCLKDIV_FDIV0                   _FCLKDIV.Bits.FDIV0
#define FCLKDIV_FDIV1                   _FCLKDIV.Bits.FDIV1
#define FCLKDIV_FDIV2                   _FCLKDIV.Bits.FDIV2
#define FCLKDIV_FDIV3                   _FCLKDIV.Bits.FDIV3
#define FCLKDIV_FDIV4                   _FCLKDIV.Bits.FDIV4
#define FCLKDIV_FDIV5                   _FCLKDIV.Bits.FDIV5
#define FCLKDIV_PRDIV8                  _FCLKDIV.Bits.PRDIV8
#define FCLKDIV_FDIVLD                  _FCLKDIV.Bits.FDIVLD
#define FCLKDIV_FDIV                    _FCLKDIV.MergedBits.grpFDIV

#define FCLKDIV_FDIV0_MASK              1U
#define FCLKDIV_FDIV1_MASK              2U
#define FCLKDIV_FDIV2_MASK              4U
#define FCLKDIV_FDIV3_MASK              8U
#define FCLKDIV_FDIV4_MASK              16U
#define FCLKDIV_FDIV5_MASK              32U
#define FCLKDIV_PRDIV8_MASK             64U
#define FCLKDIV_FDIVLD_MASK             128U
#define FCLKDIV_FDIV_MASK               63U
#define FCLKDIV_FDIV_BITNUM             0U


/*** FSEC - Flash Security Register; 0x00000101 ***/
typedef union {
  byte Byte;
  struct {
    byte SEC0        :1;                                       /* Memory security bit 0 */
    byte SEC1        :1;                                       /* Memory security bit 1 */
    byte RNV2        :1;                                       /* Reserved Non Volatile flag bit 2 */
    byte RNV3        :1;                                       /* Reserved Non Volatile flag bit 3 */
    byte RNV4        :1;                                       /* Reserved Non Volatile flag bit 4 */
    byte RNV5        :1;                                       /* Reserved Non Volatile flag bit 5 */
    byte KEYEN0      :1;                                       /* Backdoor Key Security Enable Bit 0 */
    byte KEYEN1      :1;                                       /* Backdoor Key Security Enable Bit 1 */
  } Bits;
  struct {
    byte grpSEC  :2;
    byte grpRNV_2 :4;
    byte grpKEYEN :2;
  } MergedBits;
} FSECSTR;
extern volatile FSECSTR _FSEC @(REG_BASE + 0x00000101UL);
#define FSEC                            _FSEC.Byte
#define FSEC_SEC0                       _FSEC.Bits.SEC0
#define FSEC_SEC1                       _FSEC.Bits.SEC1
#define FSEC_RNV2                       _FSEC.Bits.RNV2
#define FSEC_RNV3                       _FSEC.Bits.RNV3
#define FSEC_RNV4                       _FSEC.Bits.RNV4
#define FSEC_RNV5                       _FSEC.Bits.RNV5
#define FSEC_KEYEN0                     _FSEC.Bits.KEYEN0
#define FSEC_KEYEN1                     _FSEC.Bits.KEYEN1
#define FSEC_SEC                        _FSEC.MergedBits.grpSEC
#define FSEC_RNV_2                      _FSEC.MergedBits.grpRNV_2
#define FSEC_KEYEN                      _FSEC.MergedBits.grpKEYEN
#define FSEC_RNV                        FSEC_RNV_2

#define FSEC_SEC0_MASK                  1U
#define FSEC_SEC1_MASK                  2U
#define FSEC_RNV2_MASK                  4U
#define FSEC_RNV3_MASK                  8U
#define FSEC_RNV4_MASK                  16U
#define FSEC_RNV5_MASK                  32U
#define FSEC_KEYEN0_MASK                64U
#define FSEC_KEYEN1_MASK                128U
#define FSEC_SEC_MASK                   3U
#define FSEC_SEC_BITNUM                 0U
#define FSEC_RNV_2_MASK                 60U
#define FSEC_RNV_2_BITNUM               2U
#define FSEC_KEYEN_MASK                 192U
#define FSEC_KEYEN_BITNUM               6U


/*** FCNFG - Flash Configuration Register; 0x00000103 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte KEYACC      :1;                                       /* Enable Security Key Writing */
    byte CCIE        :1;                                       /* Command Complete Interrupt Enable */
    byte CBEIE       :1;                                       /* Command Buffers Empty Interrupt Enable */
  } Bits;
} FCNFGSTR;
extern volatile FCNFGSTR _FCNFG @(REG_BASE + 0x00000103UL);
#define FCNFG                           _FCNFG.Byte
#define FCNFG_KEYACC                    _FCNFG.Bits.KEYACC
#define FCNFG_CCIE                      _FCNFG.Bits.CCIE
#define FCNFG_CBEIE                     _FCNFG.Bits.CBEIE

#define FCNFG_KEYACC_MASK               32U
#define FCNFG_CCIE_MASK                 64U
#define FCNFG_CBEIE_MASK                128U


/*** FPROT - Flash Protection Register; 0x00000104 ***/
typedef union {
  byte Byte;
  struct {
    byte FPLS0       :1;                                       /* Flash Protection Lower Address size 0 */
    byte FPLS1       :1;                                       /* Flash Protection Lower Address size 1 */
    byte FPLDIS      :1;                                       /* Flash Protection Lower address range disable */
    byte FPHS0       :1;                                       /* Flash Protection Higher address size 0 */
    byte FPHS1       :1;                                       /* Flash Protection Higher address size 1 */
    byte FPHDIS      :1;                                       /* Flash Protection Higher address range disable */
    byte RNV6        :1;                                       /* Reserved  Non Volatile Flag Bit */
    byte FPOPEN      :1;                                       /* Opens the flash block or subsections of it for program or erase */
  } Bits;
  struct {
    byte grpFPLS :2;
    byte         :1;
    byte grpFPHS :2;
    byte         :1;
    byte grpRNV_6 :1;
    byte         :1;
  } MergedBits;
} FPROTSTR;
extern volatile FPROTSTR _FPROT @(REG_BASE + 0x00000104UL);
#define FPROT                           _FPROT.Byte
#define FPROT_FPLS0                     _FPROT.Bits.FPLS0
#define FPROT_FPLS1                     _FPROT.Bits.FPLS1
#define FPROT_FPLDIS                    _FPROT.Bits.FPLDIS
#define FPROT_FPHS0                     _FPROT.Bits.FPHS0
#define FPROT_FPHS1                     _FPROT.Bits.FPHS1
#define FPROT_FPHDIS                    _FPROT.Bits.FPHDIS
#define FPROT_RNV6                      _FPROT.Bits.RNV6
#define FPROT_FPOPEN                    _FPROT.Bits.FPOPEN
#define FPROT_FPLS                      _FPROT.MergedBits.grpFPLS
#define FPROT_FPHS                      _FPROT.MergedBits.grpFPHS

#define FPROT_FPLS0_MASK                1U
#define FPROT_FPLS1_MASK                2U
#define FPROT_FPLDIS_MASK               4U
#define FPROT_FPHS0_MASK                8U
#define FPROT_FPHS1_MASK                16U
#define FPROT_FPHDIS_MASK               32U
#define FPROT_RNV6_MASK                 64U
#define FPROT_FPOPEN_MASK               128U
#define FPROT_FPLS_MASK                 3U
#define FPROT_FPLS_BITNUM               0U
#define FPROT_FPHS_MASK                 24U
#define FPROT_FPHS_BITNUM               3U


/*** FSTAT - Flash Status Register; 0x00000105 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte BLANK       :1;                                       /* Blank Verify Flag */
    byte             :1; 
    byte ACCERR      :1;                                       /* Access error */
    byte PVIOL       :1;                                       /* Protection violation */
    byte CCIF        :1;                                       /* Command Complete Interrupt Flag */
    byte CBEIF       :1;                                       /* Command Buffers Empty Interrupt Flag */
  } Bits;
} FSTATSTR;
extern volatile FSTATSTR _FSTAT @(REG_BASE + 0x00000105UL);
#define FSTAT                           _FSTAT.Byte
#define FSTAT_BLANK                     _FSTAT.Bits.BLANK
#define FSTAT_ACCERR                    _FSTAT.Bits.ACCERR
#define FSTAT_PVIOL                     _FSTAT.Bits.PVIOL
#define FSTAT_CCIF                      _FSTAT.Bits.CCIF
#define FSTAT_CBEIF                     _FSTAT.Bits.CBEIF

#define FSTAT_BLANK_MASK                4U
#define FSTAT_ACCERR_MASK               16U
#define FSTAT_PVIOL_MASK                32U
#define FSTAT_CCIF_MASK                 64U
#define FSTAT_CBEIF_MASK                128U


/*** FCMD - Flash Command Buffer and Register; 0x00000106 ***/
typedef union {
  byte Byte;
  struct {
    byte CMDB0       :1;                                       /* Flash Command Bit 0 */
    byte CMDB1       :1;                                       /* Flash Command Bit 1 */
    byte CMDB2       :1;                                       /* Flash Command Bit 2 */
    byte CMDB3       :1;                                       /* Flash Command Bit 3 */
    byte CMDB4       :1;                                       /* Flash Command Bit 4 */
    byte CMDB5       :1;                                       /* Flash Command Bit 5 */
    byte CMDB6       :1;                                       /* Flash Command Bit 6 */
    byte             :1; 
  } Bits;
  struct {
    byte grpCMDB :7;
    byte         :1;
  } MergedBits;
} FCMDSTR;
extern volatile FCMDSTR _FCMD @(REG_BASE + 0x00000106UL);
#define FCMD                            _FCMD.Byte
#define FCMD_CMDB0                      _FCMD.Bits.CMDB0
#define FCMD_CMDB1                      _FCMD.Bits.CMDB1
#define FCMD_CMDB2                      _FCMD.Bits.CMDB2
#define FCMD_CMDB3                      _FCMD.Bits.CMDB3
#define FCMD_CMDB4                      _FCMD.Bits.CMDB4
#define FCMD_CMDB5                      _FCMD.Bits.CMDB5
#define FCMD_CMDB6                      _FCMD.Bits.CMDB6
#define FCMD_CMDB                       _FCMD.MergedBits.grpCMDB

#define FCMD_CMDB0_MASK                 1U
#define FCMD_CMDB1_MASK                 2U
#define FCMD_CMDB2_MASK                 4U
#define FCMD_CMDB3_MASK                 8U
#define FCMD_CMDB4_MASK                 16U
#define FCMD_CMDB5_MASK                 32U
#define FCMD_CMDB6_MASK                 64U
#define FCMD_CMDB_MASK                  127U
#define FCMD_CMDB_BITNUM                0U


/*** FCTL - Flash Control Register; 0x00000107 ***/
typedef union {
  byte Byte;
  struct {
    byte NV0         :1;                                       /* Non-Volatile Bit 0 */
    byte NV1         :1;                                       /* Non-Volatile Bit 1 */
    byte NV2         :1;                                       /* Non-Volatile Bit 2 */
    byte NV3         :1;                                       /* Non-Volatile Bit 3 */
    byte NV4         :1;                                       /* Non-Volatile Bit 4 */
    byte NV5         :1;                                       /* Non-Volatile Bit 5 */
    byte NV6         :1;                                       /* Non-Volatile Bit 6 */
    byte NV7         :1;                                       /* Non-Volatile Bit 7 */
  } Bits;
} FCTLSTR;
extern volatile FCTLSTR _FCTL @(REG_BASE + 0x00000107UL);
#define FCTL                            _FCTL.Byte
#define FCTL_NV0                        _FCTL.Bits.NV0
#define FCTL_NV1                        _FCTL.Bits.NV1
#define FCTL_NV2                        _FCTL.Bits.NV2
#define FCTL_NV3                        _FCTL.Bits.NV3
#define FCTL_NV4                        _FCTL.Bits.NV4
#define FCTL_NV5                        _FCTL.Bits.NV5
#define FCTL_NV6                        _FCTL.Bits.NV6
#define FCTL_NV7                        _FCTL.Bits.NV7

#define FCTL_NV0_MASK                   1U
#define FCTL_NV1_MASK                   2U
#define FCTL_NV2_MASK                   4U
#define FCTL_NV3_MASK                   8U
#define FCTL_NV4_MASK                   16U
#define FCTL_NV5_MASK                   32U
#define FCTL_NV6_MASK                   64U
#define FCTL_NV7_MASK                   128U


/*** FADDRHI - Flash Address High Register; 0x00000108 ***/
typedef union {
  byte Byte;
  struct {
    byte FADDRHI8    :1;                                       /* Flash Address High Bit 8 */
    byte FADDRHI9    :1;                                       /* Flash Address High Bit 9 */
    byte FADDRHI10   :1;                                       /* Flash Address High Bit 10 */
    byte FADDRHI11   :1;                                       /* Flash Address High Bit 11 */
    byte FADDRHI12   :1;                                       /* Flash Address High Bit 12 */
    byte FADDRHI13   :1;                                       /* Flash Address High Bit 13 */
    byte FADDRHI14   :1;                                       /* Flash Address High Bit 14 */
    byte FADDRHI15   :1;                                       /* Flash Address High Bit 15 */
  } Bits;
} FADDRHISTR;
extern volatile FADDRHISTR _FADDRHI @(REG_BASE + 0x00000108UL);
#define FADDRHI                         _FADDRHI.Byte
#define FADDRHI_FADDRHI8                _FADDRHI.Bits.FADDRHI8
#define FADDRHI_FADDRHI9                _FADDRHI.Bits.FADDRHI9
#define FADDRHI_FADDRHI10               _FADDRHI.Bits.FADDRHI10
#define FADDRHI_FADDRHI11               _FADDRHI.Bits.FADDRHI11
#define FADDRHI_FADDRHI12               _FADDRHI.Bits.FADDRHI12
#define FADDRHI_FADDRHI13               _FADDRHI.Bits.FADDRHI13
#define FADDRHI_FADDRHI14               _FADDRHI.Bits.FADDRHI14
#define FADDRHI_FADDRHI15               _FADDRHI.Bits.FADDRHI15

#define FADDRHI_FADDRHI8_MASK           1U
#define FADDRHI_FADDRHI9_MASK           2U
#define FADDRHI_FADDRHI10_MASK          4U
#define FADDRHI_FADDRHI11_MASK          8U
#define FADDRHI_FADDRHI12_MASK          16U
#define FADDRHI_FADDRHI13_MASK          32U
#define FADDRHI_FADDRHI14_MASK          64U
#define FADDRHI_FADDRHI15_MASK          128U


/*** FADDRLO - Flash Address Low Register; 0x00000109 ***/
typedef union {
  byte Byte;
  struct {
    byte FADDRLO0    :1;                                       /* Flash Address Low Bit 0 */
    byte FADDRLO1    :1;                                       /* Flash Address Low Bit 1 */
    byte FADDRLO2    :1;                                       /* Flash Address Low Bit 2 */
    byte FADDRLO3    :1;                                       /* Flash Address Low Bit 3 */
    byte FADDRLO4    :1;                                       /* Flash Address Low Bit 4 */
    byte FADDRLO5    :1;                                       /* Flash Address Low Bit 5 */
    byte FADDRLO6    :1;                                       /* Flash Address Low Bit 6 */
    byte FADDRLO7    :1;                                       /* Flash Address Low Bit 7 */
  } Bits;
} FADDRLOSTR;
extern volatile FADDRLOSTR _FADDRLO @(REG_BASE + 0x00000109UL);
#define FADDRLO                         _FADDRLO.Byte
#define FADDRLO_FADDRLO0                _FADDRLO.Bits.FADDRLO0
#define FADDRLO_FADDRLO1                _FADDRLO.Bits.FADDRLO1
#define FADDRLO_FADDRLO2                _FADDRLO.Bits.FADDRLO2
#define FADDRLO_FADDRLO3                _FADDRLO.Bits.FADDRLO3
#define FADDRLO_FADDRLO4                _FADDRLO.Bits.FADDRLO4
#define FADDRLO_FADDRLO5                _FADDRLO.Bits.FADDRLO5
#define FADDRLO_FADDRLO6                _FADDRLO.Bits.FADDRLO6
#define FADDRLO_FADDRLO7                _FADDRLO.Bits.FADDRLO7

#define FADDRLO_FADDRLO0_MASK           1U
#define FADDRLO_FADDRLO1_MASK           2U
#define FADDRLO_FADDRLO2_MASK           4U
#define FADDRLO_FADDRLO3_MASK           8U
#define FADDRLO_FADDRLO4_MASK           16U
#define FADDRLO_FADDRLO5_MASK           32U
#define FADDRLO_FADDRLO6_MASK           64U
#define FADDRLO_FADDRLO7_MASK           128U


/*** FDATAHI - Flash Data High Register; 0x0000010A ***/
typedef union {
  byte Byte;
  struct {
    byte FDATAHI8    :1;                                       /* Flash Data High Bit 8 */
    byte FDATAHI9    :1;                                       /* Flash Data High Bit 9 */
    byte FDATAHI10   :1;                                       /* Flash Data High Bit 10 */
    byte FDATAHI11   :1;                                       /* Flash Data High Bit 11 */
    byte FDATAHI12   :1;                                       /* Flash Data High Bit 12 */
    byte FDATAHI13   :1;                                       /* Flash Data High Bit 13 */
    byte FDATAHI14   :1;                                       /* Flash Data High Bit 14 */
    byte FDATAHI15   :1;                                       /* Flash Data High Bit 15 */
  } Bits;
} FDATAHISTR;
extern volatile FDATAHISTR _FDATAHI @(REG_BASE + 0x0000010AUL);
#define FDATAHI                         _FDATAHI.Byte
#define FDATAHI_FDATAHI8                _FDATAHI.Bits.FDATAHI8
#define FDATAHI_FDATAHI9                _FDATAHI.Bits.FDATAHI9
#define FDATAHI_FDATAHI10               _FDATAHI.Bits.FDATAHI10
#define FDATAHI_FDATAHI11               _FDATAHI.Bits.FDATAHI11
#define FDATAHI_FDATAHI12               _FDATAHI.Bits.FDATAHI12
#define FDATAHI_FDATAHI13               _FDATAHI.Bits.FDATAHI13
#define FDATAHI_FDATAHI14               _FDATAHI.Bits.FDATAHI14
#define FDATAHI_FDATAHI15               _FDATAHI.Bits.FDATAHI15

#define FDATAHI_FDATAHI8_MASK           1U
#define FDATAHI_FDATAHI9_MASK           2U
#define FDATAHI_FDATAHI10_MASK          4U
#define FDATAHI_FDATAHI11_MASK          8U
#define FDATAHI_FDATAHI12_MASK          16U
#define FDATAHI_FDATAHI13_MASK          32U
#define FDATAHI_FDATAHI14_MASK          64U
#define FDATAHI_FDATAHI15_MASK          128U


/*** FDATALO - Flash Data Low Register; 0x0000010B ***/
typedef union {
  byte Byte;
  struct {
    byte FDATALO0    :1;                                       /* Flash Data Low Bit 0 */
    byte FDATALO1    :1;                                       /* Flash Data Low Bit 1 */
    byte FDATALO2    :1;                                       /* Flash Data Low Bit 2 */
    byte FDATALO3    :1;                                       /* Flash Data Low Bit 3 */
    byte FDATALO4    :1;                                       /* Flash Data Low Bit 4 */
    byte FDATALO5    :1;                                       /* Flash Data Low Bit 5 */
    byte FDATALO6    :1;                                       /* Flash Data Low Bit 6 */
    byte FDATALO7    :1;                                       /* Flash Data Low Bit 7 */
  } Bits;
} FDATALOSTR;
extern volatile FDATALOSTR _FDATALO @(REG_BASE + 0x0000010BUL);
#define FDATALO                         _FDATALO.Byte
#define FDATALO_FDATALO0                _FDATALO.Bits.FDATALO0
#define FDATALO_FDATALO1                _FDATALO.Bits.FDATALO1
#define FDATALO_FDATALO2                _FDATALO.Bits.FDATALO2
#define FDATALO_FDATALO3                _FDATALO.Bits.FDATALO3
#define FDATALO_FDATALO4                _FDATALO.Bits.FDATALO4
#define FDATALO_FDATALO5                _FDATALO.Bits.FDATALO5
#define FDATALO_FDATALO6                _FDATALO.Bits.FDATALO6
#define FDATALO_FDATALO7                _FDATALO.Bits.FDATALO7

#define FDATALO_FDATALO0_MASK           1U
#define FDATALO_FDATALO1_MASK           2U
#define FDATALO_FDATALO2_MASK           4U
#define FDATALO_FDATALO3_MASK           8U
#define FDATALO_FDATALO4_MASK           16U
#define FDATALO_FDATALO5_MASK           32U
#define FDATALO_FDATALO6_MASK           64U
#define FDATALO_FDATALO7_MASK           128U


/*** ECLKDIV - EEPROM Clock Divider Register; 0x00000110 ***/
typedef union {
  byte Byte;
  struct {
    byte EDIV0       :1;                                       /* EEPROM Clock Divider 0 */
    byte EDIV1       :1;                                       /* EEPROM Clock Divider 1 */
    byte EDIV2       :1;                                       /* EEPROM Clock Divider 2 */
    byte EDIV3       :1;                                       /* EEPROM Clock Divider 3 */
    byte EDIV4       :1;                                       /* EEPROM Clock Divider 4 */
    byte EDIV5       :1;                                       /* EEPROM Clock Divider 5 */
    byte PRDIV8      :1;                                       /* Enable Prescaler by 8 */
    byte EDIVLD      :1;                                       /* EEPROM Clock Divider Loaded */
  } Bits;
  struct {
    byte grpEDIV :6;
    byte grpPRDIV_8 :1;
    byte         :1;
  } MergedBits;
} ECLKDIVSTR;
extern volatile ECLKDIVSTR _ECLKDIV @(REG_BASE + 0x00000110UL);
#define ECLKDIV                         _ECLKDIV.Byte
#define ECLKDIV_EDIV0                   _ECLKDIV.Bits.EDIV0
#define ECLKDIV_EDIV1                   _ECLKDIV.Bits.EDIV1
#define ECLKDIV_EDIV2                   _ECLKDIV.Bits.EDIV2
#define ECLKDIV_EDIV3                   _ECLKDIV.Bits.EDIV3
#define ECLKDIV_EDIV4                   _ECLKDIV.Bits.EDIV4
#define ECLKDIV_EDIV5                   _ECLKDIV.Bits.EDIV5
#define ECLKDIV_PRDIV8                  _ECLKDIV.Bits.PRDIV8
#define ECLKDIV_EDIVLD                  _ECLKDIV.Bits.EDIVLD
#define ECLKDIV_EDIV                    _ECLKDIV.MergedBits.grpEDIV

#define ECLKDIV_EDIV0_MASK              1U
#define ECLKDIV_EDIV1_MASK              2U
#define ECLKDIV_EDIV2_MASK              4U
#define ECLKDIV_EDIV3_MASK              8U
#define ECLKDIV_EDIV4_MASK              16U
#define ECLKDIV_EDIV5_MASK              32U
#define ECLKDIV_PRDIV8_MASK             64U
#define ECLKDIV_EDIVLD_MASK             128U
#define ECLKDIV_EDIV_MASK               63U
#define ECLKDIV_EDIV_BITNUM             0U


/*** ECNFG - EEPROM Configuration Register; 0x00000113 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte CCIE        :1;                                       /* Command Complete Interrupt Enable */
    byte CBEIE       :1;                                       /* Command Buffers Empty Interrupt Enable */
  } Bits;
} ECNFGSTR;
extern volatile ECNFGSTR _ECNFG @(REG_BASE + 0x00000113UL);
#define ECNFG                           _ECNFG.Byte
#define ECNFG_CCIE                      _ECNFG.Bits.CCIE
#define ECNFG_CBEIE                     _ECNFG.Bits.CBEIE

#define ECNFG_CCIE_MASK                 64U
#define ECNFG_CBEIE_MASK                128U


/*** EPROT - EEPROM Protection Register; 0x00000114 ***/
typedef union {
  byte Byte;
  struct {
    byte EP0         :1;                                       /* EEPROM Protection address size 0 */
    byte EP1         :1;                                       /* EEPROM Protection address size 1 */
    byte EP2         :1;                                       /* EEPROM Protection address size 2 */
    byte EPDIS       :1;                                       /* EEPROM Protection disable */
    byte NV4         :1;                                       /* Non Volatile Flag Bit 4 */
    byte NV5         :1;                                       /* Non Volatile Flag Bit 5 */
    byte NV6         :1;                                       /* Non Volatile Flag Bit 6 */
    byte EPOPEN      :1;                                       /* Opens the EEPROM block or a subsection of it for program or erase */
  } Bits;
  struct {
    byte grpEP   :3;
    byte         :1;
    byte grpNV_4 :3;
    byte         :1;
  } MergedBits;
} EPROTSTR;
extern volatile EPROTSTR _EPROT @(REG_BASE + 0x00000114UL);
#define EPROT                           _EPROT.Byte
#define EPROT_EP0                       _EPROT.Bits.EP0
#define EPROT_EP1                       _EPROT.Bits.EP1
#define EPROT_EP2                       _EPROT.Bits.EP2
#define EPROT_EPDIS                     _EPROT.Bits.EPDIS
#define EPROT_NV4                       _EPROT.Bits.NV4
#define EPROT_NV5                       _EPROT.Bits.NV5
#define EPROT_NV6                       _EPROT.Bits.NV6
#define EPROT_EPOPEN                    _EPROT.Bits.EPOPEN
#define EPROT_EP                        _EPROT.MergedBits.grpEP
#define EPROT_NV_4                      _EPROT.MergedBits.grpNV_4
#define EPROT_NV                        EPROT_NV_4

#define EPROT_EP0_MASK                  1U
#define EPROT_EP1_MASK                  2U
#define EPROT_EP2_MASK                  4U
#define EPROT_EPDIS_MASK                8U
#define EPROT_NV4_MASK                  16U
#define EPROT_NV5_MASK                  32U
#define EPROT_NV6_MASK                  64U
#define EPROT_EPOPEN_MASK               128U
#define EPROT_EP_MASK                   7U
#define EPROT_EP_BITNUM                 0U
#define EPROT_NV_4_MASK                 112U
#define EPROT_NV_4_BITNUM               4U


/*** ESTAT - EEPROM Status Register; 0x00000115 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte BLANK       :1;                                       /* Blank Verify Flag */
    byte             :1; 
    byte ACCERR      :1;                                       /* Access error */
    byte PVIOL       :1;                                       /* Protection violation */
    byte CCIF        :1;                                       /* Command Complete Interrupt Flag */
    byte CBEIF       :1;                                       /* Command Buffer Empty Interrupt Flag */
  } Bits;
} ESTATSTR;
extern volatile ESTATSTR _ESTAT @(REG_BASE + 0x00000115UL);
#define ESTAT                           _ESTAT.Byte
#define ESTAT_BLANK                     _ESTAT.Bits.BLANK
#define ESTAT_ACCERR                    _ESTAT.Bits.ACCERR
#define ESTAT_PVIOL                     _ESTAT.Bits.PVIOL
#define ESTAT_CCIF                      _ESTAT.Bits.CCIF
#define ESTAT_CBEIF                     _ESTAT.Bits.CBEIF

#define ESTAT_BLANK_MASK                4U
#define ESTAT_ACCERR_MASK               16U
#define ESTAT_PVIOL_MASK                32U
#define ESTAT_CCIF_MASK                 64U
#define ESTAT_CBEIF_MASK                128U


/*** ECMD - EEPROM Command Buffer and Register; 0x00000116 ***/
typedef union {
  byte Byte;
  struct {
    byte CMDB0       :1;                                       /* EEPROM User Mode Command 0 */
    byte             :1; 
    byte CMDB2       :1;                                       /* EEPROM User Mode Command 2 */
    byte             :1; 
    byte             :1; 
    byte CMDB5       :1;                                       /* EEPROM User Mode Command 5 */
    byte CMDB6       :1;                                       /* EEPROM User Mode Command 6 */
    byte             :1; 
  } Bits;
  struct {
    byte grpCMDB :1;
    byte         :1;
    byte grpCMDB_2 :1;
    byte         :1;
    byte         :1;
    byte grpCMDB_5 :2;
    byte         :1;
  } MergedBits;
} ECMDSTR;
extern volatile ECMDSTR _ECMD @(REG_BASE + 0x00000116UL);
#define ECMD                            _ECMD.Byte
#define ECMD_CMDB0                      _ECMD.Bits.CMDB0
#define ECMD_CMDB2                      _ECMD.Bits.CMDB2
#define ECMD_CMDB5                      _ECMD.Bits.CMDB5
#define ECMD_CMDB6                      _ECMD.Bits.CMDB6
#define ECMD_CMDB_5                     _ECMD.MergedBits.grpCMDB_5
#define ECMD_CMDB                       ECMD_CMDB_5

#define ECMD_CMDB0_MASK                 1U
#define ECMD_CMDB2_MASK                 4U
#define ECMD_CMDB5_MASK                 32U
#define ECMD_CMDB6_MASK                 64U
#define ECMD_CMDB_5_MASK                96U
#define ECMD_CMDB_5_BITNUM              5U


/*** LCDCR0 - LCD Control Register 0; 0x00000120 ***/
typedef union {
  byte Byte;
  struct {
    byte DUTY0       :1;                                       /* LCD Duty Select Bit 0 */
    byte DUTY1       :1;                                       /* LCD Duty Select Bit 1 */
    byte BIAS        :1;                                       /* BIAS Voltage Level Select */
    byte LCLK0       :1;                                       /* LCD Clock Prescaler Bit 0 */
    byte LCLK1       :1;                                       /* LCD Clock Prescaler Bit 1 */
    byte LCLK2       :1;                                       /* LCD Clock Prescaler Bit 2 */
    byte             :1; 
    byte LCDEN       :1;                                       /* LCD32F4B Driver System Enable */
  } Bits;
  struct {
    byte grpDUTY :2;
    byte         :1;
    byte grpLCLK :3;
    byte         :1;
    byte         :1;
  } MergedBits;
} LCDCR0STR;
extern volatile LCDCR0STR _LCDCR0 @(REG_BASE + 0x00000120UL);
#define LCDCR0                          _LCDCR0.Byte
#define LCDCR0_DUTY0                    _LCDCR0.Bits.DUTY0
#define LCDCR0_DUTY1                    _LCDCR0.Bits.DUTY1
#define LCDCR0_BIAS                     _LCDCR0.Bits.BIAS
#define LCDCR0_LCLK0                    _LCDCR0.Bits.LCLK0
#define LCDCR0_LCLK1                    _LCDCR0.Bits.LCLK1
#define LCDCR0_LCLK2                    _LCDCR0.Bits.LCLK2
#define LCDCR0_LCDEN                    _LCDCR0.Bits.LCDEN
/* LCDCR_ARR: Access 2 LCDCRx registers in an array */
#define LCDCR_ARR                       ((volatile byte *) &LCDCR0)
#define LCDCR0_DUTY                     _LCDCR0.MergedBits.grpDUTY
#define LCDCR0_LCLK                     _LCDCR0.MergedBits.grpLCLK

#define LCDCR0_DUTY0_MASK               1U
#define LCDCR0_DUTY1_MASK               2U
#define LCDCR0_BIAS_MASK                4U
#define LCDCR0_LCLK0_MASK               8U
#define LCDCR0_LCLK1_MASK               16U
#define LCDCR0_LCLK2_MASK               32U
#define LCDCR0_LCDEN_MASK               128U
#define LCDCR0_DUTY_MASK                3U
#define LCDCR0_DUTY_BITNUM              0U
#define LCDCR0_LCLK_MASK                56U
#define LCDCR0_LCLK_BITNUM              3U


/*** LCDCR1 - LCD Control Register 1; 0x00000121 ***/
typedef union {
  byte Byte;
  struct {
    byte LCDRPSTP    :1;                                       /* LCD Run in Pseudo STOP Mode */
    byte LCDSWAI     :1;                                       /* LCD Stop in Wait Mode */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} LCDCR1STR;
extern volatile LCDCR1STR _LCDCR1 @(REG_BASE + 0x00000121UL);
#define LCDCR1                          _LCDCR1.Byte
#define LCDCR1_LCDRPSTP                 _LCDCR1.Bits.LCDRPSTP
#define LCDCR1_LCDSWAI                  _LCDCR1.Bits.LCDSWAI

#define LCDCR1_LCDRPSTP_MASK            1U
#define LCDCR1_LCDSWAI_MASK             2U


/*** FPENR0 - LCD Frontplane Enable Register 0; 0x00000122 ***/
typedef union {
  byte Byte;
  struct {
    byte FP0EN       :1;                                       /* Frontplane Output Enable Bit 0 */
    byte FP1EN       :1;                                       /* Frontplane Output Enable Bit 1 */
    byte FP2EN       :1;                                       /* Frontplane Output Enable Bit 2 */
    byte FP3EN       :1;                                       /* Frontplane Output Enable Bit 3 */
    byte FP4EN       :1;                                       /* Frontplane Output Enable Bit 4 */
    byte FP5EN       :1;                                       /* Frontplane Output Enable Bit 5 */
    byte FP6EN       :1;                                       /* Frontplane Output Enable Bit 6 */
    byte FP7EN       :1;                                       /* Frontplane Output Enable Bit 7 */
  } Bits;
} FPENR0STR;
extern volatile FPENR0STR _FPENR0 @(REG_BASE + 0x00000122UL);
#define FPENR0                          _FPENR0.Byte
#define FPENR0_FP0EN                    _FPENR0.Bits.FP0EN
#define FPENR0_FP1EN                    _FPENR0.Bits.FP1EN
#define FPENR0_FP2EN                    _FPENR0.Bits.FP2EN
#define FPENR0_FP3EN                    _FPENR0.Bits.FP3EN
#define FPENR0_FP4EN                    _FPENR0.Bits.FP4EN
#define FPENR0_FP5EN                    _FPENR0.Bits.FP5EN
#define FPENR0_FP6EN                    _FPENR0.Bits.FP6EN
#define FPENR0_FP7EN                    _FPENR0.Bits.FP7EN
/* FPENR_ARR: Access 4 FPENRx registers in an array */
#define FPENR_ARR                       ((volatile byte *) &FPENR0)

#define FPENR0_FP0EN_MASK               1U
#define FPENR0_FP1EN_MASK               2U
#define FPENR0_FP2EN_MASK               4U
#define FPENR0_FP3EN_MASK               8U
#define FPENR0_FP4EN_MASK               16U
#define FPENR0_FP5EN_MASK               32U
#define FPENR0_FP6EN_MASK               64U
#define FPENR0_FP7EN_MASK               128U


/*** FPENR1 - LCD Frontplane Enable Register 1; 0x00000123 ***/
typedef union {
  byte Byte;
  struct {
    byte FP8EN       :1;                                       /* Frontplane Output Enable Bit 8 */
    byte FP9EN       :1;                                       /* Frontplane Output Enable Bit 9 */
    byte FP10EN      :1;                                       /* Frontplane Output Enable Bit 10 */
    byte FP11EN      :1;                                       /* Frontplane Output Enable Bit 11 */
    byte FP12EN      :1;                                       /* Frontplane Output Enable Bit 12 */
    byte FP13EN      :1;                                       /* Frontplane Output Enable Bit 13 */
    byte FP14EN      :1;                                       /* Frontplane Output Enable Bit 14 */
    byte FP15EN      :1;                                       /* Frontplane Output Enable Bit 15 */
  } Bits;
} FPENR1STR;
extern volatile FPENR1STR _FPENR1 @(REG_BASE + 0x00000123UL);
#define FPENR1                          _FPENR1.Byte
#define FPENR1_FP8EN                    _FPENR1.Bits.FP8EN
#define FPENR1_FP9EN                    _FPENR1.Bits.FP9EN
#define FPENR1_FP10EN                   _FPENR1.Bits.FP10EN
#define FPENR1_FP11EN                   _FPENR1.Bits.FP11EN
#define FPENR1_FP12EN                   _FPENR1.Bits.FP12EN
#define FPENR1_FP13EN                   _FPENR1.Bits.FP13EN
#define FPENR1_FP14EN                   _FPENR1.Bits.FP14EN
#define FPENR1_FP15EN                   _FPENR1.Bits.FP15EN

#define FPENR1_FP8EN_MASK               1U
#define FPENR1_FP9EN_MASK               2U
#define FPENR1_FP10EN_MASK              4U
#define FPENR1_FP11EN_MASK              8U
#define FPENR1_FP12EN_MASK              16U
#define FPENR1_FP13EN_MASK              32U
#define FPENR1_FP14EN_MASK              64U
#define FPENR1_FP15EN_MASK              128U


/*** FPENR2 - LCD Frontplane Enable Register 2; 0x00000124 ***/
typedef union {
  byte Byte;
  struct {
    byte FP16EN      :1;                                       /* Frontplane Output Enable Bit 16 */
    byte FP17EN      :1;                                       /* Frontplane Output Enable Bit 17 */
    byte FP18EN      :1;                                       /* Frontplane Output Enable Bit 18 */
    byte FP19EN      :1;                                       /* Frontplane Output Enable Bit 19 */
    byte FP20EN      :1;                                       /* Frontplane Output Enable Bit 20 */
    byte FP21EN      :1;                                       /* Frontplane Output Enable Bit 21 */
    byte FP22EN      :1;                                       /* Frontplane Output Enable Bit 22 */
    byte FP23EN      :1;                                       /* Frontplane Output Enable Bit 23 */
  } Bits;
} FPENR2STR;
extern volatile FPENR2STR _FPENR2 @(REG_BASE + 0x00000124UL);
#define FPENR2                          _FPENR2.Byte
#define FPENR2_FP16EN                   _FPENR2.Bits.FP16EN
#define FPENR2_FP17EN                   _FPENR2.Bits.FP17EN
#define FPENR2_FP18EN                   _FPENR2.Bits.FP18EN
#define FPENR2_FP19EN                   _FPENR2.Bits.FP19EN
#define FPENR2_FP20EN                   _FPENR2.Bits.FP20EN
#define FPENR2_FP21EN                   _FPENR2.Bits.FP21EN
#define FPENR2_FP22EN                   _FPENR2.Bits.FP22EN
#define FPENR2_FP23EN                   _FPENR2.Bits.FP23EN

#define FPENR2_FP16EN_MASK              1U
#define FPENR2_FP17EN_MASK              2U
#define FPENR2_FP18EN_MASK              4U
#define FPENR2_FP19EN_MASK              8U
#define FPENR2_FP20EN_MASK              16U
#define FPENR2_FP21EN_MASK              32U
#define FPENR2_FP22EN_MASK              64U
#define FPENR2_FP23EN_MASK              128U


/*** FPENR3 - LCD Frontplane Enable Register 3; 0x00000125 ***/
typedef union {
  byte Byte;
  struct {
    byte FP24EN      :1;                                       /* Frontplane Output Enable Bit 24 */
    byte FP25EN      :1;                                       /* Frontplane Output Enable Bit 25 */
    byte FP26EN      :1;                                       /* Frontplane Output Enable Bit 26 */
    byte FP27EN      :1;                                       /* Frontplane Output Enable Bit 27 */
    byte FP28EN      :1;                                       /* Frontplane Output Enable Bit 28 */
    byte FP29EN      :1;                                       /* Frontplane Output Enable Bit 29 */
    byte FP30EN      :1;                                       /* Frontplane Output Enable Bit 30 */
    byte FP31EN      :1;                                       /* Frontplane Output Enable Bit 31 */
  } Bits;
} FPENR3STR;
extern volatile FPENR3STR _FPENR3 @(REG_BASE + 0x00000125UL);
#define FPENR3                          _FPENR3.Byte
#define FPENR3_FP24EN                   _FPENR3.Bits.FP24EN
#define FPENR3_FP25EN                   _FPENR3.Bits.FP25EN
#define FPENR3_FP26EN                   _FPENR3.Bits.FP26EN
#define FPENR3_FP27EN                   _FPENR3.Bits.FP27EN
#define FPENR3_FP28EN                   _FPENR3.Bits.FP28EN
#define FPENR3_FP29EN                   _FPENR3.Bits.FP29EN
#define FPENR3_FP30EN                   _FPENR3.Bits.FP30EN
#define FPENR3_FP31EN                   _FPENR3.Bits.FP31EN

#define FPENR3_FP24EN_MASK              1U
#define FPENR3_FP25EN_MASK              2U
#define FPENR3_FP26EN_MASK              4U
#define FPENR3_FP27EN_MASK              8U
#define FPENR3_FP28EN_MASK              16U
#define FPENR3_FP29EN_MASK              32U
#define FPENR3_FP30EN_MASK              64U
#define FPENR3_FP31EN_MASK              128U


/*** LCDRAM0 - LCD RAM Register 0; 0x00000128 ***/
typedef union {
  byte Byte;
  struct {
    byte FP0BP0      :1;                                       /* LCD Segment FP0, BP0 ON */
    byte FP0BP1      :1;                                       /* LCD Segment FP0, BP1 ON */
    byte FP0BP2      :1;                                       /* LCD Segment FP0, BP2 ON */
    byte FP0BP3      :1;                                       /* LCD Segment FP0, BP3 ON */
    byte FP1BP0      :1;                                       /* LCD Segment FP1, BP0 ON */
    byte FP1BP1      :1;                                       /* LCD Segment FP1, BP1 ON */
    byte FP1BP2      :1;                                       /* LCD Segment FP1, BP2 ON */
    byte FP1BP3      :1;                                       /* LCD Segment FP1, BP3 ON */
  } Bits;
  struct {
    byte grpFP0BP :4;
    byte grpFP1BP :4;
  } MergedBits;
} LCDRAM0STR;
extern volatile LCDRAM0STR _LCDRAM0 @(REG_BASE + 0x00000128UL);
#define LCDRAM0                         _LCDRAM0.Byte
#define LCDRAM0_FP0BP0                  _LCDRAM0.Bits.FP0BP0
#define LCDRAM0_FP0BP1                  _LCDRAM0.Bits.FP0BP1
#define LCDRAM0_FP0BP2                  _LCDRAM0.Bits.FP0BP2
#define LCDRAM0_FP0BP3                  _LCDRAM0.Bits.FP0BP3
#define LCDRAM0_FP1BP0                  _LCDRAM0.Bits.FP1BP0
#define LCDRAM0_FP1BP1                  _LCDRAM0.Bits.FP1BP1
#define LCDRAM0_FP1BP2                  _LCDRAM0.Bits.FP1BP2
#define LCDRAM0_FP1BP3                  _LCDRAM0.Bits.FP1BP3
/* LCDRAM_ARR: Access 16 LCDRAMx registers in an array */
#define LCDRAM_ARR                      ((volatile byte *) &LCDRAM0)
#define LCDRAM0_FP0BP                   _LCDRAM0.MergedBits.grpFP0BP
#define LCDRAM0_FP1BP                   _LCDRAM0.MergedBits.grpFP1BP

#define LCDRAM0_FP0BP0_MASK             1U
#define LCDRAM0_FP0BP1_MASK             2U
#define LCDRAM0_FP0BP2_MASK             4U
#define LCDRAM0_FP0BP3_MASK             8U
#define LCDRAM0_FP1BP0_MASK             16U
#define LCDRAM0_FP1BP1_MASK             32U
#define LCDRAM0_FP1BP2_MASK             64U
#define LCDRAM0_FP1BP3_MASK             128U
#define LCDRAM0_FP0BP_MASK              15U
#define LCDRAM0_FP0BP_BITNUM            0U
#define LCDRAM0_FP1BP_MASK              240U
#define LCDRAM0_FP1BP_BITNUM            4U


/*** LCDRAM1 - LCD RAM Register 1; 0x00000129 ***/
typedef union {
  byte Byte;
  struct {
    byte FP2BP0      :1;                                       /* LCD Segment FP2, BP0 ON */
    byte FP2BP1      :1;                                       /* LCD Segment FP2, BP1 ON */
    byte FP2BP2      :1;                                       /* LCD Segment FP2, BP2 ON */
    byte FP2BP3      :1;                                       /* LCD Segment FP2, BP3 ON */
    byte FP3BP0      :1;                                       /* LCD Segment FP3, BP0 ON */
    byte FP3BP1      :1;                                       /* LCD Segment FP3, BP1 ON */
    byte FP3BP2      :1;                                       /* LCD Segment FP3, BP2 ON */
    byte FP3BP3      :1;                                       /* LCD Segment FP3, BP3 ON */
  } Bits;
  struct {
    byte grpFP2BP :4;
    byte grpFP3BP :4;
  } MergedBits;
} LCDRAM1STR;
extern volatile LCDRAM1STR _LCDRAM1 @(REG_BASE + 0x00000129UL);
#define LCDRAM1                         _LCDRAM1.Byte
#define LCDRAM1_FP2BP0                  _LCDRAM1.Bits.FP2BP0
#define LCDRAM1_FP2BP1                  _LCDRAM1.Bits.FP2BP1
#define LCDRAM1_FP2BP2                  _LCDRAM1.Bits.FP2BP2
#define LCDRAM1_FP2BP3                  _LCDRAM1.Bits.FP2BP3
#define LCDRAM1_FP3BP0                  _LCDRAM1.Bits.FP3BP0
#define LCDRAM1_FP3BP1                  _LCDRAM1.Bits.FP3BP1
#define LCDRAM1_FP3BP2                  _LCDRAM1.Bits.FP3BP2
#define LCDRAM1_FP3BP3                  _LCDRAM1.Bits.FP3BP3
#define LCDRAM1_FP2BP                   _LCDRAM1.MergedBits.grpFP2BP
#define LCDRAM1_FP3BP                   _LCDRAM1.MergedBits.grpFP3BP

#define LCDRAM1_FP2BP0_MASK             1U
#define LCDRAM1_FP2BP1_MASK             2U
#define LCDRAM1_FP2BP2_MASK             4U
#define LCDRAM1_FP2BP3_MASK             8U
#define LCDRAM1_FP3BP0_MASK             16U
#define LCDRAM1_FP3BP1_MASK             32U
#define LCDRAM1_FP3BP2_MASK             64U
#define LCDRAM1_FP3BP3_MASK             128U
#define LCDRAM1_FP2BP_MASK              15U
#define LCDRAM1_FP2BP_BITNUM            0U
#define LCDRAM1_FP3BP_MASK              240U
#define LCDRAM1_FP3BP_BITNUM            4U


/*** LCDRAM2 - LCD RAM Register 2; 0x0000012A ***/
typedef union {
  byte Byte;
  struct {
    byte FP4BP0      :1;                                       /* LCD Segment FP4, BP0 ON */
    byte FP4BP1      :1;                                       /* LCD Segment FP4, BP1 ON */
    byte FP4BP2      :1;                                       /* LCD Segment FP4, BP2 ON */
    byte FP4BP3      :1;                                       /* LCD Segment FP4, BP3 ON */
    byte FP5BP0      :1;                                       /* LCD Segment FP5, BP0 ON */
    byte FP5BP1      :1;                                       /* LCD Segment FP5, BP1 ON */
    byte FP5BP2      :1;                                       /* LCD Segment FP5, BP2 ON */
    byte FP5BP3      :1;                                       /* LCD Segment FP5, BP3 ON */
  } Bits;
  struct {
    byte grpFP4BP :4;
    byte grpFP5BP :4;
  } MergedBits;
} LCDRAM2STR;
extern volatile LCDRAM2STR _LCDRAM2 @(REG_BASE + 0x0000012AUL);
#define LCDRAM2                         _LCDRAM2.Byte
#define LCDRAM2_FP4BP0                  _LCDRAM2.Bits.FP4BP0
#define LCDRAM2_FP4BP1                  _LCDRAM2.Bits.FP4BP1
#define LCDRAM2_FP4BP2                  _LCDRAM2.Bits.FP4BP2
#define LCDRAM2_FP4BP3                  _LCDRAM2.Bits.FP4BP3
#define LCDRAM2_FP5BP0                  _LCDRAM2.Bits.FP5BP0
#define LCDRAM2_FP5BP1                  _LCDRAM2.Bits.FP5BP1
#define LCDRAM2_FP5BP2                  _LCDRAM2.Bits.FP5BP2
#define LCDRAM2_FP5BP3                  _LCDRAM2.Bits.FP5BP3
#define LCDRAM2_FP4BP                   _LCDRAM2.MergedBits.grpFP4BP
#define LCDRAM2_FP5BP                   _LCDRAM2.MergedBits.grpFP5BP

#define LCDRAM2_FP4BP0_MASK             1U
#define LCDRAM2_FP4BP1_MASK             2U
#define LCDRAM2_FP4BP2_MASK             4U
#define LCDRAM2_FP4BP3_MASK             8U
#define LCDRAM2_FP5BP0_MASK             16U
#define LCDRAM2_FP5BP1_MASK             32U
#define LCDRAM2_FP5BP2_MASK             64U
#define LCDRAM2_FP5BP3_MASK             128U
#define LCDRAM2_FP4BP_MASK              15U
#define LCDRAM2_FP4BP_BITNUM            0U
#define LCDRAM2_FP5BP_MASK              240U
#define LCDRAM2_FP5BP_BITNUM            4U


/*** LCDRAM3 - LCD RAM Register 3; 0x0000012B ***/
typedef union {
  byte Byte;
  struct {
    byte FP6BP0      :1;                                       /* LCD Segment FP6, BP0 ON */
    byte FP6BP1      :1;                                       /* LCD Segment FP6, BP1 ON */
    byte FP6BP2      :1;                                       /* LCD Segment FP6, BP2 ON */
    byte FP6BP3      :1;                                       /* LCD Segment FP6, BP3 ON */
    byte FP7BP0      :1;                                       /* LCD Segment FP7, BP0 ON */
    byte FP7BP1      :1;                                       /* LCD Segment FP7, BP1 ON */
    byte FP7BP2      :1;                                       /* LCD Segment FP7, BP2 ON */
    byte FP7BP3      :1;                                       /* LCD Segment FP7, BP3 ON */
  } Bits;
  struct {
    byte grpFP6BP :4;
    byte grpFP7BP :4;
  } MergedBits;
} LCDRAM3STR;
extern volatile LCDRAM3STR _LCDRAM3 @(REG_BASE + 0x0000012BUL);
#define LCDRAM3                         _LCDRAM3.Byte
#define LCDRAM3_FP6BP0                  _LCDRAM3.Bits.FP6BP0
#define LCDRAM3_FP6BP1                  _LCDRAM3.Bits.FP6BP1
#define LCDRAM3_FP6BP2                  _LCDRAM3.Bits.FP6BP2
#define LCDRAM3_FP6BP3                  _LCDRAM3.Bits.FP6BP3
#define LCDRAM3_FP7BP0                  _LCDRAM3.Bits.FP7BP0
#define LCDRAM3_FP7BP1                  _LCDRAM3.Bits.FP7BP1
#define LCDRAM3_FP7BP2                  _LCDRAM3.Bits.FP7BP2
#define LCDRAM3_FP7BP3                  _LCDRAM3.Bits.FP7BP3
#define LCDRAM3_FP6BP                   _LCDRAM3.MergedBits.grpFP6BP
#define LCDRAM3_FP7BP                   _LCDRAM3.MergedBits.grpFP7BP

#define LCDRAM3_FP6BP0_MASK             1U
#define LCDRAM3_FP6BP1_MASK             2U
#define LCDRAM3_FP6BP2_MASK             4U
#define LCDRAM3_FP6BP3_MASK             8U
#define LCDRAM3_FP7BP0_MASK             16U
#define LCDRAM3_FP7BP1_MASK             32U
#define LCDRAM3_FP7BP2_MASK             64U
#define LCDRAM3_FP7BP3_MASK             128U
#define LCDRAM3_FP6BP_MASK              15U
#define LCDRAM3_FP6BP_BITNUM            0U
#define LCDRAM3_FP7BP_MASK              240U
#define LCDRAM3_FP7BP_BITNUM            4U


/*** LCDRAM4 - LCD RAM Register 4; 0x0000012C ***/
typedef union {
  byte Byte;
  struct {
    byte FP8BP0      :1;                                       /* LCD Segment FP8, BP0 ON */
    byte FP8BP1      :1;                                       /* LCD Segment FP8, BP1 ON */
    byte FP8BP2      :1;                                       /* LCD Segment FP8, BP2 ON */
    byte FP8BP3      :1;                                       /* LCD Segment FP8, BP3 ON */
    byte FP9BP0      :1;                                       /* LCD Segment FP9, BP0 ON */
    byte FP9BP1      :1;                                       /* LCD Segment FP9, BP1 ON */
    byte FP9BP2      :1;                                       /* LCD Segment FP9, BP2 ON */
    byte FP9BP3      :1;                                       /* LCD Segment FP9, BP3 ON */
  } Bits;
  struct {
    byte grpFP8BP :4;
    byte grpFP9BP :4;
  } MergedBits;
} LCDRAM4STR;
extern volatile LCDRAM4STR _LCDRAM4 @(REG_BASE + 0x0000012CUL);
#define LCDRAM4                         _LCDRAM4.Byte
#define LCDRAM4_FP8BP0                  _LCDRAM4.Bits.FP8BP0
#define LCDRAM4_FP8BP1                  _LCDRAM4.Bits.FP8BP1
#define LCDRAM4_FP8BP2                  _LCDRAM4.Bits.FP8BP2
#define LCDRAM4_FP8BP3                  _LCDRAM4.Bits.FP8BP3
#define LCDRAM4_FP9BP0                  _LCDRAM4.Bits.FP9BP0
#define LCDRAM4_FP9BP1                  _LCDRAM4.Bits.FP9BP1
#define LCDRAM4_FP9BP2                  _LCDRAM4.Bits.FP9BP2
#define LCDRAM4_FP9BP3                  _LCDRAM4.Bits.FP9BP3
#define LCDRAM4_FP8BP                   _LCDRAM4.MergedBits.grpFP8BP
#define LCDRAM4_FP9BP                   _LCDRAM4.MergedBits.grpFP9BP

#define LCDRAM4_FP8BP0_MASK             1U
#define LCDRAM4_FP8BP1_MASK             2U
#define LCDRAM4_FP8BP2_MASK             4U
#define LCDRAM4_FP8BP3_MASK             8U
#define LCDRAM4_FP9BP0_MASK             16U
#define LCDRAM4_FP9BP1_MASK             32U
#define LCDRAM4_FP9BP2_MASK             64U
#define LCDRAM4_FP9BP3_MASK             128U
#define LCDRAM4_FP8BP_MASK              15U
#define LCDRAM4_FP8BP_BITNUM            0U
#define LCDRAM4_FP9BP_MASK              240U
#define LCDRAM4_FP9BP_BITNUM            4U


/*** LCDRAM5 - LCD RAM Register 5; 0x0000012D ***/
typedef union {
  byte Byte;
  struct {
    byte FP10BP0     :1;                                       /* LCD Segment FP10, BP0 ON */
    byte FP10BP1     :1;                                       /* LCD Segment FP10, BP1 ON */
    byte FP10BP2     :1;                                       /* LCD Segment FP10, BP2 ON */
    byte FP10BP3     :1;                                       /* LCD Segment FP10, BP3 ON */
    byte FP11BP0     :1;                                       /* LCD Segment FP11, BP0 ON */
    byte FP11BP1     :1;                                       /* LCD Segment FP11, BP1 ON */
    byte FP11BP2     :1;                                       /* LCD Segment FP11, BP2 ON */
    byte FP11BP3     :1;                                       /* LCD Segment FP11, BP3 ON */
  } Bits;
  struct {
    byte grpFP10BP :4;
    byte grpFP11BP :4;
  } MergedBits;
} LCDRAM5STR;
extern volatile LCDRAM5STR _LCDRAM5 @(REG_BASE + 0x0000012DUL);
#define LCDRAM5                         _LCDRAM5.Byte
#define LCDRAM5_FP10BP0                 _LCDRAM5.Bits.FP10BP0
#define LCDRAM5_FP10BP1                 _LCDRAM5.Bits.FP10BP1
#define LCDRAM5_FP10BP2                 _LCDRAM5.Bits.FP10BP2
#define LCDRAM5_FP10BP3                 _LCDRAM5.Bits.FP10BP3
#define LCDRAM5_FP11BP0                 _LCDRAM5.Bits.FP11BP0
#define LCDRAM5_FP11BP1                 _LCDRAM5.Bits.FP11BP1
#define LCDRAM5_FP11BP2                 _LCDRAM5.Bits.FP11BP2
#define LCDRAM5_FP11BP3                 _LCDRAM5.Bits.FP11BP3
#define LCDRAM5_FP10BP                  _LCDRAM5.MergedBits.grpFP10BP
#define LCDRAM5_FP11BP                  _LCDRAM5.MergedBits.grpFP11BP

#define LCDRAM5_FP10BP0_MASK            1U
#define LCDRAM5_FP10BP1_MASK            2U
#define LCDRAM5_FP10BP2_MASK            4U
#define LCDRAM5_FP10BP3_MASK            8U
#define LCDRAM5_FP11BP0_MASK            16U
#define LCDRAM5_FP11BP1_MASK            32U
#define LCDRAM5_FP11BP2_MASK            64U
#define LCDRAM5_FP11BP3_MASK            128U
#define LCDRAM5_FP10BP_MASK             15U
#define LCDRAM5_FP10BP_BITNUM           0U
#define LCDRAM5_FP11BP_MASK             240U
#define LCDRAM5_FP11BP_BITNUM           4U


/*** LCDRAM6 - LCD RAM Register 6; 0x0000012E ***/
typedef union {
  byte Byte;
  struct {
    byte FP12BP0     :1;                                       /* LCD Segment FP12, BP0 ON */
    byte FP12BP1     :1;                                       /* LCD Segment FP12, BP1 ON */
    byte FP12BP2     :1;                                       /* LCD Segment FP12, BP2 ON */
    byte FP12BP3     :1;                                       /* LCD Segment FP12, BP3 ON */
    byte FP13BP0     :1;                                       /* LCD Segment FP13, BP0 ON */
    byte FP13BP1     :1;                                       /* LCD Segment FP13, BP1 ON */
    byte FP13BP2     :1;                                       /* LCD Segment FP13, BP2 ON */
    byte FP13BP3     :1;                                       /* LCD Segment FP13, BP3 ON */
  } Bits;
  struct {
    byte grpFP12BP :4;
    byte grpFP13BP :4;
  } MergedBits;
} LCDRAM6STR;
extern volatile LCDRAM6STR _LCDRAM6 @(REG_BASE + 0x0000012EUL);
#define LCDRAM6                         _LCDRAM6.Byte
#define LCDRAM6_FP12BP0                 _LCDRAM6.Bits.FP12BP0
#define LCDRAM6_FP12BP1                 _LCDRAM6.Bits.FP12BP1
#define LCDRAM6_FP12BP2                 _LCDRAM6.Bits.FP12BP2
#define LCDRAM6_FP12BP3                 _LCDRAM6.Bits.FP12BP3
#define LCDRAM6_FP13BP0                 _LCDRAM6.Bits.FP13BP0
#define LCDRAM6_FP13BP1                 _LCDRAM6.Bits.FP13BP1
#define LCDRAM6_FP13BP2                 _LCDRAM6.Bits.FP13BP2
#define LCDRAM6_FP13BP3                 _LCDRAM6.Bits.FP13BP3
#define LCDRAM6_FP12BP                  _LCDRAM6.MergedBits.grpFP12BP
#define LCDRAM6_FP13BP                  _LCDRAM6.MergedBits.grpFP13BP

#define LCDRAM6_FP12BP0_MASK            1U
#define LCDRAM6_FP12BP1_MASK            2U
#define LCDRAM6_FP12BP2_MASK            4U
#define LCDRAM6_FP12BP3_MASK            8U
#define LCDRAM6_FP13BP0_MASK            16U
#define LCDRAM6_FP13BP1_MASK            32U
#define LCDRAM6_FP13BP2_MASK            64U
#define LCDRAM6_FP13BP3_MASK            128U
#define LCDRAM6_FP12BP_MASK             15U
#define LCDRAM6_FP12BP_BITNUM           0U
#define LCDRAM6_FP13BP_MASK             240U
#define LCDRAM6_FP13BP_BITNUM           4U


/*** LCDRAM7 - LCD RAM Register 7; 0x0000012F ***/
typedef union {
  byte Byte;
  struct {
    byte FP14BP0     :1;                                       /* LCD Segment FP14, BP0 ON */
    byte FP14BP1     :1;                                       /* LCD Segment FP14, BP1 ON */
    byte FP14BP2     :1;                                       /* LCD Segment FP14, BP2 ON */
    byte FP14BP3     :1;                                       /* LCD Segment FP14, BP3 ON */
    byte FP15BP0     :1;                                       /* LCD Segment FP15, BP0 ON */
    byte FP15BP1     :1;                                       /* LCD Segment FP15, BP1 ON */
    byte FP15BP2     :1;                                       /* LCD Segment FP15, BP2 ON */
    byte FP15BP3     :1;                                       /* LCD Segment FP15, BP3 ON */
  } Bits;
  struct {
    byte grpFP14BP :4;
    byte grpFP15BP :4;
  } MergedBits;
} LCDRAM7STR;
extern volatile LCDRAM7STR _LCDRAM7 @(REG_BASE + 0x0000012FUL);
#define LCDRAM7                         _LCDRAM7.Byte
#define LCDRAM7_FP14BP0                 _LCDRAM7.Bits.FP14BP0
#define LCDRAM7_FP14BP1                 _LCDRAM7.Bits.FP14BP1
#define LCDRAM7_FP14BP2                 _LCDRAM7.Bits.FP14BP2
#define LCDRAM7_FP14BP3                 _LCDRAM7.Bits.FP14BP3
#define LCDRAM7_FP15BP0                 _LCDRAM7.Bits.FP15BP0
#define LCDRAM7_FP15BP1                 _LCDRAM7.Bits.FP15BP1
#define LCDRAM7_FP15BP2                 _LCDRAM7.Bits.FP15BP2
#define LCDRAM7_FP15BP3                 _LCDRAM7.Bits.FP15BP3
#define LCDRAM7_FP14BP                  _LCDRAM7.MergedBits.grpFP14BP
#define LCDRAM7_FP15BP                  _LCDRAM7.MergedBits.grpFP15BP

#define LCDRAM7_FP14BP0_MASK            1U
#define LCDRAM7_FP14BP1_MASK            2U
#define LCDRAM7_FP14BP2_MASK            4U
#define LCDRAM7_FP14BP3_MASK            8U
#define LCDRAM7_FP15BP0_MASK            16U
#define LCDRAM7_FP15BP1_MASK            32U
#define LCDRAM7_FP15BP2_MASK            64U
#define LCDRAM7_FP15BP3_MASK            128U
#define LCDRAM7_FP14BP_MASK             15U
#define LCDRAM7_FP14BP_BITNUM           0U
#define LCDRAM7_FP15BP_MASK             240U
#define LCDRAM7_FP15BP_BITNUM           4U


/*** LCDRAM8 - LCD RAM Register 8; 0x00000130 ***/
typedef union {
  byte Byte;
  struct {
    byte FP16BP0     :1;                                       /* LCD Segment FP16, BP0 ON */
    byte FP16BP1     :1;                                       /* LCD Segment FP16, BP1 ON */
    byte FP16BP2     :1;                                       /* LCD Segment FP16, BP2 ON */
    byte FP16BP3     :1;                                       /* LCD Segment FP16, BP3 ON */
    byte FP17BP0     :1;                                       /* LCD Segment FP17, BP0 ON */
    byte FP17BP1     :1;                                       /* LCD Segment FP17, BP1 ON */
    byte FP17BP2     :1;                                       /* LCD Segment FP17, BP2 ON */
    byte FP17BP3     :1;                                       /* LCD Segment FP17, BP3 ON */
  } Bits;
  struct {
    byte grpFP16BP :4;
    byte grpFP17BP :4;
  } MergedBits;
} LCDRAM8STR;
extern volatile LCDRAM8STR _LCDRAM8 @(REG_BASE + 0x00000130UL);
#define LCDRAM8                         _LCDRAM8.Byte
#define LCDRAM8_FP16BP0                 _LCDRAM8.Bits.FP16BP0
#define LCDRAM8_FP16BP1                 _LCDRAM8.Bits.FP16BP1
#define LCDRAM8_FP16BP2                 _LCDRAM8.Bits.FP16BP2
#define LCDRAM8_FP16BP3                 _LCDRAM8.Bits.FP16BP3
#define LCDRAM8_FP17BP0                 _LCDRAM8.Bits.FP17BP0
#define LCDRAM8_FP17BP1                 _LCDRAM8.Bits.FP17BP1
#define LCDRAM8_FP17BP2                 _LCDRAM8.Bits.FP17BP2
#define LCDRAM8_FP17BP3                 _LCDRAM8.Bits.FP17BP3
#define LCDRAM8_FP16BP                  _LCDRAM8.MergedBits.grpFP16BP
#define LCDRAM8_FP17BP                  _LCDRAM8.MergedBits.grpFP17BP

#define LCDRAM8_FP16BP0_MASK            1U
#define LCDRAM8_FP16BP1_MASK            2U
#define LCDRAM8_FP16BP2_MASK            4U
#define LCDRAM8_FP16BP3_MASK            8U
#define LCDRAM8_FP17BP0_MASK            16U
#define LCDRAM8_FP17BP1_MASK            32U
#define LCDRAM8_FP17BP2_MASK            64U
#define LCDRAM8_FP17BP3_MASK            128U
#define LCDRAM8_FP16BP_MASK             15U
#define LCDRAM8_FP16BP_BITNUM           0U
#define LCDRAM8_FP17BP_MASK             240U
#define LCDRAM8_FP17BP_BITNUM           4U


/*** LCDRAM9 - LCD RAM Register 9; 0x00000131 ***/
typedef union {
  byte Byte;
  struct {
    byte FP18BP0     :1;                                       /* LCD Segment FP18, BP0 ON */
    byte FP18BP1     :1;                                       /* LCD Segment FP18, BP1 ON */
    byte FP18BP2     :1;                                       /* LCD Segment FP18, BP2 ON */
    byte FP18BP3     :1;                                       /* LCD Segment FP18, BP3 ON */
    byte FP19BP0     :1;                                       /* LCD Segment FP19, BP0 ON */
    byte FP19BP1     :1;                                       /* LCD Segment FP19, BP1 ON */
    byte FP19BP2     :1;                                       /* LCD Segment FP19, BP2 ON */
    byte FP19BP3     :1;                                       /* LCD Segment FP19, BP3 ON */
  } Bits;
  struct {
    byte grpFP18BP :4;
    byte grpFP19BP :4;
  } MergedBits;
} LCDRAM9STR;
extern volatile LCDRAM9STR _LCDRAM9 @(REG_BASE + 0x00000131UL);
#define LCDRAM9                         _LCDRAM9.Byte
#define LCDRAM9_FP18BP0                 _LCDRAM9.Bits.FP18BP0
#define LCDRAM9_FP18BP1                 _LCDRAM9.Bits.FP18BP1
#define LCDRAM9_FP18BP2                 _LCDRAM9.Bits.FP18BP2
#define LCDRAM9_FP18BP3                 _LCDRAM9.Bits.FP18BP3
#define LCDRAM9_FP19BP0                 _LCDRAM9.Bits.FP19BP0
#define LCDRAM9_FP19BP1                 _LCDRAM9.Bits.FP19BP1
#define LCDRAM9_FP19BP2                 _LCDRAM9.Bits.FP19BP2
#define LCDRAM9_FP19BP3                 _LCDRAM9.Bits.FP19BP3
#define LCDRAM9_FP18BP                  _LCDRAM9.MergedBits.grpFP18BP
#define LCDRAM9_FP19BP                  _LCDRAM9.MergedBits.grpFP19BP

#define LCDRAM9_FP18BP0_MASK            1U
#define LCDRAM9_FP18BP1_MASK            2U
#define LCDRAM9_FP18BP2_MASK            4U
#define LCDRAM9_FP18BP3_MASK            8U
#define LCDRAM9_FP19BP0_MASK            16U
#define LCDRAM9_FP19BP1_MASK            32U
#define LCDRAM9_FP19BP2_MASK            64U
#define LCDRAM9_FP19BP3_MASK            128U
#define LCDRAM9_FP18BP_MASK             15U
#define LCDRAM9_FP18BP_BITNUM           0U
#define LCDRAM9_FP19BP_MASK             240U
#define LCDRAM9_FP19BP_BITNUM           4U


/*** LCDRAM10 - LCD RAM Register 10; 0x00000132 ***/
typedef union {
  byte Byte;
  struct {
    byte FP20BP0     :1;                                       /* LCD Segment FP20, BP0 ON */
    byte FP20BP1     :1;                                       /* LCD Segment FP20, BP1 ON */
    byte FP20BP2     :1;                                       /* LCD Segment FP20, BP2 ON */
    byte FP20BP3     :1;                                       /* LCD Segment FP20, BP3 ON */
    byte FP21BP0     :1;                                       /* LCD Segment FP21, BP0 ON */
    byte FP21BP1     :1;                                       /* LCD Segment FP21, BP1 ON */
    byte FP21BP2     :1;                                       /* LCD Segment FP21, BP2 ON */
    byte FP21BP3     :1;                                       /* LCD Segment FP21, BP3 ON */
  } Bits;
  struct {
    byte grpFP20BP :4;
    byte grpFP21BP :4;
  } MergedBits;
} LCDRAM10STR;
extern volatile LCDRAM10STR _LCDRAM10 @(REG_BASE + 0x00000132UL);
#define LCDRAM10                        _LCDRAM10.Byte
#define LCDRAM10_FP20BP0                _LCDRAM10.Bits.FP20BP0
#define LCDRAM10_FP20BP1                _LCDRAM10.Bits.FP20BP1
#define LCDRAM10_FP20BP2                _LCDRAM10.Bits.FP20BP2
#define LCDRAM10_FP20BP3                _LCDRAM10.Bits.FP20BP3
#define LCDRAM10_FP21BP0                _LCDRAM10.Bits.FP21BP0
#define LCDRAM10_FP21BP1                _LCDRAM10.Bits.FP21BP1
#define LCDRAM10_FP21BP2                _LCDRAM10.Bits.FP21BP2
#define LCDRAM10_FP21BP3                _LCDRAM10.Bits.FP21BP3
#define LCDRAM10_FP20BP                 _LCDRAM10.MergedBits.grpFP20BP
#define LCDRAM10_FP21BP                 _LCDRAM10.MergedBits.grpFP21BP

#define LCDRAM10_FP20BP0_MASK           1U
#define LCDRAM10_FP20BP1_MASK           2U
#define LCDRAM10_FP20BP2_MASK           4U
#define LCDRAM10_FP20BP3_MASK           8U
#define LCDRAM10_FP21BP0_MASK           16U
#define LCDRAM10_FP21BP1_MASK           32U
#define LCDRAM10_FP21BP2_MASK           64U
#define LCDRAM10_FP21BP3_MASK           128U
#define LCDRAM10_FP20BP_MASK            15U
#define LCDRAM10_FP20BP_BITNUM          0U
#define LCDRAM10_FP21BP_MASK            240U
#define LCDRAM10_FP21BP_BITNUM          4U


/*** LCDRAM11 - LCD RAM Register 11; 0x00000133 ***/
typedef union {
  byte Byte;
  struct {
    byte FP22BP0     :1;                                       /* LCD Segment FP22, BP0 ON */
    byte FP22BP1     :1;                                       /* LCD Segment FP22, BP1 ON */
    byte FP22BP2     :1;                                       /* LCD Segment FP22, BP2 ON */
    byte FP22BP3     :1;                                       /* LCD Segment FP22, BP3 ON */
    byte FP23BP0     :1;                                       /* LCD Segment FP23, BP0 ON */
    byte FP23BP1     :1;                                       /* LCD Segment FP23, BP1 ON */
    byte FP23BP2     :1;                                       /* LCD Segment FP23, BP2 ON */
    byte FP23BP3     :1;                                       /* LCD Segment FP23, BP3 ON */
  } Bits;
  struct {
    byte grpFP22BP :4;
    byte grpFP23BP :4;
  } MergedBits;
} LCDRAM11STR;
extern volatile LCDRAM11STR _LCDRAM11 @(REG_BASE + 0x00000133UL);
#define LCDRAM11                        _LCDRAM11.Byte
#define LCDRAM11_FP22BP0                _LCDRAM11.Bits.FP22BP0
#define LCDRAM11_FP22BP1                _LCDRAM11.Bits.FP22BP1
#define LCDRAM11_FP22BP2                _LCDRAM11.Bits.FP22BP2
#define LCDRAM11_FP22BP3                _LCDRAM11.Bits.FP22BP3
#define LCDRAM11_FP23BP0                _LCDRAM11.Bits.FP23BP0
#define LCDRAM11_FP23BP1                _LCDRAM11.Bits.FP23BP1
#define LCDRAM11_FP23BP2                _LCDRAM11.Bits.FP23BP2
#define LCDRAM11_FP23BP3                _LCDRAM11.Bits.FP23BP3
#define LCDRAM11_FP22BP                 _LCDRAM11.MergedBits.grpFP22BP
#define LCDRAM11_FP23BP                 _LCDRAM11.MergedBits.grpFP23BP

#define LCDRAM11_FP22BP0_MASK           1U
#define LCDRAM11_FP22BP1_MASK           2U
#define LCDRAM11_FP22BP2_MASK           4U
#define LCDRAM11_FP22BP3_MASK           8U
#define LCDRAM11_FP23BP0_MASK           16U
#define LCDRAM11_FP23BP1_MASK           32U
#define LCDRAM11_FP23BP2_MASK           64U
#define LCDRAM11_FP23BP3_MASK           128U
#define LCDRAM11_FP22BP_MASK            15U
#define LCDRAM11_FP22BP_BITNUM          0U
#define LCDRAM11_FP23BP_MASK            240U
#define LCDRAM11_FP23BP_BITNUM          4U


/*** LCDRAM12 - LCD RAM Register 12; 0x00000134 ***/
typedef union {
  byte Byte;
  struct {
    byte FP24BP0     :1;                                       /* LCD Segment FP24, BP0 ON */
    byte FP24BP1     :1;                                       /* LCD Segment FP24, BP1 ON */
    byte FP24BP2     :1;                                       /* LCD Segment FP24, BP2 ON */
    byte FP24BP3     :1;                                       /* LCD Segment FP24, BP3 ON */
    byte FP25BP0     :1;                                       /* LCD Segment FP25, BP0 ON */
    byte FP25BP1     :1;                                       /* LCD Segment FP25, BP1 ON */
    byte FP25BP2     :1;                                       /* LCD Segment FP25, BP2 ON */
    byte FP25BP3     :1;                                       /* LCD Segment FP25, BP3 ON */
  } Bits;
  struct {
    byte grpFP24BP :4;
    byte grpFP25BP :4;
  } MergedBits;
} LCDRAM12STR;
extern volatile LCDRAM12STR _LCDRAM12 @(REG_BASE + 0x00000134UL);
#define LCDRAM12                        _LCDRAM12.Byte
#define LCDRAM12_FP24BP0                _LCDRAM12.Bits.FP24BP0
#define LCDRAM12_FP24BP1                _LCDRAM12.Bits.FP24BP1
#define LCDRAM12_FP24BP2                _LCDRAM12.Bits.FP24BP2
#define LCDRAM12_FP24BP3                _LCDRAM12.Bits.FP24BP3
#define LCDRAM12_FP25BP0                _LCDRAM12.Bits.FP25BP0
#define LCDRAM12_FP25BP1                _LCDRAM12.Bits.FP25BP1
#define LCDRAM12_FP25BP2                _LCDRAM12.Bits.FP25BP2
#define LCDRAM12_FP25BP3                _LCDRAM12.Bits.FP25BP3
#define LCDRAM12_FP24BP                 _LCDRAM12.MergedBits.grpFP24BP
#define LCDRAM12_FP25BP                 _LCDRAM12.MergedBits.grpFP25BP

#define LCDRAM12_FP24BP0_MASK           1U
#define LCDRAM12_FP24BP1_MASK           2U
#define LCDRAM12_FP24BP2_MASK           4U
#define LCDRAM12_FP24BP3_MASK           8U
#define LCDRAM12_FP25BP0_MASK           16U
#define LCDRAM12_FP25BP1_MASK           32U
#define LCDRAM12_FP25BP2_MASK           64U
#define LCDRAM12_FP25BP3_MASK           128U
#define LCDRAM12_FP24BP_MASK            15U
#define LCDRAM12_FP24BP_BITNUM          0U
#define LCDRAM12_FP25BP_MASK            240U
#define LCDRAM12_FP25BP_BITNUM          4U


/*** LCDRAM13 - LCD RAM Register 13; 0x00000135 ***/
typedef union {
  byte Byte;
  struct {
    byte FP26BP0     :1;                                       /* LCD Segment FP26, BP0 ON */
    byte FP26BP1     :1;                                       /* LCD Segment FP26, BP1 ON */
    byte FP26BP2     :1;                                       /* LCD Segment FP26, BP2 ON */
    byte FP26BP3     :1;                                       /* LCD Segment FP26, BP3 ON */
    byte FP27BP0     :1;                                       /* LCD Segment FP27, BP0 ON */
    byte FP27BP1     :1;                                       /* LCD Segment FP27, BP1 ON */
    byte FP27BP2     :1;                                       /* LCD Segment FP27, BP2 ON */
    byte FP27BP3     :1;                                       /* LCD Segment FP27, BP3 ON */
  } Bits;
  struct {
    byte grpFP26BP :4;
    byte grpFP27BP :4;
  } MergedBits;
} LCDRAM13STR;
extern volatile LCDRAM13STR _LCDRAM13 @(REG_BASE + 0x00000135UL);
#define LCDRAM13                        _LCDRAM13.Byte
#define LCDRAM13_FP26BP0                _LCDRAM13.Bits.FP26BP0
#define LCDRAM13_FP26BP1                _LCDRAM13.Bits.FP26BP1
#define LCDRAM13_FP26BP2                _LCDRAM13.Bits.FP26BP2
#define LCDRAM13_FP26BP3                _LCDRAM13.Bits.FP26BP3
#define LCDRAM13_FP27BP0                _LCDRAM13.Bits.FP27BP0
#define LCDRAM13_FP27BP1                _LCDRAM13.Bits.FP27BP1
#define LCDRAM13_FP27BP2                _LCDRAM13.Bits.FP27BP2
#define LCDRAM13_FP27BP3                _LCDRAM13.Bits.FP27BP3
#define LCDRAM13_FP26BP                 _LCDRAM13.MergedBits.grpFP26BP
#define LCDRAM13_FP27BP                 _LCDRAM13.MergedBits.grpFP27BP

#define LCDRAM13_FP26BP0_MASK           1U
#define LCDRAM13_FP26BP1_MASK           2U
#define LCDRAM13_FP26BP2_MASK           4U
#define LCDRAM13_FP26BP3_MASK           8U
#define LCDRAM13_FP27BP0_MASK           16U
#define LCDRAM13_FP27BP1_MASK           32U
#define LCDRAM13_FP27BP2_MASK           64U
#define LCDRAM13_FP27BP3_MASK           128U
#define LCDRAM13_FP26BP_MASK            15U
#define LCDRAM13_FP26BP_BITNUM          0U
#define LCDRAM13_FP27BP_MASK            240U
#define LCDRAM13_FP27BP_BITNUM          4U


/*** LCDRAM14 - LCD RAM Register 14; 0x00000136 ***/
typedef union {
  byte Byte;
  struct {
    byte FP28BP0     :1;                                       /* LCD Segment FP28, BP0 ON */
    byte FP28BP1     :1;                                       /* LCD Segment FP28, BP1 ON */
    byte FP28BP2     :1;                                       /* LCD Segment FP28, BP2 ON */
    byte FP28BP3     :1;                                       /* LCD Segment FP28, BP3 ON */
    byte FP29BP0     :1;                                       /* LCD Segment FP29, BP0 ON */
    byte FP29BP1     :1;                                       /* LCD Segment FP29, BP1 ON */
    byte FP29BP2     :1;                                       /* LCD Segment FP29, BP2 ON */
    byte FP29BP3     :1;                                       /* LCD Segment FP29, BP3 ON */
  } Bits;
  struct {
    byte grpFP28BP :4;
    byte grpFP29BP :4;
  } MergedBits;
} LCDRAM14STR;
extern volatile LCDRAM14STR _LCDRAM14 @(REG_BASE + 0x00000136UL);
#define LCDRAM14                        _LCDRAM14.Byte
#define LCDRAM14_FP28BP0                _LCDRAM14.Bits.FP28BP0
#define LCDRAM14_FP28BP1                _LCDRAM14.Bits.FP28BP1
#define LCDRAM14_FP28BP2                _LCDRAM14.Bits.FP28BP2
#define LCDRAM14_FP28BP3                _LCDRAM14.Bits.FP28BP3
#define LCDRAM14_FP29BP0                _LCDRAM14.Bits.FP29BP0
#define LCDRAM14_FP29BP1                _LCDRAM14.Bits.FP29BP1
#define LCDRAM14_FP29BP2                _LCDRAM14.Bits.FP29BP2
#define LCDRAM14_FP29BP3                _LCDRAM14.Bits.FP29BP3
#define LCDRAM14_FP28BP                 _LCDRAM14.MergedBits.grpFP28BP
#define LCDRAM14_FP29BP                 _LCDRAM14.MergedBits.grpFP29BP

#define LCDRAM14_FP28BP0_MASK           1U
#define LCDRAM14_FP28BP1_MASK           2U
#define LCDRAM14_FP28BP2_MASK           4U
#define LCDRAM14_FP28BP3_MASK           8U
#define LCDRAM14_FP29BP0_MASK           16U
#define LCDRAM14_FP29BP1_MASK           32U
#define LCDRAM14_FP29BP2_MASK           64U
#define LCDRAM14_FP29BP3_MASK           128U
#define LCDRAM14_FP28BP_MASK            15U
#define LCDRAM14_FP28BP_BITNUM          0U
#define LCDRAM14_FP29BP_MASK            240U
#define LCDRAM14_FP29BP_BITNUM          4U


/*** LCDRAM15 - LCD RAM Register 15; 0x00000137 ***/
typedef union {
  byte Byte;
  struct {
    byte FP30BP0     :1;                                       /* LCD Segment FP30, BP0 ON */
    byte FP30BP1     :1;                                       /* LCD Segment FP30, BP1 ON */
    byte FP30BP2     :1;                                       /* LCD Segment FP30, BP2 ON */
    byte FP30BP3     :1;                                       /* LCD Segment FP30, BP3 ON */
    byte FP31BP0     :1;                                       /* LCD Segment FP31, BP0 ON */
    byte FP31BP1     :1;                                       /* LCD Segment FP31, BP1 ON */
    byte FP31BP2     :1;                                       /* LCD Segment FP31, BP2 ON */
    byte FP31BP3     :1;                                       /* LCD Segment FP31, BP3 ON */
  } Bits;
  struct {
    byte grpFP30BP :4;
    byte grpFP31BP :4;
  } MergedBits;
} LCDRAM15STR;
extern volatile LCDRAM15STR _LCDRAM15 @(REG_BASE + 0x00000137UL);
#define LCDRAM15                        _LCDRAM15.Byte
#define LCDRAM15_FP30BP0                _LCDRAM15.Bits.FP30BP0
#define LCDRAM15_FP30BP1                _LCDRAM15.Bits.FP30BP1
#define LCDRAM15_FP30BP2                _LCDRAM15.Bits.FP30BP2
#define LCDRAM15_FP30BP3                _LCDRAM15.Bits.FP30BP3
#define LCDRAM15_FP31BP0                _LCDRAM15.Bits.FP31BP0
#define LCDRAM15_FP31BP1                _LCDRAM15.Bits.FP31BP1
#define LCDRAM15_FP31BP2                _LCDRAM15.Bits.FP31BP2
#define LCDRAM15_FP31BP3                _LCDRAM15.Bits.FP31BP3
#define LCDRAM15_FP30BP                 _LCDRAM15.MergedBits.grpFP30BP
#define LCDRAM15_FP31BP                 _LCDRAM15.MergedBits.grpFP31BP

#define LCDRAM15_FP30BP0_MASK           1U
#define LCDRAM15_FP30BP1_MASK           2U
#define LCDRAM15_FP30BP2_MASK           4U
#define LCDRAM15_FP30BP3_MASK           8U
#define LCDRAM15_FP31BP0_MASK           16U
#define LCDRAM15_FP31BP1_MASK           32U
#define LCDRAM15_FP31BP2_MASK           64U
#define LCDRAM15_FP31BP3_MASK           128U
#define LCDRAM15_FP30BP_MASK            15U
#define LCDRAM15_FP30BP_BITNUM          0U
#define LCDRAM15_FP31BP_MASK            240U
#define LCDRAM15_FP31BP_BITNUM          4U


/*** MCCTL0 - Motor Controller Control Register 0; 0x000001C0 ***/
typedef union {
  byte Byte;
  struct {
    byte MCTOIF      :1;                                       /* Motor Controller Timer Counter Overflow Interrupt Flag */
    byte             :1; 
    byte DITH        :1;                                       /* Motor Control/Driver dither feature enable */
    byte FAST        :1;                                       /* Motor Controller PWM resolution mode */
    byte MCSWAI      :1;                                       /* Motor Controller Module Stop in WAIT Mode */
    byte MCPRE0      :1;                                       /* Motor Controller Prescaler Select Bit 0 */
    byte MCPRE1      :1;                                       /* Motor Controller Prescaler Select Bit 1 */
    byte             :1; 
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte grpMCPRE :2;
    byte         :1;
  } MergedBits;
} MCCTL0STR;
extern volatile MCCTL0STR _MCCTL0 @(REG_BASE + 0x000001C0UL);
#define MCCTL0                          _MCCTL0.Byte
#define MCCTL0_MCTOIF                   _MCCTL0.Bits.MCTOIF
#define MCCTL0_DITH                     _MCCTL0.Bits.DITH
#define MCCTL0_FAST                     _MCCTL0.Bits.FAST
#define MCCTL0_MCSWAI                   _MCCTL0.Bits.MCSWAI
#define MCCTL0_MCPRE0                   _MCCTL0.Bits.MCPRE0
#define MCCTL0_MCPRE1                   _MCCTL0.Bits.MCPRE1
/* MCCTL_ARR: Access 2 MCCTLx registers in an array */
#define MCCTL_ARR                       ((volatile byte *) &MCCTL0)
#define MCCTL0_MCPRE                    _MCCTL0.MergedBits.grpMCPRE

#define MCCTL0_MCTOIF_MASK              1U
#define MCCTL0_DITH_MASK                4U
#define MCCTL0_FAST_MASK                8U
#define MCCTL0_MCSWAI_MASK              16U
#define MCCTL0_MCPRE0_MASK              32U
#define MCCTL0_MCPRE1_MASK              64U
#define MCCTL0_MCPRE_MASK               96U
#define MCCTL0_MCPRE_BITNUM             5U


/*** MCCTL1 - Motor Controller Control Register 1; 0x000001C1 ***/
typedef union {
  byte Byte;
  struct {
    byte MCTOIE      :1;                                       /* Motor Controller Timer Counter Overflow Interrupt Enable */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte RECIRC      :1;                                       /* Recirculation in (Dual) Full H-bridge mode */
  } Bits;
} MCCTL1STR;
extern volatile MCCTL1STR _MCCTL1 @(REG_BASE + 0x000001C1UL);
#define MCCTL1                          _MCCTL1.Byte
#define MCCTL1_MCTOIE                   _MCCTL1.Bits.MCTOIE
#define MCCTL1_RECIRC                   _MCCTL1.Bits.RECIRC

#define MCCTL1_MCTOIE_MASK              1U
#define MCCTL1_RECIRC_MASK              128U


/*** MCPER - Motor Controller Period Register, with DITH = 0; 0x000001C2 ***/
typedef union {
  word Word;
  struct {
    word P0          :1;                                       /* Motor Controller Period Bit 0 */
    word P1          :1;                                       /* Motor Controller Period Bit 1 */
    word P2          :1;                                       /* Motor Controller Period Bit 2 */
    word P3          :1;                                       /* Motor Controller Period Bit 3 */
    word P4          :1;                                       /* Motor Controller Period Bit 4 */
    word P5          :1;                                       /* Motor Controller Period Bit 5 */
    word P6          :1;                                       /* Motor Controller Period Bit 6 */
    word P7          :1;                                       /* Motor Controller Period Bit 7 */
    word P8          :1;                                       /* Motor Controller Period Bit 8 */
    word P9          :1;                                       /* Motor Controller Period Bit 9 */
    word P10         :1;                                       /* Motor Controller Period Bit 10 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
  struct {
    word grpP    :11;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} MCPERSTR;
extern volatile MCPERSTR _MCPER @(REG_BASE + 0x000001C2UL);
#define MCPER                           _MCPER.Word
#define MCPER_P0                        _MCPER.Bits.P0
#define MCPER_P1                        _MCPER.Bits.P1
#define MCPER_P2                        _MCPER.Bits.P2
#define MCPER_P3                        _MCPER.Bits.P3
#define MCPER_P4                        _MCPER.Bits.P4
#define MCPER_P5                        _MCPER.Bits.P5
#define MCPER_P6                        _MCPER.Bits.P6
#define MCPER_P7                        _MCPER.Bits.P7
#define MCPER_P8                        _MCPER.Bits.P8
#define MCPER_P9                        _MCPER.Bits.P9
#define MCPER_P10                       _MCPER.Bits.P10
#define MCPER_P                         _MCPER.MergedBits.grpP

#define MCPER_P0_MASK                   1U
#define MCPER_P1_MASK                   2U
#define MCPER_P2_MASK                   4U
#define MCPER_P3_MASK                   8U
#define MCPER_P4_MASK                   16U
#define MCPER_P5_MASK                   32U
#define MCPER_P6_MASK                   64U
#define MCPER_P7_MASK                   128U
#define MCPER_P8_MASK                   256U
#define MCPER_P9_MASK                   512U
#define MCPER_P10_MASK                  1024U
#define MCPER_P_MASK                    2047U
#define MCPER_P_BITNUM                  0U


/*** MCCC0 - Motor Controller Control Register Channel 0; 0x000001D0 ***/
typedef union {
  byte Byte;
  struct {
    byte CD0         :1;                                       /* PWM Channel Delay Bit 0 */
    byte CD1         :1;                                       /* PWM Channel Delay Bit 1 */
    byte             :1; 
    byte             :1; 
    byte MCAM0       :1;                                       /* PWM Channel Alignment Mode Bit 0 */
    byte MCAM1       :1;                                       /* PWM Channel Alignment Mode Bit 1 */
    byte MCOM0       :1;                                       /* Output Mode Bit 0 */
    byte MCOM1       :1;                                       /* Output Mode Bit 1 */
  } Bits;
  struct {
    byte grpCD   :2;
    byte         :1;
    byte         :1;
    byte grpMCAM :2;
    byte grpMCOM :2;
  } MergedBits;
} MCCC0STR;
extern volatile MCCC0STR _MCCC0 @(REG_BASE + 0x000001D0UL);
#define MCCC0                           _MCCC0.Byte
#define MCCC0_CD0                       _MCCC0.Bits.CD0
#define MCCC0_CD1                       _MCCC0.Bits.CD1
#define MCCC0_MCAM0                     _MCCC0.Bits.MCAM0
#define MCCC0_MCAM1                     _MCCC0.Bits.MCAM1
#define MCCC0_MCOM0                     _MCCC0.Bits.MCOM0
#define MCCC0_MCOM1                     _MCCC0.Bits.MCOM1
/* MCCC_ARR: Access 8 MCCCx registers in an array */
#define MCCC_ARR                        ((volatile byte *) &MCCC0)
#define MCCC0_CD                        _MCCC0.MergedBits.grpCD
#define MCCC0_MCAM                      _MCCC0.MergedBits.grpMCAM
#define MCCC0_MCOM                      _MCCC0.MergedBits.grpMCOM

#define MCCC0_CD0_MASK                  1U
#define MCCC0_CD1_MASK                  2U
#define MCCC0_MCAM0_MASK                16U
#define MCCC0_MCAM1_MASK                32U
#define MCCC0_MCOM0_MASK                64U
#define MCCC0_MCOM1_MASK                128U
#define MCCC0_CD_MASK                   3U
#define MCCC0_CD_BITNUM                 0U
#define MCCC0_MCAM_MASK                 48U
#define MCCC0_MCAM_BITNUM               4U
#define MCCC0_MCOM_MASK                 192U
#define MCCC0_MCOM_BITNUM               6U


/*** MCCC1 - Motor Controller Control Register Channel 1; 0x000001D1 ***/
typedef union {
  byte Byte;
  struct {
    byte CD0         :1;                                       /* PWM Channel Delay Bit 0 */
    byte CD1         :1;                                       /* PWM Channel Delay Bit 1 */
    byte             :1; 
    byte             :1; 
    byte MCAM0       :1;                                       /* PWM Channel Alignment Mode Bit 0 */
    byte MCAM1       :1;                                       /* PWM Channel Alignment Mode Bit 1 */
    byte MCOM0       :1;                                       /* Output Mode Bit 0 */
    byte MCOM1       :1;                                       /* Output Mode Bit 1 */
  } Bits;
  struct {
    byte grpCD   :2;
    byte         :1;
    byte         :1;
    byte grpMCAM :2;
    byte grpMCOM :2;
  } MergedBits;
} MCCC1STR;
extern volatile MCCC1STR _MCCC1 @(REG_BASE + 0x000001D1UL);
#define MCCC1                           _MCCC1.Byte
#define MCCC1_CD0                       _MCCC1.Bits.CD0
#define MCCC1_CD1                       _MCCC1.Bits.CD1
#define MCCC1_MCAM0                     _MCCC1.Bits.MCAM0
#define MCCC1_MCAM1                     _MCCC1.Bits.MCAM1
#define MCCC1_MCOM0                     _MCCC1.Bits.MCOM0
#define MCCC1_MCOM1                     _MCCC1.Bits.MCOM1
#define MCCC1_CD                        _MCCC1.MergedBits.grpCD
#define MCCC1_MCAM                      _MCCC1.MergedBits.grpMCAM
#define MCCC1_MCOM                      _MCCC1.MergedBits.grpMCOM

#define MCCC1_CD0_MASK                  1U
#define MCCC1_CD1_MASK                  2U
#define MCCC1_MCAM0_MASK                16U
#define MCCC1_MCAM1_MASK                32U
#define MCCC1_MCOM0_MASK                64U
#define MCCC1_MCOM1_MASK                128U
#define MCCC1_CD_MASK                   3U
#define MCCC1_CD_BITNUM                 0U
#define MCCC1_MCAM_MASK                 48U
#define MCCC1_MCAM_BITNUM               4U
#define MCCC1_MCOM_MASK                 192U
#define MCCC1_MCOM_BITNUM               6U


/*** MCCC2 - Motor Controller Control Register Channel 2; 0x000001D2 ***/
typedef union {
  byte Byte;
  struct {
    byte CD0         :1;                                       /* PWM Channel Delay Bit 0 */
    byte CD1         :1;                                       /* PWM Channel Delay Bit 1 */
    byte             :1; 
    byte             :1; 
    byte MCAM0       :1;                                       /* PWM Channel Alignment Mode Bit 0 */
    byte MCAM1       :1;                                       /* PWM Channel Alignment Mode Bit 1 */
    byte MCOM0       :1;                                       /* Output Mode Bit 0 */
    byte MCOM1       :1;                                       /* Output Mode Bit 1 */
  } Bits;
  struct {
    byte grpCD   :2;
    byte         :1;
    byte         :1;
    byte grpMCAM :2;
    byte grpMCOM :2;
  } MergedBits;
} MCCC2STR;
extern volatile MCCC2STR _MCCC2 @(REG_BASE + 0x000001D2UL);
#define MCCC2                           _MCCC2.Byte
#define MCCC2_CD0                       _MCCC2.Bits.CD0
#define MCCC2_CD1                       _MCCC2.Bits.CD1
#define MCCC2_MCAM0                     _MCCC2.Bits.MCAM0
#define MCCC2_MCAM1                     _MCCC2.Bits.MCAM1
#define MCCC2_MCOM0                     _MCCC2.Bits.MCOM0
#define MCCC2_MCOM1                     _MCCC2.Bits.MCOM1
#define MCCC2_CD                        _MCCC2.MergedBits.grpCD
#define MCCC2_MCAM                      _MCCC2.MergedBits.grpMCAM
#define MCCC2_MCOM                      _MCCC2.MergedBits.grpMCOM

#define MCCC2_CD0_MASK                  1U
#define MCCC2_CD1_MASK                  2U
#define MCCC2_MCAM0_MASK                16U
#define MCCC2_MCAM1_MASK                32U
#define MCCC2_MCOM0_MASK                64U
#define MCCC2_MCOM1_MASK                128U
#define MCCC2_CD_MASK                   3U
#define MCCC2_CD_BITNUM                 0U
#define MCCC2_MCAM_MASK                 48U
#define MCCC2_MCAM_BITNUM               4U
#define MCCC2_MCOM_MASK                 192U
#define MCCC2_MCOM_BITNUM               6U


/*** MCCC3 - Motor Controller Control Register Channel 3; 0x000001D3 ***/
typedef union {
  byte Byte;
  struct {
    byte CD0         :1;                                       /* PWM Channel Delay Bit 0 */
    byte CD1         :1;                                       /* PWM Channel Delay Bit 1 */
    byte             :1; 
    byte             :1; 
    byte MCAM0       :1;                                       /* PWM Channel Alignment Mode Bit 0 */
    byte MCAM1       :1;                                       /* PWM Channel Alignment Mode Bit 1 */
    byte MCOM0       :1;                                       /* Output Mode Bit 0 */
    byte MCOM1       :1;                                       /* Output Mode Bit 1 */
  } Bits;
  struct {
    byte grpCD   :2;
    byte         :1;
    byte         :1;
    byte grpMCAM :2;
    byte grpMCOM :2;
  } MergedBits;
} MCCC3STR;
extern volatile MCCC3STR _MCCC3 @(REG_BASE + 0x000001D3UL);
#define MCCC3                           _MCCC3.Byte
#define MCCC3_CD0                       _MCCC3.Bits.CD0
#define MCCC3_CD1                       _MCCC3.Bits.CD1
#define MCCC3_MCAM0                     _MCCC3.Bits.MCAM0
#define MCCC3_MCAM1                     _MCCC3.Bits.MCAM1
#define MCCC3_MCOM0                     _MCCC3.Bits.MCOM0
#define MCCC3_MCOM1                     _MCCC3.Bits.MCOM1
#define MCCC3_CD                        _MCCC3.MergedBits.grpCD
#define MCCC3_MCAM                      _MCCC3.MergedBits.grpMCAM
#define MCCC3_MCOM                      _MCCC3.MergedBits.grpMCOM

#define MCCC3_CD0_MASK                  1U
#define MCCC3_CD1_MASK                  2U
#define MCCC3_MCAM0_MASK                16U
#define MCCC3_MCAM1_MASK                32U
#define MCCC3_MCOM0_MASK                64U
#define MCCC3_MCOM1_MASK                128U
#define MCCC3_CD_MASK                   3U
#define MCCC3_CD_BITNUM                 0U
#define MCCC3_MCAM_MASK                 48U
#define MCCC3_MCAM_BITNUM               4U
#define MCCC3_MCOM_MASK                 192U
#define MCCC3_MCOM_BITNUM               6U


/*** MCCC4 - Motor Controller Control Register Channel 4; 0x000001D4 ***/
typedef union {
  byte Byte;
  struct {
    byte CD0         :1;                                       /* PWM Channel Delay Bit 0 */
    byte CD1         :1;                                       /* PWM Channel Delay Bit 1 */
    byte             :1; 
    byte             :1; 
    byte MCAM0       :1;                                       /* PWM Channel Alignment Mode Bit 0 */
    byte MCAM1       :1;                                       /* PWM Channel Alignment Mode Bit 1 */
    byte MCOM0       :1;                                       /* Output Mode Bit 0 */
    byte MCOM1       :1;                                       /* Output Mode Bit 1 */
  } Bits;
  struct {
    byte grpCD   :2;
    byte         :1;
    byte         :1;
    byte grpMCAM :2;
    byte grpMCOM :2;
  } MergedBits;
} MCCC4STR;
extern volatile MCCC4STR _MCCC4 @(REG_BASE + 0x000001D4UL);
#define MCCC4                           _MCCC4.Byte
#define MCCC4_CD0                       _MCCC4.Bits.CD0
#define MCCC4_CD1                       _MCCC4.Bits.CD1
#define MCCC4_MCAM0                     _MCCC4.Bits.MCAM0
#define MCCC4_MCAM1                     _MCCC4.Bits.MCAM1
#define MCCC4_MCOM0                     _MCCC4.Bits.MCOM0
#define MCCC4_MCOM1                     _MCCC4.Bits.MCOM1
#define MCCC4_CD                        _MCCC4.MergedBits.grpCD
#define MCCC4_MCAM                      _MCCC4.MergedBits.grpMCAM
#define MCCC4_MCOM                      _MCCC4.MergedBits.grpMCOM

#define MCCC4_CD0_MASK                  1U
#define MCCC4_CD1_MASK                  2U
#define MCCC4_MCAM0_MASK                16U
#define MCCC4_MCAM1_MASK                32U
#define MCCC4_MCOM0_MASK                64U
#define MCCC4_MCOM1_MASK                128U
#define MCCC4_CD_MASK                   3U
#define MCCC4_CD_BITNUM                 0U
#define MCCC4_MCAM_MASK                 48U
#define MCCC4_MCAM_BITNUM               4U
#define MCCC4_MCOM_MASK                 192U
#define MCCC4_MCOM_BITNUM               6U


/*** MCCC5 - Motor Controller Control Register Channel 5; 0x000001D5 ***/
typedef union {
  byte Byte;
  struct {
    byte CD0         :1;                                       /* PWM Channel Delay Bit 0 */
    byte CD1         :1;                                       /* PWM Channel Delay Bit 1 */
    byte             :1; 
    byte             :1; 
    byte MCAM0       :1;                                       /* PWM Channel Alignment Mode Bit 0 */
    byte MCAM1       :1;                                       /* PWM Channel Alignment Mode Bit 1 */
    byte MCOM0       :1;                                       /* Output Mode Bit 0 */
    byte MCOM1       :1;                                       /* Output Mode Bit 1 */
  } Bits;
  struct {
    byte grpCD   :2;
    byte         :1;
    byte         :1;
    byte grpMCAM :2;
    byte grpMCOM :2;
  } MergedBits;
} MCCC5STR;
extern volatile MCCC5STR _MCCC5 @(REG_BASE + 0x000001D5UL);
#define MCCC5                           _MCCC5.Byte
#define MCCC5_CD0                       _MCCC5.Bits.CD0
#define MCCC5_CD1                       _MCCC5.Bits.CD1
#define MCCC5_MCAM0                     _MCCC5.Bits.MCAM0
#define MCCC5_MCAM1                     _MCCC5.Bits.MCAM1
#define MCCC5_MCOM0                     _MCCC5.Bits.MCOM0
#define MCCC5_MCOM1                     _MCCC5.Bits.MCOM1
#define MCCC5_CD                        _MCCC5.MergedBits.grpCD
#define MCCC5_MCAM                      _MCCC5.MergedBits.grpMCAM
#define MCCC5_MCOM                      _MCCC5.MergedBits.grpMCOM

#define MCCC5_CD0_MASK                  1U
#define MCCC5_CD1_MASK                  2U
#define MCCC5_MCAM0_MASK                16U
#define MCCC5_MCAM1_MASK                32U
#define MCCC5_MCOM0_MASK                64U
#define MCCC5_MCOM1_MASK                128U
#define MCCC5_CD_MASK                   3U
#define MCCC5_CD_BITNUM                 0U
#define MCCC5_MCAM_MASK                 48U
#define MCCC5_MCAM_BITNUM               4U
#define MCCC5_MCOM_MASK                 192U
#define MCCC5_MCOM_BITNUM               6U


/*** MCCC6 - Motor Controller Control Register Channel 6; 0x000001D6 ***/
typedef union {
  byte Byte;
  struct {
    byte CD0         :1;                                       /* PWM Channel Delay Bit 0 */
    byte CD1         :1;                                       /* PWM Channel Delay Bit 1 */
    byte             :1; 
    byte             :1; 
    byte MCAM0       :1;                                       /* PWM Channel Alignment Mode Bit 0 */
    byte MCAM1       :1;                                       /* PWM Channel Alignment Mode Bit 1 */
    byte MCOM0       :1;                                       /* Output Mode Bit 0 */
    byte MCOM1       :1;                                       /* Output Mode Bit 1 */
  } Bits;
  struct {
    byte grpCD   :2;
    byte         :1;
    byte         :1;
    byte grpMCAM :2;
    byte grpMCOM :2;
  } MergedBits;
} MCCC6STR;
extern volatile MCCC6STR _MCCC6 @(REG_BASE + 0x000001D6UL);
#define MCCC6                           _MCCC6.Byte
#define MCCC6_CD0                       _MCCC6.Bits.CD0
#define MCCC6_CD1                       _MCCC6.Bits.CD1
#define MCCC6_MCAM0                     _MCCC6.Bits.MCAM0
#define MCCC6_MCAM1                     _MCCC6.Bits.MCAM1
#define MCCC6_MCOM0                     _MCCC6.Bits.MCOM0
#define MCCC6_MCOM1                     _MCCC6.Bits.MCOM1
#define MCCC6_CD                        _MCCC6.MergedBits.grpCD
#define MCCC6_MCAM                      _MCCC6.MergedBits.grpMCAM
#define MCCC6_MCOM                      _MCCC6.MergedBits.grpMCOM

#define MCCC6_CD0_MASK                  1U
#define MCCC6_CD1_MASK                  2U
#define MCCC6_MCAM0_MASK                16U
#define MCCC6_MCAM1_MASK                32U
#define MCCC6_MCOM0_MASK                64U
#define MCCC6_MCOM1_MASK                128U
#define MCCC6_CD_MASK                   3U
#define MCCC6_CD_BITNUM                 0U
#define MCCC6_MCAM_MASK                 48U
#define MCCC6_MCAM_BITNUM               4U
#define MCCC6_MCOM_MASK                 192U
#define MCCC6_MCOM_BITNUM               6U


/*** MCCC7 - Motor Controller Control Register Channel 7; 0x000001D7 ***/
typedef union {
  byte Byte;
  struct {
    byte CD0         :1;                                       /* PWM Channel Delay Bit 0 */
    byte CD1         :1;                                       /* PWM Channel Delay Bit 1 */
    byte             :1; 
    byte             :1; 
    byte MCAM0       :1;                                       /* PWM Channel Alignment Mode Bit 0 */
    byte MCAM1       :1;                                       /* PWM Channel Alignment Mode Bit 1 */
    byte MCOM0       :1;                                       /* Output Mode Bit 0 */
    byte MCOM1       :1;                                       /* Output Mode Bit 1 */
  } Bits;
  struct {
    byte grpCD   :2;
    byte         :1;
    byte         :1;
    byte grpMCAM :2;
    byte grpMCOM :2;
  } MergedBits;
} MCCC7STR;
extern volatile MCCC7STR _MCCC7 @(REG_BASE + 0x000001D7UL);
#define MCCC7                           _MCCC7.Byte
#define MCCC7_CD0                       _MCCC7.Bits.CD0
#define MCCC7_CD1                       _MCCC7.Bits.CD1
#define MCCC7_MCAM0                     _MCCC7.Bits.MCAM0
#define MCCC7_MCAM1                     _MCCC7.Bits.MCAM1
#define MCCC7_MCOM0                     _MCCC7.Bits.MCOM0
#define MCCC7_MCOM1                     _MCCC7.Bits.MCOM1
#define MCCC7_CD                        _MCCC7.MergedBits.grpCD
#define MCCC7_MCAM                      _MCCC7.MergedBits.grpMCAM
#define MCCC7_MCOM                      _MCCC7.MergedBits.grpMCOM

#define MCCC7_CD0_MASK                  1U
#define MCCC7_CD1_MASK                  2U
#define MCCC7_MCAM0_MASK                16U
#define MCCC7_MCAM1_MASK                32U
#define MCCC7_MCOM0_MASK                64U
#define MCCC7_MCOM1_MASK                128U
#define MCCC7_CD_MASK                   3U
#define MCCC7_CD_BITNUM                 0U
#define MCCC7_MCAM_MASK                 48U
#define MCCC7_MCAM_BITNUM               4U
#define MCCC7_MCOM_MASK                 192U
#define MCCC7_MCOM_BITNUM               6U


/*** MCDC0 - Motor Controller Duty Cycle Register 0; 0x000001E0 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** MCDC0_FAST - Motor Controller Period Register 0 access with FAST bit = 1; 0x000001E0 ***/
    union {
      byte Byte;
      struct {
        byte D2          :1;                                       /* Motor Controller Duty Cycle, bit 2 */
        byte D3          :1;                                       /* Motor Controller Duty Cycle, bit 3 */
        byte D4          :1;                                       /* Motor Controller Duty Cycle, bit 4 */
        byte D5          :1;                                       /* Motor Controller Duty Cycle, bit 5 */
        byte D6          :1;                                       /* Motor Controller Duty Cycle, bit 6 */
        byte D7          :1;                                       /* Motor Controller Duty Cycle, bit 7 */
        byte D8          :1;                                       /* Motor Controller Duty Cycle, bit 8 */
        byte S           :1;                                       /* Sign */
      } Bits;
      struct {
        byte grpD_2 :7;
        byte     :1;
      } MergedBits;
    } MCDC0_FASTSTR;
    #define MCDC0_FAST                  _MCDC0.Overlap_STR.MCDC0_FASTSTR.Byte
    #define MCDC0_FAST_D2               _MCDC0.Overlap_STR.MCDC0_FASTSTR.Bits.D2
    #define MCDC0_FAST_D3               _MCDC0.Overlap_STR.MCDC0_FASTSTR.Bits.D3
    #define MCDC0_FAST_D4               _MCDC0.Overlap_STR.MCDC0_FASTSTR.Bits.D4
    #define MCDC0_FAST_D5               _MCDC0.Overlap_STR.MCDC0_FASTSTR.Bits.D5
    #define MCDC0_FAST_D6               _MCDC0.Overlap_STR.MCDC0_FASTSTR.Bits.D6
    #define MCDC0_FAST_D7               _MCDC0.Overlap_STR.MCDC0_FASTSTR.Bits.D7
    #define MCDC0_FAST_D8               _MCDC0.Overlap_STR.MCDC0_FASTSTR.Bits.D8
    #define MCDC0_FAST_S                _MCDC0.Overlap_STR.MCDC0_FASTSTR.Bits.S
    #define MCDC0_FAST_D_2              _MCDC0.Overlap_STR.MCDC0_FASTSTR.MergedBits.grpD_2
    #define MCDC0_FAST_D                MCDC0_FAST_D_2
    
    #define MCDC0_FAST_D2_MASK          1U
    #define MCDC0_FAST_D3_MASK          2U
    #define MCDC0_FAST_D4_MASK          4U
    #define MCDC0_FAST_D5_MASK          8U
    #define MCDC0_FAST_D6_MASK          16U
    #define MCDC0_FAST_D7_MASK          32U
    #define MCDC0_FAST_D8_MASK          64U
    #define MCDC0_FAST_S_MASK           128U
    #define MCDC0_FAST_D_2_MASK         127U
    #define MCDC0_FAST_D_2_BITNUM       0U
    
  } Overlap_STR;

  struct {
    word D0          :1;                                       /* Motor Controller Duty Cycle Bit 0 */
    word D1          :1;                                       /* Motor Controller Duty Cycle Bit 1 */
    word D2          :1;                                       /* Motor Controller Duty Cycle Bit 2 */
    word D3          :1;                                       /* Motor Controller Duty Cycle Bit 3 */
    word D4          :1;                                       /* Motor Controller Duty Cycle Bit 4 */
    word D5          :1;                                       /* Motor Controller Duty Cycle Bit 5 */
    word D6          :1;                                       /* Motor Controller Duty Cycle Bit 6 */
    word D7          :1;                                       /* Motor Controller Duty Cycle Bit 7 */
    word D8          :1;                                       /* Motor Controller Duty Cycle Bit 8 */
    word D9          :1;                                       /* Motor Controller Duty Cycle Bit 9 */
    word D10         :1;                                       /* Motor Controller Duty Cycle Bit 10 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word S           :1;                                       /* Sign */
  } Bits;
  struct {
    word grpD    :11;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} MCDC0STR;
extern volatile MCDC0STR _MCDC0 @(REG_BASE + 0x000001E0UL);
#define MCDC0                           _MCDC0.Word
#define MCDC0_D0                        _MCDC0.Bits.D0
#define MCDC0_D1                        _MCDC0.Bits.D1
#define MCDC0_D2                        _MCDC0.Bits.D2
#define MCDC0_D3                        _MCDC0.Bits.D3
#define MCDC0_D4                        _MCDC0.Bits.D4
#define MCDC0_D5                        _MCDC0.Bits.D5
#define MCDC0_D6                        _MCDC0.Bits.D6
#define MCDC0_D7                        _MCDC0.Bits.D7
#define MCDC0_D8                        _MCDC0.Bits.D8
#define MCDC0_D9                        _MCDC0.Bits.D9
#define MCDC0_D10                       _MCDC0.Bits.D10
#define MCDC0_S                         _MCDC0.Bits.S
/* MCDC_ARR: Access 8 MCDCx registers in an array */
#define MCDC_ARR                        ((volatile word *) &MCDC0)
#define MCDC0_D                         _MCDC0.MergedBits.grpD

#define MCDC0_D0_MASK                   1U
#define MCDC0_D1_MASK                   2U
#define MCDC0_D2_MASK                   4U
#define MCDC0_D3_MASK                   8U
#define MCDC0_D4_MASK                   16U
#define MCDC0_D5_MASK                   32U
#define MCDC0_D6_MASK                   64U
#define MCDC0_D7_MASK                   128U
#define MCDC0_D8_MASK                   256U
#define MCDC0_D9_MASK                   512U
#define MCDC0_D10_MASK                  1024U
#define MCDC0_S_MASK                    32768U
#define MCDC0_D_MASK                    2047U
#define MCDC0_D_BITNUM                  0U


/*** MCDC1 - Motor Controller Duty Cycle Register 1; 0x000001E2 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** MCDC1_FAST - Motor Controller Period Register 1 access with FAST bit = 1; 0x000001E2 ***/
    union {
      byte Byte;
      struct {
        byte D2          :1;                                       /* Motor Controller Duty Cycle, bit 2 */
        byte D3          :1;                                       /* Motor Controller Duty Cycle, bit 3 */
        byte D4          :1;                                       /* Motor Controller Duty Cycle, bit 4 */
        byte D5          :1;                                       /* Motor Controller Duty Cycle, bit 5 */
        byte D6          :1;                                       /* Motor Controller Duty Cycle, bit 6 */
        byte D7          :1;                                       /* Motor Controller Duty Cycle, bit 7 */
        byte D8          :1;                                       /* Motor Controller Duty Cycle, bit 8 */
        byte S           :1;                                       /* Sign */
      } Bits;
      struct {
        byte grpD_2 :7;
        byte     :1;
      } MergedBits;
    } MCDC1_FASTSTR;
    #define MCDC1_FAST                  _MCDC1.Overlap_STR.MCDC1_FASTSTR.Byte
    #define MCDC1_FAST_D2               _MCDC1.Overlap_STR.MCDC1_FASTSTR.Bits.D2
    #define MCDC1_FAST_D3               _MCDC1.Overlap_STR.MCDC1_FASTSTR.Bits.D3
    #define MCDC1_FAST_D4               _MCDC1.Overlap_STR.MCDC1_FASTSTR.Bits.D4
    #define MCDC1_FAST_D5               _MCDC1.Overlap_STR.MCDC1_FASTSTR.Bits.D5
    #define MCDC1_FAST_D6               _MCDC1.Overlap_STR.MCDC1_FASTSTR.Bits.D6
    #define MCDC1_FAST_D7               _MCDC1.Overlap_STR.MCDC1_FASTSTR.Bits.D7
    #define MCDC1_FAST_D8               _MCDC1.Overlap_STR.MCDC1_FASTSTR.Bits.D8
    #define MCDC1_FAST_S                _MCDC1.Overlap_STR.MCDC1_FASTSTR.Bits.S
    #define MCDC1_FAST_D_2              _MCDC1.Overlap_STR.MCDC1_FASTSTR.MergedBits.grpD_2
    #define MCDC1_FAST_D                MCDC1_FAST_D_2
    
    #define MCDC1_FAST_D2_MASK          1U
    #define MCDC1_FAST_D3_MASK          2U
    #define MCDC1_FAST_D4_MASK          4U
    #define MCDC1_FAST_D5_MASK          8U
    #define MCDC1_FAST_D6_MASK          16U
    #define MCDC1_FAST_D7_MASK          32U
    #define MCDC1_FAST_D8_MASK          64U
    #define MCDC1_FAST_S_MASK           128U
    #define MCDC1_FAST_D_2_MASK         127U
    #define MCDC1_FAST_D_2_BITNUM       0U
    
  } Overlap_STR;

  struct {
    word D0          :1;                                       /* Motor Controller Duty Cycle Bit 0 */
    word D1          :1;                                       /* Motor Controller Duty Cycle Bit 1 */
    word D2          :1;                                       /* Motor Controller Duty Cycle Bit 2 */
    word D3          :1;                                       /* Motor Controller Duty Cycle Bit 3 */
    word D4          :1;                                       /* Motor Controller Duty Cycle Bit 4 */
    word D5          :1;                                       /* Motor Controller Duty Cycle Bit 5 */
    word D6          :1;                                       /* Motor Controller Duty Cycle Bit 6 */
    word D7          :1;                                       /* Motor Controller Duty Cycle Bit 7 */
    word D8          :1;                                       /* Motor Controller Duty Cycle Bit 8 */
    word D9          :1;                                       /* Motor Controller Duty Cycle Bit 9 */
    word D10         :1;                                       /* Motor Controller Duty Cycle Bit 10 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word S           :1;                                       /* Sign */
  } Bits;
  struct {
    word grpD    :11;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} MCDC1STR;
extern volatile MCDC1STR _MCDC1 @(REG_BASE + 0x000001E2UL);
#define MCDC1                           _MCDC1.Word
#define MCDC1_D0                        _MCDC1.Bits.D0
#define MCDC1_D1                        _MCDC1.Bits.D1
#define MCDC1_D2                        _MCDC1.Bits.D2
#define MCDC1_D3                        _MCDC1.Bits.D3
#define MCDC1_D4                        _MCDC1.Bits.D4
#define MCDC1_D5                        _MCDC1.Bits.D5
#define MCDC1_D6                        _MCDC1.Bits.D6
#define MCDC1_D7                        _MCDC1.Bits.D7
#define MCDC1_D8                        _MCDC1.Bits.D8
#define MCDC1_D9                        _MCDC1.Bits.D9
#define MCDC1_D10                       _MCDC1.Bits.D10
#define MCDC1_S                         _MCDC1.Bits.S
#define MCDC1_D                         _MCDC1.MergedBits.grpD

#define MCDC1_D0_MASK                   1U
#define MCDC1_D1_MASK                   2U
#define MCDC1_D2_MASK                   4U
#define MCDC1_D3_MASK                   8U
#define MCDC1_D4_MASK                   16U
#define MCDC1_D5_MASK                   32U
#define MCDC1_D6_MASK                   64U
#define MCDC1_D7_MASK                   128U
#define MCDC1_D8_MASK                   256U
#define MCDC1_D9_MASK                   512U
#define MCDC1_D10_MASK                  1024U
#define MCDC1_S_MASK                    32768U
#define MCDC1_D_MASK                    2047U
#define MCDC1_D_BITNUM                  0U


/*** MCDC2 - Motor Controller Duty Cycle Register 2; 0x000001E4 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** MCDC2_FAST - Motor Controller Period Register 2 access with FAST bit = 1; 0x000001E4 ***/
    union {
      byte Byte;
      struct {
        byte D2          :1;                                       /* Motor Controller Duty Cycle, bit 2 */
        byte D3          :1;                                       /* Motor Controller Duty Cycle, bit 3 */
        byte D4          :1;                                       /* Motor Controller Duty Cycle, bit 4 */
        byte D5          :1;                                       /* Motor Controller Duty Cycle, bit 5 */
        byte D6          :1;                                       /* Motor Controller Duty Cycle, bit 6 */
        byte D7          :1;                                       /* Motor Controller Duty Cycle, bit 7 */
        byte D8          :1;                                       /* Motor Controller Duty Cycle, bit 8 */
        byte S           :1;                                       /* Sign */
      } Bits;
      struct {
        byte grpD_2 :7;
        byte     :1;
      } MergedBits;
    } MCDC2_FASTSTR;
    #define MCDC2_FAST                  _MCDC2.Overlap_STR.MCDC2_FASTSTR.Byte
    #define MCDC2_FAST_D2               _MCDC2.Overlap_STR.MCDC2_FASTSTR.Bits.D2
    #define MCDC2_FAST_D3               _MCDC2.Overlap_STR.MCDC2_FASTSTR.Bits.D3
    #define MCDC2_FAST_D4               _MCDC2.Overlap_STR.MCDC2_FASTSTR.Bits.D4
    #define MCDC2_FAST_D5               _MCDC2.Overlap_STR.MCDC2_FASTSTR.Bits.D5
    #define MCDC2_FAST_D6               _MCDC2.Overlap_STR.MCDC2_FASTSTR.Bits.D6
    #define MCDC2_FAST_D7               _MCDC2.Overlap_STR.MCDC2_FASTSTR.Bits.D7
    #define MCDC2_FAST_D8               _MCDC2.Overlap_STR.MCDC2_FASTSTR.Bits.D8
    #define MCDC2_FAST_S                _MCDC2.Overlap_STR.MCDC2_FASTSTR.Bits.S
    #define MCDC2_FAST_D_2              _MCDC2.Overlap_STR.MCDC2_FASTSTR.MergedBits.grpD_2
    #define MCDC2_FAST_D                MCDC2_FAST_D_2
    
    #define MCDC2_FAST_D2_MASK          1U
    #define MCDC2_FAST_D3_MASK          2U
    #define MCDC2_FAST_D4_MASK          4U
    #define MCDC2_FAST_D5_MASK          8U
    #define MCDC2_FAST_D6_MASK          16U
    #define MCDC2_FAST_D7_MASK          32U
    #define MCDC2_FAST_D8_MASK          64U
    #define MCDC2_FAST_S_MASK           128U
    #define MCDC2_FAST_D_2_MASK         127U
    #define MCDC2_FAST_D_2_BITNUM       0U
    
  } Overlap_STR;

  struct {
    word D0          :1;                                       /* Motor Controller Duty Cycle Bit 0 */
    word D1          :1;                                       /* Motor Controller Duty Cycle Bit 1 */
    word D2          :1;                                       /* Motor Controller Duty Cycle Bit 2 */
    word D3          :1;                                       /* Motor Controller Duty Cycle Bit 3 */
    word D4          :1;                                       /* Motor Controller Duty Cycle Bit 4 */
    word D5          :1;                                       /* Motor Controller Duty Cycle Bit 5 */
    word D6          :1;                                       /* Motor Controller Duty Cycle Bit 6 */
    word D7          :1;                                       /* Motor Controller Duty Cycle Bit 7 */
    word D8          :1;                                       /* Motor Controller Duty Cycle Bit 8 */
    word D9          :1;                                       /* Motor Controller Duty Cycle Bit 9 */
    word D10         :1;                                       /* Motor Controller Duty Cycle Bit 10 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word S           :1;                                       /* Sign */
  } Bits;
  struct {
    word grpD    :11;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} MCDC2STR;
extern volatile MCDC2STR _MCDC2 @(REG_BASE + 0x000001E4UL);
#define MCDC2                           _MCDC2.Word
#define MCDC2_D0                        _MCDC2.Bits.D0
#define MCDC2_D1                        _MCDC2.Bits.D1
#define MCDC2_D2                        _MCDC2.Bits.D2
#define MCDC2_D3                        _MCDC2.Bits.D3
#define MCDC2_D4                        _MCDC2.Bits.D4
#define MCDC2_D5                        _MCDC2.Bits.D5
#define MCDC2_D6                        _MCDC2.Bits.D6
#define MCDC2_D7                        _MCDC2.Bits.D7
#define MCDC2_D8                        _MCDC2.Bits.D8
#define MCDC2_D9                        _MCDC2.Bits.D9
#define MCDC2_D10                       _MCDC2.Bits.D10
#define MCDC2_S                         _MCDC2.Bits.S
#define MCDC2_D                         _MCDC2.MergedBits.grpD

#define MCDC2_D0_MASK                   1U
#define MCDC2_D1_MASK                   2U
#define MCDC2_D2_MASK                   4U
#define MCDC2_D3_MASK                   8U
#define MCDC2_D4_MASK                   16U
#define MCDC2_D5_MASK                   32U
#define MCDC2_D6_MASK                   64U
#define MCDC2_D7_MASK                   128U
#define MCDC2_D8_MASK                   256U
#define MCDC2_D9_MASK                   512U
#define MCDC2_D10_MASK                  1024U
#define MCDC2_S_MASK                    32768U
#define MCDC2_D_MASK                    2047U
#define MCDC2_D_BITNUM                  0U


/*** MCDC3 - Motor Controller Duty Cycle Register 3; 0x000001E6 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** MCDC3_FAST - Motor Controller Period Register 3 access with FAST bit = 1; 0x000001E6 ***/
    union {
      byte Byte;
      struct {
        byte D2          :1;                                       /* Motor Controller Duty Cycle, bit 2 */
        byte D3          :1;                                       /* Motor Controller Duty Cycle, bit 3 */
        byte D4          :1;                                       /* Motor Controller Duty Cycle, bit 4 */
        byte D5          :1;                                       /* Motor Controller Duty Cycle, bit 5 */
        byte D6          :1;                                       /* Motor Controller Duty Cycle, bit 6 */
        byte D7          :1;                                       /* Motor Controller Duty Cycle, bit 7 */
        byte D8          :1;                                       /* Motor Controller Duty Cycle, bit 8 */
        byte S           :1;                                       /* Sign */
      } Bits;
      struct {
        byte grpD_2 :7;
        byte     :1;
      } MergedBits;
    } MCDC3_FASTSTR;
    #define MCDC3_FAST                  _MCDC3.Overlap_STR.MCDC3_FASTSTR.Byte
    #define MCDC3_FAST_D2               _MCDC3.Overlap_STR.MCDC3_FASTSTR.Bits.D2
    #define MCDC3_FAST_D3               _MCDC3.Overlap_STR.MCDC3_FASTSTR.Bits.D3
    #define MCDC3_FAST_D4               _MCDC3.Overlap_STR.MCDC3_FASTSTR.Bits.D4
    #define MCDC3_FAST_D5               _MCDC3.Overlap_STR.MCDC3_FASTSTR.Bits.D5
    #define MCDC3_FAST_D6               _MCDC3.Overlap_STR.MCDC3_FASTSTR.Bits.D6
    #define MCDC3_FAST_D7               _MCDC3.Overlap_STR.MCDC3_FASTSTR.Bits.D7
    #define MCDC3_FAST_D8               _MCDC3.Overlap_STR.MCDC3_FASTSTR.Bits.D8
    #define MCDC3_FAST_S                _MCDC3.Overlap_STR.MCDC3_FASTSTR.Bits.S
    #define MCDC3_FAST_D_2              _MCDC3.Overlap_STR.MCDC3_FASTSTR.MergedBits.grpD_2
    #define MCDC3_FAST_D                MCDC3_FAST_D_2
    
    #define MCDC3_FAST_D2_MASK          1U
    #define MCDC3_FAST_D3_MASK          2U
    #define MCDC3_FAST_D4_MASK          4U
    #define MCDC3_FAST_D5_MASK          8U
    #define MCDC3_FAST_D6_MASK          16U
    #define MCDC3_FAST_D7_MASK          32U
    #define MCDC3_FAST_D8_MASK          64U
    #define MCDC3_FAST_S_MASK           128U
    #define MCDC3_FAST_D_2_MASK         127U
    #define MCDC3_FAST_D_2_BITNUM       0U
    
  } Overlap_STR;

  struct {
    word D0          :1;                                       /* Motor Controller Duty Cycle Bit 0 */
    word D1          :1;                                       /* Motor Controller Duty Cycle Bit 1 */
    word D2          :1;                                       /* Motor Controller Duty Cycle Bit 2 */
    word D3          :1;                                       /* Motor Controller Duty Cycle Bit 3 */
    word D4          :1;                                       /* Motor Controller Duty Cycle Bit 4 */
    word D5          :1;                                       /* Motor Controller Duty Cycle Bit 5 */
    word D6          :1;                                       /* Motor Controller Duty Cycle Bit 6 */
    word D7          :1;                                       /* Motor Controller Duty Cycle Bit 7 */
    word D8          :1;                                       /* Motor Controller Duty Cycle Bit 8 */
    word D9          :1;                                       /* Motor Controller Duty Cycle Bit 9 */
    word D10         :1;                                       /* Motor Controller Duty Cycle Bit 10 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word S           :1;                                       /* Sign */
  } Bits;
  struct {
    word grpD    :11;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} MCDC3STR;
extern volatile MCDC3STR _MCDC3 @(REG_BASE + 0x000001E6UL);
#define MCDC3                           _MCDC3.Word
#define MCDC3_D0                        _MCDC3.Bits.D0
#define MCDC3_D1                        _MCDC3.Bits.D1
#define MCDC3_D2                        _MCDC3.Bits.D2
#define MCDC3_D3                        _MCDC3.Bits.D3
#define MCDC3_D4                        _MCDC3.Bits.D4
#define MCDC3_D5                        _MCDC3.Bits.D5
#define MCDC3_D6                        _MCDC3.Bits.D6
#define MCDC3_D7                        _MCDC3.Bits.D7
#define MCDC3_D8                        _MCDC3.Bits.D8
#define MCDC3_D9                        _MCDC3.Bits.D9
#define MCDC3_D10                       _MCDC3.Bits.D10
#define MCDC3_S                         _MCDC3.Bits.S
#define MCDC3_D                         _MCDC3.MergedBits.grpD

#define MCDC3_D0_MASK                   1U
#define MCDC3_D1_MASK                   2U
#define MCDC3_D2_MASK                   4U
#define MCDC3_D3_MASK                   8U
#define MCDC3_D4_MASK                   16U
#define MCDC3_D5_MASK                   32U
#define MCDC3_D6_MASK                   64U
#define MCDC3_D7_MASK                   128U
#define MCDC3_D8_MASK                   256U
#define MCDC3_D9_MASK                   512U
#define MCDC3_D10_MASK                  1024U
#define MCDC3_S_MASK                    32768U
#define MCDC3_D_MASK                    2047U
#define MCDC3_D_BITNUM                  0U


/*** MCDC4 - Motor Controller Duty Cycle Register 4; 0x000001E8 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** MCDC4_FAST - Motor Controller Period Register 4 access with FAST bit = 1; 0x000001E8 ***/
    union {
      byte Byte;
      struct {
        byte D2          :1;                                       /* Motor Controller Duty Cycle, bit 2 */
        byte D3          :1;                                       /* Motor Controller Duty Cycle, bit 3 */
        byte D4          :1;                                       /* Motor Controller Duty Cycle, bit 4 */
        byte D5          :1;                                       /* Motor Controller Duty Cycle, bit 5 */
        byte D6          :1;                                       /* Motor Controller Duty Cycle, bit 6 */
        byte D7          :1;                                       /* Motor Controller Duty Cycle, bit 7 */
        byte D8          :1;                                       /* Motor Controller Duty Cycle, bit 8 */
        byte S           :1;                                       /* Sign */
      } Bits;
      struct {
        byte grpD_2 :7;
        byte     :1;
      } MergedBits;
    } MCDC4_FASTSTR;
    #define MCDC4_FAST                  _MCDC4.Overlap_STR.MCDC4_FASTSTR.Byte
    #define MCDC4_FAST_D2               _MCDC4.Overlap_STR.MCDC4_FASTSTR.Bits.D2
    #define MCDC4_FAST_D3               _MCDC4.Overlap_STR.MCDC4_FASTSTR.Bits.D3
    #define MCDC4_FAST_D4               _MCDC4.Overlap_STR.MCDC4_FASTSTR.Bits.D4
    #define MCDC4_FAST_D5               _MCDC4.Overlap_STR.MCDC4_FASTSTR.Bits.D5
    #define MCDC4_FAST_D6               _MCDC4.Overlap_STR.MCDC4_FASTSTR.Bits.D6
    #define MCDC4_FAST_D7               _MCDC4.Overlap_STR.MCDC4_FASTSTR.Bits.D7
    #define MCDC4_FAST_D8               _MCDC4.Overlap_STR.MCDC4_FASTSTR.Bits.D8
    #define MCDC4_FAST_S                _MCDC4.Overlap_STR.MCDC4_FASTSTR.Bits.S
    #define MCDC4_FAST_D_2              _MCDC4.Overlap_STR.MCDC4_FASTSTR.MergedBits.grpD_2
    #define MCDC4_FAST_D                MCDC4_FAST_D_2
    
    #define MCDC4_FAST_D2_MASK          1U
    #define MCDC4_FAST_D3_MASK          2U
    #define MCDC4_FAST_D4_MASK          4U
    #define MCDC4_FAST_D5_MASK          8U
    #define MCDC4_FAST_D6_MASK          16U
    #define MCDC4_FAST_D7_MASK          32U
    #define MCDC4_FAST_D8_MASK          64U
    #define MCDC4_FAST_S_MASK           128U
    #define MCDC4_FAST_D_2_MASK         127U
    #define MCDC4_FAST_D_2_BITNUM       0U
    
  } Overlap_STR;

  struct {
    word D0          :1;                                       /* Motor Controller Duty Cycle Bit 0 */
    word D1          :1;                                       /* Motor Controller Duty Cycle Bit 1 */
    word D2          :1;                                       /* Motor Controller Duty Cycle Bit 2 */
    word D3          :1;                                       /* Motor Controller Duty Cycle Bit 3 */
    word D4          :1;                                       /* Motor Controller Duty Cycle Bit 4 */
    word D5          :1;                                       /* Motor Controller Duty Cycle Bit 5 */
    word D6          :1;                                       /* Motor Controller Duty Cycle Bit 6 */
    word D7          :1;                                       /* Motor Controller Duty Cycle Bit 7 */
    word D8          :1;                                       /* Motor Controller Duty Cycle Bit 8 */
    word D9          :1;                                       /* Motor Controller Duty Cycle Bit 9 */
    word D10         :1;                                       /* Motor Controller Duty Cycle Bit 10 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word S           :1;                                       /* Sign */
  } Bits;
  struct {
    word grpD    :11;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} MCDC4STR;
extern volatile MCDC4STR _MCDC4 @(REG_BASE + 0x000001E8UL);
#define MCDC4                           _MCDC4.Word
#define MCDC4_D0                        _MCDC4.Bits.D0
#define MCDC4_D1                        _MCDC4.Bits.D1
#define MCDC4_D2                        _MCDC4.Bits.D2
#define MCDC4_D3                        _MCDC4.Bits.D3
#define MCDC4_D4                        _MCDC4.Bits.D4
#define MCDC4_D5                        _MCDC4.Bits.D5
#define MCDC4_D6                        _MCDC4.Bits.D6
#define MCDC4_D7                        _MCDC4.Bits.D7
#define MCDC4_D8                        _MCDC4.Bits.D8
#define MCDC4_D9                        _MCDC4.Bits.D9
#define MCDC4_D10                       _MCDC4.Bits.D10
#define MCDC4_S                         _MCDC4.Bits.S
#define MCDC4_D                         _MCDC4.MergedBits.grpD

#define MCDC4_D0_MASK                   1U
#define MCDC4_D1_MASK                   2U
#define MCDC4_D2_MASK                   4U
#define MCDC4_D3_MASK                   8U
#define MCDC4_D4_MASK                   16U
#define MCDC4_D5_MASK                   32U
#define MCDC4_D6_MASK                   64U
#define MCDC4_D7_MASK                   128U
#define MCDC4_D8_MASK                   256U
#define MCDC4_D9_MASK                   512U
#define MCDC4_D10_MASK                  1024U
#define MCDC4_S_MASK                    32768U
#define MCDC4_D_MASK                    2047U
#define MCDC4_D_BITNUM                  0U


/*** MCDC5 - Motor Controller Duty Cycle Register 5; 0x000001EA ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** MCDC5_FAST - Motor Controller Period Register 5 access with FAST bit = 1; 0x000001EA ***/
    union {
      byte Byte;
      struct {
        byte D2          :1;                                       /* Motor Controller Duty Cycle, bit 2 */
        byte D3          :1;                                       /* Motor Controller Duty Cycle, bit 3 */
        byte D4          :1;                                       /* Motor Controller Duty Cycle, bit 4 */
        byte D5          :1;                                       /* Motor Controller Duty Cycle, bit 5 */
        byte D6          :1;                                       /* Motor Controller Duty Cycle, bit 6 */
        byte D7          :1;                                       /* Motor Controller Duty Cycle, bit 7 */
        byte D8          :1;                                       /* Motor Controller Duty Cycle, bit 8 */
        byte S           :1;                                       /* Sign */
      } Bits;
      struct {
        byte grpD_2 :7;
        byte     :1;
      } MergedBits;
    } MCDC5_FASTSTR;
    #define MCDC5_FAST                  _MCDC5.Overlap_STR.MCDC5_FASTSTR.Byte
    #define MCDC5_FAST_D2               _MCDC5.Overlap_STR.MCDC5_FASTSTR.Bits.D2
    #define MCDC5_FAST_D3               _MCDC5.Overlap_STR.MCDC5_FASTSTR.Bits.D3
    #define MCDC5_FAST_D4               _MCDC5.Overlap_STR.MCDC5_FASTSTR.Bits.D4
    #define MCDC5_FAST_D5               _MCDC5.Overlap_STR.MCDC5_FASTSTR.Bits.D5
    #define MCDC5_FAST_D6               _MCDC5.Overlap_STR.MCDC5_FASTSTR.Bits.D6
    #define MCDC5_FAST_D7               _MCDC5.Overlap_STR.MCDC5_FASTSTR.Bits.D7
    #define MCDC5_FAST_D8               _MCDC5.Overlap_STR.MCDC5_FASTSTR.Bits.D8
    #define MCDC5_FAST_S                _MCDC5.Overlap_STR.MCDC5_FASTSTR.Bits.S
    #define MCDC5_FAST_D_2              _MCDC5.Overlap_STR.MCDC5_FASTSTR.MergedBits.grpD_2
    #define MCDC5_FAST_D                MCDC5_FAST_D_2
    
    #define MCDC5_FAST_D2_MASK          1U
    #define MCDC5_FAST_D3_MASK          2U
    #define MCDC5_FAST_D4_MASK          4U
    #define MCDC5_FAST_D5_MASK          8U
    #define MCDC5_FAST_D6_MASK          16U
    #define MCDC5_FAST_D7_MASK          32U
    #define MCDC5_FAST_D8_MASK          64U
    #define MCDC5_FAST_S_MASK           128U
    #define MCDC5_FAST_D_2_MASK         127U
    #define MCDC5_FAST_D_2_BITNUM       0U
    
  } Overlap_STR;

  struct {
    word D0          :1;                                       /* Motor Controller Duty Cycle Bit 0 */
    word D1          :1;                                       /* Motor Controller Duty Cycle Bit 1 */
    word D2          :1;                                       /* Motor Controller Duty Cycle Bit 2 */
    word D3          :1;                                       /* Motor Controller Duty Cycle Bit 3 */
    word D4          :1;                                       /* Motor Controller Duty Cycle Bit 4 */
    word D5          :1;                                       /* Motor Controller Duty Cycle Bit 5 */
    word D6          :1;                                       /* Motor Controller Duty Cycle Bit 6 */
    word D7          :1;                                       /* Motor Controller Duty Cycle Bit 7 */
    word D8          :1;                                       /* Motor Controller Duty Cycle Bit 8 */
    word D9          :1;                                       /* Motor Controller Duty Cycle Bit 9 */
    word D10         :1;                                       /* Motor Controller Duty Cycle Bit 10 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word S           :1;                                       /* Sign */
  } Bits;
  struct {
    word grpD    :11;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} MCDC5STR;
extern volatile MCDC5STR _MCDC5 @(REG_BASE + 0x000001EAUL);
#define MCDC5                           _MCDC5.Word
#define MCDC5_D0                        _MCDC5.Bits.D0
#define MCDC5_D1                        _MCDC5.Bits.D1
#define MCDC5_D2                        _MCDC5.Bits.D2
#define MCDC5_D3                        _MCDC5.Bits.D3
#define MCDC5_D4                        _MCDC5.Bits.D4
#define MCDC5_D5                        _MCDC5.Bits.D5
#define MCDC5_D6                        _MCDC5.Bits.D6
#define MCDC5_D7                        _MCDC5.Bits.D7
#define MCDC5_D8                        _MCDC5.Bits.D8
#define MCDC5_D9                        _MCDC5.Bits.D9
#define MCDC5_D10                       _MCDC5.Bits.D10
#define MCDC5_S                         _MCDC5.Bits.S
#define MCDC5_D                         _MCDC5.MergedBits.grpD

#define MCDC5_D0_MASK                   1U
#define MCDC5_D1_MASK                   2U
#define MCDC5_D2_MASK                   4U
#define MCDC5_D3_MASK                   8U
#define MCDC5_D4_MASK                   16U
#define MCDC5_D5_MASK                   32U
#define MCDC5_D6_MASK                   64U
#define MCDC5_D7_MASK                   128U
#define MCDC5_D8_MASK                   256U
#define MCDC5_D9_MASK                   512U
#define MCDC5_D10_MASK                  1024U
#define MCDC5_S_MASK                    32768U
#define MCDC5_D_MASK                    2047U
#define MCDC5_D_BITNUM                  0U


/*** MCDC6 - Motor Controller Duty Cycle Register 6; 0x000001EC ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** MCDC6_FAST - Motor Controller Period Register 6 access with FAST bit = 1; 0x000001EC ***/
    union {
      byte Byte;
      struct {
        byte D2          :1;                                       /* Motor Controller Duty Cycle, bit 2 */
        byte D3          :1;                                       /* Motor Controller Duty Cycle, bit 3 */
        byte D4          :1;                                       /* Motor Controller Duty Cycle, bit 4 */
        byte D5          :1;                                       /* Motor Controller Duty Cycle, bit 5 */
        byte D6          :1;                                       /* Motor Controller Duty Cycle, bit 6 */
        byte D7          :1;                                       /* Motor Controller Duty Cycle, bit 7 */
        byte D8          :1;                                       /* Motor Controller Duty Cycle, bit 8 */
        byte S           :1;                                       /* Sign */
      } Bits;
      struct {
        byte grpD_2 :7;
        byte     :1;
      } MergedBits;
    } MCDC6_FASTSTR;
    #define MCDC6_FAST                  _MCDC6.Overlap_STR.MCDC6_FASTSTR.Byte
    #define MCDC6_FAST_D2               _MCDC6.Overlap_STR.MCDC6_FASTSTR.Bits.D2
    #define MCDC6_FAST_D3               _MCDC6.Overlap_STR.MCDC6_FASTSTR.Bits.D3
    #define MCDC6_FAST_D4               _MCDC6.Overlap_STR.MCDC6_FASTSTR.Bits.D4
    #define MCDC6_FAST_D5               _MCDC6.Overlap_STR.MCDC6_FASTSTR.Bits.D5
    #define MCDC6_FAST_D6               _MCDC6.Overlap_STR.MCDC6_FASTSTR.Bits.D6
    #define MCDC6_FAST_D7               _MCDC6.Overlap_STR.MCDC6_FASTSTR.Bits.D7
    #define MCDC6_FAST_D8               _MCDC6.Overlap_STR.MCDC6_FASTSTR.Bits.D8
    #define MCDC6_FAST_S                _MCDC6.Overlap_STR.MCDC6_FASTSTR.Bits.S
    #define MCDC6_FAST_D_2              _MCDC6.Overlap_STR.MCDC6_FASTSTR.MergedBits.grpD_2
    #define MCDC6_FAST_D                MCDC6_FAST_D_2
    
    #define MCDC6_FAST_D2_MASK          1U
    #define MCDC6_FAST_D3_MASK          2U
    #define MCDC6_FAST_D4_MASK          4U
    #define MCDC6_FAST_D5_MASK          8U
    #define MCDC6_FAST_D6_MASK          16U
    #define MCDC6_FAST_D7_MASK          32U
    #define MCDC6_FAST_D8_MASK          64U
    #define MCDC6_FAST_S_MASK           128U
    #define MCDC6_FAST_D_2_MASK         127U
    #define MCDC6_FAST_D_2_BITNUM       0U
    
  } Overlap_STR;

  struct {
    word D0          :1;                                       /* Motor Controller Duty Cycle Bit 0 */
    word D1          :1;                                       /* Motor Controller Duty Cycle Bit 1 */
    word D2          :1;                                       /* Motor Controller Duty Cycle Bit 2 */
    word D3          :1;                                       /* Motor Controller Duty Cycle Bit 3 */
    word D4          :1;                                       /* Motor Controller Duty Cycle Bit 4 */
    word D5          :1;                                       /* Motor Controller Duty Cycle Bit 5 */
    word D6          :1;                                       /* Motor Controller Duty Cycle Bit 6 */
    word D7          :1;                                       /* Motor Controller Duty Cycle Bit 7 */
    word D8          :1;                                       /* Motor Controller Duty Cycle Bit 8 */
    word D9          :1;                                       /* Motor Controller Duty Cycle Bit 9 */
    word D10         :1;                                       /* Motor Controller Duty Cycle Bit 10 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word S           :1;                                       /* Sign */
  } Bits;
  struct {
    word grpD    :11;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} MCDC6STR;
extern volatile MCDC6STR _MCDC6 @(REG_BASE + 0x000001ECUL);
#define MCDC6                           _MCDC6.Word
#define MCDC6_D0                        _MCDC6.Bits.D0
#define MCDC6_D1                        _MCDC6.Bits.D1
#define MCDC6_D2                        _MCDC6.Bits.D2
#define MCDC6_D3                        _MCDC6.Bits.D3
#define MCDC6_D4                        _MCDC6.Bits.D4
#define MCDC6_D5                        _MCDC6.Bits.D5
#define MCDC6_D6                        _MCDC6.Bits.D6
#define MCDC6_D7                        _MCDC6.Bits.D7
#define MCDC6_D8                        _MCDC6.Bits.D8
#define MCDC6_D9                        _MCDC6.Bits.D9
#define MCDC6_D10                       _MCDC6.Bits.D10
#define MCDC6_S                         _MCDC6.Bits.S
#define MCDC6_D                         _MCDC6.MergedBits.grpD

#define MCDC6_D0_MASK                   1U
#define MCDC6_D1_MASK                   2U
#define MCDC6_D2_MASK                   4U
#define MCDC6_D3_MASK                   8U
#define MCDC6_D4_MASK                   16U
#define MCDC6_D5_MASK                   32U
#define MCDC6_D6_MASK                   64U
#define MCDC6_D7_MASK                   128U
#define MCDC6_D8_MASK                   256U
#define MCDC6_D9_MASK                   512U
#define MCDC6_D10_MASK                  1024U
#define MCDC6_S_MASK                    32768U
#define MCDC6_D_MASK                    2047U
#define MCDC6_D_BITNUM                  0U


/*** MCDC7 - Motor Controller Duty Cycle Register 7; 0x000001EE ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** MCDC7_FAST - Motor Controller Period Register 7 access with FAST bit = 1; 0x000001EE ***/
    union {
      byte Byte;
      struct {
        byte D2          :1;                                       /* Motor Controller Duty Cycle, bit 2 */
        byte D3          :1;                                       /* Motor Controller Duty Cycle, bit 3 */
        byte D4          :1;                                       /* Motor Controller Duty Cycle, bit 4 */
        byte D5          :1;                                       /* Motor Controller Duty Cycle, bit 5 */
        byte D6          :1;                                       /* Motor Controller Duty Cycle, bit 6 */
        byte D7          :1;                                       /* Motor Controller Duty Cycle, bit 7 */
        byte D8          :1;                                       /* Motor Controller Duty Cycle, bit 8 */
        byte S           :1;                                       /* Sign */
      } Bits;
      struct {
        byte grpD_2 :7;
        byte     :1;
      } MergedBits;
    } MCDC7_FASTSTR;
    #define MCDC7_FAST                  _MCDC7.Overlap_STR.MCDC7_FASTSTR.Byte
    #define MCDC7_FAST_D2               _MCDC7.Overlap_STR.MCDC7_FASTSTR.Bits.D2
    #define MCDC7_FAST_D3               _MCDC7.Overlap_STR.MCDC7_FASTSTR.Bits.D3
    #define MCDC7_FAST_D4               _MCDC7.Overlap_STR.MCDC7_FASTSTR.Bits.D4
    #define MCDC7_FAST_D5               _MCDC7.Overlap_STR.MCDC7_FASTSTR.Bits.D5
    #define MCDC7_FAST_D6               _MCDC7.Overlap_STR.MCDC7_FASTSTR.Bits.D6
    #define MCDC7_FAST_D7               _MCDC7.Overlap_STR.MCDC7_FASTSTR.Bits.D7
    #define MCDC7_FAST_D8               _MCDC7.Overlap_STR.MCDC7_FASTSTR.Bits.D8
    #define MCDC7_FAST_S                _MCDC7.Overlap_STR.MCDC7_FASTSTR.Bits.S
    #define MCDC7_FAST_D_2              _MCDC7.Overlap_STR.MCDC7_FASTSTR.MergedBits.grpD_2
    #define MCDC7_FAST_D                MCDC7_FAST_D_2
    
    #define MCDC7_FAST_D2_MASK          1U
    #define MCDC7_FAST_D3_MASK          2U
    #define MCDC7_FAST_D4_MASK          4U
    #define MCDC7_FAST_D5_MASK          8U
    #define MCDC7_FAST_D6_MASK          16U
    #define MCDC7_FAST_D7_MASK          32U
    #define MCDC7_FAST_D8_MASK          64U
    #define MCDC7_FAST_S_MASK           128U
    #define MCDC7_FAST_D_2_MASK         127U
    #define MCDC7_FAST_D_2_BITNUM       0U
    
  } Overlap_STR;

  struct {
    word D0          :1;                                       /* Motor Controller Duty Cycle Bit 0 */
    word D1          :1;                                       /* Motor Controller Duty Cycle Bit 1 */
    word D2          :1;                                       /* Motor Controller Duty Cycle Bit 2 */
    word D3          :1;                                       /* Motor Controller Duty Cycle Bit 3 */
    word D4          :1;                                       /* Motor Controller Duty Cycle Bit 4 */
    word D5          :1;                                       /* Motor Controller Duty Cycle Bit 5 */
    word D6          :1;                                       /* Motor Controller Duty Cycle Bit 6 */
    word D7          :1;                                       /* Motor Controller Duty Cycle Bit 7 */
    word D8          :1;                                       /* Motor Controller Duty Cycle Bit 8 */
    word D9          :1;                                       /* Motor Controller Duty Cycle Bit 9 */
    word D10         :1;                                       /* Motor Controller Duty Cycle Bit 10 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word S           :1;                                       /* Sign */
  } Bits;
  struct {
    word grpD    :11;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} MCDC7STR;
extern volatile MCDC7STR _MCDC7 @(REG_BASE + 0x000001EEUL);
#define MCDC7                           _MCDC7.Word
#define MCDC7_D0                        _MCDC7.Bits.D0
#define MCDC7_D1                        _MCDC7.Bits.D1
#define MCDC7_D2                        _MCDC7.Bits.D2
#define MCDC7_D3                        _MCDC7.Bits.D3
#define MCDC7_D4                        _MCDC7.Bits.D4
#define MCDC7_D5                        _MCDC7.Bits.D5
#define MCDC7_D6                        _MCDC7.Bits.D6
#define MCDC7_D7                        _MCDC7.Bits.D7
#define MCDC7_D8                        _MCDC7.Bits.D8
#define MCDC7_D9                        _MCDC7.Bits.D9
#define MCDC7_D10                       _MCDC7.Bits.D10
#define MCDC7_S                         _MCDC7.Bits.S
#define MCDC7_D                         _MCDC7.MergedBits.grpD

#define MCDC7_D0_MASK                   1U
#define MCDC7_D1_MASK                   2U
#define MCDC7_D2_MASK                   4U
#define MCDC7_D3_MASK                   8U
#define MCDC7_D4_MASK                   16U
#define MCDC7_D5_MASK                   32U
#define MCDC7_D6_MASK                   64U
#define MCDC7_D7_MASK                   128U
#define MCDC7_D8_MASK                   256U
#define MCDC7_D9_MASK                   512U
#define MCDC7_D10_MASK                  1024U
#define MCDC7_S_MASK                    32768U
#define MCDC7_D_MASK                    2047U
#define MCDC7_D_BITNUM                  0U


/*** PTT - Port T I/O Register; 0x00000200 ***/
typedef union {
  byte Byte;
  struct {
    byte PTT0        :1;                                       /* Port T Bit 0 */
    byte PTT1        :1;                                       /* Port T Bit 1 */
    byte PTT2        :1;                                       /* Port T Bit 2 */
    byte PTT3        :1;                                       /* Port T Bit 3 */
    byte PTT4        :1;                                       /* Port T Bit 4 */
    byte PTT5        :1;                                       /* Port T Bit 5 */
    byte PTT6        :1;                                       /* Port T Bit 6 */
    byte PTT7        :1;                                       /* Port T Bit 7 */
  } Bits;
} PTTSTR;
extern volatile PTTSTR _PTT @(REG_BASE + 0x00000200UL);
#define PTT                             _PTT.Byte
#define PTT_PTT0                        _PTT.Bits.PTT0
#define PTT_PTT1                        _PTT.Bits.PTT1
#define PTT_PTT2                        _PTT.Bits.PTT2
#define PTT_PTT3                        _PTT.Bits.PTT3
#define PTT_PTT4                        _PTT.Bits.PTT4
#define PTT_PTT5                        _PTT.Bits.PTT5
#define PTT_PTT6                        _PTT.Bits.PTT6
#define PTT_PTT7                        _PTT.Bits.PTT7

#define PTT_PTT0_MASK                   1U
#define PTT_PTT1_MASK                   2U
#define PTT_PTT2_MASK                   4U
#define PTT_PTT3_MASK                   8U
#define PTT_PTT4_MASK                   16U
#define PTT_PTT5_MASK                   32U
#define PTT_PTT6_MASK                   64U
#define PTT_PTT7_MASK                   128U


/*** PTIT - Port T Input Register; 0x00000201 ***/
typedef union {
  byte Byte;
  struct {
    byte PTIT0       :1;                                       /* Port T Bit 0 */
    byte PTIT1       :1;                                       /* Port T Bit 1 */
    byte PTIT2       :1;                                       /* Port T Bit 2 */
    byte PTIT3       :1;                                       /* Port T Bit 3 */
    byte PTIT4       :1;                                       /* Port T Bit 4 */
    byte PTIT5       :1;                                       /* Port T Bit 5 */
    byte PTIT6       :1;                                       /* Port T Bit 6 */
    byte PTIT7       :1;                                       /* Port T Bit 7 */
  } Bits;
} PTITSTR;
extern volatile PTITSTR _PTIT @(REG_BASE + 0x00000201UL);
#define PTIT                            _PTIT.Byte
#define PTIT_PTIT0                      _PTIT.Bits.PTIT0
#define PTIT_PTIT1                      _PTIT.Bits.PTIT1
#define PTIT_PTIT2                      _PTIT.Bits.PTIT2
#define PTIT_PTIT3                      _PTIT.Bits.PTIT3
#define PTIT_PTIT4                      _PTIT.Bits.PTIT4
#define PTIT_PTIT5                      _PTIT.Bits.PTIT5
#define PTIT_PTIT6                      _PTIT.Bits.PTIT6
#define PTIT_PTIT7                      _PTIT.Bits.PTIT7

#define PTIT_PTIT0_MASK                 1U
#define PTIT_PTIT1_MASK                 2U
#define PTIT_PTIT2_MASK                 4U
#define PTIT_PTIT3_MASK                 8U
#define PTIT_PTIT4_MASK                 16U
#define PTIT_PTIT5_MASK                 32U
#define PTIT_PTIT6_MASK                 64U
#define PTIT_PTIT7_MASK                 128U


/*** DDRT - Port T Data Direction Register; 0x00000202 ***/
typedef union {
  byte Byte;
  struct {
    byte DDRT0       :1;                                       /* Data Direction Port T Bit 0 */
    byte DDRT1       :1;                                       /* Data Direction Port T Bit 1 */
    byte DDRT2       :1;                                       /* Data Direction Port T Bit 2 */
    byte DDRT3       :1;                                       /* Data Direction Port T Bit 3 */
    byte DDRT4       :1;                                       /* Data Direction Port T Bit 4 */
    byte DDRT5       :1;                                       /* Data Direction Port T Bit 5 */
    byte DDRT6       :1;                                       /* Data Direction Port T Bit 6 */
    byte DDRT7       :1;                                       /* Data Direction Port T Bit 7 */
  } Bits;
} DDRTSTR;
extern volatile DDRTSTR _DDRT @(REG_BASE + 0x00000202UL);
#define DDRT                            _DDRT.Byte
#define DDRT_DDRT0                      _DDRT.Bits.DDRT0
#define DDRT_DDRT1                      _DDRT.Bits.DDRT1
#define DDRT_DDRT2                      _DDRT.Bits.DDRT2
#define DDRT_DDRT3                      _DDRT.Bits.DDRT3
#define DDRT_DDRT4                      _DDRT.Bits.DDRT4
#define DDRT_DDRT5                      _DDRT.Bits.DDRT5
#define DDRT_DDRT6                      _DDRT.Bits.DDRT6
#define DDRT_DDRT7                      _DDRT.Bits.DDRT7

#define DDRT_DDRT0_MASK                 1U
#define DDRT_DDRT1_MASK                 2U
#define DDRT_DDRT2_MASK                 4U
#define DDRT_DDRT3_MASK                 8U
#define DDRT_DDRT4_MASK                 16U
#define DDRT_DDRT5_MASK                 32U
#define DDRT_DDRT6_MASK                 64U
#define DDRT_DDRT7_MASK                 128U


/*** RDRT - Port T Reduced Drive Register; 0x00000203 ***/
typedef union {
  byte Byte;
  struct {
    byte RDRT0       :1;                                       /* Reduced Drive Port T Bit 0 */
    byte RDRT1       :1;                                       /* Reduced Drive Port T Bit 1 */
    byte RDRT2       :1;                                       /* Reduced Drive Port T Bit 2 */
    byte RDRT3       :1;                                       /* Reduced Drive Port T Bit 3 */
    byte RDRT4       :1;                                       /* Reduced Drive Port T Bit 4 */
    byte RDRT5       :1;                                       /* Reduced Drive Port T Bit 5 */
    byte RDRT6       :1;                                       /* Reduced Drive Port T Bit 6 */
    byte RDRT7       :1;                                       /* Reduced Drive Port T Bit 7 */
  } Bits;
} RDRTSTR;
extern volatile RDRTSTR _RDRT @(REG_BASE + 0x00000203UL);
#define RDRT                            _RDRT.Byte
#define RDRT_RDRT0                      _RDRT.Bits.RDRT0
#define RDRT_RDRT1                      _RDRT.Bits.RDRT1
#define RDRT_RDRT2                      _RDRT.Bits.RDRT2
#define RDRT_RDRT3                      _RDRT.Bits.RDRT3
#define RDRT_RDRT4                      _RDRT.Bits.RDRT4
#define RDRT_RDRT5                      _RDRT.Bits.RDRT5
#define RDRT_RDRT6                      _RDRT.Bits.RDRT6
#define RDRT_RDRT7                      _RDRT.Bits.RDRT7

#define RDRT_RDRT0_MASK                 1U
#define RDRT_RDRT1_MASK                 2U
#define RDRT_RDRT2_MASK                 4U
#define RDRT_RDRT3_MASK                 8U
#define RDRT_RDRT4_MASK                 16U
#define RDRT_RDRT5_MASK                 32U
#define RDRT_RDRT6_MASK                 64U
#define RDRT_RDRT7_MASK                 128U


/*** PERT - Port T Pull Device Enable Register; 0x00000204 ***/
typedef union {
  byte Byte;
  struct {
    byte PERT0       :1;                                       /* Pull Device Enable Port T Bit 0 */
    byte PERT1       :1;                                       /* Pull Device Enable Port T Bit 1 */
    byte PERT2       :1;                                       /* Pull Device Enable Port T Bit 2 */
    byte PERT3       :1;                                       /* Pull Device Enable Port T Bit 3 */
    byte PERT4       :1;                                       /* Pull Device Enable Port T Bit 4 */
    byte PERT5       :1;                                       /* Pull Device Enable Port T Bit 5 */
    byte PERT6       :1;                                       /* Pull Device Enable Port T Bit 6 */
    byte PERT7       :1;                                       /* Pull Device Enable Port T Bit 7 */
  } Bits;
} PERTSTR;
extern volatile PERTSTR _PERT @(REG_BASE + 0x00000204UL);
#define PERT                            _PERT.Byte
#define PERT_PERT0                      _PERT.Bits.PERT0
#define PERT_PERT1                      _PERT.Bits.PERT1
#define PERT_PERT2                      _PERT.Bits.PERT2
#define PERT_PERT3                      _PERT.Bits.PERT3
#define PERT_PERT4                      _PERT.Bits.PERT4
#define PERT_PERT5                      _PERT.Bits.PERT5
#define PERT_PERT6                      _PERT.Bits.PERT6
#define PERT_PERT7                      _PERT.Bits.PERT7

#define PERT_PERT0_MASK                 1U
#define PERT_PERT1_MASK                 2U
#define PERT_PERT2_MASK                 4U
#define PERT_PERT3_MASK                 8U
#define PERT_PERT4_MASK                 16U
#define PERT_PERT5_MASK                 32U
#define PERT_PERT6_MASK                 64U
#define PERT_PERT7_MASK                 128U


/*** PPST - Port T Polarity Select Register; 0x00000205 ***/
typedef union {
  byte Byte;
  struct {
    byte PPST0       :1;                                       /* Pull Select Port T Bit 0 */
    byte PPST1       :1;                                       /* Pull Select Port T Bit 1 */
    byte PPST2       :1;                                       /* Pull Select Port T Bit 2 */
    byte PPST3       :1;                                       /* Pull Select Port T Bit 3 */
    byte PPST4       :1;                                       /* Pull Select Port T Bit 4 */
    byte PPST5       :1;                                       /* Pull Select Port T Bit 5 */
    byte PPST6       :1;                                       /* Pull Select Port T Bit 6 */
    byte PPST7       :1;                                       /* Pull Select Port T Bit 7 */
  } Bits;
} PPSTSTR;
extern volatile PPSTSTR _PPST @(REG_BASE + 0x00000205UL);
#define PPST                            _PPST.Byte
#define PPST_PPST0                      _PPST.Bits.PPST0
#define PPST_PPST1                      _PPST.Bits.PPST1
#define PPST_PPST2                      _PPST.Bits.PPST2
#define PPST_PPST3                      _PPST.Bits.PPST3
#define PPST_PPST4                      _PPST.Bits.PPST4
#define PPST_PPST5                      _PPST.Bits.PPST5
#define PPST_PPST6                      _PPST.Bits.PPST6
#define PPST_PPST7                      _PPST.Bits.PPST7

#define PPST_PPST0_MASK                 1U
#define PPST_PPST1_MASK                 2U
#define PPST_PPST2_MASK                 4U
#define PPST_PPST3_MASK                 8U
#define PPST_PPST4_MASK                 16U
#define PPST_PPST5_MASK                 32U
#define PPST_PPST6_MASK                 64U
#define PPST_PPST7_MASK                 128U


/*** PTS - Port S I/O Register; 0x00000208 ***/
typedef union {
  byte Byte;
  struct {
    byte PTS0        :1;                                       /* Port S Bit 0 */
    byte PTS1        :1;                                       /* Port S Bit 1 */
    byte             :1; 
    byte             :1; 
    byte PTS4        :1;                                       /* Port S Bit 4 */
    byte PTS5        :1;                                       /* Port S Bit 5 */
    byte PTS6        :1;                                       /* Port S Bit 6 */
    byte             :1; 
  } Bits;
  struct {
    byte grpPTS  :2;
    byte         :1;
    byte         :1;
    byte grpPTS_4 :3;
    byte         :1;
  } MergedBits;
} PTSSTR;
extern volatile PTSSTR _PTS @(REG_BASE + 0x00000208UL);
#define PTS                             _PTS.Byte
#define PTS_PTS0                        _PTS.Bits.PTS0
#define PTS_PTS1                        _PTS.Bits.PTS1
#define PTS_PTS4                        _PTS.Bits.PTS4
#define PTS_PTS5                        _PTS.Bits.PTS5
#define PTS_PTS6                        _PTS.Bits.PTS6
#define PTS_PTS                         _PTS.MergedBits.grpPTS
#define PTS_PTS_4                       _PTS.MergedBits.grpPTS_4

#define PTS_PTS0_MASK                   1U
#define PTS_PTS1_MASK                   2U
#define PTS_PTS4_MASK                   16U
#define PTS_PTS5_MASK                   32U
#define PTS_PTS6_MASK                   64U
#define PTS_PTS_MASK                    3U
#define PTS_PTS_BITNUM                  0U
#define PTS_PTS_4_MASK                  112U
#define PTS_PTS_4_BITNUM                4U


/*** PTIS - Port S Input Register; 0x00000209 ***/
typedef union {
  byte Byte;
  struct {
    byte PTIS0       :1;                                       /* Port S Bit 0 */
    byte PTIS1       :1;                                       /* Port S Bit 1 */
    byte             :1; 
    byte             :1; 
    byte PTIS4       :1;                                       /* Port S Bit 4 */
    byte PTIS5       :1;                                       /* Port S Bit 5 */
    byte PTIS6       :1;                                       /* Port S Bit 6 */
    byte             :1; 
  } Bits;
  struct {
    byte grpPTIS :2;
    byte         :1;
    byte         :1;
    byte grpPTIS_4 :3;
    byte         :1;
  } MergedBits;
} PTISSTR;
extern volatile PTISSTR _PTIS @(REG_BASE + 0x00000209UL);
#define PTIS                            _PTIS.Byte
#define PTIS_PTIS0                      _PTIS.Bits.PTIS0
#define PTIS_PTIS1                      _PTIS.Bits.PTIS1
#define PTIS_PTIS4                      _PTIS.Bits.PTIS4
#define PTIS_PTIS5                      _PTIS.Bits.PTIS5
#define PTIS_PTIS6                      _PTIS.Bits.PTIS6
#define PTIS_PTIS                       _PTIS.MergedBits.grpPTIS
#define PTIS_PTIS_4                     _PTIS.MergedBits.grpPTIS_4

#define PTIS_PTIS0_MASK                 1U
#define PTIS_PTIS1_MASK                 2U
#define PTIS_PTIS4_MASK                 16U
#define PTIS_PTIS5_MASK                 32U
#define PTIS_PTIS6_MASK                 64U
#define PTIS_PTIS_MASK                  3U
#define PTIS_PTIS_BITNUM                0U
#define PTIS_PTIS_4_MASK                112U
#define PTIS_PTIS_4_BITNUM              4U


/*** DDRS - Port S Data Direction Register; 0x0000020A ***/
typedef union {
  byte Byte;
  struct {
    byte DDRS0       :1;                                       /* Data Direction Port S Bit 0 */
    byte DDRS1       :1;                                       /* Data Direction Port S Bit 1 */
    byte             :1; 
    byte             :1; 
    byte DDRS4       :1;                                       /* Data Direction Port S Bit 4 */
    byte DDRS5       :1;                                       /* Data Direction Port S Bit 5 */
    byte DDRS6       :1;                                       /* Data Direction Port S Bit 6 */
    byte             :1; 
  } Bits;
  struct {
    byte grpDDRS :2;
    byte         :1;
    byte         :1;
    byte grpDDRS_4 :3;
    byte         :1;
  } MergedBits;
} DDRSSTR;
extern volatile DDRSSTR _DDRS @(REG_BASE + 0x0000020AUL);
#define DDRS                            _DDRS.Byte
#define DDRS_DDRS0                      _DDRS.Bits.DDRS0
#define DDRS_DDRS1                      _DDRS.Bits.DDRS1
#define DDRS_DDRS4                      _DDRS.Bits.DDRS4
#define DDRS_DDRS5                      _DDRS.Bits.DDRS5
#define DDRS_DDRS6                      _DDRS.Bits.DDRS6
#define DDRS_DDRS                       _DDRS.MergedBits.grpDDRS
#define DDRS_DDRS_4                     _DDRS.MergedBits.grpDDRS_4

#define DDRS_DDRS0_MASK                 1U
#define DDRS_DDRS1_MASK                 2U
#define DDRS_DDRS4_MASK                 16U
#define DDRS_DDRS5_MASK                 32U
#define DDRS_DDRS6_MASK                 64U
#define DDRS_DDRS_MASK                  3U
#define DDRS_DDRS_BITNUM                0U
#define DDRS_DDRS_4_MASK                112U
#define DDRS_DDRS_4_BITNUM              4U


/*** RDRS - Port S Reduced Drive Register; 0x0000020B ***/
typedef union {
  byte Byte;
  struct {
    byte RDRS0       :1;                                       /* Reduced Drive Port S Bit 0 */
    byte RDRS1       :1;                                       /* Reduced Drive Port S Bit 1 */
    byte             :1; 
    byte             :1; 
    byte RDRS4       :1;                                       /* Reduced Drive Port S Bit 4 */
    byte RDRS5       :1;                                       /* Reduced Drive Port S Bit 5 */
    byte RDRS6       :1;                                       /* Reduced Drive Port S Bit 6 */
    byte             :1; 
  } Bits;
  struct {
    byte grpRDRS :2;
    byte         :1;
    byte         :1;
    byte grpRDRS_4 :3;
    byte         :1;
  } MergedBits;
} RDRSSTR;
extern volatile RDRSSTR _RDRS @(REG_BASE + 0x0000020BUL);
#define RDRS                            _RDRS.Byte
#define RDRS_RDRS0                      _RDRS.Bits.RDRS0
#define RDRS_RDRS1                      _RDRS.Bits.RDRS1
#define RDRS_RDRS4                      _RDRS.Bits.RDRS4
#define RDRS_RDRS5                      _RDRS.Bits.RDRS5
#define RDRS_RDRS6                      _RDRS.Bits.RDRS6
#define RDRS_RDRS                       _RDRS.MergedBits.grpRDRS
#define RDRS_RDRS_4                     _RDRS.MergedBits.grpRDRS_4

#define RDRS_RDRS0_MASK                 1U
#define RDRS_RDRS1_MASK                 2U
#define RDRS_RDRS4_MASK                 16U
#define RDRS_RDRS5_MASK                 32U
#define RDRS_RDRS6_MASK                 64U
#define RDRS_RDRS_MASK                  3U
#define RDRS_RDRS_BITNUM                0U
#define RDRS_RDRS_4_MASK                112U
#define RDRS_RDRS_4_BITNUM              4U


/*** PERS - Port S Pull Device Enable Register; 0x0000020C ***/
typedef union {
  byte Byte;
  struct {
    byte PERS0       :1;                                       /* Pull Device Enable Port S Bit 0 */
    byte PERS1       :1;                                       /* Pull Device Enable Port S Bit 1 */
    byte             :1; 
    byte             :1; 
    byte PERS4       :1;                                       /* Pull Device Enable Port S Bit 4 */
    byte PERS5       :1;                                       /* Pull Device Enable Port S Bit 5 */
    byte PERS6       :1;                                       /* Pull Device Enable Port S Bit 6 */
    byte             :1; 
  } Bits;
  struct {
    byte grpPERS :2;
    byte         :1;
    byte         :1;
    byte grpPERS_4 :3;
    byte         :1;
  } MergedBits;
} PERSSTR;
extern volatile PERSSTR _PERS @(REG_BASE + 0x0000020CUL);
#define PERS                            _PERS.Byte
#define PERS_PERS0                      _PERS.Bits.PERS0
#define PERS_PERS1                      _PERS.Bits.PERS1
#define PERS_PERS4                      _PERS.Bits.PERS4
#define PERS_PERS5                      _PERS.Bits.PERS5
#define PERS_PERS6                      _PERS.Bits.PERS6
#define PERS_PERS                       _PERS.MergedBits.grpPERS
#define PERS_PERS_4                     _PERS.MergedBits.grpPERS_4

#define PERS_PERS0_MASK                 1U
#define PERS_PERS1_MASK                 2U
#define PERS_PERS4_MASK                 16U
#define PERS_PERS5_MASK                 32U
#define PERS_PERS6_MASK                 64U
#define PERS_PERS_MASK                  3U
#define PERS_PERS_BITNUM                0U
#define PERS_PERS_4_MASK                112U
#define PERS_PERS_4_BITNUM              4U


/*** PPSS - Port S Polarity Select Register; 0x0000020D ***/
typedef union {
  byte Byte;
  struct {
    byte PPSS0       :1;                                       /* Pull Select Port S Bit 0 */
    byte PPSS1       :1;                                       /* Pull Select Port S Bit 1 */
    byte             :1; 
    byte             :1; 
    byte PPSS4       :1;                                       /* Pull Select Port S Bit 4 */
    byte PPSS5       :1;                                       /* Pull Select Port S Bit 5 */
    byte PPSS6       :1;                                       /* Pull Select Port S Bit 6 */
    byte             :1; 
  } Bits;
  struct {
    byte grpPPSS :2;
    byte         :1;
    byte         :1;
    byte grpPPSS_4 :3;
    byte         :1;
  } MergedBits;
} PPSSSTR;
extern volatile PPSSSTR _PPSS @(REG_BASE + 0x0000020DUL);
#define PPSS                            _PPSS.Byte
#define PPSS_PPSS0                      _PPSS.Bits.PPSS0
#define PPSS_PPSS1                      _PPSS.Bits.PPSS1
#define PPSS_PPSS4                      _PPSS.Bits.PPSS4
#define PPSS_PPSS5                      _PPSS.Bits.PPSS5
#define PPSS_PPSS6                      _PPSS.Bits.PPSS6
#define PPSS_PPSS                       _PPSS.MergedBits.grpPPSS
#define PPSS_PPSS_4                     _PPSS.MergedBits.grpPPSS_4

#define PPSS_PPSS0_MASK                 1U
#define PPSS_PPSS1_MASK                 2U
#define PPSS_PPSS4_MASK                 16U
#define PPSS_PPSS5_MASK                 32U
#define PPSS_PPSS6_MASK                 64U
#define PPSS_PPSS_MASK                  3U
#define PPSS_PPSS_BITNUM                0U
#define PPSS_PPSS_4_MASK                112U
#define PPSS_PPSS_4_BITNUM              4U


/*** WOMS - Port S Wired-Or Mode Register; 0x0000020E ***/
typedef union {
  byte Byte;
  struct {
    byte WOMS0       :1;                                       /* Wired-Or Mode Port S Bit 0 */
    byte WOMS1       :1;                                       /* Wired-Or Mode Port S Bit 1 */
    byte             :1; 
    byte             :1; 
    byte WOMS4       :1;                                       /* Wired-Or Mode Port S Bit 4 */
    byte WOMS5       :1;                                       /* Wired-Or Mode Port S Bit 5 */
    byte WOMS6       :1;                                       /* Wired-Or Mode Port S Bit 6 */
    byte             :1; 
  } Bits;
  struct {
    byte grpWOMS :2;
    byte         :1;
    byte         :1;
    byte grpWOMS_4 :3;
    byte         :1;
  } MergedBits;
} WOMSSTR;
extern volatile WOMSSTR _WOMS @(REG_BASE + 0x0000020EUL);
#define WOMS                            _WOMS.Byte
#define WOMS_WOMS0                      _WOMS.Bits.WOMS0
#define WOMS_WOMS1                      _WOMS.Bits.WOMS1
#define WOMS_WOMS4                      _WOMS.Bits.WOMS4
#define WOMS_WOMS5                      _WOMS.Bits.WOMS5
#define WOMS_WOMS6                      _WOMS.Bits.WOMS6
#define WOMS_WOMS                       _WOMS.MergedBits.grpWOMS
#define WOMS_WOMS_4                     _WOMS.MergedBits.grpWOMS_4

#define WOMS_WOMS0_MASK                 1U
#define WOMS_WOMS1_MASK                 2U
#define WOMS_WOMS4_MASK                 16U
#define WOMS_WOMS5_MASK                 32U
#define WOMS_WOMS6_MASK                 64U
#define WOMS_WOMS_MASK                  3U
#define WOMS_WOMS_BITNUM                0U
#define WOMS_WOMS_4_MASK                112U
#define WOMS_WOMS_4_BITNUM              4U


/*** PTM - Port M I/O Register; 0x00000210 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte PTM2        :1;                                       /* Port M Bit 2 */
    byte PTM3        :1;                                       /* Port M Bit 3 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte grpPTM_2 :2;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} PTMSTR;
extern volatile PTMSTR _PTM @(REG_BASE + 0x00000210UL);
#define PTM                             _PTM.Byte
#define PTM_PTM2                        _PTM.Bits.PTM2
#define PTM_PTM3                        _PTM.Bits.PTM3
#define PTM_PTM_2                       _PTM.MergedBits.grpPTM_2

#define PTM_PTM2_MASK                   4U
#define PTM_PTM3_MASK                   8U
#define PTM_PTM_2_MASK                  12U
#define PTM_PTM_2_BITNUM                2U


/*** PTIM - Port M Input Register; 0x00000211 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte PTIM2       :1;                                       /* Port M Bit 2 */
    byte PTIM3       :1;                                       /* Port M Bit 3 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte grpPTIM_2 :2;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} PTIMSTR;
extern volatile PTIMSTR _PTIM @(REG_BASE + 0x00000211UL);
#define PTIM                            _PTIM.Byte
#define PTIM_PTIM2                      _PTIM.Bits.PTIM2
#define PTIM_PTIM3                      _PTIM.Bits.PTIM3
#define PTIM_PTIM_2                     _PTIM.MergedBits.grpPTIM_2

#define PTIM_PTIM2_MASK                 4U
#define PTIM_PTIM3_MASK                 8U
#define PTIM_PTIM_2_MASK                12U
#define PTIM_PTIM_2_BITNUM              2U


/*** DDRM - Port M Data Direction Register; 0x00000212 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte DDRM2       :1;                                       /* Data Direction Port M Bit 2 */
    byte DDRM3       :1;                                       /* Data Direction Port M Bit 3 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte grpDDRM_2 :2;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} DDRMSTR;
extern volatile DDRMSTR _DDRM @(REG_BASE + 0x00000212UL);
#define DDRM                            _DDRM.Byte
#define DDRM_DDRM2                      _DDRM.Bits.DDRM2
#define DDRM_DDRM3                      _DDRM.Bits.DDRM3
#define DDRM_DDRM_2                     _DDRM.MergedBits.grpDDRM_2

#define DDRM_DDRM2_MASK                 4U
#define DDRM_DDRM3_MASK                 8U
#define DDRM_DDRM_2_MASK                12U
#define DDRM_DDRM_2_BITNUM              2U


/*** RDRM - Port M Reduced Drive Register; 0x00000213 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte RDRM2       :1;                                       /* Reduced Drive Port M Bit 2 */
    byte RDRM3       :1;                                       /* Reduced Drive Port M Bit 3 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte grpRDRM_2 :2;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} RDRMSTR;
extern volatile RDRMSTR _RDRM @(REG_BASE + 0x00000213UL);
#define RDRM                            _RDRM.Byte
#define RDRM_RDRM2                      _RDRM.Bits.RDRM2
#define RDRM_RDRM3                      _RDRM.Bits.RDRM3
#define RDRM_RDRM_2                     _RDRM.MergedBits.grpRDRM_2

#define RDRM_RDRM2_MASK                 4U
#define RDRM_RDRM3_MASK                 8U
#define RDRM_RDRM_2_MASK                12U
#define RDRM_RDRM_2_BITNUM              2U


/*** PERM - Port M Pull Device Enable Register; 0x00000214 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte PERM2       :1;                                       /* Pull Device Enable Port M Bit 2 */
    byte PERM3       :1;                                       /* Pull Device Enable Port M Bit 3 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte grpPERM_2 :2;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} PERMSTR;
extern volatile PERMSTR _PERM @(REG_BASE + 0x00000214UL);
#define PERM                            _PERM.Byte
#define PERM_PERM2                      _PERM.Bits.PERM2
#define PERM_PERM3                      _PERM.Bits.PERM3
#define PERM_PERM_2                     _PERM.MergedBits.grpPERM_2

#define PERM_PERM2_MASK                 4U
#define PERM_PERM3_MASK                 8U
#define PERM_PERM_2_MASK                12U
#define PERM_PERM_2_BITNUM              2U


/*** PPSM - Port M Polarity Select Register; 0x00000215 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte PPSM2       :1;                                       /* Pull Select Port M Bit 2 */
    byte PPSM3       :1;                                       /* Pull Select Port M Bit 3 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte grpPPSM_2 :2;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} PPSMSTR;
extern volatile PPSMSTR _PPSM @(REG_BASE + 0x00000215UL);
#define PPSM                            _PPSM.Byte
#define PPSM_PPSM2                      _PPSM.Bits.PPSM2
#define PPSM_PPSM3                      _PPSM.Bits.PPSM3
#define PPSM_PPSM_2                     _PPSM.MergedBits.grpPPSM_2

#define PPSM_PPSM2_MASK                 4U
#define PPSM_PPSM3_MASK                 8U
#define PPSM_PPSM_2_MASK                12U
#define PPSM_PPSM_2_BITNUM              2U


/*** WOMM - Port M Wired-Or Mode Register; 0x00000216 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte WOMM2       :1;                                       /* Wired-Or Mode Port M Bit 2 */
    byte WOMM3       :1;                                       /* Wired-Or Mode Port M Bit 3 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte grpWOMM_2 :2;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} WOMMSTR;
extern volatile WOMMSTR _WOMM @(REG_BASE + 0x00000216UL);
#define WOMM                            _WOMM.Byte
#define WOMM_WOMM2                      _WOMM.Bits.WOMM2
#define WOMM_WOMM3                      _WOMM.Bits.WOMM3
#define WOMM_WOMM_2                     _WOMM.MergedBits.grpWOMM_2

#define WOMM_WOMM2_MASK                 4U
#define WOMM_WOMM3_MASK                 8U
#define WOMM_WOMM_2_MASK                12U
#define WOMM_WOMM_2_BITNUM              2U


/*** PTP - Port P I/O Register; 0x00000218 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte PTP1        :1;                                       /* Port P Bit 1 */
    byte             :1; 
    byte PTP3        :1;                                       /* Port P Bit 3 */
    byte PTP4        :1;                                       /* Port P Bit 4 */
    byte PTP5        :1;                                       /* Port P Bit 5 */
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte         :1;
    byte grpPTP_1 :1;
    byte         :1;
    byte grpPTP_3 :3;
    byte         :1;
    byte         :1;
  } MergedBits;
} PTPSTR;
extern volatile PTPSTR _PTP @(REG_BASE + 0x00000218UL);
#define PTP                             _PTP.Byte
#define PTP_PTP1                        _PTP.Bits.PTP1
#define PTP_PTP3                        _PTP.Bits.PTP3
#define PTP_PTP4                        _PTP.Bits.PTP4
#define PTP_PTP5                        _PTP.Bits.PTP5
#define PTP_PTP_3                       _PTP.MergedBits.grpPTP_3

#define PTP_PTP1_MASK                   2U
#define PTP_PTP3_MASK                   8U
#define PTP_PTP4_MASK                   16U
#define PTP_PTP5_MASK                   32U
#define PTP_PTP_3_MASK                  56U
#define PTP_PTP_3_BITNUM                3U


/*** PTIP - Port P Input Register; 0x00000219 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte PTIP1       :1;                                       /* Port P Bit 1 */
    byte             :1; 
    byte PTIP3       :1;                                       /* Port P Bit 3 */
    byte PTIP4       :1;                                       /* Port P Bit 4 */
    byte PTIP5       :1;                                       /* Port P Bit 5 */
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte         :1;
    byte grpPTIP_1 :1;
    byte         :1;
    byte grpPTIP_3 :3;
    byte         :1;
    byte         :1;
  } MergedBits;
} PTIPSTR;
extern volatile PTIPSTR _PTIP @(REG_BASE + 0x00000219UL);
#define PTIP                            _PTIP.Byte
#define PTIP_PTIP1                      _PTIP.Bits.PTIP1
#define PTIP_PTIP3                      _PTIP.Bits.PTIP3
#define PTIP_PTIP4                      _PTIP.Bits.PTIP4
#define PTIP_PTIP5                      _PTIP.Bits.PTIP5
#define PTIP_PTIP_3                     _PTIP.MergedBits.grpPTIP_3

#define PTIP_PTIP1_MASK                 2U
#define PTIP_PTIP3_MASK                 8U
#define PTIP_PTIP4_MASK                 16U
#define PTIP_PTIP5_MASK                 32U
#define PTIP_PTIP_3_MASK                56U
#define PTIP_PTIP_3_BITNUM              3U


/*** DDRP - Port P Data Direction Register; 0x0000021A ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte DDRP1       :1;                                       /* Data Direction Port P Bit 1 */
    byte             :1; 
    byte DDRP3       :1;                                       /* Data Direction Port P Bit 3 */
    byte DDRP4       :1;                                       /* Data Direction Port P Bit 4 */
    byte DDRP5       :1;                                       /* Data Direction Port P Bit 5 */
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte         :1;
    byte grpDDRP_1 :1;
    byte         :1;
    byte grpDDRP_3 :3;
    byte         :1;
    byte         :1;
  } MergedBits;
} DDRPSTR;
extern volatile DDRPSTR _DDRP @(REG_BASE + 0x0000021AUL);
#define DDRP                            _DDRP.Byte
#define DDRP_DDRP1                      _DDRP.Bits.DDRP1
#define DDRP_DDRP3                      _DDRP.Bits.DDRP3
#define DDRP_DDRP4                      _DDRP.Bits.DDRP4
#define DDRP_DDRP5                      _DDRP.Bits.DDRP5
#define DDRP_DDRP_3                     _DDRP.MergedBits.grpDDRP_3

#define DDRP_DDRP1_MASK                 2U
#define DDRP_DDRP3_MASK                 8U
#define DDRP_DDRP4_MASK                 16U
#define DDRP_DDRP5_MASK                 32U
#define DDRP_DDRP_3_MASK                56U
#define DDRP_DDRP_3_BITNUM              3U


/*** RDRP - Port P Reduced Drive Register; 0x0000021B ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte RDRP1       :1;                                       /* Reduced Drive Port P Bit 1 */
    byte             :1; 
    byte RDRP3       :1;                                       /* Reduced Drive Port P Bit 3 */
    byte RDRP4       :1;                                       /* Reduced Drive Port P Bit 4 */
    byte RDRP5       :1;                                       /* Reduced Drive Port P Bit 5 */
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte         :1;
    byte grpRDRP_1 :1;
    byte         :1;
    byte grpRDRP_3 :3;
    byte         :1;
    byte         :1;
  } MergedBits;
} RDRPSTR;
extern volatile RDRPSTR _RDRP @(REG_BASE + 0x0000021BUL);
#define RDRP                            _RDRP.Byte
#define RDRP_RDRP1                      _RDRP.Bits.RDRP1
#define RDRP_RDRP3                      _RDRP.Bits.RDRP3
#define RDRP_RDRP4                      _RDRP.Bits.RDRP4
#define RDRP_RDRP5                      _RDRP.Bits.RDRP5
#define RDRP_RDRP_3                     _RDRP.MergedBits.grpRDRP_3

#define RDRP_RDRP1_MASK                 2U
#define RDRP_RDRP3_MASK                 8U
#define RDRP_RDRP4_MASK                 16U
#define RDRP_RDRP5_MASK                 32U
#define RDRP_RDRP_3_MASK                56U
#define RDRP_RDRP_3_BITNUM              3U


/*** PERP - Port P Pull Device Enable Register; 0x0000021C ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte PERP1       :1;                                       /* Pull Device Enable Port P Bit 1 */
    byte             :1; 
    byte PERP3       :1;                                       /* Pull Device Enable Port P Bit 3 */
    byte PERP4       :1;                                       /* Pull Device Enable Port P Bit 4 */
    byte PERP5       :1;                                       /* Pull Device Enable Port P Bit 5 */
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte         :1;
    byte grpPERP_1 :1;
    byte         :1;
    byte grpPERP_3 :3;
    byte         :1;
    byte         :1;
  } MergedBits;
} PERPSTR;
extern volatile PERPSTR _PERP @(REG_BASE + 0x0000021CUL);
#define PERP                            _PERP.Byte
#define PERP_PERP1                      _PERP.Bits.PERP1
#define PERP_PERP3                      _PERP.Bits.PERP3
#define PERP_PERP4                      _PERP.Bits.PERP4
#define PERP_PERP5                      _PERP.Bits.PERP5
#define PERP_PERP_3                     _PERP.MergedBits.grpPERP_3

#define PERP_PERP1_MASK                 2U
#define PERP_PERP3_MASK                 8U
#define PERP_PERP4_MASK                 16U
#define PERP_PERP5_MASK                 32U
#define PERP_PERP_3_MASK                56U
#define PERP_PERP_3_BITNUM              3U


/*** PPSP - Port P Polarity Select Register; 0x0000021D ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte PPSP1       :1;                                       /* Pull Select Port P Bit 1 */
    byte             :1; 
    byte PPSP3       :1;                                       /* Pull Select Port P Bit 3 */
    byte PPSP4       :1;                                       /* Pull Select Port P Bit 4 */
    byte PPSP5       :1;                                       /* Pull Select Port P Bit 5 */
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte         :1;
    byte grpPPSP_1 :1;
    byte         :1;
    byte grpPPSP_3 :3;
    byte         :1;
    byte         :1;
  } MergedBits;
} PPSPSTR;
extern volatile PPSPSTR _PPSP @(REG_BASE + 0x0000021DUL);
#define PPSP                            _PPSP.Byte
#define PPSP_PPSP1                      _PPSP.Bits.PPSP1
#define PPSP_PPSP3                      _PPSP.Bits.PPSP3
#define PPSP_PPSP4                      _PPSP.Bits.PPSP4
#define PPSP_PPSP5                      _PPSP.Bits.PPSP5
#define PPSP_PPSP_3                     _PPSP.MergedBits.grpPPSP_3

#define PPSP_PPSP1_MASK                 2U
#define PPSP_PPSP3_MASK                 8U
#define PPSP_PPSP4_MASK                 16U
#define PPSP_PPSP5_MASK                 32U
#define PPSP_PPSP_3_MASK                56U
#define PPSP_PPSP_3_BITNUM              3U


/*** WOMP - Port P Wired-OR Mode Register; 0x0000021E ***/
typedef union {
  byte Byte;
  struct {
    byte WOMP0       :1;                                       /* Wired-OR Mode Port P Bit 0 */
    byte             :1; 
    byte WOMP2       :1;                                       /* Wired-OR Mode Port P Bit 2 */
    byte             :1; 
    byte WOMP4       :1;                                       /* Wired-OR Mode Port P Bit 4 */
    byte WOMP5       :1;                                       /* Wired-OR Mode Port P Bit 5 */
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpWOMP :1;
    byte         :1;
    byte grpWOMP_2 :1;
    byte         :1;
    byte grpWOMP_4 :2;
    byte         :1;
    byte         :1;
  } MergedBits;
} WOMPSTR;
extern volatile WOMPSTR _WOMP @(REG_BASE + 0x0000021EUL);
#define WOMP                            _WOMP.Byte
#define WOMP_WOMP0                      _WOMP.Bits.WOMP0
#define WOMP_WOMP2                      _WOMP.Bits.WOMP2
#define WOMP_WOMP4                      _WOMP.Bits.WOMP4
#define WOMP_WOMP5                      _WOMP.Bits.WOMP5
#define WOMP_WOMP_4                     _WOMP.MergedBits.grpWOMP_4

#define WOMP_WOMP0_MASK                 1U
#define WOMP_WOMP2_MASK                 4U
#define WOMP_WOMP4_MASK                 16U
#define WOMP_WOMP5_MASK                 32U
#define WOMP_WOMP_4_MASK                48U
#define WOMP_WOMP_4_BITNUM              4U


/*** PTL - Port L I/O Register; 0x00000230 ***/
typedef union {
  byte Byte;
  struct {
    byte PTL0        :1;                                       /* Port L Bit 0 */
    byte PTL1        :1;                                       /* Port L Bit 1 */
    byte PTL2        :1;                                       /* Port L Bit 2 */
    byte PTL3        :1;                                       /* Port L Bit 3 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpPTL  :4;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} PTLSTR;
extern volatile PTLSTR _PTL @(REG_BASE + 0x00000230UL);
#define PTL                             _PTL.Byte
#define PTL_PTL0                        _PTL.Bits.PTL0
#define PTL_PTL1                        _PTL.Bits.PTL1
#define PTL_PTL2                        _PTL.Bits.PTL2
#define PTL_PTL3                        _PTL.Bits.PTL3
#define PTL_PTL                         _PTL.MergedBits.grpPTL

#define PTL_PTL0_MASK                   1U
#define PTL_PTL1_MASK                   2U
#define PTL_PTL2_MASK                   4U
#define PTL_PTL3_MASK                   8U
#define PTL_PTL_MASK                    15U
#define PTL_PTL_BITNUM                  0U


/*** PTIL - Port L Input Register; 0x00000231 ***/
typedef union {
  byte Byte;
  struct {
    byte PTIL0       :1;                                       /* Port L Bit 0 */
    byte PTIL1       :1;                                       /* Port L Bit 1 */
    byte PTIL2       :1;                                       /* Port L Bit 2 */
    byte PTIL3       :1;                                       /* Port L Bit 3 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpPTIL :4;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} PTILSTR;
extern volatile PTILSTR _PTIL @(REG_BASE + 0x00000231UL);
#define PTIL                            _PTIL.Byte
#define PTIL_PTIL0                      _PTIL.Bits.PTIL0
#define PTIL_PTIL1                      _PTIL.Bits.PTIL1
#define PTIL_PTIL2                      _PTIL.Bits.PTIL2
#define PTIL_PTIL3                      _PTIL.Bits.PTIL3
#define PTIL_PTIL                       _PTIL.MergedBits.grpPTIL

#define PTIL_PTIL0_MASK                 1U
#define PTIL_PTIL1_MASK                 2U
#define PTIL_PTIL2_MASK                 4U
#define PTIL_PTIL3_MASK                 8U
#define PTIL_PTIL_MASK                  15U
#define PTIL_PTIL_BITNUM                0U


/*** DDRL - Port L Data Direction Register; 0x00000232 ***/
typedef union {
  byte Byte;
  struct {
    byte DDRL0       :1;                                       /* Data Direction Port L Bit 0 */
    byte DDRL1       :1;                                       /* Data Direction Port L Bit 1 */
    byte DDRL2       :1;                                       /* Data Direction Port L Bit 2 */
    byte DDRL3       :1;                                       /* Data Direction Port L Bit 3 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpDDRL :4;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} DDRLSTR;
extern volatile DDRLSTR _DDRL @(REG_BASE + 0x00000232UL);
#define DDRL                            _DDRL.Byte
#define DDRL_DDRL0                      _DDRL.Bits.DDRL0
#define DDRL_DDRL1                      _DDRL.Bits.DDRL1
#define DDRL_DDRL2                      _DDRL.Bits.DDRL2
#define DDRL_DDRL3                      _DDRL.Bits.DDRL3
#define DDRL_DDRL                       _DDRL.MergedBits.grpDDRL

#define DDRL_DDRL0_MASK                 1U
#define DDRL_DDRL1_MASK                 2U
#define DDRL_DDRL2_MASK                 4U
#define DDRL_DDRL3_MASK                 8U
#define DDRL_DDRL_MASK                  15U
#define DDRL_DDRL_BITNUM                0U


/*** RDRL - Port L Reduced Drive Register; 0x00000233 ***/
typedef union {
  byte Byte;
  struct {
    byte RDRL0       :1;                                       /* Reduced Drive Port L Bit 0 */
    byte RDRL1       :1;                                       /* Reduced Drive Port L Bit 1 */
    byte RDRL2       :1;                                       /* Reduced Drive Port L Bit 2 */
    byte RDRL3       :1;                                       /* Reduced Drive Port L Bit 3 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpRDRL :4;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} RDRLSTR;
extern volatile RDRLSTR _RDRL @(REG_BASE + 0x00000233UL);
#define RDRL                            _RDRL.Byte
#define RDRL_RDRL0                      _RDRL.Bits.RDRL0
#define RDRL_RDRL1                      _RDRL.Bits.RDRL1
#define RDRL_RDRL2                      _RDRL.Bits.RDRL2
#define RDRL_RDRL3                      _RDRL.Bits.RDRL3
#define RDRL_RDRL                       _RDRL.MergedBits.grpRDRL

#define RDRL_RDRL0_MASK                 1U
#define RDRL_RDRL1_MASK                 2U
#define RDRL_RDRL2_MASK                 4U
#define RDRL_RDRL3_MASK                 8U
#define RDRL_RDRL_MASK                  15U
#define RDRL_RDRL_BITNUM                0U


/*** PERL - Port L Pull Device Enable Register; 0x00000234 ***/
typedef union {
  byte Byte;
  struct {
    byte PERL0       :1;                                       /* Pull Device Enable Port L Bit 0 */
    byte PERL1       :1;                                       /* Pull Device Enable Port L Bit 1 */
    byte PERL2       :1;                                       /* Pull Device Enable Port L Bit 2 */
    byte PERL3       :1;                                       /* Pull Device Enable Port L Bit 3 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpPERL :4;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} PERLSTR;
extern volatile PERLSTR _PERL @(REG_BASE + 0x00000234UL);
#define PERL                            _PERL.Byte
#define PERL_PERL0                      _PERL.Bits.PERL0
#define PERL_PERL1                      _PERL.Bits.PERL1
#define PERL_PERL2                      _PERL.Bits.PERL2
#define PERL_PERL3                      _PERL.Bits.PERL3
#define PERL_PERL                       _PERL.MergedBits.grpPERL

#define PERL_PERL0_MASK                 1U
#define PERL_PERL1_MASK                 2U
#define PERL_PERL2_MASK                 4U
#define PERL_PERL3_MASK                 8U
#define PERL_PERL_MASK                  15U
#define PERL_PERL_BITNUM                0U


/*** PPSL - Port L Polarity Select Register; 0x00000235 ***/
typedef union {
  byte Byte;
  struct {
    byte PPSL0       :1;                                       /* Pull Select Port L Bit 0 */
    byte PPSL1       :1;                                       /* Pull Select Port L Bit 1 */
    byte PPSL2       :1;                                       /* Pull Select Port L Bit 2 */
    byte PPSL3       :1;                                       /* Pull Select Port L Bit 3 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpPPSL :4;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} PPSLSTR;
extern volatile PPSLSTR _PPSL @(REG_BASE + 0x00000235UL);
#define PPSL                            _PPSL.Byte
#define PPSL_PPSL0                      _PPSL.Bits.PPSL0
#define PPSL_PPSL1                      _PPSL.Bits.PPSL1
#define PPSL_PPSL2                      _PPSL.Bits.PPSL2
#define PPSL_PPSL3                      _PPSL.Bits.PPSL3
#define PPSL_PPSL                       _PPSL.MergedBits.grpPPSL

#define PPSL_PPSL0_MASK                 1U
#define PPSL_PPSL1_MASK                 2U
#define PPSL_PPSL2_MASK                 4U
#define PPSL_PPSL3_MASK                 8U
#define PPSL_PPSL_MASK                  15U
#define PPSL_PPSL_BITNUM                0U


/*** PTU - Port U I/O Register; 0x00000238 ***/
typedef union {
  byte Byte;
  struct {
    byte PTU0        :1;                                       /* Port U Bit 0 */
    byte PTU1        :1;                                       /* Port U Bit 1 */
    byte PTU2        :1;                                       /* Port U Bit 2 */
    byte PTU3        :1;                                       /* Port U Bit 3 */
    byte PTU4        :1;                                       /* Port U Bit 4 */
    byte PTU5        :1;                                       /* Port U Bit 5 */
    byte PTU6        :1;                                       /* Port U Bit 6 */
    byte PTU7        :1;                                       /* Port U Bit 7 */
  } Bits;
} PTUSTR;
extern volatile PTUSTR _PTU @(REG_BASE + 0x00000238UL);
#define PTU                             _PTU.Byte
#define PTU_PTU0                        _PTU.Bits.PTU0
#define PTU_PTU1                        _PTU.Bits.PTU1
#define PTU_PTU2                        _PTU.Bits.PTU2
#define PTU_PTU3                        _PTU.Bits.PTU3
#define PTU_PTU4                        _PTU.Bits.PTU4
#define PTU_PTU5                        _PTU.Bits.PTU5
#define PTU_PTU6                        _PTU.Bits.PTU6
#define PTU_PTU7                        _PTU.Bits.PTU7

#define PTU_PTU0_MASK                   1U
#define PTU_PTU1_MASK                   2U
#define PTU_PTU2_MASK                   4U
#define PTU_PTU3_MASK                   8U
#define PTU_PTU4_MASK                   16U
#define PTU_PTU5_MASK                   32U
#define PTU_PTU6_MASK                   64U
#define PTU_PTU7_MASK                   128U


/*** PTIU - Port U Input Register; 0x00000239 ***/
typedef union {
  byte Byte;
  struct {
    byte PTIU0       :1;                                       /* Port U Bit 0 */
    byte PTIU1       :1;                                       /* Port U Bit 1 */
    byte PTIU2       :1;                                       /* Port U Bit 2 */
    byte PTIU3       :1;                                       /* Port U Bit 3 */
    byte PTIU4       :1;                                       /* Port U Bit 4 */
    byte PTIU5       :1;                                       /* Port U Bit 5 */
    byte PTIU6       :1;                                       /* Port U Bit 6 */
    byte PTIU7       :1;                                       /* Port U Bit 7 */
  } Bits;
} PTIUSTR;
extern volatile PTIUSTR _PTIU @(REG_BASE + 0x00000239UL);
#define PTIU                            _PTIU.Byte
#define PTIU_PTIU0                      _PTIU.Bits.PTIU0
#define PTIU_PTIU1                      _PTIU.Bits.PTIU1
#define PTIU_PTIU2                      _PTIU.Bits.PTIU2
#define PTIU_PTIU3                      _PTIU.Bits.PTIU3
#define PTIU_PTIU4                      _PTIU.Bits.PTIU4
#define PTIU_PTIU5                      _PTIU.Bits.PTIU5
#define PTIU_PTIU6                      _PTIU.Bits.PTIU6
#define PTIU_PTIU7                      _PTIU.Bits.PTIU7

#define PTIU_PTIU0_MASK                 1U
#define PTIU_PTIU1_MASK                 2U
#define PTIU_PTIU2_MASK                 4U
#define PTIU_PTIU3_MASK                 8U
#define PTIU_PTIU4_MASK                 16U
#define PTIU_PTIU5_MASK                 32U
#define PTIU_PTIU6_MASK                 64U
#define PTIU_PTIU7_MASK                 128U


/*** DDRU - Port U Data Direction Register; 0x0000023A ***/
typedef union {
  byte Byte;
  struct {
    byte DDRU0       :1;                                       /* Data Direction Port U Bit 0 */
    byte DDRU1       :1;                                       /* Data Direction Port U Bit 1 */
    byte DDRU2       :1;                                       /* Data Direction Port U Bit 2 */
    byte DDRU3       :1;                                       /* Data Direction Port U Bit 3 */
    byte DDRU4       :1;                                       /* Data Direction Port U Bit 4 */
    byte DDRU5       :1;                                       /* Data Direction Port U Bit 5 */
    byte DDRU6       :1;                                       /* Data Direction Port U Bit 6 */
    byte DDRU7       :1;                                       /* Data Direction Port U Bit 7 */
  } Bits;
} DDRUSTR;
extern volatile DDRUSTR _DDRU @(REG_BASE + 0x0000023AUL);
#define DDRU                            _DDRU.Byte
#define DDRU_DDRU0                      _DDRU.Bits.DDRU0
#define DDRU_DDRU1                      _DDRU.Bits.DDRU1
#define DDRU_DDRU2                      _DDRU.Bits.DDRU2
#define DDRU_DDRU3                      _DDRU.Bits.DDRU3
#define DDRU_DDRU4                      _DDRU.Bits.DDRU4
#define DDRU_DDRU5                      _DDRU.Bits.DDRU5
#define DDRU_DDRU6                      _DDRU.Bits.DDRU6
#define DDRU_DDRU7                      _DDRU.Bits.DDRU7

#define DDRU_DDRU0_MASK                 1U
#define DDRU_DDRU1_MASK                 2U
#define DDRU_DDRU2_MASK                 4U
#define DDRU_DDRU3_MASK                 8U
#define DDRU_DDRU4_MASK                 16U
#define DDRU_DDRU5_MASK                 32U
#define DDRU_DDRU6_MASK                 64U
#define DDRU_DDRU7_MASK                 128U


/*** SRRU - Port U Slew Rate Register; 0x0000023B ***/
typedef union {
  byte Byte;
  struct {
    byte SRRU0       :1;                                       /* Slew Rate Port U Bit 0 */
    byte SRRU1       :1;                                       /* Slew Rate Port U Bit 1 */
    byte SRRU2       :1;                                       /* Slew Rate Port U Bit 2 */
    byte SRRU3       :1;                                       /* Slew Rate Port U Bit 3 */
    byte SRRU4       :1;                                       /* Slew Rate Port U Bit 4 */
    byte SRRU5       :1;                                       /* Slew Rate Port U Bit 5 */
    byte SRRU6       :1;                                       /* Slew Rate Port U Bit 6 */
    byte SRRU7       :1;                                       /* Slew Rate Port U Bit 7 */
  } Bits;
} SRRUSTR;
extern volatile SRRUSTR _SRRU @(REG_BASE + 0x0000023BUL);
#define SRRU                            _SRRU.Byte
#define SRRU_SRRU0                      _SRRU.Bits.SRRU0
#define SRRU_SRRU1                      _SRRU.Bits.SRRU1
#define SRRU_SRRU2                      _SRRU.Bits.SRRU2
#define SRRU_SRRU3                      _SRRU.Bits.SRRU3
#define SRRU_SRRU4                      _SRRU.Bits.SRRU4
#define SRRU_SRRU5                      _SRRU.Bits.SRRU5
#define SRRU_SRRU6                      _SRRU.Bits.SRRU6
#define SRRU_SRRU7                      _SRRU.Bits.SRRU7

#define SRRU_SRRU0_MASK                 1U
#define SRRU_SRRU1_MASK                 2U
#define SRRU_SRRU2_MASK                 4U
#define SRRU_SRRU3_MASK                 8U
#define SRRU_SRRU4_MASK                 16U
#define SRRU_SRRU5_MASK                 32U
#define SRRU_SRRU6_MASK                 64U
#define SRRU_SRRU7_MASK                 128U


/*** PERU - Port U Pull Device Enable Register; 0x0000023C ***/
typedef union {
  byte Byte;
  struct {
    byte PERU0       :1;                                       /* Pull Device Enable Port U Bit 0 */
    byte PERU1       :1;                                       /* Pull Device Enable Port U Bit 1 */
    byte PERU2       :1;                                       /* Pull Device Enable Port U Bit 2 */
    byte PERU3       :1;                                       /* Pull Device Enable Port U Bit 3 */
    byte PERU4       :1;                                       /* Pull Device Enable Port U Bit 4 */
    byte PERU5       :1;                                       /* Pull Device Enable Port U Bit 5 */
    byte PERU6       :1;                                       /* Pull Device Enable Port U Bit 6 */
    byte PERU7       :1;                                       /* Pull Device Enable Port U Bit 7 */
  } Bits;
} PERUSTR;
extern volatile PERUSTR _PERU @(REG_BASE + 0x0000023CUL);
#define PERU                            _PERU.Byte
#define PERU_PERU0                      _PERU.Bits.PERU0
#define PERU_PERU1                      _PERU.Bits.PERU1
#define PERU_PERU2                      _PERU.Bits.PERU2
#define PERU_PERU3                      _PERU.Bits.PERU3
#define PERU_PERU4                      _PERU.Bits.PERU4
#define PERU_PERU5                      _PERU.Bits.PERU5
#define PERU_PERU6                      _PERU.Bits.PERU6
#define PERU_PERU7                      _PERU.Bits.PERU7

#define PERU_PERU0_MASK                 1U
#define PERU_PERU1_MASK                 2U
#define PERU_PERU2_MASK                 4U
#define PERU_PERU3_MASK                 8U
#define PERU_PERU4_MASK                 16U
#define PERU_PERU5_MASK                 32U
#define PERU_PERU6_MASK                 64U
#define PERU_PERU7_MASK                 128U


/*** PPSU - Port U Polarity Select Register; 0x0000023D ***/
typedef union {
  byte Byte;
  struct {
    byte PPSU0       :1;                                       /* Pull Select Port U Bit 0 */
    byte PPSU1       :1;                                       /* Pull Select Port U Bit 1 */
    byte PPSU2       :1;                                       /* Pull Select Port U Bit 2 */
    byte PPSU3       :1;                                       /* Pull Select Port U Bit 3 */
    byte PPSU4       :1;                                       /* Pull Select Port U Bit 4 */
    byte PPSU5       :1;                                       /* Pull Select Port U Bit 5 */
    byte PPSU6       :1;                                       /* Pull Select Port U Bit 6 */
    byte PPSU7       :1;                                       /* Pull Select Port U Bit 7 */
  } Bits;
} PPSUSTR;
extern volatile PPSUSTR _PPSU @(REG_BASE + 0x0000023DUL);
#define PPSU                            _PPSU.Byte
#define PPSU_PPSU0                      _PPSU.Bits.PPSU0
#define PPSU_PPSU1                      _PPSU.Bits.PPSU1
#define PPSU_PPSU2                      _PPSU.Bits.PPSU2
#define PPSU_PPSU3                      _PPSU.Bits.PPSU3
#define PPSU_PPSU4                      _PPSU.Bits.PPSU4
#define PPSU_PPSU5                      _PPSU.Bits.PPSU5
#define PPSU_PPSU6                      _PPSU.Bits.PPSU6
#define PPSU_PPSU7                      _PPSU.Bits.PPSU7

#define PPSU_PPSU0_MASK                 1U
#define PPSU_PPSU1_MASK                 2U
#define PPSU_PPSU2_MASK                 4U
#define PPSU_PPSU3_MASK                 8U
#define PPSU_PPSU4_MASK                 16U
#define PPSU_PPSU5_MASK                 32U
#define PPSU_PPSU6_MASK                 64U
#define PPSU_PPSU7_MASK                 128U


/*** PTV - Port V I/O Register; 0x00000240 ***/
typedef union {
  byte Byte;
  struct {
    byte PTV0        :1;                                       /* Port V Bit 0 */
    byte PTV1        :1;                                       /* Port V Bit 1 */
    byte PTV2        :1;                                       /* Port V Bit 2 */
    byte PTV3        :1;                                       /* Port V Bit 3 */
    byte PTV4        :1;                                       /* Port V Bit 4 */
    byte PTV5        :1;                                       /* Port V Bit 5 */
    byte PTV6        :1;                                       /* Port V Bit 6 */
    byte PTV7        :1;                                       /* Port V Bit 7 */
  } Bits;
} PTVSTR;
extern volatile PTVSTR _PTV @(REG_BASE + 0x00000240UL);
#define PTV                             _PTV.Byte
#define PTV_PTV0                        _PTV.Bits.PTV0
#define PTV_PTV1                        _PTV.Bits.PTV1
#define PTV_PTV2                        _PTV.Bits.PTV2
#define PTV_PTV3                        _PTV.Bits.PTV3
#define PTV_PTV4                        _PTV.Bits.PTV4
#define PTV_PTV5                        _PTV.Bits.PTV5
#define PTV_PTV6                        _PTV.Bits.PTV6
#define PTV_PTV7                        _PTV.Bits.PTV7

#define PTV_PTV0_MASK                   1U
#define PTV_PTV1_MASK                   2U
#define PTV_PTV2_MASK                   4U
#define PTV_PTV3_MASK                   8U
#define PTV_PTV4_MASK                   16U
#define PTV_PTV5_MASK                   32U
#define PTV_PTV6_MASK                   64U
#define PTV_PTV7_MASK                   128U


/*** PTIV - Port V Input Register; 0x00000241 ***/
typedef union {
  byte Byte;
  struct {
    byte PTIV0       :1;                                       /* Port V Bit 0 */
    byte PTIV1       :1;                                       /* Port V Bit 1 */
    byte PTIV2       :1;                                       /* Port V Bit 2 */
    byte PTIV3       :1;                                       /* Port V Bit 3 */
    byte PTIV4       :1;                                       /* Port V Bit 4 */
    byte PTIV5       :1;                                       /* Port V Bit 5 */
    byte PTIV6       :1;                                       /* Port V Bit 6 */
    byte PTIV7       :1;                                       /* Port V Bit 7 */
  } Bits;
} PTIVSTR;
extern volatile PTIVSTR _PTIV @(REG_BASE + 0x00000241UL);
#define PTIV                            _PTIV.Byte
#define PTIV_PTIV0                      _PTIV.Bits.PTIV0
#define PTIV_PTIV1                      _PTIV.Bits.PTIV1
#define PTIV_PTIV2                      _PTIV.Bits.PTIV2
#define PTIV_PTIV3                      _PTIV.Bits.PTIV3
#define PTIV_PTIV4                      _PTIV.Bits.PTIV4
#define PTIV_PTIV5                      _PTIV.Bits.PTIV5
#define PTIV_PTIV6                      _PTIV.Bits.PTIV6
#define PTIV_PTIV7                      _PTIV.Bits.PTIV7

#define PTIV_PTIV0_MASK                 1U
#define PTIV_PTIV1_MASK                 2U
#define PTIV_PTIV2_MASK                 4U
#define PTIV_PTIV3_MASK                 8U
#define PTIV_PTIV4_MASK                 16U
#define PTIV_PTIV5_MASK                 32U
#define PTIV_PTIV6_MASK                 64U
#define PTIV_PTIV7_MASK                 128U


/*** DDRV - Port V Data Direction Register; 0x00000242 ***/
typedef union {
  byte Byte;
  struct {
    byte DDRV0       :1;                                       /* Data Direction Port V Bit 0 */
    byte DDRV1       :1;                                       /* Data Direction Port V Bit 1 */
    byte DDRV2       :1;                                       /* Data Direction Port V Bit 2 */
    byte DDRV3       :1;                                       /* Data Direction Port V Bit 3 */
    byte DDRV4       :1;                                       /* Data Direction Port V Bit 4 */
    byte DDRV5       :1;                                       /* Data Direction Port V Bit 5 */
    byte DDRV6       :1;                                       /* Data Direction Port V Bit 6 */
    byte DDRV7       :1;                                       /* Data Direction Port V Bit 7 */
  } Bits;
} DDRVSTR;
extern volatile DDRVSTR _DDRV @(REG_BASE + 0x00000242UL);
#define DDRV                            _DDRV.Byte
#define DDRV_DDRV0                      _DDRV.Bits.DDRV0
#define DDRV_DDRV1                      _DDRV.Bits.DDRV1
#define DDRV_DDRV2                      _DDRV.Bits.DDRV2
#define DDRV_DDRV3                      _DDRV.Bits.DDRV3
#define DDRV_DDRV4                      _DDRV.Bits.DDRV4
#define DDRV_DDRV5                      _DDRV.Bits.DDRV5
#define DDRV_DDRV6                      _DDRV.Bits.DDRV6
#define DDRV_DDRV7                      _DDRV.Bits.DDRV7

#define DDRV_DDRV0_MASK                 1U
#define DDRV_DDRV1_MASK                 2U
#define DDRV_DDRV2_MASK                 4U
#define DDRV_DDRV3_MASK                 8U
#define DDRV_DDRV4_MASK                 16U
#define DDRV_DDRV5_MASK                 32U
#define DDRV_DDRV6_MASK                 64U
#define DDRV_DDRV7_MASK                 128U


/*** SRRV - Port V Reduced Drive Register; 0x00000243 ***/
typedef union {
  byte Byte;
  struct {
    byte SRRV0       :1;                                       /* Slew Rate Port V Bit 0 */
    byte SRRV1       :1;                                       /* Slew Rate Port V Bit 1 */
    byte SRRV2       :1;                                       /* Slew Rate Port V Bit 2 */
    byte SRRV3       :1;                                       /* Slew Rate Port V Bit 3 */
    byte SRRV4       :1;                                       /* Slew Rate Port V Bit 4 */
    byte SRRV5       :1;                                       /* Slew Rate Port V Bit 5 */
    byte SRRV6       :1;                                       /* Slew Rate Port V Bit 6 */
    byte SRRV7       :1;                                       /* Slew Rate Port V Bit 7 */
  } Bits;
} SRRVSTR;
extern volatile SRRVSTR _SRRV @(REG_BASE + 0x00000243UL);
#define SRRV                            _SRRV.Byte
#define SRRV_SRRV0                      _SRRV.Bits.SRRV0
#define SRRV_SRRV1                      _SRRV.Bits.SRRV1
#define SRRV_SRRV2                      _SRRV.Bits.SRRV2
#define SRRV_SRRV3                      _SRRV.Bits.SRRV3
#define SRRV_SRRV4                      _SRRV.Bits.SRRV4
#define SRRV_SRRV5                      _SRRV.Bits.SRRV5
#define SRRV_SRRV6                      _SRRV.Bits.SRRV6
#define SRRV_SRRV7                      _SRRV.Bits.SRRV7

#define SRRV_SRRV0_MASK                 1U
#define SRRV_SRRV1_MASK                 2U
#define SRRV_SRRV2_MASK                 4U
#define SRRV_SRRV3_MASK                 8U
#define SRRV_SRRV4_MASK                 16U
#define SRRV_SRRV5_MASK                 32U
#define SRRV_SRRV6_MASK                 64U
#define SRRV_SRRV7_MASK                 128U


/*** PERV - Port V Pull Device Enable Register; 0x00000244 ***/
typedef union {
  byte Byte;
  struct {
    byte PERV0       :1;                                       /* Pull Device Enable Port V Bit 0 */
    byte PERV1       :1;                                       /* Pull Device Enable Port V Bit 1 */
    byte PERV2       :1;                                       /* Pull Device Enable Port V Bit 2 */
    byte PERV3       :1;                                       /* Pull Device Enable Port V Bit 3 */
    byte PERV4       :1;                                       /* Pull Device Enable Port V Bit 4 */
    byte PERV5       :1;                                       /* Pull Device Enable Port V Bit 5 */
    byte PERV6       :1;                                       /* Pull Device Enable Port V Bit 6 */
    byte PERV7       :1;                                       /* Pull Device Enable Port V Bit 7 */
  } Bits;
} PERVSTR;
extern volatile PERVSTR _PERV @(REG_BASE + 0x00000244UL);
#define PERV                            _PERV.Byte
#define PERV_PERV0                      _PERV.Bits.PERV0
#define PERV_PERV1                      _PERV.Bits.PERV1
#define PERV_PERV2                      _PERV.Bits.PERV2
#define PERV_PERV3                      _PERV.Bits.PERV3
#define PERV_PERV4                      _PERV.Bits.PERV4
#define PERV_PERV5                      _PERV.Bits.PERV5
#define PERV_PERV6                      _PERV.Bits.PERV6
#define PERV_PERV7                      _PERV.Bits.PERV7

#define PERV_PERV0_MASK                 1U
#define PERV_PERV1_MASK                 2U
#define PERV_PERV2_MASK                 4U
#define PERV_PERV3_MASK                 8U
#define PERV_PERV4_MASK                 16U
#define PERV_PERV5_MASK                 32U
#define PERV_PERV6_MASK                 64U
#define PERV_PERV7_MASK                 128U


/*** PPSV - Port V Polarity Select Register; 0x00000245 ***/
typedef union {
  byte Byte;
  struct {
    byte PPSV0       :1;                                       /* Pull Select Port V Bit 0 */
    byte PPSV1       :1;                                       /* Pull Select Port V Bit 1 */
    byte PPSV2       :1;                                       /* Pull Select Port V Bit 2 */
    byte PPSV3       :1;                                       /* Pull Select Port V Bit 3 */
    byte PPSV4       :1;                                       /* Pull Select Port V Bit 4 */
    byte PPSV5       :1;                                       /* Pull Select Port V Bit 5 */
    byte PPSV6       :1;                                       /* Pull Select Port V Bit 6 */
    byte PPSV7       :1;                                       /* Pull Select Port V Bit 7 */
  } Bits;
} PPSVSTR;
extern volatile PPSVSTR _PPSV @(REG_BASE + 0x00000245UL);
#define PPSV                            _PPSV.Byte
#define PPSV_PPSV0                      _PPSV.Bits.PPSV0
#define PPSV_PPSV1                      _PPSV.Bits.PPSV1
#define PPSV_PPSV2                      _PPSV.Bits.PPSV2
#define PPSV_PPSV3                      _PPSV.Bits.PPSV3
#define PPSV_PPSV4                      _PPSV.Bits.PPSV4
#define PPSV_PPSV5                      _PPSV.Bits.PPSV5
#define PPSV_PPSV6                      _PPSV.Bits.PPSV6
#define PPSV_PPSV7                      _PPSV.Bits.PPSV7

#define PPSV_PPSV0_MASK                 1U
#define PPSV_PPSV1_MASK                 2U
#define PPSV_PPSV2_MASK                 4U
#define PPSV_PPSV3_MASK                 8U
#define PPSV_PPSV4_MASK                 16U
#define PPSV_PPSV5_MASK                 32U
#define PPSV_PPSV6_MASK                 64U
#define PPSV_PPSV7_MASK                 128U


/*** PTAD - Port AD I/O Register; 0x00000251 ***/
typedef union {
  byte Byte;
  struct {
    byte PTAD0       :1;                                       /* Port AD Bit 0 */
    byte PTAD1       :1;                                       /* Port AD Bit 1 */
    byte PTAD2       :1;                                       /* Port AD Bit 2 */
    byte PTAD3       :1;                                       /* Port AD Bit 3 */
    byte PTAD4       :1;                                       /* Port AD Bit 4 */
    byte PTAD5       :1;                                       /* Port AD Bit 5 */
    byte PTAD6       :1;                                       /* Port AD Bit 6 */
    byte PTAD7       :1;                                       /* Port AD Bit 7 */
  } Bits;
} PTADSTR;
extern volatile PTADSTR _PTAD @(REG_BASE + 0x00000251UL);
#define PTAD                            _PTAD.Byte
#define PTAD_PTAD0                      _PTAD.Bits.PTAD0
#define PTAD_PTAD1                      _PTAD.Bits.PTAD1
#define PTAD_PTAD2                      _PTAD.Bits.PTAD2
#define PTAD_PTAD3                      _PTAD.Bits.PTAD3
#define PTAD_PTAD4                      _PTAD.Bits.PTAD4
#define PTAD_PTAD5                      _PTAD.Bits.PTAD5
#define PTAD_PTAD6                      _PTAD.Bits.PTAD6
#define PTAD_PTAD7                      _PTAD.Bits.PTAD7

#define PTAD_PTAD0_MASK                 1U
#define PTAD_PTAD1_MASK                 2U
#define PTAD_PTAD2_MASK                 4U
#define PTAD_PTAD3_MASK                 8U
#define PTAD_PTAD4_MASK                 16U
#define PTAD_PTAD5_MASK                 32U
#define PTAD_PTAD6_MASK                 64U
#define PTAD_PTAD7_MASK                 128U


/*** PTIAD - Port AD Input Register; 0x00000253 ***/
typedef union {
  byte Byte;
  struct {
    byte PTIAD0      :1;                                       /* Port AD Bit 0 */
    byte PTIAD1      :1;                                       /* Port AD Bit 1 */
    byte PTIAD2      :1;                                       /* Port AD Bit 2 */
    byte PTIAD3      :1;                                       /* Port AD Bit 3 */
    byte PTIAD4      :1;                                       /* Port AD Bit 4 */
    byte PTIAD5      :1;                                       /* Port AD Bit 5 */
    byte PTIAD6      :1;                                       /* Port AD Bit 6 */
    byte PTIAD7      :1;                                       /* Port AD Bit 7 */
  } Bits;
} PTIADSTR;
extern volatile PTIADSTR _PTIAD @(REG_BASE + 0x00000253UL);
#define PTIAD                           _PTIAD.Byte
#define PTIAD_PTIAD0                    _PTIAD.Bits.PTIAD0
#define PTIAD_PTIAD1                    _PTIAD.Bits.PTIAD1
#define PTIAD_PTIAD2                    _PTIAD.Bits.PTIAD2
#define PTIAD_PTIAD3                    _PTIAD.Bits.PTIAD3
#define PTIAD_PTIAD4                    _PTIAD.Bits.PTIAD4
#define PTIAD_PTIAD5                    _PTIAD.Bits.PTIAD5
#define PTIAD_PTIAD6                    _PTIAD.Bits.PTIAD6
#define PTIAD_PTIAD7                    _PTIAD.Bits.PTIAD7

#define PTIAD_PTIAD0_MASK               1U
#define PTIAD_PTIAD1_MASK               2U
#define PTIAD_PTIAD2_MASK               4U
#define PTIAD_PTIAD3_MASK               8U
#define PTIAD_PTIAD4_MASK               16U
#define PTIAD_PTIAD5_MASK               32U
#define PTIAD_PTIAD6_MASK               64U
#define PTIAD_PTIAD7_MASK               128U


/*** DDRAD - Port AD Data Direction Register; 0x00000255 ***/
typedef union {
  byte Byte;
  struct {
    byte DDRAD0      :1;                                       /* Port AD Data Direction Bit 0 */
    byte DDRAD1      :1;                                       /* Port AD Data Direction Bit 1 */
    byte DDRAD2      :1;                                       /* Port AD Data Direction Bit 2 */
    byte DDRAD3      :1;                                       /* Port AD Data Direction Bit 3 */
    byte DDRAD4      :1;                                       /* Port AD Data Direction Bit 4 */
    byte DDRAD5      :1;                                       /* Port AD Data Direction Bit 5 */
    byte DDRAD6      :1;                                       /* Port AD Data Direction Bit 6 */
    byte DDRAD7      :1;                                       /* Port AD Data Direction Bit 7 */
  } Bits;
} DDRADSTR;
extern volatile DDRADSTR _DDRAD @(REG_BASE + 0x00000255UL);
#define DDRAD                           _DDRAD.Byte
#define DDRAD_DDRAD0                    _DDRAD.Bits.DDRAD0
#define DDRAD_DDRAD1                    _DDRAD.Bits.DDRAD1
#define DDRAD_DDRAD2                    _DDRAD.Bits.DDRAD2
#define DDRAD_DDRAD3                    _DDRAD.Bits.DDRAD3
#define DDRAD_DDRAD4                    _DDRAD.Bits.DDRAD4
#define DDRAD_DDRAD5                    _DDRAD.Bits.DDRAD5
#define DDRAD_DDRAD6                    _DDRAD.Bits.DDRAD6
#define DDRAD_DDRAD7                    _DDRAD.Bits.DDRAD7

#define DDRAD_DDRAD0_MASK               1U
#define DDRAD_DDRAD1_MASK               2U
#define DDRAD_DDRAD2_MASK               4U
#define DDRAD_DDRAD3_MASK               8U
#define DDRAD_DDRAD4_MASK               16U
#define DDRAD_DDRAD5_MASK               32U
#define DDRAD_DDRAD6_MASK               64U
#define DDRAD_DDRAD7_MASK               128U


/*** RDRAD - Port AD Reduced Drive Register; 0x00000257 ***/
typedef union {
  byte Byte;
  struct {
    byte RDRAD0      :1;                                       /* Port AD Reduced Drive Bit 0 */
    byte RDRAD1      :1;                                       /* Port AD Reduced Drive Bit 1 */
    byte RDRAD2      :1;                                       /* Port AD Reduced Drive Bit 2 */
    byte RDRAD3      :1;                                       /* Port AD Reduced Drive Bit 3 */
    byte RDRAD4      :1;                                       /* Port AD Reduced Drive Bit 4 */
    byte RDRAD5      :1;                                       /* Port AD Reduced Drive Bit 5 */
    byte RDRAD6      :1;                                       /* Port AD Reduced Drive Bit 6 */
    byte RDRAD7      :1;                                       /* Port AD Reduced Drive Bit 7 */
  } Bits;
} RDRADSTR;
extern volatile RDRADSTR _RDRAD @(REG_BASE + 0x00000257UL);
#define RDRAD                           _RDRAD.Byte
#define RDRAD_RDRAD0                    _RDRAD.Bits.RDRAD0
#define RDRAD_RDRAD1                    _RDRAD.Bits.RDRAD1
#define RDRAD_RDRAD2                    _RDRAD.Bits.RDRAD2
#define RDRAD_RDRAD3                    _RDRAD.Bits.RDRAD3
#define RDRAD_RDRAD4                    _RDRAD.Bits.RDRAD4
#define RDRAD_RDRAD5                    _RDRAD.Bits.RDRAD5
#define RDRAD_RDRAD6                    _RDRAD.Bits.RDRAD6
#define RDRAD_RDRAD7                    _RDRAD.Bits.RDRAD7

#define RDRAD_RDRAD0_MASK               1U
#define RDRAD_RDRAD1_MASK               2U
#define RDRAD_RDRAD2_MASK               4U
#define RDRAD_RDRAD3_MASK               8U
#define RDRAD_RDRAD4_MASK               16U
#define RDRAD_RDRAD5_MASK               32U
#define RDRAD_RDRAD6_MASK               64U
#define RDRAD_RDRAD7_MASK               128U


/*** PERAD - Port AD Pull Device Enable Register; 0x00000259 ***/
typedef union {
  byte Byte;
  struct {
    byte PERAD0      :1;                                       /* Port AD Pull Device Enable Bit 0 */
    byte PERAD1      :1;                                       /* Port AD Pull Device Enable Bit 1 */
    byte PERAD2      :1;                                       /* Port AD Pull Device Enable Bit 2 */
    byte PERAD3      :1;                                       /* Port AD Pull Device Enable Bit 3 */
    byte PERAD4      :1;                                       /* Port AD Pull Device Enable Bit 4 */
    byte PERAD5      :1;                                       /* Port AD Pull Device Enable Bit 5 */
    byte PERAD6      :1;                                       /* Port AD Pull Device Enable Bit 6 */
    byte PERAD7      :1;                                       /* Port AD Pull Device Enable Bit 7 */
  } Bits;
} PERADSTR;
extern volatile PERADSTR _PERAD @(REG_BASE + 0x00000259UL);
#define PERAD                           _PERAD.Byte
#define PERAD_PERAD0                    _PERAD.Bits.PERAD0
#define PERAD_PERAD1                    _PERAD.Bits.PERAD1
#define PERAD_PERAD2                    _PERAD.Bits.PERAD2
#define PERAD_PERAD3                    _PERAD.Bits.PERAD3
#define PERAD_PERAD4                    _PERAD.Bits.PERAD4
#define PERAD_PERAD5                    _PERAD.Bits.PERAD5
#define PERAD_PERAD6                    _PERAD.Bits.PERAD6
#define PERAD_PERAD7                    _PERAD.Bits.PERAD7

#define PERAD_PERAD0_MASK               1U
#define PERAD_PERAD1_MASK               2U
#define PERAD_PERAD2_MASK               4U
#define PERAD_PERAD3_MASK               8U
#define PERAD_PERAD4_MASK               16U
#define PERAD_PERAD5_MASK               32U
#define PERAD_PERAD6_MASK               64U
#define PERAD_PERAD7_MASK               128U


/*** PPSAD - Port AD Polarity Select Register; 0x0000025B ***/
typedef union {
  byte Byte;
  struct {
    byte PPSAD0      :1;                                       /* Port AD Polarity Select Bit 0 */
    byte PPSAD1      :1;                                       /* Port AD Polarity Select Bit 1 */
    byte PPSAD2      :1;                                       /* Port AD Polarity Select Bit 2 */
    byte PPSAD3      :1;                                       /* Port AD Polarity Select Bit 3 */
    byte PPSAD4      :1;                                       /* Port AD Polarity Select Bit 4 */
    byte PPSAD5      :1;                                       /* Port AD Polarity Select Bit 5 */
    byte PPSAD6      :1;                                       /* Port AD Polarity Select Bit 6 */
    byte PPSAD7      :1;                                       /* Port AD Polarity Select Bit 7 */
  } Bits;
} PPSADSTR;
extern volatile PPSADSTR _PPSAD @(REG_BASE + 0x0000025BUL);
#define PPSAD                           _PPSAD.Byte
#define PPSAD_PPSAD0                    _PPSAD.Bits.PPSAD0
#define PPSAD_PPSAD1                    _PPSAD.Bits.PPSAD1
#define PPSAD_PPSAD2                    _PPSAD.Bits.PPSAD2
#define PPSAD_PPSAD3                    _PPSAD.Bits.PPSAD3
#define PPSAD_PPSAD4                    _PPSAD.Bits.PPSAD4
#define PPSAD_PPSAD5                    _PPSAD.Bits.PPSAD5
#define PPSAD_PPSAD6                    _PPSAD.Bits.PPSAD6
#define PPSAD_PPSAD7                    _PPSAD.Bits.PPSAD7

#define PPSAD_PPSAD0_MASK               1U
#define PPSAD_PPSAD1_MASK               2U
#define PPSAD_PPSAD2_MASK               4U
#define PPSAD_PPSAD3_MASK               8U
#define PPSAD_PPSAD4_MASK               16U
#define PPSAD_PPSAD5_MASK               32U
#define PPSAD_PPSAD6_MASK               64U
#define PPSAD_PPSAD7_MASK               128U


/*** PIEAD - Port AD Interrupt Enable Register; 0x0000025D ***/
typedef union {
  byte Byte;
  struct {
    byte PIEAD0      :1;                                       /* Port AD Interrupt Enable Bit 0 */
    byte PIEAD1      :1;                                       /* Port AD Interrupt Enable Bit 1 */
    byte PIEAD2      :1;                                       /* Port AD Interrupt Enable Bit 2 */
    byte PIEAD3      :1;                                       /* Port AD Interrupt Enable Bit 3 */
    byte PIEAD4      :1;                                       /* Port AD Interrupt Enable Bit 4 */
    byte PIEAD5      :1;                                       /* Port AD Interrupt Enable Bit 5 */
    byte PIEAD6      :1;                                       /* Port AD Interrupt Enable Bit 6 */
    byte PIEAD7      :1;                                       /* Port AD Interrupt Enable Bit 7 */
  } Bits;
} PIEADSTR;
extern volatile PIEADSTR _PIEAD @(REG_BASE + 0x0000025DUL);
#define PIEAD                           _PIEAD.Byte
#define PIEAD_PIEAD0                    _PIEAD.Bits.PIEAD0
#define PIEAD_PIEAD1                    _PIEAD.Bits.PIEAD1
#define PIEAD_PIEAD2                    _PIEAD.Bits.PIEAD2
#define PIEAD_PIEAD3                    _PIEAD.Bits.PIEAD3
#define PIEAD_PIEAD4                    _PIEAD.Bits.PIEAD4
#define PIEAD_PIEAD5                    _PIEAD.Bits.PIEAD5
#define PIEAD_PIEAD6                    _PIEAD.Bits.PIEAD6
#define PIEAD_PIEAD7                    _PIEAD.Bits.PIEAD7

#define PIEAD_PIEAD0_MASK               1U
#define PIEAD_PIEAD1_MASK               2U
#define PIEAD_PIEAD2_MASK               4U
#define PIEAD_PIEAD3_MASK               8U
#define PIEAD_PIEAD4_MASK               16U
#define PIEAD_PIEAD5_MASK               32U
#define PIEAD_PIEAD6_MASK               64U
#define PIEAD_PIEAD7_MASK               128U


/*** PIFAD - Port AD Interrupt Flag Register; 0x0000025F ***/
typedef union {
  byte Byte;
  struct {
    byte PIFAD0      :1;                                       /* Port AD Interrupt Flag Bit 0 */
    byte PIFAD1      :1;                                       /* Port AD Interrupt Flag Bit 1 */
    byte PIFAD2      :1;                                       /* Port AD Interrupt Flag Bit 2 */
    byte PIFAD3      :1;                                       /* Port AD Interrupt Flag Bit 3 */
    byte PIFAD4      :1;                                       /* Port AD Interrupt Flag Bit 4 */
    byte PIFAD5      :1;                                       /* Port AD Interrupt Flag Bit 5 */
    byte PIFAD6      :1;                                       /* Port AD Interrupt Flag Bit 6 */
    byte PIFAD7      :1;                                       /* Port AD Interrupt Flag Bit 7 */
  } Bits;
} PIFADSTR;
extern volatile PIFADSTR _PIFAD @(REG_BASE + 0x0000025FUL);
#define PIFAD                           _PIFAD.Byte
#define PIFAD_PIFAD0                    _PIFAD.Bits.PIFAD0
#define PIFAD_PIFAD1                    _PIFAD.Bits.PIFAD1
#define PIFAD_PIFAD2                    _PIFAD.Bits.PIFAD2
#define PIFAD_PIFAD3                    _PIFAD.Bits.PIFAD3
#define PIFAD_PIFAD4                    _PIFAD.Bits.PIFAD4
#define PIFAD_PIFAD5                    _PIFAD.Bits.PIFAD5
#define PIFAD_PIFAD6                    _PIFAD.Bits.PIFAD6
#define PIFAD_PIFAD7                    _PIFAD.Bits.PIFAD7

#define PIFAD_PIFAD0_MASK               1U
#define PIFAD_PIFAD1_MASK               2U
#define PIFAD_PIFAD2_MASK               4U
#define PIFAD_PIFAD3_MASK               8U
#define PIFAD_PIFAD4_MASK               16U
#define PIFAD_PIFAD5_MASK               32U
#define PIFAD_PIFAD6_MASK               64U
#define PIFAD_PIFAD7_MASK               128U


/*** RTZ0CTL - SSD 0 Return to Zero Control register; 0x00000288 ***/
typedef union {
  byte Byte;
  struct {
    byte STEP0       :1;                                       /* Full Step State, bit 0 */
    byte STEP1       :1;                                       /* Full Step State, bit 1 */
    byte SMS         :1;                                       /* Stepper Motor Select */
    byte             :1; 
    byte POL         :1;                                       /* Polarity */
    byte RCIR        :1;                                       /* Recirculation in blanking mode */
    byte DCOIL       :1;                                       /* Drive Coil */
    byte ITG         :1;                                       /* Integration */
  } Bits;
  struct {
    byte grpSTEP :2;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} RTZ0CTLSTR;
extern volatile RTZ0CTLSTR _RTZ0CTL @(REG_BASE + 0x00000288UL);
#define RTZ0CTL                         _RTZ0CTL.Byte
#define RTZ0CTL_STEP0                   _RTZ0CTL.Bits.STEP0
#define RTZ0CTL_STEP1                   _RTZ0CTL.Bits.STEP1
#define RTZ0CTL_SMS                     _RTZ0CTL.Bits.SMS
#define RTZ0CTL_POL                     _RTZ0CTL.Bits.POL
#define RTZ0CTL_RCIR                    _RTZ0CTL.Bits.RCIR
#define RTZ0CTL_DCOIL                   _RTZ0CTL.Bits.DCOIL
#define RTZ0CTL_ITG                     _RTZ0CTL.Bits.ITG
#define RTZ0CTL_STEP                    _RTZ0CTL.MergedBits.grpSTEP

#define RTZ0CTL_STEP0_MASK              1U
#define RTZ0CTL_STEP1_MASK              2U
#define RTZ0CTL_SMS_MASK                4U
#define RTZ0CTL_POL_MASK                16U
#define RTZ0CTL_RCIR_MASK               32U
#define RTZ0CTL_DCOIL_MASK              64U
#define RTZ0CTL_ITG_MASK                128U
#define RTZ0CTL_STEP_MASK               3U
#define RTZ0CTL_STEP_BITNUM             0U


/*** MDC0CTL - SSD 0 Modulus Down Counter Control register; 0x00000289 ***/
typedef union {
  byte Byte;
  struct {
    byte AOVIE       :1;                                       /* Accumulator Overflow Interrupt Enable */
    byte             :1; 
    byte MCEN        :1;                                       /* Modulus Down-Counter Enable */
    byte FLMC        :1;                                       /* Force Load Register into the Modulus Counter Count Register */
    byte PRE         :1;                                       /* Prescalar */
    byte RDMCL       :1;                                       /* Read Modulus Down-Counter Load */
    byte MODMC       :1;                                       /* Modulus Mode Enable */
    byte MCZIE       :1;                                       /* Modulus Counter Underflow Interrupt Enable */
  } Bits;
} MDC0CTLSTR;
extern volatile MDC0CTLSTR _MDC0CTL @(REG_BASE + 0x00000289UL);
#define MDC0CTL                         _MDC0CTL.Byte
#define MDC0CTL_AOVIE                   _MDC0CTL.Bits.AOVIE
#define MDC0CTL_MCEN                    _MDC0CTL.Bits.MCEN
#define MDC0CTL_FLMC                    _MDC0CTL.Bits.FLMC
#define MDC0CTL_PRE                     _MDC0CTL.Bits.PRE
#define MDC0CTL_RDMCL                   _MDC0CTL.Bits.RDMCL
#define MDC0CTL_MODMC                   _MDC0CTL.Bits.MODMC
#define MDC0CTL_MCZIE                   _MDC0CTL.Bits.MCZIE

#define MDC0CTL_AOVIE_MASK              1U
#define MDC0CTL_MCEN_MASK               4U
#define MDC0CTL_FLMC_MASK               8U
#define MDC0CTL_PRE_MASK                16U
#define MDC0CTL_RDMCL_MASK              32U
#define MDC0CTL_MODMC_MASK              64U
#define MDC0CTL_MCZIE_MASK              128U


/*** SSD0CTL - SSD 0 Stepper Stall Detector Control register; 0x0000028A ***/
typedef union {
  byte Byte;
  struct {
    byte ACLKS0      :1;                                       /* Accumulator Sample Frequency Select, bit 0 */
    byte ACLKS1      :1;                                       /* Accumulator Sample Frequency Select, bit 1 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte SSDWAI      :1;                                       /* SSD Disabled during Wait Mode */
    byte SDCPU       :1;                                       /* Sigma-Delta Converter Power Up */
    byte RTZE        :1;                                       /* Return to Zero Enable */
  } Bits;
  struct {
    byte grpACLKS :2;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} SSD0CTLSTR;
extern volatile SSD0CTLSTR _SSD0CTL @(REG_BASE + 0x0000028AUL);
#define SSD0CTL                         _SSD0CTL.Byte
#define SSD0CTL_ACLKS0                  _SSD0CTL.Bits.ACLKS0
#define SSD0CTL_ACLKS1                  _SSD0CTL.Bits.ACLKS1
#define SSD0CTL_SSDWAI                  _SSD0CTL.Bits.SSDWAI
#define SSD0CTL_SDCPU                   _SSD0CTL.Bits.SDCPU
#define SSD0CTL_RTZE                    _SSD0CTL.Bits.RTZE
#define SSD0CTL_ACLKS                   _SSD0CTL.MergedBits.grpACLKS

#define SSD0CTL_ACLKS0_MASK             1U
#define SSD0CTL_ACLKS1_MASK             2U
#define SSD0CTL_SSDWAI_MASK             32U
#define SSD0CTL_SDCPU_MASK              64U
#define SSD0CTL_RTZE_MASK               128U
#define SSD0CTL_ACLKS_MASK              3U
#define SSD0CTL_ACLKS_BITNUM            0U


/*** SSD0FLG - SSD 0 Stepper Stall Detector Flag register; 0x0000028B ***/
typedef union {
  byte Byte;
  struct {
    byte AOVIF       :1;                                       /* Accumulator Overflow Interrupt Flag */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte MCZIF       :1;                                       /* Modulus Counter Underflow Interrupt Flag */
  } Bits;
} SSD0FLGSTR;
extern volatile SSD0FLGSTR _SSD0FLG @(REG_BASE + 0x0000028BUL);
#define SSD0FLG                         _SSD0FLG.Byte
#define SSD0FLG_AOVIF                   _SSD0FLG.Bits.AOVIF
#define SSD0FLG_MCZIF                   _SSD0FLG.Bits.MCZIF

#define SSD0FLG_AOVIF_MASK              1U
#define SSD0FLG_MCZIF_MASK              128U


/*** MDC0CNT - SSD 0 Modulus Down-Counter Count register; 0x0000028C ***/
typedef union {
  word Word;
  struct {
    word MDCCNT0     :1;                                       /* Modulus Down-Counter Count Bits, bit 0 */
    word MDCCNT1     :1;                                       /* Modulus Down-Counter Count Bits, bit 1 */
    word MDCCNT2     :1;                                       /* Modulus Down-Counter Count Bits, bit 2 */
    word MDCCNT3     :1;                                       /* Modulus Down-Counter Count Bits, bit 3 */
    word MDCCNT4     :1;                                       /* Modulus Down-Counter Count Bits, bit 4 */
    word MDCCNT5     :1;                                       /* Modulus Down-Counter Count Bits, bit 5 */
    word MDCCNT6     :1;                                       /* Modulus Down-Counter Count Bits, bit 6 */
    word MDCCNT7     :1;                                       /* Modulus Down-Counter Count Bits, bit 7 */
    word MDCCNT8     :1;                                       /* Modulus Down-Counter Count Bits, bit 8 */
    word MDCCNT9     :1;                                       /* Modulus Down-Counter Count Bits, bit 9 */
    word MDCCNT10    :1;                                       /* Modulus Down-Counter Count Bits, bit 10 */
    word MDCCNT11    :1;                                       /* Modulus Down-Counter Count Bits, bit 11 */
    word MDCCNT12    :1;                                       /* Modulus Down-Counter Count Bits, bit 12 */
    word MDCCNT13    :1;                                       /* Modulus Down-Counter Count Bits, bit 13 */
    word MDCCNT14    :1;                                       /* Modulus Down-Counter Count Bits, bit 14 */
    word MDCCNT15    :1;                                       /* Modulus Down-Counter Count Bits, bit 15 */
  } Bits;
} MDC0CNTSTR;
extern volatile MDC0CNTSTR _MDC0CNT @(REG_BASE + 0x0000028CUL);
#define MDC0CNT                         _MDC0CNT.Word
#define MDC0CNT_MDCCNT0                 _MDC0CNT.Bits.MDCCNT0
#define MDC0CNT_MDCCNT1                 _MDC0CNT.Bits.MDCCNT1
#define MDC0CNT_MDCCNT2                 _MDC0CNT.Bits.MDCCNT2
#define MDC0CNT_MDCCNT3                 _MDC0CNT.Bits.MDCCNT3
#define MDC0CNT_MDCCNT4                 _MDC0CNT.Bits.MDCCNT4
#define MDC0CNT_MDCCNT5                 _MDC0CNT.Bits.MDCCNT5
#define MDC0CNT_MDCCNT6                 _MDC0CNT.Bits.MDCCNT6
#define MDC0CNT_MDCCNT7                 _MDC0CNT.Bits.MDCCNT7
#define MDC0CNT_MDCCNT8                 _MDC0CNT.Bits.MDCCNT8
#define MDC0CNT_MDCCNT9                 _MDC0CNT.Bits.MDCCNT9
#define MDC0CNT_MDCCNT10                _MDC0CNT.Bits.MDCCNT10
#define MDC0CNT_MDCCNT11                _MDC0CNT.Bits.MDCCNT11
#define MDC0CNT_MDCCNT12                _MDC0CNT.Bits.MDCCNT12
#define MDC0CNT_MDCCNT13                _MDC0CNT.Bits.MDCCNT13
#define MDC0CNT_MDCCNT14                _MDC0CNT.Bits.MDCCNT14
#define MDC0CNT_MDCCNT15                _MDC0CNT.Bits.MDCCNT15

#define MDC0CNT_MDCCNT0_MASK            1U
#define MDC0CNT_MDCCNT1_MASK            2U
#define MDC0CNT_MDCCNT2_MASK            4U
#define MDC0CNT_MDCCNT3_MASK            8U
#define MDC0CNT_MDCCNT4_MASK            16U
#define MDC0CNT_MDCCNT5_MASK            32U
#define MDC0CNT_MDCCNT6_MASK            64U
#define MDC0CNT_MDCCNT7_MASK            128U
#define MDC0CNT_MDCCNT8_MASK            256U
#define MDC0CNT_MDCCNT9_MASK            512U
#define MDC0CNT_MDCCNT10_MASK           1024U
#define MDC0CNT_MDCCNT11_MASK           2048U
#define MDC0CNT_MDCCNT12_MASK           4096U
#define MDC0CNT_MDCCNT13_MASK           8192U
#define MDC0CNT_MDCCNT14_MASK           16384U
#define MDC0CNT_MDCCNT15_MASK           32768U


/*** ITG0ACC - SSD 0 Integration Accumulator register; 0x0000028E ***/
typedef union {
  word Word;
  struct {
    word ITGACC0     :1;                                       /* Integration Accumulator Bits, bit 0 */
    word ITGACC1     :1;                                       /* Integration Accumulator Bits, bit 1 */
    word ITGACC2     :1;                                       /* Integration Accumulator Bits, bit 2 */
    word ITGACC3     :1;                                       /* Integration Accumulator Bits, bit 3 */
    word ITGACC4     :1;                                       /* Integration Accumulator Bits, bit 4 */
    word ITGACC5     :1;                                       /* Integration Accumulator Bits, bit 5 */
    word ITGACC6     :1;                                       /* Integration Accumulator Bits, bit 6 */
    word ITGACC7     :1;                                       /* Integration Accumulator Bits, bit 7 */
    word ITGACC8     :1;                                       /* Integration Accumulator Bits, bit 8 */
    word ITGACC9     :1;                                       /* Integration Accumulator Bits, bit 9 */
    word ITGACC10    :1;                                       /* Integration Accumulator Bits, bit 10 */
    word ITGACC11    :1;                                       /* Integration Accumulator Bits, bit 11 */
    word ITGACC12    :1;                                       /* Integration Accumulator Bits, bit 12 */
    word ITGACC13    :1;                                       /* Integration Accumulator Bits, bit 13 */
    word ITGACC14    :1;                                       /* Integration Accumulator Bits, bit 14 */
    word ITGACC15    :1;                                       /* Integration Accumulator Bits, bit 15 */
  } Bits;
} ITG0ACCSTR;
extern volatile ITG0ACCSTR _ITG0ACC @(REG_BASE + 0x0000028EUL);
#define ITG0ACC                         _ITG0ACC.Word
#define ITG0ACC_ITGACC0                 _ITG0ACC.Bits.ITGACC0
#define ITG0ACC_ITGACC1                 _ITG0ACC.Bits.ITGACC1
#define ITG0ACC_ITGACC2                 _ITG0ACC.Bits.ITGACC2
#define ITG0ACC_ITGACC3                 _ITG0ACC.Bits.ITGACC3
#define ITG0ACC_ITGACC4                 _ITG0ACC.Bits.ITGACC4
#define ITG0ACC_ITGACC5                 _ITG0ACC.Bits.ITGACC5
#define ITG0ACC_ITGACC6                 _ITG0ACC.Bits.ITGACC6
#define ITG0ACC_ITGACC7                 _ITG0ACC.Bits.ITGACC7
#define ITG0ACC_ITGACC8                 _ITG0ACC.Bits.ITGACC8
#define ITG0ACC_ITGACC9                 _ITG0ACC.Bits.ITGACC9
#define ITG0ACC_ITGACC10                _ITG0ACC.Bits.ITGACC10
#define ITG0ACC_ITGACC11                _ITG0ACC.Bits.ITGACC11
#define ITG0ACC_ITGACC12                _ITG0ACC.Bits.ITGACC12
#define ITG0ACC_ITGACC13                _ITG0ACC.Bits.ITGACC13
#define ITG0ACC_ITGACC14                _ITG0ACC.Bits.ITGACC14
#define ITG0ACC_ITGACC15                _ITG0ACC.Bits.ITGACC15

#define ITG0ACC_ITGACC0_MASK            1U
#define ITG0ACC_ITGACC1_MASK            2U
#define ITG0ACC_ITGACC2_MASK            4U
#define ITG0ACC_ITGACC3_MASK            8U
#define ITG0ACC_ITGACC4_MASK            16U
#define ITG0ACC_ITGACC5_MASK            32U
#define ITG0ACC_ITGACC6_MASK            64U
#define ITG0ACC_ITGACC7_MASK            128U
#define ITG0ACC_ITGACC8_MASK            256U
#define ITG0ACC_ITGACC9_MASK            512U
#define ITG0ACC_ITGACC10_MASK           1024U
#define ITG0ACC_ITGACC11_MASK           2048U
#define ITG0ACC_ITGACC12_MASK           4096U
#define ITG0ACC_ITGACC13_MASK           8192U
#define ITG0ACC_ITGACC14_MASK           16384U
#define ITG0ACC_ITGACC15_MASK           32768U


/*** RTZ1CTL - SSD 1 Return to Zero Control register; 0x00000290 ***/
typedef union {
  byte Byte;
  struct {
    byte STEP0       :1;                                       /* Full Step State, bit 0 */
    byte STEP1       :1;                                       /* Full Step State, bit 1 */
    byte SMS         :1;                                       /* Stepper Motor Select */
    byte             :1; 
    byte POL         :1;                                       /* Polarity */
    byte RCIR        :1;                                       /* Recirculation in blanking mode */
    byte DCOIL       :1;                                       /* Drive Coil */
    byte ITG         :1;                                       /* Integration */
  } Bits;
  struct {
    byte grpSTEP :2;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} RTZ1CTLSTR;
extern volatile RTZ1CTLSTR _RTZ1CTL @(REG_BASE + 0x00000290UL);
#define RTZ1CTL                         _RTZ1CTL.Byte
#define RTZ1CTL_STEP0                   _RTZ1CTL.Bits.STEP0
#define RTZ1CTL_STEP1                   _RTZ1CTL.Bits.STEP1
#define RTZ1CTL_SMS                     _RTZ1CTL.Bits.SMS
#define RTZ1CTL_POL                     _RTZ1CTL.Bits.POL
#define RTZ1CTL_RCIR                    _RTZ1CTL.Bits.RCIR
#define RTZ1CTL_DCOIL                   _RTZ1CTL.Bits.DCOIL
#define RTZ1CTL_ITG                     _RTZ1CTL.Bits.ITG
#define RTZ1CTL_STEP                    _RTZ1CTL.MergedBits.grpSTEP

#define RTZ1CTL_STEP0_MASK              1U
#define RTZ1CTL_STEP1_MASK              2U
#define RTZ1CTL_SMS_MASK                4U
#define RTZ1CTL_POL_MASK                16U
#define RTZ1CTL_RCIR_MASK               32U
#define RTZ1CTL_DCOIL_MASK              64U
#define RTZ1CTL_ITG_MASK                128U
#define RTZ1CTL_STEP_MASK               3U
#define RTZ1CTL_STEP_BITNUM             0U


/*** MDC1CTL - SSD 1 Modulus Down Counter Control register; 0x00000291 ***/
typedef union {
  byte Byte;
  struct {
    byte AOVIE       :1;                                       /* Accumulator Overflow Interrupt Enable */
    byte             :1; 
    byte MCEN        :1;                                       /* Modulus Down-Counter Enable */
    byte FLMC        :1;                                       /* Force Load Register into the Modulus Counter Count Register */
    byte PRE         :1;                                       /* Prescalar */
    byte RDMCL       :1;                                       /* Read Modulus Down-Counter Load */
    byte MODMC       :1;                                       /* Modulus Mode Enable */
    byte MCZIE       :1;                                       /* Modulus Counter Underflow Interrupt Enable */
  } Bits;
} MDC1CTLSTR;
extern volatile MDC1CTLSTR _MDC1CTL @(REG_BASE + 0x00000291UL);
#define MDC1CTL                         _MDC1CTL.Byte
#define MDC1CTL_AOVIE                   _MDC1CTL.Bits.AOVIE
#define MDC1CTL_MCEN                    _MDC1CTL.Bits.MCEN
#define MDC1CTL_FLMC                    _MDC1CTL.Bits.FLMC
#define MDC1CTL_PRE                     _MDC1CTL.Bits.PRE
#define MDC1CTL_RDMCL                   _MDC1CTL.Bits.RDMCL
#define MDC1CTL_MODMC                   _MDC1CTL.Bits.MODMC
#define MDC1CTL_MCZIE                   _MDC1CTL.Bits.MCZIE

#define MDC1CTL_AOVIE_MASK              1U
#define MDC1CTL_MCEN_MASK               4U
#define MDC1CTL_FLMC_MASK               8U
#define MDC1CTL_PRE_MASK                16U
#define MDC1CTL_RDMCL_MASK              32U
#define MDC1CTL_MODMC_MASK              64U
#define MDC1CTL_MCZIE_MASK              128U


/*** SSD1CTL - SSD 1 Stepper Stall Detector Control register; 0x00000292 ***/
typedef union {
  byte Byte;
  struct {
    byte ACLKS0      :1;                                       /* Accumulator Sample Frequency Select, bit 0 */
    byte ACLKS1      :1;                                       /* Accumulator Sample Frequency Select, bit 1 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte SSDWAI      :1;                                       /* SSD Disabled during Wait Mode */
    byte SDCPU       :1;                                       /* Sigma-Delta Converter Power Up */
    byte RTZE        :1;                                       /* Return to Zero Enable */
  } Bits;
  struct {
    byte grpACLKS :2;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} SSD1CTLSTR;
extern volatile SSD1CTLSTR _SSD1CTL @(REG_BASE + 0x00000292UL);
#define SSD1CTL                         _SSD1CTL.Byte
#define SSD1CTL_ACLKS0                  _SSD1CTL.Bits.ACLKS0
#define SSD1CTL_ACLKS1                  _SSD1CTL.Bits.ACLKS1
#define SSD1CTL_SSDWAI                  _SSD1CTL.Bits.SSDWAI
#define SSD1CTL_SDCPU                   _SSD1CTL.Bits.SDCPU
#define SSD1CTL_RTZE                    _SSD1CTL.Bits.RTZE
#define SSD1CTL_ACLKS                   _SSD1CTL.MergedBits.grpACLKS

#define SSD1CTL_ACLKS0_MASK             1U
#define SSD1CTL_ACLKS1_MASK             2U
#define SSD1CTL_SSDWAI_MASK             32U
#define SSD1CTL_SDCPU_MASK              64U
#define SSD1CTL_RTZE_MASK               128U
#define SSD1CTL_ACLKS_MASK              3U
#define SSD1CTL_ACLKS_BITNUM            0U


/*** SSD1FLG - SSD 1 Stepper Stall Detector Flag register; 0x00000293 ***/
typedef union {
  byte Byte;
  struct {
    byte AOVIF       :1;                                       /* Accumulator Overflow Interrupt Flag */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte MCZIF       :1;                                       /* Modulus Counter Underflow Interrupt Flag */
  } Bits;
} SSD1FLGSTR;
extern volatile SSD1FLGSTR _SSD1FLG @(REG_BASE + 0x00000293UL);
#define SSD1FLG                         _SSD1FLG.Byte
#define SSD1FLG_AOVIF                   _SSD1FLG.Bits.AOVIF
#define SSD1FLG_MCZIF                   _SSD1FLG.Bits.MCZIF

#define SSD1FLG_AOVIF_MASK              1U
#define SSD1FLG_MCZIF_MASK              128U


/*** MDC1CNT - SSD 1 Modulus Down-Counter Count register; 0x00000294 ***/
typedef union {
  word Word;
  struct {
    word MDCCNT0     :1;                                       /* Modulus Down-Counter Count Bits, bit 0 */
    word MDCCNT1     :1;                                       /* Modulus Down-Counter Count Bits, bit 1 */
    word MDCCNT2     :1;                                       /* Modulus Down-Counter Count Bits, bit 2 */
    word MDCCNT3     :1;                                       /* Modulus Down-Counter Count Bits, bit 3 */
    word MDCCNT4     :1;                                       /* Modulus Down-Counter Count Bits, bit 4 */
    word MDCCNT5     :1;                                       /* Modulus Down-Counter Count Bits, bit 5 */
    word MDCCNT6     :1;                                       /* Modulus Down-Counter Count Bits, bit 6 */
    word MDCCNT7     :1;                                       /* Modulus Down-Counter Count Bits, bit 7 */
    word MDCCNT8     :1;                                       /* Modulus Down-Counter Count Bits, bit 8 */
    word MDCCNT9     :1;                                       /* Modulus Down-Counter Count Bits, bit 9 */
    word MDCCNT10    :1;                                       /* Modulus Down-Counter Count Bits, bit 10 */
    word MDCCNT11    :1;                                       /* Modulus Down-Counter Count Bits, bit 11 */
    word MDCCNT12    :1;                                       /* Modulus Down-Counter Count Bits, bit 12 */
    word MDCCNT13    :1;                                       /* Modulus Down-Counter Count Bits, bit 13 */
    word MDCCNT14    :1;                                       /* Modulus Down-Counter Count Bits, bit 14 */
    word MDCCNT15    :1;                                       /* Modulus Down-Counter Count Bits, bit 15 */
  } Bits;
} MDC1CNTSTR;
extern volatile MDC1CNTSTR _MDC1CNT @(REG_BASE + 0x00000294UL);
#define MDC1CNT                         _MDC1CNT.Word
#define MDC1CNT_MDCCNT0                 _MDC1CNT.Bits.MDCCNT0
#define MDC1CNT_MDCCNT1                 _MDC1CNT.Bits.MDCCNT1
#define MDC1CNT_MDCCNT2                 _MDC1CNT.Bits.MDCCNT2
#define MDC1CNT_MDCCNT3                 _MDC1CNT.Bits.MDCCNT3
#define MDC1CNT_MDCCNT4                 _MDC1CNT.Bits.MDCCNT4
#define MDC1CNT_MDCCNT5                 _MDC1CNT.Bits.MDCCNT5
#define MDC1CNT_MDCCNT6                 _MDC1CNT.Bits.MDCCNT6
#define MDC1CNT_MDCCNT7                 _MDC1CNT.Bits.MDCCNT7
#define MDC1CNT_MDCCNT8                 _MDC1CNT.Bits.MDCCNT8
#define MDC1CNT_MDCCNT9                 _MDC1CNT.Bits.MDCCNT9
#define MDC1CNT_MDCCNT10                _MDC1CNT.Bits.MDCCNT10
#define MDC1CNT_MDCCNT11                _MDC1CNT.Bits.MDCCNT11
#define MDC1CNT_MDCCNT12                _MDC1CNT.Bits.MDCCNT12
#define MDC1CNT_MDCCNT13                _MDC1CNT.Bits.MDCCNT13
#define MDC1CNT_MDCCNT14                _MDC1CNT.Bits.MDCCNT14
#define MDC1CNT_MDCCNT15                _MDC1CNT.Bits.MDCCNT15

#define MDC1CNT_MDCCNT0_MASK            1U
#define MDC1CNT_MDCCNT1_MASK            2U
#define MDC1CNT_MDCCNT2_MASK            4U
#define MDC1CNT_MDCCNT3_MASK            8U
#define MDC1CNT_MDCCNT4_MASK            16U
#define MDC1CNT_MDCCNT5_MASK            32U
#define MDC1CNT_MDCCNT6_MASK            64U
#define MDC1CNT_MDCCNT7_MASK            128U
#define MDC1CNT_MDCCNT8_MASK            256U
#define MDC1CNT_MDCCNT9_MASK            512U
#define MDC1CNT_MDCCNT10_MASK           1024U
#define MDC1CNT_MDCCNT11_MASK           2048U
#define MDC1CNT_MDCCNT12_MASK           4096U
#define MDC1CNT_MDCCNT13_MASK           8192U
#define MDC1CNT_MDCCNT14_MASK           16384U
#define MDC1CNT_MDCCNT15_MASK           32768U


/*** ITG1ACC - SSD 1 Integration Accumulator register; 0x00000296 ***/
typedef union {
  word Word;
  struct {
    word ITGACC0     :1;                                       /* Integration Accumulator Bits, bit 0 */
    word ITGACC1     :1;                                       /* Integration Accumulator Bits, bit 1 */
    word ITGACC2     :1;                                       /* Integration Accumulator Bits, bit 2 */
    word ITGACC3     :1;                                       /* Integration Accumulator Bits, bit 3 */
    word ITGACC4     :1;                                       /* Integration Accumulator Bits, bit 4 */
    word ITGACC5     :1;                                       /* Integration Accumulator Bits, bit 5 */
    word ITGACC6     :1;                                       /* Integration Accumulator Bits, bit 6 */
    word ITGACC7     :1;                                       /* Integration Accumulator Bits, bit 7 */
    word ITGACC8     :1;                                       /* Integration Accumulator Bits, bit 8 */
    word ITGACC9     :1;                                       /* Integration Accumulator Bits, bit 9 */
    word ITGACC10    :1;                                       /* Integration Accumulator Bits, bit 10 */
    word ITGACC11    :1;                                       /* Integration Accumulator Bits, bit 11 */
    word ITGACC12    :1;                                       /* Integration Accumulator Bits, bit 12 */
    word ITGACC13    :1;                                       /* Integration Accumulator Bits, bit 13 */
    word ITGACC14    :1;                                       /* Integration Accumulator Bits, bit 14 */
    word ITGACC15    :1;                                       /* Integration Accumulator Bits, bit 15 */
  } Bits;
} ITG1ACCSTR;
extern volatile ITG1ACCSTR _ITG1ACC @(REG_BASE + 0x00000296UL);
#define ITG1ACC                         _ITG1ACC.Word
#define ITG1ACC_ITGACC0                 _ITG1ACC.Bits.ITGACC0
#define ITG1ACC_ITGACC1                 _ITG1ACC.Bits.ITGACC1
#define ITG1ACC_ITGACC2                 _ITG1ACC.Bits.ITGACC2
#define ITG1ACC_ITGACC3                 _ITG1ACC.Bits.ITGACC3
#define ITG1ACC_ITGACC4                 _ITG1ACC.Bits.ITGACC4
#define ITG1ACC_ITGACC5                 _ITG1ACC.Bits.ITGACC5
#define ITG1ACC_ITGACC6                 _ITG1ACC.Bits.ITGACC6
#define ITG1ACC_ITGACC7                 _ITG1ACC.Bits.ITGACC7
#define ITG1ACC_ITGACC8                 _ITG1ACC.Bits.ITGACC8
#define ITG1ACC_ITGACC9                 _ITG1ACC.Bits.ITGACC9
#define ITG1ACC_ITGACC10                _ITG1ACC.Bits.ITGACC10
#define ITG1ACC_ITGACC11                _ITG1ACC.Bits.ITGACC11
#define ITG1ACC_ITGACC12                _ITG1ACC.Bits.ITGACC12
#define ITG1ACC_ITGACC13                _ITG1ACC.Bits.ITGACC13
#define ITG1ACC_ITGACC14                _ITG1ACC.Bits.ITGACC14
#define ITG1ACC_ITGACC15                _ITG1ACC.Bits.ITGACC15

#define ITG1ACC_ITGACC0_MASK            1U
#define ITG1ACC_ITGACC1_MASK            2U
#define ITG1ACC_ITGACC2_MASK            4U
#define ITG1ACC_ITGACC3_MASK            8U
#define ITG1ACC_ITGACC4_MASK            16U
#define ITG1ACC_ITGACC5_MASK            32U
#define ITG1ACC_ITGACC6_MASK            64U
#define ITG1ACC_ITGACC7_MASK            128U
#define ITG1ACC_ITGACC8_MASK            256U
#define ITG1ACC_ITGACC9_MASK            512U
#define ITG1ACC_ITGACC10_MASK           1024U
#define ITG1ACC_ITGACC11_MASK           2048U
#define ITG1ACC_ITGACC12_MASK           4096U
#define ITG1ACC_ITGACC13_MASK           8192U
#define ITG1ACC_ITGACC14_MASK           16384U
#define ITG1ACC_ITGACC15_MASK           32768U


/*** RTZ2CTL - SSD 2 Return to Zero Control register; 0x00000298 ***/
typedef union {
  byte Byte;
  struct {
    byte STEP0       :1;                                       /* Full Step State, bit 0 */
    byte STEP1       :1;                                       /* Full Step State, bit 1 */
    byte SMS         :1;                                       /* Stepper Motor Select */
    byte             :1; 
    byte POL         :1;                                       /* Polarity */
    byte RCIR        :1;                                       /* Recirculation in blanking mode */
    byte DCOIL       :1;                                       /* Drive Coil */
    byte ITG         :1;                                       /* Integration */
  } Bits;
  struct {
    byte grpSTEP :2;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} RTZ2CTLSTR;
extern volatile RTZ2CTLSTR _RTZ2CTL @(REG_BASE + 0x00000298UL);
#define RTZ2CTL                         _RTZ2CTL.Byte
#define RTZ2CTL_STEP0                   _RTZ2CTL.Bits.STEP0
#define RTZ2CTL_STEP1                   _RTZ2CTL.Bits.STEP1
#define RTZ2CTL_SMS                     _RTZ2CTL.Bits.SMS
#define RTZ2CTL_POL                     _RTZ2CTL.Bits.POL
#define RTZ2CTL_RCIR                    _RTZ2CTL.Bits.RCIR
#define RTZ2CTL_DCOIL                   _RTZ2CTL.Bits.DCOIL
#define RTZ2CTL_ITG                     _RTZ2CTL.Bits.ITG
#define RTZ2CTL_STEP                    _RTZ2CTL.MergedBits.grpSTEP

#define RTZ2CTL_STEP0_MASK              1U
#define RTZ2CTL_STEP1_MASK              2U
#define RTZ2CTL_SMS_MASK                4U
#define RTZ2CTL_POL_MASK                16U
#define RTZ2CTL_RCIR_MASK               32U
#define RTZ2CTL_DCOIL_MASK              64U
#define RTZ2CTL_ITG_MASK                128U
#define RTZ2CTL_STEP_MASK               3U
#define RTZ2CTL_STEP_BITNUM             0U


/*** MDC2CTL - SSD 2 Modulus Down Counter Control register; 0x00000299 ***/
typedef union {
  byte Byte;
  struct {
    byte AOVIE       :1;                                       /* Accumulator Overflow Interrupt Enable */
    byte             :1; 
    byte MCEN        :1;                                       /* Modulus Down-Counter Enable */
    byte FLMC        :1;                                       /* Force Load Register into the Modulus Counter Count Register */
    byte PRE         :1;                                       /* Prescalar */
    byte RDMCL       :1;                                       /* Read Modulus Down-Counter Load */
    byte MODMC       :1;                                       /* Modulus Mode Enable */
    byte MCZIE       :1;                                       /* Modulus Counter Underflow Interrupt Enable */
  } Bits;
} MDC2CTLSTR;
extern volatile MDC2CTLSTR _MDC2CTL @(REG_BASE + 0x00000299UL);
#define MDC2CTL                         _MDC2CTL.Byte
#define MDC2CTL_AOVIE                   _MDC2CTL.Bits.AOVIE
#define MDC2CTL_MCEN                    _MDC2CTL.Bits.MCEN
#define MDC2CTL_FLMC                    _MDC2CTL.Bits.FLMC
#define MDC2CTL_PRE                     _MDC2CTL.Bits.PRE
#define MDC2CTL_RDMCL                   _MDC2CTL.Bits.RDMCL
#define MDC2CTL_MODMC                   _MDC2CTL.Bits.MODMC
#define MDC2CTL_MCZIE                   _MDC2CTL.Bits.MCZIE

#define MDC2CTL_AOVIE_MASK              1U
#define MDC2CTL_MCEN_MASK               4U
#define MDC2CTL_FLMC_MASK               8U
#define MDC2CTL_PRE_MASK                16U
#define MDC2CTL_RDMCL_MASK              32U
#define MDC2CTL_MODMC_MASK              64U
#define MDC2CTL_MCZIE_MASK              128U


/*** SSD2CTL - SSD 2 Stepper Stall Detector Control register; 0x0000029A ***/
typedef union {
  byte Byte;
  struct {
    byte ACLKS0      :1;                                       /* Accumulator Sample Frequency Select, bit 0 */
    byte ACLKS1      :1;                                       /* Accumulator Sample Frequency Select, bit 1 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte SSDWAI      :1;                                       /* SSD Disabled during Wait Mode */
    byte SDCPU       :1;                                       /* Sigma-Delta Converter Power Up */
    byte RTZE        :1;                                       /* Return to Zero Enable */
  } Bits;
  struct {
    byte grpACLKS :2;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} SSD2CTLSTR;
extern volatile SSD2CTLSTR _SSD2CTL @(REG_BASE + 0x0000029AUL);
#define SSD2CTL                         _SSD2CTL.Byte
#define SSD2CTL_ACLKS0                  _SSD2CTL.Bits.ACLKS0
#define SSD2CTL_ACLKS1                  _SSD2CTL.Bits.ACLKS1
#define SSD2CTL_SSDWAI                  _SSD2CTL.Bits.SSDWAI
#define SSD2CTL_SDCPU                   _SSD2CTL.Bits.SDCPU
#define SSD2CTL_RTZE                    _SSD2CTL.Bits.RTZE
#define SSD2CTL_ACLKS                   _SSD2CTL.MergedBits.grpACLKS

#define SSD2CTL_ACLKS0_MASK             1U
#define SSD2CTL_ACLKS1_MASK             2U
#define SSD2CTL_SSDWAI_MASK             32U
#define SSD2CTL_SDCPU_MASK              64U
#define SSD2CTL_RTZE_MASK               128U
#define SSD2CTL_ACLKS_MASK              3U
#define SSD2CTL_ACLKS_BITNUM            0U


/*** SSD2FLG - SSD 2 Stepper Stall Detector Flag register; 0x0000029B ***/
typedef union {
  byte Byte;
  struct {
    byte AOVIF       :1;                                       /* Accumulator Overflow Interrupt Flag */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte MCZIF       :1;                                       /* Modulus Counter Underflow Interrupt Flag */
  } Bits;
} SSD2FLGSTR;
extern volatile SSD2FLGSTR _SSD2FLG @(REG_BASE + 0x0000029BUL);
#define SSD2FLG                         _SSD2FLG.Byte
#define SSD2FLG_AOVIF                   _SSD2FLG.Bits.AOVIF
#define SSD2FLG_MCZIF                   _SSD2FLG.Bits.MCZIF

#define SSD2FLG_AOVIF_MASK              1U
#define SSD2FLG_MCZIF_MASK              128U


/*** MDC2CNT - SSD 2 Modulus Down-Counter Count register; 0x0000029C ***/
typedef union {
  word Word;
  struct {
    word MDCCNT0     :1;                                       /* Modulus Down-Counter Count Bits, bit 0 */
    word MDCCNT1     :1;                                       /* Modulus Down-Counter Count Bits, bit 1 */
    word MDCCNT2     :1;                                       /* Modulus Down-Counter Count Bits, bit 2 */
    word MDCCNT3     :1;                                       /* Modulus Down-Counter Count Bits, bit 3 */
    word MDCCNT4     :1;                                       /* Modulus Down-Counter Count Bits, bit 4 */
    word MDCCNT5     :1;                                       /* Modulus Down-Counter Count Bits, bit 5 */
    word MDCCNT6     :1;                                       /* Modulus Down-Counter Count Bits, bit 6 */
    word MDCCNT7     :1;                                       /* Modulus Down-Counter Count Bits, bit 7 */
    word MDCCNT8     :1;                                       /* Modulus Down-Counter Count Bits, bit 8 */
    word MDCCNT9     :1;                                       /* Modulus Down-Counter Count Bits, bit 9 */
    word MDCCNT10    :1;                                       /* Modulus Down-Counter Count Bits, bit 10 */
    word MDCCNT11    :1;                                       /* Modulus Down-Counter Count Bits, bit 11 */
    word MDCCNT12    :1;                                       /* Modulus Down-Counter Count Bits, bit 12 */
    word MDCCNT13    :1;                                       /* Modulus Down-Counter Count Bits, bit 13 */
    word MDCCNT14    :1;                                       /* Modulus Down-Counter Count Bits, bit 14 */
    word MDCCNT15    :1;                                       /* Modulus Down-Counter Count Bits, bit 15 */
  } Bits;
} MDC2CNTSTR;
extern volatile MDC2CNTSTR _MDC2CNT @(REG_BASE + 0x0000029CUL);
#define MDC2CNT                         _MDC2CNT.Word
#define MDC2CNT_MDCCNT0                 _MDC2CNT.Bits.MDCCNT0
#define MDC2CNT_MDCCNT1                 _MDC2CNT.Bits.MDCCNT1
#define MDC2CNT_MDCCNT2                 _MDC2CNT.Bits.MDCCNT2
#define MDC2CNT_MDCCNT3                 _MDC2CNT.Bits.MDCCNT3
#define MDC2CNT_MDCCNT4                 _MDC2CNT.Bits.MDCCNT4
#define MDC2CNT_MDCCNT5                 _MDC2CNT.Bits.MDCCNT5
#define MDC2CNT_MDCCNT6                 _MDC2CNT.Bits.MDCCNT6
#define MDC2CNT_MDCCNT7                 _MDC2CNT.Bits.MDCCNT7
#define MDC2CNT_MDCCNT8                 _MDC2CNT.Bits.MDCCNT8
#define MDC2CNT_MDCCNT9                 _MDC2CNT.Bits.MDCCNT9
#define MDC2CNT_MDCCNT10                _MDC2CNT.Bits.MDCCNT10
#define MDC2CNT_MDCCNT11                _MDC2CNT.Bits.MDCCNT11
#define MDC2CNT_MDCCNT12                _MDC2CNT.Bits.MDCCNT12
#define MDC2CNT_MDCCNT13                _MDC2CNT.Bits.MDCCNT13
#define MDC2CNT_MDCCNT14                _MDC2CNT.Bits.MDCCNT14
#define MDC2CNT_MDCCNT15                _MDC2CNT.Bits.MDCCNT15

#define MDC2CNT_MDCCNT0_MASK            1U
#define MDC2CNT_MDCCNT1_MASK            2U
#define MDC2CNT_MDCCNT2_MASK            4U
#define MDC2CNT_MDCCNT3_MASK            8U
#define MDC2CNT_MDCCNT4_MASK            16U
#define MDC2CNT_MDCCNT5_MASK            32U
#define MDC2CNT_MDCCNT6_MASK            64U
#define MDC2CNT_MDCCNT7_MASK            128U
#define MDC2CNT_MDCCNT8_MASK            256U
#define MDC2CNT_MDCCNT9_MASK            512U
#define MDC2CNT_MDCCNT10_MASK           1024U
#define MDC2CNT_MDCCNT11_MASK           2048U
#define MDC2CNT_MDCCNT12_MASK           4096U
#define MDC2CNT_MDCCNT13_MASK           8192U
#define MDC2CNT_MDCCNT14_MASK           16384U
#define MDC2CNT_MDCCNT15_MASK           32768U


/*** ITG2ACC - SSD 2 Integration Accumulator register; 0x0000029E ***/
typedef union {
  word Word;
  struct {
    word ITGACC0     :1;                                       /* Integration Accumulator Bits, bit 0 */
    word ITGACC1     :1;                                       /* Integration Accumulator Bits, bit 1 */
    word ITGACC2     :1;                                       /* Integration Accumulator Bits, bit 2 */
    word ITGACC3     :1;                                       /* Integration Accumulator Bits, bit 3 */
    word ITGACC4     :1;                                       /* Integration Accumulator Bits, bit 4 */
    word ITGACC5     :1;                                       /* Integration Accumulator Bits, bit 5 */
    word ITGACC6     :1;                                       /* Integration Accumulator Bits, bit 6 */
    word ITGACC7     :1;                                       /* Integration Accumulator Bits, bit 7 */
    word ITGACC8     :1;                                       /* Integration Accumulator Bits, bit 8 */
    word ITGACC9     :1;                                       /* Integration Accumulator Bits, bit 9 */
    word ITGACC10    :1;                                       /* Integration Accumulator Bits, bit 10 */
    word ITGACC11    :1;                                       /* Integration Accumulator Bits, bit 11 */
    word ITGACC12    :1;                                       /* Integration Accumulator Bits, bit 12 */
    word ITGACC13    :1;                                       /* Integration Accumulator Bits, bit 13 */
    word ITGACC14    :1;                                       /* Integration Accumulator Bits, bit 14 */
    word ITGACC15    :1;                                       /* Integration Accumulator Bits, bit 15 */
  } Bits;
} ITG2ACCSTR;
extern volatile ITG2ACCSTR _ITG2ACC @(REG_BASE + 0x0000029EUL);
#define ITG2ACC                         _ITG2ACC.Word
#define ITG2ACC_ITGACC0                 _ITG2ACC.Bits.ITGACC0
#define ITG2ACC_ITGACC1                 _ITG2ACC.Bits.ITGACC1
#define ITG2ACC_ITGACC2                 _ITG2ACC.Bits.ITGACC2
#define ITG2ACC_ITGACC3                 _ITG2ACC.Bits.ITGACC3
#define ITG2ACC_ITGACC4                 _ITG2ACC.Bits.ITGACC4
#define ITG2ACC_ITGACC5                 _ITG2ACC.Bits.ITGACC5
#define ITG2ACC_ITGACC6                 _ITG2ACC.Bits.ITGACC6
#define ITG2ACC_ITGACC7                 _ITG2ACC.Bits.ITGACC7
#define ITG2ACC_ITGACC8                 _ITG2ACC.Bits.ITGACC8
#define ITG2ACC_ITGACC9                 _ITG2ACC.Bits.ITGACC9
#define ITG2ACC_ITGACC10                _ITG2ACC.Bits.ITGACC10
#define ITG2ACC_ITGACC11                _ITG2ACC.Bits.ITGACC11
#define ITG2ACC_ITGACC12                _ITG2ACC.Bits.ITGACC12
#define ITG2ACC_ITGACC13                _ITG2ACC.Bits.ITGACC13
#define ITG2ACC_ITGACC14                _ITG2ACC.Bits.ITGACC14
#define ITG2ACC_ITGACC15                _ITG2ACC.Bits.ITGACC15

#define ITG2ACC_ITGACC0_MASK            1U
#define ITG2ACC_ITGACC1_MASK            2U
#define ITG2ACC_ITGACC2_MASK            4U
#define ITG2ACC_ITGACC3_MASK            8U
#define ITG2ACC_ITGACC4_MASK            16U
#define ITG2ACC_ITGACC5_MASK            32U
#define ITG2ACC_ITGACC6_MASK            64U
#define ITG2ACC_ITGACC7_MASK            128U
#define ITG2ACC_ITGACC8_MASK            256U
#define ITG2ACC_ITGACC9_MASK            512U
#define ITG2ACC_ITGACC10_MASK           1024U
#define ITG2ACC_ITGACC11_MASK           2048U
#define ITG2ACC_ITGACC12_MASK           4096U
#define ITG2ACC_ITGACC13_MASK           8192U
#define ITG2ACC_ITGACC14_MASK           16384U
#define ITG2ACC_ITGACC15_MASK           32768U


/*** RTZ3CTL - SSD 3 Return to Zero Control register; 0x000002A0 ***/
typedef union {
  byte Byte;
  struct {
    byte STEP0       :1;                                       /* Full Step State, bit 0 */
    byte STEP1       :1;                                       /* Full Step State, bit 1 */
    byte SMS         :1;                                       /* Stepper Motor Select */
    byte             :1; 
    byte POL         :1;                                       /* Polarity */
    byte RCIR        :1;                                       /* Recirculation in blanking mode */
    byte DCOIL       :1;                                       /* Drive Coil */
    byte ITG         :1;                                       /* Integration */
  } Bits;
  struct {
    byte grpSTEP :2;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} RTZ3CTLSTR;
extern volatile RTZ3CTLSTR _RTZ3CTL @(REG_BASE + 0x000002A0UL);
#define RTZ3CTL                         _RTZ3CTL.Byte
#define RTZ3CTL_STEP0                   _RTZ3CTL.Bits.STEP0
#define RTZ3CTL_STEP1                   _RTZ3CTL.Bits.STEP1
#define RTZ3CTL_SMS                     _RTZ3CTL.Bits.SMS
#define RTZ3CTL_POL                     _RTZ3CTL.Bits.POL
#define RTZ3CTL_RCIR                    _RTZ3CTL.Bits.RCIR
#define RTZ3CTL_DCOIL                   _RTZ3CTL.Bits.DCOIL
#define RTZ3CTL_ITG                     _RTZ3CTL.Bits.ITG
#define RTZ3CTL_STEP                    _RTZ3CTL.MergedBits.grpSTEP

#define RTZ3CTL_STEP0_MASK              1U
#define RTZ3CTL_STEP1_MASK              2U
#define RTZ3CTL_SMS_MASK                4U
#define RTZ3CTL_POL_MASK                16U
#define RTZ3CTL_RCIR_MASK               32U
#define RTZ3CTL_DCOIL_MASK              64U
#define RTZ3CTL_ITG_MASK                128U
#define RTZ3CTL_STEP_MASK               3U
#define RTZ3CTL_STEP_BITNUM             0U


/*** MDC3CTL - SSD 3 Modulus Down Counter Control register; 0x000002A1 ***/
typedef union {
  byte Byte;
  struct {
    byte AOVIE       :1;                                       /* Accumulator Overflow Interrupt Enable */
    byte             :1; 
    byte MCEN        :1;                                       /* Modulus Down-Counter Enable */
    byte FLMC        :1;                                       /* Force Load Register into the Modulus Counter Count Register */
    byte PRE         :1;                                       /* Prescalar */
    byte RDMCL       :1;                                       /* Read Modulus Down-Counter Load */
    byte MODMC       :1;                                       /* Modulus Mode Enable */
    byte MCZIE       :1;                                       /* Modulus Counter Underflow Interrupt Enable */
  } Bits;
} MDC3CTLSTR;
extern volatile MDC3CTLSTR _MDC3CTL @(REG_BASE + 0x000002A1UL);
#define MDC3CTL                         _MDC3CTL.Byte
#define MDC3CTL_AOVIE                   _MDC3CTL.Bits.AOVIE
#define MDC3CTL_MCEN                    _MDC3CTL.Bits.MCEN
#define MDC3CTL_FLMC                    _MDC3CTL.Bits.FLMC
#define MDC3CTL_PRE                     _MDC3CTL.Bits.PRE
#define MDC3CTL_RDMCL                   _MDC3CTL.Bits.RDMCL
#define MDC3CTL_MODMC                   _MDC3CTL.Bits.MODMC
#define MDC3CTL_MCZIE                   _MDC3CTL.Bits.MCZIE

#define MDC3CTL_AOVIE_MASK              1U
#define MDC3CTL_MCEN_MASK               4U
#define MDC3CTL_FLMC_MASK               8U
#define MDC3CTL_PRE_MASK                16U
#define MDC3CTL_RDMCL_MASK              32U
#define MDC3CTL_MODMC_MASK              64U
#define MDC3CTL_MCZIE_MASK              128U


/*** SSD3CTL - SSD 3 Stepper Stall Detector Control register; 0x000002A2 ***/
typedef union {
  byte Byte;
  struct {
    byte ACLKS0      :1;                                       /* Accumulator Sample Frequency Select, bit 0 */
    byte ACLKS1      :1;                                       /* Accumulator Sample Frequency Select, bit 1 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte SSDWAI      :1;                                       /* SSD Disabled during Wait Mode */
    byte SDCPU       :1;                                       /* Sigma-Delta Converter Power Up */
    byte RTZE        :1;                                       /* Return to Zero Enable */
  } Bits;
  struct {
    byte grpACLKS :2;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} SSD3CTLSTR;
extern volatile SSD3CTLSTR _SSD3CTL @(REG_BASE + 0x000002A2UL);
#define SSD3CTL                         _SSD3CTL.Byte
#define SSD3CTL_ACLKS0                  _SSD3CTL.Bits.ACLKS0
#define SSD3CTL_ACLKS1                  _SSD3CTL.Bits.ACLKS1
#define SSD3CTL_SSDWAI                  _SSD3CTL.Bits.SSDWAI
#define SSD3CTL_SDCPU                   _SSD3CTL.Bits.SDCPU
#define SSD3CTL_RTZE                    _SSD3CTL.Bits.RTZE
#define SSD3CTL_ACLKS                   _SSD3CTL.MergedBits.grpACLKS

#define SSD3CTL_ACLKS0_MASK             1U
#define SSD3CTL_ACLKS1_MASK             2U
#define SSD3CTL_SSDWAI_MASK             32U
#define SSD3CTL_SDCPU_MASK              64U
#define SSD3CTL_RTZE_MASK               128U
#define SSD3CTL_ACLKS_MASK              3U
#define SSD3CTL_ACLKS_BITNUM            0U


/*** SSD3FLG - SSD 3 Stepper Stall Detector Flag register; 0x000002A3 ***/
typedef union {
  byte Byte;
  struct {
    byte AOVIF       :1;                                       /* Accumulator Overflow Interrupt Flag */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte MCZIF       :1;                                       /* Modulus Counter Underflow Interrupt Flag */
  } Bits;
} SSD3FLGSTR;
extern volatile SSD3FLGSTR _SSD3FLG @(REG_BASE + 0x000002A3UL);
#define SSD3FLG                         _SSD3FLG.Byte
#define SSD3FLG_AOVIF                   _SSD3FLG.Bits.AOVIF
#define SSD3FLG_MCZIF                   _SSD3FLG.Bits.MCZIF

#define SSD3FLG_AOVIF_MASK              1U
#define SSD3FLG_MCZIF_MASK              128U


/*** MDC3CNT - SSD 3 Modulus Down-Counter Count register; 0x000002A4 ***/
typedef union {
  word Word;
  struct {
    word MDCCNT0     :1;                                       /* Modulus Down-Counter Count Bits, bit 0 */
    word MDCCNT1     :1;                                       /* Modulus Down-Counter Count Bits, bit 1 */
    word MDCCNT2     :1;                                       /* Modulus Down-Counter Count Bits, bit 2 */
    word MDCCNT3     :1;                                       /* Modulus Down-Counter Count Bits, bit 3 */
    word MDCCNT4     :1;                                       /* Modulus Down-Counter Count Bits, bit 4 */
    word MDCCNT5     :1;                                       /* Modulus Down-Counter Count Bits, bit 5 */
    word MDCCNT6     :1;                                       /* Modulus Down-Counter Count Bits, bit 6 */
    word MDCCNT7     :1;                                       /* Modulus Down-Counter Count Bits, bit 7 */
    word MDCCNT8     :1;                                       /* Modulus Down-Counter Count Bits, bit 8 */
    word MDCCNT9     :1;                                       /* Modulus Down-Counter Count Bits, bit 9 */
    word MDCCNT10    :1;                                       /* Modulus Down-Counter Count Bits, bit 10 */
    word MDCCNT11    :1;                                       /* Modulus Down-Counter Count Bits, bit 11 */
    word MDCCNT12    :1;                                       /* Modulus Down-Counter Count Bits, bit 12 */
    word MDCCNT13    :1;                                       /* Modulus Down-Counter Count Bits, bit 13 */
    word MDCCNT14    :1;                                       /* Modulus Down-Counter Count Bits, bit 14 */
    word MDCCNT15    :1;                                       /* Modulus Down-Counter Count Bits, bit 15 */
  } Bits;
} MDC3CNTSTR;
extern volatile MDC3CNTSTR _MDC3CNT @(REG_BASE + 0x000002A4UL);
#define MDC3CNT                         _MDC3CNT.Word
#define MDC3CNT_MDCCNT0                 _MDC3CNT.Bits.MDCCNT0
#define MDC3CNT_MDCCNT1                 _MDC3CNT.Bits.MDCCNT1
#define MDC3CNT_MDCCNT2                 _MDC3CNT.Bits.MDCCNT2
#define MDC3CNT_MDCCNT3                 _MDC3CNT.Bits.MDCCNT3
#define MDC3CNT_MDCCNT4                 _MDC3CNT.Bits.MDCCNT4
#define MDC3CNT_MDCCNT5                 _MDC3CNT.Bits.MDCCNT5
#define MDC3CNT_MDCCNT6                 _MDC3CNT.Bits.MDCCNT6
#define MDC3CNT_MDCCNT7                 _MDC3CNT.Bits.MDCCNT7
#define MDC3CNT_MDCCNT8                 _MDC3CNT.Bits.MDCCNT8
#define MDC3CNT_MDCCNT9                 _MDC3CNT.Bits.MDCCNT9
#define MDC3CNT_MDCCNT10                _MDC3CNT.Bits.MDCCNT10
#define MDC3CNT_MDCCNT11                _MDC3CNT.Bits.MDCCNT11
#define MDC3CNT_MDCCNT12                _MDC3CNT.Bits.MDCCNT12
#define MDC3CNT_MDCCNT13                _MDC3CNT.Bits.MDCCNT13
#define MDC3CNT_MDCCNT14                _MDC3CNT.Bits.MDCCNT14
#define MDC3CNT_MDCCNT15                _MDC3CNT.Bits.MDCCNT15

#define MDC3CNT_MDCCNT0_MASK            1U
#define MDC3CNT_MDCCNT1_MASK            2U
#define MDC3CNT_MDCCNT2_MASK            4U
#define MDC3CNT_MDCCNT3_MASK            8U
#define MDC3CNT_MDCCNT4_MASK            16U
#define MDC3CNT_MDCCNT5_MASK            32U
#define MDC3CNT_MDCCNT6_MASK            64U
#define MDC3CNT_MDCCNT7_MASK            128U
#define MDC3CNT_MDCCNT8_MASK            256U
#define MDC3CNT_MDCCNT9_MASK            512U
#define MDC3CNT_MDCCNT10_MASK           1024U
#define MDC3CNT_MDCCNT11_MASK           2048U
#define MDC3CNT_MDCCNT12_MASK           4096U
#define MDC3CNT_MDCCNT13_MASK           8192U
#define MDC3CNT_MDCCNT14_MASK           16384U
#define MDC3CNT_MDCCNT15_MASK           32768U


/*** ITG3ACC - SSD 3 Integration Accumulator register; 0x000002A6 ***/
typedef union {
  word Word;
  struct {
    word ITGACC0     :1;                                       /* Integration Accumulator Bits, bit 0 */
    word ITGACC1     :1;                                       /* Integration Accumulator Bits, bit 1 */
    word ITGACC2     :1;                                       /* Integration Accumulator Bits, bit 2 */
    word ITGACC3     :1;                                       /* Integration Accumulator Bits, bit 3 */
    word ITGACC4     :1;                                       /* Integration Accumulator Bits, bit 4 */
    word ITGACC5     :1;                                       /* Integration Accumulator Bits, bit 5 */
    word ITGACC6     :1;                                       /* Integration Accumulator Bits, bit 6 */
    word ITGACC7     :1;                                       /* Integration Accumulator Bits, bit 7 */
    word ITGACC8     :1;                                       /* Integration Accumulator Bits, bit 8 */
    word ITGACC9     :1;                                       /* Integration Accumulator Bits, bit 9 */
    word ITGACC10    :1;                                       /* Integration Accumulator Bits, bit 10 */
    word ITGACC11    :1;                                       /* Integration Accumulator Bits, bit 11 */
    word ITGACC12    :1;                                       /* Integration Accumulator Bits, bit 12 */
    word ITGACC13    :1;                                       /* Integration Accumulator Bits, bit 13 */
    word ITGACC14    :1;                                       /* Integration Accumulator Bits, bit 14 */
    word ITGACC15    :1;                                       /* Integration Accumulator Bits, bit 15 */
  } Bits;
} ITG3ACCSTR;
extern volatile ITG3ACCSTR _ITG3ACC @(REG_BASE + 0x000002A6UL);
#define ITG3ACC                         _ITG3ACC.Word
#define ITG3ACC_ITGACC0                 _ITG3ACC.Bits.ITGACC0
#define ITG3ACC_ITGACC1                 _ITG3ACC.Bits.ITGACC1
#define ITG3ACC_ITGACC2                 _ITG3ACC.Bits.ITGACC2
#define ITG3ACC_ITGACC3                 _ITG3ACC.Bits.ITGACC3
#define ITG3ACC_ITGACC4                 _ITG3ACC.Bits.ITGACC4
#define ITG3ACC_ITGACC5                 _ITG3ACC.Bits.ITGACC5
#define ITG3ACC_ITGACC6                 _ITG3ACC.Bits.ITGACC6
#define ITG3ACC_ITGACC7                 _ITG3ACC.Bits.ITGACC7
#define ITG3ACC_ITGACC8                 _ITG3ACC.Bits.ITGACC8
#define ITG3ACC_ITGACC9                 _ITG3ACC.Bits.ITGACC9
#define ITG3ACC_ITGACC10                _ITG3ACC.Bits.ITGACC10
#define ITG3ACC_ITGACC11                _ITG3ACC.Bits.ITGACC11
#define ITG3ACC_ITGACC12                _ITG3ACC.Bits.ITGACC12
#define ITG3ACC_ITGACC13                _ITG3ACC.Bits.ITGACC13
#define ITG3ACC_ITGACC14                _ITG3ACC.Bits.ITGACC14
#define ITG3ACC_ITGACC15                _ITG3ACC.Bits.ITGACC15

#define ITG3ACC_ITGACC0_MASK            1U
#define ITG3ACC_ITGACC1_MASK            2U
#define ITG3ACC_ITGACC2_MASK            4U
#define ITG3ACC_ITGACC3_MASK            8U
#define ITG3ACC_ITGACC4_MASK            16U
#define ITG3ACC_ITGACC5_MASK            32U
#define ITG3ACC_ITGACC6_MASK            64U
#define ITG3ACC_ITGACC7_MASK            128U
#define ITG3ACC_ITGACC8_MASK            256U
#define ITG3ACC_ITGACC9_MASK            512U
#define ITG3ACC_ITGACC10_MASK           1024U
#define ITG3ACC_ITGACC11_MASK           2048U
#define ITG3ACC_ITGACC12_MASK           4096U
#define ITG3ACC_ITGACC13_MASK           8192U
#define ITG3ACC_ITGACC14_MASK           16384U
#define ITG3ACC_ITGACC15_MASK           32768U


/*** BAKEY0 - Backdoor Access Key 0; 0x0000FF00 ***/
typedef union {
  word Word;
  struct {
    word KEY0        :1;                                       /* Backdoor Access Key bits, bit 0 */
    word KEY1        :1;                                       /* Backdoor Access Key bits, bit 1 */
    word KEY2        :1;                                       /* Backdoor Access Key bits, bit 2 */
    word KEY3        :1;                                       /* Backdoor Access Key bits, bit 3 */
    word KEY4        :1;                                       /* Backdoor Access Key bits, bit 4 */
    word KEY5        :1;                                       /* Backdoor Access Key bits, bit 5 */
    word KEY6        :1;                                       /* Backdoor Access Key bits, bit 6 */
    word KEY7        :1;                                       /* Backdoor Access Key bits, bit 7 */
    word KEY8        :1;                                       /* Backdoor Access Key bits, bit 8 */
    word KEY9        :1;                                       /* Backdoor Access Key bits, bit 9 */
    word KEY10       :1;                                       /* Backdoor Access Key bits, bit 10 */
    word KEY11       :1;                                       /* Backdoor Access Key bits, bit 11 */
    word KEY12       :1;                                       /* Backdoor Access Key bits, bit 12 */
    word KEY13       :1;                                       /* Backdoor Access Key bits, bit 13 */
    word KEY14       :1;                                       /* Backdoor Access Key bits, bit 14 */
    word KEY15       :1;                                       /* Backdoor Access Key bits, bit 15 */
  } Bits;
} BAKEY0STR;
/* Tip for register initialization in the user code:  const word BAKEY0_INIT @0x0000FF00 = <BAKEY0_INITVAL>; */
#define _BAKEY0 (*(const BAKEY0STR *)0x0000FF00)
#define BAKEY0                          _BAKEY0.Word
#define BAKEY0_KEY0                     _BAKEY0.Bits.KEY0
#define BAKEY0_KEY1                     _BAKEY0.Bits.KEY1
#define BAKEY0_KEY2                     _BAKEY0.Bits.KEY2
#define BAKEY0_KEY3                     _BAKEY0.Bits.KEY3
#define BAKEY0_KEY4                     _BAKEY0.Bits.KEY4
#define BAKEY0_KEY5                     _BAKEY0.Bits.KEY5
#define BAKEY0_KEY6                     _BAKEY0.Bits.KEY6
#define BAKEY0_KEY7                     _BAKEY0.Bits.KEY7
#define BAKEY0_KEY8                     _BAKEY0.Bits.KEY8
#define BAKEY0_KEY9                     _BAKEY0.Bits.KEY9
#define BAKEY0_KEY10                    _BAKEY0.Bits.KEY10
#define BAKEY0_KEY11                    _BAKEY0.Bits.KEY11
#define BAKEY0_KEY12                    _BAKEY0.Bits.KEY12
#define BAKEY0_KEY13                    _BAKEY0.Bits.KEY13
#define BAKEY0_KEY14                    _BAKEY0.Bits.KEY14
#define BAKEY0_KEY15                    _BAKEY0.Bits.KEY15
/* BAKEY_ARR: Access 4 BAKEYx registers in an array */
#define BAKEY_ARR                       ((volatile word *) &BAKEY0)

#define BAKEY0_KEY0_MASK                1U
#define BAKEY0_KEY1_MASK                2U
#define BAKEY0_KEY2_MASK                4U
#define BAKEY0_KEY3_MASK                8U
#define BAKEY0_KEY4_MASK                16U
#define BAKEY0_KEY5_MASK                32U
#define BAKEY0_KEY6_MASK                64U
#define BAKEY0_KEY7_MASK                128U
#define BAKEY0_KEY8_MASK                256U
#define BAKEY0_KEY9_MASK                512U
#define BAKEY0_KEY10_MASK               1024U
#define BAKEY0_KEY11_MASK               2048U
#define BAKEY0_KEY12_MASK               4096U
#define BAKEY0_KEY13_MASK               8192U
#define BAKEY0_KEY14_MASK               16384U
#define BAKEY0_KEY15_MASK               32768U


/*** BAKEY1 - Backdoor Access Key 1; 0x0000FF02 ***/
typedef union {
  word Word;
  struct {
    word KEY0        :1;                                       /* Backdoor Access Key bits, bit 0 */
    word KEY1        :1;                                       /* Backdoor Access Key bits, bit 1 */
    word KEY2        :1;                                       /* Backdoor Access Key bits, bit 2 */
    word KEY3        :1;                                       /* Backdoor Access Key bits, bit 3 */
    word KEY4        :1;                                       /* Backdoor Access Key bits, bit 4 */
    word KEY5        :1;                                       /* Backdoor Access Key bits, bit 5 */
    word KEY6        :1;                                       /* Backdoor Access Key bits, bit 6 */
    word KEY7        :1;                                       /* Backdoor Access Key bits, bit 7 */
    word KEY8        :1;                                       /* Backdoor Access Key bits, bit 8 */
    word KEY9        :1;                                       /* Backdoor Access Key bits, bit 9 */
    word KEY10       :1;                                       /* Backdoor Access Key bits, bit 10 */
    word KEY11       :1;                                       /* Backdoor Access Key bits, bit 11 */
    word KEY12       :1;                                       /* Backdoor Access Key bits, bit 12 */
    word KEY13       :1;                                       /* Backdoor Access Key bits, bit 13 */
    word KEY14       :1;                                       /* Backdoor Access Key bits, bit 14 */
    word KEY15       :1;                                       /* Backdoor Access Key bits, bit 15 */
  } Bits;
} BAKEY1STR;
/* Tip for register initialization in the user code:  const word BAKEY1_INIT @0x0000FF02 = <BAKEY1_INITVAL>; */
#define _BAKEY1 (*(const BAKEY1STR *)0x0000FF02)
#define BAKEY1                          _BAKEY1.Word
#define BAKEY1_KEY0                     _BAKEY1.Bits.KEY0
#define BAKEY1_KEY1                     _BAKEY1.Bits.KEY1
#define BAKEY1_KEY2                     _BAKEY1.Bits.KEY2
#define BAKEY1_KEY3                     _BAKEY1.Bits.KEY3
#define BAKEY1_KEY4                     _BAKEY1.Bits.KEY4
#define BAKEY1_KEY5                     _BAKEY1.Bits.KEY5
#define BAKEY1_KEY6                     _BAKEY1.Bits.KEY6
#define BAKEY1_KEY7                     _BAKEY1.Bits.KEY7
#define BAKEY1_KEY8                     _BAKEY1.Bits.KEY8
#define BAKEY1_KEY9                     _BAKEY1.Bits.KEY9
#define BAKEY1_KEY10                    _BAKEY1.Bits.KEY10
#define BAKEY1_KEY11                    _BAKEY1.Bits.KEY11
#define BAKEY1_KEY12                    _BAKEY1.Bits.KEY12
#define BAKEY1_KEY13                    _BAKEY1.Bits.KEY13
#define BAKEY1_KEY14                    _BAKEY1.Bits.KEY14
#define BAKEY1_KEY15                    _BAKEY1.Bits.KEY15

#define BAKEY1_KEY0_MASK                1U
#define BAKEY1_KEY1_MASK                2U
#define BAKEY1_KEY2_MASK                4U
#define BAKEY1_KEY3_MASK                8U
#define BAKEY1_KEY4_MASK                16U
#define BAKEY1_KEY5_MASK                32U
#define BAKEY1_KEY6_MASK                64U
#define BAKEY1_KEY7_MASK                128U
#define BAKEY1_KEY8_MASK                256U
#define BAKEY1_KEY9_MASK                512U
#define BAKEY1_KEY10_MASK               1024U
#define BAKEY1_KEY11_MASK               2048U
#define BAKEY1_KEY12_MASK               4096U
#define BAKEY1_KEY13_MASK               8192U
#define BAKEY1_KEY14_MASK               16384U
#define BAKEY1_KEY15_MASK               32768U


/*** BAKEY2 - Backdoor Access Key 2; 0x0000FF04 ***/
typedef union {
  word Word;
  struct {
    word KEY0        :1;                                       /* Backdoor Access Key bits, bit 0 */
    word KEY1        :1;                                       /* Backdoor Access Key bits, bit 1 */
    word KEY2        :1;                                       /* Backdoor Access Key bits, bit 2 */
    word KEY3        :1;                                       /* Backdoor Access Key bits, bit 3 */
    word KEY4        :1;                                       /* Backdoor Access Key bits, bit 4 */
    word KEY5        :1;                                       /* Backdoor Access Key bits, bit 5 */
    word KEY6        :1;                                       /* Backdoor Access Key bits, bit 6 */
    word KEY7        :1;                                       /* Backdoor Access Key bits, bit 7 */
    word KEY8        :1;                                       /* Backdoor Access Key bits, bit 8 */
    word KEY9        :1;                                       /* Backdoor Access Key bits, bit 9 */
    word KEY10       :1;                                       /* Backdoor Access Key bits, bit 10 */
    word KEY11       :1;                                       /* Backdoor Access Key bits, bit 11 */
    word KEY12       :1;                                       /* Backdoor Access Key bits, bit 12 */
    word KEY13       :1;                                       /* Backdoor Access Key bits, bit 13 */
    word KEY14       :1;                                       /* Backdoor Access Key bits, bit 14 */
    word KEY15       :1;                                       /* Backdoor Access Key bits, bit 15 */
  } Bits;
} BAKEY2STR;
/* Tip for register initialization in the user code:  const word BAKEY2_INIT @0x0000FF04 = <BAKEY2_INITVAL>; */
#define _BAKEY2 (*(const BAKEY2STR *)0x0000FF04)
#define BAKEY2                          _BAKEY2.Word
#define BAKEY2_KEY0                     _BAKEY2.Bits.KEY0
#define BAKEY2_KEY1                     _BAKEY2.Bits.KEY1
#define BAKEY2_KEY2                     _BAKEY2.Bits.KEY2
#define BAKEY2_KEY3                     _BAKEY2.Bits.KEY3
#define BAKEY2_KEY4                     _BAKEY2.Bits.KEY4
#define BAKEY2_KEY5                     _BAKEY2.Bits.KEY5
#define BAKEY2_KEY6                     _BAKEY2.Bits.KEY6
#define BAKEY2_KEY7                     _BAKEY2.Bits.KEY7
#define BAKEY2_KEY8                     _BAKEY2.Bits.KEY8
#define BAKEY2_KEY9                     _BAKEY2.Bits.KEY9
#define BAKEY2_KEY10                    _BAKEY2.Bits.KEY10
#define BAKEY2_KEY11                    _BAKEY2.Bits.KEY11
#define BAKEY2_KEY12                    _BAKEY2.Bits.KEY12
#define BAKEY2_KEY13                    _BAKEY2.Bits.KEY13
#define BAKEY2_KEY14                    _BAKEY2.Bits.KEY14
#define BAKEY2_KEY15                    _BAKEY2.Bits.KEY15

#define BAKEY2_KEY0_MASK                1U
#define BAKEY2_KEY1_MASK                2U
#define BAKEY2_KEY2_MASK                4U
#define BAKEY2_KEY3_MASK                8U
#define BAKEY2_KEY4_MASK                16U
#define BAKEY2_KEY5_MASK                32U
#define BAKEY2_KEY6_MASK                64U
#define BAKEY2_KEY7_MASK                128U
#define BAKEY2_KEY8_MASK                256U
#define BAKEY2_KEY9_MASK                512U
#define BAKEY2_KEY10_MASK               1024U
#define BAKEY2_KEY11_MASK               2048U
#define BAKEY2_KEY12_MASK               4096U
#define BAKEY2_KEY13_MASK               8192U
#define BAKEY2_KEY14_MASK               16384U
#define BAKEY2_KEY15_MASK               32768U


/*** BAKEY3 - Backdoor Access Key 3; 0x0000FF06 ***/
typedef union {
  word Word;
  struct {
    word KEY0        :1;                                       /* Backdoor Access Key bits, bit 0 */
    word KEY1        :1;                                       /* Backdoor Access Key bits, bit 1 */
    word KEY2        :1;                                       /* Backdoor Access Key bits, bit 2 */
    word KEY3        :1;                                       /* Backdoor Access Key bits, bit 3 */
    word KEY4        :1;                                       /* Backdoor Access Key bits, bit 4 */
    word KEY5        :1;                                       /* Backdoor Access Key bits, bit 5 */
    word KEY6        :1;                                       /* Backdoor Access Key bits, bit 6 */
    word KEY7        :1;                                       /* Backdoor Access Key bits, bit 7 */
    word KEY8        :1;                                       /* Backdoor Access Key bits, bit 8 */
    word KEY9        :1;                                       /* Backdoor Access Key bits, bit 9 */
    word KEY10       :1;                                       /* Backdoor Access Key bits, bit 10 */
    word KEY11       :1;                                       /* Backdoor Access Key bits, bit 11 */
    word KEY12       :1;                                       /* Backdoor Access Key bits, bit 12 */
    word KEY13       :1;                                       /* Backdoor Access Key bits, bit 13 */
    word KEY14       :1;                                       /* Backdoor Access Key bits, bit 14 */
    word KEY15       :1;                                       /* Backdoor Access Key bits, bit 15 */
  } Bits;
} BAKEY3STR;
/* Tip for register initialization in the user code:  const word BAKEY3_INIT @0x0000FF06 = <BAKEY3_INITVAL>; */
#define _BAKEY3 (*(const BAKEY3STR *)0x0000FF06)
#define BAKEY3                          _BAKEY3.Word
#define BAKEY3_KEY0                     _BAKEY3.Bits.KEY0
#define BAKEY3_KEY1                     _BAKEY3.Bits.KEY1
#define BAKEY3_KEY2                     _BAKEY3.Bits.KEY2
#define BAKEY3_KEY3                     _BAKEY3.Bits.KEY3
#define BAKEY3_KEY4                     _BAKEY3.Bits.KEY4
#define BAKEY3_KEY5                     _BAKEY3.Bits.KEY5
#define BAKEY3_KEY6                     _BAKEY3.Bits.KEY6
#define BAKEY3_KEY7                     _BAKEY3.Bits.KEY7
#define BAKEY3_KEY8                     _BAKEY3.Bits.KEY8
#define BAKEY3_KEY9                     _BAKEY3.Bits.KEY9
#define BAKEY3_KEY10                    _BAKEY3.Bits.KEY10
#define BAKEY3_KEY11                    _BAKEY3.Bits.KEY11
#define BAKEY3_KEY12                    _BAKEY3.Bits.KEY12
#define BAKEY3_KEY13                    _BAKEY3.Bits.KEY13
#define BAKEY3_KEY14                    _BAKEY3.Bits.KEY14
#define BAKEY3_KEY15                    _BAKEY3.Bits.KEY15

#define BAKEY3_KEY0_MASK                1U
#define BAKEY3_KEY1_MASK                2U
#define BAKEY3_KEY2_MASK                4U
#define BAKEY3_KEY3_MASK                8U
#define BAKEY3_KEY4_MASK                16U
#define BAKEY3_KEY5_MASK                32U
#define BAKEY3_KEY6_MASK                64U
#define BAKEY3_KEY7_MASK                128U
#define BAKEY3_KEY8_MASK                256U
#define BAKEY3_KEY9_MASK                512U
#define BAKEY3_KEY10_MASK               1024U
#define BAKEY3_KEY11_MASK               2048U
#define BAKEY3_KEY12_MASK               4096U
#define BAKEY3_KEY13_MASK               8192U
#define BAKEY3_KEY14_MASK               16384U
#define BAKEY3_KEY15_MASK               32768U


/*** NVFPROT0 - Non volatile Block 0 Flash Protection Register; 0x0000FF0D ***/
typedef union {
  byte Byte;
  struct {
    byte FPLS0       :1;                                       /* Flash Protection Lower Address size 0 */
    byte FPLS1       :1;                                       /* Flash Protection Lower Address size 1 */
    byte FPLDIS      :1;                                       /* Flash Protection Lower address range disable */
    byte FPHS0       :1;                                       /* Flash Protection Higher address size 0 */
    byte FPHS1       :1;                                       /* Flash Protection Higher address size 1 */
    byte FPHDIS      :1;                                       /* Flash Protection Higher address range disable */
    byte NV6         :1;                                       /* Non Volatile Flag Bit */
    byte FPOPEN      :1;                                       /* Opens the flash block or subsections of it for program or erase */
  } Bits;
  struct {
    byte grpFPLS :2;
    byte         :1;
    byte grpFPHS :2;
    byte         :1;
    byte grpNV_6 :1;
    byte         :1;
  } MergedBits;
} NVFPROT0STR;
/* Tip for register initialization in the user code:  const byte NVFPROT0_INIT @0x0000FF0D = <NVFPROT0_INITVAL>; */
#define _NVFPROT0 (*(const NVFPROT0STR *)0x0000FF0D)
#define NVFPROT0                        _NVFPROT0.Byte
#define NVFPROT0_FPLS0                  _NVFPROT0.Bits.FPLS0
#define NVFPROT0_FPLS1                  _NVFPROT0.Bits.FPLS1
#define NVFPROT0_FPLDIS                 _NVFPROT0.Bits.FPLDIS
#define NVFPROT0_FPHS0                  _NVFPROT0.Bits.FPHS0
#define NVFPROT0_FPHS1                  _NVFPROT0.Bits.FPHS1
#define NVFPROT0_FPHDIS                 _NVFPROT0.Bits.FPHDIS
#define NVFPROT0_NV6                    _NVFPROT0.Bits.NV6
#define NVFPROT0_FPOPEN                 _NVFPROT0.Bits.FPOPEN
#define NVFPROT0_FPLS                   _NVFPROT0.MergedBits.grpFPLS
#define NVFPROT0_FPHS                   _NVFPROT0.MergedBits.grpFPHS

#define NVFPROT0_FPLS0_MASK             1U
#define NVFPROT0_FPLS1_MASK             2U
#define NVFPROT0_FPLDIS_MASK            4U
#define NVFPROT0_FPHS0_MASK             8U
#define NVFPROT0_FPHS1_MASK             16U
#define NVFPROT0_FPHDIS_MASK            32U
#define NVFPROT0_NV6_MASK               64U
#define NVFPROT0_FPOPEN_MASK            128U
#define NVFPROT0_FPLS_MASK              3U
#define NVFPROT0_FPLS_BITNUM            0U
#define NVFPROT0_FPHS_MASK              24U
#define NVFPROT0_FPHS_BITNUM            3U


/*** NVFSEC - Non volatile Flash Security Register; 0x0000FF0F ***/
typedef union {
  byte Byte;
  struct {
    byte SEC0        :1;                                       /* Memory security bit 0 */
    byte SEC1        :1;                                       /* Memory security bit 1 */
    byte NV2         :1;                                       /* Non Volatile flag bit 2 */
    byte NV3         :1;                                       /* Non Volatile flag bit 3 */
    byte NV4         :1;                                       /* Non Volatile flag bit 4 */
    byte NV5         :1;                                       /* Non Volatile flag bit 5 */
    byte NV6         :1;                                       /* Non Volatile flag bit 6 */
    byte KEYEN       :1;                                       /* Backdoor Key Security Enable */
  } Bits;
  struct {
    byte grpSEC  :2;
    byte grpNV_2 :5;
    byte         :1;
  } MergedBits;
} NVFSECSTR;
/* Tip for register initialization in the user code:  const byte NVFSEC_INIT @0x0000FF0F = <NVFSEC_INITVAL>; */
#define _NVFSEC (*(const NVFSECSTR *)0x0000FF0F)
#define NVFSEC                          _NVFSEC.Byte
#define NVFSEC_SEC0                     _NVFSEC.Bits.SEC0
#define NVFSEC_SEC1                     _NVFSEC.Bits.SEC1
#define NVFSEC_NV2                      _NVFSEC.Bits.NV2
#define NVFSEC_NV3                      _NVFSEC.Bits.NV3
#define NVFSEC_NV4                      _NVFSEC.Bits.NV4
#define NVFSEC_NV5                      _NVFSEC.Bits.NV5
#define NVFSEC_NV6                      _NVFSEC.Bits.NV6
#define NVFSEC_KEYEN                    _NVFSEC.Bits.KEYEN
#define NVFSEC_SEC                      _NVFSEC.MergedBits.grpSEC
#define NVFSEC_NV_2                     _NVFSEC.MergedBits.grpNV_2
#define NVFSEC_NV                       NVFSEC_NV_2

#define NVFSEC_SEC0_MASK                1U
#define NVFSEC_SEC1_MASK                2U
#define NVFSEC_NV2_MASK                 4U
#define NVFSEC_NV3_MASK                 8U
#define NVFSEC_NV4_MASK                 16U
#define NVFSEC_NV5_MASK                 32U
#define NVFSEC_NV6_MASK                 64U
#define NVFSEC_KEYEN_MASK               128U
#define NVFSEC_SEC_MASK                 3U
#define NVFSEC_SEC_BITNUM               0U
#define NVFSEC_NV_2_MASK                124U
#define NVFSEC_NV_2_BITNUM              2U


  /* Watchdog reset macro */
#ifndef __RESET_WATCHDOG
#ifdef _lint
  #define __RESET_WATCHDOG()  /* empty */
#else
  #define __RESET_WATCHDOG() (void)(ARMCOP = 0x55U, ARMCOP = 0xAAU)
#endif
#endif /* __RESET_WATCHDOG */


/***********************************************/
/**   D E P R E C I A T E D   S Y M B O L S   **/
/***********************************************/
/* --------------------------------------------------------------------------- */
/* The following symbols were removed, because they were invalid or irrelevant */
/* --------------------------------------------------------------------------- */
#define FCNFG_BKSEL                      This_symb_has_been_depreciated
#define FCNFG_BKSEL_MASK                 This_symb_has_been_depreciated



/* **** 2.9.2008 8:32:25 */

#define VectorNumber_VReserved50         VectorNumber_Vssd3
#define VectorNumber_VReserved49         VectorNumber_Vssd2
#define VReserved50                      Vssd3
#define VReserved49                      Vssd2

#ifndef __V30COMPATIBLE__
#pragma OPTION DEL V30toV31Compatible
#endif
/*lint -restore  +esym(961,18.4) +esym(961,19.7) Enable MISRA rule (1.1,18.4,6.4,19.7) checking. */

#endif
