/* Based on CPU DB MC9S12H256, version 2.87.298 (RegistersPrg V1.085) */
/*
** ###################################################################
**     Filename  : MC9S12H128.h
**     Processor : MC9S12H128CPV
**     FileFormat: V1.085
**     DataSheet : 9S12H256BDGV1/D V01.16
**     Compiler  : Metrowerks C compiler
**     Date/Time : 2.7.2004, 12:44
**     Abstract  :
**         This implements an IO devices mapping.
**
**     (c) Copyright UNIS, spol. s r.o. 1997-2003
**     UNIS, spol. s r.o.
**     Jundrovska 33
**     624 00 Brno
**     Czech Republic
**     http      : www.processorexpert.com
**     mail      : info@processorexpert.com
** ###################################################################
*/

#ifndef _MC9S12H128_H
#define _MC9S12H128_H

/* Types definition */
typedef unsigned char byte;
typedef unsigned int word;
typedef unsigned long dword;
typedef unsigned long dlong[2];

#define REG_BASE 0x0000                /* Base address for the I/O register block */


#pragma MESSAGE DISABLE C1106 /* WARNING C1106: Non-standard bitfield type */
#pragma OPTION ADD V30toV31Compatible "-BfaGapLimitBits4294967295" /*this guarantee correct bitfield positions*/

/**************** interrupt vector table ****************/
#define VReserved63             0x0000FF80
#define VReserved62             0x0000FF82
#define VReserved61             0x0000FF84
#define VReserved60             0x0000FF86
#define VReserved59             0x0000FF88
#define Vvreglvi                0x0000FF8A
#define Vpwmesdn                0x0000FF8C
#define VReserved56             0x0000FF8E
#define VReserved55             0x0000FF90
#define VReserved54             0x0000FF92
#define VReserved53             0x0000FF94
#define Vmctimovf               0x0000FF96
#define VReserved51             0x0000FF98
#define VReserved50             0x0000FF9A
#define VReserved49             0x0000FF9C
#define VReserved48             0x0000FF9E
#define VReserved47             0x0000FFA0
#define VReserved46             0x0000FFA2
#define VReserved45             0x0000FFA4
#define VReserved44             0x0000FFA6
#define Vcan1tx                 0x0000FFA8
#define Vcan1rx                 0x0000FFAA
#define Vcan1err                0x0000FFAC
#define Vcan1wkup               0x0000FFAE
#define Vcan0tx                 0x0000FFB0
#define Vcan0rx                 0x0000FFB2
#define Vcan0err                0x0000FFB4
#define Vcan0wkup               0x0000FFB6
#define Vflash                  0x0000FFB8
#define Veeprom                 0x0000FFBA
#define VReserved33             0x0000FFBC
#define VReserved32             0x0000FFBE
#define Viic                    0x0000FFC0
#define VReserved30             0x0000FFC2
#define Vcrgscm                 0x0000FFC4
#define Vcrgplllck              0x0000FFC6
#define VReserved27             0x0000FFC8
#define VReserved26             0x0000FFCA
#define Vporth                  0x0000FFCC
#define Vportj                  0x0000FFCE
#define VReserved23             0x0000FFD0
#define Vatd0                   0x0000FFD2
#define Vsci1                   0x0000FFD4
#define Vsci0                   0x0000FFD6
#define Vspi0                   0x0000FFD8
#define Vtimpaie                0x0000FFDA
#define Vtimpaaovf              0x0000FFDC
#define Vtimovf                 0x0000FFDE
#define Vtimch7                 0x0000FFE0
#define Vtimch6                 0x0000FFE2
#define Vtimch5                 0x0000FFE4
#define Vtimch4                 0x0000FFE6
#define Vtimch3                 0x0000FFE8
#define Vtimch2                 0x0000FFEA
#define Vtimch1                 0x0000FFEC
#define Vtimch0                 0x0000FFEE
#define Vrti                    0x0000FFF0
#define Virq                    0x0000FFF2
#define Vxirq                   0x0000FFF4
#define Vswi                    0x0000FFF6
#define Vtrap                   0x0000FFF8
#define Vcop                    0x0000FFFA
#define Vclkmon                 0x0000FFFC
#define Vreset                  0x0000FFFE

/**************** registers I/O map ****************/

/*** PORTAB - Port AB Register; 0x00000000 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** PORTA - Port A Register; 0x00000000 ***/
    union {
      byte Byte;
      struct {
        byte BIT0        :1;                                       /* Port A Bit 0 */
        byte BIT1        :1;                                       /* Port A Bit 1 */
        byte BIT2        :1;                                       /* Port A Bit 2 */
        byte BIT3        :1;                                       /* Port A Bit 3 */
        byte BIT4        :1;                                       /* Port A Bit 4 */
        byte BIT5        :1;                                       /* Port A Bit 5 */
        byte BIT6        :1;                                       /* Port A Bit 6 */
        byte BIT7        :1;                                       /* Port A Bit 7 */
      } Bits;
    } PORTASTR;
    #define PORTA                       _PORTAB.Overlap_STR.PORTASTR.Byte
    #define PORTA_BIT0                  _PORTAB.Overlap_STR.PORTASTR.Bits.BIT0
    #define PORTA_BIT1                  _PORTAB.Overlap_STR.PORTASTR.Bits.BIT1
    #define PORTA_BIT2                  _PORTAB.Overlap_STR.PORTASTR.Bits.BIT2
    #define PORTA_BIT3                  _PORTAB.Overlap_STR.PORTASTR.Bits.BIT3
    #define PORTA_BIT4                  _PORTAB.Overlap_STR.PORTASTR.Bits.BIT4
    #define PORTA_BIT5                  _PORTAB.Overlap_STR.PORTASTR.Bits.BIT5
    #define PORTA_BIT6                  _PORTAB.Overlap_STR.PORTASTR.Bits.BIT6
    #define PORTA_BIT7                  _PORTAB.Overlap_STR.PORTASTR.Bits.BIT7
    
    
    #define PORTA_BIT0_MASK             1
    #define PORTA_BIT1_MASK             2
    #define PORTA_BIT2_MASK             4
    #define PORTA_BIT3_MASK             8
    #define PORTA_BIT4_MASK             16
    #define PORTA_BIT5_MASK             32
    #define PORTA_BIT6_MASK             64
    #define PORTA_BIT7_MASK             128


    /*** PORTB - Port B Register; 0x00000001 ***/
    union {
      byte Byte;
      struct {
        byte BIT0        :1;                                       /* Port B Bit 0 */
        byte BIT1        :1;                                       /* Port B Bit 1 */
        byte BIT2        :1;                                       /* Port B Bit 2 */
        byte BIT3        :1;                                       /* Port B Bit 3 */
        byte BIT4        :1;                                       /* Port B Bit 4 */
        byte BIT5        :1;                                       /* Port B Bit 5 */
        byte BIT6        :1;                                       /* Port B Bit 6 */
        byte BIT7        :1;                                       /* Port B Bit 7 */
      } Bits;
    } PORTBSTR;
    #define PORTB                       _PORTAB.Overlap_STR.PORTBSTR.Byte
    #define PORTB_BIT0                  _PORTAB.Overlap_STR.PORTBSTR.Bits.BIT0
    #define PORTB_BIT1                  _PORTAB.Overlap_STR.PORTBSTR.Bits.BIT1
    #define PORTB_BIT2                  _PORTAB.Overlap_STR.PORTBSTR.Bits.BIT2
    #define PORTB_BIT3                  _PORTAB.Overlap_STR.PORTBSTR.Bits.BIT3
    #define PORTB_BIT4                  _PORTAB.Overlap_STR.PORTBSTR.Bits.BIT4
    #define PORTB_BIT5                  _PORTAB.Overlap_STR.PORTBSTR.Bits.BIT5
    #define PORTB_BIT6                  _PORTAB.Overlap_STR.PORTBSTR.Bits.BIT6
    #define PORTB_BIT7                  _PORTAB.Overlap_STR.PORTBSTR.Bits.BIT7
    
    
    #define PORTB_BIT0_MASK             1
    #define PORTB_BIT1_MASK             2
    #define PORTB_BIT2_MASK             4
    #define PORTB_BIT3_MASK             8
    #define PORTB_BIT4_MASK             16
    #define PORTB_BIT5_MASK             32
    #define PORTB_BIT6_MASK             64
    #define PORTB_BIT7_MASK             128

  } Overlap_STR;

  struct {
    word BIT0        :1;                                       /* Port AB Bit 0 */
    word BIT1        :1;                                       /* Port AB Bit 1 */
    word BIT2        :1;                                       /* Port AB Bit 2 */
    word BIT3        :1;                                       /* Port AB Bit 3 */
    word BIT4        :1;                                       /* Port AB Bit 4 */
    word BIT5        :1;                                       /* Port AB Bit 5 */
    word BIT6        :1;                                       /* Port AB Bit 6 */
    word BIT7        :1;                                       /* Port AB Bit 7 */
    word BIT8        :1;                                       /* Port AB Bit 8 */
    word BIT9        :1;                                       /* Port AB Bit 9 */
    word BIT10       :1;                                       /* Port AB Bit 10 */
    word BIT11       :1;                                       /* Port AB Bit 11 */
    word BIT12       :1;                                       /* Port AB Bit 12 */
    word BIT13       :1;                                       /* Port AB Bit 13 */
    word BIT14       :1;                                       /* Port AB Bit 14 */
    word BIT15       :1;                                       /* Port AB Bit 15 */
  } Bits;
} PORTABSTR;
extern volatile PORTABSTR _PORTAB @(REG_BASE + 0x00000000);
#define PORTAB                          _PORTAB.Word
#define PORTAB_BIT0                     _PORTAB.Bits.BIT0
#define PORTAB_BIT1                     _PORTAB.Bits.BIT1
#define PORTAB_BIT2                     _PORTAB.Bits.BIT2
#define PORTAB_BIT3                     _PORTAB.Bits.BIT3
#define PORTAB_BIT4                     _PORTAB.Bits.BIT4
#define PORTAB_BIT5                     _PORTAB.Bits.BIT5
#define PORTAB_BIT6                     _PORTAB.Bits.BIT6
#define PORTAB_BIT7                     _PORTAB.Bits.BIT7
#define PORTAB_BIT8                     _PORTAB.Bits.BIT8
#define PORTAB_BIT9                     _PORTAB.Bits.BIT9
#define PORTAB_BIT10                    _PORTAB.Bits.BIT10
#define PORTAB_BIT11                    _PORTAB.Bits.BIT11
#define PORTAB_BIT12                    _PORTAB.Bits.BIT12
#define PORTAB_BIT13                    _PORTAB.Bits.BIT13
#define PORTAB_BIT14                    _PORTAB.Bits.BIT14
#define PORTAB_BIT15                    _PORTAB.Bits.BIT15

#define PORTAB_BIT0_MASK                1
#define PORTAB_BIT1_MASK                2
#define PORTAB_BIT2_MASK                4
#define PORTAB_BIT3_MASK                8
#define PORTAB_BIT4_MASK                16
#define PORTAB_BIT5_MASK                32
#define PORTAB_BIT6_MASK                64
#define PORTAB_BIT7_MASK                128
#define PORTAB_BIT8_MASK                256
#define PORTAB_BIT9_MASK                512
#define PORTAB_BIT10_MASK               1024
#define PORTAB_BIT11_MASK               2048
#define PORTAB_BIT12_MASK               4096
#define PORTAB_BIT13_MASK               8192
#define PORTAB_BIT14_MASK               16384
#define PORTAB_BIT15_MASK               32768


/*** DDRAB - Port AB Data Direction Register; 0x00000002 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** DDRA - Port A Data Direction Register; 0x00000002 ***/
    union {
      byte Byte;
      struct {
        byte BIT0        :1;                                       /* Data Direction Port A Bit 0 */
        byte BIT1        :1;                                       /* Data Direction Port A Bit 1 */
        byte BIT2        :1;                                       /* Data Direction Port A Bit 2 */
        byte BIT3        :1;                                       /* Data Direction Port A Bit 3 */
        byte BIT4        :1;                                       /* Data Direction Port A Bit 4 */
        byte BIT5        :1;                                       /* Data Direction Port A Bit 5 */
        byte BIT6        :1;                                       /* Data Direction Port A Bit 6 */
        byte BIT7        :1;                                       /* Data Direction Port A Bit 7 */
      } Bits;
    } DDRASTR;
    #define DDRA                        _DDRAB.Overlap_STR.DDRASTR.Byte
    #define DDRA_BIT0                   _DDRAB.Overlap_STR.DDRASTR.Bits.BIT0
    #define DDRA_BIT1                   _DDRAB.Overlap_STR.DDRASTR.Bits.BIT1
    #define DDRA_BIT2                   _DDRAB.Overlap_STR.DDRASTR.Bits.BIT2
    #define DDRA_BIT3                   _DDRAB.Overlap_STR.DDRASTR.Bits.BIT3
    #define DDRA_BIT4                   _DDRAB.Overlap_STR.DDRASTR.Bits.BIT4
    #define DDRA_BIT5                   _DDRAB.Overlap_STR.DDRASTR.Bits.BIT5
    #define DDRA_BIT6                   _DDRAB.Overlap_STR.DDRASTR.Bits.BIT6
    #define DDRA_BIT7                   _DDRAB.Overlap_STR.DDRASTR.Bits.BIT7
    
    
    #define DDRA_BIT0_MASK              1
    #define DDRA_BIT1_MASK              2
    #define DDRA_BIT2_MASK              4
    #define DDRA_BIT3_MASK              8
    #define DDRA_BIT4_MASK              16
    #define DDRA_BIT5_MASK              32
    #define DDRA_BIT6_MASK              64
    #define DDRA_BIT7_MASK              128


    /*** DDRB - Port B Data Direction Register; 0x00000003 ***/
    union {
      byte Byte;
      struct {
        byte BIT0        :1;                                       /* Data Direction Port B Bit 0 */
        byte BIT1        :1;                                       /* Data Direction Port B Bit 1 */
        byte BIT2        :1;                                       /* Data Direction Port B Bit 2 */
        byte BIT3        :1;                                       /* Data Direction Port B Bit 3 */
        byte BIT4        :1;                                       /* Data Direction Port B Bit 4 */
        byte BIT5        :1;                                       /* Data Direction Port B Bit 5 */
        byte BIT6        :1;                                       /* Data Direction Port B Bit 6 */
        byte BIT7        :1;                                       /* Data Direction Port B Bit 7 */
      } Bits;
    } DDRBSTR;
    #define DDRB                        _DDRAB.Overlap_STR.DDRBSTR.Byte
    #define DDRB_BIT0                   _DDRAB.Overlap_STR.DDRBSTR.Bits.BIT0
    #define DDRB_BIT1                   _DDRAB.Overlap_STR.DDRBSTR.Bits.BIT1
    #define DDRB_BIT2                   _DDRAB.Overlap_STR.DDRBSTR.Bits.BIT2
    #define DDRB_BIT3                   _DDRAB.Overlap_STR.DDRBSTR.Bits.BIT3
    #define DDRB_BIT4                   _DDRAB.Overlap_STR.DDRBSTR.Bits.BIT4
    #define DDRB_BIT5                   _DDRAB.Overlap_STR.DDRBSTR.Bits.BIT5
    #define DDRB_BIT6                   _DDRAB.Overlap_STR.DDRBSTR.Bits.BIT6
    #define DDRB_BIT7                   _DDRAB.Overlap_STR.DDRBSTR.Bits.BIT7
    
    
    #define DDRB_BIT0_MASK              1
    #define DDRB_BIT1_MASK              2
    #define DDRB_BIT2_MASK              4
    #define DDRB_BIT3_MASK              8
    #define DDRB_BIT4_MASK              16
    #define DDRB_BIT5_MASK              32
    #define DDRB_BIT6_MASK              64
    #define DDRB_BIT7_MASK              128

  } Overlap_STR;

  struct {
    word BIT0        :1;                                       /* Data Direction Port AB Bit 0 */
    word BIT1        :1;                                       /* Data Direction Port AB Bit 1 */
    word BIT2        :1;                                       /* Data Direction Port AB Bit 2 */
    word BIT3        :1;                                       /* Data Direction Port AB Bit 3 */
    word BIT4        :1;                                       /* Data Direction Port AB Bit 4 */
    word BIT5        :1;                                       /* Data Direction Port AB Bit 5 */
    word BIT6        :1;                                       /* Data Direction Port AB Bit 6 */
    word BIT7        :1;                                       /* Data Direction Port AB Bit 7 */
    word BIT8        :1;                                       /* Data Direction Port AB Bit 8 */
    word BIT9        :1;                                       /* Data Direction Port AB Bit 9 */
    word BIT10       :1;                                       /* Data Direction Port AB Bit 10 */
    word BIT11       :1;                                       /* Data Direction Port AB Bit 11 */
    word BIT12       :1;                                       /* Data Direction Port AB Bit 12 */
    word BIT13       :1;                                       /* Data Direction Port AB Bit 13 */
    word BIT14       :1;                                       /* Data Direction Port AB Bit 14 */
    word BIT15       :1;                                       /* Data Direction Port AB Bit 15 */
  } Bits;
} DDRABSTR;
extern volatile DDRABSTR _DDRAB @(REG_BASE + 0x00000002);
#define DDRAB                           _DDRAB.Word
#define DDRAB_BIT0                      _DDRAB.Bits.BIT0
#define DDRAB_BIT1                      _DDRAB.Bits.BIT1
#define DDRAB_BIT2                      _DDRAB.Bits.BIT2
#define DDRAB_BIT3                      _DDRAB.Bits.BIT3
#define DDRAB_BIT4                      _DDRAB.Bits.BIT4
#define DDRAB_BIT5                      _DDRAB.Bits.BIT5
#define DDRAB_BIT6                      _DDRAB.Bits.BIT6
#define DDRAB_BIT7                      _DDRAB.Bits.BIT7
#define DDRAB_BIT8                      _DDRAB.Bits.BIT8
#define DDRAB_BIT9                      _DDRAB.Bits.BIT9
#define DDRAB_BIT10                     _DDRAB.Bits.BIT10
#define DDRAB_BIT11                     _DDRAB.Bits.BIT11
#define DDRAB_BIT12                     _DDRAB.Bits.BIT12
#define DDRAB_BIT13                     _DDRAB.Bits.BIT13
#define DDRAB_BIT14                     _DDRAB.Bits.BIT14
#define DDRAB_BIT15                     _DDRAB.Bits.BIT15

#define DDRAB_BIT0_MASK                 1
#define DDRAB_BIT1_MASK                 2
#define DDRAB_BIT2_MASK                 4
#define DDRAB_BIT3_MASK                 8
#define DDRAB_BIT4_MASK                 16
#define DDRAB_BIT5_MASK                 32
#define DDRAB_BIT6_MASK                 64
#define DDRAB_BIT7_MASK                 128
#define DDRAB_BIT8_MASK                 256
#define DDRAB_BIT9_MASK                 512
#define DDRAB_BIT10_MASK                1024
#define DDRAB_BIT11_MASK                2048
#define DDRAB_BIT12_MASK                4096
#define DDRAB_BIT13_MASK                8192
#define DDRAB_BIT14_MASK                16384
#define DDRAB_BIT15_MASK                32768


/*** PORTE - Port E Register; 0x00000008 ***/
typedef union {
  byte Byte;
  struct {
    byte BIT0        :1;                                       /* Port E Bit 0 */
    byte BIT1        :1;                                       /* Port E Bit 1 */
    byte BIT2        :1;                                       /* Port E Bit 2 */
    byte BIT3        :1;                                       /* Port E Bit 3 */
    byte BIT4        :1;                                       /* Port E Bit 4 */
    byte BIT5        :1;                                       /* Port E Bit 5 */
    byte BIT6        :1;                                       /* Port E Bit 6 */
    byte BIT7        :1;                                       /* Port E Bit 7 */
  } Bits;
} PORTESTR;
extern volatile PORTESTR _PORTE @(REG_BASE + 0x00000008);
#define PORTE                           _PORTE.Byte
#define PORTE_BIT0                      _PORTE.Bits.BIT0
#define PORTE_BIT1                      _PORTE.Bits.BIT1
#define PORTE_BIT2                      _PORTE.Bits.BIT2
#define PORTE_BIT3                      _PORTE.Bits.BIT3
#define PORTE_BIT4                      _PORTE.Bits.BIT4
#define PORTE_BIT5                      _PORTE.Bits.BIT5
#define PORTE_BIT6                      _PORTE.Bits.BIT6
#define PORTE_BIT7                      _PORTE.Bits.BIT7

#define PORTE_BIT0_MASK                 1
#define PORTE_BIT1_MASK                 2
#define PORTE_BIT2_MASK                 4
#define PORTE_BIT3_MASK                 8
#define PORTE_BIT4_MASK                 16
#define PORTE_BIT5_MASK                 32
#define PORTE_BIT6_MASK                 64
#define PORTE_BIT7_MASK                 128


/*** DDRE - Port E Data Direction Register; 0x00000009 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte BIT2        :1;                                       /* Data Direction Port E Bit 2 */
    byte BIT3        :1;                                       /* Data Direction Port E Bit 3 */
    byte BIT4        :1;                                       /* Data Direction Port E Bit 4 */
    byte BIT5        :1;                                       /* Data Direction Port E Bit 5 */
    byte BIT6        :1;                                       /* Data Direction Port E Bit 6 */
    byte BIT7        :1;                                       /* Data Direction Port E Bit 7 */
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte grpBIT_2 :6;
  } MergedBits;
} DDRESTR;
extern volatile DDRESTR _DDRE @(REG_BASE + 0x00000009);
#define DDRE                            _DDRE.Byte
#define DDRE_BIT2                       _DDRE.Bits.BIT2
#define DDRE_BIT3                       _DDRE.Bits.BIT3
#define DDRE_BIT4                       _DDRE.Bits.BIT4
#define DDRE_BIT5                       _DDRE.Bits.BIT5
#define DDRE_BIT6                       _DDRE.Bits.BIT6
#define DDRE_BIT7                       _DDRE.Bits.BIT7
#define DDRE_BIT_2                      _DDRE.MergedBits.grpBIT_2
#define DDRE_BIT                        DDRE_BIT_2

#define DDRE_BIT2_MASK                  4
#define DDRE_BIT3_MASK                  8
#define DDRE_BIT4_MASK                  16
#define DDRE_BIT5_MASK                  32
#define DDRE_BIT6_MASK                  64
#define DDRE_BIT7_MASK                  128
#define DDRE_BIT_2_MASK                 %BitsMask
#define DDRE_BIT_2_BITNUM               %BitsNum


/*** PEAR - Port E Assignment Register; 0x0000000A ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte RDWE        :1;                                       /* Read / Write Enable */
    byte LSTRE       :1;                                       /* Low Strobe (LSTRB) Enable */
    byte NECLK       :1;                                       /* No External E Clock */
    byte PIPOE       :1;                                       /* Pipe Status Signal Output Enable */
    byte             :1; 
    byte NOACCE      :1;                                       /* CPU No Access Output Enable */
  } Bits;
} PEARSTR;
extern volatile PEARSTR _PEAR @(REG_BASE + 0x0000000A);
#define PEAR                            _PEAR.Byte
#define PEAR_RDWE                       _PEAR.Bits.RDWE
#define PEAR_LSTRE                      _PEAR.Bits.LSTRE
#define PEAR_NECLK                      _PEAR.Bits.NECLK
#define PEAR_PIPOE                      _PEAR.Bits.PIPOE
#define PEAR_NOACCE                     _PEAR.Bits.NOACCE

#define PEAR_RDWE_MASK                  4
#define PEAR_LSTRE_MASK                 8
#define PEAR_NECLK_MASK                 16
#define PEAR_PIPOE_MASK                 32
#define PEAR_NOACCE_MASK                128


/*** MODE - Mode Register; 0x0000000B ***/
typedef union {
  byte Byte;
  struct {
    byte EME         :1;                                       /* Emulate Port E */
    byte EMK         :1;                                       /* Emulate Port K */
    byte             :1; 
    byte IVIS        :1;                                       /* Internal Visibility */
    byte             :1; 
    byte MODA        :1;                                       /* Mode Select Bit A */
    byte MODB        :1;                                       /* Mode Select Bit B */
    byte MODC        :1;                                       /* Mode Select Bit C */
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte grpMODx :3;
  } MergedBits;
} MODESTR;
extern volatile MODESTR _MODE @(REG_BASE + 0x0000000B);
#define MODE                            _MODE.Byte
#define MODE_EME                        _MODE.Bits.EME
#define MODE_EMK                        _MODE.Bits.EMK
#define MODE_IVIS                       _MODE.Bits.IVIS
#define MODE_MODA                       _MODE.Bits.MODA
#define MODE_MODB                       _MODE.Bits.MODB
#define MODE_MODC                       _MODE.Bits.MODC
#define MODE_MODx                       _MODE.MergedBits.grpMODx

#define MODE_EME_MASK                   1
#define MODE_EMK_MASK                   2
#define MODE_IVIS_MASK                  8
#define MODE_MODA_MASK                  32
#define MODE_MODB_MASK                  64
#define MODE_MODC_MASK                  128
#define MODE_MODx_MASK                  %BitsMask
#define MODE_MODx_BITNUM                %BitsNum


/*** PUCR - Pull-Up Control Register; 0x0000000C ***/
typedef union {
  byte Byte;
  struct {
    byte PUPAE       :1;                                       /* Pull-Up Port A Enable */
    byte PUPBE       :1;                                       /* Pull-Up Port B Enable */
    byte             :1; 
    byte             :1; 
    byte PUPEE       :1;                                       /* Pull-Up Port E Enable */
    byte             :1; 
    byte             :1; 
    byte PUPKE       :1;                                       /* Pull-Up Port K Enable */
  } Bits;
} PUCRSTR;
extern volatile PUCRSTR _PUCR @(REG_BASE + 0x0000000C);
#define PUCR                            _PUCR.Byte
#define PUCR_PUPAE                      _PUCR.Bits.PUPAE
#define PUCR_PUPBE                      _PUCR.Bits.PUPBE
#define PUCR_PUPEE                      _PUCR.Bits.PUPEE
#define PUCR_PUPKE                      _PUCR.Bits.PUPKE

#define PUCR_PUPAE_MASK                 1
#define PUCR_PUPBE_MASK                 2
#define PUCR_PUPEE_MASK                 16
#define PUCR_PUPKE_MASK                 128


/*** RDRIV - Reduced Drive of I/O Lines; 0x0000000D ***/
typedef union {
  byte Byte;
  struct {
    byte RDPA        :1;                                       /* Reduced Drive of Port A */
    byte RDPB        :1;                                       /* Reduced Drive of Port B */
    byte             :1; 
    byte             :1; 
    byte RDPE        :1;                                       /* Reduced Drive of Port E */
    byte             :1; 
    byte             :1; 
    byte RDPK        :1;                                       /* Reduced Drive of Port K */
  } Bits;
  struct {
    byte grpRDPx :2;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} RDRIVSTR;
extern volatile RDRIVSTR _RDRIV @(REG_BASE + 0x0000000D);
#define RDRIV                           _RDRIV.Byte
#define RDRIV_RDPA                      _RDRIV.Bits.RDPA
#define RDRIV_RDPB                      _RDRIV.Bits.RDPB
#define RDRIV_RDPE                      _RDRIV.Bits.RDPE
#define RDRIV_RDPK                      _RDRIV.Bits.RDPK
#define RDRIV_RDPx                      _RDRIV.MergedBits.grpRDPx

#define RDRIV_RDPA_MASK                 1
#define RDRIV_RDPB_MASK                 2
#define RDRIV_RDPE_MASK                 16
#define RDRIV_RDPK_MASK                 128
#define RDRIV_RDPx_MASK                 %BitsMask
#define RDRIV_RDPx_BITNUM               %BitsNum


/*** EBICTL - External Bus Interface Control; 0x0000000E ***/
typedef union {
  byte Byte;
  struct {
    byte ESTR        :1;                                       /* E Stretches */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} EBICTLSTR;
extern volatile EBICTLSTR _EBICTL @(REG_BASE + 0x0000000E);
#define EBICTL                          _EBICTL.Byte
#define EBICTL_ESTR                     _EBICTL.Bits.ESTR

#define EBICTL_ESTR_MASK                1


/*** INITRM - Initialization of Internal RAM Position Register; 0x00000010 ***/
typedef union {
  byte Byte;
  struct {
    byte RAMHAL      :1;                                       /* Internal RAM map alignment */
    byte             :1; 
    byte             :1; 
    byte RAM11       :1;                                       /* Internal RAM map position Bit 11 */
    byte RAM12       :1;                                       /* Internal RAM map position Bit 12 */
    byte RAM13       :1;                                       /* Internal RAM map position Bit 13 */
    byte RAM14       :1;                                       /* Internal RAM map position Bit 14 */
    byte RAM15       :1;                                       /* Internal RAM map position Bit 15 */
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte         :1;
    byte grpRAM_11 :5;
  } MergedBits;
} INITRMSTR;
extern volatile INITRMSTR _INITRM @(REG_BASE + 0x00000010);
#define INITRM                          _INITRM.Byte
#define INITRM_RAMHAL                   _INITRM.Bits.RAMHAL
#define INITRM_RAM11                    _INITRM.Bits.RAM11
#define INITRM_RAM12                    _INITRM.Bits.RAM12
#define INITRM_RAM13                    _INITRM.Bits.RAM13
#define INITRM_RAM14                    _INITRM.Bits.RAM14
#define INITRM_RAM15                    _INITRM.Bits.RAM15
#define INITRM_RAM_11                   _INITRM.MergedBits.grpRAM_11
#define INITRM_RAM                      INITRM_RAM_11

#define INITRM_RAMHAL_MASK              1
#define INITRM_RAM11_MASK               8
#define INITRM_RAM12_MASK               16
#define INITRM_RAM13_MASK               32
#define INITRM_RAM14_MASK               64
#define INITRM_RAM15_MASK               128
#define INITRM_RAM_11_MASK              %BitsMask
#define INITRM_RAM_11_BITNUM            %BitsNum


/*** INITRG - Initialization of Internal Registers Position Register; 0x00000011 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte REG11       :1;                                       /* Internal Registers Map Position Bit 11 */
    byte REG12       :1;                                       /* Internal Registers Map Position Bit 12 */
    byte REG13       :1;                                       /* Internal Registers Map Position Bit 13 */
    byte REG14       :1;                                       /* Internal Registers Map Position Bit 14 */
    byte             :1; 
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte         :1;
    byte grpREG_11 :4;
    byte         :1;
  } MergedBits;
} INITRGSTR;
extern volatile INITRGSTR _INITRG @(REG_BASE + 0x00000011);
#define INITRG                          _INITRG.Byte
#define INITRG_REG11                    _INITRG.Bits.REG11
#define INITRG_REG12                    _INITRG.Bits.REG12
#define INITRG_REG13                    _INITRG.Bits.REG13
#define INITRG_REG14                    _INITRG.Bits.REG14
#define INITRG_REG_11                   _INITRG.MergedBits.grpREG_11
#define INITRG_REG                      INITRG_REG_11

#define INITRG_REG11_MASK               8
#define INITRG_REG12_MASK               16
#define INITRG_REG13_MASK               32
#define INITRG_REG14_MASK               64
#define INITRG_REG_11_MASK              %BitsMask
#define INITRG_REG_11_BITNUM            %BitsNum


/*** INITEE - Initialization of Internal EEPROM Position Register; 0x00000012 ***/
typedef union {
  byte Byte;
  struct {
    byte EEON        :1;                                       /* Internal EEPROM On */
    byte             :1; 
    byte             :1; 
    byte EE11        :1;                                       /* Internal EEPROM map position Bit 11 */
    byte EE12        :1;                                       /* Internal EEPROM map position Bit 12 */
    byte EE13        :1;                                       /* Internal EEPROM map position Bit 13 */
    byte EE14        :1;                                       /* Internal EEPROM map position Bit 14 */
    byte EE15        :1;                                       /* Internal EEPROM map position Bit 15 */
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte         :1;
    byte grpEE_11 :5;
  } MergedBits;
} INITEESTR;
extern volatile INITEESTR _INITEE @(REG_BASE + 0x00000012);
#define INITEE                          _INITEE.Byte
#define INITEE_EEON                     _INITEE.Bits.EEON
#define INITEE_EE11                     _INITEE.Bits.EE11
#define INITEE_EE12                     _INITEE.Bits.EE12
#define INITEE_EE13                     _INITEE.Bits.EE13
#define INITEE_EE14                     _INITEE.Bits.EE14
#define INITEE_EE15                     _INITEE.Bits.EE15
#define INITEE_EE_11                    _INITEE.MergedBits.grpEE_11
#define INITEE_EE                       INITEE_EE_11

#define INITEE_EEON_MASK                1
#define INITEE_EE11_MASK                8
#define INITEE_EE12_MASK                16
#define INITEE_EE13_MASK                32
#define INITEE_EE14_MASK                64
#define INITEE_EE15_MASK                128
#define INITEE_EE_11_MASK               %BitsMask
#define INITEE_EE_11_BITNUM             %BitsNum


/*** MISC - Miscellaneous System Control Register; 0x00000013 ***/
typedef union {
  byte Byte;
  struct {
    byte ROMON       :1;                                       /* Enable Flash EEPROM */
    byte ROMHM       :1;                                       /* Flash EEPROM only in second half of memory map */
    byte EXSTR0      :1;                                       /* External Access Stretch Bit 0 */
    byte EXSTR1      :1;                                       /* External Access Stretch Bit 1 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte grpEXSTR :2;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} MISCSTR;
extern volatile MISCSTR _MISC @(REG_BASE + 0x00000013);
#define MISC                            _MISC.Byte
#define MISC_ROMON                      _MISC.Bits.ROMON
#define MISC_ROMHM                      _MISC.Bits.ROMHM
#define MISC_EXSTR0                     _MISC.Bits.EXSTR0
#define MISC_EXSTR1                     _MISC.Bits.EXSTR1
#define MISC_EXSTR                      _MISC.MergedBits.grpEXSTR

#define MISC_ROMON_MASK                 1
#define MISC_ROMHM_MASK                 2
#define MISC_EXSTR0_MASK                4
#define MISC_EXSTR1_MASK                8
#define MISC_EXSTR_MASK                 %BitsMask
#define MISC_EXSTR_BITNUM               %BitsNum


/*** MTST0 - MTST0; 0x00000014 ***/
typedef union {
  byte Byte;
  struct {
    byte BIT0        :1;                                       /* MTST0 Bit 0 */
    byte BIT1        :1;                                       /* MTST0 Bit 1 */
    byte BIT2        :1;                                       /* MTST0 Bit 2 */
    byte BIT3        :1;                                       /* MTST0 Bit 3 */
    byte BIT4        :1;                                       /* MTST0 Bit 4 */
    byte BIT5        :1;                                       /* MTST0 Bit 5 */
    byte BIT6        :1;                                       /* MTST0 Bit 6 */
    byte BIT7        :1;                                       /* MTST0 Bit 7 */
  } Bits;
} MTST0STR;
extern volatile MTST0STR _MTST0 @(REG_BASE + 0x00000014);
#define MTST0                           _MTST0.Byte
#define MTST0_BIT0                      _MTST0.Bits.BIT0
#define MTST0_BIT1                      _MTST0.Bits.BIT1
#define MTST0_BIT2                      _MTST0.Bits.BIT2
#define MTST0_BIT3                      _MTST0.Bits.BIT3
#define MTST0_BIT4                      _MTST0.Bits.BIT4
#define MTST0_BIT5                      _MTST0.Bits.BIT5
#define MTST0_BIT6                      _MTST0.Bits.BIT6
#define MTST0_BIT7                      _MTST0.Bits.BIT7

#define MTST0_BIT0_MASK                 1
#define MTST0_BIT1_MASK                 2
#define MTST0_BIT2_MASK                 4
#define MTST0_BIT3_MASK                 8
#define MTST0_BIT4_MASK                 16
#define MTST0_BIT5_MASK                 32
#define MTST0_BIT6_MASK                 64
#define MTST0_BIT7_MASK                 128


/*** ITCR - Interrupt Test Control Register; 0x00000015 ***/
typedef union {
  byte Byte;
  struct {
    byte ADR0        :1;                                       /* Test register select Bit 0 */
    byte ADR1        :1;                                       /* Test register select Bit 1 */
    byte ADR2        :1;                                       /* Test register select Bit 2 */
    byte ADR3        :1;                                       /* Test register select Bit 3 */
    byte WRTINT      :1;                                       /* Write to the Interrupt Test Registers */
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpADR  :4;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} ITCRSTR;
extern volatile ITCRSTR _ITCR @(REG_BASE + 0x00000015);
#define ITCR                            _ITCR.Byte
#define ITCR_ADR0                       _ITCR.Bits.ADR0
#define ITCR_ADR1                       _ITCR.Bits.ADR1
#define ITCR_ADR2                       _ITCR.Bits.ADR2
#define ITCR_ADR3                       _ITCR.Bits.ADR3
#define ITCR_WRTINT                     _ITCR.Bits.WRTINT
#define ITCR_ADR                        _ITCR.MergedBits.grpADR

#define ITCR_ADR0_MASK                  1
#define ITCR_ADR1_MASK                  2
#define ITCR_ADR2_MASK                  4
#define ITCR_ADR3_MASK                  8
#define ITCR_WRTINT_MASK                16
#define ITCR_ADR_MASK                   %BitsMask
#define ITCR_ADR_BITNUM                 %BitsNum


/*** ITEST - Interrupt Test Register; 0x00000016 ***/
typedef union {
  byte Byte;
  struct {
    byte INT0        :1;                                       /* Interrupt Test Register Bit 0 */
    byte INT2        :1;                                       /* Interrupt Test Register Bit 1 */
    byte INT4        :1;                                       /* Interrupt Test Register Bit 2 */
    byte INT6        :1;                                       /* Interrupt Test Register Bit 3 */
    byte INT8        :1;                                       /* Interrupt Test Register Bit 4 */
    byte INTA        :1;                                       /* Interrupt Test Register Bit 5 */
    byte INTC        :1;                                       /* Interrupt Test Register Bit 6 */
    byte INTE        :1;                                       /* Interrupt Test Register Bit 7 */
  } Bits;
} ITESTSTR;
extern volatile ITESTSTR _ITEST @(REG_BASE + 0x00000016);
#define ITEST                           _ITEST.Byte
#define ITEST_INT0                      _ITEST.Bits.INT0
#define ITEST_INT2                      _ITEST.Bits.INT2
#define ITEST_INT4                      _ITEST.Bits.INT4
#define ITEST_INT6                      _ITEST.Bits.INT6
#define ITEST_INT8                      _ITEST.Bits.INT8
#define ITEST_INTA                      _ITEST.Bits.INTA
#define ITEST_INTC                      _ITEST.Bits.INTC
#define ITEST_INTE                      _ITEST.Bits.INTE

#define ITEST_INT0_MASK                 1
#define ITEST_INT2_MASK                 2
#define ITEST_INT4_MASK                 4
#define ITEST_INT6_MASK                 8
#define ITEST_INT8_MASK                 16
#define ITEST_INTA_MASK                 32
#define ITEST_INTC_MASK                 64
#define ITEST_INTE_MASK                 128


/*** MTST1 - MTST1; 0x00000017 ***/
typedef union {
  byte Byte;
  struct {
    byte BIT0        :1;                                       /* MTST1 Bit 0 */
    byte BIT1        :1;                                       /* MTST1 Bit 1 */
    byte BIT2        :1;                                       /* MTST1 Bit 2 */
    byte BIT3        :1;                                       /* MTST1 Bit 3 */
    byte BIT4        :1;                                       /* MTST1 Bit 4 */
    byte BIT5        :1;                                       /* MTST1 Bit 5 */
    byte BIT6        :1;                                       /* MTST1 Bit 6 */
    byte BIT7        :1;                                       /* MTST1 Bit 7 */
  } Bits;
} MTST1STR;
extern volatile MTST1STR _MTST1 @(REG_BASE + 0x00000017);
#define MTST1                           _MTST1.Byte
#define MTST1_BIT0                      _MTST1.Bits.BIT0
#define MTST1_BIT1                      _MTST1.Bits.BIT1
#define MTST1_BIT2                      _MTST1.Bits.BIT2
#define MTST1_BIT3                      _MTST1.Bits.BIT3
#define MTST1_BIT4                      _MTST1.Bits.BIT4
#define MTST1_BIT5                      _MTST1.Bits.BIT5
#define MTST1_BIT6                      _MTST1.Bits.BIT6
#define MTST1_BIT7                      _MTST1.Bits.BIT7

#define MTST1_BIT0_MASK                 1
#define MTST1_BIT1_MASK                 2
#define MTST1_BIT2_MASK                 4
#define MTST1_BIT3_MASK                 8
#define MTST1_BIT4_MASK                 16
#define MTST1_BIT5_MASK                 32
#define MTST1_BIT6_MASK                 64
#define MTST1_BIT7_MASK                 128


/*** VREGCTRL - VREG_3V3 - Control Register; 0x00000019 ***/
typedef union {
  byte Byte;
  struct {
    byte LVIF        :1;                                       /* Low Voltage Interrupt Flag */
    byte LVIE        :1;                                       /* Low Voltage Interrupt Enable Bit */
    byte LVDS        :1;                                       /* Low Voltage Detect Status Bit */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} VREGCTRLSTR;
extern volatile VREGCTRLSTR _VREGCTRL @(REG_BASE + 0x00000019);
#define VREGCTRL                        _VREGCTRL.Byte
#define VREGCTRL_LVIF                   _VREGCTRL.Bits.LVIF
#define VREGCTRL_LVIE                   _VREGCTRL.Bits.LVIE
#define VREGCTRL_LVDS                   _VREGCTRL.Bits.LVDS

#define VREGCTRL_LVIF_MASK              1
#define VREGCTRL_LVIE_MASK              2
#define VREGCTRL_LVDS_MASK              4


/*** PARTIDH - Part ID Register High; 0x0000001A ***/
typedef union {
  byte Byte;
  struct {
    byte ID8         :1;                                       /* Part ID Register Bit 8 */
    byte ID9         :1;                                       /* Part ID Register Bit 9 */
    byte ID10        :1;                                       /* Part ID Register Bit 10 */
    byte ID11        :1;                                       /* Part ID Register Bit 11 */
    byte ID12        :1;                                       /* Part ID Register Bit 12 */
    byte ID13        :1;                                       /* Part ID Register Bit 13 */
    byte ID14        :1;                                       /* Part ID Register Bit 14 */
    byte ID15        :1;                                       /* Part ID Register Bit 15 */
  } Bits;
} PARTIDHSTR;
extern volatile PARTIDHSTR _PARTIDH @(REG_BASE + 0x0000001A);
#define PARTIDH                         _PARTIDH.Byte
#define PARTIDH_ID8                     _PARTIDH.Bits.ID8
#define PARTIDH_ID9                     _PARTIDH.Bits.ID9
#define PARTIDH_ID10                    _PARTIDH.Bits.ID10
#define PARTIDH_ID11                    _PARTIDH.Bits.ID11
#define PARTIDH_ID12                    _PARTIDH.Bits.ID12
#define PARTIDH_ID13                    _PARTIDH.Bits.ID13
#define PARTIDH_ID14                    _PARTIDH.Bits.ID14
#define PARTIDH_ID15                    _PARTIDH.Bits.ID15

#define PARTIDH_ID8_MASK                1
#define PARTIDH_ID9_MASK                2
#define PARTIDH_ID10_MASK               4
#define PARTIDH_ID11_MASK               8
#define PARTIDH_ID12_MASK               16
#define PARTIDH_ID13_MASK               32
#define PARTIDH_ID14_MASK               64
#define PARTIDH_ID15_MASK               128


/*** PARTIDL - Part ID Register Low; 0x0000001B ***/
typedef union {
  byte Byte;
  struct {
    byte ID0         :1;                                       /* Part ID Register Bit 0 */
    byte ID1         :1;                                       /* Part ID Register Bit 1 */
    byte ID2         :1;                                       /* Part ID Register Bit 2 */
    byte ID3         :1;                                       /* Part ID Register Bit 3 */
    byte ID4         :1;                                       /* Part ID Register Bit 4 */
    byte ID5         :1;                                       /* Part ID Register Bit 5 */
    byte ID6         :1;                                       /* Part ID Register Bit 6 */
    byte ID7         :1;                                       /* Part ID Register Bit 7 */
  } Bits;
} PARTIDLSTR;
extern volatile PARTIDLSTR _PARTIDL @(REG_BASE + 0x0000001B);
#define PARTIDL                         _PARTIDL.Byte
#define PARTIDL_ID0                     _PARTIDL.Bits.ID0
#define PARTIDL_ID1                     _PARTIDL.Bits.ID1
#define PARTIDL_ID2                     _PARTIDL.Bits.ID2
#define PARTIDL_ID3                     _PARTIDL.Bits.ID3
#define PARTIDL_ID4                     _PARTIDL.Bits.ID4
#define PARTIDL_ID5                     _PARTIDL.Bits.ID5
#define PARTIDL_ID6                     _PARTIDL.Bits.ID6
#define PARTIDL_ID7                     _PARTIDL.Bits.ID7

#define PARTIDL_ID0_MASK                1
#define PARTIDL_ID1_MASK                2
#define PARTIDL_ID2_MASK                4
#define PARTIDL_ID3_MASK                8
#define PARTIDL_ID4_MASK                16
#define PARTIDL_ID5_MASK                32
#define PARTIDL_ID6_MASK                64
#define PARTIDL_ID7_MASK                128


/*** MEMSIZ0 - Memory Size Register Zero; 0x0000001C ***/
typedef union {
  byte Byte;
  struct {
    byte ram_sw0     :1;                                       /* Allocated System RAM Memory Space Bit 0 */
    byte ram_sw1     :1;                                       /* Allocated System RAM Memory Space Bit 1 */
    byte ram_sw2     :1;                                       /* Allocated System RAM Memory Space Bit 2 */
    byte             :1; 
    byte eep_sw0     :1;                                       /* Allocated EEPROM Memory Space Bit 0 */
    byte eep_sw1     :1;                                       /* Allocated EEPROM Memory Space Bit 1 */
    byte             :1; 
    byte reg_sw0     :1;                                       /* Allocated System Register Space */
  } Bits;
  struct {
    byte grpram_sw :3;
    byte         :1;
    byte grpeep_sw :2;
    byte         :1;
    byte grpreg_sw :1;
  } MergedBits;
} MEMSIZ0STR;
extern volatile MEMSIZ0STR _MEMSIZ0 @(REG_BASE + 0x0000001C);
#define MEMSIZ0                         _MEMSIZ0.Byte
#define MEMSIZ0_ram_sw0                 _MEMSIZ0.Bits.ram_sw0
#define MEMSIZ0_ram_sw1                 _MEMSIZ0.Bits.ram_sw1
#define MEMSIZ0_ram_sw2                 _MEMSIZ0.Bits.ram_sw2
#define MEMSIZ0_eep_sw0                 _MEMSIZ0.Bits.eep_sw0
#define MEMSIZ0_eep_sw1                 _MEMSIZ0.Bits.eep_sw1
#define MEMSIZ0_reg_sw0                 _MEMSIZ0.Bits.reg_sw0
/* MEMSIZ_ARR: Access 2 MEMSIZx registers in a array */
#define MEMSIZ_ARR                      ((Byte *) &MEMSIZ0)
#define MEMSIZ0_ram_sw                  _MEMSIZ0.MergedBits.grpram_sw
#define MEMSIZ0_eep_sw                  _MEMSIZ0.MergedBits.grpeep_sw

#define MEMSIZ0_ram_sw0_MASK            1
#define MEMSIZ0_ram_sw1_MASK            2
#define MEMSIZ0_ram_sw2_MASK            4
#define MEMSIZ0_eep_sw0_MASK            16
#define MEMSIZ0_eep_sw1_MASK            32
#define MEMSIZ0_reg_sw0_MASK            128
#define MEMSIZ0_ram_sw_MASK             %BitsMask
#define MEMSIZ0_ram_sw_BITNUM           %BitsNum
#define MEMSIZ0_eep_sw_MASK             %BitsMask
#define MEMSIZ0_eep_sw_BITNUM           %BitsNum


/*** MEMSIZ1 - Memory Size Register One; 0x0000001D ***/
typedef union {
  byte Byte;
  struct {
    byte pag_sw0     :1;                                       /* Allocated Off-Chip Memory Options Bit 0 */
    byte pag_sw1     :1;                                       /* Allocated Off-Chip Memory Options Bit 1 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte rom_sw0     :1;                                       /* Allocated Flash EEPROM/ROM Physical Memory Space Bit 0 */
    byte rom_sw1     :1;                                       /* Allocated Flash EEPROM/ROM Physical Memory Space Bit 1 */
  } Bits;
  struct {
    byte grppag_sw :2;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte grprom_sw :2;
  } MergedBits;
} MEMSIZ1STR;
extern volatile MEMSIZ1STR _MEMSIZ1 @(REG_BASE + 0x0000001D);
#define MEMSIZ1                         _MEMSIZ1.Byte
#define MEMSIZ1_pag_sw0                 _MEMSIZ1.Bits.pag_sw0
#define MEMSIZ1_pag_sw1                 _MEMSIZ1.Bits.pag_sw1
#define MEMSIZ1_rom_sw0                 _MEMSIZ1.Bits.rom_sw0
#define MEMSIZ1_rom_sw1                 _MEMSIZ1.Bits.rom_sw1
#define MEMSIZ1_pag_sw                  _MEMSIZ1.MergedBits.grppag_sw
#define MEMSIZ1_rom_sw                  _MEMSIZ1.MergedBits.grprom_sw

#define MEMSIZ1_pag_sw0_MASK            1
#define MEMSIZ1_pag_sw1_MASK            2
#define MEMSIZ1_rom_sw0_MASK            64
#define MEMSIZ1_rom_sw1_MASK            128
#define MEMSIZ1_pag_sw_MASK             %BitsMask
#define MEMSIZ1_pag_sw_BITNUM           %BitsNum
#define MEMSIZ1_rom_sw_MASK             %BitsMask
#define MEMSIZ1_rom_sw_BITNUM           %BitsNum


/*** INTCR - Interrupt Control Register; 0x0000001E ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte IRQEN       :1;                                       /* External IRQ Enable */
    byte IRQE        :1;                                       /* IRQ Select Edge Sensitive Only */
  } Bits;
} INTCRSTR;
extern volatile INTCRSTR _INTCR @(REG_BASE + 0x0000001E);
#define INTCR                           _INTCR.Byte
#define INTCR_IRQEN                     _INTCR.Bits.IRQEN
#define INTCR_IRQE                      _INTCR.Bits.IRQE

#define INTCR_IRQEN_MASK                64
#define INTCR_IRQE_MASK                 128


/*** HPRIO - Highest Priority I Interrupt; 0x0000001F ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte PSEL1       :1;                                       /* Highest Priority I Interrupt Bit 1 */
    byte PSEL2       :1;                                       /* Highest Priority I Interrupt Bit 2 */
    byte PSEL3       :1;                                       /* Highest Priority I Interrupt Bit 3 */
    byte PSEL4       :1;                                       /* Highest Priority I Interrupt Bit 4 */
    byte PSEL5       :1;                                       /* Highest Priority I Interrupt Bit 5 */
    byte PSEL6       :1;                                       /* Highest Priority I Interrupt Bit 6 */
    byte PSEL7       :1;                                       /* Highest Priority I Interrupt Bit 7 */
  } Bits;
  struct {
    byte         :1;
    byte grpPSEL_1 :7;
  } MergedBits;
} HPRIOSTR;
extern volatile HPRIOSTR _HPRIO @(REG_BASE + 0x0000001F);
#define HPRIO                           _HPRIO.Byte
#define HPRIO_PSEL1                     _HPRIO.Bits.PSEL1
#define HPRIO_PSEL2                     _HPRIO.Bits.PSEL2
#define HPRIO_PSEL3                     _HPRIO.Bits.PSEL3
#define HPRIO_PSEL4                     _HPRIO.Bits.PSEL4
#define HPRIO_PSEL5                     _HPRIO.Bits.PSEL5
#define HPRIO_PSEL6                     _HPRIO.Bits.PSEL6
#define HPRIO_PSEL7                     _HPRIO.Bits.PSEL7
#define HPRIO_PSEL_1                    _HPRIO.MergedBits.grpPSEL_1
#define HPRIO_PSEL                      HPRIO_PSEL_1

#define HPRIO_PSEL1_MASK                2
#define HPRIO_PSEL2_MASK                4
#define HPRIO_PSEL3_MASK                8
#define HPRIO_PSEL4_MASK                16
#define HPRIO_PSEL5_MASK                32
#define HPRIO_PSEL6_MASK                64
#define HPRIO_PSEL7_MASK                128
#define HPRIO_PSEL_1_MASK               %BitsMask
#define HPRIO_PSEL_1_BITNUM             %BitsNum


/*** BKPCT0 - Breakpoint Control Register 0; 0x00000028 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte BKTAG       :1;                                       /* Breakpoint on Tag */
    byte BKBDM       :1;                                       /* Breakpoint Background Debug Mode Enable */
    byte BKFULL      :1;                                       /* Full Breakpoint Mode Enable */
    byte BKEN        :1;                                       /* Breakpoint Enable */
  } Bits;
} BKPCT0STR;
extern volatile BKPCT0STR _BKPCT0 @(REG_BASE + 0x00000028);
#define BKPCT0                          _BKPCT0.Byte
#define BKPCT0_BKTAG                    _BKPCT0.Bits.BKTAG
#define BKPCT0_BKBDM                    _BKPCT0.Bits.BKBDM
#define BKPCT0_BKFULL                   _BKPCT0.Bits.BKFULL
#define BKPCT0_BKEN                     _BKPCT0.Bits.BKEN
/* BKPCT_ARR: Access 2 BKPCTx registers in a array */
#define BKPCT_ARR                       ((Byte *) &BKPCT0)

#define BKPCT0_BKTAG_MASK               16
#define BKPCT0_BKBDM_MASK               32
#define BKPCT0_BKFULL_MASK              64
#define BKPCT0_BKEN_MASK                128


/*** BKPCT1 - Breakpoint Control Register 1; 0x00000029 ***/
typedef union {
  byte Byte;
  struct {
    byte BK1RW       :1;                                       /* R/W Compare Value 1 */
    byte BK1RWE      :1;                                       /* R/W Compare Enable 1 */
    byte BK0RW       :1;                                       /* R/W Compare Value 0 */
    byte BK0RWE      :1;                                       /* R/W Compare Enable 0 */
    byte BK1MBL      :1;                                       /* Breakpoint Mask Low Byte for Second Address */
    byte BK1MBH      :1;                                       /* Breakpoint Mask High Byte for Second Address */
    byte BK0MBL      :1;                                       /* Breakpoint Mask Low Byte for First Address */
    byte BK0MBH      :1;                                       /* Breakpoint Mask High Byte for First Address */
  } Bits;
} BKPCT1STR;
extern volatile BKPCT1STR _BKPCT1 @(REG_BASE + 0x00000029);
#define BKPCT1                          _BKPCT1.Byte
#define BKPCT1_BK1RW                    _BKPCT1.Bits.BK1RW
#define BKPCT1_BK1RWE                   _BKPCT1.Bits.BK1RWE
#define BKPCT1_BK0RW                    _BKPCT1.Bits.BK0RW
#define BKPCT1_BK0RWE                   _BKPCT1.Bits.BK0RWE
#define BKPCT1_BK1MBL                   _BKPCT1.Bits.BK1MBL
#define BKPCT1_BK1MBH                   _BKPCT1.Bits.BK1MBH
#define BKPCT1_BK0MBL                   _BKPCT1.Bits.BK0MBL
#define BKPCT1_BK0MBH                   _BKPCT1.Bits.BK0MBH

#define BKPCT1_BK1RW_MASK               1
#define BKPCT1_BK1RWE_MASK              2
#define BKPCT1_BK0RW_MASK               4
#define BKPCT1_BK0RWE_MASK              8
#define BKPCT1_BK1MBL_MASK              16
#define BKPCT1_BK1MBH_MASK              32
#define BKPCT1_BK0MBL_MASK              64
#define BKPCT1_BK0MBH_MASK              128


/*** BKP0X - First Address Memory Expansion Breakpoint Register; 0x0000002A ***/
typedef union {
  byte Byte;
  struct {
    byte BK0V0       :1;                                       /* First Address Breakpoint Expansion Address Value Bit 0 */
    byte BK0V1       :1;                                       /* First Address Breakpoint Expansion Address Value Bit 1 */
    byte BK0V2       :1;                                       /* First Address Breakpoint Expansion Address Value Bit 2 */
    byte BK0V3       :1;                                       /* First Address Breakpoint Expansion Address Value Bit 3 */
    byte BK0V4       :1;                                       /* First Address Breakpoint Expansion Address Value Bit 4 */
    byte BK0V5       :1;                                       /* First Address Breakpoint Expansion Address Value Bit 5 */
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpBK0V :6;
    byte         :1;
    byte         :1;
  } MergedBits;
} BKP0XSTR;
extern volatile BKP0XSTR _BKP0X @(REG_BASE + 0x0000002A);
#define BKP0X                           _BKP0X.Byte
#define BKP0X_BK0V0                     _BKP0X.Bits.BK0V0
#define BKP0X_BK0V1                     _BKP0X.Bits.BK0V1
#define BKP0X_BK0V2                     _BKP0X.Bits.BK0V2
#define BKP0X_BK0V3                     _BKP0X.Bits.BK0V3
#define BKP0X_BK0V4                     _BKP0X.Bits.BK0V4
#define BKP0X_BK0V5                     _BKP0X.Bits.BK0V5
#define BKP0X_BK0V                      _BKP0X.MergedBits.grpBK0V

#define BKP0X_BK0V0_MASK                1
#define BKP0X_BK0V1_MASK                2
#define BKP0X_BK0V2_MASK                4
#define BKP0X_BK0V3_MASK                8
#define BKP0X_BK0V4_MASK                16
#define BKP0X_BK0V5_MASK                32
#define BKP0X_BK0V_MASK                 %BitsMask
#define BKP0X_BK0V_BITNUM               %BitsNum


/*** BKP0H - First Address High Byte Breakpoint Register; 0x0000002B ***/
typedef union {
  byte Byte;
  struct {
    byte BIT8        :1;                                       /* First Address Breakpoint Register Bit 8 */
    byte BIT9        :1;                                       /* First Address Breakpoint Register Bit 9 */
    byte BIT10       :1;                                       /* First Address Breakpoint Register Bit 10 */
    byte BIT11       :1;                                       /* First Address Breakpoint Register Bit 11 */
    byte BIT12       :1;                                       /* First Address Breakpoint Register Bit 12 */
    byte BIT13       :1;                                       /* First Address Breakpoint Register Bit 13 */
    byte BIT14       :1;                                       /* First Address Breakpoint Register Bit 14 */
    byte BIT15       :1;                                       /* First Address Breakpoint Register Bit 15 */
  } Bits;
} BKP0HSTR;
extern volatile BKP0HSTR _BKP0H @(REG_BASE + 0x0000002B);
#define BKP0H                           _BKP0H.Byte
#define BKP0H_BIT8                      _BKP0H.Bits.BIT8
#define BKP0H_BIT9                      _BKP0H.Bits.BIT9
#define BKP0H_BIT10                     _BKP0H.Bits.BIT10
#define BKP0H_BIT11                     _BKP0H.Bits.BIT11
#define BKP0H_BIT12                     _BKP0H.Bits.BIT12
#define BKP0H_BIT13                     _BKP0H.Bits.BIT13
#define BKP0H_BIT14                     _BKP0H.Bits.BIT14
#define BKP0H_BIT15                     _BKP0H.Bits.BIT15

#define BKP0H_BIT8_MASK                 1
#define BKP0H_BIT9_MASK                 2
#define BKP0H_BIT10_MASK                4
#define BKP0H_BIT11_MASK                8
#define BKP0H_BIT12_MASK                16
#define BKP0H_BIT13_MASK                32
#define BKP0H_BIT14_MASK                64
#define BKP0H_BIT15_MASK                128


/*** BKP0L - First Address Low Byte Breakpoint Register; 0x0000002C ***/
typedef union {
  byte Byte;
  struct {
    byte BIT0        :1;                                       /* First Address Breakpoint Register Bit 0 */
    byte BIT1        :1;                                       /* First Address Breakpoint Register Bit 1 */
    byte BIT2        :1;                                       /* First Address Breakpoint Register Bit 2 */
    byte BIT3        :1;                                       /* First Address Breakpoint Register Bit 3 */
    byte BIT4        :1;                                       /* First Address Breakpoint Register Bit 4 */
    byte BIT5        :1;                                       /* First Address Breakpoint Register Bit 5 */
    byte BIT6        :1;                                       /* First Address Breakpoint Register Bit 6 */
    byte BIT7        :1;                                       /* First Address Breakpoint Register Bit 7 */
  } Bits;
} BKP0LSTR;
extern volatile BKP0LSTR _BKP0L @(REG_BASE + 0x0000002C);
#define BKP0L                           _BKP0L.Byte
#define BKP0L_BIT0                      _BKP0L.Bits.BIT0
#define BKP0L_BIT1                      _BKP0L.Bits.BIT1
#define BKP0L_BIT2                      _BKP0L.Bits.BIT2
#define BKP0L_BIT3                      _BKP0L.Bits.BIT3
#define BKP0L_BIT4                      _BKP0L.Bits.BIT4
#define BKP0L_BIT5                      _BKP0L.Bits.BIT5
#define BKP0L_BIT6                      _BKP0L.Bits.BIT6
#define BKP0L_BIT7                      _BKP0L.Bits.BIT7

#define BKP0L_BIT0_MASK                 1
#define BKP0L_BIT1_MASK                 2
#define BKP0L_BIT2_MASK                 4
#define BKP0L_BIT3_MASK                 8
#define BKP0L_BIT4_MASK                 16
#define BKP0L_BIT5_MASK                 32
#define BKP0L_BIT6_MASK                 64
#define BKP0L_BIT7_MASK                 128


/*** BKP1X - Second Address Memory Expansion Breakpoint Register; 0x0000002D ***/
typedef union {
  byte Byte;
  struct {
    byte BK1V0       :1;                                       /* Second Address Breakpoint Expansion Address Value Bit 0 */
    byte BK1V1       :1;                                       /* Second Address Breakpoint Expansion Address Value Bit 1 */
    byte BK1V2       :1;                                       /* Second Address Breakpoint Expansion Address Value Bit 2 */
    byte BK1V3       :1;                                       /* Second Address Breakpoint Expansion Address Value Bit 3 */
    byte BK1V4       :1;                                       /* Second Address Breakpoint Expansion Address Value Bit 4 */
    byte BK1V5       :1;                                       /* Second Address Breakpoint Expansion Address Value Bit 5 */
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpBK1V :6;
    byte         :1;
    byte         :1;
  } MergedBits;
} BKP1XSTR;
extern volatile BKP1XSTR _BKP1X @(REG_BASE + 0x0000002D);
#define BKP1X                           _BKP1X.Byte
#define BKP1X_BK1V0                     _BKP1X.Bits.BK1V0
#define BKP1X_BK1V1                     _BKP1X.Bits.BK1V1
#define BKP1X_BK1V2                     _BKP1X.Bits.BK1V2
#define BKP1X_BK1V3                     _BKP1X.Bits.BK1V3
#define BKP1X_BK1V4                     _BKP1X.Bits.BK1V4
#define BKP1X_BK1V5                     _BKP1X.Bits.BK1V5
#define BKP1X_BK1V                      _BKP1X.MergedBits.grpBK1V

#define BKP1X_BK1V0_MASK                1
#define BKP1X_BK1V1_MASK                2
#define BKP1X_BK1V2_MASK                4
#define BKP1X_BK1V3_MASK                8
#define BKP1X_BK1V4_MASK                16
#define BKP1X_BK1V5_MASK                32
#define BKP1X_BK1V_MASK                 %BitsMask
#define BKP1X_BK1V_BITNUM               %BitsNum


/*** BKP1H - Data (Second Address) High Byte Breakpoint Register; 0x0000002E ***/
typedef union {
  byte Byte;
  struct {
    byte BIT8        :1;                                       /* Data (Second Address) Breakpoint Register Bit 8 */
    byte BIT9        :1;                                       /* Data (Second Address) Breakpoint Register Bit 9 */
    byte BIT10       :1;                                       /* Data (Second Address) Breakpoint Register Bit 10 */
    byte BIT11       :1;                                       /* Data (Second Address) Breakpoint Register Bit 11 */
    byte BIT12       :1;                                       /* Data (Second Address) Breakpoint Register Bit 12 */
    byte BIT13       :1;                                       /* Data (Second Address) Breakpoint Register Bit 13 */
    byte BIT14       :1;                                       /* Data (Second Address) Breakpoint Register Bit 14 */
    byte BIT15       :1;                                       /* Data (Second Address) Breakpoint Register Bit 15 */
  } Bits;
} BKP1HSTR;
extern volatile BKP1HSTR _BKP1H @(REG_BASE + 0x0000002E);
#define BKP1H                           _BKP1H.Byte
#define BKP1H_BIT8                      _BKP1H.Bits.BIT8
#define BKP1H_BIT9                      _BKP1H.Bits.BIT9
#define BKP1H_BIT10                     _BKP1H.Bits.BIT10
#define BKP1H_BIT11                     _BKP1H.Bits.BIT11
#define BKP1H_BIT12                     _BKP1H.Bits.BIT12
#define BKP1H_BIT13                     _BKP1H.Bits.BIT13
#define BKP1H_BIT14                     _BKP1H.Bits.BIT14
#define BKP1H_BIT15                     _BKP1H.Bits.BIT15

#define BKP1H_BIT8_MASK                 1
#define BKP1H_BIT9_MASK                 2
#define BKP1H_BIT10_MASK                4
#define BKP1H_BIT11_MASK                8
#define BKP1H_BIT12_MASK                16
#define BKP1H_BIT13_MASK                32
#define BKP1H_BIT14_MASK                64
#define BKP1H_BIT15_MASK                128


/*** BKP1L - Data (Second Address) Low Byte Breakpoint Register; 0x0000002F ***/
typedef union {
  byte Byte;
  struct {
    byte BIT0        :1;                                       /* Data (Second Address) Breakpoint Register Bit 0 */
    byte BIT1        :1;                                       /* Data (Second Address) Breakpoint Register Bit 1 */
    byte BIT2        :1;                                       /* Data (Second Address) Breakpoint Register Bit 2 */
    byte BIT3        :1;                                       /* Data (Second Address) Breakpoint Register Bit 3 */
    byte BIT4        :1;                                       /* Data (Second Address) Breakpoint Register Bit 4 */
    byte BIT5        :1;                                       /* Data (Second Address) Breakpoint Register Bit 5 */
    byte BIT6        :1;                                       /* Data (Second Address) Breakpoint Register Bit 6 */
    byte BIT7        :1;                                       /* Data (Second Address) Breakpoint Register Bit 7 */
  } Bits;
} BKP1LSTR;
extern volatile BKP1LSTR _BKP1L @(REG_BASE + 0x0000002F);
#define BKP1L                           _BKP1L.Byte
#define BKP1L_BIT0                      _BKP1L.Bits.BIT0
#define BKP1L_BIT1                      _BKP1L.Bits.BIT1
#define BKP1L_BIT2                      _BKP1L.Bits.BIT2
#define BKP1L_BIT3                      _BKP1L.Bits.BIT3
#define BKP1L_BIT4                      _BKP1L.Bits.BIT4
#define BKP1L_BIT5                      _BKP1L.Bits.BIT5
#define BKP1L_BIT6                      _BKP1L.Bits.BIT6
#define BKP1L_BIT7                      _BKP1L.Bits.BIT7

#define BKP1L_BIT0_MASK                 1
#define BKP1L_BIT1_MASK                 2
#define BKP1L_BIT2_MASK                 4
#define BKP1L_BIT3_MASK                 8
#define BKP1L_BIT4_MASK                 16
#define BKP1L_BIT5_MASK                 32
#define BKP1L_BIT6_MASK                 64
#define BKP1L_BIT7_MASK                 128


/*** PPAGE - Page Index Register; 0x00000030 ***/
typedef union {
  byte Byte;
  struct {
    byte PIX0        :1;                                       /* Page Index Register Bit 0 */
    byte PIX1        :1;                                       /* Page Index Register Bit 1 */
    byte PIX2        :1;                                       /* Page Index Register Bit 2 */
    byte PIX3        :1;                                       /* Page Index Register Bit 3 */
    byte PIX4        :1;                                       /* Page Index Register Bit 4 */
    byte PIX5        :1;                                       /* Page Index Register Bit 5 */
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpPIX  :6;
    byte         :1;
    byte         :1;
  } MergedBits;
} PPAGESTR;
extern volatile PPAGESTR _PPAGE @(REG_BASE + 0x00000030);
#define PPAGE                           _PPAGE.Byte
#define PPAGE_PIX0                      _PPAGE.Bits.PIX0
#define PPAGE_PIX1                      _PPAGE.Bits.PIX1
#define PPAGE_PIX2                      _PPAGE.Bits.PIX2
#define PPAGE_PIX3                      _PPAGE.Bits.PIX3
#define PPAGE_PIX4                      _PPAGE.Bits.PIX4
#define PPAGE_PIX5                      _PPAGE.Bits.PIX5
#define PPAGE_PIX                       _PPAGE.MergedBits.grpPIX

#define PPAGE_PIX0_MASK                 1
#define PPAGE_PIX1_MASK                 2
#define PPAGE_PIX2_MASK                 4
#define PPAGE_PIX3_MASK                 8
#define PPAGE_PIX4_MASK                 16
#define PPAGE_PIX5_MASK                 32
#define PPAGE_PIX_MASK                  %BitsMask
#define PPAGE_PIX_BITNUM                %BitsNum


/*** PORTK - Port K Data Register; 0x00000032 ***/
typedef union {
  byte Byte;
  struct {
    byte BIT0        :1;                                       /* Port K Bit 0 */
    byte BIT1        :1;                                       /* Port K Bit 1 */
    byte BIT2        :1;                                       /* Port K Bit 2 */
    byte BIT3        :1;                                       /* Port K Bit 3 */
    byte BIT4        :1;                                       /* Port K Bit 4 */
    byte BIT5        :1;                                       /* Port K Bit 5 */
    byte BIT6        :1;                                       /* Port K Bit 6 */
    byte BIT7        :1;                                       /* Port K Bit 7 */
  } Bits;
} PORTKSTR;
extern volatile PORTKSTR _PORTK @(REG_BASE + 0x00000032);
#define PORTK                           _PORTK.Byte
#define PORTK_BIT0                      _PORTK.Bits.BIT0
#define PORTK_BIT1                      _PORTK.Bits.BIT1
#define PORTK_BIT2                      _PORTK.Bits.BIT2
#define PORTK_BIT3                      _PORTK.Bits.BIT3
#define PORTK_BIT4                      _PORTK.Bits.BIT4
#define PORTK_BIT5                      _PORTK.Bits.BIT5
#define PORTK_BIT6                      _PORTK.Bits.BIT6
#define PORTK_BIT7                      _PORTK.Bits.BIT7

#define PORTK_BIT0_MASK                 1
#define PORTK_BIT1_MASK                 2
#define PORTK_BIT2_MASK                 4
#define PORTK_BIT3_MASK                 8
#define PORTK_BIT4_MASK                 16
#define PORTK_BIT5_MASK                 32
#define PORTK_BIT6_MASK                 64
#define PORTK_BIT7_MASK                 128


/*** DDRK - Port K Data Direction Register; 0x00000033 ***/
typedef union {
  byte Byte;
  struct {
    byte BIT0        :1;                                       /* Port K Data Direction Bit 0 */
    byte BIT1        :1;                                       /* Port K Data Direction Bit 1 */
    byte BIT2        :1;                                       /* Port K Data Direction Bit 2 */
    byte BIT3        :1;                                       /* Port K Data Direction Bit 3 */
    byte BIT4        :1;                                       /* Port K Data Direction Bit 4 */
    byte BIT5        :1;                                       /* Port K Data Direction Bit 5 */
    byte BIT6        :1;                                       /* Port K Data Direction Bit 6 */
    byte BIT7        :1;                                       /* Port K Data Direction Bit 7 */
  } Bits;
} DDRKSTR;
extern volatile DDRKSTR _DDRK @(REG_BASE + 0x00000033);
#define DDRK                            _DDRK.Byte
#define DDRK_BIT0                       _DDRK.Bits.BIT0
#define DDRK_BIT1                       _DDRK.Bits.BIT1
#define DDRK_BIT2                       _DDRK.Bits.BIT2
#define DDRK_BIT3                       _DDRK.Bits.BIT3
#define DDRK_BIT4                       _DDRK.Bits.BIT4
#define DDRK_BIT5                       _DDRK.Bits.BIT5
#define DDRK_BIT6                       _DDRK.Bits.BIT6
#define DDRK_BIT7                       _DDRK.Bits.BIT7

#define DDRK_BIT0_MASK                  1
#define DDRK_BIT1_MASK                  2
#define DDRK_BIT2_MASK                  4
#define DDRK_BIT3_MASK                  8
#define DDRK_BIT4_MASK                  16
#define DDRK_BIT5_MASK                  32
#define DDRK_BIT6_MASK                  64
#define DDRK_BIT7_MASK                  128


/*** SYNR - CRG Synthesizer Register; 0x00000034 ***/
typedef union {
  byte Byte;
  struct {
    byte SYN0        :1;                                       /* CRG Synthesizer Bit 0 */
    byte SYN1        :1;                                       /* CRG Synthesizer Bit 1 */
    byte SYN2        :1;                                       /* CRG Synthesizer Bit 2 */
    byte SYN3        :1;                                       /* CRG Synthesizer Bit 3 */
    byte SYN4        :1;                                       /* CRG Synthesizer Bit 4 */
    byte SYN5        :1;                                       /* CRG Synthesizer Bit 5 */
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpSYN  :6;
    byte         :1;
    byte         :1;
  } MergedBits;
} SYNRSTR;
extern volatile SYNRSTR _SYNR @(REG_BASE + 0x00000034);
#define SYNR                            _SYNR.Byte
#define SYNR_SYN0                       _SYNR.Bits.SYN0
#define SYNR_SYN1                       _SYNR.Bits.SYN1
#define SYNR_SYN2                       _SYNR.Bits.SYN2
#define SYNR_SYN3                       _SYNR.Bits.SYN3
#define SYNR_SYN4                       _SYNR.Bits.SYN4
#define SYNR_SYN5                       _SYNR.Bits.SYN5
#define SYNR_SYN                        _SYNR.MergedBits.grpSYN

#define SYNR_SYN0_MASK                  1
#define SYNR_SYN1_MASK                  2
#define SYNR_SYN2_MASK                  4
#define SYNR_SYN3_MASK                  8
#define SYNR_SYN4_MASK                  16
#define SYNR_SYN5_MASK                  32
#define SYNR_SYN_MASK                   %BitsMask
#define SYNR_SYN_BITNUM                 %BitsNum


/*** REFDV - CRG Reference Divider Register; 0x00000035 ***/
typedef union {
  byte Byte;
  struct {
    byte REFDV0      :1;                                       /* CRG Reference Divider Bit 0 */
    byte REFDV1      :1;                                       /* CRG Reference Divider Bit 1 */
    byte REFDV2      :1;                                       /* CRG Reference Divider Bit 2 */
    byte REFDV3      :1;                                       /* CRG Reference Divider Bit 3 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpREFDV :4;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} REFDVSTR;
extern volatile REFDVSTR _REFDV @(REG_BASE + 0x00000035);
#define REFDV                           _REFDV.Byte
#define REFDV_REFDV0                    _REFDV.Bits.REFDV0
#define REFDV_REFDV1                    _REFDV.Bits.REFDV1
#define REFDV_REFDV2                    _REFDV.Bits.REFDV2
#define REFDV_REFDV3                    _REFDV.Bits.REFDV3
#define REFDV_REFDV                     _REFDV.MergedBits.grpREFDV

#define REFDV_REFDV0_MASK               1
#define REFDV_REFDV1_MASK               2
#define REFDV_REFDV2_MASK               4
#define REFDV_REFDV3_MASK               8
#define REFDV_REFDV_MASK                %BitsMask
#define REFDV_REFDV_BITNUM              %BitsNum


/*** CRGFLG - CRG Flags Register; 0x00000037 ***/
typedef union {
  byte Byte;
  struct {
    byte SCM         :1;                                       /* Self-clock mode Status */
    byte SCMIF       :1;                                       /* Self-clock mode Interrupt Flag */
    byte TRACK       :1;                                       /* Track Status */
    byte LOCK        :1;                                       /* Lock Status */
    byte LOCKIF      :1;                                       /* PLL Lock Interrupt Flag */
    byte LVRF        :1;                                       /* Low Voltage Reset Flag */
    byte PORF        :1;                                       /* Power on Reset Flag */
    byte RTIF        :1;                                       /* Real Time Interrupt Flag */
  } Bits;
} CRGFLGSTR;
extern volatile CRGFLGSTR _CRGFLG @(REG_BASE + 0x00000037);
#define CRGFLG                          _CRGFLG.Byte
#define CRGFLG_SCM                      _CRGFLG.Bits.SCM
#define CRGFLG_SCMIF                    _CRGFLG.Bits.SCMIF
#define CRGFLG_TRACK                    _CRGFLG.Bits.TRACK
#define CRGFLG_LOCK                     _CRGFLG.Bits.LOCK
#define CRGFLG_LOCKIF                   _CRGFLG.Bits.LOCKIF
#define CRGFLG_LVRF                     _CRGFLG.Bits.LVRF
#define CRGFLG_PORF                     _CRGFLG.Bits.PORF
#define CRGFLG_RTIF                     _CRGFLG.Bits.RTIF

#define CRGFLG_SCM_MASK                 1
#define CRGFLG_SCMIF_MASK               2
#define CRGFLG_TRACK_MASK               4
#define CRGFLG_LOCK_MASK                8
#define CRGFLG_LOCKIF_MASK              16
#define CRGFLG_LVRF_MASK                32
#define CRGFLG_PORF_MASK                64
#define CRGFLG_RTIF_MASK                128


/*** CRGINT - CRG Interrupt Enable Register; 0x00000038 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte SCMIE       :1;                                       /* Self-clock mode Interrupt Enable */
    byte             :1; 
    byte             :1; 
    byte LOCKIE      :1;                                       /* Lock Interrupt Enable */
    byte             :1; 
    byte             :1; 
    byte RTIE        :1;                                       /* Real Time Interrupt Enable */
  } Bits;
} CRGINTSTR;
extern volatile CRGINTSTR _CRGINT @(REG_BASE + 0x00000038);
#define CRGINT                          _CRGINT.Byte
#define CRGINT_SCMIE                    _CRGINT.Bits.SCMIE
#define CRGINT_LOCKIE                   _CRGINT.Bits.LOCKIE
#define CRGINT_RTIE                     _CRGINT.Bits.RTIE

#define CRGINT_SCMIE_MASK               2
#define CRGINT_LOCKIE_MASK              16
#define CRGINT_RTIE_MASK                128


/*** CLKSEL - CRG Clock Select Register; 0x00000039 ***/
typedef union {
  byte Byte;
  struct {
    byte COPWAI      :1;                                       /* COP stops in WAIT mode */
    byte RTIWAI      :1;                                       /* RTI stops in WAIT mode */
    byte CWAI        :1;                                       /* CLK24 and CLK23 stop in WAIT mode */
    byte PLLWAI      :1;                                       /* PLL stops in WAIT mode */
    byte ROAWAI      :1;                                       /* Reduced Oscillator Amplitude in WAIT mode */
    byte SYSWAI      :1;                                       /* System clocks stop in WAIT mode */
    byte PSTP        :1;                                       /* Pseudo Stop */
    byte PLLSEL      :1;                                       /* PLL selected for system clock */
  } Bits;
} CLKSELSTR;
extern volatile CLKSELSTR _CLKSEL @(REG_BASE + 0x00000039);
#define CLKSEL                          _CLKSEL.Byte
#define CLKSEL_COPWAI                   _CLKSEL.Bits.COPWAI
#define CLKSEL_RTIWAI                   _CLKSEL.Bits.RTIWAI
#define CLKSEL_CWAI                     _CLKSEL.Bits.CWAI
#define CLKSEL_PLLWAI                   _CLKSEL.Bits.PLLWAI
#define CLKSEL_ROAWAI                   _CLKSEL.Bits.ROAWAI
#define CLKSEL_SYSWAI                   _CLKSEL.Bits.SYSWAI
#define CLKSEL_PSTP                     _CLKSEL.Bits.PSTP
#define CLKSEL_PLLSEL                   _CLKSEL.Bits.PLLSEL

#define CLKSEL_COPWAI_MASK              1
#define CLKSEL_RTIWAI_MASK              2
#define CLKSEL_CWAI_MASK                4
#define CLKSEL_PLLWAI_MASK              8
#define CLKSEL_ROAWAI_MASK              16
#define CLKSEL_SYSWAI_MASK              32
#define CLKSEL_PSTP_MASK                64
#define CLKSEL_PLLSEL_MASK              128


/*** PLLCTL - CRG PLL Control Register; 0x0000003A ***/
typedef union {
  byte Byte;
  struct {
    byte SCME        :1;                                       /* Self-clock mode enable */
    byte PCE         :1;                                       /* COP Enable during Pseudo Stop Bit */
    byte PRE         :1;                                       /* RTI Enable during Pseudo Stop Bit */
    byte             :1; 
    byte ACQ         :1;                                       /* Acquisition */
    byte AUTO        :1;                                       /* Automatic Bandwidth Control */
    byte PLLON       :1;                                       /* Phase Lock Loop On */
    byte CME         :1;                                       /* Crystal Monitor Enable */
  } Bits;
} PLLCTLSTR;
extern volatile PLLCTLSTR _PLLCTL @(REG_BASE + 0x0000003A);
#define PLLCTL                          _PLLCTL.Byte
#define PLLCTL_SCME                     _PLLCTL.Bits.SCME
#define PLLCTL_PCE                      _PLLCTL.Bits.PCE
#define PLLCTL_PRE                      _PLLCTL.Bits.PRE
#define PLLCTL_ACQ                      _PLLCTL.Bits.ACQ
#define PLLCTL_AUTO                     _PLLCTL.Bits.AUTO
#define PLLCTL_PLLON                    _PLLCTL.Bits.PLLON
#define PLLCTL_CME                      _PLLCTL.Bits.CME

#define PLLCTL_SCME_MASK                1
#define PLLCTL_PCE_MASK                 2
#define PLLCTL_PRE_MASK                 4
#define PLLCTL_ACQ_MASK                 16
#define PLLCTL_AUTO_MASK                32
#define PLLCTL_PLLON_MASK               64
#define PLLCTL_CME_MASK                 128


/*** RTICTL - CRG RTI Control Register; 0x0000003B ***/
typedef union {
  byte Byte;
  struct {
    byte RTR0        :1;                                       /* Real Time Interrupt Modulus Counter Select Bit 0 */
    byte RTR1        :1;                                       /* Real Time Interrupt Modulus Counter Select Bit 1 */
    byte RTR2        :1;                                       /* Real Time Interrupt Modulus Counter Select Bit 2 */
    byte RTR3        :1;                                       /* Real Time Interrupt Modulus Counter Select Bit 3 */
    byte RTR4        :1;                                       /* Real Time Interrupt Prescale Rate Select Bit 4 */
    byte RTR5        :1;                                       /* Real Time Interrupt Prescale Rate Select Bit 5 */
    byte RTR6        :1;                                       /* Real Time Interrupt Prescale Rate Select Bit 6 */
    byte             :1; 
  } Bits;
  struct {
    byte grpRTR  :7;
    byte         :1;
  } MergedBits;
} RTICTLSTR;
extern volatile RTICTLSTR _RTICTL @(REG_BASE + 0x0000003B);
#define RTICTL                          _RTICTL.Byte
#define RTICTL_RTR0                     _RTICTL.Bits.RTR0
#define RTICTL_RTR1                     _RTICTL.Bits.RTR1
#define RTICTL_RTR2                     _RTICTL.Bits.RTR2
#define RTICTL_RTR3                     _RTICTL.Bits.RTR3
#define RTICTL_RTR4                     _RTICTL.Bits.RTR4
#define RTICTL_RTR5                     _RTICTL.Bits.RTR5
#define RTICTL_RTR6                     _RTICTL.Bits.RTR6
#define RTICTL_RTR                      _RTICTL.MergedBits.grpRTR

#define RTICTL_RTR0_MASK                1
#define RTICTL_RTR1_MASK                2
#define RTICTL_RTR2_MASK                4
#define RTICTL_RTR3_MASK                8
#define RTICTL_RTR4_MASK                16
#define RTICTL_RTR5_MASK                32
#define RTICTL_RTR6_MASK                64
#define RTICTL_RTR_MASK                 %BitsMask
#define RTICTL_RTR_BITNUM               %BitsNum


/*** COPCTL - CRG COP Control Register; 0x0000003C ***/
typedef union {
  byte Byte;
  struct {
    byte CR0         :1;                                       /* COP Watchdog Timer Rate select Bit 0 */
    byte CR1         :1;                                       /* COP Watchdog Timer Rate select Bit 1 */
    byte CR2         :1;                                       /* COP Watchdog Timer Rate select Bit 2 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte RSBCK       :1;                                       /* COP and RTI stop in Active BDM mode Bit */
    byte WCOP        :1;                                       /* Window COP mode */
  } Bits;
  struct {
    byte grpCR   :3;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} COPCTLSTR;
extern volatile COPCTLSTR _COPCTL @(REG_BASE + 0x0000003C);
#define COPCTL                          _COPCTL.Byte
#define COPCTL_CR0                      _COPCTL.Bits.CR0
#define COPCTL_CR1                      _COPCTL.Bits.CR1
#define COPCTL_CR2                      _COPCTL.Bits.CR2
#define COPCTL_RSBCK                    _COPCTL.Bits.RSBCK
#define COPCTL_WCOP                     _COPCTL.Bits.WCOP
#define COPCTL_CR                       _COPCTL.MergedBits.grpCR

#define COPCTL_CR0_MASK                 1
#define COPCTL_CR1_MASK                 2
#define COPCTL_CR2_MASK                 4
#define COPCTL_RSBCK_MASK               64
#define COPCTL_WCOP_MASK                128
#define COPCTL_CR_MASK                  %BitsMask
#define COPCTL_CR_BITNUM                %BitsNum


/*** ARMCOP - CRG COP Timer Arm/Reset Register; 0x0000003F ***/
typedef union {
  byte Byte;
  struct {
    byte BIT0        :1;                                       /* CRG COP Timer Arm/Reset Bit 0 */
    byte BIT1        :1;                                       /* CRG COP Timer Arm/Reset Bit 1 */
    byte BIT2        :1;                                       /* CRG COP Timer Arm/Reset Bit 2 */
    byte BIT3        :1;                                       /* CRG COP Timer Arm/Reset Bit 3 */
    byte BIT4        :1;                                       /* CRG COP Timer Arm/Reset Bit 4 */
    byte BIT5        :1;                                       /* CRG COP Timer Arm/Reset Bit 5 */
    byte BIT6        :1;                                       /* CRG COP Timer Arm/Reset Bit 6 */
    byte BIT7        :1;                                       /* CRG COP Timer Arm/Reset Bit 7 */
  } Bits;
} ARMCOPSTR;
extern volatile ARMCOPSTR _ARMCOP @(REG_BASE + 0x0000003F);
#define ARMCOP                          _ARMCOP.Byte
#define ARMCOP_BIT0                     _ARMCOP.Bits.BIT0
#define ARMCOP_BIT1                     _ARMCOP.Bits.BIT1
#define ARMCOP_BIT2                     _ARMCOP.Bits.BIT2
#define ARMCOP_BIT3                     _ARMCOP.Bits.BIT3
#define ARMCOP_BIT4                     _ARMCOP.Bits.BIT4
#define ARMCOP_BIT5                     _ARMCOP.Bits.BIT5
#define ARMCOP_BIT6                     _ARMCOP.Bits.BIT6
#define ARMCOP_BIT7                     _ARMCOP.Bits.BIT7

#define ARMCOP_BIT0_MASK                1
#define ARMCOP_BIT1_MASK                2
#define ARMCOP_BIT2_MASK                4
#define ARMCOP_BIT3_MASK                8
#define ARMCOP_BIT4_MASK                16
#define ARMCOP_BIT5_MASK                32
#define ARMCOP_BIT6_MASK                64
#define ARMCOP_BIT7_MASK                128


/*** TIOS - Timer Input Capture/Output Compare Select; 0x00000040 ***/
typedef union {
  byte Byte;
  struct {
    byte IOS0        :1;                                       /* Input Capture or Output Compare Channel Configuration Bit 0 */
    byte IOS1        :1;                                       /* Input Capture or Output Compare Channel Configuration Bit 1 */
    byte IOS2        :1;                                       /* Input Capture or Output Compare Channel Configuration Bit 2 */
    byte IOS3        :1;                                       /* Input Capture or Output Compare Channel Configuration Bit 3 */
    byte IOS4        :1;                                       /* Input Capture or Output Compare Channel Configuration Bit 4 */
    byte IOS5        :1;                                       /* Input Capture or Output Compare Channel Configuration Bit 5 */
    byte IOS6        :1;                                       /* Input Capture or Output Compare Channel Configuration Bit 6 */
    byte IOS7        :1;                                       /* Input Capture or Output Compare Channel Configuration Bit 7 */
  } Bits;
} TIOSSTR;
extern volatile TIOSSTR _TIOS @(REG_BASE + 0x00000040);
#define TIOS                            _TIOS.Byte
#define TIOS_IOS0                       _TIOS.Bits.IOS0
#define TIOS_IOS1                       _TIOS.Bits.IOS1
#define TIOS_IOS2                       _TIOS.Bits.IOS2
#define TIOS_IOS3                       _TIOS.Bits.IOS3
#define TIOS_IOS4                       _TIOS.Bits.IOS4
#define TIOS_IOS5                       _TIOS.Bits.IOS5
#define TIOS_IOS6                       _TIOS.Bits.IOS6
#define TIOS_IOS7                       _TIOS.Bits.IOS7

#define TIOS_IOS0_MASK                  1
#define TIOS_IOS1_MASK                  2
#define TIOS_IOS2_MASK                  4
#define TIOS_IOS3_MASK                  8
#define TIOS_IOS4_MASK                  16
#define TIOS_IOS5_MASK                  32
#define TIOS_IOS6_MASK                  64
#define TIOS_IOS7_MASK                  128


/*** CFORC - Timer Compare Force Register; 0x00000041 ***/
typedef union {
  byte Byte;
  struct {
    byte FOC0        :1;                                       /* Force Output Compare Action for Channel 0 */
    byte FOC1        :1;                                       /* Force Output Compare Action for Channel 1 */
    byte FOC2        :1;                                       /* Force Output Compare Action for Channel 2 */
    byte FOC3        :1;                                       /* Force Output Compare Action for Channel 3 */
    byte FOC4        :1;                                       /* Force Output Compare Action for Channel 4 */
    byte FOC5        :1;                                       /* Force Output Compare Action for Channel 5 */
    byte FOC6        :1;                                       /* Force Output Compare Action for Channel 6 */
    byte FOC7        :1;                                       /* Force Output Compare Action for Channel 7 */
  } Bits;
} CFORCSTR;
extern volatile CFORCSTR _CFORC @(REG_BASE + 0x00000041);
#define CFORC                           _CFORC.Byte
#define CFORC_FOC0                      _CFORC.Bits.FOC0
#define CFORC_FOC1                      _CFORC.Bits.FOC1
#define CFORC_FOC2                      _CFORC.Bits.FOC2
#define CFORC_FOC3                      _CFORC.Bits.FOC3
#define CFORC_FOC4                      _CFORC.Bits.FOC4
#define CFORC_FOC5                      _CFORC.Bits.FOC5
#define CFORC_FOC6                      _CFORC.Bits.FOC6
#define CFORC_FOC7                      _CFORC.Bits.FOC7

#define CFORC_FOC0_MASK                 1
#define CFORC_FOC1_MASK                 2
#define CFORC_FOC2_MASK                 4
#define CFORC_FOC3_MASK                 8
#define CFORC_FOC4_MASK                 16
#define CFORC_FOC5_MASK                 32
#define CFORC_FOC6_MASK                 64
#define CFORC_FOC7_MASK                 128


/*** OC7M - Output Compare 7 Mask Register; 0x00000042 ***/
typedef union {
  byte Byte;
  struct {
    byte OC7M0       :1;                                       /* Output Compare 7 Mask Bit 0 */
    byte OC7M1       :1;                                       /* Output Compare 7 Mask Bit 1 */
    byte OC7M2       :1;                                       /* Output Compare 7 Mask Bit 2 */
    byte OC7M3       :1;                                       /* Output Compare 7 Mask Bit 3 */
    byte OC7M4       :1;                                       /* Output Compare 7 Mask Bit 4 */
    byte OC7M5       :1;                                       /* Output Compare 7 Mask Bit 5 */
    byte OC7M6       :1;                                       /* Output Compare 7 Mask Bit 6 */
    byte OC7M7       :1;                                       /* Output Compare 7 Mask Bit 7 */
  } Bits;
} OC7MSTR;
extern volatile OC7MSTR _OC7M @(REG_BASE + 0x00000042);
#define OC7M                            _OC7M.Byte
#define OC7M_OC7M0                      _OC7M.Bits.OC7M0
#define OC7M_OC7M1                      _OC7M.Bits.OC7M1
#define OC7M_OC7M2                      _OC7M.Bits.OC7M2
#define OC7M_OC7M3                      _OC7M.Bits.OC7M3
#define OC7M_OC7M4                      _OC7M.Bits.OC7M4
#define OC7M_OC7M5                      _OC7M.Bits.OC7M5
#define OC7M_OC7M6                      _OC7M.Bits.OC7M6
#define OC7M_OC7M7                      _OC7M.Bits.OC7M7

#define OC7M_OC7M0_MASK                 1
#define OC7M_OC7M1_MASK                 2
#define OC7M_OC7M2_MASK                 4
#define OC7M_OC7M3_MASK                 8
#define OC7M_OC7M4_MASK                 16
#define OC7M_OC7M5_MASK                 32
#define OC7M_OC7M6_MASK                 64
#define OC7M_OC7M7_MASK                 128


/*** OC7D - Output Compare 7 Data Register; 0x00000043 ***/
typedef union {
  byte Byte;
  struct {
    byte OC7D0       :1;                                       /* Output Compare 7 Bit 0 */
    byte OC7D1       :1;                                       /* Output Compare 7 Bit 1 */
    byte OC7D2       :1;                                       /* Output Compare 7 Bit 2 */
    byte OC7D3       :1;                                       /* Output Compare 7 Bit 3 */
    byte OC7D4       :1;                                       /* Output Compare 7 Bit 4 */
    byte OC7D5       :1;                                       /* Output Compare 7 Bit 5 */
    byte OC7D6       :1;                                       /* Output Compare 7 Bit 6 */
    byte OC7D7       :1;                                       /* Output Compare 7 Bit 7 */
  } Bits;
} OC7DSTR;
extern volatile OC7DSTR _OC7D @(REG_BASE + 0x00000043);
#define OC7D                            _OC7D.Byte
#define OC7D_OC7D0                      _OC7D.Bits.OC7D0
#define OC7D_OC7D1                      _OC7D.Bits.OC7D1
#define OC7D_OC7D2                      _OC7D.Bits.OC7D2
#define OC7D_OC7D3                      _OC7D.Bits.OC7D3
#define OC7D_OC7D4                      _OC7D.Bits.OC7D4
#define OC7D_OC7D5                      _OC7D.Bits.OC7D5
#define OC7D_OC7D6                      _OC7D.Bits.OC7D6
#define OC7D_OC7D7                      _OC7D.Bits.OC7D7

#define OC7D_OC7D0_MASK                 1
#define OC7D_OC7D1_MASK                 2
#define OC7D_OC7D2_MASK                 4
#define OC7D_OC7D3_MASK                 8
#define OC7D_OC7D4_MASK                 16
#define OC7D_OC7D5_MASK                 32
#define OC7D_OC7D6_MASK                 64
#define OC7D_OC7D7_MASK                 128


/*** TCNT - Timer Count Register; 0x00000044 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** TCNTHi - Timer Count Register High; 0x00000044 ***/
    union {
      byte Byte;
    } TCNTHiSTR;
    #define TCNTHi                      _TCNT.Overlap_STR.TCNTHiSTR.Byte
    
    


    /*** TCNTLo - Timer Count Register Low; 0x00000045 ***/
    union {
      byte Byte;
    } TCNTLoSTR;
    #define TCNTLo                      _TCNT.Overlap_STR.TCNTLoSTR.Byte
    
    

  } Overlap_STR;

} TCNTSTR;
extern volatile TCNTSTR _TCNT @(REG_BASE + 0x00000044);
#define TCNT                            _TCNT.Word



/*** TSCR1 - Timer System Control Register1; 0x00000046 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte TFFCA       :1;                                       /* Timer Fast Flag Clear All */
    byte TSFRZ       :1;                                       /* Timer and Modulus Counter Stop While in Freeze Mode */
    byte TSWAI       :1;                                       /* Timer Module Stops While in Wait */
    byte TEN         :1;                                       /* Timer Enable */
  } Bits;
} TSCR1STR;
extern volatile TSCR1STR _TSCR1 @(REG_BASE + 0x00000046);
#define TSCR1                           _TSCR1.Byte
#define TSCR1_TFFCA                     _TSCR1.Bits.TFFCA
#define TSCR1_TSFRZ                     _TSCR1.Bits.TSFRZ
#define TSCR1_TSWAI                     _TSCR1.Bits.TSWAI
#define TSCR1_TEN                       _TSCR1.Bits.TEN

#define TSCR1_TFFCA_MASK                16
#define TSCR1_TSFRZ_MASK                32
#define TSCR1_TSWAI_MASK                64
#define TSCR1_TEN_MASK                  128


/*** TTOV - Timer Toggle On Overflow Register; 0x00000047 ***/
typedef union {
  byte Byte;
  struct {
    byte TOV0        :1;                                       /* Toggle On Overflow Bit 0 */
    byte TOV1        :1;                                       /* Toggle On Overflow Bit 1 */
    byte TOV2        :1;                                       /* Toggle On Overflow Bit 2 */
    byte TOV3        :1;                                       /* Toggle On Overflow Bit 3 */
    byte TOV4        :1;                                       /* Toggle On Overflow Bit 4 */
    byte TOV5        :1;                                       /* Toggle On Overflow Bit 5 */
    byte TOV6        :1;                                       /* Toggle On Overflow Bit 6 */
    byte TOV7        :1;                                       /* Toggle On Overflow Bit 7 */
  } Bits;
} TTOVSTR;
extern volatile TTOVSTR _TTOV @(REG_BASE + 0x00000047);
#define TTOV                            _TTOV.Byte
#define TTOV_TOV0                       _TTOV.Bits.TOV0
#define TTOV_TOV1                       _TTOV.Bits.TOV1
#define TTOV_TOV2                       _TTOV.Bits.TOV2
#define TTOV_TOV3                       _TTOV.Bits.TOV3
#define TTOV_TOV4                       _TTOV.Bits.TOV4
#define TTOV_TOV5                       _TTOV.Bits.TOV5
#define TTOV_TOV6                       _TTOV.Bits.TOV6
#define TTOV_TOV7                       _TTOV.Bits.TOV7

#define TTOV_TOV0_MASK                  1
#define TTOV_TOV1_MASK                  2
#define TTOV_TOV2_MASK                  4
#define TTOV_TOV3_MASK                  8
#define TTOV_TOV4_MASK                  16
#define TTOV_TOV5_MASK                  32
#define TTOV_TOV6_MASK                  64
#define TTOV_TOV7_MASK                  128


/*** TCTL1 - Timer Control Register 1; 0x00000048 ***/
typedef union {
  byte Byte;
  struct {
    byte OL4         :1;                                       /* Output Level Bit 4 */
    byte OM4         :1;                                       /* Output Mode Bit 4 */
    byte OL5         :1;                                       /* Output Level Bit 5 */
    byte OM5         :1;                                       /* Output Mode Bit 5 */
    byte OL6         :1;                                       /* Output Level Bit 6 */
    byte OM6         :1;                                       /* Output Mode Bit 6 */
    byte OL7         :1;                                       /* Output Level Bit 7 */
    byte OM7         :1;                                       /* Output Mode Bit 7 */
  } Bits;
} TCTL1STR;
extern volatile TCTL1STR _TCTL1 @(REG_BASE + 0x00000048);
#define TCTL1                           _TCTL1.Byte
#define TCTL1_OL4                       _TCTL1.Bits.OL4
#define TCTL1_OM4                       _TCTL1.Bits.OM4
#define TCTL1_OL5                       _TCTL1.Bits.OL5
#define TCTL1_OM5                       _TCTL1.Bits.OM5
#define TCTL1_OL6                       _TCTL1.Bits.OL6
#define TCTL1_OM6                       _TCTL1.Bits.OM6
#define TCTL1_OL7                       _TCTL1.Bits.OL7
#define TCTL1_OM7                       _TCTL1.Bits.OM7

#define TCTL1_OL4_MASK                  1
#define TCTL1_OM4_MASK                  2
#define TCTL1_OL5_MASK                  4
#define TCTL1_OM5_MASK                  8
#define TCTL1_OL6_MASK                  16
#define TCTL1_OM6_MASK                  32
#define TCTL1_OL7_MASK                  64
#define TCTL1_OM7_MASK                  128


/*** TCTL2 - Timer Control Register 2; 0x00000049 ***/
typedef union {
  byte Byte;
  struct {
    byte OL0         :1;                                       /* Output Level Bit 0 */
    byte OM0         :1;                                       /* Output Mode Bit 0 */
    byte OL1         :1;                                       /* Output Level Bit 1 */
    byte OM1         :1;                                       /* Output Mode Bit 1 */
    byte OL2         :1;                                       /* Output Level Bit 2 */
    byte OM2         :1;                                       /* Output Mode Bit 2 */
    byte OL3         :1;                                       /* Output Level Bit 3 */
    byte OM3         :1;                                       /* Output Mode Bit 3 */
  } Bits;
} TCTL2STR;
extern volatile TCTL2STR _TCTL2 @(REG_BASE + 0x00000049);
#define TCTL2                           _TCTL2.Byte
#define TCTL2_OL0                       _TCTL2.Bits.OL0
#define TCTL2_OM0                       _TCTL2.Bits.OM0
#define TCTL2_OL1                       _TCTL2.Bits.OL1
#define TCTL2_OM1                       _TCTL2.Bits.OM1
#define TCTL2_OL2                       _TCTL2.Bits.OL2
#define TCTL2_OM2                       _TCTL2.Bits.OM2
#define TCTL2_OL3                       _TCTL2.Bits.OL3
#define TCTL2_OM3                       _TCTL2.Bits.OM3

#define TCTL2_OL0_MASK                  1
#define TCTL2_OM0_MASK                  2
#define TCTL2_OL1_MASK                  4
#define TCTL2_OM1_MASK                  8
#define TCTL2_OL2_MASK                  16
#define TCTL2_OM2_MASK                  32
#define TCTL2_OL3_MASK                  64
#define TCTL2_OM3_MASK                  128


/*** TCTL3 - Timer Control Register 3; 0x0000004A ***/
typedef union {
  byte Byte;
  struct {
    byte EDG4A       :1;                                       /* Input Capture Edge Control 4A */
    byte EDG4B       :1;                                       /* Input Capture Edge Control 4B */
    byte EDG5A       :1;                                       /* Input Capture Edge Control 5A */
    byte EDG5B       :1;                                       /* Input Capture Edge Control 5B */
    byte EDG6A       :1;                                       /* Input Capture Edge Control 6A */
    byte EDG6B       :1;                                       /* Input Capture Edge Control 6B */
    byte EDG7A       :1;                                       /* Input Capture Edge Control 7A */
    byte EDG7B       :1;                                       /* Input Capture Edge Control 7B */
  } Bits;
  struct {
    byte grpEDG4x :2;
    byte grpEDG5x :2;
    byte grpEDG6x :2;
    byte grpEDG7x :2;
  } MergedBits;
} TCTL3STR;
extern volatile TCTL3STR _TCTL3 @(REG_BASE + 0x0000004A);
#define TCTL3                           _TCTL3.Byte
#define TCTL3_EDG4A                     _TCTL3.Bits.EDG4A
#define TCTL3_EDG4B                     _TCTL3.Bits.EDG4B
#define TCTL3_EDG5A                     _TCTL3.Bits.EDG5A
#define TCTL3_EDG5B                     _TCTL3.Bits.EDG5B
#define TCTL3_EDG6A                     _TCTL3.Bits.EDG6A
#define TCTL3_EDG6B                     _TCTL3.Bits.EDG6B
#define TCTL3_EDG7A                     _TCTL3.Bits.EDG7A
#define TCTL3_EDG7B                     _TCTL3.Bits.EDG7B
#define TCTL3_EDG4x                     _TCTL3.MergedBits.grpEDG4x
#define TCTL3_EDG5x                     _TCTL3.MergedBits.grpEDG5x
#define TCTL3_EDG6x                     _TCTL3.MergedBits.grpEDG6x
#define TCTL3_EDG7x                     _TCTL3.MergedBits.grpEDG7x

#define TCTL3_EDG4A_MASK                1
#define TCTL3_EDG4B_MASK                2
#define TCTL3_EDG5A_MASK                4
#define TCTL3_EDG5B_MASK                8
#define TCTL3_EDG6A_MASK                16
#define TCTL3_EDG6B_MASK                32
#define TCTL3_EDG7A_MASK                64
#define TCTL3_EDG7B_MASK                128
#define TCTL3_EDG4x_MASK                %BitsMask
#define TCTL3_EDG4x_BITNUM              %BitsNum
#define TCTL3_EDG5x_MASK                %BitsMask
#define TCTL3_EDG5x_BITNUM              %BitsNum
#define TCTL3_EDG6x_MASK                %BitsMask
#define TCTL3_EDG6x_BITNUM              %BitsNum
#define TCTL3_EDG7x_MASK                %BitsMask
#define TCTL3_EDG7x_BITNUM              %BitsNum


/*** TCTL4 - Timer Control Register 4; 0x0000004B ***/
typedef union {
  byte Byte;
  struct {
    byte EDG0A       :1;                                       /* Input Capture Edge Control 0A */
    byte EDG0B       :1;                                       /* Input Capture Edge Control 0B */
    byte EDG1A       :1;                                       /* Input Capture Edge Control 1A */
    byte EDG1B       :1;                                       /* Input Capture Edge Control 1B */
    byte EDG2A       :1;                                       /* Input Capture Edge Control 2A */
    byte EDG2B       :1;                                       /* Input Capture Edge Control 2B */
    byte EDG3A       :1;                                       /* Input Capture Edge Control 3A */
    byte EDG3B       :1;                                       /* Input Capture Edge Control 3B */
  } Bits;
  struct {
    byte grpEDG0x :2;
    byte grpEDG1x :2;
    byte grpEDG2x :2;
    byte grpEDG3x :2;
  } MergedBits;
} TCTL4STR;
extern volatile TCTL4STR _TCTL4 @(REG_BASE + 0x0000004B);
#define TCTL4                           _TCTL4.Byte
#define TCTL4_EDG0A                     _TCTL4.Bits.EDG0A
#define TCTL4_EDG0B                     _TCTL4.Bits.EDG0B
#define TCTL4_EDG1A                     _TCTL4.Bits.EDG1A
#define TCTL4_EDG1B                     _TCTL4.Bits.EDG1B
#define TCTL4_EDG2A                     _TCTL4.Bits.EDG2A
#define TCTL4_EDG2B                     _TCTL4.Bits.EDG2B
#define TCTL4_EDG3A                     _TCTL4.Bits.EDG3A
#define TCTL4_EDG3B                     _TCTL4.Bits.EDG3B
#define TCTL4_EDG0x                     _TCTL4.MergedBits.grpEDG0x
#define TCTL4_EDG1x                     _TCTL4.MergedBits.grpEDG1x
#define TCTL4_EDG2x                     _TCTL4.MergedBits.grpEDG2x
#define TCTL4_EDG3x                     _TCTL4.MergedBits.grpEDG3x

#define TCTL4_EDG0A_MASK                1
#define TCTL4_EDG0B_MASK                2
#define TCTL4_EDG1A_MASK                4
#define TCTL4_EDG1B_MASK                8
#define TCTL4_EDG2A_MASK                16
#define TCTL4_EDG2B_MASK                32
#define TCTL4_EDG3A_MASK                64
#define TCTL4_EDG3B_MASK                128
#define TCTL4_EDG0x_MASK                %BitsMask
#define TCTL4_EDG0x_BITNUM              %BitsNum
#define TCTL4_EDG1x_MASK                %BitsMask
#define TCTL4_EDG1x_BITNUM              %BitsNum
#define TCTL4_EDG2x_MASK                %BitsMask
#define TCTL4_EDG2x_BITNUM              %BitsNum
#define TCTL4_EDG3x_MASK                %BitsMask
#define TCTL4_EDG3x_BITNUM              %BitsNum


/*** TIE - Timer Interrupt Enable Register; 0x0000004C ***/
typedef union {
  byte Byte;
  struct {
    byte C0I         :1;                                       /* Input Capture/Output Compare Interrupt Enable Bit 0 */
    byte C1I         :1;                                       /* Input Capture/Output Compare Interrupt Enable Bit 1 */
    byte C2I         :1;                                       /* Input Capture/Output Compare Interrupt Enable Bit 2 */
    byte C3I         :1;                                       /* Input Capture/Output Compare Interrupt Enable Bit 3 */
    byte C4I         :1;                                       /* Input Capture/Output Compare Interrupt Enable Bit 4 */
    byte C5I         :1;                                       /* Input Capture/Output Compare Interrupt Enable Bit 5 */
    byte C6I         :1;                                       /* Input Capture/Output Compare Interrupt Enable Bit 6 */
    byte C7I         :1;                                       /* Input Capture/Output Compare Interrupt Enable Bit 7 */
  } Bits;
} TIESTR;
extern volatile TIESTR _TIE @(REG_BASE + 0x0000004C);
#define TIE                             _TIE.Byte
#define TIE_C0I                         _TIE.Bits.C0I
#define TIE_C1I                         _TIE.Bits.C1I
#define TIE_C2I                         _TIE.Bits.C2I
#define TIE_C3I                         _TIE.Bits.C3I
#define TIE_C4I                         _TIE.Bits.C4I
#define TIE_C5I                         _TIE.Bits.C5I
#define TIE_C6I                         _TIE.Bits.C6I
#define TIE_C7I                         _TIE.Bits.C7I

#define TIE_C0I_MASK                    1
#define TIE_C1I_MASK                    2
#define TIE_C2I_MASK                    4
#define TIE_C3I_MASK                    8
#define TIE_C4I_MASK                    16
#define TIE_C5I_MASK                    32
#define TIE_C6I_MASK                    64
#define TIE_C7I_MASK                    128


/*** TSCR2 - Timer System Control Register 2; 0x0000004D ***/
typedef union {
  byte Byte;
  struct {
    byte PR0         :1;                                       /* Timer Prescaler Select Bit 0 */
    byte PR1         :1;                                       /* Timer Prescaler Select Bit 1 */
    byte PR2         :1;                                       /* Timer Prescaler Select Bit 2 */
    byte TCRE        :1;                                       /* Timer Counter Reset Enable */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte TOI         :1;                                       /* Timer Overflow Interrupt Enable */
  } Bits;
  struct {
    byte grpPR   :3;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} TSCR2STR;
extern volatile TSCR2STR _TSCR2 @(REG_BASE + 0x0000004D);
#define TSCR2                           _TSCR2.Byte
#define TSCR2_PR0                       _TSCR2.Bits.PR0
#define TSCR2_PR1                       _TSCR2.Bits.PR1
#define TSCR2_PR2                       _TSCR2.Bits.PR2
#define TSCR2_TCRE                      _TSCR2.Bits.TCRE
#define TSCR2_TOI                       _TSCR2.Bits.TOI
#define TSCR2_PR                        _TSCR2.MergedBits.grpPR

#define TSCR2_PR0_MASK                  1
#define TSCR2_PR1_MASK                  2
#define TSCR2_PR2_MASK                  4
#define TSCR2_TCRE_MASK                 8
#define TSCR2_TOI_MASK                  128
#define TSCR2_PR_MASK                   %BitsMask
#define TSCR2_PR_BITNUM                 %BitsNum


/*** TFLG1 - Main Timer Interrupt Flag 1; 0x0000004E ***/
typedef union {
  byte Byte;
  struct {
    byte C0F         :1;                                       /* Input Capture/Output Compare Channel Flag 0 */
    byte C1F         :1;                                       /* Input Capture/Output Compare Channel Flag 1 */
    byte C2F         :1;                                       /* Input Capture/Output Compare Channel Flag 2 */
    byte C3F         :1;                                       /* Input Capture/Output Compare Channel Flag 3 */
    byte C4F         :1;                                       /* Input Capture/Output Compare Channel Flag 4 */
    byte C5F         :1;                                       /* Input Capture/Output Compare Channel Flag 5 */
    byte C6F         :1;                                       /* Input Capture/Output Compare Channel Flag 6 */
    byte C7F         :1;                                       /* Input Capture/Output Compare Channel Flag 7 */
  } Bits;
} TFLG1STR;
extern volatile TFLG1STR _TFLG1 @(REG_BASE + 0x0000004E);
#define TFLG1                           _TFLG1.Byte
#define TFLG1_C0F                       _TFLG1.Bits.C0F
#define TFLG1_C1F                       _TFLG1.Bits.C1F
#define TFLG1_C2F                       _TFLG1.Bits.C2F
#define TFLG1_C3F                       _TFLG1.Bits.C3F
#define TFLG1_C4F                       _TFLG1.Bits.C4F
#define TFLG1_C5F                       _TFLG1.Bits.C5F
#define TFLG1_C6F                       _TFLG1.Bits.C6F
#define TFLG1_C7F                       _TFLG1.Bits.C7F

#define TFLG1_C0F_MASK                  1
#define TFLG1_C1F_MASK                  2
#define TFLG1_C2F_MASK                  4
#define TFLG1_C3F_MASK                  8
#define TFLG1_C4F_MASK                  16
#define TFLG1_C5F_MASK                  32
#define TFLG1_C6F_MASK                  64
#define TFLG1_C7F_MASK                  128


/*** TFLG2 - Main Timer Interrupt Flag 2; 0x0000004F ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte TOF         :1;                                       /* Timer Overflow Flag */
  } Bits;
} TFLG2STR;
extern volatile TFLG2STR _TFLG2 @(REG_BASE + 0x0000004F);
#define TFLG2                           _TFLG2.Byte
#define TFLG2_TOF                       _TFLG2.Bits.TOF

#define TFLG2_TOF_MASK                  128


/*** TC0 - Timer Input Capture/Output Compare Register 0; 0x00000050 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** TC0Hi - Timer Input Capture/Output Compare Register 0 High; 0x00000050 ***/
    union {
      byte Byte;
    } TC0HiSTR;
    #define TC0Hi                       _TC0.Overlap_STR.TC0HiSTR.Byte
    
    


    /*** TC0Lo - Timer Input Capture/Output Compare Register 0 Low; 0x00000051 ***/
    union {
      byte Byte;
    } TC0LoSTR;
    #define TC0Lo                       _TC0.Overlap_STR.TC0LoSTR.Byte
    
    

  } Overlap_STR;

} TC0STR;
extern volatile TC0STR _TC0 @(REG_BASE + 0x00000050);
#define TC0                             _TC0.Word
/* TC_ARR: Access 8 TCx registers in a array */
#define TC_ARR                          ((Word *) &TC0)



/*** TC1 - Timer Input Capture/Output Compare Register 1; 0x00000052 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** TC1Hi - Timer Input Capture/Output Compare Register 1 High; 0x00000052 ***/
    union {
      byte Byte;
    } TC1HiSTR;
    #define TC1Hi                       _TC1.Overlap_STR.TC1HiSTR.Byte
    
    


    /*** TC1Lo - Timer Input Capture/Output Compare Register 1 Low; 0x00000053 ***/
    union {
      byte Byte;
    } TC1LoSTR;
    #define TC1Lo                       _TC1.Overlap_STR.TC1LoSTR.Byte
    
    

  } Overlap_STR;

} TC1STR;
extern volatile TC1STR _TC1 @(REG_BASE + 0x00000052);
#define TC1                             _TC1.Word



/*** TC2 - Timer Input Capture/Output Compare Register 2; 0x00000054 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** TC2Hi - Timer Input Capture/Output Compare Register 2 High; 0x00000054 ***/
    union {
      byte Byte;
    } TC2HiSTR;
    #define TC2Hi                       _TC2.Overlap_STR.TC2HiSTR.Byte
    
    


    /*** TC2Lo - Timer Input Capture/Output Compare Register 2 Low; 0x00000055 ***/
    union {
      byte Byte;
    } TC2LoSTR;
    #define TC2Lo                       _TC2.Overlap_STR.TC2LoSTR.Byte
    
    

  } Overlap_STR;

} TC2STR;
extern volatile TC2STR _TC2 @(REG_BASE + 0x00000054);
#define TC2                             _TC2.Word



/*** TC3 - Timer Input Capture/Output Compare Register 3; 0x00000056 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** TC3Hi - Timer Input Capture/Output Compare Register 3 High; 0x00000056 ***/
    union {
      byte Byte;
    } TC3HiSTR;
    #define TC3Hi                       _TC3.Overlap_STR.TC3HiSTR.Byte
    
    


    /*** TC3Lo - Timer Input Capture/Output Compare Register 3 Low; 0x00000057 ***/
    union {
      byte Byte;
    } TC3LoSTR;
    #define TC3Lo                       _TC3.Overlap_STR.TC3LoSTR.Byte
    
    

  } Overlap_STR;

} TC3STR;
extern volatile TC3STR _TC3 @(REG_BASE + 0x00000056);
#define TC3                             _TC3.Word



/*** TC4 - Timer Input Capture/Output Compare Register 4; 0x00000058 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** TC4Hi - Timer Input Capture/Output Compare Register 4 High; 0x00000058 ***/
    union {
      byte Byte;
    } TC4HiSTR;
    #define TC4Hi                       _TC4.Overlap_STR.TC4HiSTR.Byte
    
    


    /*** TC4Lo - Timer Input Capture/Output Compare Register 4 Low; 0x00000059 ***/
    union {
      byte Byte;
    } TC4LoSTR;
    #define TC4Lo                       _TC4.Overlap_STR.TC4LoSTR.Byte
    
    

  } Overlap_STR;

} TC4STR;
extern volatile TC4STR _TC4 @(REG_BASE + 0x00000058);
#define TC4                             _TC4.Word



/*** TC5 - Timer Input Capture/Output Compare Register 5; 0x0000005A ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** TC5Hi - Timer Input Capture/Output Compare Register 5 High; 0x0000005A ***/
    union {
      byte Byte;
    } TC5HiSTR;
    #define TC5Hi                       _TC5.Overlap_STR.TC5HiSTR.Byte
    
    


    /*** TC5Lo - Timer Input Capture/Output Compare Register 5 Low; 0x0000005B ***/
    union {
      byte Byte;
    } TC5LoSTR;
    #define TC5Lo                       _TC5.Overlap_STR.TC5LoSTR.Byte
    
    

  } Overlap_STR;

} TC5STR;
extern volatile TC5STR _TC5 @(REG_BASE + 0x0000005A);
#define TC5                             _TC5.Word



/*** TC6 - Timer Input Capture/Output Compare Register 6; 0x0000005C ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** TC6Hi - Timer Input Capture/Output Compare Register 6 High; 0x0000005C ***/
    union {
      byte Byte;
    } TC6HiSTR;
    #define TC6Hi                       _TC6.Overlap_STR.TC6HiSTR.Byte
    
    


    /*** TC6Lo - Timer Input Capture/Output Compare Register 6 Low; 0x0000005D ***/
    union {
      byte Byte;
    } TC6LoSTR;
    #define TC6Lo                       _TC6.Overlap_STR.TC6LoSTR.Byte
    
    

  } Overlap_STR;

} TC6STR;
extern volatile TC6STR _TC6 @(REG_BASE + 0x0000005C);
#define TC6                             _TC6.Word



/*** TC7 - Timer Input Capture/Output Compare Register 7; 0x0000005E ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** TC7Hi - Timer Input Capture/Output Compare Register 7 High; 0x0000005E ***/
    union {
      byte Byte;
    } TC7HiSTR;
    #define TC7Hi                       _TC7.Overlap_STR.TC7HiSTR.Byte
    
    


    /*** TC7Lo - Timer Input Capture/Output Compare Register 7 Low; 0x0000005F ***/
    union {
      byte Byte;
    } TC7LoSTR;
    #define TC7Lo                       _TC7.Overlap_STR.TC7LoSTR.Byte
    
    

  } Overlap_STR;

} TC7STR;
extern volatile TC7STR _TC7 @(REG_BASE + 0x0000005E);
#define TC7                             _TC7.Word



/*** PACTL - 16-Bit Pulse Accumulator A Control Register; 0x00000060 ***/
typedef union {
  byte Byte;
  struct {
    byte PAI         :1;                                       /* Pulse Accumulator Input Interrupt enable */
    byte PAOVI       :1;                                       /* Pulse Accumulator A Overflow Interrupt enable */
    byte CLK0        :1;                                       /* Clock Select Bit 0 */
    byte CLK1        :1;                                       /* Clock Select Bit 1 */
    byte PEDGE       :1;                                       /* Pulse Accumulator Edge Control */
    byte PAMOD       :1;                                       /* Pulse Accumulator Mode */
    byte PAEN        :1;                                       /* Pulse Accumulator A System Enable */
    byte             :1; 
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte grpCLK  :2;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} PACTLSTR;
extern volatile PACTLSTR _PACTL @(REG_BASE + 0x00000060);
#define PACTL                           _PACTL.Byte
#define PACTL_PAI                       _PACTL.Bits.PAI
#define PACTL_PAOVI                     _PACTL.Bits.PAOVI
#define PACTL_CLK0                      _PACTL.Bits.CLK0
#define PACTL_CLK1                      _PACTL.Bits.CLK1
#define PACTL_PEDGE                     _PACTL.Bits.PEDGE
#define PACTL_PAMOD                     _PACTL.Bits.PAMOD
#define PACTL_PAEN                      _PACTL.Bits.PAEN
#define PACTL_CLK                       _PACTL.MergedBits.grpCLK

#define PACTL_PAI_MASK                  1
#define PACTL_PAOVI_MASK                2
#define PACTL_CLK0_MASK                 4
#define PACTL_CLK1_MASK                 8
#define PACTL_PEDGE_MASK                16
#define PACTL_PAMOD_MASK                32
#define PACTL_PAEN_MASK                 64
#define PACTL_CLK_MASK                  %BitsMask
#define PACTL_CLK_BITNUM                %BitsNum


/*** PAFLG - Pulse Accumulator A Flag Register; 0x00000061 ***/
typedef union {
  byte Byte;
  struct {
    byte PAIF        :1;                                       /* Pulse Accumulator Input edge Flag */
    byte PAOVF       :1;                                       /* Pulse Accumulator A Overflow Flag */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} PAFLGSTR;
extern volatile PAFLGSTR _PAFLG @(REG_BASE + 0x00000061);
#define PAFLG                           _PAFLG.Byte
#define PAFLG_PAIF                      _PAFLG.Bits.PAIF
#define PAFLG_PAOVF                     _PAFLG.Bits.PAOVF

#define PAFLG_PAIF_MASK                 1
#define PAFLG_PAOVF_MASK                2


/*** PACNT - Pulse Accumulators Count Register; 0x00000062 ***/
typedef union {
  word Word;
} PACNTSTR;
extern volatile PACNTSTR _PACNT @(REG_BASE + 0x00000062);
#define PACNT                           _PACNT.Word



/*** ATDCTL23 - ATD Control Register 23; 0x00000082 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATDCTL2 - ATD Control Register 2; 0x00000082 ***/
    union {
      byte Byte;
      struct {
        byte ASCIF       :1;                                       /* ATD Sequence Complete Interrupt Flag */
        byte ASCIE       :1;                                       /* ATD Sequence Complete Interrupt Enable */
        byte ETRIGE      :1;                                       /* External Trigger Mode enable */
        byte ETRIGP      :1;                                       /* External Trigger Polarity */
        byte ETRIGLE     :1;                                       /* External Trigger Level/Edge control */
        byte AWAI        :1;                                       /* ATD Power Down in Wait Mode */
        byte AFFC        :1;                                       /* ATD Fast Conversion Complete Flag Clear */
        byte ADPU        :1;                                       /* ATD Disable / Power Down */
      } Bits;
    } ATDCTL2STR;
    #define ATDCTL2                     _ATDCTL23.Overlap_STR.ATDCTL2STR.Byte
    #define ATDCTL2_ASCIF               _ATDCTL23.Overlap_STR.ATDCTL2STR.Bits.ASCIF
    #define ATDCTL2_ASCIE               _ATDCTL23.Overlap_STR.ATDCTL2STR.Bits.ASCIE
    #define ATDCTL2_ETRIGE              _ATDCTL23.Overlap_STR.ATDCTL2STR.Bits.ETRIGE
    #define ATDCTL2_ETRIGP              _ATDCTL23.Overlap_STR.ATDCTL2STR.Bits.ETRIGP
    #define ATDCTL2_ETRIGLE             _ATDCTL23.Overlap_STR.ATDCTL2STR.Bits.ETRIGLE
    #define ATDCTL2_AWAI                _ATDCTL23.Overlap_STR.ATDCTL2STR.Bits.AWAI
    #define ATDCTL2_AFFC                _ATDCTL23.Overlap_STR.ATDCTL2STR.Bits.AFFC
    #define ATDCTL2_ADPU                _ATDCTL23.Overlap_STR.ATDCTL2STR.Bits.ADPU
    
    
    #define ATDCTL2_ASCIF_MASK          1
    #define ATDCTL2_ASCIE_MASK          2
    #define ATDCTL2_ETRIGE_MASK         4
    #define ATDCTL2_ETRIGP_MASK         8
    #define ATDCTL2_ETRIGLE_MASK        16
    #define ATDCTL2_AWAI_MASK           32
    #define ATDCTL2_AFFC_MASK           64
    #define ATDCTL2_ADPU_MASK           128


    /*** ATDCTL3 - ATD Control Register 3; 0x00000083 ***/
    union {
      byte Byte;
      struct {
        byte FRZ0        :1;                                       /* Background Debug Freeze Enable Bit 0 */
        byte FRZ1        :1;                                       /* Background Debug Freeze Enable Bit 1 */
        byte FIFO        :1;                                       /* Result Register FIFO Mode */
        byte S1C         :1;                                       /* Conversion Sequence Length 1 */
        byte S2C         :1;                                       /* Conversion Sequence Length 2 */
        byte S4C         :1;                                       /* Conversion Sequence Length 4 */
        byte S8C         :1;                                       /* Conversion Sequence Length 8 */
        byte             :1; 
      } Bits;
      struct {
        byte grpFRZ :2;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
      } MergedBits;
    } ATDCTL3STR;
    #define ATDCTL3                     _ATDCTL23.Overlap_STR.ATDCTL3STR.Byte
    #define ATDCTL3_FRZ0                _ATDCTL23.Overlap_STR.ATDCTL3STR.Bits.FRZ0
    #define ATDCTL3_FRZ1                _ATDCTL23.Overlap_STR.ATDCTL3STR.Bits.FRZ1
    #define ATDCTL3_FIFO                _ATDCTL23.Overlap_STR.ATDCTL3STR.Bits.FIFO
    #define ATDCTL3_S1C                 _ATDCTL23.Overlap_STR.ATDCTL3STR.Bits.S1C
    #define ATDCTL3_S2C                 _ATDCTL23.Overlap_STR.ATDCTL3STR.Bits.S2C
    #define ATDCTL3_S4C                 _ATDCTL23.Overlap_STR.ATDCTL3STR.Bits.S4C
    #define ATDCTL3_S8C                 _ATDCTL23.Overlap_STR.ATDCTL3STR.Bits.S8C
    
    #define ATDCTL3_FRZ                 _ATDCTL23.Overlap_STR.ATDCTL3STR.MergedBits.grpFRZ
    
    #define ATDCTL3_FRZ0_MASK           1
    #define ATDCTL3_FRZ1_MASK           2
    #define ATDCTL3_FIFO_MASK           4
    #define ATDCTL3_S1C_MASK            8
    #define ATDCTL3_S2C_MASK            16
    #define ATDCTL3_S4C_MASK            32
    #define ATDCTL3_S8C_MASK            64
    #define ATDCTL3_FRZ_MASK            %BitsMask
    #define ATDCTL3_FRZ_BITNUM          %BitsNum

  } Overlap_STR;

  struct {
    word FRZ0        :1;                                       /* Background Debug Freeze Enable Bit 0 */
    word FRZ1        :1;                                       /* Background Debug Freeze Enable Bit 1 */
    word FIFO        :1;                                       /* Result Register FIFO Mode */
    word S1C         :1;                                       /* Conversion Sequence Length 1 */
    word S2C         :1;                                       /* Conversion Sequence Length 2 */
    word S4C         :1;                                       /* Conversion Sequence Length 4 */
    word S8C         :1;                                       /* Conversion Sequence Length 8 */
    word             :1; 
    word ASCIF       :1;                                       /* ATD Sequence Complete Interrupt Flag */
    word ASCIE       :1;                                       /* ATD Sequence Complete Interrupt Enable */
    word ETRIGE      :1;                                       /* External Trigger Mode enable */
    word ETRIGP      :1;                                       /* External Trigger Polarity */
    word ETRIGLE     :1;                                       /* External Trigger Level/Edge control */
    word AWAI        :1;                                       /* ATD Power Down in Wait Mode */
    word AFFC        :1;                                       /* ATD Fast Conversion Complete Flag Clear */
    word ADPU        :1;                                       /* ATD Disable / Power Down */
  } Bits;
  struct {
    word grpFRZ  :2;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} ATDCTL23STR;
extern volatile ATDCTL23STR _ATDCTL23 @(REG_BASE + 0x00000082);
#define ATDCTL23                        _ATDCTL23.Word
#define ATDCTL23_FRZ0                   _ATDCTL23.Bits.FRZ0
#define ATDCTL23_FRZ1                   _ATDCTL23.Bits.FRZ1
#define ATDCTL23_FIFO                   _ATDCTL23.Bits.FIFO
#define ATDCTL23_S1C                    _ATDCTL23.Bits.S1C
#define ATDCTL23_S2C                    _ATDCTL23.Bits.S2C
#define ATDCTL23_S4C                    _ATDCTL23.Bits.S4C
#define ATDCTL23_S8C                    _ATDCTL23.Bits.S8C
#define ATDCTL23_ASCIF                  _ATDCTL23.Bits.ASCIF
#define ATDCTL23_ASCIE                  _ATDCTL23.Bits.ASCIE
#define ATDCTL23_ETRIGE                 _ATDCTL23.Bits.ETRIGE
#define ATDCTL23_ETRIGP                 _ATDCTL23.Bits.ETRIGP
#define ATDCTL23_ETRIGLE                _ATDCTL23.Bits.ETRIGLE
#define ATDCTL23_AWAI                   _ATDCTL23.Bits.AWAI
#define ATDCTL23_AFFC                   _ATDCTL23.Bits.AFFC
#define ATDCTL23_ADPU                   _ATDCTL23.Bits.ADPU
#define ATDCTL23_FRZ                    _ATDCTL23.MergedBits.grpFRZ

#define ATDCTL23_FRZ0_MASK              1
#define ATDCTL23_FRZ1_MASK              2
#define ATDCTL23_FIFO_MASK              4
#define ATDCTL23_S1C_MASK               8
#define ATDCTL23_S2C_MASK               16
#define ATDCTL23_S4C_MASK               32
#define ATDCTL23_S8C_MASK               64
#define ATDCTL23_ASCIF_MASK             256
#define ATDCTL23_ASCIE_MASK             512
#define ATDCTL23_ETRIGE_MASK            1024
#define ATDCTL23_ETRIGP_MASK            2048
#define ATDCTL23_ETRIGLE_MASK           4096
#define ATDCTL23_AWAI_MASK              8192
#define ATDCTL23_AFFC_MASK              16384
#define ATDCTL23_ADPU_MASK              32768
#define ATDCTL23_FRZ_MASK               %BitsMask
#define ATDCTL23_FRZ_BITNUM             %BitsNum


/*** ATDCTL45 - ATD Control Register 45; 0x00000084 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATDCTL4 - ATD Control Register 4; 0x00000084 ***/
    union {
      byte Byte;
      struct {
        byte PRS0        :1;                                       /* ATD Clock Prescaler 0 */
        byte PRS1        :1;                                       /* ATD Clock Prescaler 1 */
        byte PRS2        :1;                                       /* ATD Clock Prescaler 2 */
        byte PRS3        :1;                                       /* ATD Clock Prescaler 3 */
        byte PRS4        :1;                                       /* ATD Clock Prescaler 4 */
        byte SMP0        :1;                                       /* Sample Time Select 0 */
        byte SMP1        :1;                                       /* Sample Time Select 1 */
        byte SRES8       :1;                                       /* ATD Resolution Select */
      } Bits;
      struct {
        byte grpPRS :5;
        byte grpSMP :2;
        byte grpSRES_8 :1;
      } MergedBits;
    } ATDCTL4STR;
    #define ATDCTL4                     _ATDCTL45.Overlap_STR.ATDCTL4STR.Byte
    #define ATDCTL4_PRS0                _ATDCTL45.Overlap_STR.ATDCTL4STR.Bits.PRS0
    #define ATDCTL4_PRS1                _ATDCTL45.Overlap_STR.ATDCTL4STR.Bits.PRS1
    #define ATDCTL4_PRS2                _ATDCTL45.Overlap_STR.ATDCTL4STR.Bits.PRS2
    #define ATDCTL4_PRS3                _ATDCTL45.Overlap_STR.ATDCTL4STR.Bits.PRS3
    #define ATDCTL4_PRS4                _ATDCTL45.Overlap_STR.ATDCTL4STR.Bits.PRS4
    #define ATDCTL4_SMP0                _ATDCTL45.Overlap_STR.ATDCTL4STR.Bits.SMP0
    #define ATDCTL4_SMP1                _ATDCTL45.Overlap_STR.ATDCTL4STR.Bits.SMP1
    #define ATDCTL4_SRES8               _ATDCTL45.Overlap_STR.ATDCTL4STR.Bits.SRES8
    
    #define ATDCTL4_PRS                 _ATDCTL45.Overlap_STR.ATDCTL4STR.MergedBits.grpPRS
    #define ATDCTL4_SMP                 _ATDCTL45.Overlap_STR.ATDCTL4STR.MergedBits.grpSMP
    
    #define ATDCTL4_PRS0_MASK           1
    #define ATDCTL4_PRS1_MASK           2
    #define ATDCTL4_PRS2_MASK           4
    #define ATDCTL4_PRS3_MASK           8
    #define ATDCTL4_PRS4_MASK           16
    #define ATDCTL4_SMP0_MASK           32
    #define ATDCTL4_SMP1_MASK           64
    #define ATDCTL4_SRES8_MASK          128
    #define ATDCTL4_PRS_MASK            %BitsMask
    #define ATDCTL4_PRS_BITNUM          %BitsNum
    #define ATDCTL4_SMP_MASK            %BitsMask
    #define ATDCTL4_SMP_BITNUM          %BitsNum


    /*** ATDCTL5 - ATD Control Register 5; 0x00000085 ***/
    union {
      byte Byte;
      struct {
        byte CA          :1;                                       /* Analog Input Channel Select Code A */
        byte CB          :1;                                       /* Analog Input Channel Select Code B */
        byte CC          :1;                                       /* Analog Input Channel Select Code C */
        byte CD          :1;                                       /* Analog Input Channel Select Code D */
        byte MULT        :1;                                       /* Multi-Channel Sample Mode */
        byte SCAN        :1;                                       /* Continuous Conversion Sequence Mode */
        byte DSGN        :1;                                       /* Signed/Unsigned Result Data Mode */
        byte DJM         :1;                                       /* Result Register Data Justification Mode */
      } Bits;
      struct {
        byte grpCx :4;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
      } MergedBits;
    } ATDCTL5STR;
    #define ATDCTL5                     _ATDCTL45.Overlap_STR.ATDCTL5STR.Byte
    #define ATDCTL5_CA                  _ATDCTL45.Overlap_STR.ATDCTL5STR.Bits.CA
    #define ATDCTL5_CB                  _ATDCTL45.Overlap_STR.ATDCTL5STR.Bits.CB
    #define ATDCTL5_CC                  _ATDCTL45.Overlap_STR.ATDCTL5STR.Bits.CC
    #define ATDCTL5_CD                  _ATDCTL45.Overlap_STR.ATDCTL5STR.Bits.CD
    #define ATDCTL5_MULT                _ATDCTL45.Overlap_STR.ATDCTL5STR.Bits.MULT
    #define ATDCTL5_SCAN                _ATDCTL45.Overlap_STR.ATDCTL5STR.Bits.SCAN
    #define ATDCTL5_DSGN                _ATDCTL45.Overlap_STR.ATDCTL5STR.Bits.DSGN
    #define ATDCTL5_DJM                 _ATDCTL45.Overlap_STR.ATDCTL5STR.Bits.DJM
    
    #define ATDCTL5_Cx                  _ATDCTL45.Overlap_STR.ATDCTL5STR.MergedBits.grpCx
    
    #define ATDCTL5_CA_MASK             1
    #define ATDCTL5_CB_MASK             2
    #define ATDCTL5_CC_MASK             4
    #define ATDCTL5_CD_MASK             8
    #define ATDCTL5_MULT_MASK           16
    #define ATDCTL5_SCAN_MASK           32
    #define ATDCTL5_DSGN_MASK           64
    #define ATDCTL5_DJM_MASK            128
    #define ATDCTL5_Cx_MASK             %BitsMask
    #define ATDCTL5_Cx_BITNUM           %BitsNum

  } Overlap_STR;

  struct {
    word CA          :1;                                       /* Analog Input Channel Select Code A */
    word CB          :1;                                       /* Analog Input Channel Select Code B */
    word CC          :1;                                       /* Analog Input Channel Select Code C */
    word             :1; 
    word MULT        :1;                                       /* Multi-Channel Sample Mode */
    word SCAN        :1;                                       /* Continuous Conversion Sequence Mode */
    word DSGN        :1;                                       /* Signed/Unsigned Result Data Mode */
    word DJM         :1;                                       /* Result Register Data Justification Mode */
    word PRS0        :1;                                       /* ATD Clock Prescaler 0 */
    word PRS1        :1;                                       /* ATD Clock Prescaler 1 */
    word PRS2        :1;                                       /* ATD Clock Prescaler 2 */
    word PRS3        :1;                                       /* ATD Clock Prescaler 3 */
    word PRS4        :1;                                       /* ATD Clock Prescaler 4 */
    word SMP0        :1;                                       /* Sample Time Select 0 */
    word SMP1        :1;                                       /* Sample Time Select 1 */
    word SRES8       :1;                                       /* ATD Resolution Select */
  } Bits;
  struct {
    word grpCx   :3;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpPRS  :5;
    word grpSMP  :2;
    word grpSRES_8 :1;
  } MergedBits;
} ATDCTL45STR;
extern volatile ATDCTL45STR _ATDCTL45 @(REG_BASE + 0x00000084);
#define ATDCTL45                        _ATDCTL45.Word
#define ATDCTL45_CA                     _ATDCTL45.Bits.CA
#define ATDCTL45_CB                     _ATDCTL45.Bits.CB
#define ATDCTL45_CC                     _ATDCTL45.Bits.CC
#define ATDCTL45_MULT                   _ATDCTL45.Bits.MULT
#define ATDCTL45_SCAN                   _ATDCTL45.Bits.SCAN
#define ATDCTL45_DSGN                   _ATDCTL45.Bits.DSGN
#define ATDCTL45_DJM                    _ATDCTL45.Bits.DJM
#define ATDCTL45_PRS0                   _ATDCTL45.Bits.PRS0
#define ATDCTL45_PRS1                   _ATDCTL45.Bits.PRS1
#define ATDCTL45_PRS2                   _ATDCTL45.Bits.PRS2
#define ATDCTL45_PRS3                   _ATDCTL45.Bits.PRS3
#define ATDCTL45_PRS4                   _ATDCTL45.Bits.PRS4
#define ATDCTL45_SMP0                   _ATDCTL45.Bits.SMP0
#define ATDCTL45_SMP1                   _ATDCTL45.Bits.SMP1
#define ATDCTL45_SRES8                  _ATDCTL45.Bits.SRES8
#define ATDCTL45_Cx                     _ATDCTL45.MergedBits.grpCx
#define ATDCTL45_PRS                    _ATDCTL45.MergedBits.grpPRS
#define ATDCTL45_SMP                    _ATDCTL45.MergedBits.grpSMP

#define ATDCTL45_CA_MASK                1
#define ATDCTL45_CB_MASK                2
#define ATDCTL45_CC_MASK                4
#define ATDCTL45_MULT_MASK              16
#define ATDCTL45_SCAN_MASK              32
#define ATDCTL45_DSGN_MASK              64
#define ATDCTL45_DJM_MASK               128
#define ATDCTL45_PRS0_MASK              256
#define ATDCTL45_PRS1_MASK              512
#define ATDCTL45_PRS2_MASK              1024
#define ATDCTL45_PRS3_MASK              2048
#define ATDCTL45_PRS4_MASK              4096
#define ATDCTL45_SMP0_MASK              8192
#define ATDCTL45_SMP1_MASK              16384
#define ATDCTL45_SRES8_MASK             32768
#define ATDCTL45_Cx_MASK                %BitsMask
#define ATDCTL45_Cx_BITNUM              %BitsNum
#define ATDCTL45_PRS_MASK               %BitsMask
#define ATDCTL45_PRS_BITNUM             %BitsNum
#define ATDCTL45_SMP_MASK               %BitsMask
#define ATDCTL45_SMP_BITNUM             %BitsNum


/*** ATDSTAT0 - ATD Status Register 0; 0x00000086 ***/
typedef union {
  byte Byte;
  struct {
    byte CC0         :1;                                       /* Conversion Counter 0 */
    byte CC1         :1;                                       /* Conversion Counter 1 */
    byte CC2         :1;                                       /* Conversion Counter 2 */
    byte CC3         :1;                                       /* Conversion Counter 3 */
    byte FIFOR       :1;                                       /* FIFO Over Run Flag */
    byte ETORF       :1;                                       /* External Trigger Overrun Flag */
    byte             :1; 
    byte SCF         :1;                                       /* Sequence Complete Flag */
  } Bits;
  struct {
    byte grpCC   :4;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} ATDSTAT0STR;
extern volatile ATDSTAT0STR _ATDSTAT0 @(REG_BASE + 0x00000086);
#define ATDSTAT0                        _ATDSTAT0.Byte
#define ATDSTAT0_CC0                    _ATDSTAT0.Bits.CC0
#define ATDSTAT0_CC1                    _ATDSTAT0.Bits.CC1
#define ATDSTAT0_CC2                    _ATDSTAT0.Bits.CC2
#define ATDSTAT0_CC3                    _ATDSTAT0.Bits.CC3
#define ATDSTAT0_FIFOR                  _ATDSTAT0.Bits.FIFOR
#define ATDSTAT0_ETORF                  _ATDSTAT0.Bits.ETORF
#define ATDSTAT0_SCF                    _ATDSTAT0.Bits.SCF
#define ATDSTAT0_CC                     _ATDSTAT0.MergedBits.grpCC

#define ATDSTAT0_CC0_MASK               1
#define ATDSTAT0_CC1_MASK               2
#define ATDSTAT0_CC2_MASK               4
#define ATDSTAT0_CC3_MASK               8
#define ATDSTAT0_FIFOR_MASK             16
#define ATDSTAT0_ETORF_MASK             32
#define ATDSTAT0_SCF_MASK               128
#define ATDSTAT0_CC_MASK                %BitsMask
#define ATDSTAT0_CC_BITNUM              %BitsNum


/*** ATDTEST1 - ATD Test Register; 0x00000089 ***/
typedef union {
  byte Byte;
  struct {
    byte SC          :1;                                       /* Special Channel Conversion Bit */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} ATDTEST1STR;
extern volatile ATDTEST1STR _ATDTEST1 @(REG_BASE + 0x00000089);
#define ATDTEST1                        _ATDTEST1.Byte
#define ATDTEST1_SC                     _ATDTEST1.Bits.SC

#define ATDTEST1_SC_MASK                1


/*** ATDSTAT2 - ATD Status Register 2; 0x0000008A ***/
typedef union {
  byte Byte;
  struct {
    byte CCF8        :1;                                       /* Conversion Complete Flag 8 */
    byte CCF9        :1;                                       /* Conversion Complete Flag 9 */
    byte CCF10       :1;                                       /* Conversion Complete Flag 10 */
    byte CCF11       :1;                                       /* Conversion Complete Flag 11 */
    byte CCF12       :1;                                       /* Conversion Complete Flag 12 */
    byte CCF13       :1;                                       /* Conversion Complete Flag 13 */
    byte CCF14       :1;                                       /* Conversion Complete Flag 14 */
    byte CCF15       :1;                                       /* Conversion Complete Flag 15 */
  } Bits;
} ATDSTAT2STR;
extern volatile ATDSTAT2STR _ATDSTAT2 @(REG_BASE + 0x0000008A);
#define ATDSTAT2                        _ATDSTAT2.Byte
#define ATDSTAT2_CCF8                   _ATDSTAT2.Bits.CCF8
#define ATDSTAT2_CCF9                   _ATDSTAT2.Bits.CCF9
#define ATDSTAT2_CCF10                  _ATDSTAT2.Bits.CCF10
#define ATDSTAT2_CCF11                  _ATDSTAT2.Bits.CCF11
#define ATDSTAT2_CCF12                  _ATDSTAT2.Bits.CCF12
#define ATDSTAT2_CCF13                  _ATDSTAT2.Bits.CCF13
#define ATDSTAT2_CCF14                  _ATDSTAT2.Bits.CCF14
#define ATDSTAT2_CCF15                  _ATDSTAT2.Bits.CCF15

#define ATDSTAT2_CCF8_MASK              1
#define ATDSTAT2_CCF9_MASK              2
#define ATDSTAT2_CCF10_MASK             4
#define ATDSTAT2_CCF11_MASK             8
#define ATDSTAT2_CCF12_MASK             16
#define ATDSTAT2_CCF13_MASK             32
#define ATDSTAT2_CCF14_MASK             64
#define ATDSTAT2_CCF15_MASK             128


/*** ATDSTAT1 - ATD Status Register 1; 0x0000008B ***/
typedef union {
  byte Byte;
  struct {
    byte CCF0        :1;                                       /* Conversion Complete Flag 0 */
    byte CCF1        :1;                                       /* Conversion Complete Flag 1 */
    byte CCF2        :1;                                       /* Conversion Complete Flag 2 */
    byte CCF3        :1;                                       /* Conversion Complete Flag 3 */
    byte CCF4        :1;                                       /* Conversion Complete Flag 4 */
    byte CCF5        :1;                                       /* Conversion Complete Flag 5 */
    byte CCF6        :1;                                       /* Conversion Complete Flag 6 */
    byte CCF7        :1;                                       /* Conversion Complete Flag 7 */
  } Bits;
} ATDSTAT1STR;
extern volatile ATDSTAT1STR _ATDSTAT1 @(REG_BASE + 0x0000008B);
#define ATDSTAT1                        _ATDSTAT1.Byte
#define ATDSTAT1_CCF0                   _ATDSTAT1.Bits.CCF0
#define ATDSTAT1_CCF1                   _ATDSTAT1.Bits.CCF1
#define ATDSTAT1_CCF2                   _ATDSTAT1.Bits.CCF2
#define ATDSTAT1_CCF3                   _ATDSTAT1.Bits.CCF3
#define ATDSTAT1_CCF4                   _ATDSTAT1.Bits.CCF4
#define ATDSTAT1_CCF5                   _ATDSTAT1.Bits.CCF5
#define ATDSTAT1_CCF6                   _ATDSTAT1.Bits.CCF6
#define ATDSTAT1_CCF7                   _ATDSTAT1.Bits.CCF7

#define ATDSTAT1_CCF0_MASK              1
#define ATDSTAT1_CCF1_MASK              2
#define ATDSTAT1_CCF2_MASK              4
#define ATDSTAT1_CCF3_MASK              8
#define ATDSTAT1_CCF4_MASK              16
#define ATDSTAT1_CCF5_MASK              32
#define ATDSTAT1_CCF6_MASK              64
#define ATDSTAT1_CCF7_MASK              128


/*** ATDDIEN - ATD Input Enable Register; 0x0000008C ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATDDIEN0 - ATD Input Enable Register 0; 0x0000008C ***/
    union {
      byte Byte;
      struct {
        byte IEN8        :1;                                       /* ATD Digital Input Enable on channel 8 */
        byte IEN9        :1;                                       /* ATD Digital Input Enable on channel 9 */
        byte IEN10       :1;                                       /* ATD Digital Input Enable on channel 10 */
        byte IEN11       :1;                                       /* ATD Digital Input Enable on channel 11 */
        byte IEN12       :1;                                       /* ATD Digital Input Enable on channel 12 */
        byte IEN13       :1;                                       /* ATD Digital Input Enable on channel 13 */
        byte IEN14       :1;                                       /* ATD Digital Input Enable on channel 14 */
        byte IEN15       :1;                                       /* ATD Digital Input Enable on channel 15 */
      } Bits;
    } ATDDIEN0STR;
    #define ATDDIEN0                    _ATDDIEN.Overlap_STR.ATDDIEN0STR.Byte
    #define ATDDIEN0_IEN8               _ATDDIEN.Overlap_STR.ATDDIEN0STR.Bits.IEN8
    #define ATDDIEN0_IEN9               _ATDDIEN.Overlap_STR.ATDDIEN0STR.Bits.IEN9
    #define ATDDIEN0_IEN10              _ATDDIEN.Overlap_STR.ATDDIEN0STR.Bits.IEN10
    #define ATDDIEN0_IEN11              _ATDDIEN.Overlap_STR.ATDDIEN0STR.Bits.IEN11
    #define ATDDIEN0_IEN12              _ATDDIEN.Overlap_STR.ATDDIEN0STR.Bits.IEN12
    #define ATDDIEN0_IEN13              _ATDDIEN.Overlap_STR.ATDDIEN0STR.Bits.IEN13
    #define ATDDIEN0_IEN14              _ATDDIEN.Overlap_STR.ATDDIEN0STR.Bits.IEN14
    #define ATDDIEN0_IEN15              _ATDDIEN.Overlap_STR.ATDDIEN0STR.Bits.IEN15
    
    /* ATDDIEN_ARR: Access 2 ATDDIENx registers in a array */
    #define ATDDIEN_ARR                 ((Byte *) &ATDDIEN0)
    
    #define ATDDIEN0_IEN8_MASK          1
    #define ATDDIEN0_IEN9_MASK          2
    #define ATDDIEN0_IEN10_MASK         4
    #define ATDDIEN0_IEN11_MASK         8
    #define ATDDIEN0_IEN12_MASK         16
    #define ATDDIEN0_IEN13_MASK         32
    #define ATDDIEN0_IEN14_MASK         64
    #define ATDDIEN0_IEN15_MASK         128


    /*** ATDDIEN1 - ATD Input Enable Register 1; 0x0000008D ***/
    union {
      byte Byte;
      struct {
        byte IEN0        :1;                                       /* ATD Digital Input Enable on channel 0 */
        byte IEN1        :1;                                       /* ATD Digital Input Enable on channel 1 */
        byte IEN2        :1;                                       /* ATD Digital Input Enable on channel 2 */
        byte IEN3        :1;                                       /* ATD Digital Input Enable on channel 3 */
        byte IEN4        :1;                                       /* ATD Digital Input Enable on channel 4 */
        byte IEN5        :1;                                       /* ATD Digital Input Enable on channel 5 */
        byte IEN6        :1;                                       /* ATD Digital Input Enable on channel 6 */
        byte IEN7        :1;                                       /* ATD Digital Input Enable on channel 7 */
      } Bits;
    } ATDDIEN1STR;
    #define ATDDIEN1                    _ATDDIEN.Overlap_STR.ATDDIEN1STR.Byte
    #define ATDDIEN1_IEN0               _ATDDIEN.Overlap_STR.ATDDIEN1STR.Bits.IEN0
    #define ATDDIEN1_IEN1               _ATDDIEN.Overlap_STR.ATDDIEN1STR.Bits.IEN1
    #define ATDDIEN1_IEN2               _ATDDIEN.Overlap_STR.ATDDIEN1STR.Bits.IEN2
    #define ATDDIEN1_IEN3               _ATDDIEN.Overlap_STR.ATDDIEN1STR.Bits.IEN3
    #define ATDDIEN1_IEN4               _ATDDIEN.Overlap_STR.ATDDIEN1STR.Bits.IEN4
    #define ATDDIEN1_IEN5               _ATDDIEN.Overlap_STR.ATDDIEN1STR.Bits.IEN5
    #define ATDDIEN1_IEN6               _ATDDIEN.Overlap_STR.ATDDIEN1STR.Bits.IEN6
    #define ATDDIEN1_IEN7               _ATDDIEN.Overlap_STR.ATDDIEN1STR.Bits.IEN7
    
    
    #define ATDDIEN1_IEN0_MASK          1
    #define ATDDIEN1_IEN1_MASK          2
    #define ATDDIEN1_IEN2_MASK          4
    #define ATDDIEN1_IEN3_MASK          8
    #define ATDDIEN1_IEN4_MASK          16
    #define ATDDIEN1_IEN5_MASK          32
    #define ATDDIEN1_IEN6_MASK          64
    #define ATDDIEN1_IEN7_MASK          128

  } Overlap_STR;

  struct {
    word IEN0        :1;                                       /* ATD Digital Input Enable on channel 0 */
    word IEN1        :1;                                       /* ATD Digital Input Enable on channel 1 */
    word IEN2        :1;                                       /* ATD Digital Input Enable on channel 2 */
    word IEN3        :1;                                       /* ATD Digital Input Enable on channel 3 */
    word IEN4        :1;                                       /* ATD Digital Input Enable on channel 4 */
    word IEN5        :1;                                       /* ATD Digital Input Enable on channel 5 */
    word IEN6        :1;                                       /* ATD Digital Input Enable on channel 6 */
    word IEN7        :1;                                       /* ATD Digital Input Enable on channel 7 */
    word IEN8        :1;                                       /* ATD Digital Input Enable on channel 8 */
    word IEN9        :1;                                       /* ATD Digital Input Enable on channel 9 */
    word IEN10       :1;                                       /* ATD Digital Input Enable on channel 10 */
    word IEN11       :1;                                       /* ATD Digital Input Enable on channel 11 */
    word IEN12       :1;                                       /* ATD Digital Input Enable on channel 12 */
    word IEN13       :1;                                       /* ATD Digital Input Enable on channel 13 */
    word IEN14       :1;                                       /* ATD Digital Input Enable on channel 14 */
    word IEN15       :1;                                       /* ATD Digital Input Enable on channel 15 */
  } Bits;
} ATDDIENSTR;
extern volatile ATDDIENSTR _ATDDIEN @(REG_BASE + 0x0000008C);
#define ATDDIEN                         _ATDDIEN.Word
#define ATDDIEN_IEN0                    _ATDDIEN.Bits.IEN0
#define ATDDIEN_IEN1                    _ATDDIEN.Bits.IEN1
#define ATDDIEN_IEN2                    _ATDDIEN.Bits.IEN2
#define ATDDIEN_IEN3                    _ATDDIEN.Bits.IEN3
#define ATDDIEN_IEN4                    _ATDDIEN.Bits.IEN4
#define ATDDIEN_IEN5                    _ATDDIEN.Bits.IEN5
#define ATDDIEN_IEN6                    _ATDDIEN.Bits.IEN6
#define ATDDIEN_IEN7                    _ATDDIEN.Bits.IEN7
#define ATDDIEN_IEN8                    _ATDDIEN.Bits.IEN8
#define ATDDIEN_IEN9                    _ATDDIEN.Bits.IEN9
#define ATDDIEN_IEN10                   _ATDDIEN.Bits.IEN10
#define ATDDIEN_IEN11                   _ATDDIEN.Bits.IEN11
#define ATDDIEN_IEN12                   _ATDDIEN.Bits.IEN12
#define ATDDIEN_IEN13                   _ATDDIEN.Bits.IEN13
#define ATDDIEN_IEN14                   _ATDDIEN.Bits.IEN14
#define ATDDIEN_IEN15                   _ATDDIEN.Bits.IEN15

#define ATDDIEN_IEN0_MASK               1
#define ATDDIEN_IEN1_MASK               2
#define ATDDIEN_IEN2_MASK               4
#define ATDDIEN_IEN3_MASK               8
#define ATDDIEN_IEN4_MASK               16
#define ATDDIEN_IEN5_MASK               32
#define ATDDIEN_IEN6_MASK               64
#define ATDDIEN_IEN7_MASK               128
#define ATDDIEN_IEN8_MASK               256
#define ATDDIEN_IEN9_MASK               512
#define ATDDIEN_IEN10_MASK              1024
#define ATDDIEN_IEN11_MASK              2048
#define ATDDIEN_IEN12_MASK              4096
#define ATDDIEN_IEN13_MASK              8192
#define ATDDIEN_IEN14_MASK              16384
#define ATDDIEN_IEN15_MASK              32768


/*** PORTAD - Port AD0 Data; 0x0000008E ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** PORTAD0 - Port AD0 Data Register; 0x0000008E ***/
    union {
      byte Byte;
      struct {
        byte PTAD8       :1;                                       /* A/D Channel 8 (AN8) Digital Input */
        byte PTAD9       :1;                                       /* A/D Channel 9 (AN9) Digital Input */
        byte PTAD10      :1;                                       /* A/D Channel 10 (AN10) Digital Input */
        byte PTAD11      :1;                                       /* A/D Channel 11 (AN11) Digital Input */
        byte PTAD12      :1;                                       /* A/D Channel 12 (AN12) Digital Input */
        byte PTAD13      :1;                                       /* A/D Channel 13 (AN13) Digital Input */
        byte PTAD14      :1;                                       /* A/D Channel 14 (AN14) Digital Input */
        byte PTAD15      :1;                                       /* A/D Channel 15 (AN15) Digital Input */
      } Bits;
    } PORTAD0STR;
    #define PORTAD0                     _PORTAD.Overlap_STR.PORTAD0STR.Byte
    #define PORTAD0_PTAD8               _PORTAD.Overlap_STR.PORTAD0STR.Bits.PTAD8
    #define PORTAD0_PTAD9               _PORTAD.Overlap_STR.PORTAD0STR.Bits.PTAD9
    #define PORTAD0_PTAD10              _PORTAD.Overlap_STR.PORTAD0STR.Bits.PTAD10
    #define PORTAD0_PTAD11              _PORTAD.Overlap_STR.PORTAD0STR.Bits.PTAD11
    #define PORTAD0_PTAD12              _PORTAD.Overlap_STR.PORTAD0STR.Bits.PTAD12
    #define PORTAD0_PTAD13              _PORTAD.Overlap_STR.PORTAD0STR.Bits.PTAD13
    #define PORTAD0_PTAD14              _PORTAD.Overlap_STR.PORTAD0STR.Bits.PTAD14
    #define PORTAD0_PTAD15              _PORTAD.Overlap_STR.PORTAD0STR.Bits.PTAD15
    
    /* PORTAD_ARR: Access 2 PORTADx registers in a array */
    #define PORTAD_ARR                  ((Byte *) &PORTAD0)
    
    #define PORTAD0_PTAD8_MASK          1
    #define PORTAD0_PTAD9_MASK          2
    #define PORTAD0_PTAD10_MASK         4
    #define PORTAD0_PTAD11_MASK         8
    #define PORTAD0_PTAD12_MASK         16
    #define PORTAD0_PTAD13_MASK         32
    #define PORTAD0_PTAD14_MASK         64
    #define PORTAD0_PTAD15_MASK         128


    /*** PORTAD1 - Port AD1 Data Register; 0x0000008F ***/
    union {
      byte Byte;
      struct {
        byte PTAD0       :1;                                       /* A/D Channel 0 (AN0) Digital Input */
        byte PTAD1       :1;                                       /* A/D Channel 1 (AN1) Digital Input */
        byte PTAD2       :1;                                       /* A/D Channel 2 (AN2) Digital Input */
        byte PTAD3       :1;                                       /* A/D Channel 3 (AN3) Digital Input */
        byte PTAD4       :1;                                       /* A/D Channel 4 (AN4) Digital Input */
        byte PTAD5       :1;                                       /* A/D Channel 5 (AN5) Digital Input */
        byte PTAD6       :1;                                       /* A/D Channel 6 (AN6) Digital Input */
        byte PTAD7       :1;                                       /* A/D Channel 7 (AN7) Digital Input */
      } Bits;
    } PORTAD1STR;
    #define PORTAD1                     _PORTAD.Overlap_STR.PORTAD1STR.Byte
    #define PORTAD1_PTAD0               _PORTAD.Overlap_STR.PORTAD1STR.Bits.PTAD0
    #define PORTAD1_PTAD1               _PORTAD.Overlap_STR.PORTAD1STR.Bits.PTAD1
    #define PORTAD1_PTAD2               _PORTAD.Overlap_STR.PORTAD1STR.Bits.PTAD2
    #define PORTAD1_PTAD3               _PORTAD.Overlap_STR.PORTAD1STR.Bits.PTAD3
    #define PORTAD1_PTAD4               _PORTAD.Overlap_STR.PORTAD1STR.Bits.PTAD4
    #define PORTAD1_PTAD5               _PORTAD.Overlap_STR.PORTAD1STR.Bits.PTAD5
    #define PORTAD1_PTAD6               _PORTAD.Overlap_STR.PORTAD1STR.Bits.PTAD6
    #define PORTAD1_PTAD7               _PORTAD.Overlap_STR.PORTAD1STR.Bits.PTAD7
    
    
    #define PORTAD1_PTAD0_MASK          1
    #define PORTAD1_PTAD1_MASK          2
    #define PORTAD1_PTAD2_MASK          4
    #define PORTAD1_PTAD3_MASK          8
    #define PORTAD1_PTAD4_MASK          16
    #define PORTAD1_PTAD5_MASK          32
    #define PORTAD1_PTAD6_MASK          64
    #define PORTAD1_PTAD7_MASK          128

  } Overlap_STR;

  struct {
    word PTAD0       :1;                                       /* A/D Channel 0 (AN0) Digital Input */
    word PTAD1       :1;                                       /* A/D Channel 1 (AN1) Digital Input */
    word PTAD2       :1;                                       /* A/D Channel 2 (AN2) Digital Input */
    word PTAD3       :1;                                       /* A/D Channel 3 (AN3) Digital Input */
    word PTAD4       :1;                                       /* A/D Channel 4 (AN4) Digital Input */
    word PTAD5       :1;                                       /* A/D Channel 5 (AN5) Digital Input */
    word PTAD6       :1;                                       /* A/D Channel 6 (AN6) Digital Input */
    word PTAD7       :1;                                       /* A/D Channel 7 (AN7) Digital Input */
    word PTAD8       :1;                                       /* A/D Channel 8 (AN8) Digital Input */
    word PTAD9       :1;                                       /* A/D Channel 9 (AN9) Digital Input */
    word PTAD10      :1;                                       /* A/D Channel 10 (AN10) Digital Input */
    word PTAD11      :1;                                       /* A/D Channel 11 (AN11) Digital Input */
    word PTAD12      :1;                                       /* A/D Channel 12 (AN12) Digital Input */
    word PTAD13      :1;                                       /* A/D Channel 13 (AN13) Digital Input */
    word PTAD14      :1;                                       /* A/D Channel 14 (AN14) Digital Input */
    word PTAD15      :1;                                       /* A/D Channel 15 (AN15) Digital Input */
  } Bits;
} PORTADSTR;
extern volatile PORTADSTR _PORTAD @(REG_BASE + 0x0000008E);
#define PORTAD                          _PORTAD.Word
#define PORTAD_PTAD0                    _PORTAD.Bits.PTAD0
#define PORTAD_PTAD1                    _PORTAD.Bits.PTAD1
#define PORTAD_PTAD2                    _PORTAD.Bits.PTAD2
#define PORTAD_PTAD3                    _PORTAD.Bits.PTAD3
#define PORTAD_PTAD4                    _PORTAD.Bits.PTAD4
#define PORTAD_PTAD5                    _PORTAD.Bits.PTAD5
#define PORTAD_PTAD6                    _PORTAD.Bits.PTAD6
#define PORTAD_PTAD7                    _PORTAD.Bits.PTAD7
#define PORTAD_PTAD8                    _PORTAD.Bits.PTAD8
#define PORTAD_PTAD9                    _PORTAD.Bits.PTAD9
#define PORTAD_PTAD10                   _PORTAD.Bits.PTAD10
#define PORTAD_PTAD11                   _PORTAD.Bits.PTAD11
#define PORTAD_PTAD12                   _PORTAD.Bits.PTAD12
#define PORTAD_PTAD13                   _PORTAD.Bits.PTAD13
#define PORTAD_PTAD14                   _PORTAD.Bits.PTAD14
#define PORTAD_PTAD15                   _PORTAD.Bits.PTAD15

#define PORTAD_PTAD0_MASK               1
#define PORTAD_PTAD1_MASK               2
#define PORTAD_PTAD2_MASK               4
#define PORTAD_PTAD3_MASK               8
#define PORTAD_PTAD4_MASK               16
#define PORTAD_PTAD5_MASK               32
#define PORTAD_PTAD6_MASK               64
#define PORTAD_PTAD7_MASK               128
#define PORTAD_PTAD8_MASK               256
#define PORTAD_PTAD9_MASK               512
#define PORTAD_PTAD10_MASK              1024
#define PORTAD_PTAD11_MASK              2048
#define PORTAD_PTAD12_MASK              4096
#define PORTAD_PTAD13_MASK              8192
#define PORTAD_PTAD14_MASK              16384
#define PORTAD_PTAD15_MASK              32768


/*** ATDDR0 - ATD Conversion Result Register 0; 0x00000090 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATDDR0H - ATD Conversion Result Register 0 High; 0x00000090 ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Bit 8 */
        byte BIT9        :1;                                       /* Bit 9 */
        byte BIT10       :1;                                       /* Bit 10 */
        byte BIT11       :1;                                       /* Bit 11 */
        byte BIT12       :1;                                       /* Bit 12 */
        byte BIT13       :1;                                       /* Bit 13 */
        byte BIT14       :1;                                       /* Bit 14 */
        byte BIT15       :1;                                       /* Bit 15 */
      } Bits;
    } ATDDR0HSTR;
    #define ATDDR0H                     _ATDDR0.Overlap_STR.ATDDR0HSTR.Byte
    #define ATDDR0H_BIT8                _ATDDR0.Overlap_STR.ATDDR0HSTR.Bits.BIT8
    #define ATDDR0H_BIT9                _ATDDR0.Overlap_STR.ATDDR0HSTR.Bits.BIT9
    #define ATDDR0H_BIT10               _ATDDR0.Overlap_STR.ATDDR0HSTR.Bits.BIT10
    #define ATDDR0H_BIT11               _ATDDR0.Overlap_STR.ATDDR0HSTR.Bits.BIT11
    #define ATDDR0H_BIT12               _ATDDR0.Overlap_STR.ATDDR0HSTR.Bits.BIT12
    #define ATDDR0H_BIT13               _ATDDR0.Overlap_STR.ATDDR0HSTR.Bits.BIT13
    #define ATDDR0H_BIT14               _ATDDR0.Overlap_STR.ATDDR0HSTR.Bits.BIT14
    #define ATDDR0H_BIT15               _ATDDR0.Overlap_STR.ATDDR0HSTR.Bits.BIT15
    
    
    #define ATDDR0H_BIT8_MASK           1
    #define ATDDR0H_BIT9_MASK           2
    #define ATDDR0H_BIT10_MASK          4
    #define ATDDR0H_BIT11_MASK          8
    #define ATDDR0H_BIT12_MASK          16
    #define ATDDR0H_BIT13_MASK          32
    #define ATDDR0H_BIT14_MASK          64
    #define ATDDR0H_BIT15_MASK          128


    /*** ATDDR0L - ATD Conversion Result Register 0 Low; 0x00000091 ***/
    union {
      byte Byte;
      struct {
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte BIT6        :1;                                       /* Bit 6 */
        byte BIT7        :1;                                       /* Bit 7 */
      } Bits;
      struct {
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte grpBIT_6 :2;
      } MergedBits;
    } ATDDR0LSTR;
    #define ATDDR0L                     _ATDDR0.Overlap_STR.ATDDR0LSTR.Byte
    #define ATDDR0L_BIT6                _ATDDR0.Overlap_STR.ATDDR0LSTR.Bits.BIT6
    #define ATDDR0L_BIT7                _ATDDR0.Overlap_STR.ATDDR0LSTR.Bits.BIT7
    
    #define ATDDR0L_BIT_6               _ATDDR0.Overlap_STR.ATDDR0LSTR.MergedBits.grpBIT_6
    #define ATDDR0L_BIT                 ATDDR0L_BIT_6
    
    #define ATDDR0L_BIT6_MASK           64
    #define ATDDR0L_BIT7_MASK           128
    #define ATDDR0L_BIT_6_MASK          %BitsMask
    #define ATDDR0L_BIT_6_BITNUM        %BitsNum

  } Overlap_STR;

  struct {
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word BIT6        :1;                                       /* Bit 6 */
    word BIT7        :1;                                       /* Bit 7 */
    word BIT8        :1;                                       /* Bit 8 */
    word BIT9        :1;                                       /* Bit 9 */
    word BIT10       :1;                                       /* Bit 10 */
    word BIT11       :1;                                       /* Bit 11 */
    word BIT12       :1;                                       /* Bit 12 */
    word BIT13       :1;                                       /* Bit 13 */
    word BIT14       :1;                                       /* Bit 14 */
    word BIT15       :1;                                       /* Bit 15 */
  } Bits;
  struct {
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpBIT_6 :10;
  } MergedBits;
} ATDDR0STR;
extern volatile ATDDR0STR _ATDDR0 @(REG_BASE + 0x00000090);
#define ATDDR0                          _ATDDR0.Word
#define ATDDR0_BIT6                     _ATDDR0.Bits.BIT6
#define ATDDR0_BIT7                     _ATDDR0.Bits.BIT7
#define ATDDR0_BIT8                     _ATDDR0.Bits.BIT8
#define ATDDR0_BIT9                     _ATDDR0.Bits.BIT9
#define ATDDR0_BIT10                    _ATDDR0.Bits.BIT10
#define ATDDR0_BIT11                    _ATDDR0.Bits.BIT11
#define ATDDR0_BIT12                    _ATDDR0.Bits.BIT12
#define ATDDR0_BIT13                    _ATDDR0.Bits.BIT13
#define ATDDR0_BIT14                    _ATDDR0.Bits.BIT14
#define ATDDR0_BIT15                    _ATDDR0.Bits.BIT15
/* ATDDR_ARR: Access 16 ATDDRx registers in a array */
#define ATDDR_ARR                       ((Word *) &ATDDR0)
#define ATDDR0_BIT_6                    _ATDDR0.MergedBits.grpBIT_6
#define ATDDR0_BIT                      ATDDR0_BIT_6

#define ATDDR0_BIT6_MASK                64
#define ATDDR0_BIT7_MASK                128
#define ATDDR0_BIT8_MASK                256
#define ATDDR0_BIT9_MASK                512
#define ATDDR0_BIT10_MASK               1024
#define ATDDR0_BIT11_MASK               2048
#define ATDDR0_BIT12_MASK               4096
#define ATDDR0_BIT13_MASK               8192
#define ATDDR0_BIT14_MASK               16384
#define ATDDR0_BIT15_MASK               32768
#define ATDDR0_BIT_6_MASK               %BitsMask
#define ATDDR0_BIT_6_BITNUM             %BitsNum


/*** ATDDR1 - ATD Conversion Result Register 1; 0x00000092 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATDDR1H - ATD Conversion Result Register 1 High; 0x00000092 ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Bit 8 */
        byte BIT9        :1;                                       /* Bit 9 */
        byte BIT10       :1;                                       /* Bit 10 */
        byte BIT11       :1;                                       /* Bit 11 */
        byte BIT12       :1;                                       /* Bit 12 */
        byte BIT13       :1;                                       /* Bit 13 */
        byte BIT14       :1;                                       /* Bit 14 */
        byte BIT15       :1;                                       /* Bit 15 */
      } Bits;
    } ATDDR1HSTR;
    #define ATDDR1H                     _ATDDR1.Overlap_STR.ATDDR1HSTR.Byte
    #define ATDDR1H_BIT8                _ATDDR1.Overlap_STR.ATDDR1HSTR.Bits.BIT8
    #define ATDDR1H_BIT9                _ATDDR1.Overlap_STR.ATDDR1HSTR.Bits.BIT9
    #define ATDDR1H_BIT10               _ATDDR1.Overlap_STR.ATDDR1HSTR.Bits.BIT10
    #define ATDDR1H_BIT11               _ATDDR1.Overlap_STR.ATDDR1HSTR.Bits.BIT11
    #define ATDDR1H_BIT12               _ATDDR1.Overlap_STR.ATDDR1HSTR.Bits.BIT12
    #define ATDDR1H_BIT13               _ATDDR1.Overlap_STR.ATDDR1HSTR.Bits.BIT13
    #define ATDDR1H_BIT14               _ATDDR1.Overlap_STR.ATDDR1HSTR.Bits.BIT14
    #define ATDDR1H_BIT15               _ATDDR1.Overlap_STR.ATDDR1HSTR.Bits.BIT15
    
    
    #define ATDDR1H_BIT8_MASK           1
    #define ATDDR1H_BIT9_MASK           2
    #define ATDDR1H_BIT10_MASK          4
    #define ATDDR1H_BIT11_MASK          8
    #define ATDDR1H_BIT12_MASK          16
    #define ATDDR1H_BIT13_MASK          32
    #define ATDDR1H_BIT14_MASK          64
    #define ATDDR1H_BIT15_MASK          128


    /*** ATDDR1L - ATD Conversion Result Register 1 Low; 0x00000093 ***/
    union {
      byte Byte;
      struct {
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte BIT6        :1;                                       /* Bit 6 */
        byte BIT7        :1;                                       /* Bit 7 */
      } Bits;
      struct {
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte grpBIT_6 :2;
      } MergedBits;
    } ATDDR1LSTR;
    #define ATDDR1L                     _ATDDR1.Overlap_STR.ATDDR1LSTR.Byte
    #define ATDDR1L_BIT6                _ATDDR1.Overlap_STR.ATDDR1LSTR.Bits.BIT6
    #define ATDDR1L_BIT7                _ATDDR1.Overlap_STR.ATDDR1LSTR.Bits.BIT7
    
    #define ATDDR1L_BIT_6               _ATDDR1.Overlap_STR.ATDDR1LSTR.MergedBits.grpBIT_6
    #define ATDDR1L_BIT                 ATDDR1L_BIT_6
    
    #define ATDDR1L_BIT6_MASK           64
    #define ATDDR1L_BIT7_MASK           128
    #define ATDDR1L_BIT_6_MASK          %BitsMask
    #define ATDDR1L_BIT_6_BITNUM        %BitsNum

  } Overlap_STR;

  struct {
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word BIT6        :1;                                       /* Bit 6 */
    word BIT7        :1;                                       /* Bit 7 */
    word BIT8        :1;                                       /* Bit 8 */
    word BIT9        :1;                                       /* Bit 9 */
    word BIT10       :1;                                       /* Bit 10 */
    word BIT11       :1;                                       /* Bit 11 */
    word BIT12       :1;                                       /* Bit 12 */
    word BIT13       :1;                                       /* Bit 13 */
    word BIT14       :1;                                       /* Bit 14 */
    word BIT15       :1;                                       /* Bit 15 */
  } Bits;
  struct {
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpBIT_6 :10;
  } MergedBits;
} ATDDR1STR;
extern volatile ATDDR1STR _ATDDR1 @(REG_BASE + 0x00000092);
#define ATDDR1                          _ATDDR1.Word
#define ATDDR1_BIT6                     _ATDDR1.Bits.BIT6
#define ATDDR1_BIT7                     _ATDDR1.Bits.BIT7
#define ATDDR1_BIT8                     _ATDDR1.Bits.BIT8
#define ATDDR1_BIT9                     _ATDDR1.Bits.BIT9
#define ATDDR1_BIT10                    _ATDDR1.Bits.BIT10
#define ATDDR1_BIT11                    _ATDDR1.Bits.BIT11
#define ATDDR1_BIT12                    _ATDDR1.Bits.BIT12
#define ATDDR1_BIT13                    _ATDDR1.Bits.BIT13
#define ATDDR1_BIT14                    _ATDDR1.Bits.BIT14
#define ATDDR1_BIT15                    _ATDDR1.Bits.BIT15
#define ATDDR1_BIT_6                    _ATDDR1.MergedBits.grpBIT_6
#define ATDDR1_BIT                      ATDDR1_BIT_6

#define ATDDR1_BIT6_MASK                64
#define ATDDR1_BIT7_MASK                128
#define ATDDR1_BIT8_MASK                256
#define ATDDR1_BIT9_MASK                512
#define ATDDR1_BIT10_MASK               1024
#define ATDDR1_BIT11_MASK               2048
#define ATDDR1_BIT12_MASK               4096
#define ATDDR1_BIT13_MASK               8192
#define ATDDR1_BIT14_MASK               16384
#define ATDDR1_BIT15_MASK               32768
#define ATDDR1_BIT_6_MASK               %BitsMask
#define ATDDR1_BIT_6_BITNUM             %BitsNum


/*** ATDDR2 - ATD Conversion Result Register 2; 0x00000094 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATDDR2H - ATD Conversion Result Register 2 High; 0x00000094 ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Bit 8 */
        byte BIT9        :1;                                       /* Bit 9 */
        byte BIT10       :1;                                       /* Bit 10 */
        byte BIT11       :1;                                       /* Bit 11 */
        byte BIT12       :1;                                       /* Bit 12 */
        byte BIT13       :1;                                       /* Bit 13 */
        byte BIT14       :1;                                       /* Bit 14 */
        byte BIT15       :1;                                       /* Bit 15 */
      } Bits;
    } ATDDR2HSTR;
    #define ATDDR2H                     _ATDDR2.Overlap_STR.ATDDR2HSTR.Byte
    #define ATDDR2H_BIT8                _ATDDR2.Overlap_STR.ATDDR2HSTR.Bits.BIT8
    #define ATDDR2H_BIT9                _ATDDR2.Overlap_STR.ATDDR2HSTR.Bits.BIT9
    #define ATDDR2H_BIT10               _ATDDR2.Overlap_STR.ATDDR2HSTR.Bits.BIT10
    #define ATDDR2H_BIT11               _ATDDR2.Overlap_STR.ATDDR2HSTR.Bits.BIT11
    #define ATDDR2H_BIT12               _ATDDR2.Overlap_STR.ATDDR2HSTR.Bits.BIT12
    #define ATDDR2H_BIT13               _ATDDR2.Overlap_STR.ATDDR2HSTR.Bits.BIT13
    #define ATDDR2H_BIT14               _ATDDR2.Overlap_STR.ATDDR2HSTR.Bits.BIT14
    #define ATDDR2H_BIT15               _ATDDR2.Overlap_STR.ATDDR2HSTR.Bits.BIT15
    
    
    #define ATDDR2H_BIT8_MASK           1
    #define ATDDR2H_BIT9_MASK           2
    #define ATDDR2H_BIT10_MASK          4
    #define ATDDR2H_BIT11_MASK          8
    #define ATDDR2H_BIT12_MASK          16
    #define ATDDR2H_BIT13_MASK          32
    #define ATDDR2H_BIT14_MASK          64
    #define ATDDR2H_BIT15_MASK          128


    /*** ATDDR2L - ATD Conversion Result Register 2 Low; 0x00000095 ***/
    union {
      byte Byte;
      struct {
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte BIT6        :1;                                       /* Bit 6 */
        byte BIT7        :1;                                       /* Bit 7 */
      } Bits;
      struct {
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte grpBIT_6 :2;
      } MergedBits;
    } ATDDR2LSTR;
    #define ATDDR2L                     _ATDDR2.Overlap_STR.ATDDR2LSTR.Byte
    #define ATDDR2L_BIT6                _ATDDR2.Overlap_STR.ATDDR2LSTR.Bits.BIT6
    #define ATDDR2L_BIT7                _ATDDR2.Overlap_STR.ATDDR2LSTR.Bits.BIT7
    
    #define ATDDR2L_BIT_6               _ATDDR2.Overlap_STR.ATDDR2LSTR.MergedBits.grpBIT_6
    #define ATDDR2L_BIT                 ATDDR2L_BIT_6
    
    #define ATDDR2L_BIT6_MASK           64
    #define ATDDR2L_BIT7_MASK           128
    #define ATDDR2L_BIT_6_MASK          %BitsMask
    #define ATDDR2L_BIT_6_BITNUM        %BitsNum

  } Overlap_STR;

  struct {
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word BIT6        :1;                                       /* Bit 6 */
    word BIT7        :1;                                       /* Bit 7 */
    word BIT8        :1;                                       /* Bit 8 */
    word BIT9        :1;                                       /* Bit 9 */
    word BIT10       :1;                                       /* Bit 10 */
    word BIT11       :1;                                       /* Bit 11 */
    word BIT12       :1;                                       /* Bit 12 */
    word BIT13       :1;                                       /* Bit 13 */
    word BIT14       :1;                                       /* Bit 14 */
    word BIT15       :1;                                       /* Bit 15 */
  } Bits;
  struct {
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpBIT_6 :10;
  } MergedBits;
} ATDDR2STR;
extern volatile ATDDR2STR _ATDDR2 @(REG_BASE + 0x00000094);
#define ATDDR2                          _ATDDR2.Word
#define ATDDR2_BIT6                     _ATDDR2.Bits.BIT6
#define ATDDR2_BIT7                     _ATDDR2.Bits.BIT7
#define ATDDR2_BIT8                     _ATDDR2.Bits.BIT8
#define ATDDR2_BIT9                     _ATDDR2.Bits.BIT9
#define ATDDR2_BIT10                    _ATDDR2.Bits.BIT10
#define ATDDR2_BIT11                    _ATDDR2.Bits.BIT11
#define ATDDR2_BIT12                    _ATDDR2.Bits.BIT12
#define ATDDR2_BIT13                    _ATDDR2.Bits.BIT13
#define ATDDR2_BIT14                    _ATDDR2.Bits.BIT14
#define ATDDR2_BIT15                    _ATDDR2.Bits.BIT15
#define ATDDR2_BIT_6                    _ATDDR2.MergedBits.grpBIT_6
#define ATDDR2_BIT                      ATDDR2_BIT_6

#define ATDDR2_BIT6_MASK                64
#define ATDDR2_BIT7_MASK                128
#define ATDDR2_BIT8_MASK                256
#define ATDDR2_BIT9_MASK                512
#define ATDDR2_BIT10_MASK               1024
#define ATDDR2_BIT11_MASK               2048
#define ATDDR2_BIT12_MASK               4096
#define ATDDR2_BIT13_MASK               8192
#define ATDDR2_BIT14_MASK               16384
#define ATDDR2_BIT15_MASK               32768
#define ATDDR2_BIT_6_MASK               %BitsMask
#define ATDDR2_BIT_6_BITNUM             %BitsNum


/*** ATDDR3 - ATD Conversion Result Register 3; 0x00000096 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATDDR3H - ATD Conversion Result Register 3 High; 0x00000096 ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Bit 8 */
        byte BIT9        :1;                                       /* Bit 9 */
        byte BIT10       :1;                                       /* Bit 10 */
        byte BIT11       :1;                                       /* Bit 11 */
        byte BIT12       :1;                                       /* Bit 12 */
        byte BIT13       :1;                                       /* Bit 13 */
        byte BIT14       :1;                                       /* Bit 14 */
        byte BIT15       :1;                                       /* Bit 15 */
      } Bits;
    } ATDDR3HSTR;
    #define ATDDR3H                     _ATDDR3.Overlap_STR.ATDDR3HSTR.Byte
    #define ATDDR3H_BIT8                _ATDDR3.Overlap_STR.ATDDR3HSTR.Bits.BIT8
    #define ATDDR3H_BIT9                _ATDDR3.Overlap_STR.ATDDR3HSTR.Bits.BIT9
    #define ATDDR3H_BIT10               _ATDDR3.Overlap_STR.ATDDR3HSTR.Bits.BIT10
    #define ATDDR3H_BIT11               _ATDDR3.Overlap_STR.ATDDR3HSTR.Bits.BIT11
    #define ATDDR3H_BIT12               _ATDDR3.Overlap_STR.ATDDR3HSTR.Bits.BIT12
    #define ATDDR3H_BIT13               _ATDDR3.Overlap_STR.ATDDR3HSTR.Bits.BIT13
    #define ATDDR3H_BIT14               _ATDDR3.Overlap_STR.ATDDR3HSTR.Bits.BIT14
    #define ATDDR3H_BIT15               _ATDDR3.Overlap_STR.ATDDR3HSTR.Bits.BIT15
    
    
    #define ATDDR3H_BIT8_MASK           1
    #define ATDDR3H_BIT9_MASK           2
    #define ATDDR3H_BIT10_MASK          4
    #define ATDDR3H_BIT11_MASK          8
    #define ATDDR3H_BIT12_MASK          16
    #define ATDDR3H_BIT13_MASK          32
    #define ATDDR3H_BIT14_MASK          64
    #define ATDDR3H_BIT15_MASK          128


    /*** ATDDR3L - ATD Conversion Result Register 3 Low; 0x00000097 ***/
    union {
      byte Byte;
      struct {
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte BIT6        :1;                                       /* Bit 6 */
        byte BIT7        :1;                                       /* Bit 7 */
      } Bits;
      struct {
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte grpBIT_6 :2;
      } MergedBits;
    } ATDDR3LSTR;
    #define ATDDR3L                     _ATDDR3.Overlap_STR.ATDDR3LSTR.Byte
    #define ATDDR3L_BIT6                _ATDDR3.Overlap_STR.ATDDR3LSTR.Bits.BIT6
    #define ATDDR3L_BIT7                _ATDDR3.Overlap_STR.ATDDR3LSTR.Bits.BIT7
    
    #define ATDDR3L_BIT_6               _ATDDR3.Overlap_STR.ATDDR3LSTR.MergedBits.grpBIT_6
    #define ATDDR3L_BIT                 ATDDR3L_BIT_6
    
    #define ATDDR3L_BIT6_MASK           64
    #define ATDDR3L_BIT7_MASK           128
    #define ATDDR3L_BIT_6_MASK          %BitsMask
    #define ATDDR3L_BIT_6_BITNUM        %BitsNum

  } Overlap_STR;

  struct {
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word BIT6        :1;                                       /* Bit 6 */
    word BIT7        :1;                                       /* Bit 7 */
    word BIT8        :1;                                       /* Bit 8 */
    word BIT9        :1;                                       /* Bit 9 */
    word BIT10       :1;                                       /* Bit 10 */
    word BIT11       :1;                                       /* Bit 11 */
    word BIT12       :1;                                       /* Bit 12 */
    word BIT13       :1;                                       /* Bit 13 */
    word BIT14       :1;                                       /* Bit 14 */
    word BIT15       :1;                                       /* Bit 15 */
  } Bits;
  struct {
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpBIT_6 :10;
  } MergedBits;
} ATDDR3STR;
extern volatile ATDDR3STR _ATDDR3 @(REG_BASE + 0x00000096);
#define ATDDR3                          _ATDDR3.Word
#define ATDDR3_BIT6                     _ATDDR3.Bits.BIT6
#define ATDDR3_BIT7                     _ATDDR3.Bits.BIT7
#define ATDDR3_BIT8                     _ATDDR3.Bits.BIT8
#define ATDDR3_BIT9                     _ATDDR3.Bits.BIT9
#define ATDDR3_BIT10                    _ATDDR3.Bits.BIT10
#define ATDDR3_BIT11                    _ATDDR3.Bits.BIT11
#define ATDDR3_BIT12                    _ATDDR3.Bits.BIT12
#define ATDDR3_BIT13                    _ATDDR3.Bits.BIT13
#define ATDDR3_BIT14                    _ATDDR3.Bits.BIT14
#define ATDDR3_BIT15                    _ATDDR3.Bits.BIT15
#define ATDDR3_BIT_6                    _ATDDR3.MergedBits.grpBIT_6
#define ATDDR3_BIT                      ATDDR3_BIT_6

#define ATDDR3_BIT6_MASK                64
#define ATDDR3_BIT7_MASK                128
#define ATDDR3_BIT8_MASK                256
#define ATDDR3_BIT9_MASK                512
#define ATDDR3_BIT10_MASK               1024
#define ATDDR3_BIT11_MASK               2048
#define ATDDR3_BIT12_MASK               4096
#define ATDDR3_BIT13_MASK               8192
#define ATDDR3_BIT14_MASK               16384
#define ATDDR3_BIT15_MASK               32768
#define ATDDR3_BIT_6_MASK               %BitsMask
#define ATDDR3_BIT_6_BITNUM             %BitsNum


/*** ATDDR4 - ATD Conversion Result Register 4; 0x00000098 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATDDR4H - ATD Conversion Result Register 4 High; 0x00000098 ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Bit 8 */
        byte BIT9        :1;                                       /* Bit 9 */
        byte BIT10       :1;                                       /* Bit 10 */
        byte BIT11       :1;                                       /* Bit 11 */
        byte BIT12       :1;                                       /* Bit 12 */
        byte BIT13       :1;                                       /* Bit 13 */
        byte BIT14       :1;                                       /* Bit 14 */
        byte BIT15       :1;                                       /* Bit 15 */
      } Bits;
    } ATDDR4HSTR;
    #define ATDDR4H                     _ATDDR4.Overlap_STR.ATDDR4HSTR.Byte
    #define ATDDR4H_BIT8                _ATDDR4.Overlap_STR.ATDDR4HSTR.Bits.BIT8
    #define ATDDR4H_BIT9                _ATDDR4.Overlap_STR.ATDDR4HSTR.Bits.BIT9
    #define ATDDR4H_BIT10               _ATDDR4.Overlap_STR.ATDDR4HSTR.Bits.BIT10
    #define ATDDR4H_BIT11               _ATDDR4.Overlap_STR.ATDDR4HSTR.Bits.BIT11
    #define ATDDR4H_BIT12               _ATDDR4.Overlap_STR.ATDDR4HSTR.Bits.BIT12
    #define ATDDR4H_BIT13               _ATDDR4.Overlap_STR.ATDDR4HSTR.Bits.BIT13
    #define ATDDR4H_BIT14               _ATDDR4.Overlap_STR.ATDDR4HSTR.Bits.BIT14
    #define ATDDR4H_BIT15               _ATDDR4.Overlap_STR.ATDDR4HSTR.Bits.BIT15
    
    
    #define ATDDR4H_BIT8_MASK           1
    #define ATDDR4H_BIT9_MASK           2
    #define ATDDR4H_BIT10_MASK          4
    #define ATDDR4H_BIT11_MASK          8
    #define ATDDR4H_BIT12_MASK          16
    #define ATDDR4H_BIT13_MASK          32
    #define ATDDR4H_BIT14_MASK          64
    #define ATDDR4H_BIT15_MASK          128


    /*** ATDDR4L - ATD Conversion Result Register 4 Low; 0x00000099 ***/
    union {
      byte Byte;
      struct {
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte BIT6        :1;                                       /* Bit 6 */
        byte BIT7        :1;                                       /* Bit 7 */
      } Bits;
      struct {
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte grpBIT_6 :2;
      } MergedBits;
    } ATDDR4LSTR;
    #define ATDDR4L                     _ATDDR4.Overlap_STR.ATDDR4LSTR.Byte
    #define ATDDR4L_BIT6                _ATDDR4.Overlap_STR.ATDDR4LSTR.Bits.BIT6
    #define ATDDR4L_BIT7                _ATDDR4.Overlap_STR.ATDDR4LSTR.Bits.BIT7
    
    #define ATDDR4L_BIT_6               _ATDDR4.Overlap_STR.ATDDR4LSTR.MergedBits.grpBIT_6
    #define ATDDR4L_BIT                 ATDDR4L_BIT_6
    
    #define ATDDR4L_BIT6_MASK           64
    #define ATDDR4L_BIT7_MASK           128
    #define ATDDR4L_BIT_6_MASK          %BitsMask
    #define ATDDR4L_BIT_6_BITNUM        %BitsNum

  } Overlap_STR;

  struct {
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word BIT6        :1;                                       /* Bit 6 */
    word BIT7        :1;                                       /* Bit 7 */
    word BIT8        :1;                                       /* Bit 8 */
    word BIT9        :1;                                       /* Bit 9 */
    word BIT10       :1;                                       /* Bit 10 */
    word BIT11       :1;                                       /* Bit 11 */
    word BIT12       :1;                                       /* Bit 12 */
    word BIT13       :1;                                       /* Bit 13 */
    word BIT14       :1;                                       /* Bit 14 */
    word BIT15       :1;                                       /* Bit 15 */
  } Bits;
  struct {
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpBIT_6 :10;
  } MergedBits;
} ATDDR4STR;
extern volatile ATDDR4STR _ATDDR4 @(REG_BASE + 0x00000098);
#define ATDDR4                          _ATDDR4.Word
#define ATDDR4_BIT6                     _ATDDR4.Bits.BIT6
#define ATDDR4_BIT7                     _ATDDR4.Bits.BIT7
#define ATDDR4_BIT8                     _ATDDR4.Bits.BIT8
#define ATDDR4_BIT9                     _ATDDR4.Bits.BIT9
#define ATDDR4_BIT10                    _ATDDR4.Bits.BIT10
#define ATDDR4_BIT11                    _ATDDR4.Bits.BIT11
#define ATDDR4_BIT12                    _ATDDR4.Bits.BIT12
#define ATDDR4_BIT13                    _ATDDR4.Bits.BIT13
#define ATDDR4_BIT14                    _ATDDR4.Bits.BIT14
#define ATDDR4_BIT15                    _ATDDR4.Bits.BIT15
#define ATDDR4_BIT_6                    _ATDDR4.MergedBits.grpBIT_6
#define ATDDR4_BIT                      ATDDR4_BIT_6

#define ATDDR4_BIT6_MASK                64
#define ATDDR4_BIT7_MASK                128
#define ATDDR4_BIT8_MASK                256
#define ATDDR4_BIT9_MASK                512
#define ATDDR4_BIT10_MASK               1024
#define ATDDR4_BIT11_MASK               2048
#define ATDDR4_BIT12_MASK               4096
#define ATDDR4_BIT13_MASK               8192
#define ATDDR4_BIT14_MASK               16384
#define ATDDR4_BIT15_MASK               32768
#define ATDDR4_BIT_6_MASK               %BitsMask
#define ATDDR4_BIT_6_BITNUM             %BitsNum


/*** ATDDR5 - ATD Conversion Result Register 5; 0x0000009A ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATDDR5H - ATD Conversion Result Register 5 High; 0x0000009A ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Bit 8 */
        byte BIT9        :1;                                       /* Bit 9 */
        byte BIT10       :1;                                       /* Bit 10 */
        byte BIT11       :1;                                       /* Bit 11 */
        byte BIT12       :1;                                       /* Bit 12 */
        byte BIT13       :1;                                       /* Bit 13 */
        byte BIT14       :1;                                       /* Bit 14 */
        byte BIT15       :1;                                       /* Bit 15 */
      } Bits;
    } ATDDR5HSTR;
    #define ATDDR5H                     _ATDDR5.Overlap_STR.ATDDR5HSTR.Byte
    #define ATDDR5H_BIT8                _ATDDR5.Overlap_STR.ATDDR5HSTR.Bits.BIT8
    #define ATDDR5H_BIT9                _ATDDR5.Overlap_STR.ATDDR5HSTR.Bits.BIT9
    #define ATDDR5H_BIT10               _ATDDR5.Overlap_STR.ATDDR5HSTR.Bits.BIT10
    #define ATDDR5H_BIT11               _ATDDR5.Overlap_STR.ATDDR5HSTR.Bits.BIT11
    #define ATDDR5H_BIT12               _ATDDR5.Overlap_STR.ATDDR5HSTR.Bits.BIT12
    #define ATDDR5H_BIT13               _ATDDR5.Overlap_STR.ATDDR5HSTR.Bits.BIT13
    #define ATDDR5H_BIT14               _ATDDR5.Overlap_STR.ATDDR5HSTR.Bits.BIT14
    #define ATDDR5H_BIT15               _ATDDR5.Overlap_STR.ATDDR5HSTR.Bits.BIT15
    
    
    #define ATDDR5H_BIT8_MASK           1
    #define ATDDR5H_BIT9_MASK           2
    #define ATDDR5H_BIT10_MASK          4
    #define ATDDR5H_BIT11_MASK          8
    #define ATDDR5H_BIT12_MASK          16
    #define ATDDR5H_BIT13_MASK          32
    #define ATDDR5H_BIT14_MASK          64
    #define ATDDR5H_BIT15_MASK          128


    /*** ATDDR5L - ATD Conversion Result Register 5 Low; 0x0000009B ***/
    union {
      byte Byte;
      struct {
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte BIT6        :1;                                       /* Bit 6 */
        byte BIT7        :1;                                       /* Bit 7 */
      } Bits;
      struct {
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte grpBIT_6 :2;
      } MergedBits;
    } ATDDR5LSTR;
    #define ATDDR5L                     _ATDDR5.Overlap_STR.ATDDR5LSTR.Byte
    #define ATDDR5L_BIT6                _ATDDR5.Overlap_STR.ATDDR5LSTR.Bits.BIT6
    #define ATDDR5L_BIT7                _ATDDR5.Overlap_STR.ATDDR5LSTR.Bits.BIT7
    
    #define ATDDR5L_BIT_6               _ATDDR5.Overlap_STR.ATDDR5LSTR.MergedBits.grpBIT_6
    #define ATDDR5L_BIT                 ATDDR5L_BIT_6
    
    #define ATDDR5L_BIT6_MASK           64
    #define ATDDR5L_BIT7_MASK           128
    #define ATDDR5L_BIT_6_MASK          %BitsMask
    #define ATDDR5L_BIT_6_BITNUM        %BitsNum

  } Overlap_STR;

  struct {
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word BIT6        :1;                                       /* Bit 6 */
    word BIT7        :1;                                       /* Bit 7 */
    word BIT8        :1;                                       /* Bit 8 */
    word BIT9        :1;                                       /* Bit 9 */
    word BIT10       :1;                                       /* Bit 10 */
    word BIT11       :1;                                       /* Bit 11 */
    word BIT12       :1;                                       /* Bit 12 */
    word BIT13       :1;                                       /* Bit 13 */
    word BIT14       :1;                                       /* Bit 14 */
    word BIT15       :1;                                       /* Bit 15 */
  } Bits;
  struct {
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpBIT_6 :10;
  } MergedBits;
} ATDDR5STR;
extern volatile ATDDR5STR _ATDDR5 @(REG_BASE + 0x0000009A);
#define ATDDR5                          _ATDDR5.Word
#define ATDDR5_BIT6                     _ATDDR5.Bits.BIT6
#define ATDDR5_BIT7                     _ATDDR5.Bits.BIT7
#define ATDDR5_BIT8                     _ATDDR5.Bits.BIT8
#define ATDDR5_BIT9                     _ATDDR5.Bits.BIT9
#define ATDDR5_BIT10                    _ATDDR5.Bits.BIT10
#define ATDDR5_BIT11                    _ATDDR5.Bits.BIT11
#define ATDDR5_BIT12                    _ATDDR5.Bits.BIT12
#define ATDDR5_BIT13                    _ATDDR5.Bits.BIT13
#define ATDDR5_BIT14                    _ATDDR5.Bits.BIT14
#define ATDDR5_BIT15                    _ATDDR5.Bits.BIT15
#define ATDDR5_BIT_6                    _ATDDR5.MergedBits.grpBIT_6
#define ATDDR5_BIT                      ATDDR5_BIT_6

#define ATDDR5_BIT6_MASK                64
#define ATDDR5_BIT7_MASK                128
#define ATDDR5_BIT8_MASK                256
#define ATDDR5_BIT9_MASK                512
#define ATDDR5_BIT10_MASK               1024
#define ATDDR5_BIT11_MASK               2048
#define ATDDR5_BIT12_MASK               4096
#define ATDDR5_BIT13_MASK               8192
#define ATDDR5_BIT14_MASK               16384
#define ATDDR5_BIT15_MASK               32768
#define ATDDR5_BIT_6_MASK               %BitsMask
#define ATDDR5_BIT_6_BITNUM             %BitsNum


/*** ATDDR6 - ATD Conversion Result Register 6; 0x0000009C ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATDDR6H - ATD Conversion Result Register 6 High; 0x0000009C ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Bit 8 */
        byte BIT9        :1;                                       /* Bit 9 */
        byte BIT10       :1;                                       /* Bit 10 */
        byte BIT11       :1;                                       /* Bit 11 */
        byte BIT12       :1;                                       /* Bit 12 */
        byte BIT13       :1;                                       /* Bit 13 */
        byte BIT14       :1;                                       /* Bit 14 */
        byte BIT15       :1;                                       /* Bit 15 */
      } Bits;
    } ATDDR6HSTR;
    #define ATDDR6H                     _ATDDR6.Overlap_STR.ATDDR6HSTR.Byte
    #define ATDDR6H_BIT8                _ATDDR6.Overlap_STR.ATDDR6HSTR.Bits.BIT8
    #define ATDDR6H_BIT9                _ATDDR6.Overlap_STR.ATDDR6HSTR.Bits.BIT9
    #define ATDDR6H_BIT10               _ATDDR6.Overlap_STR.ATDDR6HSTR.Bits.BIT10
    #define ATDDR6H_BIT11               _ATDDR6.Overlap_STR.ATDDR6HSTR.Bits.BIT11
    #define ATDDR6H_BIT12               _ATDDR6.Overlap_STR.ATDDR6HSTR.Bits.BIT12
    #define ATDDR6H_BIT13               _ATDDR6.Overlap_STR.ATDDR6HSTR.Bits.BIT13
    #define ATDDR6H_BIT14               _ATDDR6.Overlap_STR.ATDDR6HSTR.Bits.BIT14
    #define ATDDR6H_BIT15               _ATDDR6.Overlap_STR.ATDDR6HSTR.Bits.BIT15
    
    
    #define ATDDR6H_BIT8_MASK           1
    #define ATDDR6H_BIT9_MASK           2
    #define ATDDR6H_BIT10_MASK          4
    #define ATDDR6H_BIT11_MASK          8
    #define ATDDR6H_BIT12_MASK          16
    #define ATDDR6H_BIT13_MASK          32
    #define ATDDR6H_BIT14_MASK          64
    #define ATDDR6H_BIT15_MASK          128


    /*** ATDDR6L - ATD Conversion Result Register 6 Low; 0x0000009D ***/
    union {
      byte Byte;
      struct {
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte BIT6        :1;                                       /* Bit 6 */
        byte BIT7        :1;                                       /* Bit 7 */
      } Bits;
      struct {
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte grpBIT_6 :2;
      } MergedBits;
    } ATDDR6LSTR;
    #define ATDDR6L                     _ATDDR6.Overlap_STR.ATDDR6LSTR.Byte
    #define ATDDR6L_BIT6                _ATDDR6.Overlap_STR.ATDDR6LSTR.Bits.BIT6
    #define ATDDR6L_BIT7                _ATDDR6.Overlap_STR.ATDDR6LSTR.Bits.BIT7
    
    #define ATDDR6L_BIT_6               _ATDDR6.Overlap_STR.ATDDR6LSTR.MergedBits.grpBIT_6
    #define ATDDR6L_BIT                 ATDDR6L_BIT_6
    
    #define ATDDR6L_BIT6_MASK           64
    #define ATDDR6L_BIT7_MASK           128
    #define ATDDR6L_BIT_6_MASK          %BitsMask
    #define ATDDR6L_BIT_6_BITNUM        %BitsNum

  } Overlap_STR;

  struct {
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word BIT6        :1;                                       /* Bit 6 */
    word BIT7        :1;                                       /* Bit 7 */
    word BIT8        :1;                                       /* Bit 8 */
    word BIT9        :1;                                       /* Bit 9 */
    word BIT10       :1;                                       /* Bit 10 */
    word BIT11       :1;                                       /* Bit 11 */
    word BIT12       :1;                                       /* Bit 12 */
    word BIT13       :1;                                       /* Bit 13 */
    word BIT14       :1;                                       /* Bit 14 */
    word BIT15       :1;                                       /* Bit 15 */
  } Bits;
  struct {
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpBIT_6 :10;
  } MergedBits;
} ATDDR6STR;
extern volatile ATDDR6STR _ATDDR6 @(REG_BASE + 0x0000009C);
#define ATDDR6                          _ATDDR6.Word
#define ATDDR6_BIT6                     _ATDDR6.Bits.BIT6
#define ATDDR6_BIT7                     _ATDDR6.Bits.BIT7
#define ATDDR6_BIT8                     _ATDDR6.Bits.BIT8
#define ATDDR6_BIT9                     _ATDDR6.Bits.BIT9
#define ATDDR6_BIT10                    _ATDDR6.Bits.BIT10
#define ATDDR6_BIT11                    _ATDDR6.Bits.BIT11
#define ATDDR6_BIT12                    _ATDDR6.Bits.BIT12
#define ATDDR6_BIT13                    _ATDDR6.Bits.BIT13
#define ATDDR6_BIT14                    _ATDDR6.Bits.BIT14
#define ATDDR6_BIT15                    _ATDDR6.Bits.BIT15
#define ATDDR6_BIT_6                    _ATDDR6.MergedBits.grpBIT_6
#define ATDDR6_BIT                      ATDDR6_BIT_6

#define ATDDR6_BIT6_MASK                64
#define ATDDR6_BIT7_MASK                128
#define ATDDR6_BIT8_MASK                256
#define ATDDR6_BIT9_MASK                512
#define ATDDR6_BIT10_MASK               1024
#define ATDDR6_BIT11_MASK               2048
#define ATDDR6_BIT12_MASK               4096
#define ATDDR6_BIT13_MASK               8192
#define ATDDR6_BIT14_MASK               16384
#define ATDDR6_BIT15_MASK               32768
#define ATDDR6_BIT_6_MASK               %BitsMask
#define ATDDR6_BIT_6_BITNUM             %BitsNum


/*** ATDDR7 - ATD Conversion Result Register 7; 0x0000009E ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATDDR7H - ATD Conversion Result Register 7 High; 0x0000009E ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Bit 8 */
        byte BIT9        :1;                                       /* Bit 9 */
        byte BIT10       :1;                                       /* Bit 10 */
        byte BIT11       :1;                                       /* Bit 11 */
        byte BIT12       :1;                                       /* Bit 12 */
        byte BIT13       :1;                                       /* Bit 13 */
        byte BIT14       :1;                                       /* Bit 14 */
        byte BIT15       :1;                                       /* Bit 15 */
      } Bits;
    } ATDDR7HSTR;
    #define ATDDR7H                     _ATDDR7.Overlap_STR.ATDDR7HSTR.Byte
    #define ATDDR7H_BIT8                _ATDDR7.Overlap_STR.ATDDR7HSTR.Bits.BIT8
    #define ATDDR7H_BIT9                _ATDDR7.Overlap_STR.ATDDR7HSTR.Bits.BIT9
    #define ATDDR7H_BIT10               _ATDDR7.Overlap_STR.ATDDR7HSTR.Bits.BIT10
    #define ATDDR7H_BIT11               _ATDDR7.Overlap_STR.ATDDR7HSTR.Bits.BIT11
    #define ATDDR7H_BIT12               _ATDDR7.Overlap_STR.ATDDR7HSTR.Bits.BIT12
    #define ATDDR7H_BIT13               _ATDDR7.Overlap_STR.ATDDR7HSTR.Bits.BIT13
    #define ATDDR7H_BIT14               _ATDDR7.Overlap_STR.ATDDR7HSTR.Bits.BIT14
    #define ATDDR7H_BIT15               _ATDDR7.Overlap_STR.ATDDR7HSTR.Bits.BIT15
    
    
    #define ATDDR7H_BIT8_MASK           1
    #define ATDDR7H_BIT9_MASK           2
    #define ATDDR7H_BIT10_MASK          4
    #define ATDDR7H_BIT11_MASK          8
    #define ATDDR7H_BIT12_MASK          16
    #define ATDDR7H_BIT13_MASK          32
    #define ATDDR7H_BIT14_MASK          64
    #define ATDDR7H_BIT15_MASK          128


    /*** ATDDR7L - ATD Conversion Result Register 7 Low; 0x0000009F ***/
    union {
      byte Byte;
      struct {
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte BIT6        :1;                                       /* Bit 6 */
        byte BIT7        :1;                                       /* Bit 7 */
      } Bits;
      struct {
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte grpBIT_6 :2;
      } MergedBits;
    } ATDDR7LSTR;
    #define ATDDR7L                     _ATDDR7.Overlap_STR.ATDDR7LSTR.Byte
    #define ATDDR7L_BIT6                _ATDDR7.Overlap_STR.ATDDR7LSTR.Bits.BIT6
    #define ATDDR7L_BIT7                _ATDDR7.Overlap_STR.ATDDR7LSTR.Bits.BIT7
    
    #define ATDDR7L_BIT_6               _ATDDR7.Overlap_STR.ATDDR7LSTR.MergedBits.grpBIT_6
    #define ATDDR7L_BIT                 ATDDR7L_BIT_6
    
    #define ATDDR7L_BIT6_MASK           64
    #define ATDDR7L_BIT7_MASK           128
    #define ATDDR7L_BIT_6_MASK          %BitsMask
    #define ATDDR7L_BIT_6_BITNUM        %BitsNum

  } Overlap_STR;

  struct {
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word BIT6        :1;                                       /* Bit 6 */
    word BIT7        :1;                                       /* Bit 7 */
    word BIT8        :1;                                       /* Bit 8 */
    word BIT9        :1;                                       /* Bit 9 */
    word BIT10       :1;                                       /* Bit 10 */
    word BIT11       :1;                                       /* Bit 11 */
    word BIT12       :1;                                       /* Bit 12 */
    word BIT13       :1;                                       /* Bit 13 */
    word BIT14       :1;                                       /* Bit 14 */
    word BIT15       :1;                                       /* Bit 15 */
  } Bits;
  struct {
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpBIT_6 :10;
  } MergedBits;
} ATDDR7STR;
extern volatile ATDDR7STR _ATDDR7 @(REG_BASE + 0x0000009E);
#define ATDDR7                          _ATDDR7.Word
#define ATDDR7_BIT6                     _ATDDR7.Bits.BIT6
#define ATDDR7_BIT7                     _ATDDR7.Bits.BIT7
#define ATDDR7_BIT8                     _ATDDR7.Bits.BIT8
#define ATDDR7_BIT9                     _ATDDR7.Bits.BIT9
#define ATDDR7_BIT10                    _ATDDR7.Bits.BIT10
#define ATDDR7_BIT11                    _ATDDR7.Bits.BIT11
#define ATDDR7_BIT12                    _ATDDR7.Bits.BIT12
#define ATDDR7_BIT13                    _ATDDR7.Bits.BIT13
#define ATDDR7_BIT14                    _ATDDR7.Bits.BIT14
#define ATDDR7_BIT15                    _ATDDR7.Bits.BIT15
#define ATDDR7_BIT_6                    _ATDDR7.MergedBits.grpBIT_6
#define ATDDR7_BIT                      ATDDR7_BIT_6

#define ATDDR7_BIT6_MASK                64
#define ATDDR7_BIT7_MASK                128
#define ATDDR7_BIT8_MASK                256
#define ATDDR7_BIT9_MASK                512
#define ATDDR7_BIT10_MASK               1024
#define ATDDR7_BIT11_MASK               2048
#define ATDDR7_BIT12_MASK               4096
#define ATDDR7_BIT13_MASK               8192
#define ATDDR7_BIT14_MASK               16384
#define ATDDR7_BIT15_MASK               32768
#define ATDDR7_BIT_6_MASK               %BitsMask
#define ATDDR7_BIT_6_BITNUM             %BitsNum


/*** ATDDR8 - ATD Conversion Result Register 8; 0x000000A0 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATDDR8H - ATD Conversion Result Register 8 High; 0x000000A0 ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Bit 8 */
        byte BIT9        :1;                                       /* Bit 9 */
        byte BIT10       :1;                                       /* Bit 10 */
        byte BIT11       :1;                                       /* Bit 11 */
        byte BIT12       :1;                                       /* Bit 12 */
        byte BIT13       :1;                                       /* Bit 13 */
        byte BIT14       :1;                                       /* Bit 14 */
        byte BIT15       :1;                                       /* Bit 15 */
      } Bits;
    } ATDDR8HSTR;
    #define ATDDR8H                     _ATDDR8.Overlap_STR.ATDDR8HSTR.Byte
    #define ATDDR8H_BIT8                _ATDDR8.Overlap_STR.ATDDR8HSTR.Bits.BIT8
    #define ATDDR8H_BIT9                _ATDDR8.Overlap_STR.ATDDR8HSTR.Bits.BIT9
    #define ATDDR8H_BIT10               _ATDDR8.Overlap_STR.ATDDR8HSTR.Bits.BIT10
    #define ATDDR8H_BIT11               _ATDDR8.Overlap_STR.ATDDR8HSTR.Bits.BIT11
    #define ATDDR8H_BIT12               _ATDDR8.Overlap_STR.ATDDR8HSTR.Bits.BIT12
    #define ATDDR8H_BIT13               _ATDDR8.Overlap_STR.ATDDR8HSTR.Bits.BIT13
    #define ATDDR8H_BIT14               _ATDDR8.Overlap_STR.ATDDR8HSTR.Bits.BIT14
    #define ATDDR8H_BIT15               _ATDDR8.Overlap_STR.ATDDR8HSTR.Bits.BIT15
    
    
    #define ATDDR8H_BIT8_MASK           1
    #define ATDDR8H_BIT9_MASK           2
    #define ATDDR8H_BIT10_MASK          4
    #define ATDDR8H_BIT11_MASK          8
    #define ATDDR8H_BIT12_MASK          16
    #define ATDDR8H_BIT13_MASK          32
    #define ATDDR8H_BIT14_MASK          64
    #define ATDDR8H_BIT15_MASK          128


    /*** ATDDR8L - ATD Conversion Result Register 8 Low; 0x000000A1 ***/
    union {
      byte Byte;
      struct {
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte BIT6        :1;                                       /* Bit 6 */
        byte BIT7        :1;                                       /* Bit 7 */
      } Bits;
      struct {
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte grpBIT_6 :2;
      } MergedBits;
    } ATDDR8LSTR;
    #define ATDDR8L                     _ATDDR8.Overlap_STR.ATDDR8LSTR.Byte
    #define ATDDR8L_BIT6                _ATDDR8.Overlap_STR.ATDDR8LSTR.Bits.BIT6
    #define ATDDR8L_BIT7                _ATDDR8.Overlap_STR.ATDDR8LSTR.Bits.BIT7
    
    #define ATDDR8L_BIT_6               _ATDDR8.Overlap_STR.ATDDR8LSTR.MergedBits.grpBIT_6
    #define ATDDR8L_BIT                 ATDDR8L_BIT_6
    
    #define ATDDR8L_BIT6_MASK           64
    #define ATDDR8L_BIT7_MASK           128
    #define ATDDR8L_BIT_6_MASK          %BitsMask
    #define ATDDR8L_BIT_6_BITNUM        %BitsNum

  } Overlap_STR;

  struct {
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word BIT6        :1;                                       /* Bit 6 */
    word BIT7        :1;                                       /* Bit 7 */
    word BIT8        :1;                                       /* Bit 8 */
    word BIT9        :1;                                       /* Bit 9 */
    word BIT10       :1;                                       /* Bit 10 */
    word BIT11       :1;                                       /* Bit 11 */
    word BIT12       :1;                                       /* Bit 12 */
    word BIT13       :1;                                       /* Bit 13 */
    word BIT14       :1;                                       /* Bit 14 */
    word BIT15       :1;                                       /* Bit 15 */
  } Bits;
  struct {
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpBIT_6 :10;
  } MergedBits;
} ATDDR8STR;
extern volatile ATDDR8STR _ATDDR8 @(REG_BASE + 0x000000A0);
#define ATDDR8                          _ATDDR8.Word
#define ATDDR8_BIT6                     _ATDDR8.Bits.BIT6
#define ATDDR8_BIT7                     _ATDDR8.Bits.BIT7
#define ATDDR8_BIT8                     _ATDDR8.Bits.BIT8
#define ATDDR8_BIT9                     _ATDDR8.Bits.BIT9
#define ATDDR8_BIT10                    _ATDDR8.Bits.BIT10
#define ATDDR8_BIT11                    _ATDDR8.Bits.BIT11
#define ATDDR8_BIT12                    _ATDDR8.Bits.BIT12
#define ATDDR8_BIT13                    _ATDDR8.Bits.BIT13
#define ATDDR8_BIT14                    _ATDDR8.Bits.BIT14
#define ATDDR8_BIT15                    _ATDDR8.Bits.BIT15
#define ATDDR8_BIT_6                    _ATDDR8.MergedBits.grpBIT_6
#define ATDDR8_BIT                      ATDDR8_BIT_6

#define ATDDR8_BIT6_MASK                64
#define ATDDR8_BIT7_MASK                128
#define ATDDR8_BIT8_MASK                256
#define ATDDR8_BIT9_MASK                512
#define ATDDR8_BIT10_MASK               1024
#define ATDDR8_BIT11_MASK               2048
#define ATDDR8_BIT12_MASK               4096
#define ATDDR8_BIT13_MASK               8192
#define ATDDR8_BIT14_MASK               16384
#define ATDDR8_BIT15_MASK               32768
#define ATDDR8_BIT_6_MASK               %BitsMask
#define ATDDR8_BIT_6_BITNUM             %BitsNum


/*** ATDDR9 - ATD Conversion Result Register 9; 0x000000A2 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATDDR9H - ATD Conversion Result Register 9 High; 0x000000A2 ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Bit 8 */
        byte BIT9        :1;                                       /* Bit 9 */
        byte BIT10       :1;                                       /* Bit 10 */
        byte BIT11       :1;                                       /* Bit 11 */
        byte BIT12       :1;                                       /* Bit 12 */
        byte BIT13       :1;                                       /* Bit 13 */
        byte BIT14       :1;                                       /* Bit 14 */
        byte BIT15       :1;                                       /* Bit 15 */
      } Bits;
    } ATDDR9HSTR;
    #define ATDDR9H                     _ATDDR9.Overlap_STR.ATDDR9HSTR.Byte
    #define ATDDR9H_BIT8                _ATDDR9.Overlap_STR.ATDDR9HSTR.Bits.BIT8
    #define ATDDR9H_BIT9                _ATDDR9.Overlap_STR.ATDDR9HSTR.Bits.BIT9
    #define ATDDR9H_BIT10               _ATDDR9.Overlap_STR.ATDDR9HSTR.Bits.BIT10
    #define ATDDR9H_BIT11               _ATDDR9.Overlap_STR.ATDDR9HSTR.Bits.BIT11
    #define ATDDR9H_BIT12               _ATDDR9.Overlap_STR.ATDDR9HSTR.Bits.BIT12
    #define ATDDR9H_BIT13               _ATDDR9.Overlap_STR.ATDDR9HSTR.Bits.BIT13
    #define ATDDR9H_BIT14               _ATDDR9.Overlap_STR.ATDDR9HSTR.Bits.BIT14
    #define ATDDR9H_BIT15               _ATDDR9.Overlap_STR.ATDDR9HSTR.Bits.BIT15
    
    
    #define ATDDR9H_BIT8_MASK           1
    #define ATDDR9H_BIT9_MASK           2
    #define ATDDR9H_BIT10_MASK          4
    #define ATDDR9H_BIT11_MASK          8
    #define ATDDR9H_BIT12_MASK          16
    #define ATDDR9H_BIT13_MASK          32
    #define ATDDR9H_BIT14_MASK          64
    #define ATDDR9H_BIT15_MASK          128


    /*** ATDDR9L - ATD Conversion Result Register 9 Low; 0x000000A3 ***/
    union {
      byte Byte;
      struct {
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte BIT6        :1;                                       /* Bit 6 */
        byte BIT7        :1;                                       /* Bit 7 */
      } Bits;
      struct {
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte grpBIT_6 :2;
      } MergedBits;
    } ATDDR9LSTR;
    #define ATDDR9L                     _ATDDR9.Overlap_STR.ATDDR9LSTR.Byte
    #define ATDDR9L_BIT6                _ATDDR9.Overlap_STR.ATDDR9LSTR.Bits.BIT6
    #define ATDDR9L_BIT7                _ATDDR9.Overlap_STR.ATDDR9LSTR.Bits.BIT7
    
    #define ATDDR9L_BIT_6               _ATDDR9.Overlap_STR.ATDDR9LSTR.MergedBits.grpBIT_6
    #define ATDDR9L_BIT                 ATDDR9L_BIT_6
    
    #define ATDDR9L_BIT6_MASK           64
    #define ATDDR9L_BIT7_MASK           128
    #define ATDDR9L_BIT_6_MASK          %BitsMask
    #define ATDDR9L_BIT_6_BITNUM        %BitsNum

  } Overlap_STR;

  struct {
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word BIT6        :1;                                       /* Bit 6 */
    word BIT7        :1;                                       /* Bit 7 */
    word BIT8        :1;                                       /* Bit 8 */
    word BIT9        :1;                                       /* Bit 9 */
    word BIT10       :1;                                       /* Bit 10 */
    word BIT11       :1;                                       /* Bit 11 */
    word BIT12       :1;                                       /* Bit 12 */
    word BIT13       :1;                                       /* Bit 13 */
    word BIT14       :1;                                       /* Bit 14 */
    word BIT15       :1;                                       /* Bit 15 */
  } Bits;
  struct {
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpBIT_6 :10;
  } MergedBits;
} ATDDR9STR;
extern volatile ATDDR9STR _ATDDR9 @(REG_BASE + 0x000000A2);
#define ATDDR9                          _ATDDR9.Word
#define ATDDR9_BIT6                     _ATDDR9.Bits.BIT6
#define ATDDR9_BIT7                     _ATDDR9.Bits.BIT7
#define ATDDR9_BIT8                     _ATDDR9.Bits.BIT8
#define ATDDR9_BIT9                     _ATDDR9.Bits.BIT9
#define ATDDR9_BIT10                    _ATDDR9.Bits.BIT10
#define ATDDR9_BIT11                    _ATDDR9.Bits.BIT11
#define ATDDR9_BIT12                    _ATDDR9.Bits.BIT12
#define ATDDR9_BIT13                    _ATDDR9.Bits.BIT13
#define ATDDR9_BIT14                    _ATDDR9.Bits.BIT14
#define ATDDR9_BIT15                    _ATDDR9.Bits.BIT15
#define ATDDR9_BIT_6                    _ATDDR9.MergedBits.grpBIT_6
#define ATDDR9_BIT                      ATDDR9_BIT_6

#define ATDDR9_BIT6_MASK                64
#define ATDDR9_BIT7_MASK                128
#define ATDDR9_BIT8_MASK                256
#define ATDDR9_BIT9_MASK                512
#define ATDDR9_BIT10_MASK               1024
#define ATDDR9_BIT11_MASK               2048
#define ATDDR9_BIT12_MASK               4096
#define ATDDR9_BIT13_MASK               8192
#define ATDDR9_BIT14_MASK               16384
#define ATDDR9_BIT15_MASK               32768
#define ATDDR9_BIT_6_MASK               %BitsMask
#define ATDDR9_BIT_6_BITNUM             %BitsNum


/*** ATDDR10 - ATD Conversion Result Register 10; 0x000000A4 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATDDR10H - ATD Conversion Result Register 10 High; 0x000000A4 ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Bit 8 */
        byte BIT9        :1;                                       /* Bit 9 */
        byte BIT10       :1;                                       /* Bit 10 */
        byte BIT11       :1;                                       /* Bit 11 */
        byte BIT12       :1;                                       /* Bit 12 */
        byte BIT13       :1;                                       /* Bit 13 */
        byte BIT14       :1;                                       /* Bit 14 */
        byte BIT15       :1;                                       /* Bit 15 */
      } Bits;
    } ATDDR10HSTR;
    #define ATDDR10H                    _ATDDR10.Overlap_STR.ATDDR10HSTR.Byte
    #define ATDDR10H_BIT8               _ATDDR10.Overlap_STR.ATDDR10HSTR.Bits.BIT8
    #define ATDDR10H_BIT9               _ATDDR10.Overlap_STR.ATDDR10HSTR.Bits.BIT9
    #define ATDDR10H_BIT10              _ATDDR10.Overlap_STR.ATDDR10HSTR.Bits.BIT10
    #define ATDDR10H_BIT11              _ATDDR10.Overlap_STR.ATDDR10HSTR.Bits.BIT11
    #define ATDDR10H_BIT12              _ATDDR10.Overlap_STR.ATDDR10HSTR.Bits.BIT12
    #define ATDDR10H_BIT13              _ATDDR10.Overlap_STR.ATDDR10HSTR.Bits.BIT13
    #define ATDDR10H_BIT14              _ATDDR10.Overlap_STR.ATDDR10HSTR.Bits.BIT14
    #define ATDDR10H_BIT15              _ATDDR10.Overlap_STR.ATDDR10HSTR.Bits.BIT15
    
    
    #define ATDDR10H_BIT8_MASK          1
    #define ATDDR10H_BIT9_MASK          2
    #define ATDDR10H_BIT10_MASK         4
    #define ATDDR10H_BIT11_MASK         8
    #define ATDDR10H_BIT12_MASK         16
    #define ATDDR10H_BIT13_MASK         32
    #define ATDDR10H_BIT14_MASK         64
    #define ATDDR10H_BIT15_MASK         128


    /*** ATDDR10L - ATD Conversion Result Register 10 Low; 0x000000A5 ***/
    union {
      byte Byte;
      struct {
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte BIT6        :1;                                       /* Bit 6 */
        byte BIT7        :1;                                       /* Bit 7 */
      } Bits;
      struct {
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte grpBIT_6 :2;
      } MergedBits;
    } ATDDR10LSTR;
    #define ATDDR10L                    _ATDDR10.Overlap_STR.ATDDR10LSTR.Byte
    #define ATDDR10L_BIT6               _ATDDR10.Overlap_STR.ATDDR10LSTR.Bits.BIT6
    #define ATDDR10L_BIT7               _ATDDR10.Overlap_STR.ATDDR10LSTR.Bits.BIT7
    
    #define ATDDR10L_BIT_6              _ATDDR10.Overlap_STR.ATDDR10LSTR.MergedBits.grpBIT_6
    #define ATDDR10L_BIT                ATDDR10L_BIT_6
    
    #define ATDDR10L_BIT6_MASK          64
    #define ATDDR10L_BIT7_MASK          128
    #define ATDDR10L_BIT_6_MASK         %BitsMask
    #define ATDDR10L_BIT_6_BITNUM       %BitsNum

  } Overlap_STR;

  struct {
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word BIT6        :1;                                       /* Bit 6 */
    word BIT7        :1;                                       /* Bit 7 */
    word BIT8        :1;                                       /* Bit 8 */
    word BIT9        :1;                                       /* Bit 9 */
    word BIT10       :1;                                       /* Bit 10 */
    word BIT11       :1;                                       /* Bit 11 */
    word BIT12       :1;                                       /* Bit 12 */
    word BIT13       :1;                                       /* Bit 13 */
    word BIT14       :1;                                       /* Bit 14 */
    word BIT15       :1;                                       /* Bit 15 */
  } Bits;
  struct {
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpBIT_6 :10;
  } MergedBits;
} ATDDR10STR;
extern volatile ATDDR10STR _ATDDR10 @(REG_BASE + 0x000000A4);
#define ATDDR10                         _ATDDR10.Word
#define ATDDR10_BIT6                    _ATDDR10.Bits.BIT6
#define ATDDR10_BIT7                    _ATDDR10.Bits.BIT7
#define ATDDR10_BIT8                    _ATDDR10.Bits.BIT8
#define ATDDR10_BIT9                    _ATDDR10.Bits.BIT9
#define ATDDR10_BIT10                   _ATDDR10.Bits.BIT10
#define ATDDR10_BIT11                   _ATDDR10.Bits.BIT11
#define ATDDR10_BIT12                   _ATDDR10.Bits.BIT12
#define ATDDR10_BIT13                   _ATDDR10.Bits.BIT13
#define ATDDR10_BIT14                   _ATDDR10.Bits.BIT14
#define ATDDR10_BIT15                   _ATDDR10.Bits.BIT15
#define ATDDR10_BIT_6                   _ATDDR10.MergedBits.grpBIT_6
#define ATDDR10_BIT                     ATDDR10_BIT_6

#define ATDDR10_BIT6_MASK               64
#define ATDDR10_BIT7_MASK               128
#define ATDDR10_BIT8_MASK               256
#define ATDDR10_BIT9_MASK               512
#define ATDDR10_BIT10_MASK              1024
#define ATDDR10_BIT11_MASK              2048
#define ATDDR10_BIT12_MASK              4096
#define ATDDR10_BIT13_MASK              8192
#define ATDDR10_BIT14_MASK              16384
#define ATDDR10_BIT15_MASK              32768
#define ATDDR10_BIT_6_MASK              %BitsMask
#define ATDDR10_BIT_6_BITNUM            %BitsNum


/*** ATDDR11 - ATD Conversion Result Register 11; 0x000000A6 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATDDR11H - ATD Conversion Result Register 11 High; 0x000000A6 ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Bit 8 */
        byte BIT9        :1;                                       /* Bit 9 */
        byte BIT10       :1;                                       /* Bit 10 */
        byte BIT11       :1;                                       /* Bit 11 */
        byte BIT12       :1;                                       /* Bit 12 */
        byte BIT13       :1;                                       /* Bit 13 */
        byte BIT14       :1;                                       /* Bit 14 */
        byte BIT15       :1;                                       /* Bit 15 */
      } Bits;
    } ATDDR11HSTR;
    #define ATDDR11H                    _ATDDR11.Overlap_STR.ATDDR11HSTR.Byte
    #define ATDDR11H_BIT8               _ATDDR11.Overlap_STR.ATDDR11HSTR.Bits.BIT8
    #define ATDDR11H_BIT9               _ATDDR11.Overlap_STR.ATDDR11HSTR.Bits.BIT9
    #define ATDDR11H_BIT10              _ATDDR11.Overlap_STR.ATDDR11HSTR.Bits.BIT10
    #define ATDDR11H_BIT11              _ATDDR11.Overlap_STR.ATDDR11HSTR.Bits.BIT11
    #define ATDDR11H_BIT12              _ATDDR11.Overlap_STR.ATDDR11HSTR.Bits.BIT12
    #define ATDDR11H_BIT13              _ATDDR11.Overlap_STR.ATDDR11HSTR.Bits.BIT13
    #define ATDDR11H_BIT14              _ATDDR11.Overlap_STR.ATDDR11HSTR.Bits.BIT14
    #define ATDDR11H_BIT15              _ATDDR11.Overlap_STR.ATDDR11HSTR.Bits.BIT15
    
    
    #define ATDDR11H_BIT8_MASK          1
    #define ATDDR11H_BIT9_MASK          2
    #define ATDDR11H_BIT10_MASK         4
    #define ATDDR11H_BIT11_MASK         8
    #define ATDDR11H_BIT12_MASK         16
    #define ATDDR11H_BIT13_MASK         32
    #define ATDDR11H_BIT14_MASK         64
    #define ATDDR11H_BIT15_MASK         128


    /*** ATDDR11L - ATD Conversion Result Register 11 Low; 0x000000A7 ***/
    union {
      byte Byte;
      struct {
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte BIT6        :1;                                       /* Bit 6 */
        byte BIT7        :1;                                       /* Bit 7 */
      } Bits;
      struct {
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte grpBIT_6 :2;
      } MergedBits;
    } ATDDR11LSTR;
    #define ATDDR11L                    _ATDDR11.Overlap_STR.ATDDR11LSTR.Byte
    #define ATDDR11L_BIT6               _ATDDR11.Overlap_STR.ATDDR11LSTR.Bits.BIT6
    #define ATDDR11L_BIT7               _ATDDR11.Overlap_STR.ATDDR11LSTR.Bits.BIT7
    
    #define ATDDR11L_BIT_6              _ATDDR11.Overlap_STR.ATDDR11LSTR.MergedBits.grpBIT_6
    #define ATDDR11L_BIT                ATDDR11L_BIT_6
    
    #define ATDDR11L_BIT6_MASK          64
    #define ATDDR11L_BIT7_MASK          128
    #define ATDDR11L_BIT_6_MASK         %BitsMask
    #define ATDDR11L_BIT_6_BITNUM       %BitsNum

  } Overlap_STR;

  struct {
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word BIT6        :1;                                       /* Bit 6 */
    word BIT7        :1;                                       /* Bit 7 */
    word BIT8        :1;                                       /* Bit 8 */
    word BIT9        :1;                                       /* Bit 9 */
    word BIT10       :1;                                       /* Bit 10 */
    word BIT11       :1;                                       /* Bit 11 */
    word BIT12       :1;                                       /* Bit 12 */
    word BIT13       :1;                                       /* Bit 13 */
    word BIT14       :1;                                       /* Bit 14 */
    word BIT15       :1;                                       /* Bit 15 */
  } Bits;
  struct {
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpBIT_6 :10;
  } MergedBits;
} ATDDR11STR;
extern volatile ATDDR11STR _ATDDR11 @(REG_BASE + 0x000000A6);
#define ATDDR11                         _ATDDR11.Word
#define ATDDR11_BIT6                    _ATDDR11.Bits.BIT6
#define ATDDR11_BIT7                    _ATDDR11.Bits.BIT7
#define ATDDR11_BIT8                    _ATDDR11.Bits.BIT8
#define ATDDR11_BIT9                    _ATDDR11.Bits.BIT9
#define ATDDR11_BIT10                   _ATDDR11.Bits.BIT10
#define ATDDR11_BIT11                   _ATDDR11.Bits.BIT11
#define ATDDR11_BIT12                   _ATDDR11.Bits.BIT12
#define ATDDR11_BIT13                   _ATDDR11.Bits.BIT13
#define ATDDR11_BIT14                   _ATDDR11.Bits.BIT14
#define ATDDR11_BIT15                   _ATDDR11.Bits.BIT15
#define ATDDR11_BIT_6                   _ATDDR11.MergedBits.grpBIT_6
#define ATDDR11_BIT                     ATDDR11_BIT_6

#define ATDDR11_BIT6_MASK               64
#define ATDDR11_BIT7_MASK               128
#define ATDDR11_BIT8_MASK               256
#define ATDDR11_BIT9_MASK               512
#define ATDDR11_BIT10_MASK              1024
#define ATDDR11_BIT11_MASK              2048
#define ATDDR11_BIT12_MASK              4096
#define ATDDR11_BIT13_MASK              8192
#define ATDDR11_BIT14_MASK              16384
#define ATDDR11_BIT15_MASK              32768
#define ATDDR11_BIT_6_MASK              %BitsMask
#define ATDDR11_BIT_6_BITNUM            %BitsNum


/*** ATDDR12 - ATD Conversion Result Register 12; 0x000000A8 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATDDR12H - ATD Conversion Result Register 12 High; 0x000000A8 ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Bit 8 */
        byte BIT9        :1;                                       /* Bit 9 */
        byte BIT10       :1;                                       /* Bit 10 */
        byte BIT11       :1;                                       /* Bit 11 */
        byte BIT12       :1;                                       /* Bit 12 */
        byte BIT13       :1;                                       /* Bit 13 */
        byte BIT14       :1;                                       /* Bit 14 */
        byte BIT15       :1;                                       /* Bit 15 */
      } Bits;
    } ATDDR12HSTR;
    #define ATDDR12H                    _ATDDR12.Overlap_STR.ATDDR12HSTR.Byte
    #define ATDDR12H_BIT8               _ATDDR12.Overlap_STR.ATDDR12HSTR.Bits.BIT8
    #define ATDDR12H_BIT9               _ATDDR12.Overlap_STR.ATDDR12HSTR.Bits.BIT9
    #define ATDDR12H_BIT10              _ATDDR12.Overlap_STR.ATDDR12HSTR.Bits.BIT10
    #define ATDDR12H_BIT11              _ATDDR12.Overlap_STR.ATDDR12HSTR.Bits.BIT11
    #define ATDDR12H_BIT12              _ATDDR12.Overlap_STR.ATDDR12HSTR.Bits.BIT12
    #define ATDDR12H_BIT13              _ATDDR12.Overlap_STR.ATDDR12HSTR.Bits.BIT13
    #define ATDDR12H_BIT14              _ATDDR12.Overlap_STR.ATDDR12HSTR.Bits.BIT14
    #define ATDDR12H_BIT15              _ATDDR12.Overlap_STR.ATDDR12HSTR.Bits.BIT15
    
    
    #define ATDDR12H_BIT8_MASK          1
    #define ATDDR12H_BIT9_MASK          2
    #define ATDDR12H_BIT10_MASK         4
    #define ATDDR12H_BIT11_MASK         8
    #define ATDDR12H_BIT12_MASK         16
    #define ATDDR12H_BIT13_MASK         32
    #define ATDDR12H_BIT14_MASK         64
    #define ATDDR12H_BIT15_MASK         128


    /*** ATDDR12L - ATD Conversion Result Register 12 Low; 0x000000A9 ***/
    union {
      byte Byte;
      struct {
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte BIT6        :1;                                       /* Bit 6 */
        byte BIT7        :1;                                       /* Bit 7 */
      } Bits;
      struct {
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte grpBIT_6 :2;
      } MergedBits;
    } ATDDR12LSTR;
    #define ATDDR12L                    _ATDDR12.Overlap_STR.ATDDR12LSTR.Byte
    #define ATDDR12L_BIT6               _ATDDR12.Overlap_STR.ATDDR12LSTR.Bits.BIT6
    #define ATDDR12L_BIT7               _ATDDR12.Overlap_STR.ATDDR12LSTR.Bits.BIT7
    
    #define ATDDR12L_BIT_6              _ATDDR12.Overlap_STR.ATDDR12LSTR.MergedBits.grpBIT_6
    #define ATDDR12L_BIT                ATDDR12L_BIT_6
    
    #define ATDDR12L_BIT6_MASK          64
    #define ATDDR12L_BIT7_MASK          128
    #define ATDDR12L_BIT_6_MASK         %BitsMask
    #define ATDDR12L_BIT_6_BITNUM       %BitsNum

  } Overlap_STR;

  struct {
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word BIT6        :1;                                       /* Bit 6 */
    word BIT7        :1;                                       /* Bit 7 */
    word BIT8        :1;                                       /* Bit 8 */
    word BIT9        :1;                                       /* Bit 9 */
    word BIT10       :1;                                       /* Bit 10 */
    word BIT11       :1;                                       /* Bit 11 */
    word BIT12       :1;                                       /* Bit 12 */
    word BIT13       :1;                                       /* Bit 13 */
    word BIT14       :1;                                       /* Bit 14 */
    word BIT15       :1;                                       /* Bit 15 */
  } Bits;
  struct {
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpBIT_6 :10;
  } MergedBits;
} ATDDR12STR;
extern volatile ATDDR12STR _ATDDR12 @(REG_BASE + 0x000000A8);
#define ATDDR12                         _ATDDR12.Word
#define ATDDR12_BIT6                    _ATDDR12.Bits.BIT6
#define ATDDR12_BIT7                    _ATDDR12.Bits.BIT7
#define ATDDR12_BIT8                    _ATDDR12.Bits.BIT8
#define ATDDR12_BIT9                    _ATDDR12.Bits.BIT9
#define ATDDR12_BIT10                   _ATDDR12.Bits.BIT10
#define ATDDR12_BIT11                   _ATDDR12.Bits.BIT11
#define ATDDR12_BIT12                   _ATDDR12.Bits.BIT12
#define ATDDR12_BIT13                   _ATDDR12.Bits.BIT13
#define ATDDR12_BIT14                   _ATDDR12.Bits.BIT14
#define ATDDR12_BIT15                   _ATDDR12.Bits.BIT15
#define ATDDR12_BIT_6                   _ATDDR12.MergedBits.grpBIT_6
#define ATDDR12_BIT                     ATDDR12_BIT_6

#define ATDDR12_BIT6_MASK               64
#define ATDDR12_BIT7_MASK               128
#define ATDDR12_BIT8_MASK               256
#define ATDDR12_BIT9_MASK               512
#define ATDDR12_BIT10_MASK              1024
#define ATDDR12_BIT11_MASK              2048
#define ATDDR12_BIT12_MASK              4096
#define ATDDR12_BIT13_MASK              8192
#define ATDDR12_BIT14_MASK              16384
#define ATDDR12_BIT15_MASK              32768
#define ATDDR12_BIT_6_MASK              %BitsMask
#define ATDDR12_BIT_6_BITNUM            %BitsNum


/*** ATDDR13 - ATD Conversion Result Register 13; 0x000000AA ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATDDR13H - ATD Conversion Result Register 13 High; 0x000000AA ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Bit 8 */
        byte BIT9        :1;                                       /* Bit 9 */
        byte BIT10       :1;                                       /* Bit 10 */
        byte BIT11       :1;                                       /* Bit 11 */
        byte BIT12       :1;                                       /* Bit 12 */
        byte BIT13       :1;                                       /* Bit 13 */
        byte BIT14       :1;                                       /* Bit 14 */
        byte BIT15       :1;                                       /* Bit 15 */
      } Bits;
    } ATDDR13HSTR;
    #define ATDDR13H                    _ATDDR13.Overlap_STR.ATDDR13HSTR.Byte
    #define ATDDR13H_BIT8               _ATDDR13.Overlap_STR.ATDDR13HSTR.Bits.BIT8
    #define ATDDR13H_BIT9               _ATDDR13.Overlap_STR.ATDDR13HSTR.Bits.BIT9
    #define ATDDR13H_BIT10              _ATDDR13.Overlap_STR.ATDDR13HSTR.Bits.BIT10
    #define ATDDR13H_BIT11              _ATDDR13.Overlap_STR.ATDDR13HSTR.Bits.BIT11
    #define ATDDR13H_BIT12              _ATDDR13.Overlap_STR.ATDDR13HSTR.Bits.BIT12
    #define ATDDR13H_BIT13              _ATDDR13.Overlap_STR.ATDDR13HSTR.Bits.BIT13
    #define ATDDR13H_BIT14              _ATDDR13.Overlap_STR.ATDDR13HSTR.Bits.BIT14
    #define ATDDR13H_BIT15              _ATDDR13.Overlap_STR.ATDDR13HSTR.Bits.BIT15
    
    
    #define ATDDR13H_BIT8_MASK          1
    #define ATDDR13H_BIT9_MASK          2
    #define ATDDR13H_BIT10_MASK         4
    #define ATDDR13H_BIT11_MASK         8
    #define ATDDR13H_BIT12_MASK         16
    #define ATDDR13H_BIT13_MASK         32
    #define ATDDR13H_BIT14_MASK         64
    #define ATDDR13H_BIT15_MASK         128


    /*** ATDDR13L - ATD Conversion Result Register 13 Low; 0x000000AB ***/
    union {
      byte Byte;
      struct {
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte BIT6        :1;                                       /* Bit 6 */
        byte BIT7        :1;                                       /* Bit 7 */
      } Bits;
      struct {
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte grpBIT_6 :2;
      } MergedBits;
    } ATDDR13LSTR;
    #define ATDDR13L                    _ATDDR13.Overlap_STR.ATDDR13LSTR.Byte
    #define ATDDR13L_BIT6               _ATDDR13.Overlap_STR.ATDDR13LSTR.Bits.BIT6
    #define ATDDR13L_BIT7               _ATDDR13.Overlap_STR.ATDDR13LSTR.Bits.BIT7
    
    #define ATDDR13L_BIT_6              _ATDDR13.Overlap_STR.ATDDR13LSTR.MergedBits.grpBIT_6
    #define ATDDR13L_BIT                ATDDR13L_BIT_6
    
    #define ATDDR13L_BIT6_MASK          64
    #define ATDDR13L_BIT7_MASK          128
    #define ATDDR13L_BIT_6_MASK         %BitsMask
    #define ATDDR13L_BIT_6_BITNUM       %BitsNum

  } Overlap_STR;

  struct {
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word BIT6        :1;                                       /* Bit 6 */
    word BIT7        :1;                                       /* Bit 7 */
    word BIT8        :1;                                       /* Bit 8 */
    word BIT9        :1;                                       /* Bit 9 */
    word BIT10       :1;                                       /* Bit 10 */
    word BIT11       :1;                                       /* Bit 11 */
    word BIT12       :1;                                       /* Bit 12 */
    word BIT13       :1;                                       /* Bit 13 */
    word BIT14       :1;                                       /* Bit 14 */
    word BIT15       :1;                                       /* Bit 15 */
  } Bits;
  struct {
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpBIT_6 :10;
  } MergedBits;
} ATDDR13STR;
extern volatile ATDDR13STR _ATDDR13 @(REG_BASE + 0x000000AA);
#define ATDDR13                         _ATDDR13.Word
#define ATDDR13_BIT6                    _ATDDR13.Bits.BIT6
#define ATDDR13_BIT7                    _ATDDR13.Bits.BIT7
#define ATDDR13_BIT8                    _ATDDR13.Bits.BIT8
#define ATDDR13_BIT9                    _ATDDR13.Bits.BIT9
#define ATDDR13_BIT10                   _ATDDR13.Bits.BIT10
#define ATDDR13_BIT11                   _ATDDR13.Bits.BIT11
#define ATDDR13_BIT12                   _ATDDR13.Bits.BIT12
#define ATDDR13_BIT13                   _ATDDR13.Bits.BIT13
#define ATDDR13_BIT14                   _ATDDR13.Bits.BIT14
#define ATDDR13_BIT15                   _ATDDR13.Bits.BIT15
#define ATDDR13_BIT_6                   _ATDDR13.MergedBits.grpBIT_6
#define ATDDR13_BIT                     ATDDR13_BIT_6

#define ATDDR13_BIT6_MASK               64
#define ATDDR13_BIT7_MASK               128
#define ATDDR13_BIT8_MASK               256
#define ATDDR13_BIT9_MASK               512
#define ATDDR13_BIT10_MASK              1024
#define ATDDR13_BIT11_MASK              2048
#define ATDDR13_BIT12_MASK              4096
#define ATDDR13_BIT13_MASK              8192
#define ATDDR13_BIT14_MASK              16384
#define ATDDR13_BIT15_MASK              32768
#define ATDDR13_BIT_6_MASK              %BitsMask
#define ATDDR13_BIT_6_BITNUM            %BitsNum


/*** ATDDR14 - ATD Conversion Result Register 14; 0x000000AC ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATDDR14H - ATD Conversion Result Register 14 High; 0x000000AC ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Bit 8 */
        byte BIT9        :1;                                       /* Bit 9 */
        byte BIT10       :1;                                       /* Bit 10 */
        byte BIT11       :1;                                       /* Bit 11 */
        byte BIT12       :1;                                       /* Bit 12 */
        byte BIT13       :1;                                       /* Bit 13 */
        byte BIT14       :1;                                       /* Bit 14 */
        byte BIT15       :1;                                       /* Bit 15 */
      } Bits;
    } ATDDR14HSTR;
    #define ATDDR14H                    _ATDDR14.Overlap_STR.ATDDR14HSTR.Byte
    #define ATDDR14H_BIT8               _ATDDR14.Overlap_STR.ATDDR14HSTR.Bits.BIT8
    #define ATDDR14H_BIT9               _ATDDR14.Overlap_STR.ATDDR14HSTR.Bits.BIT9
    #define ATDDR14H_BIT10              _ATDDR14.Overlap_STR.ATDDR14HSTR.Bits.BIT10
    #define ATDDR14H_BIT11              _ATDDR14.Overlap_STR.ATDDR14HSTR.Bits.BIT11
    #define ATDDR14H_BIT12              _ATDDR14.Overlap_STR.ATDDR14HSTR.Bits.BIT12
    #define ATDDR14H_BIT13              _ATDDR14.Overlap_STR.ATDDR14HSTR.Bits.BIT13
    #define ATDDR14H_BIT14              _ATDDR14.Overlap_STR.ATDDR14HSTR.Bits.BIT14
    #define ATDDR14H_BIT15              _ATDDR14.Overlap_STR.ATDDR14HSTR.Bits.BIT15
    
    
    #define ATDDR14H_BIT8_MASK          1
    #define ATDDR14H_BIT9_MASK          2
    #define ATDDR14H_BIT10_MASK         4
    #define ATDDR14H_BIT11_MASK         8
    #define ATDDR14H_BIT12_MASK         16
    #define ATDDR14H_BIT13_MASK         32
    #define ATDDR14H_BIT14_MASK         64
    #define ATDDR14H_BIT15_MASK         128


    /*** ATDDR14L - ATD Conversion Result Register 14 Low; 0x000000AD ***/
    union {
      byte Byte;
      struct {
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte BIT6        :1;                                       /* Bit 6 */
        byte BIT7        :1;                                       /* Bit 7 */
      } Bits;
      struct {
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte grpBIT_6 :2;
      } MergedBits;
    } ATDDR14LSTR;
    #define ATDDR14L                    _ATDDR14.Overlap_STR.ATDDR14LSTR.Byte
    #define ATDDR14L_BIT6               _ATDDR14.Overlap_STR.ATDDR14LSTR.Bits.BIT6
    #define ATDDR14L_BIT7               _ATDDR14.Overlap_STR.ATDDR14LSTR.Bits.BIT7
    
    #define ATDDR14L_BIT_6              _ATDDR14.Overlap_STR.ATDDR14LSTR.MergedBits.grpBIT_6
    #define ATDDR14L_BIT                ATDDR14L_BIT_6
    
    #define ATDDR14L_BIT6_MASK          64
    #define ATDDR14L_BIT7_MASK          128
    #define ATDDR14L_BIT_6_MASK         %BitsMask
    #define ATDDR14L_BIT_6_BITNUM       %BitsNum

  } Overlap_STR;

  struct {
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word BIT6        :1;                                       /* Bit 6 */
    word BIT7        :1;                                       /* Bit 7 */
    word BIT8        :1;                                       /* Bit 8 */
    word BIT9        :1;                                       /* Bit 9 */
    word BIT10       :1;                                       /* Bit 10 */
    word BIT11       :1;                                       /* Bit 11 */
    word BIT12       :1;                                       /* Bit 12 */
    word BIT13       :1;                                       /* Bit 13 */
    word BIT14       :1;                                       /* Bit 14 */
    word BIT15       :1;                                       /* Bit 15 */
  } Bits;
  struct {
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpBIT_6 :10;
  } MergedBits;
} ATDDR14STR;
extern volatile ATDDR14STR _ATDDR14 @(REG_BASE + 0x000000AC);
#define ATDDR14                         _ATDDR14.Word
#define ATDDR14_BIT6                    _ATDDR14.Bits.BIT6
#define ATDDR14_BIT7                    _ATDDR14.Bits.BIT7
#define ATDDR14_BIT8                    _ATDDR14.Bits.BIT8
#define ATDDR14_BIT9                    _ATDDR14.Bits.BIT9
#define ATDDR14_BIT10                   _ATDDR14.Bits.BIT10
#define ATDDR14_BIT11                   _ATDDR14.Bits.BIT11
#define ATDDR14_BIT12                   _ATDDR14.Bits.BIT12
#define ATDDR14_BIT13                   _ATDDR14.Bits.BIT13
#define ATDDR14_BIT14                   _ATDDR14.Bits.BIT14
#define ATDDR14_BIT15                   _ATDDR14.Bits.BIT15
#define ATDDR14_BIT_6                   _ATDDR14.MergedBits.grpBIT_6
#define ATDDR14_BIT                     ATDDR14_BIT_6

#define ATDDR14_BIT6_MASK               64
#define ATDDR14_BIT7_MASK               128
#define ATDDR14_BIT8_MASK               256
#define ATDDR14_BIT9_MASK               512
#define ATDDR14_BIT10_MASK              1024
#define ATDDR14_BIT11_MASK              2048
#define ATDDR14_BIT12_MASK              4096
#define ATDDR14_BIT13_MASK              8192
#define ATDDR14_BIT14_MASK              16384
#define ATDDR14_BIT15_MASK              32768
#define ATDDR14_BIT_6_MASK              %BitsMask
#define ATDDR14_BIT_6_BITNUM            %BitsNum


/*** ATDDR15 - ATD Conversion Result Register 15; 0x000000AE ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATDDR15H - ATD Conversion Result Register 15 High; 0x000000AE ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Bit 8 */
        byte BIT9        :1;                                       /* Bit 9 */
        byte BIT10       :1;                                       /* Bit 10 */
        byte BIT11       :1;                                       /* Bit 11 */
        byte BIT12       :1;                                       /* Bit 12 */
        byte BIT13       :1;                                       /* Bit 13 */
        byte BIT14       :1;                                       /* Bit 14 */
        byte BIT15       :1;                                       /* Bit 15 */
      } Bits;
    } ATDDR15HSTR;
    #define ATDDR15H                    _ATDDR15.Overlap_STR.ATDDR15HSTR.Byte
    #define ATDDR15H_BIT8               _ATDDR15.Overlap_STR.ATDDR15HSTR.Bits.BIT8
    #define ATDDR15H_BIT9               _ATDDR15.Overlap_STR.ATDDR15HSTR.Bits.BIT9
    #define ATDDR15H_BIT10              _ATDDR15.Overlap_STR.ATDDR15HSTR.Bits.BIT10
    #define ATDDR15H_BIT11              _ATDDR15.Overlap_STR.ATDDR15HSTR.Bits.BIT11
    #define ATDDR15H_BIT12              _ATDDR15.Overlap_STR.ATDDR15HSTR.Bits.BIT12
    #define ATDDR15H_BIT13              _ATDDR15.Overlap_STR.ATDDR15HSTR.Bits.BIT13
    #define ATDDR15H_BIT14              _ATDDR15.Overlap_STR.ATDDR15HSTR.Bits.BIT14
    #define ATDDR15H_BIT15              _ATDDR15.Overlap_STR.ATDDR15HSTR.Bits.BIT15
    
    
    #define ATDDR15H_BIT8_MASK          1
    #define ATDDR15H_BIT9_MASK          2
    #define ATDDR15H_BIT10_MASK         4
    #define ATDDR15H_BIT11_MASK         8
    #define ATDDR15H_BIT12_MASK         16
    #define ATDDR15H_BIT13_MASK         32
    #define ATDDR15H_BIT14_MASK         64
    #define ATDDR15H_BIT15_MASK         128


    /*** ATDDR15L - ATD Conversion Result Register 15 Low; 0x000000AF ***/
    union {
      byte Byte;
      struct {
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte BIT6        :1;                                       /* Bit 6 */
        byte BIT7        :1;                                       /* Bit 7 */
      } Bits;
      struct {
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte grpBIT_6 :2;
      } MergedBits;
    } ATDDR15LSTR;
    #define ATDDR15L                    _ATDDR15.Overlap_STR.ATDDR15LSTR.Byte
    #define ATDDR15L_BIT6               _ATDDR15.Overlap_STR.ATDDR15LSTR.Bits.BIT6
    #define ATDDR15L_BIT7               _ATDDR15.Overlap_STR.ATDDR15LSTR.Bits.BIT7
    
    #define ATDDR15L_BIT_6              _ATDDR15.Overlap_STR.ATDDR15LSTR.MergedBits.grpBIT_6
    #define ATDDR15L_BIT                ATDDR15L_BIT_6
    
    #define ATDDR15L_BIT6_MASK          64
    #define ATDDR15L_BIT7_MASK          128
    #define ATDDR15L_BIT_6_MASK         %BitsMask
    #define ATDDR15L_BIT_6_BITNUM       %BitsNum

  } Overlap_STR;

  struct {
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word BIT6        :1;                                       /* Bit 6 */
    word BIT7        :1;                                       /* Bit 7 */
    word BIT8        :1;                                       /* Bit 8 */
    word BIT9        :1;                                       /* Bit 9 */
    word BIT10       :1;                                       /* Bit 10 */
    word BIT11       :1;                                       /* Bit 11 */
    word BIT12       :1;                                       /* Bit 12 */
    word BIT13       :1;                                       /* Bit 13 */
    word BIT14       :1;                                       /* Bit 14 */
    word BIT15       :1;                                       /* Bit 15 */
  } Bits;
  struct {
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpBIT_6 :10;
  } MergedBits;
} ATDDR15STR;
extern volatile ATDDR15STR _ATDDR15 @(REG_BASE + 0x000000AE);
#define ATDDR15                         _ATDDR15.Word
#define ATDDR15_BIT6                    _ATDDR15.Bits.BIT6
#define ATDDR15_BIT7                    _ATDDR15.Bits.BIT7
#define ATDDR15_BIT8                    _ATDDR15.Bits.BIT8
#define ATDDR15_BIT9                    _ATDDR15.Bits.BIT9
#define ATDDR15_BIT10                   _ATDDR15.Bits.BIT10
#define ATDDR15_BIT11                   _ATDDR15.Bits.BIT11
#define ATDDR15_BIT12                   _ATDDR15.Bits.BIT12
#define ATDDR15_BIT13                   _ATDDR15.Bits.BIT13
#define ATDDR15_BIT14                   _ATDDR15.Bits.BIT14
#define ATDDR15_BIT15                   _ATDDR15.Bits.BIT15
#define ATDDR15_BIT_6                   _ATDDR15.MergedBits.grpBIT_6
#define ATDDR15_BIT                     ATDDR15_BIT_6

#define ATDDR15_BIT6_MASK               64
#define ATDDR15_BIT7_MASK               128
#define ATDDR15_BIT8_MASK               256
#define ATDDR15_BIT9_MASK               512
#define ATDDR15_BIT10_MASK              1024
#define ATDDR15_BIT11_MASK              2048
#define ATDDR15_BIT12_MASK              4096
#define ATDDR15_BIT13_MASK              8192
#define ATDDR15_BIT14_MASK              16384
#define ATDDR15_BIT15_MASK              32768
#define ATDDR15_BIT_6_MASK              %BitsMask
#define ATDDR15_BIT_6_BITNUM            %BitsNum


/*** IBAD - IIC Address Register; 0x000000C0 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte ADR1        :1;                                       /* Slave Address Bit 1 */
    byte ADR2        :1;                                       /* Slave Address Bit 2 */
    byte ADR3        :1;                                       /* Slave Address Bit 3 */
    byte ADR4        :1;                                       /* Slave Address Bit 4 */
    byte ADR5        :1;                                       /* Slave Address Bit 5 */
    byte ADR6        :1;                                       /* Slave Address Bit 6 */
    byte ADR7        :1;                                       /* Slave Address Bit 7 */
  } Bits;
  struct {
    byte         :1;
    byte grpADR_1 :7;
  } MergedBits;
} IBADSTR;
extern volatile IBADSTR _IBAD @(REG_BASE + 0x000000C0);
#define IBAD                            _IBAD.Byte
#define IBAD_ADR1                       _IBAD.Bits.ADR1
#define IBAD_ADR2                       _IBAD.Bits.ADR2
#define IBAD_ADR3                       _IBAD.Bits.ADR3
#define IBAD_ADR4                       _IBAD.Bits.ADR4
#define IBAD_ADR5                       _IBAD.Bits.ADR5
#define IBAD_ADR6                       _IBAD.Bits.ADR6
#define IBAD_ADR7                       _IBAD.Bits.ADR7
#define IBAD_ADR_1                      _IBAD.MergedBits.grpADR_1
#define IBAD_ADR                        IBAD_ADR_1

#define IBAD_ADR1_MASK                  2
#define IBAD_ADR2_MASK                  4
#define IBAD_ADR3_MASK                  8
#define IBAD_ADR4_MASK                  16
#define IBAD_ADR5_MASK                  32
#define IBAD_ADR6_MASK                  64
#define IBAD_ADR7_MASK                  128
#define IBAD_ADR_1_MASK                 %BitsMask
#define IBAD_ADR_1_BITNUM               %BitsNum


/*** IBFD - IIC Frequency Divider Register; 0x000000C1 ***/
typedef union {
  byte Byte;
  struct {
    byte IBC0        :1;                                       /* I-Bus Clock Rate 0 */
    byte IBC1        :1;                                       /* I-Bus Clock Rate 1 */
    byte IBC2        :1;                                       /* I-Bus Clock Rate 2 */
    byte IBC3        :1;                                       /* I-Bus Clock Rate 3 */
    byte IBC4        :1;                                       /* I-Bus Clock Rate 4 */
    byte IBC5        :1;                                       /* I-Bus Clock Rate 5 */
    byte IBC6        :1;                                       /* I-Bus Clock Rate 6 */
    byte IBC7        :1;                                       /* I-Bus Clock Rate 7 */
  } Bits;
} IBFDSTR;
extern volatile IBFDSTR _IBFD @(REG_BASE + 0x000000C1);
#define IBFD                            _IBFD.Byte
#define IBFD_IBC0                       _IBFD.Bits.IBC0
#define IBFD_IBC1                       _IBFD.Bits.IBC1
#define IBFD_IBC2                       _IBFD.Bits.IBC2
#define IBFD_IBC3                       _IBFD.Bits.IBC3
#define IBFD_IBC4                       _IBFD.Bits.IBC4
#define IBFD_IBC5                       _IBFD.Bits.IBC5
#define IBFD_IBC6                       _IBFD.Bits.IBC6
#define IBFD_IBC7                       _IBFD.Bits.IBC7

#define IBFD_IBC0_MASK                  1
#define IBFD_IBC1_MASK                  2
#define IBFD_IBC2_MASK                  4
#define IBFD_IBC3_MASK                  8
#define IBFD_IBC4_MASK                  16
#define IBFD_IBC5_MASK                  32
#define IBFD_IBC6_MASK                  64
#define IBFD_IBC7_MASK                  128


/*** IBCR - IIC Control Register; 0x000000C2 ***/
typedef union {
  byte Byte;
  struct {
    byte IBSWAI      :1;                                       /* I-Bus Interface Stop in WAIT mode */
    byte             :1; 
    byte RSTA        :1;                                       /* Repeat Start */
    byte TXAK        :1;                                       /* Transmit Acknowledge enable */
    byte TX_RX       :1;                                       /* Transmit/Receive mode select bit */
    byte MS_SL       :1;                                       /* Master/Slave mode select bit */
    byte IBIE        :1;                                       /* I-Bus Interrupt Enable */
    byte IBEN        :1;                                       /* I-Bus Enable */
  } Bits;
} IBCRSTR;
extern volatile IBCRSTR _IBCR @(REG_BASE + 0x000000C2);
#define IBCR                            _IBCR.Byte
#define IBCR_IBSWAI                     _IBCR.Bits.IBSWAI
#define IBCR_RSTA                       _IBCR.Bits.RSTA
#define IBCR_TXAK                       _IBCR.Bits.TXAK
#define IBCR_TX_RX                      _IBCR.Bits.TX_RX
#define IBCR_MS_SL                      _IBCR.Bits.MS_SL
#define IBCR_IBIE                       _IBCR.Bits.IBIE
#define IBCR_IBEN                       _IBCR.Bits.IBEN

#define IBCR_IBSWAI_MASK                1
#define IBCR_RSTA_MASK                  4
#define IBCR_TXAK_MASK                  8
#define IBCR_TX_RX_MASK                 16
#define IBCR_MS_SL_MASK                 32
#define IBCR_IBIE_MASK                  64
#define IBCR_IBEN_MASK                  128


/*** IBSR - IIC Status Register; 0x000000C3 ***/
typedef union {
  byte Byte;
  struct {
    byte RXAK        :1;                                       /* Received Acknowledge */
    byte IBIF        :1;                                       /* I-Bus Interrupt */
    byte SRW         :1;                                       /* Slave Read/Write */
    byte             :1; 
    byte IBAL        :1;                                       /* Arbitration Lost */
    byte IBB         :1;                                       /* Bus busy bit */
    byte IAAS        :1;                                       /* Addressed as a slave bit */
    byte TCF         :1;                                       /* Data transferring bit */
  } Bits;
} IBSRSTR;
extern volatile IBSRSTR _IBSR @(REG_BASE + 0x000000C3);
#define IBSR                            _IBSR.Byte
#define IBSR_RXAK                       _IBSR.Bits.RXAK
#define IBSR_IBIF                       _IBSR.Bits.IBIF
#define IBSR_SRW                        _IBSR.Bits.SRW
#define IBSR_IBAL                       _IBSR.Bits.IBAL
#define IBSR_IBB                        _IBSR.Bits.IBB
#define IBSR_IAAS                       _IBSR.Bits.IAAS
#define IBSR_TCF                        _IBSR.Bits.TCF

#define IBSR_RXAK_MASK                  1
#define IBSR_IBIF_MASK                  2
#define IBSR_SRW_MASK                   4
#define IBSR_IBAL_MASK                  16
#define IBSR_IBB_MASK                   32
#define IBSR_IAAS_MASK                  64
#define IBSR_TCF_MASK                   128


/*** IBDR - IIC Data I/O Register; 0x000000C4 ***/
typedef union {
  byte Byte;
  struct {
    byte D0          :1;                                       /* IIC Data Bit 0 */
    byte D1          :1;                                       /* IIC Data Bit 1 */
    byte D2          :1;                                       /* IIC Data Bit 2 */
    byte D3          :1;                                       /* IIC Data Bit 3 */
    byte D4          :1;                                       /* IIC Data Bit 4 */
    byte D5          :1;                                       /* IIC Data Bit 5 */
    byte D6          :1;                                       /* IIC Data Bit 6 */
    byte D7          :1;                                       /* IIC Data Bit 7 */
  } Bits;
} IBDRSTR;
extern volatile IBDRSTR _IBDR @(REG_BASE + 0x000000C4);
#define IBDR                            _IBDR.Byte
#define IBDR_D0                         _IBDR.Bits.D0
#define IBDR_D1                         _IBDR.Bits.D1
#define IBDR_D2                         _IBDR.Bits.D2
#define IBDR_D3                         _IBDR.Bits.D3
#define IBDR_D4                         _IBDR.Bits.D4
#define IBDR_D5                         _IBDR.Bits.D5
#define IBDR_D6                         _IBDR.Bits.D6
#define IBDR_D7                         _IBDR.Bits.D7

#define IBDR_D0_MASK                    1
#define IBDR_D1_MASK                    2
#define IBDR_D2_MASK                    4
#define IBDR_D3_MASK                    8
#define IBDR_D4_MASK                    16
#define IBDR_D5_MASK                    32
#define IBDR_D6_MASK                    64
#define IBDR_D7_MASK                    128


/*** SCI0BD - SCI 0 Baud Rate Register; 0x000000C8 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** SCI0BDH - SCI 0 Baud Rate Register High; 0x000000C8 ***/
    union {
      byte Byte;
      struct {
        byte SBR8        :1;                                       /* SCI Baud Rate Bit 8 */
        byte SBR9        :1;                                       /* SCI Baud Rate Bit 9 */
        byte SBR10       :1;                                       /* SCI Baud Rate Bit 10 */
        byte SBR11       :1;                                       /* SCI Baud Rate Bit 11 */
        byte SBR12       :1;                                       /* SCI Baud Rate Bit 12 */
        byte             :1; 
        byte             :1; 
        byte             :1; 
      } Bits;
      struct {
        byte grpSBR_8 :5;
        byte     :1;
        byte     :1;
        byte     :1;
      } MergedBits;
    } SCI0BDHSTR;
    #define SCI0BDH                     _SCI0BD.Overlap_STR.SCI0BDHSTR.Byte
    #define SCI0BDH_SBR8                _SCI0BD.Overlap_STR.SCI0BDHSTR.Bits.SBR8
    #define SCI0BDH_SBR9                _SCI0BD.Overlap_STR.SCI0BDHSTR.Bits.SBR9
    #define SCI0BDH_SBR10               _SCI0BD.Overlap_STR.SCI0BDHSTR.Bits.SBR10
    #define SCI0BDH_SBR11               _SCI0BD.Overlap_STR.SCI0BDHSTR.Bits.SBR11
    #define SCI0BDH_SBR12               _SCI0BD.Overlap_STR.SCI0BDHSTR.Bits.SBR12
    
    #define SCI0BDH_SBR_8               _SCI0BD.Overlap_STR.SCI0BDHSTR.MergedBits.grpSBR_8
    #define SCI0BDH_SBR                 SCI0BDH_SBR_8
    
    #define SCI0BDH_SBR8_MASK           1
    #define SCI0BDH_SBR9_MASK           2
    #define SCI0BDH_SBR10_MASK          4
    #define SCI0BDH_SBR11_MASK          8
    #define SCI0BDH_SBR12_MASK          16
    #define SCI0BDH_SBR_8_MASK          %BitsMask
    #define SCI0BDH_SBR_8_BITNUM        %BitsNum


    /*** SCI0BDL - SCI 0 Baud Rate Register Low; 0x000000C9 ***/
    union {
      byte Byte;
      struct {
        byte SBR0        :1;                                       /* SCI Baud Rate Bit 0 */
        byte SBR1        :1;                                       /* SCI Baud Rate Bit 1 */
        byte SBR2        :1;                                       /* SCI Baud Rate Bit 2 */
        byte SBR3        :1;                                       /* SCI Baud Rate Bit 3 */
        byte SBR4        :1;                                       /* SCI Baud Rate Bit 4 */
        byte SBR5        :1;                                       /* SCI Baud Rate Bit 5 */
        byte SBR6        :1;                                       /* SCI Baud Rate Bit 6 */
        byte SBR7        :1;                                       /* SCI Baud Rate Bit 7 */
      } Bits;
    } SCI0BDLSTR;
    #define SCI0BDL                     _SCI0BD.Overlap_STR.SCI0BDLSTR.Byte
    #define SCI0BDL_SBR0                _SCI0BD.Overlap_STR.SCI0BDLSTR.Bits.SBR0
    #define SCI0BDL_SBR1                _SCI0BD.Overlap_STR.SCI0BDLSTR.Bits.SBR1
    #define SCI0BDL_SBR2                _SCI0BD.Overlap_STR.SCI0BDLSTR.Bits.SBR2
    #define SCI0BDL_SBR3                _SCI0BD.Overlap_STR.SCI0BDLSTR.Bits.SBR3
    #define SCI0BDL_SBR4                _SCI0BD.Overlap_STR.SCI0BDLSTR.Bits.SBR4
    #define SCI0BDL_SBR5                _SCI0BD.Overlap_STR.SCI0BDLSTR.Bits.SBR5
    #define SCI0BDL_SBR6                _SCI0BD.Overlap_STR.SCI0BDLSTR.Bits.SBR6
    #define SCI0BDL_SBR7                _SCI0BD.Overlap_STR.SCI0BDLSTR.Bits.SBR7
    
    
    #define SCI0BDL_SBR0_MASK           1
    #define SCI0BDL_SBR1_MASK           2
    #define SCI0BDL_SBR2_MASK           4
    #define SCI0BDL_SBR3_MASK           8
    #define SCI0BDL_SBR4_MASK           16
    #define SCI0BDL_SBR5_MASK           32
    #define SCI0BDL_SBR6_MASK           64
    #define SCI0BDL_SBR7_MASK           128

  } Overlap_STR;

  struct {
    word SBR0        :1;                                       /* SCI Baud Rate Bit 0 */
    word SBR1        :1;                                       /* SCI Baud Rate Bit 1 */
    word SBR2        :1;                                       /* SCI Baud Rate Bit 2 */
    word SBR3        :1;                                       /* SCI Baud Rate Bit 3 */
    word SBR4        :1;                                       /* SCI Baud Rate Bit 4 */
    word SBR5        :1;                                       /* SCI Baud Rate Bit 5 */
    word SBR6        :1;                                       /* SCI Baud Rate Bit 6 */
    word SBR7        :1;                                       /* SCI Baud Rate Bit 7 */
    word SBR8        :1;                                       /* SCI Baud Rate Bit 8 */
    word SBR9        :1;                                       /* SCI Baud Rate Bit 9 */
    word SBR10       :1;                                       /* SCI Baud Rate Bit 10 */
    word SBR11       :1;                                       /* SCI Baud Rate Bit 11 */
    word SBR12       :1;                                       /* SCI Baud Rate Bit 12 */
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
  struct {
    word grpSBR  :13;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} SCI0BDSTR;
extern volatile SCI0BDSTR _SCI0BD @(REG_BASE + 0x000000C8);
#define SCI0BD                          _SCI0BD.Word
#define SCI0BD_SBR0                     _SCI0BD.Bits.SBR0
#define SCI0BD_SBR1                     _SCI0BD.Bits.SBR1
#define SCI0BD_SBR2                     _SCI0BD.Bits.SBR2
#define SCI0BD_SBR3                     _SCI0BD.Bits.SBR3
#define SCI0BD_SBR4                     _SCI0BD.Bits.SBR4
#define SCI0BD_SBR5                     _SCI0BD.Bits.SBR5
#define SCI0BD_SBR6                     _SCI0BD.Bits.SBR6
#define SCI0BD_SBR7                     _SCI0BD.Bits.SBR7
#define SCI0BD_SBR8                     _SCI0BD.Bits.SBR8
#define SCI0BD_SBR9                     _SCI0BD.Bits.SBR9
#define SCI0BD_SBR10                    _SCI0BD.Bits.SBR10
#define SCI0BD_SBR11                    _SCI0BD.Bits.SBR11
#define SCI0BD_SBR12                    _SCI0BD.Bits.SBR12
#define SCI0BD_SBR                      _SCI0BD.MergedBits.grpSBR

#define SCI0BD_SBR0_MASK                1
#define SCI0BD_SBR1_MASK                2
#define SCI0BD_SBR2_MASK                4
#define SCI0BD_SBR3_MASK                8
#define SCI0BD_SBR4_MASK                16
#define SCI0BD_SBR5_MASK                32
#define SCI0BD_SBR6_MASK                64
#define SCI0BD_SBR7_MASK                128
#define SCI0BD_SBR8_MASK                256
#define SCI0BD_SBR9_MASK                512
#define SCI0BD_SBR10_MASK               1024
#define SCI0BD_SBR11_MASK               2048
#define SCI0BD_SBR12_MASK               4096
#define SCI0BD_SBR_MASK                 %BitsMask
#define SCI0BD_SBR_BITNUM               %BitsNum


/*** SCI0CR1 - SCI 0 Control Register 1; 0x000000CA ***/
typedef union {
  byte Byte;
  struct {
    byte PT          :1;                                       /* Parity Type Bit */
    byte PE          :1;                                       /* Parity Enable Bit */
    byte ILT         :1;                                       /* Idle Line Type Bit */
    byte WAKE        :1;                                       /* Wakeup Condition Bit */
    byte M           :1;                                       /* Data Format Mode Bit */
    byte RSRC        :1;                                       /* Receiver Source Bit */
    byte SCISWAI     :1;                                       /* SCI Stop in Wait Mode Bit */
    byte LOOPS       :1;                                       /* Loop Select Bit */
  } Bits;
} SCI0CR1STR;
extern volatile SCI0CR1STR _SCI0CR1 @(REG_BASE + 0x000000CA);
#define SCI0CR1                         _SCI0CR1.Byte
#define SCI0CR1_PT                      _SCI0CR1.Bits.PT
#define SCI0CR1_PE                      _SCI0CR1.Bits.PE
#define SCI0CR1_ILT                     _SCI0CR1.Bits.ILT
#define SCI0CR1_WAKE                    _SCI0CR1.Bits.WAKE
#define SCI0CR1_M                       _SCI0CR1.Bits.M
#define SCI0CR1_RSRC                    _SCI0CR1.Bits.RSRC
#define SCI0CR1_SCISWAI                 _SCI0CR1.Bits.SCISWAI
#define SCI0CR1_LOOPS                   _SCI0CR1.Bits.LOOPS

#define SCI0CR1_PT_MASK                 1
#define SCI0CR1_PE_MASK                 2
#define SCI0CR1_ILT_MASK                4
#define SCI0CR1_WAKE_MASK               8
#define SCI0CR1_M_MASK                  16
#define SCI0CR1_RSRC_MASK               32
#define SCI0CR1_SCISWAI_MASK            64
#define SCI0CR1_LOOPS_MASK              128


/*** SCI0CR2 - SCI 0 Control Register 2; 0x000000CB ***/
typedef union {
  byte Byte;
  struct {
    byte SBK         :1;                                       /* Send Break Bit */
    byte RWU         :1;                                       /* Receiver Wakeup Bit */
    byte RE          :1;                                       /* Receiver Enable Bit */
    byte TE          :1;                                       /* Transmitter Enable Bit */
    byte ILIE        :1;                                       /* Idle Line Interrupt Enable Bit */
    byte RIE         :1;                                       /* Receiver Full Interrupt Enable Bit */
    byte TCIE        :1;                                       /* Transmission Complete Interrupt Enable Bit */
    byte SCTIE       :1;                                       /* Transmitter Interrupt Enable Bit */
  } Bits;
} SCI0CR2STR;
extern volatile SCI0CR2STR _SCI0CR2 @(REG_BASE + 0x000000CB);
#define SCI0CR2                         _SCI0CR2.Byte
#define SCI0CR2_SBK                     _SCI0CR2.Bits.SBK
#define SCI0CR2_RWU                     _SCI0CR2.Bits.RWU
#define SCI0CR2_RE                      _SCI0CR2.Bits.RE
#define SCI0CR2_TE                      _SCI0CR2.Bits.TE
#define SCI0CR2_ILIE                    _SCI0CR2.Bits.ILIE
#define SCI0CR2_RIE                     _SCI0CR2.Bits.RIE
#define SCI0CR2_TCIE                    _SCI0CR2.Bits.TCIE
#define SCI0CR2_SCTIE                   _SCI0CR2.Bits.SCTIE

#define SCI0CR2_SBK_MASK                1
#define SCI0CR2_RWU_MASK                2
#define SCI0CR2_RE_MASK                 4
#define SCI0CR2_TE_MASK                 8
#define SCI0CR2_ILIE_MASK               16
#define SCI0CR2_RIE_MASK                32
#define SCI0CR2_TCIE_MASK               64
#define SCI0CR2_SCTIE_MASK              128


/*** SCI0SR1 - SCI 0 Status Register 1; 0x000000CC ***/
typedef union {
  byte Byte;
  struct {
    byte PF          :1;                                       /* Parity Error Flag */
    byte FE          :1;                                       /* Framing Error Flag */
    byte NF          :1;                                       /* Noise Flag */
    byte OR          :1;                                       /* Overrun Flag */
    byte IDLE        :1;                                       /* Idle Line Flag */
    byte RDRF        :1;                                       /* Receive Data Register Full Flag */
    byte TC          :1;                                       /* Transmit Complete Flag */
    byte TDRE        :1;                                       /* Transmit Data Register Empty Flag */
  } Bits;
} SCI0SR1STR;
extern volatile SCI0SR1STR _SCI0SR1 @(REG_BASE + 0x000000CC);
#define SCI0SR1                         _SCI0SR1.Byte
#define SCI0SR1_PF                      _SCI0SR1.Bits.PF
#define SCI0SR1_FE                      _SCI0SR1.Bits.FE
#define SCI0SR1_NF                      _SCI0SR1.Bits.NF
#define SCI0SR1_OR                      _SCI0SR1.Bits.OR
#define SCI0SR1_IDLE                    _SCI0SR1.Bits.IDLE
#define SCI0SR1_RDRF                    _SCI0SR1.Bits.RDRF
#define SCI0SR1_TC                      _SCI0SR1.Bits.TC
#define SCI0SR1_TDRE                    _SCI0SR1.Bits.TDRE

#define SCI0SR1_PF_MASK                 1
#define SCI0SR1_FE_MASK                 2
#define SCI0SR1_NF_MASK                 4
#define SCI0SR1_OR_MASK                 8
#define SCI0SR1_IDLE_MASK               16
#define SCI0SR1_RDRF_MASK               32
#define SCI0SR1_TC_MASK                 64
#define SCI0SR1_TDRE_MASK               128


/*** SCI0SR2 - SCI 0 Status Register 2; 0x000000CD ***/
typedef union {
  byte Byte;
  struct {
    byte RAF         :1;                                       /* Receiver Active Flag */
    byte TXDIR       :1;                                       /* Transmitter pin data direction in Single-Wire mode */
    byte BRK13       :1;                                       /* Break Transmit character length */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} SCI0SR2STR;
extern volatile SCI0SR2STR _SCI0SR2 @(REG_BASE + 0x000000CD);
#define SCI0SR2                         _SCI0SR2.Byte
#define SCI0SR2_RAF                     _SCI0SR2.Bits.RAF
#define SCI0SR2_TXDIR                   _SCI0SR2.Bits.TXDIR
#define SCI0SR2_BRK13                   _SCI0SR2.Bits.BRK13

#define SCI0SR2_RAF_MASK                1
#define SCI0SR2_TXDIR_MASK              2
#define SCI0SR2_BRK13_MASK              4


/*** SCI0DRH - SCI 0 Data Register High; 0x000000CE ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte T8          :1;                                       /* Transmit Bit 8 */
    byte R8          :1;                                       /* Received Bit 8 */
  } Bits;
} SCI0DRHSTR;
extern volatile SCI0DRHSTR _SCI0DRH @(REG_BASE + 0x000000CE);
#define SCI0DRH                         _SCI0DRH.Byte
#define SCI0DRH_T8                      _SCI0DRH.Bits.T8
#define SCI0DRH_R8                      _SCI0DRH.Bits.R8

#define SCI0DRH_T8_MASK                 64
#define SCI0DRH_R8_MASK                 128


/*** SCI0DRL - SCI 0 Data Register Low; 0x000000CF ***/
typedef union {
  byte Byte;
  struct {
    byte R0_T0       :1;                                       /* Received bit 0 or Transmit bit 0 */
    byte R1_T1       :1;                                       /* Received bit 1 or Transmit bit 1 */
    byte R2_T2       :1;                                       /* Received bit 2 or Transmit bit 2 */
    byte R3_T3       :1;                                       /* Received bit 3 or Transmit bit 3 */
    byte R4_T4       :1;                                       /* Received bit 4 or Transmit bit 4 */
    byte R5_T5       :1;                                       /* Received bit 5 or Transmit bit 5 */
    byte R6_T6       :1;                                       /* Received bit 6 or Transmit bit 6 */
    byte R7_T7       :1;                                       /* Received bit 7 or Transmit bit 7 */
  } Bits;
} SCI0DRLSTR;
extern volatile SCI0DRLSTR _SCI0DRL @(REG_BASE + 0x000000CF);
#define SCI0DRL                         _SCI0DRL.Byte
#define SCI0DRL_R0_T0                   _SCI0DRL.Bits.R0_T0
#define SCI0DRL_R1_T1                   _SCI0DRL.Bits.R1_T1
#define SCI0DRL_R2_T2                   _SCI0DRL.Bits.R2_T2
#define SCI0DRL_R3_T3                   _SCI0DRL.Bits.R3_T3
#define SCI0DRL_R4_T4                   _SCI0DRL.Bits.R4_T4
#define SCI0DRL_R5_T5                   _SCI0DRL.Bits.R5_T5
#define SCI0DRL_R6_T6                   _SCI0DRL.Bits.R6_T6
#define SCI0DRL_R7_T7                   _SCI0DRL.Bits.R7_T7

#define SCI0DRL_R0_T0_MASK              1
#define SCI0DRL_R1_T1_MASK              2
#define SCI0DRL_R2_T2_MASK              4
#define SCI0DRL_R3_T3_MASK              8
#define SCI0DRL_R4_T4_MASK              16
#define SCI0DRL_R5_T5_MASK              32
#define SCI0DRL_R6_T6_MASK              64
#define SCI0DRL_R7_T7_MASK              128


/*** SCI1BD - SCI 1 Baud Rate Register; 0x000000D0 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** SCI1BDH - SCI 1 Baud Rate Register High; 0x000000D0 ***/
    union {
      byte Byte;
      struct {
        byte SBR8        :1;                                       /* SCI Baud Rate Bit 8 */
        byte SBR9        :1;                                       /* SCI Baud Rate Bit 9 */
        byte SBR10       :1;                                       /* SCI Baud Rate Bit 10 */
        byte SBR11       :1;                                       /* SCI Baud Rate Bit 11 */
        byte SBR12       :1;                                       /* SCI Baud Rate Bit 12 */
        byte             :1; 
        byte             :1; 
        byte             :1; 
      } Bits;
      struct {
        byte grpSBR_8 :5;
        byte     :1;
        byte     :1;
        byte     :1;
      } MergedBits;
    } SCI1BDHSTR;
    #define SCI1BDH                     _SCI1BD.Overlap_STR.SCI1BDHSTR.Byte
    #define SCI1BDH_SBR8                _SCI1BD.Overlap_STR.SCI1BDHSTR.Bits.SBR8
    #define SCI1BDH_SBR9                _SCI1BD.Overlap_STR.SCI1BDHSTR.Bits.SBR9
    #define SCI1BDH_SBR10               _SCI1BD.Overlap_STR.SCI1BDHSTR.Bits.SBR10
    #define SCI1BDH_SBR11               _SCI1BD.Overlap_STR.SCI1BDHSTR.Bits.SBR11
    #define SCI1BDH_SBR12               _SCI1BD.Overlap_STR.SCI1BDHSTR.Bits.SBR12
    
    #define SCI1BDH_SBR_8               _SCI1BD.Overlap_STR.SCI1BDHSTR.MergedBits.grpSBR_8
    #define SCI1BDH_SBR                 SCI1BDH_SBR_8
    
    #define SCI1BDH_SBR8_MASK           1
    #define SCI1BDH_SBR9_MASK           2
    #define SCI1BDH_SBR10_MASK          4
    #define SCI1BDH_SBR11_MASK          8
    #define SCI1BDH_SBR12_MASK          16
    #define SCI1BDH_SBR_8_MASK          %BitsMask
    #define SCI1BDH_SBR_8_BITNUM        %BitsNum


    /*** SCI1BDL - SCI 1 Baud Rate Register Low; 0x000000D1 ***/
    union {
      byte Byte;
      struct {
        byte SBR0        :1;                                       /* SCI Baud Rate Bit 0 */
        byte SBR1        :1;                                       /* SCI Baud Rate Bit 1 */
        byte SBR2        :1;                                       /* SCI Baud Rate Bit 2 */
        byte SBR3        :1;                                       /* SCI Baud Rate Bit 3 */
        byte SBR4        :1;                                       /* SCI Baud Rate Bit 4 */
        byte SBR5        :1;                                       /* SCI Baud Rate Bit 5 */
        byte SBR6        :1;                                       /* SCI Baud Rate Bit 6 */
        byte SBR7        :1;                                       /* SCI Baud Rate Bit 7 */
      } Bits;
    } SCI1BDLSTR;
    #define SCI1BDL                     _SCI1BD.Overlap_STR.SCI1BDLSTR.Byte
    #define SCI1BDL_SBR0                _SCI1BD.Overlap_STR.SCI1BDLSTR.Bits.SBR0
    #define SCI1BDL_SBR1                _SCI1BD.Overlap_STR.SCI1BDLSTR.Bits.SBR1
    #define SCI1BDL_SBR2                _SCI1BD.Overlap_STR.SCI1BDLSTR.Bits.SBR2
    #define SCI1BDL_SBR3                _SCI1BD.Overlap_STR.SCI1BDLSTR.Bits.SBR3
    #define SCI1BDL_SBR4                _SCI1BD.Overlap_STR.SCI1BDLSTR.Bits.SBR4
    #define SCI1BDL_SBR5                _SCI1BD.Overlap_STR.SCI1BDLSTR.Bits.SBR5
    #define SCI1BDL_SBR6                _SCI1BD.Overlap_STR.SCI1BDLSTR.Bits.SBR6
    #define SCI1BDL_SBR7                _SCI1BD.Overlap_STR.SCI1BDLSTR.Bits.SBR7
    
    
    #define SCI1BDL_SBR0_MASK           1
    #define SCI1BDL_SBR1_MASK           2
    #define SCI1BDL_SBR2_MASK           4
    #define SCI1BDL_SBR3_MASK           8
    #define SCI1BDL_SBR4_MASK           16
    #define SCI1BDL_SBR5_MASK           32
    #define SCI1BDL_SBR6_MASK           64
    #define SCI1BDL_SBR7_MASK           128

  } Overlap_STR;

  struct {
    word SBR0        :1;                                       /* SCI Baud Rate Bit 0 */
    word SBR1        :1;                                       /* SCI Baud Rate Bit 1 */
    word SBR2        :1;                                       /* SCI Baud Rate Bit 2 */
    word SBR3        :1;                                       /* SCI Baud Rate Bit 3 */
    word SBR4        :1;                                       /* SCI Baud Rate Bit 4 */
    word SBR5        :1;                                       /* SCI Baud Rate Bit 5 */
    word SBR6        :1;                                       /* SCI Baud Rate Bit 6 */
    word SBR7        :1;                                       /* SCI Baud Rate Bit 7 */
    word SBR8        :1;                                       /* SCI Baud Rate Bit 8 */
    word SBR9        :1;                                       /* SCI Baud Rate Bit 9 */
    word SBR10       :1;                                       /* SCI Baud Rate Bit 10 */
    word SBR11       :1;                                       /* SCI Baud Rate Bit 11 */
    word SBR12       :1;                                       /* SCI Baud Rate Bit 12 */
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
  struct {
    word grpSBR  :13;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} SCI1BDSTR;
extern volatile SCI1BDSTR _SCI1BD @(REG_BASE + 0x000000D0);
#define SCI1BD                          _SCI1BD.Word
#define SCI1BD_SBR0                     _SCI1BD.Bits.SBR0
#define SCI1BD_SBR1                     _SCI1BD.Bits.SBR1
#define SCI1BD_SBR2                     _SCI1BD.Bits.SBR2
#define SCI1BD_SBR3                     _SCI1BD.Bits.SBR3
#define SCI1BD_SBR4                     _SCI1BD.Bits.SBR4
#define SCI1BD_SBR5                     _SCI1BD.Bits.SBR5
#define SCI1BD_SBR6                     _SCI1BD.Bits.SBR6
#define SCI1BD_SBR7                     _SCI1BD.Bits.SBR7
#define SCI1BD_SBR8                     _SCI1BD.Bits.SBR8
#define SCI1BD_SBR9                     _SCI1BD.Bits.SBR9
#define SCI1BD_SBR10                    _SCI1BD.Bits.SBR10
#define SCI1BD_SBR11                    _SCI1BD.Bits.SBR11
#define SCI1BD_SBR12                    _SCI1BD.Bits.SBR12
#define SCI1BD_SBR                      _SCI1BD.MergedBits.grpSBR

#define SCI1BD_SBR0_MASK                1
#define SCI1BD_SBR1_MASK                2
#define SCI1BD_SBR2_MASK                4
#define SCI1BD_SBR3_MASK                8
#define SCI1BD_SBR4_MASK                16
#define SCI1BD_SBR5_MASK                32
#define SCI1BD_SBR6_MASK                64
#define SCI1BD_SBR7_MASK                128
#define SCI1BD_SBR8_MASK                256
#define SCI1BD_SBR9_MASK                512
#define SCI1BD_SBR10_MASK               1024
#define SCI1BD_SBR11_MASK               2048
#define SCI1BD_SBR12_MASK               4096
#define SCI1BD_SBR_MASK                 %BitsMask
#define SCI1BD_SBR_BITNUM               %BitsNum


/*** SCI1CR1 - SCI 1 Control Register 1; 0x000000D2 ***/
typedef union {
  byte Byte;
  struct {
    byte PT          :1;                                       /* Parity Type Bit */
    byte PE          :1;                                       /* Parity Enable Bit */
    byte ILT         :1;                                       /* Idle Line Type Bit */
    byte WAKE        :1;                                       /* Wakeup Condition Bit */
    byte M           :1;                                       /* Data Format Mode Bit */
    byte RSRC        :1;                                       /* Receiver Source Bit */
    byte SCISWAI     :1;                                       /* SCI Stop in Wait Mode Bit */
    byte LOOPS       :1;                                       /* Loop Select Bit */
  } Bits;
} SCI1CR1STR;
extern volatile SCI1CR1STR _SCI1CR1 @(REG_BASE + 0x000000D2);
#define SCI1CR1                         _SCI1CR1.Byte
#define SCI1CR1_PT                      _SCI1CR1.Bits.PT
#define SCI1CR1_PE                      _SCI1CR1.Bits.PE
#define SCI1CR1_ILT                     _SCI1CR1.Bits.ILT
#define SCI1CR1_WAKE                    _SCI1CR1.Bits.WAKE
#define SCI1CR1_M                       _SCI1CR1.Bits.M
#define SCI1CR1_RSRC                    _SCI1CR1.Bits.RSRC
#define SCI1CR1_SCISWAI                 _SCI1CR1.Bits.SCISWAI
#define SCI1CR1_LOOPS                   _SCI1CR1.Bits.LOOPS

#define SCI1CR1_PT_MASK                 1
#define SCI1CR1_PE_MASK                 2
#define SCI1CR1_ILT_MASK                4
#define SCI1CR1_WAKE_MASK               8
#define SCI1CR1_M_MASK                  16
#define SCI1CR1_RSRC_MASK               32
#define SCI1CR1_SCISWAI_MASK            64
#define SCI1CR1_LOOPS_MASK              128


/*** SCI1CR2 - SCI 1 Control Register 2; 0x000000D3 ***/
typedef union {
  byte Byte;
  struct {
    byte SBK         :1;                                       /* Send Break Bit */
    byte RWU         :1;                                       /* Receiver Wakeup Bit */
    byte RE          :1;                                       /* Receiver Enable Bit */
    byte TE          :1;                                       /* Transmitter Enable Bit */
    byte ILIE        :1;                                       /* Idle Line Interrupt Enable Bit */
    byte RIE         :1;                                       /* Receiver Full Interrupt Enable Bit */
    byte TCIE        :1;                                       /* Transmission Complete Interrupt Enable Bit */
    byte SCTIE       :1;                                       /* Transmitter Interrupt Enable Bit */
  } Bits;
} SCI1CR2STR;
extern volatile SCI1CR2STR _SCI1CR2 @(REG_BASE + 0x000000D3);
#define SCI1CR2                         _SCI1CR2.Byte
#define SCI1CR2_SBK                     _SCI1CR2.Bits.SBK
#define SCI1CR2_RWU                     _SCI1CR2.Bits.RWU
#define SCI1CR2_RE                      _SCI1CR2.Bits.RE
#define SCI1CR2_TE                      _SCI1CR2.Bits.TE
#define SCI1CR2_ILIE                    _SCI1CR2.Bits.ILIE
#define SCI1CR2_RIE                     _SCI1CR2.Bits.RIE
#define SCI1CR2_TCIE                    _SCI1CR2.Bits.TCIE
#define SCI1CR2_SCTIE                   _SCI1CR2.Bits.SCTIE

#define SCI1CR2_SBK_MASK                1
#define SCI1CR2_RWU_MASK                2
#define SCI1CR2_RE_MASK                 4
#define SCI1CR2_TE_MASK                 8
#define SCI1CR2_ILIE_MASK               16
#define SCI1CR2_RIE_MASK                32
#define SCI1CR2_TCIE_MASK               64
#define SCI1CR2_SCTIE_MASK              128


/*** SCI1SR1 - SCI 1 Status Register 1; 0x000000D4 ***/
typedef union {
  byte Byte;
  struct {
    byte PF          :1;                                       /* Parity Error Flag */
    byte FE          :1;                                       /* Framing Error Flag */
    byte NF          :1;                                       /* Noise Flag */
    byte OR          :1;                                       /* Overrun Flag */
    byte IDLE        :1;                                       /* Idle Line Flag */
    byte RDRF        :1;                                       /* Receive Data Register Full Flag */
    byte TC          :1;                                       /* Transmit Complete Flag */
    byte TDRE        :1;                                       /* Transmit Data Register Empty Flag */
  } Bits;
} SCI1SR1STR;
extern volatile SCI1SR1STR _SCI1SR1 @(REG_BASE + 0x000000D4);
#define SCI1SR1                         _SCI1SR1.Byte
#define SCI1SR1_PF                      _SCI1SR1.Bits.PF
#define SCI1SR1_FE                      _SCI1SR1.Bits.FE
#define SCI1SR1_NF                      _SCI1SR1.Bits.NF
#define SCI1SR1_OR                      _SCI1SR1.Bits.OR
#define SCI1SR1_IDLE                    _SCI1SR1.Bits.IDLE
#define SCI1SR1_RDRF                    _SCI1SR1.Bits.RDRF
#define SCI1SR1_TC                      _SCI1SR1.Bits.TC
#define SCI1SR1_TDRE                    _SCI1SR1.Bits.TDRE

#define SCI1SR1_PF_MASK                 1
#define SCI1SR1_FE_MASK                 2
#define SCI1SR1_NF_MASK                 4
#define SCI1SR1_OR_MASK                 8
#define SCI1SR1_IDLE_MASK               16
#define SCI1SR1_RDRF_MASK               32
#define SCI1SR1_TC_MASK                 64
#define SCI1SR1_TDRE_MASK               128


/*** SCI1SR2 - SCI 1 Status Register 2; 0x000000D5 ***/
typedef union {
  byte Byte;
  struct {
    byte RAF         :1;                                       /* Receiver Active Flag */
    byte TXDIR       :1;                                       /* Transmitter pin data direction in Single-Wire mode */
    byte BRK13       :1;                                       /* Break Transmit character length */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} SCI1SR2STR;
extern volatile SCI1SR2STR _SCI1SR2 @(REG_BASE + 0x000000D5);
#define SCI1SR2                         _SCI1SR2.Byte
#define SCI1SR2_RAF                     _SCI1SR2.Bits.RAF
#define SCI1SR2_TXDIR                   _SCI1SR2.Bits.TXDIR
#define SCI1SR2_BRK13                   _SCI1SR2.Bits.BRK13

#define SCI1SR2_RAF_MASK                1
#define SCI1SR2_TXDIR_MASK              2
#define SCI1SR2_BRK13_MASK              4


/*** SCI1DRH - SCI 1 Data Register High; 0x000000D6 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte T8          :1;                                       /* Transmit Bit 8 */
    byte R8          :1;                                       /* Received Bit 8 */
  } Bits;
} SCI1DRHSTR;
extern volatile SCI1DRHSTR _SCI1DRH @(REG_BASE + 0x000000D6);
#define SCI1DRH                         _SCI1DRH.Byte
#define SCI1DRH_T8                      _SCI1DRH.Bits.T8
#define SCI1DRH_R8                      _SCI1DRH.Bits.R8

#define SCI1DRH_T8_MASK                 64
#define SCI1DRH_R8_MASK                 128


/*** SCI1DRL - SCI 1 Data Register Low; 0x000000D7 ***/
typedef union {
  byte Byte;
  struct {
    byte R0_T0       :1;                                       /* Received bit 0 or Transmit bit 0 */
    byte R1_T1       :1;                                       /* Received bit 1 or Transmit bit 1 */
    byte R2_T2       :1;                                       /* Received bit 2 or Transmit bit 2 */
    byte R3_T3       :1;                                       /* Received bit 3 or Transmit bit 3 */
    byte R4_T4       :1;                                       /* Received bit 4 or Transmit bit 4 */
    byte R5_T5       :1;                                       /* Received bit 5 or Transmit bit 5 */
    byte R6_T6       :1;                                       /* Received bit 6 or Transmit bit 6 */
    byte R7_T7       :1;                                       /* Received bit 7 or Transmit bit 7 */
  } Bits;
} SCI1DRLSTR;
extern volatile SCI1DRLSTR _SCI1DRL @(REG_BASE + 0x000000D7);
#define SCI1DRL                         _SCI1DRL.Byte
#define SCI1DRL_R0_T0                   _SCI1DRL.Bits.R0_T0
#define SCI1DRL_R1_T1                   _SCI1DRL.Bits.R1_T1
#define SCI1DRL_R2_T2                   _SCI1DRL.Bits.R2_T2
#define SCI1DRL_R3_T3                   _SCI1DRL.Bits.R3_T3
#define SCI1DRL_R4_T4                   _SCI1DRL.Bits.R4_T4
#define SCI1DRL_R5_T5                   _SCI1DRL.Bits.R5_T5
#define SCI1DRL_R6_T6                   _SCI1DRL.Bits.R6_T6
#define SCI1DRL_R7_T7                   _SCI1DRL.Bits.R7_T7

#define SCI1DRL_R0_T0_MASK              1
#define SCI1DRL_R1_T1_MASK              2
#define SCI1DRL_R2_T2_MASK              4
#define SCI1DRL_R3_T3_MASK              8
#define SCI1DRL_R4_T4_MASK              16
#define SCI1DRL_R5_T5_MASK              32
#define SCI1DRL_R6_T6_MASK              64
#define SCI1DRL_R7_T7_MASK              128


/*** SPI0CR1 - SPI 0 Control Register; 0x000000D8 ***/
typedef union {
  byte Byte;
  struct {
    byte LSBFE       :1;                                       /* SPI LSB-First Enable */
    byte SSOE        :1;                                       /* Slave Select Output Enable */
    byte CPHA        :1;                                       /* SPI Clock Phase Bit */
    byte CPOL        :1;                                       /* SPI Clock Polarity Bit */
    byte MSTR        :1;                                       /* SPI Master/Slave Mode Select Bit */
    byte SPTIE       :1;                                       /* SPI Transmit Interrupt Enable */
    byte SPE         :1;                                       /* SPI System Enable Bit */
    byte SPIE        :1;                                       /* SPI Interrupt Enable Bit */
  } Bits;
} SPI0CR1STR;
extern volatile SPI0CR1STR _SPI0CR1 @(REG_BASE + 0x000000D8);
#define SPI0CR1                         _SPI0CR1.Byte
#define SPI0CR1_LSBFE                   _SPI0CR1.Bits.LSBFE
#define SPI0CR1_SSOE                    _SPI0CR1.Bits.SSOE
#define SPI0CR1_CPHA                    _SPI0CR1.Bits.CPHA
#define SPI0CR1_CPOL                    _SPI0CR1.Bits.CPOL
#define SPI0CR1_MSTR                    _SPI0CR1.Bits.MSTR
#define SPI0CR1_SPTIE                   _SPI0CR1.Bits.SPTIE
#define SPI0CR1_SPE                     _SPI0CR1.Bits.SPE
#define SPI0CR1_SPIE                    _SPI0CR1.Bits.SPIE

#define SPI0CR1_LSBFE_MASK              1
#define SPI0CR1_SSOE_MASK               2
#define SPI0CR1_CPHA_MASK               4
#define SPI0CR1_CPOL_MASK               8
#define SPI0CR1_MSTR_MASK               16
#define SPI0CR1_SPTIE_MASK              32
#define SPI0CR1_SPE_MASK                64
#define SPI0CR1_SPIE_MASK               128


/*** SPI0CR2 - SPI 0 Control Register 2; 0x000000D9 ***/
typedef union {
  byte Byte;
  struct {
    byte SPC0        :1;                                       /* Serial Pin Control Bit 0 */
    byte SPISWAI     :1;                                       /* SPI Stop in Wait Mode Bit */
    byte             :1; 
    byte BIDIROE     :1;                                       /* Output enable in the Bidirectional mode of operation */
    byte MODFEN      :1;                                       /* Mode Fault Enable Bit */
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} SPI0CR2STR;
extern volatile SPI0CR2STR _SPI0CR2 @(REG_BASE + 0x000000D9);
#define SPI0CR2                         _SPI0CR2.Byte
#define SPI0CR2_SPC0                    _SPI0CR2.Bits.SPC0
#define SPI0CR2_SPISWAI                 _SPI0CR2.Bits.SPISWAI
#define SPI0CR2_BIDIROE                 _SPI0CR2.Bits.BIDIROE
#define SPI0CR2_MODFEN                  _SPI0CR2.Bits.MODFEN

#define SPI0CR2_SPC0_MASK               1
#define SPI0CR2_SPISWAI_MASK            2
#define SPI0CR2_BIDIROE_MASK            8
#define SPI0CR2_MODFEN_MASK             16


/*** SPI0BR - SPI 0 Baud Rate Register; 0x000000DA ***/
typedef union {
  byte Byte;
  struct {
    byte SPR0        :1;                                       /* SPI Baud Rate Selection Bit 0 */
    byte SPR1        :1;                                       /* SPI Baud Rate Selection Bit 1 */
    byte SPR2        :1;                                       /* SPI Baud Rate Selection Bit 2 */
    byte             :1; 
    byte SPPR0       :1;                                       /* SPI Baud Rate Preselection Bits 0 */
    byte SPPR1       :1;                                       /* SPI Baud Rate Preselection Bits 1 */
    byte SPPR2       :1;                                       /* SPI Baud Rate Preselection Bits 2 */
    byte             :1; 
  } Bits;
  struct {
    byte grpSPR  :3;
    byte         :1;
    byte grpSPPR :3;
    byte         :1;
  } MergedBits;
} SPI0BRSTR;
extern volatile SPI0BRSTR _SPI0BR @(REG_BASE + 0x000000DA);
#define SPI0BR                          _SPI0BR.Byte
#define SPI0BR_SPR0                     _SPI0BR.Bits.SPR0
#define SPI0BR_SPR1                     _SPI0BR.Bits.SPR1
#define SPI0BR_SPR2                     _SPI0BR.Bits.SPR2
#define SPI0BR_SPPR0                    _SPI0BR.Bits.SPPR0
#define SPI0BR_SPPR1                    _SPI0BR.Bits.SPPR1
#define SPI0BR_SPPR2                    _SPI0BR.Bits.SPPR2
#define SPI0BR_SPR                      _SPI0BR.MergedBits.grpSPR
#define SPI0BR_SPPR                     _SPI0BR.MergedBits.grpSPPR

#define SPI0BR_SPR0_MASK                1
#define SPI0BR_SPR1_MASK                2
#define SPI0BR_SPR2_MASK                4
#define SPI0BR_SPPR0_MASK               16
#define SPI0BR_SPPR1_MASK               32
#define SPI0BR_SPPR2_MASK               64
#define SPI0BR_SPR_MASK                 %BitsMask
#define SPI0BR_SPR_BITNUM               %BitsNum
#define SPI0BR_SPPR_MASK                %BitsMask
#define SPI0BR_SPPR_BITNUM              %BitsNum


/*** SPI0SR - SPI 0 Status Register; 0x000000DB ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte MODF        :1;                                       /* Mode Fault Flag */
    byte SPTEF       :1;                                       /* SPI Transmit Empty Interrupt Flag */
    byte             :1; 
    byte SPIF        :1;                                       /* SPIF Receive Interrupt Flag */
  } Bits;
} SPI0SRSTR;
extern volatile SPI0SRSTR _SPI0SR @(REG_BASE + 0x000000DB);
#define SPI0SR                          _SPI0SR.Byte
#define SPI0SR_MODF                     _SPI0SR.Bits.MODF
#define SPI0SR_SPTEF                    _SPI0SR.Bits.SPTEF
#define SPI0SR_SPIF                     _SPI0SR.Bits.SPIF

#define SPI0SR_MODF_MASK                16
#define SPI0SR_SPTEF_MASK               32
#define SPI0SR_SPIF_MASK                128


/*** SPI0DR - SPI 0 Data Register; 0x000000DD ***/
typedef union {
  byte Byte;
} SPI0DRSTR;
extern volatile SPI0DRSTR _SPI0DR @(REG_BASE + 0x000000DD);
#define SPI0DR                          _SPI0DR.Byte



/*** PWME - PWM Enable Register; 0x000000E0 ***/
typedef union {
  byte Byte;
  struct {
    byte PWME0       :1;                                       /* Pulse Width Channel 0 Enable */
    byte PWME1       :1;                                       /* Pulse Width Channel 1 Enable */
    byte PWME2       :1;                                       /* Pulse Width Channel 2 Enable */
    byte PWME3       :1;                                       /* Pulse Width Channel 3 Enable */
    byte PWME4       :1;                                       /* Pulse Width Channel 4 Enable */
    byte PWME5       :1;                                       /* Pulse Width Channel 5 Enable */
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpPWME :6;
    byte         :1;
    byte         :1;
  } MergedBits;
} PWMESTR;
extern volatile PWMESTR _PWME @(REG_BASE + 0x000000E0);
#define PWME                            _PWME.Byte
#define PWME_PWME0                      _PWME.Bits.PWME0
#define PWME_PWME1                      _PWME.Bits.PWME1
#define PWME_PWME2                      _PWME.Bits.PWME2
#define PWME_PWME3                      _PWME.Bits.PWME3
#define PWME_PWME4                      _PWME.Bits.PWME4
#define PWME_PWME5                      _PWME.Bits.PWME5
#define PWME_PWME                       _PWME.MergedBits.grpPWME

#define PWME_PWME0_MASK                 1
#define PWME_PWME1_MASK                 2
#define PWME_PWME2_MASK                 4
#define PWME_PWME3_MASK                 8
#define PWME_PWME4_MASK                 16
#define PWME_PWME5_MASK                 32
#define PWME_PWME_MASK                  %BitsMask
#define PWME_PWME_BITNUM                %BitsNum


/*** PWMPOL - PWM Polarity Register; 0x000000E1 ***/
typedef union {
  byte Byte;
  struct {
    byte PPOL0       :1;                                       /* Pulse Width Channel 0 Polarity */
    byte PPOL1       :1;                                       /* Pulse Width Channel 1 Polarity */
    byte PPOL2       :1;                                       /* Pulse Width Channel 2 Polarity */
    byte PPOL3       :1;                                       /* Pulse Width Channel 3 Polarity */
    byte PPOL4       :1;                                       /* Pulse Width Channel 4 Polarity */
    byte PPOL5       :1;                                       /* Pulse Width Channel 5 Polarity */
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpPPOL :6;
    byte         :1;
    byte         :1;
  } MergedBits;
} PWMPOLSTR;
extern volatile PWMPOLSTR _PWMPOL @(REG_BASE + 0x000000E1);
#define PWMPOL                          _PWMPOL.Byte
#define PWMPOL_PPOL0                    _PWMPOL.Bits.PPOL0
#define PWMPOL_PPOL1                    _PWMPOL.Bits.PPOL1
#define PWMPOL_PPOL2                    _PWMPOL.Bits.PPOL2
#define PWMPOL_PPOL3                    _PWMPOL.Bits.PPOL3
#define PWMPOL_PPOL4                    _PWMPOL.Bits.PPOL4
#define PWMPOL_PPOL5                    _PWMPOL.Bits.PPOL5
#define PWMPOL_PPOL                     _PWMPOL.MergedBits.grpPPOL

#define PWMPOL_PPOL0_MASK               1
#define PWMPOL_PPOL1_MASK               2
#define PWMPOL_PPOL2_MASK               4
#define PWMPOL_PPOL3_MASK               8
#define PWMPOL_PPOL4_MASK               16
#define PWMPOL_PPOL5_MASK               32
#define PWMPOL_PPOL_MASK                %BitsMask
#define PWMPOL_PPOL_BITNUM              %BitsNum


/*** PWMCLK - PWM Clock Select Register; 0x000000E2 ***/
typedef union {
  byte Byte;
  struct {
    byte PCLK0       :1;                                       /* Pulse Width Channel 0 Clock Select */
    byte PCLK1       :1;                                       /* Pulse Width Channel 1 Clock Select */
    byte PCLK2       :1;                                       /* Pulse Width Channel 2 Clock Select */
    byte PCLK3       :1;                                       /* Pulse Width Channel 3 Clock Select */
    byte PCLK4       :1;                                       /* Pulse Width Channel 4 Clock Select */
    byte PCLK5       :1;                                       /* Pulse Width Channel 5 Clock Select */
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpPCLK :6;
    byte         :1;
    byte         :1;
  } MergedBits;
} PWMCLKSTR;
extern volatile PWMCLKSTR _PWMCLK @(REG_BASE + 0x000000E2);
#define PWMCLK                          _PWMCLK.Byte
#define PWMCLK_PCLK0                    _PWMCLK.Bits.PCLK0
#define PWMCLK_PCLK1                    _PWMCLK.Bits.PCLK1
#define PWMCLK_PCLK2                    _PWMCLK.Bits.PCLK2
#define PWMCLK_PCLK3                    _PWMCLK.Bits.PCLK3
#define PWMCLK_PCLK4                    _PWMCLK.Bits.PCLK4
#define PWMCLK_PCLK5                    _PWMCLK.Bits.PCLK5
#define PWMCLK_PCLK                     _PWMCLK.MergedBits.grpPCLK

#define PWMCLK_PCLK0_MASK               1
#define PWMCLK_PCLK1_MASK               2
#define PWMCLK_PCLK2_MASK               4
#define PWMCLK_PCLK3_MASK               8
#define PWMCLK_PCLK4_MASK               16
#define PWMCLK_PCLK5_MASK               32
#define PWMCLK_PCLK_MASK                %BitsMask
#define PWMCLK_PCLK_BITNUM              %BitsNum


/*** PWMPRCLK - PWM Prescale Clock Select Register; 0x000000E3 ***/
typedef union {
  byte Byte;
  struct {
    byte PCKA0       :1;                                       /* Prescaler Select for Clock A 0 */
    byte PCKA1       :1;                                       /* Prescaler Select for Clock A 1 */
    byte PCKA2       :1;                                       /* Prescaler Select for Clock A 2 */
    byte             :1; 
    byte PCKB0       :1;                                       /* Prescaler Select for Clock B 0 */
    byte PCKB1       :1;                                       /* Prescaler Select for Clock B 1 */
    byte PCKB2       :1;                                       /* Prescaler Select for Clock B 2 */
    byte             :1; 
  } Bits;
  struct {
    byte grpPCKA :3;
    byte         :1;
    byte grpPCKB :3;
    byte         :1;
  } MergedBits;
} PWMPRCLKSTR;
extern volatile PWMPRCLKSTR _PWMPRCLK @(REG_BASE + 0x000000E3);
#define PWMPRCLK                        _PWMPRCLK.Byte
#define PWMPRCLK_PCKA0                  _PWMPRCLK.Bits.PCKA0
#define PWMPRCLK_PCKA1                  _PWMPRCLK.Bits.PCKA1
#define PWMPRCLK_PCKA2                  _PWMPRCLK.Bits.PCKA2
#define PWMPRCLK_PCKB0                  _PWMPRCLK.Bits.PCKB0
#define PWMPRCLK_PCKB1                  _PWMPRCLK.Bits.PCKB1
#define PWMPRCLK_PCKB2                  _PWMPRCLK.Bits.PCKB2
#define PWMPRCLK_PCKA                   _PWMPRCLK.MergedBits.grpPCKA
#define PWMPRCLK_PCKB                   _PWMPRCLK.MergedBits.grpPCKB

#define PWMPRCLK_PCKA0_MASK             1
#define PWMPRCLK_PCKA1_MASK             2
#define PWMPRCLK_PCKA2_MASK             4
#define PWMPRCLK_PCKB0_MASK             16
#define PWMPRCLK_PCKB1_MASK             32
#define PWMPRCLK_PCKB2_MASK             64
#define PWMPRCLK_PCKA_MASK              %BitsMask
#define PWMPRCLK_PCKA_BITNUM            %BitsNum
#define PWMPRCLK_PCKB_MASK              %BitsMask
#define PWMPRCLK_PCKB_BITNUM            %BitsNum


/*** PWMCAE - PWM Center Align Enable Register; 0x000000E4 ***/
typedef union {
  byte Byte;
  struct {
    byte CAE0        :1;                                       /* Center Aligned Output Mode on channel 0 */
    byte CAE1        :1;                                       /* Center Aligned Output Mode on channel 1 */
    byte CAE2        :1;                                       /* Center Aligned Output Mode on channel 2 */
    byte CAE3        :1;                                       /* Center Aligned Output Mode on channel 3 */
    byte CAE4        :1;                                       /* Center Aligned Output Mode on channel 4 */
    byte CAE5        :1;                                       /* Center Aligned Output Mode on channel 5 */
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpCAE  :6;
    byte         :1;
    byte         :1;
  } MergedBits;
} PWMCAESTR;
extern volatile PWMCAESTR _PWMCAE @(REG_BASE + 0x000000E4);
#define PWMCAE                          _PWMCAE.Byte
#define PWMCAE_CAE0                     _PWMCAE.Bits.CAE0
#define PWMCAE_CAE1                     _PWMCAE.Bits.CAE1
#define PWMCAE_CAE2                     _PWMCAE.Bits.CAE2
#define PWMCAE_CAE3                     _PWMCAE.Bits.CAE3
#define PWMCAE_CAE4                     _PWMCAE.Bits.CAE4
#define PWMCAE_CAE5                     _PWMCAE.Bits.CAE5
#define PWMCAE_CAE                      _PWMCAE.MergedBits.grpCAE

#define PWMCAE_CAE0_MASK                1
#define PWMCAE_CAE1_MASK                2
#define PWMCAE_CAE2_MASK                4
#define PWMCAE_CAE3_MASK                8
#define PWMCAE_CAE4_MASK                16
#define PWMCAE_CAE5_MASK                32
#define PWMCAE_CAE_MASK                 %BitsMask
#define PWMCAE_CAE_BITNUM               %BitsNum


/*** PWMCTL - PWM Control Register; 0x000000E5 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte PFRZ        :1;                                       /* PWM Counters Stop in Freeze Mode */
    byte PSWAI       :1;                                       /* PWM Stops in Wait Mode */
    byte CON01       :1;                                       /* Concatenate channels 0 and 1 */
    byte CON23       :1;                                       /* Concatenate channels 2 and 3 */
    byte CON45       :1;                                       /* Concatenate channels 4 and 5 */
    byte             :1; 
  } Bits;
} PWMCTLSTR;
extern volatile PWMCTLSTR _PWMCTL @(REG_BASE + 0x000000E5);
#define PWMCTL                          _PWMCTL.Byte
#define PWMCTL_PFRZ                     _PWMCTL.Bits.PFRZ
#define PWMCTL_PSWAI                    _PWMCTL.Bits.PSWAI
#define PWMCTL_CON01                    _PWMCTL.Bits.CON01
#define PWMCTL_CON23                    _PWMCTL.Bits.CON23
#define PWMCTL_CON45                    _PWMCTL.Bits.CON45

#define PWMCTL_PFRZ_MASK                4
#define PWMCTL_PSWAI_MASK               8
#define PWMCTL_CON01_MASK               16
#define PWMCTL_CON23_MASK               32
#define PWMCTL_CON45_MASK               64


/*** PWMSCLA - PWM Scale A Register; 0x000000E8 ***/
typedef union {
  byte Byte;
  struct {
    byte BIT0        :1;                                       /* PWM Scale A Bit 0 */
    byte BIT1        :1;                                       /* PWM Scale A Bit 1 */
    byte BIT2        :1;                                       /* PWM Scale A Bit 2 */
    byte BIT3        :1;                                       /* PWM Scale A Bit 3 */
    byte BIT4        :1;                                       /* PWM Scale A Bit 4 */
    byte BIT5        :1;                                       /* PWM Scale A Bit 5 */
    byte BIT6        :1;                                       /* PWM Scale A Bit 6 */
    byte BIT7        :1;                                       /* PWM Scale A Bit 7 */
  } Bits;
} PWMSCLASTR;
extern volatile PWMSCLASTR _PWMSCLA @(REG_BASE + 0x000000E8);
#define PWMSCLA                         _PWMSCLA.Byte
#define PWMSCLA_BIT0                    _PWMSCLA.Bits.BIT0
#define PWMSCLA_BIT1                    _PWMSCLA.Bits.BIT1
#define PWMSCLA_BIT2                    _PWMSCLA.Bits.BIT2
#define PWMSCLA_BIT3                    _PWMSCLA.Bits.BIT3
#define PWMSCLA_BIT4                    _PWMSCLA.Bits.BIT4
#define PWMSCLA_BIT5                    _PWMSCLA.Bits.BIT5
#define PWMSCLA_BIT6                    _PWMSCLA.Bits.BIT6
#define PWMSCLA_BIT7                    _PWMSCLA.Bits.BIT7

#define PWMSCLA_BIT0_MASK               1
#define PWMSCLA_BIT1_MASK               2
#define PWMSCLA_BIT2_MASK               4
#define PWMSCLA_BIT3_MASK               8
#define PWMSCLA_BIT4_MASK               16
#define PWMSCLA_BIT5_MASK               32
#define PWMSCLA_BIT6_MASK               64
#define PWMSCLA_BIT7_MASK               128


/*** PWMSCLB - PWM Scale B Register; 0x000000E9 ***/
typedef union {
  byte Byte;
  struct {
    byte BIT0        :1;                                       /* PWM Scale B Bit 0 */
    byte BIT1        :1;                                       /* PWM Scale B Bit 1 */
    byte BIT2        :1;                                       /* PWM Scale B Bit 2 */
    byte BIT3        :1;                                       /* PWM Scale B Bit 3 */
    byte BIT4        :1;                                       /* PWM Scale B Bit 4 */
    byte BIT5        :1;                                       /* PWM Scale B Bit 5 */
    byte BIT6        :1;                                       /* PWM Scale B Bit 6 */
    byte BIT7        :1;                                       /* PWM Scale B Bit 7 */
  } Bits;
} PWMSCLBSTR;
extern volatile PWMSCLBSTR _PWMSCLB @(REG_BASE + 0x000000E9);
#define PWMSCLB                         _PWMSCLB.Byte
#define PWMSCLB_BIT0                    _PWMSCLB.Bits.BIT0
#define PWMSCLB_BIT1                    _PWMSCLB.Bits.BIT1
#define PWMSCLB_BIT2                    _PWMSCLB.Bits.BIT2
#define PWMSCLB_BIT3                    _PWMSCLB.Bits.BIT3
#define PWMSCLB_BIT4                    _PWMSCLB.Bits.BIT4
#define PWMSCLB_BIT5                    _PWMSCLB.Bits.BIT5
#define PWMSCLB_BIT6                    _PWMSCLB.Bits.BIT6
#define PWMSCLB_BIT7                    _PWMSCLB.Bits.BIT7

#define PWMSCLB_BIT0_MASK               1
#define PWMSCLB_BIT1_MASK               2
#define PWMSCLB_BIT2_MASK               4
#define PWMSCLB_BIT3_MASK               8
#define PWMSCLB_BIT4_MASK               16
#define PWMSCLB_BIT5_MASK               32
#define PWMSCLB_BIT6_MASK               64
#define PWMSCLB_BIT7_MASK               128


/*** PWMCNT01 - PWM Channel Counter 01 Register; 0x000000EC ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** PWMCNT0 - PWM Channel Counter 0 Register; 0x000000EC ***/
    union {
      byte Byte;
    } PWMCNT0STR;
    #define PWMCNT0                     _PWMCNT01.Overlap_STR.PWMCNT0STR.Byte
    
    /* PWMCNT_ARR: Access 6 PWMCNTx registers in a array */
    #define PWMCNT_ARR                  ((Byte *) &PWMCNT0)
    


    /*** PWMCNT1 - PWM Channel Counter 1 Register; 0x000000ED ***/
    union {
      byte Byte;
    } PWMCNT1STR;
    #define PWMCNT1                     _PWMCNT01.Overlap_STR.PWMCNT1STR.Byte
    
    

  } Overlap_STR;

} PWMCNT01STR;
extern volatile PWMCNT01STR _PWMCNT01 @(REG_BASE + 0x000000EC);
#define PWMCNT01                        _PWMCNT01.Word



/*** PWMCNT23 - PWM Channel Counter 23 Register; 0x000000EE ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** PWMCNT2 - PWM Channel Counter 2 Register; 0x000000EE ***/
    union {
      byte Byte;
    } PWMCNT2STR;
    #define PWMCNT2                     _PWMCNT23.Overlap_STR.PWMCNT2STR.Byte
    
    


    /*** PWMCNT3 - PWM Channel Counter 3 Register; 0x000000EF ***/
    union {
      byte Byte;
    } PWMCNT3STR;
    #define PWMCNT3                     _PWMCNT23.Overlap_STR.PWMCNT3STR.Byte
    
    

  } Overlap_STR;

} PWMCNT23STR;
extern volatile PWMCNT23STR _PWMCNT23 @(REG_BASE + 0x000000EE);
#define PWMCNT23                        _PWMCNT23.Word



/*** PWMCNT45 - PWM Channel Counter 45 Register; 0x000000F0 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** PWMCNT4 - PWM Channel Counter 4 Register; 0x000000F0 ***/
    union {
      byte Byte;
    } PWMCNT4STR;
    #define PWMCNT4                     _PWMCNT45.Overlap_STR.PWMCNT4STR.Byte
    
    


    /*** PWMCNT5 - PWM Channel Counter 5 Register; 0x000000F1 ***/
    union {
      byte Byte;
    } PWMCNT5STR;
    #define PWMCNT5                     _PWMCNT45.Overlap_STR.PWMCNT5STR.Byte
    
    

  } Overlap_STR;

} PWMCNT45STR;
extern volatile PWMCNT45STR _PWMCNT45 @(REG_BASE + 0x000000F0);
#define PWMCNT45                        _PWMCNT45.Word



/*** PWMPER01 - PWM Channel Period 01 Register; 0x000000F2 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** PWMPER0 - PWM Channel Period 0 Register; 0x000000F2 ***/
    union {
      byte Byte;
    } PWMPER0STR;
    #define PWMPER0                     _PWMPER01.Overlap_STR.PWMPER0STR.Byte
    
    /* PWMPER_ARR: Access 6 PWMPERx registers in a array */
    #define PWMPER_ARR                  ((Byte *) &PWMPER0)
    


    /*** PWMPER1 - PWM Channel Period 1 Register; 0x000000F3 ***/
    union {
      byte Byte;
    } PWMPER1STR;
    #define PWMPER1                     _PWMPER01.Overlap_STR.PWMPER1STR.Byte
    
    

  } Overlap_STR;

} PWMPER01STR;
extern volatile PWMPER01STR _PWMPER01 @(REG_BASE + 0x000000F2);
#define PWMPER01                        _PWMPER01.Word



/*** PWMPER23 - PWM Channel Period 23 Register; 0x000000F4 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** PWMPER2 - PWM Channel Period 2 Register; 0x000000F4 ***/
    union {
      byte Byte;
    } PWMPER2STR;
    #define PWMPER2                     _PWMPER23.Overlap_STR.PWMPER2STR.Byte
    
    


    /*** PWMPER3 - PWM Channel Period 3 Register; 0x000000F5 ***/
    union {
      byte Byte;
    } PWMPER3STR;
    #define PWMPER3                     _PWMPER23.Overlap_STR.PWMPER3STR.Byte
    
    

  } Overlap_STR;

} PWMPER23STR;
extern volatile PWMPER23STR _PWMPER23 @(REG_BASE + 0x000000F4);
#define PWMPER23                        _PWMPER23.Word



/*** PWMPER45 - PWM Channel Period 45 Register; 0x000000F6 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** PWMPER4 - PWM Channel Period 4 Register; 0x000000F6 ***/
    union {
      byte Byte;
    } PWMPER4STR;
    #define PWMPER4                     _PWMPER45.Overlap_STR.PWMPER4STR.Byte
    
    


    /*** PWMPER5 - PWM Channel Period 5 Register; 0x000000F7 ***/
    union {
      byte Byte;
    } PWMPER5STR;
    #define PWMPER5                     _PWMPER45.Overlap_STR.PWMPER5STR.Byte
    
    

  } Overlap_STR;

} PWMPER45STR;
extern volatile PWMPER45STR _PWMPER45 @(REG_BASE + 0x000000F6);
#define PWMPER45                        _PWMPER45.Word



/*** PWMDTY01 - PWM Channel Duty 01 Register; 0x000000F8 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** PWMDTY0 - PWM Channel Duty 0 Register; 0x000000F8 ***/
    union {
      byte Byte;
    } PWMDTY0STR;
    #define PWMDTY0                     _PWMDTY01.Overlap_STR.PWMDTY0STR.Byte
    
    /* PWMDTY_ARR: Access 6 PWMDTYx registers in a array */
    #define PWMDTY_ARR                  ((Byte *) &PWMDTY0)
    


    /*** PWMDTY1 - PWM Channel Duty 1 Register; 0x000000F9 ***/
    union {
      byte Byte;
    } PWMDTY1STR;
    #define PWMDTY1                     _PWMDTY01.Overlap_STR.PWMDTY1STR.Byte
    
    

  } Overlap_STR;

} PWMDTY01STR;
extern volatile PWMDTY01STR _PWMDTY01 @(REG_BASE + 0x000000F8);
#define PWMDTY01                        _PWMDTY01.Word



/*** PWMDTY23 - PWM Channel Duty 23 Register; 0x000000FA ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** PWMDTY2 - PWM Channel Duty 2 Register; 0x000000FA ***/
    union {
      byte Byte;
    } PWMDTY2STR;
    #define PWMDTY2                     _PWMDTY23.Overlap_STR.PWMDTY2STR.Byte
    
    


    /*** PWMDTY3 - PWM Channel Duty 3 Register; 0x000000FB ***/
    union {
      byte Byte;
    } PWMDTY3STR;
    #define PWMDTY3                     _PWMDTY23.Overlap_STR.PWMDTY3STR.Byte
    
    

  } Overlap_STR;

} PWMDTY23STR;
extern volatile PWMDTY23STR _PWMDTY23 @(REG_BASE + 0x000000FA);
#define PWMDTY23                        _PWMDTY23.Word



/*** PWMDTY45 - PWM Channel Duty 45 Register; 0x000000FC ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** PWMDTY4 - PWM Channel Duty 4 Register; 0x000000FC ***/
    union {
      byte Byte;
    } PWMDTY4STR;
    #define PWMDTY4                     _PWMDTY45.Overlap_STR.PWMDTY4STR.Byte
    
    


    /*** PWMDTY5 - PWM Channel Duty 5 Register; 0x000000FD ***/
    union {
      byte Byte;
    } PWMDTY5STR;
    #define PWMDTY5                     _PWMDTY45.Overlap_STR.PWMDTY5STR.Byte
    
    

  } Overlap_STR;

} PWMDTY45STR;
extern volatile PWMDTY45STR _PWMDTY45 @(REG_BASE + 0x000000FC);
#define PWMDTY45                        _PWMDTY45.Word



/*** PWMSDN - PWM Shutdown Register; 0x000000FE ***/
typedef union {
  byte Byte;
  struct {
    byte PWM5ENA     :1;                                       /* PWM emergency shutdown Enable */
    byte PWM5INL     :1;                                       /* PWM shutdown active input level for ch. 5 */
    byte PWM5IN      :1;                                       /* PWM channel 5 input status */
    byte             :1; 
    byte PWMLVL      :1;                                       /* PWM shutdown output Level */
    byte PWMRSTRT    :1;                                       /* PWM Restart */
    byte PWMIE       :1;                                       /* PWM Interrupt Enable */
    byte PWMIF       :1;                                       /* PWM Interrupt Flag */
  } Bits;
} PWMSDNSTR;
extern volatile PWMSDNSTR _PWMSDN @(REG_BASE + 0x000000FE);
#define PWMSDN                          _PWMSDN.Byte
#define PWMSDN_PWM5ENA                  _PWMSDN.Bits.PWM5ENA
#define PWMSDN_PWM5INL                  _PWMSDN.Bits.PWM5INL
#define PWMSDN_PWM5IN                   _PWMSDN.Bits.PWM5IN
#define PWMSDN_PWMLVL                   _PWMSDN.Bits.PWMLVL
#define PWMSDN_PWMRSTRT                 _PWMSDN.Bits.PWMRSTRT
#define PWMSDN_PWMIE                    _PWMSDN.Bits.PWMIE
#define PWMSDN_PWMIF                    _PWMSDN.Bits.PWMIF

#define PWMSDN_PWM5ENA_MASK             1
#define PWMSDN_PWM5INL_MASK             2
#define PWMSDN_PWM5IN_MASK              4
#define PWMSDN_PWMLVL_MASK              16
#define PWMSDN_PWMRSTRT_MASK            32
#define PWMSDN_PWMIE_MASK               64
#define PWMSDN_PWMIF_MASK               128


/*** FCLKDIV - Flash Clock Divider Register; 0x00000100 ***/
typedef union {
  byte Byte;
  struct {
    byte FDIV0       :1;                                       /* Flash Clock Divider Bit 0 */
    byte FDIV1       :1;                                       /* Flash Clock Divider Bit 1 */
    byte FDIV2       :1;                                       /* Flash Clock Divider Bit 2 */
    byte FDIV3       :1;                                       /* Flash Clock Divider Bit 3 */
    byte FDIV4       :1;                                       /* Flash Clock Divider Bit 4 */
    byte FDIV5       :1;                                       /* Flash Clock Divider Bit 5 */
    byte PRDIV8      :1;                                       /* Enable Prescaler by 8 */
    byte FDIVLD      :1;                                       /* Flash Clock Divider Loaded */
  } Bits;
  struct {
    byte grpFDIV :6;
    byte grpPRDIV_8 :1;
    byte         :1;
  } MergedBits;
} FCLKDIVSTR;
extern volatile FCLKDIVSTR _FCLKDIV @(REG_BASE + 0x00000100);
#define FCLKDIV                         _FCLKDIV.Byte
#define FCLKDIV_FDIV0                   _FCLKDIV.Bits.FDIV0
#define FCLKDIV_FDIV1                   _FCLKDIV.Bits.FDIV1
#define FCLKDIV_FDIV2                   _FCLKDIV.Bits.FDIV2
#define FCLKDIV_FDIV3                   _FCLKDIV.Bits.FDIV3
#define FCLKDIV_FDIV4                   _FCLKDIV.Bits.FDIV4
#define FCLKDIV_FDIV5                   _FCLKDIV.Bits.FDIV5
#define FCLKDIV_PRDIV8                  _FCLKDIV.Bits.PRDIV8
#define FCLKDIV_FDIVLD                  _FCLKDIV.Bits.FDIVLD
#define FCLKDIV_FDIV                    _FCLKDIV.MergedBits.grpFDIV

#define FCLKDIV_FDIV0_MASK              1
#define FCLKDIV_FDIV1_MASK              2
#define FCLKDIV_FDIV2_MASK              4
#define FCLKDIV_FDIV3_MASK              8
#define FCLKDIV_FDIV4_MASK              16
#define FCLKDIV_FDIV5_MASK              32
#define FCLKDIV_PRDIV8_MASK             64
#define FCLKDIV_FDIVLD_MASK             128
#define FCLKDIV_FDIV_MASK               %BitsMask
#define FCLKDIV_FDIV_BITNUM             %BitsNum


/*** FSEC - Flash Security Register; 0x00000101 ***/
typedef union {
  byte Byte;
  struct {
    byte SEC0        :1;                                       /* Memory security bit 0 */
    byte SEC1        :1;                                       /* Memory security bit 1 */
    byte NV2         :1;                                       /* Non Volatile flag bit 2 */
    byte NV3         :1;                                       /* Non Volatile flag bit 3 */
    byte NV4         :1;                                       /* Non Volatile flag bit 4 */
    byte NV5         :1;                                       /* Non Volatile flag bit 5 */
    byte KEYEN0      :1;                                       /* Backdoor Key Security Enable Bit 0 */
    byte KEYEN1      :1;                                       /* Backdoor Key Security Enable Bit 1 */
  } Bits;
  struct {
    byte grpSEC  :2;
    byte grpNV_2 :4;
    byte grpKEYEN :2;
  } MergedBits;
} FSECSTR;
extern volatile FSECSTR _FSEC @(REG_BASE + 0x00000101);
#define FSEC                            _FSEC.Byte
#define FSEC_SEC0                       _FSEC.Bits.SEC0
#define FSEC_SEC1                       _FSEC.Bits.SEC1
#define FSEC_NV2                        _FSEC.Bits.NV2
#define FSEC_NV3                        _FSEC.Bits.NV3
#define FSEC_NV4                        _FSEC.Bits.NV4
#define FSEC_NV5                        _FSEC.Bits.NV5
#define FSEC_KEYEN0                     _FSEC.Bits.KEYEN0
#define FSEC_KEYEN1                     _FSEC.Bits.KEYEN1
#define FSEC_SEC                        _FSEC.MergedBits.grpSEC
#define FSEC_NV_2                       _FSEC.MergedBits.grpNV_2
#define FSEC_KEYEN                      _FSEC.MergedBits.grpKEYEN
#define FSEC_NV                         FSEC_NV_2

#define FSEC_SEC0_MASK                  1
#define FSEC_SEC1_MASK                  2
#define FSEC_NV2_MASK                   4
#define FSEC_NV3_MASK                   8
#define FSEC_NV4_MASK                   16
#define FSEC_NV5_MASK                   32
#define FSEC_KEYEN0_MASK                64
#define FSEC_KEYEN1_MASK                128
#define FSEC_SEC_MASK                   %BitsMask
#define FSEC_SEC_BITNUM                 %BitsNum
#define FSEC_NV_2_MASK                  %BitsMask
#define FSEC_NV_2_BITNUM                %BitsNum
#define FSEC_KEYEN_MASK                 %BitsMask
#define FSEC_KEYEN_BITNUM               %BitsNum


/*** FCNFG - Flash Configuration Register; 0x00000103 ***/
typedef union {
  byte Byte;
  struct {
    byte BKSEL0      :1;                                       /* Register Bank Select Bit 0 */
    byte BKSEL1      :1;                                       /* Register Bank Select Bit 1 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte KEYACC      :1;                                       /* Enable Security Key Writing */
    byte CCIE        :1;                                       /* Command Complete Interrupt Enable */
    byte CBEIE       :1;                                       /* Command Buffers Empty Interrupt Enable */
  } Bits;
  struct {
    byte grpBKSEL :2;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} FCNFGSTR;
extern volatile FCNFGSTR _FCNFG @(REG_BASE + 0x00000103);
#define FCNFG                           _FCNFG.Byte
#define FCNFG_BKSEL0                    _FCNFG.Bits.BKSEL0
#define FCNFG_BKSEL1                    _FCNFG.Bits.BKSEL1
#define FCNFG_KEYACC                    _FCNFG.Bits.KEYACC
#define FCNFG_CCIE                      _FCNFG.Bits.CCIE
#define FCNFG_CBEIE                     _FCNFG.Bits.CBEIE
#define FCNFG_BKSEL                     _FCNFG.MergedBits.grpBKSEL

#define FCNFG_BKSEL0_MASK               1
#define FCNFG_BKSEL1_MASK               2
#define FCNFG_KEYACC_MASK               32
#define FCNFG_CCIE_MASK                 64
#define FCNFG_CBEIE_MASK                128
#define FCNFG_BKSEL_MASK                %BitsMask
#define FCNFG_BKSEL_BITNUM              %BitsNum


/*** FPROT - Flash Protection Register; 0x00000104 ***/
typedef union {
  byte Byte;
  struct {
    byte FPLS0       :1;                                       /* Flash Protection Lower Address size 0 */
    byte FPLS1       :1;                                       /* Flash Protection Lower Address size 1 */
    byte FPLDIS      :1;                                       /* Flash Protection Lower address range disable */
    byte FPHS0       :1;                                       /* Flash Protection Higher address size 0 */
    byte FPHS1       :1;                                       /* Flash Protection Higher address size 1 */
    byte FPHDIS      :1;                                       /* Flash Protection Higher address range disable */
    byte NV6         :1;                                       /* Non Volatile Flag Bit */
    byte FPOPEN      :1;                                       /* Opens the flash block or subsections of it for program or erase */
  } Bits;
  struct {
    byte grpFPLS :2;
    byte         :1;
    byte grpFPHS :2;
    byte         :1;
    byte grpNV_6 :1;
    byte         :1;
  } MergedBits;
} FPROTSTR;
extern volatile FPROTSTR _FPROT @(REG_BASE + 0x00000104);
#define FPROT                           _FPROT.Byte
#define FPROT_FPLS0                     _FPROT.Bits.FPLS0
#define FPROT_FPLS1                     _FPROT.Bits.FPLS1
#define FPROT_FPLDIS                    _FPROT.Bits.FPLDIS
#define FPROT_FPHS0                     _FPROT.Bits.FPHS0
#define FPROT_FPHS1                     _FPROT.Bits.FPHS1
#define FPROT_FPHDIS                    _FPROT.Bits.FPHDIS
#define FPROT_NV6                       _FPROT.Bits.NV6
#define FPROT_FPOPEN                    _FPROT.Bits.FPOPEN
#define FPROT_FPLS                      _FPROT.MergedBits.grpFPLS
#define FPROT_FPHS                      _FPROT.MergedBits.grpFPHS

#define FPROT_FPLS0_MASK                1
#define FPROT_FPLS1_MASK                2
#define FPROT_FPLDIS_MASK               4
#define FPROT_FPHS0_MASK                8
#define FPROT_FPHS1_MASK                16
#define FPROT_FPHDIS_MASK               32
#define FPROT_NV6_MASK                  64
#define FPROT_FPOPEN_MASK               128
#define FPROT_FPLS_MASK                 %BitsMask
#define FPROT_FPLS_BITNUM               %BitsNum
#define FPROT_FPHS_MASK                 %BitsMask
#define FPROT_FPHS_BITNUM               %BitsNum


/*** FSTAT - Flash Status Register; 0x00000105 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte BLANK       :1;                                       /* Blank Verify Flag */
    byte             :1; 
    byte ACCERR      :1;                                       /* Access error */
    byte PVIOL       :1;                                       /* Protection violation */
    byte CCIF        :1;                                       /* Command Complete Interrupt Flag */
    byte CBEIF       :1;                                       /* Command Buffers Empty Interrupt Flag */
  } Bits;
} FSTATSTR;
extern volatile FSTATSTR _FSTAT @(REG_BASE + 0x00000105);
#define FSTAT                           _FSTAT.Byte
#define FSTAT_BLANK                     _FSTAT.Bits.BLANK
#define FSTAT_ACCERR                    _FSTAT.Bits.ACCERR
#define FSTAT_PVIOL                     _FSTAT.Bits.PVIOL
#define FSTAT_CCIF                      _FSTAT.Bits.CCIF
#define FSTAT_CBEIF                     _FSTAT.Bits.CBEIF

#define FSTAT_BLANK_MASK                4
#define FSTAT_ACCERR_MASK               16
#define FSTAT_PVIOL_MASK                32
#define FSTAT_CCIF_MASK                 64
#define FSTAT_CBEIF_MASK                128


/*** FCMD - Flash Command Buffer and Register; 0x00000106 ***/
typedef union {
  byte Byte;
  struct {
    byte CMDB0       :1;                                       /* NVM User Mode Command Bit 0 */
    byte             :1; 
    byte CMDB2       :1;                                       /* NVM User Mode Command Bit 2 */
    byte             :1; 
    byte             :1; 
    byte CMDB5       :1;                                       /* NVM User Mode Command Bit 5 */
    byte CMDB6       :1;                                       /* NVM User Mode Command Bit 6 */
    byte             :1; 
  } Bits;
  struct {
    byte grpCMDB :1;
    byte         :1;
    byte grpCMDB_2 :1;
    byte         :1;
    byte         :1;
    byte grpCMDB_5 :2;
    byte         :1;
  } MergedBits;
} FCMDSTR;
extern volatile FCMDSTR _FCMD @(REG_BASE + 0x00000106);
#define FCMD                            _FCMD.Byte
#define FCMD_CMDB0                      _FCMD.Bits.CMDB0
#define FCMD_CMDB2                      _FCMD.Bits.CMDB2
#define FCMD_CMDB5                      _FCMD.Bits.CMDB5
#define FCMD_CMDB6                      _FCMD.Bits.CMDB6
#define FCMD_CMDB_5                     _FCMD.MergedBits.grpCMDB_5
#define FCMD_CMDB                       FCMD_CMDB_5

#define FCMD_CMDB0_MASK                 1
#define FCMD_CMDB2_MASK                 4
#define FCMD_CMDB5_MASK                 32
#define FCMD_CMDB6_MASK                 64
#define FCMD_CMDB_5_MASK                %BitsMask
#define FCMD_CMDB_5_BITNUM              %BitsNum


/*** ECLKDIV - EEPROM Clock Divider Register; 0x00000110 ***/
typedef union {
  byte Byte;
  struct {
    byte EDIV0       :1;                                       /* EEPROM Clock Divider 0 */
    byte EDIV1       :1;                                       /* EEPROM Clock Divider 1 */
    byte EDIV2       :1;                                       /* EEPROM Clock Divider 2 */
    byte EDIV3       :1;                                       /* EEPROM Clock Divider 3 */
    byte EDIV4       :1;                                       /* EEPROM Clock Divider 4 */
    byte EDIV5       :1;                                       /* EEPROM Clock Divider 5 */
    byte PRDIV8      :1;                                       /* Enable Prescaler by 8 */
    byte EDIVLD      :1;                                       /* EEPROM Clock Divider Loaded */
  } Bits;
  struct {
    byte grpEDIV :6;
    byte grpPRDIV_8 :1;
    byte         :1;
  } MergedBits;
} ECLKDIVSTR;
extern volatile ECLKDIVSTR _ECLKDIV @(REG_BASE + 0x00000110);
#define ECLKDIV                         _ECLKDIV.Byte
#define ECLKDIV_EDIV0                   _ECLKDIV.Bits.EDIV0
#define ECLKDIV_EDIV1                   _ECLKDIV.Bits.EDIV1
#define ECLKDIV_EDIV2                   _ECLKDIV.Bits.EDIV2
#define ECLKDIV_EDIV3                   _ECLKDIV.Bits.EDIV3
#define ECLKDIV_EDIV4                   _ECLKDIV.Bits.EDIV4
#define ECLKDIV_EDIV5                   _ECLKDIV.Bits.EDIV5
#define ECLKDIV_PRDIV8                  _ECLKDIV.Bits.PRDIV8
#define ECLKDIV_EDIVLD                  _ECLKDIV.Bits.EDIVLD
#define ECLKDIV_EDIV                    _ECLKDIV.MergedBits.grpEDIV

#define ECLKDIV_EDIV0_MASK              1
#define ECLKDIV_EDIV1_MASK              2
#define ECLKDIV_EDIV2_MASK              4
#define ECLKDIV_EDIV3_MASK              8
#define ECLKDIV_EDIV4_MASK              16
#define ECLKDIV_EDIV5_MASK              32
#define ECLKDIV_PRDIV8_MASK             64
#define ECLKDIV_EDIVLD_MASK             128
#define ECLKDIV_EDIV_MASK               %BitsMask
#define ECLKDIV_EDIV_BITNUM             %BitsNum


/*** ECNFG - EEPROM Configuration Register; 0x00000113 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte CCIE        :1;                                       /* Command Complete Interrupt Enable */
    byte CBEIE       :1;                                       /* Command Buffers Empty Interrupt Enable */
  } Bits;
} ECNFGSTR;
extern volatile ECNFGSTR _ECNFG @(REG_BASE + 0x00000113);
#define ECNFG                           _ECNFG.Byte
#define ECNFG_CCIE                      _ECNFG.Bits.CCIE
#define ECNFG_CBEIE                     _ECNFG.Bits.CBEIE

#define ECNFG_CCIE_MASK                 64
#define ECNFG_CBEIE_MASK                128


/*** EPROT - EEPROM Protection Register; 0x00000114 ***/
typedef union {
  byte Byte;
  struct {
    byte EP0         :1;                                       /* EEPROM Protection address size 0 */
    byte EP1         :1;                                       /* EEPROM Protection address size 1 */
    byte EP2         :1;                                       /* EEPROM Protection address size 2 */
    byte EPDIS       :1;                                       /* EEPROM Protection disable */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte EPOPEN      :1;                                       /* Opens the EEPROM block or a subsection of it for program or erase */
  } Bits;
  struct {
    byte grpEP   :3;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} EPROTSTR;
extern volatile EPROTSTR _EPROT @(REG_BASE + 0x00000114);
#define EPROT                           _EPROT.Byte
#define EPROT_EP0                       _EPROT.Bits.EP0
#define EPROT_EP1                       _EPROT.Bits.EP1
#define EPROT_EP2                       _EPROT.Bits.EP2
#define EPROT_EPDIS                     _EPROT.Bits.EPDIS
#define EPROT_EPOPEN                    _EPROT.Bits.EPOPEN
#define EPROT_EP                        _EPROT.MergedBits.grpEP

#define EPROT_EP0_MASK                  1
#define EPROT_EP1_MASK                  2
#define EPROT_EP2_MASK                  4
#define EPROT_EPDIS_MASK                8
#define EPROT_EPOPEN_MASK               128
#define EPROT_EP_MASK                   %BitsMask
#define EPROT_EP_BITNUM                 %BitsNum


/*** ESTAT - EEPROM Status Register; 0x00000115 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte BLANK       :1;                                       /* Blank Verify Flag */
    byte             :1; 
    byte ACCERR      :1;                                       /* Access error */
    byte PVIOL       :1;                                       /* Protection violation */
    byte CCIF        :1;                                       /* Command Complete Interrupt Flag */
    byte CBEIF       :1;                                       /* Command Buffer Empty Interrupt Flag */
  } Bits;
} ESTATSTR;
extern volatile ESTATSTR _ESTAT @(REG_BASE + 0x00000115);
#define ESTAT                           _ESTAT.Byte
#define ESTAT_BLANK                     _ESTAT.Bits.BLANK
#define ESTAT_ACCERR                    _ESTAT.Bits.ACCERR
#define ESTAT_PVIOL                     _ESTAT.Bits.PVIOL
#define ESTAT_CCIF                      _ESTAT.Bits.CCIF
#define ESTAT_CBEIF                     _ESTAT.Bits.CBEIF

#define ESTAT_BLANK_MASK                4
#define ESTAT_ACCERR_MASK               16
#define ESTAT_PVIOL_MASK                32
#define ESTAT_CCIF_MASK                 64
#define ESTAT_CBEIF_MASK                128


/*** ECMD - EEPROM Command Buffer and Register; 0x00000116 ***/
typedef union {
  byte Byte;
  struct {
    byte CMDB0       :1;                                       /* EEPROM User Mode Command 0 */
    byte             :1; 
    byte CMDB2       :1;                                       /* EEPROM User Mode Command 2 */
    byte             :1; 
    byte             :1; 
    byte CMDB5       :1;                                       /* EEPROM User Mode Command 5 */
    byte CMDB6       :1;                                       /* EEPROM User Mode Command 6 */
    byte             :1; 
  } Bits;
  struct {
    byte grpCMDB :1;
    byte         :1;
    byte grpCMDB_2 :1;
    byte         :1;
    byte         :1;
    byte grpCMDB_5 :2;
    byte         :1;
  } MergedBits;
} ECMDSTR;
extern volatile ECMDSTR _ECMD @(REG_BASE + 0x00000116);
#define ECMD                            _ECMD.Byte
#define ECMD_CMDB0                      _ECMD.Bits.CMDB0
#define ECMD_CMDB2                      _ECMD.Bits.CMDB2
#define ECMD_CMDB5                      _ECMD.Bits.CMDB5
#define ECMD_CMDB6                      _ECMD.Bits.CMDB6
#define ECMD_CMDB_5                     _ECMD.MergedBits.grpCMDB_5
#define ECMD_CMDB                       ECMD_CMDB_5

#define ECMD_CMDB0_MASK                 1
#define ECMD_CMDB2_MASK                 4
#define ECMD_CMDB5_MASK                 32
#define ECMD_CMDB6_MASK                 64
#define ECMD_CMDB_5_MASK                %BitsMask
#define ECMD_CMDB_5_BITNUM              %BitsNum


/*** LCDCR0 - LCD Control Register 0; 0x00000120 ***/
typedef union {
  byte Byte;
  struct {
    byte DUTY0       :1;                                       /* LCD Duty Select Bit 0 */
    byte DUTY1       :1;                                       /* LCD Duty Select Bit 1 */
    byte BIAS        :1;                                       /* BIAS Voltage Level Select */
    byte LCLK0       :1;                                       /* LCD Clock Prescaler Bit 0 */
    byte LCLK1       :1;                                       /* LCD Clock Prescaler Bit 1 */
    byte LCLK2       :1;                                       /* LCD Clock Prescaler Bit 2 */
    byte             :1; 
    byte LCDEN       :1;                                       /* LCD32F4B Driver System Enable */
  } Bits;
  struct {
    byte grpDUTY :2;
    byte         :1;
    byte grpLCLK :3;
    byte         :1;
    byte         :1;
  } MergedBits;
} LCDCR0STR;
extern volatile LCDCR0STR _LCDCR0 @(REG_BASE + 0x00000120);
#define LCDCR0                          _LCDCR0.Byte
#define LCDCR0_DUTY0                    _LCDCR0.Bits.DUTY0
#define LCDCR0_DUTY1                    _LCDCR0.Bits.DUTY1
#define LCDCR0_BIAS                     _LCDCR0.Bits.BIAS
#define LCDCR0_LCLK0                    _LCDCR0.Bits.LCLK0
#define LCDCR0_LCLK1                    _LCDCR0.Bits.LCLK1
#define LCDCR0_LCLK2                    _LCDCR0.Bits.LCLK2
#define LCDCR0_LCDEN                    _LCDCR0.Bits.LCDEN
/* LCDCR_ARR: Access 2 LCDCRx registers in a array */
#define LCDCR_ARR                       ((Byte *) &LCDCR0)
#define LCDCR0_DUTY                     _LCDCR0.MergedBits.grpDUTY
#define LCDCR0_LCLK                     _LCDCR0.MergedBits.grpLCLK

#define LCDCR0_DUTY0_MASK               1
#define LCDCR0_DUTY1_MASK               2
#define LCDCR0_BIAS_MASK                4
#define LCDCR0_LCLK0_MASK               8
#define LCDCR0_LCLK1_MASK               16
#define LCDCR0_LCLK2_MASK               32
#define LCDCR0_LCDEN_MASK               128
#define LCDCR0_DUTY_MASK                %BitsMask
#define LCDCR0_DUTY_BITNUM              %BitsNum
#define LCDCR0_LCLK_MASK                %BitsMask
#define LCDCR0_LCLK_BITNUM              %BitsNum


/*** LCDCR1 - LCD Control Register 1; 0x00000121 ***/
typedef union {
  byte Byte;
  struct {
    byte LCDRPSTP    :1;                                       /* LCD Run in Pseudo STOP Mode */
    byte LCDSWAI     :1;                                       /* LCD Stop in Wait Mode */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} LCDCR1STR;
extern volatile LCDCR1STR _LCDCR1 @(REG_BASE + 0x00000121);
#define LCDCR1                          _LCDCR1.Byte
#define LCDCR1_LCDRPSTP                 _LCDCR1.Bits.LCDRPSTP
#define LCDCR1_LCDSWAI                  _LCDCR1.Bits.LCDSWAI

#define LCDCR1_LCDRPSTP_MASK            1
#define LCDCR1_LCDSWAI_MASK             2


/*** FPENR0 - LCD Frontplane Enable Register 0; 0x00000122 ***/
typedef union {
  byte Byte;
  struct {
    byte FP0EN       :1;                                       /* Frontplane Output Enable Bit 0 */
    byte FP1EN       :1;                                       /* Frontplane Output Enable Bit 1 */
    byte FP2EN       :1;                                       /* Frontplane Output Enable Bit 2 */
    byte FP3EN       :1;                                       /* Frontplane Output Enable Bit 3 */
    byte FP4EN       :1;                                       /* Frontplane Output Enable Bit 4 */
    byte FP5EN       :1;                                       /* Frontplane Output Enable Bit 5 */
    byte FP6EN       :1;                                       /* Frontplane Output Enable Bit 6 */
    byte FP7EN       :1;                                       /* Frontplane Output Enable Bit 7 */
  } Bits;
} FPENR0STR;
extern volatile FPENR0STR _FPENR0 @(REG_BASE + 0x00000122);
#define FPENR0                          _FPENR0.Byte
#define FPENR0_FP0EN                    _FPENR0.Bits.FP0EN
#define FPENR0_FP1EN                    _FPENR0.Bits.FP1EN
#define FPENR0_FP2EN                    _FPENR0.Bits.FP2EN
#define FPENR0_FP3EN                    _FPENR0.Bits.FP3EN
#define FPENR0_FP4EN                    _FPENR0.Bits.FP4EN
#define FPENR0_FP5EN                    _FPENR0.Bits.FP5EN
#define FPENR0_FP6EN                    _FPENR0.Bits.FP6EN
#define FPENR0_FP7EN                    _FPENR0.Bits.FP7EN
/* FPENR_ARR: Access 4 FPENRx registers in a array */
#define FPENR_ARR                       ((Byte *) &FPENR0)

#define FPENR0_FP0EN_MASK               1
#define FPENR0_FP1EN_MASK               2
#define FPENR0_FP2EN_MASK               4
#define FPENR0_FP3EN_MASK               8
#define FPENR0_FP4EN_MASK               16
#define FPENR0_FP5EN_MASK               32
#define FPENR0_FP6EN_MASK               64
#define FPENR0_FP7EN_MASK               128


/*** FPENR1 - LCD Frontplane Enable Register 1; 0x00000123 ***/
typedef union {
  byte Byte;
  struct {
    byte FP8EN       :1;                                       /* Frontplane Output Enable Bit 8 */
    byte FP9EN       :1;                                       /* Frontplane Output Enable Bit 9 */
    byte FP10EN      :1;                                       /* Frontplane Output Enable Bit 10 */
    byte FP11EN      :1;                                       /* Frontplane Output Enable Bit 11 */
    byte FP12EN      :1;                                       /* Frontplane Output Enable Bit 12 */
    byte FP13EN      :1;                                       /* Frontplane Output Enable Bit 13 */
    byte FP14EN      :1;                                       /* Frontplane Output Enable Bit 14 */
    byte FP15EN      :1;                                       /* Frontplane Output Enable Bit 15 */
  } Bits;
} FPENR1STR;
extern volatile FPENR1STR _FPENR1 @(REG_BASE + 0x00000123);
#define FPENR1                          _FPENR1.Byte
#define FPENR1_FP8EN                    _FPENR1.Bits.FP8EN
#define FPENR1_FP9EN                    _FPENR1.Bits.FP9EN
#define FPENR1_FP10EN                   _FPENR1.Bits.FP10EN
#define FPENR1_FP11EN                   _FPENR1.Bits.FP11EN
#define FPENR1_FP12EN                   _FPENR1.Bits.FP12EN
#define FPENR1_FP13EN                   _FPENR1.Bits.FP13EN
#define FPENR1_FP14EN                   _FPENR1.Bits.FP14EN
#define FPENR1_FP15EN                   _FPENR1.Bits.FP15EN

#define FPENR1_FP8EN_MASK               1
#define FPENR1_FP9EN_MASK               2
#define FPENR1_FP10EN_MASK              4
#define FPENR1_FP11EN_MASK              8
#define FPENR1_FP12EN_MASK              16
#define FPENR1_FP13EN_MASK              32
#define FPENR1_FP14EN_MASK              64
#define FPENR1_FP15EN_MASK              128


/*** FPENR2 - LCD Frontplane Enable Register 2; 0x00000124 ***/
typedef union {
  byte Byte;
  struct {
    byte FP16EN      :1;                                       /* Frontplane Output Enable Bit 16 */
    byte FP17EN      :1;                                       /* Frontplane Output Enable Bit 17 */
    byte FP18EN      :1;                                       /* Frontplane Output Enable Bit 18 */
    byte FP19EN      :1;                                       /* Frontplane Output Enable Bit 19 */
    byte FP20EN      :1;                                       /* Frontplane Output Enable Bit 20 */
    byte FP21EN      :1;                                       /* Frontplane Output Enable Bit 21 */
    byte FP22EN      :1;                                       /* Frontplane Output Enable Bit 22 */
    byte FP23EN      :1;                                       /* Frontplane Output Enable Bit 23 */
  } Bits;
} FPENR2STR;
extern volatile FPENR2STR _FPENR2 @(REG_BASE + 0x00000124);
#define FPENR2                          _FPENR2.Byte
#define FPENR2_FP16EN                   _FPENR2.Bits.FP16EN
#define FPENR2_FP17EN                   _FPENR2.Bits.FP17EN
#define FPENR2_FP18EN                   _FPENR2.Bits.FP18EN
#define FPENR2_FP19EN                   _FPENR2.Bits.FP19EN
#define FPENR2_FP20EN                   _FPENR2.Bits.FP20EN
#define FPENR2_FP21EN                   _FPENR2.Bits.FP21EN
#define FPENR2_FP22EN                   _FPENR2.Bits.FP22EN
#define FPENR2_FP23EN                   _FPENR2.Bits.FP23EN

#define FPENR2_FP16EN_MASK              1
#define FPENR2_FP17EN_MASK              2
#define FPENR2_FP18EN_MASK              4
#define FPENR2_FP19EN_MASK              8
#define FPENR2_FP20EN_MASK              16
#define FPENR2_FP21EN_MASK              32
#define FPENR2_FP22EN_MASK              64
#define FPENR2_FP23EN_MASK              128


/*** FPENR3 - LCD Frontplane Enable Register 3; 0x00000125 ***/
typedef union {
  byte Byte;
  struct {
    byte FP24EN      :1;                                       /* Frontplane Output Enable Bit 24 */
    byte FP25EN      :1;                                       /* Frontplane Output Enable Bit 25 */
    byte FP26EN      :1;                                       /* Frontplane Output Enable Bit 26 */
    byte FP27EN      :1;                                       /* Frontplane Output Enable Bit 27 */
    byte FP28EN      :1;                                       /* Frontplane Output Enable Bit 28 */
    byte FP29EN      :1;                                       /* Frontplane Output Enable Bit 29 */
    byte FP30EN      :1;                                       /* Frontplane Output Enable Bit 30 */
    byte FP31EN      :1;                                       /* Frontplane Output Enable Bit 31 */
  } Bits;
} FPENR3STR;
extern volatile FPENR3STR _FPENR3 @(REG_BASE + 0x00000125);
#define FPENR3                          _FPENR3.Byte
#define FPENR3_FP24EN                   _FPENR3.Bits.FP24EN
#define FPENR3_FP25EN                   _FPENR3.Bits.FP25EN
#define FPENR3_FP26EN                   _FPENR3.Bits.FP26EN
#define FPENR3_FP27EN                   _FPENR3.Bits.FP27EN
#define FPENR3_FP28EN                   _FPENR3.Bits.FP28EN
#define FPENR3_FP29EN                   _FPENR3.Bits.FP29EN
#define FPENR3_FP30EN                   _FPENR3.Bits.FP30EN
#define FPENR3_FP31EN                   _FPENR3.Bits.FP31EN

#define FPENR3_FP24EN_MASK              1
#define FPENR3_FP25EN_MASK              2
#define FPENR3_FP26EN_MASK              4
#define FPENR3_FP27EN_MASK              8
#define FPENR3_FP28EN_MASK              16
#define FPENR3_FP29EN_MASK              32
#define FPENR3_FP30EN_MASK              64
#define FPENR3_FP31EN_MASK              128


/*** LCDRAM0 - LCD RAM Register 0; 0x00000128 ***/
typedef union {
  byte Byte;
  struct {
    byte FP0BP0      :1;                                       /* LCD Segment FP0, BP0 ON */
    byte FP0BP1      :1;                                       /* LCD Segment FP0, BP1 ON */
    byte FP0BP2      :1;                                       /* LCD Segment FP0, BP2 ON */
    byte FP0BP3      :1;                                       /* LCD Segment FP0, BP3 ON */
    byte FP1BP0      :1;                                       /* LCD Segment FP1, BP0 ON */
    byte FP1BP1      :1;                                       /* LCD Segment FP1, BP1 ON */
    byte FP1BP2      :1;                                       /* LCD Segment FP1, BP2 ON */
    byte FP1BP3      :1;                                       /* LCD Segment FP1, BP3 ON */
  } Bits;
  struct {
    byte grpFP0BP :4;
    byte grpFP1BP :4;
  } MergedBits;
} LCDRAM0STR;
extern volatile LCDRAM0STR _LCDRAM0 @(REG_BASE + 0x00000128);
#define LCDRAM0                         _LCDRAM0.Byte
#define LCDRAM0_FP0BP0                  _LCDRAM0.Bits.FP0BP0
#define LCDRAM0_FP0BP1                  _LCDRAM0.Bits.FP0BP1
#define LCDRAM0_FP0BP2                  _LCDRAM0.Bits.FP0BP2
#define LCDRAM0_FP0BP3                  _LCDRAM0.Bits.FP0BP3
#define LCDRAM0_FP1BP0                  _LCDRAM0.Bits.FP1BP0
#define LCDRAM0_FP1BP1                  _LCDRAM0.Bits.FP1BP1
#define LCDRAM0_FP1BP2                  _LCDRAM0.Bits.FP1BP2
#define LCDRAM0_FP1BP3                  _LCDRAM0.Bits.FP1BP3
/* LCDRAM_ARR: Access 16 LCDRAMx registers in a array */
#define LCDRAM_ARR                      ((Byte *) &LCDRAM0)
#define LCDRAM0_FP0BP                   _LCDRAM0.MergedBits.grpFP0BP
#define LCDRAM0_FP1BP                   _LCDRAM0.MergedBits.grpFP1BP

#define LCDRAM0_FP0BP0_MASK             1
#define LCDRAM0_FP0BP1_MASK             2
#define LCDRAM0_FP0BP2_MASK             4
#define LCDRAM0_FP0BP3_MASK             8
#define LCDRAM0_FP1BP0_MASK             16
#define LCDRAM0_FP1BP1_MASK             32
#define LCDRAM0_FP1BP2_MASK             64
#define LCDRAM0_FP1BP3_MASK             128
#define LCDRAM0_FP0BP_MASK              %BitsMask
#define LCDRAM0_FP0BP_BITNUM            %BitsNum
#define LCDRAM0_FP1BP_MASK              %BitsMask
#define LCDRAM0_FP1BP_BITNUM            %BitsNum


/*** LCDRAM1 - LCD RAM Register 1; 0x00000129 ***/
typedef union {
  byte Byte;
  struct {
    byte FP2BP0      :1;                                       /* LCD Segment FP2, BP0 ON */
    byte FP2BP1      :1;                                       /* LCD Segment FP2, BP1 ON */
    byte FP2BP2      :1;                                       /* LCD Segment FP2, BP2 ON */
    byte FP2BP3      :1;                                       /* LCD Segment FP2, BP3 ON */
    byte FP3BP0      :1;                                       /* LCD Segment FP3, BP0 ON */
    byte FP3BP1      :1;                                       /* LCD Segment FP3, BP1 ON */
    byte FP3BP2      :1;                                       /* LCD Segment FP3, BP2 ON */
    byte FP3BP3      :1;                                       /* LCD Segment FP3, BP3 ON */
  } Bits;
  struct {
    byte grpFP2BP :4;
    byte grpFP3BP :4;
  } MergedBits;
} LCDRAM1STR;
extern volatile LCDRAM1STR _LCDRAM1 @(REG_BASE + 0x00000129);
#define LCDRAM1                         _LCDRAM1.Byte
#define LCDRAM1_FP2BP0                  _LCDRAM1.Bits.FP2BP0
#define LCDRAM1_FP2BP1                  _LCDRAM1.Bits.FP2BP1
#define LCDRAM1_FP2BP2                  _LCDRAM1.Bits.FP2BP2
#define LCDRAM1_FP2BP3                  _LCDRAM1.Bits.FP2BP3
#define LCDRAM1_FP3BP0                  _LCDRAM1.Bits.FP3BP0
#define LCDRAM1_FP3BP1                  _LCDRAM1.Bits.FP3BP1
#define LCDRAM1_FP3BP2                  _LCDRAM1.Bits.FP3BP2
#define LCDRAM1_FP3BP3                  _LCDRAM1.Bits.FP3BP3
#define LCDRAM1_FP2BP                   _LCDRAM1.MergedBits.grpFP2BP
#define LCDRAM1_FP3BP                   _LCDRAM1.MergedBits.grpFP3BP

#define LCDRAM1_FP2BP0_MASK             1
#define LCDRAM1_FP2BP1_MASK             2
#define LCDRAM1_FP2BP2_MASK             4
#define LCDRAM1_FP2BP3_MASK             8
#define LCDRAM1_FP3BP0_MASK             16
#define LCDRAM1_FP3BP1_MASK             32
#define LCDRAM1_FP3BP2_MASK             64
#define LCDRAM1_FP3BP3_MASK             128
#define LCDRAM1_FP2BP_MASK              %BitsMask
#define LCDRAM1_FP2BP_BITNUM            %BitsNum
#define LCDRAM1_FP3BP_MASK              %BitsMask
#define LCDRAM1_FP3BP_BITNUM            %BitsNum


/*** LCDRAM2 - LCD RAM Register 2; 0x0000012A ***/
typedef union {
  byte Byte;
  struct {
    byte FP4BP0      :1;                                       /* LCD Segment FP4, BP0 ON */
    byte FP4BP1      :1;                                       /* LCD Segment FP4, BP1 ON */
    byte FP4BP2      :1;                                       /* LCD Segment FP4, BP2 ON */
    byte FP4BP3      :1;                                       /* LCD Segment FP4, BP3 ON */
    byte FP5BP0      :1;                                       /* LCD Segment FP5, BP0 ON */
    byte FP5BP1      :1;                                       /* LCD Segment FP5, BP1 ON */
    byte FP5BP2      :1;                                       /* LCD Segment FP5, BP2 ON */
    byte FP5BP3      :1;                                       /* LCD Segment FP5, BP3 ON */
  } Bits;
  struct {
    byte grpFP4BP :4;
    byte grpFP5BP :4;
  } MergedBits;
} LCDRAM2STR;
extern volatile LCDRAM2STR _LCDRAM2 @(REG_BASE + 0x0000012A);
#define LCDRAM2                         _LCDRAM2.Byte
#define LCDRAM2_FP4BP0                  _LCDRAM2.Bits.FP4BP0
#define LCDRAM2_FP4BP1                  _LCDRAM2.Bits.FP4BP1
#define LCDRAM2_FP4BP2                  _LCDRAM2.Bits.FP4BP2
#define LCDRAM2_FP4BP3                  _LCDRAM2.Bits.FP4BP3
#define LCDRAM2_FP5BP0                  _LCDRAM2.Bits.FP5BP0
#define LCDRAM2_FP5BP1                  _LCDRAM2.Bits.FP5BP1
#define LCDRAM2_FP5BP2                  _LCDRAM2.Bits.FP5BP2
#define LCDRAM2_FP5BP3                  _LCDRAM2.Bits.FP5BP3
#define LCDRAM2_FP4BP                   _LCDRAM2.MergedBits.grpFP4BP
#define LCDRAM2_FP5BP                   _LCDRAM2.MergedBits.grpFP5BP

#define LCDRAM2_FP4BP0_MASK             1
#define LCDRAM2_FP4BP1_MASK             2
#define LCDRAM2_FP4BP2_MASK             4
#define LCDRAM2_FP4BP3_MASK             8
#define LCDRAM2_FP5BP0_MASK             16
#define LCDRAM2_FP5BP1_MASK             32
#define LCDRAM2_FP5BP2_MASK             64
#define LCDRAM2_FP5BP3_MASK             128
#define LCDRAM2_FP4BP_MASK              %BitsMask
#define LCDRAM2_FP4BP_BITNUM            %BitsNum
#define LCDRAM2_FP5BP_MASK              %BitsMask
#define LCDRAM2_FP5BP_BITNUM            %BitsNum


/*** LCDRAM3 - LCD RAM Register 3; 0x0000012B ***/
typedef union {
  byte Byte;
  struct {
    byte FP6BP0      :1;                                       /* LCD Segment FP6, BP0 ON */
    byte FP6BP1      :1;                                       /* LCD Segment FP6, BP1 ON */
    byte FP6BP2      :1;                                       /* LCD Segment FP6, BP2 ON */
    byte FP6BP3      :1;                                       /* LCD Segment FP6, BP3 ON */
    byte FP7BP0      :1;                                       /* LCD Segment FP7, BP0 ON */
    byte FP7BP1      :1;                                       /* LCD Segment FP7, BP1 ON */
    byte FP7BP2      :1;                                       /* LCD Segment FP7, BP2 ON */
    byte FP7BP3      :1;                                       /* LCD Segment FP7, BP3 ON */
  } Bits;
  struct {
    byte grpFP6BP :4;
    byte grpFP7BP :4;
  } MergedBits;
} LCDRAM3STR;
extern volatile LCDRAM3STR _LCDRAM3 @(REG_BASE + 0x0000012B);
#define LCDRAM3                         _LCDRAM3.Byte
#define LCDRAM3_FP6BP0                  _LCDRAM3.Bits.FP6BP0
#define LCDRAM3_FP6BP1                  _LCDRAM3.Bits.FP6BP1
#define LCDRAM3_FP6BP2                  _LCDRAM3.Bits.FP6BP2
#define LCDRAM3_FP6BP3                  _LCDRAM3.Bits.FP6BP3
#define LCDRAM3_FP7BP0                  _LCDRAM3.Bits.FP7BP0
#define LCDRAM3_FP7BP1                  _LCDRAM3.Bits.FP7BP1
#define LCDRAM3_FP7BP2                  _LCDRAM3.Bits.FP7BP2
#define LCDRAM3_FP7BP3                  _LCDRAM3.Bits.FP7BP3
#define LCDRAM3_FP6BP                   _LCDRAM3.MergedBits.grpFP6BP
#define LCDRAM3_FP7BP                   _LCDRAM3.MergedBits.grpFP7BP

#define LCDRAM3_FP6BP0_MASK             1
#define LCDRAM3_FP6BP1_MASK             2
#define LCDRAM3_FP6BP2_MASK             4
#define LCDRAM3_FP6BP3_MASK             8
#define LCDRAM3_FP7BP0_MASK             16
#define LCDRAM3_FP7BP1_MASK             32
#define LCDRAM3_FP7BP2_MASK             64
#define LCDRAM3_FP7BP3_MASK             128
#define LCDRAM3_FP6BP_MASK              %BitsMask
#define LCDRAM3_FP6BP_BITNUM            %BitsNum
#define LCDRAM3_FP7BP_MASK              %BitsMask
#define LCDRAM3_FP7BP_BITNUM            %BitsNum


/*** LCDRAM4 - LCD RAM Register 4; 0x0000012C ***/
typedef union {
  byte Byte;
  struct {
    byte FP8BP0      :1;                                       /* LCD Segment FP8, BP0 ON */
    byte FP8BP1      :1;                                       /* LCD Segment FP8, BP1 ON */
    byte FP8BP2      :1;                                       /* LCD Segment FP8, BP2 ON */
    byte FP8BP3      :1;                                       /* LCD Segment FP8, BP3 ON */
    byte FP9BP0      :1;                                       /* LCD Segment FP9, BP0 ON */
    byte FP9BP1      :1;                                       /* LCD Segment FP9, BP1 ON */
    byte FP9BP2      :1;                                       /* LCD Segment FP9, BP2 ON */
    byte FP9BP3      :1;                                       /* LCD Segment FP9, BP3 ON */
  } Bits;
  struct {
    byte grpFP8BP :4;
    byte grpFP9BP :4;
  } MergedBits;
} LCDRAM4STR;
extern volatile LCDRAM4STR _LCDRAM4 @(REG_BASE + 0x0000012C);
#define LCDRAM4                         _LCDRAM4.Byte
#define LCDRAM4_FP8BP0                  _LCDRAM4.Bits.FP8BP0
#define LCDRAM4_FP8BP1                  _LCDRAM4.Bits.FP8BP1
#define LCDRAM4_FP8BP2                  _LCDRAM4.Bits.FP8BP2
#define LCDRAM4_FP8BP3                  _LCDRAM4.Bits.FP8BP3
#define LCDRAM4_FP9BP0                  _LCDRAM4.Bits.FP9BP0
#define LCDRAM4_FP9BP1                  _LCDRAM4.Bits.FP9BP1
#define LCDRAM4_FP9BP2                  _LCDRAM4.Bits.FP9BP2
#define LCDRAM4_FP9BP3                  _LCDRAM4.Bits.FP9BP3
#define LCDRAM4_FP8BP                   _LCDRAM4.MergedBits.grpFP8BP
#define LCDRAM4_FP9BP                   _LCDRAM4.MergedBits.grpFP9BP

#define LCDRAM4_FP8BP0_MASK             1
#define LCDRAM4_FP8BP1_MASK             2
#define LCDRAM4_FP8BP2_MASK             4
#define LCDRAM4_FP8BP3_MASK             8
#define LCDRAM4_FP9BP0_MASK             16
#define LCDRAM4_FP9BP1_MASK             32
#define LCDRAM4_FP9BP2_MASK             64
#define LCDRAM4_FP9BP3_MASK             128
#define LCDRAM4_FP8BP_MASK              %BitsMask
#define LCDRAM4_FP8BP_BITNUM            %BitsNum
#define LCDRAM4_FP9BP_MASK              %BitsMask
#define LCDRAM4_FP9BP_BITNUM            %BitsNum


/*** LCDRAM5 - LCD RAM Register 5; 0x0000012D ***/
typedef union {
  byte Byte;
  struct {
    byte FP10BP0     :1;                                       /* LCD Segment FP10, BP0 ON */
    byte FP10BP1     :1;                                       /* LCD Segment FP10, BP1 ON */
    byte FP10BP2     :1;                                       /* LCD Segment FP10, BP2 ON */
    byte FP10BP3     :1;                                       /* LCD Segment FP10, BP3 ON */
    byte FP11BP0     :1;                                       /* LCD Segment FP11, BP0 ON */
    byte FP11BP1     :1;                                       /* LCD Segment FP11, BP1 ON */
    byte FP11BP2     :1;                                       /* LCD Segment FP11, BP2 ON */
    byte FP11BP3     :1;                                       /* LCD Segment FP11, BP3 ON */
  } Bits;
  struct {
    byte grpFP10BP :4;
    byte grpFP11BP :4;
  } MergedBits;
} LCDRAM5STR;
extern volatile LCDRAM5STR _LCDRAM5 @(REG_BASE + 0x0000012D);
#define LCDRAM5                         _LCDRAM5.Byte
#define LCDRAM5_FP10BP0                 _LCDRAM5.Bits.FP10BP0
#define LCDRAM5_FP10BP1                 _LCDRAM5.Bits.FP10BP1
#define LCDRAM5_FP10BP2                 _LCDRAM5.Bits.FP10BP2
#define LCDRAM5_FP10BP3                 _LCDRAM5.Bits.FP10BP3
#define LCDRAM5_FP11BP0                 _LCDRAM5.Bits.FP11BP0
#define LCDRAM5_FP11BP1                 _LCDRAM5.Bits.FP11BP1
#define LCDRAM5_FP11BP2                 _LCDRAM5.Bits.FP11BP2
#define LCDRAM5_FP11BP3                 _LCDRAM5.Bits.FP11BP3
#define LCDRAM5_FP10BP                  _LCDRAM5.MergedBits.grpFP10BP
#define LCDRAM5_FP11BP                  _LCDRAM5.MergedBits.grpFP11BP

#define LCDRAM5_FP10BP0_MASK            1
#define LCDRAM5_FP10BP1_MASK            2
#define LCDRAM5_FP10BP2_MASK            4
#define LCDRAM5_FP10BP3_MASK            8
#define LCDRAM5_FP11BP0_MASK            16
#define LCDRAM5_FP11BP1_MASK            32
#define LCDRAM5_FP11BP2_MASK            64
#define LCDRAM5_FP11BP3_MASK            128
#define LCDRAM5_FP10BP_MASK             %BitsMask
#define LCDRAM5_FP10BP_BITNUM           %BitsNum
#define LCDRAM5_FP11BP_MASK             %BitsMask
#define LCDRAM5_FP11BP_BITNUM           %BitsNum


/*** LCDRAM6 - LCD RAM Register 6; 0x0000012E ***/
typedef union {
  byte Byte;
  struct {
    byte FP12BP0     :1;                                       /* LCD Segment FP12, BP0 ON */
    byte FP12BP1     :1;                                       /* LCD Segment FP12, BP1 ON */
    byte FP12BP2     :1;                                       /* LCD Segment FP12, BP2 ON */
    byte FP12BP3     :1;                                       /* LCD Segment FP12, BP3 ON */
    byte FP13BP0     :1;                                       /* LCD Segment FP13, BP0 ON */
    byte FP13BP1     :1;                                       /* LCD Segment FP13, BP1 ON */
    byte FP13BP2     :1;                                       /* LCD Segment FP13, BP2 ON */
    byte FP13BP3     :1;                                       /* LCD Segment FP13, BP3 ON */
  } Bits;
  struct {
    byte grpFP12BP :4;
    byte grpFP13BP :4;
  } MergedBits;
} LCDRAM6STR;
extern volatile LCDRAM6STR _LCDRAM6 @(REG_BASE + 0x0000012E);
#define LCDRAM6                         _LCDRAM6.Byte
#define LCDRAM6_FP12BP0                 _LCDRAM6.Bits.FP12BP0
#define LCDRAM6_FP12BP1                 _LCDRAM6.Bits.FP12BP1
#define LCDRAM6_FP12BP2                 _LCDRAM6.Bits.FP12BP2
#define LCDRAM6_FP12BP3                 _LCDRAM6.Bits.FP12BP3
#define LCDRAM6_FP13BP0                 _LCDRAM6.Bits.FP13BP0
#define LCDRAM6_FP13BP1                 _LCDRAM6.Bits.FP13BP1
#define LCDRAM6_FP13BP2                 _LCDRAM6.Bits.FP13BP2
#define LCDRAM6_FP13BP3                 _LCDRAM6.Bits.FP13BP3
#define LCDRAM6_FP12BP                  _LCDRAM6.MergedBits.grpFP12BP
#define LCDRAM6_FP13BP                  _LCDRAM6.MergedBits.grpFP13BP

#define LCDRAM6_FP12BP0_MASK            1
#define LCDRAM6_FP12BP1_MASK            2
#define LCDRAM6_FP12BP2_MASK            4
#define LCDRAM6_FP12BP3_MASK            8
#define LCDRAM6_FP13BP0_MASK            16
#define LCDRAM6_FP13BP1_MASK            32
#define LCDRAM6_FP13BP2_MASK            64
#define LCDRAM6_FP13BP3_MASK            128
#define LCDRAM6_FP12BP_MASK             %BitsMask
#define LCDRAM6_FP12BP_BITNUM           %BitsNum
#define LCDRAM6_FP13BP_MASK             %BitsMask
#define LCDRAM6_FP13BP_BITNUM           %BitsNum


/*** LCDRAM7 - LCD RAM Register 7; 0x0000012F ***/
typedef union {
  byte Byte;
  struct {
    byte FP14BP0     :1;                                       /* LCD Segment FP14, BP0 ON */
    byte FP14BP1     :1;                                       /* LCD Segment FP14, BP1 ON */
    byte FP14BP2     :1;                                       /* LCD Segment FP14, BP2 ON */
    byte FP14BP3     :1;                                       /* LCD Segment FP14, BP3 ON */
    byte FP15BP0     :1;                                       /* LCD Segment FP15, BP0 ON */
    byte FP15BP1     :1;                                       /* LCD Segment FP15, BP1 ON */
    byte FP15BP2     :1;                                       /* LCD Segment FP15, BP2 ON */
    byte FP15BP3     :1;                                       /* LCD Segment FP15, BP3 ON */
  } Bits;
  struct {
    byte grpFP14BP :4;
    byte grpFP15BP :4;
  } MergedBits;
} LCDRAM7STR;
extern volatile LCDRAM7STR _LCDRAM7 @(REG_BASE + 0x0000012F);
#define LCDRAM7                         _LCDRAM7.Byte
#define LCDRAM7_FP14BP0                 _LCDRAM7.Bits.FP14BP0
#define LCDRAM7_FP14BP1                 _LCDRAM7.Bits.FP14BP1
#define LCDRAM7_FP14BP2                 _LCDRAM7.Bits.FP14BP2
#define LCDRAM7_FP14BP3                 _LCDRAM7.Bits.FP14BP3
#define LCDRAM7_FP15BP0                 _LCDRAM7.Bits.FP15BP0
#define LCDRAM7_FP15BP1                 _LCDRAM7.Bits.FP15BP1
#define LCDRAM7_FP15BP2                 _LCDRAM7.Bits.FP15BP2
#define LCDRAM7_FP15BP3                 _LCDRAM7.Bits.FP15BP3
#define LCDRAM7_FP14BP                  _LCDRAM7.MergedBits.grpFP14BP
#define LCDRAM7_FP15BP                  _LCDRAM7.MergedBits.grpFP15BP

#define LCDRAM7_FP14BP0_MASK            1
#define LCDRAM7_FP14BP1_MASK            2
#define LCDRAM7_FP14BP2_MASK            4
#define LCDRAM7_FP14BP3_MASK            8
#define LCDRAM7_FP15BP0_MASK            16
#define LCDRAM7_FP15BP1_MASK            32
#define LCDRAM7_FP15BP2_MASK            64
#define LCDRAM7_FP15BP3_MASK            128
#define LCDRAM7_FP14BP_MASK             %BitsMask
#define LCDRAM7_FP14BP_BITNUM           %BitsNum
#define LCDRAM7_FP15BP_MASK             %BitsMask
#define LCDRAM7_FP15BP_BITNUM           %BitsNum


/*** LCDRAM8 - LCD RAM Register 8; 0x00000130 ***/
typedef union {
  byte Byte;
  struct {
    byte FP16BP0     :1;                                       /* LCD Segment FP16, BP0 ON */
    byte FP16BP1     :1;                                       /* LCD Segment FP16, BP1 ON */
    byte FP16BP2     :1;                                       /* LCD Segment FP16, BP2 ON */
    byte FP16BP3     :1;                                       /* LCD Segment FP16, BP3 ON */
    byte FP17BP0     :1;                                       /* LCD Segment FP17, BP0 ON */
    byte FP17BP1     :1;                                       /* LCD Segment FP17, BP1 ON */
    byte FP17BP2     :1;                                       /* LCD Segment FP17, BP2 ON */
    byte FP17BP3     :1;                                       /* LCD Segment FP17, BP3 ON */
  } Bits;
  struct {
    byte grpFP16BP :4;
    byte grpFP17BP :4;
  } MergedBits;
} LCDRAM8STR;
extern volatile LCDRAM8STR _LCDRAM8 @(REG_BASE + 0x00000130);
#define LCDRAM8                         _LCDRAM8.Byte
#define LCDRAM8_FP16BP0                 _LCDRAM8.Bits.FP16BP0
#define LCDRAM8_FP16BP1                 _LCDRAM8.Bits.FP16BP1
#define LCDRAM8_FP16BP2                 _LCDRAM8.Bits.FP16BP2
#define LCDRAM8_FP16BP3                 _LCDRAM8.Bits.FP16BP3
#define LCDRAM8_FP17BP0                 _LCDRAM8.Bits.FP17BP0
#define LCDRAM8_FP17BP1                 _LCDRAM8.Bits.FP17BP1
#define LCDRAM8_FP17BP2                 _LCDRAM8.Bits.FP17BP2
#define LCDRAM8_FP17BP3                 _LCDRAM8.Bits.FP17BP3
#define LCDRAM8_FP16BP                  _LCDRAM8.MergedBits.grpFP16BP
#define LCDRAM8_FP17BP                  _LCDRAM8.MergedBits.grpFP17BP

#define LCDRAM8_FP16BP0_MASK            1
#define LCDRAM8_FP16BP1_MASK            2
#define LCDRAM8_FP16BP2_MASK            4
#define LCDRAM8_FP16BP3_MASK            8
#define LCDRAM8_FP17BP0_MASK            16
#define LCDRAM8_FP17BP1_MASK            32
#define LCDRAM8_FP17BP2_MASK            64
#define LCDRAM8_FP17BP3_MASK            128
#define LCDRAM8_FP16BP_MASK             %BitsMask
#define LCDRAM8_FP16BP_BITNUM           %BitsNum
#define LCDRAM8_FP17BP_MASK             %BitsMask
#define LCDRAM8_FP17BP_BITNUM           %BitsNum


/*** LCDRAM9 - LCD RAM Register 9; 0x00000131 ***/
typedef union {
  byte Byte;
  struct {
    byte FP18BP0     :1;                                       /* LCD Segment FP18, BP0 ON */
    byte FP18BP1     :1;                                       /* LCD Segment FP18, BP1 ON */
    byte FP18BP2     :1;                                       /* LCD Segment FP18, BP2 ON */
    byte FP18BP3     :1;                                       /* LCD Segment FP18, BP3 ON */
    byte FP19BP0     :1;                                       /* LCD Segment FP19, BP0 ON */
    byte FP19BP1     :1;                                       /* LCD Segment FP19, BP1 ON */
    byte FP19BP2     :1;                                       /* LCD Segment FP19, BP2 ON */
    byte FP19BP3     :1;                                       /* LCD Segment FP19, BP3 ON */
  } Bits;
  struct {
    byte grpFP18BP :4;
    byte grpFP19BP :4;
  } MergedBits;
} LCDRAM9STR;
extern volatile LCDRAM9STR _LCDRAM9 @(REG_BASE + 0x00000131);
#define LCDRAM9                         _LCDRAM9.Byte
#define LCDRAM9_FP18BP0                 _LCDRAM9.Bits.FP18BP0
#define LCDRAM9_FP18BP1                 _LCDRAM9.Bits.FP18BP1
#define LCDRAM9_FP18BP2                 _LCDRAM9.Bits.FP18BP2
#define LCDRAM9_FP18BP3                 _LCDRAM9.Bits.FP18BP3
#define LCDRAM9_FP19BP0                 _LCDRAM9.Bits.FP19BP0
#define LCDRAM9_FP19BP1                 _LCDRAM9.Bits.FP19BP1
#define LCDRAM9_FP19BP2                 _LCDRAM9.Bits.FP19BP2
#define LCDRAM9_FP19BP3                 _LCDRAM9.Bits.FP19BP3
#define LCDRAM9_FP18BP                  _LCDRAM9.MergedBits.grpFP18BP
#define LCDRAM9_FP19BP                  _LCDRAM9.MergedBits.grpFP19BP

#define LCDRAM9_FP18BP0_MASK            1
#define LCDRAM9_FP18BP1_MASK            2
#define LCDRAM9_FP18BP2_MASK            4
#define LCDRAM9_FP18BP3_MASK            8
#define LCDRAM9_FP19BP0_MASK            16
#define LCDRAM9_FP19BP1_MASK            32
#define LCDRAM9_FP19BP2_MASK            64
#define LCDRAM9_FP19BP3_MASK            128
#define LCDRAM9_FP18BP_MASK             %BitsMask
#define LCDRAM9_FP18BP_BITNUM           %BitsNum
#define LCDRAM9_FP19BP_MASK             %BitsMask
#define LCDRAM9_FP19BP_BITNUM           %BitsNum


/*** LCDRAM10 - LCD RAM Register 10; 0x00000132 ***/
typedef union {
  byte Byte;
  struct {
    byte FP20BP0     :1;                                       /* LCD Segment FP20, BP0 ON */
    byte FP20BP1     :1;                                       /* LCD Segment FP20, BP1 ON */
    byte FP20BP2     :1;                                       /* LCD Segment FP20, BP2 ON */
    byte FP20BP3     :1;                                       /* LCD Segment FP20, BP3 ON */
    byte FP21BP0     :1;                                       /* LCD Segment FP21, BP0 ON */
    byte FP21BP1     :1;                                       /* LCD Segment FP21, BP1 ON */
    byte FP21BP2     :1;                                       /* LCD Segment FP21, BP2 ON */
    byte FP21BP3     :1;                                       /* LCD Segment FP21, BP3 ON */
  } Bits;
  struct {
    byte grpFP20BP :4;
    byte grpFP21BP :4;
  } MergedBits;
} LCDRAM10STR;
extern volatile LCDRAM10STR _LCDRAM10 @(REG_BASE + 0x00000132);
#define LCDRAM10                        _LCDRAM10.Byte
#define LCDRAM10_FP20BP0                _LCDRAM10.Bits.FP20BP0
#define LCDRAM10_FP20BP1                _LCDRAM10.Bits.FP20BP1
#define LCDRAM10_FP20BP2                _LCDRAM10.Bits.FP20BP2
#define LCDRAM10_FP20BP3                _LCDRAM10.Bits.FP20BP3
#define LCDRAM10_FP21BP0                _LCDRAM10.Bits.FP21BP0
#define LCDRAM10_FP21BP1                _LCDRAM10.Bits.FP21BP1
#define LCDRAM10_FP21BP2                _LCDRAM10.Bits.FP21BP2
#define LCDRAM10_FP21BP3                _LCDRAM10.Bits.FP21BP3
#define LCDRAM10_FP20BP                 _LCDRAM10.MergedBits.grpFP20BP
#define LCDRAM10_FP21BP                 _LCDRAM10.MergedBits.grpFP21BP

#define LCDRAM10_FP20BP0_MASK           1
#define LCDRAM10_FP20BP1_MASK           2
#define LCDRAM10_FP20BP2_MASK           4
#define LCDRAM10_FP20BP3_MASK           8
#define LCDRAM10_FP21BP0_MASK           16
#define LCDRAM10_FP21BP1_MASK           32
#define LCDRAM10_FP21BP2_MASK           64
#define LCDRAM10_FP21BP3_MASK           128
#define LCDRAM10_FP20BP_MASK            %BitsMask
#define LCDRAM10_FP20BP_BITNUM          %BitsNum
#define LCDRAM10_FP21BP_MASK            %BitsMask
#define LCDRAM10_FP21BP_BITNUM          %BitsNum


/*** LCDRAM11 - LCD RAM Register 11; 0x00000133 ***/
typedef union {
  byte Byte;
  struct {
    byte FP22BP0     :1;                                       /* LCD Segment FP22, BP0 ON */
    byte FP22BP1     :1;                                       /* LCD Segment FP22, BP1 ON */
    byte FP22BP2     :1;                                       /* LCD Segment FP22, BP2 ON */
    byte FP22BP3     :1;                                       /* LCD Segment FP22, BP3 ON */
    byte FP23BP0     :1;                                       /* LCD Segment FP23, BP0 ON */
    byte FP23BP1     :1;                                       /* LCD Segment FP23, BP1 ON */
    byte FP23BP2     :1;                                       /* LCD Segment FP23, BP2 ON */
    byte FP23BP3     :1;                                       /* LCD Segment FP23, BP3 ON */
  } Bits;
  struct {
    byte grpFP22BP :4;
    byte grpFP23BP :4;
  } MergedBits;
} LCDRAM11STR;
extern volatile LCDRAM11STR _LCDRAM11 @(REG_BASE + 0x00000133);
#define LCDRAM11                        _LCDRAM11.Byte
#define LCDRAM11_FP22BP0                _LCDRAM11.Bits.FP22BP0
#define LCDRAM11_FP22BP1                _LCDRAM11.Bits.FP22BP1
#define LCDRAM11_FP22BP2                _LCDRAM11.Bits.FP22BP2
#define LCDRAM11_FP22BP3                _LCDRAM11.Bits.FP22BP3
#define LCDRAM11_FP23BP0                _LCDRAM11.Bits.FP23BP0
#define LCDRAM11_FP23BP1                _LCDRAM11.Bits.FP23BP1
#define LCDRAM11_FP23BP2                _LCDRAM11.Bits.FP23BP2
#define LCDRAM11_FP23BP3                _LCDRAM11.Bits.FP23BP3
#define LCDRAM11_FP22BP                 _LCDRAM11.MergedBits.grpFP22BP
#define LCDRAM11_FP23BP                 _LCDRAM11.MergedBits.grpFP23BP

#define LCDRAM11_FP22BP0_MASK           1
#define LCDRAM11_FP22BP1_MASK           2
#define LCDRAM11_FP22BP2_MASK           4
#define LCDRAM11_FP22BP3_MASK           8
#define LCDRAM11_FP23BP0_MASK           16
#define LCDRAM11_FP23BP1_MASK           32
#define LCDRAM11_FP23BP2_MASK           64
#define LCDRAM11_FP23BP3_MASK           128
#define LCDRAM11_FP22BP_MASK            %BitsMask
#define LCDRAM11_FP22BP_BITNUM          %BitsNum
#define LCDRAM11_FP23BP_MASK            %BitsMask
#define LCDRAM11_FP23BP_BITNUM          %BitsNum


/*** LCDRAM12 - LCD RAM Register 12; 0x00000134 ***/
typedef union {
  byte Byte;
  struct {
    byte FP24BP0     :1;                                       /* LCD Segment FP24, BP0 ON */
    byte FP24BP1     :1;                                       /* LCD Segment FP24, BP1 ON */
    byte FP24BP2     :1;                                       /* LCD Segment FP24, BP2 ON */
    byte FP24BP3     :1;                                       /* LCD Segment FP24, BP3 ON */
    byte FP25BP0     :1;                                       /* LCD Segment FP25, BP0 ON */
    byte FP25BP1     :1;                                       /* LCD Segment FP25, BP1 ON */
    byte FP25BP2     :1;                                       /* LCD Segment FP25, BP2 ON */
    byte FP25BP3     :1;                                       /* LCD Segment FP25, BP3 ON */
  } Bits;
  struct {
    byte grpFP24BP :4;
    byte grpFP25BP :4;
  } MergedBits;
} LCDRAM12STR;
extern volatile LCDRAM12STR _LCDRAM12 @(REG_BASE + 0x00000134);
#define LCDRAM12                        _LCDRAM12.Byte
#define LCDRAM12_FP24BP0                _LCDRAM12.Bits.FP24BP0
#define LCDRAM12_FP24BP1                _LCDRAM12.Bits.FP24BP1
#define LCDRAM12_FP24BP2                _LCDRAM12.Bits.FP24BP2
#define LCDRAM12_FP24BP3                _LCDRAM12.Bits.FP24BP3
#define LCDRAM12_FP25BP0                _LCDRAM12.Bits.FP25BP0
#define LCDRAM12_FP25BP1                _LCDRAM12.Bits.FP25BP1
#define LCDRAM12_FP25BP2                _LCDRAM12.Bits.FP25BP2
#define LCDRAM12_FP25BP3                _LCDRAM12.Bits.FP25BP3
#define LCDRAM12_FP24BP                 _LCDRAM12.MergedBits.grpFP24BP
#define LCDRAM12_FP25BP                 _LCDRAM12.MergedBits.grpFP25BP

#define LCDRAM12_FP24BP0_MASK           1
#define LCDRAM12_FP24BP1_MASK           2
#define LCDRAM12_FP24BP2_MASK           4
#define LCDRAM12_FP24BP3_MASK           8
#define LCDRAM12_FP25BP0_MASK           16
#define LCDRAM12_FP25BP1_MASK           32
#define LCDRAM12_FP25BP2_MASK           64
#define LCDRAM12_FP25BP3_MASK           128
#define LCDRAM12_FP24BP_MASK            %BitsMask
#define LCDRAM12_FP24BP_BITNUM          %BitsNum
#define LCDRAM12_FP25BP_MASK            %BitsMask
#define LCDRAM12_FP25BP_BITNUM          %BitsNum


/*** LCDRAM13 - LCD RAM Register 13; 0x00000135 ***/
typedef union {
  byte Byte;
  struct {
    byte FP26BP0     :1;                                       /* LCD Segment FP26, BP0 ON */
    byte FP26BP1     :1;                                       /* LCD Segment FP26, BP1 ON */
    byte FP26BP2     :1;                                       /* LCD Segment FP26, BP2 ON */
    byte FP26BP3     :1;                                       /* LCD Segment FP26, BP3 ON */
    byte FP27BP0     :1;                                       /* LCD Segment FP27, BP0 ON */
    byte FP27BP1     :1;                                       /* LCD Segment FP27, BP1 ON */
    byte FP27BP2     :1;                                       /* LCD Segment FP27, BP2 ON */
    byte FP27BP3     :1;                                       /* LCD Segment FP27, BP3 ON */
  } Bits;
  struct {
    byte grpFP26BP :4;
    byte grpFP27BP :4;
  } MergedBits;
} LCDRAM13STR;
extern volatile LCDRAM13STR _LCDRAM13 @(REG_BASE + 0x00000135);
#define LCDRAM13                        _LCDRAM13.Byte
#define LCDRAM13_FP26BP0                _LCDRAM13.Bits.FP26BP0
#define LCDRAM13_FP26BP1                _LCDRAM13.Bits.FP26BP1
#define LCDRAM13_FP26BP2                _LCDRAM13.Bits.FP26BP2
#define LCDRAM13_FP26BP3                _LCDRAM13.Bits.FP26BP3
#define LCDRAM13_FP27BP0                _LCDRAM13.Bits.FP27BP0
#define LCDRAM13_FP27BP1                _LCDRAM13.Bits.FP27BP1
#define LCDRAM13_FP27BP2                _LCDRAM13.Bits.FP27BP2
#define LCDRAM13_FP27BP3                _LCDRAM13.Bits.FP27BP3
#define LCDRAM13_FP26BP                 _LCDRAM13.MergedBits.grpFP26BP
#define LCDRAM13_FP27BP                 _LCDRAM13.MergedBits.grpFP27BP

#define LCDRAM13_FP26BP0_MASK           1
#define LCDRAM13_FP26BP1_MASK           2
#define LCDRAM13_FP26BP2_MASK           4
#define LCDRAM13_FP26BP3_MASK           8
#define LCDRAM13_FP27BP0_MASK           16
#define LCDRAM13_FP27BP1_MASK           32
#define LCDRAM13_FP27BP2_MASK           64
#define LCDRAM13_FP27BP3_MASK           128
#define LCDRAM13_FP26BP_MASK            %BitsMask
#define LCDRAM13_FP26BP_BITNUM          %BitsNum
#define LCDRAM13_FP27BP_MASK            %BitsMask
#define LCDRAM13_FP27BP_BITNUM          %BitsNum


/*** LCDRAM14 - LCD RAM Register 14; 0x00000136 ***/
typedef union {
  byte Byte;
  struct {
    byte FP28BP0     :1;                                       /* LCD Segment FP28, BP0 ON */
    byte FP28BP1     :1;                                       /* LCD Segment FP28, BP1 ON */
    byte FP28BP2     :1;                                       /* LCD Segment FP28, BP2 ON */
    byte FP28BP3     :1;                                       /* LCD Segment FP28, BP3 ON */
    byte FP29BP0     :1;                                       /* LCD Segment FP29, BP0 ON */
    byte FP29BP1     :1;                                       /* LCD Segment FP29, BP1 ON */
    byte FP29BP2     :1;                                       /* LCD Segment FP29, BP2 ON */
    byte FP29BP3     :1;                                       /* LCD Segment FP29, BP3 ON */
  } Bits;
  struct {
    byte grpFP28BP :4;
    byte grpFP29BP :4;
  } MergedBits;
} LCDRAM14STR;
extern volatile LCDRAM14STR _LCDRAM14 @(REG_BASE + 0x00000136);
#define LCDRAM14                        _LCDRAM14.Byte
#define LCDRAM14_FP28BP0                _LCDRAM14.Bits.FP28BP0
#define LCDRAM14_FP28BP1                _LCDRAM14.Bits.FP28BP1
#define LCDRAM14_FP28BP2                _LCDRAM14.Bits.FP28BP2
#define LCDRAM14_FP28BP3                _LCDRAM14.Bits.FP28BP3
#define LCDRAM14_FP29BP0                _LCDRAM14.Bits.FP29BP0
#define LCDRAM14_FP29BP1                _LCDRAM14.Bits.FP29BP1
#define LCDRAM14_FP29BP2                _LCDRAM14.Bits.FP29BP2
#define LCDRAM14_FP29BP3                _LCDRAM14.Bits.FP29BP3
#define LCDRAM14_FP28BP                 _LCDRAM14.MergedBits.grpFP28BP
#define LCDRAM14_FP29BP                 _LCDRAM14.MergedBits.grpFP29BP

#define LCDRAM14_FP28BP0_MASK           1
#define LCDRAM14_FP28BP1_MASK           2
#define LCDRAM14_FP28BP2_MASK           4
#define LCDRAM14_FP28BP3_MASK           8
#define LCDRAM14_FP29BP0_MASK           16
#define LCDRAM14_FP29BP1_MASK           32
#define LCDRAM14_FP29BP2_MASK           64
#define LCDRAM14_FP29BP3_MASK           128
#define LCDRAM14_FP28BP_MASK            %BitsMask
#define LCDRAM14_FP28BP_BITNUM          %BitsNum
#define LCDRAM14_FP29BP_MASK            %BitsMask
#define LCDRAM14_FP29BP_BITNUM          %BitsNum


/*** LCDRAM15 - LCD RAM Register 15; 0x00000137 ***/
typedef union {
  byte Byte;
  struct {
    byte FP30BP0     :1;                                       /* LCD Segment FP30, BP0 ON */
    byte FP30BP1     :1;                                       /* LCD Segment FP30, BP1 ON */
    byte FP30BP2     :1;                                       /* LCD Segment FP30, BP2 ON */
    byte FP30BP3     :1;                                       /* LCD Segment FP30, BP3 ON */
    byte FP31BP0     :1;                                       /* LCD Segment FP31, BP0 ON */
    byte FP31BP1     :1;                                       /* LCD Segment FP31, BP1 ON */
    byte FP31BP2     :1;                                       /* LCD Segment FP31, BP2 ON */
    byte FP31BP3     :1;                                       /* LCD Segment FP31, BP3 ON */
  } Bits;
  struct {
    byte grpFP30BP :4;
    byte grpFP31BP :4;
  } MergedBits;
} LCDRAM15STR;
extern volatile LCDRAM15STR _LCDRAM15 @(REG_BASE + 0x00000137);
#define LCDRAM15                        _LCDRAM15.Byte
#define LCDRAM15_FP30BP0                _LCDRAM15.Bits.FP30BP0
#define LCDRAM15_FP30BP1                _LCDRAM15.Bits.FP30BP1
#define LCDRAM15_FP30BP2                _LCDRAM15.Bits.FP30BP2
#define LCDRAM15_FP30BP3                _LCDRAM15.Bits.FP30BP3
#define LCDRAM15_FP31BP0                _LCDRAM15.Bits.FP31BP0
#define LCDRAM15_FP31BP1                _LCDRAM15.Bits.FP31BP1
#define LCDRAM15_FP31BP2                _LCDRAM15.Bits.FP31BP2
#define LCDRAM15_FP31BP3                _LCDRAM15.Bits.FP31BP3
#define LCDRAM15_FP30BP                 _LCDRAM15.MergedBits.grpFP30BP
#define LCDRAM15_FP31BP                 _LCDRAM15.MergedBits.grpFP31BP

#define LCDRAM15_FP30BP0_MASK           1
#define LCDRAM15_FP30BP1_MASK           2
#define LCDRAM15_FP30BP2_MASK           4
#define LCDRAM15_FP30BP3_MASK           8
#define LCDRAM15_FP31BP0_MASK           16
#define LCDRAM15_FP31BP1_MASK           32
#define LCDRAM15_FP31BP2_MASK           64
#define LCDRAM15_FP31BP3_MASK           128
#define LCDRAM15_FP30BP_MASK            %BitsMask
#define LCDRAM15_FP30BP_BITNUM          %BitsNum
#define LCDRAM15_FP31BP_MASK            %BitsMask
#define LCDRAM15_FP31BP_BITNUM          %BitsNum


/*** CAN0CTL0 - MSCAN 0 Control 0 Register; 0x00000140 ***/
typedef union {
  byte Byte;
  struct {
    byte INITRQ      :1;                                       /* Initialization Mode Request */
    byte SLPRQ       :1;                                       /* Sleep Mode Request */
    byte WUPE        :1;                                       /* Wake-Up Enable */
    byte TIME        :1;                                       /* Timer Enable */
    byte SYNCH       :1;                                       /* Synchronized Status */
    byte CSWAI       :1;                                       /* CAN Stops in Wait Mode */
    byte RXACT       :1;                                       /* Receiver Active Status */
    byte RXFRM       :1;                                       /* Received Frame Flag */
  } Bits;
} CAN0CTL0STR;
extern volatile CAN0CTL0STR _CAN0CTL0 @(REG_BASE + 0x00000140);
#define CAN0CTL0                        _CAN0CTL0.Byte
#define CAN0CTL0_INITRQ                 _CAN0CTL0.Bits.INITRQ
#define CAN0CTL0_SLPRQ                  _CAN0CTL0.Bits.SLPRQ
#define CAN0CTL0_WUPE                   _CAN0CTL0.Bits.WUPE
#define CAN0CTL0_TIME                   _CAN0CTL0.Bits.TIME
#define CAN0CTL0_SYNCH                  _CAN0CTL0.Bits.SYNCH
#define CAN0CTL0_CSWAI                  _CAN0CTL0.Bits.CSWAI
#define CAN0CTL0_RXACT                  _CAN0CTL0.Bits.RXACT
#define CAN0CTL0_RXFRM                  _CAN0CTL0.Bits.RXFRM
/* CAN0CTL_ARR: Access 2 CAN0CTLx registers in a array */
#define CAN0CTL_ARR                     ((Byte *) &CAN0CTL0)

#define CAN0CTL0_INITRQ_MASK            1
#define CAN0CTL0_SLPRQ_MASK             2
#define CAN0CTL0_WUPE_MASK              4
#define CAN0CTL0_TIME_MASK              8
#define CAN0CTL0_SYNCH_MASK             16
#define CAN0CTL0_CSWAI_MASK             32
#define CAN0CTL0_RXACT_MASK             64
#define CAN0CTL0_RXFRM_MASK             128


/*** CAN0CTL1 - MSCAN 0 Control 1 Register; 0x00000141 ***/
typedef union {
  byte Byte;
  struct {
    byte INITAK      :1;                                       /* Initialization Mode Acknowledge */
    byte SLPAK       :1;                                       /* Sleep Mode Acknowledge */
    byte WUPM        :1;                                       /* Wake-Up Mode */
    byte             :1; 
    byte LISTEN      :1;                                       /* Listen Only Mode */
    byte LOOPB       :1;                                       /* Loop Back Self Test Mode */
    byte CLKSRC      :1;                                       /* MSCAN 0 Clock Source */
    byte CANE        :1;                                       /* MSCAN 0 Enable */
  } Bits;
} CAN0CTL1STR;
extern volatile CAN0CTL1STR _CAN0CTL1 @(REG_BASE + 0x00000141);
#define CAN0CTL1                        _CAN0CTL1.Byte
#define CAN0CTL1_INITAK                 _CAN0CTL1.Bits.INITAK
#define CAN0CTL1_SLPAK                  _CAN0CTL1.Bits.SLPAK
#define CAN0CTL1_WUPM                   _CAN0CTL1.Bits.WUPM
#define CAN0CTL1_LISTEN                 _CAN0CTL1.Bits.LISTEN
#define CAN0CTL1_LOOPB                  _CAN0CTL1.Bits.LOOPB
#define CAN0CTL1_CLKSRC                 _CAN0CTL1.Bits.CLKSRC
#define CAN0CTL1_CANE                   _CAN0CTL1.Bits.CANE

#define CAN0CTL1_INITAK_MASK            1
#define CAN0CTL1_SLPAK_MASK             2
#define CAN0CTL1_WUPM_MASK              4
#define CAN0CTL1_LISTEN_MASK            16
#define CAN0CTL1_LOOPB_MASK             32
#define CAN0CTL1_CLKSRC_MASK            64
#define CAN0CTL1_CANE_MASK              128


/*** CAN0BTR0 - MSCAN 0 Bus Timing Register 0; 0x00000142 ***/
typedef union {
  byte Byte;
  struct {
    byte BRP0        :1;                                       /* Baud Rate Prescaler 0 */
    byte BRP1        :1;                                       /* Baud Rate Prescaler 1 */
    byte BRP2        :1;                                       /* Baud Rate Prescaler 2 */
    byte BRP3        :1;                                       /* Baud Rate Prescaler 3 */
    byte BRP4        :1;                                       /* Baud Rate Prescaler 4 */
    byte BRP5        :1;                                       /* Baud Rate Prescaler 5 */
    byte SJW0        :1;                                       /* Synchronization Jump Width 0 */
    byte SJW1        :1;                                       /* Synchronization Jump Width 1 */
  } Bits;
  struct {
    byte grpBRP  :6;
    byte grpSJW  :2;
  } MergedBits;
} CAN0BTR0STR;
extern volatile CAN0BTR0STR _CAN0BTR0 @(REG_BASE + 0x00000142);
#define CAN0BTR0                        _CAN0BTR0.Byte
#define CAN0BTR0_BRP0                   _CAN0BTR0.Bits.BRP0
#define CAN0BTR0_BRP1                   _CAN0BTR0.Bits.BRP1
#define CAN0BTR0_BRP2                   _CAN0BTR0.Bits.BRP2
#define CAN0BTR0_BRP3                   _CAN0BTR0.Bits.BRP3
#define CAN0BTR0_BRP4                   _CAN0BTR0.Bits.BRP4
#define CAN0BTR0_BRP5                   _CAN0BTR0.Bits.BRP5
#define CAN0BTR0_SJW0                   _CAN0BTR0.Bits.SJW0
#define CAN0BTR0_SJW1                   _CAN0BTR0.Bits.SJW1
/* CAN0BTR_ARR: Access 2 CAN0BTRx registers in a array */
#define CAN0BTR_ARR                     ((Byte *) &CAN0BTR0)
#define CAN0BTR0_BRP                    _CAN0BTR0.MergedBits.grpBRP
#define CAN0BTR0_SJW                    _CAN0BTR0.MergedBits.grpSJW

#define CAN0BTR0_BRP0_MASK              1
#define CAN0BTR0_BRP1_MASK              2
#define CAN0BTR0_BRP2_MASK              4
#define CAN0BTR0_BRP3_MASK              8
#define CAN0BTR0_BRP4_MASK              16
#define CAN0BTR0_BRP5_MASK              32
#define CAN0BTR0_SJW0_MASK              64
#define CAN0BTR0_SJW1_MASK              128
#define CAN0BTR0_BRP_MASK               %BitsMask
#define CAN0BTR0_BRP_BITNUM             %BitsNum
#define CAN0BTR0_SJW_MASK               %BitsMask
#define CAN0BTR0_SJW_BITNUM             %BitsNum


/*** CAN0BTR1 - MSCAN 0 Bus Timing Register 1; 0x00000143 ***/
typedef union {
  byte Byte;
  struct {
    byte TSEG10      :1;                                       /* Time Segment 10 */
    byte TSEG11      :1;                                       /* Time Segment 11 */
    byte TSEG12      :1;                                       /* Time Segment 12 */
    byte TSEG13      :1;                                       /* Time Segment 13 */
    byte TSEG20      :1;                                       /* Time Segment 20 */
    byte TSEG21      :1;                                       /* Time Segment 21 */
    byte TSEG22      :1;                                       /* Time Segment 22 */
    byte SAMP        :1;                                       /* Sampling */
  } Bits;
  struct {
    byte grpTSEG_10 :4;
    byte grpTSEG_20 :3;
    byte         :1;
  } MergedBits;
} CAN0BTR1STR;
extern volatile CAN0BTR1STR _CAN0BTR1 @(REG_BASE + 0x00000143);
#define CAN0BTR1                        _CAN0BTR1.Byte
#define CAN0BTR1_TSEG10                 _CAN0BTR1.Bits.TSEG10
#define CAN0BTR1_TSEG11                 _CAN0BTR1.Bits.TSEG11
#define CAN0BTR1_TSEG12                 _CAN0BTR1.Bits.TSEG12
#define CAN0BTR1_TSEG13                 _CAN0BTR1.Bits.TSEG13
#define CAN0BTR1_TSEG20                 _CAN0BTR1.Bits.TSEG20
#define CAN0BTR1_TSEG21                 _CAN0BTR1.Bits.TSEG21
#define CAN0BTR1_TSEG22                 _CAN0BTR1.Bits.TSEG22
#define CAN0BTR1_SAMP                   _CAN0BTR1.Bits.SAMP
#define CAN0BTR1_TSEG_10                _CAN0BTR1.MergedBits.grpTSEG_10
#define CAN0BTR1_TSEG_20                _CAN0BTR1.MergedBits.grpTSEG_20
#define CAN0BTR1_TSEG                   CAN0BTR1_TSEG_10

#define CAN0BTR1_TSEG10_MASK            1
#define CAN0BTR1_TSEG11_MASK            2
#define CAN0BTR1_TSEG12_MASK            4
#define CAN0BTR1_TSEG13_MASK            8
#define CAN0BTR1_TSEG20_MASK            16
#define CAN0BTR1_TSEG21_MASK            32
#define CAN0BTR1_TSEG22_MASK            64
#define CAN0BTR1_SAMP_MASK              128
#define CAN0BTR1_TSEG_10_MASK           %BitsMask
#define CAN0BTR1_TSEG_10_BITNUM         %BitsNum
#define CAN0BTR1_TSEG_20_MASK           %BitsMask
#define CAN0BTR1_TSEG_20_BITNUM         %BitsNum


/*** CAN0RFLG - MSCAN 0 Receiver Flag Register; 0x00000144 ***/
typedef union {
  byte Byte;
  struct {
    byte RXF         :1;                                       /* Receive Buffer Full */
    byte OVRIF       :1;                                       /* Overrun Interrupt Flag */
    byte TSTAT0      :1;                                       /* Transmitter Status Bit 0 */
    byte TSTAT1      :1;                                       /* Transmitter Status Bit 1 */
    byte RSTAT0      :1;                                       /* Receiver Status Bit 0 */
    byte RSTAT1      :1;                                       /* Receiver Status Bit 1 */
    byte CSCIF       :1;                                       /* CAN Status Change Interrupt Flag */
    byte WUPIF       :1;                                       /* Wake-up Interrupt Flag */
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte grpTSTAT :2;
    byte grpRSTAT :2;
    byte         :1;
    byte         :1;
  } MergedBits;
} CAN0RFLGSTR;
extern volatile CAN0RFLGSTR _CAN0RFLG @(REG_BASE + 0x00000144);
#define CAN0RFLG                        _CAN0RFLG.Byte
#define CAN0RFLG_RXF                    _CAN0RFLG.Bits.RXF
#define CAN0RFLG_OVRIF                  _CAN0RFLG.Bits.OVRIF
#define CAN0RFLG_TSTAT0                 _CAN0RFLG.Bits.TSTAT0
#define CAN0RFLG_TSTAT1                 _CAN0RFLG.Bits.TSTAT1
#define CAN0RFLG_RSTAT0                 _CAN0RFLG.Bits.RSTAT0
#define CAN0RFLG_RSTAT1                 _CAN0RFLG.Bits.RSTAT1
#define CAN0RFLG_CSCIF                  _CAN0RFLG.Bits.CSCIF
#define CAN0RFLG_WUPIF                  _CAN0RFLG.Bits.WUPIF
#define CAN0RFLG_TSTAT                  _CAN0RFLG.MergedBits.grpTSTAT
#define CAN0RFLG_RSTAT                  _CAN0RFLG.MergedBits.grpRSTAT

#define CAN0RFLG_RXF_MASK               1
#define CAN0RFLG_OVRIF_MASK             2
#define CAN0RFLG_TSTAT0_MASK            4
#define CAN0RFLG_TSTAT1_MASK            8
#define CAN0RFLG_RSTAT0_MASK            16
#define CAN0RFLG_RSTAT1_MASK            32
#define CAN0RFLG_CSCIF_MASK             64
#define CAN0RFLG_WUPIF_MASK             128
#define CAN0RFLG_TSTAT_MASK             %BitsMask
#define CAN0RFLG_TSTAT_BITNUM           %BitsNum
#define CAN0RFLG_RSTAT_MASK             %BitsMask
#define CAN0RFLG_RSTAT_BITNUM           %BitsNum


/*** CAN0RIER - MSCAN 0 Receiver Interrupt Enable Register; 0x00000145 ***/
typedef union {
  byte Byte;
  struct {
    byte RXFIE       :1;                                       /* Receiver Full Interrupt Enable */
    byte OVRIE       :1;                                       /* Overrun Interrupt Enable */
    byte TSTATE0     :1;                                       /* Transmitter Status Change Enable 0 */
    byte TSTATE1     :1;                                       /* Transmitter Status Change Enable 1 */
    byte RSTATE0     :1;                                       /* Receiver Status Change Enable 0 */
    byte RSTATE1     :1;                                       /* Receiver Status Change Enable 1 */
    byte CSCIE       :1;                                       /* CAN Status Change Interrupt Enable */
    byte WUPIE       :1;                                       /* Wake-up Interrupt Enable */
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte grpTSTATE :2;
    byte grpRSTATE :2;
    byte         :1;
    byte         :1;
  } MergedBits;
} CAN0RIERSTR;
extern volatile CAN0RIERSTR _CAN0RIER @(REG_BASE + 0x00000145);
#define CAN0RIER                        _CAN0RIER.Byte
#define CAN0RIER_RXFIE                  _CAN0RIER.Bits.RXFIE
#define CAN0RIER_OVRIE                  _CAN0RIER.Bits.OVRIE
#define CAN0RIER_TSTATE0                _CAN0RIER.Bits.TSTATE0
#define CAN0RIER_TSTATE1                _CAN0RIER.Bits.TSTATE1
#define CAN0RIER_RSTATE0                _CAN0RIER.Bits.RSTATE0
#define CAN0RIER_RSTATE1                _CAN0RIER.Bits.RSTATE1
#define CAN0RIER_CSCIE                  _CAN0RIER.Bits.CSCIE
#define CAN0RIER_WUPIE                  _CAN0RIER.Bits.WUPIE
#define CAN0RIER_TSTATE                 _CAN0RIER.MergedBits.grpTSTATE
#define CAN0RIER_RSTATE                 _CAN0RIER.MergedBits.grpRSTATE

#define CAN0RIER_RXFIE_MASK             1
#define CAN0RIER_OVRIE_MASK             2
#define CAN0RIER_TSTATE0_MASK           4
#define CAN0RIER_TSTATE1_MASK           8
#define CAN0RIER_RSTATE0_MASK           16
#define CAN0RIER_RSTATE1_MASK           32
#define CAN0RIER_CSCIE_MASK             64
#define CAN0RIER_WUPIE_MASK             128
#define CAN0RIER_TSTATE_MASK            %BitsMask
#define CAN0RIER_TSTATE_BITNUM          %BitsNum
#define CAN0RIER_RSTATE_MASK            %BitsMask
#define CAN0RIER_RSTATE_BITNUM          %BitsNum


/*** CAN0TFLG - MSCAN 0 Transmitter Flag Register; 0x00000146 ***/
typedef union {
  byte Byte;
  struct {
    byte TXE0        :1;                                       /* Transmitter Buffer Empty 0 */
    byte TXE1        :1;                                       /* Transmitter Buffer Empty 1 */
    byte TXE2        :1;                                       /* Transmitter Buffer Empty 2 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpTXE  :3;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} CAN0TFLGSTR;
extern volatile CAN0TFLGSTR _CAN0TFLG @(REG_BASE + 0x00000146);
#define CAN0TFLG                        _CAN0TFLG.Byte
#define CAN0TFLG_TXE0                   _CAN0TFLG.Bits.TXE0
#define CAN0TFLG_TXE1                   _CAN0TFLG.Bits.TXE1
#define CAN0TFLG_TXE2                   _CAN0TFLG.Bits.TXE2
#define CAN0TFLG_TXE                    _CAN0TFLG.MergedBits.grpTXE

#define CAN0TFLG_TXE0_MASK              1
#define CAN0TFLG_TXE1_MASK              2
#define CAN0TFLG_TXE2_MASK              4
#define CAN0TFLG_TXE_MASK               %BitsMask
#define CAN0TFLG_TXE_BITNUM             %BitsNum


/*** CAN0TIER - MSCAN 0 Transmitter Interrupt Enable Register; 0x00000147 ***/
typedef union {
  byte Byte;
  struct {
    byte TXEIE0      :1;                                       /* Transmitter Empty Interrupt Enable 0 */
    byte TXEIE1      :1;                                       /* Transmitter Empty Interrupt Enable 1 */
    byte TXEIE2      :1;                                       /* Transmitter Empty Interrupt Enable 2 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpTXEIE :3;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} CAN0TIERSTR;
extern volatile CAN0TIERSTR _CAN0TIER @(REG_BASE + 0x00000147);
#define CAN0TIER                        _CAN0TIER.Byte
#define CAN0TIER_TXEIE0                 _CAN0TIER.Bits.TXEIE0
#define CAN0TIER_TXEIE1                 _CAN0TIER.Bits.TXEIE1
#define CAN0TIER_TXEIE2                 _CAN0TIER.Bits.TXEIE2
#define CAN0TIER_TXEIE                  _CAN0TIER.MergedBits.grpTXEIE

#define CAN0TIER_TXEIE0_MASK            1
#define CAN0TIER_TXEIE1_MASK            2
#define CAN0TIER_TXEIE2_MASK            4
#define CAN0TIER_TXEIE_MASK             %BitsMask
#define CAN0TIER_TXEIE_BITNUM           %BitsNum


/*** CAN0TARQ - MSCAN 0 Transmitter Message Abort Request; 0x00000148 ***/
typedef union {
  byte Byte;
  struct {
    byte ABTRQ0      :1;                                       /* Abort Request 0 */
    byte ABTRQ1      :1;                                       /* Abort Request 1 */
    byte ABTRQ2      :1;                                       /* Abort Request 2 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpABTRQ :3;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} CAN0TARQSTR;
extern volatile CAN0TARQSTR _CAN0TARQ @(REG_BASE + 0x00000148);
#define CAN0TARQ                        _CAN0TARQ.Byte
#define CAN0TARQ_ABTRQ0                 _CAN0TARQ.Bits.ABTRQ0
#define CAN0TARQ_ABTRQ1                 _CAN0TARQ.Bits.ABTRQ1
#define CAN0TARQ_ABTRQ2                 _CAN0TARQ.Bits.ABTRQ2
#define CAN0TARQ_ABTRQ                  _CAN0TARQ.MergedBits.grpABTRQ

#define CAN0TARQ_ABTRQ0_MASK            1
#define CAN0TARQ_ABTRQ1_MASK            2
#define CAN0TARQ_ABTRQ2_MASK            4
#define CAN0TARQ_ABTRQ_MASK             %BitsMask
#define CAN0TARQ_ABTRQ_BITNUM           %BitsNum


/*** CAN0TAAK - MSCAN 0 Transmitter Message Abort Control; 0x00000149 ***/
typedef union {
  byte Byte;
  struct {
    byte ABTAK0      :1;                                       /* Abort Acknowledge 0 */
    byte ABTAK1      :1;                                       /* Abort Acknowledge 1 */
    byte ABTAK2      :1;                                       /* Abort Acknowledge 2 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpABTAK :3;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} CAN0TAAKSTR;
extern volatile CAN0TAAKSTR _CAN0TAAK @(REG_BASE + 0x00000149);
#define CAN0TAAK                        _CAN0TAAK.Byte
#define CAN0TAAK_ABTAK0                 _CAN0TAAK.Bits.ABTAK0
#define CAN0TAAK_ABTAK1                 _CAN0TAAK.Bits.ABTAK1
#define CAN0TAAK_ABTAK2                 _CAN0TAAK.Bits.ABTAK2
#define CAN0TAAK_ABTAK                  _CAN0TAAK.MergedBits.grpABTAK

#define CAN0TAAK_ABTAK0_MASK            1
#define CAN0TAAK_ABTAK1_MASK            2
#define CAN0TAAK_ABTAK2_MASK            4
#define CAN0TAAK_ABTAK_MASK             %BitsMask
#define CAN0TAAK_ABTAK_BITNUM           %BitsNum


/*** CAN0TBSEL - MSCAN 0 Transmit Buffer Selection; 0x0000014A ***/
typedef union {
  byte Byte;
  struct {
    byte TX0         :1;                                       /* Transmit Buffer Select 0 */
    byte TX1         :1;                                       /* Transmit Buffer Select 1 */
    byte TX2         :1;                                       /* Transmit Buffer Select 2 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpTX   :3;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} CAN0TBSELSTR;
extern volatile CAN0TBSELSTR _CAN0TBSEL @(REG_BASE + 0x0000014A);
#define CAN0TBSEL                       _CAN0TBSEL.Byte
#define CAN0TBSEL_TX0                   _CAN0TBSEL.Bits.TX0
#define CAN0TBSEL_TX1                   _CAN0TBSEL.Bits.TX1
#define CAN0TBSEL_TX2                   _CAN0TBSEL.Bits.TX2
#define CAN0TBSEL_TX                    _CAN0TBSEL.MergedBits.grpTX

#define CAN0TBSEL_TX0_MASK              1
#define CAN0TBSEL_TX1_MASK              2
#define CAN0TBSEL_TX2_MASK              4
#define CAN0TBSEL_TX_MASK               %BitsMask
#define CAN0TBSEL_TX_BITNUM             %BitsNum


/*** CAN0IDAC - MSCAN 0 Identifier Acceptance Control Register; 0x0000014B ***/
typedef union {
  byte Byte;
  struct {
    byte IDHIT0      :1;                                       /* Identifier Acceptance Hit Indicator 0 */
    byte IDHIT1      :1;                                       /* Identifier Acceptance Hit Indicator 1 */
    byte IDHIT2      :1;                                       /* Identifier Acceptance Hit Indicator 2 */
    byte             :1; 
    byte IDAM0       :1;                                       /* Identifier Acceptance Mode 0 */
    byte IDAM1       :1;                                       /* Identifier Acceptance Mode 1 */
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpIDHIT :3;
    byte         :1;
    byte grpIDAM :2;
    byte         :1;
    byte         :1;
  } MergedBits;
} CAN0IDACSTR;
extern volatile CAN0IDACSTR _CAN0IDAC @(REG_BASE + 0x0000014B);
#define CAN0IDAC                        _CAN0IDAC.Byte
#define CAN0IDAC_IDHIT0                 _CAN0IDAC.Bits.IDHIT0
#define CAN0IDAC_IDHIT1                 _CAN0IDAC.Bits.IDHIT1
#define CAN0IDAC_IDHIT2                 _CAN0IDAC.Bits.IDHIT2
#define CAN0IDAC_IDAM0                  _CAN0IDAC.Bits.IDAM0
#define CAN0IDAC_IDAM1                  _CAN0IDAC.Bits.IDAM1
#define CAN0IDAC_IDHIT                  _CAN0IDAC.MergedBits.grpIDHIT
#define CAN0IDAC_IDAM                   _CAN0IDAC.MergedBits.grpIDAM

#define CAN0IDAC_IDHIT0_MASK            1
#define CAN0IDAC_IDHIT1_MASK            2
#define CAN0IDAC_IDHIT2_MASK            4
#define CAN0IDAC_IDAM0_MASK             16
#define CAN0IDAC_IDAM1_MASK             32
#define CAN0IDAC_IDHIT_MASK             %BitsMask
#define CAN0IDAC_IDHIT_BITNUM           %BitsNum
#define CAN0IDAC_IDAM_MASK              %BitsMask
#define CAN0IDAC_IDAM_BITNUM            %BitsNum


/*** CAN0RXERR - MSCAN 0 Receive Error Counter Register; 0x0000014E ***/
typedef union {
  byte Byte;
  struct {
    byte RXERR0      :1;                                       /* Bit 0 */
    byte RXERR1      :1;                                       /* Bit 1 */
    byte RXERR2      :1;                                       /* Bit 2 */
    byte RXERR3      :1;                                       /* Bit 3 */
    byte RXERR4      :1;                                       /* Bit 4 */
    byte RXERR5      :1;                                       /* Bit 5 */
    byte RXERR6      :1;                                       /* Bit 6 */
    byte RXERR7      :1;                                       /* Bit 7 */
  } Bits;
} CAN0RXERRSTR;
extern volatile CAN0RXERRSTR _CAN0RXERR @(REG_BASE + 0x0000014E);
#define CAN0RXERR                       _CAN0RXERR.Byte
#define CAN0RXERR_RXERR0                _CAN0RXERR.Bits.RXERR0
#define CAN0RXERR_RXERR1                _CAN0RXERR.Bits.RXERR1
#define CAN0RXERR_RXERR2                _CAN0RXERR.Bits.RXERR2
#define CAN0RXERR_RXERR3                _CAN0RXERR.Bits.RXERR3
#define CAN0RXERR_RXERR4                _CAN0RXERR.Bits.RXERR4
#define CAN0RXERR_RXERR5                _CAN0RXERR.Bits.RXERR5
#define CAN0RXERR_RXERR6                _CAN0RXERR.Bits.RXERR6
#define CAN0RXERR_RXERR7                _CAN0RXERR.Bits.RXERR7

#define CAN0RXERR_RXERR0_MASK           1
#define CAN0RXERR_RXERR1_MASK           2
#define CAN0RXERR_RXERR2_MASK           4
#define CAN0RXERR_RXERR3_MASK           8
#define CAN0RXERR_RXERR4_MASK           16
#define CAN0RXERR_RXERR5_MASK           32
#define CAN0RXERR_RXERR6_MASK           64
#define CAN0RXERR_RXERR7_MASK           128


/*** CAN0TXERR - MSCAN 0 Transmit Error Counter Register; 0x0000014F ***/
typedef union {
  byte Byte;
  struct {
    byte TXERR0      :1;                                       /* Bit 0 */
    byte TXERR1      :1;                                       /* Bit 1 */
    byte TXERR2      :1;                                       /* Bit 2 */
    byte TXERR3      :1;                                       /* Bit 3 */
    byte TXERR4      :1;                                       /* Bit 4 */
    byte TXERR5      :1;                                       /* Bit 5 */
    byte TXERR6      :1;                                       /* Bit 6 */
    byte TXERR7      :1;                                       /* Bit 7 */
  } Bits;
} CAN0TXERRSTR;
extern volatile CAN0TXERRSTR _CAN0TXERR @(REG_BASE + 0x0000014F);
#define CAN0TXERR                       _CAN0TXERR.Byte
#define CAN0TXERR_TXERR0                _CAN0TXERR.Bits.TXERR0
#define CAN0TXERR_TXERR1                _CAN0TXERR.Bits.TXERR1
#define CAN0TXERR_TXERR2                _CAN0TXERR.Bits.TXERR2
#define CAN0TXERR_TXERR3                _CAN0TXERR.Bits.TXERR3
#define CAN0TXERR_TXERR4                _CAN0TXERR.Bits.TXERR4
#define CAN0TXERR_TXERR5                _CAN0TXERR.Bits.TXERR5
#define CAN0TXERR_TXERR6                _CAN0TXERR.Bits.TXERR6
#define CAN0TXERR_TXERR7                _CAN0TXERR.Bits.TXERR7

#define CAN0TXERR_TXERR0_MASK           1
#define CAN0TXERR_TXERR1_MASK           2
#define CAN0TXERR_TXERR2_MASK           4
#define CAN0TXERR_TXERR3_MASK           8
#define CAN0TXERR_TXERR4_MASK           16
#define CAN0TXERR_TXERR5_MASK           32
#define CAN0TXERR_TXERR6_MASK           64
#define CAN0TXERR_TXERR7_MASK           128


/*** CAN0IDAR0 - MSCAN 0 Identifier Acceptance Register 0; 0x00000150 ***/
typedef union {
  byte Byte;
  struct {
    byte AC0         :1;                                       /* Acceptance Code Bit 0 */
    byte AC1         :1;                                       /* Acceptance Code Bit 1 */
    byte AC2         :1;                                       /* Acceptance Code Bit 2 */
    byte AC3         :1;                                       /* Acceptance Code Bit 3 */
    byte AC4         :1;                                       /* Acceptance Code Bit 4 */
    byte AC5         :1;                                       /* Acceptance Code Bit 5 */
    byte AC6         :1;                                       /* Acceptance Code Bit 6 */
    byte AC7         :1;                                       /* Acceptance Code Bit 7 */
  } Bits;
} CAN0IDAR0STR;
extern volatile CAN0IDAR0STR _CAN0IDAR0 @(REG_BASE + 0x00000150);
#define CAN0IDAR0                       _CAN0IDAR0.Byte
#define CAN0IDAR0_AC0                   _CAN0IDAR0.Bits.AC0
#define CAN0IDAR0_AC1                   _CAN0IDAR0.Bits.AC1
#define CAN0IDAR0_AC2                   _CAN0IDAR0.Bits.AC2
#define CAN0IDAR0_AC3                   _CAN0IDAR0.Bits.AC3
#define CAN0IDAR0_AC4                   _CAN0IDAR0.Bits.AC4
#define CAN0IDAR0_AC5                   _CAN0IDAR0.Bits.AC5
#define CAN0IDAR0_AC6                   _CAN0IDAR0.Bits.AC6
#define CAN0IDAR0_AC7                   _CAN0IDAR0.Bits.AC7
/* CAN0IDAR_ARR: Access 4 CAN0IDARx registers in a array */
#define CAN0IDAR_ARR                    ((Byte *) &CAN0IDAR0)

#define CAN0IDAR0_AC0_MASK              1
#define CAN0IDAR0_AC1_MASK              2
#define CAN0IDAR0_AC2_MASK              4
#define CAN0IDAR0_AC3_MASK              8
#define CAN0IDAR0_AC4_MASK              16
#define CAN0IDAR0_AC5_MASK              32
#define CAN0IDAR0_AC6_MASK              64
#define CAN0IDAR0_AC7_MASK              128


/*** CAN0IDAR1 - MSCAN 0 Identifier Acceptance Register 1; 0x00000151 ***/
typedef union {
  byte Byte;
  struct {
    byte AC0         :1;                                       /* Acceptance Code Bit 0 */
    byte AC1         :1;                                       /* Acceptance Code Bit 1 */
    byte AC2         :1;                                       /* Acceptance Code Bit 2 */
    byte AC3         :1;                                       /* Acceptance Code Bit 3 */
    byte AC4         :1;                                       /* Acceptance Code Bit 4 */
    byte AC5         :1;                                       /* Acceptance Code Bit 5 */
    byte AC6         :1;                                       /* Acceptance Code Bit 6 */
    byte AC7         :1;                                       /* Acceptance Code Bit 7 */
  } Bits;
} CAN0IDAR1STR;
extern volatile CAN0IDAR1STR _CAN0IDAR1 @(REG_BASE + 0x00000151);
#define CAN0IDAR1                       _CAN0IDAR1.Byte
#define CAN0IDAR1_AC0                   _CAN0IDAR1.Bits.AC0
#define CAN0IDAR1_AC1                   _CAN0IDAR1.Bits.AC1
#define CAN0IDAR1_AC2                   _CAN0IDAR1.Bits.AC2
#define CAN0IDAR1_AC3                   _CAN0IDAR1.Bits.AC3
#define CAN0IDAR1_AC4                   _CAN0IDAR1.Bits.AC4
#define CAN0IDAR1_AC5                   _CAN0IDAR1.Bits.AC5
#define CAN0IDAR1_AC6                   _CAN0IDAR1.Bits.AC6
#define CAN0IDAR1_AC7                   _CAN0IDAR1.Bits.AC7

#define CAN0IDAR1_AC0_MASK              1
#define CAN0IDAR1_AC1_MASK              2
#define CAN0IDAR1_AC2_MASK              4
#define CAN0IDAR1_AC3_MASK              8
#define CAN0IDAR1_AC4_MASK              16
#define CAN0IDAR1_AC5_MASK              32
#define CAN0IDAR1_AC6_MASK              64
#define CAN0IDAR1_AC7_MASK              128


/*** CAN0IDAR2 - MSCAN 0 Identifier Acceptance Register 2; 0x00000152 ***/
typedef union {
  byte Byte;
  struct {
    byte AC0         :1;                                       /* Acceptance Code Bit 0 */
    byte AC1         :1;                                       /* Acceptance Code Bit 1 */
    byte AC2         :1;                                       /* Acceptance Code Bit 2 */
    byte AC3         :1;                                       /* Acceptance Code Bit 3 */
    byte AC4         :1;                                       /* Acceptance Code Bit 4 */
    byte AC5         :1;                                       /* Acceptance Code Bit 5 */
    byte AC6         :1;                                       /* Acceptance Code Bit 6 */
    byte AC7         :1;                                       /* Acceptance Code Bit 7 */
  } Bits;
} CAN0IDAR2STR;
extern volatile CAN0IDAR2STR _CAN0IDAR2 @(REG_BASE + 0x00000152);
#define CAN0IDAR2                       _CAN0IDAR2.Byte
#define CAN0IDAR2_AC0                   _CAN0IDAR2.Bits.AC0
#define CAN0IDAR2_AC1                   _CAN0IDAR2.Bits.AC1
#define CAN0IDAR2_AC2                   _CAN0IDAR2.Bits.AC2
#define CAN0IDAR2_AC3                   _CAN0IDAR2.Bits.AC3
#define CAN0IDAR2_AC4                   _CAN0IDAR2.Bits.AC4
#define CAN0IDAR2_AC5                   _CAN0IDAR2.Bits.AC5
#define CAN0IDAR2_AC6                   _CAN0IDAR2.Bits.AC6
#define CAN0IDAR2_AC7                   _CAN0IDAR2.Bits.AC7

#define CAN0IDAR2_AC0_MASK              1
#define CAN0IDAR2_AC1_MASK              2
#define CAN0IDAR2_AC2_MASK              4
#define CAN0IDAR2_AC3_MASK              8
#define CAN0IDAR2_AC4_MASK              16
#define CAN0IDAR2_AC5_MASK              32
#define CAN0IDAR2_AC6_MASK              64
#define CAN0IDAR2_AC7_MASK              128


/*** CAN0IDAR3 - MSCAN 0 Identifier Acceptance Register 3; 0x00000153 ***/
typedef union {
  byte Byte;
  struct {
    byte AC0         :1;                                       /* Acceptance Code Bit 0 */
    byte AC1         :1;                                       /* Acceptance Code Bit 1 */
    byte AC2         :1;                                       /* Acceptance Code Bit 2 */
    byte AC3         :1;                                       /* Acceptance Code Bit 3 */
    byte AC4         :1;                                       /* Acceptance Code Bit 4 */
    byte AC5         :1;                                       /* Acceptance Code Bit 5 */
    byte AC6         :1;                                       /* Acceptance Code Bit 6 */
    byte AC7         :1;                                       /* Acceptance Code Bit 7 */
  } Bits;
} CAN0IDAR3STR;
extern volatile CAN0IDAR3STR _CAN0IDAR3 @(REG_BASE + 0x00000153);
#define CAN0IDAR3                       _CAN0IDAR3.Byte
#define CAN0IDAR3_AC0                   _CAN0IDAR3.Bits.AC0
#define CAN0IDAR3_AC1                   _CAN0IDAR3.Bits.AC1
#define CAN0IDAR3_AC2                   _CAN0IDAR3.Bits.AC2
#define CAN0IDAR3_AC3                   _CAN0IDAR3.Bits.AC3
#define CAN0IDAR3_AC4                   _CAN0IDAR3.Bits.AC4
#define CAN0IDAR3_AC5                   _CAN0IDAR3.Bits.AC5
#define CAN0IDAR3_AC6                   _CAN0IDAR3.Bits.AC6
#define CAN0IDAR3_AC7                   _CAN0IDAR3.Bits.AC7

#define CAN0IDAR3_AC0_MASK              1
#define CAN0IDAR3_AC1_MASK              2
#define CAN0IDAR3_AC2_MASK              4
#define CAN0IDAR3_AC3_MASK              8
#define CAN0IDAR3_AC4_MASK              16
#define CAN0IDAR3_AC5_MASK              32
#define CAN0IDAR3_AC6_MASK              64
#define CAN0IDAR3_AC7_MASK              128


/*** CAN0IDMR0 - MSCAN 0 Identifier Mask Register 0; 0x00000154 ***/
typedef union {
  byte Byte;
  struct {
    byte AM0         :1;                                       /* Acceptance Mask Bit 0 */
    byte AM1         :1;                                       /* Acceptance Mask Bit 1 */
    byte AM2         :1;                                       /* Acceptance Mask Bit 2 */
    byte AM3         :1;                                       /* Acceptance Mask Bit 3 */
    byte AM4         :1;                                       /* Acceptance Mask Bit 4 */
    byte AM5         :1;                                       /* Acceptance Mask Bit 5 */
    byte AM6         :1;                                       /* Acceptance Mask Bit 6 */
    byte AM7         :1;                                       /* Acceptance Mask Bit 7 */
  } Bits;
} CAN0IDMR0STR;
extern volatile CAN0IDMR0STR _CAN0IDMR0 @(REG_BASE + 0x00000154);
#define CAN0IDMR0                       _CAN0IDMR0.Byte
#define CAN0IDMR0_AM0                   _CAN0IDMR0.Bits.AM0
#define CAN0IDMR0_AM1                   _CAN0IDMR0.Bits.AM1
#define CAN0IDMR0_AM2                   _CAN0IDMR0.Bits.AM2
#define CAN0IDMR0_AM3                   _CAN0IDMR0.Bits.AM3
#define CAN0IDMR0_AM4                   _CAN0IDMR0.Bits.AM4
#define CAN0IDMR0_AM5                   _CAN0IDMR0.Bits.AM5
#define CAN0IDMR0_AM6                   _CAN0IDMR0.Bits.AM6
#define CAN0IDMR0_AM7                   _CAN0IDMR0.Bits.AM7
/* CAN0IDMR_ARR: Access 4 CAN0IDMRx registers in a array */
#define CAN0IDMR_ARR                    ((Byte *) &CAN0IDMR0)

#define CAN0IDMR0_AM0_MASK              1
#define CAN0IDMR0_AM1_MASK              2
#define CAN0IDMR0_AM2_MASK              4
#define CAN0IDMR0_AM3_MASK              8
#define CAN0IDMR0_AM4_MASK              16
#define CAN0IDMR0_AM5_MASK              32
#define CAN0IDMR0_AM6_MASK              64
#define CAN0IDMR0_AM7_MASK              128


/*** CAN0IDMR1 - MSCAN 0 Identifier Mask Register 1; 0x00000155 ***/
typedef union {
  byte Byte;
  struct {
    byte AM0         :1;                                       /* Acceptance Mask Bit 0 */
    byte AM1         :1;                                       /* Acceptance Mask Bit 1 */
    byte AM2         :1;                                       /* Acceptance Mask Bit 2 */
    byte AM3         :1;                                       /* Acceptance Mask Bit 3 */
    byte AM4         :1;                                       /* Acceptance Mask Bit 4 */
    byte AM5         :1;                                       /* Acceptance Mask Bit 5 */
    byte AM6         :1;                                       /* Acceptance Mask Bit 6 */
    byte AM7         :1;                                       /* Acceptance Mask Bit 7 */
  } Bits;
} CAN0IDMR1STR;
extern volatile CAN0IDMR1STR _CAN0IDMR1 @(REG_BASE + 0x00000155);
#define CAN0IDMR1                       _CAN0IDMR1.Byte
#define CAN0IDMR1_AM0                   _CAN0IDMR1.Bits.AM0
#define CAN0IDMR1_AM1                   _CAN0IDMR1.Bits.AM1
#define CAN0IDMR1_AM2                   _CAN0IDMR1.Bits.AM2
#define CAN0IDMR1_AM3                   _CAN0IDMR1.Bits.AM3
#define CAN0IDMR1_AM4                   _CAN0IDMR1.Bits.AM4
#define CAN0IDMR1_AM5                   _CAN0IDMR1.Bits.AM5
#define CAN0IDMR1_AM6                   _CAN0IDMR1.Bits.AM6
#define CAN0IDMR1_AM7                   _CAN0IDMR1.Bits.AM7

#define CAN0IDMR1_AM0_MASK              1
#define CAN0IDMR1_AM1_MASK              2
#define CAN0IDMR1_AM2_MASK              4
#define CAN0IDMR1_AM3_MASK              8
#define CAN0IDMR1_AM4_MASK              16
#define CAN0IDMR1_AM5_MASK              32
#define CAN0IDMR1_AM6_MASK              64
#define CAN0IDMR1_AM7_MASK              128


/*** CAN0IDMR2 - MSCAN 0 Identifier Mask Register 2; 0x00000156 ***/
typedef union {
  byte Byte;
  struct {
    byte AM0         :1;                                       /* Acceptance Mask Bit 0 */
    byte AM1         :1;                                       /* Acceptance Mask Bit 1 */
    byte AM2         :1;                                       /* Acceptance Mask Bit 2 */
    byte AM3         :1;                                       /* Acceptance Mask Bit 3 */
    byte AM4         :1;                                       /* Acceptance Mask Bit 4 */
    byte AM5         :1;                                       /* Acceptance Mask Bit 5 */
    byte AM6         :1;                                       /* Acceptance Mask Bit 6 */
    byte AM7         :1;                                       /* Acceptance Mask Bit 7 */
  } Bits;
} CAN0IDMR2STR;
extern volatile CAN0IDMR2STR _CAN0IDMR2 @(REG_BASE + 0x00000156);
#define CAN0IDMR2                       _CAN0IDMR2.Byte
#define CAN0IDMR2_AM0                   _CAN0IDMR2.Bits.AM0
#define CAN0IDMR2_AM1                   _CAN0IDMR2.Bits.AM1
#define CAN0IDMR2_AM2                   _CAN0IDMR2.Bits.AM2
#define CAN0IDMR2_AM3                   _CAN0IDMR2.Bits.AM3
#define CAN0IDMR2_AM4                   _CAN0IDMR2.Bits.AM4
#define CAN0IDMR2_AM5                   _CAN0IDMR2.Bits.AM5
#define CAN0IDMR2_AM6                   _CAN0IDMR2.Bits.AM6
#define CAN0IDMR2_AM7                   _CAN0IDMR2.Bits.AM7

#define CAN0IDMR2_AM0_MASK              1
#define CAN0IDMR2_AM1_MASK              2
#define CAN0IDMR2_AM2_MASK              4
#define CAN0IDMR2_AM3_MASK              8
#define CAN0IDMR2_AM4_MASK              16
#define CAN0IDMR2_AM5_MASK              32
#define CAN0IDMR2_AM6_MASK              64
#define CAN0IDMR2_AM7_MASK              128


/*** CAN0IDMR3 - MSCAN 0 Identifier Mask Register 3; 0x00000157 ***/
typedef union {
  byte Byte;
  struct {
    byte AM0         :1;                                       /* Acceptance Mask Bit 0 */
    byte AM1         :1;                                       /* Acceptance Mask Bit 1 */
    byte AM2         :1;                                       /* Acceptance Mask Bit 2 */
    byte AM3         :1;                                       /* Acceptance Mask Bit 3 */
    byte AM4         :1;                                       /* Acceptance Mask Bit 4 */
    byte AM5         :1;                                       /* Acceptance Mask Bit 5 */
    byte AM6         :1;                                       /* Acceptance Mask Bit 6 */
    byte AM7         :1;                                       /* Acceptance Mask Bit 7 */
  } Bits;
} CAN0IDMR3STR;
extern volatile CAN0IDMR3STR _CAN0IDMR3 @(REG_BASE + 0x00000157);
#define CAN0IDMR3                       _CAN0IDMR3.Byte
#define CAN0IDMR3_AM0                   _CAN0IDMR3.Bits.AM0
#define CAN0IDMR3_AM1                   _CAN0IDMR3.Bits.AM1
#define CAN0IDMR3_AM2                   _CAN0IDMR3.Bits.AM2
#define CAN0IDMR3_AM3                   _CAN0IDMR3.Bits.AM3
#define CAN0IDMR3_AM4                   _CAN0IDMR3.Bits.AM4
#define CAN0IDMR3_AM5                   _CAN0IDMR3.Bits.AM5
#define CAN0IDMR3_AM6                   _CAN0IDMR3.Bits.AM6
#define CAN0IDMR3_AM7                   _CAN0IDMR3.Bits.AM7

#define CAN0IDMR3_AM0_MASK              1
#define CAN0IDMR3_AM1_MASK              2
#define CAN0IDMR3_AM2_MASK              4
#define CAN0IDMR3_AM3_MASK              8
#define CAN0IDMR3_AM4_MASK              16
#define CAN0IDMR3_AM5_MASK              32
#define CAN0IDMR3_AM6_MASK              64
#define CAN0IDMR3_AM7_MASK              128


/*** CAN0IDAR4 - MSCAN 0 Identifier Acceptance Register 4; 0x00000158 ***/
typedef union {
  byte Byte;
  struct {
    byte AC0         :1;                                       /* Acceptance Code Bit 0 */
    byte AC1         :1;                                       /* Acceptance Code Bit 1 */
    byte AC2         :1;                                       /* Acceptance Code Bit 2 */
    byte AC3         :1;                                       /* Acceptance Code Bit 3 */
    byte AC4         :1;                                       /* Acceptance Code Bit 4 */
    byte AC5         :1;                                       /* Acceptance Code Bit 5 */
    byte AC6         :1;                                       /* Acceptance Code Bit 6 */
    byte AC7         :1;                                       /* Acceptance Code Bit 7 */
  } Bits;
} CAN0IDAR4STR;
extern volatile CAN0IDAR4STR _CAN0IDAR4 @(REG_BASE + 0x00000158);
#define CAN0IDAR4                       _CAN0IDAR4.Byte
#define CAN0IDAR4_AC0                   _CAN0IDAR4.Bits.AC0
#define CAN0IDAR4_AC1                   _CAN0IDAR4.Bits.AC1
#define CAN0IDAR4_AC2                   _CAN0IDAR4.Bits.AC2
#define CAN0IDAR4_AC3                   _CAN0IDAR4.Bits.AC3
#define CAN0IDAR4_AC4                   _CAN0IDAR4.Bits.AC4
#define CAN0IDAR4_AC5                   _CAN0IDAR4.Bits.AC5
#define CAN0IDAR4_AC6                   _CAN0IDAR4.Bits.AC6
#define CAN0IDAR4_AC7                   _CAN0IDAR4.Bits.AC7

#define CAN0IDAR4_AC0_MASK              1
#define CAN0IDAR4_AC1_MASK              2
#define CAN0IDAR4_AC2_MASK              4
#define CAN0IDAR4_AC3_MASK              8
#define CAN0IDAR4_AC4_MASK              16
#define CAN0IDAR4_AC5_MASK              32
#define CAN0IDAR4_AC6_MASK              64
#define CAN0IDAR4_AC7_MASK              128


/*** CAN0IDAR5 - MSCAN 0 Identifier Acceptance Register 5; 0x00000159 ***/
typedef union {
  byte Byte;
  struct {
    byte AC0         :1;                                       /* Acceptance Code Bit 0 */
    byte AC1         :1;                                       /* Acceptance Code Bit 1 */
    byte AC2         :1;                                       /* Acceptance Code Bit 2 */
    byte AC3         :1;                                       /* Acceptance Code Bit 3 */
    byte AC4         :1;                                       /* Acceptance Code Bit 4 */
    byte AC5         :1;                                       /* Acceptance Code Bit 5 */
    byte AC6         :1;                                       /* Acceptance Code Bit 6 */
    byte AC7         :1;                                       /* Acceptance Code Bit 7 */
  } Bits;
} CAN0IDAR5STR;
extern volatile CAN0IDAR5STR _CAN0IDAR5 @(REG_BASE + 0x00000159);
#define CAN0IDAR5                       _CAN0IDAR5.Byte
#define CAN0IDAR5_AC0                   _CAN0IDAR5.Bits.AC0
#define CAN0IDAR5_AC1                   _CAN0IDAR5.Bits.AC1
#define CAN0IDAR5_AC2                   _CAN0IDAR5.Bits.AC2
#define CAN0IDAR5_AC3                   _CAN0IDAR5.Bits.AC3
#define CAN0IDAR5_AC4                   _CAN0IDAR5.Bits.AC4
#define CAN0IDAR5_AC5                   _CAN0IDAR5.Bits.AC5
#define CAN0IDAR5_AC6                   _CAN0IDAR5.Bits.AC6
#define CAN0IDAR5_AC7                   _CAN0IDAR5.Bits.AC7

#define CAN0IDAR5_AC0_MASK              1
#define CAN0IDAR5_AC1_MASK              2
#define CAN0IDAR5_AC2_MASK              4
#define CAN0IDAR5_AC3_MASK              8
#define CAN0IDAR5_AC4_MASK              16
#define CAN0IDAR5_AC5_MASK              32
#define CAN0IDAR5_AC6_MASK              64
#define CAN0IDAR5_AC7_MASK              128


/*** CAN0IDAR6 - MSCAN 0 Identifier Acceptance Register 6; 0x0000015A ***/
typedef union {
  byte Byte;
  struct {
    byte AC0         :1;                                       /* Acceptance Code Bit 0 */
    byte AC1         :1;                                       /* Acceptance Code Bit 1 */
    byte AC2         :1;                                       /* Acceptance Code Bit 2 */
    byte AC3         :1;                                       /* Acceptance Code Bit 3 */
    byte AC4         :1;                                       /* Acceptance Code Bit 4 */
    byte AC5         :1;                                       /* Acceptance Code Bit 5 */
    byte AC6         :1;                                       /* Acceptance Code Bit 6 */
    byte AC7         :1;                                       /* Acceptance Code Bit 7 */
  } Bits;
} CAN0IDAR6STR;
extern volatile CAN0IDAR6STR _CAN0IDAR6 @(REG_BASE + 0x0000015A);
#define CAN0IDAR6                       _CAN0IDAR6.Byte
#define CAN0IDAR6_AC0                   _CAN0IDAR6.Bits.AC0
#define CAN0IDAR6_AC1                   _CAN0IDAR6.Bits.AC1
#define CAN0IDAR6_AC2                   _CAN0IDAR6.Bits.AC2
#define CAN0IDAR6_AC3                   _CAN0IDAR6.Bits.AC3
#define CAN0IDAR6_AC4                   _CAN0IDAR6.Bits.AC4
#define CAN0IDAR6_AC5                   _CAN0IDAR6.Bits.AC5
#define CAN0IDAR6_AC6                   _CAN0IDAR6.Bits.AC6
#define CAN0IDAR6_AC7                   _CAN0IDAR6.Bits.AC7

#define CAN0IDAR6_AC0_MASK              1
#define CAN0IDAR6_AC1_MASK              2
#define CAN0IDAR6_AC2_MASK              4
#define CAN0IDAR6_AC3_MASK              8
#define CAN0IDAR6_AC4_MASK              16
#define CAN0IDAR6_AC5_MASK              32
#define CAN0IDAR6_AC6_MASK              64
#define CAN0IDAR6_AC7_MASK              128


/*** CAN0IDAR7 - MSCAN 0 Identifier Acceptance Register 7; 0x0000015B ***/
typedef union {
  byte Byte;
  struct {
    byte AC0         :1;                                       /* Acceptance Code Bit 0 */
    byte AC1         :1;                                       /* Acceptance Code Bit 1 */
    byte AC2         :1;                                       /* Acceptance Code Bit 2 */
    byte AC3         :1;                                       /* Acceptance Code Bit 3 */
    byte AC4         :1;                                       /* Acceptance Code Bit 4 */
    byte AC5         :1;                                       /* Acceptance Code Bit 5 */
    byte AC6         :1;                                       /* Acceptance Code Bit 6 */
    byte AC7         :1;                                       /* Acceptance Code Bit 7 */
  } Bits;
} CAN0IDAR7STR;
extern volatile CAN0IDAR7STR _CAN0IDAR7 @(REG_BASE + 0x0000015B);
#define CAN0IDAR7                       _CAN0IDAR7.Byte
#define CAN0IDAR7_AC0                   _CAN0IDAR7.Bits.AC0
#define CAN0IDAR7_AC1                   _CAN0IDAR7.Bits.AC1
#define CAN0IDAR7_AC2                   _CAN0IDAR7.Bits.AC2
#define CAN0IDAR7_AC3                   _CAN0IDAR7.Bits.AC3
#define CAN0IDAR7_AC4                   _CAN0IDAR7.Bits.AC4
#define CAN0IDAR7_AC5                   _CAN0IDAR7.Bits.AC5
#define CAN0IDAR7_AC6                   _CAN0IDAR7.Bits.AC6
#define CAN0IDAR7_AC7                   _CAN0IDAR7.Bits.AC7

#define CAN0IDAR7_AC0_MASK              1
#define CAN0IDAR7_AC1_MASK              2
#define CAN0IDAR7_AC2_MASK              4
#define CAN0IDAR7_AC3_MASK              8
#define CAN0IDAR7_AC4_MASK              16
#define CAN0IDAR7_AC5_MASK              32
#define CAN0IDAR7_AC6_MASK              64
#define CAN0IDAR7_AC7_MASK              128


/*** CAN0IDMR4 - MSCAN 0 Identifier Mask Register 4; 0x0000015C ***/
typedef union {
  byte Byte;
  struct {
    byte AM0         :1;                                       /* Acceptance Mask Bit 0 */
    byte AM1         :1;                                       /* Acceptance Mask Bit 1 */
    byte AM2         :1;                                       /* Acceptance Mask Bit 2 */
    byte AM3         :1;                                       /* Acceptance Mask Bit 3 */
    byte AM4         :1;                                       /* Acceptance Mask Bit 4 */
    byte AM5         :1;                                       /* Acceptance Mask Bit 5 */
    byte AM6         :1;                                       /* Acceptance Mask Bit 6 */
    byte AM7         :1;                                       /* Acceptance Mask Bit 7 */
  } Bits;
} CAN0IDMR4STR;
extern volatile CAN0IDMR4STR _CAN0IDMR4 @(REG_BASE + 0x0000015C);
#define CAN0IDMR4                       _CAN0IDMR4.Byte
#define CAN0IDMR4_AM0                   _CAN0IDMR4.Bits.AM0
#define CAN0IDMR4_AM1                   _CAN0IDMR4.Bits.AM1
#define CAN0IDMR4_AM2                   _CAN0IDMR4.Bits.AM2
#define CAN0IDMR4_AM3                   _CAN0IDMR4.Bits.AM3
#define CAN0IDMR4_AM4                   _CAN0IDMR4.Bits.AM4
#define CAN0IDMR4_AM5                   _CAN0IDMR4.Bits.AM5
#define CAN0IDMR4_AM6                   _CAN0IDMR4.Bits.AM6
#define CAN0IDMR4_AM7                   _CAN0IDMR4.Bits.AM7

#define CAN0IDMR4_AM0_MASK              1
#define CAN0IDMR4_AM1_MASK              2
#define CAN0IDMR4_AM2_MASK              4
#define CAN0IDMR4_AM3_MASK              8
#define CAN0IDMR4_AM4_MASK              16
#define CAN0IDMR4_AM5_MASK              32
#define CAN0IDMR4_AM6_MASK              64
#define CAN0IDMR4_AM7_MASK              128


/*** CAN0IDMR5 - MSCAN 0 Identifier Mask Register 5; 0x0000015D ***/
typedef union {
  byte Byte;
  struct {
    byte AM0         :1;                                       /* Acceptance Mask Bit 0 */
    byte AM1         :1;                                       /* Acceptance Mask Bit 1 */
    byte AM2         :1;                                       /* Acceptance Mask Bit 2 */
    byte AM3         :1;                                       /* Acceptance Mask Bit 3 */
    byte AM4         :1;                                       /* Acceptance Mask Bit 4 */
    byte AM5         :1;                                       /* Acceptance Mask Bit 5 */
    byte AM6         :1;                                       /* Acceptance Mask Bit 6 */
    byte AM7         :1;                                       /* Acceptance Mask Bit 7 */
  } Bits;
} CAN0IDMR5STR;
extern volatile CAN0IDMR5STR _CAN0IDMR5 @(REG_BASE + 0x0000015D);
#define CAN0IDMR5                       _CAN0IDMR5.Byte
#define CAN0IDMR5_AM0                   _CAN0IDMR5.Bits.AM0
#define CAN0IDMR5_AM1                   _CAN0IDMR5.Bits.AM1
#define CAN0IDMR5_AM2                   _CAN0IDMR5.Bits.AM2
#define CAN0IDMR5_AM3                   _CAN0IDMR5.Bits.AM3
#define CAN0IDMR5_AM4                   _CAN0IDMR5.Bits.AM4
#define CAN0IDMR5_AM5                   _CAN0IDMR5.Bits.AM5
#define CAN0IDMR5_AM6                   _CAN0IDMR5.Bits.AM6
#define CAN0IDMR5_AM7                   _CAN0IDMR5.Bits.AM7

#define CAN0IDMR5_AM0_MASK              1
#define CAN0IDMR5_AM1_MASK              2
#define CAN0IDMR5_AM2_MASK              4
#define CAN0IDMR5_AM3_MASK              8
#define CAN0IDMR5_AM4_MASK              16
#define CAN0IDMR5_AM5_MASK              32
#define CAN0IDMR5_AM6_MASK              64
#define CAN0IDMR5_AM7_MASK              128


/*** CAN0IDMR6 - MSCAN 0 Identifier Mask Register 6; 0x0000015E ***/
typedef union {
  byte Byte;
  struct {
    byte AM0         :1;                                       /* Acceptance Mask Bit 0 */
    byte AM1         :1;                                       /* Acceptance Mask Bit 1 */
    byte AM2         :1;                                       /* Acceptance Mask Bit 2 */
    byte AM3         :1;                                       /* Acceptance Mask Bit 3 */
    byte AM4         :1;                                       /* Acceptance Mask Bit 4 */
    byte AM5         :1;                                       /* Acceptance Mask Bit 5 */
    byte AM6         :1;                                       /* Acceptance Mask Bit 6 */
    byte AM7         :1;                                       /* Acceptance Mask Bit 7 */
  } Bits;
} CAN0IDMR6STR;
extern volatile CAN0IDMR6STR _CAN0IDMR6 @(REG_BASE + 0x0000015E);
#define CAN0IDMR6                       _CAN0IDMR6.Byte
#define CAN0IDMR6_AM0                   _CAN0IDMR6.Bits.AM0
#define CAN0IDMR6_AM1                   _CAN0IDMR6.Bits.AM1
#define CAN0IDMR6_AM2                   _CAN0IDMR6.Bits.AM2
#define CAN0IDMR6_AM3                   _CAN0IDMR6.Bits.AM3
#define CAN0IDMR6_AM4                   _CAN0IDMR6.Bits.AM4
#define CAN0IDMR6_AM5                   _CAN0IDMR6.Bits.AM5
#define CAN0IDMR6_AM6                   _CAN0IDMR6.Bits.AM6
#define CAN0IDMR6_AM7                   _CAN0IDMR6.Bits.AM7

#define CAN0IDMR6_AM0_MASK              1
#define CAN0IDMR6_AM1_MASK              2
#define CAN0IDMR6_AM2_MASK              4
#define CAN0IDMR6_AM3_MASK              8
#define CAN0IDMR6_AM4_MASK              16
#define CAN0IDMR6_AM5_MASK              32
#define CAN0IDMR6_AM6_MASK              64
#define CAN0IDMR6_AM7_MASK              128


/*** CAN0IDMR7 - MSCAN 0 Identifier Mask Register 7; 0x0000015F ***/
typedef union {
  byte Byte;
  struct {
    byte AM0         :1;                                       /* Acceptance Mask Bit 0 */
    byte AM1         :1;                                       /* Acceptance Mask Bit 1 */
    byte AM2         :1;                                       /* Acceptance Mask Bit 2 */
    byte AM3         :1;                                       /* Acceptance Mask Bit 3 */
    byte AM4         :1;                                       /* Acceptance Mask Bit 4 */
    byte AM5         :1;                                       /* Acceptance Mask Bit 5 */
    byte AM6         :1;                                       /* Acceptance Mask Bit 6 */
    byte AM7         :1;                                       /* Acceptance Mask Bit 7 */
  } Bits;
} CAN0IDMR7STR;
extern volatile CAN0IDMR7STR _CAN0IDMR7 @(REG_BASE + 0x0000015F);
#define CAN0IDMR7                       _CAN0IDMR7.Byte
#define CAN0IDMR7_AM0                   _CAN0IDMR7.Bits.AM0
#define CAN0IDMR7_AM1                   _CAN0IDMR7.Bits.AM1
#define CAN0IDMR7_AM2                   _CAN0IDMR7.Bits.AM2
#define CAN0IDMR7_AM3                   _CAN0IDMR7.Bits.AM3
#define CAN0IDMR7_AM4                   _CAN0IDMR7.Bits.AM4
#define CAN0IDMR7_AM5                   _CAN0IDMR7.Bits.AM5
#define CAN0IDMR7_AM6                   _CAN0IDMR7.Bits.AM6
#define CAN0IDMR7_AM7                   _CAN0IDMR7.Bits.AM7

#define CAN0IDMR7_AM0_MASK              1
#define CAN0IDMR7_AM1_MASK              2
#define CAN0IDMR7_AM2_MASK              4
#define CAN0IDMR7_AM3_MASK              8
#define CAN0IDMR7_AM4_MASK              16
#define CAN0IDMR7_AM5_MASK              32
#define CAN0IDMR7_AM6_MASK              64
#define CAN0IDMR7_AM7_MASK              128


/*** CAN0RXIDR0 - MSCAN 0 Receive Identifier Register 0; 0x00000160 ***/
typedef union {
  byte Byte;
  struct {
    byte ID21        :1;                                       /* Extended format identifier Bit 21 */
    byte ID22        :1;                                       /* Extended format identifier Bit 22 */
    byte ID23        :1;                                       /* Extended format identifier Bit 23 */
    byte ID24        :1;                                       /* Extended format identifier Bit 24 */
    byte ID25        :1;                                       /* Extended format identifier Bit 25 */
    byte ID26        :1;                                       /* Extended format identifier Bit 26 */
    byte ID27        :1;                                       /* Extended format identifier Bit 27 */
    byte ID28        :1;                                       /* Extended format identifier Bit 28 */
  } Bits;
} CAN0RXIDR0STR;
extern volatile CAN0RXIDR0STR _CAN0RXIDR0 @(REG_BASE + 0x00000160);
#define CAN0RXIDR0                      _CAN0RXIDR0.Byte
#define CAN0RXIDR0_ID21                 _CAN0RXIDR0.Bits.ID21
#define CAN0RXIDR0_ID22                 _CAN0RXIDR0.Bits.ID22
#define CAN0RXIDR0_ID23                 _CAN0RXIDR0.Bits.ID23
#define CAN0RXIDR0_ID24                 _CAN0RXIDR0.Bits.ID24
#define CAN0RXIDR0_ID25                 _CAN0RXIDR0.Bits.ID25
#define CAN0RXIDR0_ID26                 _CAN0RXIDR0.Bits.ID26
#define CAN0RXIDR0_ID27                 _CAN0RXIDR0.Bits.ID27
#define CAN0RXIDR0_ID28                 _CAN0RXIDR0.Bits.ID28
/* CAN0RXIDR_ARR: Access 4 CAN0RXIDRx registers in a array */
#define CAN0RXIDR_ARR                   ((Byte *) &CAN0RXIDR0)

#define CAN0RXIDR0_ID21_MASK            1
#define CAN0RXIDR0_ID22_MASK            2
#define CAN0RXIDR0_ID23_MASK            4
#define CAN0RXIDR0_ID24_MASK            8
#define CAN0RXIDR0_ID25_MASK            16
#define CAN0RXIDR0_ID26_MASK            32
#define CAN0RXIDR0_ID27_MASK            64
#define CAN0RXIDR0_ID28_MASK            128


/*** CAN0RXIDR1 - MSCAN 0 Receive Identifier Register 1; 0x00000161 ***/
typedef union {
  byte Byte;
  struct {
    byte ID15        :1;                                       /* Extended format identifier Bit 15 */
    byte ID16        :1;                                       /* Extended format identifier Bit 16 */
    byte ID17        :1;                                       /* Extended format identifier Bit 17 */
    byte IDE         :1;                                       /* ID Extended */
    byte SRR         :1;                                       /* Substitute Remote Request */
    byte ID18        :1;                                       /* Extended format identifier Bit 18 */
    byte ID19        :1;                                       /* Extended format identifier Bit 19 */
    byte ID20        :1;                                       /* Extended format identifier Bit 20 */
  } Bits;
  struct {
    byte grpID_15 :3;
    byte         :1;
    byte         :1;
    byte grpID_18 :3;
  } MergedBits;
} CAN0RXIDR1STR;
extern volatile CAN0RXIDR1STR _CAN0RXIDR1 @(REG_BASE + 0x00000161);
#define CAN0RXIDR1                      _CAN0RXIDR1.Byte
#define CAN0RXIDR1_ID15                 _CAN0RXIDR1.Bits.ID15
#define CAN0RXIDR1_ID16                 _CAN0RXIDR1.Bits.ID16
#define CAN0RXIDR1_ID17                 _CAN0RXIDR1.Bits.ID17
#define CAN0RXIDR1_IDE                  _CAN0RXIDR1.Bits.IDE
#define CAN0RXIDR1_SRR                  _CAN0RXIDR1.Bits.SRR
#define CAN0RXIDR1_ID18                 _CAN0RXIDR1.Bits.ID18
#define CAN0RXIDR1_ID19                 _CAN0RXIDR1.Bits.ID19
#define CAN0RXIDR1_ID20                 _CAN0RXIDR1.Bits.ID20
#define CAN0RXIDR1_ID_15                _CAN0RXIDR1.MergedBits.grpID_15
#define CAN0RXIDR1_ID_18                _CAN0RXIDR1.MergedBits.grpID_18
#define CAN0RXIDR1_ID                   CAN0RXIDR1_ID_15

#define CAN0RXIDR1_ID15_MASK            1
#define CAN0RXIDR1_ID16_MASK            2
#define CAN0RXIDR1_ID17_MASK            4
#define CAN0RXIDR1_IDE_MASK             8
#define CAN0RXIDR1_SRR_MASK             16
#define CAN0RXIDR1_ID18_MASK            32
#define CAN0RXIDR1_ID19_MASK            64
#define CAN0RXIDR1_ID20_MASK            128
#define CAN0RXIDR1_ID_15_MASK           %BitsMask
#define CAN0RXIDR1_ID_15_BITNUM         %BitsNum
#define CAN0RXIDR1_ID_18_MASK           %BitsMask
#define CAN0RXIDR1_ID_18_BITNUM         %BitsNum


/*** CAN0RXIDR2 - MSCAN 0 Receive Identifier Register 2; 0x00000162 ***/
typedef union {
  byte Byte;
  struct {
    byte ID7         :1;                                       /* Extended format identifier Bit 7 */
    byte ID8         :1;                                       /* Extended format identifier Bit 8 */
    byte ID9         :1;                                       /* Extended format identifier Bit 9 */
    byte ID10        :1;                                       /* Extended format identifier Bit 10 */
    byte ID11        :1;                                       /* Extended format identifier Bit 11 */
    byte ID12        :1;                                       /* Extended format identifier Bit 12 */
    byte ID13        :1;                                       /* Extended format identifier Bit 13 */
    byte ID14        :1;                                       /* Extended format identifier Bit 14 */
  } Bits;
} CAN0RXIDR2STR;
extern volatile CAN0RXIDR2STR _CAN0RXIDR2 @(REG_BASE + 0x00000162);
#define CAN0RXIDR2                      _CAN0RXIDR2.Byte
#define CAN0RXIDR2_ID7                  _CAN0RXIDR2.Bits.ID7
#define CAN0RXIDR2_ID8                  _CAN0RXIDR2.Bits.ID8
#define CAN0RXIDR2_ID9                  _CAN0RXIDR2.Bits.ID9
#define CAN0RXIDR2_ID10                 _CAN0RXIDR2.Bits.ID10
#define CAN0RXIDR2_ID11                 _CAN0RXIDR2.Bits.ID11
#define CAN0RXIDR2_ID12                 _CAN0RXIDR2.Bits.ID12
#define CAN0RXIDR2_ID13                 _CAN0RXIDR2.Bits.ID13
#define CAN0RXIDR2_ID14                 _CAN0RXIDR2.Bits.ID14

#define CAN0RXIDR2_ID7_MASK             1
#define CAN0RXIDR2_ID8_MASK             2
#define CAN0RXIDR2_ID9_MASK             4
#define CAN0RXIDR2_ID10_MASK            8
#define CAN0RXIDR2_ID11_MASK            16
#define CAN0RXIDR2_ID12_MASK            32
#define CAN0RXIDR2_ID13_MASK            64
#define CAN0RXIDR2_ID14_MASK            128


/*** CAN0RXIDR3 - MSCAN 0 Receive Identifier Register 3; 0x00000163 ***/
typedef union {
  byte Byte;
  struct {
    byte RTR         :1;                                       /* Remote Transmission Request */
    byte ID0         :1;                                       /* Extended format identifier Bit 0 */
    byte ID1         :1;                                       /* Extended format identifier Bit 1 */
    byte ID2         :1;                                       /* Extended format identifier Bit 2 */
    byte ID3         :1;                                       /* Extended format identifier Bit 3 */
    byte ID4         :1;                                       /* Extended format identifier Bit 4 */
    byte ID5         :1;                                       /* Extended format identifier Bit 5 */
    byte ID6         :1;                                       /* Extended format identifier Bit 6 */
  } Bits;
  struct {
    byte         :1;
    byte grpID   :7;
  } MergedBits;
} CAN0RXIDR3STR;
extern volatile CAN0RXIDR3STR _CAN0RXIDR3 @(REG_BASE + 0x00000163);
#define CAN0RXIDR3                      _CAN0RXIDR3.Byte
#define CAN0RXIDR3_RTR                  _CAN0RXIDR3.Bits.RTR
#define CAN0RXIDR3_ID0                  _CAN0RXIDR3.Bits.ID0
#define CAN0RXIDR3_ID1                  _CAN0RXIDR3.Bits.ID1
#define CAN0RXIDR3_ID2                  _CAN0RXIDR3.Bits.ID2
#define CAN0RXIDR3_ID3                  _CAN0RXIDR3.Bits.ID3
#define CAN0RXIDR3_ID4                  _CAN0RXIDR3.Bits.ID4
#define CAN0RXIDR3_ID5                  _CAN0RXIDR3.Bits.ID5
#define CAN0RXIDR3_ID6                  _CAN0RXIDR3.Bits.ID6
#define CAN0RXIDR3_ID                   _CAN0RXIDR3.MergedBits.grpID

#define CAN0RXIDR3_RTR_MASK             1
#define CAN0RXIDR3_ID0_MASK             2
#define CAN0RXIDR3_ID1_MASK             4
#define CAN0RXIDR3_ID2_MASK             8
#define CAN0RXIDR3_ID3_MASK             16
#define CAN0RXIDR3_ID4_MASK             32
#define CAN0RXIDR3_ID5_MASK             64
#define CAN0RXIDR3_ID6_MASK             128
#define CAN0RXIDR3_ID_MASK              %BitsMask
#define CAN0RXIDR3_ID_BITNUM            %BitsNum


/*** CAN0RXDSR0 - MSCAN 0 Receive Data Segment Register 0; 0x00000164 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN0RXDSR0STR;
extern volatile CAN0RXDSR0STR _CAN0RXDSR0 @(REG_BASE + 0x00000164);
#define CAN0RXDSR0                      _CAN0RXDSR0.Byte
#define CAN0RXDSR0_DB0                  _CAN0RXDSR0.Bits.DB0
#define CAN0RXDSR0_DB1                  _CAN0RXDSR0.Bits.DB1
#define CAN0RXDSR0_DB2                  _CAN0RXDSR0.Bits.DB2
#define CAN0RXDSR0_DB3                  _CAN0RXDSR0.Bits.DB3
#define CAN0RXDSR0_DB4                  _CAN0RXDSR0.Bits.DB4
#define CAN0RXDSR0_DB5                  _CAN0RXDSR0.Bits.DB5
#define CAN0RXDSR0_DB6                  _CAN0RXDSR0.Bits.DB6
#define CAN0RXDSR0_DB7                  _CAN0RXDSR0.Bits.DB7
/* CAN0RXDSR_ARR: Access 8 CAN0RXDSRx registers in a array */
#define CAN0RXDSR_ARR                   ((Byte *) &CAN0RXDSR0)

#define CAN0RXDSR0_DB0_MASK             1
#define CAN0RXDSR0_DB1_MASK             2
#define CAN0RXDSR0_DB2_MASK             4
#define CAN0RXDSR0_DB3_MASK             8
#define CAN0RXDSR0_DB4_MASK             16
#define CAN0RXDSR0_DB5_MASK             32
#define CAN0RXDSR0_DB6_MASK             64
#define CAN0RXDSR0_DB7_MASK             128


/*** CAN0RXDSR1 - MSCAN 0 Receive Data Segment Register 1; 0x00000165 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN0RXDSR1STR;
extern volatile CAN0RXDSR1STR _CAN0RXDSR1 @(REG_BASE + 0x00000165);
#define CAN0RXDSR1                      _CAN0RXDSR1.Byte
#define CAN0RXDSR1_DB0                  _CAN0RXDSR1.Bits.DB0
#define CAN0RXDSR1_DB1                  _CAN0RXDSR1.Bits.DB1
#define CAN0RXDSR1_DB2                  _CAN0RXDSR1.Bits.DB2
#define CAN0RXDSR1_DB3                  _CAN0RXDSR1.Bits.DB3
#define CAN0RXDSR1_DB4                  _CAN0RXDSR1.Bits.DB4
#define CAN0RXDSR1_DB5                  _CAN0RXDSR1.Bits.DB5
#define CAN0RXDSR1_DB6                  _CAN0RXDSR1.Bits.DB6
#define CAN0RXDSR1_DB7                  _CAN0RXDSR1.Bits.DB7

#define CAN0RXDSR1_DB0_MASK             1
#define CAN0RXDSR1_DB1_MASK             2
#define CAN0RXDSR1_DB2_MASK             4
#define CAN0RXDSR1_DB3_MASK             8
#define CAN0RXDSR1_DB4_MASK             16
#define CAN0RXDSR1_DB5_MASK             32
#define CAN0RXDSR1_DB6_MASK             64
#define CAN0RXDSR1_DB7_MASK             128


/*** CAN0RXDSR2 - MSCAN 0 Receive Data Segment Register 2; 0x00000166 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN0RXDSR2STR;
extern volatile CAN0RXDSR2STR _CAN0RXDSR2 @(REG_BASE + 0x00000166);
#define CAN0RXDSR2                      _CAN0RXDSR2.Byte
#define CAN0RXDSR2_DB0                  _CAN0RXDSR2.Bits.DB0
#define CAN0RXDSR2_DB1                  _CAN0RXDSR2.Bits.DB1
#define CAN0RXDSR2_DB2                  _CAN0RXDSR2.Bits.DB2
#define CAN0RXDSR2_DB3                  _CAN0RXDSR2.Bits.DB3
#define CAN0RXDSR2_DB4                  _CAN0RXDSR2.Bits.DB4
#define CAN0RXDSR2_DB5                  _CAN0RXDSR2.Bits.DB5
#define CAN0RXDSR2_DB6                  _CAN0RXDSR2.Bits.DB6
#define CAN0RXDSR2_DB7                  _CAN0RXDSR2.Bits.DB7

#define CAN0RXDSR2_DB0_MASK             1
#define CAN0RXDSR2_DB1_MASK             2
#define CAN0RXDSR2_DB2_MASK             4
#define CAN0RXDSR2_DB3_MASK             8
#define CAN0RXDSR2_DB4_MASK             16
#define CAN0RXDSR2_DB5_MASK             32
#define CAN0RXDSR2_DB6_MASK             64
#define CAN0RXDSR2_DB7_MASK             128


/*** CAN0RXDSR3 - MSCAN 0 Receive Data Segment Register 3; 0x00000167 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN0RXDSR3STR;
extern volatile CAN0RXDSR3STR _CAN0RXDSR3 @(REG_BASE + 0x00000167);
#define CAN0RXDSR3                      _CAN0RXDSR3.Byte
#define CAN0RXDSR3_DB0                  _CAN0RXDSR3.Bits.DB0
#define CAN0RXDSR3_DB1                  _CAN0RXDSR3.Bits.DB1
#define CAN0RXDSR3_DB2                  _CAN0RXDSR3.Bits.DB2
#define CAN0RXDSR3_DB3                  _CAN0RXDSR3.Bits.DB3
#define CAN0RXDSR3_DB4                  _CAN0RXDSR3.Bits.DB4
#define CAN0RXDSR3_DB5                  _CAN0RXDSR3.Bits.DB5
#define CAN0RXDSR3_DB6                  _CAN0RXDSR3.Bits.DB6
#define CAN0RXDSR3_DB7                  _CAN0RXDSR3.Bits.DB7

#define CAN0RXDSR3_DB0_MASK             1
#define CAN0RXDSR3_DB1_MASK             2
#define CAN0RXDSR3_DB2_MASK             4
#define CAN0RXDSR3_DB3_MASK             8
#define CAN0RXDSR3_DB4_MASK             16
#define CAN0RXDSR3_DB5_MASK             32
#define CAN0RXDSR3_DB6_MASK             64
#define CAN0RXDSR3_DB7_MASK             128


/*** CAN0RXDSR4 - MSCAN 0 Receive Data Segment Register 4; 0x00000168 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN0RXDSR4STR;
extern volatile CAN0RXDSR4STR _CAN0RXDSR4 @(REG_BASE + 0x00000168);
#define CAN0RXDSR4                      _CAN0RXDSR4.Byte
#define CAN0RXDSR4_DB0                  _CAN0RXDSR4.Bits.DB0
#define CAN0RXDSR4_DB1                  _CAN0RXDSR4.Bits.DB1
#define CAN0RXDSR4_DB2                  _CAN0RXDSR4.Bits.DB2
#define CAN0RXDSR4_DB3                  _CAN0RXDSR4.Bits.DB3
#define CAN0RXDSR4_DB4                  _CAN0RXDSR4.Bits.DB4
#define CAN0RXDSR4_DB5                  _CAN0RXDSR4.Bits.DB5
#define CAN0RXDSR4_DB6                  _CAN0RXDSR4.Bits.DB6
#define CAN0RXDSR4_DB7                  _CAN0RXDSR4.Bits.DB7

#define CAN0RXDSR4_DB0_MASK             1
#define CAN0RXDSR4_DB1_MASK             2
#define CAN0RXDSR4_DB2_MASK             4
#define CAN0RXDSR4_DB3_MASK             8
#define CAN0RXDSR4_DB4_MASK             16
#define CAN0RXDSR4_DB5_MASK             32
#define CAN0RXDSR4_DB6_MASK             64
#define CAN0RXDSR4_DB7_MASK             128


/*** CAN0RXDSR5 - MSCAN 0 Receive Data Segment Register 5; 0x00000169 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN0RXDSR5STR;
extern volatile CAN0RXDSR5STR _CAN0RXDSR5 @(REG_BASE + 0x00000169);
#define CAN0RXDSR5                      _CAN0RXDSR5.Byte
#define CAN0RXDSR5_DB0                  _CAN0RXDSR5.Bits.DB0
#define CAN0RXDSR5_DB1                  _CAN0RXDSR5.Bits.DB1
#define CAN0RXDSR5_DB2                  _CAN0RXDSR5.Bits.DB2
#define CAN0RXDSR5_DB3                  _CAN0RXDSR5.Bits.DB3
#define CAN0RXDSR5_DB4                  _CAN0RXDSR5.Bits.DB4
#define CAN0RXDSR5_DB5                  _CAN0RXDSR5.Bits.DB5
#define CAN0RXDSR5_DB6                  _CAN0RXDSR5.Bits.DB6
#define CAN0RXDSR5_DB7                  _CAN0RXDSR5.Bits.DB7

#define CAN0RXDSR5_DB0_MASK             1
#define CAN0RXDSR5_DB1_MASK             2
#define CAN0RXDSR5_DB2_MASK             4
#define CAN0RXDSR5_DB3_MASK             8
#define CAN0RXDSR5_DB4_MASK             16
#define CAN0RXDSR5_DB5_MASK             32
#define CAN0RXDSR5_DB6_MASK             64
#define CAN0RXDSR5_DB7_MASK             128


/*** CAN0RXDSR6 - MSCAN 0 Receive Data Segment Register 6; 0x0000016A ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN0RXDSR6STR;
extern volatile CAN0RXDSR6STR _CAN0RXDSR6 @(REG_BASE + 0x0000016A);
#define CAN0RXDSR6                      _CAN0RXDSR6.Byte
#define CAN0RXDSR6_DB0                  _CAN0RXDSR6.Bits.DB0
#define CAN0RXDSR6_DB1                  _CAN0RXDSR6.Bits.DB1
#define CAN0RXDSR6_DB2                  _CAN0RXDSR6.Bits.DB2
#define CAN0RXDSR6_DB3                  _CAN0RXDSR6.Bits.DB3
#define CAN0RXDSR6_DB4                  _CAN0RXDSR6.Bits.DB4
#define CAN0RXDSR6_DB5                  _CAN0RXDSR6.Bits.DB5
#define CAN0RXDSR6_DB6                  _CAN0RXDSR6.Bits.DB6
#define CAN0RXDSR6_DB7                  _CAN0RXDSR6.Bits.DB7

#define CAN0RXDSR6_DB0_MASK             1
#define CAN0RXDSR6_DB1_MASK             2
#define CAN0RXDSR6_DB2_MASK             4
#define CAN0RXDSR6_DB3_MASK             8
#define CAN0RXDSR6_DB4_MASK             16
#define CAN0RXDSR6_DB5_MASK             32
#define CAN0RXDSR6_DB6_MASK             64
#define CAN0RXDSR6_DB7_MASK             128


/*** CAN0RXDSR7 - MSCAN 0 Receive Data Segment Register 7; 0x0000016B ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN0RXDSR7STR;
extern volatile CAN0RXDSR7STR _CAN0RXDSR7 @(REG_BASE + 0x0000016B);
#define CAN0RXDSR7                      _CAN0RXDSR7.Byte
#define CAN0RXDSR7_DB0                  _CAN0RXDSR7.Bits.DB0
#define CAN0RXDSR7_DB1                  _CAN0RXDSR7.Bits.DB1
#define CAN0RXDSR7_DB2                  _CAN0RXDSR7.Bits.DB2
#define CAN0RXDSR7_DB3                  _CAN0RXDSR7.Bits.DB3
#define CAN0RXDSR7_DB4                  _CAN0RXDSR7.Bits.DB4
#define CAN0RXDSR7_DB5                  _CAN0RXDSR7.Bits.DB5
#define CAN0RXDSR7_DB6                  _CAN0RXDSR7.Bits.DB6
#define CAN0RXDSR7_DB7                  _CAN0RXDSR7.Bits.DB7

#define CAN0RXDSR7_DB0_MASK             1
#define CAN0RXDSR7_DB1_MASK             2
#define CAN0RXDSR7_DB2_MASK             4
#define CAN0RXDSR7_DB3_MASK             8
#define CAN0RXDSR7_DB4_MASK             16
#define CAN0RXDSR7_DB5_MASK             32
#define CAN0RXDSR7_DB6_MASK             64
#define CAN0RXDSR7_DB7_MASK             128


/*** CAN0RXDLR - MSCAN 0 Receive Data Length Register; 0x0000016C ***/
typedef union {
  byte Byte;
  struct {
    byte DLC0        :1;                                       /* Data Length Code Bit 0 */
    byte DLC1        :1;                                       /* Data Length Code Bit 1 */
    byte DLC2        :1;                                       /* Data Length Code Bit 2 */
    byte DLC3        :1;                                       /* Data Length Code Bit 3 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpDLC  :4;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} CAN0RXDLRSTR;
extern volatile CAN0RXDLRSTR _CAN0RXDLR @(REG_BASE + 0x0000016C);
#define CAN0RXDLR                       _CAN0RXDLR.Byte
#define CAN0RXDLR_DLC0                  _CAN0RXDLR.Bits.DLC0
#define CAN0RXDLR_DLC1                  _CAN0RXDLR.Bits.DLC1
#define CAN0RXDLR_DLC2                  _CAN0RXDLR.Bits.DLC2
#define CAN0RXDLR_DLC3                  _CAN0RXDLR.Bits.DLC3
#define CAN0RXDLR_DLC                   _CAN0RXDLR.MergedBits.grpDLC

#define CAN0RXDLR_DLC0_MASK             1
#define CAN0RXDLR_DLC1_MASK             2
#define CAN0RXDLR_DLC2_MASK             4
#define CAN0RXDLR_DLC3_MASK             8
#define CAN0RXDLR_DLC_MASK              %BitsMask
#define CAN0RXDLR_DLC_BITNUM            %BitsNum


/*** CAN0RXTSR - MSCAN 0 Receive Time Stamp Register; 0x0000016E ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** CAN0RXTSRH - MSCAN 0 Receive Time Stamp Register High; 0x0000016E ***/
    union {
      byte Byte;
      struct {
        byte TSR8        :1;                                       /* Time Stamp Bit 8 */
        byte TSR9        :1;                                       /* Time Stamp Bit 9 */
        byte TSR10       :1;                                       /* Time Stamp Bit 10 */
        byte TSR11       :1;                                       /* Time Stamp Bit 11 */
        byte TSR12       :1;                                       /* Time Stamp Bit 12 */
        byte TSR13       :1;                                       /* Time Stamp Bit 13 */
        byte TSR14       :1;                                       /* Time Stamp Bit 14 */
        byte TSR15       :1;                                       /* Time Stamp Bit 15 */
      } Bits;
    } CAN0RXTSRHSTR;
    #define CAN0RXTSRH                  _CAN0RXTSR.Overlap_STR.CAN0RXTSRHSTR.Byte
    #define CAN0RXTSRH_TSR8             _CAN0RXTSR.Overlap_STR.CAN0RXTSRHSTR.Bits.TSR8
    #define CAN0RXTSRH_TSR9             _CAN0RXTSR.Overlap_STR.CAN0RXTSRHSTR.Bits.TSR9
    #define CAN0RXTSRH_TSR10            _CAN0RXTSR.Overlap_STR.CAN0RXTSRHSTR.Bits.TSR10
    #define CAN0RXTSRH_TSR11            _CAN0RXTSR.Overlap_STR.CAN0RXTSRHSTR.Bits.TSR11
    #define CAN0RXTSRH_TSR12            _CAN0RXTSR.Overlap_STR.CAN0RXTSRHSTR.Bits.TSR12
    #define CAN0RXTSRH_TSR13            _CAN0RXTSR.Overlap_STR.CAN0RXTSRHSTR.Bits.TSR13
    #define CAN0RXTSRH_TSR14            _CAN0RXTSR.Overlap_STR.CAN0RXTSRHSTR.Bits.TSR14
    #define CAN0RXTSRH_TSR15            _CAN0RXTSR.Overlap_STR.CAN0RXTSRHSTR.Bits.TSR15
    
    
    #define CAN0RXTSRH_TSR8_MASK        1
    #define CAN0RXTSRH_TSR9_MASK        2
    #define CAN0RXTSRH_TSR10_MASK       4
    #define CAN0RXTSRH_TSR11_MASK       8
    #define CAN0RXTSRH_TSR12_MASK       16
    #define CAN0RXTSRH_TSR13_MASK       32
    #define CAN0RXTSRH_TSR14_MASK       64
    #define CAN0RXTSRH_TSR15_MASK       128


    /*** CAN0RXTSRL - MSCAN 0 Receive Time Stamp Register Low; 0x0000016F ***/
    union {
      byte Byte;
      struct {
        byte TSR0        :1;                                       /* Time Stamp Bit 0 */
        byte TSR1        :1;                                       /* Time Stamp Bit 1 */
        byte TSR2        :1;                                       /* Time Stamp Bit 2 */
        byte TSR3        :1;                                       /* Time Stamp Bit 3 */
        byte TSR4        :1;                                       /* Time Stamp Bit 4 */
        byte TSR5        :1;                                       /* Time Stamp Bit 5 */
        byte TSR6        :1;                                       /* Time Stamp Bit 6 */
        byte TSR7        :1;                                       /* Time Stamp Bit 7 */
      } Bits;
    } CAN0RXTSRLSTR;
    #define CAN0RXTSRL                  _CAN0RXTSR.Overlap_STR.CAN0RXTSRLSTR.Byte
    #define CAN0RXTSRL_TSR0             _CAN0RXTSR.Overlap_STR.CAN0RXTSRLSTR.Bits.TSR0
    #define CAN0RXTSRL_TSR1             _CAN0RXTSR.Overlap_STR.CAN0RXTSRLSTR.Bits.TSR1
    #define CAN0RXTSRL_TSR2             _CAN0RXTSR.Overlap_STR.CAN0RXTSRLSTR.Bits.TSR2
    #define CAN0RXTSRL_TSR3             _CAN0RXTSR.Overlap_STR.CAN0RXTSRLSTR.Bits.TSR3
    #define CAN0RXTSRL_TSR4             _CAN0RXTSR.Overlap_STR.CAN0RXTSRLSTR.Bits.TSR4
    #define CAN0RXTSRL_TSR5             _CAN0RXTSR.Overlap_STR.CAN0RXTSRLSTR.Bits.TSR5
    #define CAN0RXTSRL_TSR6             _CAN0RXTSR.Overlap_STR.CAN0RXTSRLSTR.Bits.TSR6
    #define CAN0RXTSRL_TSR7             _CAN0RXTSR.Overlap_STR.CAN0RXTSRLSTR.Bits.TSR7
    
    
    #define CAN0RXTSRL_TSR0_MASK        1
    #define CAN0RXTSRL_TSR1_MASK        2
    #define CAN0RXTSRL_TSR2_MASK        4
    #define CAN0RXTSRL_TSR3_MASK        8
    #define CAN0RXTSRL_TSR4_MASK        16
    #define CAN0RXTSRL_TSR5_MASK        32
    #define CAN0RXTSRL_TSR6_MASK        64
    #define CAN0RXTSRL_TSR7_MASK        128

  } Overlap_STR;

  struct {
    word TSR0        :1;                                       /* Time Stamp Bit 0 */
    word TSR1        :1;                                       /* Time Stamp Bit 1 */
    word TSR2        :1;                                       /* Time Stamp Bit 2 */
    word TSR3        :1;                                       /* Time Stamp Bit 3 */
    word TSR4        :1;                                       /* Time Stamp Bit 4 */
    word TSR5        :1;                                       /* Time Stamp Bit 5 */
    word TSR6        :1;                                       /* Time Stamp Bit 6 */
    word TSR7        :1;                                       /* Time Stamp Bit 7 */
    word TSR8        :1;                                       /* Time Stamp Bit 8 */
    word TSR9        :1;                                       /* Time Stamp Bit 9 */
    word TSR10       :1;                                       /* Time Stamp Bit 10 */
    word TSR11       :1;                                       /* Time Stamp Bit 11 */
    word TSR12       :1;                                       /* Time Stamp Bit 12 */
    word TSR13       :1;                                       /* Time Stamp Bit 13 */
    word TSR14       :1;                                       /* Time Stamp Bit 14 */
    word TSR15       :1;                                       /* Time Stamp Bit 15 */
  } Bits;
} CAN0RXTSRSTR;
extern volatile CAN0RXTSRSTR _CAN0RXTSR @(REG_BASE + 0x0000016E);
#define CAN0RXTSR                       _CAN0RXTSR.Word
#define CAN0RXTSR_TSR0                  _CAN0RXTSR.Bits.TSR0
#define CAN0RXTSR_TSR1                  _CAN0RXTSR.Bits.TSR1
#define CAN0RXTSR_TSR2                  _CAN0RXTSR.Bits.TSR2
#define CAN0RXTSR_TSR3                  _CAN0RXTSR.Bits.TSR3
#define CAN0RXTSR_TSR4                  _CAN0RXTSR.Bits.TSR4
#define CAN0RXTSR_TSR5                  _CAN0RXTSR.Bits.TSR5
#define CAN0RXTSR_TSR6                  _CAN0RXTSR.Bits.TSR6
#define CAN0RXTSR_TSR7                  _CAN0RXTSR.Bits.TSR7
#define CAN0RXTSR_TSR8                  _CAN0RXTSR.Bits.TSR8
#define CAN0RXTSR_TSR9                  _CAN0RXTSR.Bits.TSR9
#define CAN0RXTSR_TSR10                 _CAN0RXTSR.Bits.TSR10
#define CAN0RXTSR_TSR11                 _CAN0RXTSR.Bits.TSR11
#define CAN0RXTSR_TSR12                 _CAN0RXTSR.Bits.TSR12
#define CAN0RXTSR_TSR13                 _CAN0RXTSR.Bits.TSR13
#define CAN0RXTSR_TSR14                 _CAN0RXTSR.Bits.TSR14
#define CAN0RXTSR_TSR15                 _CAN0RXTSR.Bits.TSR15

#define CAN0RXTSR_TSR0_MASK             1
#define CAN0RXTSR_TSR1_MASK             2
#define CAN0RXTSR_TSR2_MASK             4
#define CAN0RXTSR_TSR3_MASK             8
#define CAN0RXTSR_TSR4_MASK             16
#define CAN0RXTSR_TSR5_MASK             32
#define CAN0RXTSR_TSR6_MASK             64
#define CAN0RXTSR_TSR7_MASK             128
#define CAN0RXTSR_TSR8_MASK             256
#define CAN0RXTSR_TSR9_MASK             512
#define CAN0RXTSR_TSR10_MASK            1024
#define CAN0RXTSR_TSR11_MASK            2048
#define CAN0RXTSR_TSR12_MASK            4096
#define CAN0RXTSR_TSR13_MASK            8192
#define CAN0RXTSR_TSR14_MASK            16384
#define CAN0RXTSR_TSR15_MASK            32768


/*** CAN0TXIDR0 - MSCAN 0 Transmit Identifier Register 0; 0x00000170 ***/
typedef union {
  byte Byte;
  struct {
    byte ID21        :1;                                       /* Extended format identifier Bit 21 */
    byte ID22        :1;                                       /* Extended format identifier Bit 22 */
    byte ID23        :1;                                       /* Extended format identifier Bit 23 */
    byte ID24        :1;                                       /* Extended format identifier Bit 24 */
    byte ID25        :1;                                       /* Extended format identifier Bit 25 */
    byte ID26        :1;                                       /* Extended format identifier Bit 26 */
    byte ID27        :1;                                       /* Extended format identifier Bit 27 */
    byte ID28        :1;                                       /* Extended format identifier Bit 28 */
  } Bits;
} CAN0TXIDR0STR;
extern volatile CAN0TXIDR0STR _CAN0TXIDR0 @(REG_BASE + 0x00000170);
#define CAN0TXIDR0                      _CAN0TXIDR0.Byte
#define CAN0TXIDR0_ID21                 _CAN0TXIDR0.Bits.ID21
#define CAN0TXIDR0_ID22                 _CAN0TXIDR0.Bits.ID22
#define CAN0TXIDR0_ID23                 _CAN0TXIDR0.Bits.ID23
#define CAN0TXIDR0_ID24                 _CAN0TXIDR0.Bits.ID24
#define CAN0TXIDR0_ID25                 _CAN0TXIDR0.Bits.ID25
#define CAN0TXIDR0_ID26                 _CAN0TXIDR0.Bits.ID26
#define CAN0TXIDR0_ID27                 _CAN0TXIDR0.Bits.ID27
#define CAN0TXIDR0_ID28                 _CAN0TXIDR0.Bits.ID28
/* CAN0TXIDR_ARR: Access 4 CAN0TXIDRx registers in a array */
#define CAN0TXIDR_ARR                   ((Byte *) &CAN0TXIDR0)

#define CAN0TXIDR0_ID21_MASK            1
#define CAN0TXIDR0_ID22_MASK            2
#define CAN0TXIDR0_ID23_MASK            4
#define CAN0TXIDR0_ID24_MASK            8
#define CAN0TXIDR0_ID25_MASK            16
#define CAN0TXIDR0_ID26_MASK            32
#define CAN0TXIDR0_ID27_MASK            64
#define CAN0TXIDR0_ID28_MASK            128


/*** CAN0TXIDR1 - MSCAN 0 Transmit Identifier Register 1; 0x00000171 ***/
typedef union {
  byte Byte;
  struct {
    byte ID15        :1;                                       /* Extended format identifier Bit 15 */
    byte ID16        :1;                                       /* Extended format identifier Bit 16 */
    byte ID17        :1;                                       /* Extended format identifier Bit 17 */
    byte IDE         :1;                                       /* ID Extended */
    byte SRR         :1;                                       /* Substitute Remote Request */
    byte ID18        :1;                                       /* Extended format identifier Bit 18 */
    byte ID19        :1;                                       /* Extended format identifier Bit 19 */
    byte ID20        :1;                                       /* Extended format identifier Bit 20 */
  } Bits;
  struct {
    byte grpID_15 :3;
    byte         :1;
    byte         :1;
    byte grpID_18 :3;
  } MergedBits;
} CAN0TXIDR1STR;
extern volatile CAN0TXIDR1STR _CAN0TXIDR1 @(REG_BASE + 0x00000171);
#define CAN0TXIDR1                      _CAN0TXIDR1.Byte
#define CAN0TXIDR1_ID15                 _CAN0TXIDR1.Bits.ID15
#define CAN0TXIDR1_ID16                 _CAN0TXIDR1.Bits.ID16
#define CAN0TXIDR1_ID17                 _CAN0TXIDR1.Bits.ID17
#define CAN0TXIDR1_IDE                  _CAN0TXIDR1.Bits.IDE
#define CAN0TXIDR1_SRR                  _CAN0TXIDR1.Bits.SRR
#define CAN0TXIDR1_ID18                 _CAN0TXIDR1.Bits.ID18
#define CAN0TXIDR1_ID19                 _CAN0TXIDR1.Bits.ID19
#define CAN0TXIDR1_ID20                 _CAN0TXIDR1.Bits.ID20
#define CAN0TXIDR1_ID_15                _CAN0TXIDR1.MergedBits.grpID_15
#define CAN0TXIDR1_ID_18                _CAN0TXIDR1.MergedBits.grpID_18
#define CAN0TXIDR1_ID                   CAN0TXIDR1_ID_15

#define CAN0TXIDR1_ID15_MASK            1
#define CAN0TXIDR1_ID16_MASK            2
#define CAN0TXIDR1_ID17_MASK            4
#define CAN0TXIDR1_IDE_MASK             8
#define CAN0TXIDR1_SRR_MASK             16
#define CAN0TXIDR1_ID18_MASK            32
#define CAN0TXIDR1_ID19_MASK            64
#define CAN0TXIDR1_ID20_MASK            128
#define CAN0TXIDR1_ID_15_MASK           %BitsMask
#define CAN0TXIDR1_ID_15_BITNUM         %BitsNum
#define CAN0TXIDR1_ID_18_MASK           %BitsMask
#define CAN0TXIDR1_ID_18_BITNUM         %BitsNum


/*** CAN0TXIDR2 - MSCAN 0 Transmit Identifier Register 2; 0x00000172 ***/
typedef union {
  byte Byte;
  struct {
    byte ID7         :1;                                       /* Extended format identifier Bit 7 */
    byte ID8         :1;                                       /* Extended format identifier Bit 8 */
    byte ID9         :1;                                       /* Extended format identifier Bit 9 */
    byte ID10        :1;                                       /* Extended format identifier Bit 10 */
    byte ID11        :1;                                       /* Extended format identifier Bit 11 */
    byte ID12        :1;                                       /* Extended format identifier Bit 12 */
    byte ID13        :1;                                       /* Extended format identifier Bit 13 */
    byte ID14        :1;                                       /* Extended format identifier Bit 14 */
  } Bits;
} CAN0TXIDR2STR;
extern volatile CAN0TXIDR2STR _CAN0TXIDR2 @(REG_BASE + 0x00000172);
#define CAN0TXIDR2                      _CAN0TXIDR2.Byte
#define CAN0TXIDR2_ID7                  _CAN0TXIDR2.Bits.ID7
#define CAN0TXIDR2_ID8                  _CAN0TXIDR2.Bits.ID8
#define CAN0TXIDR2_ID9                  _CAN0TXIDR2.Bits.ID9
#define CAN0TXIDR2_ID10                 _CAN0TXIDR2.Bits.ID10
#define CAN0TXIDR2_ID11                 _CAN0TXIDR2.Bits.ID11
#define CAN0TXIDR2_ID12                 _CAN0TXIDR2.Bits.ID12
#define CAN0TXIDR2_ID13                 _CAN0TXIDR2.Bits.ID13
#define CAN0TXIDR2_ID14                 _CAN0TXIDR2.Bits.ID14

#define CAN0TXIDR2_ID7_MASK             1
#define CAN0TXIDR2_ID8_MASK             2
#define CAN0TXIDR2_ID9_MASK             4
#define CAN0TXIDR2_ID10_MASK            8
#define CAN0TXIDR2_ID11_MASK            16
#define CAN0TXIDR2_ID12_MASK            32
#define CAN0TXIDR2_ID13_MASK            64
#define CAN0TXIDR2_ID14_MASK            128


/*** CAN0TXIDR3 - MSCAN 0 Transmit Identifier Register 3; 0x00000173 ***/
typedef union {
  byte Byte;
  struct {
    byte RTR         :1;                                       /* Remote Transmission Request */
    byte ID0         :1;                                       /* Extended format identifier Bit 0 */
    byte ID1         :1;                                       /* Extended format identifier Bit 1 */
    byte ID2         :1;                                       /* Extended format identifier Bit 2 */
    byte ID3         :1;                                       /* Extended format identifier Bit 3 */
    byte ID4         :1;                                       /* Extended format identifier Bit 4 */
    byte ID5         :1;                                       /* Extended format identifier Bit 5 */
    byte ID6         :1;                                       /* Extended format identifier Bit 6 */
  } Bits;
  struct {
    byte         :1;
    byte grpID   :7;
  } MergedBits;
} CAN0TXIDR3STR;
extern volatile CAN0TXIDR3STR _CAN0TXIDR3 @(REG_BASE + 0x00000173);
#define CAN0TXIDR3                      _CAN0TXIDR3.Byte
#define CAN0TXIDR3_RTR                  _CAN0TXIDR3.Bits.RTR
#define CAN0TXIDR3_ID0                  _CAN0TXIDR3.Bits.ID0
#define CAN0TXIDR3_ID1                  _CAN0TXIDR3.Bits.ID1
#define CAN0TXIDR3_ID2                  _CAN0TXIDR3.Bits.ID2
#define CAN0TXIDR3_ID3                  _CAN0TXIDR3.Bits.ID3
#define CAN0TXIDR3_ID4                  _CAN0TXIDR3.Bits.ID4
#define CAN0TXIDR3_ID5                  _CAN0TXIDR3.Bits.ID5
#define CAN0TXIDR3_ID6                  _CAN0TXIDR3.Bits.ID6
#define CAN0TXIDR3_ID                   _CAN0TXIDR3.MergedBits.grpID

#define CAN0TXIDR3_RTR_MASK             1
#define CAN0TXIDR3_ID0_MASK             2
#define CAN0TXIDR3_ID1_MASK             4
#define CAN0TXIDR3_ID2_MASK             8
#define CAN0TXIDR3_ID3_MASK             16
#define CAN0TXIDR3_ID4_MASK             32
#define CAN0TXIDR3_ID5_MASK             64
#define CAN0TXIDR3_ID6_MASK             128
#define CAN0TXIDR3_ID_MASK              %BitsMask
#define CAN0TXIDR3_ID_BITNUM            %BitsNum


/*** CAN0TXDSR0 - MSCAN 0 Transmit Data Segment Register 0; 0x00000174 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN0TXDSR0STR;
extern volatile CAN0TXDSR0STR _CAN0TXDSR0 @(REG_BASE + 0x00000174);
#define CAN0TXDSR0                      _CAN0TXDSR0.Byte
#define CAN0TXDSR0_DB0                  _CAN0TXDSR0.Bits.DB0
#define CAN0TXDSR0_DB1                  _CAN0TXDSR0.Bits.DB1
#define CAN0TXDSR0_DB2                  _CAN0TXDSR0.Bits.DB2
#define CAN0TXDSR0_DB3                  _CAN0TXDSR0.Bits.DB3
#define CAN0TXDSR0_DB4                  _CAN0TXDSR0.Bits.DB4
#define CAN0TXDSR0_DB5                  _CAN0TXDSR0.Bits.DB5
#define CAN0TXDSR0_DB6                  _CAN0TXDSR0.Bits.DB6
#define CAN0TXDSR0_DB7                  _CAN0TXDSR0.Bits.DB7
/* CAN0TXDSR_ARR: Access 8 CAN0TXDSRx registers in a array */
#define CAN0TXDSR_ARR                   ((Byte *) &CAN0TXDSR0)

#define CAN0TXDSR0_DB0_MASK             1
#define CAN0TXDSR0_DB1_MASK             2
#define CAN0TXDSR0_DB2_MASK             4
#define CAN0TXDSR0_DB3_MASK             8
#define CAN0TXDSR0_DB4_MASK             16
#define CAN0TXDSR0_DB5_MASK             32
#define CAN0TXDSR0_DB6_MASK             64
#define CAN0TXDSR0_DB7_MASK             128


/*** CAN0TXDSR1 - MSCAN 0 Transmit Data Segment Register 1; 0x00000175 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN0TXDSR1STR;
extern volatile CAN0TXDSR1STR _CAN0TXDSR1 @(REG_BASE + 0x00000175);
#define CAN0TXDSR1                      _CAN0TXDSR1.Byte
#define CAN0TXDSR1_DB0                  _CAN0TXDSR1.Bits.DB0
#define CAN0TXDSR1_DB1                  _CAN0TXDSR1.Bits.DB1
#define CAN0TXDSR1_DB2                  _CAN0TXDSR1.Bits.DB2
#define CAN0TXDSR1_DB3                  _CAN0TXDSR1.Bits.DB3
#define CAN0TXDSR1_DB4                  _CAN0TXDSR1.Bits.DB4
#define CAN0TXDSR1_DB5                  _CAN0TXDSR1.Bits.DB5
#define CAN0TXDSR1_DB6                  _CAN0TXDSR1.Bits.DB6
#define CAN0TXDSR1_DB7                  _CAN0TXDSR1.Bits.DB7

#define CAN0TXDSR1_DB0_MASK             1
#define CAN0TXDSR1_DB1_MASK             2
#define CAN0TXDSR1_DB2_MASK             4
#define CAN0TXDSR1_DB3_MASK             8
#define CAN0TXDSR1_DB4_MASK             16
#define CAN0TXDSR1_DB5_MASK             32
#define CAN0TXDSR1_DB6_MASK             64
#define CAN0TXDSR1_DB7_MASK             128


/*** CAN0TXDSR2 - MSCAN 0 Transmit Data Segment Register 2; 0x00000176 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN0TXDSR2STR;
extern volatile CAN0TXDSR2STR _CAN0TXDSR2 @(REG_BASE + 0x00000176);
#define CAN0TXDSR2                      _CAN0TXDSR2.Byte
#define CAN0TXDSR2_DB0                  _CAN0TXDSR2.Bits.DB0
#define CAN0TXDSR2_DB1                  _CAN0TXDSR2.Bits.DB1
#define CAN0TXDSR2_DB2                  _CAN0TXDSR2.Bits.DB2
#define CAN0TXDSR2_DB3                  _CAN0TXDSR2.Bits.DB3
#define CAN0TXDSR2_DB4                  _CAN0TXDSR2.Bits.DB4
#define CAN0TXDSR2_DB5                  _CAN0TXDSR2.Bits.DB5
#define CAN0TXDSR2_DB6                  _CAN0TXDSR2.Bits.DB6
#define CAN0TXDSR2_DB7                  _CAN0TXDSR2.Bits.DB7

#define CAN0TXDSR2_DB0_MASK             1
#define CAN0TXDSR2_DB1_MASK             2
#define CAN0TXDSR2_DB2_MASK             4
#define CAN0TXDSR2_DB3_MASK             8
#define CAN0TXDSR2_DB4_MASK             16
#define CAN0TXDSR2_DB5_MASK             32
#define CAN0TXDSR2_DB6_MASK             64
#define CAN0TXDSR2_DB7_MASK             128


/*** CAN0TXDSR3 - MSCAN 0 Transmit Data Segment Register 3; 0x00000177 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN0TXDSR3STR;
extern volatile CAN0TXDSR3STR _CAN0TXDSR3 @(REG_BASE + 0x00000177);
#define CAN0TXDSR3                      _CAN0TXDSR3.Byte
#define CAN0TXDSR3_DB0                  _CAN0TXDSR3.Bits.DB0
#define CAN0TXDSR3_DB1                  _CAN0TXDSR3.Bits.DB1
#define CAN0TXDSR3_DB2                  _CAN0TXDSR3.Bits.DB2
#define CAN0TXDSR3_DB3                  _CAN0TXDSR3.Bits.DB3
#define CAN0TXDSR3_DB4                  _CAN0TXDSR3.Bits.DB4
#define CAN0TXDSR3_DB5                  _CAN0TXDSR3.Bits.DB5
#define CAN0TXDSR3_DB6                  _CAN0TXDSR3.Bits.DB6
#define CAN0TXDSR3_DB7                  _CAN0TXDSR3.Bits.DB7

#define CAN0TXDSR3_DB0_MASK             1
#define CAN0TXDSR3_DB1_MASK             2
#define CAN0TXDSR3_DB2_MASK             4
#define CAN0TXDSR3_DB3_MASK             8
#define CAN0TXDSR3_DB4_MASK             16
#define CAN0TXDSR3_DB5_MASK             32
#define CAN0TXDSR3_DB6_MASK             64
#define CAN0TXDSR3_DB7_MASK             128


/*** CAN0TXDSR4 - MSCAN 0 Transmit Data Segment Register 4; 0x00000178 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN0TXDSR4STR;
extern volatile CAN0TXDSR4STR _CAN0TXDSR4 @(REG_BASE + 0x00000178);
#define CAN0TXDSR4                      _CAN0TXDSR4.Byte
#define CAN0TXDSR4_DB0                  _CAN0TXDSR4.Bits.DB0
#define CAN0TXDSR4_DB1                  _CAN0TXDSR4.Bits.DB1
#define CAN0TXDSR4_DB2                  _CAN0TXDSR4.Bits.DB2
#define CAN0TXDSR4_DB3                  _CAN0TXDSR4.Bits.DB3
#define CAN0TXDSR4_DB4                  _CAN0TXDSR4.Bits.DB4
#define CAN0TXDSR4_DB5                  _CAN0TXDSR4.Bits.DB5
#define CAN0TXDSR4_DB6                  _CAN0TXDSR4.Bits.DB6
#define CAN0TXDSR4_DB7                  _CAN0TXDSR4.Bits.DB7

#define CAN0TXDSR4_DB0_MASK             1
#define CAN0TXDSR4_DB1_MASK             2
#define CAN0TXDSR4_DB2_MASK             4
#define CAN0TXDSR4_DB3_MASK             8
#define CAN0TXDSR4_DB4_MASK             16
#define CAN0TXDSR4_DB5_MASK             32
#define CAN0TXDSR4_DB6_MASK             64
#define CAN0TXDSR4_DB7_MASK             128


/*** CAN0TXDSR5 - MSCAN 0 Transmit Data Segment Register 5; 0x00000179 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN0TXDSR5STR;
extern volatile CAN0TXDSR5STR _CAN0TXDSR5 @(REG_BASE + 0x00000179);
#define CAN0TXDSR5                      _CAN0TXDSR5.Byte
#define CAN0TXDSR5_DB0                  _CAN0TXDSR5.Bits.DB0
#define CAN0TXDSR5_DB1                  _CAN0TXDSR5.Bits.DB1
#define CAN0TXDSR5_DB2                  _CAN0TXDSR5.Bits.DB2
#define CAN0TXDSR5_DB3                  _CAN0TXDSR5.Bits.DB3
#define CAN0TXDSR5_DB4                  _CAN0TXDSR5.Bits.DB4
#define CAN0TXDSR5_DB5                  _CAN0TXDSR5.Bits.DB5
#define CAN0TXDSR5_DB6                  _CAN0TXDSR5.Bits.DB6
#define CAN0TXDSR5_DB7                  _CAN0TXDSR5.Bits.DB7

#define CAN0TXDSR5_DB0_MASK             1
#define CAN0TXDSR5_DB1_MASK             2
#define CAN0TXDSR5_DB2_MASK             4
#define CAN0TXDSR5_DB3_MASK             8
#define CAN0TXDSR5_DB4_MASK             16
#define CAN0TXDSR5_DB5_MASK             32
#define CAN0TXDSR5_DB6_MASK             64
#define CAN0TXDSR5_DB7_MASK             128


/*** CAN0TXDSR6 - MSCAN 0 Transmit Data Segment Register 6; 0x0000017A ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN0TXDSR6STR;
extern volatile CAN0TXDSR6STR _CAN0TXDSR6 @(REG_BASE + 0x0000017A);
#define CAN0TXDSR6                      _CAN0TXDSR6.Byte
#define CAN0TXDSR6_DB0                  _CAN0TXDSR6.Bits.DB0
#define CAN0TXDSR6_DB1                  _CAN0TXDSR6.Bits.DB1
#define CAN0TXDSR6_DB2                  _CAN0TXDSR6.Bits.DB2
#define CAN0TXDSR6_DB3                  _CAN0TXDSR6.Bits.DB3
#define CAN0TXDSR6_DB4                  _CAN0TXDSR6.Bits.DB4
#define CAN0TXDSR6_DB5                  _CAN0TXDSR6.Bits.DB5
#define CAN0TXDSR6_DB6                  _CAN0TXDSR6.Bits.DB6
#define CAN0TXDSR6_DB7                  _CAN0TXDSR6.Bits.DB7

#define CAN0TXDSR6_DB0_MASK             1
#define CAN0TXDSR6_DB1_MASK             2
#define CAN0TXDSR6_DB2_MASK             4
#define CAN0TXDSR6_DB3_MASK             8
#define CAN0TXDSR6_DB4_MASK             16
#define CAN0TXDSR6_DB5_MASK             32
#define CAN0TXDSR6_DB6_MASK             64
#define CAN0TXDSR6_DB7_MASK             128


/*** CAN0TXDSR7 - MSCAN 0 Transmit Data Segment Register 7; 0x0000017B ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN0TXDSR7STR;
extern volatile CAN0TXDSR7STR _CAN0TXDSR7 @(REG_BASE + 0x0000017B);
#define CAN0TXDSR7                      _CAN0TXDSR7.Byte
#define CAN0TXDSR7_DB0                  _CAN0TXDSR7.Bits.DB0
#define CAN0TXDSR7_DB1                  _CAN0TXDSR7.Bits.DB1
#define CAN0TXDSR7_DB2                  _CAN0TXDSR7.Bits.DB2
#define CAN0TXDSR7_DB3                  _CAN0TXDSR7.Bits.DB3
#define CAN0TXDSR7_DB4                  _CAN0TXDSR7.Bits.DB4
#define CAN0TXDSR7_DB5                  _CAN0TXDSR7.Bits.DB5
#define CAN0TXDSR7_DB6                  _CAN0TXDSR7.Bits.DB6
#define CAN0TXDSR7_DB7                  _CAN0TXDSR7.Bits.DB7

#define CAN0TXDSR7_DB0_MASK             1
#define CAN0TXDSR7_DB1_MASK             2
#define CAN0TXDSR7_DB2_MASK             4
#define CAN0TXDSR7_DB3_MASK             8
#define CAN0TXDSR7_DB4_MASK             16
#define CAN0TXDSR7_DB5_MASK             32
#define CAN0TXDSR7_DB6_MASK             64
#define CAN0TXDSR7_DB7_MASK             128


/*** CAN0TXDLR - MSCAN 0 Transmit Data Length Register; 0x0000017C ***/
typedef union {
  byte Byte;
  struct {
    byte DLC0        :1;                                       /* Data Length Code Bit 0 */
    byte DLC1        :1;                                       /* Data Length Code Bit 1 */
    byte DLC2        :1;                                       /* Data Length Code Bit 2 */
    byte DLC3        :1;                                       /* Data Length Code Bit 3 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpDLC  :4;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} CAN0TXDLRSTR;
extern volatile CAN0TXDLRSTR _CAN0TXDLR @(REG_BASE + 0x0000017C);
#define CAN0TXDLR                       _CAN0TXDLR.Byte
#define CAN0TXDLR_DLC0                  _CAN0TXDLR.Bits.DLC0
#define CAN0TXDLR_DLC1                  _CAN0TXDLR.Bits.DLC1
#define CAN0TXDLR_DLC2                  _CAN0TXDLR.Bits.DLC2
#define CAN0TXDLR_DLC3                  _CAN0TXDLR.Bits.DLC3
#define CAN0TXDLR_DLC                   _CAN0TXDLR.MergedBits.grpDLC

#define CAN0TXDLR_DLC0_MASK             1
#define CAN0TXDLR_DLC1_MASK             2
#define CAN0TXDLR_DLC2_MASK             4
#define CAN0TXDLR_DLC3_MASK             8
#define CAN0TXDLR_DLC_MASK              %BitsMask
#define CAN0TXDLR_DLC_BITNUM            %BitsNum


/*** CAN0TXTBPR - MSCAN 0 Transmit Buffer Priority; 0x0000017D ***/
typedef union {
  byte Byte;
  struct {
    byte PRIO0       :1;                                       /* Transmit Buffer Priority Bit 0 */
    byte PRIO1       :1;                                       /* Transmit Buffer Priority Bit 1 */
    byte PRIO2       :1;                                       /* Transmit Buffer Priority Bit 2 */
    byte PRIO3       :1;                                       /* Transmit Buffer Priority Bit 3 */
    byte PRIO4       :1;                                       /* Transmit Buffer Priority Bit 4 */
    byte PRIO5       :1;                                       /* Transmit Buffer Priority Bit 5 */
    byte PRIO6       :1;                                       /* Transmit Buffer Priority Bit 6 */
    byte PRIO7       :1;                                       /* Transmit Buffer Priority Bit 7 */
  } Bits;
} CAN0TXTBPRSTR;
extern volatile CAN0TXTBPRSTR _CAN0TXTBPR @(REG_BASE + 0x0000017D);
#define CAN0TXTBPR                      _CAN0TXTBPR.Byte
#define CAN0TXTBPR_PRIO0                _CAN0TXTBPR.Bits.PRIO0
#define CAN0TXTBPR_PRIO1                _CAN0TXTBPR.Bits.PRIO1
#define CAN0TXTBPR_PRIO2                _CAN0TXTBPR.Bits.PRIO2
#define CAN0TXTBPR_PRIO3                _CAN0TXTBPR.Bits.PRIO3
#define CAN0TXTBPR_PRIO4                _CAN0TXTBPR.Bits.PRIO4
#define CAN0TXTBPR_PRIO5                _CAN0TXTBPR.Bits.PRIO5
#define CAN0TXTBPR_PRIO6                _CAN0TXTBPR.Bits.PRIO6
#define CAN0TXTBPR_PRIO7                _CAN0TXTBPR.Bits.PRIO7

#define CAN0TXTBPR_PRIO0_MASK           1
#define CAN0TXTBPR_PRIO1_MASK           2
#define CAN0TXTBPR_PRIO2_MASK           4
#define CAN0TXTBPR_PRIO3_MASK           8
#define CAN0TXTBPR_PRIO4_MASK           16
#define CAN0TXTBPR_PRIO5_MASK           32
#define CAN0TXTBPR_PRIO6_MASK           64
#define CAN0TXTBPR_PRIO7_MASK           128


/*** CAN0TXTSR - MSCAN 0 Transmit Time Stamp Register; 0x0000017E ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** CAN0TXTSRH - MSCAN 0 Transmit Time Stamp Register High; 0x0000017E ***/
    union {
      byte Byte;
      struct {
        byte TSR8        :1;                                       /* Time Stamp Bit 8 */
        byte TSR9        :1;                                       /* Time Stamp Bit 9 */
        byte TSR10       :1;                                       /* Time Stamp Bit 10 */
        byte TSR11       :1;                                       /* Time Stamp Bit 11 */
        byte TSR12       :1;                                       /* Time Stamp Bit 12 */
        byte TSR13       :1;                                       /* Time Stamp Bit 13 */
        byte TSR14       :1;                                       /* Time Stamp Bit 14 */
        byte TSR15       :1;                                       /* Time Stamp Bit 15 */
      } Bits;
    } CAN0TXTSRHSTR;
    #define CAN0TXTSRH                  _CAN0TXTSR.Overlap_STR.CAN0TXTSRHSTR.Byte
    #define CAN0TXTSRH_TSR8             _CAN0TXTSR.Overlap_STR.CAN0TXTSRHSTR.Bits.TSR8
    #define CAN0TXTSRH_TSR9             _CAN0TXTSR.Overlap_STR.CAN0TXTSRHSTR.Bits.TSR9
    #define CAN0TXTSRH_TSR10            _CAN0TXTSR.Overlap_STR.CAN0TXTSRHSTR.Bits.TSR10
    #define CAN0TXTSRH_TSR11            _CAN0TXTSR.Overlap_STR.CAN0TXTSRHSTR.Bits.TSR11
    #define CAN0TXTSRH_TSR12            _CAN0TXTSR.Overlap_STR.CAN0TXTSRHSTR.Bits.TSR12
    #define CAN0TXTSRH_TSR13            _CAN0TXTSR.Overlap_STR.CAN0TXTSRHSTR.Bits.TSR13
    #define CAN0TXTSRH_TSR14            _CAN0TXTSR.Overlap_STR.CAN0TXTSRHSTR.Bits.TSR14
    #define CAN0TXTSRH_TSR15            _CAN0TXTSR.Overlap_STR.CAN0TXTSRHSTR.Bits.TSR15
    
    
    #define CAN0TXTSRH_TSR8_MASK        1
    #define CAN0TXTSRH_TSR9_MASK        2
    #define CAN0TXTSRH_TSR10_MASK       4
    #define CAN0TXTSRH_TSR11_MASK       8
    #define CAN0TXTSRH_TSR12_MASK       16
    #define CAN0TXTSRH_TSR13_MASK       32
    #define CAN0TXTSRH_TSR14_MASK       64
    #define CAN0TXTSRH_TSR15_MASK       128


    /*** CAN0TXTSRL - MSCAN 0 Transmit Time Stamp Register Low; 0x0000017F ***/
    union {
      byte Byte;
      struct {
        byte TSR0        :1;                                       /* Time Stamp Bit 0 */
        byte TSR1        :1;                                       /* Time Stamp Bit 1 */
        byte TSR2        :1;                                       /* Time Stamp Bit 2 */
        byte TSR3        :1;                                       /* Time Stamp Bit 3 */
        byte TSR4        :1;                                       /* Time Stamp Bit 4 */
        byte TSR5        :1;                                       /* Time Stamp Bit 5 */
        byte TSR6        :1;                                       /* Time Stamp Bit 6 */
        byte TSR7        :1;                                       /* Time Stamp Bit 7 */
      } Bits;
    } CAN0TXTSRLSTR;
    #define CAN0TXTSRL                  _CAN0TXTSR.Overlap_STR.CAN0TXTSRLSTR.Byte
    #define CAN0TXTSRL_TSR0             _CAN0TXTSR.Overlap_STR.CAN0TXTSRLSTR.Bits.TSR0
    #define CAN0TXTSRL_TSR1             _CAN0TXTSR.Overlap_STR.CAN0TXTSRLSTR.Bits.TSR1
    #define CAN0TXTSRL_TSR2             _CAN0TXTSR.Overlap_STR.CAN0TXTSRLSTR.Bits.TSR2
    #define CAN0TXTSRL_TSR3             _CAN0TXTSR.Overlap_STR.CAN0TXTSRLSTR.Bits.TSR3
    #define CAN0TXTSRL_TSR4             _CAN0TXTSR.Overlap_STR.CAN0TXTSRLSTR.Bits.TSR4
    #define CAN0TXTSRL_TSR5             _CAN0TXTSR.Overlap_STR.CAN0TXTSRLSTR.Bits.TSR5
    #define CAN0TXTSRL_TSR6             _CAN0TXTSR.Overlap_STR.CAN0TXTSRLSTR.Bits.TSR6
    #define CAN0TXTSRL_TSR7             _CAN0TXTSR.Overlap_STR.CAN0TXTSRLSTR.Bits.TSR7
    
    
    #define CAN0TXTSRL_TSR0_MASK        1
    #define CAN0TXTSRL_TSR1_MASK        2
    #define CAN0TXTSRL_TSR2_MASK        4
    #define CAN0TXTSRL_TSR3_MASK        8
    #define CAN0TXTSRL_TSR4_MASK        16
    #define CAN0TXTSRL_TSR5_MASK        32
    #define CAN0TXTSRL_TSR6_MASK        64
    #define CAN0TXTSRL_TSR7_MASK        128

  } Overlap_STR;

  struct {
    word TSR0        :1;                                       /* Time Stamp Bit 0 */
    word TSR1        :1;                                       /* Time Stamp Bit 1 */
    word TSR2        :1;                                       /* Time Stamp Bit 2 */
    word TSR3        :1;                                       /* Time Stamp Bit 3 */
    word TSR4        :1;                                       /* Time Stamp Bit 4 */
    word TSR5        :1;                                       /* Time Stamp Bit 5 */
    word TSR6        :1;                                       /* Time Stamp Bit 6 */
    word TSR7        :1;                                       /* Time Stamp Bit 7 */
    word TSR8        :1;                                       /* Time Stamp Bit 8 */
    word TSR9        :1;                                       /* Time Stamp Bit 9 */
    word TSR10       :1;                                       /* Time Stamp Bit 10 */
    word TSR11       :1;                                       /* Time Stamp Bit 11 */
    word TSR12       :1;                                       /* Time Stamp Bit 12 */
    word TSR13       :1;                                       /* Time Stamp Bit 13 */
    word TSR14       :1;                                       /* Time Stamp Bit 14 */
    word TSR15       :1;                                       /* Time Stamp Bit 15 */
  } Bits;
} CAN0TXTSRSTR;
extern volatile CAN0TXTSRSTR _CAN0TXTSR @(REG_BASE + 0x0000017E);
#define CAN0TXTSR                       _CAN0TXTSR.Word
#define CAN0TXTSR_TSR0                  _CAN0TXTSR.Bits.TSR0
#define CAN0TXTSR_TSR1                  _CAN0TXTSR.Bits.TSR1
#define CAN0TXTSR_TSR2                  _CAN0TXTSR.Bits.TSR2
#define CAN0TXTSR_TSR3                  _CAN0TXTSR.Bits.TSR3
#define CAN0TXTSR_TSR4                  _CAN0TXTSR.Bits.TSR4
#define CAN0TXTSR_TSR5                  _CAN0TXTSR.Bits.TSR5
#define CAN0TXTSR_TSR6                  _CAN0TXTSR.Bits.TSR6
#define CAN0TXTSR_TSR7                  _CAN0TXTSR.Bits.TSR7
#define CAN0TXTSR_TSR8                  _CAN0TXTSR.Bits.TSR8
#define CAN0TXTSR_TSR9                  _CAN0TXTSR.Bits.TSR9
#define CAN0TXTSR_TSR10                 _CAN0TXTSR.Bits.TSR10
#define CAN0TXTSR_TSR11                 _CAN0TXTSR.Bits.TSR11
#define CAN0TXTSR_TSR12                 _CAN0TXTSR.Bits.TSR12
#define CAN0TXTSR_TSR13                 _CAN0TXTSR.Bits.TSR13
#define CAN0TXTSR_TSR14                 _CAN0TXTSR.Bits.TSR14
#define CAN0TXTSR_TSR15                 _CAN0TXTSR.Bits.TSR15

#define CAN0TXTSR_TSR0_MASK             1
#define CAN0TXTSR_TSR1_MASK             2
#define CAN0TXTSR_TSR2_MASK             4
#define CAN0TXTSR_TSR3_MASK             8
#define CAN0TXTSR_TSR4_MASK             16
#define CAN0TXTSR_TSR5_MASK             32
#define CAN0TXTSR_TSR6_MASK             64
#define CAN0TXTSR_TSR7_MASK             128
#define CAN0TXTSR_TSR8_MASK             256
#define CAN0TXTSR_TSR9_MASK             512
#define CAN0TXTSR_TSR10_MASK            1024
#define CAN0TXTSR_TSR11_MASK            2048
#define CAN0TXTSR_TSR12_MASK            4096
#define CAN0TXTSR_TSR13_MASK            8192
#define CAN0TXTSR_TSR14_MASK            16384
#define CAN0TXTSR_TSR15_MASK            32768


/*** CAN1CTL0 - MSCAN 1 Control 0 Register; 0x00000180 ***/
typedef union {
  byte Byte;
  struct {
    byte INITRQ      :1;                                       /* Initialization Mode Request */
    byte SLPRQ       :1;                                       /* Sleep Mode Request */
    byte WUPE        :1;                                       /* Wake-Up Enable */
    byte TIME        :1;                                       /* Timer Enable */
    byte SYNCH       :1;                                       /* Synchronized Status */
    byte CSWAI       :1;                                       /* CAN Stops in Wait Mode */
    byte RXACT       :1;                                       /* Receiver Active Status */
    byte RXFRM       :1;                                       /* Received Frame Flag */
  } Bits;
} CAN1CTL0STR;
extern volatile CAN1CTL0STR _CAN1CTL0 @(REG_BASE + 0x00000180);
#define CAN1CTL0                        _CAN1CTL0.Byte
#define CAN1CTL0_INITRQ                 _CAN1CTL0.Bits.INITRQ
#define CAN1CTL0_SLPRQ                  _CAN1CTL0.Bits.SLPRQ
#define CAN1CTL0_WUPE                   _CAN1CTL0.Bits.WUPE
#define CAN1CTL0_TIME                   _CAN1CTL0.Bits.TIME
#define CAN1CTL0_SYNCH                  _CAN1CTL0.Bits.SYNCH
#define CAN1CTL0_CSWAI                  _CAN1CTL0.Bits.CSWAI
#define CAN1CTL0_RXACT                  _CAN1CTL0.Bits.RXACT
#define CAN1CTL0_RXFRM                  _CAN1CTL0.Bits.RXFRM
/* CAN1CTL_ARR: Access 2 CAN1CTLx registers in a array */
#define CAN1CTL_ARR                     ((Byte *) &CAN1CTL0)

#define CAN1CTL0_INITRQ_MASK            1
#define CAN1CTL0_SLPRQ_MASK             2
#define CAN1CTL0_WUPE_MASK              4
#define CAN1CTL0_TIME_MASK              8
#define CAN1CTL0_SYNCH_MASK             16
#define CAN1CTL0_CSWAI_MASK             32
#define CAN1CTL0_RXACT_MASK             64
#define CAN1CTL0_RXFRM_MASK             128


/*** CAN1CTL1 - MSCAN 1 Control 1 Register; 0x00000181 ***/
typedef union {
  byte Byte;
  struct {
    byte INITAK      :1;                                       /* Initialization Mode Acknowledge */
    byte SLPAK       :1;                                       /* Sleep Mode Acknowledge */
    byte WUPM        :1;                                       /* Wake-Up Mode */
    byte             :1; 
    byte LISTEN      :1;                                       /* Listen Only Mode */
    byte LOOPB       :1;                                       /* Loop Back Self Test Mode */
    byte CLKSRC      :1;                                       /* MSCAN 1 Clock Source */
    byte CANE        :1;                                       /* MSCAN 1 Enable */
  } Bits;
} CAN1CTL1STR;
extern volatile CAN1CTL1STR _CAN1CTL1 @(REG_BASE + 0x00000181);
#define CAN1CTL1                        _CAN1CTL1.Byte
#define CAN1CTL1_INITAK                 _CAN1CTL1.Bits.INITAK
#define CAN1CTL1_SLPAK                  _CAN1CTL1.Bits.SLPAK
#define CAN1CTL1_WUPM                   _CAN1CTL1.Bits.WUPM
#define CAN1CTL1_LISTEN                 _CAN1CTL1.Bits.LISTEN
#define CAN1CTL1_LOOPB                  _CAN1CTL1.Bits.LOOPB
#define CAN1CTL1_CLKSRC                 _CAN1CTL1.Bits.CLKSRC
#define CAN1CTL1_CANE                   _CAN1CTL1.Bits.CANE

#define CAN1CTL1_INITAK_MASK            1
#define CAN1CTL1_SLPAK_MASK             2
#define CAN1CTL1_WUPM_MASK              4
#define CAN1CTL1_LISTEN_MASK            16
#define CAN1CTL1_LOOPB_MASK             32
#define CAN1CTL1_CLKSRC_MASK            64
#define CAN1CTL1_CANE_MASK              128


/*** CAN1BTR0 - MSCAN 1 Bus Timing Register 0; 0x00000182 ***/
typedef union {
  byte Byte;
  struct {
    byte BRP0        :1;                                       /* Baud Rate Prescaler 0 */
    byte BRP1        :1;                                       /* Baud Rate Prescaler 1 */
    byte BRP2        :1;                                       /* Baud Rate Prescaler 2 */
    byte BRP3        :1;                                       /* Baud Rate Prescaler 3 */
    byte BRP4        :1;                                       /* Baud Rate Prescaler 4 */
    byte BRP5        :1;                                       /* Baud Rate Prescaler 5 */
    byte SJW0        :1;                                       /* Synchronization Jump Width 0 */
    byte SJW1        :1;                                       /* Synchronization Jump Width 1 */
  } Bits;
  struct {
    byte grpBRP  :6;
    byte grpSJW  :2;
  } MergedBits;
} CAN1BTR0STR;
extern volatile CAN1BTR0STR _CAN1BTR0 @(REG_BASE + 0x00000182);
#define CAN1BTR0                        _CAN1BTR0.Byte
#define CAN1BTR0_BRP0                   _CAN1BTR0.Bits.BRP0
#define CAN1BTR0_BRP1                   _CAN1BTR0.Bits.BRP1
#define CAN1BTR0_BRP2                   _CAN1BTR0.Bits.BRP2
#define CAN1BTR0_BRP3                   _CAN1BTR0.Bits.BRP3
#define CAN1BTR0_BRP4                   _CAN1BTR0.Bits.BRP4
#define CAN1BTR0_BRP5                   _CAN1BTR0.Bits.BRP5
#define CAN1BTR0_SJW0                   _CAN1BTR0.Bits.SJW0
#define CAN1BTR0_SJW1                   _CAN1BTR0.Bits.SJW1
/* CAN1BTR_ARR: Access 2 CAN1BTRx registers in a array */
#define CAN1BTR_ARR                     ((Byte *) &CAN1BTR0)
#define CAN1BTR0_BRP                    _CAN1BTR0.MergedBits.grpBRP
#define CAN1BTR0_SJW                    _CAN1BTR0.MergedBits.grpSJW

#define CAN1BTR0_BRP0_MASK              1
#define CAN1BTR0_BRP1_MASK              2
#define CAN1BTR0_BRP2_MASK              4
#define CAN1BTR0_BRP3_MASK              8
#define CAN1BTR0_BRP4_MASK              16
#define CAN1BTR0_BRP5_MASK              32
#define CAN1BTR0_SJW0_MASK              64
#define CAN1BTR0_SJW1_MASK              128
#define CAN1BTR0_BRP_MASK               %BitsMask
#define CAN1BTR0_BRP_BITNUM             %BitsNum
#define CAN1BTR0_SJW_MASK               %BitsMask
#define CAN1BTR0_SJW_BITNUM             %BitsNum


/*** CAN1BTR1 - MSCAN 1 Bus Timing Register 1; 0x00000183 ***/
typedef union {
  byte Byte;
  struct {
    byte TSEG10      :1;                                       /* Time Segment 10 */
    byte TSEG11      :1;                                       /* Time Segment 11 */
    byte TSEG12      :1;                                       /* Time Segment 12 */
    byte TSEG13      :1;                                       /* Time Segment 13 */
    byte TSEG20      :1;                                       /* Time Segment 20 */
    byte TSEG21      :1;                                       /* Time Segment 21 */
    byte TSEG22      :1;                                       /* Time Segment 22 */
    byte SAMP        :1;                                       /* Sampling */
  } Bits;
  struct {
    byte grpTSEG_10 :4;
    byte grpTSEG_20 :3;
    byte         :1;
  } MergedBits;
} CAN1BTR1STR;
extern volatile CAN1BTR1STR _CAN1BTR1 @(REG_BASE + 0x00000183);
#define CAN1BTR1                        _CAN1BTR1.Byte
#define CAN1BTR1_TSEG10                 _CAN1BTR1.Bits.TSEG10
#define CAN1BTR1_TSEG11                 _CAN1BTR1.Bits.TSEG11
#define CAN1BTR1_TSEG12                 _CAN1BTR1.Bits.TSEG12
#define CAN1BTR1_TSEG13                 _CAN1BTR1.Bits.TSEG13
#define CAN1BTR1_TSEG20                 _CAN1BTR1.Bits.TSEG20
#define CAN1BTR1_TSEG21                 _CAN1BTR1.Bits.TSEG21
#define CAN1BTR1_TSEG22                 _CAN1BTR1.Bits.TSEG22
#define CAN1BTR1_SAMP                   _CAN1BTR1.Bits.SAMP
#define CAN1BTR1_TSEG_10                _CAN1BTR1.MergedBits.grpTSEG_10
#define CAN1BTR1_TSEG_20                _CAN1BTR1.MergedBits.grpTSEG_20
#define CAN1BTR1_TSEG                   CAN1BTR1_TSEG_10

#define CAN1BTR1_TSEG10_MASK            1
#define CAN1BTR1_TSEG11_MASK            2
#define CAN1BTR1_TSEG12_MASK            4
#define CAN1BTR1_TSEG13_MASK            8
#define CAN1BTR1_TSEG20_MASK            16
#define CAN1BTR1_TSEG21_MASK            32
#define CAN1BTR1_TSEG22_MASK            64
#define CAN1BTR1_SAMP_MASK              128
#define CAN1BTR1_TSEG_10_MASK           %BitsMask
#define CAN1BTR1_TSEG_10_BITNUM         %BitsNum
#define CAN1BTR1_TSEG_20_MASK           %BitsMask
#define CAN1BTR1_TSEG_20_BITNUM         %BitsNum


/*** CAN1RFLG - MSCAN 1 Receiver Flag Register; 0x00000184 ***/
typedef union {
  byte Byte;
  struct {
    byte RXF         :1;                                       /* Receive Buffer Full */
    byte OVRIF       :1;                                       /* Overrun Interrupt Flag */
    byte TSTAT0      :1;                                       /* Transmitter Status Bit 0 */
    byte TSTAT1      :1;                                       /* Transmitter Status Bit 1 */
    byte RSTAT0      :1;                                       /* Receiver Status Bit 0 */
    byte RSTAT1      :1;                                       /* Receiver Status Bit 1 */
    byte CSCIF       :1;                                       /* CAN Status Change Interrupt Flag */
    byte WUPIF       :1;                                       /* Wake-up Interrupt Flag */
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte grpTSTAT :2;
    byte grpRSTAT :2;
    byte         :1;
    byte         :1;
  } MergedBits;
} CAN1RFLGSTR;
extern volatile CAN1RFLGSTR _CAN1RFLG @(REG_BASE + 0x00000184);
#define CAN1RFLG                        _CAN1RFLG.Byte
#define CAN1RFLG_RXF                    _CAN1RFLG.Bits.RXF
#define CAN1RFLG_OVRIF                  _CAN1RFLG.Bits.OVRIF
#define CAN1RFLG_TSTAT0                 _CAN1RFLG.Bits.TSTAT0
#define CAN1RFLG_TSTAT1                 _CAN1RFLG.Bits.TSTAT1
#define CAN1RFLG_RSTAT0                 _CAN1RFLG.Bits.RSTAT0
#define CAN1RFLG_RSTAT1                 _CAN1RFLG.Bits.RSTAT1
#define CAN1RFLG_CSCIF                  _CAN1RFLG.Bits.CSCIF
#define CAN1RFLG_WUPIF                  _CAN1RFLG.Bits.WUPIF
#define CAN1RFLG_TSTAT                  _CAN1RFLG.MergedBits.grpTSTAT
#define CAN1RFLG_RSTAT                  _CAN1RFLG.MergedBits.grpRSTAT

#define CAN1RFLG_RXF_MASK               1
#define CAN1RFLG_OVRIF_MASK             2
#define CAN1RFLG_TSTAT0_MASK            4
#define CAN1RFLG_TSTAT1_MASK            8
#define CAN1RFLG_RSTAT0_MASK            16
#define CAN1RFLG_RSTAT1_MASK            32
#define CAN1RFLG_CSCIF_MASK             64
#define CAN1RFLG_WUPIF_MASK             128
#define CAN1RFLG_TSTAT_MASK             %BitsMask
#define CAN1RFLG_TSTAT_BITNUM           %BitsNum
#define CAN1RFLG_RSTAT_MASK             %BitsMask
#define CAN1RFLG_RSTAT_BITNUM           %BitsNum


/*** CAN1RIER - MSCAN 1 Receiver Interrupt Enable Register; 0x00000185 ***/
typedef union {
  byte Byte;
  struct {
    byte RXFIE       :1;                                       /* Receiver Full Interrupt Enable */
    byte OVRIE       :1;                                       /* Overrun Interrupt Enable */
    byte TSTATE0     :1;                                       /* Transmitter Status Change Enable 0 */
    byte TSTATE1     :1;                                       /* Transmitter Status Change Enable 1 */
    byte RSTATE0     :1;                                       /* Receiver Status Change Enable 0 */
    byte RSTATE1     :1;                                       /* Receiver Status Change Enable 1 */
    byte CSCIE       :1;                                       /* CAN Status Change Interrupt Enable */
    byte WUPIE       :1;                                       /* Wake-up Interrupt Enable */
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte grpTSTATE :2;
    byte grpRSTATE :2;
    byte         :1;
    byte         :1;
  } MergedBits;
} CAN1RIERSTR;
extern volatile CAN1RIERSTR _CAN1RIER @(REG_BASE + 0x00000185);
#define CAN1RIER                        _CAN1RIER.Byte
#define CAN1RIER_RXFIE                  _CAN1RIER.Bits.RXFIE
#define CAN1RIER_OVRIE                  _CAN1RIER.Bits.OVRIE
#define CAN1RIER_TSTATE0                _CAN1RIER.Bits.TSTATE0
#define CAN1RIER_TSTATE1                _CAN1RIER.Bits.TSTATE1
#define CAN1RIER_RSTATE0                _CAN1RIER.Bits.RSTATE0
#define CAN1RIER_RSTATE1                _CAN1RIER.Bits.RSTATE1
#define CAN1RIER_CSCIE                  _CAN1RIER.Bits.CSCIE
#define CAN1RIER_WUPIE                  _CAN1RIER.Bits.WUPIE
#define CAN1RIER_TSTATE                 _CAN1RIER.MergedBits.grpTSTATE
#define CAN1RIER_RSTATE                 _CAN1RIER.MergedBits.grpRSTATE

#define CAN1RIER_RXFIE_MASK             1
#define CAN1RIER_OVRIE_MASK             2
#define CAN1RIER_TSTATE0_MASK           4
#define CAN1RIER_TSTATE1_MASK           8
#define CAN1RIER_RSTATE0_MASK           16
#define CAN1RIER_RSTATE1_MASK           32
#define CAN1RIER_CSCIE_MASK             64
#define CAN1RIER_WUPIE_MASK             128
#define CAN1RIER_TSTATE_MASK            %BitsMask
#define CAN1RIER_TSTATE_BITNUM          %BitsNum
#define CAN1RIER_RSTATE_MASK            %BitsMask
#define CAN1RIER_RSTATE_BITNUM          %BitsNum


/*** CAN1TFLG - MSCAN 1 Transmitter Flag Register; 0x00000186 ***/
typedef union {
  byte Byte;
  struct {
    byte TXE0        :1;                                       /* Transmitter Buffer Empty 0 */
    byte TXE1        :1;                                       /* Transmitter Buffer Empty 1 */
    byte TXE2        :1;                                       /* Transmitter Buffer Empty 2 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpTXE  :3;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} CAN1TFLGSTR;
extern volatile CAN1TFLGSTR _CAN1TFLG @(REG_BASE + 0x00000186);
#define CAN1TFLG                        _CAN1TFLG.Byte
#define CAN1TFLG_TXE0                   _CAN1TFLG.Bits.TXE0
#define CAN1TFLG_TXE1                   _CAN1TFLG.Bits.TXE1
#define CAN1TFLG_TXE2                   _CAN1TFLG.Bits.TXE2
#define CAN1TFLG_TXE                    _CAN1TFLG.MergedBits.grpTXE

#define CAN1TFLG_TXE0_MASK              1
#define CAN1TFLG_TXE1_MASK              2
#define CAN1TFLG_TXE2_MASK              4
#define CAN1TFLG_TXE_MASK               %BitsMask
#define CAN1TFLG_TXE_BITNUM             %BitsNum


/*** CAN1TIER - MSCAN 1 Transmitter Interrupt Enable Register; 0x00000187 ***/
typedef union {
  byte Byte;
  struct {
    byte TXEIE0      :1;                                       /* Transmitter Empty Interrupt Enable 0 */
    byte TXEIE1      :1;                                       /* Transmitter Empty Interrupt Enable 1 */
    byte TXEIE2      :1;                                       /* Transmitter Empty Interrupt Enable 2 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpTXEIE :3;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} CAN1TIERSTR;
extern volatile CAN1TIERSTR _CAN1TIER @(REG_BASE + 0x00000187);
#define CAN1TIER                        _CAN1TIER.Byte
#define CAN1TIER_TXEIE0                 _CAN1TIER.Bits.TXEIE0
#define CAN1TIER_TXEIE1                 _CAN1TIER.Bits.TXEIE1
#define CAN1TIER_TXEIE2                 _CAN1TIER.Bits.TXEIE2
#define CAN1TIER_TXEIE                  _CAN1TIER.MergedBits.grpTXEIE

#define CAN1TIER_TXEIE0_MASK            1
#define CAN1TIER_TXEIE1_MASK            2
#define CAN1TIER_TXEIE2_MASK            4
#define CAN1TIER_TXEIE_MASK             %BitsMask
#define CAN1TIER_TXEIE_BITNUM           %BitsNum


/*** CAN1TARQ - MSCAN 1 Transmitter Message Abort Request; 0x00000188 ***/
typedef union {
  byte Byte;
  struct {
    byte ABTRQ0      :1;                                       /* Abort Request 0 */
    byte ABTRQ1      :1;                                       /* Abort Request 1 */
    byte ABTRQ2      :1;                                       /* Abort Request 2 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpABTRQ :3;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} CAN1TARQSTR;
extern volatile CAN1TARQSTR _CAN1TARQ @(REG_BASE + 0x00000188);
#define CAN1TARQ                        _CAN1TARQ.Byte
#define CAN1TARQ_ABTRQ0                 _CAN1TARQ.Bits.ABTRQ0
#define CAN1TARQ_ABTRQ1                 _CAN1TARQ.Bits.ABTRQ1
#define CAN1TARQ_ABTRQ2                 _CAN1TARQ.Bits.ABTRQ2
#define CAN1TARQ_ABTRQ                  _CAN1TARQ.MergedBits.grpABTRQ

#define CAN1TARQ_ABTRQ0_MASK            1
#define CAN1TARQ_ABTRQ1_MASK            2
#define CAN1TARQ_ABTRQ2_MASK            4
#define CAN1TARQ_ABTRQ_MASK             %BitsMask
#define CAN1TARQ_ABTRQ_BITNUM           %BitsNum


/*** CAN1TAAK - MSCAN 1 Transmitter Message Abort Control; 0x00000189 ***/
typedef union {
  byte Byte;
  struct {
    byte ABTAK0      :1;                                       /* Abort Acknowledge 0 */
    byte ABTAK1      :1;                                       /* Abort Acknowledge 1 */
    byte ABTAK2      :1;                                       /* Abort Acknowledge 2 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpABTAK :3;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} CAN1TAAKSTR;
extern volatile CAN1TAAKSTR _CAN1TAAK @(REG_BASE + 0x00000189);
#define CAN1TAAK                        _CAN1TAAK.Byte
#define CAN1TAAK_ABTAK0                 _CAN1TAAK.Bits.ABTAK0
#define CAN1TAAK_ABTAK1                 _CAN1TAAK.Bits.ABTAK1
#define CAN1TAAK_ABTAK2                 _CAN1TAAK.Bits.ABTAK2
#define CAN1TAAK_ABTAK                  _CAN1TAAK.MergedBits.grpABTAK

#define CAN1TAAK_ABTAK0_MASK            1
#define CAN1TAAK_ABTAK1_MASK            2
#define CAN1TAAK_ABTAK2_MASK            4
#define CAN1TAAK_ABTAK_MASK             %BitsMask
#define CAN1TAAK_ABTAK_BITNUM           %BitsNum


/*** CAN1TBSEL - MSCAN 1 Transmit Buffer Selection; 0x0000018A ***/
typedef union {
  byte Byte;
  struct {
    byte TX0         :1;                                       /* Transmit Buffer Select 0 */
    byte TX1         :1;                                       /* Transmit Buffer Select 1 */
    byte TX2         :1;                                       /* Transmit Buffer Select 2 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpTX   :3;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} CAN1TBSELSTR;
extern volatile CAN1TBSELSTR _CAN1TBSEL @(REG_BASE + 0x0000018A);
#define CAN1TBSEL                       _CAN1TBSEL.Byte
#define CAN1TBSEL_TX0                   _CAN1TBSEL.Bits.TX0
#define CAN1TBSEL_TX1                   _CAN1TBSEL.Bits.TX1
#define CAN1TBSEL_TX2                   _CAN1TBSEL.Bits.TX2
#define CAN1TBSEL_TX                    _CAN1TBSEL.MergedBits.grpTX

#define CAN1TBSEL_TX0_MASK              1
#define CAN1TBSEL_TX1_MASK              2
#define CAN1TBSEL_TX2_MASK              4
#define CAN1TBSEL_TX_MASK               %BitsMask
#define CAN1TBSEL_TX_BITNUM             %BitsNum


/*** CAN1IDAC - MSCAN 1 Identifier Acceptance Control Register; 0x0000018B ***/
typedef union {
  byte Byte;
  struct {
    byte IDHIT0      :1;                                       /* Identifier Acceptance Hit Indicator 0 */
    byte IDHIT1      :1;                                       /* Identifier Acceptance Hit Indicator 1 */
    byte IDHIT2      :1;                                       /* Identifier Acceptance Hit Indicator 2 */
    byte             :1; 
    byte IDAM0       :1;                                       /* Identifier Acceptance Mode 0 */
    byte IDAM1       :1;                                       /* Identifier Acceptance Mode 1 */
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpIDHIT :3;
    byte         :1;
    byte grpIDAM :2;
    byte         :1;
    byte         :1;
  } MergedBits;
} CAN1IDACSTR;
extern volatile CAN1IDACSTR _CAN1IDAC @(REG_BASE + 0x0000018B);
#define CAN1IDAC                        _CAN1IDAC.Byte
#define CAN1IDAC_IDHIT0                 _CAN1IDAC.Bits.IDHIT0
#define CAN1IDAC_IDHIT1                 _CAN1IDAC.Bits.IDHIT1
#define CAN1IDAC_IDHIT2                 _CAN1IDAC.Bits.IDHIT2
#define CAN1IDAC_IDAM0                  _CAN1IDAC.Bits.IDAM0
#define CAN1IDAC_IDAM1                  _CAN1IDAC.Bits.IDAM1
#define CAN1IDAC_IDHIT                  _CAN1IDAC.MergedBits.grpIDHIT
#define CAN1IDAC_IDAM                   _CAN1IDAC.MergedBits.grpIDAM

#define CAN1IDAC_IDHIT0_MASK            1
#define CAN1IDAC_IDHIT1_MASK            2
#define CAN1IDAC_IDHIT2_MASK            4
#define CAN1IDAC_IDAM0_MASK             16
#define CAN1IDAC_IDAM1_MASK             32
#define CAN1IDAC_IDHIT_MASK             %BitsMask
#define CAN1IDAC_IDHIT_BITNUM           %BitsNum
#define CAN1IDAC_IDAM_MASK              %BitsMask
#define CAN1IDAC_IDAM_BITNUM            %BitsNum


/*** CAN1RXERR - MSCAN 1 Receive Error Counter Register; 0x0000018E ***/
typedef union {
  byte Byte;
  struct {
    byte RXERR0      :1;                                       /* Bit 0 */
    byte RXERR1      :1;                                       /* Bit 1 */
    byte RXERR2      :1;                                       /* Bit 2 */
    byte RXERR3      :1;                                       /* Bit 3 */
    byte RXERR4      :1;                                       /* Bit 4 */
    byte RXERR5      :1;                                       /* Bit 5 */
    byte RXERR6      :1;                                       /* Bit 6 */
    byte RXERR7      :1;                                       /* Bit 7 */
  } Bits;
} CAN1RXERRSTR;
extern volatile CAN1RXERRSTR _CAN1RXERR @(REG_BASE + 0x0000018E);
#define CAN1RXERR                       _CAN1RXERR.Byte
#define CAN1RXERR_RXERR0                _CAN1RXERR.Bits.RXERR0
#define CAN1RXERR_RXERR1                _CAN1RXERR.Bits.RXERR1
#define CAN1RXERR_RXERR2                _CAN1RXERR.Bits.RXERR2
#define CAN1RXERR_RXERR3                _CAN1RXERR.Bits.RXERR3
#define CAN1RXERR_RXERR4                _CAN1RXERR.Bits.RXERR4
#define CAN1RXERR_RXERR5                _CAN1RXERR.Bits.RXERR5
#define CAN1RXERR_RXERR6                _CAN1RXERR.Bits.RXERR6
#define CAN1RXERR_RXERR7                _CAN1RXERR.Bits.RXERR7

#define CAN1RXERR_RXERR0_MASK           1
#define CAN1RXERR_RXERR1_MASK           2
#define CAN1RXERR_RXERR2_MASK           4
#define CAN1RXERR_RXERR3_MASK           8
#define CAN1RXERR_RXERR4_MASK           16
#define CAN1RXERR_RXERR5_MASK           32
#define CAN1RXERR_RXERR6_MASK           64
#define CAN1RXERR_RXERR7_MASK           128


/*** CAN1TXERR - MSCAN 1 Transmit Error Counter Register; 0x0000018F ***/
typedef union {
  byte Byte;
  struct {
    byte TXERR0      :1;                                       /* Bit 0 */
    byte TXERR1      :1;                                       /* Bit 1 */
    byte TXERR2      :1;                                       /* Bit 2 */
    byte TXERR3      :1;                                       /* Bit 3 */
    byte TXERR4      :1;                                       /* Bit 4 */
    byte TXERR5      :1;                                       /* Bit 5 */
    byte TXERR6      :1;                                       /* Bit 6 */
    byte TXERR7      :1;                                       /* Bit 7 */
  } Bits;
} CAN1TXERRSTR;
extern volatile CAN1TXERRSTR _CAN1TXERR @(REG_BASE + 0x0000018F);
#define CAN1TXERR                       _CAN1TXERR.Byte
#define CAN1TXERR_TXERR0                _CAN1TXERR.Bits.TXERR0
#define CAN1TXERR_TXERR1                _CAN1TXERR.Bits.TXERR1
#define CAN1TXERR_TXERR2                _CAN1TXERR.Bits.TXERR2
#define CAN1TXERR_TXERR3                _CAN1TXERR.Bits.TXERR3
#define CAN1TXERR_TXERR4                _CAN1TXERR.Bits.TXERR4
#define CAN1TXERR_TXERR5                _CAN1TXERR.Bits.TXERR5
#define CAN1TXERR_TXERR6                _CAN1TXERR.Bits.TXERR6
#define CAN1TXERR_TXERR7                _CAN1TXERR.Bits.TXERR7

#define CAN1TXERR_TXERR0_MASK           1
#define CAN1TXERR_TXERR1_MASK           2
#define CAN1TXERR_TXERR2_MASK           4
#define CAN1TXERR_TXERR3_MASK           8
#define CAN1TXERR_TXERR4_MASK           16
#define CAN1TXERR_TXERR5_MASK           32
#define CAN1TXERR_TXERR6_MASK           64
#define CAN1TXERR_TXERR7_MASK           128


/*** CAN1IDAR0 - MSCAN 1 Identifier Acceptance Register 0; 0x00000190 ***/
typedef union {
  byte Byte;
  struct {
    byte AC0         :1;                                       /* Acceptance Code Bit 0 */
    byte AC1         :1;                                       /* Acceptance Code Bit 1 */
    byte AC2         :1;                                       /* Acceptance Code Bit 2 */
    byte AC3         :1;                                       /* Acceptance Code Bit 3 */
    byte AC4         :1;                                       /* Acceptance Code Bit 4 */
    byte AC5         :1;                                       /* Acceptance Code Bit 5 */
    byte AC6         :1;                                       /* Acceptance Code Bit 6 */
    byte AC7         :1;                                       /* Acceptance Code Bit 7 */
  } Bits;
} CAN1IDAR0STR;
extern volatile CAN1IDAR0STR _CAN1IDAR0 @(REG_BASE + 0x00000190);
#define CAN1IDAR0                       _CAN1IDAR0.Byte
#define CAN1IDAR0_AC0                   _CAN1IDAR0.Bits.AC0
#define CAN1IDAR0_AC1                   _CAN1IDAR0.Bits.AC1
#define CAN1IDAR0_AC2                   _CAN1IDAR0.Bits.AC2
#define CAN1IDAR0_AC3                   _CAN1IDAR0.Bits.AC3
#define CAN1IDAR0_AC4                   _CAN1IDAR0.Bits.AC4
#define CAN1IDAR0_AC5                   _CAN1IDAR0.Bits.AC5
#define CAN1IDAR0_AC6                   _CAN1IDAR0.Bits.AC6
#define CAN1IDAR0_AC7                   _CAN1IDAR0.Bits.AC7
/* CAN1IDAR_ARR: Access 4 CAN1IDARx registers in a array */
#define CAN1IDAR_ARR                    ((Byte *) &CAN1IDAR0)

#define CAN1IDAR0_AC0_MASK              1
#define CAN1IDAR0_AC1_MASK              2
#define CAN1IDAR0_AC2_MASK              4
#define CAN1IDAR0_AC3_MASK              8
#define CAN1IDAR0_AC4_MASK              16
#define CAN1IDAR0_AC5_MASK              32
#define CAN1IDAR0_AC6_MASK              64
#define CAN1IDAR0_AC7_MASK              128


/*** CAN1IDAR1 - MSCAN 1 Identifier Acceptance Register 1; 0x00000191 ***/
typedef union {
  byte Byte;
  struct {
    byte AC0         :1;                                       /* Acceptance Code Bit 0 */
    byte AC1         :1;                                       /* Acceptance Code Bit 1 */
    byte AC2         :1;                                       /* Acceptance Code Bit 2 */
    byte AC3         :1;                                       /* Acceptance Code Bit 3 */
    byte AC4         :1;                                       /* Acceptance Code Bit 4 */
    byte AC5         :1;                                       /* Acceptance Code Bit 5 */
    byte AC6         :1;                                       /* Acceptance Code Bit 6 */
    byte AC7         :1;                                       /* Acceptance Code Bit 7 */
  } Bits;
} CAN1IDAR1STR;
extern volatile CAN1IDAR1STR _CAN1IDAR1 @(REG_BASE + 0x00000191);
#define CAN1IDAR1                       _CAN1IDAR1.Byte
#define CAN1IDAR1_AC0                   _CAN1IDAR1.Bits.AC0
#define CAN1IDAR1_AC1                   _CAN1IDAR1.Bits.AC1
#define CAN1IDAR1_AC2                   _CAN1IDAR1.Bits.AC2
#define CAN1IDAR1_AC3                   _CAN1IDAR1.Bits.AC3
#define CAN1IDAR1_AC4                   _CAN1IDAR1.Bits.AC4
#define CAN1IDAR1_AC5                   _CAN1IDAR1.Bits.AC5
#define CAN1IDAR1_AC6                   _CAN1IDAR1.Bits.AC6
#define CAN1IDAR1_AC7                   _CAN1IDAR1.Bits.AC7

#define CAN1IDAR1_AC0_MASK              1
#define CAN1IDAR1_AC1_MASK              2
#define CAN1IDAR1_AC2_MASK              4
#define CAN1IDAR1_AC3_MASK              8
#define CAN1IDAR1_AC4_MASK              16
#define CAN1IDAR1_AC5_MASK              32
#define CAN1IDAR1_AC6_MASK              64
#define CAN1IDAR1_AC7_MASK              128


/*** CAN1IDAR2 - MSCAN 1 Identifier Acceptance Register 2; 0x00000192 ***/
typedef union {
  byte Byte;
  struct {
    byte AC0         :1;                                       /* Acceptance Code Bit 0 */
    byte AC1         :1;                                       /* Acceptance Code Bit 1 */
    byte AC2         :1;                                       /* Acceptance Code Bit 2 */
    byte AC3         :1;                                       /* Acceptance Code Bit 3 */
    byte AC4         :1;                                       /* Acceptance Code Bit 4 */
    byte AC5         :1;                                       /* Acceptance Code Bit 5 */
    byte AC6         :1;                                       /* Acceptance Code Bit 6 */
    byte AC7         :1;                                       /* Acceptance Code Bit 7 */
  } Bits;
} CAN1IDAR2STR;
extern volatile CAN1IDAR2STR _CAN1IDAR2 @(REG_BASE + 0x00000192);
#define CAN1IDAR2                       _CAN1IDAR2.Byte
#define CAN1IDAR2_AC0                   _CAN1IDAR2.Bits.AC0
#define CAN1IDAR2_AC1                   _CAN1IDAR2.Bits.AC1
#define CAN1IDAR2_AC2                   _CAN1IDAR2.Bits.AC2
#define CAN1IDAR2_AC3                   _CAN1IDAR2.Bits.AC3
#define CAN1IDAR2_AC4                   _CAN1IDAR2.Bits.AC4
#define CAN1IDAR2_AC5                   _CAN1IDAR2.Bits.AC5
#define CAN1IDAR2_AC6                   _CAN1IDAR2.Bits.AC6
#define CAN1IDAR2_AC7                   _CAN1IDAR2.Bits.AC7

#define CAN1IDAR2_AC0_MASK              1
#define CAN1IDAR2_AC1_MASK              2
#define CAN1IDAR2_AC2_MASK              4
#define CAN1IDAR2_AC3_MASK              8
#define CAN1IDAR2_AC4_MASK              16
#define CAN1IDAR2_AC5_MASK              32
#define CAN1IDAR2_AC6_MASK              64
#define CAN1IDAR2_AC7_MASK              128


/*** CAN1IDAR3 - MSCAN 1 Identifier Acceptance Register 3; 0x00000193 ***/
typedef union {
  byte Byte;
  struct {
    byte AC0         :1;                                       /* Acceptance Code Bit 0 */
    byte AC1         :1;                                       /* Acceptance Code Bit 1 */
    byte AC2         :1;                                       /* Acceptance Code Bit 2 */
    byte AC3         :1;                                       /* Acceptance Code Bit 3 */
    byte AC4         :1;                                       /* Acceptance Code Bit 4 */
    byte AC5         :1;                                       /* Acceptance Code Bit 5 */
    byte AC6         :1;                                       /* Acceptance Code Bit 6 */
    byte AC7         :1;                                       /* Acceptance Code Bit 7 */
  } Bits;
} CAN1IDAR3STR;
extern volatile CAN1IDAR3STR _CAN1IDAR3 @(REG_BASE + 0x00000193);
#define CAN1IDAR3                       _CAN1IDAR3.Byte
#define CAN1IDAR3_AC0                   _CAN1IDAR3.Bits.AC0
#define CAN1IDAR3_AC1                   _CAN1IDAR3.Bits.AC1
#define CAN1IDAR3_AC2                   _CAN1IDAR3.Bits.AC2
#define CAN1IDAR3_AC3                   _CAN1IDAR3.Bits.AC3
#define CAN1IDAR3_AC4                   _CAN1IDAR3.Bits.AC4
#define CAN1IDAR3_AC5                   _CAN1IDAR3.Bits.AC5
#define CAN1IDAR3_AC6                   _CAN1IDAR3.Bits.AC6
#define CAN1IDAR3_AC7                   _CAN1IDAR3.Bits.AC7

#define CAN1IDAR3_AC0_MASK              1
#define CAN1IDAR3_AC1_MASK              2
#define CAN1IDAR3_AC2_MASK              4
#define CAN1IDAR3_AC3_MASK              8
#define CAN1IDAR3_AC4_MASK              16
#define CAN1IDAR3_AC5_MASK              32
#define CAN1IDAR3_AC6_MASK              64
#define CAN1IDAR3_AC7_MASK              128


/*** CAN1IDMR0 - MSCAN 1 Identifier Mask Register 0; 0x00000194 ***/
typedef union {
  byte Byte;
  struct {
    byte AM0         :1;                                       /* Acceptance Mask Bit 0 */
    byte AM1         :1;                                       /* Acceptance Mask Bit 1 */
    byte AM2         :1;                                       /* Acceptance Mask Bit 2 */
    byte AM3         :1;                                       /* Acceptance Mask Bit 3 */
    byte AM4         :1;                                       /* Acceptance Mask Bit 4 */
    byte AM5         :1;                                       /* Acceptance Mask Bit 5 */
    byte AM6         :1;                                       /* Acceptance Mask Bit 6 */
    byte AM7         :1;                                       /* Acceptance Mask Bit 7 */
  } Bits;
} CAN1IDMR0STR;
extern volatile CAN1IDMR0STR _CAN1IDMR0 @(REG_BASE + 0x00000194);
#define CAN1IDMR0                       _CAN1IDMR0.Byte
#define CAN1IDMR0_AM0                   _CAN1IDMR0.Bits.AM0
#define CAN1IDMR0_AM1                   _CAN1IDMR0.Bits.AM1
#define CAN1IDMR0_AM2                   _CAN1IDMR0.Bits.AM2
#define CAN1IDMR0_AM3                   _CAN1IDMR0.Bits.AM3
#define CAN1IDMR0_AM4                   _CAN1IDMR0.Bits.AM4
#define CAN1IDMR0_AM5                   _CAN1IDMR0.Bits.AM5
#define CAN1IDMR0_AM6                   _CAN1IDMR0.Bits.AM6
#define CAN1IDMR0_AM7                   _CAN1IDMR0.Bits.AM7
/* CAN1IDMR_ARR: Access 4 CAN1IDMRx registers in a array */
#define CAN1IDMR_ARR                    ((Byte *) &CAN1IDMR0)

#define CAN1IDMR0_AM0_MASK              1
#define CAN1IDMR0_AM1_MASK              2
#define CAN1IDMR0_AM2_MASK              4
#define CAN1IDMR0_AM3_MASK              8
#define CAN1IDMR0_AM4_MASK              16
#define CAN1IDMR0_AM5_MASK              32
#define CAN1IDMR0_AM6_MASK              64
#define CAN1IDMR0_AM7_MASK              128


/*** CAN1IDMR1 - MSCAN 1 Identifier Mask Register 1; 0x00000195 ***/
typedef union {
  byte Byte;
  struct {
    byte AM0         :1;                                       /* Acceptance Mask Bit 0 */
    byte AM1         :1;                                       /* Acceptance Mask Bit 1 */
    byte AM2         :1;                                       /* Acceptance Mask Bit 2 */
    byte AM3         :1;                                       /* Acceptance Mask Bit 3 */
    byte AM4         :1;                                       /* Acceptance Mask Bit 4 */
    byte AM5         :1;                                       /* Acceptance Mask Bit 5 */
    byte AM6         :1;                                       /* Acceptance Mask Bit 6 */
    byte AM7         :1;                                       /* Acceptance Mask Bit 7 */
  } Bits;
} CAN1IDMR1STR;
extern volatile CAN1IDMR1STR _CAN1IDMR1 @(REG_BASE + 0x00000195);
#define CAN1IDMR1                       _CAN1IDMR1.Byte
#define CAN1IDMR1_AM0                   _CAN1IDMR1.Bits.AM0
#define CAN1IDMR1_AM1                   _CAN1IDMR1.Bits.AM1
#define CAN1IDMR1_AM2                   _CAN1IDMR1.Bits.AM2
#define CAN1IDMR1_AM3                   _CAN1IDMR1.Bits.AM3
#define CAN1IDMR1_AM4                   _CAN1IDMR1.Bits.AM4
#define CAN1IDMR1_AM5                   _CAN1IDMR1.Bits.AM5
#define CAN1IDMR1_AM6                   _CAN1IDMR1.Bits.AM6
#define CAN1IDMR1_AM7                   _CAN1IDMR1.Bits.AM7

#define CAN1IDMR1_AM0_MASK              1
#define CAN1IDMR1_AM1_MASK              2
#define CAN1IDMR1_AM2_MASK              4
#define CAN1IDMR1_AM3_MASK              8
#define CAN1IDMR1_AM4_MASK              16
#define CAN1IDMR1_AM5_MASK              32
#define CAN1IDMR1_AM6_MASK              64
#define CAN1IDMR1_AM7_MASK              128


/*** CAN1IDMR2 - MSCAN 1 Identifier Mask Register 2; 0x00000196 ***/
typedef union {
  byte Byte;
  struct {
    byte AM0         :1;                                       /* Acceptance Mask Bit 0 */
    byte AM1         :1;                                       /* Acceptance Mask Bit 1 */
    byte AM2         :1;                                       /* Acceptance Mask Bit 2 */
    byte AM3         :1;                                       /* Acceptance Mask Bit 3 */
    byte AM4         :1;                                       /* Acceptance Mask Bit 4 */
    byte AM5         :1;                                       /* Acceptance Mask Bit 5 */
    byte AM6         :1;                                       /* Acceptance Mask Bit 6 */
    byte AM7         :1;                                       /* Acceptance Mask Bit 7 */
  } Bits;
} CAN1IDMR2STR;
extern volatile CAN1IDMR2STR _CAN1IDMR2 @(REG_BASE + 0x00000196);
#define CAN1IDMR2                       _CAN1IDMR2.Byte
#define CAN1IDMR2_AM0                   _CAN1IDMR2.Bits.AM0
#define CAN1IDMR2_AM1                   _CAN1IDMR2.Bits.AM1
#define CAN1IDMR2_AM2                   _CAN1IDMR2.Bits.AM2
#define CAN1IDMR2_AM3                   _CAN1IDMR2.Bits.AM3
#define CAN1IDMR2_AM4                   _CAN1IDMR2.Bits.AM4
#define CAN1IDMR2_AM5                   _CAN1IDMR2.Bits.AM5
#define CAN1IDMR2_AM6                   _CAN1IDMR2.Bits.AM6
#define CAN1IDMR2_AM7                   _CAN1IDMR2.Bits.AM7

#define CAN1IDMR2_AM0_MASK              1
#define CAN1IDMR2_AM1_MASK              2
#define CAN1IDMR2_AM2_MASK              4
#define CAN1IDMR2_AM3_MASK              8
#define CAN1IDMR2_AM4_MASK              16
#define CAN1IDMR2_AM5_MASK              32
#define CAN1IDMR2_AM6_MASK              64
#define CAN1IDMR2_AM7_MASK              128


/*** CAN1IDMR3 - MSCAN 1 Identifier Mask Register 3; 0x00000197 ***/
typedef union {
  byte Byte;
  struct {
    byte AM0         :1;                                       /* Acceptance Mask Bit 0 */
    byte AM1         :1;                                       /* Acceptance Mask Bit 1 */
    byte AM2         :1;                                       /* Acceptance Mask Bit 2 */
    byte AM3         :1;                                       /* Acceptance Mask Bit 3 */
    byte AM4         :1;                                       /* Acceptance Mask Bit 4 */
    byte AM5         :1;                                       /* Acceptance Mask Bit 5 */
    byte AM6         :1;                                       /* Acceptance Mask Bit 6 */
    byte AM7         :1;                                       /* Acceptance Mask Bit 7 */
  } Bits;
} CAN1IDMR3STR;
extern volatile CAN1IDMR3STR _CAN1IDMR3 @(REG_BASE + 0x00000197);
#define CAN1IDMR3                       _CAN1IDMR3.Byte
#define CAN1IDMR3_AM0                   _CAN1IDMR3.Bits.AM0
#define CAN1IDMR3_AM1                   _CAN1IDMR3.Bits.AM1
#define CAN1IDMR3_AM2                   _CAN1IDMR3.Bits.AM2
#define CAN1IDMR3_AM3                   _CAN1IDMR3.Bits.AM3
#define CAN1IDMR3_AM4                   _CAN1IDMR3.Bits.AM4
#define CAN1IDMR3_AM5                   _CAN1IDMR3.Bits.AM5
#define CAN1IDMR3_AM6                   _CAN1IDMR3.Bits.AM6
#define CAN1IDMR3_AM7                   _CAN1IDMR3.Bits.AM7

#define CAN1IDMR3_AM0_MASK              1
#define CAN1IDMR3_AM1_MASK              2
#define CAN1IDMR3_AM2_MASK              4
#define CAN1IDMR3_AM3_MASK              8
#define CAN1IDMR3_AM4_MASK              16
#define CAN1IDMR3_AM5_MASK              32
#define CAN1IDMR3_AM6_MASK              64
#define CAN1IDMR3_AM7_MASK              128


/*** CAN1IDAR4 - MSCAN 1 Identifier Acceptance Register 4; 0x00000198 ***/
typedef union {
  byte Byte;
  struct {
    byte AC0         :1;                                       /* Acceptance Code Bit 0 */
    byte AC1         :1;                                       /* Acceptance Code Bit 1 */
    byte AC2         :1;                                       /* Acceptance Code Bit 2 */
    byte AC3         :1;                                       /* Acceptance Code Bit 3 */
    byte AC4         :1;                                       /* Acceptance Code Bit 4 */
    byte AC5         :1;                                       /* Acceptance Code Bit 5 */
    byte AC6         :1;                                       /* Acceptance Code Bit 6 */
    byte AC7         :1;                                       /* Acceptance Code Bit 7 */
  } Bits;
} CAN1IDAR4STR;
extern volatile CAN1IDAR4STR _CAN1IDAR4 @(REG_BASE + 0x00000198);
#define CAN1IDAR4                       _CAN1IDAR4.Byte
#define CAN1IDAR4_AC0                   _CAN1IDAR4.Bits.AC0
#define CAN1IDAR4_AC1                   _CAN1IDAR4.Bits.AC1
#define CAN1IDAR4_AC2                   _CAN1IDAR4.Bits.AC2
#define CAN1IDAR4_AC3                   _CAN1IDAR4.Bits.AC3
#define CAN1IDAR4_AC4                   _CAN1IDAR4.Bits.AC4
#define CAN1IDAR4_AC5                   _CAN1IDAR4.Bits.AC5
#define CAN1IDAR4_AC6                   _CAN1IDAR4.Bits.AC6
#define CAN1IDAR4_AC7                   _CAN1IDAR4.Bits.AC7

#define CAN1IDAR4_AC0_MASK              1
#define CAN1IDAR4_AC1_MASK              2
#define CAN1IDAR4_AC2_MASK              4
#define CAN1IDAR4_AC3_MASK              8
#define CAN1IDAR4_AC4_MASK              16
#define CAN1IDAR4_AC5_MASK              32
#define CAN1IDAR4_AC6_MASK              64
#define CAN1IDAR4_AC7_MASK              128


/*** CAN1IDAR5 - MSCAN 1 Identifier Acceptance Register 5; 0x00000199 ***/
typedef union {
  byte Byte;
  struct {
    byte AC0         :1;                                       /* Acceptance Code Bit 0 */
    byte AC1         :1;                                       /* Acceptance Code Bit 1 */
    byte AC2         :1;                                       /* Acceptance Code Bit 2 */
    byte AC3         :1;                                       /* Acceptance Code Bit 3 */
    byte AC4         :1;                                       /* Acceptance Code Bit 4 */
    byte AC5         :1;                                       /* Acceptance Code Bit 5 */
    byte AC6         :1;                                       /* Acceptance Code Bit 6 */
    byte AC7         :1;                                       /* Acceptance Code Bit 7 */
  } Bits;
} CAN1IDAR5STR;
extern volatile CAN1IDAR5STR _CAN1IDAR5 @(REG_BASE + 0x00000199);
#define CAN1IDAR5                       _CAN1IDAR5.Byte
#define CAN1IDAR5_AC0                   _CAN1IDAR5.Bits.AC0
#define CAN1IDAR5_AC1                   _CAN1IDAR5.Bits.AC1
#define CAN1IDAR5_AC2                   _CAN1IDAR5.Bits.AC2
#define CAN1IDAR5_AC3                   _CAN1IDAR5.Bits.AC3
#define CAN1IDAR5_AC4                   _CAN1IDAR5.Bits.AC4
#define CAN1IDAR5_AC5                   _CAN1IDAR5.Bits.AC5
#define CAN1IDAR5_AC6                   _CAN1IDAR5.Bits.AC6
#define CAN1IDAR5_AC7                   _CAN1IDAR5.Bits.AC7

#define CAN1IDAR5_AC0_MASK              1
#define CAN1IDAR5_AC1_MASK              2
#define CAN1IDAR5_AC2_MASK              4
#define CAN1IDAR5_AC3_MASK              8
#define CAN1IDAR5_AC4_MASK              16
#define CAN1IDAR5_AC5_MASK              32
#define CAN1IDAR5_AC6_MASK              64
#define CAN1IDAR5_AC7_MASK              128


/*** CAN1IDAR6 - MSCAN 1 Identifier Acceptance Register 6; 0x0000019A ***/
typedef union {
  byte Byte;
  struct {
    byte AC0         :1;                                       /* Acceptance Code Bit 0 */
    byte AC1         :1;                                       /* Acceptance Code Bit 1 */
    byte AC2         :1;                                       /* Acceptance Code Bit 2 */
    byte AC3         :1;                                       /* Acceptance Code Bit 3 */
    byte AC4         :1;                                       /* Acceptance Code Bit 4 */
    byte AC5         :1;                                       /* Acceptance Code Bit 5 */
    byte AC6         :1;                                       /* Acceptance Code Bit 6 */
    byte AC7         :1;                                       /* Acceptance Code Bit 7 */
  } Bits;
} CAN1IDAR6STR;
extern volatile CAN1IDAR6STR _CAN1IDAR6 @(REG_BASE + 0x0000019A);
#define CAN1IDAR6                       _CAN1IDAR6.Byte
#define CAN1IDAR6_AC0                   _CAN1IDAR6.Bits.AC0
#define CAN1IDAR6_AC1                   _CAN1IDAR6.Bits.AC1
#define CAN1IDAR6_AC2                   _CAN1IDAR6.Bits.AC2
#define CAN1IDAR6_AC3                   _CAN1IDAR6.Bits.AC3
#define CAN1IDAR6_AC4                   _CAN1IDAR6.Bits.AC4
#define CAN1IDAR6_AC5                   _CAN1IDAR6.Bits.AC5
#define CAN1IDAR6_AC6                   _CAN1IDAR6.Bits.AC6
#define CAN1IDAR6_AC7                   _CAN1IDAR6.Bits.AC7

#define CAN1IDAR6_AC0_MASK              1
#define CAN1IDAR6_AC1_MASK              2
#define CAN1IDAR6_AC2_MASK              4
#define CAN1IDAR6_AC3_MASK              8
#define CAN1IDAR6_AC4_MASK              16
#define CAN1IDAR6_AC5_MASK              32
#define CAN1IDAR6_AC6_MASK              64
#define CAN1IDAR6_AC7_MASK              128


/*** CAN1IDAR7 - MSCAN 1 Identifier Acceptance Register 7; 0x0000019B ***/
typedef union {
  byte Byte;
  struct {
    byte AC0         :1;                                       /* Acceptance Code Bit 0 */
    byte AC1         :1;                                       /* Acceptance Code Bit 1 */
    byte AC2         :1;                                       /* Acceptance Code Bit 2 */
    byte AC3         :1;                                       /* Acceptance Code Bit 3 */
    byte AC4         :1;                                       /* Acceptance Code Bit 4 */
    byte AC5         :1;                                       /* Acceptance Code Bit 5 */
    byte AC6         :1;                                       /* Acceptance Code Bit 6 */
    byte AC7         :1;                                       /* Acceptance Code Bit 7 */
  } Bits;
} CAN1IDAR7STR;
extern volatile CAN1IDAR7STR _CAN1IDAR7 @(REG_BASE + 0x0000019B);
#define CAN1IDAR7                       _CAN1IDAR7.Byte
#define CAN1IDAR7_AC0                   _CAN1IDAR7.Bits.AC0
#define CAN1IDAR7_AC1                   _CAN1IDAR7.Bits.AC1
#define CAN1IDAR7_AC2                   _CAN1IDAR7.Bits.AC2
#define CAN1IDAR7_AC3                   _CAN1IDAR7.Bits.AC3
#define CAN1IDAR7_AC4                   _CAN1IDAR7.Bits.AC4
#define CAN1IDAR7_AC5                   _CAN1IDAR7.Bits.AC5
#define CAN1IDAR7_AC6                   _CAN1IDAR7.Bits.AC6
#define CAN1IDAR7_AC7                   _CAN1IDAR7.Bits.AC7

#define CAN1IDAR7_AC0_MASK              1
#define CAN1IDAR7_AC1_MASK              2
#define CAN1IDAR7_AC2_MASK              4
#define CAN1IDAR7_AC3_MASK              8
#define CAN1IDAR7_AC4_MASK              16
#define CAN1IDAR7_AC5_MASK              32
#define CAN1IDAR7_AC6_MASK              64
#define CAN1IDAR7_AC7_MASK              128


/*** CAN1IDMR4 - MSCAN 1 Identifier Mask Register 4; 0x0000019C ***/
typedef union {
  byte Byte;
  struct {
    byte AM0         :1;                                       /* Acceptance Mask Bit 0 */
    byte AM1         :1;                                       /* Acceptance Mask Bit 1 */
    byte AM2         :1;                                       /* Acceptance Mask Bit 2 */
    byte AM3         :1;                                       /* Acceptance Mask Bit 3 */
    byte AM4         :1;                                       /* Acceptance Mask Bit 4 */
    byte AM5         :1;                                       /* Acceptance Mask Bit 5 */
    byte AM6         :1;                                       /* Acceptance Mask Bit 6 */
    byte AM7         :1;                                       /* Acceptance Mask Bit 7 */
  } Bits;
} CAN1IDMR4STR;
extern volatile CAN1IDMR4STR _CAN1IDMR4 @(REG_BASE + 0x0000019C);
#define CAN1IDMR4                       _CAN1IDMR4.Byte
#define CAN1IDMR4_AM0                   _CAN1IDMR4.Bits.AM0
#define CAN1IDMR4_AM1                   _CAN1IDMR4.Bits.AM1
#define CAN1IDMR4_AM2                   _CAN1IDMR4.Bits.AM2
#define CAN1IDMR4_AM3                   _CAN1IDMR4.Bits.AM3
#define CAN1IDMR4_AM4                   _CAN1IDMR4.Bits.AM4
#define CAN1IDMR4_AM5                   _CAN1IDMR4.Bits.AM5
#define CAN1IDMR4_AM6                   _CAN1IDMR4.Bits.AM6
#define CAN1IDMR4_AM7                   _CAN1IDMR4.Bits.AM7

#define CAN1IDMR4_AM0_MASK              1
#define CAN1IDMR4_AM1_MASK              2
#define CAN1IDMR4_AM2_MASK              4
#define CAN1IDMR4_AM3_MASK              8
#define CAN1IDMR4_AM4_MASK              16
#define CAN1IDMR4_AM5_MASK              32
#define CAN1IDMR4_AM6_MASK              64
#define CAN1IDMR4_AM7_MASK              128


/*** CAN1IDMR5 - MSCAN 1 Identifier Mask Register 5; 0x0000019D ***/
typedef union {
  byte Byte;
  struct {
    byte AM0         :1;                                       /* Acceptance Mask Bit 0 */
    byte AM1         :1;                                       /* Acceptance Mask Bit 1 */
    byte AM2         :1;                                       /* Acceptance Mask Bit 2 */
    byte AM3         :1;                                       /* Acceptance Mask Bit 3 */
    byte AM4         :1;                                       /* Acceptance Mask Bit 4 */
    byte AM5         :1;                                       /* Acceptance Mask Bit 5 */
    byte AM6         :1;                                       /* Acceptance Mask Bit 6 */
    byte AM7         :1;                                       /* Acceptance Mask Bit 7 */
  } Bits;
} CAN1IDMR5STR;
extern volatile CAN1IDMR5STR _CAN1IDMR5 @(REG_BASE + 0x0000019D);
#define CAN1IDMR5                       _CAN1IDMR5.Byte
#define CAN1IDMR5_AM0                   _CAN1IDMR5.Bits.AM0
#define CAN1IDMR5_AM1                   _CAN1IDMR5.Bits.AM1
#define CAN1IDMR5_AM2                   _CAN1IDMR5.Bits.AM2
#define CAN1IDMR5_AM3                   _CAN1IDMR5.Bits.AM3
#define CAN1IDMR5_AM4                   _CAN1IDMR5.Bits.AM4
#define CAN1IDMR5_AM5                   _CAN1IDMR5.Bits.AM5
#define CAN1IDMR5_AM6                   _CAN1IDMR5.Bits.AM6
#define CAN1IDMR5_AM7                   _CAN1IDMR5.Bits.AM7

#define CAN1IDMR5_AM0_MASK              1
#define CAN1IDMR5_AM1_MASK              2
#define CAN1IDMR5_AM2_MASK              4
#define CAN1IDMR5_AM3_MASK              8
#define CAN1IDMR5_AM4_MASK              16
#define CAN1IDMR5_AM5_MASK              32
#define CAN1IDMR5_AM6_MASK              64
#define CAN1IDMR5_AM7_MASK              128


/*** CAN1IDMR6 - MSCAN 1 Identifier Mask Register 6; 0x0000019E ***/
typedef union {
  byte Byte;
  struct {
    byte AM0         :1;                                       /* Acceptance Mask Bit 0 */
    byte AM1         :1;                                       /* Acceptance Mask Bit 1 */
    byte AM2         :1;                                       /* Acceptance Mask Bit 2 */
    byte AM3         :1;                                       /* Acceptance Mask Bit 3 */
    byte AM4         :1;                                       /* Acceptance Mask Bit 4 */
    byte AM5         :1;                                       /* Acceptance Mask Bit 5 */
    byte AM6         :1;                                       /* Acceptance Mask Bit 6 */
    byte AM7         :1;                                       /* Acceptance Mask Bit 7 */
  } Bits;
} CAN1IDMR6STR;
extern volatile CAN1IDMR6STR _CAN1IDMR6 @(REG_BASE + 0x0000019E);
#define CAN1IDMR6                       _CAN1IDMR6.Byte
#define CAN1IDMR6_AM0                   _CAN1IDMR6.Bits.AM0
#define CAN1IDMR6_AM1                   _CAN1IDMR6.Bits.AM1
#define CAN1IDMR6_AM2                   _CAN1IDMR6.Bits.AM2
#define CAN1IDMR6_AM3                   _CAN1IDMR6.Bits.AM3
#define CAN1IDMR6_AM4                   _CAN1IDMR6.Bits.AM4
#define CAN1IDMR6_AM5                   _CAN1IDMR6.Bits.AM5
#define CAN1IDMR6_AM6                   _CAN1IDMR6.Bits.AM6
#define CAN1IDMR6_AM7                   _CAN1IDMR6.Bits.AM7

#define CAN1IDMR6_AM0_MASK              1
#define CAN1IDMR6_AM1_MASK              2
#define CAN1IDMR6_AM2_MASK              4
#define CAN1IDMR6_AM3_MASK              8
#define CAN1IDMR6_AM4_MASK              16
#define CAN1IDMR6_AM5_MASK              32
#define CAN1IDMR6_AM6_MASK              64
#define CAN1IDMR6_AM7_MASK              128


/*** CAN1IDMR7 - MSCAN 1 Identifier Mask Register 7; 0x0000019F ***/
typedef union {
  byte Byte;
  struct {
    byte AM0         :1;                                       /* Acceptance Mask Bit 0 */
    byte AM1         :1;                                       /* Acceptance Mask Bit 1 */
    byte AM2         :1;                                       /* Acceptance Mask Bit 2 */
    byte AM3         :1;                                       /* Acceptance Mask Bit 3 */
    byte AM4         :1;                                       /* Acceptance Mask Bit 4 */
    byte AM5         :1;                                       /* Acceptance Mask Bit 5 */
    byte AM6         :1;                                       /* Acceptance Mask Bit 6 */
    byte AM7         :1;                                       /* Acceptance Mask Bit 7 */
  } Bits;
} CAN1IDMR7STR;
extern volatile CAN1IDMR7STR _CAN1IDMR7 @(REG_BASE + 0x0000019F);
#define CAN1IDMR7                       _CAN1IDMR7.Byte
#define CAN1IDMR7_AM0                   _CAN1IDMR7.Bits.AM0
#define CAN1IDMR7_AM1                   _CAN1IDMR7.Bits.AM1
#define CAN1IDMR7_AM2                   _CAN1IDMR7.Bits.AM2
#define CAN1IDMR7_AM3                   _CAN1IDMR7.Bits.AM3
#define CAN1IDMR7_AM4                   _CAN1IDMR7.Bits.AM4
#define CAN1IDMR7_AM5                   _CAN1IDMR7.Bits.AM5
#define CAN1IDMR7_AM6                   _CAN1IDMR7.Bits.AM6
#define CAN1IDMR7_AM7                   _CAN1IDMR7.Bits.AM7

#define CAN1IDMR7_AM0_MASK              1
#define CAN1IDMR7_AM1_MASK              2
#define CAN1IDMR7_AM2_MASK              4
#define CAN1IDMR7_AM3_MASK              8
#define CAN1IDMR7_AM4_MASK              16
#define CAN1IDMR7_AM5_MASK              32
#define CAN1IDMR7_AM6_MASK              64
#define CAN1IDMR7_AM7_MASK              128


/*** CAN1RXIDR0 - MSCAN 1 Receive Identifier Register 0; 0x000001A0 ***/
typedef union {
  byte Byte;
  struct {
    byte ID21        :1;                                       /* Extended format identifier Bit 21 */
    byte ID22        :1;                                       /* Extended format identifier Bit 22 */
    byte ID23        :1;                                       /* Extended format identifier Bit 23 */
    byte ID24        :1;                                       /* Extended format identifier Bit 24 */
    byte ID25        :1;                                       /* Extended format identifier Bit 25 */
    byte ID26        :1;                                       /* Extended format identifier Bit 26 */
    byte ID27        :1;                                       /* Extended format identifier Bit 27 */
    byte ID28        :1;                                       /* Extended format identifier Bit 28 */
  } Bits;
} CAN1RXIDR0STR;
extern volatile CAN1RXIDR0STR _CAN1RXIDR0 @(REG_BASE + 0x000001A0);
#define CAN1RXIDR0                      _CAN1RXIDR0.Byte
#define CAN1RXIDR0_ID21                 _CAN1RXIDR0.Bits.ID21
#define CAN1RXIDR0_ID22                 _CAN1RXIDR0.Bits.ID22
#define CAN1RXIDR0_ID23                 _CAN1RXIDR0.Bits.ID23
#define CAN1RXIDR0_ID24                 _CAN1RXIDR0.Bits.ID24
#define CAN1RXIDR0_ID25                 _CAN1RXIDR0.Bits.ID25
#define CAN1RXIDR0_ID26                 _CAN1RXIDR0.Bits.ID26
#define CAN1RXIDR0_ID27                 _CAN1RXIDR0.Bits.ID27
#define CAN1RXIDR0_ID28                 _CAN1RXIDR0.Bits.ID28
/* CAN1RXIDR_ARR: Access 4 CAN1RXIDRx registers in a array */
#define CAN1RXIDR_ARR                   ((Byte *) &CAN1RXIDR0)

#define CAN1RXIDR0_ID21_MASK            1
#define CAN1RXIDR0_ID22_MASK            2
#define CAN1RXIDR0_ID23_MASK            4
#define CAN1RXIDR0_ID24_MASK            8
#define CAN1RXIDR0_ID25_MASK            16
#define CAN1RXIDR0_ID26_MASK            32
#define CAN1RXIDR0_ID27_MASK            64
#define CAN1RXIDR0_ID28_MASK            128


/*** CAN1RXIDR1 - MSCAN 1 Receive Identifier Register 1; 0x000001A1 ***/
typedef union {
  byte Byte;
  struct {
    byte ID15        :1;                                       /* Extended format identifier Bit 15 */
    byte ID16        :1;                                       /* Extended format identifier Bit 16 */
    byte ID17        :1;                                       /* Extended format identifier Bit 17 */
    byte IDE         :1;                                       /* ID Extended */
    byte SRR         :1;                                       /* Substitute Remote Request */
    byte ID18        :1;                                       /* Extended format identifier Bit 18 */
    byte ID19        :1;                                       /* Extended format identifier Bit 19 */
    byte ID20        :1;                                       /* Extended format identifier Bit 20 */
  } Bits;
  struct {
    byte grpID_15 :3;
    byte         :1;
    byte         :1;
    byte grpID_18 :3;
  } MergedBits;
} CAN1RXIDR1STR;
extern volatile CAN1RXIDR1STR _CAN1RXIDR1 @(REG_BASE + 0x000001A1);
#define CAN1RXIDR1                      _CAN1RXIDR1.Byte
#define CAN1RXIDR1_ID15                 _CAN1RXIDR1.Bits.ID15
#define CAN1RXIDR1_ID16                 _CAN1RXIDR1.Bits.ID16
#define CAN1RXIDR1_ID17                 _CAN1RXIDR1.Bits.ID17
#define CAN1RXIDR1_IDE                  _CAN1RXIDR1.Bits.IDE
#define CAN1RXIDR1_SRR                  _CAN1RXIDR1.Bits.SRR
#define CAN1RXIDR1_ID18                 _CAN1RXIDR1.Bits.ID18
#define CAN1RXIDR1_ID19                 _CAN1RXIDR1.Bits.ID19
#define CAN1RXIDR1_ID20                 _CAN1RXIDR1.Bits.ID20
#define CAN1RXIDR1_ID_15                _CAN1RXIDR1.MergedBits.grpID_15
#define CAN1RXIDR1_ID_18                _CAN1RXIDR1.MergedBits.grpID_18
#define CAN1RXIDR1_ID                   CAN1RXIDR1_ID_15

#define CAN1RXIDR1_ID15_MASK            1
#define CAN1RXIDR1_ID16_MASK            2
#define CAN1RXIDR1_ID17_MASK            4
#define CAN1RXIDR1_IDE_MASK             8
#define CAN1RXIDR1_SRR_MASK             16
#define CAN1RXIDR1_ID18_MASK            32
#define CAN1RXIDR1_ID19_MASK            64
#define CAN1RXIDR1_ID20_MASK            128
#define CAN1RXIDR1_ID_15_MASK           %BitsMask
#define CAN1RXIDR1_ID_15_BITNUM         %BitsNum
#define CAN1RXIDR1_ID_18_MASK           %BitsMask
#define CAN1RXIDR1_ID_18_BITNUM         %BitsNum


/*** CAN1RXIDR2 - MSCAN 1 Receive Identifier Register 2; 0x000001A2 ***/
typedef union {
  byte Byte;
  struct {
    byte ID7         :1;                                       /* Extended format identifier Bit 7 */
    byte ID8         :1;                                       /* Extended format identifier Bit 8 */
    byte ID9         :1;                                       /* Extended format identifier Bit 9 */
    byte ID10        :1;                                       /* Extended format identifier Bit 10 */
    byte ID11        :1;                                       /* Extended format identifier Bit 11 */
    byte ID12        :1;                                       /* Extended format identifier Bit 12 */
    byte ID13        :1;                                       /* Extended format identifier Bit 13 */
    byte ID14        :1;                                       /* Extended format identifier Bit 14 */
  } Bits;
} CAN1RXIDR2STR;
extern volatile CAN1RXIDR2STR _CAN1RXIDR2 @(REG_BASE + 0x000001A2);
#define CAN1RXIDR2                      _CAN1RXIDR2.Byte
#define CAN1RXIDR2_ID7                  _CAN1RXIDR2.Bits.ID7
#define CAN1RXIDR2_ID8                  _CAN1RXIDR2.Bits.ID8
#define CAN1RXIDR2_ID9                  _CAN1RXIDR2.Bits.ID9
#define CAN1RXIDR2_ID10                 _CAN1RXIDR2.Bits.ID10
#define CAN1RXIDR2_ID11                 _CAN1RXIDR2.Bits.ID11
#define CAN1RXIDR2_ID12                 _CAN1RXIDR2.Bits.ID12
#define CAN1RXIDR2_ID13                 _CAN1RXIDR2.Bits.ID13
#define CAN1RXIDR2_ID14                 _CAN1RXIDR2.Bits.ID14

#define CAN1RXIDR2_ID7_MASK             1
#define CAN1RXIDR2_ID8_MASK             2
#define CAN1RXIDR2_ID9_MASK             4
#define CAN1RXIDR2_ID10_MASK            8
#define CAN1RXIDR2_ID11_MASK            16
#define CAN1RXIDR2_ID12_MASK            32
#define CAN1RXIDR2_ID13_MASK            64
#define CAN1RXIDR2_ID14_MASK            128


/*** CAN1RXIDR3 - MSCAN 1 Receive Identifier Register 3; 0x000001A3 ***/
typedef union {
  byte Byte;
  struct {
    byte RTR         :1;                                       /* Remote Transmission Request */
    byte ID0         :1;                                       /* Extended format identifier Bit 0 */
    byte ID1         :1;                                       /* Extended format identifier Bit 1 */
    byte ID2         :1;                                       /* Extended format identifier Bit 2 */
    byte ID3         :1;                                       /* Extended format identifier Bit 3 */
    byte ID4         :1;                                       /* Extended format identifier Bit 4 */
    byte ID5         :1;                                       /* Extended format identifier Bit 5 */
    byte ID6         :1;                                       /* Extended format identifier Bit 6 */
  } Bits;
  struct {
    byte         :1;
    byte grpID   :7;
  } MergedBits;
} CAN1RXIDR3STR;
extern volatile CAN1RXIDR3STR _CAN1RXIDR3 @(REG_BASE + 0x000001A3);
#define CAN1RXIDR3                      _CAN1RXIDR3.Byte
#define CAN1RXIDR3_RTR                  _CAN1RXIDR3.Bits.RTR
#define CAN1RXIDR3_ID0                  _CAN1RXIDR3.Bits.ID0
#define CAN1RXIDR3_ID1                  _CAN1RXIDR3.Bits.ID1
#define CAN1RXIDR3_ID2                  _CAN1RXIDR3.Bits.ID2
#define CAN1RXIDR3_ID3                  _CAN1RXIDR3.Bits.ID3
#define CAN1RXIDR3_ID4                  _CAN1RXIDR3.Bits.ID4
#define CAN1RXIDR3_ID5                  _CAN1RXIDR3.Bits.ID5
#define CAN1RXIDR3_ID6                  _CAN1RXIDR3.Bits.ID6
#define CAN1RXIDR3_ID                   _CAN1RXIDR3.MergedBits.grpID

#define CAN1RXIDR3_RTR_MASK             1
#define CAN1RXIDR3_ID0_MASK             2
#define CAN1RXIDR3_ID1_MASK             4
#define CAN1RXIDR3_ID2_MASK             8
#define CAN1RXIDR3_ID3_MASK             16
#define CAN1RXIDR3_ID4_MASK             32
#define CAN1RXIDR3_ID5_MASK             64
#define CAN1RXIDR3_ID6_MASK             128
#define CAN1RXIDR3_ID_MASK              %BitsMask
#define CAN1RXIDR3_ID_BITNUM            %BitsNum


/*** CAN1RXDSR0 - MSCAN 1 Receive Data Segment Register 0; 0x000001A4 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN1RXDSR0STR;
extern volatile CAN1RXDSR0STR _CAN1RXDSR0 @(REG_BASE + 0x000001A4);
#define CAN1RXDSR0                      _CAN1RXDSR0.Byte
#define CAN1RXDSR0_DB0                  _CAN1RXDSR0.Bits.DB0
#define CAN1RXDSR0_DB1                  _CAN1RXDSR0.Bits.DB1
#define CAN1RXDSR0_DB2                  _CAN1RXDSR0.Bits.DB2
#define CAN1RXDSR0_DB3                  _CAN1RXDSR0.Bits.DB3
#define CAN1RXDSR0_DB4                  _CAN1RXDSR0.Bits.DB4
#define CAN1RXDSR0_DB5                  _CAN1RXDSR0.Bits.DB5
#define CAN1RXDSR0_DB6                  _CAN1RXDSR0.Bits.DB6
#define CAN1RXDSR0_DB7                  _CAN1RXDSR0.Bits.DB7
/* CAN1RXDSR_ARR: Access 8 CAN1RXDSRx registers in a array */
#define CAN1RXDSR_ARR                   ((Byte *) &CAN1RXDSR0)

#define CAN1RXDSR0_DB0_MASK             1
#define CAN1RXDSR0_DB1_MASK             2
#define CAN1RXDSR0_DB2_MASK             4
#define CAN1RXDSR0_DB3_MASK             8
#define CAN1RXDSR0_DB4_MASK             16
#define CAN1RXDSR0_DB5_MASK             32
#define CAN1RXDSR0_DB6_MASK             64
#define CAN1RXDSR0_DB7_MASK             128


/*** CAN1RXDSR1 - MSCAN 1 Receive Data Segment Register 1; 0x000001A5 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN1RXDSR1STR;
extern volatile CAN1RXDSR1STR _CAN1RXDSR1 @(REG_BASE + 0x000001A5);
#define CAN1RXDSR1                      _CAN1RXDSR1.Byte
#define CAN1RXDSR1_DB0                  _CAN1RXDSR1.Bits.DB0
#define CAN1RXDSR1_DB1                  _CAN1RXDSR1.Bits.DB1
#define CAN1RXDSR1_DB2                  _CAN1RXDSR1.Bits.DB2
#define CAN1RXDSR1_DB3                  _CAN1RXDSR1.Bits.DB3
#define CAN1RXDSR1_DB4                  _CAN1RXDSR1.Bits.DB4
#define CAN1RXDSR1_DB5                  _CAN1RXDSR1.Bits.DB5
#define CAN1RXDSR1_DB6                  _CAN1RXDSR1.Bits.DB6
#define CAN1RXDSR1_DB7                  _CAN1RXDSR1.Bits.DB7

#define CAN1RXDSR1_DB0_MASK             1
#define CAN1RXDSR1_DB1_MASK             2
#define CAN1RXDSR1_DB2_MASK             4
#define CAN1RXDSR1_DB3_MASK             8
#define CAN1RXDSR1_DB4_MASK             16
#define CAN1RXDSR1_DB5_MASK             32
#define CAN1RXDSR1_DB6_MASK             64
#define CAN1RXDSR1_DB7_MASK             128


/*** CAN1RXDSR2 - MSCAN 1 Receive Data Segment Register 2; 0x000001A6 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN1RXDSR2STR;
extern volatile CAN1RXDSR2STR _CAN1RXDSR2 @(REG_BASE + 0x000001A6);
#define CAN1RXDSR2                      _CAN1RXDSR2.Byte
#define CAN1RXDSR2_DB0                  _CAN1RXDSR2.Bits.DB0
#define CAN1RXDSR2_DB1                  _CAN1RXDSR2.Bits.DB1
#define CAN1RXDSR2_DB2                  _CAN1RXDSR2.Bits.DB2
#define CAN1RXDSR2_DB3                  _CAN1RXDSR2.Bits.DB3
#define CAN1RXDSR2_DB4                  _CAN1RXDSR2.Bits.DB4
#define CAN1RXDSR2_DB5                  _CAN1RXDSR2.Bits.DB5
#define CAN1RXDSR2_DB6                  _CAN1RXDSR2.Bits.DB6
#define CAN1RXDSR2_DB7                  _CAN1RXDSR2.Bits.DB7

#define CAN1RXDSR2_DB0_MASK             1
#define CAN1RXDSR2_DB1_MASK             2
#define CAN1RXDSR2_DB2_MASK             4
#define CAN1RXDSR2_DB3_MASK             8
#define CAN1RXDSR2_DB4_MASK             16
#define CAN1RXDSR2_DB5_MASK             32
#define CAN1RXDSR2_DB6_MASK             64
#define CAN1RXDSR2_DB7_MASK             128


/*** CAN1RXDSR3 - MSCAN 1 Receive Data Segment Register 3; 0x000001A7 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN1RXDSR3STR;
extern volatile CAN1RXDSR3STR _CAN1RXDSR3 @(REG_BASE + 0x000001A7);
#define CAN1RXDSR3                      _CAN1RXDSR3.Byte
#define CAN1RXDSR3_DB0                  _CAN1RXDSR3.Bits.DB0
#define CAN1RXDSR3_DB1                  _CAN1RXDSR3.Bits.DB1
#define CAN1RXDSR3_DB2                  _CAN1RXDSR3.Bits.DB2
#define CAN1RXDSR3_DB3                  _CAN1RXDSR3.Bits.DB3
#define CAN1RXDSR3_DB4                  _CAN1RXDSR3.Bits.DB4
#define CAN1RXDSR3_DB5                  _CAN1RXDSR3.Bits.DB5
#define CAN1RXDSR3_DB6                  _CAN1RXDSR3.Bits.DB6
#define CAN1RXDSR3_DB7                  _CAN1RXDSR3.Bits.DB7

#define CAN1RXDSR3_DB0_MASK             1
#define CAN1RXDSR3_DB1_MASK             2
#define CAN1RXDSR3_DB2_MASK             4
#define CAN1RXDSR3_DB3_MASK             8
#define CAN1RXDSR3_DB4_MASK             16
#define CAN1RXDSR3_DB5_MASK             32
#define CAN1RXDSR3_DB6_MASK             64
#define CAN1RXDSR3_DB7_MASK             128


/*** CAN1RXDSR4 - MSCAN 1 Receive Data Segment Register 4; 0x000001A8 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN1RXDSR4STR;
extern volatile CAN1RXDSR4STR _CAN1RXDSR4 @(REG_BASE + 0x000001A8);
#define CAN1RXDSR4                      _CAN1RXDSR4.Byte
#define CAN1RXDSR4_DB0                  _CAN1RXDSR4.Bits.DB0
#define CAN1RXDSR4_DB1                  _CAN1RXDSR4.Bits.DB1
#define CAN1RXDSR4_DB2                  _CAN1RXDSR4.Bits.DB2
#define CAN1RXDSR4_DB3                  _CAN1RXDSR4.Bits.DB3
#define CAN1RXDSR4_DB4                  _CAN1RXDSR4.Bits.DB4
#define CAN1RXDSR4_DB5                  _CAN1RXDSR4.Bits.DB5
#define CAN1RXDSR4_DB6                  _CAN1RXDSR4.Bits.DB6
#define CAN1RXDSR4_DB7                  _CAN1RXDSR4.Bits.DB7

#define CAN1RXDSR4_DB0_MASK             1
#define CAN1RXDSR4_DB1_MASK             2
#define CAN1RXDSR4_DB2_MASK             4
#define CAN1RXDSR4_DB3_MASK             8
#define CAN1RXDSR4_DB4_MASK             16
#define CAN1RXDSR4_DB5_MASK             32
#define CAN1RXDSR4_DB6_MASK             64
#define CAN1RXDSR4_DB7_MASK             128


/*** CAN1RXDSR5 - MSCAN 1 Receive Data Segment Register 5; 0x000001A9 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN1RXDSR5STR;
extern volatile CAN1RXDSR5STR _CAN1RXDSR5 @(REG_BASE + 0x000001A9);
#define CAN1RXDSR5                      _CAN1RXDSR5.Byte
#define CAN1RXDSR5_DB0                  _CAN1RXDSR5.Bits.DB0
#define CAN1RXDSR5_DB1                  _CAN1RXDSR5.Bits.DB1
#define CAN1RXDSR5_DB2                  _CAN1RXDSR5.Bits.DB2
#define CAN1RXDSR5_DB3                  _CAN1RXDSR5.Bits.DB3
#define CAN1RXDSR5_DB4                  _CAN1RXDSR5.Bits.DB4
#define CAN1RXDSR5_DB5                  _CAN1RXDSR5.Bits.DB5
#define CAN1RXDSR5_DB6                  _CAN1RXDSR5.Bits.DB6
#define CAN1RXDSR5_DB7                  _CAN1RXDSR5.Bits.DB7

#define CAN1RXDSR5_DB0_MASK             1
#define CAN1RXDSR5_DB1_MASK             2
#define CAN1RXDSR5_DB2_MASK             4
#define CAN1RXDSR5_DB3_MASK             8
#define CAN1RXDSR5_DB4_MASK             16
#define CAN1RXDSR5_DB5_MASK             32
#define CAN1RXDSR5_DB6_MASK             64
#define CAN1RXDSR5_DB7_MASK             128


/*** CAN1RXDSR6 - MSCAN 1 Receive Data Segment Register 6; 0x000001AA ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN1RXDSR6STR;
extern volatile CAN1RXDSR6STR _CAN1RXDSR6 @(REG_BASE + 0x000001AA);
#define CAN1RXDSR6                      _CAN1RXDSR6.Byte
#define CAN1RXDSR6_DB0                  _CAN1RXDSR6.Bits.DB0
#define CAN1RXDSR6_DB1                  _CAN1RXDSR6.Bits.DB1
#define CAN1RXDSR6_DB2                  _CAN1RXDSR6.Bits.DB2
#define CAN1RXDSR6_DB3                  _CAN1RXDSR6.Bits.DB3
#define CAN1RXDSR6_DB4                  _CAN1RXDSR6.Bits.DB4
#define CAN1RXDSR6_DB5                  _CAN1RXDSR6.Bits.DB5
#define CAN1RXDSR6_DB6                  _CAN1RXDSR6.Bits.DB6
#define CAN1RXDSR6_DB7                  _CAN1RXDSR6.Bits.DB7

#define CAN1RXDSR6_DB0_MASK             1
#define CAN1RXDSR6_DB1_MASK             2
#define CAN1RXDSR6_DB2_MASK             4
#define CAN1RXDSR6_DB3_MASK             8
#define CAN1RXDSR6_DB4_MASK             16
#define CAN1RXDSR6_DB5_MASK             32
#define CAN1RXDSR6_DB6_MASK             64
#define CAN1RXDSR6_DB7_MASK             128


/*** CAN1RXDSR7 - MSCAN 1 Receive Data Segment Register 7; 0x000001AB ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN1RXDSR7STR;
extern volatile CAN1RXDSR7STR _CAN1RXDSR7 @(REG_BASE + 0x000001AB);
#define CAN1RXDSR7                      _CAN1RXDSR7.Byte
#define CAN1RXDSR7_DB0                  _CAN1RXDSR7.Bits.DB0
#define CAN1RXDSR7_DB1                  _CAN1RXDSR7.Bits.DB1
#define CAN1RXDSR7_DB2                  _CAN1RXDSR7.Bits.DB2
#define CAN1RXDSR7_DB3                  _CAN1RXDSR7.Bits.DB3
#define CAN1RXDSR7_DB4                  _CAN1RXDSR7.Bits.DB4
#define CAN1RXDSR7_DB5                  _CAN1RXDSR7.Bits.DB5
#define CAN1RXDSR7_DB6                  _CAN1RXDSR7.Bits.DB6
#define CAN1RXDSR7_DB7                  _CAN1RXDSR7.Bits.DB7

#define CAN1RXDSR7_DB0_MASK             1
#define CAN1RXDSR7_DB1_MASK             2
#define CAN1RXDSR7_DB2_MASK             4
#define CAN1RXDSR7_DB3_MASK             8
#define CAN1RXDSR7_DB4_MASK             16
#define CAN1RXDSR7_DB5_MASK             32
#define CAN1RXDSR7_DB6_MASK             64
#define CAN1RXDSR7_DB7_MASK             128


/*** CAN1RXDLR - MSCAN 1 Receive Data Length Register; 0x000001AC ***/
typedef union {
  byte Byte;
  struct {
    byte DLC0        :1;                                       /* Data Length Code Bit 0 */
    byte DLC1        :1;                                       /* Data Length Code Bit 1 */
    byte DLC2        :1;                                       /* Data Length Code Bit 2 */
    byte DLC3        :1;                                       /* Data Length Code Bit 3 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpDLC  :4;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} CAN1RXDLRSTR;
extern volatile CAN1RXDLRSTR _CAN1RXDLR @(REG_BASE + 0x000001AC);
#define CAN1RXDLR                       _CAN1RXDLR.Byte
#define CAN1RXDLR_DLC0                  _CAN1RXDLR.Bits.DLC0
#define CAN1RXDLR_DLC1                  _CAN1RXDLR.Bits.DLC1
#define CAN1RXDLR_DLC2                  _CAN1RXDLR.Bits.DLC2
#define CAN1RXDLR_DLC3                  _CAN1RXDLR.Bits.DLC3
#define CAN1RXDLR_DLC                   _CAN1RXDLR.MergedBits.grpDLC

#define CAN1RXDLR_DLC0_MASK             1
#define CAN1RXDLR_DLC1_MASK             2
#define CAN1RXDLR_DLC2_MASK             4
#define CAN1RXDLR_DLC3_MASK             8
#define CAN1RXDLR_DLC_MASK              %BitsMask
#define CAN1RXDLR_DLC_BITNUM            %BitsNum


/*** CAN1RXTSR - MSCAN 1 Receive Time Stamp Register; 0x000001AE ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** CAN1RXTSRH - MSCAN 1 Receive Time Stamp Register High; 0x000001AE ***/
    union {
      byte Byte;
      struct {
        byte TSR8        :1;                                       /* Time Stamp Bit 8 */
        byte TSR9        :1;                                       /* Time Stamp Bit 9 */
        byte TSR10       :1;                                       /* Time Stamp Bit 10 */
        byte TSR11       :1;                                       /* Time Stamp Bit 11 */
        byte TSR12       :1;                                       /* Time Stamp Bit 12 */
        byte TSR13       :1;                                       /* Time Stamp Bit 13 */
        byte TSR14       :1;                                       /* Time Stamp Bit 14 */
        byte TSR15       :1;                                       /* Time Stamp Bit 15 */
      } Bits;
    } CAN1RXTSRHSTR;
    #define CAN1RXTSRH                  _CAN1RXTSR.Overlap_STR.CAN1RXTSRHSTR.Byte
    #define CAN1RXTSRH_TSR8             _CAN1RXTSR.Overlap_STR.CAN1RXTSRHSTR.Bits.TSR8
    #define CAN1RXTSRH_TSR9             _CAN1RXTSR.Overlap_STR.CAN1RXTSRHSTR.Bits.TSR9
    #define CAN1RXTSRH_TSR10            _CAN1RXTSR.Overlap_STR.CAN1RXTSRHSTR.Bits.TSR10
    #define CAN1RXTSRH_TSR11            _CAN1RXTSR.Overlap_STR.CAN1RXTSRHSTR.Bits.TSR11
    #define CAN1RXTSRH_TSR12            _CAN1RXTSR.Overlap_STR.CAN1RXTSRHSTR.Bits.TSR12
    #define CAN1RXTSRH_TSR13            _CAN1RXTSR.Overlap_STR.CAN1RXTSRHSTR.Bits.TSR13
    #define CAN1RXTSRH_TSR14            _CAN1RXTSR.Overlap_STR.CAN1RXTSRHSTR.Bits.TSR14
    #define CAN1RXTSRH_TSR15            _CAN1RXTSR.Overlap_STR.CAN1RXTSRHSTR.Bits.TSR15
    
    
    #define CAN1RXTSRH_TSR8_MASK        1
    #define CAN1RXTSRH_TSR9_MASK        2
    #define CAN1RXTSRH_TSR10_MASK       4
    #define CAN1RXTSRH_TSR11_MASK       8
    #define CAN1RXTSRH_TSR12_MASK       16
    #define CAN1RXTSRH_TSR13_MASK       32
    #define CAN1RXTSRH_TSR14_MASK       64
    #define CAN1RXTSRH_TSR15_MASK       128


    /*** CAN1RXTSRL - MSCAN 1 Receive Time Stamp Register Low; 0x000001AF ***/
    union {
      byte Byte;
      struct {
        byte TSR0        :1;                                       /* Time Stamp Bit 0 */
        byte TSR1        :1;                                       /* Time Stamp Bit 1 */
        byte TSR2        :1;                                       /* Time Stamp Bit 2 */
        byte TSR3        :1;                                       /* Time Stamp Bit 3 */
        byte TSR4        :1;                                       /* Time Stamp Bit 4 */
        byte TSR5        :1;                                       /* Time Stamp Bit 5 */
        byte TSR6        :1;                                       /* Time Stamp Bit 6 */
        byte TSR7        :1;                                       /* Time Stamp Bit 7 */
      } Bits;
    } CAN1RXTSRLSTR;
    #define CAN1RXTSRL                  _CAN1RXTSR.Overlap_STR.CAN1RXTSRLSTR.Byte
    #define CAN1RXTSRL_TSR0             _CAN1RXTSR.Overlap_STR.CAN1RXTSRLSTR.Bits.TSR0
    #define CAN1RXTSRL_TSR1             _CAN1RXTSR.Overlap_STR.CAN1RXTSRLSTR.Bits.TSR1
    #define CAN1RXTSRL_TSR2             _CAN1RXTSR.Overlap_STR.CAN1RXTSRLSTR.Bits.TSR2
    #define CAN1RXTSRL_TSR3             _CAN1RXTSR.Overlap_STR.CAN1RXTSRLSTR.Bits.TSR3
    #define CAN1RXTSRL_TSR4             _CAN1RXTSR.Overlap_STR.CAN1RXTSRLSTR.Bits.TSR4
    #define CAN1RXTSRL_TSR5             _CAN1RXTSR.Overlap_STR.CAN1RXTSRLSTR.Bits.TSR5
    #define CAN1RXTSRL_TSR6             _CAN1RXTSR.Overlap_STR.CAN1RXTSRLSTR.Bits.TSR6
    #define CAN1RXTSRL_TSR7             _CAN1RXTSR.Overlap_STR.CAN1RXTSRLSTR.Bits.TSR7
    
    
    #define CAN1RXTSRL_TSR0_MASK        1
    #define CAN1RXTSRL_TSR1_MASK        2
    #define CAN1RXTSRL_TSR2_MASK        4
    #define CAN1RXTSRL_TSR3_MASK        8
    #define CAN1RXTSRL_TSR4_MASK        16
    #define CAN1RXTSRL_TSR5_MASK        32
    #define CAN1RXTSRL_TSR6_MASK        64
    #define CAN1RXTSRL_TSR7_MASK        128

  } Overlap_STR;

  struct {
    word TSR0        :1;                                       /* Time Stamp Bit 0 */
    word TSR1        :1;                                       /* Time Stamp Bit 1 */
    word TSR2        :1;                                       /* Time Stamp Bit 2 */
    word TSR3        :1;                                       /* Time Stamp Bit 3 */
    word TSR4        :1;                                       /* Time Stamp Bit 4 */
    word TSR5        :1;                                       /* Time Stamp Bit 5 */
    word TSR6        :1;                                       /* Time Stamp Bit 6 */
    word TSR7        :1;                                       /* Time Stamp Bit 7 */
    word TSR8        :1;                                       /* Time Stamp Bit 8 */
    word TSR9        :1;                                       /* Time Stamp Bit 9 */
    word TSR10       :1;                                       /* Time Stamp Bit 10 */
    word TSR11       :1;                                       /* Time Stamp Bit 11 */
    word TSR12       :1;                                       /* Time Stamp Bit 12 */
    word TSR13       :1;                                       /* Time Stamp Bit 13 */
    word TSR14       :1;                                       /* Time Stamp Bit 14 */
    word TSR15       :1;                                       /* Time Stamp Bit 15 */
  } Bits;
} CAN1RXTSRSTR;
extern volatile CAN1RXTSRSTR _CAN1RXTSR @(REG_BASE + 0x000001AE);
#define CAN1RXTSR                       _CAN1RXTSR.Word
#define CAN1RXTSR_TSR0                  _CAN1RXTSR.Bits.TSR0
#define CAN1RXTSR_TSR1                  _CAN1RXTSR.Bits.TSR1
#define CAN1RXTSR_TSR2                  _CAN1RXTSR.Bits.TSR2
#define CAN1RXTSR_TSR3                  _CAN1RXTSR.Bits.TSR3
#define CAN1RXTSR_TSR4                  _CAN1RXTSR.Bits.TSR4
#define CAN1RXTSR_TSR5                  _CAN1RXTSR.Bits.TSR5
#define CAN1RXTSR_TSR6                  _CAN1RXTSR.Bits.TSR6
#define CAN1RXTSR_TSR7                  _CAN1RXTSR.Bits.TSR7
#define CAN1RXTSR_TSR8                  _CAN1RXTSR.Bits.TSR8
#define CAN1RXTSR_TSR9                  _CAN1RXTSR.Bits.TSR9
#define CAN1RXTSR_TSR10                 _CAN1RXTSR.Bits.TSR10
#define CAN1RXTSR_TSR11                 _CAN1RXTSR.Bits.TSR11
#define CAN1RXTSR_TSR12                 _CAN1RXTSR.Bits.TSR12
#define CAN1RXTSR_TSR13                 _CAN1RXTSR.Bits.TSR13
#define CAN1RXTSR_TSR14                 _CAN1RXTSR.Bits.TSR14
#define CAN1RXTSR_TSR15                 _CAN1RXTSR.Bits.TSR15

#define CAN1RXTSR_TSR0_MASK             1
#define CAN1RXTSR_TSR1_MASK             2
#define CAN1RXTSR_TSR2_MASK             4
#define CAN1RXTSR_TSR3_MASK             8
#define CAN1RXTSR_TSR4_MASK             16
#define CAN1RXTSR_TSR5_MASK             32
#define CAN1RXTSR_TSR6_MASK             64
#define CAN1RXTSR_TSR7_MASK             128
#define CAN1RXTSR_TSR8_MASK             256
#define CAN1RXTSR_TSR9_MASK             512
#define CAN1RXTSR_TSR10_MASK            1024
#define CAN1RXTSR_TSR11_MASK            2048
#define CAN1RXTSR_TSR12_MASK            4096
#define CAN1RXTSR_TSR13_MASK            8192
#define CAN1RXTSR_TSR14_MASK            16384
#define CAN1RXTSR_TSR15_MASK            32768


/*** CAN1TXIDR0 - MSCAN 1 Transmit Identifier Register 0; 0x000001B0 ***/
typedef union {
  byte Byte;
  struct {
    byte ID21        :1;                                       /* Extended format identifier Bit 21 */
    byte ID22        :1;                                       /* Extended format identifier Bit 22 */
    byte ID23        :1;                                       /* Extended format identifier Bit 23 */
    byte ID24        :1;                                       /* Extended format identifier Bit 24 */
    byte ID25        :1;                                       /* Extended format identifier Bit 25 */
    byte ID26        :1;                                       /* Extended format identifier Bit 26 */
    byte ID27        :1;                                       /* Extended format identifier Bit 27 */
    byte ID28        :1;                                       /* Extended format identifier Bit 28 */
  } Bits;
} CAN1TXIDR0STR;
extern volatile CAN1TXIDR0STR _CAN1TXIDR0 @(REG_BASE + 0x000001B0);
#define CAN1TXIDR0                      _CAN1TXIDR0.Byte
#define CAN1TXIDR0_ID21                 _CAN1TXIDR0.Bits.ID21
#define CAN1TXIDR0_ID22                 _CAN1TXIDR0.Bits.ID22
#define CAN1TXIDR0_ID23                 _CAN1TXIDR0.Bits.ID23
#define CAN1TXIDR0_ID24                 _CAN1TXIDR0.Bits.ID24
#define CAN1TXIDR0_ID25                 _CAN1TXIDR0.Bits.ID25
#define CAN1TXIDR0_ID26                 _CAN1TXIDR0.Bits.ID26
#define CAN1TXIDR0_ID27                 _CAN1TXIDR0.Bits.ID27
#define CAN1TXIDR0_ID28                 _CAN1TXIDR0.Bits.ID28
/* CAN1TXIDR_ARR: Access 4 CAN1TXIDRx registers in a array */
#define CAN1TXIDR_ARR                   ((Byte *) &CAN1TXIDR0)

#define CAN1TXIDR0_ID21_MASK            1
#define CAN1TXIDR0_ID22_MASK            2
#define CAN1TXIDR0_ID23_MASK            4
#define CAN1TXIDR0_ID24_MASK            8
#define CAN1TXIDR0_ID25_MASK            16
#define CAN1TXIDR0_ID26_MASK            32
#define CAN1TXIDR0_ID27_MASK            64
#define CAN1TXIDR0_ID28_MASK            128


/*** CAN1TXIDR1 - MSCAN 1 Transmit Identifier Register 1; 0x000001B1 ***/
typedef union {
  byte Byte;
  struct {
    byte ID15        :1;                                       /* Extended format identifier Bit 15 */
    byte ID16        :1;                                       /* Extended format identifier Bit 16 */
    byte ID17        :1;                                       /* Extended format identifier Bit 17 */
    byte IDE         :1;                                       /* ID Extended */
    byte SRR         :1;                                       /* Substitute Remote Request */
    byte ID18        :1;                                       /* Extended format identifier Bit 18 */
    byte ID19        :1;                                       /* Extended format identifier Bit 19 */
    byte ID20        :1;                                       /* Extended format identifier Bit 20 */
  } Bits;
  struct {
    byte grpID_15 :3;
    byte         :1;
    byte         :1;
    byte grpID_18 :3;
  } MergedBits;
} CAN1TXIDR1STR;
extern volatile CAN1TXIDR1STR _CAN1TXIDR1 @(REG_BASE + 0x000001B1);
#define CAN1TXIDR1                      _CAN1TXIDR1.Byte
#define CAN1TXIDR1_ID15                 _CAN1TXIDR1.Bits.ID15
#define CAN1TXIDR1_ID16                 _CAN1TXIDR1.Bits.ID16
#define CAN1TXIDR1_ID17                 _CAN1TXIDR1.Bits.ID17
#define CAN1TXIDR1_IDE                  _CAN1TXIDR1.Bits.IDE
#define CAN1TXIDR1_SRR                  _CAN1TXIDR1.Bits.SRR
#define CAN1TXIDR1_ID18                 _CAN1TXIDR1.Bits.ID18
#define CAN1TXIDR1_ID19                 _CAN1TXIDR1.Bits.ID19
#define CAN1TXIDR1_ID20                 _CAN1TXIDR1.Bits.ID20
#define CAN1TXIDR1_ID_15                _CAN1TXIDR1.MergedBits.grpID_15
#define CAN1TXIDR1_ID_18                _CAN1TXIDR1.MergedBits.grpID_18
#define CAN1TXIDR1_ID                   CAN1TXIDR1_ID_15

#define CAN1TXIDR1_ID15_MASK            1
#define CAN1TXIDR1_ID16_MASK            2
#define CAN1TXIDR1_ID17_MASK            4
#define CAN1TXIDR1_IDE_MASK             8
#define CAN1TXIDR1_SRR_MASK             16
#define CAN1TXIDR1_ID18_MASK            32
#define CAN1TXIDR1_ID19_MASK            64
#define CAN1TXIDR1_ID20_MASK            128
#define CAN1TXIDR1_ID_15_MASK           %BitsMask
#define CAN1TXIDR1_ID_15_BITNUM         %BitsNum
#define CAN1TXIDR1_ID_18_MASK           %BitsMask
#define CAN1TXIDR1_ID_18_BITNUM         %BitsNum


/*** CAN1TXIDR2 - MSCAN 1 Transmit Identifier Register 2; 0x000001B2 ***/
typedef union {
  byte Byte;
  struct {
    byte ID7         :1;                                       /* Extended format identifier Bit 7 */
    byte ID8         :1;                                       /* Extended format identifier Bit 8 */
    byte ID9         :1;                                       /* Extended format identifier Bit 9 */
    byte ID10        :1;                                       /* Extended format identifier Bit 10 */
    byte ID11        :1;                                       /* Extended format identifier Bit 11 */
    byte ID12        :1;                                       /* Extended format identifier Bit 12 */
    byte ID13        :1;                                       /* Extended format identifier Bit 13 */
    byte ID14        :1;                                       /* Extended format identifier Bit 14 */
  } Bits;
} CAN1TXIDR2STR;
extern volatile CAN1TXIDR2STR _CAN1TXIDR2 @(REG_BASE + 0x000001B2);
#define CAN1TXIDR2                      _CAN1TXIDR2.Byte
#define CAN1TXIDR2_ID7                  _CAN1TXIDR2.Bits.ID7
#define CAN1TXIDR2_ID8                  _CAN1TXIDR2.Bits.ID8
#define CAN1TXIDR2_ID9                  _CAN1TXIDR2.Bits.ID9
#define CAN1TXIDR2_ID10                 _CAN1TXIDR2.Bits.ID10
#define CAN1TXIDR2_ID11                 _CAN1TXIDR2.Bits.ID11
#define CAN1TXIDR2_ID12                 _CAN1TXIDR2.Bits.ID12
#define CAN1TXIDR2_ID13                 _CAN1TXIDR2.Bits.ID13
#define CAN1TXIDR2_ID14                 _CAN1TXIDR2.Bits.ID14

#define CAN1TXIDR2_ID7_MASK             1
#define CAN1TXIDR2_ID8_MASK             2
#define CAN1TXIDR2_ID9_MASK             4
#define CAN1TXIDR2_ID10_MASK            8
#define CAN1TXIDR2_ID11_MASK            16
#define CAN1TXIDR2_ID12_MASK            32
#define CAN1TXIDR2_ID13_MASK            64
#define CAN1TXIDR2_ID14_MASK            128


/*** CAN1TXIDR3 - MSCAN 1 Transmit Identifier Register 3; 0x000001B3 ***/
typedef union {
  byte Byte;
  struct {
    byte RTR         :1;                                       /* Remote Transmission Request */
    byte ID0         :1;                                       /* Extended format identifier Bit 0 */
    byte ID1         :1;                                       /* Extended format identifier Bit 1 */
    byte ID2         :1;                                       /* Extended format identifier Bit 2 */
    byte ID3         :1;                                       /* Extended format identifier Bit 3 */
    byte ID4         :1;                                       /* Extended format identifier Bit 4 */
    byte ID5         :1;                                       /* Extended format identifier Bit 5 */
    byte ID6         :1;                                       /* Extended format identifier Bit 6 */
  } Bits;
  struct {
    byte         :1;
    byte grpID   :7;
  } MergedBits;
} CAN1TXIDR3STR;
extern volatile CAN1TXIDR3STR _CAN1TXIDR3 @(REG_BASE + 0x000001B3);
#define CAN1TXIDR3                      _CAN1TXIDR3.Byte
#define CAN1TXIDR3_RTR                  _CAN1TXIDR3.Bits.RTR
#define CAN1TXIDR3_ID0                  _CAN1TXIDR3.Bits.ID0
#define CAN1TXIDR3_ID1                  _CAN1TXIDR3.Bits.ID1
#define CAN1TXIDR3_ID2                  _CAN1TXIDR3.Bits.ID2
#define CAN1TXIDR3_ID3                  _CAN1TXIDR3.Bits.ID3
#define CAN1TXIDR3_ID4                  _CAN1TXIDR3.Bits.ID4
#define CAN1TXIDR3_ID5                  _CAN1TXIDR3.Bits.ID5
#define CAN1TXIDR3_ID6                  _CAN1TXIDR3.Bits.ID6
#define CAN1TXIDR3_ID                   _CAN1TXIDR3.MergedBits.grpID

#define CAN1TXIDR3_RTR_MASK             1
#define CAN1TXIDR3_ID0_MASK             2
#define CAN1TXIDR3_ID1_MASK             4
#define CAN1TXIDR3_ID2_MASK             8
#define CAN1TXIDR3_ID3_MASK             16
#define CAN1TXIDR3_ID4_MASK             32
#define CAN1TXIDR3_ID5_MASK             64
#define CAN1TXIDR3_ID6_MASK             128
#define CAN1TXIDR3_ID_MASK              %BitsMask
#define CAN1TXIDR3_ID_BITNUM            %BitsNum


/*** CAN1TXDSR0 - MSCAN 1 Transmit Data Segment Register 0; 0x000001B4 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN1TXDSR0STR;
extern volatile CAN1TXDSR0STR _CAN1TXDSR0 @(REG_BASE + 0x000001B4);
#define CAN1TXDSR0                      _CAN1TXDSR0.Byte
#define CAN1TXDSR0_DB0                  _CAN1TXDSR0.Bits.DB0
#define CAN1TXDSR0_DB1                  _CAN1TXDSR0.Bits.DB1
#define CAN1TXDSR0_DB2                  _CAN1TXDSR0.Bits.DB2
#define CAN1TXDSR0_DB3                  _CAN1TXDSR0.Bits.DB3
#define CAN1TXDSR0_DB4                  _CAN1TXDSR0.Bits.DB4
#define CAN1TXDSR0_DB5                  _CAN1TXDSR0.Bits.DB5
#define CAN1TXDSR0_DB6                  _CAN1TXDSR0.Bits.DB6
#define CAN1TXDSR0_DB7                  _CAN1TXDSR0.Bits.DB7
/* CAN1TXDSR_ARR: Access 8 CAN1TXDSRx registers in a array */
#define CAN1TXDSR_ARR                   ((Byte *) &CAN1TXDSR0)

#define CAN1TXDSR0_DB0_MASK             1
#define CAN1TXDSR0_DB1_MASK             2
#define CAN1TXDSR0_DB2_MASK             4
#define CAN1TXDSR0_DB3_MASK             8
#define CAN1TXDSR0_DB4_MASK             16
#define CAN1TXDSR0_DB5_MASK             32
#define CAN1TXDSR0_DB6_MASK             64
#define CAN1TXDSR0_DB7_MASK             128


/*** CAN1TXDSR1 - MSCAN 1 Transmit Data Segment Register 1; 0x000001B5 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN1TXDSR1STR;
extern volatile CAN1TXDSR1STR _CAN1TXDSR1 @(REG_BASE + 0x000001B5);
#define CAN1TXDSR1                      _CAN1TXDSR1.Byte
#define CAN1TXDSR1_DB0                  _CAN1TXDSR1.Bits.DB0
#define CAN1TXDSR1_DB1                  _CAN1TXDSR1.Bits.DB1
#define CAN1TXDSR1_DB2                  _CAN1TXDSR1.Bits.DB2
#define CAN1TXDSR1_DB3                  _CAN1TXDSR1.Bits.DB3
#define CAN1TXDSR1_DB4                  _CAN1TXDSR1.Bits.DB4
#define CAN1TXDSR1_DB5                  _CAN1TXDSR1.Bits.DB5
#define CAN1TXDSR1_DB6                  _CAN1TXDSR1.Bits.DB6
#define CAN1TXDSR1_DB7                  _CAN1TXDSR1.Bits.DB7

#define CAN1TXDSR1_DB0_MASK             1
#define CAN1TXDSR1_DB1_MASK             2
#define CAN1TXDSR1_DB2_MASK             4
#define CAN1TXDSR1_DB3_MASK             8
#define CAN1TXDSR1_DB4_MASK             16
#define CAN1TXDSR1_DB5_MASK             32
#define CAN1TXDSR1_DB6_MASK             64
#define CAN1TXDSR1_DB7_MASK             128


/*** CAN1TXDSR2 - MSCAN 1 Transmit Data Segment Register 2; 0x000001B6 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN1TXDSR2STR;
extern volatile CAN1TXDSR2STR _CAN1TXDSR2 @(REG_BASE + 0x000001B6);
#define CAN1TXDSR2                      _CAN1TXDSR2.Byte
#define CAN1TXDSR2_DB0                  _CAN1TXDSR2.Bits.DB0
#define CAN1TXDSR2_DB1                  _CAN1TXDSR2.Bits.DB1
#define CAN1TXDSR2_DB2                  _CAN1TXDSR2.Bits.DB2
#define CAN1TXDSR2_DB3                  _CAN1TXDSR2.Bits.DB3
#define CAN1TXDSR2_DB4                  _CAN1TXDSR2.Bits.DB4
#define CAN1TXDSR2_DB5                  _CAN1TXDSR2.Bits.DB5
#define CAN1TXDSR2_DB6                  _CAN1TXDSR2.Bits.DB6
#define CAN1TXDSR2_DB7                  _CAN1TXDSR2.Bits.DB7

#define CAN1TXDSR2_DB0_MASK             1
#define CAN1TXDSR2_DB1_MASK             2
#define CAN1TXDSR2_DB2_MASK             4
#define CAN1TXDSR2_DB3_MASK             8
#define CAN1TXDSR2_DB4_MASK             16
#define CAN1TXDSR2_DB5_MASK             32
#define CAN1TXDSR2_DB6_MASK             64
#define CAN1TXDSR2_DB7_MASK             128


/*** CAN1TXDSR3 - MSCAN 1 Transmit Data Segment Register 3; 0x000001B7 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN1TXDSR3STR;
extern volatile CAN1TXDSR3STR _CAN1TXDSR3 @(REG_BASE + 0x000001B7);
#define CAN1TXDSR3                      _CAN1TXDSR3.Byte
#define CAN1TXDSR3_DB0                  _CAN1TXDSR3.Bits.DB0
#define CAN1TXDSR3_DB1                  _CAN1TXDSR3.Bits.DB1
#define CAN1TXDSR3_DB2                  _CAN1TXDSR3.Bits.DB2
#define CAN1TXDSR3_DB3                  _CAN1TXDSR3.Bits.DB3
#define CAN1TXDSR3_DB4                  _CAN1TXDSR3.Bits.DB4
#define CAN1TXDSR3_DB5                  _CAN1TXDSR3.Bits.DB5
#define CAN1TXDSR3_DB6                  _CAN1TXDSR3.Bits.DB6
#define CAN1TXDSR3_DB7                  _CAN1TXDSR3.Bits.DB7

#define CAN1TXDSR3_DB0_MASK             1
#define CAN1TXDSR3_DB1_MASK             2
#define CAN1TXDSR3_DB2_MASK             4
#define CAN1TXDSR3_DB3_MASK             8
#define CAN1TXDSR3_DB4_MASK             16
#define CAN1TXDSR3_DB5_MASK             32
#define CAN1TXDSR3_DB6_MASK             64
#define CAN1TXDSR3_DB7_MASK             128


/*** CAN1TXDSR4 - MSCAN 1 Transmit Data Segment Register 4; 0x000001B8 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN1TXDSR4STR;
extern volatile CAN1TXDSR4STR _CAN1TXDSR4 @(REG_BASE + 0x000001B8);
#define CAN1TXDSR4                      _CAN1TXDSR4.Byte
#define CAN1TXDSR4_DB0                  _CAN1TXDSR4.Bits.DB0
#define CAN1TXDSR4_DB1                  _CAN1TXDSR4.Bits.DB1
#define CAN1TXDSR4_DB2                  _CAN1TXDSR4.Bits.DB2
#define CAN1TXDSR4_DB3                  _CAN1TXDSR4.Bits.DB3
#define CAN1TXDSR4_DB4                  _CAN1TXDSR4.Bits.DB4
#define CAN1TXDSR4_DB5                  _CAN1TXDSR4.Bits.DB5
#define CAN1TXDSR4_DB6                  _CAN1TXDSR4.Bits.DB6
#define CAN1TXDSR4_DB7                  _CAN1TXDSR4.Bits.DB7

#define CAN1TXDSR4_DB0_MASK             1
#define CAN1TXDSR4_DB1_MASK             2
#define CAN1TXDSR4_DB2_MASK             4
#define CAN1TXDSR4_DB3_MASK             8
#define CAN1TXDSR4_DB4_MASK             16
#define CAN1TXDSR4_DB5_MASK             32
#define CAN1TXDSR4_DB6_MASK             64
#define CAN1TXDSR4_DB7_MASK             128


/*** CAN1TXDSR5 - MSCAN 1 Transmit Data Segment Register 5; 0x000001B9 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN1TXDSR5STR;
extern volatile CAN1TXDSR5STR _CAN1TXDSR5 @(REG_BASE + 0x000001B9);
#define CAN1TXDSR5                      _CAN1TXDSR5.Byte
#define CAN1TXDSR5_DB0                  _CAN1TXDSR5.Bits.DB0
#define CAN1TXDSR5_DB1                  _CAN1TXDSR5.Bits.DB1
#define CAN1TXDSR5_DB2                  _CAN1TXDSR5.Bits.DB2
#define CAN1TXDSR5_DB3                  _CAN1TXDSR5.Bits.DB3
#define CAN1TXDSR5_DB4                  _CAN1TXDSR5.Bits.DB4
#define CAN1TXDSR5_DB5                  _CAN1TXDSR5.Bits.DB5
#define CAN1TXDSR5_DB6                  _CAN1TXDSR5.Bits.DB6
#define CAN1TXDSR5_DB7                  _CAN1TXDSR5.Bits.DB7

#define CAN1TXDSR5_DB0_MASK             1
#define CAN1TXDSR5_DB1_MASK             2
#define CAN1TXDSR5_DB2_MASK             4
#define CAN1TXDSR5_DB3_MASK             8
#define CAN1TXDSR5_DB4_MASK             16
#define CAN1TXDSR5_DB5_MASK             32
#define CAN1TXDSR5_DB6_MASK             64
#define CAN1TXDSR5_DB7_MASK             128


/*** CAN1TXDSR6 - MSCAN 1 Transmit Data Segment Register 6; 0x000001BA ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN1TXDSR6STR;
extern volatile CAN1TXDSR6STR _CAN1TXDSR6 @(REG_BASE + 0x000001BA);
#define CAN1TXDSR6                      _CAN1TXDSR6.Byte
#define CAN1TXDSR6_DB0                  _CAN1TXDSR6.Bits.DB0
#define CAN1TXDSR6_DB1                  _CAN1TXDSR6.Bits.DB1
#define CAN1TXDSR6_DB2                  _CAN1TXDSR6.Bits.DB2
#define CAN1TXDSR6_DB3                  _CAN1TXDSR6.Bits.DB3
#define CAN1TXDSR6_DB4                  _CAN1TXDSR6.Bits.DB4
#define CAN1TXDSR6_DB5                  _CAN1TXDSR6.Bits.DB5
#define CAN1TXDSR6_DB6                  _CAN1TXDSR6.Bits.DB6
#define CAN1TXDSR6_DB7                  _CAN1TXDSR6.Bits.DB7

#define CAN1TXDSR6_DB0_MASK             1
#define CAN1TXDSR6_DB1_MASK             2
#define CAN1TXDSR6_DB2_MASK             4
#define CAN1TXDSR6_DB3_MASK             8
#define CAN1TXDSR6_DB4_MASK             16
#define CAN1TXDSR6_DB5_MASK             32
#define CAN1TXDSR6_DB6_MASK             64
#define CAN1TXDSR6_DB7_MASK             128


/*** CAN1TXDSR7 - MSCAN 1 Transmit Data Segment Register 7; 0x000001BB ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN1TXDSR7STR;
extern volatile CAN1TXDSR7STR _CAN1TXDSR7 @(REG_BASE + 0x000001BB);
#define CAN1TXDSR7                      _CAN1TXDSR7.Byte
#define CAN1TXDSR7_DB0                  _CAN1TXDSR7.Bits.DB0
#define CAN1TXDSR7_DB1                  _CAN1TXDSR7.Bits.DB1
#define CAN1TXDSR7_DB2                  _CAN1TXDSR7.Bits.DB2
#define CAN1TXDSR7_DB3                  _CAN1TXDSR7.Bits.DB3
#define CAN1TXDSR7_DB4                  _CAN1TXDSR7.Bits.DB4
#define CAN1TXDSR7_DB5                  _CAN1TXDSR7.Bits.DB5
#define CAN1TXDSR7_DB6                  _CAN1TXDSR7.Bits.DB6
#define CAN1TXDSR7_DB7                  _CAN1TXDSR7.Bits.DB7

#define CAN1TXDSR7_DB0_MASK             1
#define CAN1TXDSR7_DB1_MASK             2
#define CAN1TXDSR7_DB2_MASK             4
#define CAN1TXDSR7_DB3_MASK             8
#define CAN1TXDSR7_DB4_MASK             16
#define CAN1TXDSR7_DB5_MASK             32
#define CAN1TXDSR7_DB6_MASK             64
#define CAN1TXDSR7_DB7_MASK             128


/*** CAN1TXDLR - MSCAN 1 Transmit Data Length Register; 0x000001BC ***/
typedef union {
  byte Byte;
  struct {
    byte DLC0        :1;                                       /* Data Length Code Bit 0 */
    byte DLC1        :1;                                       /* Data Length Code Bit 1 */
    byte DLC2        :1;                                       /* Data Length Code Bit 2 */
    byte DLC3        :1;                                       /* Data Length Code Bit 3 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpDLC  :4;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} CAN1TXDLRSTR;
extern volatile CAN1TXDLRSTR _CAN1TXDLR @(REG_BASE + 0x000001BC);
#define CAN1TXDLR                       _CAN1TXDLR.Byte
#define CAN1TXDLR_DLC0                  _CAN1TXDLR.Bits.DLC0
#define CAN1TXDLR_DLC1                  _CAN1TXDLR.Bits.DLC1
#define CAN1TXDLR_DLC2                  _CAN1TXDLR.Bits.DLC2
#define CAN1TXDLR_DLC3                  _CAN1TXDLR.Bits.DLC3
#define CAN1TXDLR_DLC                   _CAN1TXDLR.MergedBits.grpDLC

#define CAN1TXDLR_DLC0_MASK             1
#define CAN1TXDLR_DLC1_MASK             2
#define CAN1TXDLR_DLC2_MASK             4
#define CAN1TXDLR_DLC3_MASK             8
#define CAN1TXDLR_DLC_MASK              %BitsMask
#define CAN1TXDLR_DLC_BITNUM            %BitsNum


/*** CAN1TXTBPR - MSCAN 1 Transmit Buffer Priority; 0x000001BD ***/
typedef union {
  byte Byte;
  struct {
    byte PRIO0       :1;                                       /* Transmit Buffer Priority Bit 0 */
    byte PRIO1       :1;                                       /* Transmit Buffer Priority Bit 1 */
    byte PRIO2       :1;                                       /* Transmit Buffer Priority Bit 2 */
    byte PRIO3       :1;                                       /* Transmit Buffer Priority Bit 3 */
    byte PRIO4       :1;                                       /* Transmit Buffer Priority Bit 4 */
    byte PRIO5       :1;                                       /* Transmit Buffer Priority Bit 5 */
    byte PRIO6       :1;                                       /* Transmit Buffer Priority Bit 6 */
    byte PRIO7       :1;                                       /* Transmit Buffer Priority Bit 7 */
  } Bits;
} CAN1TXTBPRSTR;
extern volatile CAN1TXTBPRSTR _CAN1TXTBPR @(REG_BASE + 0x000001BD);
#define CAN1TXTBPR                      _CAN1TXTBPR.Byte
#define CAN1TXTBPR_PRIO0                _CAN1TXTBPR.Bits.PRIO0
#define CAN1TXTBPR_PRIO1                _CAN1TXTBPR.Bits.PRIO1
#define CAN1TXTBPR_PRIO2                _CAN1TXTBPR.Bits.PRIO2
#define CAN1TXTBPR_PRIO3                _CAN1TXTBPR.Bits.PRIO3
#define CAN1TXTBPR_PRIO4                _CAN1TXTBPR.Bits.PRIO4
#define CAN1TXTBPR_PRIO5                _CAN1TXTBPR.Bits.PRIO5
#define CAN1TXTBPR_PRIO6                _CAN1TXTBPR.Bits.PRIO6
#define CAN1TXTBPR_PRIO7                _CAN1TXTBPR.Bits.PRIO7

#define CAN1TXTBPR_PRIO0_MASK           1
#define CAN1TXTBPR_PRIO1_MASK           2
#define CAN1TXTBPR_PRIO2_MASK           4
#define CAN1TXTBPR_PRIO3_MASK           8
#define CAN1TXTBPR_PRIO4_MASK           16
#define CAN1TXTBPR_PRIO5_MASK           32
#define CAN1TXTBPR_PRIO6_MASK           64
#define CAN1TXTBPR_PRIO7_MASK           128


/*** CAN1TXTSR - MSCAN 1 Transmit Time Stamp Register; 0x000001BE ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** CAN1TXTSRH - MSCAN 1 Transmit Time Stamp Register High; 0x000001BE ***/
    union {
      byte Byte;
      struct {
        byte TSR8        :1;                                       /* Time Stamp Bit 8 */
        byte TSR9        :1;                                       /* Time Stamp Bit 9 */
        byte TSR10       :1;                                       /* Time Stamp Bit 10 */
        byte TSR11       :1;                                       /* Time Stamp Bit 11 */
        byte TSR12       :1;                                       /* Time Stamp Bit 12 */
        byte TSR13       :1;                                       /* Time Stamp Bit 13 */
        byte TSR14       :1;                                       /* Time Stamp Bit 14 */
        byte TSR15       :1;                                       /* Time Stamp Bit 15 */
      } Bits;
    } CAN1TXTSRHSTR;
    #define CAN1TXTSRH                  _CAN1TXTSR.Overlap_STR.CAN1TXTSRHSTR.Byte
    #define CAN1TXTSRH_TSR8             _CAN1TXTSR.Overlap_STR.CAN1TXTSRHSTR.Bits.TSR8
    #define CAN1TXTSRH_TSR9             _CAN1TXTSR.Overlap_STR.CAN1TXTSRHSTR.Bits.TSR9
    #define CAN1TXTSRH_TSR10            _CAN1TXTSR.Overlap_STR.CAN1TXTSRHSTR.Bits.TSR10
    #define CAN1TXTSRH_TSR11            _CAN1TXTSR.Overlap_STR.CAN1TXTSRHSTR.Bits.TSR11
    #define CAN1TXTSRH_TSR12            _CAN1TXTSR.Overlap_STR.CAN1TXTSRHSTR.Bits.TSR12
    #define CAN1TXTSRH_TSR13            _CAN1TXTSR.Overlap_STR.CAN1TXTSRHSTR.Bits.TSR13
    #define CAN1TXTSRH_TSR14            _CAN1TXTSR.Overlap_STR.CAN1TXTSRHSTR.Bits.TSR14
    #define CAN1TXTSRH_TSR15            _CAN1TXTSR.Overlap_STR.CAN1TXTSRHSTR.Bits.TSR15
    
    
    #define CAN1TXTSRH_TSR8_MASK        1
    #define CAN1TXTSRH_TSR9_MASK        2
    #define CAN1TXTSRH_TSR10_MASK       4
    #define CAN1TXTSRH_TSR11_MASK       8
    #define CAN1TXTSRH_TSR12_MASK       16
    #define CAN1TXTSRH_TSR13_MASK       32
    #define CAN1TXTSRH_TSR14_MASK       64
    #define CAN1TXTSRH_TSR15_MASK       128


    /*** CAN1TXTSRL - MSCAN 1 Transmit Time Stamp Register Low; 0x000001BF ***/
    union {
      byte Byte;
      struct {
        byte TSR0        :1;                                       /* Time Stamp Bit 0 */
        byte TSR1        :1;                                       /* Time Stamp Bit 1 */
        byte TSR2        :1;                                       /* Time Stamp Bit 2 */
        byte TSR3        :1;                                       /* Time Stamp Bit 3 */
        byte TSR4        :1;                                       /* Time Stamp Bit 4 */
        byte TSR5        :1;                                       /* Time Stamp Bit 5 */
        byte TSR6        :1;                                       /* Time Stamp Bit 6 */
        byte TSR7        :1;                                       /* Time Stamp Bit 7 */
      } Bits;
    } CAN1TXTSRLSTR;
    #define CAN1TXTSRL                  _CAN1TXTSR.Overlap_STR.CAN1TXTSRLSTR.Byte
    #define CAN1TXTSRL_TSR0             _CAN1TXTSR.Overlap_STR.CAN1TXTSRLSTR.Bits.TSR0
    #define CAN1TXTSRL_TSR1             _CAN1TXTSR.Overlap_STR.CAN1TXTSRLSTR.Bits.TSR1
    #define CAN1TXTSRL_TSR2             _CAN1TXTSR.Overlap_STR.CAN1TXTSRLSTR.Bits.TSR2
    #define CAN1TXTSRL_TSR3             _CAN1TXTSR.Overlap_STR.CAN1TXTSRLSTR.Bits.TSR3
    #define CAN1TXTSRL_TSR4             _CAN1TXTSR.Overlap_STR.CAN1TXTSRLSTR.Bits.TSR4
    #define CAN1TXTSRL_TSR5             _CAN1TXTSR.Overlap_STR.CAN1TXTSRLSTR.Bits.TSR5
    #define CAN1TXTSRL_TSR6             _CAN1TXTSR.Overlap_STR.CAN1TXTSRLSTR.Bits.TSR6
    #define CAN1TXTSRL_TSR7             _CAN1TXTSR.Overlap_STR.CAN1TXTSRLSTR.Bits.TSR7
    
    
    #define CAN1TXTSRL_TSR0_MASK        1
    #define CAN1TXTSRL_TSR1_MASK        2
    #define CAN1TXTSRL_TSR2_MASK        4
    #define CAN1TXTSRL_TSR3_MASK        8
    #define CAN1TXTSRL_TSR4_MASK        16
    #define CAN1TXTSRL_TSR5_MASK        32
    #define CAN1TXTSRL_TSR6_MASK        64
    #define CAN1TXTSRL_TSR7_MASK        128

  } Overlap_STR;

  struct {
    word TSR0        :1;                                       /* Time Stamp Bit 0 */
    word TSR1        :1;                                       /* Time Stamp Bit 1 */
    word TSR2        :1;                                       /* Time Stamp Bit 2 */
    word TSR3        :1;                                       /* Time Stamp Bit 3 */
    word TSR4        :1;                                       /* Time Stamp Bit 4 */
    word TSR5        :1;                                       /* Time Stamp Bit 5 */
    word TSR6        :1;                                       /* Time Stamp Bit 6 */
    word TSR7        :1;                                       /* Time Stamp Bit 7 */
    word TSR8        :1;                                       /* Time Stamp Bit 8 */
    word TSR9        :1;                                       /* Time Stamp Bit 9 */
    word TSR10       :1;                                       /* Time Stamp Bit 10 */
    word TSR11       :1;                                       /* Time Stamp Bit 11 */
    word TSR12       :1;                                       /* Time Stamp Bit 12 */
    word TSR13       :1;                                       /* Time Stamp Bit 13 */
    word TSR14       :1;                                       /* Time Stamp Bit 14 */
    word TSR15       :1;                                       /* Time Stamp Bit 15 */
  } Bits;
} CAN1TXTSRSTR;
extern volatile CAN1TXTSRSTR _CAN1TXTSR @(REG_BASE + 0x000001BE);
#define CAN1TXTSR                       _CAN1TXTSR.Word
#define CAN1TXTSR_TSR0                  _CAN1TXTSR.Bits.TSR0
#define CAN1TXTSR_TSR1                  _CAN1TXTSR.Bits.TSR1
#define CAN1TXTSR_TSR2                  _CAN1TXTSR.Bits.TSR2
#define CAN1TXTSR_TSR3                  _CAN1TXTSR.Bits.TSR3
#define CAN1TXTSR_TSR4                  _CAN1TXTSR.Bits.TSR4
#define CAN1TXTSR_TSR5                  _CAN1TXTSR.Bits.TSR5
#define CAN1TXTSR_TSR6                  _CAN1TXTSR.Bits.TSR6
#define CAN1TXTSR_TSR7                  _CAN1TXTSR.Bits.TSR7
#define CAN1TXTSR_TSR8                  _CAN1TXTSR.Bits.TSR8
#define CAN1TXTSR_TSR9                  _CAN1TXTSR.Bits.TSR9
#define CAN1TXTSR_TSR10                 _CAN1TXTSR.Bits.TSR10
#define CAN1TXTSR_TSR11                 _CAN1TXTSR.Bits.TSR11
#define CAN1TXTSR_TSR12                 _CAN1TXTSR.Bits.TSR12
#define CAN1TXTSR_TSR13                 _CAN1TXTSR.Bits.TSR13
#define CAN1TXTSR_TSR14                 _CAN1TXTSR.Bits.TSR14
#define CAN1TXTSR_TSR15                 _CAN1TXTSR.Bits.TSR15

#define CAN1TXTSR_TSR0_MASK             1
#define CAN1TXTSR_TSR1_MASK             2
#define CAN1TXTSR_TSR2_MASK             4
#define CAN1TXTSR_TSR3_MASK             8
#define CAN1TXTSR_TSR4_MASK             16
#define CAN1TXTSR_TSR5_MASK             32
#define CAN1TXTSR_TSR6_MASK             64
#define CAN1TXTSR_TSR7_MASK             128
#define CAN1TXTSR_TSR8_MASK             256
#define CAN1TXTSR_TSR9_MASK             512
#define CAN1TXTSR_TSR10_MASK            1024
#define CAN1TXTSR_TSR11_MASK            2048
#define CAN1TXTSR_TSR12_MASK            4096
#define CAN1TXTSR_TSR13_MASK            8192
#define CAN1TXTSR_TSR14_MASK            16384
#define CAN1TXTSR_TSR15_MASK            32768


/*** MCCTL0 - Motor Controller Control Register 0; 0x000001C0 ***/
typedef union {
  byte Byte;
  struct {
    byte MCTOIF      :1;                                       /* Motor Controller Timer Counter Overflow Interrupt Flag */
    byte             :1; 
    byte DITH        :1;                                       /* Motor Control/Driver dither feature enable */
    byte FAST        :1;                                       /* Motor Controller PWM resolution mode */
    byte MCSWAI      :1;                                       /* Motor Controller Module Stop in WAIT Mode */
    byte MCPRE0      :1;                                       /* Motor Controller Prescaler Select Bit 0 */
    byte MCPRE1      :1;                                       /* Motor Controller Prescaler Select Bit 1 */
    byte             :1; 
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte grpMCPRE :2;
    byte         :1;
  } MergedBits;
} MCCTL0STR;
extern volatile MCCTL0STR _MCCTL0 @(REG_BASE + 0x000001C0);
#define MCCTL0                          _MCCTL0.Byte
#define MCCTL0_MCTOIF                   _MCCTL0.Bits.MCTOIF
#define MCCTL0_DITH                     _MCCTL0.Bits.DITH
#define MCCTL0_FAST                     _MCCTL0.Bits.FAST
#define MCCTL0_MCSWAI                   _MCCTL0.Bits.MCSWAI
#define MCCTL0_MCPRE0                   _MCCTL0.Bits.MCPRE0
#define MCCTL0_MCPRE1                   _MCCTL0.Bits.MCPRE1
/* MCCTL_ARR: Access 2 MCCTLx registers in a array */
#define MCCTL_ARR                       ((Byte *) &MCCTL0)
#define MCCTL0_MCPRE                    _MCCTL0.MergedBits.grpMCPRE

#define MCCTL0_MCTOIF_MASK              1
#define MCCTL0_DITH_MASK                4
#define MCCTL0_FAST_MASK                8
#define MCCTL0_MCSWAI_MASK              16
#define MCCTL0_MCPRE0_MASK              32
#define MCCTL0_MCPRE1_MASK              64
#define MCCTL0_MCPRE_MASK               %BitsMask
#define MCCTL0_MCPRE_BITNUM             %BitsNum


/*** MCCTL1 - Motor Controller Control Register 1; 0x000001C1 ***/
typedef union {
  byte Byte;
  struct {
    byte MCTOIE      :1;                                       /* Motor Controller Timer Counter Overflow Interrupt Enable */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte RECIRC      :1;                                       /* Recirculation in (Dual) Full H-bridge mode */
  } Bits;
} MCCTL1STR;
extern volatile MCCTL1STR _MCCTL1 @(REG_BASE + 0x000001C1);
#define MCCTL1                          _MCCTL1.Byte
#define MCCTL1_MCTOIE                   _MCCTL1.Bits.MCTOIE
#define MCCTL1_RECIRC                   _MCCTL1.Bits.RECIRC

#define MCCTL1_MCTOIE_MASK              1
#define MCCTL1_RECIRC_MASK              128


/*** MCPER - Motor Controller Period Register, with DITH = 0; 0x000001C2 ***/
typedef union {
  word Word;
  struct {
    word P0          :1;                                       /* Motor Controller Period Bit 0 */
    word P1          :1;                                       /* Motor Controller Period Bit 1 */
    word P2          :1;                                       /* Motor Controller Period Bit 2 */
    word P3          :1;                                       /* Motor Controller Period Bit 3 */
    word P4          :1;                                       /* Motor Controller Period Bit 4 */
    word P5          :1;                                       /* Motor Controller Period Bit 5 */
    word P6          :1;                                       /* Motor Controller Period Bit 6 */
    word P7          :1;                                       /* Motor Controller Period Bit 7 */
    word P8          :1;                                       /* Motor Controller Period Bit 8 */
    word P9          :1;                                       /* Motor Controller Period Bit 9 */
    word P10         :1;                                       /* Motor Controller Period Bit 10 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
  struct {
    word grpP    :11;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} MCPERSTR;
extern volatile MCPERSTR _MCPER @(REG_BASE + 0x000001C2);
#define MCPER                           _MCPER.Word
#define MCPER_P0                        _MCPER.Bits.P0
#define MCPER_P1                        _MCPER.Bits.P1
#define MCPER_P2                        _MCPER.Bits.P2
#define MCPER_P3                        _MCPER.Bits.P3
#define MCPER_P4                        _MCPER.Bits.P4
#define MCPER_P5                        _MCPER.Bits.P5
#define MCPER_P6                        _MCPER.Bits.P6
#define MCPER_P7                        _MCPER.Bits.P7
#define MCPER_P8                        _MCPER.Bits.P8
#define MCPER_P9                        _MCPER.Bits.P9
#define MCPER_P10                       _MCPER.Bits.P10
#define MCPER_P                         _MCPER.MergedBits.grpP

#define MCPER_P0_MASK                   1
#define MCPER_P1_MASK                   2
#define MCPER_P2_MASK                   4
#define MCPER_P3_MASK                   8
#define MCPER_P4_MASK                   16
#define MCPER_P5_MASK                   32
#define MCPER_P6_MASK                   64
#define MCPER_P7_MASK                   128
#define MCPER_P8_MASK                   256
#define MCPER_P9_MASK                   512
#define MCPER_P10_MASK                  1024
#define MCPER_P_MASK                    %BitsMask
#define MCPER_P_BITNUM                  %BitsNum


/*** MCCC0 - Motor Controller Control Register Channel 0; 0x000001D0 ***/
typedef union {
  byte Byte;
  struct {
    byte CD0         :1;                                       /* PWM Channel Delay Bit 0 */
    byte CD1         :1;                                       /* PWM Channel Delay Bit 1 */
    byte             :1; 
    byte             :1; 
    byte MCAM0       :1;                                       /* PWM Channel Alignment Mode Bit 0 */
    byte MCAM1       :1;                                       /* PWM Channel Alignment Mode Bit 1 */
    byte MCOM0       :1;                                       /* Output Mode Bit 0 */
    byte MCOM1       :1;                                       /* Output Mode Bit 1 */
  } Bits;
  struct {
    byte grpCD   :2;
    byte         :1;
    byte         :1;
    byte grpMCAM :2;
    byte grpMCOM :2;
  } MergedBits;
} MCCC0STR;
extern volatile MCCC0STR _MCCC0 @(REG_BASE + 0x000001D0);
#define MCCC0                           _MCCC0.Byte
#define MCCC0_CD0                       _MCCC0.Bits.CD0
#define MCCC0_CD1                       _MCCC0.Bits.CD1
#define MCCC0_MCAM0                     _MCCC0.Bits.MCAM0
#define MCCC0_MCAM1                     _MCCC0.Bits.MCAM1
#define MCCC0_MCOM0                     _MCCC0.Bits.MCOM0
#define MCCC0_MCOM1                     _MCCC0.Bits.MCOM1
/* MCCC_ARR: Access 12 MCCCx registers in a array */
#define MCCC_ARR                        ((Byte *) &MCCC0)
#define MCCC0_CD                        _MCCC0.MergedBits.grpCD
#define MCCC0_MCAM                      _MCCC0.MergedBits.grpMCAM
#define MCCC0_MCOM                      _MCCC0.MergedBits.grpMCOM

#define MCCC0_CD0_MASK                  1
#define MCCC0_CD1_MASK                  2
#define MCCC0_MCAM0_MASK                16
#define MCCC0_MCAM1_MASK                32
#define MCCC0_MCOM0_MASK                64
#define MCCC0_MCOM1_MASK                128
#define MCCC0_CD_MASK                   %BitsMask
#define MCCC0_CD_BITNUM                 %BitsNum
#define MCCC0_MCAM_MASK                 %BitsMask
#define MCCC0_MCAM_BITNUM               %BitsNum
#define MCCC0_MCOM_MASK                 %BitsMask
#define MCCC0_MCOM_BITNUM               %BitsNum


/*** MCCC1 - Motor Controller Control Register Channel 1; 0x000001D1 ***/
typedef union {
  byte Byte;
  struct {
    byte CD0         :1;                                       /* PWM Channel Delay Bit 0 */
    byte CD1         :1;                                       /* PWM Channel Delay Bit 1 */
    byte             :1; 
    byte             :1; 
    byte MCAM0       :1;                                       /* PWM Channel Alignment Mode Bit 0 */
    byte MCAM1       :1;                                       /* PWM Channel Alignment Mode Bit 1 */
    byte MCOM0       :1;                                       /* Output Mode Bit 0 */
    byte MCOM1       :1;                                       /* Output Mode Bit 1 */
  } Bits;
  struct {
    byte grpCD   :2;
    byte         :1;
    byte         :1;
    byte grpMCAM :2;
    byte grpMCOM :2;
  } MergedBits;
} MCCC1STR;
extern volatile MCCC1STR _MCCC1 @(REG_BASE + 0x000001D1);
#define MCCC1                           _MCCC1.Byte
#define MCCC1_CD0                       _MCCC1.Bits.CD0
#define MCCC1_CD1                       _MCCC1.Bits.CD1
#define MCCC1_MCAM0                     _MCCC1.Bits.MCAM0
#define MCCC1_MCAM1                     _MCCC1.Bits.MCAM1
#define MCCC1_MCOM0                     _MCCC1.Bits.MCOM0
#define MCCC1_MCOM1                     _MCCC1.Bits.MCOM1
#define MCCC1_CD                        _MCCC1.MergedBits.grpCD
#define MCCC1_MCAM                      _MCCC1.MergedBits.grpMCAM
#define MCCC1_MCOM                      _MCCC1.MergedBits.grpMCOM

#define MCCC1_CD0_MASK                  1
#define MCCC1_CD1_MASK                  2
#define MCCC1_MCAM0_MASK                16
#define MCCC1_MCAM1_MASK                32
#define MCCC1_MCOM0_MASK                64
#define MCCC1_MCOM1_MASK                128
#define MCCC1_CD_MASK                   %BitsMask
#define MCCC1_CD_BITNUM                 %BitsNum
#define MCCC1_MCAM_MASK                 %BitsMask
#define MCCC1_MCAM_BITNUM               %BitsNum
#define MCCC1_MCOM_MASK                 %BitsMask
#define MCCC1_MCOM_BITNUM               %BitsNum


/*** MCCC2 - Motor Controller Control Register Channel 2; 0x000001D2 ***/
typedef union {
  byte Byte;
  struct {
    byte CD0         :1;                                       /* PWM Channel Delay Bit 0 */
    byte CD1         :1;                                       /* PWM Channel Delay Bit 1 */
    byte             :1; 
    byte             :1; 
    byte MCAM0       :1;                                       /* PWM Channel Alignment Mode Bit 0 */
    byte MCAM1       :1;                                       /* PWM Channel Alignment Mode Bit 1 */
    byte MCOM0       :1;                                       /* Output Mode Bit 0 */
    byte MCOM1       :1;                                       /* Output Mode Bit 1 */
  } Bits;
  struct {
    byte grpCD   :2;
    byte         :1;
    byte         :1;
    byte grpMCAM :2;
    byte grpMCOM :2;
  } MergedBits;
} MCCC2STR;
extern volatile MCCC2STR _MCCC2 @(REG_BASE + 0x000001D2);
#define MCCC2                           _MCCC2.Byte
#define MCCC2_CD0                       _MCCC2.Bits.CD0
#define MCCC2_CD1                       _MCCC2.Bits.CD1
#define MCCC2_MCAM0                     _MCCC2.Bits.MCAM0
#define MCCC2_MCAM1                     _MCCC2.Bits.MCAM1
#define MCCC2_MCOM0                     _MCCC2.Bits.MCOM0
#define MCCC2_MCOM1                     _MCCC2.Bits.MCOM1
#define MCCC2_CD                        _MCCC2.MergedBits.grpCD
#define MCCC2_MCAM                      _MCCC2.MergedBits.grpMCAM
#define MCCC2_MCOM                      _MCCC2.MergedBits.grpMCOM

#define MCCC2_CD0_MASK                  1
#define MCCC2_CD1_MASK                  2
#define MCCC2_MCAM0_MASK                16
#define MCCC2_MCAM1_MASK                32
#define MCCC2_MCOM0_MASK                64
#define MCCC2_MCOM1_MASK                128
#define MCCC2_CD_MASK                   %BitsMask
#define MCCC2_CD_BITNUM                 %BitsNum
#define MCCC2_MCAM_MASK                 %BitsMask
#define MCCC2_MCAM_BITNUM               %BitsNum
#define MCCC2_MCOM_MASK                 %BitsMask
#define MCCC2_MCOM_BITNUM               %BitsNum


/*** MCCC3 - Motor Controller Control Register Channel 3; 0x000001D3 ***/
typedef union {
  byte Byte;
  struct {
    byte CD0         :1;                                       /* PWM Channel Delay Bit 0 */
    byte CD1         :1;                                       /* PWM Channel Delay Bit 1 */
    byte             :1; 
    byte             :1; 
    byte MCAM0       :1;                                       /* PWM Channel Alignment Mode Bit 0 */
    byte MCAM1       :1;                                       /* PWM Channel Alignment Mode Bit 1 */
    byte MCOM0       :1;                                       /* Output Mode Bit 0 */
    byte MCOM1       :1;                                       /* Output Mode Bit 1 */
  } Bits;
  struct {
    byte grpCD   :2;
    byte         :1;
    byte         :1;
    byte grpMCAM :2;
    byte grpMCOM :2;
  } MergedBits;
} MCCC3STR;
extern volatile MCCC3STR _MCCC3 @(REG_BASE + 0x000001D3);
#define MCCC3                           _MCCC3.Byte
#define MCCC3_CD0                       _MCCC3.Bits.CD0
#define MCCC3_CD1                       _MCCC3.Bits.CD1
#define MCCC3_MCAM0                     _MCCC3.Bits.MCAM0
#define MCCC3_MCAM1                     _MCCC3.Bits.MCAM1
#define MCCC3_MCOM0                     _MCCC3.Bits.MCOM0
#define MCCC3_MCOM1                     _MCCC3.Bits.MCOM1
#define MCCC3_CD                        _MCCC3.MergedBits.grpCD
#define MCCC3_MCAM                      _MCCC3.MergedBits.grpMCAM
#define MCCC3_MCOM                      _MCCC3.MergedBits.grpMCOM

#define MCCC3_CD0_MASK                  1
#define MCCC3_CD1_MASK                  2
#define MCCC3_MCAM0_MASK                16
#define MCCC3_MCAM1_MASK                32
#define MCCC3_MCOM0_MASK                64
#define MCCC3_MCOM1_MASK                128
#define MCCC3_CD_MASK                   %BitsMask
#define MCCC3_CD_BITNUM                 %BitsNum
#define MCCC3_MCAM_MASK                 %BitsMask
#define MCCC3_MCAM_BITNUM               %BitsNum
#define MCCC3_MCOM_MASK                 %BitsMask
#define MCCC3_MCOM_BITNUM               %BitsNum


/*** MCCC4 - Motor Controller Control Register Channel 4; 0x000001D4 ***/
typedef union {
  byte Byte;
  struct {
    byte CD0         :1;                                       /* PWM Channel Delay Bit 0 */
    byte CD1         :1;                                       /* PWM Channel Delay Bit 1 */
    byte             :1; 
    byte             :1; 
    byte MCAM0       :1;                                       /* PWM Channel Alignment Mode Bit 0 */
    byte MCAM1       :1;                                       /* PWM Channel Alignment Mode Bit 1 */
    byte MCOM0       :1;                                       /* Output Mode Bit 0 */
    byte MCOM1       :1;                                       /* Output Mode Bit 1 */
  } Bits;
  struct {
    byte grpCD   :2;
    byte         :1;
    byte         :1;
    byte grpMCAM :2;
    byte grpMCOM :2;
  } MergedBits;
} MCCC4STR;
extern volatile MCCC4STR _MCCC4 @(REG_BASE + 0x000001D4);
#define MCCC4                           _MCCC4.Byte
#define MCCC4_CD0                       _MCCC4.Bits.CD0
#define MCCC4_CD1                       _MCCC4.Bits.CD1
#define MCCC4_MCAM0                     _MCCC4.Bits.MCAM0
#define MCCC4_MCAM1                     _MCCC4.Bits.MCAM1
#define MCCC4_MCOM0                     _MCCC4.Bits.MCOM0
#define MCCC4_MCOM1                     _MCCC4.Bits.MCOM1
#define MCCC4_CD                        _MCCC4.MergedBits.grpCD
#define MCCC4_MCAM                      _MCCC4.MergedBits.grpMCAM
#define MCCC4_MCOM                      _MCCC4.MergedBits.grpMCOM

#define MCCC4_CD0_MASK                  1
#define MCCC4_CD1_MASK                  2
#define MCCC4_MCAM0_MASK                16
#define MCCC4_MCAM1_MASK                32
#define MCCC4_MCOM0_MASK                64
#define MCCC4_MCOM1_MASK                128
#define MCCC4_CD_MASK                   %BitsMask
#define MCCC4_CD_BITNUM                 %BitsNum
#define MCCC4_MCAM_MASK                 %BitsMask
#define MCCC4_MCAM_BITNUM               %BitsNum
#define MCCC4_MCOM_MASK                 %BitsMask
#define MCCC4_MCOM_BITNUM               %BitsNum


/*** MCCC5 - Motor Controller Control Register Channel 5; 0x000001D5 ***/
typedef union {
  byte Byte;
  struct {
    byte CD0         :1;                                       /* PWM Channel Delay Bit 0 */
    byte CD1         :1;                                       /* PWM Channel Delay Bit 1 */
    byte             :1; 
    byte             :1; 
    byte MCAM0       :1;                                       /* PWM Channel Alignment Mode Bit 0 */
    byte MCAM1       :1;                                       /* PWM Channel Alignment Mode Bit 1 */
    byte MCOM0       :1;                                       /* Output Mode Bit 0 */
    byte MCOM1       :1;                                       /* Output Mode Bit 1 */
  } Bits;
  struct {
    byte grpCD   :2;
    byte         :1;
    byte         :1;
    byte grpMCAM :2;
    byte grpMCOM :2;
  } MergedBits;
} MCCC5STR;
extern volatile MCCC5STR _MCCC5 @(REG_BASE + 0x000001D5);
#define MCCC5                           _MCCC5.Byte
#define MCCC5_CD0                       _MCCC5.Bits.CD0
#define MCCC5_CD1                       _MCCC5.Bits.CD1
#define MCCC5_MCAM0                     _MCCC5.Bits.MCAM0
#define MCCC5_MCAM1                     _MCCC5.Bits.MCAM1
#define MCCC5_MCOM0                     _MCCC5.Bits.MCOM0
#define MCCC5_MCOM1                     _MCCC5.Bits.MCOM1
#define MCCC5_CD                        _MCCC5.MergedBits.grpCD
#define MCCC5_MCAM                      _MCCC5.MergedBits.grpMCAM
#define MCCC5_MCOM                      _MCCC5.MergedBits.grpMCOM

#define MCCC5_CD0_MASK                  1
#define MCCC5_CD1_MASK                  2
#define MCCC5_MCAM0_MASK                16
#define MCCC5_MCAM1_MASK                32
#define MCCC5_MCOM0_MASK                64
#define MCCC5_MCOM1_MASK                128
#define MCCC5_CD_MASK                   %BitsMask
#define MCCC5_CD_BITNUM                 %BitsNum
#define MCCC5_MCAM_MASK                 %BitsMask
#define MCCC5_MCAM_BITNUM               %BitsNum
#define MCCC5_MCOM_MASK                 %BitsMask
#define MCCC5_MCOM_BITNUM               %BitsNum


/*** MCCC6 - Motor Controller Control Register Channel 6; 0x000001D6 ***/
typedef union {
  byte Byte;
  struct {
    byte CD0         :1;                                       /* PWM Channel Delay Bit 0 */
    byte CD1         :1;                                       /* PWM Channel Delay Bit 1 */
    byte             :1; 
    byte             :1; 
    byte MCAM0       :1;                                       /* PWM Channel Alignment Mode Bit 0 */
    byte MCAM1       :1;                                       /* PWM Channel Alignment Mode Bit 1 */
    byte MCOM0       :1;                                       /* Output Mode Bit 0 */
    byte MCOM1       :1;                                       /* Output Mode Bit 1 */
  } Bits;
  struct {
    byte grpCD   :2;
    byte         :1;
    byte         :1;
    byte grpMCAM :2;
    byte grpMCOM :2;
  } MergedBits;
} MCCC6STR;
extern volatile MCCC6STR _MCCC6 @(REG_BASE + 0x000001D6);
#define MCCC6                           _MCCC6.Byte
#define MCCC6_CD0                       _MCCC6.Bits.CD0
#define MCCC6_CD1                       _MCCC6.Bits.CD1
#define MCCC6_MCAM0                     _MCCC6.Bits.MCAM0
#define MCCC6_MCAM1                     _MCCC6.Bits.MCAM1
#define MCCC6_MCOM0                     _MCCC6.Bits.MCOM0
#define MCCC6_MCOM1                     _MCCC6.Bits.MCOM1
#define MCCC6_CD                        _MCCC6.MergedBits.grpCD
#define MCCC6_MCAM                      _MCCC6.MergedBits.grpMCAM
#define MCCC6_MCOM                      _MCCC6.MergedBits.grpMCOM

#define MCCC6_CD0_MASK                  1
#define MCCC6_CD1_MASK                  2
#define MCCC6_MCAM0_MASK                16
#define MCCC6_MCAM1_MASK                32
#define MCCC6_MCOM0_MASK                64
#define MCCC6_MCOM1_MASK                128
#define MCCC6_CD_MASK                   %BitsMask
#define MCCC6_CD_BITNUM                 %BitsNum
#define MCCC6_MCAM_MASK                 %BitsMask
#define MCCC6_MCAM_BITNUM               %BitsNum
#define MCCC6_MCOM_MASK                 %BitsMask
#define MCCC6_MCOM_BITNUM               %BitsNum


/*** MCCC7 - Motor Controller Control Register Channel 7; 0x000001D7 ***/
typedef union {
  byte Byte;
  struct {
    byte CD0         :1;                                       /* PWM Channel Delay Bit 0 */
    byte CD1         :1;                                       /* PWM Channel Delay Bit 1 */
    byte             :1; 
    byte             :1; 
    byte MCAM0       :1;                                       /* PWM Channel Alignment Mode Bit 0 */
    byte MCAM1       :1;                                       /* PWM Channel Alignment Mode Bit 1 */
    byte MCOM0       :1;                                       /* Output Mode Bit 0 */
    byte MCOM1       :1;                                       /* Output Mode Bit 1 */
  } Bits;
  struct {
    byte grpCD   :2;
    byte         :1;
    byte         :1;
    byte grpMCAM :2;
    byte grpMCOM :2;
  } MergedBits;
} MCCC7STR;
extern volatile MCCC7STR _MCCC7 @(REG_BASE + 0x000001D7);
#define MCCC7                           _MCCC7.Byte
#define MCCC7_CD0                       _MCCC7.Bits.CD0
#define MCCC7_CD1                       _MCCC7.Bits.CD1
#define MCCC7_MCAM0                     _MCCC7.Bits.MCAM0
#define MCCC7_MCAM1                     _MCCC7.Bits.MCAM1
#define MCCC7_MCOM0                     _MCCC7.Bits.MCOM0
#define MCCC7_MCOM1                     _MCCC7.Bits.MCOM1
#define MCCC7_CD                        _MCCC7.MergedBits.grpCD
#define MCCC7_MCAM                      _MCCC7.MergedBits.grpMCAM
#define MCCC7_MCOM                      _MCCC7.MergedBits.grpMCOM

#define MCCC7_CD0_MASK                  1
#define MCCC7_CD1_MASK                  2
#define MCCC7_MCAM0_MASK                16
#define MCCC7_MCAM1_MASK                32
#define MCCC7_MCOM0_MASK                64
#define MCCC7_MCOM1_MASK                128
#define MCCC7_CD_MASK                   %BitsMask
#define MCCC7_CD_BITNUM                 %BitsNum
#define MCCC7_MCAM_MASK                 %BitsMask
#define MCCC7_MCAM_BITNUM               %BitsNum
#define MCCC7_MCOM_MASK                 %BitsMask
#define MCCC7_MCOM_BITNUM               %BitsNum


/*** MCCC8 - Motor Controller Control Register Channel 8; 0x000001D8 ***/
typedef union {
  byte Byte;
  struct {
    byte CD0         :1;                                       /* PWM Channel Delay Bit 0 */
    byte CD1         :1;                                       /* PWM Channel Delay Bit 1 */
    byte             :1; 
    byte             :1; 
    byte MCAM0       :1;                                       /* PWM Channel Alignment Mode Bit 0 */
    byte MCAM1       :1;                                       /* PWM Channel Alignment Mode Bit 1 */
    byte MCOM0       :1;                                       /* Output Mode Bit 0 */
    byte MCOM1       :1;                                       /* Output Mode Bit 1 */
  } Bits;
  struct {
    byte grpCD   :2;
    byte         :1;
    byte         :1;
    byte grpMCAM :2;
    byte grpMCOM :2;
  } MergedBits;
} MCCC8STR;
extern volatile MCCC8STR _MCCC8 @(REG_BASE + 0x000001D8);
#define MCCC8                           _MCCC8.Byte
#define MCCC8_CD0                       _MCCC8.Bits.CD0
#define MCCC8_CD1                       _MCCC8.Bits.CD1
#define MCCC8_MCAM0                     _MCCC8.Bits.MCAM0
#define MCCC8_MCAM1                     _MCCC8.Bits.MCAM1
#define MCCC8_MCOM0                     _MCCC8.Bits.MCOM0
#define MCCC8_MCOM1                     _MCCC8.Bits.MCOM1
#define MCCC8_CD                        _MCCC8.MergedBits.grpCD
#define MCCC8_MCAM                      _MCCC8.MergedBits.grpMCAM
#define MCCC8_MCOM                      _MCCC8.MergedBits.grpMCOM

#define MCCC8_CD0_MASK                  1
#define MCCC8_CD1_MASK                  2
#define MCCC8_MCAM0_MASK                16
#define MCCC8_MCAM1_MASK                32
#define MCCC8_MCOM0_MASK                64
#define MCCC8_MCOM1_MASK                128
#define MCCC8_CD_MASK                   %BitsMask
#define MCCC8_CD_BITNUM                 %BitsNum
#define MCCC8_MCAM_MASK                 %BitsMask
#define MCCC8_MCAM_BITNUM               %BitsNum
#define MCCC8_MCOM_MASK                 %BitsMask
#define MCCC8_MCOM_BITNUM               %BitsNum


/*** MCCC9 - Motor Controller Control Register Channel 9; 0x000001D9 ***/
typedef union {
  byte Byte;
  struct {
    byte CD0         :1;                                       /* PWM Channel Delay Bit 0 */
    byte CD1         :1;                                       /* PWM Channel Delay Bit 1 */
    byte             :1; 
    byte             :1; 
    byte MCAM0       :1;                                       /* PWM Channel Alignment Mode Bit 0 */
    byte MCAM1       :1;                                       /* PWM Channel Alignment Mode Bit 1 */
    byte MCOM0       :1;                                       /* Output Mode Bit 0 */
    byte MCOM1       :1;                                       /* Output Mode Bit 1 */
  } Bits;
  struct {
    byte grpCD   :2;
    byte         :1;
    byte         :1;
    byte grpMCAM :2;
    byte grpMCOM :2;
  } MergedBits;
} MCCC9STR;
extern volatile MCCC9STR _MCCC9 @(REG_BASE + 0x000001D9);
#define MCCC9                           _MCCC9.Byte
#define MCCC9_CD0                       _MCCC9.Bits.CD0
#define MCCC9_CD1                       _MCCC9.Bits.CD1
#define MCCC9_MCAM0                     _MCCC9.Bits.MCAM0
#define MCCC9_MCAM1                     _MCCC9.Bits.MCAM1
#define MCCC9_MCOM0                     _MCCC9.Bits.MCOM0
#define MCCC9_MCOM1                     _MCCC9.Bits.MCOM1
#define MCCC9_CD                        _MCCC9.MergedBits.grpCD
#define MCCC9_MCAM                      _MCCC9.MergedBits.grpMCAM
#define MCCC9_MCOM                      _MCCC9.MergedBits.grpMCOM

#define MCCC9_CD0_MASK                  1
#define MCCC9_CD1_MASK                  2
#define MCCC9_MCAM0_MASK                16
#define MCCC9_MCAM1_MASK                32
#define MCCC9_MCOM0_MASK                64
#define MCCC9_MCOM1_MASK                128
#define MCCC9_CD_MASK                   %BitsMask
#define MCCC9_CD_BITNUM                 %BitsNum
#define MCCC9_MCAM_MASK                 %BitsMask
#define MCCC9_MCAM_BITNUM               %BitsNum
#define MCCC9_MCOM_MASK                 %BitsMask
#define MCCC9_MCOM_BITNUM               %BitsNum


/*** MCCC10 - Motor Controller Control Register Channel 10; 0x000001DA ***/
typedef union {
  byte Byte;
  struct {
    byte CD0         :1;                                       /* PWM Channel Delay Bit 0 */
    byte CD1         :1;                                       /* PWM Channel Delay Bit 1 */
    byte             :1; 
    byte             :1; 
    byte MCAM0       :1;                                       /* PWM Channel Alignment Mode Bit 0 */
    byte MCAM1       :1;                                       /* PWM Channel Alignment Mode Bit 1 */
    byte MCOM0       :1;                                       /* Output Mode Bit 0 */
    byte MCOM1       :1;                                       /* Output Mode Bit 1 */
  } Bits;
  struct {
    byte grpCD   :2;
    byte         :1;
    byte         :1;
    byte grpMCAM :2;
    byte grpMCOM :2;
  } MergedBits;
} MCCC10STR;
extern volatile MCCC10STR _MCCC10 @(REG_BASE + 0x000001DA);
#define MCCC10                          _MCCC10.Byte
#define MCCC10_CD0                      _MCCC10.Bits.CD0
#define MCCC10_CD1                      _MCCC10.Bits.CD1
#define MCCC10_MCAM0                    _MCCC10.Bits.MCAM0
#define MCCC10_MCAM1                    _MCCC10.Bits.MCAM1
#define MCCC10_MCOM0                    _MCCC10.Bits.MCOM0
#define MCCC10_MCOM1                    _MCCC10.Bits.MCOM1
#define MCCC10_CD                       _MCCC10.MergedBits.grpCD
#define MCCC10_MCAM                     _MCCC10.MergedBits.grpMCAM
#define MCCC10_MCOM                     _MCCC10.MergedBits.grpMCOM

#define MCCC10_CD0_MASK                 1
#define MCCC10_CD1_MASK                 2
#define MCCC10_MCAM0_MASK               16
#define MCCC10_MCAM1_MASK               32
#define MCCC10_MCOM0_MASK               64
#define MCCC10_MCOM1_MASK               128
#define MCCC10_CD_MASK                  %BitsMask
#define MCCC10_CD_BITNUM                %BitsNum
#define MCCC10_MCAM_MASK                %BitsMask
#define MCCC10_MCAM_BITNUM              %BitsNum
#define MCCC10_MCOM_MASK                %BitsMask
#define MCCC10_MCOM_BITNUM              %BitsNum


/*** MCCC11 - Motor Controller Control Register Channel 11; 0x000001DB ***/
typedef union {
  byte Byte;
  struct {
    byte CD0         :1;                                       /* PWM Channel Delay Bit 0 */
    byte CD1         :1;                                       /* PWM Channel Delay Bit 1 */
    byte             :1; 
    byte             :1; 
    byte MCAM0       :1;                                       /* PWM Channel Alignment Mode Bit 0 */
    byte MCAM1       :1;                                       /* PWM Channel Alignment Mode Bit 1 */
    byte MCOM0       :1;                                       /* Output Mode Bit 0 */
    byte MCOM1       :1;                                       /* Output Mode Bit 1 */
  } Bits;
  struct {
    byte grpCD   :2;
    byte         :1;
    byte         :1;
    byte grpMCAM :2;
    byte grpMCOM :2;
  } MergedBits;
} MCCC11STR;
extern volatile MCCC11STR _MCCC11 @(REG_BASE + 0x000001DB);
#define MCCC11                          _MCCC11.Byte
#define MCCC11_CD0                      _MCCC11.Bits.CD0
#define MCCC11_CD1                      _MCCC11.Bits.CD1
#define MCCC11_MCAM0                    _MCCC11.Bits.MCAM0
#define MCCC11_MCAM1                    _MCCC11.Bits.MCAM1
#define MCCC11_MCOM0                    _MCCC11.Bits.MCOM0
#define MCCC11_MCOM1                    _MCCC11.Bits.MCOM1
#define MCCC11_CD                       _MCCC11.MergedBits.grpCD
#define MCCC11_MCAM                     _MCCC11.MergedBits.grpMCAM
#define MCCC11_MCOM                     _MCCC11.MergedBits.grpMCOM

#define MCCC11_CD0_MASK                 1
#define MCCC11_CD1_MASK                 2
#define MCCC11_MCAM0_MASK               16
#define MCCC11_MCAM1_MASK               32
#define MCCC11_MCOM0_MASK               64
#define MCCC11_MCOM1_MASK               128
#define MCCC11_CD_MASK                  %BitsMask
#define MCCC11_CD_BITNUM                %BitsNum
#define MCCC11_MCAM_MASK                %BitsMask
#define MCCC11_MCAM_BITNUM              %BitsNum
#define MCCC11_MCOM_MASK                %BitsMask
#define MCCC11_MCOM_BITNUM              %BitsNum


/*** MCDC0 - Motor Controller Duty Cycle Register 0; 0x000001E0 ***/
typedef union {
  word Word;
  struct {
    word D0          :1;                                       /* Motor Controller Duty Cycle Bit 0 */
    word D1          :1;                                       /* Motor Controller Duty Cycle Bit 1 */
    word D2          :1;                                       /* Motor Controller Duty Cycle Bit 2 */
    word D3          :1;                                       /* Motor Controller Duty Cycle Bit 3 */
    word D4          :1;                                       /* Motor Controller Duty Cycle Bit 4 */
    word D5          :1;                                       /* Motor Controller Duty Cycle Bit 5 */
    word D6          :1;                                       /* Motor Controller Duty Cycle Bit 6 */
    word D7          :1;                                       /* Motor Controller Duty Cycle Bit 7 */
    word D8          :1;                                       /* Motor Controller Duty Cycle Bit 8 */
    word D9          :1;                                       /* Motor Controller Duty Cycle Bit 9 */
    word D10         :1;                                       /* Motor Controller Duty Cycle Bit 10 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word S           :1;                                       /* Sign */
  } Bits;
  struct {
    word grpD    :11;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} MCDC0STR;
extern volatile MCDC0STR _MCDC0 @(REG_BASE + 0x000001E0);
#define MCDC0                           _MCDC0.Word
#define MCDC0_D0                        _MCDC0.Bits.D0
#define MCDC0_D1                        _MCDC0.Bits.D1
#define MCDC0_D2                        _MCDC0.Bits.D2
#define MCDC0_D3                        _MCDC0.Bits.D3
#define MCDC0_D4                        _MCDC0.Bits.D4
#define MCDC0_D5                        _MCDC0.Bits.D5
#define MCDC0_D6                        _MCDC0.Bits.D6
#define MCDC0_D7                        _MCDC0.Bits.D7
#define MCDC0_D8                        _MCDC0.Bits.D8
#define MCDC0_D9                        _MCDC0.Bits.D9
#define MCDC0_D10                       _MCDC0.Bits.D10
#define MCDC0_S                         _MCDC0.Bits.S
/* MCDC_ARR: Access 12 MCDCx registers in a array */
#define MCDC_ARR                        ((Word *) &MCDC0)
#define MCDC0_D                         _MCDC0.MergedBits.grpD

#define MCDC0_D0_MASK                   1
#define MCDC0_D1_MASK                   2
#define MCDC0_D2_MASK                   4
#define MCDC0_D3_MASK                   8
#define MCDC0_D4_MASK                   16
#define MCDC0_D5_MASK                   32
#define MCDC0_D6_MASK                   64
#define MCDC0_D7_MASK                   128
#define MCDC0_D8_MASK                   256
#define MCDC0_D9_MASK                   512
#define MCDC0_D10_MASK                  1024
#define MCDC0_S_MASK                    32768
#define MCDC0_D_MASK                    %BitsMask
#define MCDC0_D_BITNUM                  %BitsNum


/*** MCDC1 - Motor Controller Duty Cycle Register 1; 0x000001E2 ***/
typedef union {
  word Word;
  struct {
    word D0          :1;                                       /* Motor Controller Duty Cycle Bit 0 */
    word D1          :1;                                       /* Motor Controller Duty Cycle Bit 1 */
    word D2          :1;                                       /* Motor Controller Duty Cycle Bit 2 */
    word D3          :1;                                       /* Motor Controller Duty Cycle Bit 3 */
    word D4          :1;                                       /* Motor Controller Duty Cycle Bit 4 */
    word D5          :1;                                       /* Motor Controller Duty Cycle Bit 5 */
    word D6          :1;                                       /* Motor Controller Duty Cycle Bit 6 */
    word D7          :1;                                       /* Motor Controller Duty Cycle Bit 7 */
    word D8          :1;                                       /* Motor Controller Duty Cycle Bit 8 */
    word D9          :1;                                       /* Motor Controller Duty Cycle Bit 9 */
    word D10         :1;                                       /* Motor Controller Duty Cycle Bit 10 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word S           :1;                                       /* Sign */
  } Bits;
  struct {
    word grpD    :11;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} MCDC1STR;
extern volatile MCDC1STR _MCDC1 @(REG_BASE + 0x000001E2);
#define MCDC1                           _MCDC1.Word
#define MCDC1_D0                        _MCDC1.Bits.D0
#define MCDC1_D1                        _MCDC1.Bits.D1
#define MCDC1_D2                        _MCDC1.Bits.D2
#define MCDC1_D3                        _MCDC1.Bits.D3
#define MCDC1_D4                        _MCDC1.Bits.D4
#define MCDC1_D5                        _MCDC1.Bits.D5
#define MCDC1_D6                        _MCDC1.Bits.D6
#define MCDC1_D7                        _MCDC1.Bits.D7
#define MCDC1_D8                        _MCDC1.Bits.D8
#define MCDC1_D9                        _MCDC1.Bits.D9
#define MCDC1_D10                       _MCDC1.Bits.D10
#define MCDC1_S                         _MCDC1.Bits.S
#define MCDC1_D                         _MCDC1.MergedBits.grpD

#define MCDC1_D0_MASK                   1
#define MCDC1_D1_MASK                   2
#define MCDC1_D2_MASK                   4
#define MCDC1_D3_MASK                   8
#define MCDC1_D4_MASK                   16
#define MCDC1_D5_MASK                   32
#define MCDC1_D6_MASK                   64
#define MCDC1_D7_MASK                   128
#define MCDC1_D8_MASK                   256
#define MCDC1_D9_MASK                   512
#define MCDC1_D10_MASK                  1024
#define MCDC1_S_MASK                    32768
#define MCDC1_D_MASK                    %BitsMask
#define MCDC1_D_BITNUM                  %BitsNum


/*** MCDC2 - Motor Controller Duty Cycle Register 2; 0x000001E4 ***/
typedef union {
  word Word;
  struct {
    word D0          :1;                                       /* Motor Controller Duty Cycle Bit 0 */
    word D1          :1;                                       /* Motor Controller Duty Cycle Bit 1 */
    word D2          :1;                                       /* Motor Controller Duty Cycle Bit 2 */
    word D3          :1;                                       /* Motor Controller Duty Cycle Bit 3 */
    word D4          :1;                                       /* Motor Controller Duty Cycle Bit 4 */
    word D5          :1;                                       /* Motor Controller Duty Cycle Bit 5 */
    word D6          :1;                                       /* Motor Controller Duty Cycle Bit 6 */
    word D7          :1;                                       /* Motor Controller Duty Cycle Bit 7 */
    word D8          :1;                                       /* Motor Controller Duty Cycle Bit 8 */
    word D9          :1;                                       /* Motor Controller Duty Cycle Bit 9 */
    word D10         :1;                                       /* Motor Controller Duty Cycle Bit 10 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word S           :1;                                       /* Sign */
  } Bits;
  struct {
    word grpD    :11;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} MCDC2STR;
extern volatile MCDC2STR _MCDC2 @(REG_BASE + 0x000001E4);
#define MCDC2                           _MCDC2.Word
#define MCDC2_D0                        _MCDC2.Bits.D0
#define MCDC2_D1                        _MCDC2.Bits.D1
#define MCDC2_D2                        _MCDC2.Bits.D2
#define MCDC2_D3                        _MCDC2.Bits.D3
#define MCDC2_D4                        _MCDC2.Bits.D4
#define MCDC2_D5                        _MCDC2.Bits.D5
#define MCDC2_D6                        _MCDC2.Bits.D6
#define MCDC2_D7                        _MCDC2.Bits.D7
#define MCDC2_D8                        _MCDC2.Bits.D8
#define MCDC2_D9                        _MCDC2.Bits.D9
#define MCDC2_D10                       _MCDC2.Bits.D10
#define MCDC2_S                         _MCDC2.Bits.S
#define MCDC2_D                         _MCDC2.MergedBits.grpD

#define MCDC2_D0_MASK                   1
#define MCDC2_D1_MASK                   2
#define MCDC2_D2_MASK                   4
#define MCDC2_D3_MASK                   8
#define MCDC2_D4_MASK                   16
#define MCDC2_D5_MASK                   32
#define MCDC2_D6_MASK                   64
#define MCDC2_D7_MASK                   128
#define MCDC2_D8_MASK                   256
#define MCDC2_D9_MASK                   512
#define MCDC2_D10_MASK                  1024
#define MCDC2_S_MASK                    32768
#define MCDC2_D_MASK                    %BitsMask
#define MCDC2_D_BITNUM                  %BitsNum


/*** MCDC3 - Motor Controller Duty Cycle Register 3; 0x000001E6 ***/
typedef union {
  word Word;
  struct {
    word D0          :1;                                       /* Motor Controller Duty Cycle Bit 0 */
    word D1          :1;                                       /* Motor Controller Duty Cycle Bit 1 */
    word D2          :1;                                       /* Motor Controller Duty Cycle Bit 2 */
    word D3          :1;                                       /* Motor Controller Duty Cycle Bit 3 */
    word D4          :1;                                       /* Motor Controller Duty Cycle Bit 4 */
    word D5          :1;                                       /* Motor Controller Duty Cycle Bit 5 */
    word D6          :1;                                       /* Motor Controller Duty Cycle Bit 6 */
    word D7          :1;                                       /* Motor Controller Duty Cycle Bit 7 */
    word D8          :1;                                       /* Motor Controller Duty Cycle Bit 8 */
    word D9          :1;                                       /* Motor Controller Duty Cycle Bit 9 */
    word D10         :1;                                       /* Motor Controller Duty Cycle Bit 10 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word S           :1;                                       /* Sign */
  } Bits;
  struct {
    word grpD    :11;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} MCDC3STR;
extern volatile MCDC3STR _MCDC3 @(REG_BASE + 0x000001E6);
#define MCDC3                           _MCDC3.Word
#define MCDC3_D0                        _MCDC3.Bits.D0
#define MCDC3_D1                        _MCDC3.Bits.D1
#define MCDC3_D2                        _MCDC3.Bits.D2
#define MCDC3_D3                        _MCDC3.Bits.D3
#define MCDC3_D4                        _MCDC3.Bits.D4
#define MCDC3_D5                        _MCDC3.Bits.D5
#define MCDC3_D6                        _MCDC3.Bits.D6
#define MCDC3_D7                        _MCDC3.Bits.D7
#define MCDC3_D8                        _MCDC3.Bits.D8
#define MCDC3_D9                        _MCDC3.Bits.D9
#define MCDC3_D10                       _MCDC3.Bits.D10
#define MCDC3_S                         _MCDC3.Bits.S
#define MCDC3_D                         _MCDC3.MergedBits.grpD

#define MCDC3_D0_MASK                   1
#define MCDC3_D1_MASK                   2
#define MCDC3_D2_MASK                   4
#define MCDC3_D3_MASK                   8
#define MCDC3_D4_MASK                   16
#define MCDC3_D5_MASK                   32
#define MCDC3_D6_MASK                   64
#define MCDC3_D7_MASK                   128
#define MCDC3_D8_MASK                   256
#define MCDC3_D9_MASK                   512
#define MCDC3_D10_MASK                  1024
#define MCDC3_S_MASK                    32768
#define MCDC3_D_MASK                    %BitsMask
#define MCDC3_D_BITNUM                  %BitsNum


/*** MCDC4 - Motor Controller Duty Cycle Register 4; 0x000001E8 ***/
typedef union {
  word Word;
  struct {
    word D0          :1;                                       /* Motor Controller Duty Cycle Bit 0 */
    word D1          :1;                                       /* Motor Controller Duty Cycle Bit 1 */
    word D2          :1;                                       /* Motor Controller Duty Cycle Bit 2 */
    word D3          :1;                                       /* Motor Controller Duty Cycle Bit 3 */
    word D4          :1;                                       /* Motor Controller Duty Cycle Bit 4 */
    word D5          :1;                                       /* Motor Controller Duty Cycle Bit 5 */
    word D6          :1;                                       /* Motor Controller Duty Cycle Bit 6 */
    word D7          :1;                                       /* Motor Controller Duty Cycle Bit 7 */
    word D8          :1;                                       /* Motor Controller Duty Cycle Bit 8 */
    word D9          :1;                                       /* Motor Controller Duty Cycle Bit 9 */
    word D10         :1;                                       /* Motor Controller Duty Cycle Bit 10 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word S           :1;                                       /* Sign */
  } Bits;
  struct {
    word grpD    :11;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} MCDC4STR;
extern volatile MCDC4STR _MCDC4 @(REG_BASE + 0x000001E8);
#define MCDC4                           _MCDC4.Word
#define MCDC4_D0                        _MCDC4.Bits.D0
#define MCDC4_D1                        _MCDC4.Bits.D1
#define MCDC4_D2                        _MCDC4.Bits.D2
#define MCDC4_D3                        _MCDC4.Bits.D3
#define MCDC4_D4                        _MCDC4.Bits.D4
#define MCDC4_D5                        _MCDC4.Bits.D5
#define MCDC4_D6                        _MCDC4.Bits.D6
#define MCDC4_D7                        _MCDC4.Bits.D7
#define MCDC4_D8                        _MCDC4.Bits.D8
#define MCDC4_D9                        _MCDC4.Bits.D9
#define MCDC4_D10                       _MCDC4.Bits.D10
#define MCDC4_S                         _MCDC4.Bits.S
#define MCDC4_D                         _MCDC4.MergedBits.grpD

#define MCDC4_D0_MASK                   1
#define MCDC4_D1_MASK                   2
#define MCDC4_D2_MASK                   4
#define MCDC4_D3_MASK                   8
#define MCDC4_D4_MASK                   16
#define MCDC4_D5_MASK                   32
#define MCDC4_D6_MASK                   64
#define MCDC4_D7_MASK                   128
#define MCDC4_D8_MASK                   256
#define MCDC4_D9_MASK                   512
#define MCDC4_D10_MASK                  1024
#define MCDC4_S_MASK                    32768
#define MCDC4_D_MASK                    %BitsMask
#define MCDC4_D_BITNUM                  %BitsNum


/*** MCDC5 - Motor Controller Duty Cycle Register 5; 0x000001EA ***/
typedef union {
  word Word;
  struct {
    word D0          :1;                                       /* Motor Controller Duty Cycle Bit 0 */
    word D1          :1;                                       /* Motor Controller Duty Cycle Bit 1 */
    word D2          :1;                                       /* Motor Controller Duty Cycle Bit 2 */
    word D3          :1;                                       /* Motor Controller Duty Cycle Bit 3 */
    word D4          :1;                                       /* Motor Controller Duty Cycle Bit 4 */
    word D5          :1;                                       /* Motor Controller Duty Cycle Bit 5 */
    word D6          :1;                                       /* Motor Controller Duty Cycle Bit 6 */
    word D7          :1;                                       /* Motor Controller Duty Cycle Bit 7 */
    word D8          :1;                                       /* Motor Controller Duty Cycle Bit 8 */
    word D9          :1;                                       /* Motor Controller Duty Cycle Bit 9 */
    word D10         :1;                                       /* Motor Controller Duty Cycle Bit 10 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word S           :1;                                       /* Sign */
  } Bits;
  struct {
    word grpD    :11;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} MCDC5STR;
extern volatile MCDC5STR _MCDC5 @(REG_BASE + 0x000001EA);
#define MCDC5                           _MCDC5.Word
#define MCDC5_D0                        _MCDC5.Bits.D0
#define MCDC5_D1                        _MCDC5.Bits.D1
#define MCDC5_D2                        _MCDC5.Bits.D2
#define MCDC5_D3                        _MCDC5.Bits.D3
#define MCDC5_D4                        _MCDC5.Bits.D4
#define MCDC5_D5                        _MCDC5.Bits.D5
#define MCDC5_D6                        _MCDC5.Bits.D6
#define MCDC5_D7                        _MCDC5.Bits.D7
#define MCDC5_D8                        _MCDC5.Bits.D8
#define MCDC5_D9                        _MCDC5.Bits.D9
#define MCDC5_D10                       _MCDC5.Bits.D10
#define MCDC5_S                         _MCDC5.Bits.S
#define MCDC5_D                         _MCDC5.MergedBits.grpD

#define MCDC5_D0_MASK                   1
#define MCDC5_D1_MASK                   2
#define MCDC5_D2_MASK                   4
#define MCDC5_D3_MASK                   8
#define MCDC5_D4_MASK                   16
#define MCDC5_D5_MASK                   32
#define MCDC5_D6_MASK                   64
#define MCDC5_D7_MASK                   128
#define MCDC5_D8_MASK                   256
#define MCDC5_D9_MASK                   512
#define MCDC5_D10_MASK                  1024
#define MCDC5_S_MASK                    32768
#define MCDC5_D_MASK                    %BitsMask
#define MCDC5_D_BITNUM                  %BitsNum


/*** MCDC6 - Motor Controller Duty Cycle Register 6; 0x000001EC ***/
typedef union {
  word Word;
  struct {
    word D0          :1;                                       /* Motor Controller Duty Cycle Bit 0 */
    word D1          :1;                                       /* Motor Controller Duty Cycle Bit 1 */
    word D2          :1;                                       /* Motor Controller Duty Cycle Bit 2 */
    word D3          :1;                                       /* Motor Controller Duty Cycle Bit 3 */
    word D4          :1;                                       /* Motor Controller Duty Cycle Bit 4 */
    word D5          :1;                                       /* Motor Controller Duty Cycle Bit 5 */
    word D6          :1;                                       /* Motor Controller Duty Cycle Bit 6 */
    word D7          :1;                                       /* Motor Controller Duty Cycle Bit 7 */
    word D8          :1;                                       /* Motor Controller Duty Cycle Bit 8 */
    word D9          :1;                                       /* Motor Controller Duty Cycle Bit 9 */
    word D10         :1;                                       /* Motor Controller Duty Cycle Bit 10 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word S           :1;                                       /* Sign */
  } Bits;
  struct {
    word grpD    :11;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} MCDC6STR;
extern volatile MCDC6STR _MCDC6 @(REG_BASE + 0x000001EC);
#define MCDC6                           _MCDC6.Word
#define MCDC6_D0                        _MCDC6.Bits.D0
#define MCDC6_D1                        _MCDC6.Bits.D1
#define MCDC6_D2                        _MCDC6.Bits.D2
#define MCDC6_D3                        _MCDC6.Bits.D3
#define MCDC6_D4                        _MCDC6.Bits.D4
#define MCDC6_D5                        _MCDC6.Bits.D5
#define MCDC6_D6                        _MCDC6.Bits.D6
#define MCDC6_D7                        _MCDC6.Bits.D7
#define MCDC6_D8                        _MCDC6.Bits.D8
#define MCDC6_D9                        _MCDC6.Bits.D9
#define MCDC6_D10                       _MCDC6.Bits.D10
#define MCDC6_S                         _MCDC6.Bits.S
#define MCDC6_D                         _MCDC6.MergedBits.grpD

#define MCDC6_D0_MASK                   1
#define MCDC6_D1_MASK                   2
#define MCDC6_D2_MASK                   4
#define MCDC6_D3_MASK                   8
#define MCDC6_D4_MASK                   16
#define MCDC6_D5_MASK                   32
#define MCDC6_D6_MASK                   64
#define MCDC6_D7_MASK                   128
#define MCDC6_D8_MASK                   256
#define MCDC6_D9_MASK                   512
#define MCDC6_D10_MASK                  1024
#define MCDC6_S_MASK                    32768
#define MCDC6_D_MASK                    %BitsMask
#define MCDC6_D_BITNUM                  %BitsNum


/*** MCDC7 - Motor Controller Duty Cycle Register 7; 0x000001EE ***/
typedef union {
  word Word;
  struct {
    word D0          :1;                                       /* Motor Controller Duty Cycle Bit 0 */
    word D1          :1;                                       /* Motor Controller Duty Cycle Bit 1 */
    word D2          :1;                                       /* Motor Controller Duty Cycle Bit 2 */
    word D3          :1;                                       /* Motor Controller Duty Cycle Bit 3 */
    word D4          :1;                                       /* Motor Controller Duty Cycle Bit 4 */
    word D5          :1;                                       /* Motor Controller Duty Cycle Bit 5 */
    word D6          :1;                                       /* Motor Controller Duty Cycle Bit 6 */
    word D7          :1;                                       /* Motor Controller Duty Cycle Bit 7 */
    word D8          :1;                                       /* Motor Controller Duty Cycle Bit 8 */
    word D9          :1;                                       /* Motor Controller Duty Cycle Bit 9 */
    word D10         :1;                                       /* Motor Controller Duty Cycle Bit 10 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word S           :1;                                       /* Sign */
  } Bits;
  struct {
    word grpD    :11;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} MCDC7STR;
extern volatile MCDC7STR _MCDC7 @(REG_BASE + 0x000001EE);
#define MCDC7                           _MCDC7.Word
#define MCDC7_D0                        _MCDC7.Bits.D0
#define MCDC7_D1                        _MCDC7.Bits.D1
#define MCDC7_D2                        _MCDC7.Bits.D2
#define MCDC7_D3                        _MCDC7.Bits.D3
#define MCDC7_D4                        _MCDC7.Bits.D4
#define MCDC7_D5                        _MCDC7.Bits.D5
#define MCDC7_D6                        _MCDC7.Bits.D6
#define MCDC7_D7                        _MCDC7.Bits.D7
#define MCDC7_D8                        _MCDC7.Bits.D8
#define MCDC7_D9                        _MCDC7.Bits.D9
#define MCDC7_D10                       _MCDC7.Bits.D10
#define MCDC7_S                         _MCDC7.Bits.S
#define MCDC7_D                         _MCDC7.MergedBits.grpD

#define MCDC7_D0_MASK                   1
#define MCDC7_D1_MASK                   2
#define MCDC7_D2_MASK                   4
#define MCDC7_D3_MASK                   8
#define MCDC7_D4_MASK                   16
#define MCDC7_D5_MASK                   32
#define MCDC7_D6_MASK                   64
#define MCDC7_D7_MASK                   128
#define MCDC7_D8_MASK                   256
#define MCDC7_D9_MASK                   512
#define MCDC7_D10_MASK                  1024
#define MCDC7_S_MASK                    32768
#define MCDC7_D_MASK                    %BitsMask
#define MCDC7_D_BITNUM                  %BitsNum


/*** MCDC8 - Motor Controller Duty Cycle Register 8; 0x000001F0 ***/
typedef union {
  word Word;
  struct {
    word D0          :1;                                       /* Motor Controller Duty Cycle Bit 0 */
    word D1          :1;                                       /* Motor Controller Duty Cycle Bit 1 */
    word D2          :1;                                       /* Motor Controller Duty Cycle Bit 2 */
    word D3          :1;                                       /* Motor Controller Duty Cycle Bit 3 */
    word D4          :1;                                       /* Motor Controller Duty Cycle Bit 4 */
    word D5          :1;                                       /* Motor Controller Duty Cycle Bit 5 */
    word D6          :1;                                       /* Motor Controller Duty Cycle Bit 6 */
    word D7          :1;                                       /* Motor Controller Duty Cycle Bit 7 */
    word D8          :1;                                       /* Motor Controller Duty Cycle Bit 8 */
    word D9          :1;                                       /* Motor Controller Duty Cycle Bit 9 */
    word D10         :1;                                       /* Motor Controller Duty Cycle Bit 10 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word S           :1;                                       /* Sign */
  } Bits;
  struct {
    word grpD    :11;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} MCDC8STR;
extern volatile MCDC8STR _MCDC8 @(REG_BASE + 0x000001F0);
#define MCDC8                           _MCDC8.Word
#define MCDC8_D0                        _MCDC8.Bits.D0
#define MCDC8_D1                        _MCDC8.Bits.D1
#define MCDC8_D2                        _MCDC8.Bits.D2
#define MCDC8_D3                        _MCDC8.Bits.D3
#define MCDC8_D4                        _MCDC8.Bits.D4
#define MCDC8_D5                        _MCDC8.Bits.D5
#define MCDC8_D6                        _MCDC8.Bits.D6
#define MCDC8_D7                        _MCDC8.Bits.D7
#define MCDC8_D8                        _MCDC8.Bits.D8
#define MCDC8_D9                        _MCDC8.Bits.D9
#define MCDC8_D10                       _MCDC8.Bits.D10
#define MCDC8_S                         _MCDC8.Bits.S
#define MCDC8_D                         _MCDC8.MergedBits.grpD

#define MCDC8_D0_MASK                   1
#define MCDC8_D1_MASK                   2
#define MCDC8_D2_MASK                   4
#define MCDC8_D3_MASK                   8
#define MCDC8_D4_MASK                   16
#define MCDC8_D5_MASK                   32
#define MCDC8_D6_MASK                   64
#define MCDC8_D7_MASK                   128
#define MCDC8_D8_MASK                   256
#define MCDC8_D9_MASK                   512
#define MCDC8_D10_MASK                  1024
#define MCDC8_S_MASK                    32768
#define MCDC8_D_MASK                    %BitsMask
#define MCDC8_D_BITNUM                  %BitsNum


/*** MCDC9 - Motor Controller Duty Cycle Register 9; 0x000001F2 ***/
typedef union {
  word Word;
  struct {
    word D0          :1;                                       /* Motor Controller Duty Cycle Bit 0 */
    word D1          :1;                                       /* Motor Controller Duty Cycle Bit 1 */
    word D2          :1;                                       /* Motor Controller Duty Cycle Bit 2 */
    word D3          :1;                                       /* Motor Controller Duty Cycle Bit 3 */
    word D4          :1;                                       /* Motor Controller Duty Cycle Bit 4 */
    word D5          :1;                                       /* Motor Controller Duty Cycle Bit 5 */
    word D6          :1;                                       /* Motor Controller Duty Cycle Bit 6 */
    word D7          :1;                                       /* Motor Controller Duty Cycle Bit 7 */
    word D8          :1;                                       /* Motor Controller Duty Cycle Bit 8 */
    word D9          :1;                                       /* Motor Controller Duty Cycle Bit 9 */
    word D10         :1;                                       /* Motor Controller Duty Cycle Bit 10 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word S           :1;                                       /* Sign */
  } Bits;
  struct {
    word grpD    :11;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} MCDC9STR;
extern volatile MCDC9STR _MCDC9 @(REG_BASE + 0x000001F2);
#define MCDC9                           _MCDC9.Word
#define MCDC9_D0                        _MCDC9.Bits.D0
#define MCDC9_D1                        _MCDC9.Bits.D1
#define MCDC9_D2                        _MCDC9.Bits.D2
#define MCDC9_D3                        _MCDC9.Bits.D3
#define MCDC9_D4                        _MCDC9.Bits.D4
#define MCDC9_D5                        _MCDC9.Bits.D5
#define MCDC9_D6                        _MCDC9.Bits.D6
#define MCDC9_D7                        _MCDC9.Bits.D7
#define MCDC9_D8                        _MCDC9.Bits.D8
#define MCDC9_D9                        _MCDC9.Bits.D9
#define MCDC9_D10                       _MCDC9.Bits.D10
#define MCDC9_S                         _MCDC9.Bits.S
#define MCDC9_D                         _MCDC9.MergedBits.grpD

#define MCDC9_D0_MASK                   1
#define MCDC9_D1_MASK                   2
#define MCDC9_D2_MASK                   4
#define MCDC9_D3_MASK                   8
#define MCDC9_D4_MASK                   16
#define MCDC9_D5_MASK                   32
#define MCDC9_D6_MASK                   64
#define MCDC9_D7_MASK                   128
#define MCDC9_D8_MASK                   256
#define MCDC9_D9_MASK                   512
#define MCDC9_D10_MASK                  1024
#define MCDC9_S_MASK                    32768
#define MCDC9_D_MASK                    %BitsMask
#define MCDC9_D_BITNUM                  %BitsNum


/*** MCDC10 - Motor Controller Duty Cycle Register 10; 0x000001F4 ***/
typedef union {
  word Word;
  struct {
    word D0          :1;                                       /* Motor Controller Duty Cycle Bit 0 */
    word D1          :1;                                       /* Motor Controller Duty Cycle Bit 1 */
    word D2          :1;                                       /* Motor Controller Duty Cycle Bit 2 */
    word D3          :1;                                       /* Motor Controller Duty Cycle Bit 3 */
    word D4          :1;                                       /* Motor Controller Duty Cycle Bit 4 */
    word D5          :1;                                       /* Motor Controller Duty Cycle Bit 5 */
    word D6          :1;                                       /* Motor Controller Duty Cycle Bit 6 */
    word D7          :1;                                       /* Motor Controller Duty Cycle Bit 7 */
    word D8          :1;                                       /* Motor Controller Duty Cycle Bit 8 */
    word D9          :1;                                       /* Motor Controller Duty Cycle Bit 9 */
    word D10         :1;                                       /* Motor Controller Duty Cycle Bit 10 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word S           :1;                                       /* Sign */
  } Bits;
  struct {
    word grpD    :11;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} MCDC10STR;
extern volatile MCDC10STR _MCDC10 @(REG_BASE + 0x000001F4);
#define MCDC10                          _MCDC10.Word
#define MCDC10_D0                       _MCDC10.Bits.D0
#define MCDC10_D1                       _MCDC10.Bits.D1
#define MCDC10_D2                       _MCDC10.Bits.D2
#define MCDC10_D3                       _MCDC10.Bits.D3
#define MCDC10_D4                       _MCDC10.Bits.D4
#define MCDC10_D5                       _MCDC10.Bits.D5
#define MCDC10_D6                       _MCDC10.Bits.D6
#define MCDC10_D7                       _MCDC10.Bits.D7
#define MCDC10_D8                       _MCDC10.Bits.D8
#define MCDC10_D9                       _MCDC10.Bits.D9
#define MCDC10_D10                      _MCDC10.Bits.D10
#define MCDC10_S                        _MCDC10.Bits.S
#define MCDC10_D                        _MCDC10.MergedBits.grpD

#define MCDC10_D0_MASK                  1
#define MCDC10_D1_MASK                  2
#define MCDC10_D2_MASK                  4
#define MCDC10_D3_MASK                  8
#define MCDC10_D4_MASK                  16
#define MCDC10_D5_MASK                  32
#define MCDC10_D6_MASK                  64
#define MCDC10_D7_MASK                  128
#define MCDC10_D8_MASK                  256
#define MCDC10_D9_MASK                  512
#define MCDC10_D10_MASK                 1024
#define MCDC10_S_MASK                   32768
#define MCDC10_D_MASK                   %BitsMask
#define MCDC10_D_BITNUM                 %BitsNum


/*** MCDC11 - Motor Controller Duty Cycle Register 11; 0x000001F6 ***/
typedef union {
  word Word;
  struct {
    word D0          :1;                                       /* Motor Controller Duty Cycle Bit 0 */
    word D1          :1;                                       /* Motor Controller Duty Cycle Bit 1 */
    word D2          :1;                                       /* Motor Controller Duty Cycle Bit 2 */
    word D3          :1;                                       /* Motor Controller Duty Cycle Bit 3 */
    word D4          :1;                                       /* Motor Controller Duty Cycle Bit 4 */
    word D5          :1;                                       /* Motor Controller Duty Cycle Bit 5 */
    word D6          :1;                                       /* Motor Controller Duty Cycle Bit 6 */
    word D7          :1;                                       /* Motor Controller Duty Cycle Bit 7 */
    word D8          :1;                                       /* Motor Controller Duty Cycle Bit 8 */
    word D9          :1;                                       /* Motor Controller Duty Cycle Bit 9 */
    word D10         :1;                                       /* Motor Controller Duty Cycle Bit 10 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word S           :1;                                       /* Sign */
  } Bits;
  struct {
    word grpD    :11;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} MCDC11STR;
extern volatile MCDC11STR _MCDC11 @(REG_BASE + 0x000001F6);
#define MCDC11                          _MCDC11.Word
#define MCDC11_D0                       _MCDC11.Bits.D0
#define MCDC11_D1                       _MCDC11.Bits.D1
#define MCDC11_D2                       _MCDC11.Bits.D2
#define MCDC11_D3                       _MCDC11.Bits.D3
#define MCDC11_D4                       _MCDC11.Bits.D4
#define MCDC11_D5                       _MCDC11.Bits.D5
#define MCDC11_D6                       _MCDC11.Bits.D6
#define MCDC11_D7                       _MCDC11.Bits.D7
#define MCDC11_D8                       _MCDC11.Bits.D8
#define MCDC11_D9                       _MCDC11.Bits.D9
#define MCDC11_D10                      _MCDC11.Bits.D10
#define MCDC11_S                        _MCDC11.Bits.S
#define MCDC11_D                        _MCDC11.MergedBits.grpD

#define MCDC11_D0_MASK                  1
#define MCDC11_D1_MASK                  2
#define MCDC11_D2_MASK                  4
#define MCDC11_D3_MASK                  8
#define MCDC11_D4_MASK                  16
#define MCDC11_D5_MASK                  32
#define MCDC11_D6_MASK                  64
#define MCDC11_D7_MASK                  128
#define MCDC11_D8_MASK                  256
#define MCDC11_D9_MASK                  512
#define MCDC11_D10_MASK                 1024
#define MCDC11_S_MASK                   32768
#define MCDC11_D_MASK                   %BitsMask
#define MCDC11_D_BITNUM                 %BitsNum


/*** PTT - Port T I/O Register; 0x00000200 ***/
typedef union {
  byte Byte;
  struct {
    byte PTT0        :1;                                       /* Port T Bit 0 */
    byte PTT1        :1;                                       /* Port T Bit 1 */
    byte PTT2        :1;                                       /* Port T Bit 2 */
    byte PTT3        :1;                                       /* Port T Bit 3 */
    byte PTT4        :1;                                       /* Port T Bit 4 */
    byte PTT5        :1;                                       /* Port T Bit 5 */
    byte PTT6        :1;                                       /* Port T Bit 6 */
    byte PTT7        :1;                                       /* Port T Bit 7 */
  } Bits;
} PTTSTR;
extern volatile PTTSTR _PTT @(REG_BASE + 0x00000200);
#define PTT                             _PTT.Byte
#define PTT_PTT0                        _PTT.Bits.PTT0
#define PTT_PTT1                        _PTT.Bits.PTT1
#define PTT_PTT2                        _PTT.Bits.PTT2
#define PTT_PTT3                        _PTT.Bits.PTT3
#define PTT_PTT4                        _PTT.Bits.PTT4
#define PTT_PTT5                        _PTT.Bits.PTT5
#define PTT_PTT6                        _PTT.Bits.PTT6
#define PTT_PTT7                        _PTT.Bits.PTT7

#define PTT_PTT0_MASK                   1
#define PTT_PTT1_MASK                   2
#define PTT_PTT2_MASK                   4
#define PTT_PTT3_MASK                   8
#define PTT_PTT4_MASK                   16
#define PTT_PTT5_MASK                   32
#define PTT_PTT6_MASK                   64
#define PTT_PTT7_MASK                   128


/*** PTIT - Port T Input Register; 0x00000201 ***/
typedef union {
  byte Byte;
  struct {
    byte PTIT0       :1;                                       /* Port T Bit 0 */
    byte PTIT1       :1;                                       /* Port T Bit 1 */
    byte PTIT2       :1;                                       /* Port T Bit 2 */
    byte PTIT3       :1;                                       /* Port T Bit 3 */
    byte PTIT4       :1;                                       /* Port T Bit 4 */
    byte PTIT5       :1;                                       /* Port T Bit 5 */
    byte PTIT6       :1;                                       /* Port T Bit 6 */
    byte PTIT7       :1;                                       /* Port T Bit 7 */
  } Bits;
} PTITSTR;
extern volatile PTITSTR _PTIT @(REG_BASE + 0x00000201);
#define PTIT                            _PTIT.Byte
#define PTIT_PTIT0                      _PTIT.Bits.PTIT0
#define PTIT_PTIT1                      _PTIT.Bits.PTIT1
#define PTIT_PTIT2                      _PTIT.Bits.PTIT2
#define PTIT_PTIT3                      _PTIT.Bits.PTIT3
#define PTIT_PTIT4                      _PTIT.Bits.PTIT4
#define PTIT_PTIT5                      _PTIT.Bits.PTIT5
#define PTIT_PTIT6                      _PTIT.Bits.PTIT6
#define PTIT_PTIT7                      _PTIT.Bits.PTIT7

#define PTIT_PTIT0_MASK                 1
#define PTIT_PTIT1_MASK                 2
#define PTIT_PTIT2_MASK                 4
#define PTIT_PTIT3_MASK                 8
#define PTIT_PTIT4_MASK                 16
#define PTIT_PTIT5_MASK                 32
#define PTIT_PTIT6_MASK                 64
#define PTIT_PTIT7_MASK                 128


/*** DDRT - Port T Data Direction Register; 0x00000202 ***/
typedef union {
  byte Byte;
  struct {
    byte DDRT0       :1;                                       /* Data Direction Port T Bit 0 */
    byte DDRT1       :1;                                       /* Data Direction Port T Bit 1 */
    byte DDRT2       :1;                                       /* Data Direction Port T Bit 2 */
    byte DDRT3       :1;                                       /* Data Direction Port T Bit 3 */
    byte DDRT4       :1;                                       /* Data Direction Port T Bit 4 */
    byte DDRT5       :1;                                       /* Data Direction Port T Bit 5 */
    byte DDRT6       :1;                                       /* Data Direction Port T Bit 6 */
    byte DDRT7       :1;                                       /* Data Direction Port T Bit 7 */
  } Bits;
} DDRTSTR;
extern volatile DDRTSTR _DDRT @(REG_BASE + 0x00000202);
#define DDRT                            _DDRT.Byte
#define DDRT_DDRT0                      _DDRT.Bits.DDRT0
#define DDRT_DDRT1                      _DDRT.Bits.DDRT1
#define DDRT_DDRT2                      _DDRT.Bits.DDRT2
#define DDRT_DDRT3                      _DDRT.Bits.DDRT3
#define DDRT_DDRT4                      _DDRT.Bits.DDRT4
#define DDRT_DDRT5                      _DDRT.Bits.DDRT5
#define DDRT_DDRT6                      _DDRT.Bits.DDRT6
#define DDRT_DDRT7                      _DDRT.Bits.DDRT7

#define DDRT_DDRT0_MASK                 1
#define DDRT_DDRT1_MASK                 2
#define DDRT_DDRT2_MASK                 4
#define DDRT_DDRT3_MASK                 8
#define DDRT_DDRT4_MASK                 16
#define DDRT_DDRT5_MASK                 32
#define DDRT_DDRT6_MASK                 64
#define DDRT_DDRT7_MASK                 128


/*** RDRT - Port T Reduced Drive Register; 0x00000203 ***/
typedef union {
  byte Byte;
  struct {
    byte RDRT0       :1;                                       /* Reduced Drive Port T Bit 0 */
    byte RDRT1       :1;                                       /* Reduced Drive Port T Bit 1 */
    byte RDRT2       :1;                                       /* Reduced Drive Port T Bit 2 */
    byte RDRT3       :1;                                       /* Reduced Drive Port T Bit 3 */
    byte RDRT4       :1;                                       /* Reduced Drive Port T Bit 4 */
    byte RDRT5       :1;                                       /* Reduced Drive Port T Bit 5 */
    byte RDRT6       :1;                                       /* Reduced Drive Port T Bit 6 */
    byte RDRT7       :1;                                       /* Reduced Drive Port T Bit 7 */
  } Bits;
} RDRTSTR;
extern volatile RDRTSTR _RDRT @(REG_BASE + 0x00000203);
#define RDRT                            _RDRT.Byte
#define RDRT_RDRT0                      _RDRT.Bits.RDRT0
#define RDRT_RDRT1                      _RDRT.Bits.RDRT1
#define RDRT_RDRT2                      _RDRT.Bits.RDRT2
#define RDRT_RDRT3                      _RDRT.Bits.RDRT3
#define RDRT_RDRT4                      _RDRT.Bits.RDRT4
#define RDRT_RDRT5                      _RDRT.Bits.RDRT5
#define RDRT_RDRT6                      _RDRT.Bits.RDRT6
#define RDRT_RDRT7                      _RDRT.Bits.RDRT7

#define RDRT_RDRT0_MASK                 1
#define RDRT_RDRT1_MASK                 2
#define RDRT_RDRT2_MASK                 4
#define RDRT_RDRT3_MASK                 8
#define RDRT_RDRT4_MASK                 16
#define RDRT_RDRT5_MASK                 32
#define RDRT_RDRT6_MASK                 64
#define RDRT_RDRT7_MASK                 128


/*** PERT - Port T Pull Device Enable Register; 0x00000204 ***/
typedef union {
  byte Byte;
  struct {
    byte PERT0       :1;                                       /* Pull Device Enable Port T Bit 0 */
    byte PERT1       :1;                                       /* Pull Device Enable Port T Bit 1 */
    byte PERT2       :1;                                       /* Pull Device Enable Port T Bit 2 */
    byte PERT3       :1;                                       /* Pull Device Enable Port T Bit 3 */
    byte PERT4       :1;                                       /* Pull Device Enable Port T Bit 4 */
    byte PERT5       :1;                                       /* Pull Device Enable Port T Bit 5 */
    byte PERT6       :1;                                       /* Pull Device Enable Port T Bit 6 */
    byte PERT7       :1;                                       /* Pull Device Enable Port T Bit 7 */
  } Bits;
} PERTSTR;
extern volatile PERTSTR _PERT @(REG_BASE + 0x00000204);
#define PERT                            _PERT.Byte
#define PERT_PERT0                      _PERT.Bits.PERT0
#define PERT_PERT1                      _PERT.Bits.PERT1
#define PERT_PERT2                      _PERT.Bits.PERT2
#define PERT_PERT3                      _PERT.Bits.PERT3
#define PERT_PERT4                      _PERT.Bits.PERT4
#define PERT_PERT5                      _PERT.Bits.PERT5
#define PERT_PERT6                      _PERT.Bits.PERT6
#define PERT_PERT7                      _PERT.Bits.PERT7

#define PERT_PERT0_MASK                 1
#define PERT_PERT1_MASK                 2
#define PERT_PERT2_MASK                 4
#define PERT_PERT3_MASK                 8
#define PERT_PERT4_MASK                 16
#define PERT_PERT5_MASK                 32
#define PERT_PERT6_MASK                 64
#define PERT_PERT7_MASK                 128


/*** PPST - Port T Polarity Select Register; 0x00000205 ***/
typedef union {
  byte Byte;
  struct {
    byte PPST0       :1;                                       /* Pull Select Port T Bit 0 */
    byte PPST1       :1;                                       /* Pull Select Port T Bit 1 */
    byte PPST2       :1;                                       /* Pull Select Port T Bit 2 */
    byte PPST3       :1;                                       /* Pull Select Port T Bit 3 */
    byte PPST4       :1;                                       /* Pull Select Port T Bit 4 */
    byte PPST5       :1;                                       /* Pull Select Port T Bit 5 */
    byte PPST6       :1;                                       /* Pull Select Port T Bit 6 */
    byte PPST7       :1;                                       /* Pull Select Port T Bit 7 */
  } Bits;
} PPSTSTR;
extern volatile PPSTSTR _PPST @(REG_BASE + 0x00000205);
#define PPST                            _PPST.Byte
#define PPST_PPST0                      _PPST.Bits.PPST0
#define PPST_PPST1                      _PPST.Bits.PPST1
#define PPST_PPST2                      _PPST.Bits.PPST2
#define PPST_PPST3                      _PPST.Bits.PPST3
#define PPST_PPST4                      _PPST.Bits.PPST4
#define PPST_PPST5                      _PPST.Bits.PPST5
#define PPST_PPST6                      _PPST.Bits.PPST6
#define PPST_PPST7                      _PPST.Bits.PPST7

#define PPST_PPST0_MASK                 1
#define PPST_PPST1_MASK                 2
#define PPST_PPST2_MASK                 4
#define PPST_PPST3_MASK                 8
#define PPST_PPST4_MASK                 16
#define PPST_PPST5_MASK                 32
#define PPST_PPST6_MASK                 64
#define PPST_PPST7_MASK                 128


/*** PTS - Port S I/O Register; 0x00000208 ***/
typedef union {
  byte Byte;
  struct {
    byte PTS0        :1;                                       /* Port S Bit 0 */
    byte PTS1        :1;                                       /* Port S Bit 1 */
    byte PTS2        :1;                                       /* Port S Bit 2 */
    byte PTS3        :1;                                       /* Port S Bit 3 */
    byte PTS4        :1;                                       /* Port S Bit 4 */
    byte PTS5        :1;                                       /* Port S Bit 5 */
    byte PTS6        :1;                                       /* Port S Bit 6 */
    byte PTS7        :1;                                       /* Port S Bit 7 */
  } Bits;
} PTSSTR;
extern volatile PTSSTR _PTS @(REG_BASE + 0x00000208);
#define PTS                             _PTS.Byte
#define PTS_PTS0                        _PTS.Bits.PTS0
#define PTS_PTS1                        _PTS.Bits.PTS1
#define PTS_PTS2                        _PTS.Bits.PTS2
#define PTS_PTS3                        _PTS.Bits.PTS3
#define PTS_PTS4                        _PTS.Bits.PTS4
#define PTS_PTS5                        _PTS.Bits.PTS5
#define PTS_PTS6                        _PTS.Bits.PTS6
#define PTS_PTS7                        _PTS.Bits.PTS7

#define PTS_PTS0_MASK                   1
#define PTS_PTS1_MASK                   2
#define PTS_PTS2_MASK                   4
#define PTS_PTS3_MASK                   8
#define PTS_PTS4_MASK                   16
#define PTS_PTS5_MASK                   32
#define PTS_PTS6_MASK                   64
#define PTS_PTS7_MASK                   128


/*** PTIS - Port S Input Register; 0x00000209 ***/
typedef union {
  byte Byte;
  struct {
    byte PTIS0       :1;                                       /* Port S Bit 0 */
    byte PTIS1       :1;                                       /* Port S Bit 1 */
    byte PTIS2       :1;                                       /* Port S Bit 2 */
    byte PTIS3       :1;                                       /* Port S Bit 3 */
    byte PTIS4       :1;                                       /* Port S Bit 4 */
    byte PTIS5       :1;                                       /* Port S Bit 5 */
    byte PTIS6       :1;                                       /* Port S Bit 6 */
    byte PTIS7       :1;                                       /* Port S Bit 7 */
  } Bits;
} PTISSTR;
extern volatile PTISSTR _PTIS @(REG_BASE + 0x00000209);
#define PTIS                            _PTIS.Byte
#define PTIS_PTIS0                      _PTIS.Bits.PTIS0
#define PTIS_PTIS1                      _PTIS.Bits.PTIS1
#define PTIS_PTIS2                      _PTIS.Bits.PTIS2
#define PTIS_PTIS3                      _PTIS.Bits.PTIS3
#define PTIS_PTIS4                      _PTIS.Bits.PTIS4
#define PTIS_PTIS5                      _PTIS.Bits.PTIS5
#define PTIS_PTIS6                      _PTIS.Bits.PTIS6
#define PTIS_PTIS7                      _PTIS.Bits.PTIS7

#define PTIS_PTIS0_MASK                 1
#define PTIS_PTIS1_MASK                 2
#define PTIS_PTIS2_MASK                 4
#define PTIS_PTIS3_MASK                 8
#define PTIS_PTIS4_MASK                 16
#define PTIS_PTIS5_MASK                 32
#define PTIS_PTIS6_MASK                 64
#define PTIS_PTIS7_MASK                 128


/*** DDRS - Port S Data Direction Register; 0x0000020A ***/
typedef union {
  byte Byte;
  struct {
    byte DDRS0       :1;                                       /* Data Direction Port S Bit 0 */
    byte DDRS1       :1;                                       /* Data Direction Port S Bit 1 */
    byte DDRS2       :1;                                       /* Data Direction Port S Bit 2 */
    byte DDRS3       :1;                                       /* Data Direction Port S Bit 3 */
    byte DDRS4       :1;                                       /* Data Direction Port S Bit 4 */
    byte DDRS5       :1;                                       /* Data Direction Port S Bit 5 */
    byte DDRS6       :1;                                       /* Data Direction Port S Bit 6 */
    byte DDRS7       :1;                                       /* Data Direction Port S Bit 7 */
  } Bits;
} DDRSSTR;
extern volatile DDRSSTR _DDRS @(REG_BASE + 0x0000020A);
#define DDRS                            _DDRS.Byte
#define DDRS_DDRS0                      _DDRS.Bits.DDRS0
#define DDRS_DDRS1                      _DDRS.Bits.DDRS1
#define DDRS_DDRS2                      _DDRS.Bits.DDRS2
#define DDRS_DDRS3                      _DDRS.Bits.DDRS3
#define DDRS_DDRS4                      _DDRS.Bits.DDRS4
#define DDRS_DDRS5                      _DDRS.Bits.DDRS5
#define DDRS_DDRS6                      _DDRS.Bits.DDRS6
#define DDRS_DDRS7                      _DDRS.Bits.DDRS7

#define DDRS_DDRS0_MASK                 1
#define DDRS_DDRS1_MASK                 2
#define DDRS_DDRS2_MASK                 4
#define DDRS_DDRS3_MASK                 8
#define DDRS_DDRS4_MASK                 16
#define DDRS_DDRS5_MASK                 32
#define DDRS_DDRS6_MASK                 64
#define DDRS_DDRS7_MASK                 128


/*** RDRS - Port S Reduced Drive Register; 0x0000020B ***/
typedef union {
  byte Byte;
  struct {
    byte RDRS0       :1;                                       /* Reduced Drive Port S Bit 0 */
    byte RDRS1       :1;                                       /* Reduced Drive Port S Bit 1 */
    byte RDRS2       :1;                                       /* Reduced Drive Port S Bit 2 */
    byte RDRS3       :1;                                       /* Reduced Drive Port S Bit 3 */
    byte RDRS4       :1;                                       /* Reduced Drive Port S Bit 4 */
    byte RDRS5       :1;                                       /* Reduced Drive Port S Bit 5 */
    byte RDRS6       :1;                                       /* Reduced Drive Port S Bit 6 */
    byte RDRS7       :1;                                       /* Reduced Drive Port S Bit 7 */
  } Bits;
} RDRSSTR;
extern volatile RDRSSTR _RDRS @(REG_BASE + 0x0000020B);
#define RDRS                            _RDRS.Byte
#define RDRS_RDRS0                      _RDRS.Bits.RDRS0
#define RDRS_RDRS1                      _RDRS.Bits.RDRS1
#define RDRS_RDRS2                      _RDRS.Bits.RDRS2
#define RDRS_RDRS3                      _RDRS.Bits.RDRS3
#define RDRS_RDRS4                      _RDRS.Bits.RDRS4
#define RDRS_RDRS5                      _RDRS.Bits.RDRS5
#define RDRS_RDRS6                      _RDRS.Bits.RDRS6
#define RDRS_RDRS7                      _RDRS.Bits.RDRS7

#define RDRS_RDRS0_MASK                 1
#define RDRS_RDRS1_MASK                 2
#define RDRS_RDRS2_MASK                 4
#define RDRS_RDRS3_MASK                 8
#define RDRS_RDRS4_MASK                 16
#define RDRS_RDRS5_MASK                 32
#define RDRS_RDRS6_MASK                 64
#define RDRS_RDRS7_MASK                 128


/*** PERS - Port S Pull Device Enable Register; 0x0000020C ***/
typedef union {
  byte Byte;
  struct {
    byte PERS0       :1;                                       /* Pull Device Enable Port S Bit 0 */
    byte PERS1       :1;                                       /* Pull Device Enable Port S Bit 1 */
    byte PERS2       :1;                                       /* Pull Device Enable Port S Bit 2 */
    byte PERS3       :1;                                       /* Pull Device Enable Port S Bit 3 */
    byte PERS4       :1;                                       /* Pull Device Enable Port S Bit 4 */
    byte PERS5       :1;                                       /* Pull Device Enable Port S Bit 5 */
    byte PERS6       :1;                                       /* Pull Device Enable Port S Bit 6 */
    byte PERS7       :1;                                       /* Pull Device Enable Port S Bit 7 */
  } Bits;
} PERSSTR;
extern volatile PERSSTR _PERS @(REG_BASE + 0x0000020C);
#define PERS                            _PERS.Byte
#define PERS_PERS0                      _PERS.Bits.PERS0
#define PERS_PERS1                      _PERS.Bits.PERS1
#define PERS_PERS2                      _PERS.Bits.PERS2
#define PERS_PERS3                      _PERS.Bits.PERS3
#define PERS_PERS4                      _PERS.Bits.PERS4
#define PERS_PERS5                      _PERS.Bits.PERS5
#define PERS_PERS6                      _PERS.Bits.PERS6
#define PERS_PERS7                      _PERS.Bits.PERS7

#define PERS_PERS0_MASK                 1
#define PERS_PERS1_MASK                 2
#define PERS_PERS2_MASK                 4
#define PERS_PERS3_MASK                 8
#define PERS_PERS4_MASK                 16
#define PERS_PERS5_MASK                 32
#define PERS_PERS6_MASK                 64
#define PERS_PERS7_MASK                 128


/*** PPSS - Port S Polarity Select Register; 0x0000020D ***/
typedef union {
  byte Byte;
  struct {
    byte PPSS0       :1;                                       /* Pull Select Port S Bit 0 */
    byte PPSS1       :1;                                       /* Pull Select Port S Bit 1 */
    byte PPSS2       :1;                                       /* Pull Select Port S Bit 2 */
    byte PPSS3       :1;                                       /* Pull Select Port S Bit 3 */
    byte PPSS4       :1;                                       /* Pull Select Port S Bit 4 */
    byte PPSS5       :1;                                       /* Pull Select Port S Bit 5 */
    byte PPSS6       :1;                                       /* Pull Select Port S Bit 6 */
    byte PPSS7       :1;                                       /* Pull Select Port S Bit 7 */
  } Bits;
} PPSSSTR;
extern volatile PPSSSTR _PPSS @(REG_BASE + 0x0000020D);
#define PPSS                            _PPSS.Byte
#define PPSS_PPSS0                      _PPSS.Bits.PPSS0
#define PPSS_PPSS1                      _PPSS.Bits.PPSS1
#define PPSS_PPSS2                      _PPSS.Bits.PPSS2
#define PPSS_PPSS3                      _PPSS.Bits.PPSS3
#define PPSS_PPSS4                      _PPSS.Bits.PPSS4
#define PPSS_PPSS5                      _PPSS.Bits.PPSS5
#define PPSS_PPSS6                      _PPSS.Bits.PPSS6
#define PPSS_PPSS7                      _PPSS.Bits.PPSS7

#define PPSS_PPSS0_MASK                 1
#define PPSS_PPSS1_MASK                 2
#define PPSS_PPSS2_MASK                 4
#define PPSS_PPSS3_MASK                 8
#define PPSS_PPSS4_MASK                 16
#define PPSS_PPSS5_MASK                 32
#define PPSS_PPSS6_MASK                 64
#define PPSS_PPSS7_MASK                 128


/*** WOMS - Port S Wired-Or Mode Register; 0x0000020E ***/
typedef union {
  byte Byte;
  struct {
    byte WOMS0       :1;                                       /* Wired-Or Mode Port S Bit 0 */
    byte WOMS1       :1;                                       /* Wired-Or Mode Port S Bit 1 */
    byte WOMS2       :1;                                       /* Wired-Or Mode Port S Bit 2 */
    byte WOMS3       :1;                                       /* Wired-Or Mode Port S Bit 3 */
    byte WOMS4       :1;                                       /* Wired-Or Mode Port S Bit 4 */
    byte WOMS5       :1;                                       /* Wired-Or Mode Port S Bit 5 */
    byte WOMS6       :1;                                       /* Wired-Or Mode Port S Bit 6 */
    byte WOMS7       :1;                                       /* Wired-Or Mode Port S Bit 7 */
  } Bits;
} WOMSSTR;
extern volatile WOMSSTR _WOMS @(REG_BASE + 0x0000020E);
#define WOMS                            _WOMS.Byte
#define WOMS_WOMS0                      _WOMS.Bits.WOMS0
#define WOMS_WOMS1                      _WOMS.Bits.WOMS1
#define WOMS_WOMS2                      _WOMS.Bits.WOMS2
#define WOMS_WOMS3                      _WOMS.Bits.WOMS3
#define WOMS_WOMS4                      _WOMS.Bits.WOMS4
#define WOMS_WOMS5                      _WOMS.Bits.WOMS5
#define WOMS_WOMS6                      _WOMS.Bits.WOMS6
#define WOMS_WOMS7                      _WOMS.Bits.WOMS7

#define WOMS_WOMS0_MASK                 1
#define WOMS_WOMS1_MASK                 2
#define WOMS_WOMS2_MASK                 4
#define WOMS_WOMS3_MASK                 8
#define WOMS_WOMS4_MASK                 16
#define WOMS_WOMS5_MASK                 32
#define WOMS_WOMS6_MASK                 64
#define WOMS_WOMS7_MASK                 128


/*** PTM - Port M I/O Register; 0x00000210 ***/
typedef union {
  byte Byte;
  struct {
    byte PTM0        :1;                                       /* Port M Bit 0 */
    byte PTM1        :1;                                       /* Port M Bit 1 */
    byte PTM2        :1;                                       /* Port M Bit 2 */
    byte PTM3        :1;                                       /* Port M Bit 3 */
    byte PTM4        :1;                                       /* Port M Bit 4 */
    byte PTM5        :1;                                       /* Port M Bit 5 */
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpPTM  :6;
    byte         :1;
    byte         :1;
  } MergedBits;
} PTMSTR;
extern volatile PTMSTR _PTM @(REG_BASE + 0x00000210);
#define PTM                             _PTM.Byte
#define PTM_PTM0                        _PTM.Bits.PTM0
#define PTM_PTM1                        _PTM.Bits.PTM1
#define PTM_PTM2                        _PTM.Bits.PTM2
#define PTM_PTM3                        _PTM.Bits.PTM3
#define PTM_PTM4                        _PTM.Bits.PTM4
#define PTM_PTM5                        _PTM.Bits.PTM5
#define PTM_PTM                         _PTM.MergedBits.grpPTM

#define PTM_PTM0_MASK                   1
#define PTM_PTM1_MASK                   2
#define PTM_PTM2_MASK                   4
#define PTM_PTM3_MASK                   8
#define PTM_PTM4_MASK                   16
#define PTM_PTM5_MASK                   32
#define PTM_PTM_MASK                    %BitsMask
#define PTM_PTM_BITNUM                  %BitsNum


/*** PTIM - Port M Input Register; 0x00000211 ***/
typedef union {
  byte Byte;
  struct {
    byte PTIM0       :1;                                       /* Port M Bit 0 */
    byte PTIM1       :1;                                       /* Port M Bit 1 */
    byte PTIM2       :1;                                       /* Port M Bit 2 */
    byte PTIM3       :1;                                       /* Port M Bit 3 */
    byte PTIM4       :1;                                       /* Port M Bit 4 */
    byte PTIM5       :1;                                       /* Port M Bit 5 */
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpPTIM :6;
    byte         :1;
    byte         :1;
  } MergedBits;
} PTIMSTR;
extern volatile PTIMSTR _PTIM @(REG_BASE + 0x00000211);
#define PTIM                            _PTIM.Byte
#define PTIM_PTIM0                      _PTIM.Bits.PTIM0
#define PTIM_PTIM1                      _PTIM.Bits.PTIM1
#define PTIM_PTIM2                      _PTIM.Bits.PTIM2
#define PTIM_PTIM3                      _PTIM.Bits.PTIM3
#define PTIM_PTIM4                      _PTIM.Bits.PTIM4
#define PTIM_PTIM5                      _PTIM.Bits.PTIM5
#define PTIM_PTIM                       _PTIM.MergedBits.grpPTIM

#define PTIM_PTIM0_MASK                 1
#define PTIM_PTIM1_MASK                 2
#define PTIM_PTIM2_MASK                 4
#define PTIM_PTIM3_MASK                 8
#define PTIM_PTIM4_MASK                 16
#define PTIM_PTIM5_MASK                 32
#define PTIM_PTIM_MASK                  %BitsMask
#define PTIM_PTIM_BITNUM                %BitsNum


/*** DDRM - Port M Data Direction Register; 0x00000212 ***/
typedef union {
  byte Byte;
  struct {
    byte DDRM0       :1;                                       /* Data Direction Port M Bit 0 */
    byte DDRM1       :1;                                       /* Data Direction Port M Bit 1 */
    byte DDRM2       :1;                                       /* Data Direction Port M Bit 2 */
    byte DDRM3       :1;                                       /* Data Direction Port M Bit 3 */
    byte DDRM4       :1;                                       /* Data Direction Port M Bit 4 */
    byte DDRM5       :1;                                       /* Data Direction Port M Bit 5 */
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpDDRM :6;
    byte         :1;
    byte         :1;
  } MergedBits;
} DDRMSTR;
extern volatile DDRMSTR _DDRM @(REG_BASE + 0x00000212);
#define DDRM                            _DDRM.Byte
#define DDRM_DDRM0                      _DDRM.Bits.DDRM0
#define DDRM_DDRM1                      _DDRM.Bits.DDRM1
#define DDRM_DDRM2                      _DDRM.Bits.DDRM2
#define DDRM_DDRM3                      _DDRM.Bits.DDRM3
#define DDRM_DDRM4                      _DDRM.Bits.DDRM4
#define DDRM_DDRM5                      _DDRM.Bits.DDRM5
#define DDRM_DDRM                       _DDRM.MergedBits.grpDDRM

#define DDRM_DDRM0_MASK                 1
#define DDRM_DDRM1_MASK                 2
#define DDRM_DDRM2_MASK                 4
#define DDRM_DDRM3_MASK                 8
#define DDRM_DDRM4_MASK                 16
#define DDRM_DDRM5_MASK                 32
#define DDRM_DDRM_MASK                  %BitsMask
#define DDRM_DDRM_BITNUM                %BitsNum


/*** RDRM - Port M Reduced Drive Register; 0x00000213 ***/
typedef union {
  byte Byte;
  struct {
    byte RDRM0       :1;                                       /* Reduced Drive Port M Bit 0 */
    byte RDRM1       :1;                                       /* Reduced Drive Port M Bit 1 */
    byte RDRM2       :1;                                       /* Reduced Drive Port M Bit 2 */
    byte RDRM3       :1;                                       /* Reduced Drive Port M Bit 3 */
    byte RDRM4       :1;                                       /* Reduced Drive Port M Bit 4 */
    byte RDRM5       :1;                                       /* Reduced Drive Port M Bit 5 */
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpRDRM :6;
    byte         :1;
    byte         :1;
  } MergedBits;
} RDRMSTR;
extern volatile RDRMSTR _RDRM @(REG_BASE + 0x00000213);
#define RDRM                            _RDRM.Byte
#define RDRM_RDRM0                      _RDRM.Bits.RDRM0
#define RDRM_RDRM1                      _RDRM.Bits.RDRM1
#define RDRM_RDRM2                      _RDRM.Bits.RDRM2
#define RDRM_RDRM3                      _RDRM.Bits.RDRM3
#define RDRM_RDRM4                      _RDRM.Bits.RDRM4
#define RDRM_RDRM5                      _RDRM.Bits.RDRM5
#define RDRM_RDRM                       _RDRM.MergedBits.grpRDRM

#define RDRM_RDRM0_MASK                 1
#define RDRM_RDRM1_MASK                 2
#define RDRM_RDRM2_MASK                 4
#define RDRM_RDRM3_MASK                 8
#define RDRM_RDRM4_MASK                 16
#define RDRM_RDRM5_MASK                 32
#define RDRM_RDRM_MASK                  %BitsMask
#define RDRM_RDRM_BITNUM                %BitsNum


/*** PERM - Port M Pull Device Enable Register; 0x00000214 ***/
typedef union {
  byte Byte;
  struct {
    byte PERM0       :1;                                       /* Pull Device Enable Port M Bit 0 */
    byte PERM1       :1;                                       /* Pull Device Enable Port M Bit 1 */
    byte PERM2       :1;                                       /* Pull Device Enable Port M Bit 2 */
    byte PERM3       :1;                                       /* Pull Device Enable Port M Bit 3 */
    byte PERM4       :1;                                       /* Pull Device Enable Port M Bit 4 */
    byte PERM5       :1;                                       /* Pull Device Enable Port M Bit 5 */
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpPERM :6;
    byte         :1;
    byte         :1;
  } MergedBits;
} PERMSTR;
extern volatile PERMSTR _PERM @(REG_BASE + 0x00000214);
#define PERM                            _PERM.Byte
#define PERM_PERM0                      _PERM.Bits.PERM0
#define PERM_PERM1                      _PERM.Bits.PERM1
#define PERM_PERM2                      _PERM.Bits.PERM2
#define PERM_PERM3                      _PERM.Bits.PERM3
#define PERM_PERM4                      _PERM.Bits.PERM4
#define PERM_PERM5                      _PERM.Bits.PERM5
#define PERM_PERM                       _PERM.MergedBits.grpPERM

#define PERM_PERM0_MASK                 1
#define PERM_PERM1_MASK                 2
#define PERM_PERM2_MASK                 4
#define PERM_PERM3_MASK                 8
#define PERM_PERM4_MASK                 16
#define PERM_PERM5_MASK                 32
#define PERM_PERM_MASK                  %BitsMask
#define PERM_PERM_BITNUM                %BitsNum


/*** PPSM - Port M Polarity Select Register; 0x00000215 ***/
typedef union {
  byte Byte;
  struct {
    byte PPSM0       :1;                                       /* Pull Select Port M Bit 0 */
    byte PPSM1       :1;                                       /* Pull Select Port M Bit 1 */
    byte PPSM2       :1;                                       /* Pull Select Port M Bit 2 */
    byte PPSM3       :1;                                       /* Pull Select Port M Bit 3 */
    byte PPSM4       :1;                                       /* Pull Select Port M Bit 4 */
    byte PPSM5       :1;                                       /* Pull Select Port M Bit 5 */
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpPPSM :6;
    byte         :1;
    byte         :1;
  } MergedBits;
} PPSMSTR;
extern volatile PPSMSTR _PPSM @(REG_BASE + 0x00000215);
#define PPSM                            _PPSM.Byte
#define PPSM_PPSM0                      _PPSM.Bits.PPSM0
#define PPSM_PPSM1                      _PPSM.Bits.PPSM1
#define PPSM_PPSM2                      _PPSM.Bits.PPSM2
#define PPSM_PPSM3                      _PPSM.Bits.PPSM3
#define PPSM_PPSM4                      _PPSM.Bits.PPSM4
#define PPSM_PPSM5                      _PPSM.Bits.PPSM5
#define PPSM_PPSM                       _PPSM.MergedBits.grpPPSM

#define PPSM_PPSM0_MASK                 1
#define PPSM_PPSM1_MASK                 2
#define PPSM_PPSM2_MASK                 4
#define PPSM_PPSM3_MASK                 8
#define PPSM_PPSM4_MASK                 16
#define PPSM_PPSM5_MASK                 32
#define PPSM_PPSM_MASK                  %BitsMask
#define PPSM_PPSM_BITNUM                %BitsNum


/*** WOMM - Port M Wired-Or Mode Register; 0x00000216 ***/
typedef union {
  byte Byte;
  struct {
    byte WOMM0       :1;                                       /* Wired-Or Mode Port M Bit 0 */
    byte WOMM1       :1;                                       /* Wired-Or Mode Port M Bit 1 */
    byte WOMM2       :1;                                       /* Wired-Or Mode Port M Bit 2 */
    byte WOMM3       :1;                                       /* Wired-Or Mode Port M Bit 3 */
    byte WOMM4       :1;                                       /* Wired-Or Mode Port M Bit 4 */
    byte WOMM5       :1;                                       /* Wired-Or Mode Port M Bit 5 */
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpWOMM :6;
    byte         :1;
    byte         :1;
  } MergedBits;
} WOMMSTR;
extern volatile WOMMSTR _WOMM @(REG_BASE + 0x00000216);
#define WOMM                            _WOMM.Byte
#define WOMM_WOMM0                      _WOMM.Bits.WOMM0
#define WOMM_WOMM1                      _WOMM.Bits.WOMM1
#define WOMM_WOMM2                      _WOMM.Bits.WOMM2
#define WOMM_WOMM3                      _WOMM.Bits.WOMM3
#define WOMM_WOMM4                      _WOMM.Bits.WOMM4
#define WOMM_WOMM5                      _WOMM.Bits.WOMM5
#define WOMM_WOMM                       _WOMM.MergedBits.grpWOMM

#define WOMM_WOMM0_MASK                 1
#define WOMM_WOMM1_MASK                 2
#define WOMM_WOMM2_MASK                 4
#define WOMM_WOMM3_MASK                 8
#define WOMM_WOMM4_MASK                 16
#define WOMM_WOMM5_MASK                 32
#define WOMM_WOMM_MASK                  %BitsMask
#define WOMM_WOMM_BITNUM                %BitsNum


/*** PTP - Port P I/O Register; 0x00000218 ***/
typedef union {
  byte Byte;
  struct {
    byte PTP0        :1;                                       /* Port P Bit 0 */
    byte PTP1        :1;                                       /* Port P Bit 1 */
    byte PTP2        :1;                                       /* Port P Bit 2 */
    byte PTP3        :1;                                       /* Port P Bit 3 */
    byte PTP4        :1;                                       /* Port P Bit 4 */
    byte PTP5        :1;                                       /* Port P Bit 5 */
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpPTP  :6;
    byte         :1;
    byte         :1;
  } MergedBits;
} PTPSTR;
extern volatile PTPSTR _PTP @(REG_BASE + 0x00000218);
#define PTP                             _PTP.Byte
#define PTP_PTP0                        _PTP.Bits.PTP0
#define PTP_PTP1                        _PTP.Bits.PTP1
#define PTP_PTP2                        _PTP.Bits.PTP2
#define PTP_PTP3                        _PTP.Bits.PTP3
#define PTP_PTP4                        _PTP.Bits.PTP4
#define PTP_PTP5                        _PTP.Bits.PTP5
#define PTP_PTP                         _PTP.MergedBits.grpPTP

#define PTP_PTP0_MASK                   1
#define PTP_PTP1_MASK                   2
#define PTP_PTP2_MASK                   4
#define PTP_PTP3_MASK                   8
#define PTP_PTP4_MASK                   16
#define PTP_PTP5_MASK                   32
#define PTP_PTP_MASK                    %BitsMask
#define PTP_PTP_BITNUM                  %BitsNum


/*** PTIP - Port P Input Register; 0x00000219 ***/
typedef union {
  byte Byte;
  struct {
    byte PTIP0       :1;                                       /* Port P Bit 0 */
    byte PTIP1       :1;                                       /* Port P Bit 1 */
    byte PTIP2       :1;                                       /* Port P Bit 2 */
    byte PTIP3       :1;                                       /* Port P Bit 3 */
    byte PTIP4       :1;                                       /* Port P Bit 4 */
    byte PTIP5       :1;                                       /* Port P Bit 5 */
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpPTIP :6;
    byte         :1;
    byte         :1;
  } MergedBits;
} PTIPSTR;
extern volatile PTIPSTR _PTIP @(REG_BASE + 0x00000219);
#define PTIP                            _PTIP.Byte
#define PTIP_PTIP0                      _PTIP.Bits.PTIP0
#define PTIP_PTIP1                      _PTIP.Bits.PTIP1
#define PTIP_PTIP2                      _PTIP.Bits.PTIP2
#define PTIP_PTIP3                      _PTIP.Bits.PTIP3
#define PTIP_PTIP4                      _PTIP.Bits.PTIP4
#define PTIP_PTIP5                      _PTIP.Bits.PTIP5
#define PTIP_PTIP                       _PTIP.MergedBits.grpPTIP

#define PTIP_PTIP0_MASK                 1
#define PTIP_PTIP1_MASK                 2
#define PTIP_PTIP2_MASK                 4
#define PTIP_PTIP3_MASK                 8
#define PTIP_PTIP4_MASK                 16
#define PTIP_PTIP5_MASK                 32
#define PTIP_PTIP_MASK                  %BitsMask
#define PTIP_PTIP_BITNUM                %BitsNum


/*** DDRP - Port P Data Direction Register; 0x0000021A ***/
typedef union {
  byte Byte;
  struct {
    byte DDRP0       :1;                                       /* Data Direction Port P Bit 0 */
    byte DDRP1       :1;                                       /* Data Direction Port P Bit 1 */
    byte DDRP2       :1;                                       /* Data Direction Port P Bit 2 */
    byte DDRP3       :1;                                       /* Data Direction Port P Bit 3 */
    byte DDRP4       :1;                                       /* Data Direction Port P Bit 4 */
    byte DDRP5       :1;                                       /* Data Direction Port P Bit 5 */
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpDDRP :6;
    byte         :1;
    byte         :1;
  } MergedBits;
} DDRPSTR;
extern volatile DDRPSTR _DDRP @(REG_BASE + 0x0000021A);
#define DDRP                            _DDRP.Byte
#define DDRP_DDRP0                      _DDRP.Bits.DDRP0
#define DDRP_DDRP1                      _DDRP.Bits.DDRP1
#define DDRP_DDRP2                      _DDRP.Bits.DDRP2
#define DDRP_DDRP3                      _DDRP.Bits.DDRP3
#define DDRP_DDRP4                      _DDRP.Bits.DDRP4
#define DDRP_DDRP5                      _DDRP.Bits.DDRP5
#define DDRP_DDRP                       _DDRP.MergedBits.grpDDRP

#define DDRP_DDRP0_MASK                 1
#define DDRP_DDRP1_MASK                 2
#define DDRP_DDRP2_MASK                 4
#define DDRP_DDRP3_MASK                 8
#define DDRP_DDRP4_MASK                 16
#define DDRP_DDRP5_MASK                 32
#define DDRP_DDRP_MASK                  %BitsMask
#define DDRP_DDRP_BITNUM                %BitsNum


/*** RDRP - Port P Reduced Drive Register; 0x0000021B ***/
typedef union {
  byte Byte;
  struct {
    byte RDRP0       :1;                                       /* Reduced Drive Port P Bit 0 */
    byte RDRP1       :1;                                       /* Reduced Drive Port P Bit 1 */
    byte RDRP2       :1;                                       /* Reduced Drive Port P Bit 2 */
    byte RDRP3       :1;                                       /* Reduced Drive Port P Bit 3 */
    byte RDRP4       :1;                                       /* Reduced Drive Port P Bit 4 */
    byte RDRP5       :1;                                       /* Reduced Drive Port P Bit 5 */
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpRDRP :6;
    byte         :1;
    byte         :1;
  } MergedBits;
} RDRPSTR;
extern volatile RDRPSTR _RDRP @(REG_BASE + 0x0000021B);
#define RDRP                            _RDRP.Byte
#define RDRP_RDRP0                      _RDRP.Bits.RDRP0
#define RDRP_RDRP1                      _RDRP.Bits.RDRP1
#define RDRP_RDRP2                      _RDRP.Bits.RDRP2
#define RDRP_RDRP3                      _RDRP.Bits.RDRP3
#define RDRP_RDRP4                      _RDRP.Bits.RDRP4
#define RDRP_RDRP5                      _RDRP.Bits.RDRP5
#define RDRP_RDRP                       _RDRP.MergedBits.grpRDRP

#define RDRP_RDRP0_MASK                 1
#define RDRP_RDRP1_MASK                 2
#define RDRP_RDRP2_MASK                 4
#define RDRP_RDRP3_MASK                 8
#define RDRP_RDRP4_MASK                 16
#define RDRP_RDRP5_MASK                 32
#define RDRP_RDRP_MASK                  %BitsMask
#define RDRP_RDRP_BITNUM                %BitsNum


/*** PERP - Port P Pull Device Enable Register; 0x0000021C ***/
typedef union {
  byte Byte;
  struct {
    byte PERP0       :1;                                       /* Pull Device Enable Port P Bit 0 */
    byte PERP1       :1;                                       /* Pull Device Enable Port P Bit 1 */
    byte PERP2       :1;                                       /* Pull Device Enable Port P Bit 2 */
    byte PERP3       :1;                                       /* Pull Device Enable Port P Bit 3 */
    byte PERP4       :1;                                       /* Pull Device Enable Port P Bit 4 */
    byte PERP5       :1;                                       /* Pull Device Enable Port P Bit 5 */
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpPERP :6;
    byte         :1;
    byte         :1;
  } MergedBits;
} PERPSTR;
extern volatile PERPSTR _PERP @(REG_BASE + 0x0000021C);
#define PERP                            _PERP.Byte
#define PERP_PERP0                      _PERP.Bits.PERP0
#define PERP_PERP1                      _PERP.Bits.PERP1
#define PERP_PERP2                      _PERP.Bits.PERP2
#define PERP_PERP3                      _PERP.Bits.PERP3
#define PERP_PERP4                      _PERP.Bits.PERP4
#define PERP_PERP5                      _PERP.Bits.PERP5
#define PERP_PERP                       _PERP.MergedBits.grpPERP

#define PERP_PERP0_MASK                 1
#define PERP_PERP1_MASK                 2
#define PERP_PERP2_MASK                 4
#define PERP_PERP3_MASK                 8
#define PERP_PERP4_MASK                 16
#define PERP_PERP5_MASK                 32
#define PERP_PERP_MASK                  %BitsMask
#define PERP_PERP_BITNUM                %BitsNum


/*** PPSP - Port P Polarity Select Register; 0x0000021D ***/
typedef union {
  byte Byte;
  struct {
    byte PPSP0       :1;                                       /* Pull Select Port P Bit 0 */
    byte PPSP1       :1;                                       /* Pull Select Port P Bit 1 */
    byte PPSP2       :1;                                       /* Pull Select Port P Bit 2 */
    byte PPSP3       :1;                                       /* Pull Select Port P Bit 3 */
    byte PPSP4       :1;                                       /* Pull Select Port P Bit 4 */
    byte PPSP5       :1;                                       /* Pull Select Port P Bit 5 */
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpPPSP :6;
    byte         :1;
    byte         :1;
  } MergedBits;
} PPSPSTR;
extern volatile PPSPSTR _PPSP @(REG_BASE + 0x0000021D);
#define PPSP                            _PPSP.Byte
#define PPSP_PPSP0                      _PPSP.Bits.PPSP0
#define PPSP_PPSP1                      _PPSP.Bits.PPSP1
#define PPSP_PPSP2                      _PPSP.Bits.PPSP2
#define PPSP_PPSP3                      _PPSP.Bits.PPSP3
#define PPSP_PPSP4                      _PPSP.Bits.PPSP4
#define PPSP_PPSP5                      _PPSP.Bits.PPSP5
#define PPSP_PPSP                       _PPSP.MergedBits.grpPPSP

#define PPSP_PPSP0_MASK                 1
#define PPSP_PPSP1_MASK                 2
#define PPSP_PPSP2_MASK                 4
#define PPSP_PPSP3_MASK                 8
#define PPSP_PPSP4_MASK                 16
#define PPSP_PPSP5_MASK                 32
#define PPSP_PPSP_MASK                  %BitsMask
#define PPSP_PPSP_BITNUM                %BitsNum


/*** PTH - Port H I/O Register; 0x00000220 ***/
typedef union {
  byte Byte;
  struct {
    byte PTH0        :1;                                       /* Port H Bit 0 */
    byte PTH1        :1;                                       /* Port H Bit 1 */
    byte PTH2        :1;                                       /* Port H Bit 2 */
    byte PTH3        :1;                                       /* Port H Bit 3 */
    byte PTH4        :1;                                       /* Port H Bit 4 */
    byte PTH5        :1;                                       /* Port H Bit 5 */
    byte PTH6        :1;                                       /* Port H Bit 6 */
    byte PTH7        :1;                                       /* Port H Bit 7 */
  } Bits;
} PTHSTR;
extern volatile PTHSTR _PTH @(REG_BASE + 0x00000220);
#define PTH                             _PTH.Byte
#define PTH_PTH0                        _PTH.Bits.PTH0
#define PTH_PTH1                        _PTH.Bits.PTH1
#define PTH_PTH2                        _PTH.Bits.PTH2
#define PTH_PTH3                        _PTH.Bits.PTH3
#define PTH_PTH4                        _PTH.Bits.PTH4
#define PTH_PTH5                        _PTH.Bits.PTH5
#define PTH_PTH6                        _PTH.Bits.PTH6
#define PTH_PTH7                        _PTH.Bits.PTH7

#define PTH_PTH0_MASK                   1
#define PTH_PTH1_MASK                   2
#define PTH_PTH2_MASK                   4
#define PTH_PTH3_MASK                   8
#define PTH_PTH4_MASK                   16
#define PTH_PTH5_MASK                   32
#define PTH_PTH6_MASK                   64
#define PTH_PTH7_MASK                   128


/*** PTIH - Port H Input Register; 0x00000221 ***/
typedef union {
  byte Byte;
  struct {
    byte PTIH0       :1;                                       /* Port H Bit 0 */
    byte PTIH1       :1;                                       /* Port H Bit 1 */
    byte PTIH2       :1;                                       /* Port H Bit 2 */
    byte PTIH3       :1;                                       /* Port H Bit 3 */
    byte PTIH4       :1;                                       /* Port H Bit 4 */
    byte PTIH5       :1;                                       /* Port H Bit 5 */
    byte PTIH6       :1;                                       /* Port H Bit 6 */
    byte PTIH7       :1;                                       /* Port H Bit 7 */
  } Bits;
} PTIHSTR;
extern volatile PTIHSTR _PTIH @(REG_BASE + 0x00000221);
#define PTIH                            _PTIH.Byte
#define PTIH_PTIH0                      _PTIH.Bits.PTIH0
#define PTIH_PTIH1                      _PTIH.Bits.PTIH1
#define PTIH_PTIH2                      _PTIH.Bits.PTIH2
#define PTIH_PTIH3                      _PTIH.Bits.PTIH3
#define PTIH_PTIH4                      _PTIH.Bits.PTIH4
#define PTIH_PTIH5                      _PTIH.Bits.PTIH5
#define PTIH_PTIH6                      _PTIH.Bits.PTIH6
#define PTIH_PTIH7                      _PTIH.Bits.PTIH7

#define PTIH_PTIH0_MASK                 1
#define PTIH_PTIH1_MASK                 2
#define PTIH_PTIH2_MASK                 4
#define PTIH_PTIH3_MASK                 8
#define PTIH_PTIH4_MASK                 16
#define PTIH_PTIH5_MASK                 32
#define PTIH_PTIH6_MASK                 64
#define PTIH_PTIH7_MASK                 128


/*** DDRH - Port H Data Direction Register; 0x00000222 ***/
typedef union {
  byte Byte;
  struct {
    byte DDRH0       :1;                                       /* Data Direction Port H Bit 0 */
    byte DDRH1       :1;                                       /* Data Direction Port H Bit 1 */
    byte DDRH2       :1;                                       /* Data Direction Port H Bit 2 */
    byte DDRH3       :1;                                       /* Data Direction Port H Bit 3 */
    byte DDRH4       :1;                                       /* Data Direction Port H Bit 4 */
    byte DDRH5       :1;                                       /* Data Direction Port H Bit 5 */
    byte DDRH6       :1;                                       /* Data Direction Port H Bit 6 */
    byte DDRH7       :1;                                       /* Data Direction Port H Bit 7 */
  } Bits;
} DDRHSTR;
extern volatile DDRHSTR _DDRH @(REG_BASE + 0x00000222);
#define DDRH                            _DDRH.Byte
#define DDRH_DDRH0                      _DDRH.Bits.DDRH0
#define DDRH_DDRH1                      _DDRH.Bits.DDRH1
#define DDRH_DDRH2                      _DDRH.Bits.DDRH2
#define DDRH_DDRH3                      _DDRH.Bits.DDRH3
#define DDRH_DDRH4                      _DDRH.Bits.DDRH4
#define DDRH_DDRH5                      _DDRH.Bits.DDRH5
#define DDRH_DDRH6                      _DDRH.Bits.DDRH6
#define DDRH_DDRH7                      _DDRH.Bits.DDRH7

#define DDRH_DDRH0_MASK                 1
#define DDRH_DDRH1_MASK                 2
#define DDRH_DDRH2_MASK                 4
#define DDRH_DDRH3_MASK                 8
#define DDRH_DDRH4_MASK                 16
#define DDRH_DDRH5_MASK                 32
#define DDRH_DDRH6_MASK                 64
#define DDRH_DDRH7_MASK                 128


/*** RDRH - Port H Reduced Drive Register; 0x00000223 ***/
typedef union {
  byte Byte;
  struct {
    byte RDRH0       :1;                                       /* Reduced Drive Port H Bit 0 */
    byte RDRH1       :1;                                       /* Reduced Drive Port H Bit 1 */
    byte RDRH2       :1;                                       /* Reduced Drive Port H Bit 2 */
    byte RDRH3       :1;                                       /* Reduced Drive Port H Bit 3 */
    byte RDRH4       :1;                                       /* Reduced Drive Port H Bit 4 */
    byte RDRH5       :1;                                       /* Reduced Drive Port H Bit 5 */
    byte RDRH6       :1;                                       /* Reduced Drive Port H Bit 6 */
    byte RDRH7       :1;                                       /* Reduced Drive Port H Bit 7 */
  } Bits;
} RDRHSTR;
extern volatile RDRHSTR _RDRH @(REG_BASE + 0x00000223);
#define RDRH                            _RDRH.Byte
#define RDRH_RDRH0                      _RDRH.Bits.RDRH0
#define RDRH_RDRH1                      _RDRH.Bits.RDRH1
#define RDRH_RDRH2                      _RDRH.Bits.RDRH2
#define RDRH_RDRH3                      _RDRH.Bits.RDRH3
#define RDRH_RDRH4                      _RDRH.Bits.RDRH4
#define RDRH_RDRH5                      _RDRH.Bits.RDRH5
#define RDRH_RDRH6                      _RDRH.Bits.RDRH6
#define RDRH_RDRH7                      _RDRH.Bits.RDRH7

#define RDRH_RDRH0_MASK                 1
#define RDRH_RDRH1_MASK                 2
#define RDRH_RDRH2_MASK                 4
#define RDRH_RDRH3_MASK                 8
#define RDRH_RDRH4_MASK                 16
#define RDRH_RDRH5_MASK                 32
#define RDRH_RDRH6_MASK                 64
#define RDRH_RDRH7_MASK                 128


/*** PERH - Port H Pull Device Enable Register; 0x00000224 ***/
typedef union {
  byte Byte;
  struct {
    byte PERH0       :1;                                       /* Pull Device Enable Port H Bit 0 */
    byte PERH1       :1;                                       /* Pull Device Enable Port H Bit 1 */
    byte PERH2       :1;                                       /* Pull Device Enable Port H Bit 2 */
    byte PERH3       :1;                                       /* Pull Device Enable Port H Bit 3 */
    byte PERH4       :1;                                       /* Pull Device Enable Port H Bit 4 */
    byte PERH5       :1;                                       /* Pull Device Enable Port H Bit 5 */
    byte PERH6       :1;                                       /* Pull Device Enable Port H Bit 6 */
    byte PERH7       :1;                                       /* Pull Device Enable Port H Bit 7 */
  } Bits;
} PERHSTR;
extern volatile PERHSTR _PERH @(REG_BASE + 0x00000224);
#define PERH                            _PERH.Byte
#define PERH_PERH0                      _PERH.Bits.PERH0
#define PERH_PERH1                      _PERH.Bits.PERH1
#define PERH_PERH2                      _PERH.Bits.PERH2
#define PERH_PERH3                      _PERH.Bits.PERH3
#define PERH_PERH4                      _PERH.Bits.PERH4
#define PERH_PERH5                      _PERH.Bits.PERH5
#define PERH_PERH6                      _PERH.Bits.PERH6
#define PERH_PERH7                      _PERH.Bits.PERH7

#define PERH_PERH0_MASK                 1
#define PERH_PERH1_MASK                 2
#define PERH_PERH2_MASK                 4
#define PERH_PERH3_MASK                 8
#define PERH_PERH4_MASK                 16
#define PERH_PERH5_MASK                 32
#define PERH_PERH6_MASK                 64
#define PERH_PERH7_MASK                 128


/*** PPSH - Port H Polarity Select Register; 0x00000225 ***/
typedef union {
  byte Byte;
  struct {
    byte PPSH0       :1;                                       /* Pull Select Port H Bit 0 */
    byte PPSH1       :1;                                       /* Pull Select Port H Bit 1 */
    byte PPSH2       :1;                                       /* Pull Select Port H Bit 2 */
    byte PPSH3       :1;                                       /* Pull Select Port H Bit 3 */
    byte PPSH4       :1;                                       /* Pull Select Port H Bit 4 */
    byte PPSH5       :1;                                       /* Pull Select Port H Bit 5 */
    byte PPSH6       :1;                                       /* Pull Select Port H Bit 6 */
    byte PPSH7       :1;                                       /* Pull Select Port H Bit 7 */
  } Bits;
} PPSHSTR;
extern volatile PPSHSTR _PPSH @(REG_BASE + 0x00000225);
#define PPSH                            _PPSH.Byte
#define PPSH_PPSH0                      _PPSH.Bits.PPSH0
#define PPSH_PPSH1                      _PPSH.Bits.PPSH1
#define PPSH_PPSH2                      _PPSH.Bits.PPSH2
#define PPSH_PPSH3                      _PPSH.Bits.PPSH3
#define PPSH_PPSH4                      _PPSH.Bits.PPSH4
#define PPSH_PPSH5                      _PPSH.Bits.PPSH5
#define PPSH_PPSH6                      _PPSH.Bits.PPSH6
#define PPSH_PPSH7                      _PPSH.Bits.PPSH7

#define PPSH_PPSH0_MASK                 1
#define PPSH_PPSH1_MASK                 2
#define PPSH_PPSH2_MASK                 4
#define PPSH_PPSH3_MASK                 8
#define PPSH_PPSH4_MASK                 16
#define PPSH_PPSH5_MASK                 32
#define PPSH_PPSH6_MASK                 64
#define PPSH_PPSH7_MASK                 128


/*** PIEH - Port H Interrupt Enable Register; 0x00000226 ***/
typedef union {
  byte Byte;
  struct {
    byte PIEH0       :1;                                       /* Interrupt Enable Port H Bit 0 */
    byte PIEH1       :1;                                       /* Interrupt Enable Port H Bit 1 */
    byte PIEH2       :1;                                       /* Interrupt Enable Port H Bit 2 */
    byte PIEH3       :1;                                       /* Interrupt Enable Port H Bit 3 */
    byte PIEH4       :1;                                       /* Interrupt Enable Port H Bit 4 */
    byte PIEH5       :1;                                       /* Interrupt Enable Port H Bit 5 */
    byte PIEH6       :1;                                       /* Interrupt Enable Port H Bit 6 */
    byte PIEH7       :1;                                       /* Interrupt Enable Port H Bit 7 */
  } Bits;
} PIEHSTR;
extern volatile PIEHSTR _PIEH @(REG_BASE + 0x00000226);
#define PIEH                            _PIEH.Byte
#define PIEH_PIEH0                      _PIEH.Bits.PIEH0
#define PIEH_PIEH1                      _PIEH.Bits.PIEH1
#define PIEH_PIEH2                      _PIEH.Bits.PIEH2
#define PIEH_PIEH3                      _PIEH.Bits.PIEH3
#define PIEH_PIEH4                      _PIEH.Bits.PIEH4
#define PIEH_PIEH5                      _PIEH.Bits.PIEH5
#define PIEH_PIEH6                      _PIEH.Bits.PIEH6
#define PIEH_PIEH7                      _PIEH.Bits.PIEH7

#define PIEH_PIEH0_MASK                 1
#define PIEH_PIEH1_MASK                 2
#define PIEH_PIEH2_MASK                 4
#define PIEH_PIEH3_MASK                 8
#define PIEH_PIEH4_MASK                 16
#define PIEH_PIEH5_MASK                 32
#define PIEH_PIEH6_MASK                 64
#define PIEH_PIEH7_MASK                 128


/*** PIFH - Port H Interrupt Flag Register; 0x00000227 ***/
typedef union {
  byte Byte;
  struct {
    byte PIFH0       :1;                                       /* Interrupt Flags Port H Bit 0 */
    byte PIFH1       :1;                                       /* Interrupt Flags Port H Bit 1 */
    byte PIFH2       :1;                                       /* Interrupt Flags Port H Bit 2 */
    byte PIFH3       :1;                                       /* Interrupt Flags Port H Bit 3 */
    byte PIFH4       :1;                                       /* Interrupt Flags Port H Bit 4 */
    byte PIFH5       :1;                                       /* Interrupt Flags Port H Bit 5 */
    byte PIFH6       :1;                                       /* Interrupt Flags Port H Bit 6 */
    byte PIFH7       :1;                                       /* Interrupt Flags Port H Bit 7 */
  } Bits;
} PIFHSTR;
extern volatile PIFHSTR _PIFH @(REG_BASE + 0x00000227);
#define PIFH                            _PIFH.Byte
#define PIFH_PIFH0                      _PIFH.Bits.PIFH0
#define PIFH_PIFH1                      _PIFH.Bits.PIFH1
#define PIFH_PIFH2                      _PIFH.Bits.PIFH2
#define PIFH_PIFH3                      _PIFH.Bits.PIFH3
#define PIFH_PIFH4                      _PIFH.Bits.PIFH4
#define PIFH_PIFH5                      _PIFH.Bits.PIFH5
#define PIFH_PIFH6                      _PIFH.Bits.PIFH6
#define PIFH_PIFH7                      _PIFH.Bits.PIFH7

#define PIFH_PIFH0_MASK                 1
#define PIFH_PIFH1_MASK                 2
#define PIFH_PIFH2_MASK                 4
#define PIFH_PIFH3_MASK                 8
#define PIFH_PIFH4_MASK                 16
#define PIFH_PIFH5_MASK                 32
#define PIFH_PIFH6_MASK                 64
#define PIFH_PIFH7_MASK                 128


/*** PTJ - Port J I/O Register; 0x00000228 ***/
typedef union {
  byte Byte;
  struct {
    byte PTJ0        :1;                                       /* Port J Bit 0 */
    byte PTJ1        :1;                                       /* Port J Bit 1 */
    byte PTJ2        :1;                                       /* Port J Bit 2 */
    byte PTJ3        :1;                                       /* Port J Bit 3 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpPTJ  :4;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} PTJSTR;
extern volatile PTJSTR _PTJ @(REG_BASE + 0x00000228);
#define PTJ                             _PTJ.Byte
#define PTJ_PTJ0                        _PTJ.Bits.PTJ0
#define PTJ_PTJ1                        _PTJ.Bits.PTJ1
#define PTJ_PTJ2                        _PTJ.Bits.PTJ2
#define PTJ_PTJ3                        _PTJ.Bits.PTJ3
#define PTJ_PTJ                         _PTJ.MergedBits.grpPTJ

#define PTJ_PTJ0_MASK                   1
#define PTJ_PTJ1_MASK                   2
#define PTJ_PTJ2_MASK                   4
#define PTJ_PTJ3_MASK                   8
#define PTJ_PTJ_MASK                    %BitsMask
#define PTJ_PTJ_BITNUM                  %BitsNum


/*** PTIJ - Port J Input Register; 0x00000229 ***/
typedef union {
  byte Byte;
  struct {
    byte PTIJ0       :1;                                       /* Port J Bit 0 */
    byte PTIJ1       :1;                                       /* Port J Bit 1 */
    byte PTIJ2       :1;                                       /* Port J Bit 2 */
    byte PTIJ3       :1;                                       /* Port J Bit 3 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpPTIJ :4;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} PTIJSTR;
extern volatile PTIJSTR _PTIJ @(REG_BASE + 0x00000229);
#define PTIJ                            _PTIJ.Byte
#define PTIJ_PTIJ0                      _PTIJ.Bits.PTIJ0
#define PTIJ_PTIJ1                      _PTIJ.Bits.PTIJ1
#define PTIJ_PTIJ2                      _PTIJ.Bits.PTIJ2
#define PTIJ_PTIJ3                      _PTIJ.Bits.PTIJ3
#define PTIJ_PTIJ                       _PTIJ.MergedBits.grpPTIJ

#define PTIJ_PTIJ0_MASK                 1
#define PTIJ_PTIJ1_MASK                 2
#define PTIJ_PTIJ2_MASK                 4
#define PTIJ_PTIJ3_MASK                 8
#define PTIJ_PTIJ_MASK                  %BitsMask
#define PTIJ_PTIJ_BITNUM                %BitsNum


/*** DDRJ - Port J Data Direction Register; 0x0000022A ***/
typedef union {
  byte Byte;
  struct {
    byte DDRJ0       :1;                                       /* Data Direction Port J Bit 0 */
    byte DDRJ1       :1;                                       /* Data Direction Port J Bit 1 */
    byte DDRJ2       :1;                                       /* Data Direction Port J Bit 2 */
    byte DDRJ3       :1;                                       /* Data Direction Port J Bit 3 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpDDRJ :4;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} DDRJSTR;
extern volatile DDRJSTR _DDRJ @(REG_BASE + 0x0000022A);
#define DDRJ                            _DDRJ.Byte
#define DDRJ_DDRJ0                      _DDRJ.Bits.DDRJ0
#define DDRJ_DDRJ1                      _DDRJ.Bits.DDRJ1
#define DDRJ_DDRJ2                      _DDRJ.Bits.DDRJ2
#define DDRJ_DDRJ3                      _DDRJ.Bits.DDRJ3
#define DDRJ_DDRJ                       _DDRJ.MergedBits.grpDDRJ

#define DDRJ_DDRJ0_MASK                 1
#define DDRJ_DDRJ1_MASK                 2
#define DDRJ_DDRJ2_MASK                 4
#define DDRJ_DDRJ3_MASK                 8
#define DDRJ_DDRJ_MASK                  %BitsMask
#define DDRJ_DDRJ_BITNUM                %BitsNum


/*** RDRJ - Port J Reduced Drive Register; 0x0000022B ***/
typedef union {
  byte Byte;
  struct {
    byte RDRJ0       :1;                                       /* Reduced Drive Port J Bit 0 */
    byte RDRJ1       :1;                                       /* Reduced Drive Port J Bit 1 */
    byte RDRJ2       :1;                                       /* Reduced Drive Port J Bit 2 */
    byte RDRJ3       :1;                                       /* Reduced Drive Port J Bit 3 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpRDRJ :4;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} RDRJSTR;
extern volatile RDRJSTR _RDRJ @(REG_BASE + 0x0000022B);
#define RDRJ                            _RDRJ.Byte
#define RDRJ_RDRJ0                      _RDRJ.Bits.RDRJ0
#define RDRJ_RDRJ1                      _RDRJ.Bits.RDRJ1
#define RDRJ_RDRJ2                      _RDRJ.Bits.RDRJ2
#define RDRJ_RDRJ3                      _RDRJ.Bits.RDRJ3
#define RDRJ_RDRJ                       _RDRJ.MergedBits.grpRDRJ

#define RDRJ_RDRJ0_MASK                 1
#define RDRJ_RDRJ1_MASK                 2
#define RDRJ_RDRJ2_MASK                 4
#define RDRJ_RDRJ3_MASK                 8
#define RDRJ_RDRJ_MASK                  %BitsMask
#define RDRJ_RDRJ_BITNUM                %BitsNum


/*** PERJ - Port J Pull Device Enable Register; 0x0000022C ***/
typedef union {
  byte Byte;
  struct {
    byte PERJ0       :1;                                       /* Pull Device Enable Port J Bit 0 */
    byte PERJ1       :1;                                       /* Pull Device Enable Port J Bit 1 */
    byte PERJ2       :1;                                       /* Pull Device Enable Port J Bit 2 */
    byte PERJ3       :1;                                       /* Pull Device Enable Port J Bit 3 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpPERJ :4;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} PERJSTR;
extern volatile PERJSTR _PERJ @(REG_BASE + 0x0000022C);
#define PERJ                            _PERJ.Byte
#define PERJ_PERJ0                      _PERJ.Bits.PERJ0
#define PERJ_PERJ1                      _PERJ.Bits.PERJ1
#define PERJ_PERJ2                      _PERJ.Bits.PERJ2
#define PERJ_PERJ3                      _PERJ.Bits.PERJ3
#define PERJ_PERJ                       _PERJ.MergedBits.grpPERJ

#define PERJ_PERJ0_MASK                 1
#define PERJ_PERJ1_MASK                 2
#define PERJ_PERJ2_MASK                 4
#define PERJ_PERJ3_MASK                 8
#define PERJ_PERJ_MASK                  %BitsMask
#define PERJ_PERJ_BITNUM                %BitsNum


/*** PPSJ - Port J Polarity Select Register; 0x0000022D ***/
typedef union {
  byte Byte;
  struct {
    byte PPSJ0       :1;                                       /* Pull Select Port J Bit 0 */
    byte PPSJ1       :1;                                       /* Pull Select Port J Bit 1 */
    byte PPSJ2       :1;                                       /* Pull Select Port J Bit 2 */
    byte PPSJ3       :1;                                       /* Pull Select Port J Bit 3 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpPPSJ :4;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} PPSJSTR;
extern volatile PPSJSTR _PPSJ @(REG_BASE + 0x0000022D);
#define PPSJ                            _PPSJ.Byte
#define PPSJ_PPSJ0                      _PPSJ.Bits.PPSJ0
#define PPSJ_PPSJ1                      _PPSJ.Bits.PPSJ1
#define PPSJ_PPSJ2                      _PPSJ.Bits.PPSJ2
#define PPSJ_PPSJ3                      _PPSJ.Bits.PPSJ3
#define PPSJ_PPSJ                       _PPSJ.MergedBits.grpPPSJ

#define PPSJ_PPSJ0_MASK                 1
#define PPSJ_PPSJ1_MASK                 2
#define PPSJ_PPSJ2_MASK                 4
#define PPSJ_PPSJ3_MASK                 8
#define PPSJ_PPSJ_MASK                  %BitsMask
#define PPSJ_PPSJ_BITNUM                %BitsNum


/*** PIEJ - Port J Interrupt Enable Register; 0x0000022E ***/
typedef union {
  byte Byte;
  struct {
    byte PIEJ0       :1;                                       /* Interrupt Enable Port J Bit 0 */
    byte PIEJ1       :1;                                       /* Interrupt Enable Port J Bit 1 */
    byte PIEJ2       :1;                                       /* Interrupt Enable Port J Bit 2 */
    byte PIEJ3       :1;                                       /* Interrupt Enable Port J Bit 3 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpPIEJ :4;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} PIEJSTR;
extern volatile PIEJSTR _PIEJ @(REG_BASE + 0x0000022E);
#define PIEJ                            _PIEJ.Byte
#define PIEJ_PIEJ0                      _PIEJ.Bits.PIEJ0
#define PIEJ_PIEJ1                      _PIEJ.Bits.PIEJ1
#define PIEJ_PIEJ2                      _PIEJ.Bits.PIEJ2
#define PIEJ_PIEJ3                      _PIEJ.Bits.PIEJ3
#define PIEJ_PIEJ                       _PIEJ.MergedBits.grpPIEJ

#define PIEJ_PIEJ0_MASK                 1
#define PIEJ_PIEJ1_MASK                 2
#define PIEJ_PIEJ2_MASK                 4
#define PIEJ_PIEJ3_MASK                 8
#define PIEJ_PIEJ_MASK                  %BitsMask
#define PIEJ_PIEJ_BITNUM                %BitsNum


/*** PIFJ - Port J Interrupt Flag Register; 0x0000022F ***/
typedef union {
  byte Byte;
  struct {
    byte PIFJ0       :1;                                       /* Interrupt Flags Port J Bit 0 */
    byte PIFJ1       :1;                                       /* Interrupt Flags Port J Bit 1 */
    byte PIFJ2       :1;                                       /* Interrupt Flags Port J Bit 2 */
    byte PIFJ3       :1;                                       /* Interrupt Flags Port J Bit 3 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpPIFJ :4;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} PIFJSTR;
extern volatile PIFJSTR _PIFJ @(REG_BASE + 0x0000022F);
#define PIFJ                            _PIFJ.Byte
#define PIFJ_PIFJ0                      _PIFJ.Bits.PIFJ0
#define PIFJ_PIFJ1                      _PIFJ.Bits.PIFJ1
#define PIFJ_PIFJ2                      _PIFJ.Bits.PIFJ2
#define PIFJ_PIFJ3                      _PIFJ.Bits.PIFJ3
#define PIFJ_PIFJ                       _PIFJ.MergedBits.grpPIFJ

#define PIFJ_PIFJ0_MASK                 1
#define PIFJ_PIFJ1_MASK                 2
#define PIFJ_PIFJ2_MASK                 4
#define PIFJ_PIFJ3_MASK                 8
#define PIFJ_PIFJ_MASK                  %BitsMask
#define PIFJ_PIFJ_BITNUM                %BitsNum


/*** PTL - Port L I/O Register; 0x00000230 ***/
typedef union {
  byte Byte;
  struct {
    byte PTL0        :1;                                       /* Port L Bit 0 */
    byte PTL1        :1;                                       /* Port L Bit 1 */
    byte PTL2        :1;                                       /* Port L Bit 2 */
    byte PTL3        :1;                                       /* Port L Bit 3 */
    byte PTL4        :1;                                       /* Port L Bit 4 */
    byte PTL5        :1;                                       /* Port L Bit 5 */
    byte PTL6        :1;                                       /* Port L Bit 6 */
    byte PTL7        :1;                                       /* Port L Bit 7 */
  } Bits;
} PTLSTR;
extern volatile PTLSTR _PTL @(REG_BASE + 0x00000230);
#define PTL                             _PTL.Byte
#define PTL_PTL0                        _PTL.Bits.PTL0
#define PTL_PTL1                        _PTL.Bits.PTL1
#define PTL_PTL2                        _PTL.Bits.PTL2
#define PTL_PTL3                        _PTL.Bits.PTL3
#define PTL_PTL4                        _PTL.Bits.PTL4
#define PTL_PTL5                        _PTL.Bits.PTL5
#define PTL_PTL6                        _PTL.Bits.PTL6
#define PTL_PTL7                        _PTL.Bits.PTL7

#define PTL_PTL0_MASK                   1
#define PTL_PTL1_MASK                   2
#define PTL_PTL2_MASK                   4
#define PTL_PTL3_MASK                   8
#define PTL_PTL4_MASK                   16
#define PTL_PTL5_MASK                   32
#define PTL_PTL6_MASK                   64
#define PTL_PTL7_MASK                   128


/*** PTIL - Port L Input Register; 0x00000231 ***/
typedef union {
  byte Byte;
  struct {
    byte PTIL0       :1;                                       /* Port L Bit 0 */
    byte PTIL1       :1;                                       /* Port L Bit 1 */
    byte PTIL2       :1;                                       /* Port L Bit 2 */
    byte PTIL3       :1;                                       /* Port L Bit 3 */
    byte PTIL4       :1;                                       /* Port L Bit 4 */
    byte PTIL5       :1;                                       /* Port L Bit 5 */
    byte PTIL6       :1;                                       /* Port L Bit 6 */
    byte PTIL7       :1;                                       /* Port L Bit 7 */
  } Bits;
} PTILSTR;
extern volatile PTILSTR _PTIL @(REG_BASE + 0x00000231);
#define PTIL                            _PTIL.Byte
#define PTIL_PTIL0                      _PTIL.Bits.PTIL0
#define PTIL_PTIL1                      _PTIL.Bits.PTIL1
#define PTIL_PTIL2                      _PTIL.Bits.PTIL2
#define PTIL_PTIL3                      _PTIL.Bits.PTIL3
#define PTIL_PTIL4                      _PTIL.Bits.PTIL4
#define PTIL_PTIL5                      _PTIL.Bits.PTIL5
#define PTIL_PTIL6                      _PTIL.Bits.PTIL6
#define PTIL_PTIL7                      _PTIL.Bits.PTIL7

#define PTIL_PTIL0_MASK                 1
#define PTIL_PTIL1_MASK                 2
#define PTIL_PTIL2_MASK                 4
#define PTIL_PTIL3_MASK                 8
#define PTIL_PTIL4_MASK                 16
#define PTIL_PTIL5_MASK                 32
#define PTIL_PTIL6_MASK                 64
#define PTIL_PTIL7_MASK                 128


/*** DDRL - Port L Data Direction Register; 0x00000232 ***/
typedef union {
  byte Byte;
  struct {
    byte DDRL0       :1;                                       /* Data Direction Port L Bit 0 */
    byte DDRL1       :1;                                       /* Data Direction Port L Bit 1 */
    byte DDRL2       :1;                                       /* Data Direction Port L Bit 2 */
    byte DDRL3       :1;                                       /* Data Direction Port L Bit 3 */
    byte DDRL4       :1;                                       /* Data Direction Port L Bit 4 */
    byte DDRL5       :1;                                       /* Data Direction Port L Bit 5 */
    byte DDRL6       :1;                                       /* Data Direction Port L Bit 6 */
    byte DDRL7       :1;                                       /* Data Direction Port L Bit 7 */
  } Bits;
} DDRLSTR;
extern volatile DDRLSTR _DDRL @(REG_BASE + 0x00000232);
#define DDRL                            _DDRL.Byte
#define DDRL_DDRL0                      _DDRL.Bits.DDRL0
#define DDRL_DDRL1                      _DDRL.Bits.DDRL1
#define DDRL_DDRL2                      _DDRL.Bits.DDRL2
#define DDRL_DDRL3                      _DDRL.Bits.DDRL3
#define DDRL_DDRL4                      _DDRL.Bits.DDRL4
#define DDRL_DDRL5                      _DDRL.Bits.DDRL5
#define DDRL_DDRL6                      _DDRL.Bits.DDRL6
#define DDRL_DDRL7                      _DDRL.Bits.DDRL7

#define DDRL_DDRL0_MASK                 1
#define DDRL_DDRL1_MASK                 2
#define DDRL_DDRL2_MASK                 4
#define DDRL_DDRL3_MASK                 8
#define DDRL_DDRL4_MASK                 16
#define DDRL_DDRL5_MASK                 32
#define DDRL_DDRL6_MASK                 64
#define DDRL_DDRL7_MASK                 128


/*** RDRL - Port L Reduced Drive Register; 0x00000233 ***/
typedef union {
  byte Byte;
  struct {
    byte RDRL0       :1;                                       /* Reduced Drive Port L Bit 0 */
    byte RDRL1       :1;                                       /* Reduced Drive Port L Bit 1 */
    byte RDRL2       :1;                                       /* Reduced Drive Port L Bit 2 */
    byte RDRL3       :1;                                       /* Reduced Drive Port L Bit 3 */
    byte RDRL4       :1;                                       /* Reduced Drive Port L Bit 4 */
    byte RDRL5       :1;                                       /* Reduced Drive Port L Bit 5 */
    byte RDRL6       :1;                                       /* Reduced Drive Port L Bit 6 */
    byte RDRL7       :1;                                       /* Reduced Drive Port L Bit 7 */
  } Bits;
} RDRLSTR;
extern volatile RDRLSTR _RDRL @(REG_BASE + 0x00000233);
#define RDRL                            _RDRL.Byte
#define RDRL_RDRL0                      _RDRL.Bits.RDRL0
#define RDRL_RDRL1                      _RDRL.Bits.RDRL1
#define RDRL_RDRL2                      _RDRL.Bits.RDRL2
#define RDRL_RDRL3                      _RDRL.Bits.RDRL3
#define RDRL_RDRL4                      _RDRL.Bits.RDRL4
#define RDRL_RDRL5                      _RDRL.Bits.RDRL5
#define RDRL_RDRL6                      _RDRL.Bits.RDRL6
#define RDRL_RDRL7                      _RDRL.Bits.RDRL7

#define RDRL_RDRL0_MASK                 1
#define RDRL_RDRL1_MASK                 2
#define RDRL_RDRL2_MASK                 4
#define RDRL_RDRL3_MASK                 8
#define RDRL_RDRL4_MASK                 16
#define RDRL_RDRL5_MASK                 32
#define RDRL_RDRL6_MASK                 64
#define RDRL_RDRL7_MASK                 128


/*** PERL - Port L Pull Device Enable Register; 0x00000234 ***/
typedef union {
  byte Byte;
  struct {
    byte PERL0       :1;                                       /* Pull Device Enable Port L Bit 0 */
    byte PERL1       :1;                                       /* Pull Device Enable Port L Bit 1 */
    byte PERL2       :1;                                       /* Pull Device Enable Port L Bit 2 */
    byte PERL3       :1;                                       /* Pull Device Enable Port L Bit 3 */
    byte PERL4       :1;                                       /* Pull Device Enable Port L Bit 4 */
    byte PERL5       :1;                                       /* Pull Device Enable Port L Bit 5 */
    byte PERL6       :1;                                       /* Pull Device Enable Port L Bit 6 */
    byte PERL7       :1;                                       /* Pull Device Enable Port L Bit 7 */
  } Bits;
} PERLSTR;
extern volatile PERLSTR _PERL @(REG_BASE + 0x00000234);
#define PERL                            _PERL.Byte
#define PERL_PERL0                      _PERL.Bits.PERL0
#define PERL_PERL1                      _PERL.Bits.PERL1
#define PERL_PERL2                      _PERL.Bits.PERL2
#define PERL_PERL3                      _PERL.Bits.PERL3
#define PERL_PERL4                      _PERL.Bits.PERL4
#define PERL_PERL5                      _PERL.Bits.PERL5
#define PERL_PERL6                      _PERL.Bits.PERL6
#define PERL_PERL7                      _PERL.Bits.PERL7

#define PERL_PERL0_MASK                 1
#define PERL_PERL1_MASK                 2
#define PERL_PERL2_MASK                 4
#define PERL_PERL3_MASK                 8
#define PERL_PERL4_MASK                 16
#define PERL_PERL5_MASK                 32
#define PERL_PERL6_MASK                 64
#define PERL_PERL7_MASK                 128


/*** PPSL - Port L Polarity Select Register; 0x00000235 ***/
typedef union {
  byte Byte;
  struct {
    byte PPSL0       :1;                                       /* Pull Select Port L Bit 0 */
    byte PPSL1       :1;                                       /* Pull Select Port L Bit 1 */
    byte PPSL2       :1;                                       /* Pull Select Port L Bit 2 */
    byte PPSL3       :1;                                       /* Pull Select Port L Bit 3 */
    byte PPSL4       :1;                                       /* Pull Select Port L Bit 4 */
    byte PPSL5       :1;                                       /* Pull Select Port L Bit 5 */
    byte PPSL6       :1;                                       /* Pull Select Port L Bit 6 */
    byte PPSL7       :1;                                       /* Pull Select Port L Bit 7 */
  } Bits;
} PPSLSTR;
extern volatile PPSLSTR _PPSL @(REG_BASE + 0x00000235);
#define PPSL                            _PPSL.Byte
#define PPSL_PPSL0                      _PPSL.Bits.PPSL0
#define PPSL_PPSL1                      _PPSL.Bits.PPSL1
#define PPSL_PPSL2                      _PPSL.Bits.PPSL2
#define PPSL_PPSL3                      _PPSL.Bits.PPSL3
#define PPSL_PPSL4                      _PPSL.Bits.PPSL4
#define PPSL_PPSL5                      _PPSL.Bits.PPSL5
#define PPSL_PPSL6                      _PPSL.Bits.PPSL6
#define PPSL_PPSL7                      _PPSL.Bits.PPSL7

#define PPSL_PPSL0_MASK                 1
#define PPSL_PPSL1_MASK                 2
#define PPSL_PPSL2_MASK                 4
#define PPSL_PPSL3_MASK                 8
#define PPSL_PPSL4_MASK                 16
#define PPSL_PPSL5_MASK                 32
#define PPSL_PPSL6_MASK                 64
#define PPSL_PPSL7_MASK                 128


/*** PTU - Port U I/O Register; 0x00000238 ***/
typedef union {
  byte Byte;
  struct {
    byte PTU0        :1;                                       /* Port U Bit 0 */
    byte PTU1        :1;                                       /* Port U Bit 1 */
    byte PTU2        :1;                                       /* Port U Bit 2 */
    byte PTU3        :1;                                       /* Port U Bit 3 */
    byte PTU4        :1;                                       /* Port U Bit 4 */
    byte PTU5        :1;                                       /* Port U Bit 5 */
    byte PTU6        :1;                                       /* Port U Bit 6 */
    byte PTU7        :1;                                       /* Port U Bit 7 */
  } Bits;
} PTUSTR;
extern volatile PTUSTR _PTU @(REG_BASE + 0x00000238);
#define PTU                             _PTU.Byte
#define PTU_PTU0                        _PTU.Bits.PTU0
#define PTU_PTU1                        _PTU.Bits.PTU1
#define PTU_PTU2                        _PTU.Bits.PTU2
#define PTU_PTU3                        _PTU.Bits.PTU3
#define PTU_PTU4                        _PTU.Bits.PTU4
#define PTU_PTU5                        _PTU.Bits.PTU5
#define PTU_PTU6                        _PTU.Bits.PTU6
#define PTU_PTU7                        _PTU.Bits.PTU7

#define PTU_PTU0_MASK                   1
#define PTU_PTU1_MASK                   2
#define PTU_PTU2_MASK                   4
#define PTU_PTU3_MASK                   8
#define PTU_PTU4_MASK                   16
#define PTU_PTU5_MASK                   32
#define PTU_PTU6_MASK                   64
#define PTU_PTU7_MASK                   128


/*** PTIU - Port U Input Register; 0x00000239 ***/
typedef union {
  byte Byte;
  struct {
    byte PTIU0       :1;                                       /* Port U Bit 0 */
    byte PTIU1       :1;                                       /* Port U Bit 1 */
    byte PTIU2       :1;                                       /* Port U Bit 2 */
    byte PTIU3       :1;                                       /* Port U Bit 3 */
    byte PTIU4       :1;                                       /* Port U Bit 4 */
    byte PTIU5       :1;                                       /* Port U Bit 5 */
    byte PTIU6       :1;                                       /* Port U Bit 6 */
    byte PTIU7       :1;                                       /* Port U Bit 7 */
  } Bits;
} PTIUSTR;
extern volatile PTIUSTR _PTIU @(REG_BASE + 0x00000239);
#define PTIU                            _PTIU.Byte
#define PTIU_PTIU0                      _PTIU.Bits.PTIU0
#define PTIU_PTIU1                      _PTIU.Bits.PTIU1
#define PTIU_PTIU2                      _PTIU.Bits.PTIU2
#define PTIU_PTIU3                      _PTIU.Bits.PTIU3
#define PTIU_PTIU4                      _PTIU.Bits.PTIU4
#define PTIU_PTIU5                      _PTIU.Bits.PTIU5
#define PTIU_PTIU6                      _PTIU.Bits.PTIU6
#define PTIU_PTIU7                      _PTIU.Bits.PTIU7

#define PTIU_PTIU0_MASK                 1
#define PTIU_PTIU1_MASK                 2
#define PTIU_PTIU2_MASK                 4
#define PTIU_PTIU3_MASK                 8
#define PTIU_PTIU4_MASK                 16
#define PTIU_PTIU5_MASK                 32
#define PTIU_PTIU6_MASK                 64
#define PTIU_PTIU7_MASK                 128


/*** DDRU - Port U Data Direction Register; 0x0000023A ***/
typedef union {
  byte Byte;
  struct {
    byte DDRU0       :1;                                       /* Data Direction Port U Bit 0 */
    byte DDRU1       :1;                                       /* Data Direction Port U Bit 1 */
    byte DDRU2       :1;                                       /* Data Direction Port U Bit 2 */
    byte DDRU3       :1;                                       /* Data Direction Port U Bit 3 */
    byte DDRU4       :1;                                       /* Data Direction Port U Bit 4 */
    byte DDRU5       :1;                                       /* Data Direction Port U Bit 5 */
    byte DDRU6       :1;                                       /* Data Direction Port U Bit 6 */
    byte DDRU7       :1;                                       /* Data Direction Port U Bit 7 */
  } Bits;
} DDRUSTR;
extern volatile DDRUSTR _DDRU @(REG_BASE + 0x0000023A);
#define DDRU                            _DDRU.Byte
#define DDRU_DDRU0                      _DDRU.Bits.DDRU0
#define DDRU_DDRU1                      _DDRU.Bits.DDRU1
#define DDRU_DDRU2                      _DDRU.Bits.DDRU2
#define DDRU_DDRU3                      _DDRU.Bits.DDRU3
#define DDRU_DDRU4                      _DDRU.Bits.DDRU4
#define DDRU_DDRU5                      _DDRU.Bits.DDRU5
#define DDRU_DDRU6                      _DDRU.Bits.DDRU6
#define DDRU_DDRU7                      _DDRU.Bits.DDRU7

#define DDRU_DDRU0_MASK                 1
#define DDRU_DDRU1_MASK                 2
#define DDRU_DDRU2_MASK                 4
#define DDRU_DDRU3_MASK                 8
#define DDRU_DDRU4_MASK                 16
#define DDRU_DDRU5_MASK                 32
#define DDRU_DDRU6_MASK                 64
#define DDRU_DDRU7_MASK                 128


/*** SRRU - Port U Slew Rate Register; 0x0000023B ***/
typedef union {
  byte Byte;
  struct {
    byte SRRU0       :1;                                       /* Slew Rate Port U Bit 0 */
    byte SRRU1       :1;                                       /* Slew Rate Port U Bit 1 */
    byte SRRU2       :1;                                       /* Slew Rate Port U Bit 2 */
    byte SRRU3       :1;                                       /* Slew Rate Port U Bit 3 */
    byte SRRU4       :1;                                       /* Slew Rate Port U Bit 4 */
    byte SRRU5       :1;                                       /* Slew Rate Port U Bit 5 */
    byte SRRU6       :1;                                       /* Slew Rate Port U Bit 6 */
    byte SRRU7       :1;                                       /* Slew Rate Port U Bit 7 */
  } Bits;
} SRRUSTR;
extern volatile SRRUSTR _SRRU @(REG_BASE + 0x0000023B);
#define SRRU                            _SRRU.Byte
#define SRRU_SRRU0                      _SRRU.Bits.SRRU0
#define SRRU_SRRU1                      _SRRU.Bits.SRRU1
#define SRRU_SRRU2                      _SRRU.Bits.SRRU2
#define SRRU_SRRU3                      _SRRU.Bits.SRRU3
#define SRRU_SRRU4                      _SRRU.Bits.SRRU4
#define SRRU_SRRU5                      _SRRU.Bits.SRRU5
#define SRRU_SRRU6                      _SRRU.Bits.SRRU6
#define SRRU_SRRU7                      _SRRU.Bits.SRRU7

#define SRRU_SRRU0_MASK                 1
#define SRRU_SRRU1_MASK                 2
#define SRRU_SRRU2_MASK                 4
#define SRRU_SRRU3_MASK                 8
#define SRRU_SRRU4_MASK                 16
#define SRRU_SRRU5_MASK                 32
#define SRRU_SRRU6_MASK                 64
#define SRRU_SRRU7_MASK                 128


/*** PERU - Port U Pull Device Enable Register; 0x0000023C ***/
typedef union {
  byte Byte;
  struct {
    byte PERU0       :1;                                       /* Pull Device Enable Port U Bit 0 */
    byte PERU1       :1;                                       /* Pull Device Enable Port U Bit 1 */
    byte PERU2       :1;                                       /* Pull Device Enable Port U Bit 2 */
    byte PERU3       :1;                                       /* Pull Device Enable Port U Bit 3 */
    byte PERU4       :1;                                       /* Pull Device Enable Port U Bit 4 */
    byte PERU5       :1;                                       /* Pull Device Enable Port U Bit 5 */
    byte PERU6       :1;                                       /* Pull Device Enable Port U Bit 6 */
    byte PERU7       :1;                                       /* Pull Device Enable Port U Bit 7 */
  } Bits;
} PERUSTR;
extern volatile PERUSTR _PERU @(REG_BASE + 0x0000023C);
#define PERU                            _PERU.Byte
#define PERU_PERU0                      _PERU.Bits.PERU0
#define PERU_PERU1                      _PERU.Bits.PERU1
#define PERU_PERU2                      _PERU.Bits.PERU2
#define PERU_PERU3                      _PERU.Bits.PERU3
#define PERU_PERU4                      _PERU.Bits.PERU4
#define PERU_PERU5                      _PERU.Bits.PERU5
#define PERU_PERU6                      _PERU.Bits.PERU6
#define PERU_PERU7                      _PERU.Bits.PERU7

#define PERU_PERU0_MASK                 1
#define PERU_PERU1_MASK                 2
#define PERU_PERU2_MASK                 4
#define PERU_PERU3_MASK                 8
#define PERU_PERU4_MASK                 16
#define PERU_PERU5_MASK                 32
#define PERU_PERU6_MASK                 64
#define PERU_PERU7_MASK                 128


/*** PPSU - Port U Polarity Select Register; 0x0000023D ***/
typedef union {
  byte Byte;
  struct {
    byte PPSU0       :1;                                       /* Pull Select Port U Bit 0 */
    byte PPSU1       :1;                                       /* Pull Select Port U Bit 1 */
    byte PPSU2       :1;                                       /* Pull Select Port U Bit 2 */
    byte PPSU3       :1;                                       /* Pull Select Port U Bit 3 */
    byte PPSU4       :1;                                       /* Pull Select Port U Bit 4 */
    byte PPSU5       :1;                                       /* Pull Select Port U Bit 5 */
    byte PPSU6       :1;                                       /* Pull Select Port U Bit 6 */
    byte PPSU7       :1;                                       /* Pull Select Port U Bit 7 */
  } Bits;
} PPSUSTR;
extern volatile PPSUSTR _PPSU @(REG_BASE + 0x0000023D);
#define PPSU                            _PPSU.Byte
#define PPSU_PPSU0                      _PPSU.Bits.PPSU0
#define PPSU_PPSU1                      _PPSU.Bits.PPSU1
#define PPSU_PPSU2                      _PPSU.Bits.PPSU2
#define PPSU_PPSU3                      _PPSU.Bits.PPSU3
#define PPSU_PPSU4                      _PPSU.Bits.PPSU4
#define PPSU_PPSU5                      _PPSU.Bits.PPSU5
#define PPSU_PPSU6                      _PPSU.Bits.PPSU6
#define PPSU_PPSU7                      _PPSU.Bits.PPSU7

#define PPSU_PPSU0_MASK                 1
#define PPSU_PPSU1_MASK                 2
#define PPSU_PPSU2_MASK                 4
#define PPSU_PPSU3_MASK                 8
#define PPSU_PPSU4_MASK                 16
#define PPSU_PPSU5_MASK                 32
#define PPSU_PPSU6_MASK                 64
#define PPSU_PPSU7_MASK                 128


/*** PTV - Port V I/O Register; 0x00000240 ***/
typedef union {
  byte Byte;
  struct {
    byte PTV0        :1;                                       /* Port V Bit 0 */
    byte PTV1        :1;                                       /* Port V Bit 1 */
    byte PTV2        :1;                                       /* Port V Bit 2 */
    byte PTV3        :1;                                       /* Port V Bit 3 */
    byte PTV4        :1;                                       /* Port V Bit 4 */
    byte PTV5        :1;                                       /* Port V Bit 5 */
    byte PTV6        :1;                                       /* Port V Bit 6 */
    byte PTV7        :1;                                       /* Port V Bit 7 */
  } Bits;
} PTVSTR;
extern volatile PTVSTR _PTV @(REG_BASE + 0x00000240);
#define PTV                             _PTV.Byte
#define PTV_PTV0                        _PTV.Bits.PTV0
#define PTV_PTV1                        _PTV.Bits.PTV1
#define PTV_PTV2                        _PTV.Bits.PTV2
#define PTV_PTV3                        _PTV.Bits.PTV3
#define PTV_PTV4                        _PTV.Bits.PTV4
#define PTV_PTV5                        _PTV.Bits.PTV5
#define PTV_PTV6                        _PTV.Bits.PTV6
#define PTV_PTV7                        _PTV.Bits.PTV7

#define PTV_PTV0_MASK                   1
#define PTV_PTV1_MASK                   2
#define PTV_PTV2_MASK                   4
#define PTV_PTV3_MASK                   8
#define PTV_PTV4_MASK                   16
#define PTV_PTV5_MASK                   32
#define PTV_PTV6_MASK                   64
#define PTV_PTV7_MASK                   128


/*** PTIV - Port V Input Register; 0x00000241 ***/
typedef union {
  byte Byte;
  struct {
    byte PTIV0       :1;                                       /* Port V Bit 0 */
    byte PTIV1       :1;                                       /* Port V Bit 1 */
    byte PTIV2       :1;                                       /* Port V Bit 2 */
    byte PTIV3       :1;                                       /* Port V Bit 3 */
    byte PTIV4       :1;                                       /* Port V Bit 4 */
    byte PTIV5       :1;                                       /* Port V Bit 5 */
    byte PTIV6       :1;                                       /* Port V Bit 6 */
    byte PTIV7       :1;                                       /* Port V Bit 7 */
  } Bits;
} PTIVSTR;
extern volatile PTIVSTR _PTIV @(REG_BASE + 0x00000241);
#define PTIV                            _PTIV.Byte
#define PTIV_PTIV0                      _PTIV.Bits.PTIV0
#define PTIV_PTIV1                      _PTIV.Bits.PTIV1
#define PTIV_PTIV2                      _PTIV.Bits.PTIV2
#define PTIV_PTIV3                      _PTIV.Bits.PTIV3
#define PTIV_PTIV4                      _PTIV.Bits.PTIV4
#define PTIV_PTIV5                      _PTIV.Bits.PTIV5
#define PTIV_PTIV6                      _PTIV.Bits.PTIV6
#define PTIV_PTIV7                      _PTIV.Bits.PTIV7

#define PTIV_PTIV0_MASK                 1
#define PTIV_PTIV1_MASK                 2
#define PTIV_PTIV2_MASK                 4
#define PTIV_PTIV3_MASK                 8
#define PTIV_PTIV4_MASK                 16
#define PTIV_PTIV5_MASK                 32
#define PTIV_PTIV6_MASK                 64
#define PTIV_PTIV7_MASK                 128


/*** DDRV - Port V Data Direction Register; 0x00000242 ***/
typedef union {
  byte Byte;
  struct {
    byte DDRV0       :1;                                       /* Data Direction Port V Bit 0 */
    byte DDRV1       :1;                                       /* Data Direction Port V Bit 1 */
    byte DDRV2       :1;                                       /* Data Direction Port V Bit 2 */
    byte DDRV3       :1;                                       /* Data Direction Port V Bit 3 */
    byte DDRV4       :1;                                       /* Data Direction Port V Bit 4 */
    byte DDRV5       :1;                                       /* Data Direction Port V Bit 5 */
    byte DDRV6       :1;                                       /* Data Direction Port V Bit 6 */
    byte DDRV7       :1;                                       /* Data Direction Port V Bit 7 */
  } Bits;
} DDRVSTR;
extern volatile DDRVSTR _DDRV @(REG_BASE + 0x00000242);
#define DDRV                            _DDRV.Byte
#define DDRV_DDRV0                      _DDRV.Bits.DDRV0
#define DDRV_DDRV1                      _DDRV.Bits.DDRV1
#define DDRV_DDRV2                      _DDRV.Bits.DDRV2
#define DDRV_DDRV3                      _DDRV.Bits.DDRV3
#define DDRV_DDRV4                      _DDRV.Bits.DDRV4
#define DDRV_DDRV5                      _DDRV.Bits.DDRV5
#define DDRV_DDRV6                      _DDRV.Bits.DDRV6
#define DDRV_DDRV7                      _DDRV.Bits.DDRV7

#define DDRV_DDRV0_MASK                 1
#define DDRV_DDRV1_MASK                 2
#define DDRV_DDRV2_MASK                 4
#define DDRV_DDRV3_MASK                 8
#define DDRV_DDRV4_MASK                 16
#define DDRV_DDRV5_MASK                 32
#define DDRV_DDRV6_MASK                 64
#define DDRV_DDRV7_MASK                 128


/*** SRRV - Port V Reduced Drive Register; 0x00000243 ***/
typedef union {
  byte Byte;
  struct {
    byte SRRV0       :1;                                       /* Slew Rate Port V Bit 0 */
    byte SRRV1       :1;                                       /* Slew Rate Port V Bit 1 */
    byte SRRV2       :1;                                       /* Slew Rate Port V Bit 2 */
    byte SRRV3       :1;                                       /* Slew Rate Port V Bit 3 */
    byte SRRV4       :1;                                       /* Slew Rate Port V Bit 4 */
    byte SRRV5       :1;                                       /* Slew Rate Port V Bit 5 */
    byte SRRV6       :1;                                       /* Slew Rate Port V Bit 6 */
    byte SRRV7       :1;                                       /* Slew Rate Port V Bit 7 */
  } Bits;
} SRRVSTR;
extern volatile SRRVSTR _SRRV @(REG_BASE + 0x00000243);
#define SRRV                            _SRRV.Byte
#define SRRV_SRRV0                      _SRRV.Bits.SRRV0
#define SRRV_SRRV1                      _SRRV.Bits.SRRV1
#define SRRV_SRRV2                      _SRRV.Bits.SRRV2
#define SRRV_SRRV3                      _SRRV.Bits.SRRV3
#define SRRV_SRRV4                      _SRRV.Bits.SRRV4
#define SRRV_SRRV5                      _SRRV.Bits.SRRV5
#define SRRV_SRRV6                      _SRRV.Bits.SRRV6
#define SRRV_SRRV7                      _SRRV.Bits.SRRV7

#define SRRV_SRRV0_MASK                 1
#define SRRV_SRRV1_MASK                 2
#define SRRV_SRRV2_MASK                 4
#define SRRV_SRRV3_MASK                 8
#define SRRV_SRRV4_MASK                 16
#define SRRV_SRRV5_MASK                 32
#define SRRV_SRRV6_MASK                 64
#define SRRV_SRRV7_MASK                 128


/*** PERV - Port V Pull Device Enable Register; 0x00000244 ***/
typedef union {
  byte Byte;
  struct {
    byte PERV0       :1;                                       /* Pull Device Enable Port V Bit 0 */
    byte PERV1       :1;                                       /* Pull Device Enable Port V Bit 1 */
    byte PERV2       :1;                                       /* Pull Device Enable Port V Bit 2 */
    byte PERV3       :1;                                       /* Pull Device Enable Port V Bit 3 */
    byte PERV4       :1;                                       /* Pull Device Enable Port V Bit 4 */
    byte PERV5       :1;                                       /* Pull Device Enable Port V Bit 5 */
    byte PERV6       :1;                                       /* Pull Device Enable Port V Bit 6 */
    byte PERV7       :1;                                       /* Pull Device Enable Port V Bit 7 */
  } Bits;
} PERVSTR;
extern volatile PERVSTR _PERV @(REG_BASE + 0x00000244);
#define PERV                            _PERV.Byte
#define PERV_PERV0                      _PERV.Bits.PERV0
#define PERV_PERV1                      _PERV.Bits.PERV1
#define PERV_PERV2                      _PERV.Bits.PERV2
#define PERV_PERV3                      _PERV.Bits.PERV3
#define PERV_PERV4                      _PERV.Bits.PERV4
#define PERV_PERV5                      _PERV.Bits.PERV5
#define PERV_PERV6                      _PERV.Bits.PERV6
#define PERV_PERV7                      _PERV.Bits.PERV7

#define PERV_PERV0_MASK                 1
#define PERV_PERV1_MASK                 2
#define PERV_PERV2_MASK                 4
#define PERV_PERV3_MASK                 8
#define PERV_PERV4_MASK                 16
#define PERV_PERV5_MASK                 32
#define PERV_PERV6_MASK                 64
#define PERV_PERV7_MASK                 128


/*** PPSV - Port V Polarity Select Register; 0x00000245 ***/
typedef union {
  byte Byte;
  struct {
    byte PPSV0       :1;                                       /* Pull Select Port V Bit 0 */
    byte PPSV1       :1;                                       /* Pull Select Port V Bit 1 */
    byte PPSV2       :1;                                       /* Pull Select Port V Bit 2 */
    byte PPSV3       :1;                                       /* Pull Select Port V Bit 3 */
    byte PPSV4       :1;                                       /* Pull Select Port V Bit 4 */
    byte PPSV5       :1;                                       /* Pull Select Port V Bit 5 */
    byte PPSV6       :1;                                       /* Pull Select Port V Bit 6 */
    byte PPSV7       :1;                                       /* Pull Select Port V Bit 7 */
  } Bits;
} PPSVSTR;
extern volatile PPSVSTR _PPSV @(REG_BASE + 0x00000245);
#define PPSV                            _PPSV.Byte
#define PPSV_PPSV0                      _PPSV.Bits.PPSV0
#define PPSV_PPSV1                      _PPSV.Bits.PPSV1
#define PPSV_PPSV2                      _PPSV.Bits.PPSV2
#define PPSV_PPSV3                      _PPSV.Bits.PPSV3
#define PPSV_PPSV4                      _PPSV.Bits.PPSV4
#define PPSV_PPSV5                      _PPSV.Bits.PPSV5
#define PPSV_PPSV6                      _PPSV.Bits.PPSV6
#define PPSV_PPSV7                      _PPSV.Bits.PPSV7

#define PPSV_PPSV0_MASK                 1
#define PPSV_PPSV1_MASK                 2
#define PPSV_PPSV2_MASK                 4
#define PPSV_PPSV3_MASK                 8
#define PPSV_PPSV4_MASK                 16
#define PPSV_PPSV5_MASK                 32
#define PPSV_PPSV6_MASK                 64
#define PPSV_PPSV7_MASK                 128


/*** PTW - Port W I/O Register; 0x00000248 ***/
typedef union {
  byte Byte;
  struct {
    byte PTW0        :1;                                       /* Port W Bit 0 */
    byte PTW1        :1;                                       /* Port W Bit 1 */
    byte PTW2        :1;                                       /* Port W Bit 2 */
    byte PTW3        :1;                                       /* Port W Bit 3 */
    byte PTW4        :1;                                       /* Port W Bit 4 */
    byte PTW5        :1;                                       /* Port W Bit 5 */
    byte PTW6        :1;                                       /* Port W Bit 6 */
    byte PTW7        :1;                                       /* Port W Bit 7 */
  } Bits;
} PTWSTR;
extern volatile PTWSTR _PTW @(REG_BASE + 0x00000248);
#define PTW                             _PTW.Byte
#define PTW_PTW0                        _PTW.Bits.PTW0
#define PTW_PTW1                        _PTW.Bits.PTW1
#define PTW_PTW2                        _PTW.Bits.PTW2
#define PTW_PTW3                        _PTW.Bits.PTW3
#define PTW_PTW4                        _PTW.Bits.PTW4
#define PTW_PTW5                        _PTW.Bits.PTW5
#define PTW_PTW6                        _PTW.Bits.PTW6
#define PTW_PTW7                        _PTW.Bits.PTW7

#define PTW_PTW0_MASK                   1
#define PTW_PTW1_MASK                   2
#define PTW_PTW2_MASK                   4
#define PTW_PTW3_MASK                   8
#define PTW_PTW4_MASK                   16
#define PTW_PTW5_MASK                   32
#define PTW_PTW6_MASK                   64
#define PTW_PTW7_MASK                   128


/*** PTIW - Port W Input Register; 0x00000249 ***/
typedef union {
  byte Byte;
  struct {
    byte PTIW0       :1;                                       /* Port W Bit 0 */
    byte PTIW1       :1;                                       /* Port W Bit 1 */
    byte PTIW2       :1;                                       /* Port W Bit 2 */
    byte PTIW3       :1;                                       /* Port W Bit 3 */
    byte PTIW4       :1;                                       /* Port W Bit 4 */
    byte PTIW5       :1;                                       /* Port W Bit 5 */
    byte PTIW6       :1;                                       /* Port W Bit 6 */
    byte PTIW7       :1;                                       /* Port W Bit 7 */
  } Bits;
} PTIWSTR;
extern volatile PTIWSTR _PTIW @(REG_BASE + 0x00000249);
#define PTIW                            _PTIW.Byte
#define PTIW_PTIW0                      _PTIW.Bits.PTIW0
#define PTIW_PTIW1                      _PTIW.Bits.PTIW1
#define PTIW_PTIW2                      _PTIW.Bits.PTIW2
#define PTIW_PTIW3                      _PTIW.Bits.PTIW3
#define PTIW_PTIW4                      _PTIW.Bits.PTIW4
#define PTIW_PTIW5                      _PTIW.Bits.PTIW5
#define PTIW_PTIW6                      _PTIW.Bits.PTIW6
#define PTIW_PTIW7                      _PTIW.Bits.PTIW7

#define PTIW_PTIW0_MASK                 1
#define PTIW_PTIW1_MASK                 2
#define PTIW_PTIW2_MASK                 4
#define PTIW_PTIW3_MASK                 8
#define PTIW_PTIW4_MASK                 16
#define PTIW_PTIW5_MASK                 32
#define PTIW_PTIW6_MASK                 64
#define PTIW_PTIW7_MASK                 128


/*** DDRW - Port W Data Direction Register; 0x0000024A ***/
typedef union {
  byte Byte;
  struct {
    byte DDRW0       :1;                                       /* Data Direction Port W Bit 0 */
    byte DDRW1       :1;                                       /* Data Direction Port W Bit 1 */
    byte DDRW2       :1;                                       /* Data Direction Port W Bit 2 */
    byte DDRW3       :1;                                       /* Data Direction Port W Bit 3 */
    byte DDRW4       :1;                                       /* Data Direction Port W Bit 4 */
    byte DDRW5       :1;                                       /* Data Direction Port W Bit 5 */
    byte DDRW6       :1;                                       /* Data Direction Port W Bit 6 */
    byte DDRW7       :1;                                       /* Data Direction Port W Bit 7 */
  } Bits;
} DDRWSTR;
extern volatile DDRWSTR _DDRW @(REG_BASE + 0x0000024A);
#define DDRW                            _DDRW.Byte
#define DDRW_DDRW0                      _DDRW.Bits.DDRW0
#define DDRW_DDRW1                      _DDRW.Bits.DDRW1
#define DDRW_DDRW2                      _DDRW.Bits.DDRW2
#define DDRW_DDRW3                      _DDRW.Bits.DDRW3
#define DDRW_DDRW4                      _DDRW.Bits.DDRW4
#define DDRW_DDRW5                      _DDRW.Bits.DDRW5
#define DDRW_DDRW6                      _DDRW.Bits.DDRW6
#define DDRW_DDRW7                      _DDRW.Bits.DDRW7

#define DDRW_DDRW0_MASK                 1
#define DDRW_DDRW1_MASK                 2
#define DDRW_DDRW2_MASK                 4
#define DDRW_DDRW3_MASK                 8
#define DDRW_DDRW4_MASK                 16
#define DDRW_DDRW5_MASK                 32
#define DDRW_DDRW6_MASK                 64
#define DDRW_DDRW7_MASK                 128


/*** SRRW - Port W Reduced Drive Register; 0x0000024B ***/
typedef union {
  byte Byte;
  struct {
    byte SRRW0       :1;                                       /* Slew Rate Port W Bit 0 */
    byte SRRW1       :1;                                       /* Slew Rate Port W Bit 1 */
    byte SRRW2       :1;                                       /* Slew Rate Port W Bit 2 */
    byte SRRW3       :1;                                       /* Slew Rate Port W Bit 3 */
    byte SRRW4       :1;                                       /* Slew Rate Port W Bit 4 */
    byte SRRW5       :1;                                       /* Slew Rate Port W Bit 5 */
    byte SRRW6       :1;                                       /* Slew Rate Port W Bit 6 */
    byte SRRW7       :1;                                       /* Slew Rate Port W Bit 7 */
  } Bits;
} SRRWSTR;
extern volatile SRRWSTR _SRRW @(REG_BASE + 0x0000024B);
#define SRRW                            _SRRW.Byte
#define SRRW_SRRW0                      _SRRW.Bits.SRRW0
#define SRRW_SRRW1                      _SRRW.Bits.SRRW1
#define SRRW_SRRW2                      _SRRW.Bits.SRRW2
#define SRRW_SRRW3                      _SRRW.Bits.SRRW3
#define SRRW_SRRW4                      _SRRW.Bits.SRRW4
#define SRRW_SRRW5                      _SRRW.Bits.SRRW5
#define SRRW_SRRW6                      _SRRW.Bits.SRRW6
#define SRRW_SRRW7                      _SRRW.Bits.SRRW7

#define SRRW_SRRW0_MASK                 1
#define SRRW_SRRW1_MASK                 2
#define SRRW_SRRW2_MASK                 4
#define SRRW_SRRW3_MASK                 8
#define SRRW_SRRW4_MASK                 16
#define SRRW_SRRW5_MASK                 32
#define SRRW_SRRW6_MASK                 64
#define SRRW_SRRW7_MASK                 128


/*** PERW - Port W Pull Device Enable Register; 0x0000024C ***/
typedef union {
  byte Byte;
  struct {
    byte PERW0       :1;                                       /* Pull Device Enable Port W Bit 0 */
    byte PERW1       :1;                                       /* Pull Device Enable Port W Bit 1 */
    byte PERW2       :1;                                       /* Pull Device Enable Port W Bit 2 */
    byte PERW3       :1;                                       /* Pull Device Enable Port W Bit 3 */
    byte PERW4       :1;                                       /* Pull Device Enable Port W Bit 4 */
    byte PERW5       :1;                                       /* Pull Device Enable Port W Bit 5 */
    byte PERW6       :1;                                       /* Pull Device Enable Port W Bit 6 */
    byte PERW7       :1;                                       /* Pull Device Enable Port W Bit 7 */
  } Bits;
} PERWSTR;
extern volatile PERWSTR _PERW @(REG_BASE + 0x0000024C);
#define PERW                            _PERW.Byte
#define PERW_PERW0                      _PERW.Bits.PERW0
#define PERW_PERW1                      _PERW.Bits.PERW1
#define PERW_PERW2                      _PERW.Bits.PERW2
#define PERW_PERW3                      _PERW.Bits.PERW3
#define PERW_PERW4                      _PERW.Bits.PERW4
#define PERW_PERW5                      _PERW.Bits.PERW5
#define PERW_PERW6                      _PERW.Bits.PERW6
#define PERW_PERW7                      _PERW.Bits.PERW7

#define PERW_PERW0_MASK                 1
#define PERW_PERW1_MASK                 2
#define PERW_PERW2_MASK                 4
#define PERW_PERW3_MASK                 8
#define PERW_PERW4_MASK                 16
#define PERW_PERW5_MASK                 32
#define PERW_PERW6_MASK                 64
#define PERW_PERW7_MASK                 128


/*** PPSW - Port W Polarity Select Register; 0x0000024D ***/
typedef union {
  byte Byte;
  struct {
    byte PPSW0       :1;                                       /* Pull Select Port W Bit 0 */
    byte PPSW1       :1;                                       /* Pull Select Port W Bit 1 */
    byte PPSW2       :1;                                       /* Pull Select Port W Bit 2 */
    byte PPSW3       :1;                                       /* Pull Select Port W Bit 3 */
    byte PPSW4       :1;                                       /* Pull Select Port W Bit 4 */
    byte PPSW5       :1;                                       /* Pull Select Port W Bit 5 */
    byte PPSW6       :1;                                       /* Pull Select Port W Bit 6 */
    byte PPSW7       :1;                                       /* Pull Select Port W Bit 7 */
  } Bits;
} PPSWSTR;
extern volatile PPSWSTR _PPSW @(REG_BASE + 0x0000024D);
#define PPSW                            _PPSW.Byte
#define PPSW_PPSW0                      _PPSW.Bits.PPSW0
#define PPSW_PPSW1                      _PPSW.Bits.PPSW1
#define PPSW_PPSW2                      _PPSW.Bits.PPSW2
#define PPSW_PPSW3                      _PPSW.Bits.PPSW3
#define PPSW_PPSW4                      _PPSW.Bits.PPSW4
#define PPSW_PPSW5                      _PPSW.Bits.PPSW5
#define PPSW_PPSW6                      _PPSW.Bits.PPSW6
#define PPSW_PPSW7                      _PPSW.Bits.PPSW7

#define PPSW_PPSW0_MASK                 1
#define PPSW_PPSW1_MASK                 2
#define PPSW_PPSW2_MASK                 4
#define PPSW_PPSW3_MASK                 8
#define PPSW_PPSW4_MASK                 16
#define PPSW_PPSW5_MASK                 32
#define PPSW_PPSW6_MASK                 64
#define PPSW_PPSW7_MASK                 128


  /* Watchdog reset macro */
#ifdef _lint
  #define __RESET_WATCHDOG()  /* empty */
#else
  #define __RESET_WATCHDOG() (void)(ARMCOP = 0x55, ARMCOP = 0xAA)  /* Just write a byte to feed the dog */
#endif


#endif

