; Based on CPU DB MC9S12GA240_100, version 3.00.024 (RegistersPrg V2.33)

; ###################################################################
;     Filename  : mc9s12ga192.inc
;     Processor : MC9S12GA192CLL
;     FileFormat: V2.33
;     DataSheet : MC9S12GRMV1 Rev. 1.23 February 1, 2013
;     Compiler  : CodeWarrior compiler
;     Date/Time : 5/3/2013, 7:25 PM
;     Abstract  :
;         This header implements the mapping of I/O devices.
;
;     Copyright : 1997 - 2011 Freescale Semiconductor, Inc. All Rights Reserved.
;     
;     http      : www.freescale.com
;     mail      : support@freescale.com
;
;     CPU Registers Revisions:
;      - 4.30.2013, V3.00.001:
;              - Initial revision bassed on MC9S12GRMV1 Rev.1.23 February 1, 2013
;
;     File-Format-Revisions:
;               - none
;
;     Not all general-purpose I/O pins are available on all packages or on all mask sets of a specific
;     derivative device. To avoid extra current drain from floating input pins, the users reset
;     initialization routine in the application program must either enable on-chip pull-up devices
;     or change the direction of unconnected pins to outputs so the pins do not float.
; ###################################################################

;*** Memory Map and Interrupt Vectors
;******************************************
RAMStart:           equ   $00001400
RAMEnd:             equ   $00003FFF
DFLASHStart:        equ   $00000400
DFLASHEnd:          equ   $000013FF
ROM_4000Start:      equ   $00004000
ROM_4000End:        equ   $00007FFF
ROM_C000Start:      equ   $0000C000
ROM_C000End:        equ   $0000FEFF
PAGE_04Start:       equ   $00010000
PAGE_04End:         equ   $00013FFF
PAGE_05Start:       equ   $00014000
PAGE_05End:         equ   $00017FFF
PAGE_06Start:       equ   $00018000
PAGE_06End:         equ   $0001BFFF
PAGE_07Start:       equ   $0001C000
PAGE_07End:         equ   $0001FFFF
PAGE_08Start:       equ   $00020000
PAGE_08End:         equ   $00023FFF
PAGE_09Start:       equ   $00024000
PAGE_09End:         equ   $00027FFF
PAGE_0AStart:       equ   $00028000
PAGE_0AEnd:         equ   $0002BFFF
PAGE_0BStart:       equ   $0002C000
PAGE_0BEnd:         equ   $0002FFFF
PAGE_0CStart:       equ   $00030000
PAGE_0CEnd:         equ   $00033FFF
PAGE_0EStart:       equ   $00038000
PAGE_0EEnd:         equ   $0003BFFF
;
Vsi:                equ   $0000FF80
Vportad:            equ   $0000FF82
Vatdcompare:        equ   $0000FF84
VReserved60:        equ   $0000FF86
Vapi:               equ   $0000FF88
Vlvi:               equ   $0000FF8A
VReserved57:        equ   $0000FF8C
Vportp:             equ   $0000FF8E
VReserved55:        equ   $0000FF90
VReserved54:        equ   $0000FF92
VReserved53:        equ   $0000FF94
VReserved52:        equ   $0000FF96
VReserved51:        equ   $0000FF98
VReserved50:        equ   $0000FF9A
VReserved49:        equ   $0000FF9C
VReserved48:        equ   $0000FF9E
VReserved47:        equ   $0000FFA0
VReserved46:        equ   $0000FFA2
VReserved45:        equ   $0000FFA4
VReserved44:        equ   $0000FFA6
VReserved43:        equ   $0000FFA8
VReserved42:        equ   $0000FFAA
VReserved41:        equ   $0000FFAC
VReserved40:        equ   $0000FFAE
Vcantx:             equ   $0000FFB0
Vcanrx:             equ   $0000FFB2
Vcanerr:            equ   $0000FFB4
Vcanwkup:           equ   $0000FFB6
Vflash:             equ   $0000FFB8
Vflashfd:           equ   $0000FFBA
Vspi2:              equ   $0000FFBC
Vspi1:              equ   $0000FFBE
VReserved31:        equ   $0000FFC0
Vsci2:              equ   $0000FFC2
VReserved29:        equ   $0000FFC4
Vcpmuplllck:        equ   $0000FFC6
Vcpmuocsns:         equ   $0000FFC8
VReserved26:        equ   $0000FFCA
VReserved25:        equ   $0000FFCC
Vportj:             equ   $0000FFCE
VReserved23:        equ   $0000FFD0
Vatd:               equ   $0000FFD2
Vsci1:              equ   $0000FFD4
Vsci0:              equ   $0000FFD6
Vspi0:              equ   $0000FFD8
Vtimpaie:           equ   $0000FFDA
Vtimpaaovf:         equ   $0000FFDC
Vtimovf:            equ   $0000FFDE
Vtimch7:            equ   $0000FFE0
Vtimch6:            equ   $0000FFE2
Vtimch5:            equ   $0000FFE4
Vtimch4:            equ   $0000FFE6
Vtimch3:            equ   $0000FFE8
Vtimch2:            equ   $0000FFEA
Vtimch1:            equ   $0000FFEC
Vtimch0:            equ   $0000FFEE
Vrti:               equ   $0000FFF0
Virq:               equ   $0000FFF2
Vxirq:              equ   $0000FFF4
Vswi:               equ   $0000FFF6
Vtrap:              equ   $0000FFF8
Vcop:               equ   $0000FFFA
Vclkmon:            equ   $0000FFFC
Vreset:             equ   $0000FFFE
;


;*** PORTAB - Port AB Data Register; 0x00000000 ***
PORTAB:             equ    $00000000                                ;*** PORTAB - Port AB Data Register; 0x00000000 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PORTAB_PB0:         equ    0                                         ; Port B Bit 0
PORTAB_PB1:         equ    1                                         ; Port B Bit 1
PORTAB_PB2:         equ    2                                         ; Port B Bit 2
PORTAB_PB3:         equ    3                                         ; Port B Bit 3
PORTAB_PB4:         equ    4                                         ; Port B Bit 4
PORTAB_PB5:         equ    5                                         ; Port B Bit 5
PORTAB_PB6:         equ    6                                         ; Port B Bit 6
PORTAB_PB7:         equ    7                                         ; Port B Bit 7
PORTAB_PA0:         equ    8                                         ; Port A Bit 0
PORTAB_PA1:         equ    9                                         ; Port A Bit 1
PORTAB_PA2:         equ    10                                        ; Port A Bit 2
PORTAB_PA3:         equ    11                                        ; Port A Bit 3
PORTAB_PA4:         equ    12                                        ; Port A Bit 4
PORTAB_PA5:         equ    13                                        ; Port A Bit 5
PORTAB_PA6:         equ    14                                        ; Port A Bit 6
PORTAB_PA7:         equ    15                                        ; Port A Bit 7
; bit position masks
mPORTAB_PB0:        equ    %00000001
mPORTAB_PB1:        equ    %00000010
mPORTAB_PB2:        equ    %00000100
mPORTAB_PB3:        equ    %00001000
mPORTAB_PB4:        equ    %00010000
mPORTAB_PB5:        equ    %00100000
mPORTAB_PB6:        equ    %01000000
mPORTAB_PB7:        equ    %10000000
mPORTAB_PA0:        equ    %100000000
mPORTAB_PA1:        equ    %1000000000
mPORTAB_PA2:        equ    %10000000000
mPORTAB_PA3:        equ    %100000000000
mPORTAB_PA4:        equ    %1000000000000
mPORTAB_PA5:        equ    %10000000000000
mPORTAB_PA6:        equ    %100000000000000
mPORTAB_PA7:        equ    %1000000000000000


;*** PORTA - Port A Data Register; 0x00000000 ***
PORTA:              equ    $00000000                                ;*** PORTA - Port A Data Register; 0x00000000 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PORTA_PA0:          equ    0                                         ; Port A Bit 0
PORTA_PA1:          equ    1                                         ; Port A Bit 1
PORTA_PA2:          equ    2                                         ; Port A Bit 2
PORTA_PA3:          equ    3                                         ; Port A Bit 3
PORTA_PA4:          equ    4                                         ; Port A Bit 4
PORTA_PA5:          equ    5                                         ; Port A Bit 5
PORTA_PA6:          equ    6                                         ; Port A Bit 6
PORTA_PA7:          equ    7                                         ; Port A Bit 7
; bit position masks
mPORTA_PA0:         equ    %00000001
mPORTA_PA1:         equ    %00000010
mPORTA_PA2:         equ    %00000100
mPORTA_PA3:         equ    %00001000
mPORTA_PA4:         equ    %00010000
mPORTA_PA5:         equ    %00100000
mPORTA_PA6:         equ    %01000000
mPORTA_PA7:         equ    %10000000


;*** PORTB - Port B Data Register; 0x00000001 ***
PORTB:              equ    $00000001                                ;*** PORTB - Port B Data Register; 0x00000001 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PORTB_PB0:          equ    0                                         ; Port B Bit 0
PORTB_PB1:          equ    1                                         ; Port B Bit 1
PORTB_PB2:          equ    2                                         ; Port B Bit 2
PORTB_PB3:          equ    3                                         ; Port B Bit 3
PORTB_PB4:          equ    4                                         ; Port B Bit 4
PORTB_PB5:          equ    5                                         ; Port B Bit 5
PORTB_PB6:          equ    6                                         ; Port B Bit 6
PORTB_PB7:          equ    7                                         ; Port B Bit 7
; bit position masks
mPORTB_PB0:         equ    %00000001
mPORTB_PB1:         equ    %00000010
mPORTB_PB2:         equ    %00000100
mPORTB_PB3:         equ    %00001000
mPORTB_PB4:         equ    %00010000
mPORTB_PB5:         equ    %00100000
mPORTB_PB6:         equ    %01000000
mPORTB_PB7:         equ    %10000000


;*** DDRAB - Port AB Data Direction Register; 0x00000002 ***
DDRAB:              equ    $00000002                                ;*** DDRAB - Port AB Data Direction Register; 0x00000002 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRAB_DDRB0:        equ    0                                         ; Data Direction Port B Bit 0
DDRAB_DDRB1:        equ    1                                         ; Data Direction Port B Bit 1
DDRAB_DDRB2:        equ    2                                         ; Data Direction Port B Bit 2
DDRAB_DDRB3:        equ    3                                         ; Data Direction Port B Bit 3
DDRAB_DDRB4:        equ    4                                         ; Data Direction Port B Bit 4
DDRAB_DDRB5:        equ    5                                         ; Data Direction Port B Bit 5
DDRAB_DDRB6:        equ    6                                         ; Data Direction Port B Bit 6
DDRAB_DDRB7:        equ    7                                         ; Data Direction Port B Bit 7
DDRAB_DDRA0:        equ    8                                         ; Data Direction Port A Bit 0
DDRAB_DDRA1:        equ    9                                         ; Data Direction Port A Bit 1
DDRAB_DDRA2:        equ    10                                        ; Data Direction Port A Bit 2
DDRAB_DDRA3:        equ    11                                        ; Data Direction Port A Bit 3
DDRAB_DDRA4:        equ    12                                        ; Data Direction Port A Bit 4
DDRAB_DDRA5:        equ    13                                        ; Data Direction Port A Bit 5
DDRAB_DDRA6:        equ    14                                        ; Data Direction Port A Bit 6
DDRAB_DDRA7:        equ    15                                        ; Data Direction Port A Bit 7
; bit position masks
mDDRAB_DDRB0:       equ    %00000001
mDDRAB_DDRB1:       equ    %00000010
mDDRAB_DDRB2:       equ    %00000100
mDDRAB_DDRB3:       equ    %00001000
mDDRAB_DDRB4:       equ    %00010000
mDDRAB_DDRB5:       equ    %00100000
mDDRAB_DDRB6:       equ    %01000000
mDDRAB_DDRB7:       equ    %10000000
mDDRAB_DDRA0:       equ    %100000000
mDDRAB_DDRA1:       equ    %1000000000
mDDRAB_DDRA2:       equ    %10000000000
mDDRAB_DDRA3:       equ    %100000000000
mDDRAB_DDRA4:       equ    %1000000000000
mDDRAB_DDRA5:       equ    %10000000000000
mDDRAB_DDRA6:       equ    %100000000000000
mDDRAB_DDRA7:       equ    %1000000000000000


;*** DDRA - Port A Data Direction Register; 0x00000002 ***
DDRA:               equ    $00000002                                ;*** DDRA - Port A Data Direction Register; 0x00000002 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRA_DDRA0:         equ    0                                         ; Data Direction Port A Bit 0
DDRA_DDRA1:         equ    1                                         ; Data Direction Port A Bit 1
DDRA_DDRA2:         equ    2                                         ; Data Direction Port A Bit 2
DDRA_DDRA3:         equ    3                                         ; Data Direction Port A Bit 3
DDRA_DDRA4:         equ    4                                         ; Data Direction Port A Bit 4
DDRA_DDRA5:         equ    5                                         ; Data Direction Port A Bit 5
DDRA_DDRA6:         equ    6                                         ; Data Direction Port A Bit 6
DDRA_DDRA7:         equ    7                                         ; Data Direction Port A Bit 7
; bit position masks
mDDRA_DDRA0:        equ    %00000001
mDDRA_DDRA1:        equ    %00000010
mDDRA_DDRA2:        equ    %00000100
mDDRA_DDRA3:        equ    %00001000
mDDRA_DDRA4:        equ    %00010000
mDDRA_DDRA5:        equ    %00100000
mDDRA_DDRA6:        equ    %01000000
mDDRA_DDRA7:        equ    %10000000


;*** DDRB - Port B Data Direction Register; 0x00000003 ***
DDRB:               equ    $00000003                                ;*** DDRB - Port B Data Direction Register; 0x00000003 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRB_DDRB0:         equ    0                                         ; Data Direction Port B Bit 0
DDRB_DDRB1:         equ    1                                         ; Data Direction Port B Bit 1
DDRB_DDRB2:         equ    2                                         ; Data Direction Port B Bit 2
DDRB_DDRB3:         equ    3                                         ; Data Direction Port B Bit 3
DDRB_DDRB4:         equ    4                                         ; Data Direction Port B Bit 4
DDRB_DDRB5:         equ    5                                         ; Data Direction Port B Bit 5
DDRB_DDRB6:         equ    6                                         ; Data Direction Port B Bit 6
DDRB_DDRB7:         equ    7                                         ; Data Direction Port B Bit 7
; bit position masks
mDDRB_DDRB0:        equ    %00000001
mDDRB_DDRB1:        equ    %00000010
mDDRB_DDRB2:        equ    %00000100
mDDRB_DDRB3:        equ    %00001000
mDDRB_DDRB4:        equ    %00010000
mDDRB_DDRB5:        equ    %00100000
mDDRB_DDRB6:        equ    %01000000
mDDRB_DDRB7:        equ    %10000000


;*** PORTCD - Port CD Data Register; 0x00000004 ***
PORTCD:             equ    $00000004                                ;*** PORTCD - Port CD Data Register; 0x00000004 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PORTCD_PD0:         equ    0                                         ; Port D Bit 0
PORTCD_PD1:         equ    1                                         ; Port D Bit 1
PORTCD_PD2:         equ    2                                         ; Port D Bit 2
PORTCD_PD3:         equ    3                                         ; Port D Bit 3
PORTCD_PD4:         equ    4                                         ; Port D Bit 4
PORTCD_PD5:         equ    5                                         ; Port D Bit 5
PORTCD_PD6:         equ    6                                         ; Port D Bit 6
PORTCD_PD7:         equ    7                                         ; Port D Bit 7
PORTCD_PC0:         equ    8                                         ; Port C Bit 0
PORTCD_PC1:         equ    9                                         ; Port C Bit 1
PORTCD_PC2:         equ    10                                        ; Port C Bit 2
PORTCD_PC3:         equ    11                                        ; Port C Bit 3
PORTCD_PC4:         equ    12                                        ; Port C Bit 4
PORTCD_PC5:         equ    13                                        ; Port C Bit 5
PORTCD_PC6:         equ    14                                        ; Port C Bit 6
PORTCD_PC7:         equ    15                                        ; Port C Bit 7
; bit position masks
mPORTCD_PD0:        equ    %00000001
mPORTCD_PD1:        equ    %00000010
mPORTCD_PD2:        equ    %00000100
mPORTCD_PD3:        equ    %00001000
mPORTCD_PD4:        equ    %00010000
mPORTCD_PD5:        equ    %00100000
mPORTCD_PD6:        equ    %01000000
mPORTCD_PD7:        equ    %10000000
mPORTCD_PC0:        equ    %100000000
mPORTCD_PC1:        equ    %1000000000
mPORTCD_PC2:        equ    %10000000000
mPORTCD_PC3:        equ    %100000000000
mPORTCD_PC4:        equ    %1000000000000
mPORTCD_PC5:        equ    %10000000000000
mPORTCD_PC6:        equ    %100000000000000
mPORTCD_PC7:        equ    %1000000000000000


;*** PORTC - Port C Data Register; 0x00000004 ***
PORTC:              equ    $00000004                                ;*** PORTC - Port C Data Register; 0x00000004 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PORTC_PC0:          equ    0                                         ; Port C Bit 0
PORTC_PC1:          equ    1                                         ; Port C Bit 1
PORTC_PC2:          equ    2                                         ; Port C Bit 2
PORTC_PC3:          equ    3                                         ; Port C Bit 3
PORTC_PC4:          equ    4                                         ; Port C Bit 4
PORTC_PC5:          equ    5                                         ; Port C Bit 5
PORTC_PC6:          equ    6                                         ; Port C Bit 6
PORTC_PC7:          equ    7                                         ; Port C Bit 7
; bit position masks
mPORTC_PC0:         equ    %00000001
mPORTC_PC1:         equ    %00000010
mPORTC_PC2:         equ    %00000100
mPORTC_PC3:         equ    %00001000
mPORTC_PC4:         equ    %00010000
mPORTC_PC5:         equ    %00100000
mPORTC_PC6:         equ    %01000000
mPORTC_PC7:         equ    %10000000


;*** PORTD - Port D Data Register; 0x00000005 ***
PORTD:              equ    $00000005                                ;*** PORTD - Port D Data Register; 0x00000005 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PORTD_PD0:          equ    0                                         ; Port D Bit 0
PORTD_PD1:          equ    1                                         ; Port D Bit 1
PORTD_PD2:          equ    2                                         ; Port D Bit 2
PORTD_PD3:          equ    3                                         ; Port D Bit 3
PORTD_PD4:          equ    4                                         ; Port D Bit 4
PORTD_PD5:          equ    5                                         ; Port D Bit 5
PORTD_PD6:          equ    6                                         ; Port D Bit 6
PORTD_PD7:          equ    7                                         ; Port D Bit 7
; bit position masks
mPORTD_PD0:         equ    %00000001
mPORTD_PD1:         equ    %00000010
mPORTD_PD2:         equ    %00000100
mPORTD_PD3:         equ    %00001000
mPORTD_PD4:         equ    %00010000
mPORTD_PD5:         equ    %00100000
mPORTD_PD6:         equ    %01000000
mPORTD_PD7:         equ    %10000000


;*** DDRCD - Port CD Data Direction Register; 0x00000006 ***
DDRCD:              equ    $00000006                                ;*** DDRCD - Port CD Data Direction Register; 0x00000006 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRCD_DDRD0:        equ    0                                         ; Data Direction Port D Bit 0
DDRCD_DDRD1:        equ    1                                         ; Data Direction Port D Bit 1
DDRCD_DDRD2:        equ    2                                         ; Data Direction Port D Bit 2
DDRCD_DDRD3:        equ    3                                         ; Data Direction Port D Bit 3
DDRCD_DDRD4:        equ    4                                         ; Data Direction Port D Bit 4
DDRCD_DDRD5:        equ    5                                         ; Data Direction Port D Bit 5
DDRCD_DDRD6:        equ    6                                         ; Data Direction Port D Bit 6
DDRCD_DDRD7:        equ    7                                         ; Data Direction Port D Bit 7
DDRCD_DDRC0:        equ    8                                         ; Data Direction Port C Bit 0
DDRCD_DDRC1:        equ    9                                         ; Data Direction Port C Bit 1
DDRCD_DDRC2:        equ    10                                        ; Data Direction Port C Bit 2
DDRCD_DDRC3:        equ    11                                        ; Data Direction Port C Bit 3
DDRCD_DDRC4:        equ    12                                        ; Data Direction Port C Bit 4
DDRCD_DDRC5:        equ    13                                        ; Data Direction Port C Bit 5
DDRCD_DDRC6:        equ    14                                        ; Data Direction Port C Bit 6
DDRCD_DDRC7:        equ    15                                        ; Data Direction Port C Bit 7
; bit position masks
mDDRCD_DDRD0:       equ    %00000001
mDDRCD_DDRD1:       equ    %00000010
mDDRCD_DDRD2:       equ    %00000100
mDDRCD_DDRD3:       equ    %00001000
mDDRCD_DDRD4:       equ    %00010000
mDDRCD_DDRD5:       equ    %00100000
mDDRCD_DDRD6:       equ    %01000000
mDDRCD_DDRD7:       equ    %10000000
mDDRCD_DDRC0:       equ    %100000000
mDDRCD_DDRC1:       equ    %1000000000
mDDRCD_DDRC2:       equ    %10000000000
mDDRCD_DDRC3:       equ    %100000000000
mDDRCD_DDRC4:       equ    %1000000000000
mDDRCD_DDRC5:       equ    %10000000000000
mDDRCD_DDRC6:       equ    %100000000000000
mDDRCD_DDRC7:       equ    %1000000000000000


;*** DDRC - Port C Data Direction Register; 0x00000006 ***
DDRC:               equ    $00000006                                ;*** DDRC - Port C Data Direction Register; 0x00000006 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRC_DDRC0:         equ    0                                         ; Data Direction Port C Bit 0
DDRC_DDRC1:         equ    1                                         ; Data Direction Port C Bit 1
DDRC_DDRC2:         equ    2                                         ; Data Direction Port C Bit 2
DDRC_DDRC3:         equ    3                                         ; Data Direction Port C Bit 3
DDRC_DDRC4:         equ    4                                         ; Data Direction Port C Bit 4
DDRC_DDRC5:         equ    5                                         ; Data Direction Port C Bit 5
DDRC_DDRC6:         equ    6                                         ; Data Direction Port C Bit 6
DDRC_DDRC7:         equ    7                                         ; Data Direction Port C Bit 7
; bit position masks
mDDRC_DDRC0:        equ    %00000001
mDDRC_DDRC1:        equ    %00000010
mDDRC_DDRC2:        equ    %00000100
mDDRC_DDRC3:        equ    %00001000
mDDRC_DDRC4:        equ    %00010000
mDDRC_DDRC5:        equ    %00100000
mDDRC_DDRC6:        equ    %01000000
mDDRC_DDRC7:        equ    %10000000


;*** DDRD - Port D Data Direction Register; 0x00000007 ***
DDRD:               equ    $00000007                                ;*** DDRD - Port D Data Direction Register; 0x00000007 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRD_DDRD0:         equ    0                                         ; Data Direction Port D Bit 0
DDRD_DDRD1:         equ    1                                         ; Data Direction Port D Bit 1
DDRD_DDRD2:         equ    2                                         ; Data Direction Port D Bit 2
DDRD_DDRD3:         equ    3                                         ; Data Direction Port D Bit 3
DDRD_DDRD4:         equ    4                                         ; Data Direction Port D Bit 4
DDRD_DDRD5:         equ    5                                         ; Data Direction Port D Bit 5
DDRD_DDRD6:         equ    6                                         ; Data Direction Port D Bit 6
DDRD_DDRD7:         equ    7                                         ; Data Direction Port D Bit 7
; bit position masks
mDDRD_DDRD0:        equ    %00000001
mDDRD_DDRD1:        equ    %00000010
mDDRD_DDRD2:        equ    %00000100
mDDRD_DDRD3:        equ    %00001000
mDDRD_DDRD4:        equ    %00010000
mDDRD_DDRD5:        equ    %00100000
mDDRD_DDRD6:        equ    %01000000
mDDRD_DDRD7:        equ    %10000000


;*** PORTE - Port E Data Register; 0x00000008 ***
PORTE:              equ    $00000008                                ;*** PORTE - Port E Data Register; 0x00000008 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PORTE_PE0:          equ    0                                         ; Port E Bit 0
PORTE_PE1:          equ    1                                         ; Port E Bit 1
; bit position masks
mPORTE_PE0:         equ    %00000001
mPORTE_PE1:         equ    %00000010


;*** DDRE - Port E Data Direction Register; 0x00000009 ***
DDRE:               equ    $00000009                                ;*** DDRE - Port E Data Direction Register; 0x00000009 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRE_DDRE0:         equ    0                                         ; Data Direction Port E Bit 0
DDRE_DDRE1:         equ    1                                         ; Data Direction Port E Bit 1
; bit position masks
mDDRE_DDRE0:        equ    %00000001
mDDRE_DDRE1:        equ    %00000010


;*** MODE - Mode Register; 0x0000000B ***
MODE:               equ    $0000000B                                ;*** MODE - Mode Register; 0x0000000B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MODE_MODC:          equ    7                                         ; Mode Select Bit
; bit position masks
mMODE_MODC:         equ    %10000000


;*** PUCR - Pull-Up Control Register; 0x0000000C ***
PUCR:               equ    $0000000C                                ;*** PUCR - Pull-Up Control Register; 0x0000000C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PUCR_PUPAE:         equ    0                                         ; Pull-up Port A Enable
PUCR_PUPBE:         equ    1                                         ; Pull-up Port B Enable
PUCR_PUPCE:         equ    2                                         ; Pull-up Port C Enable
PUCR_PUPDE:         equ    3                                         ; Pull-up Port D Enable
PUCR_PDPEE:         equ    4                                         ; Pull-up Port E Enable
PUCR_BKPUE:         equ    6                                         ; BKGD and VREGEN Pin Pull-up Enable
; bit position masks
mPUCR_PUPAE:        equ    %00000001
mPUCR_PUPBE:        equ    %00000010
mPUCR_PUPCE:        equ    %00000100
mPUCR_PUPDE:        equ    %00001000
mPUCR_PDPEE:        equ    %00010000
mPUCR_BKPUE:        equ    %01000000


;*** DIRECT - Direct Page Register; 0x00000011 ***
DIRECT:             equ    $00000011                                ;*** DIRECT - Direct Page Register; 0x00000011 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DIRECT_DP8:         equ    0                                         ; Direct Page Index Bit 8
DIRECT_DP9:         equ    1                                         ; Direct Page Index Bit 9
DIRECT_DP10:        equ    2                                         ; Direct Page Index Bit 10
DIRECT_DP11:        equ    3                                         ; Direct Page Index Bit 11
DIRECT_DP12:        equ    4                                         ; Direct Page Index Bit 12
DIRECT_DP13:        equ    5                                         ; Direct Page Index Bit 13
DIRECT_DP14:        equ    6                                         ; Direct Page Index Bit 14
DIRECT_DP15:        equ    7                                         ; Direct Page Index Bit 15
; bit position masks
mDIRECT_DP8:        equ    %00000001
mDIRECT_DP9:        equ    %00000010
mDIRECT_DP10:       equ    %00000100
mDIRECT_DP11:       equ    %00001000
mDIRECT_DP12:       equ    %00010000
mDIRECT_DP13:       equ    %00100000
mDIRECT_DP14:       equ    %01000000
mDIRECT_DP15:       equ    %10000000


;*** MMCCTL1 - MMC Control Register; 0x00000013 ***
MMCCTL1:            equ    $00000013                                ;*** MMCCTL1 - MMC Control Register; 0x00000013 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MMCCTL1_NVMRES:     equ    0                                         ; Map internal NVM resources into the global memory map
; bit position masks
mMMCCTL1_NVMRES:    equ    %00000001


;*** PPAGE - Program Page Index Register; 0x00000015 ***
PPAGE:              equ    $00000015                                ;*** PPAGE - Program Page Index Register; 0x00000015 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PPAGE_PIX0:         equ    0                                         ; Program Page Index Bit 0
PPAGE_PIX1:         equ    1                                         ; Program Page Index Bit 1
PPAGE_PIX2:         equ    2                                         ; Program Page Index Bit 2
PPAGE_PIX3:         equ    3                                         ; Program Page Index Bit 3
; bit position masks
mPPAGE_PIX0:        equ    %00000001
mPPAGE_PIX1:        equ    %00000010
mPPAGE_PIX2:        equ    %00000100
mPPAGE_PIX3:        equ    %00001000


;*** PARTID - Part ID Register; 0x0000001A ***
PARTID:             equ    $0000001A                                ;*** PARTID - Part ID Register; 0x0000001A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PARTID_ID0:         equ    0                                         ; Part ID Register Bit 0
PARTID_ID1:         equ    1                                         ; Part ID Register Bit 1
PARTID_ID2:         equ    2                                         ; Part ID Register Bit 2
PARTID_ID3:         equ    3                                         ; Part ID Register Bit 3
PARTID_ID4:         equ    4                                         ; Part ID Register Bit 4
PARTID_ID5:         equ    5                                         ; Part ID Register Bit 5
PARTID_ID6:         equ    6                                         ; Part ID Register Bit 6
PARTID_ID7:         equ    7                                         ; Part ID Register Bit 7
PARTID_ID8:         equ    8                                         ; Part ID Register Bit 8
PARTID_ID9:         equ    9                                         ; Part ID Register Bit 9
PARTID_ID10:        equ    10                                        ; Part ID Register Bit 10
PARTID_ID11:        equ    11                                        ; Part ID Register Bit 11
PARTID_ID12:        equ    12                                        ; Part ID Register Bit 12
PARTID_ID13:        equ    13                                        ; Part ID Register Bit 13
PARTID_ID14:        equ    14                                        ; Part ID Register Bit 14
PARTID_ID15:        equ    15                                        ; Part ID Register Bit 15
; bit position masks
mPARTID_ID0:        equ    %00000001
mPARTID_ID1:        equ    %00000010
mPARTID_ID2:        equ    %00000100
mPARTID_ID3:        equ    %00001000
mPARTID_ID4:        equ    %00010000
mPARTID_ID5:        equ    %00100000
mPARTID_ID6:        equ    %01000000
mPARTID_ID7:        equ    %10000000
mPARTID_ID8:        equ    %100000000
mPARTID_ID9:        equ    %1000000000
mPARTID_ID10:       equ    %10000000000
mPARTID_ID11:       equ    %100000000000
mPARTID_ID12:       equ    %1000000000000
mPARTID_ID13:       equ    %10000000000000
mPARTID_ID14:       equ    %100000000000000
mPARTID_ID15:       equ    %1000000000000000


;*** PARTIDH - Part ID Register High; 0x0000001A ***
PARTIDH:            equ    $0000001A                                ;*** PARTIDH - Part ID Register High; 0x0000001A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PARTIDH_ID8:        equ    0                                         ; Part ID Register Bit 8
PARTIDH_ID9:        equ    1                                         ; Part ID Register Bit 9
PARTIDH_ID10:       equ    2                                         ; Part ID Register Bit 10
PARTIDH_ID11:       equ    3                                         ; Part ID Register Bit 11
PARTIDH_ID12:       equ    4                                         ; Part ID Register Bit 12
PARTIDH_ID13:       equ    5                                         ; Part ID Register Bit 13
PARTIDH_ID14:       equ    6                                         ; Part ID Register Bit 14
PARTIDH_ID15:       equ    7                                         ; Part ID Register Bit 15
; bit position masks
mPARTIDH_ID8:       equ    %00000001
mPARTIDH_ID9:       equ    %00000010
mPARTIDH_ID10:      equ    %00000100
mPARTIDH_ID11:      equ    %00001000
mPARTIDH_ID12:      equ    %00010000
mPARTIDH_ID13:      equ    %00100000
mPARTIDH_ID14:      equ    %01000000
mPARTIDH_ID15:      equ    %10000000


;*** PARTIDL - Part ID Register Low; 0x0000001B ***
PARTIDL:            equ    $0000001B                                ;*** PARTIDL - Part ID Register Low; 0x0000001B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PARTIDL_ID0:        equ    0                                         ; Part ID Register Bit 0
PARTIDL_ID1:        equ    1                                         ; Part ID Register Bit 1
PARTIDL_ID2:        equ    2                                         ; Part ID Register Bit 2
PARTIDL_ID3:        equ    3                                         ; Part ID Register Bit 3
PARTIDL_ID4:        equ    4                                         ; Part ID Register Bit 4
PARTIDL_ID5:        equ    5                                         ; Part ID Register Bit 5
PARTIDL_ID6:        equ    6                                         ; Part ID Register Bit 6
PARTIDL_ID7:        equ    7                                         ; Part ID Register Bit 7
; bit position masks
mPARTIDL_ID0:       equ    %00000001
mPARTIDL_ID1:       equ    %00000010
mPARTIDL_ID2:       equ    %00000100
mPARTIDL_ID3:       equ    %00001000
mPARTIDL_ID4:       equ    %00010000
mPARTIDL_ID5:       equ    %00100000
mPARTIDL_ID6:       equ    %01000000
mPARTIDL_ID7:       equ    %10000000


;*** ECLKCTL - ECLK Control Register; 0x0000001C ***
ECLKCTL:            equ    $0000001C                                ;*** ECLKCTL - ECLK Control Register; 0x0000001C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ECLKCTL_EDIV0:      equ    0                                         ; Free-running ECLK Divider, bit 0
ECLKCTL_EDIV1:      equ    1                                         ; Free-running ECLK Divider, bit 1
ECLKCTL_EDIV2:      equ    2                                         ; Free-running ECLK Divider, bit 2
ECLKCTL_EDIV3:      equ    3                                         ; Free-running ECLK Divider, bit 3
ECLKCTL_EDIV4:      equ    4                                         ; Free-running ECLK Divider, bit 4
ECLKCTL_DIV16:      equ    5                                         ; Free-running ECLK predivider
ECLKCTL_NCLKX2:     equ    6                                         ; No ECLKX2
ECLKCTL_NECLK:      equ    7                                         ; No ECLK
; bit position masks
mECLKCTL_EDIV0:     equ    %00000001
mECLKCTL_EDIV1:     equ    %00000010
mECLKCTL_EDIV2:     equ    %00000100
mECLKCTL_EDIV3:     equ    %00001000
mECLKCTL_EDIV4:     equ    %00010000
mECLKCTL_DIV16:     equ    %00100000
mECLKCTL_NCLKX2:    equ    %01000000
mECLKCTL_NECLK:     equ    %10000000


;*** IRQCR - Interrupt Control Register; 0x0000001E ***
IRQCR:              equ    $0000001E                                ;*** IRQCR - Interrupt Control Register; 0x0000001E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
IRQCR_IRQEN:        equ    6                                         ; External IRQ Enable
IRQCR_IRQE:         equ    7                                         ; IRQ Select Edge Sensitive Only
; bit position masks
mIRQCR_IRQEN:       equ    %01000000
mIRQCR_IRQE:        equ    %10000000


;*** DBGC1 - Debug Control Register 1; 0x00000020 ***
DBGC1:              equ    $00000020                                ;*** DBGC1 - Debug Control Register 1; 0x00000020 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGC1_COMRV0:       equ    0                                         ; Comparator Register Visibility Bits, bit 0
DBGC1_COMRV1:       equ    1                                         ; Comparator Register Visibility Bits, bit 1
DBGC1_DBGBRK:       equ    3                                         ; S12XDBG Breakpoint Enable Bit 1
DBGC1_BDM:          equ    4                                         ; Background Debug Mode Enable
DBGC1_TRIG:         equ    6                                         ; Immediate Trigger Request Bit
DBGC1_ARM:          equ    7                                         ; Arm Bit
; bit position masks
mDBGC1_COMRV0:      equ    %00000001
mDBGC1_COMRV1:      equ    %00000010
mDBGC1_DBGBRK:      equ    %00001000
mDBGC1_BDM:         equ    %00010000
mDBGC1_TRIG:        equ    %01000000
mDBGC1_ARM:         equ    %10000000


;*** DBGSR - Debug Status Register; 0x00000021 ***
DBGSR:              equ    $00000021                                ;*** DBGSR - Debug Status Register; 0x00000021 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGSR_SSF0:         equ    0                                         ; State Sequencer Flag Bits
DBGSR_SSF1:         equ    1                                         ; State Sequencer Flag Bit 1
DBGSR_SSF2:         equ    2                                         ; State Sequencer Flag Bit 2
DBGSR_TBF:          equ    7                                         ; Trace Buffer Full
; bit position masks
mDBGSR_SSF0:        equ    %00000001
mDBGSR_SSF1:        equ    %00000010
mDBGSR_SSF2:        equ    %00000100
mDBGSR_TBF:         equ    %10000000


;*** DBGTCR - Debug Trace Control Register; 0x00000022 ***
DBGTCR:             equ    $00000022                                ;*** DBGTCR - Debug Trace Control Register; 0x00000022 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGTCR_TALIGN:      equ    0                                         ; Trigger Align Bit
DBGTCR_TRCMOD0:     equ    2                                         ; Trace Mode Bits, bit 0
DBGTCR_TRCMOD1:     equ    3                                         ; Trace Mode Bits, bit 1
DBGTCR_TSOURCE:     equ    6                                         ; Trace Source Control Bits
; bit position masks
mDBGTCR_TALIGN:     equ    %00000001
mDBGTCR_TRCMOD0:    equ    %00000100
mDBGTCR_TRCMOD1:    equ    %00001000
mDBGTCR_TSOURCE:    equ    %01000000


;*** DBGC2 - Debug Control Register 2; 0x00000023 ***
DBGC2:              equ    $00000023                                ;*** DBGC2 - Debug Control Register 2; 0x00000023 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGC2_ABCM0:        equ    0                                         ; A and B Comparator Match Control, bit 0
DBGC2_ABCM1:        equ    1                                         ; A and B Comparator Match Control, bit 1
; bit position masks
mDBGC2_ABCM0:       equ    %00000001
mDBGC2_ABCM1:       equ    %00000010


;*** DBGTB - Debug Trace Buffer Register; 0x00000024 ***
DBGTB:              equ    $00000024                                ;*** DBGTB - Debug Trace Buffer Register; 0x00000024 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGTB_BIT0:         equ    0                                         ; Trace Buffer Data Bits
DBGTB_BIT1:         equ    1                                         ; Trace Buffer Data Bit 1
DBGTB_BIT2:         equ    2                                         ; Trace Buffer Data Bit 2
DBGTB_BIT3:         equ    3                                         ; Trace Buffer Data Bit 3
DBGTB_BIT4:         equ    4                                         ; Trace Buffer Data Bit 4
DBGTB_BIT5:         equ    5                                         ; Trace Buffer Data Bit 5
DBGTB_BIT6:         equ    6                                         ; Trace Buffer Data Bit 6
DBGTB_BIT7:         equ    7                                         ; Trace Buffer Data Bit 7
DBGTB_BIT8:         equ    8                                         ; Trace Buffer Data Bit 8
DBGTB_BIT9:         equ    9                                         ; Trace Buffer Data Bit 9
DBGTB_BIT10:        equ    10                                        ; Trace Buffer Data Bit 10
DBGTB_BIT11:        equ    11                                        ; Trace Buffer Data Bit 11
DBGTB_BIT12:        equ    12                                        ; Trace Buffer Data Bit 12
DBGTB_BIT13:        equ    13                                        ; Trace Buffer Data Bit 13
DBGTB_BIT14:        equ    14                                        ; Trace Buffer Data Bit 14
DBGTB_BIT15:        equ    15                                        ; Trace Buffer Data Bit 15
; bit position masks
mDBGTB_BIT0:        equ    %00000001
mDBGTB_BIT1:        equ    %00000010
mDBGTB_BIT2:        equ    %00000100
mDBGTB_BIT3:        equ    %00001000
mDBGTB_BIT4:        equ    %00010000
mDBGTB_BIT5:        equ    %00100000
mDBGTB_BIT6:        equ    %01000000
mDBGTB_BIT7:        equ    %10000000
mDBGTB_BIT8:        equ    %100000000
mDBGTB_BIT9:        equ    %1000000000
mDBGTB_BIT10:       equ    %10000000000
mDBGTB_BIT11:       equ    %100000000000
mDBGTB_BIT12:       equ    %1000000000000
mDBGTB_BIT13:       equ    %10000000000000
mDBGTB_BIT14:       equ    %100000000000000
mDBGTB_BIT15:       equ    %1000000000000000


;*** DBGTBH - Debug Trace Buffer Register High; 0x00000024 ***
DBGTBH:             equ    $00000024                                ;*** DBGTBH - Debug Trace Buffer Register High; 0x00000024 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGTBH_BIT8:        equ    0                                         ; Trace Buffer Data Bits
DBGTBH_BIT9:        equ    1                                         ; Trace Buffer Data Bit 9
DBGTBH_BIT10:       equ    2                                         ; Trace Buffer Data Bit 10
DBGTBH_BIT11:       equ    3                                         ; Trace Buffer Data Bit 11
DBGTBH_BIT12:       equ    4                                         ; Trace Buffer Data Bit 12
DBGTBH_BIT13:       equ    5                                         ; Trace Buffer Data Bit 13
DBGTBH_BIT14:       equ    6                                         ; Trace Buffer Data Bit 14
DBGTBH_BIT15:       equ    7                                         ; Trace Buffer Data Bit 15
; bit position masks
mDBGTBH_BIT8:       equ    %00000001
mDBGTBH_BIT9:       equ    %00000010
mDBGTBH_BIT10:      equ    %00000100
mDBGTBH_BIT11:      equ    %00001000
mDBGTBH_BIT12:      equ    %00010000
mDBGTBH_BIT13:      equ    %00100000
mDBGTBH_BIT14:      equ    %01000000
mDBGTBH_BIT15:      equ    %10000000


;*** DBGTBL - Debug Trace Buffer Register Low; 0x00000025 ***
DBGTBL:             equ    $00000025                                ;*** DBGTBL - Debug Trace Buffer Register Low; 0x00000025 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGTBL_BIT0:        equ    0                                         ; Trace Buffer Data Bits
DBGTBL_BIT1:        equ    1                                         ; Trace Buffer Data Bit 1
DBGTBL_BIT2:        equ    2                                         ; Trace Buffer Data Bit 2
DBGTBL_BIT3:        equ    3                                         ; Trace Buffer Data Bit 3
DBGTBL_BIT4:        equ    4                                         ; Trace Buffer Data Bit 4
DBGTBL_BIT5:        equ    5                                         ; Trace Buffer Data Bit 5
DBGTBL_BIT6:        equ    6                                         ; Trace Buffer Data Bit 6
DBGTBL_BIT7:        equ    7                                         ; Trace Buffer Data Bit 7
; bit position masks
mDBGTBL_BIT0:       equ    %00000001
mDBGTBL_BIT1:       equ    %00000010
mDBGTBL_BIT2:       equ    %00000100
mDBGTBL_BIT3:       equ    %00001000
mDBGTBL_BIT4:       equ    %00010000
mDBGTBL_BIT5:       equ    %00100000
mDBGTBL_BIT6:       equ    %01000000
mDBGTBL_BIT7:       equ    %10000000


;*** DBGCNT - Debug Count Register; 0x00000026 ***
DBGCNT:             equ    $00000026                                ;*** DBGCNT - Debug Count Register; 0x00000026 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGCNT_CNT0:        equ    0                                         ; Count Value, bit 0
DBGCNT_CNT1:        equ    1                                         ; Count Value, bit 1
DBGCNT_CNT2:        equ    2                                         ; Count Value, bit 2
DBGCNT_CNT3:        equ    3                                         ; Count Value, bit 3
DBGCNT_CNT4:        equ    4                                         ; Count Value, bit 4
DBGCNT_CNT5:        equ    5                                         ; Count Value, bit 5
DBGCNT_TBF:         equ    7                                         ; Trace Buffer Full
; bit position masks
mDBGCNT_CNT0:       equ    %00000001
mDBGCNT_CNT1:       equ    %00000010
mDBGCNT_CNT2:       equ    %00000100
mDBGCNT_CNT3:       equ    %00001000
mDBGCNT_CNT4:       equ    %00010000
mDBGCNT_CNT5:       equ    %00100000
mDBGCNT_TBF:        equ    %10000000


;*** DBGSCRX - Debug State Control Register; 0x00000027 ***
DBGSCRX:            equ    $00000027                                ;*** DBGSCRX - Debug State Control Register; 0x00000027 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGSCRX_SC0:        equ    0                                         ; State X Sequencer Next State Selection Bit 0
DBGSCRX_SC1:        equ    1                                         ; State X Sequencer Next State Selection Bit 1
DBGSCRX_SC2:        equ    2                                         ; State X Sequencer Next State Selection Bit 2
DBGSCRX_SC3:        equ    3                                         ; State X Sequencer Next State Selection Bit 3
; bit position masks
mDBGSCRX_SC0:       equ    %00000001
mDBGSCRX_SC1:       equ    %00000010
mDBGSCRX_SC2:       equ    %00000100
mDBGSCRX_SC3:       equ    %00001000


;*** DBGMFR - Debug Match Flag Register; 0x00000027 ***
DBGMFR:             equ    $00000027                                ;*** DBGMFR - Debug Match Flag Register; 0x00000027 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGMFR_MC0:         equ    0                                         ; Debug Match Flag Bit 0
DBGMFR_MC1:         equ    1                                         ; Debug Match Flag Bit 1
DBGMFR_MC2:         equ    2                                         ; Debug Match Flag Bit 2
; bit position masks
mDBGMFR_MC0:        equ    %00000001
mDBGMFR_MC1:        equ    %00000010
mDBGMFR_MC2:        equ    %00000100


;*** DBGXCTL - Debug Comparator Control Register; 0x00000028 ***
DBGXCTL:            equ    $00000028                                ;*** DBGXCTL - Debug Comparator Control Register; 0x00000028 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGXCTL_COMPE:      equ    0                                         ; Determines if comparator is enabled
DBGXCTL_NDB:        equ    1                                         ; Not Data Bus(Comparators A and C), Size Comparator Value Bit(Comparators B and D)
DBGXCTL_RWE:        equ    2                                         ; Read/Write Enable Bit
DBGXCTL_RW:         equ    3                                         ; Read/Write Comparator Value Bit
DBGXCTL_BRK:        equ    4                                         ; Break
DBGXCTL_TAG:        equ    5                                         ; Tag Select
DBGXCTL_SZ:         equ    6                                         ; Size Comparator Value Bit
DBGXCTL_SZE:        equ    7                                         ; Size Comparator Enable Bit
; bit position masks
mDBGXCTL_COMPE:     equ    %00000001
mDBGXCTL_NDB:       equ    %00000010
mDBGXCTL_RWE:       equ    %00000100
mDBGXCTL_RW:        equ    %00001000
mDBGXCTL_BRK:       equ    %00010000
mDBGXCTL_TAG:       equ    %00100000
mDBGXCTL_SZ:        equ    %01000000
mDBGXCTL_SZE:       equ    %10000000


;*** DBGXAH - Debug Comparator Address High Register; 0x00000029 ***
DBGXAH:             equ    $00000029                                ;*** DBGXAH - Debug Comparator Address High Register; 0x00000029 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGXAH_BIT16:       equ    0                                         ; Comparator Address High Compare Bits
DBGXAH_BIT17:       equ    1                                         ; Comparator Address High Compare Bit 17
; bit position masks
mDBGXAH_BIT16:      equ    %00000001
mDBGXAH_BIT17:      equ    %00000010


;*** DBGXAM - Debug Comparator Address Mid Register; 0x0000002A ***
DBGXAM:             equ    $0000002A                                ;*** DBGXAM - Debug Comparator Address Mid Register; 0x0000002A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGXAM_BIT8:        equ    0                                         ; Comparator Address Mid Compare Bits
DBGXAM_BIT9:        equ    1                                         ; Comparator Address Mid Compare Bit 9
DBGXAM_BIT10:       equ    2                                         ; Comparator Address Mid Compare Bit 10
DBGXAM_BIT11:       equ    3                                         ; Comparator Address Mid Compare Bit 11
DBGXAM_BIT12:       equ    4                                         ; Comparator Address Mid Compare Bit 12
DBGXAM_BIT13:       equ    5                                         ; Comparator Address Mid Compare Bit 13
DBGXAM_BIT14:       equ    6                                         ; Comparator Address Mid Compare Bit 14
DBGXAM_BIT15:       equ    7                                         ; Comparator Address Mid Compare Bit 15
; bit position masks
mDBGXAM_BIT8:       equ    %00000001
mDBGXAM_BIT9:       equ    %00000010
mDBGXAM_BIT10:      equ    %00000100
mDBGXAM_BIT11:      equ    %00001000
mDBGXAM_BIT12:      equ    %00010000
mDBGXAM_BIT13:      equ    %00100000
mDBGXAM_BIT14:      equ    %01000000
mDBGXAM_BIT15:      equ    %10000000


;*** DBGXAL - Debug Comparator Address Low Register; 0x0000002B ***
DBGXAL:             equ    $0000002B                                ;*** DBGXAL - Debug Comparator Address Low Register; 0x0000002B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGXAL_BIT0:        equ    0                                         ; Comparator Address Low Compare Bits
DBGXAL_BIT1:        equ    1                                         ; Comparator Address Low Compare Bit 1
DBGXAL_BIT2:        equ    2                                         ; Comparator Address Low Compare Bit 2
DBGXAL_BIT3:        equ    3                                         ; Comparator Address Low Compare Bit 3
DBGXAL_BIT4:        equ    4                                         ; Comparator Address Low Compare Bit 4
DBGXAL_BIT5:        equ    5                                         ; Comparator Address Low Compare Bit 5
DBGXAL_BIT6:        equ    6                                         ; Comparator Address Low Compare Bit 6
DBGXAL_BIT7:        equ    7                                         ; Comparator Address Low Compare Bit 7
; bit position masks
mDBGXAL_BIT0:       equ    %00000001
mDBGXAL_BIT1:       equ    %00000010
mDBGXAL_BIT2:       equ    %00000100
mDBGXAL_BIT3:       equ    %00001000
mDBGXAL_BIT4:       equ    %00010000
mDBGXAL_BIT5:       equ    %00100000
mDBGXAL_BIT6:       equ    %01000000
mDBGXAL_BIT7:       equ    %10000000


;*** DBGADH - Debug Comparator Data High Register; 0x0000002C ***
DBGADH:             equ    $0000002C                                ;*** DBGADH - Debug Comparator Data High Register; 0x0000002C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGADH_BIT8:        equ    0                                         ; Comparator Data High Compare Bit 8
DBGADH_BIT9:        equ    1                                         ; Comparator Data High Compare Bit 9
DBGADH_BIT10:       equ    2                                         ; Comparator Data High Compare Bit 10
DBGADH_BIT11:       equ    3                                         ; Comparator Data High Compare Bit 11
DBGADH_BIT12:       equ    4                                         ; Comparator Data High Compare Bit 12
DBGADH_BIT13:       equ    5                                         ; Comparator Data High Compare Bit 13
DBGADH_BIT14:       equ    6                                         ; Comparator Data High Compare Bit 14
DBGADH_BIT15:       equ    7                                         ; Comparator Data High Compare Bit 15
; bit position masks
mDBGADH_BIT8:       equ    %00000001
mDBGADH_BIT9:       equ    %00000010
mDBGADH_BIT10:      equ    %00000100
mDBGADH_BIT11:      equ    %00001000
mDBGADH_BIT12:      equ    %00010000
mDBGADH_BIT13:      equ    %00100000
mDBGADH_BIT14:      equ    %01000000
mDBGADH_BIT15:      equ    %10000000


;*** DBGADL - Debug Comparator Data Low Register; 0x0000002D ***
DBGADL:             equ    $0000002D                                ;*** DBGADL - Debug Comparator Data Low Register; 0x0000002D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGADL_BIT0:        equ    0                                         ; Comparator Data Low Compare Bit 0
DBGADL_BIT1:        equ    1                                         ; Comparator Data Low Compare Bit 1
DBGADL_BIT2:        equ    2                                         ; Comparator Data Low Compare Bit 2
DBGADL_BIT3:        equ    3                                         ; Comparator Data Low Compare Bit 3
DBGADL_BIT4:        equ    4                                         ; Comparator Data Low Compare Bit 4
DBGADL_BIT5:        equ    5                                         ; Comparator Data Low Compare Bit 5
DBGADL_BIT6:        equ    6                                         ; Comparator Data Low Compare Bit 6
DBGADL_BIT7:        equ    7                                         ; Comparator Data Low Compare Bit 7
; bit position masks
mDBGADL_BIT0:       equ    %00000001
mDBGADL_BIT1:       equ    %00000010
mDBGADL_BIT2:       equ    %00000100
mDBGADL_BIT3:       equ    %00001000
mDBGADL_BIT4:       equ    %00010000
mDBGADL_BIT5:       equ    %00100000
mDBGADL_BIT6:       equ    %01000000
mDBGADL_BIT7:       equ    %10000000


;*** DBGADHM - Debug Comparator Data High Mask Register; 0x0000002E ***
DBGADHM:            equ    $0000002E                                ;*** DBGADHM - Debug Comparator Data High Mask Register; 0x0000002E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGADHM_BIT8:       equ    0                                         ; Comparator Data High Mask Bit 8
DBGADHM_BIT9:       equ    1                                         ; Comparator Data High Mask Bit 9
DBGADHM_BIT10:      equ    2                                         ; Comparator Data High Mask Bit 10
DBGADHM_BIT11:      equ    3                                         ; Comparator Data High Mask Bit 11
DBGADHM_BIT12:      equ    4                                         ; Comparator Data High Mask Bit 12
DBGADHM_BIT13:      equ    5                                         ; Comparator Data High Mask Bit 13
DBGADHM_BIT14:      equ    6                                         ; Comparator Data High Mask Bit 14
DBGADHM_BIT15:      equ    7                                         ; Comparator Data High Mask Bit 15
; bit position masks
mDBGADHM_BIT8:      equ    %00000001
mDBGADHM_BIT9:      equ    %00000010
mDBGADHM_BIT10:     equ    %00000100
mDBGADHM_BIT11:     equ    %00001000
mDBGADHM_BIT12:     equ    %00010000
mDBGADHM_BIT13:     equ    %00100000
mDBGADHM_BIT14:     equ    %01000000
mDBGADHM_BIT15:     equ    %10000000


;*** DBGADLM - Debug Comparator Data Low Mask Register; 0x0000002F ***
DBGADLM:            equ    $0000002F                                ;*** DBGADLM - Debug Comparator Data Low Mask Register; 0x0000002F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGADLM_BIT0:       equ    0                                         ; Comparator Data Low Mask Bit 0
DBGADLM_BIT1:       equ    1                                         ; Comparator Data Low Mask Bit 1
DBGADLM_BIT2:       equ    2                                         ; Comparator Data Low Mask Bit 2
DBGADLM_BIT3:       equ    3                                         ; Comparator Data Low Mask Bit 3
DBGADLM_BIT4:       equ    4                                         ; Comparator Data Low Mask Bit 4
DBGADLM_BIT5:       equ    5                                         ; Comparator Data Low Mask Bit 5
DBGADLM_BIT6:       equ    6                                         ; Comparator Data Low Mask Bit 6
DBGADLM_BIT7:       equ    7                                         ; Comparator Data Low Mask Bit 7
; bit position masks
mDBGADLM_BIT0:      equ    %00000001
mDBGADLM_BIT1:      equ    %00000010
mDBGADLM_BIT2:      equ    %00000100
mDBGADLM_BIT3:      equ    %00001000
mDBGADLM_BIT4:      equ    %00010000
mDBGADLM_BIT5:      equ    %00100000
mDBGADLM_BIT6:      equ    %01000000
mDBGADLM_BIT7:      equ    %10000000


;*** CPMUSYNR - S12CPMU Synthesizer Register; 0x00000034 ***
CPMUSYNR:           equ    $00000034                                ;*** CPMUSYNR - S12CPMU Synthesizer Register; 0x00000034 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CPMUSYNR_SYNDIV0:   equ    0                                         ; Multiplication factor of the IPLL bit 0
CPMUSYNR_SYNDIV1:   equ    1                                         ; Multiplication factor of the IPLL bit 1
CPMUSYNR_SYNDIV2:   equ    2                                         ; Multiplication factor of the IPLL bit 2
CPMUSYNR_SYNDIV3:   equ    3                                         ; Multiplication factor of the IPLL bit 3
CPMUSYNR_SYNDIV4:   equ    4                                         ; Multiplication factor of the IPLL bit 4
CPMUSYNR_SYNDIV5:   equ    5                                         ; Multiplication factor of the IPLL bit 5
CPMUSYNR_VCOFRQ0:   equ    6                                         ; VCO frequency range bit 0
CPMUSYNR_VCOFRQ1:   equ    7                                         ; VCO frequency range bit 1
; bit position masks
mCPMUSYNR_SYNDIV0:  equ    %00000001
mCPMUSYNR_SYNDIV1:  equ    %00000010
mCPMUSYNR_SYNDIV2:  equ    %00000100
mCPMUSYNR_SYNDIV3:  equ    %00001000
mCPMUSYNR_SYNDIV4:  equ    %00010000
mCPMUSYNR_SYNDIV5:  equ    %00100000
mCPMUSYNR_VCOFRQ0:  equ    %01000000
mCPMUSYNR_VCOFRQ1:  equ    %10000000


;*** CPMUREFDIV - S12CPMU Reference Divider Register; 0x00000035 ***
CPMUREFDIV:         equ    $00000035                                ;*** CPMUREFDIV - S12CPMU Reference Divider Register; 0x00000035 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CPMUREFDIV_REFDIV0: equ    0                                         ; Finer granularity for the IPLL multiplier steps bit 0
CPMUREFDIV_REFDIV1: equ    1                                         ; Finer granularity for the IPLL multiplier steps bit 1
CPMUREFDIV_REFDIV2: equ    2                                         ; Finer granularity for the IPLL multiplier steps bit 2
CPMUREFDIV_REFDIV3: equ    3                                         ; Finer granularity for the IPLL multiplier steps bit 3
CPMUREFDIV_REFFRQ0: equ    6                                         ; IPLL optimal stability and lock time configuration bit 0
CPMUREFDIV_REFFRQ1: equ    7                                         ; IPLL optimal stability and lock time configuration bit 1
; bit position masks
mCPMUREFDIV_REFDIV0: equ    %00000001
mCPMUREFDIV_REFDIV1: equ    %00000010
mCPMUREFDIV_REFDIV2: equ    %00000100
mCPMUREFDIV_REFDIV3: equ    %00001000
mCPMUREFDIV_REFFRQ0: equ    %01000000
mCPMUREFDIV_REFFRQ1: equ    %10000000


;*** CPMUPOSTDIV - S12CPMU Post Divider Register; 0x00000036 ***
CPMUPOSTDIV:        equ    $00000036                                ;*** CPMUPOSTDIV - S12CPMU Post Divider Register; 0x00000036 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CPMUPOSTDIV_POSTDIV0: equ    0                                       ; Frequency ratio between the VCOCLK and PLLCLK control bit 0
CPMUPOSTDIV_POSTDIV1: equ    1                                       ; Frequency ratio between the VCOCLK and PLLCLK control bit 1
CPMUPOSTDIV_POSTDIV2: equ    2                                       ; Frequency ratio between the VCOCLK and PLLCLK control bit 2
CPMUPOSTDIV_POSTDIV3: equ    3                                       ; Frequency ratio between the VCOCLK and PLLCLK control bit 3
CPMUPOSTDIV_POSTDIV4: equ    4                                       ; Frequency ratio between the VCOCLK and PLLCLK control bit 4
; bit position masks
mCPMUPOSTDIV_POSTDIV0: equ    %00000001
mCPMUPOSTDIV_POSTDIV1: equ    %00000010
mCPMUPOSTDIV_POSTDIV2: equ    %00000100
mCPMUPOSTDIV_POSTDIV3: equ    %00001000
mCPMUPOSTDIV_POSTDIV4: equ    %00010000


;*** CPMUFLG - S12CPMU Flags Register; 0x00000037 ***
CPMUFLG:            equ    $00000037                                ;*** CPMUFLG - S12CPMU Flags Register; 0x00000037 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CPMUFLG_UPOSC:      equ    0                                         ; Oscillator Status Bit
CPMUFLG_OSCIF:      equ    1                                         ; Oscillator Interrupt Flag
CPMUFLG_ILAF:       equ    2                                         ; Illegal Address Reset Flag
CPMUFLG_LOCK:       equ    3                                         ; Lock Status Bit
CPMUFLG_LOCKIF:     equ    4                                         ; IPLL Lock Interrupt Flag
CPMUFLG_LVRF:       equ    5                                         ; Low Voltage Reset Flag
CPMUFLG_PORF:       equ    6                                         ; Power on Reset Flag
CPMUFLG_RTIF:       equ    7                                         ; Real Time Interrupt Flag
; bit position masks
mCPMUFLG_UPOSC:     equ    %00000001
mCPMUFLG_OSCIF:     equ    %00000010
mCPMUFLG_ILAF:      equ    %00000100
mCPMUFLG_LOCK:      equ    %00001000
mCPMUFLG_LOCKIF:    equ    %00010000
mCPMUFLG_LVRF:      equ    %00100000
mCPMUFLG_PORF:      equ    %01000000
mCPMUFLG_RTIF:      equ    %10000000


;*** CPMUINT - S12CPMU Interrupt Enable Register; 0x00000038 ***
CPMUINT:            equ    $00000038                                ;*** CPMUINT - S12CPMU Interrupt Enable Register; 0x00000038 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CPMUINT_OSCIE:      equ    1                                         ; Oscillator Corrupt Interrupt Enable Bit
CPMUINT_LOCKIE:     equ    4                                         ; Lock Interrupt Enable Bit
CPMUINT_RTIE:       equ    7                                         ; Real Time Interrupt Enable Bit
; bit position masks
mCPMUINT_OSCIE:     equ    %00000010
mCPMUINT_LOCKIE:    equ    %00010000
mCPMUINT_RTIE:      equ    %10000000


;*** CPMUCLKS - S12CPMU Clock Select Register; 0x00000039 ***
CPMUCLKS:           equ    $00000039                                ;*** CPMUCLKS - S12CPMU Clock Select Register; 0x00000039 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CPMUCLKS_COPOSCSEL0: equ    0                                        ; COP Clock Select 0
CPMUCLKS_RTIOSCSEL: equ    1                                         ; RTI Clock Select
CPMUCLKS_PCE:       equ    2                                         ; COP Enable During Pseudo Stop Bit
CPMUCLKS_PRE:       equ    3                                         ; RTI Enable During Pseudo Stop Bit
CPMUCLKS_COPOSCSEL1: equ    4                                        ; COP Clock Select 1
CPMUCLKS_PSTP:      equ    6                                         ; Pseudo Stop Bit
CPMUCLKS_PLLSEL:    equ    7                                         ; PLL Select Bit
; bit position masks
mCPMUCLKS_COPOSCSEL0: equ    %00000001
mCPMUCLKS_RTIOSCSEL: equ    %00000010
mCPMUCLKS_PCE:      equ    %00000100
mCPMUCLKS_PRE:      equ    %00001000
mCPMUCLKS_COPOSCSEL1: equ    %00010000
mCPMUCLKS_PSTP:     equ    %01000000
mCPMUCLKS_PLLSEL:   equ    %10000000


;*** CPMUPLL - S12CPMU PLL Control Register; 0x0000003A ***
CPMUPLL:            equ    $0000003A                                ;*** CPMUPLL - S12CPMU PLL Control Register; 0x0000003A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CPMUPLL_FM0:        equ    4                                         ; PLL Frequency Modulation Enable Bit 0
CPMUPLL_FM1:        equ    5                                         ; PLL Frequency Modulation Enable Bit 1
; bit position masks
mCPMUPLL_FM0:       equ    %00010000
mCPMUPLL_FM1:       equ    %00100000


;*** CPMURTI - CPMU RTI Control Register; 0x0000003B ***
CPMURTI:            equ    $0000003B                                ;*** CPMURTI - CPMU RTI Control Register; 0x0000003B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CPMURTI_RTR0:       equ    0                                         ; Real Time Interrupt Modulus Counter Select Bit 0
CPMURTI_RTR1:       equ    1                                         ; Real Time Interrupt Modulus Counter Select Bit 1
CPMURTI_RTR2:       equ    2                                         ; Real Time Interrupt Modulus Counter Select Bit 2
CPMURTI_RTR3:       equ    3                                         ; Real Time Interrupt Modulus Counter Select Bit 3
CPMURTI_RTR4:       equ    4                                         ; Real Time Interrupt Prescale Rate Select Bit 4
CPMURTI_RTR5:       equ    5                                         ; Real Time Interrupt Prescale Rate Select Bit 5
CPMURTI_RTR6:       equ    6                                         ; Real Time Interrupt Prescale Rate Select Bit 6
CPMURTI_RTDEC:      equ    7                                         ; Decimal or Binary Divider Select Bit
; bit position masks
mCPMURTI_RTR0:      equ    %00000001
mCPMURTI_RTR1:      equ    %00000010
mCPMURTI_RTR2:      equ    %00000100
mCPMURTI_RTR3:      equ    %00001000
mCPMURTI_RTR4:      equ    %00010000
mCPMURTI_RTR5:      equ    %00100000
mCPMURTI_RTR6:      equ    %01000000
mCPMURTI_RTDEC:     equ    %10000000


;*** CPMUCOP - CPMU COP Control Register; 0x0000003C ***
CPMUCOP:            equ    $0000003C                                ;*** CPMUCOP - CPMU COP Control Register; 0x0000003C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CPMUCOP_CR0:        equ    0                                         ; COP Watchdog Timer Rate select Bit 0
CPMUCOP_CR1:        equ    1                                         ; COP Watchdog Timer Rate select Bit 1
CPMUCOP_CR2:        equ    2                                         ; COP Watchdog Timer Rate select Bit 2
CPMUCOP_WRTMASK:    equ    5                                         ; Write Mask for WCOP
CPMUCOP_RSBCK:      equ    6                                         ; COP and RTI stop in Active BDM mode Bit
CPMUCOP_WCOP:       equ    7                                         ; Window COP mode
; bit position masks
mCPMUCOP_CR0:       equ    %00000001
mCPMUCOP_CR1:       equ    %00000010
mCPMUCOP_CR2:       equ    %00000100
mCPMUCOP_WRTMASK:   equ    %00100000
mCPMUCOP_RSBCK:     equ    %01000000
mCPMUCOP_WCOP:      equ    %10000000


;*** CPMUARMCOP - CPMU COP Timer Arm/Reset Register; 0x0000003F ***
CPMUARMCOP:         equ    $0000003F                                ;*** CPMUARMCOP - CPMU COP Timer Arm/Reset Register; 0x0000003F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CPMUARMCOP_BIT0:    equ    0                                         ; CPMU COP Timer Arm/Reset Bit 0
CPMUARMCOP_BIT1:    equ    1                                         ; CPMU COP Timer Arm/Reset Bit 1
CPMUARMCOP_BIT2:    equ    2                                         ; CPMU COP Timer Arm/Reset Bit 2
CPMUARMCOP_BIT3:    equ    3                                         ; CPMU COP Timer Arm/Reset Bit 3
CPMUARMCOP_BIT4:    equ    4                                         ; CPMU COP Timer Arm/Reset Bit 4
CPMUARMCOP_BIT5:    equ    5                                         ; CPMU COP Timer Arm/Reset Bit 5
CPMUARMCOP_BIT6:    equ    6                                         ; CPMU COP Timer Arm/Reset Bit 6
CPMUARMCOP_BIT7:    equ    7                                         ; CPMU COP Timer Arm/Reset Bit 7
; bit position masks
mCPMUARMCOP_BIT0:   equ    %00000001
mCPMUARMCOP_BIT1:   equ    %00000010
mCPMUARMCOP_BIT2:   equ    %00000100
mCPMUARMCOP_BIT3:   equ    %00001000
mCPMUARMCOP_BIT4:   equ    %00010000
mCPMUARMCOP_BIT5:   equ    %00100000
mCPMUARMCOP_BIT6:   equ    %01000000
mCPMUARMCOP_BIT7:   equ    %10000000


;*** TIOS - Timer Input Capture/Output Compare Select; 0x00000040 ***
TIOS:               equ    $00000040                                ;*** TIOS - Timer Input Capture/Output Compare Select; 0x00000040 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TIOS_IOS0:          equ    0                                         ; Input Capture or Output Compare Channel Configuration Bit 0
TIOS_IOS1:          equ    1                                         ; Input Capture or Output Compare Channel Configuration Bit 1
TIOS_IOS2:          equ    2                                         ; Input Capture or Output Compare Channel Configuration Bit 2
TIOS_IOS3:          equ    3                                         ; Input Capture or Output Compare Channel Configuration Bit 3
TIOS_IOS4:          equ    4                                         ; Input Capture or Output Compare Channel Configuration Bit 4
TIOS_IOS5:          equ    5                                         ; Input Capture or Output Compare Channel Configuration Bit 5
TIOS_IOS6:          equ    6                                         ; Input Capture or Output Compare Channel Configuration Bit 6
TIOS_IOS7:          equ    7                                         ; Input Capture or Output Compare Channel Configuration Bit 7
; bit position masks
mTIOS_IOS0:         equ    %00000001
mTIOS_IOS1:         equ    %00000010
mTIOS_IOS2:         equ    %00000100
mTIOS_IOS3:         equ    %00001000
mTIOS_IOS4:         equ    %00010000
mTIOS_IOS5:         equ    %00100000
mTIOS_IOS6:         equ    %01000000
mTIOS_IOS7:         equ    %10000000


;*** CFORC - Timer Compare Force Register; 0x00000041 ***
CFORC:              equ    $00000041                                ;*** CFORC - Timer Compare Force Register; 0x00000041 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CFORC_FOC0:         equ    0                                         ; Force Output Compare Action for Channel 0
CFORC_FOC1:         equ    1                                         ; Force Output Compare Action for Channel 1
CFORC_FOC2:         equ    2                                         ; Force Output Compare Action for Channel 2
CFORC_FOC3:         equ    3                                         ; Force Output Compare Action for Channel 3
CFORC_FOC4:         equ    4                                         ; Force Output Compare Action for Channel 4
CFORC_FOC5:         equ    5                                         ; Force Output Compare Action for Channel 5
CFORC_FOC6:         equ    6                                         ; Force Output Compare Action for Channel 6
CFORC_FOC7:         equ    7                                         ; Force Output Compare Action for Channel 7
; bit position masks
mCFORC_FOC0:        equ    %00000001
mCFORC_FOC1:        equ    %00000010
mCFORC_FOC2:        equ    %00000100
mCFORC_FOC3:        equ    %00001000
mCFORC_FOC4:        equ    %00010000
mCFORC_FOC5:        equ    %00100000
mCFORC_FOC6:        equ    %01000000
mCFORC_FOC7:        equ    %10000000


;*** OC7M - Output Compare 7 Mask Register; 0x00000042 ***
OC7M:               equ    $00000042                                ;*** OC7M - Output Compare 7 Mask Register; 0x00000042 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
OC7M_OC7M0:         equ    0                                         ; Output Compare 7 Mask Bit 0
OC7M_OC7M1:         equ    1                                         ; Output Compare 7 Mask Bit 1
OC7M_OC7M2:         equ    2                                         ; Output Compare 7 Mask Bit 2
OC7M_OC7M3:         equ    3                                         ; Output Compare 7 Mask Bit 3
OC7M_OC7M4:         equ    4                                         ; Output Compare 7 Mask Bit 4
OC7M_OC7M5:         equ    5                                         ; Output Compare 7 Mask Bit 5
OC7M_OC7M6:         equ    6                                         ; Output Compare 7 Mask Bit 6
OC7M_OC7M7:         equ    7                                         ; Output Compare 7 Mask Bit 7
; bit position masks
mOC7M_OC7M0:        equ    %00000001
mOC7M_OC7M1:        equ    %00000010
mOC7M_OC7M2:        equ    %00000100
mOC7M_OC7M3:        equ    %00001000
mOC7M_OC7M4:        equ    %00010000
mOC7M_OC7M5:        equ    %00100000
mOC7M_OC7M6:        equ    %01000000
mOC7M_OC7M7:        equ    %10000000


;*** OC7D - Output Compare 7 Data Register; 0x00000043 ***
OC7D:               equ    $00000043                                ;*** OC7D - Output Compare 7 Data Register; 0x00000043 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
OC7D_OC7D0:         equ    0                                         ; Output Compare 7 Bit 0
OC7D_OC7D1:         equ    1                                         ; Output Compare 7 Bit 1
OC7D_OC7D2:         equ    2                                         ; Output Compare 7 Bit 2
OC7D_OC7D3:         equ    3                                         ; Output Compare 7 Bit 3
OC7D_OC7D4:         equ    4                                         ; Output Compare 7 Bit 4
OC7D_OC7D5:         equ    5                                         ; Output Compare 7 Bit 5
OC7D_OC7D6:         equ    6                                         ; Output Compare 7 Bit 6
OC7D_OC7D7:         equ    7                                         ; Output Compare 7 Bit 7
; bit position masks
mOC7D_OC7D0:        equ    %00000001
mOC7D_OC7D1:        equ    %00000010
mOC7D_OC7D2:        equ    %00000100
mOC7D_OC7D3:        equ    %00001000
mOC7D_OC7D4:        equ    %00010000
mOC7D_OC7D5:        equ    %00100000
mOC7D_OC7D6:        equ    %01000000
mOC7D_OC7D7:        equ    %10000000


;*** TCNT - Timer Count Register; 0x00000044 ***
TCNT:               equ    $00000044                                ;*** TCNT - Timer Count Register; 0x00000044 ***


;*** TCNTHi - Timer Count Register High; 0x00000044 ***
TCNTHi:             equ    $00000044                                ;*** TCNTHi - Timer Count Register High; 0x00000044 ***


;*** TCNTLo - Timer Count Register Low; 0x00000045 ***
TCNTLo:             equ    $00000045                                ;*** TCNTLo - Timer Count Register Low; 0x00000045 ***


;*** TSCR1 - Timer System Control Register1; 0x00000046 ***
TSCR1:              equ    $00000046                                ;*** TSCR1 - Timer System Control Register1; 0x00000046 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TSCR1_PRNT:         equ    3                                         ; Precision Timer
TSCR1_TFFCA:        equ    4                                         ; Timer Fast Flag Clear All
TSCR1_TSFRZ:        equ    5                                         ; Timer and Modulus Counter Stop While in Freeze Mode
TSCR1_TSWAI:        equ    6                                         ; Timer Module Stops While in Wait
TSCR1_TEN:          equ    7                                         ; Timer Enable
; bit position masks
mTSCR1_PRNT:        equ    %00001000
mTSCR1_TFFCA:       equ    %00010000
mTSCR1_TSFRZ:       equ    %00100000
mTSCR1_TSWAI:       equ    %01000000
mTSCR1_TEN:         equ    %10000000


;*** TTOV - Timer Toggle On Overflow Register; 0x00000047 ***
TTOV:               equ    $00000047                                ;*** TTOV - Timer Toggle On Overflow Register; 0x00000047 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TTOV_TOV0:          equ    0                                         ; Toggle On Overflow Bit 0
TTOV_TOV1:          equ    1                                         ; Toggle On Overflow Bit 1
TTOV_TOV2:          equ    2                                         ; Toggle On Overflow Bit 2
TTOV_TOV3:          equ    3                                         ; Toggle On Overflow Bit 3
TTOV_TOV4:          equ    4                                         ; Toggle On Overflow Bit 4
TTOV_TOV5:          equ    5                                         ; Toggle On Overflow Bit 5
TTOV_TOV6:          equ    6                                         ; Toggle On Overflow Bit 6
TTOV_TOV7:          equ    7                                         ; Toggle On Overflow Bit 7
; bit position masks
mTTOV_TOV0:         equ    %00000001
mTTOV_TOV1:         equ    %00000010
mTTOV_TOV2:         equ    %00000100
mTTOV_TOV3:         equ    %00001000
mTTOV_TOV4:         equ    %00010000
mTTOV_TOV5:         equ    %00100000
mTTOV_TOV6:         equ    %01000000
mTTOV_TOV7:         equ    %10000000


;*** TCTL1 - Timer Control Register 1; 0x00000048 ***
TCTL1:              equ    $00000048                                ;*** TCTL1 - Timer Control Register 1; 0x00000048 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TCTL1_OL4:          equ    0                                         ; Output Level Bit 4
TCTL1_OM4:          equ    1                                         ; Output Mode Bit 4
TCTL1_OL5:          equ    2                                         ; Output Level Bit 5
TCTL1_OM5:          equ    3                                         ; Output Mode Bit 5
TCTL1_OL6:          equ    4                                         ; Output Level Bit 6
TCTL1_OM6:          equ    5                                         ; Output Mode Bit 6
TCTL1_OL7:          equ    6                                         ; Output Level Bit 7
TCTL1_OM7:          equ    7                                         ; Output Mode Bit 7
; bit position masks
mTCTL1_OL4:         equ    %00000001
mTCTL1_OM4:         equ    %00000010
mTCTL1_OL5:         equ    %00000100
mTCTL1_OM5:         equ    %00001000
mTCTL1_OL6:         equ    %00010000
mTCTL1_OM6:         equ    %00100000
mTCTL1_OL7:         equ    %01000000
mTCTL1_OM7:         equ    %10000000


;*** TCTL2 - Timer Control Register 2; 0x00000049 ***
TCTL2:              equ    $00000049                                ;*** TCTL2 - Timer Control Register 2; 0x00000049 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TCTL2_OL0:          equ    0                                         ; Output Level Bit 0
TCTL2_OM0:          equ    1                                         ; Output Mode Bit 0
TCTL2_OL1:          equ    2                                         ; Output Lecel Bit 1
TCTL2_OM1:          equ    3                                         ; Output Mode Bit 1
TCTL2_OL2:          equ    4                                         ; Output Level Bit 2
TCTL2_OM2:          equ    5                                         ; Output Mode Bit 2
TCTL2_OL3:          equ    6                                         ; Output Level Bit 3
TCTL2_OM3:          equ    7                                         ; Output Mode Bit 3
; bit position masks
mTCTL2_OL0:         equ    %00000001
mTCTL2_OM0:         equ    %00000010
mTCTL2_OL1:         equ    %00000100
mTCTL2_OM1:         equ    %00001000
mTCTL2_OL2:         equ    %00010000
mTCTL2_OM2:         equ    %00100000
mTCTL2_OL3:         equ    %01000000
mTCTL2_OM3:         equ    %10000000


;*** TCTL3 - Timer Control Register 3; 0x0000004A ***
TCTL3:              equ    $0000004A                                ;*** TCTL3 - Timer Control Register 3; 0x0000004A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TCTL3_EDG4A:        equ    0                                         ; Input Capture Edge Control 4A
TCTL3_EDG4B:        equ    1                                         ; Input Capture Edge Control 4B
TCTL3_EDG5A:        equ    2                                         ; Input Capture Edge Control 5A
TCTL3_EDG5B:        equ    3                                         ; Input Capture Edge Control 5B
TCTL3_EDG6A:        equ    4                                         ; Input Capture Edge Control 6A
TCTL3_EDG6B:        equ    5                                         ; Input Capture Edge Control 6B
TCTL3_EDG7A:        equ    6                                         ; Input Capture Edge Control 7A
TCTL3_EDG7B:        equ    7                                         ; Input Capture Edge Control 7B
; bit position masks
mTCTL3_EDG4A:       equ    %00000001
mTCTL3_EDG4B:       equ    %00000010
mTCTL3_EDG5A:       equ    %00000100
mTCTL3_EDG5B:       equ    %00001000
mTCTL3_EDG6A:       equ    %00010000
mTCTL3_EDG6B:       equ    %00100000
mTCTL3_EDG7A:       equ    %01000000
mTCTL3_EDG7B:       equ    %10000000


;*** TCTL4 - Timer Control Register 4; 0x0000004B ***
TCTL4:              equ    $0000004B                                ;*** TCTL4 - Timer Control Register 4; 0x0000004B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TCTL4_EDG0A:        equ    0                                         ; Input Capture Edge Control 0A
TCTL4_EDG0B:        equ    1                                         ; Input Capture Edge Control 0B
TCTL4_EDG1A:        equ    2                                         ; Input Capture Edge Control 1A
TCTL4_EDG1B:        equ    3                                         ; Input Capture Edge Control 1B
TCTL4_EDG2A:        equ    4                                         ; Input Capture Edge Control 2A
TCTL4_EDG2B:        equ    5                                         ; Input Capture Edge Control 2B
TCTL4_EDG3A:        equ    6                                         ; Input Capture Edge Control 3A
TCTL4_EDG3B:        equ    7                                         ; Input Capture Edge Control 3B
; bit position masks
mTCTL4_EDG0A:       equ    %00000001
mTCTL4_EDG0B:       equ    %00000010
mTCTL4_EDG1A:       equ    %00000100
mTCTL4_EDG1B:       equ    %00001000
mTCTL4_EDG2A:       equ    %00010000
mTCTL4_EDG2B:       equ    %00100000
mTCTL4_EDG3A:       equ    %01000000
mTCTL4_EDG3B:       equ    %10000000


;*** TIE - Timer Interrupt Enable Register; 0x0000004C ***
TIE:                equ    $0000004C                                ;*** TIE - Timer Interrupt Enable Register; 0x0000004C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TIE_C0I:            equ    0                                         ; Input Capture/Output Compare Interrupt Enable Bit 0
TIE_C1I:            equ    1                                         ; Input Capture/Output Compare Interrupt Enable Bit 1
TIE_C2I:            equ    2                                         ; Input Capture/Output Compare Interrupt Enable Bit 2
TIE_C3I:            equ    3                                         ; Input Capture/Output Compare Interrupt Enable Bit 3
TIE_C4I:            equ    4                                         ; Input Capture/Output Compare Interrupt Enable Bit 4
TIE_C5I:            equ    5                                         ; Input Capture/Output Compare Interrupt Enable Bit 5
TIE_C6I:            equ    6                                         ; Input Capture/Output Compare Interrupt Enable Bit 6
TIE_C7I:            equ    7                                         ; Input Capture/Output Compare Interrupt Enable Bit 7
; bit position masks
mTIE_C0I:           equ    %00000001
mTIE_C1I:           equ    %00000010
mTIE_C2I:           equ    %00000100
mTIE_C3I:           equ    %00001000
mTIE_C4I:           equ    %00010000
mTIE_C5I:           equ    %00100000
mTIE_C6I:           equ    %01000000
mTIE_C7I:           equ    %10000000


;*** TSCR2 - Timer System Control Register 2; 0x0000004D ***
TSCR2:              equ    $0000004D                                ;*** TSCR2 - Timer System Control Register 2; 0x0000004D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TSCR2_PR0:          equ    0                                         ; Timer Prescaler Select Bit 0
TSCR2_PR1:          equ    1                                         ; Timer Prescaler Select Bit 1
TSCR2_PR2:          equ    2                                         ; Timer Prescaler Select Bit 2
TSCR2_TCRE:         equ    3                                         ; Timer Counter Reset Enable
TSCR2_TOI:          equ    7                                         ; Timer Overflow Interrupt Enable
; bit position masks
mTSCR2_PR0:         equ    %00000001
mTSCR2_PR1:         equ    %00000010
mTSCR2_PR2:         equ    %00000100
mTSCR2_TCRE:        equ    %00001000
mTSCR2_TOI:         equ    %10000000


;*** TFLG1 - Main Timer Interrupt Flag 1; 0x0000004E ***
TFLG1:              equ    $0000004E                                ;*** TFLG1 - Main Timer Interrupt Flag 1; 0x0000004E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TFLG1_C0F:          equ    0                                         ; Input Capture/Output Compare Channel Flag 0
TFLG1_C1F:          equ    1                                         ; Input Capture/Output Compare Channel Flag 1
TFLG1_C2F:          equ    2                                         ; Input Capture/Output Compare Channel Flag 2
TFLG1_C3F:          equ    3                                         ; Input Capture/Output Compare Channel Flag 3
TFLG1_C4F:          equ    4                                         ; Input Capture/Output Compare Channel Flag 4
TFLG1_C5F:          equ    5                                         ; Input Capture/Output Compare Channel Flag 5
TFLG1_C6F:          equ    6                                         ; Input Capture/Output Compare Channel Flag 6
TFLG1_C7F:          equ    7                                         ; Input Capture/Output Compare Channel Flag 7
; bit position masks
mTFLG1_C0F:         equ    %00000001
mTFLG1_C1F:         equ    %00000010
mTFLG1_C2F:         equ    %00000100
mTFLG1_C3F:         equ    %00001000
mTFLG1_C4F:         equ    %00010000
mTFLG1_C5F:         equ    %00100000
mTFLG1_C6F:         equ    %01000000
mTFLG1_C7F:         equ    %10000000


;*** TFLG2 - Main Timer Interrupt Flag 2; 0x0000004F ***
TFLG2:              equ    $0000004F                                ;*** TFLG2 - Main Timer Interrupt Flag 2; 0x0000004F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TFLG2_TOF:          equ    7                                         ; Timer Overflow Flag
; bit position masks
mTFLG2_TOF:         equ    %10000000


;*** TC0 - Timer Input Capture/Output Compare Register 0; 0x00000050 ***
TC0:                equ    $00000050                                ;*** TC0 - Timer Input Capture/Output Compare Register 0; 0x00000050 ***


;*** TC0Hi - Timer Input Capture/Output Compare Register 0 High; 0x00000050 ***
TC0Hi:              equ    $00000050                                ;*** TC0Hi - Timer Input Capture/Output Compare Register 0 High; 0x00000050 ***


;*** TC0Lo - Timer Input Capture/Output Compare Register 0 Low; 0x00000051 ***
TC0Lo:              equ    $00000051                                ;*** TC0Lo - Timer Input Capture/Output Compare Register 0 Low; 0x00000051 ***


;*** TC1 - Timer Input Capture/Output Compare Register 1; 0x00000052 ***
TC1:                equ    $00000052                                ;*** TC1 - Timer Input Capture/Output Compare Register 1; 0x00000052 ***


;*** TC1Hi - Timer Input Capture/Output Compare Register 1 High; 0x00000052 ***
TC1Hi:              equ    $00000052                                ;*** TC1Hi - Timer Input Capture/Output Compare Register 1 High; 0x00000052 ***


;*** TC1Lo - Timer Input Capture/Output Compare Register 1 Low; 0x00000053 ***
TC1Lo:              equ    $00000053                                ;*** TC1Lo - Timer Input Capture/Output Compare Register 1 Low; 0x00000053 ***


;*** TC2 - Timer Input Capture/Output Compare Register 2; 0x00000054 ***
TC2:                equ    $00000054                                ;*** TC2 - Timer Input Capture/Output Compare Register 2; 0x00000054 ***


;*** TC2Hi - Timer Input Capture/Output Compare Register 2 High; 0x00000054 ***
TC2Hi:              equ    $00000054                                ;*** TC2Hi - Timer Input Capture/Output Compare Register 2 High; 0x00000054 ***


;*** TC2Lo - Timer Input Capture/Output Compare Register 2 Low; 0x00000055 ***
TC2Lo:              equ    $00000055                                ;*** TC2Lo - Timer Input Capture/Output Compare Register 2 Low; 0x00000055 ***


;*** TC3 - Timer Input Capture/Output Compare Register 3; 0x00000056 ***
TC3:                equ    $00000056                                ;*** TC3 - Timer Input Capture/Output Compare Register 3; 0x00000056 ***


;*** TC3Hi - Timer Input Capture/Output Compare Register 3 High; 0x00000056 ***
TC3Hi:              equ    $00000056                                ;*** TC3Hi - Timer Input Capture/Output Compare Register 3 High; 0x00000056 ***


;*** TC3Lo - Timer Input Capture/Output Compare Register 3 Low; 0x00000057 ***
TC3Lo:              equ    $00000057                                ;*** TC3Lo - Timer Input Capture/Output Compare Register 3 Low; 0x00000057 ***


;*** TC4 - Timer Input Capture/Output Compare Register 4; 0x00000058 ***
TC4:                equ    $00000058                                ;*** TC4 - Timer Input Capture/Output Compare Register 4; 0x00000058 ***


;*** TC4Hi - Timer Input Capture/Output Compare Register 4 High; 0x00000058 ***
TC4Hi:              equ    $00000058                                ;*** TC4Hi - Timer Input Capture/Output Compare Register 4 High; 0x00000058 ***


;*** TC4Lo - Timer Input Capture/Output Compare Register 4 Low; 0x00000059 ***
TC4Lo:              equ    $00000059                                ;*** TC4Lo - Timer Input Capture/Output Compare Register 4 Low; 0x00000059 ***


;*** TC5 - Timer Input Capture/Output Compare Register 5; 0x0000005A ***
TC5:                equ    $0000005A                                ;*** TC5 - Timer Input Capture/Output Compare Register 5; 0x0000005A ***


;*** TC5Hi - Timer Input Capture/Output Compare Register 5 High; 0x0000005A ***
TC5Hi:              equ    $0000005A                                ;*** TC5Hi - Timer Input Capture/Output Compare Register 5 High; 0x0000005A ***


;*** TC5Lo - Timer Input Capture/Output Compare Register 5 Low; 0x0000005B ***
TC5Lo:              equ    $0000005B                                ;*** TC5Lo - Timer Input Capture/Output Compare Register 5 Low; 0x0000005B ***


;*** TC6 - Timer Input Capture/Output Compare Register 6; 0x0000005C ***
TC6:                equ    $0000005C                                ;*** TC6 - Timer Input Capture/Output Compare Register 6; 0x0000005C ***


;*** TC6Hi - Timer Input Capture/Output Compare Register 6 High; 0x0000005C ***
TC6Hi:              equ    $0000005C                                ;*** TC6Hi - Timer Input Capture/Output Compare Register 6 High; 0x0000005C ***


;*** TC6Lo - Timer Input Capture/Output Compare Register 6 Low; 0x0000005D ***
TC6Lo:              equ    $0000005D                                ;*** TC6Lo - Timer Input Capture/Output Compare Register 6 Low; 0x0000005D ***


;*** TC7 - Timer Input Capture/Output Compare Register 7; 0x0000005E ***
TC7:                equ    $0000005E                                ;*** TC7 - Timer Input Capture/Output Compare Register 7; 0x0000005E ***


;*** TC7Hi - Timer Input Capture/Output Compare Register 7 High; 0x0000005E ***
TC7Hi:              equ    $0000005E                                ;*** TC7Hi - Timer Input Capture/Output Compare Register 7 High; 0x0000005E ***


;*** TC7Lo - Timer Input Capture/Output Compare Register 7 Low; 0x0000005F ***
TC7Lo:              equ    $0000005F                                ;*** TC7Lo - Timer Input Capture/Output Compare Register 7 Low; 0x0000005F ***


;*** PACTL - 16-Bit Pulse Accumulator A Control Register; 0x00000060 ***
PACTL:              equ    $00000060                                ;*** PACTL - 16-Bit Pulse Accumulator A Control Register; 0x00000060 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PACTL_PAI:          equ    0                                         ; Pulse Accumulator Input Interrupt enable
PACTL_PAOVI:        equ    1                                         ; Pulse Accumulator A Overflow Interrupt enable
PACTL_CLK0:         equ    2                                         ; Clock Select Bit 0
PACTL_CLK1:         equ    3                                         ; Clock Select Bit 1
PACTL_PEDGE:        equ    4                                         ; Pulse Accumulator Edge Control
PACTL_PAMOD:        equ    5                                         ; Pulse Accumulator Mode
PACTL_PAEN:         equ    6                                         ; Pulse Accumulator A System Enable
; bit position masks
mPACTL_PAI:         equ    %00000001
mPACTL_PAOVI:       equ    %00000010
mPACTL_CLK0:        equ    %00000100
mPACTL_CLK1:        equ    %00001000
mPACTL_PEDGE:       equ    %00010000
mPACTL_PAMOD:       equ    %00100000
mPACTL_PAEN:        equ    %01000000


;*** PAFLG - Pulse Accumulator A Flag Register; 0x00000061 ***
PAFLG:              equ    $00000061                                ;*** PAFLG - Pulse Accumulator A Flag Register; 0x00000061 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PAFLG_PAIF:         equ    0                                         ; Pulse Accumulator Input edge Flag
PAFLG_PAOVF:        equ    1                                         ; Pulse Accumulator A Overflow Flag
; bit position masks
mPAFLG_PAIF:        equ    %00000001
mPAFLG_PAOVF:       equ    %00000010


;*** PACNT - Pulse Accumulators Count Register; 0x00000062 ***
PACNT:              equ    $00000062                                ;*** PACNT - Pulse Accumulators Count Register; 0x00000062 ***


;*** PACNTH - Pulse Accumulators Count Register High; 0x00000062 ***
PACNTH:             equ    $00000062                                ;*** PACNTH - Pulse Accumulators Count Register High; 0x00000062 ***


;*** PACNTL - Pulse Accumulators Count Register Low; 0x00000063 ***
PACNTL:             equ    $00000063                                ;*** PACNTL - Pulse Accumulators Count Register Low; 0x00000063 ***


;*** OCPD - Output Compare Pin Disconnect Register; 0x0000006C ***
OCPD:               equ    $0000006C                                ;*** OCPD - Output Compare Pin Disconnect Register; 0x0000006C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
OCPD_OCPD0:         equ    0                                         ; Output Compare Pin Disconnect Bit 0
OCPD_OCPD1:         equ    1                                         ; Output Compare Pin Disconnect Bit 1
OCPD_OCPD2:         equ    2                                         ; Output Compare Pin Disconnect Bit 2
OCPD_OCPD3:         equ    3                                         ; Output Compare Pin Disconnect Bit 3
OCPD_OCPD4:         equ    4                                         ; Output Compare Pin Disconnect Bit 4
OCPD_OCPD5:         equ    5                                         ; Output Compare Pin Disconnect Bit 5
OCPD_OCPD6:         equ    6                                         ; Output Compare Pin Disconnect Bit 6
OCPD_OCPD7:         equ    7                                         ; Output Compare Pin Disconnect Bit 7
; bit position masks
mOCPD_OCPD0:        equ    %00000001
mOCPD_OCPD1:        equ    %00000010
mOCPD_OCPD2:        equ    %00000100
mOCPD_OCPD3:        equ    %00001000
mOCPD_OCPD4:        equ    %00010000
mOCPD_OCPD5:        equ    %00100000
mOCPD_OCPD6:        equ    %01000000
mOCPD_OCPD7:        equ    %10000000


;*** PTPSR - Precision Timer Prescaler Select Register; 0x0000006E ***
PTPSR:              equ    $0000006E                                ;*** PTPSR - Precision Timer Prescaler Select Register; 0x0000006E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTPSR_PTPS0:        equ    0                                         ; Precision Timer Prescaler Select Bit 0
PTPSR_PTPS1:        equ    1                                         ; Precision Timer Prescaler Select Bit 1
PTPSR_PTPS2:        equ    2                                         ; Precision Timer Prescaler Select Bit 2
PTPSR_PTPS3:        equ    3                                         ; Precision Timer Prescaler Select Bit 3
PTPSR_PTPS4:        equ    4                                         ; Precision Timer Prescaler Select Bit 4
PTPSR_PTPS5:        equ    5                                         ; Precision Timer Prescaler Select Bit 5
PTPSR_PTPS6:        equ    6                                         ; Precision Timer Prescaler Select Bit 6
PTPSR_PTPS7:        equ    7                                         ; Precision Timer Prescaler Select Bit 7
; bit position masks
mPTPSR_PTPS0:       equ    %00000001
mPTPSR_PTPS1:       equ    %00000010
mPTPSR_PTPS2:       equ    %00000100
mPTPSR_PTPS3:       equ    %00001000
mPTPSR_PTPS4:       equ    %00010000
mPTPSR_PTPS5:       equ    %00100000
mPTPSR_PTPS6:       equ    %01000000
mPTPSR_PTPS7:       equ    %10000000


;*** ATDCTL01 - ATD  Control Register 01; 0x00000070 ***
ATDCTL01:           equ    $00000070                                ;*** ATDCTL01 - ATD  Control Register 01; 0x00000070 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDCTL01_ETRIGCH0:  equ    0                                         ; External Trigger Channel Select Bit 0
ATDCTL01_ETRIGCH1:  equ    1                                         ; External Trigger Channel Select Bit 1
ATDCTL01_ETRIGCH2:  equ    2                                         ; External Trigger Channel Select Bit 2
ATDCTL01_ETRIGCH3:  equ    3                                         ; External Trigger Channel Select Bit 3
ATDCTL01_SMP_DIS:   equ    4                                         ; Discharge Before Sampling Bit
ATDCTL01_SRES0:     equ    5                                         ; A/D Resolution Select Bit 0
ATDCTL01_SRES1:     equ    6                                         ; A/D Resolution Select Bit 1
ATDCTL01_ETRIGSEL:  equ    7                                         ; External Trigger Source Select
ATDCTL01_WRAP0:     equ    8                                         ; Wrap Around Channel Select Bit 0
ATDCTL01_WRAP1:     equ    9                                         ; Wrap Around Channel Select Bit 1
ATDCTL01_WRAP2:     equ    10                                        ; Wrap Around Channel Select Bit 2
ATDCTL01_WRAP3:     equ    11                                        ; Wrap Around Channel Select Bit 3
; bit position masks
mATDCTL01_ETRIGCH0: equ    %00000001
mATDCTL01_ETRIGCH1: equ    %00000010
mATDCTL01_ETRIGCH2: equ    %00000100
mATDCTL01_ETRIGCH3: equ    %00001000
mATDCTL01_SMP_DIS:  equ    %00010000
mATDCTL01_SRES0:    equ    %00100000
mATDCTL01_SRES1:    equ    %01000000
mATDCTL01_ETRIGSEL: equ    %10000000
mATDCTL01_WRAP0:    equ    %100000000
mATDCTL01_WRAP1:    equ    %1000000000
mATDCTL01_WRAP2:    equ    %10000000000
mATDCTL01_WRAP3:    equ    %100000000000


;*** ATDCTL0 - ATD  Control Register 0; 0x00000070 ***
ATDCTL0:            equ    $00000070                                ;*** ATDCTL0 - ATD  Control Register 0; 0x00000070 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDCTL0_WRAP0:      equ    0                                         ; Wrap Around Channel Select Bit 0
ATDCTL0_WRAP1:      equ    1                                         ; Wrap Around Channel Select Bit 1
ATDCTL0_WRAP2:      equ    2                                         ; Wrap Around Channel Select Bit 2
ATDCTL0_WRAP3:      equ    3                                         ; Wrap Around Channel Select Bit 3
; bit position masks
mATDCTL0_WRAP0:     equ    %00000001
mATDCTL0_WRAP1:     equ    %00000010
mATDCTL0_WRAP2:     equ    %00000100
mATDCTL0_WRAP3:     equ    %00001000


;*** ATDCTL1 - ATD  Control Register 1; 0x00000071 ***
ATDCTL1:            equ    $00000071                                ;*** ATDCTL1 - ATD  Control Register 1; 0x00000071 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDCTL1_ETRIGCH0:   equ    0                                         ; External Trigger Channel Select Bit 0
ATDCTL1_ETRIGCH1:   equ    1                                         ; External Trigger Channel Select Bit 1
ATDCTL1_ETRIGCH2:   equ    2                                         ; External Trigger Channel Select Bit 2
ATDCTL1_ETRIGCH3:   equ    3                                         ; External Trigger Channel Select Bit 3
ATDCTL1_SMP_DIS:    equ    4                                         ; Discharge Before Sampling Bit
ATDCTL1_SRES0:      equ    5                                         ; A/D Resolution Select Bit 0
ATDCTL1_SRES1:      equ    6                                         ; A/D Resolution Select Bit 1
ATDCTL1_ETRIGSEL:   equ    7                                         ; External Trigger Source Select
; bit position masks
mATDCTL1_ETRIGCH0:  equ    %00000001
mATDCTL1_ETRIGCH1:  equ    %00000010
mATDCTL1_ETRIGCH2:  equ    %00000100
mATDCTL1_ETRIGCH3:  equ    %00001000
mATDCTL1_SMP_DIS:   equ    %00010000
mATDCTL1_SRES0:     equ    %00100000
mATDCTL1_SRES1:     equ    %01000000
mATDCTL1_ETRIGSEL:  equ    %10000000


;*** ATDCTL23 - ATD  Control Register 23; 0x00000072 ***
ATDCTL23:           equ    $00000072                                ;*** ATDCTL23 - ATD  Control Register 23; 0x00000072 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDCTL23_FRZ0:      equ    0                                         ; Background Debug Freeze Enable Bit 0
ATDCTL23_FRZ1:      equ    1                                         ; Background Debug Freeze Enable Bit 1
ATDCTL23_FIFO:      equ    2                                         ; Result Register FIFO Mode
ATDCTL23_S1C:       equ    3                                         ; Conversion Sequence Length 1
ATDCTL23_S2C:       equ    4                                         ; Conversion Sequence Length 2
ATDCTL23_S4C:       equ    5                                         ; Conversion Sequence Length 4
ATDCTL23_S8C:       equ    6                                         ; Conversion Sequence Length 8
ATDCTL23_DJM:       equ    7                                         ; Result Register Data Justification
ATDCTL23_ACMPIE:    equ    8                                         ; ATD Compare Interrupt Enable
ATDCTL23_ASCIE:     equ    9                                         ; ATD Sequence Complete Interrupt Enable
ATDCTL23_ETRIGE:    equ    10                                        ; External Trigger Mode enable
ATDCTL23_ETRIGP:    equ    11                                        ; External Trigger Polarity
ATDCTL23_ETRIGLE:   equ    12                                        ; External Trigger Level/Edge control
ATDCTL23_AFFC:      equ    14                                        ; ATD Fast Conversion Complete Flag Clear
; bit position masks
mATDCTL23_FRZ0:     equ    %00000001
mATDCTL23_FRZ1:     equ    %00000010
mATDCTL23_FIFO:     equ    %00000100
mATDCTL23_S1C:      equ    %00001000
mATDCTL23_S2C:      equ    %00010000
mATDCTL23_S4C:      equ    %00100000
mATDCTL23_S8C:      equ    %01000000
mATDCTL23_DJM:      equ    %10000000
mATDCTL23_ACMPIE:   equ    %100000000
mATDCTL23_ASCIE:    equ    %1000000000
mATDCTL23_ETRIGE:   equ    %10000000000
mATDCTL23_ETRIGP:   equ    %100000000000
mATDCTL23_ETRIGLE:  equ    %1000000000000
mATDCTL23_AFFC:     equ    %100000000000000


;*** ATDCTL2 - ATD  Control Register 2; 0x00000072 ***
ATDCTL2:            equ    $00000072                                ;*** ATDCTL2 - ATD  Control Register 2; 0x00000072 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDCTL2_ACMPIE:     equ    0                                         ; ATD Compare Interrupt Enable
ATDCTL2_ASCIE:      equ    1                                         ; ATD Sequence Complete Interrupt Enable
ATDCTL2_ETRIGE:     equ    2                                         ; External Trigger Mode enable
ATDCTL2_ETRIGP:     equ    3                                         ; External Trigger Polarity
ATDCTL2_ETRIGLE:    equ    4                                         ; External Trigger Level/Edge control
ATDCTL2_AFFC:       equ    6                                         ; ATD Fast Conversion Complete Flag Clear
; bit position masks
mATDCTL2_ACMPIE:    equ    %00000001
mATDCTL2_ASCIE:     equ    %00000010
mATDCTL2_ETRIGE:    equ    %00000100
mATDCTL2_ETRIGP:    equ    %00001000
mATDCTL2_ETRIGLE:   equ    %00010000
mATDCTL2_AFFC:      equ    %01000000


;*** ATDCTL3 - ATD  Control Register 3; 0x00000073 ***
ATDCTL3:            equ    $00000073                                ;*** ATDCTL3 - ATD  Control Register 3; 0x00000073 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDCTL3_FRZ0:       equ    0                                         ; Background Debug Freeze Enable Bit 0
ATDCTL3_FRZ1:       equ    1                                         ; Background Debug Freeze Enable Bit 1
ATDCTL3_FIFO:       equ    2                                         ; Result Register FIFO Mode
ATDCTL3_S1C:        equ    3                                         ; Conversion Sequence Length 1
ATDCTL3_S2C:        equ    4                                         ; Conversion Sequence Length 2
ATDCTL3_S4C:        equ    5                                         ; Conversion Sequence Length 4
ATDCTL3_S8C:        equ    6                                         ; Conversion Sequence Length 8
ATDCTL3_DJM:        equ    7                                         ; Result Register Data Justification
; bit position masks
mATDCTL3_FRZ0:      equ    %00000001
mATDCTL3_FRZ1:      equ    %00000010
mATDCTL3_FIFO:      equ    %00000100
mATDCTL3_S1C:       equ    %00001000
mATDCTL3_S2C:       equ    %00010000
mATDCTL3_S4C:       equ    %00100000
mATDCTL3_S8C:       equ    %01000000
mATDCTL3_DJM:       equ    %10000000


;*** ATDCTL45 - ATD  Control Register 45; 0x00000074 ***
ATDCTL45:           equ    $00000074                                ;*** ATDCTL45 - ATD  Control Register 45; 0x00000074 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDCTL45_CA:        equ    0                                         ; Analog Input Channel Select Code A
ATDCTL45_CB:        equ    1                                         ; Analog Input Channel Select Code B
ATDCTL45_CC:        equ    2                                         ; Analog Input Channel Select Code C
ATDCTL45_CD:        equ    3                                         ; Analog Input Channel Select Code D
ATDCTL45_MULT:      equ    4                                         ; Multi-Channel Sample Mode
ATDCTL45_SCAN:      equ    5                                         ; Continuous Conversion Sequence Mode
ATDCTL45_SC:        equ    6                                         ; Special Channel Conversion Bit
ATDCTL45_PRS0:      equ    8                                         ; ATD Clock Prescaler 0
ATDCTL45_PRS1:      equ    9                                         ; ATD Clock Prescaler 1
ATDCTL45_PRS2:      equ    10                                        ; ATD Clock Prescaler 2
ATDCTL45_PRS3:      equ    11                                        ; ATD Clock Prescaler 3
ATDCTL45_PRS4:      equ    12                                        ; ATD Clock Prescaler 4
ATDCTL45_SMP0:      equ    13                                        ; Sample Time Select 0
ATDCTL45_SMP1:      equ    14                                        ; Sample Time Select 1
ATDCTL45_SMP2:      equ    15                                        ; Sample Time Select 2
; bit position masks
mATDCTL45_CA:       equ    %00000001
mATDCTL45_CB:       equ    %00000010
mATDCTL45_CC:       equ    %00000100
mATDCTL45_CD:       equ    %00001000
mATDCTL45_MULT:     equ    %00010000
mATDCTL45_SCAN:     equ    %00100000
mATDCTL45_SC:       equ    %01000000
mATDCTL45_PRS0:     equ    %100000000
mATDCTL45_PRS1:     equ    %1000000000
mATDCTL45_PRS2:     equ    %10000000000
mATDCTL45_PRS3:     equ    %100000000000
mATDCTL45_PRS4:     equ    %1000000000000
mATDCTL45_SMP0:     equ    %10000000000000
mATDCTL45_SMP1:     equ    %100000000000000
mATDCTL45_SMP2:     equ    %1000000000000000


;*** ATDCTL4 - ATD  Control Register 4; 0x00000074 ***
ATDCTL4:            equ    $00000074                                ;*** ATDCTL4 - ATD  Control Register 4; 0x00000074 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDCTL4_PRS0:       equ    0                                         ; ATD Clock Prescaler 0
ATDCTL4_PRS1:       equ    1                                         ; ATD Clock Prescaler 1
ATDCTL4_PRS2:       equ    2                                         ; ATD Clock Prescaler 2
ATDCTL4_PRS3:       equ    3                                         ; ATD Clock Prescaler 3
ATDCTL4_PRS4:       equ    4                                         ; ATD Clock Prescaler 4
ATDCTL4_SMP0:       equ    5                                         ; Sample Time Select 0
ATDCTL4_SMP1:       equ    6                                         ; Sample Time Select 1
ATDCTL4_SMP2:       equ    7                                         ; Sample Time Select 2
; bit position masks
mATDCTL4_PRS0:      equ    %00000001
mATDCTL4_PRS1:      equ    %00000010
mATDCTL4_PRS2:      equ    %00000100
mATDCTL4_PRS3:      equ    %00001000
mATDCTL4_PRS4:      equ    %00010000
mATDCTL4_SMP0:      equ    %00100000
mATDCTL4_SMP1:      equ    %01000000
mATDCTL4_SMP2:      equ    %10000000


;*** ATDCTL5 - ATD  Control Register 5; 0x00000075 ***
ATDCTL5:            equ    $00000075                                ;*** ATDCTL5 - ATD  Control Register 5; 0x00000075 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDCTL5_CA:         equ    0                                         ; Analog Input Channel Select Code A
ATDCTL5_CB:         equ    1                                         ; Analog Input Channel Select Code B
ATDCTL5_CC:         equ    2                                         ; Analog Input Channel Select Code C
ATDCTL5_CD:         equ    3                                         ; Analog Input Channel Select Code D
ATDCTL5_MULT:       equ    4                                         ; Multi-Channel Sample Mode
ATDCTL5_SCAN:       equ    5                                         ; Continuous Conversion Sequence Mode
ATDCTL5_SC:         equ    6                                         ; Special Channel Conversion Bit
; bit position masks
mATDCTL5_CA:        equ    %00000001
mATDCTL5_CB:        equ    %00000010
mATDCTL5_CC:        equ    %00000100
mATDCTL5_CD:        equ    %00001000
mATDCTL5_MULT:      equ    %00010000
mATDCTL5_SCAN:      equ    %00100000
mATDCTL5_SC:        equ    %01000000


;*** ATDSTAT0 - ATD  Status Register 0; 0x00000076 ***
ATDSTAT0:           equ    $00000076                                ;*** ATDSTAT0 - ATD  Status Register 0; 0x00000076 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDSTAT0_CC0:       equ    0                                         ; Conversion Counter 0
ATDSTAT0_CC1:       equ    1                                         ; Conversion Counter 1
ATDSTAT0_CC2:       equ    2                                         ; Conversion Counter 2
ATDSTAT0_CC3:       equ    3                                         ; Conversion Counter 3
ATDSTAT0_FIFOR:     equ    4                                         ; FIFO Over Run Flag
ATDSTAT0_ETORF:     equ    5                                         ; External Trigger Overrun Flag
ATDSTAT0_SCF:       equ    7                                         ; Sequence Complete Flag
; bit position masks
mATDSTAT0_CC0:      equ    %00000001
mATDSTAT0_CC1:      equ    %00000010
mATDSTAT0_CC2:      equ    %00000100
mATDSTAT0_CC3:      equ    %00001000
mATDSTAT0_FIFOR:    equ    %00010000
mATDSTAT0_ETORF:    equ    %00100000
mATDSTAT0_SCF:      equ    %10000000


;*** ATDCMPE - ATD  Compare Enable Register; 0x00000078 ***
ATDCMPE:            equ    $00000078                                ;*** ATDCMPE - ATD  Compare Enable Register; 0x00000078 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDCMPE_CMPE0:      equ    0                                         ; Compare Enable for Conversion Number 0 of a Sequence
ATDCMPE_CMPE1:      equ    1                                         ; Compare Enable for Conversion Number 1 of a Sequence
ATDCMPE_CMPE2:      equ    2                                         ; Compare Enable for Conversion Number 2 of a Sequence
ATDCMPE_CMPE3:      equ    3                                         ; Compare Enable for Conversion Number 3 of a Sequence
ATDCMPE_CMPE4:      equ    4                                         ; Compare Enable for Conversion Number 4 of a Sequence
ATDCMPE_CMPE5:      equ    5                                         ; Compare Enable for Conversion Number 5 of a Sequence
ATDCMPE_CMPE6:      equ    6                                         ; Compare Enable for Conversion Number 6 of a Sequence
ATDCMPE_CMPE7:      equ    7                                         ; Compare Enable for Conversion Number 7 of a Sequence
ATDCMPE_CMPE8:      equ    8                                         ; Compare Enable for Conversion Number 8 of a Sequence
ATDCMPE_CMPE9:      equ    9                                         ; Compare Enable for Conversion Number 9 of a Sequence
ATDCMPE_CMPE10:     equ    10                                        ; Compare Enable for Conversion Number 10 of a Sequence
ATDCMPE_CMPE11:     equ    11                                        ; Compare Enable for Conversion Number 11 of a Sequence
ATDCMPE_CMPE12:     equ    12                                        ; Compare Enable for Conversion Number 12 of a Sequence
ATDCMPE_CMPE13:     equ    13                                        ; Compare Enable for Conversion Number 13 of a Sequence
ATDCMPE_CMPE14:     equ    14                                        ; Compare Enable for Conversion Number 14 of a Sequence
ATDCMPE_CMPE15:     equ    15                                        ; Compare Enable for Conversion Number 15 of a Sequence
; bit position masks
mATDCMPE_CMPE0:     equ    %00000001
mATDCMPE_CMPE1:     equ    %00000010
mATDCMPE_CMPE2:     equ    %00000100
mATDCMPE_CMPE3:     equ    %00001000
mATDCMPE_CMPE4:     equ    %00010000
mATDCMPE_CMPE5:     equ    %00100000
mATDCMPE_CMPE6:     equ    %01000000
mATDCMPE_CMPE7:     equ    %10000000
mATDCMPE_CMPE8:     equ    %100000000
mATDCMPE_CMPE9:     equ    %1000000000
mATDCMPE_CMPE10:    equ    %10000000000
mATDCMPE_CMPE11:    equ    %100000000000
mATDCMPE_CMPE12:    equ    %1000000000000
mATDCMPE_CMPE13:    equ    %10000000000000
mATDCMPE_CMPE14:    equ    %100000000000000
mATDCMPE_CMPE15:    equ    %1000000000000000


;*** ATDCMPEH - ATD  Compare Enable Register High; 0x00000078 ***
ATDCMPEH:           equ    $00000078                                ;*** ATDCMPEH - ATD  Compare Enable Register High; 0x00000078 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDCMPEH_CMPE8:     equ    0                                         ; Compare Enable for Conversion Number 8 of a Sequence
ATDCMPEH_CMPE9:     equ    1                                         ; Compare Enable for Conversion Number 9 of a Sequence
ATDCMPEH_CMPE10:    equ    2                                         ; Compare Enable for Conversion Number 10 of a Sequence
ATDCMPEH_CMPE11:    equ    3                                         ; Compare Enable for Conversion Number 11 of a Sequence
ATDCMPEH_CMPE12:    equ    4                                         ; Compare Enable for Conversion Number 12 of a Sequence
ATDCMPEH_CMPE13:    equ    5                                         ; Compare Enable for Conversion Number 13 of a Sequence
ATDCMPEH_CMPE14:    equ    6                                         ; Compare Enable for Conversion Number 14 of a Sequence
ATDCMPEH_CMPE15:    equ    7                                         ; Compare Enable for Conversion Number 15 of a Sequence
; bit position masks
mATDCMPEH_CMPE8:    equ    %00000001
mATDCMPEH_CMPE9:    equ    %00000010
mATDCMPEH_CMPE10:   equ    %00000100
mATDCMPEH_CMPE11:   equ    %00001000
mATDCMPEH_CMPE12:   equ    %00010000
mATDCMPEH_CMPE13:   equ    %00100000
mATDCMPEH_CMPE14:   equ    %01000000
mATDCMPEH_CMPE15:   equ    %10000000


;*** ATDCMPEL - ATD  Compare Enable Register Low; 0x00000079 ***
ATDCMPEL:           equ    $00000079                                ;*** ATDCMPEL - ATD  Compare Enable Register Low; 0x00000079 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDCMPEL_CMPE0:     equ    0                                         ; Compare Enable for Conversion Number 0 of a Sequence
ATDCMPEL_CMPE1:     equ    1                                         ; Compare Enable for Conversion Number 1 of a Sequence
ATDCMPEL_CMPE2:     equ    2                                         ; Compare Enable for Conversion Number 2 of a Sequence
ATDCMPEL_CMPE3:     equ    3                                         ; Compare Enable for Conversion Number 3 of a Sequence
ATDCMPEL_CMPE4:     equ    4                                         ; Compare Enable for Conversion Number 4 of a Sequence
ATDCMPEL_CMPE5:     equ    5                                         ; Compare Enable for Conversion Number 5 of a Sequence
ATDCMPEL_CMPE6:     equ    6                                         ; Compare Enable for Conversion Number 6 of a Sequence
ATDCMPEL_CMPE7:     equ    7                                         ; Compare Enable for Conversion Number 7 of a Sequence
; bit position masks
mATDCMPEL_CMPE0:    equ    %00000001
mATDCMPEL_CMPE1:    equ    %00000010
mATDCMPEL_CMPE2:    equ    %00000100
mATDCMPEL_CMPE3:    equ    %00001000
mATDCMPEL_CMPE4:    equ    %00010000
mATDCMPEL_CMPE5:    equ    %00100000
mATDCMPEL_CMPE6:    equ    %01000000
mATDCMPEL_CMPE7:    equ    %10000000


;*** ATDSTAT2 - ATD  Status Register 2; 0x0000007A ***
ATDSTAT2:           equ    $0000007A                                ;*** ATDSTAT2 - ATD  Status Register 2; 0x0000007A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDSTAT2_CCF0:      equ    0                                         ; Conversion Complete Flag 0
ATDSTAT2_CCF1:      equ    1                                         ; Conversion Complete Flag 1
ATDSTAT2_CCF2:      equ    2                                         ; Conversion Complete Flag 2
ATDSTAT2_CCF3:      equ    3                                         ; Conversion Complete Flag 3
ATDSTAT2_CCF4:      equ    4                                         ; Conversion Complete Flag 4
ATDSTAT2_CCF5:      equ    5                                         ; Conversion Complete Flag 5
ATDSTAT2_CCF6:      equ    6                                         ; Conversion Complete Flag 6
ATDSTAT2_CCF7:      equ    7                                         ; Conversion Complete Flag 7
ATDSTAT2_CCF8:      equ    8                                         ; Conversion Complete Flag 8
ATDSTAT2_CCF9:      equ    9                                         ; Conversion Complete Flag 9
ATDSTAT2_CCF10:     equ    10                                        ; Conversion Complete Flag 10
ATDSTAT2_CCF11:     equ    11                                        ; Conversion Complete Flag 11
ATDSTAT2_CCF12:     equ    12                                        ; Conversion Complete Flag 12
ATDSTAT2_CCF13:     equ    13                                        ; Conversion Complete Flag 13
ATDSTAT2_CCF14:     equ    14                                        ; Conversion Complete Flag 14
ATDSTAT2_CCF15:     equ    15                                        ; Conversion Complete Flag 15
; bit position masks
mATDSTAT2_CCF0:     equ    %00000001
mATDSTAT2_CCF1:     equ    %00000010
mATDSTAT2_CCF2:     equ    %00000100
mATDSTAT2_CCF3:     equ    %00001000
mATDSTAT2_CCF4:     equ    %00010000
mATDSTAT2_CCF5:     equ    %00100000
mATDSTAT2_CCF6:     equ    %01000000
mATDSTAT2_CCF7:     equ    %10000000
mATDSTAT2_CCF8:     equ    %100000000
mATDSTAT2_CCF9:     equ    %1000000000
mATDSTAT2_CCF10:    equ    %10000000000
mATDSTAT2_CCF11:    equ    %100000000000
mATDSTAT2_CCF12:    equ    %1000000000000
mATDSTAT2_CCF13:    equ    %10000000000000
mATDSTAT2_CCF14:    equ    %100000000000000
mATDSTAT2_CCF15:    equ    %1000000000000000


;*** ATDSTAT2H - ATD  Status Register 2 High; 0x0000007A ***
ATDSTAT2H:          equ    $0000007A                                ;*** ATDSTAT2H - ATD  Status Register 2 High; 0x0000007A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDSTAT2H_CCF8:     equ    0                                         ; Conversion Complete Flag 8
ATDSTAT2H_CCF9:     equ    1                                         ; Conversion Complete Flag 9
ATDSTAT2H_CCF10:    equ    2                                         ; Conversion Complete Flag 10
ATDSTAT2H_CCF11:    equ    3                                         ; Conversion Complete Flag 11
ATDSTAT2H_CCF12:    equ    4                                         ; Conversion Complete Flag 12
ATDSTAT2H_CCF13:    equ    5                                         ; Conversion Complete Flag 13
ATDSTAT2H_CCF14:    equ    6                                         ; Conversion Complete Flag 14
ATDSTAT2H_CCF15:    equ    7                                         ; Conversion Complete Flag 15
; bit position masks
mATDSTAT2H_CCF8:    equ    %00000001
mATDSTAT2H_CCF9:    equ    %00000010
mATDSTAT2H_CCF10:   equ    %00000100
mATDSTAT2H_CCF11:   equ    %00001000
mATDSTAT2H_CCF12:   equ    %00010000
mATDSTAT2H_CCF13:   equ    %00100000
mATDSTAT2H_CCF14:   equ    %01000000
mATDSTAT2H_CCF15:   equ    %10000000


;*** ATDSTAT2L - ATD  Status Register 2 Low; 0x0000007B ***
ATDSTAT2L:          equ    $0000007B                                ;*** ATDSTAT2L - ATD  Status Register 2 Low; 0x0000007B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDSTAT2L_CCF0:     equ    0                                         ; Conversion Complete Flag 0
ATDSTAT2L_CCF1:     equ    1                                         ; Conversion Complete Flag 1
ATDSTAT2L_CCF2:     equ    2                                         ; Conversion Complete Flag 2
ATDSTAT2L_CCF3:     equ    3                                         ; Conversion Complete Flag 3
ATDSTAT2L_CCF4:     equ    4                                         ; Conversion Complete Flag 4
ATDSTAT2L_CCF5:     equ    5                                         ; Conversion Complete Flag 5
ATDSTAT2L_CCF6:     equ    6                                         ; Conversion Complete Flag 6
ATDSTAT2L_CCF7:     equ    7                                         ; Conversion Complete Flag 7
; bit position masks
mATDSTAT2L_CCF0:    equ    %00000001
mATDSTAT2L_CCF1:    equ    %00000010
mATDSTAT2L_CCF2:    equ    %00000100
mATDSTAT2L_CCF3:    equ    %00001000
mATDSTAT2L_CCF4:    equ    %00010000
mATDSTAT2L_CCF5:    equ    %00100000
mATDSTAT2L_CCF6:    equ    %01000000
mATDSTAT2L_CCF7:    equ    %10000000


;*** ATDDIEN - ATD  Input Enable Register; 0x0000007C ***
ATDDIEN:            equ    $0000007C                                ;*** ATDDIEN - ATD  Input Enable Register; 0x0000007C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDIEN_IEN0:       equ    0                                         ; ATD Digital Input Enable on channel 0
ATDDIEN_IEN1:       equ    1                                         ; ATD Digital Input Enable on channel 1
ATDDIEN_IEN2:       equ    2                                         ; ATD Digital Input Enable on channel 2
ATDDIEN_IEN3:       equ    3                                         ; ATD Digital Input Enable on channel 3
ATDDIEN_IEN4:       equ    4                                         ; ATD Digital Input Enable on channel 4
ATDDIEN_IEN5:       equ    5                                         ; ATD Digital Input Enable on channel 5
ATDDIEN_IEN6:       equ    6                                         ; ATD Digital Input Enable on channel 6
ATDDIEN_IEN7:       equ    7                                         ; ATD Digital Input Enable on channel 7
ATDDIEN_IEN8:       equ    8                                         ; ATD Digital Input Enable on channel 8
ATDDIEN_IEN9:       equ    9                                         ; ATD Digital Input Enable on channel 9
ATDDIEN_IEN10:      equ    10                                        ; ATD Digital Input Enable on channel 10
ATDDIEN_IEN11:      equ    11                                        ; ATD Digital Input Enable on channel 11
ATDDIEN_IEN12:      equ    12                                        ; ATD Digital Input Enable on channel 12
ATDDIEN_IEN13:      equ    13                                        ; ATD Digital Input Enable on channel 13
ATDDIEN_IEN14:      equ    14                                        ; ATD Digital Input Enable on channel 14
ATDDIEN_IEN15:      equ    15                                        ; ATD Digital Input Enable on channel 15
; bit position masks
mATDDIEN_IEN0:      equ    %00000001
mATDDIEN_IEN1:      equ    %00000010
mATDDIEN_IEN2:      equ    %00000100
mATDDIEN_IEN3:      equ    %00001000
mATDDIEN_IEN4:      equ    %00010000
mATDDIEN_IEN5:      equ    %00100000
mATDDIEN_IEN6:      equ    %01000000
mATDDIEN_IEN7:      equ    %10000000
mATDDIEN_IEN8:      equ    %100000000
mATDDIEN_IEN9:      equ    %1000000000
mATDDIEN_IEN10:     equ    %10000000000
mATDDIEN_IEN11:     equ    %100000000000
mATDDIEN_IEN12:     equ    %1000000000000
mATDDIEN_IEN13:     equ    %10000000000000
mATDDIEN_IEN14:     equ    %100000000000000
mATDDIEN_IEN15:     equ    %1000000000000000


;*** ATDDIENH - ATD  Input Enable Register High; 0x0000007C ***
ATDDIENH:           equ    $0000007C                                ;*** ATDDIENH - ATD  Input Enable Register High; 0x0000007C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDIENH_IEN8:      equ    0                                         ; ATD Digital Input Enable on channel 8
ATDDIENH_IEN9:      equ    1                                         ; ATD Digital Input Enable on channel 9
ATDDIENH_IEN10:     equ    2                                         ; ATD Digital Input Enable on channel 10
ATDDIENH_IEN11:     equ    3                                         ; ATD Digital Input Enable on channel 11
ATDDIENH_IEN12:     equ    4                                         ; ATD Digital Input Enable on channel 12
ATDDIENH_IEN13:     equ    5                                         ; ATD Digital Input Enable on channel 13
ATDDIENH_IEN14:     equ    6                                         ; ATD Digital Input Enable on channel 14
ATDDIENH_IEN15:     equ    7                                         ; ATD Digital Input Enable on channel 15
; bit position masks
mATDDIENH_IEN8:     equ    %00000001
mATDDIENH_IEN9:     equ    %00000010
mATDDIENH_IEN10:    equ    %00000100
mATDDIENH_IEN11:    equ    %00001000
mATDDIENH_IEN12:    equ    %00010000
mATDDIENH_IEN13:    equ    %00100000
mATDDIENH_IEN14:    equ    %01000000
mATDDIENH_IEN15:    equ    %10000000


;*** ATDDIENL - ATD  Input Enable Register Low; 0x0000007D ***
ATDDIENL:           equ    $0000007D                                ;*** ATDDIENL - ATD  Input Enable Register Low; 0x0000007D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDIENL_IEN0:      equ    0                                         ; ATD Digital Input Enable on channel 0
ATDDIENL_IEN1:      equ    1                                         ; ATD Digital Input Enable on channel 1
ATDDIENL_IEN2:      equ    2                                         ; ATD Digital Input Enable on channel 2
ATDDIENL_IEN3:      equ    3                                         ; ATD Digital Input Enable on channel 3
ATDDIENL_IEN4:      equ    4                                         ; ATD Digital Input Enable on channel 4
ATDDIENL_IEN5:      equ    5                                         ; ATD Digital Input Enable on channel 5
ATDDIENL_IEN6:      equ    6                                         ; ATD Digital Input Enable on channel 6
ATDDIENL_IEN7:      equ    7                                         ; ATD Digital Input Enable on channel 7
; bit position masks
mATDDIENL_IEN0:     equ    %00000001
mATDDIENL_IEN1:     equ    %00000010
mATDDIENL_IEN2:     equ    %00000100
mATDDIENL_IEN3:     equ    %00001000
mATDDIENL_IEN4:     equ    %00010000
mATDDIENL_IEN5:     equ    %00100000
mATDDIENL_IEN6:     equ    %01000000
mATDDIENL_IEN7:     equ    %10000000


;*** ATDCMPHT - ATD  Compare Higher Than Register; 0x0000007E ***
ATDCMPHT:           equ    $0000007E                                ;*** ATDCMPHT - ATD  Compare Higher Than Register; 0x0000007E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDCMPHT_CMPHT0:    equ    0                                         ; Compare Operation Higher Than Enable for Conversion Number 0 of a Sequence
ATDCMPHT_CMPHT1:    equ    1                                         ; Compare Operation Higher Than Enable for Conversion Number 1 of a Sequence
ATDCMPHT_CMPHT2:    equ    2                                         ; Compare Operation Higher Than Enable for Conversion Number 2 of a Sequence
ATDCMPHT_CMPHT3:    equ    3                                         ; Compare Operation Higher Than Enable for Conversion Number 3 of a Sequence
ATDCMPHT_CMPHT4:    equ    4                                         ; Compare Operation Higher Than Enable for Conversion Number 4 of a Sequence
ATDCMPHT_CMPHT5:    equ    5                                         ; Compare Operation Higher Than Enable for Conversion Number 5 of a Sequence
ATDCMPHT_CMPHT6:    equ    6                                         ; Compare Operation Higher Than Enable for Conversion Number 6 of a Sequence
ATDCMPHT_CMPHT7:    equ    7                                         ; Compare Operation Higher Than Enable for Conversion Number 7 of a Sequence
ATDCMPHT_CMPHT8:    equ    8                                         ; Compare Operation Higher Than Enable for Conversion Number 8 of a Sequence
ATDCMPHT_CMPHT9:    equ    9                                         ; Compare Operation Higher Than Enable for Conversion Number 9 of a Sequence
ATDCMPHT_CMPHT10:   equ    10                                        ; Compare Operation Higher Than Enable for Conversion Number 10 of a Sequence
ATDCMPHT_CMPHT11:   equ    11                                        ; Compare Operation Higher Than Enable for Conversion Number 11 of a Sequence
ATDCMPHT_CMPHT12:   equ    12                                        ; Compare Operation Higher Than Enable for Conversion Number 12 of a Sequence
ATDCMPHT_CMPHT13:   equ    13                                        ; Compare Operation Higher Than Enable for Conversion Number 13 of a Sequence
ATDCMPHT_CMPHT14:   equ    14                                        ; Compare Operation Higher Than Enable for Conversion Number 14 of a Sequence
ATDCMPHT_CMPHT15:   equ    15                                        ; Compare Operation Higher Than Enable for Conversion Number 15 of a Sequence
; bit position masks
mATDCMPHT_CMPHT0:   equ    %00000001
mATDCMPHT_CMPHT1:   equ    %00000010
mATDCMPHT_CMPHT2:   equ    %00000100
mATDCMPHT_CMPHT3:   equ    %00001000
mATDCMPHT_CMPHT4:   equ    %00010000
mATDCMPHT_CMPHT5:   equ    %00100000
mATDCMPHT_CMPHT6:   equ    %01000000
mATDCMPHT_CMPHT7:   equ    %10000000
mATDCMPHT_CMPHT8:   equ    %100000000
mATDCMPHT_CMPHT9:   equ    %1000000000
mATDCMPHT_CMPHT10:  equ    %10000000000
mATDCMPHT_CMPHT11:  equ    %100000000000
mATDCMPHT_CMPHT12:  equ    %1000000000000
mATDCMPHT_CMPHT13:  equ    %10000000000000
mATDCMPHT_CMPHT14:  equ    %100000000000000
mATDCMPHT_CMPHT15:  equ    %1000000000000000


;*** ATDCMPHTH - ATD  Compare Higher Than Register High; 0x0000007E ***
ATDCMPHTH:          equ    $0000007E                                ;*** ATDCMPHTH - ATD  Compare Higher Than Register High; 0x0000007E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDCMPHTH_CMPHT8:   equ    0                                         ; Compare Operation Higher Than Enable for Conversion Number 8 of a Sequence
ATDCMPHTH_CMPHT9:   equ    1                                         ; Compare Operation Higher Than Enable for Conversion Number 9 of a Sequence
ATDCMPHTH_CMPHT10:  equ    2                                         ; Compare Operation Higher Than Enable for Conversion Number 10 of a Sequence
ATDCMPHTH_CMPHT11:  equ    3                                         ; Compare Operation Higher Than Enable for Conversion Number 11 of a Sequence
ATDCMPHTH_CMPHT12:  equ    4                                         ; Compare Operation Higher Than Enable for Conversion Number 12 of a Sequence
ATDCMPHTH_CMPHT13:  equ    5                                         ; Compare Operation Higher Than Enable for Conversion Number 13 of a Sequence
ATDCMPHTH_CMPHT14:  equ    6                                         ; Compare Operation Higher Than Enable for Conversion Number 14 of a Sequence
ATDCMPHTH_CMPHT15:  equ    7                                         ; Compare Operation Higher Than Enable for Conversion Number 15 of a Sequence
; bit position masks
mATDCMPHTH_CMPHT8:  equ    %00000001
mATDCMPHTH_CMPHT9:  equ    %00000010
mATDCMPHTH_CMPHT10: equ    %00000100
mATDCMPHTH_CMPHT11: equ    %00001000
mATDCMPHTH_CMPHT12: equ    %00010000
mATDCMPHTH_CMPHT13: equ    %00100000
mATDCMPHTH_CMPHT14: equ    %01000000
mATDCMPHTH_CMPHT15: equ    %10000000


;*** ATDCMPHTL - ATD  Compare Higher Than Register Low; 0x0000007F ***
ATDCMPHTL:          equ    $0000007F                                ;*** ATDCMPHTL - ATD  Compare Higher Than Register Low; 0x0000007F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDCMPHTL_CMPHT0:   equ    0                                         ; Compare Operation Higher Than Enable for Conversion Number 0 of a Sequence
ATDCMPHTL_CMPHT1:   equ    1                                         ; Compare Operation Higher Than Enable for Conversion Number 1 of a Sequence
ATDCMPHTL_CMPHT2:   equ    2                                         ; Compare Operation Higher Than Enable for Conversion Number 2 of a Sequence
ATDCMPHTL_CMPHT3:   equ    3                                         ; Compare Operation Higher Than Enable for Conversion Number 3 of a Sequence
ATDCMPHTL_CMPHT4:   equ    4                                         ; Compare Operation Higher Than Enable for Conversion Number 4 of a Sequence
ATDCMPHTL_CMPHT5:   equ    5                                         ; Compare Operation Higher Than Enable for Conversion Number 5 of a Sequence
ATDCMPHTL_CMPHT6:   equ    6                                         ; Compare Operation Higher Than Enable for Conversion Number 6 of a Sequence
ATDCMPHTL_CMPHT7:   equ    7                                         ; Compare Operation Higher Than Enable for Conversion Number 7 of a Sequence
; bit position masks
mATDCMPHTL_CMPHT0:  equ    %00000001
mATDCMPHTL_CMPHT1:  equ    %00000010
mATDCMPHTL_CMPHT2:  equ    %00000100
mATDCMPHTL_CMPHT3:  equ    %00001000
mATDCMPHTL_CMPHT4:  equ    %00010000
mATDCMPHTL_CMPHT5:  equ    %00100000
mATDCMPHTL_CMPHT6:  equ    %01000000
mATDCMPHTL_CMPHT7:  equ    %10000000


;*** ATDDR0 - ATD  Conversion Result Register 0; 0x00000080 ***
ATDDR0:             equ    $00000080                                ;*** ATDDR0 - ATD  Conversion Result Register 0; 0x00000080 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR0_BIT0:        equ    0                                         ; Bit 0
ATDDR0_BIT1:        equ    1                                         ; Bit 1
ATDDR0_BIT2:        equ    2                                         ; Bit 2
ATDDR0_BIT3:        equ    3                                         ; Bit 3
ATDDR0_BIT4:        equ    4                                         ; Bit 4
ATDDR0_BIT5:        equ    5                                         ; Bit 5
ATDDR0_BIT6:        equ    6                                         ; Bit 6
ATDDR0_BIT7:        equ    7                                         ; Bit 7
ATDDR0_BIT8:        equ    8                                         ; Bit 8
ATDDR0_BIT9:        equ    9                                         ; Bit 9
ATDDR0_BIT10:       equ    10                                        ; Bit 10
ATDDR0_BIT11:       equ    11                                        ; Bit 11
ATDDR0_BIT12:       equ    12                                        ; Bit 12
ATDDR0_BIT13:       equ    13                                        ; Bit 13
ATDDR0_BIT14:       equ    14                                        ; Bit 14
ATDDR0_BIT15:       equ    15                                        ; Bit 15
; bit position masks
mATDDR0_BIT0:       equ    %00000001
mATDDR0_BIT1:       equ    %00000010
mATDDR0_BIT2:       equ    %00000100
mATDDR0_BIT3:       equ    %00001000
mATDDR0_BIT4:       equ    %00010000
mATDDR0_BIT5:       equ    %00100000
mATDDR0_BIT6:       equ    %01000000
mATDDR0_BIT7:       equ    %10000000
mATDDR0_BIT8:       equ    %100000000
mATDDR0_BIT9:       equ    %1000000000
mATDDR0_BIT10:      equ    %10000000000
mATDDR0_BIT11:      equ    %100000000000
mATDDR0_BIT12:      equ    %1000000000000
mATDDR0_BIT13:      equ    %10000000000000
mATDDR0_BIT14:      equ    %100000000000000
mATDDR0_BIT15:      equ    %1000000000000000


;*** ATDDR0H - ATD  Conversion Result Register 0 High; 0x00000080 ***
ATDDR0H:            equ    $00000080                                ;*** ATDDR0H - ATD  Conversion Result Register 0 High; 0x00000080 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR0H_BIT8:       equ    0                                         ; Bit 8
ATDDR0H_BIT9:       equ    1                                         ; Bit 9
ATDDR0H_BIT10:      equ    2                                         ; Bit 10
ATDDR0H_BIT11:      equ    3                                         ; Bit 11
ATDDR0H_BIT12:      equ    4                                         ; Bit 12
ATDDR0H_BIT13:      equ    5                                         ; Bit 13
ATDDR0H_BIT14:      equ    6                                         ; Bit 14
ATDDR0H_BIT15:      equ    7                                         ; Bit 15
; bit position masks
mATDDR0H_BIT8:      equ    %00000001
mATDDR0H_BIT9:      equ    %00000010
mATDDR0H_BIT10:     equ    %00000100
mATDDR0H_BIT11:     equ    %00001000
mATDDR0H_BIT12:     equ    %00010000
mATDDR0H_BIT13:     equ    %00100000
mATDDR0H_BIT14:     equ    %01000000
mATDDR0H_BIT15:     equ    %10000000


;*** ATDDR0L - ATD  Conversion Result Register 0 Low; 0x00000081 ***
ATDDR0L:            equ    $00000081                                ;*** ATDDR0L - ATD  Conversion Result Register 0 Low; 0x00000081 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR0L_BIT0:       equ    0                                         ; Bit 0
ATDDR0L_BIT1:       equ    1                                         ; Bit 1
ATDDR0L_BIT2:       equ    2                                         ; Bit 2
ATDDR0L_BIT3:       equ    3                                         ; Bit 3
ATDDR0L_BIT4:       equ    4                                         ; Bit 4
ATDDR0L_BIT5:       equ    5                                         ; Bit 5
ATDDR0L_BIT6:       equ    6                                         ; Bit 6
ATDDR0L_BIT7:       equ    7                                         ; Bit 7
; bit position masks
mATDDR0L_BIT0:      equ    %00000001
mATDDR0L_BIT1:      equ    %00000010
mATDDR0L_BIT2:      equ    %00000100
mATDDR0L_BIT3:      equ    %00001000
mATDDR0L_BIT4:      equ    %00010000
mATDDR0L_BIT5:      equ    %00100000
mATDDR0L_BIT6:      equ    %01000000
mATDDR0L_BIT7:      equ    %10000000


;*** ATDDR1 - ATD  Conversion Result Register 1; 0x00000082 ***
ATDDR1:             equ    $00000082                                ;*** ATDDR1 - ATD  Conversion Result Register 1; 0x00000082 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR1_BIT0:        equ    0                                         ; Bit 0
ATDDR1_BIT1:        equ    1                                         ; Bit 1
ATDDR1_BIT2:        equ    2                                         ; Bit 2
ATDDR1_BIT3:        equ    3                                         ; Bit 3
ATDDR1_BIT4:        equ    4                                         ; Bit 4
ATDDR1_BIT5:        equ    5                                         ; Bit 5
ATDDR1_BIT6:        equ    6                                         ; Bit 6
ATDDR1_BIT7:        equ    7                                         ; Bit 7
ATDDR1_BIT8:        equ    8                                         ; Bit 8
ATDDR1_BIT9:        equ    9                                         ; Bit 9
ATDDR1_BIT10:       equ    10                                        ; Bit 10
ATDDR1_BIT11:       equ    11                                        ; Bit 11
ATDDR1_BIT12:       equ    12                                        ; Bit 12
ATDDR1_BIT13:       equ    13                                        ; Bit 13
ATDDR1_BIT14:       equ    14                                        ; Bit 14
ATDDR1_BIT15:       equ    15                                        ; Bit 15
; bit position masks
mATDDR1_BIT0:       equ    %00000001
mATDDR1_BIT1:       equ    %00000010
mATDDR1_BIT2:       equ    %00000100
mATDDR1_BIT3:       equ    %00001000
mATDDR1_BIT4:       equ    %00010000
mATDDR1_BIT5:       equ    %00100000
mATDDR1_BIT6:       equ    %01000000
mATDDR1_BIT7:       equ    %10000000
mATDDR1_BIT8:       equ    %100000000
mATDDR1_BIT9:       equ    %1000000000
mATDDR1_BIT10:      equ    %10000000000
mATDDR1_BIT11:      equ    %100000000000
mATDDR1_BIT12:      equ    %1000000000000
mATDDR1_BIT13:      equ    %10000000000000
mATDDR1_BIT14:      equ    %100000000000000
mATDDR1_BIT15:      equ    %1000000000000000


;*** ATDDR1H - ATD  Conversion Result Register 1 High; 0x00000082 ***
ATDDR1H:            equ    $00000082                                ;*** ATDDR1H - ATD  Conversion Result Register 1 High; 0x00000082 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR1H_BIT8:       equ    0                                         ; Bit 8
ATDDR1H_BIT9:       equ    1                                         ; Bit 9
ATDDR1H_BIT10:      equ    2                                         ; Bit 10
ATDDR1H_BIT11:      equ    3                                         ; Bit 11
ATDDR1H_BIT12:      equ    4                                         ; Bit 12
ATDDR1H_BIT13:      equ    5                                         ; Bit 13
ATDDR1H_BIT14:      equ    6                                         ; Bit 14
ATDDR1H_BIT15:      equ    7                                         ; Bit 15
; bit position masks
mATDDR1H_BIT8:      equ    %00000001
mATDDR1H_BIT9:      equ    %00000010
mATDDR1H_BIT10:     equ    %00000100
mATDDR1H_BIT11:     equ    %00001000
mATDDR1H_BIT12:     equ    %00010000
mATDDR1H_BIT13:     equ    %00100000
mATDDR1H_BIT14:     equ    %01000000
mATDDR1H_BIT15:     equ    %10000000


;*** ATDDR1L - ATD  Conversion Result Register 1 Low; 0x00000083 ***
ATDDR1L:            equ    $00000083                                ;*** ATDDR1L - ATD  Conversion Result Register 1 Low; 0x00000083 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR1L_BIT0:       equ    0                                         ; Bit 0
ATDDR1L_BIT1:       equ    1                                         ; Bit 1
ATDDR1L_BIT2:       equ    2                                         ; Bit 2
ATDDR1L_BIT3:       equ    3                                         ; Bit 3
ATDDR1L_BIT4:       equ    4                                         ; Bit 4
ATDDR1L_BIT5:       equ    5                                         ; Bit 5
ATDDR1L_BIT6:       equ    6                                         ; Bit 6
ATDDR1L_BIT7:       equ    7                                         ; Bit 7
; bit position masks
mATDDR1L_BIT0:      equ    %00000001
mATDDR1L_BIT1:      equ    %00000010
mATDDR1L_BIT2:      equ    %00000100
mATDDR1L_BIT3:      equ    %00001000
mATDDR1L_BIT4:      equ    %00010000
mATDDR1L_BIT5:      equ    %00100000
mATDDR1L_BIT6:      equ    %01000000
mATDDR1L_BIT7:      equ    %10000000


;*** ATDDR2 - ATD  Conversion Result Register 2; 0x00000084 ***
ATDDR2:             equ    $00000084                                ;*** ATDDR2 - ATD  Conversion Result Register 2; 0x00000084 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR2_BIT0:        equ    0                                         ; Bit 0
ATDDR2_BIT1:        equ    1                                         ; Bit 1
ATDDR2_BIT2:        equ    2                                         ; Bit 2
ATDDR2_BIT3:        equ    3                                         ; Bit 3
ATDDR2_BIT4:        equ    4                                         ; Bit 4
ATDDR2_BIT5:        equ    5                                         ; Bit 5
ATDDR2_BIT6:        equ    6                                         ; Bit 6
ATDDR2_BIT7:        equ    7                                         ; Bit 7
ATDDR2_BIT8:        equ    8                                         ; Bit 8
ATDDR2_BIT9:        equ    9                                         ; Bit 9
ATDDR2_BIT10:       equ    10                                        ; Bit 10
ATDDR2_BIT11:       equ    11                                        ; Bit 11
ATDDR2_BIT12:       equ    12                                        ; Bit 12
ATDDR2_BIT13:       equ    13                                        ; Bit 13
ATDDR2_BIT14:       equ    14                                        ; Bit 14
ATDDR2_BIT15:       equ    15                                        ; Bit 15
; bit position masks
mATDDR2_BIT0:       equ    %00000001
mATDDR2_BIT1:       equ    %00000010
mATDDR2_BIT2:       equ    %00000100
mATDDR2_BIT3:       equ    %00001000
mATDDR2_BIT4:       equ    %00010000
mATDDR2_BIT5:       equ    %00100000
mATDDR2_BIT6:       equ    %01000000
mATDDR2_BIT7:       equ    %10000000
mATDDR2_BIT8:       equ    %100000000
mATDDR2_BIT9:       equ    %1000000000
mATDDR2_BIT10:      equ    %10000000000
mATDDR2_BIT11:      equ    %100000000000
mATDDR2_BIT12:      equ    %1000000000000
mATDDR2_BIT13:      equ    %10000000000000
mATDDR2_BIT14:      equ    %100000000000000
mATDDR2_BIT15:      equ    %1000000000000000


;*** ATDDR2H - ATD  Conversion Result Register 2 High; 0x00000084 ***
ATDDR2H:            equ    $00000084                                ;*** ATDDR2H - ATD  Conversion Result Register 2 High; 0x00000084 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR2H_BIT8:       equ    0                                         ; Bit 8
ATDDR2H_BIT9:       equ    1                                         ; Bit 9
ATDDR2H_BIT10:      equ    2                                         ; Bit 10
ATDDR2H_BIT11:      equ    3                                         ; Bit 11
ATDDR2H_BIT12:      equ    4                                         ; Bit 12
ATDDR2H_BIT13:      equ    5                                         ; Bit 13
ATDDR2H_BIT14:      equ    6                                         ; Bit 14
ATDDR2H_BIT15:      equ    7                                         ; Bit 15
; bit position masks
mATDDR2H_BIT8:      equ    %00000001
mATDDR2H_BIT9:      equ    %00000010
mATDDR2H_BIT10:     equ    %00000100
mATDDR2H_BIT11:     equ    %00001000
mATDDR2H_BIT12:     equ    %00010000
mATDDR2H_BIT13:     equ    %00100000
mATDDR2H_BIT14:     equ    %01000000
mATDDR2H_BIT15:     equ    %10000000


;*** ATDDR2L - ATD  Conversion Result Register 2 Low; 0x00000085 ***
ATDDR2L:            equ    $00000085                                ;*** ATDDR2L - ATD  Conversion Result Register 2 Low; 0x00000085 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR2L_BIT0:       equ    0                                         ; Bit 0
ATDDR2L_BIT1:       equ    1                                         ; Bit 1
ATDDR2L_BIT2:       equ    2                                         ; Bit 2
ATDDR2L_BIT3:       equ    3                                         ; Bit 3
ATDDR2L_BIT4:       equ    4                                         ; Bit 4
ATDDR2L_BIT5:       equ    5                                         ; Bit 5
ATDDR2L_BIT6:       equ    6                                         ; Bit 6
ATDDR2L_BIT7:       equ    7                                         ; Bit 7
; bit position masks
mATDDR2L_BIT0:      equ    %00000001
mATDDR2L_BIT1:      equ    %00000010
mATDDR2L_BIT2:      equ    %00000100
mATDDR2L_BIT3:      equ    %00001000
mATDDR2L_BIT4:      equ    %00010000
mATDDR2L_BIT5:      equ    %00100000
mATDDR2L_BIT6:      equ    %01000000
mATDDR2L_BIT7:      equ    %10000000


;*** ATDDR3 - ATD  Conversion Result Register 3; 0x00000086 ***
ATDDR3:             equ    $00000086                                ;*** ATDDR3 - ATD  Conversion Result Register 3; 0x00000086 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR3_BIT0:        equ    0                                         ; Bit 0
ATDDR3_BIT1:        equ    1                                         ; Bit 1
ATDDR3_BIT2:        equ    2                                         ; Bit 2
ATDDR3_BIT3:        equ    3                                         ; Bit 3
ATDDR3_BIT4:        equ    4                                         ; Bit 4
ATDDR3_BIT5:        equ    5                                         ; Bit 5
ATDDR3_BIT6:        equ    6                                         ; Bit 6
ATDDR3_BIT7:        equ    7                                         ; Bit 7
ATDDR3_BIT8:        equ    8                                         ; Bit 8
ATDDR3_BIT9:        equ    9                                         ; Bit 9
ATDDR3_BIT10:       equ    10                                        ; Bit 10
ATDDR3_BIT11:       equ    11                                        ; Bit 11
ATDDR3_BIT12:       equ    12                                        ; Bit 12
ATDDR3_BIT13:       equ    13                                        ; Bit 13
ATDDR3_BIT14:       equ    14                                        ; Bit 14
ATDDR3_BIT15:       equ    15                                        ; Bit 15
; bit position masks
mATDDR3_BIT0:       equ    %00000001
mATDDR3_BIT1:       equ    %00000010
mATDDR3_BIT2:       equ    %00000100
mATDDR3_BIT3:       equ    %00001000
mATDDR3_BIT4:       equ    %00010000
mATDDR3_BIT5:       equ    %00100000
mATDDR3_BIT6:       equ    %01000000
mATDDR3_BIT7:       equ    %10000000
mATDDR3_BIT8:       equ    %100000000
mATDDR3_BIT9:       equ    %1000000000
mATDDR3_BIT10:      equ    %10000000000
mATDDR3_BIT11:      equ    %100000000000
mATDDR3_BIT12:      equ    %1000000000000
mATDDR3_BIT13:      equ    %10000000000000
mATDDR3_BIT14:      equ    %100000000000000
mATDDR3_BIT15:      equ    %1000000000000000


;*** ATDDR3H - ATD  Conversion Result Register 3 High; 0x00000086 ***
ATDDR3H:            equ    $00000086                                ;*** ATDDR3H - ATD  Conversion Result Register 3 High; 0x00000086 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR3H_BIT8:       equ    0                                         ; Bit 8
ATDDR3H_BIT9:       equ    1                                         ; Bit 9
ATDDR3H_BIT10:      equ    2                                         ; Bit 10
ATDDR3H_BIT11:      equ    3                                         ; Bit 11
ATDDR3H_BIT12:      equ    4                                         ; Bit 12
ATDDR3H_BIT13:      equ    5                                         ; Bit 13
ATDDR3H_BIT14:      equ    6                                         ; Bit 14
ATDDR3H_BIT15:      equ    7                                         ; Bit 15
; bit position masks
mATDDR3H_BIT8:      equ    %00000001
mATDDR3H_BIT9:      equ    %00000010
mATDDR3H_BIT10:     equ    %00000100
mATDDR3H_BIT11:     equ    %00001000
mATDDR3H_BIT12:     equ    %00010000
mATDDR3H_BIT13:     equ    %00100000
mATDDR3H_BIT14:     equ    %01000000
mATDDR3H_BIT15:     equ    %10000000


;*** ATDDR3L - ATD  Conversion Result Register 3 Low; 0x00000087 ***
ATDDR3L:            equ    $00000087                                ;*** ATDDR3L - ATD  Conversion Result Register 3 Low; 0x00000087 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR3L_BIT0:       equ    0                                         ; Bit 0
ATDDR3L_BIT1:       equ    1                                         ; Bit 1
ATDDR3L_BIT2:       equ    2                                         ; Bit 2
ATDDR3L_BIT3:       equ    3                                         ; Bit 3
ATDDR3L_BIT4:       equ    4                                         ; Bit 4
ATDDR3L_BIT5:       equ    5                                         ; Bit 5
ATDDR3L_BIT6:       equ    6                                         ; Bit 6
ATDDR3L_BIT7:       equ    7                                         ; Bit 7
; bit position masks
mATDDR3L_BIT0:      equ    %00000001
mATDDR3L_BIT1:      equ    %00000010
mATDDR3L_BIT2:      equ    %00000100
mATDDR3L_BIT3:      equ    %00001000
mATDDR3L_BIT4:      equ    %00010000
mATDDR3L_BIT5:      equ    %00100000
mATDDR3L_BIT6:      equ    %01000000
mATDDR3L_BIT7:      equ    %10000000


;*** ATDDR4 - ATD  Conversion Result Register 4; 0x00000088 ***
ATDDR4:             equ    $00000088                                ;*** ATDDR4 - ATD  Conversion Result Register 4; 0x00000088 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR4_BIT0:        equ    0                                         ; Bit 0
ATDDR4_BIT1:        equ    1                                         ; Bit 1
ATDDR4_BIT2:        equ    2                                         ; Bit 2
ATDDR4_BIT3:        equ    3                                         ; Bit 3
ATDDR4_BIT4:        equ    4                                         ; Bit 4
ATDDR4_BIT5:        equ    5                                         ; Bit 5
ATDDR4_BIT6:        equ    6                                         ; Bit 6
ATDDR4_BIT7:        equ    7                                         ; Bit 7
ATDDR4_BIT8:        equ    8                                         ; Bit 8
ATDDR4_BIT9:        equ    9                                         ; Bit 9
ATDDR4_BIT10:       equ    10                                        ; Bit 10
ATDDR4_BIT11:       equ    11                                        ; Bit 11
ATDDR4_BIT12:       equ    12                                        ; Bit 12
ATDDR4_BIT13:       equ    13                                        ; Bit 13
ATDDR4_BIT14:       equ    14                                        ; Bit 14
ATDDR4_BIT15:       equ    15                                        ; Bit 15
; bit position masks
mATDDR4_BIT0:       equ    %00000001
mATDDR4_BIT1:       equ    %00000010
mATDDR4_BIT2:       equ    %00000100
mATDDR4_BIT3:       equ    %00001000
mATDDR4_BIT4:       equ    %00010000
mATDDR4_BIT5:       equ    %00100000
mATDDR4_BIT6:       equ    %01000000
mATDDR4_BIT7:       equ    %10000000
mATDDR4_BIT8:       equ    %100000000
mATDDR4_BIT9:       equ    %1000000000
mATDDR4_BIT10:      equ    %10000000000
mATDDR4_BIT11:      equ    %100000000000
mATDDR4_BIT12:      equ    %1000000000000
mATDDR4_BIT13:      equ    %10000000000000
mATDDR4_BIT14:      equ    %100000000000000
mATDDR4_BIT15:      equ    %1000000000000000


;*** ATDDR4H - ATD  Conversion Result Register 4 High; 0x00000088 ***
ATDDR4H:            equ    $00000088                                ;*** ATDDR4H - ATD  Conversion Result Register 4 High; 0x00000088 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR4H_BIT8:       equ    0                                         ; Bit 8
ATDDR4H_BIT9:       equ    1                                         ; Bit 9
ATDDR4H_BIT10:      equ    2                                         ; Bit 10
ATDDR4H_BIT11:      equ    3                                         ; Bit 11
ATDDR4H_BIT12:      equ    4                                         ; Bit 12
ATDDR4H_BIT13:      equ    5                                         ; Bit 13
ATDDR4H_BIT14:      equ    6                                         ; Bit 14
ATDDR4H_BIT15:      equ    7                                         ; Bit 15
; bit position masks
mATDDR4H_BIT8:      equ    %00000001
mATDDR4H_BIT9:      equ    %00000010
mATDDR4H_BIT10:     equ    %00000100
mATDDR4H_BIT11:     equ    %00001000
mATDDR4H_BIT12:     equ    %00010000
mATDDR4H_BIT13:     equ    %00100000
mATDDR4H_BIT14:     equ    %01000000
mATDDR4H_BIT15:     equ    %10000000


;*** ATDDR4L - ATD  Conversion Result Register 4 Low; 0x00000089 ***
ATDDR4L:            equ    $00000089                                ;*** ATDDR4L - ATD  Conversion Result Register 4 Low; 0x00000089 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR4L_BIT0:       equ    0                                         ; Bit 0
ATDDR4L_BIT1:       equ    1                                         ; Bit 1
ATDDR4L_BIT2:       equ    2                                         ; Bit 2
ATDDR4L_BIT3:       equ    3                                         ; Bit 3
ATDDR4L_BIT4:       equ    4                                         ; Bit 4
ATDDR4L_BIT5:       equ    5                                         ; Bit 5
ATDDR4L_BIT6:       equ    6                                         ; Bit 6
ATDDR4L_BIT7:       equ    7                                         ; Bit 7
; bit position masks
mATDDR4L_BIT0:      equ    %00000001
mATDDR4L_BIT1:      equ    %00000010
mATDDR4L_BIT2:      equ    %00000100
mATDDR4L_BIT3:      equ    %00001000
mATDDR4L_BIT4:      equ    %00010000
mATDDR4L_BIT5:      equ    %00100000
mATDDR4L_BIT6:      equ    %01000000
mATDDR4L_BIT7:      equ    %10000000


;*** ATDDR5 - ATD  Conversion Result Register 5; 0x0000008A ***
ATDDR5:             equ    $0000008A                                ;*** ATDDR5 - ATD  Conversion Result Register 5; 0x0000008A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR5_BIT0:        equ    0                                         ; Bit 0
ATDDR5_BIT1:        equ    1                                         ; Bit 1
ATDDR5_BIT2:        equ    2                                         ; Bit 2
ATDDR5_BIT3:        equ    3                                         ; Bit 3
ATDDR5_BIT4:        equ    4                                         ; Bit 4
ATDDR5_BIT5:        equ    5                                         ; Bit 5
ATDDR5_BIT6:        equ    6                                         ; Bit 6
ATDDR5_BIT7:        equ    7                                         ; Bit 7
ATDDR5_BIT8:        equ    8                                         ; Bit 8
ATDDR5_BIT9:        equ    9                                         ; Bit 9
ATDDR5_BIT10:       equ    10                                        ; Bit 10
ATDDR5_BIT11:       equ    11                                        ; Bit 11
ATDDR5_BIT12:       equ    12                                        ; Bit 12
ATDDR5_BIT13:       equ    13                                        ; Bit 13
ATDDR5_BIT14:       equ    14                                        ; Bit 14
ATDDR5_BIT15:       equ    15                                        ; Bit 15
; bit position masks
mATDDR5_BIT0:       equ    %00000001
mATDDR5_BIT1:       equ    %00000010
mATDDR5_BIT2:       equ    %00000100
mATDDR5_BIT3:       equ    %00001000
mATDDR5_BIT4:       equ    %00010000
mATDDR5_BIT5:       equ    %00100000
mATDDR5_BIT6:       equ    %01000000
mATDDR5_BIT7:       equ    %10000000
mATDDR5_BIT8:       equ    %100000000
mATDDR5_BIT9:       equ    %1000000000
mATDDR5_BIT10:      equ    %10000000000
mATDDR5_BIT11:      equ    %100000000000
mATDDR5_BIT12:      equ    %1000000000000
mATDDR5_BIT13:      equ    %10000000000000
mATDDR5_BIT14:      equ    %100000000000000
mATDDR5_BIT15:      equ    %1000000000000000


;*** ATDDR5H - ATD  Conversion Result Register 5 High; 0x0000008A ***
ATDDR5H:            equ    $0000008A                                ;*** ATDDR5H - ATD  Conversion Result Register 5 High; 0x0000008A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR5H_BIT8:       equ    0                                         ; Bit 8
ATDDR5H_BIT9:       equ    1                                         ; Bit 9
ATDDR5H_BIT10:      equ    2                                         ; Bit 10
ATDDR5H_BIT11:      equ    3                                         ; Bit 11
ATDDR5H_BIT12:      equ    4                                         ; Bit 12
ATDDR5H_BIT13:      equ    5                                         ; Bit 13
ATDDR5H_BIT14:      equ    6                                         ; Bit 14
ATDDR5H_BIT15:      equ    7                                         ; Bit 15
; bit position masks
mATDDR5H_BIT8:      equ    %00000001
mATDDR5H_BIT9:      equ    %00000010
mATDDR5H_BIT10:     equ    %00000100
mATDDR5H_BIT11:     equ    %00001000
mATDDR5H_BIT12:     equ    %00010000
mATDDR5H_BIT13:     equ    %00100000
mATDDR5H_BIT14:     equ    %01000000
mATDDR5H_BIT15:     equ    %10000000


;*** ATDDR5L - ATD  Conversion Result Register 5 Low; 0x0000008B ***
ATDDR5L:            equ    $0000008B                                ;*** ATDDR5L - ATD  Conversion Result Register 5 Low; 0x0000008B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR5L_BIT0:       equ    0                                         ; Bit 0
ATDDR5L_BIT1:       equ    1                                         ; Bit 1
ATDDR5L_BIT2:       equ    2                                         ; Bit 2
ATDDR5L_BIT3:       equ    3                                         ; Bit 3
ATDDR5L_BIT4:       equ    4                                         ; Bit 4
ATDDR5L_BIT5:       equ    5                                         ; Bit 5
ATDDR5L_BIT6:       equ    6                                         ; Bit 6
ATDDR5L_BIT7:       equ    7                                         ; Bit 7
; bit position masks
mATDDR5L_BIT0:      equ    %00000001
mATDDR5L_BIT1:      equ    %00000010
mATDDR5L_BIT2:      equ    %00000100
mATDDR5L_BIT3:      equ    %00001000
mATDDR5L_BIT4:      equ    %00010000
mATDDR5L_BIT5:      equ    %00100000
mATDDR5L_BIT6:      equ    %01000000
mATDDR5L_BIT7:      equ    %10000000


;*** ATDDR6 - ATD  Conversion Result Register 6; 0x0000008C ***
ATDDR6:             equ    $0000008C                                ;*** ATDDR6 - ATD  Conversion Result Register 6; 0x0000008C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR6_BIT0:        equ    0                                         ; Bit 0
ATDDR6_BIT1:        equ    1                                         ; Bit 1
ATDDR6_BIT2:        equ    2                                         ; Bit 2
ATDDR6_BIT3:        equ    3                                         ; Bit 3
ATDDR6_BIT4:        equ    4                                         ; Bit 4
ATDDR6_BIT5:        equ    5                                         ; Bit 5
ATDDR6_BIT6:        equ    6                                         ; Bit 6
ATDDR6_BIT7:        equ    7                                         ; Bit 7
ATDDR6_BIT8:        equ    8                                         ; Bit 8
ATDDR6_BIT9:        equ    9                                         ; Bit 9
ATDDR6_BIT10:       equ    10                                        ; Bit 10
ATDDR6_BIT11:       equ    11                                        ; Bit 11
ATDDR6_BIT12:       equ    12                                        ; Bit 12
ATDDR6_BIT13:       equ    13                                        ; Bit 13
ATDDR6_BIT14:       equ    14                                        ; Bit 14
ATDDR6_BIT15:       equ    15                                        ; Bit 15
; bit position masks
mATDDR6_BIT0:       equ    %00000001
mATDDR6_BIT1:       equ    %00000010
mATDDR6_BIT2:       equ    %00000100
mATDDR6_BIT3:       equ    %00001000
mATDDR6_BIT4:       equ    %00010000
mATDDR6_BIT5:       equ    %00100000
mATDDR6_BIT6:       equ    %01000000
mATDDR6_BIT7:       equ    %10000000
mATDDR6_BIT8:       equ    %100000000
mATDDR6_BIT9:       equ    %1000000000
mATDDR6_BIT10:      equ    %10000000000
mATDDR6_BIT11:      equ    %100000000000
mATDDR6_BIT12:      equ    %1000000000000
mATDDR6_BIT13:      equ    %10000000000000
mATDDR6_BIT14:      equ    %100000000000000
mATDDR6_BIT15:      equ    %1000000000000000


;*** ATDDR6H - ATD  Conversion Result Register 6 High; 0x0000008C ***
ATDDR6H:            equ    $0000008C                                ;*** ATDDR6H - ATD  Conversion Result Register 6 High; 0x0000008C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR6H_BIT8:       equ    0                                         ; Bit 8
ATDDR6H_BIT9:       equ    1                                         ; Bit 9
ATDDR6H_BIT10:      equ    2                                         ; Bit 10
ATDDR6H_BIT11:      equ    3                                         ; Bit 11
ATDDR6H_BIT12:      equ    4                                         ; Bit 12
ATDDR6H_BIT13:      equ    5                                         ; Bit 13
ATDDR6H_BIT14:      equ    6                                         ; Bit 14
ATDDR6H_BIT15:      equ    7                                         ; Bit 15
; bit position masks
mATDDR6H_BIT8:      equ    %00000001
mATDDR6H_BIT9:      equ    %00000010
mATDDR6H_BIT10:     equ    %00000100
mATDDR6H_BIT11:     equ    %00001000
mATDDR6H_BIT12:     equ    %00010000
mATDDR6H_BIT13:     equ    %00100000
mATDDR6H_BIT14:     equ    %01000000
mATDDR6H_BIT15:     equ    %10000000


;*** ATDDR6L - ATD  Conversion Result Register 6 Low; 0x0000008D ***
ATDDR6L:            equ    $0000008D                                ;*** ATDDR6L - ATD  Conversion Result Register 6 Low; 0x0000008D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR6L_BIT0:       equ    0                                         ; Bit 0
ATDDR6L_BIT1:       equ    1                                         ; Bit 1
ATDDR6L_BIT2:       equ    2                                         ; Bit 2
ATDDR6L_BIT3:       equ    3                                         ; Bit 3
ATDDR6L_BIT4:       equ    4                                         ; Bit 4
ATDDR6L_BIT5:       equ    5                                         ; Bit 5
ATDDR6L_BIT6:       equ    6                                         ; Bit 6
ATDDR6L_BIT7:       equ    7                                         ; Bit 7
; bit position masks
mATDDR6L_BIT0:      equ    %00000001
mATDDR6L_BIT1:      equ    %00000010
mATDDR6L_BIT2:      equ    %00000100
mATDDR6L_BIT3:      equ    %00001000
mATDDR6L_BIT4:      equ    %00010000
mATDDR6L_BIT5:      equ    %00100000
mATDDR6L_BIT6:      equ    %01000000
mATDDR6L_BIT7:      equ    %10000000


;*** ATDDR7 - ATD  Conversion Result Register 7; 0x0000008E ***
ATDDR7:             equ    $0000008E                                ;*** ATDDR7 - ATD  Conversion Result Register 7; 0x0000008E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR7_BIT0:        equ    0                                         ; Bit 0
ATDDR7_BIT1:        equ    1                                         ; Bit 1
ATDDR7_BIT2:        equ    2                                         ; Bit 2
ATDDR7_BIT3:        equ    3                                         ; Bit 3
ATDDR7_BIT4:        equ    4                                         ; Bit 4
ATDDR7_BIT5:        equ    5                                         ; Bit 5
ATDDR7_BIT6:        equ    6                                         ; Bit 6
ATDDR7_BIT7:        equ    7                                         ; Bit 7
ATDDR7_BIT8:        equ    8                                         ; Bit 8
ATDDR7_BIT9:        equ    9                                         ; Bit 9
ATDDR7_BIT10:       equ    10                                        ; Bit 10
ATDDR7_BIT11:       equ    11                                        ; Bit 11
ATDDR7_BIT12:       equ    12                                        ; Bit 12
ATDDR7_BIT13:       equ    13                                        ; Bit 13
ATDDR7_BIT14:       equ    14                                        ; Bit 14
ATDDR7_BIT15:       equ    15                                        ; Bit 15
; bit position masks
mATDDR7_BIT0:       equ    %00000001
mATDDR7_BIT1:       equ    %00000010
mATDDR7_BIT2:       equ    %00000100
mATDDR7_BIT3:       equ    %00001000
mATDDR7_BIT4:       equ    %00010000
mATDDR7_BIT5:       equ    %00100000
mATDDR7_BIT6:       equ    %01000000
mATDDR7_BIT7:       equ    %10000000
mATDDR7_BIT8:       equ    %100000000
mATDDR7_BIT9:       equ    %1000000000
mATDDR7_BIT10:      equ    %10000000000
mATDDR7_BIT11:      equ    %100000000000
mATDDR7_BIT12:      equ    %1000000000000
mATDDR7_BIT13:      equ    %10000000000000
mATDDR7_BIT14:      equ    %100000000000000
mATDDR7_BIT15:      equ    %1000000000000000


;*** ATDDR7H - ATD  Conversion Result Register 7 High; 0x0000008E ***
ATDDR7H:            equ    $0000008E                                ;*** ATDDR7H - ATD  Conversion Result Register 7 High; 0x0000008E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR7H_BIT8:       equ    0                                         ; Bit 8
ATDDR7H_BIT9:       equ    1                                         ; Bit 9
ATDDR7H_BIT10:      equ    2                                         ; Bit 10
ATDDR7H_BIT11:      equ    3                                         ; Bit 11
ATDDR7H_BIT12:      equ    4                                         ; Bit 12
ATDDR7H_BIT13:      equ    5                                         ; Bit 13
ATDDR7H_BIT14:      equ    6                                         ; Bit 14
ATDDR7H_BIT15:      equ    7                                         ; Bit 15
; bit position masks
mATDDR7H_BIT8:      equ    %00000001
mATDDR7H_BIT9:      equ    %00000010
mATDDR7H_BIT10:     equ    %00000100
mATDDR7H_BIT11:     equ    %00001000
mATDDR7H_BIT12:     equ    %00010000
mATDDR7H_BIT13:     equ    %00100000
mATDDR7H_BIT14:     equ    %01000000
mATDDR7H_BIT15:     equ    %10000000


;*** ATDDR7L - ATD  Conversion Result Register 7 Low; 0x0000008F ***
ATDDR7L:            equ    $0000008F                                ;*** ATDDR7L - ATD  Conversion Result Register 7 Low; 0x0000008F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR7L_BIT0:       equ    0                                         ; Bit 0
ATDDR7L_BIT1:       equ    1                                         ; Bit 1
ATDDR7L_BIT2:       equ    2                                         ; Bit 2
ATDDR7L_BIT3:       equ    3                                         ; Bit 3
ATDDR7L_BIT4:       equ    4                                         ; Bit 4
ATDDR7L_BIT5:       equ    5                                         ; Bit 5
ATDDR7L_BIT6:       equ    6                                         ; Bit 6
ATDDR7L_BIT7:       equ    7                                         ; Bit 7
; bit position masks
mATDDR7L_BIT0:      equ    %00000001
mATDDR7L_BIT1:      equ    %00000010
mATDDR7L_BIT2:      equ    %00000100
mATDDR7L_BIT3:      equ    %00001000
mATDDR7L_BIT4:      equ    %00010000
mATDDR7L_BIT5:      equ    %00100000
mATDDR7L_BIT6:      equ    %01000000
mATDDR7L_BIT7:      equ    %10000000


;*** ATDDR8 - ATD  Conversion Result Register 8; 0x00000090 ***
ATDDR8:             equ    $00000090                                ;*** ATDDR8 - ATD  Conversion Result Register 8; 0x00000090 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR8_BIT0:        equ    0                                         ; Bit 0
ATDDR8_BIT1:        equ    1                                         ; Bit 1
ATDDR8_BIT2:        equ    2                                         ; Bit 2
ATDDR8_BIT3:        equ    3                                         ; Bit 3
ATDDR8_BIT4:        equ    4                                         ; Bit 4
ATDDR8_BIT5:        equ    5                                         ; Bit 5
ATDDR8_BIT6:        equ    6                                         ; Bit 6
ATDDR8_BIT7:        equ    7                                         ; Bit 7
ATDDR8_BIT8:        equ    8                                         ; Bit 8
ATDDR8_BIT9:        equ    9                                         ; Bit 9
ATDDR8_BIT10:       equ    10                                        ; Bit 10
ATDDR8_BIT11:       equ    11                                        ; Bit 11
ATDDR8_BIT12:       equ    12                                        ; Bit 12
ATDDR8_BIT13:       equ    13                                        ; Bit 13
ATDDR8_BIT14:       equ    14                                        ; Bit 14
ATDDR8_BIT15:       equ    15                                        ; Bit 15
; bit position masks
mATDDR8_BIT0:       equ    %00000001
mATDDR8_BIT1:       equ    %00000010
mATDDR8_BIT2:       equ    %00000100
mATDDR8_BIT3:       equ    %00001000
mATDDR8_BIT4:       equ    %00010000
mATDDR8_BIT5:       equ    %00100000
mATDDR8_BIT6:       equ    %01000000
mATDDR8_BIT7:       equ    %10000000
mATDDR8_BIT8:       equ    %100000000
mATDDR8_BIT9:       equ    %1000000000
mATDDR8_BIT10:      equ    %10000000000
mATDDR8_BIT11:      equ    %100000000000
mATDDR8_BIT12:      equ    %1000000000000
mATDDR8_BIT13:      equ    %10000000000000
mATDDR8_BIT14:      equ    %100000000000000
mATDDR8_BIT15:      equ    %1000000000000000


;*** ATDDR8H - ATD  Conversion Result Register 8 High; 0x00000090 ***
ATDDR8H:            equ    $00000090                                ;*** ATDDR8H - ATD  Conversion Result Register 8 High; 0x00000090 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR8H_BIT8:       equ    0                                         ; Bit 8
ATDDR8H_BIT9:       equ    1                                         ; Bit 9
ATDDR8H_BIT10:      equ    2                                         ; Bit 10
ATDDR8H_BIT11:      equ    3                                         ; Bit 11
ATDDR8H_BIT12:      equ    4                                         ; Bit 12
ATDDR8H_BIT13:      equ    5                                         ; Bit 13
ATDDR8H_BIT14:      equ    6                                         ; Bit 14
ATDDR8H_BIT15:      equ    7                                         ; Bit 15
; bit position masks
mATDDR8H_BIT8:      equ    %00000001
mATDDR8H_BIT9:      equ    %00000010
mATDDR8H_BIT10:     equ    %00000100
mATDDR8H_BIT11:     equ    %00001000
mATDDR8H_BIT12:     equ    %00010000
mATDDR8H_BIT13:     equ    %00100000
mATDDR8H_BIT14:     equ    %01000000
mATDDR8H_BIT15:     equ    %10000000


;*** ATDDR8L - ATD  Conversion Result Register 8 Low; 0x00000091 ***
ATDDR8L:            equ    $00000091                                ;*** ATDDR8L - ATD  Conversion Result Register 8 Low; 0x00000091 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR8L_BIT0:       equ    0                                         ; Bit 0
ATDDR8L_BIT1:       equ    1                                         ; Bit 1
ATDDR8L_BIT2:       equ    2                                         ; Bit 2
ATDDR8L_BIT3:       equ    3                                         ; Bit 3
ATDDR8L_BIT4:       equ    4                                         ; Bit 4
ATDDR8L_BIT5:       equ    5                                         ; Bit 5
ATDDR8L_BIT6:       equ    6                                         ; Bit 6
ATDDR8L_BIT7:       equ    7                                         ; Bit 7
; bit position masks
mATDDR8L_BIT0:      equ    %00000001
mATDDR8L_BIT1:      equ    %00000010
mATDDR8L_BIT2:      equ    %00000100
mATDDR8L_BIT3:      equ    %00001000
mATDDR8L_BIT4:      equ    %00010000
mATDDR8L_BIT5:      equ    %00100000
mATDDR8L_BIT6:      equ    %01000000
mATDDR8L_BIT7:      equ    %10000000


;*** ATDDR9 - ATD  Conversion Result Register 9; 0x00000092 ***
ATDDR9:             equ    $00000092                                ;*** ATDDR9 - ATD  Conversion Result Register 9; 0x00000092 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR9_BIT0:        equ    0                                         ; Bit 0
ATDDR9_BIT1:        equ    1                                         ; Bit 1
ATDDR9_BIT2:        equ    2                                         ; Bit 2
ATDDR9_BIT3:        equ    3                                         ; Bit 3
ATDDR9_BIT4:        equ    4                                         ; Bit 4
ATDDR9_BIT5:        equ    5                                         ; Bit 5
ATDDR9_BIT6:        equ    6                                         ; Bit 6
ATDDR9_BIT7:        equ    7                                         ; Bit 7
ATDDR9_BIT8:        equ    8                                         ; Bit 8
ATDDR9_BIT9:        equ    9                                         ; Bit 9
ATDDR9_BIT10:       equ    10                                        ; Bit 10
ATDDR9_BIT11:       equ    11                                        ; Bit 11
ATDDR9_BIT12:       equ    12                                        ; Bit 12
ATDDR9_BIT13:       equ    13                                        ; Bit 13
ATDDR9_BIT14:       equ    14                                        ; Bit 14
ATDDR9_BIT15:       equ    15                                        ; Bit 15
; bit position masks
mATDDR9_BIT0:       equ    %00000001
mATDDR9_BIT1:       equ    %00000010
mATDDR9_BIT2:       equ    %00000100
mATDDR9_BIT3:       equ    %00001000
mATDDR9_BIT4:       equ    %00010000
mATDDR9_BIT5:       equ    %00100000
mATDDR9_BIT6:       equ    %01000000
mATDDR9_BIT7:       equ    %10000000
mATDDR9_BIT8:       equ    %100000000
mATDDR9_BIT9:       equ    %1000000000
mATDDR9_BIT10:      equ    %10000000000
mATDDR9_BIT11:      equ    %100000000000
mATDDR9_BIT12:      equ    %1000000000000
mATDDR9_BIT13:      equ    %10000000000000
mATDDR9_BIT14:      equ    %100000000000000
mATDDR9_BIT15:      equ    %1000000000000000


;*** ATDDR9H - ATD  Conversion Result Register 9 High; 0x00000092 ***
ATDDR9H:            equ    $00000092                                ;*** ATDDR9H - ATD  Conversion Result Register 9 High; 0x00000092 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR9H_BIT8:       equ    0                                         ; Bit 8
ATDDR9H_BIT9:       equ    1                                         ; Bit 9
ATDDR9H_BIT10:      equ    2                                         ; Bit 10
ATDDR9H_BIT11:      equ    3                                         ; Bit 11
ATDDR9H_BIT12:      equ    4                                         ; Bit 12
ATDDR9H_BIT13:      equ    5                                         ; Bit 13
ATDDR9H_BIT14:      equ    6                                         ; Bit 14
ATDDR9H_BIT15:      equ    7                                         ; Bit 15
; bit position masks
mATDDR9H_BIT8:      equ    %00000001
mATDDR9H_BIT9:      equ    %00000010
mATDDR9H_BIT10:     equ    %00000100
mATDDR9H_BIT11:     equ    %00001000
mATDDR9H_BIT12:     equ    %00010000
mATDDR9H_BIT13:     equ    %00100000
mATDDR9H_BIT14:     equ    %01000000
mATDDR9H_BIT15:     equ    %10000000


;*** ATDDR9L - ATD  Conversion Result Register 9 Low; 0x00000093 ***
ATDDR9L:            equ    $00000093                                ;*** ATDDR9L - ATD  Conversion Result Register 9 Low; 0x00000093 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR9L_BIT0:       equ    0                                         ; Bit 0
ATDDR9L_BIT1:       equ    1                                         ; Bit 1
ATDDR9L_BIT2:       equ    2                                         ; Bit 2
ATDDR9L_BIT3:       equ    3                                         ; Bit 3
ATDDR9L_BIT4:       equ    4                                         ; Bit 4
ATDDR9L_BIT5:       equ    5                                         ; Bit 5
ATDDR9L_BIT6:       equ    6                                         ; Bit 6
ATDDR9L_BIT7:       equ    7                                         ; Bit 7
; bit position masks
mATDDR9L_BIT0:      equ    %00000001
mATDDR9L_BIT1:      equ    %00000010
mATDDR9L_BIT2:      equ    %00000100
mATDDR9L_BIT3:      equ    %00001000
mATDDR9L_BIT4:      equ    %00010000
mATDDR9L_BIT5:      equ    %00100000
mATDDR9L_BIT6:      equ    %01000000
mATDDR9L_BIT7:      equ    %10000000


;*** ATDDR10 - ATD  Conversion Result Register 10; 0x00000094 ***
ATDDR10:            equ    $00000094                                ;*** ATDDR10 - ATD  Conversion Result Register 10; 0x00000094 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR10_BIT0:       equ    0                                         ; Bit 0
ATDDR10_BIT1:       equ    1                                         ; Bit 1
ATDDR10_BIT2:       equ    2                                         ; Bit 2
ATDDR10_BIT3:       equ    3                                         ; Bit 3
ATDDR10_BIT4:       equ    4                                         ; Bit 4
ATDDR10_BIT5:       equ    5                                         ; Bit 5
ATDDR10_BIT6:       equ    6                                         ; Bit 6
ATDDR10_BIT7:       equ    7                                         ; Bit 7
ATDDR10_BIT8:       equ    8                                         ; Bit 8
ATDDR10_BIT9:       equ    9                                         ; Bit 9
ATDDR10_BIT10:      equ    10                                        ; Bit 10
ATDDR10_BIT11:      equ    11                                        ; Bit 11
ATDDR10_BIT12:      equ    12                                        ; Bit 12
ATDDR10_BIT13:      equ    13                                        ; Bit 13
ATDDR10_BIT14:      equ    14                                        ; Bit 14
ATDDR10_BIT15:      equ    15                                        ; Bit 15
; bit position masks
mATDDR10_BIT0:      equ    %00000001
mATDDR10_BIT1:      equ    %00000010
mATDDR10_BIT2:      equ    %00000100
mATDDR10_BIT3:      equ    %00001000
mATDDR10_BIT4:      equ    %00010000
mATDDR10_BIT5:      equ    %00100000
mATDDR10_BIT6:      equ    %01000000
mATDDR10_BIT7:      equ    %10000000
mATDDR10_BIT8:      equ    %100000000
mATDDR10_BIT9:      equ    %1000000000
mATDDR10_BIT10:     equ    %10000000000
mATDDR10_BIT11:     equ    %100000000000
mATDDR10_BIT12:     equ    %1000000000000
mATDDR10_BIT13:     equ    %10000000000000
mATDDR10_BIT14:     equ    %100000000000000
mATDDR10_BIT15:     equ    %1000000000000000


;*** ATDDR10H - ATD  Conversion Result Register 10 High; 0x00000094 ***
ATDDR10H:           equ    $00000094                                ;*** ATDDR10H - ATD  Conversion Result Register 10 High; 0x00000094 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR10H_BIT8:      equ    0                                         ; Bit 8
ATDDR10H_BIT9:      equ    1                                         ; Bit 9
ATDDR10H_BIT10:     equ    2                                         ; Bit 10
ATDDR10H_BIT11:     equ    3                                         ; Bit 11
ATDDR10H_BIT12:     equ    4                                         ; Bit 12
ATDDR10H_BIT13:     equ    5                                         ; Bit 13
ATDDR10H_BIT14:     equ    6                                         ; Bit 14
ATDDR10H_BIT15:     equ    7                                         ; Bit 15
; bit position masks
mATDDR10H_BIT8:     equ    %00000001
mATDDR10H_BIT9:     equ    %00000010
mATDDR10H_BIT10:    equ    %00000100
mATDDR10H_BIT11:    equ    %00001000
mATDDR10H_BIT12:    equ    %00010000
mATDDR10H_BIT13:    equ    %00100000
mATDDR10H_BIT14:    equ    %01000000
mATDDR10H_BIT15:    equ    %10000000


;*** ATDDR10L - ATD  Conversion Result Register 10 Low; 0x00000095 ***
ATDDR10L:           equ    $00000095                                ;*** ATDDR10L - ATD  Conversion Result Register 10 Low; 0x00000095 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR10L_BIT0:      equ    0                                         ; Bit 0
ATDDR10L_BIT1:      equ    1                                         ; Bit 1
ATDDR10L_BIT2:      equ    2                                         ; Bit 2
ATDDR10L_BIT3:      equ    3                                         ; Bit 3
ATDDR10L_BIT4:      equ    4                                         ; Bit 4
ATDDR10L_BIT5:      equ    5                                         ; Bit 5
ATDDR10L_BIT6:      equ    6                                         ; Bit 6
ATDDR10L_BIT7:      equ    7                                         ; Bit 7
; bit position masks
mATDDR10L_BIT0:     equ    %00000001
mATDDR10L_BIT1:     equ    %00000010
mATDDR10L_BIT2:     equ    %00000100
mATDDR10L_BIT3:     equ    %00001000
mATDDR10L_BIT4:     equ    %00010000
mATDDR10L_BIT5:     equ    %00100000
mATDDR10L_BIT6:     equ    %01000000
mATDDR10L_BIT7:     equ    %10000000


;*** ATDDR11 - ATD  Conversion Result Register 11; 0x00000096 ***
ATDDR11:            equ    $00000096                                ;*** ATDDR11 - ATD  Conversion Result Register 11; 0x00000096 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR11_BIT0:       equ    0                                         ; Bit 0
ATDDR11_BIT1:       equ    1                                         ; Bit 1
ATDDR11_BIT2:       equ    2                                         ; Bit 2
ATDDR11_BIT3:       equ    3                                         ; Bit 3
ATDDR11_BIT4:       equ    4                                         ; Bit 4
ATDDR11_BIT5:       equ    5                                         ; Bit 5
ATDDR11_BIT6:       equ    6                                         ; Bit 6
ATDDR11_BIT7:       equ    7                                         ; Bit 7
ATDDR11_BIT8:       equ    8                                         ; Bit 8
ATDDR11_BIT9:       equ    9                                         ; Bit 9
ATDDR11_BIT10:      equ    10                                        ; Bit 10
ATDDR11_BIT11:      equ    11                                        ; Bit 11
ATDDR11_BIT12:      equ    12                                        ; Bit 12
ATDDR11_BIT13:      equ    13                                        ; Bit 13
ATDDR11_BIT14:      equ    14                                        ; Bit 14
ATDDR11_BIT15:      equ    15                                        ; Bit 15
; bit position masks
mATDDR11_BIT0:      equ    %00000001
mATDDR11_BIT1:      equ    %00000010
mATDDR11_BIT2:      equ    %00000100
mATDDR11_BIT3:      equ    %00001000
mATDDR11_BIT4:      equ    %00010000
mATDDR11_BIT5:      equ    %00100000
mATDDR11_BIT6:      equ    %01000000
mATDDR11_BIT7:      equ    %10000000
mATDDR11_BIT8:      equ    %100000000
mATDDR11_BIT9:      equ    %1000000000
mATDDR11_BIT10:     equ    %10000000000
mATDDR11_BIT11:     equ    %100000000000
mATDDR11_BIT12:     equ    %1000000000000
mATDDR11_BIT13:     equ    %10000000000000
mATDDR11_BIT14:     equ    %100000000000000
mATDDR11_BIT15:     equ    %1000000000000000


;*** ATDDR11H - ATD  Conversion Result Register 11 High; 0x00000096 ***
ATDDR11H:           equ    $00000096                                ;*** ATDDR11H - ATD  Conversion Result Register 11 High; 0x00000096 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR11H_BIT8:      equ    0                                         ; Bit 8
ATDDR11H_BIT9:      equ    1                                         ; Bit 9
ATDDR11H_BIT10:     equ    2                                         ; Bit 10
ATDDR11H_BIT11:     equ    3                                         ; Bit 11
ATDDR11H_BIT12:     equ    4                                         ; Bit 12
ATDDR11H_BIT13:     equ    5                                         ; Bit 13
ATDDR11H_BIT14:     equ    6                                         ; Bit 14
ATDDR11H_BIT15:     equ    7                                         ; Bit 15
; bit position masks
mATDDR11H_BIT8:     equ    %00000001
mATDDR11H_BIT9:     equ    %00000010
mATDDR11H_BIT10:    equ    %00000100
mATDDR11H_BIT11:    equ    %00001000
mATDDR11H_BIT12:    equ    %00010000
mATDDR11H_BIT13:    equ    %00100000
mATDDR11H_BIT14:    equ    %01000000
mATDDR11H_BIT15:    equ    %10000000


;*** ATDDR11L - ATD  Conversion Result Register 11 Low; 0x00000097 ***
ATDDR11L:           equ    $00000097                                ;*** ATDDR11L - ATD  Conversion Result Register 11 Low; 0x00000097 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR11L_BIT0:      equ    0                                         ; Bit 0
ATDDR11L_BIT1:      equ    1                                         ; Bit 1
ATDDR11L_BIT2:      equ    2                                         ; Bit 2
ATDDR11L_BIT3:      equ    3                                         ; Bit 3
ATDDR11L_BIT4:      equ    4                                         ; Bit 4
ATDDR11L_BIT5:      equ    5                                         ; Bit 5
ATDDR11L_BIT6:      equ    6                                         ; Bit 6
ATDDR11L_BIT7:      equ    7                                         ; Bit 7
; bit position masks
mATDDR11L_BIT0:     equ    %00000001
mATDDR11L_BIT1:     equ    %00000010
mATDDR11L_BIT2:     equ    %00000100
mATDDR11L_BIT3:     equ    %00001000
mATDDR11L_BIT4:     equ    %00010000
mATDDR11L_BIT5:     equ    %00100000
mATDDR11L_BIT6:     equ    %01000000
mATDDR11L_BIT7:     equ    %10000000


;*** ATDDR12 - ATD  Conversion Result Register 12; 0x00000098 ***
ATDDR12:            equ    $00000098                                ;*** ATDDR12 - ATD  Conversion Result Register 12; 0x00000098 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR12_BIT0:       equ    0                                         ; Bit 0
ATDDR12_BIT1:       equ    1                                         ; Bit 1
ATDDR12_BIT2:       equ    2                                         ; Bit 2
ATDDR12_BIT3:       equ    3                                         ; Bit 3
ATDDR12_BIT4:       equ    4                                         ; Bit 4
ATDDR12_BIT5:       equ    5                                         ; Bit 5
ATDDR12_BIT6:       equ    6                                         ; Bit 6
ATDDR12_BIT7:       equ    7                                         ; Bit 7
ATDDR12_BIT8:       equ    8                                         ; Bit 8
ATDDR12_BIT9:       equ    9                                         ; Bit 9
ATDDR12_BIT10:      equ    10                                        ; Bit 10
ATDDR12_BIT11:      equ    11                                        ; Bit 11
ATDDR12_BIT12:      equ    12                                        ; Bit 12
ATDDR12_BIT13:      equ    13                                        ; Bit 13
ATDDR12_BIT14:      equ    14                                        ; Bit 14
ATDDR12_BIT15:      equ    15                                        ; Bit 15
; bit position masks
mATDDR12_BIT0:      equ    %00000001
mATDDR12_BIT1:      equ    %00000010
mATDDR12_BIT2:      equ    %00000100
mATDDR12_BIT3:      equ    %00001000
mATDDR12_BIT4:      equ    %00010000
mATDDR12_BIT5:      equ    %00100000
mATDDR12_BIT6:      equ    %01000000
mATDDR12_BIT7:      equ    %10000000
mATDDR12_BIT8:      equ    %100000000
mATDDR12_BIT9:      equ    %1000000000
mATDDR12_BIT10:     equ    %10000000000
mATDDR12_BIT11:     equ    %100000000000
mATDDR12_BIT12:     equ    %1000000000000
mATDDR12_BIT13:     equ    %10000000000000
mATDDR12_BIT14:     equ    %100000000000000
mATDDR12_BIT15:     equ    %1000000000000000


;*** ATDDR12H - ATD  Conversion Result Register 12 High; 0x00000098 ***
ATDDR12H:           equ    $00000098                                ;*** ATDDR12H - ATD  Conversion Result Register 12 High; 0x00000098 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR12H_BIT8:      equ    0                                         ; Bit 8
ATDDR12H_BIT9:      equ    1                                         ; Bit 9
ATDDR12H_BIT10:     equ    2                                         ; Bit 10
ATDDR12H_BIT11:     equ    3                                         ; Bit 11
ATDDR12H_BIT12:     equ    4                                         ; Bit 12
ATDDR12H_BIT13:     equ    5                                         ; Bit 13
ATDDR12H_BIT14:     equ    6                                         ; Bit 14
ATDDR12H_BIT15:     equ    7                                         ; Bit 15
; bit position masks
mATDDR12H_BIT8:     equ    %00000001
mATDDR12H_BIT9:     equ    %00000010
mATDDR12H_BIT10:    equ    %00000100
mATDDR12H_BIT11:    equ    %00001000
mATDDR12H_BIT12:    equ    %00010000
mATDDR12H_BIT13:    equ    %00100000
mATDDR12H_BIT14:    equ    %01000000
mATDDR12H_BIT15:    equ    %10000000


;*** ATDDR12L - ATD  Conversion Result Register 12 Low; 0x00000099 ***
ATDDR12L:           equ    $00000099                                ;*** ATDDR12L - ATD  Conversion Result Register 12 Low; 0x00000099 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR12L_BIT0:      equ    0                                         ; Bit 0
ATDDR12L_BIT1:      equ    1                                         ; Bit 1
ATDDR12L_BIT2:      equ    2                                         ; Bit 2
ATDDR12L_BIT3:      equ    3                                         ; Bit 3
ATDDR12L_BIT4:      equ    4                                         ; Bit 4
ATDDR12L_BIT5:      equ    5                                         ; Bit 5
ATDDR12L_BIT6:      equ    6                                         ; Bit 6
ATDDR12L_BIT7:      equ    7                                         ; Bit 7
; bit position masks
mATDDR12L_BIT0:     equ    %00000001
mATDDR12L_BIT1:     equ    %00000010
mATDDR12L_BIT2:     equ    %00000100
mATDDR12L_BIT3:     equ    %00001000
mATDDR12L_BIT4:     equ    %00010000
mATDDR12L_BIT5:     equ    %00100000
mATDDR12L_BIT6:     equ    %01000000
mATDDR12L_BIT7:     equ    %10000000


;*** ATDDR13 - ATD  Conversion Result Register 13; 0x0000009A ***
ATDDR13:            equ    $0000009A                                ;*** ATDDR13 - ATD  Conversion Result Register 13; 0x0000009A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR13_BIT0:       equ    0                                         ; Bit 0
ATDDR13_BIT1:       equ    1                                         ; Bit 1
ATDDR13_BIT2:       equ    2                                         ; Bit 2
ATDDR13_BIT3:       equ    3                                         ; Bit 3
ATDDR13_BIT4:       equ    4                                         ; Bit 4
ATDDR13_BIT5:       equ    5                                         ; Bit 5
ATDDR13_BIT6:       equ    6                                         ; Bit 6
ATDDR13_BIT7:       equ    7                                         ; Bit 7
ATDDR13_BIT8:       equ    8                                         ; Bit 8
ATDDR13_BIT9:       equ    9                                         ; Bit 9
ATDDR13_BIT10:      equ    10                                        ; Bit 10
ATDDR13_BIT11:      equ    11                                        ; Bit 11
ATDDR13_BIT12:      equ    12                                        ; Bit 12
ATDDR13_BIT13:      equ    13                                        ; Bit 13
ATDDR13_BIT14:      equ    14                                        ; Bit 14
ATDDR13_BIT15:      equ    15                                        ; Bit 15
; bit position masks
mATDDR13_BIT0:      equ    %00000001
mATDDR13_BIT1:      equ    %00000010
mATDDR13_BIT2:      equ    %00000100
mATDDR13_BIT3:      equ    %00001000
mATDDR13_BIT4:      equ    %00010000
mATDDR13_BIT5:      equ    %00100000
mATDDR13_BIT6:      equ    %01000000
mATDDR13_BIT7:      equ    %10000000
mATDDR13_BIT8:      equ    %100000000
mATDDR13_BIT9:      equ    %1000000000
mATDDR13_BIT10:     equ    %10000000000
mATDDR13_BIT11:     equ    %100000000000
mATDDR13_BIT12:     equ    %1000000000000
mATDDR13_BIT13:     equ    %10000000000000
mATDDR13_BIT14:     equ    %100000000000000
mATDDR13_BIT15:     equ    %1000000000000000


;*** ATDDR13H - ATD  Conversion Result Register 13 High; 0x0000009A ***
ATDDR13H:           equ    $0000009A                                ;*** ATDDR13H - ATD  Conversion Result Register 13 High; 0x0000009A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR13H_BIT8:      equ    0                                         ; Bit 8
ATDDR13H_BIT9:      equ    1                                         ; Bit 9
ATDDR13H_BIT10:     equ    2                                         ; Bit 10
ATDDR13H_BIT11:     equ    3                                         ; Bit 11
ATDDR13H_BIT12:     equ    4                                         ; Bit 12
ATDDR13H_BIT13:     equ    5                                         ; Bit 13
ATDDR13H_BIT14:     equ    6                                         ; Bit 14
ATDDR13H_BIT15:     equ    7                                         ; Bit 15
; bit position masks
mATDDR13H_BIT8:     equ    %00000001
mATDDR13H_BIT9:     equ    %00000010
mATDDR13H_BIT10:    equ    %00000100
mATDDR13H_BIT11:    equ    %00001000
mATDDR13H_BIT12:    equ    %00010000
mATDDR13H_BIT13:    equ    %00100000
mATDDR13H_BIT14:    equ    %01000000
mATDDR13H_BIT15:    equ    %10000000


;*** ATDDR13L - ATD  Conversion Result Register 13 Low; 0x0000009B ***
ATDDR13L:           equ    $0000009B                                ;*** ATDDR13L - ATD  Conversion Result Register 13 Low; 0x0000009B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR13L_BIT0:      equ    0                                         ; Bit 0
ATDDR13L_BIT1:      equ    1                                         ; Bit 1
ATDDR13L_BIT2:      equ    2                                         ; Bit 2
ATDDR13L_BIT3:      equ    3                                         ; Bit 3
ATDDR13L_BIT4:      equ    4                                         ; Bit 4
ATDDR13L_BIT5:      equ    5                                         ; Bit 5
ATDDR13L_BIT6:      equ    6                                         ; Bit 6
ATDDR13L_BIT7:      equ    7                                         ; Bit 7
; bit position masks
mATDDR13L_BIT0:     equ    %00000001
mATDDR13L_BIT1:     equ    %00000010
mATDDR13L_BIT2:     equ    %00000100
mATDDR13L_BIT3:     equ    %00001000
mATDDR13L_BIT4:     equ    %00010000
mATDDR13L_BIT5:     equ    %00100000
mATDDR13L_BIT6:     equ    %01000000
mATDDR13L_BIT7:     equ    %10000000


;*** ATDDR14 - ATD  Conversion Result Register 14; 0x0000009C ***
ATDDR14:            equ    $0000009C                                ;*** ATDDR14 - ATD  Conversion Result Register 14; 0x0000009C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR14_BIT0:       equ    0                                         ; Bit 0
ATDDR14_BIT1:       equ    1                                         ; Bit 1
ATDDR14_BIT2:       equ    2                                         ; Bit 2
ATDDR14_BIT3:       equ    3                                         ; Bit 3
ATDDR14_BIT4:       equ    4                                         ; Bit 4
ATDDR14_BIT5:       equ    5                                         ; Bit 5
ATDDR14_BIT6:       equ    6                                         ; Bit 6
ATDDR14_BIT7:       equ    7                                         ; Bit 7
ATDDR14_BIT8:       equ    8                                         ; Bit 8
ATDDR14_BIT9:       equ    9                                         ; Bit 9
ATDDR14_BIT10:      equ    10                                        ; Bit 10
ATDDR14_BIT11:      equ    11                                        ; Bit 11
ATDDR14_BIT12:      equ    12                                        ; Bit 12
ATDDR14_BIT13:      equ    13                                        ; Bit 13
ATDDR14_BIT14:      equ    14                                        ; Bit 14
ATDDR14_BIT15:      equ    15                                        ; Bit 15
; bit position masks
mATDDR14_BIT0:      equ    %00000001
mATDDR14_BIT1:      equ    %00000010
mATDDR14_BIT2:      equ    %00000100
mATDDR14_BIT3:      equ    %00001000
mATDDR14_BIT4:      equ    %00010000
mATDDR14_BIT5:      equ    %00100000
mATDDR14_BIT6:      equ    %01000000
mATDDR14_BIT7:      equ    %10000000
mATDDR14_BIT8:      equ    %100000000
mATDDR14_BIT9:      equ    %1000000000
mATDDR14_BIT10:     equ    %10000000000
mATDDR14_BIT11:     equ    %100000000000
mATDDR14_BIT12:     equ    %1000000000000
mATDDR14_BIT13:     equ    %10000000000000
mATDDR14_BIT14:     equ    %100000000000000
mATDDR14_BIT15:     equ    %1000000000000000


;*** ATDDR14H - ATD  Conversion Result Register 14 High; 0x0000009C ***
ATDDR14H:           equ    $0000009C                                ;*** ATDDR14H - ATD  Conversion Result Register 14 High; 0x0000009C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR14H_BIT8:      equ    0                                         ; Bit 8
ATDDR14H_BIT9:      equ    1                                         ; Bit 9
ATDDR14H_BIT10:     equ    2                                         ; Bit 10
ATDDR14H_BIT11:     equ    3                                         ; Bit 11
ATDDR14H_BIT12:     equ    4                                         ; Bit 12
ATDDR14H_BIT13:     equ    5                                         ; Bit 13
ATDDR14H_BIT14:     equ    6                                         ; Bit 14
ATDDR14H_BIT15:     equ    7                                         ; Bit 15
; bit position masks
mATDDR14H_BIT8:     equ    %00000001
mATDDR14H_BIT9:     equ    %00000010
mATDDR14H_BIT10:    equ    %00000100
mATDDR14H_BIT11:    equ    %00001000
mATDDR14H_BIT12:    equ    %00010000
mATDDR14H_BIT13:    equ    %00100000
mATDDR14H_BIT14:    equ    %01000000
mATDDR14H_BIT15:    equ    %10000000


;*** ATDDR14L - ATD  Conversion Result Register 14 Low; 0x0000009D ***
ATDDR14L:           equ    $0000009D                                ;*** ATDDR14L - ATD  Conversion Result Register 14 Low; 0x0000009D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR14L_BIT0:      equ    0                                         ; Bit 0
ATDDR14L_BIT1:      equ    1                                         ; Bit 1
ATDDR14L_BIT2:      equ    2                                         ; Bit 2
ATDDR14L_BIT3:      equ    3                                         ; Bit 3
ATDDR14L_BIT4:      equ    4                                         ; Bit 4
ATDDR14L_BIT5:      equ    5                                         ; Bit 5
ATDDR14L_BIT6:      equ    6                                         ; Bit 6
ATDDR14L_BIT7:      equ    7                                         ; Bit 7
; bit position masks
mATDDR14L_BIT0:     equ    %00000001
mATDDR14L_BIT1:     equ    %00000010
mATDDR14L_BIT2:     equ    %00000100
mATDDR14L_BIT3:     equ    %00001000
mATDDR14L_BIT4:     equ    %00010000
mATDDR14L_BIT5:     equ    %00100000
mATDDR14L_BIT6:     equ    %01000000
mATDDR14L_BIT7:     equ    %10000000


;*** ATDDR15 - ATD  Conversion Result Register 15; 0x0000009E ***
ATDDR15:            equ    $0000009E                                ;*** ATDDR15 - ATD  Conversion Result Register 15; 0x0000009E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR15_BIT0:       equ    0                                         ; Bit 0
ATDDR15_BIT1:       equ    1                                         ; Bit 1
ATDDR15_BIT2:       equ    2                                         ; Bit 2
ATDDR15_BIT3:       equ    3                                         ; Bit 3
ATDDR15_BIT4:       equ    4                                         ; Bit 4
ATDDR15_BIT5:       equ    5                                         ; Bit 5
ATDDR15_BIT6:       equ    6                                         ; Bit 6
ATDDR15_BIT7:       equ    7                                         ; Bit 7
ATDDR15_BIT8:       equ    8                                         ; Bit 8
ATDDR15_BIT9:       equ    9                                         ; Bit 9
ATDDR15_BIT10:      equ    10                                        ; Bit 10
ATDDR15_BIT11:      equ    11                                        ; Bit 11
ATDDR15_BIT12:      equ    12                                        ; Bit 12
ATDDR15_BIT13:      equ    13                                        ; Bit 13
ATDDR15_BIT14:      equ    14                                        ; Bit 14
ATDDR15_BIT15:      equ    15                                        ; Bit 15
; bit position masks
mATDDR15_BIT0:      equ    %00000001
mATDDR15_BIT1:      equ    %00000010
mATDDR15_BIT2:      equ    %00000100
mATDDR15_BIT3:      equ    %00001000
mATDDR15_BIT4:      equ    %00010000
mATDDR15_BIT5:      equ    %00100000
mATDDR15_BIT6:      equ    %01000000
mATDDR15_BIT7:      equ    %10000000
mATDDR15_BIT8:      equ    %100000000
mATDDR15_BIT9:      equ    %1000000000
mATDDR15_BIT10:     equ    %10000000000
mATDDR15_BIT11:     equ    %100000000000
mATDDR15_BIT12:     equ    %1000000000000
mATDDR15_BIT13:     equ    %10000000000000
mATDDR15_BIT14:     equ    %100000000000000
mATDDR15_BIT15:     equ    %1000000000000000


;*** ATDDR15H - ATD  Conversion Result Register 15 High; 0x0000009E ***
ATDDR15H:           equ    $0000009E                                ;*** ATDDR15H - ATD  Conversion Result Register 15 High; 0x0000009E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR15H_BIT8:      equ    0                                         ; Bit 8
ATDDR15H_BIT9:      equ    1                                         ; Bit 9
ATDDR15H_BIT10:     equ    2                                         ; Bit 10
ATDDR15H_BIT11:     equ    3                                         ; Bit 11
ATDDR15H_BIT12:     equ    4                                         ; Bit 12
ATDDR15H_BIT13:     equ    5                                         ; Bit 13
ATDDR15H_BIT14:     equ    6                                         ; Bit 14
ATDDR15H_BIT15:     equ    7                                         ; Bit 15
; bit position masks
mATDDR15H_BIT8:     equ    %00000001
mATDDR15H_BIT9:     equ    %00000010
mATDDR15H_BIT10:    equ    %00000100
mATDDR15H_BIT11:    equ    %00001000
mATDDR15H_BIT12:    equ    %00010000
mATDDR15H_BIT13:    equ    %00100000
mATDDR15H_BIT14:    equ    %01000000
mATDDR15H_BIT15:    equ    %10000000


;*** ATDDR15L - ATD  Conversion Result Register 15 Low; 0x0000009F ***
ATDDR15L:           equ    $0000009F                                ;*** ATDDR15L - ATD  Conversion Result Register 15 Low; 0x0000009F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR15L_BIT0:      equ    0                                         ; Bit 0
ATDDR15L_BIT1:      equ    1                                         ; Bit 1
ATDDR15L_BIT2:      equ    2                                         ; Bit 2
ATDDR15L_BIT3:      equ    3                                         ; Bit 3
ATDDR15L_BIT4:      equ    4                                         ; Bit 4
ATDDR15L_BIT5:      equ    5                                         ; Bit 5
ATDDR15L_BIT6:      equ    6                                         ; Bit 6
ATDDR15L_BIT7:      equ    7                                         ; Bit 7
; bit position masks
mATDDR15L_BIT0:     equ    %00000001
mATDDR15L_BIT1:     equ    %00000010
mATDDR15L_BIT2:     equ    %00000100
mATDDR15L_BIT3:     equ    %00001000
mATDDR15L_BIT4:     equ    %00010000
mATDDR15L_BIT5:     equ    %00100000
mATDDR15L_BIT6:     equ    %01000000
mATDDR15L_BIT7:     equ    %10000000


;*** PWME - PWM Enable Register; 0x000000A0 ***
PWME:               equ    $000000A0                                ;*** PWME - PWM Enable Register; 0x000000A0 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PWME_PWME0:         equ    0                                         ; Pulse Width Channel 0 Enable
PWME_PWME1:         equ    1                                         ; Pulse Width Channel 1 Enable
PWME_PWME2:         equ    2                                         ; Pulse Width Channel 2 Enable
PWME_PWME3:         equ    3                                         ; Pulse Width Channel 3 Enable
PWME_PWME4:         equ    4                                         ; Pulse Width Channel 4 Enable
PWME_PWME5:         equ    5                                         ; Pulse Width Channel 5 Enable
PWME_PWME6:         equ    6                                         ; Pulse Width Channel 6 Enable
PWME_PWME7:         equ    7                                         ; Pulse Width Channel 7 Enable
; bit position masks
mPWME_PWME0:        equ    %00000001
mPWME_PWME1:        equ    %00000010
mPWME_PWME2:        equ    %00000100
mPWME_PWME3:        equ    %00001000
mPWME_PWME4:        equ    %00010000
mPWME_PWME5:        equ    %00100000
mPWME_PWME6:        equ    %01000000
mPWME_PWME7:        equ    %10000000


;*** PWMPOL - PWM Polarity Register; 0x000000A1 ***
PWMPOL:             equ    $000000A1                                ;*** PWMPOL - PWM Polarity Register; 0x000000A1 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PWMPOL_PPOL0:       equ    0                                         ; Pulse Width Channel 0 Polarity
PWMPOL_PPOL1:       equ    1                                         ; Pulse Width Channel 1 Polarity
PWMPOL_PPOL2:       equ    2                                         ; Pulse Width Channel 2 Polarity
PWMPOL_PPOL3:       equ    3                                         ; Pulse Width Channel 3 Polarity
PWMPOL_PPOL4:       equ    4                                         ; Pulse Width Channel 4 Polarity
PWMPOL_PPOL5:       equ    5                                         ; Pulse Width Channel 5 Polarity
PWMPOL_PPOL6:       equ    6                                         ; Pulse Width Channel 6 Polarity
PWMPOL_PPOL7:       equ    7                                         ; Pulse Width Channel 7 Polarity
; bit position masks
mPWMPOL_PPOL0:      equ    %00000001
mPWMPOL_PPOL1:      equ    %00000010
mPWMPOL_PPOL2:      equ    %00000100
mPWMPOL_PPOL3:      equ    %00001000
mPWMPOL_PPOL4:      equ    %00010000
mPWMPOL_PPOL5:      equ    %00100000
mPWMPOL_PPOL6:      equ    %01000000
mPWMPOL_PPOL7:      equ    %10000000


;*** PWMCLK - PWM Clock Select Register; 0x000000A2 ***
PWMCLK:             equ    $000000A2                                ;*** PWMCLK - PWM Clock Select Register; 0x000000A2 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PWMCLK_PCLK0:       equ    0                                         ; Pulse Width Channel 0 Clock Select
PWMCLK_PCLK1:       equ    1                                         ; Pulse Width Channel 1 Clock Select
PWMCLK_PCLK2:       equ    2                                         ; Pulse Width Channel 2 Clock Select
PWMCLK_PCLK3:       equ    3                                         ; Pulse Width Channel 3 Clock Select
PWMCLK_PCLK4:       equ    4                                         ; Pulse Width Channel 4 Clock Select
PWMCLK_PCLK5:       equ    5                                         ; Pulse Width Channel 5 Clock Select
PWMCLK_PCLK6:       equ    6                                         ; Pulse Width Channel 6 Clock Select
PWMCLK_PCLK7:       equ    7                                         ; Pulse Width Channel 7 Clock Select
; bit position masks
mPWMCLK_PCLK0:      equ    %00000001
mPWMCLK_PCLK1:      equ    %00000010
mPWMCLK_PCLK2:      equ    %00000100
mPWMCLK_PCLK3:      equ    %00001000
mPWMCLK_PCLK4:      equ    %00010000
mPWMCLK_PCLK5:      equ    %00100000
mPWMCLK_PCLK6:      equ    %01000000
mPWMCLK_PCLK7:      equ    %10000000


;*** PWMPRCLK - PWM Prescale Clock Select Register; 0x000000A3 ***
PWMPRCLK:           equ    $000000A3                                ;*** PWMPRCLK - PWM Prescale Clock Select Register; 0x000000A3 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PWMPRCLK_PCKA0:     equ    0                                         ; Prescaler Select for Clock A 0
PWMPRCLK_PCKA1:     equ    1                                         ; Prescaler Select for Clock A 1
PWMPRCLK_PCKA2:     equ    2                                         ; Prescaler Select for Clock A 2
PWMPRCLK_PCKB0:     equ    4                                         ; Prescaler Select for Clock B 0
PWMPRCLK_PCKB1:     equ    5                                         ; Prescaler Select for Clock B 1
PWMPRCLK_PCKB2:     equ    6                                         ; Prescaler Select for Clock B 2
; bit position masks
mPWMPRCLK_PCKA0:    equ    %00000001
mPWMPRCLK_PCKA1:    equ    %00000010
mPWMPRCLK_PCKA2:    equ    %00000100
mPWMPRCLK_PCKB0:    equ    %00010000
mPWMPRCLK_PCKB1:    equ    %00100000
mPWMPRCLK_PCKB2:    equ    %01000000


;*** PWMCAE - PWM Center Align Enable Register; 0x000000A4 ***
PWMCAE:             equ    $000000A4                                ;*** PWMCAE - PWM Center Align Enable Register; 0x000000A4 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PWMCAE_CAE0:        equ    0                                         ; Center Aligned Output Mode on channel 0
PWMCAE_CAE1:        equ    1                                         ; Center Aligned Output Mode on channel 1
PWMCAE_CAE2:        equ    2                                         ; Center Aligned Output Mode on channel 2
PWMCAE_CAE3:        equ    3                                         ; Center Aligned Output Mode on channel 3
PWMCAE_CAE4:        equ    4                                         ; Center Aligned Output Mode on channel 4
PWMCAE_CAE5:        equ    5                                         ; Center Aligned Output Mode on channel 5
PWMCAE_CAE6:        equ    6                                         ; Center Aligned Output Mode on channel 6
PWMCAE_CAE7:        equ    7                                         ; Center Aligned Output Mode on channel 7
; bit position masks
mPWMCAE_CAE0:       equ    %00000001
mPWMCAE_CAE1:       equ    %00000010
mPWMCAE_CAE2:       equ    %00000100
mPWMCAE_CAE3:       equ    %00001000
mPWMCAE_CAE4:       equ    %00010000
mPWMCAE_CAE5:       equ    %00100000
mPWMCAE_CAE6:       equ    %01000000
mPWMCAE_CAE7:       equ    %10000000


;*** PWMCTL - PWM Control Register; 0x000000A5 ***
PWMCTL:             equ    $000000A5                                ;*** PWMCTL - PWM Control Register; 0x000000A5 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PWMCTL_PFRZ:        equ    2                                         ; PWM Counters Stop in Freeze Mode
PWMCTL_PSWAI:       equ    3                                         ; PWM Stops in Wait Mode
PWMCTL_CON01:       equ    4                                         ; Concatenate channels 0 and 1
PWMCTL_CON23:       equ    5                                         ; Concatenate channels 2 and 3
PWMCTL_CON45:       equ    6                                         ; Concatenate channels 4 and 5
PWMCTL_CON67:       equ    7                                         ; Concatenate channels 6 and 7
; bit position masks
mPWMCTL_PFRZ:       equ    %00000100
mPWMCTL_PSWAI:      equ    %00001000
mPWMCTL_CON01:      equ    %00010000
mPWMCTL_CON23:      equ    %00100000
mPWMCTL_CON45:      equ    %01000000
mPWMCTL_CON67:      equ    %10000000


;*** PWMCLKAB - PWM Clock Select Register; 0x000000A6 ***
PWMCLKAB:           equ    $000000A6                                ;*** PWMCLKAB - PWM Clock Select Register; 0x000000A6 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PWMCLKAB_PCLKAB0:   equ    0                                         ; Pulse Width Channel 0 Clock A/B Select
PWMCLKAB_PCLKAB1:   equ    1                                         ; Pulse Width Channel 1 Clock A/B Select
PWMCLKAB_PCLKAB2:   equ    2                                         ; Pulse Width Channel 2 Clock A/B Select
PWMCLKAB_PCLKAB3:   equ    3                                         ; Pulse Width Channel 3 Clock A/B Select
PWMCLKAB_PCLKAB4:   equ    4                                         ; Pulse Width Channel 4 Clock A/B Select
PWMCLKAB_PCLKAB5:   equ    5                                         ; Pulse Width Channel 5 Clock A/B Select
PWMCLKAB_PCLKAB6:   equ    6                                         ; Pulse Width Channel 6 Clock A/B Select
PWMCLKAB_PCLKAB7:   equ    7                                         ; Pulse Width Channel 7 Clock A/B Select
; bit position masks
mPWMCLKAB_PCLKAB0:  equ    %00000001
mPWMCLKAB_PCLKAB1:  equ    %00000010
mPWMCLKAB_PCLKAB2:  equ    %00000100
mPWMCLKAB_PCLKAB3:  equ    %00001000
mPWMCLKAB_PCLKAB4:  equ    %00010000
mPWMCLKAB_PCLKAB5:  equ    %00100000
mPWMCLKAB_PCLKAB6:  equ    %01000000
mPWMCLKAB_PCLKAB7:  equ    %10000000


;*** PWMSCLA - PWM Scale A Register; 0x000000A8 ***
PWMSCLA:            equ    $000000A8                                ;*** PWMSCLA - PWM Scale A Register; 0x000000A8 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PWMSCLA_BIT0:       equ    0                                         ; PWM Scale A Bit 0
PWMSCLA_BIT1:       equ    1                                         ; PWM Scale A Bit 1
PWMSCLA_BIT2:       equ    2                                         ; PWM Scale A Bit 2
PWMSCLA_BIT3:       equ    3                                         ; PWM Scale A Bit 3
PWMSCLA_BIT4:       equ    4                                         ; PWM Scale A Bit 4
PWMSCLA_BIT5:       equ    5                                         ; PWM Scale A Bit 5
PWMSCLA_BIT6:       equ    6                                         ; PWM Scale A Bit 6
PWMSCLA_BIT7:       equ    7                                         ; PWM Scale A Bit 7
; bit position masks
mPWMSCLA_BIT0:      equ    %00000001
mPWMSCLA_BIT1:      equ    %00000010
mPWMSCLA_BIT2:      equ    %00000100
mPWMSCLA_BIT3:      equ    %00001000
mPWMSCLA_BIT4:      equ    %00010000
mPWMSCLA_BIT5:      equ    %00100000
mPWMSCLA_BIT6:      equ    %01000000
mPWMSCLA_BIT7:      equ    %10000000


;*** PWMSCLB - PWM Scale B Register; 0x000000A9 ***
PWMSCLB:            equ    $000000A9                                ;*** PWMSCLB - PWM Scale B Register; 0x000000A9 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PWMSCLB_BIT0:       equ    0                                         ; PWM Scale B Bit 0
PWMSCLB_BIT1:       equ    1                                         ; PWM Scale B Bit 1
PWMSCLB_BIT2:       equ    2                                         ; PWM Scale B Bit 2
PWMSCLB_BIT3:       equ    3                                         ; PWM Scale B Bit 3
PWMSCLB_BIT4:       equ    4                                         ; PWM Scale B Bit 4
PWMSCLB_BIT5:       equ    5                                         ; PWM Scale B Bit 5
PWMSCLB_BIT6:       equ    6                                         ; PWM Scale B Bit 6
PWMSCLB_BIT7:       equ    7                                         ; PWM Scale B Bit 7
; bit position masks
mPWMSCLB_BIT0:      equ    %00000001
mPWMSCLB_BIT1:      equ    %00000010
mPWMSCLB_BIT2:      equ    %00000100
mPWMSCLB_BIT3:      equ    %00001000
mPWMSCLB_BIT4:      equ    %00010000
mPWMSCLB_BIT5:      equ    %00100000
mPWMSCLB_BIT6:      equ    %01000000
mPWMSCLB_BIT7:      equ    %10000000


;*** PWMCNT01 - PWM Channel Counter 01 Register; 0x000000AC ***
PWMCNT01:           equ    $000000AC                                ;*** PWMCNT01 - PWM Channel Counter 01 Register; 0x000000AC ***


;*** PWMCNT0 - PWM Channel Counter 0 Register; 0x000000AC ***
PWMCNT0:            equ    $000000AC                                ;*** PWMCNT0 - PWM Channel Counter 0 Register; 0x000000AC ***


;*** PWMCNT1 - PWM Channel Counter 1 Register; 0x000000AD ***
PWMCNT1:            equ    $000000AD                                ;*** PWMCNT1 - PWM Channel Counter 1 Register; 0x000000AD ***


;*** PWMCNT23 - PWM Channel Counter 23 Register; 0x000000AE ***
PWMCNT23:           equ    $000000AE                                ;*** PWMCNT23 - PWM Channel Counter 23 Register; 0x000000AE ***


;*** PWMCNT2 - PWM Channel Counter 2 Register; 0x000000AE ***
PWMCNT2:            equ    $000000AE                                ;*** PWMCNT2 - PWM Channel Counter 2 Register; 0x000000AE ***


;*** PWMCNT3 - PWM Channel Counter 3 Register; 0x000000AF ***
PWMCNT3:            equ    $000000AF                                ;*** PWMCNT3 - PWM Channel Counter 3 Register; 0x000000AF ***


;*** PWMCNT45 - PWM Channel Counter 45 Register; 0x000000B0 ***
PWMCNT45:           equ    $000000B0                                ;*** PWMCNT45 - PWM Channel Counter 45 Register; 0x000000B0 ***


;*** PWMCNT4 - PWM Channel Counter 4 Register; 0x000000B0 ***
PWMCNT4:            equ    $000000B0                                ;*** PWMCNT4 - PWM Channel Counter 4 Register; 0x000000B0 ***


;*** PWMCNT5 - PWM Channel Counter 5 Register; 0x000000B1 ***
PWMCNT5:            equ    $000000B1                                ;*** PWMCNT5 - PWM Channel Counter 5 Register; 0x000000B1 ***


;*** PWMCNT67 - PWM Channel Counter 67 Register; 0x000000B2 ***
PWMCNT67:           equ    $000000B2                                ;*** PWMCNT67 - PWM Channel Counter 67 Register; 0x000000B2 ***


;*** PWMCNT6 - PWM Channel Counter 6 Register; 0x000000B2 ***
PWMCNT6:            equ    $000000B2                                ;*** PWMCNT6 - PWM Channel Counter 6 Register; 0x000000B2 ***


;*** PWMCNT7 - PWM Channel Counter 7 Register; 0x000000B3 ***
PWMCNT7:            equ    $000000B3                                ;*** PWMCNT7 - PWM Channel Counter 7 Register; 0x000000B3 ***


;*** PWMPER01 - PWM Channel Period 01 Register; 0x000000B4 ***
PWMPER01:           equ    $000000B4                                ;*** PWMPER01 - PWM Channel Period 01 Register; 0x000000B4 ***


;*** PWMPER0 - PWM Channel Period 0 Register; 0x000000B4 ***
PWMPER0:            equ    $000000B4                                ;*** PWMPER0 - PWM Channel Period 0 Register; 0x000000B4 ***


;*** PWMPER1 - PWM Channel Period 1 Register; 0x000000B5 ***
PWMPER1:            equ    $000000B5                                ;*** PWMPER1 - PWM Channel Period 1 Register; 0x000000B5 ***


;*** PWMPER23 - PWM Channel Period 23 Register; 0x000000B6 ***
PWMPER23:           equ    $000000B6                                ;*** PWMPER23 - PWM Channel Period 23 Register; 0x000000B6 ***


;*** PWMPER2 - PWM Channel Period 2 Register; 0x000000B6 ***
PWMPER2:            equ    $000000B6                                ;*** PWMPER2 - PWM Channel Period 2 Register; 0x000000B6 ***


;*** PWMPER3 - PWM Channel Period 3 Register; 0x000000B7 ***
PWMPER3:            equ    $000000B7                                ;*** PWMPER3 - PWM Channel Period 3 Register; 0x000000B7 ***


;*** PWMPER45 - PWM Channel Period 45 Register; 0x000000B8 ***
PWMPER45:           equ    $000000B8                                ;*** PWMPER45 - PWM Channel Period 45 Register; 0x000000B8 ***


;*** PWMPER4 - PWM Channel Period 4 Register; 0x000000B8 ***
PWMPER4:            equ    $000000B8                                ;*** PWMPER4 - PWM Channel Period 4 Register; 0x000000B8 ***


;*** PWMPER5 - PWM Channel Period 5 Register; 0x000000B9 ***
PWMPER5:            equ    $000000B9                                ;*** PWMPER5 - PWM Channel Period 5 Register; 0x000000B9 ***


;*** PWMPER67 - PWM Channel Period 67 Register; 0x000000BA ***
PWMPER67:           equ    $000000BA                                ;*** PWMPER67 - PWM Channel Period 67 Register; 0x000000BA ***


;*** PWMPER6 - PWM Channel Period 6 Register; 0x000000BA ***
PWMPER6:            equ    $000000BA                                ;*** PWMPER6 - PWM Channel Period 6 Register; 0x000000BA ***


;*** PWMPER7 - PWM Channel Period 7 Register; 0x000000BB ***
PWMPER7:            equ    $000000BB                                ;*** PWMPER7 - PWM Channel Period 7 Register; 0x000000BB ***


;*** PWMDTY01 - PWM Channel Duty 01 Register; 0x000000BC ***
PWMDTY01:           equ    $000000BC                                ;*** PWMDTY01 - PWM Channel Duty 01 Register; 0x000000BC ***


;*** PWMDTY0 - PWM Channel Duty 0 Register; 0x000000BC ***
PWMDTY0:            equ    $000000BC                                ;*** PWMDTY0 - PWM Channel Duty 0 Register; 0x000000BC ***


;*** PWMDTY1 - PWM Channel Duty 1 Register; 0x000000BD ***
PWMDTY1:            equ    $000000BD                                ;*** PWMDTY1 - PWM Channel Duty 1 Register; 0x000000BD ***


;*** PWMDTY23 - PWM Channel Duty 23 Register; 0x000000BE ***
PWMDTY23:           equ    $000000BE                                ;*** PWMDTY23 - PWM Channel Duty 23 Register; 0x000000BE ***


;*** PWMDTY2 - PWM Channel Duty 2 Register; 0x000000BE ***
PWMDTY2:            equ    $000000BE                                ;*** PWMDTY2 - PWM Channel Duty 2 Register; 0x000000BE ***


;*** PWMDTY3 - PWM Channel Duty 3 Register; 0x000000BF ***
PWMDTY3:            equ    $000000BF                                ;*** PWMDTY3 - PWM Channel Duty 3 Register; 0x000000BF ***


;*** PWMDTY45 - PWM Channel Duty 45 Register; 0x000000C0 ***
PWMDTY45:           equ    $000000C0                                ;*** PWMDTY45 - PWM Channel Duty 45 Register; 0x000000C0 ***


;*** PWMDTY4 - PWM Channel Duty 4 Register; 0x000000C0 ***
PWMDTY4:            equ    $000000C0                                ;*** PWMDTY4 - PWM Channel Duty 4 Register; 0x000000C0 ***


;*** PWMDTY5 - PWM Channel Duty 5 Register; 0x000000C1 ***
PWMDTY5:            equ    $000000C1                                ;*** PWMDTY5 - PWM Channel Duty 5 Register; 0x000000C1 ***


;*** PWMDTY67 - PWM Channel Duty 67 Register; 0x000000C2 ***
PWMDTY67:           equ    $000000C2                                ;*** PWMDTY67 - PWM Channel Duty 67 Register; 0x000000C2 ***


;*** PWMDTY6 - PWM Channel Duty 6 Register; 0x000000C2 ***
PWMDTY6:            equ    $000000C2                                ;*** PWMDTY6 - PWM Channel Duty 6 Register; 0x000000C2 ***


;*** PWMDTY7 - PWM Channel Duty 7 Register; 0x000000C3 ***
PWMDTY7:            equ    $000000C3                                ;*** PWMDTY7 - PWM Channel Duty 7 Register; 0x000000C3 ***


;*** SCI0BD - SCI 0 Baud Rate Register; 0x000000C8 ***
SCI0BD:             equ    $000000C8                                ;*** SCI0BD - SCI 0 Baud Rate Register; 0x000000C8 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI0BD_SBR0:        equ    0                                         ; SCI Baud Rate Bit 0
SCI0BD_SBR1:        equ    1                                         ; SCI Baud Rate Bit 1
SCI0BD_SBR2:        equ    2                                         ; SCI Baud Rate Bit 2
SCI0BD_SBR3:        equ    3                                         ; SCI Baud Rate Bit 3
SCI0BD_SBR4:        equ    4                                         ; SCI Baud Rate Bit 4
SCI0BD_SBR5:        equ    5                                         ; SCI Baud Rate Bit 5
SCI0BD_SBR6:        equ    6                                         ; SCI Baud Rate Bit 6
SCI0BD_SBR7:        equ    7                                         ; SCI Baud Rate Bit 7
SCI0BD_SBR8:        equ    8                                         ; SCI Baud Rate Bit 8
SCI0BD_SBR9:        equ    9                                         ; SCI Baud Rate Bit 9
SCI0BD_SBR10:       equ    10                                        ; SCI Baud Rate Bit 10
SCI0BD_SBR11:       equ    11                                        ; SCI Baud Rate Bit 11
SCI0BD_SBR12:       equ    12                                        ; SCI Baud Rate Bit 12
SCI0BD_TNP0:        equ    13                                        ; Transmitter Narrow Pulse Bit 0
SCI0BD_TNP1:        equ    14                                        ; Transmitter Narrow Pulse Bit 1
SCI0BD_IREN:        equ    15                                        ; Infrared Enable Bit
; bit position masks
mSCI0BD_SBR0:       equ    %00000001
mSCI0BD_SBR1:       equ    %00000010
mSCI0BD_SBR2:       equ    %00000100
mSCI0BD_SBR3:       equ    %00001000
mSCI0BD_SBR4:       equ    %00010000
mSCI0BD_SBR5:       equ    %00100000
mSCI0BD_SBR6:       equ    %01000000
mSCI0BD_SBR7:       equ    %10000000
mSCI0BD_SBR8:       equ    %100000000
mSCI0BD_SBR9:       equ    %1000000000
mSCI0BD_SBR10:      equ    %10000000000
mSCI0BD_SBR11:      equ    %100000000000
mSCI0BD_SBR12:      equ    %1000000000000
mSCI0BD_TNP0:       equ    %10000000000000
mSCI0BD_TNP1:       equ    %100000000000000
mSCI0BD_IREN:       equ    %1000000000000000


;*** SCI0ASR1 - SCI 0 Alternative Status Register 1; 0x000000C8 ***
SCI0ASR1:           equ    $000000C8                                ;*** SCI0ASR1 - SCI 0 Alternative Status Register 1; 0x000000C8 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI0ASR1_BKDIF:     equ    0                                         ; Break Detect Interrupt Flag
SCI0ASR1_BERRIF:    equ    1                                         ; Bit Error Interrupt Flag
SCI0ASR1_BERRV:     equ    2                                         ; Bit Error Value
SCI0ASR1_RXEDGIF:   equ    7                                         ; Receive Input Active Edge Interrupt Flag
; bit position masks
mSCI0ASR1_BKDIF:    equ    %00000001
mSCI0ASR1_BERRIF:   equ    %00000010
mSCI0ASR1_BERRV:    equ    %00000100
mSCI0ASR1_RXEDGIF:  equ    %10000000


;*** SCI0BDH - SCI 0 Baud Rate Register High; 0x000000C8 ***
SCI0BDH:            equ    $000000C8                                ;*** SCI0BDH - SCI 0 Baud Rate Register High; 0x000000C8 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI0BDH_SBR8:       equ    0                                         ; SCI Baud Rate Bit 8
SCI0BDH_SBR9:       equ    1                                         ; SCI Baud Rate Bit 9
SCI0BDH_SBR10:      equ    2                                         ; SCI Baud Rate Bit 10
SCI0BDH_SBR11:      equ    3                                         ; SCI Baud Rate Bit 11
SCI0BDH_SBR12:      equ    4                                         ; SCI Baud Rate Bit 12
SCI0BDH_TNP0:       equ    5                                         ; Transmitter Narrow Pulse Bit 0
SCI0BDH_TNP1:       equ    6                                         ; Transmitter Narrow Pulse Bit 1
SCI0BDH_IREN:       equ    7                                         ; Infrared Enable Bit
; bit position masks
mSCI0BDH_SBR8:      equ    %00000001
mSCI0BDH_SBR9:      equ    %00000010
mSCI0BDH_SBR10:     equ    %00000100
mSCI0BDH_SBR11:     equ    %00001000
mSCI0BDH_SBR12:     equ    %00010000
mSCI0BDH_TNP0:      equ    %00100000
mSCI0BDH_TNP1:      equ    %01000000
mSCI0BDH_IREN:      equ    %10000000


;*** SCI0ACR1 - SCI 0 Alternative Control Register 1; 0x000000C9 ***
SCI0ACR1:           equ    $000000C9                                ;*** SCI0ACR1 - SCI 0 Alternative Control Register 1; 0x000000C9 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI0ACR1_BKDIE:     equ    0                                         ; Break Detect Interrupt Enable
SCI0ACR1_BERRIE:    equ    1                                         ; Bit Error Interrupt Enable
SCI0ACR1_RXEDGIE:   equ    7                                         ; Receive Input Active Edge Interrupt Enable
; bit position masks
mSCI0ACR1_BKDIE:    equ    %00000001
mSCI0ACR1_BERRIE:   equ    %00000010
mSCI0ACR1_RXEDGIE:  equ    %10000000


;*** SCI0BDL - SCI 0 Baud Rate Register Low; 0x000000C9 ***
SCI0BDL:            equ    $000000C9                                ;*** SCI0BDL - SCI 0 Baud Rate Register Low; 0x000000C9 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI0BDL_SBR0:       equ    0                                         ; SCI Baud Rate Bit 0
SCI0BDL_SBR1:       equ    1                                         ; SCI Baud Rate Bit 1
SCI0BDL_SBR2:       equ    2                                         ; SCI Baud Rate Bit 2
SCI0BDL_SBR3:       equ    3                                         ; SCI Baud Rate Bit 3
SCI0BDL_SBR4:       equ    4                                         ; SCI Baud Rate Bit 4
SCI0BDL_SBR5:       equ    5                                         ; SCI Baud Rate Bit 5
SCI0BDL_SBR6:       equ    6                                         ; SCI Baud Rate Bit 6
SCI0BDL_SBR7:       equ    7                                         ; SCI Baud Rate Bit 7
; bit position masks
mSCI0BDL_SBR0:      equ    %00000001
mSCI0BDL_SBR1:      equ    %00000010
mSCI0BDL_SBR2:      equ    %00000100
mSCI0BDL_SBR3:      equ    %00001000
mSCI0BDL_SBR4:      equ    %00010000
mSCI0BDL_SBR5:      equ    %00100000
mSCI0BDL_SBR6:      equ    %01000000
mSCI0BDL_SBR7:      equ    %10000000


;*** SCI0ACR2 - SCI 0 Alternative Control Register 2; 0x000000CA ***
SCI0ACR2:           equ    $000000CA                                ;*** SCI0ACR2 - SCI 0 Alternative Control Register 2; 0x000000CA ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI0ACR2_BKDFE:     equ    0                                         ; Break Detect Feature Enable
SCI0ACR2_BERRM0:    equ    1                                         ; Bit Error Mode 0
SCI0ACR2_BERRM1:    equ    2                                         ; Bit Error Mode 1
; bit position masks
mSCI0ACR2_BKDFE:    equ    %00000001
mSCI0ACR2_BERRM0:   equ    %00000010
mSCI0ACR2_BERRM1:   equ    %00000100


;*** SCI0CR1 - SCI 0 Control Register 1; 0x000000CA ***
SCI0CR1:            equ    $000000CA                                ;*** SCI0CR1 - SCI 0 Control Register 1; 0x000000CA ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI0CR1_PT:         equ    0                                         ; Parity Type Bit
SCI0CR1_PE:         equ    1                                         ; Parity Enable Bit
SCI0CR1_ILT:        equ    2                                         ; Idle Line Type Bit
SCI0CR1_WAKE:       equ    3                                         ; Wakeup Condition Bit
SCI0CR1_M:          equ    4                                         ; Data Format Mode Bit
SCI0CR1_RSRC:       equ    5                                         ; Receiver Source Bit
SCI0CR1_SCISWAI:    equ    6                                         ; SCI Stop in Wait Mode Bit
SCI0CR1_LOOPS:      equ    7                                         ; Loop Select Bit
; bit position masks
mSCI0CR1_PT:        equ    %00000001
mSCI0CR1_PE:        equ    %00000010
mSCI0CR1_ILT:       equ    %00000100
mSCI0CR1_WAKE:      equ    %00001000
mSCI0CR1_M:         equ    %00010000
mSCI0CR1_RSRC:      equ    %00100000
mSCI0CR1_SCISWAI:   equ    %01000000
mSCI0CR1_LOOPS:     equ    %10000000


;*** SCI0CR2 - SCI 0 Control Register 2; 0x000000CB ***
SCI0CR2:            equ    $000000CB                                ;*** SCI0CR2 - SCI 0 Control Register 2; 0x000000CB ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI0CR2_SBK:        equ    0                                         ; Send Break Bit
SCI0CR2_RWU:        equ    1                                         ; Receiver Wakeup Bit
SCI0CR2_RE:         equ    2                                         ; Receiver Enable Bit
SCI0CR2_TE:         equ    3                                         ; Transmitter Enable Bit
SCI0CR2_ILIE:       equ    4                                         ; Idle Line Interrupt Enable Bit
SCI0CR2_RIE:        equ    5                                         ; Receiver Full Interrupt Enable Bit
SCI0CR2_TCIE:       equ    6                                         ; Transmission Complete Interrupt Enable Bit
SCI0CR2_TIE:        equ    7                                         ; Transmitter Interrupt Enable Bit
; bit position masks
mSCI0CR2_SBK:       equ    %00000001
mSCI0CR2_RWU:       equ    %00000010
mSCI0CR2_RE:        equ    %00000100
mSCI0CR2_TE:        equ    %00001000
mSCI0CR2_ILIE:      equ    %00010000
mSCI0CR2_RIE:       equ    %00100000
mSCI0CR2_TCIE:      equ    %01000000
mSCI0CR2_TIE:       equ    %10000000


;*** SCI0SR1 - SCI 0 Status Register 1; 0x000000CC ***
SCI0SR1:            equ    $000000CC                                ;*** SCI0SR1 - SCI 0 Status Register 1; 0x000000CC ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI0SR1_PF:         equ    0                                         ; Parity Error Flag
SCI0SR1_FE:         equ    1                                         ; Framing Error Flag
SCI0SR1_NF:         equ    2                                         ; Noise Flag
SCI0SR1_OR:         equ    3                                         ; Overrun Flag
SCI0SR1_IDLE:       equ    4                                         ; Idle Line Flag
SCI0SR1_RDRF:       equ    5                                         ; Receive Data Register Full Flag
SCI0SR1_TC:         equ    6                                         ; Transmit Complete Flag
SCI0SR1_TDRE:       equ    7                                         ; Transmit Data Register Empty Flag
; bit position masks
mSCI0SR1_PF:        equ    %00000001
mSCI0SR1_FE:        equ    %00000010
mSCI0SR1_NF:        equ    %00000100
mSCI0SR1_OR:        equ    %00001000
mSCI0SR1_IDLE:      equ    %00010000
mSCI0SR1_RDRF:      equ    %00100000
mSCI0SR1_TC:        equ    %01000000
mSCI0SR1_TDRE:      equ    %10000000


;*** SCI0SR2 - SCI 0 Status Register 2; 0x000000CD ***
SCI0SR2:            equ    $000000CD                                ;*** SCI0SR2 - SCI 0 Status Register 2; 0x000000CD ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI0SR2_RAF:        equ    0                                         ; Receiver Active Flag
SCI0SR2_TXDIR:      equ    1                                         ; Transmitter pin data direction in Single-Wire mode
SCI0SR2_BRK13:      equ    2                                         ; Break Transmit character length
SCI0SR2_RXPOL:      equ    3                                         ; Receive Polarity
SCI0SR2_TXPOL:      equ    4                                         ; Transmit Polarity
SCI0SR2_AMAP:       equ    7                                         ; Alternative Map
; bit position masks
mSCI0SR2_RAF:       equ    %00000001
mSCI0SR2_TXDIR:     equ    %00000010
mSCI0SR2_BRK13:     equ    %00000100
mSCI0SR2_RXPOL:     equ    %00001000
mSCI0SR2_TXPOL:     equ    %00010000
mSCI0SR2_AMAP:      equ    %10000000


;*** SCI0DRH - SCI 0 Data Register High; 0x000000CE ***
SCI0DRH:            equ    $000000CE                                ;*** SCI0DRH - SCI 0 Data Register High; 0x000000CE ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI0DRH_T8:         equ    6                                         ; Transmit Bit 8
SCI0DRH_R8:         equ    7                                         ; Received Bit 8
; bit position masks
mSCI0DRH_T8:        equ    %01000000
mSCI0DRH_R8:        equ    %10000000


;*** SCI0DRL - SCI 0 Data Register Low; 0x000000CF ***
SCI0DRL:            equ    $000000CF                                ;*** SCI0DRL - SCI 0 Data Register Low; 0x000000CF ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI0DRL_R0_T0:      equ    0                                         ; Received bit 0 or Transmit bit 0
SCI0DRL_R1_T1:      equ    1                                         ; Received bit 1 or Transmit bit 1
SCI0DRL_R2_T2:      equ    2                                         ; Received bit 2 or Transmit bit 2
SCI0DRL_R3_T3:      equ    3                                         ; Received bit 3 or Transmit bit 3
SCI0DRL_R4_T4:      equ    4                                         ; Received bit 4 or Transmit bit 4
SCI0DRL_R5_T5:      equ    5                                         ; Received bit 5 or Transmit bit 5
SCI0DRL_R6_T6:      equ    6                                         ; Received bit 6 or Transmit bit 6
SCI0DRL_R7_T7:      equ    7                                         ; Received bit 7 or Transmit bit 7
; bit position masks
mSCI0DRL_R0_T0:     equ    %00000001
mSCI0DRL_R1_T1:     equ    %00000010
mSCI0DRL_R2_T2:     equ    %00000100
mSCI0DRL_R3_T3:     equ    %00001000
mSCI0DRL_R4_T4:     equ    %00010000
mSCI0DRL_R5_T5:     equ    %00100000
mSCI0DRL_R6_T6:     equ    %01000000
mSCI0DRL_R7_T7:     equ    %10000000


;*** SCI1BD - SCI 1 Baud Rate Register; 0x000000D0 ***
SCI1BD:             equ    $000000D0                                ;*** SCI1BD - SCI 1 Baud Rate Register; 0x000000D0 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI1BD_SBR0:        equ    0                                         ; SCI Baud Rate Bit 0
SCI1BD_SBR1:        equ    1                                         ; SCI Baud Rate Bit 1
SCI1BD_SBR2:        equ    2                                         ; SCI Baud Rate Bit 2
SCI1BD_SBR3:        equ    3                                         ; SCI Baud Rate Bit 3
SCI1BD_SBR4:        equ    4                                         ; SCI Baud Rate Bit 4
SCI1BD_SBR5:        equ    5                                         ; SCI Baud Rate Bit 5
SCI1BD_SBR6:        equ    6                                         ; SCI Baud Rate Bit 6
SCI1BD_SBR7:        equ    7                                         ; SCI Baud Rate Bit 7
SCI1BD_SBR8:        equ    8                                         ; SCI Baud Rate Bit 8
SCI1BD_SBR9:        equ    9                                         ; SCI Baud Rate Bit 9
SCI1BD_SBR10:       equ    10                                        ; SCI Baud Rate Bit 10
SCI1BD_SBR11:       equ    11                                        ; SCI Baud Rate Bit 11
SCI1BD_SBR12:       equ    12                                        ; SCI Baud Rate Bit 12
SCI1BD_TNP0:        equ    13                                        ; Transmitter Narrow Pulse Bit 0
SCI1BD_TNP1:        equ    14                                        ; Transmitter Narrow Pulse Bit 1
SCI1BD_IREN:        equ    15                                        ; Infrared Enable Bit
; bit position masks
mSCI1BD_SBR0:       equ    %00000001
mSCI1BD_SBR1:       equ    %00000010
mSCI1BD_SBR2:       equ    %00000100
mSCI1BD_SBR3:       equ    %00001000
mSCI1BD_SBR4:       equ    %00010000
mSCI1BD_SBR5:       equ    %00100000
mSCI1BD_SBR6:       equ    %01000000
mSCI1BD_SBR7:       equ    %10000000
mSCI1BD_SBR8:       equ    %100000000
mSCI1BD_SBR9:       equ    %1000000000
mSCI1BD_SBR10:      equ    %10000000000
mSCI1BD_SBR11:      equ    %100000000000
mSCI1BD_SBR12:      equ    %1000000000000
mSCI1BD_TNP0:       equ    %10000000000000
mSCI1BD_TNP1:       equ    %100000000000000
mSCI1BD_IREN:       equ    %1000000000000000


;*** SCI1ASR1 - SCI 1 Alternative Status Register 1; 0x000000D0 ***
SCI1ASR1:           equ    $000000D0                                ;*** SCI1ASR1 - SCI 1 Alternative Status Register 1; 0x000000D0 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI1ASR1_BKDIF:     equ    0                                         ; Break Detect Interrupt Flag
SCI1ASR1_BERRIF:    equ    1                                         ; Bit Error Interrupt Flag
SCI1ASR1_BERRV:     equ    2                                         ; Bit Error Value
SCI1ASR1_RXEDGIF:   equ    7                                         ; Receive Input Active Edge Interrupt Flag
; bit position masks
mSCI1ASR1_BKDIF:    equ    %00000001
mSCI1ASR1_BERRIF:   equ    %00000010
mSCI1ASR1_BERRV:    equ    %00000100
mSCI1ASR1_RXEDGIF:  equ    %10000000


;*** SCI1BDH - SCI 1 Baud Rate Register High; 0x000000D0 ***
SCI1BDH:            equ    $000000D0                                ;*** SCI1BDH - SCI 1 Baud Rate Register High; 0x000000D0 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI1BDH_SBR8:       equ    0                                         ; SCI Baud Rate Bit 8
SCI1BDH_SBR9:       equ    1                                         ; SCI Baud Rate Bit 9
SCI1BDH_SBR10:      equ    2                                         ; SCI Baud Rate Bit 10
SCI1BDH_SBR11:      equ    3                                         ; SCI Baud Rate Bit 11
SCI1BDH_SBR12:      equ    4                                         ; SCI Baud Rate Bit 12
SCI1BDH_TNP0:       equ    5                                         ; Transmitter Narrow Pulse Bit 0
SCI1BDH_TNP1:       equ    6                                         ; Transmitter Narrow Pulse Bit 1
SCI1BDH_IREN:       equ    7                                         ; Infrared Enable Bit
; bit position masks
mSCI1BDH_SBR8:      equ    %00000001
mSCI1BDH_SBR9:      equ    %00000010
mSCI1BDH_SBR10:     equ    %00000100
mSCI1BDH_SBR11:     equ    %00001000
mSCI1BDH_SBR12:     equ    %00010000
mSCI1BDH_TNP0:      equ    %00100000
mSCI1BDH_TNP1:      equ    %01000000
mSCI1BDH_IREN:      equ    %10000000


;*** SCI1ACR1 - SCI 1 Alternative Control Register 1; 0x000000D1 ***
SCI1ACR1:           equ    $000000D1                                ;*** SCI1ACR1 - SCI 1 Alternative Control Register 1; 0x000000D1 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI1ACR1_BKDIE:     equ    0                                         ; Break Detect Interrupt Enable
SCI1ACR1_BERRIE:    equ    1                                         ; Bit Error Interrupt Enable
SCI1ACR1_RXEDGIE:   equ    7                                         ; Receive Input Active Edge Interrupt Enable
; bit position masks
mSCI1ACR1_BKDIE:    equ    %00000001
mSCI1ACR1_BERRIE:   equ    %00000010
mSCI1ACR1_RXEDGIE:  equ    %10000000


;*** SCI1BDL - SCI 1 Baud Rate Register Low; 0x000000D1 ***
SCI1BDL:            equ    $000000D1                                ;*** SCI1BDL - SCI 1 Baud Rate Register Low; 0x000000D1 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI1BDL_SBR0:       equ    0                                         ; SCI Baud Rate Bit 0
SCI1BDL_SBR1:       equ    1                                         ; SCI Baud Rate Bit 1
SCI1BDL_SBR2:       equ    2                                         ; SCI Baud Rate Bit 2
SCI1BDL_SBR3:       equ    3                                         ; SCI Baud Rate Bit 3
SCI1BDL_SBR4:       equ    4                                         ; SCI Baud Rate Bit 4
SCI1BDL_SBR5:       equ    5                                         ; SCI Baud Rate Bit 5
SCI1BDL_SBR6:       equ    6                                         ; SCI Baud Rate Bit 6
SCI1BDL_SBR7:       equ    7                                         ; SCI Baud Rate Bit 7
; bit position masks
mSCI1BDL_SBR0:      equ    %00000001
mSCI1BDL_SBR1:      equ    %00000010
mSCI1BDL_SBR2:      equ    %00000100
mSCI1BDL_SBR3:      equ    %00001000
mSCI1BDL_SBR4:      equ    %00010000
mSCI1BDL_SBR5:      equ    %00100000
mSCI1BDL_SBR6:      equ    %01000000
mSCI1BDL_SBR7:      equ    %10000000


;*** SCI1ACR2 - SCI 1 Alternative Control Register 2; 0x000000D2 ***
SCI1ACR2:           equ    $000000D2                                ;*** SCI1ACR2 - SCI 1 Alternative Control Register 2; 0x000000D2 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI1ACR2_BKDFE:     equ    0                                         ; Break Detect Feature Enable
SCI1ACR2_BERRM0:    equ    1                                         ; Bit Error Mode 0
SCI1ACR2_BERRM1:    equ    2                                         ; Bit Error Mode 1
; bit position masks
mSCI1ACR2_BKDFE:    equ    %00000001
mSCI1ACR2_BERRM0:   equ    %00000010
mSCI1ACR2_BERRM1:   equ    %00000100


;*** SCI1CR1 - SCI 1 Control Register 1; 0x000000D2 ***
SCI1CR1:            equ    $000000D2                                ;*** SCI1CR1 - SCI 1 Control Register 1; 0x000000D2 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI1CR1_PT:         equ    0                                         ; Parity Type Bit
SCI1CR1_PE:         equ    1                                         ; Parity Enable Bit
SCI1CR1_ILT:        equ    2                                         ; Idle Line Type Bit
SCI1CR1_WAKE:       equ    3                                         ; Wakeup Condition Bit
SCI1CR1_M:          equ    4                                         ; Data Format Mode Bit
SCI1CR1_RSRC:       equ    5                                         ; Receiver Source Bit
SCI1CR1_SCISWAI:    equ    6                                         ; SCI Stop in Wait Mode Bit
SCI1CR1_LOOPS:      equ    7                                         ; Loop Select Bit
; bit position masks
mSCI1CR1_PT:        equ    %00000001
mSCI1CR1_PE:        equ    %00000010
mSCI1CR1_ILT:       equ    %00000100
mSCI1CR1_WAKE:      equ    %00001000
mSCI1CR1_M:         equ    %00010000
mSCI1CR1_RSRC:      equ    %00100000
mSCI1CR1_SCISWAI:   equ    %01000000
mSCI1CR1_LOOPS:     equ    %10000000


;*** SCI1CR2 - SCI 1 Control Register 2; 0x000000D3 ***
SCI1CR2:            equ    $000000D3                                ;*** SCI1CR2 - SCI 1 Control Register 2; 0x000000D3 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI1CR2_SBK:        equ    0                                         ; Send Break Bit
SCI1CR2_RWU:        equ    1                                         ; Receiver Wakeup Bit
SCI1CR2_RE:         equ    2                                         ; Receiver Enable Bit
SCI1CR2_TE:         equ    3                                         ; Transmitter Enable Bit
SCI1CR2_ILIE:       equ    4                                         ; Idle Line Interrupt Enable Bit
SCI1CR2_RIE:        equ    5                                         ; Receiver Full Interrupt Enable Bit
SCI1CR2_TCIE:       equ    6                                         ; Transmission Complete Interrupt Enable Bit
SCI1CR2_TIE:        equ    7                                         ; Transmitter Interrupt Enable Bit
; bit position masks
mSCI1CR2_SBK:       equ    %00000001
mSCI1CR2_RWU:       equ    %00000010
mSCI1CR2_RE:        equ    %00000100
mSCI1CR2_TE:        equ    %00001000
mSCI1CR2_ILIE:      equ    %00010000
mSCI1CR2_RIE:       equ    %00100000
mSCI1CR2_TCIE:      equ    %01000000
mSCI1CR2_TIE:       equ    %10000000


;*** SCI1SR1 - SCI 1 Status Register 1; 0x000000D4 ***
SCI1SR1:            equ    $000000D4                                ;*** SCI1SR1 - SCI 1 Status Register 1; 0x000000D4 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI1SR1_PF:         equ    0                                         ; Parity Error Flag
SCI1SR1_FE:         equ    1                                         ; Framing Error Flag
SCI1SR1_NF:         equ    2                                         ; Noise Flag
SCI1SR1_OR:         equ    3                                         ; Overrun Flag
SCI1SR1_IDLE:       equ    4                                         ; Idle Line Flag
SCI1SR1_RDRF:       equ    5                                         ; Receive Data Register Full Flag
SCI1SR1_TC:         equ    6                                         ; Transmit Complete Flag
SCI1SR1_TDRE:       equ    7                                         ; Transmit Data Register Empty Flag
; bit position masks
mSCI1SR1_PF:        equ    %00000001
mSCI1SR1_FE:        equ    %00000010
mSCI1SR1_NF:        equ    %00000100
mSCI1SR1_OR:        equ    %00001000
mSCI1SR1_IDLE:      equ    %00010000
mSCI1SR1_RDRF:      equ    %00100000
mSCI1SR1_TC:        equ    %01000000
mSCI1SR1_TDRE:      equ    %10000000


;*** SCI1SR2 - SCI 1 Status Register 2; 0x000000D5 ***
SCI1SR2:            equ    $000000D5                                ;*** SCI1SR2 - SCI 1 Status Register 2; 0x000000D5 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI1SR2_RAF:        equ    0                                         ; Receiver Active Flag
SCI1SR2_TXDIR:      equ    1                                         ; Transmitter pin data direction in Single-Wire mode
SCI1SR2_BRK13:      equ    2                                         ; Break Transmit character length
SCI1SR2_RXPOL:      equ    3                                         ; Receive Polarity
SCI1SR2_TXPOL:      equ    4                                         ; Transmit Polarity
SCI1SR2_AMAP:       equ    7                                         ; Alternative Map
; bit position masks
mSCI1SR2_RAF:       equ    %00000001
mSCI1SR2_TXDIR:     equ    %00000010
mSCI1SR2_BRK13:     equ    %00000100
mSCI1SR2_RXPOL:     equ    %00001000
mSCI1SR2_TXPOL:     equ    %00010000
mSCI1SR2_AMAP:      equ    %10000000


;*** SCI1DRH - SCI 1 Data Register High; 0x000000D6 ***
SCI1DRH:            equ    $000000D6                                ;*** SCI1DRH - SCI 1 Data Register High; 0x000000D6 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI1DRH_T8:         equ    6                                         ; Transmit Bit 8
SCI1DRH_R8:         equ    7                                         ; Received Bit 8
; bit position masks
mSCI1DRH_T8:        equ    %01000000
mSCI1DRH_R8:        equ    %10000000


;*** SCI1DRL - SCI 1 Data Register Low; 0x000000D7 ***
SCI1DRL:            equ    $000000D7                                ;*** SCI1DRL - SCI 1 Data Register Low; 0x000000D7 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI1DRL_R0_T0:      equ    0                                         ; Received bit 0 or Transmit bit 0
SCI1DRL_R1_T1:      equ    1                                         ; Received bit 1 or Transmit bit 1
SCI1DRL_R2_T2:      equ    2                                         ; Received bit 2 or Transmit bit 2
SCI1DRL_R3_T3:      equ    3                                         ; Received bit 3 or Transmit bit 3
SCI1DRL_R4_T4:      equ    4                                         ; Received bit 4 or Transmit bit 4
SCI1DRL_R5_T5:      equ    5                                         ; Received bit 5 or Transmit bit 5
SCI1DRL_R6_T6:      equ    6                                         ; Received bit 6 or Transmit bit 6
SCI1DRL_R7_T7:      equ    7                                         ; Received bit 7 or Transmit bit 7
; bit position masks
mSCI1DRL_R0_T0:     equ    %00000001
mSCI1DRL_R1_T1:     equ    %00000010
mSCI1DRL_R2_T2:     equ    %00000100
mSCI1DRL_R3_T3:     equ    %00001000
mSCI1DRL_R4_T4:     equ    %00010000
mSCI1DRL_R5_T5:     equ    %00100000
mSCI1DRL_R6_T6:     equ    %01000000
mSCI1DRL_R7_T7:     equ    %10000000


;*** SPI0CR1 - SPI 0 Control Register 1; 0x000000D8 ***
SPI0CR1:            equ    $000000D8                                ;*** SPI0CR1 - SPI 0 Control Register 1; 0x000000D8 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPI0CR1_LSBFE:      equ    0                                         ; SPI LSB-First Enable
SPI0CR1_SSOE:       equ    1                                         ; Slave Select Output Enable
SPI0CR1_CPHA:       equ    2                                         ; SPI Clock Phase Bit
SPI0CR1_CPOL:       equ    3                                         ; SPI Clock Polarity Bit
SPI0CR1_MSTR:       equ    4                                         ; SPI Master/Slave Mode Select Bit
SPI0CR1_SPTIE:      equ    5                                         ; SPI Transmit Interrupt Enable
SPI0CR1_SPE:        equ    6                                         ; SPI System Enable Bit
SPI0CR1_SPIE:       equ    7                                         ; SPI Interrupt Enable Bit
; bit position masks
mSPI0CR1_LSBFE:     equ    %00000001
mSPI0CR1_SSOE:      equ    %00000010
mSPI0CR1_CPHA:      equ    %00000100
mSPI0CR1_CPOL:      equ    %00001000
mSPI0CR1_MSTR:      equ    %00010000
mSPI0CR1_SPTIE:     equ    %00100000
mSPI0CR1_SPE:       equ    %01000000
mSPI0CR1_SPIE:      equ    %10000000


;*** SPI0CR2 - SPI 0 Control Register 2; 0x000000D9 ***
SPI0CR2:            equ    $000000D9                                ;*** SPI0CR2 - SPI 0 Control Register 2; 0x000000D9 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPI0CR2_SPC0:       equ    0                                         ; Serial Pin Control Bit 0
SPI0CR2_SPISWAI:    equ    1                                         ; SPI Stop in Wait Mode Bit
SPI0CR2_BIDIROE:    equ    3                                         ; Output enable in the Bidirectional mode of operation
SPI0CR2_MODFEN:     equ    4                                         ; Mode Fault Enable Bit
SPI0CR2_XFRW:       equ    6                                         ; Transfer Width
; bit position masks
mSPI0CR2_SPC0:      equ    %00000001
mSPI0CR2_SPISWAI:   equ    %00000010
mSPI0CR2_BIDIROE:   equ    %00001000
mSPI0CR2_MODFEN:    equ    %00010000
mSPI0CR2_XFRW:      equ    %01000000


;*** SPI0BR - SPI 0 Baud Rate Register; 0x000000DA ***
SPI0BR:             equ    $000000DA                                ;*** SPI0BR - SPI 0 Baud Rate Register; 0x000000DA ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPI0BR_SPR0:        equ    0                                         ; SPI Baud Rate Selection Bit 0
SPI0BR_SPR1:        equ    1                                         ; SPI Baud Rate Selection Bit 1
SPI0BR_SPR2:        equ    2                                         ; SPI Baud Rate Selection Bit 2
SPI0BR_SPPR0:       equ    4                                         ; SPI Baud Rate Preselection Bits 0
SPI0BR_SPPR1:       equ    5                                         ; SPI Baud Rate Preselection Bits 1
SPI0BR_SPPR2:       equ    6                                         ; SPI Baud Rate Preselection Bits 2
; bit position masks
mSPI0BR_SPR0:       equ    %00000001
mSPI0BR_SPR1:       equ    %00000010
mSPI0BR_SPR2:       equ    %00000100
mSPI0BR_SPPR0:      equ    %00010000
mSPI0BR_SPPR1:      equ    %00100000
mSPI0BR_SPPR2:      equ    %01000000


;*** SPI0SR - SPI 0 Status Register; 0x000000DB ***
SPI0SR:             equ    $000000DB                                ;*** SPI0SR - SPI 0 Status Register; 0x000000DB ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPI0SR_MODF:        equ    4                                         ; Mode Fault Flag
SPI0SR_SPTEF:       equ    5                                         ; SPI Transmit Empty Interrupt Flag
SPI0SR_SPIF:        equ    7                                         ; SPIF Receive Interrupt Flag
; bit position masks
mSPI0SR_MODF:       equ    %00010000
mSPI0SR_SPTEF:      equ    %00100000
mSPI0SR_SPIF:       equ    %10000000


;*** SPI0DR - SPI 0 Data Register; 0x000000DC ***
SPI0DR:             equ    $000000DC                                ;*** SPI0DR - SPI 0 Data Register; 0x000000DC ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPI0DR_R0_T0:       equ    0                                         ; SPI 0 Data Bit 0
SPI0DR_R1_T1:       equ    1                                         ; SPI 0 Data Bit 1
SPI0DR_R2_T2:       equ    2                                         ; SPI 0 Data Bit 2
SPI0DR_R3_T3:       equ    3                                         ; SPI 0 Data Bit 3
SPI0DR_R4_T4:       equ    4                                         ; SPI 0 Data Bit 4
SPI0DR_R5_T5:       equ    5                                         ; SPI 0 Data Bit 5
SPI0DR_R6_T6:       equ    6                                         ; SPI 0 Data Bit 6
SPI0DR_R7_T7:       equ    7                                         ; SPI 0 Data Bit 7
SPI0DR_R8_T8:       equ    8                                         ; SPI 0 Data Bit 8
SPI0DR_R9_T9:       equ    9                                         ; SPI 0 Data Bit 9
SPI0DR_R10_T10:     equ    10                                        ; SPI 0 Data Bit 10
SPI0DR_R11_T11:     equ    11                                        ; SPI 0 Data Bit 11
SPI0DR_R12_T12:     equ    12                                        ; SPI 0 Data Bit 12
SPI0DR_R13_T13:     equ    13                                        ; SPI 0 Data Bit 13
SPI0DR_R14_T14:     equ    14                                        ; SPI 0 Data Bit 14
SPI0DR_R15_T15:     equ    15                                        ; SPI 0 Data Bit 15
; bit position masks
mSPI0DR_R0_T0:      equ    %00000001
mSPI0DR_R1_T1:      equ    %00000010
mSPI0DR_R2_T2:      equ    %00000100
mSPI0DR_R3_T3:      equ    %00001000
mSPI0DR_R4_T4:      equ    %00010000
mSPI0DR_R5_T5:      equ    %00100000
mSPI0DR_R6_T6:      equ    %01000000
mSPI0DR_R7_T7:      equ    %10000000
mSPI0DR_R8_T8:      equ    %100000000
mSPI0DR_R9_T9:      equ    %1000000000
mSPI0DR_R10_T10:    equ    %10000000000
mSPI0DR_R11_T11:    equ    %100000000000
mSPI0DR_R12_T12:    equ    %1000000000000
mSPI0DR_R13_T13:    equ    %10000000000000
mSPI0DR_R14_T14:    equ    %100000000000000
mSPI0DR_R15_T15:    equ    %1000000000000000


;*** SPI0DRH - SPI 0 Data Register High; 0x000000DC ***
SPI0DRH:            equ    $000000DC                                ;*** SPI0DRH - SPI 0 Data Register High; 0x000000DC ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPI0DRH_R8_T8:      equ    0                                         ; SPI 0 Data Bit 8
SPI0DRH_R9_T9:      equ    1                                         ; SPI 0 Data Bit 9
SPI0DRH_R10_T10:    equ    2                                         ; SPI 0 Data Bit 10
SPI0DRH_R11_T11:    equ    3                                         ; SPI 0 Data Bit 11
SPI0DRH_R12_T12:    equ    4                                         ; SPI 0 Data Bit 12
SPI0DRH_R13_T13:    equ    5                                         ; SPI 0 Data Bit 13
SPI0DRH_R14_T14:    equ    6                                         ; SPI 0 Data Bit 14
SPI0DRH_R15_T15:    equ    7                                         ; SPI 0 Data Bit 15
; bit position masks
mSPI0DRH_R8_T8:     equ    %00000001
mSPI0DRH_R9_T9:     equ    %00000010
mSPI0DRH_R10_T10:   equ    %00000100
mSPI0DRH_R11_T11:   equ    %00001000
mSPI0DRH_R12_T12:   equ    %00010000
mSPI0DRH_R13_T13:   equ    %00100000
mSPI0DRH_R14_T14:   equ    %01000000
mSPI0DRH_R15_T15:   equ    %10000000


;*** SPI0DRL - SPI 0 Data Register Low; 0x000000DD ***
SPI0DRL:            equ    $000000DD                                ;*** SPI0DRL - SPI 0 Data Register Low; 0x000000DD ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPI0DRL_R0_T0:      equ    0                                         ; SPI 0 Data Bit 0
SPI0DRL_R1_T1:      equ    1                                         ; SPI 0 Data Bit 1
SPI0DRL_R2_T2:      equ    2                                         ; SPI 0 Data Bit 2
SPI0DRL_R3_T3:      equ    3                                         ; SPI 0 Data Bit 3
SPI0DRL_R4_T4:      equ    4                                         ; SPI 0 Data Bit 4
SPI0DRL_R5_T5:      equ    5                                         ; SPI 0 Data Bit 5
SPI0DRL_R6_T6:      equ    6                                         ; SPI 0 Data Bit 6
SPI0DRL_R7_T7:      equ    7                                         ; SPI 0 Data Bit 7
; bit position masks
mSPI0DRL_R0_T0:     equ    %00000001
mSPI0DRL_R1_T1:     equ    %00000010
mSPI0DRL_R2_T2:     equ    %00000100
mSPI0DRL_R3_T3:     equ    %00001000
mSPI0DRL_R4_T4:     equ    %00010000
mSPI0DRL_R5_T5:     equ    %00100000
mSPI0DRL_R6_T6:     equ    %01000000
mSPI0DRL_R7_T7:     equ    %10000000


;*** SCI2BD - SCI 2 Baud Rate Register; 0x000000E8 ***
SCI2BD:             equ    $000000E8                                ;*** SCI2BD - SCI 2 Baud Rate Register; 0x000000E8 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI2BD_SBR0:        equ    0                                         ; SCI Baud Rate Bit 0
SCI2BD_SBR1:        equ    1                                         ; SCI Baud Rate Bit 1
SCI2BD_SBR2:        equ    2                                         ; SCI Baud Rate Bit 2
SCI2BD_SBR3:        equ    3                                         ; SCI Baud Rate Bit 3
SCI2BD_SBR4:        equ    4                                         ; SCI Baud Rate Bit 4
SCI2BD_SBR5:        equ    5                                         ; SCI Baud Rate Bit 5
SCI2BD_SBR6:        equ    6                                         ; SCI Baud Rate Bit 6
SCI2BD_SBR7:        equ    7                                         ; SCI Baud Rate Bit 7
SCI2BD_SBR8:        equ    8                                         ; SCI Baud Rate Bit 8
SCI2BD_SBR9:        equ    9                                         ; SCI Baud Rate Bit 9
SCI2BD_SBR10:       equ    10                                        ; SCI Baud Rate Bit 10
SCI2BD_SBR11:       equ    11                                        ; SCI Baud Rate Bit 11
SCI2BD_SBR12:       equ    12                                        ; SCI Baud Rate Bit 12
SCI2BD_TNP0:        equ    13                                        ; Transmitter Narrow Pulse Bit 0
SCI2BD_TNP1:        equ    14                                        ; Transmitter Narrow Pulse Bit 1
SCI2BD_IREN:        equ    15                                        ; Infrared Enable Bit
; bit position masks
mSCI2BD_SBR0:       equ    %00000001
mSCI2BD_SBR1:       equ    %00000010
mSCI2BD_SBR2:       equ    %00000100
mSCI2BD_SBR3:       equ    %00001000
mSCI2BD_SBR4:       equ    %00010000
mSCI2BD_SBR5:       equ    %00100000
mSCI2BD_SBR6:       equ    %01000000
mSCI2BD_SBR7:       equ    %10000000
mSCI2BD_SBR8:       equ    %100000000
mSCI2BD_SBR9:       equ    %1000000000
mSCI2BD_SBR10:      equ    %10000000000
mSCI2BD_SBR11:      equ    %100000000000
mSCI2BD_SBR12:      equ    %1000000000000
mSCI2BD_TNP0:       equ    %10000000000000
mSCI2BD_TNP1:       equ    %100000000000000
mSCI2BD_IREN:       equ    %1000000000000000


;*** SCI2ASR1 - SCI 2 Alternative Status Register 1; 0x000000E8 ***
SCI2ASR1:           equ    $000000E8                                ;*** SCI2ASR1 - SCI 2 Alternative Status Register 1; 0x000000E8 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI2ASR1_BKDIF:     equ    0                                         ; Break Detect Interrupt Flag
SCI2ASR1_BERRIF:    equ    1                                         ; Bit Error Interrupt Flag
SCI2ASR1_BERRV:     equ    2                                         ; Bit Error Value
SCI2ASR1_RXEDGIF:   equ    7                                         ; Receive Input Active Edge Interrupt Flag
; bit position masks
mSCI2ASR1_BKDIF:    equ    %00000001
mSCI2ASR1_BERRIF:   equ    %00000010
mSCI2ASR1_BERRV:    equ    %00000100
mSCI2ASR1_RXEDGIF:  equ    %10000000


;*** SCI2BDH - SCI 2 Baud Rate Register High; 0x000000E8 ***
SCI2BDH:            equ    $000000E8                                ;*** SCI2BDH - SCI 2 Baud Rate Register High; 0x000000E8 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI2BDH_SBR8:       equ    0                                         ; SCI Baud Rate Bit 8
SCI2BDH_SBR9:       equ    1                                         ; SCI Baud Rate Bit 9
SCI2BDH_SBR10:      equ    2                                         ; SCI Baud Rate Bit 10
SCI2BDH_SBR11:      equ    3                                         ; SCI Baud Rate Bit 11
SCI2BDH_SBR12:      equ    4                                         ; SCI Baud Rate Bit 12
SCI2BDH_TNP0:       equ    5                                         ; Transmitter Narrow Pulse Bit 0
SCI2BDH_TNP1:       equ    6                                         ; Transmitter Narrow Pulse Bit 1
SCI2BDH_IREN:       equ    7                                         ; Infrared Enable Bit
; bit position masks
mSCI2BDH_SBR8:      equ    %00000001
mSCI2BDH_SBR9:      equ    %00000010
mSCI2BDH_SBR10:     equ    %00000100
mSCI2BDH_SBR11:     equ    %00001000
mSCI2BDH_SBR12:     equ    %00010000
mSCI2BDH_TNP0:      equ    %00100000
mSCI2BDH_TNP1:      equ    %01000000
mSCI2BDH_IREN:      equ    %10000000


;*** SCI2ACR1 - SCI 2 Alternative Control Register 1; 0x000000E9 ***
SCI2ACR1:           equ    $000000E9                                ;*** SCI2ACR1 - SCI 2 Alternative Control Register 1; 0x000000E9 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI2ACR1_BKDIE:     equ    0                                         ; Break Detect Interrupt Enable
SCI2ACR1_BERRIE:    equ    1                                         ; Bit Error Interrupt Enable
SCI2ACR1_RXEDGIE:   equ    7                                         ; Receive Input Active Edge Interrupt Enable
; bit position masks
mSCI2ACR1_BKDIE:    equ    %00000001
mSCI2ACR1_BERRIE:   equ    %00000010
mSCI2ACR1_RXEDGIE:  equ    %10000000


;*** SCI2BDL - SCI 2 Baud Rate Register Low; 0x000000E9 ***
SCI2BDL:            equ    $000000E9                                ;*** SCI2BDL - SCI 2 Baud Rate Register Low; 0x000000E9 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI2BDL_SBR0:       equ    0                                         ; SCI Baud Rate Bit 0
SCI2BDL_SBR1:       equ    1                                         ; SCI Baud Rate Bit 1
SCI2BDL_SBR2:       equ    2                                         ; SCI Baud Rate Bit 2
SCI2BDL_SBR3:       equ    3                                         ; SCI Baud Rate Bit 3
SCI2BDL_SBR4:       equ    4                                         ; SCI Baud Rate Bit 4
SCI2BDL_SBR5:       equ    5                                         ; SCI Baud Rate Bit 5
SCI2BDL_SBR6:       equ    6                                         ; SCI Baud Rate Bit 6
SCI2BDL_SBR7:       equ    7                                         ; SCI Baud Rate Bit 7
; bit position masks
mSCI2BDL_SBR0:      equ    %00000001
mSCI2BDL_SBR1:      equ    %00000010
mSCI2BDL_SBR2:      equ    %00000100
mSCI2BDL_SBR3:      equ    %00001000
mSCI2BDL_SBR4:      equ    %00010000
mSCI2BDL_SBR5:      equ    %00100000
mSCI2BDL_SBR6:      equ    %01000000
mSCI2BDL_SBR7:      equ    %10000000


;*** SCI2ACR2 - SCI 2 Alternative Control Register 2; 0x000000EA ***
SCI2ACR2:           equ    $000000EA                                ;*** SCI2ACR2 - SCI 2 Alternative Control Register 2; 0x000000EA ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI2ACR2_BKDFE:     equ    0                                         ; Break Detect Feature Enable
SCI2ACR2_BERRM0:    equ    1                                         ; Bit Error Mode 0
SCI2ACR2_BERRM1:    equ    2                                         ; Bit Error Mode 1
; bit position masks
mSCI2ACR2_BKDFE:    equ    %00000001
mSCI2ACR2_BERRM0:   equ    %00000010
mSCI2ACR2_BERRM1:   equ    %00000100


;*** SCI2CR1 - SCI 2 Control Register 1; 0x000000EA ***
SCI2CR1:            equ    $000000EA                                ;*** SCI2CR1 - SCI 2 Control Register 1; 0x000000EA ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI2CR1_PT:         equ    0                                         ; Parity Type Bit
SCI2CR1_PE:         equ    1                                         ; Parity Enable Bit
SCI2CR1_ILT:        equ    2                                         ; Idle Line Type Bit
SCI2CR1_WAKE:       equ    3                                         ; Wakeup Condition Bit
SCI2CR1_M:          equ    4                                         ; Data Format Mode Bit
SCI2CR1_RSRC:       equ    5                                         ; Receiver Source Bit
SCI2CR1_SCISWAI:    equ    6                                         ; SCI Stop in Wait Mode Bit
SCI2CR1_LOOPS:      equ    7                                         ; Loop Select Bit
; bit position masks
mSCI2CR1_PT:        equ    %00000001
mSCI2CR1_PE:        equ    %00000010
mSCI2CR1_ILT:       equ    %00000100
mSCI2CR1_WAKE:      equ    %00001000
mSCI2CR1_M:         equ    %00010000
mSCI2CR1_RSRC:      equ    %00100000
mSCI2CR1_SCISWAI:   equ    %01000000
mSCI2CR1_LOOPS:     equ    %10000000


;*** SCI2CR2 - SCI 2 Control Register 2; 0x000000EB ***
SCI2CR2:            equ    $000000EB                                ;*** SCI2CR2 - SCI 2 Control Register 2; 0x000000EB ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI2CR2_SBK:        equ    0                                         ; Send Break Bit
SCI2CR2_RWU:        equ    1                                         ; Receiver Wakeup Bit
SCI2CR2_RE:         equ    2                                         ; Receiver Enable Bit
SCI2CR2_TE:         equ    3                                         ; Transmitter Enable Bit
SCI2CR2_ILIE:       equ    4                                         ; Idle Line Interrupt Enable Bit
SCI2CR2_RIE:        equ    5                                         ; Receiver Full Interrupt Enable Bit
SCI2CR2_TCIE:       equ    6                                         ; Transmission Complete Interrupt Enable Bit
SCI2CR2_TIE:        equ    7                                         ; Transmitter Interrupt Enable Bit
; bit position masks
mSCI2CR2_SBK:       equ    %00000001
mSCI2CR2_RWU:       equ    %00000010
mSCI2CR2_RE:        equ    %00000100
mSCI2CR2_TE:        equ    %00001000
mSCI2CR2_ILIE:      equ    %00010000
mSCI2CR2_RIE:       equ    %00100000
mSCI2CR2_TCIE:      equ    %01000000
mSCI2CR2_TIE:       equ    %10000000


;*** SCI2SR1 - SCI 2 Status Register 1; 0x000000EC ***
SCI2SR1:            equ    $000000EC                                ;*** SCI2SR1 - SCI 2 Status Register 1; 0x000000EC ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI2SR1_PF:         equ    0                                         ; Parity Error Flag
SCI2SR1_FE:         equ    1                                         ; Framing Error Flag
SCI2SR1_NF:         equ    2                                         ; Noise Flag
SCI2SR1_OR:         equ    3                                         ; Overrun Flag
SCI2SR1_IDLE:       equ    4                                         ; Idle Line Flag
SCI2SR1_RDRF:       equ    5                                         ; Receive Data Register Full Flag
SCI2SR1_TC:         equ    6                                         ; Transmit Complete Flag
SCI2SR1_TDRE:       equ    7                                         ; Transmit Data Register Empty Flag
; bit position masks
mSCI2SR1_PF:        equ    %00000001
mSCI2SR1_FE:        equ    %00000010
mSCI2SR1_NF:        equ    %00000100
mSCI2SR1_OR:        equ    %00001000
mSCI2SR1_IDLE:      equ    %00010000
mSCI2SR1_RDRF:      equ    %00100000
mSCI2SR1_TC:        equ    %01000000
mSCI2SR1_TDRE:      equ    %10000000


;*** SCI2SR2 - SCI 2 Status Register 2; 0x000000ED ***
SCI2SR2:            equ    $000000ED                                ;*** SCI2SR2 - SCI 2 Status Register 2; 0x000000ED ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI2SR2_RAF:        equ    0                                         ; Receiver Active Flag
SCI2SR2_TXDIR:      equ    1                                         ; Transmitter pin data direction in Single-Wire mode
SCI2SR2_BRK13:      equ    2                                         ; Break Transmit character length
SCI2SR2_RXPOL:      equ    3                                         ; Receive Polarity
SCI2SR2_TXPOL:      equ    4                                         ; Transmit Polarity
SCI2SR2_AMAP:       equ    7                                         ; Alternative Map
; bit position masks
mSCI2SR2_RAF:       equ    %00000001
mSCI2SR2_TXDIR:     equ    %00000010
mSCI2SR2_BRK13:     equ    %00000100
mSCI2SR2_RXPOL:     equ    %00001000
mSCI2SR2_TXPOL:     equ    %00010000
mSCI2SR2_AMAP:      equ    %10000000


;*** SCI2DRH - SCI 2 Data Register High; 0x000000EE ***
SCI2DRH:            equ    $000000EE                                ;*** SCI2DRH - SCI 2 Data Register High; 0x000000EE ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI2DRH_T8:         equ    6                                         ; Transmit Bit 8
SCI2DRH_R8:         equ    7                                         ; Received Bit 8
; bit position masks
mSCI2DRH_T8:        equ    %01000000
mSCI2DRH_R8:        equ    %10000000


;*** SCI2DRL - SCI 2 Data Register Low; 0x000000EF ***
SCI2DRL:            equ    $000000EF                                ;*** SCI2DRL - SCI 2 Data Register Low; 0x000000EF ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI2DRL_R0_T0:      equ    0                                         ; Received bit 0 or Transmit bit 0
SCI2DRL_R1_T1:      equ    1                                         ; Received bit 1 or Transmit bit 1
SCI2DRL_R2_T2:      equ    2                                         ; Received bit 2 or Transmit bit 2
SCI2DRL_R3_T3:      equ    3                                         ; Received bit 3 or Transmit bit 3
SCI2DRL_R4_T4:      equ    4                                         ; Received bit 4 or Transmit bit 4
SCI2DRL_R5_T5:      equ    5                                         ; Received bit 5 or Transmit bit 5
SCI2DRL_R6_T6:      equ    6                                         ; Received bit 6 or Transmit bit 6
SCI2DRL_R7_T7:      equ    7                                         ; Received bit 7 or Transmit bit 7
; bit position masks
mSCI2DRL_R0_T0:     equ    %00000001
mSCI2DRL_R1_T1:     equ    %00000010
mSCI2DRL_R2_T2:     equ    %00000100
mSCI2DRL_R3_T3:     equ    %00001000
mSCI2DRL_R4_T4:     equ    %00010000
mSCI2DRL_R5_T5:     equ    %00100000
mSCI2DRL_R6_T6:     equ    %01000000
mSCI2DRL_R7_T7:     equ    %10000000


;*** SPI1CR1 - SPI 1 Control Register 1; 0x000000F0 ***
SPI1CR1:            equ    $000000F0                                ;*** SPI1CR1 - SPI 1 Control Register 1; 0x000000F0 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPI1CR1_LSBFE:      equ    0                                         ; SPI LSB-First Enable
SPI1CR1_SSOE:       equ    1                                         ; Slave Select Output Enable
SPI1CR1_CPHA:       equ    2                                         ; SPI Clock Phase Bit
SPI1CR1_CPOL:       equ    3                                         ; SPI Clock Polarity Bit
SPI1CR1_MSTR:       equ    4                                         ; SPI Master/Slave Mode Select Bit
SPI1CR1_SPTIE:      equ    5                                         ; SPI Transmit Interrupt Enable
SPI1CR1_SPE:        equ    6                                         ; SPI System Enable Bit
SPI1CR1_SPIE:       equ    7                                         ; SPI Interrupt Enable Bit
; bit position masks
mSPI1CR1_LSBFE:     equ    %00000001
mSPI1CR1_SSOE:      equ    %00000010
mSPI1CR1_CPHA:      equ    %00000100
mSPI1CR1_CPOL:      equ    %00001000
mSPI1CR1_MSTR:      equ    %00010000
mSPI1CR1_SPTIE:     equ    %00100000
mSPI1CR1_SPE:       equ    %01000000
mSPI1CR1_SPIE:      equ    %10000000


;*** SPI1CR2 - SPI 1 Control Register 2; 0x000000F1 ***
SPI1CR2:            equ    $000000F1                                ;*** SPI1CR2 - SPI 1 Control Register 2; 0x000000F1 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPI1CR2_SPC0:       equ    0                                         ; Serial Pin Control Bit 0
SPI1CR2_SPISWAI:    equ    1                                         ; SPI Stop in Wait Mode Bit
SPI1CR2_BIDIROE:    equ    3                                         ; Output enable in the Bidirectional mode of operation
SPI1CR2_MODFEN:     equ    4                                         ; Mode Fault Enable Bit
SPI1CR2_XFRW:       equ    6                                         ; Transfer Width
; bit position masks
mSPI1CR2_SPC0:      equ    %00000001
mSPI1CR2_SPISWAI:   equ    %00000010
mSPI1CR2_BIDIROE:   equ    %00001000
mSPI1CR2_MODFEN:    equ    %00010000
mSPI1CR2_XFRW:      equ    %01000000


;*** SPI1BR - SPI 1 Baud Rate Register; 0x000000F2 ***
SPI1BR:             equ    $000000F2                                ;*** SPI1BR - SPI 1 Baud Rate Register; 0x000000F2 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPI1BR_SPR0:        equ    0                                         ; SPI Baud Rate Selection Bit 0
SPI1BR_SPR1:        equ    1                                         ; SPI Baud Rate Selection Bit 1
SPI1BR_SPR2:        equ    2                                         ; SPI Baud Rate Selection Bit 2
SPI1BR_SPPR0:       equ    4                                         ; SPI Baud Rate Preselection Bits 0
SPI1BR_SPPR1:       equ    5                                         ; SPI Baud Rate Preselection Bits 1
SPI1BR_SPPR2:       equ    6                                         ; SPI Baud Rate Preselection Bits 2
; bit position masks
mSPI1BR_SPR0:       equ    %00000001
mSPI1BR_SPR1:       equ    %00000010
mSPI1BR_SPR2:       equ    %00000100
mSPI1BR_SPPR0:      equ    %00010000
mSPI1BR_SPPR1:      equ    %00100000
mSPI1BR_SPPR2:      equ    %01000000


;*** SPI1SR - SPI 1 Status Register; 0x000000F3 ***
SPI1SR:             equ    $000000F3                                ;*** SPI1SR - SPI 1 Status Register; 0x000000F3 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPI1SR_MODF:        equ    4                                         ; Mode Fault Flag
SPI1SR_SPTEF:       equ    5                                         ; SPI Transmit Empty Interrupt Flag
SPI1SR_SPIF:        equ    7                                         ; SPIF Receive Interrupt Flag
; bit position masks
mSPI1SR_MODF:       equ    %00010000
mSPI1SR_SPTEF:      equ    %00100000
mSPI1SR_SPIF:       equ    %10000000


;*** SPI1DR - SPI 1 Data Register; 0x000000F4 ***
SPI1DR:             equ    $000000F4                                ;*** SPI1DR - SPI 1 Data Register; 0x000000F4 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPI1DR_R0_T0:       equ    0                                         ; SPI 1 Data Bit 0
SPI1DR_R1_T1:       equ    1                                         ; SPI 1 Data Bit 1
SPI1DR_R2_T2:       equ    2                                         ; SPI 1 Data Bit 2
SPI1DR_R3_T3:       equ    3                                         ; SPI 1 Data Bit 3
SPI1DR_R4_T4:       equ    4                                         ; SPI 1 Data Bit 4
SPI1DR_R5_T5:       equ    5                                         ; SPI 1 Data Bit 5
SPI1DR_R6_T6:       equ    6                                         ; SPI 1 Data Bit 6
SPI1DR_R7_T7:       equ    7                                         ; SPI 1 Data Bit 7
SPI1DR_R8_T8:       equ    8                                         ; SPI 1 Data Bit 8
SPI1DR_R9_T9:       equ    9                                         ; SPI 1 Data Bit 9
SPI1DR_R10_T10:     equ    10                                        ; SPI 1 Data Bit 10
SPI1DR_R11_T11:     equ    11                                        ; SPI 1 Data Bit 11
SPI1DR_R12_T12:     equ    12                                        ; SPI 1 Data Bit 12
SPI1DR_R13_T13:     equ    13                                        ; SPI 1 Data Bit 13
SPI1DR_R14_T14:     equ    14                                        ; SPI 1 Data Bit 14
SPI1DR_R15_T15:     equ    15                                        ; SPI 1 Data Bit 15
; bit position masks
mSPI1DR_R0_T0:      equ    %00000001
mSPI1DR_R1_T1:      equ    %00000010
mSPI1DR_R2_T2:      equ    %00000100
mSPI1DR_R3_T3:      equ    %00001000
mSPI1DR_R4_T4:      equ    %00010000
mSPI1DR_R5_T5:      equ    %00100000
mSPI1DR_R6_T6:      equ    %01000000
mSPI1DR_R7_T7:      equ    %10000000
mSPI1DR_R8_T8:      equ    %100000000
mSPI1DR_R9_T9:      equ    %1000000000
mSPI1DR_R10_T10:    equ    %10000000000
mSPI1DR_R11_T11:    equ    %100000000000
mSPI1DR_R12_T12:    equ    %1000000000000
mSPI1DR_R13_T13:    equ    %10000000000000
mSPI1DR_R14_T14:    equ    %100000000000000
mSPI1DR_R15_T15:    equ    %1000000000000000


;*** SPI1DRH - SPI 1 Data Register High; 0x000000F4 ***
SPI1DRH:            equ    $000000F4                                ;*** SPI1DRH - SPI 1 Data Register High; 0x000000F4 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPI1DRH_R8_T8:      equ    0                                         ; SPI 1 Data Bit 8
SPI1DRH_R9_T9:      equ    1                                         ; SPI 1 Data Bit 9
SPI1DRH_R10_T10:    equ    2                                         ; SPI 1 Data Bit 10
SPI1DRH_R11_T11:    equ    3                                         ; SPI 1 Data Bit 11
SPI1DRH_R12_T12:    equ    4                                         ; SPI 1 Data Bit 12
SPI1DRH_R13_T13:    equ    5                                         ; SPI 1 Data Bit 13
SPI1DRH_R14_T14:    equ    6                                         ; SPI 1 Data Bit 14
SPI1DRH_R15_T15:    equ    7                                         ; SPI 1 Data Bit 15
; bit position masks
mSPI1DRH_R8_T8:     equ    %00000001
mSPI1DRH_R9_T9:     equ    %00000010
mSPI1DRH_R10_T10:   equ    %00000100
mSPI1DRH_R11_T11:   equ    %00001000
mSPI1DRH_R12_T12:   equ    %00010000
mSPI1DRH_R13_T13:   equ    %00100000
mSPI1DRH_R14_T14:   equ    %01000000
mSPI1DRH_R15_T15:   equ    %10000000


;*** SPI1DRL - SPI 1 Data Register Low; 0x000000F5 ***
SPI1DRL:            equ    $000000F5                                ;*** SPI1DRL - SPI 1 Data Register Low; 0x000000F5 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPI1DRL_R0_T0:      equ    0                                         ; SPI 1 Data Bit 0
SPI1DRL_R1_T1:      equ    1                                         ; SPI 1 Data Bit 1
SPI1DRL_R2_T2:      equ    2                                         ; SPI 1 Data Bit 2
SPI1DRL_R3_T3:      equ    3                                         ; SPI 1 Data Bit 3
SPI1DRL_R4_T4:      equ    4                                         ; SPI 1 Data Bit 4
SPI1DRL_R5_T5:      equ    5                                         ; SPI 1 Data Bit 5
SPI1DRL_R6_T6:      equ    6                                         ; SPI 1 Data Bit 6
SPI1DRL_R7_T7:      equ    7                                         ; SPI 1 Data Bit 7
; bit position masks
mSPI1DRL_R0_T0:     equ    %00000001
mSPI1DRL_R1_T1:     equ    %00000010
mSPI1DRL_R2_T2:     equ    %00000100
mSPI1DRL_R3_T3:     equ    %00001000
mSPI1DRL_R4_T4:     equ    %00010000
mSPI1DRL_R5_T5:     equ    %00100000
mSPI1DRL_R6_T6:     equ    %01000000
mSPI1DRL_R7_T7:     equ    %10000000


;*** SPI2CR1 - SPI 2 Control Register 1; 0x000000F8 ***
SPI2CR1:            equ    $000000F8                                ;*** SPI2CR1 - SPI 2 Control Register 1; 0x000000F8 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPI2CR1_LSBFE:      equ    0                                         ; SPI LSB-First Enable
SPI2CR1_SSOE:       equ    1                                         ; Slave Select Output Enable
SPI2CR1_CPHA:       equ    2                                         ; SPI Clock Phase Bit
SPI2CR1_CPOL:       equ    3                                         ; SPI Clock Polarity Bit
SPI2CR1_MSTR:       equ    4                                         ; SPI Master/Slave Mode Select Bit
SPI2CR1_SPTIE:      equ    5                                         ; SPI Transmit Interrupt Enable
SPI2CR1_SPE:        equ    6                                         ; SPI System Enable Bit
SPI2CR1_SPIE:       equ    7                                         ; SPI Interrupt Enable Bit
; bit position masks
mSPI2CR1_LSBFE:     equ    %00000001
mSPI2CR1_SSOE:      equ    %00000010
mSPI2CR1_CPHA:      equ    %00000100
mSPI2CR1_CPOL:      equ    %00001000
mSPI2CR1_MSTR:      equ    %00010000
mSPI2CR1_SPTIE:     equ    %00100000
mSPI2CR1_SPE:       equ    %01000000
mSPI2CR1_SPIE:      equ    %10000000


;*** SPI2CR2 - SPI 2 Control Register 2; 0x000000F9 ***
SPI2CR2:            equ    $000000F9                                ;*** SPI2CR2 - SPI 2 Control Register 2; 0x000000F9 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPI2CR2_SPC0:       equ    0                                         ; Serial Pin Control Bit 0
SPI2CR2_SPISWAI:    equ    1                                         ; SPI Stop in Wait Mode Bit
SPI2CR2_BIDIROE:    equ    3                                         ; Output enable in the Bidirectional mode of operation
SPI2CR2_MODFEN:     equ    4                                         ; Mode Fault Enable Bit
SPI2CR2_XFRW:       equ    6                                         ; Transfer Width
; bit position masks
mSPI2CR2_SPC0:      equ    %00000001
mSPI2CR2_SPISWAI:   equ    %00000010
mSPI2CR2_BIDIROE:   equ    %00001000
mSPI2CR2_MODFEN:    equ    %00010000
mSPI2CR2_XFRW:      equ    %01000000


;*** SPI2BR - SPI 2 Baud Rate Register; 0x000000FA ***
SPI2BR:             equ    $000000FA                                ;*** SPI2BR - SPI 2 Baud Rate Register; 0x000000FA ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPI2BR_SPR0:        equ    0                                         ; SPI Baud Rate Selection Bit 0
SPI2BR_SPR1:        equ    1                                         ; SPI Baud Rate Selection Bit 1
SPI2BR_SPR2:        equ    2                                         ; SPI Baud Rate Selection Bit 2
SPI2BR_SPPR0:       equ    4                                         ; SPI Baud Rate Preselection Bits 0
SPI2BR_SPPR1:       equ    5                                         ; SPI Baud Rate Preselection Bits 1
SPI2BR_SPPR2:       equ    6                                         ; SPI Baud Rate Preselection Bits 2
; bit position masks
mSPI2BR_SPR0:       equ    %00000001
mSPI2BR_SPR1:       equ    %00000010
mSPI2BR_SPR2:       equ    %00000100
mSPI2BR_SPPR0:      equ    %00010000
mSPI2BR_SPPR1:      equ    %00100000
mSPI2BR_SPPR2:      equ    %01000000


;*** SPI2SR - SPI 2 Status Register; 0x000000FB ***
SPI2SR:             equ    $000000FB                                ;*** SPI2SR - SPI 2 Status Register; 0x000000FB ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPI2SR_MODF:        equ    4                                         ; Mode Fault Flag
SPI2SR_SPTEF:       equ    5                                         ; SPI Transmit Empty Interrupt Flag
SPI2SR_SPIF:        equ    7                                         ; SPIF Receive Interrupt Flag
; bit position masks
mSPI2SR_MODF:       equ    %00010000
mSPI2SR_SPTEF:      equ    %00100000
mSPI2SR_SPIF:       equ    %10000000


;*** SPI2DR - SPI 2 Data Register; 0x000000FC ***
SPI2DR:             equ    $000000FC                                ;*** SPI2DR - SPI 2 Data Register; 0x000000FC ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPI2DR_R0_T0:       equ    0                                         ; SPI 2 Data Bit 0
SPI2DR_R1_T1:       equ    1                                         ; SPI 2 Data Bit 1
SPI2DR_R2_T2:       equ    2                                         ; SPI 2 Data Bit 2
SPI2DR_R3_T3:       equ    3                                         ; SPI 2 Data Bit 3
SPI2DR_R4_T4:       equ    4                                         ; SPI 2 Data Bit 4
SPI2DR_R5_T5:       equ    5                                         ; SPI 2 Data Bit 5
SPI2DR_R6_T6:       equ    6                                         ; SPI 2 Data Bit 6
SPI2DR_R7_T7:       equ    7                                         ; SPI 2 Data Bit 7
SPI2DR_R8_T8:       equ    8                                         ; SPI 2 Data Bit 8
SPI2DR_R9_T9:       equ    9                                         ; SPI 2 Data Bit 9
SPI2DR_R10_T10:     equ    10                                        ; SPI 2 Data Bit 10
SPI2DR_R11_T11:     equ    11                                        ; SPI 2 Data Bit 11
SPI2DR_R12_T12:     equ    12                                        ; SPI 2 Data Bit 12
SPI2DR_R13_T13:     equ    13                                        ; SPI 2 Data Bit 13
SPI2DR_R14_T14:     equ    14                                        ; SPI 2 Data Bit 14
SPI2DR_R15_T15:     equ    15                                        ; SPI 2 Data Bit 15
; bit position masks
mSPI2DR_R0_T0:      equ    %00000001
mSPI2DR_R1_T1:      equ    %00000010
mSPI2DR_R2_T2:      equ    %00000100
mSPI2DR_R3_T3:      equ    %00001000
mSPI2DR_R4_T4:      equ    %00010000
mSPI2DR_R5_T5:      equ    %00100000
mSPI2DR_R6_T6:      equ    %01000000
mSPI2DR_R7_T7:      equ    %10000000
mSPI2DR_R8_T8:      equ    %100000000
mSPI2DR_R9_T9:      equ    %1000000000
mSPI2DR_R10_T10:    equ    %10000000000
mSPI2DR_R11_T11:    equ    %100000000000
mSPI2DR_R12_T12:    equ    %1000000000000
mSPI2DR_R13_T13:    equ    %10000000000000
mSPI2DR_R14_T14:    equ    %100000000000000
mSPI2DR_R15_T15:    equ    %1000000000000000


;*** SPI2DRH - SPI 2 Data Register High; 0x000000FC ***
SPI2DRH:            equ    $000000FC                                ;*** SPI2DRH - SPI 2 Data Register High; 0x000000FC ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPI2DRH_R8_T8:      equ    0                                         ; SPI 2 Data Bit 8
SPI2DRH_R9_T9:      equ    1                                         ; SPI 2 Data Bit 9
SPI2DRH_R10_T10:    equ    2                                         ; SPI 2 Data Bit 10
SPI2DRH_R11_T11:    equ    3                                         ; SPI 2 Data Bit 11
SPI2DRH_R12_T12:    equ    4                                         ; SPI 2 Data Bit 12
SPI2DRH_R13_T13:    equ    5                                         ; SPI 2 Data Bit 13
SPI2DRH_R14_T14:    equ    6                                         ; SPI 2 Data Bit 14
SPI2DRH_R15_T15:    equ    7                                         ; SPI 2 Data Bit 15
; bit position masks
mSPI2DRH_R8_T8:     equ    %00000001
mSPI2DRH_R9_T9:     equ    %00000010
mSPI2DRH_R10_T10:   equ    %00000100
mSPI2DRH_R11_T11:   equ    %00001000
mSPI2DRH_R12_T12:   equ    %00010000
mSPI2DRH_R13_T13:   equ    %00100000
mSPI2DRH_R14_T14:   equ    %01000000
mSPI2DRH_R15_T15:   equ    %10000000


;*** SPI2DRL - SPI 2 Data Register Low; 0x000000FD ***
SPI2DRL:            equ    $000000FD                                ;*** SPI2DRL - SPI 2 Data Register Low; 0x000000FD ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPI2DRL_R0_T0:      equ    0                                         ; SPI 2 Data Bit 0
SPI2DRL_R1_T1:      equ    1                                         ; SPI 2 Data Bit 1
SPI2DRL_R2_T2:      equ    2                                         ; SPI 2 Data Bit 2
SPI2DRL_R3_T3:      equ    3                                         ; SPI 2 Data Bit 3
SPI2DRL_R4_T4:      equ    4                                         ; SPI 2 Data Bit 4
SPI2DRL_R5_T5:      equ    5                                         ; SPI 2 Data Bit 5
SPI2DRL_R6_T6:      equ    6                                         ; SPI 2 Data Bit 6
SPI2DRL_R7_T7:      equ    7                                         ; SPI 2 Data Bit 7
; bit position masks
mSPI2DRL_R0_T0:     equ    %00000001
mSPI2DRL_R1_T1:     equ    %00000010
mSPI2DRL_R2_T2:     equ    %00000100
mSPI2DRL_R3_T3:     equ    %00001000
mSPI2DRL_R4_T4:     equ    %00010000
mSPI2DRL_R5_T5:     equ    %00100000
mSPI2DRL_R6_T6:     equ    %01000000
mSPI2DRL_R7_T7:     equ    %10000000


;*** FCLKDIV - Flash Clock Divider Register; 0x00000100 ***
FCLKDIV:            equ    $00000100                                ;*** FCLKDIV - Flash Clock Divider Register; 0x00000100 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FCLKDIV_FDIV0:      equ    0                                         ; Clock Divider Bit 0
FCLKDIV_FDIV1:      equ    1                                         ; Clock Divider Bit 1
FCLKDIV_FDIV2:      equ    2                                         ; Clock Divider Bit 2
FCLKDIV_FDIV3:      equ    3                                         ; Clock Divider Bit 3
FCLKDIV_FDIV4:      equ    4                                         ; Clock Divider Bit 4
FCLKDIV_FDIV5:      equ    5                                         ; Clock Divider Bit 5
FCLKDIV_FDIVLCK:    equ    6                                         ; Clock divider locked
FCLKDIV_FDIVLD:     equ    7                                         ; Clock Divider Loaded
; bit position masks
mFCLKDIV_FDIV0:     equ    %00000001
mFCLKDIV_FDIV1:     equ    %00000010
mFCLKDIV_FDIV2:     equ    %00000100
mFCLKDIV_FDIV3:     equ    %00001000
mFCLKDIV_FDIV4:     equ    %00010000
mFCLKDIV_FDIV5:     equ    %00100000
mFCLKDIV_FDIVLCK:   equ    %01000000
mFCLKDIV_FDIVLD:    equ    %10000000


;*** FSEC - Flash Security Register; 0x00000101 ***
FSEC:               equ    $00000101                                ;*** FSEC - Flash Security Register; 0x00000101 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FSEC_SEC0:          equ    0                                         ; Flash Security Bit 0
FSEC_SEC1:          equ    1                                         ; Flash Security Bit 1
FSEC_RNV2:          equ    2                                         ; Reserved Nonvolatile Bit 2
FSEC_RNV3:          equ    3                                         ; Reserved Nonvolatile Bit 3
FSEC_RNV4:          equ    4                                         ; Reserved Nonvolatile Bit 4
FSEC_RNV5:          equ    5                                         ; Reserved Nonvolatile Bit 5
FSEC_KEYEN0:        equ    6                                         ; Backdoor Key Security Enable Bit 0
FSEC_KEYEN1:        equ    7                                         ; Backdoor Key Security Enable Bit 1
; bit position masks
mFSEC_SEC0:         equ    %00000001
mFSEC_SEC1:         equ    %00000010
mFSEC_RNV2:         equ    %00000100
mFSEC_RNV3:         equ    %00001000
mFSEC_RNV4:         equ    %00010000
mFSEC_RNV5:         equ    %00100000
mFSEC_KEYEN0:       equ    %01000000
mFSEC_KEYEN1:       equ    %10000000


;*** FCCOBIX - Flash CCOB Index Register; 0x00000102 ***
FCCOBIX:            equ    $00000102                                ;*** FCCOBIX - Flash CCOB Index Register; 0x00000102 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FCCOBIX_CCOBIX0:    equ    0                                         ; Common Command Register Index Bit 0
FCCOBIX_CCOBIX1:    equ    1                                         ; Common Command Register Index Bit 1
FCCOBIX_CCOBIX2:    equ    2                                         ; Common Command Register Index Bit 2
; bit position masks
mFCCOBIX_CCOBIX0:   equ    %00000001
mFCCOBIX_CCOBIX1:   equ    %00000010
mFCCOBIX_CCOBIX2:   equ    %00000100


;*** FCNFG - Flash Configuration Register; 0x00000104 ***
FCNFG:              equ    $00000104                                ;*** FCNFG - Flash Configuration Register; 0x00000104 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FCNFG_FSFD:         equ    0                                         ; Force Single Bit Fault Detect
FCNFG_FDFD:         equ    1                                         ; Force Double Bit Fault Detect
FCNFG_IGNSF:        equ    4                                         ; Ignore Single Bit Fault
FCNFG_CCIE:         equ    7                                         ; Command Complete Interrupt Enable
; bit position masks
mFCNFG_FSFD:        equ    %00000001
mFCNFG_FDFD:        equ    %00000010
mFCNFG_IGNSF:       equ    %00010000
mFCNFG_CCIE:        equ    %10000000


;*** FERCNFG - Flash Error Configuration Register; 0x00000105 ***
FERCNFG:            equ    $00000105                                ;*** FERCNFG - Flash Error Configuration Register; 0x00000105 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FERCNFG_SFDIE:      equ    0                                         ; Single Bit Fault Detect Interrupt Enable
FERCNFG_DFDIE:      equ    1                                         ; Double Bit Fault Detect Interrupt Enable
; bit position masks
mFERCNFG_SFDIE:     equ    %00000001
mFERCNFG_DFDIE:     equ    %00000010


;*** FSTAT - Flash Status Register; 0x00000106 ***
FSTAT:              equ    $00000106                                ;*** FSTAT - Flash Status Register; 0x00000106 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FSTAT_MGSTAT0:      equ    0                                         ; Memory Controller Command Completion Status Flag 0
FSTAT_MGSTAT1:      equ    1                                         ; Memory Controller Command Completion Status Flag 1
FSTAT_MGBUSY:       equ    3                                         ; Memory Controller Busy Flag
FSTAT_FPVIOL:       equ    4                                         ; Flash Protection Violation Flag
FSTAT_ACCERR:       equ    5                                         ; Flash Access Error Flag
FSTAT_CCIF:         equ    7                                         ; Command Complete Interrupt Flag
; bit position masks
mFSTAT_MGSTAT0:     equ    %00000001
mFSTAT_MGSTAT1:     equ    %00000010
mFSTAT_MGBUSY:      equ    %00001000
mFSTAT_FPVIOL:      equ    %00010000
mFSTAT_ACCERR:      equ    %00100000
mFSTAT_CCIF:        equ    %10000000


;*** FERSTAT - Flash Error Status Register; 0x00000107 ***
FERSTAT:            equ    $00000107                                ;*** FERSTAT - Flash Error Status Register; 0x00000107 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FERSTAT_SFDIF:      equ    0                                         ; Single Bit Fault Detect Interrupt Flag
FERSTAT_DFDIF:      equ    1                                         ; Double Bit Fault Detect Interrupt Flag
; bit position masks
mFERSTAT_SFDIF:     equ    %00000001
mFERSTAT_DFDIF:     equ    %00000010


;*** FPROT - P-Flash Protection Register; 0x00000108 ***
FPROT:              equ    $00000108                                ;*** FPROT - P-Flash Protection Register; 0x00000108 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FPROT_FPLS0:        equ    0                                         ; Flash Protection Lower Address Size Bit 0
FPROT_FPLS1:        equ    1                                         ; Flash Protection Lower Address Size Bit 1
FPROT_FPLDIS:       equ    2                                         ; Flash Protection Lower Address Range Disable
FPROT_FPHS0:        equ    3                                         ; Flash Protection Higher Address Size Bit 0
FPROT_FPHS1:        equ    4                                         ; Flash Protection Higher Address Size Bit 1
FPROT_FPHDIS:       equ    5                                         ; Flash Protection Higher Address Range Disable
FPROT_RNV6:         equ    6                                         ; Reserved Nonvolatile Bit
FPROT_FPOPEN:       equ    7                                         ; Flash Protection Operation Enable
; bit position masks
mFPROT_FPLS0:       equ    %00000001
mFPROT_FPLS1:       equ    %00000010
mFPROT_FPLDIS:      equ    %00000100
mFPROT_FPHS0:       equ    %00001000
mFPROT_FPHS1:       equ    %00010000
mFPROT_FPHDIS:      equ    %00100000
mFPROT_RNV6:        equ    %01000000
mFPROT_FPOPEN:      equ    %10000000


;*** DFPROT - D-Flash Protection Register; 0x00000109 ***
DFPROT:             equ    $00000109                                ;*** DFPROT - D-Flash Protection Register; 0x00000109 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DFPROT_DPS0:        equ    0                                         ; D-Flash Protection Size Bit 0
DFPROT_DPS1:        equ    1                                         ; D-Flash Protection Size Bit 1
DFPROT_DPS2:        equ    2                                         ; D-Flash Protection Size Bit 2
DFPROT_DPS3:        equ    3                                         ; D-Flash Protection Size Bit 3
DFPROT_DPS4:        equ    4                                         ; D-Flash Protection Size Bit 4
DFPROT_DPS5:        equ    5                                         ; D-Flash Protection Size Bit 5
DFPROT_DPS6:        equ    6                                         ; D-Flash Protection Size Bit 6
DFPROT_DPOPEN:      equ    7                                         ; D-Flash Protection Control
; bit position masks
mDFPROT_DPS0:       equ    %00000001
mDFPROT_DPS1:       equ    %00000010
mDFPROT_DPS2:       equ    %00000100
mDFPROT_DPS3:       equ    %00001000
mDFPROT_DPS4:       equ    %00010000
mDFPROT_DPS5:       equ    %00100000
mDFPROT_DPS6:       equ    %01000000
mDFPROT_DPOPEN:     equ    %10000000


;*** FCCOB - Flash Common Command Object Register; 0x0000010A ***
FCCOB:              equ    $0000010A                                ;*** FCCOB - Flash Common Command Object Register; 0x0000010A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FCCOB_CCOB0:        equ    0                                         ; Flash Common Command Object Bit 0
FCCOB_CCOB1:        equ    1                                         ; Flash Common Command Object Bit 1
FCCOB_CCOB2:        equ    2                                         ; Flash Common Command Object Bit 2
FCCOB_CCOB3:        equ    3                                         ; Flash Common Command Object Bit 3
FCCOB_CCOB4:        equ    4                                         ; Flash Common Command Object Bit 4
FCCOB_CCOB5:        equ    5                                         ; Flash Common Command Object Bit 5
FCCOB_CCOB6:        equ    6                                         ; Flash Common Command Object Bit 6
FCCOB_CCOB7:        equ    7                                         ; Flash Common Command Object Bit 7
FCCOB_CCOB8:        equ    8                                         ; Flash Common Command Object Bit 8
FCCOB_CCOB9:        equ    9                                         ; Flash Common Command Object Bit 9
FCCOB_CCOB10:       equ    10                                        ; Flash Common Command Object Bit 10
FCCOB_CCOB11:       equ    11                                        ; Flash Common Command Object Bit 11
FCCOB_CCOB12:       equ    12                                        ; Flash Common Command Object Bit 12
FCCOB_CCOB13:       equ    13                                        ; Flash Common Command Object Bit 13
FCCOB_CCOB14:       equ    14                                        ; Flash Common Command Object Bit 14
FCCOB_CCOB15:       equ    15                                        ; Flash Common Command Object Bit 15
; bit position masks
mFCCOB_CCOB0:       equ    %00000001
mFCCOB_CCOB1:       equ    %00000010
mFCCOB_CCOB2:       equ    %00000100
mFCCOB_CCOB3:       equ    %00001000
mFCCOB_CCOB4:       equ    %00010000
mFCCOB_CCOB5:       equ    %00100000
mFCCOB_CCOB6:       equ    %01000000
mFCCOB_CCOB7:       equ    %10000000
mFCCOB_CCOB8:       equ    %100000000
mFCCOB_CCOB9:       equ    %1000000000
mFCCOB_CCOB10:      equ    %10000000000
mFCCOB_CCOB11:      equ    %100000000000
mFCCOB_CCOB12:      equ    %1000000000000
mFCCOB_CCOB13:      equ    %10000000000000
mFCCOB_CCOB14:      equ    %100000000000000
mFCCOB_CCOB15:      equ    %1000000000000000


;*** FCCOBHI - Flash Common Command Object Register High; 0x0000010A ***
FCCOBHI:            equ    $0000010A                                ;*** FCCOBHI - Flash Common Command Object Register High; 0x0000010A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FCCOBHI_CCOB8:      equ    0                                         ; Flash Common Command Object Bit 8
FCCOBHI_CCOB9:      equ    1                                         ; Flash Common Command Object Bit 9
FCCOBHI_CCOB10:     equ    2                                         ; Flash Common Command Object Bit 10
FCCOBHI_CCOB11:     equ    3                                         ; Flash Common Command Object Bit 11
FCCOBHI_CCOB12:     equ    4                                         ; Flash Common Command Object Bit 12
FCCOBHI_CCOB13:     equ    5                                         ; Flash Common Command Object Bit 13
FCCOBHI_CCOB14:     equ    6                                         ; Flash Common Command Object Bit 14
FCCOBHI_CCOB15:     equ    7                                         ; Flash Common Command Object Bit 15
; bit position masks
mFCCOBHI_CCOB8:     equ    %00000001
mFCCOBHI_CCOB9:     equ    %00000010
mFCCOBHI_CCOB10:    equ    %00000100
mFCCOBHI_CCOB11:    equ    %00001000
mFCCOBHI_CCOB12:    equ    %00010000
mFCCOBHI_CCOB13:    equ    %00100000
mFCCOBHI_CCOB14:    equ    %01000000
mFCCOBHI_CCOB15:    equ    %10000000


;*** FCCOBLO - Flash Common Command Object Register Low; 0x0000010B ***
FCCOBLO:            equ    $0000010B                                ;*** FCCOBLO - Flash Common Command Object Register Low; 0x0000010B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FCCOBLO_CCOB0:      equ    0                                         ; Flash Common Command Object Bit 0
FCCOBLO_CCOB1:      equ    1                                         ; Flash Common Command Object Bit 1
FCCOBLO_CCOB2:      equ    2                                         ; Flash Common Command Object Bit 2
FCCOBLO_CCOB3:      equ    3                                         ; Flash Common Command Object Bit 3
FCCOBLO_CCOB4:      equ    4                                         ; Flash Common Command Object Bit 4
FCCOBLO_CCOB5:      equ    5                                         ; Flash Common Command Object Bit 5
FCCOBLO_CCOB6:      equ    6                                         ; Flash Common Command Object Bit 6
FCCOBLO_CCOB7:      equ    7                                         ; Flash Common Command Object Bit 7
; bit position masks
mFCCOBLO_CCOB0:     equ    %00000001
mFCCOBLO_CCOB1:     equ    %00000010
mFCCOBLO_CCOB2:     equ    %00000100
mFCCOBLO_CCOB3:     equ    %00001000
mFCCOBLO_CCOB4:     equ    %00010000
mFCCOBLO_CCOB5:     equ    %00100000
mFCCOBLO_CCOB6:     equ    %01000000
mFCCOBLO_CCOB7:     equ    %10000000


;*** FOPT - Flash Option Register; 0x00000110 ***
FOPT:               equ    $00000110                                ;*** FOPT - Flash Option Register; 0x00000110 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FOPT_NV0:           equ    0                                         ; Nonvolatile Bit 0
FOPT_NV1:           equ    1                                         ; Nonvolatile Bit 1
FOPT_NV2:           equ    2                                         ; Nonvolatile Bit 2
FOPT_NV3:           equ    3                                         ; Nonvolatile Bit 3
FOPT_NV4:           equ    4                                         ; Nonvolatile Bit 4
FOPT_NV5:           equ    5                                         ; Nonvolatile Bit 5
FOPT_NV6:           equ    6                                         ; Nonvolatile Bit 6
FOPT_NV7:           equ    7                                         ; Nonvolatile Bit 7
; bit position masks
mFOPT_NV0:          equ    %00000001
mFOPT_NV1:          equ    %00000010
mFOPT_NV2:          equ    %00000100
mFOPT_NV3:          equ    %00001000
mFOPT_NV4:          equ    %00010000
mFOPT_NV5:          equ    %00100000
mFOPT_NV6:          equ    %01000000
mFOPT_NV7:          equ    %10000000


;*** IVBR - Interrupt Vector Base Register; 0x00000120 ***
IVBR:               equ    $00000120                                ;*** IVBR - Interrupt Vector Base Register; 0x00000120 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
IVBR_IVB_ADDR0:     equ    0                                         ; Interrupt Vector Base Address Bits, bit 0
IVBR_IVB_ADDR1:     equ    1                                         ; Interrupt Vector Base Address Bits, bit 1
IVBR_IVB_ADDR2:     equ    2                                         ; Interrupt Vector Base Address Bits, bit 2
IVBR_IVB_ADDR3:     equ    3                                         ; Interrupt Vector Base Address Bits, bit 3
IVBR_IVB_ADDR4:     equ    4                                         ; Interrupt Vector Base Address Bits, bit 4
IVBR_IVB_ADDR5:     equ    5                                         ; Interrupt Vector Base Address Bits, bit 5
IVBR_IVB_ADDR6:     equ    6                                         ; Interrupt Vector Base Address Bits, bit 6
IVBR_IVB_ADDR7:     equ    7                                         ; Interrupt Vector Base Address Bits, bit 7
; bit position masks
mIVBR_IVB_ADDR0:    equ    %00000001
mIVBR_IVB_ADDR1:    equ    %00000010
mIVBR_IVB_ADDR2:    equ    %00000100
mIVBR_IVB_ADDR3:    equ    %00001000
mIVBR_IVB_ADDR4:    equ    %00010000
mIVBR_IVB_ADDR5:    equ    %00100000
mIVBR_IVB_ADDR6:    equ    %01000000
mIVBR_IVB_ADDR7:    equ    %10000000


;*** CANCTL0 - MSCAN Control 0 Register; 0x00000140 ***
CANCTL0:            equ    $00000140                                ;*** CANCTL0 - MSCAN Control 0 Register; 0x00000140 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANCTL0_INITRQ:     equ    0                                         ; Initialization Mode Request
CANCTL0_SLPRQ:      equ    1                                         ; Sleep Mode Request
CANCTL0_WUPE:       equ    2                                         ; Wake-Up Enable
CANCTL0_TIME:       equ    3                                         ; Timer Enable
CANCTL0_SYNCH:      equ    4                                         ; Synchronized Status
CANCTL0_CSWAI:      equ    5                                         ; CAN Stops in Wait Mode
CANCTL0_RXACT:      equ    6                                         ; Receiver Active Status
CANCTL0_RXFRM:      equ    7                                         ; Received Frame Flag
; bit position masks
mCANCTL0_INITRQ:    equ    %00000001
mCANCTL0_SLPRQ:     equ    %00000010
mCANCTL0_WUPE:      equ    %00000100
mCANCTL0_TIME:      equ    %00001000
mCANCTL0_SYNCH:     equ    %00010000
mCANCTL0_CSWAI:     equ    %00100000
mCANCTL0_RXACT:     equ    %01000000
mCANCTL0_RXFRM:     equ    %10000000


;*** CANCTL1 - MSCAN Control 1 Register; 0x00000141 ***
CANCTL1:            equ    $00000141                                ;*** CANCTL1 - MSCAN Control 1 Register; 0x00000141 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANCTL1_INITAK:     equ    0                                         ; Initialization Mode Acknowledge
CANCTL1_SLPAK:      equ    1                                         ; Sleep Mode Acknowledge
CANCTL1_WUPM:       equ    2                                         ; Wake-Up Mode
CANCTL1_BORM:       equ    3                                         ; Bus-Off Recovery Mode
CANCTL1_LISTEN:     equ    4                                         ; Listen Only Mode
CANCTL1_LOOPB:      equ    5                                         ; Loop Back Self Test Mode
CANCTL1_CLKSRC:     equ    6                                         ; MSCAN Clock Source
CANCTL1_CANE:       equ    7                                         ; MSCAN Enable
; bit position masks
mCANCTL1_INITAK:    equ    %00000001
mCANCTL1_SLPAK:     equ    %00000010
mCANCTL1_WUPM:      equ    %00000100
mCANCTL1_BORM:      equ    %00001000
mCANCTL1_LISTEN:    equ    %00010000
mCANCTL1_LOOPB:     equ    %00100000
mCANCTL1_CLKSRC:    equ    %01000000
mCANCTL1_CANE:      equ    %10000000


;*** CANBTR0 - MSCAN Bus Timing Register 0; 0x00000142 ***
CANBTR0:            equ    $00000142                                ;*** CANBTR0 - MSCAN Bus Timing Register 0; 0x00000142 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANBTR0_BRP0:       equ    0                                         ; Baud Rate Prescaler 0
CANBTR0_BRP1:       equ    1                                         ; Baud Rate Prescaler 1
CANBTR0_BRP2:       equ    2                                         ; Baud Rate Prescaler 2
CANBTR0_BRP3:       equ    3                                         ; Baud Rate Prescaler 3
CANBTR0_BRP4:       equ    4                                         ; Baud Rate Prescaler 4
CANBTR0_BRP5:       equ    5                                         ; Baud Rate Prescaler 5
CANBTR0_SJW0:       equ    6                                         ; Synchronization Jump Width 0
CANBTR0_SJW1:       equ    7                                         ; Synchronization Jump Width 1
; bit position masks
mCANBTR0_BRP0:      equ    %00000001
mCANBTR0_BRP1:      equ    %00000010
mCANBTR0_BRP2:      equ    %00000100
mCANBTR0_BRP3:      equ    %00001000
mCANBTR0_BRP4:      equ    %00010000
mCANBTR0_BRP5:      equ    %00100000
mCANBTR0_SJW0:      equ    %01000000
mCANBTR0_SJW1:      equ    %10000000


;*** CANBTR1 - MSCAN Bus Timing Register 1; 0x00000143 ***
CANBTR1:            equ    $00000143                                ;*** CANBTR1 - MSCAN Bus Timing Register 1; 0x00000143 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANBTR1_TSEG10:     equ    0                                         ; Time Segment 10
CANBTR1_TSEG11:     equ    1                                         ; Time Segment 11
CANBTR1_TSEG12:     equ    2                                         ; Time Segment 12
CANBTR1_TSEG13:     equ    3                                         ; Time Segment 13
CANBTR1_TSEG20:     equ    4                                         ; Time Segment 20
CANBTR1_TSEG21:     equ    5                                         ; Time Segment 21
CANBTR1_TSEG22:     equ    6                                         ; Time Segment 22
CANBTR1_SAMP:       equ    7                                         ; Sampling
; bit position masks
mCANBTR1_TSEG10:    equ    %00000001
mCANBTR1_TSEG11:    equ    %00000010
mCANBTR1_TSEG12:    equ    %00000100
mCANBTR1_TSEG13:    equ    %00001000
mCANBTR1_TSEG20:    equ    %00010000
mCANBTR1_TSEG21:    equ    %00100000
mCANBTR1_TSEG22:    equ    %01000000
mCANBTR1_SAMP:      equ    %10000000


;*** CANRFLG - MSCAN Receiver Flag Register; 0x00000144 ***
CANRFLG:            equ    $00000144                                ;*** CANRFLG - MSCAN Receiver Flag Register; 0x00000144 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANRFLG_RXF:        equ    0                                         ; Receive Buffer Full
CANRFLG_OVRIF:      equ    1                                         ; Overrun Interrupt Flag
CANRFLG_TSTAT0:     equ    2                                         ; Transmitter Status Bit 0
CANRFLG_TSTAT1:     equ    3                                         ; Transmitter Status Bit 1
CANRFLG_RSTAT0:     equ    4                                         ; Receiver Status Bit 0
CANRFLG_RSTAT1:     equ    5                                         ; Receiver Status Bit 1
CANRFLG_CSCIF:      equ    6                                         ; CAN Status Change Interrupt Flag
CANRFLG_WUPIF:      equ    7                                         ; Wake-up Interrupt Flag
; bit position masks
mCANRFLG_RXF:       equ    %00000001
mCANRFLG_OVRIF:     equ    %00000010
mCANRFLG_TSTAT0:    equ    %00000100
mCANRFLG_TSTAT1:    equ    %00001000
mCANRFLG_RSTAT0:    equ    %00010000
mCANRFLG_RSTAT1:    equ    %00100000
mCANRFLG_CSCIF:     equ    %01000000
mCANRFLG_WUPIF:     equ    %10000000


;*** CANRIER - MSCAN Receiver Interrupt Enable Register; 0x00000145 ***
CANRIER:            equ    $00000145                                ;*** CANRIER - MSCAN Receiver Interrupt Enable Register; 0x00000145 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANRIER_RXFIE:      equ    0                                         ; Receiver Full Interrupt Enable
CANRIER_OVRIE:      equ    1                                         ; Overrun Interrupt Enable
CANRIER_TSTATE0:    equ    2                                         ; Transmitter Status Change Enable 0
CANRIER_TSTATE1:    equ    3                                         ; Transmitter Status Change Enable 1
CANRIER_RSTATE0:    equ    4                                         ; Receiver Status Change Enable 0
CANRIER_RSTATE1:    equ    5                                         ; Receiver Status Change Enable 1
CANRIER_CSCIE:      equ    6                                         ; CAN Status Change Interrupt Enable
CANRIER_WUPIE:      equ    7                                         ; Wake-up Interrupt Enable
; bit position masks
mCANRIER_RXFIE:     equ    %00000001
mCANRIER_OVRIE:     equ    %00000010
mCANRIER_TSTATE0:   equ    %00000100
mCANRIER_TSTATE1:   equ    %00001000
mCANRIER_RSTATE0:   equ    %00010000
mCANRIER_RSTATE1:   equ    %00100000
mCANRIER_CSCIE:     equ    %01000000
mCANRIER_WUPIE:     equ    %10000000


;*** CANTFLG - MSCAN Transmitter Flag Register; 0x00000146 ***
CANTFLG:            equ    $00000146                                ;*** CANTFLG - MSCAN Transmitter Flag Register; 0x00000146 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANTFLG_TXE0:       equ    0                                         ; Transmitter Buffer Empty 0
CANTFLG_TXE1:       equ    1                                         ; Transmitter Buffer Empty 1
CANTFLG_TXE2:       equ    2                                         ; Transmitter Buffer Empty 2
; bit position masks
mCANTFLG_TXE0:      equ    %00000001
mCANTFLG_TXE1:      equ    %00000010
mCANTFLG_TXE2:      equ    %00000100


;*** CANTIER - MSCAN Transmitter Interrupt Enable Register; 0x00000147 ***
CANTIER:            equ    $00000147                                ;*** CANTIER - MSCAN Transmitter Interrupt Enable Register; 0x00000147 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANTIER_TXEIE0:     equ    0                                         ; Transmitter Empty Interrupt Enable 0
CANTIER_TXEIE1:     equ    1                                         ; Transmitter Empty Interrupt Enable 1
CANTIER_TXEIE2:     equ    2                                         ; Transmitter Empty Interrupt Enable 2
; bit position masks
mCANTIER_TXEIE0:    equ    %00000001
mCANTIER_TXEIE1:    equ    %00000010
mCANTIER_TXEIE2:    equ    %00000100


;*** CANTARQ - MSCAN Transmitter Message Abort Request; 0x00000148 ***
CANTARQ:            equ    $00000148                                ;*** CANTARQ - MSCAN Transmitter Message Abort Request; 0x00000148 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANTARQ_ABTRQ0:     equ    0                                         ; Abort Request 0
CANTARQ_ABTRQ1:     equ    1                                         ; Abort Request 1
CANTARQ_ABTRQ2:     equ    2                                         ; Abort Request 2
; bit position masks
mCANTARQ_ABTRQ0:    equ    %00000001
mCANTARQ_ABTRQ1:    equ    %00000010
mCANTARQ_ABTRQ2:    equ    %00000100


;*** CANTAAK - MSCAN Transmitter Message Abort Acknowledge; 0x00000149 ***
CANTAAK:            equ    $00000149                                ;*** CANTAAK - MSCAN Transmitter Message Abort Acknowledge; 0x00000149 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANTAAK_ABTAK0:     equ    0                                         ; Abort Acknowledge 0
CANTAAK_ABTAK1:     equ    1                                         ; Abort Acknowledge 1
CANTAAK_ABTAK2:     equ    2                                         ; Abort Acknowledge 2
; bit position masks
mCANTAAK_ABTAK0:    equ    %00000001
mCANTAAK_ABTAK1:    equ    %00000010
mCANTAAK_ABTAK2:    equ    %00000100


;*** CANTBSEL - MSCAN Transmit Buffer Selection; 0x0000014A ***
CANTBSEL:           equ    $0000014A                                ;*** CANTBSEL - MSCAN Transmit Buffer Selection; 0x0000014A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANTBSEL_TX0:       equ    0                                         ; Transmit Buffer Select 0
CANTBSEL_TX1:       equ    1                                         ; Transmit Buffer Select 1
CANTBSEL_TX2:       equ    2                                         ; Transmit Buffer Select 2
; bit position masks
mCANTBSEL_TX0:      equ    %00000001
mCANTBSEL_TX1:      equ    %00000010
mCANTBSEL_TX2:      equ    %00000100


;*** CANIDAC - MSCAN Identifier Acceptance Control Register; 0x0000014B ***
CANIDAC:            equ    $0000014B                                ;*** CANIDAC - MSCAN Identifier Acceptance Control Register; 0x0000014B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANIDAC_IDHIT0:     equ    0                                         ; Identifier Acceptance Hit Indicator 0
CANIDAC_IDHIT1:     equ    1                                         ; Identifier Acceptance Hit Indicator 1
CANIDAC_IDHIT2:     equ    2                                         ; Identifier Acceptance Hit Indicator 2
CANIDAC_IDAM0:      equ    4                                         ; Identifier Acceptance Mode 0
CANIDAC_IDAM1:      equ    5                                         ; Identifier Acceptance Mode 1
; bit position masks
mCANIDAC_IDHIT0:    equ    %00000001
mCANIDAC_IDHIT1:    equ    %00000010
mCANIDAC_IDHIT2:    equ    %00000100
mCANIDAC_IDAM0:     equ    %00010000
mCANIDAC_IDAM1:     equ    %00100000


;*** CANMISC - MSCAN Miscellaneous Register; 0x0000014D ***
CANMISC:            equ    $0000014D                                ;*** CANMISC - MSCAN Miscellaneous Register; 0x0000014D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANMISC_BOHOLD:     equ    0                                         ; Bus-off State Hold Until User Request
; bit position masks
mCANMISC_BOHOLD:    equ    %00000001


;*** CANRXERR - MSCAN Receive Error Counter Register; 0x0000014E ***
CANRXERR:           equ    $0000014E                                ;*** CANRXERR - MSCAN Receive Error Counter Register; 0x0000014E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANRXERR_RXERR0:    equ    0                                         ; Bit 0
CANRXERR_RXERR1:    equ    1                                         ; Bit 1
CANRXERR_RXERR2:    equ    2                                         ; Bit 2
CANRXERR_RXERR3:    equ    3                                         ; Bit 3
CANRXERR_RXERR4:    equ    4                                         ; Bit 4
CANRXERR_RXERR5:    equ    5                                         ; Bit 5
CANRXERR_RXERR6:    equ    6                                         ; Bit 6
CANRXERR_RXERR7:    equ    7                                         ; Bit 7
; bit position masks
mCANRXERR_RXERR0:   equ    %00000001
mCANRXERR_RXERR1:   equ    %00000010
mCANRXERR_RXERR2:   equ    %00000100
mCANRXERR_RXERR3:   equ    %00001000
mCANRXERR_RXERR4:   equ    %00010000
mCANRXERR_RXERR5:   equ    %00100000
mCANRXERR_RXERR6:   equ    %01000000
mCANRXERR_RXERR7:   equ    %10000000


;*** CANTXERR - MSCAN Transmit Error Counter Register; 0x0000014F ***
CANTXERR:           equ    $0000014F                                ;*** CANTXERR - MSCAN Transmit Error Counter Register; 0x0000014F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANTXERR_TXERR0:    equ    0                                         ; Bit 0
CANTXERR_TXERR1:    equ    1                                         ; Bit 1
CANTXERR_TXERR2:    equ    2                                         ; Bit 2
CANTXERR_TXERR3:    equ    3                                         ; Bit 3
CANTXERR_TXERR4:    equ    4                                         ; Bit 4
CANTXERR_TXERR5:    equ    5                                         ; Bit 5
CANTXERR_TXERR6:    equ    6                                         ; Bit 6
CANTXERR_TXERR7:    equ    7                                         ; Bit 7
; bit position masks
mCANTXERR_TXERR0:   equ    %00000001
mCANTXERR_TXERR1:   equ    %00000010
mCANTXERR_TXERR2:   equ    %00000100
mCANTXERR_TXERR3:   equ    %00001000
mCANTXERR_TXERR4:   equ    %00010000
mCANTXERR_TXERR5:   equ    %00100000
mCANTXERR_TXERR6:   equ    %01000000
mCANTXERR_TXERR7:   equ    %10000000


;*** CANIDAR0 - MSCAN Identifier Acceptance Register 0; 0x00000150 ***
CANIDAR0:           equ    $00000150                                ;*** CANIDAR0 - MSCAN Identifier Acceptance Register 0; 0x00000150 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANIDAR0_AC0:       equ    0                                         ; Acceptance Code Bit 0
CANIDAR0_AC1:       equ    1                                         ; Acceptance Code Bit 1
CANIDAR0_AC2:       equ    2                                         ; Acceptance Code Bit 2
CANIDAR0_AC3:       equ    3                                         ; Acceptance Code Bit 3
CANIDAR0_AC4:       equ    4                                         ; Acceptance Code Bit 4
CANIDAR0_AC5:       equ    5                                         ; Acceptance Code Bit 5
CANIDAR0_AC6:       equ    6                                         ; Acceptance Code Bit 6
CANIDAR0_AC7:       equ    7                                         ; Acceptance Code Bit 7
; bit position masks
mCANIDAR0_AC0:      equ    %00000001
mCANIDAR0_AC1:      equ    %00000010
mCANIDAR0_AC2:      equ    %00000100
mCANIDAR0_AC3:      equ    %00001000
mCANIDAR0_AC4:      equ    %00010000
mCANIDAR0_AC5:      equ    %00100000
mCANIDAR0_AC6:      equ    %01000000
mCANIDAR0_AC7:      equ    %10000000


;*** CANIDAR1 - MSCAN Identifier Acceptance Register 1; 0x00000151 ***
CANIDAR1:           equ    $00000151                                ;*** CANIDAR1 - MSCAN Identifier Acceptance Register 1; 0x00000151 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANIDAR1_AC0:       equ    0                                         ; Acceptance Code Bit 0
CANIDAR1_AC1:       equ    1                                         ; Acceptance Code Bit 1
CANIDAR1_AC2:       equ    2                                         ; Acceptance Code Bit 2
CANIDAR1_AC3:       equ    3                                         ; Acceptance Code Bit 3
CANIDAR1_AC4:       equ    4                                         ; Acceptance Code Bit 4
CANIDAR1_AC5:       equ    5                                         ; Acceptance Code Bit 5
CANIDAR1_AC6:       equ    6                                         ; Acceptance Code Bit 6
CANIDAR1_AC7:       equ    7                                         ; Acceptance Code Bit 7
; bit position masks
mCANIDAR1_AC0:      equ    %00000001
mCANIDAR1_AC1:      equ    %00000010
mCANIDAR1_AC2:      equ    %00000100
mCANIDAR1_AC3:      equ    %00001000
mCANIDAR1_AC4:      equ    %00010000
mCANIDAR1_AC5:      equ    %00100000
mCANIDAR1_AC6:      equ    %01000000
mCANIDAR1_AC7:      equ    %10000000


;*** CANIDAR2 - MSCAN Identifier Acceptance Register 2; 0x00000152 ***
CANIDAR2:           equ    $00000152                                ;*** CANIDAR2 - MSCAN Identifier Acceptance Register 2; 0x00000152 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANIDAR2_AC0:       equ    0                                         ; Acceptance Code Bit 0
CANIDAR2_AC1:       equ    1                                         ; Acceptance Code Bit 1
CANIDAR2_AC2:       equ    2                                         ; Acceptance Code Bit 2
CANIDAR2_AC3:       equ    3                                         ; Acceptance Code Bit 3
CANIDAR2_AC4:       equ    4                                         ; Acceptance Code Bit 4
CANIDAR2_AC5:       equ    5                                         ; Acceptance Code Bit 5
CANIDAR2_AC6:       equ    6                                         ; Acceptance Code Bit 6
CANIDAR2_AC7:       equ    7                                         ; Acceptance Code Bit 7
; bit position masks
mCANIDAR2_AC0:      equ    %00000001
mCANIDAR2_AC1:      equ    %00000010
mCANIDAR2_AC2:      equ    %00000100
mCANIDAR2_AC3:      equ    %00001000
mCANIDAR2_AC4:      equ    %00010000
mCANIDAR2_AC5:      equ    %00100000
mCANIDAR2_AC6:      equ    %01000000
mCANIDAR2_AC7:      equ    %10000000


;*** CANIDAR3 - MSCAN Identifier Acceptance Register 3; 0x00000153 ***
CANIDAR3:           equ    $00000153                                ;*** CANIDAR3 - MSCAN Identifier Acceptance Register 3; 0x00000153 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANIDAR3_AC0:       equ    0                                         ; Acceptance Code Bit 0
CANIDAR3_AC1:       equ    1                                         ; Acceptance Code Bit 1
CANIDAR3_AC2:       equ    2                                         ; Acceptance Code Bit 2
CANIDAR3_AC3:       equ    3                                         ; Acceptance Code Bit 3
CANIDAR3_AC4:       equ    4                                         ; Acceptance Code Bit 4
CANIDAR3_AC5:       equ    5                                         ; Acceptance Code Bit 5
CANIDAR3_AC6:       equ    6                                         ; Acceptance Code Bit 6
CANIDAR3_AC7:       equ    7                                         ; Acceptance Code Bit 7
; bit position masks
mCANIDAR3_AC0:      equ    %00000001
mCANIDAR3_AC1:      equ    %00000010
mCANIDAR3_AC2:      equ    %00000100
mCANIDAR3_AC3:      equ    %00001000
mCANIDAR3_AC4:      equ    %00010000
mCANIDAR3_AC5:      equ    %00100000
mCANIDAR3_AC6:      equ    %01000000
mCANIDAR3_AC7:      equ    %10000000


;*** CANIDMR0 - MSCAN Identifier Mask Register 0; 0x00000154 ***
CANIDMR0:           equ    $00000154                                ;*** CANIDMR0 - MSCAN Identifier Mask Register 0; 0x00000154 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANIDMR0_AM0:       equ    0                                         ; Acceptance Mask Bit 0
CANIDMR0_AM1:       equ    1                                         ; Acceptance Mask Bit 1
CANIDMR0_AM2:       equ    2                                         ; Acceptance Mask Bit 2
CANIDMR0_AM3:       equ    3                                         ; Acceptance Mask Bit 3
CANIDMR0_AM4:       equ    4                                         ; Acceptance Mask Bit 4
CANIDMR0_AM5:       equ    5                                         ; Acceptance Mask Bit 5
CANIDMR0_AM6:       equ    6                                         ; Acceptance Mask Bit 6
CANIDMR0_AM7:       equ    7                                         ; Acceptance Mask Bit 7
; bit position masks
mCANIDMR0_AM0:      equ    %00000001
mCANIDMR0_AM1:      equ    %00000010
mCANIDMR0_AM2:      equ    %00000100
mCANIDMR0_AM3:      equ    %00001000
mCANIDMR0_AM4:      equ    %00010000
mCANIDMR0_AM5:      equ    %00100000
mCANIDMR0_AM6:      equ    %01000000
mCANIDMR0_AM7:      equ    %10000000


;*** CANIDMR1 - MSCAN Identifier Mask Register 1; 0x00000155 ***
CANIDMR1:           equ    $00000155                                ;*** CANIDMR1 - MSCAN Identifier Mask Register 1; 0x00000155 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANIDMR1_AM0:       equ    0                                         ; Acceptance Mask Bit 0
CANIDMR1_AM1:       equ    1                                         ; Acceptance Mask Bit 1
CANIDMR1_AM2:       equ    2                                         ; Acceptance Mask Bit 2
CANIDMR1_AM3:       equ    3                                         ; Acceptance Mask Bit 3
CANIDMR1_AM4:       equ    4                                         ; Acceptance Mask Bit 4
CANIDMR1_AM5:       equ    5                                         ; Acceptance Mask Bit 5
CANIDMR1_AM6:       equ    6                                         ; Acceptance Mask Bit 6
CANIDMR1_AM7:       equ    7                                         ; Acceptance Mask Bit 7
; bit position masks
mCANIDMR1_AM0:      equ    %00000001
mCANIDMR1_AM1:      equ    %00000010
mCANIDMR1_AM2:      equ    %00000100
mCANIDMR1_AM3:      equ    %00001000
mCANIDMR1_AM4:      equ    %00010000
mCANIDMR1_AM5:      equ    %00100000
mCANIDMR1_AM6:      equ    %01000000
mCANIDMR1_AM7:      equ    %10000000


;*** CANIDMR2 - MSCAN Identifier Mask Register 2; 0x00000156 ***
CANIDMR2:           equ    $00000156                                ;*** CANIDMR2 - MSCAN Identifier Mask Register 2; 0x00000156 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANIDMR2_AM0:       equ    0                                         ; Acceptance Mask Bit 0
CANIDMR2_AM1:       equ    1                                         ; Acceptance Mask Bit 1
CANIDMR2_AM2:       equ    2                                         ; Acceptance Mask Bit 2
CANIDMR2_AM3:       equ    3                                         ; Acceptance Mask Bit 3
CANIDMR2_AM4:       equ    4                                         ; Acceptance Mask Bit 4
CANIDMR2_AM5:       equ    5                                         ; Acceptance Mask Bit 5
CANIDMR2_AM6:       equ    6                                         ; Acceptance Mask Bit 6
CANIDMR2_AM7:       equ    7                                         ; Acceptance Mask Bit 7
; bit position masks
mCANIDMR2_AM0:      equ    %00000001
mCANIDMR2_AM1:      equ    %00000010
mCANIDMR2_AM2:      equ    %00000100
mCANIDMR2_AM3:      equ    %00001000
mCANIDMR2_AM4:      equ    %00010000
mCANIDMR2_AM5:      equ    %00100000
mCANIDMR2_AM6:      equ    %01000000
mCANIDMR2_AM7:      equ    %10000000


;*** CANIDMR3 - MSCAN Identifier Mask Register 3; 0x00000157 ***
CANIDMR3:           equ    $00000157                                ;*** CANIDMR3 - MSCAN Identifier Mask Register 3; 0x00000157 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANIDMR3_AM0:       equ    0                                         ; Acceptance Mask Bit 0
CANIDMR3_AM1:       equ    1                                         ; Acceptance Mask Bit 1
CANIDMR3_AM2:       equ    2                                         ; Acceptance Mask Bit 2
CANIDMR3_AM3:       equ    3                                         ; Acceptance Mask Bit 3
CANIDMR3_AM4:       equ    4                                         ; Acceptance Mask Bit 4
CANIDMR3_AM5:       equ    5                                         ; Acceptance Mask Bit 5
CANIDMR3_AM6:       equ    6                                         ; Acceptance Mask Bit 6
CANIDMR3_AM7:       equ    7                                         ; Acceptance Mask Bit 7
; bit position masks
mCANIDMR3_AM0:      equ    %00000001
mCANIDMR3_AM1:      equ    %00000010
mCANIDMR3_AM2:      equ    %00000100
mCANIDMR3_AM3:      equ    %00001000
mCANIDMR3_AM4:      equ    %00010000
mCANIDMR3_AM5:      equ    %00100000
mCANIDMR3_AM6:      equ    %01000000
mCANIDMR3_AM7:      equ    %10000000


;*** CANIDAR4 - MSCAN Identifier Acceptance Register 4; 0x00000158 ***
CANIDAR4:           equ    $00000158                                ;*** CANIDAR4 - MSCAN Identifier Acceptance Register 4; 0x00000158 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANIDAR4_AC0:       equ    0                                         ; Acceptance Code Bit 0
CANIDAR4_AC1:       equ    1                                         ; Acceptance Code Bit 1
CANIDAR4_AC2:       equ    2                                         ; Acceptance Code Bit 2
CANIDAR4_AC3:       equ    3                                         ; Acceptance Code Bit 3
CANIDAR4_AC4:       equ    4                                         ; Acceptance Code Bit 4
CANIDAR4_AC5:       equ    5                                         ; Acceptance Code Bit 5
CANIDAR4_AC6:       equ    6                                         ; Acceptance Code Bit 6
CANIDAR4_AC7:       equ    7                                         ; Acceptance Code Bit 7
; bit position masks
mCANIDAR4_AC0:      equ    %00000001
mCANIDAR4_AC1:      equ    %00000010
mCANIDAR4_AC2:      equ    %00000100
mCANIDAR4_AC3:      equ    %00001000
mCANIDAR4_AC4:      equ    %00010000
mCANIDAR4_AC5:      equ    %00100000
mCANIDAR4_AC6:      equ    %01000000
mCANIDAR4_AC7:      equ    %10000000


;*** CANIDAR5 - MSCAN Identifier Acceptance Register 5; 0x00000159 ***
CANIDAR5:           equ    $00000159                                ;*** CANIDAR5 - MSCAN Identifier Acceptance Register 5; 0x00000159 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANIDAR5_AC0:       equ    0                                         ; Acceptance Code Bit 0
CANIDAR5_AC1:       equ    1                                         ; Acceptance Code Bit 1
CANIDAR5_AC2:       equ    2                                         ; Acceptance Code Bit 2
CANIDAR5_AC3:       equ    3                                         ; Acceptance Code Bit 3
CANIDAR5_AC4:       equ    4                                         ; Acceptance Code Bit 4
CANIDAR5_AC5:       equ    5                                         ; Acceptance Code Bit 5
CANIDAR5_AC6:       equ    6                                         ; Acceptance Code Bit 6
CANIDAR5_AC7:       equ    7                                         ; Acceptance Code Bit 7
; bit position masks
mCANIDAR5_AC0:      equ    %00000001
mCANIDAR5_AC1:      equ    %00000010
mCANIDAR5_AC2:      equ    %00000100
mCANIDAR5_AC3:      equ    %00001000
mCANIDAR5_AC4:      equ    %00010000
mCANIDAR5_AC5:      equ    %00100000
mCANIDAR5_AC6:      equ    %01000000
mCANIDAR5_AC7:      equ    %10000000


;*** CANIDAR6 - MSCAN Identifier Acceptance Register 6; 0x0000015A ***
CANIDAR6:           equ    $0000015A                                ;*** CANIDAR6 - MSCAN Identifier Acceptance Register 6; 0x0000015A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANIDAR6_AC0:       equ    0                                         ; Acceptance Code Bit 0
CANIDAR6_AC1:       equ    1                                         ; Acceptance Code Bit 1
CANIDAR6_AC2:       equ    2                                         ; Acceptance Code Bit 2
CANIDAR6_AC3:       equ    3                                         ; Acceptance Code Bit 3
CANIDAR6_AC4:       equ    4                                         ; Acceptance Code Bit 4
CANIDAR6_AC5:       equ    5                                         ; Acceptance Code Bit 5
CANIDAR6_AC6:       equ    6                                         ; Acceptance Code Bit 6
CANIDAR6_AC7:       equ    7                                         ; Acceptance Code Bit 7
; bit position masks
mCANIDAR6_AC0:      equ    %00000001
mCANIDAR6_AC1:      equ    %00000010
mCANIDAR6_AC2:      equ    %00000100
mCANIDAR6_AC3:      equ    %00001000
mCANIDAR6_AC4:      equ    %00010000
mCANIDAR6_AC5:      equ    %00100000
mCANIDAR6_AC6:      equ    %01000000
mCANIDAR6_AC7:      equ    %10000000


;*** CANIDAR7 - MSCAN Identifier Acceptance Register 7; 0x0000015B ***
CANIDAR7:           equ    $0000015B                                ;*** CANIDAR7 - MSCAN Identifier Acceptance Register 7; 0x0000015B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANIDAR7_AC0:       equ    0                                         ; Acceptance Code Bit 0
CANIDAR7_AC1:       equ    1                                         ; Acceptance Code Bit 1
CANIDAR7_AC2:       equ    2                                         ; Acceptance Code Bit 2
CANIDAR7_AC3:       equ    3                                         ; Acceptance Code Bit 3
CANIDAR7_AC4:       equ    4                                         ; Acceptance Code Bit 4
CANIDAR7_AC5:       equ    5                                         ; Acceptance Code Bit 5
CANIDAR7_AC6:       equ    6                                         ; Acceptance Code Bit 6
CANIDAR7_AC7:       equ    7                                         ; Acceptance Code Bit 7
; bit position masks
mCANIDAR7_AC0:      equ    %00000001
mCANIDAR7_AC1:      equ    %00000010
mCANIDAR7_AC2:      equ    %00000100
mCANIDAR7_AC3:      equ    %00001000
mCANIDAR7_AC4:      equ    %00010000
mCANIDAR7_AC5:      equ    %00100000
mCANIDAR7_AC6:      equ    %01000000
mCANIDAR7_AC7:      equ    %10000000


;*** CANIDMR4 - MSCAN Identifier Mask Register 4; 0x0000015C ***
CANIDMR4:           equ    $0000015C                                ;*** CANIDMR4 - MSCAN Identifier Mask Register 4; 0x0000015C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANIDMR4_AM0:       equ    0                                         ; Acceptance Mask Bit 0
CANIDMR4_AM1:       equ    1                                         ; Acceptance Mask Bit 1
CANIDMR4_AM2:       equ    2                                         ; Acceptance Mask Bit 2
CANIDMR4_AM3:       equ    3                                         ; Acceptance Mask Bit 3
CANIDMR4_AM4:       equ    4                                         ; Acceptance Mask Bit 4
CANIDMR4_AM5:       equ    5                                         ; Acceptance Mask Bit 5
CANIDMR4_AM6:       equ    6                                         ; Acceptance Mask Bit 6
CANIDMR4_AM7:       equ    7                                         ; Acceptance Mask Bit 7
; bit position masks
mCANIDMR4_AM0:      equ    %00000001
mCANIDMR4_AM1:      equ    %00000010
mCANIDMR4_AM2:      equ    %00000100
mCANIDMR4_AM3:      equ    %00001000
mCANIDMR4_AM4:      equ    %00010000
mCANIDMR4_AM5:      equ    %00100000
mCANIDMR4_AM6:      equ    %01000000
mCANIDMR4_AM7:      equ    %10000000


;*** CANIDMR5 - MSCAN Identifier Mask Register 5; 0x0000015D ***
CANIDMR5:           equ    $0000015D                                ;*** CANIDMR5 - MSCAN Identifier Mask Register 5; 0x0000015D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANIDMR5_AM0:       equ    0                                         ; Acceptance Mask Bit 0
CANIDMR5_AM1:       equ    1                                         ; Acceptance Mask Bit 1
CANIDMR5_AM2:       equ    2                                         ; Acceptance Mask Bit 2
CANIDMR5_AM3:       equ    3                                         ; Acceptance Mask Bit 3
CANIDMR5_AM4:       equ    4                                         ; Acceptance Mask Bit 4
CANIDMR5_AM5:       equ    5                                         ; Acceptance Mask Bit 5
CANIDMR5_AM6:       equ    6                                         ; Acceptance Mask Bit 6
CANIDMR5_AM7:       equ    7                                         ; Acceptance Mask Bit 7
; bit position masks
mCANIDMR5_AM0:      equ    %00000001
mCANIDMR5_AM1:      equ    %00000010
mCANIDMR5_AM2:      equ    %00000100
mCANIDMR5_AM3:      equ    %00001000
mCANIDMR5_AM4:      equ    %00010000
mCANIDMR5_AM5:      equ    %00100000
mCANIDMR5_AM6:      equ    %01000000
mCANIDMR5_AM7:      equ    %10000000


;*** CANIDMR6 - MSCAN Identifier Mask Register 6; 0x0000015E ***
CANIDMR6:           equ    $0000015E                                ;*** CANIDMR6 - MSCAN Identifier Mask Register 6; 0x0000015E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANIDMR6_AM0:       equ    0                                         ; Acceptance Mask Bit 0
CANIDMR6_AM1:       equ    1                                         ; Acceptance Mask Bit 1
CANIDMR6_AM2:       equ    2                                         ; Acceptance Mask Bit 2
CANIDMR6_AM3:       equ    3                                         ; Acceptance Mask Bit 3
CANIDMR6_AM4:       equ    4                                         ; Acceptance Mask Bit 4
CANIDMR6_AM5:       equ    5                                         ; Acceptance Mask Bit 5
CANIDMR6_AM6:       equ    6                                         ; Acceptance Mask Bit 6
CANIDMR6_AM7:       equ    7                                         ; Acceptance Mask Bit 7
; bit position masks
mCANIDMR6_AM0:      equ    %00000001
mCANIDMR6_AM1:      equ    %00000010
mCANIDMR6_AM2:      equ    %00000100
mCANIDMR6_AM3:      equ    %00001000
mCANIDMR6_AM4:      equ    %00010000
mCANIDMR6_AM5:      equ    %00100000
mCANIDMR6_AM6:      equ    %01000000
mCANIDMR6_AM7:      equ    %10000000


;*** CANIDMR7 - MSCAN Identifier Mask Register 7; 0x0000015F ***
CANIDMR7:           equ    $0000015F                                ;*** CANIDMR7 - MSCAN Identifier Mask Register 7; 0x0000015F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANIDMR7_AM0:       equ    0                                         ; Acceptance Mask Bit 0
CANIDMR7_AM1:       equ    1                                         ; Acceptance Mask Bit 1
CANIDMR7_AM2:       equ    2                                         ; Acceptance Mask Bit 2
CANIDMR7_AM3:       equ    3                                         ; Acceptance Mask Bit 3
CANIDMR7_AM4:       equ    4                                         ; Acceptance Mask Bit 4
CANIDMR7_AM5:       equ    5                                         ; Acceptance Mask Bit 5
CANIDMR7_AM6:       equ    6                                         ; Acceptance Mask Bit 6
CANIDMR7_AM7:       equ    7                                         ; Acceptance Mask Bit 7
; bit position masks
mCANIDMR7_AM0:      equ    %00000001
mCANIDMR7_AM1:      equ    %00000010
mCANIDMR7_AM2:      equ    %00000100
mCANIDMR7_AM3:      equ    %00001000
mCANIDMR7_AM4:      equ    %00010000
mCANIDMR7_AM5:      equ    %00100000
mCANIDMR7_AM6:      equ    %01000000
mCANIDMR7_AM7:      equ    %10000000


;*** CANRXIDR0 - MSCAN Receive Identifier Register 0; 0x00000160 ***
CANRXIDR0:          equ    $00000160                                ;*** CANRXIDR0 - MSCAN Receive Identifier Register 0; 0x00000160 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANRXIDR0_ID21:     equ    0                                         ; Extended format identifier Bit 21
CANRXIDR0_ID22:     equ    1                                         ; Extended format identifier Bit 22
CANRXIDR0_ID23:     equ    2                                         ; Extended format identifier Bit 23
CANRXIDR0_ID24:     equ    3                                         ; Extended format identifier Bit 24
CANRXIDR0_ID25:     equ    4                                         ; Extended format identifier Bit 25
CANRXIDR0_ID26:     equ    5                                         ; Extended format identifier Bit 26
CANRXIDR0_ID27:     equ    6                                         ; Extended format identifier Bit 27
CANRXIDR0_ID28:     equ    7                                         ; Extended format identifier Bit 28
; bit position masks
mCANRXIDR0_ID21:    equ    %00000001
mCANRXIDR0_ID22:    equ    %00000010
mCANRXIDR0_ID23:    equ    %00000100
mCANRXIDR0_ID24:    equ    %00001000
mCANRXIDR0_ID25:    equ    %00010000
mCANRXIDR0_ID26:    equ    %00100000
mCANRXIDR0_ID27:    equ    %01000000
mCANRXIDR0_ID28:    equ    %10000000


;*** CANRXIDR1 - MSCAN Receive Identifier Register 1; 0x00000161 ***
CANRXIDR1:          equ    $00000161                                ;*** CANRXIDR1 - MSCAN Receive Identifier Register 1; 0x00000161 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANRXIDR1_ID15:     equ    0                                         ; Extended format identifier Bit 15
CANRXIDR1_ID16:     equ    1                                         ; Extended format identifier Bit 16
CANRXIDR1_ID17:     equ    2                                         ; Extended format identifier Bit 17
CANRXIDR1_IDE:      equ    3                                         ; ID Extended
CANRXIDR1_SRR:      equ    4                                         ; Substitute Remote Request
CANRXIDR1_ID18:     equ    5                                         ; Extended format identifier Bit 18
CANRXIDR1_ID19:     equ    6                                         ; Extended format identifier Bit 19
CANRXIDR1_ID20:     equ    7                                         ; Extended format identifier Bit 20
; bit position masks
mCANRXIDR1_ID15:    equ    %00000001
mCANRXIDR1_ID16:    equ    %00000010
mCANRXIDR1_ID17:    equ    %00000100
mCANRXIDR1_IDE:     equ    %00001000
mCANRXIDR1_SRR:     equ    %00010000
mCANRXIDR1_ID18:    equ    %00100000
mCANRXIDR1_ID19:    equ    %01000000
mCANRXIDR1_ID20:    equ    %10000000


;*** CANRXIDR2 - MSCAN Receive Identifier Register 2; 0x00000162 ***
CANRXIDR2:          equ    $00000162                                ;*** CANRXIDR2 - MSCAN Receive Identifier Register 2; 0x00000162 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANRXIDR2_ID7:      equ    0                                         ; Extended format identifier Bit 7
CANRXIDR2_ID8:      equ    1                                         ; Extended format identifier Bit 8
CANRXIDR2_ID9:      equ    2                                         ; Extended format identifier Bit 9
CANRXIDR2_ID10:     equ    3                                         ; Extended format identifier Bit 10
CANRXIDR2_ID11:     equ    4                                         ; Extended format identifier Bit 11
CANRXIDR2_ID12:     equ    5                                         ; Extended format identifier Bit 12
CANRXIDR2_ID13:     equ    6                                         ; Extended format identifier Bit 13
CANRXIDR2_ID14:     equ    7                                         ; Extended format identifier Bit 14
; bit position masks
mCANRXIDR2_ID7:     equ    %00000001
mCANRXIDR2_ID8:     equ    %00000010
mCANRXIDR2_ID9:     equ    %00000100
mCANRXIDR2_ID10:    equ    %00001000
mCANRXIDR2_ID11:    equ    %00010000
mCANRXIDR2_ID12:    equ    %00100000
mCANRXIDR2_ID13:    equ    %01000000
mCANRXIDR2_ID14:    equ    %10000000


;*** CANRXIDR3 - MSCAN Receive Identifier Register 3; 0x00000163 ***
CANRXIDR3:          equ    $00000163                                ;*** CANRXIDR3 - MSCAN Receive Identifier Register 3; 0x00000163 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANRXIDR3_RTR:      equ    0                                         ; Remote Transmission Request
CANRXIDR3_ID0:      equ    1                                         ; Extended format identifier Bit 0
CANRXIDR3_ID1:      equ    2                                         ; Extended format identifier Bit 1
CANRXIDR3_ID2:      equ    3                                         ; Extended format identifier Bit 2
CANRXIDR3_ID3:      equ    4                                         ; Extended format identifier Bit 3
CANRXIDR3_ID4:      equ    5                                         ; Extended format identifier Bit 4
CANRXIDR3_ID5:      equ    6                                         ; Extended format identifier Bit 5
CANRXIDR3_ID6:      equ    7                                         ; Extended format identifier Bit 6
; bit position masks
mCANRXIDR3_RTR:     equ    %00000001
mCANRXIDR3_ID0:     equ    %00000010
mCANRXIDR3_ID1:     equ    %00000100
mCANRXIDR3_ID2:     equ    %00001000
mCANRXIDR3_ID3:     equ    %00010000
mCANRXIDR3_ID4:     equ    %00100000
mCANRXIDR3_ID5:     equ    %01000000
mCANRXIDR3_ID6:     equ    %10000000


;*** CANRXDSR0 - MSCAN Receive Data Segment Register 0; 0x00000164 ***
CANRXDSR0:          equ    $00000164                                ;*** CANRXDSR0 - MSCAN Receive Data Segment Register 0; 0x00000164 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANRXDSR0_DB0:      equ    0                                         ; Data Bit 0
CANRXDSR0_DB1:      equ    1                                         ; Data Bit 1
CANRXDSR0_DB2:      equ    2                                         ; Data Bit 2
CANRXDSR0_DB3:      equ    3                                         ; Data Bit 3
CANRXDSR0_DB4:      equ    4                                         ; Data Bit 4
CANRXDSR0_DB5:      equ    5                                         ; Data Bit 5
CANRXDSR0_DB6:      equ    6                                         ; Data Bit 6
CANRXDSR0_DB7:      equ    7                                         ; Data Bit 7
; bit position masks
mCANRXDSR0_DB0:     equ    %00000001
mCANRXDSR0_DB1:     equ    %00000010
mCANRXDSR0_DB2:     equ    %00000100
mCANRXDSR0_DB3:     equ    %00001000
mCANRXDSR0_DB4:     equ    %00010000
mCANRXDSR0_DB5:     equ    %00100000
mCANRXDSR0_DB6:     equ    %01000000
mCANRXDSR0_DB7:     equ    %10000000


;*** CANRXDSR1 - MSCAN Receive Data Segment Register 1; 0x00000165 ***
CANRXDSR1:          equ    $00000165                                ;*** CANRXDSR1 - MSCAN Receive Data Segment Register 1; 0x00000165 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANRXDSR1_DB0:      equ    0                                         ; Data Bit 0
CANRXDSR1_DB1:      equ    1                                         ; Data Bit 1
CANRXDSR1_DB2:      equ    2                                         ; Data Bit 2
CANRXDSR1_DB3:      equ    3                                         ; Data Bit 3
CANRXDSR1_DB4:      equ    4                                         ; Data Bit 4
CANRXDSR1_DB5:      equ    5                                         ; Data Bit 5
CANRXDSR1_DB6:      equ    6                                         ; Data Bit 6
CANRXDSR1_DB7:      equ    7                                         ; Data Bit 7
; bit position masks
mCANRXDSR1_DB0:     equ    %00000001
mCANRXDSR1_DB1:     equ    %00000010
mCANRXDSR1_DB2:     equ    %00000100
mCANRXDSR1_DB3:     equ    %00001000
mCANRXDSR1_DB4:     equ    %00010000
mCANRXDSR1_DB5:     equ    %00100000
mCANRXDSR1_DB6:     equ    %01000000
mCANRXDSR1_DB7:     equ    %10000000


;*** CANRXDSR2 - MSCAN Receive Data Segment Register 2; 0x00000166 ***
CANRXDSR2:          equ    $00000166                                ;*** CANRXDSR2 - MSCAN Receive Data Segment Register 2; 0x00000166 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANRXDSR2_DB0:      equ    0                                         ; Data Bit 0
CANRXDSR2_DB1:      equ    1                                         ; Data Bit 1
CANRXDSR2_DB2:      equ    2                                         ; Data Bit 2
CANRXDSR2_DB3:      equ    3                                         ; Data Bit 3
CANRXDSR2_DB4:      equ    4                                         ; Data Bit 4
CANRXDSR2_DB5:      equ    5                                         ; Data Bit 5
CANRXDSR2_DB6:      equ    6                                         ; Data Bit 6
CANRXDSR2_DB7:      equ    7                                         ; Data Bit 7
; bit position masks
mCANRXDSR2_DB0:     equ    %00000001
mCANRXDSR2_DB1:     equ    %00000010
mCANRXDSR2_DB2:     equ    %00000100
mCANRXDSR2_DB3:     equ    %00001000
mCANRXDSR2_DB4:     equ    %00010000
mCANRXDSR2_DB5:     equ    %00100000
mCANRXDSR2_DB6:     equ    %01000000
mCANRXDSR2_DB7:     equ    %10000000


;*** CANRXDSR3 - MSCAN Receive Data Segment Register 3; 0x00000167 ***
CANRXDSR3:          equ    $00000167                                ;*** CANRXDSR3 - MSCAN Receive Data Segment Register 3; 0x00000167 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANRXDSR3_DB0:      equ    0                                         ; Data Bit 0
CANRXDSR3_DB1:      equ    1                                         ; Data Bit 1
CANRXDSR3_DB2:      equ    2                                         ; Data Bit 2
CANRXDSR3_DB3:      equ    3                                         ; Data Bit 3
CANRXDSR3_DB4:      equ    4                                         ; Data Bit 4
CANRXDSR3_DB5:      equ    5                                         ; Data Bit 5
CANRXDSR3_DB6:      equ    6                                         ; Data Bit 6
CANRXDSR3_DB7:      equ    7                                         ; Data Bit 7
; bit position masks
mCANRXDSR3_DB0:     equ    %00000001
mCANRXDSR3_DB1:     equ    %00000010
mCANRXDSR3_DB2:     equ    %00000100
mCANRXDSR3_DB3:     equ    %00001000
mCANRXDSR3_DB4:     equ    %00010000
mCANRXDSR3_DB5:     equ    %00100000
mCANRXDSR3_DB6:     equ    %01000000
mCANRXDSR3_DB7:     equ    %10000000


;*** CANRXDSR4 - MSCAN Receive Data Segment Register 4; 0x00000168 ***
CANRXDSR4:          equ    $00000168                                ;*** CANRXDSR4 - MSCAN Receive Data Segment Register 4; 0x00000168 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANRXDSR4_DB0:      equ    0                                         ; Data Bit 0
CANRXDSR4_DB1:      equ    1                                         ; Data Bit 1
CANRXDSR4_DB2:      equ    2                                         ; Data Bit 2
CANRXDSR4_DB3:      equ    3                                         ; Data Bit 3
CANRXDSR4_DB4:      equ    4                                         ; Data Bit 4
CANRXDSR4_DB5:      equ    5                                         ; Data Bit 5
CANRXDSR4_DB6:      equ    6                                         ; Data Bit 6
CANRXDSR4_DB7:      equ    7                                         ; Data Bit 7
; bit position masks
mCANRXDSR4_DB0:     equ    %00000001
mCANRXDSR4_DB1:     equ    %00000010
mCANRXDSR4_DB2:     equ    %00000100
mCANRXDSR4_DB3:     equ    %00001000
mCANRXDSR4_DB4:     equ    %00010000
mCANRXDSR4_DB5:     equ    %00100000
mCANRXDSR4_DB6:     equ    %01000000
mCANRXDSR4_DB7:     equ    %10000000


;*** CANRXDSR5 - MSCAN Receive Data Segment Register 5; 0x00000169 ***
CANRXDSR5:          equ    $00000169                                ;*** CANRXDSR5 - MSCAN Receive Data Segment Register 5; 0x00000169 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANRXDSR5_DB0:      equ    0                                         ; Data Bit 0
CANRXDSR5_DB1:      equ    1                                         ; Data Bit 1
CANRXDSR5_DB2:      equ    2                                         ; Data Bit 2
CANRXDSR5_DB3:      equ    3                                         ; Data Bit 3
CANRXDSR5_DB4:      equ    4                                         ; Data Bit 4
CANRXDSR5_DB5:      equ    5                                         ; Data Bit 5
CANRXDSR5_DB6:      equ    6                                         ; Data Bit 6
CANRXDSR5_DB7:      equ    7                                         ; Data Bit 7
; bit position masks
mCANRXDSR5_DB0:     equ    %00000001
mCANRXDSR5_DB1:     equ    %00000010
mCANRXDSR5_DB2:     equ    %00000100
mCANRXDSR5_DB3:     equ    %00001000
mCANRXDSR5_DB4:     equ    %00010000
mCANRXDSR5_DB5:     equ    %00100000
mCANRXDSR5_DB6:     equ    %01000000
mCANRXDSR5_DB7:     equ    %10000000


;*** CANRXDSR6 - MSCAN Receive Data Segment Register 6; 0x0000016A ***
CANRXDSR6:          equ    $0000016A                                ;*** CANRXDSR6 - MSCAN Receive Data Segment Register 6; 0x0000016A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANRXDSR6_DB0:      equ    0                                         ; Data Bit 0
CANRXDSR6_DB1:      equ    1                                         ; Data Bit 1
CANRXDSR6_DB2:      equ    2                                         ; Data Bit 2
CANRXDSR6_DB3:      equ    3                                         ; Data Bit 3
CANRXDSR6_DB4:      equ    4                                         ; Data Bit 4
CANRXDSR6_DB5:      equ    5                                         ; Data Bit 5
CANRXDSR6_DB6:      equ    6                                         ; Data Bit 6
CANRXDSR6_DB7:      equ    7                                         ; Data Bit 7
; bit position masks
mCANRXDSR6_DB0:     equ    %00000001
mCANRXDSR6_DB1:     equ    %00000010
mCANRXDSR6_DB2:     equ    %00000100
mCANRXDSR6_DB3:     equ    %00001000
mCANRXDSR6_DB4:     equ    %00010000
mCANRXDSR6_DB5:     equ    %00100000
mCANRXDSR6_DB6:     equ    %01000000
mCANRXDSR6_DB7:     equ    %10000000


;*** CANRXDSR7 - MSCAN Receive Data Segment Register 7; 0x0000016B ***
CANRXDSR7:          equ    $0000016B                                ;*** CANRXDSR7 - MSCAN Receive Data Segment Register 7; 0x0000016B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANRXDSR7_DB0:      equ    0                                         ; Data Bit 0
CANRXDSR7_DB1:      equ    1                                         ; Data Bit 1
CANRXDSR7_DB2:      equ    2                                         ; Data Bit 2
CANRXDSR7_DB3:      equ    3                                         ; Data Bit 3
CANRXDSR7_DB4:      equ    4                                         ; Data Bit 4
CANRXDSR7_DB5:      equ    5                                         ; Data Bit 5
CANRXDSR7_DB6:      equ    6                                         ; Data Bit 6
CANRXDSR7_DB7:      equ    7                                         ; Data Bit 7
; bit position masks
mCANRXDSR7_DB0:     equ    %00000001
mCANRXDSR7_DB1:     equ    %00000010
mCANRXDSR7_DB2:     equ    %00000100
mCANRXDSR7_DB3:     equ    %00001000
mCANRXDSR7_DB4:     equ    %00010000
mCANRXDSR7_DB5:     equ    %00100000
mCANRXDSR7_DB6:     equ    %01000000
mCANRXDSR7_DB7:     equ    %10000000


;*** CANRXDLR - MSCAN Receive Data Length Register; 0x0000016C ***
CANRXDLR:           equ    $0000016C                                ;*** CANRXDLR - MSCAN Receive Data Length Register; 0x0000016C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANRXDLR_DLC0:      equ    0                                         ; Data Length Code Bit 0
CANRXDLR_DLC1:      equ    1                                         ; Data Length Code Bit 1
CANRXDLR_DLC2:      equ    2                                         ; Data Length Code Bit 2
CANRXDLR_DLC3:      equ    3                                         ; Data Length Code Bit 3
; bit position masks
mCANRXDLR_DLC0:     equ    %00000001
mCANRXDLR_DLC1:     equ    %00000010
mCANRXDLR_DLC2:     equ    %00000100
mCANRXDLR_DLC3:     equ    %00001000


;*** CANRXTSR - MSCAN Receive Time Stamp Register; 0x0000016E ***
CANRXTSR:           equ    $0000016E                                ;*** CANRXTSR - MSCAN Receive Time Stamp Register; 0x0000016E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANRXTSR_TSR0:      equ    0                                         ; Time Stamp Bit 0
CANRXTSR_TSR1:      equ    1                                         ; Time Stamp Bit 1
CANRXTSR_TSR2:      equ    2                                         ; Time Stamp Bit 2
CANRXTSR_TSR3:      equ    3                                         ; Time Stamp Bit 3
CANRXTSR_TSR4:      equ    4                                         ; Time Stamp Bit 4
CANRXTSR_TSR5:      equ    5                                         ; Time Stamp Bit 5
CANRXTSR_TSR6:      equ    6                                         ; Time Stamp Bit 6
CANRXTSR_TSR7:      equ    7                                         ; Time Stamp Bit 7
CANRXTSR_TSR8:      equ    8                                         ; Time Stamp Bit 8
CANRXTSR_TSR9:      equ    9                                         ; Time Stamp Bit 9
CANRXTSR_TSR10:     equ    10                                        ; Time Stamp Bit 10
CANRXTSR_TSR11:     equ    11                                        ; Time Stamp Bit 11
CANRXTSR_TSR12:     equ    12                                        ; Time Stamp Bit 12
CANRXTSR_TSR13:     equ    13                                        ; Time Stamp Bit 13
CANRXTSR_TSR14:     equ    14                                        ; Time Stamp Bit 14
CANRXTSR_TSR15:     equ    15                                        ; Time Stamp Bit 15
; bit position masks
mCANRXTSR_TSR0:     equ    %00000001
mCANRXTSR_TSR1:     equ    %00000010
mCANRXTSR_TSR2:     equ    %00000100
mCANRXTSR_TSR3:     equ    %00001000
mCANRXTSR_TSR4:     equ    %00010000
mCANRXTSR_TSR5:     equ    %00100000
mCANRXTSR_TSR6:     equ    %01000000
mCANRXTSR_TSR7:     equ    %10000000
mCANRXTSR_TSR8:     equ    %100000000
mCANRXTSR_TSR9:     equ    %1000000000
mCANRXTSR_TSR10:    equ    %10000000000
mCANRXTSR_TSR11:    equ    %100000000000
mCANRXTSR_TSR12:    equ    %1000000000000
mCANRXTSR_TSR13:    equ    %10000000000000
mCANRXTSR_TSR14:    equ    %100000000000000
mCANRXTSR_TSR15:    equ    %1000000000000000


;*** CANRXTSRH - MSCAN Receive Time Stamp Register High; 0x0000016E ***
CANRXTSRH:          equ    $0000016E                                ;*** CANRXTSRH - MSCAN Receive Time Stamp Register High; 0x0000016E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANRXTSRH_TSR8:     equ    0                                         ; Time Stamp Bit 8
CANRXTSRH_TSR9:     equ    1                                         ; Time Stamp Bit 9
CANRXTSRH_TSR10:    equ    2                                         ; Time Stamp Bit 10
CANRXTSRH_TSR11:    equ    3                                         ; Time Stamp Bit 11
CANRXTSRH_TSR12:    equ    4                                         ; Time Stamp Bit 12
CANRXTSRH_TSR13:    equ    5                                         ; Time Stamp Bit 13
CANRXTSRH_TSR14:    equ    6                                         ; Time Stamp Bit 14
CANRXTSRH_TSR15:    equ    7                                         ; Time Stamp Bit 15
; bit position masks
mCANRXTSRH_TSR8:    equ    %00000001
mCANRXTSRH_TSR9:    equ    %00000010
mCANRXTSRH_TSR10:   equ    %00000100
mCANRXTSRH_TSR11:   equ    %00001000
mCANRXTSRH_TSR12:   equ    %00010000
mCANRXTSRH_TSR13:   equ    %00100000
mCANRXTSRH_TSR14:   equ    %01000000
mCANRXTSRH_TSR15:   equ    %10000000


;*** CANRXTSRL - MSCAN Receive Time Stamp Register Low; 0x0000016F ***
CANRXTSRL:          equ    $0000016F                                ;*** CANRXTSRL - MSCAN Receive Time Stamp Register Low; 0x0000016F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANRXTSRL_TSR0:     equ    0                                         ; Time Stamp Bit 0
CANRXTSRL_TSR1:     equ    1                                         ; Time Stamp Bit 1
CANRXTSRL_TSR2:     equ    2                                         ; Time Stamp Bit 2
CANRXTSRL_TSR3:     equ    3                                         ; Time Stamp Bit 3
CANRXTSRL_TSR4:     equ    4                                         ; Time Stamp Bit 4
CANRXTSRL_TSR5:     equ    5                                         ; Time Stamp Bit 5
CANRXTSRL_TSR6:     equ    6                                         ; Time Stamp Bit 6
CANRXTSRL_TSR7:     equ    7                                         ; Time Stamp Bit 7
; bit position masks
mCANRXTSRL_TSR0:    equ    %00000001
mCANRXTSRL_TSR1:    equ    %00000010
mCANRXTSRL_TSR2:    equ    %00000100
mCANRXTSRL_TSR3:    equ    %00001000
mCANRXTSRL_TSR4:    equ    %00010000
mCANRXTSRL_TSR5:    equ    %00100000
mCANRXTSRL_TSR6:    equ    %01000000
mCANRXTSRL_TSR7:    equ    %10000000


;*** CANTXIDR0 - MSCAN Transmit Identifier Register 0; 0x00000170 ***
CANTXIDR0:          equ    $00000170                                ;*** CANTXIDR0 - MSCAN Transmit Identifier Register 0; 0x00000170 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANTXIDR0_ID21:     equ    0                                         ; Extended format identifier Bit 21
CANTXIDR0_ID22:     equ    1                                         ; Extended format identifier Bit 22
CANTXIDR0_ID23:     equ    2                                         ; Extended format identifier Bit 23
CANTXIDR0_ID24:     equ    3                                         ; Extended format identifier Bit 24
CANTXIDR0_ID25:     equ    4                                         ; Extended format identifier Bit 25
CANTXIDR0_ID26:     equ    5                                         ; Extended format identifier Bit 26
CANTXIDR0_ID27:     equ    6                                         ; Extended format identifier Bit 27
CANTXIDR0_ID28:     equ    7                                         ; Extended format identifier Bit 28
; bit position masks
mCANTXIDR0_ID21:    equ    %00000001
mCANTXIDR0_ID22:    equ    %00000010
mCANTXIDR0_ID23:    equ    %00000100
mCANTXIDR0_ID24:    equ    %00001000
mCANTXIDR0_ID25:    equ    %00010000
mCANTXIDR0_ID26:    equ    %00100000
mCANTXIDR0_ID27:    equ    %01000000
mCANTXIDR0_ID28:    equ    %10000000


;*** CANTXIDR1 - MSCAN Transmit Identifier Register 1; 0x00000171 ***
CANTXIDR1:          equ    $00000171                                ;*** CANTXIDR1 - MSCAN Transmit Identifier Register 1; 0x00000171 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANTXIDR1_ID15:     equ    0                                         ; Extended format identifier Bit 15
CANTXIDR1_ID16:     equ    1                                         ; Extended format identifier Bit 16
CANTXIDR1_ID17:     equ    2                                         ; Extended format identifier Bit 17
CANTXIDR1_IDE:      equ    3                                         ; ID Extended
CANTXIDR1_SRR:      equ    4                                         ; Substitute Remote Request
CANTXIDR1_ID18:     equ    5                                         ; Extended format identifier Bit 18
CANTXIDR1_ID19:     equ    6                                         ; Extended format identifier Bit 19
CANTXIDR1_ID20:     equ    7                                         ; Extended format identifier Bit 20
; bit position masks
mCANTXIDR1_ID15:    equ    %00000001
mCANTXIDR1_ID16:    equ    %00000010
mCANTXIDR1_ID17:    equ    %00000100
mCANTXIDR1_IDE:     equ    %00001000
mCANTXIDR1_SRR:     equ    %00010000
mCANTXIDR1_ID18:    equ    %00100000
mCANTXIDR1_ID19:    equ    %01000000
mCANTXIDR1_ID20:    equ    %10000000


;*** CANTXIDR2 - MSCAN Transmit Identifier Register 2; 0x00000172 ***
CANTXIDR2:          equ    $00000172                                ;*** CANTXIDR2 - MSCAN Transmit Identifier Register 2; 0x00000172 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANTXIDR2_ID7:      equ    0                                         ; Extended format identifier Bit 7
CANTXIDR2_ID8:      equ    1                                         ; Extended format identifier Bit 8
CANTXIDR2_ID9:      equ    2                                         ; Extended format identifier Bit 9
CANTXIDR2_ID10:     equ    3                                         ; Extended format identifier Bit 10
CANTXIDR2_ID11:     equ    4                                         ; Extended format identifier Bit 11
CANTXIDR2_ID12:     equ    5                                         ; Extended format identifier Bit 12
CANTXIDR2_ID13:     equ    6                                         ; Extended format identifier Bit 13
CANTXIDR2_ID14:     equ    7                                         ; Extended format identifier Bit 14
; bit position masks
mCANTXIDR2_ID7:     equ    %00000001
mCANTXIDR2_ID8:     equ    %00000010
mCANTXIDR2_ID9:     equ    %00000100
mCANTXIDR2_ID10:    equ    %00001000
mCANTXIDR2_ID11:    equ    %00010000
mCANTXIDR2_ID12:    equ    %00100000
mCANTXIDR2_ID13:    equ    %01000000
mCANTXIDR2_ID14:    equ    %10000000


;*** CANTXIDR3 - MSCAN Transmit Identifier Register 3; 0x00000173 ***
CANTXIDR3:          equ    $00000173                                ;*** CANTXIDR3 - MSCAN Transmit Identifier Register 3; 0x00000173 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANTXIDR3_RTR:      equ    0                                         ; Remote Transmission Request
CANTXIDR3_ID0:      equ    1                                         ; Extended format identifier Bit 0
CANTXIDR3_ID1:      equ    2                                         ; Extended format identifier Bit 1
CANTXIDR3_ID2:      equ    3                                         ; Extended format identifier Bit 2
CANTXIDR3_ID3:      equ    4                                         ; Extended format identifier Bit 3
CANTXIDR3_ID4:      equ    5                                         ; Extended format identifier Bit 4
CANTXIDR3_ID5:      equ    6                                         ; Extended format identifier Bit 5
CANTXIDR3_ID6:      equ    7                                         ; Extended format identifier Bit 6
; bit position masks
mCANTXIDR3_RTR:     equ    %00000001
mCANTXIDR3_ID0:     equ    %00000010
mCANTXIDR3_ID1:     equ    %00000100
mCANTXIDR3_ID2:     equ    %00001000
mCANTXIDR3_ID3:     equ    %00010000
mCANTXIDR3_ID4:     equ    %00100000
mCANTXIDR3_ID5:     equ    %01000000
mCANTXIDR3_ID6:     equ    %10000000


;*** CANTXDSR0 - MSCAN Transmit Data Segment Register 0; 0x00000174 ***
CANTXDSR0:          equ    $00000174                                ;*** CANTXDSR0 - MSCAN Transmit Data Segment Register 0; 0x00000174 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANTXDSR0_DB0:      equ    0                                         ; Data Bit 0
CANTXDSR0_DB1:      equ    1                                         ; Data Bit 1
CANTXDSR0_DB2:      equ    2                                         ; Data Bit 2
CANTXDSR0_DB3:      equ    3                                         ; Data Bit 3
CANTXDSR0_DB4:      equ    4                                         ; Data Bit 4
CANTXDSR0_DB5:      equ    5                                         ; Data Bit 5
CANTXDSR0_DB6:      equ    6                                         ; Data Bit 6
CANTXDSR0_DB7:      equ    7                                         ; Data Bit 7
; bit position masks
mCANTXDSR0_DB0:     equ    %00000001
mCANTXDSR0_DB1:     equ    %00000010
mCANTXDSR0_DB2:     equ    %00000100
mCANTXDSR0_DB3:     equ    %00001000
mCANTXDSR0_DB4:     equ    %00010000
mCANTXDSR0_DB5:     equ    %00100000
mCANTXDSR0_DB6:     equ    %01000000
mCANTXDSR0_DB7:     equ    %10000000


;*** CANTXDSR1 - MSCAN Transmit Data Segment Register 1; 0x00000175 ***
CANTXDSR1:          equ    $00000175                                ;*** CANTXDSR1 - MSCAN Transmit Data Segment Register 1; 0x00000175 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANTXDSR1_DB0:      equ    0                                         ; Data Bit 0
CANTXDSR1_DB1:      equ    1                                         ; Data Bit 1
CANTXDSR1_DB2:      equ    2                                         ; Data Bit 2
CANTXDSR1_DB3:      equ    3                                         ; Data Bit 3
CANTXDSR1_DB4:      equ    4                                         ; Data Bit 4
CANTXDSR1_DB5:      equ    5                                         ; Data Bit 5
CANTXDSR1_DB6:      equ    6                                         ; Data Bit 6
CANTXDSR1_DB7:      equ    7                                         ; Data Bit 7
; bit position masks
mCANTXDSR1_DB0:     equ    %00000001
mCANTXDSR1_DB1:     equ    %00000010
mCANTXDSR1_DB2:     equ    %00000100
mCANTXDSR1_DB3:     equ    %00001000
mCANTXDSR1_DB4:     equ    %00010000
mCANTXDSR1_DB5:     equ    %00100000
mCANTXDSR1_DB6:     equ    %01000000
mCANTXDSR1_DB7:     equ    %10000000


;*** CANTXDSR2 - MSCAN Transmit Data Segment Register 2; 0x00000176 ***
CANTXDSR2:          equ    $00000176                                ;*** CANTXDSR2 - MSCAN Transmit Data Segment Register 2; 0x00000176 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANTXDSR2_DB0:      equ    0                                         ; Data Bit 0
CANTXDSR2_DB1:      equ    1                                         ; Data Bit 1
CANTXDSR2_DB2:      equ    2                                         ; Data Bit 2
CANTXDSR2_DB3:      equ    3                                         ; Data Bit 3
CANTXDSR2_DB4:      equ    4                                         ; Data Bit 4
CANTXDSR2_DB5:      equ    5                                         ; Data Bit 5
CANTXDSR2_DB6:      equ    6                                         ; Data Bit 6
CANTXDSR2_DB7:      equ    7                                         ; Data Bit 7
; bit position masks
mCANTXDSR2_DB0:     equ    %00000001
mCANTXDSR2_DB1:     equ    %00000010
mCANTXDSR2_DB2:     equ    %00000100
mCANTXDSR2_DB3:     equ    %00001000
mCANTXDSR2_DB4:     equ    %00010000
mCANTXDSR2_DB5:     equ    %00100000
mCANTXDSR2_DB6:     equ    %01000000
mCANTXDSR2_DB7:     equ    %10000000


;*** CANTXDSR3 - MSCAN Transmit Data Segment Register 3; 0x00000177 ***
CANTXDSR3:          equ    $00000177                                ;*** CANTXDSR3 - MSCAN Transmit Data Segment Register 3; 0x00000177 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANTXDSR3_DB0:      equ    0                                         ; Data Bit 0
CANTXDSR3_DB1:      equ    1                                         ; Data Bit 1
CANTXDSR3_DB2:      equ    2                                         ; Data Bit 2
CANTXDSR3_DB3:      equ    3                                         ; Data Bit 3
CANTXDSR3_DB4:      equ    4                                         ; Data Bit 4
CANTXDSR3_DB5:      equ    5                                         ; Data Bit 5
CANTXDSR3_DB6:      equ    6                                         ; Data Bit 6
CANTXDSR3_DB7:      equ    7                                         ; Data Bit 7
; bit position masks
mCANTXDSR3_DB0:     equ    %00000001
mCANTXDSR3_DB1:     equ    %00000010
mCANTXDSR3_DB2:     equ    %00000100
mCANTXDSR3_DB3:     equ    %00001000
mCANTXDSR3_DB4:     equ    %00010000
mCANTXDSR3_DB5:     equ    %00100000
mCANTXDSR3_DB6:     equ    %01000000
mCANTXDSR3_DB7:     equ    %10000000


;*** CANTXDSR4 - MSCAN Transmit Data Segment Register 4; 0x00000178 ***
CANTXDSR4:          equ    $00000178                                ;*** CANTXDSR4 - MSCAN Transmit Data Segment Register 4; 0x00000178 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANTXDSR4_DB0:      equ    0                                         ; Data Bit 0
CANTXDSR4_DB1:      equ    1                                         ; Data Bit 1
CANTXDSR4_DB2:      equ    2                                         ; Data Bit 2
CANTXDSR4_DB3:      equ    3                                         ; Data Bit 3
CANTXDSR4_DB4:      equ    4                                         ; Data Bit 4
CANTXDSR4_DB5:      equ    5                                         ; Data Bit 5
CANTXDSR4_DB6:      equ    6                                         ; Data Bit 6
CANTXDSR4_DB7:      equ    7                                         ; Data Bit 7
; bit position masks
mCANTXDSR4_DB0:     equ    %00000001
mCANTXDSR4_DB1:     equ    %00000010
mCANTXDSR4_DB2:     equ    %00000100
mCANTXDSR4_DB3:     equ    %00001000
mCANTXDSR4_DB4:     equ    %00010000
mCANTXDSR4_DB5:     equ    %00100000
mCANTXDSR4_DB6:     equ    %01000000
mCANTXDSR4_DB7:     equ    %10000000


;*** CANTXDSR5 - MSCAN Transmit Data Segment Register 5; 0x00000179 ***
CANTXDSR5:          equ    $00000179                                ;*** CANTXDSR5 - MSCAN Transmit Data Segment Register 5; 0x00000179 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANTXDSR5_DB0:      equ    0                                         ; Data Bit 0
CANTXDSR5_DB1:      equ    1                                         ; Data Bit 1
CANTXDSR5_DB2:      equ    2                                         ; Data Bit 2
CANTXDSR5_DB3:      equ    3                                         ; Data Bit 3
CANTXDSR5_DB4:      equ    4                                         ; Data Bit 4
CANTXDSR5_DB5:      equ    5                                         ; Data Bit 5
CANTXDSR5_DB6:      equ    6                                         ; Data Bit 6
CANTXDSR5_DB7:      equ    7                                         ; Data Bit 7
; bit position masks
mCANTXDSR5_DB0:     equ    %00000001
mCANTXDSR5_DB1:     equ    %00000010
mCANTXDSR5_DB2:     equ    %00000100
mCANTXDSR5_DB3:     equ    %00001000
mCANTXDSR5_DB4:     equ    %00010000
mCANTXDSR5_DB5:     equ    %00100000
mCANTXDSR5_DB6:     equ    %01000000
mCANTXDSR5_DB7:     equ    %10000000


;*** CANTXDSR6 - MSCAN Transmit Data Segment Register 6; 0x0000017A ***
CANTXDSR6:          equ    $0000017A                                ;*** CANTXDSR6 - MSCAN Transmit Data Segment Register 6; 0x0000017A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANTXDSR6_DB0:      equ    0                                         ; Data Bit 0
CANTXDSR6_DB1:      equ    1                                         ; Data Bit 1
CANTXDSR6_DB2:      equ    2                                         ; Data Bit 2
CANTXDSR6_DB3:      equ    3                                         ; Data Bit 3
CANTXDSR6_DB4:      equ    4                                         ; Data Bit 4
CANTXDSR6_DB5:      equ    5                                         ; Data Bit 5
CANTXDSR6_DB6:      equ    6                                         ; Data Bit 6
CANTXDSR6_DB7:      equ    7                                         ; Data Bit 7
; bit position masks
mCANTXDSR6_DB0:     equ    %00000001
mCANTXDSR6_DB1:     equ    %00000010
mCANTXDSR6_DB2:     equ    %00000100
mCANTXDSR6_DB3:     equ    %00001000
mCANTXDSR6_DB4:     equ    %00010000
mCANTXDSR6_DB5:     equ    %00100000
mCANTXDSR6_DB6:     equ    %01000000
mCANTXDSR6_DB7:     equ    %10000000


;*** CANTXDSR7 - MSCAN Transmit Data Segment Register 7; 0x0000017B ***
CANTXDSR7:          equ    $0000017B                                ;*** CANTXDSR7 - MSCAN Transmit Data Segment Register 7; 0x0000017B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANTXDSR7_DB0:      equ    0                                         ; Data Bit 0
CANTXDSR7_DB1:      equ    1                                         ; Data Bit 1
CANTXDSR7_DB2:      equ    2                                         ; Data Bit 2
CANTXDSR7_DB3:      equ    3                                         ; Data Bit 3
CANTXDSR7_DB4:      equ    4                                         ; Data Bit 4
CANTXDSR7_DB5:      equ    5                                         ; Data Bit 5
CANTXDSR7_DB6:      equ    6                                         ; Data Bit 6
CANTXDSR7_DB7:      equ    7                                         ; Data Bit 7
; bit position masks
mCANTXDSR7_DB0:     equ    %00000001
mCANTXDSR7_DB1:     equ    %00000010
mCANTXDSR7_DB2:     equ    %00000100
mCANTXDSR7_DB3:     equ    %00001000
mCANTXDSR7_DB4:     equ    %00010000
mCANTXDSR7_DB5:     equ    %00100000
mCANTXDSR7_DB6:     equ    %01000000
mCANTXDSR7_DB7:     equ    %10000000


;*** CANTXDLR - MSCAN Transmit Data Length Register; 0x0000017C ***
CANTXDLR:           equ    $0000017C                                ;*** CANTXDLR - MSCAN Transmit Data Length Register; 0x0000017C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANTXDLR_DLC0:      equ    0                                         ; Data Length Code Bit 0
CANTXDLR_DLC1:      equ    1                                         ; Data Length Code Bit 1
CANTXDLR_DLC2:      equ    2                                         ; Data Length Code Bit 2
CANTXDLR_DLC3:      equ    3                                         ; Data Length Code Bit 3
; bit position masks
mCANTXDLR_DLC0:     equ    %00000001
mCANTXDLR_DLC1:     equ    %00000010
mCANTXDLR_DLC2:     equ    %00000100
mCANTXDLR_DLC3:     equ    %00001000


;*** CANTXTBPR - MSCAN Transmit Buffer Priority; 0x0000017D ***
CANTXTBPR:          equ    $0000017D                                ;*** CANTXTBPR - MSCAN Transmit Buffer Priority; 0x0000017D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANTXTBPR_PRIO0:    equ    0                                         ; Transmit Buffer Priority Bit 0
CANTXTBPR_PRIO1:    equ    1                                         ; Transmit Buffer Priority Bit 1
CANTXTBPR_PRIO2:    equ    2                                         ; Transmit Buffer Priority Bit 2
CANTXTBPR_PRIO3:    equ    3                                         ; Transmit Buffer Priority Bit 3
CANTXTBPR_PRIO4:    equ    4                                         ; Transmit Buffer Priority Bit 4
CANTXTBPR_PRIO5:    equ    5                                         ; Transmit Buffer Priority Bit 5
CANTXTBPR_PRIO6:    equ    6                                         ; Transmit Buffer Priority Bit 6
CANTXTBPR_PRIO7:    equ    7                                         ; Transmit Buffer Priority Bit 7
; bit position masks
mCANTXTBPR_PRIO0:   equ    %00000001
mCANTXTBPR_PRIO1:   equ    %00000010
mCANTXTBPR_PRIO2:   equ    %00000100
mCANTXTBPR_PRIO3:   equ    %00001000
mCANTXTBPR_PRIO4:   equ    %00010000
mCANTXTBPR_PRIO5:   equ    %00100000
mCANTXTBPR_PRIO6:   equ    %01000000
mCANTXTBPR_PRIO7:   equ    %10000000


;*** CANTXTSR - MSCAN Transmit Time Stamp Register; 0x0000017E ***
CANTXTSR:           equ    $0000017E                                ;*** CANTXTSR - MSCAN Transmit Time Stamp Register; 0x0000017E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANTXTSR_TSR0:      equ    0                                         ; Time Stamp Bit 0
CANTXTSR_TSR1:      equ    1                                         ; Time Stamp Bit 1
CANTXTSR_TSR2:      equ    2                                         ; Time Stamp Bit 2
CANTXTSR_TSR3:      equ    3                                         ; Time Stamp Bit 3
CANTXTSR_TSR4:      equ    4                                         ; Time Stamp Bit 4
CANTXTSR_TSR5:      equ    5                                         ; Time Stamp Bit 5
CANTXTSR_TSR6:      equ    6                                         ; Time Stamp Bit 6
CANTXTSR_TSR7:      equ    7                                         ; Time Stamp Bit 7
CANTXTSR_TSR8:      equ    8                                         ; Time Stamp Bit 8
CANTXTSR_TSR9:      equ    9                                         ; Time Stamp Bit 9
CANTXTSR_TSR10:     equ    10                                        ; Time Stamp Bit 10
CANTXTSR_TSR11:     equ    11                                        ; Time Stamp Bit 11
CANTXTSR_TSR12:     equ    12                                        ; Time Stamp Bit 12
CANTXTSR_TSR13:     equ    13                                        ; Time Stamp Bit 13
CANTXTSR_TSR14:     equ    14                                        ; Time Stamp Bit 14
CANTXTSR_TSR15:     equ    15                                        ; Time Stamp Bit 15
; bit position masks
mCANTXTSR_TSR0:     equ    %00000001
mCANTXTSR_TSR1:     equ    %00000010
mCANTXTSR_TSR2:     equ    %00000100
mCANTXTSR_TSR3:     equ    %00001000
mCANTXTSR_TSR4:     equ    %00010000
mCANTXTSR_TSR5:     equ    %00100000
mCANTXTSR_TSR6:     equ    %01000000
mCANTXTSR_TSR7:     equ    %10000000
mCANTXTSR_TSR8:     equ    %100000000
mCANTXTSR_TSR9:     equ    %1000000000
mCANTXTSR_TSR10:    equ    %10000000000
mCANTXTSR_TSR11:    equ    %100000000000
mCANTXTSR_TSR12:    equ    %1000000000000
mCANTXTSR_TSR13:    equ    %10000000000000
mCANTXTSR_TSR14:    equ    %100000000000000
mCANTXTSR_TSR15:    equ    %1000000000000000


;*** CANTXTSRH - MSCAN Transmit Time Stamp Register High; 0x0000017E ***
CANTXTSRH:          equ    $0000017E                                ;*** CANTXTSRH - MSCAN Transmit Time Stamp Register High; 0x0000017E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANTXTSRH_TSR8:     equ    0                                         ; Time Stamp Bit 8
CANTXTSRH_TSR9:     equ    1                                         ; Time Stamp Bit 9
CANTXTSRH_TSR10:    equ    2                                         ; Time Stamp Bit 10
CANTXTSRH_TSR11:    equ    3                                         ; Time Stamp Bit 11
CANTXTSRH_TSR12:    equ    4                                         ; Time Stamp Bit 12
CANTXTSRH_TSR13:    equ    5                                         ; Time Stamp Bit 13
CANTXTSRH_TSR14:    equ    6                                         ; Time Stamp Bit 14
CANTXTSRH_TSR15:    equ    7                                         ; Time Stamp Bit 15
; bit position masks
mCANTXTSRH_TSR8:    equ    %00000001
mCANTXTSRH_TSR9:    equ    %00000010
mCANTXTSRH_TSR10:   equ    %00000100
mCANTXTSRH_TSR11:   equ    %00001000
mCANTXTSRH_TSR12:   equ    %00010000
mCANTXTSRH_TSR13:   equ    %00100000
mCANTXTSRH_TSR14:   equ    %01000000
mCANTXTSRH_TSR15:   equ    %10000000


;*** CANTXTSRL - MSCAN Transmit Time Stamp Register Low; 0x0000017F ***
CANTXTSRL:          equ    $0000017F                                ;*** CANTXTSRL - MSCAN Transmit Time Stamp Register Low; 0x0000017F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CANTXTSRL_TSR0:     equ    0                                         ; Time Stamp Bit 0
CANTXTSRL_TSR1:     equ    1                                         ; Time Stamp Bit 1
CANTXTSRL_TSR2:     equ    2                                         ; Time Stamp Bit 2
CANTXTSRL_TSR3:     equ    3                                         ; Time Stamp Bit 3
CANTXTSRL_TSR4:     equ    4                                         ; Time Stamp Bit 4
CANTXTSRL_TSR5:     equ    5                                         ; Time Stamp Bit 5
CANTXTSRL_TSR6:     equ    6                                         ; Time Stamp Bit 6
CANTXTSRL_TSR7:     equ    7                                         ; Time Stamp Bit 7
; bit position masks
mCANTXTSRL_TSR0:    equ    %00000001
mCANTXTSRL_TSR1:    equ    %00000010
mCANTXTSRL_TSR2:    equ    %00000100
mCANTXTSRL_TSR3:    equ    %00001000
mCANTXTSRL_TSR4:    equ    %00010000
mCANTXTSRL_TSR5:    equ    %00100000
mCANTXTSRL_TSR6:    equ    %01000000
mCANTXTSRL_TSR7:    equ    %10000000


;*** PTT - Port T Data Register; 0x00000240 ***
PTT:                equ    $00000240                                ;*** PTT - Port T Data Register; 0x00000240 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTT_PTT0:           equ    0                                         ; Port T general purpose input/output data bit 0
PTT_PTT1:           equ    1                                         ; Port T general purpose input/output data bit 1
PTT_PTT2:           equ    2                                         ; Port T general purpose input/output data bit 2
PTT_PTT3:           equ    3                                         ; Port T general purpose input/output data bit 3
PTT_PTT4:           equ    4                                         ; Port T general purpose input/output data bit 4
PTT_PTT5:           equ    5                                         ; Port T general purpose input/output data bit 5
PTT_PTT6:           equ    6                                         ; Port T general purpose input/output data bit 6
PTT_PTT7:           equ    7                                         ; Port T general purpose input/output data bit 7
; bit position masks
mPTT_PTT0:          equ    %00000001
mPTT_PTT1:          equ    %00000010
mPTT_PTT2:          equ    %00000100
mPTT_PTT3:          equ    %00001000
mPTT_PTT4:          equ    %00010000
mPTT_PTT5:          equ    %00100000
mPTT_PTT6:          equ    %01000000
mPTT_PTT7:          equ    %10000000


;*** PTIT - Port T Input Register; 0x00000241 ***
PTIT:               equ    $00000241                                ;*** PTIT - Port T Input Register; 0x00000241 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTIT_PTIT0:         equ    0                                         ; Port T input data bit 0
PTIT_PTIT1:         equ    1                                         ; Port T input data bit 1
PTIT_PTIT2:         equ    2                                         ; Port T input data bit 2
PTIT_PTIT3:         equ    3                                         ; Port T input data bit 3
PTIT_PTIT4:         equ    4                                         ; Port T input data bit 4
PTIT_PTIT5:         equ    5                                         ; Port T input data bit 5
PTIT_PTIT6:         equ    6                                         ; Port T input data bit 6
PTIT_PTIT7:         equ    7                                         ; Port T input data bit 7
; bit position masks
mPTIT_PTIT0:        equ    %00000001
mPTIT_PTIT1:        equ    %00000010
mPTIT_PTIT2:        equ    %00000100
mPTIT_PTIT3:        equ    %00001000
mPTIT_PTIT4:        equ    %00010000
mPTIT_PTIT5:        equ    %00100000
mPTIT_PTIT6:        equ    %01000000
mPTIT_PTIT7:        equ    %10000000


;*** DDRT - Port T Data Direction Register; 0x00000242 ***
DDRT:               equ    $00000242                                ;*** DDRT - Port T Data Direction Register; 0x00000242 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRT_DDRT0:         equ    0                                         ; Port T data direction bit 0
DDRT_DDRT1:         equ    1                                         ; Port T data direction bit 1
DDRT_DDRT2:         equ    2                                         ; Port T data direction bit 2
DDRT_DDRT3:         equ    3                                         ; Port T data direction bit 3
DDRT_DDRT4:         equ    4                                         ; Port T data direction bit 4
DDRT_DDRT5:         equ    5                                         ; Port T data direction bit 5
DDRT_DDRT6:         equ    6                                         ; Port T data direction bit 6
DDRT_DDRT7:         equ    7                                         ; Port T data direction bit 7
; bit position masks
mDDRT_DDRT0:        equ    %00000001
mDDRT_DDRT1:        equ    %00000010
mDDRT_DDRT2:        equ    %00000100
mDDRT_DDRT3:        equ    %00001000
mDDRT_DDRT4:        equ    %00010000
mDDRT_DDRT5:        equ    %00100000
mDDRT_DDRT6:        equ    %01000000
mDDRT_DDRT7:        equ    %10000000


;*** PERT - Port T Pull Device Enable Register; 0x00000244 ***
PERT:               equ    $00000244                                ;*** PERT - Port T Pull Device Enable Register; 0x00000244 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PERT_PERT0:         equ    0                                         ; Port T pull device enable bit 0
PERT_PERT1:         equ    1                                         ; Port T pull device enable bit 1
PERT_PERT2:         equ    2                                         ; Port T pull device enable bit 2
PERT_PERT3:         equ    3                                         ; Port T pull device enable bit 3
PERT_PERT4:         equ    4                                         ; Port T pull device enable bit 4
PERT_PERT5:         equ    5                                         ; Port T pull device enable bit 5
PERT_PERT6:         equ    6                                         ; Port T pull device enable bit 6
PERT_PERT7:         equ    7                                         ; Port T pull device enable bit 7
; bit position masks
mPERT_PERT0:        equ    %00000001
mPERT_PERT1:        equ    %00000010
mPERT_PERT2:        equ    %00000100
mPERT_PERT3:        equ    %00001000
mPERT_PERT4:        equ    %00010000
mPERT_PERT5:        equ    %00100000
mPERT_PERT6:        equ    %01000000
mPERT_PERT7:        equ    %10000000


;*** PPST - Port T Polarity Select Register; 0x00000245 ***
PPST:               equ    $00000245                                ;*** PPST - Port T Polarity Select Register; 0x00000245 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PPST_PPST0:         equ    0                                         ; Port T pull device select bit 0
PPST_PPST1:         equ    1                                         ; Port T pull device select bit 1
PPST_PPST2:         equ    2                                         ; Port T pull device select bit 2
PPST_PPST3:         equ    3                                         ; Port T pull device select bit 3
PPST_PPST4:         equ    4                                         ; Port T pull device select bit 4
PPST_PPST5:         equ    5                                         ; Port T pull device select bit 5
PPST_PPST6:         equ    6                                         ; Port T pull device select bit 6
PPST_PPST7:         equ    7                                         ; Port T pull device select bit 7
; bit position masks
mPPST_PPST0:        equ    %00000001
mPPST_PPST1:        equ    %00000010
mPPST_PPST2:        equ    %00000100
mPPST_PPST3:        equ    %00001000
mPPST_PPST4:        equ    %00010000
mPPST_PPST5:        equ    %00100000
mPPST_PPST6:        equ    %01000000
mPPST_PPST7:        equ    %10000000


;*** PTS - Port S Data Register; 0x00000248 ***
PTS:                equ    $00000248                                ;*** PTS - Port S Data Register; 0x00000248 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTS_PTS0:           equ    0                                         ; Port S general purpose input/output data bit 0
PTS_PTS1:           equ    1                                         ; Port S general purpose input/output data bit 1
PTS_PTS2:           equ    2                                         ; Port S general purpose input/output data bit 2
PTS_PTS3:           equ    3                                         ; Port S general purpose input/output data bit 3
PTS_PTS4:           equ    4                                         ; Port S general purpose input/output data bit 4
PTS_PTS5:           equ    5                                         ; Port S general purpose input/output data bit 5
PTS_PTS6:           equ    6                                         ; Port S general purpose input/output data bit 6
PTS_PTS7:           equ    7                                         ; Port S general purpose input/output data bit 7
; bit position masks
mPTS_PTS0:          equ    %00000001
mPTS_PTS1:          equ    %00000010
mPTS_PTS2:          equ    %00000100
mPTS_PTS3:          equ    %00001000
mPTS_PTS4:          equ    %00010000
mPTS_PTS5:          equ    %00100000
mPTS_PTS6:          equ    %01000000
mPTS_PTS7:          equ    %10000000


;*** PTIS - Port S Input Register; 0x00000249 ***
PTIS:               equ    $00000249                                ;*** PTIS - Port S Input Register; 0x00000249 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTIS_PTIS0:         equ    0                                         ; Port S input data bit 0
PTIS_PTIS1:         equ    1                                         ; Port S input data bit 1
PTIS_PTIS2:         equ    2                                         ; Port S input data bit 2
PTIS_PTIS3:         equ    3                                         ; Port S input data bit 3
PTIS_PTIS4:         equ    4                                         ; Port S input data bit 4
PTIS_PTIS5:         equ    5                                         ; Port S input data bit 5
PTIS_PTIS6:         equ    6                                         ; Port S input data bit 6
PTIS_PTIS7:         equ    7                                         ; Port S input data bit 7
; bit position masks
mPTIS_PTIS0:        equ    %00000001
mPTIS_PTIS1:        equ    %00000010
mPTIS_PTIS2:        equ    %00000100
mPTIS_PTIS3:        equ    %00001000
mPTIS_PTIS4:        equ    %00010000
mPTIS_PTIS5:        equ    %00100000
mPTIS_PTIS6:        equ    %01000000
mPTIS_PTIS7:        equ    %10000000


;*** DDRS - Port S Data Direction Register; 0x0000024A ***
DDRS:               equ    $0000024A                                ;*** DDRS - Port S Data Direction Register; 0x0000024A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRS_DDRS0:         equ    0                                         ; Port S data direction bit 0
DDRS_DDRS1:         equ    1                                         ; Port S data direction bit 1
DDRS_DDRS2:         equ    2                                         ; Port S data direction bit 2
DDRS_DDRS3:         equ    3                                         ; Port S data direction bit 3
DDRS_DDRS4:         equ    4                                         ; Port S data direction bit 4
DDRS_DDRS5:         equ    5                                         ; Port S data direction bit 5
DDRS_DDRS6:         equ    6                                         ; Port S data direction bit 6
DDRS_DDRS7:         equ    7                                         ; Port S data direction bit 7
; bit position masks
mDDRS_DDRS0:        equ    %00000001
mDDRS_DDRS1:        equ    %00000010
mDDRS_DDRS2:        equ    %00000100
mDDRS_DDRS3:        equ    %00001000
mDDRS_DDRS4:        equ    %00010000
mDDRS_DDRS5:        equ    %00100000
mDDRS_DDRS6:        equ    %01000000
mDDRS_DDRS7:        equ    %10000000


;*** PERS - Port S Pull Device Enable Register; 0x0000024C ***
PERS:               equ    $0000024C                                ;*** PERS - Port S Pull Device Enable Register; 0x0000024C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PERS_PERS0:         equ    0                                         ; Port S pull device enable bit 0
PERS_PERS1:         equ    1                                         ; Port S pull device enable bit 1
PERS_PERS2:         equ    2                                         ; Port S pull device enable bit 2
PERS_PERS3:         equ    3                                         ; Port S pull device enable bit 3
PERS_PERS4:         equ    4                                         ; Port S pull device enable bit 4
PERS_PERS5:         equ    5                                         ; Port S pull device enable bit 5
PERS_PERS6:         equ    6                                         ; Port S pull device enable bit 6
PERS_PERS7:         equ    7                                         ; Port S pull device enable bit 7
; bit position masks
mPERS_PERS0:        equ    %00000001
mPERS_PERS1:        equ    %00000010
mPERS_PERS2:        equ    %00000100
mPERS_PERS3:        equ    %00001000
mPERS_PERS4:        equ    %00010000
mPERS_PERS5:        equ    %00100000
mPERS_PERS6:        equ    %01000000
mPERS_PERS7:        equ    %10000000


;*** PPSS - Port S Polarity Select Register; 0x0000024D ***
PPSS:               equ    $0000024D                                ;*** PPSS - Port S Polarity Select Register; 0x0000024D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PPSS_PPSS0:         equ    0                                         ; Port S pull device select bit 0
PPSS_PPSS1:         equ    1                                         ; Port S pull device select bit 1
PPSS_PPSS2:         equ    2                                         ; Port S pull device select bit 2
PPSS_PPSS3:         equ    3                                         ; Port S pull device select bit 3
PPSS_PPSS4:         equ    4                                         ; Port S pull device select bit 4
PPSS_PPSS5:         equ    5                                         ; Port S pull device select bit 5
PPSS_PPSS6:         equ    6                                         ; Port S pull device select bit 6
PPSS_PPSS7:         equ    7                                         ; Port S pull device select bit 7
; bit position masks
mPPSS_PPSS0:        equ    %00000001
mPPSS_PPSS1:        equ    %00000010
mPPSS_PPSS2:        equ    %00000100
mPPSS_PPSS3:        equ    %00001000
mPPSS_PPSS4:        equ    %00010000
mPPSS_PPSS5:        equ    %00100000
mPPSS_PPSS6:        equ    %01000000
mPPSS_PPSS7:        equ    %10000000


;*** WOMS - Port S Wired-Or Mode Register; 0x0000024E ***
WOMS:               equ    $0000024E                                ;*** WOMS - Port S Wired-Or Mode Register; 0x0000024E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
WOMS_WOMS0:         equ    0                                         ; Port S wired-or mode bit 0
WOMS_WOMS1:         equ    1                                         ; Port S wired-or mode bit 1
WOMS_WOMS2:         equ    2                                         ; Port S wired-or mode bit 2
WOMS_WOMS3:         equ    3                                         ; Port S wired-or mode bit 3
WOMS_WOMS4:         equ    4                                         ; Port S wired-or mode bit 4
WOMS_WOMS5:         equ    5                                         ; Port S wired-or mode bit 5
WOMS_WOMS6:         equ    6                                         ; Port S wired-or mode bit 6
WOMS_WOMS7:         equ    7                                         ; Port S wired-or mode bit 7
; bit position masks
mWOMS_WOMS0:        equ    %00000001
mWOMS_WOMS1:        equ    %00000010
mWOMS_WOMS2:        equ    %00000100
mWOMS_WOMS3:        equ    %00001000
mWOMS_WOMS4:        equ    %00010000
mWOMS_WOMS5:        equ    %00100000
mWOMS_WOMS6:        equ    %01000000
mWOMS_WOMS7:        equ    %10000000


;*** PRR0 - Pin Routing Register 0; 0x0000024F ***
PRR0:               equ    $0000024F                                ;*** PRR0 - Pin Routing Register 0; 0x0000024F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PRR0_PRR0S0:        equ    0                                         ; Pin Routing Register Serial Module, bit 0
PRR0_PRR0S1:        equ    1                                         ; Pin Routing Register Serial Module, bit 1
PRR0_PRR0T20:       equ    2                                         ; Pin Routing Register IOC2, bit 0
PRR0_PRR0T21:       equ    3                                         ; Pin Routing Register IOC2, bit 1
PRR0_PRR0T30:       equ    4                                         ; Pin Routing Register IOC3, bit 0
PRR0_PRR0T31:       equ    5                                         ; Pin Routing Register IOC3, bit 1
PRR0_PRR0P2:        equ    6                                         ; Pin Routing Register PWM2
PRR0_PRR0P3:        equ    7                                         ; Pin Routing Register PWM3
; bit position masks
mPRR0_PRR0S0:       equ    %00000001
mPRR0_PRR0S1:       equ    %00000010
mPRR0_PRR0T20:      equ    %00000100
mPRR0_PRR0T21:      equ    %00001000
mPRR0_PRR0T30:      equ    %00010000
mPRR0_PRR0T31:      equ    %00100000
mPRR0_PRR0P2:       equ    %01000000
mPRR0_PRR0P3:       equ    %10000000


;*** PTM - Port M Data Register; 0x00000250 ***
PTM:                equ    $00000250                                ;*** PTM - Port M Data Register; 0x00000250 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTM_PTM0:           equ    0                                         ; Port M general purpose input/output data bit 0
PTM_PTM1:           equ    1                                         ; Port M general purpose input/output data bit 1
PTM_PTM2:           equ    2                                         ; Port M general purpose input/output data bit 2
PTM_PTM3:           equ    3                                         ; Port M general purpose input/output data bit 3
; bit position masks
mPTM_PTM0:          equ    %00000001
mPTM_PTM1:          equ    %00000010
mPTM_PTM2:          equ    %00000100
mPTM_PTM3:          equ    %00001000


;*** PTIM - Port M Input Register; 0x00000251 ***
PTIM:               equ    $00000251                                ;*** PTIM - Port M Input Register; 0x00000251 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTIM_PTIM0:         equ    0                                         ; Port M input data bit 0
PTIM_PTIM1:         equ    1                                         ; Port M input data bit 1
PTIM_PTIM2:         equ    2                                         ; Port M input data bit 2
PTIM_PTIM3:         equ    3                                         ; Port M input data bit 3
; bit position masks
mPTIM_PTIM0:        equ    %00000001
mPTIM_PTIM1:        equ    %00000010
mPTIM_PTIM2:        equ    %00000100
mPTIM_PTIM3:        equ    %00001000


;*** DDRM - Port M Data Direction Register; 0x00000252 ***
DDRM:               equ    $00000252                                ;*** DDRM - Port M Data Direction Register; 0x00000252 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRM_DDRM0:         equ    0                                         ; Port M data direction bit 0
DDRM_DDRM1:         equ    1                                         ; Port M data direction bit 1
DDRM_DDRM2:         equ    2                                         ; Port M data direction bit 2
DDRM_DDRM3:         equ    3                                         ; Port M data direction bit 3
; bit position masks
mDDRM_DDRM0:        equ    %00000001
mDDRM_DDRM1:        equ    %00000010
mDDRM_DDRM2:        equ    %00000100
mDDRM_DDRM3:        equ    %00001000


;*** PERM - Port M Pull Device Enable Register; 0x00000254 ***
PERM:               equ    $00000254                                ;*** PERM - Port M Pull Device Enable Register; 0x00000254 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PERM_PERM0:         equ    0                                         ; Port M pull device enable bit 0
PERM_PERM1:         equ    1                                         ; Port M pull device enable bit 1
PERM_PERM2:         equ    2                                         ; Port M pull device enable bit 2
PERM_PERM3:         equ    3                                         ; Port M pull device enable bit 3
; bit position masks
mPERM_PERM0:        equ    %00000001
mPERM_PERM1:        equ    %00000010
mPERM_PERM2:        equ    %00000100
mPERM_PERM3:        equ    %00001000


;*** PPSM - Port M Polarity Select Register; 0x00000255 ***
PPSM:               equ    $00000255                                ;*** PPSM - Port M Polarity Select Register; 0x00000255 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PPSM_PPSM0:         equ    0                                         ; Port M pull device select bit 0
PPSM_PPSM1:         equ    1                                         ; Port M pull device select bit 1
PPSM_PPSM2:         equ    2                                         ; Port M pull device select bit 2
PPSM_PPSM3:         equ    3                                         ; Port M pull device select bit 3
; bit position masks
mPPSM_PPSM0:        equ    %00000001
mPPSM_PPSM1:        equ    %00000010
mPPSM_PPSM2:        equ    %00000100
mPPSM_PPSM3:        equ    %00001000


;*** WOMM - Port M Wired-Or Mode Register; 0x00000256 ***
WOMM:               equ    $00000256                                ;*** WOMM - Port M Wired-Or Mode Register; 0x00000256 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
WOMM_WOMM0:         equ    0                                         ; Port M wired-or mode bit 0
WOMM_WOMM1:         equ    1                                         ; Port M wired-or mode bit 1
WOMM_WOMM2:         equ    2                                         ; Port M wired-or mode bit 2
WOMM_WOMM3:         equ    3                                         ; Port M wired-or mode bit 3
; bit position masks
mWOMM_WOMM0:        equ    %00000001
mWOMM_WOMM1:        equ    %00000010
mWOMM_WOMM2:        equ    %00000100
mWOMM_WOMM3:        equ    %00001000


;*** PKGCR - Package Code Register; 0x00000257 ***
PKGCR:              equ    $00000257                                ;*** PKGCR - Package Code Register; 0x00000257 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PKGCR_PKGCR0:       equ    0                                         ; Package Code, bit 0
PKGCR_PKGCR1:       equ    1                                         ; Package Code, bit 1
PKGCR_PKGCR2:       equ    2                                         ; Package Code, bit 2
PKGCR_APICLKS7:     equ    7                                         ; Pin Routing Register API_EXTCLK
; bit position masks
mPKGCR_PKGCR0:      equ    %00000001
mPKGCR_PKGCR1:      equ    %00000010
mPKGCR_PKGCR2:      equ    %00000100
mPKGCR_APICLKS7:    equ    %10000000


;*** PTP - Port P Data Register; 0x00000258 ***
PTP:                equ    $00000258                                ;*** PTP - Port P Data Register; 0x00000258 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTP_PTP0:           equ    0                                         ; Port P general purpose input/output data bit 0
PTP_PTP1:           equ    1                                         ; Port P general purpose input/output data bit 1
PTP_PTP2:           equ    2                                         ; Port P general purpose input/output data bit 2
PTP_PTP3:           equ    3                                         ; Port P general purpose input/output data bit 3
PTP_PTP4:           equ    4                                         ; Port P general purpose input/output data bit 4
PTP_PTP5:           equ    5                                         ; Port P general purpose input/output data bit 5
PTP_PTP6:           equ    6                                         ; Port P general purpose input/output data bit 6
PTP_PTP7:           equ    7                                         ; Port P general purpose input/output data bit 7
; bit position masks
mPTP_PTP0:          equ    %00000001
mPTP_PTP1:          equ    %00000010
mPTP_PTP2:          equ    %00000100
mPTP_PTP3:          equ    %00001000
mPTP_PTP4:          equ    %00010000
mPTP_PTP5:          equ    %00100000
mPTP_PTP6:          equ    %01000000
mPTP_PTP7:          equ    %10000000


;*** PTIP - Port P Input Register; 0x00000259 ***
PTIP:               equ    $00000259                                ;*** PTIP - Port P Input Register; 0x00000259 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTIP_PTIP0:         equ    0                                         ; Port P input data bit 0
PTIP_PTIP1:         equ    1                                         ; Port P input data bit 1
PTIP_PTIP2:         equ    2                                         ; Port P input data bit 2
PTIP_PTIP3:         equ    3                                         ; Port P input data bit 3
PTIP_PTIP4:         equ    4                                         ; Port P input data bit 4
PTIP_PTIP5:         equ    5                                         ; Port P input data bit 5
PTIP_PTIP6:         equ    6                                         ; Port P input data bit 6
PTIP_PTIP7:         equ    7                                         ; Port P input data bit 7
; bit position masks
mPTIP_PTIP0:        equ    %00000001
mPTIP_PTIP1:        equ    %00000010
mPTIP_PTIP2:        equ    %00000100
mPTIP_PTIP3:        equ    %00001000
mPTIP_PTIP4:        equ    %00010000
mPTIP_PTIP5:        equ    %00100000
mPTIP_PTIP6:        equ    %01000000
mPTIP_PTIP7:        equ    %10000000


;*** DDRP - Port P Data Direction Register; 0x0000025A ***
DDRP:               equ    $0000025A                                ;*** DDRP - Port P Data Direction Register; 0x0000025A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRP_DDRP0:         equ    0                                         ; Port P data direction bit 0
DDRP_DDRP1:         equ    1                                         ; Port P data direction bit 1
DDRP_DDRP2:         equ    2                                         ; Port P data direction bit 2
DDRP_DDRP3:         equ    3                                         ; Port P data direction bit 3
DDRP_DDRP4:         equ    4                                         ; Port P data direction bit 4
DDRP_DDRP5:         equ    5                                         ; Port P data direction bit 5
DDRP_DDRP6:         equ    6                                         ; Port P data direction bit 6
DDRP_DDRP7:         equ    7                                         ; Port P data direction bit 7
; bit position masks
mDDRP_DDRP0:        equ    %00000001
mDDRP_DDRP1:        equ    %00000010
mDDRP_DDRP2:        equ    %00000100
mDDRP_DDRP3:        equ    %00001000
mDDRP_DDRP4:        equ    %00010000
mDDRP_DDRP5:        equ    %00100000
mDDRP_DDRP6:        equ    %01000000
mDDRP_DDRP7:        equ    %10000000


;*** PERP - Port P Pull Device Enable Register; 0x0000025C ***
PERP:               equ    $0000025C                                ;*** PERP - Port P Pull Device Enable Register; 0x0000025C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PERP_PERP0:         equ    0                                         ; Port P pull device enable bit 0
PERP_PERP1:         equ    1                                         ; Port P pull device enable bit 1
PERP_PERP2:         equ    2                                         ; Port P pull device enable bit 2
PERP_PERP3:         equ    3                                         ; Port P pull device enable bit 3
PERP_PERP4:         equ    4                                         ; Port P pull device enable bit 4
PERP_PERP5:         equ    5                                         ; Port P pull device enable bit 5
PERP_PERP6:         equ    6                                         ; Port P pull device enable bit 6
PERP_PERP7:         equ    7                                         ; Port P pull device enable bit 7
; bit position masks
mPERP_PERP0:        equ    %00000001
mPERP_PERP1:        equ    %00000010
mPERP_PERP2:        equ    %00000100
mPERP_PERP3:        equ    %00001000
mPERP_PERP4:        equ    %00010000
mPERP_PERP5:        equ    %00100000
mPERP_PERP6:        equ    %01000000
mPERP_PERP7:        equ    %10000000


;*** PPSP - Port P Polarity Select Register; 0x0000025D ***
PPSP:               equ    $0000025D                                ;*** PPSP - Port P Polarity Select Register; 0x0000025D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PPSP_PPSP0:         equ    0                                         ; Port P pull device select bit 0
PPSP_PPSP1:         equ    1                                         ; Port P pull device select bit 1
PPSP_PPSP2:         equ    2                                         ; Port P pull device select bit 2
PPSP_PPSP3:         equ    3                                         ; Port P pull device select bit 3
PPSP_PPSP4:         equ    4                                         ; Port P pull device select bit 4
PPSP_PPSP5:         equ    5                                         ; Port P pull device select bit 5
PPSP_PPSP6:         equ    6                                         ; Port P pull device select bit 6
PPSP_PPSP7:         equ    7                                         ; Port P pull device select bit 7
; bit position masks
mPPSP_PPSP0:        equ    %00000001
mPPSP_PPSP1:        equ    %00000010
mPPSP_PPSP2:        equ    %00000100
mPPSP_PPSP3:        equ    %00001000
mPPSP_PPSP4:        equ    %00010000
mPPSP_PPSP5:        equ    %00100000
mPPSP_PPSP6:        equ    %01000000
mPPSP_PPSP7:        equ    %10000000


;*** PIEP - Port P Interrupt Enable Register; 0x0000025E ***
PIEP:               equ    $0000025E                                ;*** PIEP - Port P Interrupt Enable Register; 0x0000025E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PIEP_PIEP0:         equ    0                                         ; Port P interrupt enable bit 0
PIEP_PIEP1:         equ    1                                         ; Port P interrupt enable bit 1
PIEP_PIEP2:         equ    2                                         ; Port P interrupt enable bit 2
PIEP_PIEP3:         equ    3                                         ; Port P interrupt enable bit 3
PIEP_PIEP4:         equ    4                                         ; Port P interrupt enable bit 4
PIEP_PIEP5:         equ    5                                         ; Port P interrupt enable bit 5
PIEP_PIEP6:         equ    6                                         ; Port P interrupt enable bit 6
PIEP_PIEP7:         equ    7                                         ; Port P interrupt enable bit 7
; bit position masks
mPIEP_PIEP0:        equ    %00000001
mPIEP_PIEP1:        equ    %00000010
mPIEP_PIEP2:        equ    %00000100
mPIEP_PIEP3:        equ    %00001000
mPIEP_PIEP4:        equ    %00010000
mPIEP_PIEP5:        equ    %00100000
mPIEP_PIEP6:        equ    %01000000
mPIEP_PIEP7:        equ    %10000000


;*** PIFP - Port P Interrupt Flag Register; 0x0000025F ***
PIFP:               equ    $0000025F                                ;*** PIFP - Port P Interrupt Flag Register; 0x0000025F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PIFP_PIFP0:         equ    0                                         ; Port P interrupt flag bit 0
PIFP_PIFP1:         equ    1                                         ; Port P interrupt flag bit 1
PIFP_PIFP2:         equ    2                                         ; Port P interrupt flag bit 2
PIFP_PIFP3:         equ    3                                         ; Port P interrupt flag bit 3
PIFP_PIFP4:         equ    4                                         ; Port P interrupt flag bit 4
PIFP_PIFP5:         equ    5                                         ; Port P interrupt flag bit 5
PIFP_PIFP6:         equ    6                                         ; Port P interrupt flag bit 6
PIFP_PIFP7:         equ    7                                         ; Port P interrupt flag bit 7
; bit position masks
mPIFP_PIFP0:        equ    %00000001
mPIFP_PIFP1:        equ    %00000010
mPIFP_PIFP2:        equ    %00000100
mPIFP_PIFP3:        equ    %00001000
mPIFP_PIFP4:        equ    %00010000
mPIFP_PIFP5:        equ    %00100000
mPIFP_PIFP6:        equ    %01000000
mPIFP_PIFP7:        equ    %10000000


;*** PTJ - Port J Data Register; 0x00000268 ***
PTJ:                equ    $00000268                                ;*** PTJ - Port J Data Register; 0x00000268 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTJ_PTJ0:           equ    0                                         ; Port J general purpose input/output data bit 0
PTJ_PTJ1:           equ    1                                         ; Port J general purpose input/output data bit 1
PTJ_PTJ2:           equ    2                                         ; Port J general purpose input/output data bit 2
PTJ_PTJ3:           equ    3                                         ; Port J general purpose input/output data bit 3
PTJ_PTJ4:           equ    4                                         ; Port J general purpose input/output data bit 4
PTJ_PTJ5:           equ    5                                         ; Port J general purpose input/output data bit 5
PTJ_PTJ6:           equ    6                                         ; Port J general purpose input/output data bit 6
PTJ_PTJ7:           equ    7                                         ; Port J general purpose input/output data bit 7
; bit position masks
mPTJ_PTJ0:          equ    %00000001
mPTJ_PTJ1:          equ    %00000010
mPTJ_PTJ2:          equ    %00000100
mPTJ_PTJ3:          equ    %00001000
mPTJ_PTJ4:          equ    %00010000
mPTJ_PTJ5:          equ    %00100000
mPTJ_PTJ6:          equ    %01000000
mPTJ_PTJ7:          equ    %10000000


;*** PTIJ - Port J Input Register; 0x00000269 ***
PTIJ:               equ    $00000269                                ;*** PTIJ - Port J Input Register; 0x00000269 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTIJ_PTIJ0:         equ    0                                         ; Port J input data bit 0
PTIJ_PTIJ1:         equ    1                                         ; Port J input data bit 1
PTIJ_PTIJ2:         equ    2                                         ; Port J input data bit 2
PTIJ_PTIJ3:         equ    3                                         ; Port J input data bit 3
PTIJ_PTIJ4:         equ    4                                         ; Port J input data bit 4
PTIJ_PTIJ5:         equ    5                                         ; Port J input data bit 5
PTIJ_PTIJ6:         equ    6                                         ; Port J input data bit 6
PTIJ_PTIJ7:         equ    7                                         ; Port J input data bit 7
; bit position masks
mPTIJ_PTIJ0:        equ    %00000001
mPTIJ_PTIJ1:        equ    %00000010
mPTIJ_PTIJ2:        equ    %00000100
mPTIJ_PTIJ3:        equ    %00001000
mPTIJ_PTIJ4:        equ    %00010000
mPTIJ_PTIJ5:        equ    %00100000
mPTIJ_PTIJ6:        equ    %01000000
mPTIJ_PTIJ7:        equ    %10000000


;*** DDRJ - Port J Data Direction Register; 0x0000026A ***
DDRJ:               equ    $0000026A                                ;*** DDRJ - Port J Data Direction Register; 0x0000026A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRJ_DDRJ0:         equ    0                                         ; Port J data direction bit 0
DDRJ_DDRJ1:         equ    1                                         ; Port J data direction bit 1
DDRJ_DDRJ2:         equ    2                                         ; Port J data direction bit 2
DDRJ_DDRJ3:         equ    3                                         ; Port J data direction bit 3
DDRJ_DDRJ4:         equ    4                                         ; Port J data direction bit 4
DDRJ_DDRJ5:         equ    5                                         ; Port J data direction bit 5
DDRJ_DDRJ6:         equ    6                                         ; Port J data direction bit 6
DDRJ_DDRJ7:         equ    7                                         ; Port J data direction bit 7
; bit position masks
mDDRJ_DDRJ0:        equ    %00000001
mDDRJ_DDRJ1:        equ    %00000010
mDDRJ_DDRJ2:        equ    %00000100
mDDRJ_DDRJ3:        equ    %00001000
mDDRJ_DDRJ4:        equ    %00010000
mDDRJ_DDRJ5:        equ    %00100000
mDDRJ_DDRJ6:        equ    %01000000
mDDRJ_DDRJ7:        equ    %10000000


;*** PERJ - Port J Pull Device Enable Register; 0x0000026C ***
PERJ:               equ    $0000026C                                ;*** PERJ - Port J Pull Device Enable Register; 0x0000026C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PERJ_PERJ0:         equ    0                                         ; Port J pull device enable bit 0
PERJ_PERJ1:         equ    1                                         ; Port J pull device enable bit 1
PERJ_PERJ2:         equ    2                                         ; Port J pull device enable bit 2
PERJ_PERJ3:         equ    3                                         ; Port J pull device enable bit 3
PERJ_PERJ4:         equ    4                                         ; Port J pull device enable bit 4
PERJ_PERJ5:         equ    5                                         ; Port J pull device enable bit 5
PERJ_PERJ6:         equ    6                                         ; Port J pull device enable bit 6
PERJ_PERJ7:         equ    7                                         ; Port J pull device enable bit 7
; bit position masks
mPERJ_PERJ0:        equ    %00000001
mPERJ_PERJ1:        equ    %00000010
mPERJ_PERJ2:        equ    %00000100
mPERJ_PERJ3:        equ    %00001000
mPERJ_PERJ4:        equ    %00010000
mPERJ_PERJ5:        equ    %00100000
mPERJ_PERJ6:        equ    %01000000
mPERJ_PERJ7:        equ    %10000000


;*** PPSJ - Port J Polarity Select Register; 0x0000026D ***
PPSJ:               equ    $0000026D                                ;*** PPSJ - Port J Polarity Select Register; 0x0000026D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PPSJ_PPSJ0:         equ    0                                         ; Port J pull device select bit 0
PPSJ_PPSJ1:         equ    1                                         ; Port J pull device select bit 1
PPSJ_PPSJ2:         equ    2                                         ; Port J pull device select bit 2
PPSJ_PPSJ3:         equ    3                                         ; Port J pull device select bit 3
PPSJ_PPSJ4:         equ    4                                         ; Port J pull device select bit 4
PPSJ_PPSJ5:         equ    5                                         ; Port J pull device select bit 5
PPSJ_PPSJ6:         equ    6                                         ; Port J pull device select bit 6
PPSJ_PPSJ7:         equ    7                                         ; Port J pull device select bit 7
; bit position masks
mPPSJ_PPSJ0:        equ    %00000001
mPPSJ_PPSJ1:        equ    %00000010
mPPSJ_PPSJ2:        equ    %00000100
mPPSJ_PPSJ3:        equ    %00001000
mPPSJ_PPSJ4:        equ    %00010000
mPPSJ_PPSJ5:        equ    %00100000
mPPSJ_PPSJ6:        equ    %01000000
mPPSJ_PPSJ7:        equ    %10000000


;*** PIEJ - Port J Interrupt Enable Register; 0x0000026E ***
PIEJ:               equ    $0000026E                                ;*** PIEJ - Port J Interrupt Enable Register; 0x0000026E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PIEJ_PIEJ0:         equ    0                                         ; Port J interrupt enable bit 0
PIEJ_PIEJ1:         equ    1                                         ; Port J interrupt enable bit 1
PIEJ_PIEJ2:         equ    2                                         ; Port J interrupt enable bit 2
PIEJ_PIEJ3:         equ    3                                         ; Port J interrupt enable bit 3
PIEJ_PIEJ4:         equ    4                                         ; Port J interrupt enable bit 4
PIEJ_PIEJ5:         equ    5                                         ; Port J interrupt enable bit 5
PIEJ_PIEJ6:         equ    6                                         ; Port J interrupt enable bit 6
PIEJ_PIEJ7:         equ    7                                         ; Port J interrupt enable bit 7
; bit position masks
mPIEJ_PIEJ0:        equ    %00000001
mPIEJ_PIEJ1:        equ    %00000010
mPIEJ_PIEJ2:        equ    %00000100
mPIEJ_PIEJ3:        equ    %00001000
mPIEJ_PIEJ4:        equ    %00010000
mPIEJ_PIEJ5:        equ    %00100000
mPIEJ_PIEJ6:        equ    %01000000
mPIEJ_PIEJ7:        equ    %10000000


;*** PIFJ - Port J Interrupt Flag Register; 0x0000026F ***
PIFJ:               equ    $0000026F                                ;*** PIFJ - Port J Interrupt Flag Register; 0x0000026F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PIFJ_PIFJ0:         equ    0                                         ; Port J interrupt flag bit 0
PIFJ_PIFJ1:         equ    1                                         ; Port J interrupt flag bit 1
PIFJ_PIFJ2:         equ    2                                         ; Port J interrupt flag bit 2
PIFJ_PIFJ3:         equ    3                                         ; Port J interrupt flag bit 3
PIFJ_PIFJ4:         equ    4                                         ; Port J interrupt flag bit 4
PIFJ_PIFJ5:         equ    5                                         ; Port J interrupt flag bit 5
PIFJ_PIFJ6:         equ    6                                         ; Port J interrupt flag bit 6
PIFJ_PIFJ7:         equ    7                                         ; Port J interrupt flag bit 7
; bit position masks
mPIFJ_PIFJ0:        equ    %00000001
mPIFJ_PIFJ1:        equ    %00000010
mPIFJ_PIFJ2:        equ    %00000100
mPIFJ_PIFJ3:        equ    %00001000
mPIFJ_PIFJ4:        equ    %00010000
mPIFJ_PIFJ5:        equ    %00100000
mPIFJ_PIFJ6:        equ    %01000000
mPIFJ_PIFJ7:        equ    %10000000


;*** PT01AD - Port AD Data Register; 0x00000270 ***
PT01AD:             equ    $00000270                                ;*** PT01AD - Port AD Data Register; 0x00000270 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PT01AD_PT1AD0:      equ    0                                         ; Port AD data bit 0
PT01AD_PT1AD1:      equ    1                                         ; Port AD data bit 1
PT01AD_PT1AD2:      equ    2                                         ; Port AD data bit 2
PT01AD_PT1AD3:      equ    3                                         ; Port AD data bit 3
PT01AD_PT1AD4:      equ    4                                         ; Port AD data bit 4
PT01AD_PT1AD5:      equ    5                                         ; Port AD data bit 5
PT01AD_PT1AD6:      equ    6                                         ; Port AD data bit 6
PT01AD_PT1AD7:      equ    7                                         ; Port AD data bit 7
PT01AD_PT0AD0:      equ    8                                         ; Port AD data bit 8
PT01AD_PT0AD1:      equ    9                                         ; Port AD data bit 9
PT01AD_PT0AD2:      equ    10                                        ; Port AD data bit 10
PT01AD_PT0AD3:      equ    11                                        ; Port AD data bit 11
PT01AD_PT0AD4:      equ    12                                        ; Port AD data bit 12
PT01AD_PT0AD5:      equ    13                                        ; Port AD data bit 13
PT01AD_PT0AD6:      equ    14                                        ; Port AD data bit 14
PT01AD_PT0AD7:      equ    15                                        ; Port AD data bit 15
; bit position masks
mPT01AD_PT1AD0:     equ    %00000001
mPT01AD_PT1AD1:     equ    %00000010
mPT01AD_PT1AD2:     equ    %00000100
mPT01AD_PT1AD3:     equ    %00001000
mPT01AD_PT1AD4:     equ    %00010000
mPT01AD_PT1AD5:     equ    %00100000
mPT01AD_PT1AD6:     equ    %01000000
mPT01AD_PT1AD7:     equ    %10000000
mPT01AD_PT0AD0:     equ    %100000000
mPT01AD_PT0AD1:     equ    %1000000000
mPT01AD_PT0AD2:     equ    %10000000000
mPT01AD_PT0AD3:     equ    %100000000000
mPT01AD_PT0AD4:     equ    %1000000000000
mPT01AD_PT0AD5:     equ    %10000000000000
mPT01AD_PT0AD6:     equ    %100000000000000
mPT01AD_PT0AD7:     equ    %1000000000000000


;*** PT0AD - Port ADH Data Register; 0x00000270 ***
PT0AD:              equ    $00000270                                ;*** PT0AD - Port ADH Data Register; 0x00000270 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PT0AD_PT0AD0:       equ    0                                         ; Port AD data bit 0
PT0AD_PT0AD1:       equ    1                                         ; Port AD data bit 1
PT0AD_PT0AD2:       equ    2                                         ; Port AD data bit 2
PT0AD_PT0AD3:       equ    3                                         ; Port AD data bit 3
PT0AD_PT0AD4:       equ    4                                         ; Port AD data bit 4
PT0AD_PT0AD5:       equ    5                                         ; Port AD data bit 5
PT0AD_PT0AD6:       equ    6                                         ; Port AD data bit 6
PT0AD_PT0AD7:       equ    7                                         ; Port AD data bit 7
; bit position masks
mPT0AD_PT0AD0:      equ    %00000001
mPT0AD_PT0AD1:      equ    %00000010
mPT0AD_PT0AD2:      equ    %00000100
mPT0AD_PT0AD3:      equ    %00001000
mPT0AD_PT0AD4:      equ    %00010000
mPT0AD_PT0AD5:      equ    %00100000
mPT0AD_PT0AD6:      equ    %01000000
mPT0AD_PT0AD7:      equ    %10000000


;*** PT1AD - Port ADL Data Register; 0x00000271 ***
PT1AD:              equ    $00000271                                ;*** PT1AD - Port ADL Data Register; 0x00000271 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PT1AD_PT1AD0:       equ    0                                         ; Port AD data bit 0
PT1AD_PT1AD1:       equ    1                                         ; Port AD data bit 1
PT1AD_PT1AD2:       equ    2                                         ; Port AD data bit 2
PT1AD_PT1AD3:       equ    3                                         ; Port AD data bit 3
PT1AD_PT1AD4:       equ    4                                         ; Port AD data bit 4
PT1AD_PT1AD5:       equ    5                                         ; Port AD data bit 5
PT1AD_PT1AD6:       equ    6                                         ; Port AD data bit 6
PT1AD_PT1AD7:       equ    7                                         ; Port AD data bit 7
; bit position masks
mPT1AD_PT1AD0:      equ    %00000001
mPT1AD_PT1AD1:      equ    %00000010
mPT1AD_PT1AD2:      equ    %00000100
mPT1AD_PT1AD3:      equ    %00001000
mPT1AD_PT1AD4:      equ    %00010000
mPT1AD_PT1AD5:      equ    %00100000
mPT1AD_PT1AD6:      equ    %01000000
mPT1AD_PT1AD7:      equ    %10000000


;*** PTI01AD - Port AD Input Register; 0x00000272 ***
PTI01AD:            equ    $00000272                                ;*** PTI01AD - Port AD Input Register; 0x00000272 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTI01AD_PTI1AD0:    equ    0                                         ; Port AD Bit 0
PTI01AD_PTI1AD1:    equ    1                                         ; Port AD Bit 1
PTI01AD_PTI1AD2:    equ    2                                         ; Port AD Bit 2
PTI01AD_PTI1AD3:    equ    3                                         ; Port AD Bit 3
PTI01AD_PTI1AD4:    equ    4                                         ; Port AD Bit 4
PTI01AD_PTI1AD5:    equ    5                                         ; Port AD Bit 5
PTI01AD_PTI1AD6:    equ    6                                         ; Port AD Bit 6
PTI01AD_PTI1AD7:    equ    7                                         ; Port AD Bit 7
PTI01AD_PTI0AD0:    equ    8                                         ; Port AD Bit 0
PTI01AD_PTI0AD1:    equ    9                                         ; Port AD Bit 1
PTI01AD_PTI0AD2:    equ    10                                        ; Port AD Bit 2
PTI01AD_PTI0AD3:    equ    11                                        ; Port AD Bit 3
PTI01AD_PTI0AD4:    equ    12                                        ; Port AD Bit 4
PTI01AD_PTI0AD5:    equ    13                                        ; Port AD Bit 5
PTI01AD_PTI0AD6:    equ    14                                        ; Port AD Bit 6
PTI01AD_PTI0AD7:    equ    15                                        ; Port AD Bit 7
; bit position masks
mPTI01AD_PTI1AD0:   equ    %00000001
mPTI01AD_PTI1AD1:   equ    %00000010
mPTI01AD_PTI1AD2:   equ    %00000100
mPTI01AD_PTI1AD3:   equ    %00001000
mPTI01AD_PTI1AD4:   equ    %00010000
mPTI01AD_PTI1AD5:   equ    %00100000
mPTI01AD_PTI1AD6:   equ    %01000000
mPTI01AD_PTI1AD7:   equ    %10000000
mPTI01AD_PTI0AD0:   equ    %100000000
mPTI01AD_PTI0AD1:   equ    %1000000000
mPTI01AD_PTI0AD2:   equ    %10000000000
mPTI01AD_PTI0AD3:   equ    %100000000000
mPTI01AD_PTI0AD4:   equ    %1000000000000
mPTI01AD_PTI0AD5:   equ    %10000000000000
mPTI01AD_PTI0AD6:   equ    %100000000000000
mPTI01AD_PTI0AD7:   equ    %1000000000000000


;*** PTI0AD - Port ADH Input Register; 0x00000272 ***
PTI0AD:             equ    $00000272                                ;*** PTI0AD - Port ADH Input Register; 0x00000272 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTI0AD_PTI0AD0:     equ    0                                         ; Port ADH Bit 0
PTI0AD_PTI0AD1:     equ    1                                         ; Port ADH Bit 1
PTI0AD_PTI0AD2:     equ    2                                         ; Port ADH Bit 2
PTI0AD_PTI0AD3:     equ    3                                         ; Port ADH Bit 3
PTI0AD_PTI0AD4:     equ    4                                         ; Port ADH Bit 4
PTI0AD_PTI0AD5:     equ    5                                         ; Port ADH Bit 5
PTI0AD_PTI0AD6:     equ    6                                         ; Port ADH Bit 6
PTI0AD_PTI0AD7:     equ    7                                         ; Port ADH Bit 7
; bit position masks
mPTI0AD_PTI0AD0:    equ    %00000001
mPTI0AD_PTI0AD1:    equ    %00000010
mPTI0AD_PTI0AD2:    equ    %00000100
mPTI0AD_PTI0AD3:    equ    %00001000
mPTI0AD_PTI0AD4:    equ    %00010000
mPTI0AD_PTI0AD5:    equ    %00100000
mPTI0AD_PTI0AD6:    equ    %01000000
mPTI0AD_PTI0AD7:    equ    %10000000


;*** PTI1AD - Port ADL Input Register; 0x00000273 ***
PTI1AD:             equ    $00000273                                ;*** PTI1AD - Port ADL Input Register; 0x00000273 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTI1AD_PTI1AD0:     equ    0                                         ; Port ADL Bit 0
PTI1AD_PTI1AD1:     equ    1                                         ; Port ADL Bit 1
PTI1AD_PTI1AD2:     equ    2                                         ; Port ADL Bit 2
PTI1AD_PTI1AD3:     equ    3                                         ; Port ADL Bit 3
PTI1AD_PTI1AD4:     equ    4                                         ; Port ADL Bit 4
PTI1AD_PTI1AD5:     equ    5                                         ; Port ADL Bit 5
PTI1AD_PTI1AD6:     equ    6                                         ; Port ADL Bit 6
PTI1AD_PTI1AD7:     equ    7                                         ; Port ADL Bit 7
; bit position masks
mPTI1AD_PTI1AD0:    equ    %00000001
mPTI1AD_PTI1AD1:    equ    %00000010
mPTI1AD_PTI1AD2:    equ    %00000100
mPTI1AD_PTI1AD3:    equ    %00001000
mPTI1AD_PTI1AD4:    equ    %00010000
mPTI1AD_PTI1AD5:    equ    %00100000
mPTI1AD_PTI1AD6:    equ    %01000000
mPTI1AD_PTI1AD7:    equ    %10000000


;*** DDR01AD - Port AD Data Direction Register; 0x00000274 ***
DDR01AD:            equ    $00000274                                ;*** DDR01AD - Port AD Data Direction Register; 0x00000274 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDR01AD_DDR1AD0:    equ    0                                         ; Port AD data direction bit 0
DDR01AD_DDR1AD1:    equ    1                                         ; Port AD data direction bit 1
DDR01AD_DDR1AD2:    equ    2                                         ; Port AD data direction bit 2
DDR01AD_DDR1AD3:    equ    3                                         ; Port AD data direction bit 3
DDR01AD_DDR1AD4:    equ    4                                         ; Port AD data direction bit 4
DDR01AD_DDR1AD5:    equ    5                                         ; Port AD data direction bit 5
DDR01AD_DDR1AD6:    equ    6                                         ; Port AD data direction bit 6
DDR01AD_DDR1AD7:    equ    7                                         ; Port AD data direction bit 7
DDR01AD_DDR0AD0:    equ    8                                         ; Port AD data direction bit 8
DDR01AD_DDR0AD1:    equ    9                                         ; Port AD data direction bit 9
DDR01AD_DDR0AD2:    equ    10                                        ; Port AD data direction bit 10
DDR01AD_DDR0AD3:    equ    11                                        ; Port AD data direction bit 11
DDR01AD_DDR0AD4:    equ    12                                        ; Port AD data direction bit 12
DDR01AD_DDR0AD5:    equ    13                                        ; Port AD data direction bit 13
DDR01AD_DDR0AD6:    equ    14                                        ; Port AD data direction bit 14
DDR01AD_DDR0AD7:    equ    15                                        ; Port AD data direction bit 15
; bit position masks
mDDR01AD_DDR1AD0:   equ    %00000001
mDDR01AD_DDR1AD1:   equ    %00000010
mDDR01AD_DDR1AD2:   equ    %00000100
mDDR01AD_DDR1AD3:   equ    %00001000
mDDR01AD_DDR1AD4:   equ    %00010000
mDDR01AD_DDR1AD5:   equ    %00100000
mDDR01AD_DDR1AD6:   equ    %01000000
mDDR01AD_DDR1AD7:   equ    %10000000
mDDR01AD_DDR0AD0:   equ    %100000000
mDDR01AD_DDR0AD1:   equ    %1000000000
mDDR01AD_DDR0AD2:   equ    %10000000000
mDDR01AD_DDR0AD3:   equ    %100000000000
mDDR01AD_DDR0AD4:   equ    %1000000000000
mDDR01AD_DDR0AD5:   equ    %10000000000000
mDDR01AD_DDR0AD6:   equ    %100000000000000
mDDR01AD_DDR0AD7:   equ    %1000000000000000


;*** DDR0AD - Port ADH Data Direction Register; 0x00000274 ***
DDR0AD:             equ    $00000274                                ;*** DDR0AD - Port ADH Data Direction Register; 0x00000274 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDR0AD_DDR0AD0:     equ    0                                         ; Port AD data direction bit 0
DDR0AD_DDR0AD1:     equ    1                                         ; Port AD data direction bit 1
DDR0AD_DDR0AD2:     equ    2                                         ; Port AD data direction bit 2
DDR0AD_DDR0AD3:     equ    3                                         ; Port AD data direction bit 3
DDR0AD_DDR0AD4:     equ    4                                         ; Port AD data direction bit 4
DDR0AD_DDR0AD5:     equ    5                                         ; Port AD data direction bit 5
DDR0AD_DDR0AD6:     equ    6                                         ; Port AD data direction bit 6
DDR0AD_DDR0AD7:     equ    7                                         ; Port AD data direction bit 7
; bit position masks
mDDR0AD_DDR0AD0:    equ    %00000001
mDDR0AD_DDR0AD1:    equ    %00000010
mDDR0AD_DDR0AD2:    equ    %00000100
mDDR0AD_DDR0AD3:    equ    %00001000
mDDR0AD_DDR0AD4:    equ    %00010000
mDDR0AD_DDR0AD5:    equ    %00100000
mDDR0AD_DDR0AD6:    equ    %01000000
mDDR0AD_DDR0AD7:    equ    %10000000


;*** DDR1AD - Port ADL Data Direction Register; 0x00000275 ***
DDR1AD:             equ    $00000275                                ;*** DDR1AD - Port ADL Data Direction Register; 0x00000275 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDR1AD_DDR1AD0:     equ    0                                         ; Port AD data direction bit 0
DDR1AD_DDR1AD1:     equ    1                                         ; Port AD data direction bit 1
DDR1AD_DDR1AD2:     equ    2                                         ; Port AD data direction bit 2
DDR1AD_DDR1AD3:     equ    3                                         ; Port AD data direction bit 3
DDR1AD_DDR1AD4:     equ    4                                         ; Port AD data direction bit 4
DDR1AD_DDR1AD5:     equ    5                                         ; Port AD data direction bit 5
DDR1AD_DDR1AD6:     equ    6                                         ; Port AD data direction bit 6
DDR1AD_DDR1AD7:     equ    7                                         ; Port AD data direction bit 7
; bit position masks
mDDR1AD_DDR1AD0:    equ    %00000001
mDDR1AD_DDR1AD1:    equ    %00000010
mDDR1AD_DDR1AD2:    equ    %00000100
mDDR1AD_DDR1AD3:    equ    %00001000
mDDR1AD_DDR1AD4:    equ    %00010000
mDDR1AD_DDR1AD5:    equ    %00100000
mDDR1AD_DDR1AD6:    equ    %01000000
mDDR1AD_DDR1AD7:    equ    %10000000


;*** RVACTL - RVA control register; 0x00000276 ***
RVACTL:             equ    $00000276                                ;*** RVACTL - RVA control register; 0x00000276 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RVACTL_RVAON:       equ    0                                         ; Reference voltage attenuator on
; bit position masks
mRVACTL_RVAON:      equ    %00000001


;*** PRR1 - Pin Routing Register 1; 0x00000277 ***
PRR1:               equ    $00000277                                ;*** PRR1 - Pin Routing Register 1; 0x00000277 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PRR1_PRR1AN:        equ    0                                         ; Pin Routing Register ADC channels
; bit position masks
mPRR1_PRR1AN:       equ    %00000001


;*** PER01AD - Port AD Pull Up Enable Register; 0x00000278 ***
PER01AD:            equ    $00000278                                ;*** PER01AD - Port AD Pull Up Enable Register; 0x00000278 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PER01AD_PER1AD0:    equ    0                                         ; Port AD pull up enable bit 0
PER01AD_PER1AD1:    equ    1                                         ; Port AD pull up enable bit 1
PER01AD_PER1AD2:    equ    2                                         ; Port AD pull up enable bit 2
PER01AD_PER1AD3:    equ    3                                         ; Port AD pull up enable bit 3
PER01AD_PER1AD4:    equ    4                                         ; Port AD pull up enable bit 4
PER01AD_PER1AD5:    equ    5                                         ; Port AD pull up enable bit 5
PER01AD_PER1AD6:    equ    6                                         ; Port AD pull up enable bit 6
PER01AD_PER1AD7:    equ    7                                         ; Port AD pull up enable bit 7
PER01AD_PER0AD0:    equ    8                                         ; Port AD pull up enable bit 8
PER01AD_PER0AD1:    equ    9                                         ; Port AD pull up enable bit 9
PER01AD_PER0AD2:    equ    10                                        ; Port AD pull up enable bit 10
PER01AD_PER0AD3:    equ    11                                        ; Port AD pull up enable bit 11
PER01AD_PER0AD4:    equ    12                                        ; Port AD pull up enable bit 12
PER01AD_PER0AD5:    equ    13                                        ; Port AD pull up enable bit 13
PER01AD_PER0AD6:    equ    14                                        ; Port AD pull up enable bit 14
PER01AD_PER0AD7:    equ    15                                        ; Port AD pull up enable bit 15
; bit position masks
mPER01AD_PER1AD0:   equ    %00000001
mPER01AD_PER1AD1:   equ    %00000010
mPER01AD_PER1AD2:   equ    %00000100
mPER01AD_PER1AD3:   equ    %00001000
mPER01AD_PER1AD4:   equ    %00010000
mPER01AD_PER1AD5:   equ    %00100000
mPER01AD_PER1AD6:   equ    %01000000
mPER01AD_PER1AD7:   equ    %10000000
mPER01AD_PER0AD0:   equ    %100000000
mPER01AD_PER0AD1:   equ    %1000000000
mPER01AD_PER0AD2:   equ    %10000000000
mPER01AD_PER0AD3:   equ    %100000000000
mPER01AD_PER0AD4:   equ    %1000000000000
mPER01AD_PER0AD5:   equ    %10000000000000
mPER01AD_PER0AD6:   equ    %100000000000000
mPER01AD_PER0AD7:   equ    %1000000000000000


;*** PER0AD - Port ADH Pull Up Enable Register; 0x00000278 ***
PER0AD:             equ    $00000278                                ;*** PER0AD - Port ADH Pull Up Enable Register; 0x00000278 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PER0AD_PER0AD0:     equ    0                                         ; Port ADH pull up enable bit 0
PER0AD_PER0AD1:     equ    1                                         ; Port ADH pull up enable bit 1
PER0AD_PER0AD2:     equ    2                                         ; Port ADH pull up enable bit 2
PER0AD_PER0AD3:     equ    3                                         ; Port ADH pull up enable bit 3
PER0AD_PER0AD4:     equ    4                                         ; Port ADH pull up enable bit 4
PER0AD_PER0AD5:     equ    5                                         ; Port ADH pull up enable bit 5
PER0AD_PER0AD6:     equ    6                                         ; Port ADH pull up enable bit 6
PER0AD_PER0AD7:     equ    7                                         ; Port ADH pull up enable bit 7
; bit position masks
mPER0AD_PER0AD0:    equ    %00000001
mPER0AD_PER0AD1:    equ    %00000010
mPER0AD_PER0AD2:    equ    %00000100
mPER0AD_PER0AD3:    equ    %00001000
mPER0AD_PER0AD4:    equ    %00010000
mPER0AD_PER0AD5:    equ    %00100000
mPER0AD_PER0AD6:    equ    %01000000
mPER0AD_PER0AD7:    equ    %10000000


;*** PER1AD - Port ADL Pull Up Enable Register; 0x00000279 ***
PER1AD:             equ    $00000279                                ;*** PER1AD - Port ADL Pull Up Enable Register; 0x00000279 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PER1AD_PER1AD0:     equ    0                                         ; Port ADL pull up enable bit 0
PER1AD_PER1AD1:     equ    1                                         ; Port ADL pull up enable bit 1
PER1AD_PER1AD2:     equ    2                                         ; Port ADL pull up enable bit 2
PER1AD_PER1AD3:     equ    3                                         ; Port ADL pull up enable bit 3
PER1AD_PER1AD4:     equ    4                                         ; Port ADL pull up enable bit 4
PER1AD_PER1AD5:     equ    5                                         ; Port ADL pull up enable bit 5
PER1AD_PER1AD6:     equ    6                                         ; Port ADL pull up enable bit 6
PER1AD_PER1AD7:     equ    7                                         ; Port ADL pull up enable bit 7
; bit position masks
mPER1AD_PER1AD0:    equ    %00000001
mPER1AD_PER1AD1:    equ    %00000010
mPER1AD_PER1AD2:    equ    %00000100
mPER1AD_PER1AD3:    equ    %00001000
mPER1AD_PER1AD4:    equ    %00010000
mPER1AD_PER1AD5:    equ    %00100000
mPER1AD_PER1AD6:    equ    %01000000
mPER1AD_PER1AD7:    equ    %10000000


;*** PPS01AD - Port AD Polarity Select Register; 0x0000027A ***
PPS01AD:            equ    $0000027A                                ;*** PPS01AD - Port AD Polarity Select Register; 0x0000027A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PPS01AD_PPS1AD0:    equ    0                                         ; Port AD Polarity Select Bit 0
PPS01AD_PPS1AD1:    equ    1                                         ; Port AD Polarity Select Bit 1
PPS01AD_PPS1AD2:    equ    2                                         ; Port AD Polarity Select Bit 2
PPS01AD_PPS1AD3:    equ    3                                         ; Port AD Polarity Select Bit 3
PPS01AD_PPS1AD4:    equ    4                                         ; Port AD Polarity Select Bit 4
PPS01AD_PPS1AD5:    equ    5                                         ; Port AD Polarity Select Bit 5
PPS01AD_PPS1AD6:    equ    6                                         ; Port AD Polarity Select Bit 6
PPS01AD_PPS1AD7:    equ    7                                         ; Port AD Polarity Select Bit 7
PPS01AD_PPS0AD0:    equ    8                                         ; Port AD Polarity Select Bit 0
PPS01AD_PPS0AD1:    equ    9                                         ; Port AD Polarity Select Bit 1
PPS01AD_PPS0AD2:    equ    10                                        ; Port AD Polarity Select Bit 2
PPS01AD_PPS0AD3:    equ    11                                        ; Port AD Polarity Select Bit 3
PPS01AD_PPS0AD4:    equ    12                                        ; Port AD Polarity Select Bit 4
PPS01AD_PPS0AD5:    equ    13                                        ; Port AD Polarity Select Bit 5
PPS01AD_PPS0AD6:    equ    14                                        ; Port AD Polarity Select Bit 6
PPS01AD_PPS0AD7:    equ    15                                        ; Port AD Polarity Select Bit 7
; bit position masks
mPPS01AD_PPS1AD0:   equ    %00000001
mPPS01AD_PPS1AD1:   equ    %00000010
mPPS01AD_PPS1AD2:   equ    %00000100
mPPS01AD_PPS1AD3:   equ    %00001000
mPPS01AD_PPS1AD4:   equ    %00010000
mPPS01AD_PPS1AD5:   equ    %00100000
mPPS01AD_PPS1AD6:   equ    %01000000
mPPS01AD_PPS1AD7:   equ    %10000000
mPPS01AD_PPS0AD0:   equ    %100000000
mPPS01AD_PPS0AD1:   equ    %1000000000
mPPS01AD_PPS0AD2:   equ    %10000000000
mPPS01AD_PPS0AD3:   equ    %100000000000
mPPS01AD_PPS0AD4:   equ    %1000000000000
mPPS01AD_PPS0AD5:   equ    %10000000000000
mPPS01AD_PPS0AD6:   equ    %100000000000000
mPPS01AD_PPS0AD7:   equ    %1000000000000000


;*** PPS0AD - Port ADH Polarity Select Register; 0x0000027A ***
PPS0AD:             equ    $0000027A                                ;*** PPS0AD - Port ADH Polarity Select Register; 0x0000027A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PPS0AD_PPS0AD0:     equ    0                                         ; Port ADH Polarity Select Bit 0
PPS0AD_PPS0AD1:     equ    1                                         ; Port ADH Polarity Select Bit 1
PPS0AD_PPS0AD2:     equ    2                                         ; Port ADH Polarity Select Bit 2
PPS0AD_PPS0AD3:     equ    3                                         ; Port ADH Polarity Select Bit 3
PPS0AD_PPS0AD4:     equ    4                                         ; Port ADH Polarity Select Bit 4
PPS0AD_PPS0AD5:     equ    5                                         ; Port ADH Polarity Select Bit 5
PPS0AD_PPS0AD6:     equ    6                                         ; Port ADH Polarity Select Bit 6
PPS0AD_PPS0AD7:     equ    7                                         ; Port ADH Polarity Select Bit 7
; bit position masks
mPPS0AD_PPS0AD0:    equ    %00000001
mPPS0AD_PPS0AD1:    equ    %00000010
mPPS0AD_PPS0AD2:    equ    %00000100
mPPS0AD_PPS0AD3:    equ    %00001000
mPPS0AD_PPS0AD4:    equ    %00010000
mPPS0AD_PPS0AD5:    equ    %00100000
mPPS0AD_PPS0AD6:    equ    %01000000
mPPS0AD_PPS0AD7:    equ    %10000000


;*** PPS1AD - Port ADL Polarity Select Register; 0x0000027B ***
PPS1AD:             equ    $0000027B                                ;*** PPS1AD - Port ADL Polarity Select Register; 0x0000027B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PPS1AD_PPS1AD0:     equ    0                                         ; Port ADL Polarity Select Bit 0
PPS1AD_PPS1AD1:     equ    1                                         ; Port ADL Polarity Select Bit 1
PPS1AD_PPS1AD2:     equ    2                                         ; Port ADL Polarity Select Bit 2
PPS1AD_PPS1AD3:     equ    3                                         ; Port ADL Polarity Select Bit 3
PPS1AD_PPS1AD4:     equ    4                                         ; Port ADL Polarity Select Bit 4
PPS1AD_PPS1AD5:     equ    5                                         ; Port ADL Polarity Select Bit 5
PPS1AD_PPS1AD6:     equ    6                                         ; Port ADL Polarity Select Bit 6
PPS1AD_PPS1AD7:     equ    7                                         ; Port ADL Polarity Select Bit 7
; bit position masks
mPPS1AD_PPS1AD0:    equ    %00000001
mPPS1AD_PPS1AD1:    equ    %00000010
mPPS1AD_PPS1AD2:    equ    %00000100
mPPS1AD_PPS1AD3:    equ    %00001000
mPPS1AD_PPS1AD4:    equ    %00010000
mPPS1AD_PPS1AD5:    equ    %00100000
mPPS1AD_PPS1AD6:    equ    %01000000
mPPS1AD_PPS1AD7:    equ    %10000000


;*** PIE01AD - Port AD Interrupt Enable Register; 0x0000027C ***
PIE01AD:            equ    $0000027C                                ;*** PIE01AD - Port AD Interrupt Enable Register; 0x0000027C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PIE01AD_PIE1AD0:    equ    0                                         ; Port AD Interrupt Enable Bit 0
PIE01AD_PIE1AD1:    equ    1                                         ; Port AD Interrupt Enable Bit 1
PIE01AD_PIE1AD2:    equ    2                                         ; Port AD Interrupt Enable Bit 2
PIE01AD_PIE1AD3:    equ    3                                         ; Port AD Interrupt Enable Bit 3
PIE01AD_PIE1AD4:    equ    4                                         ; Port AD Interrupt Enable Bit 4
PIE01AD_PIE1AD5:    equ    5                                         ; Port AD Interrupt Enable Bit 5
PIE01AD_PIE1AD6:    equ    6                                         ; Port AD Interrupt Enable Bit 6
PIE01AD_PIE1AD7:    equ    7                                         ; Port AD Interrupt Enable Bit 7
PIE01AD_PIE0AD0:    equ    8                                         ; Port AD Interrupt Enable Bit 0
PIE01AD_PIE0AD1:    equ    9                                         ; Port AD Interrupt Enable Bit 1
PIE01AD_PIE0AD2:    equ    10                                        ; Port AD Interrupt Enable Bit 2
PIE01AD_PIE0AD3:    equ    11                                        ; Port AD Interrupt Enable Bit 3
PIE01AD_PIE0AD4:    equ    12                                        ; Port AD Interrupt Enable Bit 4
PIE01AD_PIE0AD5:    equ    13                                        ; Port AD Interrupt Enable Bit 5
PIE01AD_PIE0AD6:    equ    14                                        ; Port AD Interrupt Enable Bit 6
PIE01AD_PIE0AD7:    equ    15                                        ; Port AD Interrupt Enable Bit 7
; bit position masks
mPIE01AD_PIE1AD0:   equ    %00000001
mPIE01AD_PIE1AD1:   equ    %00000010
mPIE01AD_PIE1AD2:   equ    %00000100
mPIE01AD_PIE1AD3:   equ    %00001000
mPIE01AD_PIE1AD4:   equ    %00010000
mPIE01AD_PIE1AD5:   equ    %00100000
mPIE01AD_PIE1AD6:   equ    %01000000
mPIE01AD_PIE1AD7:   equ    %10000000
mPIE01AD_PIE0AD0:   equ    %100000000
mPIE01AD_PIE0AD1:   equ    %1000000000
mPIE01AD_PIE0AD2:   equ    %10000000000
mPIE01AD_PIE0AD3:   equ    %100000000000
mPIE01AD_PIE0AD4:   equ    %1000000000000
mPIE01AD_PIE0AD5:   equ    %10000000000000
mPIE01AD_PIE0AD6:   equ    %100000000000000
mPIE01AD_PIE0AD7:   equ    %1000000000000000


;*** PIE0AD - Port ADH Interrupt Enable Register; 0x0000027C ***
PIE0AD:             equ    $0000027C                                ;*** PIE0AD - Port ADH Interrupt Enable Register; 0x0000027C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PIE0AD_PIE0AD0:     equ    0                                         ; Port ADH Interrupt Enable Bit 0
PIE0AD_PIE0AD1:     equ    1                                         ; Port ADH Interrupt Enable Bit 1
PIE0AD_PIE0AD2:     equ    2                                         ; Port ADH Interrupt Enable Bit 2
PIE0AD_PIE0AD3:     equ    3                                         ; Port ADH Interrupt Enable Bit 3
PIE0AD_PIE0AD4:     equ    4                                         ; Port ADH Interrupt Enable Bit 4
PIE0AD_PIE0AD5:     equ    5                                         ; Port ADH Interrupt Enable Bit 5
PIE0AD_PIE0AD6:     equ    6                                         ; Port ADH Interrupt Enable Bit 6
PIE0AD_PIE0AD7:     equ    7                                         ; Port ADH Interrupt Enable Bit 7
; bit position masks
mPIE0AD_PIE0AD0:    equ    %00000001
mPIE0AD_PIE0AD1:    equ    %00000010
mPIE0AD_PIE0AD2:    equ    %00000100
mPIE0AD_PIE0AD3:    equ    %00001000
mPIE0AD_PIE0AD4:    equ    %00010000
mPIE0AD_PIE0AD5:    equ    %00100000
mPIE0AD_PIE0AD6:    equ    %01000000
mPIE0AD_PIE0AD7:    equ    %10000000


;*** PIE1AD - Port ADL Interrupt Enable Register; 0x0000027D ***
PIE1AD:             equ    $0000027D                                ;*** PIE1AD - Port ADL Interrupt Enable Register; 0x0000027D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PIE1AD_PIE1AD0:     equ    0                                         ; Port ADL Interrupt Enable Bit 0
PIE1AD_PIE1AD1:     equ    1                                         ; Port ADL Interrupt Enable Bit 1
PIE1AD_PIE1AD2:     equ    2                                         ; Port ADL Interrupt Enable Bit 2
PIE1AD_PIE1AD3:     equ    3                                         ; Port ADL Interrupt Enable Bit 3
PIE1AD_PIE1AD4:     equ    4                                         ; Port ADL Interrupt Enable Bit 4
PIE1AD_PIE1AD5:     equ    5                                         ; Port ADL Interrupt Enable Bit 5
PIE1AD_PIE1AD6:     equ    6                                         ; Port ADL Interrupt Enable Bit 6
PIE1AD_PIE1AD7:     equ    7                                         ; Port ADL Interrupt Enable Bit 7
; bit position masks
mPIE1AD_PIE1AD0:    equ    %00000001
mPIE1AD_PIE1AD1:    equ    %00000010
mPIE1AD_PIE1AD2:    equ    %00000100
mPIE1AD_PIE1AD3:    equ    %00001000
mPIE1AD_PIE1AD4:    equ    %00010000
mPIE1AD_PIE1AD5:    equ    %00100000
mPIE1AD_PIE1AD6:    equ    %01000000
mPIE1AD_PIE1AD7:    equ    %10000000


;*** PIF01AD - Port AD Interrupt Flag Register; 0x0000027E ***
PIF01AD:            equ    $0000027E                                ;*** PIF01AD - Port AD Interrupt Flag Register; 0x0000027E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PIF01AD_PIF1AD0:    equ    0                                         ; Port AD Bit 0
PIF01AD_PIF1AD1:    equ    1                                         ; Port AD Bit 1
PIF01AD_PIF1AD2:    equ    2                                         ; Port AD Bit 2
PIF01AD_PIF1AD3:    equ    3                                         ; Port AD Bit 3
PIF01AD_PIF1AD4:    equ    4                                         ; Port AD Bit 4
PIF01AD_PIF1AD5:    equ    5                                         ; Port AD Bit 5
PIF01AD_PIF1AD6:    equ    6                                         ; Port AD Bit 6
PIF01AD_PIF1AD7:    equ    7                                         ; Port AD Bit 7
PIF01AD_PIF0AD0:    equ    8                                         ; Port AD Bit 0
PIF01AD_PIF0AD1:    equ    9                                         ; Port AD Bit 1
PIF01AD_PIF0AD2:    equ    10                                        ; Port AD Bit 2
PIF01AD_PIF0AD3:    equ    11                                        ; Port AD Bit 3
PIF01AD_PIF0AD4:    equ    12                                        ; Port AD Bit 4
PIF01AD_PIF0AD5:    equ    13                                        ; Port AD Bit 5
PIF01AD_PIF0AD6:    equ    14                                        ; Port AD Bit 6
PIF01AD_PIF0AD7:    equ    15                                        ; Port AD Bit 7
; bit position masks
mPIF01AD_PIF1AD0:   equ    %00000001
mPIF01AD_PIF1AD1:   equ    %00000010
mPIF01AD_PIF1AD2:   equ    %00000100
mPIF01AD_PIF1AD3:   equ    %00001000
mPIF01AD_PIF1AD4:   equ    %00010000
mPIF01AD_PIF1AD5:   equ    %00100000
mPIF01AD_PIF1AD6:   equ    %01000000
mPIF01AD_PIF1AD7:   equ    %10000000
mPIF01AD_PIF0AD0:   equ    %100000000
mPIF01AD_PIF0AD1:   equ    %1000000000
mPIF01AD_PIF0AD2:   equ    %10000000000
mPIF01AD_PIF0AD3:   equ    %100000000000
mPIF01AD_PIF0AD4:   equ    %1000000000000
mPIF01AD_PIF0AD5:   equ    %10000000000000
mPIF01AD_PIF0AD6:   equ    %100000000000000
mPIF01AD_PIF0AD7:   equ    %1000000000000000


;*** PIF0AD - Port ADH Interrupt Flag Register; 0x0000027E ***
PIF0AD:             equ    $0000027E                                ;*** PIF0AD - Port ADH Interrupt Flag Register; 0x0000027E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PIF0AD_PIF0AD0:     equ    0                                         ; Port ADH Bit 0
PIF0AD_PIF0AD1:     equ    1                                         ; Port ADH Bit 1
PIF0AD_PIF0AD2:     equ    2                                         ; Port ADH Bit 2
PIF0AD_PIF0AD3:     equ    3                                         ; Port ADH Bit 3
PIF0AD_PIF0AD4:     equ    4                                         ; Port ADH Bit 4
PIF0AD_PIF0AD5:     equ    5                                         ; Port ADH Bit 5
PIF0AD_PIF0AD6:     equ    6                                         ; Port ADH Bit 6
PIF0AD_PIF0AD7:     equ    7                                         ; Port ADH Bit 7
; bit position masks
mPIF0AD_PIF0AD0:    equ    %00000001
mPIF0AD_PIF0AD1:    equ    %00000010
mPIF0AD_PIF0AD2:    equ    %00000100
mPIF0AD_PIF0AD3:    equ    %00001000
mPIF0AD_PIF0AD4:    equ    %00010000
mPIF0AD_PIF0AD5:    equ    %00100000
mPIF0AD_PIF0AD6:    equ    %01000000
mPIF0AD_PIF0AD7:    equ    %10000000


;*** PIF1AD - Port ADL Interrupt Flag Register; 0x0000027F ***
PIF1AD:             equ    $0000027F                                ;*** PIF1AD - Port ADL Interrupt Flag Register; 0x0000027F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PIF1AD_PIF1AD0:     equ    0                                         ; Port ADL Bit 0
PIF1AD_PIF1AD1:     equ    1                                         ; Port ADL Bit 1
PIF1AD_PIF1AD2:     equ    2                                         ; Port ADL Bit 2
PIF1AD_PIF1AD3:     equ    3                                         ; Port ADL Bit 3
PIF1AD_PIF1AD4:     equ    4                                         ; Port ADL Bit 4
PIF1AD_PIF1AD5:     equ    5                                         ; Port ADL Bit 5
PIF1AD_PIF1AD6:     equ    6                                         ; Port ADL Bit 6
PIF1AD_PIF1AD7:     equ    7                                         ; Port ADL Bit 7
; bit position masks
mPIF1AD_PIF1AD0:    equ    %00000001
mPIF1AD_PIF1AD1:    equ    %00000010
mPIF1AD_PIF1AD2:    equ    %00000100
mPIF1AD_PIF1AD3:    equ    %00001000
mPIF1AD_PIF1AD4:    equ    %00010000
mPIF1AD_PIF1AD5:    equ    %00100000
mPIF1AD_PIF1AD6:    equ    %01000000
mPIF1AD_PIF1AD7:    equ    %10000000


;*** CPMULVCTL - Low Voltage Control Register; 0x000002F1 ***
CPMULVCTL:          equ    $000002F1                                ;*** CPMULVCTL - Low Voltage Control Register; 0x000002F1 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CPMULVCTL_LVIF:     equ    0                                         ; Low-Voltage Interrupt Flag
CPMULVCTL_LVIE:     equ    1                                         ; Low-Voltage Interrupt Enable Bit
CPMULVCTL_LVDS:     equ    2                                         ; Low-Voltage Detect Status Bit
; bit position masks
mCPMULVCTL_LVIF:    equ    %00000001
mCPMULVCTL_LVIE:    equ    %00000010
mCPMULVCTL_LVDS:    equ    %00000100


;*** CPMUAPICTL - Autonomous Periodical Interrupt Control Register; 0x000002F2 ***
CPMUAPICTL:         equ    $000002F2                                ;*** CPMUAPICTL - Autonomous Periodical Interrupt Control Register; 0x000002F2 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CPMUAPICTL_APIF:    equ    0                                         ; Autonomous Periodical Interrupt Flag
CPMUAPICTL_APIE:    equ    1                                         ; Autonomous Periodical Interrupt Enable Bit
CPMUAPICTL_APIFE:   equ    2                                         ; Autonomous Periodical Interrupt Feature Enable Bit
CPMUAPICTL_APIEA:   equ    3                                         ; Autonomous Periodical Interrupt External Access Enable Bit
CPMUAPICTL_APIES:   equ    4                                         ; Autonomous Periodical Interrupt External Select Bit
CPMUAPICTL_APICLK:  equ    7                                         ; Autonomous Periodical Interrupt Clock Select Bit
; bit position masks
mCPMUAPICTL_APIF:   equ    %00000001
mCPMUAPICTL_APIE:   equ    %00000010
mCPMUAPICTL_APIFE:  equ    %00000100
mCPMUAPICTL_APIEA:  equ    %00001000
mCPMUAPICTL_APIES:  equ    %00010000
mCPMUAPICTL_APICLK: equ    %10000000


;*** CPMUACLKTR - Autonomous Clock Trimming Register; 0x000002F3 ***
CPMUACLKTR:         equ    $000002F3                                ;*** CPMUACLKTR - Autonomous Clock Trimming Register; 0x000002F3 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CPMUACLKTR_ACLKTR0: equ    2                                         ; Autonomous Periodical Interrupt Period Trimming Bit 0
CPMUACLKTR_ACLKTR1: equ    3                                         ; Autonomous Periodical Interrupt Period Trimming Bit 1
CPMUACLKTR_ACLKTR2: equ    4                                         ; Autonomous Periodical Interrupt Period Trimming Bit 2
CPMUACLKTR_ACLKTR3: equ    5                                         ; Autonomous Periodical Interrupt Period Trimming Bit 3
CPMUACLKTR_ACLKTR4: equ    6                                         ; Autonomous Periodical Interrupt Period Trimming Bit 4
CPMUACLKTR_ACLKTR5: equ    7                                         ; Autonomous Periodical Interrupt Period Trimming Bit 5
; bit position masks
mCPMUACLKTR_ACLKTR0: equ    %00000100
mCPMUACLKTR_ACLKTR1: equ    %00001000
mCPMUACLKTR_ACLKTR2: equ    %00010000
mCPMUACLKTR_ACLKTR3: equ    %00100000
mCPMUACLKTR_ACLKTR4: equ    %01000000
mCPMUACLKTR_ACLKTR5: equ    %10000000


;*** CPMUAPIR - Autonomous Periodical Interrupt Rate Register; 0x000002F4 ***
CPMUAPIR:           equ    $000002F4                                ;*** CPMUAPIR - Autonomous Periodical Interrupt Rate Register; 0x000002F4 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CPMUAPIR_APIR0:     equ    0                                         ; Autonomous Periodical Interrupt Rate Bit 0
CPMUAPIR_APIR1:     equ    1                                         ; Autonomous Periodical Interrupt Rate Bit 1
CPMUAPIR_APIR2:     equ    2                                         ; Autonomous Periodical Interrupt Rate Bit 2
CPMUAPIR_APIR3:     equ    3                                         ; Autonomous Periodical Interrupt Rate Bit 3
CPMUAPIR_APIR4:     equ    4                                         ; Autonomous Periodical Interrupt Rate Bit 4
CPMUAPIR_APIR5:     equ    5                                         ; Autonomous Periodical Interrupt Rate Bit 5
CPMUAPIR_APIR6:     equ    6                                         ; Autonomous Periodical Interrupt Rate Bit 6
CPMUAPIR_APIR7:     equ    7                                         ; Autonomous Periodical Interrupt Rate Bit 7
CPMUAPIR_APIR8:     equ    8                                         ; Autonomous Periodical Interrupt Rate Bit 8
CPMUAPIR_APIR9:     equ    9                                         ; Autonomous Periodical Interrupt Rate Bit 9
CPMUAPIR_APIR10:    equ    10                                        ; Autonomous Periodical Interrupt Rate Bit 10
CPMUAPIR_APIR11:    equ    11                                        ; Autonomous Periodical Interrupt Rate Bit 11
CPMUAPIR_APIR12:    equ    12                                        ; Autonomous Periodical Interrupt Rate Bit 12
CPMUAPIR_APIR13:    equ    13                                        ; Autonomous Periodical Interrupt Rate Bit 13
CPMUAPIR_APIR14:    equ    14                                        ; Autonomous Periodical Interrupt Rate Bit 14
CPMUAPIR_APIR15:    equ    15                                        ; Autonomous Periodical Interrupt Rate Bit 15
; bit position masks
mCPMUAPIR_APIR0:    equ    %00000001
mCPMUAPIR_APIR1:    equ    %00000010
mCPMUAPIR_APIR2:    equ    %00000100
mCPMUAPIR_APIR3:    equ    %00001000
mCPMUAPIR_APIR4:    equ    %00010000
mCPMUAPIR_APIR5:    equ    %00100000
mCPMUAPIR_APIR6:    equ    %01000000
mCPMUAPIR_APIR7:    equ    %10000000
mCPMUAPIR_APIR8:    equ    %100000000
mCPMUAPIR_APIR9:    equ    %1000000000
mCPMUAPIR_APIR10:   equ    %10000000000
mCPMUAPIR_APIR11:   equ    %100000000000
mCPMUAPIR_APIR12:   equ    %1000000000000
mCPMUAPIR_APIR13:   equ    %10000000000000
mCPMUAPIR_APIR14:   equ    %100000000000000
mCPMUAPIR_APIR15:   equ    %1000000000000000


;*** CPMUAPIRH - Autonomous Periodical Interrupt Rate Register High; 0x000002F4 ***
CPMUAPIRH:          equ    $000002F4                                ;*** CPMUAPIRH - Autonomous Periodical Interrupt Rate Register High; 0x000002F4 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CPMUAPIRH_APIR8:    equ    0                                         ; Autonomous Periodical Interrupt Rate Bit 8
CPMUAPIRH_APIR9:    equ    1                                         ; Autonomous Periodical Interrupt Rate Bit 9
CPMUAPIRH_APIR10:   equ    2                                         ; Autonomous Periodical Interrupt Rate Bit 10
CPMUAPIRH_APIR11:   equ    3                                         ; Autonomous Periodical Interrupt Rate Bit 11
CPMUAPIRH_APIR12:   equ    4                                         ; Autonomous Periodical Interrupt Rate Bit 12
CPMUAPIRH_APIR13:   equ    5                                         ; Autonomous Periodical Interrupt Rate Bit 13
CPMUAPIRH_APIR14:   equ    6                                         ; Autonomous Periodical Interrupt Rate Bit 14
CPMUAPIRH_APIR15:   equ    7                                         ; Autonomous Periodical Interrupt Rate Bit 15
; bit position masks
mCPMUAPIRH_APIR8:   equ    %00000001
mCPMUAPIRH_APIR9:   equ    %00000010
mCPMUAPIRH_APIR10:  equ    %00000100
mCPMUAPIRH_APIR11:  equ    %00001000
mCPMUAPIRH_APIR12:  equ    %00010000
mCPMUAPIRH_APIR13:  equ    %00100000
mCPMUAPIRH_APIR14:  equ    %01000000
mCPMUAPIRH_APIR15:  equ    %10000000


;*** CPMUAPIRL - Autonomous Periodical Interrupt Rate Register Low; 0x000002F5 ***
CPMUAPIRL:          equ    $000002F5                                ;*** CPMUAPIRL - Autonomous Periodical Interrupt Rate Register Low; 0x000002F5 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CPMUAPIRL_APIR0:    equ    0                                         ; Autonomous Periodical Interrupt Rate Bit 0
CPMUAPIRL_APIR1:    equ    1                                         ; Autonomous Periodical Interrupt Rate Bit 1
CPMUAPIRL_APIR2:    equ    2                                         ; Autonomous Periodical Interrupt Rate Bit 2
CPMUAPIRL_APIR3:    equ    3                                         ; Autonomous Periodical Interrupt Rate Bit 3
CPMUAPIRL_APIR4:    equ    4                                         ; Autonomous Periodical Interrupt Rate Bit 4
CPMUAPIRL_APIR5:    equ    5                                         ; Autonomous Periodical Interrupt Rate Bit 5
CPMUAPIRL_APIR6:    equ    6                                         ; Autonomous Periodical Interrupt Rate Bit 6
CPMUAPIRL_APIR7:    equ    7                                         ; Autonomous Periodical Interrupt Rate Bit 7
; bit position masks
mCPMUAPIRL_APIR0:   equ    %00000001
mCPMUAPIRL_APIR1:   equ    %00000010
mCPMUAPIRL_APIR2:   equ    %00000100
mCPMUAPIRL_APIR3:   equ    %00001000
mCPMUAPIRL_APIR4:   equ    %00010000
mCPMUAPIRL_APIR5:   equ    %00100000
mCPMUAPIRL_APIR6:   equ    %01000000
mCPMUAPIRL_APIR7:   equ    %10000000


;*** CPMUIRCTRIM - S12CPMU IRC1M Trim Registers; 0x000002F8 ***
CPMUIRCTRIM:        equ    $000002F8                                ;*** CPMUIRCTRIM - S12CPMU IRC1M Trim Registers; 0x000002F8 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CPMUIRCTRIM_IRCTRIM0: equ    0                                       ; IRC1M Frequency Trim Bit 0
CPMUIRCTRIM_IRCTRIM1: equ    1                                       ; IRC1M Frequency Trim Bit 1
CPMUIRCTRIM_IRCTRIM2: equ    2                                       ; IRC1M Frequency Trim Bit 2
CPMUIRCTRIM_IRCTRIM3: equ    3                                       ; IRC1M Frequency Trim Bit 3
CPMUIRCTRIM_IRCTRIM4: equ    4                                       ; IRC1M Frequency Trim Bit 4
CPMUIRCTRIM_IRCTRIM5: equ    5                                       ; IRC1M Frequency Trim Bit 5
CPMUIRCTRIM_IRCTRIM6: equ    6                                       ; IRC1M Frequency Trim Bit 6
CPMUIRCTRIM_IRCTRIM7: equ    7                                       ; IRC1M Frequency Trim Bit 7
CPMUIRCTRIM_IRCTRIM8: equ    8                                       ; IRC1M Frequency Trim Bit 8
CPMUIRCTRIM_IRCTRIM9: equ    9                                       ; IRC1M Frequency Trim Bit 9
CPMUIRCTRIM_TCTRIM0: equ    11                                       ; IRC1M temperature coeficient Trim Bit 0
CPMUIRCTRIM_TCTRIM1: equ    12                                       ; IRC1M temperature coeficient Trim Bit 1
CPMUIRCTRIM_TCTRIM2: equ    13                                       ; IRC1M temperature coeficient Trim Bit 2
CPMUIRCTRIM_TCTRIM3: equ    14                                       ; IRC1M temperature coeficient Trim Bit 3
CPMUIRCTRIM_TCTRIM4: equ    15                                       ; IRC1M temperature coeficient Trim Bit 4
; bit position masks
mCPMUIRCTRIM_IRCTRIM0: equ    %00000001
mCPMUIRCTRIM_IRCTRIM1: equ    %00000010
mCPMUIRCTRIM_IRCTRIM2: equ    %00000100
mCPMUIRCTRIM_IRCTRIM3: equ    %00001000
mCPMUIRCTRIM_IRCTRIM4: equ    %00010000
mCPMUIRCTRIM_IRCTRIM5: equ    %00100000
mCPMUIRCTRIM_IRCTRIM6: equ    %01000000
mCPMUIRCTRIM_IRCTRIM7: equ    %10000000
mCPMUIRCTRIM_IRCTRIM8: equ    %100000000
mCPMUIRCTRIM_IRCTRIM9: equ    %1000000000
mCPMUIRCTRIM_TCTRIM0: equ    %100000000000
mCPMUIRCTRIM_TCTRIM1: equ    %1000000000000
mCPMUIRCTRIM_TCTRIM2: equ    %10000000000000
mCPMUIRCTRIM_TCTRIM3: equ    %100000000000000
mCPMUIRCTRIM_TCTRIM4: equ    %1000000000000000


;*** CPMUIRCTRIMH - S12CPMU IRC1M Trim Registers High; 0x000002F8 ***
CPMUIRCTRIMH:       equ    $000002F8                                ;*** CPMUIRCTRIMH - S12CPMU IRC1M Trim Registers High; 0x000002F8 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CPMUIRCTRIMH_IRCTRIM8: equ    0                                      ; IRC1M Frequency Trim Bit 8
CPMUIRCTRIMH_IRCTRIM9: equ    1                                      ; IRC1M Frequency Trim Bit 9
CPMUIRCTRIMH_TCTRIM0: equ    3                                       ; IRC1M temperature coeficient Trim Bit 0
CPMUIRCTRIMH_TCTRIM1: equ    4                                       ; IRC1M temperature coeficient Trim Bit 1
CPMUIRCTRIMH_TCTRIM2: equ    5                                       ; IRC1M temperature coeficient Trim Bit 2
CPMUIRCTRIMH_TCTRIM3: equ    6                                       ; IRC1M temperature coeficient Trim Bit 3
CPMUIRCTRIMH_TCTRIM4: equ    7                                       ; IRC1M temperature coeficient Trim Bit 4
; bit position masks
mCPMUIRCTRIMH_IRCTRIM8: equ    %00000001
mCPMUIRCTRIMH_IRCTRIM9: equ    %00000010
mCPMUIRCTRIMH_TCTRIM0: equ    %00001000
mCPMUIRCTRIMH_TCTRIM1: equ    %00010000
mCPMUIRCTRIMH_TCTRIM2: equ    %00100000
mCPMUIRCTRIMH_TCTRIM3: equ    %01000000
mCPMUIRCTRIMH_TCTRIM4: equ    %10000000


;*** CPMUIRCTRIML - S12CPMU IRC1M Trim Registers Low; 0x000002F9 ***
CPMUIRCTRIML:       equ    $000002F9                                ;*** CPMUIRCTRIML - S12CPMU IRC1M Trim Registers Low; 0x000002F9 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CPMUIRCTRIML_IRCTRIM0: equ    0                                      ; IRC1M Frequency Trim Bit 0
CPMUIRCTRIML_IRCTRIM1: equ    1                                      ; IRC1M Frequency Trim Bit 1
CPMUIRCTRIML_IRCTRIM2: equ    2                                      ; IRC1M Frequency Trim Bit 2
CPMUIRCTRIML_IRCTRIM3: equ    3                                      ; IRC1M Frequency Trim Bit 3
CPMUIRCTRIML_IRCTRIM4: equ    4                                      ; IRC1M Frequency Trim Bit 4
CPMUIRCTRIML_IRCTRIM5: equ    5                                      ; IRC1M Frequency Trim Bit 5
CPMUIRCTRIML_IRCTRIM6: equ    6                                      ; IRC1M Frequency Trim Bit 6
CPMUIRCTRIML_IRCTRIM7: equ    7                                      ; IRC1M Frequency Trim Bit 7
; bit position masks
mCPMUIRCTRIML_IRCTRIM0: equ    %00000001
mCPMUIRCTRIML_IRCTRIM1: equ    %00000010
mCPMUIRCTRIML_IRCTRIM2: equ    %00000100
mCPMUIRCTRIML_IRCTRIM3: equ    %00001000
mCPMUIRCTRIML_IRCTRIM4: equ    %00010000
mCPMUIRCTRIML_IRCTRIM5: equ    %00100000
mCPMUIRCTRIML_IRCTRIM6: equ    %01000000
mCPMUIRCTRIML_IRCTRIM7: equ    %10000000


;*** CPMUOSC - S12CPMU Oscillator Register; 0x000002FA ***
CPMUOSC:            equ    $000002FA                                ;*** CPMUOSC - S12CPMU Oscillator Register; 0x000002FA ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CPMUOSC_OSCPINS_EN: equ    5                                         ; Oscillator Pins EXTAL and XTAL Enable Bit
CPMUOSC_OSCE:       equ    7                                         ; Oscillator Enable Bit
; bit position masks
mCPMUOSC_OSCPINS_EN: equ    %00100000
mCPMUOSC_OSCE:      equ    %10000000


;*** CPMUPROT - S12CPMUV1 Protection Register; 0x000002FB ***
CPMUPROT:           equ    $000002FB                                ;*** CPMUPROT - S12CPMUV1 Protection Register; 0x000002FB ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CPMUPROT_PROT:      equ    0                                         ; Clock Configuration Registers Protection Bit
; bit position masks
mCPMUPROT_PROT:     equ    %00000001


;*** DAC0CTL - DAC0 control register; 0x000003C0 ***
DAC0CTL:            equ    $000003C0                                ;*** DAC0CTL - DAC0 control register; 0x000003C0 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DAC0CTL_DACM0:      equ    0                                         ; Mode select, bit 0
DAC0CTL_DACM1:      equ    1                                         ; Mode select, bit 1
DAC0CTL_DACM2:      equ    2                                         ; Mode select, bit 2
DAC0CTL_DRIVE:      equ    6                                         ; Drive select
DAC0CTL_FVR:        equ    7                                         ; Full voltage range
; bit position masks
mDAC0CTL_DACM0:     equ    %00000001
mDAC0CTL_DACM1:     equ    %00000010
mDAC0CTL_DACM2:     equ    %00000100
mDAC0CTL_DRIVE:     equ    %01000000
mDAC0CTL_FVR:       equ    %10000000


;*** DAC0VOL - DAC0 analog output voltage level register; 0x000003C2 ***
DAC0VOL:            equ    $000003C2                                ;*** DAC0VOL - DAC0 analog output voltage level register; 0x000003C2 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DAC0VOL_VOLTAGE0:   equ    0                                         ; Defines (together with the FVR bit) the analog output voltage, bit 0
DAC0VOL_VOLTAGE1:   equ    1                                         ; Defines (together with the FVR bit) the analog output voltage, bit 1
DAC0VOL_VOLTAGE2:   equ    2                                         ; Defines (together with the FVR bit) the analog output voltage, bit 2
DAC0VOL_VOLTAGE3:   equ    3                                         ; Defines (together with the FVR bit) the analog output voltage, bit 3
DAC0VOL_VOLTAGE4:   equ    4                                         ; Defines (together with the FVR bit) the analog output voltage, bit 4
DAC0VOL_VOLTAGE5:   equ    5                                         ; Defines (together with the FVR bit) the analog output voltage, bit 5
DAC0VOL_VOLTAGE6:   equ    6                                         ; Defines (together with the FVR bit) the analog output voltage, bit 6
DAC0VOL_VOLTAGE7:   equ    7                                         ; Defines (together with the FVR bit) the analog output voltage, bit 7
; bit position masks
mDAC0VOL_VOLTAGE0:  equ    %00000001
mDAC0VOL_VOLTAGE1:  equ    %00000010
mDAC0VOL_VOLTAGE2:  equ    %00000100
mDAC0VOL_VOLTAGE3:  equ    %00001000
mDAC0VOL_VOLTAGE4:  equ    %00010000
mDAC0VOL_VOLTAGE5:  equ    %00100000
mDAC0VOL_VOLTAGE6:  equ    %01000000
mDAC0VOL_VOLTAGE7:  equ    %10000000


;*** DAC1CTL - DAC1 control register; 0x000003C8 ***
DAC1CTL:            equ    $000003C8                                ;*** DAC1CTL - DAC1 control register; 0x000003C8 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DAC1CTL_DACM0:      equ    0                                         ; Mode select, bit 0
DAC1CTL_DACM1:      equ    1                                         ; Mode select, bit 1
DAC1CTL_DACM2:      equ    2                                         ; Mode select, bit 2
DAC1CTL_DRIVE:      equ    6                                         ; Drive select
DAC1CTL_FVR:        equ    7                                         ; Full voltage range
; bit position masks
mDAC1CTL_DACM0:     equ    %00000001
mDAC1CTL_DACM1:     equ    %00000010
mDAC1CTL_DACM2:     equ    %00000100
mDAC1CTL_DRIVE:     equ    %01000000
mDAC1CTL_FVR:       equ    %10000000


;*** DAC1VOL - DAC1 analog output voltage level register; 0x000003CA ***
DAC1VOL:            equ    $000003CA                                ;*** DAC1VOL - DAC1 analog output voltage level register; 0x000003CA ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DAC1VOL_VOLTAGE0:   equ    0                                         ; Defines (together with the FVR bit) the analog output voltage, bit 0
DAC1VOL_VOLTAGE1:   equ    1                                         ; Defines (together with the FVR bit) the analog output voltage, bit 1
DAC1VOL_VOLTAGE2:   equ    2                                         ; Defines (together with the FVR bit) the analog output voltage, bit 2
DAC1VOL_VOLTAGE3:   equ    3                                         ; Defines (together with the FVR bit) the analog output voltage, bit 3
DAC1VOL_VOLTAGE4:   equ    4                                         ; Defines (together with the FVR bit) the analog output voltage, bit 4
DAC1VOL_VOLTAGE5:   equ    5                                         ; Defines (together with the FVR bit) the analog output voltage, bit 5
DAC1VOL_VOLTAGE6:   equ    6                                         ; Defines (together with the FVR bit) the analog output voltage, bit 6
DAC1VOL_VOLTAGE7:   equ    7                                         ; Defines (together with the FVR bit) the analog output voltage, bit 7
; bit position masks
mDAC1VOL_VOLTAGE0:  equ    %00000001
mDAC1VOL_VOLTAGE1:  equ    %00000010
mDAC1VOL_VOLTAGE2:  equ    %00000100
mDAC1VOL_VOLTAGE3:  equ    %00001000
mDAC1VOL_VOLTAGE4:  equ    %00010000
mDAC1VOL_VOLTAGE5:  equ    %00100000
mDAC1VOL_VOLTAGE6:  equ    %01000000
mDAC1VOL_VOLTAGE7:  equ    %10000000


;*** BAKEY0 - Backdoor Comparison Key 0; 0x0000FF00 ***
BAKEY0:             equ    $0000FF00                                ;*** BAKEY0 - Backdoor Comparison Key 0; 0x0000FF00 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
BAKEY0_KEY0:        equ    0                                         ; Backdoor Comparison Key Bits, bit 0
BAKEY0_KEY1:        equ    1                                         ; Backdoor Comparison Key Bits, bit 1
BAKEY0_KEY2:        equ    2                                         ; Backdoor Comparison Key Bits, bit 2
BAKEY0_KEY3:        equ    3                                         ; Backdoor Comparison Key Bits, bit 3
BAKEY0_KEY4:        equ    4                                         ; Backdoor Comparison Key Bits, bit 4
BAKEY0_KEY5:        equ    5                                         ; Backdoor Comparison Key Bits, bit 5
BAKEY0_KEY6:        equ    6                                         ; Backdoor Comparison Key Bits, bit 6
BAKEY0_KEY7:        equ    7                                         ; Backdoor Comparison Key Bits, bit 7
BAKEY0_KEY8:        equ    8                                         ; Backdoor Comparison Key Bits, bit 8
BAKEY0_KEY9:        equ    9                                         ; Backdoor Comparison Key Bits, bit 9
BAKEY0_KEY10:       equ    10                                        ; Backdoor Comparison Key Bits, bit 10
BAKEY0_KEY11:       equ    11                                        ; Backdoor Comparison Key Bits, bit 11
BAKEY0_KEY12:       equ    12                                        ; Backdoor Comparison Key Bits, bit 12
BAKEY0_KEY13:       equ    13                                        ; Backdoor Comparison Key Bits, bit 13
BAKEY0_KEY14:       equ    14                                        ; Backdoor Comparison Key Bits, bit 14
BAKEY0_KEY15:       equ    15                                        ; Backdoor Comparison Key Bits, bit 15
; bit position masks
mBAKEY0_KEY0:       equ    %00000001
mBAKEY0_KEY1:       equ    %00000010
mBAKEY0_KEY2:       equ    %00000100
mBAKEY0_KEY3:       equ    %00001000
mBAKEY0_KEY4:       equ    %00010000
mBAKEY0_KEY5:       equ    %00100000
mBAKEY0_KEY6:       equ    %01000000
mBAKEY0_KEY7:       equ    %10000000
mBAKEY0_KEY8:       equ    %100000000
mBAKEY0_KEY9:       equ    %1000000000
mBAKEY0_KEY10:      equ    %10000000000
mBAKEY0_KEY11:      equ    %100000000000
mBAKEY0_KEY12:      equ    %1000000000000
mBAKEY0_KEY13:      equ    %10000000000000
mBAKEY0_KEY14:      equ    %100000000000000
mBAKEY0_KEY15:      equ    %1000000000000000


;*** BAKEY1 - Backdoor Comparison Key 1; 0x0000FF02 ***
BAKEY1:             equ    $0000FF02                                ;*** BAKEY1 - Backdoor Comparison Key 1; 0x0000FF02 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
BAKEY1_KEY0:        equ    0                                         ; Backdoor Comparison Key Bits, bit 0
BAKEY1_KEY1:        equ    1                                         ; Backdoor Comparison Key Bits, bit 1
BAKEY1_KEY2:        equ    2                                         ; Backdoor Comparison Key Bits, bit 2
BAKEY1_KEY3:        equ    3                                         ; Backdoor Comparison Key Bits, bit 3
BAKEY1_KEY4:        equ    4                                         ; Backdoor Comparison Key Bits, bit 4
BAKEY1_KEY5:        equ    5                                         ; Backdoor Comparison Key Bits, bit 5
BAKEY1_KEY6:        equ    6                                         ; Backdoor Comparison Key Bits, bit 6
BAKEY1_KEY7:        equ    7                                         ; Backdoor Comparison Key Bits, bit 7
BAKEY1_KEY8:        equ    8                                         ; Backdoor Comparison Key Bits, bit 8
BAKEY1_KEY9:        equ    9                                         ; Backdoor Comparison Key Bits, bit 9
BAKEY1_KEY10:       equ    10                                        ; Backdoor Comparison Key Bits, bit 10
BAKEY1_KEY11:       equ    11                                        ; Backdoor Comparison Key Bits, bit 11
BAKEY1_KEY12:       equ    12                                        ; Backdoor Comparison Key Bits, bit 12
BAKEY1_KEY13:       equ    13                                        ; Backdoor Comparison Key Bits, bit 13
BAKEY1_KEY14:       equ    14                                        ; Backdoor Comparison Key Bits, bit 14
BAKEY1_KEY15:       equ    15                                        ; Backdoor Comparison Key Bits, bit 15
; bit position masks
mBAKEY1_KEY0:       equ    %00000001
mBAKEY1_KEY1:       equ    %00000010
mBAKEY1_KEY2:       equ    %00000100
mBAKEY1_KEY3:       equ    %00001000
mBAKEY1_KEY4:       equ    %00010000
mBAKEY1_KEY5:       equ    %00100000
mBAKEY1_KEY6:       equ    %01000000
mBAKEY1_KEY7:       equ    %10000000
mBAKEY1_KEY8:       equ    %100000000
mBAKEY1_KEY9:       equ    %1000000000
mBAKEY1_KEY10:      equ    %10000000000
mBAKEY1_KEY11:      equ    %100000000000
mBAKEY1_KEY12:      equ    %1000000000000
mBAKEY1_KEY13:      equ    %10000000000000
mBAKEY1_KEY14:      equ    %100000000000000
mBAKEY1_KEY15:      equ    %1000000000000000


;*** BAKEY2 - Backdoor Comparison Key 2; 0x0000FF04 ***
BAKEY2:             equ    $0000FF04                                ;*** BAKEY2 - Backdoor Comparison Key 2; 0x0000FF04 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
BAKEY2_KEY0:        equ    0                                         ; Backdoor Comparison Key Bits, bit 0
BAKEY2_KEY1:        equ    1                                         ; Backdoor Comparison Key Bits, bit 1
BAKEY2_KEY2:        equ    2                                         ; Backdoor Comparison Key Bits, bit 2
BAKEY2_KEY3:        equ    3                                         ; Backdoor Comparison Key Bits, bit 3
BAKEY2_KEY4:        equ    4                                         ; Backdoor Comparison Key Bits, bit 4
BAKEY2_KEY5:        equ    5                                         ; Backdoor Comparison Key Bits, bit 5
BAKEY2_KEY6:        equ    6                                         ; Backdoor Comparison Key Bits, bit 6
BAKEY2_KEY7:        equ    7                                         ; Backdoor Comparison Key Bits, bit 7
BAKEY2_KEY8:        equ    8                                         ; Backdoor Comparison Key Bits, bit 8
BAKEY2_KEY9:        equ    9                                         ; Backdoor Comparison Key Bits, bit 9
BAKEY2_KEY10:       equ    10                                        ; Backdoor Comparison Key Bits, bit 10
BAKEY2_KEY11:       equ    11                                        ; Backdoor Comparison Key Bits, bit 11
BAKEY2_KEY12:       equ    12                                        ; Backdoor Comparison Key Bits, bit 12
BAKEY2_KEY13:       equ    13                                        ; Backdoor Comparison Key Bits, bit 13
BAKEY2_KEY14:       equ    14                                        ; Backdoor Comparison Key Bits, bit 14
BAKEY2_KEY15:       equ    15                                        ; Backdoor Comparison Key Bits, bit 15
; bit position masks
mBAKEY2_KEY0:       equ    %00000001
mBAKEY2_KEY1:       equ    %00000010
mBAKEY2_KEY2:       equ    %00000100
mBAKEY2_KEY3:       equ    %00001000
mBAKEY2_KEY4:       equ    %00010000
mBAKEY2_KEY5:       equ    %00100000
mBAKEY2_KEY6:       equ    %01000000
mBAKEY2_KEY7:       equ    %10000000
mBAKEY2_KEY8:       equ    %100000000
mBAKEY2_KEY9:       equ    %1000000000
mBAKEY2_KEY10:      equ    %10000000000
mBAKEY2_KEY11:      equ    %100000000000
mBAKEY2_KEY12:      equ    %1000000000000
mBAKEY2_KEY13:      equ    %10000000000000
mBAKEY2_KEY14:      equ    %100000000000000
mBAKEY2_KEY15:      equ    %1000000000000000


;*** BAKEY3 - Backdoor Comparison Key 3; 0x0000FF06 ***
BAKEY3:             equ    $0000FF06                                ;*** BAKEY3 - Backdoor Comparison Key 3; 0x0000FF06 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
BAKEY3_KEY0:        equ    0                                         ; Backdoor Comparison Key Bits, bit 0
BAKEY3_KEY1:        equ    1                                         ; Backdoor Comparison Key Bits, bit 1
BAKEY3_KEY2:        equ    2                                         ; Backdoor Comparison Key Bits, bit 2
BAKEY3_KEY3:        equ    3                                         ; Backdoor Comparison Key Bits, bit 3
BAKEY3_KEY4:        equ    4                                         ; Backdoor Comparison Key Bits, bit 4
BAKEY3_KEY5:        equ    5                                         ; Backdoor Comparison Key Bits, bit 5
BAKEY3_KEY6:        equ    6                                         ; Backdoor Comparison Key Bits, bit 6
BAKEY3_KEY7:        equ    7                                         ; Backdoor Comparison Key Bits, bit 7
BAKEY3_KEY8:        equ    8                                         ; Backdoor Comparison Key Bits, bit 8
BAKEY3_KEY9:        equ    9                                         ; Backdoor Comparison Key Bits, bit 9
BAKEY3_KEY10:       equ    10                                        ; Backdoor Comparison Key Bits, bit 10
BAKEY3_KEY11:       equ    11                                        ; Backdoor Comparison Key Bits, bit 11
BAKEY3_KEY12:       equ    12                                        ; Backdoor Comparison Key Bits, bit 12
BAKEY3_KEY13:       equ    13                                        ; Backdoor Comparison Key Bits, bit 13
BAKEY3_KEY14:       equ    14                                        ; Backdoor Comparison Key Bits, bit 14
BAKEY3_KEY15:       equ    15                                        ; Backdoor Comparison Key Bits, bit 15
; bit position masks
mBAKEY3_KEY0:       equ    %00000001
mBAKEY3_KEY1:       equ    %00000010
mBAKEY3_KEY2:       equ    %00000100
mBAKEY3_KEY3:       equ    %00001000
mBAKEY3_KEY4:       equ    %00010000
mBAKEY3_KEY5:       equ    %00100000
mBAKEY3_KEY6:       equ    %01000000
mBAKEY3_KEY7:       equ    %10000000
mBAKEY3_KEY8:       equ    %100000000
mBAKEY3_KEY9:       equ    %1000000000
mBAKEY3_KEY10:      equ    %10000000000
mBAKEY3_KEY11:      equ    %100000000000
mBAKEY3_KEY12:      equ    %1000000000000
mBAKEY3_KEY13:      equ    %10000000000000
mBAKEY3_KEY14:      equ    %100000000000000
mBAKEY3_KEY15:      equ    %1000000000000000


;*** NVFPROT - Non Volatile P-Flash Protection Register; 0x0000FF0C ***
NVFPROT:            equ    $0000FF0C                                ;*** NVFPROT - Non Volatile P-Flash Protection Register; 0x0000FF0C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NVFPROT_FPLS0:      equ    0                                         ; Flash Protection Lower Address Size Bit 0
NVFPROT_FPLS1:      equ    1                                         ; Flash Protection Lower Address Size Bit 1
NVFPROT_FPLDIS:     equ    2                                         ; Flash Protection Lower Address Range Disable
NVFPROT_FPHS0:      equ    3                                         ; Flash Protection Higher Address Size Bit 0
NVFPROT_FPHS1:      equ    4                                         ; Flash Protection Higher Address Size Bit 1
NVFPROT_FPHDIS:     equ    5                                         ; Flash Protection Higher Address Range Disable
NVFPROT_RNV6:       equ    6                                         ; Reserved Nonvolatile Bit
NVFPROT_FPOPEN:     equ    7                                         ; Flash Protection Operation Enable
; bit position masks
mNVFPROT_FPLS0:     equ    %00000001
mNVFPROT_FPLS1:     equ    %00000010
mNVFPROT_FPLDIS:    equ    %00000100
mNVFPROT_FPHS0:     equ    %00001000
mNVFPROT_FPHS1:     equ    %00010000
mNVFPROT_FPHDIS:    equ    %00100000
mNVFPROT_RNV6:      equ    %01000000
mNVFPROT_FPOPEN:    equ    %10000000


;*** NVDFPROT - Non Volatile D-Flash Protection Register; 0x0000FF0D ***
NVDFPROT:           equ    $0000FF0D                                ;*** NVDFPROT - Non Volatile D-Flash Protection Register; 0x0000FF0D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NVDFPROT_DPS0:      equ    0                                         ; D-Flash Protection Size Bit 0
NVDFPROT_DPS1:      equ    1                                         ; D-Flash Protection Size Bit 1
NVDFPROT_DPS2:      equ    2                                         ; D-Flash Protection Size Bit 2
NVDFPROT_DPS3:      equ    3                                         ; D-Flash Protection Size Bit 3
NVDFPROT_DPS4:      equ    4                                         ; D-Flash Protection Size Bit 4
NVDFPROT_DPS5:      equ    5                                         ; D-Flash Protection Size Bit 5
NVDFPROT_DPS6:      equ    6                                         ; D-Flash Protection Size Bit 6
NVDFPROT_DPOPEN:    equ    7                                         ; D-Flash Protection Control
; bit position masks
mNVDFPROT_DPS0:     equ    %00000001
mNVDFPROT_DPS1:     equ    %00000010
mNVDFPROT_DPS2:     equ    %00000100
mNVDFPROT_DPS3:     equ    %00001000
mNVDFPROT_DPS4:     equ    %00010000
mNVDFPROT_DPS5:     equ    %00100000
mNVDFPROT_DPS6:     equ    %01000000
mNVDFPROT_DPOPEN:   equ    %10000000


;*** NVFOPT - Non Volatile Flash Option Register; 0x0000FF0E ***
NVFOPT:             equ    $0000FF0E                                ;*** NVFOPT - Non Volatile Flash Option Register; 0x0000FF0E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NVFOPT_NV0:         equ    0                                         ; Nonvolatile Bit 0
NVFOPT_NV1:         equ    1                                         ; Nonvolatile Bit 1
NVFOPT_NV2:         equ    2                                         ; Nonvolatile Bit 2
NVFOPT_NV3:         equ    3                                         ; Nonvolatile Bit 3
NVFOPT_NV4:         equ    4                                         ; Nonvolatile Bit 4
NVFOPT_NV5:         equ    5                                         ; Nonvolatile Bit 5
NVFOPT_NV6:         equ    6                                         ; Nonvolatile Bit 6
NVFOPT_NV7:         equ    7                                         ; Nonvolatile Bit 7
; bit position masks
mNVFOPT_NV0:        equ    %00000001
mNVFOPT_NV1:        equ    %00000010
mNVFOPT_NV2:        equ    %00000100
mNVFOPT_NV3:        equ    %00001000
mNVFOPT_NV4:        equ    %00010000
mNVFOPT_NV5:        equ    %00100000
mNVFOPT_NV6:        equ    %01000000
mNVFOPT_NV7:        equ    %10000000


;*** NVFSEC - Non Volatile Flash Security Register; 0x0000FF0F ***
NVFSEC:             equ    $0000FF0F                                ;*** NVFSEC - Non Volatile Flash Security Register; 0x0000FF0F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NVFSEC_SEC0:        equ    0                                         ; Flash Security Bit 0
NVFSEC_SEC1:        equ    1                                         ; Flash Security Bit 1
NVFSEC_RNV2:        equ    2                                         ; Reserved Nonvolatile Bit 2
NVFSEC_RNV3:        equ    3                                         ; Reserved Nonvolatile Bit 3
NVFSEC_RNV4:        equ    4                                         ; Reserved Nonvolatile Bit 4
NVFSEC_RNV5:        equ    5                                         ; Reserved Nonvolatile Bit 5
NVFSEC_KEYEN0:      equ    6                                         ; Backdoor Key Security Enable Bit 0
NVFSEC_KEYEN1:      equ    7                                         ; Backdoor Key Security Enable Bit 1
; bit position masks
mNVFSEC_SEC0:       equ    %00000001
mNVFSEC_SEC1:       equ    %00000010
mNVFSEC_RNV2:       equ    %00000100
mNVFSEC_RNV3:       equ    %00001000
mNVFSEC_RNV4:       equ    %00010000
mNVFSEC_RNV5:       equ    %00100000
mNVFSEC_KEYEN0:     equ    %01000000
mNVFSEC_KEYEN1:     equ    %10000000



;***********************************************
;**   D E P R E C I A T E D   S Y M B O L S   **
;***********************************************
        IFNDEF  __GENERATE_APPLICATION__                            ; not supported for absolute assembler
                    XREF    This_symb_has_been_depreciated
        ENDIF

; EOF
