/* Based on CPU DB MC9S12E128_112, version 2.87.545 (RegistersPrg V2.32) */
/*
** ###################################################################
**     Filename  : mc9s12e64.h
**     Processor : MC9S12E64BCPV
**     FileFormat: V2.32
**     DataSheet : 9S12E-FamilyDGV1/D V01.01
**     Compiler  : CodeWarrior compiler
**     Date/Time : 8.6.2010, 9:02
**     Abstract  :
**         This header implements the mapping of I/O devices.
**
**     Copyright : 1997 - 2010 Freescale Semiconductor, Inc. All Rights Reserved.
**     
**     http      : www.freescale.com
**     mail      : support@freescale.com
**
**     CPU Registers Revisions:
**      - 12.07.2006, V2.87.502:
**              - Added bit 15 to PMFVALx registers. REASON: Bug-fix (#3494 in Issue Manager)
**      - 23.08.2006, V2.87.522:
**              - Renamed register VREGCTRL0 ==> VREGCTRL. REASON: Bug-fix (#<3647> in Issue Manager)
**      - 12.09.2006, V2.87.526:
**              - Removed bits PMFVALx_PMFVAL0x. REASON: Bug-fix (#3494 in Issue Manager)
**      - 6.08.2009, V2.87.542:
**              - Single bits of PMFCNTx, PMFMODx, PMFDTMx registers merged to PMFCNTx[0:14], PMFMODx[0:14], PMFDTMx[0:14] groups. REASON: Access to individual bits is useless (#7539 in Issue Manager)
**
**     File-Format-Revisions:
**      - 14.11.2005, V2.00 :
**               - Deprecated symbols added for backward compatibility (section at the end of this file)
**      - 15.11.2005, V2.01 :
**               - Fixed invalid instruction in macro __RESET_WATCHDOG for HCS12 family.
**      - 17.12.2005, V2.02 :
**               - Arrays (symbols xx_ARR) are defined as pointer to volatile, see issue #2778
**      - 16.01.2006, V2.03 :
**               - Fixed declaration of non volatile registers. Now it does not require (but allows) their initialization, see issue #2920.
**               - "volatile" modifier removed from declaration of non volatile registers (that contain modifier "const")
**      - 08.03.2006, V2.04 :
**               - Support for bit(s) names duplicated with any register name in .h header files
**      - 24.03.2006, V2.05 :
**               - Fixed macro __RESET_WATCHDOG for HCS12 family - address and correct write order.
**      - 26.04.2006, V2.06 :
**               - Changes have not affected this file (because they are related to another family)
**      - 27.04.2006, V2.07 :
**               - Fixed macro __RESET_WATCHDOG for HCS12, HCS12X ,HCS08 DZ and HCS08 EN derivatives (write 0x55,0xAA).
**      - 07.06.2006, V2.08 :
**               - Changes have not affected this file (because they are related to another family)
**      - 03.07.2006, V2.09 :
**               - Changes have not affected this file (because they are related to another family)
**      - 27.10.2006, V2.10 :
**               - __RESET_WATCHDOG improved formating and re-definition
**      - 23.11.2006, V2.11 :
**               - Changes have not affected this file (because they are related to another family)
**      - 22.01.2007, V2.12 :
**               - Fixed declaration of non volatile registers. Now it does not require (but allows) their initialization, see issue #4086.
**      - 01.03.2007, V2.13 :
**               - Flash commands constants values converted to HEX format
**      - 02.03.2007, V2.14 :
**               - Interrupt vector numbers added into .H, see VectorNumber_*
**      - 26.03.2007, V2.15 :
**               - Changes have not affected this file (because they are related to another family)
**      - 10.05.2007, V2.16 :
**               - Changes have not affected this file (because they are related to another family)
**      - 05.06.2007, V2.17 :
**               - Changes have not affected this file (because they are related to another family)
**      - 19.07.2007, V2.18 :
**               - Improved number of blanked lines inside register structures
**      - 06.08.2007, V2.19 :
**               - CPUDB revisions generated ahead of the file-format revisions.
**      - 11.09.2007, V2.20 :
**               - Added comment about initialization of unbonded pins.
**      - 02.01.2008, V2.21 :
**               - Changes have not affected this file (because they are related to another family)
**      - 13.02.2008, V2.22 :
**               - Changes have not affected this file (because they are related to another family)
**      - 20.02.2008, V2.23 :
**               - Termination of pragma V30toV31Compatible added, #5708
**      - 03.07.2008, V2.24 :
**               - Added support for bits with name starting with number (like "1HZ")
**      - 28.11.2008, V2.25 :
**               - StandBy RAM array declaration for ANSI-C added
**      - 1.12.2008, V2.26 :
**               - Duplication of bit (or bit-group) name with register name is not marked as a problem, is register is internal only and it is not displayed in I/O map.
**      - 17.3.2009, V2.27 :
**               - Merged bit-group is not generated, if the name matches with another bit name in the register
**      - 6.4.2009, V2.28 :
**               - Fixed generation of merged bits for bit-groups with a digit at the end, if group-name is defined in CPUDB
**      - 3.8.2009, V2.29 :
**               - If there is just one bits group matching register name, single bits are not generated
**      - 10.9.2009, V2.30 :
**               - Fixed generation of registers arrays.
**      - 15.10.2009, V2.31 :
**               - Changes have not affected this file (because they are related to another family)
**      - 18.05.2010, V2.32 :
**               - MISRA compliance: U/UL suffixes added to all numbers (_MASK,_BITNUM and addresses)
**
**     Not all general-purpose I/O pins are available on all packages or on all mask sets of a specific
**     derivative device. To avoid extra current drain from floating input pins, the users reset
**     initialization routine in the application program must either enable on-chip pull-up devices
**     or change the direction of unconnected pins to outputs so the pins do not float.
** ###################################################################
*/

#ifndef _MC9S12E64_H
#define _MC9S12E64_H

/*lint -save  -e950 -esym(960,18.4) -e46 -esym(961,19.7) Disable MISRA rule (1.1,18.4,6.4,19.7) checking. */
/* Types definition */
typedef unsigned char byte;
typedef unsigned int word;
typedef unsigned long dword;
typedef unsigned long dlong[2];

#define REG_BASE 0x0000                /* Base address for the I/O register block */


#pragma MESSAGE DISABLE C1106 /* WARNING C1106: Non-standard bitfield type */
#pragma OPTION ADD V30toV31Compatible "-BfaGapLimitBits4294967295" /*this guarantee correct bitfield positions*/

/**************** interrupt vector numbers ****************/
#define VectorNumber_VReserved63        63U
#define VectorNumber_VReserved62        62U
#define VectorNumber_VReserved61        61U
#define VectorNumber_VReserved60        60U
#define VectorNumber_Vpwmesdn           59U
#define VectorNumber_Vvreglvi           58U
#define VectorNumber_Vpmffault3         57U
#define VectorNumber_Vpmffault2         56U
#define VectorNumber_Vpmffault1         55U
#define VectorNumber_Vpmffault0         54U
#define VectorNumber_Vpmfgcr            53U
#define VectorNumber_Vpmfgbr            52U
#define VectorNumber_Vpmfgar            51U
#define VectorNumber_Vtim2paie          50U
#define VectorNumber_Vtim2paovf         49U
#define VectorNumber_Vtim2ovf           48U
#define VectorNumber_Vtim2ch7           47U
#define VectorNumber_Vtim2ch6           46U
#define VectorNumber_Vtim2ch5           45U
#define VectorNumber_Vtim2ch4           44U
#define VectorNumber_VReserved43        43U
#define VectorNumber_Vtim1paie          42U
#define VectorNumber_Vtim1paovf         41U
#define VectorNumber_Vtim1ovf           40U
#define VectorNumber_Vtim1ch7           39U
#define VectorNumber_Vtim1ch6           38U
#define VectorNumber_Vtim1ch5           37U
#define VectorNumber_Vtim1ch4           36U
#define VectorNumber_Vflash             35U
#define VectorNumber_VReserved34        34U
#define VectorNumber_VReserved33        33U
#define VectorNumber_VReserved32        32U
#define VectorNumber_Viic               31U
#define VectorNumber_VReserved30        30U
#define VectorNumber_Vcrgscm            29U
#define VectorNumber_Vcrgplllck         28U
#define VectorNumber_VReserved27        27U
#define VectorNumber_VReserved26        26U
#define VectorNumber_VReserved25        25U
#define VectorNumber_Vportad            24U
#define VectorNumber_Vatd0              23U
#define VectorNumber_Vsci2              22U
#define VectorNumber_Vsci1              21U
#define VectorNumber_Vsci0              20U
#define VectorNumber_Vspi               19U
#define VectorNumber_Vtim0paie          18U
#define VectorNumber_Vtim0paovf         17U
#define VectorNumber_Vtim0ovf           16U
#define VectorNumber_Vtim0ch7           15U
#define VectorNumber_Vtim0ch6           14U
#define VectorNumber_Vtim0ch5           13U
#define VectorNumber_Vtim0ch4           12U
#define VectorNumber_VReserved11        11U
#define VectorNumber_VReserved10        10U
#define VectorNumber_VReserved9         9U
#define VectorNumber_VReserved8         8U
#define VectorNumber_Vrti               7U
#define VectorNumber_Virq               6U
#define VectorNumber_Vxirq              5U
#define VectorNumber_Vswi               4U
#define VectorNumber_Vtrap              3U
#define VectorNumber_Vcop               2U
#define VectorNumber_Vclkmon            1U
#define VectorNumber_Vreset             0U

/**************** interrupt vector table ****************/
#define VReserved63                     0xFF80U
#define VReserved62                     0xFF82U
#define VReserved61                     0xFF84U
#define VReserved60                     0xFF86U
#define Vpwmesdn                        0xFF88U
#define Vvreglvi                        0xFF8AU
#define Vpmffault3                      0xFF8CU
#define Vpmffault2                      0xFF8EU
#define Vpmffault1                      0xFF90U
#define Vpmffault0                      0xFF92U
#define Vpmfgcr                         0xFF94U
#define Vpmfgbr                         0xFF96U
#define Vpmfgar                         0xFF98U
#define Vtim2paie                       0xFF9AU
#define Vtim2paovf                      0xFF9CU
#define Vtim2ovf                        0xFF9EU
#define Vtim2ch7                        0xFFA0U
#define Vtim2ch6                        0xFFA2U
#define Vtim2ch5                        0xFFA4U
#define Vtim2ch4                        0xFFA6U
#define VReserved43                     0xFFA8U
#define Vtim1paie                       0xFFAAU
#define Vtim1paovf                      0xFFACU
#define Vtim1ovf                        0xFFAEU
#define Vtim1ch7                        0xFFB0U
#define Vtim1ch6                        0xFFB2U
#define Vtim1ch5                        0xFFB4U
#define Vtim1ch4                        0xFFB6U
#define Vflash                          0xFFB8U
#define VReserved34                     0xFFBAU
#define VReserved33                     0xFFBCU
#define VReserved32                     0xFFBEU
#define Viic                            0xFFC0U
#define VReserved30                     0xFFC2U
#define Vcrgscm                         0xFFC4U
#define Vcrgplllck                      0xFFC6U
#define VReserved27                     0xFFC8U
#define VReserved26                     0xFFCAU
#define VReserved25                     0xFFCCU
#define Vportad                         0xFFCEU
#define Vatd0                           0xFFD0U
#define Vsci2                           0xFFD2U
#define Vsci1                           0xFFD4U
#define Vsci0                           0xFFD6U
#define Vspi                            0xFFD8U
#define Vtim0paie                       0xFFDAU
#define Vtim0paovf                      0xFFDCU
#define Vtim0ovf                        0xFFDEU
#define Vtim0ch7                        0xFFE0U
#define Vtim0ch6                        0xFFE2U
#define Vtim0ch5                        0xFFE4U
#define Vtim0ch4                        0xFFE6U
#define VReserved11                     0xFFE8U
#define VReserved10                     0xFFEAU
#define VReserved9                      0xFFECU
#define VReserved8                      0xFFEEU
#define Vrti                            0xFFF0U
#define Virq                            0xFFF2U
#define Vxirq                           0xFFF4U
#define Vswi                            0xFFF6U
#define Vtrap                           0xFFF8U
#define Vcop                            0xFFFAU
#define Vclkmon                         0xFFFCU
#define Vreset                          0xFFFEU

/**************** registers I/O map ****************/

/*** PORTAB - Port AB Register; 0x00000000 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** PORTA - Port A Register; 0x00000000 ***/
    union {
      byte Byte;
      struct {
        byte BIT0        :1;                                       /* Port A Bit 0 */
        byte BIT1        :1;                                       /* Port A Bit 1 */
        byte BIT2        :1;                                       /* Port A Bit 2 */
        byte BIT3        :1;                                       /* Port A Bit 3 */
        byte BIT4        :1;                                       /* Port A Bit 4 */
        byte BIT5        :1;                                       /* Port A Bit 5 */
        byte BIT6        :1;                                       /* Port A Bit 6 */
        byte BIT7        :1;                                       /* Port A Bit 7 */
      } Bits;
    } PORTASTR;
    #define PORTA                       _PORTAB.Overlap_STR.PORTASTR.Byte
    #define PORTA_BIT0                  _PORTAB.Overlap_STR.PORTASTR.Bits.BIT0
    #define PORTA_BIT1                  _PORTAB.Overlap_STR.PORTASTR.Bits.BIT1
    #define PORTA_BIT2                  _PORTAB.Overlap_STR.PORTASTR.Bits.BIT2
    #define PORTA_BIT3                  _PORTAB.Overlap_STR.PORTASTR.Bits.BIT3
    #define PORTA_BIT4                  _PORTAB.Overlap_STR.PORTASTR.Bits.BIT4
    #define PORTA_BIT5                  _PORTAB.Overlap_STR.PORTASTR.Bits.BIT5
    #define PORTA_BIT6                  _PORTAB.Overlap_STR.PORTASTR.Bits.BIT6
    #define PORTA_BIT7                  _PORTAB.Overlap_STR.PORTASTR.Bits.BIT7
    
    #define PORTA_BIT0_MASK             1U
    #define PORTA_BIT1_MASK             2U
    #define PORTA_BIT2_MASK             4U
    #define PORTA_BIT3_MASK             8U
    #define PORTA_BIT4_MASK             16U
    #define PORTA_BIT5_MASK             32U
    #define PORTA_BIT6_MASK             64U
    #define PORTA_BIT7_MASK             128U
    

    /*** PORTB - Port B Register; 0x00000001 ***/
    union {
      byte Byte;
      struct {
        byte BIT0        :1;                                       /* Port B Bit 0 */
        byte BIT1        :1;                                       /* Port B Bit 1 */
        byte BIT2        :1;                                       /* Port B Bit 2 */
        byte BIT3        :1;                                       /* Port B Bit 3 */
        byte BIT4        :1;                                       /* Port B Bit 4 */
        byte BIT5        :1;                                       /* Port B Bit 5 */
        byte BIT6        :1;                                       /* Port B Bit 6 */
        byte BIT7        :1;                                       /* Port B Bit 7 */
      } Bits;
    } PORTBSTR;
    #define PORTB                       _PORTAB.Overlap_STR.PORTBSTR.Byte
    #define PORTB_BIT0                  _PORTAB.Overlap_STR.PORTBSTR.Bits.BIT0
    #define PORTB_BIT1                  _PORTAB.Overlap_STR.PORTBSTR.Bits.BIT1
    #define PORTB_BIT2                  _PORTAB.Overlap_STR.PORTBSTR.Bits.BIT2
    #define PORTB_BIT3                  _PORTAB.Overlap_STR.PORTBSTR.Bits.BIT3
    #define PORTB_BIT4                  _PORTAB.Overlap_STR.PORTBSTR.Bits.BIT4
    #define PORTB_BIT5                  _PORTAB.Overlap_STR.PORTBSTR.Bits.BIT5
    #define PORTB_BIT6                  _PORTAB.Overlap_STR.PORTBSTR.Bits.BIT6
    #define PORTB_BIT7                  _PORTAB.Overlap_STR.PORTBSTR.Bits.BIT7
    
    #define PORTB_BIT0_MASK             1U
    #define PORTB_BIT1_MASK             2U
    #define PORTB_BIT2_MASK             4U
    #define PORTB_BIT3_MASK             8U
    #define PORTB_BIT4_MASK             16U
    #define PORTB_BIT5_MASK             32U
    #define PORTB_BIT6_MASK             64U
    #define PORTB_BIT7_MASK             128U
    
  } Overlap_STR;

  struct {
    word BIT0        :1;                                       /* Port AB Bit 0 */
    word BIT1        :1;                                       /* Port AB Bit 1 */
    word BIT2        :1;                                       /* Port AB Bit 2 */
    word BIT3        :1;                                       /* Port AB Bit 3 */
    word BIT4        :1;                                       /* Port AB Bit 4 */
    word BIT5        :1;                                       /* Port AB Bit 5 */
    word BIT6        :1;                                       /* Port AB Bit 6 */
    word BIT7        :1;                                       /* Port AB Bit 7 */
    word BIT8        :1;                                       /* Port AB Bit 8 */
    word BIT9        :1;                                       /* Port AB Bit 9 */
    word BIT10       :1;                                       /* Port AB Bit 10 */
    word BIT11       :1;                                       /* Port AB Bit 11 */
    word BIT12       :1;                                       /* Port AB Bit 12 */
    word BIT13       :1;                                       /* Port AB Bit 13 */
    word BIT14       :1;                                       /* Port AB Bit 14 */
    word BIT15       :1;                                       /* Port AB Bit 15 */
  } Bits;
} PORTABSTR;
extern volatile PORTABSTR _PORTAB @(REG_BASE + 0x00000000UL);
#define PORTAB                          _PORTAB.Word
#define PORTAB_BIT0                     _PORTAB.Bits.BIT0
#define PORTAB_BIT1                     _PORTAB.Bits.BIT1
#define PORTAB_BIT2                     _PORTAB.Bits.BIT2
#define PORTAB_BIT3                     _PORTAB.Bits.BIT3
#define PORTAB_BIT4                     _PORTAB.Bits.BIT4
#define PORTAB_BIT5                     _PORTAB.Bits.BIT5
#define PORTAB_BIT6                     _PORTAB.Bits.BIT6
#define PORTAB_BIT7                     _PORTAB.Bits.BIT7
#define PORTAB_BIT8                     _PORTAB.Bits.BIT8
#define PORTAB_BIT9                     _PORTAB.Bits.BIT9
#define PORTAB_BIT10                    _PORTAB.Bits.BIT10
#define PORTAB_BIT11                    _PORTAB.Bits.BIT11
#define PORTAB_BIT12                    _PORTAB.Bits.BIT12
#define PORTAB_BIT13                    _PORTAB.Bits.BIT13
#define PORTAB_BIT14                    _PORTAB.Bits.BIT14
#define PORTAB_BIT15                    _PORTAB.Bits.BIT15

#define PORTAB_BIT0_MASK                1U
#define PORTAB_BIT1_MASK                2U
#define PORTAB_BIT2_MASK                4U
#define PORTAB_BIT3_MASK                8U
#define PORTAB_BIT4_MASK                16U
#define PORTAB_BIT5_MASK                32U
#define PORTAB_BIT6_MASK                64U
#define PORTAB_BIT7_MASK                128U
#define PORTAB_BIT8_MASK                256U
#define PORTAB_BIT9_MASK                512U
#define PORTAB_BIT10_MASK               1024U
#define PORTAB_BIT11_MASK               2048U
#define PORTAB_BIT12_MASK               4096U
#define PORTAB_BIT13_MASK               8192U
#define PORTAB_BIT14_MASK               16384U
#define PORTAB_BIT15_MASK               32768U


/*** DDRAB - Port AB Data Direction Register; 0x00000002 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** DDRA - Port A Data Direction Register; 0x00000002 ***/
    union {
      byte Byte;
      struct {
        byte BIT0        :1;                                       /* Data Direction Port A Bit 0 */
        byte BIT1        :1;                                       /* Data Direction Port A Bit 1 */
        byte BIT2        :1;                                       /* Data Direction Port A Bit 2 */
        byte BIT3        :1;                                       /* Data Direction Port A Bit 3 */
        byte BIT4        :1;                                       /* Data Direction Port A Bit 4 */
        byte BIT5        :1;                                       /* Data Direction Port A Bit 5 */
        byte BIT6        :1;                                       /* Data Direction Port A Bit 6 */
        byte BIT7        :1;                                       /* Data Direction Port A Bit 7 */
      } Bits;
    } DDRASTR;
    #define DDRA                        _DDRAB.Overlap_STR.DDRASTR.Byte
    #define DDRA_BIT0                   _DDRAB.Overlap_STR.DDRASTR.Bits.BIT0
    #define DDRA_BIT1                   _DDRAB.Overlap_STR.DDRASTR.Bits.BIT1
    #define DDRA_BIT2                   _DDRAB.Overlap_STR.DDRASTR.Bits.BIT2
    #define DDRA_BIT3                   _DDRAB.Overlap_STR.DDRASTR.Bits.BIT3
    #define DDRA_BIT4                   _DDRAB.Overlap_STR.DDRASTR.Bits.BIT4
    #define DDRA_BIT5                   _DDRAB.Overlap_STR.DDRASTR.Bits.BIT5
    #define DDRA_BIT6                   _DDRAB.Overlap_STR.DDRASTR.Bits.BIT6
    #define DDRA_BIT7                   _DDRAB.Overlap_STR.DDRASTR.Bits.BIT7
    
    #define DDRA_BIT0_MASK              1U
    #define DDRA_BIT1_MASK              2U
    #define DDRA_BIT2_MASK              4U
    #define DDRA_BIT3_MASK              8U
    #define DDRA_BIT4_MASK              16U
    #define DDRA_BIT5_MASK              32U
    #define DDRA_BIT6_MASK              64U
    #define DDRA_BIT7_MASK              128U
    

    /*** DDRB - Port B Data Direction Register; 0x00000003 ***/
    union {
      byte Byte;
      struct {
        byte BIT0        :1;                                       /* Data Direction Port B Bit 0 */
        byte BIT1        :1;                                       /* Data Direction Port B Bit 1 */
        byte BIT2        :1;                                       /* Data Direction Port B Bit 2 */
        byte BIT3        :1;                                       /* Data Direction Port B Bit 3 */
        byte BIT4        :1;                                       /* Data Direction Port B Bit 4 */
        byte BIT5        :1;                                       /* Data Direction Port B Bit 5 */
        byte BIT6        :1;                                       /* Data Direction Port B Bit 6 */
        byte BIT7        :1;                                       /* Data Direction Port B Bit 7 */
      } Bits;
    } DDRBSTR;
    #define DDRB                        _DDRAB.Overlap_STR.DDRBSTR.Byte
    #define DDRB_BIT0                   _DDRAB.Overlap_STR.DDRBSTR.Bits.BIT0
    #define DDRB_BIT1                   _DDRAB.Overlap_STR.DDRBSTR.Bits.BIT1
    #define DDRB_BIT2                   _DDRAB.Overlap_STR.DDRBSTR.Bits.BIT2
    #define DDRB_BIT3                   _DDRAB.Overlap_STR.DDRBSTR.Bits.BIT3
    #define DDRB_BIT4                   _DDRAB.Overlap_STR.DDRBSTR.Bits.BIT4
    #define DDRB_BIT5                   _DDRAB.Overlap_STR.DDRBSTR.Bits.BIT5
    #define DDRB_BIT6                   _DDRAB.Overlap_STR.DDRBSTR.Bits.BIT6
    #define DDRB_BIT7                   _DDRAB.Overlap_STR.DDRBSTR.Bits.BIT7
    
    #define DDRB_BIT0_MASK              1U
    #define DDRB_BIT1_MASK              2U
    #define DDRB_BIT2_MASK              4U
    #define DDRB_BIT3_MASK              8U
    #define DDRB_BIT4_MASK              16U
    #define DDRB_BIT5_MASK              32U
    #define DDRB_BIT6_MASK              64U
    #define DDRB_BIT7_MASK              128U
    
  } Overlap_STR;

  struct {
    word BIT0        :1;                                       /* Data Direction Port B Bit 0 */
    word BIT1        :1;                                       /* Data Direction Port B Bit 1 */
    word BIT2        :1;                                       /* Data Direction Port B Bit 2 */
    word BIT3        :1;                                       /* Data Direction Port B Bit 3 */
    word BIT4        :1;                                       /* Data Direction Port B Bit 4 */
    word BIT5        :1;                                       /* Data Direction Port B Bit 5 */
    word BIT6        :1;                                       /* Data Direction Port B Bit 6 */
    word BIT7        :1;                                       /* Data Direction Port B Bit 7 */
    word BIT8        :1;                                       /* Data Direction Port A Bit 8 */
    word BIT9        :1;                                       /* Data Direction Port A Bit 9 */
    word BIT10       :1;                                       /* Data Direction Port A Bit 10 */
    word BIT11       :1;                                       /* Data Direction Port A Bit 11 */
    word BIT12       :1;                                       /* Data Direction Port A Bit 12 */
    word BIT13       :1;                                       /* Data Direction Port A Bit 13 */
    word BIT14       :1;                                       /* Data Direction Port A Bit 14 */
    word BIT15       :1;                                       /* Data Direction Port A Bit 15 */
  } Bits;
} DDRABSTR;
extern volatile DDRABSTR _DDRAB @(REG_BASE + 0x00000002UL);
#define DDRAB                           _DDRAB.Word
#define DDRAB_BIT0                      _DDRAB.Bits.BIT0
#define DDRAB_BIT1                      _DDRAB.Bits.BIT1
#define DDRAB_BIT2                      _DDRAB.Bits.BIT2
#define DDRAB_BIT3                      _DDRAB.Bits.BIT3
#define DDRAB_BIT4                      _DDRAB.Bits.BIT4
#define DDRAB_BIT5                      _DDRAB.Bits.BIT5
#define DDRAB_BIT6                      _DDRAB.Bits.BIT6
#define DDRAB_BIT7                      _DDRAB.Bits.BIT7
#define DDRAB_BIT8                      _DDRAB.Bits.BIT8
#define DDRAB_BIT9                      _DDRAB.Bits.BIT9
#define DDRAB_BIT10                     _DDRAB.Bits.BIT10
#define DDRAB_BIT11                     _DDRAB.Bits.BIT11
#define DDRAB_BIT12                     _DDRAB.Bits.BIT12
#define DDRAB_BIT13                     _DDRAB.Bits.BIT13
#define DDRAB_BIT14                     _DDRAB.Bits.BIT14
#define DDRAB_BIT15                     _DDRAB.Bits.BIT15

#define DDRAB_BIT0_MASK                 1U
#define DDRAB_BIT1_MASK                 2U
#define DDRAB_BIT2_MASK                 4U
#define DDRAB_BIT3_MASK                 8U
#define DDRAB_BIT4_MASK                 16U
#define DDRAB_BIT5_MASK                 32U
#define DDRAB_BIT6_MASK                 64U
#define DDRAB_BIT7_MASK                 128U
#define DDRAB_BIT8_MASK                 256U
#define DDRAB_BIT9_MASK                 512U
#define DDRAB_BIT10_MASK                1024U
#define DDRAB_BIT11_MASK                2048U
#define DDRAB_BIT12_MASK                4096U
#define DDRAB_BIT13_MASK                8192U
#define DDRAB_BIT14_MASK                16384U
#define DDRAB_BIT15_MASK                32768U


/*** PORTE - Port E Register; 0x00000008 ***/
typedef union {
  byte Byte;
  struct {
    byte BIT0        :1;                                       /* Port E Bit 0 */
    byte BIT1        :1;                                       /* Port E Bit 1 */
    byte BIT2        :1;                                       /* Port E Bit 2 */
    byte BIT3        :1;                                       /* Port E Bit 3 */
    byte BIT4        :1;                                       /* Port E Bit 4 */
    byte BIT5        :1;                                       /* Port E Bit 5 */
    byte BIT6        :1;                                       /* Port E Bit 6 */
    byte BIT7        :1;                                       /* Port E Bit 7 */
  } Bits;
} PORTESTR;
extern volatile PORTESTR _PORTE @(REG_BASE + 0x00000008UL);
#define PORTE                           _PORTE.Byte
#define PORTE_BIT0                      _PORTE.Bits.BIT0
#define PORTE_BIT1                      _PORTE.Bits.BIT1
#define PORTE_BIT2                      _PORTE.Bits.BIT2
#define PORTE_BIT3                      _PORTE.Bits.BIT3
#define PORTE_BIT4                      _PORTE.Bits.BIT4
#define PORTE_BIT5                      _PORTE.Bits.BIT5
#define PORTE_BIT6                      _PORTE.Bits.BIT6
#define PORTE_BIT7                      _PORTE.Bits.BIT7

#define PORTE_BIT0_MASK                 1U
#define PORTE_BIT1_MASK                 2U
#define PORTE_BIT2_MASK                 4U
#define PORTE_BIT3_MASK                 8U
#define PORTE_BIT4_MASK                 16U
#define PORTE_BIT5_MASK                 32U
#define PORTE_BIT6_MASK                 64U
#define PORTE_BIT7_MASK                 128U


/*** DDRE - Port E Data Direction Register; 0x00000009 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte BIT2        :1;                                       /* Data Direction Port E Bit 2 */
    byte BIT3        :1;                                       /* Data Direction Port E Bit 3 */
    byte BIT4        :1;                                       /* Data Direction Port E Bit 4 */
    byte BIT5        :1;                                       /* Data Direction Port E Bit 5 */
    byte BIT6        :1;                                       /* Data Direction Port E Bit 6 */
    byte BIT7        :1;                                       /* Data Direction Port E Bit 7 */
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte grpBIT_2 :6;
  } MergedBits;
} DDRESTR;
extern volatile DDRESTR _DDRE @(REG_BASE + 0x00000009UL);
#define DDRE                            _DDRE.Byte
#define DDRE_BIT2                       _DDRE.Bits.BIT2
#define DDRE_BIT3                       _DDRE.Bits.BIT3
#define DDRE_BIT4                       _DDRE.Bits.BIT4
#define DDRE_BIT5                       _DDRE.Bits.BIT5
#define DDRE_BIT6                       _DDRE.Bits.BIT6
#define DDRE_BIT7                       _DDRE.Bits.BIT7
#define DDRE_BIT_2                      _DDRE.MergedBits.grpBIT_2
#define DDRE_BIT                        DDRE_BIT_2

#define DDRE_BIT2_MASK                  4U
#define DDRE_BIT3_MASK                  8U
#define DDRE_BIT4_MASK                  16U
#define DDRE_BIT5_MASK                  32U
#define DDRE_BIT6_MASK                  64U
#define DDRE_BIT7_MASK                  128U
#define DDRE_BIT_2_MASK                 252U
#define DDRE_BIT_2_BITNUM               2U


/*** PEAR - Port E Assignment Register; 0x0000000A ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte RDWE        :1;                                       /* Read / Write Enable */
    byte LSTRE       :1;                                       /* Low Strobe (LSTRB) Enable */
    byte NECLK       :1;                                       /* No External E Clock */
    byte PIPOE       :1;                                       /* Pipe Status Signal Output Enable */
    byte             :1; 
    byte NOACCE      :1;                                       /* CPU No Access Output Enable */
  } Bits;
} PEARSTR;
extern volatile PEARSTR _PEAR @(REG_BASE + 0x0000000AUL);
#define PEAR                            _PEAR.Byte
#define PEAR_RDWE                       _PEAR.Bits.RDWE
#define PEAR_LSTRE                      _PEAR.Bits.LSTRE
#define PEAR_NECLK                      _PEAR.Bits.NECLK
#define PEAR_PIPOE                      _PEAR.Bits.PIPOE
#define PEAR_NOACCE                     _PEAR.Bits.NOACCE

#define PEAR_RDWE_MASK                  4U
#define PEAR_LSTRE_MASK                 8U
#define PEAR_NECLK_MASK                 16U
#define PEAR_PIPOE_MASK                 32U
#define PEAR_NOACCE_MASK                128U


/*** MODE - Mode Register; 0x0000000B ***/
typedef union {
  byte Byte;
  struct {
    byte EME         :1;                                       /* Emulate Port E */
    byte EMK         :1;                                       /* Emulate Port K */
    byte             :1; 
    byte IVIS        :1;                                       /* Internal Visibility */
    byte             :1; 
    byte MODA        :1;                                       /* Mode Select Bit A */
    byte MODB        :1;                                       /* Mode Select Bit B */
    byte MODC        :1;                                       /* Mode Select Bit C */
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte grpMODx :3;
  } MergedBits;
} MODESTR;
extern volatile MODESTR _MODE @(REG_BASE + 0x0000000BUL);
#define MODE                            _MODE.Byte
#define MODE_EME                        _MODE.Bits.EME
#define MODE_EMK                        _MODE.Bits.EMK
#define MODE_IVIS                       _MODE.Bits.IVIS
#define MODE_MODA                       _MODE.Bits.MODA
#define MODE_MODB                       _MODE.Bits.MODB
#define MODE_MODC                       _MODE.Bits.MODC
#define MODE_MODx                       _MODE.MergedBits.grpMODx

#define MODE_EME_MASK                   1U
#define MODE_EMK_MASK                   2U
#define MODE_IVIS_MASK                  8U
#define MODE_MODA_MASK                  32U
#define MODE_MODB_MASK                  64U
#define MODE_MODC_MASK                  128U
#define MODE_MODx_MASK                  224U
#define MODE_MODx_BITNUM                5U


/*** PUCR - Pull-Up Control Register; 0x0000000C ***/
typedef union {
  byte Byte;
  struct {
    byte PUPAE       :1;                                       /* Pull-Up Port A Enable */
    byte PUPBE       :1;                                       /* Pull-Up Port B Enable */
    byte             :1; 
    byte             :1; 
    byte PUPEE       :1;                                       /* Pull-Up Port E Enable */
    byte             :1; 
    byte             :1; 
    byte PUPKE       :1;                                       /* Pull-Up Port K Enable */
  } Bits;
} PUCRSTR;
extern volatile PUCRSTR _PUCR @(REG_BASE + 0x0000000CUL);
#define PUCR                            _PUCR.Byte
#define PUCR_PUPAE                      _PUCR.Bits.PUPAE
#define PUCR_PUPBE                      _PUCR.Bits.PUPBE
#define PUCR_PUPEE                      _PUCR.Bits.PUPEE
#define PUCR_PUPKE                      _PUCR.Bits.PUPKE

#define PUCR_PUPAE_MASK                 1U
#define PUCR_PUPBE_MASK                 2U
#define PUCR_PUPEE_MASK                 16U
#define PUCR_PUPKE_MASK                 128U


/*** RDRIV - Reduced Drive of I/O Lines; 0x0000000D ***/
typedef union {
  byte Byte;
  struct {
    byte RDPA        :1;                                       /* Reduced Drive of Port A */
    byte RDPB        :1;                                       /* Reduced Drive of Port B */
    byte             :1; 
    byte             :1; 
    byte RDPE        :1;                                       /* Reduced Drive of Port E */
    byte             :1; 
    byte             :1; 
    byte RDPK        :1;                                       /* Reduced Drive of Port K */
  } Bits;
  struct {
    byte grpRDPx :2;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} RDRIVSTR;
extern volatile RDRIVSTR _RDRIV @(REG_BASE + 0x0000000DUL);
#define RDRIV                           _RDRIV.Byte
#define RDRIV_RDPA                      _RDRIV.Bits.RDPA
#define RDRIV_RDPB                      _RDRIV.Bits.RDPB
#define RDRIV_RDPE                      _RDRIV.Bits.RDPE
#define RDRIV_RDPK                      _RDRIV.Bits.RDPK
#define RDRIV_RDPx                      _RDRIV.MergedBits.grpRDPx

#define RDRIV_RDPA_MASK                 1U
#define RDRIV_RDPB_MASK                 2U
#define RDRIV_RDPE_MASK                 16U
#define RDRIV_RDPK_MASK                 128U
#define RDRIV_RDPx_MASK                 3U
#define RDRIV_RDPx_BITNUM               0U


/*** EBICTL - External Bus Interface Control; 0x0000000E ***/
typedef union {
  byte Byte;
  struct {
    byte ESTR        :1;                                       /* E Stretches */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} EBICTLSTR;
extern volatile EBICTLSTR _EBICTL @(REG_BASE + 0x0000000EUL);
#define EBICTL                          _EBICTL.Byte
#define EBICTL_ESTR                     _EBICTL.Bits.ESTR

#define EBICTL_ESTR_MASK                1U


/*** INITRM - Initialization of Internal RAM Position Register; 0x00000010 ***/
typedef union {
  byte Byte;
  struct {
    byte RAMHAL      :1;                                       /* Internal RAM map alignment */
    byte             :1; 
    byte             :1; 
    byte RAM11       :1;                                       /* Internal RAM map position Bit 11 */
    byte RAM12       :1;                                       /* Internal RAM map position Bit 12 */
    byte RAM13       :1;                                       /* Internal RAM map position Bit 13 */
    byte RAM14       :1;                                       /* Internal RAM map position Bit 14 */
    byte RAM15       :1;                                       /* Internal RAM map position Bit 15 */
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte         :1;
    byte grpRAM_11 :5;
  } MergedBits;
} INITRMSTR;
extern volatile INITRMSTR _INITRM @(REG_BASE + 0x00000010UL);
#define INITRM                          _INITRM.Byte
#define INITRM_RAMHAL                   _INITRM.Bits.RAMHAL
#define INITRM_RAM11                    _INITRM.Bits.RAM11
#define INITRM_RAM12                    _INITRM.Bits.RAM12
#define INITRM_RAM13                    _INITRM.Bits.RAM13
#define INITRM_RAM14                    _INITRM.Bits.RAM14
#define INITRM_RAM15                    _INITRM.Bits.RAM15
#define INITRM_RAM_11                   _INITRM.MergedBits.grpRAM_11
#define INITRM_RAM                      INITRM_RAM_11

#define INITRM_RAMHAL_MASK              1U
#define INITRM_RAM11_MASK               8U
#define INITRM_RAM12_MASK               16U
#define INITRM_RAM13_MASK               32U
#define INITRM_RAM14_MASK               64U
#define INITRM_RAM15_MASK               128U
#define INITRM_RAM_11_MASK              248U
#define INITRM_RAM_11_BITNUM            3U


/*** INITRG - Initialization of Internal Registers Position Register; 0x00000011 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte REG11       :1;                                       /* Internal Registers Map Position Bit 11 */
    byte REG12       :1;                                       /* Internal Registers Map Position Bit 12 */
    byte REG13       :1;                                       /* Internal Registers Map Position Bit 13 */
    byte REG14       :1;                                       /* Internal Registers Map Position Bit 14 */
    byte             :1; 
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte         :1;
    byte grpREG_11 :4;
    byte         :1;
  } MergedBits;
} INITRGSTR;
extern volatile INITRGSTR _INITRG @(REG_BASE + 0x00000011UL);
#define INITRG                          _INITRG.Byte
#define INITRG_REG11                    _INITRG.Bits.REG11
#define INITRG_REG12                    _INITRG.Bits.REG12
#define INITRG_REG13                    _INITRG.Bits.REG13
#define INITRG_REG14                    _INITRG.Bits.REG14
#define INITRG_REG_11                   _INITRG.MergedBits.grpREG_11
#define INITRG_REG                      INITRG_REG_11

#define INITRG_REG11_MASK               8U
#define INITRG_REG12_MASK               16U
#define INITRG_REG13_MASK               32U
#define INITRG_REG14_MASK               64U
#define INITRG_REG_11_MASK              120U
#define INITRG_REG_11_BITNUM            3U


/*** MISC - Miscellaneous System Control Register; 0x00000013 ***/
typedef union {
  byte Byte;
  struct {
    byte ROMON       :1;                                       /* Enable Flash EEPROM */
    byte ROMHM       :1;                                       /* Flash EEPROM only in second half of memory map */
    byte EXSTR0      :1;                                       /* External Access Stretch Bit 0 */
    byte EXSTR1      :1;                                       /* External Access Stretch Bit 1 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte grpEXSTR :2;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} MISCSTR;
extern volatile MISCSTR _MISC @(REG_BASE + 0x00000013UL);
#define MISC                            _MISC.Byte
#define MISC_ROMON                      _MISC.Bits.ROMON
#define MISC_ROMHM                      _MISC.Bits.ROMHM
#define MISC_EXSTR0                     _MISC.Bits.EXSTR0
#define MISC_EXSTR1                     _MISC.Bits.EXSTR1
#define MISC_EXSTR                      _MISC.MergedBits.grpEXSTR

#define MISC_ROMON_MASK                 1U
#define MISC_ROMHM_MASK                 2U
#define MISC_EXSTR0_MASK                4U
#define MISC_EXSTR1_MASK                8U
#define MISC_EXSTR_MASK                 12U
#define MISC_EXSTR_BITNUM               2U


/*** ITCR - Interrupt Test Control Register; 0x00000015 ***/
typedef union {
  byte Byte;
  struct {
    byte ADR0        :1;                                       /* Test register select Bit 0 */
    byte ADR1        :1;                                       /* Test register select Bit 1 */
    byte ADR2        :1;                                       /* Test register select Bit 2 */
    byte ADR3        :1;                                       /* Test register select Bit 3 */
    byte WRTINT      :1;                                       /* Write to the Interrupt Test Registers */
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpADR  :4;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} ITCRSTR;
extern volatile ITCRSTR _ITCR @(REG_BASE + 0x00000015UL);
#define ITCR                            _ITCR.Byte
#define ITCR_ADR0                       _ITCR.Bits.ADR0
#define ITCR_ADR1                       _ITCR.Bits.ADR1
#define ITCR_ADR2                       _ITCR.Bits.ADR2
#define ITCR_ADR3                       _ITCR.Bits.ADR3
#define ITCR_WRTINT                     _ITCR.Bits.WRTINT
#define ITCR_ADR                        _ITCR.MergedBits.grpADR

#define ITCR_ADR0_MASK                  1U
#define ITCR_ADR1_MASK                  2U
#define ITCR_ADR2_MASK                  4U
#define ITCR_ADR3_MASK                  8U
#define ITCR_WRTINT_MASK                16U
#define ITCR_ADR_MASK                   15U
#define ITCR_ADR_BITNUM                 0U


/*** ITEST - Interrupt Test Register; 0x00000016 ***/
typedef union {
  byte Byte;
  struct {
    byte INT0        :1;                                       /* Interrupt Test Register Bit 0 */
    byte INT2        :1;                                       /* Interrupt Test Register Bit 1 */
    byte INT4        :1;                                       /* Interrupt Test Register Bit 2 */
    byte INT6        :1;                                       /* Interrupt Test Register Bit 3 */
    byte INT8        :1;                                       /* Interrupt Test Register Bit 4 */
    byte INTA        :1;                                       /* Interrupt Test Register Bit 5 */
    byte INTC        :1;                                       /* Interrupt Test Register Bit 6 */
    byte INTE        :1;                                       /* Interrupt Test Register Bit 7 */
  } Bits;
} ITESTSTR;
extern volatile ITESTSTR _ITEST @(REG_BASE + 0x00000016UL);
#define ITEST                           _ITEST.Byte
#define ITEST_INT0                      _ITEST.Bits.INT0
#define ITEST_INT2                      _ITEST.Bits.INT2
#define ITEST_INT4                      _ITEST.Bits.INT4
#define ITEST_INT6                      _ITEST.Bits.INT6
#define ITEST_INT8                      _ITEST.Bits.INT8
#define ITEST_INTA                      _ITEST.Bits.INTA
#define ITEST_INTC                      _ITEST.Bits.INTC
#define ITEST_INTE                      _ITEST.Bits.INTE

#define ITEST_INT0_MASK                 1U
#define ITEST_INT2_MASK                 2U
#define ITEST_INT4_MASK                 4U
#define ITEST_INT6_MASK                 8U
#define ITEST_INT8_MASK                 16U
#define ITEST_INTA_MASK                 32U
#define ITEST_INTC_MASK                 64U
#define ITEST_INTE_MASK                 128U


/*** VREGCTRL - VREG_3V3 - Control Register; 0x00000019 ***/
typedef union {
  byte Byte;
  struct {
    byte LVIF        :1;                                       /* Low Voltage Interrupt Flag */
    byte LVIE        :1;                                       /* Low Voltage Interrupt Enable Bit */
    byte LVDS        :1;                                       /* Low Voltage Detect Status Bit */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} VREGCTRLSTR;
extern volatile VREGCTRLSTR _VREGCTRL @(REG_BASE + 0x00000019UL);
#define VREGCTRL                        _VREGCTRL.Byte
#define VREGCTRL_LVIF                   _VREGCTRL.Bits.LVIF
#define VREGCTRL_LVIE                   _VREGCTRL.Bits.LVIE
#define VREGCTRL_LVDS                   _VREGCTRL.Bits.LVDS

#define VREGCTRL_LVIF_MASK              1U
#define VREGCTRL_LVIE_MASK              2U
#define VREGCTRL_LVDS_MASK              4U


/*** PARTID - Part ID Register; 0x0000001A ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** PARTIDH - Part ID Register High; 0x0000001A ***/
    union {
      byte Byte;
      struct {
        byte ID8         :1;                                       /* Part ID Register Bit 8 */
        byte ID9         :1;                                       /* Part ID Register Bit 9 */
        byte ID10        :1;                                       /* Part ID Register Bit 10 */
        byte ID11        :1;                                       /* Part ID Register Bit 11 */
        byte ID12        :1;                                       /* Part ID Register Bit 12 */
        byte ID13        :1;                                       /* Part ID Register Bit 13 */
        byte ID14        :1;                                       /* Part ID Register Bit 14 */
        byte ID15        :1;                                       /* Part ID Register Bit 15 */
      } Bits;
    } PARTIDHSTR;
    #define PARTIDH                     _PARTID.Overlap_STR.PARTIDHSTR.Byte
    #define PARTIDH_ID8                 _PARTID.Overlap_STR.PARTIDHSTR.Bits.ID8
    #define PARTIDH_ID9                 _PARTID.Overlap_STR.PARTIDHSTR.Bits.ID9
    #define PARTIDH_ID10                _PARTID.Overlap_STR.PARTIDHSTR.Bits.ID10
    #define PARTIDH_ID11                _PARTID.Overlap_STR.PARTIDHSTR.Bits.ID11
    #define PARTIDH_ID12                _PARTID.Overlap_STR.PARTIDHSTR.Bits.ID12
    #define PARTIDH_ID13                _PARTID.Overlap_STR.PARTIDHSTR.Bits.ID13
    #define PARTIDH_ID14                _PARTID.Overlap_STR.PARTIDHSTR.Bits.ID14
    #define PARTIDH_ID15                _PARTID.Overlap_STR.PARTIDHSTR.Bits.ID15
    
    #define PARTIDH_ID8_MASK            1U
    #define PARTIDH_ID9_MASK            2U
    #define PARTIDH_ID10_MASK           4U
    #define PARTIDH_ID11_MASK           8U
    #define PARTIDH_ID12_MASK           16U
    #define PARTIDH_ID13_MASK           32U
    #define PARTIDH_ID14_MASK           64U
    #define PARTIDH_ID15_MASK           128U
    

    /*** PARTIDL - Part ID Register Low; 0x0000001B ***/
    union {
      byte Byte;
      struct {
        byte ID0         :1;                                       /* Part ID Register Bit 0 */
        byte ID1         :1;                                       /* Part ID Register Bit 1 */
        byte ID2         :1;                                       /* Part ID Register Bit 2 */
        byte ID3         :1;                                       /* Part ID Register Bit 3 */
        byte ID4         :1;                                       /* Part ID Register Bit 4 */
        byte ID5         :1;                                       /* Part ID Register Bit 5 */
        byte ID6         :1;                                       /* Part ID Register Bit 6 */
        byte ID7         :1;                                       /* Part ID Register Bit 7 */
      } Bits;
    } PARTIDLSTR;
    #define PARTIDL                     _PARTID.Overlap_STR.PARTIDLSTR.Byte
    #define PARTIDL_ID0                 _PARTID.Overlap_STR.PARTIDLSTR.Bits.ID0
    #define PARTIDL_ID1                 _PARTID.Overlap_STR.PARTIDLSTR.Bits.ID1
    #define PARTIDL_ID2                 _PARTID.Overlap_STR.PARTIDLSTR.Bits.ID2
    #define PARTIDL_ID3                 _PARTID.Overlap_STR.PARTIDLSTR.Bits.ID3
    #define PARTIDL_ID4                 _PARTID.Overlap_STR.PARTIDLSTR.Bits.ID4
    #define PARTIDL_ID5                 _PARTID.Overlap_STR.PARTIDLSTR.Bits.ID5
    #define PARTIDL_ID6                 _PARTID.Overlap_STR.PARTIDLSTR.Bits.ID6
    #define PARTIDL_ID7                 _PARTID.Overlap_STR.PARTIDLSTR.Bits.ID7
    
    #define PARTIDL_ID0_MASK            1U
    #define PARTIDL_ID1_MASK            2U
    #define PARTIDL_ID2_MASK            4U
    #define PARTIDL_ID3_MASK            8U
    #define PARTIDL_ID4_MASK            16U
    #define PARTIDL_ID5_MASK            32U
    #define PARTIDL_ID6_MASK            64U
    #define PARTIDL_ID7_MASK            128U
    
  } Overlap_STR;

  struct {
    word ID0         :1;                                       /* Part ID Register Bit 0 */
    word ID1         :1;                                       /* Part ID Register Bit 1 */
    word ID2         :1;                                       /* Part ID Register Bit 2 */
    word ID3         :1;                                       /* Part ID Register Bit 3 */
    word ID4         :1;                                       /* Part ID Register Bit 4 */
    word ID5         :1;                                       /* Part ID Register Bit 5 */
    word ID6         :1;                                       /* Part ID Register Bit 6 */
    word ID7         :1;                                       /* Part ID Register Bit 7 */
    word ID8         :1;                                       /* Part ID Register Bit 8 */
    word ID9         :1;                                       /* Part ID Register Bit 9 */
    word ID10        :1;                                       /* Part ID Register Bit 10 */
    word ID11        :1;                                       /* Part ID Register Bit 11 */
    word ID12        :1;                                       /* Part ID Register Bit 12 */
    word ID13        :1;                                       /* Part ID Register Bit 13 */
    word ID14        :1;                                       /* Part ID Register Bit 14 */
    word ID15        :1;                                       /* Part ID Register Bit 15 */
  } Bits;
} PARTIDSTR;
extern volatile PARTIDSTR _PARTID @(REG_BASE + 0x0000001AUL);
#define PARTID                          _PARTID.Word
#define PARTID_ID0                      _PARTID.Bits.ID0
#define PARTID_ID1                      _PARTID.Bits.ID1
#define PARTID_ID2                      _PARTID.Bits.ID2
#define PARTID_ID3                      _PARTID.Bits.ID3
#define PARTID_ID4                      _PARTID.Bits.ID4
#define PARTID_ID5                      _PARTID.Bits.ID5
#define PARTID_ID6                      _PARTID.Bits.ID6
#define PARTID_ID7                      _PARTID.Bits.ID7
#define PARTID_ID8                      _PARTID.Bits.ID8
#define PARTID_ID9                      _PARTID.Bits.ID9
#define PARTID_ID10                     _PARTID.Bits.ID10
#define PARTID_ID11                     _PARTID.Bits.ID11
#define PARTID_ID12                     _PARTID.Bits.ID12
#define PARTID_ID13                     _PARTID.Bits.ID13
#define PARTID_ID14                     _PARTID.Bits.ID14
#define PARTID_ID15                     _PARTID.Bits.ID15

#define PARTID_ID0_MASK                 1U
#define PARTID_ID1_MASK                 2U
#define PARTID_ID2_MASK                 4U
#define PARTID_ID3_MASK                 8U
#define PARTID_ID4_MASK                 16U
#define PARTID_ID5_MASK                 32U
#define PARTID_ID6_MASK                 64U
#define PARTID_ID7_MASK                 128U
#define PARTID_ID8_MASK                 256U
#define PARTID_ID9_MASK                 512U
#define PARTID_ID10_MASK                1024U
#define PARTID_ID11_MASK                2048U
#define PARTID_ID12_MASK                4096U
#define PARTID_ID13_MASK                8192U
#define PARTID_ID14_MASK                16384U
#define PARTID_ID15_MASK                32768U


/*** MEMSIZ0 - Memory Size Register Zero; 0x0000001C ***/
typedef union {
  byte Byte;
  struct {
    byte ram_sw0     :1;                                       /* Allocated System RAM Memory Space Bit 0 */
    byte ram_sw1     :1;                                       /* Allocated System RAM Memory Space Bit 1 */
    byte ram_sw2     :1;                                       /* Allocated System RAM Memory Space Bit 2 */
    byte             :1; 
    byte eep_sw0     :1;                                       /* Allocated EEPROM Memory Space Bit 0 */
    byte eep_sw1     :1;                                       /* Allocated EEPROM Memory Space Bit 1 */
    byte             :1; 
    byte reg_sw0     :1;                                       /* Allocated System Register Space */
  } Bits;
  struct {
    byte grpram_sw :3;
    byte         :1;
    byte grpeep_sw :2;
    byte         :1;
    byte grpreg_sw :1;
  } MergedBits;
} MEMSIZ0STR;
extern volatile MEMSIZ0STR _MEMSIZ0 @(REG_BASE + 0x0000001CUL);
#define MEMSIZ0                         _MEMSIZ0.Byte
#define MEMSIZ0_ram_sw0                 _MEMSIZ0.Bits.ram_sw0
#define MEMSIZ0_ram_sw1                 _MEMSIZ0.Bits.ram_sw1
#define MEMSIZ0_ram_sw2                 _MEMSIZ0.Bits.ram_sw2
#define MEMSIZ0_eep_sw0                 _MEMSIZ0.Bits.eep_sw0
#define MEMSIZ0_eep_sw1                 _MEMSIZ0.Bits.eep_sw1
#define MEMSIZ0_reg_sw0                 _MEMSIZ0.Bits.reg_sw0
/* MEMSIZ_ARR: Access 2 MEMSIZx registers in an array */
#define MEMSIZ_ARR                      ((volatile byte *) &MEMSIZ0)
#define MEMSIZ0_ram_sw                  _MEMSIZ0.MergedBits.grpram_sw
#define MEMSIZ0_eep_sw                  _MEMSIZ0.MergedBits.grpeep_sw

#define MEMSIZ0_ram_sw0_MASK            1U
#define MEMSIZ0_ram_sw1_MASK            2U
#define MEMSIZ0_ram_sw2_MASK            4U
#define MEMSIZ0_eep_sw0_MASK            16U
#define MEMSIZ0_eep_sw1_MASK            32U
#define MEMSIZ0_reg_sw0_MASK            128U
#define MEMSIZ0_ram_sw_MASK             7U
#define MEMSIZ0_ram_sw_BITNUM           0U
#define MEMSIZ0_eep_sw_MASK             48U
#define MEMSIZ0_eep_sw_BITNUM           4U


/*** MEMSIZ1 - Memory Size Register One; 0x0000001D ***/
typedef union {
  byte Byte;
  struct {
    byte pag_sw0     :1;                                       /* Allocated Off-Chip Memory Options Bit 0 */
    byte pag_sw1     :1;                                       /* Allocated Off-Chip Memory Options Bit 1 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte rom_sw0     :1;                                       /* Allocated Flash EEPROM/ROM Physical Memory Space Bit 0 */
    byte rom_sw1     :1;                                       /* Allocated Flash EEPROM/ROM Physical Memory Space Bit 1 */
  } Bits;
  struct {
    byte grppag_sw :2;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte grprom_sw :2;
  } MergedBits;
} MEMSIZ1STR;
extern volatile MEMSIZ1STR _MEMSIZ1 @(REG_BASE + 0x0000001DUL);
#define MEMSIZ1                         _MEMSIZ1.Byte
#define MEMSIZ1_pag_sw0                 _MEMSIZ1.Bits.pag_sw0
#define MEMSIZ1_pag_sw1                 _MEMSIZ1.Bits.pag_sw1
#define MEMSIZ1_rom_sw0                 _MEMSIZ1.Bits.rom_sw0
#define MEMSIZ1_rom_sw1                 _MEMSIZ1.Bits.rom_sw1
#define MEMSIZ1_pag_sw                  _MEMSIZ1.MergedBits.grppag_sw
#define MEMSIZ1_rom_sw                  _MEMSIZ1.MergedBits.grprom_sw

#define MEMSIZ1_pag_sw0_MASK            1U
#define MEMSIZ1_pag_sw1_MASK            2U
#define MEMSIZ1_rom_sw0_MASK            64U
#define MEMSIZ1_rom_sw1_MASK            128U
#define MEMSIZ1_pag_sw_MASK             3U
#define MEMSIZ1_pag_sw_BITNUM           0U
#define MEMSIZ1_rom_sw_MASK             192U
#define MEMSIZ1_rom_sw_BITNUM           6U


/*** INTCR - Interrupt Control Register; 0x0000001E ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte IRQEN       :1;                                       /* External IRQ Enable */
    byte IRQE        :1;                                       /* IRQ Select Edge Sensitive Only */
  } Bits;
} INTCRSTR;
extern volatile INTCRSTR _INTCR @(REG_BASE + 0x0000001EUL);
#define INTCR                           _INTCR.Byte
#define INTCR_IRQEN                     _INTCR.Bits.IRQEN
#define INTCR_IRQE                      _INTCR.Bits.IRQE

#define INTCR_IRQEN_MASK                64U
#define INTCR_IRQE_MASK                 128U


/*** HPRIO - Highest Priority I Interrupt; 0x0000001F ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte PSEL1       :1;                                       /* Highest Priority I Interrupt Bit 1 */
    byte PSEL2       :1;                                       /* Highest Priority I Interrupt Bit 2 */
    byte PSEL3       :1;                                       /* Highest Priority I Interrupt Bit 3 */
    byte PSEL4       :1;                                       /* Highest Priority I Interrupt Bit 4 */
    byte PSEL5       :1;                                       /* Highest Priority I Interrupt Bit 5 */
    byte PSEL6       :1;                                       /* Highest Priority I Interrupt Bit 6 */
    byte PSEL7       :1;                                       /* Highest Priority I Interrupt Bit 7 */
  } Bits;
  struct {
    byte         :1;
    byte grpPSEL_1 :7;
  } MergedBits;
} HPRIOSTR;
extern volatile HPRIOSTR _HPRIO @(REG_BASE + 0x0000001FUL);
#define HPRIO                           _HPRIO.Byte
#define HPRIO_PSEL1                     _HPRIO.Bits.PSEL1
#define HPRIO_PSEL2                     _HPRIO.Bits.PSEL2
#define HPRIO_PSEL3                     _HPRIO.Bits.PSEL3
#define HPRIO_PSEL4                     _HPRIO.Bits.PSEL4
#define HPRIO_PSEL5                     _HPRIO.Bits.PSEL5
#define HPRIO_PSEL6                     _HPRIO.Bits.PSEL6
#define HPRIO_PSEL7                     _HPRIO.Bits.PSEL7
#define HPRIO_PSEL_1                    _HPRIO.MergedBits.grpPSEL_1
#define HPRIO_PSEL                      HPRIO_PSEL_1

#define HPRIO_PSEL1_MASK                2U
#define HPRIO_PSEL2_MASK                4U
#define HPRIO_PSEL3_MASK                8U
#define HPRIO_PSEL4_MASK                16U
#define HPRIO_PSEL5_MASK                32U
#define HPRIO_PSEL6_MASK                64U
#define HPRIO_PSEL7_MASK                128U
#define HPRIO_PSEL_1_MASK               254U
#define HPRIO_PSEL_1_BITNUM             1U


/*** DBGC1 - Debug Control Register 1; 0x00000020 ***/
typedef union {
  byte Byte;
  struct {
    byte CAPMOD0     :1;                                       /* Capture Mode Field, bit 0 */
    byte CAPMOD1     :1;                                       /* Capture Mode Field, bit 1 */
    byte             :1; 
    byte DBGBRK      :1;                                       /* DBG Breakpoint Enable Bit */
    byte BEGIN       :1;                                       /* Begin/End Trigger Bit */
    byte TRGSEL      :1;                                       /* Trigger Selection Bit */
    byte ARM         :1;                                       /* Arm Bit */
    byte DBGEN       :1;                                       /* DBG Mode Enable Bit */
  } Bits;
  struct {
    byte grpCAPMOD :2;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} DBGC1STR;
extern volatile DBGC1STR _DBGC1 @(REG_BASE + 0x00000020UL);
#define DBGC1                           _DBGC1.Byte
#define DBGC1_CAPMOD0                   _DBGC1.Bits.CAPMOD0
#define DBGC1_CAPMOD1                   _DBGC1.Bits.CAPMOD1
#define DBGC1_DBGBRK                    _DBGC1.Bits.DBGBRK
#define DBGC1_BEGIN                     _DBGC1.Bits.BEGIN
#define DBGC1_TRGSEL                    _DBGC1.Bits.TRGSEL
#define DBGC1_ARM                       _DBGC1.Bits.ARM
#define DBGC1_DBGEN                     _DBGC1.Bits.DBGEN
#define DBGC1_CAPMOD                    _DBGC1.MergedBits.grpCAPMOD

#define DBGC1_CAPMOD0_MASK              1U
#define DBGC1_CAPMOD1_MASK              2U
#define DBGC1_DBGBRK_MASK               8U
#define DBGC1_BEGIN_MASK                16U
#define DBGC1_TRGSEL_MASK               32U
#define DBGC1_ARM_MASK                  64U
#define DBGC1_DBGEN_MASK                128U
#define DBGC1_CAPMOD_MASK               3U
#define DBGC1_CAPMOD_BITNUM             0U


/*** DBGSC - Debug Status and Control Register; 0x00000021 ***/
typedef union {
  byte Byte;
  struct {
    byte TRG0        :1;                                       /* Trigger Mode Bits, bit 0 */
    byte TRG1        :1;                                       /* Trigger Mode Bits, bit 1 */
    byte TRG2        :1;                                       /* Trigger Mode Bits, bit 2 */
    byte TRG3        :1;                                       /* Trigger Mode Bits, bit 3 */
    byte             :1; 
    byte CF          :1;                                       /* Comparator C Match Flag */
    byte BF          :1;                                       /* Trigger B Match Flag */
    byte AF          :1;                                       /* Trigger A Match Flag */
  } Bits;
  struct {
    byte grpTRG  :4;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} DBGSCSTR;
extern volatile DBGSCSTR _DBGSC @(REG_BASE + 0x00000021UL);
#define DBGSC                           _DBGSC.Byte
#define DBGSC_TRG0                      _DBGSC.Bits.TRG0
#define DBGSC_TRG1                      _DBGSC.Bits.TRG1
#define DBGSC_TRG2                      _DBGSC.Bits.TRG2
#define DBGSC_TRG3                      _DBGSC.Bits.TRG3
#define DBGSC_CF                        _DBGSC.Bits.CF
#define DBGSC_BF                        _DBGSC.Bits.BF
#define DBGSC_AF                        _DBGSC.Bits.AF
#define DBGSC_TRG                       _DBGSC.MergedBits.grpTRG

#define DBGSC_TRG0_MASK                 1U
#define DBGSC_TRG1_MASK                 2U
#define DBGSC_TRG2_MASK                 4U
#define DBGSC_TRG3_MASK                 8U
#define DBGSC_CF_MASK                   32U
#define DBGSC_BF_MASK                   64U
#define DBGSC_AF_MASK                   128U
#define DBGSC_TRG_MASK                  15U
#define DBGSC_TRG_BITNUM                0U


/*** DBGTB - Debug Trace Buffer Register; 0x00000022 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** DBGTBH - Debug Trace Buffer Register High; 0x00000022 ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Trace Buffer Data Bit 8 */
        byte BIT9        :1;                                       /* Trace Buffer Data Bit 9 */
        byte BIT10       :1;                                       /* Trace Buffer Data Bit 10 */
        byte BIT11       :1;                                       /* Trace Buffer Data Bit 11 */
        byte BIT12       :1;                                       /* Trace Buffer Data Bit 12 */
        byte BIT13       :1;                                       /* Trace Buffer Data Bit 13 */
        byte BIT14       :1;                                       /* Trace Buffer Data Bit 14 */
        byte BIT15       :1;                                       /* Trace Buffer Data Bit 15 */
      } Bits;
    } DBGTBHSTR;
    #define DBGTBH                      _DBGTB.Overlap_STR.DBGTBHSTR.Byte
    #define DBGTBH_BIT8                 _DBGTB.Overlap_STR.DBGTBHSTR.Bits.BIT8
    #define DBGTBH_BIT9                 _DBGTB.Overlap_STR.DBGTBHSTR.Bits.BIT9
    #define DBGTBH_BIT10                _DBGTB.Overlap_STR.DBGTBHSTR.Bits.BIT10
    #define DBGTBH_BIT11                _DBGTB.Overlap_STR.DBGTBHSTR.Bits.BIT11
    #define DBGTBH_BIT12                _DBGTB.Overlap_STR.DBGTBHSTR.Bits.BIT12
    #define DBGTBH_BIT13                _DBGTB.Overlap_STR.DBGTBHSTR.Bits.BIT13
    #define DBGTBH_BIT14                _DBGTB.Overlap_STR.DBGTBHSTR.Bits.BIT14
    #define DBGTBH_BIT15                _DBGTB.Overlap_STR.DBGTBHSTR.Bits.BIT15
    
    #define DBGTBH_BIT8_MASK            1U
    #define DBGTBH_BIT9_MASK            2U
    #define DBGTBH_BIT10_MASK           4U
    #define DBGTBH_BIT11_MASK           8U
    #define DBGTBH_BIT12_MASK           16U
    #define DBGTBH_BIT13_MASK           32U
    #define DBGTBH_BIT14_MASK           64U
    #define DBGTBH_BIT15_MASK           128U
    

    /*** DBGTBL - Debug Trace Buffer Register Low; 0x00000023 ***/
    union {
      byte Byte;
      struct {
        byte BIT0        :1;                                       /* Trace Buffer Data Bit 0 */
        byte BIT1        :1;                                       /* Trace Buffer Data Bit 1 */
        byte BIT2        :1;                                       /* Trace Buffer Data Bit 2 */
        byte BIT3        :1;                                       /* Trace Buffer Data Bit 3 */
        byte BIT4        :1;                                       /* Trace Buffer Data Bit 4 */
        byte BIT5        :1;                                       /* Trace Buffer Data Bit 5 */
        byte BIT6        :1;                                       /* Trace Buffer Data Bit 6 */
        byte BIT7        :1;                                       /* Trace Buffer Data Bit 7 */
      } Bits;
    } DBGTBLSTR;
    #define DBGTBL                      _DBGTB.Overlap_STR.DBGTBLSTR.Byte
    #define DBGTBL_BIT0                 _DBGTB.Overlap_STR.DBGTBLSTR.Bits.BIT0
    #define DBGTBL_BIT1                 _DBGTB.Overlap_STR.DBGTBLSTR.Bits.BIT1
    #define DBGTBL_BIT2                 _DBGTB.Overlap_STR.DBGTBLSTR.Bits.BIT2
    #define DBGTBL_BIT3                 _DBGTB.Overlap_STR.DBGTBLSTR.Bits.BIT3
    #define DBGTBL_BIT4                 _DBGTB.Overlap_STR.DBGTBLSTR.Bits.BIT4
    #define DBGTBL_BIT5                 _DBGTB.Overlap_STR.DBGTBLSTR.Bits.BIT5
    #define DBGTBL_BIT6                 _DBGTB.Overlap_STR.DBGTBLSTR.Bits.BIT6
    #define DBGTBL_BIT7                 _DBGTB.Overlap_STR.DBGTBLSTR.Bits.BIT7
    
    #define DBGTBL_BIT0_MASK            1U
    #define DBGTBL_BIT1_MASK            2U
    #define DBGTBL_BIT2_MASK            4U
    #define DBGTBL_BIT3_MASK            8U
    #define DBGTBL_BIT4_MASK            16U
    #define DBGTBL_BIT5_MASK            32U
    #define DBGTBL_BIT6_MASK            64U
    #define DBGTBL_BIT7_MASK            128U
    
  } Overlap_STR;

  struct {
    word BIT0        :1;                                       /* Trace Buffer Data Bit 0 */
    word BIT1        :1;                                       /* Trace Buffer Data Bit 1 */
    word BIT2        :1;                                       /* Trace Buffer Data Bit 2 */
    word BIT3        :1;                                       /* Trace Buffer Data Bit 3 */
    word BIT4        :1;                                       /* Trace Buffer Data Bit 4 */
    word BIT5        :1;                                       /* Trace Buffer Data Bit 5 */
    word BIT6        :1;                                       /* Trace Buffer Data Bit 6 */
    word BIT7        :1;                                       /* Trace Buffer Data Bit 7 */
    word BIT8        :1;                                       /* Trace Buffer Data Bit 8 */
    word BIT9        :1;                                       /* Trace Buffer Data Bit 9 */
    word BIT10       :1;                                       /* Trace Buffer Data Bit 10 */
    word BIT11       :1;                                       /* Trace Buffer Data Bit 11 */
    word BIT12       :1;                                       /* Trace Buffer Data Bit 12 */
    word BIT13       :1;                                       /* Trace Buffer Data Bit 13 */
    word BIT14       :1;                                       /* Trace Buffer Data Bit 14 */
    word BIT15       :1;                                       /* Trace Buffer Data Bit 15 */
  } Bits;
} DBGTBSTR;
extern volatile DBGTBSTR _DBGTB @(REG_BASE + 0x00000022UL);
#define DBGTB                           _DBGTB.Word
#define DBGTB_BIT0                      _DBGTB.Bits.BIT0
#define DBGTB_BIT1                      _DBGTB.Bits.BIT1
#define DBGTB_BIT2                      _DBGTB.Bits.BIT2
#define DBGTB_BIT3                      _DBGTB.Bits.BIT3
#define DBGTB_BIT4                      _DBGTB.Bits.BIT4
#define DBGTB_BIT5                      _DBGTB.Bits.BIT5
#define DBGTB_BIT6                      _DBGTB.Bits.BIT6
#define DBGTB_BIT7                      _DBGTB.Bits.BIT7
#define DBGTB_BIT8                      _DBGTB.Bits.BIT8
#define DBGTB_BIT9                      _DBGTB.Bits.BIT9
#define DBGTB_BIT10                     _DBGTB.Bits.BIT10
#define DBGTB_BIT11                     _DBGTB.Bits.BIT11
#define DBGTB_BIT12                     _DBGTB.Bits.BIT12
#define DBGTB_BIT13                     _DBGTB.Bits.BIT13
#define DBGTB_BIT14                     _DBGTB.Bits.BIT14
#define DBGTB_BIT15                     _DBGTB.Bits.BIT15

#define DBGTB_BIT0_MASK                 1U
#define DBGTB_BIT1_MASK                 2U
#define DBGTB_BIT2_MASK                 4U
#define DBGTB_BIT3_MASK                 8U
#define DBGTB_BIT4_MASK                 16U
#define DBGTB_BIT5_MASK                 32U
#define DBGTB_BIT6_MASK                 64U
#define DBGTB_BIT7_MASK                 128U
#define DBGTB_BIT8_MASK                 256U
#define DBGTB_BIT9_MASK                 512U
#define DBGTB_BIT10_MASK                1024U
#define DBGTB_BIT11_MASK                2048U
#define DBGTB_BIT12_MASK                4096U
#define DBGTB_BIT13_MASK                8192U
#define DBGTB_BIT14_MASK                16384U
#define DBGTB_BIT15_MASK                32768U


/*** DBGCNT - Debug Count Register; 0x00000024 ***/
typedef union {
  byte Byte;
  struct {
    byte CNT0        :1;                                       /* Count Value, bit 0 */
    byte CNT1        :1;                                       /* Count Value, bit 1 */
    byte CNT2        :1;                                       /* Count Value, bit 2 */
    byte CNT3        :1;                                       /* Count Value, bit 3 */
    byte CNT4        :1;                                       /* Count Value, bit 4 */
    byte CNT5        :1;                                       /* Count Value, bit 5 */
    byte             :1; 
    byte TBF         :1;                                       /* Trace Buffer Full */
  } Bits;
  struct {
    byte grpCNT  :6;
    byte         :1;
    byte         :1;
  } MergedBits;
} DBGCNTSTR;
extern volatile DBGCNTSTR _DBGCNT @(REG_BASE + 0x00000024UL);
#define DBGCNT                          _DBGCNT.Byte
#define DBGCNT_CNT0                     _DBGCNT.Bits.CNT0
#define DBGCNT_CNT1                     _DBGCNT.Bits.CNT1
#define DBGCNT_CNT2                     _DBGCNT.Bits.CNT2
#define DBGCNT_CNT3                     _DBGCNT.Bits.CNT3
#define DBGCNT_CNT4                     _DBGCNT.Bits.CNT4
#define DBGCNT_CNT5                     _DBGCNT.Bits.CNT5
#define DBGCNT_TBF                      _DBGCNT.Bits.TBF
#define DBGCNT_CNT                      _DBGCNT.MergedBits.grpCNT

#define DBGCNT_CNT0_MASK                1U
#define DBGCNT_CNT1_MASK                2U
#define DBGCNT_CNT2_MASK                4U
#define DBGCNT_CNT3_MASK                8U
#define DBGCNT_CNT4_MASK                16U
#define DBGCNT_CNT5_MASK                32U
#define DBGCNT_TBF_MASK                 128U
#define DBGCNT_CNT_MASK                 63U
#define DBGCNT_CNT_BITNUM               0U


/*** DBGCCX - Debug Comparator C Extended Register; 0x00000025 ***/
typedef union {
  byte Byte;
  struct {
    byte EXTCMP0     :1;                                       /* Comparator C Extended Compare Bits, bit 0 */
    byte EXTCMP1     :1;                                       /* Comparator C Extended Compare Bits, bit 1 */
    byte EXTCMP2     :1;                                       /* Comparator C Extended Compare Bits, bit 2 */
    byte EXTCMP3     :1;                                       /* Comparator C Extended Compare Bits, bit 3 */
    byte EXTCMP4     :1;                                       /* Comparator C Extended Compare Bits, bit 4 */
    byte EXTCMP5     :1;                                       /* Comparator C Extended Compare Bits, bit 5 */
    byte PAGSEL0     :1;                                       /* Page Selector Field, bit 0 */
    byte PAGSEL1     :1;                                       /* Page Selector Field, bit 1 */
  } Bits;
  struct {
    byte grpEXTCMP :6;
    byte grpPAGSEL :2;
  } MergedBits;
} DBGCCXSTR;
extern volatile DBGCCXSTR _DBGCCX @(REG_BASE + 0x00000025UL);
#define DBGCCX                          _DBGCCX.Byte
#define DBGCCX_EXTCMP0                  _DBGCCX.Bits.EXTCMP0
#define DBGCCX_EXTCMP1                  _DBGCCX.Bits.EXTCMP1
#define DBGCCX_EXTCMP2                  _DBGCCX.Bits.EXTCMP2
#define DBGCCX_EXTCMP3                  _DBGCCX.Bits.EXTCMP3
#define DBGCCX_EXTCMP4                  _DBGCCX.Bits.EXTCMP4
#define DBGCCX_EXTCMP5                  _DBGCCX.Bits.EXTCMP5
#define DBGCCX_PAGSEL0                  _DBGCCX.Bits.PAGSEL0
#define DBGCCX_PAGSEL1                  _DBGCCX.Bits.PAGSEL1
#define DBGCCX_EXTCMP                   _DBGCCX.MergedBits.grpEXTCMP
#define DBGCCX_PAGSEL                   _DBGCCX.MergedBits.grpPAGSEL

#define DBGCCX_EXTCMP0_MASK             1U
#define DBGCCX_EXTCMP1_MASK             2U
#define DBGCCX_EXTCMP2_MASK             4U
#define DBGCCX_EXTCMP3_MASK             8U
#define DBGCCX_EXTCMP4_MASK             16U
#define DBGCCX_EXTCMP5_MASK             32U
#define DBGCCX_PAGSEL0_MASK             64U
#define DBGCCX_PAGSEL1_MASK             128U
#define DBGCCX_EXTCMP_MASK              63U
#define DBGCCX_EXTCMP_BITNUM            0U
#define DBGCCX_PAGSEL_MASK              192U
#define DBGCCX_PAGSEL_BITNUM            6U


/*** DBGCC - Debug Comparator C Register; 0x00000026 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** DBGCCH - Debug Comparator C Register High; 0x00000026 ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Comparator C Compare Bit 8 */
        byte BIT9        :1;                                       /* Comparator C Compare Bit 9 */
        byte BIT10       :1;                                       /* Comparator C Compare Bit 10 */
        byte BIT11       :1;                                       /* Comparator C Compare Bit 11 */
        byte BIT12       :1;                                       /* Comparator C Compare Bit 12 */
        byte BIT13       :1;                                       /* Comparator C Compare Bit 13 */
        byte BIT14       :1;                                       /* Comparator C Compare Bit 14 */
        byte BIT15       :1;                                       /* Comparator C Compare Bit 15 */
      } Bits;
    } DBGCCHSTR;
    #define DBGCCH                      _DBGCC.Overlap_STR.DBGCCHSTR.Byte
    #define DBGCCH_BIT8                 _DBGCC.Overlap_STR.DBGCCHSTR.Bits.BIT8
    #define DBGCCH_BIT9                 _DBGCC.Overlap_STR.DBGCCHSTR.Bits.BIT9
    #define DBGCCH_BIT10                _DBGCC.Overlap_STR.DBGCCHSTR.Bits.BIT10
    #define DBGCCH_BIT11                _DBGCC.Overlap_STR.DBGCCHSTR.Bits.BIT11
    #define DBGCCH_BIT12                _DBGCC.Overlap_STR.DBGCCHSTR.Bits.BIT12
    #define DBGCCH_BIT13                _DBGCC.Overlap_STR.DBGCCHSTR.Bits.BIT13
    #define DBGCCH_BIT14                _DBGCC.Overlap_STR.DBGCCHSTR.Bits.BIT14
    #define DBGCCH_BIT15                _DBGCC.Overlap_STR.DBGCCHSTR.Bits.BIT15
    
    #define DBGCCH_BIT8_MASK            1U
    #define DBGCCH_BIT9_MASK            2U
    #define DBGCCH_BIT10_MASK           4U
    #define DBGCCH_BIT11_MASK           8U
    #define DBGCCH_BIT12_MASK           16U
    #define DBGCCH_BIT13_MASK           32U
    #define DBGCCH_BIT14_MASK           64U
    #define DBGCCH_BIT15_MASK           128U
    

    /*** DBGCCL - Debug Comparator C Register Low; 0x00000027 ***/
    union {
      byte Byte;
      struct {
        byte BIT0        :1;                                       /* Comparator C Compare Bit 0 */
        byte BIT1        :1;                                       /* Comparator C Compare Bit 1 */
        byte BIT2        :1;                                       /* Comparator C Compare Bit 2 */
        byte BIT3        :1;                                       /* Comparator C Compare Bit 3 */
        byte BIT4        :1;                                       /* Comparator C Compare Bit 4 */
        byte BIT5        :1;                                       /* Comparator C Compare Bit 5 */
        byte BIT6        :1;                                       /* Comparator C Compare Bit 6 */
        byte BIT7        :1;                                       /* Comparator C Compare Bit 7 */
      } Bits;
    } DBGCCLSTR;
    #define DBGCCL                      _DBGCC.Overlap_STR.DBGCCLSTR.Byte
    #define DBGCCL_BIT0                 _DBGCC.Overlap_STR.DBGCCLSTR.Bits.BIT0
    #define DBGCCL_BIT1                 _DBGCC.Overlap_STR.DBGCCLSTR.Bits.BIT1
    #define DBGCCL_BIT2                 _DBGCC.Overlap_STR.DBGCCLSTR.Bits.BIT2
    #define DBGCCL_BIT3                 _DBGCC.Overlap_STR.DBGCCLSTR.Bits.BIT3
    #define DBGCCL_BIT4                 _DBGCC.Overlap_STR.DBGCCLSTR.Bits.BIT4
    #define DBGCCL_BIT5                 _DBGCC.Overlap_STR.DBGCCLSTR.Bits.BIT5
    #define DBGCCL_BIT6                 _DBGCC.Overlap_STR.DBGCCLSTR.Bits.BIT6
    #define DBGCCL_BIT7                 _DBGCC.Overlap_STR.DBGCCLSTR.Bits.BIT7
    
    #define DBGCCL_BIT0_MASK            1U
    #define DBGCCL_BIT1_MASK            2U
    #define DBGCCL_BIT2_MASK            4U
    #define DBGCCL_BIT3_MASK            8U
    #define DBGCCL_BIT4_MASK            16U
    #define DBGCCL_BIT5_MASK            32U
    #define DBGCCL_BIT6_MASK            64U
    #define DBGCCL_BIT7_MASK            128U
    
  } Overlap_STR;

  struct {
    word BIT0        :1;                                       /* Comparator C Compare Bit 0 */
    word BIT1        :1;                                       /* Comparator C Compare Bit 1 */
    word BIT2        :1;                                       /* Comparator C Compare Bit 2 */
    word BIT3        :1;                                       /* Comparator C Compare Bit 3 */
    word BIT4        :1;                                       /* Comparator C Compare Bit 4 */
    word BIT5        :1;                                       /* Comparator C Compare Bit 5 */
    word BIT6        :1;                                       /* Comparator C Compare Bit 6 */
    word BIT7        :1;                                       /* Comparator C Compare Bit 7 */
    word BIT8        :1;                                       /* Comparator C Compare Bit 8 */
    word BIT9        :1;                                       /* Comparator C Compare Bit 9 */
    word BIT10       :1;                                       /* Comparator C Compare Bit 10 */
    word BIT11       :1;                                       /* Comparator C Compare Bit 11 */
    word BIT12       :1;                                       /* Comparator C Compare Bit 12 */
    word BIT13       :1;                                       /* Comparator C Compare Bit 13 */
    word BIT14       :1;                                       /* Comparator C Compare Bit 14 */
    word BIT15       :1;                                       /* Comparator C Compare Bit 15 */
  } Bits;
} DBGCCSTR;
extern volatile DBGCCSTR _DBGCC @(REG_BASE + 0x00000026UL);
#define DBGCC                           _DBGCC.Word
#define DBGCC_BIT0                      _DBGCC.Bits.BIT0
#define DBGCC_BIT1                      _DBGCC.Bits.BIT1
#define DBGCC_BIT2                      _DBGCC.Bits.BIT2
#define DBGCC_BIT3                      _DBGCC.Bits.BIT3
#define DBGCC_BIT4                      _DBGCC.Bits.BIT4
#define DBGCC_BIT5                      _DBGCC.Bits.BIT5
#define DBGCC_BIT6                      _DBGCC.Bits.BIT6
#define DBGCC_BIT7                      _DBGCC.Bits.BIT7
#define DBGCC_BIT8                      _DBGCC.Bits.BIT8
#define DBGCC_BIT9                      _DBGCC.Bits.BIT9
#define DBGCC_BIT10                     _DBGCC.Bits.BIT10
#define DBGCC_BIT11                     _DBGCC.Bits.BIT11
#define DBGCC_BIT12                     _DBGCC.Bits.BIT12
#define DBGCC_BIT13                     _DBGCC.Bits.BIT13
#define DBGCC_BIT14                     _DBGCC.Bits.BIT14
#define DBGCC_BIT15                     _DBGCC.Bits.BIT15

#define DBGCC_BIT0_MASK                 1U
#define DBGCC_BIT1_MASK                 2U
#define DBGCC_BIT2_MASK                 4U
#define DBGCC_BIT3_MASK                 8U
#define DBGCC_BIT4_MASK                 16U
#define DBGCC_BIT5_MASK                 32U
#define DBGCC_BIT6_MASK                 64U
#define DBGCC_BIT7_MASK                 128U
#define DBGCC_BIT8_MASK                 256U
#define DBGCC_BIT9_MASK                 512U
#define DBGCC_BIT10_MASK                1024U
#define DBGCC_BIT11_MASK                2048U
#define DBGCC_BIT12_MASK                4096U
#define DBGCC_BIT13_MASK                8192U
#define DBGCC_BIT14_MASK                16384U
#define DBGCC_BIT15_MASK                32768U


/*** DBGC2 - Debug Control Register 2; 0x00000028 ***/
typedef union {
  byte Byte;
  struct {
    byte RWC         :1;                                       /* Read/Write Comparator C Value Bit */
    byte RWCEN       :1;                                       /* Read/Write Comparator C Enable Bit */
    byte TAGC        :1;                                       /* Comparator C Tag Select */
    byte BKCEN       :1;                                       /* Breakpoint Comparator C Enable Bit */
    byte TAGAB       :1;                                       /* Comparator A/B Tag Select */
    byte BDM         :1;                                       /* Background Debug Mode Enable */
    byte FULL        :1;                                       /* Full Breakpoint Mode Enable */
    byte BKABEN      :1;                                       /* Breakpoint Using Comparator A and B Enable */
  } Bits;
} DBGC2STR;
extern volatile DBGC2STR _DBGC2 @(REG_BASE + 0x00000028UL);
#define DBGC2                           _DBGC2.Byte
#define DBGC2_RWC                       _DBGC2.Bits.RWC
#define DBGC2_RWCEN                     _DBGC2.Bits.RWCEN
#define DBGC2_TAGC                      _DBGC2.Bits.TAGC
#define DBGC2_BKCEN                     _DBGC2.Bits.BKCEN
#define DBGC2_TAGAB                     _DBGC2.Bits.TAGAB
#define DBGC2_BDM                       _DBGC2.Bits.BDM
#define DBGC2_FULL                      _DBGC2.Bits.FULL
#define DBGC2_BKABEN                    _DBGC2.Bits.BKABEN

#define DBGC2_RWC_MASK                  1U
#define DBGC2_RWCEN_MASK                2U
#define DBGC2_TAGC_MASK                 4U
#define DBGC2_BKCEN_MASK                8U
#define DBGC2_TAGAB_MASK                16U
#define DBGC2_BDM_MASK                  32U
#define DBGC2_FULL_MASK                 64U
#define DBGC2_BKABEN_MASK               128U


/*** DBGC3 - Debug Control Register 3; 0x00000029 ***/
typedef union {
  byte Byte;
  struct {
    byte RWB         :1;                                       /* Read/Write Comparator B Value Bit */
    byte RWBEN       :1;                                       /* Read/Write Comparator B Enable Bit */
    byte RWA         :1;                                       /* Read/Write Comparator A Value Bit */
    byte RWAEN       :1;                                       /* Read/Write Comparator A Enable Bit */
    byte BKBMBL      :1;                                       /* Breakpoint Mask Low Byte for Second Address */
    byte BKBMBH      :1;                                       /* Breakpoint Mask High Byte for Second Address */
    byte BKAMBL      :1;                                       /* Breakpoint Mask Low Byte for First Address */
    byte BKAMBH      :1;                                       /* Breakpoint Mask High Byte for First Address */
  } Bits;
} DBGC3STR;
extern volatile DBGC3STR _DBGC3 @(REG_BASE + 0x00000029UL);
#define DBGC3                           _DBGC3.Byte
#define DBGC3_RWB                       _DBGC3.Bits.RWB
#define DBGC3_RWBEN                     _DBGC3.Bits.RWBEN
#define DBGC3_RWA                       _DBGC3.Bits.RWA
#define DBGC3_RWAEN                     _DBGC3.Bits.RWAEN
#define DBGC3_BKBMBL                    _DBGC3.Bits.BKBMBL
#define DBGC3_BKBMBH                    _DBGC3.Bits.BKBMBH
#define DBGC3_BKAMBL                    _DBGC3.Bits.BKAMBL
#define DBGC3_BKAMBH                    _DBGC3.Bits.BKAMBH

#define DBGC3_RWB_MASK                  1U
#define DBGC3_RWBEN_MASK                2U
#define DBGC3_RWA_MASK                  4U
#define DBGC3_RWAEN_MASK                8U
#define DBGC3_BKBMBL_MASK               16U
#define DBGC3_BKBMBH_MASK               32U
#define DBGC3_BKAMBL_MASK               64U
#define DBGC3_BKAMBH_MASK               128U


/*** DBGCAX - Debug Comparator A Extended Register; 0x0000002A ***/
typedef union {
  byte Byte;
  struct {
    byte EXTCMP0     :1;                                       /* Comparator A Extended Compare Bits, bit 0 */
    byte EXTCMP1     :1;                                       /* Comparator A Extended Compare Bits, bit 1 */
    byte EXTCMP2     :1;                                       /* Comparator A Extended Compare Bits, bit 2 */
    byte EXTCMP3     :1;                                       /* Comparator A Extended Compare Bits, bit 3 */
    byte EXTCMP4     :1;                                       /* Comparator A Extended Compare Bits, bit 4 */
    byte EXTCMP5     :1;                                       /* Comparator A Extended Compare Bits, bit 5 */
    byte PAGSEL0     :1;                                       /* Page Selector Field, bit 0 */
    byte PAGSEL1     :1;                                       /* Page Selector Field, bit 1 */
  } Bits;
  struct {
    byte grpEXTCMP :6;
    byte grpPAGSEL :2;
  } MergedBits;
} DBGCAXSTR;
extern volatile DBGCAXSTR _DBGCAX @(REG_BASE + 0x0000002AUL);
#define DBGCAX                          _DBGCAX.Byte
#define DBGCAX_EXTCMP0                  _DBGCAX.Bits.EXTCMP0
#define DBGCAX_EXTCMP1                  _DBGCAX.Bits.EXTCMP1
#define DBGCAX_EXTCMP2                  _DBGCAX.Bits.EXTCMP2
#define DBGCAX_EXTCMP3                  _DBGCAX.Bits.EXTCMP3
#define DBGCAX_EXTCMP4                  _DBGCAX.Bits.EXTCMP4
#define DBGCAX_EXTCMP5                  _DBGCAX.Bits.EXTCMP5
#define DBGCAX_PAGSEL0                  _DBGCAX.Bits.PAGSEL0
#define DBGCAX_PAGSEL1                  _DBGCAX.Bits.PAGSEL1
#define DBGCAX_EXTCMP                   _DBGCAX.MergedBits.grpEXTCMP
#define DBGCAX_PAGSEL                   _DBGCAX.MergedBits.grpPAGSEL

#define DBGCAX_EXTCMP0_MASK             1U
#define DBGCAX_EXTCMP1_MASK             2U
#define DBGCAX_EXTCMP2_MASK             4U
#define DBGCAX_EXTCMP3_MASK             8U
#define DBGCAX_EXTCMP4_MASK             16U
#define DBGCAX_EXTCMP5_MASK             32U
#define DBGCAX_PAGSEL0_MASK             64U
#define DBGCAX_PAGSEL1_MASK             128U
#define DBGCAX_EXTCMP_MASK              63U
#define DBGCAX_EXTCMP_BITNUM            0U
#define DBGCAX_PAGSEL_MASK              192U
#define DBGCAX_PAGSEL_BITNUM            6U


/*** DBGCA - Debug Comparator A Register; 0x0000002B ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** DBGCAH - Debug Comparator A Register High; 0x0000002B ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Comparator A Compare Bit 8 */
        byte BIT9        :1;                                       /* Comparator A Compare Bit 9 */
        byte BIT10       :1;                                       /* Comparator A Compare Bit 10 */
        byte BIT11       :1;                                       /* Comparator A Compare Bit 11 */
        byte BIT12       :1;                                       /* Comparator A Compare Bit 12 */
        byte BIT13       :1;                                       /* Comparator A Compare Bit 13 */
        byte BIT14       :1;                                       /* Comparator A Compare Bit 14 */
        byte BIT15       :1;                                       /* Comparator A Compare Bit 15 */
      } Bits;
    } DBGCAHSTR;
    #define DBGCAH                      _DBGCA.Overlap_STR.DBGCAHSTR.Byte
    #define DBGCAH_BIT8                 _DBGCA.Overlap_STR.DBGCAHSTR.Bits.BIT8
    #define DBGCAH_BIT9                 _DBGCA.Overlap_STR.DBGCAHSTR.Bits.BIT9
    #define DBGCAH_BIT10                _DBGCA.Overlap_STR.DBGCAHSTR.Bits.BIT10
    #define DBGCAH_BIT11                _DBGCA.Overlap_STR.DBGCAHSTR.Bits.BIT11
    #define DBGCAH_BIT12                _DBGCA.Overlap_STR.DBGCAHSTR.Bits.BIT12
    #define DBGCAH_BIT13                _DBGCA.Overlap_STR.DBGCAHSTR.Bits.BIT13
    #define DBGCAH_BIT14                _DBGCA.Overlap_STR.DBGCAHSTR.Bits.BIT14
    #define DBGCAH_BIT15                _DBGCA.Overlap_STR.DBGCAHSTR.Bits.BIT15
    
    #define DBGCAH_BIT8_MASK            1U
    #define DBGCAH_BIT9_MASK            2U
    #define DBGCAH_BIT10_MASK           4U
    #define DBGCAH_BIT11_MASK           8U
    #define DBGCAH_BIT12_MASK           16U
    #define DBGCAH_BIT13_MASK           32U
    #define DBGCAH_BIT14_MASK           64U
    #define DBGCAH_BIT15_MASK           128U
    

    /*** DBGCAL - Debug Comparator A Register Low; 0x0000002C ***/
    union {
      byte Byte;
      struct {
        byte BIT0        :1;                                       /* Comparator A Compare Bit 0 */
        byte BIT1        :1;                                       /* Comparator A Compare Bit 1 */
        byte BIT2        :1;                                       /* Comparator A Compare Bit 2 */
        byte BIT3        :1;                                       /* Comparator A Compare Bit 3 */
        byte BIT4        :1;                                       /* Comparator A Compare Bit 4 */
        byte BIT5        :1;                                       /* Comparator A Compare Bit 5 */
        byte BIT6        :1;                                       /* Comparator A Compare Bit 6 */
        byte BIT7        :1;                                       /* Comparator A Compare Bit 7 */
      } Bits;
    } DBGCALSTR;
    #define DBGCAL                      _DBGCA.Overlap_STR.DBGCALSTR.Byte
    #define DBGCAL_BIT0                 _DBGCA.Overlap_STR.DBGCALSTR.Bits.BIT0
    #define DBGCAL_BIT1                 _DBGCA.Overlap_STR.DBGCALSTR.Bits.BIT1
    #define DBGCAL_BIT2                 _DBGCA.Overlap_STR.DBGCALSTR.Bits.BIT2
    #define DBGCAL_BIT3                 _DBGCA.Overlap_STR.DBGCALSTR.Bits.BIT3
    #define DBGCAL_BIT4                 _DBGCA.Overlap_STR.DBGCALSTR.Bits.BIT4
    #define DBGCAL_BIT5                 _DBGCA.Overlap_STR.DBGCALSTR.Bits.BIT5
    #define DBGCAL_BIT6                 _DBGCA.Overlap_STR.DBGCALSTR.Bits.BIT6
    #define DBGCAL_BIT7                 _DBGCA.Overlap_STR.DBGCALSTR.Bits.BIT7
    
    #define DBGCAL_BIT0_MASK            1U
    #define DBGCAL_BIT1_MASK            2U
    #define DBGCAL_BIT2_MASK            4U
    #define DBGCAL_BIT3_MASK            8U
    #define DBGCAL_BIT4_MASK            16U
    #define DBGCAL_BIT5_MASK            32U
    #define DBGCAL_BIT6_MASK            64U
    #define DBGCAL_BIT7_MASK            128U
    
  } Overlap_STR;

  struct {
    word BIT0        :1;                                       /* Comparator A Compare Bit 0 */
    word BIT1        :1;                                       /* Comparator A Compare Bit 1 */
    word BIT2        :1;                                       /* Comparator A Compare Bit 2 */
    word BIT3        :1;                                       /* Comparator A Compare Bit 3 */
    word BIT4        :1;                                       /* Comparator A Compare Bit 4 */
    word BIT5        :1;                                       /* Comparator A Compare Bit 5 */
    word BIT6        :1;                                       /* Comparator A Compare Bit 6 */
    word BIT7        :1;                                       /* Comparator A Compare Bit 7 */
    word BIT8        :1;                                       /* Comparator A Compare Bit 8 */
    word BIT9        :1;                                       /* Comparator A Compare Bit 9 */
    word BIT10       :1;                                       /* Comparator A Compare Bit 10 */
    word BIT11       :1;                                       /* Comparator A Compare Bit 11 */
    word BIT12       :1;                                       /* Comparator A Compare Bit 12 */
    word BIT13       :1;                                       /* Comparator A Compare Bit 13 */
    word BIT14       :1;                                       /* Comparator A Compare Bit 14 */
    word BIT15       :1;                                       /* Comparator A Compare Bit 15 */
  } Bits;
} DBGCASTR;
extern volatile DBGCASTR _DBGCA @(REG_BASE + 0x0000002BUL);
#define DBGCA                           _DBGCA.Word
#define DBGCA_BIT0                      _DBGCA.Bits.BIT0
#define DBGCA_BIT1                      _DBGCA.Bits.BIT1
#define DBGCA_BIT2                      _DBGCA.Bits.BIT2
#define DBGCA_BIT3                      _DBGCA.Bits.BIT3
#define DBGCA_BIT4                      _DBGCA.Bits.BIT4
#define DBGCA_BIT5                      _DBGCA.Bits.BIT5
#define DBGCA_BIT6                      _DBGCA.Bits.BIT6
#define DBGCA_BIT7                      _DBGCA.Bits.BIT7
#define DBGCA_BIT8                      _DBGCA.Bits.BIT8
#define DBGCA_BIT9                      _DBGCA.Bits.BIT9
#define DBGCA_BIT10                     _DBGCA.Bits.BIT10
#define DBGCA_BIT11                     _DBGCA.Bits.BIT11
#define DBGCA_BIT12                     _DBGCA.Bits.BIT12
#define DBGCA_BIT13                     _DBGCA.Bits.BIT13
#define DBGCA_BIT14                     _DBGCA.Bits.BIT14
#define DBGCA_BIT15                     _DBGCA.Bits.BIT15

#define DBGCA_BIT0_MASK                 1U
#define DBGCA_BIT1_MASK                 2U
#define DBGCA_BIT2_MASK                 4U
#define DBGCA_BIT3_MASK                 8U
#define DBGCA_BIT4_MASK                 16U
#define DBGCA_BIT5_MASK                 32U
#define DBGCA_BIT6_MASK                 64U
#define DBGCA_BIT7_MASK                 128U
#define DBGCA_BIT8_MASK                 256U
#define DBGCA_BIT9_MASK                 512U
#define DBGCA_BIT10_MASK                1024U
#define DBGCA_BIT11_MASK                2048U
#define DBGCA_BIT12_MASK                4096U
#define DBGCA_BIT13_MASK                8192U
#define DBGCA_BIT14_MASK                16384U
#define DBGCA_BIT15_MASK                32768U


/*** DBGCBX - Debug Comparator B Extended Register; 0x0000002D ***/
typedef union {
  byte Byte;
  struct {
    byte EXTCMP0     :1;                                       /* Comparator B Extended Compare Bits, bit 0 */
    byte EXTCMP1     :1;                                       /* Comparator B Extended Compare Bits, bit 1 */
    byte EXTCMP2     :1;                                       /* Comparator B Extended Compare Bits, bit 2 */
    byte EXTCMP3     :1;                                       /* Comparator B Extended Compare Bits, bit 3 */
    byte EXTCMP4     :1;                                       /* Comparator B Extended Compare Bits, bit 4 */
    byte EXTCMP5     :1;                                       /* Comparator B Extended Compare Bits, bit 5 */
    byte PAGSEL0     :1;                                       /* Page Selector Field, bit 0 */
    byte PAGSEL1     :1;                                       /* Page Selector Field, bit 1 */
  } Bits;
  struct {
    byte grpEXTCMP :6;
    byte grpPAGSEL :2;
  } MergedBits;
} DBGCBXSTR;
extern volatile DBGCBXSTR _DBGCBX @(REG_BASE + 0x0000002DUL);
#define DBGCBX                          _DBGCBX.Byte
#define DBGCBX_EXTCMP0                  _DBGCBX.Bits.EXTCMP0
#define DBGCBX_EXTCMP1                  _DBGCBX.Bits.EXTCMP1
#define DBGCBX_EXTCMP2                  _DBGCBX.Bits.EXTCMP2
#define DBGCBX_EXTCMP3                  _DBGCBX.Bits.EXTCMP3
#define DBGCBX_EXTCMP4                  _DBGCBX.Bits.EXTCMP4
#define DBGCBX_EXTCMP5                  _DBGCBX.Bits.EXTCMP5
#define DBGCBX_PAGSEL0                  _DBGCBX.Bits.PAGSEL0
#define DBGCBX_PAGSEL1                  _DBGCBX.Bits.PAGSEL1
#define DBGCBX_EXTCMP                   _DBGCBX.MergedBits.grpEXTCMP
#define DBGCBX_PAGSEL                   _DBGCBX.MergedBits.grpPAGSEL

#define DBGCBX_EXTCMP0_MASK             1U
#define DBGCBX_EXTCMP1_MASK             2U
#define DBGCBX_EXTCMP2_MASK             4U
#define DBGCBX_EXTCMP3_MASK             8U
#define DBGCBX_EXTCMP4_MASK             16U
#define DBGCBX_EXTCMP5_MASK             32U
#define DBGCBX_PAGSEL0_MASK             64U
#define DBGCBX_PAGSEL1_MASK             128U
#define DBGCBX_EXTCMP_MASK              63U
#define DBGCBX_EXTCMP_BITNUM            0U
#define DBGCBX_PAGSEL_MASK              192U
#define DBGCBX_PAGSEL_BITNUM            6U


/*** DBGCB - Debug Comparator B Register; 0x0000002E ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** DBGCBH - Debug Comparator B Register High; 0x0000002E ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Comparator B High Compare Bit 8 */
        byte BIT9        :1;                                       /* Comparator B High Compare Bit 9 */
        byte BIT10       :1;                                       /* Comparator B High Compare Bit 10 */
        byte BIT11       :1;                                       /* Comparator B High Compare Bit 11 */
        byte BIT12       :1;                                       /* Comparator B High Compare Bit 12 */
        byte BIT13       :1;                                       /* Comparator B High Compare Bit 13 */
        byte BIT14       :1;                                       /* Comparator B High Compare Bit 14 */
        byte BIT15       :1;                                       /* Comparator B High Compare Bit 15 */
      } Bits;
    } DBGCBHSTR;
    #define DBGCBH                      _DBGCB.Overlap_STR.DBGCBHSTR.Byte
    #define DBGCBH_BIT8                 _DBGCB.Overlap_STR.DBGCBHSTR.Bits.BIT8
    #define DBGCBH_BIT9                 _DBGCB.Overlap_STR.DBGCBHSTR.Bits.BIT9
    #define DBGCBH_BIT10                _DBGCB.Overlap_STR.DBGCBHSTR.Bits.BIT10
    #define DBGCBH_BIT11                _DBGCB.Overlap_STR.DBGCBHSTR.Bits.BIT11
    #define DBGCBH_BIT12                _DBGCB.Overlap_STR.DBGCBHSTR.Bits.BIT12
    #define DBGCBH_BIT13                _DBGCB.Overlap_STR.DBGCBHSTR.Bits.BIT13
    #define DBGCBH_BIT14                _DBGCB.Overlap_STR.DBGCBHSTR.Bits.BIT14
    #define DBGCBH_BIT15                _DBGCB.Overlap_STR.DBGCBHSTR.Bits.BIT15
    
    #define DBGCBH_BIT8_MASK            1U
    #define DBGCBH_BIT9_MASK            2U
    #define DBGCBH_BIT10_MASK           4U
    #define DBGCBH_BIT11_MASK           8U
    #define DBGCBH_BIT12_MASK           16U
    #define DBGCBH_BIT13_MASK           32U
    #define DBGCBH_BIT14_MASK           64U
    #define DBGCBH_BIT15_MASK           128U
    

    /*** DBGCBL - Debug Comparator B Register Low; 0x0000002F ***/
    union {
      byte Byte;
      struct {
        byte BIT0        :1;                                       /* Comparator B High Compare Bit 0 */
        byte BIT1        :1;                                       /* Comparator B High Compare Bit 1 */
        byte BIT2        :1;                                       /* Comparator B High Compare Bit 2 */
        byte BIT3        :1;                                       /* Comparator B High Compare Bit 3 */
        byte BIT4        :1;                                       /* Comparator B High Compare Bit 4 */
        byte BIT5        :1;                                       /* Comparator B High Compare Bit 5 */
        byte BIT6        :1;                                       /* Comparator B High Compare Bit 6 */
        byte BIT7        :1;                                       /* Comparator B High Compare Bit 7 */
      } Bits;
    } DBGCBLSTR;
    #define DBGCBL                      _DBGCB.Overlap_STR.DBGCBLSTR.Byte
    #define DBGCBL_BIT0                 _DBGCB.Overlap_STR.DBGCBLSTR.Bits.BIT0
    #define DBGCBL_BIT1                 _DBGCB.Overlap_STR.DBGCBLSTR.Bits.BIT1
    #define DBGCBL_BIT2                 _DBGCB.Overlap_STR.DBGCBLSTR.Bits.BIT2
    #define DBGCBL_BIT3                 _DBGCB.Overlap_STR.DBGCBLSTR.Bits.BIT3
    #define DBGCBL_BIT4                 _DBGCB.Overlap_STR.DBGCBLSTR.Bits.BIT4
    #define DBGCBL_BIT5                 _DBGCB.Overlap_STR.DBGCBLSTR.Bits.BIT5
    #define DBGCBL_BIT6                 _DBGCB.Overlap_STR.DBGCBLSTR.Bits.BIT6
    #define DBGCBL_BIT7                 _DBGCB.Overlap_STR.DBGCBLSTR.Bits.BIT7
    
    #define DBGCBL_BIT0_MASK            1U
    #define DBGCBL_BIT1_MASK            2U
    #define DBGCBL_BIT2_MASK            4U
    #define DBGCBL_BIT3_MASK            8U
    #define DBGCBL_BIT4_MASK            16U
    #define DBGCBL_BIT5_MASK            32U
    #define DBGCBL_BIT6_MASK            64U
    #define DBGCBL_BIT7_MASK            128U
    
  } Overlap_STR;

  struct {
    word BIT0        :1;                                       /* Comparator B High Compare Bit 0 */
    word BIT1        :1;                                       /* Comparator B High Compare Bit 1 */
    word BIT2        :1;                                       /* Comparator B High Compare Bit 2 */
    word BIT3        :1;                                       /* Comparator B High Compare Bit 3 */
    word BIT4        :1;                                       /* Comparator B High Compare Bit 4 */
    word BIT5        :1;                                       /* Comparator B High Compare Bit 5 */
    word BIT6        :1;                                       /* Comparator B High Compare Bit 6 */
    word BIT7        :1;                                       /* Comparator B High Compare Bit 7 */
    word BIT8        :1;                                       /* Comparator B High Compare Bit 8 */
    word BIT9        :1;                                       /* Comparator B High Compare Bit 9 */
    word BIT10       :1;                                       /* Comparator B High Compare Bit 10 */
    word BIT11       :1;                                       /* Comparator B High Compare Bit 11 */
    word BIT12       :1;                                       /* Comparator B High Compare Bit 12 */
    word BIT13       :1;                                       /* Comparator B High Compare Bit 13 */
    word BIT14       :1;                                       /* Comparator B High Compare Bit 14 */
    word BIT15       :1;                                       /* Comparator B High Compare Bit 15 */
  } Bits;
} DBGCBSTR;
extern volatile DBGCBSTR _DBGCB @(REG_BASE + 0x0000002EUL);
#define DBGCB                           _DBGCB.Word
#define DBGCB_BIT0                      _DBGCB.Bits.BIT0
#define DBGCB_BIT1                      _DBGCB.Bits.BIT1
#define DBGCB_BIT2                      _DBGCB.Bits.BIT2
#define DBGCB_BIT3                      _DBGCB.Bits.BIT3
#define DBGCB_BIT4                      _DBGCB.Bits.BIT4
#define DBGCB_BIT5                      _DBGCB.Bits.BIT5
#define DBGCB_BIT6                      _DBGCB.Bits.BIT6
#define DBGCB_BIT7                      _DBGCB.Bits.BIT7
#define DBGCB_BIT8                      _DBGCB.Bits.BIT8
#define DBGCB_BIT9                      _DBGCB.Bits.BIT9
#define DBGCB_BIT10                     _DBGCB.Bits.BIT10
#define DBGCB_BIT11                     _DBGCB.Bits.BIT11
#define DBGCB_BIT12                     _DBGCB.Bits.BIT12
#define DBGCB_BIT13                     _DBGCB.Bits.BIT13
#define DBGCB_BIT14                     _DBGCB.Bits.BIT14
#define DBGCB_BIT15                     _DBGCB.Bits.BIT15

#define DBGCB_BIT0_MASK                 1U
#define DBGCB_BIT1_MASK                 2U
#define DBGCB_BIT2_MASK                 4U
#define DBGCB_BIT3_MASK                 8U
#define DBGCB_BIT4_MASK                 16U
#define DBGCB_BIT5_MASK                 32U
#define DBGCB_BIT6_MASK                 64U
#define DBGCB_BIT7_MASK                 128U
#define DBGCB_BIT8_MASK                 256U
#define DBGCB_BIT9_MASK                 512U
#define DBGCB_BIT10_MASK                1024U
#define DBGCB_BIT11_MASK                2048U
#define DBGCB_BIT12_MASK                4096U
#define DBGCB_BIT13_MASK                8192U
#define DBGCB_BIT14_MASK                16384U
#define DBGCB_BIT15_MASK                32768U


/*** PPAGE - Page Index Register; 0x00000030 ***/
typedef union {
  byte Byte;
  struct {
    byte PIX0        :1;                                       /* Page Index Register Bit 0 */
    byte PIX1        :1;                                       /* Page Index Register Bit 1 */
    byte PIX2        :1;                                       /* Page Index Register Bit 2 */
    byte PIX3        :1;                                       /* Page Index Register Bit 3 */
    byte PIX4        :1;                                       /* Page Index Register Bit 4 */
    byte PIX5        :1;                                       /* Page Index Register Bit 5 */
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpPIX  :6;
    byte         :1;
    byte         :1;
  } MergedBits;
} PPAGESTR;
extern volatile PPAGESTR _PPAGE @(REG_BASE + 0x00000030UL);
#define PPAGE                           _PPAGE.Byte
#define PPAGE_PIX0                      _PPAGE.Bits.PIX0
#define PPAGE_PIX1                      _PPAGE.Bits.PIX1
#define PPAGE_PIX2                      _PPAGE.Bits.PIX2
#define PPAGE_PIX3                      _PPAGE.Bits.PIX3
#define PPAGE_PIX4                      _PPAGE.Bits.PIX4
#define PPAGE_PIX5                      _PPAGE.Bits.PIX5
#define PPAGE_PIX                       _PPAGE.MergedBits.grpPIX

#define PPAGE_PIX0_MASK                 1U
#define PPAGE_PIX1_MASK                 2U
#define PPAGE_PIX2_MASK                 4U
#define PPAGE_PIX3_MASK                 8U
#define PPAGE_PIX4_MASK                 16U
#define PPAGE_PIX5_MASK                 32U
#define PPAGE_PIX_MASK                  63U
#define PPAGE_PIX_BITNUM                0U


/*** PORTK - Port K Data Register; 0x00000032 ***/
typedef union {
  byte Byte;
  struct {
    byte BIT0        :1;                                       /* Port K Bit 0 */
    byte BIT1        :1;                                       /* Port K Bit 1 */
    byte BIT2        :1;                                       /* Port K Bit 2 */
    byte BIT3        :1;                                       /* Port K Bit 3 */
    byte BIT4        :1;                                       /* Port K Bit 4 */
    byte BIT5        :1;                                       /* Port K Bit 5 */
    byte BIT6        :1;                                       /* Port K Bit 6 */
    byte BIT7        :1;                                       /* Port K Bit 7 */
  } Bits;
} PORTKSTR;
extern volatile PORTKSTR _PORTK @(REG_BASE + 0x00000032UL);
#define PORTK                           _PORTK.Byte
#define PORTK_BIT0                      _PORTK.Bits.BIT0
#define PORTK_BIT1                      _PORTK.Bits.BIT1
#define PORTK_BIT2                      _PORTK.Bits.BIT2
#define PORTK_BIT3                      _PORTK.Bits.BIT3
#define PORTK_BIT4                      _PORTK.Bits.BIT4
#define PORTK_BIT5                      _PORTK.Bits.BIT5
#define PORTK_BIT6                      _PORTK.Bits.BIT6
#define PORTK_BIT7                      _PORTK.Bits.BIT7

#define PORTK_BIT0_MASK                 1U
#define PORTK_BIT1_MASK                 2U
#define PORTK_BIT2_MASK                 4U
#define PORTK_BIT3_MASK                 8U
#define PORTK_BIT4_MASK                 16U
#define PORTK_BIT5_MASK                 32U
#define PORTK_BIT6_MASK                 64U
#define PORTK_BIT7_MASK                 128U


/*** DDRK - Port K Data Direction Register; 0x00000033 ***/
typedef union {
  byte Byte;
  struct {
    byte BIT0        :1;                                       /* Port K Data Direction Bit 0 */
    byte BIT1        :1;                                       /* Port K Data Direction Bit 1 */
    byte BIT2        :1;                                       /* Port K Data Direction Bit 2 */
    byte BIT3        :1;                                       /* Port K Data Direction Bit 3 */
    byte BIT4        :1;                                       /* Port K Data Direction Bit 4 */
    byte BIT5        :1;                                       /* Port K Data Direction Bit 5 */
    byte BIT6        :1;                                       /* Port K Data Direction Bit 6 */
    byte BIT7        :1;                                       /* Port K Data Direction Bit 7 */
  } Bits;
} DDRKSTR;
extern volatile DDRKSTR _DDRK @(REG_BASE + 0x00000033UL);
#define DDRK                            _DDRK.Byte
#define DDRK_BIT0                       _DDRK.Bits.BIT0
#define DDRK_BIT1                       _DDRK.Bits.BIT1
#define DDRK_BIT2                       _DDRK.Bits.BIT2
#define DDRK_BIT3                       _DDRK.Bits.BIT3
#define DDRK_BIT4                       _DDRK.Bits.BIT4
#define DDRK_BIT5                       _DDRK.Bits.BIT5
#define DDRK_BIT6                       _DDRK.Bits.BIT6
#define DDRK_BIT7                       _DDRK.Bits.BIT7

#define DDRK_BIT0_MASK                  1U
#define DDRK_BIT1_MASK                  2U
#define DDRK_BIT2_MASK                  4U
#define DDRK_BIT3_MASK                  8U
#define DDRK_BIT4_MASK                  16U
#define DDRK_BIT5_MASK                  32U
#define DDRK_BIT6_MASK                  64U
#define DDRK_BIT7_MASK                  128U


/*** SYNR - CRG Synthesizer Register; 0x00000034 ***/
typedef union {
  byte Byte;
  struct {
    byte SYN0        :1;                                       /* CRG Synthesizer Bit 0 */
    byte SYN1        :1;                                       /* CRG Synthesizer Bit 1 */
    byte SYN2        :1;                                       /* CRG Synthesizer Bit 2 */
    byte SYN3        :1;                                       /* CRG Synthesizer Bit 3 */
    byte SYN4        :1;                                       /* CRG Synthesizer Bit 4 */
    byte SYN5        :1;                                       /* CRG Synthesizer Bit 5 */
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpSYN  :6;
    byte         :1;
    byte         :1;
  } MergedBits;
} SYNRSTR;
extern volatile SYNRSTR _SYNR @(REG_BASE + 0x00000034UL);
#define SYNR                            _SYNR.Byte
#define SYNR_SYN0                       _SYNR.Bits.SYN0
#define SYNR_SYN1                       _SYNR.Bits.SYN1
#define SYNR_SYN2                       _SYNR.Bits.SYN2
#define SYNR_SYN3                       _SYNR.Bits.SYN3
#define SYNR_SYN4                       _SYNR.Bits.SYN4
#define SYNR_SYN5                       _SYNR.Bits.SYN5
#define SYNR_SYN                        _SYNR.MergedBits.grpSYN

#define SYNR_SYN0_MASK                  1U
#define SYNR_SYN1_MASK                  2U
#define SYNR_SYN2_MASK                  4U
#define SYNR_SYN3_MASK                  8U
#define SYNR_SYN4_MASK                  16U
#define SYNR_SYN5_MASK                  32U
#define SYNR_SYN_MASK                   63U
#define SYNR_SYN_BITNUM                 0U


/*** REFDV - CRG Reference Divider Register; 0x00000035 ***/
typedef union {
  byte Byte;
  struct {
    byte REFDV0      :1;                                       /* CRG Reference Divider Bit 0 */
    byte REFDV1      :1;                                       /* CRG Reference Divider Bit 1 */
    byte REFDV2      :1;                                       /* CRG Reference Divider Bit 2 */
    byte REFDV3      :1;                                       /* CRG Reference Divider Bit 3 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpREFDV :4;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} REFDVSTR;
extern volatile REFDVSTR _REFDV @(REG_BASE + 0x00000035UL);
#define REFDV                           _REFDV.Byte
#define REFDV_REFDV0                    _REFDV.Bits.REFDV0
#define REFDV_REFDV1                    _REFDV.Bits.REFDV1
#define REFDV_REFDV2                    _REFDV.Bits.REFDV2
#define REFDV_REFDV3                    _REFDV.Bits.REFDV3
#define REFDV_REFDV                     _REFDV.MergedBits.grpREFDV

#define REFDV_REFDV0_MASK               1U
#define REFDV_REFDV1_MASK               2U
#define REFDV_REFDV2_MASK               4U
#define REFDV_REFDV3_MASK               8U
#define REFDV_REFDV_MASK                15U
#define REFDV_REFDV_BITNUM              0U


/*** CRGFLG - CRG Flags Register; 0x00000037 ***/
typedef union {
  byte Byte;
  struct {
    byte SCM         :1;                                       /* Self-clock mode Status */
    byte SCMIF       :1;                                       /* Self-clock mode Interrupt Flag */
    byte TRACK       :1;                                       /* Track Status */
    byte LOCK        :1;                                       /* Lock Status */
    byte LOCKIF      :1;                                       /* PLL Lock Interrupt Flag */
    byte LVRF        :1;                                       /* Low Voltage Reset Flag */
    byte PORF        :1;                                       /* Power on Reset Flag */
    byte RTIF        :1;                                       /* Real Time Interrupt Flag */
  } Bits;
} CRGFLGSTR;
extern volatile CRGFLGSTR _CRGFLG @(REG_BASE + 0x00000037UL);
#define CRGFLG                          _CRGFLG.Byte
#define CRGFLG_SCM                      _CRGFLG.Bits.SCM
#define CRGFLG_SCMIF                    _CRGFLG.Bits.SCMIF
#define CRGFLG_TRACK                    _CRGFLG.Bits.TRACK
#define CRGFLG_LOCK                     _CRGFLG.Bits.LOCK
#define CRGFLG_LOCKIF                   _CRGFLG.Bits.LOCKIF
#define CRGFLG_LVRF                     _CRGFLG.Bits.LVRF
#define CRGFLG_PORF                     _CRGFLG.Bits.PORF
#define CRGFLG_RTIF                     _CRGFLG.Bits.RTIF

#define CRGFLG_SCM_MASK                 1U
#define CRGFLG_SCMIF_MASK               2U
#define CRGFLG_TRACK_MASK               4U
#define CRGFLG_LOCK_MASK                8U
#define CRGFLG_LOCKIF_MASK              16U
#define CRGFLG_LVRF_MASK                32U
#define CRGFLG_PORF_MASK                64U
#define CRGFLG_RTIF_MASK                128U


/*** CRGINT - CRG Interrupt Enable Register; 0x00000038 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte SCMIE       :1;                                       /* Self-clock mode Interrupt Enable */
    byte             :1; 
    byte             :1; 
    byte LOCKIE      :1;                                       /* Lock Interrupt Enable */
    byte             :1; 
    byte             :1; 
    byte RTIE        :1;                                       /* Real Time Interrupt Enable */
  } Bits;
} CRGINTSTR;
extern volatile CRGINTSTR _CRGINT @(REG_BASE + 0x00000038UL);
#define CRGINT                          _CRGINT.Byte
#define CRGINT_SCMIE                    _CRGINT.Bits.SCMIE
#define CRGINT_LOCKIE                   _CRGINT.Bits.LOCKIE
#define CRGINT_RTIE                     _CRGINT.Bits.RTIE

#define CRGINT_SCMIE_MASK               2U
#define CRGINT_LOCKIE_MASK              16U
#define CRGINT_RTIE_MASK                128U


/*** CLKSEL - CRG Clock Select Register; 0x00000039 ***/
typedef union {
  byte Byte;
  struct {
    byte COPWAI      :1;                                       /* COP stops in WAIT mode */
    byte RTIWAI      :1;                                       /* RTI stops in WAIT mode */
    byte CWAI        :1;                                       /* CLK24 and CLK23 stop in WAIT mode */
    byte PLLWAI      :1;                                       /* PLL stops in WAIT mode */
    byte ROAWAI      :1;                                       /* Reduced Oscillator Amplitude in WAIT mode */
    byte SYSWAI      :1;                                       /* System clocks stop in WAIT mode */
    byte PSTP        :1;                                       /* Pseudo Stop */
    byte PLLSEL      :1;                                       /* PLL selected for system clock */
  } Bits;
} CLKSELSTR;
extern volatile CLKSELSTR _CLKSEL @(REG_BASE + 0x00000039UL);
#define CLKSEL                          _CLKSEL.Byte
#define CLKSEL_COPWAI                   _CLKSEL.Bits.COPWAI
#define CLKSEL_RTIWAI                   _CLKSEL.Bits.RTIWAI
#define CLKSEL_CWAI                     _CLKSEL.Bits.CWAI
#define CLKSEL_PLLWAI                   _CLKSEL.Bits.PLLWAI
#define CLKSEL_ROAWAI                   _CLKSEL.Bits.ROAWAI
#define CLKSEL_SYSWAI                   _CLKSEL.Bits.SYSWAI
#define CLKSEL_PSTP                     _CLKSEL.Bits.PSTP
#define CLKSEL_PLLSEL                   _CLKSEL.Bits.PLLSEL

#define CLKSEL_COPWAI_MASK              1U
#define CLKSEL_RTIWAI_MASK              2U
#define CLKSEL_CWAI_MASK                4U
#define CLKSEL_PLLWAI_MASK              8U
#define CLKSEL_ROAWAI_MASK              16U
#define CLKSEL_SYSWAI_MASK              32U
#define CLKSEL_PSTP_MASK                64U
#define CLKSEL_PLLSEL_MASK              128U


/*** PLLCTL - CRG PLL Control Register; 0x0000003A ***/
typedef union {
  byte Byte;
  struct {
    byte SCME        :1;                                       /* Self-clock mode enable */
    byte PCE         :1;                                       /* COP Enable during Pseudo Stop Bit */
    byte PRE         :1;                                       /* RTI Enable during Pseudo Stop Bit */
    byte             :1; 
    byte ACQ         :1;                                       /* Acquisition */
    byte AUTO        :1;                                       /* Automatic Bandwidth Control */
    byte PLLON       :1;                                       /* Phase Lock Loop On */
    byte CME         :1;                                       /* Clock Monitor Enable */
  } Bits;
} PLLCTLSTR;
extern volatile PLLCTLSTR _PLLCTL @(REG_BASE + 0x0000003AUL);
#define PLLCTL                          _PLLCTL.Byte
#define PLLCTL_SCME                     _PLLCTL.Bits.SCME
#define PLLCTL_PCE                      _PLLCTL.Bits.PCE
#define PLLCTL_PRE                      _PLLCTL.Bits.PRE
#define PLLCTL_ACQ                      _PLLCTL.Bits.ACQ
#define PLLCTL_AUTO                     _PLLCTL.Bits.AUTO
#define PLLCTL_PLLON                    _PLLCTL.Bits.PLLON
#define PLLCTL_CME                      _PLLCTL.Bits.CME

#define PLLCTL_SCME_MASK                1U
#define PLLCTL_PCE_MASK                 2U
#define PLLCTL_PRE_MASK                 4U
#define PLLCTL_ACQ_MASK                 16U
#define PLLCTL_AUTO_MASK                32U
#define PLLCTL_PLLON_MASK               64U
#define PLLCTL_CME_MASK                 128U


/*** RTICTL - CRG RTI Control Register; 0x0000003B ***/
typedef union {
  byte Byte;
  struct {
    byte RTR0        :1;                                       /* Real Time Interrupt Modulus Counter Select Bit 0 */
    byte RTR1        :1;                                       /* Real Time Interrupt Modulus Counter Select Bit 1 */
    byte RTR2        :1;                                       /* Real Time Interrupt Modulus Counter Select Bit 2 */
    byte RTR3        :1;                                       /* Real Time Interrupt Modulus Counter Select Bit 3 */
    byte RTR4        :1;                                       /* Real Time Interrupt Prescale Rate Select Bit 4 */
    byte RTR5        :1;                                       /* Real Time Interrupt Prescale Rate Select Bit 5 */
    byte RTR6        :1;                                       /* Real Time Interrupt Prescale Rate Select Bit 6 */
    byte             :1; 
  } Bits;
  struct {
    byte grpRTR  :7;
    byte         :1;
  } MergedBits;
} RTICTLSTR;
extern volatile RTICTLSTR _RTICTL @(REG_BASE + 0x0000003BUL);
#define RTICTL                          _RTICTL.Byte
#define RTICTL_RTR0                     _RTICTL.Bits.RTR0
#define RTICTL_RTR1                     _RTICTL.Bits.RTR1
#define RTICTL_RTR2                     _RTICTL.Bits.RTR2
#define RTICTL_RTR3                     _RTICTL.Bits.RTR3
#define RTICTL_RTR4                     _RTICTL.Bits.RTR4
#define RTICTL_RTR5                     _RTICTL.Bits.RTR5
#define RTICTL_RTR6                     _RTICTL.Bits.RTR6
#define RTICTL_RTR                      _RTICTL.MergedBits.grpRTR

#define RTICTL_RTR0_MASK                1U
#define RTICTL_RTR1_MASK                2U
#define RTICTL_RTR2_MASK                4U
#define RTICTL_RTR3_MASK                8U
#define RTICTL_RTR4_MASK                16U
#define RTICTL_RTR5_MASK                32U
#define RTICTL_RTR6_MASK                64U
#define RTICTL_RTR_MASK                 127U
#define RTICTL_RTR_BITNUM               0U


/*** COPCTL - CRG COP Control Register; 0x0000003C ***/
typedef union {
  byte Byte;
  struct {
    byte CR0         :1;                                       /* COP Watchdog Timer Rate select Bit 0 */
    byte CR1         :1;                                       /* COP Watchdog Timer Rate select Bit 1 */
    byte CR2         :1;                                       /* COP Watchdog Timer Rate select Bit 2 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte RSBCK       :1;                                       /* COP and RTI stop in Active BDM mode Bit */
    byte WCOP        :1;                                       /* Window COP mode */
  } Bits;
  struct {
    byte grpCR   :3;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} COPCTLSTR;
extern volatile COPCTLSTR _COPCTL @(REG_BASE + 0x0000003CUL);
#define COPCTL                          _COPCTL.Byte
#define COPCTL_CR0                      _COPCTL.Bits.CR0
#define COPCTL_CR1                      _COPCTL.Bits.CR1
#define COPCTL_CR2                      _COPCTL.Bits.CR2
#define COPCTL_RSBCK                    _COPCTL.Bits.RSBCK
#define COPCTL_WCOP                     _COPCTL.Bits.WCOP
#define COPCTL_CR                       _COPCTL.MergedBits.grpCR

#define COPCTL_CR0_MASK                 1U
#define COPCTL_CR1_MASK                 2U
#define COPCTL_CR2_MASK                 4U
#define COPCTL_RSBCK_MASK               64U
#define COPCTL_WCOP_MASK                128U
#define COPCTL_CR_MASK                  7U
#define COPCTL_CR_BITNUM                0U


/*** ARMCOP - CRG COP Timer Arm/Reset Register; 0x0000003F ***/
typedef union {
  byte Byte;
  struct {
    byte BIT0        :1;                                       /* CRG COP Timer Arm/Reset Bit 0 */
    byte BIT1        :1;                                       /* CRG COP Timer Arm/Reset Bit 1 */
    byte BIT2        :1;                                       /* CRG COP Timer Arm/Reset Bit 2 */
    byte BIT3        :1;                                       /* CRG COP Timer Arm/Reset Bit 3 */
    byte BIT4        :1;                                       /* CRG COP Timer Arm/Reset Bit 4 */
    byte BIT5        :1;                                       /* CRG COP Timer Arm/Reset Bit 5 */
    byte BIT6        :1;                                       /* CRG COP Timer Arm/Reset Bit 6 */
    byte BIT7        :1;                                       /* CRG COP Timer Arm/Reset Bit 7 */
  } Bits;
} ARMCOPSTR;
extern volatile ARMCOPSTR _ARMCOP @(REG_BASE + 0x0000003FUL);
#define ARMCOP                          _ARMCOP.Byte
#define ARMCOP_BIT0                     _ARMCOP.Bits.BIT0
#define ARMCOP_BIT1                     _ARMCOP.Bits.BIT1
#define ARMCOP_BIT2                     _ARMCOP.Bits.BIT2
#define ARMCOP_BIT3                     _ARMCOP.Bits.BIT3
#define ARMCOP_BIT4                     _ARMCOP.Bits.BIT4
#define ARMCOP_BIT5                     _ARMCOP.Bits.BIT5
#define ARMCOP_BIT6                     _ARMCOP.Bits.BIT6
#define ARMCOP_BIT7                     _ARMCOP.Bits.BIT7

#define ARMCOP_BIT0_MASK                1U
#define ARMCOP_BIT1_MASK                2U
#define ARMCOP_BIT2_MASK                4U
#define ARMCOP_BIT3_MASK                8U
#define ARMCOP_BIT4_MASK                16U
#define ARMCOP_BIT5_MASK                32U
#define ARMCOP_BIT6_MASK                64U
#define ARMCOP_BIT7_MASK                128U


/*** TIM0_TIOS - TIM0 Timer Input Capture/Output Compare Select; 0x00000040 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte IOS4        :1;                                       /* Input Capture or Output Compare Channel Configuration Bit 4 */
    byte IOS5        :1;                                       /* Input Capture or Output Compare Channel Configuration Bit 5 */
    byte IOS6        :1;                                       /* Input Capture or Output Compare Channel Configuration Bit 6 */
    byte IOS7        :1;                                       /* Input Capture or Output Compare Channel Configuration Bit 7 */
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte grpIOS_4 :4;
  } MergedBits;
} TIM0_TIOSSTR;
extern volatile TIM0_TIOSSTR _TIM0_TIOS @(REG_BASE + 0x00000040UL);
#define TIM0_TIOS                       _TIM0_TIOS.Byte
#define TIM0_TIOS_IOS4                  _TIM0_TIOS.Bits.IOS4
#define TIM0_TIOS_IOS5                  _TIM0_TIOS.Bits.IOS5
#define TIM0_TIOS_IOS6                  _TIM0_TIOS.Bits.IOS6
#define TIM0_TIOS_IOS7                  _TIM0_TIOS.Bits.IOS7
#define TIM0_TIOS_IOS_4                 _TIM0_TIOS.MergedBits.grpIOS_4
#define TIM0_TIOS_IOS                   TIM0_TIOS_IOS_4

#define TIM0_TIOS_IOS4_MASK             16U
#define TIM0_TIOS_IOS5_MASK             32U
#define TIM0_TIOS_IOS6_MASK             64U
#define TIM0_TIOS_IOS7_MASK             128U
#define TIM0_TIOS_IOS_4_MASK            240U
#define TIM0_TIOS_IOS_4_BITNUM          4U


/*** TIM0_CFORC - TIM0 Timer Compare Force Register; 0x00000041 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte FOC4        :1;                                       /* Force Output Compare Action for Channel 4 */
    byte FOC5        :1;                                       /* Force Output Compare Action for Channel 5 */
    byte FOC6        :1;                                       /* Force Output Compare Action for Channel 6 */
    byte FOC7        :1;                                       /* Force Output Compare Action for Channel 7 */
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte grpFOC_4 :4;
  } MergedBits;
} TIM0_CFORCSTR;
extern volatile TIM0_CFORCSTR _TIM0_CFORC @(REG_BASE + 0x00000041UL);
#define TIM0_CFORC                      _TIM0_CFORC.Byte
#define TIM0_CFORC_FOC4                 _TIM0_CFORC.Bits.FOC4
#define TIM0_CFORC_FOC5                 _TIM0_CFORC.Bits.FOC5
#define TIM0_CFORC_FOC6                 _TIM0_CFORC.Bits.FOC6
#define TIM0_CFORC_FOC7                 _TIM0_CFORC.Bits.FOC7
#define TIM0_CFORC_FOC_4                _TIM0_CFORC.MergedBits.grpFOC_4
#define TIM0_CFORC_FOC                  TIM0_CFORC_FOC_4

#define TIM0_CFORC_FOC4_MASK            16U
#define TIM0_CFORC_FOC5_MASK            32U
#define TIM0_CFORC_FOC6_MASK            64U
#define TIM0_CFORC_FOC7_MASK            128U
#define TIM0_CFORC_FOC_4_MASK           240U
#define TIM0_CFORC_FOC_4_BITNUM         4U


/*** TIM0_OC7M - TIM0 Output Compare 7 Mask Register; 0x00000042 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte OC7M4       :1;                                       /* Output Compare 7 Mask Bit 4 */
    byte OC7M5       :1;                                       /* Output Compare 7 Mask Bit 5 */
    byte OC7M6       :1;                                       /* Output Compare 7 Mask Bit 6 */
    byte OC7M7       :1;                                       /* Output Compare 7 Mask Bit 7 */
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte grpOC7M_4 :4;
  } MergedBits;
} TIM0_OC7MSTR;
extern volatile TIM0_OC7MSTR _TIM0_OC7M @(REG_BASE + 0x00000042UL);
#define TIM0_OC7M                       _TIM0_OC7M.Byte
#define TIM0_OC7M_OC7M4                 _TIM0_OC7M.Bits.OC7M4
#define TIM0_OC7M_OC7M5                 _TIM0_OC7M.Bits.OC7M5
#define TIM0_OC7M_OC7M6                 _TIM0_OC7M.Bits.OC7M6
#define TIM0_OC7M_OC7M7                 _TIM0_OC7M.Bits.OC7M7
#define TIM0_OC7M_OC7M_4                _TIM0_OC7M.MergedBits.grpOC7M_4
#define TIM0_OC7M_OC7M                  TIM0_OC7M_OC7M_4

#define TIM0_OC7M_OC7M4_MASK            16U
#define TIM0_OC7M_OC7M5_MASK            32U
#define TIM0_OC7M_OC7M6_MASK            64U
#define TIM0_OC7M_OC7M7_MASK            128U
#define TIM0_OC7M_OC7M_4_MASK           240U
#define TIM0_OC7M_OC7M_4_BITNUM         4U


/*** TIM0_OC7D - TIM0 Output Compare 7 Data Register; 0x00000043 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte OC7D4       :1;                                       /* Output Compare 7 Bit 4 */
    byte OC7D5       :1;                                       /* Output Compare 7 Bit 5 */
    byte OC7D6       :1;                                       /* Output Compare 7 Bit 6 */
    byte OC7D7       :1;                                       /* Output Compare 7 Bit 7 */
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte grpOC7D_4 :4;
  } MergedBits;
} TIM0_OC7DSTR;
extern volatile TIM0_OC7DSTR _TIM0_OC7D @(REG_BASE + 0x00000043UL);
#define TIM0_OC7D                       _TIM0_OC7D.Byte
#define TIM0_OC7D_OC7D4                 _TIM0_OC7D.Bits.OC7D4
#define TIM0_OC7D_OC7D5                 _TIM0_OC7D.Bits.OC7D5
#define TIM0_OC7D_OC7D6                 _TIM0_OC7D.Bits.OC7D6
#define TIM0_OC7D_OC7D7                 _TIM0_OC7D.Bits.OC7D7
#define TIM0_OC7D_OC7D_4                _TIM0_OC7D.MergedBits.grpOC7D_4
#define TIM0_OC7D_OC7D                  TIM0_OC7D_OC7D_4

#define TIM0_OC7D_OC7D4_MASK            16U
#define TIM0_OC7D_OC7D5_MASK            32U
#define TIM0_OC7D_OC7D6_MASK            64U
#define TIM0_OC7D_OC7D7_MASK            128U
#define TIM0_OC7D_OC7D_4_MASK           240U
#define TIM0_OC7D_OC7D_4_BITNUM         4U


/*** TIM0_TCNT - TIM0 Timer Count Register; 0x00000044 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** TIM0_TCNTHi - TIM0 Timer Count Register High; 0x00000044 ***/
    union {
      byte Byte;
    } TIM0_TCNTHiSTR;
    #define TIM0_TCNTHi                 _TIM0_TCNT.Overlap_STR.TIM0_TCNTHiSTR.Byte
    

    /*** TIM0_TCNTLo - TIM0 Timer Count Register Low; 0x00000045 ***/
    union {
      byte Byte;
    } TIM0_TCNTLoSTR;
    #define TIM0_TCNTLo                 _TIM0_TCNT.Overlap_STR.TIM0_TCNTLoSTR.Byte
    
  } Overlap_STR;

} TIM0_TCNTSTR;
extern volatile TIM0_TCNTSTR _TIM0_TCNT @(REG_BASE + 0x00000044UL);
#define TIM0_TCNT                       _TIM0_TCNT.Word


/*** TIM0_TSCR1 - TIM0 Timer System Control Register1; 0x00000046 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte TFFCA       :1;                                       /* Timer Fast Flag Clear All */
    byte TSFRZ       :1;                                       /* Timer and Modulus Counter Stop While in Freeze Mode */
    byte TSWAI       :1;                                       /* Timer Module Stops While in Wait */
    byte TEN         :1;                                       /* Timer Enable */
  } Bits;
} TIM0_TSCR1STR;
extern volatile TIM0_TSCR1STR _TIM0_TSCR1 @(REG_BASE + 0x00000046UL);
#define TIM0_TSCR1                      _TIM0_TSCR1.Byte
#define TIM0_TSCR1_TFFCA                _TIM0_TSCR1.Bits.TFFCA
#define TIM0_TSCR1_TSFRZ                _TIM0_TSCR1.Bits.TSFRZ
#define TIM0_TSCR1_TSWAI                _TIM0_TSCR1.Bits.TSWAI
#define TIM0_TSCR1_TEN                  _TIM0_TSCR1.Bits.TEN

#define TIM0_TSCR1_TFFCA_MASK           16U
#define TIM0_TSCR1_TSFRZ_MASK           32U
#define TIM0_TSCR1_TSWAI_MASK           64U
#define TIM0_TSCR1_TEN_MASK             128U


/*** TIM0_TTOV - TIM0 Timer Toggle On Overflow Register; 0x00000047 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte TOV4        :1;                                       /* Toggle On Overflow Bit 4 */
    byte TOV5        :1;                                       /* Toggle On Overflow Bit 5 */
    byte TOV6        :1;                                       /* Toggle On Overflow Bit 6 */
    byte TOV7        :1;                                       /* Toggle On Overflow Bit 7 */
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte grpTOV_4 :4;
  } MergedBits;
} TIM0_TTOVSTR;
extern volatile TIM0_TTOVSTR _TIM0_TTOV @(REG_BASE + 0x00000047UL);
#define TIM0_TTOV                       _TIM0_TTOV.Byte
#define TIM0_TTOV_TOV4                  _TIM0_TTOV.Bits.TOV4
#define TIM0_TTOV_TOV5                  _TIM0_TTOV.Bits.TOV5
#define TIM0_TTOV_TOV6                  _TIM0_TTOV.Bits.TOV6
#define TIM0_TTOV_TOV7                  _TIM0_TTOV.Bits.TOV7
#define TIM0_TTOV_TOV_4                 _TIM0_TTOV.MergedBits.grpTOV_4
#define TIM0_TTOV_TOV                   TIM0_TTOV_TOV_4

#define TIM0_TTOV_TOV4_MASK             16U
#define TIM0_TTOV_TOV5_MASK             32U
#define TIM0_TTOV_TOV6_MASK             64U
#define TIM0_TTOV_TOV7_MASK             128U
#define TIM0_TTOV_TOV_4_MASK            240U
#define TIM0_TTOV_TOV_4_BITNUM          4U


/*** TIM0_TCTL1 - TIM0 Timer Control Register 1; 0x00000048 ***/
typedef union {
  byte Byte;
  struct {
    byte OL4         :1;                                       /* Output Level Bit 4 */
    byte OM4         :1;                                       /* Output Mode Bit 4 */
    byte OL5         :1;                                       /* Output Level Bit 5 */
    byte OM5         :1;                                       /* Output Mode Bit 5 */
    byte OL6         :1;                                       /* Output Level Bit 6 */
    byte OM6         :1;                                       /* Output Mode Bit 6 */
    byte OL7         :1;                                       /* Output Level Bit 7 */
    byte OM7         :1;                                       /* Output Mode Bit 7 */
  } Bits;
} TIM0_TCTL1STR;
extern volatile TIM0_TCTL1STR _TIM0_TCTL1 @(REG_BASE + 0x00000048UL);
#define TIM0_TCTL1                      _TIM0_TCTL1.Byte
#define TIM0_TCTL1_OL4                  _TIM0_TCTL1.Bits.OL4
#define TIM0_TCTL1_OM4                  _TIM0_TCTL1.Bits.OM4
#define TIM0_TCTL1_OL5                  _TIM0_TCTL1.Bits.OL5
#define TIM0_TCTL1_OM5                  _TIM0_TCTL1.Bits.OM5
#define TIM0_TCTL1_OL6                  _TIM0_TCTL1.Bits.OL6
#define TIM0_TCTL1_OM6                  _TIM0_TCTL1.Bits.OM6
#define TIM0_TCTL1_OL7                  _TIM0_TCTL1.Bits.OL7
#define TIM0_TCTL1_OM7                  _TIM0_TCTL1.Bits.OM7

#define TIM0_TCTL1_OL4_MASK             1U
#define TIM0_TCTL1_OM4_MASK             2U
#define TIM0_TCTL1_OL5_MASK             4U
#define TIM0_TCTL1_OM5_MASK             8U
#define TIM0_TCTL1_OL6_MASK             16U
#define TIM0_TCTL1_OM6_MASK             32U
#define TIM0_TCTL1_OL7_MASK             64U
#define TIM0_TCTL1_OM7_MASK             128U


/*** TIM0_TCTL3 - TIM0 Timer Control Register 3; 0x0000004A ***/
typedef union {
  byte Byte;
  struct {
    byte EDG4A       :1;                                       /* Input Capture Edge Control 4A */
    byte EDG4B       :1;                                       /* Input Capture Edge Control 4B */
    byte EDG5A       :1;                                       /* Input Capture Edge Control 5A */
    byte EDG5B       :1;                                       /* Input Capture Edge Control 5B */
    byte EDG6A       :1;                                       /* Input Capture Edge Control 6A */
    byte EDG6B       :1;                                       /* Input Capture Edge Control 6B */
    byte EDG7A       :1;                                       /* Input Capture Edge Control 7A */
    byte EDG7B       :1;                                       /* Input Capture Edge Control 7B */
  } Bits;
  struct {
    byte grpEDG4x :2;
    byte grpEDG5x :2;
    byte grpEDG6x :2;
    byte grpEDG7x :2;
  } MergedBits;
} TIM0_TCTL3STR;
extern volatile TIM0_TCTL3STR _TIM0_TCTL3 @(REG_BASE + 0x0000004AUL);
#define TIM0_TCTL3                      _TIM0_TCTL3.Byte
#define TIM0_TCTL3_EDG4A                _TIM0_TCTL3.Bits.EDG4A
#define TIM0_TCTL3_EDG4B                _TIM0_TCTL3.Bits.EDG4B
#define TIM0_TCTL3_EDG5A                _TIM0_TCTL3.Bits.EDG5A
#define TIM0_TCTL3_EDG5B                _TIM0_TCTL3.Bits.EDG5B
#define TIM0_TCTL3_EDG6A                _TIM0_TCTL3.Bits.EDG6A
#define TIM0_TCTL3_EDG6B                _TIM0_TCTL3.Bits.EDG6B
#define TIM0_TCTL3_EDG7A                _TIM0_TCTL3.Bits.EDG7A
#define TIM0_TCTL3_EDG7B                _TIM0_TCTL3.Bits.EDG7B
#define TIM0_TCTL3_EDG4x                _TIM0_TCTL3.MergedBits.grpEDG4x
#define TIM0_TCTL3_EDG5x                _TIM0_TCTL3.MergedBits.grpEDG5x
#define TIM0_TCTL3_EDG6x                _TIM0_TCTL3.MergedBits.grpEDG6x
#define TIM0_TCTL3_EDG7x                _TIM0_TCTL3.MergedBits.grpEDG7x

#define TIM0_TCTL3_EDG4A_MASK           1U
#define TIM0_TCTL3_EDG4B_MASK           2U
#define TIM0_TCTL3_EDG5A_MASK           4U
#define TIM0_TCTL3_EDG5B_MASK           8U
#define TIM0_TCTL3_EDG6A_MASK           16U
#define TIM0_TCTL3_EDG6B_MASK           32U
#define TIM0_TCTL3_EDG7A_MASK           64U
#define TIM0_TCTL3_EDG7B_MASK           128U
#define TIM0_TCTL3_EDG4x_MASK           3U
#define TIM0_TCTL3_EDG4x_BITNUM         0U
#define TIM0_TCTL3_EDG5x_MASK           12U
#define TIM0_TCTL3_EDG5x_BITNUM         2U
#define TIM0_TCTL3_EDG6x_MASK           48U
#define TIM0_TCTL3_EDG6x_BITNUM         4U
#define TIM0_TCTL3_EDG7x_MASK           192U
#define TIM0_TCTL3_EDG7x_BITNUM         6U


/*** TIM0_TIE - TIM0 Timer Interrupt Enable Register; 0x0000004C ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte C4I         :1;                                       /* Input Capture/Output Compare Interrupt Enable Bit 4 */
    byte C5I         :1;                                       /* Input Capture/Output Compare Interrupt Enable Bit 5 */
    byte C6I         :1;                                       /* Input Capture/Output Compare Interrupt Enable Bit 6 */
    byte C7I         :1;                                       /* Input Capture/Output Compare Interrupt Enable Bit 7 */
  } Bits;
} TIM0_TIESTR;
extern volatile TIM0_TIESTR _TIM0_TIE @(REG_BASE + 0x0000004CUL);
#define TIM0_TIE                        _TIM0_TIE.Byte
#define TIM0_TIE_C4I                    _TIM0_TIE.Bits.C4I
#define TIM0_TIE_C5I                    _TIM0_TIE.Bits.C5I
#define TIM0_TIE_C6I                    _TIM0_TIE.Bits.C6I
#define TIM0_TIE_C7I                    _TIM0_TIE.Bits.C7I

#define TIM0_TIE_C4I_MASK               16U
#define TIM0_TIE_C5I_MASK               32U
#define TIM0_TIE_C6I_MASK               64U
#define TIM0_TIE_C7I_MASK               128U


/*** TIM0_TSCR2 - TIM0 Timer System Control Register 2; 0x0000004D ***/
typedef union {
  byte Byte;
  struct {
    byte PR0         :1;                                       /* Timer Prescaler Select Bit 0 */
    byte PR1         :1;                                       /* Timer Prescaler Select Bit 1 */
    byte PR2         :1;                                       /* Timer Prescaler Select Bit 2 */
    byte TCRE        :1;                                       /* Timer Counter Reset Enable */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte TOI         :1;                                       /* Timer Overflow Interrupt Enable */
  } Bits;
  struct {
    byte grpPR   :3;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} TIM0_TSCR2STR;
extern volatile TIM0_TSCR2STR _TIM0_TSCR2 @(REG_BASE + 0x0000004DUL);
#define TIM0_TSCR2                      _TIM0_TSCR2.Byte
#define TIM0_TSCR2_PR0                  _TIM0_TSCR2.Bits.PR0
#define TIM0_TSCR2_PR1                  _TIM0_TSCR2.Bits.PR1
#define TIM0_TSCR2_PR2                  _TIM0_TSCR2.Bits.PR2
#define TIM0_TSCR2_TCRE                 _TIM0_TSCR2.Bits.TCRE
#define TIM0_TSCR2_TOI                  _TIM0_TSCR2.Bits.TOI
#define TIM0_TSCR2_PR                   _TIM0_TSCR2.MergedBits.grpPR

#define TIM0_TSCR2_PR0_MASK             1U
#define TIM0_TSCR2_PR1_MASK             2U
#define TIM0_TSCR2_PR2_MASK             4U
#define TIM0_TSCR2_TCRE_MASK            8U
#define TIM0_TSCR2_TOI_MASK             128U
#define TIM0_TSCR2_PR_MASK              7U
#define TIM0_TSCR2_PR_BITNUM            0U


/*** TIM0_TFLG1 - TIM0 Main Timer Interrupt Flag 1; 0x0000004E ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte C4F         :1;                                       /* Input Capture/Output Compare Channel Flag 4 */
    byte C5F         :1;                                       /* Input Capture/Output Compare Channel Flag 5 */
    byte C6F         :1;                                       /* Input Capture/Output Compare Channel Flag 6 */
    byte C7F         :1;                                       /* Input Capture/Output Compare Channel Flag 7 */
  } Bits;
} TIM0_TFLG1STR;
extern volatile TIM0_TFLG1STR _TIM0_TFLG1 @(REG_BASE + 0x0000004EUL);
#define TIM0_TFLG1                      _TIM0_TFLG1.Byte
#define TIM0_TFLG1_C4F                  _TIM0_TFLG1.Bits.C4F
#define TIM0_TFLG1_C5F                  _TIM0_TFLG1.Bits.C5F
#define TIM0_TFLG1_C6F                  _TIM0_TFLG1.Bits.C6F
#define TIM0_TFLG1_C7F                  _TIM0_TFLG1.Bits.C7F

#define TIM0_TFLG1_C4F_MASK             16U
#define TIM0_TFLG1_C5F_MASK             32U
#define TIM0_TFLG1_C6F_MASK             64U
#define TIM0_TFLG1_C7F_MASK             128U


/*** TIM0_TFLG2 - TIM0 Main Timer Interrupt Flag 2; 0x0000004F ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte TOF         :1;                                       /* Timer Overflow Flag */
  } Bits;
} TIM0_TFLG2STR;
extern volatile TIM0_TFLG2STR _TIM0_TFLG2 @(REG_BASE + 0x0000004FUL);
#define TIM0_TFLG2                      _TIM0_TFLG2.Byte
#define TIM0_TFLG2_TOF                  _TIM0_TFLG2.Bits.TOF

#define TIM0_TFLG2_TOF_MASK             128U


/*** TIM0_TC4 - TIM0 Timer Input Capture/Output Compare Register 4; 0x00000058 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** TIM0_TC4Hi - TIM0 Timer Input Capture/Output Compare Register 4 High; 0x00000058 ***/
    union {
      byte Byte;
    } TIM0_TC4HiSTR;
    #define TIM0_TC4Hi                  _TIM0_TC4.Overlap_STR.TIM0_TC4HiSTR.Byte
    

    /*** TIM0_TC4Lo - TIM0 Timer Input Capture/Output Compare Register 4 Low; 0x00000059 ***/
    union {
      byte Byte;
    } TIM0_TC4LoSTR;
    #define TIM0_TC4Lo                  _TIM0_TC4.Overlap_STR.TIM0_TC4LoSTR.Byte
    
  } Overlap_STR;

} TIM0_TC4STR;
extern volatile TIM0_TC4STR _TIM0_TC4 @(REG_BASE + 0x00000058UL);
#define TIM0_TC4                        _TIM0_TC4.Word


/*** TIM0_TC5 - TIM0 Timer Input Capture/Output Compare Register 5; 0x0000005A ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** TIM0_TC5Hi - TIM0 Timer Input Capture/Output Compare Register 5 High; 0x0000005A ***/
    union {
      byte Byte;
    } TIM0_TC5HiSTR;
    #define TIM0_TC5Hi                  _TIM0_TC5.Overlap_STR.TIM0_TC5HiSTR.Byte
    

    /*** TIM0_TC5Lo - TIM0 Timer Input Capture/Output Compare Register 5 Low; 0x0000005B ***/
    union {
      byte Byte;
    } TIM0_TC5LoSTR;
    #define TIM0_TC5Lo                  _TIM0_TC5.Overlap_STR.TIM0_TC5LoSTR.Byte
    
  } Overlap_STR;

} TIM0_TC5STR;
extern volatile TIM0_TC5STR _TIM0_TC5 @(REG_BASE + 0x0000005AUL);
#define TIM0_TC5                        _TIM0_TC5.Word


/*** TIM0_TC6 - TIM0 Timer Input Capture/Output Compare Register 6; 0x0000005C ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** TIM0_TC6Hi - TIM0 Timer Input Capture/Output Compare Register 6 High; 0x0000005C ***/
    union {
      byte Byte;
    } TIM0_TC6HiSTR;
    #define TIM0_TC6Hi                  _TIM0_TC6.Overlap_STR.TIM0_TC6HiSTR.Byte
    

    /*** TIM0_TC6Lo - TIM0 Timer Input Capture/Output Compare Register 6 Low; 0x0000005D ***/
    union {
      byte Byte;
    } TIM0_TC6LoSTR;
    #define TIM0_TC6Lo                  _TIM0_TC6.Overlap_STR.TIM0_TC6LoSTR.Byte
    
  } Overlap_STR;

} TIM0_TC6STR;
extern volatile TIM0_TC6STR _TIM0_TC6 @(REG_BASE + 0x0000005CUL);
#define TIM0_TC6                        _TIM0_TC6.Word


/*** TIM0_TC7 - TIM0 Timer Input Capture/Output Compare Register 7; 0x0000005E ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** TIM0_TC7Hi - TIM0 Timer Input Capture/Output Compare Register 7 High; 0x0000005E ***/
    union {
      byte Byte;
    } TIM0_TC7HiSTR;
    #define TIM0_TC7Hi                  _TIM0_TC7.Overlap_STR.TIM0_TC7HiSTR.Byte
    

    /*** TIM0_TC7Lo - TIM0 Timer Input Capture/Output Compare Register 7 Low; 0x0000005F ***/
    union {
      byte Byte;
    } TIM0_TC7LoSTR;
    #define TIM0_TC7Lo                  _TIM0_TC7.Overlap_STR.TIM0_TC7LoSTR.Byte
    
  } Overlap_STR;

} TIM0_TC7STR;
extern volatile TIM0_TC7STR _TIM0_TC7 @(REG_BASE + 0x0000005EUL);
#define TIM0_TC7                        _TIM0_TC7.Word


/*** TIM0_PACTL - TIM0 16-Bit Pulse Accumulator A Control Register; 0x00000060 ***/
typedef union {
  byte Byte;
  struct {
    byte PAI         :1;                                       /* Pulse Accumulator Input Interrupt enable */
    byte PAOVI       :1;                                       /* Pulse Accumulator A Overflow Interrupt enable */
    byte CLK0        :1;                                       /* Clock Select Bit 0 */
    byte CLK1        :1;                                       /* Clock Select Bit 1 */
    byte PEDGE       :1;                                       /* Pulse Accumulator Edge Control */
    byte PAMOD       :1;                                       /* Pulse Accumulator Mode */
    byte PAEN        :1;                                       /* Pulse Accumulator A System Enable */
    byte             :1; 
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte grpCLK  :2;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} TIM0_PACTLSTR;
extern volatile TIM0_PACTLSTR _TIM0_PACTL @(REG_BASE + 0x00000060UL);
#define TIM0_PACTL                      _TIM0_PACTL.Byte
#define TIM0_PACTL_PAI                  _TIM0_PACTL.Bits.PAI
#define TIM0_PACTL_PAOVI                _TIM0_PACTL.Bits.PAOVI
#define TIM0_PACTL_CLK0                 _TIM0_PACTL.Bits.CLK0
#define TIM0_PACTL_CLK1                 _TIM0_PACTL.Bits.CLK1
#define TIM0_PACTL_PEDGE                _TIM0_PACTL.Bits.PEDGE
#define TIM0_PACTL_PAMOD                _TIM0_PACTL.Bits.PAMOD
#define TIM0_PACTL_PAEN                 _TIM0_PACTL.Bits.PAEN
#define TIM0_PACTL_CLK                  _TIM0_PACTL.MergedBits.grpCLK

#define TIM0_PACTL_PAI_MASK             1U
#define TIM0_PACTL_PAOVI_MASK           2U
#define TIM0_PACTL_CLK0_MASK            4U
#define TIM0_PACTL_CLK1_MASK            8U
#define TIM0_PACTL_PEDGE_MASK           16U
#define TIM0_PACTL_PAMOD_MASK           32U
#define TIM0_PACTL_PAEN_MASK            64U
#define TIM0_PACTL_CLK_MASK             12U
#define TIM0_PACTL_CLK_BITNUM           2U


/*** TIM0_PAFLG - TIM0 Pulse Accumulator A Flag Register; 0x00000061 ***/
typedef union {
  byte Byte;
  struct {
    byte PAIF        :1;                                       /* Pulse Accumulator Input edge Flag */
    byte PAOVF       :1;                                       /* Pulse Accumulator A Overflow Flag */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} TIM0_PAFLGSTR;
extern volatile TIM0_PAFLGSTR _TIM0_PAFLG @(REG_BASE + 0x00000061UL);
#define TIM0_PAFLG                      _TIM0_PAFLG.Byte
#define TIM0_PAFLG_PAIF                 _TIM0_PAFLG.Bits.PAIF
#define TIM0_PAFLG_PAOVF                _TIM0_PAFLG.Bits.PAOVF

#define TIM0_PAFLG_PAIF_MASK            1U
#define TIM0_PAFLG_PAOVF_MASK           2U


/*** TIM0_PACNT - TIM0 Pulse Accumulators Count Register; 0x00000062 ***/
typedef union {
  word Word;
} TIM0_PACNTSTR;
extern volatile TIM0_PACNTSTR _TIM0_PACNT @(REG_BASE + 0x00000062UL);
#define TIM0_PACNT                      _TIM0_PACNT.Word


/*** ATDCTL23 - ATD Control Register 23; 0x00000082 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATDCTL2 - ATD Control Register 2; 0x00000082 ***/
    union {
      byte Byte;
      struct {
        byte ASCIF       :1;                                       /* ATD Sequence Complete Interrupt Flag */
        byte ASCIE       :1;                                       /* ATD Sequence Complete Interrupt Enable */
        byte ETRIGE      :1;                                       /* External Trigger Mode enable */
        byte ETRIGP      :1;                                       /* External Trigger Polarity */
        byte ETRIGLE     :1;                                       /* External Trigger Level/Edge control */
        byte AWAI        :1;                                       /* ATD Power Down in Wait Mode */
        byte AFFC        :1;                                       /* ATD Fast Conversion Complete Flag Clear */
        byte ADPU        :1;                                       /* ATD Disable / Power Down */
      } Bits;
    } ATDCTL2STR;
    #define ATDCTL2                     _ATDCTL23.Overlap_STR.ATDCTL2STR.Byte
    #define ATDCTL2_ASCIF               _ATDCTL23.Overlap_STR.ATDCTL2STR.Bits.ASCIF
    #define ATDCTL2_ASCIE               _ATDCTL23.Overlap_STR.ATDCTL2STR.Bits.ASCIE
    #define ATDCTL2_ETRIGE              _ATDCTL23.Overlap_STR.ATDCTL2STR.Bits.ETRIGE
    #define ATDCTL2_ETRIGP              _ATDCTL23.Overlap_STR.ATDCTL2STR.Bits.ETRIGP
    #define ATDCTL2_ETRIGLE             _ATDCTL23.Overlap_STR.ATDCTL2STR.Bits.ETRIGLE
    #define ATDCTL2_AWAI                _ATDCTL23.Overlap_STR.ATDCTL2STR.Bits.AWAI
    #define ATDCTL2_AFFC                _ATDCTL23.Overlap_STR.ATDCTL2STR.Bits.AFFC
    #define ATDCTL2_ADPU                _ATDCTL23.Overlap_STR.ATDCTL2STR.Bits.ADPU
    
    #define ATDCTL2_ASCIF_MASK          1U
    #define ATDCTL2_ASCIE_MASK          2U
    #define ATDCTL2_ETRIGE_MASK         4U
    #define ATDCTL2_ETRIGP_MASK         8U
    #define ATDCTL2_ETRIGLE_MASK        16U
    #define ATDCTL2_AWAI_MASK           32U
    #define ATDCTL2_AFFC_MASK           64U
    #define ATDCTL2_ADPU_MASK           128U
    

    /*** ATDCTL3 - ATD Control Register 3; 0x00000083 ***/
    union {
      byte Byte;
      struct {
        byte FRZ0        :1;                                       /* Background Debug Freeze Enable Bit 0 */
        byte FRZ1        :1;                                       /* Background Debug Freeze Enable Bit 1 */
        byte FIFO        :1;                                       /* Result Register FIFO Mode */
        byte S1C         :1;                                       /* Conversion Sequence Length 1 */
        byte S2C         :1;                                       /* Conversion Sequence Length 2 */
        byte S4C         :1;                                       /* Conversion Sequence Length 4 */
        byte S8C         :1;                                       /* Conversion Sequence Length 8 */
        byte             :1; 
      } Bits;
      struct {
        byte grpFRZ :2;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
      } MergedBits;
    } ATDCTL3STR;
    #define ATDCTL3                     _ATDCTL23.Overlap_STR.ATDCTL3STR.Byte
    #define ATDCTL3_FRZ0                _ATDCTL23.Overlap_STR.ATDCTL3STR.Bits.FRZ0
    #define ATDCTL3_FRZ1                _ATDCTL23.Overlap_STR.ATDCTL3STR.Bits.FRZ1
    #define ATDCTL3_FIFO                _ATDCTL23.Overlap_STR.ATDCTL3STR.Bits.FIFO
    #define ATDCTL3_S1C                 _ATDCTL23.Overlap_STR.ATDCTL3STR.Bits.S1C
    #define ATDCTL3_S2C                 _ATDCTL23.Overlap_STR.ATDCTL3STR.Bits.S2C
    #define ATDCTL3_S4C                 _ATDCTL23.Overlap_STR.ATDCTL3STR.Bits.S4C
    #define ATDCTL3_S8C                 _ATDCTL23.Overlap_STR.ATDCTL3STR.Bits.S8C
    #define ATDCTL3_FRZ                 _ATDCTL23.Overlap_STR.ATDCTL3STR.MergedBits.grpFRZ
    
    #define ATDCTL3_FRZ0_MASK           1U
    #define ATDCTL3_FRZ1_MASK           2U
    #define ATDCTL3_FIFO_MASK           4U
    #define ATDCTL3_S1C_MASK            8U
    #define ATDCTL3_S2C_MASK            16U
    #define ATDCTL3_S4C_MASK            32U
    #define ATDCTL3_S8C_MASK            64U
    #define ATDCTL3_FRZ_MASK            3U
    #define ATDCTL3_FRZ_BITNUM          0U
    
  } Overlap_STR;

  struct {
    word FRZ0        :1;                                       /* Background Debug Freeze Enable Bit 0 */
    word FRZ1        :1;                                       /* Background Debug Freeze Enable Bit 1 */
    word FIFO        :1;                                       /* Result Register FIFO Mode */
    word S1C         :1;                                       /* Conversion Sequence Length 1 */
    word S2C         :1;                                       /* Conversion Sequence Length 2 */
    word S4C         :1;                                       /* Conversion Sequence Length 4 */
    word S8C         :1;                                       /* Conversion Sequence Length 8 */
    word             :1; 
    word ASCIF       :1;                                       /* ATD Sequence Complete Interrupt Flag */
    word ASCIE       :1;                                       /* ATD Sequence Complete Interrupt Enable */
    word ETRIGE      :1;                                       /* External Trigger Mode enable */
    word ETRIGP      :1;                                       /* External Trigger Polarity */
    word ETRIGLE     :1;                                       /* External Trigger Level/Edge control */
    word AWAI        :1;                                       /* ATD Power Down in Wait Mode */
    word AFFC        :1;                                       /* ATD Fast Conversion Complete Flag Clear */
    word ADPU        :1;                                       /* ATD Disable / Power Down */
  } Bits;
  struct {
    word grpFRZ  :2;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} ATDCTL23STR;
extern volatile ATDCTL23STR _ATDCTL23 @(REG_BASE + 0x00000082UL);
#define ATDCTL23                        _ATDCTL23.Word
#define ATDCTL23_FRZ0                   _ATDCTL23.Bits.FRZ0
#define ATDCTL23_FRZ1                   _ATDCTL23.Bits.FRZ1
#define ATDCTL23_FIFO                   _ATDCTL23.Bits.FIFO
#define ATDCTL23_S1C                    _ATDCTL23.Bits.S1C
#define ATDCTL23_S2C                    _ATDCTL23.Bits.S2C
#define ATDCTL23_S4C                    _ATDCTL23.Bits.S4C
#define ATDCTL23_S8C                    _ATDCTL23.Bits.S8C
#define ATDCTL23_ASCIF                  _ATDCTL23.Bits.ASCIF
#define ATDCTL23_ASCIE                  _ATDCTL23.Bits.ASCIE
#define ATDCTL23_ETRIGE                 _ATDCTL23.Bits.ETRIGE
#define ATDCTL23_ETRIGP                 _ATDCTL23.Bits.ETRIGP
#define ATDCTL23_ETRIGLE                _ATDCTL23.Bits.ETRIGLE
#define ATDCTL23_AWAI                   _ATDCTL23.Bits.AWAI
#define ATDCTL23_AFFC                   _ATDCTL23.Bits.AFFC
#define ATDCTL23_ADPU                   _ATDCTL23.Bits.ADPU
#define ATDCTL23_FRZ                    _ATDCTL23.MergedBits.grpFRZ

#define ATDCTL23_FRZ0_MASK              1U
#define ATDCTL23_FRZ1_MASK              2U
#define ATDCTL23_FIFO_MASK              4U
#define ATDCTL23_S1C_MASK               8U
#define ATDCTL23_S2C_MASK               16U
#define ATDCTL23_S4C_MASK               32U
#define ATDCTL23_S8C_MASK               64U
#define ATDCTL23_ASCIF_MASK             256U
#define ATDCTL23_ASCIE_MASK             512U
#define ATDCTL23_ETRIGE_MASK            1024U
#define ATDCTL23_ETRIGP_MASK            2048U
#define ATDCTL23_ETRIGLE_MASK           4096U
#define ATDCTL23_AWAI_MASK              8192U
#define ATDCTL23_AFFC_MASK              16384U
#define ATDCTL23_ADPU_MASK              32768U
#define ATDCTL23_FRZ_MASK               3U
#define ATDCTL23_FRZ_BITNUM             0U


/*** ATDCTL45 - ATD Control Register 45; 0x00000084 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATDCTL4 - ATD Control Register 4; 0x00000084 ***/
    union {
      byte Byte;
      struct {
        byte PRS0        :1;                                       /* ATD Clock Prescaler 0 */
        byte PRS1        :1;                                       /* ATD Clock Prescaler 1 */
        byte PRS2        :1;                                       /* ATD Clock Prescaler 2 */
        byte PRS3        :1;                                       /* ATD Clock Prescaler 3 */
        byte PRS4        :1;                                       /* ATD Clock Prescaler 4 */
        byte SMP0        :1;                                       /* Sample Time Select 0 */
        byte SMP1        :1;                                       /* Sample Time Select 1 */
        byte SRES8       :1;                                       /* ATD Resolution Select */
      } Bits;
      struct {
        byte grpPRS :5;
        byte grpSMP :2;
        byte grpSRES_8 :1;
      } MergedBits;
    } ATDCTL4STR;
    #define ATDCTL4                     _ATDCTL45.Overlap_STR.ATDCTL4STR.Byte
    #define ATDCTL4_PRS0                _ATDCTL45.Overlap_STR.ATDCTL4STR.Bits.PRS0
    #define ATDCTL4_PRS1                _ATDCTL45.Overlap_STR.ATDCTL4STR.Bits.PRS1
    #define ATDCTL4_PRS2                _ATDCTL45.Overlap_STR.ATDCTL4STR.Bits.PRS2
    #define ATDCTL4_PRS3                _ATDCTL45.Overlap_STR.ATDCTL4STR.Bits.PRS3
    #define ATDCTL4_PRS4                _ATDCTL45.Overlap_STR.ATDCTL4STR.Bits.PRS4
    #define ATDCTL4_SMP0                _ATDCTL45.Overlap_STR.ATDCTL4STR.Bits.SMP0
    #define ATDCTL4_SMP1                _ATDCTL45.Overlap_STR.ATDCTL4STR.Bits.SMP1
    #define ATDCTL4_SRES8               _ATDCTL45.Overlap_STR.ATDCTL4STR.Bits.SRES8
    #define ATDCTL4_PRS                 _ATDCTL45.Overlap_STR.ATDCTL4STR.MergedBits.grpPRS
    #define ATDCTL4_SMP                 _ATDCTL45.Overlap_STR.ATDCTL4STR.MergedBits.grpSMP
    
    #define ATDCTL4_PRS0_MASK           1U
    #define ATDCTL4_PRS1_MASK           2U
    #define ATDCTL4_PRS2_MASK           4U
    #define ATDCTL4_PRS3_MASK           8U
    #define ATDCTL4_PRS4_MASK           16U
    #define ATDCTL4_SMP0_MASK           32U
    #define ATDCTL4_SMP1_MASK           64U
    #define ATDCTL4_SRES8_MASK          128U
    #define ATDCTL4_PRS_MASK            31U
    #define ATDCTL4_PRS_BITNUM          0U
    #define ATDCTL4_SMP_MASK            96U
    #define ATDCTL4_SMP_BITNUM          5U
    

    /*** ATDCTL5 - ATD Control Register 5; 0x00000085 ***/
    union {
      byte Byte;
      struct {
        byte CA          :1;                                       /* Analog Input Channel Select Code A */
        byte CB          :1;                                       /* Analog Input Channel Select Code B */
        byte CC          :1;                                       /* Analog Input Channel Select Code C */
        byte CD          :1;                                       /* Analog Input Channel Select Code D */
        byte MULT        :1;                                       /* Multi-Channel Sample Mode */
        byte SCAN        :1;                                       /* Continuous Conversion Sequence Mode */
        byte DSGN        :1;                                       /* Signed/Unsigned Result Data Mode */
        byte DJM         :1;                                       /* Result Register Data Justification Mode */
      } Bits;
      struct {
        byte grpCx :4;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
      } MergedBits;
    } ATDCTL5STR;
    #define ATDCTL5                     _ATDCTL45.Overlap_STR.ATDCTL5STR.Byte
    #define ATDCTL5_CA                  _ATDCTL45.Overlap_STR.ATDCTL5STR.Bits.CA
    #define ATDCTL5_CB                  _ATDCTL45.Overlap_STR.ATDCTL5STR.Bits.CB
    #define ATDCTL5_CC                  _ATDCTL45.Overlap_STR.ATDCTL5STR.Bits.CC
    #define ATDCTL5_CD                  _ATDCTL45.Overlap_STR.ATDCTL5STR.Bits.CD
    #define ATDCTL5_MULT                _ATDCTL45.Overlap_STR.ATDCTL5STR.Bits.MULT
    #define ATDCTL5_SCAN                _ATDCTL45.Overlap_STR.ATDCTL5STR.Bits.SCAN
    #define ATDCTL5_DSGN                _ATDCTL45.Overlap_STR.ATDCTL5STR.Bits.DSGN
    #define ATDCTL5_DJM                 _ATDCTL45.Overlap_STR.ATDCTL5STR.Bits.DJM
    #define ATDCTL5_Cx                  _ATDCTL45.Overlap_STR.ATDCTL5STR.MergedBits.grpCx
    
    #define ATDCTL5_CA_MASK             1U
    #define ATDCTL5_CB_MASK             2U
    #define ATDCTL5_CC_MASK             4U
    #define ATDCTL5_CD_MASK             8U
    #define ATDCTL5_MULT_MASK           16U
    #define ATDCTL5_SCAN_MASK           32U
    #define ATDCTL5_DSGN_MASK           64U
    #define ATDCTL5_DJM_MASK            128U
    #define ATDCTL5_Cx_MASK             15U
    #define ATDCTL5_Cx_BITNUM           0U
    
  } Overlap_STR;

  struct {
    word CA          :1;                                       /* Analog Input Channel Select Code A */
    word CB          :1;                                       /* Analog Input Channel Select Code B */
    word CC          :1;                                       /* Analog Input Channel Select Code C */
    word CD          :1;                                       /* Analog Input Channel Select Code D */
    word MULT        :1;                                       /* Multi-Channel Sample Mode */
    word SCAN        :1;                                       /* Continuous Conversion Sequence Mode */
    word DSGN        :1;                                       /* Signed/Unsigned Result Data Mode */
    word DJM         :1;                                       /* Result Register Data Justification Mode */
    word PRS0        :1;                                       /* ATD Clock Prescaler 0 */
    word PRS1        :1;                                       /* ATD Clock Prescaler 1 */
    word PRS2        :1;                                       /* ATD Clock Prescaler 2 */
    word PRS3        :1;                                       /* ATD Clock Prescaler 3 */
    word PRS4        :1;                                       /* ATD Clock Prescaler 4 */
    word SMP0        :1;                                       /* Sample Time Select 0 */
    word SMP1        :1;                                       /* Sample Time Select 1 */
    word SRES8       :1;                                       /* ATD Resolution Select */
  } Bits;
  struct {
    word grpCx   :4;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpPRS  :5;
    word grpSMP  :2;
    word grpSRES_8 :1;
  } MergedBits;
} ATDCTL45STR;
extern volatile ATDCTL45STR _ATDCTL45 @(REG_BASE + 0x00000084UL);
#define ATDCTL45                        _ATDCTL45.Word
#define ATDCTL45_CA                     _ATDCTL45.Bits.CA
#define ATDCTL45_CB                     _ATDCTL45.Bits.CB
#define ATDCTL45_CC                     _ATDCTL45.Bits.CC
#define ATDCTL45_CD                     _ATDCTL45.Bits.CD
#define ATDCTL45_MULT                   _ATDCTL45.Bits.MULT
#define ATDCTL45_SCAN                   _ATDCTL45.Bits.SCAN
#define ATDCTL45_DSGN                   _ATDCTL45.Bits.DSGN
#define ATDCTL45_DJM                    _ATDCTL45.Bits.DJM
#define ATDCTL45_PRS0                   _ATDCTL45.Bits.PRS0
#define ATDCTL45_PRS1                   _ATDCTL45.Bits.PRS1
#define ATDCTL45_PRS2                   _ATDCTL45.Bits.PRS2
#define ATDCTL45_PRS3                   _ATDCTL45.Bits.PRS3
#define ATDCTL45_PRS4                   _ATDCTL45.Bits.PRS4
#define ATDCTL45_SMP0                   _ATDCTL45.Bits.SMP0
#define ATDCTL45_SMP1                   _ATDCTL45.Bits.SMP1
#define ATDCTL45_SRES8                  _ATDCTL45.Bits.SRES8
#define ATDCTL45_Cx                     _ATDCTL45.MergedBits.grpCx
#define ATDCTL45_PRS                    _ATDCTL45.MergedBits.grpPRS
#define ATDCTL45_SMP                    _ATDCTL45.MergedBits.grpSMP

#define ATDCTL45_CA_MASK                1U
#define ATDCTL45_CB_MASK                2U
#define ATDCTL45_CC_MASK                4U
#define ATDCTL45_CD_MASK                8U
#define ATDCTL45_MULT_MASK              16U
#define ATDCTL45_SCAN_MASK              32U
#define ATDCTL45_DSGN_MASK              64U
#define ATDCTL45_DJM_MASK               128U
#define ATDCTL45_PRS0_MASK              256U
#define ATDCTL45_PRS1_MASK              512U
#define ATDCTL45_PRS2_MASK              1024U
#define ATDCTL45_PRS3_MASK              2048U
#define ATDCTL45_PRS4_MASK              4096U
#define ATDCTL45_SMP0_MASK              8192U
#define ATDCTL45_SMP1_MASK              16384U
#define ATDCTL45_SRES8_MASK             32768U
#define ATDCTL45_Cx_MASK                15U
#define ATDCTL45_Cx_BITNUM              0U
#define ATDCTL45_PRS_MASK               7936U
#define ATDCTL45_PRS_BITNUM             8U
#define ATDCTL45_SMP_MASK               24576U
#define ATDCTL45_SMP_BITNUM             13U


/*** ATDSTAT0 - ATD Status Register 0; 0x00000086 ***/
typedef union {
  byte Byte;
  struct {
    byte CC0         :1;                                       /* Conversion Counter 0 */
    byte CC1         :1;                                       /* Conversion Counter 1 */
    byte CC2         :1;                                       /* Conversion Counter 2 */
    byte CC3         :1;                                       /* Conversion Counter 3 */
    byte FIFOR       :1;                                       /* FIFO Over Run Flag */
    byte ETORF       :1;                                       /* External Trigger Overrun Flag */
    byte             :1; 
    byte SCF         :1;                                       /* Sequence Complete Flag */
  } Bits;
  struct {
    byte grpCC   :4;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} ATDSTAT0STR;
extern volatile ATDSTAT0STR _ATDSTAT0 @(REG_BASE + 0x00000086UL);
#define ATDSTAT0                        _ATDSTAT0.Byte
#define ATDSTAT0_CC0                    _ATDSTAT0.Bits.CC0
#define ATDSTAT0_CC1                    _ATDSTAT0.Bits.CC1
#define ATDSTAT0_CC2                    _ATDSTAT0.Bits.CC2
#define ATDSTAT0_CC3                    _ATDSTAT0.Bits.CC3
#define ATDSTAT0_FIFOR                  _ATDSTAT0.Bits.FIFOR
#define ATDSTAT0_ETORF                  _ATDSTAT0.Bits.ETORF
#define ATDSTAT0_SCF                    _ATDSTAT0.Bits.SCF
#define ATDSTAT0_CC                     _ATDSTAT0.MergedBits.grpCC

#define ATDSTAT0_CC0_MASK               1U
#define ATDSTAT0_CC1_MASK               2U
#define ATDSTAT0_CC2_MASK               4U
#define ATDSTAT0_CC3_MASK               8U
#define ATDSTAT0_FIFOR_MASK             16U
#define ATDSTAT0_ETORF_MASK             32U
#define ATDSTAT0_SCF_MASK               128U
#define ATDSTAT0_CC_MASK                15U
#define ATDSTAT0_CC_BITNUM              0U


/*** ATDTEST1 - ATD Test Register; 0x00000089 ***/
typedef union {
  byte Byte;
  struct {
    byte SC          :1;                                       /* Special Channel Conversion Bit */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} ATDTEST1STR;
extern volatile ATDTEST1STR _ATDTEST1 @(REG_BASE + 0x00000089UL);
#define ATDTEST1                        _ATDTEST1.Byte
#define ATDTEST1_SC                     _ATDTEST1.Bits.SC

#define ATDTEST1_SC_MASK                1U


/*** ATDSTAT2 - ATD Status Register 2; 0x0000008A ***/
typedef union {
  byte Byte;
  struct {
    byte CCF8        :1;                                       /* Conversion Complete Flag 8 */
    byte CCF9        :1;                                       /* Conversion Complete Flag 9 */
    byte CCF10       :1;                                       /* Conversion Complete Flag 10 */
    byte CCF11       :1;                                       /* Conversion Complete Flag 11 */
    byte CCF12       :1;                                       /* Conversion Complete Flag 12 */
    byte CCF13       :1;                                       /* Conversion Complete Flag 13 */
    byte CCF14       :1;                                       /* Conversion Complete Flag 14 */
    byte CCF15       :1;                                       /* Conversion Complete Flag 15 */
  } Bits;
} ATDSTAT2STR;
extern volatile ATDSTAT2STR _ATDSTAT2 @(REG_BASE + 0x0000008AUL);
#define ATDSTAT2                        _ATDSTAT2.Byte
#define ATDSTAT2_CCF8                   _ATDSTAT2.Bits.CCF8
#define ATDSTAT2_CCF9                   _ATDSTAT2.Bits.CCF9
#define ATDSTAT2_CCF10                  _ATDSTAT2.Bits.CCF10
#define ATDSTAT2_CCF11                  _ATDSTAT2.Bits.CCF11
#define ATDSTAT2_CCF12                  _ATDSTAT2.Bits.CCF12
#define ATDSTAT2_CCF13                  _ATDSTAT2.Bits.CCF13
#define ATDSTAT2_CCF14                  _ATDSTAT2.Bits.CCF14
#define ATDSTAT2_CCF15                  _ATDSTAT2.Bits.CCF15

#define ATDSTAT2_CCF8_MASK              1U
#define ATDSTAT2_CCF9_MASK              2U
#define ATDSTAT2_CCF10_MASK             4U
#define ATDSTAT2_CCF11_MASK             8U
#define ATDSTAT2_CCF12_MASK             16U
#define ATDSTAT2_CCF13_MASK             32U
#define ATDSTAT2_CCF14_MASK             64U
#define ATDSTAT2_CCF15_MASK             128U


/*** ATDSTAT1 - ATD Status Register 1; 0x0000008B ***/
typedef union {
  byte Byte;
  struct {
    byte CCF0        :1;                                       /* Conversion Complete Flag 0 */
    byte CCF1        :1;                                       /* Conversion Complete Flag 1 */
    byte CCF2        :1;                                       /* Conversion Complete Flag 2 */
    byte CCF3        :1;                                       /* Conversion Complete Flag 3 */
    byte CCF4        :1;                                       /* Conversion Complete Flag 4 */
    byte CCF5        :1;                                       /* Conversion Complete Flag 5 */
    byte CCF6        :1;                                       /* Conversion Complete Flag 6 */
    byte CCF7        :1;                                       /* Conversion Complete Flag 7 */
  } Bits;
} ATDSTAT1STR;
extern volatile ATDSTAT1STR _ATDSTAT1 @(REG_BASE + 0x0000008BUL);
#define ATDSTAT1                        _ATDSTAT1.Byte
#define ATDSTAT1_CCF0                   _ATDSTAT1.Bits.CCF0
#define ATDSTAT1_CCF1                   _ATDSTAT1.Bits.CCF1
#define ATDSTAT1_CCF2                   _ATDSTAT1.Bits.CCF2
#define ATDSTAT1_CCF3                   _ATDSTAT1.Bits.CCF3
#define ATDSTAT1_CCF4                   _ATDSTAT1.Bits.CCF4
#define ATDSTAT1_CCF5                   _ATDSTAT1.Bits.CCF5
#define ATDSTAT1_CCF6                   _ATDSTAT1.Bits.CCF6
#define ATDSTAT1_CCF7                   _ATDSTAT1.Bits.CCF7

#define ATDSTAT1_CCF0_MASK              1U
#define ATDSTAT1_CCF1_MASK              2U
#define ATDSTAT1_CCF2_MASK              4U
#define ATDSTAT1_CCF3_MASK              8U
#define ATDSTAT1_CCF4_MASK              16U
#define ATDSTAT1_CCF5_MASK              32U
#define ATDSTAT1_CCF6_MASK              64U
#define ATDSTAT1_CCF7_MASK              128U


/*** ATDDIEN - ATD Input Enable Register; 0x0000008C ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATDDIEN0 - ATD Input Enable Register 0; 0x0000008C ***/
    union {
      byte Byte;
      struct {
        byte IEN8        :1;                                       /* ATD Digital Input Enable on channel 8 */
        byte IEN9        :1;                                       /* ATD Digital Input Enable on channel 9 */
        byte IEN10       :1;                                       /* ATD Digital Input Enable on channel 10 */
        byte IEN11       :1;                                       /* ATD Digital Input Enable on channel 11 */
        byte IEN12       :1;                                       /* ATD Digital Input Enable on channel 12 */
        byte IEN13       :1;                                       /* ATD Digital Input Enable on channel 13 */
        byte IEN14       :1;                                       /* ATD Digital Input Enable on channel 14 */
        byte IEN15       :1;                                       /* ATD Digital Input Enable on channel 15 */
      } Bits;
    } ATDDIEN0STR;
    #define ATDDIEN0                    _ATDDIEN.Overlap_STR.ATDDIEN0STR.Byte
    #define ATDDIEN0_IEN8               _ATDDIEN.Overlap_STR.ATDDIEN0STR.Bits.IEN8
    #define ATDDIEN0_IEN9               _ATDDIEN.Overlap_STR.ATDDIEN0STR.Bits.IEN9
    #define ATDDIEN0_IEN10              _ATDDIEN.Overlap_STR.ATDDIEN0STR.Bits.IEN10
    #define ATDDIEN0_IEN11              _ATDDIEN.Overlap_STR.ATDDIEN0STR.Bits.IEN11
    #define ATDDIEN0_IEN12              _ATDDIEN.Overlap_STR.ATDDIEN0STR.Bits.IEN12
    #define ATDDIEN0_IEN13              _ATDDIEN.Overlap_STR.ATDDIEN0STR.Bits.IEN13
    #define ATDDIEN0_IEN14              _ATDDIEN.Overlap_STR.ATDDIEN0STR.Bits.IEN14
    #define ATDDIEN0_IEN15              _ATDDIEN.Overlap_STR.ATDDIEN0STR.Bits.IEN15
    /* ATDDIEN_ARR: Access 2 ATDDIENx registers in an array */
    #define ATDDIEN_ARR                 ((volatile byte *) &ATDDIEN0)
    
    #define ATDDIEN0_IEN8_MASK          1U
    #define ATDDIEN0_IEN9_MASK          2U
    #define ATDDIEN0_IEN10_MASK         4U
    #define ATDDIEN0_IEN11_MASK         8U
    #define ATDDIEN0_IEN12_MASK         16U
    #define ATDDIEN0_IEN13_MASK         32U
    #define ATDDIEN0_IEN14_MASK         64U
    #define ATDDIEN0_IEN15_MASK         128U
    

    /*** ATDDIEN1 - ATD Input Enable Register 1; 0x0000008D ***/
    union {
      byte Byte;
      struct {
        byte IEN0        :1;                                       /* ATD Digital Input Enable on channel 0 */
        byte IEN1        :1;                                       /* ATD Digital Input Enable on channel 1 */
        byte IEN2        :1;                                       /* ATD Digital Input Enable on channel 2 */
        byte IEN3        :1;                                       /* ATD Digital Input Enable on channel 3 */
        byte IEN4        :1;                                       /* ATD Digital Input Enable on channel 4 */
        byte IEN5        :1;                                       /* ATD Digital Input Enable on channel 5 */
        byte IEN6        :1;                                       /* ATD Digital Input Enable on channel 6 */
        byte IEN7        :1;                                       /* ATD Digital Input Enable on channel 7 */
      } Bits;
    } ATDDIEN1STR;
    #define ATDDIEN1                    _ATDDIEN.Overlap_STR.ATDDIEN1STR.Byte
    #define ATDDIEN1_IEN0               _ATDDIEN.Overlap_STR.ATDDIEN1STR.Bits.IEN0
    #define ATDDIEN1_IEN1               _ATDDIEN.Overlap_STR.ATDDIEN1STR.Bits.IEN1
    #define ATDDIEN1_IEN2               _ATDDIEN.Overlap_STR.ATDDIEN1STR.Bits.IEN2
    #define ATDDIEN1_IEN3               _ATDDIEN.Overlap_STR.ATDDIEN1STR.Bits.IEN3
    #define ATDDIEN1_IEN4               _ATDDIEN.Overlap_STR.ATDDIEN1STR.Bits.IEN4
    #define ATDDIEN1_IEN5               _ATDDIEN.Overlap_STR.ATDDIEN1STR.Bits.IEN5
    #define ATDDIEN1_IEN6               _ATDDIEN.Overlap_STR.ATDDIEN1STR.Bits.IEN6
    #define ATDDIEN1_IEN7               _ATDDIEN.Overlap_STR.ATDDIEN1STR.Bits.IEN7
    
    #define ATDDIEN1_IEN0_MASK          1U
    #define ATDDIEN1_IEN1_MASK          2U
    #define ATDDIEN1_IEN2_MASK          4U
    #define ATDDIEN1_IEN3_MASK          8U
    #define ATDDIEN1_IEN4_MASK          16U
    #define ATDDIEN1_IEN5_MASK          32U
    #define ATDDIEN1_IEN6_MASK          64U
    #define ATDDIEN1_IEN7_MASK          128U
    
  } Overlap_STR;

  struct {
    word IEN0        :1;                                       /* ATD Digital Input Enable on channel 0 */
    word IEN1        :1;                                       /* ATD Digital Input Enable on channel 1 */
    word IEN2        :1;                                       /* ATD Digital Input Enable on channel 2 */
    word IEN3        :1;                                       /* ATD Digital Input Enable on channel 3 */
    word IEN4        :1;                                       /* ATD Digital Input Enable on channel 4 */
    word IEN5        :1;                                       /* ATD Digital Input Enable on channel 5 */
    word IEN6        :1;                                       /* ATD Digital Input Enable on channel 6 */
    word IEN7        :1;                                       /* ATD Digital Input Enable on channel 7 */
    word IEN8        :1;                                       /* ATD Digital Input Enable on channel 8 */
    word IEN9        :1;                                       /* ATD Digital Input Enable on channel 9 */
    word IEN10       :1;                                       /* ATD Digital Input Enable on channel 10 */
    word IEN11       :1;                                       /* ATD Digital Input Enable on channel 11 */
    word IEN12       :1;                                       /* ATD Digital Input Enable on channel 12 */
    word IEN13       :1;                                       /* ATD Digital Input Enable on channel 13 */
    word IEN14       :1;                                       /* ATD Digital Input Enable on channel 14 */
    word IEN15       :1;                                       /* ATD Digital Input Enable on channel 15 */
  } Bits;
} ATDDIENSTR;
extern volatile ATDDIENSTR _ATDDIEN @(REG_BASE + 0x0000008CUL);
#define ATDDIEN                         _ATDDIEN.Word
#define ATDDIEN_IEN0                    _ATDDIEN.Bits.IEN0
#define ATDDIEN_IEN1                    _ATDDIEN.Bits.IEN1
#define ATDDIEN_IEN2                    _ATDDIEN.Bits.IEN2
#define ATDDIEN_IEN3                    _ATDDIEN.Bits.IEN3
#define ATDDIEN_IEN4                    _ATDDIEN.Bits.IEN4
#define ATDDIEN_IEN5                    _ATDDIEN.Bits.IEN5
#define ATDDIEN_IEN6                    _ATDDIEN.Bits.IEN6
#define ATDDIEN_IEN7                    _ATDDIEN.Bits.IEN7
#define ATDDIEN_IEN8                    _ATDDIEN.Bits.IEN8
#define ATDDIEN_IEN9                    _ATDDIEN.Bits.IEN9
#define ATDDIEN_IEN10                   _ATDDIEN.Bits.IEN10
#define ATDDIEN_IEN11                   _ATDDIEN.Bits.IEN11
#define ATDDIEN_IEN12                   _ATDDIEN.Bits.IEN12
#define ATDDIEN_IEN13                   _ATDDIEN.Bits.IEN13
#define ATDDIEN_IEN14                   _ATDDIEN.Bits.IEN14
#define ATDDIEN_IEN15                   _ATDDIEN.Bits.IEN15

#define ATDDIEN_IEN0_MASK               1U
#define ATDDIEN_IEN1_MASK               2U
#define ATDDIEN_IEN2_MASK               4U
#define ATDDIEN_IEN3_MASK               8U
#define ATDDIEN_IEN4_MASK               16U
#define ATDDIEN_IEN5_MASK               32U
#define ATDDIEN_IEN6_MASK               64U
#define ATDDIEN_IEN7_MASK               128U
#define ATDDIEN_IEN8_MASK               256U
#define ATDDIEN_IEN9_MASK               512U
#define ATDDIEN_IEN10_MASK              1024U
#define ATDDIEN_IEN11_MASK              2048U
#define ATDDIEN_IEN12_MASK              4096U
#define ATDDIEN_IEN13_MASK              8192U
#define ATDDIEN_IEN14_MASK              16384U
#define ATDDIEN_IEN15_MASK              32768U


/*** PORTAD0 - Port AD0 Register; 0x0000008E ***/
typedef union {
  byte Byte;
  struct {
    byte PTAD8       :1;                                       /* Port AD Bit 8 */
    byte PTAD9       :1;                                       /* Port AD Bit 9 */
    byte PTAD10      :1;                                       /* Port AD Bit 10 */
    byte PTAD11      :1;                                       /* Port AD Bit 11 */
    byte PTAD12      :1;                                       /* Port AD Bit 12 */
    byte PTAD13      :1;                                       /* Port AD Bit 13 */
    byte PTAD14      :1;                                       /* Port AD Bit 14 */
    byte PTAD15      :1;                                       /* Port AD Bit 15 */
  } Bits;
} PORTAD0STR;
extern volatile PORTAD0STR _PORTAD0 @(REG_BASE + 0x0000008EUL);
#define PORTAD0                         _PORTAD0.Byte
#define PORTAD0_PTAD8                   _PORTAD0.Bits.PTAD8
#define PORTAD0_PTAD9                   _PORTAD0.Bits.PTAD9
#define PORTAD0_PTAD10                  _PORTAD0.Bits.PTAD10
#define PORTAD0_PTAD11                  _PORTAD0.Bits.PTAD11
#define PORTAD0_PTAD12                  _PORTAD0.Bits.PTAD12
#define PORTAD0_PTAD13                  _PORTAD0.Bits.PTAD13
#define PORTAD0_PTAD14                  _PORTAD0.Bits.PTAD14
#define PORTAD0_PTAD15                  _PORTAD0.Bits.PTAD15
/* PORTAD_ARR: Access 2 PORTADx registers in an array */
#define PORTAD_ARR                      ((volatile byte *) &PORTAD0)

#define PORTAD0_PTAD8_MASK              1U
#define PORTAD0_PTAD9_MASK              2U
#define PORTAD0_PTAD10_MASK             4U
#define PORTAD0_PTAD11_MASK             8U
#define PORTAD0_PTAD12_MASK             16U
#define PORTAD0_PTAD13_MASK             32U
#define PORTAD0_PTAD14_MASK             64U
#define PORTAD0_PTAD15_MASK             128U


/*** PORTAD1 - Port AD1 Register; 0x0000008F ***/
typedef union {
  byte Byte;
  struct {
    byte PTAD0       :1;                                       /* Port AD Bit 0 */
    byte PTAD1       :1;                                       /* Port AD Bit 1 */
    byte PTAD2       :1;                                       /* Port AD Bit 2 */
    byte PTAD3       :1;                                       /* Port AD Bit 3 */
    byte PTAD4       :1;                                       /* Port AD Bit 4 */
    byte PTAD5       :1;                                       /* Port AD Bit 5 */
    byte PTAD6       :1;                                       /* Port AD Bit 6 */
    byte PTAD7       :1;                                       /* Port AD Bit 7 */
  } Bits;
} PORTAD1STR;
extern volatile PORTAD1STR _PORTAD1 @(REG_BASE + 0x0000008FUL);
#define PORTAD1                         _PORTAD1.Byte
#define PORTAD1_PTAD0                   _PORTAD1.Bits.PTAD0
#define PORTAD1_PTAD1                   _PORTAD1.Bits.PTAD1
#define PORTAD1_PTAD2                   _PORTAD1.Bits.PTAD2
#define PORTAD1_PTAD3                   _PORTAD1.Bits.PTAD3
#define PORTAD1_PTAD4                   _PORTAD1.Bits.PTAD4
#define PORTAD1_PTAD5                   _PORTAD1.Bits.PTAD5
#define PORTAD1_PTAD6                   _PORTAD1.Bits.PTAD6
#define PORTAD1_PTAD7                   _PORTAD1.Bits.PTAD7

#define PORTAD1_PTAD0_MASK              1U
#define PORTAD1_PTAD1_MASK              2U
#define PORTAD1_PTAD2_MASK              4U
#define PORTAD1_PTAD3_MASK              8U
#define PORTAD1_PTAD4_MASK              16U
#define PORTAD1_PTAD5_MASK              32U
#define PORTAD1_PTAD6_MASK              64U
#define PORTAD1_PTAD7_MASK              128U


/*** ATDDR0 - ATD Conversion Result Register 0; 0x00000090 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATDDR0H - ATD Conversion Result Register 0 High; 0x00000090 ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Bit 8 */
        byte BIT9        :1;                                       /* Bit 9 */
        byte BIT10       :1;                                       /* Bit 10 */
        byte BIT11       :1;                                       /* Bit 11 */
        byte BIT12       :1;                                       /* Bit 12 */
        byte BIT13       :1;                                       /* Bit 13 */
        byte BIT14       :1;                                       /* Bit 14 */
        byte BIT15       :1;                                       /* Bit 15 */
      } Bits;
    } ATDDR0HSTR;
    #define ATDDR0H                     _ATDDR0.Overlap_STR.ATDDR0HSTR.Byte
    #define ATDDR0H_BIT8                _ATDDR0.Overlap_STR.ATDDR0HSTR.Bits.BIT8
    #define ATDDR0H_BIT9                _ATDDR0.Overlap_STR.ATDDR0HSTR.Bits.BIT9
    #define ATDDR0H_BIT10               _ATDDR0.Overlap_STR.ATDDR0HSTR.Bits.BIT10
    #define ATDDR0H_BIT11               _ATDDR0.Overlap_STR.ATDDR0HSTR.Bits.BIT11
    #define ATDDR0H_BIT12               _ATDDR0.Overlap_STR.ATDDR0HSTR.Bits.BIT12
    #define ATDDR0H_BIT13               _ATDDR0.Overlap_STR.ATDDR0HSTR.Bits.BIT13
    #define ATDDR0H_BIT14               _ATDDR0.Overlap_STR.ATDDR0HSTR.Bits.BIT14
    #define ATDDR0H_BIT15               _ATDDR0.Overlap_STR.ATDDR0HSTR.Bits.BIT15
    
    #define ATDDR0H_BIT8_MASK           1U
    #define ATDDR0H_BIT9_MASK           2U
    #define ATDDR0H_BIT10_MASK          4U
    #define ATDDR0H_BIT11_MASK          8U
    #define ATDDR0H_BIT12_MASK          16U
    #define ATDDR0H_BIT13_MASK          32U
    #define ATDDR0H_BIT14_MASK          64U
    #define ATDDR0H_BIT15_MASK          128U
    

    /*** ATDDR0L - ATD Conversion Result Register 0 Low; 0x00000091 ***/
    union {
      byte Byte;
      struct {
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte BIT6        :1;                                       /* Bit 6 */
        byte BIT7        :1;                                       /* Bit 7 */
      } Bits;
      struct {
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte grpBIT_6 :2;
      } MergedBits;
    } ATDDR0LSTR;
    #define ATDDR0L                     _ATDDR0.Overlap_STR.ATDDR0LSTR.Byte
    #define ATDDR0L_BIT6                _ATDDR0.Overlap_STR.ATDDR0LSTR.Bits.BIT6
    #define ATDDR0L_BIT7                _ATDDR0.Overlap_STR.ATDDR0LSTR.Bits.BIT7
    #define ATDDR0L_BIT_6               _ATDDR0.Overlap_STR.ATDDR0LSTR.MergedBits.grpBIT_6
    #define ATDDR0L_BIT                 ATDDR0L_BIT_6
    
    #define ATDDR0L_BIT6_MASK           64U
    #define ATDDR0L_BIT7_MASK           128U
    #define ATDDR0L_BIT_6_MASK          192U
    #define ATDDR0L_BIT_6_BITNUM        6U
    
  } Overlap_STR;

  struct {
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word BIT6        :1;                                       /* Bit 6 */
    word BIT7        :1;                                       /* Bit 7 */
    word BIT8        :1;                                       /* Bit 8 */
    word BIT9        :1;                                       /* Bit 9 */
    word BIT10       :1;                                       /* Bit 10 */
    word BIT11       :1;                                       /* Bit 11 */
    word BIT12       :1;                                       /* Bit 12 */
    word BIT13       :1;                                       /* Bit 13 */
    word BIT14       :1;                                       /* Bit 14 */
    word BIT15       :1;                                       /* Bit 15 */
  } Bits;
  struct {
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpBIT_6 :10;
  } MergedBits;
} ATDDR0STR;
extern volatile ATDDR0STR _ATDDR0 @(REG_BASE + 0x00000090UL);
#define ATDDR0                          _ATDDR0.Word
#define ATDDR0_BIT6                     _ATDDR0.Bits.BIT6
#define ATDDR0_BIT7                     _ATDDR0.Bits.BIT7
#define ATDDR0_BIT8                     _ATDDR0.Bits.BIT8
#define ATDDR0_BIT9                     _ATDDR0.Bits.BIT9
#define ATDDR0_BIT10                    _ATDDR0.Bits.BIT10
#define ATDDR0_BIT11                    _ATDDR0.Bits.BIT11
#define ATDDR0_BIT12                    _ATDDR0.Bits.BIT12
#define ATDDR0_BIT13                    _ATDDR0.Bits.BIT13
#define ATDDR0_BIT14                    _ATDDR0.Bits.BIT14
#define ATDDR0_BIT15                    _ATDDR0.Bits.BIT15
/* ATDDR_ARR: Access 16 ATDDRx registers in an array */
#define ATDDR_ARR                       ((volatile word *) &ATDDR0)
#define ATDDR0_BIT_6                    _ATDDR0.MergedBits.grpBIT_6
#define ATDDR0_BIT                      ATDDR0_BIT_6

#define ATDDR0_BIT6_MASK                64U
#define ATDDR0_BIT7_MASK                128U
#define ATDDR0_BIT8_MASK                256U
#define ATDDR0_BIT9_MASK                512U
#define ATDDR0_BIT10_MASK               1024U
#define ATDDR0_BIT11_MASK               2048U
#define ATDDR0_BIT12_MASK               4096U
#define ATDDR0_BIT13_MASK               8192U
#define ATDDR0_BIT14_MASK               16384U
#define ATDDR0_BIT15_MASK               32768U
#define ATDDR0_BIT_6_MASK               65472U
#define ATDDR0_BIT_6_BITNUM             6U


/*** ATDDR1 - ATD Conversion Result Register 1; 0x00000092 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATDDR1H - ATD Conversion Result Register 1 High; 0x00000092 ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Bit 8 */
        byte BIT9        :1;                                       /* Bit 9 */
        byte BIT10       :1;                                       /* Bit 10 */
        byte BIT11       :1;                                       /* Bit 11 */
        byte BIT12       :1;                                       /* Bit 12 */
        byte BIT13       :1;                                       /* Bit 13 */
        byte BIT14       :1;                                       /* Bit 14 */
        byte BIT15       :1;                                       /* Bit 15 */
      } Bits;
    } ATDDR1HSTR;
    #define ATDDR1H                     _ATDDR1.Overlap_STR.ATDDR1HSTR.Byte
    #define ATDDR1H_BIT8                _ATDDR1.Overlap_STR.ATDDR1HSTR.Bits.BIT8
    #define ATDDR1H_BIT9                _ATDDR1.Overlap_STR.ATDDR1HSTR.Bits.BIT9
    #define ATDDR1H_BIT10               _ATDDR1.Overlap_STR.ATDDR1HSTR.Bits.BIT10
    #define ATDDR1H_BIT11               _ATDDR1.Overlap_STR.ATDDR1HSTR.Bits.BIT11
    #define ATDDR1H_BIT12               _ATDDR1.Overlap_STR.ATDDR1HSTR.Bits.BIT12
    #define ATDDR1H_BIT13               _ATDDR1.Overlap_STR.ATDDR1HSTR.Bits.BIT13
    #define ATDDR1H_BIT14               _ATDDR1.Overlap_STR.ATDDR1HSTR.Bits.BIT14
    #define ATDDR1H_BIT15               _ATDDR1.Overlap_STR.ATDDR1HSTR.Bits.BIT15
    
    #define ATDDR1H_BIT8_MASK           1U
    #define ATDDR1H_BIT9_MASK           2U
    #define ATDDR1H_BIT10_MASK          4U
    #define ATDDR1H_BIT11_MASK          8U
    #define ATDDR1H_BIT12_MASK          16U
    #define ATDDR1H_BIT13_MASK          32U
    #define ATDDR1H_BIT14_MASK          64U
    #define ATDDR1H_BIT15_MASK          128U
    

    /*** ATDDR1L - ATD Conversion Result Register 1 Low; 0x00000093 ***/
    union {
      byte Byte;
      struct {
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte BIT6        :1;                                       /* Bit 6 */
        byte BIT7        :1;                                       /* Bit 7 */
      } Bits;
      struct {
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte grpBIT_6 :2;
      } MergedBits;
    } ATDDR1LSTR;
    #define ATDDR1L                     _ATDDR1.Overlap_STR.ATDDR1LSTR.Byte
    #define ATDDR1L_BIT6                _ATDDR1.Overlap_STR.ATDDR1LSTR.Bits.BIT6
    #define ATDDR1L_BIT7                _ATDDR1.Overlap_STR.ATDDR1LSTR.Bits.BIT7
    #define ATDDR1L_BIT_6               _ATDDR1.Overlap_STR.ATDDR1LSTR.MergedBits.grpBIT_6
    #define ATDDR1L_BIT                 ATDDR1L_BIT_6
    
    #define ATDDR1L_BIT6_MASK           64U
    #define ATDDR1L_BIT7_MASK           128U
    #define ATDDR1L_BIT_6_MASK          192U
    #define ATDDR1L_BIT_6_BITNUM        6U
    
  } Overlap_STR;

  struct {
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word BIT6        :1;                                       /* Bit 6 */
    word BIT7        :1;                                       /* Bit 7 */
    word BIT8        :1;                                       /* Bit 8 */
    word BIT9        :1;                                       /* Bit 9 */
    word BIT10       :1;                                       /* Bit 10 */
    word BIT11       :1;                                       /* Bit 11 */
    word BIT12       :1;                                       /* Bit 12 */
    word BIT13       :1;                                       /* Bit 13 */
    word BIT14       :1;                                       /* Bit 14 */
    word BIT15       :1;                                       /* Bit 15 */
  } Bits;
  struct {
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpBIT_6 :10;
  } MergedBits;
} ATDDR1STR;
extern volatile ATDDR1STR _ATDDR1 @(REG_BASE + 0x00000092UL);
#define ATDDR1                          _ATDDR1.Word
#define ATDDR1_BIT6                     _ATDDR1.Bits.BIT6
#define ATDDR1_BIT7                     _ATDDR1.Bits.BIT7
#define ATDDR1_BIT8                     _ATDDR1.Bits.BIT8
#define ATDDR1_BIT9                     _ATDDR1.Bits.BIT9
#define ATDDR1_BIT10                    _ATDDR1.Bits.BIT10
#define ATDDR1_BIT11                    _ATDDR1.Bits.BIT11
#define ATDDR1_BIT12                    _ATDDR1.Bits.BIT12
#define ATDDR1_BIT13                    _ATDDR1.Bits.BIT13
#define ATDDR1_BIT14                    _ATDDR1.Bits.BIT14
#define ATDDR1_BIT15                    _ATDDR1.Bits.BIT15
#define ATDDR1_BIT_6                    _ATDDR1.MergedBits.grpBIT_6
#define ATDDR1_BIT                      ATDDR1_BIT_6

#define ATDDR1_BIT6_MASK                64U
#define ATDDR1_BIT7_MASK                128U
#define ATDDR1_BIT8_MASK                256U
#define ATDDR1_BIT9_MASK                512U
#define ATDDR1_BIT10_MASK               1024U
#define ATDDR1_BIT11_MASK               2048U
#define ATDDR1_BIT12_MASK               4096U
#define ATDDR1_BIT13_MASK               8192U
#define ATDDR1_BIT14_MASK               16384U
#define ATDDR1_BIT15_MASK               32768U
#define ATDDR1_BIT_6_MASK               65472U
#define ATDDR1_BIT_6_BITNUM             6U


/*** ATDDR2 - ATD Conversion Result Register 2; 0x00000094 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATDDR2H - ATD Conversion Result Register 2 High; 0x00000094 ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Bit 8 */
        byte BIT9        :1;                                       /* Bit 9 */
        byte BIT10       :1;                                       /* Bit 10 */
        byte BIT11       :1;                                       /* Bit 11 */
        byte BIT12       :1;                                       /* Bit 12 */
        byte BIT13       :1;                                       /* Bit 13 */
        byte BIT14       :1;                                       /* Bit 14 */
        byte BIT15       :1;                                       /* Bit 15 */
      } Bits;
    } ATDDR2HSTR;
    #define ATDDR2H                     _ATDDR2.Overlap_STR.ATDDR2HSTR.Byte
    #define ATDDR2H_BIT8                _ATDDR2.Overlap_STR.ATDDR2HSTR.Bits.BIT8
    #define ATDDR2H_BIT9                _ATDDR2.Overlap_STR.ATDDR2HSTR.Bits.BIT9
    #define ATDDR2H_BIT10               _ATDDR2.Overlap_STR.ATDDR2HSTR.Bits.BIT10
    #define ATDDR2H_BIT11               _ATDDR2.Overlap_STR.ATDDR2HSTR.Bits.BIT11
    #define ATDDR2H_BIT12               _ATDDR2.Overlap_STR.ATDDR2HSTR.Bits.BIT12
    #define ATDDR2H_BIT13               _ATDDR2.Overlap_STR.ATDDR2HSTR.Bits.BIT13
    #define ATDDR2H_BIT14               _ATDDR2.Overlap_STR.ATDDR2HSTR.Bits.BIT14
    #define ATDDR2H_BIT15               _ATDDR2.Overlap_STR.ATDDR2HSTR.Bits.BIT15
    
    #define ATDDR2H_BIT8_MASK           1U
    #define ATDDR2H_BIT9_MASK           2U
    #define ATDDR2H_BIT10_MASK          4U
    #define ATDDR2H_BIT11_MASK          8U
    #define ATDDR2H_BIT12_MASK          16U
    #define ATDDR2H_BIT13_MASK          32U
    #define ATDDR2H_BIT14_MASK          64U
    #define ATDDR2H_BIT15_MASK          128U
    

    /*** ATDDR2L - ATD Conversion Result Register 2 Low; 0x00000095 ***/
    union {
      byte Byte;
      struct {
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte BIT6        :1;                                       /* Bit 6 */
        byte BIT7        :1;                                       /* Bit 7 */
      } Bits;
      struct {
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte grpBIT_6 :2;
      } MergedBits;
    } ATDDR2LSTR;
    #define ATDDR2L                     _ATDDR2.Overlap_STR.ATDDR2LSTR.Byte
    #define ATDDR2L_BIT6                _ATDDR2.Overlap_STR.ATDDR2LSTR.Bits.BIT6
    #define ATDDR2L_BIT7                _ATDDR2.Overlap_STR.ATDDR2LSTR.Bits.BIT7
    #define ATDDR2L_BIT_6               _ATDDR2.Overlap_STR.ATDDR2LSTR.MergedBits.grpBIT_6
    #define ATDDR2L_BIT                 ATDDR2L_BIT_6
    
    #define ATDDR2L_BIT6_MASK           64U
    #define ATDDR2L_BIT7_MASK           128U
    #define ATDDR2L_BIT_6_MASK          192U
    #define ATDDR2L_BIT_6_BITNUM        6U
    
  } Overlap_STR;

  struct {
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word BIT6        :1;                                       /* Bit 6 */
    word BIT7        :1;                                       /* Bit 7 */
    word BIT8        :1;                                       /* Bit 8 */
    word BIT9        :1;                                       /* Bit 9 */
    word BIT10       :1;                                       /* Bit 10 */
    word BIT11       :1;                                       /* Bit 11 */
    word BIT12       :1;                                       /* Bit 12 */
    word BIT13       :1;                                       /* Bit 13 */
    word BIT14       :1;                                       /* Bit 14 */
    word BIT15       :1;                                       /* Bit 15 */
  } Bits;
  struct {
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpBIT_6 :10;
  } MergedBits;
} ATDDR2STR;
extern volatile ATDDR2STR _ATDDR2 @(REG_BASE + 0x00000094UL);
#define ATDDR2                          _ATDDR2.Word
#define ATDDR2_BIT6                     _ATDDR2.Bits.BIT6
#define ATDDR2_BIT7                     _ATDDR2.Bits.BIT7
#define ATDDR2_BIT8                     _ATDDR2.Bits.BIT8
#define ATDDR2_BIT9                     _ATDDR2.Bits.BIT9
#define ATDDR2_BIT10                    _ATDDR2.Bits.BIT10
#define ATDDR2_BIT11                    _ATDDR2.Bits.BIT11
#define ATDDR2_BIT12                    _ATDDR2.Bits.BIT12
#define ATDDR2_BIT13                    _ATDDR2.Bits.BIT13
#define ATDDR2_BIT14                    _ATDDR2.Bits.BIT14
#define ATDDR2_BIT15                    _ATDDR2.Bits.BIT15
#define ATDDR2_BIT_6                    _ATDDR2.MergedBits.grpBIT_6
#define ATDDR2_BIT                      ATDDR2_BIT_6

#define ATDDR2_BIT6_MASK                64U
#define ATDDR2_BIT7_MASK                128U
#define ATDDR2_BIT8_MASK                256U
#define ATDDR2_BIT9_MASK                512U
#define ATDDR2_BIT10_MASK               1024U
#define ATDDR2_BIT11_MASK               2048U
#define ATDDR2_BIT12_MASK               4096U
#define ATDDR2_BIT13_MASK               8192U
#define ATDDR2_BIT14_MASK               16384U
#define ATDDR2_BIT15_MASK               32768U
#define ATDDR2_BIT_6_MASK               65472U
#define ATDDR2_BIT_6_BITNUM             6U


/*** ATDDR3 - ATD Conversion Result Register 3; 0x00000096 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATDDR3H - ATD Conversion Result Register 3 High; 0x00000096 ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Bit 8 */
        byte BIT9        :1;                                       /* Bit 9 */
        byte BIT10       :1;                                       /* Bit 10 */
        byte BIT11       :1;                                       /* Bit 11 */
        byte BIT12       :1;                                       /* Bit 12 */
        byte BIT13       :1;                                       /* Bit 13 */
        byte BIT14       :1;                                       /* Bit 14 */
        byte BIT15       :1;                                       /* Bit 15 */
      } Bits;
    } ATDDR3HSTR;
    #define ATDDR3H                     _ATDDR3.Overlap_STR.ATDDR3HSTR.Byte
    #define ATDDR3H_BIT8                _ATDDR3.Overlap_STR.ATDDR3HSTR.Bits.BIT8
    #define ATDDR3H_BIT9                _ATDDR3.Overlap_STR.ATDDR3HSTR.Bits.BIT9
    #define ATDDR3H_BIT10               _ATDDR3.Overlap_STR.ATDDR3HSTR.Bits.BIT10
    #define ATDDR3H_BIT11               _ATDDR3.Overlap_STR.ATDDR3HSTR.Bits.BIT11
    #define ATDDR3H_BIT12               _ATDDR3.Overlap_STR.ATDDR3HSTR.Bits.BIT12
    #define ATDDR3H_BIT13               _ATDDR3.Overlap_STR.ATDDR3HSTR.Bits.BIT13
    #define ATDDR3H_BIT14               _ATDDR3.Overlap_STR.ATDDR3HSTR.Bits.BIT14
    #define ATDDR3H_BIT15               _ATDDR3.Overlap_STR.ATDDR3HSTR.Bits.BIT15
    
    #define ATDDR3H_BIT8_MASK           1U
    #define ATDDR3H_BIT9_MASK           2U
    #define ATDDR3H_BIT10_MASK          4U
    #define ATDDR3H_BIT11_MASK          8U
    #define ATDDR3H_BIT12_MASK          16U
    #define ATDDR3H_BIT13_MASK          32U
    #define ATDDR3H_BIT14_MASK          64U
    #define ATDDR3H_BIT15_MASK          128U
    

    /*** ATDDR3L - ATD Conversion Result Register 3 Low; 0x00000097 ***/
    union {
      byte Byte;
      struct {
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte BIT6        :1;                                       /* Bit 6 */
        byte BIT7        :1;                                       /* Bit 7 */
      } Bits;
      struct {
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte grpBIT_6 :2;
      } MergedBits;
    } ATDDR3LSTR;
    #define ATDDR3L                     _ATDDR3.Overlap_STR.ATDDR3LSTR.Byte
    #define ATDDR3L_BIT6                _ATDDR3.Overlap_STR.ATDDR3LSTR.Bits.BIT6
    #define ATDDR3L_BIT7                _ATDDR3.Overlap_STR.ATDDR3LSTR.Bits.BIT7
    #define ATDDR3L_BIT_6               _ATDDR3.Overlap_STR.ATDDR3LSTR.MergedBits.grpBIT_6
    #define ATDDR3L_BIT                 ATDDR3L_BIT_6
    
    #define ATDDR3L_BIT6_MASK           64U
    #define ATDDR3L_BIT7_MASK           128U
    #define ATDDR3L_BIT_6_MASK          192U
    #define ATDDR3L_BIT_6_BITNUM        6U
    
  } Overlap_STR;

  struct {
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word BIT6        :1;                                       /* Bit 6 */
    word BIT7        :1;                                       /* Bit 7 */
    word BIT8        :1;                                       /* Bit 8 */
    word BIT9        :1;                                       /* Bit 9 */
    word BIT10       :1;                                       /* Bit 10 */
    word BIT11       :1;                                       /* Bit 11 */
    word BIT12       :1;                                       /* Bit 12 */
    word BIT13       :1;                                       /* Bit 13 */
    word BIT14       :1;                                       /* Bit 14 */
    word BIT15       :1;                                       /* Bit 15 */
  } Bits;
  struct {
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpBIT_6 :10;
  } MergedBits;
} ATDDR3STR;
extern volatile ATDDR3STR _ATDDR3 @(REG_BASE + 0x00000096UL);
#define ATDDR3                          _ATDDR3.Word
#define ATDDR3_BIT6                     _ATDDR3.Bits.BIT6
#define ATDDR3_BIT7                     _ATDDR3.Bits.BIT7
#define ATDDR3_BIT8                     _ATDDR3.Bits.BIT8
#define ATDDR3_BIT9                     _ATDDR3.Bits.BIT9
#define ATDDR3_BIT10                    _ATDDR3.Bits.BIT10
#define ATDDR3_BIT11                    _ATDDR3.Bits.BIT11
#define ATDDR3_BIT12                    _ATDDR3.Bits.BIT12
#define ATDDR3_BIT13                    _ATDDR3.Bits.BIT13
#define ATDDR3_BIT14                    _ATDDR3.Bits.BIT14
#define ATDDR3_BIT15                    _ATDDR3.Bits.BIT15
#define ATDDR3_BIT_6                    _ATDDR3.MergedBits.grpBIT_6
#define ATDDR3_BIT                      ATDDR3_BIT_6

#define ATDDR3_BIT6_MASK                64U
#define ATDDR3_BIT7_MASK                128U
#define ATDDR3_BIT8_MASK                256U
#define ATDDR3_BIT9_MASK                512U
#define ATDDR3_BIT10_MASK               1024U
#define ATDDR3_BIT11_MASK               2048U
#define ATDDR3_BIT12_MASK               4096U
#define ATDDR3_BIT13_MASK               8192U
#define ATDDR3_BIT14_MASK               16384U
#define ATDDR3_BIT15_MASK               32768U
#define ATDDR3_BIT_6_MASK               65472U
#define ATDDR3_BIT_6_BITNUM             6U


/*** ATDDR4 - ATD Conversion Result Register 4; 0x00000098 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATDDR4H - ATD Conversion Result Register 4 High; 0x00000098 ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Bit 8 */
        byte BIT9        :1;                                       /* Bit 9 */
        byte BIT10       :1;                                       /* Bit 10 */
        byte BIT11       :1;                                       /* Bit 11 */
        byte BIT12       :1;                                       /* Bit 12 */
        byte BIT13       :1;                                       /* Bit 13 */
        byte BIT14       :1;                                       /* Bit 14 */
        byte BIT15       :1;                                       /* Bit 15 */
      } Bits;
    } ATDDR4HSTR;
    #define ATDDR4H                     _ATDDR4.Overlap_STR.ATDDR4HSTR.Byte
    #define ATDDR4H_BIT8                _ATDDR4.Overlap_STR.ATDDR4HSTR.Bits.BIT8
    #define ATDDR4H_BIT9                _ATDDR4.Overlap_STR.ATDDR4HSTR.Bits.BIT9
    #define ATDDR4H_BIT10               _ATDDR4.Overlap_STR.ATDDR4HSTR.Bits.BIT10
    #define ATDDR4H_BIT11               _ATDDR4.Overlap_STR.ATDDR4HSTR.Bits.BIT11
    #define ATDDR4H_BIT12               _ATDDR4.Overlap_STR.ATDDR4HSTR.Bits.BIT12
    #define ATDDR4H_BIT13               _ATDDR4.Overlap_STR.ATDDR4HSTR.Bits.BIT13
    #define ATDDR4H_BIT14               _ATDDR4.Overlap_STR.ATDDR4HSTR.Bits.BIT14
    #define ATDDR4H_BIT15               _ATDDR4.Overlap_STR.ATDDR4HSTR.Bits.BIT15
    
    #define ATDDR4H_BIT8_MASK           1U
    #define ATDDR4H_BIT9_MASK           2U
    #define ATDDR4H_BIT10_MASK          4U
    #define ATDDR4H_BIT11_MASK          8U
    #define ATDDR4H_BIT12_MASK          16U
    #define ATDDR4H_BIT13_MASK          32U
    #define ATDDR4H_BIT14_MASK          64U
    #define ATDDR4H_BIT15_MASK          128U
    

    /*** ATDDR4L - ATD Conversion Result Register 4 Low; 0x00000099 ***/
    union {
      byte Byte;
      struct {
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte BIT6        :1;                                       /* Bit 6 */
        byte BIT7        :1;                                       /* Bit 7 */
      } Bits;
      struct {
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte grpBIT_6 :2;
      } MergedBits;
    } ATDDR4LSTR;
    #define ATDDR4L                     _ATDDR4.Overlap_STR.ATDDR4LSTR.Byte
    #define ATDDR4L_BIT6                _ATDDR4.Overlap_STR.ATDDR4LSTR.Bits.BIT6
    #define ATDDR4L_BIT7                _ATDDR4.Overlap_STR.ATDDR4LSTR.Bits.BIT7
    #define ATDDR4L_BIT_6               _ATDDR4.Overlap_STR.ATDDR4LSTR.MergedBits.grpBIT_6
    #define ATDDR4L_BIT                 ATDDR4L_BIT_6
    
    #define ATDDR4L_BIT6_MASK           64U
    #define ATDDR4L_BIT7_MASK           128U
    #define ATDDR4L_BIT_6_MASK          192U
    #define ATDDR4L_BIT_6_BITNUM        6U
    
  } Overlap_STR;

  struct {
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word BIT6        :1;                                       /* Bit 6 */
    word BIT7        :1;                                       /* Bit 7 */
    word BIT8        :1;                                       /* Bit 8 */
    word BIT9        :1;                                       /* Bit 9 */
    word BIT10       :1;                                       /* Bit 10 */
    word BIT11       :1;                                       /* Bit 11 */
    word BIT12       :1;                                       /* Bit 12 */
    word BIT13       :1;                                       /* Bit 13 */
    word BIT14       :1;                                       /* Bit 14 */
    word BIT15       :1;                                       /* Bit 15 */
  } Bits;
  struct {
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpBIT_6 :10;
  } MergedBits;
} ATDDR4STR;
extern volatile ATDDR4STR _ATDDR4 @(REG_BASE + 0x00000098UL);
#define ATDDR4                          _ATDDR4.Word
#define ATDDR4_BIT6                     _ATDDR4.Bits.BIT6
#define ATDDR4_BIT7                     _ATDDR4.Bits.BIT7
#define ATDDR4_BIT8                     _ATDDR4.Bits.BIT8
#define ATDDR4_BIT9                     _ATDDR4.Bits.BIT9
#define ATDDR4_BIT10                    _ATDDR4.Bits.BIT10
#define ATDDR4_BIT11                    _ATDDR4.Bits.BIT11
#define ATDDR4_BIT12                    _ATDDR4.Bits.BIT12
#define ATDDR4_BIT13                    _ATDDR4.Bits.BIT13
#define ATDDR4_BIT14                    _ATDDR4.Bits.BIT14
#define ATDDR4_BIT15                    _ATDDR4.Bits.BIT15
#define ATDDR4_BIT_6                    _ATDDR4.MergedBits.grpBIT_6
#define ATDDR4_BIT                      ATDDR4_BIT_6

#define ATDDR4_BIT6_MASK                64U
#define ATDDR4_BIT7_MASK                128U
#define ATDDR4_BIT8_MASK                256U
#define ATDDR4_BIT9_MASK                512U
#define ATDDR4_BIT10_MASK               1024U
#define ATDDR4_BIT11_MASK               2048U
#define ATDDR4_BIT12_MASK               4096U
#define ATDDR4_BIT13_MASK               8192U
#define ATDDR4_BIT14_MASK               16384U
#define ATDDR4_BIT15_MASK               32768U
#define ATDDR4_BIT_6_MASK               65472U
#define ATDDR4_BIT_6_BITNUM             6U


/*** ATDDR5 - ATD Conversion Result Register 5; 0x0000009A ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATDDR5H - ATD Conversion Result Register 5 High; 0x0000009A ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Bit 8 */
        byte BIT9        :1;                                       /* Bit 9 */
        byte BIT10       :1;                                       /* Bit 10 */
        byte BIT11       :1;                                       /* Bit 11 */
        byte BIT12       :1;                                       /* Bit 12 */
        byte BIT13       :1;                                       /* Bit 13 */
        byte BIT14       :1;                                       /* Bit 14 */
        byte BIT15       :1;                                       /* Bit 15 */
      } Bits;
    } ATDDR5HSTR;
    #define ATDDR5H                     _ATDDR5.Overlap_STR.ATDDR5HSTR.Byte
    #define ATDDR5H_BIT8                _ATDDR5.Overlap_STR.ATDDR5HSTR.Bits.BIT8
    #define ATDDR5H_BIT9                _ATDDR5.Overlap_STR.ATDDR5HSTR.Bits.BIT9
    #define ATDDR5H_BIT10               _ATDDR5.Overlap_STR.ATDDR5HSTR.Bits.BIT10
    #define ATDDR5H_BIT11               _ATDDR5.Overlap_STR.ATDDR5HSTR.Bits.BIT11
    #define ATDDR5H_BIT12               _ATDDR5.Overlap_STR.ATDDR5HSTR.Bits.BIT12
    #define ATDDR5H_BIT13               _ATDDR5.Overlap_STR.ATDDR5HSTR.Bits.BIT13
    #define ATDDR5H_BIT14               _ATDDR5.Overlap_STR.ATDDR5HSTR.Bits.BIT14
    #define ATDDR5H_BIT15               _ATDDR5.Overlap_STR.ATDDR5HSTR.Bits.BIT15
    
    #define ATDDR5H_BIT8_MASK           1U
    #define ATDDR5H_BIT9_MASK           2U
    #define ATDDR5H_BIT10_MASK          4U
    #define ATDDR5H_BIT11_MASK          8U
    #define ATDDR5H_BIT12_MASK          16U
    #define ATDDR5H_BIT13_MASK          32U
    #define ATDDR5H_BIT14_MASK          64U
    #define ATDDR5H_BIT15_MASK          128U
    

    /*** ATDDR5L - ATD Conversion Result Register 5 Low; 0x0000009B ***/
    union {
      byte Byte;
      struct {
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte BIT6        :1;                                       /* Bit 6 */
        byte BIT7        :1;                                       /* Bit 7 */
      } Bits;
      struct {
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte grpBIT_6 :2;
      } MergedBits;
    } ATDDR5LSTR;
    #define ATDDR5L                     _ATDDR5.Overlap_STR.ATDDR5LSTR.Byte
    #define ATDDR5L_BIT6                _ATDDR5.Overlap_STR.ATDDR5LSTR.Bits.BIT6
    #define ATDDR5L_BIT7                _ATDDR5.Overlap_STR.ATDDR5LSTR.Bits.BIT7
    #define ATDDR5L_BIT_6               _ATDDR5.Overlap_STR.ATDDR5LSTR.MergedBits.grpBIT_6
    #define ATDDR5L_BIT                 ATDDR5L_BIT_6
    
    #define ATDDR5L_BIT6_MASK           64U
    #define ATDDR5L_BIT7_MASK           128U
    #define ATDDR5L_BIT_6_MASK          192U
    #define ATDDR5L_BIT_6_BITNUM        6U
    
  } Overlap_STR;

  struct {
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word BIT6        :1;                                       /* Bit 6 */
    word BIT7        :1;                                       /* Bit 7 */
    word BIT8        :1;                                       /* Bit 8 */
    word BIT9        :1;                                       /* Bit 9 */
    word BIT10       :1;                                       /* Bit 10 */
    word BIT11       :1;                                       /* Bit 11 */
    word BIT12       :1;                                       /* Bit 12 */
    word BIT13       :1;                                       /* Bit 13 */
    word BIT14       :1;                                       /* Bit 14 */
    word BIT15       :1;                                       /* Bit 15 */
  } Bits;
  struct {
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpBIT_6 :10;
  } MergedBits;
} ATDDR5STR;
extern volatile ATDDR5STR _ATDDR5 @(REG_BASE + 0x0000009AUL);
#define ATDDR5                          _ATDDR5.Word
#define ATDDR5_BIT6                     _ATDDR5.Bits.BIT6
#define ATDDR5_BIT7                     _ATDDR5.Bits.BIT7
#define ATDDR5_BIT8                     _ATDDR5.Bits.BIT8
#define ATDDR5_BIT9                     _ATDDR5.Bits.BIT9
#define ATDDR5_BIT10                    _ATDDR5.Bits.BIT10
#define ATDDR5_BIT11                    _ATDDR5.Bits.BIT11
#define ATDDR5_BIT12                    _ATDDR5.Bits.BIT12
#define ATDDR5_BIT13                    _ATDDR5.Bits.BIT13
#define ATDDR5_BIT14                    _ATDDR5.Bits.BIT14
#define ATDDR5_BIT15                    _ATDDR5.Bits.BIT15
#define ATDDR5_BIT_6                    _ATDDR5.MergedBits.grpBIT_6
#define ATDDR5_BIT                      ATDDR5_BIT_6

#define ATDDR5_BIT6_MASK                64U
#define ATDDR5_BIT7_MASK                128U
#define ATDDR5_BIT8_MASK                256U
#define ATDDR5_BIT9_MASK                512U
#define ATDDR5_BIT10_MASK               1024U
#define ATDDR5_BIT11_MASK               2048U
#define ATDDR5_BIT12_MASK               4096U
#define ATDDR5_BIT13_MASK               8192U
#define ATDDR5_BIT14_MASK               16384U
#define ATDDR5_BIT15_MASK               32768U
#define ATDDR5_BIT_6_MASK               65472U
#define ATDDR5_BIT_6_BITNUM             6U


/*** ATDDR6 - ATD Conversion Result Register 6; 0x0000009C ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATDDR6H - ATD Conversion Result Register 6 High; 0x0000009C ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Bit 8 */
        byte BIT9        :1;                                       /* Bit 9 */
        byte BIT10       :1;                                       /* Bit 10 */
        byte BIT11       :1;                                       /* Bit 11 */
        byte BIT12       :1;                                       /* Bit 12 */
        byte BIT13       :1;                                       /* Bit 13 */
        byte BIT14       :1;                                       /* Bit 14 */
        byte BIT15       :1;                                       /* Bit 15 */
      } Bits;
    } ATDDR6HSTR;
    #define ATDDR6H                     _ATDDR6.Overlap_STR.ATDDR6HSTR.Byte
    #define ATDDR6H_BIT8                _ATDDR6.Overlap_STR.ATDDR6HSTR.Bits.BIT8
    #define ATDDR6H_BIT9                _ATDDR6.Overlap_STR.ATDDR6HSTR.Bits.BIT9
    #define ATDDR6H_BIT10               _ATDDR6.Overlap_STR.ATDDR6HSTR.Bits.BIT10
    #define ATDDR6H_BIT11               _ATDDR6.Overlap_STR.ATDDR6HSTR.Bits.BIT11
    #define ATDDR6H_BIT12               _ATDDR6.Overlap_STR.ATDDR6HSTR.Bits.BIT12
    #define ATDDR6H_BIT13               _ATDDR6.Overlap_STR.ATDDR6HSTR.Bits.BIT13
    #define ATDDR6H_BIT14               _ATDDR6.Overlap_STR.ATDDR6HSTR.Bits.BIT14
    #define ATDDR6H_BIT15               _ATDDR6.Overlap_STR.ATDDR6HSTR.Bits.BIT15
    
    #define ATDDR6H_BIT8_MASK           1U
    #define ATDDR6H_BIT9_MASK           2U
    #define ATDDR6H_BIT10_MASK          4U
    #define ATDDR6H_BIT11_MASK          8U
    #define ATDDR6H_BIT12_MASK          16U
    #define ATDDR6H_BIT13_MASK          32U
    #define ATDDR6H_BIT14_MASK          64U
    #define ATDDR6H_BIT15_MASK          128U
    

    /*** ATDDR6L - ATD Conversion Result Register 6 Low; 0x0000009D ***/
    union {
      byte Byte;
      struct {
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte BIT6        :1;                                       /* Bit 6 */
        byte BIT7        :1;                                       /* Bit 7 */
      } Bits;
      struct {
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte grpBIT_6 :2;
      } MergedBits;
    } ATDDR6LSTR;
    #define ATDDR6L                     _ATDDR6.Overlap_STR.ATDDR6LSTR.Byte
    #define ATDDR6L_BIT6                _ATDDR6.Overlap_STR.ATDDR6LSTR.Bits.BIT6
    #define ATDDR6L_BIT7                _ATDDR6.Overlap_STR.ATDDR6LSTR.Bits.BIT7
    #define ATDDR6L_BIT_6               _ATDDR6.Overlap_STR.ATDDR6LSTR.MergedBits.grpBIT_6
    #define ATDDR6L_BIT                 ATDDR6L_BIT_6
    
    #define ATDDR6L_BIT6_MASK           64U
    #define ATDDR6L_BIT7_MASK           128U
    #define ATDDR6L_BIT_6_MASK          192U
    #define ATDDR6L_BIT_6_BITNUM        6U
    
  } Overlap_STR;

  struct {
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word BIT6        :1;                                       /* Bit 6 */
    word BIT7        :1;                                       /* Bit 7 */
    word BIT8        :1;                                       /* Bit 8 */
    word BIT9        :1;                                       /* Bit 9 */
    word BIT10       :1;                                       /* Bit 10 */
    word BIT11       :1;                                       /* Bit 11 */
    word BIT12       :1;                                       /* Bit 12 */
    word BIT13       :1;                                       /* Bit 13 */
    word BIT14       :1;                                       /* Bit 14 */
    word BIT15       :1;                                       /* Bit 15 */
  } Bits;
  struct {
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpBIT_6 :10;
  } MergedBits;
} ATDDR6STR;
extern volatile ATDDR6STR _ATDDR6 @(REG_BASE + 0x0000009CUL);
#define ATDDR6                          _ATDDR6.Word
#define ATDDR6_BIT6                     _ATDDR6.Bits.BIT6
#define ATDDR6_BIT7                     _ATDDR6.Bits.BIT7
#define ATDDR6_BIT8                     _ATDDR6.Bits.BIT8
#define ATDDR6_BIT9                     _ATDDR6.Bits.BIT9
#define ATDDR6_BIT10                    _ATDDR6.Bits.BIT10
#define ATDDR6_BIT11                    _ATDDR6.Bits.BIT11
#define ATDDR6_BIT12                    _ATDDR6.Bits.BIT12
#define ATDDR6_BIT13                    _ATDDR6.Bits.BIT13
#define ATDDR6_BIT14                    _ATDDR6.Bits.BIT14
#define ATDDR6_BIT15                    _ATDDR6.Bits.BIT15
#define ATDDR6_BIT_6                    _ATDDR6.MergedBits.grpBIT_6
#define ATDDR6_BIT                      ATDDR6_BIT_6

#define ATDDR6_BIT6_MASK                64U
#define ATDDR6_BIT7_MASK                128U
#define ATDDR6_BIT8_MASK                256U
#define ATDDR6_BIT9_MASK                512U
#define ATDDR6_BIT10_MASK               1024U
#define ATDDR6_BIT11_MASK               2048U
#define ATDDR6_BIT12_MASK               4096U
#define ATDDR6_BIT13_MASK               8192U
#define ATDDR6_BIT14_MASK               16384U
#define ATDDR6_BIT15_MASK               32768U
#define ATDDR6_BIT_6_MASK               65472U
#define ATDDR6_BIT_6_BITNUM             6U


/*** ATDDR7 - ATD Conversion Result Register 7; 0x0000009E ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATDDR7H - ATD Conversion Result Register 7 High; 0x0000009E ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Bit 8 */
        byte BIT9        :1;                                       /* Bit 9 */
        byte BIT10       :1;                                       /* Bit 10 */
        byte BIT11       :1;                                       /* Bit 11 */
        byte BIT12       :1;                                       /* Bit 12 */
        byte BIT13       :1;                                       /* Bit 13 */
        byte BIT14       :1;                                       /* Bit 14 */
        byte BIT15       :1;                                       /* Bit 15 */
      } Bits;
    } ATDDR7HSTR;
    #define ATDDR7H                     _ATDDR7.Overlap_STR.ATDDR7HSTR.Byte
    #define ATDDR7H_BIT8                _ATDDR7.Overlap_STR.ATDDR7HSTR.Bits.BIT8
    #define ATDDR7H_BIT9                _ATDDR7.Overlap_STR.ATDDR7HSTR.Bits.BIT9
    #define ATDDR7H_BIT10               _ATDDR7.Overlap_STR.ATDDR7HSTR.Bits.BIT10
    #define ATDDR7H_BIT11               _ATDDR7.Overlap_STR.ATDDR7HSTR.Bits.BIT11
    #define ATDDR7H_BIT12               _ATDDR7.Overlap_STR.ATDDR7HSTR.Bits.BIT12
    #define ATDDR7H_BIT13               _ATDDR7.Overlap_STR.ATDDR7HSTR.Bits.BIT13
    #define ATDDR7H_BIT14               _ATDDR7.Overlap_STR.ATDDR7HSTR.Bits.BIT14
    #define ATDDR7H_BIT15               _ATDDR7.Overlap_STR.ATDDR7HSTR.Bits.BIT15
    
    #define ATDDR7H_BIT8_MASK           1U
    #define ATDDR7H_BIT9_MASK           2U
    #define ATDDR7H_BIT10_MASK          4U
    #define ATDDR7H_BIT11_MASK          8U
    #define ATDDR7H_BIT12_MASK          16U
    #define ATDDR7H_BIT13_MASK          32U
    #define ATDDR7H_BIT14_MASK          64U
    #define ATDDR7H_BIT15_MASK          128U
    

    /*** ATDDR7L - ATD Conversion Result Register 7 Low; 0x0000009F ***/
    union {
      byte Byte;
      struct {
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte BIT6        :1;                                       /* Bit 6 */
        byte BIT7        :1;                                       /* Bit 7 */
      } Bits;
      struct {
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte grpBIT_6 :2;
      } MergedBits;
    } ATDDR7LSTR;
    #define ATDDR7L                     _ATDDR7.Overlap_STR.ATDDR7LSTR.Byte
    #define ATDDR7L_BIT6                _ATDDR7.Overlap_STR.ATDDR7LSTR.Bits.BIT6
    #define ATDDR7L_BIT7                _ATDDR7.Overlap_STR.ATDDR7LSTR.Bits.BIT7
    #define ATDDR7L_BIT_6               _ATDDR7.Overlap_STR.ATDDR7LSTR.MergedBits.grpBIT_6
    #define ATDDR7L_BIT                 ATDDR7L_BIT_6
    
    #define ATDDR7L_BIT6_MASK           64U
    #define ATDDR7L_BIT7_MASK           128U
    #define ATDDR7L_BIT_6_MASK          192U
    #define ATDDR7L_BIT_6_BITNUM        6U
    
  } Overlap_STR;

  struct {
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word BIT6        :1;                                       /* Bit 6 */
    word BIT7        :1;                                       /* Bit 7 */
    word BIT8        :1;                                       /* Bit 8 */
    word BIT9        :1;                                       /* Bit 9 */
    word BIT10       :1;                                       /* Bit 10 */
    word BIT11       :1;                                       /* Bit 11 */
    word BIT12       :1;                                       /* Bit 12 */
    word BIT13       :1;                                       /* Bit 13 */
    word BIT14       :1;                                       /* Bit 14 */
    word BIT15       :1;                                       /* Bit 15 */
  } Bits;
  struct {
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpBIT_6 :10;
  } MergedBits;
} ATDDR7STR;
extern volatile ATDDR7STR _ATDDR7 @(REG_BASE + 0x0000009EUL);
#define ATDDR7                          _ATDDR7.Word
#define ATDDR7_BIT6                     _ATDDR7.Bits.BIT6
#define ATDDR7_BIT7                     _ATDDR7.Bits.BIT7
#define ATDDR7_BIT8                     _ATDDR7.Bits.BIT8
#define ATDDR7_BIT9                     _ATDDR7.Bits.BIT9
#define ATDDR7_BIT10                    _ATDDR7.Bits.BIT10
#define ATDDR7_BIT11                    _ATDDR7.Bits.BIT11
#define ATDDR7_BIT12                    _ATDDR7.Bits.BIT12
#define ATDDR7_BIT13                    _ATDDR7.Bits.BIT13
#define ATDDR7_BIT14                    _ATDDR7.Bits.BIT14
#define ATDDR7_BIT15                    _ATDDR7.Bits.BIT15
#define ATDDR7_BIT_6                    _ATDDR7.MergedBits.grpBIT_6
#define ATDDR7_BIT                      ATDDR7_BIT_6

#define ATDDR7_BIT6_MASK                64U
#define ATDDR7_BIT7_MASK                128U
#define ATDDR7_BIT8_MASK                256U
#define ATDDR7_BIT9_MASK                512U
#define ATDDR7_BIT10_MASK               1024U
#define ATDDR7_BIT11_MASK               2048U
#define ATDDR7_BIT12_MASK               4096U
#define ATDDR7_BIT13_MASK               8192U
#define ATDDR7_BIT14_MASK               16384U
#define ATDDR7_BIT15_MASK               32768U
#define ATDDR7_BIT_6_MASK               65472U
#define ATDDR7_BIT_6_BITNUM             6U


/*** ATDDR8 - ATD Conversion Result Register 8; 0x000000A0 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATDDR8H - ATD Conversion Result Register 8 High; 0x000000A0 ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Bit 8 */
        byte BIT9        :1;                                       /* Bit 9 */
        byte BIT10       :1;                                       /* Bit 10 */
        byte BIT11       :1;                                       /* Bit 11 */
        byte BIT12       :1;                                       /* Bit 12 */
        byte BIT13       :1;                                       /* Bit 13 */
        byte BIT14       :1;                                       /* Bit 14 */
        byte BIT15       :1;                                       /* Bit 15 */
      } Bits;
    } ATDDR8HSTR;
    #define ATDDR8H                     _ATDDR8.Overlap_STR.ATDDR8HSTR.Byte
    #define ATDDR8H_BIT8                _ATDDR8.Overlap_STR.ATDDR8HSTR.Bits.BIT8
    #define ATDDR8H_BIT9                _ATDDR8.Overlap_STR.ATDDR8HSTR.Bits.BIT9
    #define ATDDR8H_BIT10               _ATDDR8.Overlap_STR.ATDDR8HSTR.Bits.BIT10
    #define ATDDR8H_BIT11               _ATDDR8.Overlap_STR.ATDDR8HSTR.Bits.BIT11
    #define ATDDR8H_BIT12               _ATDDR8.Overlap_STR.ATDDR8HSTR.Bits.BIT12
    #define ATDDR8H_BIT13               _ATDDR8.Overlap_STR.ATDDR8HSTR.Bits.BIT13
    #define ATDDR8H_BIT14               _ATDDR8.Overlap_STR.ATDDR8HSTR.Bits.BIT14
    #define ATDDR8H_BIT15               _ATDDR8.Overlap_STR.ATDDR8HSTR.Bits.BIT15
    
    #define ATDDR8H_BIT8_MASK           1U
    #define ATDDR8H_BIT9_MASK           2U
    #define ATDDR8H_BIT10_MASK          4U
    #define ATDDR8H_BIT11_MASK          8U
    #define ATDDR8H_BIT12_MASK          16U
    #define ATDDR8H_BIT13_MASK          32U
    #define ATDDR8H_BIT14_MASK          64U
    #define ATDDR8H_BIT15_MASK          128U
    

    /*** ATDDR8L - ATD Conversion Result Register 8 Low; 0x000000A1 ***/
    union {
      byte Byte;
      struct {
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte BIT6        :1;                                       /* Bit 6 */
        byte BIT7        :1;                                       /* Bit 7 */
      } Bits;
      struct {
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte grpBIT_6 :2;
      } MergedBits;
    } ATDDR8LSTR;
    #define ATDDR8L                     _ATDDR8.Overlap_STR.ATDDR8LSTR.Byte
    #define ATDDR8L_BIT6                _ATDDR8.Overlap_STR.ATDDR8LSTR.Bits.BIT6
    #define ATDDR8L_BIT7                _ATDDR8.Overlap_STR.ATDDR8LSTR.Bits.BIT7
    #define ATDDR8L_BIT_6               _ATDDR8.Overlap_STR.ATDDR8LSTR.MergedBits.grpBIT_6
    #define ATDDR8L_BIT                 ATDDR8L_BIT_6
    
    #define ATDDR8L_BIT6_MASK           64U
    #define ATDDR8L_BIT7_MASK           128U
    #define ATDDR8L_BIT_6_MASK          192U
    #define ATDDR8L_BIT_6_BITNUM        6U
    
  } Overlap_STR;

  struct {
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word BIT6        :1;                                       /* Bit 6 */
    word BIT7        :1;                                       /* Bit 7 */
    word BIT8        :1;                                       /* Bit 8 */
    word BIT9        :1;                                       /* Bit 9 */
    word BIT10       :1;                                       /* Bit 10 */
    word BIT11       :1;                                       /* Bit 11 */
    word BIT12       :1;                                       /* Bit 12 */
    word BIT13       :1;                                       /* Bit 13 */
    word BIT14       :1;                                       /* Bit 14 */
    word BIT15       :1;                                       /* Bit 15 */
  } Bits;
  struct {
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpBIT_6 :10;
  } MergedBits;
} ATDDR8STR;
extern volatile ATDDR8STR _ATDDR8 @(REG_BASE + 0x000000A0UL);
#define ATDDR8                          _ATDDR8.Word
#define ATDDR8_BIT6                     _ATDDR8.Bits.BIT6
#define ATDDR8_BIT7                     _ATDDR8.Bits.BIT7
#define ATDDR8_BIT8                     _ATDDR8.Bits.BIT8
#define ATDDR8_BIT9                     _ATDDR8.Bits.BIT9
#define ATDDR8_BIT10                    _ATDDR8.Bits.BIT10
#define ATDDR8_BIT11                    _ATDDR8.Bits.BIT11
#define ATDDR8_BIT12                    _ATDDR8.Bits.BIT12
#define ATDDR8_BIT13                    _ATDDR8.Bits.BIT13
#define ATDDR8_BIT14                    _ATDDR8.Bits.BIT14
#define ATDDR8_BIT15                    _ATDDR8.Bits.BIT15
#define ATDDR8_BIT_6                    _ATDDR8.MergedBits.grpBIT_6
#define ATDDR8_BIT                      ATDDR8_BIT_6

#define ATDDR8_BIT6_MASK                64U
#define ATDDR8_BIT7_MASK                128U
#define ATDDR8_BIT8_MASK                256U
#define ATDDR8_BIT9_MASK                512U
#define ATDDR8_BIT10_MASK               1024U
#define ATDDR8_BIT11_MASK               2048U
#define ATDDR8_BIT12_MASK               4096U
#define ATDDR8_BIT13_MASK               8192U
#define ATDDR8_BIT14_MASK               16384U
#define ATDDR8_BIT15_MASK               32768U
#define ATDDR8_BIT_6_MASK               65472U
#define ATDDR8_BIT_6_BITNUM             6U


/*** ATDDR9 - ATD Conversion Result Register 9; 0x000000A2 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATDDR9H - ATD Conversion Result Register 9 High; 0x000000A2 ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Bit 8 */
        byte BIT9        :1;                                       /* Bit 9 */
        byte BIT10       :1;                                       /* Bit 10 */
        byte BIT11       :1;                                       /* Bit 11 */
        byte BIT12       :1;                                       /* Bit 12 */
        byte BIT13       :1;                                       /* Bit 13 */
        byte BIT14       :1;                                       /* Bit 14 */
        byte BIT15       :1;                                       /* Bit 15 */
      } Bits;
    } ATDDR9HSTR;
    #define ATDDR9H                     _ATDDR9.Overlap_STR.ATDDR9HSTR.Byte
    #define ATDDR9H_BIT8                _ATDDR9.Overlap_STR.ATDDR9HSTR.Bits.BIT8
    #define ATDDR9H_BIT9                _ATDDR9.Overlap_STR.ATDDR9HSTR.Bits.BIT9
    #define ATDDR9H_BIT10               _ATDDR9.Overlap_STR.ATDDR9HSTR.Bits.BIT10
    #define ATDDR9H_BIT11               _ATDDR9.Overlap_STR.ATDDR9HSTR.Bits.BIT11
    #define ATDDR9H_BIT12               _ATDDR9.Overlap_STR.ATDDR9HSTR.Bits.BIT12
    #define ATDDR9H_BIT13               _ATDDR9.Overlap_STR.ATDDR9HSTR.Bits.BIT13
    #define ATDDR9H_BIT14               _ATDDR9.Overlap_STR.ATDDR9HSTR.Bits.BIT14
    #define ATDDR9H_BIT15               _ATDDR9.Overlap_STR.ATDDR9HSTR.Bits.BIT15
    
    #define ATDDR9H_BIT8_MASK           1U
    #define ATDDR9H_BIT9_MASK           2U
    #define ATDDR9H_BIT10_MASK          4U
    #define ATDDR9H_BIT11_MASK          8U
    #define ATDDR9H_BIT12_MASK          16U
    #define ATDDR9H_BIT13_MASK          32U
    #define ATDDR9H_BIT14_MASK          64U
    #define ATDDR9H_BIT15_MASK          128U
    

    /*** ATDDR9L - ATD Conversion Result Register 9 Low; 0x000000A3 ***/
    union {
      byte Byte;
      struct {
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte BIT6        :1;                                       /* Bit 6 */
        byte BIT7        :1;                                       /* Bit 7 */
      } Bits;
      struct {
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte grpBIT_6 :2;
      } MergedBits;
    } ATDDR9LSTR;
    #define ATDDR9L                     _ATDDR9.Overlap_STR.ATDDR9LSTR.Byte
    #define ATDDR9L_BIT6                _ATDDR9.Overlap_STR.ATDDR9LSTR.Bits.BIT6
    #define ATDDR9L_BIT7                _ATDDR9.Overlap_STR.ATDDR9LSTR.Bits.BIT7
    #define ATDDR9L_BIT_6               _ATDDR9.Overlap_STR.ATDDR9LSTR.MergedBits.grpBIT_6
    #define ATDDR9L_BIT                 ATDDR9L_BIT_6
    
    #define ATDDR9L_BIT6_MASK           64U
    #define ATDDR9L_BIT7_MASK           128U
    #define ATDDR9L_BIT_6_MASK          192U
    #define ATDDR9L_BIT_6_BITNUM        6U
    
  } Overlap_STR;

  struct {
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word BIT6        :1;                                       /* Bit 6 */
    word BIT7        :1;                                       /* Bit 7 */
    word BIT8        :1;                                       /* Bit 8 */
    word BIT9        :1;                                       /* Bit 9 */
    word BIT10       :1;                                       /* Bit 10 */
    word BIT11       :1;                                       /* Bit 11 */
    word BIT12       :1;                                       /* Bit 12 */
    word BIT13       :1;                                       /* Bit 13 */
    word BIT14       :1;                                       /* Bit 14 */
    word BIT15       :1;                                       /* Bit 15 */
  } Bits;
  struct {
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpBIT_6 :10;
  } MergedBits;
} ATDDR9STR;
extern volatile ATDDR9STR _ATDDR9 @(REG_BASE + 0x000000A2UL);
#define ATDDR9                          _ATDDR9.Word
#define ATDDR9_BIT6                     _ATDDR9.Bits.BIT6
#define ATDDR9_BIT7                     _ATDDR9.Bits.BIT7
#define ATDDR9_BIT8                     _ATDDR9.Bits.BIT8
#define ATDDR9_BIT9                     _ATDDR9.Bits.BIT9
#define ATDDR9_BIT10                    _ATDDR9.Bits.BIT10
#define ATDDR9_BIT11                    _ATDDR9.Bits.BIT11
#define ATDDR9_BIT12                    _ATDDR9.Bits.BIT12
#define ATDDR9_BIT13                    _ATDDR9.Bits.BIT13
#define ATDDR9_BIT14                    _ATDDR9.Bits.BIT14
#define ATDDR9_BIT15                    _ATDDR9.Bits.BIT15
#define ATDDR9_BIT_6                    _ATDDR9.MergedBits.grpBIT_6
#define ATDDR9_BIT                      ATDDR9_BIT_6

#define ATDDR9_BIT6_MASK                64U
#define ATDDR9_BIT7_MASK                128U
#define ATDDR9_BIT8_MASK                256U
#define ATDDR9_BIT9_MASK                512U
#define ATDDR9_BIT10_MASK               1024U
#define ATDDR9_BIT11_MASK               2048U
#define ATDDR9_BIT12_MASK               4096U
#define ATDDR9_BIT13_MASK               8192U
#define ATDDR9_BIT14_MASK               16384U
#define ATDDR9_BIT15_MASK               32768U
#define ATDDR9_BIT_6_MASK               65472U
#define ATDDR9_BIT_6_BITNUM             6U


/*** ATDDR10 - ATD Conversion Result Register 10; 0x000000A4 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATDDR10H - ATD Conversion Result Register 10 High; 0x000000A4 ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Bit 8 */
        byte BIT9        :1;                                       /* Bit 9 */
        byte BIT10       :1;                                       /* Bit 10 */
        byte BIT11       :1;                                       /* Bit 11 */
        byte BIT12       :1;                                       /* Bit 12 */
        byte BIT13       :1;                                       /* Bit 13 */
        byte BIT14       :1;                                       /* Bit 14 */
        byte BIT15       :1;                                       /* Bit 15 */
      } Bits;
    } ATDDR10HSTR;
    #define ATDDR10H                    _ATDDR10.Overlap_STR.ATDDR10HSTR.Byte
    #define ATDDR10H_BIT8               _ATDDR10.Overlap_STR.ATDDR10HSTR.Bits.BIT8
    #define ATDDR10H_BIT9               _ATDDR10.Overlap_STR.ATDDR10HSTR.Bits.BIT9
    #define ATDDR10H_BIT10              _ATDDR10.Overlap_STR.ATDDR10HSTR.Bits.BIT10
    #define ATDDR10H_BIT11              _ATDDR10.Overlap_STR.ATDDR10HSTR.Bits.BIT11
    #define ATDDR10H_BIT12              _ATDDR10.Overlap_STR.ATDDR10HSTR.Bits.BIT12
    #define ATDDR10H_BIT13              _ATDDR10.Overlap_STR.ATDDR10HSTR.Bits.BIT13
    #define ATDDR10H_BIT14              _ATDDR10.Overlap_STR.ATDDR10HSTR.Bits.BIT14
    #define ATDDR10H_BIT15              _ATDDR10.Overlap_STR.ATDDR10HSTR.Bits.BIT15
    
    #define ATDDR10H_BIT8_MASK          1U
    #define ATDDR10H_BIT9_MASK          2U
    #define ATDDR10H_BIT10_MASK         4U
    #define ATDDR10H_BIT11_MASK         8U
    #define ATDDR10H_BIT12_MASK         16U
    #define ATDDR10H_BIT13_MASK         32U
    #define ATDDR10H_BIT14_MASK         64U
    #define ATDDR10H_BIT15_MASK         128U
    

    /*** ATDDR10L - ATD Conversion Result Register 10 Low; 0x000000A5 ***/
    union {
      byte Byte;
      struct {
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte BIT6        :1;                                       /* Bit 6 */
        byte BIT7        :1;                                       /* Bit 7 */
      } Bits;
      struct {
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte grpBIT_6 :2;
      } MergedBits;
    } ATDDR10LSTR;
    #define ATDDR10L                    _ATDDR10.Overlap_STR.ATDDR10LSTR.Byte
    #define ATDDR10L_BIT6               _ATDDR10.Overlap_STR.ATDDR10LSTR.Bits.BIT6
    #define ATDDR10L_BIT7               _ATDDR10.Overlap_STR.ATDDR10LSTR.Bits.BIT7
    #define ATDDR10L_BIT_6              _ATDDR10.Overlap_STR.ATDDR10LSTR.MergedBits.grpBIT_6
    #define ATDDR10L_BIT                ATDDR10L_BIT_6
    
    #define ATDDR10L_BIT6_MASK          64U
    #define ATDDR10L_BIT7_MASK          128U
    #define ATDDR10L_BIT_6_MASK         192U
    #define ATDDR10L_BIT_6_BITNUM       6U
    
  } Overlap_STR;

  struct {
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word BIT6        :1;                                       /* Bit 6 */
    word BIT7        :1;                                       /* Bit 7 */
    word BIT8        :1;                                       /* Bit 8 */
    word BIT9        :1;                                       /* Bit 9 */
    word BIT10       :1;                                       /* Bit 10 */
    word BIT11       :1;                                       /* Bit 11 */
    word BIT12       :1;                                       /* Bit 12 */
    word BIT13       :1;                                       /* Bit 13 */
    word BIT14       :1;                                       /* Bit 14 */
    word BIT15       :1;                                       /* Bit 15 */
  } Bits;
  struct {
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpBIT_6 :10;
  } MergedBits;
} ATDDR10STR;
extern volatile ATDDR10STR _ATDDR10 @(REG_BASE + 0x000000A4UL);
#define ATDDR10                         _ATDDR10.Word
#define ATDDR10_BIT6                    _ATDDR10.Bits.BIT6
#define ATDDR10_BIT7                    _ATDDR10.Bits.BIT7
#define ATDDR10_BIT8                    _ATDDR10.Bits.BIT8
#define ATDDR10_BIT9                    _ATDDR10.Bits.BIT9
#define ATDDR10_BIT10                   _ATDDR10.Bits.BIT10
#define ATDDR10_BIT11                   _ATDDR10.Bits.BIT11
#define ATDDR10_BIT12                   _ATDDR10.Bits.BIT12
#define ATDDR10_BIT13                   _ATDDR10.Bits.BIT13
#define ATDDR10_BIT14                   _ATDDR10.Bits.BIT14
#define ATDDR10_BIT15                   _ATDDR10.Bits.BIT15
#define ATDDR10_BIT_6                   _ATDDR10.MergedBits.grpBIT_6
#define ATDDR10_BIT                     ATDDR10_BIT_6

#define ATDDR10_BIT6_MASK               64U
#define ATDDR10_BIT7_MASK               128U
#define ATDDR10_BIT8_MASK               256U
#define ATDDR10_BIT9_MASK               512U
#define ATDDR10_BIT10_MASK              1024U
#define ATDDR10_BIT11_MASK              2048U
#define ATDDR10_BIT12_MASK              4096U
#define ATDDR10_BIT13_MASK              8192U
#define ATDDR10_BIT14_MASK              16384U
#define ATDDR10_BIT15_MASK              32768U
#define ATDDR10_BIT_6_MASK              65472U
#define ATDDR10_BIT_6_BITNUM            6U


/*** ATDDR11 - ATD Conversion Result Register 11; 0x000000A6 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATDDR11H - ATD Conversion Result Register 11 High; 0x000000A6 ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Bit 8 */
        byte BIT9        :1;                                       /* Bit 9 */
        byte BIT10       :1;                                       /* Bit 10 */
        byte BIT11       :1;                                       /* Bit 11 */
        byte BIT12       :1;                                       /* Bit 12 */
        byte BIT13       :1;                                       /* Bit 13 */
        byte BIT14       :1;                                       /* Bit 14 */
        byte BIT15       :1;                                       /* Bit 15 */
      } Bits;
    } ATDDR11HSTR;
    #define ATDDR11H                    _ATDDR11.Overlap_STR.ATDDR11HSTR.Byte
    #define ATDDR11H_BIT8               _ATDDR11.Overlap_STR.ATDDR11HSTR.Bits.BIT8
    #define ATDDR11H_BIT9               _ATDDR11.Overlap_STR.ATDDR11HSTR.Bits.BIT9
    #define ATDDR11H_BIT10              _ATDDR11.Overlap_STR.ATDDR11HSTR.Bits.BIT10
    #define ATDDR11H_BIT11              _ATDDR11.Overlap_STR.ATDDR11HSTR.Bits.BIT11
    #define ATDDR11H_BIT12              _ATDDR11.Overlap_STR.ATDDR11HSTR.Bits.BIT12
    #define ATDDR11H_BIT13              _ATDDR11.Overlap_STR.ATDDR11HSTR.Bits.BIT13
    #define ATDDR11H_BIT14              _ATDDR11.Overlap_STR.ATDDR11HSTR.Bits.BIT14
    #define ATDDR11H_BIT15              _ATDDR11.Overlap_STR.ATDDR11HSTR.Bits.BIT15
    
    #define ATDDR11H_BIT8_MASK          1U
    #define ATDDR11H_BIT9_MASK          2U
    #define ATDDR11H_BIT10_MASK         4U
    #define ATDDR11H_BIT11_MASK         8U
    #define ATDDR11H_BIT12_MASK         16U
    #define ATDDR11H_BIT13_MASK         32U
    #define ATDDR11H_BIT14_MASK         64U
    #define ATDDR11H_BIT15_MASK         128U
    

    /*** ATDDR11L - ATD Conversion Result Register 11 Low; 0x000000A7 ***/
    union {
      byte Byte;
      struct {
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte BIT6        :1;                                       /* Bit 6 */
        byte BIT7        :1;                                       /* Bit 7 */
      } Bits;
      struct {
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte grpBIT_6 :2;
      } MergedBits;
    } ATDDR11LSTR;
    #define ATDDR11L                    _ATDDR11.Overlap_STR.ATDDR11LSTR.Byte
    #define ATDDR11L_BIT6               _ATDDR11.Overlap_STR.ATDDR11LSTR.Bits.BIT6
    #define ATDDR11L_BIT7               _ATDDR11.Overlap_STR.ATDDR11LSTR.Bits.BIT7
    #define ATDDR11L_BIT_6              _ATDDR11.Overlap_STR.ATDDR11LSTR.MergedBits.grpBIT_6
    #define ATDDR11L_BIT                ATDDR11L_BIT_6
    
    #define ATDDR11L_BIT6_MASK          64U
    #define ATDDR11L_BIT7_MASK          128U
    #define ATDDR11L_BIT_6_MASK         192U
    #define ATDDR11L_BIT_6_BITNUM       6U
    
  } Overlap_STR;

  struct {
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word BIT6        :1;                                       /* Bit 6 */
    word BIT7        :1;                                       /* Bit 7 */
    word BIT8        :1;                                       /* Bit 8 */
    word BIT9        :1;                                       /* Bit 9 */
    word BIT10       :1;                                       /* Bit 10 */
    word BIT11       :1;                                       /* Bit 11 */
    word BIT12       :1;                                       /* Bit 12 */
    word BIT13       :1;                                       /* Bit 13 */
    word BIT14       :1;                                       /* Bit 14 */
    word BIT15       :1;                                       /* Bit 15 */
  } Bits;
  struct {
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpBIT_6 :10;
  } MergedBits;
} ATDDR11STR;
extern volatile ATDDR11STR _ATDDR11 @(REG_BASE + 0x000000A6UL);
#define ATDDR11                         _ATDDR11.Word
#define ATDDR11_BIT6                    _ATDDR11.Bits.BIT6
#define ATDDR11_BIT7                    _ATDDR11.Bits.BIT7
#define ATDDR11_BIT8                    _ATDDR11.Bits.BIT8
#define ATDDR11_BIT9                    _ATDDR11.Bits.BIT9
#define ATDDR11_BIT10                   _ATDDR11.Bits.BIT10
#define ATDDR11_BIT11                   _ATDDR11.Bits.BIT11
#define ATDDR11_BIT12                   _ATDDR11.Bits.BIT12
#define ATDDR11_BIT13                   _ATDDR11.Bits.BIT13
#define ATDDR11_BIT14                   _ATDDR11.Bits.BIT14
#define ATDDR11_BIT15                   _ATDDR11.Bits.BIT15
#define ATDDR11_BIT_6                   _ATDDR11.MergedBits.grpBIT_6
#define ATDDR11_BIT                     ATDDR11_BIT_6

#define ATDDR11_BIT6_MASK               64U
#define ATDDR11_BIT7_MASK               128U
#define ATDDR11_BIT8_MASK               256U
#define ATDDR11_BIT9_MASK               512U
#define ATDDR11_BIT10_MASK              1024U
#define ATDDR11_BIT11_MASK              2048U
#define ATDDR11_BIT12_MASK              4096U
#define ATDDR11_BIT13_MASK              8192U
#define ATDDR11_BIT14_MASK              16384U
#define ATDDR11_BIT15_MASK              32768U
#define ATDDR11_BIT_6_MASK              65472U
#define ATDDR11_BIT_6_BITNUM            6U


/*** ATDDR12 - ATD Conversion Result Register 12; 0x000000A8 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATDDR12H - ATD Conversion Result Register 12 High; 0x000000A8 ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Bit 8 */
        byte BIT9        :1;                                       /* Bit 9 */
        byte BIT10       :1;                                       /* Bit 10 */
        byte BIT11       :1;                                       /* Bit 11 */
        byte BIT12       :1;                                       /* Bit 12 */
        byte BIT13       :1;                                       /* Bit 13 */
        byte BIT14       :1;                                       /* Bit 14 */
        byte BIT15       :1;                                       /* Bit 15 */
      } Bits;
    } ATDDR12HSTR;
    #define ATDDR12H                    _ATDDR12.Overlap_STR.ATDDR12HSTR.Byte
    #define ATDDR12H_BIT8               _ATDDR12.Overlap_STR.ATDDR12HSTR.Bits.BIT8
    #define ATDDR12H_BIT9               _ATDDR12.Overlap_STR.ATDDR12HSTR.Bits.BIT9
    #define ATDDR12H_BIT10              _ATDDR12.Overlap_STR.ATDDR12HSTR.Bits.BIT10
    #define ATDDR12H_BIT11              _ATDDR12.Overlap_STR.ATDDR12HSTR.Bits.BIT11
    #define ATDDR12H_BIT12              _ATDDR12.Overlap_STR.ATDDR12HSTR.Bits.BIT12
    #define ATDDR12H_BIT13              _ATDDR12.Overlap_STR.ATDDR12HSTR.Bits.BIT13
    #define ATDDR12H_BIT14              _ATDDR12.Overlap_STR.ATDDR12HSTR.Bits.BIT14
    #define ATDDR12H_BIT15              _ATDDR12.Overlap_STR.ATDDR12HSTR.Bits.BIT15
    
    #define ATDDR12H_BIT8_MASK          1U
    #define ATDDR12H_BIT9_MASK          2U
    #define ATDDR12H_BIT10_MASK         4U
    #define ATDDR12H_BIT11_MASK         8U
    #define ATDDR12H_BIT12_MASK         16U
    #define ATDDR12H_BIT13_MASK         32U
    #define ATDDR12H_BIT14_MASK         64U
    #define ATDDR12H_BIT15_MASK         128U
    

    /*** ATDDR12L - ATD Conversion Result Register 12 Low; 0x000000A9 ***/
    union {
      byte Byte;
      struct {
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte BIT6        :1;                                       /* Bit 6 */
        byte BIT7        :1;                                       /* Bit 7 */
      } Bits;
      struct {
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte grpBIT_6 :2;
      } MergedBits;
    } ATDDR12LSTR;
    #define ATDDR12L                    _ATDDR12.Overlap_STR.ATDDR12LSTR.Byte
    #define ATDDR12L_BIT6               _ATDDR12.Overlap_STR.ATDDR12LSTR.Bits.BIT6
    #define ATDDR12L_BIT7               _ATDDR12.Overlap_STR.ATDDR12LSTR.Bits.BIT7
    #define ATDDR12L_BIT_6              _ATDDR12.Overlap_STR.ATDDR12LSTR.MergedBits.grpBIT_6
    #define ATDDR12L_BIT                ATDDR12L_BIT_6
    
    #define ATDDR12L_BIT6_MASK          64U
    #define ATDDR12L_BIT7_MASK          128U
    #define ATDDR12L_BIT_6_MASK         192U
    #define ATDDR12L_BIT_6_BITNUM       6U
    
  } Overlap_STR;

  struct {
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word BIT6        :1;                                       /* Bit 6 */
    word BIT7        :1;                                       /* Bit 7 */
    word BIT8        :1;                                       /* Bit 8 */
    word BIT9        :1;                                       /* Bit 9 */
    word BIT10       :1;                                       /* Bit 10 */
    word BIT11       :1;                                       /* Bit 11 */
    word BIT12       :1;                                       /* Bit 12 */
    word BIT13       :1;                                       /* Bit 13 */
    word BIT14       :1;                                       /* Bit 14 */
    word BIT15       :1;                                       /* Bit 15 */
  } Bits;
  struct {
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpBIT_6 :10;
  } MergedBits;
} ATDDR12STR;
extern volatile ATDDR12STR _ATDDR12 @(REG_BASE + 0x000000A8UL);
#define ATDDR12                         _ATDDR12.Word
#define ATDDR12_BIT6                    _ATDDR12.Bits.BIT6
#define ATDDR12_BIT7                    _ATDDR12.Bits.BIT7
#define ATDDR12_BIT8                    _ATDDR12.Bits.BIT8
#define ATDDR12_BIT9                    _ATDDR12.Bits.BIT9
#define ATDDR12_BIT10                   _ATDDR12.Bits.BIT10
#define ATDDR12_BIT11                   _ATDDR12.Bits.BIT11
#define ATDDR12_BIT12                   _ATDDR12.Bits.BIT12
#define ATDDR12_BIT13                   _ATDDR12.Bits.BIT13
#define ATDDR12_BIT14                   _ATDDR12.Bits.BIT14
#define ATDDR12_BIT15                   _ATDDR12.Bits.BIT15
#define ATDDR12_BIT_6                   _ATDDR12.MergedBits.grpBIT_6
#define ATDDR12_BIT                     ATDDR12_BIT_6

#define ATDDR12_BIT6_MASK               64U
#define ATDDR12_BIT7_MASK               128U
#define ATDDR12_BIT8_MASK               256U
#define ATDDR12_BIT9_MASK               512U
#define ATDDR12_BIT10_MASK              1024U
#define ATDDR12_BIT11_MASK              2048U
#define ATDDR12_BIT12_MASK              4096U
#define ATDDR12_BIT13_MASK              8192U
#define ATDDR12_BIT14_MASK              16384U
#define ATDDR12_BIT15_MASK              32768U
#define ATDDR12_BIT_6_MASK              65472U
#define ATDDR12_BIT_6_BITNUM            6U


/*** ATDDR13 - ATD Conversion Result Register 13; 0x000000AA ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATDDR13H - ATD Conversion Result Register 13 High; 0x000000AA ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Bit 8 */
        byte BIT9        :1;                                       /* Bit 9 */
        byte BIT10       :1;                                       /* Bit 10 */
        byte BIT11       :1;                                       /* Bit 11 */
        byte BIT12       :1;                                       /* Bit 12 */
        byte BIT13       :1;                                       /* Bit 13 */
        byte BIT14       :1;                                       /* Bit 14 */
        byte BIT15       :1;                                       /* Bit 15 */
      } Bits;
    } ATDDR13HSTR;
    #define ATDDR13H                    _ATDDR13.Overlap_STR.ATDDR13HSTR.Byte
    #define ATDDR13H_BIT8               _ATDDR13.Overlap_STR.ATDDR13HSTR.Bits.BIT8
    #define ATDDR13H_BIT9               _ATDDR13.Overlap_STR.ATDDR13HSTR.Bits.BIT9
    #define ATDDR13H_BIT10              _ATDDR13.Overlap_STR.ATDDR13HSTR.Bits.BIT10
    #define ATDDR13H_BIT11              _ATDDR13.Overlap_STR.ATDDR13HSTR.Bits.BIT11
    #define ATDDR13H_BIT12              _ATDDR13.Overlap_STR.ATDDR13HSTR.Bits.BIT12
    #define ATDDR13H_BIT13              _ATDDR13.Overlap_STR.ATDDR13HSTR.Bits.BIT13
    #define ATDDR13H_BIT14              _ATDDR13.Overlap_STR.ATDDR13HSTR.Bits.BIT14
    #define ATDDR13H_BIT15              _ATDDR13.Overlap_STR.ATDDR13HSTR.Bits.BIT15
    
    #define ATDDR13H_BIT8_MASK          1U
    #define ATDDR13H_BIT9_MASK          2U
    #define ATDDR13H_BIT10_MASK         4U
    #define ATDDR13H_BIT11_MASK         8U
    #define ATDDR13H_BIT12_MASK         16U
    #define ATDDR13H_BIT13_MASK         32U
    #define ATDDR13H_BIT14_MASK         64U
    #define ATDDR13H_BIT15_MASK         128U
    

    /*** ATDDR13L - ATD Conversion Result Register 13 Low; 0x000000AB ***/
    union {
      byte Byte;
      struct {
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte BIT6        :1;                                       /* Bit 6 */
        byte BIT7        :1;                                       /* Bit 7 */
      } Bits;
      struct {
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte grpBIT_6 :2;
      } MergedBits;
    } ATDDR13LSTR;
    #define ATDDR13L                    _ATDDR13.Overlap_STR.ATDDR13LSTR.Byte
    #define ATDDR13L_BIT6               _ATDDR13.Overlap_STR.ATDDR13LSTR.Bits.BIT6
    #define ATDDR13L_BIT7               _ATDDR13.Overlap_STR.ATDDR13LSTR.Bits.BIT7
    #define ATDDR13L_BIT_6              _ATDDR13.Overlap_STR.ATDDR13LSTR.MergedBits.grpBIT_6
    #define ATDDR13L_BIT                ATDDR13L_BIT_6
    
    #define ATDDR13L_BIT6_MASK          64U
    #define ATDDR13L_BIT7_MASK          128U
    #define ATDDR13L_BIT_6_MASK         192U
    #define ATDDR13L_BIT_6_BITNUM       6U
    
  } Overlap_STR;

  struct {
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word BIT6        :1;                                       /* Bit 6 */
    word BIT7        :1;                                       /* Bit 7 */
    word BIT8        :1;                                       /* Bit 8 */
    word BIT9        :1;                                       /* Bit 9 */
    word BIT10       :1;                                       /* Bit 10 */
    word BIT11       :1;                                       /* Bit 11 */
    word BIT12       :1;                                       /* Bit 12 */
    word BIT13       :1;                                       /* Bit 13 */
    word BIT14       :1;                                       /* Bit 14 */
    word BIT15       :1;                                       /* Bit 15 */
  } Bits;
  struct {
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpBIT_6 :10;
  } MergedBits;
} ATDDR13STR;
extern volatile ATDDR13STR _ATDDR13 @(REG_BASE + 0x000000AAUL);
#define ATDDR13                         _ATDDR13.Word
#define ATDDR13_BIT6                    _ATDDR13.Bits.BIT6
#define ATDDR13_BIT7                    _ATDDR13.Bits.BIT7
#define ATDDR13_BIT8                    _ATDDR13.Bits.BIT8
#define ATDDR13_BIT9                    _ATDDR13.Bits.BIT9
#define ATDDR13_BIT10                   _ATDDR13.Bits.BIT10
#define ATDDR13_BIT11                   _ATDDR13.Bits.BIT11
#define ATDDR13_BIT12                   _ATDDR13.Bits.BIT12
#define ATDDR13_BIT13                   _ATDDR13.Bits.BIT13
#define ATDDR13_BIT14                   _ATDDR13.Bits.BIT14
#define ATDDR13_BIT15                   _ATDDR13.Bits.BIT15
#define ATDDR13_BIT_6                   _ATDDR13.MergedBits.grpBIT_6
#define ATDDR13_BIT                     ATDDR13_BIT_6

#define ATDDR13_BIT6_MASK               64U
#define ATDDR13_BIT7_MASK               128U
#define ATDDR13_BIT8_MASK               256U
#define ATDDR13_BIT9_MASK               512U
#define ATDDR13_BIT10_MASK              1024U
#define ATDDR13_BIT11_MASK              2048U
#define ATDDR13_BIT12_MASK              4096U
#define ATDDR13_BIT13_MASK              8192U
#define ATDDR13_BIT14_MASK              16384U
#define ATDDR13_BIT15_MASK              32768U
#define ATDDR13_BIT_6_MASK              65472U
#define ATDDR13_BIT_6_BITNUM            6U


/*** ATDDR14 - ATD Conversion Result Register 14; 0x000000AC ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATDDR14H - ATD Conversion Result Register 14 High; 0x000000AC ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Bit 8 */
        byte BIT9        :1;                                       /* Bit 9 */
        byte BIT10       :1;                                       /* Bit 10 */
        byte BIT11       :1;                                       /* Bit 11 */
        byte BIT12       :1;                                       /* Bit 12 */
        byte BIT13       :1;                                       /* Bit 13 */
        byte BIT14       :1;                                       /* Bit 14 */
        byte BIT15       :1;                                       /* Bit 15 */
      } Bits;
    } ATDDR14HSTR;
    #define ATDDR14H                    _ATDDR14.Overlap_STR.ATDDR14HSTR.Byte
    #define ATDDR14H_BIT8               _ATDDR14.Overlap_STR.ATDDR14HSTR.Bits.BIT8
    #define ATDDR14H_BIT9               _ATDDR14.Overlap_STR.ATDDR14HSTR.Bits.BIT9
    #define ATDDR14H_BIT10              _ATDDR14.Overlap_STR.ATDDR14HSTR.Bits.BIT10
    #define ATDDR14H_BIT11              _ATDDR14.Overlap_STR.ATDDR14HSTR.Bits.BIT11
    #define ATDDR14H_BIT12              _ATDDR14.Overlap_STR.ATDDR14HSTR.Bits.BIT12
    #define ATDDR14H_BIT13              _ATDDR14.Overlap_STR.ATDDR14HSTR.Bits.BIT13
    #define ATDDR14H_BIT14              _ATDDR14.Overlap_STR.ATDDR14HSTR.Bits.BIT14
    #define ATDDR14H_BIT15              _ATDDR14.Overlap_STR.ATDDR14HSTR.Bits.BIT15
    
    #define ATDDR14H_BIT8_MASK          1U
    #define ATDDR14H_BIT9_MASK          2U
    #define ATDDR14H_BIT10_MASK         4U
    #define ATDDR14H_BIT11_MASK         8U
    #define ATDDR14H_BIT12_MASK         16U
    #define ATDDR14H_BIT13_MASK         32U
    #define ATDDR14H_BIT14_MASK         64U
    #define ATDDR14H_BIT15_MASK         128U
    

    /*** ATDDR14L - ATD Conversion Result Register 14 Low; 0x000000AD ***/
    union {
      byte Byte;
      struct {
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte BIT6        :1;                                       /* Bit 6 */
        byte BIT7        :1;                                       /* Bit 7 */
      } Bits;
      struct {
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte grpBIT_6 :2;
      } MergedBits;
    } ATDDR14LSTR;
    #define ATDDR14L                    _ATDDR14.Overlap_STR.ATDDR14LSTR.Byte
    #define ATDDR14L_BIT6               _ATDDR14.Overlap_STR.ATDDR14LSTR.Bits.BIT6
    #define ATDDR14L_BIT7               _ATDDR14.Overlap_STR.ATDDR14LSTR.Bits.BIT7
    #define ATDDR14L_BIT_6              _ATDDR14.Overlap_STR.ATDDR14LSTR.MergedBits.grpBIT_6
    #define ATDDR14L_BIT                ATDDR14L_BIT_6
    
    #define ATDDR14L_BIT6_MASK          64U
    #define ATDDR14L_BIT7_MASK          128U
    #define ATDDR14L_BIT_6_MASK         192U
    #define ATDDR14L_BIT_6_BITNUM       6U
    
  } Overlap_STR;

  struct {
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word BIT6        :1;                                       /* Bit 6 */
    word BIT7        :1;                                       /* Bit 7 */
    word BIT8        :1;                                       /* Bit 8 */
    word BIT9        :1;                                       /* Bit 9 */
    word BIT10       :1;                                       /* Bit 10 */
    word BIT11       :1;                                       /* Bit 11 */
    word BIT12       :1;                                       /* Bit 12 */
    word BIT13       :1;                                       /* Bit 13 */
    word BIT14       :1;                                       /* Bit 14 */
    word BIT15       :1;                                       /* Bit 15 */
  } Bits;
  struct {
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpBIT_6 :10;
  } MergedBits;
} ATDDR14STR;
extern volatile ATDDR14STR _ATDDR14 @(REG_BASE + 0x000000ACUL);
#define ATDDR14                         _ATDDR14.Word
#define ATDDR14_BIT6                    _ATDDR14.Bits.BIT6
#define ATDDR14_BIT7                    _ATDDR14.Bits.BIT7
#define ATDDR14_BIT8                    _ATDDR14.Bits.BIT8
#define ATDDR14_BIT9                    _ATDDR14.Bits.BIT9
#define ATDDR14_BIT10                   _ATDDR14.Bits.BIT10
#define ATDDR14_BIT11                   _ATDDR14.Bits.BIT11
#define ATDDR14_BIT12                   _ATDDR14.Bits.BIT12
#define ATDDR14_BIT13                   _ATDDR14.Bits.BIT13
#define ATDDR14_BIT14                   _ATDDR14.Bits.BIT14
#define ATDDR14_BIT15                   _ATDDR14.Bits.BIT15
#define ATDDR14_BIT_6                   _ATDDR14.MergedBits.grpBIT_6
#define ATDDR14_BIT                     ATDDR14_BIT_6

#define ATDDR14_BIT6_MASK               64U
#define ATDDR14_BIT7_MASK               128U
#define ATDDR14_BIT8_MASK               256U
#define ATDDR14_BIT9_MASK               512U
#define ATDDR14_BIT10_MASK              1024U
#define ATDDR14_BIT11_MASK              2048U
#define ATDDR14_BIT12_MASK              4096U
#define ATDDR14_BIT13_MASK              8192U
#define ATDDR14_BIT14_MASK              16384U
#define ATDDR14_BIT15_MASK              32768U
#define ATDDR14_BIT_6_MASK              65472U
#define ATDDR14_BIT_6_BITNUM            6U


/*** ATDDR15 - ATD Conversion Result Register 15; 0x000000AE ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATDDR15H - ATD Conversion Result Register 15 High; 0x000000AE ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Bit 8 */
        byte BIT9        :1;                                       /* Bit 9 */
        byte BIT10       :1;                                       /* Bit 10 */
        byte BIT11       :1;                                       /* Bit 11 */
        byte BIT12       :1;                                       /* Bit 12 */
        byte BIT13       :1;                                       /* Bit 13 */
        byte BIT14       :1;                                       /* Bit 14 */
        byte BIT15       :1;                                       /* Bit 15 */
      } Bits;
    } ATDDR15HSTR;
    #define ATDDR15H                    _ATDDR15.Overlap_STR.ATDDR15HSTR.Byte
    #define ATDDR15H_BIT8               _ATDDR15.Overlap_STR.ATDDR15HSTR.Bits.BIT8
    #define ATDDR15H_BIT9               _ATDDR15.Overlap_STR.ATDDR15HSTR.Bits.BIT9
    #define ATDDR15H_BIT10              _ATDDR15.Overlap_STR.ATDDR15HSTR.Bits.BIT10
    #define ATDDR15H_BIT11              _ATDDR15.Overlap_STR.ATDDR15HSTR.Bits.BIT11
    #define ATDDR15H_BIT12              _ATDDR15.Overlap_STR.ATDDR15HSTR.Bits.BIT12
    #define ATDDR15H_BIT13              _ATDDR15.Overlap_STR.ATDDR15HSTR.Bits.BIT13
    #define ATDDR15H_BIT14              _ATDDR15.Overlap_STR.ATDDR15HSTR.Bits.BIT14
    #define ATDDR15H_BIT15              _ATDDR15.Overlap_STR.ATDDR15HSTR.Bits.BIT15
    
    #define ATDDR15H_BIT8_MASK          1U
    #define ATDDR15H_BIT9_MASK          2U
    #define ATDDR15H_BIT10_MASK         4U
    #define ATDDR15H_BIT11_MASK         8U
    #define ATDDR15H_BIT12_MASK         16U
    #define ATDDR15H_BIT13_MASK         32U
    #define ATDDR15H_BIT14_MASK         64U
    #define ATDDR15H_BIT15_MASK         128U
    

    /*** ATDDR15L - ATD Conversion Result Register 15 Low; 0x000000AF ***/
    union {
      byte Byte;
      struct {
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte BIT6        :1;                                       /* Bit 6 */
        byte BIT7        :1;                                       /* Bit 7 */
      } Bits;
      struct {
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte grpBIT_6 :2;
      } MergedBits;
    } ATDDR15LSTR;
    #define ATDDR15L                    _ATDDR15.Overlap_STR.ATDDR15LSTR.Byte
    #define ATDDR15L_BIT6               _ATDDR15.Overlap_STR.ATDDR15LSTR.Bits.BIT6
    #define ATDDR15L_BIT7               _ATDDR15.Overlap_STR.ATDDR15LSTR.Bits.BIT7
    #define ATDDR15L_BIT_6              _ATDDR15.Overlap_STR.ATDDR15LSTR.MergedBits.grpBIT_6
    #define ATDDR15L_BIT                ATDDR15L_BIT_6
    
    #define ATDDR15L_BIT6_MASK          64U
    #define ATDDR15L_BIT7_MASK          128U
    #define ATDDR15L_BIT_6_MASK         192U
    #define ATDDR15L_BIT_6_BITNUM       6U
    
  } Overlap_STR;

  struct {
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word BIT6        :1;                                       /* Bit 6 */
    word BIT7        :1;                                       /* Bit 7 */
    word BIT8        :1;                                       /* Bit 8 */
    word BIT9        :1;                                       /* Bit 9 */
    word BIT10       :1;                                       /* Bit 10 */
    word BIT11       :1;                                       /* Bit 11 */
    word BIT12       :1;                                       /* Bit 12 */
    word BIT13       :1;                                       /* Bit 13 */
    word BIT14       :1;                                       /* Bit 14 */
    word BIT15       :1;                                       /* Bit 15 */
  } Bits;
  struct {
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpBIT_6 :10;
  } MergedBits;
} ATDDR15STR;
extern volatile ATDDR15STR _ATDDR15 @(REG_BASE + 0x000000AEUL);
#define ATDDR15                         _ATDDR15.Word
#define ATDDR15_BIT6                    _ATDDR15.Bits.BIT6
#define ATDDR15_BIT7                    _ATDDR15.Bits.BIT7
#define ATDDR15_BIT8                    _ATDDR15.Bits.BIT8
#define ATDDR15_BIT9                    _ATDDR15.Bits.BIT9
#define ATDDR15_BIT10                   _ATDDR15.Bits.BIT10
#define ATDDR15_BIT11                   _ATDDR15.Bits.BIT11
#define ATDDR15_BIT12                   _ATDDR15.Bits.BIT12
#define ATDDR15_BIT13                   _ATDDR15.Bits.BIT13
#define ATDDR15_BIT14                   _ATDDR15.Bits.BIT14
#define ATDDR15_BIT15                   _ATDDR15.Bits.BIT15
#define ATDDR15_BIT_6                   _ATDDR15.MergedBits.grpBIT_6
#define ATDDR15_BIT                     ATDDR15_BIT_6

#define ATDDR15_BIT6_MASK               64U
#define ATDDR15_BIT7_MASK               128U
#define ATDDR15_BIT8_MASK               256U
#define ATDDR15_BIT9_MASK               512U
#define ATDDR15_BIT10_MASK              1024U
#define ATDDR15_BIT11_MASK              2048U
#define ATDDR15_BIT12_MASK              4096U
#define ATDDR15_BIT13_MASK              8192U
#define ATDDR15_BIT14_MASK              16384U
#define ATDDR15_BIT15_MASK              32768U
#define ATDDR15_BIT_6_MASK              65472U
#define ATDDR15_BIT_6_BITNUM            6U


/*** SCI0BD - SCI 0 Baud Rate Register; 0x000000C8 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** SCI0BDH - SCI 0 Baud Rate Register High; 0x000000C8 ***/
    union {
      byte Byte;
      struct {
        byte SBR8        :1;                                       /* SCI Baud Rate Bit 8 */
        byte SBR9        :1;                                       /* SCI Baud Rate Bit 9 */
        byte SBR10       :1;                                       /* SCI Baud Rate Bit 10 */
        byte SBR11       :1;                                       /* SCI Baud Rate Bit 11 */
        byte SBR12       :1;                                       /* SCI Baud Rate Bit 12 */
        byte TNP0        :1;                                       /* Transmitter Narrow Pulse Bit 0 */
        byte TNP1        :1;                                       /* Transmitter Narrow Pulse Bit 1 */
        byte IREN        :1;                                       /* Infrared Enable Bit */
      } Bits;
      struct {
        byte grpSBR_8 :5;
        byte grpTNP :2;
        byte     :1;
      } MergedBits;
    } SCI0BDHSTR;
    #define SCI0BDH                     _SCI0BD.Overlap_STR.SCI0BDHSTR.Byte
    #define SCI0BDH_SBR8                _SCI0BD.Overlap_STR.SCI0BDHSTR.Bits.SBR8
    #define SCI0BDH_SBR9                _SCI0BD.Overlap_STR.SCI0BDHSTR.Bits.SBR9
    #define SCI0BDH_SBR10               _SCI0BD.Overlap_STR.SCI0BDHSTR.Bits.SBR10
    #define SCI0BDH_SBR11               _SCI0BD.Overlap_STR.SCI0BDHSTR.Bits.SBR11
    #define SCI0BDH_SBR12               _SCI0BD.Overlap_STR.SCI0BDHSTR.Bits.SBR12
    #define SCI0BDH_TNP0                _SCI0BD.Overlap_STR.SCI0BDHSTR.Bits.TNP0
    #define SCI0BDH_TNP1                _SCI0BD.Overlap_STR.SCI0BDHSTR.Bits.TNP1
    #define SCI0BDH_IREN                _SCI0BD.Overlap_STR.SCI0BDHSTR.Bits.IREN
    #define SCI0BDH_SBR_8               _SCI0BD.Overlap_STR.SCI0BDHSTR.MergedBits.grpSBR_8
    #define SCI0BDH_TNP                 _SCI0BD.Overlap_STR.SCI0BDHSTR.MergedBits.grpTNP
    #define SCI0BDH_SBR                 SCI0BDH_SBR_8
    
    #define SCI0BDH_SBR8_MASK           1U
    #define SCI0BDH_SBR9_MASK           2U
    #define SCI0BDH_SBR10_MASK          4U
    #define SCI0BDH_SBR11_MASK          8U
    #define SCI0BDH_SBR12_MASK          16U
    #define SCI0BDH_TNP0_MASK           32U
    #define SCI0BDH_TNP1_MASK           64U
    #define SCI0BDH_IREN_MASK           128U
    #define SCI0BDH_SBR_8_MASK          31U
    #define SCI0BDH_SBR_8_BITNUM        0U
    #define SCI0BDH_TNP_MASK            96U
    #define SCI0BDH_TNP_BITNUM          5U
    

    /*** SCI0BDL - SCI 0 Baud Rate Register Low; 0x000000C9 ***/
    union {
      byte Byte;
      struct {
        byte SBR0        :1;                                       /* SCI Baud Rate Bit 0 */
        byte SBR1        :1;                                       /* SCI Baud Rate Bit 1 */
        byte SBR2        :1;                                       /* SCI Baud Rate Bit 2 */
        byte SBR3        :1;                                       /* SCI Baud Rate Bit 3 */
        byte SBR4        :1;                                       /* SCI Baud Rate Bit 4 */
        byte SBR5        :1;                                       /* SCI Baud Rate Bit 5 */
        byte SBR6        :1;                                       /* SCI Baud Rate Bit 6 */
        byte SBR7        :1;                                       /* SCI Baud Rate Bit 7 */
      } Bits;
    } SCI0BDLSTR;
    #define SCI0BDL                     _SCI0BD.Overlap_STR.SCI0BDLSTR.Byte
    #define SCI0BDL_SBR0                _SCI0BD.Overlap_STR.SCI0BDLSTR.Bits.SBR0
    #define SCI0BDL_SBR1                _SCI0BD.Overlap_STR.SCI0BDLSTR.Bits.SBR1
    #define SCI0BDL_SBR2                _SCI0BD.Overlap_STR.SCI0BDLSTR.Bits.SBR2
    #define SCI0BDL_SBR3                _SCI0BD.Overlap_STR.SCI0BDLSTR.Bits.SBR3
    #define SCI0BDL_SBR4                _SCI0BD.Overlap_STR.SCI0BDLSTR.Bits.SBR4
    #define SCI0BDL_SBR5                _SCI0BD.Overlap_STR.SCI0BDLSTR.Bits.SBR5
    #define SCI0BDL_SBR6                _SCI0BD.Overlap_STR.SCI0BDLSTR.Bits.SBR6
    #define SCI0BDL_SBR7                _SCI0BD.Overlap_STR.SCI0BDLSTR.Bits.SBR7
    
    #define SCI0BDL_SBR0_MASK           1U
    #define SCI0BDL_SBR1_MASK           2U
    #define SCI0BDL_SBR2_MASK           4U
    #define SCI0BDL_SBR3_MASK           8U
    #define SCI0BDL_SBR4_MASK           16U
    #define SCI0BDL_SBR5_MASK           32U
    #define SCI0BDL_SBR6_MASK           64U
    #define SCI0BDL_SBR7_MASK           128U
    
  } Overlap_STR;

  struct {
    word SBR0        :1;                                       /* SCI Baud Rate Bit 0 */
    word SBR1        :1;                                       /* SCI Baud Rate Bit 1 */
    word SBR2        :1;                                       /* SCI Baud Rate Bit 2 */
    word SBR3        :1;                                       /* SCI Baud Rate Bit 3 */
    word SBR4        :1;                                       /* SCI Baud Rate Bit 4 */
    word SBR5        :1;                                       /* SCI Baud Rate Bit 5 */
    word SBR6        :1;                                       /* SCI Baud Rate Bit 6 */
    word SBR7        :1;                                       /* SCI Baud Rate Bit 7 */
    word SBR8        :1;                                       /* SCI Baud Rate Bit 8 */
    word SBR9        :1;                                       /* SCI Baud Rate Bit 9 */
    word SBR10       :1;                                       /* SCI Baud Rate Bit 10 */
    word SBR11       :1;                                       /* SCI Baud Rate Bit 11 */
    word SBR12       :1;                                       /* SCI Baud Rate Bit 12 */
    word TNP0        :1;                                       /* Transmitter Narrow Pulse Bit 0 */
    word TNP1        :1;                                       /* Transmitter Narrow Pulse Bit 1 */
    word IREN        :1;                                       /* Infrared Enable Bit */
  } Bits;
  struct {
    word grpSBR  :13;
    word grpTNP  :2;
    word         :1;
  } MergedBits;
} SCI0BDSTR;
extern volatile SCI0BDSTR _SCI0BD @(REG_BASE + 0x000000C8UL);
#define SCI0BD                          _SCI0BD.Word
#define SCI0BD_SBR0                     _SCI0BD.Bits.SBR0
#define SCI0BD_SBR1                     _SCI0BD.Bits.SBR1
#define SCI0BD_SBR2                     _SCI0BD.Bits.SBR2
#define SCI0BD_SBR3                     _SCI0BD.Bits.SBR3
#define SCI0BD_SBR4                     _SCI0BD.Bits.SBR4
#define SCI0BD_SBR5                     _SCI0BD.Bits.SBR5
#define SCI0BD_SBR6                     _SCI0BD.Bits.SBR6
#define SCI0BD_SBR7                     _SCI0BD.Bits.SBR7
#define SCI0BD_SBR8                     _SCI0BD.Bits.SBR8
#define SCI0BD_SBR9                     _SCI0BD.Bits.SBR9
#define SCI0BD_SBR10                    _SCI0BD.Bits.SBR10
#define SCI0BD_SBR11                    _SCI0BD.Bits.SBR11
#define SCI0BD_SBR12                    _SCI0BD.Bits.SBR12
#define SCI0BD_TNP0                     _SCI0BD.Bits.TNP0
#define SCI0BD_TNP1                     _SCI0BD.Bits.TNP1
#define SCI0BD_IREN                     _SCI0BD.Bits.IREN
#define SCI0BD_SBR                      _SCI0BD.MergedBits.grpSBR
#define SCI0BD_TNP                      _SCI0BD.MergedBits.grpTNP

#define SCI0BD_SBR0_MASK                1U
#define SCI0BD_SBR1_MASK                2U
#define SCI0BD_SBR2_MASK                4U
#define SCI0BD_SBR3_MASK                8U
#define SCI0BD_SBR4_MASK                16U
#define SCI0BD_SBR5_MASK                32U
#define SCI0BD_SBR6_MASK                64U
#define SCI0BD_SBR7_MASK                128U
#define SCI0BD_SBR8_MASK                256U
#define SCI0BD_SBR9_MASK                512U
#define SCI0BD_SBR10_MASK               1024U
#define SCI0BD_SBR11_MASK               2048U
#define SCI0BD_SBR12_MASK               4096U
#define SCI0BD_TNP0_MASK                8192U
#define SCI0BD_TNP1_MASK                16384U
#define SCI0BD_IREN_MASK                32768U
#define SCI0BD_SBR_MASK                 8191U
#define SCI0BD_SBR_BITNUM               0U
#define SCI0BD_TNP_MASK                 24576U
#define SCI0BD_TNP_BITNUM               13U


/*** SCI0CR1 - SCI 0 Control Register 1; 0x000000CA ***/
typedef union {
  byte Byte;
  struct {
    byte PT          :1;                                       /* Parity Type Bit */
    byte PE          :1;                                       /* Parity Enable Bit */
    byte ILT         :1;                                       /* Idle Line Type Bit */
    byte WAKE        :1;                                       /* Wakeup Condition Bit */
    byte M           :1;                                       /* Data Format Mode Bit */
    byte RSRC        :1;                                       /* Receiver Source Bit */
    byte SCISWAI     :1;                                       /* SCI Stop in Wait Mode Bit */
    byte LOOPS       :1;                                       /* Loop Select Bit */
  } Bits;
} SCI0CR1STR;
extern volatile SCI0CR1STR _SCI0CR1 @(REG_BASE + 0x000000CAUL);
#define SCI0CR1                         _SCI0CR1.Byte
#define SCI0CR1_PT                      _SCI0CR1.Bits.PT
#define SCI0CR1_PE                      _SCI0CR1.Bits.PE
#define SCI0CR1_ILT                     _SCI0CR1.Bits.ILT
#define SCI0CR1_WAKE                    _SCI0CR1.Bits.WAKE
#define SCI0CR1_M                       _SCI0CR1.Bits.M
#define SCI0CR1_RSRC                    _SCI0CR1.Bits.RSRC
#define SCI0CR1_SCISWAI                 _SCI0CR1.Bits.SCISWAI
#define SCI0CR1_LOOPS                   _SCI0CR1.Bits.LOOPS

#define SCI0CR1_PT_MASK                 1U
#define SCI0CR1_PE_MASK                 2U
#define SCI0CR1_ILT_MASK                4U
#define SCI0CR1_WAKE_MASK               8U
#define SCI0CR1_M_MASK                  16U
#define SCI0CR1_RSRC_MASK               32U
#define SCI0CR1_SCISWAI_MASK            64U
#define SCI0CR1_LOOPS_MASK              128U


/*** SCI0CR2 - SCI 0 Control Register 2; 0x000000CB ***/
typedef union {
  byte Byte;
  struct {
    byte SBK         :1;                                       /* Send Break Bit */
    byte RWU         :1;                                       /* Receiver Wakeup Bit */
    byte RE          :1;                                       /* Receiver Enable Bit */
    byte TE          :1;                                       /* Transmitter Enable Bit */
    byte ILIE        :1;                                       /* Idle Line Interrupt Enable Bit */
    byte RIE         :1;                                       /* Receiver Full Interrupt Enable Bit */
    byte TCIE        :1;                                       /* Transmission Complete Interrupt Enable Bit */
    byte SCTIE       :1;                                       /* Transmitter Interrupt Enable Bit */
  } Bits;
} SCI0CR2STR;
extern volatile SCI0CR2STR _SCI0CR2 @(REG_BASE + 0x000000CBUL);
#define SCI0CR2                         _SCI0CR2.Byte
#define SCI0CR2_SBK                     _SCI0CR2.Bits.SBK
#define SCI0CR2_RWU                     _SCI0CR2.Bits.RWU
#define SCI0CR2_RE                      _SCI0CR2.Bits.RE
#define SCI0CR2_TE                      _SCI0CR2.Bits.TE
#define SCI0CR2_ILIE                    _SCI0CR2.Bits.ILIE
#define SCI0CR2_RIE                     _SCI0CR2.Bits.RIE
#define SCI0CR2_TCIE                    _SCI0CR2.Bits.TCIE
#define SCI0CR2_SCTIE                   _SCI0CR2.Bits.SCTIE

#define SCI0CR2_SBK_MASK                1U
#define SCI0CR2_RWU_MASK                2U
#define SCI0CR2_RE_MASK                 4U
#define SCI0CR2_TE_MASK                 8U
#define SCI0CR2_ILIE_MASK               16U
#define SCI0CR2_RIE_MASK                32U
#define SCI0CR2_TCIE_MASK               64U
#define SCI0CR2_SCTIE_MASK              128U


/*** SCI0SR1 - SCI 0 Status Register 1; 0x000000CC ***/
typedef union {
  byte Byte;
  struct {
    byte PF          :1;                                       /* Parity Error Flag */
    byte FE          :1;                                       /* Framing Error Flag */
    byte NF          :1;                                       /* Noise Flag */
    byte OR          :1;                                       /* Overrun Flag */
    byte IDLE        :1;                                       /* Idle Line Flag */
    byte RDRF        :1;                                       /* Receive Data Register Full Flag */
    byte TC          :1;                                       /* Transmit Complete Flag */
    byte TDRE        :1;                                       /* Transmit Data Register Empty Flag */
  } Bits;
} SCI0SR1STR;
extern volatile SCI0SR1STR _SCI0SR1 @(REG_BASE + 0x000000CCUL);
#define SCI0SR1                         _SCI0SR1.Byte
#define SCI0SR1_PF                      _SCI0SR1.Bits.PF
#define SCI0SR1_FE                      _SCI0SR1.Bits.FE
#define SCI0SR1_NF                      _SCI0SR1.Bits.NF
#define SCI0SR1_OR                      _SCI0SR1.Bits.OR
#define SCI0SR1_IDLE                    _SCI0SR1.Bits.IDLE
#define SCI0SR1_RDRF                    _SCI0SR1.Bits.RDRF
#define SCI0SR1_TC                      _SCI0SR1.Bits.TC
#define SCI0SR1_TDRE                    _SCI0SR1.Bits.TDRE

#define SCI0SR1_PF_MASK                 1U
#define SCI0SR1_FE_MASK                 2U
#define SCI0SR1_NF_MASK                 4U
#define SCI0SR1_OR_MASK                 8U
#define SCI0SR1_IDLE_MASK               16U
#define SCI0SR1_RDRF_MASK               32U
#define SCI0SR1_TC_MASK                 64U
#define SCI0SR1_TDRE_MASK               128U


/*** SCI0SR2 - SCI 0 Status Register 2; 0x000000CD ***/
typedef union {
  byte Byte;
  struct {
    byte RAF         :1;                                       /* Receiver Active Flag */
    byte TXDIR       :1;                                       /* Transmitter pin data direction in Single-Wire mode */
    byte BRK13       :1;                                       /* Break Transmit character length */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} SCI0SR2STR;
extern volatile SCI0SR2STR _SCI0SR2 @(REG_BASE + 0x000000CDUL);
#define SCI0SR2                         _SCI0SR2.Byte
#define SCI0SR2_RAF                     _SCI0SR2.Bits.RAF
#define SCI0SR2_TXDIR                   _SCI0SR2.Bits.TXDIR
#define SCI0SR2_BRK13                   _SCI0SR2.Bits.BRK13

#define SCI0SR2_RAF_MASK                1U
#define SCI0SR2_TXDIR_MASK              2U
#define SCI0SR2_BRK13_MASK              4U


/*** SCI0DRH - SCI 0 Data Register High; 0x000000CE ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte T8          :1;                                       /* Transmit Bit 8 */
    byte R8          :1;                                       /* Received Bit 8 */
  } Bits;
} SCI0DRHSTR;
extern volatile SCI0DRHSTR _SCI0DRH @(REG_BASE + 0x000000CEUL);
#define SCI0DRH                         _SCI0DRH.Byte
#define SCI0DRH_T8                      _SCI0DRH.Bits.T8
#define SCI0DRH_R8                      _SCI0DRH.Bits.R8

#define SCI0DRH_T8_MASK                 64U
#define SCI0DRH_R8_MASK                 128U


/*** SCI0DRL - SCI 0 Data Register Low; 0x000000CF ***/
typedef union {
  byte Byte;
  struct {
    byte R0_T0       :1;                                       /* Received bit 0 or Transmit bit 0 */
    byte R1_T1       :1;                                       /* Received bit 1 or Transmit bit 1 */
    byte R2_T2       :1;                                       /* Received bit 2 or Transmit bit 2 */
    byte R3_T3       :1;                                       /* Received bit 3 or Transmit bit 3 */
    byte R4_T4       :1;                                       /* Received bit 4 or Transmit bit 4 */
    byte R5_T5       :1;                                       /* Received bit 5 or Transmit bit 5 */
    byte R6_T6       :1;                                       /* Received bit 6 or Transmit bit 6 */
    byte R7_T7       :1;                                       /* Received bit 7 or Transmit bit 7 */
  } Bits;
} SCI0DRLSTR;
extern volatile SCI0DRLSTR _SCI0DRL @(REG_BASE + 0x000000CFUL);
#define SCI0DRL                         _SCI0DRL.Byte
#define SCI0DRL_R0_T0                   _SCI0DRL.Bits.R0_T0
#define SCI0DRL_R1_T1                   _SCI0DRL.Bits.R1_T1
#define SCI0DRL_R2_T2                   _SCI0DRL.Bits.R2_T2
#define SCI0DRL_R3_T3                   _SCI0DRL.Bits.R3_T3
#define SCI0DRL_R4_T4                   _SCI0DRL.Bits.R4_T4
#define SCI0DRL_R5_T5                   _SCI0DRL.Bits.R5_T5
#define SCI0DRL_R6_T6                   _SCI0DRL.Bits.R6_T6
#define SCI0DRL_R7_T7                   _SCI0DRL.Bits.R7_T7

#define SCI0DRL_R0_T0_MASK              1U
#define SCI0DRL_R1_T1_MASK              2U
#define SCI0DRL_R2_T2_MASK              4U
#define SCI0DRL_R3_T3_MASK              8U
#define SCI0DRL_R4_T4_MASK              16U
#define SCI0DRL_R5_T5_MASK              32U
#define SCI0DRL_R6_T6_MASK              64U
#define SCI0DRL_R7_T7_MASK              128U


/*** SCI1BD - SCI 1 Baud Rate Register; 0x000000D0 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** SCI1BDH - SCI 1 Baud Rate Register High; 0x000000D0 ***/
    union {
      byte Byte;
      struct {
        byte SBR8        :1;                                       /* SCI Baud Rate Bit 8 */
        byte SBR9        :1;                                       /* SCI Baud Rate Bit 9 */
        byte SBR10       :1;                                       /* SCI Baud Rate Bit 10 */
        byte SBR11       :1;                                       /* SCI Baud Rate Bit 11 */
        byte SBR12       :1;                                       /* SCI Baud Rate Bit 12 */
        byte TNP0        :1;                                       /* Transmitter Narrow Pulse Bit 0 */
        byte TNP1        :1;                                       /* Transmitter Narrow Pulse Bit 1 */
        byte IREN        :1;                                       /* Infrared Enable Bit */
      } Bits;
      struct {
        byte grpSBR_8 :5;
        byte grpTNP :2;
        byte     :1;
      } MergedBits;
    } SCI1BDHSTR;
    #define SCI1BDH                     _SCI1BD.Overlap_STR.SCI1BDHSTR.Byte
    #define SCI1BDH_SBR8                _SCI1BD.Overlap_STR.SCI1BDHSTR.Bits.SBR8
    #define SCI1BDH_SBR9                _SCI1BD.Overlap_STR.SCI1BDHSTR.Bits.SBR9
    #define SCI1BDH_SBR10               _SCI1BD.Overlap_STR.SCI1BDHSTR.Bits.SBR10
    #define SCI1BDH_SBR11               _SCI1BD.Overlap_STR.SCI1BDHSTR.Bits.SBR11
    #define SCI1BDH_SBR12               _SCI1BD.Overlap_STR.SCI1BDHSTR.Bits.SBR12
    #define SCI1BDH_TNP0                _SCI1BD.Overlap_STR.SCI1BDHSTR.Bits.TNP0
    #define SCI1BDH_TNP1                _SCI1BD.Overlap_STR.SCI1BDHSTR.Bits.TNP1
    #define SCI1BDH_IREN                _SCI1BD.Overlap_STR.SCI1BDHSTR.Bits.IREN
    #define SCI1BDH_SBR_8               _SCI1BD.Overlap_STR.SCI1BDHSTR.MergedBits.grpSBR_8
    #define SCI1BDH_TNP                 _SCI1BD.Overlap_STR.SCI1BDHSTR.MergedBits.grpTNP
    #define SCI1BDH_SBR                 SCI1BDH_SBR_8
    
    #define SCI1BDH_SBR8_MASK           1U
    #define SCI1BDH_SBR9_MASK           2U
    #define SCI1BDH_SBR10_MASK          4U
    #define SCI1BDH_SBR11_MASK          8U
    #define SCI1BDH_SBR12_MASK          16U
    #define SCI1BDH_TNP0_MASK           32U
    #define SCI1BDH_TNP1_MASK           64U
    #define SCI1BDH_IREN_MASK           128U
    #define SCI1BDH_SBR_8_MASK          31U
    #define SCI1BDH_SBR_8_BITNUM        0U
    #define SCI1BDH_TNP_MASK            96U
    #define SCI1BDH_TNP_BITNUM          5U
    

    /*** SCI1BDL - SCI 1 Baud Rate Register Low; 0x000000D1 ***/
    union {
      byte Byte;
      struct {
        byte SBR0        :1;                                       /* SCI Baud Rate Bit 0 */
        byte SBR1        :1;                                       /* SCI Baud Rate Bit 1 */
        byte SBR2        :1;                                       /* SCI Baud Rate Bit 2 */
        byte SBR3        :1;                                       /* SCI Baud Rate Bit 3 */
        byte SBR4        :1;                                       /* SCI Baud Rate Bit 4 */
        byte SBR5        :1;                                       /* SCI Baud Rate Bit 5 */
        byte SBR6        :1;                                       /* SCI Baud Rate Bit 6 */
        byte SBR7        :1;                                       /* SCI Baud Rate Bit 7 */
      } Bits;
    } SCI1BDLSTR;
    #define SCI1BDL                     _SCI1BD.Overlap_STR.SCI1BDLSTR.Byte
    #define SCI1BDL_SBR0                _SCI1BD.Overlap_STR.SCI1BDLSTR.Bits.SBR0
    #define SCI1BDL_SBR1                _SCI1BD.Overlap_STR.SCI1BDLSTR.Bits.SBR1
    #define SCI1BDL_SBR2                _SCI1BD.Overlap_STR.SCI1BDLSTR.Bits.SBR2
    #define SCI1BDL_SBR3                _SCI1BD.Overlap_STR.SCI1BDLSTR.Bits.SBR3
    #define SCI1BDL_SBR4                _SCI1BD.Overlap_STR.SCI1BDLSTR.Bits.SBR4
    #define SCI1BDL_SBR5                _SCI1BD.Overlap_STR.SCI1BDLSTR.Bits.SBR5
    #define SCI1BDL_SBR6                _SCI1BD.Overlap_STR.SCI1BDLSTR.Bits.SBR6
    #define SCI1BDL_SBR7                _SCI1BD.Overlap_STR.SCI1BDLSTR.Bits.SBR7
    
    #define SCI1BDL_SBR0_MASK           1U
    #define SCI1BDL_SBR1_MASK           2U
    #define SCI1BDL_SBR2_MASK           4U
    #define SCI1BDL_SBR3_MASK           8U
    #define SCI1BDL_SBR4_MASK           16U
    #define SCI1BDL_SBR5_MASK           32U
    #define SCI1BDL_SBR6_MASK           64U
    #define SCI1BDL_SBR7_MASK           128U
    
  } Overlap_STR;

  struct {
    word SBR0        :1;                                       /* SCI Baud Rate Bit 0 */
    word SBR1        :1;                                       /* SCI Baud Rate Bit 1 */
    word SBR2        :1;                                       /* SCI Baud Rate Bit 2 */
    word SBR3        :1;                                       /* SCI Baud Rate Bit 3 */
    word SBR4        :1;                                       /* SCI Baud Rate Bit 4 */
    word SBR5        :1;                                       /* SCI Baud Rate Bit 5 */
    word SBR6        :1;                                       /* SCI Baud Rate Bit 6 */
    word SBR7        :1;                                       /* SCI Baud Rate Bit 7 */
    word SBR8        :1;                                       /* SCI Baud Rate Bit 8 */
    word SBR9        :1;                                       /* SCI Baud Rate Bit 9 */
    word SBR10       :1;                                       /* SCI Baud Rate Bit 10 */
    word SBR11       :1;                                       /* SCI Baud Rate Bit 11 */
    word SBR12       :1;                                       /* SCI Baud Rate Bit 12 */
    word TNP0        :1;                                       /* Transmitter Narrow Pulse Bit 0 */
    word TNP1        :1;                                       /* Transmitter Narrow Pulse Bit 1 */
    word IREN        :1;                                       /* Infrared Enable Bit */
  } Bits;
  struct {
    word grpSBR  :13;
    word grpTNP  :2;
    word         :1;
  } MergedBits;
} SCI1BDSTR;
extern volatile SCI1BDSTR _SCI1BD @(REG_BASE + 0x000000D0UL);
#define SCI1BD                          _SCI1BD.Word
#define SCI1BD_SBR0                     _SCI1BD.Bits.SBR0
#define SCI1BD_SBR1                     _SCI1BD.Bits.SBR1
#define SCI1BD_SBR2                     _SCI1BD.Bits.SBR2
#define SCI1BD_SBR3                     _SCI1BD.Bits.SBR3
#define SCI1BD_SBR4                     _SCI1BD.Bits.SBR4
#define SCI1BD_SBR5                     _SCI1BD.Bits.SBR5
#define SCI1BD_SBR6                     _SCI1BD.Bits.SBR6
#define SCI1BD_SBR7                     _SCI1BD.Bits.SBR7
#define SCI1BD_SBR8                     _SCI1BD.Bits.SBR8
#define SCI1BD_SBR9                     _SCI1BD.Bits.SBR9
#define SCI1BD_SBR10                    _SCI1BD.Bits.SBR10
#define SCI1BD_SBR11                    _SCI1BD.Bits.SBR11
#define SCI1BD_SBR12                    _SCI1BD.Bits.SBR12
#define SCI1BD_TNP0                     _SCI1BD.Bits.TNP0
#define SCI1BD_TNP1                     _SCI1BD.Bits.TNP1
#define SCI1BD_IREN                     _SCI1BD.Bits.IREN
#define SCI1BD_SBR                      _SCI1BD.MergedBits.grpSBR
#define SCI1BD_TNP                      _SCI1BD.MergedBits.grpTNP

#define SCI1BD_SBR0_MASK                1U
#define SCI1BD_SBR1_MASK                2U
#define SCI1BD_SBR2_MASK                4U
#define SCI1BD_SBR3_MASK                8U
#define SCI1BD_SBR4_MASK                16U
#define SCI1BD_SBR5_MASK                32U
#define SCI1BD_SBR6_MASK                64U
#define SCI1BD_SBR7_MASK                128U
#define SCI1BD_SBR8_MASK                256U
#define SCI1BD_SBR9_MASK                512U
#define SCI1BD_SBR10_MASK               1024U
#define SCI1BD_SBR11_MASK               2048U
#define SCI1BD_SBR12_MASK               4096U
#define SCI1BD_TNP0_MASK                8192U
#define SCI1BD_TNP1_MASK                16384U
#define SCI1BD_IREN_MASK                32768U
#define SCI1BD_SBR_MASK                 8191U
#define SCI1BD_SBR_BITNUM               0U
#define SCI1BD_TNP_MASK                 24576U
#define SCI1BD_TNP_BITNUM               13U


/*** SCI1CR1 - SCI 1 Control Register 1; 0x000000D2 ***/
typedef union {
  byte Byte;
  struct {
    byte PT          :1;                                       /* Parity Type Bit */
    byte PE          :1;                                       /* Parity Enable Bit */
    byte ILT         :1;                                       /* Idle Line Type Bit */
    byte WAKE        :1;                                       /* Wakeup Condition Bit */
    byte M           :1;                                       /* Data Format Mode Bit */
    byte RSRC        :1;                                       /* Receiver Source Bit */
    byte SCISWAI     :1;                                       /* SCI Stop in Wait Mode Bit */
    byte LOOPS       :1;                                       /* Loop Select Bit */
  } Bits;
} SCI1CR1STR;
extern volatile SCI1CR1STR _SCI1CR1 @(REG_BASE + 0x000000D2UL);
#define SCI1CR1                         _SCI1CR1.Byte
#define SCI1CR1_PT                      _SCI1CR1.Bits.PT
#define SCI1CR1_PE                      _SCI1CR1.Bits.PE
#define SCI1CR1_ILT                     _SCI1CR1.Bits.ILT
#define SCI1CR1_WAKE                    _SCI1CR1.Bits.WAKE
#define SCI1CR1_M                       _SCI1CR1.Bits.M
#define SCI1CR1_RSRC                    _SCI1CR1.Bits.RSRC
#define SCI1CR1_SCISWAI                 _SCI1CR1.Bits.SCISWAI
#define SCI1CR1_LOOPS                   _SCI1CR1.Bits.LOOPS

#define SCI1CR1_PT_MASK                 1U
#define SCI1CR1_PE_MASK                 2U
#define SCI1CR1_ILT_MASK                4U
#define SCI1CR1_WAKE_MASK               8U
#define SCI1CR1_M_MASK                  16U
#define SCI1CR1_RSRC_MASK               32U
#define SCI1CR1_SCISWAI_MASK            64U
#define SCI1CR1_LOOPS_MASK              128U


/*** SCI1CR2 - SCI 1 Control Register 2; 0x000000D3 ***/
typedef union {
  byte Byte;
  struct {
    byte SBK         :1;                                       /* Send Break Bit */
    byte RWU         :1;                                       /* Receiver Wakeup Bit */
    byte RE          :1;                                       /* Receiver Enable Bit */
    byte TE          :1;                                       /* Transmitter Enable Bit */
    byte ILIE        :1;                                       /* Idle Line Interrupt Enable Bit */
    byte RIE         :1;                                       /* Receiver Full Interrupt Enable Bit */
    byte TCIE        :1;                                       /* Transmission Complete Interrupt Enable Bit */
    byte SCTIE       :1;                                       /* Transmitter Interrupt Enable Bit */
  } Bits;
} SCI1CR2STR;
extern volatile SCI1CR2STR _SCI1CR2 @(REG_BASE + 0x000000D3UL);
#define SCI1CR2                         _SCI1CR2.Byte
#define SCI1CR2_SBK                     _SCI1CR2.Bits.SBK
#define SCI1CR2_RWU                     _SCI1CR2.Bits.RWU
#define SCI1CR2_RE                      _SCI1CR2.Bits.RE
#define SCI1CR2_TE                      _SCI1CR2.Bits.TE
#define SCI1CR2_ILIE                    _SCI1CR2.Bits.ILIE
#define SCI1CR2_RIE                     _SCI1CR2.Bits.RIE
#define SCI1CR2_TCIE                    _SCI1CR2.Bits.TCIE
#define SCI1CR2_SCTIE                   _SCI1CR2.Bits.SCTIE

#define SCI1CR2_SBK_MASK                1U
#define SCI1CR2_RWU_MASK                2U
#define SCI1CR2_RE_MASK                 4U
#define SCI1CR2_TE_MASK                 8U
#define SCI1CR2_ILIE_MASK               16U
#define SCI1CR2_RIE_MASK                32U
#define SCI1CR2_TCIE_MASK               64U
#define SCI1CR2_SCTIE_MASK              128U


/*** SCI1SR1 - SCI 1 Status Register 1; 0x000000D4 ***/
typedef union {
  byte Byte;
  struct {
    byte PF          :1;                                       /* Parity Error Flag */
    byte FE          :1;                                       /* Framing Error Flag */
    byte NF          :1;                                       /* Noise Flag */
    byte OR          :1;                                       /* Overrun Flag */
    byte IDLE        :1;                                       /* Idle Line Flag */
    byte RDRF        :1;                                       /* Receive Data Register Full Flag */
    byte TC          :1;                                       /* Transmit Complete Flag */
    byte TDRE        :1;                                       /* Transmit Data Register Empty Flag */
  } Bits;
} SCI1SR1STR;
extern volatile SCI1SR1STR _SCI1SR1 @(REG_BASE + 0x000000D4UL);
#define SCI1SR1                         _SCI1SR1.Byte
#define SCI1SR1_PF                      _SCI1SR1.Bits.PF
#define SCI1SR1_FE                      _SCI1SR1.Bits.FE
#define SCI1SR1_NF                      _SCI1SR1.Bits.NF
#define SCI1SR1_OR                      _SCI1SR1.Bits.OR
#define SCI1SR1_IDLE                    _SCI1SR1.Bits.IDLE
#define SCI1SR1_RDRF                    _SCI1SR1.Bits.RDRF
#define SCI1SR1_TC                      _SCI1SR1.Bits.TC
#define SCI1SR1_TDRE                    _SCI1SR1.Bits.TDRE

#define SCI1SR1_PF_MASK                 1U
#define SCI1SR1_FE_MASK                 2U
#define SCI1SR1_NF_MASK                 4U
#define SCI1SR1_OR_MASK                 8U
#define SCI1SR1_IDLE_MASK               16U
#define SCI1SR1_RDRF_MASK               32U
#define SCI1SR1_TC_MASK                 64U
#define SCI1SR1_TDRE_MASK               128U


/*** SCI1SR2 - SCI 1 Status Register 2; 0x000000D5 ***/
typedef union {
  byte Byte;
  struct {
    byte RAF         :1;                                       /* Receiver Active Flag */
    byte TXDIR       :1;                                       /* Transmitter pin data direction in Single-Wire mode */
    byte BRK13       :1;                                       /* Break Transmit character length */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} SCI1SR2STR;
extern volatile SCI1SR2STR _SCI1SR2 @(REG_BASE + 0x000000D5UL);
#define SCI1SR2                         _SCI1SR2.Byte
#define SCI1SR2_RAF                     _SCI1SR2.Bits.RAF
#define SCI1SR2_TXDIR                   _SCI1SR2.Bits.TXDIR
#define SCI1SR2_BRK13                   _SCI1SR2.Bits.BRK13

#define SCI1SR2_RAF_MASK                1U
#define SCI1SR2_TXDIR_MASK              2U
#define SCI1SR2_BRK13_MASK              4U


/*** SCI1DRH - SCI 1 Data Register High; 0x000000D6 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte T8          :1;                                       /* Transmit Bit 8 */
    byte R8          :1;                                       /* Received Bit 8 */
  } Bits;
} SCI1DRHSTR;
extern volatile SCI1DRHSTR _SCI1DRH @(REG_BASE + 0x000000D6UL);
#define SCI1DRH                         _SCI1DRH.Byte
#define SCI1DRH_T8                      _SCI1DRH.Bits.T8
#define SCI1DRH_R8                      _SCI1DRH.Bits.R8

#define SCI1DRH_T8_MASK                 64U
#define SCI1DRH_R8_MASK                 128U


/*** SCI1DRL - SCI 1 Data Register Low; 0x000000D7 ***/
typedef union {
  byte Byte;
  struct {
    byte R0_T0       :1;                                       /* Received bit 0 or Transmit bit 0 */
    byte R1_T1       :1;                                       /* Received bit 1 or Transmit bit 1 */
    byte R2_T2       :1;                                       /* Received bit 2 or Transmit bit 2 */
    byte R3_T3       :1;                                       /* Received bit 3 or Transmit bit 3 */
    byte R4_T4       :1;                                       /* Received bit 4 or Transmit bit 4 */
    byte R5_T5       :1;                                       /* Received bit 5 or Transmit bit 5 */
    byte R6_T6       :1;                                       /* Received bit 6 or Transmit bit 6 */
    byte R7_T7       :1;                                       /* Received bit 7 or Transmit bit 7 */
  } Bits;
} SCI1DRLSTR;
extern volatile SCI1DRLSTR _SCI1DRL @(REG_BASE + 0x000000D7UL);
#define SCI1DRL                         _SCI1DRL.Byte
#define SCI1DRL_R0_T0                   _SCI1DRL.Bits.R0_T0
#define SCI1DRL_R1_T1                   _SCI1DRL.Bits.R1_T1
#define SCI1DRL_R2_T2                   _SCI1DRL.Bits.R2_T2
#define SCI1DRL_R3_T3                   _SCI1DRL.Bits.R3_T3
#define SCI1DRL_R4_T4                   _SCI1DRL.Bits.R4_T4
#define SCI1DRL_R5_T5                   _SCI1DRL.Bits.R5_T5
#define SCI1DRL_R6_T6                   _SCI1DRL.Bits.R6_T6
#define SCI1DRL_R7_T7                   _SCI1DRL.Bits.R7_T7

#define SCI1DRL_R0_T0_MASK              1U
#define SCI1DRL_R1_T1_MASK              2U
#define SCI1DRL_R2_T2_MASK              4U
#define SCI1DRL_R3_T3_MASK              8U
#define SCI1DRL_R4_T4_MASK              16U
#define SCI1DRL_R5_T5_MASK              32U
#define SCI1DRL_R6_T6_MASK              64U
#define SCI1DRL_R7_T7_MASK              128U


/*** SPICR1 - SPI Control Register; 0x000000D8 ***/
typedef union {
  byte Byte;
  struct {
    byte LSBFE       :1;                                       /* SPI LSB-First Enable */
    byte SSOE        :1;                                       /* Slave Select Output Enable */
    byte CPHA        :1;                                       /* SPI Clock Phase Bit */
    byte CPOL        :1;                                       /* SPI Clock Polarity Bit */
    byte MSTR        :1;                                       /* SPI Master/Slave Mode Select Bit */
    byte SPTIE       :1;                                       /* SPI Transmit Interrupt Enable */
    byte SPE         :1;                                       /* SPI System Enable Bit */
    byte SPIE        :1;                                       /* SPI Interrupt Enable Bit */
  } Bits;
} SPICR1STR;
extern volatile SPICR1STR _SPICR1 @(REG_BASE + 0x000000D8UL);
#define SPICR1                          _SPICR1.Byte
#define SPICR1_LSBFE                    _SPICR1.Bits.LSBFE
#define SPICR1_SSOE                     _SPICR1.Bits.SSOE
#define SPICR1_CPHA                     _SPICR1.Bits.CPHA
#define SPICR1_CPOL                     _SPICR1.Bits.CPOL
#define SPICR1_MSTR                     _SPICR1.Bits.MSTR
#define SPICR1_SPTIE                    _SPICR1.Bits.SPTIE
#define SPICR1_SPE                      _SPICR1.Bits.SPE
#define SPICR1_SPIE                     _SPICR1.Bits.SPIE

#define SPICR1_LSBFE_MASK               1U
#define SPICR1_SSOE_MASK                2U
#define SPICR1_CPHA_MASK                4U
#define SPICR1_CPOL_MASK                8U
#define SPICR1_MSTR_MASK                16U
#define SPICR1_SPTIE_MASK               32U
#define SPICR1_SPE_MASK                 64U
#define SPICR1_SPIE_MASK                128U


/*** SPICR2 - SPI Control Register 2; 0x000000D9 ***/
typedef union {
  byte Byte;
  struct {
    byte SPC0        :1;                                       /* Serial Pin Control Bit 0 */
    byte SPISWAI     :1;                                       /* SPI Stop in Wait Mode Bit */
    byte             :1; 
    byte BIDIROE     :1;                                       /* Output enable in the Bidirectional mode of operation */
    byte MODFEN      :1;                                       /* Mode Fault Enable Bit */
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} SPICR2STR;
extern volatile SPICR2STR _SPICR2 @(REG_BASE + 0x000000D9UL);
#define SPICR2                          _SPICR2.Byte
#define SPICR2_SPC0                     _SPICR2.Bits.SPC0
#define SPICR2_SPISWAI                  _SPICR2.Bits.SPISWAI
#define SPICR2_BIDIROE                  _SPICR2.Bits.BIDIROE
#define SPICR2_MODFEN                   _SPICR2.Bits.MODFEN

#define SPICR2_SPC0_MASK                1U
#define SPICR2_SPISWAI_MASK             2U
#define SPICR2_BIDIROE_MASK             8U
#define SPICR2_MODFEN_MASK              16U


/*** SPIBR - SPI Baud Rate Register; 0x000000DA ***/
typedef union {
  byte Byte;
  struct {
    byte SPR0        :1;                                       /* SPI Baud Rate Selection Bit 0 */
    byte SPR1        :1;                                       /* SPI Baud Rate Selection Bit 1 */
    byte SPR2        :1;                                       /* SPI Baud Rate Selection Bit 2 */
    byte             :1; 
    byte SPPR0       :1;                                       /* SPI Baud Rate Preselection Bits 0 */
    byte SPPR1       :1;                                       /* SPI Baud Rate Preselection Bits 1 */
    byte SPPR2       :1;                                       /* SPI Baud Rate Preselection Bits 2 */
    byte             :1; 
  } Bits;
  struct {
    byte grpSPR  :3;
    byte         :1;
    byte grpSPPR :3;
    byte         :1;
  } MergedBits;
} SPIBRSTR;
extern volatile SPIBRSTR _SPIBR @(REG_BASE + 0x000000DAUL);
#define SPIBR                           _SPIBR.Byte
#define SPIBR_SPR0                      _SPIBR.Bits.SPR0
#define SPIBR_SPR1                      _SPIBR.Bits.SPR1
#define SPIBR_SPR2                      _SPIBR.Bits.SPR2
#define SPIBR_SPPR0                     _SPIBR.Bits.SPPR0
#define SPIBR_SPPR1                     _SPIBR.Bits.SPPR1
#define SPIBR_SPPR2                     _SPIBR.Bits.SPPR2
#define SPIBR_SPR                       _SPIBR.MergedBits.grpSPR
#define SPIBR_SPPR                      _SPIBR.MergedBits.grpSPPR

#define SPIBR_SPR0_MASK                 1U
#define SPIBR_SPR1_MASK                 2U
#define SPIBR_SPR2_MASK                 4U
#define SPIBR_SPPR0_MASK                16U
#define SPIBR_SPPR1_MASK                32U
#define SPIBR_SPPR2_MASK                64U
#define SPIBR_SPR_MASK                  7U
#define SPIBR_SPR_BITNUM                0U
#define SPIBR_SPPR_MASK                 112U
#define SPIBR_SPPR_BITNUM               4U


/*** SPISR - SPI Status Register; 0x000000DB ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte MODF        :1;                                       /* Mode Fault Flag */
    byte SPTEF       :1;                                       /* SPI Transmit Empty Interrupt Flag */
    byte             :1; 
    byte SPIF        :1;                                       /* SPIF Receive Interrupt Flag */
  } Bits;
} SPISRSTR;
extern volatile SPISRSTR _SPISR @(REG_BASE + 0x000000DBUL);
#define SPISR                           _SPISR.Byte
#define SPISR_MODF                      _SPISR.Bits.MODF
#define SPISR_SPTEF                     _SPISR.Bits.SPTEF
#define SPISR_SPIF                      _SPISR.Bits.SPIF

#define SPISR_MODF_MASK                 16U
#define SPISR_SPTEF_MASK                32U
#define SPISR_SPIF_MASK                 128U


/*** SPIDR - SPI Data Register; 0x000000DD ***/
typedef union {
  byte Byte;
} SPIDRSTR;
extern volatile SPIDRSTR _SPIDR @(REG_BASE + 0x000000DDUL);
#define SPIDR                           _SPIDR.Byte


/*** IBAD - IIC Address Register; 0x000000E0 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte ADR1        :1;                                       /* Slave Address Bit 1 */
    byte ADR2        :1;                                       /* Slave Address Bit 2 */
    byte ADR3        :1;                                       /* Slave Address Bit 3 */
    byte ADR4        :1;                                       /* Slave Address Bit 4 */
    byte ADR5        :1;                                       /* Slave Address Bit 5 */
    byte ADR6        :1;                                       /* Slave Address Bit 6 */
    byte ADR7        :1;                                       /* Slave Address Bit 7 */
  } Bits;
  struct {
    byte         :1;
    byte grpADR_1 :7;
  } MergedBits;
} IBADSTR;
extern volatile IBADSTR _IBAD @(REG_BASE + 0x000000E0UL);
#define IBAD                            _IBAD.Byte
#define IBAD_ADR1                       _IBAD.Bits.ADR1
#define IBAD_ADR2                       _IBAD.Bits.ADR2
#define IBAD_ADR3                       _IBAD.Bits.ADR3
#define IBAD_ADR4                       _IBAD.Bits.ADR4
#define IBAD_ADR5                       _IBAD.Bits.ADR5
#define IBAD_ADR6                       _IBAD.Bits.ADR6
#define IBAD_ADR7                       _IBAD.Bits.ADR7
#define IBAD_ADR_1                      _IBAD.MergedBits.grpADR_1
#define IBAD_ADR                        IBAD_ADR_1

#define IBAD_ADR1_MASK                  2U
#define IBAD_ADR2_MASK                  4U
#define IBAD_ADR3_MASK                  8U
#define IBAD_ADR4_MASK                  16U
#define IBAD_ADR5_MASK                  32U
#define IBAD_ADR6_MASK                  64U
#define IBAD_ADR7_MASK                  128U
#define IBAD_ADR_1_MASK                 254U
#define IBAD_ADR_1_BITNUM               1U


/*** IBFD - IIC Frequency Divider Register; 0x000000E1 ***/
typedef union {
  byte Byte;
  struct {
    byte IBC0        :1;                                       /* I-Bus Clock Rate 0 */
    byte IBC1        :1;                                       /* I-Bus Clock Rate 1 */
    byte IBC2        :1;                                       /* I-Bus Clock Rate 2 */
    byte IBC3        :1;                                       /* I-Bus Clock Rate 3 */
    byte IBC4        :1;                                       /* I-Bus Clock Rate 4 */
    byte IBC5        :1;                                       /* I-Bus Clock Rate 5 */
    byte IBC6        :1;                                       /* I-Bus Clock Rate 6 */
    byte IBC7        :1;                                       /* I-Bus Clock Rate 7 */
  } Bits;
} IBFDSTR;
extern volatile IBFDSTR _IBFD @(REG_BASE + 0x000000E1UL);
#define IBFD                            _IBFD.Byte
#define IBFD_IBC0                       _IBFD.Bits.IBC0
#define IBFD_IBC1                       _IBFD.Bits.IBC1
#define IBFD_IBC2                       _IBFD.Bits.IBC2
#define IBFD_IBC3                       _IBFD.Bits.IBC3
#define IBFD_IBC4                       _IBFD.Bits.IBC4
#define IBFD_IBC5                       _IBFD.Bits.IBC5
#define IBFD_IBC6                       _IBFD.Bits.IBC6
#define IBFD_IBC7                       _IBFD.Bits.IBC7

#define IBFD_IBC0_MASK                  1U
#define IBFD_IBC1_MASK                  2U
#define IBFD_IBC2_MASK                  4U
#define IBFD_IBC3_MASK                  8U
#define IBFD_IBC4_MASK                  16U
#define IBFD_IBC5_MASK                  32U
#define IBFD_IBC6_MASK                  64U
#define IBFD_IBC7_MASK                  128U


/*** IBCR - IIC Control Register; 0x000000E2 ***/
typedef union {
  byte Byte;
  struct {
    byte IBSWAI      :1;                                       /* I-Bus Interface Stop in WAIT mode */
    byte             :1; 
    byte RSTA        :1;                                       /* Repeat Start */
    byte TXAK        :1;                                       /* Transmit Acknowledge enable */
    byte TX_RX       :1;                                       /* Transmit/Receive mode select bit */
    byte MS_SL       :1;                                       /* Master/Slave mode select bit */
    byte IBIE        :1;                                       /* I-Bus Interrupt Enable */
    byte IBEN        :1;                                       /* I-Bus Enable */
  } Bits;
} IBCRSTR;
extern volatile IBCRSTR _IBCR @(REG_BASE + 0x000000E2UL);
#define IBCR                            _IBCR.Byte
#define IBCR_IBSWAI                     _IBCR.Bits.IBSWAI
#define IBCR_RSTA                       _IBCR.Bits.RSTA
#define IBCR_TXAK                       _IBCR.Bits.TXAK
#define IBCR_TX_RX                      _IBCR.Bits.TX_RX
#define IBCR_MS_SL                      _IBCR.Bits.MS_SL
#define IBCR_IBIE                       _IBCR.Bits.IBIE
#define IBCR_IBEN                       _IBCR.Bits.IBEN

#define IBCR_IBSWAI_MASK                1U
#define IBCR_RSTA_MASK                  4U
#define IBCR_TXAK_MASK                  8U
#define IBCR_TX_RX_MASK                 16U
#define IBCR_MS_SL_MASK                 32U
#define IBCR_IBIE_MASK                  64U
#define IBCR_IBEN_MASK                  128U


/*** IBSR - IIC Status Register; 0x000000E3 ***/
typedef union {
  byte Byte;
  struct {
    byte RXAK        :1;                                       /* Received Acknowledge */
    byte IBIF        :1;                                       /* I-Bus Interrupt */
    byte SRW         :1;                                       /* Slave Read/Write */
    byte             :1; 
    byte IBAL        :1;                                       /* Arbitration Lost */
    byte IBB         :1;                                       /* Bus busy bit */
    byte IAAS        :1;                                       /* Addressed as a slave bit */
    byte TCF         :1;                                       /* Data transferring bit */
  } Bits;
} IBSRSTR;
extern volatile IBSRSTR _IBSR @(REG_BASE + 0x000000E3UL);
#define IBSR                            _IBSR.Byte
#define IBSR_RXAK                       _IBSR.Bits.RXAK
#define IBSR_IBIF                       _IBSR.Bits.IBIF
#define IBSR_SRW                        _IBSR.Bits.SRW
#define IBSR_IBAL                       _IBSR.Bits.IBAL
#define IBSR_IBB                        _IBSR.Bits.IBB
#define IBSR_IAAS                       _IBSR.Bits.IAAS
#define IBSR_TCF                        _IBSR.Bits.TCF

#define IBSR_RXAK_MASK                  1U
#define IBSR_IBIF_MASK                  2U
#define IBSR_SRW_MASK                   4U
#define IBSR_IBAL_MASK                  16U
#define IBSR_IBB_MASK                   32U
#define IBSR_IAAS_MASK                  64U
#define IBSR_TCF_MASK                   128U


/*** IBDR - IIC Data I/O Register; 0x000000E4 ***/
typedef union {
  byte Byte;
  struct {
    byte D0          :1;                                       /* IIC Data Bit 0 */
    byte D1          :1;                                       /* IIC Data Bit 1 */
    byte D2          :1;                                       /* IIC Data Bit 2 */
    byte D3          :1;                                       /* IIC Data Bit 3 */
    byte D4          :1;                                       /* IIC Data Bit 4 */
    byte D5          :1;                                       /* IIC Data Bit 5 */
    byte D6          :1;                                       /* IIC Data Bit 6 */
    byte D7          :1;                                       /* IIC Data Bit 7 */
  } Bits;
} IBDRSTR;
extern volatile IBDRSTR _IBDR @(REG_BASE + 0x000000E4UL);
#define IBDR                            _IBDR.Byte
#define IBDR_D0                         _IBDR.Bits.D0
#define IBDR_D1                         _IBDR.Bits.D1
#define IBDR_D2                         _IBDR.Bits.D2
#define IBDR_D3                         _IBDR.Bits.D3
#define IBDR_D4                         _IBDR.Bits.D4
#define IBDR_D5                         _IBDR.Bits.D5
#define IBDR_D6                         _IBDR.Bits.D6
#define IBDR_D7                         _IBDR.Bits.D7

#define IBDR_D0_MASK                    1U
#define IBDR_D1_MASK                    2U
#define IBDR_D2_MASK                    4U
#define IBDR_D3_MASK                    8U
#define IBDR_D4_MASK                    16U
#define IBDR_D5_MASK                    32U
#define IBDR_D6_MASK                    64U
#define IBDR_D7_MASK                    128U


/*** SCI2BD - SCI 2 Baud Rate Register; 0x000000E8 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** SCI2BDH - SCI 2 Baud Rate Register High; 0x000000E8 ***/
    union {
      byte Byte;
      struct {
        byte SBR8        :1;                                       /* SCI Baud Rate Bit 8 */
        byte SBR9        :1;                                       /* SCI Baud Rate Bit 9 */
        byte SBR10       :1;                                       /* SCI Baud Rate Bit 10 */
        byte SBR11       :1;                                       /* SCI Baud Rate Bit 11 */
        byte SBR12       :1;                                       /* SCI Baud Rate Bit 12 */
        byte TNP0        :1;                                       /* Transmitter Narrow Pulse Bit 0 */
        byte TNP1        :1;                                       /* Transmitter Narrow Pulse Bit 1 */
        byte IREN        :1;                                       /* Infrared Enable Bit */
      } Bits;
      struct {
        byte grpSBR_8 :5;
        byte grpTNP :2;
        byte     :1;
      } MergedBits;
    } SCI2BDHSTR;
    #define SCI2BDH                     _SCI2BD.Overlap_STR.SCI2BDHSTR.Byte
    #define SCI2BDH_SBR8                _SCI2BD.Overlap_STR.SCI2BDHSTR.Bits.SBR8
    #define SCI2BDH_SBR9                _SCI2BD.Overlap_STR.SCI2BDHSTR.Bits.SBR9
    #define SCI2BDH_SBR10               _SCI2BD.Overlap_STR.SCI2BDHSTR.Bits.SBR10
    #define SCI2BDH_SBR11               _SCI2BD.Overlap_STR.SCI2BDHSTR.Bits.SBR11
    #define SCI2BDH_SBR12               _SCI2BD.Overlap_STR.SCI2BDHSTR.Bits.SBR12
    #define SCI2BDH_TNP0                _SCI2BD.Overlap_STR.SCI2BDHSTR.Bits.TNP0
    #define SCI2BDH_TNP1                _SCI2BD.Overlap_STR.SCI2BDHSTR.Bits.TNP1
    #define SCI2BDH_IREN                _SCI2BD.Overlap_STR.SCI2BDHSTR.Bits.IREN
    #define SCI2BDH_SBR_8               _SCI2BD.Overlap_STR.SCI2BDHSTR.MergedBits.grpSBR_8
    #define SCI2BDH_TNP                 _SCI2BD.Overlap_STR.SCI2BDHSTR.MergedBits.grpTNP
    #define SCI2BDH_SBR                 SCI2BDH_SBR_8
    
    #define SCI2BDH_SBR8_MASK           1U
    #define SCI2BDH_SBR9_MASK           2U
    #define SCI2BDH_SBR10_MASK          4U
    #define SCI2BDH_SBR11_MASK          8U
    #define SCI2BDH_SBR12_MASK          16U
    #define SCI2BDH_TNP0_MASK           32U
    #define SCI2BDH_TNP1_MASK           64U
    #define SCI2BDH_IREN_MASK           128U
    #define SCI2BDH_SBR_8_MASK          31U
    #define SCI2BDH_SBR_8_BITNUM        0U
    #define SCI2BDH_TNP_MASK            96U
    #define SCI2BDH_TNP_BITNUM          5U
    

    /*** SCI2BDL - SCI 2 Baud Rate Register Low; 0x000000E9 ***/
    union {
      byte Byte;
      struct {
        byte SBR0        :1;                                       /* SCI Baud Rate Bit 0 */
        byte SBR1        :1;                                       /* SCI Baud Rate Bit 1 */
        byte SBR2        :1;                                       /* SCI Baud Rate Bit 2 */
        byte SBR3        :1;                                       /* SCI Baud Rate Bit 3 */
        byte SBR4        :1;                                       /* SCI Baud Rate Bit 4 */
        byte SBR5        :1;                                       /* SCI Baud Rate Bit 5 */
        byte SBR6        :1;                                       /* SCI Baud Rate Bit 6 */
        byte SBR7        :1;                                       /* SCI Baud Rate Bit 7 */
      } Bits;
    } SCI2BDLSTR;
    #define SCI2BDL                     _SCI2BD.Overlap_STR.SCI2BDLSTR.Byte
    #define SCI2BDL_SBR0                _SCI2BD.Overlap_STR.SCI2BDLSTR.Bits.SBR0
    #define SCI2BDL_SBR1                _SCI2BD.Overlap_STR.SCI2BDLSTR.Bits.SBR1
    #define SCI2BDL_SBR2                _SCI2BD.Overlap_STR.SCI2BDLSTR.Bits.SBR2
    #define SCI2BDL_SBR3                _SCI2BD.Overlap_STR.SCI2BDLSTR.Bits.SBR3
    #define SCI2BDL_SBR4                _SCI2BD.Overlap_STR.SCI2BDLSTR.Bits.SBR4
    #define SCI2BDL_SBR5                _SCI2BD.Overlap_STR.SCI2BDLSTR.Bits.SBR5
    #define SCI2BDL_SBR6                _SCI2BD.Overlap_STR.SCI2BDLSTR.Bits.SBR6
    #define SCI2BDL_SBR7                _SCI2BD.Overlap_STR.SCI2BDLSTR.Bits.SBR7
    
    #define SCI2BDL_SBR0_MASK           1U
    #define SCI2BDL_SBR1_MASK           2U
    #define SCI2BDL_SBR2_MASK           4U
    #define SCI2BDL_SBR3_MASK           8U
    #define SCI2BDL_SBR4_MASK           16U
    #define SCI2BDL_SBR5_MASK           32U
    #define SCI2BDL_SBR6_MASK           64U
    #define SCI2BDL_SBR7_MASK           128U
    
  } Overlap_STR;

  struct {
    word SBR0        :1;                                       /* SCI Baud Rate Bit 0 */
    word SBR1        :1;                                       /* SCI Baud Rate Bit 1 */
    word SBR2        :1;                                       /* SCI Baud Rate Bit 2 */
    word SBR3        :1;                                       /* SCI Baud Rate Bit 3 */
    word SBR4        :1;                                       /* SCI Baud Rate Bit 4 */
    word SBR5        :1;                                       /* SCI Baud Rate Bit 5 */
    word SBR6        :1;                                       /* SCI Baud Rate Bit 6 */
    word SBR7        :1;                                       /* SCI Baud Rate Bit 7 */
    word SBR8        :1;                                       /* SCI Baud Rate Bit 8 */
    word SBR9        :1;                                       /* SCI Baud Rate Bit 9 */
    word SBR10       :1;                                       /* SCI Baud Rate Bit 10 */
    word SBR11       :1;                                       /* SCI Baud Rate Bit 11 */
    word SBR12       :1;                                       /* SCI Baud Rate Bit 12 */
    word TNP0        :1;                                       /* Transmitter Narrow Pulse Bit 0 */
    word TNP1        :1;                                       /* Transmitter Narrow Pulse Bit 1 */
    word IREN        :1;                                       /* Infrared Enable Bit */
  } Bits;
  struct {
    word grpSBR  :13;
    word grpTNP  :2;
    word         :1;
  } MergedBits;
} SCI2BDSTR;
extern volatile SCI2BDSTR _SCI2BD @(REG_BASE + 0x000000E8UL);
#define SCI2BD                          _SCI2BD.Word
#define SCI2BD_SBR0                     _SCI2BD.Bits.SBR0
#define SCI2BD_SBR1                     _SCI2BD.Bits.SBR1
#define SCI2BD_SBR2                     _SCI2BD.Bits.SBR2
#define SCI2BD_SBR3                     _SCI2BD.Bits.SBR3
#define SCI2BD_SBR4                     _SCI2BD.Bits.SBR4
#define SCI2BD_SBR5                     _SCI2BD.Bits.SBR5
#define SCI2BD_SBR6                     _SCI2BD.Bits.SBR6
#define SCI2BD_SBR7                     _SCI2BD.Bits.SBR7
#define SCI2BD_SBR8                     _SCI2BD.Bits.SBR8
#define SCI2BD_SBR9                     _SCI2BD.Bits.SBR9
#define SCI2BD_SBR10                    _SCI2BD.Bits.SBR10
#define SCI2BD_SBR11                    _SCI2BD.Bits.SBR11
#define SCI2BD_SBR12                    _SCI2BD.Bits.SBR12
#define SCI2BD_TNP0                     _SCI2BD.Bits.TNP0
#define SCI2BD_TNP1                     _SCI2BD.Bits.TNP1
#define SCI2BD_IREN                     _SCI2BD.Bits.IREN
#define SCI2BD_SBR                      _SCI2BD.MergedBits.grpSBR
#define SCI2BD_TNP                      _SCI2BD.MergedBits.grpTNP

#define SCI2BD_SBR0_MASK                1U
#define SCI2BD_SBR1_MASK                2U
#define SCI2BD_SBR2_MASK                4U
#define SCI2BD_SBR3_MASK                8U
#define SCI2BD_SBR4_MASK                16U
#define SCI2BD_SBR5_MASK                32U
#define SCI2BD_SBR6_MASK                64U
#define SCI2BD_SBR7_MASK                128U
#define SCI2BD_SBR8_MASK                256U
#define SCI2BD_SBR9_MASK                512U
#define SCI2BD_SBR10_MASK               1024U
#define SCI2BD_SBR11_MASK               2048U
#define SCI2BD_SBR12_MASK               4096U
#define SCI2BD_TNP0_MASK                8192U
#define SCI2BD_TNP1_MASK                16384U
#define SCI2BD_IREN_MASK                32768U
#define SCI2BD_SBR_MASK                 8191U
#define SCI2BD_SBR_BITNUM               0U
#define SCI2BD_TNP_MASK                 24576U
#define SCI2BD_TNP_BITNUM               13U


/*** SCI2CR1 - SCI 2 Control Register 1; 0x000000EA ***/
typedef union {
  byte Byte;
  struct {
    byte PT          :1;                                       /* Parity Type Bit */
    byte PE          :1;                                       /* Parity Enable Bit */
    byte ILT         :1;                                       /* Idle Line Type Bit */
    byte WAKE        :1;                                       /* Wakeup Condition Bit */
    byte M           :1;                                       /* Data Format Mode Bit */
    byte RSRC        :1;                                       /* Receiver Source Bit */
    byte SCISWAI     :1;                                       /* SCI Stop in Wait Mode Bit */
    byte LOOPS       :1;                                       /* Loop Select Bit */
  } Bits;
} SCI2CR1STR;
extern volatile SCI2CR1STR _SCI2CR1 @(REG_BASE + 0x000000EAUL);
#define SCI2CR1                         _SCI2CR1.Byte
#define SCI2CR1_PT                      _SCI2CR1.Bits.PT
#define SCI2CR1_PE                      _SCI2CR1.Bits.PE
#define SCI2CR1_ILT                     _SCI2CR1.Bits.ILT
#define SCI2CR1_WAKE                    _SCI2CR1.Bits.WAKE
#define SCI2CR1_M                       _SCI2CR1.Bits.M
#define SCI2CR1_RSRC                    _SCI2CR1.Bits.RSRC
#define SCI2CR1_SCISWAI                 _SCI2CR1.Bits.SCISWAI
#define SCI2CR1_LOOPS                   _SCI2CR1.Bits.LOOPS

#define SCI2CR1_PT_MASK                 1U
#define SCI2CR1_PE_MASK                 2U
#define SCI2CR1_ILT_MASK                4U
#define SCI2CR1_WAKE_MASK               8U
#define SCI2CR1_M_MASK                  16U
#define SCI2CR1_RSRC_MASK               32U
#define SCI2CR1_SCISWAI_MASK            64U
#define SCI2CR1_LOOPS_MASK              128U


/*** SCI2CR2 - SCI 2 Control Register 2; 0x000000EB ***/
typedef union {
  byte Byte;
  struct {
    byte SBK         :1;                                       /* Send Break Bit */
    byte RWU         :1;                                       /* Receiver Wakeup Bit */
    byte RE          :1;                                       /* Receiver Enable Bit */
    byte TE          :1;                                       /* Transmitter Enable Bit */
    byte ILIE        :1;                                       /* Idle Line Interrupt Enable Bit */
    byte RIE         :1;                                       /* Receiver Full Interrupt Enable Bit */
    byte TCIE        :1;                                       /* Transmission Complete Interrupt Enable Bit */
    byte SCTIE       :1;                                       /* Transmitter Interrupt Enable Bit */
  } Bits;
} SCI2CR2STR;
extern volatile SCI2CR2STR _SCI2CR2 @(REG_BASE + 0x000000EBUL);
#define SCI2CR2                         _SCI2CR2.Byte
#define SCI2CR2_SBK                     _SCI2CR2.Bits.SBK
#define SCI2CR2_RWU                     _SCI2CR2.Bits.RWU
#define SCI2CR2_RE                      _SCI2CR2.Bits.RE
#define SCI2CR2_TE                      _SCI2CR2.Bits.TE
#define SCI2CR2_ILIE                    _SCI2CR2.Bits.ILIE
#define SCI2CR2_RIE                     _SCI2CR2.Bits.RIE
#define SCI2CR2_TCIE                    _SCI2CR2.Bits.TCIE
#define SCI2CR2_SCTIE                   _SCI2CR2.Bits.SCTIE

#define SCI2CR2_SBK_MASK                1U
#define SCI2CR2_RWU_MASK                2U
#define SCI2CR2_RE_MASK                 4U
#define SCI2CR2_TE_MASK                 8U
#define SCI2CR2_ILIE_MASK               16U
#define SCI2CR2_RIE_MASK                32U
#define SCI2CR2_TCIE_MASK               64U
#define SCI2CR2_SCTIE_MASK              128U


/*** SCI2SR1 - SCI 2 Status Register 1; 0x000000EC ***/
typedef union {
  byte Byte;
  struct {
    byte PF          :1;                                       /* Parity Error Flag */
    byte FE          :1;                                       /* Framing Error Flag */
    byte NF          :1;                                       /* Noise Flag */
    byte OR          :1;                                       /* Overrun Flag */
    byte IDLE        :1;                                       /* Idle Line Flag */
    byte RDRF        :1;                                       /* Receive Data Register Full Flag */
    byte TC          :1;                                       /* Transmit Complete Flag */
    byte TDRE        :1;                                       /* Transmit Data Register Empty Flag */
  } Bits;
} SCI2SR1STR;
extern volatile SCI2SR1STR _SCI2SR1 @(REG_BASE + 0x000000ECUL);
#define SCI2SR1                         _SCI2SR1.Byte
#define SCI2SR1_PF                      _SCI2SR1.Bits.PF
#define SCI2SR1_FE                      _SCI2SR1.Bits.FE
#define SCI2SR1_NF                      _SCI2SR1.Bits.NF
#define SCI2SR1_OR                      _SCI2SR1.Bits.OR
#define SCI2SR1_IDLE                    _SCI2SR1.Bits.IDLE
#define SCI2SR1_RDRF                    _SCI2SR1.Bits.RDRF
#define SCI2SR1_TC                      _SCI2SR1.Bits.TC
#define SCI2SR1_TDRE                    _SCI2SR1.Bits.TDRE

#define SCI2SR1_PF_MASK                 1U
#define SCI2SR1_FE_MASK                 2U
#define SCI2SR1_NF_MASK                 4U
#define SCI2SR1_OR_MASK                 8U
#define SCI2SR1_IDLE_MASK               16U
#define SCI2SR1_RDRF_MASK               32U
#define SCI2SR1_TC_MASK                 64U
#define SCI2SR1_TDRE_MASK               128U


/*** SCI2SR2 - SCI 2 Status Register 2; 0x000000ED ***/
typedef union {
  byte Byte;
  struct {
    byte RAF         :1;                                       /* Receiver Active Flag */
    byte TXDIR       :1;                                       /* Transmitter pin data direction in Single-Wire mode */
    byte BRK13       :1;                                       /* Break Transmit character length */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} SCI2SR2STR;
extern volatile SCI2SR2STR _SCI2SR2 @(REG_BASE + 0x000000EDUL);
#define SCI2SR2                         _SCI2SR2.Byte
#define SCI2SR2_RAF                     _SCI2SR2.Bits.RAF
#define SCI2SR2_TXDIR                   _SCI2SR2.Bits.TXDIR
#define SCI2SR2_BRK13                   _SCI2SR2.Bits.BRK13

#define SCI2SR2_RAF_MASK                1U
#define SCI2SR2_TXDIR_MASK              2U
#define SCI2SR2_BRK13_MASK              4U


/*** SCI2DRH - SCI 2 Data Register High; 0x000000EE ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte T8          :1;                                       /* Transmit Bit 8 */
    byte R8          :1;                                       /* Received Bit 8 */
  } Bits;
} SCI2DRHSTR;
extern volatile SCI2DRHSTR _SCI2DRH @(REG_BASE + 0x000000EEUL);
#define SCI2DRH                         _SCI2DRH.Byte
#define SCI2DRH_T8                      _SCI2DRH.Bits.T8
#define SCI2DRH_R8                      _SCI2DRH.Bits.R8

#define SCI2DRH_T8_MASK                 64U
#define SCI2DRH_R8_MASK                 128U


/*** SCI2DRL - SCI 2 Data Register Low; 0x000000EF ***/
typedef union {
  byte Byte;
  struct {
    byte R0_T0       :1;                                       /* Received bit 0 or Transmit bit 0 */
    byte R1_T1       :1;                                       /* Received bit 1 or Transmit bit 1 */
    byte R2_T2       :1;                                       /* Received bit 2 or Transmit bit 2 */
    byte R3_T3       :1;                                       /* Received bit 3 or Transmit bit 3 */
    byte R4_T4       :1;                                       /* Received bit 4 or Transmit bit 4 */
    byte R5_T5       :1;                                       /* Received bit 5 or Transmit bit 5 */
    byte R6_T6       :1;                                       /* Received bit 6 or Transmit bit 6 */
    byte R7_T7       :1;                                       /* Received bit 7 or Transmit bit 7 */
  } Bits;
} SCI2DRLSTR;
extern volatile SCI2DRLSTR _SCI2DRL @(REG_BASE + 0x000000EFUL);
#define SCI2DRL                         _SCI2DRL.Byte
#define SCI2DRL_R0_T0                   _SCI2DRL.Bits.R0_T0
#define SCI2DRL_R1_T1                   _SCI2DRL.Bits.R1_T1
#define SCI2DRL_R2_T2                   _SCI2DRL.Bits.R2_T2
#define SCI2DRL_R3_T3                   _SCI2DRL.Bits.R3_T3
#define SCI2DRL_R4_T4                   _SCI2DRL.Bits.R4_T4
#define SCI2DRL_R5_T5                   _SCI2DRL.Bits.R5_T5
#define SCI2DRL_R6_T6                   _SCI2DRL.Bits.R6_T6
#define SCI2DRL_R7_T7                   _SCI2DRL.Bits.R7_T7

#define SCI2DRL_R0_T0_MASK              1U
#define SCI2DRL_R1_T1_MASK              2U
#define SCI2DRL_R2_T2_MASK              4U
#define SCI2DRL_R3_T3_MASK              8U
#define SCI2DRL_R4_T4_MASK              16U
#define SCI2DRL_R5_T5_MASK              32U
#define SCI2DRL_R6_T6_MASK              64U
#define SCI2DRL_R7_T7_MASK              128U


/*** DAC0_DACC0 - DAC0 Control Register 0; 0x000000F0 ***/
typedef union {
  byte Byte;
  struct {
    byte DACOE       :1;                                       /* DAC Output Enable */
    byte DACWAI      :1;                                       /* DAC Stop in WAIT mode */
    byte DSGN        :1;                                       /* Result Register Data Signed or Unsigned Representation */
    byte DJM         :1;                                       /* Data Register Data Justification */
    byte             :1; 
    byte             :1; 
    byte DACTE       :1;                                       /* DAC Test Enable */
    byte DACE        :1;                                       /* DAC Enable */
  } Bits;
} DAC0_DACC0STR;
extern volatile DAC0_DACC0STR _DAC0_DACC0 @(REG_BASE + 0x000000F0UL);
#define DAC0_DACC0                      _DAC0_DACC0.Byte
#define DAC0_DACC0_DACOE                _DAC0_DACC0.Bits.DACOE
#define DAC0_DACC0_DACWAI               _DAC0_DACC0.Bits.DACWAI
#define DAC0_DACC0_DSGN                 _DAC0_DACC0.Bits.DSGN
#define DAC0_DACC0_DJM                  _DAC0_DACC0.Bits.DJM
#define DAC0_DACC0_DACTE                _DAC0_DACC0.Bits.DACTE
#define DAC0_DACC0_DACE                 _DAC0_DACC0.Bits.DACE

#define DAC0_DACC0_DACOE_MASK           1U
#define DAC0_DACC0_DACWAI_MASK          2U
#define DAC0_DACC0_DSGN_MASK            4U
#define DAC0_DACC0_DJM_MASK             8U
#define DAC0_DACC0_DACTE_MASK           64U
#define DAC0_DACC0_DACE_MASK            128U


/*** DAC0_DACDLeft - DAC0 Data Register - Left Justified; 0x000000F2 ***/
typedef union {
  byte Byte;
  struct {
    byte BIT0        :1;                                       /* Data Bit 0 */
    byte BIT1        :1;                                       /* Data Bit 1 */
    byte BIT2        :1;                                       /* Data Bit 2 */
    byte BIT3        :1;                                       /* Data Bit 3 */
    byte BIT4        :1;                                       /* Data Bit 4 */
    byte BIT5        :1;                                       /* Data Bit 5 */
    byte BIT6        :1;                                       /* Data Bit 6 */
    byte BIT7        :1;                                       /* Data Bit 7 */
  } Bits;
} DAC0_DACDLeftSTR;
extern volatile DAC0_DACDLeftSTR _DAC0_DACDLeft @(REG_BASE + 0x000000F2UL);
#define DAC0_DACDLeft                   _DAC0_DACDLeft.Byte
#define DAC0_DACDLeft_BIT0              _DAC0_DACDLeft.Bits.BIT0
#define DAC0_DACDLeft_BIT1              _DAC0_DACDLeft.Bits.BIT1
#define DAC0_DACDLeft_BIT2              _DAC0_DACDLeft.Bits.BIT2
#define DAC0_DACDLeft_BIT3              _DAC0_DACDLeft.Bits.BIT3
#define DAC0_DACDLeft_BIT4              _DAC0_DACDLeft.Bits.BIT4
#define DAC0_DACDLeft_BIT5              _DAC0_DACDLeft.Bits.BIT5
#define DAC0_DACDLeft_BIT6              _DAC0_DACDLeft.Bits.BIT6
#define DAC0_DACDLeft_BIT7              _DAC0_DACDLeft.Bits.BIT7

#define DAC0_DACDLeft_BIT0_MASK         1U
#define DAC0_DACDLeft_BIT1_MASK         2U
#define DAC0_DACDLeft_BIT2_MASK         4U
#define DAC0_DACDLeft_BIT3_MASK         8U
#define DAC0_DACDLeft_BIT4_MASK         16U
#define DAC0_DACDLeft_BIT5_MASK         32U
#define DAC0_DACDLeft_BIT6_MASK         64U
#define DAC0_DACDLeft_BIT7_MASK         128U


/*** DAC0_DACDRight - DAC0 Data Register - Right Justified; 0x000000F3 ***/
typedef union {
  byte Byte;
  struct {
    byte BIT0        :1;                                       /* Data Bit 0 */
    byte BIT1        :1;                                       /* Data Bit 1 */
    byte BIT2        :1;                                       /* Data Bit 2 */
    byte BIT3        :1;                                       /* Data Bit 3 */
    byte BIT4        :1;                                       /* Data Bit 4 */
    byte BIT5        :1;                                       /* Data Bit 5 */
    byte BIT6        :1;                                       /* Data Bit 6 */
    byte BIT7        :1;                                       /* Data Bit 7 */
  } Bits;
} DAC0_DACDRightSTR;
extern volatile DAC0_DACDRightSTR _DAC0_DACDRight @(REG_BASE + 0x000000F3UL);
#define DAC0_DACDRight                  _DAC0_DACDRight.Byte
#define DAC0_DACDRight_BIT0             _DAC0_DACDRight.Bits.BIT0
#define DAC0_DACDRight_BIT1             _DAC0_DACDRight.Bits.BIT1
#define DAC0_DACDRight_BIT2             _DAC0_DACDRight.Bits.BIT2
#define DAC0_DACDRight_BIT3             _DAC0_DACDRight.Bits.BIT3
#define DAC0_DACDRight_BIT4             _DAC0_DACDRight.Bits.BIT4
#define DAC0_DACDRight_BIT5             _DAC0_DACDRight.Bits.BIT5
#define DAC0_DACDRight_BIT6             _DAC0_DACDRight.Bits.BIT6
#define DAC0_DACDRight_BIT7             _DAC0_DACDRight.Bits.BIT7

#define DAC0_DACDRight_BIT0_MASK        1U
#define DAC0_DACDRight_BIT1_MASK        2U
#define DAC0_DACDRight_BIT2_MASK        4U
#define DAC0_DACDRight_BIT3_MASK        8U
#define DAC0_DACDRight_BIT4_MASK        16U
#define DAC0_DACDRight_BIT5_MASK        32U
#define DAC0_DACDRight_BIT6_MASK        64U
#define DAC0_DACDRight_BIT7_MASK        128U


/*** DAC1_DACC0 - DAC1Control Register 0; 0x000000F4 ***/
typedef union {
  byte Byte;
  struct {
    byte DACOE       :1;                                       /* DAC Output Enable */
    byte DACWAI      :1;                                       /* DAC Stop in WAIT mode */
    byte DSGN        :1;                                       /* Result Register Data Signed or Unsigned Representation */
    byte DJM         :1;                                       /* Data Register Data Justification */
    byte             :1; 
    byte             :1; 
    byte DACTE       :1;                                       /* DAC Test Enable */
    byte DACE        :1;                                       /* DAC Enable */
  } Bits;
} DAC1_DACC0STR;
extern volatile DAC1_DACC0STR _DAC1_DACC0 @(REG_BASE + 0x000000F4UL);
#define DAC1_DACC0                      _DAC1_DACC0.Byte
#define DAC1_DACC0_DACOE                _DAC1_DACC0.Bits.DACOE
#define DAC1_DACC0_DACWAI               _DAC1_DACC0.Bits.DACWAI
#define DAC1_DACC0_DSGN                 _DAC1_DACC0.Bits.DSGN
#define DAC1_DACC0_DJM                  _DAC1_DACC0.Bits.DJM
#define DAC1_DACC0_DACTE                _DAC1_DACC0.Bits.DACTE
#define DAC1_DACC0_DACE                 _DAC1_DACC0.Bits.DACE

#define DAC1_DACC0_DACOE_MASK           1U
#define DAC1_DACC0_DACWAI_MASK          2U
#define DAC1_DACC0_DSGN_MASK            4U
#define DAC1_DACC0_DJM_MASK             8U
#define DAC1_DACC0_DACTE_MASK           64U
#define DAC1_DACC0_DACE_MASK            128U


/*** DAC1_DACDLeft - DAC1 Data Register - Left Justified; 0x000000F6 ***/
typedef union {
  byte Byte;
  struct {
    byte BIT0        :1;                                       /* Data Bit 0 */
    byte BIT1        :1;                                       /* Data Bit 1 */
    byte BIT2        :1;                                       /* Data Bit 2 */
    byte BIT3        :1;                                       /* Data Bit 3 */
    byte BIT4        :1;                                       /* Data Bit 4 */
    byte BIT5        :1;                                       /* Data Bit 5 */
    byte BIT6        :1;                                       /* Data Bit 6 */
    byte BIT7        :1;                                       /* Data Bit 7 */
  } Bits;
} DAC1_DACDLeftSTR;
extern volatile DAC1_DACDLeftSTR _DAC1_DACDLeft @(REG_BASE + 0x000000F6UL);
#define DAC1_DACDLeft                   _DAC1_DACDLeft.Byte
#define DAC1_DACDLeft_BIT0              _DAC1_DACDLeft.Bits.BIT0
#define DAC1_DACDLeft_BIT1              _DAC1_DACDLeft.Bits.BIT1
#define DAC1_DACDLeft_BIT2              _DAC1_DACDLeft.Bits.BIT2
#define DAC1_DACDLeft_BIT3              _DAC1_DACDLeft.Bits.BIT3
#define DAC1_DACDLeft_BIT4              _DAC1_DACDLeft.Bits.BIT4
#define DAC1_DACDLeft_BIT5              _DAC1_DACDLeft.Bits.BIT5
#define DAC1_DACDLeft_BIT6              _DAC1_DACDLeft.Bits.BIT6
#define DAC1_DACDLeft_BIT7              _DAC1_DACDLeft.Bits.BIT7

#define DAC1_DACDLeft_BIT0_MASK         1U
#define DAC1_DACDLeft_BIT1_MASK         2U
#define DAC1_DACDLeft_BIT2_MASK         4U
#define DAC1_DACDLeft_BIT3_MASK         8U
#define DAC1_DACDLeft_BIT4_MASK         16U
#define DAC1_DACDLeft_BIT5_MASK         32U
#define DAC1_DACDLeft_BIT6_MASK         64U
#define DAC1_DACDLeft_BIT7_MASK         128U


/*** DAC1_DACDRight - DAC1 Data Register - Right Justified; 0x000000F7 ***/
typedef union {
  byte Byte;
  struct {
    byte BIT0        :1;                                       /* Data Bit 0 */
    byte BIT1        :1;                                       /* Data Bit 1 */
    byte BIT2        :1;                                       /* Data Bit 2 */
    byte BIT3        :1;                                       /* Data Bit 3 */
    byte BIT4        :1;                                       /* Data Bit 4 */
    byte BIT5        :1;                                       /* Data Bit 5 */
    byte BIT6        :1;                                       /* Data Bit 6 */
    byte BIT7        :1;                                       /* Data Bit 7 */
  } Bits;
} DAC1_DACDRightSTR;
extern volatile DAC1_DACDRightSTR _DAC1_DACDRight @(REG_BASE + 0x000000F7UL);
#define DAC1_DACDRight                  _DAC1_DACDRight.Byte
#define DAC1_DACDRight_BIT0             _DAC1_DACDRight.Bits.BIT0
#define DAC1_DACDRight_BIT1             _DAC1_DACDRight.Bits.BIT1
#define DAC1_DACDRight_BIT2             _DAC1_DACDRight.Bits.BIT2
#define DAC1_DACDRight_BIT3             _DAC1_DACDRight.Bits.BIT3
#define DAC1_DACDRight_BIT4             _DAC1_DACDRight.Bits.BIT4
#define DAC1_DACDRight_BIT5             _DAC1_DACDRight.Bits.BIT5
#define DAC1_DACDRight_BIT6             _DAC1_DACDRight.Bits.BIT6
#define DAC1_DACDRight_BIT7             _DAC1_DACDRight.Bits.BIT7

#define DAC1_DACDRight_BIT0_MASK        1U
#define DAC1_DACDRight_BIT1_MASK        2U
#define DAC1_DACDRight_BIT2_MASK        4U
#define DAC1_DACDRight_BIT3_MASK        8U
#define DAC1_DACDRight_BIT4_MASK        16U
#define DAC1_DACDRight_BIT5_MASK        32U
#define DAC1_DACDRight_BIT6_MASK        64U
#define DAC1_DACDRight_BIT7_MASK        128U


/*** FCLKDIV - Flash Clock Divider Register; 0x00000100 ***/
typedef union {
  byte Byte;
  struct {
    byte FDIV0       :1;                                       /* Flash Clock Divider Bit 0 */
    byte FDIV1       :1;                                       /* Flash Clock Divider Bit 1 */
    byte FDIV2       :1;                                       /* Flash Clock Divider Bit 2 */
    byte FDIV3       :1;                                       /* Flash Clock Divider Bit 3 */
    byte FDIV4       :1;                                       /* Flash Clock Divider Bit 4 */
    byte FDIV5       :1;                                       /* Flash Clock Divider Bit 5 */
    byte PRDIV8      :1;                                       /* Enable Prescaler by 8 */
    byte FDIVLD      :1;                                       /* Flash Clock Divider Loaded */
  } Bits;
  struct {
    byte grpFDIV :6;
    byte grpPRDIV_8 :1;
    byte         :1;
  } MergedBits;
} FCLKDIVSTR;
extern volatile FCLKDIVSTR _FCLKDIV @(REG_BASE + 0x00000100UL);
#define FCLKDIV                         _FCLKDIV.Byte
#define FCLKDIV_FDIV0                   _FCLKDIV.Bits.FDIV0
#define FCLKDIV_FDIV1                   _FCLKDIV.Bits.FDIV1
#define FCLKDIV_FDIV2                   _FCLKDIV.Bits.FDIV2
#define FCLKDIV_FDIV3                   _FCLKDIV.Bits.FDIV3
#define FCLKDIV_FDIV4                   _FCLKDIV.Bits.FDIV4
#define FCLKDIV_FDIV5                   _FCLKDIV.Bits.FDIV5
#define FCLKDIV_PRDIV8                  _FCLKDIV.Bits.PRDIV8
#define FCLKDIV_FDIVLD                  _FCLKDIV.Bits.FDIVLD
#define FCLKDIV_FDIV                    _FCLKDIV.MergedBits.grpFDIV

#define FCLKDIV_FDIV0_MASK              1U
#define FCLKDIV_FDIV1_MASK              2U
#define FCLKDIV_FDIV2_MASK              4U
#define FCLKDIV_FDIV3_MASK              8U
#define FCLKDIV_FDIV4_MASK              16U
#define FCLKDIV_FDIV5_MASK              32U
#define FCLKDIV_PRDIV8_MASK             64U
#define FCLKDIV_FDIVLD_MASK             128U
#define FCLKDIV_FDIV_MASK               63U
#define FCLKDIV_FDIV_BITNUM             0U


/*** FSEC - Flash Security Register; 0x00000101 ***/
typedef union {
  byte Byte;
  struct {
    byte SEC0        :1;                                       /* Memory security bit 0 */
    byte SEC1        :1;                                       /* Memory security bit 1 */
    byte NV2         :1;                                       /* Non Volatile flag bit 2 */
    byte NV3         :1;                                       /* Non Volatile flag bit 3 */
    byte NV4         :1;                                       /* Non Volatile flag bit 4 */
    byte NV5         :1;                                       /* Non Volatile flag bit 5 */
    byte NV6         :1;                                       /* Non Volatile flag bit 6 */
    byte KEYEN       :1;                                       /* Backdoor Key Security Enable */
  } Bits;
  struct {
    byte grpSEC  :2;
    byte grpNV_2 :5;
    byte         :1;
  } MergedBits;
} FSECSTR;
extern volatile FSECSTR _FSEC @(REG_BASE + 0x00000101UL);
#define FSEC                            _FSEC.Byte
#define FSEC_SEC0                       _FSEC.Bits.SEC0
#define FSEC_SEC1                       _FSEC.Bits.SEC1
#define FSEC_NV2                        _FSEC.Bits.NV2
#define FSEC_NV3                        _FSEC.Bits.NV3
#define FSEC_NV4                        _FSEC.Bits.NV4
#define FSEC_NV5                        _FSEC.Bits.NV5
#define FSEC_NV6                        _FSEC.Bits.NV6
#define FSEC_KEYEN                      _FSEC.Bits.KEYEN
#define FSEC_SEC                        _FSEC.MergedBits.grpSEC
#define FSEC_NV_2                       _FSEC.MergedBits.grpNV_2
#define FSEC_NV                         FSEC_NV_2

#define FSEC_SEC0_MASK                  1U
#define FSEC_SEC1_MASK                  2U
#define FSEC_NV2_MASK                   4U
#define FSEC_NV3_MASK                   8U
#define FSEC_NV4_MASK                   16U
#define FSEC_NV5_MASK                   32U
#define FSEC_NV6_MASK                   64U
#define FSEC_KEYEN_MASK                 128U
#define FSEC_SEC_MASK                   3U
#define FSEC_SEC_BITNUM                 0U
#define FSEC_NV_2_MASK                  124U
#define FSEC_NV_2_BITNUM                2U


/*** FCNFG - Flash Configuration Register; 0x00000103 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte KEYACC      :1;                                       /* Enable Security Key Writing */
    byte CCIE        :1;                                       /* Command Complete Interrupt Enable */
    byte CBEIE       :1;                                       /* Command Buffers Empty Interrupt Enable */
  } Bits;
} FCNFGSTR;
extern volatile FCNFGSTR _FCNFG @(REG_BASE + 0x00000103UL);
#define FCNFG                           _FCNFG.Byte
#define FCNFG_KEYACC                    _FCNFG.Bits.KEYACC
#define FCNFG_CCIE                      _FCNFG.Bits.CCIE
#define FCNFG_CBEIE                     _FCNFG.Bits.CBEIE

#define FCNFG_KEYACC_MASK               32U
#define FCNFG_CCIE_MASK                 64U
#define FCNFG_CBEIE_MASK                128U


/*** FPROT - Flash Protection Register; 0x00000104 ***/
typedef union {
  byte Byte;
  struct {
    byte FPLS0       :1;                                       /* Flash Protection Lower Address size 0 */
    byte FPLS1       :1;                                       /* Flash Protection Lower Address size 1 */
    byte FPLDIS      :1;                                       /* Flash Protection Lower address range disable */
    byte FPHS0       :1;                                       /* Flash Protection Higher address size 0 */
    byte FPHS1       :1;                                       /* Flash Protection Higher address size 1 */
    byte FPHDIS      :1;                                       /* Flash Protection Higher address range disable */
    byte NV6         :1;                                       /* Non Volatile Flag Bit */
    byte FPOPEN      :1;                                       /* Opens the flash block or subsections of it for program or erase */
  } Bits;
  struct {
    byte grpFPLS :2;
    byte         :1;
    byte grpFPHS :2;
    byte         :1;
    byte grpNV_6 :1;
    byte         :1;
  } MergedBits;
} FPROTSTR;
extern volatile FPROTSTR _FPROT @(REG_BASE + 0x00000104UL);
#define FPROT                           _FPROT.Byte
#define FPROT_FPLS0                     _FPROT.Bits.FPLS0
#define FPROT_FPLS1                     _FPROT.Bits.FPLS1
#define FPROT_FPLDIS                    _FPROT.Bits.FPLDIS
#define FPROT_FPHS0                     _FPROT.Bits.FPHS0
#define FPROT_FPHS1                     _FPROT.Bits.FPHS1
#define FPROT_FPHDIS                    _FPROT.Bits.FPHDIS
#define FPROT_NV6                       _FPROT.Bits.NV6
#define FPROT_FPOPEN                    _FPROT.Bits.FPOPEN
#define FPROT_FPLS                      _FPROT.MergedBits.grpFPLS
#define FPROT_FPHS                      _FPROT.MergedBits.grpFPHS

#define FPROT_FPLS0_MASK                1U
#define FPROT_FPLS1_MASK                2U
#define FPROT_FPLDIS_MASK               4U
#define FPROT_FPHS0_MASK                8U
#define FPROT_FPHS1_MASK                16U
#define FPROT_FPHDIS_MASK               32U
#define FPROT_NV6_MASK                  64U
#define FPROT_FPOPEN_MASK               128U
#define FPROT_FPLS_MASK                 3U
#define FPROT_FPLS_BITNUM               0U
#define FPROT_FPHS_MASK                 24U
#define FPROT_FPHS_BITNUM               3U


/*** FSTAT - Flash Status Register; 0x00000105 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte BLANK       :1;                                       /* Blank Verify Flag */
    byte             :1; 
    byte ACCERR      :1;                                       /* Access error */
    byte PVIOL       :1;                                       /* Protection violation */
    byte CCIF        :1;                                       /* Command Complete Interrupt Flag */
    byte CBEIF       :1;                                       /* Command Buffers Empty Interrupt Flag */
  } Bits;
} FSTATSTR;
extern volatile FSTATSTR _FSTAT @(REG_BASE + 0x00000105UL);
#define FSTAT                           _FSTAT.Byte
#define FSTAT_BLANK                     _FSTAT.Bits.BLANK
#define FSTAT_ACCERR                    _FSTAT.Bits.ACCERR
#define FSTAT_PVIOL                     _FSTAT.Bits.PVIOL
#define FSTAT_CCIF                      _FSTAT.Bits.CCIF
#define FSTAT_CBEIF                     _FSTAT.Bits.CBEIF

#define FSTAT_BLANK_MASK                4U
#define FSTAT_ACCERR_MASK               16U
#define FSTAT_PVIOL_MASK                32U
#define FSTAT_CCIF_MASK                 64U
#define FSTAT_CBEIF_MASK                128U


/*** FCMD - Flash Command Buffer and Register; 0x00000106 ***/
typedef union {
  byte Byte;
  struct {
    byte CMDB0       :1;                                       /* NVM User Mode Command Bit 0 */
    byte             :1; 
    byte CMDB2       :1;                                       /* NVM User Mode Command Bit 2 */
    byte             :1; 
    byte             :1; 
    byte CMDB5       :1;                                       /* NVM User Mode Command Bit 5 */
    byte CMDB6       :1;                                       /* NVM User Mode Command Bit 6 */
    byte             :1; 
  } Bits;
  struct {
    byte grpCMDB :1;
    byte         :1;
    byte grpCMDB_2 :1;
    byte         :1;
    byte         :1;
    byte grpCMDB_5 :2;
    byte         :1;
  } MergedBits;
} FCMDSTR;
extern volatile FCMDSTR _FCMD @(REG_BASE + 0x00000106UL);
#define FCMD                            _FCMD.Byte
#define FCMD_CMDB0                      _FCMD.Bits.CMDB0
#define FCMD_CMDB2                      _FCMD.Bits.CMDB2
#define FCMD_CMDB5                      _FCMD.Bits.CMDB5
#define FCMD_CMDB6                      _FCMD.Bits.CMDB6
#define FCMD_CMDB_5                     _FCMD.MergedBits.grpCMDB_5
#define FCMD_CMDB                       FCMD_CMDB_5

#define FCMD_CMDB0_MASK                 1U
#define FCMD_CMDB2_MASK                 4U
#define FCMD_CMDB5_MASK                 32U
#define FCMD_CMDB6_MASK                 64U
#define FCMD_CMDB_5_MASK                96U
#define FCMD_CMDB_5_BITNUM              5U


/*** TIM1_TIOS - TIM1 Timer Input Capture/Output Compare Select; 0x00000140 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte IOS4        :1;                                       /* Input Capture or Output Compare Channel Configuration Bit 4 */
    byte IOS5        :1;                                       /* Input Capture or Output Compare Channel Configuration Bit 5 */
    byte IOS6        :1;                                       /* Input Capture or Output Compare Channel Configuration Bit 6 */
    byte IOS7        :1;                                       /* Input Capture or Output Compare Channel Configuration Bit 7 */
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte grpIOS_4 :4;
  } MergedBits;
} TIM1_TIOSSTR;
extern volatile TIM1_TIOSSTR _TIM1_TIOS @(REG_BASE + 0x00000140UL);
#define TIM1_TIOS                       _TIM1_TIOS.Byte
#define TIM1_TIOS_IOS4                  _TIM1_TIOS.Bits.IOS4
#define TIM1_TIOS_IOS5                  _TIM1_TIOS.Bits.IOS5
#define TIM1_TIOS_IOS6                  _TIM1_TIOS.Bits.IOS6
#define TIM1_TIOS_IOS7                  _TIM1_TIOS.Bits.IOS7
#define TIM1_TIOS_IOS_4                 _TIM1_TIOS.MergedBits.grpIOS_4
#define TIM1_TIOS_IOS                   TIM1_TIOS_IOS_4

#define TIM1_TIOS_IOS4_MASK             16U
#define TIM1_TIOS_IOS5_MASK             32U
#define TIM1_TIOS_IOS6_MASK             64U
#define TIM1_TIOS_IOS7_MASK             128U
#define TIM1_TIOS_IOS_4_MASK            240U
#define TIM1_TIOS_IOS_4_BITNUM          4U


/*** TIM1_CFORC - TIM1 Timer Compare Force Register; 0x00000141 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte FOC4        :1;                                       /* Force Output Compare Action for Channel 4 */
    byte FOC5        :1;                                       /* Force Output Compare Action for Channel 5 */
    byte FOC6        :1;                                       /* Force Output Compare Action for Channel 6 */
    byte FOC7        :1;                                       /* Force Output Compare Action for Channel 7 */
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte grpFOC_4 :4;
  } MergedBits;
} TIM1_CFORCSTR;
extern volatile TIM1_CFORCSTR _TIM1_CFORC @(REG_BASE + 0x00000141UL);
#define TIM1_CFORC                      _TIM1_CFORC.Byte
#define TIM1_CFORC_FOC4                 _TIM1_CFORC.Bits.FOC4
#define TIM1_CFORC_FOC5                 _TIM1_CFORC.Bits.FOC5
#define TIM1_CFORC_FOC6                 _TIM1_CFORC.Bits.FOC6
#define TIM1_CFORC_FOC7                 _TIM1_CFORC.Bits.FOC7
#define TIM1_CFORC_FOC_4                _TIM1_CFORC.MergedBits.grpFOC_4
#define TIM1_CFORC_FOC                  TIM1_CFORC_FOC_4

#define TIM1_CFORC_FOC4_MASK            16U
#define TIM1_CFORC_FOC5_MASK            32U
#define TIM1_CFORC_FOC6_MASK            64U
#define TIM1_CFORC_FOC7_MASK            128U
#define TIM1_CFORC_FOC_4_MASK           240U
#define TIM1_CFORC_FOC_4_BITNUM         4U


/*** TIM1_OC7M - TIM1 Output Compare 7 Mask Register; 0x00000142 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte OC7M4       :1;                                       /* Output Compare 7 Mask Bit 4 */
    byte OC7M5       :1;                                       /* Output Compare 7 Mask Bit 5 */
    byte OC7M6       :1;                                       /* Output Compare 7 Mask Bit 6 */
    byte OC7M7       :1;                                       /* Output Compare 7 Mask Bit 7 */
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte grpOC7M_4 :4;
  } MergedBits;
} TIM1_OC7MSTR;
extern volatile TIM1_OC7MSTR _TIM1_OC7M @(REG_BASE + 0x00000142UL);
#define TIM1_OC7M                       _TIM1_OC7M.Byte
#define TIM1_OC7M_OC7M4                 _TIM1_OC7M.Bits.OC7M4
#define TIM1_OC7M_OC7M5                 _TIM1_OC7M.Bits.OC7M5
#define TIM1_OC7M_OC7M6                 _TIM1_OC7M.Bits.OC7M6
#define TIM1_OC7M_OC7M7                 _TIM1_OC7M.Bits.OC7M7
#define TIM1_OC7M_OC7M_4                _TIM1_OC7M.MergedBits.grpOC7M_4
#define TIM1_OC7M_OC7M                  TIM1_OC7M_OC7M_4

#define TIM1_OC7M_OC7M4_MASK            16U
#define TIM1_OC7M_OC7M5_MASK            32U
#define TIM1_OC7M_OC7M6_MASK            64U
#define TIM1_OC7M_OC7M7_MASK            128U
#define TIM1_OC7M_OC7M_4_MASK           240U
#define TIM1_OC7M_OC7M_4_BITNUM         4U


/*** TIM1_OC7D - TIM1 Output Compare 7 Data Register; 0x00000143 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte OC7D4       :1;                                       /* Output Compare 7 Bit 4 */
    byte OC7D5       :1;                                       /* Output Compare 7 Bit 5 */
    byte OC7D6       :1;                                       /* Output Compare 7 Bit 6 */
    byte OC7D7       :1;                                       /* Output Compare 7 Bit 7 */
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte grpOC7D_4 :4;
  } MergedBits;
} TIM1_OC7DSTR;
extern volatile TIM1_OC7DSTR _TIM1_OC7D @(REG_BASE + 0x00000143UL);
#define TIM1_OC7D                       _TIM1_OC7D.Byte
#define TIM1_OC7D_OC7D4                 _TIM1_OC7D.Bits.OC7D4
#define TIM1_OC7D_OC7D5                 _TIM1_OC7D.Bits.OC7D5
#define TIM1_OC7D_OC7D6                 _TIM1_OC7D.Bits.OC7D6
#define TIM1_OC7D_OC7D7                 _TIM1_OC7D.Bits.OC7D7
#define TIM1_OC7D_OC7D_4                _TIM1_OC7D.MergedBits.grpOC7D_4
#define TIM1_OC7D_OC7D                  TIM1_OC7D_OC7D_4

#define TIM1_OC7D_OC7D4_MASK            16U
#define TIM1_OC7D_OC7D5_MASK            32U
#define TIM1_OC7D_OC7D6_MASK            64U
#define TIM1_OC7D_OC7D7_MASK            128U
#define TIM1_OC7D_OC7D_4_MASK           240U
#define TIM1_OC7D_OC7D_4_BITNUM         4U


/*** TIM1_TCNT - TIM1 Timer Count Register; 0x00000144 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** TIM1_TCNTHi - TIM1 Timer Count Register High; 0x00000144 ***/
    union {
      byte Byte;
    } TIM1_TCNTHiSTR;
    #define TIM1_TCNTHi                 _TIM1_TCNT.Overlap_STR.TIM1_TCNTHiSTR.Byte
    

    /*** TIM1_TCNTLo - TIM1 Timer Count Register Low; 0x00000145 ***/
    union {
      byte Byte;
    } TIM1_TCNTLoSTR;
    #define TIM1_TCNTLo                 _TIM1_TCNT.Overlap_STR.TIM1_TCNTLoSTR.Byte
    
  } Overlap_STR;

} TIM1_TCNTSTR;
extern volatile TIM1_TCNTSTR _TIM1_TCNT @(REG_BASE + 0x00000144UL);
#define TIM1_TCNT                       _TIM1_TCNT.Word


/*** TIM1_TSCR1 - TIM1 Timer System Control Register1; 0x00000146 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte TFFCA       :1;                                       /* Timer Fast Flag Clear All */
    byte TSFRZ       :1;                                       /* Timer and Modulus Counter Stop While in Freeze Mode */
    byte TSWAI       :1;                                       /* Timer Module Stops While in Wait */
    byte TEN         :1;                                       /* Timer Enable */
  } Bits;
} TIM1_TSCR1STR;
extern volatile TIM1_TSCR1STR _TIM1_TSCR1 @(REG_BASE + 0x00000146UL);
#define TIM1_TSCR1                      _TIM1_TSCR1.Byte
#define TIM1_TSCR1_TFFCA                _TIM1_TSCR1.Bits.TFFCA
#define TIM1_TSCR1_TSFRZ                _TIM1_TSCR1.Bits.TSFRZ
#define TIM1_TSCR1_TSWAI                _TIM1_TSCR1.Bits.TSWAI
#define TIM1_TSCR1_TEN                  _TIM1_TSCR1.Bits.TEN

#define TIM1_TSCR1_TFFCA_MASK           16U
#define TIM1_TSCR1_TSFRZ_MASK           32U
#define TIM1_TSCR1_TSWAI_MASK           64U
#define TIM1_TSCR1_TEN_MASK             128U


/*** TIM1_TTOV - TIM1 Timer Toggle On Overflow Register; 0x00000147 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte TOV4        :1;                                       /* Toggle On Overflow Bit 4 */
    byte TOV5        :1;                                       /* Toggle On Overflow Bit 5 */
    byte TOV6        :1;                                       /* Toggle On Overflow Bit 6 */
    byte TOV7        :1;                                       /* Toggle On Overflow Bit 7 */
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte grpTOV_4 :4;
  } MergedBits;
} TIM1_TTOVSTR;
extern volatile TIM1_TTOVSTR _TIM1_TTOV @(REG_BASE + 0x00000147UL);
#define TIM1_TTOV                       _TIM1_TTOV.Byte
#define TIM1_TTOV_TOV4                  _TIM1_TTOV.Bits.TOV4
#define TIM1_TTOV_TOV5                  _TIM1_TTOV.Bits.TOV5
#define TIM1_TTOV_TOV6                  _TIM1_TTOV.Bits.TOV6
#define TIM1_TTOV_TOV7                  _TIM1_TTOV.Bits.TOV7
#define TIM1_TTOV_TOV_4                 _TIM1_TTOV.MergedBits.grpTOV_4
#define TIM1_TTOV_TOV                   TIM1_TTOV_TOV_4

#define TIM1_TTOV_TOV4_MASK             16U
#define TIM1_TTOV_TOV5_MASK             32U
#define TIM1_TTOV_TOV6_MASK             64U
#define TIM1_TTOV_TOV7_MASK             128U
#define TIM1_TTOV_TOV_4_MASK            240U
#define TIM1_TTOV_TOV_4_BITNUM          4U


/*** TIM1_TCTL1 - TIM1 Timer Control Register 1; 0x00000148 ***/
typedef union {
  byte Byte;
  struct {
    byte OL4         :1;                                       /* Output Level Bit 4 */
    byte OM4         :1;                                       /* Output Mode Bit 4 */
    byte OL5         :1;                                       /* Output Level Bit 5 */
    byte OM5         :1;                                       /* Output Mode Bit 5 */
    byte OL6         :1;                                       /* Output Level Bit 6 */
    byte OM6         :1;                                       /* Output Mode Bit 6 */
    byte OL7         :1;                                       /* Output Level Bit 7 */
    byte OM7         :1;                                       /* Output Mode Bit 7 */
  } Bits;
} TIM1_TCTL1STR;
extern volatile TIM1_TCTL1STR _TIM1_TCTL1 @(REG_BASE + 0x00000148UL);
#define TIM1_TCTL1                      _TIM1_TCTL1.Byte
#define TIM1_TCTL1_OL4                  _TIM1_TCTL1.Bits.OL4
#define TIM1_TCTL1_OM4                  _TIM1_TCTL1.Bits.OM4
#define TIM1_TCTL1_OL5                  _TIM1_TCTL1.Bits.OL5
#define TIM1_TCTL1_OM5                  _TIM1_TCTL1.Bits.OM5
#define TIM1_TCTL1_OL6                  _TIM1_TCTL1.Bits.OL6
#define TIM1_TCTL1_OM6                  _TIM1_TCTL1.Bits.OM6
#define TIM1_TCTL1_OL7                  _TIM1_TCTL1.Bits.OL7
#define TIM1_TCTL1_OM7                  _TIM1_TCTL1.Bits.OM7

#define TIM1_TCTL1_OL4_MASK             1U
#define TIM1_TCTL1_OM4_MASK             2U
#define TIM1_TCTL1_OL5_MASK             4U
#define TIM1_TCTL1_OM5_MASK             8U
#define TIM1_TCTL1_OL6_MASK             16U
#define TIM1_TCTL1_OM6_MASK             32U
#define TIM1_TCTL1_OL7_MASK             64U
#define TIM1_TCTL1_OM7_MASK             128U


/*** TIM1_TCTL3 - TIM1 Timer Control Register 3; 0x0000014A ***/
typedef union {
  byte Byte;
  struct {
    byte EDG4A       :1;                                       /* Input Capture Edge Control 4A */
    byte EDG4B       :1;                                       /* Input Capture Edge Control 4B */
    byte EDG5A       :1;                                       /* Input Capture Edge Control 5A */
    byte EDG5B       :1;                                       /* Input Capture Edge Control 5B */
    byte EDG6A       :1;                                       /* Input Capture Edge Control 6A */
    byte EDG6B       :1;                                       /* Input Capture Edge Control 6B */
    byte EDG7A       :1;                                       /* Input Capture Edge Control 7A */
    byte EDG7B       :1;                                       /* Input Capture Edge Control 7B */
  } Bits;
  struct {
    byte grpEDG4x :2;
    byte grpEDG5x :2;
    byte grpEDG6x :2;
    byte grpEDG7x :2;
  } MergedBits;
} TIM1_TCTL3STR;
extern volatile TIM1_TCTL3STR _TIM1_TCTL3 @(REG_BASE + 0x0000014AUL);
#define TIM1_TCTL3                      _TIM1_TCTL3.Byte
#define TIM1_TCTL3_EDG4A                _TIM1_TCTL3.Bits.EDG4A
#define TIM1_TCTL3_EDG4B                _TIM1_TCTL3.Bits.EDG4B
#define TIM1_TCTL3_EDG5A                _TIM1_TCTL3.Bits.EDG5A
#define TIM1_TCTL3_EDG5B                _TIM1_TCTL3.Bits.EDG5B
#define TIM1_TCTL3_EDG6A                _TIM1_TCTL3.Bits.EDG6A
#define TIM1_TCTL3_EDG6B                _TIM1_TCTL3.Bits.EDG6B
#define TIM1_TCTL3_EDG7A                _TIM1_TCTL3.Bits.EDG7A
#define TIM1_TCTL3_EDG7B                _TIM1_TCTL3.Bits.EDG7B
#define TIM1_TCTL3_EDG4x                _TIM1_TCTL3.MergedBits.grpEDG4x
#define TIM1_TCTL3_EDG5x                _TIM1_TCTL3.MergedBits.grpEDG5x
#define TIM1_TCTL3_EDG6x                _TIM1_TCTL3.MergedBits.grpEDG6x
#define TIM1_TCTL3_EDG7x                _TIM1_TCTL3.MergedBits.grpEDG7x

#define TIM1_TCTL3_EDG4A_MASK           1U
#define TIM1_TCTL3_EDG4B_MASK           2U
#define TIM1_TCTL3_EDG5A_MASK           4U
#define TIM1_TCTL3_EDG5B_MASK           8U
#define TIM1_TCTL3_EDG6A_MASK           16U
#define TIM1_TCTL3_EDG6B_MASK           32U
#define TIM1_TCTL3_EDG7A_MASK           64U
#define TIM1_TCTL3_EDG7B_MASK           128U
#define TIM1_TCTL3_EDG4x_MASK           3U
#define TIM1_TCTL3_EDG4x_BITNUM         0U
#define TIM1_TCTL3_EDG5x_MASK           12U
#define TIM1_TCTL3_EDG5x_BITNUM         2U
#define TIM1_TCTL3_EDG6x_MASK           48U
#define TIM1_TCTL3_EDG6x_BITNUM         4U
#define TIM1_TCTL3_EDG7x_MASK           192U
#define TIM1_TCTL3_EDG7x_BITNUM         6U


/*** TIM1_TIE - TIM1 Timer Interrupt Enable Register; 0x0000014C ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte C4I         :1;                                       /* Input Capture/Output Compare Interrupt Enable Bit 4 */
    byte C5I         :1;                                       /* Input Capture/Output Compare Interrupt Enable Bit 5 */
    byte C6I         :1;                                       /* Input Capture/Output Compare Interrupt Enable Bit 6 */
    byte C7I         :1;                                       /* Input Capture/Output Compare Interrupt Enable Bit 7 */
  } Bits;
} TIM1_TIESTR;
extern volatile TIM1_TIESTR _TIM1_TIE @(REG_BASE + 0x0000014CUL);
#define TIM1_TIE                        _TIM1_TIE.Byte
#define TIM1_TIE_C4I                    _TIM1_TIE.Bits.C4I
#define TIM1_TIE_C5I                    _TIM1_TIE.Bits.C5I
#define TIM1_TIE_C6I                    _TIM1_TIE.Bits.C6I
#define TIM1_TIE_C7I                    _TIM1_TIE.Bits.C7I

#define TIM1_TIE_C4I_MASK               16U
#define TIM1_TIE_C5I_MASK               32U
#define TIM1_TIE_C6I_MASK               64U
#define TIM1_TIE_C7I_MASK               128U


/*** TIM1_TSCR2 - TIM1 Timer System Control Register 2; 0x0000014D ***/
typedef union {
  byte Byte;
  struct {
    byte PR0         :1;                                       /* Timer Prescaler Select Bit 0 */
    byte PR1         :1;                                       /* Timer Prescaler Select Bit 1 */
    byte PR2         :1;                                       /* Timer Prescaler Select Bit 2 */
    byte TCRE        :1;                                       /* Timer Counter Reset Enable */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte TOI         :1;                                       /* Timer Overflow Interrupt Enable */
  } Bits;
  struct {
    byte grpPR   :3;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} TIM1_TSCR2STR;
extern volatile TIM1_TSCR2STR _TIM1_TSCR2 @(REG_BASE + 0x0000014DUL);
#define TIM1_TSCR2                      _TIM1_TSCR2.Byte
#define TIM1_TSCR2_PR0                  _TIM1_TSCR2.Bits.PR0
#define TIM1_TSCR2_PR1                  _TIM1_TSCR2.Bits.PR1
#define TIM1_TSCR2_PR2                  _TIM1_TSCR2.Bits.PR2
#define TIM1_TSCR2_TCRE                 _TIM1_TSCR2.Bits.TCRE
#define TIM1_TSCR2_TOI                  _TIM1_TSCR2.Bits.TOI
#define TIM1_TSCR2_PR                   _TIM1_TSCR2.MergedBits.grpPR

#define TIM1_TSCR2_PR0_MASK             1U
#define TIM1_TSCR2_PR1_MASK             2U
#define TIM1_TSCR2_PR2_MASK             4U
#define TIM1_TSCR2_TCRE_MASK            8U
#define TIM1_TSCR2_TOI_MASK             128U
#define TIM1_TSCR2_PR_MASK              7U
#define TIM1_TSCR2_PR_BITNUM            0U


/*** TIM1_TFLG1 - TIM1 Main Timer Interrupt Flag 1; 0x0000014E ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte C4F         :1;                                       /* Input Capture/Output Compare Channel Flag 4 */
    byte C5F         :1;                                       /* Input Capture/Output Compare Channel Flag 5 */
    byte C6F         :1;                                       /* Input Capture/Output Compare Channel Flag 6 */
    byte C7F         :1;                                       /* Input Capture/Output Compare Channel Flag 7 */
  } Bits;
} TIM1_TFLG1STR;
extern volatile TIM1_TFLG1STR _TIM1_TFLG1 @(REG_BASE + 0x0000014EUL);
#define TIM1_TFLG1                      _TIM1_TFLG1.Byte
#define TIM1_TFLG1_C4F                  _TIM1_TFLG1.Bits.C4F
#define TIM1_TFLG1_C5F                  _TIM1_TFLG1.Bits.C5F
#define TIM1_TFLG1_C6F                  _TIM1_TFLG1.Bits.C6F
#define TIM1_TFLG1_C7F                  _TIM1_TFLG1.Bits.C7F

#define TIM1_TFLG1_C4F_MASK             16U
#define TIM1_TFLG1_C5F_MASK             32U
#define TIM1_TFLG1_C6F_MASK             64U
#define TIM1_TFLG1_C7F_MASK             128U


/*** TIM1_TFLG2 - TIM1 Main Timer Interrupt Flag 2; 0x0000014F ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte TOF         :1;                                       /* Timer Overflow Flag */
  } Bits;
} TIM1_TFLG2STR;
extern volatile TIM1_TFLG2STR _TIM1_TFLG2 @(REG_BASE + 0x0000014FUL);
#define TIM1_TFLG2                      _TIM1_TFLG2.Byte
#define TIM1_TFLG2_TOF                  _TIM1_TFLG2.Bits.TOF

#define TIM1_TFLG2_TOF_MASK             128U


/*** TIM1_TC4 - TIM1 Timer Input Capture/Output Compare Register 4; 0x00000158 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** TIM1_TC4Hi - TIM1 Timer Input Capture/Output Compare Register 4 High; 0x00000158 ***/
    union {
      byte Byte;
    } TIM1_TC4HiSTR;
    #define TIM1_TC4Hi                  _TIM1_TC4.Overlap_STR.TIM1_TC4HiSTR.Byte
    

    /*** TIM1_TC4Lo - TIM1 Timer Input Capture/Output Compare Register 4 Low; 0x00000159 ***/
    union {
      byte Byte;
    } TIM1_TC4LoSTR;
    #define TIM1_TC4Lo                  _TIM1_TC4.Overlap_STR.TIM1_TC4LoSTR.Byte
    
  } Overlap_STR;

} TIM1_TC4STR;
extern volatile TIM1_TC4STR _TIM1_TC4 @(REG_BASE + 0x00000158UL);
#define TIM1_TC4                        _TIM1_TC4.Word


/*** TIM1_TC5 - TIM1 Timer Input Capture/Output Compare Register 5; 0x0000015A ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** TIM1_TC5Hi - TIM1 Timer Input Capture/Output Compare Register 5 High; 0x0000015A ***/
    union {
      byte Byte;
    } TIM1_TC5HiSTR;
    #define TIM1_TC5Hi                  _TIM1_TC5.Overlap_STR.TIM1_TC5HiSTR.Byte
    

    /*** TIM1_TC5Lo - TIM1 Timer Input Capture/Output Compare Register 5 Low; 0x0000015B ***/
    union {
      byte Byte;
    } TIM1_TC5LoSTR;
    #define TIM1_TC5Lo                  _TIM1_TC5.Overlap_STR.TIM1_TC5LoSTR.Byte
    
  } Overlap_STR;

} TIM1_TC5STR;
extern volatile TIM1_TC5STR _TIM1_TC5 @(REG_BASE + 0x0000015AUL);
#define TIM1_TC5                        _TIM1_TC5.Word


/*** TIM1_TC6 - TIM1 Timer Input Capture/Output Compare Register 6; 0x0000015C ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** TIM1_TC6Hi - TIM1 Timer Input Capture/Output Compare Register 6 High; 0x0000015C ***/
    union {
      byte Byte;
    } TIM1_TC6HiSTR;
    #define TIM1_TC6Hi                  _TIM1_TC6.Overlap_STR.TIM1_TC6HiSTR.Byte
    

    /*** TIM1_TC6Lo - TIM1 Timer Input Capture/Output Compare Register 6 Low; 0x0000015D ***/
    union {
      byte Byte;
    } TIM1_TC6LoSTR;
    #define TIM1_TC6Lo                  _TIM1_TC6.Overlap_STR.TIM1_TC6LoSTR.Byte
    
  } Overlap_STR;

} TIM1_TC6STR;
extern volatile TIM1_TC6STR _TIM1_TC6 @(REG_BASE + 0x0000015CUL);
#define TIM1_TC6                        _TIM1_TC6.Word


/*** TIM1_TC7 - TIM1 Timer Input Capture/Output Compare Register 7; 0x0000015E ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** TIM1_TC7Hi - TIM1 Timer Input Capture/Output Compare Register 7 High; 0x0000015E ***/
    union {
      byte Byte;
    } TIM1_TC7HiSTR;
    #define TIM1_TC7Hi                  _TIM1_TC7.Overlap_STR.TIM1_TC7HiSTR.Byte
    

    /*** TIM1_TC7Lo - TIM1 Timer Input Capture/Output Compare Register 7 Low; 0x0000015F ***/
    union {
      byte Byte;
    } TIM1_TC7LoSTR;
    #define TIM1_TC7Lo                  _TIM1_TC7.Overlap_STR.TIM1_TC7LoSTR.Byte
    
  } Overlap_STR;

} TIM1_TC7STR;
extern volatile TIM1_TC7STR _TIM1_TC7 @(REG_BASE + 0x0000015EUL);
#define TIM1_TC7                        _TIM1_TC7.Word


/*** TIM1_PACTL - TIM1 16-Bit Pulse Accumulator A Control Register; 0x00000160 ***/
typedef union {
  byte Byte;
  struct {
    byte PAI         :1;                                       /* Pulse Accumulator Input Interrupt enable */
    byte PAOVI       :1;                                       /* Pulse Accumulator A Overflow Interrupt enable */
    byte CLK0        :1;                                       /* Clock Select Bit 0 */
    byte CLK1        :1;                                       /* Clock Select Bit 1 */
    byte PEDGE       :1;                                       /* Pulse Accumulator Edge Control */
    byte PAMOD       :1;                                       /* Pulse Accumulator Mode */
    byte PAEN        :1;                                       /* Pulse Accumulator A System Enable */
    byte             :1; 
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte grpCLK  :2;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} TIM1_PACTLSTR;
extern volatile TIM1_PACTLSTR _TIM1_PACTL @(REG_BASE + 0x00000160UL);
#define TIM1_PACTL                      _TIM1_PACTL.Byte
#define TIM1_PACTL_PAI                  _TIM1_PACTL.Bits.PAI
#define TIM1_PACTL_PAOVI                _TIM1_PACTL.Bits.PAOVI
#define TIM1_PACTL_CLK0                 _TIM1_PACTL.Bits.CLK0
#define TIM1_PACTL_CLK1                 _TIM1_PACTL.Bits.CLK1
#define TIM1_PACTL_PEDGE                _TIM1_PACTL.Bits.PEDGE
#define TIM1_PACTL_PAMOD                _TIM1_PACTL.Bits.PAMOD
#define TIM1_PACTL_PAEN                 _TIM1_PACTL.Bits.PAEN
#define TIM1_PACTL_CLK                  _TIM1_PACTL.MergedBits.grpCLK

#define TIM1_PACTL_PAI_MASK             1U
#define TIM1_PACTL_PAOVI_MASK           2U
#define TIM1_PACTL_CLK0_MASK            4U
#define TIM1_PACTL_CLK1_MASK            8U
#define TIM1_PACTL_PEDGE_MASK           16U
#define TIM1_PACTL_PAMOD_MASK           32U
#define TIM1_PACTL_PAEN_MASK            64U
#define TIM1_PACTL_CLK_MASK             12U
#define TIM1_PACTL_CLK_BITNUM           2U


/*** TIM1_PAFLG - TIM1 Pulse Accumulator A Flag Register; 0x00000161 ***/
typedef union {
  byte Byte;
  struct {
    byte PAIF        :1;                                       /* Pulse Accumulator Input edge Flag */
    byte PAOVF       :1;                                       /* Pulse Accumulator A Overflow Flag */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} TIM1_PAFLGSTR;
extern volatile TIM1_PAFLGSTR _TIM1_PAFLG @(REG_BASE + 0x00000161UL);
#define TIM1_PAFLG                      _TIM1_PAFLG.Byte
#define TIM1_PAFLG_PAIF                 _TIM1_PAFLG.Bits.PAIF
#define TIM1_PAFLG_PAOVF                _TIM1_PAFLG.Bits.PAOVF

#define TIM1_PAFLG_PAIF_MASK            1U
#define TIM1_PAFLG_PAOVF_MASK           2U


/*** TIM1_PACNT - TIM1 Pulse Accumulators Count Register; 0x00000162 ***/
typedef union {
  word Word;
} TIM1_PACNTSTR;
extern volatile TIM1_PACNTSTR _TIM1_PACNT @(REG_BASE + 0x00000162UL);
#define TIM1_PACNT                      _TIM1_PACNT.Word


/*** TIM2_TIOS - TIM2 Timer Input Capture/Output Compare Select; 0x00000180 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte IOS4        :1;                                       /* Input Capture or Output Compare Channel Configuration Bit 4 */
    byte IOS5        :1;                                       /* Input Capture or Output Compare Channel Configuration Bit 5 */
    byte IOS6        :1;                                       /* Input Capture or Output Compare Channel Configuration Bit 6 */
    byte IOS7        :1;                                       /* Input Capture or Output Compare Channel Configuration Bit 7 */
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte grpIOS_4 :4;
  } MergedBits;
} TIM2_TIOSSTR;
extern volatile TIM2_TIOSSTR _TIM2_TIOS @(REG_BASE + 0x00000180UL);
#define TIM2_TIOS                       _TIM2_TIOS.Byte
#define TIM2_TIOS_IOS4                  _TIM2_TIOS.Bits.IOS4
#define TIM2_TIOS_IOS5                  _TIM2_TIOS.Bits.IOS5
#define TIM2_TIOS_IOS6                  _TIM2_TIOS.Bits.IOS6
#define TIM2_TIOS_IOS7                  _TIM2_TIOS.Bits.IOS7
#define TIM2_TIOS_IOS_4                 _TIM2_TIOS.MergedBits.grpIOS_4
#define TIM2_TIOS_IOS                   TIM2_TIOS_IOS_4

#define TIM2_TIOS_IOS4_MASK             16U
#define TIM2_TIOS_IOS5_MASK             32U
#define TIM2_TIOS_IOS6_MASK             64U
#define TIM2_TIOS_IOS7_MASK             128U
#define TIM2_TIOS_IOS_4_MASK            240U
#define TIM2_TIOS_IOS_4_BITNUM          4U


/*** TIM2_CFORC - TIM2 Timer Compare Force Register; 0x00000181 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte FOC4        :1;                                       /* Force Output Compare Action for Channel 4 */
    byte FOC5        :1;                                       /* Force Output Compare Action for Channel 5 */
    byte FOC6        :1;                                       /* Force Output Compare Action for Channel 6 */
    byte FOC7        :1;                                       /* Force Output Compare Action for Channel 7 */
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte grpFOC_4 :4;
  } MergedBits;
} TIM2_CFORCSTR;
extern volatile TIM2_CFORCSTR _TIM2_CFORC @(REG_BASE + 0x00000181UL);
#define TIM2_CFORC                      _TIM2_CFORC.Byte
#define TIM2_CFORC_FOC4                 _TIM2_CFORC.Bits.FOC4
#define TIM2_CFORC_FOC5                 _TIM2_CFORC.Bits.FOC5
#define TIM2_CFORC_FOC6                 _TIM2_CFORC.Bits.FOC6
#define TIM2_CFORC_FOC7                 _TIM2_CFORC.Bits.FOC7
#define TIM2_CFORC_FOC_4                _TIM2_CFORC.MergedBits.grpFOC_4
#define TIM2_CFORC_FOC                  TIM2_CFORC_FOC_4

#define TIM2_CFORC_FOC4_MASK            16U
#define TIM2_CFORC_FOC5_MASK            32U
#define TIM2_CFORC_FOC6_MASK            64U
#define TIM2_CFORC_FOC7_MASK            128U
#define TIM2_CFORC_FOC_4_MASK           240U
#define TIM2_CFORC_FOC_4_BITNUM         4U


/*** TIM2_OC7M - TIM2 Output Compare 7 Mask Register; 0x00000182 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte OC7M4       :1;                                       /* Output Compare 7 Mask Bit 4 */
    byte OC7M5       :1;                                       /* Output Compare 7 Mask Bit 5 */
    byte OC7M6       :1;                                       /* Output Compare 7 Mask Bit 6 */
    byte OC7M7       :1;                                       /* Output Compare 7 Mask Bit 7 */
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte grpOC7M_4 :4;
  } MergedBits;
} TIM2_OC7MSTR;
extern volatile TIM2_OC7MSTR _TIM2_OC7M @(REG_BASE + 0x00000182UL);
#define TIM2_OC7M                       _TIM2_OC7M.Byte
#define TIM2_OC7M_OC7M4                 _TIM2_OC7M.Bits.OC7M4
#define TIM2_OC7M_OC7M5                 _TIM2_OC7M.Bits.OC7M5
#define TIM2_OC7M_OC7M6                 _TIM2_OC7M.Bits.OC7M6
#define TIM2_OC7M_OC7M7                 _TIM2_OC7M.Bits.OC7M7
#define TIM2_OC7M_OC7M_4                _TIM2_OC7M.MergedBits.grpOC7M_4
#define TIM2_OC7M_OC7M                  TIM2_OC7M_OC7M_4

#define TIM2_OC7M_OC7M4_MASK            16U
#define TIM2_OC7M_OC7M5_MASK            32U
#define TIM2_OC7M_OC7M6_MASK            64U
#define TIM2_OC7M_OC7M7_MASK            128U
#define TIM2_OC7M_OC7M_4_MASK           240U
#define TIM2_OC7M_OC7M_4_BITNUM         4U


/*** TIM2_OC7D - TIM2 Output Compare 7 Data Register; 0x00000183 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte OC7D4       :1;                                       /* Output Compare 7 Bit 4 */
    byte OC7D5       :1;                                       /* Output Compare 7 Bit 5 */
    byte OC7D6       :1;                                       /* Output Compare 7 Bit 6 */
    byte OC7D7       :1;                                       /* Output Compare 7 Bit 7 */
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte grpOC7D_4 :4;
  } MergedBits;
} TIM2_OC7DSTR;
extern volatile TIM2_OC7DSTR _TIM2_OC7D @(REG_BASE + 0x00000183UL);
#define TIM2_OC7D                       _TIM2_OC7D.Byte
#define TIM2_OC7D_OC7D4                 _TIM2_OC7D.Bits.OC7D4
#define TIM2_OC7D_OC7D5                 _TIM2_OC7D.Bits.OC7D5
#define TIM2_OC7D_OC7D6                 _TIM2_OC7D.Bits.OC7D6
#define TIM2_OC7D_OC7D7                 _TIM2_OC7D.Bits.OC7D7
#define TIM2_OC7D_OC7D_4                _TIM2_OC7D.MergedBits.grpOC7D_4
#define TIM2_OC7D_OC7D                  TIM2_OC7D_OC7D_4

#define TIM2_OC7D_OC7D4_MASK            16U
#define TIM2_OC7D_OC7D5_MASK            32U
#define TIM2_OC7D_OC7D6_MASK            64U
#define TIM2_OC7D_OC7D7_MASK            128U
#define TIM2_OC7D_OC7D_4_MASK           240U
#define TIM2_OC7D_OC7D_4_BITNUM         4U


/*** TIM2_TCNT - TIM2 Timer Count Register; 0x00000184 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** TIM2_TCNTHi - TIM2 Timer Count Register High; 0x00000184 ***/
    union {
      byte Byte;
    } TIM2_TCNTHiSTR;
    #define TIM2_TCNTHi                 _TIM2_TCNT.Overlap_STR.TIM2_TCNTHiSTR.Byte
    

    /*** TIM2_TCNTLo - TIM2 Timer Count Register Low; 0x00000185 ***/
    union {
      byte Byte;
    } TIM2_TCNTLoSTR;
    #define TIM2_TCNTLo                 _TIM2_TCNT.Overlap_STR.TIM2_TCNTLoSTR.Byte
    
  } Overlap_STR;

} TIM2_TCNTSTR;
extern volatile TIM2_TCNTSTR _TIM2_TCNT @(REG_BASE + 0x00000184UL);
#define TIM2_TCNT                       _TIM2_TCNT.Word


/*** TIM2_TSCR1 - TIM2 Timer System Control Register1; 0x00000186 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte TFFCA       :1;                                       /* Timer Fast Flag Clear All */
    byte TSFRZ       :1;                                       /* Timer and Modulus Counter Stop While in Freeze Mode */
    byte TSWAI       :1;                                       /* Timer Module Stops While in Wait */
    byte TEN         :1;                                       /* Timer Enable */
  } Bits;
} TIM2_TSCR1STR;
extern volatile TIM2_TSCR1STR _TIM2_TSCR1 @(REG_BASE + 0x00000186UL);
#define TIM2_TSCR1                      _TIM2_TSCR1.Byte
#define TIM2_TSCR1_TFFCA                _TIM2_TSCR1.Bits.TFFCA
#define TIM2_TSCR1_TSFRZ                _TIM2_TSCR1.Bits.TSFRZ
#define TIM2_TSCR1_TSWAI                _TIM2_TSCR1.Bits.TSWAI
#define TIM2_TSCR1_TEN                  _TIM2_TSCR1.Bits.TEN

#define TIM2_TSCR1_TFFCA_MASK           16U
#define TIM2_TSCR1_TSFRZ_MASK           32U
#define TIM2_TSCR1_TSWAI_MASK           64U
#define TIM2_TSCR1_TEN_MASK             128U


/*** TIM2_TTOV - TIM2 Timer Toggle On Overflow Register; 0x00000187 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte TOV4        :1;                                       /* Toggle On Overflow Bit 4 */
    byte TOV5        :1;                                       /* Toggle On Overflow Bit 5 */
    byte TOV6        :1;                                       /* Toggle On Overflow Bit 6 */
    byte TOV7        :1;                                       /* Toggle On Overflow Bit 7 */
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte grpTOV_4 :4;
  } MergedBits;
} TIM2_TTOVSTR;
extern volatile TIM2_TTOVSTR _TIM2_TTOV @(REG_BASE + 0x00000187UL);
#define TIM2_TTOV                       _TIM2_TTOV.Byte
#define TIM2_TTOV_TOV4                  _TIM2_TTOV.Bits.TOV4
#define TIM2_TTOV_TOV5                  _TIM2_TTOV.Bits.TOV5
#define TIM2_TTOV_TOV6                  _TIM2_TTOV.Bits.TOV6
#define TIM2_TTOV_TOV7                  _TIM2_TTOV.Bits.TOV7
#define TIM2_TTOV_TOV_4                 _TIM2_TTOV.MergedBits.grpTOV_4
#define TIM2_TTOV_TOV                   TIM2_TTOV_TOV_4

#define TIM2_TTOV_TOV4_MASK             16U
#define TIM2_TTOV_TOV5_MASK             32U
#define TIM2_TTOV_TOV6_MASK             64U
#define TIM2_TTOV_TOV7_MASK             128U
#define TIM2_TTOV_TOV_4_MASK            240U
#define TIM2_TTOV_TOV_4_BITNUM          4U


/*** TIM2_TCTL1 - TIM2 Timer Control Register 1; 0x00000188 ***/
typedef union {
  byte Byte;
  struct {
    byte OL4         :1;                                       /* Output Level Bit 4 */
    byte OM4         :1;                                       /* Output Mode Bit 4 */
    byte OL5         :1;                                       /* Output Level Bit 5 */
    byte OM5         :1;                                       /* Output Mode Bit 5 */
    byte OL6         :1;                                       /* Output Level Bit 6 */
    byte OM6         :1;                                       /* Output Mode Bit 6 */
    byte OL7         :1;                                       /* Output Level Bit 7 */
    byte OM7         :1;                                       /* Output Mode Bit 7 */
  } Bits;
} TIM2_TCTL1STR;
extern volatile TIM2_TCTL1STR _TIM2_TCTL1 @(REG_BASE + 0x00000188UL);
#define TIM2_TCTL1                      _TIM2_TCTL1.Byte
#define TIM2_TCTL1_OL4                  _TIM2_TCTL1.Bits.OL4
#define TIM2_TCTL1_OM4                  _TIM2_TCTL1.Bits.OM4
#define TIM2_TCTL1_OL5                  _TIM2_TCTL1.Bits.OL5
#define TIM2_TCTL1_OM5                  _TIM2_TCTL1.Bits.OM5
#define TIM2_TCTL1_OL6                  _TIM2_TCTL1.Bits.OL6
#define TIM2_TCTL1_OM6                  _TIM2_TCTL1.Bits.OM6
#define TIM2_TCTL1_OL7                  _TIM2_TCTL1.Bits.OL7
#define TIM2_TCTL1_OM7                  _TIM2_TCTL1.Bits.OM7

#define TIM2_TCTL1_OL4_MASK             1U
#define TIM2_TCTL1_OM4_MASK             2U
#define TIM2_TCTL1_OL5_MASK             4U
#define TIM2_TCTL1_OM5_MASK             8U
#define TIM2_TCTL1_OL6_MASK             16U
#define TIM2_TCTL1_OM6_MASK             32U
#define TIM2_TCTL1_OL7_MASK             64U
#define TIM2_TCTL1_OM7_MASK             128U


/*** TIM2_TCTL3 - TIM2 Timer Control Register 3; 0x0000018A ***/
typedef union {
  byte Byte;
  struct {
    byte EDG4A       :1;                                       /* Input Capture Edge Control 4A */
    byte EDG4B       :1;                                       /* Input Capture Edge Control 4B */
    byte EDG5A       :1;                                       /* Input Capture Edge Control 5A */
    byte EDG5B       :1;                                       /* Input Capture Edge Control 5B */
    byte EDG6A       :1;                                       /* Input Capture Edge Control 6A */
    byte EDG6B       :1;                                       /* Input Capture Edge Control 6B */
    byte EDG7A       :1;                                       /* Input Capture Edge Control 7A */
    byte EDG7B       :1;                                       /* Input Capture Edge Control 7B */
  } Bits;
  struct {
    byte grpEDG4x :2;
    byte grpEDG5x :2;
    byte grpEDG6x :2;
    byte grpEDG7x :2;
  } MergedBits;
} TIM2_TCTL3STR;
extern volatile TIM2_TCTL3STR _TIM2_TCTL3 @(REG_BASE + 0x0000018AUL);
#define TIM2_TCTL3                      _TIM2_TCTL3.Byte
#define TIM2_TCTL3_EDG4A                _TIM2_TCTL3.Bits.EDG4A
#define TIM2_TCTL3_EDG4B                _TIM2_TCTL3.Bits.EDG4B
#define TIM2_TCTL3_EDG5A                _TIM2_TCTL3.Bits.EDG5A
#define TIM2_TCTL3_EDG5B                _TIM2_TCTL3.Bits.EDG5B
#define TIM2_TCTL3_EDG6A                _TIM2_TCTL3.Bits.EDG6A
#define TIM2_TCTL3_EDG6B                _TIM2_TCTL3.Bits.EDG6B
#define TIM2_TCTL3_EDG7A                _TIM2_TCTL3.Bits.EDG7A
#define TIM2_TCTL3_EDG7B                _TIM2_TCTL3.Bits.EDG7B
#define TIM2_TCTL3_EDG4x                _TIM2_TCTL3.MergedBits.grpEDG4x
#define TIM2_TCTL3_EDG5x                _TIM2_TCTL3.MergedBits.grpEDG5x
#define TIM2_TCTL3_EDG6x                _TIM2_TCTL3.MergedBits.grpEDG6x
#define TIM2_TCTL3_EDG7x                _TIM2_TCTL3.MergedBits.grpEDG7x

#define TIM2_TCTL3_EDG4A_MASK           1U
#define TIM2_TCTL3_EDG4B_MASK           2U
#define TIM2_TCTL3_EDG5A_MASK           4U
#define TIM2_TCTL3_EDG5B_MASK           8U
#define TIM2_TCTL3_EDG6A_MASK           16U
#define TIM2_TCTL3_EDG6B_MASK           32U
#define TIM2_TCTL3_EDG7A_MASK           64U
#define TIM2_TCTL3_EDG7B_MASK           128U
#define TIM2_TCTL3_EDG4x_MASK           3U
#define TIM2_TCTL3_EDG4x_BITNUM         0U
#define TIM2_TCTL3_EDG5x_MASK           12U
#define TIM2_TCTL3_EDG5x_BITNUM         2U
#define TIM2_TCTL3_EDG6x_MASK           48U
#define TIM2_TCTL3_EDG6x_BITNUM         4U
#define TIM2_TCTL3_EDG7x_MASK           192U
#define TIM2_TCTL3_EDG7x_BITNUM         6U


/*** TIM2_TIE - TIM2 Timer Interrupt Enable Register; 0x0000018C ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte C4I         :1;                                       /* Input Capture/Output Compare Interrupt Enable Bit 4 */
    byte C5I         :1;                                       /* Input Capture/Output Compare Interrupt Enable Bit 5 */
    byte C6I         :1;                                       /* Input Capture/Output Compare Interrupt Enable Bit 6 */
    byte C7I         :1;                                       /* Input Capture/Output Compare Interrupt Enable Bit 7 */
  } Bits;
} TIM2_TIESTR;
extern volatile TIM2_TIESTR _TIM2_TIE @(REG_BASE + 0x0000018CUL);
#define TIM2_TIE                        _TIM2_TIE.Byte
#define TIM2_TIE_C4I                    _TIM2_TIE.Bits.C4I
#define TIM2_TIE_C5I                    _TIM2_TIE.Bits.C5I
#define TIM2_TIE_C6I                    _TIM2_TIE.Bits.C6I
#define TIM2_TIE_C7I                    _TIM2_TIE.Bits.C7I

#define TIM2_TIE_C4I_MASK               16U
#define TIM2_TIE_C5I_MASK               32U
#define TIM2_TIE_C6I_MASK               64U
#define TIM2_TIE_C7I_MASK               128U


/*** TIM2_TSCR2 - TIM2 Timer System Control Register 2; 0x0000018D ***/
typedef union {
  byte Byte;
  struct {
    byte PR0         :1;                                       /* Timer Prescaler Select Bit 0 */
    byte PR1         :1;                                       /* Timer Prescaler Select Bit 1 */
    byte PR2         :1;                                       /* Timer Prescaler Select Bit 2 */
    byte TCRE        :1;                                       /* Timer Counter Reset Enable */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte TOI         :1;                                       /* Timer Overflow Interrupt Enable */
  } Bits;
  struct {
    byte grpPR   :3;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} TIM2_TSCR2STR;
extern volatile TIM2_TSCR2STR _TIM2_TSCR2 @(REG_BASE + 0x0000018DUL);
#define TIM2_TSCR2                      _TIM2_TSCR2.Byte
#define TIM2_TSCR2_PR0                  _TIM2_TSCR2.Bits.PR0
#define TIM2_TSCR2_PR1                  _TIM2_TSCR2.Bits.PR1
#define TIM2_TSCR2_PR2                  _TIM2_TSCR2.Bits.PR2
#define TIM2_TSCR2_TCRE                 _TIM2_TSCR2.Bits.TCRE
#define TIM2_TSCR2_TOI                  _TIM2_TSCR2.Bits.TOI
#define TIM2_TSCR2_PR                   _TIM2_TSCR2.MergedBits.grpPR

#define TIM2_TSCR2_PR0_MASK             1U
#define TIM2_TSCR2_PR1_MASK             2U
#define TIM2_TSCR2_PR2_MASK             4U
#define TIM2_TSCR2_TCRE_MASK            8U
#define TIM2_TSCR2_TOI_MASK             128U
#define TIM2_TSCR2_PR_MASK              7U
#define TIM2_TSCR2_PR_BITNUM            0U


/*** TIM2_TFLG1 - TIM2 Main Timer Interrupt Flag 1; 0x0000018E ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte C4F         :1;                                       /* Input Capture/Output Compare Channel Flag 4 */
    byte C5F         :1;                                       /* Input Capture/Output Compare Channel Flag 5 */
    byte C6F         :1;                                       /* Input Capture/Output Compare Channel Flag 6 */
    byte C7F         :1;                                       /* Input Capture/Output Compare Channel Flag 7 */
  } Bits;
} TIM2_TFLG1STR;
extern volatile TIM2_TFLG1STR _TIM2_TFLG1 @(REG_BASE + 0x0000018EUL);
#define TIM2_TFLG1                      _TIM2_TFLG1.Byte
#define TIM2_TFLG1_C4F                  _TIM2_TFLG1.Bits.C4F
#define TIM2_TFLG1_C5F                  _TIM2_TFLG1.Bits.C5F
#define TIM2_TFLG1_C6F                  _TIM2_TFLG1.Bits.C6F
#define TIM2_TFLG1_C7F                  _TIM2_TFLG1.Bits.C7F

#define TIM2_TFLG1_C4F_MASK             16U
#define TIM2_TFLG1_C5F_MASK             32U
#define TIM2_TFLG1_C6F_MASK             64U
#define TIM2_TFLG1_C7F_MASK             128U


/*** TIM2_TFLG2 - TIM2 Main Timer Interrupt Flag 2; 0x0000018F ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte TOF         :1;                                       /* Timer Overflow Flag */
  } Bits;
} TIM2_TFLG2STR;
extern volatile TIM2_TFLG2STR _TIM2_TFLG2 @(REG_BASE + 0x0000018FUL);
#define TIM2_TFLG2                      _TIM2_TFLG2.Byte
#define TIM2_TFLG2_TOF                  _TIM2_TFLG2.Bits.TOF

#define TIM2_TFLG2_TOF_MASK             128U


/*** TIM2_TC4 - TIM2 Timer Input Capture/Output Compare Register 4; 0x00000198 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** TIM2_TC4Hi - TIM2 Timer Input Capture/Output Compare Register 4 High; 0x00000198 ***/
    union {
      byte Byte;
    } TIM2_TC4HiSTR;
    #define TIM2_TC4Hi                  _TIM2_TC4.Overlap_STR.TIM2_TC4HiSTR.Byte
    

    /*** TIM2_TC4Lo - TIM2 Timer Input Capture/Output Compare Register 4 Low; 0x00000199 ***/
    union {
      byte Byte;
    } TIM2_TC4LoSTR;
    #define TIM2_TC4Lo                  _TIM2_TC4.Overlap_STR.TIM2_TC4LoSTR.Byte
    
  } Overlap_STR;

} TIM2_TC4STR;
extern volatile TIM2_TC4STR _TIM2_TC4 @(REG_BASE + 0x00000198UL);
#define TIM2_TC4                        _TIM2_TC4.Word


/*** TIM2_TC5 - TIM2 Timer Input Capture/Output Compare Register 5; 0x0000019A ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** TIM2_TC5Hi - TIM2 Timer Input Capture/Output Compare Register 5 High; 0x0000019A ***/
    union {
      byte Byte;
    } TIM2_TC5HiSTR;
    #define TIM2_TC5Hi                  _TIM2_TC5.Overlap_STR.TIM2_TC5HiSTR.Byte
    

    /*** TIM2_TC5Lo - TIM2 Timer Input Capture/Output Compare Register 5 Low; 0x0000019B ***/
    union {
      byte Byte;
    } TIM2_TC5LoSTR;
    #define TIM2_TC5Lo                  _TIM2_TC5.Overlap_STR.TIM2_TC5LoSTR.Byte
    
  } Overlap_STR;

} TIM2_TC5STR;
extern volatile TIM2_TC5STR _TIM2_TC5 @(REG_BASE + 0x0000019AUL);
#define TIM2_TC5                        _TIM2_TC5.Word


/*** TIM2_TC6 - TIM2 Timer Input Capture/Output Compare Register 6; 0x0000019C ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** TIM2_TC6Hi - TIM2 Timer Input Capture/Output Compare Register 6 High; 0x0000019C ***/
    union {
      byte Byte;
    } TIM2_TC6HiSTR;
    #define TIM2_TC6Hi                  _TIM2_TC6.Overlap_STR.TIM2_TC6HiSTR.Byte
    

    /*** TIM2_TC6Lo - TIM2 Timer Input Capture/Output Compare Register 6 Low; 0x0000019D ***/
    union {
      byte Byte;
    } TIM2_TC6LoSTR;
    #define TIM2_TC6Lo                  _TIM2_TC6.Overlap_STR.TIM2_TC6LoSTR.Byte
    
  } Overlap_STR;

} TIM2_TC6STR;
extern volatile TIM2_TC6STR _TIM2_TC6 @(REG_BASE + 0x0000019CUL);
#define TIM2_TC6                        _TIM2_TC6.Word


/*** TIM2_TC7 - TIM2 Timer Input Capture/Output Compare Register 7; 0x0000019E ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** TIM2_TC7Hi - TIM2 Timer Input Capture/Output Compare Register 7 High; 0x0000019E ***/
    union {
      byte Byte;
    } TIM2_TC7HiSTR;
    #define TIM2_TC7Hi                  _TIM2_TC7.Overlap_STR.TIM2_TC7HiSTR.Byte
    

    /*** TIM2_TC7Lo - TIM2 Timer Input Capture/Output Compare Register 7 Low; 0x0000019F ***/
    union {
      byte Byte;
    } TIM2_TC7LoSTR;
    #define TIM2_TC7Lo                  _TIM2_TC7.Overlap_STR.TIM2_TC7LoSTR.Byte
    
  } Overlap_STR;

} TIM2_TC7STR;
extern volatile TIM2_TC7STR _TIM2_TC7 @(REG_BASE + 0x0000019EUL);
#define TIM2_TC7                        _TIM2_TC7.Word


/*** TIM2_PACTL - TIM2 16-Bit Pulse Accumulator A Control Register; 0x000001A0 ***/
typedef union {
  byte Byte;
  struct {
    byte PAI         :1;                                       /* Pulse Accumulator Input Interrupt enable */
    byte PAOVI       :1;                                       /* Pulse Accumulator A Overflow Interrupt enable */
    byte CLK0        :1;                                       /* Clock Select Bit 0 */
    byte CLK1        :1;                                       /* Clock Select Bit 1 */
    byte PEDGE       :1;                                       /* Pulse Accumulator Edge Control */
    byte PAMOD       :1;                                       /* Pulse Accumulator Mode */
    byte PAEN        :1;                                       /* Pulse Accumulator A System Enable */
    byte             :1; 
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte grpCLK  :2;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} TIM2_PACTLSTR;
extern volatile TIM2_PACTLSTR _TIM2_PACTL @(REG_BASE + 0x000001A0UL);
#define TIM2_PACTL                      _TIM2_PACTL.Byte
#define TIM2_PACTL_PAI                  _TIM2_PACTL.Bits.PAI
#define TIM2_PACTL_PAOVI                _TIM2_PACTL.Bits.PAOVI
#define TIM2_PACTL_CLK0                 _TIM2_PACTL.Bits.CLK0
#define TIM2_PACTL_CLK1                 _TIM2_PACTL.Bits.CLK1
#define TIM2_PACTL_PEDGE                _TIM2_PACTL.Bits.PEDGE
#define TIM2_PACTL_PAMOD                _TIM2_PACTL.Bits.PAMOD
#define TIM2_PACTL_PAEN                 _TIM2_PACTL.Bits.PAEN
#define TIM2_PACTL_CLK                  _TIM2_PACTL.MergedBits.grpCLK

#define TIM2_PACTL_PAI_MASK             1U
#define TIM2_PACTL_PAOVI_MASK           2U
#define TIM2_PACTL_CLK0_MASK            4U
#define TIM2_PACTL_CLK1_MASK            8U
#define TIM2_PACTL_PEDGE_MASK           16U
#define TIM2_PACTL_PAMOD_MASK           32U
#define TIM2_PACTL_PAEN_MASK            64U
#define TIM2_PACTL_CLK_MASK             12U
#define TIM2_PACTL_CLK_BITNUM           2U


/*** TIM2_PAFLG - TIM2 Pulse Accumulator A Flag Register; 0x000001A1 ***/
typedef union {
  byte Byte;
  struct {
    byte PAIF        :1;                                       /* Pulse Accumulator Input edge Flag */
    byte PAOVF       :1;                                       /* Pulse Accumulator A Overflow Flag */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} TIM2_PAFLGSTR;
extern volatile TIM2_PAFLGSTR _TIM2_PAFLG @(REG_BASE + 0x000001A1UL);
#define TIM2_PAFLG                      _TIM2_PAFLG.Byte
#define TIM2_PAFLG_PAIF                 _TIM2_PAFLG.Bits.PAIF
#define TIM2_PAFLG_PAOVF                _TIM2_PAFLG.Bits.PAOVF

#define TIM2_PAFLG_PAIF_MASK            1U
#define TIM2_PAFLG_PAOVF_MASK           2U


/*** TIM2_PACNT - TIM2 Pulse Accumulators Count Register; 0x000001A2 ***/
typedef union {
  word Word;
} TIM2_PACNTSTR;
extern volatile TIM2_PACNTSTR _TIM2_PACNT @(REG_BASE + 0x000001A2UL);
#define TIM2_PACNT                      _TIM2_PACNT.Word


/*** PWME - PWM Enable Register; 0x000001E0 ***/
typedef union {
  byte Byte;
  struct {
    byte PWME0       :1;                                       /* Pulse Width Channel 0 Enable */
    byte PWME1       :1;                                       /* Pulse Width Channel 1 Enable */
    byte PWME2       :1;                                       /* Pulse Width Channel 2 Enable */
    byte PWME3       :1;                                       /* Pulse Width Channel 3 Enable */
    byte PWME4       :1;                                       /* Pulse Width Channel 4 Enable */
    byte PWME5       :1;                                       /* Pulse Width Channel 5 Enable */
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpPWME :6;
    byte         :1;
    byte         :1;
  } MergedBits;
} PWMESTR;
extern volatile PWMESTR _PWME @(REG_BASE + 0x000001E0UL);
#define PWME                            _PWME.Byte
#define PWME_PWME0                      _PWME.Bits.PWME0
#define PWME_PWME1                      _PWME.Bits.PWME1
#define PWME_PWME2                      _PWME.Bits.PWME2
#define PWME_PWME3                      _PWME.Bits.PWME3
#define PWME_PWME4                      _PWME.Bits.PWME4
#define PWME_PWME5                      _PWME.Bits.PWME5
#define PWME_PWME                       _PWME.MergedBits.grpPWME

#define PWME_PWME0_MASK                 1U
#define PWME_PWME1_MASK                 2U
#define PWME_PWME2_MASK                 4U
#define PWME_PWME3_MASK                 8U
#define PWME_PWME4_MASK                 16U
#define PWME_PWME5_MASK                 32U
#define PWME_PWME_MASK                  63U
#define PWME_PWME_BITNUM                0U


/*** PWMPOL - PWM Polarity Register; 0x000001E1 ***/
typedef union {
  byte Byte;
  struct {
    byte PPOL0       :1;                                       /* Pulse Width Channel 0 Polarity */
    byte PPOL1       :1;                                       /* Pulse Width Channel 1 Polarity */
    byte PPOL2       :1;                                       /* Pulse Width Channel 2 Polarity */
    byte PPOL3       :1;                                       /* Pulse Width Channel 3 Polarity */
    byte PPOL4       :1;                                       /* Pulse Width Channel 4 Polarity */
    byte PPOL5       :1;                                       /* Pulse Width Channel 5 Polarity */
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpPPOL :6;
    byte         :1;
    byte         :1;
  } MergedBits;
} PWMPOLSTR;
extern volatile PWMPOLSTR _PWMPOL @(REG_BASE + 0x000001E1UL);
#define PWMPOL                          _PWMPOL.Byte
#define PWMPOL_PPOL0                    _PWMPOL.Bits.PPOL0
#define PWMPOL_PPOL1                    _PWMPOL.Bits.PPOL1
#define PWMPOL_PPOL2                    _PWMPOL.Bits.PPOL2
#define PWMPOL_PPOL3                    _PWMPOL.Bits.PPOL3
#define PWMPOL_PPOL4                    _PWMPOL.Bits.PPOL4
#define PWMPOL_PPOL5                    _PWMPOL.Bits.PPOL5
#define PWMPOL_PPOL                     _PWMPOL.MergedBits.grpPPOL

#define PWMPOL_PPOL0_MASK               1U
#define PWMPOL_PPOL1_MASK               2U
#define PWMPOL_PPOL2_MASK               4U
#define PWMPOL_PPOL3_MASK               8U
#define PWMPOL_PPOL4_MASK               16U
#define PWMPOL_PPOL5_MASK               32U
#define PWMPOL_PPOL_MASK                63U
#define PWMPOL_PPOL_BITNUM              0U


/*** PWMCLK - PWM Clock Select Register; 0x000001E2 ***/
typedef union {
  byte Byte;
  struct {
    byte PCLK0       :1;                                       /* Pulse Width Channel 0 Clock Select */
    byte PCLK1       :1;                                       /* Pulse Width Channel 1 Clock Select */
    byte PCLK2       :1;                                       /* Pulse Width Channel 2 Clock Select */
    byte PCLK3       :1;                                       /* Pulse Width Channel 3 Clock Select */
    byte PCLK4       :1;                                       /* Pulse Width Channel 4 Clock Select */
    byte PCLK5       :1;                                       /* Pulse Width Channel 5 Clock Select */
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpPCLK :6;
    byte         :1;
    byte         :1;
  } MergedBits;
} PWMCLKSTR;
extern volatile PWMCLKSTR _PWMCLK @(REG_BASE + 0x000001E2UL);
#define PWMCLK                          _PWMCLK.Byte
#define PWMCLK_PCLK0                    _PWMCLK.Bits.PCLK0
#define PWMCLK_PCLK1                    _PWMCLK.Bits.PCLK1
#define PWMCLK_PCLK2                    _PWMCLK.Bits.PCLK2
#define PWMCLK_PCLK3                    _PWMCLK.Bits.PCLK3
#define PWMCLK_PCLK4                    _PWMCLK.Bits.PCLK4
#define PWMCLK_PCLK5                    _PWMCLK.Bits.PCLK5
#define PWMCLK_PCLK                     _PWMCLK.MergedBits.grpPCLK

#define PWMCLK_PCLK0_MASK               1U
#define PWMCLK_PCLK1_MASK               2U
#define PWMCLK_PCLK2_MASK               4U
#define PWMCLK_PCLK3_MASK               8U
#define PWMCLK_PCLK4_MASK               16U
#define PWMCLK_PCLK5_MASK               32U
#define PWMCLK_PCLK_MASK                63U
#define PWMCLK_PCLK_BITNUM              0U


/*** PWMPRCLK - PWM Prescale Clock Select Register; 0x000001E3 ***/
typedef union {
  byte Byte;
  struct {
    byte PCKA0       :1;                                       /* Prescaler Select for Clock A 0 */
    byte PCKA1       :1;                                       /* Prescaler Select for Clock A 1 */
    byte PCKA2       :1;                                       /* Prescaler Select for Clock A 2 */
    byte             :1; 
    byte PCKB0       :1;                                       /* Prescaler Select for Clock B 0 */
    byte PCKB1       :1;                                       /* Prescaler Select for Clock B 1 */
    byte PCKB2       :1;                                       /* Prescaler Select for Clock B 2 */
    byte             :1; 
  } Bits;
  struct {
    byte grpPCKA :3;
    byte         :1;
    byte grpPCKB :3;
    byte         :1;
  } MergedBits;
} PWMPRCLKSTR;
extern volatile PWMPRCLKSTR _PWMPRCLK @(REG_BASE + 0x000001E3UL);
#define PWMPRCLK                        _PWMPRCLK.Byte
#define PWMPRCLK_PCKA0                  _PWMPRCLK.Bits.PCKA0
#define PWMPRCLK_PCKA1                  _PWMPRCLK.Bits.PCKA1
#define PWMPRCLK_PCKA2                  _PWMPRCLK.Bits.PCKA2
#define PWMPRCLK_PCKB0                  _PWMPRCLK.Bits.PCKB0
#define PWMPRCLK_PCKB1                  _PWMPRCLK.Bits.PCKB1
#define PWMPRCLK_PCKB2                  _PWMPRCLK.Bits.PCKB2
#define PWMPRCLK_PCKA                   _PWMPRCLK.MergedBits.grpPCKA
#define PWMPRCLK_PCKB                   _PWMPRCLK.MergedBits.grpPCKB

#define PWMPRCLK_PCKA0_MASK             1U
#define PWMPRCLK_PCKA1_MASK             2U
#define PWMPRCLK_PCKA2_MASK             4U
#define PWMPRCLK_PCKB0_MASK             16U
#define PWMPRCLK_PCKB1_MASK             32U
#define PWMPRCLK_PCKB2_MASK             64U
#define PWMPRCLK_PCKA_MASK              7U
#define PWMPRCLK_PCKA_BITNUM            0U
#define PWMPRCLK_PCKB_MASK              112U
#define PWMPRCLK_PCKB_BITNUM            4U


/*** PWMCAE - PWM Center Align Enable Register; 0x000001E4 ***/
typedef union {
  byte Byte;
  struct {
    byte CAE0        :1;                                       /* Center Aligned Output Mode on channel 0 */
    byte CAE1        :1;                                       /* Center Aligned Output Mode on channel 1 */
    byte CAE2        :1;                                       /* Center Aligned Output Mode on channel 2 */
    byte CAE3        :1;                                       /* Center Aligned Output Mode on channel 3 */
    byte CAE4        :1;                                       /* Center Aligned Output Mode on channel 4 */
    byte CAE5        :1;                                       /* Center Aligned Output Mode on channel 5 */
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpCAE  :6;
    byte         :1;
    byte         :1;
  } MergedBits;
} PWMCAESTR;
extern volatile PWMCAESTR _PWMCAE @(REG_BASE + 0x000001E4UL);
#define PWMCAE                          _PWMCAE.Byte
#define PWMCAE_CAE0                     _PWMCAE.Bits.CAE0
#define PWMCAE_CAE1                     _PWMCAE.Bits.CAE1
#define PWMCAE_CAE2                     _PWMCAE.Bits.CAE2
#define PWMCAE_CAE3                     _PWMCAE.Bits.CAE3
#define PWMCAE_CAE4                     _PWMCAE.Bits.CAE4
#define PWMCAE_CAE5                     _PWMCAE.Bits.CAE5
#define PWMCAE_CAE                      _PWMCAE.MergedBits.grpCAE

#define PWMCAE_CAE0_MASK                1U
#define PWMCAE_CAE1_MASK                2U
#define PWMCAE_CAE2_MASK                4U
#define PWMCAE_CAE3_MASK                8U
#define PWMCAE_CAE4_MASK                16U
#define PWMCAE_CAE5_MASK                32U
#define PWMCAE_CAE_MASK                 63U
#define PWMCAE_CAE_BITNUM               0U


/*** PWMCTL - PWM Control Register; 0x000001E5 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte PFRZ        :1;                                       /* PWM Counters Stop in Freeze Mode */
    byte PSWAI       :1;                                       /* PWM Stops in Wait Mode */
    byte CON01       :1;                                       /* Concatenate channels 0 and 1 */
    byte CON23       :1;                                       /* Concatenate channels 2 and 3 */
    byte CON45       :1;                                       /* Concatenate channels 4 and 5 */
    byte             :1; 
  } Bits;
} PWMCTLSTR;
extern volatile PWMCTLSTR _PWMCTL @(REG_BASE + 0x000001E5UL);
#define PWMCTL                          _PWMCTL.Byte
#define PWMCTL_PFRZ                     _PWMCTL.Bits.PFRZ
#define PWMCTL_PSWAI                    _PWMCTL.Bits.PSWAI
#define PWMCTL_CON01                    _PWMCTL.Bits.CON01
#define PWMCTL_CON23                    _PWMCTL.Bits.CON23
#define PWMCTL_CON45                    _PWMCTL.Bits.CON45

#define PWMCTL_PFRZ_MASK                4U
#define PWMCTL_PSWAI_MASK               8U
#define PWMCTL_CON01_MASK               16U
#define PWMCTL_CON23_MASK               32U
#define PWMCTL_CON45_MASK               64U


/*** PWMSCLA - PWM Scale A Register; 0x000001E8 ***/
typedef union {
  byte Byte;
  struct {
    byte BIT0        :1;                                       /* PWM Scale A Bit 0 */
    byte BIT1        :1;                                       /* PWM Scale A Bit 1 */
    byte BIT2        :1;                                       /* PWM Scale A Bit 2 */
    byte BIT3        :1;                                       /* PWM Scale A Bit 3 */
    byte BIT4        :1;                                       /* PWM Scale A Bit 4 */
    byte BIT5        :1;                                       /* PWM Scale A Bit 5 */
    byte BIT6        :1;                                       /* PWM Scale A Bit 6 */
    byte BIT7        :1;                                       /* PWM Scale A Bit 7 */
  } Bits;
} PWMSCLASTR;
extern volatile PWMSCLASTR _PWMSCLA @(REG_BASE + 0x000001E8UL);
#define PWMSCLA                         _PWMSCLA.Byte
#define PWMSCLA_BIT0                    _PWMSCLA.Bits.BIT0
#define PWMSCLA_BIT1                    _PWMSCLA.Bits.BIT1
#define PWMSCLA_BIT2                    _PWMSCLA.Bits.BIT2
#define PWMSCLA_BIT3                    _PWMSCLA.Bits.BIT3
#define PWMSCLA_BIT4                    _PWMSCLA.Bits.BIT4
#define PWMSCLA_BIT5                    _PWMSCLA.Bits.BIT5
#define PWMSCLA_BIT6                    _PWMSCLA.Bits.BIT6
#define PWMSCLA_BIT7                    _PWMSCLA.Bits.BIT7

#define PWMSCLA_BIT0_MASK               1U
#define PWMSCLA_BIT1_MASK               2U
#define PWMSCLA_BIT2_MASK               4U
#define PWMSCLA_BIT3_MASK               8U
#define PWMSCLA_BIT4_MASK               16U
#define PWMSCLA_BIT5_MASK               32U
#define PWMSCLA_BIT6_MASK               64U
#define PWMSCLA_BIT7_MASK               128U


/*** PWMSCLB - PWM Scale B Register; 0x000001E9 ***/
typedef union {
  byte Byte;
  struct {
    byte BIT0        :1;                                       /* PWM Scale B Bit 0 */
    byte BIT1        :1;                                       /* PWM Scale B Bit 1 */
    byte BIT2        :1;                                       /* PWM Scale B Bit 2 */
    byte BIT3        :1;                                       /* PWM Scale B Bit 3 */
    byte BIT4        :1;                                       /* PWM Scale B Bit 4 */
    byte BIT5        :1;                                       /* PWM Scale B Bit 5 */
    byte BIT6        :1;                                       /* PWM Scale B Bit 6 */
    byte BIT7        :1;                                       /* PWM Scale B Bit 7 */
  } Bits;
} PWMSCLBSTR;
extern volatile PWMSCLBSTR _PWMSCLB @(REG_BASE + 0x000001E9UL);
#define PWMSCLB                         _PWMSCLB.Byte
#define PWMSCLB_BIT0                    _PWMSCLB.Bits.BIT0
#define PWMSCLB_BIT1                    _PWMSCLB.Bits.BIT1
#define PWMSCLB_BIT2                    _PWMSCLB.Bits.BIT2
#define PWMSCLB_BIT3                    _PWMSCLB.Bits.BIT3
#define PWMSCLB_BIT4                    _PWMSCLB.Bits.BIT4
#define PWMSCLB_BIT5                    _PWMSCLB.Bits.BIT5
#define PWMSCLB_BIT6                    _PWMSCLB.Bits.BIT6
#define PWMSCLB_BIT7                    _PWMSCLB.Bits.BIT7

#define PWMSCLB_BIT0_MASK               1U
#define PWMSCLB_BIT1_MASK               2U
#define PWMSCLB_BIT2_MASK               4U
#define PWMSCLB_BIT3_MASK               8U
#define PWMSCLB_BIT4_MASK               16U
#define PWMSCLB_BIT5_MASK               32U
#define PWMSCLB_BIT6_MASK               64U
#define PWMSCLB_BIT7_MASK               128U


/*** PWMCNT01 - PWM Channel Counter 01 Register; 0x000001EC ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** PWMCNT0 - PWM Channel Counter 0 Register; 0x000001EC ***/
    union {
      byte Byte;
    } PWMCNT0STR;
    #define PWMCNT0                     _PWMCNT01.Overlap_STR.PWMCNT0STR.Byte
    /* PWMCNT_ARR: Access 6 PWMCNTx registers in an array */
    #define PWMCNT_ARR                  ((volatile byte *) &PWMCNT0)
    

    /*** PWMCNT1 - PWM Channel Counter 1 Register; 0x000001ED ***/
    union {
      byte Byte;
    } PWMCNT1STR;
    #define PWMCNT1                     _PWMCNT01.Overlap_STR.PWMCNT1STR.Byte
    
  } Overlap_STR;

} PWMCNT01STR;
extern volatile PWMCNT01STR _PWMCNT01 @(REG_BASE + 0x000001ECUL);
#define PWMCNT01                        _PWMCNT01.Word


/*** PWMCNT23 - PWM Channel Counter 23 Register; 0x000001EE ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** PWMCNT2 - PWM Channel Counter 2 Register; 0x000001EE ***/
    union {
      byte Byte;
    } PWMCNT2STR;
    #define PWMCNT2                     _PWMCNT23.Overlap_STR.PWMCNT2STR.Byte
    

    /*** PWMCNT3 - PWM Channel Counter 3 Register; 0x000001EF ***/
    union {
      byte Byte;
    } PWMCNT3STR;
    #define PWMCNT3                     _PWMCNT23.Overlap_STR.PWMCNT3STR.Byte
    
  } Overlap_STR;

} PWMCNT23STR;
extern volatile PWMCNT23STR _PWMCNT23 @(REG_BASE + 0x000001EEUL);
#define PWMCNT23                        _PWMCNT23.Word


/*** PWMCNT45 - PWM Channel Counter 45 Register; 0x000001F0 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** PWMCNT4 - PWM Channel Counter 4 Register; 0x000001F0 ***/
    union {
      byte Byte;
    } PWMCNT4STR;
    #define PWMCNT4                     _PWMCNT45.Overlap_STR.PWMCNT4STR.Byte
    

    /*** PWMCNT5 - PWM Channel Counter 5 Register; 0x000001F1 ***/
    union {
      byte Byte;
    } PWMCNT5STR;
    #define PWMCNT5                     _PWMCNT45.Overlap_STR.PWMCNT5STR.Byte
    
  } Overlap_STR;

} PWMCNT45STR;
extern volatile PWMCNT45STR _PWMCNT45 @(REG_BASE + 0x000001F0UL);
#define PWMCNT45                        _PWMCNT45.Word


/*** PWMPER01 - PWM Channel Period 01 Register; 0x000001F2 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** PWMPER0 - PWM Channel Period 0 Register; 0x000001F2 ***/
    union {
      byte Byte;
    } PWMPER0STR;
    #define PWMPER0                     _PWMPER01.Overlap_STR.PWMPER0STR.Byte
    /* PWMPER_ARR: Access 6 PWMPERx registers in an array */
    #define PWMPER_ARR                  ((volatile byte *) &PWMPER0)
    

    /*** PWMPER1 - PWM Channel Period 1 Register; 0x000001F3 ***/
    union {
      byte Byte;
    } PWMPER1STR;
    #define PWMPER1                     _PWMPER01.Overlap_STR.PWMPER1STR.Byte
    
  } Overlap_STR;

} PWMPER01STR;
extern volatile PWMPER01STR _PWMPER01 @(REG_BASE + 0x000001F2UL);
#define PWMPER01                        _PWMPER01.Word


/*** PWMPER23 - PWM Channel Period 23 Register; 0x000001F4 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** PWMPER2 - PWM Channel Period 2 Register; 0x000001F4 ***/
    union {
      byte Byte;
    } PWMPER2STR;
    #define PWMPER2                     _PWMPER23.Overlap_STR.PWMPER2STR.Byte
    

    /*** PWMPER3 - PWM Channel Period 3 Register; 0x000001F5 ***/
    union {
      byte Byte;
    } PWMPER3STR;
    #define PWMPER3                     _PWMPER23.Overlap_STR.PWMPER3STR.Byte
    
  } Overlap_STR;

} PWMPER23STR;
extern volatile PWMPER23STR _PWMPER23 @(REG_BASE + 0x000001F4UL);
#define PWMPER23                        _PWMPER23.Word


/*** PWMPER45 - PWM Channel Period 45 Register; 0x000001F6 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** PWMPER4 - PWM Channel Period 4 Register; 0x000001F6 ***/
    union {
      byte Byte;
    } PWMPER4STR;
    #define PWMPER4                     _PWMPER45.Overlap_STR.PWMPER4STR.Byte
    

    /*** PWMPER5 - PWM Channel Period 5 Register; 0x000001F7 ***/
    union {
      byte Byte;
    } PWMPER5STR;
    #define PWMPER5                     _PWMPER45.Overlap_STR.PWMPER5STR.Byte
    
  } Overlap_STR;

} PWMPER45STR;
extern volatile PWMPER45STR _PWMPER45 @(REG_BASE + 0x000001F6UL);
#define PWMPER45                        _PWMPER45.Word


/*** PWMDTY01 - PWM Channel Duty 01 Register; 0x000001F8 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** PWMDTY0 - PWM Channel Duty 0 Register; 0x000001F8 ***/
    union {
      byte Byte;
    } PWMDTY0STR;
    #define PWMDTY0                     _PWMDTY01.Overlap_STR.PWMDTY0STR.Byte
    /* PWMDTY_ARR: Access 6 PWMDTYx registers in an array */
    #define PWMDTY_ARR                  ((volatile byte *) &PWMDTY0)
    

    /*** PWMDTY1 - PWM Channel Duty 1 Register; 0x000001F9 ***/
    union {
      byte Byte;
    } PWMDTY1STR;
    #define PWMDTY1                     _PWMDTY01.Overlap_STR.PWMDTY1STR.Byte
    
  } Overlap_STR;

} PWMDTY01STR;
extern volatile PWMDTY01STR _PWMDTY01 @(REG_BASE + 0x000001F8UL);
#define PWMDTY01                        _PWMDTY01.Word


/*** PWMDTY23 - PWM Channel Duty 23 Register; 0x000001FA ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** PWMDTY2 - PWM Channel Duty 2 Register; 0x000001FA ***/
    union {
      byte Byte;
    } PWMDTY2STR;
    #define PWMDTY2                     _PWMDTY23.Overlap_STR.PWMDTY2STR.Byte
    

    /*** PWMDTY3 - PWM Channel Duty 3 Register; 0x000001FB ***/
    union {
      byte Byte;
    } PWMDTY3STR;
    #define PWMDTY3                     _PWMDTY23.Overlap_STR.PWMDTY3STR.Byte
    
  } Overlap_STR;

} PWMDTY23STR;
extern volatile PWMDTY23STR _PWMDTY23 @(REG_BASE + 0x000001FAUL);
#define PWMDTY23                        _PWMDTY23.Word


/*** PWMDTY45 - PWM Channel Duty 45 Register; 0x000001FC ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** PWMDTY4 - PWM Channel Duty 4 Register; 0x000001FC ***/
    union {
      byte Byte;
    } PWMDTY4STR;
    #define PWMDTY4                     _PWMDTY45.Overlap_STR.PWMDTY4STR.Byte
    

    /*** PWMDTY5 - PWM Channel Duty 5 Register; 0x000001FD ***/
    union {
      byte Byte;
    } PWMDTY5STR;
    #define PWMDTY5                     _PWMDTY45.Overlap_STR.PWMDTY5STR.Byte
    
  } Overlap_STR;

} PWMDTY45STR;
extern volatile PWMDTY45STR _PWMDTY45 @(REG_BASE + 0x000001FCUL);
#define PWMDTY45                        _PWMDTY45.Word


/*** PWMSDN - PWM Shutdown Register; 0x000001FE ***/
typedef union {
  byte Byte;
  struct {
    byte PWM5ENA     :1;                                       /* PWM emergency shutdown Enable */
    byte PWM5INL     :1;                                       /* PWM shutdown active input level for ch. 5 */
    byte PWM5IN      :1;                                       /* PWM channel 5 input status */
    byte             :1; 
    byte PWMLVL      :1;                                       /* PWM shutdown output Level */
    byte PWMRSTRT    :1;                                       /* PWM Restart */
    byte PWMIE       :1;                                       /* PWM Interrupt Enable */
    byte PWMIF       :1;                                       /* PWM Interrupt Flag */
  } Bits;
} PWMSDNSTR;
extern volatile PWMSDNSTR _PWMSDN @(REG_BASE + 0x000001FEUL);
#define PWMSDN                          _PWMSDN.Byte
#define PWMSDN_PWM5ENA                  _PWMSDN.Bits.PWM5ENA
#define PWMSDN_PWM5INL                  _PWMSDN.Bits.PWM5INL
#define PWMSDN_PWM5IN                   _PWMSDN.Bits.PWM5IN
#define PWMSDN_PWMLVL                   _PWMSDN.Bits.PWMLVL
#define PWMSDN_PWMRSTRT                 _PWMSDN.Bits.PWMRSTRT
#define PWMSDN_PWMIE                    _PWMSDN.Bits.PWMIE
#define PWMSDN_PWMIF                    _PWMSDN.Bits.PWMIF

#define PWMSDN_PWM5ENA_MASK             1U
#define PWMSDN_PWM5INL_MASK             2U
#define PWMSDN_PWM5IN_MASK              4U
#define PWMSDN_PWMLVL_MASK              16U
#define PWMSDN_PWMRSTRT_MASK            32U
#define PWMSDN_PWMIE_MASK               64U
#define PWMSDN_PWMIF_MASK               128U


/*** PMFCFG0 - PMF Configure 0 Register; 0x00000200 ***/
typedef union {
  byte Byte;
  struct {
    byte INDEPA      :1;                                       /* Independent or Complimentary Operation for Pair A */
    byte INDEPB      :1;                                       /* Independent or Complimentary Operation for Pair B */
    byte INDEPC      :1;                                       /* Independent or Complimentary Operation for Pair C */
    byte EDGEA       :1;                                       /* Edge-Aligned or Center-Aligned PWM for Pair A */
    byte EDGEB       :1;                                       /* Edge-Aligned or Center-Aligned PWM for Pair B */
    byte EDGEC       :1;                                       /* Edge-Aligned or Center-Aligned PWM for Pair C */
    byte MTG         :1;                                       /* Multiple Timebase Generators */
    byte WP          :1;                                       /* Write Protect */
  } Bits;
  struct {
    byte grpINDEPx :3;
    byte grpEDGEx :3;
    byte         :1;
    byte         :1;
  } MergedBits;
} PMFCFG0STR;
extern volatile PMFCFG0STR _PMFCFG0 @(REG_BASE + 0x00000200UL);
#define PMFCFG0                         _PMFCFG0.Byte
#define PMFCFG0_INDEPA                  _PMFCFG0.Bits.INDEPA
#define PMFCFG0_INDEPB                  _PMFCFG0.Bits.INDEPB
#define PMFCFG0_INDEPC                  _PMFCFG0.Bits.INDEPC
#define PMFCFG0_EDGEA                   _PMFCFG0.Bits.EDGEA
#define PMFCFG0_EDGEB                   _PMFCFG0.Bits.EDGEB
#define PMFCFG0_EDGEC                   _PMFCFG0.Bits.EDGEC
#define PMFCFG0_MTG                     _PMFCFG0.Bits.MTG
#define PMFCFG0_WP                      _PMFCFG0.Bits.WP
/* PMFCFG_ARR: Access 4 PMFCFGx registers in an array */
#define PMFCFG_ARR                      ((volatile byte *) &PMFCFG0)
#define PMFCFG0_INDEPx                  _PMFCFG0.MergedBits.grpINDEPx
#define PMFCFG0_EDGEx                   _PMFCFG0.MergedBits.grpEDGEx

#define PMFCFG0_INDEPA_MASK             1U
#define PMFCFG0_INDEPB_MASK             2U
#define PMFCFG0_INDEPC_MASK             4U
#define PMFCFG0_EDGEA_MASK              8U
#define PMFCFG0_EDGEB_MASK              16U
#define PMFCFG0_EDGEC_MASK              32U
#define PMFCFG0_MTG_MASK                64U
#define PMFCFG0_WP_MASK                 128U
#define PMFCFG0_INDEPx_MASK             7U
#define PMFCFG0_INDEPx_BITNUM           0U
#define PMFCFG0_EDGEx_MASK              56U
#define PMFCFG0_EDGEx_BITNUM            3U


/*** PMFCFG1 - PMF Configure 1 Register; 0x00000201 ***/
typedef union {
  byte Byte;
  struct {
    byte TOPNEGA     :1;                                       /* Pair A Top-side PWM Polarity */
    byte BOTNEGA     :1;                                       /* Pair A Bottom-side PWM Polarity */
    byte TOPNEGB     :1;                                       /* Pair B Top-side PWM Polarity */
    byte BOTNEGB     :1;                                       /* Pair B Bottom-side PWM Polarity */
    byte TOPNEGC     :1;                                       /* Pair C Top-side PWM Polarity */
    byte BOTNEGC     :1;                                       /* Pair C Bottom-side PWM Polarity */
    byte             :1; 
    byte ENHA        :1;                                       /* Enable Hardware Acceleration */
  } Bits;
} PMFCFG1STR;
extern volatile PMFCFG1STR _PMFCFG1 @(REG_BASE + 0x00000201UL);
#define PMFCFG1                         _PMFCFG1.Byte
#define PMFCFG1_TOPNEGA                 _PMFCFG1.Bits.TOPNEGA
#define PMFCFG1_BOTNEGA                 _PMFCFG1.Bits.BOTNEGA
#define PMFCFG1_TOPNEGB                 _PMFCFG1.Bits.TOPNEGB
#define PMFCFG1_BOTNEGB                 _PMFCFG1.Bits.BOTNEGB
#define PMFCFG1_TOPNEGC                 _PMFCFG1.Bits.TOPNEGC
#define PMFCFG1_BOTNEGC                 _PMFCFG1.Bits.BOTNEGC
#define PMFCFG1_ENHA                    _PMFCFG1.Bits.ENHA

#define PMFCFG1_TOPNEGA_MASK            1U
#define PMFCFG1_BOTNEGA_MASK            2U
#define PMFCFG1_TOPNEGB_MASK            4U
#define PMFCFG1_BOTNEGB_MASK            8U
#define PMFCFG1_TOPNEGC_MASK            16U
#define PMFCFG1_BOTNEGC_MASK            32U
#define PMFCFG1_ENHA_MASK               128U


/*** PMFCFG2 - PMF Configure 2 Register; 0x00000202 ***/
typedef union {
  byte Byte;
  struct {
    byte MSK0        :1;                                       /* Mask PWM 0 */
    byte MSK1        :1;                                       /* Mask PWM 1 */
    byte MSK2        :1;                                       /* Mask PWM 2 */
    byte MSK3        :1;                                       /* Mask PWM 3 */
    byte MSK4        :1;                                       /* Mask PWM 4 */
    byte MSK5        :1;                                       /* Mask PWM 5 */
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpMSK  :6;
    byte         :1;
    byte         :1;
  } MergedBits;
} PMFCFG2STR;
extern volatile PMFCFG2STR _PMFCFG2 @(REG_BASE + 0x00000202UL);
#define PMFCFG2                         _PMFCFG2.Byte
#define PMFCFG2_MSK0                    _PMFCFG2.Bits.MSK0
#define PMFCFG2_MSK1                    _PMFCFG2.Bits.MSK1
#define PMFCFG2_MSK2                    _PMFCFG2.Bits.MSK2
#define PMFCFG2_MSK3                    _PMFCFG2.Bits.MSK3
#define PMFCFG2_MSK4                    _PMFCFG2.Bits.MSK4
#define PMFCFG2_MSK5                    _PMFCFG2.Bits.MSK5
#define PMFCFG2_MSK                     _PMFCFG2.MergedBits.grpMSK

#define PMFCFG2_MSK0_MASK               1U
#define PMFCFG2_MSK1_MASK               2U
#define PMFCFG2_MSK2_MASK               4U
#define PMFCFG2_MSK3_MASK               8U
#define PMFCFG2_MSK4_MASK               16U
#define PMFCFG2_MSK5_MASK               32U
#define PMFCFG2_MSK_MASK                63U
#define PMFCFG2_MSK_BITNUM              0U


/*** PMFCFG3 - PMF Configure 3 Register; 0x00000203 ***/
typedef union {
  byte Byte;
  struct {
    byte SWAPA       :1;                                       /* Swap Pair A */
    byte SWAPB       :1;                                       /* Swap Pair B */
    byte SWAPC       :1;                                       /* Swap Pair C */
    byte VLMODE0     :1;                                       /* Value Register Load Mode Bit 0 */
    byte VLMODE1     :1;                                       /* Value Register Load Mode Bit 1 */
    byte             :1; 
    byte PMFFRZ      :1;                                       /* PMF stops in FREEZE mode */
    byte PMFWAI      :1;                                       /* PMF stops in WAIT mode */
  } Bits;
  struct {
    byte grpSWAPx :3;
    byte grpVLMODE :2;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} PMFCFG3STR;
extern volatile PMFCFG3STR _PMFCFG3 @(REG_BASE + 0x00000203UL);
#define PMFCFG3                         _PMFCFG3.Byte
#define PMFCFG3_SWAPA                   _PMFCFG3.Bits.SWAPA
#define PMFCFG3_SWAPB                   _PMFCFG3.Bits.SWAPB
#define PMFCFG3_SWAPC                   _PMFCFG3.Bits.SWAPC
#define PMFCFG3_VLMODE0                 _PMFCFG3.Bits.VLMODE0
#define PMFCFG3_VLMODE1                 _PMFCFG3.Bits.VLMODE1
#define PMFCFG3_PMFFRZ                  _PMFCFG3.Bits.PMFFRZ
#define PMFCFG3_PMFWAI                  _PMFCFG3.Bits.PMFWAI
#define PMFCFG3_SWAPx                   _PMFCFG3.MergedBits.grpSWAPx
#define PMFCFG3_VLMODE                  _PMFCFG3.MergedBits.grpVLMODE

#define PMFCFG3_SWAPA_MASK              1U
#define PMFCFG3_SWAPB_MASK              2U
#define PMFCFG3_SWAPC_MASK              4U
#define PMFCFG3_VLMODE0_MASK            8U
#define PMFCFG3_VLMODE1_MASK            16U
#define PMFCFG3_PMFFRZ_MASK             64U
#define PMFCFG3_PMFWAI_MASK             128U
#define PMFCFG3_SWAPx_MASK              7U
#define PMFCFG3_SWAPx_BITNUM            0U
#define PMFCFG3_VLMODE_MASK             24U
#define PMFCFG3_VLMODE_BITNUM           3U


/*** PMFFCTL - PMF fault control register; 0x00000204 ***/
typedef union {
  byte Byte;
  struct {
    byte FIE0        :1;                                       /* Fault 0 Pin Interrupt Enable */
    byte FMODE0      :1;                                       /* Fault 0 Pin Clearing Mode */
    byte FIE1        :1;                                       /* Fault 1 Pin Interrupt Enable */
    byte FMODE1      :1;                                       /* Fault 1 Pin Clearing Mode */
    byte FIE2        :1;                                       /* Fault 2 Pin Interrupt Enable */
    byte FMODE2      :1;                                       /* Fault 2 Pin Clearing Mode */
    byte FIE3        :1;                                       /* Fault 3 Pin Interrupt Enable */
    byte FMODE3      :1;                                       /* Fault 3 Pin Clearing Mode */
  } Bits;
} PMFFCTLSTR;
extern volatile PMFFCTLSTR _PMFFCTL @(REG_BASE + 0x00000204UL);
#define PMFFCTL                         _PMFFCTL.Byte
#define PMFFCTL_FIE0                    _PMFFCTL.Bits.FIE0
#define PMFFCTL_FMODE0                  _PMFFCTL.Bits.FMODE0
#define PMFFCTL_FIE1                    _PMFFCTL.Bits.FIE1
#define PMFFCTL_FMODE1                  _PMFFCTL.Bits.FMODE1
#define PMFFCTL_FIE2                    _PMFFCTL.Bits.FIE2
#define PMFFCTL_FMODE2                  _PMFFCTL.Bits.FMODE2
#define PMFFCTL_FIE3                    _PMFFCTL.Bits.FIE3
#define PMFFCTL_FMODE3                  _PMFFCTL.Bits.FMODE3

#define PMFFCTL_FIE0_MASK               1U
#define PMFFCTL_FMODE0_MASK             2U
#define PMFFCTL_FIE1_MASK               4U
#define PMFFCTL_FMODE1_MASK             8U
#define PMFFCTL_FIE2_MASK               16U
#define PMFFCTL_FMODE2_MASK             32U
#define PMFFCTL_FIE3_MASK               64U
#define PMFFCTL_FMODE3_MASK             128U


/*** PMFFPIN - PMF fault acknowledge register; 0x00000205 ***/
typedef union {
  byte Byte;
  struct {
    byte FPINE0      :1;                                       /* Fault 0 Pin Enable */
    byte             :1; 
    byte FPINE1      :1;                                       /* Fault 1 Pin Enable */
    byte             :1; 
    byte FPINE2      :1;                                       /* Fault 2 Pin Enable */
    byte             :1; 
    byte FPINE3      :1;                                       /* Fault 3 Pin Enable */
    byte             :1; 
  } Bits;
} PMFFPINSTR;
extern volatile PMFFPINSTR _PMFFPIN @(REG_BASE + 0x00000205UL);
#define PMFFPIN                         _PMFFPIN.Byte
#define PMFFPIN_FPINE0                  _PMFFPIN.Bits.FPINE0
#define PMFFPIN_FPINE1                  _PMFFPIN.Bits.FPINE1
#define PMFFPIN_FPINE2                  _PMFFPIN.Bits.FPINE2
#define PMFFPIN_FPINE3                  _PMFFPIN.Bits.FPINE3

#define PMFFPIN_FPINE0_MASK             1U
#define PMFFPIN_FPINE1_MASK             4U
#define PMFFPIN_FPINE2_MASK             16U
#define PMFFPIN_FPINE3_MASK             64U


/*** PMFFSTA - PMF fault status register; 0x00000206 ***/
typedef union {
  byte Byte;
  struct {
    byte FFLAG0      :1;                                       /* Fault 0 pin Flag */
    byte             :1; 
    byte FFLAG1      :1;                                       /* Fault 1 pin Flag */
    byte             :1; 
    byte FFLAG2      :1;                                       /* Fault 2 pin Flag */
    byte             :1; 
    byte FFLAG3      :1;                                       /* Fault 3 pin Flag */
    byte             :1; 
  } Bits;
} PMFFSTASTR;
extern volatile PMFFSTASTR _PMFFSTA @(REG_BASE + 0x00000206UL);
#define PMFFSTA                         _PMFFSTA.Byte
#define PMFFSTA_FFLAG0                  _PMFFSTA.Bits.FFLAG0
#define PMFFSTA_FFLAG1                  _PMFFSTA.Bits.FFLAG1
#define PMFFSTA_FFLAG2                  _PMFFSTA.Bits.FFLAG2
#define PMFFSTA_FFLAG3                  _PMFFSTA.Bits.FFLAG3

#define PMFFSTA_FFLAG0_MASK             1U
#define PMFFSTA_FFLAG1_MASK             4U
#define PMFFSTA_FFLAG2_MASK             16U
#define PMFFSTA_FFLAG3_MASK             64U


/*** PMFQSMP - PMF fault qualifying samples register; 0x00000207 ***/
typedef union {
  byte Byte;
  struct {
    byte QSMP00      :1;                                       /* Fault 0 Qualifying samples, bit 0 */
    byte QSMP01      :1;                                       /* Fault 0 Qualifying samples, bit 1 */
    byte QSMP10      :1;                                       /* Fault 1 Qualifying samples, bit 0 */
    byte QSMP11      :1;                                       /* Fault 1 Qualifying samples, bit 1 */
    byte QSMP20      :1;                                       /* Fault 2 Qualifying samples, bit 0 */
    byte QSMP21      :1;                                       /* Fault 2 Qualifying samples, bit 1 */
    byte QSMP30      :1;                                       /* Fault 3 Qualifying samples, bit 0 */
    byte QSMP31      :1;                                       /* Fault 3 Qualifying samples, bit 1 */
  } Bits;
  struct {
    byte grpQSMP0 :2;
    byte grpQSMP1 :2;
    byte grpQSMP2 :2;
    byte grpQSMP3 :2;
  } MergedBits;
} PMFQSMPSTR;
extern volatile PMFQSMPSTR _PMFQSMP @(REG_BASE + 0x00000207UL);
#define PMFQSMP                         _PMFQSMP.Byte
#define PMFQSMP_QSMP00                  _PMFQSMP.Bits.QSMP00
#define PMFQSMP_QSMP01                  _PMFQSMP.Bits.QSMP01
#define PMFQSMP_QSMP10                  _PMFQSMP.Bits.QSMP10
#define PMFQSMP_QSMP11                  _PMFQSMP.Bits.QSMP11
#define PMFQSMP_QSMP20                  _PMFQSMP.Bits.QSMP20
#define PMFQSMP_QSMP21                  _PMFQSMP.Bits.QSMP21
#define PMFQSMP_QSMP30                  _PMFQSMP.Bits.QSMP30
#define PMFQSMP_QSMP31                  _PMFQSMP.Bits.QSMP31
#define PMFQSMP_QSMP0                   _PMFQSMP.MergedBits.grpQSMP0
#define PMFQSMP_QSMP1                   _PMFQSMP.MergedBits.grpQSMP1
#define PMFQSMP_QSMP2                   _PMFQSMP.MergedBits.grpQSMP2
#define PMFQSMP_QSMP3                   _PMFQSMP.MergedBits.grpQSMP3

#define PMFQSMP_QSMP00_MASK             1U
#define PMFQSMP_QSMP01_MASK             2U
#define PMFQSMP_QSMP10_MASK             4U
#define PMFQSMP_QSMP11_MASK             8U
#define PMFQSMP_QSMP20_MASK             16U
#define PMFQSMP_QSMP21_MASK             32U
#define PMFQSMP_QSMP30_MASK             64U
#define PMFQSMP_QSMP31_MASK             128U
#define PMFQSMP_QSMP0_MASK              3U
#define PMFQSMP_QSMP0_BITNUM            0U
#define PMFQSMP_QSMP1_MASK              12U
#define PMFQSMP_QSMP1_BITNUM            2U
#define PMFQSMP_QSMP2_MASK              48U
#define PMFQSMP_QSMP2_BITNUM            4U
#define PMFQSMP_QSMP3_MASK              192U
#define PMFQSMP_QSMP3_BITNUM            6U


/*** PMFDMPA - PMF disable mapping A register; 0x00000208 ***/
typedef union {
  byte Byte;
  struct {
    byte DMP00       :1;                                       /* PMF Disable Mapping A Bit 00 */
    byte DMP01       :1;                                       /* PMF Disable Mapping A Bit 01 */
    byte DMP02       :1;                                       /* PMF Disable Mapping A Bit 02 */
    byte DMP03       :1;                                       /* PMF Disable Mapping A Bit 03 */
    byte DMP10       :1;                                       /* PMF Disable Mapping A Bit 10 */
    byte DMP11       :1;                                       /* PMF Disable Mapping A Bit 11 */
    byte DMP12       :1;                                       /* PMF Disable Mapping A Bit 12 */
    byte DMP13       :1;                                       /* PMF Disable Mapping A Bit 13 */
  } Bits;
  struct {
    byte grpDMP0 :4;
    byte grpDMP_10 :4;
  } MergedBits;
} PMFDMPASTR;
extern volatile PMFDMPASTR _PMFDMPA @(REG_BASE + 0x00000208UL);
#define PMFDMPA                         _PMFDMPA.Byte
#define PMFDMPA_DMP00                   _PMFDMPA.Bits.DMP00
#define PMFDMPA_DMP01                   _PMFDMPA.Bits.DMP01
#define PMFDMPA_DMP02                   _PMFDMPA.Bits.DMP02
#define PMFDMPA_DMP03                   _PMFDMPA.Bits.DMP03
#define PMFDMPA_DMP10                   _PMFDMPA.Bits.DMP10
#define PMFDMPA_DMP11                   _PMFDMPA.Bits.DMP11
#define PMFDMPA_DMP12                   _PMFDMPA.Bits.DMP12
#define PMFDMPA_DMP13                   _PMFDMPA.Bits.DMP13
#define PMFDMPA_DMP0                    _PMFDMPA.MergedBits.grpDMP0
#define PMFDMPA_DMP_10                  _PMFDMPA.MergedBits.grpDMP_10
#define PMFDMPA_DMP                     PMFDMPA_DMP_10

#define PMFDMPA_DMP00_MASK              1U
#define PMFDMPA_DMP01_MASK              2U
#define PMFDMPA_DMP02_MASK              4U
#define PMFDMPA_DMP03_MASK              8U
#define PMFDMPA_DMP10_MASK              16U
#define PMFDMPA_DMP11_MASK              32U
#define PMFDMPA_DMP12_MASK              64U
#define PMFDMPA_DMP13_MASK              128U
#define PMFDMPA_DMP0_MASK               15U
#define PMFDMPA_DMP0_BITNUM             0U
#define PMFDMPA_DMP_10_MASK             240U
#define PMFDMPA_DMP_10_BITNUM           4U


/*** PMFDMPB - PMF disable mapping B register; 0x00000209 ***/
typedef union {
  byte Byte;
  struct {
    byte DMP20       :1;                                       /* PMF Disable Mapping A Bit 20 */
    byte DMP21       :1;                                       /* PMF Disable Mapping A Bit 21 */
    byte DMP22       :1;                                       /* PMF Disable Mapping A Bit 22 */
    byte DMP23       :1;                                       /* PMF Disable Mapping A Bit 23 */
    byte DMP30       :1;                                       /* PMF Disable Mapping A Bit 30 */
    byte DMP31       :1;                                       /* PMF Disable Mapping A Bit 31 */
    byte DMP32       :1;                                       /* PMF Disable Mapping A Bit 32 */
    byte DMP33       :1;                                       /* PMF Disable Mapping A Bit 33 */
  } Bits;
  struct {
    byte grpDMP_20 :4;
    byte grpDMP_30 :4;
  } MergedBits;
} PMFDMPBSTR;
extern volatile PMFDMPBSTR _PMFDMPB @(REG_BASE + 0x00000209UL);
#define PMFDMPB                         _PMFDMPB.Byte
#define PMFDMPB_DMP20                   _PMFDMPB.Bits.DMP20
#define PMFDMPB_DMP21                   _PMFDMPB.Bits.DMP21
#define PMFDMPB_DMP22                   _PMFDMPB.Bits.DMP22
#define PMFDMPB_DMP23                   _PMFDMPB.Bits.DMP23
#define PMFDMPB_DMP30                   _PMFDMPB.Bits.DMP30
#define PMFDMPB_DMP31                   _PMFDMPB.Bits.DMP31
#define PMFDMPB_DMP32                   _PMFDMPB.Bits.DMP32
#define PMFDMPB_DMP33                   _PMFDMPB.Bits.DMP33
#define PMFDMPB_DMP_20                  _PMFDMPB.MergedBits.grpDMP_20
#define PMFDMPB_DMP_30                  _PMFDMPB.MergedBits.grpDMP_30
#define PMFDMPB_DMP                     PMFDMPB_DMP_20

#define PMFDMPB_DMP20_MASK              1U
#define PMFDMPB_DMP21_MASK              2U
#define PMFDMPB_DMP22_MASK              4U
#define PMFDMPB_DMP23_MASK              8U
#define PMFDMPB_DMP30_MASK              16U
#define PMFDMPB_DMP31_MASK              32U
#define PMFDMPB_DMP32_MASK              64U
#define PMFDMPB_DMP33_MASK              128U
#define PMFDMPB_DMP_20_MASK             15U
#define PMFDMPB_DMP_20_BITNUM           0U
#define PMFDMPB_DMP_30_MASK             240U
#define PMFDMPB_DMP_30_BITNUM           4U


/*** PMFDMPC - PMF disable mapping C register; 0x0000020A ***/
typedef union {
  byte Byte;
  struct {
    byte DMP40       :1;                                       /* PMF Disable Mapping A Bit 40 */
    byte DMP41       :1;                                       /* PMF Disable Mapping A Bit 41 */
    byte DMP42       :1;                                       /* PMF Disable Mapping A Bit 42 */
    byte DMP43       :1;                                       /* PMF Disable Mapping A Bit 43 */
    byte DMP50       :1;                                       /* PMF Disable Mapping A Bit 50 */
    byte DMP51       :1;                                       /* PMF Disable Mapping A Bit 51 */
    byte DMP52       :1;                                       /* PMF Disable Mapping A Bit 52 */
    byte DMP53       :1;                                       /* PMF Disable Mapping A Bit 53 */
  } Bits;
  struct {
    byte grpDMP_40 :4;
    byte grpDMP_50 :4;
  } MergedBits;
} PMFDMPCSTR;
extern volatile PMFDMPCSTR _PMFDMPC @(REG_BASE + 0x0000020AUL);
#define PMFDMPC                         _PMFDMPC.Byte
#define PMFDMPC_DMP40                   _PMFDMPC.Bits.DMP40
#define PMFDMPC_DMP41                   _PMFDMPC.Bits.DMP41
#define PMFDMPC_DMP42                   _PMFDMPC.Bits.DMP42
#define PMFDMPC_DMP43                   _PMFDMPC.Bits.DMP43
#define PMFDMPC_DMP50                   _PMFDMPC.Bits.DMP50
#define PMFDMPC_DMP51                   _PMFDMPC.Bits.DMP51
#define PMFDMPC_DMP52                   _PMFDMPC.Bits.DMP52
#define PMFDMPC_DMP53                   _PMFDMPC.Bits.DMP53
#define PMFDMPC_DMP_40                  _PMFDMPC.MergedBits.grpDMP_40
#define PMFDMPC_DMP_50                  _PMFDMPC.MergedBits.grpDMP_50
#define PMFDMPC_DMP                     PMFDMPC_DMP_40

#define PMFDMPC_DMP40_MASK              1U
#define PMFDMPC_DMP41_MASK              2U
#define PMFDMPC_DMP42_MASK              4U
#define PMFDMPC_DMP43_MASK              8U
#define PMFDMPC_DMP50_MASK              16U
#define PMFDMPC_DMP51_MASK              32U
#define PMFDMPC_DMP52_MASK              64U
#define PMFDMPC_DMP53_MASK              128U
#define PMFDMPC_DMP_40_MASK             15U
#define PMFDMPC_DMP_40_BITNUM           0U
#define PMFDMPC_DMP_50_MASK             240U
#define PMFDMPC_DMP_50_BITNUM           4U


/*** PMFOUTC - PMF output control register; 0x0000020C ***/
typedef union {
  byte Byte;
  struct {
    byte OUTCTL0     :1;                                       /* PMF Output Control Bit 0 */
    byte OUTCTL1     :1;                                       /* PMF Output Control Bit 1 */
    byte OUTCTL2     :1;                                       /* PMF Output Control Bit 2 */
    byte OUTCTL3     :1;                                       /* PMF Output Control Bit 3 */
    byte OUTCTL4     :1;                                       /* PMF Output Control Bit 4 */
    byte OUTCTL5     :1;                                       /* PMF Output Control Bit 5 */
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpOUTCTL :6;
    byte         :1;
    byte         :1;
  } MergedBits;
} PMFOUTCSTR;
extern volatile PMFOUTCSTR _PMFOUTC @(REG_BASE + 0x0000020CUL);
#define PMFOUTC                         _PMFOUTC.Byte
#define PMFOUTC_OUTCTL0                 _PMFOUTC.Bits.OUTCTL0
#define PMFOUTC_OUTCTL1                 _PMFOUTC.Bits.OUTCTL1
#define PMFOUTC_OUTCTL2                 _PMFOUTC.Bits.OUTCTL2
#define PMFOUTC_OUTCTL3                 _PMFOUTC.Bits.OUTCTL3
#define PMFOUTC_OUTCTL4                 _PMFOUTC.Bits.OUTCTL4
#define PMFOUTC_OUTCTL5                 _PMFOUTC.Bits.OUTCTL5
#define PMFOUTC_OUTCTL                  _PMFOUTC.MergedBits.grpOUTCTL

#define PMFOUTC_OUTCTL0_MASK            1U
#define PMFOUTC_OUTCTL1_MASK            2U
#define PMFOUTC_OUTCTL2_MASK            4U
#define PMFOUTC_OUTCTL3_MASK            8U
#define PMFOUTC_OUTCTL4_MASK            16U
#define PMFOUTC_OUTCTL5_MASK            32U
#define PMFOUTC_OUTCTL_MASK             63U
#define PMFOUTC_OUTCTL_BITNUM           0U


/*** PMFOUTB - PMF output control bit register; 0x0000020D ***/
typedef union {
  byte Byte;
  struct {
    byte OUT0        :1;                                       /* PMF Output Control Bit Bit 0 */
    byte OUT1        :1;                                       /* PMF Output Control Bit Bit 1 */
    byte OUT2        :1;                                       /* PMF Output Control Bit Bit 2 */
    byte OUT3        :1;                                       /* PMF Output Control Bit Bit 3 */
    byte OUT4        :1;                                       /* PMF Output Control Bit Bit 4 */
    byte OUT5        :1;                                       /* PMF Output Control Bit Bit 5 */
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpOUT  :6;
    byte         :1;
    byte         :1;
  } MergedBits;
} PMFOUTBSTR;
extern volatile PMFOUTBSTR _PMFOUTB @(REG_BASE + 0x0000020DUL);
#define PMFOUTB                         _PMFOUTB.Byte
#define PMFOUTB_OUT0                    _PMFOUTB.Bits.OUT0
#define PMFOUTB_OUT1                    _PMFOUTB.Bits.OUT1
#define PMFOUTB_OUT2                    _PMFOUTB.Bits.OUT2
#define PMFOUTB_OUT3                    _PMFOUTB.Bits.OUT3
#define PMFOUTB_OUT4                    _PMFOUTB.Bits.OUT4
#define PMFOUTB_OUT5                    _PMFOUTB.Bits.OUT5
#define PMFOUTB_OUT                     _PMFOUTB.MergedBits.grpOUT

#define PMFOUTB_OUT0_MASK               1U
#define PMFOUTB_OUT1_MASK               2U
#define PMFOUTB_OUT2_MASK               4U
#define PMFOUTB_OUT3_MASK               8U
#define PMFOUTB_OUT4_MASK               16U
#define PMFOUTB_OUT5_MASK               32U
#define PMFOUTB_OUT_MASK                63U
#define PMFOUTB_OUT_BITNUM              0U


/*** PMFDTMS - PMF deadtime sample register; 0x0000020E ***/
typedef union {
  byte Byte;
  struct {
    byte DT0         :1;                                       /* PMF Deadtime Sample Bit 0 */
    byte DT1         :1;                                       /* PMF Deadtime Sample Bit 1 */
    byte DT2         :1;                                       /* PMF Deadtime Sample Bit 2 */
    byte DT3         :1;                                       /* PMF Deadtime Sample Bit 3 */
    byte DT4         :1;                                       /* PMF Deadtime Sample Bit 4 */
    byte DT5         :1;                                       /* PMF Deadtime Sample Bit 5 */
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpDT   :6;
    byte         :1;
    byte         :1;
  } MergedBits;
} PMFDTMSSTR;
extern volatile PMFDTMSSTR _PMFDTMS @(REG_BASE + 0x0000020EUL);
#define PMFDTMS                         _PMFDTMS.Byte
#define PMFDTMS_DT0                     _PMFDTMS.Bits.DT0
#define PMFDTMS_DT1                     _PMFDTMS.Bits.DT1
#define PMFDTMS_DT2                     _PMFDTMS.Bits.DT2
#define PMFDTMS_DT3                     _PMFDTMS.Bits.DT3
#define PMFDTMS_DT4                     _PMFDTMS.Bits.DT4
#define PMFDTMS_DT5                     _PMFDTMS.Bits.DT5
#define PMFDTMS_DT                      _PMFDTMS.MergedBits.grpDT

#define PMFDTMS_DT0_MASK                1U
#define PMFDTMS_DT1_MASK                2U
#define PMFDTMS_DT2_MASK                4U
#define PMFDTMS_DT3_MASK                8U
#define PMFDTMS_DT4_MASK                16U
#define PMFDTMS_DT5_MASK                32U
#define PMFDTMS_DT_MASK                 63U
#define PMFDTMS_DT_BITNUM               0U


/*** PMFCCTL - PMF correction control register; 0x0000020F ***/
typedef union {
  byte Byte;
  struct {
    byte IPOLA       :1;                                       /* Current Polarity A */
    byte IPOLB       :1;                                       /* Current Polarity B */
    byte IPOLC       :1;                                       /* Current Polarity C */
    byte             :1; 
    byte ISENS0      :1;                                       /* Current status sensing method Bit 0 */
    byte ISENS1      :1;                                       /* Current status sensing method Bit 1 */
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpIPOLx :3;
    byte         :1;
    byte grpISENS :2;
    byte         :1;
    byte         :1;
  } MergedBits;
} PMFCCTLSTR;
extern volatile PMFCCTLSTR _PMFCCTL @(REG_BASE + 0x0000020FUL);
#define PMFCCTL                         _PMFCCTL.Byte
#define PMFCCTL_IPOLA                   _PMFCCTL.Bits.IPOLA
#define PMFCCTL_IPOLB                   _PMFCCTL.Bits.IPOLB
#define PMFCCTL_IPOLC                   _PMFCCTL.Bits.IPOLC
#define PMFCCTL_ISENS0                  _PMFCCTL.Bits.ISENS0
#define PMFCCTL_ISENS1                  _PMFCCTL.Bits.ISENS1
#define PMFCCTL_IPOLx                   _PMFCCTL.MergedBits.grpIPOLx
#define PMFCCTL_ISENS                   _PMFCCTL.MergedBits.grpISENS

#define PMFCCTL_IPOLA_MASK              1U
#define PMFCCTL_IPOLB_MASK              2U
#define PMFCCTL_IPOLC_MASK              4U
#define PMFCCTL_ISENS0_MASK             16U
#define PMFCCTL_ISENS1_MASK             32U
#define PMFCCTL_IPOLx_MASK              7U
#define PMFCCTL_IPOLx_BITNUM            0U
#define PMFCCTL_ISENS_MASK              48U
#define PMFCCTL_ISENS_BITNUM            4U


/*** PMFVAL0 - PMF Value 0 Register; 0x00000210 ***/
typedef union {
  word Word;
} PMFVAL0STR;
extern volatile PMFVAL0STR _PMFVAL0 @(REG_BASE + 0x00000210UL);
#define PMFVAL0                         _PMFVAL0.Word
/* PMFVAL_ARR: Access 6 PMFVALx registers in an array */
#define PMFVAL_ARR                      ((volatile word *) &PMFVAL0)


/*** PMFVAL1 - PMF Value 1 Register; 0x00000212 ***/
typedef union {
  word Word;
} PMFVAL1STR;
extern volatile PMFVAL1STR _PMFVAL1 @(REG_BASE + 0x00000212UL);
#define PMFVAL1                         _PMFVAL1.Word


/*** PMFVAL2 - PMF Value 2 Register; 0x00000214 ***/
typedef union {
  word Word;
} PMFVAL2STR;
extern volatile PMFVAL2STR _PMFVAL2 @(REG_BASE + 0x00000214UL);
#define PMFVAL2                         _PMFVAL2.Word


/*** PMFVAL3 - PMF Value 3 Register; 0x00000216 ***/
typedef union {
  word Word;
} PMFVAL3STR;
extern volatile PMFVAL3STR _PMFVAL3 @(REG_BASE + 0x00000216UL);
#define PMFVAL3                         _PMFVAL3.Word


/*** PMFVAL4 - PMF Value 4 Register; 0x00000218 ***/
typedef union {
  word Word;
} PMFVAL4STR;
extern volatile PMFVAL4STR _PMFVAL4 @(REG_BASE + 0x00000218UL);
#define PMFVAL4                         _PMFVAL4.Word


/*** PMFVAL5 - PMF Value 5 Register; 0x0000021A ***/
typedef union {
  word Word;
} PMFVAL5STR;
extern volatile PMFVAL5STR _PMFVAL5 @(REG_BASE + 0x0000021AUL);
#define PMFVAL5                         _PMFVAL5.Word


/*** PMFENCA - PMF Enable Control A Register; 0x00000220 ***/
typedef union {
  byte Byte;
  struct {
    byte PWMRIEA     :1;                                       /* PWM Reload Interrupt Enable A */
    byte LDOKA       :1;                                       /* Load Okay A */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte PWMENA      :1;                                       /* PWM Generator A Enable */
  } Bits;
} PMFENCASTR;
extern volatile PMFENCASTR _PMFENCA @(REG_BASE + 0x00000220UL);
#define PMFENCA                         _PMFENCA.Byte
#define PMFENCA_PWMRIEA                 _PMFENCA.Bits.PWMRIEA
#define PMFENCA_LDOKA                   _PMFENCA.Bits.LDOKA
#define PMFENCA_PWMENA                  _PMFENCA.Bits.PWMENA

#define PMFENCA_PWMRIEA_MASK            1U
#define PMFENCA_LDOKA_MASK              2U
#define PMFENCA_PWMENA_MASK             128U


/*** PMFFQCA - PMF Frequency Control A Register; 0x00000221 ***/
typedef union {
  byte Byte;
  struct {
    byte PWMRFA      :1;                                       /* PWM Reload Flag A */
    byte PRSCA0      :1;                                       /* Prescaler A, bit 0 */
    byte PRSCA1      :1;                                       /* Prescaler A, bit 1 */
    byte HALFA       :1;                                       /* Half Cycle Reload A */
    byte LDFQA0      :1;                                       /* Load Frequency A, bit 0 */
    byte LDFQA1      :1;                                       /* Load Frequency A, bit 1 */
    byte LDFQA2      :1;                                       /* Load Frequency A, bit 2 */
    byte LDFQA3      :1;                                       /* Load Frequency A, bit 3 */
  } Bits;
  struct {
    byte grpPWMRFx :1;
    byte grpPRSCA :2;
    byte grpHALFx :1;
    byte grpLDFQA :4;
  } MergedBits;
} PMFFQCASTR;
extern volatile PMFFQCASTR _PMFFQCA @(REG_BASE + 0x00000221UL);
#define PMFFQCA                         _PMFFQCA.Byte
#define PMFFQCA_PWMRFA                  _PMFFQCA.Bits.PWMRFA
#define PMFFQCA_PRSCA0                  _PMFFQCA.Bits.PRSCA0
#define PMFFQCA_PRSCA1                  _PMFFQCA.Bits.PRSCA1
#define PMFFQCA_HALFA                   _PMFFQCA.Bits.HALFA
#define PMFFQCA_LDFQA0                  _PMFFQCA.Bits.LDFQA0
#define PMFFQCA_LDFQA1                  _PMFFQCA.Bits.LDFQA1
#define PMFFQCA_LDFQA2                  _PMFFQCA.Bits.LDFQA2
#define PMFFQCA_LDFQA3                  _PMFFQCA.Bits.LDFQA3
#define PMFFQCA_PRSCA                   _PMFFQCA.MergedBits.grpPRSCA
#define PMFFQCA_LDFQA                   _PMFFQCA.MergedBits.grpLDFQA

#define PMFFQCA_PWMRFA_MASK             1U
#define PMFFQCA_PRSCA0_MASK             2U
#define PMFFQCA_PRSCA1_MASK             4U
#define PMFFQCA_HALFA_MASK              8U
#define PMFFQCA_LDFQA0_MASK             16U
#define PMFFQCA_LDFQA1_MASK             32U
#define PMFFQCA_LDFQA2_MASK             64U
#define PMFFQCA_LDFQA3_MASK             128U
#define PMFFQCA_PRSCA_MASK              6U
#define PMFFQCA_PRSCA_BITNUM            1U
#define PMFFQCA_LDFQA_MASK              240U
#define PMFFQCA_LDFQA_BITNUM            4U


/*** PMFCNTA - PMF Counter A Register; 0x00000222 ***/
typedef union {
  word Word;
  struct {
    word grpPMFCNTA :15;
    word         :1;
  } MergedBits;
} PMFCNTASTR;
extern volatile PMFCNTASTR _PMFCNTA @(REG_BASE + 0x00000222UL);
#define PMFCNTA                         _PMFCNTA.Word
#define PMFCNTA_PMFCNTA                 _PMFCNTA.MergedBits.grpPMFCNTA

#define PMFCNTA_PMFCNTA_MASK            32767U
#define PMFCNTA_PMFCNTA_BITNUM          0U


/*** PMFMODA - PMF Counter Modulo A Register; 0x00000224 ***/
typedef union {
  word Word;
  struct {
    word grpPMFMODA :15;
    word         :1;
  } MergedBits;
} PMFMODASTR;
extern volatile PMFMODASTR _PMFMODA @(REG_BASE + 0x00000224UL);
#define PMFMODA                         _PMFMODA.Word
#define PMFMODA_PMFMODA                 _PMFMODA.MergedBits.grpPMFMODA

#define PMFMODA_PMFMODA_MASK            32767U
#define PMFMODA_PMFMODA_BITNUM          0U


/*** PMFDTMA - PMF Deadtime A Register; 0x00000226 ***/
typedef union {
  word Word;
  struct {
    word grpPMFDTMA :12;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} PMFDTMASTR;
extern volatile PMFDTMASTR _PMFDTMA @(REG_BASE + 0x00000226UL);
#define PMFDTMA                         _PMFDTMA.Word
#define PMFDTMA_PMFDTMA                 _PMFDTMA.MergedBits.grpPMFDTMA

#define PMFDTMA_PMFDTMA_MASK            4095U
#define PMFDTMA_PMFDTMA_BITNUM          0U


/*** PMFENCB - PMF enable control B register; 0x00000228 ***/
typedef union {
  byte Byte;
  struct {
    byte PWMRIEB     :1;                                       /* PWM Reload Interrupt Enable B */
    byte LDOKB       :1;                                       /* Load Okay B */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte PWMENB      :1;                                       /* PWM Generator B Enable */
  } Bits;
} PMFENCBSTR;
extern volatile PMFENCBSTR _PMFENCB @(REG_BASE + 0x00000228UL);
#define PMFENCB                         _PMFENCB.Byte
#define PMFENCB_PWMRIEB                 _PMFENCB.Bits.PWMRIEB
#define PMFENCB_LDOKB                   _PMFENCB.Bits.LDOKB
#define PMFENCB_PWMENB                  _PMFENCB.Bits.PWMENB

#define PMFENCB_PWMRIEB_MASK            1U
#define PMFENCB_LDOKB_MASK              2U
#define PMFENCB_PWMENB_MASK             128U


/*** PMFFQCB - PMF Frequency Control B Register; 0x00000229 ***/
typedef union {
  byte Byte;
  struct {
    byte PWMRFB      :1;                                       /* PWM Reload Flag B */
    byte PRSCB0      :1;                                       /* Prescaler B, bit 0 */
    byte PRSCB1      :1;                                       /* Prescaler B, bit 1 */
    byte HALFB       :1;                                       /* Half Cycle Reload B */
    byte LDFQB0      :1;                                       /* Load Frequency B, bit 0 */
    byte LDFQB1      :1;                                       /* Load Frequency B, bit 1 */
    byte LDFQB2      :1;                                       /* Load Frequency B, bit 2 */
    byte LDFQB3      :1;                                       /* Load Frequency B, bit 3 */
  } Bits;
  struct {
    byte         :1;
    byte grpPRSCB :2;
    byte         :1;
    byte grpLDFQB :4;
  } MergedBits;
} PMFFQCBSTR;
extern volatile PMFFQCBSTR _PMFFQCB @(REG_BASE + 0x00000229UL);
#define PMFFQCB                         _PMFFQCB.Byte
#define PMFFQCB_PWMRFB                  _PMFFQCB.Bits.PWMRFB
#define PMFFQCB_PRSCB0                  _PMFFQCB.Bits.PRSCB0
#define PMFFQCB_PRSCB1                  _PMFFQCB.Bits.PRSCB1
#define PMFFQCB_HALFB                   _PMFFQCB.Bits.HALFB
#define PMFFQCB_LDFQB0                  _PMFFQCB.Bits.LDFQB0
#define PMFFQCB_LDFQB1                  _PMFFQCB.Bits.LDFQB1
#define PMFFQCB_LDFQB2                  _PMFFQCB.Bits.LDFQB2
#define PMFFQCB_LDFQB3                  _PMFFQCB.Bits.LDFQB3
#define PMFFQCB_PRSCB                   _PMFFQCB.MergedBits.grpPRSCB
#define PMFFQCB_LDFQB                   _PMFFQCB.MergedBits.grpLDFQB

#define PMFFQCB_PWMRFB_MASK             1U
#define PMFFQCB_PRSCB0_MASK             2U
#define PMFFQCB_PRSCB1_MASK             4U
#define PMFFQCB_HALFB_MASK              8U
#define PMFFQCB_LDFQB0_MASK             16U
#define PMFFQCB_LDFQB1_MASK             32U
#define PMFFQCB_LDFQB2_MASK             64U
#define PMFFQCB_LDFQB3_MASK             128U
#define PMFFQCB_PRSCB_MASK              6U
#define PMFFQCB_PRSCB_BITNUM            1U
#define PMFFQCB_LDFQB_MASK              240U
#define PMFFQCB_LDFQB_BITNUM            4U


/*** PMFCNTB - PMF Counter B Register; 0x0000022A ***/
typedef union {
  word Word;
  struct {
    word grpPMFCNTB :15;
    word         :1;
  } MergedBits;
} PMFCNTBSTR;
extern volatile PMFCNTBSTR _PMFCNTB @(REG_BASE + 0x0000022AUL);
#define PMFCNTB                         _PMFCNTB.Word
#define PMFCNTB_PMFCNTB                 _PMFCNTB.MergedBits.grpPMFCNTB

#define PMFCNTB_PMFCNTB_MASK            32767U
#define PMFCNTB_PMFCNTB_BITNUM          0U


/*** PMFMODB - PMF Counter Modulo B Register; 0x0000022C ***/
typedef union {
  word Word;
  struct {
    word grpPMFMODB :15;
    word         :1;
  } MergedBits;
} PMFMODBSTR;
extern volatile PMFMODBSTR _PMFMODB @(REG_BASE + 0x0000022CUL);
#define PMFMODB                         _PMFMODB.Word
#define PMFMODB_PMFMODB                 _PMFMODB.MergedBits.grpPMFMODB

#define PMFMODB_PMFMODB_MASK            32767U
#define PMFMODB_PMFMODB_BITNUM          0U


/*** PMFDTMB - PMF Deadtime B Register; 0x0000022E ***/
typedef union {
  word Word;
  struct {
    word grpPMFDTMB :12;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} PMFDTMBSTR;
extern volatile PMFDTMBSTR _PMFDTMB @(REG_BASE + 0x0000022EUL);
#define PMFDTMB                         _PMFDTMB.Word
#define PMFDTMB_PMFDTMB                 _PMFDTMB.MergedBits.grpPMFDTMB

#define PMFDTMB_PMFDTMB_MASK            4095U
#define PMFDTMB_PMFDTMB_BITNUM          0U


/*** PMFENCC - PMF Enable Control C Register; 0x00000230 ***/
typedef union {
  byte Byte;
  struct {
    byte PWMRIEC     :1;                                       /* PWM Reload Interrupt Enable C */
    byte LDOKC       :1;                                       /* Load Okay C */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte PWMENC      :1;                                       /* PWM Generator C Enable */
  } Bits;
} PMFENCCSTR;
extern volatile PMFENCCSTR _PMFENCC @(REG_BASE + 0x00000230UL);
#define PMFENCC                         _PMFENCC.Byte
#define PMFENCC_PWMRIEC                 _PMFENCC.Bits.PWMRIEC
#define PMFENCC_LDOKC                   _PMFENCC.Bits.LDOKC
#define PMFENCC_PWMENC                  _PMFENCC.Bits.PWMENC

#define PMFENCC_PWMRIEC_MASK            1U
#define PMFENCC_LDOKC_MASK              2U
#define PMFENCC_PWMENC_MASK             128U


/*** PMFFQCC - PMF Frequency Control C Register; 0x00000231 ***/
typedef union {
  byte Byte;
  struct {
    byte PWMRFC      :1;                                       /* PWM Reload Flag C */
    byte PRSCC0      :1;                                       /* Prescaler C, bit 0 */
    byte PRSCC1      :1;                                       /* Prescaler C, bit 1 */
    byte HALFC       :1;                                       /* Half Cycle Reload C */
    byte LDFQC0      :1;                                       /* Load Frequency C, bit 0 */
    byte LDFQC1      :1;                                       /* Load Frequency C, bit 1 */
    byte LDFQC2      :1;                                       /* Load Frequency C, bit 2 */
    byte LDFQC3      :1;                                       /* Load Frequency C, bit 3 */
  } Bits;
  struct {
    byte         :1;
    byte grpPRSCC :2;
    byte         :1;
    byte grpLDFQC :4;
  } MergedBits;
} PMFFQCCSTR;
extern volatile PMFFQCCSTR _PMFFQCC @(REG_BASE + 0x00000231UL);
#define PMFFQCC                         _PMFFQCC.Byte
#define PMFFQCC_PWMRFC                  _PMFFQCC.Bits.PWMRFC
#define PMFFQCC_PRSCC0                  _PMFFQCC.Bits.PRSCC0
#define PMFFQCC_PRSCC1                  _PMFFQCC.Bits.PRSCC1
#define PMFFQCC_HALFC                   _PMFFQCC.Bits.HALFC
#define PMFFQCC_LDFQC0                  _PMFFQCC.Bits.LDFQC0
#define PMFFQCC_LDFQC1                  _PMFFQCC.Bits.LDFQC1
#define PMFFQCC_LDFQC2                  _PMFFQCC.Bits.LDFQC2
#define PMFFQCC_LDFQC3                  _PMFFQCC.Bits.LDFQC3
#define PMFFQCC_PRSCC                   _PMFFQCC.MergedBits.grpPRSCC
#define PMFFQCC_LDFQC                   _PMFFQCC.MergedBits.grpLDFQC

#define PMFFQCC_PWMRFC_MASK             1U
#define PMFFQCC_PRSCC0_MASK             2U
#define PMFFQCC_PRSCC1_MASK             4U
#define PMFFQCC_HALFC_MASK              8U
#define PMFFQCC_LDFQC0_MASK             16U
#define PMFFQCC_LDFQC1_MASK             32U
#define PMFFQCC_LDFQC2_MASK             64U
#define PMFFQCC_LDFQC3_MASK             128U
#define PMFFQCC_PRSCC_MASK              6U
#define PMFFQCC_PRSCC_BITNUM            1U
#define PMFFQCC_LDFQC_MASK              240U
#define PMFFQCC_LDFQC_BITNUM            4U


/*** PMFCNTC - PMF Counter C Register; 0x00000232 ***/
typedef union {
  word Word;
  struct {
    word grpPMFCNTC :15;
    word         :1;
  } MergedBits;
} PMFCNTCSTR;
extern volatile PMFCNTCSTR _PMFCNTC @(REG_BASE + 0x00000232UL);
#define PMFCNTC                         _PMFCNTC.Word
#define PMFCNTC_PMFCNTC                 _PMFCNTC.MergedBits.grpPMFCNTC

#define PMFCNTC_PMFCNTC_MASK            32767U
#define PMFCNTC_PMFCNTC_BITNUM          0U


/*** PMFMODC - PMF Counter Modulo C Register; 0x00000234 ***/
typedef union {
  word Word;
  struct {
    word grpPMFMODC :15;
    word         :1;
  } MergedBits;
} PMFMODCSTR;
extern volatile PMFMODCSTR _PMFMODC @(REG_BASE + 0x00000234UL);
#define PMFMODC                         _PMFMODC.Word
#define PMFMODC_PMFMODC                 _PMFMODC.MergedBits.grpPMFMODC

#define PMFMODC_PMFMODC_MASK            32767U
#define PMFMODC_PMFMODC_BITNUM          0U


/*** PMFDTMC - PMF Deadtime C Register; 0x00000236 ***/
typedef union {
  word Word;
  struct {
    word grpPMFDTMC :12;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} PMFDTMCSTR;
extern volatile PMFDTMCSTR _PMFDTMC @(REG_BASE + 0x00000236UL);
#define PMFDTMC                         _PMFDTMC.Word
#define PMFDTMC_PMFDTMC                 _PMFDTMC.MergedBits.grpPMFDTMC

#define PMFDTMC_PMFDTMC_MASK            4095U
#define PMFDTMC_PMFDTMC_BITNUM          0U


/*** PTT - Port T I/O Register; 0x00000240 ***/
typedef union {
  byte Byte;
  struct {
    byte PTT0        :1;                                       /* Port T Bit 0 */
    byte PTT1        :1;                                       /* Port T Bit 1 */
    byte PTT2        :1;                                       /* Port T Bit 2 */
    byte PTT3        :1;                                       /* Port T Bit 3 */
    byte PTT4        :1;                                       /* Port T Bit 4 */
    byte PTT5        :1;                                       /* Port T Bit 5 */
    byte PTT6        :1;                                       /* Port T Bit 6 */
    byte PTT7        :1;                                       /* Port T Bit 7 */
  } Bits;
} PTTSTR;
extern volatile PTTSTR _PTT @(REG_BASE + 0x00000240UL);
#define PTT                             _PTT.Byte
#define PTT_PTT0                        _PTT.Bits.PTT0
#define PTT_PTT1                        _PTT.Bits.PTT1
#define PTT_PTT2                        _PTT.Bits.PTT2
#define PTT_PTT3                        _PTT.Bits.PTT3
#define PTT_PTT4                        _PTT.Bits.PTT4
#define PTT_PTT5                        _PTT.Bits.PTT5
#define PTT_PTT6                        _PTT.Bits.PTT6
#define PTT_PTT7                        _PTT.Bits.PTT7

#define PTT_PTT0_MASK                   1U
#define PTT_PTT1_MASK                   2U
#define PTT_PTT2_MASK                   4U
#define PTT_PTT3_MASK                   8U
#define PTT_PTT4_MASK                   16U
#define PTT_PTT5_MASK                   32U
#define PTT_PTT6_MASK                   64U
#define PTT_PTT7_MASK                   128U


/*** PTIT - Port T Input Register; 0x00000241 ***/
typedef union {
  byte Byte;
  struct {
    byte PTIT0       :1;                                       /* Port T Bit 0 */
    byte PTIT1       :1;                                       /* Port T Bit 1 */
    byte PTIT2       :1;                                       /* Port T Bit 2 */
    byte PTIT3       :1;                                       /* Port T Bit 3 */
    byte PTIT4       :1;                                       /* Port T Bit 4 */
    byte PTIT5       :1;                                       /* Port T Bit 5 */
    byte PTIT6       :1;                                       /* Port T Bit 6 */
    byte PTIT7       :1;                                       /* Port T Bit 7 */
  } Bits;
} PTITSTR;
extern volatile PTITSTR _PTIT @(REG_BASE + 0x00000241UL);
#define PTIT                            _PTIT.Byte
#define PTIT_PTIT0                      _PTIT.Bits.PTIT0
#define PTIT_PTIT1                      _PTIT.Bits.PTIT1
#define PTIT_PTIT2                      _PTIT.Bits.PTIT2
#define PTIT_PTIT3                      _PTIT.Bits.PTIT3
#define PTIT_PTIT4                      _PTIT.Bits.PTIT4
#define PTIT_PTIT5                      _PTIT.Bits.PTIT5
#define PTIT_PTIT6                      _PTIT.Bits.PTIT6
#define PTIT_PTIT7                      _PTIT.Bits.PTIT7

#define PTIT_PTIT0_MASK                 1U
#define PTIT_PTIT1_MASK                 2U
#define PTIT_PTIT2_MASK                 4U
#define PTIT_PTIT3_MASK                 8U
#define PTIT_PTIT4_MASK                 16U
#define PTIT_PTIT5_MASK                 32U
#define PTIT_PTIT6_MASK                 64U
#define PTIT_PTIT7_MASK                 128U


/*** DDRT - Port T Data Direction Register; 0x00000242 ***/
typedef union {
  byte Byte;
  struct {
    byte DDRT0       :1;                                       /* Data Direction Port T Bit 0 */
    byte DDRT1       :1;                                       /* Data Direction Port T Bit 1 */
    byte DDRT2       :1;                                       /* Data Direction Port T Bit 2 */
    byte DDRT3       :1;                                       /* Data Direction Port T Bit 3 */
    byte DDRT4       :1;                                       /* Data Direction Port T Bit 4 */
    byte DDRT5       :1;                                       /* Data Direction Port T Bit 5 */
    byte DDRT6       :1;                                       /* Data Direction Port T Bit 6 */
    byte DDRT7       :1;                                       /* Data Direction Port T Bit 7 */
  } Bits;
} DDRTSTR;
extern volatile DDRTSTR _DDRT @(REG_BASE + 0x00000242UL);
#define DDRT                            _DDRT.Byte
#define DDRT_DDRT0                      _DDRT.Bits.DDRT0
#define DDRT_DDRT1                      _DDRT.Bits.DDRT1
#define DDRT_DDRT2                      _DDRT.Bits.DDRT2
#define DDRT_DDRT3                      _DDRT.Bits.DDRT3
#define DDRT_DDRT4                      _DDRT.Bits.DDRT4
#define DDRT_DDRT5                      _DDRT.Bits.DDRT5
#define DDRT_DDRT6                      _DDRT.Bits.DDRT6
#define DDRT_DDRT7                      _DDRT.Bits.DDRT7

#define DDRT_DDRT0_MASK                 1U
#define DDRT_DDRT1_MASK                 2U
#define DDRT_DDRT2_MASK                 4U
#define DDRT_DDRT3_MASK                 8U
#define DDRT_DDRT4_MASK                 16U
#define DDRT_DDRT5_MASK                 32U
#define DDRT_DDRT6_MASK                 64U
#define DDRT_DDRT7_MASK                 128U


/*** RDRT - Port T Reduced Drive Register; 0x00000243 ***/
typedef union {
  byte Byte;
  struct {
    byte RDRT0       :1;                                       /* Reduced Drive Port T Bit 0 */
    byte RDRT1       :1;                                       /* Reduced Drive Port T Bit 1 */
    byte RDRT2       :1;                                       /* Reduced Drive Port T Bit 2 */
    byte RDRT3       :1;                                       /* Reduced Drive Port T Bit 3 */
    byte RDRT4       :1;                                       /* Reduced Drive Port T Bit 4 */
    byte RDRT5       :1;                                       /* Reduced Drive Port T Bit 5 */
    byte RDRT6       :1;                                       /* Reduced Drive Port T Bit 6 */
    byte RDRT7       :1;                                       /* Reduced Drive Port T Bit 7 */
  } Bits;
} RDRTSTR;
extern volatile RDRTSTR _RDRT @(REG_BASE + 0x00000243UL);
#define RDRT                            _RDRT.Byte
#define RDRT_RDRT0                      _RDRT.Bits.RDRT0
#define RDRT_RDRT1                      _RDRT.Bits.RDRT1
#define RDRT_RDRT2                      _RDRT.Bits.RDRT2
#define RDRT_RDRT3                      _RDRT.Bits.RDRT3
#define RDRT_RDRT4                      _RDRT.Bits.RDRT4
#define RDRT_RDRT5                      _RDRT.Bits.RDRT5
#define RDRT_RDRT6                      _RDRT.Bits.RDRT6
#define RDRT_RDRT7                      _RDRT.Bits.RDRT7

#define RDRT_RDRT0_MASK                 1U
#define RDRT_RDRT1_MASK                 2U
#define RDRT_RDRT2_MASK                 4U
#define RDRT_RDRT3_MASK                 8U
#define RDRT_RDRT4_MASK                 16U
#define RDRT_RDRT5_MASK                 32U
#define RDRT_RDRT6_MASK                 64U
#define RDRT_RDRT7_MASK                 128U


/*** PERT - Port T Pull Device Enable Register; 0x00000244 ***/
typedef union {
  byte Byte;
  struct {
    byte PERT0       :1;                                       /* Pull Device Enable Port T Bit 0 */
    byte PERT1       :1;                                       /* Pull Device Enable Port T Bit 1 */
    byte PERT2       :1;                                       /* Pull Device Enable Port T Bit 2 */
    byte PERT3       :1;                                       /* Pull Device Enable Port T Bit 3 */
    byte PERT4       :1;                                       /* Pull Device Enable Port T Bit 4 */
    byte PERT5       :1;                                       /* Pull Device Enable Port T Bit 5 */
    byte PERT6       :1;                                       /* Pull Device Enable Port T Bit 6 */
    byte PERT7       :1;                                       /* Pull Device Enable Port T Bit 7 */
  } Bits;
} PERTSTR;
extern volatile PERTSTR _PERT @(REG_BASE + 0x00000244UL);
#define PERT                            _PERT.Byte
#define PERT_PERT0                      _PERT.Bits.PERT0
#define PERT_PERT1                      _PERT.Bits.PERT1
#define PERT_PERT2                      _PERT.Bits.PERT2
#define PERT_PERT3                      _PERT.Bits.PERT3
#define PERT_PERT4                      _PERT.Bits.PERT4
#define PERT_PERT5                      _PERT.Bits.PERT5
#define PERT_PERT6                      _PERT.Bits.PERT6
#define PERT_PERT7                      _PERT.Bits.PERT7

#define PERT_PERT0_MASK                 1U
#define PERT_PERT1_MASK                 2U
#define PERT_PERT2_MASK                 4U
#define PERT_PERT3_MASK                 8U
#define PERT_PERT4_MASK                 16U
#define PERT_PERT5_MASK                 32U
#define PERT_PERT6_MASK                 64U
#define PERT_PERT7_MASK                 128U


/*** PPST - Port T Polarity Select Register; 0x00000245 ***/
typedef union {
  byte Byte;
  struct {
    byte PPST0       :1;                                       /* Pull Select Port T Bit 0 */
    byte PPST1       :1;                                       /* Pull Select Port T Bit 1 */
    byte PPST2       :1;                                       /* Pull Select Port T Bit 2 */
    byte PPST3       :1;                                       /* Pull Select Port T Bit 3 */
    byte PPST4       :1;                                       /* Pull Select Port T Bit 4 */
    byte PPST5       :1;                                       /* Pull Select Port T Bit 5 */
    byte PPST6       :1;                                       /* Pull Select Port T Bit 6 */
    byte PPST7       :1;                                       /* Pull Select Port T Bit 7 */
  } Bits;
} PPSTSTR;
extern volatile PPSTSTR _PPST @(REG_BASE + 0x00000245UL);
#define PPST                            _PPST.Byte
#define PPST_PPST0                      _PPST.Bits.PPST0
#define PPST_PPST1                      _PPST.Bits.PPST1
#define PPST_PPST2                      _PPST.Bits.PPST2
#define PPST_PPST3                      _PPST.Bits.PPST3
#define PPST_PPST4                      _PPST.Bits.PPST4
#define PPST_PPST5                      _PPST.Bits.PPST5
#define PPST_PPST6                      _PPST.Bits.PPST6
#define PPST_PPST7                      _PPST.Bits.PPST7

#define PPST_PPST0_MASK                 1U
#define PPST_PPST1_MASK                 2U
#define PPST_PPST2_MASK                 4U
#define PPST_PPST3_MASK                 8U
#define PPST_PPST4_MASK                 16U
#define PPST_PPST5_MASK                 32U
#define PPST_PPST6_MASK                 64U
#define PPST_PPST7_MASK                 128U


/*** PTS - Port S I/O Register; 0x00000248 ***/
typedef union {
  byte Byte;
  struct {
    byte PTS0        :1;                                       /* Port S Bit 0 */
    byte PTS1        :1;                                       /* Port S Bit 1 */
    byte PTS2        :1;                                       /* Port S Bit 2 */
    byte PTS3        :1;                                       /* Port S Bit 3 */
    byte PTS4        :1;                                       /* Port S Bit 4 */
    byte PTS5        :1;                                       /* Port S Bit 5 */
    byte PTS6        :1;                                       /* Port S Bit 6 */
    byte PTS7        :1;                                       /* Port S Bit 7 */
  } Bits;
} PTSSTR;
extern volatile PTSSTR _PTS @(REG_BASE + 0x00000248UL);
#define PTS                             _PTS.Byte
#define PTS_PTS0                        _PTS.Bits.PTS0
#define PTS_PTS1                        _PTS.Bits.PTS1
#define PTS_PTS2                        _PTS.Bits.PTS2
#define PTS_PTS3                        _PTS.Bits.PTS3
#define PTS_PTS4                        _PTS.Bits.PTS4
#define PTS_PTS5                        _PTS.Bits.PTS5
#define PTS_PTS6                        _PTS.Bits.PTS6
#define PTS_PTS7                        _PTS.Bits.PTS7

#define PTS_PTS0_MASK                   1U
#define PTS_PTS1_MASK                   2U
#define PTS_PTS2_MASK                   4U
#define PTS_PTS3_MASK                   8U
#define PTS_PTS4_MASK                   16U
#define PTS_PTS5_MASK                   32U
#define PTS_PTS6_MASK                   64U
#define PTS_PTS7_MASK                   128U


/*** PTIS - Port S Input Register; 0x00000249 ***/
typedef union {
  byte Byte;
  struct {
    byte PTIS0       :1;                                       /* Port S Bit 0 */
    byte PTIS1       :1;                                       /* Port S Bit 1 */
    byte PTIS2       :1;                                       /* Port S Bit 2 */
    byte PTIS3       :1;                                       /* Port S Bit 3 */
    byte PTIS4       :1;                                       /* Port S Bit 4 */
    byte PTIS5       :1;                                       /* Port S Bit 5 */
    byte PTIS6       :1;                                       /* Port S Bit 6 */
    byte PTIS7       :1;                                       /* Port S Bit 7 */
  } Bits;
} PTISSTR;
extern volatile PTISSTR _PTIS @(REG_BASE + 0x00000249UL);
#define PTIS                            _PTIS.Byte
#define PTIS_PTIS0                      _PTIS.Bits.PTIS0
#define PTIS_PTIS1                      _PTIS.Bits.PTIS1
#define PTIS_PTIS2                      _PTIS.Bits.PTIS2
#define PTIS_PTIS3                      _PTIS.Bits.PTIS3
#define PTIS_PTIS4                      _PTIS.Bits.PTIS4
#define PTIS_PTIS5                      _PTIS.Bits.PTIS5
#define PTIS_PTIS6                      _PTIS.Bits.PTIS6
#define PTIS_PTIS7                      _PTIS.Bits.PTIS7

#define PTIS_PTIS0_MASK                 1U
#define PTIS_PTIS1_MASK                 2U
#define PTIS_PTIS2_MASK                 4U
#define PTIS_PTIS3_MASK                 8U
#define PTIS_PTIS4_MASK                 16U
#define PTIS_PTIS5_MASK                 32U
#define PTIS_PTIS6_MASK                 64U
#define PTIS_PTIS7_MASK                 128U


/*** DDRS - Port S Data Direction Register; 0x0000024A ***/
typedef union {
  byte Byte;
  struct {
    byte DDRS0       :1;                                       /* Data Direction Port S Bit 0 */
    byte DDRS1       :1;                                       /* Data Direction Port S Bit 1 */
    byte DDRS2       :1;                                       /* Data Direction Port S Bit 2 */
    byte DDRS3       :1;                                       /* Data Direction Port S Bit 3 */
    byte DDRS4       :1;                                       /* Data Direction Port S Bit 4 */
    byte DDRS5       :1;                                       /* Data Direction Port S Bit 5 */
    byte DDRS6       :1;                                       /* Data Direction Port S Bit 6 */
    byte DDRS7       :1;                                       /* Data Direction Port S Bit 7 */
  } Bits;
} DDRSSTR;
extern volatile DDRSSTR _DDRS @(REG_BASE + 0x0000024AUL);
#define DDRS                            _DDRS.Byte
#define DDRS_DDRS0                      _DDRS.Bits.DDRS0
#define DDRS_DDRS1                      _DDRS.Bits.DDRS1
#define DDRS_DDRS2                      _DDRS.Bits.DDRS2
#define DDRS_DDRS3                      _DDRS.Bits.DDRS3
#define DDRS_DDRS4                      _DDRS.Bits.DDRS4
#define DDRS_DDRS5                      _DDRS.Bits.DDRS5
#define DDRS_DDRS6                      _DDRS.Bits.DDRS6
#define DDRS_DDRS7                      _DDRS.Bits.DDRS7

#define DDRS_DDRS0_MASK                 1U
#define DDRS_DDRS1_MASK                 2U
#define DDRS_DDRS2_MASK                 4U
#define DDRS_DDRS3_MASK                 8U
#define DDRS_DDRS4_MASK                 16U
#define DDRS_DDRS5_MASK                 32U
#define DDRS_DDRS6_MASK                 64U
#define DDRS_DDRS7_MASK                 128U


/*** RDRS - Port S Reduced Drive Register; 0x0000024B ***/
typedef union {
  byte Byte;
  struct {
    byte RDRS0       :1;                                       /* Reduced Drive Port S Bit 0 */
    byte RDRS1       :1;                                       /* Reduced Drive Port S Bit 1 */
    byte RDRS2       :1;                                       /* Reduced Drive Port S Bit 2 */
    byte RDRS3       :1;                                       /* Reduced Drive Port S Bit 3 */
    byte RDRS4       :1;                                       /* Reduced Drive Port S Bit 4 */
    byte RDRS5       :1;                                       /* Reduced Drive Port S Bit 5 */
    byte RDRS6       :1;                                       /* Reduced Drive Port S Bit 6 */
    byte RDRS7       :1;                                       /* Reduced Drive Port S Bit 7 */
  } Bits;
} RDRSSTR;
extern volatile RDRSSTR _RDRS @(REG_BASE + 0x0000024BUL);
#define RDRS                            _RDRS.Byte
#define RDRS_RDRS0                      _RDRS.Bits.RDRS0
#define RDRS_RDRS1                      _RDRS.Bits.RDRS1
#define RDRS_RDRS2                      _RDRS.Bits.RDRS2
#define RDRS_RDRS3                      _RDRS.Bits.RDRS3
#define RDRS_RDRS4                      _RDRS.Bits.RDRS4
#define RDRS_RDRS5                      _RDRS.Bits.RDRS5
#define RDRS_RDRS6                      _RDRS.Bits.RDRS6
#define RDRS_RDRS7                      _RDRS.Bits.RDRS7

#define RDRS_RDRS0_MASK                 1U
#define RDRS_RDRS1_MASK                 2U
#define RDRS_RDRS2_MASK                 4U
#define RDRS_RDRS3_MASK                 8U
#define RDRS_RDRS4_MASK                 16U
#define RDRS_RDRS5_MASK                 32U
#define RDRS_RDRS6_MASK                 64U
#define RDRS_RDRS7_MASK                 128U


/*** PERS - Port S Pull Device Enable Register; 0x0000024C ***/
typedef union {
  byte Byte;
  struct {
    byte PERS0       :1;                                       /* Pull Device Enable Port S Bit 0 */
    byte PERS1       :1;                                       /* Pull Device Enable Port S Bit 1 */
    byte PERS2       :1;                                       /* Pull Device Enable Port S Bit 2 */
    byte PERS3       :1;                                       /* Pull Device Enable Port S Bit 3 */
    byte PERS4       :1;                                       /* Pull Device Enable Port S Bit 4 */
    byte PERS5       :1;                                       /* Pull Device Enable Port S Bit 5 */
    byte PERS6       :1;                                       /* Pull Device Enable Port S Bit 6 */
    byte PERS7       :1;                                       /* Pull Device Enable Port S Bit 7 */
  } Bits;
} PERSSTR;
extern volatile PERSSTR _PERS @(REG_BASE + 0x0000024CUL);
#define PERS                            _PERS.Byte
#define PERS_PERS0                      _PERS.Bits.PERS0
#define PERS_PERS1                      _PERS.Bits.PERS1
#define PERS_PERS2                      _PERS.Bits.PERS2
#define PERS_PERS3                      _PERS.Bits.PERS3
#define PERS_PERS4                      _PERS.Bits.PERS4
#define PERS_PERS5                      _PERS.Bits.PERS5
#define PERS_PERS6                      _PERS.Bits.PERS6
#define PERS_PERS7                      _PERS.Bits.PERS7

#define PERS_PERS0_MASK                 1U
#define PERS_PERS1_MASK                 2U
#define PERS_PERS2_MASK                 4U
#define PERS_PERS3_MASK                 8U
#define PERS_PERS4_MASK                 16U
#define PERS_PERS5_MASK                 32U
#define PERS_PERS6_MASK                 64U
#define PERS_PERS7_MASK                 128U


/*** PPSS - Port S Polarity Select Register; 0x0000024D ***/
typedef union {
  byte Byte;
  struct {
    byte PPSS0       :1;                                       /* Pull Select Port S Bit 0 */
    byte PPSS1       :1;                                       /* Pull Select Port S Bit 1 */
    byte PPSS2       :1;                                       /* Pull Select Port S Bit 2 */
    byte PPSS3       :1;                                       /* Pull Select Port S Bit 3 */
    byte PPSS4       :1;                                       /* Pull Select Port S Bit 4 */
    byte PPSS5       :1;                                       /* Pull Select Port S Bit 5 */
    byte PPSS6       :1;                                       /* Pull Select Port S Bit 6 */
    byte PPSS7       :1;                                       /* Pull Select Port S Bit 7 */
  } Bits;
} PPSSSTR;
extern volatile PPSSSTR _PPSS @(REG_BASE + 0x0000024DUL);
#define PPSS                            _PPSS.Byte
#define PPSS_PPSS0                      _PPSS.Bits.PPSS0
#define PPSS_PPSS1                      _PPSS.Bits.PPSS1
#define PPSS_PPSS2                      _PPSS.Bits.PPSS2
#define PPSS_PPSS3                      _PPSS.Bits.PPSS3
#define PPSS_PPSS4                      _PPSS.Bits.PPSS4
#define PPSS_PPSS5                      _PPSS.Bits.PPSS5
#define PPSS_PPSS6                      _PPSS.Bits.PPSS6
#define PPSS_PPSS7                      _PPSS.Bits.PPSS7

#define PPSS_PPSS0_MASK                 1U
#define PPSS_PPSS1_MASK                 2U
#define PPSS_PPSS2_MASK                 4U
#define PPSS_PPSS3_MASK                 8U
#define PPSS_PPSS4_MASK                 16U
#define PPSS_PPSS5_MASK                 32U
#define PPSS_PPSS6_MASK                 64U
#define PPSS_PPSS7_MASK                 128U


/*** WOMS - Port S Wired-Or Mode Register; 0x0000024E ***/
typedef union {
  byte Byte;
  struct {
    byte WOMS0       :1;                                       /* Wired-Or Mode Port S Bit 0 */
    byte WOMS1       :1;                                       /* Wired-Or Mode Port S Bit 1 */
    byte WOMS2       :1;                                       /* Wired-Or Mode Port S Bit 2 */
    byte WOMS3       :1;                                       /* Wired-Or Mode Port S Bit 3 */
    byte WOMS4       :1;                                       /* Wired-Or Mode Port S Bit 4 */
    byte WOMS5       :1;                                       /* Wired-Or Mode Port S Bit 5 */
    byte WOMS6       :1;                                       /* Wired-Or Mode Port S Bit 6 */
    byte WOMS7       :1;                                       /* Wired-Or Mode Port S Bit 7 */
  } Bits;
} WOMSSTR;
extern volatile WOMSSTR _WOMS @(REG_BASE + 0x0000024EUL);
#define WOMS                            _WOMS.Byte
#define WOMS_WOMS0                      _WOMS.Bits.WOMS0
#define WOMS_WOMS1                      _WOMS.Bits.WOMS1
#define WOMS_WOMS2                      _WOMS.Bits.WOMS2
#define WOMS_WOMS3                      _WOMS.Bits.WOMS3
#define WOMS_WOMS4                      _WOMS.Bits.WOMS4
#define WOMS_WOMS5                      _WOMS.Bits.WOMS5
#define WOMS_WOMS6                      _WOMS.Bits.WOMS6
#define WOMS_WOMS7                      _WOMS.Bits.WOMS7

#define WOMS_WOMS0_MASK                 1U
#define WOMS_WOMS1_MASK                 2U
#define WOMS_WOMS2_MASK                 4U
#define WOMS_WOMS3_MASK                 8U
#define WOMS_WOMS4_MASK                 16U
#define WOMS_WOMS5_MASK                 32U
#define WOMS_WOMS6_MASK                 64U
#define WOMS_WOMS7_MASK                 128U


/*** PTM - Port M I/O Register; 0x00000250 ***/
typedef union {
  byte Byte;
  struct {
    byte PTM0        :1;                                       /* Port M Bit 0 */
    byte PTM1        :1;                                       /* Port M Bit 1 */
    byte             :1; 
    byte PTM3        :1;                                       /* Port M Bit 3 */
    byte PTM4        :1;                                       /* Port M Bit 4 */
    byte PTM5        :1;                                       /* Port M Bit 5 */
    byte PTM6        :1;                                       /* Port M Bit 6 */
    byte PTM7        :1;                                       /* Port M Bit 7 */
  } Bits;
  struct {
    byte grpPTM  :2;
    byte         :1;
    byte grpPTM_3 :5;
  } MergedBits;
} PTMSTR;
extern volatile PTMSTR _PTM @(REG_BASE + 0x00000250UL);
#define PTM                             _PTM.Byte
#define PTM_PTM0                        _PTM.Bits.PTM0
#define PTM_PTM1                        _PTM.Bits.PTM1
#define PTM_PTM3                        _PTM.Bits.PTM3
#define PTM_PTM4                        _PTM.Bits.PTM4
#define PTM_PTM5                        _PTM.Bits.PTM5
#define PTM_PTM6                        _PTM.Bits.PTM6
#define PTM_PTM7                        _PTM.Bits.PTM7
#define PTM_PTM                         _PTM.MergedBits.grpPTM
#define PTM_PTM_3                       _PTM.MergedBits.grpPTM_3

#define PTM_PTM0_MASK                   1U
#define PTM_PTM1_MASK                   2U
#define PTM_PTM3_MASK                   8U
#define PTM_PTM4_MASK                   16U
#define PTM_PTM5_MASK                   32U
#define PTM_PTM6_MASK                   64U
#define PTM_PTM7_MASK                   128U
#define PTM_PTM_MASK                    3U
#define PTM_PTM_BITNUM                  0U
#define PTM_PTM_3_MASK                  248U
#define PTM_PTM_3_BITNUM                3U


/*** PTIM - Port M Input Register; 0x00000251 ***/
typedef union {
  byte Byte;
  struct {
    byte PTIM0       :1;                                       /* Port M Bit 0 */
    byte PTIM1       :1;                                       /* Port M Bit 1 */
    byte             :1; 
    byte PTIM3       :1;                                       /* Port M Bit 3 */
    byte PTIM4       :1;                                       /* Port M Bit 4 */
    byte PTIM5       :1;                                       /* Port M Bit 5 */
    byte PTIM6       :1;                                       /* Port M Bit 6 */
    byte PTIM7       :1;                                       /* Port M Bit 7 */
  } Bits;
  struct {
    byte grpPTIM :2;
    byte         :1;
    byte grpPTIM_3 :5;
  } MergedBits;
} PTIMSTR;
extern volatile PTIMSTR _PTIM @(REG_BASE + 0x00000251UL);
#define PTIM                            _PTIM.Byte
#define PTIM_PTIM0                      _PTIM.Bits.PTIM0
#define PTIM_PTIM1                      _PTIM.Bits.PTIM1
#define PTIM_PTIM3                      _PTIM.Bits.PTIM3
#define PTIM_PTIM4                      _PTIM.Bits.PTIM4
#define PTIM_PTIM5                      _PTIM.Bits.PTIM5
#define PTIM_PTIM6                      _PTIM.Bits.PTIM6
#define PTIM_PTIM7                      _PTIM.Bits.PTIM7
#define PTIM_PTIM                       _PTIM.MergedBits.grpPTIM
#define PTIM_PTIM_3                     _PTIM.MergedBits.grpPTIM_3

#define PTIM_PTIM0_MASK                 1U
#define PTIM_PTIM1_MASK                 2U
#define PTIM_PTIM3_MASK                 8U
#define PTIM_PTIM4_MASK                 16U
#define PTIM_PTIM5_MASK                 32U
#define PTIM_PTIM6_MASK                 64U
#define PTIM_PTIM7_MASK                 128U
#define PTIM_PTIM_MASK                  3U
#define PTIM_PTIM_BITNUM                0U
#define PTIM_PTIM_3_MASK                248U
#define PTIM_PTIM_3_BITNUM              3U


/*** DDRM - Port M Data Direction Register; 0x00000252 ***/
typedef union {
  byte Byte;
  struct {
    byte DDRM0       :1;                                       /* Data Direction Port M Bit 0 */
    byte DDRM1       :1;                                       /* Data Direction Port M Bit 1 */
    byte             :1; 
    byte DDRM3       :1;                                       /* Data Direction Port M Bit 3 */
    byte DDRM4       :1;                                       /* Data Direction Port M Bit 4 */
    byte DDRM5       :1;                                       /* Data Direction Port M Bit 5 */
    byte DDRM6       :1;                                       /* Data Direction Port M Bit 6 */
    byte DDRM7       :1;                                       /* Data Direction Port M Bit 7 */
  } Bits;
  struct {
    byte grpDDRM :2;
    byte         :1;
    byte grpDDRM_3 :5;
  } MergedBits;
} DDRMSTR;
extern volatile DDRMSTR _DDRM @(REG_BASE + 0x00000252UL);
#define DDRM                            _DDRM.Byte
#define DDRM_DDRM0                      _DDRM.Bits.DDRM0
#define DDRM_DDRM1                      _DDRM.Bits.DDRM1
#define DDRM_DDRM3                      _DDRM.Bits.DDRM3
#define DDRM_DDRM4                      _DDRM.Bits.DDRM4
#define DDRM_DDRM5                      _DDRM.Bits.DDRM5
#define DDRM_DDRM6                      _DDRM.Bits.DDRM6
#define DDRM_DDRM7                      _DDRM.Bits.DDRM7
#define DDRM_DDRM                       _DDRM.MergedBits.grpDDRM
#define DDRM_DDRM_3                     _DDRM.MergedBits.grpDDRM_3

#define DDRM_DDRM0_MASK                 1U
#define DDRM_DDRM1_MASK                 2U
#define DDRM_DDRM3_MASK                 8U
#define DDRM_DDRM4_MASK                 16U
#define DDRM_DDRM5_MASK                 32U
#define DDRM_DDRM6_MASK                 64U
#define DDRM_DDRM7_MASK                 128U
#define DDRM_DDRM_MASK                  3U
#define DDRM_DDRM_BITNUM                0U
#define DDRM_DDRM_3_MASK                248U
#define DDRM_DDRM_3_BITNUM              3U


/*** RDRM - Port M Reduced Drive Register; 0x00000253 ***/
typedef union {
  byte Byte;
  struct {
    byte RDRM0       :1;                                       /* Reduced Drive Port M Bit 0 */
    byte RDRM1       :1;                                       /* Reduced Drive Port M Bit 1 */
    byte             :1; 
    byte RDRM3       :1;                                       /* Reduced Drive Port M Bit 3 */
    byte RDRM4       :1;                                       /* Reduced Drive Port M Bit 4 */
    byte RDRM5       :1;                                       /* Reduced Drive Port M Bit 5 */
    byte RDRM6       :1;                                       /* Reduced Drive Port M Bit 6 */
    byte RDRM7       :1;                                       /* Reduced Drive Port M Bit 7 */
  } Bits;
  struct {
    byte grpRDRM :2;
    byte         :1;
    byte grpRDRM_3 :5;
  } MergedBits;
} RDRMSTR;
extern volatile RDRMSTR _RDRM @(REG_BASE + 0x00000253UL);
#define RDRM                            _RDRM.Byte
#define RDRM_RDRM0                      _RDRM.Bits.RDRM0
#define RDRM_RDRM1                      _RDRM.Bits.RDRM1
#define RDRM_RDRM3                      _RDRM.Bits.RDRM3
#define RDRM_RDRM4                      _RDRM.Bits.RDRM4
#define RDRM_RDRM5                      _RDRM.Bits.RDRM5
#define RDRM_RDRM6                      _RDRM.Bits.RDRM6
#define RDRM_RDRM7                      _RDRM.Bits.RDRM7
#define RDRM_RDRM                       _RDRM.MergedBits.grpRDRM
#define RDRM_RDRM_3                     _RDRM.MergedBits.grpRDRM_3

#define RDRM_RDRM0_MASK                 1U
#define RDRM_RDRM1_MASK                 2U
#define RDRM_RDRM3_MASK                 8U
#define RDRM_RDRM4_MASK                 16U
#define RDRM_RDRM5_MASK                 32U
#define RDRM_RDRM6_MASK                 64U
#define RDRM_RDRM7_MASK                 128U
#define RDRM_RDRM_MASK                  3U
#define RDRM_RDRM_BITNUM                0U
#define RDRM_RDRM_3_MASK                248U
#define RDRM_RDRM_3_BITNUM              3U


/*** PERM - Port M Pull Device Enable Register; 0x00000254 ***/
typedef union {
  byte Byte;
  struct {
    byte PERM0       :1;                                       /* Pull Device Enable Port M Bit 0 */
    byte PERM1       :1;                                       /* Pull Device Enable Port M Bit 1 */
    byte             :1; 
    byte PERM3       :1;                                       /* Pull Device Enable Port M Bit 3 */
    byte PERM4       :1;                                       /* Pull Device Enable Port M Bit 4 */
    byte PERM5       :1;                                       /* Pull Device Enable Port M Bit 5 */
    byte PERM6       :1;                                       /* Pull Device Enable Port M Bit 6 */
    byte PERM7       :1;                                       /* Pull Device Enable Port M Bit 7 */
  } Bits;
  struct {
    byte grpPERM :2;
    byte         :1;
    byte grpPERM_3 :5;
  } MergedBits;
} PERMSTR;
extern volatile PERMSTR _PERM @(REG_BASE + 0x00000254UL);
#define PERM                            _PERM.Byte
#define PERM_PERM0                      _PERM.Bits.PERM0
#define PERM_PERM1                      _PERM.Bits.PERM1
#define PERM_PERM3                      _PERM.Bits.PERM3
#define PERM_PERM4                      _PERM.Bits.PERM4
#define PERM_PERM5                      _PERM.Bits.PERM5
#define PERM_PERM6                      _PERM.Bits.PERM6
#define PERM_PERM7                      _PERM.Bits.PERM7
#define PERM_PERM                       _PERM.MergedBits.grpPERM
#define PERM_PERM_3                     _PERM.MergedBits.grpPERM_3

#define PERM_PERM0_MASK                 1U
#define PERM_PERM1_MASK                 2U
#define PERM_PERM3_MASK                 8U
#define PERM_PERM4_MASK                 16U
#define PERM_PERM5_MASK                 32U
#define PERM_PERM6_MASK                 64U
#define PERM_PERM7_MASK                 128U
#define PERM_PERM_MASK                  3U
#define PERM_PERM_BITNUM                0U
#define PERM_PERM_3_MASK                248U
#define PERM_PERM_3_BITNUM              3U


/*** PPSM - Port M Polarity Select Register; 0x00000255 ***/
typedef union {
  byte Byte;
  struct {
    byte PPSM0       :1;                                       /* Pull Select Port M Bit 0 */
    byte PPSM1       :1;                                       /* Pull Select Port M Bit 1 */
    byte             :1; 
    byte PPSM3       :1;                                       /* Pull Select Port M Bit 3 */
    byte PPSM4       :1;                                       /* Pull Select Port M Bit 4 */
    byte PPSM5       :1;                                       /* Pull Select Port M Bit 5 */
    byte PPSM6       :1;                                       /* Pull Select Port M Bit 6 */
    byte PPSM7       :1;                                       /* Pull Select Port M Bit 7 */
  } Bits;
  struct {
    byte grpPPSM :2;
    byte         :1;
    byte grpPPSM_3 :5;
  } MergedBits;
} PPSMSTR;
extern volatile PPSMSTR _PPSM @(REG_BASE + 0x00000255UL);
#define PPSM                            _PPSM.Byte
#define PPSM_PPSM0                      _PPSM.Bits.PPSM0
#define PPSM_PPSM1                      _PPSM.Bits.PPSM1
#define PPSM_PPSM3                      _PPSM.Bits.PPSM3
#define PPSM_PPSM4                      _PPSM.Bits.PPSM4
#define PPSM_PPSM5                      _PPSM.Bits.PPSM5
#define PPSM_PPSM6                      _PPSM.Bits.PPSM6
#define PPSM_PPSM7                      _PPSM.Bits.PPSM7
#define PPSM_PPSM                       _PPSM.MergedBits.grpPPSM
#define PPSM_PPSM_3                     _PPSM.MergedBits.grpPPSM_3

#define PPSM_PPSM0_MASK                 1U
#define PPSM_PPSM1_MASK                 2U
#define PPSM_PPSM3_MASK                 8U
#define PPSM_PPSM4_MASK                 16U
#define PPSM_PPSM5_MASK                 32U
#define PPSM_PPSM6_MASK                 64U
#define PPSM_PPSM7_MASK                 128U
#define PPSM_PPSM_MASK                  3U
#define PPSM_PPSM_BITNUM                0U
#define PPSM_PPSM_3_MASK                248U
#define PPSM_PPSM_3_BITNUM              3U


/*** WOMM - Port M Wired-Or Mode Register; 0x00000256 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte WOMM4       :1;                                       /* Wired-Or Mode Port M Bit 4 */
    byte WOMM5       :1;                                       /* Wired-Or Mode Port M Bit 5 */
    byte WOMM6       :1;                                       /* Wired-Or Mode Port M Bit 6 */
    byte WOMM7       :1;                                       /* Wired-Or Mode Port M Bit 7 */
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte grpWOMM_4 :4;
  } MergedBits;
} WOMMSTR;
extern volatile WOMMSTR _WOMM @(REG_BASE + 0x00000256UL);
#define WOMM                            _WOMM.Byte
#define WOMM_WOMM4                      _WOMM.Bits.WOMM4
#define WOMM_WOMM5                      _WOMM.Bits.WOMM5
#define WOMM_WOMM6                      _WOMM.Bits.WOMM6
#define WOMM_WOMM7                      _WOMM.Bits.WOMM7
#define WOMM_WOMM_4                     _WOMM.MergedBits.grpWOMM_4

#define WOMM_WOMM4_MASK                 16U
#define WOMM_WOMM5_MASK                 32U
#define WOMM_WOMM6_MASK                 64U
#define WOMM_WOMM7_MASK                 128U
#define WOMM_WOMM_4_MASK                240U
#define WOMM_WOMM_4_BITNUM              4U


/*** PTP - Port P I/O Register; 0x00000258 ***/
typedef union {
  byte Byte;
  struct {
    byte PTP0        :1;                                       /* Port P Bit 0 */
    byte PTP1        :1;                                       /* Port P Bit 1 */
    byte PTP2        :1;                                       /* Port P Bit 2 */
    byte PTP3        :1;                                       /* Port P Bit 3 */
    byte PTP4        :1;                                       /* Port P Bit 4 */
    byte PTP5        :1;                                       /* Port P Bit 5 */
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpPTP  :6;
    byte         :1;
    byte         :1;
  } MergedBits;
} PTPSTR;
extern volatile PTPSTR _PTP @(REG_BASE + 0x00000258UL);
#define PTP                             _PTP.Byte
#define PTP_PTP0                        _PTP.Bits.PTP0
#define PTP_PTP1                        _PTP.Bits.PTP1
#define PTP_PTP2                        _PTP.Bits.PTP2
#define PTP_PTP3                        _PTP.Bits.PTP3
#define PTP_PTP4                        _PTP.Bits.PTP4
#define PTP_PTP5                        _PTP.Bits.PTP5
#define PTP_PTP                         _PTP.MergedBits.grpPTP

#define PTP_PTP0_MASK                   1U
#define PTP_PTP1_MASK                   2U
#define PTP_PTP2_MASK                   4U
#define PTP_PTP3_MASK                   8U
#define PTP_PTP4_MASK                   16U
#define PTP_PTP5_MASK                   32U
#define PTP_PTP_MASK                    63U
#define PTP_PTP_BITNUM                  0U


/*** PTIP - Port P Input Register; 0x00000259 ***/
typedef union {
  byte Byte;
  struct {
    byte PTIP0       :1;                                       /* Port P Bit 0 */
    byte PTIP1       :1;                                       /* Port P Bit 1 */
    byte PTIP2       :1;                                       /* Port P Bit 2 */
    byte PTIP3       :1;                                       /* Port P Bit 3 */
    byte PTIP4       :1;                                       /* Port P Bit 4 */
    byte PTIP5       :1;                                       /* Port P Bit 5 */
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpPTIP :6;
    byte         :1;
    byte         :1;
  } MergedBits;
} PTIPSTR;
extern volatile PTIPSTR _PTIP @(REG_BASE + 0x00000259UL);
#define PTIP                            _PTIP.Byte
#define PTIP_PTIP0                      _PTIP.Bits.PTIP0
#define PTIP_PTIP1                      _PTIP.Bits.PTIP1
#define PTIP_PTIP2                      _PTIP.Bits.PTIP2
#define PTIP_PTIP3                      _PTIP.Bits.PTIP3
#define PTIP_PTIP4                      _PTIP.Bits.PTIP4
#define PTIP_PTIP5                      _PTIP.Bits.PTIP5
#define PTIP_PTIP                       _PTIP.MergedBits.grpPTIP

#define PTIP_PTIP0_MASK                 1U
#define PTIP_PTIP1_MASK                 2U
#define PTIP_PTIP2_MASK                 4U
#define PTIP_PTIP3_MASK                 8U
#define PTIP_PTIP4_MASK                 16U
#define PTIP_PTIP5_MASK                 32U
#define PTIP_PTIP_MASK                  63U
#define PTIP_PTIP_BITNUM                0U


/*** DDRP - Port P Data Direction Register; 0x0000025A ***/
typedef union {
  byte Byte;
  struct {
    byte DDRP0       :1;                                       /* Data Direction Port P Bit 0 */
    byte DDRP1       :1;                                       /* Data Direction Port P Bit 1 */
    byte DDRP2       :1;                                       /* Data Direction Port P Bit 2 */
    byte DDRP3       :1;                                       /* Data Direction Port P Bit 3 */
    byte DDRP4       :1;                                       /* Data Direction Port P Bit 4 */
    byte DDRP5       :1;                                       /* Data Direction Port P Bit 5 */
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpDDRP :6;
    byte         :1;
    byte         :1;
  } MergedBits;
} DDRPSTR;
extern volatile DDRPSTR _DDRP @(REG_BASE + 0x0000025AUL);
#define DDRP                            _DDRP.Byte
#define DDRP_DDRP0                      _DDRP.Bits.DDRP0
#define DDRP_DDRP1                      _DDRP.Bits.DDRP1
#define DDRP_DDRP2                      _DDRP.Bits.DDRP2
#define DDRP_DDRP3                      _DDRP.Bits.DDRP3
#define DDRP_DDRP4                      _DDRP.Bits.DDRP4
#define DDRP_DDRP5                      _DDRP.Bits.DDRP5
#define DDRP_DDRP                       _DDRP.MergedBits.grpDDRP

#define DDRP_DDRP0_MASK                 1U
#define DDRP_DDRP1_MASK                 2U
#define DDRP_DDRP2_MASK                 4U
#define DDRP_DDRP3_MASK                 8U
#define DDRP_DDRP4_MASK                 16U
#define DDRP_DDRP5_MASK                 32U
#define DDRP_DDRP_MASK                  63U
#define DDRP_DDRP_BITNUM                0U


/*** RDRP - Port P Reduced Drive Register; 0x0000025B ***/
typedef union {
  byte Byte;
  struct {
    byte RDRP0       :1;                                       /* Reduced Drive Port P Bit 0 */
    byte RDRP1       :1;                                       /* Reduced Drive Port P Bit 1 */
    byte RDRP2       :1;                                       /* Reduced Drive Port P Bit 2 */
    byte RDRP3       :1;                                       /* Reduced Drive Port P Bit 3 */
    byte RDRP4       :1;                                       /* Reduced Drive Port P Bit 4 */
    byte RDRP5       :1;                                       /* Reduced Drive Port P Bit 5 */
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpRDRP :6;
    byte         :1;
    byte         :1;
  } MergedBits;
} RDRPSTR;
extern volatile RDRPSTR _RDRP @(REG_BASE + 0x0000025BUL);
#define RDRP                            _RDRP.Byte
#define RDRP_RDRP0                      _RDRP.Bits.RDRP0
#define RDRP_RDRP1                      _RDRP.Bits.RDRP1
#define RDRP_RDRP2                      _RDRP.Bits.RDRP2
#define RDRP_RDRP3                      _RDRP.Bits.RDRP3
#define RDRP_RDRP4                      _RDRP.Bits.RDRP4
#define RDRP_RDRP5                      _RDRP.Bits.RDRP5
#define RDRP_RDRP                       _RDRP.MergedBits.grpRDRP

#define RDRP_RDRP0_MASK                 1U
#define RDRP_RDRP1_MASK                 2U
#define RDRP_RDRP2_MASK                 4U
#define RDRP_RDRP3_MASK                 8U
#define RDRP_RDRP4_MASK                 16U
#define RDRP_RDRP5_MASK                 32U
#define RDRP_RDRP_MASK                  63U
#define RDRP_RDRP_BITNUM                0U


/*** PERP - Port P Pull Device Enable Register; 0x0000025C ***/
typedef union {
  byte Byte;
  struct {
    byte PERP0       :1;                                       /* Pull Device Enable Port P Bit 0 */
    byte PERP1       :1;                                       /* Pull Device Enable Port P Bit 1 */
    byte PERP2       :1;                                       /* Pull Device Enable Port P Bit 2 */
    byte PERP3       :1;                                       /* Pull Device Enable Port P Bit 3 */
    byte PERP4       :1;                                       /* Pull Device Enable Port P Bit 4 */
    byte PERP5       :1;                                       /* Pull Device Enable Port P Bit 5 */
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpPERP :6;
    byte         :1;
    byte         :1;
  } MergedBits;
} PERPSTR;
extern volatile PERPSTR _PERP @(REG_BASE + 0x0000025CUL);
#define PERP                            _PERP.Byte
#define PERP_PERP0                      _PERP.Bits.PERP0
#define PERP_PERP1                      _PERP.Bits.PERP1
#define PERP_PERP2                      _PERP.Bits.PERP2
#define PERP_PERP3                      _PERP.Bits.PERP3
#define PERP_PERP4                      _PERP.Bits.PERP4
#define PERP_PERP5                      _PERP.Bits.PERP5
#define PERP_PERP                       _PERP.MergedBits.grpPERP

#define PERP_PERP0_MASK                 1U
#define PERP_PERP1_MASK                 2U
#define PERP_PERP2_MASK                 4U
#define PERP_PERP3_MASK                 8U
#define PERP_PERP4_MASK                 16U
#define PERP_PERP5_MASK                 32U
#define PERP_PERP_MASK                  63U
#define PERP_PERP_BITNUM                0U


/*** PPSP - Port P Polarity Select Register; 0x0000025D ***/
typedef union {
  byte Byte;
  struct {
    byte PPSP0       :1;                                       /* Pull Select Port P Bit 0 */
    byte PPSP1       :1;                                       /* Pull Select Port P Bit 1 */
    byte PPSP2       :1;                                       /* Pull Select Port P Bit 2 */
    byte PPSP3       :1;                                       /* Pull Select Port P Bit 3 */
    byte PPSP4       :1;                                       /* Pull Select Port P Bit 4 */
    byte PPSP5       :1;                                       /* Pull Select Port P Bit 5 */
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpPPSP :6;
    byte         :1;
    byte         :1;
  } MergedBits;
} PPSPSTR;
extern volatile PPSPSTR _PPSP @(REG_BASE + 0x0000025DUL);
#define PPSP                            _PPSP.Byte
#define PPSP_PPSP0                      _PPSP.Bits.PPSP0
#define PPSP_PPSP1                      _PPSP.Bits.PPSP1
#define PPSP_PPSP2                      _PPSP.Bits.PPSP2
#define PPSP_PPSP3                      _PPSP.Bits.PPSP3
#define PPSP_PPSP4                      _PPSP.Bits.PPSP4
#define PPSP_PPSP5                      _PPSP.Bits.PPSP5
#define PPSP_PPSP                       _PPSP.MergedBits.grpPPSP

#define PPSP_PPSP0_MASK                 1U
#define PPSP_PPSP1_MASK                 2U
#define PPSP_PPSP2_MASK                 4U
#define PPSP_PPSP3_MASK                 8U
#define PPSP_PPSP4_MASK                 16U
#define PPSP_PPSP5_MASK                 32U
#define PPSP_PPSP_MASK                  63U
#define PPSP_PPSP_BITNUM                0U


/*** PTQ - Port Q I/O Register; 0x00000260 ***/
typedef union {
  byte Byte;
  struct {
    byte PTQ0        :1;                                       /* Port Q Bit 0 */
    byte PTQ1        :1;                                       /* Port Q Bit 1 */
    byte PTQ2        :1;                                       /* Port Q Bit 2 */
    byte PTQ3        :1;                                       /* Port Q Bit 3 */
    byte PTQ4        :1;                                       /* Port Q Bit 4 */
    byte PTQ5        :1;                                       /* Port Q Bit 5 */
    byte PTQ6        :1;                                       /* Port Q Bit 6 */
    byte             :1; 
  } Bits;
  struct {
    byte grpPTQ  :7;
    byte         :1;
  } MergedBits;
} PTQSTR;
extern volatile PTQSTR _PTQ @(REG_BASE + 0x00000260UL);
#define PTQ                             _PTQ.Byte
#define PTQ_PTQ0                        _PTQ.Bits.PTQ0
#define PTQ_PTQ1                        _PTQ.Bits.PTQ1
#define PTQ_PTQ2                        _PTQ.Bits.PTQ2
#define PTQ_PTQ3                        _PTQ.Bits.PTQ3
#define PTQ_PTQ4                        _PTQ.Bits.PTQ4
#define PTQ_PTQ5                        _PTQ.Bits.PTQ5
#define PTQ_PTQ6                        _PTQ.Bits.PTQ6
#define PTQ_PTQ                         _PTQ.MergedBits.grpPTQ

#define PTQ_PTQ0_MASK                   1U
#define PTQ_PTQ1_MASK                   2U
#define PTQ_PTQ2_MASK                   4U
#define PTQ_PTQ3_MASK                   8U
#define PTQ_PTQ4_MASK                   16U
#define PTQ_PTQ5_MASK                   32U
#define PTQ_PTQ6_MASK                   64U
#define PTQ_PTQ_MASK                    127U
#define PTQ_PTQ_BITNUM                  0U


/*** PTIQ - Port Q Input Register; 0x00000261 ***/
typedef union {
  byte Byte;
  struct {
    byte PTIQ0       :1;                                       /* Port Q Bit 0 */
    byte PTIQ1       :1;                                       /* Port Q Bit 1 */
    byte PTIQ2       :1;                                       /* Port Q Bit 2 */
    byte PTIQ3       :1;                                       /* Port Q Bit 3 */
    byte PTIQ4       :1;                                       /* Port Q Bit 4 */
    byte PTIQ5       :1;                                       /* Port Q Bit 5 */
    byte PTIQ6       :1;                                       /* Port Q Bit 6 */
    byte             :1; 
  } Bits;
  struct {
    byte grpPTIQ :7;
    byte         :1;
  } MergedBits;
} PTIQSTR;
extern volatile PTIQSTR _PTIQ @(REG_BASE + 0x00000261UL);
#define PTIQ                            _PTIQ.Byte
#define PTIQ_PTIQ0                      _PTIQ.Bits.PTIQ0
#define PTIQ_PTIQ1                      _PTIQ.Bits.PTIQ1
#define PTIQ_PTIQ2                      _PTIQ.Bits.PTIQ2
#define PTIQ_PTIQ3                      _PTIQ.Bits.PTIQ3
#define PTIQ_PTIQ4                      _PTIQ.Bits.PTIQ4
#define PTIQ_PTIQ5                      _PTIQ.Bits.PTIQ5
#define PTIQ_PTIQ6                      _PTIQ.Bits.PTIQ6
#define PTIQ_PTIQ                       _PTIQ.MergedBits.grpPTIQ

#define PTIQ_PTIQ0_MASK                 1U
#define PTIQ_PTIQ1_MASK                 2U
#define PTIQ_PTIQ2_MASK                 4U
#define PTIQ_PTIQ3_MASK                 8U
#define PTIQ_PTIQ4_MASK                 16U
#define PTIQ_PTIQ5_MASK                 32U
#define PTIQ_PTIQ6_MASK                 64U
#define PTIQ_PTIQ_MASK                  127U
#define PTIQ_PTIQ_BITNUM                0U


/*** DDRQ - Port Q Data Direction Register; 0x00000262 ***/
typedef union {
  byte Byte;
  struct {
    byte DDRQ0       :1;                                       /* Data Direction Port Q Bit 0 */
    byte DDRQ1       :1;                                       /* Data Direction Port Q Bit 1 */
    byte DDRQ2       :1;                                       /* Data Direction Port Q Bit 2 */
    byte DDRQ3       :1;                                       /* Data Direction Port Q Bit 3 */
    byte DDRQ4       :1;                                       /* Data Direction Port Q Bit 4 */
    byte DDRQ5       :1;                                       /* Data Direction Port Q Bit 5 */
    byte DDRQ6       :1;                                       /* Data Direction Port Q Bit 6 */
    byte             :1; 
  } Bits;
  struct {
    byte grpDDRQ :7;
    byte         :1;
  } MergedBits;
} DDRQSTR;
extern volatile DDRQSTR _DDRQ @(REG_BASE + 0x00000262UL);
#define DDRQ                            _DDRQ.Byte
#define DDRQ_DDRQ0                      _DDRQ.Bits.DDRQ0
#define DDRQ_DDRQ1                      _DDRQ.Bits.DDRQ1
#define DDRQ_DDRQ2                      _DDRQ.Bits.DDRQ2
#define DDRQ_DDRQ3                      _DDRQ.Bits.DDRQ3
#define DDRQ_DDRQ4                      _DDRQ.Bits.DDRQ4
#define DDRQ_DDRQ5                      _DDRQ.Bits.DDRQ5
#define DDRQ_DDRQ6                      _DDRQ.Bits.DDRQ6
#define DDRQ_DDRQ                       _DDRQ.MergedBits.grpDDRQ

#define DDRQ_DDRQ0_MASK                 1U
#define DDRQ_DDRQ1_MASK                 2U
#define DDRQ_DDRQ2_MASK                 4U
#define DDRQ_DDRQ3_MASK                 8U
#define DDRQ_DDRQ4_MASK                 16U
#define DDRQ_DDRQ5_MASK                 32U
#define DDRQ_DDRQ6_MASK                 64U
#define DDRQ_DDRQ_MASK                  127U
#define DDRQ_DDRQ_BITNUM                0U


/*** RDRQ - Port Q Reduced Drive Register; 0x00000263 ***/
typedef union {
  byte Byte;
  struct {
    byte RDRQ0       :1;                                       /* Reduced Drive Port Q Bit 0 */
    byte RDRQ1       :1;                                       /* Reduced Drive Port Q Bit 1 */
    byte RDRQ2       :1;                                       /* Reduced Drive Port Q Bit 2 */
    byte RDRQ3       :1;                                       /* Reduced Drive Port Q Bit 3 */
    byte RDRQ4       :1;                                       /* Reduced Drive Port Q Bit 4 */
    byte RDRQ5       :1;                                       /* Reduced Drive Port Q Bit 5 */
    byte RDRQ6       :1;                                       /* Reduced Drive Port Q Bit 6 */
    byte             :1; 
  } Bits;
  struct {
    byte grpRDRQ :7;
    byte         :1;
  } MergedBits;
} RDRQSTR;
extern volatile RDRQSTR _RDRQ @(REG_BASE + 0x00000263UL);
#define RDRQ                            _RDRQ.Byte
#define RDRQ_RDRQ0                      _RDRQ.Bits.RDRQ0
#define RDRQ_RDRQ1                      _RDRQ.Bits.RDRQ1
#define RDRQ_RDRQ2                      _RDRQ.Bits.RDRQ2
#define RDRQ_RDRQ3                      _RDRQ.Bits.RDRQ3
#define RDRQ_RDRQ4                      _RDRQ.Bits.RDRQ4
#define RDRQ_RDRQ5                      _RDRQ.Bits.RDRQ5
#define RDRQ_RDRQ6                      _RDRQ.Bits.RDRQ6
#define RDRQ_RDRQ                       _RDRQ.MergedBits.grpRDRQ

#define RDRQ_RDRQ0_MASK                 1U
#define RDRQ_RDRQ1_MASK                 2U
#define RDRQ_RDRQ2_MASK                 4U
#define RDRQ_RDRQ3_MASK                 8U
#define RDRQ_RDRQ4_MASK                 16U
#define RDRQ_RDRQ5_MASK                 32U
#define RDRQ_RDRQ6_MASK                 64U
#define RDRQ_RDRQ_MASK                  127U
#define RDRQ_RDRQ_BITNUM                0U


/*** PERQ - Port Q Pull Device Enable Register; 0x00000264 ***/
typedef union {
  byte Byte;
  struct {
    byte PERQ0       :1;                                       /* Pull Device Enable Port Q Bit 0 */
    byte PERQ1       :1;                                       /* Pull Device Enable Port Q Bit 1 */
    byte PERQ2       :1;                                       /* Pull Device Enable Port Q Bit 2 */
    byte PERQ3       :1;                                       /* Pull Device Enable Port Q Bit 3 */
    byte PERQ4       :1;                                       /* Pull Device Enable Port Q Bit 4 */
    byte PERQ5       :1;                                       /* Pull Device Enable Port Q Bit 5 */
    byte PERQ6       :1;                                       /* Pull Device Enable Port Q Bit 6 */
    byte             :1; 
  } Bits;
  struct {
    byte grpPERQ :7;
    byte         :1;
  } MergedBits;
} PERQSTR;
extern volatile PERQSTR _PERQ @(REG_BASE + 0x00000264UL);
#define PERQ                            _PERQ.Byte
#define PERQ_PERQ0                      _PERQ.Bits.PERQ0
#define PERQ_PERQ1                      _PERQ.Bits.PERQ1
#define PERQ_PERQ2                      _PERQ.Bits.PERQ2
#define PERQ_PERQ3                      _PERQ.Bits.PERQ3
#define PERQ_PERQ4                      _PERQ.Bits.PERQ4
#define PERQ_PERQ5                      _PERQ.Bits.PERQ5
#define PERQ_PERQ6                      _PERQ.Bits.PERQ6
#define PERQ_PERQ                       _PERQ.MergedBits.grpPERQ

#define PERQ_PERQ0_MASK                 1U
#define PERQ_PERQ1_MASK                 2U
#define PERQ_PERQ2_MASK                 4U
#define PERQ_PERQ3_MASK                 8U
#define PERQ_PERQ4_MASK                 16U
#define PERQ_PERQ5_MASK                 32U
#define PERQ_PERQ6_MASK                 64U
#define PERQ_PERQ_MASK                  127U
#define PERQ_PERQ_BITNUM                0U


/*** PPSQ - Port Q Polarity Select Register; 0x00000265 ***/
typedef union {
  byte Byte;
  struct {
    byte PPSQ0       :1;                                       /* Pull Select Port Q Bit 0 */
    byte PPSQ1       :1;                                       /* Pull Select Port Q Bit 1 */
    byte PPSQ2       :1;                                       /* Pull Select Port Q Bit 2 */
    byte PPSQ3       :1;                                       /* Pull Select Port Q Bit 3 */
    byte PPSQ4       :1;                                       /* Pull Select Port Q Bit 4 */
    byte PPSQ5       :1;                                       /* Pull Select Port Q Bit 5 */
    byte PPSQ6       :1;                                       /* Pull Select Port Q Bit 6 */
    byte             :1; 
  } Bits;
  struct {
    byte grpPPSQ :7;
    byte         :1;
  } MergedBits;
} PPSQSTR;
extern volatile PPSQSTR _PPSQ @(REG_BASE + 0x00000265UL);
#define PPSQ                            _PPSQ.Byte
#define PPSQ_PPSQ0                      _PPSQ.Bits.PPSQ0
#define PPSQ_PPSQ1                      _PPSQ.Bits.PPSQ1
#define PPSQ_PPSQ2                      _PPSQ.Bits.PPSQ2
#define PPSQ_PPSQ3                      _PPSQ.Bits.PPSQ3
#define PPSQ_PPSQ4                      _PPSQ.Bits.PPSQ4
#define PPSQ_PPSQ5                      _PPSQ.Bits.PPSQ5
#define PPSQ_PPSQ6                      _PPSQ.Bits.PPSQ6
#define PPSQ_PPSQ                       _PPSQ.MergedBits.grpPPSQ

#define PPSQ_PPSQ0_MASK                 1U
#define PPSQ_PPSQ1_MASK                 2U
#define PPSQ_PPSQ2_MASK                 4U
#define PPSQ_PPSQ3_MASK                 8U
#define PPSQ_PPSQ4_MASK                 16U
#define PPSQ_PPSQ5_MASK                 32U
#define PPSQ_PPSQ6_MASK                 64U
#define PPSQ_PPSQ_MASK                  127U
#define PPSQ_PPSQ_BITNUM                0U


/*** PTU - Port U I/O Register; 0x00000268 ***/
typedef union {
  byte Byte;
  struct {
    byte PTU0        :1;                                       /* Port U Bit 0 */
    byte PTU1        :1;                                       /* Port U Bit 1 */
    byte PTU2        :1;                                       /* Port U Bit 2 */
    byte PTU3        :1;                                       /* Port U Bit 3 */
    byte PTU4        :1;                                       /* Port U Bit 4 */
    byte PTU5        :1;                                       /* Port U Bit 5 */
    byte PTU6        :1;                                       /* Port U Bit 6 */
    byte PTU7        :1;                                       /* Port U Bit 7 */
  } Bits;
} PTUSTR;
extern volatile PTUSTR _PTU @(REG_BASE + 0x00000268UL);
#define PTU                             _PTU.Byte
#define PTU_PTU0                        _PTU.Bits.PTU0
#define PTU_PTU1                        _PTU.Bits.PTU1
#define PTU_PTU2                        _PTU.Bits.PTU2
#define PTU_PTU3                        _PTU.Bits.PTU3
#define PTU_PTU4                        _PTU.Bits.PTU4
#define PTU_PTU5                        _PTU.Bits.PTU5
#define PTU_PTU6                        _PTU.Bits.PTU6
#define PTU_PTU7                        _PTU.Bits.PTU7

#define PTU_PTU0_MASK                   1U
#define PTU_PTU1_MASK                   2U
#define PTU_PTU2_MASK                   4U
#define PTU_PTU3_MASK                   8U
#define PTU_PTU4_MASK                   16U
#define PTU_PTU5_MASK                   32U
#define PTU_PTU6_MASK                   64U
#define PTU_PTU7_MASK                   128U


/*** PTIU - Port U Input Register; 0x00000269 ***/
typedef union {
  byte Byte;
  struct {
    byte PTIU0       :1;                                       /* Port U Bit 0 */
    byte PTIU1       :1;                                       /* Port U Bit 1 */
    byte PTIU2       :1;                                       /* Port U Bit 2 */
    byte PTIU3       :1;                                       /* Port U Bit 3 */
    byte PTIU4       :1;                                       /* Port U Bit 4 */
    byte PTIU5       :1;                                       /* Port U Bit 5 */
    byte PTIU6       :1;                                       /* Port U Bit 6 */
    byte PTIU7       :1;                                       /* Port U Bit 7 */
  } Bits;
} PTIUSTR;
extern volatile PTIUSTR _PTIU @(REG_BASE + 0x00000269UL);
#define PTIU                            _PTIU.Byte
#define PTIU_PTIU0                      _PTIU.Bits.PTIU0
#define PTIU_PTIU1                      _PTIU.Bits.PTIU1
#define PTIU_PTIU2                      _PTIU.Bits.PTIU2
#define PTIU_PTIU3                      _PTIU.Bits.PTIU3
#define PTIU_PTIU4                      _PTIU.Bits.PTIU4
#define PTIU_PTIU5                      _PTIU.Bits.PTIU5
#define PTIU_PTIU6                      _PTIU.Bits.PTIU6
#define PTIU_PTIU7                      _PTIU.Bits.PTIU7

#define PTIU_PTIU0_MASK                 1U
#define PTIU_PTIU1_MASK                 2U
#define PTIU_PTIU2_MASK                 4U
#define PTIU_PTIU3_MASK                 8U
#define PTIU_PTIU4_MASK                 16U
#define PTIU_PTIU5_MASK                 32U
#define PTIU_PTIU6_MASK                 64U
#define PTIU_PTIU7_MASK                 128U


/*** DDRU - Port U Data Direction Register; 0x0000026A ***/
typedef union {
  byte Byte;
  struct {
    byte DDRU0       :1;                                       /* Data Direction Port U Bit 0 */
    byte DDRU1       :1;                                       /* Data Direction Port U Bit 1 */
    byte DDRU2       :1;                                       /* Data Direction Port U Bit 2 */
    byte DDRU3       :1;                                       /* Data Direction Port U Bit 3 */
    byte DDRU4       :1;                                       /* Data Direction Port U Bit 4 */
    byte DDRU5       :1;                                       /* Data Direction Port U Bit 5 */
    byte DDRU6       :1;                                       /* Data Direction Port U Bit 6 */
    byte DDRU7       :1;                                       /* Data Direction Port U Bit 7 */
  } Bits;
} DDRUSTR;
extern volatile DDRUSTR _DDRU @(REG_BASE + 0x0000026AUL);
#define DDRU                            _DDRU.Byte
#define DDRU_DDRU0                      _DDRU.Bits.DDRU0
#define DDRU_DDRU1                      _DDRU.Bits.DDRU1
#define DDRU_DDRU2                      _DDRU.Bits.DDRU2
#define DDRU_DDRU3                      _DDRU.Bits.DDRU3
#define DDRU_DDRU4                      _DDRU.Bits.DDRU4
#define DDRU_DDRU5                      _DDRU.Bits.DDRU5
#define DDRU_DDRU6                      _DDRU.Bits.DDRU6
#define DDRU_DDRU7                      _DDRU.Bits.DDRU7

#define DDRU_DDRU0_MASK                 1U
#define DDRU_DDRU1_MASK                 2U
#define DDRU_DDRU2_MASK                 4U
#define DDRU_DDRU3_MASK                 8U
#define DDRU_DDRU4_MASK                 16U
#define DDRU_DDRU5_MASK                 32U
#define DDRU_DDRU6_MASK                 64U
#define DDRU_DDRU7_MASK                 128U


/*** RDRU - Port U Reduced Drive Register; 0x0000026B ***/
typedef union {
  byte Byte;
  struct {
    byte RDRU0       :1;                                       /* Reduced Drive Port U Bit 0 */
    byte RDRU1       :1;                                       /* Reduced Drive Port U Bit 1 */
    byte RDRU2       :1;                                       /* Reduced Drive Port U Bit 2 */
    byte RDRU3       :1;                                       /* Reduced Drive Port U Bit 3 */
    byte RDRU4       :1;                                       /* Reduced Drive Port U Bit 4 */
    byte RDRU5       :1;                                       /* Reduced Drive Port U Bit 5 */
    byte RDRU6       :1;                                       /* Reduced Drive Port U Bit 6 */
    byte RDRU7       :1;                                       /* Reduced Drive Port U Bit 7 */
  } Bits;
} RDRUSTR;
extern volatile RDRUSTR _RDRU @(REG_BASE + 0x0000026BUL);
#define RDRU                            _RDRU.Byte
#define RDRU_RDRU0                      _RDRU.Bits.RDRU0
#define RDRU_RDRU1                      _RDRU.Bits.RDRU1
#define RDRU_RDRU2                      _RDRU.Bits.RDRU2
#define RDRU_RDRU3                      _RDRU.Bits.RDRU3
#define RDRU_RDRU4                      _RDRU.Bits.RDRU4
#define RDRU_RDRU5                      _RDRU.Bits.RDRU5
#define RDRU_RDRU6                      _RDRU.Bits.RDRU6
#define RDRU_RDRU7                      _RDRU.Bits.RDRU7

#define RDRU_RDRU0_MASK                 1U
#define RDRU_RDRU1_MASK                 2U
#define RDRU_RDRU2_MASK                 4U
#define RDRU_RDRU3_MASK                 8U
#define RDRU_RDRU4_MASK                 16U
#define RDRU_RDRU5_MASK                 32U
#define RDRU_RDRU6_MASK                 64U
#define RDRU_RDRU7_MASK                 128U


/*** PERU - Port U Pull Device Enable Register; 0x0000026C ***/
typedef union {
  byte Byte;
  struct {
    byte PERU0       :1;                                       /* Pull Device Enable Port U Bit 0 */
    byte PERU1       :1;                                       /* Pull Device Enable Port U Bit 1 */
    byte PERU2       :1;                                       /* Pull Device Enable Port U Bit 2 */
    byte PERU3       :1;                                       /* Pull Device Enable Port U Bit 3 */
    byte PERU4       :1;                                       /* Pull Device Enable Port U Bit 4 */
    byte PERU5       :1;                                       /* Pull Device Enable Port U Bit 5 */
    byte PERU6       :1;                                       /* Pull Device Enable Port U Bit 6 */
    byte PERU7       :1;                                       /* Pull Device Enable Port U Bit 7 */
  } Bits;
} PERUSTR;
extern volatile PERUSTR _PERU @(REG_BASE + 0x0000026CUL);
#define PERU                            _PERU.Byte
#define PERU_PERU0                      _PERU.Bits.PERU0
#define PERU_PERU1                      _PERU.Bits.PERU1
#define PERU_PERU2                      _PERU.Bits.PERU2
#define PERU_PERU3                      _PERU.Bits.PERU3
#define PERU_PERU4                      _PERU.Bits.PERU4
#define PERU_PERU5                      _PERU.Bits.PERU5
#define PERU_PERU6                      _PERU.Bits.PERU6
#define PERU_PERU7                      _PERU.Bits.PERU7

#define PERU_PERU0_MASK                 1U
#define PERU_PERU1_MASK                 2U
#define PERU_PERU2_MASK                 4U
#define PERU_PERU3_MASK                 8U
#define PERU_PERU4_MASK                 16U
#define PERU_PERU5_MASK                 32U
#define PERU_PERU6_MASK                 64U
#define PERU_PERU7_MASK                 128U


/*** PPSU - Port U Polarity Select Register; 0x0000026D ***/
typedef union {
  byte Byte;
  struct {
    byte PPSU0       :1;                                       /* Pull Select Port U Bit 0 */
    byte PPSU1       :1;                                       /* Pull Select Port U Bit 1 */
    byte PPSU2       :1;                                       /* Pull Select Port U Bit 2 */
    byte PPSU3       :1;                                       /* Pull Select Port U Bit 3 */
    byte PPSU4       :1;                                       /* Pull Select Port U Bit 4 */
    byte PPSU5       :1;                                       /* Pull Select Port U Bit 5 */
    byte PPSU6       :1;                                       /* Pull Select Port U Bit 6 */
    byte PPSU7       :1;                                       /* Pull Select Port U Bit 7 */
  } Bits;
} PPSUSTR;
extern volatile PPSUSTR _PPSU @(REG_BASE + 0x0000026DUL);
#define PPSU                            _PPSU.Byte
#define PPSU_PPSU0                      _PPSU.Bits.PPSU0
#define PPSU_PPSU1                      _PPSU.Bits.PPSU1
#define PPSU_PPSU2                      _PPSU.Bits.PPSU2
#define PPSU_PPSU3                      _PPSU.Bits.PPSU3
#define PPSU_PPSU4                      _PPSU.Bits.PPSU4
#define PPSU_PPSU5                      _PPSU.Bits.PPSU5
#define PPSU_PPSU6                      _PPSU.Bits.PPSU6
#define PPSU_PPSU7                      _PPSU.Bits.PPSU7

#define PPSU_PPSU0_MASK                 1U
#define PPSU_PPSU1_MASK                 2U
#define PPSU_PPSU2_MASK                 4U
#define PPSU_PPSU3_MASK                 8U
#define PPSU_PPSU4_MASK                 16U
#define PPSU_PPSU5_MASK                 32U
#define PPSU_PPSU6_MASK                 64U
#define PPSU_PPSU7_MASK                 128U


/*** MODRR - Module Routing Register; 0x0000026E ***/
typedef union {
  byte Byte;
  struct {
    byte MODRR0      :1;                                       /* Module Routing Bit 0 */
    byte MODRR1      :1;                                       /* Module Routing Bit 1 */
    byte MODRR2      :1;                                       /* Module Routing Bit 2 */
    byte MODRR3      :1;                                       /* Module Routing Bit 3 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpMODRR :4;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} MODRRSTR;
extern volatile MODRRSTR _MODRR @(REG_BASE + 0x0000026EUL);
#define MODRR                           _MODRR.Byte
#define MODRR_MODRR0                    _MODRR.Bits.MODRR0
#define MODRR_MODRR1                    _MODRR.Bits.MODRR1
#define MODRR_MODRR2                    _MODRR.Bits.MODRR2
#define MODRR_MODRR3                    _MODRR.Bits.MODRR3
#define MODRR_MODRR                     _MODRR.MergedBits.grpMODRR

#define MODRR_MODRR0_MASK               1U
#define MODRR_MODRR1_MASK               2U
#define MODRR_MODRR2_MASK               4U
#define MODRR_MODRR3_MASK               8U
#define MODRR_MODRR_MASK                15U
#define MODRR_MODRR_BITNUM              0U


/*** PTAD - Port AD I/O Register; 0x00000270 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** PTADHi - Port AD I/O Register High; 0x00000270 ***/
    union {
      byte Byte;
      struct {
        byte PTAD8       :1;                                       /* Port AD Bit 8 */
        byte PTAD9       :1;                                       /* Port AD Bit 9 */
        byte PTAD10      :1;                                       /* Port AD Bit 10 */
        byte PTAD11      :1;                                       /* Port AD Bit 11 */
        byte PTAD12      :1;                                       /* Port AD Bit 12 */
        byte PTAD13      :1;                                       /* Port AD Bit 13 */
        byte PTAD14      :1;                                       /* Port AD Bit 14 */
        byte PTAD15      :1;                                       /* Port AD Bit 15 */
      } Bits;
    } PTADHiSTR;
    #define PTADHi                      _PTAD.Overlap_STR.PTADHiSTR.Byte
    #define PTADHi_PTAD8                _PTAD.Overlap_STR.PTADHiSTR.Bits.PTAD8
    #define PTADHi_PTAD9                _PTAD.Overlap_STR.PTADHiSTR.Bits.PTAD9
    #define PTADHi_PTAD10               _PTAD.Overlap_STR.PTADHiSTR.Bits.PTAD10
    #define PTADHi_PTAD11               _PTAD.Overlap_STR.PTADHiSTR.Bits.PTAD11
    #define PTADHi_PTAD12               _PTAD.Overlap_STR.PTADHiSTR.Bits.PTAD12
    #define PTADHi_PTAD13               _PTAD.Overlap_STR.PTADHiSTR.Bits.PTAD13
    #define PTADHi_PTAD14               _PTAD.Overlap_STR.PTADHiSTR.Bits.PTAD14
    #define PTADHi_PTAD15               _PTAD.Overlap_STR.PTADHiSTR.Bits.PTAD15
    
    #define PTADHi_PTAD8_MASK           1U
    #define PTADHi_PTAD9_MASK           2U
    #define PTADHi_PTAD10_MASK          4U
    #define PTADHi_PTAD11_MASK          8U
    #define PTADHi_PTAD12_MASK          16U
    #define PTADHi_PTAD13_MASK          32U
    #define PTADHi_PTAD14_MASK          64U
    #define PTADHi_PTAD15_MASK          128U
    

    /*** PTADLo - Port AD I/O Register Low; 0x00000271 ***/
    union {
      byte Byte;
      struct {
        byte PTAD0       :1;                                       /* Port AD Bit 0 */
        byte PTAD1       :1;                                       /* Port AD Bit 1 */
        byte PTAD2       :1;                                       /* Port AD Bit 2 */
        byte PTAD3       :1;                                       /* Port AD Bit 3 */
        byte PTAD4       :1;                                       /* Port AD Bit 4 */
        byte PTAD5       :1;                                       /* Port AD Bit 5 */
        byte PTAD6       :1;                                       /* Port AD Bit 6 */
        byte PTAD7       :1;                                       /* Port AD Bit 7 */
      } Bits;
    } PTADLoSTR;
    #define PTADLo                      _PTAD.Overlap_STR.PTADLoSTR.Byte
    #define PTADLo_PTAD0                _PTAD.Overlap_STR.PTADLoSTR.Bits.PTAD0
    #define PTADLo_PTAD1                _PTAD.Overlap_STR.PTADLoSTR.Bits.PTAD1
    #define PTADLo_PTAD2                _PTAD.Overlap_STR.PTADLoSTR.Bits.PTAD2
    #define PTADLo_PTAD3                _PTAD.Overlap_STR.PTADLoSTR.Bits.PTAD3
    #define PTADLo_PTAD4                _PTAD.Overlap_STR.PTADLoSTR.Bits.PTAD4
    #define PTADLo_PTAD5                _PTAD.Overlap_STR.PTADLoSTR.Bits.PTAD5
    #define PTADLo_PTAD6                _PTAD.Overlap_STR.PTADLoSTR.Bits.PTAD6
    #define PTADLo_PTAD7                _PTAD.Overlap_STR.PTADLoSTR.Bits.PTAD7
    
    #define PTADLo_PTAD0_MASK           1U
    #define PTADLo_PTAD1_MASK           2U
    #define PTADLo_PTAD2_MASK           4U
    #define PTADLo_PTAD3_MASK           8U
    #define PTADLo_PTAD4_MASK           16U
    #define PTADLo_PTAD5_MASK           32U
    #define PTADLo_PTAD6_MASK           64U
    #define PTADLo_PTAD7_MASK           128U
    
  } Overlap_STR;

  struct {
    word PTAD0       :1;                                       /* Port AD Bit 0 */
    word PTAD1       :1;                                       /* Port AD Bit 1 */
    word PTAD2       :1;                                       /* Port AD Bit 2 */
    word PTAD3       :1;                                       /* Port AD Bit 3 */
    word PTAD4       :1;                                       /* Port AD Bit 4 */
    word PTAD5       :1;                                       /* Port AD Bit 5 */
    word PTAD6       :1;                                       /* Port AD Bit 6 */
    word PTAD7       :1;                                       /* Port AD Bit 7 */
    word PTAD8       :1;                                       /* Port AD Bit 8 */
    word PTAD9       :1;                                       /* Port AD Bit 9 */
    word PTAD10      :1;                                       /* Port AD Bit 10 */
    word PTAD11      :1;                                       /* Port AD Bit 11 */
    word PTAD12      :1;                                       /* Port AD Bit 12 */
    word PTAD13      :1;                                       /* Port AD Bit 13 */
    word PTAD14      :1;                                       /* Port AD Bit 14 */
    word PTAD15      :1;                                       /* Port AD Bit 15 */
  } Bits;
} PTADSTR;
extern volatile PTADSTR _PTAD @(REG_BASE + 0x00000270UL);
#define PTAD                            _PTAD.Word
#define PTAD_PTAD0                      _PTAD.Bits.PTAD0
#define PTAD_PTAD1                      _PTAD.Bits.PTAD1
#define PTAD_PTAD2                      _PTAD.Bits.PTAD2
#define PTAD_PTAD3                      _PTAD.Bits.PTAD3
#define PTAD_PTAD4                      _PTAD.Bits.PTAD4
#define PTAD_PTAD5                      _PTAD.Bits.PTAD5
#define PTAD_PTAD6                      _PTAD.Bits.PTAD6
#define PTAD_PTAD7                      _PTAD.Bits.PTAD7
#define PTAD_PTAD8                      _PTAD.Bits.PTAD8
#define PTAD_PTAD9                      _PTAD.Bits.PTAD9
#define PTAD_PTAD10                     _PTAD.Bits.PTAD10
#define PTAD_PTAD11                     _PTAD.Bits.PTAD11
#define PTAD_PTAD12                     _PTAD.Bits.PTAD12
#define PTAD_PTAD13                     _PTAD.Bits.PTAD13
#define PTAD_PTAD14                     _PTAD.Bits.PTAD14
#define PTAD_PTAD15                     _PTAD.Bits.PTAD15

#define PTAD_PTAD0_MASK                 1U
#define PTAD_PTAD1_MASK                 2U
#define PTAD_PTAD2_MASK                 4U
#define PTAD_PTAD3_MASK                 8U
#define PTAD_PTAD4_MASK                 16U
#define PTAD_PTAD5_MASK                 32U
#define PTAD_PTAD6_MASK                 64U
#define PTAD_PTAD7_MASK                 128U
#define PTAD_PTAD8_MASK                 256U
#define PTAD_PTAD9_MASK                 512U
#define PTAD_PTAD10_MASK                1024U
#define PTAD_PTAD11_MASK                2048U
#define PTAD_PTAD12_MASK                4096U
#define PTAD_PTAD13_MASK                8192U
#define PTAD_PTAD14_MASK                16384U
#define PTAD_PTAD15_MASK                32768U


/*** PTIAD - Port AD Input Register; 0x00000272 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** PTIADHi - Port AD Input Register High; 0x00000272 ***/
    union {
      byte Byte;
      struct {
        byte PTIAD8      :1;                                       /* Port AD Bit 8 */
        byte PTIAD9      :1;                                       /* Port AD Bit 9 */
        byte PTIAD10     :1;                                       /* Port AD Bit 10 */
        byte PTIAD11     :1;                                       /* Port AD Bit 11 */
        byte PTIAD12     :1;                                       /* Port AD Bit 12 */
        byte PTIAD13     :1;                                       /* Port AD Bit 13 */
        byte PTIAD14     :1;                                       /* Port AD Bit 14 */
        byte PTIAD15     :1;                                       /* Port AD Bit 15 */
      } Bits;
    } PTIADHiSTR;
    #define PTIADHi                     _PTIAD.Overlap_STR.PTIADHiSTR.Byte
    #define PTIADHi_PTIAD8              _PTIAD.Overlap_STR.PTIADHiSTR.Bits.PTIAD8
    #define PTIADHi_PTIAD9              _PTIAD.Overlap_STR.PTIADHiSTR.Bits.PTIAD9
    #define PTIADHi_PTIAD10             _PTIAD.Overlap_STR.PTIADHiSTR.Bits.PTIAD10
    #define PTIADHi_PTIAD11             _PTIAD.Overlap_STR.PTIADHiSTR.Bits.PTIAD11
    #define PTIADHi_PTIAD12             _PTIAD.Overlap_STR.PTIADHiSTR.Bits.PTIAD12
    #define PTIADHi_PTIAD13             _PTIAD.Overlap_STR.PTIADHiSTR.Bits.PTIAD13
    #define PTIADHi_PTIAD14             _PTIAD.Overlap_STR.PTIADHiSTR.Bits.PTIAD14
    #define PTIADHi_PTIAD15             _PTIAD.Overlap_STR.PTIADHiSTR.Bits.PTIAD15
    
    #define PTIADHi_PTIAD8_MASK         1U
    #define PTIADHi_PTIAD9_MASK         2U
    #define PTIADHi_PTIAD10_MASK        4U
    #define PTIADHi_PTIAD11_MASK        8U
    #define PTIADHi_PTIAD12_MASK        16U
    #define PTIADHi_PTIAD13_MASK        32U
    #define PTIADHi_PTIAD14_MASK        64U
    #define PTIADHi_PTIAD15_MASK        128U
    

    /*** PTIADLo - Port AD Input Register Low; 0x00000273 ***/
    union {
      byte Byte;
      struct {
        byte PTIAD0      :1;                                       /* Port AD Bit 0 */
        byte PTIAD1      :1;                                       /* Port AD Bit 1 */
        byte PTIAD2      :1;                                       /* Port AD Bit 2 */
        byte PTIAD3      :1;                                       /* Port AD Bit 3 */
        byte PTIAD4      :1;                                       /* Port AD Bit 4 */
        byte PTIAD5      :1;                                       /* Port AD Bit 5 */
        byte PTIAD6      :1;                                       /* Port AD Bit 6 */
        byte PTIAD7      :1;                                       /* Port AD Bit 7 */
      } Bits;
    } PTIADLoSTR;
    #define PTIADLo                     _PTIAD.Overlap_STR.PTIADLoSTR.Byte
    #define PTIADLo_PTIAD0              _PTIAD.Overlap_STR.PTIADLoSTR.Bits.PTIAD0
    #define PTIADLo_PTIAD1              _PTIAD.Overlap_STR.PTIADLoSTR.Bits.PTIAD1
    #define PTIADLo_PTIAD2              _PTIAD.Overlap_STR.PTIADLoSTR.Bits.PTIAD2
    #define PTIADLo_PTIAD3              _PTIAD.Overlap_STR.PTIADLoSTR.Bits.PTIAD3
    #define PTIADLo_PTIAD4              _PTIAD.Overlap_STR.PTIADLoSTR.Bits.PTIAD4
    #define PTIADLo_PTIAD5              _PTIAD.Overlap_STR.PTIADLoSTR.Bits.PTIAD5
    #define PTIADLo_PTIAD6              _PTIAD.Overlap_STR.PTIADLoSTR.Bits.PTIAD6
    #define PTIADLo_PTIAD7              _PTIAD.Overlap_STR.PTIADLoSTR.Bits.PTIAD7
    
    #define PTIADLo_PTIAD0_MASK         1U
    #define PTIADLo_PTIAD1_MASK         2U
    #define PTIADLo_PTIAD2_MASK         4U
    #define PTIADLo_PTIAD3_MASK         8U
    #define PTIADLo_PTIAD4_MASK         16U
    #define PTIADLo_PTIAD5_MASK         32U
    #define PTIADLo_PTIAD6_MASK         64U
    #define PTIADLo_PTIAD7_MASK         128U
    
  } Overlap_STR;

  struct {
    word PTIAD0      :1;                                       /* Port AD Bit 0 */
    word PTIAD1      :1;                                       /* Port AD Bit 1 */
    word PTIAD2      :1;                                       /* Port AD Bit 2 */
    word PTIAD3      :1;                                       /* Port AD Bit 3 */
    word PTIAD4      :1;                                       /* Port AD Bit 4 */
    word PTIAD5      :1;                                       /* Port AD Bit 5 */
    word PTIAD6      :1;                                       /* Port AD Bit 6 */
    word PTIAD7      :1;                                       /* Port AD Bit 7 */
    word PTIAD8      :1;                                       /* Port AD Bit 8 */
    word PTIAD9      :1;                                       /* Port AD Bit 9 */
    word PTIAD10     :1;                                       /* Port AD Bit 10 */
    word PTIAD11     :1;                                       /* Port AD Bit 11 */
    word PTIAD12     :1;                                       /* Port AD Bit 12 */
    word PTIAD13     :1;                                       /* Port AD Bit 13 */
    word PTIAD14     :1;                                       /* Port AD Bit 14 */
    word PTIAD15     :1;                                       /* Port AD Bit 15 */
  } Bits;
} PTIADSTR;
extern volatile PTIADSTR _PTIAD @(REG_BASE + 0x00000272UL);
#define PTIAD                           _PTIAD.Word
#define PTIAD_PTIAD0                    _PTIAD.Bits.PTIAD0
#define PTIAD_PTIAD1                    _PTIAD.Bits.PTIAD1
#define PTIAD_PTIAD2                    _PTIAD.Bits.PTIAD2
#define PTIAD_PTIAD3                    _PTIAD.Bits.PTIAD3
#define PTIAD_PTIAD4                    _PTIAD.Bits.PTIAD4
#define PTIAD_PTIAD5                    _PTIAD.Bits.PTIAD5
#define PTIAD_PTIAD6                    _PTIAD.Bits.PTIAD6
#define PTIAD_PTIAD7                    _PTIAD.Bits.PTIAD7
#define PTIAD_PTIAD8                    _PTIAD.Bits.PTIAD8
#define PTIAD_PTIAD9                    _PTIAD.Bits.PTIAD9
#define PTIAD_PTIAD10                   _PTIAD.Bits.PTIAD10
#define PTIAD_PTIAD11                   _PTIAD.Bits.PTIAD11
#define PTIAD_PTIAD12                   _PTIAD.Bits.PTIAD12
#define PTIAD_PTIAD13                   _PTIAD.Bits.PTIAD13
#define PTIAD_PTIAD14                   _PTIAD.Bits.PTIAD14
#define PTIAD_PTIAD15                   _PTIAD.Bits.PTIAD15

#define PTIAD_PTIAD0_MASK               1U
#define PTIAD_PTIAD1_MASK               2U
#define PTIAD_PTIAD2_MASK               4U
#define PTIAD_PTIAD3_MASK               8U
#define PTIAD_PTIAD4_MASK               16U
#define PTIAD_PTIAD5_MASK               32U
#define PTIAD_PTIAD6_MASK               64U
#define PTIAD_PTIAD7_MASK               128U
#define PTIAD_PTIAD8_MASK               256U
#define PTIAD_PTIAD9_MASK               512U
#define PTIAD_PTIAD10_MASK              1024U
#define PTIAD_PTIAD11_MASK              2048U
#define PTIAD_PTIAD12_MASK              4096U
#define PTIAD_PTIAD13_MASK              8192U
#define PTIAD_PTIAD14_MASK              16384U
#define PTIAD_PTIAD15_MASK              32768U


/*** DDRAD - Port AD Data Direction Register; 0x00000274 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** DDRADHi - Port AD Data Direction Register High; 0x00000274 ***/
    union {
      byte Byte;
      struct {
        byte DDRAD8      :1;                                       /* Port AD Data Direction Bit 8 */
        byte DDRAD9      :1;                                       /* Port AD Data Direction Bit 9 */
        byte DDRAD10     :1;                                       /* Port AD Data Direction Bit 10 */
        byte DDRAD11     :1;                                       /* Port AD Data Direction Bit 11 */
        byte DDRAD12     :1;                                       /* Port AD Data Direction Bit 12 */
        byte DDRAD13     :1;                                       /* Port AD Data Direction Bit 13 */
        byte DDRAD14     :1;                                       /* Port AD Data Direction Bit 14 */
        byte DDRAD15     :1;                                       /* Port AD Data Direction Bit 15 */
      } Bits;
    } DDRADHiSTR;
    #define DDRADHi                     _DDRAD.Overlap_STR.DDRADHiSTR.Byte
    #define DDRADHi_DDRAD8              _DDRAD.Overlap_STR.DDRADHiSTR.Bits.DDRAD8
    #define DDRADHi_DDRAD9              _DDRAD.Overlap_STR.DDRADHiSTR.Bits.DDRAD9
    #define DDRADHi_DDRAD10             _DDRAD.Overlap_STR.DDRADHiSTR.Bits.DDRAD10
    #define DDRADHi_DDRAD11             _DDRAD.Overlap_STR.DDRADHiSTR.Bits.DDRAD11
    #define DDRADHi_DDRAD12             _DDRAD.Overlap_STR.DDRADHiSTR.Bits.DDRAD12
    #define DDRADHi_DDRAD13             _DDRAD.Overlap_STR.DDRADHiSTR.Bits.DDRAD13
    #define DDRADHi_DDRAD14             _DDRAD.Overlap_STR.DDRADHiSTR.Bits.DDRAD14
    #define DDRADHi_DDRAD15             _DDRAD.Overlap_STR.DDRADHiSTR.Bits.DDRAD15
    
    #define DDRADHi_DDRAD8_MASK         1U
    #define DDRADHi_DDRAD9_MASK         2U
    #define DDRADHi_DDRAD10_MASK        4U
    #define DDRADHi_DDRAD11_MASK        8U
    #define DDRADHi_DDRAD12_MASK        16U
    #define DDRADHi_DDRAD13_MASK        32U
    #define DDRADHi_DDRAD14_MASK        64U
    #define DDRADHi_DDRAD15_MASK        128U
    

    /*** DDRADLo - Port AD Data Direction Register Low; 0x00000275 ***/
    union {
      byte Byte;
      struct {
        byte DDRAD0      :1;                                       /* Port AD Data Direction Bit 0 */
        byte DDRAD1      :1;                                       /* Port AD Data Direction Bit 1 */
        byte DDRAD2      :1;                                       /* Port AD Data Direction Bit 2 */
        byte DDRAD3      :1;                                       /* Port AD Data Direction Bit 3 */
        byte DDRAD4      :1;                                       /* Port AD Data Direction Bit 4 */
        byte DDRAD5      :1;                                       /* Port AD Data Direction Bit 5 */
        byte DDRAD6      :1;                                       /* Port AD Data Direction Bit 6 */
        byte DDRAD7      :1;                                       /* Port AD Data Direction Bit 7 */
      } Bits;
    } DDRADLoSTR;
    #define DDRADLo                     _DDRAD.Overlap_STR.DDRADLoSTR.Byte
    #define DDRADLo_DDRAD0              _DDRAD.Overlap_STR.DDRADLoSTR.Bits.DDRAD0
    #define DDRADLo_DDRAD1              _DDRAD.Overlap_STR.DDRADLoSTR.Bits.DDRAD1
    #define DDRADLo_DDRAD2              _DDRAD.Overlap_STR.DDRADLoSTR.Bits.DDRAD2
    #define DDRADLo_DDRAD3              _DDRAD.Overlap_STR.DDRADLoSTR.Bits.DDRAD3
    #define DDRADLo_DDRAD4              _DDRAD.Overlap_STR.DDRADLoSTR.Bits.DDRAD4
    #define DDRADLo_DDRAD5              _DDRAD.Overlap_STR.DDRADLoSTR.Bits.DDRAD5
    #define DDRADLo_DDRAD6              _DDRAD.Overlap_STR.DDRADLoSTR.Bits.DDRAD6
    #define DDRADLo_DDRAD7              _DDRAD.Overlap_STR.DDRADLoSTR.Bits.DDRAD7
    
    #define DDRADLo_DDRAD0_MASK         1U
    #define DDRADLo_DDRAD1_MASK         2U
    #define DDRADLo_DDRAD2_MASK         4U
    #define DDRADLo_DDRAD3_MASK         8U
    #define DDRADLo_DDRAD4_MASK         16U
    #define DDRADLo_DDRAD5_MASK         32U
    #define DDRADLo_DDRAD6_MASK         64U
    #define DDRADLo_DDRAD7_MASK         128U
    
  } Overlap_STR;

  struct {
    word DDRAD0      :1;                                       /* Port AD Data Direction Bit 0 */
    word DDRAD1      :1;                                       /* Port AD Data Direction Bit 1 */
    word DDRAD2      :1;                                       /* Port AD Data Direction Bit 2 */
    word DDRAD3      :1;                                       /* Port AD Data Direction Bit 3 */
    word DDRAD4      :1;                                       /* Port AD Data Direction Bit 4 */
    word DDRAD5      :1;                                       /* Port AD Data Direction Bit 5 */
    word DDRAD6      :1;                                       /* Port AD Data Direction Bit 6 */
    word DDRAD7      :1;                                       /* Port AD Data Direction Bit 7 */
    word DDRAD8      :1;                                       /* Port AD Data Direction Bit 8 */
    word DDRAD9      :1;                                       /* Port AD Data Direction Bit 9 */
    word DDRAD10     :1;                                       /* Port AD Data Direction Bit 10 */
    word DDRAD11     :1;                                       /* Port AD Data Direction Bit 11 */
    word DDRAD12     :1;                                       /* Port AD Data Direction Bit 12 */
    word DDRAD13     :1;                                       /* Port AD Data Direction Bit 13 */
    word DDRAD14     :1;                                       /* Port AD Data Direction Bit 14 */
    word DDRAD15     :1;                                       /* Port AD Data Direction Bit 15 */
  } Bits;
} DDRADSTR;
extern volatile DDRADSTR _DDRAD @(REG_BASE + 0x00000274UL);
#define DDRAD                           _DDRAD.Word
#define DDRAD_DDRAD0                    _DDRAD.Bits.DDRAD0
#define DDRAD_DDRAD1                    _DDRAD.Bits.DDRAD1
#define DDRAD_DDRAD2                    _DDRAD.Bits.DDRAD2
#define DDRAD_DDRAD3                    _DDRAD.Bits.DDRAD3
#define DDRAD_DDRAD4                    _DDRAD.Bits.DDRAD4
#define DDRAD_DDRAD5                    _DDRAD.Bits.DDRAD5
#define DDRAD_DDRAD6                    _DDRAD.Bits.DDRAD6
#define DDRAD_DDRAD7                    _DDRAD.Bits.DDRAD7
#define DDRAD_DDRAD8                    _DDRAD.Bits.DDRAD8
#define DDRAD_DDRAD9                    _DDRAD.Bits.DDRAD9
#define DDRAD_DDRAD10                   _DDRAD.Bits.DDRAD10
#define DDRAD_DDRAD11                   _DDRAD.Bits.DDRAD11
#define DDRAD_DDRAD12                   _DDRAD.Bits.DDRAD12
#define DDRAD_DDRAD13                   _DDRAD.Bits.DDRAD13
#define DDRAD_DDRAD14                   _DDRAD.Bits.DDRAD14
#define DDRAD_DDRAD15                   _DDRAD.Bits.DDRAD15

#define DDRAD_DDRAD0_MASK               1U
#define DDRAD_DDRAD1_MASK               2U
#define DDRAD_DDRAD2_MASK               4U
#define DDRAD_DDRAD3_MASK               8U
#define DDRAD_DDRAD4_MASK               16U
#define DDRAD_DDRAD5_MASK               32U
#define DDRAD_DDRAD6_MASK               64U
#define DDRAD_DDRAD7_MASK               128U
#define DDRAD_DDRAD8_MASK               256U
#define DDRAD_DDRAD9_MASK               512U
#define DDRAD_DDRAD10_MASK              1024U
#define DDRAD_DDRAD11_MASK              2048U
#define DDRAD_DDRAD12_MASK              4096U
#define DDRAD_DDRAD13_MASK              8192U
#define DDRAD_DDRAD14_MASK              16384U
#define DDRAD_DDRAD15_MASK              32768U


/*** RDRAD - Port AD Reduced Drive Register; 0x00000276 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** RDRADHi - Port AD Reduced Drive Register High; 0x00000276 ***/
    union {
      byte Byte;
      struct {
        byte RDRAD8      :1;                                       /* Port AD Reduced Drive Bit 8 */
        byte RDRAD9      :1;                                       /* Port AD Reduced Drive Bit 9 */
        byte RDRAD10     :1;                                       /* Port AD Reduced Drive Bit 10 */
        byte RDRAD11     :1;                                       /* Port AD Reduced Drive Bit 11 */
        byte RDRAD12     :1;                                       /* Port AD Reduced Drive Bit 12 */
        byte RDRAD13     :1;                                       /* Port AD Reduced Drive Bit 13 */
        byte RDRAD14     :1;                                       /* Port AD Reduced Drive Bit 14 */
        byte RDRAD15     :1;                                       /* Port AD Reduced Drive Bit 15 */
      } Bits;
    } RDRADHiSTR;
    #define RDRADHi                     _RDRAD.Overlap_STR.RDRADHiSTR.Byte
    #define RDRADHi_RDRAD8              _RDRAD.Overlap_STR.RDRADHiSTR.Bits.RDRAD8
    #define RDRADHi_RDRAD9              _RDRAD.Overlap_STR.RDRADHiSTR.Bits.RDRAD9
    #define RDRADHi_RDRAD10             _RDRAD.Overlap_STR.RDRADHiSTR.Bits.RDRAD10
    #define RDRADHi_RDRAD11             _RDRAD.Overlap_STR.RDRADHiSTR.Bits.RDRAD11
    #define RDRADHi_RDRAD12             _RDRAD.Overlap_STR.RDRADHiSTR.Bits.RDRAD12
    #define RDRADHi_RDRAD13             _RDRAD.Overlap_STR.RDRADHiSTR.Bits.RDRAD13
    #define RDRADHi_RDRAD14             _RDRAD.Overlap_STR.RDRADHiSTR.Bits.RDRAD14
    #define RDRADHi_RDRAD15             _RDRAD.Overlap_STR.RDRADHiSTR.Bits.RDRAD15
    
    #define RDRADHi_RDRAD8_MASK         1U
    #define RDRADHi_RDRAD9_MASK         2U
    #define RDRADHi_RDRAD10_MASK        4U
    #define RDRADHi_RDRAD11_MASK        8U
    #define RDRADHi_RDRAD12_MASK        16U
    #define RDRADHi_RDRAD13_MASK        32U
    #define RDRADHi_RDRAD14_MASK        64U
    #define RDRADHi_RDRAD15_MASK        128U
    

    /*** RDRADLo - Port AD Reduced Drive Register Low; 0x00000277 ***/
    union {
      byte Byte;
      struct {
        byte RDRAD0      :1;                                       /* Port AD Reduced Drive Bit 0 */
        byte RDRAD1      :1;                                       /* Port AD Reduced Drive Bit 1 */
        byte RDRAD2      :1;                                       /* Port AD Reduced Drive Bit 2 */
        byte RDRAD3      :1;                                       /* Port AD Reduced Drive Bit 3 */
        byte RDRAD4      :1;                                       /* Port AD Reduced Drive Bit 4 */
        byte RDRAD5      :1;                                       /* Port AD Reduced Drive Bit 5 */
        byte RDRAD6      :1;                                       /* Port AD Reduced Drive Bit 6 */
        byte RDRAD7      :1;                                       /* Port AD Reduced Drive Bit 7 */
      } Bits;
    } RDRADLoSTR;
    #define RDRADLo                     _RDRAD.Overlap_STR.RDRADLoSTR.Byte
    #define RDRADLo_RDRAD0              _RDRAD.Overlap_STR.RDRADLoSTR.Bits.RDRAD0
    #define RDRADLo_RDRAD1              _RDRAD.Overlap_STR.RDRADLoSTR.Bits.RDRAD1
    #define RDRADLo_RDRAD2              _RDRAD.Overlap_STR.RDRADLoSTR.Bits.RDRAD2
    #define RDRADLo_RDRAD3              _RDRAD.Overlap_STR.RDRADLoSTR.Bits.RDRAD3
    #define RDRADLo_RDRAD4              _RDRAD.Overlap_STR.RDRADLoSTR.Bits.RDRAD4
    #define RDRADLo_RDRAD5              _RDRAD.Overlap_STR.RDRADLoSTR.Bits.RDRAD5
    #define RDRADLo_RDRAD6              _RDRAD.Overlap_STR.RDRADLoSTR.Bits.RDRAD6
    #define RDRADLo_RDRAD7              _RDRAD.Overlap_STR.RDRADLoSTR.Bits.RDRAD7
    
    #define RDRADLo_RDRAD0_MASK         1U
    #define RDRADLo_RDRAD1_MASK         2U
    #define RDRADLo_RDRAD2_MASK         4U
    #define RDRADLo_RDRAD3_MASK         8U
    #define RDRADLo_RDRAD4_MASK         16U
    #define RDRADLo_RDRAD5_MASK         32U
    #define RDRADLo_RDRAD6_MASK         64U
    #define RDRADLo_RDRAD7_MASK         128U
    
  } Overlap_STR;

  struct {
    word RDRAD0      :1;                                       /* Port AD Reduced Drive Bit 0 */
    word RDRAD1      :1;                                       /* Port AD Reduced Drive Bit 1 */
    word RDRAD2      :1;                                       /* Port AD Reduced Drive Bit 2 */
    word RDRAD3      :1;                                       /* Port AD Reduced Drive Bit 3 */
    word RDRAD4      :1;                                       /* Port AD Reduced Drive Bit 4 */
    word RDRAD5      :1;                                       /* Port AD Reduced Drive Bit 5 */
    word RDRAD6      :1;                                       /* Port AD Reduced Drive Bit 6 */
    word RDRAD7      :1;                                       /* Port AD Reduced Drive Bit 7 */
    word RDRAD8      :1;                                       /* Port AD Reduced Drive Bit 8 */
    word RDRAD9      :1;                                       /* Port AD Reduced Drive Bit 9 */
    word RDRAD10     :1;                                       /* Port AD Reduced Drive Bit 10 */
    word RDRAD11     :1;                                       /* Port AD Reduced Drive Bit 11 */
    word RDRAD12     :1;                                       /* Port AD Reduced Drive Bit 12 */
    word RDRAD13     :1;                                       /* Port AD Reduced Drive Bit 13 */
    word RDRAD14     :1;                                       /* Port AD Reduced Drive Bit 14 */
    word RDRAD15     :1;                                       /* Port AD Reduced Drive Bit 15 */
  } Bits;
} RDRADSTR;
extern volatile RDRADSTR _RDRAD @(REG_BASE + 0x00000276UL);
#define RDRAD                           _RDRAD.Word
#define RDRAD_RDRAD0                    _RDRAD.Bits.RDRAD0
#define RDRAD_RDRAD1                    _RDRAD.Bits.RDRAD1
#define RDRAD_RDRAD2                    _RDRAD.Bits.RDRAD2
#define RDRAD_RDRAD3                    _RDRAD.Bits.RDRAD3
#define RDRAD_RDRAD4                    _RDRAD.Bits.RDRAD4
#define RDRAD_RDRAD5                    _RDRAD.Bits.RDRAD5
#define RDRAD_RDRAD6                    _RDRAD.Bits.RDRAD6
#define RDRAD_RDRAD7                    _RDRAD.Bits.RDRAD7
#define RDRAD_RDRAD8                    _RDRAD.Bits.RDRAD8
#define RDRAD_RDRAD9                    _RDRAD.Bits.RDRAD9
#define RDRAD_RDRAD10                   _RDRAD.Bits.RDRAD10
#define RDRAD_RDRAD11                   _RDRAD.Bits.RDRAD11
#define RDRAD_RDRAD12                   _RDRAD.Bits.RDRAD12
#define RDRAD_RDRAD13                   _RDRAD.Bits.RDRAD13
#define RDRAD_RDRAD14                   _RDRAD.Bits.RDRAD14
#define RDRAD_RDRAD15                   _RDRAD.Bits.RDRAD15

#define RDRAD_RDRAD0_MASK               1U
#define RDRAD_RDRAD1_MASK               2U
#define RDRAD_RDRAD2_MASK               4U
#define RDRAD_RDRAD3_MASK               8U
#define RDRAD_RDRAD4_MASK               16U
#define RDRAD_RDRAD5_MASK               32U
#define RDRAD_RDRAD6_MASK               64U
#define RDRAD_RDRAD7_MASK               128U
#define RDRAD_RDRAD8_MASK               256U
#define RDRAD_RDRAD9_MASK               512U
#define RDRAD_RDRAD10_MASK              1024U
#define RDRAD_RDRAD11_MASK              2048U
#define RDRAD_RDRAD12_MASK              4096U
#define RDRAD_RDRAD13_MASK              8192U
#define RDRAD_RDRAD14_MASK              16384U
#define RDRAD_RDRAD15_MASK              32768U


/*** PERAD - Port AD Pull Device Enable Register; 0x00000278 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** PERADHi - Port AD Pull Device Enable Register High; 0x00000278 ***/
    union {
      byte Byte;
      struct {
        byte PERAD8      :1;                                       /* Port AD Pull Device Enable Bit 8 */
        byte PERAD9      :1;                                       /* Port AD Pull Device Enable Bit 9 */
        byte PERAD10     :1;                                       /* Port AD Pull Device Enable Bit 10 */
        byte PERAD11     :1;                                       /* Port AD Pull Device Enable Bit 11 */
        byte PERAD12     :1;                                       /* Port AD Pull Device Enable Bit 12 */
        byte PERAD13     :1;                                       /* Port AD Pull Device Enable Bit 13 */
        byte PERAD14     :1;                                       /* Port AD Pull Device Enable Bit 14 */
        byte PERAD15     :1;                                       /* Port AD Pull Device Enable Bit 15 */
      } Bits;
    } PERADHiSTR;
    #define PERADHi                     _PERAD.Overlap_STR.PERADHiSTR.Byte
    #define PERADHi_PERAD8              _PERAD.Overlap_STR.PERADHiSTR.Bits.PERAD8
    #define PERADHi_PERAD9              _PERAD.Overlap_STR.PERADHiSTR.Bits.PERAD9
    #define PERADHi_PERAD10             _PERAD.Overlap_STR.PERADHiSTR.Bits.PERAD10
    #define PERADHi_PERAD11             _PERAD.Overlap_STR.PERADHiSTR.Bits.PERAD11
    #define PERADHi_PERAD12             _PERAD.Overlap_STR.PERADHiSTR.Bits.PERAD12
    #define PERADHi_PERAD13             _PERAD.Overlap_STR.PERADHiSTR.Bits.PERAD13
    #define PERADHi_PERAD14             _PERAD.Overlap_STR.PERADHiSTR.Bits.PERAD14
    #define PERADHi_PERAD15             _PERAD.Overlap_STR.PERADHiSTR.Bits.PERAD15
    
    #define PERADHi_PERAD8_MASK         1U
    #define PERADHi_PERAD9_MASK         2U
    #define PERADHi_PERAD10_MASK        4U
    #define PERADHi_PERAD11_MASK        8U
    #define PERADHi_PERAD12_MASK        16U
    #define PERADHi_PERAD13_MASK        32U
    #define PERADHi_PERAD14_MASK        64U
    #define PERADHi_PERAD15_MASK        128U
    

    /*** PERADLo - Port AD Pull Device Enable Register Low; 0x00000279 ***/
    union {
      byte Byte;
      struct {
        byte PERAD0      :1;                                       /* Port AD Pull Device Enable Bit 0 */
        byte PERAD1      :1;                                       /* Port AD Pull Device Enable Bit 1 */
        byte PERAD2      :1;                                       /* Port AD Pull Device Enable Bit 2 */
        byte PERAD3      :1;                                       /* Port AD Pull Device Enable Bit 3 */
        byte PERAD4      :1;                                       /* Port AD Pull Device Enable Bit 4 */
        byte PERAD5      :1;                                       /* Port AD Pull Device Enable Bit 5 */
        byte PERAD6      :1;                                       /* Port AD Pull Device Enable Bit 6 */
        byte PERAD7      :1;                                       /* Port AD Pull Device Enable Bit 7 */
      } Bits;
    } PERADLoSTR;
    #define PERADLo                     _PERAD.Overlap_STR.PERADLoSTR.Byte
    #define PERADLo_PERAD0              _PERAD.Overlap_STR.PERADLoSTR.Bits.PERAD0
    #define PERADLo_PERAD1              _PERAD.Overlap_STR.PERADLoSTR.Bits.PERAD1
    #define PERADLo_PERAD2              _PERAD.Overlap_STR.PERADLoSTR.Bits.PERAD2
    #define PERADLo_PERAD3              _PERAD.Overlap_STR.PERADLoSTR.Bits.PERAD3
    #define PERADLo_PERAD4              _PERAD.Overlap_STR.PERADLoSTR.Bits.PERAD4
    #define PERADLo_PERAD5              _PERAD.Overlap_STR.PERADLoSTR.Bits.PERAD5
    #define PERADLo_PERAD6              _PERAD.Overlap_STR.PERADLoSTR.Bits.PERAD6
    #define PERADLo_PERAD7              _PERAD.Overlap_STR.PERADLoSTR.Bits.PERAD7
    
    #define PERADLo_PERAD0_MASK         1U
    #define PERADLo_PERAD1_MASK         2U
    #define PERADLo_PERAD2_MASK         4U
    #define PERADLo_PERAD3_MASK         8U
    #define PERADLo_PERAD4_MASK         16U
    #define PERADLo_PERAD5_MASK         32U
    #define PERADLo_PERAD6_MASK         64U
    #define PERADLo_PERAD7_MASK         128U
    
  } Overlap_STR;

  struct {
    word PERAD0      :1;                                       /* Port AD Pull Device Enable Bit 0 */
    word PERAD1      :1;                                       /* Port AD Pull Device Enable Bit 1 */
    word PERAD2      :1;                                       /* Port AD Pull Device Enable Bit 2 */
    word PERAD3      :1;                                       /* Port AD Pull Device Enable Bit 3 */
    word PERAD4      :1;                                       /* Port AD Pull Device Enable Bit 4 */
    word PERAD5      :1;                                       /* Port AD Pull Device Enable Bit 5 */
    word PERAD6      :1;                                       /* Port AD Pull Device Enable Bit 6 */
    word PERAD7      :1;                                       /* Port AD Pull Device Enable Bit 7 */
    word PERAD8      :1;                                       /* Port AD Pull Device Enable Bit 8 */
    word PERAD9      :1;                                       /* Port AD Pull Device Enable Bit 9 */
    word PERAD10     :1;                                       /* Port AD Pull Device Enable Bit 10 */
    word PERAD11     :1;                                       /* Port AD Pull Device Enable Bit 11 */
    word PERAD12     :1;                                       /* Port AD Pull Device Enable Bit 12 */
    word PERAD13     :1;                                       /* Port AD Pull Device Enable Bit 13 */
    word PERAD14     :1;                                       /* Port AD Pull Device Enable Bit 14 */
    word PERAD15     :1;                                       /* Port AD Pull Device Enable Bit 15 */
  } Bits;
} PERADSTR;
extern volatile PERADSTR _PERAD @(REG_BASE + 0x00000278UL);
#define PERAD                           _PERAD.Word
#define PERAD_PERAD0                    _PERAD.Bits.PERAD0
#define PERAD_PERAD1                    _PERAD.Bits.PERAD1
#define PERAD_PERAD2                    _PERAD.Bits.PERAD2
#define PERAD_PERAD3                    _PERAD.Bits.PERAD3
#define PERAD_PERAD4                    _PERAD.Bits.PERAD4
#define PERAD_PERAD5                    _PERAD.Bits.PERAD5
#define PERAD_PERAD6                    _PERAD.Bits.PERAD6
#define PERAD_PERAD7                    _PERAD.Bits.PERAD7
#define PERAD_PERAD8                    _PERAD.Bits.PERAD8
#define PERAD_PERAD9                    _PERAD.Bits.PERAD9
#define PERAD_PERAD10                   _PERAD.Bits.PERAD10
#define PERAD_PERAD11                   _PERAD.Bits.PERAD11
#define PERAD_PERAD12                   _PERAD.Bits.PERAD12
#define PERAD_PERAD13                   _PERAD.Bits.PERAD13
#define PERAD_PERAD14                   _PERAD.Bits.PERAD14
#define PERAD_PERAD15                   _PERAD.Bits.PERAD15

#define PERAD_PERAD0_MASK               1U
#define PERAD_PERAD1_MASK               2U
#define PERAD_PERAD2_MASK               4U
#define PERAD_PERAD3_MASK               8U
#define PERAD_PERAD4_MASK               16U
#define PERAD_PERAD5_MASK               32U
#define PERAD_PERAD6_MASK               64U
#define PERAD_PERAD7_MASK               128U
#define PERAD_PERAD8_MASK               256U
#define PERAD_PERAD9_MASK               512U
#define PERAD_PERAD10_MASK              1024U
#define PERAD_PERAD11_MASK              2048U
#define PERAD_PERAD12_MASK              4096U
#define PERAD_PERAD13_MASK              8192U
#define PERAD_PERAD14_MASK              16384U
#define PERAD_PERAD15_MASK              32768U


/*** PPSAD - Port AD Polarity Select Register; 0x0000027A ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** PPSADHi - Port AD Polarity Select Register High; 0x0000027A ***/
    union {
      byte Byte;
      struct {
        byte PPSAD8      :1;                                       /* Port AD Polarity Select Bit 8 */
        byte PPSAD9      :1;                                       /* Port AD Polarity Select Bit 9 */
        byte PPSAD10     :1;                                       /* Port AD Polarity Select Bit 10 */
        byte PPSAD11     :1;                                       /* Port AD Polarity Select Bit 11 */
        byte PPSAD12     :1;                                       /* Port AD Polarity Select Bit 12 */
        byte PPSAD13     :1;                                       /* Port AD Polarity Select Bit 13 */
        byte PPSAD14     :1;                                       /* Port AD Polarity Select Bit 14 */
        byte PPSAD15     :1;                                       /* Port AD Polarity Select Bit 15 */
      } Bits;
    } PPSADHiSTR;
    #define PPSADHi                     _PPSAD.Overlap_STR.PPSADHiSTR.Byte
    #define PPSADHi_PPSAD8              _PPSAD.Overlap_STR.PPSADHiSTR.Bits.PPSAD8
    #define PPSADHi_PPSAD9              _PPSAD.Overlap_STR.PPSADHiSTR.Bits.PPSAD9
    #define PPSADHi_PPSAD10             _PPSAD.Overlap_STR.PPSADHiSTR.Bits.PPSAD10
    #define PPSADHi_PPSAD11             _PPSAD.Overlap_STR.PPSADHiSTR.Bits.PPSAD11
    #define PPSADHi_PPSAD12             _PPSAD.Overlap_STR.PPSADHiSTR.Bits.PPSAD12
    #define PPSADHi_PPSAD13             _PPSAD.Overlap_STR.PPSADHiSTR.Bits.PPSAD13
    #define PPSADHi_PPSAD14             _PPSAD.Overlap_STR.PPSADHiSTR.Bits.PPSAD14
    #define PPSADHi_PPSAD15             _PPSAD.Overlap_STR.PPSADHiSTR.Bits.PPSAD15
    
    #define PPSADHi_PPSAD8_MASK         1U
    #define PPSADHi_PPSAD9_MASK         2U
    #define PPSADHi_PPSAD10_MASK        4U
    #define PPSADHi_PPSAD11_MASK        8U
    #define PPSADHi_PPSAD12_MASK        16U
    #define PPSADHi_PPSAD13_MASK        32U
    #define PPSADHi_PPSAD14_MASK        64U
    #define PPSADHi_PPSAD15_MASK        128U
    

    /*** PPSADLo - Port AD Polarity Select Register Low; 0x0000027B ***/
    union {
      byte Byte;
      struct {
        byte PPSAD0      :1;                                       /* Port AD Polarity Select Bit 0 */
        byte PPSAD1      :1;                                       /* Port AD Polarity Select Bit 1 */
        byte PPSAD2      :1;                                       /* Port AD Polarity Select Bit 2 */
        byte PPSAD3      :1;                                       /* Port AD Polarity Select Bit 3 */
        byte PPSAD4      :1;                                       /* Port AD Polarity Select Bit 4 */
        byte PPSAD5      :1;                                       /* Port AD Polarity Select Bit 5 */
        byte PPSAD6      :1;                                       /* Port AD Polarity Select Bit 6 */
        byte PPSAD7      :1;                                       /* Port AD Polarity Select Bit 7 */
      } Bits;
    } PPSADLoSTR;
    #define PPSADLo                     _PPSAD.Overlap_STR.PPSADLoSTR.Byte
    #define PPSADLo_PPSAD0              _PPSAD.Overlap_STR.PPSADLoSTR.Bits.PPSAD0
    #define PPSADLo_PPSAD1              _PPSAD.Overlap_STR.PPSADLoSTR.Bits.PPSAD1
    #define PPSADLo_PPSAD2              _PPSAD.Overlap_STR.PPSADLoSTR.Bits.PPSAD2
    #define PPSADLo_PPSAD3              _PPSAD.Overlap_STR.PPSADLoSTR.Bits.PPSAD3
    #define PPSADLo_PPSAD4              _PPSAD.Overlap_STR.PPSADLoSTR.Bits.PPSAD4
    #define PPSADLo_PPSAD5              _PPSAD.Overlap_STR.PPSADLoSTR.Bits.PPSAD5
    #define PPSADLo_PPSAD6              _PPSAD.Overlap_STR.PPSADLoSTR.Bits.PPSAD6
    #define PPSADLo_PPSAD7              _PPSAD.Overlap_STR.PPSADLoSTR.Bits.PPSAD7
    
    #define PPSADLo_PPSAD0_MASK         1U
    #define PPSADLo_PPSAD1_MASK         2U
    #define PPSADLo_PPSAD2_MASK         4U
    #define PPSADLo_PPSAD3_MASK         8U
    #define PPSADLo_PPSAD4_MASK         16U
    #define PPSADLo_PPSAD5_MASK         32U
    #define PPSADLo_PPSAD6_MASK         64U
    #define PPSADLo_PPSAD7_MASK         128U
    
  } Overlap_STR;

  struct {
    word PPSAD0      :1;                                       /* Port AD Polarity Select Bit 0 */
    word PPSAD1      :1;                                       /* Port AD Polarity Select Bit 1 */
    word PPSAD2      :1;                                       /* Port AD Polarity Select Bit 2 */
    word PPSAD3      :1;                                       /* Port AD Polarity Select Bit 3 */
    word PPSAD4      :1;                                       /* Port AD Polarity Select Bit 4 */
    word PPSAD5      :1;                                       /* Port AD Polarity Select Bit 5 */
    word PPSAD6      :1;                                       /* Port AD Polarity Select Bit 6 */
    word PPSAD7      :1;                                       /* Port AD Polarity Select Bit 7 */
    word PPSAD8      :1;                                       /* Port AD Polarity Select Bit 8 */
    word PPSAD9      :1;                                       /* Port AD Polarity Select Bit 9 */
    word PPSAD10     :1;                                       /* Port AD Polarity Select Bit 10 */
    word PPSAD11     :1;                                       /* Port AD Polarity Select Bit 11 */
    word PPSAD12     :1;                                       /* Port AD Polarity Select Bit 12 */
    word PPSAD13     :1;                                       /* Port AD Polarity Select Bit 13 */
    word PPSAD14     :1;                                       /* Port AD Polarity Select Bit 14 */
    word PPSAD15     :1;                                       /* Port AD Polarity Select Bit 15 */
  } Bits;
} PPSADSTR;
extern volatile PPSADSTR _PPSAD @(REG_BASE + 0x0000027AUL);
#define PPSAD                           _PPSAD.Word
#define PPSAD_PPSAD0                    _PPSAD.Bits.PPSAD0
#define PPSAD_PPSAD1                    _PPSAD.Bits.PPSAD1
#define PPSAD_PPSAD2                    _PPSAD.Bits.PPSAD2
#define PPSAD_PPSAD3                    _PPSAD.Bits.PPSAD3
#define PPSAD_PPSAD4                    _PPSAD.Bits.PPSAD4
#define PPSAD_PPSAD5                    _PPSAD.Bits.PPSAD5
#define PPSAD_PPSAD6                    _PPSAD.Bits.PPSAD6
#define PPSAD_PPSAD7                    _PPSAD.Bits.PPSAD7
#define PPSAD_PPSAD8                    _PPSAD.Bits.PPSAD8
#define PPSAD_PPSAD9                    _PPSAD.Bits.PPSAD9
#define PPSAD_PPSAD10                   _PPSAD.Bits.PPSAD10
#define PPSAD_PPSAD11                   _PPSAD.Bits.PPSAD11
#define PPSAD_PPSAD12                   _PPSAD.Bits.PPSAD12
#define PPSAD_PPSAD13                   _PPSAD.Bits.PPSAD13
#define PPSAD_PPSAD14                   _PPSAD.Bits.PPSAD14
#define PPSAD_PPSAD15                   _PPSAD.Bits.PPSAD15

#define PPSAD_PPSAD0_MASK               1U
#define PPSAD_PPSAD1_MASK               2U
#define PPSAD_PPSAD2_MASK               4U
#define PPSAD_PPSAD3_MASK               8U
#define PPSAD_PPSAD4_MASK               16U
#define PPSAD_PPSAD5_MASK               32U
#define PPSAD_PPSAD6_MASK               64U
#define PPSAD_PPSAD7_MASK               128U
#define PPSAD_PPSAD8_MASK               256U
#define PPSAD_PPSAD9_MASK               512U
#define PPSAD_PPSAD10_MASK              1024U
#define PPSAD_PPSAD11_MASK              2048U
#define PPSAD_PPSAD12_MASK              4096U
#define PPSAD_PPSAD13_MASK              8192U
#define PPSAD_PPSAD14_MASK              16384U
#define PPSAD_PPSAD15_MASK              32768U


/*** PIEAD - Port AD Interrupt Enable Register; 0x0000027C ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** PIEADHi - Port AD Interrupt Enable Register High; 0x0000027C ***/
    union {
      byte Byte;
      struct {
        byte PIEAD8      :1;                                       /* Port AD Interrupt Enable Bit 8 */
        byte PIEAD9      :1;                                       /* Port AD Interrupt Enable Bit 9 */
        byte PIEAD10     :1;                                       /* Port AD Interrupt Enable Bit 10 */
        byte PIEAD11     :1;                                       /* Port AD Interrupt Enable Bit 11 */
        byte PIEAD12     :1;                                       /* Port AD Interrupt Enable Bit 12 */
        byte PIEAD13     :1;                                       /* Port AD Interrupt Enable Bit 13 */
        byte PIEAD14     :1;                                       /* Port AD Interrupt Enable Bit 14 */
        byte PIEAD15     :1;                                       /* Port AD Interrupt Enable Bit 15 */
      } Bits;
    } PIEADHiSTR;
    #define PIEADHi                     _PIEAD.Overlap_STR.PIEADHiSTR.Byte
    #define PIEADHi_PIEAD8              _PIEAD.Overlap_STR.PIEADHiSTR.Bits.PIEAD8
    #define PIEADHi_PIEAD9              _PIEAD.Overlap_STR.PIEADHiSTR.Bits.PIEAD9
    #define PIEADHi_PIEAD10             _PIEAD.Overlap_STR.PIEADHiSTR.Bits.PIEAD10
    #define PIEADHi_PIEAD11             _PIEAD.Overlap_STR.PIEADHiSTR.Bits.PIEAD11
    #define PIEADHi_PIEAD12             _PIEAD.Overlap_STR.PIEADHiSTR.Bits.PIEAD12
    #define PIEADHi_PIEAD13             _PIEAD.Overlap_STR.PIEADHiSTR.Bits.PIEAD13
    #define PIEADHi_PIEAD14             _PIEAD.Overlap_STR.PIEADHiSTR.Bits.PIEAD14
    #define PIEADHi_PIEAD15             _PIEAD.Overlap_STR.PIEADHiSTR.Bits.PIEAD15
    
    #define PIEADHi_PIEAD8_MASK         1U
    #define PIEADHi_PIEAD9_MASK         2U
    #define PIEADHi_PIEAD10_MASK        4U
    #define PIEADHi_PIEAD11_MASK        8U
    #define PIEADHi_PIEAD12_MASK        16U
    #define PIEADHi_PIEAD13_MASK        32U
    #define PIEADHi_PIEAD14_MASK        64U
    #define PIEADHi_PIEAD15_MASK        128U
    

    /*** PIEADLo - Port AD Interrupt Enable Register Low; 0x0000027D ***/
    union {
      byte Byte;
      struct {
        byte PIEAD0      :1;                                       /* Port AD Interrupt Enable Bit 0 */
        byte PIEAD1      :1;                                       /* Port AD Interrupt Enable Bit 1 */
        byte PIEAD2      :1;                                       /* Port AD Interrupt Enable Bit 2 */
        byte PIEAD3      :1;                                       /* Port AD Interrupt Enable Bit 3 */
        byte PIEAD4      :1;                                       /* Port AD Interrupt Enable Bit 4 */
        byte PIEAD5      :1;                                       /* Port AD Interrupt Enable Bit 5 */
        byte PIEAD6      :1;                                       /* Port AD Interrupt Enable Bit 6 */
        byte PIEAD7      :1;                                       /* Port AD Interrupt Enable Bit 7 */
      } Bits;
    } PIEADLoSTR;
    #define PIEADLo                     _PIEAD.Overlap_STR.PIEADLoSTR.Byte
    #define PIEADLo_PIEAD0              _PIEAD.Overlap_STR.PIEADLoSTR.Bits.PIEAD0
    #define PIEADLo_PIEAD1              _PIEAD.Overlap_STR.PIEADLoSTR.Bits.PIEAD1
    #define PIEADLo_PIEAD2              _PIEAD.Overlap_STR.PIEADLoSTR.Bits.PIEAD2
    #define PIEADLo_PIEAD3              _PIEAD.Overlap_STR.PIEADLoSTR.Bits.PIEAD3
    #define PIEADLo_PIEAD4              _PIEAD.Overlap_STR.PIEADLoSTR.Bits.PIEAD4
    #define PIEADLo_PIEAD5              _PIEAD.Overlap_STR.PIEADLoSTR.Bits.PIEAD5
    #define PIEADLo_PIEAD6              _PIEAD.Overlap_STR.PIEADLoSTR.Bits.PIEAD6
    #define PIEADLo_PIEAD7              _PIEAD.Overlap_STR.PIEADLoSTR.Bits.PIEAD7
    
    #define PIEADLo_PIEAD0_MASK         1U
    #define PIEADLo_PIEAD1_MASK         2U
    #define PIEADLo_PIEAD2_MASK         4U
    #define PIEADLo_PIEAD3_MASK         8U
    #define PIEADLo_PIEAD4_MASK         16U
    #define PIEADLo_PIEAD5_MASK         32U
    #define PIEADLo_PIEAD6_MASK         64U
    #define PIEADLo_PIEAD7_MASK         128U
    
  } Overlap_STR;

  struct {
    word PIEAD0      :1;                                       /* Port AD Interrupt Enable Bit 0 */
    word PIEAD1      :1;                                       /* Port AD Interrupt Enable Bit 1 */
    word PIEAD2      :1;                                       /* Port AD Interrupt Enable Bit 2 */
    word PIEAD3      :1;                                       /* Port AD Interrupt Enable Bit 3 */
    word PIEAD4      :1;                                       /* Port AD Interrupt Enable Bit 4 */
    word PIEAD5      :1;                                       /* Port AD Interrupt Enable Bit 5 */
    word PIEAD6      :1;                                       /* Port AD Interrupt Enable Bit 6 */
    word PIEAD7      :1;                                       /* Port AD Interrupt Enable Bit 7 */
    word PIEAD8      :1;                                       /* Port AD Interrupt Enable Bit 8 */
    word PIEAD9      :1;                                       /* Port AD Interrupt Enable Bit 9 */
    word PIEAD10     :1;                                       /* Port AD Interrupt Enable Bit 10 */
    word PIEAD11     :1;                                       /* Port AD Interrupt Enable Bit 11 */
    word PIEAD12     :1;                                       /* Port AD Interrupt Enable Bit 12 */
    word PIEAD13     :1;                                       /* Port AD Interrupt Enable Bit 13 */
    word PIEAD14     :1;                                       /* Port AD Interrupt Enable Bit 14 */
    word PIEAD15     :1;                                       /* Port AD Interrupt Enable Bit 15 */
  } Bits;
} PIEADSTR;
extern volatile PIEADSTR _PIEAD @(REG_BASE + 0x0000027CUL);
#define PIEAD                           _PIEAD.Word
#define PIEAD_PIEAD0                    _PIEAD.Bits.PIEAD0
#define PIEAD_PIEAD1                    _PIEAD.Bits.PIEAD1
#define PIEAD_PIEAD2                    _PIEAD.Bits.PIEAD2
#define PIEAD_PIEAD3                    _PIEAD.Bits.PIEAD3
#define PIEAD_PIEAD4                    _PIEAD.Bits.PIEAD4
#define PIEAD_PIEAD5                    _PIEAD.Bits.PIEAD5
#define PIEAD_PIEAD6                    _PIEAD.Bits.PIEAD6
#define PIEAD_PIEAD7                    _PIEAD.Bits.PIEAD7
#define PIEAD_PIEAD8                    _PIEAD.Bits.PIEAD8
#define PIEAD_PIEAD9                    _PIEAD.Bits.PIEAD9
#define PIEAD_PIEAD10                   _PIEAD.Bits.PIEAD10
#define PIEAD_PIEAD11                   _PIEAD.Bits.PIEAD11
#define PIEAD_PIEAD12                   _PIEAD.Bits.PIEAD12
#define PIEAD_PIEAD13                   _PIEAD.Bits.PIEAD13
#define PIEAD_PIEAD14                   _PIEAD.Bits.PIEAD14
#define PIEAD_PIEAD15                   _PIEAD.Bits.PIEAD15

#define PIEAD_PIEAD0_MASK               1U
#define PIEAD_PIEAD1_MASK               2U
#define PIEAD_PIEAD2_MASK               4U
#define PIEAD_PIEAD3_MASK               8U
#define PIEAD_PIEAD4_MASK               16U
#define PIEAD_PIEAD5_MASK               32U
#define PIEAD_PIEAD6_MASK               64U
#define PIEAD_PIEAD7_MASK               128U
#define PIEAD_PIEAD8_MASK               256U
#define PIEAD_PIEAD9_MASK               512U
#define PIEAD_PIEAD10_MASK              1024U
#define PIEAD_PIEAD11_MASK              2048U
#define PIEAD_PIEAD12_MASK              4096U
#define PIEAD_PIEAD13_MASK              8192U
#define PIEAD_PIEAD14_MASK              16384U
#define PIEAD_PIEAD15_MASK              32768U


/*** PIFAD - Port AD Interrupt Flag Register; 0x0000027E ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** PIFADHi - Port AD Interrupt Flag Register High; 0x0000027E ***/
    union {
      byte Byte;
      struct {
        byte PIFAD8      :1;                                       /* Port AD Interrupt Flag Bit 8 */
        byte PIFAD9      :1;                                       /* Port AD Interrupt Flag Bit 9 */
        byte PIFAD10     :1;                                       /* Port AD Interrupt Flag Bit 10 */
        byte PIFAD11     :1;                                       /* Port AD Interrupt Flag Bit 11 */
        byte PIFAD12     :1;                                       /* Port AD Interrupt Flag Bit 12 */
        byte PIFAD13     :1;                                       /* Port AD Interrupt Flag Bit 13 */
        byte PIFAD14     :1;                                       /* Port AD Interrupt Flag Bit 14 */
        byte PIFAD15     :1;                                       /* Port AD Interrupt Flag Bit 15 */
      } Bits;
    } PIFADHiSTR;
    #define PIFADHi                     _PIFAD.Overlap_STR.PIFADHiSTR.Byte
    #define PIFADHi_PIFAD8              _PIFAD.Overlap_STR.PIFADHiSTR.Bits.PIFAD8
    #define PIFADHi_PIFAD9              _PIFAD.Overlap_STR.PIFADHiSTR.Bits.PIFAD9
    #define PIFADHi_PIFAD10             _PIFAD.Overlap_STR.PIFADHiSTR.Bits.PIFAD10
    #define PIFADHi_PIFAD11             _PIFAD.Overlap_STR.PIFADHiSTR.Bits.PIFAD11
    #define PIFADHi_PIFAD12             _PIFAD.Overlap_STR.PIFADHiSTR.Bits.PIFAD12
    #define PIFADHi_PIFAD13             _PIFAD.Overlap_STR.PIFADHiSTR.Bits.PIFAD13
    #define PIFADHi_PIFAD14             _PIFAD.Overlap_STR.PIFADHiSTR.Bits.PIFAD14
    #define PIFADHi_PIFAD15             _PIFAD.Overlap_STR.PIFADHiSTR.Bits.PIFAD15
    
    #define PIFADHi_PIFAD8_MASK         1U
    #define PIFADHi_PIFAD9_MASK         2U
    #define PIFADHi_PIFAD10_MASK        4U
    #define PIFADHi_PIFAD11_MASK        8U
    #define PIFADHi_PIFAD12_MASK        16U
    #define PIFADHi_PIFAD13_MASK        32U
    #define PIFADHi_PIFAD14_MASK        64U
    #define PIFADHi_PIFAD15_MASK        128U
    

    /*** PIFADLo - Port AD Interrupt Flag Register Low; 0x0000027F ***/
    union {
      byte Byte;
      struct {
        byte PIFAD0      :1;                                       /* Port AD Interrupt Flag Bit 0 */
        byte PIFAD1      :1;                                       /* Port AD Interrupt Flag Bit 1 */
        byte PIFAD2      :1;                                       /* Port AD Interrupt Flag Bit 2 */
        byte PIFAD3      :1;                                       /* Port AD Interrupt Flag Bit 3 */
        byte PIFAD4      :1;                                       /* Port AD Interrupt Flag Bit 4 */
        byte PIFAD5      :1;                                       /* Port AD Interrupt Flag Bit 5 */
        byte PIFAD6      :1;                                       /* Port AD Interrupt Flag Bit 6 */
        byte PIFAD7      :1;                                       /* Port AD Interrupt Flag Bit 7 */
      } Bits;
    } PIFADLoSTR;
    #define PIFADLo                     _PIFAD.Overlap_STR.PIFADLoSTR.Byte
    #define PIFADLo_PIFAD0              _PIFAD.Overlap_STR.PIFADLoSTR.Bits.PIFAD0
    #define PIFADLo_PIFAD1              _PIFAD.Overlap_STR.PIFADLoSTR.Bits.PIFAD1
    #define PIFADLo_PIFAD2              _PIFAD.Overlap_STR.PIFADLoSTR.Bits.PIFAD2
    #define PIFADLo_PIFAD3              _PIFAD.Overlap_STR.PIFADLoSTR.Bits.PIFAD3
    #define PIFADLo_PIFAD4              _PIFAD.Overlap_STR.PIFADLoSTR.Bits.PIFAD4
    #define PIFADLo_PIFAD5              _PIFAD.Overlap_STR.PIFADLoSTR.Bits.PIFAD5
    #define PIFADLo_PIFAD6              _PIFAD.Overlap_STR.PIFADLoSTR.Bits.PIFAD6
    #define PIFADLo_PIFAD7              _PIFAD.Overlap_STR.PIFADLoSTR.Bits.PIFAD7
    
    #define PIFADLo_PIFAD0_MASK         1U
    #define PIFADLo_PIFAD1_MASK         2U
    #define PIFADLo_PIFAD2_MASK         4U
    #define PIFADLo_PIFAD3_MASK         8U
    #define PIFADLo_PIFAD4_MASK         16U
    #define PIFADLo_PIFAD5_MASK         32U
    #define PIFADLo_PIFAD6_MASK         64U
    #define PIFADLo_PIFAD7_MASK         128U
    
  } Overlap_STR;

  struct {
    word PIFAD0      :1;                                       /* Port AD Interrupt Flag Bit 0 */
    word PIFAD1      :1;                                       /* Port AD Interrupt Flag Bit 1 */
    word PIFAD2      :1;                                       /* Port AD Interrupt Flag Bit 2 */
    word PIFAD3      :1;                                       /* Port AD Interrupt Flag Bit 3 */
    word PIFAD4      :1;                                       /* Port AD Interrupt Flag Bit 4 */
    word PIFAD5      :1;                                       /* Port AD Interrupt Flag Bit 5 */
    word PIFAD6      :1;                                       /* Port AD Interrupt Flag Bit 6 */
    word PIFAD7      :1;                                       /* Port AD Interrupt Flag Bit 7 */
    word PIFAD8      :1;                                       /* Port AD Interrupt Flag Bit 8 */
    word PIFAD9      :1;                                       /* Port AD Interrupt Flag Bit 9 */
    word PIFAD10     :1;                                       /* Port AD Interrupt Flag Bit 10 */
    word PIFAD11     :1;                                       /* Port AD Interrupt Flag Bit 11 */
    word PIFAD12     :1;                                       /* Port AD Interrupt Flag Bit 12 */
    word PIFAD13     :1;                                       /* Port AD Interrupt Flag Bit 13 */
    word PIFAD14     :1;                                       /* Port AD Interrupt Flag Bit 14 */
    word PIFAD15     :1;                                       /* Port AD Interrupt Flag Bit 15 */
  } Bits;
} PIFADSTR;
extern volatile PIFADSTR _PIFAD @(REG_BASE + 0x0000027EUL);
#define PIFAD                           _PIFAD.Word
#define PIFAD_PIFAD0                    _PIFAD.Bits.PIFAD0
#define PIFAD_PIFAD1                    _PIFAD.Bits.PIFAD1
#define PIFAD_PIFAD2                    _PIFAD.Bits.PIFAD2
#define PIFAD_PIFAD3                    _PIFAD.Bits.PIFAD3
#define PIFAD_PIFAD4                    _PIFAD.Bits.PIFAD4
#define PIFAD_PIFAD5                    _PIFAD.Bits.PIFAD5
#define PIFAD_PIFAD6                    _PIFAD.Bits.PIFAD6
#define PIFAD_PIFAD7                    _PIFAD.Bits.PIFAD7
#define PIFAD_PIFAD8                    _PIFAD.Bits.PIFAD8
#define PIFAD_PIFAD9                    _PIFAD.Bits.PIFAD9
#define PIFAD_PIFAD10                   _PIFAD.Bits.PIFAD10
#define PIFAD_PIFAD11                   _PIFAD.Bits.PIFAD11
#define PIFAD_PIFAD12                   _PIFAD.Bits.PIFAD12
#define PIFAD_PIFAD13                   _PIFAD.Bits.PIFAD13
#define PIFAD_PIFAD14                   _PIFAD.Bits.PIFAD14
#define PIFAD_PIFAD15                   _PIFAD.Bits.PIFAD15

#define PIFAD_PIFAD0_MASK               1U
#define PIFAD_PIFAD1_MASK               2U
#define PIFAD_PIFAD2_MASK               4U
#define PIFAD_PIFAD3_MASK               8U
#define PIFAD_PIFAD4_MASK               16U
#define PIFAD_PIFAD5_MASK               32U
#define PIFAD_PIFAD6_MASK               64U
#define PIFAD_PIFAD7_MASK               128U
#define PIFAD_PIFAD8_MASK               256U
#define PIFAD_PIFAD9_MASK               512U
#define PIFAD_PIFAD10_MASK              1024U
#define PIFAD_PIFAD11_MASK              2048U
#define PIFAD_PIFAD12_MASK              4096U
#define PIFAD_PIFAD13_MASK              8192U
#define PIFAD_PIFAD14_MASK              16384U
#define PIFAD_PIFAD15_MASK              32768U


/*** BAKEY0 - Backdoor Access Key 0; 0x0000FF00 ***/
typedef union {
  word Word;
  struct {
    word KEY0        :1;                                       /* Backdoor Access Key bits, bit 0 */
    word KEY1        :1;                                       /* Backdoor Access Key bits, bit 1 */
    word KEY2        :1;                                       /* Backdoor Access Key bits, bit 2 */
    word KEY3        :1;                                       /* Backdoor Access Key bits, bit 3 */
    word KEY4        :1;                                       /* Backdoor Access Key bits, bit 4 */
    word KEY5        :1;                                       /* Backdoor Access Key bits, bit 5 */
    word KEY6        :1;                                       /* Backdoor Access Key bits, bit 6 */
    word KEY7        :1;                                       /* Backdoor Access Key bits, bit 7 */
    word KEY8        :1;                                       /* Backdoor Access Key bits, bit 8 */
    word KEY9        :1;                                       /* Backdoor Access Key bits, bit 9 */
    word KEY10       :1;                                       /* Backdoor Access Key bits, bit 10 */
    word KEY11       :1;                                       /* Backdoor Access Key bits, bit 11 */
    word KEY12       :1;                                       /* Backdoor Access Key bits, bit 12 */
    word KEY13       :1;                                       /* Backdoor Access Key bits, bit 13 */
    word KEY14       :1;                                       /* Backdoor Access Key bits, bit 14 */
    word KEY15       :1;                                       /* Backdoor Access Key bits, bit 15 */
  } Bits;
} BAKEY0STR;
/* Tip for register initialization in the user code:  const word BAKEY0_INIT @0x0000FF00 = <BAKEY0_INITVAL>; */
#define _BAKEY0 (*(const BAKEY0STR *)0x0000FF00)
#define BAKEY0                          _BAKEY0.Word
#define BAKEY0_KEY0                     _BAKEY0.Bits.KEY0
#define BAKEY0_KEY1                     _BAKEY0.Bits.KEY1
#define BAKEY0_KEY2                     _BAKEY0.Bits.KEY2
#define BAKEY0_KEY3                     _BAKEY0.Bits.KEY3
#define BAKEY0_KEY4                     _BAKEY0.Bits.KEY4
#define BAKEY0_KEY5                     _BAKEY0.Bits.KEY5
#define BAKEY0_KEY6                     _BAKEY0.Bits.KEY6
#define BAKEY0_KEY7                     _BAKEY0.Bits.KEY7
#define BAKEY0_KEY8                     _BAKEY0.Bits.KEY8
#define BAKEY0_KEY9                     _BAKEY0.Bits.KEY9
#define BAKEY0_KEY10                    _BAKEY0.Bits.KEY10
#define BAKEY0_KEY11                    _BAKEY0.Bits.KEY11
#define BAKEY0_KEY12                    _BAKEY0.Bits.KEY12
#define BAKEY0_KEY13                    _BAKEY0.Bits.KEY13
#define BAKEY0_KEY14                    _BAKEY0.Bits.KEY14
#define BAKEY0_KEY15                    _BAKEY0.Bits.KEY15
/* BAKEY_ARR: Access 4 BAKEYx registers in an array */
#define BAKEY_ARR                       ((volatile word *) &BAKEY0)

#define BAKEY0_KEY0_MASK                1U
#define BAKEY0_KEY1_MASK                2U
#define BAKEY0_KEY2_MASK                4U
#define BAKEY0_KEY3_MASK                8U
#define BAKEY0_KEY4_MASK                16U
#define BAKEY0_KEY5_MASK                32U
#define BAKEY0_KEY6_MASK                64U
#define BAKEY0_KEY7_MASK                128U
#define BAKEY0_KEY8_MASK                256U
#define BAKEY0_KEY9_MASK                512U
#define BAKEY0_KEY10_MASK               1024U
#define BAKEY0_KEY11_MASK               2048U
#define BAKEY0_KEY12_MASK               4096U
#define BAKEY0_KEY13_MASK               8192U
#define BAKEY0_KEY14_MASK               16384U
#define BAKEY0_KEY15_MASK               32768U


/*** BAKEY1 - Backdoor Access Key 1; 0x0000FF02 ***/
typedef union {
  word Word;
  struct {
    word KEY0        :1;                                       /* Backdoor Access Key bits, bit 0 */
    word KEY1        :1;                                       /* Backdoor Access Key bits, bit 1 */
    word KEY2        :1;                                       /* Backdoor Access Key bits, bit 2 */
    word KEY3        :1;                                       /* Backdoor Access Key bits, bit 3 */
    word KEY4        :1;                                       /* Backdoor Access Key bits, bit 4 */
    word KEY5        :1;                                       /* Backdoor Access Key bits, bit 5 */
    word KEY6        :1;                                       /* Backdoor Access Key bits, bit 6 */
    word KEY7        :1;                                       /* Backdoor Access Key bits, bit 7 */
    word KEY8        :1;                                       /* Backdoor Access Key bits, bit 8 */
    word KEY9        :1;                                       /* Backdoor Access Key bits, bit 9 */
    word KEY10       :1;                                       /* Backdoor Access Key bits, bit 10 */
    word KEY11       :1;                                       /* Backdoor Access Key bits, bit 11 */
    word KEY12       :1;                                       /* Backdoor Access Key bits, bit 12 */
    word KEY13       :1;                                       /* Backdoor Access Key bits, bit 13 */
    word KEY14       :1;                                       /* Backdoor Access Key bits, bit 14 */
    word KEY15       :1;                                       /* Backdoor Access Key bits, bit 15 */
  } Bits;
} BAKEY1STR;
/* Tip for register initialization in the user code:  const word BAKEY1_INIT @0x0000FF02 = <BAKEY1_INITVAL>; */
#define _BAKEY1 (*(const BAKEY1STR *)0x0000FF02)
#define BAKEY1                          _BAKEY1.Word
#define BAKEY1_KEY0                     _BAKEY1.Bits.KEY0
#define BAKEY1_KEY1                     _BAKEY1.Bits.KEY1
#define BAKEY1_KEY2                     _BAKEY1.Bits.KEY2
#define BAKEY1_KEY3                     _BAKEY1.Bits.KEY3
#define BAKEY1_KEY4                     _BAKEY1.Bits.KEY4
#define BAKEY1_KEY5                     _BAKEY1.Bits.KEY5
#define BAKEY1_KEY6                     _BAKEY1.Bits.KEY6
#define BAKEY1_KEY7                     _BAKEY1.Bits.KEY7
#define BAKEY1_KEY8                     _BAKEY1.Bits.KEY8
#define BAKEY1_KEY9                     _BAKEY1.Bits.KEY9
#define BAKEY1_KEY10                    _BAKEY1.Bits.KEY10
#define BAKEY1_KEY11                    _BAKEY1.Bits.KEY11
#define BAKEY1_KEY12                    _BAKEY1.Bits.KEY12
#define BAKEY1_KEY13                    _BAKEY1.Bits.KEY13
#define BAKEY1_KEY14                    _BAKEY1.Bits.KEY14
#define BAKEY1_KEY15                    _BAKEY1.Bits.KEY15

#define BAKEY1_KEY0_MASK                1U
#define BAKEY1_KEY1_MASK                2U
#define BAKEY1_KEY2_MASK                4U
#define BAKEY1_KEY3_MASK                8U
#define BAKEY1_KEY4_MASK                16U
#define BAKEY1_KEY5_MASK                32U
#define BAKEY1_KEY6_MASK                64U
#define BAKEY1_KEY7_MASK                128U
#define BAKEY1_KEY8_MASK                256U
#define BAKEY1_KEY9_MASK                512U
#define BAKEY1_KEY10_MASK               1024U
#define BAKEY1_KEY11_MASK               2048U
#define BAKEY1_KEY12_MASK               4096U
#define BAKEY1_KEY13_MASK               8192U
#define BAKEY1_KEY14_MASK               16384U
#define BAKEY1_KEY15_MASK               32768U


/*** BAKEY2 - Backdoor Access Key 2; 0x0000FF04 ***/
typedef union {
  word Word;
  struct {
    word KEY0        :1;                                       /* Backdoor Access Key bits, bit 0 */
    word KEY1        :1;                                       /* Backdoor Access Key bits, bit 1 */
    word KEY2        :1;                                       /* Backdoor Access Key bits, bit 2 */
    word KEY3        :1;                                       /* Backdoor Access Key bits, bit 3 */
    word KEY4        :1;                                       /* Backdoor Access Key bits, bit 4 */
    word KEY5        :1;                                       /* Backdoor Access Key bits, bit 5 */
    word KEY6        :1;                                       /* Backdoor Access Key bits, bit 6 */
    word KEY7        :1;                                       /* Backdoor Access Key bits, bit 7 */
    word KEY8        :1;                                       /* Backdoor Access Key bits, bit 8 */
    word KEY9        :1;                                       /* Backdoor Access Key bits, bit 9 */
    word KEY10       :1;                                       /* Backdoor Access Key bits, bit 10 */
    word KEY11       :1;                                       /* Backdoor Access Key bits, bit 11 */
    word KEY12       :1;                                       /* Backdoor Access Key bits, bit 12 */
    word KEY13       :1;                                       /* Backdoor Access Key bits, bit 13 */
    word KEY14       :1;                                       /* Backdoor Access Key bits, bit 14 */
    word KEY15       :1;                                       /* Backdoor Access Key bits, bit 15 */
  } Bits;
} BAKEY2STR;
/* Tip for register initialization in the user code:  const word BAKEY2_INIT @0x0000FF04 = <BAKEY2_INITVAL>; */
#define _BAKEY2 (*(const BAKEY2STR *)0x0000FF04)
#define BAKEY2                          _BAKEY2.Word
#define BAKEY2_KEY0                     _BAKEY2.Bits.KEY0
#define BAKEY2_KEY1                     _BAKEY2.Bits.KEY1
#define BAKEY2_KEY2                     _BAKEY2.Bits.KEY2
#define BAKEY2_KEY3                     _BAKEY2.Bits.KEY3
#define BAKEY2_KEY4                     _BAKEY2.Bits.KEY4
#define BAKEY2_KEY5                     _BAKEY2.Bits.KEY5
#define BAKEY2_KEY6                     _BAKEY2.Bits.KEY6
#define BAKEY2_KEY7                     _BAKEY2.Bits.KEY7
#define BAKEY2_KEY8                     _BAKEY2.Bits.KEY8
#define BAKEY2_KEY9                     _BAKEY2.Bits.KEY9
#define BAKEY2_KEY10                    _BAKEY2.Bits.KEY10
#define BAKEY2_KEY11                    _BAKEY2.Bits.KEY11
#define BAKEY2_KEY12                    _BAKEY2.Bits.KEY12
#define BAKEY2_KEY13                    _BAKEY2.Bits.KEY13
#define BAKEY2_KEY14                    _BAKEY2.Bits.KEY14
#define BAKEY2_KEY15                    _BAKEY2.Bits.KEY15

#define BAKEY2_KEY0_MASK                1U
#define BAKEY2_KEY1_MASK                2U
#define BAKEY2_KEY2_MASK                4U
#define BAKEY2_KEY3_MASK                8U
#define BAKEY2_KEY4_MASK                16U
#define BAKEY2_KEY5_MASK                32U
#define BAKEY2_KEY6_MASK                64U
#define BAKEY2_KEY7_MASK                128U
#define BAKEY2_KEY8_MASK                256U
#define BAKEY2_KEY9_MASK                512U
#define BAKEY2_KEY10_MASK               1024U
#define BAKEY2_KEY11_MASK               2048U
#define BAKEY2_KEY12_MASK               4096U
#define BAKEY2_KEY13_MASK               8192U
#define BAKEY2_KEY14_MASK               16384U
#define BAKEY2_KEY15_MASK               32768U


/*** BAKEY3 - Backdoor Access Key 3; 0x0000FF06 ***/
typedef union {
  word Word;
  struct {
    word KEY0        :1;                                       /* Backdoor Access Key bits, bit 0 */
    word KEY1        :1;                                       /* Backdoor Access Key bits, bit 1 */
    word KEY2        :1;                                       /* Backdoor Access Key bits, bit 2 */
    word KEY3        :1;                                       /* Backdoor Access Key bits, bit 3 */
    word KEY4        :1;                                       /* Backdoor Access Key bits, bit 4 */
    word KEY5        :1;                                       /* Backdoor Access Key bits, bit 5 */
    word KEY6        :1;                                       /* Backdoor Access Key bits, bit 6 */
    word KEY7        :1;                                       /* Backdoor Access Key bits, bit 7 */
    word KEY8        :1;                                       /* Backdoor Access Key bits, bit 8 */
    word KEY9        :1;                                       /* Backdoor Access Key bits, bit 9 */
    word KEY10       :1;                                       /* Backdoor Access Key bits, bit 10 */
    word KEY11       :1;                                       /* Backdoor Access Key bits, bit 11 */
    word KEY12       :1;                                       /* Backdoor Access Key bits, bit 12 */
    word KEY13       :1;                                       /* Backdoor Access Key bits, bit 13 */
    word KEY14       :1;                                       /* Backdoor Access Key bits, bit 14 */
    word KEY15       :1;                                       /* Backdoor Access Key bits, bit 15 */
  } Bits;
} BAKEY3STR;
/* Tip for register initialization in the user code:  const word BAKEY3_INIT @0x0000FF06 = <BAKEY3_INITVAL>; */
#define _BAKEY3 (*(const BAKEY3STR *)0x0000FF06)
#define BAKEY3                          _BAKEY3.Word
#define BAKEY3_KEY0                     _BAKEY3.Bits.KEY0
#define BAKEY3_KEY1                     _BAKEY3.Bits.KEY1
#define BAKEY3_KEY2                     _BAKEY3.Bits.KEY2
#define BAKEY3_KEY3                     _BAKEY3.Bits.KEY3
#define BAKEY3_KEY4                     _BAKEY3.Bits.KEY4
#define BAKEY3_KEY5                     _BAKEY3.Bits.KEY5
#define BAKEY3_KEY6                     _BAKEY3.Bits.KEY6
#define BAKEY3_KEY7                     _BAKEY3.Bits.KEY7
#define BAKEY3_KEY8                     _BAKEY3.Bits.KEY8
#define BAKEY3_KEY9                     _BAKEY3.Bits.KEY9
#define BAKEY3_KEY10                    _BAKEY3.Bits.KEY10
#define BAKEY3_KEY11                    _BAKEY3.Bits.KEY11
#define BAKEY3_KEY12                    _BAKEY3.Bits.KEY12
#define BAKEY3_KEY13                    _BAKEY3.Bits.KEY13
#define BAKEY3_KEY14                    _BAKEY3.Bits.KEY14
#define BAKEY3_KEY15                    _BAKEY3.Bits.KEY15

#define BAKEY3_KEY0_MASK                1U
#define BAKEY3_KEY1_MASK                2U
#define BAKEY3_KEY2_MASK                4U
#define BAKEY3_KEY3_MASK                8U
#define BAKEY3_KEY4_MASK                16U
#define BAKEY3_KEY5_MASK                32U
#define BAKEY3_KEY6_MASK                64U
#define BAKEY3_KEY7_MASK                128U
#define BAKEY3_KEY8_MASK                256U
#define BAKEY3_KEY9_MASK                512U
#define BAKEY3_KEY10_MASK               1024U
#define BAKEY3_KEY11_MASK               2048U
#define BAKEY3_KEY12_MASK               4096U
#define BAKEY3_KEY13_MASK               8192U
#define BAKEY3_KEY14_MASK               16384U
#define BAKEY3_KEY15_MASK               32768U


/*** NVFPROT0 - Non volatile Block 0 Flash Protection Register; 0x0000FF0D ***/
typedef union {
  byte Byte;
  struct {
    byte FPLS0       :1;                                       /* Flash Protection Lower Address size 0 */
    byte FPLS1       :1;                                       /* Flash Protection Lower Address size 1 */
    byte FPLDIS      :1;                                       /* Flash Protection Lower address range disable */
    byte FPHS0       :1;                                       /* Flash Protection Higher address size 0 */
    byte FPHS1       :1;                                       /* Flash Protection Higher address size 1 */
    byte FPHDIS      :1;                                       /* Flash Protection Higher address range disable */
    byte NV6         :1;                                       /* Non Volatile Flag Bit */
    byte FPOPEN      :1;                                       /* Opens the flash block or subsections of it for program or erase */
  } Bits;
  struct {
    byte grpFPLS :2;
    byte         :1;
    byte grpFPHS :2;
    byte         :1;
    byte grpNV_6 :1;
    byte         :1;
  } MergedBits;
} NVFPROT0STR;
/* Tip for register initialization in the user code:  const byte NVFPROT0_INIT @0x0000FF0D = <NVFPROT0_INITVAL>; */
#define _NVFPROT0 (*(const NVFPROT0STR *)0x0000FF0D)
#define NVFPROT0                        _NVFPROT0.Byte
#define NVFPROT0_FPLS0                  _NVFPROT0.Bits.FPLS0
#define NVFPROT0_FPLS1                  _NVFPROT0.Bits.FPLS1
#define NVFPROT0_FPLDIS                 _NVFPROT0.Bits.FPLDIS
#define NVFPROT0_FPHS0                  _NVFPROT0.Bits.FPHS0
#define NVFPROT0_FPHS1                  _NVFPROT0.Bits.FPHS1
#define NVFPROT0_FPHDIS                 _NVFPROT0.Bits.FPHDIS
#define NVFPROT0_NV6                    _NVFPROT0.Bits.NV6
#define NVFPROT0_FPOPEN                 _NVFPROT0.Bits.FPOPEN
#define NVFPROT0_FPLS                   _NVFPROT0.MergedBits.grpFPLS
#define NVFPROT0_FPHS                   _NVFPROT0.MergedBits.grpFPHS

#define NVFPROT0_FPLS0_MASK             1U
#define NVFPROT0_FPLS1_MASK             2U
#define NVFPROT0_FPLDIS_MASK            4U
#define NVFPROT0_FPHS0_MASK             8U
#define NVFPROT0_FPHS1_MASK             16U
#define NVFPROT0_FPHDIS_MASK            32U
#define NVFPROT0_NV6_MASK               64U
#define NVFPROT0_FPOPEN_MASK            128U
#define NVFPROT0_FPLS_MASK              3U
#define NVFPROT0_FPLS_BITNUM            0U
#define NVFPROT0_FPHS_MASK              24U
#define NVFPROT0_FPHS_BITNUM            3U


/*** NVFSEC - Non volatile Flash Security Register; 0x0000FF0F ***/
typedef union {
  byte Byte;
  struct {
    byte SEC0        :1;                                       /* Memory security bit 0 */
    byte SEC1        :1;                                       /* Memory security bit 1 */
    byte NV2         :1;                                       /* Non Volatile flag bit 2 */
    byte NV3         :1;                                       /* Non Volatile flag bit 3 */
    byte NV4         :1;                                       /* Non Volatile flag bit 4 */
    byte NV5         :1;                                       /* Non Volatile flag bit 5 */
    byte NV6         :1;                                       /* Non Volatile flag bit 6 */
    byte KEYEN       :1;                                       /* Backdoor Key Security Enable */
  } Bits;
  struct {
    byte grpSEC  :2;
    byte grpNV_2 :5;
    byte         :1;
  } MergedBits;
} NVFSECSTR;
/* Tip for register initialization in the user code:  const byte NVFSEC_INIT @0x0000FF0F = <NVFSEC_INITVAL>; */
#define _NVFSEC (*(const NVFSECSTR *)0x0000FF0F)
#define NVFSEC                          _NVFSEC.Byte
#define NVFSEC_SEC0                     _NVFSEC.Bits.SEC0
#define NVFSEC_SEC1                     _NVFSEC.Bits.SEC1
#define NVFSEC_NV2                      _NVFSEC.Bits.NV2
#define NVFSEC_NV3                      _NVFSEC.Bits.NV3
#define NVFSEC_NV4                      _NVFSEC.Bits.NV4
#define NVFSEC_NV5                      _NVFSEC.Bits.NV5
#define NVFSEC_NV6                      _NVFSEC.Bits.NV6
#define NVFSEC_KEYEN                    _NVFSEC.Bits.KEYEN
#define NVFSEC_SEC                      _NVFSEC.MergedBits.grpSEC
#define NVFSEC_NV_2                     _NVFSEC.MergedBits.grpNV_2
#define NVFSEC_NV                       NVFSEC_NV_2

#define NVFSEC_SEC0_MASK                1U
#define NVFSEC_SEC1_MASK                2U
#define NVFSEC_NV2_MASK                 4U
#define NVFSEC_NV3_MASK                 8U
#define NVFSEC_NV4_MASK                 16U
#define NVFSEC_NV5_MASK                 32U
#define NVFSEC_NV6_MASK                 64U
#define NVFSEC_KEYEN_MASK               128U
#define NVFSEC_SEC_MASK                 3U
#define NVFSEC_SEC_BITNUM               0U
#define NVFSEC_NV_2_MASK                124U
#define NVFSEC_NV_2_BITNUM              2U


  /* Watchdog reset macro */
#ifndef __RESET_WATCHDOG
#ifdef _lint
  #define __RESET_WATCHDOG()  /* empty */
#else
  #define __RESET_WATCHDOG() (void)(ARMCOP = 0x55U, ARMCOP = 0xAAU)
#endif
#endif /* __RESET_WATCHDOG */


/***********************************************/
/**   D E P R E C I A T E D   S Y M B O L S   **/
/***********************************************/
/* --------------------------------------------------------------------------- */
/* The following symbols were removed, because they were invalid or irrelevant */
/* --------------------------------------------------------------------------- */
/*
 * Follows changes from the database 2.87.489 version */
#define VportAD                          Vportad
/*
 * Follows changes from the database 2.87.501 version */
#define PMFVAL0_PMFVAL00                 This_symb_has_been_depreciated
#define PMFVAL0_PMFVAL00_MASK            This_symb_has_been_depreciated
#define PMFVAL0_PMFVAL01                 This_symb_has_been_depreciated
#define PMFVAL0_PMFVAL01_MASK            This_symb_has_been_depreciated
#define PMFVAL0_PMFVAL02                 This_symb_has_been_depreciated
#define PMFVAL0_PMFVAL02_MASK            This_symb_has_been_depreciated
#define PMFVAL0_PMFVAL03                 This_symb_has_been_depreciated
#define PMFVAL0_PMFVAL03_MASK            This_symb_has_been_depreciated
#define PMFVAL0_PMFVAL04                 This_symb_has_been_depreciated
#define PMFVAL0_PMFVAL04_MASK            This_symb_has_been_depreciated
#define PMFVAL0_PMFVAL05                 This_symb_has_been_depreciated
#define PMFVAL0_PMFVAL05_MASK            This_symb_has_been_depreciated
#define PMFVAL0_PMFVAL06                 This_symb_has_been_depreciated
#define PMFVAL0_PMFVAL06_MASK            This_symb_has_been_depreciated
#define PMFVAL0_PMFVAL07                 This_symb_has_been_depreciated
#define PMFVAL0_PMFVAL07_MASK            This_symb_has_been_depreciated
#define PMFVAL0_PMFVAL08                 This_symb_has_been_depreciated
#define PMFVAL0_PMFVAL08_MASK            This_symb_has_been_depreciated
#define PMFVAL0_PMFVAL09                 This_symb_has_been_depreciated
#define PMFVAL0_PMFVAL09_MASK            This_symb_has_been_depreciated
#define PMFVAL0_PMFVAL010                This_symb_has_been_depreciated
#define PMFVAL0_PMFVAL010_MASK           This_symb_has_been_depreciated
#define PMFVAL0_PMFVAL011                This_symb_has_been_depreciated
#define PMFVAL0_PMFVAL011_MASK           This_symb_has_been_depreciated
#define PMFVAL0_PMFVAL012                This_symb_has_been_depreciated
#define PMFVAL0_PMFVAL012_MASK           This_symb_has_been_depreciated
#define PMFVAL0_PMFVAL013                This_symb_has_been_depreciated
#define PMFVAL0_PMFVAL013_MASK           This_symb_has_been_depreciated
#define PMFVAL0_PMFVAL014                This_symb_has_been_depreciated
#define PMFVAL0_PMFVAL014_MASK           This_symb_has_been_depreciated
#define PMFVAL0_PMFVAL0                  PMFVAL0_PMFVAL
#define PMFVAL0_PMFVAL0_BITNUM           PMFVAL0_PMFVAL_BITNUM
#define PMFVAL0_PMFVAL0_MASK             PMFVAL0_PMFVAL_MASK
#define PMFVAL1_PMFVAL10                 This_symb_has_been_depreciated
#define PMFVAL1_PMFVAL10_MASK            This_symb_has_been_depreciated
#define PMFVAL1_PMFVAL11                 This_symb_has_been_depreciated
#define PMFVAL1_PMFVAL11_MASK            This_symb_has_been_depreciated
#define PMFVAL1_PMFVAL12                 This_symb_has_been_depreciated
#define PMFVAL1_PMFVAL12_MASK            This_symb_has_been_depreciated
#define PMFVAL1_PMFVAL13                 This_symb_has_been_depreciated
#define PMFVAL1_PMFVAL13_MASK            This_symb_has_been_depreciated
#define PMFVAL1_PMFVAL14                 This_symb_has_been_depreciated
#define PMFVAL1_PMFVAL14_MASK            This_symb_has_been_depreciated
#define PMFVAL1_PMFVAL15                 This_symb_has_been_depreciated
#define PMFVAL1_PMFVAL15_MASK            This_symb_has_been_depreciated
#define PMFVAL1_PMFVAL16                 This_symb_has_been_depreciated
#define PMFVAL1_PMFVAL16_MASK            This_symb_has_been_depreciated
#define PMFVAL1_PMFVAL17                 This_symb_has_been_depreciated
#define PMFVAL1_PMFVAL17_MASK            This_symb_has_been_depreciated
#define PMFVAL1_PMFVAL18                 This_symb_has_been_depreciated
#define PMFVAL1_PMFVAL18_MASK            This_symb_has_been_depreciated
#define PMFVAL1_PMFVAL19                 This_symb_has_been_depreciated
#define PMFVAL1_PMFVAL19_MASK            This_symb_has_been_depreciated
#define PMFVAL1_PMFVAL110                This_symb_has_been_depreciated
#define PMFVAL1_PMFVAL110_MASK           This_symb_has_been_depreciated
#define PMFVAL1_PMFVAL111                This_symb_has_been_depreciated
#define PMFVAL1_PMFVAL111_MASK           This_symb_has_been_depreciated
#define PMFVAL1_PMFVAL112                This_symb_has_been_depreciated
#define PMFVAL1_PMFVAL112_MASK           This_symb_has_been_depreciated
#define PMFVAL1_PMFVAL113                This_symb_has_been_depreciated
#define PMFVAL1_PMFVAL113_MASK           This_symb_has_been_depreciated
#define PMFVAL1_PMFVAL114                This_symb_has_been_depreciated
#define PMFVAL1_PMFVAL114_MASK           This_symb_has_been_depreciated
#define PMFVAL1_PMFVAL1                  PMFVAL1_PMFVAL
#define PMFVAL1_PMFVAL1_BITNUM           PMFVAL1_PMFVAL_BITNUM
#define PMFVAL1_PMFVAL1_MASK             PMFVAL1_PMFVAL_MASK
#define PMFVAL2_PMFVAL20                 This_symb_has_been_depreciated
#define PMFVAL2_PMFVAL20_MASK            This_symb_has_been_depreciated
#define PMFVAL2_PMFVAL21                 This_symb_has_been_depreciated
#define PMFVAL2_PMFVAL21_MASK            This_symb_has_been_depreciated
#define PMFVAL2_PMFVAL22                 This_symb_has_been_depreciated
#define PMFVAL2_PMFVAL22_MASK            This_symb_has_been_depreciated
#define PMFVAL2_PMFVAL23                 This_symb_has_been_depreciated
#define PMFVAL2_PMFVAL23_MASK            This_symb_has_been_depreciated
#define PMFVAL2_PMFVAL24                 This_symb_has_been_depreciated
#define PMFVAL2_PMFVAL24_MASK            This_symb_has_been_depreciated
#define PMFVAL2_PMFVAL25                 This_symb_has_been_depreciated
#define PMFVAL2_PMFVAL25_MASK            This_symb_has_been_depreciated
#define PMFVAL2_PMFVAL26                 This_symb_has_been_depreciated
#define PMFVAL2_PMFVAL26_MASK            This_symb_has_been_depreciated
#define PMFVAL2_PMFVAL27                 This_symb_has_been_depreciated
#define PMFVAL2_PMFVAL27_MASK            This_symb_has_been_depreciated
#define PMFVAL2_PMFVAL28                 This_symb_has_been_depreciated
#define PMFVAL2_PMFVAL28_MASK            This_symb_has_been_depreciated
#define PMFVAL2_PMFVAL29                 This_symb_has_been_depreciated
#define PMFVAL2_PMFVAL29_MASK            This_symb_has_been_depreciated
#define PMFVAL2_PMFVAL210                This_symb_has_been_depreciated
#define PMFVAL2_PMFVAL210_MASK           This_symb_has_been_depreciated
#define PMFVAL2_PMFVAL211                This_symb_has_been_depreciated
#define PMFVAL2_PMFVAL211_MASK           This_symb_has_been_depreciated
#define PMFVAL2_PMFVAL212                This_symb_has_been_depreciated
#define PMFVAL2_PMFVAL212_MASK           This_symb_has_been_depreciated
#define PMFVAL2_PMFVAL213                This_symb_has_been_depreciated
#define PMFVAL2_PMFVAL213_MASK           This_symb_has_been_depreciated
#define PMFVAL2_PMFVAL214                This_symb_has_been_depreciated
#define PMFVAL2_PMFVAL214_MASK           This_symb_has_been_depreciated
#define PMFVAL2_PMFVAL2                  PMFVAL2_PMFVAL
#define PMFVAL2_PMFVAL2_BITNUM           PMFVAL2_PMFVAL_BITNUM
#define PMFVAL2_PMFVAL2_MASK             PMFVAL2_PMFVAL_MASK
#define PMFVAL3_PMFVAL30                 This_symb_has_been_depreciated
#define PMFVAL3_PMFVAL30_MASK            This_symb_has_been_depreciated
#define PMFVAL3_PMFVAL31                 This_symb_has_been_depreciated
#define PMFVAL3_PMFVAL31_MASK            This_symb_has_been_depreciated
#define PMFVAL3_PMFVAL32                 This_symb_has_been_depreciated
#define PMFVAL3_PMFVAL32_MASK            This_symb_has_been_depreciated
#define PMFVAL3_PMFVAL33                 This_symb_has_been_depreciated
#define PMFVAL3_PMFVAL33_MASK            This_symb_has_been_depreciated
#define PMFVAL3_PMFVAL34                 This_symb_has_been_depreciated
#define PMFVAL3_PMFVAL34_MASK            This_symb_has_been_depreciated
#define PMFVAL3_PMFVAL35                 This_symb_has_been_depreciated
#define PMFVAL3_PMFVAL35_MASK            This_symb_has_been_depreciated
#define PMFVAL3_PMFVAL36                 This_symb_has_been_depreciated
#define PMFVAL3_PMFVAL36_MASK            This_symb_has_been_depreciated
#define PMFVAL3_PMFVAL37                 This_symb_has_been_depreciated
#define PMFVAL3_PMFVAL37_MASK            This_symb_has_been_depreciated
#define PMFVAL3_PMFVAL38                 This_symb_has_been_depreciated
#define PMFVAL3_PMFVAL38_MASK            This_symb_has_been_depreciated
#define PMFVAL3_PMFVAL39                 This_symb_has_been_depreciated
#define PMFVAL3_PMFVAL39_MASK            This_symb_has_been_depreciated
#define PMFVAL3_PMFVAL310                This_symb_has_been_depreciated
#define PMFVAL3_PMFVAL310_MASK           This_symb_has_been_depreciated
#define PMFVAL3_PMFVAL311                This_symb_has_been_depreciated
#define PMFVAL3_PMFVAL311_MASK           This_symb_has_been_depreciated
#define PMFVAL3_PMFVAL312                This_symb_has_been_depreciated
#define PMFVAL3_PMFVAL312_MASK           This_symb_has_been_depreciated
#define PMFVAL3_PMFVAL313                This_symb_has_been_depreciated
#define PMFVAL3_PMFVAL313_MASK           This_symb_has_been_depreciated
#define PMFVAL3_PMFVAL314                This_symb_has_been_depreciated
#define PMFVAL3_PMFVAL314_MASK           This_symb_has_been_depreciated
#define PMFVAL3_PMFVAL3                  PMFVAL3_PMFVAL
#define PMFVAL3_PMFVAL3_BITNUM           PMFVAL3_PMFVAL_BITNUM
#define PMFVAL3_PMFVAL3_MASK             PMFVAL3_PMFVAL_MASK
#define PMFVAL4_PMFVAL40                 This_symb_has_been_depreciated
#define PMFVAL4_PMFVAL40_MASK            This_symb_has_been_depreciated
#define PMFVAL4_PMFVAL41                 This_symb_has_been_depreciated
#define PMFVAL4_PMFVAL41_MASK            This_symb_has_been_depreciated
#define PMFVAL4_PMFVAL42                 This_symb_has_been_depreciated
#define PMFVAL4_PMFVAL42_MASK            This_symb_has_been_depreciated
#define PMFVAL4_PMFVAL43                 This_symb_has_been_depreciated
#define PMFVAL4_PMFVAL43_MASK            This_symb_has_been_depreciated
#define PMFVAL4_PMFVAL44                 This_symb_has_been_depreciated
#define PMFVAL4_PMFVAL44_MASK            This_symb_has_been_depreciated
#define PMFVAL4_PMFVAL45                 This_symb_has_been_depreciated
#define PMFVAL4_PMFVAL45_MASK            This_symb_has_been_depreciated
#define PMFVAL4_PMFVAL46                 This_symb_has_been_depreciated
#define PMFVAL4_PMFVAL46_MASK            This_symb_has_been_depreciated
#define PMFVAL4_PMFVAL47                 This_symb_has_been_depreciated
#define PMFVAL4_PMFVAL47_MASK            This_symb_has_been_depreciated
#define PMFVAL4_PMFVAL48                 This_symb_has_been_depreciated
#define PMFVAL4_PMFVAL48_MASK            This_symb_has_been_depreciated
#define PMFVAL4_PMFVAL49                 This_symb_has_been_depreciated
#define PMFVAL4_PMFVAL49_MASK            This_symb_has_been_depreciated
#define PMFVAL4_PMFVAL410                This_symb_has_been_depreciated
#define PMFVAL4_PMFVAL410_MASK           This_symb_has_been_depreciated
#define PMFVAL4_PMFVAL411                This_symb_has_been_depreciated
#define PMFVAL4_PMFVAL411_MASK           This_symb_has_been_depreciated
#define PMFVAL4_PMFVAL412                This_symb_has_been_depreciated
#define PMFVAL4_PMFVAL412_MASK           This_symb_has_been_depreciated
#define PMFVAL4_PMFVAL413                This_symb_has_been_depreciated
#define PMFVAL4_PMFVAL413_MASK           This_symb_has_been_depreciated
#define PMFVAL4_PMFVAL414                This_symb_has_been_depreciated
#define PMFVAL4_PMFVAL414_MASK           This_symb_has_been_depreciated
#define PMFVAL4_PMFVAL4                  PMFVAL4_PMFVAL
#define PMFVAL4_PMFVAL4_BITNUM           PMFVAL4_PMFVAL_BITNUM
#define PMFVAL4_PMFVAL4_MASK             PMFVAL4_PMFVAL_MASK
#define PMFVAL5_PMFVAL50                 This_symb_has_been_depreciated
#define PMFVAL5_PMFVAL50_MASK            This_symb_has_been_depreciated
#define PMFVAL5_PMFVAL51                 This_symb_has_been_depreciated
#define PMFVAL5_PMFVAL51_MASK            This_symb_has_been_depreciated
#define PMFVAL5_PMFVAL52                 This_symb_has_been_depreciated
#define PMFVAL5_PMFVAL52_MASK            This_symb_has_been_depreciated
#define PMFVAL5_PMFVAL53                 This_symb_has_been_depreciated
#define PMFVAL5_PMFVAL53_MASK            This_symb_has_been_depreciated
#define PMFVAL5_PMFVAL54                 This_symb_has_been_depreciated
#define PMFVAL5_PMFVAL54_MASK            This_symb_has_been_depreciated
#define PMFVAL5_PMFVAL55                 This_symb_has_been_depreciated
#define PMFVAL5_PMFVAL55_MASK            This_symb_has_been_depreciated
#define PMFVAL5_PMFVAL56                 This_symb_has_been_depreciated
#define PMFVAL5_PMFVAL56_MASK            This_symb_has_been_depreciated
#define PMFVAL5_PMFVAL57                 This_symb_has_been_depreciated
#define PMFVAL5_PMFVAL57_MASK            This_symb_has_been_depreciated
#define PMFVAL5_PMFVAL58                 This_symb_has_been_depreciated
#define PMFVAL5_PMFVAL58_MASK            This_symb_has_been_depreciated
#define PMFVAL5_PMFVAL59                 This_symb_has_been_depreciated
#define PMFVAL5_PMFVAL59_MASK            This_symb_has_been_depreciated
#define PMFVAL5_PMFVAL510                This_symb_has_been_depreciated
#define PMFVAL5_PMFVAL510_MASK           This_symb_has_been_depreciated
#define PMFVAL5_PMFVAL511                This_symb_has_been_depreciated
#define PMFVAL5_PMFVAL511_MASK           This_symb_has_been_depreciated
#define PMFVAL5_PMFVAL512                This_symb_has_been_depreciated
#define PMFVAL5_PMFVAL512_MASK           This_symb_has_been_depreciated
#define PMFVAL5_PMFVAL513                This_symb_has_been_depreciated
#define PMFVAL5_PMFVAL513_MASK           This_symb_has_been_depreciated
#define PMFVAL5_PMFVAL514                This_symb_has_been_depreciated
#define PMFVAL5_PMFVAL514_MASK           This_symb_has_been_depreciated
#define PMFVAL5_PMFVAL5                  PMFVAL5_PMFVAL
#define PMFVAL5_PMFVAL5_BITNUM           PMFVAL5_PMFVAL_BITNUM
#define PMFVAL5_PMFVAL5_MASK             PMFVAL5_PMFVAL_MASK

/*
 * Follows changes from the database 2.87.521 version */
#define VREGCTRL0                        VREGCTRL
#define VREGCTRL0_LVIF                   VREGCTRL_LVIF
#define VREGCTRL0_LVIF_MASK              VREGCTRL_LVIF_MASK
#define VREGCTRL0_LVIE                   VREGCTRL_LVIE
#define VREGCTRL0_LVIE_MASK              VREGCTRL_LVIE_MASK
#define VREGCTRL0_LVDS                   VREGCTRL_LVDS
#define VREGCTRL0_LVDS_MASK              VREGCTRL_LVDS_MASK


/* **** 7.4.2009 9:47:33 */

#define PMFQSMP_QSMP                     This_symb_has_been_depreciated


/* **** 6.8.2009 10:22:19 */

#define PMFCNTA_PMFCNTA0                 This_symb_has_been_depreciated
#define PMFCNTA_PMFCNTA1                 This_symb_has_been_depreciated
#define PMFCNTA_PMFCNTA2                 This_symb_has_been_depreciated
#define PMFCNTA_PMFCNTA3                 This_symb_has_been_depreciated
#define PMFCNTA_PMFCNTA4                 This_symb_has_been_depreciated
#define PMFCNTA_PMFCNTA5                 This_symb_has_been_depreciated
#define PMFCNTA_PMFCNTA6                 This_symb_has_been_depreciated
#define PMFCNTA_PMFCNTA7                 This_symb_has_been_depreciated
#define PMFCNTA_PMFCNTA8                 This_symb_has_been_depreciated
#define PMFCNTA_PMFCNTA9                 This_symb_has_been_depreciated
#define PMFCNTA_PMFCNTA10                This_symb_has_been_depreciated
#define PMFCNTA_PMFCNTA11                This_symb_has_been_depreciated
#define PMFCNTA_PMFCNTA12                This_symb_has_been_depreciated
#define PMFCNTA_PMFCNTA13                This_symb_has_been_depreciated
#define PMFCNTA_PMFCNTA14                This_symb_has_been_depreciated
#define PMFCNTA_PMFCNTA0_MASK            This_symb_has_been_depreciated
#define PMFCNTA_PMFCNTA1_MASK            This_symb_has_been_depreciated
#define PMFCNTA_PMFCNTA2_MASK            This_symb_has_been_depreciated
#define PMFCNTA_PMFCNTA3_MASK            This_symb_has_been_depreciated
#define PMFCNTA_PMFCNTA4_MASK            This_symb_has_been_depreciated
#define PMFCNTA_PMFCNTA5_MASK            This_symb_has_been_depreciated
#define PMFCNTA_PMFCNTA6_MASK            This_symb_has_been_depreciated
#define PMFCNTA_PMFCNTA7_MASK            This_symb_has_been_depreciated
#define PMFCNTA_PMFCNTA8_MASK            This_symb_has_been_depreciated
#define PMFCNTA_PMFCNTA9_MASK            This_symb_has_been_depreciated
#define PMFCNTA_PMFCNTA10_MASK           This_symb_has_been_depreciated
#define PMFCNTA_PMFCNTA11_MASK           This_symb_has_been_depreciated
#define PMFCNTA_PMFCNTA12_MASK           This_symb_has_been_depreciated
#define PMFCNTA_PMFCNTA13_MASK           This_symb_has_been_depreciated
#define PMFCNTA_PMFCNTA14_MASK           This_symb_has_been_depreciated
#define PMFMODA_PMFMODA0                 This_symb_has_been_depreciated
#define PMFMODA_PMFMODA1                 This_symb_has_been_depreciated
#define PMFMODA_PMFMODA2                 This_symb_has_been_depreciated
#define PMFMODA_PMFMODA3                 This_symb_has_been_depreciated
#define PMFMODA_PMFMODA4                 This_symb_has_been_depreciated
#define PMFMODA_PMFMODA5                 This_symb_has_been_depreciated
#define PMFMODA_PMFMODA6                 This_symb_has_been_depreciated
#define PMFMODA_PMFMODA7                 This_symb_has_been_depreciated
#define PMFMODA_PMFMODA8                 This_symb_has_been_depreciated
#define PMFMODA_PMFMODA9                 This_symb_has_been_depreciated
#define PMFMODA_PMFMODA10                This_symb_has_been_depreciated
#define PMFMODA_PMFMODA11                This_symb_has_been_depreciated
#define PMFMODA_PMFMODA12                This_symb_has_been_depreciated
#define PMFMODA_PMFMODA13                This_symb_has_been_depreciated
#define PMFMODA_PMFMODA14                This_symb_has_been_depreciated
#define PMFMODA_PMFMODA0_MASK            This_symb_has_been_depreciated
#define PMFMODA_PMFMODA1_MASK            This_symb_has_been_depreciated
#define PMFMODA_PMFMODA2_MASK            This_symb_has_been_depreciated
#define PMFMODA_PMFMODA3_MASK            This_symb_has_been_depreciated
#define PMFMODA_PMFMODA4_MASK            This_symb_has_been_depreciated
#define PMFMODA_PMFMODA5_MASK            This_symb_has_been_depreciated
#define PMFMODA_PMFMODA6_MASK            This_symb_has_been_depreciated
#define PMFMODA_PMFMODA7_MASK            This_symb_has_been_depreciated
#define PMFMODA_PMFMODA8_MASK            This_symb_has_been_depreciated
#define PMFMODA_PMFMODA9_MASK            This_symb_has_been_depreciated
#define PMFMODA_PMFMODA10_MASK           This_symb_has_been_depreciated
#define PMFMODA_PMFMODA11_MASK           This_symb_has_been_depreciated
#define PMFMODA_PMFMODA12_MASK           This_symb_has_been_depreciated
#define PMFMODA_PMFMODA13_MASK           This_symb_has_been_depreciated
#define PMFMODA_PMFMODA14_MASK           This_symb_has_been_depreciated
#define PMFDTMA_PMFDTMA0                 This_symb_has_been_depreciated
#define PMFDTMA_PMFDTMA1                 This_symb_has_been_depreciated
#define PMFDTMA_PMFDTMA2                 This_symb_has_been_depreciated
#define PMFDTMA_PMFDTMA3                 This_symb_has_been_depreciated
#define PMFDTMA_PMFDTMA4                 This_symb_has_been_depreciated
#define PMFDTMA_PMFDTMA5                 This_symb_has_been_depreciated
#define PMFDTMA_PMFDTMA6                 This_symb_has_been_depreciated
#define PMFDTMA_PMFDTMA7                 This_symb_has_been_depreciated
#define PMFDTMA_PMFDTMA8                 This_symb_has_been_depreciated
#define PMFDTMA_PMFDTMA9                 This_symb_has_been_depreciated
#define PMFDTMA_PMFDTMA10                This_symb_has_been_depreciated
#define PMFDTMA_PMFDTMA11                This_symb_has_been_depreciated
#define PMFDTMA_PMFDTMA0_MASK            This_symb_has_been_depreciated
#define PMFDTMA_PMFDTMA1_MASK            This_symb_has_been_depreciated
#define PMFDTMA_PMFDTMA2_MASK            This_symb_has_been_depreciated
#define PMFDTMA_PMFDTMA3_MASK            This_symb_has_been_depreciated
#define PMFDTMA_PMFDTMA4_MASK            This_symb_has_been_depreciated
#define PMFDTMA_PMFDTMA5_MASK            This_symb_has_been_depreciated
#define PMFDTMA_PMFDTMA6_MASK            This_symb_has_been_depreciated
#define PMFDTMA_PMFDTMA7_MASK            This_symb_has_been_depreciated
#define PMFDTMA_PMFDTMA8_MASK            This_symb_has_been_depreciated
#define PMFDTMA_PMFDTMA9_MASK            This_symb_has_been_depreciated
#define PMFDTMA_PMFDTMA10_MASK           This_symb_has_been_depreciated
#define PMFDTMA_PMFDTMA11_MASK           This_symb_has_been_depreciated
#define PMFCNTB_PMFCNTB0                 This_symb_has_been_depreciated
#define PMFCNTB_PMFCNTB1                 This_symb_has_been_depreciated
#define PMFCNTB_PMFCNTB2                 This_symb_has_been_depreciated
#define PMFCNTB_PMFCNTB3                 This_symb_has_been_depreciated
#define PMFCNTB_PMFCNTB4                 This_symb_has_been_depreciated
#define PMFCNTB_PMFCNTB5                 This_symb_has_been_depreciated
#define PMFCNTB_PMFCNTB6                 This_symb_has_been_depreciated
#define PMFCNTB_PMFCNTB7                 This_symb_has_been_depreciated
#define PMFCNTB_PMFCNTB8                 This_symb_has_been_depreciated
#define PMFCNTB_PMFCNTB9                 This_symb_has_been_depreciated
#define PMFCNTB_PMFCNTB10                This_symb_has_been_depreciated
#define PMFCNTB_PMFCNTB11                This_symb_has_been_depreciated
#define PMFCNTB_PMFCNTB12                This_symb_has_been_depreciated
#define PMFCNTB_PMFCNTB13                This_symb_has_been_depreciated
#define PMFCNTB_PMFCNTB14                This_symb_has_been_depreciated
#define PMFCNTB_PMFCNTB0_MASK            This_symb_has_been_depreciated
#define PMFCNTB_PMFCNTB1_MASK            This_symb_has_been_depreciated
#define PMFCNTB_PMFCNTB2_MASK            This_symb_has_been_depreciated
#define PMFCNTB_PMFCNTB3_MASK            This_symb_has_been_depreciated
#define PMFCNTB_PMFCNTB4_MASK            This_symb_has_been_depreciated
#define PMFCNTB_PMFCNTB5_MASK            This_symb_has_been_depreciated
#define PMFCNTB_PMFCNTB6_MASK            This_symb_has_been_depreciated
#define PMFCNTB_PMFCNTB7_MASK            This_symb_has_been_depreciated
#define PMFCNTB_PMFCNTB8_MASK            This_symb_has_been_depreciated
#define PMFCNTB_PMFCNTB9_MASK            This_symb_has_been_depreciated
#define PMFCNTB_PMFCNTB10_MASK           This_symb_has_been_depreciated
#define PMFCNTB_PMFCNTB11_MASK           This_symb_has_been_depreciated
#define PMFCNTB_PMFCNTB12_MASK           This_symb_has_been_depreciated
#define PMFCNTB_PMFCNTB13_MASK           This_symb_has_been_depreciated
#define PMFCNTB_PMFCNTB14_MASK           This_symb_has_been_depreciated
#define PMFMODB_PMFMODB0                 This_symb_has_been_depreciated
#define PMFMODB_PMFMODB1                 This_symb_has_been_depreciated
#define PMFMODB_PMFMODB2                 This_symb_has_been_depreciated
#define PMFMODB_PMFMODB3                 This_symb_has_been_depreciated
#define PMFMODB_PMFMODB4                 This_symb_has_been_depreciated
#define PMFMODB_PMFMODB5                 This_symb_has_been_depreciated
#define PMFMODB_PMFMODB6                 This_symb_has_been_depreciated
#define PMFMODB_PMFMODB7                 This_symb_has_been_depreciated
#define PMFMODB_PMFMODB8                 This_symb_has_been_depreciated
#define PMFMODB_PMFMODB9                 This_symb_has_been_depreciated
#define PMFMODB_PMFMODB10                This_symb_has_been_depreciated
#define PMFMODB_PMFMODB11                This_symb_has_been_depreciated
#define PMFMODB_PMFMODB12                This_symb_has_been_depreciated
#define PMFMODB_PMFMODB13                This_symb_has_been_depreciated
#define PMFMODB_PMFMODB14                This_symb_has_been_depreciated
#define PMFMODB_PMFMODB0_MASK            This_symb_has_been_depreciated
#define PMFMODB_PMFMODB1_MASK            This_symb_has_been_depreciated
#define PMFMODB_PMFMODB2_MASK            This_symb_has_been_depreciated
#define PMFMODB_PMFMODB3_MASK            This_symb_has_been_depreciated
#define PMFMODB_PMFMODB4_MASK            This_symb_has_been_depreciated
#define PMFMODB_PMFMODB5_MASK            This_symb_has_been_depreciated
#define PMFMODB_PMFMODB6_MASK            This_symb_has_been_depreciated
#define PMFMODB_PMFMODB7_MASK            This_symb_has_been_depreciated
#define PMFMODB_PMFMODB8_MASK            This_symb_has_been_depreciated
#define PMFMODB_PMFMODB9_MASK            This_symb_has_been_depreciated
#define PMFMODB_PMFMODB10_MASK           This_symb_has_been_depreciated
#define PMFMODB_PMFMODB11_MASK           This_symb_has_been_depreciated
#define PMFMODB_PMFMODB12_MASK           This_symb_has_been_depreciated
#define PMFMODB_PMFMODB13_MASK           This_symb_has_been_depreciated
#define PMFMODB_PMFMODB14_MASK           This_symb_has_been_depreciated
#define PMFDTMB_PMFDTMB0                 This_symb_has_been_depreciated
#define PMFDTMB_PMFDTMB1                 This_symb_has_been_depreciated
#define PMFDTMB_PMFDTMB2                 This_symb_has_been_depreciated
#define PMFDTMB_PMFDTMB3                 This_symb_has_been_depreciated
#define PMFDTMB_PMFDTMB4                 This_symb_has_been_depreciated
#define PMFDTMB_PMFDTMB5                 This_symb_has_been_depreciated
#define PMFDTMB_PMFDTMB6                 This_symb_has_been_depreciated
#define PMFDTMB_PMFDTMB7                 This_symb_has_been_depreciated
#define PMFDTMB_PMFDTMB8                 This_symb_has_been_depreciated
#define PMFDTMB_PMFDTMB9                 This_symb_has_been_depreciated
#define PMFDTMB_PMFDTMB10                This_symb_has_been_depreciated
#define PMFDTMB_PMFDTMB11                This_symb_has_been_depreciated
#define PMFDTMB_PMFDTMB0_MASK            This_symb_has_been_depreciated
#define PMFDTMB_PMFDTMB1_MASK            This_symb_has_been_depreciated
#define PMFDTMB_PMFDTMB2_MASK            This_symb_has_been_depreciated
#define PMFDTMB_PMFDTMB3_MASK            This_symb_has_been_depreciated
#define PMFDTMB_PMFDTMB4_MASK            This_symb_has_been_depreciated
#define PMFDTMB_PMFDTMB5_MASK            This_symb_has_been_depreciated
#define PMFDTMB_PMFDTMB6_MASK            This_symb_has_been_depreciated
#define PMFDTMB_PMFDTMB7_MASK            This_symb_has_been_depreciated
#define PMFDTMB_PMFDTMB8_MASK            This_symb_has_been_depreciated
#define PMFDTMB_PMFDTMB9_MASK            This_symb_has_been_depreciated
#define PMFDTMB_PMFDTMB10_MASK           This_symb_has_been_depreciated
#define PMFDTMB_PMFDTMB11_MASK           This_symb_has_been_depreciated
#define PMFCNTC_PMFCNTC0                 This_symb_has_been_depreciated
#define PMFCNTC_PMFCNTC1                 This_symb_has_been_depreciated
#define PMFCNTC_PMFCNTC2                 This_symb_has_been_depreciated
#define PMFCNTC_PMFCNTC3                 This_symb_has_been_depreciated
#define PMFCNTC_PMFCNTC4                 This_symb_has_been_depreciated
#define PMFCNTC_PMFCNTC5                 This_symb_has_been_depreciated
#define PMFCNTC_PMFCNTC6                 This_symb_has_been_depreciated
#define PMFCNTC_PMFCNTC7                 This_symb_has_been_depreciated
#define PMFCNTC_PMFCNTC8                 This_symb_has_been_depreciated
#define PMFCNTC_PMFCNTC9                 This_symb_has_been_depreciated
#define PMFCNTC_PMFCNTC10                This_symb_has_been_depreciated
#define PMFCNTC_PMFCNTC11                This_symb_has_been_depreciated
#define PMFCNTC_PMFCNTC12                This_symb_has_been_depreciated
#define PMFCNTC_PMFCNTC13                This_symb_has_been_depreciated
#define PMFCNTC_PMFCNTC14                This_symb_has_been_depreciated
#define PMFCNTC_PMFCNTC0_MASK            This_symb_has_been_depreciated
#define PMFCNTC_PMFCNTC1_MASK            This_symb_has_been_depreciated
#define PMFCNTC_PMFCNTC2_MASK            This_symb_has_been_depreciated
#define PMFCNTC_PMFCNTC3_MASK            This_symb_has_been_depreciated
#define PMFCNTC_PMFCNTC4_MASK            This_symb_has_been_depreciated
#define PMFCNTC_PMFCNTC5_MASK            This_symb_has_been_depreciated
#define PMFCNTC_PMFCNTC6_MASK            This_symb_has_been_depreciated
#define PMFCNTC_PMFCNTC7_MASK            This_symb_has_been_depreciated
#define PMFCNTC_PMFCNTC8_MASK            This_symb_has_been_depreciated
#define PMFCNTC_PMFCNTC9_MASK            This_symb_has_been_depreciated
#define PMFCNTC_PMFCNTC10_MASK           This_symb_has_been_depreciated
#define PMFCNTC_PMFCNTC11_MASK           This_symb_has_been_depreciated
#define PMFCNTC_PMFCNTC12_MASK           This_symb_has_been_depreciated
#define PMFCNTC_PMFCNTC13_MASK           This_symb_has_been_depreciated
#define PMFCNTC_PMFCNTC14_MASK           This_symb_has_been_depreciated
#define PMFMODC_PMFMODC0                 This_symb_has_been_depreciated
#define PMFMODC_PMFMODC1                 This_symb_has_been_depreciated
#define PMFMODC_PMFMODC2                 This_symb_has_been_depreciated
#define PMFMODC_PMFMODC3                 This_symb_has_been_depreciated
#define PMFMODC_PMFMODC4                 This_symb_has_been_depreciated
#define PMFMODC_PMFMODC5                 This_symb_has_been_depreciated
#define PMFMODC_PMFMODC6                 This_symb_has_been_depreciated
#define PMFMODC_PMFMODC7                 This_symb_has_been_depreciated
#define PMFMODC_PMFMODC8                 This_symb_has_been_depreciated
#define PMFMODC_PMFMODC9                 This_symb_has_been_depreciated
#define PMFMODC_PMFMODC10                This_symb_has_been_depreciated
#define PMFMODC_PMFMODC11                This_symb_has_been_depreciated
#define PMFMODC_PMFMODC12                This_symb_has_been_depreciated
#define PMFMODC_PMFMODC13                This_symb_has_been_depreciated
#define PMFMODC_PMFMODC14                This_symb_has_been_depreciated
#define PMFMODC_PMFMODC0_MASK            This_symb_has_been_depreciated
#define PMFMODC_PMFMODC1_MASK            This_symb_has_been_depreciated
#define PMFMODC_PMFMODC2_MASK            This_symb_has_been_depreciated
#define PMFMODC_PMFMODC3_MASK            This_symb_has_been_depreciated
#define PMFMODC_PMFMODC4_MASK            This_symb_has_been_depreciated
#define PMFMODC_PMFMODC5_MASK            This_symb_has_been_depreciated
#define PMFMODC_PMFMODC6_MASK            This_symb_has_been_depreciated
#define PMFMODC_PMFMODC7_MASK            This_symb_has_been_depreciated
#define PMFMODC_PMFMODC8_MASK            This_symb_has_been_depreciated
#define PMFMODC_PMFMODC9_MASK            This_symb_has_been_depreciated
#define PMFMODC_PMFMODC10_MASK           This_symb_has_been_depreciated
#define PMFMODC_PMFMODC11_MASK           This_symb_has_been_depreciated
#define PMFMODC_PMFMODC12_MASK           This_symb_has_been_depreciated
#define PMFMODC_PMFMODC13_MASK           This_symb_has_been_depreciated
#define PMFMODC_PMFMODC14_MASK           This_symb_has_been_depreciated
#define PMFDTMC_PMFDTMC0                 This_symb_has_been_depreciated
#define PMFDTMC_PMFDTMC1                 This_symb_has_been_depreciated
#define PMFDTMC_PMFDTMC2                 This_symb_has_been_depreciated
#define PMFDTMC_PMFDTMC3                 This_symb_has_been_depreciated
#define PMFDTMC_PMFDTMC4                 This_symb_has_been_depreciated
#define PMFDTMC_PMFDTMC5                 This_symb_has_been_depreciated
#define PMFDTMC_PMFDTMC6                 This_symb_has_been_depreciated
#define PMFDTMC_PMFDTMC7                 This_symb_has_been_depreciated
#define PMFDTMC_PMFDTMC8                 This_symb_has_been_depreciated
#define PMFDTMC_PMFDTMC9                 This_symb_has_been_depreciated
#define PMFDTMC_PMFDTMC10                This_symb_has_been_depreciated
#define PMFDTMC_PMFDTMC11                This_symb_has_been_depreciated
#define PMFDTMC_PMFDTMC0_MASK            This_symb_has_been_depreciated
#define PMFDTMC_PMFDTMC1_MASK            This_symb_has_been_depreciated
#define PMFDTMC_PMFDTMC2_MASK            This_symb_has_been_depreciated
#define PMFDTMC_PMFDTMC3_MASK            This_symb_has_been_depreciated
#define PMFDTMC_PMFDTMC4_MASK            This_symb_has_been_depreciated
#define PMFDTMC_PMFDTMC5_MASK            This_symb_has_been_depreciated
#define PMFDTMC_PMFDTMC6_MASK            This_symb_has_been_depreciated
#define PMFDTMC_PMFDTMC7_MASK            This_symb_has_been_depreciated
#define PMFDTMC_PMFDTMC8_MASK            This_symb_has_been_depreciated
#define PMFDTMC_PMFDTMC9_MASK            This_symb_has_been_depreciated
#define PMFDTMC_PMFDTMC10_MASK           This_symb_has_been_depreciated
#define PMFDTMC_PMFDTMC11_MASK           This_symb_has_been_depreciated

#ifndef __V30COMPATIBLE__
#pragma OPTION DEL V30toV31Compatible
#endif
/*lint -restore  +esym(961,18.4) +esym(961,19.7) Enable MISRA rule (1.1,18.4,6.4,19.7) checking. */

#endif
