; Based on CPU DB MC9S12E128_112, version 2.87.542 (RegistersPrg V2.29)

; ###################################################################
;     Filename  : mc9s12e128.inc
;     Processor : MC9S12E128BCPV
;     FileFormat: V2.29
;     DataSheet : 9S12E-FamilyDGV1/D V01.01
;     Compiler  : CodeWarrior compiler
;     Date/Time : 6.8.2009, 10:24
;     Abstract  :
;         This header implements the mapping of I/O devices.
;
;     Copyright : 1997 - 2009 Freescale Semiconductor, Inc. All Rights Reserved.
;     
;     http      : www.freescale.com
;     mail      : support@freescale.com
;
;     CPU Registers Revisions:
;      - 12.07.2006, V2.87.502:
;              - Added bit 15 to PMFVALx registers. REASON: Bug-fix (#3494 in Issue Manager)
;      - 23.08.2006, V2.87.522:
;              - Renamed register VREGCTRL0 ==> VREGCTRL. REASON: Bug-fix (#<3647> in Issue Manager)
;      - 12.09.2006, V2.87.526:
;              - Removed bits PMFVALx_PMFVAL0x. REASON: Bug-fix (#3494 in Issue Manager)
;      - 6.08.2009, V2.87.542:
;              - Single bits of PMFCNTx, PMFMODx, PMFDTMx registers merged to PMFCNTx[0:14], PMFMODx[0:14], PMFDTMx[0:14] groups. REASON: Access to individual bits is useless (#7539 in Issue Manager)
;
;     File-Format-Revisions:
;      - 14.11.2005, V2.00 :
;               - Deprecated symbols added for backward compatibility (section at the end of this file)
;      - 15.11.2005, V2.01 :
;               - Fixed invalid instruction in macro __RESET_WATCHDOG for HCS12 family.
;      - 17.12.2005, V2.02 :
;               - Arrays (symbols xx_ARR) are defined as pointer to volatile, see issue #2778
;      - 16.01.2006, V2.03 :
;               - Fixed declaration of non volatile registers. Now it does not require (but allows) their initialization, see issue #2920.
;               - "volatile" modifier removed from declaration of non volatile registers (that contain modifier "const")
;      - 08.03.2006, V2.04 :
;               - Support for bit(s) names duplicated with any register name in .h header files
;      - 24.03.2006, V2.05 :
;               - Fixed macro __RESET_WATCHDOG for HCS12 family - address and correct write order.
;      - 26.04.2006, V2.06 :
;               - Changes have not affected this file (because they are related to another family)
;      - 27.04.2006, V2.07 :
;               - Fixed macro __RESET_WATCHDOG for HCS12, HCS12X ,HCS08 DZ and HCS08 EN derivatives (write 0x55,0xAA).
;      - 07.06.2006, V2.08 :
;               - Changes have not affected this file (because they are related to another family)
;      - 03.07.2006, V2.09 :
;               - Changes have not affected this file (because they are related to another family)
;      - 27.10.2006, V2.10 :
;               - __RESET_WATCHDOG improved formating and re-definition
;      - 23.11.2006, V2.11 :
;               - Changes have not affected this file (because they are related to another family)
;      - 22.01.2007, V2.12 :
;               - Fixed declaration of non volatile registers. Now it does not require (but allows) their initialization, see issue #4086.
;      - 01.03.2007, V2.13 :
;               - Flash commands constants values converted to HEX format
;      - 02.03.2007, V2.14 :
;               - Interrupt vector numbers added into .H, see VectorNumber_*
;      - 26.03.2007, V2.15 :
;               - Changes have not affected this file (because they are related to another family)
;      - 10.05.2007, V2.16 :
;               - Changes have not affected this file (because they are related to another family)
;      - 05.06.2007, V2.17 :
;               - Changes have not affected this file (because they are related to another family)
;      - 19.07.2007, V2.18 :
;               - Improved number of blanked lines inside register structures
;      - 06.08.2007, V2.19 :
;               - CPUDB revisions generated ahead of the file-format revisions.
;      - 11.09.2007, V2.20 :
;               - Added comment about initialization of unbonded pins.
;      - 02.01.2008, V2.21 :
;               - Changes have not affected this file (because they are related to another family)
;      - 13.02.2008, V2.22 :
;               - Changes have not affected this file (because they are related to another family)
;      - 20.02.2008, V2.23 :
;               - Termination of pragma V30toV31Compatible added, #5708
;      - 03.07.2008, V2.24 :
;               - Added support for bits with name starting with number (like "1HZ")
;      - 28.11.2008, V2.25 :
;               - StandBy RAM array declaration for ANSI-C added
;      - 1.12.2008, V2.26 :
;               - Duplication of bit (or bit-group) name with register name is not marked as a problem, is register is internal only and it is not displayed in I/O map.
;      - 17.3.2009, V2.27 :
;               - Merged bit-group is not generated, if the name matches with another bit name in the register
;      - 6.4.2009, V2.28 :
;               - Fixed generation of merged bits for bit-groups with a digit at the end, if group-name is defined in CPUDB
;      - 3.8.2009, V2.29 :
;               - If there is just one bits group matching register name, single bits are not generated
;
;     Not all general-purpose I/O pins are available on all packages or on all mask sets of a specific
;     derivative device. To avoid extra current drain from floating input pins, the users reset
;     initialization routine in the application program must either enable on-chip pull-up devices
;     or change the direction of unconnected pins to outputs so the pins do not float.
; ###################################################################

;*** Memory Map and Interrupt Vectors
;******************************************
RAMStart:           equ   $00000400
RAMEnd:             equ   $00001FFF
ROM_4000Start:      equ   $00004000
ROM_4000End:        equ   $00007FFF
ROM_C000Start:      equ   $0000C000
ROM_C000End:        equ   $0000FEFF
PAGE_38Start:       equ   $00388000
PAGE_38End:         equ   $0038BFFF
PAGE_39Start:       equ   $00398000
PAGE_39End:         equ   $0039BFFF
PAGE_3AStart:       equ   $003A8000
PAGE_3AEnd:         equ   $003ABFFF
PAGE_3BStart:       equ   $003B8000
PAGE_3BEnd:         equ   $003BBFFF
PAGE_3CStart:       equ   $003C8000
PAGE_3CEnd:         equ   $003CBFFF
PAGE_3DStart:       equ   $003D8000
PAGE_3DEnd:         equ   $003DBFFF
;
VReserved63:        equ   $0000FF80
VReserved62:        equ   $0000FF82
VReserved61:        equ   $0000FF84
VReserved60:        equ   $0000FF86
Vpwmesdn:           equ   $0000FF88
Vvreglvi:           equ   $0000FF8A
Vpmffault3:         equ   $0000FF8C
Vpmffault2:         equ   $0000FF8E
Vpmffault1:         equ   $0000FF90
Vpmffault0:         equ   $0000FF92
Vpmfgcr:            equ   $0000FF94
Vpmfgbr:            equ   $0000FF96
Vpmfgar:            equ   $0000FF98
Vtim2paie:          equ   $0000FF9A
Vtim2paovf:         equ   $0000FF9C
Vtim2ovf:           equ   $0000FF9E
Vtim2ch7:           equ   $0000FFA0
Vtim2ch6:           equ   $0000FFA2
Vtim2ch5:           equ   $0000FFA4
Vtim2ch4:           equ   $0000FFA6
VReserved43:        equ   $0000FFA8
Vtim1paie:          equ   $0000FFAA
Vtim1paovf:         equ   $0000FFAC
Vtim1ovf:           equ   $0000FFAE
Vtim1ch7:           equ   $0000FFB0
Vtim1ch6:           equ   $0000FFB2
Vtim1ch5:           equ   $0000FFB4
Vtim1ch4:           equ   $0000FFB6
Vflash:             equ   $0000FFB8
VReserved34:        equ   $0000FFBA
VReserved33:        equ   $0000FFBC
VReserved32:        equ   $0000FFBE
Viic:               equ   $0000FFC0
VReserved30:        equ   $0000FFC2
Vcrgscm:            equ   $0000FFC4
Vcrgplllck:         equ   $0000FFC6
VReserved27:        equ   $0000FFC8
VReserved26:        equ   $0000FFCA
VReserved25:        equ   $0000FFCC
Vportad:            equ   $0000FFCE
Vatd0:              equ   $0000FFD0
Vsci2:              equ   $0000FFD2
Vsci1:              equ   $0000FFD4
Vsci0:              equ   $0000FFD6
Vspi:               equ   $0000FFD8
Vtim0paie:          equ   $0000FFDA
Vtim0paovf:         equ   $0000FFDC
Vtim0ovf:           equ   $0000FFDE
Vtim0ch7:           equ   $0000FFE0
Vtim0ch6:           equ   $0000FFE2
Vtim0ch5:           equ   $0000FFE4
Vtim0ch4:           equ   $0000FFE6
VReserved11:        equ   $0000FFE8
VReserved10:        equ   $0000FFEA
VReserved9:         equ   $0000FFEC
VReserved8:         equ   $0000FFEE
Vrti:               equ   $0000FFF0
Virq:               equ   $0000FFF2
Vxirq:              equ   $0000FFF4
Vswi:               equ   $0000FFF6
Vtrap:              equ   $0000FFF8
Vcop:               equ   $0000FFFA
Vclkmon:            equ   $0000FFFC
Vreset:             equ   $0000FFFE
;


;*** PORTAB - Port AB Register; 0x00000000 ***
PORTAB:             equ    $00000000                                ;*** PORTAB - Port AB Register; 0x00000000 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PORTAB_BIT0:        equ    0                                         ; Port AB Bit 0
PORTAB_BIT1:        equ    1                                         ; Port AB Bit 1
PORTAB_BIT2:        equ    2                                         ; Port AB Bit 2
PORTAB_BIT3:        equ    3                                         ; Port AB Bit 3
PORTAB_BIT4:        equ    4                                         ; Port AB Bit 4
PORTAB_BIT5:        equ    5                                         ; Port AB Bit 5
PORTAB_BIT6:        equ    6                                         ; Port AB Bit 6
PORTAB_BIT7:        equ    7                                         ; Port AB Bit 7
PORTAB_BIT8:        equ    8                                         ; Port AB Bit 8
PORTAB_BIT9:        equ    9                                         ; Port AB Bit 9
PORTAB_BIT10:       equ    10                                        ; Port AB Bit 10
PORTAB_BIT11:       equ    11                                        ; Port AB Bit 11
PORTAB_BIT12:       equ    12                                        ; Port AB Bit 12
PORTAB_BIT13:       equ    13                                        ; Port AB Bit 13
PORTAB_BIT14:       equ    14                                        ; Port AB Bit 14
PORTAB_BIT15:       equ    15                                        ; Port AB Bit 15
; bit position masks
mPORTAB_BIT0:       equ    %00000001
mPORTAB_BIT1:       equ    %00000010
mPORTAB_BIT2:       equ    %00000100
mPORTAB_BIT3:       equ    %00001000
mPORTAB_BIT4:       equ    %00010000
mPORTAB_BIT5:       equ    %00100000
mPORTAB_BIT6:       equ    %01000000
mPORTAB_BIT7:       equ    %10000000
mPORTAB_BIT8:       equ    %100000000
mPORTAB_BIT9:       equ    %1000000000
mPORTAB_BIT10:      equ    %10000000000
mPORTAB_BIT11:      equ    %100000000000
mPORTAB_BIT12:      equ    %1000000000000
mPORTAB_BIT13:      equ    %10000000000000
mPORTAB_BIT14:      equ    %100000000000000
mPORTAB_BIT15:      equ    %1000000000000000


;*** PORTA - Port A Register; 0x00000000 ***
PORTA:              equ    $00000000                                ;*** PORTA - Port A Register; 0x00000000 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PORTA_BIT0:         equ    0                                         ; Port A Bit 0
PORTA_BIT1:         equ    1                                         ; Port A Bit 1
PORTA_BIT2:         equ    2                                         ; Port A Bit 2
PORTA_BIT3:         equ    3                                         ; Port A Bit 3
PORTA_BIT4:         equ    4                                         ; Port A Bit 4
PORTA_BIT5:         equ    5                                         ; Port A Bit 5
PORTA_BIT6:         equ    6                                         ; Port A Bit 6
PORTA_BIT7:         equ    7                                         ; Port A Bit 7
; bit position masks
mPORTA_BIT0:        equ    %00000001
mPORTA_BIT1:        equ    %00000010
mPORTA_BIT2:        equ    %00000100
mPORTA_BIT3:        equ    %00001000
mPORTA_BIT4:        equ    %00010000
mPORTA_BIT5:        equ    %00100000
mPORTA_BIT6:        equ    %01000000
mPORTA_BIT7:        equ    %10000000


;*** PORTB - Port B Register; 0x00000001 ***
PORTB:              equ    $00000001                                ;*** PORTB - Port B Register; 0x00000001 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PORTB_BIT0:         equ    0                                         ; Port B Bit 0
PORTB_BIT1:         equ    1                                         ; Port B Bit 1
PORTB_BIT2:         equ    2                                         ; Port B Bit 2
PORTB_BIT3:         equ    3                                         ; Port B Bit 3
PORTB_BIT4:         equ    4                                         ; Port B Bit 4
PORTB_BIT5:         equ    5                                         ; Port B Bit 5
PORTB_BIT6:         equ    6                                         ; Port B Bit 6
PORTB_BIT7:         equ    7                                         ; Port B Bit 7
; bit position masks
mPORTB_BIT0:        equ    %00000001
mPORTB_BIT1:        equ    %00000010
mPORTB_BIT2:        equ    %00000100
mPORTB_BIT3:        equ    %00001000
mPORTB_BIT4:        equ    %00010000
mPORTB_BIT5:        equ    %00100000
mPORTB_BIT6:        equ    %01000000
mPORTB_BIT7:        equ    %10000000


;*** DDRAB - Port AB Data Direction Register; 0x00000002 ***
DDRAB:              equ    $00000002                                ;*** DDRAB - Port AB Data Direction Register; 0x00000002 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRAB_BIT0:         equ    0                                         ; Data Direction Port B Bit 0
DDRAB_BIT1:         equ    1                                         ; Data Direction Port B Bit 1
DDRAB_BIT2:         equ    2                                         ; Data Direction Port B Bit 2
DDRAB_BIT3:         equ    3                                         ; Data Direction Port B Bit 3
DDRAB_BIT4:         equ    4                                         ; Data Direction Port B Bit 4
DDRAB_BIT5:         equ    5                                         ; Data Direction Port B Bit 5
DDRAB_BIT6:         equ    6                                         ; Data Direction Port B Bit 6
DDRAB_BIT7:         equ    7                                         ; Data Direction Port B Bit 7
DDRAB_BIT8:         equ    8                                         ; Data Direction Port A Bit 8
DDRAB_BIT9:         equ    9                                         ; Data Direction Port A Bit 9
DDRAB_BIT10:        equ    10                                        ; Data Direction Port A Bit 10
DDRAB_BIT11:        equ    11                                        ; Data Direction Port A Bit 11
DDRAB_BIT12:        equ    12                                        ; Data Direction Port A Bit 12
DDRAB_BIT13:        equ    13                                        ; Data Direction Port A Bit 13
DDRAB_BIT14:        equ    14                                        ; Data Direction Port A Bit 14
DDRAB_BIT15:        equ    15                                        ; Data Direction Port A Bit 15
; bit position masks
mDDRAB_BIT0:        equ    %00000001
mDDRAB_BIT1:        equ    %00000010
mDDRAB_BIT2:        equ    %00000100
mDDRAB_BIT3:        equ    %00001000
mDDRAB_BIT4:        equ    %00010000
mDDRAB_BIT5:        equ    %00100000
mDDRAB_BIT6:        equ    %01000000
mDDRAB_BIT7:        equ    %10000000
mDDRAB_BIT8:        equ    %100000000
mDDRAB_BIT9:        equ    %1000000000
mDDRAB_BIT10:       equ    %10000000000
mDDRAB_BIT11:       equ    %100000000000
mDDRAB_BIT12:       equ    %1000000000000
mDDRAB_BIT13:       equ    %10000000000000
mDDRAB_BIT14:       equ    %100000000000000
mDDRAB_BIT15:       equ    %1000000000000000


;*** DDRA - Port A Data Direction Register; 0x00000002 ***
DDRA:               equ    $00000002                                ;*** DDRA - Port A Data Direction Register; 0x00000002 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRA_BIT0:          equ    0                                         ; Data Direction Port A Bit 0
DDRA_BIT1:          equ    1                                         ; Data Direction Port A Bit 1
DDRA_BIT2:          equ    2                                         ; Data Direction Port A Bit 2
DDRA_BIT3:          equ    3                                         ; Data Direction Port A Bit 3
DDRA_BIT4:          equ    4                                         ; Data Direction Port A Bit 4
DDRA_BIT5:          equ    5                                         ; Data Direction Port A Bit 5
DDRA_BIT6:          equ    6                                         ; Data Direction Port A Bit 6
DDRA_BIT7:          equ    7                                         ; Data Direction Port A Bit 7
; bit position masks
mDDRA_BIT0:         equ    %00000001
mDDRA_BIT1:         equ    %00000010
mDDRA_BIT2:         equ    %00000100
mDDRA_BIT3:         equ    %00001000
mDDRA_BIT4:         equ    %00010000
mDDRA_BIT5:         equ    %00100000
mDDRA_BIT6:         equ    %01000000
mDDRA_BIT7:         equ    %10000000


;*** DDRB - Port B Data Direction Register; 0x00000003 ***
DDRB:               equ    $00000003                                ;*** DDRB - Port B Data Direction Register; 0x00000003 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRB_BIT0:          equ    0                                         ; Data Direction Port B Bit 0
DDRB_BIT1:          equ    1                                         ; Data Direction Port B Bit 1
DDRB_BIT2:          equ    2                                         ; Data Direction Port B Bit 2
DDRB_BIT3:          equ    3                                         ; Data Direction Port B Bit 3
DDRB_BIT4:          equ    4                                         ; Data Direction Port B Bit 4
DDRB_BIT5:          equ    5                                         ; Data Direction Port B Bit 5
DDRB_BIT6:          equ    6                                         ; Data Direction Port B Bit 6
DDRB_BIT7:          equ    7                                         ; Data Direction Port B Bit 7
; bit position masks
mDDRB_BIT0:         equ    %00000001
mDDRB_BIT1:         equ    %00000010
mDDRB_BIT2:         equ    %00000100
mDDRB_BIT3:         equ    %00001000
mDDRB_BIT4:         equ    %00010000
mDDRB_BIT5:         equ    %00100000
mDDRB_BIT6:         equ    %01000000
mDDRB_BIT7:         equ    %10000000


;*** PORTE - Port E Register; 0x00000008 ***
PORTE:              equ    $00000008                                ;*** PORTE - Port E Register; 0x00000008 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PORTE_BIT0:         equ    0                                         ; Port E Bit 0
PORTE_BIT1:         equ    1                                         ; Port E Bit 1
PORTE_BIT2:         equ    2                                         ; Port E Bit 2
PORTE_BIT3:         equ    3                                         ; Port E Bit 3
PORTE_BIT4:         equ    4                                         ; Port E Bit 4
PORTE_BIT5:         equ    5                                         ; Port E Bit 5
PORTE_BIT6:         equ    6                                         ; Port E Bit 6
PORTE_BIT7:         equ    7                                         ; Port E Bit 7
; bit position masks
mPORTE_BIT0:        equ    %00000001
mPORTE_BIT1:        equ    %00000010
mPORTE_BIT2:        equ    %00000100
mPORTE_BIT3:        equ    %00001000
mPORTE_BIT4:        equ    %00010000
mPORTE_BIT5:        equ    %00100000
mPORTE_BIT6:        equ    %01000000
mPORTE_BIT7:        equ    %10000000


;*** DDRE - Port E Data Direction Register; 0x00000009 ***
DDRE:               equ    $00000009                                ;*** DDRE - Port E Data Direction Register; 0x00000009 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRE_BIT2:          equ    2                                         ; Data Direction Port E Bit 2
DDRE_BIT3:          equ    3                                         ; Data Direction Port E Bit 3
DDRE_BIT4:          equ    4                                         ; Data Direction Port E Bit 4
DDRE_BIT5:          equ    5                                         ; Data Direction Port E Bit 5
DDRE_BIT6:          equ    6                                         ; Data Direction Port E Bit 6
DDRE_BIT7:          equ    7                                         ; Data Direction Port E Bit 7
; bit position masks
mDDRE_BIT2:         equ    %00000100
mDDRE_BIT3:         equ    %00001000
mDDRE_BIT4:         equ    %00010000
mDDRE_BIT5:         equ    %00100000
mDDRE_BIT6:         equ    %01000000
mDDRE_BIT7:         equ    %10000000


;*** PEAR - Port E Assignment Register; 0x0000000A ***
PEAR:               equ    $0000000A                                ;*** PEAR - Port E Assignment Register; 0x0000000A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PEAR_RDWE:          equ    2                                         ; Read / Write Enable
PEAR_LSTRE:         equ    3                                         ; Low Strobe (LSTRB) Enable
PEAR_NECLK:         equ    4                                         ; No External E Clock
PEAR_PIPOE:         equ    5                                         ; Pipe Status Signal Output Enable
PEAR_NOACCE:        equ    7                                         ; CPU No Access Output Enable
; bit position masks
mPEAR_RDWE:         equ    %00000100
mPEAR_LSTRE:        equ    %00001000
mPEAR_NECLK:        equ    %00010000
mPEAR_PIPOE:        equ    %00100000
mPEAR_NOACCE:       equ    %10000000


;*** MODE - Mode Register; 0x0000000B ***
MODE:               equ    $0000000B                                ;*** MODE - Mode Register; 0x0000000B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MODE_EME:           equ    0                                         ; Emulate Port E
MODE_EMK:           equ    1                                         ; Emulate Port K
MODE_IVIS:          equ    3                                         ; Internal Visibility
MODE_MODA:          equ    5                                         ; Mode Select Bit A
MODE_MODB:          equ    6                                         ; Mode Select Bit B
MODE_MODC:          equ    7                                         ; Mode Select Bit C
; bit position masks
mMODE_EME:          equ    %00000001
mMODE_EMK:          equ    %00000010
mMODE_IVIS:         equ    %00001000
mMODE_MODA:         equ    %00100000
mMODE_MODB:         equ    %01000000
mMODE_MODC:         equ    %10000000


;*** PUCR - Pull-Up Control Register; 0x0000000C ***
PUCR:               equ    $0000000C                                ;*** PUCR - Pull-Up Control Register; 0x0000000C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PUCR_PUPAE:         equ    0                                         ; Pull-Up Port A Enable
PUCR_PUPBE:         equ    1                                         ; Pull-Up Port B Enable
PUCR_PUPEE:         equ    4                                         ; Pull-Up Port E Enable
PUCR_PUPKE:         equ    7                                         ; Pull-Up Port K Enable
; bit position masks
mPUCR_PUPAE:        equ    %00000001
mPUCR_PUPBE:        equ    %00000010
mPUCR_PUPEE:        equ    %00010000
mPUCR_PUPKE:        equ    %10000000


;*** RDRIV - Reduced Drive of I/O Lines; 0x0000000D ***
RDRIV:              equ    $0000000D                                ;*** RDRIV - Reduced Drive of I/O Lines; 0x0000000D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RDRIV_RDPA:         equ    0                                         ; Reduced Drive of Port A
RDRIV_RDPB:         equ    1                                         ; Reduced Drive of Port B
RDRIV_RDPE:         equ    4                                         ; Reduced Drive of Port E
RDRIV_RDPK:         equ    7                                         ; Reduced Drive of Port K
; bit position masks
mRDRIV_RDPA:        equ    %00000001
mRDRIV_RDPB:        equ    %00000010
mRDRIV_RDPE:        equ    %00010000
mRDRIV_RDPK:        equ    %10000000


;*** EBICTL - External Bus Interface Control; 0x0000000E ***
EBICTL:             equ    $0000000E                                ;*** EBICTL - External Bus Interface Control; 0x0000000E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
EBICTL_ESTR:        equ    0                                         ; E Stretches
; bit position masks
mEBICTL_ESTR:       equ    %00000001


;*** INITRM - Initialization of Internal RAM Position Register; 0x00000010 ***
INITRM:             equ    $00000010                                ;*** INITRM - Initialization of Internal RAM Position Register; 0x00000010 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
INITRM_RAMHAL:      equ    0                                         ; Internal RAM map alignment
INITRM_RAM11:       equ    3                                         ; Internal RAM map position Bit 11
INITRM_RAM12:       equ    4                                         ; Internal RAM map position Bit 12
INITRM_RAM13:       equ    5                                         ; Internal RAM map position Bit 13
INITRM_RAM14:       equ    6                                         ; Internal RAM map position Bit 14
INITRM_RAM15:       equ    7                                         ; Internal RAM map position Bit 15
; bit position masks
mINITRM_RAMHAL:     equ    %00000001
mINITRM_RAM11:      equ    %00001000
mINITRM_RAM12:      equ    %00010000
mINITRM_RAM13:      equ    %00100000
mINITRM_RAM14:      equ    %01000000
mINITRM_RAM15:      equ    %10000000


;*** INITRG - Initialization of Internal Registers Position Register; 0x00000011 ***
INITRG:             equ    $00000011                                ;*** INITRG - Initialization of Internal Registers Position Register; 0x00000011 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
INITRG_REG11:       equ    3                                         ; Internal Registers Map Position Bit 11
INITRG_REG12:       equ    4                                         ; Internal Registers Map Position Bit 12
INITRG_REG13:       equ    5                                         ; Internal Registers Map Position Bit 13
INITRG_REG14:       equ    6                                         ; Internal Registers Map Position Bit 14
; bit position masks
mINITRG_REG11:      equ    %00001000
mINITRG_REG12:      equ    %00010000
mINITRG_REG13:      equ    %00100000
mINITRG_REG14:      equ    %01000000


;*** MISC - Miscellaneous System Control Register; 0x00000013 ***
MISC:               equ    $00000013                                ;*** MISC - Miscellaneous System Control Register; 0x00000013 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MISC_ROMON:         equ    0                                         ; Enable Flash EEPROM
MISC_ROMHM:         equ    1                                         ; Flash EEPROM only in second half of memory map
MISC_EXSTR0:        equ    2                                         ; External Access Stretch Bit 0
MISC_EXSTR1:        equ    3                                         ; External Access Stretch Bit 1
; bit position masks
mMISC_ROMON:        equ    %00000001
mMISC_ROMHM:        equ    %00000010
mMISC_EXSTR0:       equ    %00000100
mMISC_EXSTR1:       equ    %00001000


;*** ITCR - Interrupt Test Control Register; 0x00000015 ***
ITCR:               equ    $00000015                                ;*** ITCR - Interrupt Test Control Register; 0x00000015 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ITCR_ADR0:          equ    0                                         ; Test register select Bit 0
ITCR_ADR1:          equ    1                                         ; Test register select Bit 1
ITCR_ADR2:          equ    2                                         ; Test register select Bit 2
ITCR_ADR3:          equ    3                                         ; Test register select Bit 3
ITCR_WRTINT:        equ    4                                         ; Write to the Interrupt Test Registers
; bit position masks
mITCR_ADR0:         equ    %00000001
mITCR_ADR1:         equ    %00000010
mITCR_ADR2:         equ    %00000100
mITCR_ADR3:         equ    %00001000
mITCR_WRTINT:       equ    %00010000


;*** ITEST - Interrupt Test Register; 0x00000016 ***
ITEST:              equ    $00000016                                ;*** ITEST - Interrupt Test Register; 0x00000016 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ITEST_INT0:         equ    0                                         ; Interrupt Test Register Bit 0
ITEST_INT2:         equ    1                                         ; Interrupt Test Register Bit 1
ITEST_INT4:         equ    2                                         ; Interrupt Test Register Bit 2
ITEST_INT6:         equ    3                                         ; Interrupt Test Register Bit 3
ITEST_INT8:         equ    4                                         ; Interrupt Test Register Bit 4
ITEST_INTA:         equ    5                                         ; Interrupt Test Register Bit 5
ITEST_INTC:         equ    6                                         ; Interrupt Test Register Bit 6
ITEST_INTE:         equ    7                                         ; Interrupt Test Register Bit 7
; bit position masks
mITEST_INT0:        equ    %00000001
mITEST_INT2:        equ    %00000010
mITEST_INT4:        equ    %00000100
mITEST_INT6:        equ    %00001000
mITEST_INT8:        equ    %00010000
mITEST_INTA:        equ    %00100000
mITEST_INTC:        equ    %01000000
mITEST_INTE:        equ    %10000000


;*** VREGCTRL - VREG_3V3 - Control Register; 0x00000019 ***
VREGCTRL:           equ    $00000019                                ;*** VREGCTRL - VREG_3V3 - Control Register; 0x00000019 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
VREGCTRL_LVIF:      equ    0                                         ; Low Voltage Interrupt Flag
VREGCTRL_LVIE:      equ    1                                         ; Low Voltage Interrupt Enable Bit
VREGCTRL_LVDS:      equ    2                                         ; Low Voltage Detect Status Bit
; bit position masks
mVREGCTRL_LVIF:     equ    %00000001
mVREGCTRL_LVIE:     equ    %00000010
mVREGCTRL_LVDS:     equ    %00000100


;*** PARTID - Part ID Register; 0x0000001A ***
PARTID:             equ    $0000001A                                ;*** PARTID - Part ID Register; 0x0000001A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PARTID_ID0:         equ    0                                         ; Part ID Register Bit 0
PARTID_ID1:         equ    1                                         ; Part ID Register Bit 1
PARTID_ID2:         equ    2                                         ; Part ID Register Bit 2
PARTID_ID3:         equ    3                                         ; Part ID Register Bit 3
PARTID_ID4:         equ    4                                         ; Part ID Register Bit 4
PARTID_ID5:         equ    5                                         ; Part ID Register Bit 5
PARTID_ID6:         equ    6                                         ; Part ID Register Bit 6
PARTID_ID7:         equ    7                                         ; Part ID Register Bit 7
PARTID_ID8:         equ    8                                         ; Part ID Register Bit 8
PARTID_ID9:         equ    9                                         ; Part ID Register Bit 9
PARTID_ID10:        equ    10                                        ; Part ID Register Bit 10
PARTID_ID11:        equ    11                                        ; Part ID Register Bit 11
PARTID_ID12:        equ    12                                        ; Part ID Register Bit 12
PARTID_ID13:        equ    13                                        ; Part ID Register Bit 13
PARTID_ID14:        equ    14                                        ; Part ID Register Bit 14
PARTID_ID15:        equ    15                                        ; Part ID Register Bit 15
; bit position masks
mPARTID_ID0:        equ    %00000001
mPARTID_ID1:        equ    %00000010
mPARTID_ID2:        equ    %00000100
mPARTID_ID3:        equ    %00001000
mPARTID_ID4:        equ    %00010000
mPARTID_ID5:        equ    %00100000
mPARTID_ID6:        equ    %01000000
mPARTID_ID7:        equ    %10000000
mPARTID_ID8:        equ    %100000000
mPARTID_ID9:        equ    %1000000000
mPARTID_ID10:       equ    %10000000000
mPARTID_ID11:       equ    %100000000000
mPARTID_ID12:       equ    %1000000000000
mPARTID_ID13:       equ    %10000000000000
mPARTID_ID14:       equ    %100000000000000
mPARTID_ID15:       equ    %1000000000000000


;*** PARTIDH - Part ID Register High; 0x0000001A ***
PARTIDH:            equ    $0000001A                                ;*** PARTIDH - Part ID Register High; 0x0000001A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PARTIDH_ID8:        equ    0                                         ; Part ID Register Bit 8
PARTIDH_ID9:        equ    1                                         ; Part ID Register Bit 9
PARTIDH_ID10:       equ    2                                         ; Part ID Register Bit 10
PARTIDH_ID11:       equ    3                                         ; Part ID Register Bit 11
PARTIDH_ID12:       equ    4                                         ; Part ID Register Bit 12
PARTIDH_ID13:       equ    5                                         ; Part ID Register Bit 13
PARTIDH_ID14:       equ    6                                         ; Part ID Register Bit 14
PARTIDH_ID15:       equ    7                                         ; Part ID Register Bit 15
; bit position masks
mPARTIDH_ID8:       equ    %00000001
mPARTIDH_ID9:       equ    %00000010
mPARTIDH_ID10:      equ    %00000100
mPARTIDH_ID11:      equ    %00001000
mPARTIDH_ID12:      equ    %00010000
mPARTIDH_ID13:      equ    %00100000
mPARTIDH_ID14:      equ    %01000000
mPARTIDH_ID15:      equ    %10000000


;*** PARTIDL - Part ID Register Low; 0x0000001B ***
PARTIDL:            equ    $0000001B                                ;*** PARTIDL - Part ID Register Low; 0x0000001B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PARTIDL_ID0:        equ    0                                         ; Part ID Register Bit 0
PARTIDL_ID1:        equ    1                                         ; Part ID Register Bit 1
PARTIDL_ID2:        equ    2                                         ; Part ID Register Bit 2
PARTIDL_ID3:        equ    3                                         ; Part ID Register Bit 3
PARTIDL_ID4:        equ    4                                         ; Part ID Register Bit 4
PARTIDL_ID5:        equ    5                                         ; Part ID Register Bit 5
PARTIDL_ID6:        equ    6                                         ; Part ID Register Bit 6
PARTIDL_ID7:        equ    7                                         ; Part ID Register Bit 7
; bit position masks
mPARTIDL_ID0:       equ    %00000001
mPARTIDL_ID1:       equ    %00000010
mPARTIDL_ID2:       equ    %00000100
mPARTIDL_ID3:       equ    %00001000
mPARTIDL_ID4:       equ    %00010000
mPARTIDL_ID5:       equ    %00100000
mPARTIDL_ID6:       equ    %01000000
mPARTIDL_ID7:       equ    %10000000


;*** MEMSIZ0 - Memory Size Register Zero; 0x0000001C ***
MEMSIZ0:            equ    $0000001C                                ;*** MEMSIZ0 - Memory Size Register Zero; 0x0000001C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MEMSIZ0_ram_sw0:    equ    0                                         ; Allocated System RAM Memory Space Bit 0
MEMSIZ0_ram_sw1:    equ    1                                         ; Allocated System RAM Memory Space Bit 1
MEMSIZ0_ram_sw2:    equ    2                                         ; Allocated System RAM Memory Space Bit 2
MEMSIZ0_eep_sw0:    equ    4                                         ; Allocated EEPROM Memory Space Bit 0
MEMSIZ0_eep_sw1:    equ    5                                         ; Allocated EEPROM Memory Space Bit 1
MEMSIZ0_reg_sw0:    equ    7                                         ; Allocated System Register Space
; bit position masks
mMEMSIZ0_ram_sw0:   equ    %00000001
mMEMSIZ0_ram_sw1:   equ    %00000010
mMEMSIZ0_ram_sw2:   equ    %00000100
mMEMSIZ0_eep_sw0:   equ    %00010000
mMEMSIZ0_eep_sw1:   equ    %00100000
mMEMSIZ0_reg_sw0:   equ    %10000000


;*** MEMSIZ1 - Memory Size Register One; 0x0000001D ***
MEMSIZ1:            equ    $0000001D                                ;*** MEMSIZ1 - Memory Size Register One; 0x0000001D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MEMSIZ1_pag_sw0:    equ    0                                         ; Allocated Off-Chip Memory Options Bit 0
MEMSIZ1_pag_sw1:    equ    1                                         ; Allocated Off-Chip Memory Options Bit 1
MEMSIZ1_rom_sw0:    equ    6                                         ; Allocated Flash EEPROM/ROM Physical Memory Space Bit 0
MEMSIZ1_rom_sw1:    equ    7                                         ; Allocated Flash EEPROM/ROM Physical Memory Space Bit 1
; bit position masks
mMEMSIZ1_pag_sw0:   equ    %00000001
mMEMSIZ1_pag_sw1:   equ    %00000010
mMEMSIZ1_rom_sw0:   equ    %01000000
mMEMSIZ1_rom_sw1:   equ    %10000000


;*** INTCR - Interrupt Control Register; 0x0000001E ***
INTCR:              equ    $0000001E                                ;*** INTCR - Interrupt Control Register; 0x0000001E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
INTCR_IRQEN:        equ    6                                         ; External IRQ Enable
INTCR_IRQE:         equ    7                                         ; IRQ Select Edge Sensitive Only
; bit position masks
mINTCR_IRQEN:       equ    %01000000
mINTCR_IRQE:        equ    %10000000


;*** HPRIO - Highest Priority I Interrupt; 0x0000001F ***
HPRIO:              equ    $0000001F                                ;*** HPRIO - Highest Priority I Interrupt; 0x0000001F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
HPRIO_PSEL1:        equ    1                                         ; Highest Priority I Interrupt Bit 1
HPRIO_PSEL2:        equ    2                                         ; Highest Priority I Interrupt Bit 2
HPRIO_PSEL3:        equ    3                                         ; Highest Priority I Interrupt Bit 3
HPRIO_PSEL4:        equ    4                                         ; Highest Priority I Interrupt Bit 4
HPRIO_PSEL5:        equ    5                                         ; Highest Priority I Interrupt Bit 5
HPRIO_PSEL6:        equ    6                                         ; Highest Priority I Interrupt Bit 6
HPRIO_PSEL7:        equ    7                                         ; Highest Priority I Interrupt Bit 7
; bit position masks
mHPRIO_PSEL1:       equ    %00000010
mHPRIO_PSEL2:       equ    %00000100
mHPRIO_PSEL3:       equ    %00001000
mHPRIO_PSEL4:       equ    %00010000
mHPRIO_PSEL5:       equ    %00100000
mHPRIO_PSEL6:       equ    %01000000
mHPRIO_PSEL7:       equ    %10000000


;*** DBGC1 - Debug Control Register 1; 0x00000020 ***
DBGC1:              equ    $00000020                                ;*** DBGC1 - Debug Control Register 1; 0x00000020 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGC1_CAPMOD0:      equ    0                                         ; Capture Mode Field, bit 0
DBGC1_CAPMOD1:      equ    1                                         ; Capture Mode Field, bit 1
DBGC1_DBGBRK:       equ    3                                         ; DBG Breakpoint Enable Bit
DBGC1_BEGIN:        equ    4                                         ; Begin/End Trigger Bit
DBGC1_TRGSEL:       equ    5                                         ; Trigger Selection Bit
DBGC1_ARM:          equ    6                                         ; Arm Bit
DBGC1_DBGEN:        equ    7                                         ; DBG Mode Enable Bit
; bit position masks
mDBGC1_CAPMOD0:     equ    %00000001
mDBGC1_CAPMOD1:     equ    %00000010
mDBGC1_DBGBRK:      equ    %00001000
mDBGC1_BEGIN:       equ    %00010000
mDBGC1_TRGSEL:      equ    %00100000
mDBGC1_ARM:         equ    %01000000
mDBGC1_DBGEN:       equ    %10000000


;*** DBGSC - Debug Status and Control Register; 0x00000021 ***
DBGSC:              equ    $00000021                                ;*** DBGSC - Debug Status and Control Register; 0x00000021 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGSC_TRG0:         equ    0                                         ; Trigger Mode Bits, bit 0
DBGSC_TRG1:         equ    1                                         ; Trigger Mode Bits, bit 1
DBGSC_TRG2:         equ    2                                         ; Trigger Mode Bits, bit 2
DBGSC_TRG3:         equ    3                                         ; Trigger Mode Bits, bit 3
DBGSC_CF:           equ    5                                         ; Comparator C Match Flag
DBGSC_BF:           equ    6                                         ; Trigger B Match Flag
DBGSC_AF:           equ    7                                         ; Trigger A Match Flag
; bit position masks
mDBGSC_TRG0:        equ    %00000001
mDBGSC_TRG1:        equ    %00000010
mDBGSC_TRG2:        equ    %00000100
mDBGSC_TRG3:        equ    %00001000
mDBGSC_CF:          equ    %00100000
mDBGSC_BF:          equ    %01000000
mDBGSC_AF:          equ    %10000000


;*** DBGTB - Debug Trace Buffer Register; 0x00000022 ***
DBGTB:              equ    $00000022                                ;*** DBGTB - Debug Trace Buffer Register; 0x00000022 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGTB_BIT0:         equ    0                                         ; Trace Buffer Data Bit 0
DBGTB_BIT1:         equ    1                                         ; Trace Buffer Data Bit 1
DBGTB_BIT2:         equ    2                                         ; Trace Buffer Data Bit 2
DBGTB_BIT3:         equ    3                                         ; Trace Buffer Data Bit 3
DBGTB_BIT4:         equ    4                                         ; Trace Buffer Data Bit 4
DBGTB_BIT5:         equ    5                                         ; Trace Buffer Data Bit 5
DBGTB_BIT6:         equ    6                                         ; Trace Buffer Data Bit 6
DBGTB_BIT7:         equ    7                                         ; Trace Buffer Data Bit 7
DBGTB_BIT8:         equ    8                                         ; Trace Buffer Data Bit 8
DBGTB_BIT9:         equ    9                                         ; Trace Buffer Data Bit 9
DBGTB_BIT10:        equ    10                                        ; Trace Buffer Data Bit 10
DBGTB_BIT11:        equ    11                                        ; Trace Buffer Data Bit 11
DBGTB_BIT12:        equ    12                                        ; Trace Buffer Data Bit 12
DBGTB_BIT13:        equ    13                                        ; Trace Buffer Data Bit 13
DBGTB_BIT14:        equ    14                                        ; Trace Buffer Data Bit 14
DBGTB_BIT15:        equ    15                                        ; Trace Buffer Data Bit 15
; bit position masks
mDBGTB_BIT0:        equ    %00000001
mDBGTB_BIT1:        equ    %00000010
mDBGTB_BIT2:        equ    %00000100
mDBGTB_BIT3:        equ    %00001000
mDBGTB_BIT4:        equ    %00010000
mDBGTB_BIT5:        equ    %00100000
mDBGTB_BIT6:        equ    %01000000
mDBGTB_BIT7:        equ    %10000000
mDBGTB_BIT8:        equ    %100000000
mDBGTB_BIT9:        equ    %1000000000
mDBGTB_BIT10:       equ    %10000000000
mDBGTB_BIT11:       equ    %100000000000
mDBGTB_BIT12:       equ    %1000000000000
mDBGTB_BIT13:       equ    %10000000000000
mDBGTB_BIT14:       equ    %100000000000000
mDBGTB_BIT15:       equ    %1000000000000000


;*** DBGTBH - Debug Trace Buffer Register High; 0x00000022 ***
DBGTBH:             equ    $00000022                                ;*** DBGTBH - Debug Trace Buffer Register High; 0x00000022 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGTBH_BIT8:        equ    0                                         ; Trace Buffer Data Bit 8
DBGTBH_BIT9:        equ    1                                         ; Trace Buffer Data Bit 9
DBGTBH_BIT10:       equ    2                                         ; Trace Buffer Data Bit 10
DBGTBH_BIT11:       equ    3                                         ; Trace Buffer Data Bit 11
DBGTBH_BIT12:       equ    4                                         ; Trace Buffer Data Bit 12
DBGTBH_BIT13:       equ    5                                         ; Trace Buffer Data Bit 13
DBGTBH_BIT14:       equ    6                                         ; Trace Buffer Data Bit 14
DBGTBH_BIT15:       equ    7                                         ; Trace Buffer Data Bit 15
; bit position masks
mDBGTBH_BIT8:       equ    %00000001
mDBGTBH_BIT9:       equ    %00000010
mDBGTBH_BIT10:      equ    %00000100
mDBGTBH_BIT11:      equ    %00001000
mDBGTBH_BIT12:      equ    %00010000
mDBGTBH_BIT13:      equ    %00100000
mDBGTBH_BIT14:      equ    %01000000
mDBGTBH_BIT15:      equ    %10000000


;*** DBGTBL - Debug Trace Buffer Register Low; 0x00000023 ***
DBGTBL:             equ    $00000023                                ;*** DBGTBL - Debug Trace Buffer Register Low; 0x00000023 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGTBL_BIT0:        equ    0                                         ; Trace Buffer Data Bit 0
DBGTBL_BIT1:        equ    1                                         ; Trace Buffer Data Bit 1
DBGTBL_BIT2:        equ    2                                         ; Trace Buffer Data Bit 2
DBGTBL_BIT3:        equ    3                                         ; Trace Buffer Data Bit 3
DBGTBL_BIT4:        equ    4                                         ; Trace Buffer Data Bit 4
DBGTBL_BIT5:        equ    5                                         ; Trace Buffer Data Bit 5
DBGTBL_BIT6:        equ    6                                         ; Trace Buffer Data Bit 6
DBGTBL_BIT7:        equ    7                                         ; Trace Buffer Data Bit 7
; bit position masks
mDBGTBL_BIT0:       equ    %00000001
mDBGTBL_BIT1:       equ    %00000010
mDBGTBL_BIT2:       equ    %00000100
mDBGTBL_BIT3:       equ    %00001000
mDBGTBL_BIT4:       equ    %00010000
mDBGTBL_BIT5:       equ    %00100000
mDBGTBL_BIT6:       equ    %01000000
mDBGTBL_BIT7:       equ    %10000000


;*** DBGCNT - Debug Count Register; 0x00000024 ***
DBGCNT:             equ    $00000024                                ;*** DBGCNT - Debug Count Register; 0x00000024 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGCNT_CNT0:        equ    0                                         ; Count Value, bit 0
DBGCNT_CNT1:        equ    1                                         ; Count Value, bit 1
DBGCNT_CNT2:        equ    2                                         ; Count Value, bit 2
DBGCNT_CNT3:        equ    3                                         ; Count Value, bit 3
DBGCNT_CNT4:        equ    4                                         ; Count Value, bit 4
DBGCNT_CNT5:        equ    5                                         ; Count Value, bit 5
DBGCNT_TBF:         equ    7                                         ; Trace Buffer Full
; bit position masks
mDBGCNT_CNT0:       equ    %00000001
mDBGCNT_CNT1:       equ    %00000010
mDBGCNT_CNT2:       equ    %00000100
mDBGCNT_CNT3:       equ    %00001000
mDBGCNT_CNT4:       equ    %00010000
mDBGCNT_CNT5:       equ    %00100000
mDBGCNT_TBF:        equ    %10000000


;*** DBGCCX - Debug Comparator C Extended Register; 0x00000025 ***
DBGCCX:             equ    $00000025                                ;*** DBGCCX - Debug Comparator C Extended Register; 0x00000025 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGCCX_EXTCMP0:     equ    0                                         ; Comparator C Extended Compare Bits, bit 0
DBGCCX_EXTCMP1:     equ    1                                         ; Comparator C Extended Compare Bits, bit 1
DBGCCX_EXTCMP2:     equ    2                                         ; Comparator C Extended Compare Bits, bit 2
DBGCCX_EXTCMP3:     equ    3                                         ; Comparator C Extended Compare Bits, bit 3
DBGCCX_EXTCMP4:     equ    4                                         ; Comparator C Extended Compare Bits, bit 4
DBGCCX_EXTCMP5:     equ    5                                         ; Comparator C Extended Compare Bits, bit 5
DBGCCX_PAGSEL0:     equ    6                                         ; Page Selector Field, bit 0
DBGCCX_PAGSEL1:     equ    7                                         ; Page Selector Field, bit 1
; bit position masks
mDBGCCX_EXTCMP0:    equ    %00000001
mDBGCCX_EXTCMP1:    equ    %00000010
mDBGCCX_EXTCMP2:    equ    %00000100
mDBGCCX_EXTCMP3:    equ    %00001000
mDBGCCX_EXTCMP4:    equ    %00010000
mDBGCCX_EXTCMP5:    equ    %00100000
mDBGCCX_PAGSEL0:    equ    %01000000
mDBGCCX_PAGSEL1:    equ    %10000000


;*** DBGCC - Debug Comparator C Register; 0x00000026 ***
DBGCC:              equ    $00000026                                ;*** DBGCC - Debug Comparator C Register; 0x00000026 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGCC_BIT0:         equ    0                                         ; Comparator C Compare Bit 0
DBGCC_BIT1:         equ    1                                         ; Comparator C Compare Bit 1
DBGCC_BIT2:         equ    2                                         ; Comparator C Compare Bit 2
DBGCC_BIT3:         equ    3                                         ; Comparator C Compare Bit 3
DBGCC_BIT4:         equ    4                                         ; Comparator C Compare Bit 4
DBGCC_BIT5:         equ    5                                         ; Comparator C Compare Bit 5
DBGCC_BIT6:         equ    6                                         ; Comparator C Compare Bit 6
DBGCC_BIT7:         equ    7                                         ; Comparator C Compare Bit 7
DBGCC_BIT8:         equ    8                                         ; Comparator C Compare Bit 8
DBGCC_BIT9:         equ    9                                         ; Comparator C Compare Bit 9
DBGCC_BIT10:        equ    10                                        ; Comparator C Compare Bit 10
DBGCC_BIT11:        equ    11                                        ; Comparator C Compare Bit 11
DBGCC_BIT12:        equ    12                                        ; Comparator C Compare Bit 12
DBGCC_BIT13:        equ    13                                        ; Comparator C Compare Bit 13
DBGCC_BIT14:        equ    14                                        ; Comparator C Compare Bit 14
DBGCC_BIT15:        equ    15                                        ; Comparator C Compare Bit 15
; bit position masks
mDBGCC_BIT0:        equ    %00000001
mDBGCC_BIT1:        equ    %00000010
mDBGCC_BIT2:        equ    %00000100
mDBGCC_BIT3:        equ    %00001000
mDBGCC_BIT4:        equ    %00010000
mDBGCC_BIT5:        equ    %00100000
mDBGCC_BIT6:        equ    %01000000
mDBGCC_BIT7:        equ    %10000000
mDBGCC_BIT8:        equ    %100000000
mDBGCC_BIT9:        equ    %1000000000
mDBGCC_BIT10:       equ    %10000000000
mDBGCC_BIT11:       equ    %100000000000
mDBGCC_BIT12:       equ    %1000000000000
mDBGCC_BIT13:       equ    %10000000000000
mDBGCC_BIT14:       equ    %100000000000000
mDBGCC_BIT15:       equ    %1000000000000000


;*** DBGCCH - Debug Comparator C Register High; 0x00000026 ***
DBGCCH:             equ    $00000026                                ;*** DBGCCH - Debug Comparator C Register High; 0x00000026 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGCCH_BIT8:        equ    0                                         ; Comparator C Compare Bit 8
DBGCCH_BIT9:        equ    1                                         ; Comparator C Compare Bit 9
DBGCCH_BIT10:       equ    2                                         ; Comparator C Compare Bit 10
DBGCCH_BIT11:       equ    3                                         ; Comparator C Compare Bit 11
DBGCCH_BIT12:       equ    4                                         ; Comparator C Compare Bit 12
DBGCCH_BIT13:       equ    5                                         ; Comparator C Compare Bit 13
DBGCCH_BIT14:       equ    6                                         ; Comparator C Compare Bit 14
DBGCCH_BIT15:       equ    7                                         ; Comparator C Compare Bit 15
; bit position masks
mDBGCCH_BIT8:       equ    %00000001
mDBGCCH_BIT9:       equ    %00000010
mDBGCCH_BIT10:      equ    %00000100
mDBGCCH_BIT11:      equ    %00001000
mDBGCCH_BIT12:      equ    %00010000
mDBGCCH_BIT13:      equ    %00100000
mDBGCCH_BIT14:      equ    %01000000
mDBGCCH_BIT15:      equ    %10000000


;*** DBGCCL - Debug Comparator C Register Low; 0x00000027 ***
DBGCCL:             equ    $00000027                                ;*** DBGCCL - Debug Comparator C Register Low; 0x00000027 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGCCL_BIT0:        equ    0                                         ; Comparator C Compare Bit 0
DBGCCL_BIT1:        equ    1                                         ; Comparator C Compare Bit 1
DBGCCL_BIT2:        equ    2                                         ; Comparator C Compare Bit 2
DBGCCL_BIT3:        equ    3                                         ; Comparator C Compare Bit 3
DBGCCL_BIT4:        equ    4                                         ; Comparator C Compare Bit 4
DBGCCL_BIT5:        equ    5                                         ; Comparator C Compare Bit 5
DBGCCL_BIT6:        equ    6                                         ; Comparator C Compare Bit 6
DBGCCL_BIT7:        equ    7                                         ; Comparator C Compare Bit 7
; bit position masks
mDBGCCL_BIT0:       equ    %00000001
mDBGCCL_BIT1:       equ    %00000010
mDBGCCL_BIT2:       equ    %00000100
mDBGCCL_BIT3:       equ    %00001000
mDBGCCL_BIT4:       equ    %00010000
mDBGCCL_BIT5:       equ    %00100000
mDBGCCL_BIT6:       equ    %01000000
mDBGCCL_BIT7:       equ    %10000000


;*** DBGC2 - Debug Control Register 2; 0x00000028 ***
DBGC2:              equ    $00000028                                ;*** DBGC2 - Debug Control Register 2; 0x00000028 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGC2_RWC:          equ    0                                         ; Read/Write Comparator C Value Bit
DBGC2_RWCEN:        equ    1                                         ; Read/Write Comparator C Enable Bit
DBGC2_TAGC:         equ    2                                         ; Comparator C Tag Select
DBGC2_BKCEN:        equ    3                                         ; Breakpoint Comparator C Enable Bit
DBGC2_TAGAB:        equ    4                                         ; Comparator A/B Tag Select
DBGC2_BDM:          equ    5                                         ; Background Debug Mode Enable
DBGC2_FULL:         equ    6                                         ; Full Breakpoint Mode Enable
DBGC2_BKABEN:       equ    7                                         ; Breakpoint Using Comparator A and B Enable
; bit position masks
mDBGC2_RWC:         equ    %00000001
mDBGC2_RWCEN:       equ    %00000010
mDBGC2_TAGC:        equ    %00000100
mDBGC2_BKCEN:       equ    %00001000
mDBGC2_TAGAB:       equ    %00010000
mDBGC2_BDM:         equ    %00100000
mDBGC2_FULL:        equ    %01000000
mDBGC2_BKABEN:      equ    %10000000


;*** DBGC3 - Debug Control Register 3; 0x00000029 ***
DBGC3:              equ    $00000029                                ;*** DBGC3 - Debug Control Register 3; 0x00000029 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGC3_RWB:          equ    0                                         ; Read/Write Comparator B Value Bit
DBGC3_RWBEN:        equ    1                                         ; Read/Write Comparator B Enable Bit
DBGC3_RWA:          equ    2                                         ; Read/Write Comparator A Value Bit
DBGC3_RWAEN:        equ    3                                         ; Read/Write Comparator A Enable Bit
DBGC3_BKBMBL:       equ    4                                         ; Breakpoint Mask Low Byte for Second Address
DBGC3_BKBMBH:       equ    5                                         ; Breakpoint Mask High Byte for Second Address
DBGC3_BKAMBL:       equ    6                                         ; Breakpoint Mask Low Byte for First Address
DBGC3_BKAMBH:       equ    7                                         ; Breakpoint Mask High Byte for First Address
; bit position masks
mDBGC3_RWB:         equ    %00000001
mDBGC3_RWBEN:       equ    %00000010
mDBGC3_RWA:         equ    %00000100
mDBGC3_RWAEN:       equ    %00001000
mDBGC3_BKBMBL:      equ    %00010000
mDBGC3_BKBMBH:      equ    %00100000
mDBGC3_BKAMBL:      equ    %01000000
mDBGC3_BKAMBH:      equ    %10000000


;*** DBGCAX - Debug Comparator A Extended Register; 0x0000002A ***
DBGCAX:             equ    $0000002A                                ;*** DBGCAX - Debug Comparator A Extended Register; 0x0000002A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGCAX_EXTCMP0:     equ    0                                         ; Comparator A Extended Compare Bits, bit 0
DBGCAX_EXTCMP1:     equ    1                                         ; Comparator A Extended Compare Bits, bit 1
DBGCAX_EXTCMP2:     equ    2                                         ; Comparator A Extended Compare Bits, bit 2
DBGCAX_EXTCMP3:     equ    3                                         ; Comparator A Extended Compare Bits, bit 3
DBGCAX_EXTCMP4:     equ    4                                         ; Comparator A Extended Compare Bits, bit 4
DBGCAX_EXTCMP5:     equ    5                                         ; Comparator A Extended Compare Bits, bit 5
DBGCAX_PAGSEL0:     equ    6                                         ; Page Selector Field, bit 0
DBGCAX_PAGSEL1:     equ    7                                         ; Page Selector Field, bit 1
; bit position masks
mDBGCAX_EXTCMP0:    equ    %00000001
mDBGCAX_EXTCMP1:    equ    %00000010
mDBGCAX_EXTCMP2:    equ    %00000100
mDBGCAX_EXTCMP3:    equ    %00001000
mDBGCAX_EXTCMP4:    equ    %00010000
mDBGCAX_EXTCMP5:    equ    %00100000
mDBGCAX_PAGSEL0:    equ    %01000000
mDBGCAX_PAGSEL1:    equ    %10000000


;*** DBGCA - Debug Comparator A Register; 0x0000002B ***
DBGCA:              equ    $0000002B                                ;*** DBGCA - Debug Comparator A Register; 0x0000002B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGCA_BIT0:         equ    0                                         ; Comparator A Compare Bit 0
DBGCA_BIT1:         equ    1                                         ; Comparator A Compare Bit 1
DBGCA_BIT2:         equ    2                                         ; Comparator A Compare Bit 2
DBGCA_BIT3:         equ    3                                         ; Comparator A Compare Bit 3
DBGCA_BIT4:         equ    4                                         ; Comparator A Compare Bit 4
DBGCA_BIT5:         equ    5                                         ; Comparator A Compare Bit 5
DBGCA_BIT6:         equ    6                                         ; Comparator A Compare Bit 6
DBGCA_BIT7:         equ    7                                         ; Comparator A Compare Bit 7
DBGCA_BIT8:         equ    8                                         ; Comparator A Compare Bit 8
DBGCA_BIT9:         equ    9                                         ; Comparator A Compare Bit 9
DBGCA_BIT10:        equ    10                                        ; Comparator A Compare Bit 10
DBGCA_BIT11:        equ    11                                        ; Comparator A Compare Bit 11
DBGCA_BIT12:        equ    12                                        ; Comparator A Compare Bit 12
DBGCA_BIT13:        equ    13                                        ; Comparator A Compare Bit 13
DBGCA_BIT14:        equ    14                                        ; Comparator A Compare Bit 14
DBGCA_BIT15:        equ    15                                        ; Comparator A Compare Bit 15
; bit position masks
mDBGCA_BIT0:        equ    %00000001
mDBGCA_BIT1:        equ    %00000010
mDBGCA_BIT2:        equ    %00000100
mDBGCA_BIT3:        equ    %00001000
mDBGCA_BIT4:        equ    %00010000
mDBGCA_BIT5:        equ    %00100000
mDBGCA_BIT6:        equ    %01000000
mDBGCA_BIT7:        equ    %10000000
mDBGCA_BIT8:        equ    %100000000
mDBGCA_BIT9:        equ    %1000000000
mDBGCA_BIT10:       equ    %10000000000
mDBGCA_BIT11:       equ    %100000000000
mDBGCA_BIT12:       equ    %1000000000000
mDBGCA_BIT13:       equ    %10000000000000
mDBGCA_BIT14:       equ    %100000000000000
mDBGCA_BIT15:       equ    %1000000000000000


;*** DBGCAH - Debug Comparator A Register High; 0x0000002B ***
DBGCAH:             equ    $0000002B                                ;*** DBGCAH - Debug Comparator A Register High; 0x0000002B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGCAH_BIT8:        equ    0                                         ; Comparator A Compare Bit 8
DBGCAH_BIT9:        equ    1                                         ; Comparator A Compare Bit 9
DBGCAH_BIT10:       equ    2                                         ; Comparator A Compare Bit 10
DBGCAH_BIT11:       equ    3                                         ; Comparator A Compare Bit 11
DBGCAH_BIT12:       equ    4                                         ; Comparator A Compare Bit 12
DBGCAH_BIT13:       equ    5                                         ; Comparator A Compare Bit 13
DBGCAH_BIT14:       equ    6                                         ; Comparator A Compare Bit 14
DBGCAH_BIT15:       equ    7                                         ; Comparator A Compare Bit 15
; bit position masks
mDBGCAH_BIT8:       equ    %00000001
mDBGCAH_BIT9:       equ    %00000010
mDBGCAH_BIT10:      equ    %00000100
mDBGCAH_BIT11:      equ    %00001000
mDBGCAH_BIT12:      equ    %00010000
mDBGCAH_BIT13:      equ    %00100000
mDBGCAH_BIT14:      equ    %01000000
mDBGCAH_BIT15:      equ    %10000000


;*** DBGCAL - Debug Comparator A Register Low; 0x0000002C ***
DBGCAL:             equ    $0000002C                                ;*** DBGCAL - Debug Comparator A Register Low; 0x0000002C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGCAL_BIT0:        equ    0                                         ; Comparator A Compare Bit 0
DBGCAL_BIT1:        equ    1                                         ; Comparator A Compare Bit 1
DBGCAL_BIT2:        equ    2                                         ; Comparator A Compare Bit 2
DBGCAL_BIT3:        equ    3                                         ; Comparator A Compare Bit 3
DBGCAL_BIT4:        equ    4                                         ; Comparator A Compare Bit 4
DBGCAL_BIT5:        equ    5                                         ; Comparator A Compare Bit 5
DBGCAL_BIT6:        equ    6                                         ; Comparator A Compare Bit 6
DBGCAL_BIT7:        equ    7                                         ; Comparator A Compare Bit 7
; bit position masks
mDBGCAL_BIT0:       equ    %00000001
mDBGCAL_BIT1:       equ    %00000010
mDBGCAL_BIT2:       equ    %00000100
mDBGCAL_BIT3:       equ    %00001000
mDBGCAL_BIT4:       equ    %00010000
mDBGCAL_BIT5:       equ    %00100000
mDBGCAL_BIT6:       equ    %01000000
mDBGCAL_BIT7:       equ    %10000000


;*** DBGCBX - Debug Comparator B Extended Register; 0x0000002D ***
DBGCBX:             equ    $0000002D                                ;*** DBGCBX - Debug Comparator B Extended Register; 0x0000002D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGCBX_EXTCMP0:     equ    0                                         ; Comparator B Extended Compare Bits, bit 0
DBGCBX_EXTCMP1:     equ    1                                         ; Comparator B Extended Compare Bits, bit 1
DBGCBX_EXTCMP2:     equ    2                                         ; Comparator B Extended Compare Bits, bit 2
DBGCBX_EXTCMP3:     equ    3                                         ; Comparator B Extended Compare Bits, bit 3
DBGCBX_EXTCMP4:     equ    4                                         ; Comparator B Extended Compare Bits, bit 4
DBGCBX_EXTCMP5:     equ    5                                         ; Comparator B Extended Compare Bits, bit 5
DBGCBX_PAGSEL0:     equ    6                                         ; Page Selector Field, bit 0
DBGCBX_PAGSEL1:     equ    7                                         ; Page Selector Field, bit 1
; bit position masks
mDBGCBX_EXTCMP0:    equ    %00000001
mDBGCBX_EXTCMP1:    equ    %00000010
mDBGCBX_EXTCMP2:    equ    %00000100
mDBGCBX_EXTCMP3:    equ    %00001000
mDBGCBX_EXTCMP4:    equ    %00010000
mDBGCBX_EXTCMP5:    equ    %00100000
mDBGCBX_PAGSEL0:    equ    %01000000
mDBGCBX_PAGSEL1:    equ    %10000000


;*** DBGCB - Debug Comparator B Register; 0x0000002E ***
DBGCB:              equ    $0000002E                                ;*** DBGCB - Debug Comparator B Register; 0x0000002E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGCB_BIT0:         equ    0                                         ; Comparator B High Compare Bit 0
DBGCB_BIT1:         equ    1                                         ; Comparator B High Compare Bit 1
DBGCB_BIT2:         equ    2                                         ; Comparator B High Compare Bit 2
DBGCB_BIT3:         equ    3                                         ; Comparator B High Compare Bit 3
DBGCB_BIT4:         equ    4                                         ; Comparator B High Compare Bit 4
DBGCB_BIT5:         equ    5                                         ; Comparator B High Compare Bit 5
DBGCB_BIT6:         equ    6                                         ; Comparator B High Compare Bit 6
DBGCB_BIT7:         equ    7                                         ; Comparator B High Compare Bit 7
DBGCB_BIT8:         equ    8                                         ; Comparator B High Compare Bit 8
DBGCB_BIT9:         equ    9                                         ; Comparator B High Compare Bit 9
DBGCB_BIT10:        equ    10                                        ; Comparator B High Compare Bit 10
DBGCB_BIT11:        equ    11                                        ; Comparator B High Compare Bit 11
DBGCB_BIT12:        equ    12                                        ; Comparator B High Compare Bit 12
DBGCB_BIT13:        equ    13                                        ; Comparator B High Compare Bit 13
DBGCB_BIT14:        equ    14                                        ; Comparator B High Compare Bit 14
DBGCB_BIT15:        equ    15                                        ; Comparator B High Compare Bit 15
; bit position masks
mDBGCB_BIT0:        equ    %00000001
mDBGCB_BIT1:        equ    %00000010
mDBGCB_BIT2:        equ    %00000100
mDBGCB_BIT3:        equ    %00001000
mDBGCB_BIT4:        equ    %00010000
mDBGCB_BIT5:        equ    %00100000
mDBGCB_BIT6:        equ    %01000000
mDBGCB_BIT7:        equ    %10000000
mDBGCB_BIT8:        equ    %100000000
mDBGCB_BIT9:        equ    %1000000000
mDBGCB_BIT10:       equ    %10000000000
mDBGCB_BIT11:       equ    %100000000000
mDBGCB_BIT12:       equ    %1000000000000
mDBGCB_BIT13:       equ    %10000000000000
mDBGCB_BIT14:       equ    %100000000000000
mDBGCB_BIT15:       equ    %1000000000000000


;*** DBGCBH - Debug Comparator B Register High; 0x0000002E ***
DBGCBH:             equ    $0000002E                                ;*** DBGCBH - Debug Comparator B Register High; 0x0000002E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGCBH_BIT8:        equ    0                                         ; Comparator B High Compare Bit 8
DBGCBH_BIT9:        equ    1                                         ; Comparator B High Compare Bit 9
DBGCBH_BIT10:       equ    2                                         ; Comparator B High Compare Bit 10
DBGCBH_BIT11:       equ    3                                         ; Comparator B High Compare Bit 11
DBGCBH_BIT12:       equ    4                                         ; Comparator B High Compare Bit 12
DBGCBH_BIT13:       equ    5                                         ; Comparator B High Compare Bit 13
DBGCBH_BIT14:       equ    6                                         ; Comparator B High Compare Bit 14
DBGCBH_BIT15:       equ    7                                         ; Comparator B High Compare Bit 15
; bit position masks
mDBGCBH_BIT8:       equ    %00000001
mDBGCBH_BIT9:       equ    %00000010
mDBGCBH_BIT10:      equ    %00000100
mDBGCBH_BIT11:      equ    %00001000
mDBGCBH_BIT12:      equ    %00010000
mDBGCBH_BIT13:      equ    %00100000
mDBGCBH_BIT14:      equ    %01000000
mDBGCBH_BIT15:      equ    %10000000


;*** DBGCBL - Debug Comparator B Register Low; 0x0000002F ***
DBGCBL:             equ    $0000002F                                ;*** DBGCBL - Debug Comparator B Register Low; 0x0000002F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGCBL_BIT0:        equ    0                                         ; Comparator B High Compare Bit 0
DBGCBL_BIT1:        equ    1                                         ; Comparator B High Compare Bit 1
DBGCBL_BIT2:        equ    2                                         ; Comparator B High Compare Bit 2
DBGCBL_BIT3:        equ    3                                         ; Comparator B High Compare Bit 3
DBGCBL_BIT4:        equ    4                                         ; Comparator B High Compare Bit 4
DBGCBL_BIT5:        equ    5                                         ; Comparator B High Compare Bit 5
DBGCBL_BIT6:        equ    6                                         ; Comparator B High Compare Bit 6
DBGCBL_BIT7:        equ    7                                         ; Comparator B High Compare Bit 7
; bit position masks
mDBGCBL_BIT0:       equ    %00000001
mDBGCBL_BIT1:       equ    %00000010
mDBGCBL_BIT2:       equ    %00000100
mDBGCBL_BIT3:       equ    %00001000
mDBGCBL_BIT4:       equ    %00010000
mDBGCBL_BIT5:       equ    %00100000
mDBGCBL_BIT6:       equ    %01000000
mDBGCBL_BIT7:       equ    %10000000


;*** PPAGE - Page Index Register; 0x00000030 ***
PPAGE:              equ    $00000030                                ;*** PPAGE - Page Index Register; 0x00000030 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PPAGE_PIX0:         equ    0                                         ; Page Index Register Bit 0
PPAGE_PIX1:         equ    1                                         ; Page Index Register Bit 1
PPAGE_PIX2:         equ    2                                         ; Page Index Register Bit 2
PPAGE_PIX3:         equ    3                                         ; Page Index Register Bit 3
PPAGE_PIX4:         equ    4                                         ; Page Index Register Bit 4
PPAGE_PIX5:         equ    5                                         ; Page Index Register Bit 5
; bit position masks
mPPAGE_PIX0:        equ    %00000001
mPPAGE_PIX1:        equ    %00000010
mPPAGE_PIX2:        equ    %00000100
mPPAGE_PIX3:        equ    %00001000
mPPAGE_PIX4:        equ    %00010000
mPPAGE_PIX5:        equ    %00100000


;*** PORTK - Port K Data Register; 0x00000032 ***
PORTK:              equ    $00000032                                ;*** PORTK - Port K Data Register; 0x00000032 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PORTK_BIT0:         equ    0                                         ; Port K Bit 0
PORTK_BIT1:         equ    1                                         ; Port K Bit 1
PORTK_BIT2:         equ    2                                         ; Port K Bit 2
PORTK_BIT3:         equ    3                                         ; Port K Bit 3
PORTK_BIT4:         equ    4                                         ; Port K Bit 4
PORTK_BIT5:         equ    5                                         ; Port K Bit 5
PORTK_BIT6:         equ    6                                         ; Port K Bit 6
PORTK_BIT7:         equ    7                                         ; Port K Bit 7
; bit position masks
mPORTK_BIT0:        equ    %00000001
mPORTK_BIT1:        equ    %00000010
mPORTK_BIT2:        equ    %00000100
mPORTK_BIT3:        equ    %00001000
mPORTK_BIT4:        equ    %00010000
mPORTK_BIT5:        equ    %00100000
mPORTK_BIT6:        equ    %01000000
mPORTK_BIT7:        equ    %10000000


;*** DDRK - Port K Data Direction Register; 0x00000033 ***
DDRK:               equ    $00000033                                ;*** DDRK - Port K Data Direction Register; 0x00000033 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRK_BIT0:          equ    0                                         ; Port K Data Direction Bit 0
DDRK_BIT1:          equ    1                                         ; Port K Data Direction Bit 1
DDRK_BIT2:          equ    2                                         ; Port K Data Direction Bit 2
DDRK_BIT3:          equ    3                                         ; Port K Data Direction Bit 3
DDRK_BIT4:          equ    4                                         ; Port K Data Direction Bit 4
DDRK_BIT5:          equ    5                                         ; Port K Data Direction Bit 5
DDRK_BIT6:          equ    6                                         ; Port K Data Direction Bit 6
DDRK_BIT7:          equ    7                                         ; Port K Data Direction Bit 7
; bit position masks
mDDRK_BIT0:         equ    %00000001
mDDRK_BIT1:         equ    %00000010
mDDRK_BIT2:         equ    %00000100
mDDRK_BIT3:         equ    %00001000
mDDRK_BIT4:         equ    %00010000
mDDRK_BIT5:         equ    %00100000
mDDRK_BIT6:         equ    %01000000
mDDRK_BIT7:         equ    %10000000


;*** SYNR - CRG Synthesizer Register; 0x00000034 ***
SYNR:               equ    $00000034                                ;*** SYNR - CRG Synthesizer Register; 0x00000034 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SYNR_SYN0:          equ    0                                         ; CRG Synthesizer Bit 0
SYNR_SYN1:          equ    1                                         ; CRG Synthesizer Bit 1
SYNR_SYN2:          equ    2                                         ; CRG Synthesizer Bit 2
SYNR_SYN3:          equ    3                                         ; CRG Synthesizer Bit 3
SYNR_SYN4:          equ    4                                         ; CRG Synthesizer Bit 4
SYNR_SYN5:          equ    5                                         ; CRG Synthesizer Bit 5
; bit position masks
mSYNR_SYN0:         equ    %00000001
mSYNR_SYN1:         equ    %00000010
mSYNR_SYN2:         equ    %00000100
mSYNR_SYN3:         equ    %00001000
mSYNR_SYN4:         equ    %00010000
mSYNR_SYN5:         equ    %00100000


;*** REFDV - CRG Reference Divider Register; 0x00000035 ***
REFDV:              equ    $00000035                                ;*** REFDV - CRG Reference Divider Register; 0x00000035 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
REFDV_REFDV0:       equ    0                                         ; CRG Reference Divider Bit 0
REFDV_REFDV1:       equ    1                                         ; CRG Reference Divider Bit 1
REFDV_REFDV2:       equ    2                                         ; CRG Reference Divider Bit 2
REFDV_REFDV3:       equ    3                                         ; CRG Reference Divider Bit 3
; bit position masks
mREFDV_REFDV0:      equ    %00000001
mREFDV_REFDV1:      equ    %00000010
mREFDV_REFDV2:      equ    %00000100
mREFDV_REFDV3:      equ    %00001000


;*** CRGFLG - CRG Flags Register; 0x00000037 ***
CRGFLG:             equ    $00000037                                ;*** CRGFLG - CRG Flags Register; 0x00000037 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CRGFLG_SCM:         equ    0                                         ; Self-clock mode Status
CRGFLG_SCMIF:       equ    1                                         ; Self-clock mode Interrupt Flag
CRGFLG_TRACK:       equ    2                                         ; Track Status
CRGFLG_LOCK:        equ    3                                         ; Lock Status
CRGFLG_LOCKIF:      equ    4                                         ; PLL Lock Interrupt Flag
CRGFLG_LVRF:        equ    5                                         ; Low Voltage Reset Flag
CRGFLG_PORF:        equ    6                                         ; Power on Reset Flag
CRGFLG_RTIF:        equ    7                                         ; Real Time Interrupt Flag
; bit position masks
mCRGFLG_SCM:        equ    %00000001
mCRGFLG_SCMIF:      equ    %00000010
mCRGFLG_TRACK:      equ    %00000100
mCRGFLG_LOCK:       equ    %00001000
mCRGFLG_LOCKIF:     equ    %00010000
mCRGFLG_LVRF:       equ    %00100000
mCRGFLG_PORF:       equ    %01000000
mCRGFLG_RTIF:       equ    %10000000


;*** CRGINT - CRG Interrupt Enable Register; 0x00000038 ***
CRGINT:             equ    $00000038                                ;*** CRGINT - CRG Interrupt Enable Register; 0x00000038 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CRGINT_SCMIE:       equ    1                                         ; Self-clock mode Interrupt Enable
CRGINT_LOCKIE:      equ    4                                         ; Lock Interrupt Enable
CRGINT_RTIE:        equ    7                                         ; Real Time Interrupt Enable
; bit position masks
mCRGINT_SCMIE:      equ    %00000010
mCRGINT_LOCKIE:     equ    %00010000
mCRGINT_RTIE:       equ    %10000000


;*** CLKSEL - CRG Clock Select Register; 0x00000039 ***
CLKSEL:             equ    $00000039                                ;*** CLKSEL - CRG Clock Select Register; 0x00000039 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CLKSEL_COPWAI:      equ    0                                         ; COP stops in WAIT mode
CLKSEL_RTIWAI:      equ    1                                         ; RTI stops in WAIT mode
CLKSEL_CWAI:        equ    2                                         ; CLK24 and CLK23 stop in WAIT mode
CLKSEL_PLLWAI:      equ    3                                         ; PLL stops in WAIT mode
CLKSEL_ROAWAI:      equ    4                                         ; Reduced Oscillator Amplitude in WAIT mode
CLKSEL_SYSWAI:      equ    5                                         ; System clocks stop in WAIT mode
CLKSEL_PSTP:        equ    6                                         ; Pseudo Stop
CLKSEL_PLLSEL:      equ    7                                         ; PLL selected for system clock
; bit position masks
mCLKSEL_COPWAI:     equ    %00000001
mCLKSEL_RTIWAI:     equ    %00000010
mCLKSEL_CWAI:       equ    %00000100
mCLKSEL_PLLWAI:     equ    %00001000
mCLKSEL_ROAWAI:     equ    %00010000
mCLKSEL_SYSWAI:     equ    %00100000
mCLKSEL_PSTP:       equ    %01000000
mCLKSEL_PLLSEL:     equ    %10000000


;*** PLLCTL - CRG PLL Control Register; 0x0000003A ***
PLLCTL:             equ    $0000003A                                ;*** PLLCTL - CRG PLL Control Register; 0x0000003A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PLLCTL_SCME:        equ    0                                         ; Self-clock mode enable
PLLCTL_PCE:         equ    1                                         ; COP Enable during Pseudo Stop Bit
PLLCTL_PRE:         equ    2                                         ; RTI Enable during Pseudo Stop Bit
PLLCTL_ACQ:         equ    4                                         ; Acquisition
PLLCTL_AUTO:        equ    5                                         ; Automatic Bandwidth Control
PLLCTL_PLLON:       equ    6                                         ; Phase Lock Loop On
PLLCTL_CME:         equ    7                                         ; Clock Monitor Enable
; bit position masks
mPLLCTL_SCME:       equ    %00000001
mPLLCTL_PCE:        equ    %00000010
mPLLCTL_PRE:        equ    %00000100
mPLLCTL_ACQ:        equ    %00010000
mPLLCTL_AUTO:       equ    %00100000
mPLLCTL_PLLON:      equ    %01000000
mPLLCTL_CME:        equ    %10000000


;*** RTICTL - CRG RTI Control Register; 0x0000003B ***
RTICTL:             equ    $0000003B                                ;*** RTICTL - CRG RTI Control Register; 0x0000003B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RTICTL_RTR0:        equ    0                                         ; Real Time Interrupt Modulus Counter Select Bit 0
RTICTL_RTR1:        equ    1                                         ; Real Time Interrupt Modulus Counter Select Bit 1
RTICTL_RTR2:        equ    2                                         ; Real Time Interrupt Modulus Counter Select Bit 2
RTICTL_RTR3:        equ    3                                         ; Real Time Interrupt Modulus Counter Select Bit 3
RTICTL_RTR4:        equ    4                                         ; Real Time Interrupt Prescale Rate Select Bit 4
RTICTL_RTR5:        equ    5                                         ; Real Time Interrupt Prescale Rate Select Bit 5
RTICTL_RTR6:        equ    6                                         ; Real Time Interrupt Prescale Rate Select Bit 6
; bit position masks
mRTICTL_RTR0:       equ    %00000001
mRTICTL_RTR1:       equ    %00000010
mRTICTL_RTR2:       equ    %00000100
mRTICTL_RTR3:       equ    %00001000
mRTICTL_RTR4:       equ    %00010000
mRTICTL_RTR5:       equ    %00100000
mRTICTL_RTR6:       equ    %01000000


;*** COPCTL - CRG COP Control Register; 0x0000003C ***
COPCTL:             equ    $0000003C                                ;*** COPCTL - CRG COP Control Register; 0x0000003C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
COPCTL_CR0:         equ    0                                         ; COP Watchdog Timer Rate select Bit 0
COPCTL_CR1:         equ    1                                         ; COP Watchdog Timer Rate select Bit 1
COPCTL_CR2:         equ    2                                         ; COP Watchdog Timer Rate select Bit 2
COPCTL_RSBCK:       equ    6                                         ; COP and RTI stop in Active BDM mode Bit
COPCTL_WCOP:        equ    7                                         ; Window COP mode
; bit position masks
mCOPCTL_CR0:        equ    %00000001
mCOPCTL_CR1:        equ    %00000010
mCOPCTL_CR2:        equ    %00000100
mCOPCTL_RSBCK:      equ    %01000000
mCOPCTL_WCOP:       equ    %10000000


;*** ARMCOP - CRG COP Timer Arm/Reset Register; 0x0000003F ***
ARMCOP:             equ    $0000003F                                ;*** ARMCOP - CRG COP Timer Arm/Reset Register; 0x0000003F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ARMCOP_BIT0:        equ    0                                         ; CRG COP Timer Arm/Reset Bit 0
ARMCOP_BIT1:        equ    1                                         ; CRG COP Timer Arm/Reset Bit 1
ARMCOP_BIT2:        equ    2                                         ; CRG COP Timer Arm/Reset Bit 2
ARMCOP_BIT3:        equ    3                                         ; CRG COP Timer Arm/Reset Bit 3
ARMCOP_BIT4:        equ    4                                         ; CRG COP Timer Arm/Reset Bit 4
ARMCOP_BIT5:        equ    5                                         ; CRG COP Timer Arm/Reset Bit 5
ARMCOP_BIT6:        equ    6                                         ; CRG COP Timer Arm/Reset Bit 6
ARMCOP_BIT7:        equ    7                                         ; CRG COP Timer Arm/Reset Bit 7
; bit position masks
mARMCOP_BIT0:       equ    %00000001
mARMCOP_BIT1:       equ    %00000010
mARMCOP_BIT2:       equ    %00000100
mARMCOP_BIT3:       equ    %00001000
mARMCOP_BIT4:       equ    %00010000
mARMCOP_BIT5:       equ    %00100000
mARMCOP_BIT6:       equ    %01000000
mARMCOP_BIT7:       equ    %10000000


;*** TIM0_TIOS - TIM0 Timer Input Capture/Output Compare Select; 0x00000040 ***
TIM0_TIOS:          equ    $00000040                                ;*** TIM0_TIOS - TIM0 Timer Input Capture/Output Compare Select; 0x00000040 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TIM0_TIOS_IOS4:     equ    4                                         ; Input Capture or Output Compare Channel Configuration Bit 4
TIM0_TIOS_IOS5:     equ    5                                         ; Input Capture or Output Compare Channel Configuration Bit 5
TIM0_TIOS_IOS6:     equ    6                                         ; Input Capture or Output Compare Channel Configuration Bit 6
TIM0_TIOS_IOS7:     equ    7                                         ; Input Capture or Output Compare Channel Configuration Bit 7
; bit position masks
mTIM0_TIOS_IOS4:    equ    %00010000
mTIM0_TIOS_IOS5:    equ    %00100000
mTIM0_TIOS_IOS6:    equ    %01000000
mTIM0_TIOS_IOS7:    equ    %10000000


;*** TIM0_CFORC - TIM0 Timer Compare Force Register; 0x00000041 ***
TIM0_CFORC:         equ    $00000041                                ;*** TIM0_CFORC - TIM0 Timer Compare Force Register; 0x00000041 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TIM0_CFORC_FOC4:    equ    4                                         ; Force Output Compare Action for Channel 4
TIM0_CFORC_FOC5:    equ    5                                         ; Force Output Compare Action for Channel 5
TIM0_CFORC_FOC6:    equ    6                                         ; Force Output Compare Action for Channel 6
TIM0_CFORC_FOC7:    equ    7                                         ; Force Output Compare Action for Channel 7
; bit position masks
mTIM0_CFORC_FOC4:   equ    %00010000
mTIM0_CFORC_FOC5:   equ    %00100000
mTIM0_CFORC_FOC6:   equ    %01000000
mTIM0_CFORC_FOC7:   equ    %10000000


;*** TIM0_OC7M - TIM0 Output Compare 7 Mask Register; 0x00000042 ***
TIM0_OC7M:          equ    $00000042                                ;*** TIM0_OC7M - TIM0 Output Compare 7 Mask Register; 0x00000042 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TIM0_OC7M_OC7M4:    equ    4                                         ; Output Compare 7 Mask Bit 4
TIM0_OC7M_OC7M5:    equ    5                                         ; Output Compare 7 Mask Bit 5
TIM0_OC7M_OC7M6:    equ    6                                         ; Output Compare 7 Mask Bit 6
TIM0_OC7M_OC7M7:    equ    7                                         ; Output Compare 7 Mask Bit 7
; bit position masks
mTIM0_OC7M_OC7M4:   equ    %00010000
mTIM0_OC7M_OC7M5:   equ    %00100000
mTIM0_OC7M_OC7M6:   equ    %01000000
mTIM0_OC7M_OC7M7:   equ    %10000000


;*** TIM0_OC7D - TIM0 Output Compare 7 Data Register; 0x00000043 ***
TIM0_OC7D:          equ    $00000043                                ;*** TIM0_OC7D - TIM0 Output Compare 7 Data Register; 0x00000043 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TIM0_OC7D_OC7D4:    equ    4                                         ; Output Compare 7 Bit 4
TIM0_OC7D_OC7D5:    equ    5                                         ; Output Compare 7 Bit 5
TIM0_OC7D_OC7D6:    equ    6                                         ; Output Compare 7 Bit 6
TIM0_OC7D_OC7D7:    equ    7                                         ; Output Compare 7 Bit 7
; bit position masks
mTIM0_OC7D_OC7D4:   equ    %00010000
mTIM0_OC7D_OC7D5:   equ    %00100000
mTIM0_OC7D_OC7D6:   equ    %01000000
mTIM0_OC7D_OC7D7:   equ    %10000000


;*** TIM0_TCNT - TIM0 Timer Count Register; 0x00000044 ***
TIM0_TCNT:          equ    $00000044                                ;*** TIM0_TCNT - TIM0 Timer Count Register; 0x00000044 ***


;*** TIM0_TCNTHi - TIM0 Timer Count Register High; 0x00000044 ***
TIM0_TCNTHi:        equ    $00000044                                ;*** TIM0_TCNTHi - TIM0 Timer Count Register High; 0x00000044 ***


;*** TIM0_TCNTLo - TIM0 Timer Count Register Low; 0x00000045 ***
TIM0_TCNTLo:        equ    $00000045                                ;*** TIM0_TCNTLo - TIM0 Timer Count Register Low; 0x00000045 ***


;*** TIM0_TSCR1 - TIM0 Timer System Control Register1; 0x00000046 ***
TIM0_TSCR1:         equ    $00000046                                ;*** TIM0_TSCR1 - TIM0 Timer System Control Register1; 0x00000046 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TIM0_TSCR1_TFFCA:   equ    4                                         ; Timer Fast Flag Clear All
TIM0_TSCR1_TSFRZ:   equ    5                                         ; Timer and Modulus Counter Stop While in Freeze Mode
TIM0_TSCR1_TSWAI:   equ    6                                         ; Timer Module Stops While in Wait
TIM0_TSCR1_TEN:     equ    7                                         ; Timer Enable
; bit position masks
mTIM0_TSCR1_TFFCA:  equ    %00010000
mTIM0_TSCR1_TSFRZ:  equ    %00100000
mTIM0_TSCR1_TSWAI:  equ    %01000000
mTIM0_TSCR1_TEN:    equ    %10000000


;*** TIM0_TTOV - TIM0 Timer Toggle On Overflow Register; 0x00000047 ***
TIM0_TTOV:          equ    $00000047                                ;*** TIM0_TTOV - TIM0 Timer Toggle On Overflow Register; 0x00000047 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TIM0_TTOV_TOV4:     equ    4                                         ; Toggle On Overflow Bit 4
TIM0_TTOV_TOV5:     equ    5                                         ; Toggle On Overflow Bit 5
TIM0_TTOV_TOV6:     equ    6                                         ; Toggle On Overflow Bit 6
TIM0_TTOV_TOV7:     equ    7                                         ; Toggle On Overflow Bit 7
; bit position masks
mTIM0_TTOV_TOV4:    equ    %00010000
mTIM0_TTOV_TOV5:    equ    %00100000
mTIM0_TTOV_TOV6:    equ    %01000000
mTIM0_TTOV_TOV7:    equ    %10000000


;*** TIM0_TCTL1 - TIM0 Timer Control Register 1; 0x00000048 ***
TIM0_TCTL1:         equ    $00000048                                ;*** TIM0_TCTL1 - TIM0 Timer Control Register 1; 0x00000048 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TIM0_TCTL1_OL4:     equ    0                                         ; Output Level Bit 4
TIM0_TCTL1_OM4:     equ    1                                         ; Output Mode Bit 4
TIM0_TCTL1_OL5:     equ    2                                         ; Output Level Bit 5
TIM0_TCTL1_OM5:     equ    3                                         ; Output Mode Bit 5
TIM0_TCTL1_OL6:     equ    4                                         ; Output Level Bit 6
TIM0_TCTL1_OM6:     equ    5                                         ; Output Mode Bit 6
TIM0_TCTL1_OL7:     equ    6                                         ; Output Level Bit 7
TIM0_TCTL1_OM7:     equ    7                                         ; Output Mode Bit 7
; bit position masks
mTIM0_TCTL1_OL4:    equ    %00000001
mTIM0_TCTL1_OM4:    equ    %00000010
mTIM0_TCTL1_OL5:    equ    %00000100
mTIM0_TCTL1_OM5:    equ    %00001000
mTIM0_TCTL1_OL6:    equ    %00010000
mTIM0_TCTL1_OM6:    equ    %00100000
mTIM0_TCTL1_OL7:    equ    %01000000
mTIM0_TCTL1_OM7:    equ    %10000000


;*** TIM0_TCTL3 - TIM0 Timer Control Register 3; 0x0000004A ***
TIM0_TCTL3:         equ    $0000004A                                ;*** TIM0_TCTL3 - TIM0 Timer Control Register 3; 0x0000004A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TIM0_TCTL3_EDG4A:   equ    0                                         ; Input Capture Edge Control 4A
TIM0_TCTL3_EDG4B:   equ    1                                         ; Input Capture Edge Control 4B
TIM0_TCTL3_EDG5A:   equ    2                                         ; Input Capture Edge Control 5A
TIM0_TCTL3_EDG5B:   equ    3                                         ; Input Capture Edge Control 5B
TIM0_TCTL3_EDG6A:   equ    4                                         ; Input Capture Edge Control 6A
TIM0_TCTL3_EDG6B:   equ    5                                         ; Input Capture Edge Control 6B
TIM0_TCTL3_EDG7A:   equ    6                                         ; Input Capture Edge Control 7A
TIM0_TCTL3_EDG7B:   equ    7                                         ; Input Capture Edge Control 7B
; bit position masks
mTIM0_TCTL3_EDG4A:  equ    %00000001
mTIM0_TCTL3_EDG4B:  equ    %00000010
mTIM0_TCTL3_EDG5A:  equ    %00000100
mTIM0_TCTL3_EDG5B:  equ    %00001000
mTIM0_TCTL3_EDG6A:  equ    %00010000
mTIM0_TCTL3_EDG6B:  equ    %00100000
mTIM0_TCTL3_EDG7A:  equ    %01000000
mTIM0_TCTL3_EDG7B:  equ    %10000000


;*** TIM0_TIE - TIM0 Timer Interrupt Enable Register; 0x0000004C ***
TIM0_TIE:           equ    $0000004C                                ;*** TIM0_TIE - TIM0 Timer Interrupt Enable Register; 0x0000004C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TIM0_TIE_C4I:       equ    4                                         ; Input Capture/Output Compare Interrupt Enable Bit 4
TIM0_TIE_C5I:       equ    5                                         ; Input Capture/Output Compare Interrupt Enable Bit 5
TIM0_TIE_C6I:       equ    6                                         ; Input Capture/Output Compare Interrupt Enable Bit 6
TIM0_TIE_C7I:       equ    7                                         ; Input Capture/Output Compare Interrupt Enable Bit 7
; bit position masks
mTIM0_TIE_C4I:      equ    %00010000
mTIM0_TIE_C5I:      equ    %00100000
mTIM0_TIE_C6I:      equ    %01000000
mTIM0_TIE_C7I:      equ    %10000000


;*** TIM0_TSCR2 - TIM0 Timer System Control Register 2; 0x0000004D ***
TIM0_TSCR2:         equ    $0000004D                                ;*** TIM0_TSCR2 - TIM0 Timer System Control Register 2; 0x0000004D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TIM0_TSCR2_PR0:     equ    0                                         ; Timer Prescaler Select Bit 0
TIM0_TSCR2_PR1:     equ    1                                         ; Timer Prescaler Select Bit 1
TIM0_TSCR2_PR2:     equ    2                                         ; Timer Prescaler Select Bit 2
TIM0_TSCR2_TCRE:    equ    3                                         ; Timer Counter Reset Enable
TIM0_TSCR2_TOI:     equ    7                                         ; Timer Overflow Interrupt Enable
; bit position masks
mTIM0_TSCR2_PR0:    equ    %00000001
mTIM0_TSCR2_PR1:    equ    %00000010
mTIM0_TSCR2_PR2:    equ    %00000100
mTIM0_TSCR2_TCRE:   equ    %00001000
mTIM0_TSCR2_TOI:    equ    %10000000


;*** TIM0_TFLG1 - TIM0 Main Timer Interrupt Flag 1; 0x0000004E ***
TIM0_TFLG1:         equ    $0000004E                                ;*** TIM0_TFLG1 - TIM0 Main Timer Interrupt Flag 1; 0x0000004E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TIM0_TFLG1_C4F:     equ    4                                         ; Input Capture/Output Compare Channel Flag 4
TIM0_TFLG1_C5F:     equ    5                                         ; Input Capture/Output Compare Channel Flag 5
TIM0_TFLG1_C6F:     equ    6                                         ; Input Capture/Output Compare Channel Flag 6
TIM0_TFLG1_C7F:     equ    7                                         ; Input Capture/Output Compare Channel Flag 7
; bit position masks
mTIM0_TFLG1_C4F:    equ    %00010000
mTIM0_TFLG1_C5F:    equ    %00100000
mTIM0_TFLG1_C6F:    equ    %01000000
mTIM0_TFLG1_C7F:    equ    %10000000


;*** TIM0_TFLG2 - TIM0 Main Timer Interrupt Flag 2; 0x0000004F ***
TIM0_TFLG2:         equ    $0000004F                                ;*** TIM0_TFLG2 - TIM0 Main Timer Interrupt Flag 2; 0x0000004F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TIM0_TFLG2_TOF:     equ    7                                         ; Timer Overflow Flag
; bit position masks
mTIM0_TFLG2_TOF:    equ    %10000000


;*** TIM0_TC4 - TIM0 Timer Input Capture/Output Compare Register 4; 0x00000058 ***
TIM0_TC4:           equ    $00000058                                ;*** TIM0_TC4 - TIM0 Timer Input Capture/Output Compare Register 4; 0x00000058 ***


;*** TIM0_TC4Hi - TIM0 Timer Input Capture/Output Compare Register 4 High; 0x00000058 ***
TIM0_TC4Hi:         equ    $00000058                                ;*** TIM0_TC4Hi - TIM0 Timer Input Capture/Output Compare Register 4 High; 0x00000058 ***


;*** TIM0_TC4Lo - TIM0 Timer Input Capture/Output Compare Register 4 Low; 0x00000059 ***
TIM0_TC4Lo:         equ    $00000059                                ;*** TIM0_TC4Lo - TIM0 Timer Input Capture/Output Compare Register 4 Low; 0x00000059 ***


;*** TIM0_TC5 - TIM0 Timer Input Capture/Output Compare Register 5; 0x0000005A ***
TIM0_TC5:           equ    $0000005A                                ;*** TIM0_TC5 - TIM0 Timer Input Capture/Output Compare Register 5; 0x0000005A ***


;*** TIM0_TC5Hi - TIM0 Timer Input Capture/Output Compare Register 5 High; 0x0000005A ***
TIM0_TC5Hi:         equ    $0000005A                                ;*** TIM0_TC5Hi - TIM0 Timer Input Capture/Output Compare Register 5 High; 0x0000005A ***


;*** TIM0_TC5Lo - TIM0 Timer Input Capture/Output Compare Register 5 Low; 0x0000005B ***
TIM0_TC5Lo:         equ    $0000005B                                ;*** TIM0_TC5Lo - TIM0 Timer Input Capture/Output Compare Register 5 Low; 0x0000005B ***


;*** TIM0_TC6 - TIM0 Timer Input Capture/Output Compare Register 6; 0x0000005C ***
TIM0_TC6:           equ    $0000005C                                ;*** TIM0_TC6 - TIM0 Timer Input Capture/Output Compare Register 6; 0x0000005C ***


;*** TIM0_TC6Hi - TIM0 Timer Input Capture/Output Compare Register 6 High; 0x0000005C ***
TIM0_TC6Hi:         equ    $0000005C                                ;*** TIM0_TC6Hi - TIM0 Timer Input Capture/Output Compare Register 6 High; 0x0000005C ***


;*** TIM0_TC6Lo - TIM0 Timer Input Capture/Output Compare Register 6 Low; 0x0000005D ***
TIM0_TC6Lo:         equ    $0000005D                                ;*** TIM0_TC6Lo - TIM0 Timer Input Capture/Output Compare Register 6 Low; 0x0000005D ***


;*** TIM0_TC7 - TIM0 Timer Input Capture/Output Compare Register 7; 0x0000005E ***
TIM0_TC7:           equ    $0000005E                                ;*** TIM0_TC7 - TIM0 Timer Input Capture/Output Compare Register 7; 0x0000005E ***


;*** TIM0_TC7Hi - TIM0 Timer Input Capture/Output Compare Register 7 High; 0x0000005E ***
TIM0_TC7Hi:         equ    $0000005E                                ;*** TIM0_TC7Hi - TIM0 Timer Input Capture/Output Compare Register 7 High; 0x0000005E ***


;*** TIM0_TC7Lo - TIM0 Timer Input Capture/Output Compare Register 7 Low; 0x0000005F ***
TIM0_TC7Lo:         equ    $0000005F                                ;*** TIM0_TC7Lo - TIM0 Timer Input Capture/Output Compare Register 7 Low; 0x0000005F ***


;*** TIM0_PACTL - TIM0 16-Bit Pulse Accumulator A Control Register; 0x00000060 ***
TIM0_PACTL:         equ    $00000060                                ;*** TIM0_PACTL - TIM0 16-Bit Pulse Accumulator A Control Register; 0x00000060 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TIM0_PACTL_PAI:     equ    0                                         ; Pulse Accumulator Input Interrupt enable
TIM0_PACTL_PAOVI:   equ    1                                         ; Pulse Accumulator A Overflow Interrupt enable
TIM0_PACTL_CLK0:    equ    2                                         ; Clock Select Bit 0
TIM0_PACTL_CLK1:    equ    3                                         ; Clock Select Bit 1
TIM0_PACTL_PEDGE:   equ    4                                         ; Pulse Accumulator Edge Control
TIM0_PACTL_PAMOD:   equ    5                                         ; Pulse Accumulator Mode
TIM0_PACTL_PAEN:    equ    6                                         ; Pulse Accumulator A System Enable
; bit position masks
mTIM0_PACTL_PAI:    equ    %00000001
mTIM0_PACTL_PAOVI:  equ    %00000010
mTIM0_PACTL_CLK0:   equ    %00000100
mTIM0_PACTL_CLK1:   equ    %00001000
mTIM0_PACTL_PEDGE:  equ    %00010000
mTIM0_PACTL_PAMOD:  equ    %00100000
mTIM0_PACTL_PAEN:   equ    %01000000


;*** TIM0_PAFLG - TIM0 Pulse Accumulator A Flag Register; 0x00000061 ***
TIM0_PAFLG:         equ    $00000061                                ;*** TIM0_PAFLG - TIM0 Pulse Accumulator A Flag Register; 0x00000061 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TIM0_PAFLG_PAIF:    equ    0                                         ; Pulse Accumulator Input edge Flag
TIM0_PAFLG_PAOVF:   equ    1                                         ; Pulse Accumulator A Overflow Flag
; bit position masks
mTIM0_PAFLG_PAIF:   equ    %00000001
mTIM0_PAFLG_PAOVF:  equ    %00000010


;*** TIM0_PACNT - TIM0 Pulse Accumulators Count Register; 0x00000062 ***
TIM0_PACNT:         equ    $00000062                                ;*** TIM0_PACNT - TIM0 Pulse Accumulators Count Register; 0x00000062 ***


;*** ATDCTL23 - ATD Control Register 23; 0x00000082 ***
ATDCTL23:           equ    $00000082                                ;*** ATDCTL23 - ATD Control Register 23; 0x00000082 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDCTL23_FRZ0:      equ    0                                         ; Background Debug Freeze Enable Bit 0
ATDCTL23_FRZ1:      equ    1                                         ; Background Debug Freeze Enable Bit 1
ATDCTL23_FIFO:      equ    2                                         ; Result Register FIFO Mode
ATDCTL23_S1C:       equ    3                                         ; Conversion Sequence Length 1
ATDCTL23_S2C:       equ    4                                         ; Conversion Sequence Length 2
ATDCTL23_S4C:       equ    5                                         ; Conversion Sequence Length 4
ATDCTL23_S8C:       equ    6                                         ; Conversion Sequence Length 8
ATDCTL23_ASCIF:     equ    8                                         ; ATD Sequence Complete Interrupt Flag
ATDCTL23_ASCIE:     equ    9                                         ; ATD Sequence Complete Interrupt Enable
ATDCTL23_ETRIGE:    equ    10                                        ; External Trigger Mode enable
ATDCTL23_ETRIGP:    equ    11                                        ; External Trigger Polarity
ATDCTL23_ETRIGLE:   equ    12                                        ; External Trigger Level/Edge control
ATDCTL23_AWAI:      equ    13                                        ; ATD Power Down in Wait Mode
ATDCTL23_AFFC:      equ    14                                        ; ATD Fast Conversion Complete Flag Clear
ATDCTL23_ADPU:      equ    15                                        ; ATD Disable / Power Down
; bit position masks
mATDCTL23_FRZ0:     equ    %00000001
mATDCTL23_FRZ1:     equ    %00000010
mATDCTL23_FIFO:     equ    %00000100
mATDCTL23_S1C:      equ    %00001000
mATDCTL23_S2C:      equ    %00010000
mATDCTL23_S4C:      equ    %00100000
mATDCTL23_S8C:      equ    %01000000
mATDCTL23_ASCIF:    equ    %100000000
mATDCTL23_ASCIE:    equ    %1000000000
mATDCTL23_ETRIGE:   equ    %10000000000
mATDCTL23_ETRIGP:   equ    %100000000000
mATDCTL23_ETRIGLE:  equ    %1000000000000
mATDCTL23_AWAI:     equ    %10000000000000
mATDCTL23_AFFC:     equ    %100000000000000
mATDCTL23_ADPU:     equ    %1000000000000000


;*** ATDCTL2 - ATD Control Register 2; 0x00000082 ***
ATDCTL2:            equ    $00000082                                ;*** ATDCTL2 - ATD Control Register 2; 0x00000082 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDCTL2_ASCIF:      equ    0                                         ; ATD Sequence Complete Interrupt Flag
ATDCTL2_ASCIE:      equ    1                                         ; ATD Sequence Complete Interrupt Enable
ATDCTL2_ETRIGE:     equ    2                                         ; External Trigger Mode enable
ATDCTL2_ETRIGP:     equ    3                                         ; External Trigger Polarity
ATDCTL2_ETRIGLE:    equ    4                                         ; External Trigger Level/Edge control
ATDCTL2_AWAI:       equ    5                                         ; ATD Power Down in Wait Mode
ATDCTL2_AFFC:       equ    6                                         ; ATD Fast Conversion Complete Flag Clear
ATDCTL2_ADPU:       equ    7                                         ; ATD Disable / Power Down
; bit position masks
mATDCTL2_ASCIF:     equ    %00000001
mATDCTL2_ASCIE:     equ    %00000010
mATDCTL2_ETRIGE:    equ    %00000100
mATDCTL2_ETRIGP:    equ    %00001000
mATDCTL2_ETRIGLE:   equ    %00010000
mATDCTL2_AWAI:      equ    %00100000
mATDCTL2_AFFC:      equ    %01000000
mATDCTL2_ADPU:      equ    %10000000


;*** ATDCTL3 - ATD Control Register 3; 0x00000083 ***
ATDCTL3:            equ    $00000083                                ;*** ATDCTL3 - ATD Control Register 3; 0x00000083 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDCTL3_FRZ0:       equ    0                                         ; Background Debug Freeze Enable Bit 0
ATDCTL3_FRZ1:       equ    1                                         ; Background Debug Freeze Enable Bit 1
ATDCTL3_FIFO:       equ    2                                         ; Result Register FIFO Mode
ATDCTL3_S1C:        equ    3                                         ; Conversion Sequence Length 1
ATDCTL3_S2C:        equ    4                                         ; Conversion Sequence Length 2
ATDCTL3_S4C:        equ    5                                         ; Conversion Sequence Length 4
ATDCTL3_S8C:        equ    6                                         ; Conversion Sequence Length 8
; bit position masks
mATDCTL3_FRZ0:      equ    %00000001
mATDCTL3_FRZ1:      equ    %00000010
mATDCTL3_FIFO:      equ    %00000100
mATDCTL3_S1C:       equ    %00001000
mATDCTL3_S2C:       equ    %00010000
mATDCTL3_S4C:       equ    %00100000
mATDCTL3_S8C:       equ    %01000000


;*** ATDCTL45 - ATD Control Register 45; 0x00000084 ***
ATDCTL45:           equ    $00000084                                ;*** ATDCTL45 - ATD Control Register 45; 0x00000084 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDCTL45_CA:        equ    0                                         ; Analog Input Channel Select Code A
ATDCTL45_CB:        equ    1                                         ; Analog Input Channel Select Code B
ATDCTL45_CC:        equ    2                                         ; Analog Input Channel Select Code C
ATDCTL45_CD:        equ    3                                         ; Analog Input Channel Select Code D
ATDCTL45_MULT:      equ    4                                         ; Multi-Channel Sample Mode
ATDCTL45_SCAN:      equ    5                                         ; Continuous Conversion Sequence Mode
ATDCTL45_DSGN:      equ    6                                         ; Signed/Unsigned Result Data Mode
ATDCTL45_DJM:       equ    7                                         ; Result Register Data Justification Mode
ATDCTL45_PRS0:      equ    8                                         ; ATD Clock Prescaler 0
ATDCTL45_PRS1:      equ    9                                         ; ATD Clock Prescaler 1
ATDCTL45_PRS2:      equ    10                                        ; ATD Clock Prescaler 2
ATDCTL45_PRS3:      equ    11                                        ; ATD Clock Prescaler 3
ATDCTL45_PRS4:      equ    12                                        ; ATD Clock Prescaler 4
ATDCTL45_SMP0:      equ    13                                        ; Sample Time Select 0
ATDCTL45_SMP1:      equ    14                                        ; Sample Time Select 1
ATDCTL45_SRES8:     equ    15                                        ; ATD Resolution Select
; bit position masks
mATDCTL45_CA:       equ    %00000001
mATDCTL45_CB:       equ    %00000010
mATDCTL45_CC:       equ    %00000100
mATDCTL45_CD:       equ    %00001000
mATDCTL45_MULT:     equ    %00010000
mATDCTL45_SCAN:     equ    %00100000
mATDCTL45_DSGN:     equ    %01000000
mATDCTL45_DJM:      equ    %10000000
mATDCTL45_PRS0:     equ    %100000000
mATDCTL45_PRS1:     equ    %1000000000
mATDCTL45_PRS2:     equ    %10000000000
mATDCTL45_PRS3:     equ    %100000000000
mATDCTL45_PRS4:     equ    %1000000000000
mATDCTL45_SMP0:     equ    %10000000000000
mATDCTL45_SMP1:     equ    %100000000000000
mATDCTL45_SRES8:    equ    %1000000000000000


;*** ATDCTL4 - ATD Control Register 4; 0x00000084 ***
ATDCTL4:            equ    $00000084                                ;*** ATDCTL4 - ATD Control Register 4; 0x00000084 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDCTL4_PRS0:       equ    0                                         ; ATD Clock Prescaler 0
ATDCTL4_PRS1:       equ    1                                         ; ATD Clock Prescaler 1
ATDCTL4_PRS2:       equ    2                                         ; ATD Clock Prescaler 2
ATDCTL4_PRS3:       equ    3                                         ; ATD Clock Prescaler 3
ATDCTL4_PRS4:       equ    4                                         ; ATD Clock Prescaler 4
ATDCTL4_SMP0:       equ    5                                         ; Sample Time Select 0
ATDCTL4_SMP1:       equ    6                                         ; Sample Time Select 1
ATDCTL4_SRES8:      equ    7                                         ; ATD Resolution Select
; bit position masks
mATDCTL4_PRS0:      equ    %00000001
mATDCTL4_PRS1:      equ    %00000010
mATDCTL4_PRS2:      equ    %00000100
mATDCTL4_PRS3:      equ    %00001000
mATDCTL4_PRS4:      equ    %00010000
mATDCTL4_SMP0:      equ    %00100000
mATDCTL4_SMP1:      equ    %01000000
mATDCTL4_SRES8:     equ    %10000000


;*** ATDCTL5 - ATD Control Register 5; 0x00000085 ***
ATDCTL5:            equ    $00000085                                ;*** ATDCTL5 - ATD Control Register 5; 0x00000085 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDCTL5_CA:         equ    0                                         ; Analog Input Channel Select Code A
ATDCTL5_CB:         equ    1                                         ; Analog Input Channel Select Code B
ATDCTL5_CC:         equ    2                                         ; Analog Input Channel Select Code C
ATDCTL5_CD:         equ    3                                         ; Analog Input Channel Select Code D
ATDCTL5_MULT:       equ    4                                         ; Multi-Channel Sample Mode
ATDCTL5_SCAN:       equ    5                                         ; Continuous Conversion Sequence Mode
ATDCTL5_DSGN:       equ    6                                         ; Signed/Unsigned Result Data Mode
ATDCTL5_DJM:        equ    7                                         ; Result Register Data Justification Mode
; bit position masks
mATDCTL5_CA:        equ    %00000001
mATDCTL5_CB:        equ    %00000010
mATDCTL5_CC:        equ    %00000100
mATDCTL5_CD:        equ    %00001000
mATDCTL5_MULT:      equ    %00010000
mATDCTL5_SCAN:      equ    %00100000
mATDCTL5_DSGN:      equ    %01000000
mATDCTL5_DJM:       equ    %10000000


;*** ATDSTAT0 - ATD Status Register 0; 0x00000086 ***
ATDSTAT0:           equ    $00000086                                ;*** ATDSTAT0 - ATD Status Register 0; 0x00000086 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDSTAT0_CC0:       equ    0                                         ; Conversion Counter 0
ATDSTAT0_CC1:       equ    1                                         ; Conversion Counter 1
ATDSTAT0_CC2:       equ    2                                         ; Conversion Counter 2
ATDSTAT0_CC3:       equ    3                                         ; Conversion Counter 3
ATDSTAT0_FIFOR:     equ    4                                         ; FIFO Over Run Flag
ATDSTAT0_ETORF:     equ    5                                         ; External Trigger Overrun Flag
ATDSTAT0_SCF:       equ    7                                         ; Sequence Complete Flag
; bit position masks
mATDSTAT0_CC0:      equ    %00000001
mATDSTAT0_CC1:      equ    %00000010
mATDSTAT0_CC2:      equ    %00000100
mATDSTAT0_CC3:      equ    %00001000
mATDSTAT0_FIFOR:    equ    %00010000
mATDSTAT0_ETORF:    equ    %00100000
mATDSTAT0_SCF:      equ    %10000000


;*** ATDTEST1 - ATD Test Register; 0x00000089 ***
ATDTEST1:           equ    $00000089                                ;*** ATDTEST1 - ATD Test Register; 0x00000089 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDTEST1_SC:        equ    0                                         ; Special Channel Conversion Bit
; bit position masks
mATDTEST1_SC:       equ    %00000001


;*** ATDSTAT2 - ATD Status Register 2; 0x0000008A ***
ATDSTAT2:           equ    $0000008A                                ;*** ATDSTAT2 - ATD Status Register 2; 0x0000008A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDSTAT2_CCF8:      equ    0                                         ; Conversion Complete Flag 8
ATDSTAT2_CCF9:      equ    1                                         ; Conversion Complete Flag 9
ATDSTAT2_CCF10:     equ    2                                         ; Conversion Complete Flag 10
ATDSTAT2_CCF11:     equ    3                                         ; Conversion Complete Flag 11
ATDSTAT2_CCF12:     equ    4                                         ; Conversion Complete Flag 12
ATDSTAT2_CCF13:     equ    5                                         ; Conversion Complete Flag 13
ATDSTAT2_CCF14:     equ    6                                         ; Conversion Complete Flag 14
ATDSTAT2_CCF15:     equ    7                                         ; Conversion Complete Flag 15
; bit position masks
mATDSTAT2_CCF8:     equ    %00000001
mATDSTAT2_CCF9:     equ    %00000010
mATDSTAT2_CCF10:    equ    %00000100
mATDSTAT2_CCF11:    equ    %00001000
mATDSTAT2_CCF12:    equ    %00010000
mATDSTAT2_CCF13:    equ    %00100000
mATDSTAT2_CCF14:    equ    %01000000
mATDSTAT2_CCF15:    equ    %10000000


;*** ATDSTAT1 - ATD Status Register 1; 0x0000008B ***
ATDSTAT1:           equ    $0000008B                                ;*** ATDSTAT1 - ATD Status Register 1; 0x0000008B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDSTAT1_CCF0:      equ    0                                         ; Conversion Complete Flag 0
ATDSTAT1_CCF1:      equ    1                                         ; Conversion Complete Flag 1
ATDSTAT1_CCF2:      equ    2                                         ; Conversion Complete Flag 2
ATDSTAT1_CCF3:      equ    3                                         ; Conversion Complete Flag 3
ATDSTAT1_CCF4:      equ    4                                         ; Conversion Complete Flag 4
ATDSTAT1_CCF5:      equ    5                                         ; Conversion Complete Flag 5
ATDSTAT1_CCF6:      equ    6                                         ; Conversion Complete Flag 6
ATDSTAT1_CCF7:      equ    7                                         ; Conversion Complete Flag 7
; bit position masks
mATDSTAT1_CCF0:     equ    %00000001
mATDSTAT1_CCF1:     equ    %00000010
mATDSTAT1_CCF2:     equ    %00000100
mATDSTAT1_CCF3:     equ    %00001000
mATDSTAT1_CCF4:     equ    %00010000
mATDSTAT1_CCF5:     equ    %00100000
mATDSTAT1_CCF6:     equ    %01000000
mATDSTAT1_CCF7:     equ    %10000000


;*** ATDDIEN - ATD Input Enable Register; 0x0000008C ***
ATDDIEN:            equ    $0000008C                                ;*** ATDDIEN - ATD Input Enable Register; 0x0000008C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDIEN_IEN0:       equ    0                                         ; ATD Digital Input Enable on channel 0
ATDDIEN_IEN1:       equ    1                                         ; ATD Digital Input Enable on channel 1
ATDDIEN_IEN2:       equ    2                                         ; ATD Digital Input Enable on channel 2
ATDDIEN_IEN3:       equ    3                                         ; ATD Digital Input Enable on channel 3
ATDDIEN_IEN4:       equ    4                                         ; ATD Digital Input Enable on channel 4
ATDDIEN_IEN5:       equ    5                                         ; ATD Digital Input Enable on channel 5
ATDDIEN_IEN6:       equ    6                                         ; ATD Digital Input Enable on channel 6
ATDDIEN_IEN7:       equ    7                                         ; ATD Digital Input Enable on channel 7
ATDDIEN_IEN8:       equ    8                                         ; ATD Digital Input Enable on channel 8
ATDDIEN_IEN9:       equ    9                                         ; ATD Digital Input Enable on channel 9
ATDDIEN_IEN10:      equ    10                                        ; ATD Digital Input Enable on channel 10
ATDDIEN_IEN11:      equ    11                                        ; ATD Digital Input Enable on channel 11
ATDDIEN_IEN12:      equ    12                                        ; ATD Digital Input Enable on channel 12
ATDDIEN_IEN13:      equ    13                                        ; ATD Digital Input Enable on channel 13
ATDDIEN_IEN14:      equ    14                                        ; ATD Digital Input Enable on channel 14
ATDDIEN_IEN15:      equ    15                                        ; ATD Digital Input Enable on channel 15
; bit position masks
mATDDIEN_IEN0:      equ    %00000001
mATDDIEN_IEN1:      equ    %00000010
mATDDIEN_IEN2:      equ    %00000100
mATDDIEN_IEN3:      equ    %00001000
mATDDIEN_IEN4:      equ    %00010000
mATDDIEN_IEN5:      equ    %00100000
mATDDIEN_IEN6:      equ    %01000000
mATDDIEN_IEN7:      equ    %10000000
mATDDIEN_IEN8:      equ    %100000000
mATDDIEN_IEN9:      equ    %1000000000
mATDDIEN_IEN10:     equ    %10000000000
mATDDIEN_IEN11:     equ    %100000000000
mATDDIEN_IEN12:     equ    %1000000000000
mATDDIEN_IEN13:     equ    %10000000000000
mATDDIEN_IEN14:     equ    %100000000000000
mATDDIEN_IEN15:     equ    %1000000000000000


;*** ATDDIEN0 - ATD Input Enable Register 0; 0x0000008C ***
ATDDIEN0:           equ    $0000008C                                ;*** ATDDIEN0 - ATD Input Enable Register 0; 0x0000008C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDIEN0_IEN8:      equ    0                                         ; ATD Digital Input Enable on channel 8
ATDDIEN0_IEN9:      equ    1                                         ; ATD Digital Input Enable on channel 9
ATDDIEN0_IEN10:     equ    2                                         ; ATD Digital Input Enable on channel 10
ATDDIEN0_IEN11:     equ    3                                         ; ATD Digital Input Enable on channel 11
ATDDIEN0_IEN12:     equ    4                                         ; ATD Digital Input Enable on channel 12
ATDDIEN0_IEN13:     equ    5                                         ; ATD Digital Input Enable on channel 13
ATDDIEN0_IEN14:     equ    6                                         ; ATD Digital Input Enable on channel 14
ATDDIEN0_IEN15:     equ    7                                         ; ATD Digital Input Enable on channel 15
; bit position masks
mATDDIEN0_IEN8:     equ    %00000001
mATDDIEN0_IEN9:     equ    %00000010
mATDDIEN0_IEN10:    equ    %00000100
mATDDIEN0_IEN11:    equ    %00001000
mATDDIEN0_IEN12:    equ    %00010000
mATDDIEN0_IEN13:    equ    %00100000
mATDDIEN0_IEN14:    equ    %01000000
mATDDIEN0_IEN15:    equ    %10000000


;*** ATDDIEN1 - ATD Input Enable Register 1; 0x0000008D ***
ATDDIEN1:           equ    $0000008D                                ;*** ATDDIEN1 - ATD Input Enable Register 1; 0x0000008D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDIEN1_IEN0:      equ    0                                         ; ATD Digital Input Enable on channel 0
ATDDIEN1_IEN1:      equ    1                                         ; ATD Digital Input Enable on channel 1
ATDDIEN1_IEN2:      equ    2                                         ; ATD Digital Input Enable on channel 2
ATDDIEN1_IEN3:      equ    3                                         ; ATD Digital Input Enable on channel 3
ATDDIEN1_IEN4:      equ    4                                         ; ATD Digital Input Enable on channel 4
ATDDIEN1_IEN5:      equ    5                                         ; ATD Digital Input Enable on channel 5
ATDDIEN1_IEN6:      equ    6                                         ; ATD Digital Input Enable on channel 6
ATDDIEN1_IEN7:      equ    7                                         ; ATD Digital Input Enable on channel 7
; bit position masks
mATDDIEN1_IEN0:     equ    %00000001
mATDDIEN1_IEN1:     equ    %00000010
mATDDIEN1_IEN2:     equ    %00000100
mATDDIEN1_IEN3:     equ    %00001000
mATDDIEN1_IEN4:     equ    %00010000
mATDDIEN1_IEN5:     equ    %00100000
mATDDIEN1_IEN6:     equ    %01000000
mATDDIEN1_IEN7:     equ    %10000000


;*** PORTAD0 - Port AD0 Register; 0x0000008E ***
PORTAD0:            equ    $0000008E                                ;*** PORTAD0 - Port AD0 Register; 0x0000008E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PORTAD0_PTAD8:      equ    0                                         ; Port AD Bit 8
PORTAD0_PTAD9:      equ    1                                         ; Port AD Bit 9
PORTAD0_PTAD10:     equ    2                                         ; Port AD Bit 10
PORTAD0_PTAD11:     equ    3                                         ; Port AD Bit 11
PORTAD0_PTAD12:     equ    4                                         ; Port AD Bit 12
PORTAD0_PTAD13:     equ    5                                         ; Port AD Bit 13
PORTAD0_PTAD14:     equ    6                                         ; Port AD Bit 14
PORTAD0_PTAD15:     equ    7                                         ; Port AD Bit 15
; bit position masks
mPORTAD0_PTAD8:     equ    %00000001
mPORTAD0_PTAD9:     equ    %00000010
mPORTAD0_PTAD10:    equ    %00000100
mPORTAD0_PTAD11:    equ    %00001000
mPORTAD0_PTAD12:    equ    %00010000
mPORTAD0_PTAD13:    equ    %00100000
mPORTAD0_PTAD14:    equ    %01000000
mPORTAD0_PTAD15:    equ    %10000000


;*** PORTAD1 - Port AD1 Register; 0x0000008F ***
PORTAD1:            equ    $0000008F                                ;*** PORTAD1 - Port AD1 Register; 0x0000008F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PORTAD1_PTAD0:      equ    0                                         ; Port AD Bit 0
PORTAD1_PTAD1:      equ    1                                         ; Port AD Bit 1
PORTAD1_PTAD2:      equ    2                                         ; Port AD Bit 2
PORTAD1_PTAD3:      equ    3                                         ; Port AD Bit 3
PORTAD1_PTAD4:      equ    4                                         ; Port AD Bit 4
PORTAD1_PTAD5:      equ    5                                         ; Port AD Bit 5
PORTAD1_PTAD6:      equ    6                                         ; Port AD Bit 6
PORTAD1_PTAD7:      equ    7                                         ; Port AD Bit 7
; bit position masks
mPORTAD1_PTAD0:     equ    %00000001
mPORTAD1_PTAD1:     equ    %00000010
mPORTAD1_PTAD2:     equ    %00000100
mPORTAD1_PTAD3:     equ    %00001000
mPORTAD1_PTAD4:     equ    %00010000
mPORTAD1_PTAD5:     equ    %00100000
mPORTAD1_PTAD6:     equ    %01000000
mPORTAD1_PTAD7:     equ    %10000000


;*** ATDDR0 - ATD Conversion Result Register 0; 0x00000090 ***
ATDDR0:             equ    $00000090                                ;*** ATDDR0 - ATD Conversion Result Register 0; 0x00000090 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR0_BIT6:        equ    6                                         ; Bit 6
ATDDR0_BIT7:        equ    7                                         ; Bit 7
ATDDR0_BIT8:        equ    8                                         ; Bit 8
ATDDR0_BIT9:        equ    9                                         ; Bit 9
ATDDR0_BIT10:       equ    10                                        ; Bit 10
ATDDR0_BIT11:       equ    11                                        ; Bit 11
ATDDR0_BIT12:       equ    12                                        ; Bit 12
ATDDR0_BIT13:       equ    13                                        ; Bit 13
ATDDR0_BIT14:       equ    14                                        ; Bit 14
ATDDR0_BIT15:       equ    15                                        ; Bit 15
; bit position masks
mATDDR0_BIT6:       equ    %01000000
mATDDR0_BIT7:       equ    %10000000
mATDDR0_BIT8:       equ    %100000000
mATDDR0_BIT9:       equ    %1000000000
mATDDR0_BIT10:      equ    %10000000000
mATDDR0_BIT11:      equ    %100000000000
mATDDR0_BIT12:      equ    %1000000000000
mATDDR0_BIT13:      equ    %10000000000000
mATDDR0_BIT14:      equ    %100000000000000
mATDDR0_BIT15:      equ    %1000000000000000


;*** ATDDR0H - ATD Conversion Result Register 0 High; 0x00000090 ***
ATDDR0H:            equ    $00000090                                ;*** ATDDR0H - ATD Conversion Result Register 0 High; 0x00000090 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR0H_BIT8:       equ    0                                         ; Bit 8
ATDDR0H_BIT9:       equ    1                                         ; Bit 9
ATDDR0H_BIT10:      equ    2                                         ; Bit 10
ATDDR0H_BIT11:      equ    3                                         ; Bit 11
ATDDR0H_BIT12:      equ    4                                         ; Bit 12
ATDDR0H_BIT13:      equ    5                                         ; Bit 13
ATDDR0H_BIT14:      equ    6                                         ; Bit 14
ATDDR0H_BIT15:      equ    7                                         ; Bit 15
; bit position masks
mATDDR0H_BIT8:      equ    %00000001
mATDDR0H_BIT9:      equ    %00000010
mATDDR0H_BIT10:     equ    %00000100
mATDDR0H_BIT11:     equ    %00001000
mATDDR0H_BIT12:     equ    %00010000
mATDDR0H_BIT13:     equ    %00100000
mATDDR0H_BIT14:     equ    %01000000
mATDDR0H_BIT15:     equ    %10000000


;*** ATDDR0L - ATD Conversion Result Register 0 Low; 0x00000091 ***
ATDDR0L:            equ    $00000091                                ;*** ATDDR0L - ATD Conversion Result Register 0 Low; 0x00000091 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR0L_BIT6:       equ    6                                         ; Bit 6
ATDDR0L_BIT7:       equ    7                                         ; Bit 7
; bit position masks
mATDDR0L_BIT6:      equ    %01000000
mATDDR0L_BIT7:      equ    %10000000


;*** ATDDR1 - ATD Conversion Result Register 1; 0x00000092 ***
ATDDR1:             equ    $00000092                                ;*** ATDDR1 - ATD Conversion Result Register 1; 0x00000092 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR1_BIT6:        equ    6                                         ; Bit 6
ATDDR1_BIT7:        equ    7                                         ; Bit 7
ATDDR1_BIT8:        equ    8                                         ; Bit 8
ATDDR1_BIT9:        equ    9                                         ; Bit 9
ATDDR1_BIT10:       equ    10                                        ; Bit 10
ATDDR1_BIT11:       equ    11                                        ; Bit 11
ATDDR1_BIT12:       equ    12                                        ; Bit 12
ATDDR1_BIT13:       equ    13                                        ; Bit 13
ATDDR1_BIT14:       equ    14                                        ; Bit 14
ATDDR1_BIT15:       equ    15                                        ; Bit 15
; bit position masks
mATDDR1_BIT6:       equ    %01000000
mATDDR1_BIT7:       equ    %10000000
mATDDR1_BIT8:       equ    %100000000
mATDDR1_BIT9:       equ    %1000000000
mATDDR1_BIT10:      equ    %10000000000
mATDDR1_BIT11:      equ    %100000000000
mATDDR1_BIT12:      equ    %1000000000000
mATDDR1_BIT13:      equ    %10000000000000
mATDDR1_BIT14:      equ    %100000000000000
mATDDR1_BIT15:      equ    %1000000000000000


;*** ATDDR1H - ATD Conversion Result Register 1 High; 0x00000092 ***
ATDDR1H:            equ    $00000092                                ;*** ATDDR1H - ATD Conversion Result Register 1 High; 0x00000092 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR1H_BIT8:       equ    0                                         ; Bit 8
ATDDR1H_BIT9:       equ    1                                         ; Bit 9
ATDDR1H_BIT10:      equ    2                                         ; Bit 10
ATDDR1H_BIT11:      equ    3                                         ; Bit 11
ATDDR1H_BIT12:      equ    4                                         ; Bit 12
ATDDR1H_BIT13:      equ    5                                         ; Bit 13
ATDDR1H_BIT14:      equ    6                                         ; Bit 14
ATDDR1H_BIT15:      equ    7                                         ; Bit 15
; bit position masks
mATDDR1H_BIT8:      equ    %00000001
mATDDR1H_BIT9:      equ    %00000010
mATDDR1H_BIT10:     equ    %00000100
mATDDR1H_BIT11:     equ    %00001000
mATDDR1H_BIT12:     equ    %00010000
mATDDR1H_BIT13:     equ    %00100000
mATDDR1H_BIT14:     equ    %01000000
mATDDR1H_BIT15:     equ    %10000000


;*** ATDDR1L - ATD Conversion Result Register 1 Low; 0x00000093 ***
ATDDR1L:            equ    $00000093                                ;*** ATDDR1L - ATD Conversion Result Register 1 Low; 0x00000093 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR1L_BIT6:       equ    6                                         ; Bit 6
ATDDR1L_BIT7:       equ    7                                         ; Bit 7
; bit position masks
mATDDR1L_BIT6:      equ    %01000000
mATDDR1L_BIT7:      equ    %10000000


;*** ATDDR2 - ATD Conversion Result Register 2; 0x00000094 ***
ATDDR2:             equ    $00000094                                ;*** ATDDR2 - ATD Conversion Result Register 2; 0x00000094 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR2_BIT6:        equ    6                                         ; Bit 6
ATDDR2_BIT7:        equ    7                                         ; Bit 7
ATDDR2_BIT8:        equ    8                                         ; Bit 8
ATDDR2_BIT9:        equ    9                                         ; Bit 9
ATDDR2_BIT10:       equ    10                                        ; Bit 10
ATDDR2_BIT11:       equ    11                                        ; Bit 11
ATDDR2_BIT12:       equ    12                                        ; Bit 12
ATDDR2_BIT13:       equ    13                                        ; Bit 13
ATDDR2_BIT14:       equ    14                                        ; Bit 14
ATDDR2_BIT15:       equ    15                                        ; Bit 15
; bit position masks
mATDDR2_BIT6:       equ    %01000000
mATDDR2_BIT7:       equ    %10000000
mATDDR2_BIT8:       equ    %100000000
mATDDR2_BIT9:       equ    %1000000000
mATDDR2_BIT10:      equ    %10000000000
mATDDR2_BIT11:      equ    %100000000000
mATDDR2_BIT12:      equ    %1000000000000
mATDDR2_BIT13:      equ    %10000000000000
mATDDR2_BIT14:      equ    %100000000000000
mATDDR2_BIT15:      equ    %1000000000000000


;*** ATDDR2H - ATD Conversion Result Register 2 High; 0x00000094 ***
ATDDR2H:            equ    $00000094                                ;*** ATDDR2H - ATD Conversion Result Register 2 High; 0x00000094 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR2H_BIT8:       equ    0                                         ; Bit 8
ATDDR2H_BIT9:       equ    1                                         ; Bit 9
ATDDR2H_BIT10:      equ    2                                         ; Bit 10
ATDDR2H_BIT11:      equ    3                                         ; Bit 11
ATDDR2H_BIT12:      equ    4                                         ; Bit 12
ATDDR2H_BIT13:      equ    5                                         ; Bit 13
ATDDR2H_BIT14:      equ    6                                         ; Bit 14
ATDDR2H_BIT15:      equ    7                                         ; Bit 15
; bit position masks
mATDDR2H_BIT8:      equ    %00000001
mATDDR2H_BIT9:      equ    %00000010
mATDDR2H_BIT10:     equ    %00000100
mATDDR2H_BIT11:     equ    %00001000
mATDDR2H_BIT12:     equ    %00010000
mATDDR2H_BIT13:     equ    %00100000
mATDDR2H_BIT14:     equ    %01000000
mATDDR2H_BIT15:     equ    %10000000


;*** ATDDR2L - ATD Conversion Result Register 2 Low; 0x00000095 ***
ATDDR2L:            equ    $00000095                                ;*** ATDDR2L - ATD Conversion Result Register 2 Low; 0x00000095 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR2L_BIT6:       equ    6                                         ; Bit 6
ATDDR2L_BIT7:       equ    7                                         ; Bit 7
; bit position masks
mATDDR2L_BIT6:      equ    %01000000
mATDDR2L_BIT7:      equ    %10000000


;*** ATDDR3 - ATD Conversion Result Register 3; 0x00000096 ***
ATDDR3:             equ    $00000096                                ;*** ATDDR3 - ATD Conversion Result Register 3; 0x00000096 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR3_BIT6:        equ    6                                         ; Bit 6
ATDDR3_BIT7:        equ    7                                         ; Bit 7
ATDDR3_BIT8:        equ    8                                         ; Bit 8
ATDDR3_BIT9:        equ    9                                         ; Bit 9
ATDDR3_BIT10:       equ    10                                        ; Bit 10
ATDDR3_BIT11:       equ    11                                        ; Bit 11
ATDDR3_BIT12:       equ    12                                        ; Bit 12
ATDDR3_BIT13:       equ    13                                        ; Bit 13
ATDDR3_BIT14:       equ    14                                        ; Bit 14
ATDDR3_BIT15:       equ    15                                        ; Bit 15
; bit position masks
mATDDR3_BIT6:       equ    %01000000
mATDDR3_BIT7:       equ    %10000000
mATDDR3_BIT8:       equ    %100000000
mATDDR3_BIT9:       equ    %1000000000
mATDDR3_BIT10:      equ    %10000000000
mATDDR3_BIT11:      equ    %100000000000
mATDDR3_BIT12:      equ    %1000000000000
mATDDR3_BIT13:      equ    %10000000000000
mATDDR3_BIT14:      equ    %100000000000000
mATDDR3_BIT15:      equ    %1000000000000000


;*** ATDDR3H - ATD Conversion Result Register 3 High; 0x00000096 ***
ATDDR3H:            equ    $00000096                                ;*** ATDDR3H - ATD Conversion Result Register 3 High; 0x00000096 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR3H_BIT8:       equ    0                                         ; Bit 8
ATDDR3H_BIT9:       equ    1                                         ; Bit 9
ATDDR3H_BIT10:      equ    2                                         ; Bit 10
ATDDR3H_BIT11:      equ    3                                         ; Bit 11
ATDDR3H_BIT12:      equ    4                                         ; Bit 12
ATDDR3H_BIT13:      equ    5                                         ; Bit 13
ATDDR3H_BIT14:      equ    6                                         ; Bit 14
ATDDR3H_BIT15:      equ    7                                         ; Bit 15
; bit position masks
mATDDR3H_BIT8:      equ    %00000001
mATDDR3H_BIT9:      equ    %00000010
mATDDR3H_BIT10:     equ    %00000100
mATDDR3H_BIT11:     equ    %00001000
mATDDR3H_BIT12:     equ    %00010000
mATDDR3H_BIT13:     equ    %00100000
mATDDR3H_BIT14:     equ    %01000000
mATDDR3H_BIT15:     equ    %10000000


;*** ATDDR3L - ATD Conversion Result Register 3 Low; 0x00000097 ***
ATDDR3L:            equ    $00000097                                ;*** ATDDR3L - ATD Conversion Result Register 3 Low; 0x00000097 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR3L_BIT6:       equ    6                                         ; Bit 6
ATDDR3L_BIT7:       equ    7                                         ; Bit 7
; bit position masks
mATDDR3L_BIT6:      equ    %01000000
mATDDR3L_BIT7:      equ    %10000000


;*** ATDDR4 - ATD Conversion Result Register 4; 0x00000098 ***
ATDDR4:             equ    $00000098                                ;*** ATDDR4 - ATD Conversion Result Register 4; 0x00000098 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR4_BIT6:        equ    6                                         ; Bit 6
ATDDR4_BIT7:        equ    7                                         ; Bit 7
ATDDR4_BIT8:        equ    8                                         ; Bit 8
ATDDR4_BIT9:        equ    9                                         ; Bit 9
ATDDR4_BIT10:       equ    10                                        ; Bit 10
ATDDR4_BIT11:       equ    11                                        ; Bit 11
ATDDR4_BIT12:       equ    12                                        ; Bit 12
ATDDR4_BIT13:       equ    13                                        ; Bit 13
ATDDR4_BIT14:       equ    14                                        ; Bit 14
ATDDR4_BIT15:       equ    15                                        ; Bit 15
; bit position masks
mATDDR4_BIT6:       equ    %01000000
mATDDR4_BIT7:       equ    %10000000
mATDDR4_BIT8:       equ    %100000000
mATDDR4_BIT9:       equ    %1000000000
mATDDR4_BIT10:      equ    %10000000000
mATDDR4_BIT11:      equ    %100000000000
mATDDR4_BIT12:      equ    %1000000000000
mATDDR4_BIT13:      equ    %10000000000000
mATDDR4_BIT14:      equ    %100000000000000
mATDDR4_BIT15:      equ    %1000000000000000


;*** ATDDR4H - ATD Conversion Result Register 4 High; 0x00000098 ***
ATDDR4H:            equ    $00000098                                ;*** ATDDR4H - ATD Conversion Result Register 4 High; 0x00000098 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR4H_BIT8:       equ    0                                         ; Bit 8
ATDDR4H_BIT9:       equ    1                                         ; Bit 9
ATDDR4H_BIT10:      equ    2                                         ; Bit 10
ATDDR4H_BIT11:      equ    3                                         ; Bit 11
ATDDR4H_BIT12:      equ    4                                         ; Bit 12
ATDDR4H_BIT13:      equ    5                                         ; Bit 13
ATDDR4H_BIT14:      equ    6                                         ; Bit 14
ATDDR4H_BIT15:      equ    7                                         ; Bit 15
; bit position masks
mATDDR4H_BIT8:      equ    %00000001
mATDDR4H_BIT9:      equ    %00000010
mATDDR4H_BIT10:     equ    %00000100
mATDDR4H_BIT11:     equ    %00001000
mATDDR4H_BIT12:     equ    %00010000
mATDDR4H_BIT13:     equ    %00100000
mATDDR4H_BIT14:     equ    %01000000
mATDDR4H_BIT15:     equ    %10000000


;*** ATDDR4L - ATD Conversion Result Register 4 Low; 0x00000099 ***
ATDDR4L:            equ    $00000099                                ;*** ATDDR4L - ATD Conversion Result Register 4 Low; 0x00000099 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR4L_BIT6:       equ    6                                         ; Bit 6
ATDDR4L_BIT7:       equ    7                                         ; Bit 7
; bit position masks
mATDDR4L_BIT6:      equ    %01000000
mATDDR4L_BIT7:      equ    %10000000


;*** ATDDR5 - ATD Conversion Result Register 5; 0x0000009A ***
ATDDR5:             equ    $0000009A                                ;*** ATDDR5 - ATD Conversion Result Register 5; 0x0000009A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR5_BIT6:        equ    6                                         ; Bit 6
ATDDR5_BIT7:        equ    7                                         ; Bit 7
ATDDR5_BIT8:        equ    8                                         ; Bit 8
ATDDR5_BIT9:        equ    9                                         ; Bit 9
ATDDR5_BIT10:       equ    10                                        ; Bit 10
ATDDR5_BIT11:       equ    11                                        ; Bit 11
ATDDR5_BIT12:       equ    12                                        ; Bit 12
ATDDR5_BIT13:       equ    13                                        ; Bit 13
ATDDR5_BIT14:       equ    14                                        ; Bit 14
ATDDR5_BIT15:       equ    15                                        ; Bit 15
; bit position masks
mATDDR5_BIT6:       equ    %01000000
mATDDR5_BIT7:       equ    %10000000
mATDDR5_BIT8:       equ    %100000000
mATDDR5_BIT9:       equ    %1000000000
mATDDR5_BIT10:      equ    %10000000000
mATDDR5_BIT11:      equ    %100000000000
mATDDR5_BIT12:      equ    %1000000000000
mATDDR5_BIT13:      equ    %10000000000000
mATDDR5_BIT14:      equ    %100000000000000
mATDDR5_BIT15:      equ    %1000000000000000


;*** ATDDR5H - ATD Conversion Result Register 5 High; 0x0000009A ***
ATDDR5H:            equ    $0000009A                                ;*** ATDDR5H - ATD Conversion Result Register 5 High; 0x0000009A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR5H_BIT8:       equ    0                                         ; Bit 8
ATDDR5H_BIT9:       equ    1                                         ; Bit 9
ATDDR5H_BIT10:      equ    2                                         ; Bit 10
ATDDR5H_BIT11:      equ    3                                         ; Bit 11
ATDDR5H_BIT12:      equ    4                                         ; Bit 12
ATDDR5H_BIT13:      equ    5                                         ; Bit 13
ATDDR5H_BIT14:      equ    6                                         ; Bit 14
ATDDR5H_BIT15:      equ    7                                         ; Bit 15
; bit position masks
mATDDR5H_BIT8:      equ    %00000001
mATDDR5H_BIT9:      equ    %00000010
mATDDR5H_BIT10:     equ    %00000100
mATDDR5H_BIT11:     equ    %00001000
mATDDR5H_BIT12:     equ    %00010000
mATDDR5H_BIT13:     equ    %00100000
mATDDR5H_BIT14:     equ    %01000000
mATDDR5H_BIT15:     equ    %10000000


;*** ATDDR5L - ATD Conversion Result Register 5 Low; 0x0000009B ***
ATDDR5L:            equ    $0000009B                                ;*** ATDDR5L - ATD Conversion Result Register 5 Low; 0x0000009B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR5L_BIT6:       equ    6                                         ; Bit 6
ATDDR5L_BIT7:       equ    7                                         ; Bit 7
; bit position masks
mATDDR5L_BIT6:      equ    %01000000
mATDDR5L_BIT7:      equ    %10000000


;*** ATDDR6 - ATD Conversion Result Register 6; 0x0000009C ***
ATDDR6:             equ    $0000009C                                ;*** ATDDR6 - ATD Conversion Result Register 6; 0x0000009C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR6_BIT6:        equ    6                                         ; Bit 6
ATDDR6_BIT7:        equ    7                                         ; Bit 7
ATDDR6_BIT8:        equ    8                                         ; Bit 8
ATDDR6_BIT9:        equ    9                                         ; Bit 9
ATDDR6_BIT10:       equ    10                                        ; Bit 10
ATDDR6_BIT11:       equ    11                                        ; Bit 11
ATDDR6_BIT12:       equ    12                                        ; Bit 12
ATDDR6_BIT13:       equ    13                                        ; Bit 13
ATDDR6_BIT14:       equ    14                                        ; Bit 14
ATDDR6_BIT15:       equ    15                                        ; Bit 15
; bit position masks
mATDDR6_BIT6:       equ    %01000000
mATDDR6_BIT7:       equ    %10000000
mATDDR6_BIT8:       equ    %100000000
mATDDR6_BIT9:       equ    %1000000000
mATDDR6_BIT10:      equ    %10000000000
mATDDR6_BIT11:      equ    %100000000000
mATDDR6_BIT12:      equ    %1000000000000
mATDDR6_BIT13:      equ    %10000000000000
mATDDR6_BIT14:      equ    %100000000000000
mATDDR6_BIT15:      equ    %1000000000000000


;*** ATDDR6H - ATD Conversion Result Register 6 High; 0x0000009C ***
ATDDR6H:            equ    $0000009C                                ;*** ATDDR6H - ATD Conversion Result Register 6 High; 0x0000009C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR6H_BIT8:       equ    0                                         ; Bit 8
ATDDR6H_BIT9:       equ    1                                         ; Bit 9
ATDDR6H_BIT10:      equ    2                                         ; Bit 10
ATDDR6H_BIT11:      equ    3                                         ; Bit 11
ATDDR6H_BIT12:      equ    4                                         ; Bit 12
ATDDR6H_BIT13:      equ    5                                         ; Bit 13
ATDDR6H_BIT14:      equ    6                                         ; Bit 14
ATDDR6H_BIT15:      equ    7                                         ; Bit 15
; bit position masks
mATDDR6H_BIT8:      equ    %00000001
mATDDR6H_BIT9:      equ    %00000010
mATDDR6H_BIT10:     equ    %00000100
mATDDR6H_BIT11:     equ    %00001000
mATDDR6H_BIT12:     equ    %00010000
mATDDR6H_BIT13:     equ    %00100000
mATDDR6H_BIT14:     equ    %01000000
mATDDR6H_BIT15:     equ    %10000000


;*** ATDDR6L - ATD Conversion Result Register 6 Low; 0x0000009D ***
ATDDR6L:            equ    $0000009D                                ;*** ATDDR6L - ATD Conversion Result Register 6 Low; 0x0000009D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR6L_BIT6:       equ    6                                         ; Bit 6
ATDDR6L_BIT7:       equ    7                                         ; Bit 7
; bit position masks
mATDDR6L_BIT6:      equ    %01000000
mATDDR6L_BIT7:      equ    %10000000


;*** ATDDR7 - ATD Conversion Result Register 7; 0x0000009E ***
ATDDR7:             equ    $0000009E                                ;*** ATDDR7 - ATD Conversion Result Register 7; 0x0000009E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR7_BIT6:        equ    6                                         ; Bit 6
ATDDR7_BIT7:        equ    7                                         ; Bit 7
ATDDR7_BIT8:        equ    8                                         ; Bit 8
ATDDR7_BIT9:        equ    9                                         ; Bit 9
ATDDR7_BIT10:       equ    10                                        ; Bit 10
ATDDR7_BIT11:       equ    11                                        ; Bit 11
ATDDR7_BIT12:       equ    12                                        ; Bit 12
ATDDR7_BIT13:       equ    13                                        ; Bit 13
ATDDR7_BIT14:       equ    14                                        ; Bit 14
ATDDR7_BIT15:       equ    15                                        ; Bit 15
; bit position masks
mATDDR7_BIT6:       equ    %01000000
mATDDR7_BIT7:       equ    %10000000
mATDDR7_BIT8:       equ    %100000000
mATDDR7_BIT9:       equ    %1000000000
mATDDR7_BIT10:      equ    %10000000000
mATDDR7_BIT11:      equ    %100000000000
mATDDR7_BIT12:      equ    %1000000000000
mATDDR7_BIT13:      equ    %10000000000000
mATDDR7_BIT14:      equ    %100000000000000
mATDDR7_BIT15:      equ    %1000000000000000


;*** ATDDR7H - ATD Conversion Result Register 7 High; 0x0000009E ***
ATDDR7H:            equ    $0000009E                                ;*** ATDDR7H - ATD Conversion Result Register 7 High; 0x0000009E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR7H_BIT8:       equ    0                                         ; Bit 8
ATDDR7H_BIT9:       equ    1                                         ; Bit 9
ATDDR7H_BIT10:      equ    2                                         ; Bit 10
ATDDR7H_BIT11:      equ    3                                         ; Bit 11
ATDDR7H_BIT12:      equ    4                                         ; Bit 12
ATDDR7H_BIT13:      equ    5                                         ; Bit 13
ATDDR7H_BIT14:      equ    6                                         ; Bit 14
ATDDR7H_BIT15:      equ    7                                         ; Bit 15
; bit position masks
mATDDR7H_BIT8:      equ    %00000001
mATDDR7H_BIT9:      equ    %00000010
mATDDR7H_BIT10:     equ    %00000100
mATDDR7H_BIT11:     equ    %00001000
mATDDR7H_BIT12:     equ    %00010000
mATDDR7H_BIT13:     equ    %00100000
mATDDR7H_BIT14:     equ    %01000000
mATDDR7H_BIT15:     equ    %10000000


;*** ATDDR7L - ATD Conversion Result Register 7 Low; 0x0000009F ***
ATDDR7L:            equ    $0000009F                                ;*** ATDDR7L - ATD Conversion Result Register 7 Low; 0x0000009F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR7L_BIT6:       equ    6                                         ; Bit 6
ATDDR7L_BIT7:       equ    7                                         ; Bit 7
; bit position masks
mATDDR7L_BIT6:      equ    %01000000
mATDDR7L_BIT7:      equ    %10000000


;*** ATDDR8 - ATD Conversion Result Register 8; 0x000000A0 ***
ATDDR8:             equ    $000000A0                                ;*** ATDDR8 - ATD Conversion Result Register 8; 0x000000A0 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR8_BIT6:        equ    6                                         ; Bit 6
ATDDR8_BIT7:        equ    7                                         ; Bit 7
ATDDR8_BIT8:        equ    8                                         ; Bit 8
ATDDR8_BIT9:        equ    9                                         ; Bit 9
ATDDR8_BIT10:       equ    10                                        ; Bit 10
ATDDR8_BIT11:       equ    11                                        ; Bit 11
ATDDR8_BIT12:       equ    12                                        ; Bit 12
ATDDR8_BIT13:       equ    13                                        ; Bit 13
ATDDR8_BIT14:       equ    14                                        ; Bit 14
ATDDR8_BIT15:       equ    15                                        ; Bit 15
; bit position masks
mATDDR8_BIT6:       equ    %01000000
mATDDR8_BIT7:       equ    %10000000
mATDDR8_BIT8:       equ    %100000000
mATDDR8_BIT9:       equ    %1000000000
mATDDR8_BIT10:      equ    %10000000000
mATDDR8_BIT11:      equ    %100000000000
mATDDR8_BIT12:      equ    %1000000000000
mATDDR8_BIT13:      equ    %10000000000000
mATDDR8_BIT14:      equ    %100000000000000
mATDDR8_BIT15:      equ    %1000000000000000


;*** ATDDR8H - ATD Conversion Result Register 8 High; 0x000000A0 ***
ATDDR8H:            equ    $000000A0                                ;*** ATDDR8H - ATD Conversion Result Register 8 High; 0x000000A0 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR8H_BIT8:       equ    0                                         ; Bit 8
ATDDR8H_BIT9:       equ    1                                         ; Bit 9
ATDDR8H_BIT10:      equ    2                                         ; Bit 10
ATDDR8H_BIT11:      equ    3                                         ; Bit 11
ATDDR8H_BIT12:      equ    4                                         ; Bit 12
ATDDR8H_BIT13:      equ    5                                         ; Bit 13
ATDDR8H_BIT14:      equ    6                                         ; Bit 14
ATDDR8H_BIT15:      equ    7                                         ; Bit 15
; bit position masks
mATDDR8H_BIT8:      equ    %00000001
mATDDR8H_BIT9:      equ    %00000010
mATDDR8H_BIT10:     equ    %00000100
mATDDR8H_BIT11:     equ    %00001000
mATDDR8H_BIT12:     equ    %00010000
mATDDR8H_BIT13:     equ    %00100000
mATDDR8H_BIT14:     equ    %01000000
mATDDR8H_BIT15:     equ    %10000000


;*** ATDDR8L - ATD Conversion Result Register 8 Low; 0x000000A1 ***
ATDDR8L:            equ    $000000A1                                ;*** ATDDR8L - ATD Conversion Result Register 8 Low; 0x000000A1 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR8L_BIT6:       equ    6                                         ; Bit 6
ATDDR8L_BIT7:       equ    7                                         ; Bit 7
; bit position masks
mATDDR8L_BIT6:      equ    %01000000
mATDDR8L_BIT7:      equ    %10000000


;*** ATDDR9 - ATD Conversion Result Register 9; 0x000000A2 ***
ATDDR9:             equ    $000000A2                                ;*** ATDDR9 - ATD Conversion Result Register 9; 0x000000A2 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR9_BIT6:        equ    6                                         ; Bit 6
ATDDR9_BIT7:        equ    7                                         ; Bit 7
ATDDR9_BIT8:        equ    8                                         ; Bit 8
ATDDR9_BIT9:        equ    9                                         ; Bit 9
ATDDR9_BIT10:       equ    10                                        ; Bit 10
ATDDR9_BIT11:       equ    11                                        ; Bit 11
ATDDR9_BIT12:       equ    12                                        ; Bit 12
ATDDR9_BIT13:       equ    13                                        ; Bit 13
ATDDR9_BIT14:       equ    14                                        ; Bit 14
ATDDR9_BIT15:       equ    15                                        ; Bit 15
; bit position masks
mATDDR9_BIT6:       equ    %01000000
mATDDR9_BIT7:       equ    %10000000
mATDDR9_BIT8:       equ    %100000000
mATDDR9_BIT9:       equ    %1000000000
mATDDR9_BIT10:      equ    %10000000000
mATDDR9_BIT11:      equ    %100000000000
mATDDR9_BIT12:      equ    %1000000000000
mATDDR9_BIT13:      equ    %10000000000000
mATDDR9_BIT14:      equ    %100000000000000
mATDDR9_BIT15:      equ    %1000000000000000


;*** ATDDR9H - ATD Conversion Result Register 9 High; 0x000000A2 ***
ATDDR9H:            equ    $000000A2                                ;*** ATDDR9H - ATD Conversion Result Register 9 High; 0x000000A2 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR9H_BIT8:       equ    0                                         ; Bit 8
ATDDR9H_BIT9:       equ    1                                         ; Bit 9
ATDDR9H_BIT10:      equ    2                                         ; Bit 10
ATDDR9H_BIT11:      equ    3                                         ; Bit 11
ATDDR9H_BIT12:      equ    4                                         ; Bit 12
ATDDR9H_BIT13:      equ    5                                         ; Bit 13
ATDDR9H_BIT14:      equ    6                                         ; Bit 14
ATDDR9H_BIT15:      equ    7                                         ; Bit 15
; bit position masks
mATDDR9H_BIT8:      equ    %00000001
mATDDR9H_BIT9:      equ    %00000010
mATDDR9H_BIT10:     equ    %00000100
mATDDR9H_BIT11:     equ    %00001000
mATDDR9H_BIT12:     equ    %00010000
mATDDR9H_BIT13:     equ    %00100000
mATDDR9H_BIT14:     equ    %01000000
mATDDR9H_BIT15:     equ    %10000000


;*** ATDDR9L - ATD Conversion Result Register 9 Low; 0x000000A3 ***
ATDDR9L:            equ    $000000A3                                ;*** ATDDR9L - ATD Conversion Result Register 9 Low; 0x000000A3 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR9L_BIT6:       equ    6                                         ; Bit 6
ATDDR9L_BIT7:       equ    7                                         ; Bit 7
; bit position masks
mATDDR9L_BIT6:      equ    %01000000
mATDDR9L_BIT7:      equ    %10000000


;*** ATDDR10 - ATD Conversion Result Register 10; 0x000000A4 ***
ATDDR10:            equ    $000000A4                                ;*** ATDDR10 - ATD Conversion Result Register 10; 0x000000A4 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR10_BIT6:       equ    6                                         ; Bit 6
ATDDR10_BIT7:       equ    7                                         ; Bit 7
ATDDR10_BIT8:       equ    8                                         ; Bit 8
ATDDR10_BIT9:       equ    9                                         ; Bit 9
ATDDR10_BIT10:      equ    10                                        ; Bit 10
ATDDR10_BIT11:      equ    11                                        ; Bit 11
ATDDR10_BIT12:      equ    12                                        ; Bit 12
ATDDR10_BIT13:      equ    13                                        ; Bit 13
ATDDR10_BIT14:      equ    14                                        ; Bit 14
ATDDR10_BIT15:      equ    15                                        ; Bit 15
; bit position masks
mATDDR10_BIT6:      equ    %01000000
mATDDR10_BIT7:      equ    %10000000
mATDDR10_BIT8:      equ    %100000000
mATDDR10_BIT9:      equ    %1000000000
mATDDR10_BIT10:     equ    %10000000000
mATDDR10_BIT11:     equ    %100000000000
mATDDR10_BIT12:     equ    %1000000000000
mATDDR10_BIT13:     equ    %10000000000000
mATDDR10_BIT14:     equ    %100000000000000
mATDDR10_BIT15:     equ    %1000000000000000


;*** ATDDR10H - ATD Conversion Result Register 10 High; 0x000000A4 ***
ATDDR10H:           equ    $000000A4                                ;*** ATDDR10H - ATD Conversion Result Register 10 High; 0x000000A4 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR10H_BIT8:      equ    0                                         ; Bit 8
ATDDR10H_BIT9:      equ    1                                         ; Bit 9
ATDDR10H_BIT10:     equ    2                                         ; Bit 10
ATDDR10H_BIT11:     equ    3                                         ; Bit 11
ATDDR10H_BIT12:     equ    4                                         ; Bit 12
ATDDR10H_BIT13:     equ    5                                         ; Bit 13
ATDDR10H_BIT14:     equ    6                                         ; Bit 14
ATDDR10H_BIT15:     equ    7                                         ; Bit 15
; bit position masks
mATDDR10H_BIT8:     equ    %00000001
mATDDR10H_BIT9:     equ    %00000010
mATDDR10H_BIT10:    equ    %00000100
mATDDR10H_BIT11:    equ    %00001000
mATDDR10H_BIT12:    equ    %00010000
mATDDR10H_BIT13:    equ    %00100000
mATDDR10H_BIT14:    equ    %01000000
mATDDR10H_BIT15:    equ    %10000000


;*** ATDDR10L - ATD Conversion Result Register 10 Low; 0x000000A5 ***
ATDDR10L:           equ    $000000A5                                ;*** ATDDR10L - ATD Conversion Result Register 10 Low; 0x000000A5 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR10L_BIT6:      equ    6                                         ; Bit 6
ATDDR10L_BIT7:      equ    7                                         ; Bit 7
; bit position masks
mATDDR10L_BIT6:     equ    %01000000
mATDDR10L_BIT7:     equ    %10000000


;*** ATDDR11 - ATD Conversion Result Register 11; 0x000000A6 ***
ATDDR11:            equ    $000000A6                                ;*** ATDDR11 - ATD Conversion Result Register 11; 0x000000A6 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR11_BIT6:       equ    6                                         ; Bit 6
ATDDR11_BIT7:       equ    7                                         ; Bit 7
ATDDR11_BIT8:       equ    8                                         ; Bit 8
ATDDR11_BIT9:       equ    9                                         ; Bit 9
ATDDR11_BIT10:      equ    10                                        ; Bit 10
ATDDR11_BIT11:      equ    11                                        ; Bit 11
ATDDR11_BIT12:      equ    12                                        ; Bit 12
ATDDR11_BIT13:      equ    13                                        ; Bit 13
ATDDR11_BIT14:      equ    14                                        ; Bit 14
ATDDR11_BIT15:      equ    15                                        ; Bit 15
; bit position masks
mATDDR11_BIT6:      equ    %01000000
mATDDR11_BIT7:      equ    %10000000
mATDDR11_BIT8:      equ    %100000000
mATDDR11_BIT9:      equ    %1000000000
mATDDR11_BIT10:     equ    %10000000000
mATDDR11_BIT11:     equ    %100000000000
mATDDR11_BIT12:     equ    %1000000000000
mATDDR11_BIT13:     equ    %10000000000000
mATDDR11_BIT14:     equ    %100000000000000
mATDDR11_BIT15:     equ    %1000000000000000


;*** ATDDR11H - ATD Conversion Result Register 11 High; 0x000000A6 ***
ATDDR11H:           equ    $000000A6                                ;*** ATDDR11H - ATD Conversion Result Register 11 High; 0x000000A6 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR11H_BIT8:      equ    0                                         ; Bit 8
ATDDR11H_BIT9:      equ    1                                         ; Bit 9
ATDDR11H_BIT10:     equ    2                                         ; Bit 10
ATDDR11H_BIT11:     equ    3                                         ; Bit 11
ATDDR11H_BIT12:     equ    4                                         ; Bit 12
ATDDR11H_BIT13:     equ    5                                         ; Bit 13
ATDDR11H_BIT14:     equ    6                                         ; Bit 14
ATDDR11H_BIT15:     equ    7                                         ; Bit 15
; bit position masks
mATDDR11H_BIT8:     equ    %00000001
mATDDR11H_BIT9:     equ    %00000010
mATDDR11H_BIT10:    equ    %00000100
mATDDR11H_BIT11:    equ    %00001000
mATDDR11H_BIT12:    equ    %00010000
mATDDR11H_BIT13:    equ    %00100000
mATDDR11H_BIT14:    equ    %01000000
mATDDR11H_BIT15:    equ    %10000000


;*** ATDDR11L - ATD Conversion Result Register 11 Low; 0x000000A7 ***
ATDDR11L:           equ    $000000A7                                ;*** ATDDR11L - ATD Conversion Result Register 11 Low; 0x000000A7 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR11L_BIT6:      equ    6                                         ; Bit 6
ATDDR11L_BIT7:      equ    7                                         ; Bit 7
; bit position masks
mATDDR11L_BIT6:     equ    %01000000
mATDDR11L_BIT7:     equ    %10000000


;*** ATDDR12 - ATD Conversion Result Register 12; 0x000000A8 ***
ATDDR12:            equ    $000000A8                                ;*** ATDDR12 - ATD Conversion Result Register 12; 0x000000A8 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR12_BIT6:       equ    6                                         ; Bit 6
ATDDR12_BIT7:       equ    7                                         ; Bit 7
ATDDR12_BIT8:       equ    8                                         ; Bit 8
ATDDR12_BIT9:       equ    9                                         ; Bit 9
ATDDR12_BIT10:      equ    10                                        ; Bit 10
ATDDR12_BIT11:      equ    11                                        ; Bit 11
ATDDR12_BIT12:      equ    12                                        ; Bit 12
ATDDR12_BIT13:      equ    13                                        ; Bit 13
ATDDR12_BIT14:      equ    14                                        ; Bit 14
ATDDR12_BIT15:      equ    15                                        ; Bit 15
; bit position masks
mATDDR12_BIT6:      equ    %01000000
mATDDR12_BIT7:      equ    %10000000
mATDDR12_BIT8:      equ    %100000000
mATDDR12_BIT9:      equ    %1000000000
mATDDR12_BIT10:     equ    %10000000000
mATDDR12_BIT11:     equ    %100000000000
mATDDR12_BIT12:     equ    %1000000000000
mATDDR12_BIT13:     equ    %10000000000000
mATDDR12_BIT14:     equ    %100000000000000
mATDDR12_BIT15:     equ    %1000000000000000


;*** ATDDR12H - ATD Conversion Result Register 12 High; 0x000000A8 ***
ATDDR12H:           equ    $000000A8                                ;*** ATDDR12H - ATD Conversion Result Register 12 High; 0x000000A8 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR12H_BIT8:      equ    0                                         ; Bit 8
ATDDR12H_BIT9:      equ    1                                         ; Bit 9
ATDDR12H_BIT10:     equ    2                                         ; Bit 10
ATDDR12H_BIT11:     equ    3                                         ; Bit 11
ATDDR12H_BIT12:     equ    4                                         ; Bit 12
ATDDR12H_BIT13:     equ    5                                         ; Bit 13
ATDDR12H_BIT14:     equ    6                                         ; Bit 14
ATDDR12H_BIT15:     equ    7                                         ; Bit 15
; bit position masks
mATDDR12H_BIT8:     equ    %00000001
mATDDR12H_BIT9:     equ    %00000010
mATDDR12H_BIT10:    equ    %00000100
mATDDR12H_BIT11:    equ    %00001000
mATDDR12H_BIT12:    equ    %00010000
mATDDR12H_BIT13:    equ    %00100000
mATDDR12H_BIT14:    equ    %01000000
mATDDR12H_BIT15:    equ    %10000000


;*** ATDDR12L - ATD Conversion Result Register 12 Low; 0x000000A9 ***
ATDDR12L:           equ    $000000A9                                ;*** ATDDR12L - ATD Conversion Result Register 12 Low; 0x000000A9 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR12L_BIT6:      equ    6                                         ; Bit 6
ATDDR12L_BIT7:      equ    7                                         ; Bit 7
; bit position masks
mATDDR12L_BIT6:     equ    %01000000
mATDDR12L_BIT7:     equ    %10000000


;*** ATDDR13 - ATD Conversion Result Register 13; 0x000000AA ***
ATDDR13:            equ    $000000AA                                ;*** ATDDR13 - ATD Conversion Result Register 13; 0x000000AA ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR13_BIT6:       equ    6                                         ; Bit 6
ATDDR13_BIT7:       equ    7                                         ; Bit 7
ATDDR13_BIT8:       equ    8                                         ; Bit 8
ATDDR13_BIT9:       equ    9                                         ; Bit 9
ATDDR13_BIT10:      equ    10                                        ; Bit 10
ATDDR13_BIT11:      equ    11                                        ; Bit 11
ATDDR13_BIT12:      equ    12                                        ; Bit 12
ATDDR13_BIT13:      equ    13                                        ; Bit 13
ATDDR13_BIT14:      equ    14                                        ; Bit 14
ATDDR13_BIT15:      equ    15                                        ; Bit 15
; bit position masks
mATDDR13_BIT6:      equ    %01000000
mATDDR13_BIT7:      equ    %10000000
mATDDR13_BIT8:      equ    %100000000
mATDDR13_BIT9:      equ    %1000000000
mATDDR13_BIT10:     equ    %10000000000
mATDDR13_BIT11:     equ    %100000000000
mATDDR13_BIT12:     equ    %1000000000000
mATDDR13_BIT13:     equ    %10000000000000
mATDDR13_BIT14:     equ    %100000000000000
mATDDR13_BIT15:     equ    %1000000000000000


;*** ATDDR13H - ATD Conversion Result Register 13 High; 0x000000AA ***
ATDDR13H:           equ    $000000AA                                ;*** ATDDR13H - ATD Conversion Result Register 13 High; 0x000000AA ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR13H_BIT8:      equ    0                                         ; Bit 8
ATDDR13H_BIT9:      equ    1                                         ; Bit 9
ATDDR13H_BIT10:     equ    2                                         ; Bit 10
ATDDR13H_BIT11:     equ    3                                         ; Bit 11
ATDDR13H_BIT12:     equ    4                                         ; Bit 12
ATDDR13H_BIT13:     equ    5                                         ; Bit 13
ATDDR13H_BIT14:     equ    6                                         ; Bit 14
ATDDR13H_BIT15:     equ    7                                         ; Bit 15
; bit position masks
mATDDR13H_BIT8:     equ    %00000001
mATDDR13H_BIT9:     equ    %00000010
mATDDR13H_BIT10:    equ    %00000100
mATDDR13H_BIT11:    equ    %00001000
mATDDR13H_BIT12:    equ    %00010000
mATDDR13H_BIT13:    equ    %00100000
mATDDR13H_BIT14:    equ    %01000000
mATDDR13H_BIT15:    equ    %10000000


;*** ATDDR13L - ATD Conversion Result Register 13 Low; 0x000000AB ***
ATDDR13L:           equ    $000000AB                                ;*** ATDDR13L - ATD Conversion Result Register 13 Low; 0x000000AB ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR13L_BIT6:      equ    6                                         ; Bit 6
ATDDR13L_BIT7:      equ    7                                         ; Bit 7
; bit position masks
mATDDR13L_BIT6:     equ    %01000000
mATDDR13L_BIT7:     equ    %10000000


;*** ATDDR14 - ATD Conversion Result Register 14; 0x000000AC ***
ATDDR14:            equ    $000000AC                                ;*** ATDDR14 - ATD Conversion Result Register 14; 0x000000AC ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR14_BIT6:       equ    6                                         ; Bit 6
ATDDR14_BIT7:       equ    7                                         ; Bit 7
ATDDR14_BIT8:       equ    8                                         ; Bit 8
ATDDR14_BIT9:       equ    9                                         ; Bit 9
ATDDR14_BIT10:      equ    10                                        ; Bit 10
ATDDR14_BIT11:      equ    11                                        ; Bit 11
ATDDR14_BIT12:      equ    12                                        ; Bit 12
ATDDR14_BIT13:      equ    13                                        ; Bit 13
ATDDR14_BIT14:      equ    14                                        ; Bit 14
ATDDR14_BIT15:      equ    15                                        ; Bit 15
; bit position masks
mATDDR14_BIT6:      equ    %01000000
mATDDR14_BIT7:      equ    %10000000
mATDDR14_BIT8:      equ    %100000000
mATDDR14_BIT9:      equ    %1000000000
mATDDR14_BIT10:     equ    %10000000000
mATDDR14_BIT11:     equ    %100000000000
mATDDR14_BIT12:     equ    %1000000000000
mATDDR14_BIT13:     equ    %10000000000000
mATDDR14_BIT14:     equ    %100000000000000
mATDDR14_BIT15:     equ    %1000000000000000


;*** ATDDR14H - ATD Conversion Result Register 14 High; 0x000000AC ***
ATDDR14H:           equ    $000000AC                                ;*** ATDDR14H - ATD Conversion Result Register 14 High; 0x000000AC ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR14H_BIT8:      equ    0                                         ; Bit 8
ATDDR14H_BIT9:      equ    1                                         ; Bit 9
ATDDR14H_BIT10:     equ    2                                         ; Bit 10
ATDDR14H_BIT11:     equ    3                                         ; Bit 11
ATDDR14H_BIT12:     equ    4                                         ; Bit 12
ATDDR14H_BIT13:     equ    5                                         ; Bit 13
ATDDR14H_BIT14:     equ    6                                         ; Bit 14
ATDDR14H_BIT15:     equ    7                                         ; Bit 15
; bit position masks
mATDDR14H_BIT8:     equ    %00000001
mATDDR14H_BIT9:     equ    %00000010
mATDDR14H_BIT10:    equ    %00000100
mATDDR14H_BIT11:    equ    %00001000
mATDDR14H_BIT12:    equ    %00010000
mATDDR14H_BIT13:    equ    %00100000
mATDDR14H_BIT14:    equ    %01000000
mATDDR14H_BIT15:    equ    %10000000


;*** ATDDR14L - ATD Conversion Result Register 14 Low; 0x000000AD ***
ATDDR14L:           equ    $000000AD                                ;*** ATDDR14L - ATD Conversion Result Register 14 Low; 0x000000AD ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR14L_BIT6:      equ    6                                         ; Bit 6
ATDDR14L_BIT7:      equ    7                                         ; Bit 7
; bit position masks
mATDDR14L_BIT6:     equ    %01000000
mATDDR14L_BIT7:     equ    %10000000


;*** ATDDR15 - ATD Conversion Result Register 15; 0x000000AE ***
ATDDR15:            equ    $000000AE                                ;*** ATDDR15 - ATD Conversion Result Register 15; 0x000000AE ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR15_BIT6:       equ    6                                         ; Bit 6
ATDDR15_BIT7:       equ    7                                         ; Bit 7
ATDDR15_BIT8:       equ    8                                         ; Bit 8
ATDDR15_BIT9:       equ    9                                         ; Bit 9
ATDDR15_BIT10:      equ    10                                        ; Bit 10
ATDDR15_BIT11:      equ    11                                        ; Bit 11
ATDDR15_BIT12:      equ    12                                        ; Bit 12
ATDDR15_BIT13:      equ    13                                        ; Bit 13
ATDDR15_BIT14:      equ    14                                        ; Bit 14
ATDDR15_BIT15:      equ    15                                        ; Bit 15
; bit position masks
mATDDR15_BIT6:      equ    %01000000
mATDDR15_BIT7:      equ    %10000000
mATDDR15_BIT8:      equ    %100000000
mATDDR15_BIT9:      equ    %1000000000
mATDDR15_BIT10:     equ    %10000000000
mATDDR15_BIT11:     equ    %100000000000
mATDDR15_BIT12:     equ    %1000000000000
mATDDR15_BIT13:     equ    %10000000000000
mATDDR15_BIT14:     equ    %100000000000000
mATDDR15_BIT15:     equ    %1000000000000000


;*** ATDDR15H - ATD Conversion Result Register 15 High; 0x000000AE ***
ATDDR15H:           equ    $000000AE                                ;*** ATDDR15H - ATD Conversion Result Register 15 High; 0x000000AE ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR15H_BIT8:      equ    0                                         ; Bit 8
ATDDR15H_BIT9:      equ    1                                         ; Bit 9
ATDDR15H_BIT10:     equ    2                                         ; Bit 10
ATDDR15H_BIT11:     equ    3                                         ; Bit 11
ATDDR15H_BIT12:     equ    4                                         ; Bit 12
ATDDR15H_BIT13:     equ    5                                         ; Bit 13
ATDDR15H_BIT14:     equ    6                                         ; Bit 14
ATDDR15H_BIT15:     equ    7                                         ; Bit 15
; bit position masks
mATDDR15H_BIT8:     equ    %00000001
mATDDR15H_BIT9:     equ    %00000010
mATDDR15H_BIT10:    equ    %00000100
mATDDR15H_BIT11:    equ    %00001000
mATDDR15H_BIT12:    equ    %00010000
mATDDR15H_BIT13:    equ    %00100000
mATDDR15H_BIT14:    equ    %01000000
mATDDR15H_BIT15:    equ    %10000000


;*** ATDDR15L - ATD Conversion Result Register 15 Low; 0x000000AF ***
ATDDR15L:           equ    $000000AF                                ;*** ATDDR15L - ATD Conversion Result Register 15 Low; 0x000000AF ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR15L_BIT6:      equ    6                                         ; Bit 6
ATDDR15L_BIT7:      equ    7                                         ; Bit 7
; bit position masks
mATDDR15L_BIT6:     equ    %01000000
mATDDR15L_BIT7:     equ    %10000000


;*** SCI0BD - SCI 0 Baud Rate Register; 0x000000C8 ***
SCI0BD:             equ    $000000C8                                ;*** SCI0BD - SCI 0 Baud Rate Register; 0x000000C8 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI0BD_SBR0:        equ    0                                         ; SCI Baud Rate Bit 0
SCI0BD_SBR1:        equ    1                                         ; SCI Baud Rate Bit 1
SCI0BD_SBR2:        equ    2                                         ; SCI Baud Rate Bit 2
SCI0BD_SBR3:        equ    3                                         ; SCI Baud Rate Bit 3
SCI0BD_SBR4:        equ    4                                         ; SCI Baud Rate Bit 4
SCI0BD_SBR5:        equ    5                                         ; SCI Baud Rate Bit 5
SCI0BD_SBR6:        equ    6                                         ; SCI Baud Rate Bit 6
SCI0BD_SBR7:        equ    7                                         ; SCI Baud Rate Bit 7
SCI0BD_SBR8:        equ    8                                         ; SCI Baud Rate Bit 8
SCI0BD_SBR9:        equ    9                                         ; SCI Baud Rate Bit 9
SCI0BD_SBR10:       equ    10                                        ; SCI Baud Rate Bit 10
SCI0BD_SBR11:       equ    11                                        ; SCI Baud Rate Bit 11
SCI0BD_SBR12:       equ    12                                        ; SCI Baud Rate Bit 12
SCI0BD_TNP0:        equ    13                                        ; Transmitter Narrow Pulse Bit 0
SCI0BD_TNP1:        equ    14                                        ; Transmitter Narrow Pulse Bit 1
SCI0BD_IREN:        equ    15                                        ; Infrared Enable Bit
; bit position masks
mSCI0BD_SBR0:       equ    %00000001
mSCI0BD_SBR1:       equ    %00000010
mSCI0BD_SBR2:       equ    %00000100
mSCI0BD_SBR3:       equ    %00001000
mSCI0BD_SBR4:       equ    %00010000
mSCI0BD_SBR5:       equ    %00100000
mSCI0BD_SBR6:       equ    %01000000
mSCI0BD_SBR7:       equ    %10000000
mSCI0BD_SBR8:       equ    %100000000
mSCI0BD_SBR9:       equ    %1000000000
mSCI0BD_SBR10:      equ    %10000000000
mSCI0BD_SBR11:      equ    %100000000000
mSCI0BD_SBR12:      equ    %1000000000000
mSCI0BD_TNP0:       equ    %10000000000000
mSCI0BD_TNP1:       equ    %100000000000000
mSCI0BD_IREN:       equ    %1000000000000000


;*** SCI0BDH - SCI 0 Baud Rate Register High; 0x000000C8 ***
SCI0BDH:            equ    $000000C8                                ;*** SCI0BDH - SCI 0 Baud Rate Register High; 0x000000C8 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI0BDH_SBR8:       equ    0                                         ; SCI Baud Rate Bit 8
SCI0BDH_SBR9:       equ    1                                         ; SCI Baud Rate Bit 9
SCI0BDH_SBR10:      equ    2                                         ; SCI Baud Rate Bit 10
SCI0BDH_SBR11:      equ    3                                         ; SCI Baud Rate Bit 11
SCI0BDH_SBR12:      equ    4                                         ; SCI Baud Rate Bit 12
SCI0BDH_TNP0:       equ    5                                         ; Transmitter Narrow Pulse Bit 0
SCI0BDH_TNP1:       equ    6                                         ; Transmitter Narrow Pulse Bit 1
SCI0BDH_IREN:       equ    7                                         ; Infrared Enable Bit
; bit position masks
mSCI0BDH_SBR8:      equ    %00000001
mSCI0BDH_SBR9:      equ    %00000010
mSCI0BDH_SBR10:     equ    %00000100
mSCI0BDH_SBR11:     equ    %00001000
mSCI0BDH_SBR12:     equ    %00010000
mSCI0BDH_TNP0:      equ    %00100000
mSCI0BDH_TNP1:      equ    %01000000
mSCI0BDH_IREN:      equ    %10000000


;*** SCI0BDL - SCI 0 Baud Rate Register Low; 0x000000C9 ***
SCI0BDL:            equ    $000000C9                                ;*** SCI0BDL - SCI 0 Baud Rate Register Low; 0x000000C9 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI0BDL_SBR0:       equ    0                                         ; SCI Baud Rate Bit 0
SCI0BDL_SBR1:       equ    1                                         ; SCI Baud Rate Bit 1
SCI0BDL_SBR2:       equ    2                                         ; SCI Baud Rate Bit 2
SCI0BDL_SBR3:       equ    3                                         ; SCI Baud Rate Bit 3
SCI0BDL_SBR4:       equ    4                                         ; SCI Baud Rate Bit 4
SCI0BDL_SBR5:       equ    5                                         ; SCI Baud Rate Bit 5
SCI0BDL_SBR6:       equ    6                                         ; SCI Baud Rate Bit 6
SCI0BDL_SBR7:       equ    7                                         ; SCI Baud Rate Bit 7
; bit position masks
mSCI0BDL_SBR0:      equ    %00000001
mSCI0BDL_SBR1:      equ    %00000010
mSCI0BDL_SBR2:      equ    %00000100
mSCI0BDL_SBR3:      equ    %00001000
mSCI0BDL_SBR4:      equ    %00010000
mSCI0BDL_SBR5:      equ    %00100000
mSCI0BDL_SBR6:      equ    %01000000
mSCI0BDL_SBR7:      equ    %10000000


;*** SCI0CR1 - SCI 0 Control Register 1; 0x000000CA ***
SCI0CR1:            equ    $000000CA                                ;*** SCI0CR1 - SCI 0 Control Register 1; 0x000000CA ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI0CR1_PT:         equ    0                                         ; Parity Type Bit
SCI0CR1_PE:         equ    1                                         ; Parity Enable Bit
SCI0CR1_ILT:        equ    2                                         ; Idle Line Type Bit
SCI0CR1_WAKE:       equ    3                                         ; Wakeup Condition Bit
SCI0CR1_M:          equ    4                                         ; Data Format Mode Bit
SCI0CR1_RSRC:       equ    5                                         ; Receiver Source Bit
SCI0CR1_SCISWAI:    equ    6                                         ; SCI Stop in Wait Mode Bit
SCI0CR1_LOOPS:      equ    7                                         ; Loop Select Bit
; bit position masks
mSCI0CR1_PT:        equ    %00000001
mSCI0CR1_PE:        equ    %00000010
mSCI0CR1_ILT:       equ    %00000100
mSCI0CR1_WAKE:      equ    %00001000
mSCI0CR1_M:         equ    %00010000
mSCI0CR1_RSRC:      equ    %00100000
mSCI0CR1_SCISWAI:   equ    %01000000
mSCI0CR1_LOOPS:     equ    %10000000


;*** SCI0CR2 - SCI 0 Control Register 2; 0x000000CB ***
SCI0CR2:            equ    $000000CB                                ;*** SCI0CR2 - SCI 0 Control Register 2; 0x000000CB ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI0CR2_SBK:        equ    0                                         ; Send Break Bit
SCI0CR2_RWU:        equ    1                                         ; Receiver Wakeup Bit
SCI0CR2_RE:         equ    2                                         ; Receiver Enable Bit
SCI0CR2_TE:         equ    3                                         ; Transmitter Enable Bit
SCI0CR2_ILIE:       equ    4                                         ; Idle Line Interrupt Enable Bit
SCI0CR2_RIE:        equ    5                                         ; Receiver Full Interrupt Enable Bit
SCI0CR2_TCIE:       equ    6                                         ; Transmission Complete Interrupt Enable Bit
SCI0CR2_SCTIE:      equ    7                                         ; Transmitter Interrupt Enable Bit
; bit position masks
mSCI0CR2_SBK:       equ    %00000001
mSCI0CR2_RWU:       equ    %00000010
mSCI0CR2_RE:        equ    %00000100
mSCI0CR2_TE:        equ    %00001000
mSCI0CR2_ILIE:      equ    %00010000
mSCI0CR2_RIE:       equ    %00100000
mSCI0CR2_TCIE:      equ    %01000000
mSCI0CR2_SCTIE:     equ    %10000000


;*** SCI0SR1 - SCI 0 Status Register 1; 0x000000CC ***
SCI0SR1:            equ    $000000CC                                ;*** SCI0SR1 - SCI 0 Status Register 1; 0x000000CC ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI0SR1_PF:         equ    0                                         ; Parity Error Flag
SCI0SR1_FE:         equ    1                                         ; Framing Error Flag
SCI0SR1_NF:         equ    2                                         ; Noise Flag
SCI0SR1_OR:         equ    3                                         ; Overrun Flag
SCI0SR1_IDLE:       equ    4                                         ; Idle Line Flag
SCI0SR1_RDRF:       equ    5                                         ; Receive Data Register Full Flag
SCI0SR1_TC:         equ    6                                         ; Transmit Complete Flag
SCI0SR1_TDRE:       equ    7                                         ; Transmit Data Register Empty Flag
; bit position masks
mSCI0SR1_PF:        equ    %00000001
mSCI0SR1_FE:        equ    %00000010
mSCI0SR1_NF:        equ    %00000100
mSCI0SR1_OR:        equ    %00001000
mSCI0SR1_IDLE:      equ    %00010000
mSCI0SR1_RDRF:      equ    %00100000
mSCI0SR1_TC:        equ    %01000000
mSCI0SR1_TDRE:      equ    %10000000


;*** SCI0SR2 - SCI 0 Status Register 2; 0x000000CD ***
SCI0SR2:            equ    $000000CD                                ;*** SCI0SR2 - SCI 0 Status Register 2; 0x000000CD ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI0SR2_RAF:        equ    0                                         ; Receiver Active Flag
SCI0SR2_TXDIR:      equ    1                                         ; Transmitter pin data direction in Single-Wire mode
SCI0SR2_BRK13:      equ    2                                         ; Break Transmit character length
; bit position masks
mSCI0SR2_RAF:       equ    %00000001
mSCI0SR2_TXDIR:     equ    %00000010
mSCI0SR2_BRK13:     equ    %00000100


;*** SCI0DRH - SCI 0 Data Register High; 0x000000CE ***
SCI0DRH:            equ    $000000CE                                ;*** SCI0DRH - SCI 0 Data Register High; 0x000000CE ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI0DRH_T8:         equ    6                                         ; Transmit Bit 8
SCI0DRH_R8:         equ    7                                         ; Received Bit 8
; bit position masks
mSCI0DRH_T8:        equ    %01000000
mSCI0DRH_R8:        equ    %10000000


;*** SCI0DRL - SCI 0 Data Register Low; 0x000000CF ***
SCI0DRL:            equ    $000000CF                                ;*** SCI0DRL - SCI 0 Data Register Low; 0x000000CF ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI0DRL_R0_T0:      equ    0                                         ; Received bit 0 or Transmit bit 0
SCI0DRL_R1_T1:      equ    1                                         ; Received bit 1 or Transmit bit 1
SCI0DRL_R2_T2:      equ    2                                         ; Received bit 2 or Transmit bit 2
SCI0DRL_R3_T3:      equ    3                                         ; Received bit 3 or Transmit bit 3
SCI0DRL_R4_T4:      equ    4                                         ; Received bit 4 or Transmit bit 4
SCI0DRL_R5_T5:      equ    5                                         ; Received bit 5 or Transmit bit 5
SCI0DRL_R6_T6:      equ    6                                         ; Received bit 6 or Transmit bit 6
SCI0DRL_R7_T7:      equ    7                                         ; Received bit 7 or Transmit bit 7
; bit position masks
mSCI0DRL_R0_T0:     equ    %00000001
mSCI0DRL_R1_T1:     equ    %00000010
mSCI0DRL_R2_T2:     equ    %00000100
mSCI0DRL_R3_T3:     equ    %00001000
mSCI0DRL_R4_T4:     equ    %00010000
mSCI0DRL_R5_T5:     equ    %00100000
mSCI0DRL_R6_T6:     equ    %01000000
mSCI0DRL_R7_T7:     equ    %10000000


;*** SCI1BD - SCI 1 Baud Rate Register; 0x000000D0 ***
SCI1BD:             equ    $000000D0                                ;*** SCI1BD - SCI 1 Baud Rate Register; 0x000000D0 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI1BD_SBR0:        equ    0                                         ; SCI Baud Rate Bit 0
SCI1BD_SBR1:        equ    1                                         ; SCI Baud Rate Bit 1
SCI1BD_SBR2:        equ    2                                         ; SCI Baud Rate Bit 2
SCI1BD_SBR3:        equ    3                                         ; SCI Baud Rate Bit 3
SCI1BD_SBR4:        equ    4                                         ; SCI Baud Rate Bit 4
SCI1BD_SBR5:        equ    5                                         ; SCI Baud Rate Bit 5
SCI1BD_SBR6:        equ    6                                         ; SCI Baud Rate Bit 6
SCI1BD_SBR7:        equ    7                                         ; SCI Baud Rate Bit 7
SCI1BD_SBR8:        equ    8                                         ; SCI Baud Rate Bit 8
SCI1BD_SBR9:        equ    9                                         ; SCI Baud Rate Bit 9
SCI1BD_SBR10:       equ    10                                        ; SCI Baud Rate Bit 10
SCI1BD_SBR11:       equ    11                                        ; SCI Baud Rate Bit 11
SCI1BD_SBR12:       equ    12                                        ; SCI Baud Rate Bit 12
SCI1BD_TNP0:        equ    13                                        ; Transmitter Narrow Pulse Bit 0
SCI1BD_TNP1:        equ    14                                        ; Transmitter Narrow Pulse Bit 1
SCI1BD_IREN:        equ    15                                        ; Infrared Enable Bit
; bit position masks
mSCI1BD_SBR0:       equ    %00000001
mSCI1BD_SBR1:       equ    %00000010
mSCI1BD_SBR2:       equ    %00000100
mSCI1BD_SBR3:       equ    %00001000
mSCI1BD_SBR4:       equ    %00010000
mSCI1BD_SBR5:       equ    %00100000
mSCI1BD_SBR6:       equ    %01000000
mSCI1BD_SBR7:       equ    %10000000
mSCI1BD_SBR8:       equ    %100000000
mSCI1BD_SBR9:       equ    %1000000000
mSCI1BD_SBR10:      equ    %10000000000
mSCI1BD_SBR11:      equ    %100000000000
mSCI1BD_SBR12:      equ    %1000000000000
mSCI1BD_TNP0:       equ    %10000000000000
mSCI1BD_TNP1:       equ    %100000000000000
mSCI1BD_IREN:       equ    %1000000000000000


;*** SCI1BDH - SCI 1 Baud Rate Register High; 0x000000D0 ***
SCI1BDH:            equ    $000000D0                                ;*** SCI1BDH - SCI 1 Baud Rate Register High; 0x000000D0 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI1BDH_SBR8:       equ    0                                         ; SCI Baud Rate Bit 8
SCI1BDH_SBR9:       equ    1                                         ; SCI Baud Rate Bit 9
SCI1BDH_SBR10:      equ    2                                         ; SCI Baud Rate Bit 10
SCI1BDH_SBR11:      equ    3                                         ; SCI Baud Rate Bit 11
SCI1BDH_SBR12:      equ    4                                         ; SCI Baud Rate Bit 12
SCI1BDH_TNP0:       equ    5                                         ; Transmitter Narrow Pulse Bit 0
SCI1BDH_TNP1:       equ    6                                         ; Transmitter Narrow Pulse Bit 1
SCI1BDH_IREN:       equ    7                                         ; Infrared Enable Bit
; bit position masks
mSCI1BDH_SBR8:      equ    %00000001
mSCI1BDH_SBR9:      equ    %00000010
mSCI1BDH_SBR10:     equ    %00000100
mSCI1BDH_SBR11:     equ    %00001000
mSCI1BDH_SBR12:     equ    %00010000
mSCI1BDH_TNP0:      equ    %00100000
mSCI1BDH_TNP1:      equ    %01000000
mSCI1BDH_IREN:      equ    %10000000


;*** SCI1BDL - SCI 1 Baud Rate Register Low; 0x000000D1 ***
SCI1BDL:            equ    $000000D1                                ;*** SCI1BDL - SCI 1 Baud Rate Register Low; 0x000000D1 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI1BDL_SBR0:       equ    0                                         ; SCI Baud Rate Bit 0
SCI1BDL_SBR1:       equ    1                                         ; SCI Baud Rate Bit 1
SCI1BDL_SBR2:       equ    2                                         ; SCI Baud Rate Bit 2
SCI1BDL_SBR3:       equ    3                                         ; SCI Baud Rate Bit 3
SCI1BDL_SBR4:       equ    4                                         ; SCI Baud Rate Bit 4
SCI1BDL_SBR5:       equ    5                                         ; SCI Baud Rate Bit 5
SCI1BDL_SBR6:       equ    6                                         ; SCI Baud Rate Bit 6
SCI1BDL_SBR7:       equ    7                                         ; SCI Baud Rate Bit 7
; bit position masks
mSCI1BDL_SBR0:      equ    %00000001
mSCI1BDL_SBR1:      equ    %00000010
mSCI1BDL_SBR2:      equ    %00000100
mSCI1BDL_SBR3:      equ    %00001000
mSCI1BDL_SBR4:      equ    %00010000
mSCI1BDL_SBR5:      equ    %00100000
mSCI1BDL_SBR6:      equ    %01000000
mSCI1BDL_SBR7:      equ    %10000000


;*** SCI1CR1 - SCI 1 Control Register 1; 0x000000D2 ***
SCI1CR1:            equ    $000000D2                                ;*** SCI1CR1 - SCI 1 Control Register 1; 0x000000D2 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI1CR1_PT:         equ    0                                         ; Parity Type Bit
SCI1CR1_PE:         equ    1                                         ; Parity Enable Bit
SCI1CR1_ILT:        equ    2                                         ; Idle Line Type Bit
SCI1CR1_WAKE:       equ    3                                         ; Wakeup Condition Bit
SCI1CR1_M:          equ    4                                         ; Data Format Mode Bit
SCI1CR1_RSRC:       equ    5                                         ; Receiver Source Bit
SCI1CR1_SCISWAI:    equ    6                                         ; SCI Stop in Wait Mode Bit
SCI1CR1_LOOPS:      equ    7                                         ; Loop Select Bit
; bit position masks
mSCI1CR1_PT:        equ    %00000001
mSCI1CR1_PE:        equ    %00000010
mSCI1CR1_ILT:       equ    %00000100
mSCI1CR1_WAKE:      equ    %00001000
mSCI1CR1_M:         equ    %00010000
mSCI1CR1_RSRC:      equ    %00100000
mSCI1CR1_SCISWAI:   equ    %01000000
mSCI1CR1_LOOPS:     equ    %10000000


;*** SCI1CR2 - SCI 1 Control Register 2; 0x000000D3 ***
SCI1CR2:            equ    $000000D3                                ;*** SCI1CR2 - SCI 1 Control Register 2; 0x000000D3 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI1CR2_SBK:        equ    0                                         ; Send Break Bit
SCI1CR2_RWU:        equ    1                                         ; Receiver Wakeup Bit
SCI1CR2_RE:         equ    2                                         ; Receiver Enable Bit
SCI1CR2_TE:         equ    3                                         ; Transmitter Enable Bit
SCI1CR2_ILIE:       equ    4                                         ; Idle Line Interrupt Enable Bit
SCI1CR2_RIE:        equ    5                                         ; Receiver Full Interrupt Enable Bit
SCI1CR2_TCIE:       equ    6                                         ; Transmission Complete Interrupt Enable Bit
SCI1CR2_SCTIE:      equ    7                                         ; Transmitter Interrupt Enable Bit
; bit position masks
mSCI1CR2_SBK:       equ    %00000001
mSCI1CR2_RWU:       equ    %00000010
mSCI1CR2_RE:        equ    %00000100
mSCI1CR2_TE:        equ    %00001000
mSCI1CR2_ILIE:      equ    %00010000
mSCI1CR2_RIE:       equ    %00100000
mSCI1CR2_TCIE:      equ    %01000000
mSCI1CR2_SCTIE:     equ    %10000000


;*** SCI1SR1 - SCI 1 Status Register 1; 0x000000D4 ***
SCI1SR1:            equ    $000000D4                                ;*** SCI1SR1 - SCI 1 Status Register 1; 0x000000D4 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI1SR1_PF:         equ    0                                         ; Parity Error Flag
SCI1SR1_FE:         equ    1                                         ; Framing Error Flag
SCI1SR1_NF:         equ    2                                         ; Noise Flag
SCI1SR1_OR:         equ    3                                         ; Overrun Flag
SCI1SR1_IDLE:       equ    4                                         ; Idle Line Flag
SCI1SR1_RDRF:       equ    5                                         ; Receive Data Register Full Flag
SCI1SR1_TC:         equ    6                                         ; Transmit Complete Flag
SCI1SR1_TDRE:       equ    7                                         ; Transmit Data Register Empty Flag
; bit position masks
mSCI1SR1_PF:        equ    %00000001
mSCI1SR1_FE:        equ    %00000010
mSCI1SR1_NF:        equ    %00000100
mSCI1SR1_OR:        equ    %00001000
mSCI1SR1_IDLE:      equ    %00010000
mSCI1SR1_RDRF:      equ    %00100000
mSCI1SR1_TC:        equ    %01000000
mSCI1SR1_TDRE:      equ    %10000000


;*** SCI1SR2 - SCI 1 Status Register 2; 0x000000D5 ***
SCI1SR2:            equ    $000000D5                                ;*** SCI1SR2 - SCI 1 Status Register 2; 0x000000D5 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI1SR2_RAF:        equ    0                                         ; Receiver Active Flag
SCI1SR2_TXDIR:      equ    1                                         ; Transmitter pin data direction in Single-Wire mode
SCI1SR2_BRK13:      equ    2                                         ; Break Transmit character length
; bit position masks
mSCI1SR2_RAF:       equ    %00000001
mSCI1SR2_TXDIR:     equ    %00000010
mSCI1SR2_BRK13:     equ    %00000100


;*** SCI1DRH - SCI 1 Data Register High; 0x000000D6 ***
SCI1DRH:            equ    $000000D6                                ;*** SCI1DRH - SCI 1 Data Register High; 0x000000D6 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI1DRH_T8:         equ    6                                         ; Transmit Bit 8
SCI1DRH_R8:         equ    7                                         ; Received Bit 8
; bit position masks
mSCI1DRH_T8:        equ    %01000000
mSCI1DRH_R8:        equ    %10000000


;*** SCI1DRL - SCI 1 Data Register Low; 0x000000D7 ***
SCI1DRL:            equ    $000000D7                                ;*** SCI1DRL - SCI 1 Data Register Low; 0x000000D7 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI1DRL_R0_T0:      equ    0                                         ; Received bit 0 or Transmit bit 0
SCI1DRL_R1_T1:      equ    1                                         ; Received bit 1 or Transmit bit 1
SCI1DRL_R2_T2:      equ    2                                         ; Received bit 2 or Transmit bit 2
SCI1DRL_R3_T3:      equ    3                                         ; Received bit 3 or Transmit bit 3
SCI1DRL_R4_T4:      equ    4                                         ; Received bit 4 or Transmit bit 4
SCI1DRL_R5_T5:      equ    5                                         ; Received bit 5 or Transmit bit 5
SCI1DRL_R6_T6:      equ    6                                         ; Received bit 6 or Transmit bit 6
SCI1DRL_R7_T7:      equ    7                                         ; Received bit 7 or Transmit bit 7
; bit position masks
mSCI1DRL_R0_T0:     equ    %00000001
mSCI1DRL_R1_T1:     equ    %00000010
mSCI1DRL_R2_T2:     equ    %00000100
mSCI1DRL_R3_T3:     equ    %00001000
mSCI1DRL_R4_T4:     equ    %00010000
mSCI1DRL_R5_T5:     equ    %00100000
mSCI1DRL_R6_T6:     equ    %01000000
mSCI1DRL_R7_T7:     equ    %10000000


;*** SPICR1 - SPI Control Register; 0x000000D8 ***
SPICR1:             equ    $000000D8                                ;*** SPICR1 - SPI Control Register; 0x000000D8 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPICR1_LSBFE:       equ    0                                         ; SPI LSB-First Enable
SPICR1_SSOE:        equ    1                                         ; Slave Select Output Enable
SPICR1_CPHA:        equ    2                                         ; SPI Clock Phase Bit
SPICR1_CPOL:        equ    3                                         ; SPI Clock Polarity Bit
SPICR1_MSTR:        equ    4                                         ; SPI Master/Slave Mode Select Bit
SPICR1_SPTIE:       equ    5                                         ; SPI Transmit Interrupt Enable
SPICR1_SPE:         equ    6                                         ; SPI System Enable Bit
SPICR1_SPIE:        equ    7                                         ; SPI Interrupt Enable Bit
; bit position masks
mSPICR1_LSBFE:      equ    %00000001
mSPICR1_SSOE:       equ    %00000010
mSPICR1_CPHA:       equ    %00000100
mSPICR1_CPOL:       equ    %00001000
mSPICR1_MSTR:       equ    %00010000
mSPICR1_SPTIE:      equ    %00100000
mSPICR1_SPE:        equ    %01000000
mSPICR1_SPIE:       equ    %10000000


;*** SPICR2 - SPI Control Register 2; 0x000000D9 ***
SPICR2:             equ    $000000D9                                ;*** SPICR2 - SPI Control Register 2; 0x000000D9 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPICR2_SPC0:        equ    0                                         ; Serial Pin Control Bit 0
SPICR2_SPISWAI:     equ    1                                         ; SPI Stop in Wait Mode Bit
SPICR2_BIDIROE:     equ    3                                         ; Output enable in the Bidirectional mode of operation
SPICR2_MODFEN:      equ    4                                         ; Mode Fault Enable Bit
; bit position masks
mSPICR2_SPC0:       equ    %00000001
mSPICR2_SPISWAI:    equ    %00000010
mSPICR2_BIDIROE:    equ    %00001000
mSPICR2_MODFEN:     equ    %00010000


;*** SPIBR - SPI Baud Rate Register; 0x000000DA ***
SPIBR:              equ    $000000DA                                ;*** SPIBR - SPI Baud Rate Register; 0x000000DA ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPIBR_SPR0:         equ    0                                         ; SPI Baud Rate Selection Bit 0
SPIBR_SPR1:         equ    1                                         ; SPI Baud Rate Selection Bit 1
SPIBR_SPR2:         equ    2                                         ; SPI Baud Rate Selection Bit 2
SPIBR_SPPR0:        equ    4                                         ; SPI Baud Rate Preselection Bits 0
SPIBR_SPPR1:        equ    5                                         ; SPI Baud Rate Preselection Bits 1
SPIBR_SPPR2:        equ    6                                         ; SPI Baud Rate Preselection Bits 2
; bit position masks
mSPIBR_SPR0:        equ    %00000001
mSPIBR_SPR1:        equ    %00000010
mSPIBR_SPR2:        equ    %00000100
mSPIBR_SPPR0:       equ    %00010000
mSPIBR_SPPR1:       equ    %00100000
mSPIBR_SPPR2:       equ    %01000000


;*** SPISR - SPI Status Register; 0x000000DB ***
SPISR:              equ    $000000DB                                ;*** SPISR - SPI Status Register; 0x000000DB ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPISR_MODF:         equ    4                                         ; Mode Fault Flag
SPISR_SPTEF:        equ    5                                         ; SPI Transmit Empty Interrupt Flag
SPISR_SPIF:         equ    7                                         ; SPIF Receive Interrupt Flag
; bit position masks
mSPISR_MODF:        equ    %00010000
mSPISR_SPTEF:       equ    %00100000
mSPISR_SPIF:        equ    %10000000


;*** SPIDR - SPI Data Register; 0x000000DD ***
SPIDR:              equ    $000000DD                                ;*** SPIDR - SPI Data Register; 0x000000DD ***


;*** IBAD - IIC Address Register; 0x000000E0 ***
IBAD:               equ    $000000E0                                ;*** IBAD - IIC Address Register; 0x000000E0 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
IBAD_ADR1:          equ    1                                         ; Slave Address Bit 1
IBAD_ADR2:          equ    2                                         ; Slave Address Bit 2
IBAD_ADR3:          equ    3                                         ; Slave Address Bit 3
IBAD_ADR4:          equ    4                                         ; Slave Address Bit 4
IBAD_ADR5:          equ    5                                         ; Slave Address Bit 5
IBAD_ADR6:          equ    6                                         ; Slave Address Bit 6
IBAD_ADR7:          equ    7                                         ; Slave Address Bit 7
; bit position masks
mIBAD_ADR1:         equ    %00000010
mIBAD_ADR2:         equ    %00000100
mIBAD_ADR3:         equ    %00001000
mIBAD_ADR4:         equ    %00010000
mIBAD_ADR5:         equ    %00100000
mIBAD_ADR6:         equ    %01000000
mIBAD_ADR7:         equ    %10000000


;*** IBFD - IIC Frequency Divider Register; 0x000000E1 ***
IBFD:               equ    $000000E1                                ;*** IBFD - IIC Frequency Divider Register; 0x000000E1 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
IBFD_IBC0:          equ    0                                         ; I-Bus Clock Rate 0
IBFD_IBC1:          equ    1                                         ; I-Bus Clock Rate 1
IBFD_IBC2:          equ    2                                         ; I-Bus Clock Rate 2
IBFD_IBC3:          equ    3                                         ; I-Bus Clock Rate 3
IBFD_IBC4:          equ    4                                         ; I-Bus Clock Rate 4
IBFD_IBC5:          equ    5                                         ; I-Bus Clock Rate 5
IBFD_IBC6:          equ    6                                         ; I-Bus Clock Rate 6
IBFD_IBC7:          equ    7                                         ; I-Bus Clock Rate 7
; bit position masks
mIBFD_IBC0:         equ    %00000001
mIBFD_IBC1:         equ    %00000010
mIBFD_IBC2:         equ    %00000100
mIBFD_IBC3:         equ    %00001000
mIBFD_IBC4:         equ    %00010000
mIBFD_IBC5:         equ    %00100000
mIBFD_IBC6:         equ    %01000000
mIBFD_IBC7:         equ    %10000000


;*** IBCR - IIC Control Register; 0x000000E2 ***
IBCR:               equ    $000000E2                                ;*** IBCR - IIC Control Register; 0x000000E2 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
IBCR_IBSWAI:        equ    0                                         ; I-Bus Interface Stop in WAIT mode
IBCR_RSTA:          equ    2                                         ; Repeat Start
IBCR_TXAK:          equ    3                                         ; Transmit Acknowledge enable
IBCR_TX_RX:         equ    4                                         ; Transmit/Receive mode select bit
IBCR_MS_SL:         equ    5                                         ; Master/Slave mode select bit
IBCR_IBIE:          equ    6                                         ; I-Bus Interrupt Enable
IBCR_IBEN:          equ    7                                         ; I-Bus Enable
; bit position masks
mIBCR_IBSWAI:       equ    %00000001
mIBCR_RSTA:         equ    %00000100
mIBCR_TXAK:         equ    %00001000
mIBCR_TX_RX:        equ    %00010000
mIBCR_MS_SL:        equ    %00100000
mIBCR_IBIE:         equ    %01000000
mIBCR_IBEN:         equ    %10000000


;*** IBSR - IIC Status Register; 0x000000E3 ***
IBSR:               equ    $000000E3                                ;*** IBSR - IIC Status Register; 0x000000E3 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
IBSR_RXAK:          equ    0                                         ; Received Acknowledge
IBSR_IBIF:          equ    1                                         ; I-Bus Interrupt
IBSR_SRW:           equ    2                                         ; Slave Read/Write
IBSR_IBAL:          equ    4                                         ; Arbitration Lost
IBSR_IBB:           equ    5                                         ; Bus busy bit
IBSR_IAAS:          equ    6                                         ; Addressed as a slave bit
IBSR_TCF:           equ    7                                         ; Data transferring bit
; bit position masks
mIBSR_RXAK:         equ    %00000001
mIBSR_IBIF:         equ    %00000010
mIBSR_SRW:          equ    %00000100
mIBSR_IBAL:         equ    %00010000
mIBSR_IBB:          equ    %00100000
mIBSR_IAAS:         equ    %01000000
mIBSR_TCF:          equ    %10000000


;*** IBDR - IIC Data I/O Register; 0x000000E4 ***
IBDR:               equ    $000000E4                                ;*** IBDR - IIC Data I/O Register; 0x000000E4 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
IBDR_D0:            equ    0                                         ; IIC Data Bit 0
IBDR_D1:            equ    1                                         ; IIC Data Bit 1
IBDR_D2:            equ    2                                         ; IIC Data Bit 2
IBDR_D3:            equ    3                                         ; IIC Data Bit 3
IBDR_D4:            equ    4                                         ; IIC Data Bit 4
IBDR_D5:            equ    5                                         ; IIC Data Bit 5
IBDR_D6:            equ    6                                         ; IIC Data Bit 6
IBDR_D7:            equ    7                                         ; IIC Data Bit 7
; bit position masks
mIBDR_D0:           equ    %00000001
mIBDR_D1:           equ    %00000010
mIBDR_D2:           equ    %00000100
mIBDR_D3:           equ    %00001000
mIBDR_D4:           equ    %00010000
mIBDR_D5:           equ    %00100000
mIBDR_D6:           equ    %01000000
mIBDR_D7:           equ    %10000000


;*** SCI2BD - SCI 2 Baud Rate Register; 0x000000E8 ***
SCI2BD:             equ    $000000E8                                ;*** SCI2BD - SCI 2 Baud Rate Register; 0x000000E8 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI2BD_SBR0:        equ    0                                         ; SCI Baud Rate Bit 0
SCI2BD_SBR1:        equ    1                                         ; SCI Baud Rate Bit 1
SCI2BD_SBR2:        equ    2                                         ; SCI Baud Rate Bit 2
SCI2BD_SBR3:        equ    3                                         ; SCI Baud Rate Bit 3
SCI2BD_SBR4:        equ    4                                         ; SCI Baud Rate Bit 4
SCI2BD_SBR5:        equ    5                                         ; SCI Baud Rate Bit 5
SCI2BD_SBR6:        equ    6                                         ; SCI Baud Rate Bit 6
SCI2BD_SBR7:        equ    7                                         ; SCI Baud Rate Bit 7
SCI2BD_SBR8:        equ    8                                         ; SCI Baud Rate Bit 8
SCI2BD_SBR9:        equ    9                                         ; SCI Baud Rate Bit 9
SCI2BD_SBR10:       equ    10                                        ; SCI Baud Rate Bit 10
SCI2BD_SBR11:       equ    11                                        ; SCI Baud Rate Bit 11
SCI2BD_SBR12:       equ    12                                        ; SCI Baud Rate Bit 12
SCI2BD_TNP0:        equ    13                                        ; Transmitter Narrow Pulse Bit 0
SCI2BD_TNP1:        equ    14                                        ; Transmitter Narrow Pulse Bit 1
SCI2BD_IREN:        equ    15                                        ; Infrared Enable Bit
; bit position masks
mSCI2BD_SBR0:       equ    %00000001
mSCI2BD_SBR1:       equ    %00000010
mSCI2BD_SBR2:       equ    %00000100
mSCI2BD_SBR3:       equ    %00001000
mSCI2BD_SBR4:       equ    %00010000
mSCI2BD_SBR5:       equ    %00100000
mSCI2BD_SBR6:       equ    %01000000
mSCI2BD_SBR7:       equ    %10000000
mSCI2BD_SBR8:       equ    %100000000
mSCI2BD_SBR9:       equ    %1000000000
mSCI2BD_SBR10:      equ    %10000000000
mSCI2BD_SBR11:      equ    %100000000000
mSCI2BD_SBR12:      equ    %1000000000000
mSCI2BD_TNP0:       equ    %10000000000000
mSCI2BD_TNP1:       equ    %100000000000000
mSCI2BD_IREN:       equ    %1000000000000000


;*** SCI2BDH - SCI 2 Baud Rate Register High; 0x000000E8 ***
SCI2BDH:            equ    $000000E8                                ;*** SCI2BDH - SCI 2 Baud Rate Register High; 0x000000E8 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI2BDH_SBR8:       equ    0                                         ; SCI Baud Rate Bit 8
SCI2BDH_SBR9:       equ    1                                         ; SCI Baud Rate Bit 9
SCI2BDH_SBR10:      equ    2                                         ; SCI Baud Rate Bit 10
SCI2BDH_SBR11:      equ    3                                         ; SCI Baud Rate Bit 11
SCI2BDH_SBR12:      equ    4                                         ; SCI Baud Rate Bit 12
SCI2BDH_TNP0:       equ    5                                         ; Transmitter Narrow Pulse Bit 0
SCI2BDH_TNP1:       equ    6                                         ; Transmitter Narrow Pulse Bit 1
SCI2BDH_IREN:       equ    7                                         ; Infrared Enable Bit
; bit position masks
mSCI2BDH_SBR8:      equ    %00000001
mSCI2BDH_SBR9:      equ    %00000010
mSCI2BDH_SBR10:     equ    %00000100
mSCI2BDH_SBR11:     equ    %00001000
mSCI2BDH_SBR12:     equ    %00010000
mSCI2BDH_TNP0:      equ    %00100000
mSCI2BDH_TNP1:      equ    %01000000
mSCI2BDH_IREN:      equ    %10000000


;*** SCI2BDL - SCI 2 Baud Rate Register Low; 0x000000E9 ***
SCI2BDL:            equ    $000000E9                                ;*** SCI2BDL - SCI 2 Baud Rate Register Low; 0x000000E9 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI2BDL_SBR0:       equ    0                                         ; SCI Baud Rate Bit 0
SCI2BDL_SBR1:       equ    1                                         ; SCI Baud Rate Bit 1
SCI2BDL_SBR2:       equ    2                                         ; SCI Baud Rate Bit 2
SCI2BDL_SBR3:       equ    3                                         ; SCI Baud Rate Bit 3
SCI2BDL_SBR4:       equ    4                                         ; SCI Baud Rate Bit 4
SCI2BDL_SBR5:       equ    5                                         ; SCI Baud Rate Bit 5
SCI2BDL_SBR6:       equ    6                                         ; SCI Baud Rate Bit 6
SCI2BDL_SBR7:       equ    7                                         ; SCI Baud Rate Bit 7
; bit position masks
mSCI2BDL_SBR0:      equ    %00000001
mSCI2BDL_SBR1:      equ    %00000010
mSCI2BDL_SBR2:      equ    %00000100
mSCI2BDL_SBR3:      equ    %00001000
mSCI2BDL_SBR4:      equ    %00010000
mSCI2BDL_SBR5:      equ    %00100000
mSCI2BDL_SBR6:      equ    %01000000
mSCI2BDL_SBR7:      equ    %10000000


;*** SCI2CR1 - SCI 2 Control Register 1; 0x000000EA ***
SCI2CR1:            equ    $000000EA                                ;*** SCI2CR1 - SCI 2 Control Register 1; 0x000000EA ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI2CR1_PT:         equ    0                                         ; Parity Type Bit
SCI2CR1_PE:         equ    1                                         ; Parity Enable Bit
SCI2CR1_ILT:        equ    2                                         ; Idle Line Type Bit
SCI2CR1_WAKE:       equ    3                                         ; Wakeup Condition Bit
SCI2CR1_M:          equ    4                                         ; Data Format Mode Bit
SCI2CR1_RSRC:       equ    5                                         ; Receiver Source Bit
SCI2CR1_SCISWAI:    equ    6                                         ; SCI Stop in Wait Mode Bit
SCI2CR1_LOOPS:      equ    7                                         ; Loop Select Bit
; bit position masks
mSCI2CR1_PT:        equ    %00000001
mSCI2CR1_PE:        equ    %00000010
mSCI2CR1_ILT:       equ    %00000100
mSCI2CR1_WAKE:      equ    %00001000
mSCI2CR1_M:         equ    %00010000
mSCI2CR1_RSRC:      equ    %00100000
mSCI2CR1_SCISWAI:   equ    %01000000
mSCI2CR1_LOOPS:     equ    %10000000


;*** SCI2CR2 - SCI 2 Control Register 2; 0x000000EB ***
SCI2CR2:            equ    $000000EB                                ;*** SCI2CR2 - SCI 2 Control Register 2; 0x000000EB ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI2CR2_SBK:        equ    0                                         ; Send Break Bit
SCI2CR2_RWU:        equ    1                                         ; Receiver Wakeup Bit
SCI2CR2_RE:         equ    2                                         ; Receiver Enable Bit
SCI2CR2_TE:         equ    3                                         ; Transmitter Enable Bit
SCI2CR2_ILIE:       equ    4                                         ; Idle Line Interrupt Enable Bit
SCI2CR2_RIE:        equ    5                                         ; Receiver Full Interrupt Enable Bit
SCI2CR2_TCIE:       equ    6                                         ; Transmission Complete Interrupt Enable Bit
SCI2CR2_SCTIE:      equ    7                                         ; Transmitter Interrupt Enable Bit
; bit position masks
mSCI2CR2_SBK:       equ    %00000001
mSCI2CR2_RWU:       equ    %00000010
mSCI2CR2_RE:        equ    %00000100
mSCI2CR2_TE:        equ    %00001000
mSCI2CR2_ILIE:      equ    %00010000
mSCI2CR2_RIE:       equ    %00100000
mSCI2CR2_TCIE:      equ    %01000000
mSCI2CR2_SCTIE:     equ    %10000000


;*** SCI2SR1 - SCI 2 Status Register 1; 0x000000EC ***
SCI2SR1:            equ    $000000EC                                ;*** SCI2SR1 - SCI 2 Status Register 1; 0x000000EC ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI2SR1_PF:         equ    0                                         ; Parity Error Flag
SCI2SR1_FE:         equ    1                                         ; Framing Error Flag
SCI2SR1_NF:         equ    2                                         ; Noise Flag
SCI2SR1_OR:         equ    3                                         ; Overrun Flag
SCI2SR1_IDLE:       equ    4                                         ; Idle Line Flag
SCI2SR1_RDRF:       equ    5                                         ; Receive Data Register Full Flag
SCI2SR1_TC:         equ    6                                         ; Transmit Complete Flag
SCI2SR1_TDRE:       equ    7                                         ; Transmit Data Register Empty Flag
; bit position masks
mSCI2SR1_PF:        equ    %00000001
mSCI2SR1_FE:        equ    %00000010
mSCI2SR1_NF:        equ    %00000100
mSCI2SR1_OR:        equ    %00001000
mSCI2SR1_IDLE:      equ    %00010000
mSCI2SR1_RDRF:      equ    %00100000
mSCI2SR1_TC:        equ    %01000000
mSCI2SR1_TDRE:      equ    %10000000


;*** SCI2SR2 - SCI 2 Status Register 2; 0x000000ED ***
SCI2SR2:            equ    $000000ED                                ;*** SCI2SR2 - SCI 2 Status Register 2; 0x000000ED ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI2SR2_RAF:        equ    0                                         ; Receiver Active Flag
SCI2SR2_TXDIR:      equ    1                                         ; Transmitter pin data direction in Single-Wire mode
SCI2SR2_BRK13:      equ    2                                         ; Break Transmit character length
; bit position masks
mSCI2SR2_RAF:       equ    %00000001
mSCI2SR2_TXDIR:     equ    %00000010
mSCI2SR2_BRK13:     equ    %00000100


;*** SCI2DRH - SCI 2 Data Register High; 0x000000EE ***
SCI2DRH:            equ    $000000EE                                ;*** SCI2DRH - SCI 2 Data Register High; 0x000000EE ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI2DRH_T8:         equ    6                                         ; Transmit Bit 8
SCI2DRH_R8:         equ    7                                         ; Received Bit 8
; bit position masks
mSCI2DRH_T8:        equ    %01000000
mSCI2DRH_R8:        equ    %10000000


;*** SCI2DRL - SCI 2 Data Register Low; 0x000000EF ***
SCI2DRL:            equ    $000000EF                                ;*** SCI2DRL - SCI 2 Data Register Low; 0x000000EF ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI2DRL_R0_T0:      equ    0                                         ; Received bit 0 or Transmit bit 0
SCI2DRL_R1_T1:      equ    1                                         ; Received bit 1 or Transmit bit 1
SCI2DRL_R2_T2:      equ    2                                         ; Received bit 2 or Transmit bit 2
SCI2DRL_R3_T3:      equ    3                                         ; Received bit 3 or Transmit bit 3
SCI2DRL_R4_T4:      equ    4                                         ; Received bit 4 or Transmit bit 4
SCI2DRL_R5_T5:      equ    5                                         ; Received bit 5 or Transmit bit 5
SCI2DRL_R6_T6:      equ    6                                         ; Received bit 6 or Transmit bit 6
SCI2DRL_R7_T7:      equ    7                                         ; Received bit 7 or Transmit bit 7
; bit position masks
mSCI2DRL_R0_T0:     equ    %00000001
mSCI2DRL_R1_T1:     equ    %00000010
mSCI2DRL_R2_T2:     equ    %00000100
mSCI2DRL_R3_T3:     equ    %00001000
mSCI2DRL_R4_T4:     equ    %00010000
mSCI2DRL_R5_T5:     equ    %00100000
mSCI2DRL_R6_T6:     equ    %01000000
mSCI2DRL_R7_T7:     equ    %10000000


;*** DAC0_DACC0 - DAC0 Control Register 0; 0x000000F0 ***
DAC0_DACC0:         equ    $000000F0                                ;*** DAC0_DACC0 - DAC0 Control Register 0; 0x000000F0 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DAC0_DACC0_DACOE:   equ    0                                         ; DAC Output Enable
DAC0_DACC0_DACWAI:  equ    1                                         ; DAC Stop in WAIT mode
DAC0_DACC0_DSGN:    equ    2                                         ; Result Register Data Signed or Unsigned Representation
DAC0_DACC0_DJM:     equ    3                                         ; Data Register Data Justification
DAC0_DACC0_DACTE:   equ    6                                         ; DAC Test Enable
DAC0_DACC0_DACE:    equ    7                                         ; DAC Enable
; bit position masks
mDAC0_DACC0_DACOE:  equ    %00000001
mDAC0_DACC0_DACWAI: equ    %00000010
mDAC0_DACC0_DSGN:   equ    %00000100
mDAC0_DACC0_DJM:    equ    %00001000
mDAC0_DACC0_DACTE:  equ    %01000000
mDAC0_DACC0_DACE:   equ    %10000000


;*** DAC0_DACDLeft - DAC0 Data Register - Left Justified; 0x000000F2 ***
DAC0_DACDLeft:      equ    $000000F2                                ;*** DAC0_DACDLeft - DAC0 Data Register - Left Justified; 0x000000F2 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DAC0_DACDLeft_BIT0: equ    0                                         ; Data Bit 0
DAC0_DACDLeft_BIT1: equ    1                                         ; Data Bit 1
DAC0_DACDLeft_BIT2: equ    2                                         ; Data Bit 2
DAC0_DACDLeft_BIT3: equ    3                                         ; Data Bit 3
DAC0_DACDLeft_BIT4: equ    4                                         ; Data Bit 4
DAC0_DACDLeft_BIT5: equ    5                                         ; Data Bit 5
DAC0_DACDLeft_BIT6: equ    6                                         ; Data Bit 6
DAC0_DACDLeft_BIT7: equ    7                                         ; Data Bit 7
; bit position masks
mDAC0_DACDLeft_BIT0: equ    %00000001
mDAC0_DACDLeft_BIT1: equ    %00000010
mDAC0_DACDLeft_BIT2: equ    %00000100
mDAC0_DACDLeft_BIT3: equ    %00001000
mDAC0_DACDLeft_BIT4: equ    %00010000
mDAC0_DACDLeft_BIT5: equ    %00100000
mDAC0_DACDLeft_BIT6: equ    %01000000
mDAC0_DACDLeft_BIT7: equ    %10000000


;*** DAC0_DACDRight - DAC0 Data Register - Right Justified; 0x000000F3 ***
DAC0_DACDRight:     equ    $000000F3                                ;*** DAC0_DACDRight - DAC0 Data Register - Right Justified; 0x000000F3 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DAC0_DACDRight_BIT0: equ    0                                        ; Data Bit 0
DAC0_DACDRight_BIT1: equ    1                                        ; Data Bit 1
DAC0_DACDRight_BIT2: equ    2                                        ; Data Bit 2
DAC0_DACDRight_BIT3: equ    3                                        ; Data Bit 3
DAC0_DACDRight_BIT4: equ    4                                        ; Data Bit 4
DAC0_DACDRight_BIT5: equ    5                                        ; Data Bit 5
DAC0_DACDRight_BIT6: equ    6                                        ; Data Bit 6
DAC0_DACDRight_BIT7: equ    7                                        ; Data Bit 7
; bit position masks
mDAC0_DACDRight_BIT0: equ    %00000001
mDAC0_DACDRight_BIT1: equ    %00000010
mDAC0_DACDRight_BIT2: equ    %00000100
mDAC0_DACDRight_BIT3: equ    %00001000
mDAC0_DACDRight_BIT4: equ    %00010000
mDAC0_DACDRight_BIT5: equ    %00100000
mDAC0_DACDRight_BIT6: equ    %01000000
mDAC0_DACDRight_BIT7: equ    %10000000


;*** DAC1_DACC0 - DAC1Control Register 0; 0x000000F4 ***
DAC1_DACC0:         equ    $000000F4                                ;*** DAC1_DACC0 - DAC1Control Register 0; 0x000000F4 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DAC1_DACC0_DACOE:   equ    0                                         ; DAC Output Enable
DAC1_DACC0_DACWAI:  equ    1                                         ; DAC Stop in WAIT mode
DAC1_DACC0_DSGN:    equ    2                                         ; Result Register Data Signed or Unsigned Representation
DAC1_DACC0_DJM:     equ    3                                         ; Data Register Data Justification
DAC1_DACC0_DACTE:   equ    6                                         ; DAC Test Enable
DAC1_DACC0_DACE:    equ    7                                         ; DAC Enable
; bit position masks
mDAC1_DACC0_DACOE:  equ    %00000001
mDAC1_DACC0_DACWAI: equ    %00000010
mDAC1_DACC0_DSGN:   equ    %00000100
mDAC1_DACC0_DJM:    equ    %00001000
mDAC1_DACC0_DACTE:  equ    %01000000
mDAC1_DACC0_DACE:   equ    %10000000


;*** DAC1_DACDLeft - DAC1 Data Register - Left Justified; 0x000000F6 ***
DAC1_DACDLeft:      equ    $000000F6                                ;*** DAC1_DACDLeft - DAC1 Data Register - Left Justified; 0x000000F6 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DAC1_DACDLeft_BIT0: equ    0                                         ; Data Bit 0
DAC1_DACDLeft_BIT1: equ    1                                         ; Data Bit 1
DAC1_DACDLeft_BIT2: equ    2                                         ; Data Bit 2
DAC1_DACDLeft_BIT3: equ    3                                         ; Data Bit 3
DAC1_DACDLeft_BIT4: equ    4                                         ; Data Bit 4
DAC1_DACDLeft_BIT5: equ    5                                         ; Data Bit 5
DAC1_DACDLeft_BIT6: equ    6                                         ; Data Bit 6
DAC1_DACDLeft_BIT7: equ    7                                         ; Data Bit 7
; bit position masks
mDAC1_DACDLeft_BIT0: equ    %00000001
mDAC1_DACDLeft_BIT1: equ    %00000010
mDAC1_DACDLeft_BIT2: equ    %00000100
mDAC1_DACDLeft_BIT3: equ    %00001000
mDAC1_DACDLeft_BIT4: equ    %00010000
mDAC1_DACDLeft_BIT5: equ    %00100000
mDAC1_DACDLeft_BIT6: equ    %01000000
mDAC1_DACDLeft_BIT7: equ    %10000000


;*** DAC1_DACDRight - DAC1 Data Register - Right Justified; 0x000000F7 ***
DAC1_DACDRight:     equ    $000000F7                                ;*** DAC1_DACDRight - DAC1 Data Register - Right Justified; 0x000000F7 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DAC1_DACDRight_BIT0: equ    0                                        ; Data Bit 0
DAC1_DACDRight_BIT1: equ    1                                        ; Data Bit 1
DAC1_DACDRight_BIT2: equ    2                                        ; Data Bit 2
DAC1_DACDRight_BIT3: equ    3                                        ; Data Bit 3
DAC1_DACDRight_BIT4: equ    4                                        ; Data Bit 4
DAC1_DACDRight_BIT5: equ    5                                        ; Data Bit 5
DAC1_DACDRight_BIT6: equ    6                                        ; Data Bit 6
DAC1_DACDRight_BIT7: equ    7                                        ; Data Bit 7
; bit position masks
mDAC1_DACDRight_BIT0: equ    %00000001
mDAC1_DACDRight_BIT1: equ    %00000010
mDAC1_DACDRight_BIT2: equ    %00000100
mDAC1_DACDRight_BIT3: equ    %00001000
mDAC1_DACDRight_BIT4: equ    %00010000
mDAC1_DACDRight_BIT5: equ    %00100000
mDAC1_DACDRight_BIT6: equ    %01000000
mDAC1_DACDRight_BIT7: equ    %10000000


;*** FCLKDIV - Flash Clock Divider Register; 0x00000100 ***
FCLKDIV:            equ    $00000100                                ;*** FCLKDIV - Flash Clock Divider Register; 0x00000100 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FCLKDIV_FDIV0:      equ    0                                         ; Flash Clock Divider Bit 0
FCLKDIV_FDIV1:      equ    1                                         ; Flash Clock Divider Bit 1
FCLKDIV_FDIV2:      equ    2                                         ; Flash Clock Divider Bit 2
FCLKDIV_FDIV3:      equ    3                                         ; Flash Clock Divider Bit 3
FCLKDIV_FDIV4:      equ    4                                         ; Flash Clock Divider Bit 4
FCLKDIV_FDIV5:      equ    5                                         ; Flash Clock Divider Bit 5
FCLKDIV_PRDIV8:     equ    6                                         ; Enable Prescaler by 8
FCLKDIV_FDIVLD:     equ    7                                         ; Flash Clock Divider Loaded
; bit position masks
mFCLKDIV_FDIV0:     equ    %00000001
mFCLKDIV_FDIV1:     equ    %00000010
mFCLKDIV_FDIV2:     equ    %00000100
mFCLKDIV_FDIV3:     equ    %00001000
mFCLKDIV_FDIV4:     equ    %00010000
mFCLKDIV_FDIV5:     equ    %00100000
mFCLKDIV_PRDIV8:    equ    %01000000
mFCLKDIV_FDIVLD:    equ    %10000000


;*** FSEC - Flash Security Register; 0x00000101 ***
FSEC:               equ    $00000101                                ;*** FSEC - Flash Security Register; 0x00000101 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FSEC_SEC0:          equ    0                                         ; Memory security bit 0
FSEC_SEC1:          equ    1                                         ; Memory security bit 1
FSEC_NV2:           equ    2                                         ; Non Volatile flag bit 2
FSEC_NV3:           equ    3                                         ; Non Volatile flag bit 3
FSEC_NV4:           equ    4                                         ; Non Volatile flag bit 4
FSEC_NV5:           equ    5                                         ; Non Volatile flag bit 5
FSEC_NV6:           equ    6                                         ; Non Volatile flag bit 6
FSEC_KEYEN:         equ    7                                         ; Backdoor Key Security Enable
; bit position masks
mFSEC_SEC0:         equ    %00000001
mFSEC_SEC1:         equ    %00000010
mFSEC_NV2:          equ    %00000100
mFSEC_NV3:          equ    %00001000
mFSEC_NV4:          equ    %00010000
mFSEC_NV5:          equ    %00100000
mFSEC_NV6:          equ    %01000000
mFSEC_KEYEN:        equ    %10000000


;*** FCNFG - Flash Configuration Register; 0x00000103 ***
FCNFG:              equ    $00000103                                ;*** FCNFG - Flash Configuration Register; 0x00000103 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FCNFG_KEYACC:       equ    5                                         ; Enable Security Key Writing
FCNFG_CCIE:         equ    6                                         ; Command Complete Interrupt Enable
FCNFG_CBEIE:        equ    7                                         ; Command Buffers Empty Interrupt Enable
; bit position masks
mFCNFG_KEYACC:      equ    %00100000
mFCNFG_CCIE:        equ    %01000000
mFCNFG_CBEIE:       equ    %10000000


;*** FPROT - Flash Protection Register; 0x00000104 ***
FPROT:              equ    $00000104                                ;*** FPROT - Flash Protection Register; 0x00000104 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FPROT_FPLS0:        equ    0                                         ; Flash Protection Lower Address size 0
FPROT_FPLS1:        equ    1                                         ; Flash Protection Lower Address size 1
FPROT_FPLDIS:       equ    2                                         ; Flash Protection Lower address range disable
FPROT_FPHS0:        equ    3                                         ; Flash Protection Higher address size 0
FPROT_FPHS1:        equ    4                                         ; Flash Protection Higher address size 1
FPROT_FPHDIS:       equ    5                                         ; Flash Protection Higher address range disable
FPROT_NV6:          equ    6                                         ; Non Volatile Flag Bit
FPROT_FPOPEN:       equ    7                                         ; Opens the flash block or subsections of it for program or erase
; bit position masks
mFPROT_FPLS0:       equ    %00000001
mFPROT_FPLS1:       equ    %00000010
mFPROT_FPLDIS:      equ    %00000100
mFPROT_FPHS0:       equ    %00001000
mFPROT_FPHS1:       equ    %00010000
mFPROT_FPHDIS:      equ    %00100000
mFPROT_NV6:         equ    %01000000
mFPROT_FPOPEN:      equ    %10000000


;*** FSTAT - Flash Status Register; 0x00000105 ***
FSTAT:              equ    $00000105                                ;*** FSTAT - Flash Status Register; 0x00000105 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FSTAT_BLANK:        equ    2                                         ; Blank Verify Flag
FSTAT_ACCERR:       equ    4                                         ; Access error
FSTAT_PVIOL:        equ    5                                         ; Protection violation
FSTAT_CCIF:         equ    6                                         ; Command Complete Interrupt Flag
FSTAT_CBEIF:        equ    7                                         ; Command Buffers Empty Interrupt Flag
; bit position masks
mFSTAT_BLANK:       equ    %00000100
mFSTAT_ACCERR:      equ    %00010000
mFSTAT_PVIOL:       equ    %00100000
mFSTAT_CCIF:        equ    %01000000
mFSTAT_CBEIF:       equ    %10000000


;*** FCMD - Flash Command Buffer and Register; 0x00000106 ***
FCMD:               equ    $00000106                                ;*** FCMD - Flash Command Buffer and Register; 0x00000106 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FCMD_CMDB0:         equ    0                                         ; NVM User Mode Command Bit 0
FCMD_CMDB2:         equ    2                                         ; NVM User Mode Command Bit 2
FCMD_CMDB5:         equ    5                                         ; NVM User Mode Command Bit 5
FCMD_CMDB6:         equ    6                                         ; NVM User Mode Command Bit 6
; bit position masks
mFCMD_CMDB0:        equ    %00000001
mFCMD_CMDB2:        equ    %00000100
mFCMD_CMDB5:        equ    %00100000
mFCMD_CMDB6:        equ    %01000000


;*** TIM1_TIOS - TIM1 Timer Input Capture/Output Compare Select; 0x00000140 ***
TIM1_TIOS:          equ    $00000140                                ;*** TIM1_TIOS - TIM1 Timer Input Capture/Output Compare Select; 0x00000140 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TIM1_TIOS_IOS4:     equ    4                                         ; Input Capture or Output Compare Channel Configuration Bit 4
TIM1_TIOS_IOS5:     equ    5                                         ; Input Capture or Output Compare Channel Configuration Bit 5
TIM1_TIOS_IOS6:     equ    6                                         ; Input Capture or Output Compare Channel Configuration Bit 6
TIM1_TIOS_IOS7:     equ    7                                         ; Input Capture or Output Compare Channel Configuration Bit 7
; bit position masks
mTIM1_TIOS_IOS4:    equ    %00010000
mTIM1_TIOS_IOS5:    equ    %00100000
mTIM1_TIOS_IOS6:    equ    %01000000
mTIM1_TIOS_IOS7:    equ    %10000000


;*** TIM1_CFORC - TIM1 Timer Compare Force Register; 0x00000141 ***
TIM1_CFORC:         equ    $00000141                                ;*** TIM1_CFORC - TIM1 Timer Compare Force Register; 0x00000141 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TIM1_CFORC_FOC4:    equ    4                                         ; Force Output Compare Action for Channel 4
TIM1_CFORC_FOC5:    equ    5                                         ; Force Output Compare Action for Channel 5
TIM1_CFORC_FOC6:    equ    6                                         ; Force Output Compare Action for Channel 6
TIM1_CFORC_FOC7:    equ    7                                         ; Force Output Compare Action for Channel 7
; bit position masks
mTIM1_CFORC_FOC4:   equ    %00010000
mTIM1_CFORC_FOC5:   equ    %00100000
mTIM1_CFORC_FOC6:   equ    %01000000
mTIM1_CFORC_FOC7:   equ    %10000000


;*** TIM1_OC7M - TIM1 Output Compare 7 Mask Register; 0x00000142 ***
TIM1_OC7M:          equ    $00000142                                ;*** TIM1_OC7M - TIM1 Output Compare 7 Mask Register; 0x00000142 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TIM1_OC7M_OC7M4:    equ    4                                         ; Output Compare 7 Mask Bit 4
TIM1_OC7M_OC7M5:    equ    5                                         ; Output Compare 7 Mask Bit 5
TIM1_OC7M_OC7M6:    equ    6                                         ; Output Compare 7 Mask Bit 6
TIM1_OC7M_OC7M7:    equ    7                                         ; Output Compare 7 Mask Bit 7
; bit position masks
mTIM1_OC7M_OC7M4:   equ    %00010000
mTIM1_OC7M_OC7M5:   equ    %00100000
mTIM1_OC7M_OC7M6:   equ    %01000000
mTIM1_OC7M_OC7M7:   equ    %10000000


;*** TIM1_OC7D - TIM1 Output Compare 7 Data Register; 0x00000143 ***
TIM1_OC7D:          equ    $00000143                                ;*** TIM1_OC7D - TIM1 Output Compare 7 Data Register; 0x00000143 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TIM1_OC7D_OC7D4:    equ    4                                         ; Output Compare 7 Bit 4
TIM1_OC7D_OC7D5:    equ    5                                         ; Output Compare 7 Bit 5
TIM1_OC7D_OC7D6:    equ    6                                         ; Output Compare 7 Bit 6
TIM1_OC7D_OC7D7:    equ    7                                         ; Output Compare 7 Bit 7
; bit position masks
mTIM1_OC7D_OC7D4:   equ    %00010000
mTIM1_OC7D_OC7D5:   equ    %00100000
mTIM1_OC7D_OC7D6:   equ    %01000000
mTIM1_OC7D_OC7D7:   equ    %10000000


;*** TIM1_TCNT - TIM1 Timer Count Register; 0x00000144 ***
TIM1_TCNT:          equ    $00000144                                ;*** TIM1_TCNT - TIM1 Timer Count Register; 0x00000144 ***


;*** TIM1_TCNTHi - TIM1 Timer Count Register High; 0x00000144 ***
TIM1_TCNTHi:        equ    $00000144                                ;*** TIM1_TCNTHi - TIM1 Timer Count Register High; 0x00000144 ***


;*** TIM1_TCNTLo - TIM1 Timer Count Register Low; 0x00000145 ***
TIM1_TCNTLo:        equ    $00000145                                ;*** TIM1_TCNTLo - TIM1 Timer Count Register Low; 0x00000145 ***


;*** TIM1_TSCR1 - TIM1 Timer System Control Register1; 0x00000146 ***
TIM1_TSCR1:         equ    $00000146                                ;*** TIM1_TSCR1 - TIM1 Timer System Control Register1; 0x00000146 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TIM1_TSCR1_TFFCA:   equ    4                                         ; Timer Fast Flag Clear All
TIM1_TSCR1_TSFRZ:   equ    5                                         ; Timer and Modulus Counter Stop While in Freeze Mode
TIM1_TSCR1_TSWAI:   equ    6                                         ; Timer Module Stops While in Wait
TIM1_TSCR1_TEN:     equ    7                                         ; Timer Enable
; bit position masks
mTIM1_TSCR1_TFFCA:  equ    %00010000
mTIM1_TSCR1_TSFRZ:  equ    %00100000
mTIM1_TSCR1_TSWAI:  equ    %01000000
mTIM1_TSCR1_TEN:    equ    %10000000


;*** TIM1_TTOV - TIM1 Timer Toggle On Overflow Register; 0x00000147 ***
TIM1_TTOV:          equ    $00000147                                ;*** TIM1_TTOV - TIM1 Timer Toggle On Overflow Register; 0x00000147 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TIM1_TTOV_TOV4:     equ    4                                         ; Toggle On Overflow Bit 4
TIM1_TTOV_TOV5:     equ    5                                         ; Toggle On Overflow Bit 5
TIM1_TTOV_TOV6:     equ    6                                         ; Toggle On Overflow Bit 6
TIM1_TTOV_TOV7:     equ    7                                         ; Toggle On Overflow Bit 7
; bit position masks
mTIM1_TTOV_TOV4:    equ    %00010000
mTIM1_TTOV_TOV5:    equ    %00100000
mTIM1_TTOV_TOV6:    equ    %01000000
mTIM1_TTOV_TOV7:    equ    %10000000


;*** TIM1_TCTL1 - TIM1 Timer Control Register 1; 0x00000148 ***
TIM1_TCTL1:         equ    $00000148                                ;*** TIM1_TCTL1 - TIM1 Timer Control Register 1; 0x00000148 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TIM1_TCTL1_OL4:     equ    0                                         ; Output Level Bit 4
TIM1_TCTL1_OM4:     equ    1                                         ; Output Mode Bit 4
TIM1_TCTL1_OL5:     equ    2                                         ; Output Level Bit 5
TIM1_TCTL1_OM5:     equ    3                                         ; Output Mode Bit 5
TIM1_TCTL1_OL6:     equ    4                                         ; Output Level Bit 6
TIM1_TCTL1_OM6:     equ    5                                         ; Output Mode Bit 6
TIM1_TCTL1_OL7:     equ    6                                         ; Output Level Bit 7
TIM1_TCTL1_OM7:     equ    7                                         ; Output Mode Bit 7
; bit position masks
mTIM1_TCTL1_OL4:    equ    %00000001
mTIM1_TCTL1_OM4:    equ    %00000010
mTIM1_TCTL1_OL5:    equ    %00000100
mTIM1_TCTL1_OM5:    equ    %00001000
mTIM1_TCTL1_OL6:    equ    %00010000
mTIM1_TCTL1_OM6:    equ    %00100000
mTIM1_TCTL1_OL7:    equ    %01000000
mTIM1_TCTL1_OM7:    equ    %10000000


;*** TIM1_TCTL3 - TIM1 Timer Control Register 3; 0x0000014A ***
TIM1_TCTL3:         equ    $0000014A                                ;*** TIM1_TCTL3 - TIM1 Timer Control Register 3; 0x0000014A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TIM1_TCTL3_EDG4A:   equ    0                                         ; Input Capture Edge Control 4A
TIM1_TCTL3_EDG4B:   equ    1                                         ; Input Capture Edge Control 4B
TIM1_TCTL3_EDG5A:   equ    2                                         ; Input Capture Edge Control 5A
TIM1_TCTL3_EDG5B:   equ    3                                         ; Input Capture Edge Control 5B
TIM1_TCTL3_EDG6A:   equ    4                                         ; Input Capture Edge Control 6A
TIM1_TCTL3_EDG6B:   equ    5                                         ; Input Capture Edge Control 6B
TIM1_TCTL3_EDG7A:   equ    6                                         ; Input Capture Edge Control 7A
TIM1_TCTL3_EDG7B:   equ    7                                         ; Input Capture Edge Control 7B
; bit position masks
mTIM1_TCTL3_EDG4A:  equ    %00000001
mTIM1_TCTL3_EDG4B:  equ    %00000010
mTIM1_TCTL3_EDG5A:  equ    %00000100
mTIM1_TCTL3_EDG5B:  equ    %00001000
mTIM1_TCTL3_EDG6A:  equ    %00010000
mTIM1_TCTL3_EDG6B:  equ    %00100000
mTIM1_TCTL3_EDG7A:  equ    %01000000
mTIM1_TCTL3_EDG7B:  equ    %10000000


;*** TIM1_TIE - TIM1 Timer Interrupt Enable Register; 0x0000014C ***
TIM1_TIE:           equ    $0000014C                                ;*** TIM1_TIE - TIM1 Timer Interrupt Enable Register; 0x0000014C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TIM1_TIE_C4I:       equ    4                                         ; Input Capture/Output Compare Interrupt Enable Bit 4
TIM1_TIE_C5I:       equ    5                                         ; Input Capture/Output Compare Interrupt Enable Bit 5
TIM1_TIE_C6I:       equ    6                                         ; Input Capture/Output Compare Interrupt Enable Bit 6
TIM1_TIE_C7I:       equ    7                                         ; Input Capture/Output Compare Interrupt Enable Bit 7
; bit position masks
mTIM1_TIE_C4I:      equ    %00010000
mTIM1_TIE_C5I:      equ    %00100000
mTIM1_TIE_C6I:      equ    %01000000
mTIM1_TIE_C7I:      equ    %10000000


;*** TIM1_TSCR2 - TIM1 Timer System Control Register 2; 0x0000014D ***
TIM1_TSCR2:         equ    $0000014D                                ;*** TIM1_TSCR2 - TIM1 Timer System Control Register 2; 0x0000014D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TIM1_TSCR2_PR0:     equ    0                                         ; Timer Prescaler Select Bit 0
TIM1_TSCR2_PR1:     equ    1                                         ; Timer Prescaler Select Bit 1
TIM1_TSCR2_PR2:     equ    2                                         ; Timer Prescaler Select Bit 2
TIM1_TSCR2_TCRE:    equ    3                                         ; Timer Counter Reset Enable
TIM1_TSCR2_TOI:     equ    7                                         ; Timer Overflow Interrupt Enable
; bit position masks
mTIM1_TSCR2_PR0:    equ    %00000001
mTIM1_TSCR2_PR1:    equ    %00000010
mTIM1_TSCR2_PR2:    equ    %00000100
mTIM1_TSCR2_TCRE:   equ    %00001000
mTIM1_TSCR2_TOI:    equ    %10000000


;*** TIM1_TFLG1 - TIM1 Main Timer Interrupt Flag 1; 0x0000014E ***
TIM1_TFLG1:         equ    $0000014E                                ;*** TIM1_TFLG1 - TIM1 Main Timer Interrupt Flag 1; 0x0000014E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TIM1_TFLG1_C4F:     equ    4                                         ; Input Capture/Output Compare Channel Flag 4
TIM1_TFLG1_C5F:     equ    5                                         ; Input Capture/Output Compare Channel Flag 5
TIM1_TFLG1_C6F:     equ    6                                         ; Input Capture/Output Compare Channel Flag 6
TIM1_TFLG1_C7F:     equ    7                                         ; Input Capture/Output Compare Channel Flag 7
; bit position masks
mTIM1_TFLG1_C4F:    equ    %00010000
mTIM1_TFLG1_C5F:    equ    %00100000
mTIM1_TFLG1_C6F:    equ    %01000000
mTIM1_TFLG1_C7F:    equ    %10000000


;*** TIM1_TFLG2 - TIM1 Main Timer Interrupt Flag 2; 0x0000014F ***
TIM1_TFLG2:         equ    $0000014F                                ;*** TIM1_TFLG2 - TIM1 Main Timer Interrupt Flag 2; 0x0000014F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TIM1_TFLG2_TOF:     equ    7                                         ; Timer Overflow Flag
; bit position masks
mTIM1_TFLG2_TOF:    equ    %10000000


;*** TIM1_TC4 - TIM1 Timer Input Capture/Output Compare Register 4; 0x00000158 ***
TIM1_TC4:           equ    $00000158                                ;*** TIM1_TC4 - TIM1 Timer Input Capture/Output Compare Register 4; 0x00000158 ***


;*** TIM1_TC4Hi - TIM1 Timer Input Capture/Output Compare Register 4 High; 0x00000158 ***
TIM1_TC4Hi:         equ    $00000158                                ;*** TIM1_TC4Hi - TIM1 Timer Input Capture/Output Compare Register 4 High; 0x00000158 ***


;*** TIM1_TC4Lo - TIM1 Timer Input Capture/Output Compare Register 4 Low; 0x00000159 ***
TIM1_TC4Lo:         equ    $00000159                                ;*** TIM1_TC4Lo - TIM1 Timer Input Capture/Output Compare Register 4 Low; 0x00000159 ***


;*** TIM1_TC5 - TIM1 Timer Input Capture/Output Compare Register 5; 0x0000015A ***
TIM1_TC5:           equ    $0000015A                                ;*** TIM1_TC5 - TIM1 Timer Input Capture/Output Compare Register 5; 0x0000015A ***


;*** TIM1_TC5Hi - TIM1 Timer Input Capture/Output Compare Register 5 High; 0x0000015A ***
TIM1_TC5Hi:         equ    $0000015A                                ;*** TIM1_TC5Hi - TIM1 Timer Input Capture/Output Compare Register 5 High; 0x0000015A ***


;*** TIM1_TC5Lo - TIM1 Timer Input Capture/Output Compare Register 5 Low; 0x0000015B ***
TIM1_TC5Lo:         equ    $0000015B                                ;*** TIM1_TC5Lo - TIM1 Timer Input Capture/Output Compare Register 5 Low; 0x0000015B ***


;*** TIM1_TC6 - TIM1 Timer Input Capture/Output Compare Register 6; 0x0000015C ***
TIM1_TC6:           equ    $0000015C                                ;*** TIM1_TC6 - TIM1 Timer Input Capture/Output Compare Register 6; 0x0000015C ***


;*** TIM1_TC6Hi - TIM1 Timer Input Capture/Output Compare Register 6 High; 0x0000015C ***
TIM1_TC6Hi:         equ    $0000015C                                ;*** TIM1_TC6Hi - TIM1 Timer Input Capture/Output Compare Register 6 High; 0x0000015C ***


;*** TIM1_TC6Lo - TIM1 Timer Input Capture/Output Compare Register 6 Low; 0x0000015D ***
TIM1_TC6Lo:         equ    $0000015D                                ;*** TIM1_TC6Lo - TIM1 Timer Input Capture/Output Compare Register 6 Low; 0x0000015D ***


;*** TIM1_TC7 - TIM1 Timer Input Capture/Output Compare Register 7; 0x0000015E ***
TIM1_TC7:           equ    $0000015E                                ;*** TIM1_TC7 - TIM1 Timer Input Capture/Output Compare Register 7; 0x0000015E ***


;*** TIM1_TC7Hi - TIM1 Timer Input Capture/Output Compare Register 7 High; 0x0000015E ***
TIM1_TC7Hi:         equ    $0000015E                                ;*** TIM1_TC7Hi - TIM1 Timer Input Capture/Output Compare Register 7 High; 0x0000015E ***


;*** TIM1_TC7Lo - TIM1 Timer Input Capture/Output Compare Register 7 Low; 0x0000015F ***
TIM1_TC7Lo:         equ    $0000015F                                ;*** TIM1_TC7Lo - TIM1 Timer Input Capture/Output Compare Register 7 Low; 0x0000015F ***


;*** TIM1_PACTL - TIM1 16-Bit Pulse Accumulator A Control Register; 0x00000160 ***
TIM1_PACTL:         equ    $00000160                                ;*** TIM1_PACTL - TIM1 16-Bit Pulse Accumulator A Control Register; 0x00000160 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TIM1_PACTL_PAI:     equ    0                                         ; Pulse Accumulator Input Interrupt enable
TIM1_PACTL_PAOVI:   equ    1                                         ; Pulse Accumulator A Overflow Interrupt enable
TIM1_PACTL_CLK0:    equ    2                                         ; Clock Select Bit 0
TIM1_PACTL_CLK1:    equ    3                                         ; Clock Select Bit 1
TIM1_PACTL_PEDGE:   equ    4                                         ; Pulse Accumulator Edge Control
TIM1_PACTL_PAMOD:   equ    5                                         ; Pulse Accumulator Mode
TIM1_PACTL_PAEN:    equ    6                                         ; Pulse Accumulator A System Enable
; bit position masks
mTIM1_PACTL_PAI:    equ    %00000001
mTIM1_PACTL_PAOVI:  equ    %00000010
mTIM1_PACTL_CLK0:   equ    %00000100
mTIM1_PACTL_CLK1:   equ    %00001000
mTIM1_PACTL_PEDGE:  equ    %00010000
mTIM1_PACTL_PAMOD:  equ    %00100000
mTIM1_PACTL_PAEN:   equ    %01000000


;*** TIM1_PAFLG - TIM1 Pulse Accumulator A Flag Register; 0x00000161 ***
TIM1_PAFLG:         equ    $00000161                                ;*** TIM1_PAFLG - TIM1 Pulse Accumulator A Flag Register; 0x00000161 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TIM1_PAFLG_PAIF:    equ    0                                         ; Pulse Accumulator Input edge Flag
TIM1_PAFLG_PAOVF:   equ    1                                         ; Pulse Accumulator A Overflow Flag
; bit position masks
mTIM1_PAFLG_PAIF:   equ    %00000001
mTIM1_PAFLG_PAOVF:  equ    %00000010


;*** TIM1_PACNT - TIM1 Pulse Accumulators Count Register; 0x00000162 ***
TIM1_PACNT:         equ    $00000162                                ;*** TIM1_PACNT - TIM1 Pulse Accumulators Count Register; 0x00000162 ***


;*** TIM2_TIOS - TIM2 Timer Input Capture/Output Compare Select; 0x00000180 ***
TIM2_TIOS:          equ    $00000180                                ;*** TIM2_TIOS - TIM2 Timer Input Capture/Output Compare Select; 0x00000180 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TIM2_TIOS_IOS4:     equ    4                                         ; Input Capture or Output Compare Channel Configuration Bit 4
TIM2_TIOS_IOS5:     equ    5                                         ; Input Capture or Output Compare Channel Configuration Bit 5
TIM2_TIOS_IOS6:     equ    6                                         ; Input Capture or Output Compare Channel Configuration Bit 6
TIM2_TIOS_IOS7:     equ    7                                         ; Input Capture or Output Compare Channel Configuration Bit 7
; bit position masks
mTIM2_TIOS_IOS4:    equ    %00010000
mTIM2_TIOS_IOS5:    equ    %00100000
mTIM2_TIOS_IOS6:    equ    %01000000
mTIM2_TIOS_IOS7:    equ    %10000000


;*** TIM2_CFORC - TIM2 Timer Compare Force Register; 0x00000181 ***
TIM2_CFORC:         equ    $00000181                                ;*** TIM2_CFORC - TIM2 Timer Compare Force Register; 0x00000181 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TIM2_CFORC_FOC4:    equ    4                                         ; Force Output Compare Action for Channel 4
TIM2_CFORC_FOC5:    equ    5                                         ; Force Output Compare Action for Channel 5
TIM2_CFORC_FOC6:    equ    6                                         ; Force Output Compare Action for Channel 6
TIM2_CFORC_FOC7:    equ    7                                         ; Force Output Compare Action for Channel 7
; bit position masks
mTIM2_CFORC_FOC4:   equ    %00010000
mTIM2_CFORC_FOC5:   equ    %00100000
mTIM2_CFORC_FOC6:   equ    %01000000
mTIM2_CFORC_FOC7:   equ    %10000000


;*** TIM2_OC7M - TIM2 Output Compare 7 Mask Register; 0x00000182 ***
TIM2_OC7M:          equ    $00000182                                ;*** TIM2_OC7M - TIM2 Output Compare 7 Mask Register; 0x00000182 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TIM2_OC7M_OC7M4:    equ    4                                         ; Output Compare 7 Mask Bit 4
TIM2_OC7M_OC7M5:    equ    5                                         ; Output Compare 7 Mask Bit 5
TIM2_OC7M_OC7M6:    equ    6                                         ; Output Compare 7 Mask Bit 6
TIM2_OC7M_OC7M7:    equ    7                                         ; Output Compare 7 Mask Bit 7
; bit position masks
mTIM2_OC7M_OC7M4:   equ    %00010000
mTIM2_OC7M_OC7M5:   equ    %00100000
mTIM2_OC7M_OC7M6:   equ    %01000000
mTIM2_OC7M_OC7M7:   equ    %10000000


;*** TIM2_OC7D - TIM2 Output Compare 7 Data Register; 0x00000183 ***
TIM2_OC7D:          equ    $00000183                                ;*** TIM2_OC7D - TIM2 Output Compare 7 Data Register; 0x00000183 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TIM2_OC7D_OC7D4:    equ    4                                         ; Output Compare 7 Bit 4
TIM2_OC7D_OC7D5:    equ    5                                         ; Output Compare 7 Bit 5
TIM2_OC7D_OC7D6:    equ    6                                         ; Output Compare 7 Bit 6
TIM2_OC7D_OC7D7:    equ    7                                         ; Output Compare 7 Bit 7
; bit position masks
mTIM2_OC7D_OC7D4:   equ    %00010000
mTIM2_OC7D_OC7D5:   equ    %00100000
mTIM2_OC7D_OC7D6:   equ    %01000000
mTIM2_OC7D_OC7D7:   equ    %10000000


;*** TIM2_TCNT - TIM2 Timer Count Register; 0x00000184 ***
TIM2_TCNT:          equ    $00000184                                ;*** TIM2_TCNT - TIM2 Timer Count Register; 0x00000184 ***


;*** TIM2_TCNTHi - TIM2 Timer Count Register High; 0x00000184 ***
TIM2_TCNTHi:        equ    $00000184                                ;*** TIM2_TCNTHi - TIM2 Timer Count Register High; 0x00000184 ***


;*** TIM2_TCNTLo - TIM2 Timer Count Register Low; 0x00000185 ***
TIM2_TCNTLo:        equ    $00000185                                ;*** TIM2_TCNTLo - TIM2 Timer Count Register Low; 0x00000185 ***


;*** TIM2_TSCR1 - TIM2 Timer System Control Register1; 0x00000186 ***
TIM2_TSCR1:         equ    $00000186                                ;*** TIM2_TSCR1 - TIM2 Timer System Control Register1; 0x00000186 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TIM2_TSCR1_TFFCA:   equ    4                                         ; Timer Fast Flag Clear All
TIM2_TSCR1_TSFRZ:   equ    5                                         ; Timer and Modulus Counter Stop While in Freeze Mode
TIM2_TSCR1_TSWAI:   equ    6                                         ; Timer Module Stops While in Wait
TIM2_TSCR1_TEN:     equ    7                                         ; Timer Enable
; bit position masks
mTIM2_TSCR1_TFFCA:  equ    %00010000
mTIM2_TSCR1_TSFRZ:  equ    %00100000
mTIM2_TSCR1_TSWAI:  equ    %01000000
mTIM2_TSCR1_TEN:    equ    %10000000


;*** TIM2_TTOV - TIM2 Timer Toggle On Overflow Register; 0x00000187 ***
TIM2_TTOV:          equ    $00000187                                ;*** TIM2_TTOV - TIM2 Timer Toggle On Overflow Register; 0x00000187 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TIM2_TTOV_TOV4:     equ    4                                         ; Toggle On Overflow Bit 4
TIM2_TTOV_TOV5:     equ    5                                         ; Toggle On Overflow Bit 5
TIM2_TTOV_TOV6:     equ    6                                         ; Toggle On Overflow Bit 6
TIM2_TTOV_TOV7:     equ    7                                         ; Toggle On Overflow Bit 7
; bit position masks
mTIM2_TTOV_TOV4:    equ    %00010000
mTIM2_TTOV_TOV5:    equ    %00100000
mTIM2_TTOV_TOV6:    equ    %01000000
mTIM2_TTOV_TOV7:    equ    %10000000


;*** TIM2_TCTL1 - TIM2 Timer Control Register 1; 0x00000188 ***
TIM2_TCTL1:         equ    $00000188                                ;*** TIM2_TCTL1 - TIM2 Timer Control Register 1; 0x00000188 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TIM2_TCTL1_OL4:     equ    0                                         ; Output Level Bit 4
TIM2_TCTL1_OM4:     equ    1                                         ; Output Mode Bit 4
TIM2_TCTL1_OL5:     equ    2                                         ; Output Level Bit 5
TIM2_TCTL1_OM5:     equ    3                                         ; Output Mode Bit 5
TIM2_TCTL1_OL6:     equ    4                                         ; Output Level Bit 6
TIM2_TCTL1_OM6:     equ    5                                         ; Output Mode Bit 6
TIM2_TCTL1_OL7:     equ    6                                         ; Output Level Bit 7
TIM2_TCTL1_OM7:     equ    7                                         ; Output Mode Bit 7
; bit position masks
mTIM2_TCTL1_OL4:    equ    %00000001
mTIM2_TCTL1_OM4:    equ    %00000010
mTIM2_TCTL1_OL5:    equ    %00000100
mTIM2_TCTL1_OM5:    equ    %00001000
mTIM2_TCTL1_OL6:    equ    %00010000
mTIM2_TCTL1_OM6:    equ    %00100000
mTIM2_TCTL1_OL7:    equ    %01000000
mTIM2_TCTL1_OM7:    equ    %10000000


;*** TIM2_TCTL3 - TIM2 Timer Control Register 3; 0x0000018A ***
TIM2_TCTL3:         equ    $0000018A                                ;*** TIM2_TCTL3 - TIM2 Timer Control Register 3; 0x0000018A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TIM2_TCTL3_EDG4A:   equ    0                                         ; Input Capture Edge Control 4A
TIM2_TCTL3_EDG4B:   equ    1                                         ; Input Capture Edge Control 4B
TIM2_TCTL3_EDG5A:   equ    2                                         ; Input Capture Edge Control 5A
TIM2_TCTL3_EDG5B:   equ    3                                         ; Input Capture Edge Control 5B
TIM2_TCTL3_EDG6A:   equ    4                                         ; Input Capture Edge Control 6A
TIM2_TCTL3_EDG6B:   equ    5                                         ; Input Capture Edge Control 6B
TIM2_TCTL3_EDG7A:   equ    6                                         ; Input Capture Edge Control 7A
TIM2_TCTL3_EDG7B:   equ    7                                         ; Input Capture Edge Control 7B
; bit position masks
mTIM2_TCTL3_EDG4A:  equ    %00000001
mTIM2_TCTL3_EDG4B:  equ    %00000010
mTIM2_TCTL3_EDG5A:  equ    %00000100
mTIM2_TCTL3_EDG5B:  equ    %00001000
mTIM2_TCTL3_EDG6A:  equ    %00010000
mTIM2_TCTL3_EDG6B:  equ    %00100000
mTIM2_TCTL3_EDG7A:  equ    %01000000
mTIM2_TCTL3_EDG7B:  equ    %10000000


;*** TIM2_TIE - TIM2 Timer Interrupt Enable Register; 0x0000018C ***
TIM2_TIE:           equ    $0000018C                                ;*** TIM2_TIE - TIM2 Timer Interrupt Enable Register; 0x0000018C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TIM2_TIE_C4I:       equ    4                                         ; Input Capture/Output Compare Interrupt Enable Bit 4
TIM2_TIE_C5I:       equ    5                                         ; Input Capture/Output Compare Interrupt Enable Bit 5
TIM2_TIE_C6I:       equ    6                                         ; Input Capture/Output Compare Interrupt Enable Bit 6
TIM2_TIE_C7I:       equ    7                                         ; Input Capture/Output Compare Interrupt Enable Bit 7
; bit position masks
mTIM2_TIE_C4I:      equ    %00010000
mTIM2_TIE_C5I:      equ    %00100000
mTIM2_TIE_C6I:      equ    %01000000
mTIM2_TIE_C7I:      equ    %10000000


;*** TIM2_TSCR2 - TIM2 Timer System Control Register 2; 0x0000018D ***
TIM2_TSCR2:         equ    $0000018D                                ;*** TIM2_TSCR2 - TIM2 Timer System Control Register 2; 0x0000018D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TIM2_TSCR2_PR0:     equ    0                                         ; Timer Prescaler Select Bit 0
TIM2_TSCR2_PR1:     equ    1                                         ; Timer Prescaler Select Bit 1
TIM2_TSCR2_PR2:     equ    2                                         ; Timer Prescaler Select Bit 2
TIM2_TSCR2_TCRE:    equ    3                                         ; Timer Counter Reset Enable
TIM2_TSCR2_TOI:     equ    7                                         ; Timer Overflow Interrupt Enable
; bit position masks
mTIM2_TSCR2_PR0:    equ    %00000001
mTIM2_TSCR2_PR1:    equ    %00000010
mTIM2_TSCR2_PR2:    equ    %00000100
mTIM2_TSCR2_TCRE:   equ    %00001000
mTIM2_TSCR2_TOI:    equ    %10000000


;*** TIM2_TFLG1 - TIM2 Main Timer Interrupt Flag 1; 0x0000018E ***
TIM2_TFLG1:         equ    $0000018E                                ;*** TIM2_TFLG1 - TIM2 Main Timer Interrupt Flag 1; 0x0000018E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TIM2_TFLG1_C4F:     equ    4                                         ; Input Capture/Output Compare Channel Flag 4
TIM2_TFLG1_C5F:     equ    5                                         ; Input Capture/Output Compare Channel Flag 5
TIM2_TFLG1_C6F:     equ    6                                         ; Input Capture/Output Compare Channel Flag 6
TIM2_TFLG1_C7F:     equ    7                                         ; Input Capture/Output Compare Channel Flag 7
; bit position masks
mTIM2_TFLG1_C4F:    equ    %00010000
mTIM2_TFLG1_C5F:    equ    %00100000
mTIM2_TFLG1_C6F:    equ    %01000000
mTIM2_TFLG1_C7F:    equ    %10000000


;*** TIM2_TFLG2 - TIM2 Main Timer Interrupt Flag 2; 0x0000018F ***
TIM2_TFLG2:         equ    $0000018F                                ;*** TIM2_TFLG2 - TIM2 Main Timer Interrupt Flag 2; 0x0000018F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TIM2_TFLG2_TOF:     equ    7                                         ; Timer Overflow Flag
; bit position masks
mTIM2_TFLG2_TOF:    equ    %10000000


;*** TIM2_TC4 - TIM2 Timer Input Capture/Output Compare Register 4; 0x00000198 ***
TIM2_TC4:           equ    $00000198                                ;*** TIM2_TC4 - TIM2 Timer Input Capture/Output Compare Register 4; 0x00000198 ***


;*** TIM2_TC4Hi - TIM2 Timer Input Capture/Output Compare Register 4 High; 0x00000198 ***
TIM2_TC4Hi:         equ    $00000198                                ;*** TIM2_TC4Hi - TIM2 Timer Input Capture/Output Compare Register 4 High; 0x00000198 ***


;*** TIM2_TC4Lo - TIM2 Timer Input Capture/Output Compare Register 4 Low; 0x00000199 ***
TIM2_TC4Lo:         equ    $00000199                                ;*** TIM2_TC4Lo - TIM2 Timer Input Capture/Output Compare Register 4 Low; 0x00000199 ***


;*** TIM2_TC5 - TIM2 Timer Input Capture/Output Compare Register 5; 0x0000019A ***
TIM2_TC5:           equ    $0000019A                                ;*** TIM2_TC5 - TIM2 Timer Input Capture/Output Compare Register 5; 0x0000019A ***


;*** TIM2_TC5Hi - TIM2 Timer Input Capture/Output Compare Register 5 High; 0x0000019A ***
TIM2_TC5Hi:         equ    $0000019A                                ;*** TIM2_TC5Hi - TIM2 Timer Input Capture/Output Compare Register 5 High; 0x0000019A ***


;*** TIM2_TC5Lo - TIM2 Timer Input Capture/Output Compare Register 5 Low; 0x0000019B ***
TIM2_TC5Lo:         equ    $0000019B                                ;*** TIM2_TC5Lo - TIM2 Timer Input Capture/Output Compare Register 5 Low; 0x0000019B ***


;*** TIM2_TC6 - TIM2 Timer Input Capture/Output Compare Register 6; 0x0000019C ***
TIM2_TC6:           equ    $0000019C                                ;*** TIM2_TC6 - TIM2 Timer Input Capture/Output Compare Register 6; 0x0000019C ***


;*** TIM2_TC6Hi - TIM2 Timer Input Capture/Output Compare Register 6 High; 0x0000019C ***
TIM2_TC6Hi:         equ    $0000019C                                ;*** TIM2_TC6Hi - TIM2 Timer Input Capture/Output Compare Register 6 High; 0x0000019C ***


;*** TIM2_TC6Lo - TIM2 Timer Input Capture/Output Compare Register 6 Low; 0x0000019D ***
TIM2_TC6Lo:         equ    $0000019D                                ;*** TIM2_TC6Lo - TIM2 Timer Input Capture/Output Compare Register 6 Low; 0x0000019D ***


;*** TIM2_TC7 - TIM2 Timer Input Capture/Output Compare Register 7; 0x0000019E ***
TIM2_TC7:           equ    $0000019E                                ;*** TIM2_TC7 - TIM2 Timer Input Capture/Output Compare Register 7; 0x0000019E ***


;*** TIM2_TC7Hi - TIM2 Timer Input Capture/Output Compare Register 7 High; 0x0000019E ***
TIM2_TC7Hi:         equ    $0000019E                                ;*** TIM2_TC7Hi - TIM2 Timer Input Capture/Output Compare Register 7 High; 0x0000019E ***


;*** TIM2_TC7Lo - TIM2 Timer Input Capture/Output Compare Register 7 Low; 0x0000019F ***
TIM2_TC7Lo:         equ    $0000019F                                ;*** TIM2_TC7Lo - TIM2 Timer Input Capture/Output Compare Register 7 Low; 0x0000019F ***


;*** TIM2_PACTL - TIM2 16-Bit Pulse Accumulator A Control Register; 0x000001A0 ***
TIM2_PACTL:         equ    $000001A0                                ;*** TIM2_PACTL - TIM2 16-Bit Pulse Accumulator A Control Register; 0x000001A0 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TIM2_PACTL_PAI:     equ    0                                         ; Pulse Accumulator Input Interrupt enable
TIM2_PACTL_PAOVI:   equ    1                                         ; Pulse Accumulator A Overflow Interrupt enable
TIM2_PACTL_CLK0:    equ    2                                         ; Clock Select Bit 0
TIM2_PACTL_CLK1:    equ    3                                         ; Clock Select Bit 1
TIM2_PACTL_PEDGE:   equ    4                                         ; Pulse Accumulator Edge Control
TIM2_PACTL_PAMOD:   equ    5                                         ; Pulse Accumulator Mode
TIM2_PACTL_PAEN:    equ    6                                         ; Pulse Accumulator A System Enable
; bit position masks
mTIM2_PACTL_PAI:    equ    %00000001
mTIM2_PACTL_PAOVI:  equ    %00000010
mTIM2_PACTL_CLK0:   equ    %00000100
mTIM2_PACTL_CLK1:   equ    %00001000
mTIM2_PACTL_PEDGE:  equ    %00010000
mTIM2_PACTL_PAMOD:  equ    %00100000
mTIM2_PACTL_PAEN:   equ    %01000000


;*** TIM2_PAFLG - TIM2 Pulse Accumulator A Flag Register; 0x000001A1 ***
TIM2_PAFLG:         equ    $000001A1                                ;*** TIM2_PAFLG - TIM2 Pulse Accumulator A Flag Register; 0x000001A1 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TIM2_PAFLG_PAIF:    equ    0                                         ; Pulse Accumulator Input edge Flag
TIM2_PAFLG_PAOVF:   equ    1                                         ; Pulse Accumulator A Overflow Flag
; bit position masks
mTIM2_PAFLG_PAIF:   equ    %00000001
mTIM2_PAFLG_PAOVF:  equ    %00000010


;*** TIM2_PACNT - TIM2 Pulse Accumulators Count Register; 0x000001A2 ***
TIM2_PACNT:         equ    $000001A2                                ;*** TIM2_PACNT - TIM2 Pulse Accumulators Count Register; 0x000001A2 ***


;*** PWME - PWM Enable Register; 0x000001E0 ***
PWME:               equ    $000001E0                                ;*** PWME - PWM Enable Register; 0x000001E0 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PWME_PWME0:         equ    0                                         ; Pulse Width Channel 0 Enable
PWME_PWME1:         equ    1                                         ; Pulse Width Channel 1 Enable
PWME_PWME2:         equ    2                                         ; Pulse Width Channel 2 Enable
PWME_PWME3:         equ    3                                         ; Pulse Width Channel 3 Enable
PWME_PWME4:         equ    4                                         ; Pulse Width Channel 4 Enable
PWME_PWME5:         equ    5                                         ; Pulse Width Channel 5 Enable
; bit position masks
mPWME_PWME0:        equ    %00000001
mPWME_PWME1:        equ    %00000010
mPWME_PWME2:        equ    %00000100
mPWME_PWME3:        equ    %00001000
mPWME_PWME4:        equ    %00010000
mPWME_PWME5:        equ    %00100000


;*** PWMPOL - PWM Polarity Register; 0x000001E1 ***
PWMPOL:             equ    $000001E1                                ;*** PWMPOL - PWM Polarity Register; 0x000001E1 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PWMPOL_PPOL0:       equ    0                                         ; Pulse Width Channel 0 Polarity
PWMPOL_PPOL1:       equ    1                                         ; Pulse Width Channel 1 Polarity
PWMPOL_PPOL2:       equ    2                                         ; Pulse Width Channel 2 Polarity
PWMPOL_PPOL3:       equ    3                                         ; Pulse Width Channel 3 Polarity
PWMPOL_PPOL4:       equ    4                                         ; Pulse Width Channel 4 Polarity
PWMPOL_PPOL5:       equ    5                                         ; Pulse Width Channel 5 Polarity
; bit position masks
mPWMPOL_PPOL0:      equ    %00000001
mPWMPOL_PPOL1:      equ    %00000010
mPWMPOL_PPOL2:      equ    %00000100
mPWMPOL_PPOL3:      equ    %00001000
mPWMPOL_PPOL4:      equ    %00010000
mPWMPOL_PPOL5:      equ    %00100000


;*** PWMCLK - PWM Clock Select Register; 0x000001E2 ***
PWMCLK:             equ    $000001E2                                ;*** PWMCLK - PWM Clock Select Register; 0x000001E2 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PWMCLK_PCLK0:       equ    0                                         ; Pulse Width Channel 0 Clock Select
PWMCLK_PCLK1:       equ    1                                         ; Pulse Width Channel 1 Clock Select
PWMCLK_PCLK2:       equ    2                                         ; Pulse Width Channel 2 Clock Select
PWMCLK_PCLK3:       equ    3                                         ; Pulse Width Channel 3 Clock Select
PWMCLK_PCLK4:       equ    4                                         ; Pulse Width Channel 4 Clock Select
PWMCLK_PCLK5:       equ    5                                         ; Pulse Width Channel 5 Clock Select
; bit position masks
mPWMCLK_PCLK0:      equ    %00000001
mPWMCLK_PCLK1:      equ    %00000010
mPWMCLK_PCLK2:      equ    %00000100
mPWMCLK_PCLK3:      equ    %00001000
mPWMCLK_PCLK4:      equ    %00010000
mPWMCLK_PCLK5:      equ    %00100000


;*** PWMPRCLK - PWM Prescale Clock Select Register; 0x000001E3 ***
PWMPRCLK:           equ    $000001E3                                ;*** PWMPRCLK - PWM Prescale Clock Select Register; 0x000001E3 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PWMPRCLK_PCKA0:     equ    0                                         ; Prescaler Select for Clock A 0
PWMPRCLK_PCKA1:     equ    1                                         ; Prescaler Select for Clock A 1
PWMPRCLK_PCKA2:     equ    2                                         ; Prescaler Select for Clock A 2
PWMPRCLK_PCKB0:     equ    4                                         ; Prescaler Select for Clock B 0
PWMPRCLK_PCKB1:     equ    5                                         ; Prescaler Select for Clock B 1
PWMPRCLK_PCKB2:     equ    6                                         ; Prescaler Select for Clock B 2
; bit position masks
mPWMPRCLK_PCKA0:    equ    %00000001
mPWMPRCLK_PCKA1:    equ    %00000010
mPWMPRCLK_PCKA2:    equ    %00000100
mPWMPRCLK_PCKB0:    equ    %00010000
mPWMPRCLK_PCKB1:    equ    %00100000
mPWMPRCLK_PCKB2:    equ    %01000000


;*** PWMCAE - PWM Center Align Enable Register; 0x000001E4 ***
PWMCAE:             equ    $000001E4                                ;*** PWMCAE - PWM Center Align Enable Register; 0x000001E4 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PWMCAE_CAE0:        equ    0                                         ; Center Aligned Output Mode on channel 0
PWMCAE_CAE1:        equ    1                                         ; Center Aligned Output Mode on channel 1
PWMCAE_CAE2:        equ    2                                         ; Center Aligned Output Mode on channel 2
PWMCAE_CAE3:        equ    3                                         ; Center Aligned Output Mode on channel 3
PWMCAE_CAE4:        equ    4                                         ; Center Aligned Output Mode on channel 4
PWMCAE_CAE5:        equ    5                                         ; Center Aligned Output Mode on channel 5
; bit position masks
mPWMCAE_CAE0:       equ    %00000001
mPWMCAE_CAE1:       equ    %00000010
mPWMCAE_CAE2:       equ    %00000100
mPWMCAE_CAE3:       equ    %00001000
mPWMCAE_CAE4:       equ    %00010000
mPWMCAE_CAE5:       equ    %00100000


;*** PWMCTL - PWM Control Register; 0x000001E5 ***
PWMCTL:             equ    $000001E5                                ;*** PWMCTL - PWM Control Register; 0x000001E5 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PWMCTL_PFRZ:        equ    2                                         ; PWM Counters Stop in Freeze Mode
PWMCTL_PSWAI:       equ    3                                         ; PWM Stops in Wait Mode
PWMCTL_CON01:       equ    4                                         ; Concatenate channels 0 and 1
PWMCTL_CON23:       equ    5                                         ; Concatenate channels 2 and 3
PWMCTL_CON45:       equ    6                                         ; Concatenate channels 4 and 5
; bit position masks
mPWMCTL_PFRZ:       equ    %00000100
mPWMCTL_PSWAI:      equ    %00001000
mPWMCTL_CON01:      equ    %00010000
mPWMCTL_CON23:      equ    %00100000
mPWMCTL_CON45:      equ    %01000000


;*** PWMSCLA - PWM Scale A Register; 0x000001E8 ***
PWMSCLA:            equ    $000001E8                                ;*** PWMSCLA - PWM Scale A Register; 0x000001E8 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PWMSCLA_BIT0:       equ    0                                         ; PWM Scale A Bit 0
PWMSCLA_BIT1:       equ    1                                         ; PWM Scale A Bit 1
PWMSCLA_BIT2:       equ    2                                         ; PWM Scale A Bit 2
PWMSCLA_BIT3:       equ    3                                         ; PWM Scale A Bit 3
PWMSCLA_BIT4:       equ    4                                         ; PWM Scale A Bit 4
PWMSCLA_BIT5:       equ    5                                         ; PWM Scale A Bit 5
PWMSCLA_BIT6:       equ    6                                         ; PWM Scale A Bit 6
PWMSCLA_BIT7:       equ    7                                         ; PWM Scale A Bit 7
; bit position masks
mPWMSCLA_BIT0:      equ    %00000001
mPWMSCLA_BIT1:      equ    %00000010
mPWMSCLA_BIT2:      equ    %00000100
mPWMSCLA_BIT3:      equ    %00001000
mPWMSCLA_BIT4:      equ    %00010000
mPWMSCLA_BIT5:      equ    %00100000
mPWMSCLA_BIT6:      equ    %01000000
mPWMSCLA_BIT7:      equ    %10000000


;*** PWMSCLB - PWM Scale B Register; 0x000001E9 ***
PWMSCLB:            equ    $000001E9                                ;*** PWMSCLB - PWM Scale B Register; 0x000001E9 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PWMSCLB_BIT0:       equ    0                                         ; PWM Scale B Bit 0
PWMSCLB_BIT1:       equ    1                                         ; PWM Scale B Bit 1
PWMSCLB_BIT2:       equ    2                                         ; PWM Scale B Bit 2
PWMSCLB_BIT3:       equ    3                                         ; PWM Scale B Bit 3
PWMSCLB_BIT4:       equ    4                                         ; PWM Scale B Bit 4
PWMSCLB_BIT5:       equ    5                                         ; PWM Scale B Bit 5
PWMSCLB_BIT6:       equ    6                                         ; PWM Scale B Bit 6
PWMSCLB_BIT7:       equ    7                                         ; PWM Scale B Bit 7
; bit position masks
mPWMSCLB_BIT0:      equ    %00000001
mPWMSCLB_BIT1:      equ    %00000010
mPWMSCLB_BIT2:      equ    %00000100
mPWMSCLB_BIT3:      equ    %00001000
mPWMSCLB_BIT4:      equ    %00010000
mPWMSCLB_BIT5:      equ    %00100000
mPWMSCLB_BIT6:      equ    %01000000
mPWMSCLB_BIT7:      equ    %10000000


;*** PWMCNT01 - PWM Channel Counter 01 Register; 0x000001EC ***
PWMCNT01:           equ    $000001EC                                ;*** PWMCNT01 - PWM Channel Counter 01 Register; 0x000001EC ***


;*** PWMCNT0 - PWM Channel Counter 0 Register; 0x000001EC ***
PWMCNT0:            equ    $000001EC                                ;*** PWMCNT0 - PWM Channel Counter 0 Register; 0x000001EC ***


;*** PWMCNT1 - PWM Channel Counter 1 Register; 0x000001ED ***
PWMCNT1:            equ    $000001ED                                ;*** PWMCNT1 - PWM Channel Counter 1 Register; 0x000001ED ***


;*** PWMCNT23 - PWM Channel Counter 23 Register; 0x000001EE ***
PWMCNT23:           equ    $000001EE                                ;*** PWMCNT23 - PWM Channel Counter 23 Register; 0x000001EE ***


;*** PWMCNT2 - PWM Channel Counter 2 Register; 0x000001EE ***
PWMCNT2:            equ    $000001EE                                ;*** PWMCNT2 - PWM Channel Counter 2 Register; 0x000001EE ***


;*** PWMCNT3 - PWM Channel Counter 3 Register; 0x000001EF ***
PWMCNT3:            equ    $000001EF                                ;*** PWMCNT3 - PWM Channel Counter 3 Register; 0x000001EF ***


;*** PWMCNT45 - PWM Channel Counter 45 Register; 0x000001F0 ***
PWMCNT45:           equ    $000001F0                                ;*** PWMCNT45 - PWM Channel Counter 45 Register; 0x000001F0 ***


;*** PWMCNT4 - PWM Channel Counter 4 Register; 0x000001F0 ***
PWMCNT4:            equ    $000001F0                                ;*** PWMCNT4 - PWM Channel Counter 4 Register; 0x000001F0 ***


;*** PWMCNT5 - PWM Channel Counter 5 Register; 0x000001F1 ***
PWMCNT5:            equ    $000001F1                                ;*** PWMCNT5 - PWM Channel Counter 5 Register; 0x000001F1 ***


;*** PWMPER01 - PWM Channel Period 01 Register; 0x000001F2 ***
PWMPER01:           equ    $000001F2                                ;*** PWMPER01 - PWM Channel Period 01 Register; 0x000001F2 ***


;*** PWMPER0 - PWM Channel Period 0 Register; 0x000001F2 ***
PWMPER0:            equ    $000001F2                                ;*** PWMPER0 - PWM Channel Period 0 Register; 0x000001F2 ***


;*** PWMPER1 - PWM Channel Period 1 Register; 0x000001F3 ***
PWMPER1:            equ    $000001F3                                ;*** PWMPER1 - PWM Channel Period 1 Register; 0x000001F3 ***


;*** PWMPER23 - PWM Channel Period 23 Register; 0x000001F4 ***
PWMPER23:           equ    $000001F4                                ;*** PWMPER23 - PWM Channel Period 23 Register; 0x000001F4 ***


;*** PWMPER2 - PWM Channel Period 2 Register; 0x000001F4 ***
PWMPER2:            equ    $000001F4                                ;*** PWMPER2 - PWM Channel Period 2 Register; 0x000001F4 ***


;*** PWMPER3 - PWM Channel Period 3 Register; 0x000001F5 ***
PWMPER3:            equ    $000001F5                                ;*** PWMPER3 - PWM Channel Period 3 Register; 0x000001F5 ***


;*** PWMPER45 - PWM Channel Period 45 Register; 0x000001F6 ***
PWMPER45:           equ    $000001F6                                ;*** PWMPER45 - PWM Channel Period 45 Register; 0x000001F6 ***


;*** PWMPER4 - PWM Channel Period 4 Register; 0x000001F6 ***
PWMPER4:            equ    $000001F6                                ;*** PWMPER4 - PWM Channel Period 4 Register; 0x000001F6 ***


;*** PWMPER5 - PWM Channel Period 5 Register; 0x000001F7 ***
PWMPER5:            equ    $000001F7                                ;*** PWMPER5 - PWM Channel Period 5 Register; 0x000001F7 ***


;*** PWMDTY01 - PWM Channel Duty 01 Register; 0x000001F8 ***
PWMDTY01:           equ    $000001F8                                ;*** PWMDTY01 - PWM Channel Duty 01 Register; 0x000001F8 ***


;*** PWMDTY0 - PWM Channel Duty 0 Register; 0x000001F8 ***
PWMDTY0:            equ    $000001F8                                ;*** PWMDTY0 - PWM Channel Duty 0 Register; 0x000001F8 ***


;*** PWMDTY1 - PWM Channel Duty 1 Register; 0x000001F9 ***
PWMDTY1:            equ    $000001F9                                ;*** PWMDTY1 - PWM Channel Duty 1 Register; 0x000001F9 ***


;*** PWMDTY23 - PWM Channel Duty 23 Register; 0x000001FA ***
PWMDTY23:           equ    $000001FA                                ;*** PWMDTY23 - PWM Channel Duty 23 Register; 0x000001FA ***


;*** PWMDTY2 - PWM Channel Duty 2 Register; 0x000001FA ***
PWMDTY2:            equ    $000001FA                                ;*** PWMDTY2 - PWM Channel Duty 2 Register; 0x000001FA ***


;*** PWMDTY3 - PWM Channel Duty 3 Register; 0x000001FB ***
PWMDTY3:            equ    $000001FB                                ;*** PWMDTY3 - PWM Channel Duty 3 Register; 0x000001FB ***


;*** PWMDTY45 - PWM Channel Duty 45 Register; 0x000001FC ***
PWMDTY45:           equ    $000001FC                                ;*** PWMDTY45 - PWM Channel Duty 45 Register; 0x000001FC ***


;*** PWMDTY4 - PWM Channel Duty 4 Register; 0x000001FC ***
PWMDTY4:            equ    $000001FC                                ;*** PWMDTY4 - PWM Channel Duty 4 Register; 0x000001FC ***


;*** PWMDTY5 - PWM Channel Duty 5 Register; 0x000001FD ***
PWMDTY5:            equ    $000001FD                                ;*** PWMDTY5 - PWM Channel Duty 5 Register; 0x000001FD ***


;*** PWMSDN - PWM Shutdown Register; 0x000001FE ***
PWMSDN:             equ    $000001FE                                ;*** PWMSDN - PWM Shutdown Register; 0x000001FE ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PWMSDN_PWM5ENA:     equ    0                                         ; PWM emergency shutdown Enable
PWMSDN_PWM5INL:     equ    1                                         ; PWM shutdown active input level for ch. 5
PWMSDN_PWM5IN:      equ    2                                         ; PWM channel 5 input status
PWMSDN_PWMLVL:      equ    4                                         ; PWM shutdown output Level
PWMSDN_PWMRSTRT:    equ    5                                         ; PWM Restart
PWMSDN_PWMIE:       equ    6                                         ; PWM Interrupt Enable
PWMSDN_PWMIF:       equ    7                                         ; PWM Interrupt Flag
; bit position masks
mPWMSDN_PWM5ENA:    equ    %00000001
mPWMSDN_PWM5INL:    equ    %00000010
mPWMSDN_PWM5IN:     equ    %00000100
mPWMSDN_PWMLVL:     equ    %00010000
mPWMSDN_PWMRSTRT:   equ    %00100000
mPWMSDN_PWMIE:      equ    %01000000
mPWMSDN_PWMIF:      equ    %10000000


;*** PMFCFG0 - PMF Configure 0 Register; 0x00000200 ***
PMFCFG0:            equ    $00000200                                ;*** PMFCFG0 - PMF Configure 0 Register; 0x00000200 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PMFCFG0_INDEPA:     equ    0                                         ; Independent or Complimentary Operation for Pair A
PMFCFG0_INDEPB:     equ    1                                         ; Independent or Complimentary Operation for Pair B
PMFCFG0_INDEPC:     equ    2                                         ; Independent or Complimentary Operation for Pair C
PMFCFG0_EDGEA:      equ    3                                         ; Edge-Aligned or Center-Aligned PWM for Pair A
PMFCFG0_EDGEB:      equ    4                                         ; Edge-Aligned or Center-Aligned PWM for Pair B
PMFCFG0_EDGEC:      equ    5                                         ; Edge-Aligned or Center-Aligned PWM for Pair C
PMFCFG0_MTG:        equ    6                                         ; Multiple Timebase Generators
PMFCFG0_WP:         equ    7                                         ; Write Protect
; bit position masks
mPMFCFG0_INDEPA:    equ    %00000001
mPMFCFG0_INDEPB:    equ    %00000010
mPMFCFG0_INDEPC:    equ    %00000100
mPMFCFG0_EDGEA:     equ    %00001000
mPMFCFG0_EDGEB:     equ    %00010000
mPMFCFG0_EDGEC:     equ    %00100000
mPMFCFG0_MTG:       equ    %01000000
mPMFCFG0_WP:        equ    %10000000


;*** PMFCFG1 - PMF Configure 1 Register; 0x00000201 ***
PMFCFG1:            equ    $00000201                                ;*** PMFCFG1 - PMF Configure 1 Register; 0x00000201 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PMFCFG1_TOPNEGA:    equ    0                                         ; Pair A Top-side PWM Polarity
PMFCFG1_BOTNEGA:    equ    1                                         ; Pair A Bottom-side PWM Polarity
PMFCFG1_TOPNEGB:    equ    2                                         ; Pair B Top-side PWM Polarity
PMFCFG1_BOTNEGB:    equ    3                                         ; Pair B Bottom-side PWM Polarity
PMFCFG1_TOPNEGC:    equ    4                                         ; Pair C Top-side PWM Polarity
PMFCFG1_BOTNEGC:    equ    5                                         ; Pair C Bottom-side PWM Polarity
PMFCFG1_ENHA:       equ    7                                         ; Enable Hardware Acceleration
; bit position masks
mPMFCFG1_TOPNEGA:   equ    %00000001
mPMFCFG1_BOTNEGA:   equ    %00000010
mPMFCFG1_TOPNEGB:   equ    %00000100
mPMFCFG1_BOTNEGB:   equ    %00001000
mPMFCFG1_TOPNEGC:   equ    %00010000
mPMFCFG1_BOTNEGC:   equ    %00100000
mPMFCFG1_ENHA:      equ    %10000000


;*** PMFCFG2 - PMF Configure 2 Register; 0x00000202 ***
PMFCFG2:            equ    $00000202                                ;*** PMFCFG2 - PMF Configure 2 Register; 0x00000202 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PMFCFG2_MSK0:       equ    0                                         ; Mask PWM 0
PMFCFG2_MSK1:       equ    1                                         ; Mask PWM 1
PMFCFG2_MSK2:       equ    2                                         ; Mask PWM 2
PMFCFG2_MSK3:       equ    3                                         ; Mask PWM 3
PMFCFG2_MSK4:       equ    4                                         ; Mask PWM 4
PMFCFG2_MSK5:       equ    5                                         ; Mask PWM 5
; bit position masks
mPMFCFG2_MSK0:      equ    %00000001
mPMFCFG2_MSK1:      equ    %00000010
mPMFCFG2_MSK2:      equ    %00000100
mPMFCFG2_MSK3:      equ    %00001000
mPMFCFG2_MSK4:      equ    %00010000
mPMFCFG2_MSK5:      equ    %00100000


;*** PMFCFG3 - PMF Configure 3 Register; 0x00000203 ***
PMFCFG3:            equ    $00000203                                ;*** PMFCFG3 - PMF Configure 3 Register; 0x00000203 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PMFCFG3_SWAPA:      equ    0                                         ; Swap Pair A
PMFCFG3_SWAPB:      equ    1                                         ; Swap Pair B
PMFCFG3_SWAPC:      equ    2                                         ; Swap Pair C
PMFCFG3_VLMODE0:    equ    3                                         ; Value Register Load Mode Bit 0
PMFCFG3_VLMODE1:    equ    4                                         ; Value Register Load Mode Bit 1
PMFCFG3_PMFFRZ:     equ    6                                         ; PMF stops in FREEZE mode
PMFCFG3_PMFWAI:     equ    7                                         ; PMF stops in WAIT mode
; bit position masks
mPMFCFG3_SWAPA:     equ    %00000001
mPMFCFG3_SWAPB:     equ    %00000010
mPMFCFG3_SWAPC:     equ    %00000100
mPMFCFG3_VLMODE0:   equ    %00001000
mPMFCFG3_VLMODE1:   equ    %00010000
mPMFCFG3_PMFFRZ:    equ    %01000000
mPMFCFG3_PMFWAI:    equ    %10000000


;*** PMFFCTL - PMF fault control register; 0x00000204 ***
PMFFCTL:            equ    $00000204                                ;*** PMFFCTL - PMF fault control register; 0x00000204 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PMFFCTL_FIE0:       equ    0                                         ; Fault 0 Pin Interrupt Enable
PMFFCTL_FMODE0:     equ    1                                         ; Fault 0 Pin Clearing Mode
PMFFCTL_FIE1:       equ    2                                         ; Fault 1 Pin Interrupt Enable
PMFFCTL_FMODE1:     equ    3                                         ; Fault 1 Pin Clearing Mode
PMFFCTL_FIE2:       equ    4                                         ; Fault 2 Pin Interrupt Enable
PMFFCTL_FMODE2:     equ    5                                         ; Fault 2 Pin Clearing Mode
PMFFCTL_FIE3:       equ    6                                         ; Fault 3 Pin Interrupt Enable
PMFFCTL_FMODE3:     equ    7                                         ; Fault 3 Pin Clearing Mode
; bit position masks
mPMFFCTL_FIE0:      equ    %00000001
mPMFFCTL_FMODE0:    equ    %00000010
mPMFFCTL_FIE1:      equ    %00000100
mPMFFCTL_FMODE1:    equ    %00001000
mPMFFCTL_FIE2:      equ    %00010000
mPMFFCTL_FMODE2:    equ    %00100000
mPMFFCTL_FIE3:      equ    %01000000
mPMFFCTL_FMODE3:    equ    %10000000


;*** PMFFPIN - PMF fault acknowledge register; 0x00000205 ***
PMFFPIN:            equ    $00000205                                ;*** PMFFPIN - PMF fault acknowledge register; 0x00000205 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PMFFPIN_FPINE0:     equ    0                                         ; Fault 0 Pin Enable
PMFFPIN_FPINE1:     equ    2                                         ; Fault 1 Pin Enable
PMFFPIN_FPINE2:     equ    4                                         ; Fault 2 Pin Enable
PMFFPIN_FPINE3:     equ    6                                         ; Fault 3 Pin Enable
; bit position masks
mPMFFPIN_FPINE0:    equ    %00000001
mPMFFPIN_FPINE1:    equ    %00000100
mPMFFPIN_FPINE2:    equ    %00010000
mPMFFPIN_FPINE3:    equ    %01000000


;*** PMFFSTA - PMF fault status register; 0x00000206 ***
PMFFSTA:            equ    $00000206                                ;*** PMFFSTA - PMF fault status register; 0x00000206 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PMFFSTA_FFLAG0:     equ    0                                         ; Fault 0 pin Flag
PMFFSTA_FFLAG1:     equ    2                                         ; Fault 1 pin Flag
PMFFSTA_FFLAG2:     equ    4                                         ; Fault 2 pin Flag
PMFFSTA_FFLAG3:     equ    6                                         ; Fault 3 pin Flag
; bit position masks
mPMFFSTA_FFLAG0:    equ    %00000001
mPMFFSTA_FFLAG1:    equ    %00000100
mPMFFSTA_FFLAG2:    equ    %00010000
mPMFFSTA_FFLAG3:    equ    %01000000


;*** PMFQSMP - PMF fault qualifying samples register; 0x00000207 ***
PMFQSMP:            equ    $00000207                                ;*** PMFQSMP - PMF fault qualifying samples register; 0x00000207 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PMFQSMP_QSMP00:     equ    0                                         ; Fault 0 Qualifying samples, bit 0
PMFQSMP_QSMP01:     equ    1                                         ; Fault 0 Qualifying samples, bit 1
PMFQSMP_QSMP10:     equ    2                                         ; Fault 1 Qualifying samples, bit 0
PMFQSMP_QSMP11:     equ    3                                         ; Fault 1 Qualifying samples, bit 1
PMFQSMP_QSMP20:     equ    4                                         ; Fault 2 Qualifying samples, bit 0
PMFQSMP_QSMP21:     equ    5                                         ; Fault 2 Qualifying samples, bit 1
PMFQSMP_QSMP30:     equ    6                                         ; Fault 3 Qualifying samples, bit 0
PMFQSMP_QSMP31:     equ    7                                         ; Fault 3 Qualifying samples, bit 1
; bit position masks
mPMFQSMP_QSMP00:    equ    %00000001
mPMFQSMP_QSMP01:    equ    %00000010
mPMFQSMP_QSMP10:    equ    %00000100
mPMFQSMP_QSMP11:    equ    %00001000
mPMFQSMP_QSMP20:    equ    %00010000
mPMFQSMP_QSMP21:    equ    %00100000
mPMFQSMP_QSMP30:    equ    %01000000
mPMFQSMP_QSMP31:    equ    %10000000


;*** PMFDMPA - PMF disable mapping A register; 0x00000208 ***
PMFDMPA:            equ    $00000208                                ;*** PMFDMPA - PMF disable mapping A register; 0x00000208 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PMFDMPA_DMP00:      equ    0                                         ; PMF Disable Mapping A Bit 00
PMFDMPA_DMP01:      equ    1                                         ; PMF Disable Mapping A Bit 01
PMFDMPA_DMP02:      equ    2                                         ; PMF Disable Mapping A Bit 02
PMFDMPA_DMP03:      equ    3                                         ; PMF Disable Mapping A Bit 03
PMFDMPA_DMP10:      equ    4                                         ; PMF Disable Mapping A Bit 10
PMFDMPA_DMP11:      equ    5                                         ; PMF Disable Mapping A Bit 11
PMFDMPA_DMP12:      equ    6                                         ; PMF Disable Mapping A Bit 12
PMFDMPA_DMP13:      equ    7                                         ; PMF Disable Mapping A Bit 13
; bit position masks
mPMFDMPA_DMP00:     equ    %00000001
mPMFDMPA_DMP01:     equ    %00000010
mPMFDMPA_DMP02:     equ    %00000100
mPMFDMPA_DMP03:     equ    %00001000
mPMFDMPA_DMP10:     equ    %00010000
mPMFDMPA_DMP11:     equ    %00100000
mPMFDMPA_DMP12:     equ    %01000000
mPMFDMPA_DMP13:     equ    %10000000


;*** PMFDMPB - PMF disable mapping B register; 0x00000209 ***
PMFDMPB:            equ    $00000209                                ;*** PMFDMPB - PMF disable mapping B register; 0x00000209 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PMFDMPB_DMP20:      equ    0                                         ; PMF Disable Mapping A Bit 20
PMFDMPB_DMP21:      equ    1                                         ; PMF Disable Mapping A Bit 21
PMFDMPB_DMP22:      equ    2                                         ; PMF Disable Mapping A Bit 22
PMFDMPB_DMP23:      equ    3                                         ; PMF Disable Mapping A Bit 23
PMFDMPB_DMP30:      equ    4                                         ; PMF Disable Mapping A Bit 30
PMFDMPB_DMP31:      equ    5                                         ; PMF Disable Mapping A Bit 31
PMFDMPB_DMP32:      equ    6                                         ; PMF Disable Mapping A Bit 32
PMFDMPB_DMP33:      equ    7                                         ; PMF Disable Mapping A Bit 33
; bit position masks
mPMFDMPB_DMP20:     equ    %00000001
mPMFDMPB_DMP21:     equ    %00000010
mPMFDMPB_DMP22:     equ    %00000100
mPMFDMPB_DMP23:     equ    %00001000
mPMFDMPB_DMP30:     equ    %00010000
mPMFDMPB_DMP31:     equ    %00100000
mPMFDMPB_DMP32:     equ    %01000000
mPMFDMPB_DMP33:     equ    %10000000


;*** PMFDMPC - PMF disable mapping C register; 0x0000020A ***
PMFDMPC:            equ    $0000020A                                ;*** PMFDMPC - PMF disable mapping C register; 0x0000020A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PMFDMPC_DMP40:      equ    0                                         ; PMF Disable Mapping A Bit 40
PMFDMPC_DMP41:      equ    1                                         ; PMF Disable Mapping A Bit 41
PMFDMPC_DMP42:      equ    2                                         ; PMF Disable Mapping A Bit 42
PMFDMPC_DMP43:      equ    3                                         ; PMF Disable Mapping A Bit 43
PMFDMPC_DMP50:      equ    4                                         ; PMF Disable Mapping A Bit 50
PMFDMPC_DMP51:      equ    5                                         ; PMF Disable Mapping A Bit 51
PMFDMPC_DMP52:      equ    6                                         ; PMF Disable Mapping A Bit 52
PMFDMPC_DMP53:      equ    7                                         ; PMF Disable Mapping A Bit 53
; bit position masks
mPMFDMPC_DMP40:     equ    %00000001
mPMFDMPC_DMP41:     equ    %00000010
mPMFDMPC_DMP42:     equ    %00000100
mPMFDMPC_DMP43:     equ    %00001000
mPMFDMPC_DMP50:     equ    %00010000
mPMFDMPC_DMP51:     equ    %00100000
mPMFDMPC_DMP52:     equ    %01000000
mPMFDMPC_DMP53:     equ    %10000000


;*** PMFOUTC - PMF output control register; 0x0000020C ***
PMFOUTC:            equ    $0000020C                                ;*** PMFOUTC - PMF output control register; 0x0000020C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PMFOUTC_OUTCTL0:    equ    0                                         ; PMF Output Control Bit 0
PMFOUTC_OUTCTL1:    equ    1                                         ; PMF Output Control Bit 1
PMFOUTC_OUTCTL2:    equ    2                                         ; PMF Output Control Bit 2
PMFOUTC_OUTCTL3:    equ    3                                         ; PMF Output Control Bit 3
PMFOUTC_OUTCTL4:    equ    4                                         ; PMF Output Control Bit 4
PMFOUTC_OUTCTL5:    equ    5                                         ; PMF Output Control Bit 5
; bit position masks
mPMFOUTC_OUTCTL0:   equ    %00000001
mPMFOUTC_OUTCTL1:   equ    %00000010
mPMFOUTC_OUTCTL2:   equ    %00000100
mPMFOUTC_OUTCTL3:   equ    %00001000
mPMFOUTC_OUTCTL4:   equ    %00010000
mPMFOUTC_OUTCTL5:   equ    %00100000


;*** PMFOUTB - PMF output control bit register; 0x0000020D ***
PMFOUTB:            equ    $0000020D                                ;*** PMFOUTB - PMF output control bit register; 0x0000020D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PMFOUTB_OUT0:       equ    0                                         ; PMF Output Control Bit Bit 0
PMFOUTB_OUT1:       equ    1                                         ; PMF Output Control Bit Bit 1
PMFOUTB_OUT2:       equ    2                                         ; PMF Output Control Bit Bit 2
PMFOUTB_OUT3:       equ    3                                         ; PMF Output Control Bit Bit 3
PMFOUTB_OUT4:       equ    4                                         ; PMF Output Control Bit Bit 4
PMFOUTB_OUT5:       equ    5                                         ; PMF Output Control Bit Bit 5
; bit position masks
mPMFOUTB_OUT0:      equ    %00000001
mPMFOUTB_OUT1:      equ    %00000010
mPMFOUTB_OUT2:      equ    %00000100
mPMFOUTB_OUT3:      equ    %00001000
mPMFOUTB_OUT4:      equ    %00010000
mPMFOUTB_OUT5:      equ    %00100000


;*** PMFDTMS - PMF deadtime sample register; 0x0000020E ***
PMFDTMS:            equ    $0000020E                                ;*** PMFDTMS - PMF deadtime sample register; 0x0000020E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PMFDTMS_DT0:        equ    0                                         ; PMF Deadtime Sample Bit 0
PMFDTMS_DT1:        equ    1                                         ; PMF Deadtime Sample Bit 1
PMFDTMS_DT2:        equ    2                                         ; PMF Deadtime Sample Bit 2
PMFDTMS_DT3:        equ    3                                         ; PMF Deadtime Sample Bit 3
PMFDTMS_DT4:        equ    4                                         ; PMF Deadtime Sample Bit 4
PMFDTMS_DT5:        equ    5                                         ; PMF Deadtime Sample Bit 5
; bit position masks
mPMFDTMS_DT0:       equ    %00000001
mPMFDTMS_DT1:       equ    %00000010
mPMFDTMS_DT2:       equ    %00000100
mPMFDTMS_DT3:       equ    %00001000
mPMFDTMS_DT4:       equ    %00010000
mPMFDTMS_DT5:       equ    %00100000


;*** PMFCCTL - PMF correction control register; 0x0000020F ***
PMFCCTL:            equ    $0000020F                                ;*** PMFCCTL - PMF correction control register; 0x0000020F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PMFCCTL_IPOLA:      equ    0                                         ; Current Polarity A
PMFCCTL_IPOLB:      equ    1                                         ; Current Polarity B
PMFCCTL_IPOLC:      equ    2                                         ; Current Polarity C
PMFCCTL_ISENS0:     equ    4                                         ; Current status sensing method Bit 0
PMFCCTL_ISENS1:     equ    5                                         ; Current status sensing method Bit 1
; bit position masks
mPMFCCTL_IPOLA:     equ    %00000001
mPMFCCTL_IPOLB:     equ    %00000010
mPMFCCTL_IPOLC:     equ    %00000100
mPMFCCTL_ISENS0:    equ    %00010000
mPMFCCTL_ISENS1:    equ    %00100000


;*** PMFVAL0 - PMF Value 0 Register; 0x00000210 ***
PMFVAL0:            equ    $00000210                                ;*** PMFVAL0 - PMF Value 0 Register; 0x00000210 ***


;*** PMFVAL1 - PMF Value 1 Register; 0x00000212 ***
PMFVAL1:            equ    $00000212                                ;*** PMFVAL1 - PMF Value 1 Register; 0x00000212 ***


;*** PMFVAL2 - PMF Value 2 Register; 0x00000214 ***
PMFVAL2:            equ    $00000214                                ;*** PMFVAL2 - PMF Value 2 Register; 0x00000214 ***


;*** PMFVAL3 - PMF Value 3 Register; 0x00000216 ***
PMFVAL3:            equ    $00000216                                ;*** PMFVAL3 - PMF Value 3 Register; 0x00000216 ***


;*** PMFVAL4 - PMF Value 4 Register; 0x00000218 ***
PMFVAL4:            equ    $00000218                                ;*** PMFVAL4 - PMF Value 4 Register; 0x00000218 ***


;*** PMFVAL5 - PMF Value 5 Register; 0x0000021A ***
PMFVAL5:            equ    $0000021A                                ;*** PMFVAL5 - PMF Value 5 Register; 0x0000021A ***


;*** PMFENCA - PMF Enable Control A Register; 0x00000220 ***
PMFENCA:            equ    $00000220                                ;*** PMFENCA - PMF Enable Control A Register; 0x00000220 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PMFENCA_PWMRIEA:    equ    0                                         ; PWM Reload Interrupt Enable A
PMFENCA_LDOKA:      equ    1                                         ; Load Okay A
PMFENCA_PWMENA:     equ    7                                         ; PWM Generator A Enable
; bit position masks
mPMFENCA_PWMRIEA:   equ    %00000001
mPMFENCA_LDOKA:     equ    %00000010
mPMFENCA_PWMENA:    equ    %10000000


;*** PMFFQCA - PMF Frequency Control A Register; 0x00000221 ***
PMFFQCA:            equ    $00000221                                ;*** PMFFQCA - PMF Frequency Control A Register; 0x00000221 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PMFFQCA_PWMRFA:     equ    0                                         ; PWM Reload Flag A
PMFFQCA_PRSCA0:     equ    1                                         ; Prescaler A, bit 0
PMFFQCA_PRSCA1:     equ    2                                         ; Prescaler A, bit 1
PMFFQCA_HALFA:      equ    3                                         ; Half Cycle Reload A
PMFFQCA_LDFQA0:     equ    4                                         ; Load Frequency A, bit 0
PMFFQCA_LDFQA1:     equ    5                                         ; Load Frequency A, bit 1
PMFFQCA_LDFQA2:     equ    6                                         ; Load Frequency A, bit 2
PMFFQCA_LDFQA3:     equ    7                                         ; Load Frequency A, bit 3
; bit position masks
mPMFFQCA_PWMRFA:    equ    %00000001
mPMFFQCA_PRSCA0:    equ    %00000010
mPMFFQCA_PRSCA1:    equ    %00000100
mPMFFQCA_HALFA:     equ    %00001000
mPMFFQCA_LDFQA0:    equ    %00010000
mPMFFQCA_LDFQA1:    equ    %00100000
mPMFFQCA_LDFQA2:    equ    %01000000
mPMFFQCA_LDFQA3:    equ    %10000000


;*** PMFCNTA - PMF Counter A Register; 0x00000222 ***
PMFCNTA:            equ    $00000222                                ;*** PMFCNTA - PMF Counter A Register; 0x00000222 ***


;*** PMFMODA - PMF Counter Modulo A Register; 0x00000224 ***
PMFMODA:            equ    $00000224                                ;*** PMFMODA - PMF Counter Modulo A Register; 0x00000224 ***


;*** PMFDTMA - PMF Deadtime A Register; 0x00000226 ***
PMFDTMA:            equ    $00000226                                ;*** PMFDTMA - PMF Deadtime A Register; 0x00000226 ***


;*** PMFENCB - PMF enable control B register; 0x00000228 ***
PMFENCB:            equ    $00000228                                ;*** PMFENCB - PMF enable control B register; 0x00000228 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PMFENCB_PWMRIEB:    equ    0                                         ; PWM Reload Interrupt Enable B
PMFENCB_LDOKB:      equ    1                                         ; Load Okay B
PMFENCB_PWMENB:     equ    7                                         ; PWM Generator B Enable
; bit position masks
mPMFENCB_PWMRIEB:   equ    %00000001
mPMFENCB_LDOKB:     equ    %00000010
mPMFENCB_PWMENB:    equ    %10000000


;*** PMFFQCB - PMF Frequency Control B Register; 0x00000229 ***
PMFFQCB:            equ    $00000229                                ;*** PMFFQCB - PMF Frequency Control B Register; 0x00000229 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PMFFQCB_PWMRFB:     equ    0                                         ; PWM Reload Flag B
PMFFQCB_PRSCB0:     equ    1                                         ; Prescaler B, bit 0
PMFFQCB_PRSCB1:     equ    2                                         ; Prescaler B, bit 1
PMFFQCB_HALFB:      equ    3                                         ; Half Cycle Reload B
PMFFQCB_LDFQB0:     equ    4                                         ; Load Frequency B, bit 0
PMFFQCB_LDFQB1:     equ    5                                         ; Load Frequency B, bit 1
PMFFQCB_LDFQB2:     equ    6                                         ; Load Frequency B, bit 2
PMFFQCB_LDFQB3:     equ    7                                         ; Load Frequency B, bit 3
; bit position masks
mPMFFQCB_PWMRFB:    equ    %00000001
mPMFFQCB_PRSCB0:    equ    %00000010
mPMFFQCB_PRSCB1:    equ    %00000100
mPMFFQCB_HALFB:     equ    %00001000
mPMFFQCB_LDFQB0:    equ    %00010000
mPMFFQCB_LDFQB1:    equ    %00100000
mPMFFQCB_LDFQB2:    equ    %01000000
mPMFFQCB_LDFQB3:    equ    %10000000


;*** PMFCNTB - PMF Counter B Register; 0x0000022A ***
PMFCNTB:            equ    $0000022A                                ;*** PMFCNTB - PMF Counter B Register; 0x0000022A ***


;*** PMFMODB - PMF Counter Modulo B Register; 0x0000022C ***
PMFMODB:            equ    $0000022C                                ;*** PMFMODB - PMF Counter Modulo B Register; 0x0000022C ***


;*** PMFDTMB - PMF Deadtime B Register; 0x0000022E ***
PMFDTMB:            equ    $0000022E                                ;*** PMFDTMB - PMF Deadtime B Register; 0x0000022E ***


;*** PMFENCC - PMF Enable Control C Register; 0x00000230 ***
PMFENCC:            equ    $00000230                                ;*** PMFENCC - PMF Enable Control C Register; 0x00000230 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PMFENCC_PWMRIEC:    equ    0                                         ; PWM Reload Interrupt Enable C
PMFENCC_LDOKC:      equ    1                                         ; Load Okay C
PMFENCC_PWMENC:     equ    7                                         ; PWM Generator C Enable
; bit position masks
mPMFENCC_PWMRIEC:   equ    %00000001
mPMFENCC_LDOKC:     equ    %00000010
mPMFENCC_PWMENC:    equ    %10000000


;*** PMFFQCC - PMF Frequency Control C Register; 0x00000231 ***
PMFFQCC:            equ    $00000231                                ;*** PMFFQCC - PMF Frequency Control C Register; 0x00000231 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PMFFQCC_PWMRFC:     equ    0                                         ; PWM Reload Flag C
PMFFQCC_PRSCC0:     equ    1                                         ; Prescaler C, bit 0
PMFFQCC_PRSCC1:     equ    2                                         ; Prescaler C, bit 1
PMFFQCC_HALFC:      equ    3                                         ; Half Cycle Reload C
PMFFQCC_LDFQC0:     equ    4                                         ; Load Frequency C, bit 0
PMFFQCC_LDFQC1:     equ    5                                         ; Load Frequency C, bit 1
PMFFQCC_LDFQC2:     equ    6                                         ; Load Frequency C, bit 2
PMFFQCC_LDFQC3:     equ    7                                         ; Load Frequency C, bit 3
; bit position masks
mPMFFQCC_PWMRFC:    equ    %00000001
mPMFFQCC_PRSCC0:    equ    %00000010
mPMFFQCC_PRSCC1:    equ    %00000100
mPMFFQCC_HALFC:     equ    %00001000
mPMFFQCC_LDFQC0:    equ    %00010000
mPMFFQCC_LDFQC1:    equ    %00100000
mPMFFQCC_LDFQC2:    equ    %01000000
mPMFFQCC_LDFQC3:    equ    %10000000


;*** PMFCNTC - PMF Counter C Register; 0x00000232 ***
PMFCNTC:            equ    $00000232                                ;*** PMFCNTC - PMF Counter C Register; 0x00000232 ***


;*** PMFMODC - PMF Counter Modulo C Register; 0x00000234 ***
PMFMODC:            equ    $00000234                                ;*** PMFMODC - PMF Counter Modulo C Register; 0x00000234 ***


;*** PMFDTMC - PMF Deadtime C Register; 0x00000236 ***
PMFDTMC:            equ    $00000236                                ;*** PMFDTMC - PMF Deadtime C Register; 0x00000236 ***


;*** PTT - Port T I/O Register; 0x00000240 ***
PTT:                equ    $00000240                                ;*** PTT - Port T I/O Register; 0x00000240 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTT_PTT0:           equ    0                                         ; Port T Bit 0
PTT_PTT1:           equ    1                                         ; Port T Bit 1
PTT_PTT2:           equ    2                                         ; Port T Bit 2
PTT_PTT3:           equ    3                                         ; Port T Bit 3
PTT_PTT4:           equ    4                                         ; Port T Bit 4
PTT_PTT5:           equ    5                                         ; Port T Bit 5
PTT_PTT6:           equ    6                                         ; Port T Bit 6
PTT_PTT7:           equ    7                                         ; Port T Bit 7
; bit position masks
mPTT_PTT0:          equ    %00000001
mPTT_PTT1:          equ    %00000010
mPTT_PTT2:          equ    %00000100
mPTT_PTT3:          equ    %00001000
mPTT_PTT4:          equ    %00010000
mPTT_PTT5:          equ    %00100000
mPTT_PTT6:          equ    %01000000
mPTT_PTT7:          equ    %10000000


;*** PTIT - Port T Input Register; 0x00000241 ***
PTIT:               equ    $00000241                                ;*** PTIT - Port T Input Register; 0x00000241 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTIT_PTIT0:         equ    0                                         ; Port T Bit 0
PTIT_PTIT1:         equ    1                                         ; Port T Bit 1
PTIT_PTIT2:         equ    2                                         ; Port T Bit 2
PTIT_PTIT3:         equ    3                                         ; Port T Bit 3
PTIT_PTIT4:         equ    4                                         ; Port T Bit 4
PTIT_PTIT5:         equ    5                                         ; Port T Bit 5
PTIT_PTIT6:         equ    6                                         ; Port T Bit 6
PTIT_PTIT7:         equ    7                                         ; Port T Bit 7
; bit position masks
mPTIT_PTIT0:        equ    %00000001
mPTIT_PTIT1:        equ    %00000010
mPTIT_PTIT2:        equ    %00000100
mPTIT_PTIT3:        equ    %00001000
mPTIT_PTIT4:        equ    %00010000
mPTIT_PTIT5:        equ    %00100000
mPTIT_PTIT6:        equ    %01000000
mPTIT_PTIT7:        equ    %10000000


;*** DDRT - Port T Data Direction Register; 0x00000242 ***
DDRT:               equ    $00000242                                ;*** DDRT - Port T Data Direction Register; 0x00000242 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRT_DDRT0:         equ    0                                         ; Data Direction Port T Bit 0
DDRT_DDRT1:         equ    1                                         ; Data Direction Port T Bit 1
DDRT_DDRT2:         equ    2                                         ; Data Direction Port T Bit 2
DDRT_DDRT3:         equ    3                                         ; Data Direction Port T Bit 3
DDRT_DDRT4:         equ    4                                         ; Data Direction Port T Bit 4
DDRT_DDRT5:         equ    5                                         ; Data Direction Port T Bit 5
DDRT_DDRT6:         equ    6                                         ; Data Direction Port T Bit 6
DDRT_DDRT7:         equ    7                                         ; Data Direction Port T Bit 7
; bit position masks
mDDRT_DDRT0:        equ    %00000001
mDDRT_DDRT1:        equ    %00000010
mDDRT_DDRT2:        equ    %00000100
mDDRT_DDRT3:        equ    %00001000
mDDRT_DDRT4:        equ    %00010000
mDDRT_DDRT5:        equ    %00100000
mDDRT_DDRT6:        equ    %01000000
mDDRT_DDRT7:        equ    %10000000


;*** RDRT - Port T Reduced Drive Register; 0x00000243 ***
RDRT:               equ    $00000243                                ;*** RDRT - Port T Reduced Drive Register; 0x00000243 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RDRT_RDRT0:         equ    0                                         ; Reduced Drive Port T Bit 0
RDRT_RDRT1:         equ    1                                         ; Reduced Drive Port T Bit 1
RDRT_RDRT2:         equ    2                                         ; Reduced Drive Port T Bit 2
RDRT_RDRT3:         equ    3                                         ; Reduced Drive Port T Bit 3
RDRT_RDRT4:         equ    4                                         ; Reduced Drive Port T Bit 4
RDRT_RDRT5:         equ    5                                         ; Reduced Drive Port T Bit 5
RDRT_RDRT6:         equ    6                                         ; Reduced Drive Port T Bit 6
RDRT_RDRT7:         equ    7                                         ; Reduced Drive Port T Bit 7
; bit position masks
mRDRT_RDRT0:        equ    %00000001
mRDRT_RDRT1:        equ    %00000010
mRDRT_RDRT2:        equ    %00000100
mRDRT_RDRT3:        equ    %00001000
mRDRT_RDRT4:        equ    %00010000
mRDRT_RDRT5:        equ    %00100000
mRDRT_RDRT6:        equ    %01000000
mRDRT_RDRT7:        equ    %10000000


;*** PERT - Port T Pull Device Enable Register; 0x00000244 ***
PERT:               equ    $00000244                                ;*** PERT - Port T Pull Device Enable Register; 0x00000244 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PERT_PERT0:         equ    0                                         ; Pull Device Enable Port T Bit 0
PERT_PERT1:         equ    1                                         ; Pull Device Enable Port T Bit 1
PERT_PERT2:         equ    2                                         ; Pull Device Enable Port T Bit 2
PERT_PERT3:         equ    3                                         ; Pull Device Enable Port T Bit 3
PERT_PERT4:         equ    4                                         ; Pull Device Enable Port T Bit 4
PERT_PERT5:         equ    5                                         ; Pull Device Enable Port T Bit 5
PERT_PERT6:         equ    6                                         ; Pull Device Enable Port T Bit 6
PERT_PERT7:         equ    7                                         ; Pull Device Enable Port T Bit 7
; bit position masks
mPERT_PERT0:        equ    %00000001
mPERT_PERT1:        equ    %00000010
mPERT_PERT2:        equ    %00000100
mPERT_PERT3:        equ    %00001000
mPERT_PERT4:        equ    %00010000
mPERT_PERT5:        equ    %00100000
mPERT_PERT6:        equ    %01000000
mPERT_PERT7:        equ    %10000000


;*** PPST - Port T Polarity Select Register; 0x00000245 ***
PPST:               equ    $00000245                                ;*** PPST - Port T Polarity Select Register; 0x00000245 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PPST_PPST0:         equ    0                                         ; Pull Select Port T Bit 0
PPST_PPST1:         equ    1                                         ; Pull Select Port T Bit 1
PPST_PPST2:         equ    2                                         ; Pull Select Port T Bit 2
PPST_PPST3:         equ    3                                         ; Pull Select Port T Bit 3
PPST_PPST4:         equ    4                                         ; Pull Select Port T Bit 4
PPST_PPST5:         equ    5                                         ; Pull Select Port T Bit 5
PPST_PPST6:         equ    6                                         ; Pull Select Port T Bit 6
PPST_PPST7:         equ    7                                         ; Pull Select Port T Bit 7
; bit position masks
mPPST_PPST0:        equ    %00000001
mPPST_PPST1:        equ    %00000010
mPPST_PPST2:        equ    %00000100
mPPST_PPST3:        equ    %00001000
mPPST_PPST4:        equ    %00010000
mPPST_PPST5:        equ    %00100000
mPPST_PPST6:        equ    %01000000
mPPST_PPST7:        equ    %10000000


;*** PTS - Port S I/O Register; 0x00000248 ***
PTS:                equ    $00000248                                ;*** PTS - Port S I/O Register; 0x00000248 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTS_PTS0:           equ    0                                         ; Port S Bit 0
PTS_PTS1:           equ    1                                         ; Port S Bit 1
PTS_PTS2:           equ    2                                         ; Port S Bit 2
PTS_PTS3:           equ    3                                         ; Port S Bit 3
PTS_PTS4:           equ    4                                         ; Port S Bit 4
PTS_PTS5:           equ    5                                         ; Port S Bit 5
PTS_PTS6:           equ    6                                         ; Port S Bit 6
PTS_PTS7:           equ    7                                         ; Port S Bit 7
; bit position masks
mPTS_PTS0:          equ    %00000001
mPTS_PTS1:          equ    %00000010
mPTS_PTS2:          equ    %00000100
mPTS_PTS3:          equ    %00001000
mPTS_PTS4:          equ    %00010000
mPTS_PTS5:          equ    %00100000
mPTS_PTS6:          equ    %01000000
mPTS_PTS7:          equ    %10000000


;*** PTIS - Port S Input Register; 0x00000249 ***
PTIS:               equ    $00000249                                ;*** PTIS - Port S Input Register; 0x00000249 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTIS_PTIS0:         equ    0                                         ; Port S Bit 0
PTIS_PTIS1:         equ    1                                         ; Port S Bit 1
PTIS_PTIS2:         equ    2                                         ; Port S Bit 2
PTIS_PTIS3:         equ    3                                         ; Port S Bit 3
PTIS_PTIS4:         equ    4                                         ; Port S Bit 4
PTIS_PTIS5:         equ    5                                         ; Port S Bit 5
PTIS_PTIS6:         equ    6                                         ; Port S Bit 6
PTIS_PTIS7:         equ    7                                         ; Port S Bit 7
; bit position masks
mPTIS_PTIS0:        equ    %00000001
mPTIS_PTIS1:        equ    %00000010
mPTIS_PTIS2:        equ    %00000100
mPTIS_PTIS3:        equ    %00001000
mPTIS_PTIS4:        equ    %00010000
mPTIS_PTIS5:        equ    %00100000
mPTIS_PTIS6:        equ    %01000000
mPTIS_PTIS7:        equ    %10000000


;*** DDRS - Port S Data Direction Register; 0x0000024A ***
DDRS:               equ    $0000024A                                ;*** DDRS - Port S Data Direction Register; 0x0000024A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRS_DDRS0:         equ    0                                         ; Data Direction Port S Bit 0
DDRS_DDRS1:         equ    1                                         ; Data Direction Port S Bit 1
DDRS_DDRS2:         equ    2                                         ; Data Direction Port S Bit 2
DDRS_DDRS3:         equ    3                                         ; Data Direction Port S Bit 3
DDRS_DDRS4:         equ    4                                         ; Data Direction Port S Bit 4
DDRS_DDRS5:         equ    5                                         ; Data Direction Port S Bit 5
DDRS_DDRS6:         equ    6                                         ; Data Direction Port S Bit 6
DDRS_DDRS7:         equ    7                                         ; Data Direction Port S Bit 7
; bit position masks
mDDRS_DDRS0:        equ    %00000001
mDDRS_DDRS1:        equ    %00000010
mDDRS_DDRS2:        equ    %00000100
mDDRS_DDRS3:        equ    %00001000
mDDRS_DDRS4:        equ    %00010000
mDDRS_DDRS5:        equ    %00100000
mDDRS_DDRS6:        equ    %01000000
mDDRS_DDRS7:        equ    %10000000


;*** RDRS - Port S Reduced Drive Register; 0x0000024B ***
RDRS:               equ    $0000024B                                ;*** RDRS - Port S Reduced Drive Register; 0x0000024B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RDRS_RDRS0:         equ    0                                         ; Reduced Drive Port S Bit 0
RDRS_RDRS1:         equ    1                                         ; Reduced Drive Port S Bit 1
RDRS_RDRS2:         equ    2                                         ; Reduced Drive Port S Bit 2
RDRS_RDRS3:         equ    3                                         ; Reduced Drive Port S Bit 3
RDRS_RDRS4:         equ    4                                         ; Reduced Drive Port S Bit 4
RDRS_RDRS5:         equ    5                                         ; Reduced Drive Port S Bit 5
RDRS_RDRS6:         equ    6                                         ; Reduced Drive Port S Bit 6
RDRS_RDRS7:         equ    7                                         ; Reduced Drive Port S Bit 7
; bit position masks
mRDRS_RDRS0:        equ    %00000001
mRDRS_RDRS1:        equ    %00000010
mRDRS_RDRS2:        equ    %00000100
mRDRS_RDRS3:        equ    %00001000
mRDRS_RDRS4:        equ    %00010000
mRDRS_RDRS5:        equ    %00100000
mRDRS_RDRS6:        equ    %01000000
mRDRS_RDRS7:        equ    %10000000


;*** PERS - Port S Pull Device Enable Register; 0x0000024C ***
PERS:               equ    $0000024C                                ;*** PERS - Port S Pull Device Enable Register; 0x0000024C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PERS_PERS0:         equ    0                                         ; Pull Device Enable Port S Bit 0
PERS_PERS1:         equ    1                                         ; Pull Device Enable Port S Bit 1
PERS_PERS2:         equ    2                                         ; Pull Device Enable Port S Bit 2
PERS_PERS3:         equ    3                                         ; Pull Device Enable Port S Bit 3
PERS_PERS4:         equ    4                                         ; Pull Device Enable Port S Bit 4
PERS_PERS5:         equ    5                                         ; Pull Device Enable Port S Bit 5
PERS_PERS6:         equ    6                                         ; Pull Device Enable Port S Bit 6
PERS_PERS7:         equ    7                                         ; Pull Device Enable Port S Bit 7
; bit position masks
mPERS_PERS0:        equ    %00000001
mPERS_PERS1:        equ    %00000010
mPERS_PERS2:        equ    %00000100
mPERS_PERS3:        equ    %00001000
mPERS_PERS4:        equ    %00010000
mPERS_PERS5:        equ    %00100000
mPERS_PERS6:        equ    %01000000
mPERS_PERS7:        equ    %10000000


;*** PPSS - Port S Polarity Select Register; 0x0000024D ***
PPSS:               equ    $0000024D                                ;*** PPSS - Port S Polarity Select Register; 0x0000024D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PPSS_PPSS0:         equ    0                                         ; Pull Select Port S Bit 0
PPSS_PPSS1:         equ    1                                         ; Pull Select Port S Bit 1
PPSS_PPSS2:         equ    2                                         ; Pull Select Port S Bit 2
PPSS_PPSS3:         equ    3                                         ; Pull Select Port S Bit 3
PPSS_PPSS4:         equ    4                                         ; Pull Select Port S Bit 4
PPSS_PPSS5:         equ    5                                         ; Pull Select Port S Bit 5
PPSS_PPSS6:         equ    6                                         ; Pull Select Port S Bit 6
PPSS_PPSS7:         equ    7                                         ; Pull Select Port S Bit 7
; bit position masks
mPPSS_PPSS0:        equ    %00000001
mPPSS_PPSS1:        equ    %00000010
mPPSS_PPSS2:        equ    %00000100
mPPSS_PPSS3:        equ    %00001000
mPPSS_PPSS4:        equ    %00010000
mPPSS_PPSS5:        equ    %00100000
mPPSS_PPSS6:        equ    %01000000
mPPSS_PPSS7:        equ    %10000000


;*** WOMS - Port S Wired-Or Mode Register; 0x0000024E ***
WOMS:               equ    $0000024E                                ;*** WOMS - Port S Wired-Or Mode Register; 0x0000024E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
WOMS_WOMS0:         equ    0                                         ; Wired-Or Mode Port S Bit 0
WOMS_WOMS1:         equ    1                                         ; Wired-Or Mode Port S Bit 1
WOMS_WOMS2:         equ    2                                         ; Wired-Or Mode Port S Bit 2
WOMS_WOMS3:         equ    3                                         ; Wired-Or Mode Port S Bit 3
WOMS_WOMS4:         equ    4                                         ; Wired-Or Mode Port S Bit 4
WOMS_WOMS5:         equ    5                                         ; Wired-Or Mode Port S Bit 5
WOMS_WOMS6:         equ    6                                         ; Wired-Or Mode Port S Bit 6
WOMS_WOMS7:         equ    7                                         ; Wired-Or Mode Port S Bit 7
; bit position masks
mWOMS_WOMS0:        equ    %00000001
mWOMS_WOMS1:        equ    %00000010
mWOMS_WOMS2:        equ    %00000100
mWOMS_WOMS3:        equ    %00001000
mWOMS_WOMS4:        equ    %00010000
mWOMS_WOMS5:        equ    %00100000
mWOMS_WOMS6:        equ    %01000000
mWOMS_WOMS7:        equ    %10000000


;*** PTM - Port M I/O Register; 0x00000250 ***
PTM:                equ    $00000250                                ;*** PTM - Port M I/O Register; 0x00000250 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTM_PTM0:           equ    0                                         ; Port M Bit 0
PTM_PTM1:           equ    1                                         ; Port M Bit 1
PTM_PTM3:           equ    3                                         ; Port M Bit 3
PTM_PTM4:           equ    4                                         ; Port M Bit 4
PTM_PTM5:           equ    5                                         ; Port M Bit 5
PTM_PTM6:           equ    6                                         ; Port M Bit 6
PTM_PTM7:           equ    7                                         ; Port M Bit 7
; bit position masks
mPTM_PTM0:          equ    %00000001
mPTM_PTM1:          equ    %00000010
mPTM_PTM3:          equ    %00001000
mPTM_PTM4:          equ    %00010000
mPTM_PTM5:          equ    %00100000
mPTM_PTM6:          equ    %01000000
mPTM_PTM7:          equ    %10000000


;*** PTIM - Port M Input Register; 0x00000251 ***
PTIM:               equ    $00000251                                ;*** PTIM - Port M Input Register; 0x00000251 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTIM_PTIM0:         equ    0                                         ; Port M Bit 0
PTIM_PTIM1:         equ    1                                         ; Port M Bit 1
PTIM_PTIM3:         equ    3                                         ; Port M Bit 3
PTIM_PTIM4:         equ    4                                         ; Port M Bit 4
PTIM_PTIM5:         equ    5                                         ; Port M Bit 5
PTIM_PTIM6:         equ    6                                         ; Port M Bit 6
PTIM_PTIM7:         equ    7                                         ; Port M Bit 7
; bit position masks
mPTIM_PTIM0:        equ    %00000001
mPTIM_PTIM1:        equ    %00000010
mPTIM_PTIM3:        equ    %00001000
mPTIM_PTIM4:        equ    %00010000
mPTIM_PTIM5:        equ    %00100000
mPTIM_PTIM6:        equ    %01000000
mPTIM_PTIM7:        equ    %10000000


;*** DDRM - Port M Data Direction Register; 0x00000252 ***
DDRM:               equ    $00000252                                ;*** DDRM - Port M Data Direction Register; 0x00000252 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRM_DDRM0:         equ    0                                         ; Data Direction Port M Bit 0
DDRM_DDRM1:         equ    1                                         ; Data Direction Port M Bit 1
DDRM_DDRM3:         equ    3                                         ; Data Direction Port M Bit 3
DDRM_DDRM4:         equ    4                                         ; Data Direction Port M Bit 4
DDRM_DDRM5:         equ    5                                         ; Data Direction Port M Bit 5
DDRM_DDRM6:         equ    6                                         ; Data Direction Port M Bit 6
DDRM_DDRM7:         equ    7                                         ; Data Direction Port M Bit 7
; bit position masks
mDDRM_DDRM0:        equ    %00000001
mDDRM_DDRM1:        equ    %00000010
mDDRM_DDRM3:        equ    %00001000
mDDRM_DDRM4:        equ    %00010000
mDDRM_DDRM5:        equ    %00100000
mDDRM_DDRM6:        equ    %01000000
mDDRM_DDRM7:        equ    %10000000


;*** RDRM - Port M Reduced Drive Register; 0x00000253 ***
RDRM:               equ    $00000253                                ;*** RDRM - Port M Reduced Drive Register; 0x00000253 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RDRM_RDRM0:         equ    0                                         ; Reduced Drive Port M Bit 0
RDRM_RDRM1:         equ    1                                         ; Reduced Drive Port M Bit 1
RDRM_RDRM3:         equ    3                                         ; Reduced Drive Port M Bit 3
RDRM_RDRM4:         equ    4                                         ; Reduced Drive Port M Bit 4
RDRM_RDRM5:         equ    5                                         ; Reduced Drive Port M Bit 5
RDRM_RDRM6:         equ    6                                         ; Reduced Drive Port M Bit 6
RDRM_RDRM7:         equ    7                                         ; Reduced Drive Port M Bit 7
; bit position masks
mRDRM_RDRM0:        equ    %00000001
mRDRM_RDRM1:        equ    %00000010
mRDRM_RDRM3:        equ    %00001000
mRDRM_RDRM4:        equ    %00010000
mRDRM_RDRM5:        equ    %00100000
mRDRM_RDRM6:        equ    %01000000
mRDRM_RDRM7:        equ    %10000000


;*** PERM - Port M Pull Device Enable Register; 0x00000254 ***
PERM:               equ    $00000254                                ;*** PERM - Port M Pull Device Enable Register; 0x00000254 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PERM_PERM0:         equ    0                                         ; Pull Device Enable Port M Bit 0
PERM_PERM1:         equ    1                                         ; Pull Device Enable Port M Bit 1
PERM_PERM3:         equ    3                                         ; Pull Device Enable Port M Bit 3
PERM_PERM4:         equ    4                                         ; Pull Device Enable Port M Bit 4
PERM_PERM5:         equ    5                                         ; Pull Device Enable Port M Bit 5
PERM_PERM6:         equ    6                                         ; Pull Device Enable Port M Bit 6
PERM_PERM7:         equ    7                                         ; Pull Device Enable Port M Bit 7
; bit position masks
mPERM_PERM0:        equ    %00000001
mPERM_PERM1:        equ    %00000010
mPERM_PERM3:        equ    %00001000
mPERM_PERM4:        equ    %00010000
mPERM_PERM5:        equ    %00100000
mPERM_PERM6:        equ    %01000000
mPERM_PERM7:        equ    %10000000


;*** PPSM - Port M Polarity Select Register; 0x00000255 ***
PPSM:               equ    $00000255                                ;*** PPSM - Port M Polarity Select Register; 0x00000255 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PPSM_PPSM0:         equ    0                                         ; Pull Select Port M Bit 0
PPSM_PPSM1:         equ    1                                         ; Pull Select Port M Bit 1
PPSM_PPSM3:         equ    3                                         ; Pull Select Port M Bit 3
PPSM_PPSM4:         equ    4                                         ; Pull Select Port M Bit 4
PPSM_PPSM5:         equ    5                                         ; Pull Select Port M Bit 5
PPSM_PPSM6:         equ    6                                         ; Pull Select Port M Bit 6
PPSM_PPSM7:         equ    7                                         ; Pull Select Port M Bit 7
; bit position masks
mPPSM_PPSM0:        equ    %00000001
mPPSM_PPSM1:        equ    %00000010
mPPSM_PPSM3:        equ    %00001000
mPPSM_PPSM4:        equ    %00010000
mPPSM_PPSM5:        equ    %00100000
mPPSM_PPSM6:        equ    %01000000
mPPSM_PPSM7:        equ    %10000000


;*** WOMM - Port M Wired-Or Mode Register; 0x00000256 ***
WOMM:               equ    $00000256                                ;*** WOMM - Port M Wired-Or Mode Register; 0x00000256 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
WOMM_WOMM4:         equ    4                                         ; Wired-Or Mode Port M Bit 4
WOMM_WOMM5:         equ    5                                         ; Wired-Or Mode Port M Bit 5
WOMM_WOMM6:         equ    6                                         ; Wired-Or Mode Port M Bit 6
WOMM_WOMM7:         equ    7                                         ; Wired-Or Mode Port M Bit 7
; bit position masks
mWOMM_WOMM4:        equ    %00010000
mWOMM_WOMM5:        equ    %00100000
mWOMM_WOMM6:        equ    %01000000
mWOMM_WOMM7:        equ    %10000000


;*** PTP - Port P I/O Register; 0x00000258 ***
PTP:                equ    $00000258                                ;*** PTP - Port P I/O Register; 0x00000258 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTP_PTP0:           equ    0                                         ; Port P Bit 0
PTP_PTP1:           equ    1                                         ; Port P Bit 1
PTP_PTP2:           equ    2                                         ; Port P Bit 2
PTP_PTP3:           equ    3                                         ; Port P Bit 3
PTP_PTP4:           equ    4                                         ; Port P Bit 4
PTP_PTP5:           equ    5                                         ; Port P Bit 5
; bit position masks
mPTP_PTP0:          equ    %00000001
mPTP_PTP1:          equ    %00000010
mPTP_PTP2:          equ    %00000100
mPTP_PTP3:          equ    %00001000
mPTP_PTP4:          equ    %00010000
mPTP_PTP5:          equ    %00100000


;*** PTIP - Port P Input Register; 0x00000259 ***
PTIP:               equ    $00000259                                ;*** PTIP - Port P Input Register; 0x00000259 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTIP_PTIP0:         equ    0                                         ; Port P Bit 0
PTIP_PTIP1:         equ    1                                         ; Port P Bit 1
PTIP_PTIP2:         equ    2                                         ; Port P Bit 2
PTIP_PTIP3:         equ    3                                         ; Port P Bit 3
PTIP_PTIP4:         equ    4                                         ; Port P Bit 4
PTIP_PTIP5:         equ    5                                         ; Port P Bit 5
; bit position masks
mPTIP_PTIP0:        equ    %00000001
mPTIP_PTIP1:        equ    %00000010
mPTIP_PTIP2:        equ    %00000100
mPTIP_PTIP3:        equ    %00001000
mPTIP_PTIP4:        equ    %00010000
mPTIP_PTIP5:        equ    %00100000


;*** DDRP - Port P Data Direction Register; 0x0000025A ***
DDRP:               equ    $0000025A                                ;*** DDRP - Port P Data Direction Register; 0x0000025A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRP_DDRP0:         equ    0                                         ; Data Direction Port P Bit 0
DDRP_DDRP1:         equ    1                                         ; Data Direction Port P Bit 1
DDRP_DDRP2:         equ    2                                         ; Data Direction Port P Bit 2
DDRP_DDRP3:         equ    3                                         ; Data Direction Port P Bit 3
DDRP_DDRP4:         equ    4                                         ; Data Direction Port P Bit 4
DDRP_DDRP5:         equ    5                                         ; Data Direction Port P Bit 5
; bit position masks
mDDRP_DDRP0:        equ    %00000001
mDDRP_DDRP1:        equ    %00000010
mDDRP_DDRP2:        equ    %00000100
mDDRP_DDRP3:        equ    %00001000
mDDRP_DDRP4:        equ    %00010000
mDDRP_DDRP5:        equ    %00100000


;*** RDRP - Port P Reduced Drive Register; 0x0000025B ***
RDRP:               equ    $0000025B                                ;*** RDRP - Port P Reduced Drive Register; 0x0000025B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RDRP_RDRP0:         equ    0                                         ; Reduced Drive Port P Bit 0
RDRP_RDRP1:         equ    1                                         ; Reduced Drive Port P Bit 1
RDRP_RDRP2:         equ    2                                         ; Reduced Drive Port P Bit 2
RDRP_RDRP3:         equ    3                                         ; Reduced Drive Port P Bit 3
RDRP_RDRP4:         equ    4                                         ; Reduced Drive Port P Bit 4
RDRP_RDRP5:         equ    5                                         ; Reduced Drive Port P Bit 5
; bit position masks
mRDRP_RDRP0:        equ    %00000001
mRDRP_RDRP1:        equ    %00000010
mRDRP_RDRP2:        equ    %00000100
mRDRP_RDRP3:        equ    %00001000
mRDRP_RDRP4:        equ    %00010000
mRDRP_RDRP5:        equ    %00100000


;*** PERP - Port P Pull Device Enable Register; 0x0000025C ***
PERP:               equ    $0000025C                                ;*** PERP - Port P Pull Device Enable Register; 0x0000025C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PERP_PERP0:         equ    0                                         ; Pull Device Enable Port P Bit 0
PERP_PERP1:         equ    1                                         ; Pull Device Enable Port P Bit 1
PERP_PERP2:         equ    2                                         ; Pull Device Enable Port P Bit 2
PERP_PERP3:         equ    3                                         ; Pull Device Enable Port P Bit 3
PERP_PERP4:         equ    4                                         ; Pull Device Enable Port P Bit 4
PERP_PERP5:         equ    5                                         ; Pull Device Enable Port P Bit 5
; bit position masks
mPERP_PERP0:        equ    %00000001
mPERP_PERP1:        equ    %00000010
mPERP_PERP2:        equ    %00000100
mPERP_PERP3:        equ    %00001000
mPERP_PERP4:        equ    %00010000
mPERP_PERP5:        equ    %00100000


;*** PPSP - Port P Polarity Select Register; 0x0000025D ***
PPSP:               equ    $0000025D                                ;*** PPSP - Port P Polarity Select Register; 0x0000025D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PPSP_PPSP0:         equ    0                                         ; Pull Select Port P Bit 0
PPSP_PPSP1:         equ    1                                         ; Pull Select Port P Bit 1
PPSP_PPSP2:         equ    2                                         ; Pull Select Port P Bit 2
PPSP_PPSP3:         equ    3                                         ; Pull Select Port P Bit 3
PPSP_PPSP4:         equ    4                                         ; Pull Select Port P Bit 4
PPSP_PPSP5:         equ    5                                         ; Pull Select Port P Bit 5
; bit position masks
mPPSP_PPSP0:        equ    %00000001
mPPSP_PPSP1:        equ    %00000010
mPPSP_PPSP2:        equ    %00000100
mPPSP_PPSP3:        equ    %00001000
mPPSP_PPSP4:        equ    %00010000
mPPSP_PPSP5:        equ    %00100000


;*** PTQ - Port Q I/O Register; 0x00000260 ***
PTQ:                equ    $00000260                                ;*** PTQ - Port Q I/O Register; 0x00000260 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTQ_PTQ0:           equ    0                                         ; Port Q Bit 0
PTQ_PTQ1:           equ    1                                         ; Port Q Bit 1
PTQ_PTQ2:           equ    2                                         ; Port Q Bit 2
PTQ_PTQ3:           equ    3                                         ; Port Q Bit 3
PTQ_PTQ4:           equ    4                                         ; Port Q Bit 4
PTQ_PTQ5:           equ    5                                         ; Port Q Bit 5
PTQ_PTQ6:           equ    6                                         ; Port Q Bit 6
; bit position masks
mPTQ_PTQ0:          equ    %00000001
mPTQ_PTQ1:          equ    %00000010
mPTQ_PTQ2:          equ    %00000100
mPTQ_PTQ3:          equ    %00001000
mPTQ_PTQ4:          equ    %00010000
mPTQ_PTQ5:          equ    %00100000
mPTQ_PTQ6:          equ    %01000000


;*** PTIQ - Port Q Input Register; 0x00000261 ***
PTIQ:               equ    $00000261                                ;*** PTIQ - Port Q Input Register; 0x00000261 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTIQ_PTIQ0:         equ    0                                         ; Port Q Bit 0
PTIQ_PTIQ1:         equ    1                                         ; Port Q Bit 1
PTIQ_PTIQ2:         equ    2                                         ; Port Q Bit 2
PTIQ_PTIQ3:         equ    3                                         ; Port Q Bit 3
PTIQ_PTIQ4:         equ    4                                         ; Port Q Bit 4
PTIQ_PTIQ5:         equ    5                                         ; Port Q Bit 5
PTIQ_PTIQ6:         equ    6                                         ; Port Q Bit 6
; bit position masks
mPTIQ_PTIQ0:        equ    %00000001
mPTIQ_PTIQ1:        equ    %00000010
mPTIQ_PTIQ2:        equ    %00000100
mPTIQ_PTIQ3:        equ    %00001000
mPTIQ_PTIQ4:        equ    %00010000
mPTIQ_PTIQ5:        equ    %00100000
mPTIQ_PTIQ6:        equ    %01000000


;*** DDRQ - Port Q Data Direction Register; 0x00000262 ***
DDRQ:               equ    $00000262                                ;*** DDRQ - Port Q Data Direction Register; 0x00000262 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRQ_DDRQ0:         equ    0                                         ; Data Direction Port Q Bit 0
DDRQ_DDRQ1:         equ    1                                         ; Data Direction Port Q Bit 1
DDRQ_DDRQ2:         equ    2                                         ; Data Direction Port Q Bit 2
DDRQ_DDRQ3:         equ    3                                         ; Data Direction Port Q Bit 3
DDRQ_DDRQ4:         equ    4                                         ; Data Direction Port Q Bit 4
DDRQ_DDRQ5:         equ    5                                         ; Data Direction Port Q Bit 5
DDRQ_DDRQ6:         equ    6                                         ; Data Direction Port Q Bit 6
; bit position masks
mDDRQ_DDRQ0:        equ    %00000001
mDDRQ_DDRQ1:        equ    %00000010
mDDRQ_DDRQ2:        equ    %00000100
mDDRQ_DDRQ3:        equ    %00001000
mDDRQ_DDRQ4:        equ    %00010000
mDDRQ_DDRQ5:        equ    %00100000
mDDRQ_DDRQ6:        equ    %01000000


;*** RDRQ - Port Q Reduced Drive Register; 0x00000263 ***
RDRQ:               equ    $00000263                                ;*** RDRQ - Port Q Reduced Drive Register; 0x00000263 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RDRQ_RDRQ0:         equ    0                                         ; Reduced Drive Port Q Bit 0
RDRQ_RDRQ1:         equ    1                                         ; Reduced Drive Port Q Bit 1
RDRQ_RDRQ2:         equ    2                                         ; Reduced Drive Port Q Bit 2
RDRQ_RDRQ3:         equ    3                                         ; Reduced Drive Port Q Bit 3
RDRQ_RDRQ4:         equ    4                                         ; Reduced Drive Port Q Bit 4
RDRQ_RDRQ5:         equ    5                                         ; Reduced Drive Port Q Bit 5
RDRQ_RDRQ6:         equ    6                                         ; Reduced Drive Port Q Bit 6
; bit position masks
mRDRQ_RDRQ0:        equ    %00000001
mRDRQ_RDRQ1:        equ    %00000010
mRDRQ_RDRQ2:        equ    %00000100
mRDRQ_RDRQ3:        equ    %00001000
mRDRQ_RDRQ4:        equ    %00010000
mRDRQ_RDRQ5:        equ    %00100000
mRDRQ_RDRQ6:        equ    %01000000


;*** PERQ - Port Q Pull Device Enable Register; 0x00000264 ***
PERQ:               equ    $00000264                                ;*** PERQ - Port Q Pull Device Enable Register; 0x00000264 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PERQ_PERQ0:         equ    0                                         ; Pull Device Enable Port Q Bit 0
PERQ_PERQ1:         equ    1                                         ; Pull Device Enable Port Q Bit 1
PERQ_PERQ2:         equ    2                                         ; Pull Device Enable Port Q Bit 2
PERQ_PERQ3:         equ    3                                         ; Pull Device Enable Port Q Bit 3
PERQ_PERQ4:         equ    4                                         ; Pull Device Enable Port Q Bit 4
PERQ_PERQ5:         equ    5                                         ; Pull Device Enable Port Q Bit 5
PERQ_PERQ6:         equ    6                                         ; Pull Device Enable Port Q Bit 6
; bit position masks
mPERQ_PERQ0:        equ    %00000001
mPERQ_PERQ1:        equ    %00000010
mPERQ_PERQ2:        equ    %00000100
mPERQ_PERQ3:        equ    %00001000
mPERQ_PERQ4:        equ    %00010000
mPERQ_PERQ5:        equ    %00100000
mPERQ_PERQ6:        equ    %01000000


;*** PPSQ - Port Q Polarity Select Register; 0x00000265 ***
PPSQ:               equ    $00000265                                ;*** PPSQ - Port Q Polarity Select Register; 0x00000265 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PPSQ_PPSQ0:         equ    0                                         ; Pull Select Port Q Bit 0
PPSQ_PPSQ1:         equ    1                                         ; Pull Select Port Q Bit 1
PPSQ_PPSQ2:         equ    2                                         ; Pull Select Port Q Bit 2
PPSQ_PPSQ3:         equ    3                                         ; Pull Select Port Q Bit 3
PPSQ_PPSQ4:         equ    4                                         ; Pull Select Port Q Bit 4
PPSQ_PPSQ5:         equ    5                                         ; Pull Select Port Q Bit 5
PPSQ_PPSQ6:         equ    6                                         ; Pull Select Port Q Bit 6
; bit position masks
mPPSQ_PPSQ0:        equ    %00000001
mPPSQ_PPSQ1:        equ    %00000010
mPPSQ_PPSQ2:        equ    %00000100
mPPSQ_PPSQ3:        equ    %00001000
mPPSQ_PPSQ4:        equ    %00010000
mPPSQ_PPSQ5:        equ    %00100000
mPPSQ_PPSQ6:        equ    %01000000


;*** PTU - Port U I/O Register; 0x00000268 ***
PTU:                equ    $00000268                                ;*** PTU - Port U I/O Register; 0x00000268 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTU_PTU0:           equ    0                                         ; Port U Bit 0
PTU_PTU1:           equ    1                                         ; Port U Bit 1
PTU_PTU2:           equ    2                                         ; Port U Bit 2
PTU_PTU3:           equ    3                                         ; Port U Bit 3
PTU_PTU4:           equ    4                                         ; Port U Bit 4
PTU_PTU5:           equ    5                                         ; Port U Bit 5
PTU_PTU6:           equ    6                                         ; Port U Bit 6
PTU_PTU7:           equ    7                                         ; Port U Bit 7
; bit position masks
mPTU_PTU0:          equ    %00000001
mPTU_PTU1:          equ    %00000010
mPTU_PTU2:          equ    %00000100
mPTU_PTU3:          equ    %00001000
mPTU_PTU4:          equ    %00010000
mPTU_PTU5:          equ    %00100000
mPTU_PTU6:          equ    %01000000
mPTU_PTU7:          equ    %10000000


;*** PTIU - Port U Input Register; 0x00000269 ***
PTIU:               equ    $00000269                                ;*** PTIU - Port U Input Register; 0x00000269 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTIU_PTIU0:         equ    0                                         ; Port U Bit 0
PTIU_PTIU1:         equ    1                                         ; Port U Bit 1
PTIU_PTIU2:         equ    2                                         ; Port U Bit 2
PTIU_PTIU3:         equ    3                                         ; Port U Bit 3
PTIU_PTIU4:         equ    4                                         ; Port U Bit 4
PTIU_PTIU5:         equ    5                                         ; Port U Bit 5
PTIU_PTIU6:         equ    6                                         ; Port U Bit 6
PTIU_PTIU7:         equ    7                                         ; Port U Bit 7
; bit position masks
mPTIU_PTIU0:        equ    %00000001
mPTIU_PTIU1:        equ    %00000010
mPTIU_PTIU2:        equ    %00000100
mPTIU_PTIU3:        equ    %00001000
mPTIU_PTIU4:        equ    %00010000
mPTIU_PTIU5:        equ    %00100000
mPTIU_PTIU6:        equ    %01000000
mPTIU_PTIU7:        equ    %10000000


;*** DDRU - Port U Data Direction Register; 0x0000026A ***
DDRU:               equ    $0000026A                                ;*** DDRU - Port U Data Direction Register; 0x0000026A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRU_DDRU0:         equ    0                                         ; Data Direction Port U Bit 0
DDRU_DDRU1:         equ    1                                         ; Data Direction Port U Bit 1
DDRU_DDRU2:         equ    2                                         ; Data Direction Port U Bit 2
DDRU_DDRU3:         equ    3                                         ; Data Direction Port U Bit 3
DDRU_DDRU4:         equ    4                                         ; Data Direction Port U Bit 4
DDRU_DDRU5:         equ    5                                         ; Data Direction Port U Bit 5
DDRU_DDRU6:         equ    6                                         ; Data Direction Port U Bit 6
DDRU_DDRU7:         equ    7                                         ; Data Direction Port U Bit 7
; bit position masks
mDDRU_DDRU0:        equ    %00000001
mDDRU_DDRU1:        equ    %00000010
mDDRU_DDRU2:        equ    %00000100
mDDRU_DDRU3:        equ    %00001000
mDDRU_DDRU4:        equ    %00010000
mDDRU_DDRU5:        equ    %00100000
mDDRU_DDRU6:        equ    %01000000
mDDRU_DDRU7:        equ    %10000000


;*** RDRU - Port U Reduced Drive Register; 0x0000026B ***
RDRU:               equ    $0000026B                                ;*** RDRU - Port U Reduced Drive Register; 0x0000026B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RDRU_RDRU0:         equ    0                                         ; Reduced Drive Port U Bit 0
RDRU_RDRU1:         equ    1                                         ; Reduced Drive Port U Bit 1
RDRU_RDRU2:         equ    2                                         ; Reduced Drive Port U Bit 2
RDRU_RDRU3:         equ    3                                         ; Reduced Drive Port U Bit 3
RDRU_RDRU4:         equ    4                                         ; Reduced Drive Port U Bit 4
RDRU_RDRU5:         equ    5                                         ; Reduced Drive Port U Bit 5
RDRU_RDRU6:         equ    6                                         ; Reduced Drive Port U Bit 6
RDRU_RDRU7:         equ    7                                         ; Reduced Drive Port U Bit 7
; bit position masks
mRDRU_RDRU0:        equ    %00000001
mRDRU_RDRU1:        equ    %00000010
mRDRU_RDRU2:        equ    %00000100
mRDRU_RDRU3:        equ    %00001000
mRDRU_RDRU4:        equ    %00010000
mRDRU_RDRU5:        equ    %00100000
mRDRU_RDRU6:        equ    %01000000
mRDRU_RDRU7:        equ    %10000000


;*** PERU - Port U Pull Device Enable Register; 0x0000026C ***
PERU:               equ    $0000026C                                ;*** PERU - Port U Pull Device Enable Register; 0x0000026C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PERU_PERU0:         equ    0                                         ; Pull Device Enable Port U Bit 0
PERU_PERU1:         equ    1                                         ; Pull Device Enable Port U Bit 1
PERU_PERU2:         equ    2                                         ; Pull Device Enable Port U Bit 2
PERU_PERU3:         equ    3                                         ; Pull Device Enable Port U Bit 3
PERU_PERU4:         equ    4                                         ; Pull Device Enable Port U Bit 4
PERU_PERU5:         equ    5                                         ; Pull Device Enable Port U Bit 5
PERU_PERU6:         equ    6                                         ; Pull Device Enable Port U Bit 6
PERU_PERU7:         equ    7                                         ; Pull Device Enable Port U Bit 7
; bit position masks
mPERU_PERU0:        equ    %00000001
mPERU_PERU1:        equ    %00000010
mPERU_PERU2:        equ    %00000100
mPERU_PERU3:        equ    %00001000
mPERU_PERU4:        equ    %00010000
mPERU_PERU5:        equ    %00100000
mPERU_PERU6:        equ    %01000000
mPERU_PERU7:        equ    %10000000


;*** PPSU - Port U Polarity Select Register; 0x0000026D ***
PPSU:               equ    $0000026D                                ;*** PPSU - Port U Polarity Select Register; 0x0000026D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PPSU_PPSU0:         equ    0                                         ; Pull Select Port U Bit 0
PPSU_PPSU1:         equ    1                                         ; Pull Select Port U Bit 1
PPSU_PPSU2:         equ    2                                         ; Pull Select Port U Bit 2
PPSU_PPSU3:         equ    3                                         ; Pull Select Port U Bit 3
PPSU_PPSU4:         equ    4                                         ; Pull Select Port U Bit 4
PPSU_PPSU5:         equ    5                                         ; Pull Select Port U Bit 5
PPSU_PPSU6:         equ    6                                         ; Pull Select Port U Bit 6
PPSU_PPSU7:         equ    7                                         ; Pull Select Port U Bit 7
; bit position masks
mPPSU_PPSU0:        equ    %00000001
mPPSU_PPSU1:        equ    %00000010
mPPSU_PPSU2:        equ    %00000100
mPPSU_PPSU3:        equ    %00001000
mPPSU_PPSU4:        equ    %00010000
mPPSU_PPSU5:        equ    %00100000
mPPSU_PPSU6:        equ    %01000000
mPPSU_PPSU7:        equ    %10000000


;*** MODRR - Module Routing Register; 0x0000026E ***
MODRR:              equ    $0000026E                                ;*** MODRR - Module Routing Register; 0x0000026E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MODRR_MODRR0:       equ    0                                         ; Module Routing Bit 0
MODRR_MODRR1:       equ    1                                         ; Module Routing Bit 1
MODRR_MODRR2:       equ    2                                         ; Module Routing Bit 2
MODRR_MODRR3:       equ    3                                         ; Module Routing Bit 3
; bit position masks
mMODRR_MODRR0:      equ    %00000001
mMODRR_MODRR1:      equ    %00000010
mMODRR_MODRR2:      equ    %00000100
mMODRR_MODRR3:      equ    %00001000


;*** PTAD - Port AD I/O Register; 0x00000270 ***
PTAD:               equ    $00000270                                ;*** PTAD - Port AD I/O Register; 0x00000270 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTAD_PTAD0:         equ    0                                         ; Port AD Bit 0
PTAD_PTAD1:         equ    1                                         ; Port AD Bit 1
PTAD_PTAD2:         equ    2                                         ; Port AD Bit 2
PTAD_PTAD3:         equ    3                                         ; Port AD Bit 3
PTAD_PTAD4:         equ    4                                         ; Port AD Bit 4
PTAD_PTAD5:         equ    5                                         ; Port AD Bit 5
PTAD_PTAD6:         equ    6                                         ; Port AD Bit 6
PTAD_PTAD7:         equ    7                                         ; Port AD Bit 7
PTAD_PTAD8:         equ    8                                         ; Port AD Bit 8
PTAD_PTAD9:         equ    9                                         ; Port AD Bit 9
PTAD_PTAD10:        equ    10                                        ; Port AD Bit 10
PTAD_PTAD11:        equ    11                                        ; Port AD Bit 11
PTAD_PTAD12:        equ    12                                        ; Port AD Bit 12
PTAD_PTAD13:        equ    13                                        ; Port AD Bit 13
PTAD_PTAD14:        equ    14                                        ; Port AD Bit 14
PTAD_PTAD15:        equ    15                                        ; Port AD Bit 15
; bit position masks
mPTAD_PTAD0:        equ    %00000001
mPTAD_PTAD1:        equ    %00000010
mPTAD_PTAD2:        equ    %00000100
mPTAD_PTAD3:        equ    %00001000
mPTAD_PTAD4:        equ    %00010000
mPTAD_PTAD5:        equ    %00100000
mPTAD_PTAD6:        equ    %01000000
mPTAD_PTAD7:        equ    %10000000
mPTAD_PTAD8:        equ    %100000000
mPTAD_PTAD9:        equ    %1000000000
mPTAD_PTAD10:       equ    %10000000000
mPTAD_PTAD11:       equ    %100000000000
mPTAD_PTAD12:       equ    %1000000000000
mPTAD_PTAD13:       equ    %10000000000000
mPTAD_PTAD14:       equ    %100000000000000
mPTAD_PTAD15:       equ    %1000000000000000


;*** PTADHi - Port AD I/O Register High; 0x00000270 ***
PTADHi:             equ    $00000270                                ;*** PTADHi - Port AD I/O Register High; 0x00000270 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTADHi_PTAD8:       equ    0                                         ; Port AD Bit 8
PTADHi_PTAD9:       equ    1                                         ; Port AD Bit 9
PTADHi_PTAD10:      equ    2                                         ; Port AD Bit 10
PTADHi_PTAD11:      equ    3                                         ; Port AD Bit 11
PTADHi_PTAD12:      equ    4                                         ; Port AD Bit 12
PTADHi_PTAD13:      equ    5                                         ; Port AD Bit 13
PTADHi_PTAD14:      equ    6                                         ; Port AD Bit 14
PTADHi_PTAD15:      equ    7                                         ; Port AD Bit 15
; bit position masks
mPTADHi_PTAD8:      equ    %00000001
mPTADHi_PTAD9:      equ    %00000010
mPTADHi_PTAD10:     equ    %00000100
mPTADHi_PTAD11:     equ    %00001000
mPTADHi_PTAD12:     equ    %00010000
mPTADHi_PTAD13:     equ    %00100000
mPTADHi_PTAD14:     equ    %01000000
mPTADHi_PTAD15:     equ    %10000000


;*** PTADLo - Port AD I/O Register Low; 0x00000271 ***
PTADLo:             equ    $00000271                                ;*** PTADLo - Port AD I/O Register Low; 0x00000271 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTADLo_PTAD0:       equ    0                                         ; Port AD Bit 0
PTADLo_PTAD1:       equ    1                                         ; Port AD Bit 1
PTADLo_PTAD2:       equ    2                                         ; Port AD Bit 2
PTADLo_PTAD3:       equ    3                                         ; Port AD Bit 3
PTADLo_PTAD4:       equ    4                                         ; Port AD Bit 4
PTADLo_PTAD5:       equ    5                                         ; Port AD Bit 5
PTADLo_PTAD6:       equ    6                                         ; Port AD Bit 6
PTADLo_PTAD7:       equ    7                                         ; Port AD Bit 7
; bit position masks
mPTADLo_PTAD0:      equ    %00000001
mPTADLo_PTAD1:      equ    %00000010
mPTADLo_PTAD2:      equ    %00000100
mPTADLo_PTAD3:      equ    %00001000
mPTADLo_PTAD4:      equ    %00010000
mPTADLo_PTAD5:      equ    %00100000
mPTADLo_PTAD6:      equ    %01000000
mPTADLo_PTAD7:      equ    %10000000


;*** PTIAD - Port AD Input Register; 0x00000272 ***
PTIAD:              equ    $00000272                                ;*** PTIAD - Port AD Input Register; 0x00000272 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTIAD_PTIAD0:       equ    0                                         ; Port AD Bit 0
PTIAD_PTIAD1:       equ    1                                         ; Port AD Bit 1
PTIAD_PTIAD2:       equ    2                                         ; Port AD Bit 2
PTIAD_PTIAD3:       equ    3                                         ; Port AD Bit 3
PTIAD_PTIAD4:       equ    4                                         ; Port AD Bit 4
PTIAD_PTIAD5:       equ    5                                         ; Port AD Bit 5
PTIAD_PTIAD6:       equ    6                                         ; Port AD Bit 6
PTIAD_PTIAD7:       equ    7                                         ; Port AD Bit 7
PTIAD_PTIAD8:       equ    8                                         ; Port AD Bit 8
PTIAD_PTIAD9:       equ    9                                         ; Port AD Bit 9
PTIAD_PTIAD10:      equ    10                                        ; Port AD Bit 10
PTIAD_PTIAD11:      equ    11                                        ; Port AD Bit 11
PTIAD_PTIAD12:      equ    12                                        ; Port AD Bit 12
PTIAD_PTIAD13:      equ    13                                        ; Port AD Bit 13
PTIAD_PTIAD14:      equ    14                                        ; Port AD Bit 14
PTIAD_PTIAD15:      equ    15                                        ; Port AD Bit 15
; bit position masks
mPTIAD_PTIAD0:      equ    %00000001
mPTIAD_PTIAD1:      equ    %00000010
mPTIAD_PTIAD2:      equ    %00000100
mPTIAD_PTIAD3:      equ    %00001000
mPTIAD_PTIAD4:      equ    %00010000
mPTIAD_PTIAD5:      equ    %00100000
mPTIAD_PTIAD6:      equ    %01000000
mPTIAD_PTIAD7:      equ    %10000000
mPTIAD_PTIAD8:      equ    %100000000
mPTIAD_PTIAD9:      equ    %1000000000
mPTIAD_PTIAD10:     equ    %10000000000
mPTIAD_PTIAD11:     equ    %100000000000
mPTIAD_PTIAD12:     equ    %1000000000000
mPTIAD_PTIAD13:     equ    %10000000000000
mPTIAD_PTIAD14:     equ    %100000000000000
mPTIAD_PTIAD15:     equ    %1000000000000000


;*** PTIADHi - Port AD Input Register High; 0x00000272 ***
PTIADHi:            equ    $00000272                                ;*** PTIADHi - Port AD Input Register High; 0x00000272 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTIADHi_PTIAD8:     equ    0                                         ; Port AD Bit 8
PTIADHi_PTIAD9:     equ    1                                         ; Port AD Bit 9
PTIADHi_PTIAD10:    equ    2                                         ; Port AD Bit 10
PTIADHi_PTIAD11:    equ    3                                         ; Port AD Bit 11
PTIADHi_PTIAD12:    equ    4                                         ; Port AD Bit 12
PTIADHi_PTIAD13:    equ    5                                         ; Port AD Bit 13
PTIADHi_PTIAD14:    equ    6                                         ; Port AD Bit 14
PTIADHi_PTIAD15:    equ    7                                         ; Port AD Bit 15
; bit position masks
mPTIADHi_PTIAD8:    equ    %00000001
mPTIADHi_PTIAD9:    equ    %00000010
mPTIADHi_PTIAD10:   equ    %00000100
mPTIADHi_PTIAD11:   equ    %00001000
mPTIADHi_PTIAD12:   equ    %00010000
mPTIADHi_PTIAD13:   equ    %00100000
mPTIADHi_PTIAD14:   equ    %01000000
mPTIADHi_PTIAD15:   equ    %10000000


;*** PTIADLo - Port AD Input Register Low; 0x00000273 ***
PTIADLo:            equ    $00000273                                ;*** PTIADLo - Port AD Input Register Low; 0x00000273 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTIADLo_PTIAD0:     equ    0                                         ; Port AD Bit 0
PTIADLo_PTIAD1:     equ    1                                         ; Port AD Bit 1
PTIADLo_PTIAD2:     equ    2                                         ; Port AD Bit 2
PTIADLo_PTIAD3:     equ    3                                         ; Port AD Bit 3
PTIADLo_PTIAD4:     equ    4                                         ; Port AD Bit 4
PTIADLo_PTIAD5:     equ    5                                         ; Port AD Bit 5
PTIADLo_PTIAD6:     equ    6                                         ; Port AD Bit 6
PTIADLo_PTIAD7:     equ    7                                         ; Port AD Bit 7
; bit position masks
mPTIADLo_PTIAD0:    equ    %00000001
mPTIADLo_PTIAD1:    equ    %00000010
mPTIADLo_PTIAD2:    equ    %00000100
mPTIADLo_PTIAD3:    equ    %00001000
mPTIADLo_PTIAD4:    equ    %00010000
mPTIADLo_PTIAD5:    equ    %00100000
mPTIADLo_PTIAD6:    equ    %01000000
mPTIADLo_PTIAD7:    equ    %10000000


;*** DDRAD - Port AD Data Direction Register; 0x00000274 ***
DDRAD:              equ    $00000274                                ;*** DDRAD - Port AD Data Direction Register; 0x00000274 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRAD_DDRAD0:       equ    0                                         ; Port AD Data Direction Bit 0
DDRAD_DDRAD1:       equ    1                                         ; Port AD Data Direction Bit 1
DDRAD_DDRAD2:       equ    2                                         ; Port AD Data Direction Bit 2
DDRAD_DDRAD3:       equ    3                                         ; Port AD Data Direction Bit 3
DDRAD_DDRAD4:       equ    4                                         ; Port AD Data Direction Bit 4
DDRAD_DDRAD5:       equ    5                                         ; Port AD Data Direction Bit 5
DDRAD_DDRAD6:       equ    6                                         ; Port AD Data Direction Bit 6
DDRAD_DDRAD7:       equ    7                                         ; Port AD Data Direction Bit 7
DDRAD_DDRAD8:       equ    8                                         ; Port AD Data Direction Bit 8
DDRAD_DDRAD9:       equ    9                                         ; Port AD Data Direction Bit 9
DDRAD_DDRAD10:      equ    10                                        ; Port AD Data Direction Bit 10
DDRAD_DDRAD11:      equ    11                                        ; Port AD Data Direction Bit 11
DDRAD_DDRAD12:      equ    12                                        ; Port AD Data Direction Bit 12
DDRAD_DDRAD13:      equ    13                                        ; Port AD Data Direction Bit 13
DDRAD_DDRAD14:      equ    14                                        ; Port AD Data Direction Bit 14
DDRAD_DDRAD15:      equ    15                                        ; Port AD Data Direction Bit 15
; bit position masks
mDDRAD_DDRAD0:      equ    %00000001
mDDRAD_DDRAD1:      equ    %00000010
mDDRAD_DDRAD2:      equ    %00000100
mDDRAD_DDRAD3:      equ    %00001000
mDDRAD_DDRAD4:      equ    %00010000
mDDRAD_DDRAD5:      equ    %00100000
mDDRAD_DDRAD6:      equ    %01000000
mDDRAD_DDRAD7:      equ    %10000000
mDDRAD_DDRAD8:      equ    %100000000
mDDRAD_DDRAD9:      equ    %1000000000
mDDRAD_DDRAD10:     equ    %10000000000
mDDRAD_DDRAD11:     equ    %100000000000
mDDRAD_DDRAD12:     equ    %1000000000000
mDDRAD_DDRAD13:     equ    %10000000000000
mDDRAD_DDRAD14:     equ    %100000000000000
mDDRAD_DDRAD15:     equ    %1000000000000000


;*** DDRADHi - Port AD Data Direction Register High; 0x00000274 ***
DDRADHi:            equ    $00000274                                ;*** DDRADHi - Port AD Data Direction Register High; 0x00000274 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRADHi_DDRAD8:     equ    0                                         ; Port AD Data Direction Bit 8
DDRADHi_DDRAD9:     equ    1                                         ; Port AD Data Direction Bit 9
DDRADHi_DDRAD10:    equ    2                                         ; Port AD Data Direction Bit 10
DDRADHi_DDRAD11:    equ    3                                         ; Port AD Data Direction Bit 11
DDRADHi_DDRAD12:    equ    4                                         ; Port AD Data Direction Bit 12
DDRADHi_DDRAD13:    equ    5                                         ; Port AD Data Direction Bit 13
DDRADHi_DDRAD14:    equ    6                                         ; Port AD Data Direction Bit 14
DDRADHi_DDRAD15:    equ    7                                         ; Port AD Data Direction Bit 15
; bit position masks
mDDRADHi_DDRAD8:    equ    %00000001
mDDRADHi_DDRAD9:    equ    %00000010
mDDRADHi_DDRAD10:   equ    %00000100
mDDRADHi_DDRAD11:   equ    %00001000
mDDRADHi_DDRAD12:   equ    %00010000
mDDRADHi_DDRAD13:   equ    %00100000
mDDRADHi_DDRAD14:   equ    %01000000
mDDRADHi_DDRAD15:   equ    %10000000


;*** DDRADLo - Port AD Data Direction Register Low; 0x00000275 ***
DDRADLo:            equ    $00000275                                ;*** DDRADLo - Port AD Data Direction Register Low; 0x00000275 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRADLo_DDRAD0:     equ    0                                         ; Port AD Data Direction Bit 0
DDRADLo_DDRAD1:     equ    1                                         ; Port AD Data Direction Bit 1
DDRADLo_DDRAD2:     equ    2                                         ; Port AD Data Direction Bit 2
DDRADLo_DDRAD3:     equ    3                                         ; Port AD Data Direction Bit 3
DDRADLo_DDRAD4:     equ    4                                         ; Port AD Data Direction Bit 4
DDRADLo_DDRAD5:     equ    5                                         ; Port AD Data Direction Bit 5
DDRADLo_DDRAD6:     equ    6                                         ; Port AD Data Direction Bit 6
DDRADLo_DDRAD7:     equ    7                                         ; Port AD Data Direction Bit 7
; bit position masks
mDDRADLo_DDRAD0:    equ    %00000001
mDDRADLo_DDRAD1:    equ    %00000010
mDDRADLo_DDRAD2:    equ    %00000100
mDDRADLo_DDRAD3:    equ    %00001000
mDDRADLo_DDRAD4:    equ    %00010000
mDDRADLo_DDRAD5:    equ    %00100000
mDDRADLo_DDRAD6:    equ    %01000000
mDDRADLo_DDRAD7:    equ    %10000000


;*** RDRAD - Port AD Reduced Drive Register; 0x00000276 ***
RDRAD:              equ    $00000276                                ;*** RDRAD - Port AD Reduced Drive Register; 0x00000276 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RDRAD_RDRAD0:       equ    0                                         ; Port AD Reduced Drive Bit 0
RDRAD_RDRAD1:       equ    1                                         ; Port AD Reduced Drive Bit 1
RDRAD_RDRAD2:       equ    2                                         ; Port AD Reduced Drive Bit 2
RDRAD_RDRAD3:       equ    3                                         ; Port AD Reduced Drive Bit 3
RDRAD_RDRAD4:       equ    4                                         ; Port AD Reduced Drive Bit 4
RDRAD_RDRAD5:       equ    5                                         ; Port AD Reduced Drive Bit 5
RDRAD_RDRAD6:       equ    6                                         ; Port AD Reduced Drive Bit 6
RDRAD_RDRAD7:       equ    7                                         ; Port AD Reduced Drive Bit 7
RDRAD_RDRAD8:       equ    8                                         ; Port AD Reduced Drive Bit 8
RDRAD_RDRAD9:       equ    9                                         ; Port AD Reduced Drive Bit 9
RDRAD_RDRAD10:      equ    10                                        ; Port AD Reduced Drive Bit 10
RDRAD_RDRAD11:      equ    11                                        ; Port AD Reduced Drive Bit 11
RDRAD_RDRAD12:      equ    12                                        ; Port AD Reduced Drive Bit 12
RDRAD_RDRAD13:      equ    13                                        ; Port AD Reduced Drive Bit 13
RDRAD_RDRAD14:      equ    14                                        ; Port AD Reduced Drive Bit 14
RDRAD_RDRAD15:      equ    15                                        ; Port AD Reduced Drive Bit 15
; bit position masks
mRDRAD_RDRAD0:      equ    %00000001
mRDRAD_RDRAD1:      equ    %00000010
mRDRAD_RDRAD2:      equ    %00000100
mRDRAD_RDRAD3:      equ    %00001000
mRDRAD_RDRAD4:      equ    %00010000
mRDRAD_RDRAD5:      equ    %00100000
mRDRAD_RDRAD6:      equ    %01000000
mRDRAD_RDRAD7:      equ    %10000000
mRDRAD_RDRAD8:      equ    %100000000
mRDRAD_RDRAD9:      equ    %1000000000
mRDRAD_RDRAD10:     equ    %10000000000
mRDRAD_RDRAD11:     equ    %100000000000
mRDRAD_RDRAD12:     equ    %1000000000000
mRDRAD_RDRAD13:     equ    %10000000000000
mRDRAD_RDRAD14:     equ    %100000000000000
mRDRAD_RDRAD15:     equ    %1000000000000000


;*** RDRADHi - Port AD Reduced Drive Register High; 0x00000276 ***
RDRADHi:            equ    $00000276                                ;*** RDRADHi - Port AD Reduced Drive Register High; 0x00000276 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RDRADHi_RDRAD8:     equ    0                                         ; Port AD Reduced Drive Bit 8
RDRADHi_RDRAD9:     equ    1                                         ; Port AD Reduced Drive Bit 9
RDRADHi_RDRAD10:    equ    2                                         ; Port AD Reduced Drive Bit 10
RDRADHi_RDRAD11:    equ    3                                         ; Port AD Reduced Drive Bit 11
RDRADHi_RDRAD12:    equ    4                                         ; Port AD Reduced Drive Bit 12
RDRADHi_RDRAD13:    equ    5                                         ; Port AD Reduced Drive Bit 13
RDRADHi_RDRAD14:    equ    6                                         ; Port AD Reduced Drive Bit 14
RDRADHi_RDRAD15:    equ    7                                         ; Port AD Reduced Drive Bit 15
; bit position masks
mRDRADHi_RDRAD8:    equ    %00000001
mRDRADHi_RDRAD9:    equ    %00000010
mRDRADHi_RDRAD10:   equ    %00000100
mRDRADHi_RDRAD11:   equ    %00001000
mRDRADHi_RDRAD12:   equ    %00010000
mRDRADHi_RDRAD13:   equ    %00100000
mRDRADHi_RDRAD14:   equ    %01000000
mRDRADHi_RDRAD15:   equ    %10000000


;*** RDRADLo - Port AD Reduced Drive Register Low; 0x00000277 ***
RDRADLo:            equ    $00000277                                ;*** RDRADLo - Port AD Reduced Drive Register Low; 0x00000277 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RDRADLo_RDRAD0:     equ    0                                         ; Port AD Reduced Drive Bit 0
RDRADLo_RDRAD1:     equ    1                                         ; Port AD Reduced Drive Bit 1
RDRADLo_RDRAD2:     equ    2                                         ; Port AD Reduced Drive Bit 2
RDRADLo_RDRAD3:     equ    3                                         ; Port AD Reduced Drive Bit 3
RDRADLo_RDRAD4:     equ    4                                         ; Port AD Reduced Drive Bit 4
RDRADLo_RDRAD5:     equ    5                                         ; Port AD Reduced Drive Bit 5
RDRADLo_RDRAD6:     equ    6                                         ; Port AD Reduced Drive Bit 6
RDRADLo_RDRAD7:     equ    7                                         ; Port AD Reduced Drive Bit 7
; bit position masks
mRDRADLo_RDRAD0:    equ    %00000001
mRDRADLo_RDRAD1:    equ    %00000010
mRDRADLo_RDRAD2:    equ    %00000100
mRDRADLo_RDRAD3:    equ    %00001000
mRDRADLo_RDRAD4:    equ    %00010000
mRDRADLo_RDRAD5:    equ    %00100000
mRDRADLo_RDRAD6:    equ    %01000000
mRDRADLo_RDRAD7:    equ    %10000000


;*** PERAD - Port AD Pull Device Enable Register; 0x00000278 ***
PERAD:              equ    $00000278                                ;*** PERAD - Port AD Pull Device Enable Register; 0x00000278 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PERAD_PERAD0:       equ    0                                         ; Port AD Pull Device Enable Bit 0
PERAD_PERAD1:       equ    1                                         ; Port AD Pull Device Enable Bit 1
PERAD_PERAD2:       equ    2                                         ; Port AD Pull Device Enable Bit 2
PERAD_PERAD3:       equ    3                                         ; Port AD Pull Device Enable Bit 3
PERAD_PERAD4:       equ    4                                         ; Port AD Pull Device Enable Bit 4
PERAD_PERAD5:       equ    5                                         ; Port AD Pull Device Enable Bit 5
PERAD_PERAD6:       equ    6                                         ; Port AD Pull Device Enable Bit 6
PERAD_PERAD7:       equ    7                                         ; Port AD Pull Device Enable Bit 7
PERAD_PERAD8:       equ    8                                         ; Port AD Pull Device Enable Bit 8
PERAD_PERAD9:       equ    9                                         ; Port AD Pull Device Enable Bit 9
PERAD_PERAD10:      equ    10                                        ; Port AD Pull Device Enable Bit 10
PERAD_PERAD11:      equ    11                                        ; Port AD Pull Device Enable Bit 11
PERAD_PERAD12:      equ    12                                        ; Port AD Pull Device Enable Bit 12
PERAD_PERAD13:      equ    13                                        ; Port AD Pull Device Enable Bit 13
PERAD_PERAD14:      equ    14                                        ; Port AD Pull Device Enable Bit 14
PERAD_PERAD15:      equ    15                                        ; Port AD Pull Device Enable Bit 15
; bit position masks
mPERAD_PERAD0:      equ    %00000001
mPERAD_PERAD1:      equ    %00000010
mPERAD_PERAD2:      equ    %00000100
mPERAD_PERAD3:      equ    %00001000
mPERAD_PERAD4:      equ    %00010000
mPERAD_PERAD5:      equ    %00100000
mPERAD_PERAD6:      equ    %01000000
mPERAD_PERAD7:      equ    %10000000
mPERAD_PERAD8:      equ    %100000000
mPERAD_PERAD9:      equ    %1000000000
mPERAD_PERAD10:     equ    %10000000000
mPERAD_PERAD11:     equ    %100000000000
mPERAD_PERAD12:     equ    %1000000000000
mPERAD_PERAD13:     equ    %10000000000000
mPERAD_PERAD14:     equ    %100000000000000
mPERAD_PERAD15:     equ    %1000000000000000


;*** PERADHi - Port AD Pull Device Enable Register High; 0x00000278 ***
PERADHi:            equ    $00000278                                ;*** PERADHi - Port AD Pull Device Enable Register High; 0x00000278 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PERADHi_PERAD8:     equ    0                                         ; Port AD Pull Device Enable Bit 8
PERADHi_PERAD9:     equ    1                                         ; Port AD Pull Device Enable Bit 9
PERADHi_PERAD10:    equ    2                                         ; Port AD Pull Device Enable Bit 10
PERADHi_PERAD11:    equ    3                                         ; Port AD Pull Device Enable Bit 11
PERADHi_PERAD12:    equ    4                                         ; Port AD Pull Device Enable Bit 12
PERADHi_PERAD13:    equ    5                                         ; Port AD Pull Device Enable Bit 13
PERADHi_PERAD14:    equ    6                                         ; Port AD Pull Device Enable Bit 14
PERADHi_PERAD15:    equ    7                                         ; Port AD Pull Device Enable Bit 15
; bit position masks
mPERADHi_PERAD8:    equ    %00000001
mPERADHi_PERAD9:    equ    %00000010
mPERADHi_PERAD10:   equ    %00000100
mPERADHi_PERAD11:   equ    %00001000
mPERADHi_PERAD12:   equ    %00010000
mPERADHi_PERAD13:   equ    %00100000
mPERADHi_PERAD14:   equ    %01000000
mPERADHi_PERAD15:   equ    %10000000


;*** PERADLo - Port AD Pull Device Enable Register Low; 0x00000279 ***
PERADLo:            equ    $00000279                                ;*** PERADLo - Port AD Pull Device Enable Register Low; 0x00000279 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PERADLo_PERAD0:     equ    0                                         ; Port AD Pull Device Enable Bit 0
PERADLo_PERAD1:     equ    1                                         ; Port AD Pull Device Enable Bit 1
PERADLo_PERAD2:     equ    2                                         ; Port AD Pull Device Enable Bit 2
PERADLo_PERAD3:     equ    3                                         ; Port AD Pull Device Enable Bit 3
PERADLo_PERAD4:     equ    4                                         ; Port AD Pull Device Enable Bit 4
PERADLo_PERAD5:     equ    5                                         ; Port AD Pull Device Enable Bit 5
PERADLo_PERAD6:     equ    6                                         ; Port AD Pull Device Enable Bit 6
PERADLo_PERAD7:     equ    7                                         ; Port AD Pull Device Enable Bit 7
; bit position masks
mPERADLo_PERAD0:    equ    %00000001
mPERADLo_PERAD1:    equ    %00000010
mPERADLo_PERAD2:    equ    %00000100
mPERADLo_PERAD3:    equ    %00001000
mPERADLo_PERAD4:    equ    %00010000
mPERADLo_PERAD5:    equ    %00100000
mPERADLo_PERAD6:    equ    %01000000
mPERADLo_PERAD7:    equ    %10000000


;*** PPSAD - Port AD Polarity Select Register; 0x0000027A ***
PPSAD:              equ    $0000027A                                ;*** PPSAD - Port AD Polarity Select Register; 0x0000027A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PPSAD_PPSAD0:       equ    0                                         ; Port AD Polarity Select Bit 0
PPSAD_PPSAD1:       equ    1                                         ; Port AD Polarity Select Bit 1
PPSAD_PPSAD2:       equ    2                                         ; Port AD Polarity Select Bit 2
PPSAD_PPSAD3:       equ    3                                         ; Port AD Polarity Select Bit 3
PPSAD_PPSAD4:       equ    4                                         ; Port AD Polarity Select Bit 4
PPSAD_PPSAD5:       equ    5                                         ; Port AD Polarity Select Bit 5
PPSAD_PPSAD6:       equ    6                                         ; Port AD Polarity Select Bit 6
PPSAD_PPSAD7:       equ    7                                         ; Port AD Polarity Select Bit 7
PPSAD_PPSAD8:       equ    8                                         ; Port AD Polarity Select Bit 8
PPSAD_PPSAD9:       equ    9                                         ; Port AD Polarity Select Bit 9
PPSAD_PPSAD10:      equ    10                                        ; Port AD Polarity Select Bit 10
PPSAD_PPSAD11:      equ    11                                        ; Port AD Polarity Select Bit 11
PPSAD_PPSAD12:      equ    12                                        ; Port AD Polarity Select Bit 12
PPSAD_PPSAD13:      equ    13                                        ; Port AD Polarity Select Bit 13
PPSAD_PPSAD14:      equ    14                                        ; Port AD Polarity Select Bit 14
PPSAD_PPSAD15:      equ    15                                        ; Port AD Polarity Select Bit 15
; bit position masks
mPPSAD_PPSAD0:      equ    %00000001
mPPSAD_PPSAD1:      equ    %00000010
mPPSAD_PPSAD2:      equ    %00000100
mPPSAD_PPSAD3:      equ    %00001000
mPPSAD_PPSAD4:      equ    %00010000
mPPSAD_PPSAD5:      equ    %00100000
mPPSAD_PPSAD6:      equ    %01000000
mPPSAD_PPSAD7:      equ    %10000000
mPPSAD_PPSAD8:      equ    %100000000
mPPSAD_PPSAD9:      equ    %1000000000
mPPSAD_PPSAD10:     equ    %10000000000
mPPSAD_PPSAD11:     equ    %100000000000
mPPSAD_PPSAD12:     equ    %1000000000000
mPPSAD_PPSAD13:     equ    %10000000000000
mPPSAD_PPSAD14:     equ    %100000000000000
mPPSAD_PPSAD15:     equ    %1000000000000000


;*** PPSADHi - Port AD Polarity Select Register High; 0x0000027A ***
PPSADHi:            equ    $0000027A                                ;*** PPSADHi - Port AD Polarity Select Register High; 0x0000027A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PPSADHi_PPSAD8:     equ    0                                         ; Port AD Polarity Select Bit 8
PPSADHi_PPSAD9:     equ    1                                         ; Port AD Polarity Select Bit 9
PPSADHi_PPSAD10:    equ    2                                         ; Port AD Polarity Select Bit 10
PPSADHi_PPSAD11:    equ    3                                         ; Port AD Polarity Select Bit 11
PPSADHi_PPSAD12:    equ    4                                         ; Port AD Polarity Select Bit 12
PPSADHi_PPSAD13:    equ    5                                         ; Port AD Polarity Select Bit 13
PPSADHi_PPSAD14:    equ    6                                         ; Port AD Polarity Select Bit 14
PPSADHi_PPSAD15:    equ    7                                         ; Port AD Polarity Select Bit 15
; bit position masks
mPPSADHi_PPSAD8:    equ    %00000001
mPPSADHi_PPSAD9:    equ    %00000010
mPPSADHi_PPSAD10:   equ    %00000100
mPPSADHi_PPSAD11:   equ    %00001000
mPPSADHi_PPSAD12:   equ    %00010000
mPPSADHi_PPSAD13:   equ    %00100000
mPPSADHi_PPSAD14:   equ    %01000000
mPPSADHi_PPSAD15:   equ    %10000000


;*** PPSADLo - Port AD Polarity Select Register Low; 0x0000027B ***
PPSADLo:            equ    $0000027B                                ;*** PPSADLo - Port AD Polarity Select Register Low; 0x0000027B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PPSADLo_PPSAD0:     equ    0                                         ; Port AD Polarity Select Bit 0
PPSADLo_PPSAD1:     equ    1                                         ; Port AD Polarity Select Bit 1
PPSADLo_PPSAD2:     equ    2                                         ; Port AD Polarity Select Bit 2
PPSADLo_PPSAD3:     equ    3                                         ; Port AD Polarity Select Bit 3
PPSADLo_PPSAD4:     equ    4                                         ; Port AD Polarity Select Bit 4
PPSADLo_PPSAD5:     equ    5                                         ; Port AD Polarity Select Bit 5
PPSADLo_PPSAD6:     equ    6                                         ; Port AD Polarity Select Bit 6
PPSADLo_PPSAD7:     equ    7                                         ; Port AD Polarity Select Bit 7
; bit position masks
mPPSADLo_PPSAD0:    equ    %00000001
mPPSADLo_PPSAD1:    equ    %00000010
mPPSADLo_PPSAD2:    equ    %00000100
mPPSADLo_PPSAD3:    equ    %00001000
mPPSADLo_PPSAD4:    equ    %00010000
mPPSADLo_PPSAD5:    equ    %00100000
mPPSADLo_PPSAD6:    equ    %01000000
mPPSADLo_PPSAD7:    equ    %10000000


;*** PIEAD - Port AD Interrupt Enable Register; 0x0000027C ***
PIEAD:              equ    $0000027C                                ;*** PIEAD - Port AD Interrupt Enable Register; 0x0000027C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PIEAD_PIEAD0:       equ    0                                         ; Port AD Interrupt Enable Bit 0
PIEAD_PIEAD1:       equ    1                                         ; Port AD Interrupt Enable Bit 1
PIEAD_PIEAD2:       equ    2                                         ; Port AD Interrupt Enable Bit 2
PIEAD_PIEAD3:       equ    3                                         ; Port AD Interrupt Enable Bit 3
PIEAD_PIEAD4:       equ    4                                         ; Port AD Interrupt Enable Bit 4
PIEAD_PIEAD5:       equ    5                                         ; Port AD Interrupt Enable Bit 5
PIEAD_PIEAD6:       equ    6                                         ; Port AD Interrupt Enable Bit 6
PIEAD_PIEAD7:       equ    7                                         ; Port AD Interrupt Enable Bit 7
PIEAD_PIEAD8:       equ    8                                         ; Port AD Interrupt Enable Bit 8
PIEAD_PIEAD9:       equ    9                                         ; Port AD Interrupt Enable Bit 9
PIEAD_PIEAD10:      equ    10                                        ; Port AD Interrupt Enable Bit 10
PIEAD_PIEAD11:      equ    11                                        ; Port AD Interrupt Enable Bit 11
PIEAD_PIEAD12:      equ    12                                        ; Port AD Interrupt Enable Bit 12
PIEAD_PIEAD13:      equ    13                                        ; Port AD Interrupt Enable Bit 13
PIEAD_PIEAD14:      equ    14                                        ; Port AD Interrupt Enable Bit 14
PIEAD_PIEAD15:      equ    15                                        ; Port AD Interrupt Enable Bit 15
; bit position masks
mPIEAD_PIEAD0:      equ    %00000001
mPIEAD_PIEAD1:      equ    %00000010
mPIEAD_PIEAD2:      equ    %00000100
mPIEAD_PIEAD3:      equ    %00001000
mPIEAD_PIEAD4:      equ    %00010000
mPIEAD_PIEAD5:      equ    %00100000
mPIEAD_PIEAD6:      equ    %01000000
mPIEAD_PIEAD7:      equ    %10000000
mPIEAD_PIEAD8:      equ    %100000000
mPIEAD_PIEAD9:      equ    %1000000000
mPIEAD_PIEAD10:     equ    %10000000000
mPIEAD_PIEAD11:     equ    %100000000000
mPIEAD_PIEAD12:     equ    %1000000000000
mPIEAD_PIEAD13:     equ    %10000000000000
mPIEAD_PIEAD14:     equ    %100000000000000
mPIEAD_PIEAD15:     equ    %1000000000000000


;*** PIEADHi - Port AD Interrupt Enable Register High; 0x0000027C ***
PIEADHi:            equ    $0000027C                                ;*** PIEADHi - Port AD Interrupt Enable Register High; 0x0000027C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PIEADHi_PIEAD8:     equ    0                                         ; Port AD Interrupt Enable Bit 8
PIEADHi_PIEAD9:     equ    1                                         ; Port AD Interrupt Enable Bit 9
PIEADHi_PIEAD10:    equ    2                                         ; Port AD Interrupt Enable Bit 10
PIEADHi_PIEAD11:    equ    3                                         ; Port AD Interrupt Enable Bit 11
PIEADHi_PIEAD12:    equ    4                                         ; Port AD Interrupt Enable Bit 12
PIEADHi_PIEAD13:    equ    5                                         ; Port AD Interrupt Enable Bit 13
PIEADHi_PIEAD14:    equ    6                                         ; Port AD Interrupt Enable Bit 14
PIEADHi_PIEAD15:    equ    7                                         ; Port AD Interrupt Enable Bit 15
; bit position masks
mPIEADHi_PIEAD8:    equ    %00000001
mPIEADHi_PIEAD9:    equ    %00000010
mPIEADHi_PIEAD10:   equ    %00000100
mPIEADHi_PIEAD11:   equ    %00001000
mPIEADHi_PIEAD12:   equ    %00010000
mPIEADHi_PIEAD13:   equ    %00100000
mPIEADHi_PIEAD14:   equ    %01000000
mPIEADHi_PIEAD15:   equ    %10000000


;*** PIEADLo - Port AD Interrupt Enable Register Low; 0x0000027D ***
PIEADLo:            equ    $0000027D                                ;*** PIEADLo - Port AD Interrupt Enable Register Low; 0x0000027D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PIEADLo_PIEAD0:     equ    0                                         ; Port AD Interrupt Enable Bit 0
PIEADLo_PIEAD1:     equ    1                                         ; Port AD Interrupt Enable Bit 1
PIEADLo_PIEAD2:     equ    2                                         ; Port AD Interrupt Enable Bit 2
PIEADLo_PIEAD3:     equ    3                                         ; Port AD Interrupt Enable Bit 3
PIEADLo_PIEAD4:     equ    4                                         ; Port AD Interrupt Enable Bit 4
PIEADLo_PIEAD5:     equ    5                                         ; Port AD Interrupt Enable Bit 5
PIEADLo_PIEAD6:     equ    6                                         ; Port AD Interrupt Enable Bit 6
PIEADLo_PIEAD7:     equ    7                                         ; Port AD Interrupt Enable Bit 7
; bit position masks
mPIEADLo_PIEAD0:    equ    %00000001
mPIEADLo_PIEAD1:    equ    %00000010
mPIEADLo_PIEAD2:    equ    %00000100
mPIEADLo_PIEAD3:    equ    %00001000
mPIEADLo_PIEAD4:    equ    %00010000
mPIEADLo_PIEAD5:    equ    %00100000
mPIEADLo_PIEAD6:    equ    %01000000
mPIEADLo_PIEAD7:    equ    %10000000


;*** PIFAD - Port AD Interrupt Flag Register; 0x0000027E ***
PIFAD:              equ    $0000027E                                ;*** PIFAD - Port AD Interrupt Flag Register; 0x0000027E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PIFAD_PIFAD0:       equ    0                                         ; Port AD Interrupt Flag Bit 0
PIFAD_PIFAD1:       equ    1                                         ; Port AD Interrupt Flag Bit 1
PIFAD_PIFAD2:       equ    2                                         ; Port AD Interrupt Flag Bit 2
PIFAD_PIFAD3:       equ    3                                         ; Port AD Interrupt Flag Bit 3
PIFAD_PIFAD4:       equ    4                                         ; Port AD Interrupt Flag Bit 4
PIFAD_PIFAD5:       equ    5                                         ; Port AD Interrupt Flag Bit 5
PIFAD_PIFAD6:       equ    6                                         ; Port AD Interrupt Flag Bit 6
PIFAD_PIFAD7:       equ    7                                         ; Port AD Interrupt Flag Bit 7
PIFAD_PIFAD8:       equ    8                                         ; Port AD Interrupt Flag Bit 8
PIFAD_PIFAD9:       equ    9                                         ; Port AD Interrupt Flag Bit 9
PIFAD_PIFAD10:      equ    10                                        ; Port AD Interrupt Flag Bit 10
PIFAD_PIFAD11:      equ    11                                        ; Port AD Interrupt Flag Bit 11
PIFAD_PIFAD12:      equ    12                                        ; Port AD Interrupt Flag Bit 12
PIFAD_PIFAD13:      equ    13                                        ; Port AD Interrupt Flag Bit 13
PIFAD_PIFAD14:      equ    14                                        ; Port AD Interrupt Flag Bit 14
PIFAD_PIFAD15:      equ    15                                        ; Port AD Interrupt Flag Bit 15
; bit position masks
mPIFAD_PIFAD0:      equ    %00000001
mPIFAD_PIFAD1:      equ    %00000010
mPIFAD_PIFAD2:      equ    %00000100
mPIFAD_PIFAD3:      equ    %00001000
mPIFAD_PIFAD4:      equ    %00010000
mPIFAD_PIFAD5:      equ    %00100000
mPIFAD_PIFAD6:      equ    %01000000
mPIFAD_PIFAD7:      equ    %10000000
mPIFAD_PIFAD8:      equ    %100000000
mPIFAD_PIFAD9:      equ    %1000000000
mPIFAD_PIFAD10:     equ    %10000000000
mPIFAD_PIFAD11:     equ    %100000000000
mPIFAD_PIFAD12:     equ    %1000000000000
mPIFAD_PIFAD13:     equ    %10000000000000
mPIFAD_PIFAD14:     equ    %100000000000000
mPIFAD_PIFAD15:     equ    %1000000000000000


;*** PIFADHi - Port AD Interrupt Flag Register High; 0x0000027E ***
PIFADHi:            equ    $0000027E                                ;*** PIFADHi - Port AD Interrupt Flag Register High; 0x0000027E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PIFADHi_PIFAD8:     equ    0                                         ; Port AD Interrupt Flag Bit 8
PIFADHi_PIFAD9:     equ    1                                         ; Port AD Interrupt Flag Bit 9
PIFADHi_PIFAD10:    equ    2                                         ; Port AD Interrupt Flag Bit 10
PIFADHi_PIFAD11:    equ    3                                         ; Port AD Interrupt Flag Bit 11
PIFADHi_PIFAD12:    equ    4                                         ; Port AD Interrupt Flag Bit 12
PIFADHi_PIFAD13:    equ    5                                         ; Port AD Interrupt Flag Bit 13
PIFADHi_PIFAD14:    equ    6                                         ; Port AD Interrupt Flag Bit 14
PIFADHi_PIFAD15:    equ    7                                         ; Port AD Interrupt Flag Bit 15
; bit position masks
mPIFADHi_PIFAD8:    equ    %00000001
mPIFADHi_PIFAD9:    equ    %00000010
mPIFADHi_PIFAD10:   equ    %00000100
mPIFADHi_PIFAD11:   equ    %00001000
mPIFADHi_PIFAD12:   equ    %00010000
mPIFADHi_PIFAD13:   equ    %00100000
mPIFADHi_PIFAD14:   equ    %01000000
mPIFADHi_PIFAD15:   equ    %10000000


;*** PIFADLo - Port AD Interrupt Flag Register Low; 0x0000027F ***
PIFADLo:            equ    $0000027F                                ;*** PIFADLo - Port AD Interrupt Flag Register Low; 0x0000027F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PIFADLo_PIFAD0:     equ    0                                         ; Port AD Interrupt Flag Bit 0
PIFADLo_PIFAD1:     equ    1                                         ; Port AD Interrupt Flag Bit 1
PIFADLo_PIFAD2:     equ    2                                         ; Port AD Interrupt Flag Bit 2
PIFADLo_PIFAD3:     equ    3                                         ; Port AD Interrupt Flag Bit 3
PIFADLo_PIFAD4:     equ    4                                         ; Port AD Interrupt Flag Bit 4
PIFADLo_PIFAD5:     equ    5                                         ; Port AD Interrupt Flag Bit 5
PIFADLo_PIFAD6:     equ    6                                         ; Port AD Interrupt Flag Bit 6
PIFADLo_PIFAD7:     equ    7                                         ; Port AD Interrupt Flag Bit 7
; bit position masks
mPIFADLo_PIFAD0:    equ    %00000001
mPIFADLo_PIFAD1:    equ    %00000010
mPIFADLo_PIFAD2:    equ    %00000100
mPIFADLo_PIFAD3:    equ    %00001000
mPIFADLo_PIFAD4:    equ    %00010000
mPIFADLo_PIFAD5:    equ    %00100000
mPIFADLo_PIFAD6:    equ    %01000000
mPIFADLo_PIFAD7:    equ    %10000000


;*** BAKEY0 - Backdoor Access Key 0; 0x0000FF00 ***
BAKEY0:             equ    $0000FF00                                ;*** BAKEY0 - Backdoor Access Key 0; 0x0000FF00 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
BAKEY0_KEY0:        equ    0                                         ; Backdoor Access Key bits, bit 0
BAKEY0_KEY1:        equ    1                                         ; Backdoor Access Key bits, bit 1
BAKEY0_KEY2:        equ    2                                         ; Backdoor Access Key bits, bit 2
BAKEY0_KEY3:        equ    3                                         ; Backdoor Access Key bits, bit 3
BAKEY0_KEY4:        equ    4                                         ; Backdoor Access Key bits, bit 4
BAKEY0_KEY5:        equ    5                                         ; Backdoor Access Key bits, bit 5
BAKEY0_KEY6:        equ    6                                         ; Backdoor Access Key bits, bit 6
BAKEY0_KEY7:        equ    7                                         ; Backdoor Access Key bits, bit 7
BAKEY0_KEY8:        equ    8                                         ; Backdoor Access Key bits, bit 8
BAKEY0_KEY9:        equ    9                                         ; Backdoor Access Key bits, bit 9
BAKEY0_KEY10:       equ    10                                        ; Backdoor Access Key bits, bit 10
BAKEY0_KEY11:       equ    11                                        ; Backdoor Access Key bits, bit 11
BAKEY0_KEY12:       equ    12                                        ; Backdoor Access Key bits, bit 12
BAKEY0_KEY13:       equ    13                                        ; Backdoor Access Key bits, bit 13
BAKEY0_KEY14:       equ    14                                        ; Backdoor Access Key bits, bit 14
BAKEY0_KEY15:       equ    15                                        ; Backdoor Access Key bits, bit 15
; bit position masks
mBAKEY0_KEY0:       equ    %00000001
mBAKEY0_KEY1:       equ    %00000010
mBAKEY0_KEY2:       equ    %00000100
mBAKEY0_KEY3:       equ    %00001000
mBAKEY0_KEY4:       equ    %00010000
mBAKEY0_KEY5:       equ    %00100000
mBAKEY0_KEY6:       equ    %01000000
mBAKEY0_KEY7:       equ    %10000000
mBAKEY0_KEY8:       equ    %100000000
mBAKEY0_KEY9:       equ    %1000000000
mBAKEY0_KEY10:      equ    %10000000000
mBAKEY0_KEY11:      equ    %100000000000
mBAKEY0_KEY12:      equ    %1000000000000
mBAKEY0_KEY13:      equ    %10000000000000
mBAKEY0_KEY14:      equ    %100000000000000
mBAKEY0_KEY15:      equ    %1000000000000000


;*** BAKEY1 - Backdoor Access Key 1; 0x0000FF02 ***
BAKEY1:             equ    $0000FF02                                ;*** BAKEY1 - Backdoor Access Key 1; 0x0000FF02 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
BAKEY1_KEY0:        equ    0                                         ; Backdoor Access Key bits, bit 0
BAKEY1_KEY1:        equ    1                                         ; Backdoor Access Key bits, bit 1
BAKEY1_KEY2:        equ    2                                         ; Backdoor Access Key bits, bit 2
BAKEY1_KEY3:        equ    3                                         ; Backdoor Access Key bits, bit 3
BAKEY1_KEY4:        equ    4                                         ; Backdoor Access Key bits, bit 4
BAKEY1_KEY5:        equ    5                                         ; Backdoor Access Key bits, bit 5
BAKEY1_KEY6:        equ    6                                         ; Backdoor Access Key bits, bit 6
BAKEY1_KEY7:        equ    7                                         ; Backdoor Access Key bits, bit 7
BAKEY1_KEY8:        equ    8                                         ; Backdoor Access Key bits, bit 8
BAKEY1_KEY9:        equ    9                                         ; Backdoor Access Key bits, bit 9
BAKEY1_KEY10:       equ    10                                        ; Backdoor Access Key bits, bit 10
BAKEY1_KEY11:       equ    11                                        ; Backdoor Access Key bits, bit 11
BAKEY1_KEY12:       equ    12                                        ; Backdoor Access Key bits, bit 12
BAKEY1_KEY13:       equ    13                                        ; Backdoor Access Key bits, bit 13
BAKEY1_KEY14:       equ    14                                        ; Backdoor Access Key bits, bit 14
BAKEY1_KEY15:       equ    15                                        ; Backdoor Access Key bits, bit 15
; bit position masks
mBAKEY1_KEY0:       equ    %00000001
mBAKEY1_KEY1:       equ    %00000010
mBAKEY1_KEY2:       equ    %00000100
mBAKEY1_KEY3:       equ    %00001000
mBAKEY1_KEY4:       equ    %00010000
mBAKEY1_KEY5:       equ    %00100000
mBAKEY1_KEY6:       equ    %01000000
mBAKEY1_KEY7:       equ    %10000000
mBAKEY1_KEY8:       equ    %100000000
mBAKEY1_KEY9:       equ    %1000000000
mBAKEY1_KEY10:      equ    %10000000000
mBAKEY1_KEY11:      equ    %100000000000
mBAKEY1_KEY12:      equ    %1000000000000
mBAKEY1_KEY13:      equ    %10000000000000
mBAKEY1_KEY14:      equ    %100000000000000
mBAKEY1_KEY15:      equ    %1000000000000000


;*** BAKEY2 - Backdoor Access Key 2; 0x0000FF04 ***
BAKEY2:             equ    $0000FF04                                ;*** BAKEY2 - Backdoor Access Key 2; 0x0000FF04 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
BAKEY2_KEY0:        equ    0                                         ; Backdoor Access Key bits, bit 0
BAKEY2_KEY1:        equ    1                                         ; Backdoor Access Key bits, bit 1
BAKEY2_KEY2:        equ    2                                         ; Backdoor Access Key bits, bit 2
BAKEY2_KEY3:        equ    3                                         ; Backdoor Access Key bits, bit 3
BAKEY2_KEY4:        equ    4                                         ; Backdoor Access Key bits, bit 4
BAKEY2_KEY5:        equ    5                                         ; Backdoor Access Key bits, bit 5
BAKEY2_KEY6:        equ    6                                         ; Backdoor Access Key bits, bit 6
BAKEY2_KEY7:        equ    7                                         ; Backdoor Access Key bits, bit 7
BAKEY2_KEY8:        equ    8                                         ; Backdoor Access Key bits, bit 8
BAKEY2_KEY9:        equ    9                                         ; Backdoor Access Key bits, bit 9
BAKEY2_KEY10:       equ    10                                        ; Backdoor Access Key bits, bit 10
BAKEY2_KEY11:       equ    11                                        ; Backdoor Access Key bits, bit 11
BAKEY2_KEY12:       equ    12                                        ; Backdoor Access Key bits, bit 12
BAKEY2_KEY13:       equ    13                                        ; Backdoor Access Key bits, bit 13
BAKEY2_KEY14:       equ    14                                        ; Backdoor Access Key bits, bit 14
BAKEY2_KEY15:       equ    15                                        ; Backdoor Access Key bits, bit 15
; bit position masks
mBAKEY2_KEY0:       equ    %00000001
mBAKEY2_KEY1:       equ    %00000010
mBAKEY2_KEY2:       equ    %00000100
mBAKEY2_KEY3:       equ    %00001000
mBAKEY2_KEY4:       equ    %00010000
mBAKEY2_KEY5:       equ    %00100000
mBAKEY2_KEY6:       equ    %01000000
mBAKEY2_KEY7:       equ    %10000000
mBAKEY2_KEY8:       equ    %100000000
mBAKEY2_KEY9:       equ    %1000000000
mBAKEY2_KEY10:      equ    %10000000000
mBAKEY2_KEY11:      equ    %100000000000
mBAKEY2_KEY12:      equ    %1000000000000
mBAKEY2_KEY13:      equ    %10000000000000
mBAKEY2_KEY14:      equ    %100000000000000
mBAKEY2_KEY15:      equ    %1000000000000000


;*** BAKEY3 - Backdoor Access Key 3; 0x0000FF06 ***
BAKEY3:             equ    $0000FF06                                ;*** BAKEY3 - Backdoor Access Key 3; 0x0000FF06 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
BAKEY3_KEY0:        equ    0                                         ; Backdoor Access Key bits, bit 0
BAKEY3_KEY1:        equ    1                                         ; Backdoor Access Key bits, bit 1
BAKEY3_KEY2:        equ    2                                         ; Backdoor Access Key bits, bit 2
BAKEY3_KEY3:        equ    3                                         ; Backdoor Access Key bits, bit 3
BAKEY3_KEY4:        equ    4                                         ; Backdoor Access Key bits, bit 4
BAKEY3_KEY5:        equ    5                                         ; Backdoor Access Key bits, bit 5
BAKEY3_KEY6:        equ    6                                         ; Backdoor Access Key bits, bit 6
BAKEY3_KEY7:        equ    7                                         ; Backdoor Access Key bits, bit 7
BAKEY3_KEY8:        equ    8                                         ; Backdoor Access Key bits, bit 8
BAKEY3_KEY9:        equ    9                                         ; Backdoor Access Key bits, bit 9
BAKEY3_KEY10:       equ    10                                        ; Backdoor Access Key bits, bit 10
BAKEY3_KEY11:       equ    11                                        ; Backdoor Access Key bits, bit 11
BAKEY3_KEY12:       equ    12                                        ; Backdoor Access Key bits, bit 12
BAKEY3_KEY13:       equ    13                                        ; Backdoor Access Key bits, bit 13
BAKEY3_KEY14:       equ    14                                        ; Backdoor Access Key bits, bit 14
BAKEY3_KEY15:       equ    15                                        ; Backdoor Access Key bits, bit 15
; bit position masks
mBAKEY3_KEY0:       equ    %00000001
mBAKEY3_KEY1:       equ    %00000010
mBAKEY3_KEY2:       equ    %00000100
mBAKEY3_KEY3:       equ    %00001000
mBAKEY3_KEY4:       equ    %00010000
mBAKEY3_KEY5:       equ    %00100000
mBAKEY3_KEY6:       equ    %01000000
mBAKEY3_KEY7:       equ    %10000000
mBAKEY3_KEY8:       equ    %100000000
mBAKEY3_KEY9:       equ    %1000000000
mBAKEY3_KEY10:      equ    %10000000000
mBAKEY3_KEY11:      equ    %100000000000
mBAKEY3_KEY12:      equ    %1000000000000
mBAKEY3_KEY13:      equ    %10000000000000
mBAKEY3_KEY14:      equ    %100000000000000
mBAKEY3_KEY15:      equ    %1000000000000000


;*** NVFPROT0 - Non volatile Block 0 Flash Protection Register; 0x0000FF0D ***
NVFPROT0:           equ    $0000FF0D                                ;*** NVFPROT0 - Non volatile Block 0 Flash Protection Register; 0x0000FF0D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NVFPROT0_FPLS0:     equ    0                                         ; Flash Protection Lower Address size 0
NVFPROT0_FPLS1:     equ    1                                         ; Flash Protection Lower Address size 1
NVFPROT0_FPLDIS:    equ    2                                         ; Flash Protection Lower address range disable
NVFPROT0_FPHS0:     equ    3                                         ; Flash Protection Higher address size 0
NVFPROT0_FPHS1:     equ    4                                         ; Flash Protection Higher address size 1
NVFPROT0_FPHDIS:    equ    5                                         ; Flash Protection Higher address range disable
NVFPROT0_NV6:       equ    6                                         ; Non Volatile Flag Bit
NVFPROT0_FPOPEN:    equ    7                                         ; Opens the flash block or subsections of it for program or erase
; bit position masks
mNVFPROT0_FPLS0:    equ    %00000001
mNVFPROT0_FPLS1:    equ    %00000010
mNVFPROT0_FPLDIS:   equ    %00000100
mNVFPROT0_FPHS0:    equ    %00001000
mNVFPROT0_FPHS1:    equ    %00010000
mNVFPROT0_FPHDIS:   equ    %00100000
mNVFPROT0_NV6:      equ    %01000000
mNVFPROT0_FPOPEN:   equ    %10000000


;*** NVFSEC - Non volatile Flash Security Register; 0x0000FF0F ***
NVFSEC:             equ    $0000FF0F                                ;*** NVFSEC - Non volatile Flash Security Register; 0x0000FF0F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NVFSEC_SEC0:        equ    0                                         ; Memory security bit 0
NVFSEC_SEC1:        equ    1                                         ; Memory security bit 1
NVFSEC_NV2:         equ    2                                         ; Non Volatile flag bit 2
NVFSEC_NV3:         equ    3                                         ; Non Volatile flag bit 3
NVFSEC_NV4:         equ    4                                         ; Non Volatile flag bit 4
NVFSEC_NV5:         equ    5                                         ; Non Volatile flag bit 5
NVFSEC_NV6:         equ    6                                         ; Non Volatile flag bit 6
NVFSEC_KEYEN:       equ    7                                         ; Backdoor Key Security Enable
; bit position masks
mNVFSEC_SEC0:       equ    %00000001
mNVFSEC_SEC1:       equ    %00000010
mNVFSEC_NV2:        equ    %00000100
mNVFSEC_NV3:        equ    %00001000
mNVFSEC_NV4:        equ    %00010000
mNVFSEC_NV5:        equ    %00100000
mNVFSEC_NV6:        equ    %01000000
mNVFSEC_KEYEN:      equ    %10000000



;***********************************************
;**   D E P R E C I A T E D   S Y M B O L S   **
;***********************************************
        IFNDEF  __GENERATE_APPLICATION__                            ; not supported for absolute assembler
                    XREF    This_symb_has_been_depreciated
        ENDIF
; ---------------------------------------------------------------------------
; The following symbols were removed, because they were invalid or irrelevant
; ---------------------------------------------------------------------------
;
; Follows changes from the database 2.87.489 version
VportAD                                  EQU        Vportad
;
; Follows changes from the database 2.87.501 version
        IFNDEF __GENERATE_APPLICATION__
mPMFVAL0_PMFVAL00                        EQU        This_symb_has_been_depreciated
mPMFVAL0_PMFVAL01                        EQU        This_symb_has_been_depreciated
mPMFVAL0_PMFVAL02                        EQU        This_symb_has_been_depreciated
mPMFVAL0_PMFVAL03                        EQU        This_symb_has_been_depreciated
mPMFVAL0_PMFVAL04                        EQU        This_symb_has_been_depreciated
mPMFVAL0_PMFVAL05                        EQU        This_symb_has_been_depreciated
mPMFVAL0_PMFVAL06                        EQU        This_symb_has_been_depreciated
mPMFVAL0_PMFVAL07                        EQU        This_symb_has_been_depreciated
mPMFVAL0_PMFVAL08                        EQU        This_symb_has_been_depreciated
mPMFVAL0_PMFVAL09                        EQU        This_symb_has_been_depreciated
mPMFVAL0_PMFVAL010                       EQU        This_symb_has_been_depreciated
mPMFVAL0_PMFVAL011                       EQU        This_symb_has_been_depreciated
mPMFVAL0_PMFVAL012                       EQU        This_symb_has_been_depreciated
mPMFVAL0_PMFVAL013                       EQU        This_symb_has_been_depreciated
mPMFVAL0_PMFVAL014                       EQU        This_symb_has_been_depreciated
        ENDIF

        IFNDEF __GENERATE_APPLICATION__
mPMFVAL1_PMFVAL10                        EQU        This_symb_has_been_depreciated
mPMFVAL1_PMFVAL11                        EQU        This_symb_has_been_depreciated
mPMFVAL1_PMFVAL12                        EQU        This_symb_has_been_depreciated
mPMFVAL1_PMFVAL13                        EQU        This_symb_has_been_depreciated
mPMFVAL1_PMFVAL14                        EQU        This_symb_has_been_depreciated
mPMFVAL1_PMFVAL15                        EQU        This_symb_has_been_depreciated
mPMFVAL1_PMFVAL16                        EQU        This_symb_has_been_depreciated
mPMFVAL1_PMFVAL17                        EQU        This_symb_has_been_depreciated
mPMFVAL1_PMFVAL18                        EQU        This_symb_has_been_depreciated
mPMFVAL1_PMFVAL19                        EQU        This_symb_has_been_depreciated
mPMFVAL1_PMFVAL110                       EQU        This_symb_has_been_depreciated
mPMFVAL1_PMFVAL111                       EQU        This_symb_has_been_depreciated
mPMFVAL1_PMFVAL112                       EQU        This_symb_has_been_depreciated
mPMFVAL1_PMFVAL113                       EQU        This_symb_has_been_depreciated
mPMFVAL1_PMFVAL114                       EQU        This_symb_has_been_depreciated
        ENDIF

        IFNDEF __GENERATE_APPLICATION__
mPMFVAL2_PMFVAL20                        EQU        This_symb_has_been_depreciated
mPMFVAL2_PMFVAL21                        EQU        This_symb_has_been_depreciated
mPMFVAL2_PMFVAL22                        EQU        This_symb_has_been_depreciated
mPMFVAL2_PMFVAL23                        EQU        This_symb_has_been_depreciated
mPMFVAL2_PMFVAL24                        EQU        This_symb_has_been_depreciated
mPMFVAL2_PMFVAL25                        EQU        This_symb_has_been_depreciated
mPMFVAL2_PMFVAL26                        EQU        This_symb_has_been_depreciated
mPMFVAL2_PMFVAL27                        EQU        This_symb_has_been_depreciated
mPMFVAL2_PMFVAL28                        EQU        This_symb_has_been_depreciated
mPMFVAL2_PMFVAL29                        EQU        This_symb_has_been_depreciated
mPMFVAL2_PMFVAL210                       EQU        This_symb_has_been_depreciated
mPMFVAL2_PMFVAL211                       EQU        This_symb_has_been_depreciated
mPMFVAL2_PMFVAL212                       EQU        This_symb_has_been_depreciated
mPMFVAL2_PMFVAL213                       EQU        This_symb_has_been_depreciated
mPMFVAL2_PMFVAL214                       EQU        This_symb_has_been_depreciated
        ENDIF

        IFNDEF __GENERATE_APPLICATION__
mPMFVAL3_PMFVAL30                        EQU        This_symb_has_been_depreciated
mPMFVAL3_PMFVAL31                        EQU        This_symb_has_been_depreciated
mPMFVAL3_PMFVAL32                        EQU        This_symb_has_been_depreciated
mPMFVAL3_PMFVAL33                        EQU        This_symb_has_been_depreciated
mPMFVAL3_PMFVAL34                        EQU        This_symb_has_been_depreciated
mPMFVAL3_PMFVAL35                        EQU        This_symb_has_been_depreciated
mPMFVAL3_PMFVAL36                        EQU        This_symb_has_been_depreciated
mPMFVAL3_PMFVAL37                        EQU        This_symb_has_been_depreciated
mPMFVAL3_PMFVAL38                        EQU        This_symb_has_been_depreciated
mPMFVAL3_PMFVAL39                        EQU        This_symb_has_been_depreciated
mPMFVAL3_PMFVAL310                       EQU        This_symb_has_been_depreciated
mPMFVAL3_PMFVAL311                       EQU        This_symb_has_been_depreciated
mPMFVAL3_PMFVAL312                       EQU        This_symb_has_been_depreciated
mPMFVAL3_PMFVAL313                       EQU        This_symb_has_been_depreciated
mPMFVAL3_PMFVAL314                       EQU        This_symb_has_been_depreciated
        ENDIF

        IFNDEF __GENERATE_APPLICATION__
mPMFVAL4_PMFVAL40                        EQU        This_symb_has_been_depreciated
mPMFVAL4_PMFVAL41                        EQU        This_symb_has_been_depreciated
mPMFVAL4_PMFVAL42                        EQU        This_symb_has_been_depreciated
mPMFVAL4_PMFVAL43                        EQU        This_symb_has_been_depreciated
mPMFVAL4_PMFVAL44                        EQU        This_symb_has_been_depreciated
mPMFVAL4_PMFVAL45                        EQU        This_symb_has_been_depreciated
mPMFVAL4_PMFVAL46                        EQU        This_symb_has_been_depreciated
mPMFVAL4_PMFVAL47                        EQU        This_symb_has_been_depreciated
mPMFVAL4_PMFVAL48                        EQU        This_symb_has_been_depreciated
mPMFVAL4_PMFVAL49                        EQU        This_symb_has_been_depreciated
mPMFVAL4_PMFVAL410                       EQU        This_symb_has_been_depreciated
mPMFVAL4_PMFVAL411                       EQU        This_symb_has_been_depreciated
mPMFVAL4_PMFVAL412                       EQU        This_symb_has_been_depreciated
mPMFVAL4_PMFVAL413                       EQU        This_symb_has_been_depreciated
mPMFVAL4_PMFVAL414                       EQU        This_symb_has_been_depreciated
        ENDIF

        IFNDEF __GENERATE_APPLICATION__
mPMFVAL5_PMFVAL50                        EQU        This_symb_has_been_depreciated
mPMFVAL5_PMFVAL51                        EQU        This_symb_has_been_depreciated
mPMFVAL5_PMFVAL52                        EQU        This_symb_has_been_depreciated
mPMFVAL5_PMFVAL53                        EQU        This_symb_has_been_depreciated
mPMFVAL5_PMFVAL54                        EQU        This_symb_has_been_depreciated
mPMFVAL5_PMFVAL55                        EQU        This_symb_has_been_depreciated
mPMFVAL5_PMFVAL56                        EQU        This_symb_has_been_depreciated
mPMFVAL5_PMFVAL57                        EQU        This_symb_has_been_depreciated
mPMFVAL5_PMFVAL58                        EQU        This_symb_has_been_depreciated
mPMFVAL5_PMFVAL59                        EQU        This_symb_has_been_depreciated
mPMFVAL5_PMFVAL510                       EQU        This_symb_has_been_depreciated
mPMFVAL5_PMFVAL511                       EQU        This_symb_has_been_depreciated
mPMFVAL5_PMFVAL512                       EQU        This_symb_has_been_depreciated
mPMFVAL5_PMFVAL513                       EQU        This_symb_has_been_depreciated
mPMFVAL5_PMFVAL514                       EQU        This_symb_has_been_depreciated
        ENDIF



;
; Follows changes from the database 2.87.521 version
VREGCTRL0                                EQU        VREGCTRL
VREGCTRL0_LVIF                           EQU        VREGCTRL_LVIF
mVREGCTRL0_LVIF                          EQU        mVREGCTRL_LVIF
VREGCTRL0_LVIE                           EQU        VREGCTRL_LVIE
mVREGCTRL0_LVIE                          EQU        mVREGCTRL_LVIE
VREGCTRL0_LVDS                           EQU        VREGCTRL_LVDS
mVREGCTRL0_LVDS                          EQU        mVREGCTRL_LVDS


; **** 6.8.2009 10:22:24

        IFNDEF __GENERATE_APPLICATION__
PMFCNTA_PMFCNTA0:                        equ        This_symb_has_been_depreciated
PMFCNTA_PMFCNTA1:                        equ        This_symb_has_been_depreciated
PMFCNTA_PMFCNTA2:                        equ        This_symb_has_been_depreciated
PMFCNTA_PMFCNTA3:                        equ        This_symb_has_been_depreciated
PMFCNTA_PMFCNTA4:                        equ        This_symb_has_been_depreciated
PMFCNTA_PMFCNTA5:                        equ        This_symb_has_been_depreciated
PMFCNTA_PMFCNTA6:                        equ        This_symb_has_been_depreciated
PMFCNTA_PMFCNTA7:                        equ        This_symb_has_been_depreciated
PMFCNTA_PMFCNTA8:                        equ        This_symb_has_been_depreciated
PMFCNTA_PMFCNTA9:                        equ        This_symb_has_been_depreciated
PMFCNTA_PMFCNTA10:                       equ        This_symb_has_been_depreciated
PMFCNTA_PMFCNTA11:                       equ        This_symb_has_been_depreciated
PMFCNTA_PMFCNTA12:                       equ        This_symb_has_been_depreciated
PMFCNTA_PMFCNTA13:                       equ        This_symb_has_been_depreciated
PMFCNTA_PMFCNTA14:                       equ        This_symb_has_been_depreciated
mPMFCNTA_PMFCNTA0:                       equ        This_symb_has_been_depreciated
mPMFCNTA_PMFCNTA1:                       equ        This_symb_has_been_depreciated
mPMFCNTA_PMFCNTA2:                       equ        This_symb_has_been_depreciated
mPMFCNTA_PMFCNTA3:                       equ        This_symb_has_been_depreciated
mPMFCNTA_PMFCNTA4:                       equ        This_symb_has_been_depreciated
mPMFCNTA_PMFCNTA5:                       equ        This_symb_has_been_depreciated
mPMFCNTA_PMFCNTA6:                       equ        This_symb_has_been_depreciated
mPMFCNTA_PMFCNTA7:                       equ        This_symb_has_been_depreciated
mPMFCNTA_PMFCNTA8:                       equ        This_symb_has_been_depreciated
mPMFCNTA_PMFCNTA9:                       equ        This_symb_has_been_depreciated
mPMFCNTA_PMFCNTA10:                      equ        This_symb_has_been_depreciated
mPMFCNTA_PMFCNTA11:                      equ        This_symb_has_been_depreciated
mPMFCNTA_PMFCNTA12:                      equ        This_symb_has_been_depreciated
mPMFCNTA_PMFCNTA13:                      equ        This_symb_has_been_depreciated
mPMFCNTA_PMFCNTA14:                      equ        This_symb_has_been_depreciated
PMFMODA_PMFMODA0:                        equ        This_symb_has_been_depreciated
PMFMODA_PMFMODA1:                        equ        This_symb_has_been_depreciated
PMFMODA_PMFMODA2:                        equ        This_symb_has_been_depreciated
PMFMODA_PMFMODA3:                        equ        This_symb_has_been_depreciated
PMFMODA_PMFMODA4:                        equ        This_symb_has_been_depreciated
PMFMODA_PMFMODA5:                        equ        This_symb_has_been_depreciated
PMFMODA_PMFMODA6:                        equ        This_symb_has_been_depreciated
PMFMODA_PMFMODA7:                        equ        This_symb_has_been_depreciated
PMFMODA_PMFMODA8:                        equ        This_symb_has_been_depreciated
PMFMODA_PMFMODA9:                        equ        This_symb_has_been_depreciated
PMFMODA_PMFMODA10:                       equ        This_symb_has_been_depreciated
PMFMODA_PMFMODA11:                       equ        This_symb_has_been_depreciated
PMFMODA_PMFMODA12:                       equ        This_symb_has_been_depreciated
PMFMODA_PMFMODA13:                       equ        This_symb_has_been_depreciated
PMFMODA_PMFMODA14:                       equ        This_symb_has_been_depreciated
mPMFMODA_PMFMODA0:                       equ        This_symb_has_been_depreciated
mPMFMODA_PMFMODA1:                       equ        This_symb_has_been_depreciated
mPMFMODA_PMFMODA2:                       equ        This_symb_has_been_depreciated
mPMFMODA_PMFMODA3:                       equ        This_symb_has_been_depreciated
mPMFMODA_PMFMODA4:                       equ        This_symb_has_been_depreciated
mPMFMODA_PMFMODA5:                       equ        This_symb_has_been_depreciated
mPMFMODA_PMFMODA6:                       equ        This_symb_has_been_depreciated
mPMFMODA_PMFMODA7:                       equ        This_symb_has_been_depreciated
mPMFMODA_PMFMODA8:                       equ        This_symb_has_been_depreciated
mPMFMODA_PMFMODA9:                       equ        This_symb_has_been_depreciated
mPMFMODA_PMFMODA10:                      equ        This_symb_has_been_depreciated
mPMFMODA_PMFMODA11:                      equ        This_symb_has_been_depreciated
mPMFMODA_PMFMODA12:                      equ        This_symb_has_been_depreciated
mPMFMODA_PMFMODA13:                      equ        This_symb_has_been_depreciated
mPMFMODA_PMFMODA14:                      equ        This_symb_has_been_depreciated
PMFDTMA_PMFDTMA0:                        equ        This_symb_has_been_depreciated
PMFDTMA_PMFDTMA1:                        equ        This_symb_has_been_depreciated
PMFDTMA_PMFDTMA2:                        equ        This_symb_has_been_depreciated
PMFDTMA_PMFDTMA3:                        equ        This_symb_has_been_depreciated
PMFDTMA_PMFDTMA4:                        equ        This_symb_has_been_depreciated
PMFDTMA_PMFDTMA5:                        equ        This_symb_has_been_depreciated
PMFDTMA_PMFDTMA6:                        equ        This_symb_has_been_depreciated
PMFDTMA_PMFDTMA7:                        equ        This_symb_has_been_depreciated
PMFDTMA_PMFDTMA8:                        equ        This_symb_has_been_depreciated
PMFDTMA_PMFDTMA9:                        equ        This_symb_has_been_depreciated
PMFDTMA_PMFDTMA10:                       equ        This_symb_has_been_depreciated
PMFDTMA_PMFDTMA11:                       equ        This_symb_has_been_depreciated
mPMFDTMA_PMFDTMA0:                       equ        This_symb_has_been_depreciated
mPMFDTMA_PMFDTMA1:                       equ        This_symb_has_been_depreciated
mPMFDTMA_PMFDTMA2:                       equ        This_symb_has_been_depreciated
mPMFDTMA_PMFDTMA3:                       equ        This_symb_has_been_depreciated
mPMFDTMA_PMFDTMA4:                       equ        This_symb_has_been_depreciated
mPMFDTMA_PMFDTMA5:                       equ        This_symb_has_been_depreciated
mPMFDTMA_PMFDTMA6:                       equ        This_symb_has_been_depreciated
mPMFDTMA_PMFDTMA7:                       equ        This_symb_has_been_depreciated
mPMFDTMA_PMFDTMA8:                       equ        This_symb_has_been_depreciated
mPMFDTMA_PMFDTMA9:                       equ        This_symb_has_been_depreciated
mPMFDTMA_PMFDTMA10:                      equ        This_symb_has_been_depreciated
mPMFDTMA_PMFDTMA11:                      equ        This_symb_has_been_depreciated
PMFCNTB_PMFCNTB0:                        equ        This_symb_has_been_depreciated
PMFCNTB_PMFCNTB1:                        equ        This_symb_has_been_depreciated
PMFCNTB_PMFCNTB2:                        equ        This_symb_has_been_depreciated
PMFCNTB_PMFCNTB3:                        equ        This_symb_has_been_depreciated
PMFCNTB_PMFCNTB4:                        equ        This_symb_has_been_depreciated
PMFCNTB_PMFCNTB5:                        equ        This_symb_has_been_depreciated
PMFCNTB_PMFCNTB6:                        equ        This_symb_has_been_depreciated
PMFCNTB_PMFCNTB7:                        equ        This_symb_has_been_depreciated
PMFCNTB_PMFCNTB8:                        equ        This_symb_has_been_depreciated
PMFCNTB_PMFCNTB9:                        equ        This_symb_has_been_depreciated
PMFCNTB_PMFCNTB10:                       equ        This_symb_has_been_depreciated
PMFCNTB_PMFCNTB11:                       equ        This_symb_has_been_depreciated
PMFCNTB_PMFCNTB12:                       equ        This_symb_has_been_depreciated
PMFCNTB_PMFCNTB13:                       equ        This_symb_has_been_depreciated
PMFCNTB_PMFCNTB14:                       equ        This_symb_has_been_depreciated
mPMFCNTB_PMFCNTB0:                       equ        This_symb_has_been_depreciated
mPMFCNTB_PMFCNTB1:                       equ        This_symb_has_been_depreciated
mPMFCNTB_PMFCNTB2:                       equ        This_symb_has_been_depreciated
mPMFCNTB_PMFCNTB3:                       equ        This_symb_has_been_depreciated
mPMFCNTB_PMFCNTB4:                       equ        This_symb_has_been_depreciated
mPMFCNTB_PMFCNTB5:                       equ        This_symb_has_been_depreciated
mPMFCNTB_PMFCNTB6:                       equ        This_symb_has_been_depreciated
mPMFCNTB_PMFCNTB7:                       equ        This_symb_has_been_depreciated
mPMFCNTB_PMFCNTB8:                       equ        This_symb_has_been_depreciated
mPMFCNTB_PMFCNTB9:                       equ        This_symb_has_been_depreciated
mPMFCNTB_PMFCNTB10:                      equ        This_symb_has_been_depreciated
mPMFCNTB_PMFCNTB11:                      equ        This_symb_has_been_depreciated
mPMFCNTB_PMFCNTB12:                      equ        This_symb_has_been_depreciated
mPMFCNTB_PMFCNTB13:                      equ        This_symb_has_been_depreciated
mPMFCNTB_PMFCNTB14:                      equ        This_symb_has_been_depreciated
PMFMODB_PMFMODB0:                        equ        This_symb_has_been_depreciated
PMFMODB_PMFMODB1:                        equ        This_symb_has_been_depreciated
PMFMODB_PMFMODB2:                        equ        This_symb_has_been_depreciated
PMFMODB_PMFMODB3:                        equ        This_symb_has_been_depreciated
PMFMODB_PMFMODB4:                        equ        This_symb_has_been_depreciated
PMFMODB_PMFMODB5:                        equ        This_symb_has_been_depreciated
PMFMODB_PMFMODB6:                        equ        This_symb_has_been_depreciated
PMFMODB_PMFMODB7:                        equ        This_symb_has_been_depreciated
PMFMODB_PMFMODB8:                        equ        This_symb_has_been_depreciated
PMFMODB_PMFMODB9:                        equ        This_symb_has_been_depreciated
PMFMODB_PMFMODB10:                       equ        This_symb_has_been_depreciated
PMFMODB_PMFMODB11:                       equ        This_symb_has_been_depreciated
PMFMODB_PMFMODB12:                       equ        This_symb_has_been_depreciated
PMFMODB_PMFMODB13:                       equ        This_symb_has_been_depreciated
PMFMODB_PMFMODB14:                       equ        This_symb_has_been_depreciated
mPMFMODB_PMFMODB0:                       equ        This_symb_has_been_depreciated
mPMFMODB_PMFMODB1:                       equ        This_symb_has_been_depreciated
mPMFMODB_PMFMODB2:                       equ        This_symb_has_been_depreciated
mPMFMODB_PMFMODB3:                       equ        This_symb_has_been_depreciated
mPMFMODB_PMFMODB4:                       equ        This_symb_has_been_depreciated
mPMFMODB_PMFMODB5:                       equ        This_symb_has_been_depreciated
mPMFMODB_PMFMODB6:                       equ        This_symb_has_been_depreciated
mPMFMODB_PMFMODB7:                       equ        This_symb_has_been_depreciated
mPMFMODB_PMFMODB8:                       equ        This_symb_has_been_depreciated
mPMFMODB_PMFMODB9:                       equ        This_symb_has_been_depreciated
mPMFMODB_PMFMODB10:                      equ        This_symb_has_been_depreciated
mPMFMODB_PMFMODB11:                      equ        This_symb_has_been_depreciated
mPMFMODB_PMFMODB12:                      equ        This_symb_has_been_depreciated
mPMFMODB_PMFMODB13:                      equ        This_symb_has_been_depreciated
mPMFMODB_PMFMODB14:                      equ        This_symb_has_been_depreciated
PMFDTMB_PMFDTMB0:                        equ        This_symb_has_been_depreciated
PMFDTMB_PMFDTMB1:                        equ        This_symb_has_been_depreciated
PMFDTMB_PMFDTMB2:                        equ        This_symb_has_been_depreciated
PMFDTMB_PMFDTMB3:                        equ        This_symb_has_been_depreciated
PMFDTMB_PMFDTMB4:                        equ        This_symb_has_been_depreciated
PMFDTMB_PMFDTMB5:                        equ        This_symb_has_been_depreciated
PMFDTMB_PMFDTMB6:                        equ        This_symb_has_been_depreciated
PMFDTMB_PMFDTMB7:                        equ        This_symb_has_been_depreciated
PMFDTMB_PMFDTMB8:                        equ        This_symb_has_been_depreciated
PMFDTMB_PMFDTMB9:                        equ        This_symb_has_been_depreciated
PMFDTMB_PMFDTMB10:                       equ        This_symb_has_been_depreciated
PMFDTMB_PMFDTMB11:                       equ        This_symb_has_been_depreciated
mPMFDTMB_PMFDTMB0:                       equ        This_symb_has_been_depreciated
mPMFDTMB_PMFDTMB1:                       equ        This_symb_has_been_depreciated
mPMFDTMB_PMFDTMB2:                       equ        This_symb_has_been_depreciated
mPMFDTMB_PMFDTMB3:                       equ        This_symb_has_been_depreciated
mPMFDTMB_PMFDTMB4:                       equ        This_symb_has_been_depreciated
mPMFDTMB_PMFDTMB5:                       equ        This_symb_has_been_depreciated
mPMFDTMB_PMFDTMB6:                       equ        This_symb_has_been_depreciated
mPMFDTMB_PMFDTMB7:                       equ        This_symb_has_been_depreciated
mPMFDTMB_PMFDTMB8:                       equ        This_symb_has_been_depreciated
mPMFDTMB_PMFDTMB9:                       equ        This_symb_has_been_depreciated
mPMFDTMB_PMFDTMB10:                      equ        This_symb_has_been_depreciated
mPMFDTMB_PMFDTMB11:                      equ        This_symb_has_been_depreciated
PMFCNTC_PMFCNTC0:                        equ        This_symb_has_been_depreciated
PMFCNTC_PMFCNTC1:                        equ        This_symb_has_been_depreciated
PMFCNTC_PMFCNTC2:                        equ        This_symb_has_been_depreciated
PMFCNTC_PMFCNTC3:                        equ        This_symb_has_been_depreciated
PMFCNTC_PMFCNTC4:                        equ        This_symb_has_been_depreciated
PMFCNTC_PMFCNTC5:                        equ        This_symb_has_been_depreciated
PMFCNTC_PMFCNTC6:                        equ        This_symb_has_been_depreciated
PMFCNTC_PMFCNTC7:                        equ        This_symb_has_been_depreciated
PMFCNTC_PMFCNTC8:                        equ        This_symb_has_been_depreciated
PMFCNTC_PMFCNTC9:                        equ        This_symb_has_been_depreciated
PMFCNTC_PMFCNTC10:                       equ        This_symb_has_been_depreciated
PMFCNTC_PMFCNTC11:                       equ        This_symb_has_been_depreciated
PMFCNTC_PMFCNTC12:                       equ        This_symb_has_been_depreciated
PMFCNTC_PMFCNTC13:                       equ        This_symb_has_been_depreciated
PMFCNTC_PMFCNTC14:                       equ        This_symb_has_been_depreciated
mPMFCNTC_PMFCNTC0:                       equ        This_symb_has_been_depreciated
mPMFCNTC_PMFCNTC1:                       equ        This_symb_has_been_depreciated
mPMFCNTC_PMFCNTC2:                       equ        This_symb_has_been_depreciated
mPMFCNTC_PMFCNTC3:                       equ        This_symb_has_been_depreciated
mPMFCNTC_PMFCNTC4:                       equ        This_symb_has_been_depreciated
mPMFCNTC_PMFCNTC5:                       equ        This_symb_has_been_depreciated
mPMFCNTC_PMFCNTC6:                       equ        This_symb_has_been_depreciated
mPMFCNTC_PMFCNTC7:                       equ        This_symb_has_been_depreciated
mPMFCNTC_PMFCNTC8:                       equ        This_symb_has_been_depreciated
mPMFCNTC_PMFCNTC9:                       equ        This_symb_has_been_depreciated
mPMFCNTC_PMFCNTC10:                      equ        This_symb_has_been_depreciated
mPMFCNTC_PMFCNTC11:                      equ        This_symb_has_been_depreciated
mPMFCNTC_PMFCNTC12:                      equ        This_symb_has_been_depreciated
mPMFCNTC_PMFCNTC13:                      equ        This_symb_has_been_depreciated
mPMFCNTC_PMFCNTC14:                      equ        This_symb_has_been_depreciated
PMFMODC_PMFMODC0:                        equ        This_symb_has_been_depreciated
PMFMODC_PMFMODC1:                        equ        This_symb_has_been_depreciated
PMFMODC_PMFMODC2:                        equ        This_symb_has_been_depreciated
PMFMODC_PMFMODC3:                        equ        This_symb_has_been_depreciated
PMFMODC_PMFMODC4:                        equ        This_symb_has_been_depreciated
PMFMODC_PMFMODC5:                        equ        This_symb_has_been_depreciated
PMFMODC_PMFMODC6:                        equ        This_symb_has_been_depreciated
PMFMODC_PMFMODC7:                        equ        This_symb_has_been_depreciated
PMFMODC_PMFMODC8:                        equ        This_symb_has_been_depreciated
PMFMODC_PMFMODC9:                        equ        This_symb_has_been_depreciated
PMFMODC_PMFMODC10:                       equ        This_symb_has_been_depreciated
PMFMODC_PMFMODC11:                       equ        This_symb_has_been_depreciated
PMFMODC_PMFMODC12:                       equ        This_symb_has_been_depreciated
PMFMODC_PMFMODC13:                       equ        This_symb_has_been_depreciated
PMFMODC_PMFMODC14:                       equ        This_symb_has_been_depreciated
mPMFMODC_PMFMODC0:                       equ        This_symb_has_been_depreciated
mPMFMODC_PMFMODC1:                       equ        This_symb_has_been_depreciated
mPMFMODC_PMFMODC2:                       equ        This_symb_has_been_depreciated
mPMFMODC_PMFMODC3:                       equ        This_symb_has_been_depreciated
mPMFMODC_PMFMODC4:                       equ        This_symb_has_been_depreciated
mPMFMODC_PMFMODC5:                       equ        This_symb_has_been_depreciated
mPMFMODC_PMFMODC6:                       equ        This_symb_has_been_depreciated
mPMFMODC_PMFMODC7:                       equ        This_symb_has_been_depreciated
mPMFMODC_PMFMODC8:                       equ        This_symb_has_been_depreciated
mPMFMODC_PMFMODC9:                       equ        This_symb_has_been_depreciated
mPMFMODC_PMFMODC10:                      equ        This_symb_has_been_depreciated
mPMFMODC_PMFMODC11:                      equ        This_symb_has_been_depreciated
mPMFMODC_PMFMODC12:                      equ        This_symb_has_been_depreciated
mPMFMODC_PMFMODC13:                      equ        This_symb_has_been_depreciated
mPMFMODC_PMFMODC14:                      equ        This_symb_has_been_depreciated
PMFDTMC_PMFDTMC0:                        equ        This_symb_has_been_depreciated
PMFDTMC_PMFDTMC1:                        equ        This_symb_has_been_depreciated
PMFDTMC_PMFDTMC2:                        equ        This_symb_has_been_depreciated
PMFDTMC_PMFDTMC3:                        equ        This_symb_has_been_depreciated
PMFDTMC_PMFDTMC4:                        equ        This_symb_has_been_depreciated
PMFDTMC_PMFDTMC5:                        equ        This_symb_has_been_depreciated
PMFDTMC_PMFDTMC6:                        equ        This_symb_has_been_depreciated
PMFDTMC_PMFDTMC7:                        equ        This_symb_has_been_depreciated
PMFDTMC_PMFDTMC8:                        equ        This_symb_has_been_depreciated
PMFDTMC_PMFDTMC9:                        equ        This_symb_has_been_depreciated
PMFDTMC_PMFDTMC10:                       equ        This_symb_has_been_depreciated
PMFDTMC_PMFDTMC11:                       equ        This_symb_has_been_depreciated
mPMFDTMC_PMFDTMC0:                       equ        This_symb_has_been_depreciated
mPMFDTMC_PMFDTMC1:                       equ        This_symb_has_been_depreciated
mPMFDTMC_PMFDTMC2:                       equ        This_symb_has_been_depreciated
mPMFDTMC_PMFDTMC3:                       equ        This_symb_has_been_depreciated
mPMFDTMC_PMFDTMC4:                       equ        This_symb_has_been_depreciated
mPMFDTMC_PMFDTMC5:                       equ        This_symb_has_been_depreciated
mPMFDTMC_PMFDTMC6:                       equ        This_symb_has_been_depreciated
mPMFDTMC_PMFDTMC7:                       equ        This_symb_has_been_depreciated
mPMFDTMC_PMFDTMC8:                       equ        This_symb_has_been_depreciated
mPMFDTMC_PMFDTMC9:                       equ        This_symb_has_been_depreciated
mPMFDTMC_PMFDTMC10:                      equ        This_symb_has_been_depreciated
mPMFDTMC_PMFDTMC11:                      equ        This_symb_has_been_depreciated
        ENDIF

; EOF
